# FieldLogger-FMXTraining
Code to accompany a full-day training on building mobile apps with FireMonkey. 

All of the code, slides, labs, etc. are free for reuse (see [license](https://github.com/Embarcadero/FieldLogger-FMXTraining/blob/master/LICENSE)). Please link back [here](https://github.com/Embarcadero/FieldLogger-FMXTraining/).

## Overview

* Designed as a full day training
* Help developers experienced with Delphi or C++Builder to get up to speed for mobile development with FireMonkey and be comfortable targeting iOS and Android.
* This is a workshop - we are developing apps together
* Expectations
  * Experienced with VCL & Delphi
  * Experience with database development
  * Follow along with the exercises
* Code samples are in Delphi, but it will mostly work the same in C++Builder.

## App Description

This is developed with RAD Studio / Delphi 10.3 Rio to work across Windows, macOS, iOS, and Android, but the focus is mostly on the mobile device experience. Not all features will work on desktops as they lack some of the sensors.

The App is called **Field Logger** it is designed around the workflow of being used by someone in the field to collect log information for various projects. For example, an insurance adjuster. Each log entry includes a timestamp, photo, geolocation, orientation and inclination of the device, along with user notes. All data is stored locally in an embedded InterBase database, and there is a function for exporting the data to share with others.

## External documents
These documents on Google Drive are still being updated. These links represent that latest version, but a snapshot may also be stored in this repository.
* [General Outline](https://docs.google.com/document/d/16niJk2H78lvHK0esTJyEq2kKWslC6_FJbEeu5M-psOs/edit?usp=sharing) This is a short doc that provides a general outline of the training. Mostly from the planning stage.
* [Slides](https://docs.google.com/presentation/d/1qCcynRuIjRoA1Ej9RCRg4fI9t2hMjPOzENg4vbWS_l0/edit?usp=sharing) The slides to be used during the training and shared with attendees. 
