import { type Config } from "tailwindcss";

export default {
    content: ["./src/**/*.{js,ts,jsx,tsx}"],
    theme: {
        colors: ({ colors }) => ({
            inherit: colors.inherit,
            current: colors.current,
            transparent: colors.transparent,
            black: colors.black,
            white: colors.white,
            slate: colors.slate,
            gray: colors.gray,
            zinc: colors.zinc,
            neutral: colors.neutral,
            stone: colors.stone,
            red: colors.red,
            orange: colors.orange,
            amber: colors.amber,
            yellow: colors.yellow,
            lime: colors.lime,
            green: colors.green,
            emerald: colors.emerald,
            teal: colors.teal,
            cyan: colors.cyan,
            sky: colors.sky,
            blue: colors.blue,
            indigo: colors.indigo,
            violet: colors.violet,
            purple: colors.purple,
            fuchsia: colors.fuchsia,
            pink: colors.pink,
            rose: colors.rose,
            "background-dark": "#141414",
            "background-primary": "#315045",
            background: "#1f1f1f",
            "background-light": "#333333",
            "background-token": "rgb(49, 80, 69)",
            main: "rgb(76, 184, 117)",
            "main-dark": "rgb(49, 133, 81)",
            "main-primary": "rgb(168, 241, 218)",
            "main-light": "rgb(132, 254, 179)",
            "main-text": "rgb(139, 160, 148)",
        }),
        extend: {
            gridTemplateAreas: {
                toast: ["title action", "description action"],
                info: ["left art title right", "left art buttons right", "left art info right", "left art stats right", "left art padding right", "left synopsis synopsis right", "left content content right"],
                infoMobile: ["art title", "art stats", "info info", "buttons buttons", "synopsis synopsis", "content content"],
                listEditor: ["status score progress", "start finish repeat", "notes notes notes", "advanced advanced advanced"],
            },
        },
    },
    plugins: [require("@savvywombat/tailwindcss-grid-areas")],
} satisfies Config;
