unit CashFormUnit;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.Grids, AdvObj, BaseGrid, AdvGrid, Vcl.StdCtrls,
  AdvUtil;

type
  TCashForm = class(TForm)
    CashGrid: TAdvStringGrid;
    Button1: TButton;
    Label1: TLabel;
    Edit1: TEdit;
    procedure CashGridClickCell(Sender: TObject; ARow, ACol: Integer);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure Button1Click(Sender: TObject);
    procedure FormClick(Sender: TObject);
    procedure CashGridClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
  private
    HasLoad: Boolean;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  CashForm: TCashForm;

implementation

uses
  WzUtils, MapleEffect, Global;
{$R *.dfm}

function IDToInt(ID: string): string;
begin
  var S := ID.ToInteger;
  Result := S.ToString;
end;

procedure TCashForm.Button1Click(Sender: TObject);
begin
  TItemEffect.Delete(Cash);
  ActiveControl := nil;
end;

procedure TCashForm.CashGridClick(Sender: TObject);
begin
  ActiveControl := nil;
end;

procedure TCashForm.CashGridClickCell(Sender: TObject; ARow, ACol: Integer);
begin
  var ID := CashGrid.Cells[1, ARow];
  TItemEffect.Delete(Cash);

  TItemEffect.Create(ID,Cash);

  ActiveControl := nil;
end;

procedure TCashForm.Edit1Change(Sender: TObject);
begin
 CashGrid.NarrowDown(Trim(Edit1.Text));
end;

procedure TCashForm.FormActivate(Sender: TObject);
begin
  if HasLoad then
    Exit;
  HasLoad := True;
  CashGrid.Canvas.Font.Size := 18;
  CashGrid.Canvas.TextOut(60, 0, 'Loading...');

  var Entry := GetImgEntry('Item/Cash/0501.img/');
  var RowCount := -1;

  for var Iter in Entry.Children do
  begin
    if Iter.Name = '05010044' then
      Continue;
    if Iter.Name = '05012000' then
      Continue;
    if Iter.Name = '05012001' then
      Continue;
    if Iter.Name = '05010099' then
      Continue;

    Inc(RowCount);
    CashGrid.RowCount := RowCount + 1;
    CashGrid.Cells[1, RowCount] := Iter.Name;
    if HasImgEntry('String/Cash.img/' + IDToInt(Iter.Name)) then
      CashGrid.Cells[3, RowCount] := GetImgEntry('String/Cash.img/' + IDToInt(Iter.Name)).Get('Name', '');
    if Iter.Get('info/icon') <> nil then
    begin
      var Bmp := Iter.Get2('info/icon').Canvas.DumpBmp;
      CashGrid.CreateBitmap(2, RowCount, False, haCenter, vaCenter).Assign(Bmp);
      Bmp.Free;
    end;

  end;

end;

procedure TCashForm.FormClick(Sender: TObject);
begin
  ActiveControl := nil;
end;

procedure TCashForm.FormCreate(Sender: TObject);
begin
  Left := (Screen.Width - Width) div 2;
  Top := (Screen.Height - Height) div 2;
end;

procedure TCashForm.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if Key = VK_MENU then
    Key := 0;
end;

end.

