{*****************************************************************************

  Delphi Encryption Compendium (DEC Part I)
  Version 5.2, Part I, for Delphi 7 - 2009

  Remarks:          Freeware, Copyright must be included

  Original Author:  (c) 2006 Hagen Reddmann, HaReddmann [at] T-Online [dot] de
  Modifications:    (c) 2008 Arvid Winkelsdorf, info [at] digivendo [dot] de

  Last change:      02. November 2008

 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*****************************************************************************}

{$IFDEF THash_MD2_asm}
procedure THash_MD2.DoTransform(Buffer: PLongArray);
asm
                push    ebx
                push    esi
                push    edi
                push    ebp

                lea  esi, [eax].THash_MD2.FDigest


                // copying incoming buffer into work buffer
                mov  eax, [edx]
                mov  ecx, [edx + 4]
                mov  ebx, [edx + 8]
                mov  edi, [edx + 12]
                mov  [esi + 16], eax
                mov  [esi + 16 + 4], ecx
                mov  [esi + 16 + 8], ebx
                mov  [esi + 16 + 12], edi


                // recalculating message checksum
                //  loop unrolled to 4 iterations,
                // combined with
                //  xor first 16 bytes with second 16 and move res to third
                mov   ecx, dword ptr [esi + 60]
                mov   edi, -16
                shr   ecx, 24

             @checksumloop:

                mov  edx, dword ptr [esi + edi + 16]       // digest
                mov  ebp, dword ptr [esi + edi + 16 + 16]  // source data
                mov  ebx, dword ptr [esi + edi + 16 + 48]  // checksum

                xor  ecx, ebp
                xor  edx, ebp
                and  ecx, 0ffh
                xor  eax, eax
                mov  ecx, dword ptr MD2_PiSubst[ecx*4]
                shr  ebp, 8
                xor  ecx, ebx
                mov  dword ptr [esi + edi + 16 + 32], edx
                and  ecx, 0ffh
                shr  ebx, 8
                or   eax, ecx
                shl  eax, 24

                xor  ecx, ebp
                and  ecx, 0ffh
                shr  ebp, 8
                mov  ecx, dword ptr MD2_PiSubst[ecx*4]
                xor  ecx, ebx
                and  ecx, 0ffh
                shr  ebx, 8
                or   eax, ecx
                ror  eax, 8

                xor  ecx, ebp
                and  ecx, 0ffh
                shr  ebp, 8
                mov  ecx, dword ptr MD2_PiSubst[ecx*4]
                xor  ecx, ebx
                and  ecx, 0ffh
                shr  ebx, 8
                or   eax, ecx
                ror  eax, 8

                xor  ecx, ebp
                and  ecx, 0ffh
                mov  ecx, dword ptr MD2_PiSubst[ecx*4]
                xor  ecx, ebx
                or   eax, ecx
                ror  eax, 8

                mov  dword ptr [esi + edi + 16 + 48], eax

                add  edi, 4
                jnz  @checksumloop


                // do 18 rounds of transformation
                //  internal loop unrolled

                lea  edi, MD2_PiSubst  // MD2 permutation array pointer
                xor  ecx, ecx       // T variable
                xor  ebp, ebp       // external 18 rounds loop
                mov  ebx, 0ffh      // mask constant

             @roundsloop:


                // part 1
                mov  edx, dword ptr [esi]
                mov  ecx, dword ptr [edi + ecx*4]
                xor  eax, eax
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                shl  eax, 24
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                or   eax, ecx
                ror  eax, 8
                mov  dword ptr [esi], eax

                // part 2
                mov  edx, dword ptr [esi + 4]
                mov  ecx, dword ptr [edi + ecx*4]
                xor  eax, eax
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                shl  eax, 24
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                or   eax, ecx
                ror  eax, 8
                mov  dword ptr [esi + 4], eax

                // part 3
                mov  edx, dword ptr [esi + 8]
                mov  ecx, dword ptr [edi + ecx*4]
                xor  eax, eax
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                shl  eax, 24
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                or   eax, ecx
                ror  eax, 8
                mov  dword ptr [esi + 8], eax

                // part 4
                mov  edx, dword ptr [esi + 12]
                mov  ecx, dword ptr [edi + ecx*4]
                xor  eax, eax
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                shl  eax, 24
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                or   eax, ecx
                ror  eax, 8
                mov  dword ptr [esi + 12], eax

                // part 5
                mov  edx, dword ptr [esi + 16]
                mov  ecx, dword ptr [edi + ecx*4]
                xor  eax, eax
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                shl  eax, 24
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                or   eax, ecx
                ror  eax, 8
                mov  dword ptr [esi + 16], eax

                // part 6
                mov  edx, dword ptr [esi + 20]
                mov  ecx, dword ptr [edi + ecx*4]
                xor  eax, eax
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                shl  eax, 24
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                or   eax, ecx
                ror  eax, 8
                mov  dword ptr [esi + 20], eax

                // part 7
                mov  edx, dword ptr [esi + 24]
                mov  ecx, dword ptr [edi + ecx*4]
                xor  eax, eax
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                shl  eax, 24
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                or   eax, ecx
                ror  eax, 8
                mov  dword ptr [esi + 24], eax

                // part 8
                mov  edx, dword ptr [esi + 28]
                mov  ecx, dword ptr [edi + ecx*4]
                xor  eax, eax
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                shl  eax, 24
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                or   eax, ecx
                ror  eax, 8
                mov  dword ptr [esi + 28], eax

                // part 9
                mov  edx, dword ptr [esi + 32]
                mov  ecx, dword ptr [edi + ecx*4]
                xor  eax, eax
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                shl  eax, 24
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                or   eax, ecx
                ror  eax, 8
                mov  dword ptr [esi + 32], eax

                // part 10
                mov  edx, dword ptr [esi + 36]
                mov  ecx, dword ptr [edi + ecx*4]
                xor  eax, eax
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                shl  eax, 24
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                or   eax, ecx
                ror  eax, 8
                mov  dword ptr [esi + 36], eax

                // part 11
                mov  edx, dword ptr [esi + 40]
                mov  ecx, dword ptr [edi + ecx*4]
                xor  eax, eax
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                shl  eax, 24
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                or   eax, ecx
                ror  eax, 8
                mov  dword ptr [esi + 40], eax

                // part 12
                mov  edx, dword ptr [esi + 44]
                mov  ecx, dword ptr [edi + ecx*4]
                xor  eax, eax
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                shl  eax, 24
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                shr  edx, 8
                and  ecx, ebx
                or   eax, ecx

                mov  ecx, dword ptr [edi + ecx*4]
                ror  eax, 8
                xor  ecx, edx
                or   eax, ecx
                ror  eax, 8
                mov  dword ptr [esi + 44], eax


                add  ecx, ebp
                inc  ebp
                and  ecx, ebx
                cmp  ebp, 18
                jnz  @roundsloop

                
                pop  ebp
                pop  edi
                pop  esi
                pop  ebx
end;
{$ENDIF}

{$IFDEF THash_MD4_asm}
procedure THash_MD4.DoTransform(Buffer: PLongArray);
asm
                push    ebx
                push    esi
                push    edi
                lea     edi, [eax].THash_MD4.FDigest  // let edi points to A,B ..
                mov     esi, edx                      // let esi points to Buffer
                push    ebp

                mov     eax, [edi]
                mov     ebx, [edi+4]
                push    edi
                mov     ecx, [edi+8]
                mov     edx, [edi+0Ch]
                mov     edi, ecx
                xor     edi, edx
                and     edi, ebx
                mov     ebp, [esi]
                xor     edi, edx
                add     eax, ebp
                mov     ebp, ebx
                add     eax, edi
                rol     eax, 3
                xor     ebp, ecx
                mov     edi, [esi+4]
                and     ebp, eax
                add     edx, edi
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                xor     edi, ebx
                rol     edx, 7
                and     edi, edx
                mov     ebp, [esi+8]
                xor     edi, ebx
                add     ecx, ebp
                mov     ebp, edx
                add     ecx, edi
                rol     ecx, 0Bh
                xor     ebp, eax
                mov     edi, [esi+0Ch]
                and     ebp, ecx
                add     ebx, edi
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                xor     edi, edx
                ror     ebx, 0Dh
                and     edi, ebx
                mov     ebp, [esi+10h]
                xor     edi, edx
                add     eax, ebp
                mov     ebp, ebx
                add     eax, edi
                rol     eax, 3
                xor     ebp, ecx
                mov     edi, [esi+14h]
                and     ebp, eax
                add     edx, edi
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                xor     edi, ebx
                rol     edx, 7
                and     edi, edx
                mov     ebp, [esi+18h]
                xor     edi, ebx
                add     ecx, ebp
                mov     ebp, edx
                add     ecx, edi
                rol     ecx, 0Bh
                xor     ebp, eax
                mov     edi, [esi+1Ch]
                and     ebp, ecx
                add     ebx, edi
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                xor     edi, edx
                ror     ebx, 0Dh
                and     edi, ebx
                mov     ebp, [esi+20h]
                xor     edi, edx
                add     eax, ebp
                mov     ebp, ebx
                add     eax, edi
                rol     eax, 3
                xor     ebp, ecx
                mov     edi, [esi+24h]
                and     ebp, eax
                add     edx, edi
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                xor     edi, ebx
                rol     edx, 7
                and     edi, edx
                mov     ebp, [esi+28h]
                xor     edi, ebx
                add     ecx, ebp
                mov     ebp, edx
                add     ecx, edi
                rol     ecx, 0Bh
                xor     ebp, eax
                mov     edi, [esi+2Ch]
                and     ebp, ecx
                add     ebx, edi
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                xor     edi, edx
                ror     ebx, 0Dh
                and     edi, ebx
                mov     ebp, [esi+30h]
                xor     edi, edx
                add     eax, ebp
                mov     ebp, ebx
                add     eax, edi
                rol     eax, 3
                xor     ebp, ecx
                mov     edi, [esi+34h]
                and     ebp, eax
                add     edx, edi
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                xor     edi, ebx
                rol     edx, 7
                and     edi, edx
                mov     ebp, [esi+38h]
                xor     edi, ebx
                add     ecx, ebp
                mov     ebp, edx
                add     ecx, edi
                rol     ecx, 0Bh
                xor     ebp, eax
                mov     edi, [esi+3Ch]
                and     ebp, ecx
                add     ebx, edi
                xor     ebp, eax
                mov     edi, edx
                add     ebx, ebp
                mov     ebp, edx
                ror     ebx, 0Dh
                or      edi, ecx
                and     ebp, ecx
                and     edi, ebx
                add     eax, [esi]
                or      edi, ebp
                mov     ebp, ecx
                lea     eax, [eax+edi+5A827999h]
                mov     edi, ecx
                rol     eax, 3
                or      edi, ebx
                and     ebp, ebx
                and     edi, eax
                add     edx, [esi+10h]
                or      edi, ebp
                mov     ebp, ebx
                lea     edx, [edx+edi+5A827999h]
                mov     edi, ebx
                rol     edx, 5
                or      edi, eax
                and     ebp, eax
                and     edi, edx
                add     ecx, [esi+20h]
                or      edi, ebp
                mov     ebp, eax
                lea     ecx, [ecx+edi+5A827999h]
                mov     edi, eax
                rol     ecx, 9
                or      edi, edx
                and     ebp, edx
                and     edi, ecx
                add     ebx, [esi+30h]
                or      edi, ebp
                mov     ebp, edx
                lea     ebx, [ebx+edi+5A827999h]
                mov     edi, edx
                rol     ebx, 0Dh
                or      edi, ecx
                and     ebp, ecx
                and     edi, ebx
                add     eax, [esi+4]
                or      edi, ebp
                mov     ebp, ecx
                lea     eax, [eax+edi+5A827999h]
                mov     edi, ecx
                rol     eax, 3
                or      edi, ebx
                and     ebp, ebx
                and     edi, eax
                add     edx, [esi+14h]
                or      edi, ebp
                mov     ebp, ebx
                lea     edx, [edx+edi+5A827999h]
                mov     edi, ebx
                rol     edx, 5
                or      edi, eax
                and     ebp, eax
                and     edi, edx
                add     ecx, [esi+24h]
                or      edi, ebp
                mov     ebp, eax
                lea     ecx, [ecx+edi+5A827999h]
                mov     edi, eax
                rol     ecx, 9
                or      edi, edx
                and     ebp, edx
                and     edi, ecx
                add     ebx, [esi+34h]
                or      edi, ebp
                mov     ebp, edx
                lea     ebx, [ebx+edi+5A827999h]
                mov     edi, edx
                rol     ebx, 0Dh
                or      edi, ecx
                and     ebp, ecx
                and     edi, ebx
                add     eax, [esi+8]
                or      edi, ebp
                mov     ebp, ecx
                lea     eax, [eax+edi+5A827999h]
                mov     edi, ecx
                rol     eax, 3
                or      edi, ebx
                and     ebp, ebx
                and     edi, eax
                add     edx, [esi+18h]
                or      edi, ebp
                mov     ebp, ebx
                lea     edx, [edx+edi+5A827999h]
                mov     edi, ebx
                rol     edx, 5
                or      edi, eax
                and     ebp, eax
                and     edi, edx
                add     ecx, [esi+28h]
                or      edi, ebp
                mov     ebp, eax
                lea     ecx, [ecx+edi+5A827999h]
                mov     edi, eax
                rol     ecx, 9
                or      edi, edx
                and     ebp, edx
                and     edi, ecx
                add     ebx, [esi+38h]
                or      edi, ebp
                mov     ebp, edx
                lea     ebx, [ebx+edi+5A827999h]
                mov     edi, edx
                rol     ebx, 0Dh
                or      edi, ecx
                and     ebp, ecx
                and     edi, ebx
                add     eax, [esi+0Ch]
                or      edi, ebp
                mov     ebp, ecx
                lea     eax, [eax+edi+5A827999h]
                mov     edi, ecx
                rol     eax, 3
                or      edi, ebx
                and     ebp, ebx
                and     edi, eax
                add     edx, [esi+1Ch]
                or      edi, ebp
                mov     ebp, ebx
                lea     edx, [edx+edi+5A827999h]
                mov     edi, ebx
                rol     edx, 5
                or      edi, eax
                and     ebp, eax
                and     edi, edx
                add     ecx, [esi+2Ch]
                or      edi, ebp
                mov     ebp, eax
                lea     ecx, [ecx+edi+5A827999h]
                mov     edi, eax
                rol     ecx, 9
                or      edi, edx
                and     ebp, edx
                and     edi, ecx
                add     ebx, [esi+3Ch]
                or      edi, ebp
                mov     ebp, edx
                lea     ebx, [ebx+edi+5A827999h]
                mov     edi, edx
                rol     ebx, 0Dh
                xor     edi, ecx
                mov     ebp, [esi]
                xor     edi, ebx
                add     eax, ebp
                lea     eax, [eax+edi+6ED9EBA1h]
                mov     ebp, ecx
                rol     eax, 3
                xor     ebp, ebx
                mov     edi, [esi+20h]
                xor     ebp, eax
                add     edx, edi
                lea     edx, [edx+ebp+6ED9EBA1h]
                mov     edi, ebx
                rol     edx, 9
                xor     edi, eax
                mov     ebp, [esi+10h]
                xor     edi, edx
                add     ecx, ebp
                lea     ecx, [ecx+edi+6ED9EBA1h]
                mov     ebp, eax
                rol     ecx, 0Bh
                xor     ebp, edx
                mov     edi, [esi+30h]
                xor     ebp, ecx
                add     ebx, edi
                lea     ebx, [ebx+ebp+6ED9EBA1h]
                mov     edi, edx
                rol     ebx, 0Fh
                xor     edi, ecx
                mov     ebp, [esi+8]
                xor     edi, ebx
                add     eax, ebp
                lea     eax, [eax+edi+6ED9EBA1h]
                mov     ebp, ecx
                rol     eax, 3
                xor     ebp, ebx
                mov     edi, [esi+28h]
                xor     ebp, eax
                add     edx, edi
                lea     edx, [edx+ebp+6ED9EBA1h]
                mov     edi, ebx
                rol     edx, 9
                xor     edi, eax
                mov     ebp, [esi+18h]
                xor     edi, edx
                add     ecx, ebp
                lea     ecx, [ecx+edi+6ED9EBA1h]
                mov     ebp, eax
                rol     ecx, 0Bh
                xor     ebp, edx
                mov     edi, [esi+38h]
                xor     ebp, ecx
                add     ebx, edi
                lea     ebx, [ebx+ebp+6ED9EBA1h]
                mov     edi, edx
                rol     ebx, 0Fh
                xor     edi, ecx
                mov     ebp, [esi+4]
                xor     edi, ebx
                add     eax, ebp
                lea     eax, [eax+edi+6ED9EBA1h]
                mov     ebp, ecx
                rol     eax, 3
                xor     ebp, ebx
                mov     edi, [esi+24h]
                xor     ebp, eax
                add     edx, edi
                lea     edx, [edx+ebp+6ED9EBA1h]
                mov     edi, ebx
                rol     edx, 9
                xor     edi, eax
                mov     ebp, [esi+14h]
                xor     edi, edx
                add     ecx, ebp
                lea     ecx, [ecx+edi+6ED9EBA1h]
                mov     ebp, eax
                rol     ecx, 0Bh
                xor     ebp, edx
                mov     edi, [esi+34h]
                xor     ebp, ecx
                add     ebx, edi
                lea     ebx, [ebx+ebp+6ED9EBA1h]
                mov     edi, edx
                rol     ebx, 0Fh
                xor     edi, ecx
                mov     ebp, [esi+0Ch]
                xor     edi, ebx
                add     eax, ebp
                lea     eax, [eax+edi+6ED9EBA1h]
                mov     ebp, ecx
                rol     eax, 3
                xor     ebp, ebx
                mov     edi, [esi+2Ch]
                xor     ebp, eax
                add     edx, edi
                lea     edx, [edx+ebp+6ED9EBA1h]
                mov     edi, ebx
                rol     edx, 9
                xor     edi, eax
                mov     ebp, [esi+1Ch]
                xor     edi, edx
                add     ecx, ebp
                lea     ecx, [ecx+edi+6ED9EBA1h]
                mov     ebp, eax
                rol     ecx, 0Bh
                xor     ebp, edx
                mov     edi, [esi+3Ch]
                xor     ebp, ecx
                add     ebx, edi
                lea     ebx, [ebx+ebp+6ED9EBA1h]
                rol     ebx, 0Fh
                pop     edi
                add     [edi], eax
                add     [edi+4], ebx
                add     [edi+8], ecx
                add     [edi+0Ch], edx

                pop     ebp
                pop     edi
                pop     esi
                pop     ebx

end;
{$ENDIF}

{$IFDEF THash_MD5_asm}
procedure THash_MD5.DoTransform(Buffer: PLongArray);
asm
                push    ebx
                push    esi
                push    edi
                lea     edi, [eax].THash_MD5.FDigest   // let edi points to A,B ..
                mov     esi, edx                       // let esi points to Buffer
                push    ebp
                mov     eax, [edi]
                mov     ebx, [edi+4]
                push    edi
                mov     ecx, [edi+8]
                mov     edx, [edi+0Ch]
                mov     edi, ecx
                mov     ebp, [esi]
                xor     edi, edx
                lea     eax, [eax+ebp-28955B88h]
                and     edi, ebx
                mov     ebp, [esi+4]
                xor     edi, edx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 7
                xor     edi, ecx
                add     eax, ebx
                lea     edx, [edx+ebp-173848AAh]
                and     edi, eax
                mov     ebp, [esi+8]
                xor     edi, ecx
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Ch
                xor     edi, ebx
                add     edx, eax
                lea     ecx, [ecx+ebp+242070DBh]
                and     edi, edx
                mov     ebp, [esi+0Ch]
                xor     edi, ebx
                add     ecx, edi
                mov     edi, edx
                ror     ecx, 0Fh
                xor     edi, eax
                add     ecx, edx
                lea     ebx, [ebx+ebp-3E423112h]
                and     edi, ecx
                mov     ebp, [esi+10h]
                xor     edi, eax
                add     ebx, edi
                mov     edi, ecx
                ror     ebx, 0Ah
                xor     edi, edx
                add     ebx, ecx
                lea     eax, [eax+ebp-0A83F051h]
                and     edi, ebx
                mov     ebp, [esi+14h]
                xor     edi, edx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 7
                xor     edi, ecx
                add     eax, ebx
                lea     edx, [edx+ebp+4787C62Ah]
                and     edi, eax
                mov     ebp, [esi+18h]
                xor     edi, ecx
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Ch
                xor     edi, ebx
                add     edx, eax
                lea     ecx, [ecx+ebp-57CFB9EDh]
                and     edi, edx
                mov     ebp, [esi+1Ch]
                xor     edi, ebx
                add     ecx, edi
                mov     edi, edx
                ror     ecx, 0Fh
                xor     edi, eax
                add     ecx, edx
                lea     ebx, [ebx+ebp-2B96AFFh]
                and     edi, ecx
                mov     ebp, [esi+20h]
                xor     edi, eax
                add     ebx, edi
                mov     edi, ecx
                ror     ebx, 0Ah
                xor     edi, edx
                add     ebx, ecx
                lea     eax, [eax+ebp+698098D8h]
                and     edi, ebx
                mov     ebp, [esi+24h]
                xor     edi, edx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 7
                xor     edi, ecx
                add     eax, ebx
                lea     edx, [edx+ebp-74BB0851h]
                and     edi, eax
                mov     ebp, [esi+28h]
                xor     edi, ecx
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Ch
                xor     edi, ebx
                add     edx, eax
                lea     ecx, [ecx+ebp-0A44Fh]
                and     edi, edx
                mov     ebp, [esi+2Ch]
                xor     edi, ebx
                add     ecx, edi
                mov     edi, edx
                ror     ecx, 0Fh
                xor     edi, eax
                add     ecx, edx
                lea     ebx, [ebx+ebp-76A32842h]
                and     edi, ecx
                mov     ebp, [esi+30h]
                xor     edi, eax
                add     ebx, edi
                mov     edi, ecx
                ror     ebx, 0Ah
                xor     edi, edx
                add     ebx, ecx
                lea     eax, [eax+ebp+6B901122h]
                and     edi, ebx
                mov     ebp, [esi+34h]
                xor     edi, edx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 7
                xor     edi, ecx
                add     eax, ebx
                lea     edx, [edx+ebp-2678E6Dh]
                and     edi, eax
                mov     ebp, [esi+38h]
                xor     edi, ecx
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Ch
                xor     edi, ebx
                add     edx, eax
                lea     ecx, [ecx+ebp-5986BC72h]
                and     edi, edx
                mov     ebp, [esi+3Ch]
                xor     edi, ebx
                add     ecx, edi
                mov     edi, edx
                ror     ecx, 0Fh
                xor     edi, eax
                add     ecx, edx
                lea     ebx, [ebx+ebp+49B40821h]
                and     edi, ecx
                mov     ebp, [esi+4]
                xor     edi, eax
                add     ebx, edi
                mov     edi, ecx
                ror     ebx, 0Ah
                xor     edi, edx
                add     ebx, ecx
                mov     edi, ecx
                xor     edi, ebx
                lea     eax, [eax+ebp-9E1DA9Eh]
                and     edi, edx
                mov     ebp, [esi+18h]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 5
                add     eax, ebx
                xor     edi, eax
                lea     edx, [edx+ebp-3FBF4CC0h]
                and     edi, ecx
                mov     ebp, [esi+2Ch]
                xor     edi, ebx
                add     edx, edi
                mov     edi, eax
                rol     edx, 9
                add     edx, eax
                xor     edi, edx
                lea     ecx, [ecx+ebp+265E5A51h]
                and     edi, ebx
                mov     ebp, [esi]
                xor     edi, eax
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 0Eh
                add     ecx, edx
                xor     edi, ecx
                lea     ebx, [ebx+ebp-16493856h]
                and     edi, eax
                mov     ebp, [esi+14h]
                xor     edi, edx
                add     ebx, edi
                mov     edi, ecx
                ror     ebx, 0Ch
                add     ebx, ecx
                xor     edi, ebx
                lea     eax, [eax+ebp-29D0EFA3h]
                and     edi, edx
                mov     ebp, [esi+28h]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 5
                add     eax, ebx
                xor     edi, eax
                lea     edx, [edx+ebp+2441453h]
                and     edi, ecx
                mov     ebp, [esi+3Ch]
                xor     edi, ebx
                add     edx, edi
                mov     edi, eax
                rol     edx, 9
                add     edx, eax
                xor     edi, edx
                lea     ecx, [ecx+ebp-275E197Fh]
                and     edi, ebx
                mov     ebp, [esi+10h]
                xor     edi, eax
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 0Eh
                add     ecx, edx
                xor     edi, ecx
                lea     ebx, [ebx+ebp-182C0438h]
                and     edi, eax
                mov     ebp, [esi+24h]
                xor     edi, edx
                add     ebx, edi
                mov     edi, ecx
                ror     ebx, 0Ch
                add     ebx, ecx
                xor     edi, ebx
                lea     eax, [eax+ebp+21E1CDE6h]
                and     edi, edx
                mov     ebp, [esi+38h]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 5
                add     eax, ebx
                xor     edi, eax
                lea     edx, [edx+ebp-3CC8F82Ah]
                and     edi, ecx
                mov     ebp, [esi+0Ch]
                xor     edi, ebx
                add     edx, edi
                mov     edi, eax
                rol     edx, 9
                add     edx, eax
                xor     edi, edx
                lea     ecx, [ecx+ebp-0B2AF279h]
                and     edi, ebx
                mov     ebp, [esi+20h]
                xor     edi, eax
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 0Eh
                add     ecx, edx
                xor     edi, ecx
                lea     ebx, [ebx+ebp+455A14EDh]
                and     edi, eax
                mov     ebp, [esi+34h]
                xor     edi, edx
                add     ebx, edi
                mov     edi, ecx
                ror     ebx, 0Ch
                add     ebx, ecx
                xor     edi, ebx
                lea     eax, [eax+ebp-561C16FBh]
                and     edi, edx
                mov     ebp, [esi+8]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 5
                add     eax, ebx
                xor     edi, eax
                lea     edx, [edx+ebp-3105C08h]
                and     edi, ecx
                mov     ebp, [esi+1Ch]
                xor     edi, ebx
                add     edx, edi
                mov     edi, eax
                rol     edx, 9
                add     edx, eax
                xor     edi, edx
                lea     ecx, [ecx+ebp+676F02D9h]
                and     edi, ebx
                mov     ebp, [esi+30h]
                xor     edi, eax
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 0Eh
                add     ecx, edx
                xor     edi, ecx
                lea     ebx, [ebx+ebp-72D5B376h]
                and     edi, eax
                mov     ebp, [esi+14h]
                xor     edi, edx
                add     ebx, edi
                mov     edi, ecx
                ror     ebx, 0Ch
                add     ebx, ecx
                xor     edi, edx
                lea     eax, [eax+ebp-5C6BEh]
                xor     edi, ebx
                mov     ebp, [esi+20h]
                add     eax, edi
                rol     eax, 4
                lea     edx, [edx+ebp-788E097Fh]
                mov     edi, ebx
                add     eax, ebx
                xor     edi, ecx
                mov     ebp, [esi+2Ch]
                xor     edi, eax
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Bh
                add     edx, eax
                xor     edi, ebx
                lea     ecx, [ecx+ebp+6D9D6122h]
                xor     edi, edx
                mov     ebp, [esi+38h]
                add     ecx, edi
                rol     ecx, 10h
                lea     ebx, [ebx+ebp-21AC7F4h]
                mov     edi, edx
                add     ecx, edx
                xor     edi, eax
                mov     ebp, [esi+4]
                xor     edi, ecx
                add     ebx, edi
                mov     edi, ecx
                ror     ebx, 9
                add     ebx, ecx
                xor     edi, edx
                lea     eax, [eax+ebp-5B4115BCh]
                xor     edi, ebx
                mov     ebp, [esi+10h]
                add     eax, edi
                rol     eax, 4
                lea     edx, [edx+ebp+4BDECFA9h]
                mov     edi, ebx
                add     eax, ebx
                xor     edi, ecx
                mov     ebp, [esi+1Ch]
                xor     edi, eax
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Bh
                add     edx, eax
                xor     edi, ebx
                lea     ecx, [ecx+ebp-944B4A0h]
                xor     edi, edx
                mov     ebp, [esi+28h]
                add     ecx, edi
                rol     ecx, 10h
                lea     ebx, [ebx+ebp-41404390h]
                mov     edi, edx
                add     ecx, edx
                xor     edi, eax
                mov     ebp, [esi+34h]
                xor     edi, ecx
                add     ebx, edi
                mov     edi, ecx
                ror     ebx, 9
                add     ebx, ecx
                xor     edi, edx
                lea     eax, [eax+ebp+289B7EC6h]
                xor     edi, ebx
                mov     ebp, [esi]
                add     eax, edi
                rol     eax, 4
                lea     edx, [edx+ebp-155ED806h]
                mov     edi, ebx
                add     eax, ebx
                xor     edi, ecx
                mov     ebp, [esi+0Ch]
                xor     edi, eax
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Bh
                add     edx, eax
                xor     edi, ebx
                lea     ecx, [ecx+ebp-2B10CF7Bh]
                xor     edi, edx
                mov     ebp, [esi+18h]
                add     ecx, edi
                rol     ecx, 10h
                lea     ebx, [ebx+ebp+4881D05h]
                mov     edi, edx
                add     ecx, edx
                xor     edi, eax
                mov     ebp, [esi+24h]
                xor     edi, ecx
                add     ebx, edi
                mov     edi, ecx
                ror     ebx, 9
                add     ebx, ecx
                xor     edi, edx
                lea     eax, [eax+ebp-262B2FC7h]
                xor     edi, ebx
                mov     ebp, [esi+30h]
                add     eax, edi
                rol     eax, 4
                lea     edx, [edx+ebp-1924661Bh]
                mov     edi, ebx
                add     eax, ebx
                xor     edi, ecx
                mov     ebp, [esi+3Ch]
                xor     edi, eax
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Bh
                add     edx, eax
                xor     edi, ebx
                lea     ecx, [ecx+ebp+1FA27CF8h]
                xor     edi, edx
                mov     ebp, [esi+8]
                add     ecx, edi
                rol     ecx, 10h
                lea     ebx, [ebx+ebp-3B53A99Bh]
                mov     edi, edx
                add     ecx, edx
                xor     edi, eax
                mov     ebp, [esi]
                xor     edi, ecx
                add     ebx, edi
                mov     edi, edx
                ror     ebx, 9
                add     ebx, ecx
                xor     edi, 0FFFFFFFFh
                lea     eax, [eax+ebp-0BD6DDBCh]
                or      edi, ebx
                mov     ebp, [esi+1Ch]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ecx
                rol     eax, 6
                add     eax, ebx
                xor     edi, 0FFFFFFFFh
                lea     edx, [edx+ebp+432AFF97h]
                or      edi, eax
                mov     ebp, [esi+38h]
                xor     edi, ebx
                add     edx, edi
                mov     edi, ebx
                rol     edx, 0Ah
                add     edx, eax
                xor     edi, 0FFFFFFFFh
                lea     ecx, [ecx+ebp-546BDC59h]
                or      edi, edx
                mov     ebp, [esi+14h]
                xor     edi, eax
                add     ecx, edi
                mov     edi, eax
                rol     ecx, 0Fh
                add     ecx, edx
                xor     edi, 0FFFFFFFFh
                lea     ebx, [ebx+ebp-36C5FC7h]
                or      edi, ecx
                mov     ebp, [esi+30h]
                xor     edi, edx
                add     ebx, edi
                mov     edi, edx
                ror     ebx, 0Bh
                add     ebx, ecx
                xor     edi, 0FFFFFFFFh
                lea     eax, [eax+ebp+655B59C3h]
                or      edi, ebx
                mov     ebp, [esi+0Ch]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ecx
                rol     eax, 6
                add     eax, ebx
                xor     edi, 0FFFFFFFFh
                lea     edx, [edx+ebp-70F3336Eh]
                or      edi, eax
                mov     ebp, [esi+28h]
                xor     edi, ebx
                add     edx, edi
                mov     edi, ebx
                rol     edx, 0Ah
                add     edx, eax
                xor     edi, 0FFFFFFFFh
                lea     ecx, [ecx+ebp-100B83h]
                or      edi, edx
                mov     ebp, [esi+4]
                xor     edi, eax
                add     ecx, edi
                mov     edi, eax
                rol     ecx, 0Fh
                add     ecx, edx
                xor     edi, 0FFFFFFFFh
                lea     ebx, [ebx+ebp-7A7BA22Fh]
                or      edi, ecx
                mov     ebp, [esi+20h]
                xor     edi, edx
                add     ebx, edi
                mov     edi, edx
                ror     ebx, 0Bh
                add     ebx, ecx
                xor     edi, 0FFFFFFFFh
                lea     eax, [eax+ebp+6FA87E4Fh]
                or      edi, ebx
                mov     ebp, [esi+3Ch]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ecx
                rol     eax, 6
                add     eax, ebx
                xor     edi, 0FFFFFFFFh
                lea     edx, [edx+ebp-1D31920h]
                or      edi, eax
                mov     ebp, [esi+18h]
                xor     edi, ebx
                add     edx, edi
                mov     edi, ebx
                rol     edx, 0Ah
                add     edx, eax
                xor     edi, 0FFFFFFFFh
                lea     ecx, [ecx+ebp-5CFEBCECh]
                or      edi, edx
                mov     ebp, [esi+34h]
                xor     edi, eax
                add     ecx, edi
                mov     edi, eax
                rol     ecx, 0Fh
                add     ecx, edx
                xor     edi, 0FFFFFFFFh
                lea     ebx, [ebx+ebp+4E0811A1h]
                or      edi, ecx
                mov     ebp, [esi+10h]
                xor     edi, edx
                add     ebx, edi
                mov     edi, edx
                ror     ebx, 0Bh
                add     ebx, ecx
                xor     edi, 0FFFFFFFFh
                lea     eax, [eax+ebp-8AC817Eh]
                or      edi, ebx
                mov     ebp, [esi+2Ch]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ecx
                rol     eax, 6
                add     eax, ebx
                xor     edi, 0FFFFFFFFh
                lea     edx, [edx+ebp-42C50DCBh]
                or      edi, eax
                mov     ebp, [esi+8]
                xor     edi, ebx
                add     edx, edi
                mov     edi, ebx
                rol     edx, 0Ah
                add     edx, eax
                xor     edi, 0FFFFFFFFh
                lea     ecx, [ecx+ebp+2AD7D2BBh]
                or      edi, edx
                mov     ebp, [esi+24h]
                xor     edi, eax
                add     ecx, edi
                mov     edi, eax
                rol     ecx, 0Fh
                add     ecx, edx
                xor     edi, 0FFFFFFFFh
                lea     ebx, [ebx+ebp-14792C6Fh]
                or      edi, ecx
                xor     edi, edx
                add     ebx, edi
                ror     ebx, 0Bh
                add     ebx, ecx
                pop     edi
                add     [edi], eax
                add     [edi+4], ebx
                add     [edi+8], ecx
                add     [edi+0Ch], edx


                pop     ebp
                pop     edi
                pop     esi
                pop     ebx
end;
{$ENDIF}

{$IFDEF THash_RipeMD128_asm}
procedure THash_RipeMD128.DoTransform(Buffer: PLongArray);
asm
                push    ebx
                push    esi
                push    edi
                lea     edi, [eax].THash_RipeMD128.FDigest
                mov     esi, edx
                push    ebp

                mov     eax, [edi]
                mov     ebx, [edi+4]
                push    edi
                mov     ecx, [edi+8]
                mov     edx, [edi+0Ch]
                add     esp, 0FFFFFFF0h
                mov     edi, edx
                xor     edi, ecx
                mov     ebp, [esi]
                xor     edi, ebx
                add     eax, ebp
                add     eax, edi
                mov     edi, ecx
                rol     eax, 0Bh
                xor     edi, ebx
                mov     ebp, [esi+4]
                xor     edi, eax
                add     edx, ebp
                add     edx, edi
                mov     edi, ebx
                rol     edx, 0Eh
                xor     edi, eax
                mov     ebp, [esi+8]
                xor     edi, edx
                add     ecx, ebp
                add     ecx, edi
                mov     edi, eax
                rol     ecx, 0Fh
                xor     edi, edx
                mov     ebp, [esi+0Ch]
                xor     edi, ecx
                add     ebx, ebp
                add     ebx, edi
                mov     edi, edx
                rol     ebx, 0Ch
                xor     edi, ecx
                mov     ebp, [esi+10h]
                xor     edi, ebx
                add     eax, ebp
                add     eax, edi
                mov     edi, ecx
                rol     eax, 5
                xor     edi, ebx
                mov     ebp, [esi+14h]
                xor     edi, eax
                add     edx, ebp
                add     edx, edi
                mov     edi, ebx
                rol     edx, 8
                xor     edi, eax
                mov     ebp, [esi+18h]
                xor     edi, edx
                add     ecx, ebp
                add     ecx, edi
                mov     edi, eax
                rol     ecx, 7
                xor     edi, edx
                mov     ebp, [esi+1Ch]
                xor     edi, ecx
                add     ebx, ebp
                add     ebx, edi
                mov     edi, edx
                rol     ebx, 9
                xor     edi, ecx
                mov     ebp, [esi+20h]
                xor     edi, ebx
                add     eax, ebp
                add     eax, edi
                mov     edi, ecx
                rol     eax, 0Bh
                xor     edi, ebx
                mov     ebp, [esi+24h]
                xor     edi, eax
                add     edx, ebp
                add     edx, edi
                mov     edi, ebx
                rol     edx, 0Dh
                xor     edi, eax
                mov     ebp, [esi+28h]
                xor     edi, edx
                add     ecx, ebp
                add     ecx, edi
                mov     edi, eax
                rol     ecx, 0Eh
                xor     edi, edx
                mov     ebp, [esi+2Ch]
                xor     edi, ecx
                add     ebx, ebp
                add     ebx, edi
                mov     edi, edx
                rol     ebx, 0Fh
                xor     edi, ecx
                mov     ebp, [esi+30h]
                xor     edi, ebx
                add     eax, ebp
                add     eax, edi
                mov     edi, ecx
                rol     eax, 6
                xor     edi, ebx
                mov     ebp, [esi+34h]
                xor     edi, eax
                add     edx, ebp
                add     edx, edi
                mov     edi, ebx
                rol     edx, 7
                xor     edi, eax
                mov     ebp, [esi+38h]
                xor     edi, edx
                add     ecx, ebp
                add     ecx, edi
                mov     edi, eax
                rol     ecx, 9
                xor     edi, edx
                mov     ebp, [esi+3Ch]
                xor     edi, ecx
                add     ebx, ebp
                add     ebx, edi
                rol     ebx, 8
                mov     ebp, [esi+1Ch]
                mov     edi, ecx
                xor     edi, edx
                lea     eax, [eax+ebp+5A827999h]
                and     edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, ecx
                add     eax, edi
                mov     edi, [esi+10h]
                rol     eax, 7
                and     ebp, eax
                lea     edx, [edx+edi+5A827999h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+34h]
                rol     edx, 6
                xor     edi, ebx
                lea     ecx, [ecx+ebp+5A827999h]
                and     edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, eax
                add     ecx, edi
                mov     edi, [esi+4]
                rol     ecx, 8
                and     ebp, ecx
                lea     ebx, [ebx+edi+5A827999h]
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                mov     ebp, [esi+28h]
                rol     ebx, 0Dh
                xor     edi, edx
                lea     eax, [eax+ebp+5A827999h]
                and     edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, ecx
                add     eax, edi
                mov     edi, [esi+18h]
                rol     eax, 0Bh
                and     ebp, eax
                lea     edx, [edx+edi+5A827999h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+3Ch]
                rol     edx, 9
                xor     edi, ebx
                lea     ecx, [ecx+ebp+5A827999h]
                and     edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, eax
                add     ecx, edi
                mov     edi, [esi+0Ch]
                rol     ecx, 7
                and     ebp, ecx
                lea     ebx, [ebx+edi+5A827999h]
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                mov     ebp, [esi+30h]
                rol     ebx, 0Fh
                xor     edi, edx
                lea     eax, [eax+ebp+5A827999h]
                and     edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, ecx
                add     eax, edi
                mov     edi, [esi]
                rol     eax, 7
                and     ebp, eax
                lea     edx, [edx+edi+5A827999h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+24h]
                rol     edx, 0Ch
                xor     edi, ebx
                lea     ecx, [ecx+ebp+5A827999h]
                and     edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, eax
                add     ecx, edi
                mov     edi, [esi+14h]
                rol     ecx, 0Fh
                and     ebp, ecx
                lea     ebx, [ebx+edi+5A827999h]
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                mov     ebp, [esi+8]
                rol     ebx, 9
                xor     edi, edx
                lea     eax, [eax+ebp+5A827999h]
                and     edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, ecx
                add     eax, edi
                mov     edi, [esi+38h]
                rol     eax, 0Bh
                and     ebp, eax
                lea     edx, [edx+edi+5A827999h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+2Ch]
                rol     edx, 7
                xor     edi, ebx
                lea     ecx, [ecx+ebp+5A827999h]
                and     edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, eax
                add     ecx, edi
                mov     edi, [esi+20h]
                rol     ecx, 0Dh
                and     ebp, ecx
                lea     ebx, [ebx+edi+5A827999h]
                xor     ebp, eax
                add     ebx, ebp
                rol     ebx, 0Ch
                mov     edi, ecx
                mov     ebp, [esi+0Ch]
                xor     edi, 0FFFFFFFFh
                lea     eax, [eax+ebp+6ED9EBA1h]
                or      edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, 0FFFFFFFFh
                add     eax, edi
                mov     edi, [esi+28h]
                rol     eax, 0Bh
                or      ebp, eax
                lea     edx, [edx+edi+6ED9EBA1h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+38h]
                rol     edx, 0Dh
                xor     edi, 0FFFFFFFFh
                lea     ecx, [ecx+ebp+6ED9EBA1h]
                or      edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, 0FFFFFFFFh
                add     ecx, edi
                mov     edi, [esi+10h]
                rol     ecx, 6
                or      ebp, ecx
                lea     ebx, [ebx+edi+6ED9EBA1h]
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                mov     ebp, [esi+24h]
                rol     ebx, 7
                xor     edi, 0FFFFFFFFh
                lea     eax, [eax+ebp+6ED9EBA1h]
                or      edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, 0FFFFFFFFh
                add     eax, edi
                mov     edi, [esi+3Ch]
                rol     eax, 0Eh
                or      ebp, eax
                lea     edx, [edx+edi+6ED9EBA1h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+20h]
                rol     edx, 9
                xor     edi, 0FFFFFFFFh
                lea     ecx, [ecx+ebp+6ED9EBA1h]
                or      edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, 0FFFFFFFFh
                add     ecx, edi
                mov     edi, [esi+4]
                rol     ecx, 0Dh
                or      ebp, ecx
                lea     ebx, [ebx+edi+6ED9EBA1h]
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                mov     ebp, [esi+8]
                rol     ebx, 0Fh
                xor     edi, 0FFFFFFFFh
                lea     eax, [eax+ebp+6ED9EBA1h]
                or      edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, 0FFFFFFFFh
                add     eax, edi
                mov     edi, [esi+1Ch]
                rol     eax, 0Eh
                or      ebp, eax
                lea     edx, [edx+edi+6ED9EBA1h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi]
                rol     edx, 8
                xor     edi, 0FFFFFFFFh
                lea     ecx, [ecx+ebp+6ED9EBA1h]
                or      edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, 0FFFFFFFFh
                add     ecx, edi
                mov     edi, [esi+18h]
                rol     ecx, 0Dh
                or      ebp, ecx
                lea     ebx, [ebx+edi+6ED9EBA1h]
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                mov     ebp, [esi+34h]
                rol     ebx, 6
                xor     edi, 0FFFFFFFFh
                lea     eax, [eax+ebp+6ED9EBA1h]
                or      edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, 0FFFFFFFFh
                add     eax, edi
                mov     edi, [esi+2Ch]
                rol     eax, 5
                or      ebp, eax
                lea     edx, [edx+edi+6ED9EBA1h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+14h]
                rol     edx, 0Ch
                xor     edi, 0FFFFFFFFh
                lea     ecx, [ecx+ebp+6ED9EBA1h]
                or      edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, 0FFFFFFFFh
                add     ecx, edi
                mov     edi, [esi+30h]
                rol     ecx, 7
                or      ebp, ecx
                lea     ebx, [ebx+edi+6ED9EBA1h]
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                mov     ebp, [esi+4]
                rol     ebx, 5
                xor     edi, ebx
                lea     eax, [eax+ebp-70E44324h]
                and     edi, edx
                mov     ebp, [esi+24h]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 0Bh
                xor     edi, eax
                lea     edx, [edx+ebp-70E44324h]
                and     edi, ecx
                mov     ebp, [esi+2Ch]
                xor     edi, ebx
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Ch
                xor     edi, edx
                lea     ecx, [ecx+ebp-70E44324h]
                and     edi, ebx
                mov     ebp, [esi+28h]
                xor     edi, eax
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 0Eh
                xor     edi, ecx
                lea     ebx, [ebx+ebp-70E44324h]
                and     edi, eax
                mov     ebp, [esi]
                xor     edi, edx
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 0Fh
                xor     edi, ebx
                lea     eax, [eax+ebp-70E44324h]
                and     edi, edx
                mov     ebp, [esi+20h]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 0Eh
                xor     edi, eax
                lea     edx, [edx+ebp-70E44324h]
                and     edi, ecx
                mov     ebp, [esi+30h]
                xor     edi, ebx
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Fh
                xor     edi, edx
                lea     ecx, [ecx+ebp-70E44324h]
                and     edi, ebx
                mov     ebp, [esi+10h]
                xor     edi, eax
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 9
                xor     edi, ecx
                lea     ebx, [ebx+ebp-70E44324h]
                and     edi, eax
                mov     ebp, [esi+34h]
                xor     edi, edx
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 8
                xor     edi, ebx
                lea     eax, [eax+ebp-70E44324h]
                and     edi, edx
                mov     ebp, [esi+0Ch]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 9
                xor     edi, eax
                lea     edx, [edx+ebp-70E44324h]
                and     edi, ecx
                mov     ebp, [esi+1Ch]
                xor     edi, ebx
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Eh
                xor     edi, edx
                lea     ecx, [ecx+ebp-70E44324h]
                and     edi, ebx
                mov     ebp, [esi+3Ch]
                xor     edi, eax
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 5
                xor     edi, ecx
                lea     ebx, [ebx+ebp-70E44324h]
                and     edi, eax
                mov     ebp, [esi+38h]
                xor     edi, edx
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 6
                xor     edi, ebx
                lea     eax, [eax+ebp-70E44324h]
                and     edi, edx
                mov     ebp, [esi+14h]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 8
                xor     edi, eax
                lea     edx, [edx+ebp-70E44324h]
                and     edi, ecx
                mov     ebp, [esi+18h]
                xor     edi, ebx
                add     edx, edi
                mov     edi, eax
                rol     edx, 6
                xor     edi, edx
                lea     ecx, [ecx+ebp-70E44324h]
                and     edi, ebx
                mov     ebp, [esi+8]
                xor     edi, eax
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 5
                xor     edi, ecx
                lea     ebx, [ebx+ebp-70E44324h]
                and     edi, eax
                xor     edi, edx
                add     ebx, edi
                rol     ebx, 0Ch
                mov     edi, [esp+10h]
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     eax, [edi]
                mov     ebx, [edi+4]
                mov     [esp+8], ecx
                mov     ecx, [edi+8]
                mov     ebp, [esi+14h]
                mov     [esp+0Ch], edx
                mov     edx, [edi+0Ch]
                mov     edi, ecx
                xor     edi, ebx
                lea     eax, [eax+ebp+50A28BE6h]
                and     edi, edx
                mov     ebp, [esi+38h]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 8
                xor     edi, eax
                lea     edx, [edx+ebp+50A28BE6h]
                and     edi, ecx
                mov     ebp, [esi+1Ch]
                xor     edi, ebx
                add     edx, edi
                mov     edi, eax
                rol     edx, 9
                xor     edi, edx
                lea     ecx, [ecx+ebp+50A28BE6h]
                and     edi, ebx
                mov     ebp, [esi]
                xor     edi, eax
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 9
                xor     edi, ecx
                lea     ebx, [ebx+ebp+50A28BE6h]
                and     edi, eax
                mov     ebp, [esi+24h]
                xor     edi, edx
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 0Bh
                xor     edi, ebx
                lea     eax, [eax+ebp+50A28BE6h]
                and     edi, edx
                mov     ebp, [esi+8]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 0Dh
                xor     edi, eax
                lea     edx, [edx+ebp+50A28BE6h]
                and     edi, ecx
                mov     ebp, [esi+2Ch]
                xor     edi, ebx
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Fh
                xor     edi, edx
                lea     ecx, [ecx+ebp+50A28BE6h]
                and     edi, ebx
                mov     ebp, [esi+10h]
                xor     edi, eax
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 0Fh
                xor     edi, ecx
                lea     ebx, [ebx+ebp+50A28BE6h]
                and     edi, eax
                mov     ebp, [esi+34h]
                xor     edi, edx
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 5
                xor     edi, ebx
                lea     eax, [eax+ebp+50A28BE6h]
                and     edi, edx
                mov     ebp, [esi+18h]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 7
                xor     edi, eax
                lea     edx, [edx+ebp+50A28BE6h]
                and     edi, ecx
                mov     ebp, [esi+3Ch]
                xor     edi, ebx
                add     edx, edi
                mov     edi, eax
                rol     edx, 7
                xor     edi, edx
                lea     ecx, [ecx+ebp+50A28BE6h]
                and     edi, ebx
                mov     ebp, [esi+20h]
                xor     edi, eax
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 8
                xor     edi, ecx
                lea     ebx, [ebx+ebp+50A28BE6h]
                and     edi, eax
                mov     ebp, [esi+4]
                xor     edi, edx
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 0Bh
                xor     edi, ebx
                lea     eax, [eax+ebp+50A28BE6h]
                and     edi, edx
                mov     ebp, [esi+28h]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 0Eh
                xor     edi, eax
                lea     edx, [edx+ebp+50A28BE6h]
                and     edi, ecx
                mov     ebp, [esi+0Ch]
                xor     edi, ebx
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Eh
                xor     edi, edx
                lea     ecx, [ecx+ebp+50A28BE6h]
                and     edi, ebx
                mov     ebp, [esi+30h]
                xor     edi, eax
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 0Ch
                xor     edi, ecx
                lea     ebx, [ebx+ebp+50A28BE6h]
                and     edi, eax
                mov     ebp, [esi+18h]
                xor     edi, edx
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 6
                xor     edi, 0FFFFFFFFh
                lea     eax, [eax+ebp+5C4DD124h]
                or      edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, 0FFFFFFFFh
                add     eax, edi
                mov     edi, [esi+2Ch]
                rol     eax, 9
                or      ebp, eax
                lea     edx, [edx+edi+5C4DD124h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+0Ch]
                rol     edx, 0Dh
                xor     edi, 0FFFFFFFFh
                lea     ecx, [ecx+ebp+5C4DD124h]
                or      edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, 0FFFFFFFFh
                add     ecx, edi
                mov     edi, [esi+1Ch]
                rol     ecx, 0Fh
                or      ebp, ecx
                lea     ebx, [ebx+edi+5C4DD124h]
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                mov     ebp, [esi]
                rol     ebx, 7
                xor     edi, 0FFFFFFFFh
                lea     eax, [eax+ebp+5C4DD124h]
                or      edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, 0FFFFFFFFh
                add     eax, edi
                mov     edi, [esi+34h]
                rol     eax, 0Ch
                or      ebp, eax
                lea     edx, [edx+edi+5C4DD124h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+14h]
                rol     edx, 8
                xor     edi, 0FFFFFFFFh
                lea     ecx, [ecx+ebp+5C4DD124h]
                or      edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, 0FFFFFFFFh
                add     ecx, edi
                mov     edi, [esi+28h]
                rol     ecx, 9
                or      ebp, ecx
                lea     ebx, [ebx+edi+5C4DD124h]
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                mov     ebp, [esi+38h]
                rol     ebx, 0Bh
                xor     edi, 0FFFFFFFFh
                lea     eax, [eax+ebp+5C4DD124h]
                or      edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, 0FFFFFFFFh
                add     eax, edi
                mov     edi, [esi+3Ch]
                rol     eax, 7
                or      ebp, eax
                lea     edx, [edx+edi+5C4DD124h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+20h]
                rol     edx, 7
                xor     edi, 0FFFFFFFFh
                lea     ecx, [ecx+ebp+5C4DD124h]
                or      edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, 0FFFFFFFFh
                add     ecx, edi
                mov     edi, [esi+30h]
                rol     ecx, 0Ch
                or      ebp, ecx
                lea     ebx, [ebx+edi+5C4DD124h]
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                mov     ebp, [esi+10h]
                rol     ebx, 7
                xor     edi, 0FFFFFFFFh
                lea     eax, [eax+ebp+5C4DD124h]
                or      edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, 0FFFFFFFFh
                add     eax, edi
                mov     edi, [esi+24h]
                rol     eax, 6
                or      ebp, eax
                lea     edx, [edx+edi+5C4DD124h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+4]
                rol     edx, 0Fh
                xor     edi, 0FFFFFFFFh
                lea     ecx, [ecx+ebp+5C4DD124h]
                or      edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, 0FFFFFFFFh
                add     ecx, edi
                mov     edi, [esi+8]
                rol     ecx, 0Dh
                or      ebp, ecx
                lea     ebx, [ebx+edi+5C4DD124h]
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                mov     ebp, [esi+3Ch]
                rol     ebx, 0Bh
                xor     edi, edx
                lea     eax, [eax+ebp+6D703EF3h]
                and     edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, ecx
                add     eax, edi
                mov     edi, [esi+14h]
                rol     eax, 9
                and     ebp, eax
                lea     edx, [edx+edi+6D703EF3h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+4]
                rol     edx, 7
                xor     edi, ebx
                lea     ecx, [ecx+ebp+6D703EF3h]
                and     edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, eax
                add     ecx, edi
                mov     edi, [esi+0Ch]
                rol     ecx, 0Fh
                and     ebp, ecx
                lea     ebx, [ebx+edi+6D703EF3h]
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                mov     ebp, [esi+1Ch]
                rol     ebx, 0Bh
                xor     edi, edx
                lea     eax, [eax+ebp+6D703EF3h]
                and     edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, ecx
                add     eax, edi
                mov     edi, [esi+38h]
                rol     eax, 8
                and     ebp, eax
                lea     edx, [edx+edi+6D703EF3h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+18h]
                rol     edx, 6
                xor     edi, ebx
                lea     ecx, [ecx+ebp+6D703EF3h]
                and     edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, eax
                add     ecx, edi
                mov     edi, [esi+24h]
                rol     ecx, 6
                and     ebp, ecx
                lea     ebx, [ebx+edi+6D703EF3h]
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                mov     ebp, [esi+2Ch]
                rol     ebx, 0Eh
                xor     edi, edx
                lea     eax, [eax+ebp+6D703EF3h]
                and     edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, ecx
                add     eax, edi
                mov     edi, [esi+20h]
                rol     eax, 0Ch
                and     ebp, eax
                lea     edx, [edx+edi+6D703EF3h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+30h]
                rol     edx, 0Dh
                xor     edi, ebx
                lea     ecx, [ecx+ebp+6D703EF3h]
                and     edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, eax
                add     ecx, edi
                mov     edi, [esi+8]
                rol     ecx, 5
                and     ebp, ecx
                lea     ebx, [ebx+edi+6D703EF3h]
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                mov     ebp, [esi+28h]
                rol     ebx, 0Eh
                xor     edi, edx
                lea     eax, [eax+ebp+6D703EF3h]
                and     edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, ecx
                add     eax, edi
                mov     edi, [esi]
                rol     eax, 0Dh
                and     ebp, eax
                lea     edx, [edx+edi+6D703EF3h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+10h]
                rol     edx, 0Dh
                xor     edi, ebx
                lea     ecx, [ecx+ebp+6D703EF3h]
                and     edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, eax
                add     ecx, edi
                mov     edi, [esi+34h]
                rol     ecx, 7
                and     ebp, ecx
                lea     ebx, [ebx+edi+6D703EF3h]
                xor     ebp, eax
                add     ebx, ebp
                rol     ebx, 5
                mov     edi, edx
                xor     edi, ecx
                mov     ebp, [esi+20h]
                xor     edi, ebx
                add     eax, ebp
                add     eax, edi
                mov     edi, ecx
                rol     eax, 0Fh
                xor     edi, ebx
                mov     ebp, [esi+18h]
                xor     edi, eax
                add     edx, ebp
                add     edx, edi
                mov     edi, ebx
                rol     edx, 5
                xor     edi, eax
                mov     ebp, [esi+10h]
                xor     edi, edx
                add     ecx, ebp
                add     ecx, edi
                mov     edi, eax
                rol     ecx, 8
                xor     edi, edx
                mov     ebp, [esi+4]
                xor     edi, ecx
                add     ebx, ebp
                add     ebx, edi
                mov     edi, edx
                rol     ebx, 0Bh
                xor     edi, ecx
                mov     ebp, [esi+0Ch]
                xor     edi, ebx
                add     eax, ebp
                add     eax, edi
                mov     edi, ecx
                rol     eax, 0Eh
                xor     edi, ebx
                mov     ebp, [esi+2Ch]
                xor     edi, eax
                add     edx, ebp
                add     edx, edi
                mov     edi, ebx
                rol     edx, 0Eh
                xor     edi, eax
                mov     ebp, [esi+3Ch]
                xor     edi, edx
                add     ecx, ebp
                add     ecx, edi
                mov     edi, eax
                rol     ecx, 6
                xor     edi, edx
                mov     ebp, [esi]
                xor     edi, ecx
                add     ebx, ebp
                add     ebx, edi
                mov     edi, edx
                rol     ebx, 0Eh
                xor     edi, ecx
                mov     ebp, [esi+14h]
                xor     edi, ebx
                add     eax, ebp
                add     eax, edi
                mov     edi, ecx
                rol     eax, 6
                xor     edi, ebx
                mov     ebp, [esi+30h]
                xor     edi, eax
                add     edx, ebp
                add     edx, edi
                mov     edi, ebx
                rol     edx, 9
                xor     edi, eax
                mov     ebp, [esi+8]
                xor     edi, edx
                add     ecx, ebp
                add     ecx, edi
                mov     edi, eax
                rol     ecx, 0Ch
                xor     edi, edx
                mov     ebp, [esi+34h]
                xor     edi, ecx
                add     ebx, ebp
                add     ebx, edi
                mov     edi, edx
                rol     ebx, 9
                xor     edi, ecx
                mov     ebp, [esi+24h]
                xor     edi, ebx
                add     eax, ebp
                add     eax, edi
                mov     edi, ecx
                rol     eax, 0Ch
                xor     edi, ebx
                mov     ebp, [esi+1Ch]
                xor     edi, eax
                add     edx, ebp
                add     edx, edi
                mov     edi, ebx
                rol     edx, 5
                xor     edi, eax
                mov     ebp, [esi+28h]
                xor     edi, edx
                add     ecx, ebp
                add     ecx, edi
                mov     edi, eax
                rol     ecx, 0Fh
                xor     edi, edx
                mov     ebp, [esi+38h]
                xor     edi, ecx
                add     ebx, ebp
                add     ebx, edi
                rol     ebx, 8
                mov     edi, [esp+10h]
                mov     ebp, [esp+8]
                mov     esi, [esp+0Ch]
                add     edx, ebp
                add     eax, esi
                mov     ebp, [edi+4]
                mov     esi, [edi+8]
                add     edx, ebp
                add     eax, esi
                mov     [edi+4], eax
                mov     ebp, [esp]
                mov     esi, [esp+4]
                add     ebx, ebp
                add     ecx, esi
                mov     ebp, [edi+0Ch]
                mov     esi, [edi]
                add     ebx, ebp
                add     ecx, esi
                mov     [edi+8], ebx
                add     esp, 14h
                mov     [edi+0Ch], ecx
                mov     [edi], edx


                pop     ebp
                pop     edi
                pop     esi
                pop     ebx
end;
{$ENDIF}

{$IFDEF THash_RipeMD160_asm}
procedure THash_RipeMD160.DoTransform(Buffer: PLongArray);
asm
                push    ebx
                push    esi
                push    edi
                lea     edi, [eax].THash_RipeMD160.FDigest
                mov     esi, edx
                push    ebp

                mov     eax, [edi]
                mov     ebx, [edi+4]
                push    edi
                mov     ecx, [edi+8]
                mov     edx, [edi+0Ch]
                mov     ebp, [edi+10h]
                add     esp, 0FFFFFFECh
                mov     edi, edx
                xor     edi, ecx
                xor     edi, ebx
                add     eax, [esi]
                rol     ecx, 0Ah
                add     eax, edi
                mov     edi, ecx
                rol     eax, 0Bh
                add     eax, ebp
                xor     edi, ebx
                xor     edi, eax
                add     ebp, [esi+4]
                rol     ebx, 0Ah
                add     ebp, edi
                mov     edi, ebx
                rol     ebp, 0Eh
                add     ebp, edx
                xor     edi, eax
                xor     edi, ebp
                add     edx, [esi+8]
                rol     eax, 0Ah
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Fh
                add     edx, ecx
                xor     edi, ebp
                xor     edi, edx
                add     ecx, [esi+0Ch]
                rol     ebp, 0Ah
                add     ecx, edi
                mov     edi, ebp
                rol     ecx, 0Ch
                add     ecx, ebx
                xor     edi, edx
                xor     edi, ecx
                add     ebx, [esi+10h]
                rol     edx, 0Ah
                add     ebx, edi
                mov     edi, edx
                rol     ebx, 5
                add     ebx, eax
                xor     edi, ecx
                xor     edi, ebx
                add     eax, [esi+14h]
                rol     ecx, 0Ah
                add     eax, edi
                mov     edi, ecx
                rol     eax, 8
                add     eax, ebp
                xor     edi, ebx
                xor     edi, eax
                add     ebp, [esi+18h]
                rol     ebx, 0Ah
                add     ebp, edi
                mov     edi, ebx
                rol     ebp, 7
                add     ebp, edx
                xor     edi, eax
                xor     edi, ebp
                add     edx, [esi+1Ch]
                rol     eax, 0Ah
                add     edx, edi
                mov     edi, eax
                rol     edx, 9
                add     edx, ecx
                xor     edi, ebp
                xor     edi, edx
                add     ecx, [esi+20h]
                rol     ebp, 0Ah
                add     ecx, edi
                mov     edi, ebp
                rol     ecx, 0Bh
                add     ecx, ebx
                xor     edi, edx
                xor     edi, ecx
                add     ebx, [esi+24h]
                rol     edx, 0Ah
                add     ebx, edi
                mov     edi, edx
                rol     ebx, 0Dh
                add     ebx, eax
                xor     edi, ecx
                xor     edi, ebx
                add     eax, [esi+28h]
                rol     ecx, 0Ah
                add     eax, edi
                mov     edi, ecx
                rol     eax, 0Eh
                add     eax, ebp
                xor     edi, ebx
                xor     edi, eax
                add     ebp, [esi+2Ch]
                rol     ebx, 0Ah
                add     ebp, edi
                mov     edi, ebx
                rol     ebp, 0Fh
                add     ebp, edx
                xor     edi, eax
                xor     edi, ebp
                add     edx, [esi+30h]
                rol     eax, 0Ah
                add     edx, edi
                mov     edi, eax
                rol     edx, 6
                add     edx, ecx
                xor     edi, ebp
                xor     edi, edx
                add     ecx, [esi+34h]
                rol     ebp, 0Ah
                add     ecx, edi
                mov     edi, ebp
                rol     ecx, 7
                add     ecx, ebx
                xor     edi, edx
                xor     edi, ecx
                add     ebx, [esi+38h]
                rol     edx, 0Ah
                add     ebx, edi
                mov     edi, edx
                rol     ebx, 9
                add     ebx, eax
                xor     edi, ecx
                xor     edi, ebx
                add     eax, [esi+3Ch]
                rol     ecx, 0Ah
                add     eax, edi
                mov     edi, ecx
                rol     eax, 8
                add     eax, ebp
                xor     edi, ebx
                add     ebp, [esi+1Ch]
                and     edi, eax
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+5A827999h]
                mov     edi, ebx
                rol     ebp, 7
                add     ebp, edx
                xor     edi, eax
                add     edx, [esi+10h]
                and     edi, ebp
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+5A827999h]
                mov     edi, eax
                rol     edx, 6
                add     edx, ecx
                xor     edi, ebp
                add     ecx, [esi+34h]
                and     edi, edx
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+5A827999h]
                mov     edi, ebp
                rol     ecx, 8
                add     ecx, ebx
                xor     edi, edx
                add     ebx, [esi+4]
                and     edi, ecx
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+5A827999h]
                mov     edi, edx
                rol     ebx, 0Dh
                add     ebx, eax
                xor     edi, ecx
                add     eax, [esi+28h]
                and     edi, ebx
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+5A827999h]
                mov     edi, ecx
                rol     eax, 0Bh
                add     eax, ebp
                xor     edi, ebx
                add     ebp, [esi+18h]
                and     edi, eax
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+5A827999h]
                mov     edi, ebx
                rol     ebp, 9
                add     ebp, edx
                xor     edi, eax
                add     edx, [esi+3Ch]
                and     edi, ebp
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+5A827999h]
                mov     edi, eax
                rol     edx, 7
                add     edx, ecx
                xor     edi, ebp
                add     ecx, [esi+0Ch]
                and     edi, edx
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+5A827999h]
                mov     edi, ebp
                rol     ecx, 0Fh
                add     ecx, ebx
                xor     edi, edx
                add     ebx, [esi+30h]
                and     edi, ecx
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+5A827999h]
                mov     edi, edx
                rol     ebx, 7
                add     ebx, eax
                xor     edi, ecx
                add     eax, [esi]
                and     edi, ebx
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+5A827999h]
                mov     edi, ecx
                rol     eax, 0Ch
                add     eax, ebp
                xor     edi, ebx
                add     ebp, [esi+24h]
                and     edi, eax
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+5A827999h]
                mov     edi, ebx
                rol     ebp, 0Fh
                add     ebp, edx
                xor     edi, eax
                add     edx, [esi+14h]
                and     edi, ebp
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+5A827999h]
                mov     edi, eax
                rol     edx, 9
                add     edx, ecx
                xor     edi, ebp
                add     ecx, [esi+8]
                and     edi, edx
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+5A827999h]
                mov     edi, ebp
                rol     ecx, 0Bh
                add     ecx, ebx
                xor     edi, edx
                add     ebx, [esi+38h]
                and     edi, ecx
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+5A827999h]
                mov     edi, edx
                rol     ebx, 7
                add     ebx, eax
                xor     edi, ecx
                add     eax, [esi+2Ch]
                and     edi, ebx
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+5A827999h]
                mov     edi, ecx
                rol     eax, 0Dh
                add     eax, ebp
                xor     edi, ebx
                add     ebp, [esi+20h]
                and     edi, eax
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+5A827999h]
                mov     edi, ebx
                rol     ebp, 0Ch
                add     ebp, edx
                mov     edi, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     edx, [esi+0Ch]
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+6ED9EBA1h]
                mov     edi, ebp
                rol     edx, 0Bh
                xor     edi, 0FFFFFFFFh
                add     edx, ecx
                or      edi, edx
                add     ecx, [esi+28h]
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+6ED9EBA1h]
                mov     edi, edx
                rol     ecx, 0Dh
                xor     edi, 0FFFFFFFFh
                add     ecx, ebx
                or      edi, ecx
                add     ebx, [esi+38h]
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+6ED9EBA1h]
                mov     edi, ecx
                rol     ebx, 6
                xor     edi, 0FFFFFFFFh
                add     ebx, eax
                or      edi, ebx
                add     eax, [esi+10h]
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+6ED9EBA1h]
                mov     edi, ebx
                rol     eax, 7
                xor     edi, 0FFFFFFFFh
                add     eax, ebp
                or      edi, eax
                add     ebp, [esi+24h]
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+6ED9EBA1h]
                mov     edi, eax
                rol     ebp, 0Eh
                xor     edi, 0FFFFFFFFh
                add     ebp, edx
                or      edi, ebp
                add     edx, [esi+3Ch]
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+6ED9EBA1h]
                mov     edi, ebp
                rol     edx, 9
                xor     edi, 0FFFFFFFFh
                add     edx, ecx
                or      edi, edx
                add     ecx, [esi+20h]
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+6ED9EBA1h]
                mov     edi, edx
                rol     ecx, 0Dh
                xor     edi, 0FFFFFFFFh
                add     ecx, ebx
                or      edi, ecx
                add     ebx, [esi+4]
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+6ED9EBA1h]
                mov     edi, ecx
                rol     ebx, 0Fh
                xor     edi, 0FFFFFFFFh
                add     ebx, eax
                or      edi, ebx
                add     eax, [esi+8]
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+6ED9EBA1h]
                mov     edi, ebx
                rol     eax, 0Eh
                xor     edi, 0FFFFFFFFh
                add     eax, ebp
                or      edi, eax
                add     ebp, [esi+1Ch]
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+6ED9EBA1h]
                mov     edi, eax
                rol     ebp, 8
                xor     edi, 0FFFFFFFFh
                add     ebp, edx
                or      edi, ebp
                add     edx, [esi]
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+6ED9EBA1h]
                mov     edi, ebp
                rol     edx, 0Dh
                xor     edi, 0FFFFFFFFh
                add     edx, ecx
                or      edi, edx
                add     ecx, [esi+18h]
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+6ED9EBA1h]
                mov     edi, edx
                rol     ecx, 6
                xor     edi, 0FFFFFFFFh
                add     ecx, ebx
                or      edi, ecx
                add     ebx, [esi+34h]
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+6ED9EBA1h]
                mov     edi, ecx
                rol     ebx, 5
                xor     edi, 0FFFFFFFFh
                add     ebx, eax
                or      edi, ebx
                add     eax, [esi+2Ch]
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+6ED9EBA1h]
                mov     edi, ebx
                rol     eax, 0Ch
                xor     edi, 0FFFFFFFFh
                add     eax, ebp
                or      edi, eax
                add     ebp, [esi+14h]
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+6ED9EBA1h]
                mov     edi, eax
                rol     ebp, 7
                xor     edi, 0FFFFFFFFh
                add     ebp, edx
                or      edi, ebp
                add     edx, [esi+30h]
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+6ED9EBA1h]
                mov     edi, ebp
                rol     edx, 5
                xor     edi, 0FFFFFFFFh
                add     edx, ecx
                mov     edi, ebp
                xor     edi, edx
                and     edi, eax
                add     ecx, [esi+4]
                xor     edi, ebp
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi-70E44324h]
                mov     edi, edx
                rol     ecx, 0Bh
                add     ecx, ebx
                xor     edi, ecx
                and     edi, ebp
                add     ebx, [esi+24h]
                xor     edi, edx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi-70E44324h]
                mov     edi, ecx
                rol     ebx, 0Ch
                add     ebx, eax
                xor     edi, ebx
                and     edi, edx
                add     eax, [esi+2Ch]
                xor     edi, ecx
                rol     ecx, 0Ah
                lea     eax, [eax+edi-70E44324h]
                mov     edi, ebx
                rol     eax, 0Eh
                add     eax, ebp
                xor     edi, eax
                and     edi, ecx
                add     ebp, [esi+28h]
                xor     edi, ebx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi-70E44324h]
                mov     edi, eax
                rol     ebp, 0Fh
                add     ebp, edx
                xor     edi, ebp
                and     edi, ebx
                add     edx, [esi]
                xor     edi, eax
                rol     eax, 0Ah
                lea     edx, [edx+edi-70E44324h]
                mov     edi, ebp
                rol     edx, 0Eh
                add     edx, ecx
                xor     edi, edx
                and     edi, eax
                add     ecx, [esi+20h]
                xor     edi, ebp
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi-70E44324h]
                mov     edi, edx
                rol     ecx, 0Fh
                add     ecx, ebx
                xor     edi, ecx
                and     edi, ebp
                add     ebx, [esi+30h]
                xor     edi, edx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi-70E44324h]
                mov     edi, ecx
                rol     ebx, 9
                add     ebx, eax
                xor     edi, ebx
                and     edi, edx
                add     eax, [esi+10h]
                xor     edi, ecx
                rol     ecx, 0Ah
                lea     eax, [eax+edi-70E44324h]
                mov     edi, ebx
                rol     eax, 8
                add     eax, ebp
                xor     edi, eax
                and     edi, ecx
                add     ebp, [esi+34h]
                xor     edi, ebx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi-70E44324h]
                mov     edi, eax
                rol     ebp, 9
                add     ebp, edx
                xor     edi, ebp
                and     edi, ebx
                add     edx, [esi+0Ch]
                xor     edi, eax
                rol     eax, 0Ah
                lea     edx, [edx+edi-70E44324h]
                mov     edi, ebp
                rol     edx, 0Eh
                add     edx, ecx
                xor     edi, edx
                and     edi, eax
                add     ecx, [esi+1Ch]
                xor     edi, ebp
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi-70E44324h]
                mov     edi, edx
                rol     ecx, 5
                add     ecx, ebx
                xor     edi, ecx
                and     edi, ebp
                add     ebx, [esi+3Ch]
                xor     edi, edx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi-70E44324h]
                mov     edi, ecx
                rol     ebx, 6
                add     ebx, eax
                xor     edi, ebx
                and     edi, edx
                add     eax, [esi+38h]
                xor     edi, ecx
                rol     ecx, 0Ah
                lea     eax, [eax+edi-70E44324h]
                mov     edi, ebx
                rol     eax, 8
                add     eax, ebp
                xor     edi, eax
                and     edi, ecx
                add     ebp, [esi+14h]
                xor     edi, ebx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi-70E44324h]
                mov     edi, eax
                rol     ebp, 6
                add     ebp, edx
                xor     edi, ebp
                and     edi, ebx
                add     edx, [esi+18h]
                xor     edi, eax
                rol     eax, 0Ah
                lea     edx, [edx+edi-70E44324h]
                mov     edi, ebp
                rol     edx, 5
                add     edx, ecx
                xor     edi, edx
                and     edi, eax
                add     ecx, [esi+8]
                xor     edi, ebp
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi-70E44324h]
                mov     edi, edx
                rol     ecx, 0Ch
                add     ecx, ebx
                mov     edi, ebp
                xor     edi, 0FFFFFFFFh
                or      edi, edx
                add     ebx, [esi+10h]
                xor     edi, ecx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi-56AC02B2h]
                mov     edi, edx
                rol     ebx, 9
                add     ebx, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ecx
                add     eax, [esi]
                xor     edi, ebx
                rol     ecx, 0Ah
                lea     eax, [eax+edi-56AC02B2h]
                mov     edi, ecx
                rol     eax, 0Fh
                add     eax, ebp
                xor     edi, 0FFFFFFFFh
                or      edi, ebx
                add     ebp, [esi+14h]
                xor     edi, eax
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi-56AC02B2h]
                mov     edi, ebx
                rol     ebp, 5
                add     ebp, edx
                xor     edi, 0FFFFFFFFh
                or      edi, eax
                add     edx, [esi+24h]
                xor     edi, ebp
                rol     eax, 0Ah
                lea     edx, [edx+edi-56AC02B2h]
                mov     edi, eax
                rol     edx, 0Bh
                add     edx, ecx
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     ecx, [esi+1Ch]
                xor     edi, edx
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi-56AC02B2h]
                mov     edi, ebp
                rol     ecx, 6
                add     ecx, ebx
                xor     edi, 0FFFFFFFFh
                or      edi, edx
                add     ebx, [esi+30h]
                xor     edi, ecx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi-56AC02B2h]
                mov     edi, edx
                rol     ebx, 8
                add     ebx, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ecx
                add     eax, [esi+8]
                xor     edi, ebx
                rol     ecx, 0Ah
                lea     eax, [eax+edi-56AC02B2h]
                mov     edi, ecx
                rol     eax, 0Dh
                add     eax, ebp
                xor     edi, 0FFFFFFFFh
                or      edi, ebx
                add     ebp, [esi+28h]
                xor     edi, eax
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi-56AC02B2h]
                mov     edi, ebx
                rol     ebp, 0Ch
                add     ebp, edx
                xor     edi, 0FFFFFFFFh
                or      edi, eax
                add     edx, [esi+38h]
                xor     edi, ebp
                rol     eax, 0Ah
                lea     edx, [edx+edi-56AC02B2h]
                mov     edi, eax
                rol     edx, 5
                add     edx, ecx
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     ecx, [esi+4]
                xor     edi, edx
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi-56AC02B2h]
                mov     edi, ebp
                rol     ecx, 0Ch
                add     ecx, ebx
                xor     edi, 0FFFFFFFFh
                or      edi, edx
                add     ebx, [esi+0Ch]
                xor     edi, ecx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi-56AC02B2h]
                mov     edi, edx
                rol     ebx, 0Dh
                add     ebx, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ecx
                add     eax, [esi+20h]
                xor     edi, ebx
                rol     ecx, 0Ah
                lea     eax, [eax+edi-56AC02B2h]
                mov     edi, ecx
                rol     eax, 0Eh
                add     eax, ebp
                xor     edi, 0FFFFFFFFh
                or      edi, ebx
                add     ebp, [esi+2Ch]
                xor     edi, eax
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi-56AC02B2h]
                mov     edi, ebx
                rol     ebp, 0Bh
                add     ebp, edx
                xor     edi, 0FFFFFFFFh
                or      edi, eax
                add     edx, [esi+18h]
                xor     edi, ebp
                rol     eax, 0Ah
                lea     edx, [edx+edi-56AC02B2h]
                mov     edi, eax
                rol     edx, 8
                add     edx, ecx
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     ecx, [esi+3Ch]
                xor     edi, edx
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi-56AC02B2h]
                mov     edi, ebp
                rol     ecx, 5
                add     ecx, ebx
                xor     edi, 0FFFFFFFFh
                or      edi, edx
                add     ebx, [esi+34h]
                xor     edi, ecx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi-56AC02B2h]
                mov     edi, edx
                rol     ebx, 6
                add     ebx, eax
                mov     edi, [esp+14h]
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     eax, [edi]
                mov     ebx, [edi+4]
                mov     [esp+8], ecx
                mov     [esp+0Ch], edx
                mov     ecx, [edi+8]
                mov     edx, [edi+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [edi+10h]
                mov     edi, edx
                xor     edi, 0FFFFFFFFh
                or      edi, ecx
                add     eax, [esi+14h]
                xor     edi, ebx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+50A28BE6h]
                mov     edi, ecx
                rol     eax, 8
                add     eax, ebp
                xor     edi, 0FFFFFFFFh
                or      edi, ebx
                add     ebp, [esi+38h]
                xor     edi, eax
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+50A28BE6h]
                mov     edi, ebx
                rol     ebp, 9
                add     ebp, edx
                xor     edi, 0FFFFFFFFh
                or      edi, eax
                add     edx, [esi+1Ch]
                xor     edi, ebp
                rol     eax, 0Ah
                lea     edx, [edx+edi+50A28BE6h]
                mov     edi, eax
                rol     edx, 9
                add     edx, ecx
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     ecx, [esi]
                xor     edi, edx
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+50A28BE6h]
                mov     edi, ebp
                rol     ecx, 0Bh
                add     ecx, ebx
                xor     edi, 0FFFFFFFFh
                or      edi, edx
                add     ebx, [esi+24h]
                xor     edi, ecx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+50A28BE6h]
                mov     edi, edx
                rol     ebx, 0Dh
                add     ebx, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ecx
                add     eax, [esi+8]
                xor     edi, ebx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+50A28BE6h]
                mov     edi, ecx
                rol     eax, 0Fh
                add     eax, ebp
                xor     edi, 0FFFFFFFFh
                or      edi, ebx
                add     ebp, [esi+2Ch]
                xor     edi, eax
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+50A28BE6h]
                mov     edi, ebx
                rol     ebp, 0Fh
                add     ebp, edx
                xor     edi, 0FFFFFFFFh
                or      edi, eax
                add     edx, [esi+10h]
                xor     edi, ebp
                rol     eax, 0Ah
                lea     edx, [edx+edi+50A28BE6h]
                mov     edi, eax
                rol     edx, 5
                add     edx, ecx
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     ecx, [esi+34h]
                xor     edi, edx
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+50A28BE6h]
                mov     edi, ebp
                rol     ecx, 7
                add     ecx, ebx
                xor     edi, 0FFFFFFFFh
                or      edi, edx
                add     ebx, [esi+18h]
                xor     edi, ecx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+50A28BE6h]
                mov     edi, edx
                rol     ebx, 7
                add     ebx, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ecx
                add     eax, [esi+3Ch]
                xor     edi, ebx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+50A28BE6h]
                mov     edi, ecx
                rol     eax, 8
                add     eax, ebp
                xor     edi, 0FFFFFFFFh
                or      edi, ebx
                add     ebp, [esi+20h]
                xor     edi, eax
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+50A28BE6h]
                mov     edi, ebx
                rol     ebp, 0Bh
                add     ebp, edx
                xor     edi, 0FFFFFFFFh
                or      edi, eax
                add     edx, [esi+4]
                xor     edi, ebp
                rol     eax, 0Ah
                lea     edx, [edx+edi+50A28BE6h]
                mov     edi, eax
                rol     edx, 0Eh
                add     edx, ecx
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     ecx, [esi+28h]
                xor     edi, edx
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+50A28BE6h]
                mov     edi, ebp
                rol     ecx, 0Eh
                add     ecx, ebx
                xor     edi, 0FFFFFFFFh
                or      edi, edx
                add     ebx, [esi+0Ch]
                xor     edi, ecx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+50A28BE6h]
                mov     edi, edx
                rol     ebx, 0Ch
                add     ebx, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ecx
                add     eax, [esi+30h]
                xor     edi, ebx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+50A28BE6h]
                mov     edi, ecx
                rol     eax, 6
                add     eax, ebp
                mov     edi, ebx
                xor     edi, eax
                and     edi, ecx
                add     ebp, [esi+18h]
                xor     edi, ebx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+5C4DD124h]
                mov     edi, eax
                rol     ebp, 9
                add     ebp, edx
                xor     edi, ebp
                and     edi, ebx
                add     edx, [esi+2Ch]
                xor     edi, eax
                rol     eax, 0Ah
                lea     edx, [edx+edi+5C4DD124h]
                mov     edi, ebp
                rol     edx, 0Dh
                add     edx, ecx
                xor     edi, edx
                and     edi, eax
                add     ecx, [esi+0Ch]
                xor     edi, ebp
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+5C4DD124h]
                mov     edi, edx
                rol     ecx, 0Fh
                add     ecx, ebx
                xor     edi, ecx
                and     edi, ebp
                add     ebx, [esi+1Ch]
                xor     edi, edx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+5C4DD124h]
                mov     edi, ecx
                rol     ebx, 7
                add     ebx, eax
                xor     edi, ebx
                and     edi, edx
                add     eax, [esi]
                xor     edi, ecx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+5C4DD124h]
                mov     edi, ebx
                rol     eax, 0Ch
                add     eax, ebp
                xor     edi, eax
                and     edi, ecx
                add     ebp, [esi+34h]
                xor     edi, ebx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+5C4DD124h]
                mov     edi, eax
                rol     ebp, 8
                add     ebp, edx
                xor     edi, ebp
                and     edi, ebx
                add     edx, [esi+14h]
                xor     edi, eax
                rol     eax, 0Ah
                lea     edx, [edx+edi+5C4DD124h]
                mov     edi, ebp
                rol     edx, 9
                add     edx, ecx
                xor     edi, edx
                and     edi, eax
                add     ecx, [esi+28h]
                xor     edi, ebp
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+5C4DD124h]
                mov     edi, edx
                rol     ecx, 0Bh
                add     ecx, ebx
                xor     edi, ecx
                and     edi, ebp
                add     ebx, [esi+38h]
                xor     edi, edx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+5C4DD124h]
                mov     edi, ecx
                rol     ebx, 7
                add     ebx, eax
                xor     edi, ebx
                and     edi, edx
                add     eax, [esi+3Ch]
                xor     edi, ecx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+5C4DD124h]
                mov     edi, ebx
                rol     eax, 7
                add     eax, ebp
                xor     edi, eax
                and     edi, ecx
                add     ebp, [esi+20h]
                xor     edi, ebx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+5C4DD124h]
                mov     edi, eax
                rol     ebp, 0Ch
                add     ebp, edx
                xor     edi, ebp
                and     edi, ebx
                add     edx, [esi+30h]
                xor     edi, eax
                rol     eax, 0Ah
                lea     edx, [edx+edi+5C4DD124h]
                mov     edi, ebp
                rol     edx, 7
                add     edx, ecx
                xor     edi, edx
                and     edi, eax
                add     ecx, [esi+10h]
                xor     edi, ebp
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+5C4DD124h]
                mov     edi, edx
                rol     ecx, 6
                add     ecx, ebx
                xor     edi, ecx
                and     edi, ebp
                add     ebx, [esi+24h]
                xor     edi, edx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+5C4DD124h]
                mov     edi, ecx
                rol     ebx, 0Fh
                add     ebx, eax
                xor     edi, ebx
                and     edi, edx
                add     eax, [esi+4]
                xor     edi, ecx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+5C4DD124h]
                mov     edi, ebx
                rol     eax, 0Dh
                add     eax, ebp
                xor     edi, eax
                and     edi, ecx
                add     ebp, [esi+8]
                xor     edi, ebx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+5C4DD124h]
                mov     edi, eax
                rol     ebp, 0Bh
                add     ebp, edx
                mov     edi, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     edx, [esi+3Ch]
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+6D703EF3h]
                mov     edi, ebp
                rol     edx, 9
                xor     edi, 0FFFFFFFFh
                add     edx, ecx
                or      edi, edx
                add     ecx, [esi+14h]
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+6D703EF3h]
                mov     edi, edx
                rol     ecx, 7
                xor     edi, 0FFFFFFFFh
                add     ecx, ebx
                or      edi, ecx
                add     ebx, [esi+4]
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+6D703EF3h]
                mov     edi, ecx
                rol     ebx, 0Fh
                xor     edi, 0FFFFFFFFh
                add     ebx, eax
                or      edi, ebx
                add     eax, [esi+0Ch]
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+6D703EF3h]
                mov     edi, ebx
                rol     eax, 0Bh
                xor     edi, 0FFFFFFFFh
                add     eax, ebp
                or      edi, eax
                add     ebp, [esi+1Ch]
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+6D703EF3h]
                mov     edi, eax
                rol     ebp, 8
                xor     edi, 0FFFFFFFFh
                add     ebp, edx
                or      edi, ebp
                add     edx, [esi+38h]
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+6D703EF3h]
                mov     edi, ebp
                rol     edx, 6
                xor     edi, 0FFFFFFFFh
                add     edx, ecx
                or      edi, edx
                add     ecx, [esi+18h]
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+6D703EF3h]
                mov     edi, edx
                rol     ecx, 6
                xor     edi, 0FFFFFFFFh
                add     ecx, ebx
                or      edi, ecx
                add     ebx, [esi+24h]
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+6D703EF3h]
                mov     edi, ecx
                rol     ebx, 0Eh
                xor     edi, 0FFFFFFFFh
                add     ebx, eax
                or      edi, ebx
                add     eax, [esi+2Ch]
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+6D703EF3h]
                mov     edi, ebx
                rol     eax, 0Ch
                xor     edi, 0FFFFFFFFh
                add     eax, ebp
                or      edi, eax
                add     ebp, [esi+20h]
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+6D703EF3h]
                mov     edi, eax
                rol     ebp, 0Dh
                xor     edi, 0FFFFFFFFh
                add     ebp, edx
                or      edi, ebp
                add     edx, [esi+30h]
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+6D703EF3h]
                mov     edi, ebp
                rol     edx, 5
                xor     edi, 0FFFFFFFFh
                add     edx, ecx
                or      edi, edx
                add     ecx, [esi+8]
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+6D703EF3h]
                mov     edi, edx
                rol     ecx, 0Eh
                xor     edi, 0FFFFFFFFh
                add     ecx, ebx
                or      edi, ecx
                add     ebx, [esi+28h]
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+6D703EF3h]
                mov     edi, ecx
                rol     ebx, 0Dh
                xor     edi, 0FFFFFFFFh
                add     ebx, eax
                or      edi, ebx
                add     eax, [esi]
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+6D703EF3h]
                mov     edi, ebx
                rol     eax, 0Dh
                xor     edi, 0FFFFFFFFh
                add     eax, ebp
                or      edi, eax
                add     ebp, [esi+10h]
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+6D703EF3h]
                mov     edi, eax
                rol     ebp, 7
                xor     edi, 0FFFFFFFFh
                add     ebp, edx
                or      edi, ebp
                add     edx, [esi+34h]
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+6D703EF3h]
                mov     edi, ebp
                rol     edx, 5
                xor     edi, 0FFFFFFFFh
                add     edx, ecx
                mov     edi, eax
                xor     edi, ebp
                add     ecx, [esi+20h]
                and     edi, edx
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+7A6D76E9h]
                mov     edi, ebp
                rol     ecx, 0Fh
                add     ecx, ebx
                xor     edi, edx
                add     ebx, [esi+18h]
                and     edi, ecx
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+7A6D76E9h]
                mov     edi, edx
                rol     ebx, 5
                add     ebx, eax
                xor     edi, ecx
                add     eax, [esi+10h]
                and     edi, ebx
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+7A6D76E9h]
                mov     edi, ecx
                rol     eax, 8
                add     eax, ebp
                xor     edi, ebx
                add     ebp, [esi+4]
                and     edi, eax
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+7A6D76E9h]
                mov     edi, ebx
                rol     ebp, 0Bh
                add     ebp, edx
                xor     edi, eax
                add     edx, [esi+0Ch]
                and     edi, ebp
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+7A6D76E9h]
                mov     edi, eax
                rol     edx, 0Eh
                add     edx, ecx
                xor     edi, ebp
                add     ecx, [esi+2Ch]
                and     edi, edx
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+7A6D76E9h]
                mov     edi, ebp
                rol     ecx, 0Eh
                add     ecx, ebx
                xor     edi, edx
                add     ebx, [esi+3Ch]
                and     edi, ecx
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+7A6D76E9h]
                mov     edi, edx
                rol     ebx, 6
                add     ebx, eax
                xor     edi, ecx
                add     eax, [esi]
                and     edi, ebx
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+7A6D76E9h]
                mov     edi, ecx
                rol     eax, 0Eh
                add     eax, ebp
                xor     edi, ebx
                add     ebp, [esi+14h]
                and     edi, eax
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+7A6D76E9h]
                mov     edi, ebx
                rol     ebp, 6
                add     ebp, edx
                xor     edi, eax
                add     edx, [esi+30h]
                and     edi, ebp
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+7A6D76E9h]
                mov     edi, eax
                rol     edx, 9
                add     edx, ecx
                xor     edi, ebp
                add     ecx, [esi+8]
                and     edi, edx
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+7A6D76E9h]
                mov     edi, ebp
                rol     ecx, 0Ch
                add     ecx, ebx
                xor     edi, edx
                add     ebx, [esi+34h]
                and     edi, ecx
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+7A6D76E9h]
                mov     edi, edx
                rol     ebx, 9
                add     ebx, eax
                xor     edi, ecx
                add     eax, [esi+24h]
                and     edi, ebx
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+7A6D76E9h]
                mov     edi, ecx
                rol     eax, 0Ch
                add     eax, ebp
                xor     edi, ebx
                add     ebp, [esi+1Ch]
                and     edi, eax
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+7A6D76E9h]
                mov     edi, ebx
                rol     ebp, 5
                add     ebp, edx
                xor     edi, eax
                add     edx, [esi+28h]
                and     edi, ebp
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+7A6D76E9h]
                mov     edi, eax
                rol     edx, 0Fh
                add     edx, ecx
                xor     edi, ebp
                add     ecx, [esi+38h]
                and     edi, edx
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+7A6D76E9h]
                mov     edi, ebp
                rol     ecx, 8
                add     ecx, ebx
                xor     edi, edx
                xor     edi, ecx
                add     ebx, [esi+30h]
                rol     edx, 0Ah
                add     ebx, edi
                mov     edi, edx
                rol     ebx, 8
                add     ebx, eax
                xor     edi, ecx
                xor     edi, ebx
                add     eax, [esi+3Ch]
                rol     ecx, 0Ah
                add     eax, edi
                mov     edi, ecx
                rol     eax, 5
                add     eax, ebp
                xor     edi, ebx
                xor     edi, eax
                add     ebp, [esi+28h]
                rol     ebx, 0Ah
                add     ebp, edi
                mov     edi, ebx
                rol     ebp, 0Ch
                add     ebp, edx
                xor     edi, eax
                xor     edi, ebp
                add     edx, [esi+10h]
                rol     eax, 0Ah
                add     edx, edi
                mov     edi, eax
                rol     edx, 9
                add     edx, ecx
                xor     edi, ebp
                xor     edi, edx
                add     ecx, [esi+4]
                rol     ebp, 0Ah
                add     ecx, edi
                mov     edi, ebp
                rol     ecx, 0Ch
                add     ecx, ebx
                xor     edi, edx
                xor     edi, ecx
                add     ebx, [esi+14h]
                rol     edx, 0Ah
                add     ebx, edi
                mov     edi, edx
                rol     ebx, 5
                add     ebx, eax
                xor     edi, ecx
                xor     edi, ebx
                add     eax, [esi+20h]
                rol     ecx, 0Ah
                add     eax, edi
                mov     edi, ecx
                rol     eax, 0Eh
                add     eax, ebp
                xor     edi, ebx
                xor     edi, eax
                add     ebp, [esi+1Ch]
                rol     ebx, 0Ah
                add     ebp, edi
                mov     edi, ebx
                rol     ebp, 6
                add     ebp, edx
                xor     edi, eax
                xor     edi, ebp
                add     edx, [esi+18h]
                rol     eax, 0Ah
                add     edx, edi
                mov     edi, eax
                rol     edx, 8
                add     edx, ecx
                xor     edi, ebp
                xor     edi, edx
                add     ecx, [esi+8]
                rol     ebp, 0Ah
                add     ecx, edi
                mov     edi, ebp
                rol     ecx, 0Dh
                add     ecx, ebx
                xor     edi, edx
                xor     edi, ecx
                add     ebx, [esi+34h]
                rol     edx, 0Ah
                add     ebx, edi
                mov     edi, edx
                rol     ebx, 6
                add     ebx, eax
                xor     edi, ecx
                xor     edi, ebx
                add     eax, [esi+38h]
                rol     ecx, 0Ah
                add     eax, edi
                mov     edi, ecx
                rol     eax, 5
                add     eax, ebp
                xor     edi, ebx
                xor     edi, eax
                add     ebp, [esi]
                rol     ebx, 0Ah
                add     ebp, edi
                mov     edi, ebx
                rol     ebp, 0Fh
                add     ebp, edx
                xor     edi, eax
                xor     edi, ebp
                add     edx, [esi+0Ch]
                rol     eax, 0Ah
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Dh
                add     edx, ecx
                xor     edi, ebp
                xor     edi, edx
                add     ecx, [esi+24h]
                rol     ebp, 0Ah
                add     ecx, edi
                mov     edi, ebp
                rol     ecx, 0Bh
                add     ecx, ebx
                xor     edi, edx
                xor     edi, ecx
                add     ebx, [esi+2Ch]
                rol     edx, 0Ah
                add     ebx, edi
                mov     edi, edx
                rol     ebx, 0Bh
                add     ebx, eax
                mov     edi, [esp+14h]
                add     edx, [esp+8]
                mov     esi, [edi+4]
                add     ebp, [esp+0Ch]
                add     edx, esi
                mov     esi, [esp+10h]
                add     ecx, [edi]
                mov     [edi], edx
                mov     edx, [edi+8]
                add     eax, esi
                mov     esi, [edi+0Ch]
                add     ebp, edx
                mov     edx, [esp]
                mov     [edi+4], ebp
                add     eax, esi
                mov     esi, [edi+10h]
                add     ebx, edx
                mov     edx, [esp+4]
                mov     [edi+8], eax
                add     ebx, esi
                add     ecx, edx
                mov     [edi+0Ch], ebx
                add     esp, 18h
                mov     [edi+10h], ecx


                pop     ebp
                pop     edi
                pop     esi
                pop     ebx
end;
{$ENDIF}

{$IFDEF THash_RipeMD256_asm}
procedure THash_RipeMD256.DoTransform(Buffer: PLongArray);
asm
                push    ebx
                push    esi
                push    edi
                lea     edi, [eax].THash_RipeMD256.FDigest
                mov     esi, edx
                push    ebp

                mov     eax, [edi]
                mov     ebx, [edi+4]
                push    edi
                mov     ecx, [edi+8]
                mov     edx, [edi+0Ch]
                add     esp, 0FFFFFFE0h
                mov     edi, ecx
                xor     edi, edx
                mov     ebp, [esi]
                xor     edi, ebx
                add     eax, ebp
                add     eax, edi
                mov     edi, ebx
                rol     eax, 0Bh
                xor     edi, ecx
                mov     ebp, [esi+4]
                xor     edi, eax
                add     edx, ebp
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Eh
                xor     edi, ebx
                mov     ebp, [esi+8]
                xor     edi, edx
                add     ecx, ebp
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 0Fh
                xor     edi, eax
                mov     ebp, [esi+0Ch]
                xor     edi, ecx
                add     ebx, ebp
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 0Ch
                xor     edi, edx
                mov     ebp, [esi+10h]
                xor     edi, ebx
                add     eax, ebp
                add     eax, edi
                mov     edi, ebx
                rol     eax, 5
                xor     edi, ecx
                mov     ebp, [esi+14h]
                xor     edi, eax
                add     edx, ebp
                add     edx, edi
                mov     edi, eax
                rol     edx, 8
                xor     edi, ebx
                mov     ebp, [esi+18h]
                xor     edi, edx
                add     ecx, ebp
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 7
                xor     edi, eax
                mov     ebp, [esi+1Ch]
                xor     edi, ecx
                add     ebx, ebp
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 9
                xor     edi, edx
                mov     ebp, [esi+20h]
                xor     edi, ebx
                add     eax, ebp
                add     eax, edi
                mov     edi, ebx
                rol     eax, 0Bh
                xor     edi, ecx
                mov     ebp, [esi+24h]
                xor     edi, eax
                add     edx, ebp
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Dh
                xor     edi, ebx
                mov     ebp, [esi+28h]
                xor     edi, edx
                add     ecx, ebp
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 0Eh
                xor     edi, eax
                mov     ebp, [esi+2Ch]
                xor     edi, ecx
                add     ebx, ebp
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 0Fh
                xor     edi, edx
                mov     ebp, [esi+30h]
                xor     edi, ebx
                add     eax, ebp
                add     eax, edi
                mov     edi, ebx
                rol     eax, 6
                xor     edi, ecx
                mov     ebp, [esi+34h]
                xor     edi, eax
                add     edx, ebp
                add     edx, edi
                mov     edi, eax
                rol     edx, 7
                xor     edi, ebx
                mov     ebp, [esi+38h]
                xor     edi, edx
                add     ecx, ebp
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 9
                xor     edi, eax
                mov     ebp, [esi+3Ch]
                xor     edi, ecx
                add     ebx, ebp
                add     ebx, edi
                rol     ebx, 8
                mov     edi, [esp+20h]
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     ebp, [esi+14h]
                mov     eax, [edi+10h]
                mov     [esp+8], ecx
                mov     ebx, [edi+14h]
                mov     ecx, [edi+18h]
                mov     [esp+0Ch], edx
                mov     edx, [edi+1Ch]
                mov     edi, ecx
                xor     edi, ebx
                lea     eax, [eax+ebp+50A28BE6h]
                and     edi, edx
                mov     ebp, [esi+38h]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 8
                xor     edi, eax
                lea     edx, [edx+ebp+50A28BE6h]
                and     edi, ecx
                mov     ebp, [esi+1Ch]
                xor     edi, ebx
                add     edx, edi
                mov     edi, eax
                rol     edx, 9
                xor     edi, edx
                lea     ecx, [ecx+ebp+50A28BE6h]
                and     edi, ebx
                mov     ebp, [esi]
                xor     edi, eax
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 9
                xor     edi, ecx
                lea     ebx, [ebx+ebp+50A28BE6h]
                and     edi, eax
                mov     ebp, [esi+24h]
                xor     edi, edx
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 0Bh
                xor     edi, ebx
                lea     eax, [eax+ebp+50A28BE6h]
                and     edi, edx
                mov     ebp, [esi+8]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 0Dh
                xor     edi, eax
                lea     edx, [edx+ebp+50A28BE6h]
                and     edi, ecx
                mov     ebp, [esi+2Ch]
                xor     edi, ebx
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Fh
                xor     edi, edx
                lea     ecx, [ecx+ebp+50A28BE6h]
                and     edi, ebx
                mov     ebp, [esi+10h]
                xor     edi, eax
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 0Fh
                xor     edi, ecx
                lea     ebx, [ebx+ebp+50A28BE6h]
                and     edi, eax
                mov     ebp, [esi+34h]
                xor     edi, edx
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 5
                xor     edi, ebx
                lea     eax, [eax+ebp+50A28BE6h]
                and     edi, edx
                mov     ebp, [esi+18h]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 7
                xor     edi, eax
                lea     edx, [edx+ebp+50A28BE6h]
                and     edi, ecx
                mov     ebp, [esi+3Ch]
                xor     edi, ebx
                add     edx, edi
                mov     edi, eax
                rol     edx, 7
                xor     edi, edx
                lea     ecx, [ecx+ebp+50A28BE6h]
                and     edi, ebx
                mov     ebp, [esi+20h]
                xor     edi, eax
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 8
                xor     edi, ecx
                lea     ebx, [ebx+ebp+50A28BE6h]
                and     edi, eax
                mov     ebp, [esi+4]
                xor     edi, edx
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 0Bh
                xor     edi, ebx
                lea     eax, [eax+ebp+50A28BE6h]
                and     edi, edx
                mov     ebp, [esi+28h]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 0Eh
                xor     edi, eax
                lea     edx, [edx+ebp+50A28BE6h]
                and     edi, ecx
                mov     ebp, [esi+0Ch]
                xor     edi, ebx
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Eh
                xor     edi, edx
                lea     ecx, [ecx+ebp+50A28BE6h]
                and     edi, ebx
                mov     ebp, [esi+30h]
                xor     edi, eax
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 0Ch
                xor     edi, ecx
                lea     ebx, [ebx+ebp+50A28BE6h]
                and     edi, eax
                mov     ebp, [esi+1Ch]
                xor     edi, edx
                add     ebx, edi
                rol     ebx, 6
                mov     [esp+14h], ebx
                mov     ebx, [esp+4]
                mov     [esp+1Ch], edx
                mov     [esp+18h], ecx
                mov     edx, [esp]
                mov     ecx, [esp+8]
                mov     [esp+10h], edx
                mov     edx, [esp+0Ch]
                mov     edi, ecx
                xor     edi, edx
                lea     eax, [eax+ebp+5A827999h]
                and     edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, ecx
                add     eax, edi
                mov     edi, [esi+10h]
                rol     eax, 7
                and     ebp, eax
                lea     edx, [edx+edi+5A827999h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+34h]
                rol     edx, 6
                xor     edi, ebx
                lea     ecx, [ecx+ebp+5A827999h]
                and     edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, eax
                add     ecx, edi
                mov     edi, [esi+4]
                rol     ecx, 8
                and     ebp, ecx
                lea     ebx, [ebx+edi+5A827999h]
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                mov     ebp, [esi+28h]
                rol     ebx, 0Dh
                xor     edi, edx
                lea     eax, [eax+ebp+5A827999h]
                and     edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, ecx
                add     eax, edi
                mov     edi, [esi+18h]
                rol     eax, 0Bh
                and     ebp, eax
                lea     edx, [edx+edi+5A827999h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+3Ch]
                rol     edx, 9
                xor     edi, ebx
                lea     ecx, [ecx+ebp+5A827999h]
                and     edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, eax
                add     ecx, edi
                mov     edi, [esi+0Ch]
                rol     ecx, 7
                and     ebp, ecx
                lea     ebx, [ebx+edi+5A827999h]
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                mov     ebp, [esi+30h]
                rol     ebx, 0Fh
                xor     edi, edx
                lea     eax, [eax+ebp+5A827999h]
                and     edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, ecx
                add     eax, edi
                mov     edi, [esi]
                rol     eax, 7
                and     ebp, eax
                lea     edx, [edx+edi+5A827999h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+24h]
                rol     edx, 0Ch
                xor     edi, ebx
                lea     ecx, [ecx+ebp+5A827999h]
                and     edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, eax
                add     ecx, edi
                mov     edi, [esi+14h]
                rol     ecx, 0Fh
                and     ebp, ecx
                lea     ebx, [ebx+edi+5A827999h]
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                mov     ebp, [esi+8]
                rol     ebx, 9
                xor     edi, edx
                lea     eax, [eax+ebp+5A827999h]
                and     edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, ecx
                add     eax, edi
                mov     edi, [esi+38h]
                rol     eax, 0Bh
                and     ebp, eax
                lea     edx, [edx+edi+5A827999h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+2Ch]
                rol     edx, 7
                xor     edi, ebx
                lea     ecx, [ecx+ebp+5A827999h]
                and     edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, eax
                add     ecx, edi
                mov     edi, [esi+20h]
                rol     ecx, 0Dh
                and     ebp, ecx
                lea     ebx, [ebx+edi+5A827999h]
                xor     ebp, eax
                add     ebx, ebp
                mov     ebp, [esi+18h]
                rol     ebx, 0Ch
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     eax, [esp+10h]
                mov     ebx, [esp+14h]
                mov     [esp+8], ecx
                mov     ecx, [esp+18h]
                mov     [esp+0Ch], edx
                mov     edx, [esp+1Ch]
                mov     edi, ecx
                xor     edi, 0FFFFFFFFh
                lea     eax, [eax+ebp+5C4DD124h]
                or      edi, ebx
                mov     ebp, [esi+2Ch]
                xor     edi, edx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 9
                xor     edi, 0FFFFFFFFh
                lea     edx, [edx+ebp+5C4DD124h]
                or      edi, eax
                mov     ebp, [esi+0Ch]
                xor     edi, ecx
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Dh
                xor     edi, 0FFFFFFFFh
                lea     ecx, [ecx+ebp+5C4DD124h]
                or      edi, edx
                mov     ebp, [esi+1Ch]
                xor     edi, ebx
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 0Fh
                xor     edi, 0FFFFFFFFh
                lea     ebx, [ebx+ebp+5C4DD124h]
                or      edi, ecx
                mov     ebp, [esi]
                xor     edi, eax
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 7
                xor     edi, 0FFFFFFFFh
                lea     eax, [eax+ebp+5C4DD124h]
                or      edi, ebx
                mov     ebp, [esi+34h]
                xor     edi, edx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 0Ch
                xor     edi, 0FFFFFFFFh
                lea     edx, [edx+ebp+5C4DD124h]
                or      edi, eax
                mov     ebp, [esi+14h]
                xor     edi, ecx
                add     edx, edi
                mov     edi, eax
                rol     edx, 8
                xor     edi, 0FFFFFFFFh
                lea     ecx, [ecx+ebp+5C4DD124h]
                or      edi, edx
                mov     ebp, [esi+28h]
                xor     edi, ebx
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 9
                xor     edi, 0FFFFFFFFh
                lea     ebx, [ebx+ebp+5C4DD124h]
                or      edi, ecx
                mov     ebp, [esi+38h]
                xor     edi, eax
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 0Bh
                xor     edi, 0FFFFFFFFh
                lea     eax, [eax+ebp+5C4DD124h]
                or      edi, ebx
                mov     ebp, [esi+3Ch]
                xor     edi, edx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 7
                xor     edi, 0FFFFFFFFh
                lea     edx, [edx+ebp+5C4DD124h]
                or      edi, eax
                mov     ebp, [esi+20h]
                xor     edi, ecx
                add     edx, edi
                mov     edi, eax
                rol     edx, 7
                xor     edi, 0FFFFFFFFh
                lea     ecx, [ecx+ebp+5C4DD124h]
                or      edi, edx
                mov     ebp, [esi+30h]
                xor     edi, ebx
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 0Ch
                xor     edi, 0FFFFFFFFh
                lea     ebx, [ebx+ebp+5C4DD124h]
                or      edi, ecx
                mov     ebp, [esi+10h]
                xor     edi, eax
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 7
                xor     edi, 0FFFFFFFFh
                lea     eax, [eax+ebp+5C4DD124h]
                or      edi, ebx
                mov     ebp, [esi+24h]
                xor     edi, edx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 6
                xor     edi, 0FFFFFFFFh
                lea     edx, [edx+ebp+5C4DD124h]
                or      edi, eax
                mov     ebp, [esi+4]
                xor     edi, ecx
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Fh
                xor     edi, 0FFFFFFFFh
                lea     ecx, [ecx+ebp+5C4DD124h]
                or      edi, edx
                mov     ebp, [esi+8]
                xor     edi, ebx
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 0Dh
                xor     edi, 0FFFFFFFFh
                lea     ebx, [ebx+ebp+5C4DD124h]
                or      edi, ecx
                mov     ebp, [esi+0Ch]
                xor     edi, eax
                add     ebx, edi
                rol     ebx, 0Bh
                mov     [esp+10h], eax
                mov     [esp+18h], ecx
                mov     eax, [esp]
                mov     ecx, [esp+8]
                mov     [esp+1Ch], edx
                mov     edx, [esp+4]
                mov     [esp+14h], edx
                mov     edx, [esp+0Ch]
                mov     edi, ecx
                xor     edi, 0FFFFFFFFh
                lea     eax, [eax+ebp+6ED9EBA1h]
                or      edi, ebx
                mov     ebp, [esi+28h]
                xor     edi, edx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 0Bh
                xor     edi, 0FFFFFFFFh
                lea     edx, [edx+ebp+6ED9EBA1h]
                or      edi, eax
                mov     ebp, [esi+38h]
                xor     edi, ecx
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Dh
                xor     edi, 0FFFFFFFFh
                lea     ecx, [ecx+ebp+6ED9EBA1h]
                or      edi, edx
                mov     ebp, [esi+10h]
                xor     edi, ebx
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 6
                xor     edi, 0FFFFFFFFh
                lea     ebx, [ebx+ebp+6ED9EBA1h]
                or      edi, ecx
                mov     ebp, [esi+24h]
                xor     edi, eax
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 7
                xor     edi, 0FFFFFFFFh
                lea     eax, [eax+ebp+6ED9EBA1h]
                or      edi, ebx
                mov     ebp, [esi+3Ch]
                xor     edi, edx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 0Eh
                xor     edi, 0FFFFFFFFh
                lea     edx, [edx+ebp+6ED9EBA1h]
                or      edi, eax
                mov     ebp, [esi+20h]
                xor     edi, ecx
                add     edx, edi
                mov     edi, eax
                rol     edx, 9
                xor     edi, 0FFFFFFFFh
                lea     ecx, [ecx+ebp+6ED9EBA1h]
                or      edi, edx
                mov     ebp, [esi+4]
                xor     edi, ebx
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 0Dh
                xor     edi, 0FFFFFFFFh
                lea     ebx, [ebx+ebp+6ED9EBA1h]
                or      edi, ecx
                mov     ebp, [esi+8]
                xor     edi, eax
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 0Fh
                xor     edi, 0FFFFFFFFh
                lea     eax, [eax+ebp+6ED9EBA1h]
                or      edi, ebx
                mov     ebp, [esi+1Ch]
                xor     edi, edx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 0Eh
                xor     edi, 0FFFFFFFFh
                lea     edx, [edx+ebp+6ED9EBA1h]
                or      edi, eax
                mov     ebp, [esi]
                xor     edi, ecx
                add     edx, edi
                mov     edi, eax
                rol     edx, 8
                xor     edi, 0FFFFFFFFh
                lea     ecx, [ecx+ebp+6ED9EBA1h]
                or      edi, edx
                mov     ebp, [esi+18h]
                xor     edi, ebx
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 0Dh
                xor     edi, 0FFFFFFFFh
                lea     ebx, [ebx+ebp+6ED9EBA1h]
                or      edi, ecx
                mov     ebp, [esi+34h]
                xor     edi, eax
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 6
                xor     edi, 0FFFFFFFFh
                lea     eax, [eax+ebp+6ED9EBA1h]
                or      edi, ebx
                mov     ebp, [esi+2Ch]
                xor     edi, edx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 5
                xor     edi, 0FFFFFFFFh
                lea     edx, [edx+ebp+6ED9EBA1h]
                or      edi, eax
                mov     ebp, [esi+14h]
                xor     edi, ecx
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Ch
                xor     edi, 0FFFFFFFFh
                lea     ecx, [ecx+ebp+6ED9EBA1h]
                or      edi, edx
                mov     ebp, [esi+30h]
                xor     edi, ebx
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 7
                xor     edi, 0FFFFFFFFh
                lea     ebx, [ebx+ebp+6ED9EBA1h]
                or      edi, ecx
                mov     ebp, [esi+3Ch]
                xor     edi, eax
                add     ebx, edi
                rol     ebx, 5
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     eax, [esp+10h]
                mov     ebx, [esp+14h]
                mov     [esp+8], ecx
                mov     ecx, [esp+18h]
                mov     [esp+0Ch], edx
                mov     edx, [esp+1Ch]
                mov     edi, ecx
                xor     edi, edx
                lea     eax, [eax+ebp+6D703EF3h]
                and     edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, ecx
                add     eax, edi
                mov     edi, [esi+14h]
                rol     eax, 9
                and     ebp, eax
                lea     edx, [edx+edi+6D703EF3h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+4]
                rol     edx, 7
                xor     edi, ebx
                lea     ecx, [ecx+ebp+6D703EF3h]
                and     edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, eax
                add     ecx, edi
                mov     edi, [esi+0Ch]
                rol     ecx, 0Fh
                and     ebp, ecx
                lea     ebx, [ebx+edi+6D703EF3h]
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                mov     ebp, [esi+1Ch]
                rol     ebx, 0Bh
                xor     edi, edx
                lea     eax, [eax+ebp+6D703EF3h]
                and     edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, ecx
                add     eax, edi
                mov     edi, [esi+38h]
                rol     eax, 8
                and     ebp, eax
                lea     edx, [edx+edi+6D703EF3h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+18h]
                rol     edx, 6
                xor     edi, ebx
                lea     ecx, [ecx+ebp+6D703EF3h]
                and     edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, eax
                add     ecx, edi
                mov     edi, [esi+24h]
                rol     ecx, 6
                and     ebp, ecx
                lea     ebx, [ebx+edi+6D703EF3h]
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                mov     ebp, [esi+2Ch]
                rol     ebx, 0Eh
                xor     edi, edx
                lea     eax, [eax+ebp+6D703EF3h]
                and     edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, ecx
                add     eax, edi
                mov     edi, [esi+20h]
                rol     eax, 0Ch
                and     ebp, eax
                lea     edx, [edx+edi+6D703EF3h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+30h]
                rol     edx, 0Dh
                xor     edi, ebx
                lea     ecx, [ecx+ebp+6D703EF3h]
                and     edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, eax
                add     ecx, edi
                mov     edi, [esi+8]
                rol     ecx, 5
                and     ebp, ecx
                lea     ebx, [ebx+edi+6D703EF3h]
                xor     ebp, eax
                mov     edi, ecx
                add     ebx, ebp
                mov     ebp, [esi+28h]
                rol     ebx, 0Eh
                xor     edi, edx
                lea     eax, [eax+ebp+6D703EF3h]
                and     edi, ebx
                mov     ebp, ebx
                xor     edi, edx
                xor     ebp, ecx
                add     eax, edi
                mov     edi, [esi]
                rol     eax, 0Dh
                and     ebp, eax
                lea     edx, [edx+edi+6D703EF3h]
                xor     ebp, ecx
                mov     edi, eax
                add     edx, ebp
                mov     ebp, [esi+10h]
                rol     edx, 0Dh
                xor     edi, ebx
                lea     ecx, [ecx+ebp+6D703EF3h]
                and     edi, edx
                mov     ebp, edx
                xor     edi, ebx
                xor     ebp, eax
                add     ecx, edi
                mov     edi, [esi+34h]
                rol     ecx, 7
                and     ebp, ecx
                lea     ebx, [ebx+edi+6D703EF3h]
                xor     ebp, eax
                add     ebx, ebp
                mov     ebp, [esi+4]
                rol     ebx, 5
                mov     [esp+10h], eax
                mov     [esp+14h], ebx
                mov     eax, [esp]
                mov     ebx, [esp+4]
                mov     [esp+1Ch], edx
                mov     edx, [esp+8]
                mov     [esp+18h], edx
                mov     edx, [esp+0Ch]
                mov     edi, ecx
                xor     edi, ebx
                lea     eax, [eax+ebp-70E44324h]
                and     edi, edx
                mov     ebp, [esi+24h]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 0Bh
                xor     edi, eax
                lea     edx, [edx+ebp-70E44324h]
                and     edi, ecx
                mov     ebp, [esi+2Ch]
                xor     edi, ebx
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Ch
                xor     edi, edx
                lea     ecx, [ecx+ebp-70E44324h]
                and     edi, ebx
                mov     ebp, [esi+28h]
                xor     edi, eax
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 0Eh
                xor     edi, ecx
                lea     ebx, [ebx+ebp-70E44324h]
                and     edi, eax
                mov     ebp, [esi]
                xor     edi, edx
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 0Fh
                xor     edi, ebx
                lea     eax, [eax+ebp-70E44324h]
                and     edi, edx
                mov     ebp, [esi+20h]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 0Eh
                xor     edi, eax
                lea     edx, [edx+ebp-70E44324h]
                and     edi, ecx
                mov     ebp, [esi+30h]
                xor     edi, ebx
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Fh
                xor     edi, edx
                lea     ecx, [ecx+ebp-70E44324h]
                and     edi, ebx
                mov     ebp, [esi+10h]
                xor     edi, eax
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 9
                xor     edi, ecx
                lea     ebx, [ebx+ebp-70E44324h]
                and     edi, eax
                mov     ebp, [esi+34h]
                xor     edi, edx
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 8
                xor     edi, ebx
                lea     eax, [eax+ebp-70E44324h]
                and     edi, edx
                mov     ebp, [esi+0Ch]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 9
                xor     edi, eax
                lea     edx, [edx+ebp-70E44324h]
                and     edi, ecx
                mov     ebp, [esi+1Ch]
                xor     edi, ebx
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Eh
                xor     edi, edx
                lea     ecx, [ecx+ebp-70E44324h]
                and     edi, ebx
                mov     ebp, [esi+3Ch]
                xor     edi, eax
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 5
                xor     edi, ecx
                lea     ebx, [ebx+ebp-70E44324h]
                and     edi, eax
                mov     ebp, [esi+38h]
                xor     edi, edx
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 6
                xor     edi, ebx
                lea     eax, [eax+ebp-70E44324h]
                and     edi, edx
                mov     ebp, [esi+14h]
                xor     edi, ecx
                add     eax, edi
                mov     edi, ebx
                rol     eax, 8
                xor     edi, eax
                lea     edx, [edx+ebp-70E44324h]
                and     edi, ecx
                mov     ebp, [esi+18h]
                xor     edi, ebx
                add     edx, edi
                mov     edi, eax
                rol     edx, 6
                xor     edi, edx
                lea     ecx, [ecx+ebp-70E44324h]
                and     edi, ebx
                mov     ebp, [esi+8]
                xor     edi, eax
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 5
                xor     edi, ecx
                lea     ebx, [ebx+ebp-70E44324h]
                and     edi, eax
                mov     ebp, [esi+20h]
                xor     edi, edx
                add     ebx, edi
                rol     ebx, 0Ch
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     eax, [esp+10h]
                mov     ebx, [esp+14h]
                mov     [esp+8], ecx
                mov     ecx, [esp+18h]
                mov     edi, ecx
                mov     [esp+0Ch], edx
                mov     edx, [esp+1Ch]
                xor     edi, edx
                mov     ebp, [esi+20h]
                xor     edi, ebx
                add     eax, ebp
                add     eax, edi
                mov     edi, ebx
                rol     eax, 0Fh
                xor     edi, ecx
                mov     ebp, [esi+18h]
                xor     edi, eax
                add     edx, ebp
                add     edx, edi
                mov     edi, eax
                rol     edx, 5
                xor     edi, ebx
                mov     ebp, [esi+10h]
                xor     edi, edx
                add     ecx, ebp
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 8
                xor     edi, eax
                mov     ebp, [esi+4]
                xor     edi, ecx
                add     ebx, ebp
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 0Bh
                xor     edi, edx
                mov     ebp, [esi+0Ch]
                xor     edi, ebx
                add     eax, ebp
                add     eax, edi
                mov     edi, ebx
                rol     eax, 0Eh
                xor     edi, ecx
                mov     ebp, [esi+2Ch]
                xor     edi, eax
                add     edx, ebp
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Eh
                xor     edi, ebx
                mov     ebp, [esi+3Ch]
                xor     edi, edx
                add     ecx, ebp
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 6
                xor     edi, eax
                mov     ebp, [esi]
                xor     edi, ecx
                add     ebx, ebp
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 0Eh
                xor     edi, edx
                mov     ebp, [esi+14h]
                xor     edi, ebx
                add     eax, ebp
                add     eax, edi
                mov     edi, ebx
                rol     eax, 6
                xor     edi, ecx
                mov     ebp, [esi+30h]
                xor     edi, eax
                add     edx, ebp
                add     edx, edi
                mov     edi, eax
                rol     edx, 9
                xor     edi, ebx
                mov     ebp, [esi+8]
                xor     edi, edx
                add     ecx, ebp
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 0Ch
                xor     edi, eax
                mov     ebp, [esi+34h]
                xor     edi, ecx
                add     ebx, ebp
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 9
                xor     edi, edx
                mov     ebp, [esi+24h]
                xor     edi, ebx
                add     eax, ebp
                add     eax, edi
                mov     edi, ebx
                rol     eax, 0Ch
                xor     edi, ecx
                mov     ebp, [esi+1Ch]
                xor     edi, eax
                add     edx, ebp
                add     edx, edi
                mov     edi, eax
                rol     edx, 5
                xor     edi, ebx
                mov     ebp, [esi+28h]
                xor     edi, edx
                add     ecx, ebp
                add     ecx, edi
                mov     edi, edx
                rol     ecx, 0Fh
                xor     edi, eax
                mov     ebp, [esi+38h]
                xor     edi, ecx
                add     ebx, ebp
                add     ebx, edi
                mov     edi, ecx
                rol     ebx, 8
                mov     edi, [esp+20h]
                add     [edi+0Ch], edx
                add     [edi+10h], eax
                add     [edi+14h], ebx
                mov     eax, [esp]
                mov     ebx, [esp+4]
                add     [edi+18h], ecx
                mov     ecx, [esp+8]
                mov     edx, [esp+0Ch]
                add     [edi], eax
                add     esp, 24h
                add     [edi+4], ebx
                add     [edi+8], ecx
                add     [edi+1Ch], edx


                pop     ebp
                pop     edi
                pop     esi
                pop     ebx
end;
{$ENDIF}

{$IFDEF THash_RipeMD320_asm}
procedure THash_RipeMD320.DoTransform(Buffer: PLongArray);
asm
                push    ebx
                push    esi
                push    edi
                lea     edi, [eax].THash_RipeMD320.FDigest
                mov     esi, edx
                push    ebp
                mov     eax, [edi]
                mov     ebx, [edi+4]
                push    edi
                mov     ecx, [edi+8]
                mov     edx, [edi+0Ch]
                add     esp, 0FFFFFFD8h
                mov     ebp, [edi+10h]
                mov     edi, edx
                xor     edi, ecx
                xor     edi, ebx
                add     eax, [esi]
                rol     ecx, 0Ah
                add     eax, edi
                mov     edi, ecx
                rol     eax, 0Bh
                add     eax, ebp
                xor     edi, ebx
                xor     edi, eax
                add     ebp, [esi+4]
                rol     ebx, 0Ah
                add     ebp, edi
                mov     edi, ebx
                rol     ebp, 0Eh
                add     ebp, edx
                xor     edi, eax
                xor     edi, ebp
                add     edx, [esi+8]
                rol     eax, 0Ah
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Fh
                add     edx, ecx
                xor     edi, ebp
                xor     edi, edx
                add     ecx, [esi+0Ch]
                rol     ebp, 0Ah
                add     ecx, edi
                mov     edi, ebp
                rol     ecx, 0Ch
                add     ecx, ebx
                xor     edi, edx
                xor     edi, ecx
                add     ebx, [esi+10h]
                rol     edx, 0Ah
                add     ebx, edi
                mov     edi, edx
                rol     ebx, 5
                add     ebx, eax
                xor     edi, ecx
                xor     edi, ebx
                add     eax, [esi+14h]
                rol     ecx, 0Ah
                add     eax, edi
                mov     edi, ecx
                rol     eax, 8
                add     eax, ebp
                xor     edi, ebx
                xor     edi, eax
                add     ebp, [esi+18h]
                rol     ebx, 0Ah
                add     ebp, edi
                mov     edi, ebx
                rol     ebp, 7
                add     ebp, edx
                xor     edi, eax
                xor     edi, ebp
                add     edx, [esi+1Ch]
                rol     eax, 0Ah
                add     edx, edi
                mov     edi, eax
                rol     edx, 9
                add     edx, ecx
                xor     edi, ebp
                xor     edi, edx
                add     ecx, [esi+20h]
                rol     ebp, 0Ah
                add     ecx, edi
                mov     edi, ebp
                rol     ecx, 0Bh
                add     ecx, ebx
                xor     edi, edx
                xor     edi, ecx
                add     ebx, [esi+24h]
                rol     edx, 0Ah
                add     ebx, edi
                mov     edi, edx
                rol     ebx, 0Dh
                add     ebx, eax
                xor     edi, ecx
                xor     edi, ebx
                add     eax, [esi+28h]
                rol     ecx, 0Ah
                add     eax, edi
                mov     edi, ecx
                rol     eax, 0Eh
                add     eax, ebp
                xor     edi, ebx
                xor     edi, eax
                add     ebp, [esi+2Ch]
                rol     ebx, 0Ah
                add     ebp, edi
                mov     edi, ebx
                rol     ebp, 0Fh
                add     ebp, edx
                xor     edi, eax
                xor     edi, ebp
                add     edx, [esi+30h]
                rol     eax, 0Ah
                add     edx, edi
                mov     edi, eax
                rol     edx, 6
                add     edx, ecx
                xor     edi, ebp
                xor     edi, edx
                add     ecx, [esi+34h]
                rol     ebp, 0Ah
                add     ecx, edi
                mov     edi, ebp
                rol     ecx, 7
                add     ecx, ebx
                xor     edi, edx
                xor     edi, ecx
                add     ebx, [esi+38h]
                rol     edx, 0Ah
                add     ebx, edi
                mov     edi, edx
                rol     ebx, 9
                add     ebx, eax
                xor     edi, ecx
                xor     edi, ebx
                add     eax, [esi+3Ch]
                rol     ecx, 0Ah
                add     eax, edi
                rol     eax, 8
                add     eax, ebp
                mov     edi, [esp+28h]
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     eax, [edi+14h]
                mov     ebx, [edi+18h]
                mov     [esp+8], ecx
                mov     [esp+0Ch], edx
                mov     ecx, [edi+1Ch]
                mov     edx, [edi+20h]
                mov     [esp+10h], ebp
                mov     ebp, [edi+24h]
                mov     edi, edx
                xor     edi, 0FFFFFFFFh
                or      edi, ecx
                add     eax, [esi+14h]
                xor     edi, ebx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+50A28BE6h]
                mov     edi, ecx
                rol     eax, 8
                add     eax, ebp
                xor     edi, 0FFFFFFFFh
                or      edi, ebx
                add     ebp, [esi+38h]
                xor     edi, eax
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+50A28BE6h]
                mov     edi, ebx
                rol     ebp, 9
                add     ebp, edx
                xor     edi, 0FFFFFFFFh
                or      edi, eax
                add     edx, [esi+1Ch]
                xor     edi, ebp
                rol     eax, 0Ah
                lea     edx, [edx+edi+50A28BE6h]
                mov     edi, eax
                rol     edx, 9
                add     edx, ecx
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     ecx, [esi]
                xor     edi, edx
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+50A28BE6h]
                mov     edi, ebp
                rol     ecx, 0Bh
                add     ecx, ebx
                xor     edi, 0FFFFFFFFh
                or      edi, edx
                add     ebx, [esi+24h]
                xor     edi, ecx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+50A28BE6h]
                mov     edi, edx
                rol     ebx, 0Dh
                add     ebx, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ecx
                add     eax, [esi+8]
                xor     edi, ebx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+50A28BE6h]
                mov     edi, ecx
                rol     eax, 0Fh
                add     eax, ebp
                xor     edi, 0FFFFFFFFh
                or      edi, ebx
                add     ebp, [esi+2Ch]
                xor     edi, eax
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+50A28BE6h]
                mov     edi, ebx
                rol     ebp, 0Fh
                add     ebp, edx
                xor     edi, 0FFFFFFFFh
                or      edi, eax
                add     edx, [esi+10h]
                xor     edi, ebp
                rol     eax, 0Ah
                lea     edx, [edx+edi+50A28BE6h]
                mov     edi, eax
                rol     edx, 5
                add     edx, ecx
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     ecx, [esi+34h]
                xor     edi, edx
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+50A28BE6h]
                mov     edi, ebp
                rol     ecx, 7
                add     ecx, ebx
                xor     edi, 0FFFFFFFFh
                or      edi, edx
                add     ebx, [esi+18h]
                xor     edi, ecx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+50A28BE6h]
                mov     edi, edx
                rol     ebx, 7
                add     ebx, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ecx
                add     eax, [esi+3Ch]
                xor     edi, ebx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+50A28BE6h]
                mov     edi, ecx
                rol     eax, 8
                add     eax, ebp
                xor     edi, 0FFFFFFFFh
                or      edi, ebx
                add     ebp, [esi+20h]
                xor     edi, eax
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+50A28BE6h]
                mov     edi, ebx
                rol     ebp, 0Bh
                add     ebp, edx
                xor     edi, 0FFFFFFFFh
                or      edi, eax
                add     edx, [esi+4]
                xor     edi, ebp
                rol     eax, 0Ah
                lea     edx, [edx+edi+50A28BE6h]
                mov     edi, eax
                rol     edx, 0Eh
                add     edx, ecx
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     ecx, [esi+28h]
                xor     edi, edx
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+50A28BE6h]
                mov     edi, ebp
                rol     ecx, 0Eh
                add     ecx, ebx
                xor     edi, 0FFFFFFFFh
                or      edi, edx
                add     ebx, [esi+0Ch]
                xor     edi, ecx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+50A28BE6h]
                mov     edi, edx
                rol     ebx, 0Ch
                add     ebx, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ecx
                add     eax, [esi+30h]
                xor     edi, ebx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+50A28BE6h]
                rol     eax, 6
                add     eax, ebp
                mov     [esp+18h], ebx
                mov     [esp+1Ch], ecx
                mov     ebx, [esp+4]
                mov     ecx, [esp+8]
                mov     [esp+20h], edx
                mov     [esp+24h], ebp
                mov     edx, [esp+0Ch]
                mov     ebp, [esp]
                mov     [esp+14h], ebp
                mov     ebp, [esp+10h]
                mov     edi, ecx
                xor     edi, ebx
                add     ebp, [esi+1Ch]
                and     edi, eax
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+5A827999h]
                mov     edi, ebx
                rol     ebp, 7
                add     ebp, edx
                xor     edi, eax
                add     edx, [esi+10h]
                and     edi, ebp
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+5A827999h]
                mov     edi, eax
                rol     edx, 6
                add     edx, ecx
                xor     edi, ebp
                add     ecx, [esi+34h]
                and     edi, edx
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+5A827999h]
                mov     edi, ebp
                rol     ecx, 8
                add     ecx, ebx
                xor     edi, edx
                add     ebx, [esi+4]
                and     edi, ecx
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+5A827999h]
                mov     edi, edx
                rol     ebx, 0Dh
                add     ebx, eax
                xor     edi, ecx
                add     eax, [esi+28h]
                and     edi, ebx
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+5A827999h]
                mov     edi, ecx
                rol     eax, 0Bh
                add     eax, ebp
                xor     edi, ebx
                add     ebp, [esi+18h]
                and     edi, eax
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+5A827999h]
                mov     edi, ebx
                rol     ebp, 9
                add     ebp, edx
                xor     edi, eax
                add     edx, [esi+3Ch]
                and     edi, ebp
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+5A827999h]
                mov     edi, eax
                rol     edx, 7
                add     edx, ecx
                xor     edi, ebp
                add     ecx, [esi+0Ch]
                and     edi, edx
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+5A827999h]
                mov     edi, ebp
                rol     ecx, 0Fh
                add     ecx, ebx
                xor     edi, edx
                add     ebx, [esi+30h]
                and     edi, ecx
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+5A827999h]
                mov     edi, edx
                rol     ebx, 7
                add     ebx, eax
                xor     edi, ecx
                add     eax, [esi]
                and     edi, ebx
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+5A827999h]
                mov     edi, ecx
                rol     eax, 0Ch
                add     eax, ebp
                xor     edi, ebx
                add     ebp, [esi+24h]
                and     edi, eax
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+5A827999h]
                mov     edi, ebx
                rol     ebp, 0Fh
                add     ebp, edx
                xor     edi, eax
                add     edx, [esi+14h]
                and     edi, ebp
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+5A827999h]
                mov     edi, eax
                rol     edx, 9
                add     edx, ecx
                xor     edi, ebp
                add     ecx, [esi+8]
                and     edi, edx
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+5A827999h]
                mov     edi, ebp
                rol     ecx, 0Bh
                add     ecx, ebx
                xor     edi, edx
                add     ebx, [esi+38h]
                and     edi, ecx
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+5A827999h]
                mov     edi, edx
                rol     ebx, 7
                add     ebx, eax
                xor     edi, ecx
                add     eax, [esi+2Ch]
                and     edi, ebx
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+5A827999h]
                mov     edi, ecx
                rol     eax, 0Dh
                add     eax, ebp
                xor     edi, ebx
                add     ebp, [esi+20h]
                and     edi, eax
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+5A827999h]
                rol     ebp, 0Ch
                add     ebp, edx
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     eax, [esp+14h]
                mov     ebx, [esp+18h]
                mov     [esp+8], ecx
                mov     [esp+0Ch], edx
                mov     ecx, [esp+1Ch]
                mov     edx, [esp+20h]
                mov     [esp+10h], ebp
                mov     ebp, [esp+24h]
                mov     edi, ebx
                xor     edi, eax
                and     edi, ecx
                add     ebp, [esi+18h]
                xor     edi, ebx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+5C4DD124h]
                mov     edi, eax
                rol     ebp, 9
                add     ebp, edx
                xor     edi, ebp
                and     edi, ebx
                add     edx, [esi+2Ch]
                xor     edi, eax
                rol     eax, 0Ah
                lea     edx, [edx+edi+5C4DD124h]
                mov     edi, ebp
                rol     edx, 0Dh
                add     edx, ecx
                xor     edi, edx
                and     edi, eax
                add     ecx, [esi+0Ch]
                xor     edi, ebp
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+5C4DD124h]
                mov     edi, edx
                rol     ecx, 0Fh
                add     ecx, ebx
                xor     edi, ecx
                and     edi, ebp
                add     ebx, [esi+1Ch]
                xor     edi, edx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+5C4DD124h]
                mov     edi, ecx
                rol     ebx, 7
                add     ebx, eax
                xor     edi, ebx
                and     edi, edx
                add     eax, [esi]
                xor     edi, ecx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+5C4DD124h]
                mov     edi, ebx
                rol     eax, 0Ch
                add     eax, ebp
                xor     edi, eax
                and     edi, ecx
                add     ebp, [esi+34h]
                xor     edi, ebx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+5C4DD124h]
                mov     edi, eax
                rol     ebp, 8
                add     ebp, edx
                xor     edi, ebp
                and     edi, ebx
                add     edx, [esi+14h]
                xor     edi, eax
                rol     eax, 0Ah
                lea     edx, [edx+edi+5C4DD124h]
                mov     edi, ebp
                rol     edx, 9
                add     edx, ecx
                xor     edi, edx
                and     edi, eax
                add     ecx, [esi+28h]
                xor     edi, ebp
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+5C4DD124h]
                mov     edi, edx
                rol     ecx, 0Bh
                add     ecx, ebx
                xor     edi, ecx
                and     edi, ebp
                add     ebx, [esi+38h]
                xor     edi, edx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+5C4DD124h]
                mov     edi, ecx
                rol     ebx, 7
                add     ebx, eax
                xor     edi, ebx
                and     edi, edx
                add     eax, [esi+3Ch]
                xor     edi, ecx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+5C4DD124h]
                mov     edi, ebx
                rol     eax, 7
                add     eax, ebp
                xor     edi, eax
                and     edi, ecx
                add     ebp, [esi+20h]
                xor     edi, ebx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+5C4DD124h]
                mov     edi, eax
                rol     ebp, 0Ch
                add     ebp, edx
                xor     edi, ebp
                and     edi, ebx
                add     edx, [esi+30h]
                xor     edi, eax
                rol     eax, 0Ah
                lea     edx, [edx+edi+5C4DD124h]
                mov     edi, ebp
                rol     edx, 7
                add     edx, ecx
                xor     edi, edx
                and     edi, eax
                add     ecx, [esi+10h]
                xor     edi, ebp
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+5C4DD124h]
                mov     edi, edx
                rol     ecx, 6
                add     ecx, ebx
                xor     edi, ecx
                and     edi, ebp
                add     ebx, [esi+24h]
                xor     edi, edx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+5C4DD124h]
                mov     edi, ecx
                rol     ebx, 0Fh
                add     ebx, eax
                xor     edi, ebx
                and     edi, edx
                add     eax, [esi+4]
                xor     edi, ecx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+5C4DD124h]
                mov     edi, ebx
                rol     eax, 0Dh
                add     eax, ebp
                xor     edi, eax
                and     edi, ecx
                add     ebp, [esi+8]
                xor     edi, ebx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+5C4DD124h]
                rol     ebp, 0Bh
                add     ebp, edx
                mov     [esp+14h], eax
                mov     [esp+1Ch], ecx
                mov     eax, [esp]
                mov     ecx, [esp+8]
                mov     [esp+20h], edx
                mov     [esp+24h], ebp
                mov     edx, [esp+0Ch]
                mov     ebp, [esp+4]
                mov     [esp+18h], ebp
                mov     ebp, [esp+10h]
                mov     edi, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     edx, [esi+0Ch]
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+6ED9EBA1h]
                mov     edi, ebp
                rol     edx, 0Bh
                add     edx, ecx
                xor     edi, 0FFFFFFFFh
                or      edi, edx
                add     ecx, [esi+28h]
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+6ED9EBA1h]
                mov     edi, edx
                rol     ecx, 0Dh
                add     ecx, ebx
                xor     edi, 0FFFFFFFFh
                or      edi, ecx
                add     ebx, [esi+38h]
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+6ED9EBA1h]
                mov     edi, ecx
                rol     ebx, 6
                add     ebx, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ebx
                add     eax, [esi+10h]
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+6ED9EBA1h]
                mov     edi, ebx
                rol     eax, 7
                add     eax, ebp
                xor     edi, 0FFFFFFFFh
                or      edi, eax
                add     ebp, [esi+24h]
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+6ED9EBA1h]
                mov     edi, eax
                rol     ebp, 0Eh
                add     ebp, edx
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     edx, [esi+3Ch]
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+6ED9EBA1h]
                mov     edi, ebp
                rol     edx, 9
                add     edx, ecx
                xor     edi, 0FFFFFFFFh
                or      edi, edx
                add     ecx, [esi+20h]
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+6ED9EBA1h]
                mov     edi, edx
                rol     ecx, 0Dh
                add     ecx, ebx
                xor     edi, 0FFFFFFFFh
                or      edi, ecx
                add     ebx, [esi+4]
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+6ED9EBA1h]
                mov     edi, ecx
                rol     ebx, 0Fh
                add     ebx, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ebx
                add     eax, [esi+8]
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+6ED9EBA1h]
                mov     edi, ebx
                rol     eax, 0Eh
                add     eax, ebp
                xor     edi, 0FFFFFFFFh
                or      edi, eax
                add     ebp, [esi+1Ch]
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+6ED9EBA1h]
                mov     edi, eax
                rol     ebp, 8
                add     ebp, edx
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     edx, [esi]
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+6ED9EBA1h]
                mov     edi, ebp
                rol     edx, 0Dh
                add     edx, ecx
                xor     edi, 0FFFFFFFFh
                or      edi, edx
                add     ecx, [esi+18h]
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+6ED9EBA1h]
                mov     edi, edx
                rol     ecx, 6
                add     ecx, ebx
                xor     edi, 0FFFFFFFFh
                or      edi, ecx
                add     ebx, [esi+34h]
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+6ED9EBA1h]
                mov     edi, ecx
                rol     ebx, 5
                add     ebx, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ebx
                add     eax, [esi+2Ch]
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+6ED9EBA1h]
                mov     edi, ebx
                rol     eax, 0Ch
                add     eax, ebp
                xor     edi, 0FFFFFFFFh
                or      edi, eax
                add     ebp, [esi+14h]
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+6ED9EBA1h]
                mov     edi, eax
                rol     ebp, 7
                add     ebp, edx
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     edx, [esi+30h]
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+6ED9EBA1h]
                rol     edx, 5
                add     edx, ecx
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     eax, [esp+14h]
                mov     ebx, [esp+18h]
                mov     [esp+8], ecx
                mov     [esp+0Ch], edx
                mov     ecx, [esp+1Ch]
                mov     edx, [esp+20h]
                mov     [esp+10h], ebp
                mov     ebp, [esp+24h]
                mov     edi, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     edx, [esi+3Ch]
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+6D703EF3h]
                mov     edi, ebp
                rol     edx, 9
                add     edx, ecx
                xor     edi, 0FFFFFFFFh
                or      edi, edx
                add     ecx, [esi+14h]
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+6D703EF3h]
                mov     edi, edx
                rol     ecx, 7
                add     ecx, ebx
                xor     edi, 0FFFFFFFFh
                or      edi, ecx
                add     ebx, [esi+4]
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+6D703EF3h]
                mov     edi, ecx
                rol     ebx, 0Fh
                add     ebx, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ebx
                add     eax, [esi+0Ch]
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+6D703EF3h]
                mov     edi, ebx
                rol     eax, 0Bh
                add     eax, ebp
                xor     edi, 0FFFFFFFFh
                or      edi, eax
                add     ebp, [esi+1Ch]
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+6D703EF3h]
                mov     edi, eax
                rol     ebp, 8
                add     ebp, edx
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     edx, [esi+38h]
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+6D703EF3h]
                mov     edi, ebp
                rol     edx, 6
                add     edx, ecx
                xor     edi, 0FFFFFFFFh
                or      edi, edx
                add     ecx, [esi+18h]
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+6D703EF3h]
                mov     edi, edx
                rol     ecx, 6
                add     ecx, ebx
                xor     edi, 0FFFFFFFFh
                or      edi, ecx
                add     ebx, [esi+24h]
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+6D703EF3h]
                mov     edi, ecx
                rol     ebx, 0Eh
                add     ebx, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ebx
                add     eax, [esi+2Ch]
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+6D703EF3h]
                mov     edi, ebx
                rol     eax, 0Ch
                add     eax, ebp
                xor     edi, 0FFFFFFFFh
                or      edi, eax
                add     ebp, [esi+20h]
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+6D703EF3h]
                mov     edi, eax
                rol     ebp, 0Dh
                add     ebp, edx
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     edx, [esi+30h]
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+6D703EF3h]
                mov     edi, ebp
                rol     edx, 5
                add     edx, ecx
                xor     edi, 0FFFFFFFFh
                or      edi, edx
                add     ecx, [esi+8]
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+6D703EF3h]
                mov     edi, edx
                rol     ecx, 0Eh
                add     ecx, ebx
                xor     edi, 0FFFFFFFFh
                or      edi, ecx
                add     ebx, [esi+28h]
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+6D703EF3h]
                mov     edi, ecx
                rol     ebx, 0Dh
                add     ebx, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ebx
                add     eax, [esi]
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+6D703EF3h]
                mov     edi, ebx
                rol     eax, 0Dh
                add     eax, ebp
                xor     edi, 0FFFFFFFFh
                or      edi, eax
                add     ebp, [esi+10h]
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+6D703EF3h]
                mov     edi, eax
                rol     ebp, 7
                add     ebp, edx
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     edx, [esi+34h]
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+6D703EF3h]
                rol     edx, 5
                add     edx, ecx
                mov     [esp+14h], eax
                mov     [esp+18h], ebx
                mov     eax, [esp]
                mov     ebx, [esp+4]
                mov     [esp+20h], edx
                mov     [esp+24h], ebp
                mov     edx, [esp+0Ch]
                mov     ebp, [esp+8]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+10h]
                mov     edi, ebp
                xor     edi, edx
                and     edi, eax
                add     ecx, [esi+4]
                xor     edi, ebp
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi-70E44324h]
                mov     edi, edx
                rol     ecx, 0Bh
                add     ecx, ebx
                xor     edi, ecx
                and     edi, ebp
                add     ebx, [esi+24h]
                xor     edi, edx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi-70E44324h]
                mov     edi, ecx
                rol     ebx, 0Ch
                add     ebx, eax
                xor     edi, ebx
                and     edi, edx
                add     eax, [esi+2Ch]
                xor     edi, ecx
                rol     ecx, 0Ah
                lea     eax, [eax+edi-70E44324h]
                mov     edi, ebx
                rol     eax, 0Eh
                add     eax, ebp
                xor     edi, eax
                and     edi, ecx
                add     ebp, [esi+28h]
                xor     edi, ebx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi-70E44324h]
                mov     edi, eax
                rol     ebp, 0Fh
                add     ebp, edx
                xor     edi, ebp
                and     edi, ebx
                add     edx, [esi]
                xor     edi, eax
                rol     eax, 0Ah
                lea     edx, [edx+edi-70E44324h]
                mov     edi, ebp
                rol     edx, 0Eh
                add     edx, ecx
                xor     edi, edx
                and     edi, eax
                add     ecx, [esi+20h]
                xor     edi, ebp
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi-70E44324h]
                mov     edi, edx
                rol     ecx, 0Fh
                add     ecx, ebx
                xor     edi, ecx
                and     edi, ebp
                add     ebx, [esi+30h]
                xor     edi, edx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi-70E44324h]
                mov     edi, ecx
                rol     ebx, 9
                add     ebx, eax
                xor     edi, ebx
                and     edi, edx
                add     eax, [esi+10h]
                xor     edi, ecx
                rol     ecx, 0Ah
                lea     eax, [eax+edi-70E44324h]
                mov     edi, ebx
                rol     eax, 8
                add     eax, ebp
                xor     edi, eax
                and     edi, ecx
                add     ebp, [esi+34h]
                xor     edi, ebx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi-70E44324h]
                mov     edi, eax
                rol     ebp, 9
                add     ebp, edx
                xor     edi, ebp
                and     edi, ebx
                add     edx, [esi+0Ch]
                xor     edi, eax
                rol     eax, 0Ah
                lea     edx, [edx+edi-70E44324h]
                mov     edi, ebp
                rol     edx, 0Eh
                add     edx, ecx
                xor     edi, edx
                and     edi, eax
                add     ecx, [esi+1Ch]
                xor     edi, ebp
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi-70E44324h]
                mov     edi, edx
                rol     ecx, 5
                add     ecx, ebx
                xor     edi, ecx
                and     edi, ebp
                add     ebx, [esi+3Ch]
                xor     edi, edx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi-70E44324h]
                mov     edi, ecx
                rol     ebx, 6
                add     ebx, eax
                xor     edi, ebx
                and     edi, edx
                add     eax, [esi+38h]
                xor     edi, ecx
                rol     ecx, 0Ah
                lea     eax, [eax+edi-70E44324h]
                mov     edi, ebx
                rol     eax, 8
                add     eax, ebp
                xor     edi, eax
                and     edi, ecx
                add     ebp, [esi+14h]
                xor     edi, ebx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi-70E44324h]
                mov     edi, eax
                rol     ebp, 6
                add     ebp, edx
                xor     edi, ebp
                and     edi, ebx
                add     edx, [esi+18h]
                xor     edi, eax
                rol     eax, 0Ah
                lea     edx, [edx+edi-70E44324h]
                mov     edi, ebp
                rol     edx, 5
                add     edx, ecx
                xor     edi, edx
                and     edi, eax
                add     ecx, [esi+8]
                xor     edi, ebp
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi-70E44324h]
                rol     ecx, 0Ch
                add     ecx, ebx
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     eax, [esp+14h]
                mov     ebx, [esp+18h]
                mov     [esp+8], ecx
                mov     [esp+0Ch], edx
                mov     ecx, [esp+1Ch]
                mov     edx, [esp+20h]
                mov     [esp+10h], ebp
                mov     ebp, [esp+24h]
                mov     edi, eax
                xor     edi, ebp
                add     ecx, [esi+20h]
                and     edi, edx
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+7A6D76E9h]
                mov     edi, ebp
                rol     ecx, 0Fh
                add     ecx, ebx
                xor     edi, edx
                add     ebx, [esi+18h]
                and     edi, ecx
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+7A6D76E9h]
                mov     edi, edx
                rol     ebx, 5
                add     ebx, eax
                xor     edi, ecx
                add     eax, [esi+10h]
                and     edi, ebx
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+7A6D76E9h]
                mov     edi, ecx
                rol     eax, 8
                add     eax, ebp
                xor     edi, ebx
                add     ebp, [esi+4]
                and     edi, eax
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+7A6D76E9h]
                mov     edi, ebx
                rol     ebp, 0Bh
                add     ebp, edx
                xor     edi, eax
                add     edx, [esi+0Ch]
                and     edi, ebp
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+7A6D76E9h]
                mov     edi, eax
                rol     edx, 0Eh
                add     edx, ecx
                xor     edi, ebp
                add     ecx, [esi+2Ch]
                and     edi, edx
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+7A6D76E9h]
                mov     edi, ebp
                rol     ecx, 0Eh
                add     ecx, ebx
                xor     edi, edx
                add     ebx, [esi+3Ch]
                and     edi, ecx
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+7A6D76E9h]
                mov     edi, edx
                rol     ebx, 6
                add     ebx, eax
                xor     edi, ecx
                add     eax, [esi]
                and     edi, ebx
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+7A6D76E9h]
                mov     edi, ecx
                rol     eax, 0Eh
                add     eax, ebp
                xor     edi, ebx
                add     ebp, [esi+14h]
                and     edi, eax
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+7A6D76E9h]
                mov     edi, ebx
                rol     ebp, 6
                add     ebp, edx
                xor     edi, eax
                add     edx, [esi+30h]
                and     edi, ebp
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+7A6D76E9h]
                mov     edi, eax
                rol     edx, 9
                add     edx, ecx
                xor     edi, ebp
                add     ecx, [esi+8]
                and     edi, edx
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+7A6D76E9h]
                mov     edi, ebp
                rol     ecx, 0Ch
                add     ecx, ebx
                xor     edi, edx
                add     ebx, [esi+34h]
                and     edi, ecx
                xor     edi, ebp
                rol     edx, 0Ah
                lea     ebx, [ebx+edi+7A6D76E9h]
                mov     edi, edx
                rol     ebx, 9
                add     ebx, eax
                xor     edi, ecx
                add     eax, [esi+24h]
                and     edi, ebx
                xor     edi, edx
                rol     ecx, 0Ah
                lea     eax, [eax+edi+7A6D76E9h]
                mov     edi, ecx
                rol     eax, 0Ch
                add     eax, ebp
                xor     edi, ebx
                add     ebp, [esi+1Ch]
                and     edi, eax
                xor     edi, ecx
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi+7A6D76E9h]
                mov     edi, ebx
                rol     ebp, 5
                add     ebp, edx
                xor     edi, eax
                add     edx, [esi+28h]
                and     edi, ebp
                xor     edi, ebx
                rol     eax, 0Ah
                lea     edx, [edx+edi+7A6D76E9h]
                mov     edi, eax
                rol     edx, 0Fh
                add     edx, ecx
                xor     edi, ebp
                add     ecx, [esi+38h]
                and     edi, edx
                xor     edi, eax
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi+7A6D76E9h]
                rol     ecx, 8
                add     ecx, ebx
                mov     [esp+14h], eax
                mov     [esp+18h], ebx
                mov     eax, [esp]
                mov     ebx, [esp+4]
                mov     [esp+1Ch], ecx
                mov     [esp+24h], ebp
                mov     ecx, [esp+8]
                mov     ebp, [esp+0Ch]
                mov     [esp+20h], ebp
                mov     ebp, [esp+10h]
                mov     edi, ebp
                xor     edi, 0FFFFFFFFh
                or      edi, edx
                add     ebx, [esi+10h]
                xor     edi, ecx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi-56AC02B2h]
                mov     edi, edx
                rol     ebx, 9
                add     ebx, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ecx
                add     eax, [esi]
                xor     edi, ebx
                rol     ecx, 0Ah
                lea     eax, [eax+edi-56AC02B2h]
                mov     edi, ecx
                rol     eax, 0Fh
                add     eax, ebp
                xor     edi, 0FFFFFFFFh
                or      edi, ebx
                add     ebp, [esi+14h]
                xor     edi, eax
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi-56AC02B2h]
                mov     edi, ebx
                rol     ebp, 5
                add     ebp, edx
                xor     edi, 0FFFFFFFFh
                or      edi, eax
                add     edx, [esi+24h]
                xor     edi, ebp
                rol     eax, 0Ah
                lea     edx, [edx+edi-56AC02B2h]
                mov     edi, eax
                rol     edx, 0Bh
                add     edx, ecx
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     ecx, [esi+1Ch]
                xor     edi, edx
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi-56AC02B2h]
                mov     edi, ebp
                rol     ecx, 6
                add     ecx, ebx
                xor     edi, 0FFFFFFFFh
                or      edi, edx
                add     ebx, [esi+30h]
                xor     edi, ecx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi-56AC02B2h]
                mov     edi, edx
                rol     ebx, 8
                add     ebx, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ecx
                add     eax, [esi+8]
                xor     edi, ebx
                rol     ecx, 0Ah
                lea     eax, [eax+edi-56AC02B2h]
                mov     edi, ecx
                rol     eax, 0Dh
                add     eax, ebp
                xor     edi, 0FFFFFFFFh
                or      edi, ebx
                add     ebp, [esi+28h]
                xor     edi, eax
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi-56AC02B2h]
                mov     edi, ebx
                rol     ebp, 0Ch
                add     ebp, edx
                xor     edi, 0FFFFFFFFh
                or      edi, eax
                add     edx, [esi+38h]
                xor     edi, ebp
                rol     eax, 0Ah
                lea     edx, [edx+edi-56AC02B2h]
                mov     edi, eax
                rol     edx, 5
                add     edx, ecx
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     ecx, [esi+4]
                xor     edi, edx
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi-56AC02B2h]
                mov     edi, ebp
                rol     ecx, 0Ch
                add     ecx, ebx
                xor     edi, 0FFFFFFFFh
                or      edi, edx
                add     ebx, [esi+0Ch]
                xor     edi, ecx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi-56AC02B2h]
                mov     edi, edx
                rol     ebx, 0Dh
                add     ebx, eax
                xor     edi, 0FFFFFFFFh
                or      edi, ecx
                add     eax, [esi+20h]
                xor     edi, ebx
                rol     ecx, 0Ah
                lea     eax, [eax+edi-56AC02B2h]
                mov     edi, ecx
                rol     eax, 0Eh
                add     eax, ebp
                xor     edi, 0FFFFFFFFh
                or      edi, ebx
                add     ebp, [esi+2Ch]
                xor     edi, eax
                rol     ebx, 0Ah
                lea     ebp, [ebp+edi-56AC02B2h]
                mov     edi, ebx
                rol     ebp, 0Bh
                add     ebp, edx
                xor     edi, 0FFFFFFFFh
                or      edi, eax
                add     edx, [esi+18h]
                xor     edi, ebp
                rol     eax, 0Ah
                lea     edx, [edx+edi-56AC02B2h]
                mov     edi, eax
                rol     edx, 8
                add     edx, ecx
                xor     edi, 0FFFFFFFFh
                or      edi, ebp
                add     ecx, [esi+3Ch]
                xor     edi, edx
                rol     ebp, 0Ah
                lea     ecx, [ecx+edi-56AC02B2h]
                mov     edi, ebp
                rol     ecx, 5
                add     ecx, ebx
                xor     edi, 0FFFFFFFFh
                or      edi, edx
                add     ebx, [esi+34h]
                xor     edi, ecx
                rol     edx, 0Ah
                lea     ebx, [ebx+edi-56AC02B2h]
                rol     ebx, 6
                add     ebx, eax
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     eax, [esp+14h]
                mov     ebx, [esp+18h]
                mov     [esp+8], ecx
                mov     [esp+0Ch], edx
                mov     ecx, [esp+1Ch]
                mov     edx, [esp+20h]
                mov     [esp+10h], ebp
                mov     ebp, [esp+24h]
                mov     edi, ebp
                xor     edi, edx
                xor     edi, ecx
                add     ebx, [esi+30h]
                rol     edx, 0Ah
                add     ebx, edi
                mov     edi, edx
                rol     ebx, 8
                add     ebx, eax
                xor     edi, ecx
                xor     edi, ebx
                add     eax, [esi+3Ch]
                rol     ecx, 0Ah
                add     eax, edi
                mov     edi, ecx
                rol     eax, 5
                add     eax, ebp
                xor     edi, ebx
                xor     edi, eax
                add     ebp, [esi+28h]
                rol     ebx, 0Ah
                add     ebp, edi
                mov     edi, ebx
                rol     ebp, 0Ch
                add     ebp, edx
                xor     edi, eax
                xor     edi, ebp
                add     edx, [esi+10h]
                rol     eax, 0Ah
                add     edx, edi
                mov     edi, eax
                rol     edx, 9
                add     edx, ecx
                xor     edi, ebp
                xor     edi, edx
                add     ecx, [esi+4]
                rol     ebp, 0Ah
                add     ecx, edi
                mov     edi, ebp
                rol     ecx, 0Ch
                add     ecx, ebx
                xor     edi, edx
                xor     edi, ecx
                add     ebx, [esi+14h]
                rol     edx, 0Ah
                add     ebx, edi
                mov     edi, edx
                rol     ebx, 5
                add     ebx, eax
                xor     edi, ecx
                xor     edi, ebx
                add     eax, [esi+20h]
                rol     ecx, 0Ah
                add     eax, edi
                mov     edi, ecx
                rol     eax, 0Eh
                add     eax, ebp
                xor     edi, ebx
                xor     edi, eax
                add     ebp, [esi+1Ch]
                rol     ebx, 0Ah
                add     ebp, edi
                mov     edi, ebx
                rol     ebp, 6
                add     ebp, edx
                xor     edi, eax
                xor     edi, ebp
                add     edx, [esi+18h]
                rol     eax, 0Ah
                add     edx, edi
                mov     edi, eax
                rol     edx, 8
                add     edx, ecx
                xor     edi, ebp
                xor     edi, edx
                add     ecx, [esi+8]
                rol     ebp, 0Ah
                add     ecx, edi
                mov     edi, ebp
                rol     ecx, 0Dh
                add     ecx, ebx
                xor     edi, edx
                xor     edi, ecx
                add     ebx, [esi+34h]
                rol     edx, 0Ah
                add     ebx, edi
                mov     edi, edx
                rol     ebx, 6
                add     ebx, eax
                xor     edi, ecx
                xor     edi, ebx
                add     eax, [esi+38h]
                rol     ecx, 0Ah
                add     eax, edi
                mov     edi, ecx
                rol     eax, 5
                add     eax, ebp
                xor     edi, ebx
                xor     edi, eax
                add     ebp, [esi]
                rol     ebx, 0Ah
                add     ebp, edi
                mov     edi, ebx
                rol     ebp, 0Fh
                add     ebp, edx
                xor     edi, eax
                xor     edi, ebp
                add     edx, [esi+0Ch]
                rol     eax, 0Ah
                add     edx, edi
                mov     edi, eax
                rol     edx, 0Dh
                add     edx, ecx
                xor     edi, ebp
                xor     edi, edx
                add     ecx, [esi+24h]
                rol     ebp, 0Ah
                add     ecx, edi
                mov     edi, ebp
                rol     ecx, 0Bh
                add     ecx, ebx
                xor     edi, edx
                xor     edi, ecx
                add     ebx, [esi+2Ch]
                rol     edx, 0Ah
                add     ebx, edi
                rol     ebx, 0Bh
                add     ebx, eax
                mov     edi, [esp+28h]
                add     [edi+10h], ebp
                add     [edi+14h], eax
                add     [edi+18h], ebx
                mov     eax, [esp]
                mov     ebx, [esp+4]
                add     [edi+1Ch], ecx
                mov     ebp, [esp+10h]
                add     [edi+20h], edx
                mov     ecx, [esp+8]
                mov     edx, [esp+0Ch]
                add     [edi], eax
                add     [edi+4], ebx
                add     esp, 2Ch
                add     [edi+8], ecx
                add     [edi+0Ch], edx
                add     [edi+24h], ebp
                pop     ebp
                pop     edi
                pop     esi
                pop     ebx
end;
{$ENDIF}

{$IFDEF THash_SHA_asm}
procedure SHABuffer(W,S: PLongArray; Rotate: Boolean);
var
  I: Integer;
  T: LongWord;
begin
  SwapLongBuffer(S[0], W[0], 16);
  if Rotate then
    for I := 16 to 79 do
    begin
      T := W[I - 3] xor W[I - 8] xor W[I - 14] xor W[I - 16];
      W[I] := T shl 1 or T shr 31;
    end
  else
    for I := 16 to 79 do
    begin
      T := W[I - 3] xor W[I - 8] xor W[I - 14] xor W[I - 16];
      W[I] := T;
    end
end;

procedure THash_SHA.DoTransform(Buffer: PLongArray);
var
  W: array[0..79] of LongWord;
begin
  SHABuffer(@W, Buffer, ClassType <> THash_SHA);
  asm
                push    ebx
                mov     eax, Self
                push    esi
                push    edi
                lea     edi, [eax].THash_SHA.FDigest
                lea     esi, W
                push    ebp

                sub     esp, 8
                mov     eax, [edi]
                mov     ebx, [edi+4]
                mov     ecx, [edi+8]
                mov     [esp], edi
                mov     edx, [edi+0Ch]
                mov     ebp, [edi+10h]
                mov     [esp+4], esi
                mov     edi, ecx
                xor     edi, edx
                and     edi, ebx
                add     ebp, [esi]
                xor     edi, edx
                ror     ebx, 2
                lea     ebp, [ebp+edi+5A827999h]
                mov     edi, eax
                rol     edi, 5
                add     ebp, edi
                mov     edi, ecx
                xor     edi, ebx
                and     edi, eax
                add     edx, [esi+4]
                xor     edi, ecx
                ror     eax, 2
                lea     edx, [edx+edi+5A827999h]
                mov     edi, ebp
                rol     edi, 5
                add     edx, edi
                mov     edi, ebx
                xor     edi, eax
                and     edi, ebp
                add     ecx, [esi+8]
                xor     edi, ebx
                ror     ebp, 2
                lea     ecx, [ecx+edi+5A827999h]
                mov     edi, edx
                rol     edi, 5
                add     ecx, edi
                mov     edi, eax
                xor     edi, ebp
                and     edi, edx
                add     ebx, [esi+0Ch]
                xor     edi, eax
                ror     edx, 2
                lea     ebx, [ebx+edi+5A827999h]
                mov     edi, ecx
                rol     edi, 5
                add     ebx, edi
                mov     edi, ebp
                xor     edi, edx
                and     edi, ecx
                add     eax, [esi+10h]
                xor     edi, ebp
                ror     ecx, 2
                lea     eax, [eax+edi+5A827999h]
                mov     edi, ebx
                rol     edi, 5
                add     eax, edi
                mov     edi, edx
                xor     edi, ecx
                and     edi, ebx
                add     ebp, [esi+14h]
                xor     edi, edx
                ror     ebx, 2
                lea     ebp, [ebp+edi+5A827999h]
                mov     edi, eax
                rol     edi, 5
                add     ebp, edi
                mov     edi, ecx
                xor     edi, ebx
                and     edi, eax
                add     edx, [esi+18h]
                xor     edi, ecx
                ror     eax, 2
                lea     edx, [edx+edi+5A827999h]
                mov     edi, ebp
                rol     edi, 5
                add     edx, edi
                mov     edi, ebx
                xor     edi, eax
                and     edi, ebp
                add     ecx, [esi+1Ch]
                xor     edi, ebx
                ror     ebp, 2
                lea     ecx, [ecx+edi+5A827999h]
                mov     edi, edx
                rol     edi, 5
                add     ecx, edi
                mov     edi, eax
                xor     edi, ebp
                and     edi, edx
                add     ebx, [esi+20h]
                xor     edi, eax
                ror     edx, 2
                lea     ebx, [ebx+edi+5A827999h]
                mov     edi, ecx
                rol     edi, 5
                add     ebx, edi
                mov     edi, ebp
                xor     edi, edx
                and     edi, ecx
                add     eax, [esi+24h]
                xor     edi, ebp
                ror     ecx, 2
                lea     eax, [eax+edi+5A827999h]
                mov     edi, ebx
                rol     edi, 5
                add     eax, edi
                mov     edi, edx
                xor     edi, ecx
                and     edi, ebx
                add     ebp, [esi+28h]
                xor     edi, edx
                ror     ebx, 2
                lea     ebp, [ebp+edi+5A827999h]
                mov     edi, eax
                rol     edi, 5
                add     ebp, edi
                mov     edi, ecx
                xor     edi, ebx
                and     edi, eax
                add     edx, [esi+2Ch]
                xor     edi, ecx
                ror     eax, 2
                lea     edx, [edx+edi+5A827999h]
                mov     edi, ebp
                rol     edi, 5
                add     edx, edi
                mov     edi, ebx
                xor     edi, eax
                and     edi, ebp
                add     ecx, [esi+30h]
                xor     edi, ebx
                ror     ebp, 2
                lea     ecx, [ecx+edi+5A827999h]
                mov     edi, edx
                rol     edi, 5
                add     ecx, edi
                mov     edi, eax
                xor     edi, ebp
                and     edi, edx
                add     ebx, [esi+34h]
                xor     edi, eax
                ror     edx, 2
                lea     ebx, [ebx+edi+5A827999h]
                mov     edi, ecx
                rol     edi, 5
                add     ebx, edi
                mov     edi, ebp
                xor     edi, edx
                and     edi, ecx
                add     eax, [esi+38h]
                xor     edi, ebp
                ror     ecx, 2
                lea     eax, [eax+edi+5A827999h]
                mov     edi, ebx
                rol     edi, 5
                add     eax, edi
                mov     edi, edx
                xor     edi, ecx
                and     edi, ebx
                add     ebp, [esi+3Ch]
                xor     edi, edx
                ror     ebx, 2
                lea     ebp, [ebp+edi+5A827999h]
                mov     edi, eax
                rol     edi, 5
                add     ebp, edi
                mov     edi, ecx
                xor     edi, ebx
                and     edi, eax
                add     edx, [esi+40h]
                xor     edi, ecx
                ror     eax, 2
                lea     edx, [edx+edi+5A827999h]
                mov     edi, ebp
                rol     edi, 5
                add     edx, edi
                mov     edi, ebx
                xor     edi, eax
                and     edi, ebp
                add     ecx, [esi+44h]
                xor     edi, ebx
                ror     ebp, 2
                lea     ecx, [ecx+edi+5A827999h]
                mov     edi, edx
                rol     edi, 5
                add     ecx, edi
                mov     edi, eax
                xor     edi, ebp
                and     edi, edx
                add     ebx, [esi+48h]
                xor     edi, eax
                ror     edx, 2
                lea     ebx, [ebx+edi+5A827999h]
                mov     edi, ecx
                rol     edi, 5
                add     ebx, edi
                mov     edi, ebp
                xor     edi, edx
                and     edi, ecx
                add     eax, [esi+4Ch]
                xor     edi, ebp
                ror     ecx, 2
                lea     eax, [eax+edi+5A827999h]
                mov     edi, ebx
                rol     edi, 5
                add     eax, edi
                mov     edi, edx
                xor     edi, ecx
                xor     edi, ebx
                add     ebp, edi
                mov     edi, [esi+50h]
                ror     ebx, 2
                lea     ebp, [ebp+edi+6ED9EBA1h]
                mov     edi, eax
                rol     edi, 5
                add     ebp, edi
                mov     edi, ecx
                xor     edi, ebx
                xor     edi, eax
                add     edx, edi
                mov     edi, [esi+54h]
                ror     eax, 2
                lea     edx, [edx+edi+6ED9EBA1h]
                mov     edi, ebp
                rol     edi, 5
                add     edx, edi
                mov     edi, ebx
                xor     edi, eax
                xor     edi, ebp
                add     ecx, edi
                mov     edi, [esi+58h]
                ror     ebp, 2
                lea     ecx, [ecx+edi+6ED9EBA1h]
                mov     edi, edx
                rol     edi, 5
                add     ecx, edi
                mov     edi, eax
                xor     edi, ebp
                xor     edi, edx
                add     ebx, edi
                mov     edi, [esi+5Ch]
                ror     edx, 2
                lea     ebx, [ebx+edi+6ED9EBA1h]
                mov     edi, ecx
                rol     edi, 5
                add     ebx, edi
                mov     edi, ebp
                xor     edi, edx
                xor     edi, ecx
                add     eax, edi
                mov     edi, [esi+60h]
                ror     ecx, 2
                lea     eax, [eax+edi+6ED9EBA1h]
                mov     edi, ebx
                rol     edi, 5
                add     eax, edi
                mov     edi, edx
                xor     edi, ecx
                xor     edi, ebx
                add     ebp, edi
                mov     edi, [esi+64h]
                ror     ebx, 2
                lea     ebp, [ebp+edi+6ED9EBA1h]
                mov     edi, eax
                rol     edi, 5
                add     ebp, edi
                mov     edi, ecx
                xor     edi, ebx
                xor     edi, eax
                add     edx, edi
                mov     edi, [esi+68h]
                ror     eax, 2
                lea     edx, [edx+edi+6ED9EBA1h]
                mov     edi, ebp
                rol     edi, 5
                add     edx, edi
                mov     edi, ebx
                xor     edi, eax
                xor     edi, ebp
                add     ecx, edi
                mov     edi, [esi+6Ch]
                ror     ebp, 2
                lea     ecx, [ecx+edi+6ED9EBA1h]
                mov     edi, edx
                rol     edi, 5
                add     ecx, edi
                mov     edi, eax
                xor     edi, ebp
                xor     edi, edx
                add     ebx, edi
                mov     edi, [esi+70h]
                ror     edx, 2
                lea     ebx, [ebx+edi+6ED9EBA1h]
                mov     edi, ecx
                rol     edi, 5
                add     ebx, edi
                mov     edi, ebp
                xor     edi, edx
                xor     edi, ecx
                add     eax, edi
                mov     edi, [esi+74h]
                ror     ecx, 2
                lea     eax, [eax+edi+6ED9EBA1h]
                mov     edi, ebx
                rol     edi, 5
                add     eax, edi
                mov     edi, edx
                xor     edi, ecx
                xor     edi, ebx
                add     ebp, edi
                mov     edi, [esi+78h]
                ror     ebx, 2
                lea     ebp, [ebp+edi+6ED9EBA1h]
                mov     edi, eax
                rol     edi, 5
                add     ebp, edi
                mov     edi, ecx
                xor     edi, ebx
                xor     edi, eax
                add     edx, edi
                mov     edi, [esi+7Ch]
                ror     eax, 2
                lea     edx, [edx+edi+6ED9EBA1h]
                mov     edi, ebp
                rol     edi, 5
                add     edx, edi
                mov     edi, ebx
                xor     edi, eax
                xor     edi, ebp
                add     ecx, edi
                mov     edi, [esi+80h]
                ror     ebp, 2
                lea     ecx, [ecx+edi+6ED9EBA1h]
                mov     edi, edx
                rol     edi, 5
                add     ecx, edi
                mov     edi, eax
                xor     edi, ebp
                xor     edi, edx
                add     ebx, edi
                mov     edi, [esi+84h]
                ror     edx, 2
                lea     ebx, [ebx+edi+6ED9EBA1h]
                mov     edi, ecx
                rol     edi, 5
                add     ebx, edi
                mov     edi, ebp
                xor     edi, edx
                xor     edi, ecx
                add     eax, edi
                mov     edi, [esi+88h]
                ror     ecx, 2
                lea     eax, [eax+edi+6ED9EBA1h]
                mov     edi, ebx
                rol     edi, 5
                add     eax, edi
                mov     edi, edx
                xor     edi, ecx
                xor     edi, ebx
                add     ebp, edi
                mov     edi, [esi+8Ch]
                ror     ebx, 2
                lea     ebp, [ebp+edi+6ED9EBA1h]
                mov     edi, eax
                rol     edi, 5
                add     ebp, edi
                mov     edi, ecx
                xor     edi, ebx
                xor     edi, eax
                add     edx, edi
                mov     edi, [esi+90h]
                ror     eax, 2
                lea     edx, [edx+edi+6ED9EBA1h]
                mov     edi, ebp
                rol     edi, 5
                add     edx, edi
                mov     edi, ebx
                xor     edi, eax
                xor     edi, ebp
                add     ecx, edi
                mov     edi, [esi+94h]
                ror     ebp, 2
                lea     ecx, [ecx+edi+6ED9EBA1h]
                mov     edi, edx
                rol     edi, 5
                add     ecx, edi
                mov     edi, eax
                xor     edi, ebp
                xor     edi, edx
                add     ebx, edi
                mov     edi, [esi+98h]
                ror     edx, 2
                lea     ebx, [ebx+edi+6ED9EBA1h]
                mov     edi, ecx
                rol     edi, 5
                add     ebx, edi
                mov     edi, ebp
                xor     edi, edx
                xor     edi, ecx
                add     eax, edi
                mov     edi, [esi+9Ch]
                ror     ecx, 2
                lea     eax, [eax+edi+6ED9EBA1h]
                mov     edi, ebx
                rol     edi, 5
                add     eax, edi
                mov     edi, edx
                xor     edi, ecx
                mov     esi, ecx
                mov     edi, ecx
                or      esi, edx
                and     edi, edx
                and     esi, ebx
                or      esi, edi
                mov     edi, eax
                add     ebp, esi
                mov     esi, [esp+4]
                rol     edi, 5
                add     ebp, edi
                mov     edi, [esi+0A0h]
                ror     ebx, 2
                lea     ebp, [ebp+edi-70E44324h]
                mov     esi, ebx
                mov     edi, ebx
                or      esi, ecx
                and     edi, ecx
                and     esi, eax
                or      esi, edi
                mov     edi, ebp
                add     edx, esi
                mov     esi, [esp+4]
                rol     edi, 5
                add     edx, edi
                mov     edi, [esi+0A4h]
                ror     eax, 2
                lea     edx, [edx+edi-70E44324h]
                mov     esi, eax
                mov     edi, eax
                or      esi, ebx
                and     edi, ebx
                and     esi, ebp
                or      esi, edi
                mov     edi, edx
                add     ecx, esi
                mov     esi, [esp+4]
                rol     edi, 5
                add     ecx, edi
                mov     edi, [esi+0A8h]
                ror     ebp, 2
                lea     ecx, [ecx+edi-70E44324h]
                mov     esi, ebp
                mov     edi, ebp
                or      esi, eax
                and     edi, eax
                and     esi, edx
                or      esi, edi
                mov     edi, ecx
                add     ebx, esi
                mov     esi, [esp+4]
                rol     edi, 5
                add     ebx, edi
                mov     edi, [esi+0ACh]
                ror     edx, 2
                lea     ebx, [ebx+edi-70E44324h]
                mov     esi, edx
                mov     edi, edx
                or      esi, ebp
                and     edi, ebp
                and     esi, ecx
                or      esi, edi
                mov     edi, ebx
                add     eax, esi
                mov     esi, [esp+4]
                rol     edi, 5
                add     eax, edi
                mov     edi, [esi+0B0h]
                ror     ecx, 2
                lea     eax, [eax+edi-70E44324h]
                mov     esi, ecx
                mov     edi, ecx
                or      esi, edx
                and     edi, edx
                and     esi, ebx
                or      esi, edi
                mov     edi, eax
                add     ebp, esi
                mov     esi, [esp+4]
                rol     edi, 5
                add     ebp, edi
                mov     edi, [esi+0B4h]
                ror     ebx, 2
                lea     ebp, [ebp+edi-70E44324h]
                mov     esi, ebx
                mov     edi, ebx
                or      esi, ecx
                and     edi, ecx
                and     esi, eax
                or      esi, edi
                mov     edi, ebp
                add     edx, esi
                mov     esi, [esp+4]
                rol     edi, 5
                add     edx, edi
                mov     edi, [esi+0B8h]
                ror     eax, 2
                lea     edx, [edx+edi-70E44324h]
                mov     esi, eax
                mov     edi, eax
                or      esi, ebx
                and     edi, ebx
                and     esi, ebp
                or      esi, edi
                mov     edi, edx
                add     ecx, esi
                mov     esi, [esp+4]
                rol     edi, 5
                add     ecx, edi
                mov     edi, [esi+0BCh]
                ror     ebp, 2
                lea     ecx, [ecx+edi-70E44324h]
                mov     esi, ebp
                mov     edi, ebp
                or      esi, eax
                and     edi, eax
                and     esi, edx
                or      esi, edi
                mov     edi, ecx
                add     ebx, esi
                mov     esi, [esp+4]
                rol     edi, 5
                add     ebx, edi
                mov     edi, [esi+0C0h]
                ror     edx, 2
                lea     ebx, [ebx+edi-70E44324h]
                mov     esi, edx
                mov     edi, edx
                or      esi, ebp
                and     edi, ebp
                and     esi, ecx
                or      esi, edi
                mov     edi, ebx
                add     eax, esi
                mov     esi, [esp+4]
                rol     edi, 5
                add     eax, edi
                mov     edi, [esi+0C4h]
                ror     ecx, 2
                lea     eax, [eax+edi-70E44324h]
                mov     esi, ecx
                mov     edi, ecx
                or      esi, edx
                and     edi, edx
                and     esi, ebx
                or      esi, edi
                mov     edi, eax
                add     ebp, esi
                mov     esi, [esp+4]
                rol     edi, 5
                add     ebp, edi
                mov     edi, [esi+0C8h]
                ror     ebx, 2
                lea     ebp, [ebp+edi-70E44324h]
                mov     esi, ebx
                mov     edi, ebx
                or      esi, ecx
                and     edi, ecx
                and     esi, eax
                or      esi, edi
                mov     edi, ebp
                add     edx, esi
                mov     esi, [esp+4]
                rol     edi, 5
                add     edx, edi
                mov     edi, [esi+0CCh]
                ror     eax, 2
                lea     edx, [edx+edi-70E44324h]
                mov     esi, eax
                mov     edi, eax
                or      esi, ebx
                and     edi, ebx
                and     esi, ebp
                or      esi, edi
                mov     edi, edx
                add     ecx, esi
                mov     esi, [esp+4]
                rol     edi, 5
                add     ecx, edi
                mov     edi, [esi+0D0h]
                ror     ebp, 2
                lea     ecx, [ecx+edi-70E44324h]
                mov     esi, ebp
                mov     edi, ebp
                or      esi, eax
                and     edi, eax
                and     esi, edx
                or      esi, edi
                mov     edi, ecx
                add     ebx, esi
                mov     esi, [esp+4]
                rol     edi, 5
                add     ebx, edi
                mov     edi, [esi+0D4h]
                ror     edx, 2
                lea     ebx, [ebx+edi-70E44324h]
                mov     esi, edx
                mov     edi, edx
                or      esi, ebp
                and     edi, ebp
                and     esi, ecx
                or      esi, edi
                mov     edi, ebx
                add     eax, esi
                mov     esi, [esp+4]
                rol     edi, 5
                add     eax, edi
                mov     edi, [esi+0D8h]
                ror     ecx, 2
                lea     eax, [eax+edi-70E44324h]
                mov     esi, ecx
                mov     edi, ecx
                or      esi, edx
                and     edi, edx
                and     esi, ebx
                or      esi, edi
                mov     edi, eax
                add     ebp, esi
                mov     esi, [esp+4]
                rol     edi, 5
                add     ebp, edi
                mov     edi, [esi+0DCh]
                ror     ebx, 2
                lea     ebp, [ebp+edi-70E44324h]
                mov     esi, ebx
                mov     edi, ebx
                or      esi, ecx
                and     edi, ecx
                and     esi, eax
                or      esi, edi
                mov     edi, ebp
                add     edx, esi
                mov     esi, [esp+4]
                rol     edi, 5
                add     edx, edi
                mov     edi, [esi+0E0h]
                ror     eax, 2
                lea     edx, [edx+edi-70E44324h]
                mov     esi, eax
                mov     edi, eax
                or      esi, ebx
                and     edi, ebx
                and     esi, ebp
                or      esi, edi
                mov     edi, edx
                add     ecx, esi
                mov     esi, [esp+4]
                rol     edi, 5
                add     ecx, edi
                mov     edi, [esi+0E4h]
                ror     ebp, 2
                lea     ecx, [ecx+edi-70E44324h]
                mov     esi, ebp
                mov     edi, ebp
                or      esi, eax
                and     edi, eax
                and     esi, edx
                or      esi, edi
                mov     edi, ecx
                add     ebx, esi
                mov     esi, [esp+4]
                rol     edi, 5
                add     ebx, edi
                mov     edi, [esi+0E8h]
                ror     edx, 2
                lea     ebx, [ebx+edi-70E44324h]
                mov     esi, edx
                mov     edi, edx
                or      esi, ebp
                and     edi, ebp
                and     esi, ecx
                or      esi, edi
                mov     edi, ebx
                add     eax, esi
                mov     esi, [esp+4]
                rol     edi, 5
                add     eax, edi
                mov     edi, [esi+0ECh]
                ror     ecx, 2
                lea     eax, [eax+edi-70E44324h]
                mov     edi, ecx
                xor     edi, edx
                xor     edi, ebx
                add     ebp, edi
                mov     edi, [esi+0F0h]
                ror     ebx, 2
                lea     ebp, [ebp+edi-359D3E2Ah]
                mov     edi, eax
                rol     edi, 5
                add     ebp, edi
                mov     edi, ecx
                xor     edi, ebx
                xor     edi, eax
                add     edx, edi
                mov     edi, [esi+0F4h]
                ror     eax, 2
                lea     edx, [edx+edi-359D3E2Ah]
                mov     edi, ebp
                rol     edi, 5
                add     edx, edi
                mov     edi, ebx
                xor     edi, eax
                xor     edi, ebp
                add     ecx, edi
                mov     edi, [esi+0F8h]
                ror     ebp, 2
                lea     ecx, [ecx+edi-359D3E2Ah]
                mov     edi, edx
                rol     edi, 5
                add     ecx, edi
                mov     edi, eax
                xor     edi, ebp
                xor     edi, edx
                add     ebx, edi
                mov     edi, [esi+0FCh]
                ror     edx, 2
                lea     ebx, [ebx+edi-359D3E2Ah]
                mov     edi, ecx
                rol     edi, 5
                add     ebx, edi
                mov     edi, ebp
                xor     edi, edx
                xor     edi, ecx
                add     eax, edi
                mov     edi, [esi+100h]
                ror     ecx, 2
                lea     eax, [eax+edi-359D3E2Ah]
                mov     edi, ebx
                rol     edi, 5
                add     eax, edi
                mov     edi, edx
                xor     edi, ecx
                xor     edi, ebx
                add     ebp, edi
                mov     edi, [esi+104h]
                ror     ebx, 2
                lea     ebp, [ebp+edi-359D3E2Ah]
                mov     edi, eax
                rol     edi, 5
                add     ebp, edi
                mov     edi, ecx
                xor     edi, ebx
                xor     edi, eax
                add     edx, edi
                mov     edi, [esi+108h]
                ror     eax, 2
                lea     edx, [edx+edi-359D3E2Ah]
                mov     edi, ebp
                rol     edi, 5
                add     edx, edi
                mov     edi, ebx
                xor     edi, eax
                xor     edi, ebp
                add     ecx, edi
                mov     edi, [esi+10Ch]
                ror     ebp, 2
                lea     ecx, [ecx+edi-359D3E2Ah]
                mov     edi, edx
                rol     edi, 5
                add     ecx, edi
                mov     edi, eax
                xor     edi, ebp
                xor     edi, edx
                add     ebx, edi
                mov     edi, [esi+110h]
                ror     edx, 2
                lea     ebx, [ebx+edi-359D3E2Ah]
                mov     edi, ecx
                rol     edi, 5
                add     ebx, edi
                mov     edi, ebp
                xor     edi, edx
                xor     edi, ecx
                add     eax, edi
                mov     edi, [esi+114h]
                ror     ecx, 2
                lea     eax, [eax+edi-359D3E2Ah]
                mov     edi, ebx
                rol     edi, 5
                add     eax, edi
                mov     edi, edx
                xor     edi, ecx
                xor     edi, ebx
                add     ebp, edi
                mov     edi, [esi+118h]
                ror     ebx, 2
                lea     ebp, [ebp+edi-359D3E2Ah]
                mov     edi, eax
                rol     edi, 5
                add     ebp, edi
                mov     edi, ecx
                xor     edi, ebx
                xor     edi, eax
                add     edx, edi
                mov     edi, [esi+11Ch]
                ror     eax, 2
                lea     edx, [edx+edi-359D3E2Ah]
                mov     edi, ebp
                rol     edi, 5
                add     edx, edi
                mov     edi, ebx
                xor     edi, eax
                xor     edi, ebp
                add     ecx, edi
                mov     edi, [esi+120h]
                ror     ebp, 2
                lea     ecx, [ecx+edi-359D3E2Ah]
                mov     edi, edx
                rol     edi, 5
                add     ecx, edi
                mov     edi, eax
                xor     edi, ebp
                xor     edi, edx
                add     ebx, edi
                mov     edi, [esi+124h]
                ror     edx, 2
                lea     ebx, [ebx+edi-359D3E2Ah]
                mov     edi, ecx
                rol     edi, 5
                add     ebx, edi
                mov     edi, ebp
                xor     edi, edx
                xor     edi, ecx
                add     eax, edi
                mov     edi, [esi+128h]
                ror     ecx, 2
                lea     eax, [eax+edi-359D3E2Ah]
                mov     edi, ebx
                rol     edi, 5
                add     eax, edi
                mov     edi, edx
                xor     edi, ecx
                xor     edi, ebx
                add     ebp, edi
                mov     edi, [esi+12Ch]
                ror     ebx, 2
                lea     ebp, [ebp+edi-359D3E2Ah]
                mov     edi, eax
                rol     edi, 5
                add     ebp, edi
                mov     edi, ecx
                xor     edi, ebx
                xor     edi, eax
                add     edx, edi
                mov     edi, [esi+130h]
                ror     eax, 2
                lea     edx, [edx+edi-359D3E2Ah]
                mov     edi, ebp
                rol     edi, 5
                add     edx, edi
                mov     edi, ebx
                xor     edi, eax
                xor     edi, ebp
                add     ecx, edi
                mov     edi, [esi+134h]
                ror     ebp, 2
                lea     ecx, [ecx+edi-359D3E2Ah]
                mov     edi, edx
                rol     edi, 5
                add     ecx, edi
                mov     edi, eax
                xor     edi, ebp
                xor     edi, edx
                add     ebx, edi
                mov     edi, [esi+138h]
                ror     edx, 2
                lea     ebx, [ebx+edi-359D3E2Ah]
                mov     edi, ecx
                rol     edi, 5
                add     ebx, edi
                mov     edi, ebp
                xor     edi, edx
                xor     edi, ecx
                add     eax, edi
                mov     edi, [esi+13Ch]
                ror     ecx, 2
                lea     eax, [eax+edi-359D3E2Ah]
                mov     edi, ebx
                rol     edi, 5
                add     eax, edi
                mov     edi, [esp]
                add     esp, 8
                add     [edi], eax
                mov     eax, [edi+4]
                mov     esi, [edi+8]
                add     ebx, eax
                mov     eax, [edi+0Ch]
                add     ecx, esi
                mov     esi, [edi+10h]
                mov     [edi+4], ebx
                add     edx, eax
                add     ebp, esi
                mov     [edi+8], ecx
                mov     [edi+0Ch], edx
                mov     [edi+10h], ebp

                pop     ebp
                pop     edi
                pop     esi
                pop     ebx
  end;
end;
{$ENDIF}

{$IFDEF THash_SHA256_asm}
procedure SHA256Buffer(S, D: Pointer); assembler;
asm
                push ebx
                push edi
                mov  edi, eax
                push esi
                mov  esi, edx

                mov     eax, [esi]
                mov     ebx, [esi+4]
                bswap   eax
                mov     ecx, [esi+8]
                mov     edx, [esi+0Ch]
                bswap   ebx
                bswap   ecx
                bswap   edx
                mov     [edi], eax
                mov     [edi+4], ebx
                mov     [edi+8], ecx
                mov     [edi+0Ch], edx
                mov     eax, [esi+10h]
                mov     ebx, [esi+14h]
                bswap   eax
                mov     ecx, [esi+18h]
                mov     edx, [esi+1Ch]
                bswap   ebx
                bswap   ecx
                bswap   edx
                mov     [edi+10h], eax
                mov     [edi+14h], ebx
                mov     [edi+18h], ecx
                mov     [edi+1Ch], edx
                mov     eax, [esi+20h]
                mov     ebx, [esi+24h]
                bswap   eax
                mov     ecx, [esi+28h]
                mov     edx, [esi+2Ch]
                bswap   ebx
                bswap   ecx
                bswap   edx
                mov     [edi+20h], eax
                mov     [edi+24h], ebx
                mov     [edi+28h], ecx
                mov     [edi+2Ch], edx
                mov     eax, [esi+30h]
                mov     ebx, [esi+34h]
                bswap   eax
                mov     ecx, [esi+38h]
                mov     edx, [esi+3Ch]
                bswap   ebx
                bswap   ecx
                bswap   edx
                mov     [edi+30h], eax
                mov     [edi+34h], ebx
                mov     [edi+38h], ecx
                mov     [edi+3Ch], edx


                pop  esi
                pop  edi
                pop  ebx
end;

procedure THash_SHA256.DoTransform(Buffer: PLongArray);
var
  W: array[0..63] of LongWord;
begin
  // swap first 16 uint32
  SHA256Buffer(@W, Buffer);
  asm
    push    ebx
    push    esi
    push    edi
    push    ebp

    mov     eax, Self
    lea     edi, [eax].THash_SHA256.FDigest
    lea     esi, W

                mov     eax, esp
                add     esp, 0FFFFFFD4h
                and     esp, 0FFFFFFC0h
                mov     [esp+20h], esi
                mov     [esp+24h], edi
                mov     [esp+28h], eax
                mov     edi, [esi]
                mov     eax, [esi+4]
                mov     edx, [esi+24h]
                mov     ebx, [esi+38h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+4]
                add     edx, eax
                mov     eax, [esi+8]
                mov     [esi+40h], edx
                mov     edx, [esi+28h]
                mov     ebx, [esi+3Ch]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+8]
                add     edx, eax
                mov     eax, [esi+0Ch]
                mov     [esi+44h], edx
                mov     edx, [esi+2Ch]
                mov     ebx, [esi+40h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+0Ch]
                add     edx, eax
                mov     eax, [esi+10h]
                mov     [esi+48h], edx
                mov     edx, [esi+30h]
                mov     ebx, [esi+44h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+10h]
                add     edx, eax
                mov     eax, [esi+14h]
                mov     [esi+4Ch], edx
                mov     edx, [esi+34h]
                mov     ebx, [esi+48h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+14h]
                add     edx, eax
                mov     eax, [esi+18h]
                mov     [esi+50h], edx
                mov     edx, [esi+38h]
                mov     ebx, [esi+4Ch]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+18h]
                add     edx, eax
                mov     eax, [esi+1Ch]
                mov     [esi+54h], edx
                mov     edx, [esi+3Ch]
                mov     ebx, [esi+50h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+1Ch]
                add     edx, eax
                mov     eax, [esi+20h]
                mov     [esi+58h], edx
                mov     edx, [esi+40h]
                mov     ebx, [esi+54h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+20h]
                add     edx, eax
                mov     eax, [esi+24h]
                mov     [esi+5Ch], edx
                mov     edx, [esi+44h]
                mov     ebx, [esi+58h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+24h]
                add     edx, eax
                mov     eax, [esi+28h]
                mov     [esi+60h], edx
                mov     edx, [esi+48h]
                mov     ebx, [esi+5Ch]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+28h]
                add     edx, eax
                mov     eax, [esi+2Ch]
                mov     [esi+64h], edx
                mov     edx, [esi+4Ch]
                mov     ebx, [esi+60h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+2Ch]
                add     edx, eax
                mov     eax, [esi+30h]
                mov     [esi+68h], edx
                mov     edx, [esi+50h]
                mov     ebx, [esi+64h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+30h]
                add     edx, eax
                mov     eax, [esi+34h]
                mov     [esi+6Ch], edx
                mov     edx, [esi+54h]
                mov     ebx, [esi+68h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+34h]
                add     edx, eax
                mov     eax, [esi+38h]
                mov     [esi+70h], edx
                mov     edx, [esi+58h]
                mov     ebx, [esi+6Ch]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+38h]
                add     edx, eax
                mov     eax, [esi+3Ch]
                mov     [esi+74h], edx
                mov     edx, [esi+5Ch]
                mov     ebx, [esi+70h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+3Ch]
                add     edx, eax
                mov     eax, [esi+40h]
                mov     [esi+78h], edx
                mov     edx, [esi+60h]
                mov     ebx, [esi+74h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+40h]
                add     edx, eax
                mov     eax, [esi+44h]
                mov     [esi+7Ch], edx
                mov     edx, [esi+64h]
                mov     ebx, [esi+78h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+44h]
                add     edx, eax
                mov     eax, [esi+48h]
                mov     [esi+80h], edx
                mov     edx, [esi+68h]
                mov     ebx, [esi+7Ch]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+48h]
                add     edx, eax
                mov     eax, [esi+4Ch]
                mov     [esi+84h], edx
                mov     edx, [esi+6Ch]
                mov     ebx, [esi+80h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+4Ch]
                add     edx, eax
                mov     eax, [esi+50h]
                mov     [esi+88h], edx
                mov     edx, [esi+70h]
                mov     ebx, [esi+84h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+50h]
                add     edx, eax
                mov     eax, [esi+54h]
                mov     [esi+8Ch], edx
                mov     edx, [esi+74h]
                mov     ebx, [esi+88h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+54h]
                add     edx, eax
                mov     eax, [esi+58h]
                mov     [esi+90h], edx
                mov     edx, [esi+78h]
                mov     ebx, [esi+8Ch]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+58h]
                add     edx, eax
                mov     eax, [esi+5Ch]
                mov     [esi+94h], edx
                mov     edx, [esi+7Ch]
                mov     ebx, [esi+90h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+5Ch]
                add     edx, eax
                mov     eax, [esi+60h]
                mov     [esi+98h], edx
                mov     edx, [esi+80h]
                mov     ebx, [esi+94h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+60h]
                add     edx, eax
                mov     eax, [esi+64h]
                mov     [esi+9Ch], edx
                mov     edx, [esi+84h]
                mov     ebx, [esi+98h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+64h]
                add     edx, eax
                mov     eax, [esi+68h]
                mov     [esi+0A0h], edx
                mov     edx, [esi+88h]
                mov     ebx, [esi+9Ch]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+68h]
                add     edx, eax
                mov     eax, [esi+6Ch]
                mov     [esi+0A4h], edx
                mov     edx, [esi+8Ch]
                mov     ebx, [esi+0A0h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+6Ch]
                add     edx, eax
                mov     eax, [esi+70h]
                mov     [esi+0A8h], edx
                mov     edx, [esi+90h]
                mov     ebx, [esi+0A4h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+70h]
                add     edx, eax
                mov     eax, [esi+74h]
                mov     [esi+0ACh], edx
                mov     edx, [esi+94h]
                mov     ebx, [esi+0A8h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+74h]
                add     edx, eax
                mov     eax, [esi+78h]
                mov     [esi+0B0h], edx
                mov     edx, [esi+98h]
                mov     ebx, [esi+0ACh]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+78h]
                add     edx, eax
                mov     eax, [esi+7Ch]
                mov     [esi+0B4h], edx
                mov     edx, [esi+9Ch]
                mov     ebx, [esi+0B0h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+7Ch]
                add     edx, eax
                mov     eax, [esi+80h]
                mov     [esi+0B8h], edx
                mov     edx, [esi+0A0h]
                mov     ebx, [esi+0B4h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+80h]
                add     edx, eax
                mov     eax, [esi+84h]
                mov     [esi+0BCh], edx
                mov     edx, [esi+0A4h]
                mov     ebx, [esi+0B8h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+84h]
                add     edx, eax
                mov     eax, [esi+88h]
                mov     [esi+0C0h], edx
                mov     edx, [esi+0A8h]
                mov     ebx, [esi+0BCh]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+88h]
                add     edx, eax
                mov     eax, [esi+8Ch]
                mov     [esi+0C4h], edx
                mov     edx, [esi+0ACh]
                mov     ebx, [esi+0C0h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+8Ch]
                add     edx, eax
                mov     eax, [esi+90h]
                mov     [esi+0C8h], edx
                mov     edx, [esi+0B0h]
                mov     ebx, [esi+0C4h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+90h]
                add     edx, eax
                mov     eax, [esi+94h]
                mov     [esi+0CCh], edx
                mov     edx, [esi+0B4h]
                mov     ebx, [esi+0C8h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+94h]
                add     edx, eax
                mov     eax, [esi+98h]
                mov     [esi+0D0h], edx
                mov     edx, [esi+0B8h]
                mov     ebx, [esi+0CCh]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+98h]
                add     edx, eax
                mov     eax, [esi+9Ch]
                mov     [esi+0D4h], edx
                mov     edx, [esi+0BCh]
                mov     ebx, [esi+0D0h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+9Ch]
                add     edx, eax
                mov     eax, [esi+0A0h]
                mov     [esi+0D8h], edx
                mov     edx, [esi+0C0h]
                mov     ebx, [esi+0D4h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+0A0h]
                add     edx, eax
                mov     eax, [esi+0A4h]
                mov     [esi+0DCh], edx
                mov     edx, [esi+0C4h]
                mov     ebx, [esi+0D8h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+0A4h]
                add     edx, eax
                mov     eax, [esi+0A8h]
                mov     [esi+0E0h], edx
                mov     edx, [esi+0C8h]
                mov     ebx, [esi+0DCh]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+0A8h]
                add     edx, eax
                mov     eax, [esi+0ACh]
                mov     [esi+0E4h], edx
                mov     edx, [esi+0CCh]
                mov     ebx, [esi+0E0h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+0ACh]
                add     edx, eax
                mov     eax, [esi+0B0h]
                mov     [esi+0E8h], edx
                mov     edx, [esi+0D0h]
                mov     ebx, [esi+0E4h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+0B0h]
                add     edx, eax
                mov     eax, [esi+0B4h]
                mov     [esi+0ECh], edx
                mov     edx, [esi+0D4h]
                mov     ebx, [esi+0E8h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+0B4h]
                add     edx, eax
                mov     eax, [esi+0B8h]
                mov     [esi+0F0h], edx
                mov     edx, [esi+0D8h]
                mov     ebx, [esi+0ECh]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+0B8h]
                add     edx, eax
                mov     eax, [esi+0BCh]
                mov     [esi+0F4h], edx
                mov     edx, [esi+0DCh]
                mov     ebx, [esi+0F0h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+0BCh]
                add     edx, eax
                mov     eax, [esi+0C0h]
                mov     [esi+0F8h], edx
                mov     edx, [esi+0E0h]
                mov     ebx, [esi+0F4h]
                mov     ecx, eax
                ror     ecx, 7
                shr     eax, 3
                mov     ebp, ebx
                shr     ebx, 0Ah
                xor     eax, ecx
                ror     ecx, 0Bh
                rol     ebp, 0Fh
                xor     eax, ecx
                xor     ebx, ebp
                ror     ebp, 2
                xor     ebx, ebp
                add     edx, edi
                add     eax, ebx
                mov     edi, [esi+0C0h]
                add     edx, eax
                mov     eax, [esi+0C4h]
                mov     [esi+0FCh], edx
                mov     edi, [esp+24h]
                mov     eax, [edi]
                mov     ebx, [edi+4]
                mov     ecx, [edi+8]
                mov     edx, [edi+0Ch]
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     [esp+8], ecx
                mov     [esp+0Ch], edx
                mov     eax, [edi+10h]
                mov     ebx, [edi+14h]
                mov     ecx, [edi+18h]
                mov     edx, [edi+1Ch]
                mov     [esp+10h], eax
                mov     [esp+14h], ebx
                mov     [esp+18h], ecx
                mov     [esp+1Ch], edx
                mov     ebp, eax
                mov     edi, eax
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ebx
                xor     ebp, ecx
                and     ebp, eax
                lea     edx, [edi+edx+428A2F98h]
                mov     edi, [esp+4]
                xor     ebp, ecx
                add     edx, [esi]
                add     edx, ebp
                mov     ebp, [esp+8]
                mov     eax, edi
                and     edi, ebp
                or      eax, ebp
                mov     ebp, [esp]
                and     eax, ebp
                ror     ebp, 2
                or      eax, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     eax, edx
                xor     ebp, edi
                add     edx, [esp+0Ch]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+0Ch], edx
                add     eax, ebp
                mov     [esp+1Ch], eax
                mov     eax, [esp+10h]
                mov     ebp, edx
                mov     edi, edx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, eax
                xor     ebp, ebx
                and     ebp, edx
                lea     ecx, [edi+ecx+71374491h]
                mov     edi, [esp]
                xor     ebp, ebx
                add     ecx, [esi+4]
                add     ecx, ebp
                mov     ebp, [esp+4]
                mov     edx, edi
                and     edi, ebp
                or      edx, ebp
                mov     ebp, [esp+1Ch]
                and     edx, ebp
                ror     ebp, 2
                or      edx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     edx, ecx
                xor     ebp, edi
                add     ecx, [esp+8]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+8], ecx
                add     edx, ebp
                mov     [esp+18h], edx
                mov     edx, [esp+0Ch]
                mov     ebp, ecx
                mov     edi, ecx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, edx
                xor     ebp, eax
                and     ebp, ecx
                lea     ebx, [edi+ebx-4A3F0431h]
                mov     edi, [esp+1Ch]
                xor     ebp, eax
                add     ebx, [esi+8]
                add     ebx, ebp
                mov     ebp, [esp]
                mov     ecx, edi
                and     edi, ebp
                or      ecx, ebp
                mov     ebp, [esp+18h]
                and     ecx, ebp
                ror     ebp, 2
                or      ecx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ecx, ebx
                xor     ebp, edi
                add     ebx, [esp+4]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+4], ebx
                add     ecx, ebp
                mov     [esp+14h], ecx
                mov     ecx, [esp+8]
                mov     ebp, ebx
                mov     edi, ebx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ecx
                xor     ebp, edx
                and     ebp, ebx
                lea     eax, [edi+eax-164A245Bh]
                mov     edi, [esp+18h]
                xor     ebp, edx
                add     eax, [esi+0Ch]
                add     eax, ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, edi
                and     edi, ebp
                or      ebx, ebp
                mov     ebp, [esp+14h]
                and     ebx, ebp
                ror     ebp, 2
                or      ebx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ebx, eax
                xor     ebp, edi
                add     eax, [esp]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp], eax
                add     ebx, ebp
                mov     [esp+10h], ebx
                mov     ebx, [esp+4]
                mov     ebp, eax
                mov     edi, eax
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ebx
                xor     ebp, ecx
                and     ebp, eax
                lea     edx, [edi+edx+3956C25Bh]
                mov     edi, [esp+14h]
                xor     ebp, ecx
                add     edx, [esi+10h]
                add     edx, ebp
                mov     ebp, [esp+18h]
                mov     eax, edi
                and     edi, ebp
                or      eax, ebp
                mov     ebp, [esp+10h]
                and     eax, ebp
                ror     ebp, 2
                or      eax, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     eax, edx
                xor     ebp, edi
                add     edx, [esp+1Ch]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+1Ch], edx
                add     eax, ebp
                mov     [esp+0Ch], eax
                mov     eax, [esp]
                mov     ebp, edx
                mov     edi, edx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, eax
                xor     ebp, ebx
                and     ebp, edx
                lea     ecx, [edi+ecx+59F111F1h]
                mov     edi, [esp+10h]
                xor     ebp, ebx
                add     ecx, [esi+14h]
                add     ecx, ebp
                mov     ebp, [esp+14h]
                mov     edx, edi
                and     edi, ebp
                or      edx, ebp
                mov     ebp, [esp+0Ch]
                and     edx, ebp
                ror     ebp, 2
                or      edx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     edx, ecx
                xor     ebp, edi
                add     ecx, [esp+18h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+18h], ecx
                add     edx, ebp
                mov     [esp+8], edx
                mov     edx, [esp+1Ch]
                mov     ebp, ecx
                mov     edi, ecx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, edx
                xor     ebp, eax
                and     ebp, ecx
                lea     ebx, [edi+ebx-6DC07D5Ch]
                mov     edi, [esp+0Ch]
                xor     ebp, eax
                add     ebx, [esi+18h]
                add     ebx, ebp
                mov     ebp, [esp+10h]
                mov     ecx, edi
                and     edi, ebp
                or      ecx, ebp
                mov     ebp, [esp+8]
                and     ecx, ebp
                ror     ebp, 2
                or      ecx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ecx, ebx
                xor     ebp, edi
                add     ebx, [esp+14h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+14h], ebx
                add     ecx, ebp
                mov     [esp+4], ecx
                mov     ecx, [esp+18h]
                mov     ebp, ebx
                mov     edi, ebx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ecx
                xor     ebp, edx
                and     ebp, ebx
                lea     eax, [edi+eax-54E3A12Bh]
                mov     edi, [esp+8]
                xor     ebp, edx
                add     eax, [esi+1Ch]
                add     eax, ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, edi
                and     edi, ebp
                or      ebx, ebp
                mov     ebp, [esp+4]
                and     ebx, ebp
                ror     ebp, 2
                or      ebx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ebx, eax
                xor     ebp, edi
                add     eax, [esp+10h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+10h], eax
                add     ebx, ebp
                mov     [esp], ebx
                mov     ebx, [esp+14h]
                mov     ebp, eax
                mov     edi, eax
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ebx
                xor     ebp, ecx
                and     ebp, eax
                lea     edx, [edi+edx-27F85568h]
                mov     edi, [esp+4]
                xor     ebp, ecx
                add     edx, [esi+20h]
                add     edx, ebp
                mov     ebp, [esp+8]
                mov     eax, edi
                and     edi, ebp
                or      eax, ebp
                mov     ebp, [esp]
                and     eax, ebp
                ror     ebp, 2
                or      eax, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     eax, edx
                xor     ebp, edi
                add     edx, [esp+0Ch]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+0Ch], edx
                add     eax, ebp
                mov     [esp+1Ch], eax
                mov     eax, [esp+10h]
                mov     ebp, edx
                mov     edi, edx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, eax
                xor     ebp, ebx
                and     ebp, edx
                lea     ecx, [edi+ecx+12835B01h]
                mov     edi, [esp]
                xor     ebp, ebx
                add     ecx, [esi+24h]
                add     ecx, ebp
                mov     ebp, [esp+4]
                mov     edx, edi
                and     edi, ebp
                or      edx, ebp
                mov     ebp, [esp+1Ch]
                and     edx, ebp
                ror     ebp, 2
                or      edx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     edx, ecx
                xor     ebp, edi
                add     ecx, [esp+8]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+8], ecx
                add     edx, ebp
                mov     [esp+18h], edx
                mov     edx, [esp+0Ch]
                mov     ebp, ecx
                mov     edi, ecx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, edx
                xor     ebp, eax
                and     ebp, ecx
                lea     ebx, [edi+ebx+243185BEh]
                mov     edi, [esp+1Ch]
                xor     ebp, eax
                add     ebx, [esi+28h]
                add     ebx, ebp
                mov     ebp, [esp]
                mov     ecx, edi
                and     edi, ebp
                or      ecx, ebp
                mov     ebp, [esp+18h]
                and     ecx, ebp
                ror     ebp, 2
                or      ecx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ecx, ebx
                xor     ebp, edi
                add     ebx, [esp+4]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+4], ebx
                add     ecx, ebp
                mov     [esp+14h], ecx
                mov     ecx, [esp+8]
                mov     ebp, ebx
                mov     edi, ebx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ecx
                xor     ebp, edx
                and     ebp, ebx
                lea     eax, [edi+eax+550C7DC3h]
                mov     edi, [esp+18h]
                xor     ebp, edx
                add     eax, [esi+2Ch]
                add     eax, ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, edi
                and     edi, ebp
                or      ebx, ebp
                mov     ebp, [esp+14h]
                and     ebx, ebp
                ror     ebp, 2
                or      ebx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ebx, eax
                xor     ebp, edi
                add     eax, [esp]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp], eax
                add     ebx, ebp
                mov     [esp+10h], ebx
                mov     ebx, [esp+4]
                mov     ebp, eax
                mov     edi, eax
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ebx
                xor     ebp, ecx
                and     ebp, eax
                lea     edx, [edi+edx+72BE5D74h]
                mov     edi, [esp+14h]
                xor     ebp, ecx
                add     edx, [esi+30h]
                add     edx, ebp
                mov     ebp, [esp+18h]
                mov     eax, edi
                and     edi, ebp
                or      eax, ebp
                mov     ebp, [esp+10h]
                and     eax, ebp
                ror     ebp, 2
                or      eax, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     eax, edx
                xor     ebp, edi
                add     edx, [esp+1Ch]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+1Ch], edx
                add     eax, ebp
                mov     [esp+0Ch], eax
                mov     eax, [esp]
                mov     ebp, edx
                mov     edi, edx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, eax
                xor     ebp, ebx
                and     ebp, edx
                lea     ecx, [edi+ecx-7F214E02h]
                mov     edi, [esp+10h]
                xor     ebp, ebx
                add     ecx, [esi+34h]
                add     ecx, ebp
                mov     ebp, [esp+14h]
                mov     edx, edi
                and     edi, ebp
                or      edx, ebp
                mov     ebp, [esp+0Ch]
                and     edx, ebp
                ror     ebp, 2
                or      edx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     edx, ecx
                xor     ebp, edi
                add     ecx, [esp+18h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+18h], ecx
                add     edx, ebp
                mov     [esp+8], edx
                mov     edx, [esp+1Ch]
                mov     ebp, ecx
                mov     edi, ecx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, edx
                xor     ebp, eax
                and     ebp, ecx
                lea     ebx, [edi+ebx-6423F959h]
                mov     edi, [esp+0Ch]
                xor     ebp, eax
                add     ebx, [esi+38h]
                add     ebx, ebp
                mov     ebp, [esp+10h]
                mov     ecx, edi
                and     edi, ebp
                or      ecx, ebp
                mov     ebp, [esp+8]
                and     ecx, ebp
                ror     ebp, 2
                or      ecx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ecx, ebx
                xor     ebp, edi
                add     ebx, [esp+14h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+14h], ebx
                add     ecx, ebp
                mov     [esp+4], ecx
                mov     ecx, [esp+18h]
                mov     ebp, ebx
                mov     edi, ebx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ecx
                xor     ebp, edx
                and     ebp, ebx
                lea     eax, [edi+eax-3E640E8Ch]
                mov     edi, [esp+8]
                xor     ebp, edx
                add     eax, [esi+3Ch]
                add     eax, ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, edi
                and     edi, ebp
                or      ebx, ebp
                mov     ebp, [esp+4]
                and     ebx, ebp
                ror     ebp, 2
                or      ebx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ebx, eax
                xor     ebp, edi
                add     eax, [esp+10h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+10h], eax
                add     ebx, ebp
                mov     [esp], ebx
                mov     ebx, [esp+14h]
                mov     ebp, eax
                mov     edi, eax
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ebx
                xor     ebp, ecx
                and     ebp, eax
                lea     edx, [edi+edx-1B64963Fh]
                mov     edi, [esp+4]
                xor     ebp, ecx
                add     edx, [esi+40h]
                add     edx, ebp
                mov     ebp, [esp+8]
                mov     eax, edi
                and     edi, ebp
                or      eax, ebp
                mov     ebp, [esp]
                and     eax, ebp
                ror     ebp, 2
                or      eax, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     eax, edx
                xor     ebp, edi
                add     edx, [esp+0Ch]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+0Ch], edx
                add     eax, ebp
                mov     [esp+1Ch], eax
                mov     eax, [esp+10h]
                mov     ebp, edx
                mov     edi, edx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, eax
                xor     ebp, ebx
                and     ebp, edx
                lea     ecx, [edi+ecx-1041B87Ah]
                mov     edi, [esp]
                xor     ebp, ebx
                add     ecx, [esi+44h]
                add     ecx, ebp
                mov     ebp, [esp+4]
                mov     edx, edi
                and     edi, ebp
                or      edx, ebp
                mov     ebp, [esp+1Ch]
                and     edx, ebp
                ror     ebp, 2
                or      edx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     edx, ecx
                xor     ebp, edi
                add     ecx, [esp+8]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+8], ecx
                add     edx, ebp
                mov     [esp+18h], edx
                mov     edx, [esp+0Ch]
                mov     ebp, ecx
                mov     edi, ecx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, edx
                xor     ebp, eax
                and     ebp, ecx
                lea     ebx, [edi+ebx+0FC19DC6h]
                mov     edi, [esp+1Ch]
                xor     ebp, eax
                add     ebx, [esi+48h]
                add     ebx, ebp
                mov     ebp, [esp]
                mov     ecx, edi
                and     edi, ebp
                or      ecx, ebp
                mov     ebp, [esp+18h]
                and     ecx, ebp
                ror     ebp, 2
                or      ecx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ecx, ebx
                xor     ebp, edi
                add     ebx, [esp+4]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+4], ebx
                add     ecx, ebp
                mov     [esp+14h], ecx
                mov     ecx, [esp+8]
                mov     ebp, ebx
                mov     edi, ebx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ecx
                xor     ebp, edx
                and     ebp, ebx
                lea     eax, [edi+eax+240CA1CCh]
                mov     edi, [esp+18h]
                xor     ebp, edx
                add     eax, [esi+4Ch]
                add     eax, ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, edi
                and     edi, ebp
                or      ebx, ebp
                mov     ebp, [esp+14h]
                and     ebx, ebp
                ror     ebp, 2
                or      ebx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ebx, eax
                xor     ebp, edi
                add     eax, [esp]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp], eax
                add     ebx, ebp
                mov     [esp+10h], ebx
                mov     ebx, [esp+4]
                mov     ebp, eax
                mov     edi, eax
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ebx
                xor     ebp, ecx
                and     ebp, eax
                lea     edx, [edi+edx+2DE92C6Fh]
                mov     edi, [esp+14h]
                xor     ebp, ecx
                add     edx, [esi+50h]
                add     edx, ebp
                mov     ebp, [esp+18h]
                mov     eax, edi
                and     edi, ebp
                or      eax, ebp
                mov     ebp, [esp+10h]
                and     eax, ebp
                ror     ebp, 2
                or      eax, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     eax, edx
                xor     ebp, edi
                add     edx, [esp+1Ch]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+1Ch], edx
                add     eax, ebp
                mov     [esp+0Ch], eax
                mov     eax, [esp]
                mov     ebp, edx
                mov     edi, edx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, eax
                xor     ebp, ebx
                and     ebp, edx
                lea     ecx, [edi+ecx+4A7484AAh]
                mov     edi, [esp+10h]
                xor     ebp, ebx
                add     ecx, [esi+54h]
                add     ecx, ebp
                mov     ebp, [esp+14h]
                mov     edx, edi
                and     edi, ebp
                or      edx, ebp
                mov     ebp, [esp+0Ch]
                and     edx, ebp
                ror     ebp, 2
                or      edx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     edx, ecx
                xor     ebp, edi
                add     ecx, [esp+18h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+18h], ecx
                add     edx, ebp
                mov     [esp+8], edx
                mov     edx, [esp+1Ch]
                mov     ebp, ecx
                mov     edi, ecx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, edx
                xor     ebp, eax
                and     ebp, ecx
                lea     ebx, [edi+ebx+5CB0A9DCh]
                mov     edi, [esp+0Ch]
                xor     ebp, eax
                add     ebx, [esi+58h]
                add     ebx, ebp
                mov     ebp, [esp+10h]
                mov     ecx, edi
                and     edi, ebp
                or      ecx, ebp
                mov     ebp, [esp+8]
                and     ecx, ebp
                ror     ebp, 2
                or      ecx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ecx, ebx
                xor     ebp, edi
                add     ebx, [esp+14h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+14h], ebx
                add     ecx, ebp
                mov     [esp+4], ecx
                mov     ecx, [esp+18h]
                mov     ebp, ebx
                mov     edi, ebx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ecx
                xor     ebp, edx
                and     ebp, ebx
                lea     eax, [edi+eax+76F988DAh]
                mov     edi, [esp+8]
                xor     ebp, edx
                add     eax, [esi+5Ch]
                add     eax, ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, edi
                and     edi, ebp
                or      ebx, ebp
                mov     ebp, [esp+4]
                and     ebx, ebp
                ror     ebp, 2
                or      ebx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ebx, eax
                xor     ebp, edi
                add     eax, [esp+10h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+10h], eax
                add     ebx, ebp
                mov     [esp], ebx
                mov     ebx, [esp+14h]
                mov     ebp, eax
                mov     edi, eax
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ebx
                xor     ebp, ecx
                and     ebp, eax
                lea     edx, [edi+edx-67C1AEAEh]
                mov     edi, [esp+4]
                xor     ebp, ecx
                add     edx, [esi+60h]
                add     edx, ebp
                mov     ebp, [esp+8]
                mov     eax, edi
                and     edi, ebp
                or      eax, ebp
                mov     ebp, [esp]
                and     eax, ebp
                ror     ebp, 2
                or      eax, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     eax, edx
                xor     ebp, edi
                add     edx, [esp+0Ch]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+0Ch], edx
                add     eax, ebp
                mov     [esp+1Ch], eax
                mov     eax, [esp+10h]
                mov     ebp, edx
                mov     edi, edx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, eax
                xor     ebp, ebx
                and     ebp, edx
                lea     ecx, [edi+ecx-57CE3993h]
                mov     edi, [esp]
                xor     ebp, ebx
                add     ecx, [esi+64h]
                add     ecx, ebp
                mov     ebp, [esp+4]
                mov     edx, edi
                and     edi, ebp
                or      edx, ebp
                mov     ebp, [esp+1Ch]
                and     edx, ebp
                ror     ebp, 2
                or      edx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     edx, ecx
                xor     ebp, edi
                add     ecx, [esp+8]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+8], ecx
                add     edx, ebp
                mov     [esp+18h], edx
                mov     edx, [esp+0Ch]
                mov     ebp, ecx
                mov     edi, ecx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, edx
                xor     ebp, eax
                and     ebp, ecx
                lea     ebx, [edi+ebx-4FFCD838h]
                mov     edi, [esp+1Ch]
                xor     ebp, eax
                add     ebx, [esi+68h]
                add     ebx, ebp
                mov     ebp, [esp]
                mov     ecx, edi
                and     edi, ebp
                or      ecx, ebp
                mov     ebp, [esp+18h]
                and     ecx, ebp
                ror     ebp, 2
                or      ecx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ecx, ebx
                xor     ebp, edi
                add     ebx, [esp+4]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+4], ebx
                add     ecx, ebp
                mov     [esp+14h], ecx
                mov     ecx, [esp+8]
                mov     ebp, ebx
                mov     edi, ebx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ecx
                xor     ebp, edx
                and     ebp, ebx
                lea     eax, [edi+eax-40A68039h]
                mov     edi, [esp+18h]
                xor     ebp, edx
                add     eax, [esi+6Ch]
                add     eax, ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, edi
                and     edi, ebp
                or      ebx, ebp
                mov     ebp, [esp+14h]
                and     ebx, ebp
                ror     ebp, 2
                or      ebx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ebx, eax
                xor     ebp, edi
                add     eax, [esp]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp], eax
                add     ebx, ebp
                mov     [esp+10h], ebx
                mov     ebx, [esp+4]
                mov     ebp, eax
                mov     edi, eax
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ebx
                xor     ebp, ecx
                and     ebp, eax
                lea     edx, [edi+edx-391FF40Dh]
                mov     edi, [esp+14h]
                xor     ebp, ecx
                add     edx, [esi+70h]
                add     edx, ebp
                mov     ebp, [esp+18h]
                mov     eax, edi
                and     edi, ebp
                or      eax, ebp
                mov     ebp, [esp+10h]
                and     eax, ebp
                ror     ebp, 2
                or      eax, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     eax, edx
                xor     ebp, edi
                add     edx, [esp+1Ch]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+1Ch], edx
                add     eax, ebp
                mov     [esp+0Ch], eax
                mov     eax, [esp]
                mov     ebp, edx
                mov     edi, edx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, eax
                xor     ebp, ebx
                and     ebp, edx
                lea     ecx, [edi+ecx-2A586EB9h]
                mov     edi, [esp+10h]
                xor     ebp, ebx
                add     ecx, [esi+74h]
                add     ecx, ebp
                mov     ebp, [esp+14h]
                mov     edx, edi
                and     edi, ebp
                or      edx, ebp
                mov     ebp, [esp+0Ch]
                and     edx, ebp
                ror     ebp, 2
                or      edx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     edx, ecx
                xor     ebp, edi
                add     ecx, [esp+18h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+18h], ecx
                add     edx, ebp
                mov     [esp+8], edx
                mov     edx, [esp+1Ch]
                mov     ebp, ecx
                mov     edi, ecx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, edx
                xor     ebp, eax
                and     ebp, ecx
                lea     ebx, [edi+ebx+6CA6351h]
                mov     edi, [esp+0Ch]
                xor     ebp, eax
                add     ebx, [esi+78h]
                add     ebx, ebp
                mov     ebp, [esp+10h]
                mov     ecx, edi
                and     edi, ebp
                or      ecx, ebp
                mov     ebp, [esp+8]
                and     ecx, ebp
                ror     ebp, 2
                or      ecx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ecx, ebx
                xor     ebp, edi
                add     ebx, [esp+14h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+14h], ebx
                add     ecx, ebp
                mov     [esp+4], ecx
                mov     ecx, [esp+18h]
                mov     ebp, ebx
                mov     edi, ebx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ecx
                xor     ebp, edx
                and     ebp, ebx
                lea     eax, [edi+eax+14292967h]
                mov     edi, [esp+8]
                xor     ebp, edx
                add     eax, [esi+7Ch]
                add     eax, ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, edi
                and     edi, ebp
                or      ebx, ebp
                mov     ebp, [esp+4]
                and     ebx, ebp
                ror     ebp, 2
                or      ebx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ebx, eax
                xor     ebp, edi
                add     eax, [esp+10h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+10h], eax
                add     ebx, ebp
                mov     [esp], ebx
                mov     ebx, [esp+14h]
                mov     ebp, eax
                mov     edi, eax
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ebx
                xor     ebp, ecx
                and     ebp, eax
                lea     edx, [edi+edx+27B70A85h]
                mov     edi, [esp+4]
                xor     ebp, ecx
                add     edx, [esi+80h]
                add     edx, ebp
                mov     ebp, [esp+8]
                mov     eax, edi
                and     edi, ebp
                or      eax, ebp
                mov     ebp, [esp]
                and     eax, ebp
                ror     ebp, 2
                or      eax, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     eax, edx
                xor     ebp, edi
                add     edx, [esp+0Ch]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+0Ch], edx
                add     eax, ebp
                mov     [esp+1Ch], eax
                mov     eax, [esp+10h]
                mov     ebp, edx
                mov     edi, edx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, eax
                xor     ebp, ebx
                and     ebp, edx
                lea     ecx, [edi+ecx+2E1B2138h]
                mov     edi, [esp]
                xor     ebp, ebx
                add     ecx, [esi+84h]
                add     ecx, ebp
                mov     ebp, [esp+4]
                mov     edx, edi
                and     edi, ebp
                or      edx, ebp
                mov     ebp, [esp+1Ch]
                and     edx, ebp
                ror     ebp, 2
                or      edx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     edx, ecx
                xor     ebp, edi
                add     ecx, [esp+8]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+8], ecx
                add     edx, ebp
                mov     [esp+18h], edx
                mov     edx, [esp+0Ch]
                mov     ebp, ecx
                mov     edi, ecx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, edx
                xor     ebp, eax
                and     ebp, ecx
                lea     ebx, [edi+ebx+4D2C6DFCh]
                mov     edi, [esp+1Ch]
                xor     ebp, eax
                add     ebx, [esi+88h]
                add     ebx, ebp
                mov     ebp, [esp]
                mov     ecx, edi
                and     edi, ebp
                or      ecx, ebp
                mov     ebp, [esp+18h]
                and     ecx, ebp
                ror     ebp, 2
                or      ecx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ecx, ebx
                xor     ebp, edi
                add     ebx, [esp+4]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+4], ebx
                add     ecx, ebp
                mov     [esp+14h], ecx
                mov     ecx, [esp+8]
                mov     ebp, ebx
                mov     edi, ebx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ecx
                xor     ebp, edx
                and     ebp, ebx
                lea     eax, [edi+eax+53380D13h]
                mov     edi, [esp+18h]
                xor     ebp, edx
                add     eax, [esi+8Ch]
                add     eax, ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, edi
                and     edi, ebp
                or      ebx, ebp
                mov     ebp, [esp+14h]
                and     ebx, ebp
                ror     ebp, 2
                or      ebx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ebx, eax
                xor     ebp, edi
                add     eax, [esp]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp], eax
                add     ebx, ebp
                mov     [esp+10h], ebx
                mov     ebx, [esp+4]
                mov     ebp, eax
                mov     edi, eax
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ebx
                xor     ebp, ecx
                and     ebp, eax
                lea     edx, [edi+edx+650A7354h]
                mov     edi, [esp+14h]
                xor     ebp, ecx
                add     edx, [esi+90h]
                add     edx, ebp
                mov     ebp, [esp+18h]
                mov     eax, edi
                and     edi, ebp
                or      eax, ebp
                mov     ebp, [esp+10h]
                and     eax, ebp
                ror     ebp, 2
                or      eax, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     eax, edx
                xor     ebp, edi
                add     edx, [esp+1Ch]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+1Ch], edx
                add     eax, ebp
                mov     [esp+0Ch], eax
                mov     eax, [esp]
                mov     ebp, edx
                mov     edi, edx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, eax
                xor     ebp, ebx
                and     ebp, edx
                lea     ecx, [edi+ecx+766A0ABBh]
                mov     edi, [esp+10h]
                xor     ebp, ebx
                add     ecx, [esi+94h]
                add     ecx, ebp
                mov     ebp, [esp+14h]
                mov     edx, edi
                and     edi, ebp
                or      edx, ebp
                mov     ebp, [esp+0Ch]
                and     edx, ebp
                ror     ebp, 2
                or      edx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     edx, ecx
                xor     ebp, edi
                add     ecx, [esp+18h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+18h], ecx
                add     edx, ebp
                mov     [esp+8], edx
                mov     edx, [esp+1Ch]
                mov     ebp, ecx
                mov     edi, ecx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, edx
                xor     ebp, eax
                and     ebp, ecx
                lea     ebx, [edi+ebx-7E3D36D2h]
                mov     edi, [esp+0Ch]
                xor     ebp, eax
                add     ebx, [esi+98h]
                add     ebx, ebp
                mov     ebp, [esp+10h]
                mov     ecx, edi
                and     edi, ebp
                or      ecx, ebp
                mov     ebp, [esp+8]
                and     ecx, ebp
                ror     ebp, 2
                or      ecx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ecx, ebx
                xor     ebp, edi
                add     ebx, [esp+14h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+14h], ebx
                add     ecx, ebp
                mov     [esp+4], ecx
                mov     ecx, [esp+18h]
                mov     ebp, ebx
                mov     edi, ebx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ecx
                xor     ebp, edx
                and     ebp, ebx
                lea     eax, [edi+eax-6D8DD37Bh]
                mov     edi, [esp+8]
                xor     ebp, edx
                add     eax, [esi+9Ch]
                add     eax, ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, edi
                and     edi, ebp
                or      ebx, ebp
                mov     ebp, [esp+4]
                and     ebx, ebp
                ror     ebp, 2
                or      ebx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ebx, eax
                xor     ebp, edi
                add     eax, [esp+10h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+10h], eax
                add     ebx, ebp
                mov     [esp], ebx
                mov     ebx, [esp+14h]
                mov     ebp, eax
                mov     edi, eax
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ebx
                xor     ebp, ecx
                and     ebp, eax
                lea     edx, [edi+edx-5D40175Fh]
                mov     edi, [esp+4]
                xor     ebp, ecx
                add     edx, [esi+0A0h]
                add     edx, ebp
                mov     ebp, [esp+8]
                mov     eax, edi
                and     edi, ebp
                or      eax, ebp
                mov     ebp, [esp]
                and     eax, ebp
                ror     ebp, 2
                or      eax, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     eax, edx
                xor     ebp, edi
                add     edx, [esp+0Ch]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+0Ch], edx
                add     eax, ebp
                mov     [esp+1Ch], eax
                mov     eax, [esp+10h]
                mov     ebp, edx
                mov     edi, edx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, eax
                xor     ebp, ebx
                and     ebp, edx
                lea     ecx, [edi+ecx-57E599B5h]
                mov     edi, [esp]
                xor     ebp, ebx
                add     ecx, [esi+0A4h]
                add     ecx, ebp
                mov     ebp, [esp+4]
                mov     edx, edi
                and     edi, ebp
                or      edx, ebp
                mov     ebp, [esp+1Ch]
                and     edx, ebp
                ror     ebp, 2
                or      edx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     edx, ecx
                xor     ebp, edi
                add     ecx, [esp+8]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+8], ecx
                add     edx, ebp
                mov     [esp+18h], edx
                mov     edx, [esp+0Ch]
                mov     ebp, ecx
                mov     edi, ecx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, edx
                xor     ebp, eax
                and     ebp, ecx
                lea     ebx, [edi+ebx-3DB47490h]
                mov     edi, [esp+1Ch]
                xor     ebp, eax
                add     ebx, [esi+0A8h]
                add     ebx, ebp
                mov     ebp, [esp]
                mov     ecx, edi
                and     edi, ebp
                or      ecx, ebp
                mov     ebp, [esp+18h]
                and     ecx, ebp
                ror     ebp, 2
                or      ecx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ecx, ebx
                xor     ebp, edi
                add     ebx, [esp+4]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+4], ebx
                add     ecx, ebp
                mov     [esp+14h], ecx
                mov     ecx, [esp+8]
                mov     ebp, ebx
                mov     edi, ebx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ecx
                xor     ebp, edx
                and     ebp, ebx
                lea     eax, [edi+eax-3893AE5Dh]
                mov     edi, [esp+18h]
                xor     ebp, edx
                add     eax, [esi+0ACh]
                add     eax, ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, edi
                and     edi, ebp
                or      ebx, ebp
                mov     ebp, [esp+14h]
                and     ebx, ebp
                ror     ebp, 2
                or      ebx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ebx, eax
                xor     ebp, edi
                add     eax, [esp]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp], eax
                add     ebx, ebp
                mov     [esp+10h], ebx
                mov     ebx, [esp+4]
                mov     ebp, eax
                mov     edi, eax
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ebx
                xor     ebp, ecx
                and     ebp, eax
                lea     edx, [edi+edx-2E6D17E7h]
                mov     edi, [esp+14h]
                xor     ebp, ecx
                add     edx, [esi+0B0h]
                add     edx, ebp
                mov     ebp, [esp+18h]
                mov     eax, edi
                and     edi, ebp
                or      eax, ebp
                mov     ebp, [esp+10h]
                and     eax, ebp
                ror     ebp, 2
                or      eax, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     eax, edx
                xor     ebp, edi
                add     edx, [esp+1Ch]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+1Ch], edx
                add     eax, ebp
                mov     [esp+0Ch], eax
                mov     eax, [esp]
                mov     ebp, edx
                mov     edi, edx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, eax
                xor     ebp, ebx
                and     ebp, edx
                lea     ecx, [edi+ecx-2966F9DCh]
                mov     edi, [esp+10h]
                xor     ebp, ebx
                add     ecx, [esi+0B4h]
                add     ecx, ebp
                mov     ebp, [esp+14h]
                mov     edx, edi
                and     edi, ebp
                or      edx, ebp
                mov     ebp, [esp+0Ch]
                and     edx, ebp
                ror     ebp, 2
                or      edx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     edx, ecx
                xor     ebp, edi
                add     ecx, [esp+18h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+18h], ecx
                add     edx, ebp
                mov     [esp+8], edx
                mov     edx, [esp+1Ch]
                mov     ebp, ecx
                mov     edi, ecx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, edx
                xor     ebp, eax
                and     ebp, ecx
                lea     ebx, [edi+ebx-0BF1CA7Bh]
                mov     edi, [esp+0Ch]
                xor     ebp, eax
                add     ebx, [esi+0B8h]
                add     ebx, ebp
                mov     ebp, [esp+10h]
                mov     ecx, edi
                and     edi, ebp
                or      ecx, ebp
                mov     ebp, [esp+8]
                and     ecx, ebp
                ror     ebp, 2
                or      ecx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ecx, ebx
                xor     ebp, edi
                add     ebx, [esp+14h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+14h], ebx
                add     ecx, ebp
                mov     [esp+4], ecx
                mov     ecx, [esp+18h]
                mov     ebp, ebx
                mov     edi, ebx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ecx
                xor     ebp, edx
                and     ebp, ebx
                lea     eax, [edi+eax+106AA070h]
                mov     edi, [esp+8]
                xor     ebp, edx
                add     eax, [esi+0BCh]
                add     eax, ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, edi
                and     edi, ebp
                or      ebx, ebp
                mov     ebp, [esp+4]
                and     ebx, ebp
                ror     ebp, 2
                or      ebx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ebx, eax
                xor     ebp, edi
                add     eax, [esp+10h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+10h], eax
                add     ebx, ebp
                mov     [esp], ebx
                mov     ebx, [esp+14h]
                mov     ebp, eax
                mov     edi, eax
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ebx
                xor     ebp, ecx
                and     ebp, eax
                lea     edx, [edi+edx+19A4C116h]
                mov     edi, [esp+4]
                xor     ebp, ecx
                add     edx, [esi+0C0h]
                add     edx, ebp
                mov     ebp, [esp+8]
                mov     eax, edi
                and     edi, ebp
                or      eax, ebp
                mov     ebp, [esp]
                and     eax, ebp
                ror     ebp, 2
                or      eax, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     eax, edx
                xor     ebp, edi
                add     edx, [esp+0Ch]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+0Ch], edx
                add     eax, ebp
                mov     [esp+1Ch], eax
                mov     eax, [esp+10h]
                mov     ebp, edx
                mov     edi, edx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, eax
                xor     ebp, ebx
                and     ebp, edx
                lea     ecx, [edi+ecx+1E376C08h]
                mov     edi, [esp]
                xor     ebp, ebx
                add     ecx, [esi+0C4h]
                add     ecx, ebp
                mov     ebp, [esp+4]
                mov     edx, edi
                and     edi, ebp
                or      edx, ebp
                mov     ebp, [esp+1Ch]
                and     edx, ebp
                ror     ebp, 2
                or      edx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     edx, ecx
                xor     ebp, edi
                add     ecx, [esp+8]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+8], ecx
                add     edx, ebp
                mov     [esp+18h], edx
                mov     edx, [esp+0Ch]
                mov     ebp, ecx
                mov     edi, ecx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, edx
                xor     ebp, eax
                and     ebp, ecx
                lea     ebx, [edi+ebx+2748774Ch]
                mov     edi, [esp+1Ch]
                xor     ebp, eax
                add     ebx, [esi+0C8h]
                add     ebx, ebp
                mov     ebp, [esp]
                mov     ecx, edi
                and     edi, ebp
                or      ecx, ebp
                mov     ebp, [esp+18h]
                and     ecx, ebp
                ror     ebp, 2
                or      ecx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ecx, ebx
                xor     ebp, edi
                add     ebx, [esp+4]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+4], ebx
                add     ecx, ebp
                mov     [esp+14h], ecx
                mov     ecx, [esp+8]
                mov     ebp, ebx
                mov     edi, ebx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ecx
                xor     ebp, edx
                and     ebp, ebx
                lea     eax, [edi+eax+34B0BCB5h]
                mov     edi, [esp+18h]
                xor     ebp, edx
                add     eax, [esi+0CCh]
                add     eax, ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, edi
                and     edi, ebp
                or      ebx, ebp
                mov     ebp, [esp+14h]
                and     ebx, ebp
                ror     ebp, 2
                or      ebx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ebx, eax
                xor     ebp, edi
                add     eax, [esp]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp], eax
                add     ebx, ebp
                mov     [esp+10h], ebx
                mov     ebx, [esp+4]
                mov     ebp, eax
                mov     edi, eax
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ebx
                xor     ebp, ecx
                and     ebp, eax
                lea     edx, [edi+edx+391C0CB3h]
                mov     edi, [esp+14h]
                xor     ebp, ecx
                add     edx, [esi+0D0h]
                add     edx, ebp
                mov     ebp, [esp+18h]
                mov     eax, edi
                and     edi, ebp
                or      eax, ebp
                mov     ebp, [esp+10h]
                and     eax, ebp
                ror     ebp, 2
                or      eax, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     eax, edx
                xor     ebp, edi
                add     edx, [esp+1Ch]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+1Ch], edx
                add     eax, ebp
                mov     [esp+0Ch], eax
                mov     eax, [esp]
                mov     ebp, edx
                mov     edi, edx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, eax
                xor     ebp, ebx
                and     ebp, edx
                lea     ecx, [edi+ecx+4ED8AA4Ah]
                mov     edi, [esp+10h]
                xor     ebp, ebx
                add     ecx, [esi+0D4h]
                add     ecx, ebp
                mov     ebp, [esp+14h]
                mov     edx, edi
                and     edi, ebp
                or      edx, ebp
                mov     ebp, [esp+0Ch]
                and     edx, ebp
                ror     ebp, 2
                or      edx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     edx, ecx
                xor     ebp, edi
                add     ecx, [esp+18h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+18h], ecx
                add     edx, ebp
                mov     [esp+8], edx
                mov     edx, [esp+1Ch]
                mov     ebp, ecx
                mov     edi, ecx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, edx
                xor     ebp, eax
                and     ebp, ecx
                lea     ebx, [edi+ebx+5B9CCA4Fh]
                mov     edi, [esp+0Ch]
                xor     ebp, eax
                add     ebx, [esi+0D8h]
                add     ebx, ebp
                mov     ebp, [esp+10h]
                mov     ecx, edi
                and     edi, ebp
                or      ecx, ebp
                mov     ebp, [esp+8]
                and     ecx, ebp
                ror     ebp, 2
                or      ecx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ecx, ebx
                xor     ebp, edi
                add     ebx, [esp+14h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+14h], ebx
                add     ecx, ebp
                mov     [esp+4], ecx
                mov     ecx, [esp+18h]
                mov     ebp, ebx
                mov     edi, ebx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ecx
                xor     ebp, edx
                and     ebp, ebx
                lea     eax, [edi+eax+682E6FF3h]
                mov     edi, [esp+8]
                xor     ebp, edx
                add     eax, [esi+0DCh]
                add     eax, ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, edi
                and     edi, ebp
                or      ebx, ebp
                mov     ebp, [esp+4]
                and     ebx, ebp
                ror     ebp, 2
                or      ebx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ebx, eax
                xor     ebp, edi
                add     eax, [esp+10h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+10h], eax
                add     ebx, ebp
                mov     [esp], ebx
                mov     ebx, [esp+14h]
                mov     ebp, eax
                mov     edi, eax
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ebx
                xor     ebp, ecx
                and     ebp, eax
                lea     edx, [edi+edx+748F82EEh]
                mov     edi, [esp+4]
                xor     ebp, ecx
                add     edx, [esi+0E0h]
                add     edx, ebp
                mov     ebp, [esp+8]
                mov     eax, edi
                and     edi, ebp
                or      eax, ebp
                mov     ebp, [esp]
                and     eax, ebp
                ror     ebp, 2
                or      eax, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     eax, edx
                xor     ebp, edi
                add     edx, [esp+0Ch]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+0Ch], edx
                add     eax, ebp
                mov     [esp+1Ch], eax
                mov     eax, [esp+10h]
                mov     ebp, edx
                mov     edi, edx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, eax
                xor     ebp, ebx
                and     ebp, edx
                lea     ecx, [edi+ecx+78A5636Fh]
                mov     edi, [esp]
                xor     ebp, ebx
                add     ecx, [esi+0E4h]
                add     ecx, ebp
                mov     ebp, [esp+4]
                mov     edx, edi
                and     edi, ebp
                or      edx, ebp
                mov     ebp, [esp+1Ch]
                and     edx, ebp
                ror     ebp, 2
                or      edx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     edx, ecx
                xor     ebp, edi
                add     ecx, [esp+8]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+8], ecx
                add     edx, ebp
                mov     [esp+18h], edx
                mov     edx, [esp+0Ch]
                mov     ebp, ecx
                mov     edi, ecx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, edx
                xor     ebp, eax
                and     ebp, ecx
                lea     ebx, [edi+ebx-7B3787ECh]
                mov     edi, [esp+1Ch]
                xor     ebp, eax
                add     ebx, [esi+0E8h]
                add     ebx, ebp
                mov     ebp, [esp]
                mov     ecx, edi
                and     edi, ebp
                or      ecx, ebp
                mov     ebp, [esp+18h]
                and     ecx, ebp
                ror     ebp, 2
                or      ecx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ecx, ebx
                xor     ebp, edi
                add     ebx, [esp+4]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+4], ebx
                add     ecx, ebp
                mov     [esp+14h], ecx
                mov     ecx, [esp+8]
                mov     ebp, ebx
                mov     edi, ebx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ecx
                xor     ebp, edx
                and     ebp, ebx
                lea     eax, [edi+eax-7338FDF8h]
                mov     edi, [esp+18h]
                xor     ebp, edx
                add     eax, [esi+0ECh]
                add     eax, ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, edi
                and     edi, ebp
                or      ebx, ebp
                mov     ebp, [esp+14h]
                and     ebx, ebp
                ror     ebp, 2
                or      ebx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ebx, eax
                xor     ebp, edi
                add     eax, [esp]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp], eax
                add     ebx, ebp
                mov     [esp+10h], ebx
                mov     ebx, [esp+4]
                mov     ebp, eax
                mov     edi, eax
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ebx
                xor     ebp, ecx
                and     ebp, eax
                lea     edx, [edi+edx-6F410006h]
                mov     edi, [esp+14h]
                xor     ebp, ecx
                add     edx, [esi+0F0h]
                add     edx, ebp
                mov     ebp, [esp+18h]
                mov     eax, edi
                and     edi, ebp
                or      eax, ebp
                mov     ebp, [esp+10h]
                and     eax, ebp
                ror     ebp, 2
                or      eax, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     eax, edx
                xor     ebp, edi
                add     edx, [esp+1Ch]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+1Ch], edx
                add     eax, ebp
                mov     [esp+0Ch], eax
                mov     eax, [esp]
                mov     ebp, edx
                mov     edi, edx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, eax
                xor     ebp, ebx
                and     ebp, edx
                lea     ecx, [edi+ecx-5BAF9315h]
                mov     edi, [esp+10h]
                xor     ebp, ebx
                add     ecx, [esi+0F4h]
                add     ecx, ebp
                mov     ebp, [esp+14h]
                mov     edx, edi
                and     edi, ebp
                or      edx, ebp
                mov     ebp, [esp+0Ch]
                and     edx, ebp
                ror     ebp, 2
                or      edx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     edx, ecx
                xor     ebp, edi
                add     ecx, [esp+18h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+18h], ecx
                add     edx, ebp
                mov     [esp+8], edx
                mov     edx, [esp+1Ch]
                mov     ebp, ecx
                mov     edi, ecx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, edx
                xor     ebp, eax
                and     ebp, ecx
                lea     ebx, [edi+ebx-41065C09h]
                mov     edi, [esp+0Ch]
                xor     ebp, eax
                add     ebx, [esi+0F8h]
                add     ebx, ebp
                mov     ebp, [esp+10h]
                mov     ecx, edi
                and     edi, ebp
                or      ecx, ebp
                mov     ebp, [esp+8]
                and     ecx, ebp
                ror     ebp, 2
                or      ecx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ecx, ebx
                xor     ebp, edi
                add     ebx, [esp+14h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+14h], ebx
                add     ecx, ebp
                mov     [esp+4], ecx
                mov     ecx, [esp+18h]
                mov     ebp, ebx
                mov     edi, ebx
                ror     ebp, 6
                rol     edi, 7
                xor     edi, ebp
                ror     ebp, 5
                xor     edi, ebp
                mov     ebp, ecx
                xor     ebp, edx
                and     ebp, ebx
                lea     eax, [edi+eax-398E870Eh]
                mov     edi, [esp+8]
                xor     ebp, edx
                add     eax, [esi+0FCh]
                add     eax, ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, edi
                and     edi, ebp
                or      ebx, ebp
                mov     ebp, [esp+4]
                and     ebx, ebp
                ror     ebp, 2
                or      ebx, edi
                mov     edi, ebp
                rol     edi, 0Ch
                add     ebx, eax
                xor     ebp, edi
                add     eax, [esp+10h]
                rol     edi, 9
                xor     ebp, edi
                mov     [esp+10h], eax
                add     ebx, ebp
                mov     [esp], ebx
                mov     ebx, [esp+14h]
                mov     edi, [esp+24h]
                add     [edi+10h], eax
                add     [edi+14h], ebx
                add     [edi+18h], ecx
                add     [edi+1Ch], edx
                mov     eax, [esp]
                mov     ebx, [esp+4]
                mov     ecx, [esp+8]
                mov     edx, [esp+0Ch]
                mov     ebp, [esp+28h]
                add     [edi], eax
                add     [edi+4], ebx
                mov     esp, ebp
                add     [edi+8], ecx
                add     [edi+0Ch], edx
                pop     ebp
                pop     edi
                pop     esi
                pop     ebx
  end;
end;
{$ENDIF}

{$IFDEF THash_SHA384_asm}
procedure SHA384Buffer(S, D: Pointer); assembler;
asm
                push ebx
                push edi
                mov  edi, eax
                push esi
                mov  esi, edx

                mov     eax, [esi]
                mov     ebx, [esi+4]
                bswap   eax
                bswap   ebx
                mov     ecx, [esi+8]
                mov     edx, [esi+0Ch]
                bswap   ecx
                bswap   edx
                mov     [edi], ebx
                mov     [edi+4], eax
                mov     [edi+8], edx
                mov     [edi+0Ch], ecx
                mov     eax, [esi+10h]
                mov     ebx, [esi+14h]
                bswap   eax
                bswap   ebx
                mov     ecx, [esi+18h]
                mov     edx, [esi+1Ch]
                bswap   ecx
                bswap   edx
                mov     [edi+10h], ebx
                mov     [edi+14h], eax
                mov     [edi+18h], edx
                mov     [edi+1Ch], ecx
                mov     eax, [esi+20h]
                mov     ebx, [esi+24h]
                bswap   eax
                bswap   ebx
                mov     ecx, [esi+28h]
                mov     edx, [esi+2Ch]
                bswap   ecx
                bswap   edx
                mov     [edi+20h], ebx
                mov     [edi+24h], eax
                mov     [edi+28h], edx
                mov     [edi+2Ch], ecx
                mov     eax, [esi+30h]
                mov     ebx, [esi+34h]
                bswap   eax
                bswap   ebx
                mov     ecx, [esi+38h]
                mov     edx, [esi+3Ch]
                bswap   ecx
                bswap   edx
                mov     [edi+30h], ebx
                mov     [edi+34h], eax
                mov     [edi+38h], edx
                mov     [edi+3Ch], ecx



                pop  esi
                pop  edi
                pop  ebx
end;

procedure THash_SHA384.DoTransform(Buffer: PLongArray);
var
  W: array [0..159] of LongWord;
begin
  // swap first 16 uint64
  SHA384Buffer(@W[0],  @Buffer[0]);
  SHA384Buffer(Pointer(LongInt(@W[0]) + 16*4), Pointer(LongInt(@Buffer[0]) + 16*4));
  asm
    push    ebx
    push    esi
    push    edi
    push    ebp

    mov     eax, Self
    lea     edi, [eax].THash_SHA512.FDigest
    lea     esi, W
    lea     ebp, SHA_512K

  //  {$INCLUDE sha512t.inc}  // include sha512 asm transform code

                sub     esp, 60h
                mov     [esp+54h], ebp
                mov     [esp+5Ch], edi
                mov     [esp+58h], esi
                mov     dword ptr [esp+50h], 10h

@@buffexpand_loop:
                mov     ebp, [esi+8]
                mov     eax, [esi+0Ch]
                mov     ecx, ebp
                mov     edi, eax
                shl     eax, 18h
                mov     edx, edi
                shr     ecx, 1
                mov     ebx, eax
                shl     edx, 1Fh
                shl     ebx, 1
                or      edx, ecx
                shr     ecx, 6
                or      ebx, ecx
                shr     ecx, 1
                xor     edx, ebx
                shl     ebp, 18h
                or      eax, ecx
                shr     edi, 1
                mov     ecx, ebp
                shl     ecx, 7
                or      ecx, edi
                shr     edi, 6
                xor     edx, eax
                xor     ecx, edi
                mov     [esp+40h], edx
                shr     edi, 1
                or      ebp, edi
                xor     ecx, ebp
                mov     ebp, [esi+70h]
                mov     edi, [esi+74h]
                mov     [esp+44h], ecx
                mov     ecx, ebp
                mov     edx, edi
                shl     ecx, 3
                mov     eax, ebp
                shr     edx, 1Dh
                mov     ebx, edi
                shr     eax, 6
                or      edx, ecx
                shl     ebx, 1Ah
                or      eax, ebx
                mov     ebx, edi
                xor     edx, eax
                shr     eax, 0Dh
                mov     ecx, ebp
                shl     ebx, 0Dh
                or      eax, ebx
                shr     ecx, 1Dh
                xor     eax, edx
                mov     edx, edi
                shl     edx, 3
                shr     edi, 6
                or      edx, ecx
                xor     edx, edi
                shr     edi, 0Dh
                mov     ecx, eax
                shl     ebp, 0Dh
                mov     eax, [esp+40h]
                or      edi, ebp
                mov     ebx, [esp+44h]
                xor     edx, edi
                mov     ebp, [esi]
                mov     edi, [esi+4]
                add     eax, ecx
                adc     ebx, edx
                add     eax, ebp
                adc     ebx, edi
                mov     ebp, [esi+48h]
                mov     edi, [esi+4Ch]
                add     eax, ebp
                adc     ebx, edi
                mov     [esi+80h], eax
                mov     [esi+84h], ebx
                mov     ebp, [esi+10h]
                mov     eax, [esi+14h]
                mov     ecx, ebp
                mov     edi, eax
                shl     eax, 18h
                mov     edx, edi
                shr     ecx, 1
                mov     ebx, eax
                shl     edx, 1Fh
                shl     ebx, 1
                or      edx, ecx
                shr     ecx, 6
                or      ebx, ecx
                shr     ecx, 1
                xor     edx, ebx
                shl     ebp, 18h
                or      eax, ecx
                shr     edi, 1
                mov     ecx, ebp
                shl     ecx, 7
                or      ecx, edi
                shr     edi, 6
                xor     edx, eax
                xor     ecx, edi
                mov     [esp+40h], edx
                shr     edi, 1
                or      ebp, edi
                xor     ecx, ebp
                mov     ebp, [esi+78h]
                mov     edi, [esi+7Ch]
                mov     [esp+44h], ecx
                mov     ecx, ebp
                mov     edx, edi
                shl     ecx, 3
                mov     eax, ebp
                shr     edx, 1Dh
                mov     ebx, edi
                shr     eax, 6
                or      edx, ecx
                shl     ebx, 1Ah
                or      eax, ebx
                mov     ebx, edi
                xor     edx, eax
                shr     eax, 0Dh
                mov     ecx, ebp
                shl     ebx, 0Dh
                or      eax, ebx
                shr     ecx, 1Dh
                xor     eax, edx
                mov     edx, edi
                shl     edx, 3
                shr     edi, 6
                or      edx, ecx
                xor     edx, edi
                shr     edi, 0Dh
                mov     ecx, eax
                shl     ebp, 0Dh
                mov     eax, [esp+40h]
                or      edi, ebp
                mov     ebx, [esp+44h]
                xor     edx, edi
                mov     ebp, [esi+8]
                mov     edi, [esi+0Ch]
                add     eax, ecx
                adc     ebx, edx
                add     eax, ebp
                adc     ebx, edi
                mov     ebp, [esi+50h]
                mov     edi, [esi+54h]
                add     eax, ebp
                adc     ebx, edi
                mov     [esi+88h], eax
                mov     [esi+8Ch], ebx
                add     esi, 10h
                add     dword ptr [esp+50h], 2
                cmp     dword ptr [esp+50h], 50h 
                jnz     @@buffexpand_loop
                mov     edi, [esp+5Ch]
                mov     esi, [esp+58h]
                mov     eax, [edi]
                mov     ebx, [edi+4]
                mov     ecx, [edi+8]
                mov     edx, [edi+0Ch]
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     [esp+8], ecx
                mov     [esp+0Ch], edx
                mov     eax, [edi+10h]
                mov     ebx, [edi+14h]
                mov     ecx, [edi+18h]
                mov     edx, [edi+1Ch]
                mov     [esp+10h], eax
                mov     [esp+14h], ebx
                mov     [esp+18h], ecx
                mov     [esp+1Ch], edx
                mov     eax, [edi+20h]
                mov     ebx, [edi+24h]
                mov     ecx, [edi+28h]
                mov     edx, [edi+2Ch]
                mov     [esp+20h], eax
                mov     [esp+24h], ebx
                mov     [esp+28h], ecx
                mov     [esp+2Ch], edx
                mov     eax, [edi+30h]
                mov     ebx, [edi+34h]
                mov     ecx, [edi+38h]
                mov     edx, [edi+3Ch]
                mov     [esp+30h], eax
                mov     [esp+34h], ebx
                xor     eax, eax
                mov     [esp+38h], ecx
                mov     [esp+3Ch], edx
                mov     [esp+50h], eax

@@body_loop:                            
                mov     eax, [esp+20h]
                mov     ebx, [esp+24h]
                mov     ecx, eax
                mov     edx, ebx
                shr     ecx, 0Eh
                mov     ebp, eax
                shl     edx, 12h
                mov     edi, ebx
                shr     ebp, 12h
                or      ecx, edx
                shl     edi, 0Eh
                or      ebp, edi
                mov     edx, ebx
                xor     ebp, ecx
                mov     ecx, eax
                shl     ecx, 17h
                shr     edx, 9
                or      ecx, edx
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                mov     [esp+40h], ebp
                shr     ecx, 0Eh
                mov     ebp, ebx
                shl     edx, 12h
                mov     edi, eax
                shr     ebp, 12h
                or      ecx, edx
                shl     edi, 0Eh
                or      ebp, edi
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                shl     ecx, 17h
                shr     edx, 9
                or      ecx, edx
                mov     edx, [esp+2Ch]
                xor     ebp, ecx
                mov     ecx, [esp+28h]
                mov     [esp+44h], ebp
                mov     ebp, [esp+30h]
                mov     edi, [esp+34h]
                xor     ecx, ebp
                xor     edx, edi
                and     ecx, eax
                and     edx, ebx
                xor     ecx, ebp
                xor     edx, edi
                add     ecx, [esp+40h]
                mov     eax, [esp+38h]
                adc     edx, [esp+44h]
                mov     ebx, [esp+3Ch]
                add     ecx, eax
                mov     edi, [esp+50h]
                adc     edx, ebx
                mov     ebp, [esp+54h]
                shl     edi, 3
                add     edi, 0
                shl     edi, 3
                mov     eax, [edi+ebp]
                mov     ebx, [edi+ebp+4]
                add     ecx, eax
                mov     eax, [esi+edi]
                adc     edx, ebx
                mov     ebx, [esi+edi+4]
                add     ecx, eax
                mov     eax, [esp]
                adc     edx, ebx
                mov     ebx, [esp+4]
                mov     [esp+40h], ecx
                mov     [esp+44h], edx
                mov     ecx, eax
                mov     edx, ebx
                shr     ecx, 1Ch
                mov     ebp, eax
                shl     edx, 4
                mov     edi, ebx
                shl     ebp, 1Eh
                or      ecx, edx
                shr     edi, 2
                or      ebp, edi
                mov     edx, ebx
                xor     ebp, ecx
                mov     ecx, eax
                shr     edx, 7
                shl     ecx, 19h
                or      ecx, edx
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                mov     [esp+48h], ebp
                shr     ecx, 1Ch
                mov     ebp, ebx
                shl     edx, 4
                mov     edi, eax
                shl     ebp, 1Eh
                or      ecx, edx
                shr     edi, 2
                or      ebp, edi
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                shl     ecx, 19h
                shr     edx, 7
                or      ecx, edx
                mov     edx, [esp+0Ch]
                xor     ebp, ecx
                mov     ecx, [esp+8]
                mov     [esp+4Ch], ebp
                mov     ebp, [esp+10h]
                mov     edi, [esp+14h]
                or      ecx, ebp
                or      edx, edi
                and     eax, ecx
                and     ebx, edx
                mov     ecx, [esp+8]
                mov     edx, [esp+0Ch]
                and     ebp, ecx
                and     edi, edx
                or      eax, ebp
                or      ebx, edi
                mov     ecx, [esp+48h]
                mov     edx, [esp+4Ch]
                add     eax, ecx
                mov     ebp, [esp+40h]
                adc     ebx, edx
                mov     ecx, [esp+18h]
                mov     edx, [esp+1Ch]
                mov     edi, [esp+44h]
                add     ecx, ebp
                adc     edx, edi
                mov     [esp+18h], ecx
                mov     [esp+1Ch], edx
                add     ebp, eax
                adc     edi, ebx
                mov     [esp+38h], ebp
                mov     [esp+3Ch], edi
                mov     eax, [esp+18h]
                mov     ebx, [esp+1Ch]
                mov     ecx, eax
                mov     edx, ebx
                shr     ecx, 0Eh
                mov     ebp, eax
                shl     edx, 12h
                mov     edi, ebx
                shr     ebp, 12h
                or      ecx, edx
                shl     edi, 0Eh
                or      ebp, edi
                mov     edx, ebx
                xor     ebp, ecx
                mov     ecx, eax
                shl     ecx, 17h
                shr     edx, 9
                or      ecx, edx
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                mov     [esp+40h], ebp
                shr     ecx, 0Eh
                mov     ebp, ebx
                shl     edx, 12h
                mov     edi, eax
                shr     ebp, 12h
                or      ecx, edx
                shl     edi, 0Eh
                or      ebp, edi
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                shl     ecx, 17h
                shr     edx, 9
                or      ecx, edx
                mov     edx, [esp+24h]
                xor     ebp, ecx
                mov     ecx, [esp+20h]
                mov     [esp+44h], ebp
                mov     ebp, [esp+28h]
                mov     edi, [esp+2Ch]
                xor     ecx, ebp
                xor     edx, edi
                and     ecx, eax
                and     edx, ebx
                xor     ecx, ebp
                xor     edx, edi
                add     ecx, [esp+40h]
                mov     eax, [esp+30h]
                adc     edx, [esp+44h]
                mov     ebx, [esp+34h]
                add     ecx, eax
                mov     edi, [esp+50h]
                adc     edx, ebx
                mov     ebp, [esp+54h]
                shl     edi, 3
                add     edi, 1
                shl     edi, 3
                mov     eax, [edi+ebp]
                mov     ebx, [edi+ebp+4]
                add     ecx, eax
                mov     eax, [esi+edi]
                adc     edx, ebx
                mov     ebx, [esi+edi+4]
                add     ecx, eax
                mov     eax, [esp+38h]
                adc     edx, ebx
                mov     ebx, [esp+3Ch]
                mov     [esp+40h], ecx
                mov     [esp+44h], edx
                mov     ecx, eax
                mov     edx, ebx
                shr     ecx, 1Ch
                mov     ebp, eax
                shl     edx, 4
                mov     edi, ebx
                shl     ebp, 1Eh
                or      ecx, edx
                shr     edi, 2
                or      ebp, edi
                mov     edx, ebx
                xor     ebp, ecx
                mov     ecx, eax
                shr     edx, 7
                shl     ecx, 19h
                or      ecx, edx
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                mov     [esp+48h], ebp
                shr     ecx, 1Ch
                mov     ebp, ebx
                shl     edx, 4
                mov     edi, eax
                shl     ebp, 1Eh
                or      ecx, edx
                shr     edi, 2
                or      ebp, edi
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                shl     ecx, 19h
                shr     edx, 7
                or      ecx, edx
                mov     edx, [esp+4]
                xor     ebp, ecx
                mov     ecx, [esp]
                mov     [esp+4Ch], ebp
                mov     ebp, [esp+8]
                mov     edi, [esp+0Ch]
                or      ecx, ebp
                or      edx, edi
                and     eax, ecx
                and     ebx, edx
                mov     ecx, [esp]
                mov     edx, [esp+4]
                and     ebp, ecx
                and     edi, edx
                or      eax, ebp
                or      ebx, edi
                mov     ecx, [esp+48h]
                mov     edx, [esp+4Ch]
                add     eax, ecx
                mov     ebp, [esp+40h]
                adc     ebx, edx
                mov     ecx, [esp+10h]
                mov     edx, [esp+14h]
                mov     edi, [esp+44h]
                add     ecx, ebp
                adc     edx, edi
                mov     [esp+10h], ecx
                mov     [esp+14h], edx
                add     ebp, eax
                adc     edi, ebx
                mov     [esp+30h], ebp
                mov     [esp+34h], edi
                mov     eax, [esp+10h]
                mov     ebx, [esp+14h]
                mov     ecx, eax
                mov     edx, ebx
                shr     ecx, 0Eh
                mov     ebp, eax
                shl     edx, 12h
                mov     edi, ebx
                shr     ebp, 12h
                or      ecx, edx
                shl     edi, 0Eh
                or      ebp, edi
                mov     edx, ebx
                xor     ebp, ecx
                mov     ecx, eax
                shl     ecx, 17h
                shr     edx, 9
                or      ecx, edx
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                mov     [esp+40h], ebp
                shr     ecx, 0Eh
                mov     ebp, ebx
                shl     edx, 12h
                mov     edi, eax
                shr     ebp, 12h
                or      ecx, edx
                shl     edi, 0Eh
                or      ebp, edi
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                shl     ecx, 17h
                shr     edx, 9
                or      ecx, edx
                mov     edx, [esp+1Ch]
                xor     ebp, ecx
                mov     ecx, [esp+18h]
                mov     [esp+44h], ebp
                mov     ebp, [esp+20h]
                mov     edi, [esp+24h]
                xor     ecx, ebp
                xor     edx, edi
                and     ecx, eax
                and     edx, ebx
                xor     ecx, ebp
                xor     edx, edi
                add     ecx, [esp+40h]
                mov     eax, [esp+28h]
                adc     edx, [esp+44h]
                mov     ebx, [esp+2Ch]
                add     ecx, eax
                mov     edi, [esp+50h]
                adc     edx, ebx
                mov     ebp, [esp+54h]
                shl     edi, 3
                add     edi, 2
                shl     edi, 3
                mov     eax, [edi+ebp]
                mov     ebx, [edi+ebp+4]
                add     ecx, eax
                mov     eax, [esi+edi]
                adc     edx, ebx
                mov     ebx, [esi+edi+4]
                add     ecx, eax
                mov     eax, [esp+30h]
                adc     edx, ebx
                mov     ebx, [esp+34h]
                mov     [esp+40h], ecx
                mov     [esp+44h], edx
                mov     ecx, eax
                mov     edx, ebx
                shr     ecx, 1Ch
                mov     ebp, eax
                shl     edx, 4
                mov     edi, ebx
                shl     ebp, 1Eh
                or      ecx, edx
                shr     edi, 2
                or      ebp, edi
                mov     edx, ebx
                xor     ebp, ecx
                mov     ecx, eax
                shr     edx, 7
                shl     ecx, 19h
                or      ecx, edx
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                mov     [esp+48h], ebp
                shr     ecx, 1Ch
                mov     ebp, ebx
                shl     edx, 4
                mov     edi, eax
                shl     ebp, 1Eh
                or      ecx, edx
                shr     edi, 2
                or      ebp, edi
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                shl     ecx, 19h
                shr     edx, 7
                or      ecx, edx
                mov     edx, [esp+3Ch]
                xor     ebp, ecx
                mov     ecx, [esp+38h]
                mov     [esp+4Ch], ebp
                mov     ebp, [esp]
                mov     edi, [esp+4]
                or      ecx, ebp
                or      edx, edi
                and     eax, ecx
                and     ebx, edx
                mov     ecx, [esp+38h]
                mov     edx, [esp+3Ch]
                and     ebp, ecx
                and     edi, edx
                or      eax, ebp
                or      ebx, edi
                mov     ecx, [esp+48h]
                mov     edx, [esp+4Ch]
                add     eax, ecx
                mov     ebp, [esp+40h]
                adc     ebx, edx
                mov     ecx, [esp+8]
                mov     edx, [esp+0Ch]
                mov     edi, [esp+44h]
                add     ecx, ebp
                adc     edx, edi
                mov     [esp+8], ecx
                mov     [esp+0Ch], edx
                add     ebp, eax
                adc     edi, ebx
                mov     [esp+28h], ebp
                mov     [esp+2Ch], edi
                mov     eax, [esp+8]
                mov     ebx, [esp+0Ch]
                mov     ecx, eax
                mov     edx, ebx
                shr     ecx, 0Eh
                mov     ebp, eax
                shl     edx, 12h
                mov     edi, ebx
                shr     ebp, 12h
                or      ecx, edx
                shl     edi, 0Eh
                or      ebp, edi
                mov     edx, ebx
                xor     ebp, ecx
                mov     ecx, eax
                shl     ecx, 17h
                shr     edx, 9
                or      ecx, edx
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                mov     [esp+40h], ebp
                shr     ecx, 0Eh
                mov     ebp, ebx
                shl     edx, 12h
                mov     edi, eax
                shr     ebp, 12h
                or      ecx, edx
                shl     edi, 0Eh
                or      ebp, edi
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                shl     ecx, 17h
                shr     edx, 9
                or      ecx, edx
                mov     edx, [esp+14h]
                xor     ebp, ecx
                mov     ecx, [esp+10h]
                mov     [esp+44h], ebp
                mov     ebp, [esp+18h]
                mov     edi, [esp+1Ch]
                xor     ecx, ebp
                xor     edx, edi
                and     ecx, eax
                and     edx, ebx
                xor     ecx, ebp
                xor     edx, edi
                add     ecx, [esp+40h]
                mov     eax, [esp+20h]
                adc     edx, [esp+44h]
                mov     ebx, [esp+24h]
                add     ecx, eax
                mov     edi, [esp+50h]
                adc     edx, ebx
                mov     ebp, [esp+54h]
                shl     edi, 3
                add     edi, 3
                shl     edi, 3
                mov     eax, [edi+ebp]
                mov     ebx, [edi+ebp+4]
                add     ecx, eax
                mov     eax, [esi+edi]
                adc     edx, ebx
                mov     ebx, [esi+edi+4]
                add     ecx, eax
                mov     eax, [esp+28h]
                adc     edx, ebx
                mov     ebx, [esp+2Ch]
                mov     [esp+40h], ecx
                mov     [esp+44h], edx
                mov     ecx, eax
                mov     edx, ebx
                shr     ecx, 1Ch
                mov     ebp, eax
                shl     edx, 4
                mov     edi, ebx
                shl     ebp, 1Eh
                or      ecx, edx
                shr     edi, 2
                or      ebp, edi
                mov     edx, ebx
                xor     ebp, ecx
                mov     ecx, eax
                shr     edx, 7
                shl     ecx, 19h
                or      ecx, edx
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                mov     [esp+48h], ebp
                shr     ecx, 1Ch
                mov     ebp, ebx
                shl     edx, 4
                mov     edi, eax
                shl     ebp, 1Eh
                or      ecx, edx
                shr     edi, 2
                or      ebp, edi
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                shl     ecx, 19h
                shr     edx, 7
                or      ecx, edx
                mov     edx, [esp+34h]
                xor     ebp, ecx
                mov     ecx, [esp+30h]
                mov     [esp+4Ch], ebp
                mov     ebp, [esp+38h]
                mov     edi, [esp+3Ch]
                or      ecx, ebp
                or      edx, edi
                and     eax, ecx
                and     ebx, edx
                mov     ecx, [esp+30h]
                mov     edx, [esp+34h]
                and     ebp, ecx
                and     edi, edx
                or      eax, ebp
                or      ebx, edi
                mov     ecx, [esp+48h]
                mov     edx, [esp+4Ch]
                add     eax, ecx
                mov     ebp, [esp+40h]
                adc     ebx, edx
                mov     ecx, [esp]
                mov     edx, [esp+4]
                mov     edi, [esp+44h]
                add     ecx, ebp
                adc     edx, edi
                mov     [esp], ecx
                mov     [esp+4], edx
                add     ebp, eax
                adc     edi, ebx
                mov     [esp+20h], ebp
                mov     [esp+24h], edi
                mov     eax, [esp]
                mov     ebx, [esp+4]
                mov     ecx, eax
                mov     edx, ebx
                shr     ecx, 0Eh
                mov     ebp, eax
                shl     edx, 12h
                mov     edi, ebx
                shr     ebp, 12h
                or      ecx, edx
                shl     edi, 0Eh
                or      ebp, edi
                mov     edx, ebx
                xor     ebp, ecx
                mov     ecx, eax
                shl     ecx, 17h
                shr     edx, 9
                or      ecx, edx
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                mov     [esp+40h], ebp
                shr     ecx, 0Eh
                mov     ebp, ebx
                shl     edx, 12h
                mov     edi, eax
                shr     ebp, 12h
                or      ecx, edx
                shl     edi, 0Eh
                or      ebp, edi
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                shl     ecx, 17h
                shr     edx, 9
                or      ecx, edx
                mov     edx, [esp+0Ch]
                xor     ebp, ecx
                mov     ecx, [esp+8]
                mov     [esp+44h], ebp
                mov     ebp, [esp+10h]
                mov     edi, [esp+14h]
                xor     ecx, ebp
                xor     edx, edi
                and     ecx, eax
                and     edx, ebx
                xor     ecx, ebp
                xor     edx, edi
                add     ecx, [esp+40h]
                mov     eax, [esp+18h]
                adc     edx, [esp+44h]
                mov     ebx, [esp+1Ch]
                add     ecx, eax
                mov     edi, [esp+50h]
                adc     edx, ebx
                mov     ebp, [esp+54h]
                shl     edi, 3
                add     edi, 4
                shl     edi, 3
                mov     eax, [edi+ebp]
                mov     ebx, [edi+ebp+4]
                add     ecx, eax
                mov     eax, [esi+edi]
                adc     edx, ebx
                mov     ebx, [esi+edi+4]
                add     ecx, eax
                mov     eax, [esp+20h]
                adc     edx, ebx
                mov     ebx, [esp+24h]
                mov     [esp+40h], ecx
                mov     [esp+44h], edx
                mov     ecx, eax
                mov     edx, ebx
                shr     ecx, 1Ch
                mov     ebp, eax
                shl     edx, 4
                mov     edi, ebx
                shl     ebp, 1Eh
                or      ecx, edx
                shr     edi, 2
                or      ebp, edi
                mov     edx, ebx
                xor     ebp, ecx
                mov     ecx, eax
                shr     edx, 7
                shl     ecx, 19h
                or      ecx, edx
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                mov     [esp+48h], ebp
                shr     ecx, 1Ch
                mov     ebp, ebx
                shl     edx, 4
                mov     edi, eax
                shl     ebp, 1Eh
                or      ecx, edx
                shr     edi, 2
                or      ebp, edi
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                shl     ecx, 19h
                shr     edx, 7
                or      ecx, edx
                mov     edx, [esp+2Ch]
                xor     ebp, ecx
                mov     ecx, [esp+28h]
                mov     [esp+4Ch], ebp
                mov     ebp, [esp+30h]
                mov     edi, [esp+34h]
                or      ecx, ebp
                or      edx, edi
                and     eax, ecx
                and     ebx, edx
                mov     ecx, [esp+28h]
                mov     edx, [esp+2Ch]
                and     ebp, ecx
                and     edi, edx
                or      eax, ebp
                or      ebx, edi
                mov     ecx, [esp+48h]
                mov     edx, [esp+4Ch]
                add     eax, ecx
                mov     ebp, [esp+40h]
                adc     ebx, edx
                mov     ecx, [esp+38h]
                mov     edx, [esp+3Ch]
                mov     edi, [esp+44h]
                add     ecx, ebp
                adc     edx, edi
                mov     [esp+38h], ecx
                mov     [esp+3Ch], edx
                add     ebp, eax
                adc     edi, ebx
                mov     [esp+18h], ebp
                mov     [esp+1Ch], edi
                mov     eax, [esp+38h]
                mov     ebx, [esp+3Ch]
                mov     ecx, eax
                mov     edx, ebx
                shr     ecx, 0Eh
                mov     ebp, eax
                shl     edx, 12h
                mov     edi, ebx
                shr     ebp, 12h
                or      ecx, edx
                shl     edi, 0Eh
                or      ebp, edi
                mov     edx, ebx
                xor     ebp, ecx
                mov     ecx, eax
                shl     ecx, 17h
                shr     edx, 9
                or      ecx, edx
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                mov     [esp+40h], ebp
                shr     ecx, 0Eh
                mov     ebp, ebx
                shl     edx, 12h
                mov     edi, eax
                shr     ebp, 12h
                or      ecx, edx
                shl     edi, 0Eh
                or      ebp, edi
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                shl     ecx, 17h
                shr     edx, 9
                or      ecx, edx
                mov     edx, [esp+4]
                xor     ebp, ecx
                mov     ecx, [esp]
                mov     [esp+44h], ebp
                mov     ebp, [esp+8]
                mov     edi, [esp+0Ch]
                xor     ecx, ebp
                xor     edx, edi
                and     ecx, eax
                and     edx, ebx
                xor     ecx, ebp
                xor     edx, edi
                add     ecx, [esp+40h]
                mov     eax, [esp+10h]
                adc     edx, [esp+44h]
                mov     ebx, [esp+14h]
                add     ecx, eax
                mov     edi, [esp+50h]
                adc     edx, ebx
                mov     ebp, [esp+54h]
                shl     edi, 3
                add     edi, 5
                shl     edi, 3
                mov     eax, [edi+ebp]
                mov     ebx, [edi+ebp+4]
                add     ecx, eax
                mov     eax, [esi+edi]
                adc     edx, ebx
                mov     ebx, [esi+edi+4]
                add     ecx, eax
                mov     eax, [esp+18h]
                adc     edx, ebx
                mov     ebx, [esp+1Ch]
                mov     [esp+40h], ecx
                mov     [esp+44h], edx
                mov     ecx, eax
                mov     edx, ebx
                shr     ecx, 1Ch
                mov     ebp, eax
                shl     edx, 4
                mov     edi, ebx
                shl     ebp, 1Eh
                or      ecx, edx
                shr     edi, 2
                or      ebp, edi
                mov     edx, ebx
                xor     ebp, ecx
                mov     ecx, eax
                shr     edx, 7
                shl     ecx, 19h
                or      ecx, edx
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                mov     [esp+48h], ebp
                shr     ecx, 1Ch
                mov     ebp, ebx
                shl     edx, 4
                mov     edi, eax
                shl     ebp, 1Eh
                or      ecx, edx
                shr     edi, 2
                or      ebp, edi
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                shl     ecx, 19h
                shr     edx, 7
                or      ecx, edx
                mov     edx, [esp+24h]
                xor     ebp, ecx
                mov     ecx, [esp+20h]
                mov     [esp+4Ch], ebp
                mov     ebp, [esp+28h]
                mov     edi, [esp+2Ch]
                or      ecx, ebp
                or      edx, edi
                and     eax, ecx
                and     ebx, edx
                mov     ecx, [esp+20h]
                mov     edx, [esp+24h]
                and     ebp, ecx
                and     edi, edx
                or      eax, ebp
                or      ebx, edi
                mov     ecx, [esp+48h]
                mov     edx, [esp+4Ch]
                add     eax, ecx
                mov     ebp, [esp+40h]
                adc     ebx, edx
                mov     ecx, [esp+30h]
                mov     edx, [esp+34h]
                mov     edi, [esp+44h]
                add     ecx, ebp
                adc     edx, edi
                mov     [esp+30h], ecx
                mov     [esp+34h], edx
                add     ebp, eax
                adc     edi, ebx
                mov     [esp+10h], ebp
                mov     [esp+14h], edi
                mov     eax, [esp+30h]
                mov     ebx, [esp+34h]
                mov     ecx, eax
                mov     edx, ebx
                shr     ecx, 0Eh
                mov     ebp, eax
                shl     edx, 12h
                mov     edi, ebx
                shr     ebp, 12h
                or      ecx, edx
                shl     edi, 0Eh
                or      ebp, edi
                mov     edx, ebx
                xor     ebp, ecx
                mov     ecx, eax
                shl     ecx, 17h
                shr     edx, 9
                or      ecx, edx
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                mov     [esp+40h], ebp
                shr     ecx, 0Eh
                mov     ebp, ebx
                shl     edx, 12h
                mov     edi, eax
                shr     ebp, 12h
                or      ecx, edx
                shl     edi, 0Eh
                or      ebp, edi
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                shl     ecx, 17h
                shr     edx, 9
                or      ecx, edx
                mov     edx, [esp+3Ch]
                xor     ebp, ecx
                mov     ecx, [esp+38h]
                mov     [esp+44h], ebp
                mov     ebp, [esp]
                mov     edi, [esp+4]
                xor     ecx, ebp
                xor     edx, edi
                and     ecx, eax
                and     edx, ebx
                xor     ecx, ebp
                xor     edx, edi
                add     ecx, [esp+40h]
                mov     eax, [esp+8]
                adc     edx, [esp+44h]
                mov     ebx, [esp+0Ch]
                add     ecx, eax
                mov     edi, [esp+50h]
                adc     edx, ebx
                mov     ebp, [esp+54h]
                shl     edi, 3
                add     edi, 6
                shl     edi, 3
                mov     eax, [edi+ebp]
                mov     ebx, [edi+ebp+4]
                add     ecx, eax
                mov     eax, [esi+edi]
                adc     edx, ebx
                mov     ebx, [esi+edi+4]
                add     ecx, eax
                mov     eax, [esp+10h]
                adc     edx, ebx
                mov     ebx, [esp+14h]
                mov     [esp+40h], ecx
                mov     [esp+44h], edx
                mov     ecx, eax
                mov     edx, ebx
                shr     ecx, 1Ch
                mov     ebp, eax
                shl     edx, 4
                mov     edi, ebx
                shl     ebp, 1Eh
                or      ecx, edx
                shr     edi, 2
                or      ebp, edi
                mov     edx, ebx
                xor     ebp, ecx
                mov     ecx, eax
                shr     edx, 7
                shl     ecx, 19h
                or      ecx, edx
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                mov     [esp+48h], ebp
                shr     ecx, 1Ch
                mov     ebp, ebx
                shl     edx, 4
                mov     edi, eax
                shl     ebp, 1Eh
                or      ecx, edx
                shr     edi, 2
                or      ebp, edi
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                shl     ecx, 19h
                shr     edx, 7
                or      ecx, edx
                mov     edx, [esp+1Ch]
                xor     ebp, ecx
                mov     ecx, [esp+18h]
                mov     [esp+4Ch], ebp
                mov     ebp, [esp+20h]
                mov     edi, [esp+24h]
                or      ecx, ebp
                or      edx, edi
                and     eax, ecx
                and     ebx, edx
                mov     ecx, [esp+18h]
                mov     edx, [esp+1Ch]
                and     ebp, ecx
                and     edi, edx
                or      eax, ebp
                or      ebx, edi
                mov     ecx, [esp+48h]
                mov     edx, [esp+4Ch]
                add     eax, ecx
                mov     ebp, [esp+40h]
                adc     ebx, edx
                mov     ecx, [esp+28h]
                mov     edx, [esp+2Ch]
                mov     edi, [esp+44h]
                add     ecx, ebp
                adc     edx, edi
                mov     [esp+28h], ecx
                mov     [esp+2Ch], edx
                add     ebp, eax
                adc     edi, ebx
                mov     [esp+8], ebp
                mov     [esp+0Ch], edi
                mov     eax, [esp+28h]
                mov     ebx, [esp+2Ch]
                mov     ecx, eax
                mov     edx, ebx
                shr     ecx, 0Eh
                mov     ebp, eax
                shl     edx, 12h
                mov     edi, ebx
                shr     ebp, 12h
                or      ecx, edx
                shl     edi, 0Eh
                or      ebp, edi
                mov     edx, ebx
                xor     ebp, ecx
                mov     ecx, eax
                shl     ecx, 17h
                shr     edx, 9
                or      ecx, edx
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                mov     [esp+40h], ebp
                shr     ecx, 0Eh
                mov     ebp, ebx
                shl     edx, 12h
                mov     edi, eax
                shr     ebp, 12h
                or      ecx, edx
                shl     edi, 0Eh
                or      ebp, edi
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                shl     ecx, 17h
                shr     edx, 9
                or      ecx, edx
                mov     edx, [esp+34h]
                xor     ebp, ecx
                mov     ecx, [esp+30h]
                mov     [esp+44h], ebp
                mov     ebp, [esp+38h]
                mov     edi, [esp+3Ch]
                xor     ecx, ebp
                xor     edx, edi
                and     ecx, eax
                and     edx, ebx
                xor     ecx, ebp
                xor     edx, edi
                add     ecx, [esp+40h]
                mov     eax, [esp]
                adc     edx, [esp+44h]
                mov     ebx, [esp+4]
                add     ecx, eax
                mov     edi, [esp+50h]
                adc     edx, ebx
                mov     ebp, [esp+54h]
                shl     edi, 3
                add     edi, 7
                shl     edi, 3
                mov     eax, [edi+ebp]
                mov     ebx, [edi+ebp+4]
                add     ecx, eax
                mov     eax, [esi+edi]
                adc     edx, ebx
                mov     ebx, [esi+edi+4]
                add     ecx, eax
                mov     eax, [esp+8]
                adc     edx, ebx
                mov     ebx, [esp+0Ch]
                mov     [esp+40h], ecx
                mov     [esp+44h], edx
                mov     ecx, eax
                mov     edx, ebx
                shr     ecx, 1Ch
                mov     ebp, eax
                shl     edx, 4
                mov     edi, ebx
                shl     ebp, 1Eh
                or      ecx, edx
                shr     edi, 2
                or      ebp, edi
                mov     edx, ebx
                xor     ebp, ecx
                mov     ecx, eax
                shr     edx, 7
                shl     ecx, 19h
                or      ecx, edx
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                mov     [esp+48h], ebp
                shr     ecx, 1Ch
                mov     ebp, ebx
                shl     edx, 4
                mov     edi, eax
                shl     ebp, 1Eh
                or      ecx, edx
                shr     edi, 2
                or      ebp, edi
                mov     edx, eax
                xor     ebp, ecx
                mov     ecx, ebx
                shl     ecx, 19h
                shr     edx, 7
                or      ecx, edx
                mov     edx, [esp+14h]
                xor     ebp, ecx
                mov     ecx, [esp+10h]
                mov     [esp+4Ch], ebp
                mov     ebp, [esp+18h]
                mov     edi, [esp+1Ch]
                or      ecx, ebp
                or      edx, edi
                and     eax, ecx
                and     ebx, edx
                mov     ecx, [esp+10h]
                mov     edx, [esp+14h]
                and     ebp, ecx
                and     edi, edx
                or      eax, ebp
                or      ebx, edi
                mov     ecx, [esp+48h]
                mov     edx, [esp+4Ch]
                add     eax, ecx
                mov     ebp, [esp+40h]
                adc     ebx, edx
                mov     ecx, [esp+20h]
                mov     edx, [esp+24h]
                mov     edi, [esp+44h]
                add     ecx, ebp
                adc     edx, edi
                mov     [esp+20h], ecx
                mov     [esp+24h], edx
                add     ebp, eax
                adc     edi, ebx
                mov     [esp], ebp
                mov     [esp+4], edi
                inc     dword ptr [esp+50h]
                cmp     dword ptr [esp+50h], 0Ah
                jnz     @@body_loop
                mov     edi, [esp+5Ch]
                mov     eax, [esp]
                mov     ebx, [esp+4]
                mov     ecx, [esp+8]
                mov     edx, [esp+0Ch]
                add     [edi], eax
                adc     [edi+4], ebx
                add     [edi+8], ecx
                adc     [edi+0Ch], edx
                mov     eax, [esp+10h]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+18h]
                mov     edx, [esp+1Ch]
                add     [edi+10h], eax
                adc     [edi+14h], ebx
                add     [edi+18h], ecx
                adc     [edi+1Ch], edx
                mov     eax, [esp+20h]
                mov     ebx, [esp+24h]
                mov     ecx, [esp+28h]
                mov     edx, [esp+2Ch]
                add     [edi+20h], eax
                adc     [edi+24h], ebx
                add     [edi+28h], ecx
                adc     [edi+2Ch], edx
                mov     eax, [esp+30h]
                mov     ebx, [esp+34h]
                mov     ecx, [esp+38h]
                mov     edx, [esp+3Ch]
                add     [edi+30h], eax
                adc     [edi+34h], ebx
                add     [edi+38h], ecx
                adc     [edi+3Ch], edx
                add     esp, 60h


    pop     ebp
    pop     edi
    pop     esi
    pop     ebx
  end;
end;
{$ENDIF}

{$IFDEF THashBaseHaval_asm}
procedure THashBaseHaval.DoTransform3(Buffer: PLongArray);
asm
                push    ebx
                push    esi
                push    edi
                lea     edi, [eax].THashBaseHaval.FDigest
                mov     esi, edx
                push    ebp
                mov     ebp, esp
                add     esp, 0FFFFFFD4h
                and     esp, 0FFFFFFC0h
                mov     eax, [edi]
                mov     ebx, [edi+4]
                mov     [esp+20h], esi
                mov     [esp+24h], edi
                mov     [esp+28h], ebp
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     ecx, [edi+8]
                mov     edx, [edi+0Ch]
                mov     [esp+8], ecx
                mov     [esp+0Ch], edx
                mov     eax, [edi+10h]
                mov     ebx, [edi+14h]
                mov     [esp+10h], eax
                mov     [esp+14h], ebx
                mov     ecx, [edi+18h]
                mov     edx, [edi+1Ch]
                mov     [esp+18h], ecx
                mov     [esp+1Ch], edx
                mov     eax, edx
                mov     ebp, [esp]
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+10h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+4]
                and     ebx, [esp+8]
                and     edi, [esp+14h]
                xor     ecx, ebx
                and     ebp, [esp+18h]
                xor     edi, ecx
                mov     edx, [esi]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp+8]
                mov     ecx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp]
                and     ebx, [esp+4]
                and     edi, [esp+10h]
                xor     ecx, ebx
                and     ebp, [esp+14h]
                xor     edi, ecx
                mov     edx, [esi+4]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp+4]
                mov     ecx, [esp+8]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+1Ch]
                and     ebx, [esp]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                and     ebp, [esp+10h]
                xor     edi, ecx
                mov     edx, [esi+8]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp]
                mov     ecx, [esp+4]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+18h]
                and     ebx, [esp+1Ch]
                and     edi, [esp+8]
                xor     ecx, ebx
                and     ebp, [esp+0Ch]
                xor     edi, ecx
                mov     edx, [esi+0Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+14h]
                and     ebx, [esp+18h]
                and     edi, [esp+4]
                xor     ecx, ebx
                and     ebp, [esp+8]
                xor     edi, ecx
                mov     edx, [esi+10h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+18h]
                mov     ecx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+10h]
                and     ebx, [esp+14h]
                and     edi, [esp]
                xor     ecx, ebx
                and     ebp, [esp+4]
                xor     edi, ecx
                mov     edx, [esi+14h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+14h]
                mov     ecx, [esp+18h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+0Ch]
                and     ebx, [esp+10h]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                and     ebp, [esp]
                xor     edi, ecx
                mov     edx, [esi+18h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+10h]
                mov     ecx, [esp+14h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+8]
                and     ebx, [esp+0Ch]
                and     edi, [esp+18h]
                xor     ecx, ebx
                and     ebp, [esp+1Ch]
                xor     edi, ecx
                mov     edx, [esi+1Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+10h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+4]
                and     ebx, [esp+8]
                and     edi, [esp+14h]
                xor     ecx, ebx
                and     ebp, [esp+18h]
                xor     edi, ecx
                mov     edx, [esi+20h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp+8]
                mov     ecx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp]
                and     ebx, [esp+4]
                and     edi, [esp+10h]
                xor     ecx, ebx
                and     ebp, [esp+14h]
                xor     edi, ecx
                mov     edx, [esi+24h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp+4]
                mov     ecx, [esp+8]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+1Ch]
                and     ebx, [esp]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                and     ebp, [esp+10h]
                xor     edi, ecx
                mov     edx, [esi+28h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp]
                mov     ecx, [esp+4]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+18h]
                and     ebx, [esp+1Ch]
                and     edi, [esp+8]
                xor     ecx, ebx
                and     ebp, [esp+0Ch]
                xor     edi, ecx
                mov     edx, [esi+2Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+14h]
                and     ebx, [esp+18h]
                and     edi, [esp+4]
                xor     ecx, ebx
                and     ebp, [esp+8]
                xor     edi, ecx
                mov     edx, [esi+30h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+18h]
                mov     ecx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+10h]
                and     ebx, [esp+14h]
                and     edi, [esp]
                xor     ecx, ebx
                and     ebp, [esp+4]
                xor     edi, ecx
                mov     edx, [esi+34h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+14h]
                mov     ecx, [esp+18h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+0Ch]
                and     ebx, [esp+10h]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                and     ebp, [esp]
                xor     edi, ecx
                mov     edx, [esi+38h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+10h]
                mov     ecx, [esp+14h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+8]
                and     ebx, [esp+0Ch]
                and     edi, [esp+18h]
                xor     ecx, ebx
                and     ebp, [esp+1Ch]
                xor     edi, ecx
                mov     edx, [esi+3Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+10h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+4]
                and     ebx, [esp+8]
                and     edi, [esp+14h]
                xor     ecx, ebx
                and     ebp, [esp+18h]
                xor     edi, ecx
                mov     edx, [esi+40h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp+8]
                mov     ecx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp]
                and     ebx, [esp+4]
                and     edi, [esp+10h]
                xor     ecx, ebx
                and     ebp, [esp+14h]
                xor     edi, ecx
                mov     edx, [esi+44h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp+4]
                mov     ecx, [esp+8]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+1Ch]
                and     ebx, [esp]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                and     ebp, [esp+10h]
                xor     edi, ecx
                mov     edx, [esi+48h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp]
                mov     ecx, [esp+4]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+18h]
                and     ebx, [esp+1Ch]
                and     edi, [esp+8]
                xor     ecx, ebx
                and     ebp, [esp+0Ch]
                xor     edi, ecx
                mov     edx, [esi+4Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+14h]
                and     ebx, [esp+18h]
                and     edi, [esp+4]
                xor     ecx, ebx
                and     ebp, [esp+8]
                xor     edi, ecx
                mov     edx, [esi+50h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+18h]
                mov     ecx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+10h]
                and     ebx, [esp+14h]
                and     edi, [esp]
                xor     ecx, ebx
                and     ebp, [esp+4]
                xor     edi, ecx
                mov     edx, [esi+54h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+14h]
                mov     ecx, [esp+18h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+0Ch]
                and     ebx, [esp+10h]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                and     ebp, [esp]
                xor     edi, ecx
                mov     edx, [esi+58h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+10h]
                mov     ecx, [esp+14h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+8]
                and     ebx, [esp+0Ch]
                and     edi, [esp+18h]
                xor     ecx, ebx
                and     ebp, [esp+1Ch]
                xor     edi, ecx
                mov     edx, [esi+5Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+10h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+4]
                and     ebx, [esp+8]
                and     edi, [esp+14h]
                xor     ecx, ebx
                and     ebp, [esp+18h]
                xor     edi, ecx
                mov     edx, [esi+60h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp+8]
                mov     ecx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp]
                and     ebx, [esp+4]
                and     edi, [esp+10h]
                xor     ecx, ebx
                and     ebp, [esp+14h]
                xor     edi, ecx
                mov     edx, [esi+64h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp+4]
                mov     ecx, [esp+8]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+1Ch]
                and     ebx, [esp]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                and     ebp, [esp+10h]
                xor     edi, ecx
                mov     edx, [esi+68h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp]
                mov     ecx, [esp+4]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+18h]
                and     ebx, [esp+1Ch]
                and     edi, [esp+8]
                xor     ecx, ebx
                and     ebp, [esp+0Ch]
                xor     edi, ecx
                mov     edx, [esi+6Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+14h]
                and     ebx, [esp+18h]
                and     edi, [esp+4]
                xor     ecx, ebx
                and     ebp, [esp+8]
                xor     edi, ecx
                mov     edx, [esi+70h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+18h]
                mov     ecx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+10h]
                and     ebx, [esp+14h]
                and     edi, [esp]
                xor     ecx, ebx
                and     ebp, [esp+4]
                xor     edi, ecx
                mov     edx, [esi+74h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+14h]
                mov     ecx, [esp+18h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+0Ch]
                and     ebx, [esp+10h]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                and     ebp, [esp]
                xor     edi, ecx
                mov     edx, [esi+78h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+10h]
                mov     ecx, [esp+14h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+8]
                and     ebx, [esp+0Ch]
                and     edi, [esp+18h]
                xor     ecx, ebx
                and     ebp, [esp+1Ch]
                xor     edi, ecx
                mov     edx, [esi+7Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp]
                mov     ebx, [esp+4]
                mov     edi, [esp+8]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+0Ch]
                and     ebx, edi
                mov     edx, [esp+18h]
                and     ebp, ecx
                xor     ebx, [esp+10h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+4]
                and     ebx, [esp+14h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+14h]
                xor     ecx, ebx
                and     edi, [esp]
                xor     ecx, edi
                lea     ebp, [eax+ebp+452821E6h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp]
                mov     edi, [esp+4]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+8]
                and     ebx, edi
                mov     edx, [esp+14h]
                and     ebp, ecx
                xor     ebx, [esp+0Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp]
                and     ebx, [esp+10h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+38h]
                xor     ecx, ebx
                and     edi, [esp+1Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp+38D01377h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp+1Ch]
                mov     edi, [esp]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+4]
                and     ebx, edi
                mov     edx, [esp+10h]
                and     ebp, ecx
                xor     ebx, [esp+8]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+1Ch]
                and     ebx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+68h]
                xor     ecx, ebx
                and     edi, [esp+18h]
                xor     ecx, edi
                lea     ebp, [eax+ebp-41AB9931h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp+18h]
                mov     edi, [esp+1Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp]
                and     ebx, edi
                mov     edx, [esp+0Ch]
                and     ebp, ecx
                xor     ebx, [esp+4]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+18h]
                and     ebx, [esp+8]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+48h]
                xor     ecx, ebx
                and     edi, [esp+14h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+34E90C6Ch]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp+14h]
                mov     edi, [esp+18h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+1Ch]
                and     ebx, edi
                mov     edx, [esp+8]
                and     ebp, ecx
                xor     ebx, [esp]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+14h]
                and     ebx, [esp+4]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+2Ch]
                xor     ecx, ebx
                and     edi, [esp+10h]
                xor     ecx, edi
                lea     ebp, [eax+ebp-3F53D649h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+10h]
                mov     edi, [esp+14h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+18h]
                and     ebx, edi
                mov     edx, [esp+4]
                and     ebp, ecx
                xor     ebx, [esp+1Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+10h]
                and     ebx, [esp]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+70h]
                xor     ecx, ebx
                and     edi, [esp+0Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-3683AF23h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+0Ch]
                mov     edi, [esp+10h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+14h]
                and     ebx, edi
                mov     edx, [esp]
                and     ebp, ecx
                xor     ebx, [esp+18h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+0Ch]
                and     ebx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+1Ch]
                xor     ecx, ebx
                and     edi, [esp+8]
                xor     ecx, edi
                lea     ebp, [eax+ebp+3F84D5B5h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+8]
                mov     edi, [esp+0Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+10h]
                and     ebx, edi
                mov     edx, [esp+1Ch]
                and     ebp, ecx
                xor     ebx, [esp+14h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+8]
                and     ebx, [esp+18h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+40h]
                xor     ecx, ebx
                and     edi, [esp+4]
                xor     ecx, edi
                lea     ebp, [eax+ebp-4AB8F6E9h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebx, [esp+4]
                mov     edi, [esp+8]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+0Ch]
                and     ebx, edi
                mov     edx, [esp+18h]
                and     ebp, ecx
                xor     ebx, [esp+10h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+4]
                and     ebx, [esp+14h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi]
                xor     ecx, ebx
                and     edi, [esp]
                xor     ecx, edi
                lea     ebp, [eax+ebp-6DE92A27h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp]
                mov     edi, [esp+4]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+8]
                and     ebx, edi
                mov     edx, [esp+14h]
                and     ebp, ecx
                xor     ebx, [esp+0Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp]
                and     ebx, [esp+10h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+5Ch]
                xor     ecx, ebx
                and     edi, [esp+1Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-768604E5h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp+1Ch]
                mov     edi, [esp]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+4]
                and     ebx, edi
                mov     edx, [esp+10h]
                and     ebp, ecx
                xor     ebx, [esp+8]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+1Ch]
                and     ebx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+50h]
                xor     ecx, ebx
                and     edi, [esp+18h]
                xor     ecx, edi
                lea     ebp, [eax+ebp-2ECEF45Ah]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp+18h]
                mov     edi, [esp+1Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp]
                and     ebx, edi
                mov     edx, [esp+0Ch]
                and     ebp, ecx
                xor     ebx, [esp+4]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+18h]
                and     ebx, [esp+8]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+58h]
                xor     ecx, ebx
                and     edi, [esp+14h]
                xor     ecx, edi
                lea     ebp, [eax+ebp-67204A54h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp+14h]
                mov     edi, [esp+18h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+1Ch]
                and     ebx, edi
                mov     edx, [esp+8]
                and     ebp, ecx
                xor     ebx, [esp]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+14h]
                and     ebx, [esp+4]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+4]
                xor     ecx, ebx
                and     edi, [esp+10h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+2FFD72DBh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+10h]
                mov     edi, [esp+14h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+18h]
                and     ebx, edi
                mov     edx, [esp+4]
                and     ebp, ecx
                xor     ebx, [esp+1Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+10h]
                and     ebx, [esp]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+28h]
                xor     ecx, ebx
                and     edi, [esp+0Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-2FE52049h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+0Ch]
                mov     edi, [esp+10h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+14h]
                and     ebx, edi
                mov     edx, [esp]
                and     ebp, ecx
                xor     ebx, [esp+18h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+0Ch]
                and     ebx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+10h]
                xor     ecx, ebx
                and     edi, [esp+8]
                xor     ecx, edi
                lea     ebp, [eax+ebp-471E5013h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+8]
                mov     edi, [esp+0Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+10h]
                and     ebx, edi
                mov     edx, [esp+1Ch]
                and     ebp, ecx
                xor     ebx, [esp+14h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+8]
                and     ebx, [esp+18h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+20h]
                xor     ecx, ebx
                and     edi, [esp+4]
                xor     ecx, edi
                lea     ebp, [eax+ebp+6A267E96h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebx, [esp+4]
                mov     edi, [esp+8]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+0Ch]
                and     ebx, edi
                mov     edx, [esp+18h]
                and     ebp, ecx
                xor     ebx, [esp+10h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+4]
                and     ebx, [esp+14h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+78h]
                xor     ecx, ebx
                and     edi, [esp]
                xor     ecx, edi
                lea     ebp, [eax+ebp-45836FBBh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp]
                mov     edi, [esp+4]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+8]
                and     ebx, edi
                mov     edx, [esp+14h]
                and     ebp, ecx
                xor     ebx, [esp+0Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp]
                and     ebx, [esp+10h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+0Ch]
                xor     ecx, ebx
                and     edi, [esp+1Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-0ED38067h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp+1Ch]
                mov     edi, [esp]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+4]
                and     ebx, edi
                mov     edx, [esp+10h]
                and     ebp, ecx
                xor     ebx, [esp+8]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+1Ch]
                and     ebx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+54h]
                xor     ecx, ebx
                and     edi, [esp+18h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+24A19947h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp+18h]
                mov     edi, [esp+1Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp]
                and     ebx, edi
                mov     edx, [esp+0Ch]
                and     ebp, ecx
                xor     ebx, [esp+4]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+18h]
                and     ebx, [esp+8]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+24h]
                xor     ecx, ebx
                and     edi, [esp+14h]
                xor     ecx, edi
                lea     ebp, [eax+ebp-4C6E9309h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp+14h]
                mov     edi, [esp+18h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+1Ch]
                and     ebx, edi
                mov     edx, [esp+8]
                and     ebp, ecx
                xor     ebx, [esp]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+14h]
                and     ebx, [esp+4]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+44h]
                xor     ecx, ebx
                and     edi, [esp+10h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+801F2E2h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+10h]
                mov     edi, [esp+14h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+18h]
                and     ebx, edi
                mov     edx, [esp+4]
                and     ebp, ecx
                xor     ebx, [esp+1Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+10h]
                and     ebx, [esp]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+60h]
                xor     ecx, ebx
                and     edi, [esp+0Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-7A7103EAh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+0Ch]
                mov     edi, [esp+10h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+14h]
                and     ebx, edi
                mov     edx, [esp]
                and     ebp, ecx
                xor     ebx, [esp+18h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+0Ch]
                and     ebx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+74h]
                xor     ecx, ebx
                and     edi, [esp+8]
                xor     ecx, edi
                lea     ebp, [eax+ebp+636920D8h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+8]
                mov     edi, [esp+0Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+10h]
                and     ebx, edi
                mov     edx, [esp+1Ch]
                and     ebp, ecx
                xor     ebx, [esp+14h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+8]
                and     ebx, [esp+18h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+18h]
                xor     ecx, ebx
                and     edi, [esp+4]
                xor     ecx, edi
                lea     ebp, [eax+ebp+71574E69h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebx, [esp+4]
                mov     edi, [esp+8]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+0Ch]
                and     ebx, edi
                mov     edx, [esp+18h]
                and     ebp, ecx
                xor     ebx, [esp+10h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+4]
                and     ebx, [esp+14h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+4Ch]
                xor     ecx, ebx
                and     edi, [esp]
                xor     ecx, edi
                lea     ebp, [eax+ebp-5BA7015Dh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp]
                mov     edi, [esp+4]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+8]
                and     ebx, edi
                mov     edx, [esp+14h]
                and     ebp, ecx
                xor     ebx, [esp+0Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp]
                and     ebx, [esp+10h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+30h]
                xor     ecx, ebx
                and     edi, [esp+1Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-0B6CC282h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp+1Ch]
                mov     edi, [esp]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+4]
                and     ebx, edi
                mov     edx, [esp+10h]
                and     ebp, ecx
                xor     ebx, [esp+8]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+1Ch]
                and     ebx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+3Ch]
                xor     ecx, ebx
                and     edi, [esp+18h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+0D95748Fh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp+18h]
                mov     edi, [esp+1Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp]
                and     ebx, edi
                mov     edx, [esp+0Ch]
                and     ebp, ecx
                xor     ebx, [esp+4]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+18h]
                and     ebx, [esp+8]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+34h]
                xor     ecx, ebx
                and     edi, [esp+14h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+728EB658h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp+14h]
                mov     edi, [esp+18h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+1Ch]
                and     ebx, edi
                mov     edx, [esp+8]
                and     ebp, ecx
                xor     ebx, [esp]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+14h]
                and     ebx, [esp+4]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+8]
                xor     ecx, ebx
                and     edi, [esp+10h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+718BCD58h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+10h]
                mov     edi, [esp+14h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+18h]
                and     ebx, edi
                mov     edx, [esp+4]
                and     ebp, ecx
                xor     ebx, [esp+1Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+10h]
                and     ebx, [esp]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+64h]
                xor     ecx, ebx
                and     edi, [esp+0Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-7DEAB512h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+0Ch]
                mov     edi, [esp+10h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+14h]
                and     ebx, edi
                mov     edx, [esp]
                and     ebp, ecx
                xor     ebx, [esp+18h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+0Ch]
                and     ebx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+7Ch]
                xor     ecx, ebx
                and     edi, [esp+8]
                xor     ecx, edi
                lea     ebp, [eax+ebp+7B54A41Dh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+8]
                mov     edi, [esp+0Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+10h]
                and     ebx, edi
                mov     edx, [esp+1Ch]
                and     ebp, ecx
                xor     ebx, [esp+14h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+8]
                and     ebx, [esp+18h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+6Ch]
                xor     ecx, ebx
                and     edi, [esp+4]
                xor     ecx, edi
                lea     ebp, [eax+ebp-3DA5A64Bh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebx, [esp+10h]
                mov     ecx, [esp+14h]
                mov     edi, ebx
                and     ebx, [esp+4]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+4Ch]
                xor     edi, [esp+18h]
                and     ecx, [esp+8]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-63CF2AC7h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+10h]
                mov     edi, ebx
                and     ebx, [esp]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+24h]
                xor     edi, [esp+14h]
                and     ecx, [esp+4]
                and     edi, [esp+8]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+2AF26013h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp+8]
                mov     ecx, [esp+0Ch]
                mov     edi, ebx
                and     ebx, [esp+1Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+10h]
                xor     edi, [esp+10h]
                and     ecx, [esp]
                and     edi, [esp+4]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-3A2E4FDDh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp+4]
                mov     ecx, [esp+8]
                mov     edi, ebx
                and     ebx, [esp+18h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+50h]
                xor     edi, [esp+0Ch]
                and     ecx, [esp+1Ch]
                and     edi, [esp]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+286085F0h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp]
                mov     ecx, [esp+4]
                mov     edi, ebx
                and     ebx, [esp+14h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+70h]
                xor     edi, [esp+8]
                and     ecx, [esp+18h]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-35BE86E8h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp]
                mov     edi, ebx
                and     ebx, [esp+10h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+44h]
                xor     edi, [esp+4]
                and     ecx, [esp+14h]
                and     edi, [esp+18h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-4724C711h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+18h]
                mov     ecx, [esp+1Ch]
                mov     edi, ebx
                and     ebx, [esp+0Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+20h]
                xor     edi, [esp]
                and     ecx, [esp+10h]
                and     edi, [esp+14h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-71862350h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+14h]
                mov     ecx, [esp+18h]
                mov     edi, ebx
                and     ebx, [esp+8]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+58h]
                xor     edi, [esp+1Ch]
                and     ecx, [esp+0Ch]
                and     edi, [esp+10h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+603A180Eh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebx, [esp+10h]
                mov     ecx, [esp+14h]
                mov     edi, ebx
                and     ebx, [esp+4]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+74h]
                xor     edi, [esp+18h]
                and     ecx, [esp+8]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+6C9E0E8Bh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+10h]
                mov     edi, ebx
                and     ebx, [esp]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+38h]
                xor     edi, [esp+14h]
                and     ecx, [esp+4]
                and     edi, [esp+8]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-4FE175C2h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp+8]
                mov     ecx, [esp+0Ch]
                mov     edi, ebx
                and     ebx, [esp+1Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+64h]
                xor     edi, [esp+10h]
                and     ecx, [esp]
                and     edi, [esp+4]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-28EA883Fh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp+4]
                mov     ecx, [esp+8]
                mov     edi, ebx
                and     ebx, [esp+18h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+30h]
                xor     edi, [esp+0Ch]
                and     ecx, [esp+1Ch]
                and     edi, [esp]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-42CEB4D9h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp]
                mov     ecx, [esp+4]
                mov     edi, ebx
                and     ebx, [esp+14h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+60h]
                xor     edi, [esp+8]
                and     ecx, [esp+18h]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+78AF2FDAh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp]
                mov     edi, ebx
                and     ebx, [esp+10h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+78h]
                xor     edi, [esp+4]
                and     ecx, [esp+14h]
                and     edi, [esp+18h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+55605C60h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+18h]
                mov     ecx, [esp+1Ch]
                mov     edi, ebx
                and     ebx, [esp+0Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+40h]
                xor     edi, [esp]
                and     ecx, [esp+10h]
                and     edi, [esp+14h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-19AADA0Dh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+14h]
                mov     ecx, [esp+18h]
                mov     edi, ebx
                and     ebx, [esp+8]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+68h]
                xor     edi, [esp+1Ch]
                and     ecx, [esp+0Ch]
                and     edi, [esp+10h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-55AA546Ch]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebx, [esp+10h]
                mov     ecx, [esp+14h]
                mov     edi, ebx
                and     ebx, [esp+4]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+7Ch]
                xor     edi, [esp+18h]
                and     ecx, [esp+8]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+57489862h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+10h]
                mov     edi, ebx
                and     ebx, [esp]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+3Ch]
                xor     edi, [esp+14h]
                and     ecx, [esp+4]
                and     edi, [esp+8]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+63E81440h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp+8]
                mov     ecx, [esp+0Ch]
                mov     edi, ebx
                and     ebx, [esp+1Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+1Ch]
                xor     edi, [esp+10h]
                and     ecx, [esp]
                and     edi, [esp+4]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+55CA396Ah]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp+4]
                mov     ecx, [esp+8]
                mov     edi, ebx
                and     ebx, [esp+18h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+0Ch]
                xor     edi, [esp+0Ch]
                and     ecx, [esp+1Ch]
                and     edi, [esp]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+2AAB10B6h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp]
                mov     ecx, [esp+4]
                mov     edi, ebx
                and     ebx, [esp+14h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+4]
                xor     edi, [esp+8]
                and     ecx, [esp+18h]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-4B33A3CCh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp]
                mov     edi, ebx
                and     ebx, [esp+10h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi]
                xor     edi, [esp+4]
                and     ecx, [esp+14h]
                and     edi, [esp+18h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+1141E8CEh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+18h]
                mov     ecx, [esp+1Ch]
                mov     edi, ebx
                and     ebx, [esp+0Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+48h]
                xor     edi, [esp]
                and     ecx, [esp+10h]
                and     edi, [esp+14h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-5EAB7951h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+14h]
                mov     ecx, [esp+18h]
                mov     edi, ebx
                and     ebx, [esp+8]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+6Ch]
                xor     edi, [esp+1Ch]
                and     ecx, [esp+0Ch]
                and     edi, [esp+10h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+7C72E993h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebx, [esp+10h]
                mov     ecx, [esp+14h]
                mov     edi, ebx
                and     ebx, [esp+4]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+34h]
                xor     edi, [esp+18h]
                and     ecx, [esp+8]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-4C11EBEFh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+10h]
                mov     edi, ebx
                and     ebx, [esp]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+18h]
                xor     edi, [esp+14h]
                and     ecx, [esp+4]
                and     edi, [esp+8]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+636FBC2Ah]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp+8]
                mov     ecx, [esp+0Ch]
                mov     edi, ebx
                and     ebx, [esp+1Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+54h]
                xor     edi, [esp+10h]
                and     ecx, [esp]
                and     edi, [esp+4]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+2BA9C55Dh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp+4]
                mov     ecx, [esp+8]
                mov     edi, ebx
                and     ebx, [esp+18h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+28h]
                xor     edi, [esp+0Ch]
                and     ecx, [esp+1Ch]
                and     edi, [esp]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+741831F6h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp]
                mov     ecx, [esp+4]
                mov     edi, ebx
                and     ebx, [esp+14h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+5Ch]
                xor     edi, [esp+8]
                and     ecx, [esp+18h]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-31A3C1EAh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp]
                mov     edi, ebx
                and     ebx, [esp+10h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+2Ch]
                xor     edi, [esp+4]
                and     ecx, [esp+14h]
                and     edi, [esp+18h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-64786CE2h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+18h]
                mov     ecx, [esp+1Ch]
                mov     edi, ebx
                and     ebx, [esp+0Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+14h]
                xor     edi, [esp]
                and     ecx, [esp+10h]
                and     edi, [esp+14h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-502945CDh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+14h]
                mov     ecx, [esp+18h]
                mov     edi, ebx
                and     ebx, [esp+8]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+8]
                xor     edi, [esp+1Ch]
                and     ecx, [esp+0Ch]
                and     edi, [esp+10h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+6C24CF5Ch]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     edi, [esp+24h]
                mov     eax, [esp]
                mov     ebx, [esp+4]
                add     [edi], eax
                add     [edi+4], ebx
                mov     ecx, [esp+8]
                mov     edx, [esp+0Ch]
                add     [edi+8], ecx
                add     [edi+0Ch], edx
                mov     eax, [esp+10h]
                mov     ebx, [esp+14h]
                add     [edi+10h], eax
                add     [edi+14h], ebx
                mov     ebp, [esp+28h]
                mov     ecx, [esp+18h]
                mov     edx, [esp+1Ch]
                mov     esp, ebp
                add     [edi+18h], ecx
                add     [edi+1Ch], edx
                pop     ebp
                pop     edi
                pop     esi
                pop     ebx
end;

procedure THashBaseHaval.DoTransform4(Buffer: PLongArray);
asm
                push    ebx
                push    esi
                push    edi
                lea     edi, [eax].THashBaseHaval.FDigest
                mov     esi, edx
                push    ebp
                mov     ebp, esp
                add     esp, 0FFFFFFD4h
                and     esp, 0FFFFFFC0h
                mov     eax, [edi]
                mov     ebx, [edi+4]
                mov     [esp+20h], esi
                mov     [esp+24h], edi
                mov     [esp+28h], ebp
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     ecx, [edi+8]
                mov     edx, [edi+0Ch]
                mov     [esp+8], ecx
                mov     [esp+0Ch], edx
                mov     eax, [edi+10h]
                mov     ebx, [edi+14h]
                mov     [esp+10h], eax
                mov     [esp+14h], ebx
                mov     ecx, [edi+18h]
                mov     edx, [edi+1Ch]
                mov     [esp+18h], ecx
                mov     [esp+1Ch], edx
                mov     eax, edx
                mov     ebp, [esp+18h]
                mov     ebx, [esp+4]
                mov     ecx, [esp]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+8]
                and     ebx, [esp+0Ch]
                and     edi, [esp+10h]
                xor     ecx, ebx
                and     ebp, [esp+14h]
                xor     edi, ecx
                mov     edx, [esi]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+14h]
                mov     ebx, [esp]
                mov     ecx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+4]
                and     ebx, [esp+8]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                and     ebp, [esp+10h]
                xor     edi, ecx
                mov     edx, [esi+4]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebp, [esp+10h]
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp+18h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp]
                and     ebx, [esp+4]
                and     edi, [esp+8]
                xor     ecx, ebx
                and     ebp, [esp+0Ch]
                xor     edi, ecx
                mov     edx, [esi+8]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, [esp+18h]
                mov     ecx, [esp+14h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+1Ch]
                and     ebx, [esp]
                and     edi, [esp+4]
                xor     ecx, ebx
                and     ebp, [esp+8]
                xor     edi, ecx
                mov     edx, [esi+0Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [esp+8]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+10h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+18h]
                and     ebx, [esp+1Ch]
                and     edi, [esp]
                xor     ecx, ebx
                and     ebp, [esp+4]
                xor     edi, ecx
                mov     edx, [esi+10h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebp, [esp+4]
                mov     ebx, [esp+10h]
                mov     ecx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+14h]
                and     ebx, [esp+18h]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                and     ebp, [esp]
                xor     edi, ecx
                mov     edx, [esi+14h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebp, [esp]
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+8]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+10h]
                and     ebx, [esp+14h]
                and     edi, [esp+18h]
                xor     ecx, ebx
                and     ebp, [esp+1Ch]
                xor     edi, ecx
                mov     edx, [esi+18h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, [esp+8]
                mov     ecx, [esp+4]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+0Ch]
                and     ebx, [esp+10h]
                and     edi, [esp+14h]
                xor     ecx, ebx
                and     ebp, [esp+18h]
                xor     edi, ecx
                mov     edx, [esi+1Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp+18h]
                mov     ebx, [esp+4]
                mov     ecx, [esp]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+8]
                and     ebx, [esp+0Ch]
                and     edi, [esp+10h]
                xor     ecx, ebx
                and     ebp, [esp+14h]
                xor     edi, ecx
                mov     edx, [esi+20h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+14h]
                mov     ebx, [esp]
                mov     ecx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+4]
                and     ebx, [esp+8]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                and     ebp, [esp+10h]
                xor     edi, ecx
                mov     edx, [esi+24h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebp, [esp+10h]
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp+18h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp]
                and     ebx, [esp+4]
                and     edi, [esp+8]
                xor     ecx, ebx
                and     ebp, [esp+0Ch]
                xor     edi, ecx
                mov     edx, [esi+28h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, [esp+18h]
                mov     ecx, [esp+14h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+1Ch]
                and     ebx, [esp]
                and     edi, [esp+4]
                xor     ecx, ebx
                and     ebp, [esp+8]
                xor     edi, ecx
                mov     edx, [esi+2Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [esp+8]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+10h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+18h]
                and     ebx, [esp+1Ch]
                and     edi, [esp]
                xor     ecx, ebx
                and     ebp, [esp+4]
                xor     edi, ecx
                mov     edx, [esi+30h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebp, [esp+4]
                mov     ebx, [esp+10h]
                mov     ecx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+14h]
                and     ebx, [esp+18h]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                and     ebp, [esp]
                xor     edi, ecx
                mov     edx, [esi+34h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebp, [esp]
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+8]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+10h]
                and     ebx, [esp+14h]
                and     edi, [esp+18h]
                xor     ecx, ebx
                and     ebp, [esp+1Ch]
                xor     edi, ecx
                mov     edx, [esi+38h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, [esp+8]
                mov     ecx, [esp+4]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+0Ch]
                and     ebx, [esp+10h]
                and     edi, [esp+14h]
                xor     ecx, ebx
                and     ebp, [esp+18h]
                xor     edi, ecx
                mov     edx, [esi+3Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp+18h]
                mov     ebx, [esp+4]
                mov     ecx, [esp]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+8]
                and     ebx, [esp+0Ch]
                and     edi, [esp+10h]
                xor     ecx, ebx
                and     ebp, [esp+14h]
                xor     edi, ecx
                mov     edx, [esi+40h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+14h]
                mov     ebx, [esp]
                mov     ecx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+4]
                and     ebx, [esp+8]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                and     ebp, [esp+10h]
                xor     edi, ecx
                mov     edx, [esi+44h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebp, [esp+10h]
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp+18h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp]
                and     ebx, [esp+4]
                and     edi, [esp+8]
                xor     ecx, ebx
                and     ebp, [esp+0Ch]
                xor     edi, ecx
                mov     edx, [esi+48h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, [esp+18h]
                mov     ecx, [esp+14h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+1Ch]
                and     ebx, [esp]
                and     edi, [esp+4]
                xor     ecx, ebx
                and     ebp, [esp+8]
                xor     edi, ecx
                mov     edx, [esi+4Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [esp+8]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+10h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+18h]
                and     ebx, [esp+1Ch]
                and     edi, [esp]
                xor     ecx, ebx
                and     ebp, [esp+4]
                xor     edi, ecx
                mov     edx, [esi+50h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebp, [esp+4]
                mov     ebx, [esp+10h]
                mov     ecx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+14h]
                and     ebx, [esp+18h]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                and     ebp, [esp]
                xor     edi, ecx
                mov     edx, [esi+54h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebp, [esp]
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+8]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+10h]
                and     ebx, [esp+14h]
                and     edi, [esp+18h]
                xor     ecx, ebx
                and     ebp, [esp+1Ch]
                xor     edi, ecx
                mov     edx, [esi+58h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, [esp+8]
                mov     ecx, [esp+4]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+0Ch]
                and     ebx, [esp+10h]
                and     edi, [esp+14h]
                xor     ecx, ebx
                and     ebp, [esp+18h]
                xor     edi, ecx
                mov     edx, [esi+5Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp+18h]
                mov     ebx, [esp+4]
                mov     ecx, [esp]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+8]
                and     ebx, [esp+0Ch]
                and     edi, [esp+10h]
                xor     ecx, ebx
                and     ebp, [esp+14h]
                xor     edi, ecx
                mov     edx, [esi+60h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+14h]
                mov     ebx, [esp]
                mov     ecx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+4]
                and     ebx, [esp+8]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                and     ebp, [esp+10h]
                xor     edi, ecx
                mov     edx, [esi+64h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebp, [esp+10h]
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp+18h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp]
                and     ebx, [esp+4]
                and     edi, [esp+8]
                xor     ecx, ebx
                and     ebp, [esp+0Ch]
                xor     edi, ecx
                mov     edx, [esi+68h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, [esp+18h]
                mov     ecx, [esp+14h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+1Ch]
                and     ebx, [esp]
                and     edi, [esp+4]
                xor     ecx, ebx
                and     ebp, [esp+8]
                xor     edi, ecx
                mov     edx, [esi+6Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [esp+8]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+10h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+18h]
                and     ebx, [esp+1Ch]
                and     edi, [esp]
                xor     ecx, ebx
                and     ebp, [esp+4]
                xor     edi, ecx
                mov     edx, [esi+70h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebp, [esp+4]
                mov     ebx, [esp+10h]
                mov     ecx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+14h]
                and     ebx, [esp+18h]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                and     ebp, [esp]
                xor     edi, ecx
                mov     edx, [esi+74h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebp, [esp]
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+8]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+10h]
                and     ebx, [esp+14h]
                and     edi, [esp+18h]
                xor     ecx, ebx
                and     ebp, [esp+1Ch]
                xor     edi, ecx
                mov     edx, [esi+78h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, [esp+8]
                mov     ecx, [esp+4]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+0Ch]
                and     ebx, [esp+10h]
                and     edi, [esp+14h]
                xor     ecx, ebx
                and     ebp, [esp+18h]
                xor     edi, ecx
                mov     edx, [esi+7Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp]
                mov     ebx, [esp+8]
                mov     edi, [esp+14h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+18h]
                and     ebx, edi
                mov     edx, [esp+10h]
                and     ebp, ecx
                xor     ebx, [esp+0Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+8]
                and     ebx, [esp+4]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+14h]
                xor     ecx, ebx
                and     edi, [esp]
                xor     ecx, edi
                lea     ebp, [eax+ebp+452821E6h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp+4]
                mov     edi, [esp+10h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+14h]
                and     ebx, edi
                mov     edx, [esp+0Ch]
                and     ebp, ecx
                xor     ebx, [esp+8]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+4]
                and     ebx, [esp]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+38h]
                xor     ecx, ebx
                and     edi, [esp+1Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp+38D01377h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp]
                mov     edi, [esp+0Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+10h]
                and     ebx, edi
                mov     edx, [esp+8]
                and     ebp, ecx
                xor     ebx, [esp+4]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp]
                and     ebx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+68h]
                xor     ecx, ebx
                and     edi, [esp+18h]
                xor     ecx, edi
                lea     ebp, [eax+ebp-41AB9931h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp+1Ch]
                mov     edi, [esp+8]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+0Ch]
                and     ebx, edi
                mov     edx, [esp+4]
                and     ebp, ecx
                xor     ebx, [esp]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+1Ch]
                and     ebx, [esp+18h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+48h]
                xor     ecx, ebx
                and     edi, [esp+14h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+34E90C6Ch]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp+18h]
                mov     edi, [esp+4]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+8]
                and     ebx, edi
                mov     edx, [esp]
                and     ebp, ecx
                xor     ebx, [esp+1Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+18h]
                and     ebx, [esp+14h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+2Ch]
                xor     ecx, ebx
                and     edi, [esp+10h]
                xor     ecx, edi
                lea     ebp, [eax+ebp-3F53D649h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+14h]
                mov     edi, [esp]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+4]
                and     ebx, edi
                mov     edx, [esp+1Ch]
                and     ebp, ecx
                xor     ebx, [esp+18h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+14h]
                and     ebx, [esp+10h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+70h]
                xor     ecx, ebx
                and     edi, [esp+0Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-3683AF23h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+10h]
                mov     edi, [esp+1Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp]
                and     ebx, edi
                mov     edx, [esp+18h]
                and     ebp, ecx
                xor     ebx, [esp+14h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+10h]
                and     ebx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+1Ch]
                xor     ecx, ebx
                and     edi, [esp+8]
                xor     ecx, edi
                lea     ebp, [eax+ebp+3F84D5B5h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+0Ch]
                mov     edi, [esp+18h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+1Ch]
                and     ebx, edi
                mov     edx, [esp+14h]
                and     ebp, ecx
                xor     ebx, [esp+10h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+0Ch]
                and     ebx, [esp+8]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+40h]
                xor     ecx, ebx
                and     edi, [esp+4]
                xor     ecx, edi
                lea     ebp, [eax+ebp-4AB8F6E9h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebx, [esp+8]
                mov     edi, [esp+14h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+18h]
                and     ebx, edi
                mov     edx, [esp+10h]
                and     ebp, ecx
                xor     ebx, [esp+0Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+8]
                and     ebx, [esp+4]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi]
                xor     ecx, ebx
                and     edi, [esp]
                xor     ecx, edi
                lea     ebp, [eax+ebp-6DE92A27h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp+4]
                mov     edi, [esp+10h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+14h]
                and     ebx, edi
                mov     edx, [esp+0Ch]
                and     ebp, ecx
                xor     ebx, [esp+8]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+4]
                and     ebx, [esp]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+5Ch]
                xor     ecx, ebx
                and     edi, [esp+1Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-768604E5h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp]
                mov     edi, [esp+0Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+10h]
                and     ebx, edi
                mov     edx, [esp+8]
                and     ebp, ecx
                xor     ebx, [esp+4]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp]
                and     ebx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+50h]
                xor     ecx, ebx
                and     edi, [esp+18h]
                xor     ecx, edi
                lea     ebp, [eax+ebp-2ECEF45Ah]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp+1Ch]
                mov     edi, [esp+8]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+0Ch]
                and     ebx, edi
                mov     edx, [esp+4]
                and     ebp, ecx
                xor     ebx, [esp]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+1Ch]
                and     ebx, [esp+18h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+58h]
                xor     ecx, ebx
                and     edi, [esp+14h]
                xor     ecx, edi
                lea     ebp, [eax+ebp-67204A54h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp+18h]
                mov     edi, [esp+4]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+8]
                and     ebx, edi
                mov     edx, [esp]
                and     ebp, ecx
                xor     ebx, [esp+1Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+18h]
                and     ebx, [esp+14h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+4]
                xor     ecx, ebx
                and     edi, [esp+10h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+2FFD72DBh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+14h]
                mov     edi, [esp]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+4]
                and     ebx, edi
                mov     edx, [esp+1Ch]
                and     ebp, ecx
                xor     ebx, [esp+18h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+14h]
                and     ebx, [esp+10h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+28h]
                xor     ecx, ebx
                and     edi, [esp+0Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-2FE52049h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+10h]
                mov     edi, [esp+1Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp]
                and     ebx, edi
                mov     edx, [esp+18h]
                and     ebp, ecx
                xor     ebx, [esp+14h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+10h]
                and     ebx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+10h]
                xor     ecx, ebx
                and     edi, [esp+8]
                xor     ecx, edi
                lea     ebp, [eax+ebp-471E5013h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+0Ch]
                mov     edi, [esp+18h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+1Ch]
                and     ebx, edi
                mov     edx, [esp+14h]
                and     ebp, ecx
                xor     ebx, [esp+10h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+0Ch]
                and     ebx, [esp+8]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+20h]
                xor     ecx, ebx
                and     edi, [esp+4]
                xor     ecx, edi
                lea     ebp, [eax+ebp+6A267E96h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebx, [esp+8]
                mov     edi, [esp+14h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+18h]
                and     ebx, edi
                mov     edx, [esp+10h]
                and     ebp, ecx
                xor     ebx, [esp+0Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+8]
                and     ebx, [esp+4]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+78h]
                xor     ecx, ebx
                and     edi, [esp]
                xor     ecx, edi
                lea     ebp, [eax+ebp-45836FBBh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp+4]
                mov     edi, [esp+10h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+14h]
                and     ebx, edi
                mov     edx, [esp+0Ch]
                and     ebp, ecx
                xor     ebx, [esp+8]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+4]
                and     ebx, [esp]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+0Ch]
                xor     ecx, ebx
                and     edi, [esp+1Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-0ED38067h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp]
                mov     edi, [esp+0Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+10h]
                and     ebx, edi
                mov     edx, [esp+8]
                and     ebp, ecx
                xor     ebx, [esp+4]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp]
                and     ebx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+54h]
                xor     ecx, ebx
                and     edi, [esp+18h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+24A19947h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp+1Ch]
                mov     edi, [esp+8]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+0Ch]
                and     ebx, edi
                mov     edx, [esp+4]
                and     ebp, ecx
                xor     ebx, [esp]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+1Ch]
                and     ebx, [esp+18h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+24h]
                xor     ecx, ebx
                and     edi, [esp+14h]
                xor     ecx, edi
                lea     ebp, [eax+ebp-4C6E9309h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp+18h]
                mov     edi, [esp+4]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+8]
                and     ebx, edi
                mov     edx, [esp]
                and     ebp, ecx
                xor     ebx, [esp+1Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+18h]
                and     ebx, [esp+14h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+44h]
                xor     ecx, ebx
                and     edi, [esp+10h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+801F2E2h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+14h]
                mov     edi, [esp]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+4]
                and     ebx, edi
                mov     edx, [esp+1Ch]
                and     ebp, ecx
                xor     ebx, [esp+18h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+14h]
                and     ebx, [esp+10h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+60h]
                xor     ecx, ebx
                and     edi, [esp+0Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-7A7103EAh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+10h]
                mov     edi, [esp+1Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp]
                and     ebx, edi
                mov     edx, [esp+18h]
                and     ebp, ecx
                xor     ebx, [esp+14h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+10h]
                and     ebx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+74h]
                xor     ecx, ebx
                and     edi, [esp+8]
                xor     ecx, edi
                lea     ebp, [eax+ebp+636920D8h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+0Ch]
                mov     edi, [esp+18h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+1Ch]
                and     ebx, edi
                mov     edx, [esp+14h]
                and     ebp, ecx
                xor     ebx, [esp+10h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+0Ch]
                and     ebx, [esp+8]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+18h]
                xor     ecx, ebx
                and     edi, [esp+4]
                xor     ecx, edi
                lea     ebp, [eax+ebp+71574E69h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebx, [esp+8]
                mov     edi, [esp+14h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+18h]
                and     ebx, edi
                mov     edx, [esp+10h]
                and     ebp, ecx
                xor     ebx, [esp+0Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+8]
                and     ebx, [esp+4]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+4Ch]
                xor     ecx, ebx
                and     edi, [esp]
                xor     ecx, edi
                lea     ebp, [eax+ebp-5BA7015Dh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp+4]
                mov     edi, [esp+10h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+14h]
                and     ebx, edi
                mov     edx, [esp+0Ch]
                and     ebp, ecx
                xor     ebx, [esp+8]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+4]
                and     ebx, [esp]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+30h]
                xor     ecx, ebx
                and     edi, [esp+1Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-0B6CC282h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp]
                mov     edi, [esp+0Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+10h]
                and     ebx, edi
                mov     edx, [esp+8]
                and     ebp, ecx
                xor     ebx, [esp+4]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp]
                and     ebx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+3Ch]
                xor     ecx, ebx
                and     edi, [esp+18h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+0D95748Fh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp+1Ch]
                mov     edi, [esp+8]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+0Ch]
                and     ebx, edi
                mov     edx, [esp+4]
                and     ebp, ecx
                xor     ebx, [esp]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+1Ch]
                and     ebx, [esp+18h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+34h]
                xor     ecx, ebx
                and     edi, [esp+14h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+728EB658h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp+18h]
                mov     edi, [esp+4]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+8]
                and     ebx, edi
                mov     edx, [esp]
                and     ebp, ecx
                xor     ebx, [esp+1Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+18h]
                and     ebx, [esp+14h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+8]
                xor     ecx, ebx
                and     edi, [esp+10h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+718BCD58h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+14h]
                mov     edi, [esp]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+4]
                and     ebx, edi
                mov     edx, [esp+1Ch]
                and     ebp, ecx
                xor     ebx, [esp+18h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+14h]
                and     ebx, [esp+10h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+64h]
                xor     ecx, ebx
                and     edi, [esp+0Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-7DEAB512h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+10h]
                mov     edi, [esp+1Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp]
                and     ebx, edi
                mov     edx, [esp+18h]
                and     ebp, ecx
                xor     ebx, [esp+14h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+10h]
                and     ebx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+7Ch]
                xor     ecx, ebx
                and     edi, [esp+8]
                xor     ecx, edi
                lea     ebp, [eax+ebp+7B54A41Dh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+0Ch]
                mov     edi, [esp+18h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+1Ch]
                and     ebx, edi
                mov     edx, [esp+14h]
                and     ebp, ecx
                xor     ebx, [esp+10h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+0Ch]
                and     ebx, [esp+8]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+6Ch]
                xor     ecx, ebx
                and     edi, [esp+4]
                xor     ecx, edi
                lea     ebp, [eax+ebp-3DA5A64Bh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp+14h]
                mov     ebx, [esp]
                mov     ecx, [esp+8]
                mov     edi, ebx
                and     ebx, [esp+10h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+4Ch]
                xor     edi, [esp+4]
                and     ecx, [esp+0Ch]
                and     edi, [esp+18h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-63CF2AC7h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+10h]
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp+4]
                mov     edi, ebx
                and     ebx, [esp+0Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+24h]
                xor     edi, [esp]
                and     ecx, [esp+8]
                and     edi, [esp+14h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+2AF26013h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, [esp+18h]
                mov     ecx, [esp]
                mov     edi, ebx
                and     ebx, [esp+8]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+10h]
                xor     edi, [esp+1Ch]
                and     ecx, [esp+4]
                and     edi, [esp+10h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-3A2E4FDDh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebp, [esp+8]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+1Ch]
                mov     edi, ebx
                and     ebx, [esp+4]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+50h]
                xor     edi, [esp+18h]
                and     ecx, [esp]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+286085F0h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [esp+4]
                mov     ebx, [esp+10h]
                mov     ecx, [esp+18h]
                mov     edi, ebx
                and     ebx, [esp]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+70h]
                xor     edi, [esp+14h]
                and     ecx, [esp+1Ch]
                and     edi, [esp+8]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-35BE86E8h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebp, [esp]
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+14h]
                mov     edi, ebx
                and     ebx, [esp+1Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+44h]
                xor     edi, [esp+10h]
                and     ecx, [esp+18h]
                and     edi, [esp+4]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-4724C711h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, [esp+8]
                mov     ecx, [esp+10h]
                mov     edi, ebx
                and     ebx, [esp+18h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+20h]
                xor     edi, [esp+0Ch]
                and     ecx, [esp+14h]
                and     edi, [esp]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-71862350h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebp, [esp+18h]
                mov     ebx, [esp+4]
                mov     ecx, [esp+0Ch]
                mov     edi, ebx
                and     ebx, [esp+14h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+58h]
                xor     edi, [esp+8]
                and     ecx, [esp+10h]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+603A180Eh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp+14h]
                mov     ebx, [esp]
                mov     ecx, [esp+8]
                mov     edi, ebx
                and     ebx, [esp+10h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+74h]
                xor     edi, [esp+4]
                and     ecx, [esp+0Ch]
                and     edi, [esp+18h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+6C9E0E8Bh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+10h]
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp+4]
                mov     edi, ebx
                and     ebx, [esp+0Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+38h]
                xor     edi, [esp]
                and     ecx, [esp+8]
                and     edi, [esp+14h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-4FE175C2h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, [esp+18h]
                mov     ecx, [esp]
                mov     edi, ebx
                and     ebx, [esp+8]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+64h]
                xor     edi, [esp+1Ch]
                and     ecx, [esp+4]
                and     edi, [esp+10h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-28EA883Fh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebp, [esp+8]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+1Ch]
                mov     edi, ebx
                and     ebx, [esp+4]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+30h]
                xor     edi, [esp+18h]
                and     ecx, [esp]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-42CEB4D9h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [esp+4]
                mov     ebx, [esp+10h]
                mov     ecx, [esp+18h]
                mov     edi, ebx
                and     ebx, [esp]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+60h]
                xor     edi, [esp+14h]
                and     ecx, [esp+1Ch]
                and     edi, [esp+8]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+78AF2FDAh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebp, [esp]
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+14h]
                mov     edi, ebx
                and     ebx, [esp+1Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+78h]
                xor     edi, [esp+10h]
                and     ecx, [esp+18h]
                and     edi, [esp+4]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+55605C60h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, [esp+8]
                mov     ecx, [esp+10h]
                mov     edi, ebx
                and     ebx, [esp+18h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+40h]
                xor     edi, [esp+0Ch]
                and     ecx, [esp+14h]
                and     edi, [esp]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-19AADA0Dh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebp, [esp+18h]
                mov     ebx, [esp+4]
                mov     ecx, [esp+0Ch]
                mov     edi, ebx
                and     ebx, [esp+14h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+68h]
                xor     edi, [esp+8]
                and     ecx, [esp+10h]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-55AA546Ch]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp+14h]
                mov     ebx, [esp]
                mov     ecx, [esp+8]
                mov     edi, ebx
                and     ebx, [esp+10h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+7Ch]
                xor     edi, [esp+4]
                and     ecx, [esp+0Ch]
                and     edi, [esp+18h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+57489862h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+10h]
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp+4]
                mov     edi, ebx
                and     ebx, [esp+0Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+3Ch]
                xor     edi, [esp]
                and     ecx, [esp+8]
                and     edi, [esp+14h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+63E81440h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, [esp+18h]
                mov     ecx, [esp]
                mov     edi, ebx
                and     ebx, [esp+8]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+1Ch]
                xor     edi, [esp+1Ch]
                and     ecx, [esp+4]
                and     edi, [esp+10h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+55CA396Ah]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebp, [esp+8]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+1Ch]
                mov     edi, ebx
                and     ebx, [esp+4]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+0Ch]
                xor     edi, [esp+18h]
                and     ecx, [esp]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+2AAB10B6h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [esp+4]
                mov     ebx, [esp+10h]
                mov     ecx, [esp+18h]
                mov     edi, ebx
                and     ebx, [esp]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+4]
                xor     edi, [esp+14h]
                and     ecx, [esp+1Ch]
                and     edi, [esp+8]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-4B33A3CCh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebp, [esp]
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+14h]
                mov     edi, ebx
                and     ebx, [esp+1Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi]
                xor     edi, [esp+10h]
                and     ecx, [esp+18h]
                and     edi, [esp+4]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+1141E8CEh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, [esp+8]
                mov     ecx, [esp+10h]
                mov     edi, ebx
                and     ebx, [esp+18h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+48h]
                xor     edi, [esp+0Ch]
                and     ecx, [esp+14h]
                and     edi, [esp]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-5EAB7951h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebp, [esp+18h]
                mov     ebx, [esp+4]
                mov     ecx, [esp+0Ch]
                mov     edi, ebx
                and     ebx, [esp+14h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+6Ch]
                xor     edi, [esp+8]
                and     ecx, [esp+10h]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+7C72E993h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp+14h]
                mov     ebx, [esp]
                mov     ecx, [esp+8]
                mov     edi, ebx
                and     ebx, [esp+10h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+34h]
                xor     edi, [esp+4]
                and     ecx, [esp+0Ch]
                and     edi, [esp+18h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-4C11EBEFh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+10h]
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp+4]
                mov     edi, ebx
                and     ebx, [esp+0Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+18h]
                xor     edi, [esp]
                and     ecx, [esp+8]
                and     edi, [esp+14h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+636FBC2Ah]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, [esp+18h]
                mov     ecx, [esp]
                mov     edi, ebx
                and     ebx, [esp+8]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+54h]
                xor     edi, [esp+1Ch]
                and     ecx, [esp+4]
                and     edi, [esp+10h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+2BA9C55Dh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebp, [esp+8]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+1Ch]
                mov     edi, ebx
                and     ebx, [esp+4]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+28h]
                xor     edi, [esp+18h]
                and     ecx, [esp]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+741831F6h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [esp+4]
                mov     ebx, [esp+10h]
                mov     ecx, [esp+18h]
                mov     edi, ebx
                and     ebx, [esp]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+5Ch]
                xor     edi, [esp+14h]
                and     ecx, [esp+1Ch]
                and     edi, [esp+8]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-31A3C1EAh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebp, [esp]
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+14h]
                mov     edi, ebx
                and     ebx, [esp+1Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+2Ch]
                xor     edi, [esp+10h]
                and     ecx, [esp+18h]
                and     edi, [esp+4]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-64786CE2h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, [esp+8]
                mov     ecx, [esp+10h]
                mov     edi, ebx
                and     ebx, [esp+18h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+14h]
                xor     edi, [esp+0Ch]
                and     ecx, [esp+14h]
                and     edi, [esp]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-502945CDh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebp, [esp+18h]
                mov     ebx, [esp+4]
                mov     ecx, [esp+0Ch]
                mov     edi, ebx
                and     ebx, [esp+14h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+8]
                xor     edi, [esp+8]
                and     ecx, [esp+10h]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+6C24CF5Ch]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp+8]
                mov     ecx, [esp+10h]
                mov     edx, [esp+18h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+14h]
                xor     ebp, [esp+4]
                xor     ebx, edx
                xor     ebp, [esp+0Ch]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp]
                and     ebp, [esp+4]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+60h]
                and     ebp, [esp+14h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+7A325381h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+4]
                mov     ecx, [esp+0Ch]
                mov     edx, [esp+14h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+10h]
                xor     ebp, [esp]
                xor     ebx, edx
                xor     ebp, [esp+8]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+1Ch]
                and     ebp, [esp]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+8]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+10h]
                and     ebp, [esp+10h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+28958677h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebp, [esp]
                mov     ecx, [esp+8]
                mov     edx, [esp+10h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+0Ch]
                xor     ebp, [esp+1Ch]
                xor     ebx, edx
                xor     ebp, [esp+4]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+18h]
                and     ebp, [esp+1Ch]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+4]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi]
                and     ebp, [esp+0Ch]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+3B8F4898h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebp, [esp+1Ch]
                mov     ecx, [esp+4]
                mov     edx, [esp+0Ch]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+8]
                xor     ebp, [esp+18h]
                xor     ebx, edx
                xor     ebp, [esp]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+14h]
                and     ebp, [esp+18h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+38h]
                and     ebp, [esp+8]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+6B4BB9AFh]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [esp+18h]
                mov     ecx, [esp]
                mov     edx, [esp+8]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+4]
                xor     ebp, [esp+14h]
                xor     ebx, edx
                xor     ebp, [esp+1Ch]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+10h]
                and     ebp, [esp+14h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+8]
                and     ebp, [esp+4]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-3B4017E5h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebp, [esp+14h]
                mov     ecx, [esp+1Ch]
                mov     edx, [esp+4]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp]
                xor     ebp, [esp+10h]
                xor     ebx, edx
                xor     ebp, [esp+18h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+0Ch]
                and     ebp, [esp+10h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+18h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+1Ch]
                and     ebp, [esp]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+66282193h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebp, [esp+10h]
                mov     ecx, [esp+18h]
                mov     edx, [esp]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+1Ch]
                xor     ebp, [esp+0Ch]
                xor     ebx, edx
                xor     ebp, [esp+14h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+8]
                and     ebp, [esp+0Ch]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+14h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+70h]
                and     ebp, [esp+1Ch]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+61D809CCh]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebp, [esp+0Ch]
                mov     ecx, [esp+14h]
                mov     edx, [esp+1Ch]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+18h]
                xor     ebp, [esp+8]
                xor     ebx, edx
                xor     ebp, [esp+10h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+4]
                and     ebp, [esp+8]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+10h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+5Ch]
                and     ebp, [esp+18h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-4DE566Fh]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp+8]
                mov     ecx, [esp+10h]
                mov     edx, [esp+18h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+14h]
                xor     ebp, [esp+4]
                xor     ebx, edx
                xor     ebp, [esp+0Ch]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp]
                and     ebp, [esp+4]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+68h]
                and     ebp, [esp+14h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+487CAC60h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+4]
                mov     ecx, [esp+0Ch]
                mov     edx, [esp+14h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+10h]
                xor     ebp, [esp]
                xor     ebx, edx
                xor     ebp, [esp+8]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+1Ch]
                and     ebp, [esp]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+8]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+18h]
                and     ebp, [esp+10h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+5DEC8032h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebp, [esp]
                mov     ecx, [esp+8]
                mov     edx, [esp+10h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+0Ch]
                xor     ebp, [esp+1Ch]
                xor     ebx, edx
                xor     ebp, [esp+4]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+18h]
                and     ebp, [esp+1Ch]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+4]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+78h]
                and     ebp, [esp+0Ch]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-107BA2A3h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebp, [esp+1Ch]
                mov     ecx, [esp+4]
                mov     edx, [esp+0Ch]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+8]
                xor     ebp, [esp+18h]
                xor     ebx, edx
                xor     ebp, [esp]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+14h]
                and     ebp, [esp+18h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+50h]
                and     ebp, [esp+8]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-167A8A4Fh]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [esp+18h]
                mov     ecx, [esp]
                mov     edx, [esp+8]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+4]
                xor     ebp, [esp+14h]
                xor     ebx, edx
                xor     ebp, [esp+1Ch]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+10h]
                and     ebp, [esp+14h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+48h]
                and     ebp, [esp+4]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-23D9DCFEh]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebp, [esp+14h]
                mov     ecx, [esp+1Ch]
                mov     edx, [esp+4]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp]
                xor     ebp, [esp+10h]
                xor     ebx, edx
                xor     ebp, [esp+18h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+0Ch]
                and     ebp, [esp+10h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+18h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+64h]
                and     ebp, [esp]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-149AE478h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebp, [esp+10h]
                mov     ecx, [esp+18h]
                mov     edx, [esp]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+1Ch]
                xor     ebp, [esp+0Ch]
                xor     ebx, edx
                xor     ebp, [esp+14h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+8]
                and     ebp, [esp+0Ch]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+14h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+4Ch]
                and     ebp, [esp+1Ch]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+23893E81h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebp, [esp+0Ch]
                mov     ecx, [esp+14h]
                mov     edx, [esp+1Ch]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+18h]
                xor     ebp, [esp+8]
                xor     ebx, edx
                xor     ebp, [esp+10h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+4]
                and     ebp, [esp+8]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+10h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+0Ch]
                and     ebp, [esp+18h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-2C69533Bh]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp+8]
                mov     ecx, [esp+10h]
                mov     edx, [esp+18h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+14h]
                xor     ebp, [esp+4]
                xor     ebx, edx
                xor     ebp, [esp+0Ch]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp]
                and     ebp, [esp+4]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+58h]
                and     ebp, [esp+14h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+0F6D6FF3h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+4]
                mov     ecx, [esp+0Ch]
                mov     edx, [esp+14h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+10h]
                xor     ebp, [esp]
                xor     ebx, edx
                xor     ebp, [esp+8]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+1Ch]
                and     ebp, [esp]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+8]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+2Ch]
                and     ebp, [esp+10h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-7C0BBDC7h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebp, [esp]
                mov     ecx, [esp+8]
                mov     edx, [esp+10h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+0Ch]
                xor     ebp, [esp+1Ch]
                xor     ebx, edx
                xor     ebp, [esp+4]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+18h]
                and     ebp, [esp+1Ch]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+4]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+7Ch]
                and     ebp, [esp+0Ch]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+2E0B4482h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebp, [esp+1Ch]
                mov     ecx, [esp+4]
                mov     edx, [esp+0Ch]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+8]
                xor     ebp, [esp+18h]
                xor     ebx, edx
                xor     ebp, [esp]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+14h]
                and     ebp, [esp+18h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+54h]
                and     ebp, [esp+8]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-5B7BDFFCh]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [esp+18h]
                mov     ecx, [esp]
                mov     edx, [esp+8]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+4]
                xor     ebp, [esp+14h]
                xor     ebx, edx
                xor     ebp, [esp+1Ch]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+10h]
                and     ebp, [esp+14h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+20h]
                and     ebp, [esp+4]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+69C8F04Ah]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebp, [esp+14h]
                mov     ecx, [esp+1Ch]
                mov     edx, [esp+4]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp]
                xor     ebp, [esp+10h]
                xor     ebx, edx
                xor     ebp, [esp+18h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+0Ch]
                and     ebp, [esp+10h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+18h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+6Ch]
                and     ebp, [esp]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-61E064A2h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebp, [esp+10h]
                mov     ecx, [esp+18h]
                mov     edx, [esp]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+1Ch]
                xor     ebp, [esp+0Ch]
                xor     ebx, edx
                xor     ebp, [esp+14h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+8]
                and     ebp, [esp+0Ch]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+14h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+30h]
                and     ebp, [esp+1Ch]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+21C66842h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebp, [esp+0Ch]
                mov     ecx, [esp+14h]
                mov     edx, [esp+1Ch]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+18h]
                xor     ebp, [esp+8]
                xor     ebx, edx
                xor     ebp, [esp+10h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+4]
                and     ebp, [esp+8]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+10h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+24h]
                and     ebp, [esp+18h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-9169366h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp+8]
                mov     ecx, [esp+10h]
                mov     edx, [esp+18h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+14h]
                xor     ebp, [esp+4]
                xor     ebx, edx
                xor     ebp, [esp+0Ch]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp]
                and     ebp, [esp+4]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+4]
                and     ebp, [esp+14h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+670C9C61h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+4]
                mov     ecx, [esp+0Ch]
                mov     edx, [esp+14h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+10h]
                xor     ebp, [esp]
                xor     ebx, edx
                xor     ebp, [esp+8]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+1Ch]
                and     ebp, [esp]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+8]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+74h]
                and     ebp, [esp+10h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-542C7710h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebp, [esp]
                mov     ecx, [esp+8]
                mov     edx, [esp+10h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+0Ch]
                xor     ebp, [esp+1Ch]
                xor     ebx, edx
                xor     ebp, [esp+4]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+18h]
                and     ebp, [esp+1Ch]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+4]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+14h]
                and     ebp, [esp+0Ch]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+6A51A0D2h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebp, [esp+1Ch]
                mov     ecx, [esp+4]
                mov     edx, [esp+0Ch]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+8]
                xor     ebp, [esp+18h]
                xor     ebx, edx
                xor     ebp, [esp]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+14h]
                and     ebp, [esp+18h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+3Ch]
                and     ebp, [esp+8]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-27ABD098h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [esp+18h]
                mov     ecx, [esp]
                mov     edx, [esp+8]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+4]
                xor     ebp, [esp+14h]
                xor     ebx, edx
                xor     ebp, [esp+1Ch]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+10h]
                and     ebp, [esp+14h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+44h]
                and     ebp, [esp+4]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-69F058D8h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebp, [esp+14h]
                mov     ecx, [esp+1Ch]
                mov     edx, [esp+4]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp]
                xor     ebp, [esp+10h]
                xor     ebx, edx
                xor     ebp, [esp+18h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+0Ch]
                and     ebp, [esp+10h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+18h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+28h]
                and     ebp, [esp]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-54AECC5Dh]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebp, [esp+10h]
                mov     ecx, [esp+18h]
                mov     edx, [esp]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+1Ch]
                xor     ebp, [esp+0Ch]
                xor     ebx, edx
                xor     ebp, [esp+14h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+8]
                and     ebp, [esp+0Ch]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+14h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+40h]
                and     ebp, [esp+1Ch]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+6EEF0B6Ch]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebp, [esp+0Ch]
                mov     ecx, [esp+14h]
                mov     edx, [esp+1Ch]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+18h]
                xor     ebp, [esp+8]
                xor     ebx, edx
                xor     ebp, [esp+10h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+4]
                and     ebp, [esp+8]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+10h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+34h]
                and     ebp, [esp+18h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+137A3BE4h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     edi, [esp+24h]
                mov     eax, [esp]
                mov     ebx, [esp+4]
                add     [edi], eax
                add     [edi+4], ebx
                mov     ecx, [esp+8]
                mov     edx, [esp+0Ch]
                add     [edi+8], ecx
                add     [edi+0Ch], edx
                mov     eax, [esp+10h]
                mov     ebx, [esp+14h]
                add     [edi+10h], eax
                add     [edi+14h], ebx
                mov     ebp, [esp+28h]
                mov     ecx, [esp+18h]
                mov     edx, [esp+1Ch]
                mov     esp, ebp
                add     [edi+18h], ecx
                add     [edi+1Ch], edx
                pop     ebp
                pop     edi
                pop     esi
                pop     ebx
end;

procedure THashBaseHaval.DoTransform5(Buffer: PLongArray);
asm
                push    ebx
                push    esi
                push    edi
                lea     edi, [eax].THashBaseHaval.FDigest
                mov     esi, edx
                push    ebp
                mov     ebp, esp
                add     esp, 0FFFFFFD4h
                and     esp, 0FFFFFFC0h
                mov     eax, [edi]
                mov     ebx, [edi+4]
                mov     [esp+20h], esi
                mov     [esp+24h], edi
                mov     [esp+28h], ebp
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     ecx, [edi+8]
                mov     edx, [edi+0Ch]
                mov     [esp+8], ecx
                mov     [esp+0Ch], edx
                mov     eax, [edi+10h]
                mov     ebx, [edi+14h]
                mov     [esp+10h], eax
                mov     [esp+14h], ebx
                mov     ecx, [edi+18h]
                mov     edx, [edi+1Ch]
                mov     [esp+18h], ecx
                mov     [esp+1Ch], edx
                mov     eax, edx
                mov     ebp, [esp+10h]
                mov     ebx, [esp+4]
                mov     ecx, [esp+18h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+0Ch]
                and     ebx, [esp+8]
                and     edi, [esp]
                xor     ecx, ebx
                and     ebp, [esp+14h]
                xor     edi, ecx
                mov     edx, [esi]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, [esp]
                mov     ecx, [esp+14h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+8]
                and     ebx, [esp+4]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                and     ebp, [esp+10h]
                xor     edi, ecx
                mov     edx, [esi+4]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebp, [esp+8]
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp+10h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+4]
                and     ebx, [esp]
                and     edi, [esp+18h]
                xor     ecx, ebx
                and     ebp, [esp+0Ch]
                xor     edi, ecx
                mov     edx, [esi+8]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebp, [esp+4]
                mov     ebx, [esp+18h]
                mov     ecx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp]
                and     ebx, [esp+1Ch]
                and     edi, [esp+14h]
                xor     ecx, ebx
                and     ebp, [esp+8]
                xor     edi, ecx
                mov     edx, [esi+0Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [esp]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+8]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+1Ch]
                and     ebx, [esp+18h]
                and     edi, [esp+10h]
                xor     ecx, ebx
                and     ebp, [esp+4]
                xor     edi, ecx
                mov     edx, [esi+10h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, [esp+10h]
                mov     ecx, [esp+4]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+18h]
                and     ebx, [esp+14h]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                and     ebp, [esp]
                xor     edi, ecx
                mov     edx, [esi+14h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebp, [esp+18h]
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+14h]
                and     ebx, [esp+10h]
                and     edi, [esp+8]
                xor     ecx, ebx
                and     ebp, [esp+1Ch]
                xor     edi, ecx
                mov     edx, [esi+18h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebp, [esp+14h]
                mov     ebx, [esp+8]
                mov     ecx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+10h]
                and     ebx, [esp+0Ch]
                and     edi, [esp+4]
                xor     ecx, ebx
                and     ebp, [esp+18h]
                xor     edi, ecx
                mov     edx, [esi+1Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp+10h]
                mov     ebx, [esp+4]
                mov     ecx, [esp+18h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+0Ch]
                and     ebx, [esp+8]
                and     edi, [esp]
                xor     ecx, ebx
                and     ebp, [esp+14h]
                xor     edi, ecx
                mov     edx, [esi+20h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, [esp]
                mov     ecx, [esp+14h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+8]
                and     ebx, [esp+4]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                and     ebp, [esp+10h]
                xor     edi, ecx
                mov     edx, [esi+24h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebp, [esp+8]
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp+10h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+4]
                and     ebx, [esp]
                and     edi, [esp+18h]
                xor     ecx, ebx
                and     ebp, [esp+0Ch]
                xor     edi, ecx
                mov     edx, [esi+28h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebp, [esp+4]
                mov     ebx, [esp+18h]
                mov     ecx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp]
                and     ebx, [esp+1Ch]
                and     edi, [esp+14h]
                xor     ecx, ebx
                and     ebp, [esp+8]
                xor     edi, ecx
                mov     edx, [esi+2Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [esp]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+8]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+1Ch]
                and     ebx, [esp+18h]
                and     edi, [esp+10h]
                xor     ecx, ebx
                and     ebp, [esp+4]
                xor     edi, ecx
                mov     edx, [esi+30h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, [esp+10h]
                mov     ecx, [esp+4]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+18h]
                and     ebx, [esp+14h]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                and     ebp, [esp]
                xor     edi, ecx
                mov     edx, [esi+34h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebp, [esp+18h]
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+14h]
                and     ebx, [esp+10h]
                and     edi, [esp+8]
                xor     ecx, ebx
                and     ebp, [esp+1Ch]
                xor     edi, ecx
                mov     edx, [esi+38h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebp, [esp+14h]
                mov     ebx, [esp+8]
                mov     ecx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+10h]
                and     ebx, [esp+0Ch]
                and     edi, [esp+4]
                xor     ecx, ebx
                and     ebp, [esp+18h]
                xor     edi, ecx
                mov     edx, [esi+3Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp+10h]
                mov     ebx, [esp+4]
                mov     ecx, [esp+18h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+0Ch]
                and     ebx, [esp+8]
                and     edi, [esp]
                xor     ecx, ebx
                and     ebp, [esp+14h]
                xor     edi, ecx
                mov     edx, [esi+40h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, [esp]
                mov     ecx, [esp+14h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+8]
                and     ebx, [esp+4]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                and     ebp, [esp+10h]
                xor     edi, ecx
                mov     edx, [esi+44h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebp, [esp+8]
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp+10h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+4]
                and     ebx, [esp]
                and     edi, [esp+18h]
                xor     ecx, ebx
                and     ebp, [esp+0Ch]
                xor     edi, ecx
                mov     edx, [esi+48h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebp, [esp+4]
                mov     ebx, [esp+18h]
                mov     ecx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp]
                and     ebx, [esp+1Ch]
                and     edi, [esp+14h]
                xor     ecx, ebx
                and     ebp, [esp+8]
                xor     edi, ecx
                mov     edx, [esi+4Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [esp]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+8]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+1Ch]
                and     ebx, [esp+18h]
                and     edi, [esp+10h]
                xor     ecx, ebx
                and     ebp, [esp+4]
                xor     edi, ecx
                mov     edx, [esi+50h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, [esp+10h]
                mov     ecx, [esp+4]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+18h]
                and     ebx, [esp+14h]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                and     ebp, [esp]
                xor     edi, ecx
                mov     edx, [esi+54h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebp, [esp+18h]
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+14h]
                and     ebx, [esp+10h]
                and     edi, [esp+8]
                xor     ecx, ebx
                and     ebp, [esp+1Ch]
                xor     edi, ecx
                mov     edx, [esi+58h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebp, [esp+14h]
                mov     ebx, [esp+8]
                mov     ecx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+10h]
                and     ebx, [esp+0Ch]
                and     edi, [esp+4]
                xor     ecx, ebx
                and     ebp, [esp+18h]
                xor     edi, ecx
                mov     edx, [esi+5Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp+10h]
                mov     ebx, [esp+4]
                mov     ecx, [esp+18h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+0Ch]
                and     ebx, [esp+8]
                and     edi, [esp]
                xor     ecx, ebx
                and     ebp, [esp+14h]
                xor     edi, ecx
                mov     edx, [esi+60h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, [esp]
                mov     ecx, [esp+14h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+8]
                and     ebx, [esp+4]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                and     ebp, [esp+10h]
                xor     edi, ecx
                mov     edx, [esi+64h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebp, [esp+8]
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp+10h]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+4]
                and     ebx, [esp]
                and     edi, [esp+18h]
                xor     ecx, ebx
                and     ebp, [esp+0Ch]
                xor     edi, ecx
                mov     edx, [esi+68h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebp, [esp+4]
                mov     ebx, [esp+18h]
                mov     ecx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp]
                and     ebx, [esp+1Ch]
                and     edi, [esp+14h]
                xor     ecx, ebx
                and     ebp, [esp+8]
                xor     edi, ecx
                mov     edx, [esi+6Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [esp]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+8]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+1Ch]
                and     ebx, [esp+18h]
                and     edi, [esp+10h]
                xor     ecx, ebx
                and     ebp, [esp+4]
                xor     edi, ecx
                mov     edx, [esi+70h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, [esp+10h]
                mov     ecx, [esp+4]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+18h]
                and     ebx, [esp+14h]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                and     ebp, [esp]
                xor     edi, ecx
                mov     edx, [esi+74h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebp, [esp+18h]
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+14h]
                and     ebx, [esp+10h]
                and     edi, [esp+8]
                xor     ecx, ebx
                and     ebp, [esp+1Ch]
                xor     edi, ecx
                mov     edx, [esi+78h]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebp, [esp+14h]
                mov     ebx, [esp+8]
                mov     ecx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ebx, ecx
                mov     edi, [esp+10h]
                and     ebx, [esp+0Ch]
                and     edi, [esp+4]
                xor     ecx, ebx
                and     ebp, [esp+18h]
                xor     edi, ecx
                mov     edx, [esi+7Ch]
                xor     ebp, edi
                add     eax, edx
                ror     ebp, 7
                add     ebp, eax
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp]
                mov     ebx, [esp+4]
                mov     edi, [esp+8]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+10h]
                and     ebx, edi
                mov     edx, [esp+14h]
                and     ebp, ecx
                xor     ebx, [esp+18h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+4]
                and     ebx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+14h]
                xor     ecx, ebx
                and     edi, [esp]
                xor     ecx, edi
                lea     ebp, [eax+ebp+452821E6h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp]
                mov     edi, [esp+4]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+0Ch]
                and     ebx, edi
                mov     edx, [esp+10h]
                and     ebp, ecx
                xor     ebx, [esp+14h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp]
                and     ebx, [esp+8]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+38h]
                xor     ecx, ebx
                and     edi, [esp+1Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp+38D01377h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp+1Ch]
                mov     edi, [esp]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+8]
                and     ebx, edi
                mov     edx, [esp+0Ch]
                and     ebp, ecx
                xor     ebx, [esp+10h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+1Ch]
                and     ebx, [esp+4]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+68h]
                xor     ecx, ebx
                and     edi, [esp+18h]
                xor     ecx, edi
                lea     ebp, [eax+ebp-41AB9931h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp+18h]
                mov     edi, [esp+1Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+4]
                and     ebx, edi
                mov     edx, [esp+8]
                and     ebp, ecx
                xor     ebx, [esp+0Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+18h]
                and     ebx, [esp]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+48h]
                xor     ecx, ebx
                and     edi, [esp+14h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+34E90C6Ch]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp+14h]
                mov     edi, [esp+18h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp]
                and     ebx, edi
                mov     edx, [esp+4]
                and     ebp, ecx
                xor     ebx, [esp+8]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+14h]
                and     ebx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+2Ch]
                xor     ecx, ebx
                and     edi, [esp+10h]
                xor     ecx, edi
                lea     ebp, [eax+ebp-3F53D649h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+10h]
                mov     edi, [esp+14h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+1Ch]
                and     ebx, edi
                mov     edx, [esp]
                and     ebp, ecx
                xor     ebx, [esp+4]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+10h]
                and     ebx, [esp+18h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+70h]
                xor     ecx, ebx
                and     edi, [esp+0Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-3683AF23h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+0Ch]
                mov     edi, [esp+10h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+18h]
                and     ebx, edi
                mov     edx, [esp+1Ch]
                and     ebp, ecx
                xor     ebx, [esp]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+0Ch]
                and     ebx, [esp+14h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+1Ch]
                xor     ecx, ebx
                and     edi, [esp+8]
                xor     ecx, edi
                lea     ebp, [eax+ebp+3F84D5B5h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+8]
                mov     edi, [esp+0Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+14h]
                and     ebx, edi
                mov     edx, [esp+18h]
                and     ebp, ecx
                xor     ebx, [esp+1Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+8]
                and     ebx, [esp+10h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+40h]
                xor     ecx, ebx
                and     edi, [esp+4]
                xor     ecx, edi
                lea     ebp, [eax+ebp-4AB8F6E9h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebx, [esp+4]
                mov     edi, [esp+8]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+10h]
                and     ebx, edi
                mov     edx, [esp+14h]
                and     ebp, ecx
                xor     ebx, [esp+18h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+4]
                and     ebx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi]
                xor     ecx, ebx
                and     edi, [esp]
                xor     ecx, edi
                lea     ebp, [eax+ebp-6DE92A27h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp]
                mov     edi, [esp+4]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+0Ch]
                and     ebx, edi
                mov     edx, [esp+10h]
                and     ebp, ecx
                xor     ebx, [esp+14h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp]
                and     ebx, [esp+8]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+5Ch]
                xor     ecx, ebx
                and     edi, [esp+1Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-768604E5h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp+1Ch]
                mov     edi, [esp]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+8]
                and     ebx, edi
                mov     edx, [esp+0Ch]
                and     ebp, ecx
                xor     ebx, [esp+10h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+1Ch]
                and     ebx, [esp+4]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+50h]
                xor     ecx, ebx
                and     edi, [esp+18h]
                xor     ecx, edi
                lea     ebp, [eax+ebp-2ECEF45Ah]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp+18h]
                mov     edi, [esp+1Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+4]
                and     ebx, edi
                mov     edx, [esp+8]
                and     ebp, ecx
                xor     ebx, [esp+0Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+18h]
                and     ebx, [esp]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+58h]
                xor     ecx, ebx
                and     edi, [esp+14h]
                xor     ecx, edi
                lea     ebp, [eax+ebp-67204A54h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp+14h]
                mov     edi, [esp+18h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp]
                and     ebx, edi
                mov     edx, [esp+4]
                and     ebp, ecx
                xor     ebx, [esp+8]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+14h]
                and     ebx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+4]
                xor     ecx, ebx
                and     edi, [esp+10h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+2FFD72DBh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+10h]
                mov     edi, [esp+14h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+1Ch]
                and     ebx, edi
                mov     edx, [esp]
                and     ebp, ecx
                xor     ebx, [esp+4]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+10h]
                and     ebx, [esp+18h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+28h]
                xor     ecx, ebx
                and     edi, [esp+0Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-2FE52049h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+0Ch]
                mov     edi, [esp+10h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+18h]
                and     ebx, edi
                mov     edx, [esp+1Ch]
                and     ebp, ecx
                xor     ebx, [esp]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+0Ch]
                and     ebx, [esp+14h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+10h]
                xor     ecx, ebx
                and     edi, [esp+8]
                xor     ecx, edi
                lea     ebp, [eax+ebp-471E5013h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+8]
                mov     edi, [esp+0Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+14h]
                and     ebx, edi
                mov     edx, [esp+18h]
                and     ebp, ecx
                xor     ebx, [esp+1Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+8]
                and     ebx, [esp+10h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+20h]
                xor     ecx, ebx
                and     edi, [esp+4]
                xor     ecx, edi
                lea     ebp, [eax+ebp+6A267E96h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebx, [esp+4]
                mov     edi, [esp+8]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+10h]
                and     ebx, edi
                mov     edx, [esp+14h]
                and     ebp, ecx
                xor     ebx, [esp+18h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+4]
                and     ebx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+78h]
                xor     ecx, ebx
                and     edi, [esp]
                xor     ecx, edi
                lea     ebp, [eax+ebp-45836FBBh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp]
                mov     edi, [esp+4]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+0Ch]
                and     ebx, edi
                mov     edx, [esp+10h]
                and     ebp, ecx
                xor     ebx, [esp+14h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp]
                and     ebx, [esp+8]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+0Ch]
                xor     ecx, ebx
                and     edi, [esp+1Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-0ED38067h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp+1Ch]
                mov     edi, [esp]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+8]
                and     ebx, edi
                mov     edx, [esp+0Ch]
                and     ebp, ecx
                xor     ebx, [esp+10h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+1Ch]
                and     ebx, [esp+4]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+54h]
                xor     ecx, ebx
                and     edi, [esp+18h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+24A19947h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp+18h]
                mov     edi, [esp+1Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+4]
                and     ebx, edi
                mov     edx, [esp+8]
                and     ebp, ecx
                xor     ebx, [esp+0Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+18h]
                and     ebx, [esp]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+24h]
                xor     ecx, ebx
                and     edi, [esp+14h]
                xor     ecx, edi
                lea     ebp, [eax+ebp-4C6E9309h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp+14h]
                mov     edi, [esp+18h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp]
                and     ebx, edi
                mov     edx, [esp+4]
                and     ebp, ecx
                xor     ebx, [esp+8]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+14h]
                and     ebx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+44h]
                xor     ecx, ebx
                and     edi, [esp+10h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+801F2E2h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+10h]
                mov     edi, [esp+14h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+1Ch]
                and     ebx, edi
                mov     edx, [esp]
                and     ebp, ecx
                xor     ebx, [esp+4]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+10h]
                and     ebx, [esp+18h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+60h]
                xor     ecx, ebx
                and     edi, [esp+0Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-7A7103EAh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+0Ch]
                mov     edi, [esp+10h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+18h]
                and     ebx, edi
                mov     edx, [esp+1Ch]
                and     ebp, ecx
                xor     ebx, [esp]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+0Ch]
                and     ebx, [esp+14h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+74h]
                xor     ecx, ebx
                and     edi, [esp+8]
                xor     ecx, edi
                lea     ebp, [eax+ebp+636920D8h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+8]
                mov     edi, [esp+0Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+14h]
                and     ebx, edi
                mov     edx, [esp+18h]
                and     ebp, ecx
                xor     ebx, [esp+1Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+8]
                and     ebx, [esp+10h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+18h]
                xor     ecx, ebx
                and     edi, [esp+4]
                xor     ecx, edi
                lea     ebp, [eax+ebp+71574E69h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebx, [esp+4]
                mov     edi, [esp+8]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+10h]
                and     ebx, edi
                mov     edx, [esp+14h]
                and     ebp, ecx
                xor     ebx, [esp+18h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+4]
                and     ebx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+4Ch]
                xor     ecx, ebx
                and     edi, [esp]
                xor     ecx, edi
                lea     ebp, [eax+ebp-5BA7015Dh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp]
                mov     edi, [esp+4]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+0Ch]
                and     ebx, edi
                mov     edx, [esp+10h]
                and     ebp, ecx
                xor     ebx, [esp+14h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp]
                and     ebx, [esp+8]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+30h]
                xor     ecx, ebx
                and     edi, [esp+1Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-0B6CC282h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp+1Ch]
                mov     edi, [esp]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+8]
                and     ebx, edi
                mov     edx, [esp+0Ch]
                and     ebp, ecx
                xor     ebx, [esp+10h]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+1Ch]
                and     ebx, [esp+4]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+3Ch]
                xor     ecx, ebx
                and     edi, [esp+18h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+0D95748Fh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp+18h]
                mov     edi, [esp+1Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+4]
                and     ebx, edi
                mov     edx, [esp+8]
                and     ebp, ecx
                xor     ebx, [esp+0Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+18h]
                and     ebx, [esp]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+34h]
                xor     ecx, ebx
                and     edi, [esp+14h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+728EB658h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp+14h]
                mov     edi, [esp+18h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp]
                and     ebx, edi
                mov     edx, [esp+4]
                and     ebp, ecx
                xor     ebx, [esp+8]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+14h]
                and     ebx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+8]
                xor     ecx, ebx
                and     edi, [esp+10h]
                xor     ecx, edi
                lea     ebp, [eax+ebp+718BCD58h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+10h]
                mov     edi, [esp+14h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+1Ch]
                and     ebx, edi
                mov     edx, [esp]
                and     ebp, ecx
                xor     ebx, [esp+4]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+10h]
                and     ebx, [esp+18h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+64h]
                xor     ecx, ebx
                and     edi, [esp+0Ch]
                xor     ecx, edi
                lea     ebp, [eax+ebp-7DEAB512h]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+0Ch]
                mov     edi, [esp+10h]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+18h]
                and     ebx, edi
                mov     edx, [esp+1Ch]
                and     ebp, ecx
                xor     ebx, [esp]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+0Ch]
                and     ebx, [esp+14h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+7Ch]
                xor     ecx, ebx
                and     edi, [esp+8]
                xor     ecx, edi
                lea     ebp, [eax+ebp+7B54A41Dh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+8]
                mov     edi, [esp+0Ch]
                xor     ebp, 0FFFFFFFFh
                mov     ecx, [esp+14h]
                and     ebx, edi
                mov     edx, [esp+18h]
                and     ebp, ecx
                xor     ebx, [esp+1Ch]
                xor     ebp, edx
                xor     ecx, edi
                xor     ebx, ebp
                and     ecx, [esp+8]
                and     ebx, [esp+10h]
                ror     eax, 0Bh
                xor     ecx, edx
                mov     ebp, [esi+6Ch]
                xor     ecx, ebx
                and     edi, [esp+4]
                xor     ecx, edi
                lea     ebp, [eax+ebp-3DA5A64Bh]
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp+14h]
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+4]
                mov     edi, ebx
                and     ebx, [esp+18h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+4Ch]
                xor     edi, [esp+8]
                and     ecx, [esp]
                and     edi, [esp+10h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-63CF2AC7h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+10h]
                mov     ebx, [esp+8]
                mov     ecx, [esp]
                mov     edi, ebx
                and     ebx, [esp+14h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+24h]
                xor     edi, [esp+4]
                and     ecx, [esp+1Ch]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+2AF26013h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, [esp+4]
                mov     ecx, [esp+1Ch]
                mov     edi, ebx
                and     ebx, [esp+10h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+10h]
                xor     edi, [esp]
                and     ecx, [esp+18h]
                and     edi, [esp+8]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-3A2E4FDDh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebp, [esp+8]
                mov     ebx, [esp]
                mov     ecx, [esp+18h]
                mov     edi, ebx
                and     ebx, [esp+0Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+50h]
                xor     edi, [esp+1Ch]
                and     ecx, [esp+14h]
                and     edi, [esp+4]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+286085F0h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [esp+4]
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp+14h]
                mov     edi, ebx
                and     ebx, [esp+8]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+70h]
                xor     edi, [esp+18h]
                and     ecx, [esp+10h]
                and     edi, [esp]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-35BE86E8h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebp, [esp]
                mov     ebx, [esp+18h]
                mov     ecx, [esp+10h]
                mov     edi, ebx
                and     ebx, [esp+4]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+44h]
                xor     edi, [esp+14h]
                and     ecx, [esp+0Ch]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-4724C711h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+0Ch]
                mov     edi, ebx
                and     ebx, [esp]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+20h]
                xor     edi, [esp+10h]
                and     ecx, [esp+8]
                and     edi, [esp+18h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-71862350h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebp, [esp+18h]
                mov     ebx, [esp+10h]
                mov     ecx, [esp+8]
                mov     edi, ebx
                and     ebx, [esp+1Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+58h]
                xor     edi, [esp+0Ch]
                and     ecx, [esp+4]
                and     edi, [esp+14h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+603A180Eh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp+14h]
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+4]
                mov     edi, ebx
                and     ebx, [esp+18h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+74h]
                xor     edi, [esp+8]
                and     ecx, [esp]
                and     edi, [esp+10h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+6C9E0E8Bh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+10h]
                mov     ebx, [esp+8]
                mov     ecx, [esp]
                mov     edi, ebx
                and     ebx, [esp+14h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+38h]
                xor     edi, [esp+4]
                and     ecx, [esp+1Ch]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-4FE175C2h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, [esp+4]
                mov     ecx, [esp+1Ch]
                mov     edi, ebx
                and     ebx, [esp+10h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+64h]
                xor     edi, [esp]
                and     ecx, [esp+18h]
                and     edi, [esp+8]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-28EA883Fh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebp, [esp+8]
                mov     ebx, [esp]
                mov     ecx, [esp+18h]
                mov     edi, ebx
                and     ebx, [esp+0Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+30h]
                xor     edi, [esp+1Ch]
                and     ecx, [esp+14h]
                and     edi, [esp+4]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-42CEB4D9h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [esp+4]
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp+14h]
                mov     edi, ebx
                and     ebx, [esp+8]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+60h]
                xor     edi, [esp+18h]
                and     ecx, [esp+10h]
                and     edi, [esp]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+78AF2FDAh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebp, [esp]
                mov     ebx, [esp+18h]
                mov     ecx, [esp+10h]
                mov     edi, ebx
                and     ebx, [esp+4]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+78h]
                xor     edi, [esp+14h]
                and     ecx, [esp+0Ch]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+55605C60h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+0Ch]
                mov     edi, ebx
                and     ebx, [esp]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+40h]
                xor     edi, [esp+10h]
                and     ecx, [esp+8]
                and     edi, [esp+18h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-19AADA0Dh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebp, [esp+18h]
                mov     ebx, [esp+10h]
                mov     ecx, [esp+8]
                mov     edi, ebx
                and     ebx, [esp+1Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+68h]
                xor     edi, [esp+0Ch]
                and     ecx, [esp+4]
                and     edi, [esp+14h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-55AA546Ch]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp+14h]
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+4]
                mov     edi, ebx
                and     ebx, [esp+18h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+7Ch]
                xor     edi, [esp+8]
                and     ecx, [esp]
                and     edi, [esp+10h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+57489862h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+10h]
                mov     ebx, [esp+8]
                mov     ecx, [esp]
                mov     edi, ebx
                and     ebx, [esp+14h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+3Ch]
                xor     edi, [esp+4]
                and     ecx, [esp+1Ch]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+63E81440h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, [esp+4]
                mov     ecx, [esp+1Ch]
                mov     edi, ebx
                and     ebx, [esp+10h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+1Ch]
                xor     edi, [esp]
                and     ecx, [esp+18h]
                and     edi, [esp+8]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+55CA396Ah]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebp, [esp+8]
                mov     ebx, [esp]
                mov     ecx, [esp+18h]
                mov     edi, ebx
                and     ebx, [esp+0Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+0Ch]
                xor     edi, [esp+1Ch]
                and     ecx, [esp+14h]
                and     edi, [esp+4]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+2AAB10B6h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [esp+4]
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp+14h]
                mov     edi, ebx
                and     ebx, [esp+8]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+4]
                xor     edi, [esp+18h]
                and     ecx, [esp+10h]
                and     edi, [esp]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-4B33A3CCh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebp, [esp]
                mov     ebx, [esp+18h]
                mov     ecx, [esp+10h]
                mov     edi, ebx
                and     ebx, [esp+4]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi]
                xor     edi, [esp+14h]
                and     ecx, [esp+0Ch]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+1141E8CEh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+0Ch]
                mov     edi, ebx
                and     ebx, [esp]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+48h]
                xor     edi, [esp+10h]
                and     ecx, [esp+8]
                and     edi, [esp+18h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-5EAB7951h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebp, [esp+18h]
                mov     ebx, [esp+10h]
                mov     ecx, [esp+8]
                mov     edi, ebx
                and     ebx, [esp+1Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+6Ch]
                xor     edi, [esp+0Ch]
                and     ecx, [esp+4]
                and     edi, [esp+14h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+7C72E993h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp+14h]
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+4]
                mov     edi, ebx
                and     ebx, [esp+18h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+34h]
                xor     edi, [esp+8]
                and     ecx, [esp]
                and     edi, [esp+10h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-4C11EBEFh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebp, [esp+10h]
                mov     ebx, [esp+8]
                mov     ecx, [esp]
                mov     edi, ebx
                and     ebx, [esp+14h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+18h]
                xor     edi, [esp+4]
                and     ecx, [esp+1Ch]
                and     edi, [esp+0Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+636FBC2Ah]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebp, [esp+0Ch]
                mov     ebx, [esp+4]
                mov     ecx, [esp+1Ch]
                mov     edi, ebx
                and     ebx, [esp+10h]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+54h]
                xor     edi, [esp]
                and     ecx, [esp+18h]
                and     edi, [esp+8]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+2BA9C55Dh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebp, [esp+8]
                mov     ebx, [esp]
                mov     ecx, [esp+18h]
                mov     edi, ebx
                and     ebx, [esp+0Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+28h]
                xor     edi, [esp+1Ch]
                and     ecx, [esp+14h]
                and     edi, [esp+4]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+741831F6h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebp, [esp+4]
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp+14h]
                mov     edi, ebx
                and     ebx, [esp+8]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+5Ch]
                xor     edi, [esp+18h]
                and     ecx, [esp+10h]
                and     edi, [esp]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-31A3C1EAh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebp, [esp]
                mov     ebx, [esp+18h]
                mov     ecx, [esp+10h]
                mov     edi, ebx
                and     ebx, [esp+4]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+2Ch]
                xor     edi, [esp+14h]
                and     ecx, [esp+0Ch]
                and     edi, [esp+1Ch]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-64786CE2h]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebp, [esp+1Ch]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+0Ch]
                mov     edi, ebx
                and     ebx, [esp]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+14h]
                xor     edi, [esp+10h]
                and     ecx, [esp+8]
                and     edi, [esp+18h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp-502945CDh]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebp, [esp+18h]
                mov     ebx, [esp+10h]
                mov     ecx, [esp+8]
                mov     edi, ebx
                and     ebx, [esp+1Ch]
                and     edi, ecx
                xor     ebx, ebp
                ror     eax, 0Bh
                xor     edi, ebp
                mov     ebp, [esi+8]
                xor     edi, [esp+0Ch]
                and     ecx, [esp+4]
                and     edi, [esp+14h]
                xor     ecx, ebx
                lea     ebp, [eax+ebp+6C24CF5Ch]
                xor     ecx, edi
                ror     ecx, 7
                add     ebp, ecx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebp, [esp]
                mov     ecx, [esp+14h]
                mov     edx, [esp+4]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+8]
                xor     ebp, [esp+10h]
                xor     ebx, edx
                xor     ebp, [esp+18h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+0Ch]
                and     ebp, [esp+10h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+18h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+60h]
                and     ebp, [esp+8]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+7A325381h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ecx, [esp+10h]
                mov     edx, [esp]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+4]
                xor     ebp, [esp+0Ch]
                xor     ebx, edx
                xor     ebp, [esp+14h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+8]
                and     ebp, [esp+0Ch]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+14h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+10h]
                and     ebp, [esp+4]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+28958677h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ecx, [esp+0Ch]
                mov     edx, [esp+1Ch]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp]
                xor     ebp, [esp+8]
                xor     ebx, edx
                xor     ebp, [esp+10h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+4]
                and     ebp, [esp+8]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+10h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi]
                and     ebp, [esp]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+3B8F4898h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ecx, [esp+8]
                mov     edx, [esp+18h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+1Ch]
                xor     ebp, [esp+4]
                xor     ebx, edx
                xor     ebp, [esp+0Ch]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp]
                and     ebp, [esp+4]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+38h]
                and     ebp, [esp+1Ch]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+6B4BB9AFh]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ecx, [esp+4]
                mov     edx, [esp+14h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+18h]
                xor     ebp, [esp]
                xor     ebx, edx
                xor     ebp, [esp+8]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+1Ch]
                and     ebp, [esp]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+8]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+8]
                and     ebp, [esp+18h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-3B4017E5h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ecx, [esp]
                mov     edx, [esp+10h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+14h]
                xor     ebp, [esp+1Ch]
                xor     ebx, edx
                xor     ebp, [esp+4]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+18h]
                and     ebp, [esp+1Ch]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+4]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+1Ch]
                and     ebp, [esp+14h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+66282193h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ecx, [esp+1Ch]
                mov     edx, [esp+0Ch]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+10h]
                xor     ebp, [esp+18h]
                xor     ebx, edx
                xor     ebp, [esp]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+14h]
                and     ebp, [esp+18h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+70h]
                and     ebp, [esp+10h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+61D809CCh]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ecx, [esp+18h]
                mov     edx, [esp+8]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+0Ch]
                xor     ebp, [esp+14h]
                xor     ebx, edx
                xor     ebp, [esp+1Ch]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+10h]
                and     ebp, [esp+14h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+5Ch]
                and     ebp, [esp+0Ch]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-4DE566Fh]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ecx, [esp+14h]
                mov     edx, [esp+4]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+8]
                xor     ebp, [esp+10h]
                xor     ebx, edx
                xor     ebp, [esp+18h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+0Ch]
                and     ebp, [esp+10h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+18h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+68h]
                and     ebp, [esp+8]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+487CAC60h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ecx, [esp+10h]
                mov     edx, [esp]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+4]
                xor     ebp, [esp+0Ch]
                xor     ebx, edx
                xor     ebp, [esp+14h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+8]
                and     ebp, [esp+0Ch]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+14h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+18h]
                and     ebp, [esp+4]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+5DEC8032h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ecx, [esp+0Ch]
                mov     edx, [esp+1Ch]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp]
                xor     ebp, [esp+8]
                xor     ebx, edx
                xor     ebp, [esp+10h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+4]
                and     ebp, [esp+8]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+10h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+78h]
                and     ebp, [esp]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-107BA2A3h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ecx, [esp+8]
                mov     edx, [esp+18h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+1Ch]
                xor     ebp, [esp+4]
                xor     ebx, edx
                xor     ebp, [esp+0Ch]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp]
                and     ebp, [esp+4]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+50h]
                and     ebp, [esp+1Ch]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-167A8A4Fh]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ecx, [esp+4]
                mov     edx, [esp+14h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+18h]
                xor     ebp, [esp]
                xor     ebx, edx
                xor     ebp, [esp+8]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+1Ch]
                and     ebp, [esp]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+8]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+48h]
                and     ebp, [esp+18h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-23D9DCFEh]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ecx, [esp]
                mov     edx, [esp+10h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+14h]
                xor     ebp, [esp+1Ch]
                xor     ebx, edx
                xor     ebp, [esp+4]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+18h]
                and     ebp, [esp+1Ch]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+4]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+64h]
                and     ebp, [esp+14h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-149AE478h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ecx, [esp+1Ch]
                mov     edx, [esp+0Ch]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+10h]
                xor     ebp, [esp+18h]
                xor     ebx, edx
                xor     ebp, [esp]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+14h]
                and     ebp, [esp+18h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+4Ch]
                and     ebp, [esp+10h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+23893E81h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ecx, [esp+18h]
                mov     edx, [esp+8]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+0Ch]
                xor     ebp, [esp+14h]
                xor     ebx, edx
                xor     ebp, [esp+1Ch]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+10h]
                and     ebp, [esp+14h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+0Ch]
                and     ebp, [esp+0Ch]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-2C69533Bh]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ecx, [esp+14h]
                mov     edx, [esp+4]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+8]
                xor     ebp, [esp+10h]
                xor     ebx, edx
                xor     ebp, [esp+18h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+0Ch]
                and     ebp, [esp+10h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+18h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+58h]
                and     ebp, [esp+8]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+0F6D6FF3h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ecx, [esp+10h]
                mov     edx, [esp]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+4]
                xor     ebp, [esp+0Ch]
                xor     ebx, edx
                xor     ebp, [esp+14h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+8]
                and     ebp, [esp+0Ch]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+14h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+2Ch]
                and     ebp, [esp+4]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-7C0BBDC7h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ecx, [esp+0Ch]
                mov     edx, [esp+1Ch]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp]
                xor     ebp, [esp+8]
                xor     ebx, edx
                xor     ebp, [esp+10h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+4]
                and     ebp, [esp+8]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+10h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+7Ch]
                and     ebp, [esp]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+2E0B4482h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ecx, [esp+8]
                mov     edx, [esp+18h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+1Ch]
                xor     ebp, [esp+4]
                xor     ebx, edx
                xor     ebp, [esp+0Ch]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp]
                and     ebp, [esp+4]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+54h]
                and     ebp, [esp+1Ch]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-5B7BDFFCh]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ecx, [esp+4]
                mov     edx, [esp+14h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+18h]
                xor     ebp, [esp]
                xor     ebx, edx
                xor     ebp, [esp+8]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+1Ch]
                and     ebp, [esp]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+8]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+20h]
                and     ebp, [esp+18h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+69C8F04Ah]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ecx, [esp]
                mov     edx, [esp+10h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+14h]
                xor     ebp, [esp+1Ch]
                xor     ebx, edx
                xor     ebp, [esp+4]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+18h]
                and     ebp, [esp+1Ch]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+4]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+6Ch]
                and     ebp, [esp+14h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-61E064A2h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ecx, [esp+1Ch]
                mov     edx, [esp+0Ch]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+10h]
                xor     ebp, [esp+18h]
                xor     ebx, edx
                xor     ebp, [esp]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+14h]
                and     ebp, [esp+18h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+30h]
                and     ebp, [esp+10h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+21C66842h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ecx, [esp+18h]
                mov     edx, [esp+8]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+0Ch]
                xor     ebp, [esp+14h]
                xor     ebx, edx
                xor     ebp, [esp+1Ch]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+10h]
                and     ebp, [esp+14h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+24h]
                and     ebp, [esp+0Ch]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-9169366h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ecx, [esp+14h]
                mov     edx, [esp+4]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+8]
                xor     ebp, [esp+10h]
                xor     ebx, edx
                xor     ebp, [esp+18h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+0Ch]
                and     ebp, [esp+10h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+18h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+4]
                and     ebp, [esp+8]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+670C9C61h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ecx, [esp+10h]
                mov     edx, [esp]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+4]
                xor     ebp, [esp+0Ch]
                xor     ebx, edx
                xor     ebp, [esp+14h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+8]
                and     ebp, [esp+0Ch]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+14h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+74h]
                and     ebp, [esp+4]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-542C7710h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ecx, [esp+0Ch]
                mov     edx, [esp+1Ch]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp]
                xor     ebp, [esp+8]
                xor     ebx, edx
                xor     ebp, [esp+10h]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+4]
                and     ebp, [esp+8]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+10h]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+14h]
                and     ebp, [esp]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+6A51A0D2h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ecx, [esp+8]
                mov     edx, [esp+18h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+1Ch]
                xor     ebp, [esp+4]
                xor     ebx, edx
                xor     ebp, [esp+0Ch]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp]
                and     ebp, [esp+4]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+0Ch]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+3Ch]
                and     ebp, [esp+1Ch]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-27ABD098h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ecx, [esp+4]
                mov     edx, [esp+14h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+18h]
                xor     ebp, [esp]
                xor     ebx, edx
                xor     ebp, [esp+8]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+1Ch]
                and     ebp, [esp]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+8]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+44h]
                and     ebp, [esp+18h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-69F058D8h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ecx, [esp]
                mov     edx, [esp+10h]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+14h]
                xor     ebp, [esp+1Ch]
                xor     ebx, edx
                xor     ebp, [esp+4]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+18h]
                and     ebp, [esp+1Ch]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+4]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+28h]
                and     ebp, [esp+14h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx-54AECC5Dh]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ecx, [esp+1Ch]
                mov     edx, [esp+0Ch]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+10h]
                xor     ebp, [esp+18h]
                xor     ebx, edx
                xor     ebp, [esp]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+14h]
                and     ebp, [esp+18h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+40h]
                and     ebp, [esp+10h]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+6EEF0B6Ch]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ecx, [esp+18h]
                mov     edx, [esp+8]
                mov     edi, ebp
                mov     ebx, edx
                xor     ebp, 0FFFFFFFFh
                xor     ebx, 0FFFFFFFFh
                and     ebp, ecx
                and     ebx, [esp+0Ch]
                xor     ebp, [esp+14h]
                xor     ebx, edx
                xor     ebp, [esp+1Ch]
                xor     ebx, ebp
                mov     ebp, edi
                and     ebx, [esp+10h]
                and     ebp, [esp+14h]
                and     edi, edx
                xor     ebp, ecx
                xor     ebx, [esp+1Ch]
                ror     eax, 0Bh
                xor     ebp, edx
                mov     edx, [esi+34h]
                and     ebp, [esp+0Ch]
                xor     ebx, edi
                xor     ebp, ebx
                lea     edx, [eax+edx+137A3BE4h]
                ror     ebp, 7
                add     ebp, edx
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                nop
                nop
                nop
                nop
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+10h]
                and     ebp, ebx
                mov     edx, [esp+14h]
                and     ebx, ecx
                mov     edi, [esp+18h]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+8]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+6Ch]
                and     ebx, [esp+4]
                xor     ebp, ecx
                lea     edi, [eax+edi-45C40FB0h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp+8]
                mov     ecx, [esp+0Ch]
                and     ebp, ebx
                mov     edx, [esp+10h]
                and     ebx, ecx
                mov     edi, [esp+14h]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+4]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+0Ch]
                and     ebx, [esp]
                xor     ebp, ecx
                lea     edi, [eax+edi+7EFB2A98h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp+4]
                mov     ecx, [esp+8]
                and     ebp, ebx
                mov     edx, [esp+0Ch]
                and     ebx, ecx
                mov     edi, [esp+10h]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+54h]
                and     ebx, [esp+1Ch]
                xor     ebp, ecx
                lea     edi, [eax+edi-5E0E9AE3h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp]
                mov     ecx, [esp+4]
                and     ebp, ebx
                mov     edx, [esp+8]
                and     ebx, ecx
                mov     edi, [esp+0Ch]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+1Ch]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+68h]
                and     ebx, [esp+18h]
                xor     ebp, ecx
                lea     edi, [eax+edi+39AF0176h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp]
                and     ebp, ebx
                mov     edx, [esp+4]
                and     ebx, ecx
                mov     edi, [esp+8]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+18h]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+44h]
                and     ebx, [esp+14h]
                xor     ebp, ecx
                lea     edi, [eax+edi+66CA593Eh]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+18h]
                mov     ecx, [esp+1Ch]
                and     ebp, ebx
                mov     edx, [esp]
                and     ebx, ecx
                mov     edi, [esp+4]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+14h]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+2Ch]
                and     ebx, [esp+10h]
                xor     ebp, ecx
                lea     edi, [eax+edi-7DBCF178h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+14h]
                mov     ecx, [esp+18h]
                and     ebp, ebx
                mov     edx, [esp+1Ch]
                and     ebx, ecx
                mov     edi, [esp]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+10h]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+50h]
                and     ebx, [esp+0Ch]
                xor     ebp, ecx
                lea     edi, [eax+edi-731179E7h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+10h]
                mov     ecx, [esp+14h]
                and     ebp, ebx
                mov     edx, [esp+18h]
                and     ebx, ecx
                mov     edi, [esp+1Ch]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+0Ch]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+74h]
                and     ebx, [esp+8]
                xor     ebp, ecx
                lea     edi, [eax+edi+456F9FB4h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+10h]
                and     ebp, ebx
                mov     edx, [esp+14h]
                and     ebx, ecx
                mov     edi, [esp+18h]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+8]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+4Ch]
                and     ebx, [esp+4]
                xor     ebp, ecx
                lea     edi, [eax+edi+7D84A5C3h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp+8]
                mov     ecx, [esp+0Ch]
                and     ebp, ebx
                mov     edx, [esp+10h]
                and     ebx, ecx
                mov     edi, [esp+14h]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+4]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi]
                and     ebx, [esp]
                xor     ebp, ecx
                lea     edi, [eax+edi+3B8B5EBEh]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp+4]
                mov     ecx, [esp+8]
                and     ebp, ebx
                mov     edx, [esp+0Ch]
                and     ebx, ecx
                mov     edi, [esp+10h]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+30h]
                and     ebx, [esp+1Ch]
                xor     ebp, ecx
                lea     edi, [eax+edi-1F908A28h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp]
                mov     ecx, [esp+4]
                and     ebp, ebx
                mov     edx, [esp+8]
                and     ebx, ecx
                mov     edi, [esp+0Ch]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+1Ch]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+1Ch]
                and     ebx, [esp+18h]
                xor     ebp, ecx
                lea     edi, [eax+edi-7A3EDF8Dh]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp]
                and     ebp, ebx
                mov     edx, [esp+4]
                and     ebx, ecx
                mov     edi, [esp+8]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+18h]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+34h]
                and     ebx, [esp+14h]
                xor     ebp, ecx
                lea     edi, [eax+edi+401A449Fh]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+18h]
                mov     ecx, [esp+1Ch]
                and     ebp, ebx
                mov     edx, [esp]
                and     ebx, ecx
                mov     edi, [esp+4]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+14h]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+20h]
                and     ebx, [esp+10h]
                xor     ebp, ecx
                lea     edi, [eax+edi+56C16AA6h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+14h]
                mov     ecx, [esp+18h]
                and     ebp, ebx
                mov     edx, [esp+1Ch]
                and     ebx, ecx
                mov     edi, [esp]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+10h]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+7Ch]
                and     ebx, [esp+0Ch]
                xor     ebp, ecx
                lea     edi, [eax+edi+4ED3AA62h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+10h]
                mov     ecx, [esp+14h]
                and     ebp, ebx
                mov     edx, [esp+18h]
                and     ebx, ecx
                mov     edi, [esp+1Ch]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+0Ch]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+28h]
                and     ebx, [esp+8]
                xor     ebp, ecx
                lea     edi, [eax+edi+363F7706h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+10h]
                and     ebp, ebx
                mov     edx, [esp+14h]
                and     ebx, ecx
                mov     edi, [esp+18h]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+8]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+14h]
                and     ebx, [esp+4]
                xor     ebp, ecx
                lea     edi, [eax+edi+1BFEDF72h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp+8]
                mov     ecx, [esp+0Ch]
                and     ebp, ebx
                mov     edx, [esp+10h]
                and     ebx, ecx
                mov     edi, [esp+14h]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+4]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+24h]
                and     ebx, [esp]
                xor     ebp, ecx
                lea     edi, [eax+edi+429B023Dh]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp+4]
                mov     ecx, [esp+8]
                and     ebp, ebx
                mov     edx, [esp+0Ch]
                and     ebx, ecx
                mov     edi, [esp+10h]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+38h]
                and     ebx, [esp+1Ch]
                xor     ebp, ecx
                lea     edi, [eax+edi+37D0D724h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp]
                mov     ecx, [esp+4]
                and     ebp, ebx
                mov     edx, [esp+8]
                and     ebx, ecx
                mov     edi, [esp+0Ch]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+1Ch]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+78h]
                and     ebx, [esp+18h]
                xor     ebp, ecx
                lea     edi, [eax+edi-2FF5EDB8h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp]
                and     ebp, ebx
                mov     edx, [esp+4]
                and     ebx, ecx
                mov     edi, [esp+8]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+18h]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+48h]
                and     ebx, [esp+14h]
                xor     ebp, ecx
                lea     edi, [eax+edi-24F0152Dh]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+18h]
                mov     ecx, [esp+1Ch]
                and     ebp, ebx
                mov     edx, [esp]
                and     ebx, ecx
                mov     edi, [esp+4]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+14h]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+18h]
                and     ebx, [esp+10h]
                xor     ebp, ecx
                lea     edi, [eax+edi+49F1C09Bh]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+14h]
                mov     ecx, [esp+18h]
                and     ebp, ebx
                mov     edx, [esp+1Ch]
                and     ebx, ecx
                mov     edi, [esp]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+10h]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+70h]
                and     ebx, [esp+0Ch]
                xor     ebp, ecx
                lea     edi, [eax+edi+75372C9h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+10h]
                mov     ecx, [esp+14h]
                and     ebp, ebx
                mov     edx, [esp+18h]
                and     ebx, ecx
                mov     edi, [esp+1Ch]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+0Ch]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+60h]
                and     ebx, [esp+8]
                xor     ebp, ecx
                lea     edi, [eax+edi-7F66E485h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+10h]
                and     ebp, ebx
                mov     edx, [esp+14h]
                and     ebx, ecx
                mov     edi, [esp+18h]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+8]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+8]
                and     ebx, [esp+4]
                xor     ebp, ecx
                lea     edi, [eax+edi+25D479D8h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+18h]
                mov     [esp+1Ch], ebp
                mov     ebx, [esp+8]
                mov     ecx, [esp+0Ch]
                and     ebp, ebx
                mov     edx, [esp+10h]
                and     ebx, ecx
                mov     edi, [esp+14h]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+4]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+5Ch]
                and     ebx, [esp]
                xor     ebp, ecx
                lea     edi, [eax+edi-9172109h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+14h]
                mov     [esp+18h], ebp
                mov     ebx, [esp+4]
                mov     ecx, [esp+8]
                and     ebp, ebx
                mov     edx, [esp+0Ch]
                and     ebx, ecx
                mov     edi, [esp+10h]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+40h]
                and     ebx, [esp+1Ch]
                xor     ebp, ecx
                lea     edi, [eax+edi-1C01AFE6h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+10h]
                mov     [esp+14h], ebp
                mov     ebx, [esp]
                mov     ecx, [esp+4]
                and     ebp, ebx
                mov     edx, [esp+8]
                and     ebx, ecx
                mov     edi, [esp+0Ch]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+1Ch]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+58h]
                and     ebx, [esp+18h]
                xor     ebp, ecx
                lea     edi, [eax+edi-4986B3C5h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+0Ch]
                mov     [esp+10h], ebp
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp]
                and     ebp, ebx
                mov     edx, [esp+4]
                and     ebx, ecx
                mov     edi, [esp+8]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+18h]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+10h]
                and     ebx, [esp+14h]
                xor     ebp, ecx
                lea     edi, [eax+edi-68931F43h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+8]
                mov     [esp+0Ch], ebp
                mov     ebx, [esp+18h]
                mov     ecx, [esp+1Ch]
                and     ebp, ebx
                mov     edx, [esp]
                and     ebx, ecx
                mov     edi, [esp+4]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+14h]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+4]
                and     ebx, [esp+10h]
                xor     ebp, ecx
                lea     edi, [eax+edi+4C006BAh]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+4]
                mov     [esp+8], ebp
                mov     ebx, [esp+14h]
                mov     ecx, [esp+18h]
                and     ebp, ebx
                mov     edx, [esp+1Ch]
                and     ebx, ecx
                mov     edi, [esp]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+10h]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+64h]
                and     ebx, [esp+0Ch]
                xor     ebp, ecx
                lea     edi, [eax+edi-3E56B04Ah]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp]
                mov     [esp+4], ebp
                mov     ebx, [esp+10h]
                mov     ecx, [esp+14h]
                and     ebp, ebx
                mov     edx, [esp+18h]
                and     ebx, ecx
                mov     edi, [esp+1Ch]
                and     ecx, edx
                xor     edx, 0FFFFFFFFh
                and     ebx, edi
                and     edi, [esp+0Ch]
                xor     ebx, edx
                ror     eax, 0Bh
                xor     ecx, edi
                mov     edi, [esi+3Ch]
                and     ebx, [esp+8]
                xor     ebp, ecx
                lea     edi, [eax+edi+409F60C4h]
                xor     ebp, ebx
                ror     ebp, 7
                add     ebp, edi
                mov     eax, [esp+1Ch]
                mov     [esp], ebp
                mov     edi, [esp+24h]
                mov     eax, [esp]
                mov     ebx, [esp+4]
                add     [edi], eax
                add     [edi+4], ebx
                mov     ecx, [esp+8]
                mov     edx, [esp+0Ch]
                add     [edi+8], ecx
                add     [edi+0Ch], edx
                mov     eax, [esp+10h]
                mov     ebx, [esp+14h]
                add     [edi+10h], eax
                add     [edi+14h], ebx
                mov     ebp, [esp+28h]
                mov     ecx, [esp+18h]
                mov     edx, [esp+1Ch]
                mov     esp, ebp
                add     [edi+18h], ecx
                add     [edi+1Ch], edx
                pop     ebp
                pop     edi
                pop     esi
                pop     ebx
end;
{$ENDIF}

{$IFDEF THash_Tiger_asm}
procedure THash_Tiger.DoTransform(Buffer: PLongArray);
asm
                push    ebx
                push    esi
                push    edi
                lea     edi, [eax].THash_Tiger.FDigest
                mov     esi, edx
                push    ebp
                mov     ebp, [eax].THash_Tiger.FRounds
                lea     eax, Tiger_Data

                mov     ecx, esp
                add     esp, 0FFFFFF94h
                and     esp, 0FFFFFFC0h
                sub     ebp, 3
                mov     [esp+58h], esi
                mov     [esp+5Ch], edi
                mov     [esp+60h], ebp
                mov     [esp+64h], eax
                mov     [esp+68h], ecx
                mov     eax, [esi]
                mov     ebx, [esi+4]
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     ecx, [esi+8]
                mov     edx, [esi+0Ch]
                mov     [esp+8], ecx
                mov     [esp+0Ch], edx
                mov     eax, [esi+10h]
                mov     ebx, [esi+14h]
                mov     [esp+10h], eax
                mov     [esp+14h], ebx
                mov     ecx, [esi+18h]
                mov     edx, [esi+1Ch]
                mov     [esp+18h], ecx
                mov     [esp+1Ch], edx
                mov     eax, [esi+20h]
                mov     ebx, [esi+24h]
                mov     [esp+20h], eax
                mov     [esp+24h], ebx
                mov     ecx, [esi+28h]
                mov     edx, [esi+2Ch]
                mov     [esp+28h], ecx
                mov     [esp+2Ch], edx
                mov     eax, [esi+30h]
                mov     ebx, [esi+34h]
                mov     [esp+30h], eax
                mov     [esp+34h], ebx
                mov     ecx, [esi+38h]
                mov     edx, [esi+3Ch]
                mov     [esp+38h], ecx
                mov     [esp+3Ch], edx
                mov     eax, [edi]
                mov     ebx, [edi+4]
                mov     [esp+40h], eax
                mov     [esp+44h], ebx
                mov     ecx, [edi+8]
                mov     edx, [edi+0Ch]
                mov     [esp+48h], ecx
                mov     [esp+4Ch], edx
                mov     eax, [edi+10h]
                mov     ebx, [edi+14h]
                mov     [esp+50h], eax
                mov     [esp+54h], ebx
                mov     esi, [esp+64h]
                mov     eax, [esp]
                mov     ebx, [esp+4]
                mov     ecx, [esp+50h]
                mov     edx, [esp+54h]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+50h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+54h], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+40h]
                mov     ebp, [esp+44h]
                sub     edi, ecx
                mov     eax, [esp+50h]
                sbb     ebp, edx
                mov     ebx, [esp+54h]
                mov     [esp+40h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+44h], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+48h]
                mov     ebx, [esp+4Ch]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Eh
                mov     ebp, ebx
                shl     ebx, 2
                mov     edi, eax
                shl     eax, 2
                or      ebx, ecx
                add     eax, edi
                adc     ebx, ebp
                mov     [esp+48h], eax
                mov     [esp+4Ch], ebx
                mov     eax, [esp+8]
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+40h]
                mov     edx, [esp+44h]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+40h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+44h], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+48h]
                mov     ebp, [esp+4Ch]
                sub     edi, ecx
                mov     eax, [esp+40h]
                sbb     ebp, edx
                mov     ebx, [esp+44h]
                mov     [esp+48h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+4Ch], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+50h]
                mov     ebx, [esp+54h]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Eh
                mov     ebp, ebx
                shl     ebx, 2
                mov     edi, eax
                shl     eax, 2
                or      ebx, ecx
                add     eax, edi
                adc     ebx, ebp
                mov     [esp+50h], eax
                mov     [esp+54h], ebx
                mov     eax, [esp+10h]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+48h]
                mov     edx, [esp+4Ch]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+48h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+4Ch], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+50h]
                mov     ebp, [esp+54h]
                sub     edi, ecx
                mov     eax, [esp+48h]
                sbb     ebp, edx
                mov     ebx, [esp+4Ch]
                mov     [esp+50h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+54h], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+40h]
                mov     ebx, [esp+44h]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Eh
                mov     ebp, ebx
                shl     ebx, 2
                mov     edi, eax
                shl     eax, 2
                or      ebx, ecx
                add     eax, edi
                adc     ebx, ebp
                mov     [esp+40h], eax
                mov     [esp+44h], ebx
                mov     eax, [esp+18h]
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp+50h]
                mov     edx, [esp+54h]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+50h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+54h], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+40h]
                mov     ebp, [esp+44h]
                sub     edi, ecx
                mov     eax, [esp+50h]
                sbb     ebp, edx
                mov     ebx, [esp+54h]
                mov     [esp+40h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+44h], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+48h]
                mov     ebx, [esp+4Ch]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Eh
                mov     ebp, ebx
                shl     ebx, 2
                mov     edi, eax
                shl     eax, 2
                or      ebx, ecx
                add     eax, edi
                adc     ebx, ebp
                mov     [esp+48h], eax
                mov     [esp+4Ch], ebx
                mov     eax, [esp+20h]
                mov     ebx, [esp+24h]
                mov     ecx, [esp+40h]
                mov     edx, [esp+44h]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+40h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+44h], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+48h]
                mov     ebp, [esp+4Ch]
                sub     edi, ecx
                mov     eax, [esp+40h]
                sbb     ebp, edx
                mov     ebx, [esp+44h]
                mov     [esp+48h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+4Ch], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+50h]
                mov     ebx, [esp+54h]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Eh
                mov     ebp, ebx
                shl     ebx, 2
                mov     edi, eax
                shl     eax, 2
                or      ebx, ecx
                add     eax, edi
                adc     ebx, ebp
                mov     [esp+50h], eax
                mov     [esp+54h], ebx
                mov     eax, [esp+28h]
                mov     ebx, [esp+2Ch]
                mov     ecx, [esp+48h]
                mov     edx, [esp+4Ch]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+48h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+4Ch], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+50h]
                mov     ebp, [esp+54h]
                sub     edi, ecx
                mov     eax, [esp+48h]
                sbb     ebp, edx
                mov     ebx, [esp+4Ch]
                mov     [esp+50h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+54h], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+40h]
                mov     ebx, [esp+44h]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Eh
                mov     ebp, ebx
                shl     ebx, 2
                mov     edi, eax
                shl     eax, 2
                or      ebx, ecx
                add     eax, edi
                adc     ebx, ebp
                mov     [esp+40h], eax
                mov     [esp+44h], ebx
                mov     eax, [esp+30h]
                mov     ebx, [esp+34h]
                mov     ecx, [esp+50h]
                mov     edx, [esp+54h]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+50h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+54h], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+40h]
                mov     ebp, [esp+44h]
                sub     edi, ecx
                mov     eax, [esp+50h]
                sbb     ebp, edx
                mov     ebx, [esp+54h]
                mov     [esp+40h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+44h], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+48h]
                mov     ebx, [esp+4Ch]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Eh
                mov     ebp, ebx
                shl     ebx, 2
                mov     edi, eax
                shl     eax, 2
                or      ebx, ecx
                add     eax, edi
                adc     ebx, ebp
                mov     [esp+48h], eax
                mov     [esp+4Ch], ebx
                mov     eax, [esp+38h]
                mov     ebx, [esp+3Ch]
                mov     ecx, [esp+40h]
                mov     edx, [esp+44h]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+40h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+44h], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+48h]
                mov     ebp, [esp+4Ch]
                sub     edi, ecx
                mov     eax, [esp+40h]
                sbb     ebp, edx
                mov     ebx, [esp+44h]
                mov     [esp+48h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+4Ch], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+50h]
                mov     ebx, [esp+54h]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Eh
                mov     ebp, ebx
                shl     ebx, 2
                mov     edi, eax
                shl     eax, 2
                or      ebx, ecx
                add     eax, edi
                adc     ebx, ebp
                mov     [esp+50h], eax
                mov     [esp+54h], ebx
                mov     eax, [esp+38h]
                mov     ebx, [esp+3Ch]
                xor     eax, 0A5A5A5A5h
                xor     ebx, 0A5A5A5A5h
                mov     ecx, [esp]
                mov     edx, [esp+4]
                sub     ecx, eax
                sbb     edx, ebx
                mov     [esp], ecx
                mov     [esp+4], edx
                mov     eax, [esp+8]
                mov     ebx, [esp+0Ch]
                xor     eax, ecx
                xor     ebx, edx
                mov     [esp+8], eax
                mov     edi, eax
                mov     esi, eax
                shr     edi, 0Dh
                xor     eax, 0FFFFFFFFh
                mov     [esp+0Ch], ebx
                mov     ecx, [esp+10h]
                shl     eax, 13h
                mov     ebp, ebx
                shl     ebx, 13h
                mov     edx, [esp+14h]
                add     esi, ecx
                mov     ecx, [esp+20h]
                adc     ebp, edx
                or      edi, ebx
                mov     [esp+10h], esi
                xor     esi, eax
                mov     [esp+14h], ebp
                mov     eax, [esp+18h]
                xor     ebp, 0FFFFFFFFh
                mov     ebx, [esp+1Ch]
                xor     ebp, edi
                sub     eax, esi
                sbb     ebx, ebp
                mov     edx, [esp+24h]
                mov     [esp+18h], eax
                xor     eax, ecx
                mov     [esp+1Ch], ebx
                xor     ebx, edx
                mov     ecx, [esp+28h]
                mov     edx, [esp+2Ch]
                mov     edi, ebx
                mov     ebp, ebx
                mov     [esp+20h], eax
                xor     ebp, 0FFFFFFFFh
                shl     ebx, 9
                add     ecx, eax
                adc     edx, edi
                mov     [esp+24h], edi
                shr     ebp, 17h
                mov     [esp+28h], ecx
                shr     eax, 17h
                xor     ecx, 0FFFFFFFFh
                or      ebx, eax
                mov     [esp+2Ch], edx
                mov     eax, [esp+30h]
                xor     ecx, ebx
                mov     ebx, [esp+34h]
                xor     edx, ebp
                mov     edi, [esp+38h]
                sub     eax, ecx
                mov     ebp, [esp+3Ch]
                mov     [esp+30h], eax
                sbb     ebx, edx
                xor     edi, eax
                xor     ebp, ebx
                mov     [esp+34h], ebx
                mov     eax, [esp]
                mov     ecx, edi
                xor     edi, 0FFFFFFFFh
                mov     ebx, [esp+4]
                shl     edi, 13h
                mov     [esp+38h], ecx
                add     eax, ecx
                mov     [esp+3Ch], ebp
                adc     ebx, ebp
                xor     edi, eax
                shr     ecx, 0Dh
                mov     [esp], eax
                shl     ebp, 13h
                mov     [esp+4], ebx
                mov     esi, [esp+8]
                xor     ebx, 0FFFFFFFFh
                or      ebp, ecx
                mov     edx, [esp+0Ch]
                xor     ebp, ebx
                sub     esi, edi
                mov     eax, [esp+10h]
                mov     ebx, [esp+14h]
                sbb     edx, ebp
                mov     [esp+8], esi
                xor     eax, esi
                mov     [esp+0Ch], edx
                mov     edi, [esp+18h]
                mov     ebp, [esp+1Ch]
                xor     ebx, edx
                mov     [esp+10h], eax
                add     edi, eax
                mov     esi, ebx
                adc     ebp, ebx
                mov     [esp+14h], ebx
                shr     eax, 17h
                mov     ecx, [esp+20h]
                xor     ebx, 0FFFFFFFFh
                mov     edx, [esp+24h]
                shl     esi, 9
                mov     [esp+18h], edi
                or      eax, esi
                xor     edi, 0FFFFFFFFh
                shr     ebx, 17h
                mov     [esp+1Ch], ebp
                xor     eax, edi
                mov     edi, [esp+28h]
                xor     ebx, ebp
                sub     ecx, eax
                mov     ebp, [esp+2Ch]
                mov     [esp+20h], ecx
                sbb     edx, ebx
                xor     edi, ecx
                mov     [esp+24h], edx
                xor     ebp, edx
                mov     eax, [esp+30h]
                mov     ebx, [esp+34h]
                mov     [esp+28h], edi
                add     eax, edi
                mov     [esp+2Ch], ebp
                mov     ecx, [esp+38h]
                adc     ebx, ebp
                mov     edx, [esp+3Ch]
                mov     [esp+30h], eax
                xor     eax, 89ABCDEFh
                mov     [esp+34h], ebx
                xor     ebx, 1234567h
                sub     ecx, eax
                sbb     edx, ebx
                mov     [esp+38h], ecx
                mov     [esp+3Ch], edx
                mov     esi, [esp+64h]
                mov     eax, [esp]
                mov     ebx, [esp+4]
                mov     ecx, [esp+48h]
                mov     edx, [esp+4Ch]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+48h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+4Ch], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+50h]
                mov     ebp, [esp+54h]
                sub     edi, ecx
                mov     eax, [esp+48h]
                sbb     ebp, edx
                mov     ebx, [esp+4Ch]
                mov     [esp+50h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+54h], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+40h]
                mov     ebx, [esp+44h]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Dh
                mov     ebp, ebx
                shl     ebx, 3
                mov     edi, eax
                shl     eax, 3
                or      ebx, ecx
                sub     eax, edi
                sbb     ebx, ebp
                mov     [esp+40h], eax
                mov     [esp+44h], ebx
                mov     eax, [esp+8]
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+50h]
                mov     edx, [esp+54h]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+50h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+54h], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+40h]
                mov     ebp, [esp+44h]
                sub     edi, ecx
                mov     eax, [esp+50h]
                sbb     ebp, edx
                mov     ebx, [esp+54h]
                mov     [esp+40h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+44h], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+48h]
                mov     ebx, [esp+4Ch]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Dh
                mov     ebp, ebx
                shl     ebx, 3
                mov     edi, eax
                shl     eax, 3
                or      ebx, ecx
                sub     eax, edi
                sbb     ebx, ebp
                mov     [esp+48h], eax
                mov     [esp+4Ch], ebx
                mov     eax, [esp+10h]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+40h]
                mov     edx, [esp+44h]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+40h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+44h], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+48h]
                mov     ebp, [esp+4Ch]
                sub     edi, ecx
                mov     eax, [esp+40h]
                sbb     ebp, edx
                mov     ebx, [esp+44h]
                mov     [esp+48h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+4Ch], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+50h]
                mov     ebx, [esp+54h]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Dh
                mov     ebp, ebx
                shl     ebx, 3
                mov     edi, eax
                shl     eax, 3
                or      ebx, ecx
                sub     eax, edi
                sbb     ebx, ebp
                mov     [esp+50h], eax
                mov     [esp+54h], ebx
                mov     eax, [esp+18h]
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp+48h]
                mov     edx, [esp+4Ch]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+48h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+4Ch], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+50h]
                mov     ebp, [esp+54h]
                sub     edi, ecx
                mov     eax, [esp+48h]
                sbb     ebp, edx
                mov     ebx, [esp+4Ch]
                mov     [esp+50h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+54h], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+40h]
                mov     ebx, [esp+44h]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Dh
                mov     ebp, ebx
                shl     ebx, 3
                mov     edi, eax
                shl     eax, 3
                or      ebx, ecx
                sub     eax, edi
                sbb     ebx, ebp
                mov     [esp+40h], eax
                mov     [esp+44h], ebx
                mov     eax, [esp+20h]
                mov     ebx, [esp+24h]
                mov     ecx, [esp+50h]
                mov     edx, [esp+54h]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+50h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+54h], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+40h]
                mov     ebp, [esp+44h]
                sub     edi, ecx
                mov     eax, [esp+50h]
                sbb     ebp, edx
                mov     ebx, [esp+54h]
                mov     [esp+40h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+44h], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+48h]
                mov     ebx, [esp+4Ch]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Dh
                mov     ebp, ebx
                shl     ebx, 3
                mov     edi, eax
                shl     eax, 3
                or      ebx, ecx
                sub     eax, edi
                sbb     ebx, ebp
                mov     [esp+48h], eax
                mov     [esp+4Ch], ebx
                mov     eax, [esp+28h]
                mov     ebx, [esp+2Ch]
                mov     ecx, [esp+40h]
                mov     edx, [esp+44h]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+40h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+44h], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+48h]
                mov     ebp, [esp+4Ch]
                sub     edi, ecx
                mov     eax, [esp+40h]
                sbb     ebp, edx
                mov     ebx, [esp+44h]
                mov     [esp+48h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+4Ch], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+50h]
                mov     ebx, [esp+54h]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Dh
                mov     ebp, ebx
                shl     ebx, 3
                mov     edi, eax
                shl     eax, 3
                or      ebx, ecx
                sub     eax, edi
                sbb     ebx, ebp
                mov     [esp+50h], eax
                mov     [esp+54h], ebx
                mov     eax, [esp+30h]
                mov     ebx, [esp+34h]
                mov     ecx, [esp+48h]
                mov     edx, [esp+4Ch]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+48h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+4Ch], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+50h]
                mov     ebp, [esp+54h]
                sub     edi, ecx
                mov     eax, [esp+48h]
                sbb     ebp, edx
                mov     ebx, [esp+4Ch]
                mov     [esp+50h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+54h], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+40h]
                mov     ebx, [esp+44h]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Dh
                mov     ebp, ebx
                shl     ebx, 3
                mov     edi, eax
                shl     eax, 3
                or      ebx, ecx
                sub     eax, edi
                sbb     ebx, ebp
                mov     [esp+40h], eax
                mov     [esp+44h], ebx
                mov     eax, [esp+38h]
                mov     ebx, [esp+3Ch]
                mov     ecx, [esp+50h]
                mov     edx, [esp+54h]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+50h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+54h], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+40h]
                mov     ebp, [esp+44h]
                sub     edi, ecx
                mov     eax, [esp+50h]
                sbb     ebp, edx
                mov     ebx, [esp+54h]
                mov     [esp+40h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+44h], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+48h]
                mov     ebx, [esp+4Ch]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Dh
                mov     ebp, ebx
                shl     ebx, 3
                mov     edi, eax
                shl     eax, 3
                or      ebx, ecx
                sub     eax, edi
                sbb     ebx, ebp
                mov     [esp+48h], eax
                mov     [esp+4Ch], ebx
                mov     eax, [esp+38h]
                mov     ebx, [esp+3Ch]
                xor     eax, 0A5A5A5A5h
                xor     ebx, 0A5A5A5A5h
                mov     ecx, [esp]
                mov     edx, [esp+4]
                sub     ecx, eax
                sbb     edx, ebx
                mov     [esp], ecx
                mov     [esp+4], edx
                mov     eax, [esp+8]
                mov     ebx, [esp+0Ch]
                xor     eax, ecx
                xor     ebx, edx
                mov     [esp+8], eax
                mov     edi, eax
                mov     esi, eax
                shr     edi, 0Dh
                xor     eax, 0FFFFFFFFh
                mov     [esp+0Ch], ebx
                mov     ecx, [esp+10h]
                shl     eax, 13h
                mov     ebp, ebx
                shl     ebx, 13h
                mov     edx, [esp+14h]
                add     esi, ecx
                mov     ecx, [esp+20h]
                adc     ebp, edx
                or      edi, ebx
                mov     [esp+10h], esi
                xor     esi, eax
                mov     [esp+14h], ebp
                mov     eax, [esp+18h]
                xor     ebp, 0FFFFFFFFh
                mov     ebx, [esp+1Ch]
                xor     ebp, edi
                sub     eax, esi
                sbb     ebx, ebp
                mov     edx, [esp+24h]
                mov     [esp+18h], eax
                xor     eax, ecx
                mov     [esp+1Ch], ebx
                xor     ebx, edx
                mov     ecx, [esp+28h]
                mov     edx, [esp+2Ch]
                mov     edi, ebx
                mov     ebp, ebx
                mov     [esp+20h], eax
                xor     ebp, 0FFFFFFFFh
                shl     ebx, 9
                add     ecx, eax
                adc     edx, edi
                mov     [esp+24h], edi
                shr     ebp, 17h
                mov     [esp+28h], ecx
                shr     eax, 17h
                xor     ecx, 0FFFFFFFFh
                or      ebx, eax
                mov     [esp+2Ch], edx
                mov     eax, [esp+30h]
                xor     ecx, ebx
                mov     ebx, [esp+34h]
                xor     edx, ebp
                mov     edi, [esp+38h]
                sub     eax, ecx
                mov     ebp, [esp+3Ch]
                mov     [esp+30h], eax
                sbb     ebx, edx
                xor     edi, eax
                xor     ebp, ebx
                mov     [esp+34h], ebx
                mov     eax, [esp]
                mov     ecx, edi
                xor     edi, 0FFFFFFFFh
                mov     ebx, [esp+4]
                shl     edi, 13h
                mov     [esp+38h], ecx
                add     eax, ecx
                mov     [esp+3Ch], ebp
                adc     ebx, ebp
                xor     edi, eax
                shr     ecx, 0Dh
                mov     [esp], eax
                shl     ebp, 13h
                mov     [esp+4], ebx
                mov     esi, [esp+8]
                xor     ebx, 0FFFFFFFFh
                or      ebp, ecx
                mov     edx, [esp+0Ch]
                xor     ebp, ebx
                sub     esi, edi
                mov     eax, [esp+10h]
                mov     ebx, [esp+14h]
                sbb     edx, ebp
                mov     [esp+8], esi
                xor     eax, esi
                mov     [esp+0Ch], edx
                mov     edi, [esp+18h]
                mov     ebp, [esp+1Ch]
                xor     ebx, edx
                mov     [esp+10h], eax
                add     edi, eax
                mov     esi, ebx
                adc     ebp, ebx
                mov     [esp+14h], ebx
                shr     eax, 17h
                mov     ecx, [esp+20h]
                xor     ebx, 0FFFFFFFFh
                mov     edx, [esp+24h]
                shl     esi, 9
                mov     [esp+18h], edi
                or      eax, esi
                xor     edi, 0FFFFFFFFh
                shr     ebx, 17h
                mov     [esp+1Ch], ebp
                xor     eax, edi
                mov     edi, [esp+28h]
                xor     ebx, ebp
                sub     ecx, eax
                mov     ebp, [esp+2Ch]
                mov     [esp+20h], ecx
                sbb     edx, ebx
                xor     edi, ecx
                mov     [esp+24h], edx
                xor     ebp, edx
                mov     eax, [esp+30h]
                mov     ebx, [esp+34h]
                mov     [esp+28h], edi
                add     eax, edi
                mov     [esp+2Ch], ebp
                mov     ecx, [esp+38h]
                adc     ebx, ebp
                mov     edx, [esp+3Ch]
                mov     [esp+30h], eax
                xor     eax, 89ABCDEFh
                mov     [esp+34h], ebx
                xor     ebx, 1234567h
                sub     ecx, eax
                sbb     edx, ebx
                mov     [esp+38h], ecx
                mov     [esp+3Ch], edx

@_pass_loop:
                mov     esi, [esp+64h]
                mov     eax, [esp]
                mov     ebx, [esp+4]
                mov     ecx, [esp+40h]
                mov     edx, [esp+44h]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+40h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+44h], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+48h]
                mov     ebp, [esp+4Ch]
                sub     edi, ecx
                mov     eax, [esp+40h]
                sbb     ebp, edx
                mov     ebx, [esp+44h]
                mov     [esp+48h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+4Ch], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+50h]
                mov     ebx, [esp+54h]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Dh
                mov     ebp, ebx
                shl     ebx, 3
                mov     edi, eax
                shl     eax, 3
                or      ebx, ecx
                add     eax, edi
                adc     ebx, ebp
                mov     [esp+50h], eax
                mov     [esp+54h], ebx
                mov     eax, [esp+8]
                mov     ebx, [esp+0Ch]
                mov     ecx, [esp+48h]
                mov     edx, [esp+4Ch]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+48h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+4Ch], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+50h]
                mov     ebp, [esp+54h]
                sub     edi, ecx
                mov     eax, [esp+48h]
                sbb     ebp, edx
                mov     ebx, [esp+4Ch]
                mov     [esp+50h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+54h], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+40h]
                mov     ebx, [esp+44h]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Dh
                mov     ebp, ebx
                shl     ebx, 3
                mov     edi, eax
                shl     eax, 3
                or      ebx, ecx
                add     eax, edi
                adc     ebx, ebp
                mov     [esp+40h], eax
                mov     [esp+44h], ebx
                mov     eax, [esp+10h]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+50h]
                mov     edx, [esp+54h]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+50h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+54h], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+40h]
                mov     ebp, [esp+44h]
                sub     edi, ecx
                mov     eax, [esp+50h]
                sbb     ebp, edx
                mov     ebx, [esp+54h]
                mov     [esp+40h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+44h], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+48h]
                mov     ebx, [esp+4Ch]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Dh
                mov     ebp, ebx
                shl     ebx, 3
                mov     edi, eax
                shl     eax, 3
                or      ebx, ecx
                add     eax, edi
                adc     ebx, ebp
                mov     [esp+48h], eax
                mov     [esp+4Ch], ebx
                mov     eax, [esp+18h]
                mov     ebx, [esp+1Ch]
                mov     ecx, [esp+40h]
                mov     edx, [esp+44h]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+40h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+44h], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+48h]
                mov     ebp, [esp+4Ch]
                sub     edi, ecx
                mov     eax, [esp+40h]
                sbb     ebp, edx
                mov     ebx, [esp+44h]
                mov     [esp+48h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+4Ch], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+50h]
                mov     ebx, [esp+54h]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Dh
                mov     ebp, ebx
                shl     ebx, 3
                mov     edi, eax
                shl     eax, 3
                or      ebx, ecx
                add     eax, edi
                adc     ebx, ebp
                mov     [esp+50h], eax
                mov     [esp+54h], ebx
                mov     eax, [esp+20h]
                mov     ebx, [esp+24h]
                mov     ecx, [esp+48h]
                mov     edx, [esp+4Ch]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+48h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+4Ch], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+50h]
                mov     ebp, [esp+54h]
                sub     edi, ecx
                mov     eax, [esp+48h]
                sbb     ebp, edx
                mov     ebx, [esp+4Ch]
                mov     [esp+50h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+54h], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+40h]
                mov     ebx, [esp+44h]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Dh
                mov     ebp, ebx
                shl     ebx, 3
                mov     edi, eax
                shl     eax, 3
                or      ebx, ecx
                add     eax, edi
                adc     ebx, ebp
                mov     [esp+40h], eax
                mov     [esp+44h], ebx
                mov     eax, [esp+28h]
                mov     ebx, [esp+2Ch]
                mov     ecx, [esp+50h]
                mov     edx, [esp+54h]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+50h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+54h], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+40h]
                mov     ebp, [esp+44h]
                sub     edi, ecx
                mov     eax, [esp+50h]
                sbb     ebp, edx
                mov     ebx, [esp+54h]
                mov     [esp+40h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+44h], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+48h]
                mov     ebx, [esp+4Ch]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Dh
                mov     ebp, ebx
                shl     ebx, 3
                mov     edi, eax
                shl     eax, 3
                or      ebx, ecx
                add     eax, edi
                adc     ebx, ebp
                mov     [esp+48h], eax
                mov     [esp+4Ch], ebx
                mov     eax, [esp+30h]
                mov     ebx, [esp+34h]
                mov     ecx, [esp+40h]
                mov     edx, [esp+44h]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+40h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+44h], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+48h]
                mov     ebp, [esp+4Ch]
                sub     edi, ecx
                mov     eax, [esp+40h]
                sbb     ebp, edx
                mov     ebx, [esp+44h]
                mov     [esp+48h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+4Ch], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+50h]
                mov     ebx, [esp+54h]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Dh
                mov     ebp, ebx
                shl     ebx, 3
                mov     edi, eax
                shl     eax, 3
                or      ebx, ecx
                add     eax, edi
                adc     ebx, ebp
                mov     [esp+50h], eax
                mov     [esp+54h], ebx
                mov     eax, [esp+38h]
                mov     ebx, [esp+3Ch]
                mov     ecx, [esp+48h]
                mov     edx, [esp+4Ch]
                xor     eax, ecx
                xor     ebx, edx
                mov     edi, eax
                mov     [esp+48h], eax
                shr     eax, 0Dh
                mov     ebp, ebx
                and     edi, 0FFh
                mov     [esp+4Ch], ebx
                shl     edi, 3
                and     ebp, 0FFh
                shr     ebx, 0Dh
                and     eax, 7F8h
                shl     ebp, 3
                mov     ecx, [esi+edi]
                mov     edx, [esi+edi+4]
                xor     ecx, [esi+eax+800h]
                xor     edx, [esi+eax+804h]
                and     ebx, 7F8h
                xor     ecx, [esi+ebp+1000h]
                xor     edx, [esi+ebp+1004h]
                xor     ecx, [esi+ebx+1800h]
                xor     edx, [esi+ebx+1804h]
                mov     edi, [esp+50h]
                mov     ebp, [esp+54h]
                sub     edi, ecx
                mov     eax, [esp+48h]
                sbb     ebp, edx
                mov     ebx, [esp+4Ch]
                mov     [esp+50h], edi
                mov     edi, eax
                shr     eax, 5
                mov     [esp+54h], ebp
                shr     edi, 15h
                mov     ebp, ebx
                shr     ebx, 5
                and     eax, 7F8h
                shr     ebp, 15h
                and     edi, 7F8h
                and     ebx, 7F8h
                mov     ecx, [esi+eax+1800h]
                mov     edx, [esi+eax+1804h]
                xor     ecx, [esi+edi+1000h]
                and     ebp, 7F8h
                xor     edx, [esi+edi+1004h]
                xor     ecx, [esi+ebx+800h]
                xor     edx, [esi+ebx+804h]
                xor     ecx, [esi+ebp]
                xor     edx, [esi+ebp+4]
                mov     eax, [esp+40h]
                mov     ebx, [esp+44h]
                add     eax, ecx
                adc     ebx, edx
                mov     ecx, eax
                shr     ecx, 1Dh
                mov     ebp, ebx
                shl     ebx, 3
                mov     edi, eax
                shl     eax, 3
                or      ebx, ecx
                add     eax, edi
                adc     ebx, ebp
                mov     [esp+40h], eax
                mov     [esp+44h], ebx
                mov     esi, [esp+60h]
                test    esi, esi
                jnz     @_yet_more_cycles 
                jmp     @_pass_loop_end

@_yet_more_cycles:

                dec     esi
                mov     [esp+60h], esi
                mov     eax, [esp+38h]
                mov     ebx, [esp+3Ch]
                xor     eax, 0A5A5A5A5h
                xor     ebx, 0A5A5A5A5h
                mov     ecx, [esp]
                mov     edx, [esp+4]
                sub     ecx, eax
                sbb     edx, ebx
                mov     [esp], ecx
                mov     [esp+4], edx
                mov     eax, [esp+8]
                mov     ebx, [esp+0Ch]
                xor     eax, ecx
                xor     ebx, edx
                mov     [esp+8], eax
                mov     edi, eax
                mov     esi, eax
                shr     edi, 0Dh
                xor     eax, 0FFFFFFFFh
                mov     [esp+0Ch], ebx
                mov     ecx, [esp+10h]
                shl     eax, 13h
                mov     ebp, ebx
                shl     ebx, 13h
                mov     edx, [esp+14h]
                add     esi, ecx
                mov     ecx, [esp+20h]
                adc     ebp, edx
                or      edi, ebx
                mov     [esp+10h], esi
                xor     esi, eax
                mov     [esp+14h], ebp
                mov     eax, [esp+18h]
                xor     ebp, 0FFFFFFFFh
                mov     ebx, [esp+1Ch]
                xor     ebp, edi
                sub     eax, esi
                sbb     ebx, ebp
                mov     edx, [esp+24h]
                mov     [esp+18h], eax
                xor     eax, ecx
                mov     [esp+1Ch], ebx
                xor     ebx, edx
                mov     ecx, [esp+28h]
                mov     edx, [esp+2Ch]
                mov     edi, ebx
                mov     ebp, ebx
                mov     [esp+20h], eax
                xor     ebp, 0FFFFFFFFh
                shl     ebx, 9
                add     ecx, eax
                adc     edx, edi
                mov     [esp+24h], edi
                shr     ebp, 17h
                mov     [esp+28h], ecx
                shr     eax, 17h
                xor     ecx, 0FFFFFFFFh
                or      ebx, eax
                mov     [esp+2Ch], edx
                mov     eax, [esp+30h]
                xor     ecx, ebx
                mov     ebx, [esp+34h]
                xor     edx, ebp
                mov     edi, [esp+38h]
                sub     eax, ecx
                mov     ebp, [esp+3Ch]
                mov     [esp+30h], eax
                sbb     ebx, edx
                xor     edi, eax
                xor     ebp, ebx
                mov     [esp+34h], ebx
                mov     eax, [esp]
                mov     ecx, edi
                xor     edi, 0FFFFFFFFh
                mov     ebx, [esp+4]
                shl     edi, 13h
                mov     [esp+38h], ecx
                add     eax, ecx
                mov     [esp+3Ch], ebp
                adc     ebx, ebp
                xor     edi, eax
                shr     ecx, 0Dh
                mov     [esp], eax
                shl     ebp, 13h
                mov     [esp+4], ebx
                mov     esi, [esp+8]
                xor     ebx, 0FFFFFFFFh
                or      ebp, ecx
                mov     edx, [esp+0Ch]
                xor     ebp, ebx
                sub     esi, edi
                mov     eax, [esp+10h]
                mov     ebx, [esp+14h]
                sbb     edx, ebp
                mov     [esp+8], esi
                xor     eax, esi
                mov     [esp+0Ch], edx
                mov     edi, [esp+18h]
                mov     ebp, [esp+1Ch]
                xor     ebx, edx
                mov     [esp+10h], eax
                add     edi, eax
                mov     esi, ebx
                adc     ebp, ebx
                mov     [esp+14h], ebx
                shr     eax, 17h
                mov     ecx, [esp+20h]
                xor     ebx, 0FFFFFFFFh
                mov     edx, [esp+24h]
                shl     esi, 9
                mov     [esp+18h], edi
                or      eax, esi
                xor     edi, 0FFFFFFFFh
                shr     ebx, 17h
                mov     [esp+1Ch], ebp
                xor     eax, edi
                mov     edi, [esp+28h]
                xor     ebx, ebp
                sub     ecx, eax
                mov     ebp, [esp+2Ch]
                mov     [esp+20h], ecx
                sbb     edx, ebx
                xor     edi, ecx
                mov     [esp+24h], edx
                xor     ebp, edx
                mov     eax, [esp+30h]
                mov     ebx, [esp+34h]
                mov     [esp+28h], edi
                add     eax, edi
                mov     [esp+2Ch], ebp
                mov     ecx, [esp+38h]
                adc     ebx, ebp
                mov     edx, [esp+3Ch]
                mov     [esp+30h], eax
                xor     eax, 89ABCDEFh
                mov     [esp+34h], ebx
                xor     ebx, 1234567h
                sub     ecx, eax
                sbb     edx, ebx
                mov     [esp+38h], ecx
                mov     [esp+3Ch], edx
                mov     eax, [esp+40h]
                mov     ebx, [esp+44h]
                mov     ecx, [esp+48h]
                mov     edx, [esp+4Ch]
                mov     [esp+48h], eax
                mov     [esp+4Ch], ebx
                mov     edi, [esp+50h]
                mov     ebp, [esp+54h]
                mov     [esp+50h], ecx
                mov     [esp+54h], edx
                mov     [esp+40h], edi
                mov     [esp+44h], ebp
                jmp     @_pass_loop

@_pass_loop_end:
                mov     esi, [esp+5Ch]
                mov     eax, [esp+40h]
                mov     ebx, [esp+44h]
                mov     edi, [esp+48h]
                mov     ebp, [esp+4Ch]
                mov     ecx, [esi]
                mov     edx, [esi+4]
                xor     eax, ecx
                xor     ebx, edx
                mov     [esi], eax
                mov     ecx, [esi+8]
                mov     edx, [esi+0Ch]
                mov     [esi+4], ebx
                sub     edi, ecx
                mov     ecx, [esi+10h]
                mov     [esi+8], edi
                sbb     ebp, edx
                mov     edx, [esi+14h]
                mov     [esi+0Ch], ebp
                mov     eax, [esp+50h]
                mov     ebx, [esp+54h]
                add     ecx, eax
                adc     edx, ebx
                mov     [esi+10h], ecx
                mov     [esi+14h], edx
                mov     ebp, [esp+68h]
                mov     esp, ebp
                pop     ebp
                pop     edi
                pop     esi
                pop     ebx
end;
{$ENDIF}

{$IFDEF THash_Panama_asm}
procedure THash_Panama.DoPull;
asm
                push    ebx
                push    esi
                lea     edx, [eax].THash_Panama.FTap
                push    edi
                lea     edi, [eax].THash_Panama.FDigest
                push    ebp
                lea     eax, [eax].THash_Panama.FLFSRBuffer
                mov     ebp, esp
                add     esp, 0FFFFFF5Ch
                and     esp, 0FFFFFFE0h
                mov     [esp+88h], edi
                mov     [esp+8Ch], edx
                mov     ecx, 20h
                mov     [esp+90h], eax
                mov     [esp+0A0h], ebp
                mov     eax, [edi]
                mov     ebx, [edi+4]
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     ebp, [edi+8]
                mov     esi, [edi+0Ch]
                mov     [esp+8], ebp
                mov     [esp+0Ch], esi
                mov     eax, [edi+10h]
                mov     ebx, [edi+14h]
                mov     [esp+10h], eax
                mov     [esp+14h], ebx
                mov     ebp, [edi+18h]
                mov     esi, [edi+1Ch]
                mov     [esp+18h], ebp
                mov     [esp+1Ch], esi
                mov     eax, [edi+20h]
                mov     ebx, [edi+24h]
                mov     [esp+20h], eax
                mov     [esp+24h], ebx
                mov     ebp, [edi+28h]
                mov     esi, [edi+2Ch]
                mov     [esp+28h], ebp
                mov     [esp+2Ch], esi
                mov     eax, [edi+30h]
                mov     ebx, [edi+34h]
                mov     [esp+30h], eax
                mov     [esp+34h], ebx
                mov     ebp, [edi+38h]
                mov     esi, [edi+3Ch]
                mov     eax, [edi+40h]
                mov     [esp+38h], ebp
                mov     [esp+3Ch], esi
                mov     [esp+40h], eax
@@_loop_start:
                mov     esi, [esp+8Ch]
                dec     ecx
                mov     ebp, [esp+90h]
                mov     [esp+9Ch], ecx
                mov     edx, [esi]
                mov     eax, edx
                mov     ecx, edx
                add     edx, 10h
                dec     eax
                add     ecx, 4
                and     edx, 1Fh
                and     eax, 1Fh
                and     ecx, 1Fh
                shl     edx, 5
                mov     [esi], eax
                shl     ecx, 5
                mov     ebx, eax
                shl     eax, 5
                add     edx, ebp
                add     ebx, 19h
                add     eax, ebp
                and     ebx, 1Fh
                add     ecx, ebp
                shl     ebx, 5
                mov     [esp+98h], edx
                add     ebx, ebp
                mov     [esp+94h], ecx
                mov     ecx, [ebx]
                mov     edx, [eax+8]
                mov     edi, [ebx+4]
                mov     ebp, [eax+0Ch]
                xor     ecx, edx
                xor     edi, ebp
                mov     [ebx], ecx
                mov     [ebx+4], edi
                mov     ecx, [ebx+8]
                mov     edx, [eax+10h]
                mov     edi, [ebx+0Ch]
                mov     ebp, [eax+14h]
                xor     ecx, edx
                xor     edi, ebp
                mov     [ebx+8], ecx
                mov     [ebx+0Ch], edi
                mov     ecx, [ebx+10h]
                mov     edx, [eax+18h]
                mov     edi, [ebx+14h]
                mov     ebp, [eax+1Ch]
                xor     ecx, edx
                xor     edi, ebp
                mov     [ebx+10h], ecx
                mov     [ebx+14h], edi
                mov     ecx, [ebx+18h]
                mov     edx, [eax]
                mov     edi, [ebx+1Ch]
                mov     ebp, [eax+4]
                xor     ecx, edx
                xor     edi, ebp
                mov     [ebx+18h], ecx
                mov     [ebx+1Ch], edi
                mov     ecx, [eax]
                mov     edx, [esp+4]
                mov     edi, [eax+4]
                mov     ebp, [esp+8]
                xor     ecx, edx
                xor     edi, ebp
                mov     [eax], ecx
                mov     [eax+4], edi
                mov     ecx, [eax+8]
                mov     edx, [esp+0Ch]
                mov     edi, [eax+0Ch]
                mov     ebp, [esp+10h]
                xor     ecx, edx
                xor     edi, ebp
                mov     [eax+8], ecx
                mov     [eax+0Ch], edi
                mov     ecx, [eax+10h]
                mov     edx, [esp+14h]
                mov     edi, [eax+14h]
                mov     ebp, [esp+18h]
                xor     ecx, edx
                xor     edi, ebp
                mov     [eax+10h], ecx
                mov     [eax+14h], edi
                mov     ecx, [eax+18h]
                mov     edx, [esp+1Ch]
                mov     edi, [eax+1Ch]
                mov     ebp, [esp+20h]
                xor     ecx, edx
                xor     edi, ebp
                mov     [eax+18h], ecx
                mov     [eax+1Ch], edi
                mov     eax, [esp]
                mov     ebx, [esp+4]
                mov     ecx, [esp+8]
                mov     esi, ecx
                xor     ecx, 0FFFFFFFFh
                mov     ebp, ebx
                or      ecx, ebx
                xor     ecx, eax
                mov     [esp+44h], ecx
                mov     ecx, [esp+0Ch]
                mov     edx, [esp+10h]
                mov     eax, ecx
                xor     ecx, 0FFFFFFFFh
                mov     ebx, edx
                xor     edx, 0FFFFFFFFh
                or      ecx, esi
                or      edx, eax
                xor     ebp, ecx
                mov     ecx, [esp+14h]
                rol     ebp, 0Fh
                xor     esi, edx
                mov     edx, [esp+18h]
                ror     esi, 9
                mov     [esp+58h], ebp
                mov     ebp, ecx
                xor     ecx, 0FFFFFFFFh
                mov     [esp+6Ch], esi
                mov     esi, edx
                xor     edx, 0FFFFFFFFh
                or      ecx, ebx
                or      edx, ebp
                xor     eax, ecx
                mov     ecx, [esp+1Ch]
                ror     eax, 8
                xor     ebx, edx
                mov     edx, [esp+20h]
                rol     ebx, 6
                mov     [esp+80h], eax
                mov     eax, ecx
                xor     ecx, 0FFFFFFFFh
                mov     [esp+50h], ebx
                mov     ebx, edx
                xor     edx, 0FFFFFFFFh
                or      ecx, esi
                or      edx, eax
                xor     ebp, ecx
                mov     ecx, [esp+24h]
                rol     ebp, 4
                xor     esi, edx
                mov     edx, [esp+28h]
                ror     esi, 5
                mov     [esp+64h], ebp
                mov     ebp, ecx
                xor     ecx, 0FFFFFFFFh
                mov     [esp+78h], esi
                mov     esi, edx
                xor     edx, 0FFFFFFFFh
                or      ecx, ebx
                or      edx, ebp
                xor     eax, ecx
                mov     ecx, [esp+2Ch]
                rol     eax, 1
                xor     ebx, edx
                mov     edx, [esp+30h]
                ror     ebx, 0Bh
                mov     [esp+48h], eax
                mov     eax, ecx
                xor     ecx, 0FFFFFFFFh
                mov     [esp+5Ch], ebx
                mov     ebx, edx
                xor     edx, 0FFFFFFFFh
                or      ecx, esi
                or      edx, eax
                xor     ebp, ecx
                mov     ecx, [esp+34h]
                rol     ebp, 2
                xor     esi, edx
                mov     edx, [esp+38h]
                rol     esi, 8
                mov     [esp+70h], ebp
                mov     ebp, ecx
                xor     ecx, 0FFFFFFFFh
                mov     [esp+84h], esi
                mov     esi, edx
                xor     edx, 0FFFFFFFFh
                or      ecx, ebx
                or      edx, ebp
                xor     eax, ecx
                mov     ecx, [esp+3Ch]
                rol     eax, 0Ah
                xor     ebx, edx
                mov     edx, [esp+40h]
                rol     ebx, 0Dh
                mov     [esp+54h], eax
                mov     eax, ecx
                xor     ecx, 0FFFFFFFFh
                mov     [esp+68h], ebx
                mov     ebx, edx
                xor     edx, 0FFFFFFFFh
                or      ecx, esi
                or      edx, eax
                xor     ebp, ecx
                mov     ecx, [esp]
                rol     ebp, 9
                xor     esi, edx
                mov     edx, [esp+4]
                rol     esi, 3
                mov     [esp+7Ch], ebp
                mov     ebp, ecx
                xor     ecx, 0FFFFFFFFh
                mov     [esp+4Ch], esi
                mov     esi, edx
                xor     edx, 0FFFFFFFFh
                or      ecx, ebx
                or      edx, ebp
                xor     eax, ecx
                xor     ebx, edx
                ror     eax, 4
                rol     ebx, 0Eh
                mov     [esp+60h], eax
                mov     [esp+74h], ebx
                mov     eax, [esp+44h]
                mov     ebx, [esp+48h]
                mov     ecx, [esp+4Ch]
                xor     eax, 1
                mov     edx, [esp+50h]
                xor     eax, ebx
                mov     ebp, [esp+54h]
                xor     eax, ebp
                mov     esi, [esp+94h]
                mov     [esp], eax
                xor     ebx, ecx
                mov     eax, [esp+58h]
                xor     ecx, edx
                mov     edi, [esp+5Ch]
                xor     ebx, eax
                xor     ecx, edi
                xor     ebx, [esi]
                xor     ecx, [esi+4]
                mov     [esp+4], ebx
                mov     [esp+8], ecx
                xor     edx, ebp
                mov     ecx, [esp+60h]
                xor     ebp, eax
                mov     ebx, [esp+64h]
                xor     edx, ecx
                xor     ebp, ebx
                xor     edx, [esi+8]
                xor     ebp, [esi+0Ch]
                mov     [esp+0Ch], edx
                mov     [esp+10h], ebp
                xor     eax, edi
                mov     edx, [esp+68h]
                xor     edi, ecx
                mov     ebp, [esp+6Ch]
                xor     eax, edx
                xor     edi, ebp
                xor     eax, [esi+10h]
                xor     edi, [esi+14h]
                mov     [esp+14h], eax
                mov     [esp+18h], edi
                xor     ecx, ebx
                mov     eax, [esp+70h]
                xor     ebx, edx
                mov     edi, [esp+74h]
                xor     ecx, eax
                xor     ebx, edi
                xor     ecx, [esi+18h]
                xor     ebx, [esi+1Ch]
                mov     [esp+1Ch], ecx
                mov     [esp+20h], ebx
                mov     esi, [esp+98h]
                xor     edx, ebp
                mov     ecx, [esp+78h]
                xor     ebp, eax
                mov     ebx, [esp+7Ch]
                xor     edx, ecx
                xor     ebp, ebx
                xor     edx, [esi]
                xor     ebp, [esi+4]
                mov     [esp+24h], edx
                mov     [esp+28h], ebp
                xor     eax, edi
                mov     edx, [esp+80h]
                xor     edi, ecx
                mov     ebp, [esp+84h]
                xor     eax, edx
                xor     edi, ebp
                xor     eax, [esi+8]
                xor     edi, [esi+0Ch]
                mov     [esp+2Ch], eax
                mov     [esp+30h], edi
                xor     ecx, ebx
                mov     eax, [esp+44h]
                xor     ebx, edx
                mov     edi, [esp+48h]
                xor     ecx, eax
                xor     ebx, edi
                xor     ecx, [esi+10h]
                xor     ebx, [esi+14h]
                mov     [esp+34h], ecx
                mov     [esp+38h], ebx
                mov     ecx, [esp+4Ch]
                xor     edx, ebp
                mov     ebx, [esp+50h]
                xor     ebp, eax
                xor     edx, ecx
                xor     ebp, ebx
                xor     edx, [esi+18h]
                xor     ebp, [esi+1Ch]
                mov     [esp+3Ch], edx
                mov     [esp+40h], ebp
                mov     ecx, [esp+9Ch]
                test    ecx, ecx
                jnz     @@_loop_start
                mov     edi, [esp+88h]
                mov     ebp, [esp+0A0h]
                mov     eax, [esp+24h]
                mov     ebx, [esp+28h]
                mov     [edi], eax
                mov     [edi+4], ebx
                mov     ecx, [esp+2Ch]
                mov     edx, [esp+30h]
                mov     [edi+8], ecx
                mov     [edi+0Ch], edx
                mov     eax, [esp+34h]
                mov     ebx, [esp+38h]
                mov     [edi+10h], eax
                mov     [edi+14h], ebx
                mov     ecx, [esp+3Ch]
                mov     edx, [esp+40h]
                mov     esp, ebp
                mov     [edi+18h], ecx
                mov     [edi+1Ch], edx
                pop     ebp
                pop     edi
                pop     esi
                pop     ebx
end;

procedure THash_Panama.DoTransform(Buffer: PLongArray); assembler;
asm
                push    ebx
                push    esi
                mov     esi, edx
                push    edi
                lea     edi, [eax].THash_Panama.FDigest
                lea     edx, [eax].THash_Panama.FTap
                push    ebp
                lea     eax, [eax].THash_Panama.FLFSRBuffer

                mov     ebp, esp
                add     esp, 0FFFFFF5Ch
                and     esp, 0FFFFFFE0h
                mov     [esp+88h], edi
                mov     [esp+8Ch], esi
                mov     [esp+90h], edx
                mov     [esp+94h], eax
                mov     [esp+0A0h], ebp
                mov     eax, [edi]
                mov     ebx, [edi+4]
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     ebp, [edi+8]
                mov     esi, [edi+0Ch]
                mov     [esp+8], ebp
                mov     [esp+0Ch], esi
                mov     eax, [edi+10h]
                mov     ebx, [edi+14h]
                mov     [esp+10h], eax
                mov     [esp+14h], ebx
                mov     ebp, [edi+18h]
                mov     esi, [edi+1Ch]
                mov     [esp+18h], ebp
                mov     [esp+1Ch], esi
                mov     eax, [edi+20h]
                mov     ebx, [edi+24h]
                mov     [esp+20h], eax
                mov     [esp+24h], ebx
                mov     ebp, [edi+28h]
                mov     esi, [edi+2Ch]
                mov     [esp+28h], ebp
                mov     [esp+2Ch], esi
                mov     eax, [edi+30h]
                mov     ebx, [edi+34h]
                mov     [esp+30h], eax
                mov     [esp+34h], ebx
                mov     ebp, [edi+38h]
                mov     esi, [edi+3Ch]
                mov     eax, [edi+40h]
                mov     [esp+38h], ebp
                mov     [esp+3Ch], esi
                mov     [esp+40h], eax

                mov     eax, [esp]
                mov     ebx, [esp+4]
                mov     ecx, [esp+8]
                mov     esi, ecx
                xor     ecx, 0FFFFFFFFh
                mov     ebp, ebx
                or      ecx, ebx
                xor     ecx, eax
                mov     [esp+44h], ecx
                mov     ecx, [esp+0Ch]
                mov     edx, [esp+10h]
                mov     eax, ecx
                xor     ecx, 0FFFFFFFFh
                mov     ebx, edx
                xor     edx, 0FFFFFFFFh
                or      ecx, esi
                or      edx, eax
                xor     ebp, ecx
                mov     ecx, [esp+14h]
                rol     ebp, 0Fh
                xor     esi, edx
                mov     edx, [esp+18h]
                ror     esi, 9
                mov     [esp+58h], ebp
                mov     ebp, ecx
                xor     ecx, 0FFFFFFFFh
                mov     [esp+6Ch], esi
                mov     esi, edx
                xor     edx, 0FFFFFFFFh
                or      ecx, ebx
                or      edx, ebp
                xor     eax, ecx
                mov     ecx, [esp+1Ch]
                ror     eax, 8
                xor     ebx, edx
                mov     edx, [esp+20h]
                rol     ebx, 6
                mov     [esp+80h], eax
                mov     eax, ecx
                xor     ecx, 0FFFFFFFFh
                mov     [esp+50h], ebx
                mov     ebx, edx
                xor     edx, 0FFFFFFFFh
                or      ecx, esi
                or      edx, eax
                xor     ebp, ecx
                mov     ecx, [esp+24h]
                rol     ebp, 4
                xor     esi, edx
                mov     edx, [esp+28h]
                ror     esi, 5
                mov     [esp+64h], ebp
                mov     ebp, ecx
                xor     ecx, 0FFFFFFFFh
                mov     [esp+78h], esi
                mov     esi, edx
                xor     edx, 0FFFFFFFFh
                or      ecx, ebx
                or      edx, ebp
                xor     eax, ecx
                mov     ecx, [esp+2Ch]
                rol     eax, 1
                xor     ebx, edx
                mov     edx, [esp+30h]
                ror     ebx, 0Bh
                mov     [esp+48h], eax
                mov     eax, ecx
                xor     ecx, 0FFFFFFFFh
                mov     [esp+5Ch], ebx
                mov     ebx, edx
                xor     edx, 0FFFFFFFFh
                or      ecx, esi
                or      edx, eax
                xor     ebp, ecx
                mov     ecx, [esp+34h]
                rol     ebp, 2
                xor     esi, edx
                mov     edx, [esp+38h]
                rol     esi, 8
                mov     [esp+70h], ebp
                mov     ebp, ecx
                xor     ecx, 0FFFFFFFFh
                mov     [esp+84h], esi
                mov     esi, edx
                xor     edx, 0FFFFFFFFh
                or      ecx, ebx
                or      edx, ebp
                xor     eax, ecx
                mov     ecx, [esp+3Ch]
                rol     eax, 0Ah
                xor     ebx, edx
                mov     edx, [esp+40h]
                rol     ebx, 0Dh
                mov     [esp+54h], eax
                mov     eax, ecx
                xor     ecx, 0FFFFFFFFh
                mov     [esp+68h], ebx
                mov     ebx, edx
                xor     edx, 0FFFFFFFFh
                or      ecx, esi
                or      edx, eax
                xor     ebp, ecx
                mov     ecx, [esp]
                rol     ebp, 9
                xor     esi, edx
                mov     edx, [esp+4]
                rol     esi, 3
                mov     [esp+7Ch], ebp
                mov     ebp, ecx
                xor     ecx, 0FFFFFFFFh
                mov     [esp+4Ch], esi
                mov     esi, edx
                xor     edx, 0FFFFFFFFh
                or      ecx, ebx
                or      edx, ebp
                xor     eax, ecx
                xor     ebx, edx
                ror     eax, 4
                rol     ebx, 0Eh
                mov     [esp+60h], eax
                mov     [esp+74h], ebx
                mov     esi, [esp+90h]
                mov     ebp, [esp+94h]
                mov     edx, [esi]
                mov     eax, edx
                add     edx, 10h
                dec     eax
                and     edx, 1Fh
                and     eax, 1Fh
                shl     edx, 5
                mov     [esi], eax
                add     edx, ebp
                mov     ebx, eax
                shl     eax, 5
                add     ebx, 19h
                add     eax, ebp
                and     ebx, 1Fh
                shl     ebx, 5
                mov     [esp+98h], edx
                add     ebx, ebp
                mov     ecx, [ebx]
                mov     edx, [eax+8]
                mov     edi, [ebx+4]
                mov     ebp, [eax+0Ch]
                xor     ecx, edx
                xor     edi, ebp
                mov     [ebx], ecx
                mov     [ebx+4], edi
                mov     ecx, [ebx+8]
                mov     edx, [eax+10h]
                mov     edi, [ebx+0Ch]
                mov     ebp, [eax+14h]
                xor     ecx, edx
                xor     edi, ebp
                mov     [ebx+8], ecx
                mov     [ebx+0Ch], edi
                mov     ecx, [ebx+10h]
                mov     edx, [eax+18h]
                mov     edi, [ebx+14h]
                mov     ebp, [eax+1Ch]
                xor     ecx, edx
                xor     edi, ebp
                mov     [ebx+10h], ecx
                mov     [ebx+14h], edi
                mov     ecx, [ebx+18h]
                mov     edx, [eax]
                mov     edi, [ebx+1Ch]
                mov     ebp, [eax+4]
                xor     ecx, edx
                xor     edi, ebp
                mov     [ebx+18h], ecx
                mov     [ebx+1Ch], edi
                mov     ebx, [esp+8Ch]
                mov     ecx, [eax]
                mov     edx, [ebx]
                mov     edi, [eax+4]
                mov     ebp, [ebx+4]
                xor     ecx, edx
                xor     edi, ebp
                mov     [eax], ecx
                mov     [eax+4], edi
                mov     ecx, [eax+8]
                mov     edx, [ebx+8]
                mov     edi, [eax+0Ch]
                mov     ebp, [ebx+0Ch]
                xor     ecx, edx
                xor     edi, ebp
                mov     [eax+8], ecx
                mov     [eax+0Ch], edi
                mov     ecx, [eax+10h]
                mov     edx, [ebx+10h]
                mov     edi, [eax+14h]
                mov     ebp, [ebx+14h]
                xor     ecx, edx
                xor     edi, ebp
                mov     [eax+10h], ecx
                mov     [eax+14h], edi
                mov     ecx, [eax+18h]
                mov     edx, [ebx+18h]
                mov     edi, [eax+1Ch]
                mov     ebp, [ebx+1Ch]
                xor     ecx, edx
                xor     edi, ebp
                mov     [eax+18h], ecx
                mov     [eax+1Ch], edi
                mov     eax, [esp+44h]
                mov     ebx, [esp+48h]
                mov     ecx, [esp+4Ch]
                xor     eax, 1
                mov     edx, [esp+50h]
                xor     eax, ebx
                mov     ebp, [esp+54h]
                xor     eax, ebp
                mov     esi, [esp+8Ch]
                mov     [esp], eax
                xor     ebx, ecx
                mov     eax, [esp+58h]
                xor     ecx, edx
                mov     edi, [esp+5Ch]
                xor     ebx, eax
                xor     ecx, edi
                xor     ebx, [esi]
                xor     ecx, [esi+4]
                mov     [esp+4], ebx
                mov     [esp+8], ecx
                xor     edx, ebp
                mov     ecx, [esp+60h]
                xor     ebp, eax
                mov     ebx, [esp+64h]
                xor     edx, ecx
                xor     ebp, ebx
                xor     edx, [esi+8]
                xor     ebp, [esi+0Ch]
                mov     [esp+0Ch], edx
                mov     [esp+10h], ebp
                xor     eax, edi
                mov     edx, [esp+68h]
                xor     edi, ecx
                mov     ebp, [esp+6Ch]
                xor     eax, edx
                xor     edi, ebp
                xor     eax, [esi+10h]
                xor     edi, [esi+14h]
                mov     [esp+14h], eax
                mov     [esp+18h], edi
                xor     ecx, ebx
                mov     eax, [esp+70h]
                xor     ebx, edx
                mov     edi, [esp+74h]
                xor     ecx, eax
                xor     ebx, edi
                xor     ecx, [esi+18h]
                xor     ebx, [esi+1Ch]
                add     esi, 20h 
                mov     [esp+1Ch], ecx
                mov     [esp+20h], ebx
                mov     [esp+8Ch], esi
                mov     esi, [esp+98h]
                xor     edx, ebp
                mov     ecx, [esp+78h]
                xor     ebp, eax
                mov     ebx, [esp+7Ch]
                xor     edx, ecx
                xor     ebp, ebx
                xor     edx, [esi]
                xor     ebp, [esi+4]
                mov     [esp+24h], edx
                mov     [esp+28h], ebp
                xor     eax, edi
                mov     edx, [esp+80h]
                xor     edi, ecx
                mov     ebp, [esp+84h]
                xor     eax, edx
                xor     edi, ebp
                xor     eax, [esi+8]
                xor     edi, [esi+0Ch]
                mov     [esp+2Ch], eax
                mov     [esp+30h], edi
                xor     ecx, ebx
                mov     eax, [esp+44h]
                xor     ebx, edx
                mov     edi, [esp+48h]
                xor     ecx, eax
                xor     ebx, edi
                xor     ecx, [esi+10h]
                xor     ebx, [esi+14h]
                mov     [esp+34h], ecx
                mov     [esp+38h], ebx
                mov     ecx, [esp+4Ch]
                xor     edx, ebp
                mov     ebx, [esp+50h]
                xor     ebp, eax
                xor     edx, ecx
                xor     ebp, ebx
                xor     edx, [esi+18h]
                xor     ebp, [esi+1Ch]
                mov     [esp+3Ch], edx
                mov     [esp+40h], ebp

                mov     edi, [esp+88h]
                mov     eax, [esp]
                mov     ebx, [esp+4]
                mov     [edi], eax
                mov     [edi+4], ebx
                mov     ebp, [esp+8]
                mov     esi, [esp+0Ch]
                mov     [edi+8], ebp
                mov     [edi+0Ch], esi
                mov     eax, [esp+10h]
                mov     ebx, [esp+14h]
                mov     [edi+10h], eax
                mov     [edi+14h], ebx
                mov     ebp, [esp+18h]
                mov     esi, [esp+1Ch]
                mov     [edi+18h], ebp
                mov     [edi+1Ch], esi
                mov     eax, [esp+20h]
                mov     ebx, [esp+24h]
                mov     [edi+20h], eax
                mov     [edi+24h], ebx
                mov     ebp, [esp+28h]
                mov     esi, [esp+2Ch]
                mov     [edi+28h], ebp
                mov     [edi+2Ch], esi
                mov     eax, [esp+30h]
                mov     ebx, [esp+34h]
                mov     [edi+30h], eax
                mov     [edi+34h], ebx
                mov     ebp, [esp+38h]
                mov     esi, [esp+3Ch]
                mov     eax, [esp+40h]
                mov     [edi+38h], ebp
                mov     [edi+3Ch], esi
                mov     [edi+40h], eax
                mov     ebp, [esp+0A0h]
                mov     esp, ebp
                pop     ebp
                pop     edi
                pop     esi
                pop     ebx
end;
{$ENDIF}

{$IFDEF THashBaseWhirlpool_asm}
procedure THashBaseWhirlpool.DoTransform(Buffer: PLongArray); assembler;
asm
                push    ebx
                push    esi
                push    edi
                mov     esi, edx
                lea     edi, [eax].THashBaseWhirlpool.FDigest
                push    ebp
                mov     ebx, [eax].THashBaseWhirlpool.FTableC
                mov     eax, [eax].THashBaseWhirlpool.FTableR

                mov     ebp, esp
                add     esp, 0FFFFFEE8h
                and     esp, 0FFFFFFE0h
                mov     [esp+100h], eax
                mov     [esp+104h], ebx
                mov     [esp+10Ch], edi
                mov     [esp+110h], esi
                mov     [esp+114h], ebp
                xor     ebp, ebp
                mov     eax, [edi]
                mov     ebx, [edi+4]
                mov     [esp+40h], eax
                mov     ecx, [esi]
                mov     edx, [esi+4]
                mov     [esp+44h], ebx
                xor     eax, ecx
                xor     ebx, edx
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     eax, [edi+8]
                mov     ebx, [edi+0Ch]
                mov     [esp+48h], eax
                mov     ecx, [esi+8]
                mov     edx, [esi+0Ch]
                mov     [esp+4Ch], ebx
                xor     eax, ecx
                xor     ebx, edx
                mov     [esp+8], eax
                mov     [esp+0Ch], ebx
                mov     eax, [edi+10h]
                mov     ebx, [edi+14h]
                mov     [esp+50h], eax
                mov     ecx, [esi+10h]
                mov     edx, [esi+14h]
                mov     [esp+54h], ebx
                xor     eax, ecx
                xor     ebx, edx
                mov     [esp+10h], eax
                mov     [esp+14h], ebx
                mov     eax, [edi+18h]
                mov     ebx, [edi+1Ch]
                mov     [esp+58h], eax
                mov     ecx, [esi+18h]
                mov     edx, [esi+1Ch]
                mov     [esp+5Ch], ebx
                xor     eax, ecx
                xor     ebx, edx
                mov     [esp+18h], eax
                mov     [esp+1Ch], ebx
                mov     eax, [edi+20h]
                mov     ebx, [edi+24h]
                mov     [esp+60h], eax
                mov     ecx, [esi+20h]
                mov     edx, [esi+24h]
                mov     [esp+64h], ebx
                xor     eax, ecx
                xor     ebx, edx
                mov     [esp+20h], eax
                mov     [esp+24h], ebx
                mov     eax, [edi+28h]
                mov     ebx, [edi+2Ch]
                mov     [esp+68h], eax
                mov     ecx, [esi+28h]
                mov     edx, [esi+2Ch]
                mov     [esp+6Ch], ebx
                xor     eax, ecx
                xor     ebx, edx
                mov     [esp+28h], eax
                mov     [esp+2Ch], ebx
                mov     eax, [edi+30h]
                mov     ebx, [edi+34h]
                mov     [esp+70h], eax
                mov     ecx, [esi+30h]
                mov     edx, [esi+34h]
                mov     [esp+74h], ebx
                xor     eax, ecx
                xor     ebx, edx
                mov     [esp+30h], eax
                mov     [esp+34h], ebx
                mov     eax, [edi+38h]
                mov     ebx, [edi+3Ch]
                mov     [esp+78h], eax
                mov     ecx, [esi+38h]
                mov     edx, [esi+3Ch]
                mov     [esp+7Ch], ebx
                xor     eax, ecx
                xor     ebx, edx
                mov     [esp+38h], eax
                mov     [esp+3Ch], ebx

@@_loop_start:                          
                mov     [esp+108h], ebp
                mov     edi, [esp+100h]
                mov     esi, [esp+104h]
                mov     eax, [edi+ebp]
                mov     ebx, [edi+ebp+4]
                mov     ecx, [esp+40h]
                mov     edx, [esp+78h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+4]
                xor     eax, edi
                mov     ecx, [esp+70h]
                mov     edi, [esi+edx+800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+68h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     ecx, [esp+64h]
                mov     edx, [esp+5Ch]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+2004h]
                xor     eax, edi
                mov     ecx, [esp+54h]
                mov     edi, [esi+edx+2800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+2804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+4Ch]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+80h], eax
                mov     [esp+84h], ebx
                mov     ecx, [esp+48h]
                mov     edx, [esp+40h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     eax, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebx, [esi+ecx*8+4]
                mov     ecx, [esp+78h]
                mov     edi, [esi+edx+800h]
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                mov     edx, [esp+70h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                mov     ecx, [esp+6Ch]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                and     ecx, 0FFh
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                mov     edx, [esp+64h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                mov     ebp, [esi+ecx*8+2004h]
                and     edx, 7F8h
                mov     ecx, [esp+5Ch]
                xor     eax, edi
                shr     ecx, 0Dh
                xor     ebx, ebp
                mov     edi, [esi+edx+2800h]
                and     ecx, 7F8h
                mov     ebp, [esi+edx+2804h]
                xor     eax, edi
                mov     edx, [esp+54h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+88h], eax
                mov     [esp+8Ch], ebx
                mov     ecx, [esp+50h]
                mov     edx, [esp+48h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     eax, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebx, [esi+ecx*8+4]
                mov     ecx, [esp+40h]
                mov     edi, [esi+edx+800h]
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                mov     edx, [esp+78h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                mov     ecx, [esp+74h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                and     ecx, 0FFh
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                mov     edx, [esp+6Ch]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                mov     ebp, [esi+ecx*8+2004h]
                and     edx, 7F8h
                mov     ecx, [esp+64h]
                xor     eax, edi
                shr     ecx, 0Dh
                xor     ebx, ebp
                mov     edi, [esi+edx+2800h]
                and     ecx, 7F8h
                mov     ebp, [esi+edx+2804h]
                xor     eax, edi
                mov     edx, [esp+5Ch]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+90h], eax
                mov     [esp+94h], ebx
                mov     ecx, [esp+58h]
                mov     edx, [esp+50h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     eax, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebx, [esi+ecx*8+4]
                mov     ecx, [esp+48h]
                mov     edi, [esi+edx+800h]
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                mov     edx, [esp+40h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                mov     ecx, [esp+7Ch]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                and     ecx, 0FFh
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                mov     edx, [esp+74h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                mov     ebp, [esi+ecx*8+2004h]
                and     edx, 7F8h
                mov     ecx, [esp+6Ch]
                xor     eax, edi
                shr     ecx, 0Dh
                xor     ebx, ebp
                mov     edi, [esi+edx+2800h]
                and     ecx, 7F8h
                mov     ebp, [esi+edx+2804h]
                xor     eax, edi
                mov     edx, [esp+64h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+98h], eax
                mov     [esp+9Ch], ebx
                mov     ecx, [esp+60h]
                mov     edx, [esp+58h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     eax, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebx, [esi+ecx*8+4]
                mov     ecx, [esp+50h]
                mov     edi, [esi+edx+800h]
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                mov     edx, [esp+48h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                mov     ecx, [esp+44h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                and     ecx, 0FFh
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                mov     edx, [esp+7Ch]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                mov     ebp, [esi+ecx*8+2004h]
                and     edx, 7F8h
                mov     ecx, [esp+74h]
                xor     eax, edi
                shr     ecx, 0Dh
                xor     ebx, ebp
                mov     edi, [esi+edx+2800h]
                and     ecx, 7F8h
                mov     ebp, [esi+edx+2804h]
                xor     eax, edi
                mov     edx, [esp+6Ch]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+0A0h], eax
                mov     [esp+0A4h], ebx
                mov     ecx, [esp+68h]
                mov     edx, [esp+60h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     eax, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebx, [esi+ecx*8+4]
                mov     ecx, [esp+58h]
                mov     edi, [esi+edx+800h]
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                mov     edx, [esp+50h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                mov     ecx, [esp+4Ch]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                and     ecx, 0FFh
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                mov     edx, [esp+44h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                mov     ebp, [esi+ecx*8+2004h]
                and     edx, 7F8h
                mov     ecx, [esp+7Ch]
                xor     eax, edi
                shr     ecx, 0Dh
                xor     ebx, ebp
                mov     edi, [esi+edx+2800h]
                and     ecx, 7F8h
                mov     ebp, [esi+edx+2804h]
                xor     eax, edi
                mov     edx, [esp+74h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+0A8h], eax
                mov     [esp+0ACh], ebx
                mov     ecx, [esp+70h]
                mov     edx, [esp+68h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     eax, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebx, [esi+ecx*8+4]
                mov     ecx, [esp+60h]
                mov     edi, [esi+edx+800h]
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                mov     edx, [esp+58h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                mov     ecx, [esp+54h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                and     ecx, 0FFh
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                mov     edx, [esp+4Ch]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                mov     ebp, [esi+ecx*8+2004h]
                and     edx, 7F8h
                mov     ecx, [esp+44h]
                xor     eax, edi
                shr     ecx, 0Dh
                xor     ebx, ebp
                mov     edi, [esi+edx+2800h]
                and     ecx, 7F8h
                mov     ebp, [esi+edx+2804h]
                xor     eax, edi
                mov     edx, [esp+7Ch]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+0B0h], eax
                mov     [esp+0B4h], ebx
                mov     ecx, [esp+78h]
                mov     edx, [esp+70h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     eax, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebx, [esi+ecx*8+4]
                mov     ecx, [esp+68h]
                mov     edi, [esi+edx+800h]
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                mov     edx, [esp+60h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                mov     ecx, [esp+5Ch]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                and     ecx, 0FFh
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                mov     edx, [esp+54h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                mov     ebp, [esi+ecx*8+2004h]
                and     edx, 7F8h
                mov     ecx, [esp+4Ch]
                xor     eax, edi
                shr     ecx, 0Dh
                xor     ebx, ebp
                mov     edi, [esi+edx+2800h]
                and     ecx, 7F8h
                mov     ebp, [esi+edx+2804h]
                xor     eax, edi
                mov     edx, [esp+44h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+0B8h], eax
                mov     [esp+0BCh], ebx
                mov     eax, [esp+80h]
                mov     ebx, [esp+84h]
                mov     ecx, [esp]
                mov     edx, [esp+38h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+4]
                xor     eax, edi
                mov     ecx, [esp+30h]
                mov     edi, [esi+edx+800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+28h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     ecx, [esp+24h]
                mov     edx, [esp+1Ch]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+2004h]
                xor     eax, edi
                mov     ecx, [esp+14h]
                mov     edi, [esi+edx+2800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+2804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+0Ch]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+0C0h], eax
                mov     [esp+0C4h], ebx
                mov     eax, [esp+88h]
                mov     ebx, [esp+8Ch]
                mov     ecx, [esp+8]
                mov     edx, [esp]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+4]
                xor     eax, edi
                mov     ecx, [esp+38h]
                mov     edi, [esi+edx+800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+30h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     ecx, [esp+2Ch]
                mov     edx, [esp+24h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+2004h]
                xor     eax, edi
                mov     ecx, [esp+1Ch]
                mov     edi, [esi+edx+2800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+2804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+14h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+0C8h], eax
                mov     [esp+0CCh], ebx
                mov     eax, [esp+90h]
                mov     ebx, [esp+94h]
                mov     ecx, [esp+10h]
                mov     edx, [esp+8]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+4]
                xor     eax, edi
                mov     ecx, [esp]
                mov     edi, [esi+edx+800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+38h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     ecx, [esp+34h]
                mov     edx, [esp+2Ch]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+2004h]
                xor     eax, edi
                mov     ecx, [esp+24h]
                mov     edi, [esi+edx+2800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+2804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+1Ch]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+0D0h], eax
                mov     [esp+0D4h], ebx
                mov     eax, [esp+98h]
                mov     ebx, [esp+9Ch]
                mov     ecx, [esp+18h]
                mov     edx, [esp+10h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+4]
                xor     eax, edi
                mov     ecx, [esp+8]
                mov     edi, [esi+edx+800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     ecx, [esp+3Ch]
                mov     edx, [esp+34h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+2004h]
                xor     eax, edi
                mov     ecx, [esp+2Ch]
                mov     edi, [esi+edx+2800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+2804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+24h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+0D8h], eax
                mov     [esp+0DCh], ebx
                mov     eax, [esp+0A0h]
                mov     ebx, [esp+0A4h]
                mov     ecx, [esp+20h]
                mov     edx, [esp+18h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+4]
                xor     eax, edi
                mov     ecx, [esp+10h]
                mov     edi, [esi+edx+800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+8]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     ecx, [esp+4]
                mov     edx, [esp+3Ch]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+2004h]
                xor     eax, edi
                mov     ecx, [esp+34h]
                mov     edi, [esi+edx+2800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+2804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+2Ch]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+0E0h], eax
                mov     [esp+0E4h], ebx
                mov     eax, [esp+0A8h]
                mov     ebx, [esp+0ACh]
                mov     ecx, [esp+28h]
                mov     edx, [esp+20h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+4]
                xor     eax, edi
                mov     ecx, [esp+18h]
                mov     edi, [esi+edx+800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+10h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     ecx, [esp+0Ch]
                mov     edx, [esp+4]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+2004h]
                xor     eax, edi
                mov     ecx, [esp+3Ch]
                mov     edi, [esi+edx+2800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+2804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+34h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+0E8h], eax
                mov     [esp+0ECh], ebx
                mov     eax, [esp+0B0h]
                mov     ebx, [esp+0B4h]
                mov     ecx, [esp+30h]
                mov     edx, [esp+28h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+4]
                xor     eax, edi
                mov     ecx, [esp+20h]
                mov     edi, [esi+edx+800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+18h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     ecx, [esp+14h]
                mov     edx, [esp+0Ch]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+2004h]
                xor     eax, edi
                mov     ecx, [esp+4]
                mov     edi, [esi+edx+2800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+2804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+3Ch]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+0F0h], eax
                mov     [esp+0F4h], ebx
                mov     eax, [esp+0B8h]
                mov     ebx, [esp+0BCh]
                mov     ecx, [esp+38h]
                mov     edx, [esp+30h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+4]
                xor     eax, edi
                mov     ecx, [esp+28h]
                mov     edi, [esi+edx+800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+20h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     ecx, [esp+1Ch]
                mov     edx, [esp+14h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+2004h]
                xor     eax, edi
                mov     ecx, [esp+0Ch]
                mov     edi, [esi+edx+2800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+2804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+4]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+0F8h], eax
                mov     [esp+0FCh], ebx
                mov     ebp, [esp+108h]
                mov     edi, [esp+100h]
                mov     eax, [edi+ebp+8]
                mov     ebx, [edi+ebp+0Ch]
                mov     ecx, [esp+80h]
                mov     edx, [esp+0B8h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+4]
                xor     eax, edi
                mov     ecx, [esp+0B0h]
                mov     edi, [esi+edx+800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+0A8h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     ecx, [esp+0A4h]
                mov     edx, [esp+9Ch]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+2004h]
                xor     eax, edi
                mov     ecx, [esp+94h]
                mov     edi, [esi+edx+2800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+2804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+8Ch]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+40h], eax
                mov     [esp+44h], ebx
                mov     ecx, [esp+88h]
                mov     edx, [esp+80h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     eax, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebx, [esi+ecx*8+4]
                mov     ecx, [esp+0B8h]
                mov     edi, [esi+edx+800h]
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                mov     edx, [esp+0B0h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                mov     ecx, [esp+0ACh]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                and     ecx, 0FFh
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                mov     edx, [esp+0A4h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                mov     ebp, [esi+ecx*8+2004h]
                and     edx, 7F8h
                mov     ecx, [esp+9Ch]
                xor     eax, edi
                shr     ecx, 0Dh
                xor     ebx, ebp
                mov     edi, [esi+edx+2800h]
                and     ecx, 7F8h
                mov     ebp, [esi+edx+2804h]
                xor     eax, edi
                mov     edx, [esp+94h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+48h], eax
                mov     [esp+4Ch], ebx
                mov     ecx, [esp+90h]
                mov     edx, [esp+88h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     eax, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebx, [esi+ecx*8+4]
                mov     ecx, [esp+80h]
                mov     edi, [esi+edx+800h]
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                mov     edx, [esp+0B8h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                mov     ecx, [esp+0B4h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                and     ecx, 0FFh
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                mov     edx, [esp+0ACh]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                mov     ebp, [esi+ecx*8+2004h]
                and     edx, 7F8h
                mov     ecx, [esp+0A4h]
                xor     eax, edi
                shr     ecx, 0Dh
                xor     ebx, ebp
                mov     edi, [esi+edx+2800h]
                and     ecx, 7F8h
                mov     ebp, [esi+edx+2804h]
                xor     eax, edi
                mov     edx, [esp+9Ch]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+50h], eax
                mov     [esp+54h], ebx
                mov     ecx, [esp+98h]
                mov     edx, [esp+90h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     eax, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebx, [esi+ecx*8+4]
                mov     ecx, [esp+88h]
                mov     edi, [esi+edx+800h]
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                mov     edx, [esp+80h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                mov     ecx, [esp+0BCh]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                and     ecx, 0FFh
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                mov     edx, [esp+0B4h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                mov     ebp, [esi+ecx*8+2004h]
                and     edx, 7F8h
                mov     ecx, [esp+0ACh]
                xor     eax, edi
                shr     ecx, 0Dh
                xor     ebx, ebp
                mov     edi, [esi+edx+2800h]
                and     ecx, 7F8h
                mov     ebp, [esi+edx+2804h]
                xor     eax, edi
                mov     edx, [esp+0A4h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+58h], eax
                mov     [esp+5Ch], ebx
                mov     ecx, [esp+0A0h]
                mov     edx, [esp+98h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     eax, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebx, [esi+ecx*8+4]
                mov     ecx, [esp+90h]
                mov     edi, [esi+edx+800h]
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                mov     edx, [esp+88h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                mov     ecx, [esp+84h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                and     ecx, 0FFh
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                mov     edx, [esp+0BCh]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                mov     ebp, [esi+ecx*8+2004h]
                and     edx, 7F8h
                mov     ecx, [esp+0B4h]
                xor     eax, edi
                shr     ecx, 0Dh
                xor     ebx, ebp
                mov     edi, [esi+edx+2800h]
                and     ecx, 7F8h
                mov     ebp, [esi+edx+2804h]
                xor     eax, edi
                mov     edx, [esp+0ACh]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+60h], eax
                mov     [esp+64h], ebx
                mov     ecx, [esp+0A8h]
                mov     edx, [esp+0A0h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     eax, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebx, [esi+ecx*8+4]
                mov     ecx, [esp+98h]
                mov     edi, [esi+edx+800h]
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                mov     edx, [esp+90h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                mov     ecx, [esp+8Ch]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                and     ecx, 0FFh
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                mov     edx, [esp+84h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                mov     ebp, [esi+ecx*8+2004h]
                and     edx, 7F8h
                mov     ecx, [esp+0BCh]
                xor     eax, edi
                shr     ecx, 0Dh
                xor     ebx, ebp
                mov     edi, [esi+edx+2800h]
                and     ecx, 7F8h
                mov     ebp, [esi+edx+2804h]
                xor     eax, edi
                mov     edx, [esp+0B4h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+68h], eax
                mov     [esp+6Ch], ebx
                mov     ecx, [esp+0B0h]
                mov     edx, [esp+0A8h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     eax, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebx, [esi+ecx*8+4]
                mov     ecx, [esp+0A0h]
                mov     edi, [esi+edx+800h]
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                mov     edx, [esp+98h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                mov     ecx, [esp+94h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                and     ecx, 0FFh
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                mov     edx, [esp+8Ch]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                mov     ebp, [esi+ecx*8+2004h]
                and     edx, 7F8h
                mov     ecx, [esp+84h]
                xor     eax, edi
                shr     ecx, 0Dh
                xor     ebx, ebp
                mov     edi, [esi+edx+2800h]
                and     ecx, 7F8h
                mov     ebp, [esi+edx+2804h]
                xor     eax, edi
                mov     edx, [esp+0BCh]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+70h], eax
                mov     [esp+74h], ebx
                mov     ecx, [esp+0B8h]
                mov     edx, [esp+0B0h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     eax, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebx, [esi+ecx*8+4]
                mov     ecx, [esp+0A8h]
                mov     edi, [esi+edx+800h]
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                mov     edx, [esp+0A0h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                mov     ecx, [esp+9Ch]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                and     ecx, 0FFh
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                mov     edx, [esp+94h]
                xor     eax, edi
                xor     ebx, ebp
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                mov     ebp, [esi+ecx*8+2004h]
                and     edx, 7F8h
                mov     ecx, [esp+8Ch]
                xor     eax, edi
                shr     ecx, 0Dh
                xor     ebx, ebp
                mov     edi, [esi+edx+2800h]
                and     ecx, 7F8h
                mov     ebp, [esi+edx+2804h]
                xor     eax, edi
                mov     edx, [esp+84h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+78h], eax
                mov     [esp+7Ch], ebx
                mov     eax, [esp+40h]
                mov     ebx, [esp+44h]
                mov     ecx, [esp+0C0h]
                mov     edx, [esp+0F8h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+4]
                xor     eax, edi
                mov     ecx, [esp+0F0h]
                mov     edi, [esi+edx+800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+0E8h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     ecx, [esp+0E4h]
                mov     edx, [esp+0DCh]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+2004h]
                xor     eax, edi
                mov     ecx, [esp+0D4h]
                mov     edi, [esi+edx+2800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+2804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+0CCh]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     eax, [esp+48h]
                mov     ebx, [esp+4Ch]
                mov     ecx, [esp+0C8h]
                mov     edx, [esp+0C0h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+4]
                xor     eax, edi
                mov     ecx, [esp+0F8h]
                mov     edi, [esi+edx+800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+0F0h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     ecx, [esp+0ECh]
                mov     edx, [esp+0E4h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+2004h]
                xor     eax, edi
                mov     ecx, [esp+0DCh]
                mov     edi, [esi+edx+2800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+2804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+0D4h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+8], eax
                mov     [esp+0Ch], ebx
                mov     eax, [esp+50h]
                mov     ebx, [esp+54h]
                mov     ecx, [esp+0D0h]
                mov     edx, [esp+0C8h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+4]
                xor     eax, edi
                mov     ecx, [esp+0C0h]
                mov     edi, [esi+edx+800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+0F8h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     ecx, [esp+0F4h]
                mov     edx, [esp+0ECh]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+2004h]
                xor     eax, edi
                mov     ecx, [esp+0E4h]
                mov     edi, [esi+edx+2800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+2804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+0DCh]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+10h], eax
                mov     [esp+14h], ebx
                mov     eax, [esp+58h]
                mov     ebx, [esp+5Ch]
                mov     ecx, [esp+0D8h]
                mov     edx, [esp+0D0h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+4]
                xor     eax, edi
                mov     ecx, [esp+0C8h]
                mov     edi, [esi+edx+800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+0C0h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     ecx, [esp+0FCh]
                mov     edx, [esp+0F4h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+2004h]
                xor     eax, edi
                mov     ecx, [esp+0ECh]
                mov     edi, [esi+edx+2800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+2804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+0E4h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+18h], eax
                mov     [esp+1Ch], ebx
                mov     eax, [esp+60h]
                mov     ebx, [esp+64h]
                mov     ecx, [esp+0E0h]
                mov     edx, [esp+0D8h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+4]
                xor     eax, edi
                mov     ecx, [esp+0D0h]
                mov     edi, [esi+edx+800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+0C8h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     ecx, [esp+0C4h]
                mov     edx, [esp+0FCh]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+2004h]
                xor     eax, edi
                mov     ecx, [esp+0F4h]
                mov     edi, [esi+edx+2800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+2804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+0ECh]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+20h], eax
                mov     [esp+24h], ebx
                mov     eax, [esp+68h]
                mov     ebx, [esp+6Ch]
                mov     ecx, [esp+0E8h]
                mov     edx, [esp+0E0h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+4]
                xor     eax, edi
                mov     ecx, [esp+0D8h]
                mov     edi, [esi+edx+800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+0D0h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     ecx, [esp+0CCh]
                mov     edx, [esp+0C4h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+2004h]
                xor     eax, edi
                mov     ecx, [esp+0FCh]
                mov     edi, [esi+edx+2800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+2804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+0F4h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+28h], eax
                mov     [esp+2Ch], ebx
                mov     eax, [esp+70h]
                mov     ebx, [esp+74h]
                mov     ecx, [esp+0F0h]
                mov     edx, [esp+0E8h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+4]
                xor     eax, edi
                mov     ecx, [esp+0E0h]
                mov     edi, [esi+edx+800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+0D8h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     ecx, [esp+0D4h]
                mov     edx, [esp+0CCh]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+2004h]
                xor     eax, edi
                mov     ecx, [esp+0C4h]
                mov     edi, [esi+edx+2800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+2804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+0FCh]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+30h], eax
                mov     [esp+34h], ebx
                mov     eax, [esp+78h]
                mov     ebx, [esp+7Ch]
                mov     ecx, [esp+0F8h]
                mov     edx, [esp+0F0h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+4]
                xor     eax, edi
                mov     ecx, [esp+0E8h]
                mov     edi, [esi+edx+800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+0E0h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+1000h]
                mov     ebp, [esi+ecx+1004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+1800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+1804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     ecx, [esp+0DCh]
                mov     edx, [esp+0D4h]
                and     ecx, 0FFh
                shr     edx, 5
                mov     edi, [esi+ecx*8+2000h]
                and     edx, 7F8h
                mov     ebp, [esi+ecx*8+2004h]
                xor     eax, edi
                mov     ecx, [esp+0CCh]
                mov     edi, [esi+edx+2800h]
                xor     ebx, ebp
                shr     ecx, 0Dh
                mov     ebp, [esi+edx+2804h]
                and     ecx, 7F8h
                xor     eax, edi
                mov     edx, [esp+0C4h]
                xor     ebx, ebp
                shr     edx, 18h
                mov     edi, [esi+ecx+3000h]
                mov     ebp, [esi+ecx+3004h]
                xor     eax, edi
                mov     edi, [esi+edx*8+3800h]
                xor     ebx, ebp
                mov     ebp, [esi+edx*8+3804h]
                xor     eax, edi
                xor     ebx, ebp
                mov     [esp+38h], eax
                mov     [esp+3Ch], ebx
                mov     ebp, [esp+108h]
                add     ebp, 10h
                cmp     ebp, 50h 
                jnz     @@_loop_start
                mov     ebp, [esp+114h]
                mov     edi, [esp+110h]
                mov     esi, [esp+10Ch]
                mov     eax, [esp]
                mov     ebx, [esp+4]
                mov     ecx, [edi]
                mov     edx, [edi+4]
                xor     eax, ecx
                xor     ebx, edx
                mov     ecx, [esi]
                mov     edx, [esi+4]
                xor     eax, ecx
                xor     ebx, edx
                mov     [esi], eax
                mov     [esi+4], ebx
                mov     eax, [esp+8]
                mov     ebx, [esp+0Ch]
                mov     ecx, [edi+8]
                mov     edx, [edi+0Ch]
                xor     eax, ecx
                xor     ebx, edx
                mov     ecx, [esi+8]
                mov     edx, [esi+0Ch]
                xor     eax, ecx
                xor     ebx, edx
                mov     [esi+8], eax
                mov     [esi+0Ch], ebx
                mov     eax, [esp+10h]
                mov     ebx, [esp+14h]
                mov     ecx, [edi+10h]
                mov     edx, [edi+14h]
                xor     eax, ecx
                xor     ebx, edx
                mov     ecx, [esi+10h]
                mov     edx, [esi+14h]
                xor     eax, ecx
                xor     ebx, edx
                mov     [esi+10h], eax
                mov     [esi+14h], ebx
                mov     eax, [esp+18h]
                mov     ebx, [esp+1Ch]
                mov     ecx, [edi+18h]
                mov     edx, [edi+1Ch]
                xor     eax, ecx
                xor     ebx, edx
                mov     ecx, [esi+18h]
                mov     edx, [esi+1Ch]
                xor     eax, ecx
                xor     ebx, edx
                mov     [esi+18h], eax
                mov     [esi+1Ch], ebx
                mov     eax, [esp+20h]
                mov     ebx, [esp+24h]
                mov     ecx, [edi+20h]
                mov     edx, [edi+24h]
                xor     eax, ecx
                xor     ebx, edx
                mov     ecx, [esi+20h]
                mov     edx, [esi+24h]
                xor     eax, ecx
                xor     ebx, edx
                mov     [esi+20h], eax
                mov     [esi+24h], ebx
                mov     eax, [esp+28h]
                mov     ebx, [esp+2Ch]
                mov     ecx, [edi+28h]
                mov     edx, [edi+2Ch]
                xor     eax, ecx
                xor     ebx, edx
                mov     ecx, [esi+28h]
                mov     edx, [esi+2Ch]
                xor     eax, ecx
                xor     ebx, edx
                mov     [esi+28h], eax
                mov     [esi+2Ch], ebx
                mov     eax, [esp+30h]
                mov     ebx, [esp+34h]
                mov     ecx, [edi+30h]
                mov     edx, [edi+34h]
                xor     eax, ecx
                xor     ebx, edx
                mov     ecx, [esi+30h]
                mov     edx, [esi+34h]
                xor     eax, ecx
                xor     ebx, edx
                mov     [esi+30h], eax
                mov     [esi+34h], ebx
                mov     eax, [esp+38h]
                mov     ebx, [esp+3Ch]
                mov     ecx, [edi+38h]
                mov     edx, [edi+3Ch]
                xor     eax, ecx
                xor     ebx, edx
                mov     ecx, [esi+38h]
                mov     edx, [esi+3Ch]
                xor     eax, ecx
                xor     ebx, edx
                mov     [esi+38h], eax
                mov     [esi+3Ch], ebx
                mov     esp, ebp
                pop  ebp
                pop  edi
                pop  esi
                pop  ebx
end;
{$ENDIF}

{$IFDEF THash_Square_asm}
procedure THash_Square.DoTransform(Buffer: PLongArray);
asm
                push    ebx
                push    esi
                push    edi
                mov     esi, edx
                lea     edi, [eax].THash_Square.FDigest
                push    ebp
                lea     eax, Square_PHIr
                lea     edx, Square_TE
                lea     ecx, Square_SEint

                mov     ebp, esp
                add     esp, 0FFFFFF58h
                and     esp, 0FFFFFFE0h
                mov     [esp+90h], edi
                mov     [esp+94h], esi
                mov     [esp+98h], eax
                mov     [esp+9Ch], edx
                mov     [esp+0A0h], ecx
                mov     [esp+0A4h], ebp
                mov     ecx, [edi]
                mov     edx, [edi+4]
                mov     [esp], ecx
                mov     esi, eax
                mov     [esp+4], edx
                mov     ebp, [edi+8]
                mov     edi, [edi+0Ch]
                mov     [esp+8], ebp
                mov     [esp+0Ch], edi
                mov     eax, ecx
                mov     ebx, edx
                mov     ecx, ebp
                mov     ebp, edi
                xor     eax, 1
                ror     ebp, 8
                xor     eax, ebp
                mov     ebp, 0FFh
                xor     ebx, eax
                mov     [esp+10h], eax
                mov     eax, [esp]
                xor     ecx, ebx
                mov     [esp+14h], ebx
                xor     edi, ecx
                mov     [esp+18h], ecx
                mov     [esp+1Ch], edi
                mov     edx, eax
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+4]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+8]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+4], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+0Ch]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+8], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                mov     ebx, [esi+ebx*4]
                and     ecx, ebp
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                xor     ebx, edx
                mov     [esp+0Ch], ebx
                mov     eax, [esp+10h]
                mov     ebx, [esp+14h]
                mov     ecx, [esp+18h]
                mov     ebp, [esp+1Ch]
                xor     eax, 2
                mov     edi, ebp
                ror     ebp, 8
                xor     eax, ebp
                mov     ebp, 0FFh
                xor     ebx, eax
                mov     [esp+20h], eax
                mov     eax, [esp+10h]
                xor     ecx, ebx
                mov     [esp+24h], ebx
                xor     edi, ecx
                mov     [esp+28h], ecx
                mov     [esp+2Ch], edi
                mov     edx, eax
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+14h]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+10h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+18h]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+14h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+1Ch]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+18h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                mov     ebx, [esi+ebx*4]
                and     ecx, ebp
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                xor     ebx, edx
                mov     [esp+1Ch], ebx
                mov     eax, [esp+20h]
                mov     ebx, [esp+24h]
                mov     ecx, [esp+28h]
                mov     ebp, [esp+2Ch]
                xor     eax, 4
                mov     edi, ebp
                ror     ebp, 8
                xor     eax, ebp
                mov     ebp, 0FFh
                xor     ebx, eax
                mov     [esp+30h], eax
                mov     eax, [esp+20h]
                xor     ecx, ebx
                mov     [esp+34h], ebx
                xor     edi, ecx
                mov     [esp+38h], ecx
                mov     [esp+3Ch], edi
                mov     edx, eax
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+24h]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+20h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+28h]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+24h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+2Ch]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+28h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                mov     ebx, [esi+ebx*4]
                and     ecx, ebp
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                xor     ebx, edx
                mov     [esp+2Ch], ebx
                mov     eax, [esp+30h]
                mov     ebx, [esp+34h]
                mov     ecx, [esp+38h]
                mov     ebp, [esp+3Ch]
                xor     eax, 8
                mov     edi, ebp
                ror     ebp, 8
                xor     eax, ebp
                mov     ebp, 0FFh
                xor     ebx, eax
                mov     [esp+40h], eax
                mov     eax, [esp+30h]
                xor     ecx, ebx
                mov     [esp+44h], ebx
                xor     edi, ecx
                mov     [esp+48h], ecx
                mov     [esp+4Ch], edi
                mov     edx, eax
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+34h]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+30h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+38h]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+34h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+3Ch]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+38h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                mov     ebx, [esi+ebx*4]
                and     ecx, ebp
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                xor     ebx, edx
                mov     [esp+3Ch], ebx
                mov     eax, [esp+40h]
                mov     ebx, [esp+44h]
                mov     ecx, [esp+48h]
                mov     ebp, [esp+4Ch]
                xor     eax, 10h
                mov     edi, ebp
                ror     ebp, 8
                xor     eax, ebp
                mov     ebp, 0FFh
                xor     ebx, eax
                mov     [esp+50h], eax
                mov     eax, [esp+40h]
                xor     ecx, ebx
                mov     [esp+54h], ebx
                xor     edi, ecx
                mov     [esp+58h], ecx
                mov     [esp+5Ch], edi
                mov     edx, eax
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+44h]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+40h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+48h]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+44h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+4Ch]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+48h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                mov     ebx, [esi+ebx*4]
                and     ecx, ebp
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                xor     ebx, edx
                mov     [esp+4Ch], ebx
                mov     eax, [esp+50h]
                mov     ebx, [esp+54h]
                mov     ecx, [esp+58h]
                mov     ebp, [esp+5Ch]
                xor     eax, 20h
                mov     edi, ebp
                ror     ebp, 8
                xor     eax, ebp
                mov     ebp, 0FFh
                xor     ebx, eax
                mov     [esp+60h], eax
                mov     eax, [esp+50h]
                xor     ecx, ebx
                mov     [esp+64h], ebx
                xor     edi, ecx
                mov     [esp+68h], ecx
                mov     [esp+6Ch], edi
                mov     edx, eax
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+54h]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+50h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+58h]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+54h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+5Ch]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+58h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                mov     ebx, [esi+ebx*4]
                and     ecx, ebp
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                xor     ebx, edx
                mov     [esp+5Ch], ebx
                mov     eax, [esp+60h]
                mov     ebx, [esp+64h]
                mov     ecx, [esp+68h]
                mov     ebp, [esp+6Ch]
                xor     eax, 40h
                mov     edi, ebp
                ror     ebp, 8
                xor     eax, ebp
                mov     ebp, 0FFh
                xor     ebx, eax
                mov     [esp+70h], eax
                mov     eax, [esp+60h]
                xor     ecx, ebx
                mov     [esp+74h], ebx
                xor     edi, ecx
                mov     [esp+78h], ecx
                mov     [esp+7Ch], edi
                mov     edx, eax
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+64h]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+60h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+68h]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+64h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+6Ch]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+68h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                mov     ebx, [esi+ebx*4]
                and     ecx, ebp
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                xor     ebx, edx
                mov     [esp+6Ch], ebx
                mov     eax, [esp+70h]
                mov     ebx, [esp+74h]
                mov     ecx, [esp+78h]
                mov     ebp, [esp+7Ch]
                xor     eax, 80h
                mov     edi, ebp
                ror     ebp, 8
                xor     eax, ebp
                mov     ebp, 0FFh
                xor     ebx, eax
                mov     [esp+80h], eax
                mov     eax, [esp+70h]
                xor     ecx, ebx
                mov     [esp+84h], ebx
                xor     edi, ecx
                mov     [esp+88h], ecx
                mov     [esp+8Ch], edi
                mov     edx, eax
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+74h]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+70h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+78h]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+74h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                and     ecx, ebp
                mov     ebx, [esi+ebx*4]
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                mov     eax, [esp+7Ch]
                xor     ebx, edx
                mov     edx, eax
                mov     [esp+78h], ebx
                mov     ebx, eax
                mov     ecx, eax
                shr     eax, 8
                and     ebx, ebp
                shr     ecx, 10h
                and     eax, ebp
                mov     ebx, [esi+ebx*4]
                and     ecx, ebp
                shr     edx, 18h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esi+ecx*4+800h]
                xor     ebx, eax
                mov     edx, [esi+edx*4+0C00h]
                xor     ebx, ecx
                xor     ebx, edx
                mov     [esp+7Ch], ebx
                mov     esi, [esp+94h]
                mov     eax, [esp]
                mov     ebx, [esp+4]
                mov     ecx, [esp+8]
                mov     edx, [esp+0Ch]
                mov     edi, [esi]
                mov     ebp, [esi+4]
                xor     eax, edi
                xor     ebx, ebp
                mov     edi, [esi+8]
                mov     ebp, [esi+0Ch]
                mov     [esp], eax
                mov     [esp+4], ebx
                xor     ecx, edi
                xor     edx, ebp
                mov     [esp+8], ecx
                mov     [esp+0Ch], edx
                mov     esi, [esp+9Ch]
                mov     eax, [esp]
                mov     ecx, [esp+4]
                mov     ebx, eax
                mov     edx, ecx
                shr     eax, 8
                mov     edi, [esp+8]
                and     ebx, 0FFh
                mov     ebp, [esp+0Ch]
                shr     ecx, 8
                and     eax, 0FFh
                and     edx, 0FFh
                and     ecx, 0FFh
                mov     ebx, [esi+ebx*4]
                mov     eax, [esi+eax*4]
                mov     edx, [esi+edx*4+400h]
                mov     ecx, [esi+ecx*4+400h]
                xor     ebx, edx
                mov     edx, edi
                shr     edi, 8
                xor     eax, ecx
                mov     ecx, ebp
                and     edx, 0FFh
                shr     ebp, 8
                and     edi, 0FFh
                and     ecx, 0FFh
                mov     edx, [esi+edx*4+800h]
                and     ebp, 0FFh
                mov     edi, [esi+edi*4+800h]
                xor     ebx, edx
                mov     edx, [esp+10h]
                mov     ecx, [esi+ecx*4+0C00h]
                xor     eax, edi
                xor     ebx, ecx
                mov     ecx, [esp+14h]
                xor     ebx, edx
                xor     eax, ecx
                mov     ebp, [esi+ebp*4+0C00h]
                mov     [esp+10h], ebx
                xor     eax, ebp
                mov     [esp+14h], eax
                mov     ecx, [esp]
                mov     edx, [esp+4]
                mov     edi, ecx
                shr     ecx, 10h
                mov     eax, [esp+8]
                mov     ebp, edx
                mov     ebx, [esp+0Ch]
                shr     edx, 10h
                and     ecx, 0FFh
                shr     edi, 18h
                and     edx, 0FFh
                shr     ebp, 18h
                mov     ecx, [esi+ecx*4]
                shr     eax, 10h
                mov     edi, [esi+edi*4]
                shr     ebx, 10h
                mov     edx, [esi+edx*4+400h]
                mov     ebp, [esi+ebp*4+400h]
                xor     ecx, edx
                mov     edx, eax
                xor     edi, ebp
                shr     eax, 8
                mov     ebp, ebx
                and     edx, 0FFh
                and     ebx, 0FFh
                shr     ebp, 8
                mov     eax, [esi+eax*4+800h]
                mov     edx, [esi+edx*4+800h]
                xor     edi, eax
                xor     ecx, edx
                mov     ebx, [esi+ebx*4+0C00h]
                mov     ebp, [esi+ebp*4+0C00h]
                xor     ecx, ebx
                xor     edi, ebp
                mov     eax, [esp+18h]
                mov     ebx, [esp+1Ch]
                xor     ecx, eax
                xor     edi, ebx
                mov     [esp+18h], ecx
                mov     [esp+1Ch], edi
                mov     eax, [esp+10h]
                mov     ecx, [esp+14h]
                mov     ebx, eax
                mov     edx, ecx
                shr     eax, 8
                mov     edi, [esp+18h]
                and     ebx, 0FFh
                mov     ebp, [esp+1Ch]
                shr     ecx, 8
                and     eax, 0FFh
                and     edx, 0FFh
                and     ecx, 0FFh
                mov     ebx, [esi+ebx*4]
                mov     eax, [esi+eax*4]
                mov     edx, [esi+edx*4+400h]
                mov     ecx, [esi+ecx*4+400h]
                xor     ebx, edx
                mov     edx, edi
                shr     edi, 8
                xor     eax, ecx
                mov     ecx, ebp
                and     edx, 0FFh
                shr     ebp, 8
                and     edi, 0FFh
                and     ecx, 0FFh
                mov     edx, [esi+edx*4+800h]
                and     ebp, 0FFh
                mov     edi, [esi+edi*4+800h]
                xor     ebx, edx
                mov     edx, [esp+20h]
                mov     ecx, [esi+ecx*4+0C00h]
                xor     eax, edi
                xor     ebx, ecx
                mov     ecx, [esp+24h]
                xor     ebx, edx
                xor     eax, ecx
                mov     ebp, [esi+ebp*4+0C00h]
                mov     [esp+20h], ebx
                xor     eax, ebp
                mov     [esp+24h], eax
                mov     ecx, [esp+10h]
                mov     edx, [esp+14h]
                mov     edi, ecx
                shr     ecx, 10h
                mov     eax, [esp+18h]
                mov     ebp, edx
                mov     ebx, [esp+1Ch]
                shr     edx, 10h
                and     ecx, 0FFh
                shr     edi, 18h
                and     edx, 0FFh
                shr     ebp, 18h
                mov     ecx, [esi+ecx*4]
                shr     eax, 10h
                mov     edi, [esi+edi*4]
                shr     ebx, 10h
                mov     edx, [esi+edx*4+400h]
                mov     ebp, [esi+ebp*4+400h]
                xor     ecx, edx
                mov     edx, eax
                xor     edi, ebp
                shr     eax, 8
                mov     ebp, ebx
                and     edx, 0FFh
                and     ebx, 0FFh
                shr     ebp, 8
                mov     eax, [esi+eax*4+800h]
                mov     edx, [esi+edx*4+800h]
                xor     edi, eax
                xor     ecx, edx
                mov     ebx, [esi+ebx*4+0C00h]
                mov     ebp, [esi+ebp*4+0C00h]
                xor     ecx, ebx
                xor     edi, ebp
                mov     eax, [esp+28h]
                mov     ebx, [esp+2Ch]
                xor     ecx, eax
                xor     edi, ebx
                mov     [esp+28h], ecx
                mov     [esp+2Ch], edi
                mov     eax, [esp+20h]
                mov     ecx, [esp+24h]
                mov     ebx, eax
                mov     edx, ecx
                shr     eax, 8
                mov     edi, [esp+28h]
                and     ebx, 0FFh
                mov     ebp, [esp+2Ch]
                shr     ecx, 8
                and     eax, 0FFh
                and     edx, 0FFh
                and     ecx, 0FFh
                mov     ebx, [esi+ebx*4]
                mov     eax, [esi+eax*4]
                mov     edx, [esi+edx*4+400h]
                mov     ecx, [esi+ecx*4+400h]
                xor     ebx, edx
                mov     edx, edi
                shr     edi, 8
                xor     eax, ecx
                mov     ecx, ebp
                and     edx, 0FFh
                shr     ebp, 8
                and     edi, 0FFh
                and     ecx, 0FFh
                mov     edx, [esi+edx*4+800h]
                and     ebp, 0FFh
                mov     edi, [esi+edi*4+800h]
                xor     ebx, edx
                mov     edx, [esp+30h]
                mov     ecx, [esi+ecx*4+0C00h]
                xor     eax, edi
                xor     ebx, ecx
                mov     ecx, [esp+34h]
                xor     ebx, edx
                xor     eax, ecx
                mov     ebp, [esi+ebp*4+0C00h]
                mov     [esp+30h], ebx
                xor     eax, ebp
                mov     [esp+34h], eax
                mov     ecx, [esp+20h]
                mov     edx, [esp+24h]
                mov     edi, ecx
                shr     ecx, 10h
                mov     eax, [esp+28h]
                mov     ebp, edx
                mov     ebx, [esp+2Ch]
                shr     edx, 10h
                and     ecx, 0FFh
                shr     edi, 18h
                and     edx, 0FFh
                shr     ebp, 18h
                mov     ecx, [esi+ecx*4]
                shr     eax, 10h
                mov     edi, [esi+edi*4]
                shr     ebx, 10h
                mov     edx, [esi+edx*4+400h]
                mov     ebp, [esi+ebp*4+400h]
                xor     ecx, edx
                mov     edx, eax
                xor     edi, ebp
                shr     eax, 8
                mov     ebp, ebx
                and     edx, 0FFh
                and     ebx, 0FFh
                shr     ebp, 8
                mov     eax, [esi+eax*4+800h]
                mov     edx, [esi+edx*4+800h]
                xor     edi, eax
                xor     ecx, edx
                mov     ebx, [esi+ebx*4+0C00h]
                mov     ebp, [esi+ebp*4+0C00h]
                xor     ecx, ebx
                xor     edi, ebp
                mov     eax, [esp+38h]
                mov     ebx, [esp+3Ch]
                xor     ecx, eax
                xor     edi, ebx
                mov     [esp+38h], ecx
                mov     [esp+3Ch], edi
                mov     eax, [esp+30h]
                mov     ecx, [esp+34h]
                mov     ebx, eax
                mov     edx, ecx
                shr     eax, 8
                mov     edi, [esp+38h]
                and     ebx, 0FFh
                mov     ebp, [esp+3Ch]
                shr     ecx, 8
                and     eax, 0FFh
                and     edx, 0FFh
                and     ecx, 0FFh
                mov     ebx, [esi+ebx*4]
                mov     eax, [esi+eax*4]
                mov     edx, [esi+edx*4+400h]
                mov     ecx, [esi+ecx*4+400h]
                xor     ebx, edx
                mov     edx, edi
                shr     edi, 8
                xor     eax, ecx
                mov     ecx, ebp
                and     edx, 0FFh
                shr     ebp, 8
                and     edi, 0FFh
                and     ecx, 0FFh
                mov     edx, [esi+edx*4+800h]
                and     ebp, 0FFh
                mov     edi, [esi+edi*4+800h]
                xor     ebx, edx
                mov     edx, [esp+40h]
                mov     ecx, [esi+ecx*4+0C00h]
                xor     eax, edi
                xor     ebx, ecx
                mov     ecx, [esp+44h]
                xor     ebx, edx
                xor     eax, ecx
                mov     ebp, [esi+ebp*4+0C00h]
                mov     [esp+40h], ebx
                xor     eax, ebp
                mov     [esp+44h], eax
                mov     ecx, [esp+30h]
                mov     edx, [esp+34h]
                mov     edi, ecx
                shr     ecx, 10h
                mov     eax, [esp+38h]
                mov     ebp, edx
                mov     ebx, [esp+3Ch]
                shr     edx, 10h
                and     ecx, 0FFh
                shr     edi, 18h
                and     edx, 0FFh
                shr     ebp, 18h
                mov     ecx, [esi+ecx*4]
                shr     eax, 10h
                mov     edi, [esi+edi*4]
                shr     ebx, 10h
                mov     edx, [esi+edx*4+400h]
                mov     ebp, [esi+ebp*4+400h]
                xor     ecx, edx
                mov     edx, eax
                xor     edi, ebp
                shr     eax, 8
                mov     ebp, ebx
                and     edx, 0FFh
                and     ebx, 0FFh
                shr     ebp, 8
                mov     eax, [esi+eax*4+800h]
                mov     edx, [esi+edx*4+800h]
                xor     edi, eax
                xor     ecx, edx
                mov     ebx, [esi+ebx*4+0C00h]
                mov     ebp, [esi+ebp*4+0C00h]
                xor     ecx, ebx
                xor     edi, ebp
                mov     eax, [esp+48h]
                mov     ebx, [esp+4Ch]
                xor     ecx, eax
                xor     edi, ebx
                mov     [esp+48h], ecx
                mov     [esp+4Ch], edi
                mov     eax, [esp+40h]
                mov     ecx, [esp+44h]
                mov     ebx, eax
                mov     edx, ecx
                shr     eax, 8
                mov     edi, [esp+48h]
                and     ebx, 0FFh
                mov     ebp, [esp+4Ch]
                shr     ecx, 8
                and     eax, 0FFh
                and     edx, 0FFh
                and     ecx, 0FFh
                mov     ebx, [esi+ebx*4]
                mov     eax, [esi+eax*4]
                mov     edx, [esi+edx*4+400h]
                mov     ecx, [esi+ecx*4+400h]
                xor     ebx, edx
                mov     edx, edi
                shr     edi, 8
                xor     eax, ecx
                mov     ecx, ebp
                and     edx, 0FFh
                shr     ebp, 8
                and     edi, 0FFh
                and     ecx, 0FFh
                mov     edx, [esi+edx*4+800h]
                and     ebp, 0FFh
                mov     edi, [esi+edi*4+800h]
                xor     ebx, edx
                mov     edx, [esp+50h]
                mov     ecx, [esi+ecx*4+0C00h]
                xor     eax, edi
                xor     ebx, ecx
                mov     ecx, [esp+54h]
                xor     ebx, edx
                xor     eax, ecx
                mov     ebp, [esi+ebp*4+0C00h]
                mov     [esp+50h], ebx
                xor     eax, ebp
                mov     [esp+54h], eax
                mov     ecx, [esp+40h]
                mov     edx, [esp+44h]
                mov     edi, ecx
                shr     ecx, 10h
                mov     eax, [esp+48h]
                mov     ebp, edx
                mov     ebx, [esp+4Ch]
                shr     edx, 10h
                and     ecx, 0FFh
                shr     edi, 18h
                and     edx, 0FFh
                shr     ebp, 18h
                mov     ecx, [esi+ecx*4]
                shr     eax, 10h
                mov     edi, [esi+edi*4]
                shr     ebx, 10h
                mov     edx, [esi+edx*4+400h]
                mov     ebp, [esi+ebp*4+400h]
                xor     ecx, edx
                mov     edx, eax
                xor     edi, ebp
                shr     eax, 8
                mov     ebp, ebx
                and     edx, 0FFh
                and     ebx, 0FFh
                shr     ebp, 8
                mov     eax, [esi+eax*4+800h]
                mov     edx, [esi+edx*4+800h]
                xor     edi, eax
                xor     ecx, edx
                mov     ebx, [esi+ebx*4+0C00h]
                mov     ebp, [esi+ebp*4+0C00h]
                xor     ecx, ebx
                xor     edi, ebp
                mov     eax, [esp+58h]
                mov     ebx, [esp+5Ch]
                xor     ecx, eax
                xor     edi, ebx
                mov     [esp+58h], ecx
                mov     [esp+5Ch], edi
                mov     eax, [esp+50h]
                mov     ecx, [esp+54h]
                mov     ebx, eax
                mov     edx, ecx
                shr     eax, 8
                mov     edi, [esp+58h]
                and     ebx, 0FFh
                mov     ebp, [esp+5Ch]
                shr     ecx, 8
                and     eax, 0FFh
                and     edx, 0FFh
                and     ecx, 0FFh
                mov     ebx, [esi+ebx*4]
                mov     eax, [esi+eax*4]
                mov     edx, [esi+edx*4+400h]
                mov     ecx, [esi+ecx*4+400h]
                xor     ebx, edx
                mov     edx, edi
                shr     edi, 8
                xor     eax, ecx
                mov     ecx, ebp
                and     edx, 0FFh
                shr     ebp, 8
                and     edi, 0FFh
                and     ecx, 0FFh
                mov     edx, [esi+edx*4+800h]
                and     ebp, 0FFh
                mov     edi, [esi+edi*4+800h]
                xor     ebx, edx
                mov     edx, [esp+60h]
                mov     ecx, [esi+ecx*4+0C00h]
                xor     eax, edi
                xor     ebx, ecx
                mov     ecx, [esp+64h]
                xor     ebx, edx
                xor     eax, ecx
                mov     ebp, [esi+ebp*4+0C00h]
                mov     [esp+60h], ebx
                xor     eax, ebp
                mov     [esp+64h], eax
                mov     ecx, [esp+50h]
                mov     edx, [esp+54h]
                mov     edi, ecx
                shr     ecx, 10h
                mov     eax, [esp+58h]
                mov     ebp, edx
                mov     ebx, [esp+5Ch]
                shr     edx, 10h
                and     ecx, 0FFh
                shr     edi, 18h
                and     edx, 0FFh
                shr     ebp, 18h
                mov     ecx, [esi+ecx*4]
                shr     eax, 10h
                mov     edi, [esi+edi*4]
                shr     ebx, 10h
                mov     edx, [esi+edx*4+400h]
                mov     ebp, [esi+ebp*4+400h]
                xor     ecx, edx
                mov     edx, eax
                xor     edi, ebp
                shr     eax, 8
                mov     ebp, ebx
                and     edx, 0FFh
                and     ebx, 0FFh
                shr     ebp, 8
                mov     eax, [esi+eax*4+800h]
                mov     edx, [esi+edx*4+800h]
                xor     edi, eax
                xor     ecx, edx
                mov     ebx, [esi+ebx*4+0C00h]
                mov     ebp, [esi+ebp*4+0C00h]
                xor     ecx, ebx
                xor     edi, ebp
                mov     eax, [esp+68h]
                mov     ebx, [esp+6Ch]
                xor     ecx, eax
                xor     edi, ebx
                mov     [esp+68h], ecx
                mov     [esp+6Ch], edi
                mov     eax, [esp+60h]
                mov     ecx, [esp+64h]
                mov     ebx, eax
                mov     edx, ecx
                shr     eax, 8
                mov     edi, [esp+68h]
                and     ebx, 0FFh
                mov     ebp, [esp+6Ch]
                shr     ecx, 8
                and     eax, 0FFh
                and     edx, 0FFh
                and     ecx, 0FFh
                mov     ebx, [esi+ebx*4]
                mov     eax, [esi+eax*4]
                mov     edx, [esi+edx*4+400h]
                mov     ecx, [esi+ecx*4+400h]
                xor     ebx, edx
                mov     edx, edi
                shr     edi, 8
                xor     eax, ecx
                mov     ecx, ebp
                and     edx, 0FFh
                shr     ebp, 8
                and     edi, 0FFh
                and     ecx, 0FFh
                mov     edx, [esi+edx*4+800h]
                and     ebp, 0FFh
                mov     edi, [esi+edi*4+800h]
                xor     ebx, edx
                mov     edx, [esp+70h]
                mov     ecx, [esi+ecx*4+0C00h]
                xor     eax, edi
                xor     ebx, ecx
                mov     ecx, [esp+74h]
                xor     ebx, edx
                xor     eax, ecx
                mov     ebp, [esi+ebp*4+0C00h]
                mov     [esp+70h], ebx
                xor     eax, ebp
                mov     [esp+74h], eax
                mov     ecx, [esp+60h]
                mov     edx, [esp+64h]
                mov     edi, ecx
                shr     ecx, 10h
                mov     eax, [esp+68h]
                mov     ebp, edx
                mov     ebx, [esp+6Ch]
                shr     edx, 10h
                and     ecx, 0FFh
                shr     edi, 18h
                and     edx, 0FFh
                shr     ebp, 18h
                mov     ecx, [esi+ecx*4]
                shr     eax, 10h
                mov     edi, [esi+edi*4]
                shr     ebx, 10h
                mov     edx, [esi+edx*4+400h]
                mov     ebp, [esi+ebp*4+400h]
                xor     ecx, edx
                mov     edx, eax
                xor     edi, ebp
                shr     eax, 8
                mov     ebp, ebx
                and     edx, 0FFh
                and     ebx, 0FFh
                shr     ebp, 8
                mov     eax, [esi+eax*4+800h]
                mov     edx, [esi+edx*4+800h]
                xor     edi, eax
                xor     ecx, edx
                mov     ebx, [esi+ebx*4+0C00h]
                mov     ebp, [esi+ebp*4+0C00h]
                xor     ecx, ebx
                xor     edi, ebp
                mov     eax, [esp+78h]
                mov     ebx, [esp+7Ch]
                xor     ecx, eax
                xor     edi, ebx
                mov     [esp+78h], ecx
                mov     [esp+7Ch], edi
                mov     esi, [esp+0A0h]
                mov     eax, [esp+70h]
                mov     ebx, [esp+74h]
                mov     ecx, eax
                mov     edi, [esp+78h]
                shr     eax, 8
                mov     ebp, [esp+7Ch]
                mov     edx, ebx
                and     ecx, 0FFh
                and     eax, 0FFh
                shr     ebx, 8
                and     edx, 0FFh
                and     ebx, 0FFh
                mov     ecx, [esi+ecx*4]
                mov     edx, [esi+edx*4]
                mov     eax, [esi+eax*4]
                shl     edx, 8
                mov     ebx, [esi+ebx*4]
                shl     ebx, 8
                xor     ecx, edx
                mov     edx, edi
                xor     eax, ebx
                shr     edi, 8
                mov     ebx, ebp
                shr     ebp, 8
                and     edx, 0FFh
                and     edi, 0FFh
                and     ebx, 0FFh
                and     ebp, 0FFh
                mov     edx, [esi+edx*4]
                mov     edi, [esi+edi*4]
                mov     ebx, [esi+ebx*4]
                shl     edx, 10h
                mov     ebp, [esi+ebp*4]
                shl     edi, 10h
                xor     ecx, edx
                shl     ebx, 18h
                xor     eax, edi
                shl     ebp, 18h
                mov     edx, [esp+94h]
                xor     ecx, ebx
                xor     eax, ebp
                mov     ebx, [edx]
                mov     ebp, [edx+4]
                mov     edx, [esp+90h]
                xor     ecx, ebx
                xor     eax, ebp
                mov     ebx, [esp+80h]
                mov     ebp, [esp+84h]
                xor     ecx, ebx
                xor     eax, ebp
                mov     [edx], ecx
                mov     [edx+4], eax
                mov     eax, [esp+70h]
                mov     ebx, [esp+74h]
                mov     ecx, eax
                shr     eax, 10h
                mov     edi, [esp+78h]
                mov     ebp, [esp+7Ch]
                mov     edx, ebx
                shr     ebx, 10h
                and     eax, 0FFh
                shr     ecx, 18h
                and     ebx, 0FFh
                shr     edx, 18h
                mov     eax, [esi+eax*4]
                mov     ebx, [esi+ebx*4]
                mov     ecx, [esi+ecx*4]
                shl     ebx, 8
                mov     edx, [esi+edx*4]
                shl     edx, 8
                xor     eax, ebx
                mov     ebx, edi
                xor     ecx, edx
                shr     edi, 10h
                mov     edx, ebp
                shr     ebp, 10h
                and     edi, 0FFh
                shr     ebx, 18h
                and     ebp, 0FFh
                shr     edx, 18h
                mov     edi, [esi+edi*4]
                mov     ebx, [esi+ebx*4]
                mov     ebp, [esi+ebp*4]
                shl     edi, 10h
                mov     edx, [esi+edx*4]
                shl     ebp, 18h
                xor     eax, edi
                shl     ebx, 10h
                xor     eax, ebp
                shl     edx, 18h
                mov     edi, [esp+94h]
                xor     ecx, ebx
                mov     ebx, [esp+88h]
                xor     ecx, edx
                mov     edx, [esp+8Ch]
                xor     eax, ebx
                mov     ebx, [edi+8]
                mov     edi, [edi+0Ch]
                xor     ecx, edx
                mov     edx, [esp+90h]
                mov     ebp, [esp+0A4h]
                xor     eax, ebx
                mov     esp, ebp
                xor     ecx, edi
                mov     [edx+8], eax
                mov     [edx+0Ch], ecx
                pop  ebp
                pop  edi
                pop  esi
                pop  ebx
end;
{$ENDIF}

{$IFDEF THash_Snefru128_asm}
procedure THash_Snefru128.DoTransform(Buffer: PLongArray);
begin
  SwapLongBuffer(Buffer[0], FDigest[4], 12);
  asm
                push    ebx
                mov     eax, Self
                push    esi
                push    edi
                lea     edi, [eax].THash_Snefru128.FDigest
                push    ebp
                lea     esi, Snefru_Data
                mov     ecx, [eax].THash_Snefru128.FSecurity_Level

                mov     ebp, esp
                add     esp, 0FFFFFF94h
                and     esp, 0FFFFFFE0h
                mov     [esp+60h], edi
                mov     [esp+68h], ebp
                mov     eax, [edi]
                mov     ebx, [edi+4]
                mov     ebp, [edi+8]
                mov     edx, [edi+0Ch]
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     [esp+8], ebp
                mov     [esp+0Ch], edx
                mov     [esp+40h], eax
                mov     [esp+44h], ebx
                mov     [esp+48h], ebp
                mov     [esp+4Ch], edx
                mov     eax, [edi+10h]
                mov     ebx, [edi+14h]
                mov     ebp, [edi+18h]
                mov     edx, [edi+1Ch]
                mov     [esp+10h], eax
                mov     [esp+14h], ebx
                mov     [esp+18h], ebp
                mov     [esp+1Ch], edx
                mov     eax, [edi+20h]
                mov     ebx, [edi+24h]
                mov     ebp, [edi+28h]
                mov     edx, [edi+2Ch]
                mov     [esp+20h], eax
                mov     [esp+24h], ebx
                mov     [esp+28h], ebp
                mov     [esp+2Ch], edx
                mov     eax, [edi+30h]
                mov     ebx, [edi+34h]
                mov     ebp, [edi+38h]
                mov     edx, [edi+3Ch]
                mov     [esp+30h], eax
                mov     [esp+34h], ebx
                mov     [esp+38h], ebp
                mov     [esp+3Ch], edx

@@_level_loop:
                mov     [esp+64h], ecx
                mov     ebx, [esp]
                mov     ecx, [esp+4]
                mov     edi, ebx
                and     ebx, 0FFh
                mov     eax, [esp+3Ch]
                mov     ebx, [esi+ebx*4]
                mov     edx, [esp+8]
                xor     ecx, ebx
                xor     eax, ebx
                mov     ebp, ecx
                and     ecx, 0FFh
                mov     [esp+3Ch], eax
                mov     ecx, [esi+ecx*4]
                mov     ebx, [esp+0Ch]
                xor     edx, ecx
                xor     edi, ecx
                mov     ecx, edx
                and     edx, 0FFh
                mov     [esp], edi
                mov     edx, [esi+edx*4+400h]
                mov     edi, [esp+10h]
                xor     ebx, edx
                xor     ebp, edx
                mov     edx, ebx
                and     ebx, 0FFh
                ror     ebp, 10h
                mov     ebx, [esi+ebx*4+400h]
                mov     eax, [esp+14h]
                mov     [esp+4], ebp
                xor     edi, ebx
                xor     ecx, ebx
                mov     ebx, edi
                and     edi, 0FFh
                mov     ebp, [esp+18h]
                ror     ecx, 10h
                mov     edi, [esi+edi*4]
                mov     [esp+8], ecx
                xor     eax, edi
                xor     edx, edi
                mov     edi, eax
                and     eax, 0FFh
                ror     edx, 10h
                mov     eax, [esi+eax*4]
                mov     ecx, [esp+1Ch]
                mov     [esp+0Ch], edx
                xor     ebp, eax
                xor     ebx, eax
                mov     eax, ebp
                and     ebp, 0FFh
                mov     edx, [esp+20h]
                ror     ebx, 10h
                mov     ebp, [esi+ebp*4+400h]
                mov     [esp+10h], ebx
                xor     ecx, ebp
                xor     edi, ebp
                mov     ebp, ecx
                and     ecx, 0FFh
                ror     edi, 10h
                mov     ecx, [esi+ecx*4+400h]
                mov     ebx, [esp+24h]
                mov     [esp+14h], edi
                xor     edx, ecx
                xor     eax, ecx
                mov     ecx, edx
                and     edx, 0FFh
                mov     edi, [esp+28h]
                ror     eax, 10h
                mov     edx, [esi+edx*4]
                mov     [esp+18h], eax
                xor     ebx, edx
                xor     ebp, edx
                mov     edx, ebx
                and     ebx, 0FFh
                ror     ebp, 10h
                mov     ebx, [esi+ebx*4]
                mov     eax, [esp+2Ch]
                mov     [esp+1Ch], ebp
                xor     edi, ebx
                xor     ecx, ebx
                mov     ebx, edi
                and     edi, 0FFh
                mov     ebp, [esp+30h]
                ror     ecx, 10h
                mov     edi, [esi+edi*4+400h]
                mov     [esp+20h], ecx
                xor     eax, edi
                xor     edx, edi
                mov     edi, eax
                and     eax, 0FFh
                ror     edx, 10h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esp+34h]
                mov     [esp+24h], edx
                xor     ebp, eax
                xor     ebx, eax
                mov     eax, ebp
                and     ebp, 0FFh
                mov     edx, [esp+38h]
                ror     ebx, 10h
                mov     ebp, [esi+ebp*4]
                mov     [esp+28h], ebx
                xor     ecx, ebp
                xor     edi, ebp
                mov     ebp, ecx
                and     ecx, 0FFh
                ror     edi, 10h
                mov     ecx, [esi+ecx*4]
                mov     ebx, [esp+3Ch]
                mov     [esp+2Ch], edi
                xor     edx, ecx
                xor     eax, ecx
                mov     ecx, edx
                and     edx, 0FFh
                mov     edi, [esp]
                ror     eax, 10h
                mov     edx, [esi+edx*4+400h]
                mov     [esp+30h], eax
                xor     ebx, edx
                xor     ebp, edx
                mov     edx, ebx
                and     ebx, 0FFh
                ror     ebp, 10h
                ror     edx, 10h
                mov     ebx, [esi+ebx*4+400h]
                mov     [esp+34h], ebp
                xor     edi, ebx
                xor     ecx, ebx
                ror     edi, 10h
                ror     ecx, 10h
                mov     [esp], edi
                mov     [esp+38h], ecx
                mov     [esp+3Ch], edx
                mov     ebx, [esp]
                mov     ecx, [esp+4]
                mov     edi, ebx
                and     ebx, 0FFh
                mov     eax, [esp+3Ch]
                mov     ebx, [esi+ebx*4]
                mov     edx, [esp+8]
                xor     ecx, ebx
                xor     eax, ebx
                mov     ebp, ecx
                and     ecx, 0FFh
                mov     [esp+3Ch], eax
                mov     ecx, [esi+ecx*4]
                mov     ebx, [esp+0Ch]
                xor     edx, ecx
                xor     edi, ecx
                mov     ecx, edx
                and     edx, 0FFh
                mov     [esp], edi
                mov     edx, [esi+edx*4+400h]
                mov     edi, [esp+10h]
                xor     ebx, edx
                xor     ebp, edx
                mov     edx, ebx
                and     ebx, 0FFh
                ror     ebp, 8
                mov     ebx, [esi+ebx*4+400h]
                mov     eax, [esp+14h]
                mov     [esp+4], ebp
                xor     edi, ebx
                xor     ecx, ebx
                mov     ebx, edi
                and     edi, 0FFh
                mov     ebp, [esp+18h]
                ror     ecx, 8
                mov     edi, [esi+edi*4]
                mov     [esp+8], ecx
                xor     eax, edi
                xor     edx, edi
                mov     edi, eax
                and     eax, 0FFh
                ror     edx, 8
                mov     eax, [esi+eax*4]
                mov     ecx, [esp+1Ch]
                mov     [esp+0Ch], edx
                xor     ebp, eax
                xor     ebx, eax
                mov     eax, ebp
                and     ebp, 0FFh
                mov     edx, [esp+20h]
                ror     ebx, 8
                mov     ebp, [esi+ebp*4+400h]
                mov     [esp+10h], ebx
                xor     ecx, ebp
                xor     edi, ebp
                mov     ebp, ecx
                and     ecx, 0FFh
                ror     edi, 8
                mov     ecx, [esi+ecx*4+400h]
                mov     ebx, [esp+24h]
                mov     [esp+14h], edi
                xor     edx, ecx
                xor     eax, ecx
                mov     ecx, edx
                and     edx, 0FFh
                mov     edi, [esp+28h]
                ror     eax, 8
                mov     edx, [esi+edx*4]
                mov     [esp+18h], eax
                xor     ebx, edx
                xor     ebp, edx
                mov     edx, ebx
                and     ebx, 0FFh
                ror     ebp, 8
                mov     ebx, [esi+ebx*4]
                mov     eax, [esp+2Ch]
                mov     [esp+1Ch], ebp
                xor     edi, ebx
                xor     ecx, ebx
                mov     ebx, edi
                and     edi, 0FFh
                mov     ebp, [esp+30h]
                ror     ecx, 8
                mov     edi, [esi+edi*4+400h]
                mov     [esp+20h], ecx
                xor     eax, edi
                xor     edx, edi
                mov     edi, eax
                and     eax, 0FFh
                ror     edx, 8
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esp+34h]
                mov     [esp+24h], edx
                xor     ebp, eax
                xor     ebx, eax
                mov     eax, ebp
                and     ebp, 0FFh
                mov     edx, [esp+38h]
                ror     ebx, 8
                mov     ebp, [esi+ebp*4]
                mov     [esp+28h], ebx
                xor     ecx, ebp
                xor     edi, ebp
                mov     ebp, ecx
                and     ecx, 0FFh
                ror     edi, 8
                mov     ecx, [esi+ecx*4]
                mov     ebx, [esp+3Ch]
                mov     [esp+2Ch], edi
                xor     edx, ecx
                xor     eax, ecx
                mov     ecx, edx
                and     edx, 0FFh
                mov     edi, [esp]
                ror     eax, 8
                mov     edx, [esi+edx*4+400h]
                mov     [esp+30h], eax
                xor     ebx, edx
                xor     ebp, edx
                mov     edx, ebx
                and     ebx, 0FFh
                ror     ebp, 8
                ror     edx, 8
                mov     ebx, [esi+ebx*4+400h]
                mov     [esp+34h], ebp
                xor     edi, ebx
                xor     ecx, ebx
                ror     edi, 8
                ror     ecx, 8
                mov     [esp], edi
                mov     [esp+38h], ecx
                mov     [esp+3Ch], edx
                mov     ebx, [esp]
                mov     ecx, [esp+4]
                mov     edi, ebx
                and     ebx, 0FFh
                mov     eax, [esp+3Ch]
                mov     ebx, [esi+ebx*4]
                mov     edx, [esp+8]
                xor     ecx, ebx
                xor     eax, ebx
                mov     ebp, ecx
                and     ecx, 0FFh
                mov     [esp+3Ch], eax
                mov     ecx, [esi+ecx*4]
                mov     ebx, [esp+0Ch]
                xor     edx, ecx
                xor     edi, ecx
                mov     ecx, edx
                and     edx, 0FFh
                mov     [esp], edi
                mov     edx, [esi+edx*4+400h]
                mov     edi, [esp+10h]
                xor     ebx, edx
                xor     ebp, edx
                mov     edx, ebx
                and     ebx, 0FFh
                ror     ebp, 10h
                mov     ebx, [esi+ebx*4+400h]
                mov     eax, [esp+14h]
                mov     [esp+4], ebp
                xor     edi, ebx
                xor     ecx, ebx
                mov     ebx, edi
                and     edi, 0FFh
                mov     ebp, [esp+18h]
                ror     ecx, 10h
                mov     edi, [esi+edi*4]
                mov     [esp+8], ecx
                xor     eax, edi
                xor     edx, edi
                mov     edi, eax
                and     eax, 0FFh
                ror     edx, 10h
                mov     eax, [esi+eax*4]
                mov     ecx, [esp+1Ch]
                mov     [esp+0Ch], edx
                xor     ebp, eax
                xor     ebx, eax
                mov     eax, ebp
                and     ebp, 0FFh
                mov     edx, [esp+20h]
                ror     ebx, 10h
                mov     ebp, [esi+ebp*4+400h]
                mov     [esp+10h], ebx
                xor     ecx, ebp
                xor     edi, ebp
                mov     ebp, ecx
                and     ecx, 0FFh
                ror     edi, 10h
                mov     ecx, [esi+ecx*4+400h]
                mov     ebx, [esp+24h]
                mov     [esp+14h], edi
                xor     edx, ecx
                xor     eax, ecx
                mov     ecx, edx
                and     edx, 0FFh
                mov     edi, [esp+28h]
                ror     eax, 10h
                mov     edx, [esi+edx*4]
                mov     [esp+18h], eax
                xor     ebx, edx
                xor     ebp, edx
                mov     edx, ebx
                and     ebx, 0FFh
                ror     ebp, 10h
                mov     ebx, [esi+ebx*4]
                mov     eax, [esp+2Ch]
                mov     [esp+1Ch], ebp
                xor     edi, ebx
                xor     ecx, ebx
                mov     ebx, edi
                and     edi, 0FFh
                mov     ebp, [esp+30h]
                ror     ecx, 10h
                mov     edi, [esi+edi*4+400h]
                mov     [esp+20h], ecx
                xor     eax, edi
                xor     edx, edi
                mov     edi, eax
                and     eax, 0FFh
                ror     edx, 10h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esp+34h]
                mov     [esp+24h], edx
                xor     ebp, eax
                xor     ebx, eax
                mov     eax, ebp
                and     ebp, 0FFh
                mov     edx, [esp+38h]
                ror     ebx, 10h
                mov     ebp, [esi+ebp*4]
                mov     [esp+28h], ebx
                xor     ecx, ebp
                xor     edi, ebp
                mov     ebp, ecx
                and     ecx, 0FFh
                ror     edi, 10h
                mov     ecx, [esi+ecx*4]
                mov     ebx, [esp+3Ch]
                mov     [esp+2Ch], edi
                xor     edx, ecx
                xor     eax, ecx
                mov     ecx, edx
                and     edx, 0FFh
                mov     edi, [esp]
                ror     eax, 10h
                mov     edx, [esi+edx*4+400h]
                mov     [esp+30h], eax
                xor     ebx, edx
                xor     ebp, edx
                mov     edx, ebx
                and     ebx, 0FFh
                ror     ebp, 10h
                ror     edx, 10h
                mov     ebx, [esi+ebx*4+400h]
                mov     [esp+34h], ebp
                xor     edi, ebx
                xor     ecx, ebx
                ror     edi, 10h
                ror     ecx, 10h
                mov     [esp], edi
                mov     [esp+38h], ecx
                mov     [esp+3Ch], edx
                mov     ebx, [esp]
                mov     ecx, [esp+4]
                mov     edi, ebx
                and     ebx, 0FFh
                mov     eax, [esp+3Ch]
                mov     ebx, [esi+ebx*4]
                mov     edx, [esp+8]
                xor     ecx, ebx
                xor     eax, ebx
                mov     ebp, ecx
                and     ecx, 0FFh
                mov     [esp+3Ch], eax
                mov     ecx, [esi+ecx*4]
                mov     ebx, [esp+0Ch]
                xor     edx, ecx
                xor     edi, ecx
                mov     ecx, edx
                and     edx, 0FFh
                mov     [esp], edi
                mov     edx, [esi+edx*4+400h]
                mov     edi, [esp+10h]
                xor     ebx, edx
                xor     ebp, edx
                mov     edx, ebx
                and     ebx, 0FFh
                rol     ebp, 8
                mov     ebx, [esi+ebx*4+400h]
                mov     eax, [esp+14h]
                mov     [esp+4], ebp
                xor     edi, ebx
                xor     ecx, ebx
                mov     ebx, edi
                and     edi, 0FFh
                mov     ebp, [esp+18h]
                rol     ecx, 8
                mov     edi, [esi+edi*4]
                mov     [esp+8], ecx
                xor     eax, edi
                xor     edx, edi
                mov     edi, eax
                and     eax, 0FFh
                rol     edx, 8
                mov     eax, [esi+eax*4]
                mov     ecx, [esp+1Ch]
                mov     [esp+0Ch], edx
                xor     ebp, eax
                xor     ebx, eax
                mov     eax, ebp
                and     ebp, 0FFh
                mov     edx, [esp+20h]
                rol     ebx, 8
                mov     ebp, [esi+ebp*4+400h]
                mov     [esp+10h], ebx
                xor     ecx, ebp
                xor     edi, ebp
                mov     ebp, ecx
                and     ecx, 0FFh
                rol     edi, 8
                mov     ecx, [esi+ecx*4+400h]
                mov     ebx, [esp+24h]
                mov     [esp+14h], edi
                xor     edx, ecx
                xor     eax, ecx
                mov     ecx, edx
                and     edx, 0FFh
                mov     edi, [esp+28h]
                rol     eax, 8
                mov     edx, [esi+edx*4]
                mov     [esp+18h], eax
                xor     ebx, edx
                xor     ebp, edx
                mov     edx, ebx
                and     ebx, 0FFh
                rol     ebp, 8
                mov     ebx, [esi+ebx*4]
                mov     eax, [esp+2Ch]
                mov     [esp+1Ch], ebp
                xor     edi, ebx
                xor     ecx, ebx
                mov     ebx, edi
                and     edi, 0FFh
                mov     ebp, [esp+30h]
                rol     ecx, 8
                mov     edi, [esi+edi*4+400h]
                mov     [esp+20h], ecx
                xor     eax, edi
                xor     edx, edi
                mov     edi, eax
                and     eax, 0FFh
                rol     edx, 8
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esp+34h]
                mov     [esp+24h], edx
                xor     ebp, eax
                xor     ebx, eax
                mov     eax, ebp
                and     ebp, 0FFh
                mov     edx, [esp+38h]
                rol     ebx, 8
                mov     ebp, [esi+ebp*4]
                mov     [esp+28h], ebx
                xor     ecx, ebp
                xor     edi, ebp
                mov     ebp, ecx
                and     ecx, 0FFh
                rol     edi, 8
                mov     ecx, [esi+ecx*4]
                mov     ebx, [esp+3Ch]
                mov     [esp+2Ch], edi
                xor     edx, ecx
                xor     eax, ecx
                mov     ecx, edx
                and     edx, 0FFh
                mov     edi, [esp]
                rol     eax, 8
                mov     edx, [esi+edx*4+400h]
                mov     [esp+30h], eax
                xor     ebx, edx
                xor     ebp, edx
                mov     edx, ebx
                and     ebx, 0FFh
                rol     ebp, 8
                rol     edx, 8
                mov     ebx, [esi+ebx*4+400h]
                mov     [esp+34h], ebp
                xor     edi, ebx
                xor     ecx, ebx
                rol     edi, 8
                rol     ecx, 8
                mov     [esp], edi
                mov     [esp+38h], ecx
                mov     [esp+3Ch], edx
                mov     ecx, [esp+64h]
                add     esi, 800h
                dec     ecx
                jnz     @@_level_loop
                mov     edi, [esp+60h]
                mov     eax, [esp+40h]
                mov     ebx, [esp+44h]
                mov     ecx, [esp+3Ch]
                mov     edx, [esp+38h]
                xor     eax, ecx
                xor     ebx, edx
                mov     [edi], eax
                mov     [edi+4], ebx
                mov     eax, [esp+48h]
                mov     ebx, [esp+4Ch]
                mov     ecx, [esp+34h]
                mov     edx, [esp+30h]
                xor     eax, ecx
                xor     ebx, edx
                mov     [edi+8], eax
                mov     [edi+0Ch], ebx
                mov     ebp, [esp+68h]
                mov     esp, ebp


                pop  ebp
                pop  edi
                pop  esi
                pop  ebx
  end;
end;
{$ENDIF}

{$IFDEF THash_Snefru256_asm}
procedure THash_Snefru256.DoTransform(Buffer: PLongArray);
begin
  SwapLongBuffer(Buffer[0], FDigest[8], 8);
  asm
                push    ebx
                mov     eax, Self
                push    esi
                push    edi
                lea     edi, [eax].THash_Snefru256.FDigest
                push    ebp
                lea     esi, Snefru_Data
                mov     ecx, [eax].THash_Snefru256.FSecurity_Level
                mov     ebp, esp
                add     esp, 0FFFFFF94h
                and     esp, 0FFFFFFE0h
                mov     [esp+60h], edi
                mov     [esp+68h], ebp
                mov     eax, [edi]
                mov     ebx, [edi+4]
                mov     ebp, [edi+8]
                mov     edx, [edi+0Ch]
                mov     [esp], eax
                mov     [esp+4], ebx
                mov     [esp+8], ebp
                mov     [esp+0Ch], edx
                mov     [esp+40h], eax
                mov     [esp+44h], ebx
                mov     [esp+48h], ebp
                mov     [esp+4Ch], edx
                mov     eax, [edi+10h]
                mov     ebx, [edi+14h]
                mov     ebp, [edi+18h]
                mov     edx, [edi+1Ch]
                mov     [esp+10h], eax
                mov     [esp+14h], ebx
                mov     [esp+18h], ebp
                mov     [esp+1Ch], edx
                mov     [esp+50h], eax
                mov     [esp+54h], ebx
                mov     [esp+58h], ebp
                mov     [esp+5Ch], edx
                mov     eax, [edi+20h]
                mov     ebx, [edi+24h]
                mov     ebp, [edi+28h]
                mov     edx, [edi+2Ch]
                mov     [esp+20h], eax
                mov     [esp+24h], ebx
                mov     [esp+28h], ebp
                mov     [esp+2Ch], edx
                mov     eax, [edi+30h]
                mov     ebx, [edi+34h]
                mov     ebp, [edi+38h]
                mov     edx, [edi+3Ch]
                mov     [esp+30h], eax
                mov     [esp+34h], ebx
                mov     [esp+38h], ebp
                mov     [esp+3Ch], edx

@@_level_loop:
                mov     [esp+64h], ecx
                mov     ebx, [esp]
                mov     ecx, [esp+4]
                mov     edi, ebx
                and     ebx, 0FFh
                mov     eax, [esp+3Ch]
                mov     ebx, [esi+ebx*4]
                mov     edx, [esp+8]
                xor     ecx, ebx
                xor     eax, ebx
                mov     ebp, ecx
                and     ecx, 0FFh
                mov     [esp+3Ch], eax
                mov     ecx, [esi+ecx*4]
                mov     ebx, [esp+0Ch]
                xor     edx, ecx
                xor     edi, ecx
                mov     ecx, edx
                and     edx, 0FFh
                mov     [esp], edi
                mov     edx, [esi+edx*4+400h]
                mov     edi, [esp+10h]
                xor     ebx, edx
                xor     ebp, edx
                mov     edx, ebx
                and     ebx, 0FFh
                ror     ebp, 10h
                mov     ebx, [esi+ebx*4+400h]
                mov     eax, [esp+14h]
                mov     [esp+4], ebp
                xor     edi, ebx
                xor     ecx, ebx
                mov     ebx, edi
                and     edi, 0FFh
                mov     ebp, [esp+18h]
                ror     ecx, 10h
                mov     edi, [esi+edi*4]
                mov     [esp+8], ecx
                xor     eax, edi
                xor     edx, edi
                mov     edi, eax
                and     eax, 0FFh
                ror     edx, 10h
                mov     eax, [esi+eax*4]
                mov     ecx, [esp+1Ch]
                mov     [esp+0Ch], edx
                xor     ebp, eax
                xor     ebx, eax
                mov     eax, ebp
                and     ebp, 0FFh
                mov     edx, [esp+20h]
                ror     ebx, 10h
                mov     ebp, [esi+ebp*4+400h]
                mov     [esp+10h], ebx
                xor     ecx, ebp
                xor     edi, ebp
                mov     ebp, ecx
                and     ecx, 0FFh
                ror     edi, 10h
                mov     ecx, [esi+ecx*4+400h]
                mov     ebx, [esp+24h]
                mov     [esp+14h], edi
                xor     edx, ecx
                xor     eax, ecx
                mov     ecx, edx
                and     edx, 0FFh
                mov     edi, [esp+28h]
                ror     eax, 10h
                mov     edx, [esi+edx*4]
                mov     [esp+18h], eax
                xor     ebx, edx
                xor     ebp, edx
                mov     edx, ebx
                and     ebx, 0FFh
                ror     ebp, 10h
                mov     ebx, [esi+ebx*4]
                mov     eax, [esp+2Ch]
                mov     [esp+1Ch], ebp
                xor     edi, ebx
                xor     ecx, ebx
                mov     ebx, edi
                and     edi, 0FFh
                mov     ebp, [esp+30h]
                ror     ecx, 10h
                mov     edi, [esi+edi*4+400h]
                mov     [esp+20h], ecx
                xor     eax, edi
                xor     edx, edi
                mov     edi, eax
                and     eax, 0FFh
                ror     edx, 10h
                mov     eax, [esi+eax*4+400h]
                mov     ecx, [esp+34h]
                mov     [esp+24h], edx
                xor     ebp, eax
                xor     ebx, eax
                mov     eax, ebp
                and     ebp, 0FFh
                mov     edx, [esp+38h]
                ror     ebx, 10h
                mov     ebp, [esi+ebp*4]
                mov     [esp+28h], ebx
                xor     ecx, ebp
                xor     edi, ebp
                mov     ebp, ecx
                and     ecx, 0FFh
                ror     edi, 10h
                mov     ecx, [esi+ecx*4]
                mov     ebx, [esp+3Ch]
                mov     [esp+2Ch], edi
                xor     edx, ecx
                xor     eax, ecx
                mov     ecx, edx
                and     edx, 0FFh
                mov     edi, [esp]
                ror     eax, 10h
                mov     edx, [esi+edx*4+400h]
                mov     [esp+30h], eax
                xor     ebx, edx
                xor     ebp, edx
                mov     edx, ebx
                and     ebx, 0FFh
                ror     ebp, 10h
                ror     edx, 10h
                mov     ebx, [esi+ebx*4+400h]
                mov     [esp+34h], ebp
                xor     edi, ebx
                xor     ecx, ebx
                ror     edi, 10h
                ror     ecx, 10h
                mov     [esp], edi
                mov     [esp+38h], ecx
                mov     [esp+3Ch], edx
                mov     ebx, [esp]
                mov     ecx, [esp+4]
                mov     edi, ebx
                and     ebx, 0FFh
                mov     eax, [esp+3Ch]
                mov     ebx, [esi+ebx*4]
                mov     edx, [esp+8]
                xor     ecx, ebx
                xor     eax, ebx
                mov     ebp, ecx
                and     ecx, 0FFh
                mov     [esp+3Ch], eax
                mov     ecx, [esi+ecx*4]
                mov     ebx, [esp+0Ch]
                xor     edx, ecx
                xor     edi, ecx
                mov     ecx, edx
                and     edx, 0FFh
                mov     [esp], edi
                mov     edx, [esi+edx*4+400h]
                mov     edi, [esp+10h]
                xor     ebx, edx
                xor     ebp, edx
                mov     edx, ebx
                and     ebx, 0FFh
                ror     ebp, 8
                mov     ebx, [esi+ebx*4+400h]
                mov     eax, [esp+14h]
                mov     [esp+4], ebp
                xor     edi, ebx
                xor     ecx, ebx
                mov     ebx, edi
                and     edi, 0FFh
                mov     ebp, [esp+18h]
                ror     ecx, 8
                mov     edi, [esi+edi*4]
                mov     [esp+8], ecx
                xor     eax, edi
                xor     edx, edi
                mov     edi, eax
                and     eax, 0FFh
                ror     edx, 8
                mov     eax, [esi+eax*4]
                mov     ecx, [esp+1Ch]
                mov     [esp+0Ch], edx
                xor     ebp, eax
                xor     ebx, eax
                mov     eax, ebp
                and     ebp, 0FFh
                mov     edx, [esp+20h]
                ror     ebx, 8
                mov     ebp, [esi+ebp*4+400h]
                mov     [esp+10h], ebx
                xor     ecx, ebp
                xor     edi, ebp
                mov     ebp, ecx
                and     ecx, 0FFh
                ror     edi, 8
                mov     ecx, [esi+ecx*4+400h]
                mov     ebx, [esp+24h]
                mov     [esp+14h], edi
                xor     edx, ecx
                xor     eax, 