export const MAIN_PARSER = // @generated by Peggy 4.0.3.
//
// https://peggyjs.org/
(function() {
  "use strict";

function peg$subclass(child, parent) {
  function C() { this.constructor = child; }
  C.prototype = parent.prototype;
  child.prototype = new C();
}

function peg$SyntaxError(message, expected, found, location) {
  var self = Error.call(this, message);
  // istanbul ignore next Check is a necessary evil to support older environments
  if (Object.setPrototypeOf) {
    Object.setPrototypeOf(self, peg$SyntaxError.prototype);
  }
  self.expected = expected;
  self.found = found;
  self.location = location;
  self.name = "SyntaxError";
  return self;
}

peg$subclass(peg$SyntaxError, Error);

function peg$padEnd(str, targetLength, padString) {
  padString = padString || " ";
  if (str.length > targetLength) { return str; }
  targetLength -= str.length;
  padString += padString.repeat(targetLength);
  return str + padString.slice(0, targetLength);
}

peg$SyntaxError.prototype.format = function(sources) {
  var str = "Error: " + this.message;
  if (this.location) {
    var src = null;
    var k;
    for (k = 0; k < sources.length; k++) {
      if (sources[k].source === this.location.source) {
        src = sources[k].text.split(/\r\n|\n|\r/g);
        break;
      }
    }
    var s = this.location.start;
    var offset_s = (this.location.source && (typeof this.location.source.offset === "function"))
      ? this.location.source.offset(s)
      : s;
    var loc = this.location.source + ":" + offset_s.line + ":" + offset_s.column;
    if (src) {
      var e = this.location.end;
      var filler = peg$padEnd("", offset_s.line.toString().length, ' ');
      var line = src[s.line - 1];
      var last = s.line === e.line ? e.column : line.length + 1;
      var hatLen = (last - s.column) || 1;
      str += "\n --> " + loc + "\n"
          + filler + " |\n"
          + offset_s.line + " | " + line + "\n"
          + filler + " | " + peg$padEnd("", s.column - 1, ' ')
          + peg$padEnd("", hatLen, "^");
    } else {
      str += "\n at " + loc;
    }
  }
  return str;
};

peg$SyntaxError.buildMessage = function(expected, found) {
  var DESCRIBE_EXPECTATION_FNS = {
    literal: function(expectation) {
      return "\"" + literalEscape(expectation.text) + "\"";
    },

    class: function(expectation) {
      var escapedParts = expectation.parts.map(function(part) {
        return Array.isArray(part)
          ? classEscape(part[0]) + "-" + classEscape(part[1])
          : classEscape(part);
      });

      return "[" + (expectation.inverted ? "^" : "") + escapedParts.join("") + "]";
    },

    any: function() {
      return "any character";
    },

    end: function() {
      return "end of input";
    },

    other: function(expectation) {
      return expectation.description;
    }
  };

  function hex(ch) {
    return ch.charCodeAt(0).toString(16).toUpperCase();
  }

  function literalEscape(s) {
    return s
      .replace(/\\/g, "\\\\")
      .replace(/"/g,  "\\\"")
      .replace(/\0/g, "\\0")
      .replace(/\t/g, "\\t")
      .replace(/\n/g, "\\n")
      .replace(/\r/g, "\\r")
      .replace(/[\x00-\x0F]/g,          function(ch) { return "\\x0" + hex(ch); })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return "\\x"  + hex(ch); });
  }

  function classEscape(s) {
    return s
      .replace(/\\/g, "\\\\")
      .replace(/\]/g, "\\]")
      .replace(/\^/g, "\\^")
      .replace(/-/g,  "\\-")
      .replace(/\0/g, "\\0")
      .replace(/\t/g, "\\t")
      .replace(/\n/g, "\\n")
      .replace(/\r/g, "\\r")
      .replace(/[\x00-\x0F]/g,          function(ch) { return "\\x0" + hex(ch); })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return "\\x"  + hex(ch); });
  }

  function describeExpectation(expectation) {
    return DESCRIBE_EXPECTATION_FNS[expectation.type](expectation);
  }

  function describeExpected(expected) {
    var descriptions = expected.map(describeExpectation);
    var i, j;

    descriptions.sort();

    if (descriptions.length > 0) {
      for (i = 1, j = 1; i < descriptions.length; i++) {
        if (descriptions[i - 1] !== descriptions[i]) {
          descriptions[j] = descriptions[i];
          j++;
        }
      }
      descriptions.length = j;
    }

    switch (descriptions.length) {
      case 1:
        return descriptions[0];

      case 2:
        return descriptions[0] + " or " + descriptions[1];

      default:
        return descriptions.slice(0, -1).join(", ")
          + ", or "
          + descriptions[descriptions.length - 1];
    }
  }

  function describeFound(found) {
    return found ? "\"" + literalEscape(found) + "\"" : "end of input";
  }

  return "Expected " + describeExpected(expected) + " but " + describeFound(found) + " found.";
};

function peg$parse(input, options) {
  options = options !== undefined ? options : {};

  var peg$FAILED = {};
  var peg$source = options.grammarSource;

  var peg$startRuleFunctions = { Main: peg$parseMain };
  var peg$startRuleFunction = peg$parseMain;

  var peg$c0 = "(";
  var peg$c1 = ")";
  var peg$c2 = ";";
  var peg$c3 = "::";
  var peg$c4 = "std";
  var peg$c5 = "sn";
  var peg$c6 = "printf";
  var peg$c7 = "_s";
  var peg$c8 = "scanf";
  var peg$c9 = "fscanf";
  var peg$c10 = "sscanf";
  var peg$c11 = ",";
  var peg$c12 = "\"";
  var peg$c13 = "\\\"";
  var peg$c14 = "\\";
  var peg$c15 = "++";
  var peg$c16 = "+";
  var peg$c17 = "--";
  var peg$c18 = "[";
  var peg$c19 = "]";
  var peg$c20 = "{";
  var peg$c21 = "}";
  var peg$c22 = "typedef";
  var peg$c23 = "extern";
  var peg$c24 = "static";
  var peg$c25 = "auto";
  var peg$c26 = "constexpr";
  var peg$c27 = "register";
  var peg$c28 = "void";
  var peg$c29 = "char";
  var peg$c30 = "short";
  var peg$c31 = "int";
  var peg$c32 = "long";
  var peg$c33 = "float";
  var peg$c34 = "double";
  var peg$c35 = "signed";
  var peg$c36 = "unsigned";
  var peg$c37 = "struct";
  var peg$c38 = "union";
  var peg$c39 = "class";
  var peg$c40 = "enum";
  var peg$c41 = "const";
  var peg$c42 = "restrict";
  var peg$c43 = "volatile";
  var peg$c44 = "inline";
  var peg$c45 = "*";
  var peg$c46 = "&&";
  var peg$c47 = "&";
  var peg$c48 = "override";
  var peg$c49 = "final";
  var peg$c50 = "...";
  var peg$c51 = "0";
  var peg$c52 = "break";
  var peg$c53 = "case";
  var peg$c54 = "continue";
  var peg$c55 = "default";
  var peg$c56 = "do";
  var peg$c57 = "else";
  var peg$c58 = "for";
  var peg$c59 = "goto";
  var peg$c60 = "if";
  var peg$c61 = "return";
  var peg$c62 = "sizeof";
  var peg$c63 = "switch";
  var peg$c64 = "while";
  var peg$c65 = "FILE";
  var peg$c66 = "_t";
  var peg$c67 = "_Alignas";
  var peg$c68 = "alignas";
  var peg$c69 = "_Alignof";
  var peg$c70 = "alignof";
  var peg$c71 = "_Atomic";
  var peg$c72 = "_Bool";
  var peg$c73 = "bool";
  var peg$c74 = "_Complex";
  var peg$c75 = "complex";
  var peg$c76 = "_Generic";
  var peg$c77 = "_Imaginary";
  var peg$c78 = "imaginary";
  var peg$c79 = "_Noreturn";
  var peg$c80 = "_Static_assert";
  var peg$c81 = "static_assert";
  var peg$c82 = "_Thread_local";
  var peg$c83 = "thread_local";

  var peg$r0 = /^[fs]/;
  var peg$r1 = /^[^"]/;
  var peg$r2 = /^[!&*\-~]/;
  var peg$r3 = /^[([]/;
  var peg$r4 = /^[a-zA-Z_]/;
  var peg$r5 = /^[bB]/;
  var peg$r6 = /^[01]/;
  var peg$r7 = /^[xX]/;
  var peg$r8 = /^[0-9a-fA-F]/;
  var peg$r9 = /^[0-7]/;
  var peg$r10 = /^[1-9]/;
  var peg$r11 = /^[0-9]/;
  var peg$r12 = /^[uU]/;
  var peg$r13 = /^[lL]/;
  var peg$r14 = /^[a-zA-Z0-9_]/;
  var peg$r15 = /^[ \n]/;

  var peg$e0 = peg$otherExpectation("printf-scanf-call");
  var peg$e1 = peg$literalExpectation("(", false);
  var peg$e2 = peg$literalExpectation(")", false);
  var peg$e3 = peg$literalExpectation(";", false);
  var peg$e4 = peg$literalExpectation("::", false);
  var peg$e5 = peg$literalExpectation("std", false);
  var peg$e6 = peg$classExpectation(["f", "s"], false, false);
  var peg$e7 = peg$literalExpectation("sn", false);
  var peg$e8 = peg$literalExpectation("printf", false);
  var peg$e9 = peg$literalExpectation("_s", false);
  var peg$e10 = peg$literalExpectation("scanf", false);
  var peg$e11 = peg$literalExpectation("fscanf", false);
  var peg$e12 = peg$literalExpectation("sscanf", false);
  var peg$e13 = peg$literalExpectation(",", false);
  var peg$e14 = peg$literalExpectation("\"", false);
  var peg$e15 = peg$literalExpectation("\\\"", false);
  var peg$e16 = peg$literalExpectation("\\", false);
  var peg$e17 = peg$classExpectation(["\""], true, false);
  var peg$e18 = peg$literalExpectation("++", false);
  var peg$e19 = peg$literalExpectation("+", false);
  var peg$e20 = peg$literalExpectation("--", false);
  var peg$e21 = peg$classExpectation(["!", "&", "*", "-", "~"], false, false);
  var peg$e22 = peg$literalExpectation("[", false);
  var peg$e23 = peg$literalExpectation("]", false);
  var peg$e24 = peg$otherExpectation("declaration");
  var peg$e25 = peg$otherExpectation("declaration-specifier-list");
  var peg$e26 = peg$otherExpectation("declaration-specifier");
  var peg$e27 = peg$otherExpectation("x-no-typedef-declaration-specifier");
  var peg$e28 = peg$otherExpectation("init-declarator-list");
  var peg$e29 = peg$otherExpectation("init-declarator");
  var peg$e30 = peg$otherExpectation("x-brace-initializer");
  var peg$e31 = peg$literalExpectation("{", false);
  var peg$e32 = peg$literalExpectation("}", false);
  var peg$e33 = peg$otherExpectation("storage-class-specifier");
  var peg$e34 = peg$literalExpectation("typedef", false);
  var peg$e35 = peg$literalExpectation("extern", false);
  var peg$e36 = peg$literalExpectation("static", false);
  var peg$e37 = peg$literalExpectation("auto", false);
  var peg$e38 = peg$literalExpectation("constexpr", false);
  var peg$e39 = peg$literalExpectation("register", false);
  var peg$e40 = peg$otherExpectation("type-specifier");
  var peg$e41 = peg$otherExpectation("x-no-typedef-type-specifier");
  var peg$e42 = peg$literalExpectation("void", false);
  var peg$e43 = peg$literalExpectation("char", false);
  var peg$e44 = peg$literalExpectation("short", false);
  var peg$e45 = peg$literalExpectation("int", false);
  var peg$e46 = peg$literalExpectation("long", false);
  var peg$e47 = peg$literalExpectation("float", false);
  var peg$e48 = peg$literalExpectation("double", false);
  var peg$e49 = peg$literalExpectation("signed", false);
  var peg$e50 = peg$literalExpectation("unsigned", false);
  var peg$e51 = peg$otherExpectation("struct-or-union-specifier");
  var peg$e52 = peg$literalExpectation("struct", false);
  var peg$e53 = peg$literalExpectation("union", false);
  var peg$e54 = peg$literalExpectation("class", false);
  var peg$e55 = peg$otherExpectation("enum-specifier");
  var peg$e56 = peg$literalExpectation("enum", false);
  var peg$e57 = peg$otherExpectation("atomic-type-specifier");
  var peg$e58 = peg$otherExpectation("type-qualifier");
  var peg$e59 = peg$literalExpectation("const", false);
  var peg$e60 = peg$literalExpectation("restrict", false);
  var peg$e61 = peg$literalExpectation("volatile", false);
  var peg$e62 = peg$otherExpectation("function-specifier");
  var peg$e63 = peg$literalExpectation("inline", false);
  var peg$e64 = peg$otherExpectation("declarator");
  var peg$e65 = peg$otherExpectation("direct-declarator");
  var peg$e66 = peg$otherExpectation("x-scoped-declarator");
  var peg$e67 = peg$otherExpectation("abstract-declarator");
  var peg$e68 = peg$otherExpectation("direct-abstract-declarator");
  var peg$e69 = peg$otherExpectation("x-scoped-abstract-declarator");
  var peg$e70 = peg$otherExpectation("x-postfix");
  var peg$e71 = peg$literalExpectation("*", false);
  var peg$e72 = peg$otherExpectation("x-scope");
  var peg$e73 = peg$classExpectation(["(", "["], false, false);
  var peg$e74 = peg$otherExpectation("x-prefix");
  var peg$e75 = peg$otherExpectation("pointer");
  var peg$e76 = peg$otherExpectation("x-pointer-item");
  var peg$e77 = peg$otherExpectation("x-reference-item");
  var peg$e78 = peg$literalExpectation("&&", false);
  var peg$e79 = peg$literalExpectation("&", false);
  var peg$e80 = peg$otherExpectation("type-qualifier-list");
  var peg$e81 = peg$otherExpectation("x-function-qualifier-list");
  var peg$e82 = peg$otherExpectation("x-override-final");
  var peg$e83 = peg$literalExpectation("override", false);
  var peg$e84 = peg$literalExpectation("final", false);
  var peg$e85 = peg$otherExpectation("parameter-type-list");
  var peg$e86 = peg$literalExpectation("...", false);
  var peg$e87 = peg$otherExpectation("parameter-list");
  var peg$e88 = peg$otherExpectation("parameter-declaration");
  var peg$e89 = peg$otherExpectation("type-name");
  var peg$e90 = peg$otherExpectation("typedef-name");
  var peg$e91 = peg$otherExpectation("specifier-qualifier-list");
  var peg$e92 = peg$otherExpectation("identifier");
  var peg$e93 = peg$classExpectation([["a", "z"], ["A", "Z"], "_"], false, false);
  var peg$e94 = peg$otherExpectation("integer-constant");
  var peg$e95 = peg$otherExpectation("binary-constant");
  var peg$e96 = peg$literalExpectation("0", false);
  var peg$e97 = peg$classExpectation(["b", "B"], false, false);
  var peg$e98 = peg$classExpectation(["0", "1"], false, false);
  var peg$e99 = peg$otherExpectation("hexadecimal-constant");
  var peg$e100 = peg$classExpectation(["x", "X"], false, false);
  var peg$e101 = peg$classExpectation([["0", "9"], ["a", "f"], ["A", "F"]], false, false);
  var peg$e102 = peg$otherExpectation("octal-constant");
  var peg$e103 = peg$classExpectation([["0", "7"]], false, false);
  var peg$e104 = peg$otherExpectation("decimal-constant");
  var peg$e105 = peg$classExpectation([["1", "9"]], false, false);
  var peg$e106 = peg$classExpectation([["0", "9"]], false, false);
  var peg$e107 = peg$otherExpectation("integer-suffix");
  var peg$e108 = peg$classExpectation(["u", "U"], false, false);
  var peg$e109 = peg$classExpectation(["l", "L"], false, false);
  var peg$e110 = peg$otherExpectation("keyword");
  var peg$e111 = peg$literalExpectation("break", false);
  var peg$e112 = peg$literalExpectation("case", false);
  var peg$e113 = peg$literalExpectation("continue", false);
  var peg$e114 = peg$literalExpectation("default", false);
  var peg$e115 = peg$literalExpectation("do", false);
  var peg$e116 = peg$literalExpectation("else", false);
  var peg$e117 = peg$literalExpectation("for", false);
  var peg$e118 = peg$literalExpectation("goto", false);
  var peg$e119 = peg$literalExpectation("if", false);
  var peg$e120 = peg$literalExpectation("return", false);
  var peg$e121 = peg$literalExpectation("sizeof", false);
  var peg$e122 = peg$literalExpectation("switch", false);
  var peg$e123 = peg$literalExpectation("while", false);
  var peg$e124 = peg$literalExpectation("FILE", false);
  var peg$e125 = peg$literalExpectation("_t", false);
  var peg$e126 = peg$literalExpectation("_Alignas", false);
  var peg$e127 = peg$literalExpectation("alignas", false);
  var peg$e128 = peg$literalExpectation("_Alignof", false);
  var peg$e129 = peg$literalExpectation("alignof", false);
  var peg$e130 = peg$literalExpectation("_Atomic", false);
  var peg$e131 = peg$literalExpectation("_Bool", false);
  var peg$e132 = peg$literalExpectation("bool", false);
  var peg$e133 = peg$literalExpectation("_Complex", false);
  var peg$e134 = peg$literalExpectation("complex", false);
  var peg$e135 = peg$literalExpectation("_Generic", false);
  var peg$e136 = peg$literalExpectation("_Imaginary", false);
  var peg$e137 = peg$literalExpectation("imaginary", false);
  var peg$e138 = peg$literalExpectation("_Noreturn", false);
  var peg$e139 = peg$literalExpectation("_Static_assert", false);
  var peg$e140 = peg$literalExpectation("static_assert", false);
  var peg$e141 = peg$literalExpectation("_Thread_local", false);
  var peg$e142 = peg$literalExpectation("thread_local", false);
  var peg$e143 = peg$classExpectation([["a", "z"], ["A", "Z"], ["0", "9"], "_"], false, false);
  var peg$e144 = peg$otherExpectation("comma");
  var peg$e145 = peg$otherExpectation("whitespace");
  var peg$e146 = peg$classExpectation([" ", "\n"], false, false);
  var peg$e147 = peg$otherExpectation("mandatory-whitespace");

  var peg$f0 = function(fname, args) {
      return {
      	  formatArgs: args ?? [],
          functionName: fname
      };
  };
  var peg$f1 = function() {
      return text();
  };
  var peg$f2 = function() {
      return text();
  };
  var peg$f3 = function(head, tail) {
      return reduceRightRecursion(head, tail);
  };
  var peg$f4 = function(value) {
      return {
          typ: "string",
          // use base 64 encoding because PEG.js has issues with
          // string escape characters
          value: btoa(value)
      };
  };
  var peg$f5 = function() {
      return text();
  };
  var peg$f6 = function(expr) {
    return {typ: "expr", value: expr.trim()};
  };
  var peg$f7 = function() {
      return text();
  };
  var peg$f8 = function(head, tail) {
    return reduceRightRecursion(head, tail)
      .filter(x => x !== null);
  };
  var peg$f9 = function(declSpecs, list) {
    return {specifiers: declSpecs, declarators: list};
  };
  var peg$f10 = function(head, tail) {
    return reduceRightRecursion(head, tail);
  };
  var peg$f11 = function(head, tail) {
    return reduceRightRecursion(head, tail);
  };
  var peg$f12 = function(head, tail) {
    return reduceRightRecursion(head, tail);
  };
  var peg$f13 = function(it) {
    return it ? [it] : [[]];
  };
  var peg$f14 = function(decl) {
    return decl;
  };
  var peg$f15 = function(it) {
    return ["storage-class-specifier", it];
  };
  var peg$f16 = function(it) { return ["type-specifier", it]; };
  var peg$f17 = function(kind, id) {
    return ["struct-or-union-specifier", kind, id];
  };
  var peg$f18 = function(kind) {
    return ["struct-or-union-specifier", kind];
  };
  var peg$f19 = function(id) {
      return ["enum-specifier", id];
  };
  var peg$f20 = function(name) {
    return ["atomic-type-specifier", name];
  };
  var peg$f21 = function(it) {
    return ["type-qualifier", it];
  };
  var peg$f22 = function(it) {
    return ["type-qualifier", it];
  };
  var peg$f23 = function(it) {
    return ["function-specifier", it];
  };
  var peg$f24 = function(ptr, decl) {
    return decl.concat(ptr ?? []);
  };
  var peg$f25 = function(scoped, postfix) {
    return scoped.concat(postfix ?? []);
  };
  var peg$f26 = function(scope, id) {
    return [{typ: "id", id: id}].concat(scope ?? []);
  };
  var peg$f27 = function(scope, decl) {
    return decl.concat(scope);
  };
  var peg$f28 = function(decl) {
    return decl;
  };
  var peg$f29 = function(ptr, decl) {
    return decl.concat(ptr ?? []);
  };
  var peg$f30 = function(pre, postfix) {
    return (pre ?? []).concat(postfix);
  };
  var peg$f31 = function(pre) {
    return pre;
  };
  var peg$f32 = function(scope, decl) {
    return decl.concat(scope);
  };
  var peg$f33 = function(decl) {
    return decl;
  };
  var peg$f34 = function(qual, size) {
    const q = qual.map(e => e[1]);
    const s = size ? size[1] : null;
    return {typ: "[]", statik: false, qualifiers: q, size: s};
  };
  var peg$f35 = function(size) {
    return {typ: "[]", statik: false, qualifiers: [], size: size};
  };
  var peg$f36 = function(statik, qual, size) {
    const q = (qual ? qual[0] : []).map(e => e[1]);
    return {typ: "[]", statik: true, qualifiers: q, size: size};
  };
  var peg$f37 = function(qual, statik, size) {
    const q = (qual ?? []).map(e => e[1]);
    return {typ: "[]", statik: true, qualifiers: q, size: size};
  };
  var peg$f38 = function(qual) {
    return {typ: "[*]", qualifiers: (qual ?? []).map(e => e[1])};
  };
  var peg$f39 = function(params, q) {
    return {typ: "()", params: params ?? [], qualifiers: q};
  };
  var peg$f40 = function(head, tail) {
    return [{typ: "::", id: head}].concat(tail
        .map(e => e[1])
        .map(e => ({typ: "::", id: e})))
        .reverse();
  };
  var peg$f41 = function(list) {
    return [].concat(...list.reverse());
  };
  var peg$f42 = function(head) {
    return head.map(e => ({typ: '*', qualifiers: e})).reverse();
  };
  var peg$f43 = function(list) {
    return (list ?? []).map(e => e[1]);
  };
  var peg$f44 = function(it) {
    return {typ: it};
  };
  var peg$f45 = function(head, tail) {
    return reduceRightRecursion(head, tail);
  };
  var peg$f46 = function(cv, ref, virt) {
    return [...(cv ?? []), ref].map(e => e[1])
                       .concat(virt ? [virt[1]] : []);
  };
  var peg$f47 = function(cv, virt) {
    return [...cv].map(e => e[1])
                  .concat(virt ? [virt[1]] : []);
  };
  var peg$f48 = function(it) {
    return it ? [it] : [];
  };
  var peg$f49 = function(it) {
    return it[0];
  };
  var peg$f50 = function(head, ellipsis) {
    return head.concat(ellipsis ? [{typ: "..."}] : []);
  };
  var peg$f51 = function() {
    return [{typ: "..."}];
  };
  var peg$f52 = function(head, tail) {
    return reduceRightRecursion(head, tail);
  };
  var peg$f53 = function(spec, decl) {
    return {typ: "decl", specifiers: spec, declarator: decl ?? []};
  };
  var peg$f54 = function(list, decl) {
    return {specifiers: list, declarator: decl ?? []};
  };
  var peg$f55 = function(id) {
    return ["typedef-name", id];
  };
  var peg$f56 = function(head, tail) {
    return reduceRightRecursion(head, tail);
  };
  var peg$f57 = function() {
      return text();
  };
  var peg$f58 = function(value, typ) {
    return {base: value[0], value: value[1], typ: typ ?? Type.INT};
  };
  var peg$f59 = function(digits) {
    return [2, Number.parseInt(digits, 2)];
  };
  var peg$f60 = function(digits) {
    return [16, Number.parseInt(digits, 16)];
  };
  var peg$f61 = function(digits) {
    return [8, digits ? Number.parseInt(digits, 8) : 0];
  };
  var peg$f62 = function() {
    return [10, Number.parseInt(text(), 10)];
  };
  var peg$f63 = function() {
    const res = text().toLowerCase();
    return res.startsWith('u') || res.endsWith('u') ?
       [Type.UINT, Type.ULONG, Type.ULONG_LONG][res.length - 1] :
       [Type.INT, Type.LONG, Type.LONG_LONG][res.length];
  };
  var peg$f64 = function() { return text(); };
  var peg$f65 = function() { return "alignas"; };
  var peg$f66 = function() { return "alignof"; };
  var peg$f67 = function() { return "bool"; };
  var peg$f68 = function() { return "complex"; };
  var peg$f69 = function() { return "imaginary"; };
  var peg$f70 = function() { return "static_assert"; };
  var peg$f71 = function() { return "thread_local"; };
  var peg$currPos = options.peg$currPos | 0;
  var peg$savedPos = peg$currPos;
  var peg$posDetailsCache = [{ line: 1, column: 1 }];
  var peg$maxFailPos = peg$currPos;
  var peg$maxFailExpected = options.peg$maxFailExpected || [];
  var peg$silentFails = options.peg$silentFails | 0;

  var peg$result;

  if (options.startRule) {
    if (!(options.startRule in peg$startRuleFunctions)) {
      throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
    }

    peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
  }

  function text() {
    return input.substring(peg$savedPos, peg$currPos);
  }

  function offset() {
    return peg$savedPos;
  }

  function range() {
    return {
      source: peg$source,
      start: peg$savedPos,
      end: peg$currPos
    };
  }

  function location() {
    return peg$computeLocation(peg$savedPos, peg$currPos);
  }

  function expected(description, location) {
    location = location !== undefined
      ? location
      : peg$computeLocation(peg$savedPos, peg$currPos);

    throw peg$buildStructuredError(
      [peg$otherExpectation(description)],
      input.substring(peg$savedPos, peg$currPos),
      location
    );
  }

  function error(message, location) {
    location = location !== undefined
      ? location
      : peg$computeLocation(peg$savedPos, peg$currPos);

    throw peg$buildSimpleError(message, location);
  }

  function peg$literalExpectation(text, ignoreCase) {
    return { type: "literal", text: text, ignoreCase: ignoreCase };
  }

  function peg$classExpectation(parts, inverted, ignoreCase) {
    return { type: "class", parts: parts, inverted: inverted, ignoreCase: ignoreCase };
  }

  function peg$anyExpectation() {
    return { type: "any" };
  }

  function peg$endExpectation() {
    return { type: "end" };
  }

  function peg$otherExpectation(description) {
    return { type: "other", description: description };
  }

  function peg$computePosDetails(pos) {
    var details = peg$posDetailsCache[pos];
    var p;

    if (details) {
      return details;
    } else {
      if (pos >= peg$posDetailsCache.length) {
        p = peg$posDetailsCache.length - 1;
      } else {
        p = pos;
        while (!peg$posDetailsCache[--p]) {}
      }

      details = peg$posDetailsCache[p];
      details = {
        line: details.line,
        column: details.column
      };

      while (p < pos) {
        if (input.charCodeAt(p) === 10) {
          details.line++;
          details.column = 1;
        } else {
          details.column++;
        }

        p++;
      }

      peg$posDetailsCache[pos] = details;

      return details;
    }
  }

  function peg$computeLocation(startPos, endPos, offset) {
    var startPosDetails = peg$computePosDetails(startPos);
    var endPosDetails = peg$computePosDetails(endPos);

    var res = {
      source: peg$source,
      start: {
        offset: startPos,
        line: startPosDetails.line,
        column: startPosDetails.column
      },
      end: {
        offset: endPos,
        line: endPosDetails.line,
        column: endPosDetails.column
      }
    };
    if (offset && peg$source && (typeof peg$source.offset === "function")) {
      res.start = peg$source.offset(res.start);
      res.end = peg$source.offset(res.end);
    }
    return res;
  }

  function peg$fail(expected) {
    if (peg$currPos < peg$maxFailPos) { return; }

    if (peg$currPos > peg$maxFailPos) {
      peg$maxFailPos = peg$currPos;
      peg$maxFailExpected = [];
    }

    peg$maxFailExpected.push(expected);
  }

  function peg$buildSimpleError(message, location) {
    return new peg$SyntaxError(message, null, null, location);
  }

  function peg$buildStructuredError(expected, found, location) {
    return new peg$SyntaxError(
      peg$SyntaxError.buildMessage(expected, found),
      expected,
      found,
      location
    );
  }

  function peg$parseMain() {
    var s0;

    s0 = peg$parseXDeclarationList();
    if (s0 === peg$FAILED) {
      s0 = peg$parseFormatCall();
    }

    return s0;
  }

  function peg$parseFormatCall() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseFormatScope();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parsePrintfFunctionName();
    if (s2 === peg$FAILED) {
      s2 = peg$parseScanfFunctionName();
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$parse_();
      if (input.charCodeAt(peg$currPos) === 40) {
        s4 = peg$c0;
        peg$currPos++;
      } else {
        s4 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e1); }
      }
      if (s4 !== peg$FAILED) {
        s5 = peg$parse_();
        s6 = peg$parseFormatArguments();
        if (s6 === peg$FAILED) {
          s6 = null;
        }
        s7 = peg$parse_();
        if (input.charCodeAt(peg$currPos) === 41) {
          s8 = peg$c1;
          peg$currPos++;
        } else {
          s8 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e2); }
        }
        if (s8 !== peg$FAILED) {
          s9 = [];
          s10 = peg$currPos;
          s11 = peg$parse_();
          if (input.charCodeAt(peg$currPos) === 59) {
            s12 = peg$c2;
            peg$currPos++;
          } else {
            s12 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e3); }
          }
          if (s12 !== peg$FAILED) {
            s11 = [s11, s12];
            s10 = s11;
          } else {
            peg$currPos = s10;
            s10 = peg$FAILED;
          }
          while (s10 !== peg$FAILED) {
            s9.push(s10);
            s10 = peg$currPos;
            s11 = peg$parse_();
            if (input.charCodeAt(peg$currPos) === 59) {
              s12 = peg$c2;
              peg$currPos++;
            } else {
              s12 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e3); }
            }
            if (s12 !== peg$FAILED) {
              s11 = [s11, s12];
              s10 = s11;
            } else {
              peg$currPos = s10;
              s10 = peg$FAILED;
            }
          }
          s10 = peg$parse_();
          peg$savedPos = s0;
          s0 = peg$f0(s2, s6);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e0); }
    }

    return s0;
  }

  function peg$parseFormatScope() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8;

    s0 = peg$currPos;
    s1 = peg$parse_();
    s2 = peg$currPos;
    if (input.substr(peg$currPos, 2) === peg$c3) {
      s3 = peg$c3;
      peg$currPos += 2;
    } else {
      s3 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e4); }
    }
    if (s3 === peg$FAILED) {
      s3 = null;
    }
    s4 = peg$parse_();
    if (input.substr(peg$currPos, 3) === peg$c4) {
      s5 = peg$c4;
      peg$currPos += 3;
    } else {
      s5 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e5); }
    }
    if (s5 !== peg$FAILED) {
      s6 = peg$parse_();
      if (input.substr(peg$currPos, 2) === peg$c3) {
        s7 = peg$c3;
        peg$currPos += 2;
      } else {
        s7 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e4); }
      }
      if (s7 !== peg$FAILED) {
        s8 = peg$parse_();
        s3 = [s3, s4, s5, s6, s7, s8];
        s2 = s3;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
    } else {
      peg$currPos = s2;
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      s1 = [s1, s2];
      s0 = s1;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsePrintfFunctionName() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = input.charAt(peg$currPos);
    if (peg$r0.test(s1)) {
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e6); }
    }
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 2) === peg$c5) {
        s1 = peg$c5;
        peg$currPos += 2;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e7); }
      }
    }
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    if (input.substr(peg$currPos, 6) === peg$c6) {
      s2 = peg$c6;
      peg$currPos += 6;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e8); }
    }
    if (s2 !== peg$FAILED) {
      if (input.substr(peg$currPos, 2) === peg$c7) {
        s3 = peg$c7;
        peg$currPos += 2;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e9); }
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f1();
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseScanfFunctionName() {
    var s0, s1, s2;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5) === peg$c8) {
      s1 = peg$c8;
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e10); }
    }
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 6) === peg$c9) {
        s1 = peg$c9;
        peg$currPos += 6;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e11); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c10) {
          s1 = peg$c10;
          peg$currPos += 6;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e12); }
        }
      }
    }
    if (s1 !== peg$FAILED) {
      if (input.substr(peg$currPos, 2) === peg$c7) {
        s2 = peg$c7;
        peg$currPos += 2;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e9); }
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f2();
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseFormatArguments() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseFormatArgument();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse_();
      if (input.charCodeAt(peg$currPos) === 44) {
        s5 = peg$c11;
        peg$currPos++;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e13); }
      }
      if (s5 !== peg$FAILED) {
        s6 = peg$parse_();
        s7 = peg$parseFormatArgument();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse_();
        if (input.charCodeAt(peg$currPos) === 44) {
          s5 = peg$c11;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e13); }
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parse_();
          s7 = peg$parseFormatArgument();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f3(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseFormatArgument() {
    var s0;

    s0 = peg$parseStringLiteral();
    if (s0 === peg$FAILED) {
      s0 = peg$parseFormatArgExpr();
    }

    return s0;
  }

  function peg$parseStringLiteral() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 34) {
      s1 = peg$c12;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e14); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parseStringLiteralContents();
      if (input.charCodeAt(peg$currPos) === 34) {
        s3 = peg$c12;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e14); }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f4(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseStringLiteralContents() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = [];
    if (input.substr(peg$currPos, 2) === peg$c13) {
      s2 = peg$c13;
      peg$currPos += 2;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e15); }
    }
    if (s2 === peg$FAILED) {
      s2 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 92) {
        s3 = peg$c14;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e16); }
      }
      if (s3 !== peg$FAILED) {
        s4 = input.charAt(peg$currPos);
        if (peg$r1.test(s4)) {
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e17); }
        }
        if (s4 !== peg$FAILED) {
          s3 = [s3, s4];
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = input.charAt(peg$currPos);
        if (peg$r1.test(s2)) {
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e17); }
        }
      }
    }
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      if (input.substr(peg$currPos, 2) === peg$c13) {
        s2 = peg$c13;
        peg$currPos += 2;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e15); }
      }
      if (s2 === peg$FAILED) {
        s2 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 92) {
          s3 = peg$c14;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e16); }
        }
        if (s3 !== peg$FAILED) {
          s4 = input.charAt(peg$currPos);
          if (peg$r1.test(s4)) {
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e17); }
          }
          if (s4 !== peg$FAILED) {
            s3 = [s3, s4];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          s2 = input.charAt(peg$currPos);
          if (peg$r1.test(s2)) {
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e17); }
          }
        }
      }
    }
    peg$savedPos = s0;
    s1 = peg$f5();
    s0 = s1;

    return s0;
  }

  function peg$parseFormatArgExpr() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseUnaryExpr();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f6(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parseUnaryExpr() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parsePrefixExpr();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f7();
    }
    s0 = s1;

    return s0;
  }

  function peg$parseParenthesizedExpr() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (input.charCodeAt(peg$currPos) === 40) {
      s2 = peg$c0;
      peg$currPos++;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e1); }
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$parseUnaryExpr();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse_();
        if (input.charCodeAt(peg$currPos) === 41) {
          s5 = peg$c1;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e2); }
        }
        if (s5 !== peg$FAILED) {
          s1 = [s1, s2, s3, s4, s5];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsePrefixExpr() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10;

    s0 = peg$currPos;
    s1 = peg$parse_();
    s2 = [];
    s3 = peg$currPos;
    s4 = peg$parse_();
    if (input.substr(peg$currPos, 2) === peg$c15) {
      s5 = peg$c15;
      peg$currPos += 2;
    } else {
      s5 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e18); }
    }
    if (s5 === peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 43) {
        s5 = peg$c16;
        peg$currPos++;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e19); }
      }
      if (s5 === peg$FAILED) {
        if (input.substr(peg$currPos, 2) === peg$c17) {
          s5 = peg$c17;
          peg$currPos += 2;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e20); }
        }
        if (s5 === peg$FAILED) {
          s5 = input.charAt(peg$currPos);
          if (peg$r2.test(s5)) {
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e21); }
          }
          if (s5 === peg$FAILED) {
            s5 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 40) {
              s6 = peg$c0;
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e1); }
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parseDeclarationSpecifiers();
              if (s7 !== peg$FAILED) {
                s8 = peg$parseAbstractDeclarator();
                if (s8 === peg$FAILED) {
                  s8 = null;
                }
                s9 = peg$parse_();
                if (input.charCodeAt(peg$currPos) === 41) {
                  s10 = peg$c1;
                  peg$currPos++;
                } else {
                  s10 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e2); }
                }
                if (s10 !== peg$FAILED) {
                  s6 = [s6, s7, s8, s9, s10];
                  s5 = s6;
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          }
        }
      }
    }
    if (s5 !== peg$FAILED) {
      s4 = [s4, s5];
      s3 = s4;
    } else {
      peg$currPos = s3;
      s3 = peg$FAILED;
    }
    while (s3 !== peg$FAILED) {
      s2.push(s3);
      s3 = peg$currPos;
      s4 = peg$parse_();
      if (input.substr(peg$currPos, 2) === peg$c15) {
        s5 = peg$c15;
        peg$currPos += 2;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e18); }
      }
      if (s5 === peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 43) {
          s5 = peg$c16;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e19); }
        }
        if (s5 === peg$FAILED) {
          if (input.substr(peg$currPos, 2) === peg$c17) {
            s5 = peg$c17;
            peg$currPos += 2;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e20); }
          }
          if (s5 === peg$FAILED) {
            s5 = input.charAt(peg$currPos);
            if (peg$r2.test(s5)) {
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e21); }
            }
            if (s5 === peg$FAILED) {
              s5 = peg$currPos;
              if (input.charCodeAt(peg$currPos) === 40) {
                s6 = peg$c0;
                peg$currPos++;
              } else {
                s6 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e1); }
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseDeclarationSpecifiers();
                if (s7 !== peg$FAILED) {
                  s8 = peg$parseAbstractDeclarator();
                  if (s8 === peg$FAILED) {
                    s8 = null;
                  }
                  s9 = peg$parse_();
                  if (input.charCodeAt(peg$currPos) === 41) {
                    s10 = peg$c1;
                    peg$currPos++;
                  } else {
                    s10 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e2); }
                  }
                  if (s10 !== peg$FAILED) {
                    s6 = [s6, s7, s8, s9, s10];
                    s5 = s6;
                  } else {
                    peg$currPos = s5;
                    s5 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            }
          }
        }
      }
      if (s5 !== peg$FAILED) {
        s4 = [s4, s5];
        s3 = s4;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
    }
    s3 = peg$parsePostfixExpr();
    if (s3 !== peg$FAILED) {
      s1 = [s1, s2, s3];
      s0 = s1;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsePostfixExpr() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parsePrimaryExpr();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse_();
      s5 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 40) {
        s6 = peg$c0;
        peg$currPos++;
      } else {
        s6 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e1); }
      }
      if (s6 !== peg$FAILED) {
        s7 = peg$parseUnaryExpr();
        if (s7 !== peg$FAILED) {
          s8 = peg$parse_();
          if (input.charCodeAt(peg$currPos) === 41) {
            s9 = peg$c1;
            peg$currPos++;
          } else {
            s9 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e2); }
          }
          if (s9 !== peg$FAILED) {
            s6 = [s6, s7, s8, s9];
            s5 = s6;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
      } else {
        peg$currPos = s5;
        s5 = peg$FAILED;
      }
      if (s5 === peg$FAILED) {
        s5 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 91) {
          s6 = peg$c18;
          peg$currPos++;
        } else {
          s6 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e22); }
        }
        if (s6 !== peg$FAILED) {
          s7 = peg$parseUnaryExpr();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse_();
            if (input.charCodeAt(peg$currPos) === 93) {
              s9 = peg$c19;
              peg$currPos++;
            } else {
              s9 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e23); }
            }
            if (s9 !== peg$FAILED) {
              s6 = [s6, s7, s8, s9];
              s5 = s6;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        if (s5 === peg$FAILED) {
          if (input.substr(peg$currPos, 2) === peg$c15) {
            s5 = peg$c15;
            peg$currPos += 2;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e18); }
          }
          if (s5 === peg$FAILED) {
            if (input.substr(peg$currPos, 2) === peg$c17) {
              s5 = peg$c17;
              peg$currPos += 2;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e20); }
            }
          }
        }
      }
      if (s5 !== peg$FAILED) {
        s4 = [s4, s5];
        s3 = s4;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse_();
        s5 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 40) {
          s6 = peg$c0;
          peg$currPos++;
        } else {
          s6 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e1); }
        }
        if (s6 !== peg$FAILED) {
          s7 = peg$parseUnaryExpr();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse_();
            if (input.charCodeAt(peg$currPos) === 41) {
              s9 = peg$c1;
              peg$currPos++;
            } else {
              s9 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e2); }
            }
            if (s9 !== peg$FAILED) {
              s6 = [s6, s7, s8, s9];
              s5 = s6;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        if (s5 === peg$FAILED) {
          s5 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 91) {
            s6 = peg$c18;
            peg$currPos++;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e22); }
          }
          if (s6 !== peg$FAILED) {
            s7 = peg$parseUnaryExpr();
            if (s7 !== peg$FAILED) {
              s8 = peg$parse_();
              if (input.charCodeAt(peg$currPos) === 93) {
                s9 = peg$c19;
                peg$currPos++;
              } else {
                s9 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e23); }
              }
              if (s9 !== peg$FAILED) {
                s6 = [s6, s7, s8, s9];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          if (s5 === peg$FAILED) {
            if (input.substr(peg$currPos, 2) === peg$c15) {
              s5 = peg$c15;
              peg$currPos += 2;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e18); }
            }
            if (s5 === peg$FAILED) {
              if (input.substr(peg$currPos, 2) === peg$c17) {
                s5 = peg$c17;
                peg$currPos += 2;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e20); }
              }
            }
          }
        }
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      s1 = [s1, s2];
      s0 = s1;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsePrimaryExpr() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parse_();
    s2 = peg$parseIdentifier();
    if (s2 !== peg$FAILED) {
      s1 = [s1, s2];
      s0 = s1;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parse_();
      s2 = peg$parseIntegerConstant();
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parse_();
        if (input.charCodeAt(peg$currPos) === 40) {
          s2 = peg$c0;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e1); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseUnaryExpr();
          if (s3 !== peg$FAILED) {
            s4 = peg$parse_();
            if (input.charCodeAt(peg$currPos) === 41) {
              s5 = peg$c1;
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e2); }
            }
            if (s5 !== peg$FAILED) {
              s1 = [s1, s2, s3, s4, s5];
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parseXDeclarationList() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseDeclaration();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse_();
      if (input.charCodeAt(peg$currPos) === 59) {
        s5 = peg$c2;
        peg$currPos++;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e3); }
      }
      if (s5 !== peg$FAILED) {
        s6 = peg$parse_();
        s7 = peg$parseDeclaration();
        if (s7 === peg$FAILED) {
          s7 = null;
        }
        s4 = [s4, s5, s6, s7];
        s3 = s4;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse_();
        if (input.charCodeAt(peg$currPos) === 59) {
          s5 = peg$c2;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e3); }
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parse_();
          s7 = peg$parseDeclaration();
          if (s7 === peg$FAILED) {
            s7 = null;
          }
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f8(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseDeclaration() {
    var s0, s1, s2, s3;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseDeclarationSpecifiers();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse_();
      s3 = peg$parseInitDeclaratorList();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f9(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e24); }
    }

    return s0;
  }

  function peg$parseDeclarationSpecifiers() {
    var s0, s1, s2, s3, s4, s5;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseTypedefName();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      if (s4 !== peg$FAILED) {
        s5 = peg$parseXNoTypedefDeclarationSpecifier();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        if (s4 !== peg$FAILED) {
          s5 = peg$parseXNoTypedefDeclarationSpecifier();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f10(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseDeclarationSpecifier();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        s4 = peg$parse__();
        if (s4 !== peg$FAILED) {
          s5 = peg$parseDeclarationSpecifier();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = peg$parse__();
          if (s4 !== peg$FAILED) {
            s5 = peg$parseDeclarationSpecifier();
            if (s5 !== peg$FAILED) {
              s4 = [s4, s5];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
        peg$savedPos = s0;
        s0 = peg$f11(s1, s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e25); }
    }

    return s0;
  }

  function peg$parseDeclarationSpecifier() {
    var s0, s1;

    peg$silentFails++;
    s0 = peg$parseXNoTypedefDeclarationSpecifier();
    if (s0 === peg$FAILED) {
      s0 = peg$parseTypedefName();
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e26); }
    }

    return s0;
  }

  function peg$parseXNoTypedefDeclarationSpecifier() {
    var s0, s1;

    peg$silentFails++;
    s0 = peg$parseStorageClassSpecifier();
    if (s0 === peg$FAILED) {
      s0 = peg$parseXNoTypedefTypeSpecifier();
      if (s0 === peg$FAILED) {
        s0 = peg$parseTypeQualifier();
        if (s0 === peg$FAILED) {
          s0 = peg$parseFunctionSpecifier();
        }
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e27); }
    }

    return s0;
  }

  function peg$parseInitDeclaratorList() {
    var s0, s1, s2, s3, s4, s5;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseInitDeclarator();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parseComma();
      if (s4 !== peg$FAILED) {
        s5 = peg$parseInitDeclarator();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parseComma();
        if (s4 !== peg$FAILED) {
          s5 = peg$parseInitDeclarator();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f12(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseAbstractDeclarator();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      peg$savedPos = s0;
      s1 = peg$f13(s1);
      s0 = s1;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e28); }
    }

    return s0;
  }

  function peg$parseInitDeclarator() {
    var s0, s1, s2;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseDeclarator();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseXBraceInitializer();
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f14(s1);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e29); }
    }

    return s0;
  }

  function peg$parseXBraceInitializer() {
    var s0, s1, s2, s3, s4;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parse_();
    if (input.charCodeAt(peg$currPos) === 123) {
      s2 = peg$c20;
      peg$currPos++;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e31); }
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$parse_();
      if (input.charCodeAt(peg$currPos) === 125) {
        s4 = peg$c21;
        peg$currPos++;
      } else {
        s4 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e32); }
      }
      if (s4 !== peg$FAILED) {
        s1 = [s1, s2, s3, s4];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e30); }
    }

    return s0;
  }

  function peg$parseStorageClassSpecifier() {
    var s0, s1, s2, s3;

    peg$silentFails++;
    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7) === peg$c22) {
      s1 = peg$c22;
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e34); }
    }
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 6) === peg$c23) {
        s1 = peg$c23;
        peg$currPos += 6;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e35); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c24) {
          s1 = peg$c24;
          peg$currPos += 6;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e36); }
        }
        if (s1 === peg$FAILED) {
          s1 = peg$parseThreadLocalKeyword();
          if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 4) === peg$c25) {
              s1 = peg$c25;
              peg$currPos += 4;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e37); }
            }
            if (s1 === peg$FAILED) {
              if (input.substr(peg$currPos, 9) === peg$c26) {
                s1 = peg$c26;
                peg$currPos += 9;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e38); }
              }
              if (s1 === peg$FAILED) {
                if (input.substr(peg$currPos, 8) === peg$c27) {
                  s1 = peg$c27;
                  peg$currPos += 8;
                } else {
                  s1 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e39); }
                }
              }
            }
          }
        }
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseWordChar();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f15(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e33); }
    }

    return s0;
  }

  function peg$parseTypeSpecifier() {
    var s0, s1;

    peg$silentFails++;
    s0 = peg$parseXNoTypedefTypeSpecifier();
    if (s0 === peg$FAILED) {
      s0 = peg$parseTypedefName();
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e40); }
    }

    return s0;
  }

  function peg$parseXNoTypedefTypeSpecifier() {
    var s0, s1, s2, s3;

    peg$silentFails++;
    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4) === peg$c28) {
      s1 = peg$c28;
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e42); }
    }
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 4) === peg$c29) {
        s1 = peg$c29;
        peg$currPos += 4;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e43); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 5) === peg$c30) {
          s1 = peg$c30;
          peg$currPos += 5;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e44); }
        }
        if (s1 === peg$FAILED) {
          if (input.substr(peg$currPos, 3) === peg$c31) {
            s1 = peg$c31;
            peg$currPos += 3;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e45); }
          }
          if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 4) === peg$c32) {
              s1 = peg$c32;
              peg$currPos += 4;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e46); }
            }
            if (s1 === peg$FAILED) {
              if (input.substr(peg$currPos, 5) === peg$c33) {
                s1 = peg$c33;
                peg$currPos += 5;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e47); }
              }
              if (s1 === peg$FAILED) {
                if (input.substr(peg$currPos, 6) === peg$c34) {
                  s1 = peg$c34;
                  peg$currPos += 6;
                } else {
                  s1 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e48); }
                }
                if (s1 === peg$FAILED) {
                  if (input.substr(peg$currPos, 6) === peg$c35) {
                    s1 = peg$c35;
                    peg$currPos += 6;
                  } else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e49); }
                  }
                  if (s1 === peg$FAILED) {
                    if (input.substr(peg$currPos, 8) === peg$c36) {
                      s1 = peg$c36;
                      peg$currPos += 8;
                    } else {
                      s1 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$e50); }
                    }
                    if (s1 === peg$FAILED) {
                      s1 = peg$parseComplexKeyword();
                      if (s1 === peg$FAILED) {
                        s1 = peg$parseBoolKeyword();
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseWordChar();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f16(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseAtomicTypeSpecifier();
      if (s0 === peg$FAILED) {
        s0 = peg$parseStructOrUnionSpecifier();
        if (s0 === peg$FAILED) {
          s0 = peg$parseEnumSpecifier();
        }
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e41); }
    }

    return s0;
  }

  function peg$parseStructOrUnionSpecifier() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$currPos;
    if (input.substr(peg$currPos, 6) === peg$c37) {
      s2 = peg$c37;
      peg$currPos += 6;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e52); }
    }
    if (s2 === peg$FAILED) {
      if (input.substr(peg$currPos, 5) === peg$c38) {
        s2 = peg$c38;
        peg$currPos += 5;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e53); }
      }
      if (s2 === peg$FAILED) {
        if (input.substr(peg$currPos, 5) === peg$c39) {
          s2 = peg$c39;
          peg$currPos += 5;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e54); }
        }
      }
    }
    if (s2 !== peg$FAILED) {
      s1 = input.substring(s1, peg$currPos);
    } else {
      s1 = s2;
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseIdentifier();
        if (s3 !== peg$FAILED) {
          s4 = peg$currPos;
          peg$silentFails++;
          s5 = peg$parseWordChar();
          peg$silentFails--;
          if (s5 === peg$FAILED) {
            s4 = undefined;
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$currPos;
            s6 = peg$parse_();
            if (input.charCodeAt(peg$currPos) === 123) {
              s7 = peg$c20;
              peg$currPos++;
            } else {
              s7 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e31); }
            }
            if (s7 !== peg$FAILED) {
              s8 = peg$parse_();
              if (input.charCodeAt(peg$currPos) === 125) {
                s9 = peg$c21;
                peg$currPos++;
              } else {
                s9 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e32); }
              }
              if (s9 !== peg$FAILED) {
                s6 = [s6, s7, s8, s9];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            if (s5 === peg$FAILED) {
              s5 = null;
            }
            peg$savedPos = s0;
            s0 = peg$f17(s1, s3);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$currPos;
      if (input.substr(peg$currPos, 6) === peg$c37) {
        s2 = peg$c37;
        peg$currPos += 6;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e52); }
      }
      if (s2 === peg$FAILED) {
        if (input.substr(peg$currPos, 5) === peg$c38) {
          s2 = peg$c38;
          peg$currPos += 5;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e53); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 5) === peg$c39) {
            s2 = peg$c39;
            peg$currPos += 5;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e54); }
          }
        }
      }
      if (s2 !== peg$FAILED) {
        s1 = input.substring(s1, peg$currPos);
      } else {
        s1 = s2;
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse_();
        if (input.charCodeAt(peg$currPos) === 123) {
          s3 = peg$c20;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e31); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parse_();
          if (input.charCodeAt(peg$currPos) === 125) {
            s5 = peg$c21;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e32); }
          }
          if (s5 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f18(s1);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e51); }
    }

    return s0;
  }

  function peg$parseEnumSpecifier() {
    var s0, s1, s2, s3, s4, s5;

    peg$silentFails++;
    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4) === peg$c40) {
      s1 = peg$c40;
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e56); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseIdentifier();
        if (s3 !== peg$FAILED) {
          s4 = peg$currPos;
          peg$silentFails++;
          s5 = peg$parseWordChar();
          peg$silentFails--;
          if (s5 === peg$FAILED) {
            s4 = undefined;
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          if (s4 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f19(s3);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e55); }
    }

    return s0;
  }

  function peg$parseAtomicTypeSpecifier() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseAtomicKeyword();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse_();
      if (input.charCodeAt(peg$currPos) === 40) {
        s3 = peg$c0;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e1); }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse_();
        s5 = peg$parseTypeName();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse_();
          if (input.charCodeAt(peg$currPos) === 41) {
            s7 = peg$c1;
            peg$currPos++;
          } else {
            s7 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e2); }
          }
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f20(s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e57); }
    }

    return s0;
  }

  function peg$parseTypeQualifier() {
    var s0, s1, s2, s3, s4, s5;

    peg$silentFails++;
    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5) === peg$c41) {
      s1 = peg$c41;
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e59); }
    }
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 8) === peg$c42) {
        s1 = peg$c42;
        peg$currPos += 8;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e60); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 8) === peg$c43) {
          s1 = peg$c43;
          peg$currPos += 8;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e61); }
        }
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseWordChar();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f21(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseAtomicKeyword();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        peg$silentFails++;
        s3 = peg$currPos;
        s4 = peg$parse_();
        if (input.charCodeAt(peg$currPos) === 40) {
          s5 = peg$c0;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e1); }
        }
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = peg$parseWordChar();
        }
        peg$silentFails--;
        if (s3 === peg$FAILED) {
          s2 = undefined;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f22(s1);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e58); }
    }

    return s0;
  }

  function peg$parseFunctionSpecifier() {
    var s0, s1, s2, s3;

    peg$silentFails++;
    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6) === peg$c44) {
      s1 = peg$c44;
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e63); }
    }
    if (s1 === peg$FAILED) {
      s1 = peg$parseNoreturnKeyword();
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseWordChar();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f23(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e62); }
    }

    return s0;
  }

  function peg$parseDeclarator() {
    var s0, s1, s2, s3;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseXPrefix();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse_();
    s3 = peg$parseDirectDeclarator();
    if (s3 !== peg$FAILED) {
      peg$savedPos = s0;
      s0 = peg$f24(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e64); }
    }

    return s0;
  }

  function peg$parseDirectDeclarator() {
    var s0, s1, s2, s3, s4;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseXScopedDeclarator();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse_();
      s3 = [];
      s4 = peg$parseXPostfix();
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = peg$parseXPostfix();
      }
      peg$savedPos = s0;
      s0 = peg$f25(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e65); }
    }

    return s0;
  }

  function peg$parseXScopedDeclarator() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseXScope();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse_();
    s3 = peg$parseIdentifier();
    if (s3 !== peg$FAILED) {
      s4 = peg$currPos;
      peg$silentFails++;
      s5 = peg$currPos;
      s6 = peg$parse_();
      if (input.substr(peg$currPos, 2) === peg$c3) {
        s7 = peg$c3;
        peg$currPos += 2;
      } else {
        s7 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e4); }
      }
      if (s7 !== peg$FAILED) {
        s6 = [s6, s7];
        s5 = s6;
      } else {
        peg$currPos = s5;
        s5 = peg$FAILED;
      }
      peg$silentFails--;
      if (s5 === peg$FAILED) {
        s4 = undefined;
      } else {
        peg$currPos = s4;
        s4 = peg$FAILED;
      }
      if (s4 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f26(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseXScope();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse_();
        s3 = peg$parseDeclarator();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f27(s1, s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parse_();
        if (input.charCodeAt(peg$currPos) === 40) {
          s2 = peg$c0;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e1); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parse_();
          s4 = peg$parseDeclarator();
          if (s4 !== peg$FAILED) {
            s5 = peg$parse_();
            if (input.charCodeAt(peg$currPos) === 41) {
              s6 = peg$c1;
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e2); }
            }
            if (s6 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f28(s4);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e66); }
    }

    return s0;
  }

  function peg$parseAbstractDeclarator() {
    var s0, s1, s2, s3;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseXPrefix();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse_();
    s3 = peg$parseDirectAbstractDeclarator();
    if (s3 !== peg$FAILED) {
      peg$savedPos = s0;
      s0 = peg$f29(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseXPrefix();
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e67); }
    }

    return s0;
  }

  function peg$parseDirectAbstractDeclarator() {
    var s0, s1, s2, s3;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseXScopedAbstractDeclarator();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = [];
    s3 = peg$parseXPostfix();
    if (s3 !== peg$FAILED) {
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseXPostfix();
      }
    } else {
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      peg$savedPos = s0;
      s0 = peg$f30(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseXScopedAbstractDeclarator();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f31(s1);
      }
      s0 = s1;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e68); }
    }

    return s0;
  }

  function peg$parseXScopedAbstractDeclarator() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseXScope();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse_();
      s3 = peg$parseAbstractDeclarator();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f32(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parse_();
      if (input.charCodeAt(peg$currPos) === 40) {
        s2 = peg$c0;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e1); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parse_();
        s4 = peg$parseAbstractDeclarator();
        if (s4 !== peg$FAILED) {
          s5 = peg$parse_();
          if (input.charCodeAt(peg$currPos) === 41) {
            s6 = peg$c1;
            peg$currPos++;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e2); }
          }
          if (s6 !== peg$FAILED) {
            s7 = peg$parse_();
            peg$savedPos = s0;
            s0 = peg$f33(s4);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e69); }
    }

    return s0;
  }

  function peg$parseXPostfix() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parse_();
    if (input.charCodeAt(peg$currPos) === 91) {
      s2 = peg$c18;
      peg$currPos++;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e22); }
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$parse_();
      s4 = peg$parseTypeQualifierList();
      if (s4 !== peg$FAILED) {
        s5 = peg$currPos;
        s6 = peg$parse__();
        if (s6 !== peg$FAILED) {
          s7 = peg$parseIntegerConstant();
          if (s7 !== peg$FAILED) {
            s6 = [s6, s7];
            s5 = s6;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        s6 = peg$parse_();
        if (input.charCodeAt(peg$currPos) === 93) {
          s7 = peg$c19;
          peg$currPos++;
        } else {
          s7 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e23); }
        }
        if (s7 !== peg$FAILED) {
          s8 = peg$parse_();
          peg$savedPos = s0;
          s0 = peg$f34(s4, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parse_();
      if (input.charCodeAt(peg$currPos) === 91) {
        s2 = peg$c18;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e22); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parse_();
        s4 = peg$parseIntegerConstant();
        if (s4 === peg$FAILED) {
          s4 = null;
        }
        s5 = peg$parse_();
        if (input.charCodeAt(peg$currPos) === 93) {
          s6 = peg$c19;
          peg$currPos++;
        } else {
          s6 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e23); }
        }
        if (s6 !== peg$FAILED) {
          s7 = peg$parse_();
          peg$savedPos = s0;
          s0 = peg$f35(s4);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parse_();
        if (input.charCodeAt(peg$currPos) === 91) {
          s2 = peg$c18;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e22); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parse_();
          s4 = peg$currPos;
          if (input.substr(peg$currPos, 6) === peg$c24) {
            s5 = peg$c24;
            peg$currPos += 6;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e36); }
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            if (s6 !== peg$FAILED) {
              s5 = [s5, s6];
              s4 = s5;
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$currPos;
            s6 = peg$parseTypeQualifierList();
            if (s6 !== peg$FAILED) {
              s7 = peg$parse__();
              if (s7 !== peg$FAILED) {
                s6 = [s6, s7];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            if (s5 === peg$FAILED) {
              s5 = null;
            }
            s6 = peg$parseIntegerConstant();
            if (s6 !== peg$FAILED) {
              s7 = peg$parse_();
              if (input.charCodeAt(peg$currPos) === 93) {
                s8 = peg$c19;
                peg$currPos++;
              } else {
                s8 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e23); }
              }
              if (s8 !== peg$FAILED) {
                s9 = peg$parse_();
                peg$savedPos = s0;
                s0 = peg$f36(s4, s5, s6);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$parse_();
          if (input.charCodeAt(peg$currPos) === 91) {
            s2 = peg$c18;
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e22); }
          }
          if (s2 !== peg$FAILED) {
            s3 = peg$parse_();
            s4 = peg$parseTypeQualifierList();
            if (s4 !== peg$FAILED) {
              s5 = peg$parse__();
              if (s5 !== peg$FAILED) {
                s6 = peg$currPos;
                if (input.substr(peg$currPos, 6) === peg$c24) {
                  s7 = peg$c24;
                  peg$currPos += 6;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e36); }
                }
                if (s7 !== peg$FAILED) {
                  s8 = peg$parse__();
                  if (s8 !== peg$FAILED) {
                    s7 = [s7, s8];
                    s6 = s7;
                  } else {
                    peg$currPos = s6;
                    s6 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
                if (s6 !== peg$FAILED) {
                  s7 = peg$parseIntegerConstant();
                  if (s7 !== peg$FAILED) {
                    s8 = peg$parse_();
                    if (input.charCodeAt(peg$currPos) === 93) {
                      s9 = peg$c19;
                      peg$currPos++;
                    } else {
                      s9 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$e23); }
                    }
                    if (s9 !== peg$FAILED) {
                      s10 = peg$parse_();
                      peg$savedPos = s0;
                      s0 = peg$f37(s4, s6, s7);
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parse_();
            if (input.charCodeAt(peg$currPos) === 91) {
              s2 = peg$c18;
              peg$currPos++;
            } else {
              s2 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e22); }
            }
            if (s2 !== peg$FAILED) {
              s3 = peg$parse_();
              s4 = peg$parseTypeQualifierList();
              if (s4 === peg$FAILED) {
                s4 = null;
              }
              s5 = peg$parse_();
              if (input.charCodeAt(peg$currPos) === 42) {
                s6 = peg$c45;
                peg$currPos++;
              } else {
                s6 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e71); }
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parse_();
                if (input.charCodeAt(peg$currPos) === 93) {
                  s8 = peg$c19;
                  peg$currPos++;
                } else {
                  s8 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e23); }
                }
                if (s8 !== peg$FAILED) {
                  s9 = peg$parse_();
                  peg$savedPos = s0;
                  s0 = peg$f38(s4);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              s1 = peg$parse_();
              if (input.charCodeAt(peg$currPos) === 40) {
                s2 = peg$c0;
                peg$currPos++;
              } else {
                s2 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e1); }
              }
              if (s2 !== peg$FAILED) {
                s3 = peg$parse_();
                s4 = peg$parseParameterTypeList();
                if (s4 === peg$FAILED) {
                  s4 = null;
                }
                s5 = peg$parse_();
                if (input.charCodeAt(peg$currPos) === 41) {
                  s6 = peg$c1;
                  peg$currPos++;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e2); }
                }
                if (s6 !== peg$FAILED) {
                  s7 = peg$parse_();
                  s8 = peg$parseFunctionQualifierList();
                  if (s8 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s0 = peg$f39(s4, s8);
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            }
          }
        }
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e70); }
    }

    return s0;
  }

  function peg$parseXScope() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseIdentifier();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse_();
    if (input.substr(peg$currPos, 2) === peg$c3) {
      s3 = peg$c3;
      peg$currPos += 2;
    } else {
      s3 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e4); }
    }
    if (s3 !== peg$FAILED) {
      s4 = [];
      s5 = peg$currPos;
      s6 = peg$parse_();
      s7 = peg$parseIdentifier();
      if (s7 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2) === peg$c3) {
          s8 = peg$c3;
          peg$currPos += 2;
        } else {
          s8 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e4); }
        }
        if (s8 !== peg$FAILED) {
          s6 = [s6, s7, s8];
          s5 = s6;
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
      } else {
        peg$currPos = s5;
        s5 = peg$FAILED;
      }
      while (s5 !== peg$FAILED) {
        s4.push(s5);
        s5 = peg$currPos;
        s6 = peg$parse_();
        s7 = peg$parseIdentifier();
        if (s7 !== peg$FAILED) {
          if (input.substr(peg$currPos, 2) === peg$c3) {
            s8 = peg$c3;
            peg$currPos += 2;
          } else {
            s8 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e4); }
          }
          if (s8 !== peg$FAILED) {
            s6 = [s6, s7, s8];
            s5 = s6;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
      }
      s5 = peg$currPos;
      peg$silentFails++;
      s6 = peg$currPos;
      s7 = peg$parse_();
      s8 = input.charAt(peg$currPos);
      if (peg$r3.test(s8)) {
        peg$currPos++;
      } else {
        s8 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e73); }
      }
      if (s8 !== peg$FAILED) {
        s7 = [s7, s8];
        s6 = s7;
      } else {
        peg$currPos = s6;
        s6 = peg$FAILED;
      }
      peg$silentFails--;
      if (s6 === peg$FAILED) {
        s5 = undefined;
      } else {
        peg$currPos = s5;
        s5 = peg$FAILED;
      }
      if (s5 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f40(s1, s4);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e72); }
    }

    return s0;
  }

  function peg$parseXPrefix() {
    var s0, s1, s2;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parsePointer();
    if (s2 === peg$FAILED) {
      s2 = peg$parseXReferenceItem();
    }
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parsePointer();
        if (s2 === peg$FAILED) {
          s2 = peg$parseXReferenceItem();
        }
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f41(s1);
    }
    s0 = s1;
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e74); }
    }

    return s0;
  }

  function peg$parsePointer() {
    var s0, s1, s2;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseXPointerItem();
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseXPointerItem();
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f42(s1);
    }
    s0 = s1;
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e75); }
    }

    return s0;
  }

  function peg$parseXPointerItem() {
    var s0, s1, s2, s3, s4;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parse_();
    if (input.charCodeAt(peg$currPos) === 42) {
      s2 = peg$c45;
      peg$currPos++;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e71); }
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$parse_();
      s4 = peg$parseTypeQualifierList();
      if (s4 === peg$FAILED) {
        s4 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f43(s4);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e76); }
    }

    return s0;
  }

  function peg$parseXReferenceItem() {
    var s0, s1, s2, s3;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parse_();
    if (input.substr(peg$currPos, 2) === peg$c46) {
      s2 = peg$c46;
      peg$currPos += 2;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e78); }
    }
    if (s2 === peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 38) {
        s2 = peg$c47;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e79); }
      }
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$parse_();
      peg$savedPos = s0;
      s0 = peg$f44(s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e77); }
    }

    return s0;
  }

  function peg$parseTypeQualifierList() {
    var s0, s1, s2, s3, s4, s5;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseTypeQualifier();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      if (s4 !== peg$FAILED) {
        s5 = peg$parseTypeQualifier();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        if (s4 !== peg$FAILED) {
          s5 = peg$parseTypeQualifier();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f45(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e80); }
    }

    return s0;
  }

  function peg$parseFunctionQualifierList() {
    var s0, s1, s2, s3, s4, s5;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseTypeQualifierList();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$currPos;
    s3 = peg$parse_();
    if (input.substr(peg$currPos, 2) === peg$c46) {
      s4 = peg$c46;
      peg$currPos += 2;
    } else {
      s4 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e78); }
    }
    if (s4 !== peg$FAILED) {
      s3 = [s3, s4];
      s2 = s3;
    } else {
      peg$currPos = s2;
      s2 = peg$FAILED;
    }
    if (s2 === peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$parse_();
      if (input.charCodeAt(peg$currPos) === 38) {
        s4 = peg$c47;
        peg$currPos++;
      } else {
        s4 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e79); }
      }
      if (s4 !== peg$FAILED) {
        s3 = [s3, s4];
        s2 = s3;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$currPos;
      s4 = peg$parse_();
      s5 = peg$parseOverrideFinal();
      if (s5 !== peg$FAILED) {
        s4 = [s4, s5];
        s3 = s4;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f46(s1, s2, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseTypeQualifierList();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        s3 = peg$parse__();
        if (s3 !== peg$FAILED) {
          s4 = peg$parseOverrideFinal();
          if (s4 !== peg$FAILED) {
            s3 = [s3, s4];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f47(s1, s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseOverrideFinal();
        if (s1 === peg$FAILED) {
          s1 = null;
        }
        peg$savedPos = s0;
        s1 = peg$f48(s1);
        s0 = s1;
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e81); }
    }

    return s0;
  }

  function peg$parseOverrideFinal() {
    var s0, s1, s2, s3, s4;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$currPos;
    if (input.substr(peg$currPos, 8) === peg$c48) {
      s2 = peg$c48;
      peg$currPos += 8;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e83); }
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$currPos;
      peg$silentFails++;
      s4 = peg$parseWordChar();
      peg$silentFails--;
      if (s4 === peg$FAILED) {
        s3 = undefined;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        s2 = [s2, s3];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 === peg$FAILED) {
      s1 = peg$currPos;
      if (input.substr(peg$currPos, 5) === peg$c49) {
        s2 = peg$c49;
        peg$currPos += 5;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e84); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$currPos;
        peg$silentFails++;
        s4 = peg$parseWordChar();
        peg$silentFails--;
        if (s4 === peg$FAILED) {
          s3 = undefined;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          s2 = [s2, s3];
          s1 = s2;
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f49(s1);
    }
    s0 = s1;
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e82); }
    }

    return s0;
  }

  function peg$parseParameterTypeList() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseParameterList();
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$parse_();
      if (input.charCodeAt(peg$currPos) === 44) {
        s4 = peg$c11;
        peg$currPos++;
      } else {
        s4 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e13); }
      }
      if (s4 === peg$FAILED) {
        s4 = null;
      }
      s5 = peg$parse_();
      if (input.substr(peg$currPos, 3) === peg$c50) {
        s6 = peg$c50;
        peg$currPos += 3;
      } else {
        s6 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e86); }
      }
      if (s6 !== peg$FAILED) {
        s7 = peg$parse_();
        s3 = [s3, s4, s5, s6, s7];
        s2 = s3;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f50(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parse_();
      if (input.substr(peg$currPos, 3) === peg$c50) {
        s2 = peg$c50;
        peg$currPos += 3;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e86); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parse_();
        peg$savedPos = s0;
        s0 = peg$f51();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e85); }
    }

    return s0;
  }

  function peg$parseParameterList() {
    var s0, s1, s2, s3, s4, s5;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseParameterDeclaration();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parseComma();
      if (s4 !== peg$FAILED) {
        s5 = peg$parseParameterDeclaration();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parseComma();
        if (s4 !== peg$FAILED) {
          s5 = peg$parseParameterDeclaration();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f52(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e87); }
    }

    return s0;
  }

  function peg$parseParameterDeclaration() {
    var s0, s1, s2, s3;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseDeclarationSpecifiers();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse_();
      s3 = peg$parseDeclarator();
      if (s3 === peg$FAILED) {
        s3 = peg$parseAbstractDeclarator();
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f53(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e88); }
    }

    return s0;
  }

  function peg$parseTypeName() {
    var s0, s1, s2, s3;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseSpecifierQualifierList();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse_();
      s3 = peg$parseAbstractDeclarator();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f54(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e89); }
    }

    return s0;
  }

  function peg$parseTypedefName() {
    var s0, s1, s2, s3;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseKnownAlias();
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseWordChar();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f55(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e90); }
    }

    return s0;
  }

  function peg$parseSpecifierQualifierList() {
    var s0, s1, s2, s3, s4, s5;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseTypeSpecifier();
    if (s1 === peg$FAILED) {
      s1 = peg$parseTypeQualifier();
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      if (s4 !== peg$FAILED) {
        s5 = peg$parseTypeSpecifier();
        if (s5 === peg$FAILED) {
          s5 = peg$parseTypeQualifier();
        }
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        if (s4 !== peg$FAILED) {
          s5 = peg$parseTypeSpecifier();
          if (s5 === peg$FAILED) {
            s5 = peg$parseTypeQualifier();
          }
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f56(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e91); }
    }

    return s0;
  }

  function peg$parseIdentifier() {
    var s0, s1, s2, s3, s4, s5;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$currPos;
    peg$silentFails++;
    s2 = peg$currPos;
    s3 = peg$parseKeyword();
    if (s3 !== peg$FAILED) {
      s4 = peg$currPos;
      peg$silentFails++;
      s5 = peg$parseWordChar();
      peg$silentFails--;
      if (s5 === peg$FAILED) {
        s4 = undefined;
      } else {
        peg$currPos = s4;
        s4 = peg$FAILED;
      }
      if (s4 !== peg$FAILED) {
        s3 = [s3, s4];
        s2 = s3;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
    } else {
      peg$currPos = s2;
      s2 = peg$FAILED;
    }
    peg$silentFails--;
    if (s2 === peg$FAILED) {
      s1 = undefined;
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s2 = input.charAt(peg$currPos);
      if (peg$r4.test(s2)) {
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e93); }
      }
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$parseWordChar();
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$parseWordChar();
        }
        peg$savedPos = s0;
        s0 = peg$f57();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e92); }
    }

    return s0;
  }

  function peg$parseIntegerConstant() {
    var s0, s1, s2;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseBinaryConstant();
    if (s1 === peg$FAILED) {
      s1 = peg$parseHexadecimalConstant();
      if (s1 === peg$FAILED) {
        s1 = peg$parseOctalConstant();
        if (s1 === peg$FAILED) {
          s1 = peg$parseDecimalConstant();
        }
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parseIntegerSuffix();
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f58(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e94); }
    }

    return s0;
  }

  function peg$parseBinaryConstant() {
    var s0, s1, s2, s3, s4, s5;

    peg$silentFails++;
    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 48) {
      s1 = peg$c51;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e96); }
    }
    if (s1 !== peg$FAILED) {
      s2 = input.charAt(peg$currPos);
      if (peg$r5.test(s2)) {
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e97); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$currPos;
        s4 = [];
        s5 = input.charAt(peg$currPos);
        if (peg$r6.test(s5)) {
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e98); }
        }
        if (s5 !== peg$FAILED) {
          while (s5 !== peg$FAILED) {
            s4.push(s5);
            s5 = input.charAt(peg$currPos);
            if (peg$r6.test(s5)) {
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e98); }
            }
          }
        } else {
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          s3 = input.substring(s3, peg$currPos);
        } else {
          s3 = s4;
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f59(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e95); }
    }

    return s0;
  }

  function peg$parseHexadecimalConstant() {
    var s0, s1, s2, s3, s4, s5;

    peg$silentFails++;
    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 48) {
      s1 = peg$c51;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e96); }
    }
    if (s1 !== peg$FAILED) {
      s2 = input.charAt(peg$currPos);
      if (peg$r7.test(s2)) {
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e100); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$currPos;
        s4 = [];
        s5 = input.charAt(peg$currPos);
        if (peg$r8.test(s5)) {
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e101); }
        }
        if (s5 !== peg$FAILED) {
          while (s5 !== peg$FAILED) {
            s4.push(s5);
            s5 = input.charAt(peg$currPos);
            if (peg$r8.test(s5)) {
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e101); }
            }
          }
        } else {
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          s3 = input.substring(s3, peg$currPos);
        } else {
          s3 = s4;
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f60(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e99); }
    }

    return s0;
  }

  function peg$parseOctalConstant() {
    var s0, s1, s2, s3, s4;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = [];
    if (input.charCodeAt(peg$currPos) === 48) {
      s2 = peg$c51;
      peg$currPos++;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e96); }
    }
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        if (input.charCodeAt(peg$currPos) === 48) {
          s2 = peg$c51;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e96); }
        }
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = [];
      s4 = input.charAt(peg$currPos);
      if (peg$r9.test(s4)) {
        peg$currPos++;
      } else {
        s4 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e103); }
      }
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = input.charAt(peg$currPos);
        if (peg$r9.test(s4)) {
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e103); }
        }
      }
      s2 = input.substring(s2, peg$currPos);
      peg$savedPos = s0;
      s0 = peg$f61(s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e102); }
    }

    return s0;
  }

  function peg$parseDecimalConstant() {
    var s0, s1, s2, s3;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = input.charAt(peg$currPos);
    if (peg$r10.test(s1)) {
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e105); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = input.charAt(peg$currPos);
      if (peg$r11.test(s3)) {
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e106); }
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = input.charAt(peg$currPos);
        if (peg$r11.test(s3)) {
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e106); }
        }
      }
      peg$savedPos = s0;
      s0 = peg$f62();
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e104); }
    }

    return s0;
  }

  function peg$parseIntegerSuffix() {
    var s0, s1, s2, s3, s4;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = input.charAt(peg$currPos);
    if (peg$r12.test(s2)) {
      peg$currPos++;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e108); }
    }
    if (s2 !== peg$FAILED) {
      s3 = input.charAt(peg$currPos);
      if (peg$r13.test(s3)) {
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e109); }
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = input.charAt(peg$currPos);
      if (peg$r13.test(s4)) {
        peg$currPos++;
      } else {
        s4 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e109); }
      }
      if (s4 === peg$FAILED) {
        s4 = null;
      }
      s2 = [s2, s3, s4];
      s1 = s2;
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 === peg$FAILED) {
      s1 = peg$currPos;
      s2 = input.charAt(peg$currPos);
      if (peg$r13.test(s2)) {
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e109); }
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      s3 = input.charAt(peg$currPos);
      if (peg$r13.test(s3)) {
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e109); }
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = input.charAt(peg$currPos);
      if (peg$r12.test(s4)) {
        peg$currPos++;
      } else {
        s4 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e108); }
      }
      if (s4 === peg$FAILED) {
        s4 = null;
      }
      s2 = [s2, s3, s4];
      s1 = s2;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f63();
    }
    s0 = s1;
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e107); }
    }

    return s0;
  }

  function peg$parseKeyword() {
    var s0, s1;

    peg$silentFails++;
    if (input.substr(peg$currPos, 4) === peg$c25) {
      s0 = peg$c25;
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e37); }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 5) === peg$c52) {
        s0 = peg$c52;
        peg$currPos += 5;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e111); }
      }
      if (s0 === peg$FAILED) {
        if (input.substr(peg$currPos, 4) === peg$c53) {
          s0 = peg$c53;
          peg$currPos += 4;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e112); }
        }
        if (s0 === peg$FAILED) {
          if (input.substr(peg$currPos, 9) === peg$c26) {
            s0 = peg$c26;
            peg$currPos += 9;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e38); }
          }
          if (s0 === peg$FAILED) {
            if (input.substr(peg$currPos, 4) === peg$c29) {
              s0 = peg$c29;
              peg$currPos += 4;
            } else {
              s0 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e43); }
            }
            if (s0 === peg$FAILED) {
              if (input.substr(peg$currPos, 5) === peg$c41) {
                s0 = peg$c41;
                peg$currPos += 5;
              } else {
                s0 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e59); }
              }
              if (s0 === peg$FAILED) {
                if (input.substr(peg$currPos, 8) === peg$c54) {
                  s0 = peg$c54;
                  peg$currPos += 8;
                } else {
                  s0 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e113); }
                }
                if (s0 === peg$FAILED) {
                  if (input.substr(peg$currPos, 7) === peg$c55) {
                    s0 = peg$c55;
                    peg$currPos += 7;
                  } else {
                    s0 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e114); }
                  }
                  if (s0 === peg$FAILED) {
                    if (input.substr(peg$currPos, 2) === peg$c56) {
                      s0 = peg$c56;
                      peg$currPos += 2;
                    } else {
                      s0 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$e115); }
                    }
                    if (s0 === peg$FAILED) {
                      if (input.substr(peg$currPos, 6) === peg$c34) {
                        s0 = peg$c34;
                        peg$currPos += 6;
                      } else {
                        s0 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$e48); }
                      }
                      if (s0 === peg$FAILED) {
                        if (input.substr(peg$currPos, 4) === peg$c57) {
                          s0 = peg$c57;
                          peg$currPos += 4;
                        } else {
                          s0 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$e116); }
                        }
                        if (s0 === peg$FAILED) {
                          if (input.substr(peg$currPos, 4) === peg$c40) {
                            s0 = peg$c40;
                            peg$currPos += 4;
                          } else {
                            s0 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$e56); }
                          }
                          if (s0 === peg$FAILED) {
                            if (input.substr(peg$currPos, 6) === peg$c23) {
                              s0 = peg$c23;
                              peg$currPos += 6;
                            } else {
                              s0 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$e35); }
                            }
                            if (s0 === peg$FAILED) {
                              if (input.substr(peg$currPos, 5) === peg$c33) {
                                s0 = peg$c33;
                                peg$currPos += 5;
                              } else {
                                s0 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$e47); }
                              }
                              if (s0 === peg$FAILED) {
                                if (input.substr(peg$currPos, 3) === peg$c58) {
                                  s0 = peg$c58;
                                  peg$currPos += 3;
                                } else {
                                  s0 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$e117); }
                                }
                                if (s0 === peg$FAILED) {
                                  if (input.substr(peg$currPos, 4) === peg$c59) {
                                    s0 = peg$c59;
                                    peg$currPos += 4;
                                  } else {
                                    s0 = peg$FAILED;
                                    if (peg$silentFails === 0) { peg$fail(peg$e118); }
                                  }
                                  if (s0 === peg$FAILED) {
                                    if (input.substr(peg$currPos, 2) === peg$c60) {
                                      s0 = peg$c60;
                                      peg$currPos += 2;
                                    } else {
                                      s0 = peg$FAILED;
                                      if (peg$silentFails === 0) { peg$fail(peg$e119); }
                                    }
                                    if (s0 === peg$FAILED) {
                                      if (input.substr(peg$currPos, 6) === peg$c44) {
                                        s0 = peg$c44;
                                        peg$currPos += 6;
                                      } else {
                                        s0 = peg$FAILED;
                                        if (peg$silentFails === 0) { peg$fail(peg$e63); }
                                      }
                                      if (s0 === peg$FAILED) {
                                        if (input.substr(peg$currPos, 3) === peg$c31) {
                                          s0 = peg$c31;
                                          peg$currPos += 3;
                                        } else {
                                          s0 = peg$FAILED;
                                          if (peg$silentFails === 0) { peg$fail(peg$e45); }
                                        }
                                        if (s0 === peg$FAILED) {
                                          if (input.substr(peg$currPos, 4) === peg$c32) {
                                            s0 = peg$c32;
                                            peg$currPos += 4;
                                          } else {
                                            s0 = peg$FAILED;
                                            if (peg$silentFails === 0) { peg$fail(peg$e46); }
                                          }
                                          if (s0 === peg$FAILED) {
                                            if (input.substr(peg$currPos, 8) === peg$c27) {
                                              s0 = peg$c27;
                                              peg$currPos += 8;
                                            } else {
                                              s0 = peg$FAILED;
                                              if (peg$silentFails === 0) { peg$fail(peg$e39); }
                                            }
                                            if (s0 === peg$FAILED) {
                                              if (input.substr(peg$currPos, 8) === peg$c42) {
                                                s0 = peg$c42;
                                                peg$currPos += 8;
                                              } else {
                                                s0 = peg$FAILED;
                                                if (peg$silentFails === 0) { peg$fail(peg$e60); }
                                              }
                                              if (s0 === peg$FAILED) {
                                                if (input.substr(peg$currPos, 6) === peg$c61) {
                                                  s0 = peg$c61;
                                                  peg$currPos += 6;
                                                } else {
                                                  s0 = peg$FAILED;
                                                  if (peg$silentFails === 0) { peg$fail(peg$e120); }
                                                }
                                                if (s0 === peg$FAILED) {
                                                  if (input.substr(peg$currPos, 5) === peg$c30) {
                                                    s0 = peg$c30;
                                                    peg$currPos += 5;
                                                  } else {
                                                    s0 = peg$FAILED;
                                                    if (peg$silentFails === 0) { peg$fail(peg$e44); }
                                                  }
                                                  if (s0 === peg$FAILED) {
                                                    if (input.substr(peg$currPos, 6) === peg$c35) {
                                                      s0 = peg$c35;
                                                      peg$currPos += 6;
                                                    } else {
                                                      s0 = peg$FAILED;
                                                      if (peg$silentFails === 0) { peg$fail(peg$e49); }
                                                    }
                                                    if (s0 === peg$FAILED) {
                                                      if (input.substr(peg$currPos, 6) === peg$c62) {
                                                        s0 = peg$c62;
                                                        peg$currPos += 6;
                                                      } else {
                                                        s0 = peg$FAILED;
                                                        if (peg$silentFails === 0) { peg$fail(peg$e121); }
                                                      }
                                                      if (s0 === peg$FAILED) {
                                                        if (input.substr(peg$currPos, 6) === peg$c24) {
                                                          s0 = peg$c24;
                                                          peg$currPos += 6;
                                                        } else {
                                                          s0 = peg$FAILED;
                                                          if (peg$silentFails === 0) { peg$fail(peg$e36); }
                                                        }
                                                        if (s0 === peg$FAILED) {
                                                          if (input.substr(peg$currPos, 6) === peg$c37) {
                                                            s0 = peg$c37;
                                                            peg$currPos += 6;
                                                          } else {
                                                            s0 = peg$FAILED;
                                                            if (peg$silentFails === 0) { peg$fail(peg$e52); }
                                                          }
                                                          if (s0 === peg$FAILED) {
                                                            if (input.substr(peg$currPos, 6) === peg$c63) {
                                                              s0 = peg$c63;
                                                              peg$currPos += 6;
                                                            } else {
                                                              s0 = peg$FAILED;
                                                              if (peg$silentFails === 0) { peg$fail(peg$e122); }
                                                            }
                                                            if (s0 === peg$FAILED) {
                                                              if (input.substr(peg$currPos, 7) === peg$c22) {
                                                                s0 = peg$c22;
                                                                peg$currPos += 7;
                                                              } else {
                                                                s0 = peg$FAILED;
                                                                if (peg$silentFails === 0) { peg$fail(peg$e34); }
                                                              }
                                                              if (s0 === peg$FAILED) {
                                                                if (input.substr(peg$currPos, 5) === peg$c38) {
                                                                  s0 = peg$c38;
                                                                  peg$currPos += 5;
                                                                } else {
                                                                  s0 = peg$FAILED;
                                                                  if (peg$silentFails === 0) { peg$fail(peg$e53); }
                                                                }
                                                                if (s0 === peg$FAILED) {
                                                                  if (input.substr(peg$currPos, 8) === peg$c36) {
                                                                    s0 = peg$c36;
                                                                    peg$currPos += 8;
                                                                  } else {
                                                                    s0 = peg$FAILED;
                                                                    if (peg$silentFails === 0) { peg$fail(peg$e50); }
                                                                  }
                                                                  if (s0 === peg$FAILED) {
                                                                    if (input.substr(peg$currPos, 4) === peg$c28) {
                                                                      s0 = peg$c28;
                                                                      peg$currPos += 4;
                                                                    } else {
                                                                      s0 = peg$FAILED;
                                                                      if (peg$silentFails === 0) { peg$fail(peg$e42); }
                                                                    }
                                                                    if (s0 === peg$FAILED) {
                                                                      if (input.substr(peg$currPos, 8) === peg$c43) {
                                                                        s0 = peg$c43;
                                                                        peg$currPos += 8;
                                                                      } else {
                                                                        s0 = peg$FAILED;
                                                                        if (peg$silentFails === 0) { peg$fail(peg$e61); }
                                                                      }
                                                                      if (s0 === peg$FAILED) {
                                                                        if (input.substr(peg$currPos, 5) === peg$c64) {
                                                                          s0 = peg$c64;
                                                                          peg$currPos += 5;
                                                                        } else {
                                                                          s0 = peg$FAILED;
                                                                          if (peg$silentFails === 0) { peg$fail(peg$e123); }
                                                                        }
                                                                        if (s0 === peg$FAILED) {
                                                                          s0 = peg$parseAlignasKeyword();
                                                                          if (s0 === peg$FAILED) {
                                                                            s0 = peg$parseAlignofKeyword();
                                                                            if (s0 === peg$FAILED) {
                                                                              s0 = peg$parseAtomicKeyword();
                                                                              if (s0 === peg$FAILED) {
                                                                                s0 = peg$parseBoolKeyword();
                                                                                if (s0 === peg$FAILED) {
                                                                                  s0 = peg$parseComplexKeyword();
                                                                                  if (s0 === peg$FAILED) {
                                                                                    s0 = peg$parseGenericKeyword();
                                                                                    if (s0 === peg$FAILED) {
                                                                                      s0 = peg$parseImaginaryKeyword();
                                                                                      if (s0 === peg$FAILED) {
                                                                                        s0 = peg$parseNoreturnKeyword();
                                                                                        if (s0 === peg$FAILED) {
                                                                                          s0 = peg$parseStaticAssertKeyword();
                                                                                          if (s0 === peg$FAILED) {
                                                                                            s0 = peg$parseThreadLocalKeyword();
                                                                                          }
                                                                                        }
                                                                                      }
                                                                                    }
                                                                                  }
                                                                                }
                                                                              }
                                                                            }
                                                                          }
                                                                        }
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            }
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e110); }
    }

    return s0;
  }

  function peg$parseKnownAlias() {
    var s0;

    if (input.substr(peg$currPos, 4) === peg$c65) {
      s0 = peg$c65;
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e124); }
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parsePosixAlias();
    }

    return s0;
  }

  function peg$parsePosixAlias() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = input.charAt(peg$currPos);
    if (peg$r4.test(s2)) {
      peg$currPos++;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e93); }
    }
    if (s2 !== peg$FAILED) {
      s3 = [];
      s4 = peg$currPos;
      s5 = peg$currPos;
      peg$silentFails++;
      if (input.substr(peg$currPos, 2) === peg$c66) {
        s6 = peg$c66;
        peg$currPos += 2;
      } else {
        s6 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e125); }
      }
      peg$silentFails--;
      if (s6 === peg$FAILED) {
        s5 = undefined;
      } else {
        peg$currPos = s5;
        s5 = peg$FAILED;
      }
      if (s5 !== peg$FAILED) {
        s6 = peg$parseWordChar();
        if (s6 !== peg$FAILED) {
          s5 = [s5, s6];
          s4 = s5;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
      } else {
        peg$currPos = s4;
        s4 = peg$FAILED;
      }
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = peg$currPos;
        s5 = peg$currPos;
        peg$silentFails++;
        if (input.substr(peg$currPos, 2) === peg$c66) {
          s6 = peg$c66;
          peg$currPos += 2;
        } else {
          s6 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e125); }
        }
        peg$silentFails--;
        if (s6 === peg$FAILED) {
          s5 = undefined;
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parseWordChar();
          if (s6 !== peg$FAILED) {
            s5 = [s5, s6];
            s4 = s5;
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
      }
      s2 = [s2, s3];
      s1 = s2;
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      if (input.substr(peg$currPos, 2) === peg$c66) {
        s2 = peg$c66;
        peg$currPos += 2;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e125); }
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f64();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseAlignasKeyword() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8) === peg$c67) {
      s1 = peg$c67;
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e126); }
    }
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 7) === peg$c68) {
        s1 = peg$c68;
        peg$currPos += 7;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e127); }
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f65();
    }
    s0 = s1;

    return s0;
  }

  function peg$parseAlignofKeyword() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8) === peg$c69) {
      s1 = peg$c69;
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e128); }
    }
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 7) === peg$c70) {
        s1 = peg$c70;
        peg$currPos += 7;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e129); }
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f66();
    }
    s0 = s1;

    return s0;
  }

  function peg$parseAtomicKeyword() {
    var s0;

    if (input.substr(peg$currPos, 7) === peg$c71) {
      s0 = peg$c71;
      peg$currPos += 7;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e130); }
    }

    return s0;
  }

  function peg$parseBoolKeyword() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5) === peg$c72) {
      s1 = peg$c72;
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e131); }
    }
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 4) === peg$c73) {
        s1 = peg$c73;
        peg$currPos += 4;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e132); }
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f67();
    }
    s0 = s1;

    return s0;
  }

  function peg$parseComplexKeyword() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8) === peg$c74) {
      s1 = peg$c74;
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e133); }
    }
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 7) === peg$c75) {
        s1 = peg$c75;
        peg$currPos += 7;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e134); }
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f68();
    }
    s0 = s1;

    return s0;
  }

  function peg$parseGenericKeyword() {
    var s0;

    if (input.substr(peg$currPos, 8) === peg$c76) {
      s0 = peg$c76;
      peg$currPos += 8;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e135); }
    }

    return s0;
  }

  function peg$parseImaginaryKeyword() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 10) === peg$c77) {
      s1 = peg$c77;
      peg$currPos += 10;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e136); }
    }
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 9) === peg$c78) {
        s1 = peg$c78;
        peg$currPos += 9;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e137); }
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f69();
    }
    s0 = s1;

    return s0;
  }

  function peg$parseNoreturnKeyword() {
    var s0;

    if (input.substr(peg$currPos, 9) === peg$c79) {
      s0 = peg$c79;
      peg$currPos += 9;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e138); }
    }

    return s0;
  }

  function peg$parseStaticAssertKeyword() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 14) === peg$c80) {
      s1 = peg$c80;
      peg$currPos += 14;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e139); }
    }
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 13) === peg$c81) {
        s1 = peg$c81;
        peg$currPos += 13;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e140); }
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f70();
    }
    s0 = s1;

    return s0;
  }

  function peg$parseThreadLocalKeyword() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 13) === peg$c82) {
      s1 = peg$c82;
      peg$currPos += 13;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e141); }
    }
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 12) === peg$c83) {
        s1 = peg$c83;
        peg$currPos += 12;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e142); }
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f71();
    }
    s0 = s1;

    return s0;
  }

  function peg$parseWordChar() {
    var s0;

    s0 = input.charAt(peg$currPos);
    if (peg$r14.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e143); }
    }

    return s0;
  }

  function peg$parseComma() {
    var s0, s1, s2, s3;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parse_();
    if (input.charCodeAt(peg$currPos) === 44) {
      s2 = peg$c11;
      peg$currPos++;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e13); }
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$parse_();
      s1 = [s1, s2, s3];
      s0 = s1;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e144); }
    }

    return s0;
  }

  function peg$parse_() {
    var s0, s1;

    peg$silentFails++;
    s0 = input.charAt(peg$currPos);
    if (peg$r15.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e146); }
    }
    if (s0 === peg$FAILED) {
      s0 = null;
    }
    peg$silentFails--;
    s1 = peg$FAILED;
    if (peg$silentFails === 0) { peg$fail(peg$e145); }

    return s0;
  }

  function peg$parse__() {
    var s0, s1;

    peg$silentFails++;
    s0 = input.charAt(peg$currPos);
    if (peg$r15.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e146); }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e147); }
    }

    return s0;
  }


  function reduceRightRecursion(head, tail) {
    tail = tail.map(e => e[e.length - 1]) ?? [];
    return [head, ...tail];
  };
  
  function concatInPlace(dest, src) {
      for (const e of src) {
          dest.push(e);
      }
  };

  const Type = {
    INT: 'i',
    UINT: 'u',
    LONG: 'l',
    ULONG: 'ul',
    LONG_LONG: 'll',
    ULONG_LONG: 'ull',
  };

  peg$result = peg$startRuleFunction();

  if (options.peg$library) {
    return /** @type {any} */ ({
      peg$result,
      peg$currPos,
      peg$FAILED,
      peg$maxFailExpected,
      peg$maxFailPos
    });
  }
  if (peg$result !== peg$FAILED && peg$currPos === input.length) {
    return peg$result;
  } else {
    if (peg$result !== peg$FAILED && peg$currPos < input.length) {
      peg$fail(peg$endExpectation());
    }

    throw peg$buildStructuredError(
      peg$maxFailExpected,
      peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null,
      peg$maxFailPos < input.length
        ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
        : peg$computeLocation(peg$maxFailPos, peg$maxFailPos)
    );
  }
}

  return {
    StartRules: ["Main"],
    SyntaxError: peg$SyntaxError,
    parse: peg$parse
  };
})()
;
