/********************************************************************************
 * Copyright (c) 2020 TypeFox and others
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 ********************************************************************************/

const express = require('express');
const path = require('path');

const port = 3000;
const staticPath = path.join(__dirname, '..', '..', 'static');

const app = express();

app.use(express.static(path.join(__dirname, '..', 'static')));
app.use(express.static(staticPath));

app.get('*', (req, res) => {
    res.sendFile(path.join(staticPath, 'index.html'));
});

app.listen(port, () => console.log(`Dev server running on port ${port}...`));
