# Pre-train, Prompt, and Predict: A Systematic Survey of Prompting Methods in Natural Language Processing

## Índice

- [Fonte Principal](#fonte-principal)
- [Pontos-chave](#pontos-chave)
- [Aplicações em Prompt Engineering](#aplicações-em-prompt-engineering)
- [Limitações e Considerações](#limitações-e-considerações)
- [Navegação](#navegação)

## Fonte Principal

Artigo: "Pre-train, Prompt, and Predict: A Systematic Survey of Prompting Methods in Natural Language Processing"
Autores: Pengfei Liu, et al.
Link: <https://arxiv.org/abs/2107.13586>

## Pontos-chave

1. **Paradigma de Prompting**: Introdução ao conceito de prompting como uma nova abordagem em NLP.

2. **Taxonomia de Métodos de Prompting**:
   - Classificação baseada em modalidade de prompt (discreto vs. contínuo)
   - Categorização por estratégias de engenharia de prompt (manual, automática, híbrida)

3. **Aplicações de Prompting**:
   - Uso em várias tarefas de NLP, incluindo classificação, geração e extração de informações
   - Adaptação de prompts para domínios específicos

4. **Técnicas de Otimização de Prompts**:
   - Métodos baseados em gradiente para prompts contínuos
   - Estratégias de busca para prompts discretos

5. **Avaliação de Métodos de Prompting**:
   - Métricas de desempenho em diferentes tarefas
   - Comparação com métodos tradicionais de fine-tuning

## Aplicações em Prompt Engineering

- Desenvolvimento de prompts mais eficientes para tarefas específicas de NLP
- Criação de sistemas de NLP mais adaptáveis e generalizáveis
- Melhoria da interpretabilidade de modelos de linguagem grandes

## Limitações e Considerações

- Dependência da qualidade e tamanho do modelo pré-treinado
- Desafios na transferência de conhecimentos entre domínios
- Necessidade de mais pesquisas sobre a robustez dos métodos de prompting

## Navegação

- [Próximo: Language Models are Few-Shot Learners](language_models_few_shot_learners.md)
- [Voltar para Articles](..)

<div align="center">
  <a href="#índice">Voltar ao Índice</a> |
  <a href="https://github.com/EYLatamSouth/beyondlabs-prompt-engineering">Sobre este Projeto</a> | 
  <a href="https://github.com/EYLatamSouth/beyondlabs-prompt-engineering/blob/main/LICENSE">Licença</a>
</div>