# 📚 Artigos sobre Engenharia de Prompt

## Índice

- [Introdução](#introdução)
- [Artigos Disponíveis](#artigos-disponíveis)
- [Como Utilizar](#como-utilizar)
- [Contribuindo](#contribuindo)
- [Navegação](#navegação)

## Introdução

Bem-vindo à seção de Artigos do BeyondLabs - Prompt Engineering! Aqui você encontrará uma coleção curada de artigos científicos e técnicos de fontes confiáveis que aprofundam diversos aspectos da engenharia de prompt.

## Artigos Disponíveis

Atualmente, temos três artigos importantes de organizações líderes em IA:

1. [Anthropic - Constitutional AI: Harmless from AI Feedback](anthropic_constitutional_ai.md)
   - Constitutional AI é uma abordagem desenvolvida pela Anthropic para criar modelos de IA mais seguros e alinhados com valores humanos. O método envolve treinar modelos de linguagem para seguir um conjunto de regras ou "constituição" que define comportamentos desejáveis e indesejáveis.

2. [Google - A Survey of Large Language Models](google_prompt_engineering_study.md)
   - Este estudo abrangente do Google Research oferece uma visão geral sistemática das técnicas de Prompt Engineering para Modelos de Linguagem Grandes (LLMs). O artigo examina várias estratégias, desafios e direções futuras neste campo em rápida evolução.

3. [OpenAI - Prompt Engineering](openai_prompt_engineering.md)
   - A OpenAI fornece um guia abrangente de melhores práticas para usar efetivamente seus modelos GPT. Este documento cobre estratégias para melhorar a qualidade das respostas, lidar com limitações do modelo e otimizar o desempenho em várias tarefas.

## Como Utilizar

- Cada conteúdo está disponível o link para fácil leitura e referência.
- Recomendamos começar pelo artigo/estudo que mais se alinha com seus interesses ou necessidades atuais.
- Considere fazer anotações e tentar aplicar os conceitos aprendidos em seus próprios projetos de engenharia de prompt.

## Contribuindo

Encontrou um artigo valioso que gostaria de adicionar à nossa coleção? Ótimo! Siga estas etapas:

1. Verifique se o artigo é de uma fonte confiável e relevante para engenharia de prompt.
2. Faça um fork do repositório.
3. Adicione o artigo (em formato PDF ou Referência(link)) à pasta `articles`.
4. Atualize este README.md com informações sobre o novo artigo.
5. Crie um pull request com uma breve descrição do artigo e por que você acha que ele seria uma adição valiosa.

## Navegação
- [Voltar para Resources](..)
- [Ir para Tools](../tools)

<div align="center">
  <a href="#índice">Voltar ao Índice</a> |
  <a href="https://github.com/EYLatamSouth/beyondlabs-prompt-engineering">Sobre este Projeto</a> | 
  <a href="https://github.com/EYLatamSouth/beyondlabs-prompt-engineering/blob/main/LICENSE">Licença</a>
</div>