# 📚 Fundamentos da Engenharia de Prompt

## Índice
- [O que você aprenderá](#-o-que-você-aprenderá)
- [Como navegar](#-como-navegar)
- [Próximos passos](#-próximos-passos)
- [Dica](#-dica)
- [Navegação](#navegação)

Bem-vindo à seção de Fundamentos do BeyondLabs - Prompt Engineering! Aqui você encontrará os alicerces essenciais para se tornar um engenheiro de prompt eficaz.

## 🎯 O que você aprenderá

Nesta seção, você será introduzido aos conceitos básicos e cruciais da engenharia de prompt, incluindo:

1. [Introdução à Engenharia de Prompt](01_introduction_to_prompt_engineering.md)
   - O que é e por que é importante

2. [Estrutura Básica de Prompts](02_basic_prompt_structure.md)
   - Componentes de um prompt eficaz
   - Técnicas de formatação

3. [Tipos de Prompts](03_types_of_prompts.md)
   - Prompts de pergunta-resposta
   - Prompts de completamento
   - Prompts de instrução
   - Prompts de conversação

4. [Contexto e Especificidade](04_context_and_specificity.md)
   - Como fornecer contexto adequado
   - A importância da especificidade nos prompts

5. [Componentes de Prompts](05_prompt_components.md)
   - Componentes principais (Contexto, Instrução, Entrada, Indicador de Saída)
   - Componentes avançados (Exemplos, Persona, Formato de Saída)

6. [Erros Comuns](06_common_pitfalls.md)
   - Identificação e prevenção de erros frequentes na engenharia de prompts

## 🗺️ Como navegar

Cada tópico é apresentado em um arquivo markdown separado, numerado em ordem sugerida de leitura. Sinta-se à vontade para seguir a ordem ou pular para os tópicos de seu interesse.

## 🚀 Próximos passos

Após dominar os fundamentos, você estará preparado para:

- [Explorar técnicas avançadas em nossa seção de Aprendizado Avançado](../../assets/utils/NOT_FOUND.md)
- [Analisar exemplos práticos em nossa Galeria de Exemplos](../../assets/utils/NOT_FOUND.md)
- [Experimentar com prompts na seção de Playground](../../assets/utils/NOT_FOUND.md)

## 💡 Dica

Pratique ativamente enquanto aprende! Tente criar seus próprios prompts baseados nos conceitos apresentados em cada lição.

## Navegação
- [Próximo: Introdução à Engenharia de Prompt](01_introduction_to_prompt_engineering.md)

<div align="center">
  <a href="#índice">Voltar ao Índice</a> |
  <a href="https://github.com/EYLatamSouth/beyondlabs-prompt-engineering">Sobre este Projeto</a> | 
  <a href="https://github.com/EYLatamSouth/beyondlabs-prompt-engineering/blob/main/LICENSE">Licença</a>
</div>