# from xml.dom import minidom
# xmldoc = minidom.parse('dblp.xml')
# itemlist = xmldoc.getElementsByTagName('item')


import xml.sax
from personhandler import Personhandler
from publicationhandler import PublicationHandler

# Configure data path
xml_path = 'dblp.xml'


pub_types = ['article', 'inproceedings', 'proceedings', 'book', 'incollection', 'phdthesis', 'mastersthesis', 'www']

pub_attributes = {'key': 'pubKey', 'title': 'pubTitle', 'year': 'pubYear', 'mdate': 'pubMdate', 'type': 'pubType', 'publisher': 'publisherName'}
pub_subclass_attributes_map = {
                    'article': {'key': 'pubKey', 'journal': 'articleJournal', 'booktitle': 'articleBooktitle', 'number': 'articleNumber', 'pages': 'articlePages', 'volume': 'articleVolume', 'crossref': 'articleCrossref'},
                    'inproceedings': {'key': 'pubKey', 'booktitle': 'inproBooktitle', 'number': 'inproNumber', 'pages': 'inproPages', 'crossref': 'inproCrossref'},
                    'incollection': {'key': 'pubKey', 'chapter': 'incolChapter', 'booktitle': 'incolBooktitle', 'number': 'incolNumber', 'pages': 'incolPages', 'crossref': 'incolCrossref'},
                    'proceedings': {'key': 'pubKey', 'address': 'proceedAddress', 'journal': 'proceedJournal', 'booktitle': 'proceedBooktitle', 'number': 'proceedNumber', 'pages': 'proceedPages', 'series': 'proceedSeries', 'volume': 'proceedVolume', 'type': 'proceedType'},
                    'book': {'key': 'pubKey', 'booktitle': 'bookBooktitle', 'pages': 'bookPages', 'series': 'bookSeries', 'volume': 'bookVolume'},
                    'thesis': {'key': 'pubKey', 'number': 'thesisNumber', 'pages': 'thesisPages', 'series': 'thesisSeries', 'volume': 'thesisVolume'},
                    'www': {'key': 'pubKey', 'booktitle': 'wwwBooktitle'},
                    }

# Convert xml to csv files for Person, Editorship, Authorship
parser = xml.sax.make_parser()
Person_handler = Personhandler()
parser.setContentHandler(Person_handler)
xml.sax.parse(xml_path, Person_handler)

# Convert xml to csv files for Publication and its subclasses
parser = xml.sax.make_parser()
Publicaiton_handler = PublicationHandler(fieldnames=pub_types)
parser.setContentHandler(PublicationHandler)
xml.sax.parse(xml_path, Publicaiton_handler)
