﻿using Bogus;
using Eisk.Domains.Entities;
using Eisk.Domains.Enums;
using Eisk.Test.Core.DataGen.DataFactories;

namespace Eisk.Domains.TestData;


public class EmployeeDataFactory : EntityDomainDataFactory<Employee>
{
    string[] _jobTitles = new string[] { "Vice President", "Director", "Manager", "Executive", "Sales Executive", "Management Trainee" };
    protected override void AssignDomainData(Employee employee)
    {
        var faker = new Faker();

        employee.Id = 0;
        employee.ReportsTo = null;
        employee.ReportsToId = null;
        employee.Subordinates = null;

        employee.TitleOfCourtesy = faker.PickRandom<TitleOfCourtesy>();
        employee.FirstName = faker.Person.FirstName;
        employee.LastName = faker.Person.LastName;
        employee.BirthDate = faker.Date.Past();

        var fakerAddress = faker.Address;
        employee.Address = new ValueObjects.Address
        {
            AddressLine = fakerAddress.StreetAddress(),
            City = fakerAddress.City(),
            PostalCode = fakerAddress.ZipCode(),
            Region = fakerAddress.State(),
            Country = fakerAddress.Country(),
        };

        employee.HireDate = faker.Date.Future();
        employee.Title = faker.PickRandomParam(_jobTitles);
        employee.Phone = faker.Person.Phone;
        employee.Extension = faker.Person.Random.Number(0, 999).ToString("000");

        employee.Photo = null;

        //employee.Notes: to be auto-generated by the underlying framework
    }

}
