FILE(GLOB_RECURSE FILES_FOUND "${OpENer_CIP_OBJECTS_DIR}/*CMakeLists.txt")

FOREACH(FILE ${FILES_FOUND})
  string(REPLACE "${OpENer_CIP_OBJECTS_DIR}" "" CIP_OBJECT_NAME ${FILE})
  STRING(REGEX MATCH "^/([^/]*)/CMakeLists.txt$" CIP_OBJECT_NAME ${CIP_OBJECT_NAME})
  IF(CIP_OBJECT_NAME)
    string(REPLACE "/CMakeLists.txt" "" CIP_OBJECT_NAME "${CIP_OBJECT_NAME}")
    string(REPLACE "/" "" CIP_OBJECT_NAME "${CIP_OBJECT_NAME}")
    LIST(APPEND CIP_OBJECT_LIST ${CIP_OBJECT_NAME})
  ENDIF(CIP_OBJECT_NAME)
ENDFOREACH(FILE)

SET(WRITE_FILE "")
FOREACH(CIP_OBJECT ${CIP_OBJECT_LIST})
  SET(WRITE_FILE "${WRITE_FILE}SET(SOURCE_GROUP_BACKUP \"\${SOURCE_GROUP}\")\n")
  SET(WRITE_FILE "${WRITE_FILE}SET(SOURCE_GROUP \"\${SOURCE_GROUP}/${CIP_OBJECT}\")\n")
  SET(WRITE_FILE "${WRITE_FILE}ADD_SUBDIRECTORY(\"\${OpENer_CIP_OBJECTS_DIR}/${CIP_OBJECT}\")\n")
  SET(WRITE_FILE "${WRITE_FILE}SET(SOURCE_GROUP \"\${SOURCE_GROUP_BACKUP}\")\n")
ENDFOREACH(CIP_OBJECT)

file(WRITE ${CMAKE_BINARY_DIR}/cip_objects/CMakeLists_new.txt ${WRITE_FILE})
  
execute_process( COMMAND ${CMAKE_COMMAND} -E compare_files ${CMAKE_BINARY_DIR}/cip_objects/CMakeLists_new.txt ${CMAKE_BINARY_DIR}/cip_objects/CMakeLists.txt RESULT_VARIABLE test_not_successful OUTPUT_QUIET ERROR_QUIET )  

IF(test_not_successful)
  file(REMOVE ${CMAKE_BINARY_DIR}/cip_objects/CMakeLists.txt)
  file(RENAME ${CMAKE_BINARY_DIR}/cip_objects/CMakeLists_new.txt ${CMAKE_BINARY_DIR}/cip_objects/CMakeLists.txt)
ENDIF( test_not_successful)  
file(REMOVE ${CMAKE_BINARY_DIR}/cip_objects/CMakeLists_new.txt) 
