# Generated by Django 4.1.1 on 2022-10-28 23:27

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import multiselectfield.db.fields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('role', models.CharField(choices=[('COMPANY', 'COMPANY'), ('CUSTOMER', 'CUSTOMER'), ('ADMIN', 'ADMIN')], default='ADMIN', editable=False, max_length=50)),
                ('name', models.CharField(blank=True, default='Name', max_length=50, null=True)),
                ('email', models.EmailField(blank=True, max_length=50, null=True, unique=True)),
                ('is_staff', models.BooleanField(default=True)),
                ('is_admin', models.BooleanField(default=True)),
                ('is_superuser', models.BooleanField(default=True)),
                ('is_active', models.BooleanField(default=True)),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.permission', verbose_name='user permissions')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CompanyProfile',
            fields=[
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('is_active', models.BooleanField(default=True)),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('phone', models.CharField(blank=True, default='Phone', max_length=50, null=True, unique=True)),
                ('email', models.EmailField(blank=True, max_length=50, null=True)),
                ('password', models.CharField(blank=True, max_length=32, null=True)),
                ('name', models.CharField(blank=True, max_length=50, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('website', models.CharField(blank=True, max_length=255, null=True)),
                ('head_office', models.CharField(blank=True, max_length=255, null=True)),
                ('founded', models.DateField(blank=True, null=True)),
                ('work_type', models.CharField(choices=[('accounting', 'accounting'), ('advertising', 'advertising'), ('aerospace', 'aerospace'), ('agriculture', 'agriculture'), ('airlines', 'airlines'), ('apparel', 'apparel'), ('architecture', 'architecture'), ('automotive', 'automotive'), ('banking', 'banking'), ('biotechnology', 'biotechnology'), ('broadcasting', 'broadcasting'), ('building materials', 'building materials'), ('business services', 'business services'), ('chemicals', 'chemicals'), ('clothing', 'clothing'), ('computer hardware', 'computer hardware'), ('computer software', 'computer software'), ('construction', 'construction'), ('consulting', 'consulting'), ('consumer electronics', 'consumer electronics'), ('consumer goods', 'consumer goods'), ('consumer services', 'consumer services'), ('cosmetics', 'cosmetics'), ('defense', 'defense'), ('design', 'design'), ('education', 'education'), ('electronics', 'electronics'), ('energy', 'energy'), ('engineering', 'engineering'), ('entertainment', 'entertainment'), ('environmental services', 'environmental services'), ('fashion', 'fashion'), ('finance', 'finance'), ('financial services', 'financial services'), ('food and beverage', 'food and beverage'), ('food production', 'food production'), ('furniture', 'furniture'), ('gambling', 'gambling'), ('gas', 'gas'), ('glass', 'glass'), ('government', 'government'), ('healthcare', 'healthcare'), ('hospitality', 'hospitality'), ('insurance', 'insurance'), ('internet', 'internet'), ('investment banking', 'investment banking'), ('investment management', 'investment management'), ('judiciary', 'judiciary'), ('law enforcement', 'law enforcement'), ('law practice', 'law practice'), ('legal services', 'legal services'), ('leisure', 'leisure'), ('manufacturing', 'manufacturing'), ('marketing', 'marketing'), ('mass media', 'mass media'), ('medical devices', 'medical devices'), ('medical practice', 'medical practice'), ('military', 'military'), ('mining', 'mining'), ('motion pictures', 'motion pictures'), ('museums', 'museums'), ('music', 'music'), ('nanotechnology', 'nanotechnology'), ('newspapers', 'newspapers'), ('nonprofit organization management', 'nonprofit organization management'), ('oil', 'oil')], max_length=100)),
                ('country', models.CharField(blank=True, default='Iraq', max_length=50, null=True)),
                ('city', models.CharField(blank=True, max_length=100, null=True)),
                ('address', models.CharField(blank=True, max_length=255, null=True)),
                ('image', models.ImageField(blank=True, null=True, upload_to='company/')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CustomerProfile',
            fields=[
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('is_active', models.BooleanField(default=True)),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('email', models.EmailField(blank=True, max_length=50, null=True)),
                ('phone', models.CharField(blank=True, max_length=20, null=True, unique=True)),
                ('password', models.CharField(blank=True, max_length=32, null=True)),
                ('name', models.CharField(blank=True, max_length=50, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('address', models.CharField(blank=True, max_length=255, null=True)),
                ('skills', multiselectfield.db.fields.MultiSelectField(choices=[('Adaptability', 'Adaptability'), ('Execution willingness', 'Execution willingness'), ('Resilience', 'Resilience'), ('Advice ability', 'Advice ability'), ('Relationship Management ', 'Relationship Management'), ('Charisma ', 'Charisma'), ('Discipline ', 'Discipline'), ('Decisiveness', 'Decisiveness'), ('Assertiveness', 'Assertiveness'), ('Flexibility', 'Flexibility'), ('Leadership', 'Leadership'), ('Holistic_thinking', 'Holistic thinking'), ('Patience', 'Patience'), ('Credibility', ' Credibility'), ('Helpfulness', ' Helpfulness'), ('Communication skills', 'Communication skills'), ('Concept Development', 'Concept Development'), ('Ability to cooperate', 'Ability to cooperate'), ('Creativity Techniques', 'Creativity Techniques'), ('Customer focus', 'Customer focus'), ('Logical thinking', 'Logical thinking'), ('Solution oriented', 'Solution oriented'), ('Organizational capacity', 'Organizational capacity'), ('Personal responsibility', 'Personal responsibility'), ('Time Management', 'Time Management'), ('Teamwork', 'Teamwork'), ('Environmental Awareness', 'Environmental Awareness'), ('Reliability', 'Reliability'), ('Tolerance', 'Tolerance')], max_length=255)),
                ('language', multiselectfield.db.fields.MultiSelectField(choices=[('english', 'english'), ('french', 'french'), ('german', 'german'), ('spanish', 'spanish'), ('italian', 'italian'), ('portuguese', 'portuguese'), ('russian', 'russian'), ('arabic', 'arabic'), ('chinese', 'chinese'), ('japanese', 'japanese'), ('korean', 'korean'), ('hindi', 'hindi'), ('bengali', 'bengali')], max_length=255)),
                ('job_title', models.CharField(choices=[('Public Relations', 'Public Relations'), ('Brand Manager', 'Brand Manager'), ('Seo Manager', 'Seo Manager'), ('Media Buyer', 'Media Buyer'), ('SQL Developer', 'SQL Developer'), ('Web Designer', 'Web Designer'), ('Web Developer', 'Web Developer'), ('Software Engineer', 'Software Engineer'), ('Data Entry', 'Data Entry'), ('IT Manager', 'IT Manager'), ('Backend Developer', 'Backend Developer'), ('Frontend Developer', 'Frontend Developer'), ('Receptionist', 'Receptionist'), ('Office Manager', 'Office Manager'), ('Auditing Clerk', 'Auditing Clerk'), ('Bookkeeper', 'Bookkeeper'), ('Account Executive', 'Account Executive'), ('Branch Manager', 'Branch Manager'), ('Business Manager', 'Business Manager'), ('Human Resources', 'Human Resources'), ('Office Assistant', 'Office Assistant'), ('Secretary', 'Secretary')], max_length=100)),
                ('image', models.ImageField(blank=True, null=True, upload_to='customer/')),
                ('cv', models.FileField(blank=True, null=True, upload_to='CV/')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Job',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('is_active', models.BooleanField(default=True)),
                ('position', models.CharField(blank=True, choices=[('Public Relations', 'Public Relations'), ('Brand Manager', 'Brand Manager'), ('Seo Manager', 'Seo Manager'), ('Media Buyer', 'Media Buyer'), ('SQL Developer', 'SQL Developer'), ('Web Designer', 'Web Designer'), ('Web Developer', 'Web Developer'), ('Software Engineer', 'Software Engineer'), ('Data Entry', 'Data Entry'), ('IT Manager', 'IT Manager'), ('Backend Developer', 'Backend Developer'), ('Frontend Developer', 'Frontend Developer'), ('Receptionist', 'Receptionist'), ('Office Manager', 'Office Manager'), ('Auditing Clerk', 'Auditing Clerk'), ('Bookkeeper', 'Bookkeeper'), ('Account Executive', 'Account Executive'), ('Branch Manager', 'Branch Manager'), ('Business Manager', 'Business Manager'), ('Human Resources', 'Human Resources'), ('Office Assistant', 'Office Assistant'), ('Secretary', 'Secretary')], max_length=100, null=True)),
                ('workplace', models.CharField(blank=True, choices=[('ON SITE', 'on site'), ('REMOTE', 'Remote'), ('HYBRID', 'Hybrid')], max_length=30, null=True)),
                ('location', models.CharField(blank=True, choices=[('Baghdad', 'Baghdad'), ('Basrah', 'Basrah'), ('Arbil', 'Arbil'), ('Sulaymaniyah', 'Sulaymaniyah'), ('Karkh', 'Karkh'), ('Karbala', 'Karbala'), ('Najaf', 'Najaf'), ('Ramadi', 'Ramadi'), ('Hillah', 'Hillah'), ('Nasiriyah', 'Nasiriyah'), ('Duhok', 'Duhok')], max_length=40, null=True)),
                ('employment_type', models.CharField(blank=True, choices=[('FULL TIME', 'Full time'), ('PART TIME', 'Part time')], max_length=30, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('expire_date', models.DateField(blank=True, null=True)),
                ('is_featured', models.BooleanField(blank=True, default=False, null=True)),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='job', to='cv.companyprofile')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Company',
            fields=[
                ('user_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to=settings.AUTH_USER_MODEL)),
                ('phone', models.CharField(blank=True, default='Phone', max_length=50, null=True)),
                ('status', models.CharField(choices=[('PENDING', 'pending'), ('APPROVED', 'approved')], default='PENDING', max_length=50)),
                ('country', models.CharField(blank=True, default='Iraq', max_length=50, null=True)),
            ],
            options={
                'abstract': False,
            },
            bases=('cv.user',),
            managers=[
                ('Company', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='Customer',
            fields=[
                ('user_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to=settings.AUTH_USER_MODEL)),
                ('phone', models.CharField(blank=True, default='Phone', max_length=50, null=True)),
                ('status', models.CharField(choices=[('PENDING', 'pending'), ('APPROVED', 'approved')], default='APPROVED', max_length=50)),
            ],
            options={
                'abstract': False,
            },
            bases=('cv.user',),
            managers=[
                ('Customer', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='WorkExperience',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('is_active', models.BooleanField(default=True)),
                ('title', models.CharField(choices=[('Public Relations', 'Public Relations'), ('Brand Manager', 'Brand Manager'), ('Seo Manager', 'Seo Manager'), ('Media Buyer', 'Media Buyer'), ('SQL Developer', 'SQL Developer'), ('Web Designer', 'Web Designer'), ('Web Developer', 'Web Developer'), ('Software Engineer', 'Software Engineer'), ('Data Entry', 'Data Entry'), ('IT Manager', 'IT Manager'), ('Backend Developer', 'Backend Developer'), ('Frontend Developer', 'Frontend Developer'), ('Receptionist', 'Receptionist'), ('Office Manager', 'Office Manager'), ('Auditing Clerk', 'Auditing Clerk'), ('Bookkeeper', 'Bookkeeper'), ('Account Executive', 'Account Executive'), ('Branch Manager', 'Branch Manager'), ('Business Manager', 'Business Manager'), ('Human Resources', 'Human Resources'), ('Office Assistant', 'Office Assistant'), ('Secretary', 'Secretary')], max_length=100)),
                ('company_worked_for', models.CharField(max_length=50)),
                ('start_date', models.DateField(blank=True, null=True)),
                ('end_date', models.DateField(blank=True, default=None, null=True)),
                ('customer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='work_experience', to='cv.customerprofile')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='JobApplication',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('is_active', models.BooleanField(default=True)),
                ('category', models.CharField(choices=[('LONG_LIST', 'Long List'), ('SHORT LIST', 'Short List'), ('ALL', 'All')], default='ALL', max_length=30)),
                ('why_apply', models.TextField(blank=True, null=True)),
                ('customer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='job_application', to='cv.customerprofile')),
                ('job', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='job_application', to='cv.job')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Education',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('is_active', models.BooleanField(default=True)),
                ('degree', models.CharField(blank=True, max_length=255, null=True)),
                ('school', models.CharField(blank=True, max_length=255, null=True)),
                ('start_date', models.DateField(blank=True, null=True)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('customer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='education', to='cv.customerprofile')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='customerprofile',
            name='saved_job',
            field=models.ManyToManyField(blank=True, related_name='job', to='cv.job'),
        ),
        migrations.AddField(
            model_name='customerprofile',
            name='user',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='customer_profile', to='cv.customer'),
        ),
        migrations.AddField(
            model_name='companyprofile',
            name='user',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='company_profile', to='cv.company'),
        ),
    ]
