#import "../components/prelude.typ": *

= 总结和展望

== 亮点与创新

1. 内存管理：TLB 是用于加速虚拟地址到物理地址转换的硬件缓存。当 CPU 需要访问内存时，首先在 TLB 中查找对应的虚拟地址。如果找到，则直接使用 TLB 中缓存的物理地址，避免了访问页表的开销。如果未命中，则需要访问页表以进行地址转换。找到物理地址后，将该映射缓存到 TLB 中，以便后续访问更快。MinotaurOS 充分利用了 RISC-V 的 ASID 机制，对 TLB 刷新做了优化，减少了刷新带来的开销，提高了效率。

2. 进程管理：MinotaurOS 通过协程执行器管理用户线程和内核线程，实现了用户线程和内核线程的统一调度。

3. 浮点寄存器优化：使用浮点寄存器状态机，精细化管理浮点寄存器的保存和恢复操作。只有在浮点寄存器被修改后才标记为脏，只有在必要时才进行保存和恢复操作。这样可以减少不必要的浮点寄存器操作，降低开销。通过减少浮点寄存器操作的频率，降低了系统的开销，提高了系统的响应速度和整体性能。在处理多线程、多进程以及频繁的用户态和内核态切换时，能够显著提高响应速度和稳定性。

#figure(
  grid(
    columns: 2,
    image("img/nooptim.png", width: 80%),
    image("img/optim.png"),
  ),
  caption: [性能优化前后对比],
)

== 问题与挑战

目前 MinotaurOS 还存在一些复杂的挑战，例如需要适配 LTP 测试用例、支持更多的 Linux 系统调用、优化文件系统等。在未来的工作中，我们将继续努力，解决这些问题，提高 MinotaurOS 的性能和稳定性。