---
layout: default
title: examples
---

# Examples

The [examples](https://github.com/Dovyski/cvui/tree/master/example) folder contains several small-sized apps that demonstrate each component of cvui. Below is a list of all available examples. You can [build all examples](../build) using [cmake](https://cmake.org).

* [button-shortcut](https://github.com/Dovyski/cvui/tree/master/example/src/button-shortcut): how to use buttons with labels triggering keyboard shortcuts, e.g. `&Quit` will trigger the button when `Q` is pressed on the keyboard.

* [canny](https://github.com/Dovyski/cvui/tree/master/example/src/canny): use checkboxes and sliders to dynamically apply and control the Canny Edge algorithm on an image.

* [complext-layout](https://github.com/Dovyski/cvui/tree/master/example/src/complext-layout): use of several components to create a complex UI.

* [hello-world](https://github.com/Dovyski/cvui/tree/master/example/src/hello-world): simple demonstration of the basics of cvui.

* [image-button](https://github.com/Dovyski/cvui/tree/master/example/src/image-button): use of buttons with custom rendering based on images.

* [interaction-area](https://github.com/Dovyski/cvui/tree/master/example/src/interaction-area): tracking of mouse status within an area on the screen, e.g. over, clicked, etc.

* [main-app](https://github.com/Dovyski/cvui/tree/master/example/src/main-app): simple application showcasing several components of cvui.

* [mouse](https://github.com/Dovyski/cvui/tree/master/example/src/mouse): shows the capabilities of cvui's mouse API with a rectangle on the screen that can be adjusted with mouse clicks and drags.

* [mouse-complex](https://github.com/Dovyski/cvui/tree/master/example/src/mouse-complex): shows more advanced capabilities of cvui's mouse API allowing the dynamic creation of a ROI for image visualization.

* [mouse-complex-buttons](https://github.com/Dovyski/cvui/tree/master/example/src/mouse-complex-buttons): uses the fine details of cvui's mouse API to dynamically
create ROIs for image visualization based on different mouse buttons.

* [multiple-files](https://github.com/Dovyski/cvui/tree/master/example/src/multiple-files): demonstrates how to use cvui when a project has multiple files that include `cvui.h`, e.g. multiple classes.

* [multiple-windows](https://github.com/Dovyski/cvui/tree/master/example/src/multiple-windows): demonstrates how you to use cvui in an application that uses
more than one OpenCV window.

* [multiple-windows-complex](https://github.com/Dovyski/cvui/tree/master/example/src/multiple-windows-complex): demonstrates how you to use cvui in an application that uses
more than one OpenCV window relying on rows and colums for layout creation.

* [multiple-windows-complex-dynamic](https://github.com/Dovyski/cvui/tree/master/example/src/multiple-windows-complex-dynamic): demonstrates how you to use cvui in an application that uses more than one OpenCV window which are open/closed programmatically.

* [multiple-windows-complex-mouse](https://github.com/Dovyski/cvui/tree/master/example/src/multiple-windows-complex-dynamic): demonstrates how you to use mouse API with multiple OpenCV windows.

* [nested-rows-columns](https://github.com/Dovyski/cvui/tree/master/example/src/nested-rows-columns): how to use nested rows and columns.

* [on-image](https://github.com/Dovyski/cvui/tree/master/example/src/on-image): simple application where the user can dynamically adjust colors of an image during runtime.

* [row-column](https://github.com/Dovyski/cvui/tree/master/example/src/row-column): how to use rows and columns.

* [sparkline](https://github.com/Dovyski/cvui/tree/master/example/src/sparkline): load an external CSV file and plot its lines/values using a sparkline.

* [trackbar](https://github.com/Dovyski/cvui/tree/master/example/src/trackbar): how to use the trackbar (slider) component.

* [trackbar-complex](https://github.com/Dovyski/cvui/tree/master/example/src/trackbar-complex): a more complex use of trackbar, including customizations and discrete values.

* [trackbar-sparkline](https://github.com/Dovyski/cvui/tree/master/example/src/trackbar-sparkline): dynamic generation of points for a sparline during runtime as a result of the interaction with a trackbar.

* [ui-enhanced-canny](https://github.com/Dovyski/cvui/tree/master/example/src/ui-enhanced-canny): more sophisticated use of the window component, which is enhanced to become a movable and minimizable settings window to dynamically apply and control the Canny Edge algorithm on an image.

* [ui-enhanced-window-component](https://github.com/Dovyski/cvui/tree/master/example/src/ui-enhanced-window-component): demonstrates how the window component of cvui can be
enhanced, i.e. make it movable and minimizable.
