# Awesome Software and Architectural Design Patterns 
<br>

<img alt="PRs Welcome" src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg" /> <a href="https://gitter.im/awesome-design-patterns/Lobby"><img src="https://badges.gitter.im/awesome-design-patterns/Lobby.svg" alt="awesome"></a> <a href="http://awesome.re"><img src="https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg" alt="awesome"></a> 

<br>

> A curated list of software and architecture related design patterns.

[Software design pattern](https://en.wikipedia.org/wiki/Software_design_pattern) - A general, reusable solution to a commonly occurring problem within a given context in software design. It is a description or template for how to solve a problem that can be used in many different situations. 



<br>

## Contents
- [Programming language design patterns](#programming-language-design-patterns)
- [General Architecture](#general-architecture)
- [Cloud Architecture](#cloud-architecture)
- [Serverless Architecture](#serverless-architecture)
- [Micro services & Distributed Systems](#micro-services--distributed-systems)
- [Internet of things](#internet-of-things)
- [Big Data](#big-data)
- [Machine Learning](#machine-learning)
- [Databases and storage](#databases)
- [DevOps & containers](#devops--containers)
- [Mobile](#mobile)
- [Front End Development](#front-end-development)
- [Security](#security)

<br>

## Programming Language Design Patterns

- AngularJS
	- [design patterns](https://github.com/mgechev/angularjs-in-patterns)
- C#
	- [design-patterns](https://github.com/abishekaditya/DesignPatterns) 
	- [design-patterns-for-human](https://github.com/anupavanm/csharp-design-patterns-for-humans) - ultra simplified explanation to design patterns.
	- [Design Patterns Library](https://github.com/nemanjarogic/DesignPatternsLibrary)
- C++
	- [design-patterns](http://www.vincehuston.org/dp/)
- Closure
	- [design-patterns](https://arturoherrero.com/closure-design-patterns/)
- Go
	- [design-patterns](https://github.com/tmrts/go-patterns)
- Java
	- [sourcemaking](https://sourcemaking.com/design_patterns) - patterns and anti patterns.
	- [oodesign](https://www.oodesign.com/)  - patterns catalog with UML diagrams.
	- [design-patterns](https://github.com/iluwatar/java-design-patterns)
	- [effective-java patterns](https://github.com/HugoMatilla/Effective-JAVA-Summary) - patterns from the Effective Java book.
	- [Design patterns implemented in Java](https://java-design-patterns.com/patterns/)
	- [Effective-Java-3rd-Joshua-Bloch](https://www.amazon.com/Effective-Java-3rd-Joshua-Bloch/dp/0134685997/ref=pd_sim_14_7)
- JavaScript
	- [es6 design patterns](https://github.com/ziyasal/design-patterns-and-idioms-in-es6)
	- [humans](https://github.com/sohamkamani/javascript-design-patterns-for-humans) - ultra simplified explanation to design patterns.
	- [design-patterns](https://github.com/nnupoor/js_designpatterns)
	- [design patterns by addy osmani](https://addyosmani.com/resources/essentialjsdesignpatterns/book)
- Kotlin
	- [design-patterns](https://github.com/dbacinski/Design-Patterns-In-Kotlin) 
- Node
	- [Real world design patterns with Node.js](https://github.com/nimit95/Real-world-Design-Patterns-Node-JS)
	- [Node.js Design Patterns](https://www.packtpub.com/web-development/nodejs-design-patterns-second-edition)
- Object Oriented
	- [Design-Patterns-Elements-Reusable-Object-Oriented](https://www.amazon.com/Design-Patterns-Elements-Reusable-Object-Oriented/dp/0201633612/ref=sr_1_4?s=books&ie=UTF8&qid=1528136036&sr=1-4&keywords=design+patterns)
	- [Head-First-Design-Patterns-Brain-Friendly](https://www.amazon.com/Head-First-Design-Patterns-Brain-Friendly/dp/0596007124/ref=pd_sim_14_4)
	- [Object Design Style Guide](https://www.manning.com/books/object-design-style-guide)
- PHP
	- [humans](https://github.com/kamranahmedse/design-patterns-for-humans) - ultra simplified explanation to design patterns.
	- [design-patterns](https://github.com/domnikl/DesignPatternsPHP) 
- Python
	- [design-patterns](https://github.com/faif/python-patterns) 
	- [PyPattyrn](https://github.com/tylerlaberge/PyPattyrn) - A simple library for implementing common design patterns.
	- [Python Design Patterns](https://python-patterns.guide/)
	- [Design Patterns in Python](https://refactoring.guru/design-patterns/python)
	- [Django Design Patterns and Best Practices](https://arunrocks.com/static/book/django-design-patterns-best-practices-2-ed)
- React
	- [design-patterns](http://krasimirtsonev.com/blog/article/react-js-in-design-patterns)
	- [react-bits](https://github.com/vasanthk/react-bits)
	- [reactpatterns.com](https://reactpatterns.com)
- Ruby
	- [design-patterns](https://github.com/davidgf/design-patterns-in-ruby) 
- Rust
	- [design-patterns](https://rust-unofficial.github.io/patterns/) 

- Scala
	- [design-patterns](https://github.com/josephguan/scala-design-patterns)
- Swift
	- [design-patterns](https://github.com/ochococo/Design-Patterns-In-Swift)
- TypeScript
	- [design-patterns](https://github.com/torokmark/design_patterns_in_typescript)
- UML
	- [design-patterns quick reference](http://www.mcdonaldland.info/2007/11/28/40)
	- [design-patterns cheat-sheet](https://www.slideshare.net/hustwj/design-patterns-cheat-sheet)
- Vue.js
	- [Vue Patterns](https://learn-vuejs.github.io/vue-patterns/) - Useful Vue patterns, techniques, tips and tricks and curated helpful links.
- Elixir
	- [design-patterns](https://github.com/joshnuss/design-patterns-in-elixir)
	- [the-pipeline](https://mattpruitt.com/articles/the-pipeline) - The Pipeline is defined by a collection of functions that take a data structure as an argument and return the same type of data structure
	
	
## General Architecture
- [10 common architectural patterns](https://towardsdatascience.com/10-common-software-architectural-patterns-in-a-nutshell-a0b47a1e9013) - 10 Common software architectural patterns in a nutshell.
- [reactive design patterns](https://www.reactivedesignpatterns.com/categories.html) - This website accompanies the book Reactive Design Patterns by Roland Kuhn.
- [scalable System Design Patterns](https://dzone.com/articles/scalable-system-design) - Scalable system design techniques.
- [martin fowler](https://martinfowler.com/eaaCatalog) - Catalog of Patterns of Enterprise Application Architecture.
- [system-design-primer](https://github.com/donnemartin/system-design-primer) - Design large-scale systems.
- [architecting-for-reliability](https://medium.com/becloudy/architecting-for-reliability-part-1-concepts-17028343089) - Architecting for Reliability Part 1/3.
- [InnerSource Patterns](https://patterns.innersourcecommons.org/) - Patterns for implementing InnerSource, the use of open source principles and practices for software development within the confines of an organization.


## Cloud Architecture
- [Cloud cost hacking](https://hackernoon.com/cloud-cost-hacking-fc35fd19985d) - Patterns for reducing cloud costs. 
- [AWS cloud design patterns](http://en.clouddesignpattern.org/index.php/Main_Page) - The AWS Cloud Design Patterns (CDP).
- [Azure cloud design patterns](https://docs.microsoft.com/en-us/azure/architecture/patterns) - Building reliable, scalable, secure applications in the cloud.
- [cloud computing patterns](http://www.cloudcomputingpatterns.org) - Cloud Computing Patterns.
- [Google Cloud Solutions](https://gcp.solutions) - Real business cases solutions with diagrams on GCP.
- [saas tenant isolation strategies](https://d1.awsstatic.com/whitepapers/saas-tenant-isolation-strategies.pdf) - Isolating Resources in a Multi-Tenant Environment
- [design patterns for multi-tenancy](https://www.nagarro.com/en/blog/architectural-design-patterns-aws-multi-tenancy) - Architectural design patterns for multi-tenancy on AWS


## Serverless Architecture
- [serverless architecture](https://thenewstack.io/serverless-architecture-five-design-patterns) - Serverless Architecture: Five Design Patterns.
- [solving problems in serverless](https://freecontent.manning.com/patterns-for-solving-problems-in-serverless-architectures) - Patterns for Solving Problems in Serverless Architectures.
- [serverless patterns](https://www.jeremydaly.com/serverless-microservice-patterns-for-aws/) - serverless microservice patterns for aws.
- [serverless-reference-architectures](https://www.jeremydaly.com/serverless-reference-architectures//) - serverless microservice patterns with deployment scripts.
- [serverless-patterns-collection](https://serverlessland.com/patterns) - Serverless Patterns Collection.
- [serverless-design-patterns-and-best-practices](https://www.packtpub.com/free-ebook/serverless-design-patterns-and-best-practices/9781788620642)


## Micro services & Distributed Systems
- [microservices](http://microservices.io/patterns) - A pattern language for microservices.
- [microservices-anti patterns](https://www.oreilly.com/ideas/microservices-antipatterns-and-pitfalls) - Microservices antipatterns and pitfalls.
- [12factor](https://12factor.net) - The twelve-factor methodology.
- [microservices-sync-vs-async](https://dzone.com/articles/patterns-for-microservices-sync-vs-async) - Microservices patterns, synchronous and asynchronous.
- [message-queues](http://tech.forter.com/comparing-message-queue-architectures-on-aws) - Comparing-message-queue-architectures.
- [enterprise Integration Patterns](http://www.enterpriseintegrationpatterns.com/patterns/messaging/toc.html) - Patterns and Best Practices for Enterprise Integration.
- [martinfowler](https://martinfowler.com/articles/patterns-of-distributed-systems/) - Patterns of Distributed Systems.

## Internet of things
- [iot-communication-patterns](https://dzone.com/articles/strengths-and-weaknesses-of-iot-communication-patterns) - Strengths and Weaknesses of IoT Communication Patterns.
- [design-patterns-for-iot](https://community.arm.com/iot/b/blog/posts/design-patterns-for-an-internet-of-things) - A Design Pattern Framework for IoT Architecture.

## Big Data
- [mapreduce-patterns](https://highlyscalable.wordpress.com/2012/02/01/mapreduce-patterns) - Map-reduce patterns.
- [streaming-realtime-analytics](https://iwringer.wordpress.com/2015/08/03/patterns-for-streaming-realtime-analytics) - 13 Stream Processing Patterns for building Streaming and Realtime Applications.

## Machine Learning
- [distributed-ml-patterns](https://github.com/terrytangyuan/distributed-ml-patterns) - Distributed machine learning system patterns.

## Databases and Storage
- SQL
	- [database tenancy patterns](https://docs.microsoft.com/en-us/azure/sql-database/saas-tenancy-app-design-patterns) - Multi-tenant SaaS database tenancy patterns
	- [databaseanswers](http://www.databaseanswers.org/data_models) -  Industry-specific SQL Data Models in 50 categories.
	- [database-programmer](http://database-programmer.blogspot.com/2008/01/table-design-patterns.html) - Table-design-patterns.
	- [red-gate](https://www.red-gate.com/simple-talk/sql/database-administration/five-simple-database-design-errors-you-should-avoid) -  five simple database design errors you should avoid.
	- [talend](https://www.talend.com/blog/2017/05/05/data-model-design-best-practices-part-1) - Data model design best practices. 
	- [sqlcheck](https://github.com/jarulraj/sqlcheck) - Anti-patterns in SQL queries.
	- [Data warehouse patterns](https://aws.amazon.com/blogs/big-data/etl-and-elt-design-patterns-for-lake-house-architecture-using-amazon-redshift-part-1/) - ETL and ELT design patterns for lake house architecture using Amazon Redshift
- NOSQL
	- [nosql resilience patterns](https://www.ebayinc.com/stories/blogs/tech/practical-nosql-resilience-design-pattern-for-the-enterprise) - Practical NoSQL resilience design pattern for the enterprise.
	- [nosql-patterns](https://dzone.com/articles/introduction-nosql-patterns) - Pragmatic Programming Techniques.
	- [mongodb](https://dzone.com/articles/mongodb-design-patterns) - Mongodb design patterns.
	- [MongoDB Applied Design Patterns](http://shop.oreilly.com/product/0636920027041.do)
	- [DynamoDB design patterns](https://amazon-dynamodb-labs.com/design-patterns.html)- Advanced design patterns for Amazon DynamoDB
	- [Redis applied design patterns](https://redislabs.com/redis-best-practices/introduction/) - Redis Applied Design Patterns book
- Storage
	- [storage patterns](https://aws.amazon.com/blogs/storage/comparing-your-on-premises-storage-patterns-with-aws-storage-services/)- Comparing your on-premises storage patterns with AWS Storage services
	- [S3 Design Patterns](https://d1.awsstatic.com/whitepapers/AmazonS3BestPractices.pdf) - Best Practices Design Patterns: Optimizing Amazon S3 Performance

## DevOps & containers
- [containerspatterns](https://l0rd.github.io/containerspatterns) - There are a Thousand Ways to Use Containers.
- [kubernetes](https://github.com/gravitational/workshop/blob/master/k8sprod.md) - Kubernetes Production Patterns.
- [container-design-patterns](https://vitalflux.com/container-design-patterns-kubernetes-pods-design) - Container Design Patterns for Kubernetes Pods Design.
- [best-practices-for-shell-scripts](https://stackoverflow.com/questions/78497/design-patterns-or-best-practices-for-shell-scripts) - Best practices for shell scripts.
- [kubernetes patterns](https://github.com/ro14nd-talks/kubernetes-patterns) - Presentation around the book kubernetes paterns.
- [kubernetes patterns book](https://k8spatterns.io/)
- [cdk patterns](https://cdkpatterns.com/) - cdk patterns.
- [CDK Construct Catalog](https://awscdk.io/) - CDK construct catalog.
 

## Mobile
- IOS
	- [ios-architecture-patterns](https://medium.com/ios-os-x-development/ios-architecture-patterns-ecba4c38de52)
- Android
	- [design-patterns-for-android](https://www.raywenderlich.com/109843/common-design-patterns-for-android) -  Common Design Patterns for Android. 
	- [mvc-mvp-and-mvvm](https://academy.realm.io/posts/eric-maxwell-mvc-mvp-and-mvvm-on-android) -  The MVC, MVP, and MVVM Smackdown. 
	
	
## Front-End Development
- [user Interface](http://ui-patterns.com) - User Interface Design patterns.
- [oocss-acss-bem-smacss](http://clubmate.fi/oocss-acss-bem-smacss-what-are-they-what-should-i-use) - OOCSS, ACSS, BEM, SMACSS: what are they? What should I use?
- [css-protips](https://github.com/AllThingsSmitty/css-protips) - A collection of tips to help take your CSS skills pro.
- [responsive design patterns](https://bradfrost.github.io/this-is-responsive/patterns.html#layout) - A collection of patterns and modules for responsive designs.
- [front-End Architecture]
	- [mv*](https://proandroiddev.com/mvc-mvp-mvvm-clean-viper-redux-mvi-prnsaaspfruicc-building-abstractions-for-the-sake-of-building-18459ab89386) - MVC/MVP/MVVM/CLEAN/VIPER/REDUX/MVI/PRNSAASPFRUICC.
	- [martinfowler](https://martinfowler.com/eaaDev/uiArchs.html) - GUI Architectures.

## Security
- [opensecurityarchitecture](http://www.opensecurityarchitecture.org/cms/library/patternlandscape) - Security Architecture Patterns.
- [martinfowler](https://www.martinfowler.com/articles/web-security-basics.html) - Web-security-basics.
- [cloud-security](https://www.infoq.com/articles/cloud-security-architecture-intro) - Cloud security architecture intro.
- [owasp](https://www.owasp.org/index.php/Security_by_Design_Principles) - Security by Design Principles.
- [azure-security](https://docs.microsoft.com/en-us/azure/security/security-best-practices-and-patterns) - Azure security best practices and patterns.

## Books
- [Django Design Patterns and Best Practices](https://arunrocks.com/static/book/django-design-patterns-best-practices-2-ed)
- [MongoDB Applied Design Patterns](http://shop.oreilly.com/product/0636920027041.do)
- [Design-Patterns-Elements-Reusable-Object-Oriented](https://www.amazon.com/Design-Patterns-Elements-Reusable-Object-Oriented/dp/0201633612/ref=sr_1_4?s=books&ie=UTF8&qid=1528136036&sr=1-4&keywords=design+patterns)
- [Head-First-Design-Patterns-Brain-Friendly](https://www.amazon.com/Head-First-Design-Patterns-Brain-Friendly/dp/0596007124/ref=pd_sim_14_4)
- [Effective-Java-3rd-Joshua-Bloch](https://www.amazon.com/Effective-Java-3rd-Joshua-Bloch/dp/0134685997/ref=pd_sim_14_7)
- [Node.js Design Patterns](https://www.packtpub.com/web-development/nodejs-design-patterns-second-edition)
- [Game Programming Patterns](https://github.com/munificent/game-programming-patterns)
- [Object Design Style Guide](https://www.manning.com/books/object-design-style-guide)
- [Spring Boot in Practice](https://www.manning.com/books/spring-boot-in-practice)
- [Designing Microservices](https://www.manning.com/books/designing-microservices)

## Other Awesome Lists
- Other amazingly awesome lists can be found in the [awesome](https://github.com/sindresorhus/awesome) list.

## Contributing
- Your contributions are always welcome! Please read the [contribution guidelines](contributing.md) first.

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0) 


To the extent possible under law, [Dov Amir](https://github.com/DovAmir) has waived all copyright and related or neighboring rights to this work.
