/**
 +----------------------------------------------------------
 * 监听
 +----------------------------------------------------------
 */
$(function() {
    if ($(".attribute-list").length > 0) {
        $('.attribute-list .radio-box input[type="radio"]').on('change', function() {
            var price_text = $('.attribute-list').data('price');

            var money = Number(price_text.match(/\d+.\d+/g));
            $('.attribute-list .radio-box input[type="radio"]').each(function() {
                if ($(this).prop('checked')) {
                    money += Number($(this).data('money'));
                }
            });

            var newMoney = price_text.replace(/\d+.\d+/g, money.toFixed(2));
            
            $('.product-price .price').text(newMoney);
        }).trigger('change'); // 初始化时触发一次更新
    }
});

/**
 +----------------------------------------------------------
 * 主图
 +----------------------------------------------------------
 */
var galleryThumbs = new Swiper('.gallery-thumbs', {
  spaceBetween: 10,
  slidesPerView: 5,
  freeMode: true,
  watchSlidesVisibility: true,
  watchSlidesProgress: true,
});
var galleryTop = new Swiper('.gallery-top', {
  spaceBetween: 10,
  navigation: {
    nextEl: '.swiper-button-next',
    prevEl: '.swiper-button-prev',
  },
  thumbs: {
    swiper: galleryThumbs
  }
});