// index.js
// 获取全局的应用实例
const app = getApp();

// 引入utils全局函数
var dou = require('../../utils/util.js');

Page({
  data: {
    dataBox: [],
    curMenu: 'main',
    headerHeight: 156,
    indicatorDots: true, // 是否显示面板指示点
    indicatorColor: 'rgba(0, 0, 0, .3)', // 指示点颜色
    indicatorActiveColor: '#FF0000', // 高亮颜色
    autoplay: true,
    interval: 5000, // 自动切换时间间隔
    duration: 500, // 滑动动画时长
    imgheight: '', // 图片最终显示大小是根据imgwidth/imgheight比例然后进行同比例缩放
    locationMode: 'fold'
  },
  
  onLoad: function() {
    var that = this;
   
    wx.setNavigationBarTitle({
      title: app.title.site_name
    })

    // 显示转发按钮
    dou.showShareMenu()
    
    wx.request({ // 同时只能有5个wx.request（网络请求连接）
      url: app.mp_url + 'databox.php?rec=common',
      success: function(res) {
        that.setData({
          lang: res.data.lang,
          site: res.data.site,
          box_list: res.data.box_list,
          fragment: res.data.fragment,
          nav_list: res.data.nav_list
        })
      },
    })

    wx.request({
      url: app.mp_url,
      data: {
        'user_id': wx.getStorageSync('user_id'),
        'shell': wx.getStorageSync('shell')
      },
      header: {
        'Connect-Key' : wx.getStorageSync('connect_key')
      },
      success: function(res) {
        that.setData({
          data: res.data
        })
      },
    })
     
    that.setData({
      windowHeight: wx.getSystemInfoSync().windowHeight
    })
  },
 
  onShow: function () {
    var that = this;
    
    // 在tabBar第三个图标中显示购物车数量
    dou.showCartNumber()
  },
 
  onReady: function() {
    var that = this;

   
    // 延迟加载框架，防止获取节点错误
    setTimeout(function () {
      var query = wx.createSelectorQuery()

      query.select('.header').boundingClientRect(function (res) {
        that.setData({
         headerHeight: res.height
        })
      }).exec()
      
      query.selectAll('.scroll-box').boundingClientRect(function (rects) {
        //console.log(rects)
        var dataBox = []
        rects.forEach(function (rect) {
          dataBox[rect.id] = rect; // 合并数组
        })

        that.setData({
          dataBox: dataBox,
          dataOrg: rects
        })
      }).exec()

    }, 1000)
  },
  
  // 监听滚动事件 scrollTop 滚动的距离  
  onPageScroll: function (e) { // 获取滚动条当前位置
    var that = this;
    
    for (let i = 0; i < that.data.dataOrg.length; i++) {
      if (e.scrollTop > that.data.dataOrg[i].top - that.data.headerHeight && e.scrollTop < this.data.dataOrg[i].bottom - that.data.headerHeight && !that.data.scrollBottom) {
        that.setData({
          curMenu: that.data.dataOrg[i].id
        })
        break;
      }
    }
   
    wx.createSelectorQuery().select('.footer').boundingClientRect(function (res) {
      if (res.bottom.toFixed(0) < that.data.windowHeight + 5) {
        that.setData({
          curMenu: that.data.dataOrg[that.data.dataOrg.length-1].id
        })
      }
    }).exec()
  },
  
  // 点击跳转到板块一
  scrollTo: function (e) {
    var that = this;
    
    wx.pageScrollTo({
      scrollTop: that.data.dataBox[e.currentTarget.dataset.id].top - that.data.headerHeight,
      duration: 0
    })
    
    that.setData({
      curMenu: e.currentTarget.dataset.id
    })
  },

  // location显示隐藏
  locationAction: function() {
    this.setData({
      locationMode: this.data.locationMode == 'fold' ? 'pop' : 'fold'
    })
  },

  imageLoad: function(e) {
    var windowWidth = wx.getSystemInfoSync().windowWidth
    //获取可使用窗口宽度
    var height = e.detail.height
    //获取图片实际高度
    var width = e.detail.width
    //获取图片实际宽度
    var imgheight = windowWidth * height / width +"px"
    //计算等比swiper高度
    this.setData({
      imgheight: imgheight
    })
  },
 
  // 防止swiper卡顿
  swiperbindchange: function(e) {
    if (e.detail.source == "touch" || e.detail.source == "autoplay") {
      this.setData({
        current: e.detail.current
      })
      
      //防止swiper控件卡死
      if (this.data.current == 0 && this.data.rightcurrent > 1) { //卡死时，重置current为正确索引
        this.setData({
          current: this.data.rightcurrent
        });
      } else { //正常轮转时，记录正确页码索引
        this.setData({
          rightcurrent: this.data.current
        });
      }
    }
  },

  // 传入参数重新加载
  douCategory: function(e) {
    wx.setStorageSync('product_category_id', e.currentTarget.dataset.category_id)
    
    var url = e.currentTarget.dataset.url;
    wx.switchTab({
      url: url
    })
  },

  // 非tabBar的页面，可以带参数
  douNavigateTo: function(e) {
    var url = e.currentTarget.dataset.url;
    wx.navigateTo({
      url: url
    })
  },

  // 只能跳转到tabBar配置页面
  douSwitchTab: function(e) {
    var url = e.currentTarget.dataset.url;
    wx.switchTab({
      url: url
    })
  },

  // 只能跳转到tabBar配置页面
  catSwitchTab: function(e) {
    wx.setStorageSync('cat_id', e.currentTarget.dataset.cat_id)
    var url = e.currentTarget.dataset.url;
    wx.switchTab({
      url: url
    })
  }

})