// pages/article/article.js
// 获取全局的应用实例
const app = getApp();

// 引入utils全局函数
var dou = require('../../utils/util.js');

Page({
  onLoad: function(options) {
    var that = this
        
    wx.setNavigationBarTitle({
      title: app.title.article_detail
    })

    // 显示转发按钮
    dou.showShareMenu()
        
    wx.request({
      url: app.mp_url + 'databox.php?rec=common',
      success: function(res) {
        that.setData({
          lang: res.data.lang,
          site: res.data.site
        })
      },
    })

    wx.request({
      url: app.mp_url + 'article.php',
      data: {
        id: options.id
      },
      success: function(res) {
        that.setData({
          article: res.data.article,
          defined: res.data.defined
        })
       
        // 设置转发标题缓存
        wx.setStorageSync('shareTitle', res.data.article.title)
      },
    })

  },

  // 设置转发标题
  onShareAppMessage: function (options) {
    return {
      title: wx.getStorageSync('shareTitle')
    }
  }

})