# 
# Copyright (c) 2005, 2023 Ricoh Company, Ltd.
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
##### FILE = alluni #####

# TARGET N
# Unicodeの各文字を対象とする基本動作
#
# PROCESS
# UnicodeData.txtを対象とする正規化結果(正規化表記出力)と、正解ファイルとを比較する。
# 
# EFFECT
# 正規化結果が正解ファイルと一致する。

# TARGET N
# Unicodeの各文字を対象とする基本動作
#
# PROCESS
# UnicodeData.txtを対象とする正規化結果(前処理形式出力)から原表記を抽出し、入力ファイルと比較する。
#
# EFFECT
# 抽出結果が入力ファイルと一致する。

# TARGET N
# Unicodeの各文字を対象とする基本動作
#
# PROCESS
# UnicodeData.txtを対象とする正規化結果(前処理形式出力)から正規化表記を抽出し、
# 正規化結果(正規化表記出力)と比較する。
#
# EFFECT
# 抽出結果が正規化結果と一致する。

##### FILE = combimap #####

# TARGET N
# 合字規則を対象とする基本動作
#
# PROCESS
# 合字規則のターゲットを対象とする正規化結果(正規化表記出力)と、正解ファ
# イルとを比較する。
# 
# EFFECT
# 正規化結果が正解ファイルと一致する。

# TARGET N
# 合字規則を対象とする基本動作
#
# PROCESS
# 合字規則のターゲットを対象とする正規化結果(前処理形式出力)から原表記
# を抽出し、入力ファイルと比較する。
#
# EFFECT
# 抽出結果が入力ファイルと一致する。

# TARGET N
# 合字規則を対象とする基本動作
#
# PROCESS
# 合字規則のターゲットを対象とする正規化結果(前処理形式出力)から正規化
# 表記を抽出し、正規化結果(正規化表記出力)と比較する。
#
# EFFECT
# 抽出結果が正規化結果と一致する。

##### FILE = combikana #####

# TARGET N
# 仮名合字パターンを対象とする基本動作
#
# PROCESS
# ひらがな/カタカナの合字パターンを対象とする正規化結果(正規化表記出力)
# と、正解ファイルとを比較する。
# 
# EFFECT
# 正規化結果が正解ファイルと一致する。

# TARGET N
# 仮名合字パターンを対象とする基本動作
#
# PROCESS
# ひらがな/カタカナの合字パターンを対象とする正規化結果(前処理形式出力)
# から原表記を抽出し、入力ファイルと比較する。
#
# EFFECT
# 抽出結果が入力ファイルと一致する。

# TARGET N
# 仮名合字パターンを対象とする基本動作
#
# PROCESS
# ひらがな/カタカナの合字パターンを対象とする正規化結果(前処理形式出力)
# 正規化表記を抽出し、正規化結果(正規化表記出力)と比較する。
#
# EFFECT
# 抽出結果が正規化結果と一致する。

##### FILE = metachouon #####

# TARGET N
# 長音処理パターンを対象とする基本動作
#
# PROCESS
# 長音処理のパターンを対象とする正規化結果(正規化表記出力)と、正解ファ
# イルとを比較する。
# 
# EFFECT
# 正規化結果が正解ファイルと一致する。

# TARGET N
# 長音処理パターンを対象とする基本動作
#
# PROCESS
# 長音処理のパターンを対象とする正規化結果(前処理形式出力)から原表記を
# 抽出し、入力ファイルと比較する。
#
# EFFECT
# 抽出結果が入力ファイルと一致する。

# TARGET N
# 長音処理パターンを対象とする基本動作
#
# PROCESS
# 長音処理のパターンを対象とする正規化結果(前処理形式出力)から正規化表
# 記を抽出し、正規化結果(正規化表記出力)と比較する。
#
# EFFECT
# 抽出結果が正規化結果と一致する。

##### FILE = metahyphen #####

# TARGET N
# ハイフン処理パターンを対象とする基本動作
#
# PROCESS
# ハイフン処理のパターンを対象とする正規化結果(正規化表記出力)と、正解
# ファイルとを比較する。
# 
# EFFECT
# 正規化結果が正解ファイルと一致する。

# TARGET N
# ハイフン処理パターンを対象とする基本動作
#
# PROCESS
# ハイフン処理のパターンを対象とする正規化結果(前処理形式出力)から原表
# 記を抽出し、入力ファイルと比較する。
#
# EFFECT
# 抽出結果が入力ファイルと一致する。

# TARGET N
# ハイフン処理パターンを対象とする基本動作
#
# PROCESS
# ハイフン処理のパターンを対象とする正規化結果(前処理形式出力)から正規
# 化表記を抽出し、正規化結果(正規化表記出力)と比較する。
#
# EFFECT
# 抽出結果が正規化結果と一致する。

##### FILE = metanakaten #####

# TARGET N
# 中点処理パターンを対象とする基本動作
#
# PROCESS
# 中点処理のパターンを対象とする正規化結果(正規化表記出力)と、正解ファ
# イルとを比較する。
# 
# EFFECT
# 正規化結果が正解ファイルと一致する。

# TARGET N
# 中点処理パターンを対象とする基本動作
#
# PROCESS
# 中点処理のパターンを対象とする正規化結果(前処理形式出力)から原表記を
# 抽出し、入力ファイルと比較する。
#
# EFFECT
# 抽出結果が入力ファイルと一致する。

# TARGET N
# 中点処理パターンを対象とする基本動作
#
# PROCESS
# 中点処理のパターンを対象とする正規化結果(前処理形式出力)から正規化表
# 記を抽出し、正規化結果(正規化表記出力)と比較する。
#
# EFFECT
# 抽出結果が正規化結果と一致する。

##### FILE = combilatin #####

# TARGET N
# ラテン合字パターンを対象とする基本動作
#
# PROCESS
# ラテン合字パターンを対象とする正規化結果(正規化表記出力)
# と、正解ファイルとを比較する。
# 
# EFFECT
# 正規化結果が正解ファイルと一致する。

# TARGET N
# ラテン合字パターンを対象とする基本動作
#
# PROCESS
# ラテンの合字パターンを対象とする正規化結果(前処理形式出力)
# から原表記を抽出し、入力ファイルと比較する。
#
# EFFECT
# 抽出結果が入力ファイルと一致する。

# TARGET N
# ラテン合字パターンを対象とする基本動作
#
# PROCESS
# ラテンの合字パターンを対象とする正規化結果(前処理形式出力)
# 正規化表記を抽出し、正規化結果(正規化表記出力)と比較する。
#
# EFFECT
# 抽出結果が正規化結果と一致する。

##### FILE = combicyrillic #####

# TARGET N
# キリル合字パターンを対象とする基本動作
#
# PROCESS
# キリル合字パターンを対象とする正規化結果(正規化表記出力)
# と、正解ファイルとを比較する。
# 
# EFFECT
# 正規化結果が正解ファイルと一致する。

# TARGET N
# キリル合字パターンを対象とする基本動作
#
# PROCESS
# キリルの合字パターンを対象とする正規化結果(前処理形式出力)
# から原表記を抽出し、入力ファイルと比較する。
#
# EFFECT
# 抽出結果が入力ファイルと一致する。

# TARGET N
# キリル合字パターンを対象とする基本動作
#
# PROCESS
# キリルの合字パターンを対象とする正規化結果(前処理形式出力)
# 正規化表記を抽出し、正規化結果(正規化表記出力)と比較する。
#
# EFFECT
# 抽出結果が正規化結果と一致する。

##### FILE = combigreek #####

# TARGET N
# ギリシャ合字パターンを対象とする基本動作
#
# PROCESS
# ギリシャ合字パターンを対象とする正規化結果(正規化表記出力)
# と、正解ファイルとを比較する。
# 
# EFFECT
# 正規化結果が正解ファイルと一致する。

# TARGET N
# ギリシャ合字パターンを対象とする基本動作
#
# PROCESS
# ギリシャの合字パターンを対象とする正規化結果(前処理形式出力)
# から原表記を抽出し、入力ファイルと比較する。
#
# EFFECT
# 抽出結果が入力ファイルと一致する。

# TARGET N
# ギリシャ合字パターンを対象とする基本動作
#
# PROCESS
# ギリシャの合字パターンを対象とする正規化結果(前処理形式出力)
# 正規化表記を抽出し、正規化結果(正規化表記出力)と比較する。
#
# EFFECT
# 抽出結果が正規化結果と一致する。

prefix="./"
TEST=uniTest
DAT_DIR=../src/dat.norm/$TEST

FILES="alluni combimap combikana metachouon metahyphen metanakaten combilatin combicyrillic combigreek"

for FILE in $FILES
do
	DAT_FILE=$DAT_DIR/$FILE
	DIC_DIR=../unadic/norm
	ANS_NORM=../src/ans.norm/$TEST/$FILE.norm
	OUT_BOTH=norm_$TEST.$FILE.both
	OUT_NORM=norm_$TEST.$FILE.norm
	OUT_ORG=norm_$TEST.$FILE.org
	OUT_XTR=norm_$TEST.$FILE.xtr

	${prefix}norm -l -r $DIC_DIR -i $DAT_FILE -o $OUT_BOTH -a b -c utf8;
	${prefix}norm -l -r $DIC_DIR -i $OUT_BOTH -o $OUT_ORG  -a O -c utf8;
	${prefix}norm -l -r $DIC_DIR -i $OUT_BOTH -o $OUT_XTR  -a X -c utf8;
	${prefix}norm -l -r $DIC_DIR -i $DAT_FILE -o $OUT_NORM -a n -c utf8;

	# 原表記抽出結果と入力ファイルを比較
	cmp -s $DAT_FILE $OUT_ORG && rm $OUT_ORG || \
	(echo "extorg FAILED: norm_"$TEST; ls -l $DAT_FILE $OUT_ORG; echo);

	# 正規化表記抽出結果と正規化結果を比較
	# 展開結果と正解を比較
	cmp -s $OUT_NORM $OUT_XTR && rm $OUT_XTR || \
	(echo "extract FAILED: norm_"$TEST; ls -l $OUT_NORM $OUT_XTR; echo);

	# 展開結果と正解を比較
	cmp -s $ANS_NORM $OUT_NORM && \
	(test -f $OUT_XTR || rm $OUT_NORM) || \
	(echo "norm FAILED: norm_"$TEST; ls -l $ANS_NORM $OUT_NORM; echo);

	test -f $OUT_ORG || test -f $OUT_XTR || rm $OUT_BOTH;
done
