/* 
 * ambDatCode.c --- 内部コード変換処理データ
 *
 * Copyright (c) 1993, 2023 Ricoh Company, Ltd.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*               入力コード  →  内部コード変換                              */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
typedef struct _ambCnvTbl {
        unsigned long           code;
        unsigned long           kind;
}ambCnvTbl;

/*---------------------------------------------*/
/*  ＡＳＣＩＩコード→ 内部コード変換テーブル  */
/*---------------------------------------------*/
ambCnvTbl  AsciiToNormTbl[0x80] = {
/* (00)    "",  */  {  0x0000,   0L                 },
/* (01)    "",  */  {  0x0000,   0L                 },
/* (02)    "",  */  {  0x0000,   0L                 },
/* (03)    "",  */  {  0x0000,   0L                 },
/* (04)    "",  */  {  0x0000,   0L                 },
/* (05)    "",  */  {  0x0000,   0L                 },
/* (06)    "",  */  {  0x0000,   0L                 },
/* (07)    "",  */  {  0x0000,   0L                 },
/* (08)    "",  */  {  0x0000,   0L                 },
/* (09)    "",  */  {  0x0000,   0L                 },
/* (0A)    "",  */  {  0x0000,   0L                 },
/* (0B)    "",  */  {  0x0000,   0L                 },
/* (0C)    "",  */  {  0x0000,   0L                 },
/* (0D)    "",  */  {  0x0000,   0L                 },
/* (0E)    "",  */  {  0x0000,   0L                 },
/* (0F)    "",  */  {  0x0000,   0L                 },
/* (10)    "",  */  {  0x0000,   0L                 },
/* (11)    "",  */  {  0x0000,   0L                 },
/* (12)    "",  */  {  0x0000,   0L                 },
/* (13)    "",  */  {  0x0000,   0L                 },
/* (14)    "",  */  {  0x0000,   0L                 },
/* (15)    "",  */  {  0x0000,   0L                 },
/* (16)    "",  */  {  0x0000,   0L                 },
/* (17)    "",  */  {  0x0000,   0L                 },
/* (18)    "",  */  {  0x0000,   0L                 },
/* (19)    "",  */  {  0x0000,   0L                 },
/* (1A)    "",  */  {  0x0000,   0L                 },
/* (1B)    "",  */  {  0x0000,   0L                 },
/* (1C)    "",  */  {  0x0000,   0L                 },
/* (1D)    "",  */  {  0x0000,   0L                 },
/* (1E)    "",  */  {  0x0000,   0L                 },
/* (1F)    "",  */  {  0x0000,   0L                 },
/* (20)    "　" */  {  0xa1a1,   AMB_NORM_FLG_MARK   },
/* (21) !  "！" */  {  0xa1aa,   AMB_NORM_FLG_MARK   },
/* (22) "  "”" */  {  0xa1c9,   AMB_NORM_FLG_MARK   },
/* (23) #  "＃" */  {  0xa1f4,   AMB_NORM_FLG_MARK   },
/* (24) $  "＄" */  {  0xa1f0,   AMB_NORM_FLG_MARK   },
/* (25) %  "％" */  {  0xa1f3,   AMB_NORM_FLG_MARK   },
/* (26) &  "＆" */  {  0xa1f5,   AMB_NORM_FLG_MARK   },
/* (27) '  "’" */  {  0xa1c7,   AMB_NORM_FLG_MARK   },
/* (28) (  "（" */  {  0xa1ca,   AMB_NORM_FLG_MARK   },
/* (29) )  "）" */  {  0xa1cb,   AMB_NORM_FLG_MARK   },
/* (2A) *  "＊" */  {  0xa1f6,   AMB_NORM_FLG_MARK   },
/* (2B) +  "＋" */  {  0xa1dc,   AMB_NORM_FLG_MARK   },
/* (2C) ,  "，" */  {  0xa1a4,   AMB_NORM_FLG_MARK   },
/* (2D) -  "−" */  {  0xa1dd,   AMB_NORM_FLG_MARK   },
/* (2E) .  "．" */  {  0xa1a5,   AMB_NORM_FLG_MARK   },
/* (2F) /  "／" */  {  0xa1bf,   AMB_NORM_FLG_MARK   },
/* (30) 0  "０" */  {  0xa3b0,   AMB_NORM_FLG_SUJI   },
/* (31) 1  "１" */  {  0xa3b1,   AMB_NORM_FLG_SUJI   },
/* (32) 2  "２" */  {  0xa3b2,   AMB_NORM_FLG_SUJI   },
/* (33) 3  "３" */  {  0xa3b3,   AMB_NORM_FLG_SUJI   },
/* (34) 4  "４" */  {  0xa3b4,   AMB_NORM_FLG_SUJI   },
/* (35) 5  "５" */  {  0xa3b5,   AMB_NORM_FLG_SUJI   },
/* (36) 6  "６" */  {  0xa3b6,   AMB_NORM_FLG_SUJI   },
/* (37) 7  "７" */  {  0xa3b7,   AMB_NORM_FLG_SUJI   },
/* (38) 8  "８" */  {  0xa3b8,   AMB_NORM_FLG_SUJI   },
/* (39) 9  "９" */  {  0xa3b9,   AMB_NORM_FLG_SUJI   },
/* (3A) :  "：" */  {  0xa1a7,   AMB_NORM_FLG_MARK   },
/* (3B) ;  "；" */  {  0xa1a8,   AMB_NORM_FLG_MARK   },
/* (3C) <  "＜" */  {  0xa1e3,   AMB_NORM_FLG_MARK   },
/* (3D) =  "＝" */  {  0xa1e1,   AMB_NORM_FLG_MARK   },
/* (3E) >  "＞" */  {  0xa1e4,   AMB_NORM_FLG_MARK   },
/* (3F) ?  "？" */  {  0xa1a9,   AMB_NORM_FLG_MARK   },
/* (40) @  "＠" */  {  0xa1f7,   AMB_NORM_FLG_MARK   },
/* (41) A, "Ａ" */  {  0xa3c1,   AMB_NORM_FLG_ALPHA1 },
/* (42) B, "Ｂ" */  {  0xa3c2,   AMB_NORM_FLG_ALPHA1 },
/* (43) C, "Ｃ" */  {  0xa3c3,   AMB_NORM_FLG_ALPHA1 },
/* (44) D, "Ｄ" */  {  0xa3c4,   AMB_NORM_FLG_ALPHA1 },
/* (45) E, "Ｅ" */  {  0xa3c5,   AMB_NORM_FLG_ALPHA1 },
/* (46) F, "Ｆ" */  {  0xa3c6,   AMB_NORM_FLG_ALPHA1 },
/* (47) G, "Ｇ" */  {  0xa3c7,   AMB_NORM_FLG_ALPHA1 },
/* (48) H, "Ｈ" */  {  0xa3c8,   AMB_NORM_FLG_ALPHA1 },
/* (49) I, "Ｉ" */  {  0xa3c9,   AMB_NORM_FLG_ALPHA1 },
/* (4A) J, "Ｊ" */  {  0xa3ca,   AMB_NORM_FLG_ALPHA1 },
/* (4B) K, "Ｋ" */  {  0xa3cb,   AMB_NORM_FLG_ALPHA1 },
/* (4C) L, "Ｌ" */  {  0xa3cc,   AMB_NORM_FLG_ALPHA1 },
/* (4D) M, "Ｍ" */  {  0xa3cd,   AMB_NORM_FLG_ALPHA1 },
/* (4E) N, "Ｎ" */  {  0xa3ce,   AMB_NORM_FLG_ALPHA1 },
/* (4F) O, "Ｏ" */  {  0xa3cf,   AMB_NORM_FLG_ALPHA1 },
/* (50) P, "Ｐ" */  {  0xa3d0,   AMB_NORM_FLG_ALPHA1 },
/* (51) Q, "Ｑ" */  {  0xa3d1,   AMB_NORM_FLG_ALPHA1 },
/* (52) R, "Ｒ" */  {  0xa3d2,   AMB_NORM_FLG_ALPHA1 },
/* (53) S, "Ｓ" */  {  0xa3d3,   AMB_NORM_FLG_ALPHA1 },
/* (54) T, "Ｔ" */  {  0xa3d4,   AMB_NORM_FLG_ALPHA1 },
/* (55) U, "Ｕ" */  {  0xa3d5,   AMB_NORM_FLG_ALPHA1 },
/* (56) V, "Ｖ" */  {  0xa3d6,   AMB_NORM_FLG_ALPHA1 },
/* (57) W, "Ｗ" */  {  0xa3d7,   AMB_NORM_FLG_ALPHA1 },
/* (58) X, "Ｘ" */  {  0xa3d8,   AMB_NORM_FLG_ALPHA1 },
/* (59) Y, "Ｙ" */  {  0xa3d9,   AMB_NORM_FLG_ALPHA1 },
/* (5A) Z, "Ｚ" */  {  0xa3da,   AMB_NORM_FLG_ALPHA1 },
/* (5B) [  "［" */  {  0xa1ce,   AMB_NORM_FLG_MARK   },
/* (5C) \  "¥" */  {  0xa1ef,   AMB_NORM_FLG_MARK   },
/* (5D) ]  "］" */  {  0xa1cf,   AMB_NORM_FLG_MARK   },
/* (5E) ^  "＾" */  {  0xa1b0,   AMB_NORM_FLG_MARK   },
/* (5F) _  "＿" */  {  0xa1b2,   AMB_NORM_FLG_MARK   },
/* (60) `  "｀" */  {  0xa1ae,   AMB_NORM_FLG_MARK   },
/* (61) a, "Ａ" */  {  0xa3c1,   AMB_NORM_FLG_ALPHA1 },
/* (62) b, "Ｂ" */  {  0xa3c2,   AMB_NORM_FLG_ALPHA1 },
/* (63) c, "Ｃ" */  {  0xa3c3,   AMB_NORM_FLG_ALPHA1 },
/* (64) d, "Ｄ" */  {  0xa3c4,   AMB_NORM_FLG_ALPHA1 },
/* (65) e, "Ｅ" */  {  0xa3c5,   AMB_NORM_FLG_ALPHA1 },
/* (66) f, "Ｆ" */  {  0xa3c6,   AMB_NORM_FLG_ALPHA1 },
/* (67) g, "Ｇ" */  {  0xa3c7,   AMB_NORM_FLG_ALPHA1 },
/* (68) h, "Ｈ" */  {  0xa3c8,   AMB_NORM_FLG_ALPHA1 },
/* (69) i, "Ｉ" */  {  0xa3c9,   AMB_NORM_FLG_ALPHA1 },
/* (6A) j, "Ｊ" */  {  0xa3ca,   AMB_NORM_FLG_ALPHA1 },
/* (6B) k, "Ｋ" */  {  0xa3cb,   AMB_NORM_FLG_ALPHA1 },
/* (6C) l, "Ｌ" */  {  0xa3cc,   AMB_NORM_FLG_ALPHA1 },
/* (6D) m, "Ｍ" */  {  0xa3cd,   AMB_NORM_FLG_ALPHA1 },
/* (6E) n, "Ｎ" */  {  0xa3ce,   AMB_NORM_FLG_ALPHA1 },
/* (6F) o, "Ｏ" */  {  0xa3cf,   AMB_NORM_FLG_ALPHA1 },
/* (70) p, "Ｐ" */  {  0xa3d0,   AMB_NORM_FLG_ALPHA1 },
/* (71) q, "Ｑ" */  {  0xa3d1,   AMB_NORM_FLG_ALPHA1 },
/* (72) r, "Ｒ" */  {  0xa3d2,   AMB_NORM_FLG_ALPHA1 },
/* (73) s, "Ｓ" */  {  0xa3d3,   AMB_NORM_FLG_ALPHA1 },
/* (74) t, "Ｔ" */  {  0xa3d4,   AMB_NORM_FLG_ALPHA1 },
/* (75) u, "Ｕ" */  {  0xa3d5,   AMB_NORM_FLG_ALPHA1 },
/* (76) v, "Ｖ" */  {  0xa3d6,   AMB_NORM_FLG_ALPHA1 },
/* (77) w, "Ｗ" */  {  0xa3d7,   AMB_NORM_FLG_ALPHA1 },
/* (78) x, "Ｘ" */  {  0xa3d8,   AMB_NORM_FLG_ALPHA1 },
/* (79) y, "Ｙ" */  {  0xa3d9,   AMB_NORM_FLG_ALPHA1 },
/* (7A) z, "Ｚ" */  {  0xa3da,   AMB_NORM_FLG_ALPHA1 },
/* (7B) {  "｛" */  {  0xa1d0,   AMB_NORM_FLG_MARK   },
/* (7C) |  "｜" */  {  0xa1c3,   AMB_NORM_FLG_MARK   },
/* (7D) }  "｝" */  {  0xa1d1,   AMB_NORM_FLG_MARK   },
/* (7E) ~  "‾" */  {  0xa1b1,   AMB_NORM_FLG_MARK   },
/* (7F)    "",  */  {  0x0000,   0L                 } 
};


/*---------------------------------------*/
/*  JIS-X0201 → 内部コード変換テーブル  */
/*---------------------------------------*/
ambCnvTbl J201ToNormTbl[0x40] = {
/* (A0)   "",  */  { 0x0000,   0L               },
/* (A1) 。  "。" */  { 0xa1a3,   AMB_NORM_FLG_MARK },
/* (A2) 「  "「" */  { 0xa1d6,   AMB_NORM_FLG_MARK },
/* (A3) 」  "」" */  { 0xa1d7,   AMB_NORM_FLG_MARK },
/* (A4) 、  "、" */  { 0xa1a2,   AMB_NORM_FLG_MARK },
/* (A5) ・  "・" */  { 0xa1a6,   AMB_NORM_FLG_MARK },
/* (A6) ヲ  "ヲ" */  { 0xa5f2,   AMB_NORM_FLG_KATA },
/* (A7) ァ  "ァ" */  { 0xa5a1,   AMB_NORM_FLG_KATA },
/* (A8) ィ  "ィ" */  { 0xa5a3,   AMB_NORM_FLG_KATA },
/* (A9) ゥ  "ゥ" */  { 0xa5a5,   AMB_NORM_FLG_KATA },
/* (AA) ェ  "ェ" */  { 0xa5a7,   AMB_NORM_FLG_KATA },
/* (AB) ォ  "ォ" */  { 0xa5a9,   AMB_NORM_FLG_KATA },
/* (AC) ャ  "ャ" */  { 0xa5e3,   AMB_NORM_FLG_KATA },
/* (AD) ュ  "ュ" */  { 0xa5e5,   AMB_NORM_FLG_KATA },
/* (AE) ョ  "ョ" */  { 0xa5e7,   AMB_NORM_FLG_KATA },
/* (AF) ッ  "ッ" */  { 0xa5c3,   AMB_NORM_FLG_KATA },
/* (B0) ー  "ー" */  { 0xa1bc,   AMB_NORM_FLG_MARK },
/* (B1) ア  "ア" */  { 0xa5a2,   AMB_NORM_FLG_KATA },
/* (B2) イ  "イ" */  { 0xa5a4,   AMB_NORM_FLG_KATA },
/* (B3) ウ  "ウ" */  { 0xa5a6,   AMB_NORM_FLG_KATA },
/* (B4) エ  "エ" */  { 0xa5a8,   AMB_NORM_FLG_KATA },
/* (B5) オ  "オ" */  { 0xa5aa,   AMB_NORM_FLG_KATA },
/* (B6) カ  "カ" */  { 0xa5ab,   AMB_NORM_FLG_KATA },
/* (B7) キ  "キ" */  { 0xa5ad,   AMB_NORM_FLG_KATA },
/* (B8) ク  "ク" */  { 0xa5af,   AMB_NORM_FLG_KATA },
/* (B9) ケ  "ケ" */  { 0xa5b1,   AMB_NORM_FLG_KATA },
/* (BA) コ  "コ" */  { 0xa5b3,   AMB_NORM_FLG_KATA },
/* (BB) サ  "サ" */  { 0xa5b5,   AMB_NORM_FLG_KATA },
/* (BC) シ  "シ" */  { 0xa5b7,   AMB_NORM_FLG_KATA },
/* (BD) ス  "ス" */  { 0xa5b9,   AMB_NORM_FLG_KATA },
/* (BE) セ  "セ" */  { 0xa5bb,   AMB_NORM_FLG_KATA },
/* (BF) ソ  "ソ" */  { 0xa5bd,   AMB_NORM_FLG_KATA },
/* (C0) タ  "タ" */  { 0xa5bf,   AMB_NORM_FLG_KATA },
/* (C1) チ  "チ" */  { 0xa5c1,   AMB_NORM_FLG_KATA },
/* (C2) ツ  "ツ" */  { 0xa5c4,   AMB_NORM_FLG_KATA },
/* (C3) テ  "テ" */  { 0xa5c6,   AMB_NORM_FLG_KATA },
/* (C4) ト  "ト" */  { 0xa5c8,   AMB_NORM_FLG_KATA },
/* (C5) ナ  "ナ" */  { 0xa5ca,   AMB_NORM_FLG_KATA },
/* (C6) ニ  "ニ" */  { 0xa5cb,   AMB_NORM_FLG_KATA },
/* (C7) ヌ  "ヌ" */  { 0xa5cc,   AMB_NORM_FLG_KATA },
/* (C8) ネ  "ネ" */  { 0xa5cd,   AMB_NORM_FLG_KATA },
/* (C9) ノ  "ノ" */  { 0xa5ce,   AMB_NORM_FLG_KATA },
/* (CA) ハ  "ハ" */  { 0xa5cf,   AMB_NORM_FLG_KATA },
/* (CB) ヒ  "ヒ" */  { 0xa5d2,   AMB_NORM_FLG_KATA },
/* (CC) フ  "フ" */  { 0xa5d5,   AMB_NORM_FLG_KATA },
/* (CD) ヘ  "ヘ" */  { 0xa5d8,   AMB_NORM_FLG_KATA },
/* (CE) ホ  "ホ" */  { 0xa5db,   AMB_NORM_FLG_KATA },
/* (CF) マ  "マ" */  { 0xa5de,   AMB_NORM_FLG_KATA },
/* (D0) ミ  "ミ" */  { 0xa5df,   AMB_NORM_FLG_KATA },
/* (D1) ム  "ム" */  { 0xa5e0,   AMB_NORM_FLG_KATA },
/* (D2) メ  "メ" */  { 0xa5e1,   AMB_NORM_FLG_KATA },
/* (D3) モ  "モ" */  { 0xa5e2,   AMB_NORM_FLG_KATA },
/* (D4) ヤ  "ヤ" */  { 0xa5e4,   AMB_NORM_FLG_KATA },
/* (D5) ユ  "ユ" */  { 0xa5e6,   AMB_NORM_FLG_KATA },
/* (D6) ヨ  "ヨ" */  { 0xa5e8,   AMB_NORM_FLG_KATA },
/* (D7) ラ  "ラ" */  { 0xa5e9,   AMB_NORM_FLG_KATA },
/* (D8) リ  "リ" */  { 0xa5ea,   AMB_NORM_FLG_KATA },
/* (D9) ル  "ル" */  { 0xa5eb,   AMB_NORM_FLG_KATA },
/* (DA) レ  "レ" */  { 0xa5ec,   AMB_NORM_FLG_KATA },
/* (DB) ロ  "ロ" */  { 0xa5ed,   AMB_NORM_FLG_KATA },
/* (DC) ワ  "ワ" */  { 0xa5ef,   AMB_NORM_FLG_KATA },
/* (DD) ン  "ン" */  { 0xa5f3,   AMB_NORM_FLG_KATA },
/* (DE) ゛  "゛" */  { 0xa1ab,   AMB_NORM_FLG_MARK },
/* (DF) ゜  "゜" */  { 0xa1ac,   AMB_NORM_FLG_MARK },
};


/*-----------------------------------------------*/
/*  JIS-X0208半角英数 → 内部コード変換テーブル  */
/*-----------------------------------------------*/
ambCnvTbl J208HEToNormTbl[0x5F] = {
/* (A9-A0)    "　"*/  { 0xa1a1 ,   AMB_NORM_FLG_MARK   },
/* (A9-A1) ① "！" */  { 0xa1aa ,   AMB_NORM_FLG_MARK   },
/* (A9-A2) ② "”" */  { 0xa1c9 ,   AMB_NORM_FLG_MARK   },
/* (A9-A3) ③ "＃" */  { 0xa1f4 ,   AMB_NORM_FLG_MARK   },
/* (A9-A4) ④ "＄" */  { 0xa1f0 ,   AMB_NORM_FLG_MARK   },
/* (A9-A5) ⑤ "％" */  { 0xa1f3 ,   AMB_NORM_FLG_MARK   },
/* (A9-A6) ⑥ "＆" */  { 0xa1f5 ,   AMB_NORM_FLG_MARK   },
/* (A9-A7) ⑦ "’" */  { 0xa1c7 ,   AMB_NORM_FLG_MARK   },
/* (A9-A8) ⑧ "（" */  { 0xa1ca ,   AMB_NORM_FLG_MARK   },
/* (A9-A9) ⑨ "）" */  { 0xa1cb ,   AMB_NORM_FLG_MARK   },
/* (A9-AA) ⑩ "＊" */  { 0xa1f6 ,   AMB_NORM_FLG_MARK   },
/* (A9-AB) ⑪ "＋" */  { 0xa1dc ,   AMB_NORM_FLG_MARK   },
/* (A9-AC) ⑫ "，" */  { 0xa1a4 ,   AMB_NORM_FLG_MARK   },
/* (A9-AD) ⑬ "−" */  { 0xa1dd ,   AMB_NORM_FLG_MARK   },
/* (A9-AE) ⑭ "．" */  { 0xa1a5 ,   AMB_NORM_FLG_MARK   },
/* (A9-AF) ⑮ "／" */  { 0xa1bf ,   AMB_NORM_FLG_MARK   },
/* (A9-B0) ⑯ "０" */  { 0xa3b0 ,   AMB_NORM_FLG_SUJI   },
/* (A9-B1) ⑰ "１" */  { 0xa3b1 ,   AMB_NORM_FLG_SUJI   },
/* (A9-B2) ⑱ "２" */  { 0xa3b2 ,   AMB_NORM_FLG_SUJI   },
/* (A9-B3) ⑲ "３" */  { 0xa3b3 ,   AMB_NORM_FLG_SUJI   },
/* (A9-B4) ⑳ "４" */  { 0xa3b4 ,   AMB_NORM_FLG_SUJI   },
/* (A9-B5)  "５" */  { 0xa3b5 ,   AMB_NORM_FLG_SUJI   },
/* (A9-B6)  "６" */  { 0xa3b6 ,   AMB_NORM_FLG_SUJI   },
/* (A9-B7)  "７" */  { 0xa3b7 ,   AMB_NORM_FLG_SUJI   },
/* (A9-B8)  "８" */  { 0xa3b8 ,   AMB_NORM_FLG_SUJI   },
/* (A9-B9)  "９" */  { 0xa3b9 ,   AMB_NORM_FLG_SUJI   },
/* (A9-BA)  "：" */  { 0xa1a7 ,   AMB_NORM_FLG_MARK   },
/* (A9-BB)  "；" */  { 0xa1a8 ,   AMB_NORM_FLG_MARK   },
/* (A9-BC)  "＜" */  { 0xa1e3 ,   AMB_NORM_FLG_MARK   },
/* (A9-BD)  "＝" */  { 0xa1e1 ,   AMB_NORM_FLG_MARK   },
/* (A9-BE)  "＞" */  { 0xa1e4 ,   AMB_NORM_FLG_MARK   },
/* (A9-BF) ⑴ "？" */  { 0xa1a9 ,   AMB_NORM_FLG_MARK   },
/* (A9-C0) ⑵ "＠" */  { 0xa1f7 ,   AMB_NORM_FLG_MARK   },
/* (A9-C1) ⑶ "Ａ" */  { 0xa3c1 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-C2) ⑷ "Ｂ" */  { 0xa3c2 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-C3) ⑸ "Ｃ" */  { 0xa3c3 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-C4) ⑹ "Ｄ" */  { 0xa3c4 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-C5) ⑺ "Ｅ" */  { 0xa3c5 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-C6) ⑻ "Ｆ" */  { 0xa3c6 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-C7) ⑼ "Ｇ" */  { 0xa3c7 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-C8) ⑽ "Ｈ" */  { 0xa3c8 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-C9) ⑾ "Ｉ" */  { 0xa3c9 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-CA) ⑿ "Ｊ" */  { 0xa3ca ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-CB) ⒀ "Ｋ" */  { 0xa3cb ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-CC) ⒁ "Ｌ" */  { 0xa3cc ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-CD) ⒂ "Ｍ" */  { 0xa3cd ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-CE) ⒃ "Ｎ" */  { 0xa3ce ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-CF) ⒄ "Ｏ" */  { 0xa3cf ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-D0) ⒅ "Ｐ" */  { 0xa3d0 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-D1) ⒆ "Ｑ" */  { 0xa3d1 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-D2) ⒇ "Ｒ" */  { 0xa3d2 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-D3)  "Ｓ" */  { 0xa3d3 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-D4)  "Ｔ" */  { 0xa3d4 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-D5)  "Ｕ" */  { 0xa3d5 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-D6)  "Ｖ" */  { 0xa3d6 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-D7)  "Ｗ" */  { 0xa3d7 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-D8)  "Ｘ" */  { 0xa3d8 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-D9)  "Ｙ" */  { 0xa3d9 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-DA)  "Ｚ" */  { 0xa3da ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-DB)  "［" */  { 0xa1ce ,   AMB_NORM_FLG_MARK   },
/* (A9-DC)  "¥" */  { 0xa1ef ,   AMB_NORM_FLG_MARK   },
/* (A9-DD) ❶ "］" */  { 0xa1cf ,   AMB_NORM_FLG_MARK   },
/* (A9-DE) ❷ "＾" */  { 0xa1b0 ,   AMB_NORM_FLG_MARK   },
/* (A9-DF) ❸ "＿" */  { 0xa1b2 ,   AMB_NORM_FLG_MARK   },
/* (A9-E0) ❹ "｀" */  { 0xa1ae ,   AMB_NORM_FLG_MARK   },
/* (A9-E1) ❺ "Ａ" */  { 0xa3c1 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-E2) ❻ "Ｂ" */  { 0xa3c2 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-E3) ❼ "Ｃ" */  { 0xa3c3 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-E4) ❽ "Ｄ" */  { 0xa3c4 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-E5) ❾ "Ｅ" */  { 0xa3c5 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-E6)  "Ｆ" */  { 0xa3c6 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-E7)  "Ｇ" */  { 0xa3c7 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-E8)  "Ｈ" */  { 0xa3c8 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-E9)  "Ｉ" */  { 0xa3c9 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-EA)  "Ｊ" */  { 0xa3ca ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-EB)  "Ｋ" */  { 0xa3cb ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-EC)  "Ｌ" */  { 0xa3cc ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-ED)  "Ｍ" */  { 0xa3cd ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-EE)  "Ｎ" */  { 0xa3ce ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-EF)  "Ｏ" */  { 0xa3cf ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-F0)  "Ｐ" */  { 0xa3d0 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-F1)  "Ｑ" */  { 0xa3d1 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-F2) ⒈ "Ｒ" */  { 0xa3d2 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-F3) ⒉ "Ｓ" */  { 0xa3d3 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-F4) ⒊ "Ｔ" */  { 0xa3d4 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-F5) ⒋ "Ｕ" */  { 0xa3d5 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-F6) ⒌ "Ｖ" */  { 0xa3d6 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-F7) ⒍ "Ｗ" */  { 0xa3d7 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-F8) ⒎ "Ｘ" */  { 0xa3d8 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-F9) ⒏ "Ｙ" */  { 0xa3d9 ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-FA) ⒐ "Ｚ" */  { 0xa3da ,   AMB_NORM_FLG_ALPHA1 },
/* (A9-FB)  "｛" */  { 0xa1d0 ,   AMB_NORM_FLG_MARK   },
/* (A9-FC)  "｜" */  { 0xa1c3 ,   AMB_NORM_FLG_MARK   },
/* (A9-FD)  "｝" */  { 0xa1d1 ,   AMB_NORM_FLG_MARK   },
/* (A9-FE)  "‾" */  { 0xa1b1 ,   AMB_NORM_FLG_MARK   },
};


/*---------------------------------------------------*/
/*  JIS-X0208半角カタカナ → 内部コード変換テーブル  */
/*---------------------------------------------------*/
ambCnvTbl J208HKToNormTbl[0x5F] = {
/* (AA-A0)   ""   */  { 0x0000,  0L               },
/* (AA-A1) Ⅰ "。" */  { 0xa1a3,  AMB_NORM_FLG_MARK },
/* (AA-A2) Ⅱ "「" */  { 0xa1d6,  AMB_NORM_FLG_MARK },
/* (AA-A3) Ⅲ "」" */  { 0xa1d7,  AMB_NORM_FLG_MARK },
/* (AA-A4) Ⅳ "、" */  { 0xa1a2,  AMB_NORM_FLG_MARK },
/* (AA-A5) Ⅴ "・" */  { 0xa1a6,  AMB_NORM_FLG_MARK },
/* (AA-A6) Ⅵ "ヲ" */  { 0xa5f2,  AMB_NORM_FLG_KATA },
/* (AA-A7) Ⅶ "ァ" */  { 0xa5a1,  AMB_NORM_FLG_KATA },
/* (AA-A8) Ⅷ "ィ" */  { 0xa5a3,  AMB_NORM_FLG_KATA },
/* (AA-A9) Ⅸ "ゥ" */  { 0xa5a5,  AMB_NORM_FLG_KATA },
/* (AA-AA) Ⅹ "ェ" */  { 0xa5a7,  AMB_NORM_FLG_KATA },
/* (AA-AB) Ⅺ "ォ" */  { 0xa5a9,  AMB_NORM_FLG_KATA },
/* (AA-AC) Ⅻ "ャ" */  { 0xa5e3,  AMB_NORM_FLG_KATA },
/* (AA-AD)  "ュ" */  { 0xa5e5,  AMB_NORM_FLG_KATA },
/* (AA-AE)  "ョ" */  { 0xa5e7,  AMB_NORM_FLG_KATA },
/* (AA-AF)  "ッ" */  { 0xa5c3,  AMB_NORM_FLG_KATA },
/* (AA-B0)  "ー" */  { 0xa1bc,  AMB_NORM_FLG_MARK },
/* (AA-B1)  "ア" */  { 0xa5a2,  AMB_NORM_FLG_KATA },
/* (AA-B2)  "イ" */  { 0xa5a4,  AMB_NORM_FLG_KATA },
/* (AA-B3)  "ウ" */  { 0xa5a6,  AMB_NORM_FLG_KATA },
/* (AA-B4)  "エ" */  { 0xa5a8,  AMB_NORM_FLG_KATA },
/* (AA-B5) ⅰ "オ" */  { 0xa5aa,  AMB_NORM_FLG_KATA },
/* (AA-B6) ⅱ "カ" */  { 0xa5ab,  AMB_NORM_FLG_KATA },
/* (AA-B7) ⅲ "キ" */  { 0xa5ad,  AMB_NORM_FLG_KATA },
/* (AA-B8) ⅳ "ク" */  { 0xa5af,  AMB_NORM_FLG_KATA },
/* (AA-B9) ⅴ "ケ" */  { 0xa5b1,  AMB_NORM_FLG_KATA },
/* (AA-BA) ⅵ "コ" */  { 0xa5b3,  AMB_NORM_FLG_KATA },
/* (AA-BB) ⅶ "サ" */  { 0xa5b5,  AMB_NORM_FLG_KATA },
/* (AA-BC) ⅷ "シ" */  { 0xa5b7,  AMB_NORM_FLG_KATA },
/* (AA-BD) ⅸ "ス" */  { 0xa5b9,  AMB_NORM_FLG_KATA },
/* (AA-BE) ⅹ "セ" */  { 0xa5bb,  AMB_NORM_FLG_KATA },
/* (AA-BF) ⅺ "ソ" */  { 0xa5bd,  AMB_NORM_FLG_KATA },
/* (AA-C0) ⅻ "タ" */  { 0xa5bf,  AMB_NORM_FLG_KATA },
/* (AA-C1)  "チ" */  { 0xa5c1,  AMB_NORM_FLG_KATA },
/* (AA-C2)  "ツ" */  { 0xa5c4,  AMB_NORM_FLG_KATA },
/* (AA-C3)  "テ" */  { 0xa5c6,  AMB_NORM_FLG_KATA },
/* (AA-C4)  "ト" */  { 0xa5c8,  AMB_NORM_FLG_KATA },
/* (AA-C5)  "ナ" */  { 0xa5ca,  AMB_NORM_FLG_KATA },
/* (AA-C6)  "ニ" */  { 0xa5cb,  AMB_NORM_FLG_KATA },
/* (AA-C7)  "ヌ" */  { 0xa5cc,  AMB_NORM_FLG_KATA },
/* (AA-C8)  "ネ" */  { 0xa5cd,  AMB_NORM_FLG_KATA },
/* (AA-C9)  "ノ" */  { 0xa5ce,  AMB_NORM_FLG_KATA },
/* (AA-CA)  "ハ" */  { 0xa5cf,  AMB_NORM_FLG_KATA },
/* (AA-CB)  "ヒ" */  { 0xa5d2,  AMB_NORM_FLG_KATA },
/* (AA-CC)  "フ" */  { 0xa5d5,  AMB_NORM_FLG_KATA },
/* (AA-CD)  "ヘ" */  { 0xa5d8,  AMB_NORM_FLG_KATA },
/* (AA-CE)  "ホ" */  { 0xa5db,  AMB_NORM_FLG_KATA },
/* (AA-CF)  "マ" */  { 0xa5de,  AMB_NORM_FLG_KATA },
/* (AA-D0)  "ミ" */  { 0xa5df,  AMB_NORM_FLG_KATA },
/* (AA-D1)  "ム" */  { 0xa5e0,  AMB_NORM_FLG_KATA },
/* (AA-D2)  "メ" */  { 0xa5e1,  AMB_NORM_FLG_KATA },
/* (AA-D3)  "モ" */  { 0xa5e2,  AMB_NORM_FLG_KATA },
/* (AA-D4)  "ヤ" */  { 0xa5e4,  AMB_NORM_FLG_KATA },
/* (AA-D5)  "ユ" */  { 0xa5e6,  AMB_NORM_FLG_KATA },
/* (AA-D6)  "ヨ" */  { 0xa5e8,  AMB_NORM_FLG_KATA },
/* (AA-D7)  "ラ" */  { 0xa5e9,  AMB_NORM_FLG_KATA },
/* (AA-D8)  "リ" */  { 0xa5ea,  AMB_NORM_FLG_KATA },
/* (AA-D9)  "ル" */  { 0xa5eb,  AMB_NORM_FLG_KATA },
/* (AA-DA)  "レ" */  { 0xa5ec,  AMB_NORM_FLG_KATA },
/* (AA-DB)  "ロ" */  { 0xa5ed,  AMB_NORM_FLG_KATA },
/* (AA-DC)  "ワ" */  { 0xa5ef,  AMB_NORM_FLG_KATA },
/* (AA-DD) ⒜ "ン" */  { 0xa5f3,  AMB_NORM_FLG_KATA },
/* (AA-DE) ⒝ "゛" */  { 0xa1ab,  AMB_NORM_FLG_MARK },
/* (AA-DF) ⒞ "゜" */  { 0xa1ac,  AMB_NORM_FLG_MARK },
/* (AA-E0) ⒟ "ヰ" */  { 0xa5f0,  AMB_NORM_FLG_KATA },
/* (AA-E1) ⒠ "ヱ" */  { 0xa5f1,  AMB_NORM_FLG_KATA },
/* (AA-E2) ⒡ "ヮ" */  { 0xa5ee,  AMB_NORM_FLG_KATA },
/* (AA-E3) ⒢ "ヵ" */  { 0xa5f5,  AMB_NORM_FLG_KATA },
/* (AA-E4) ⒣ "ヶ" */  { 0xa5f6,  AMB_NORM_FLG_KATA },
/* (AA-E5) ⒤ "ヴ" */  { 0xa5f4,  AMB_NORM_FLG_KATA },
/* (AA-E6) ⒥ "ガ" */  { 0xa5ac,  AMB_NORM_FLG_KATA },
/* (AA-E7) ⒦ "ギ" */  { 0xa5ae,  AMB_NORM_FLG_KATA },
/* (AA-E8) ⒧ "グ" */  { 0xa5b0,  AMB_NORM_FLG_KATA },
/* (AA-E9) ⒨ "ゲ" */  { 0xa5b2,  AMB_NORM_FLG_KATA },
/* (AA-EA) ⒩ "ゴ" */  { 0xa5b4,  AMB_NORM_FLG_KATA },
/* (AA-EB) ⒪ "ザ" */  { 0xa5b6,  AMB_NORM_FLG_KATA },
/* (AA-EC) ⒫ "ジ" */  { 0xa5b8,  AMB_NORM_FLG_KATA },
/* (AA-ED) ⒬ "ズ" */  { 0xa5ba,  AMB_NORM_FLG_KATA },
/* (AA-EE) ⒭ "ゼ" */  { 0xa5bc,  AMB_NORM_FLG_KATA },
/* (AA-EF) ⒮ "ゾ" */  { 0xa5be,  AMB_NORM_FLG_KATA },
/* (AA-F0) ⒯ "ダ" */  { 0xa5c0,  AMB_NORM_FLG_KATA },
/* (AA-F1) ⒰ "ヂ" */  { 0xa5c2,  AMB_NORM_FLG_KATA },
/* (AA-F2) ⒱ "ヅ" */  { 0xa5c5,  AMB_NORM_FLG_KATA },
/* (AA-F3) ⒲ "デ" */  { 0xa5c7,  AMB_NORM_FLG_KATA },
/* (AA-F4) ⒳ "ド" */  { 0xa5c9,  AMB_NORM_FLG_KATA },
/* (AA-F5) ⒴ "バ" */  { 0xa5d0,  AMB_NORM_FLG_KATA },
/* (AA-F6) ⒵ "パ" */  { 0xa5d1,  AMB_NORM_FLG_KATA },
/* (AA-F7)  "ビ" */  { 0xa5d3,  AMB_NORM_FLG_KATA },
/* (AA-F8)  "ピ" */  { 0xa5d4,  AMB_NORM_FLG_KATA },
/* (AA-F9)  "ブ" */  { 0xa5d6,  AMB_NORM_FLG_KATA },
/* (AA-FA)  "プ" */  { 0xa5d7,  AMB_NORM_FLG_KATA },
/* (AA-FB)  "ベ" */  { 0xa5d9,  AMB_NORM_FLG_KATA },
/* (AA-FC)  "ぺ" */  { 0xa4da,  AMB_NORM_FLG_KATA },
/* (AA-FD)  "ボ" */  { 0xa5dc,  AMB_NORM_FLG_KATA },
/* (AA-FE)  "ポ" */  { 0xa5dd,  AMB_NORM_FLG_KATA }
};            


/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*               内部コード変換   →　入力コード変換                         */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
/*-------------------------------------------*/
/*   JIS-X0208（記号１）→ 半角変換テーブル  */
/*-------------------------------------------*/
unsigned char KigouToHankaku1[0x60][3] = {
/* (A1-A0)    */    ""  ,
/* (A1-A1) SP */    " ",
/* (A1-A2) 、 */    "、",
/* (A1-A3) 。 */    "。",
/* (A1-A4) ， */    ",",
/* (A1-A5) ． */    ".",
/* (A1-A5) ・ */    "・",
/* (A1-A7) ： */    ":",
/* (A1-A8) ； */    ";",
/* (A1-A9) ？ */    "?",
/* (A1-AA) ！ */    "!",
/* (A1-AB) ゛ */    "゛",
/* (A1-AC) ゜ */    "゜",
/* (A1-AD) ´ */    "´",
/* (A1-AE) ｀ */    "`",
/* (A1-AF) ¨ */    "¨",
/* (A1-B0) ＾ */    "^",
/* (A1-B1) ‾ */    "~",
/* (A1-B2) ＿ */    "_",
/* (A1-B3) ヽ */    "ヽ",
/* (A1-B4) ヾ */    "ヾ",
/* (A1-B5) ゝ */    "ゝ",
/* (A1-B6) ゞ */    "ゞ",
/* (A1-B7) 〃 */    "〃",
/* (A1-B8) 仝 */    "仝",
/* (A1-B9) 々 */    "々",
/* (A1-BA) 〆 */    "〆",
/* (A1-BB) 〇 */    "〇",
/* (A1-BC) ー */    "ー",
/* (A1-BD) — */    "—",
/* (A1-BE) ‐ */    "‐",
/* (A1-BF) ／ */    "/",
/* (A1-C0) ＼ */    "\\",
/* (A1-C1) 〜 */    "〜",
/* (A1-C2) ‖ */    "‖",
/* (A1-C3) ｜ */    "|",
/* (A1-C4) … */    "…",
/* (A1-C5) ‥ */    "‥",
/* (A1-C6) ‘ */    "‘",
/* (A1-C7) ’ */    "'",
/* (A1-C8)    */    "", 
/* (A1-C9) ” */    "\"",
/* (A1-CA) （ */    "(",
/* (A1-CB) ） */    ")",
/* (A1-CC) 〔 */    "〔",
/* (A1-CD) 〕 */    "〕",
/* (A1-CE) ［ */    "[",
/* (A1-CF) ］ */    "]",
/* (A1-D0) ｛ */    "{",
/* (A1-D1) ｝ */    "}",
/* (A1-D2) 〈 */    "〈",
/* (A1-D3) 〉 */    "〉",
/* (A1-D4) 《 */    "《",
/* (A1-D5) 》 */    "》",
/* (A1-D6) 「 */    "「",
/* (A1-D7) 」 */    "」",
/* (A1-D8) 『 */    "『",
/* (A1-D9) 』 */    "』",
/* (A1-DA) 【 */    "【",
/* (A1-DB) 】 */    "】",
/* (A1-DC) ＋ */    "+",
/* (A1-DD) − */    "-",
/* (A1-DE) ± */    "±",
/* (A1-DF) × */    "*", 
/* (A1-E0) ÷ */    "/", 
/* (A1-E1) ＝ */    "=",
/* (A1-E2) ≠ */    "≠",
/* (A1-E3) ＜ */    "<",
/* (A1-E4) ＞ */    ">",
/* (A1-E5) ≦ */    "≦",
/* (A1-E6) ≧ */    "≧",
/* (A1-E7) ∞ */    "∞",
/* (A1-E8) ∴ */    "∴",
/* (A1-E9) ♂ */    "♂",
/* (A1-EA) ♀ */    "♀",
/* (A1-EB) ° */    "°",
/* (A1-EC) ′ */    "′",
/* (A1-ED) ″ */    "″",
/* (A1-EE) ℃ */    "℃",
/* (A1-EF) ¥ */    "\\",
/* (A1-F0) ＄ */    "$",
/* (A1-F1) ¢ */    "¢",
/* (A1-F2) £ */    "£",
/* (A1-F3) ％ */    "%",
/* (A1-F4) ＃ */    "#",
/* (A1-F5) ＆ */    "&",
/* (A1-F6) ＊ */    "*",
/* (A1-F7) ＠ */    "@",
/* (A1-F8) § */    "§",
/* (A1-F9) ☆ */    "☆",
/* (A1-FA) ★ */    "★",
/* (A1-FB) ○ */    "○",
/* (A1-FC) ● */    "●",
/* (A1-FD) ◎ */    "◎",
/* (A1-FE) ◇ */    "◇",
/* (A1-FF)    */    "" 
};


/*-------------------------------------------*/
/*   JIS-X0208（記号２）→ 半角変換テーブル  */
/*-------------------------------------------*/
unsigned char KigouToHankaku2[0x10][3] = {
/* (A2-A0)    */    "",
/* (A2-A1) ◆ */    "◆",
/* (A2-A2) □ */    "□",
/* (A2-A3) ■ */    "■",
/* (A2-A4) △ */    "△",
/* (A2-A5) ▲ */    "▲",
/* (A2-A5) ▽ */    "▽",
/* (A2-A7) ▼ */    "▼",
/* (A2-A8) ※ */    "※",
/* (A2-A9) 〒 */    "〒",
/* (A2-AA) → */    "→",
/* (A2-AB) ← */    "←",
/* (A2-AC) ↑ */    "↑",
/* (A2-AD) ↓ */    "↓",
/* (A2-AE) 〓 */    "〓",
/* (A1-FF)    */    "" 
};

/*---------------------------------------------*/
/*   JIS-X0208（英・数字）→ 半角変換テーブル  */
/*---------------------------------------------*/
unsigned char EisuToHankaku[0x60][3] = {
/* (A3-A0)    */    "", 
/* (A3-A1)    */    "",
/* (A3-A2)    */    "", 
/* (A3-A3)    */    "",
/* (A3-A4)    */    "",
/* (A3-A5)    */    "", 
/* (A3-A5)    */    "", 
/* (A3-A7)    */    "", 
/* (A3-A8)    */    "", 
/* (A3-A9)    */    "", 
/* (A3-AA)    */    "", 
/* (A3-AB)    */    "", 
/* (A3-AC)    */    "", 
/* (A3-AD)    */    "", 
/* (A3-AE)    */    "", 
/* (A3-AF)    */    "", 
/* (A3-B0) ０ */    "0",
/* (A3-B1) １ */    "1",
/* (A3-B2) ２ */    "2",
/* (A3-B3) ３ */    "3",
/* (A3-B4) ４ */    "4",
/* (A3-B5) ５ */    "5",
/* (A3-B6) ６ */    "6",
/* (A3-B7) ７ */    "7",
/* (A3-B8) ８ */    "8",
/* (A3-B9) ９ */    "9",
/* (A3-BA)    */    "",
/* (A3-BB)    */    "",
/* (A3-BC)    */    "",
/* (A3-BD)    */    "",
/* (A3-BE)    */    "",
/* (A3-BF)    */    "",
/* (A3-C0)    */    "",
/* (A3-C1) Ａ */    "A",
/* (A3-C2) Ｂ */    "B",
/* (A3-C3) Ｃ */    "C",
/* (A3-C4) Ｄ */    "D",
/* (A3-C5) Ｅ */    "E",
/* (A3-C6) Ｆ */    "F",
/* (A3-C7) Ｇ */    "G",
/* (A3-C8) Ｈ */    "H",
/* (A3-C9) Ｉ */    "I",
/* (A3-CA) Ｊ */    "J",
/* (A3-CB) Ｋ */    "K",
/* (A3-CC) Ｌ */    "L",
/* (A3-CD) Ｍ */    "M",
/* (A3-CE) Ｎ */    "N",
/* (A3-CF) Ｏ */    "O",
/* (A3-D0) Ｐ */    "P",
/* (A3-D1) Ｑ */    "Q",
/* (A3-D2) Ｒ */    "R",
/* (A3-D3) Ｓ */    "S",
/* (A3-D4) Ｔ */    "T",
/* (A3-D5) Ｕ */    "U",
/* (A3-D6) Ｖ */    "V",
/* (A3-D7) Ｗ */    "W",
/* (A3-D8) Ｘ */    "X",
/* (A3-D9) Ｙ */    "Y",
/* (A3-DA) Ｚ */    "Z",
/* (A3-DB)    */    "",
/* (A3-DC)    */    "",
/* (A3-DD)    */    "",
/* (A3-DE)    */    "",
/* (A3-DF)    */    "",
/* (A3-E0)    */    "",
/* (A3-E1) Ａ */    "a",
/* (A3-E2) Ｂ */    "b",
/* (A3-E3) Ｃ */    "c",
/* (A3-E4) Ｄ */    "d",
/* (A3-E5) Ｅ */    "e",
/* (A3-E6) Ｆ */    "f",
/* (A3-E7) Ｇ */    "g",
/* (A3-E8) Ｈ */    "h",
/* (A3-E9) Ｉ */    "i",
/* (A3-EA) Ｊ */    "j",
/* (A3-EB) Ｋ */    "k",
/* (A3-EC) Ｌ */    "l",
/* (A3-ED) Ｍ */    "m",
/* (A3-EE) Ｎ */    "n",
/* (A3-EF) Ｏ */    "o",
/* (A3-F0) Ｐ */    "p",
/* (A3-F1) Ｑ */    "q",
/* (A3-F2) Ｒ */    "r",
/* (A3-F3) Ｓ */    "s",
/* (A3-F4) Ｔ */    "t",
/* (A3-F5) Ｕ */    "u",
/* (A3-F6) Ｖ */    "v",
/* (A3-F7) Ｗ */    "w",
/* (A3-F8) Ｘ */    "x",
/* (A3-F9) Ｙ */    "y",
/* (A3-FA) Ｚ */    "z"
};

/*---------------------------------------------*/
/*   JIS-X0208（カタカナ）→ 半角変換テーブル  */
/*---------------------------------------------*/
unsigned char KatakanaToHankaku[0x58][5] = {
/* (A5-A0)    */    "",
/* (A5-A1) ァ */    "ァ",
/* (A5-A2) ア */    "ア",
/* (A5-A3) ィ */    "ィ",
/* (A5-A4) イ */    "イ",
/* (A5-A5) ゥ */    "ゥ",
/* (A5-A6) ウ */    "ウ",
/* (A5-A7) ェ */    "ェ",
/* (A5-A8) エ */    "エ",
/* (A5-A9) ォ */    "ォ",
/* (A5-AA) オ */    "オ",
/* (A5-AB) カ */    "カ",
/* (A5-AC) ガ */    "ガ",
/* (A5-AD) キ */    "キ",
/* (A5-AE) ギ */    "ギ",
/* (A5-AF) ク */    "ク",
/* (A5-B0) グ */    "グ",
/* (A5-B1) ケ */    "ケ",
/* (A5-B2) ゲ */    "ゲ",
/* (A5-B3) コ */    "コ",
/* (A5-B4) ゴ */    "ゴ",
/* (A5-B5) サ */    "サ",
/* (A5-B6) ザ */    "ザ",
/* (A5-B7) シ */    "シ",
/* (A5-B8) ジ */    "ジ",
/* (A5-B9) ス */    "ス",
/* (A5-BA) ズ */    "ズ",
/* (A5-BB) セ */    "セ",
/* (A5-BC) ゼ */    "ゼ",
/* (A5-BD) ソ */    "ソ",
/* (A5-BE) ゾ */    "ゾ",
/* (A5-BF) タ */    "タ",
/* (A5-C0) ダ */    "ダ",
/* (A5-C1) チ */    "チ",
/* (A5-C2) ヂ */    "ヂ",
/* (A5-C3) ッ */    "ッ",
/* (A5-C4) ツ */    "ツ",
/* (A5-C5) ヅ */    "ヅ",
/* (A5-C6) テ */    "テ",
/* (A5-C7) デ */    "デ",
/* (A5-C8) ト */    "ト",
/* (A5-C9) ド */    "ド",
/* (A5-CA) ナ */    "ナ",
/* (A5-CB) ニ */    "ニ",
/* (A5-CC) ヌ */    "ヌ",
/* (A5-CD) ネ */    "ネ",
/* (A5-CE) ノ */    "ノ",
/* (A5-CF) ハ */    "ハ",
/* (A5-D0) バ */    "バ",
/* (A5-D1) パ */    "パ",
/* (A5-D2) ヒ */    "ヒ",
/* (A5-D3) ビ */    "ビ",
/* (A5-D4) ピ */    "ピ",
/* (A5-D5) フ */    "フ",
/* (A5-D6) ブ */    "ブ",
/* (A5-D7) プ */    "プ",
/* (A5-D8) ヘ */    "ヘ",
/* (A5-D9) ベ */    "ベ",
/* (A5-DA) ペ */    "ペ",
/* (A5-DB) ホ */    "ホ",
/* (A5-DC) ボ */    "ボ",
/* (A5-DD) ポ */    "ポ",
/* (A5-DE) マ */    "マ",
/* (A5-DF) ミ */    "ミ",
/* (A5-E0) ム */    "ム",
/* (A5-E1) メ */    "メ",
/* (A5-E2) モ */    "モ",
/* (A5-E3) ャ */    "ャ",
/* (A5-E4) ヤ */    "ヤ",
/* (A5-E5) ュ */    "ュ",
/* (A5-E6) ユ */    "ユ",
/* (A5-E7) ョ */    "ョ",
/* (A5-E8) ヨ */    "ヨ",
/* (A5-E9) ラ */    "ラ",
/* (A5-EA) リ */    "リ",
/* (A5-EB) ル */    "ル",
/* (A5-EC) レ */    "レ",
/* (A5-ED) ロ */    "ロ",
/* (A5-EE) ヮ */    "", 
/* (A5-EF) ワ */    "ワ",
/* (A5-F0) ヰ */    "ヰ",
/* (A5-F1) ヱ */    "ヱ",
/* (A5-F2) ヲ */    "ヲ",
/* (A5-F3) ン */    "ン",
/* (A5-F4) ヴ */    "ヴ",
/* (A5-F5) ヵ */    "ヵ",
/* (A5-F6) ヶ */    "ヶ"
};


/*****************************************************************************/
/*   濁点チェックテーブル                                                    */
/*                                                                           */
/*        0 : 濁音・半濁音に変換不可能な文字                                 */
/*        1 : 濁音に変換可能な文字                                           */
/*        2 : 濁音・半濁音に変換可能な文字                                   */
/*        3 : "ヴ"に変換可能な文字                                           */
/*****************************************************************************/
unsigned char DakutenCheckTbl[0x58] = {
/*   (40 A0) */   0,
/* ァ(40 A1) */   0,
/* ア(41 A2) */   0,
/* ィ(42 A3) */   0,
/* イ(43 A4) */   0,
/* ゥ(44 A5) */   0,
/* ウ(45 A6) */   3,
/* ェ(46 A7) */   0,
/* エ(47 A8) */   0,
/* ォ(48 A9) */   0,
/* オ(49 AA) */   0,
/* カ(4A AB) */   1,
/* ガ(4B AC) */   0,
/* キ(4C AD) */   1,
/* ギ(4D AE) */   0,
/* ク(4E AF) */   1,
/* グ(4F B0) */   0,
/* ケ(50 B1) */   1,
/* ゲ(51 B2) */   0,
/* コ(52 B3) */   1,
/* ゴ(53 B4) */   0,
/* サ(54 B5) */   1,
/* ザ(55 B6) */   0,
/* シ(56 B7) */   1,
/* ジ(57 B8) */   0,
/* ス(58 B9) */   1,
/* ズ(59 BA) */   0,
/* セ(5A BB) */   1,
/* ゼ(5B BC) */   0,
/* ソ(5C BD) */   1,
/* ゾ(5D BE) */   0,
/* タ(5E BF) */   1,
/* ダ(5F C0) */   0,
/* チ(60 C1) */   1,
/* ヂ(61 C2) */   0,
/* ッ(62 C3) */   0,
/* ツ(63 C4) */   1,
/* ヅ(64 C5) */   0,
/* テ(65 C6) */   1,
/* デ(66 C7) */   0,
/* ト(67 C8) */   1,
/* ド(68 C9) */   0,
/* ナ(69 CA) */   0,
/* ニ(6A CB) */   0,
/* ヌ(6B CC) */   0,
/* ネ(6C CD) */   0,
/* ノ(6D CE) */   0,
/* ハ(6E CF) */   2,
/* バ(6F D0) */   0,
/* パ(70 D1) */   0,
/* ヒ(71 D2) */   2,
/* ビ(72 D3) */   0,
/* ピ(73 D4) */   0,
/* フ(74 D5) */   2,
/* ブ(75 D6) */   0,
/* プ(76 D7) */   0,
/* ヘ(77 D8) */   2,
/* ベ(78 D9) */   0,
/* ペ(79 DA) */   0,
/* ホ(7A DB) */   2,
/* ボ(7B DC) */   0,
/* ポ(7C DD) */   0,
/* マ(7D DE) */   0,
/* ミ(7E DF) */   0,
/* ム(80 E0) */   0,
/* メ(81 E1) */   0,
/* モ(82 E2) */   0,
/* ャ(83 E3) */   0,
/* ヤ(84 E4) */   0,
/* ュ(85 E5) */   0,
/* ユ(86 E6) */   0,
/* ョ(87 E7) */   0,
/* ヨ(88 E8) */   0,
/* ラ(89 E9) */   0,
/* リ(8A EA) */   0,
/* ル(8B EB) */   0,
/* レ(8C EC) */   0,
/* ロ(8D ED) */   0,
/* ヮ(8E FE) */   0,
/* ワ(8F FF) */   0,
/* ヰ(80 F0) */   0,
/* ヱ(91 F1) */   0,
/* ヲ(92 F2) */   0,
/* ン(93 F3) */   0,
/* ヴ(94 F4) */   0,
/* ヵ(95 F5) */   0,
/* ヶ(96 F6) */   0
};
