// -*-Mode: C++; tab-width: 4; c-basic-offset: 4;-*-
// vi:set ts=4 sw=4:
//
// Assert.h -- Assert の定義ファイル
// 
// Copyright (c) 2005, 2023 Ricoh Company, Ltd.
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//     http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// 
#ifndef __UNA_ASSERT_H
#define __UNA_ASSERT_H

#ifdef DEBUG

#include "ModOsDriver.h"
#include "ModMessage.h"

//
//	DEFINE
//	DsapAssert -- アサート
//
//	NOTES
#define _UNA_ASSERT(expression) \
{ \
	if (!(expression)) \
	{ \
		ModErrorMessage \
			<< "Assertion failed. (" #expression ")" << ModEndl; \
		ModOsDriver::Process::abort(); \
	} \
}
#else
#define _UNA_ASSERT(expression)
#endif

#endif // __UNA_ASSERT_H

//
// Copyright (c) 2005, 2023 Ricoh Company, Ltd.
// All rights reserved.
//
