// -*-Mode: C++; tab-width: 4; c-basic-offset: 4;-*-
// vi:set ts=4 sw=4:
//
// RevokeStatement.h --
// 
// Copyright (c) 2007, 2012, 2023 Ricoh Company, Ltd.
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//     http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// 

#ifndef __SYDNEY_STATEMENT_REVOKESTATEMENT_H
#define __SYDNEY_STATEMENT_REVOKESTATEMENT_H

#include "Common/Common.h"
#include "Statement/Object.h"

_SYDNEY_BEGIN
_SYDNEY_STATEMENT_BEGIN

class IdentifierList;

//
//	CLASS
//	Statement::RevokeStatement --
//
//	NOTES
//
//
class SYD_STATEMENT_FUNCTION RevokeStatement  : public Statement::Object
{
public:
	//constructor
	RevokeStatement()
		: Object(ObjectType::RevokeStatement)
	{}
	//Constructor
	RevokeStatement(IdentifierList* pRole_, IdentifierList* pGrantee_);

	//create clone
	Object* copy() const;

	// Accessor
	IdentifierList* getRole() const;
	void setRole(IdentifierList* pRole_);
	IdentifierList* getGrantee() const;
	void setGrantee(IdentifierList* pGrantee_);
	
private:
	// Can't copied implicitly
	RevokeStatement& operator=(const RevokeStatement& cOther_);
};

_SYDNEY_STATEMENT_END
_SYDNEY_END

#endif //__SYDNEY_STATEMENT_REVOKESTATEMENT_H

//
//	Copyright (c) 2007, 2012, 2023 Ricoh Company, Ltd.
//	All rights reserved.
//
