// -*-Mode: C++; tab-width: 4; c-basic-offset: 4;-*-
// vi:set ts=4 sw=4:
//
// Statement::GroupingColumnReference -- GroupingColumnReference
// 
// Copyright (c) 1999, 2002, 2003, 2011, 2012, 2013, 2023 Ricoh Company, Ltd.
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//     http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// 

#ifndef __SYDNEY_STATEMENT__GROUPINGCOLUMN__REFERENCE_H
#define __SYDNEY_STATEMENT__GROUPINGCOLUMN__REFERENCE_H

#include "Statement/Object.h"

_SYDNEY_BEGIN
_SYDNEY_STATEMENT_BEGIN

	class ItemReference;
	class ValueExpression;
	
//	CLASS
//	GroupingColumnReference -- GroupingColumnReference
//
//	NOTES

class SYD_STATEMENT_FUNCTION GroupingColumnReference : public Statement::Object
{
public:
	//constructor
	GroupingColumnReference()
		: Object(ObjectType::GroupingColumnReference)
	{}
	// コンストラクタ
	GroupingColumnReference(ItemReference* pItemReference_);
	// コンストラクタ
	GroupingColumnReference(ValueExpression* pElementReference_);

	// SQL文で値を得る
	virtual ModUnicodeString toSQLStatement(bool bForCascade_ = false) const;

	// ItemReference を設定する
	ItemReference* getItemReference() const;

	Statement::Object* getReference() const;	
	
	// ItemReference を設定する
	void setItemReference(ItemReference* pItemReference_);

	// ItemReference を設定する
	void setElementReference(ValueExpression* pItemReference_);	

	//自身をコピーする
	Object* copy() const;

	// Analyzerを得る
	virtual const Analysis::Interface::IAnalyzer* getAnalyzer2() const;
	
#if 0
	// Analyzerを得る
	virtual const Analysis::Analyzer* getAnalyzer() const;
#endif

private:
	// 代入オペレーターは使わない
	GroupingColumnReference& operator=(const GroupingColumnReference& cOther_);

	// メンバ変数
};

//	FUNCTION public
//	Statement::GroupingColumnReference::copy -- 自身をコピーする
//
//	NOTES
//
//	ARGUMENTS
//	なし
//
//	RETURN
//	Statement::Object*
//
//	EXCEPTIONS

inline
Object*
GroupingColumnReference::copy() const
{
	return new GroupingColumnReference(*this);
}

_SYDNEY_STATEMENT_END
_SYDNEY_END

#endif // __SYDNEY_STATEMENT_GROUPINGCOLUMNREFERENCE_H

//
// Copyright (c) 1999, 2002, 2003, 2011, 2012, 2013, 2023 Ricoh Company, Ltd.
// All rights reserved.
//
