// 
// Copyright (c) 2023 Ricoh Company, Ltd.
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//     http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// 
/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>
#line 13 "../LemonSrc/SQLParserL.lemon"

// -*-Mode: C++; tab-width: 4; c-basic-offset: 4;-*-
// vi:set ts=4 sw=4:
//
// SQLParserL.cpp -- Lemonにより生成されたパーザ
//


namespace {
const char moduleName[] = "Statement";
const char srcFile[] = __FILE__;
}

#include <stdlib.h>
#include <malloc.h>

#include "SyDefault.h"
#include "SyReinterpretCast.h"
#include "SyDynamicCast.h"

#include "Statement/AllType.h"
#include "Statement/Object.h"
#include "Statement/SQLParser.h"
#include "Statement/SQLParserL.h"
#include "Statement/SQLScanner.h"
#include "Statement/Token.h"

#include "Common/Data.h"
#include "Common/DateData.h"
#include "Common/DateTimeData.h"
#include "Common/IntegerData.h"
#include "Common/Message.h"
#include "Common/SQLData.h"

#include "Os/Limits.h"

#include "ModAutoPointer.h"
#include "ModPair.h"
#include "ModUnicodeCharTrait.h"
#include "ModUnicodeOstrStream.h"

_SYDNEY_USING
_SYDNEY_STATEMENT_USING

struct yyStackEntry;
namespace
{
// overloaded realloc is required
inline yyStackEntry* realloc(yyStackEntry* ptr, size_t size) {
	return static_cast<yyStackEntry*>(::realloc(ptr, size));
}
}

#line 63 "../LemonSrc/SQLParserL.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    SQLParserEngineTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is SQLParserEngineTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    SQLParserEngineARG_SDECL     A static variable declaration for the %extra_argument
**    SQLParserEngineARG_PDECL     A parameter declaration for the %extra_argument
**    SQLParserEngineARG_STORE     Code to store %extra_argument into yypParser
**    SQLParserEngineARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned short int
#define YYNOCODE 665
#define YYACTIONTYPE unsigned short int
#define SQLParserEngineTOKENTYPE  Token* 
typedef union {
  int yyinit;
  SQLParserEngineTOKENTYPE yy0;
  ContainsOption* yy11;
  InsertStatement* yy13;
  AlterIndexAction* yy25;
  AlterAreaStatement* yy37;
  DropTableStatement* yy41;
  SelectSubListList* yy57;
  SelectTargetList* yy82;
  ItemReference* yy85;
  RollbackStatement* yy110;
  TableElementList* yy117;
  ColumnConstraintDefinition* yy123;
  DeclareStatement* yy124;
  VerifyStatement* yy133;
  XA_RecoverStatement* yy134;
  ColumnConstraintDefinitionList* yy139;
  DatabasePathElementList* yy159;
  DeleteStatement* yy171;
  TableReferenceList* yy178;
  TablePrimary* yy183;
  ContainsOperand* yy231;
  EndExplainStatement* yy232;
  OptionalAreaParameterList* yy243;
  GroupByClause* yy244;
  UpdateSetClause* yy263;
  TableCorrelationSpec* yy272;
  VariableName* yy278;
  DatabasePathElement* yy287;
  Generator::Definition::When yy311;
  SelectSubList* yy329;
  UpdateStatement* yy351;
  ExplainOption::Value yy360;
  XA_ForgetStatement* yy367;
  ColumnName* yy370;
  DropFunctionStatement* yy371;
  AlterDatabaseAttributeList* yy388;
  ReturnsClause* yy407;
  VerifyOptionList* yy409;
  TableExpression* yy415;
  Expand* yy416;
  ColumnDefinition* yy418;
  Common::SQLData::Type::Value yy439;
  IndexDefinition* yy456;
  HintElementList* yy484;
  AlterAreaAction* yy490;
  AlterCascadeStatement* yy496;
  GroupingColumnReferenceList* yy511;
  OptionalAreaParameter* yy515;
  StartTransactionStatement* yy516;
  AlterDatabaseAttribute* yy532;
  QueryExpression* yy533;
  DatabaseCreateOptionList* yy553;
  StartExplainStatement* yy555;
  XA_PrepareStatement* yy563;
  HintElement* yy564;
  IsolationLevel* yy565;
  AlterTableStatement* yy568;
  LimitSpecification* yy579;
  ValueExpression * yy584;
  AreaElementList* yy586;
  SelectList* yy587;
  ReturnStatement* yy592;
  GroupingElementList* yy604;
  ValueExpressionList * yy616;
  SortSpecificationList* yy640;
  TableConstraintDefinition* yy641;
  ContainsOperandList* yy647;
  PartitionDefinition::Category::Value yy648;
  TransactionModeList* yy662;
  DropAreaStatement* yy706;
  BulkSpecification* yy707;
  TransactAccMode* yy715;
  CascadeDefinition* yy720;
  PartitionDefinition* yy726;
  ModPair<int, int>* yy727;
  HavingClause* yy729;
  DropIndexStatement* yy745;
  IntegerValue* yy754;
  int yy764;
  XA_CommitStatement* yy777;
  DatabaseDefinition* yy809;
  AlterTableAction* yy810;
  SortSpecification* yy816;
  DisconnectStatement* yy822;
  InsertColumnsAndSource* yy853;
  AreaDefinition* yy857;
  Hint* yy858;
  EndBackupStatement* yy861;
  FunctionDefinition* yy862;
  JoinType::Value yy880;
  XA_StartStatement* yy882;
  RoutineBody* yy891;
  SetTransactionStatement* yy918;
  XA_EndStatement* yy931;
  Object* yy934;
  MountDatabaseStatement* yy936;
  bool yy937;
  XA_RollbackStatement* yy938;
  TableDefinition* yy1000;
  ParameterDeclaration* yy1010;
  UnmountDatabaseStatement* yy1043;
  ExplainStatement* yy1045;
  AreaOption* yy1053;
  SyncStatement* yy1057;
  DropPartitionStatement* yy1071;
  DropDatabaseStatement* yy1074;
  ParameterDeclarationList* yy1075;
  QuerySpecification* yy1078;
  QualifiedJoin* yy1083;
  StartBackupStatement* yy1108;
  Identifier* yy1118;
  IdentifierList* yy1134;
  ValueExpressionList* yy1140;
  XA_Identifier* yy1146;
  DropCascadeStatement* yy1161;
  ValueExpression* yy1172;
  AreaDataDefinition* yy1187;
  AlterIndexStatement* yy1192;
  Common::SQLData* yy1194;
  CommitStatement* yy1197;
  Literal* yy1200;
  UpdateSetClauseList* yy1207;
  GroupingColumnReference* yy1215;
  ColumnNameList* yy1234;
  DatabaseCreateOption* yy1241;
  AlterPartitionStatement* yy1246;
  CheckpointStatement* yy1248;
  ExistsJoin* yy1255;
  RevokeStatement* yy1256;
  DerivedColumn* yy1268;
  GrantStatement* yy1276;
  ExplainOption* yy1289;
  QueryOperator* yy1313;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 0
#endif
#define SQLParserEngineARG_SDECL  Statement::SQLParser* pParser ;
#define SQLParserEngineARG_PDECL , Statement::SQLParser* pParser 
#define SQLParserEngineARG_FETCH  Statement::SQLParser* pParser  = yypParser->pParser 
#define SQLParserEngineARG_STORE yypParser->pParser  = pParser 
#define YYNSTATE 1647
#define YYNRULE 931
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   692, 1128,  173, 1156, 1131, 1132, 1133, 1134, 1135, 1489,
 /*    10 */  1488, 1479, 1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535,
 /*    20 */  1458,  609,  912,  909,  887,  883,  884,  885,  881, 1477,
 /*    30 */  1470, 1468, 1465,  801,  790, 1454, 1525, 1560, 1559, 1558,
 /*    40 */  1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535,  857,  111,
 /*    50 */  1489, 1488, 1479, 1557, 1556, 1551, 1550, 1548, 1546, 1536,
 /*    60 */  1535, 1458,  609,  111,  227, 1203, 1396, 1406, 1322, 1339,
 /*    70 */  1477, 1470, 1468, 1465,  801,  790, 1454,  260,  115, 1384,
 /*    80 */   121, 1451, 1411,  187,  860, 1452, 1341, 1499, 1497, 1449,
 /*    90 */  1448, 1446, 1445, 1443, 1442, 1828,  911,  855,  853,  851,
 /*   100 */   392,  848, 1007,  512,  977,  773,  815,  294,  268,  267,
 /*   110 */   587,  858, 1449, 1448, 1446, 1445, 1443, 1442,  845,  384,
 /*   120 */   892,  908,  454,  228,  226,   77, 1452, 1341,  900, 1209,
 /*   130 */   114,  901,  902,  903,  904,  897, 1554, 1553, 1552, 1547,
 /*   140 */  1539,  873,  868, 1605, 1606, 1607, 1608, 1609,  538,  551,
 /*   150 */  1426, 1423, 1421, 1417, 1416, 1415, 1414, 1412, 1409,  136,
 /*   160 */   608, 1384,  570,   80,  600, 1176,  648,  671,  119,  586,
 /*   170 */   823,  891, 1258, 1256, 1525, 1560, 1559, 1558, 1557, 1556,
 /*   180 */  1551, 1550, 1548, 1546, 1536, 1535, 1347, 1342, 1338, 1337,
 /*   190 */  1336, 1335,  916, 1334, 1333,  461,  480,  485, 1407,  674,
 /*   200 */   540,  543, 1405, 1404,  654, 1547, 1301, 1299,  760, 1294,
 /*   210 */   968,  595,  514,  558,  548,  645,  529,  523, 1395, 1394,
 /*   220 */  1393, 1387,  242,  812,  810,  811, 1314, 1347, 1342, 1338,
 /*   230 */  1337, 1336, 1335,  360, 1334, 1333,  762,  822, 1149, 1016,
 /*   240 */   593,  361, 1518,  985,  240,  296,  628, 1301, 1299, 1176,
 /*   250 */  1294, 1176, 1289, 1287, 1271,  814,  816,  818, 1489, 1488,
 /*   260 */  1479, 1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535, 1458,
 /*   270 */   609,  995,  236,  487, 1396, 1406, 1322, 1339, 1477, 1470,
 /*   280 */  1468, 1465,  801,  790, 1454,  260,  409,  405,  410, 1451,
 /*   290 */   174, 1156, 1131, 1132, 1133, 1134, 1135, 1449, 1448, 1446,
 /*   300 */  1445, 1443, 1442, 1554, 1553, 1552, 1547, 1539,  873,  868,
 /*   310 */  1505,  512, 1221,  140, 1519,  610,  260, 1186, 1187, 1188,
 /*   320 */  1451, 1515, 1513, 1510, 1509, 1507, 1506,  111, 1449, 1448,
 /*   330 */  1446, 1445, 1443, 1442, 1452, 1341, 1525, 1560, 1559, 1558,
 /*   340 */  1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535, 1490, 1491,
 /*   350 */  1492, 1493, 1494, 1495, 1496, 1638,  538,  551, 1426, 1423,
 /*   360 */  1421, 1417, 1416, 1415, 1414, 1412, 1409,   52,  185,  652,
 /*   370 */   570, 1418, 1488, 1176, 1557, 1556,  126, 1419, 1420,  235,
 /*   380 */   215,  847, 1458,  609, 1549,  227, 1203,  205, 1406,   77,
 /*   390 */  1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 1384,  247,
 /*   400 */  1024,  212,  225, 1458,  665,  687, 1407,  674,  540,  543,
 /*   410 */  1405, 1404,  654, 1499, 1497,  835,  801,  692, 1199, 1203,
 /*   420 */   514,  558,  548,  645,  529,  523, 1395, 1394, 1393, 1387,
 /*   430 */   924,  812,  810,  811, 1314, 1347, 1342, 1338, 1337, 1336,
 /*   440 */  1335,  943, 1334, 1333,  228,  226, 1178, 1452, 1341,  900,
 /*   450 */  1209,  142, 1519, 1263,  628, 1301, 1299,  896, 1294,  897,
 /*   460 */  1289, 1287, 1271,  814,  816,  818, 1390, 1489, 1488, 1479,
 /*   470 */  1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535, 1458,  609,
 /*   480 */   826,  921,  929, 1396, 1406, 1322, 1339, 1477, 1470, 1468,
 /*   490 */  1465,  801,  790, 1454,  260,  709, 1099, 1489, 1451,   26,
 /*   500 */  1015, 1019, 1551, 1550, 1548, 1546, 1449, 1448, 1446, 1445,
 /*   510 */  1443, 1442, 1143, 1355,  227, 1203,  894, 1354,  797,  461,
 /*   520 */  1267, 1352, 1349, 1405, 1404,  589, 1168,  488,  492, 1162,
 /*   530 */  1180, 1157, 1183,  620,  633,  632, 1481, 1482, 1484, 1485,
 /*   540 */  1434,  204, 1483, 1452, 1341, 1474,  175, 1486, 1347, 1342,
 /*   550 */  1338, 1337, 1336, 1335,  941, 1334, 1333, 1533, 1534, 1499,
 /*   560 */  1497,  138,  493,   83,   96,  538,   89,   87, 1301, 1299,
 /*   570 */   798, 1294,  260,  228,  226,  151, 1451,  420,  900, 1209,
 /*   580 */  1488,  187, 1557, 1556, 1449, 1448, 1446, 1445, 1443, 1442,
 /*   590 */  1458,  609, 1158, 1209, 1499, 1497, 1406, 1473, 1339, 1477,
 /*   600 */  1470, 1468, 1465,  801,  790, 1454, 1048, 1049, 1050, 1051,
 /*   610 */  1458,  665,  262,  141, 1519, 1407,  674,  565,  563, 1405,
 /*   620 */  1404,  654,  835,  801,  799,  760, 1136, 1129,  111,  533,
 /*   630 */   558,  548,  645,  529,  523, 1395, 1394, 1393, 1387,  587,
 /*   640 */   812,  810,  811, 1314, 1347, 1342, 1338, 1337, 1336, 1335,
 /*   650 */  1487, 1334, 1333,  471, 1182, 1452, 1341,   38,  279,  472,
 /*   660 */   912, 1035, 1092,  628, 1301, 1299,  951, 1294,  569, 1289,
 /*   670 */  1287, 1271,  814,  816,  818, 1489, 1488, 1479, 1557, 1556,
 /*   680 */  1551, 1550, 1548, 1546, 1536, 1535, 1458,  609,  930,  929,
 /*   690 */   759, 1396, 1406, 1322, 1339, 1477, 1470, 1468, 1465,  801,
 /*   700 */   790, 1454,  260, 1543, 1544,  756, 1451, 1635, 1540, 1541,
 /*   710 */  1542, 1545,  365, 1236, 1449, 1448, 1446, 1445, 1443, 1442,
 /*   720 */   367,  455,  227, 1203,  223,  221,  435, 1203, 1267, 1352,
 /*   730 */  1349, 1405, 1404, 1353,  301,  309, 1212,  437,  834, 1401,
 /*   740 */   595,  620,  633,  632,  911,  855,  853,  851,  392,  848,
 /*   750 */   506, 1452, 1341,  759,  815,  762, 1347, 1342, 1338, 1337,
 /*   760 */  1336, 1335, 1247, 1334, 1333, 1401,  822, 1149, 1162,  593,
 /*   770 */  1157,  441,  241,  538,  840, 2065, 1301, 1299,  927, 1294,
 /*   780 */  2065,  228,  226, 1388,  449,  231,  900, 1209, 2068, 1525,
 /*   790 */  1560, 1559, 1558, 1557, 1556, 1551, 1550, 1548, 1546, 1536,
 /*   800 */  1535, 1220, 1560, 1559, 1558, 1557, 1556, 1551, 1550, 1548,
 /*   810 */  1546, 1536, 1535,  567, 1489, 1344, 1187, 1188,  823, 1551,
 /*   820 */  1550, 1548, 1546, 1407,  674,  565,  563, 1405, 1404,  654,
 /*   830 */  1399, 1158, 1209,  738,  261,  200,  380,  533,  558,  548,
 /*   840 */   645,  529,  523, 1395, 1394, 1393, 1387, 1635,  812,  810,
 /*   850 */   811, 1314, 1347, 1342, 1338, 1337, 1336, 1335,  379, 1334,
 /*   860 */  1333,  328, 1039,  680,  673, 1160, 1159,  579, 1435,  171,
 /*   870 */   702,  628, 1301, 1299,  575, 1294,  153, 1289, 1287, 1271,
 /*   880 */   814,  816,  818,  111, 1489, 1488, 1479, 1557, 1556, 1551,
 /*   890 */  1550, 1548, 1546, 1536, 1535, 1458,  609,  151,  138,  420,
 /*   900 */  1396, 1406, 1322, 1339, 1477, 1470, 1468, 1465,  801,  790,
 /*   910 */  1454,  911,  855,  853,  851,   86,   85,  912,  962,  912,
 /*   920 */  1035, 1554, 1553, 1552, 1547, 1539,  873,  868, 1499, 1497,
 /*   930 */  1475, 1472, 1466, 1464, 1463, 1462, 1461,  513,  896, 2096,
 /*   940 */  2096, 2072, 2096, 2096,    4,   77,  420, 1220, 1560, 1559,
 /*   950 */  1558, 1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535, 1489,
 /*   960 */  1452, 1341, 2162,  111, 1551, 1550, 1548, 1546,  942,   80,
 /*   970 */  1229,  872,  121,  896,   68, 1399,   66,  833,   67,   38,
 /*   980 */   279, 1208,  538,  615, 1426, 1423, 1421, 1417, 1416, 1415,
 /*   990 */  1414, 1412, 1409, 1141,  663,  151,  570,  420,   80,   68,
 /*  1000 */   683,   66,  667,   67,  854,  882,  701, 1087,  636,  626,
 /*  1010 */   621,  784,  770,  724,  734, 1313, 1312,   16, 1554, 1553,
 /*  1020 */  1552,  842,  878,  879,  852,  775,   38,  279, 1139, 1466,
 /*  1030 */  1458,  665, 1407,  201,  552,  556, 1405, 1404,  654, 1255,
 /*  1040 */   501,  111, 1385,  801, 1266,  468,  515,  573,  571,   80,
 /*  1050 */   537,  534, 1395, 1394, 1393, 1387,   77,  481, 1272, 1286,
 /*  1060 */  1314, 1347, 1342, 1338, 1337, 1336, 1335, 1527, 1334, 1333,
 /*  1070 */  1219, 1130, 1131, 1132, 1133, 1134, 1135,   38,  279,  961,
 /*  1080 */   187, 1301, 1299,  746, 1294, 1593, 1289, 1287, 1271, 1285,
 /*  1090 */  1273, 1592, 1489, 1488, 1479, 1557, 1556, 1551, 1550, 1548,
 /*  1100 */  1546, 1536, 1535, 1458,  609,  762,  227, 1203, 1396, 1406,
 /*  1110 */  1322, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454,  748,
 /*  1120 */   311, 1039,  680,  673, 1026, 1554, 1553, 1552, 1547, 1539,
 /*  1130 */   873,  868, 1499, 1497, 1475, 1472, 1466, 1464, 1463, 1462,
 /*  1140 */  1461,  729,  172, 1499, 1497,  513,  303,  920,  128,  539,
 /*  1150 */    29,  183,   36,   48,   33,   31,   32,   30,  553,  180,
 /*  1160 */    63,  675,  821,  912,  909,  228,  226, 1176, 1452, 1341,
 /*  1170 */   900, 1209, 2067, 1020, 1379,  872,  933, 2067, 1229,  912,
 /*  1180 */  1035,  833,  256, 2096, 2096, 2072, 2096, 2096,  733,  730,
 /*  1190 */   538,  615, 1426, 1423, 1421, 1417, 1416, 1415, 1414, 1412,
 /*  1200 */  1409,  554, 1499, 1497,  570, 1138, 2162, 1554, 1553,  736,
 /*  1210 */   224,  229, 1248, 1189,  705,  784, 1223, 1384,  167, 2095,
 /*  1220 */  2095,   16, 2095, 2095,  912,  909,  878,  879,  852, 1086,
 /*  1230 */  1085, 1081, 1077, 1075, 1070, 1068, 1067, 1064, 1061, 1058,
 /*  1240 */  1407, 1433,  552,  556, 1405, 1404,  654, 1255,  501, 2074,
 /*  1250 */   581, 1638, 1266,  468,  515,  573,  571, 1176,  537,  534,
 /*  1260 */  1395, 1394, 1393, 1387,  177,  587, 1272, 1286, 1314, 1347,
 /*  1270 */  1342, 1338, 1337, 1336, 1335,  216, 1334, 1333,  711, 1066,
 /*  1280 */  1049, 1050, 1051,  204,   83,   96,  193,   89,   87, 1301,
 /*  1290 */  1299,  327, 1294,  470, 1289, 1287, 1271, 1285, 1273,  440,
 /*  1300 */  1203, 1489, 1488, 1479, 1557, 1556, 1551, 1550, 1548, 1546,
 /*  1310 */  1536, 1535, 1458,  609, 1389, 1511, 1512, 1396, 1406, 1322,
 /*  1320 */  1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 1227,  372,
 /*  1330 */   469,  187,   86,   85, 1432,  954, 1554, 1553, 1554, 1553,
 /*  1340 */  1552, 1547, 1539,  873,  868, 1499, 1497, 1475, 1472, 1466,
 /*  1350 */  1464, 1463, 1462, 1461,  513,    8,   83,   96,  808,   89,
 /*  1360 */    87,    3,  859, 1425, 1499, 1497,  595, 1458,  665, 1255,
 /*  1370 */   501, 1284,  158, 1203, 1266,  468,  178, 1452, 1341,  835,
 /*  1380 */   801, 1028,  680,  673,  416,  666, 1177, 1229,  872,  377,
 /*  1390 */   653, 1281, 1148, 1149,  833,  593,    8,   92, 1487,  538,
 /*  1400 */   615, 1426, 1423, 1421, 1417, 1416, 1415, 1414, 1412, 1409,
 /*  1410 */   984,  663,  495,  570, 1499, 1497, 1099,  683,  187,  667,
 /*  1420 */  1547,  854,  882, 1458,  665,  636,  626,  621,  784,  770,
 /*  1430 */   724,  734, 1313, 1312,   16, 1385,  801,  630,  444,  878,
 /*  1440 */   879,  852,  775, 1043,  550,  272,  922,  584,  213, 1407,
 /*  1450 */   644,  552,  556, 1405, 1404,  654, 1276, 1424, 1520, 1521,
 /*  1460 */  1522, 1523, 1524,  515,  573,  571,  920,  537,  534, 1395,
 /*  1470 */  1394, 1393, 1387,  288,  286, 1272, 1286, 1314, 1347, 1342,
 /*  1480 */  1338, 1337, 1336, 1335, 1010, 1334, 1333,  406,  403, 1481,
 /*  1490 */  1482, 1484, 1485,   83,   96, 1483,   89,   87, 1301, 1299,
 /*  1500 */  1480, 1294, 1384, 1289, 1287, 1271, 1285, 1273,  778, 1489,
 /*  1510 */  1488, 1479, 1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535,
 /*  1520 */  1458,  609, 1391, 1392,  614, 1396, 1406, 1322, 1339, 1477,
 /*  1530 */  1470, 1468, 1465,  801,  790, 1454,  896,  273,  483,  758,
 /*  1540 */   776, 1275, 1277, 1278, 1279, 1280, 1282, 1283,  781,  787,
 /*  1550 */   792, 1297, 1298, 1307, 1308, 1309, 1499, 1497,  187, 1176,
 /*  1560 */   607,  260,  513,  637,  591, 1451, 1508,  678,  897,  295,
 /*  1570 */   227, 1203,  135, 1449, 1448, 1446, 1445, 1443, 1442,  769,
 /*  1580 */    68,  387,   66,  874,   67, 1452, 1341,  832,  757, 2067,
 /*  1590 */   732,  898,  254,  919, 2067, 1229,  187,  843, 1398,  433,
 /*  1600 */  2096, 2096, 2072, 2096, 2096,  877, 1377,  538,  615, 1426,
 /*  1610 */  1423, 1421, 1417, 1416, 1415, 1414, 1412, 1409,  999, 1499,
 /*  1620 */  1497,  570, 1184, 2162, 1565,  383,  892,  908,  366,  228,
 /*  1630 */   226, 1002, 1203, 1236,  900, 1209, 1398,  901,  902,  903,
 /*  1640 */   904,  920,  911,  855,  853,  851,  392,  848,    9, 1318,
 /*  1650 */   426,  467,  815, 1511, 1092,  291, 1316, 1407, 1263,  552,
 /*  1660 */   556, 1405, 1404,  654,  618, 1066, 1049, 1050, 1051,  841,
 /*  1670 */   289,  515,  573,  571,   94,  537,  534, 1395, 1394, 1393,
 /*  1680 */  1387, 1320, 1239, 1272, 1286, 1314, 1347, 1342, 1338, 1337,
 /*  1690 */  1336, 1335, 2065, 1334, 1333,  692,  611, 2065,   83,   96,
 /*  1700 */   864,   89,   87,  631, 1063, 2068, 1301, 1299, 1162, 1294,
 /*  1710 */   950, 1289, 1287, 1271, 1285, 1273,  823, 1401, 1489, 1488,
 /*  1720 */  1479, 1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535, 1458,
 /*  1730 */   609, 1499, 1497, 2040, 1396, 1406, 1322, 1339, 1477, 1470,
 /*  1740 */  1468, 1465,  801,  790, 1454,  270, 1011,  912,  909,   86,
 /*  1750 */    85,  416, 1321,  413,  691, 1554, 1553, 1552, 1547, 1539,
 /*  1760 */   873,  868, 1499, 1497, 1475, 1472, 1466, 1464, 1463, 1462,
 /*  1770 */  1461,  513,  260,  612, 1317, 1319, 1451, 1324,    3,   83,
 /*  1780 */    96, 1487,   89,   87, 1449, 1448, 1446, 1445, 1443, 1442,
 /*  1790 */  1768, 1768, 1768, 1517, 1452, 1341, 1488,  129, 1557, 1556,
 /*  1800 */   510, 1203,  918, 1165, 1229,  872, 1381, 1382, 1383, 1179,
 /*  1810 */  1411,  833, 1360, 1499, 1497, 1359,  538,  615, 1426, 1423,
 /*  1820 */  1421, 1417, 1416, 1415, 1414, 1412, 1409, 1151,  663,  263,
 /*  1830 */   570, 1517, 1106,  416,  683,  448,  667, 1166,  854,  882,
 /*  1840 */  1183, 1514,  636,  626,  621,  784,  770,  724,  734, 1313,
 /*  1850 */  1312,   16, 1366,    6,  429, 1768,  878,  879,  852,  775,
 /*  1860 */   630,   83,   96, 1768,   89,   87, 1407, 1263,  552,  556,
 /*  1870 */  1405, 1404,  654, 1768,  445,  912,  909,  709, 1768, 1516,
 /*  1880 */   515,  573,  571,  130,  537,  534, 1395, 1394, 1393, 1387,
 /*  1890 */  1263, 1332, 1272, 1286, 1314, 1347, 1342, 1338, 1337, 1336,
 /*  1900 */  1335,  561, 1334, 1333,  647, 1066, 1049, 1050, 1051, 1488,
 /*  1910 */   765, 1557, 1556,  912, 1375, 1301, 1299,  280, 1294, 1555,
 /*  1920 */  1289, 1287, 1271, 1285, 1273, 1400, 1489, 1488, 1479, 1557,
 /*  1930 */  1556, 1551, 1550, 1548, 1546, 1536, 1535, 1458,  609,  912,
 /*  1940 */   909, 1001, 1396, 1406, 1322, 1339, 1477, 1470, 1468, 1465,
 /*  1950 */   801,  790, 1454,  693,  260, 1201, 1358, 1397, 1451, 1434,
 /*  1960 */  1499, 1497, 1499, 1497,  920,  578, 1449, 1448, 1446, 1445,
 /*  1970 */  1443, 1442, 1458,  665, 1499, 1497, 1458,  665,  255,  513,
 /*  1980 */   346, 1554, 1553,  607, 1385,  801,  637,  356, 1385,  801,
 /*  1990 */   134,    6,  420,   42,  349,  358,  375, 1107,  333, 1499,
 /*  2000 */  1497,  874, 1452, 1341, 1152,  832,  344,  155,  342,  994,
 /*  2010 */   936,  476, 1229,  345, 1411,   14, 1122,  341, 1140,  363,
 /*  2020 */   451,  707, 1231,  452,  538,  615, 1426, 1423, 1421, 1417,
 /*  2030 */  1416, 1415, 1414, 1412, 1409,  641, 1002, 1203,  570, 2094,
 /*  2040 */  2094, 1076, 2094, 2094,  129, 1489, 1488, 1479, 1557, 1556,
 /*  2050 */  1551, 1550, 1548, 1546, 1536, 1535, 1458,  609,  973,  382,
 /*  2060 */   498, 1396, 1406, 1322, 1339, 1477, 1470, 1468, 1465,  801,
 /*  2070 */   790, 1454,   38,  279, 1407,  503,  552,  556, 1405, 1404,
 /*  2080 */   654,   84,  292, 1488,  694, 1557, 1556,  748,  515,  573,
 /*  2090 */   571,  850,  537,  534, 1395, 1394, 1393, 1387,  513, 1400,
 /*  2100 */  1272, 1286, 1314, 1347, 1342, 1338, 1337, 1336, 1335,  729,
 /*  2110 */  1334, 1333,  282, 1076, 2095, 2095,  678, 2095, 2095,  780,
 /*  2120 */   678, 1452, 1341, 1301, 1299,  769, 1294,  387, 1289, 1287,
 /*  2130 */  1271, 1285, 1273,  446,   83,   96,  732,   89,   87, 1554,
 /*  2140 */  1553, 1552,  785,  538,  703, 1426, 1423, 1421, 1417, 1416,
 /*  2150 */  1415, 1414, 1412, 1409,  867, 1377, 1591,  570,  725, 1377,
 /*  2160 */  1458,  665, 1590,  404, 1181, 1213,  335,  462,  428,  554,
 /*  2170 */    24,  111, 1385,  801, 1547,   79,  138,  736,  224,  229,
 /*  2180 */  1248, 1499, 1497,  293, 1153,  337,  450, 2094, 2094, 1455,
 /*  2190 */  2094, 2094,   23, 1407,   42,  552,  556, 1405, 1404,  654,
 /*  2200 */   274,  416,  731,  417,   25,  760, 1230,  515,  573,  571,
 /*  2210 */   896,  537,  534, 1395, 1394, 1393, 1387, 2073,  817, 1272,
 /*  2220 */  1286, 1314, 1347, 1342, 1338, 1337, 1336, 1335, 1263, 1334,
 /*  2230 */  1333,  912, 1378,  759,  203,  762, 1243, 1244, 1245,  170,
 /*  2240 */  1370, 1368, 1301, 1299, 1162, 1294,  639, 1289, 1287, 1271,
 /*  2250 */  1285, 1273, 1489, 1488, 1479, 1557, 1556, 1551, 1550, 1548,
 /*  2260 */  1546, 1536, 1535, 1458,  609, 1139,  227, 1203, 1396, 1406,
 /*  2270 */  1322, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454,  211,
 /*  2280 */    83,   96,  260,   89,   87,  643, 1451, 1430,  171,   83,
 /*  2290 */    96, 1263,   89,   87, 1449, 1448, 1446, 1445, 1443, 1442,
 /*  2300 */  1458,  665, 1263,  697,  678,  513,  912,  909,  149, 1203,
 /*  2310 */  1330,  888, 1385,  801,  886,  624,  147, 1718,  420, 1174,
 /*  2320 */  1263,  386,  892,  870,   18,  228,  226,  701, 1452, 1341,
 /*  2330 */   900, 1209,  562,  901,  902,  903,  904,  686,   56,  264,
 /*  2340 */  1083, 1263,  708, 1377, 1099,  749,  144, 1246, 1499, 1497,
 /*  2350 */   538, 1429, 1426, 1423, 1421, 1417, 1416, 1415, 1414, 1412,
 /*  2360 */  1409, 1210, 1080, 1225,  570,  912,  907,   43,  416,  143,
 /*  2370 */   418, 1489, 1488, 1479, 1557, 1556, 1551, 1550, 1548, 1546,
 /*  2380 */  1536, 1535, 1458,  609,  698, 1203,  897, 1396, 1406, 1322,
 /*  2390 */  1339, 1477, 1470, 1468, 1465,  801,  790, 1454,   38,  279,
 /*  2400 */  1407, 1012,  552,  556, 1405, 1404,  654,  896, 1554, 1553,
 /*  2410 */  1084,  264, 1083,  169,  515,  573,  571, 1013,  537,  534,
 /*  2420 */  1395, 1394, 1393, 1387,  513, 1099, 1272, 1286, 1314, 1347,
 /*  2430 */  1342, 1338, 1337, 1336, 1335, 2165, 1334, 1333,  227, 1203,
 /*  2440 */  1500,  219, 1144,  889, 1380,  111,  461, 1452, 1341, 1301,
 /*  2450 */  1299,  181, 1294, 1440, 1289, 1287, 1271, 1285, 1273,  912,
 /*  2460 */   909, 2072,  895, 1499, 1497, 1488,  331, 1557, 1556,  538,
 /*  2470 */  1427, 1426, 1423, 1421, 1417, 1416, 1415, 1414, 1412, 1409,
 /*  2480 */   791, 1360, 2162,  570, 1359,  596, 1072, 1458,  665, 1189,
 /*  2490 */   643,  912,  909,  257,  892,  908,   44,  228,  226,  835,
 /*  2500 */   801,  113,  900, 1209, 1124,  901,  902,  903,  904,   13,
 /*  2510 */    12,  694,  114, 1488, 1012, 1557, 1556,  576, 1561, 1407,
 /*  2520 */  1303,  552,  556, 1405, 1404,  654,  685, 1203,  692, 1360,
 /*  2530 */  1006,   80, 1359,  515,  573,  571,  355,  537,  534, 1395,
 /*  2540 */  1394, 1393, 1387,  844,  359, 1272, 1286, 1314, 1347, 1342,
 /*  2550 */  1338, 1337, 1336, 1335,  613, 1334, 1333, 1023, 1150,  307,
 /*  2560 */  1225, 1236, 1431,  466, 1203,  111,  926,  643, 1301, 1299,
 /*  2570 */   196, 1294,  875, 1289, 1287, 1271, 1285, 1273, 1489, 1488,
 /*  2580 */  1479, 1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535, 1458,
 /*  2590 */   609,   13,   12,  846, 1396, 1406, 1322, 1339, 1477, 1470,
 /*  2600 */  1468, 1465,  801,  790, 1454,  260, 1176,  912,  909, 1451,
 /*  2610 */  1241,  912,  909, 2071,  912,  909,  302, 1449, 1448, 1446,
 /*  2620 */  1445, 1443, 1442, 1458,  665, 1357, 2066,   77, 2072, 1537,
 /*  2630 */  1538, 2066,  114,  588, 2161, 1385,  801,  574, 1145, 2069,
 /*  2640 */   590, 2149, 1236, 1488,  692, 1557, 1556, 1059, 1060, 2162,
 /*  2650 */   643,   80, 1499, 1497, 1452, 1341, 1189, 1074, 2066, 1360,
 /*  2660 */  2070,  396, 1359, 2066, 1363, 1364,  643, 2041, 1073, 1612,
 /*  2670 */   457, 2069,  285, 1356,  456,  208,  538,  899,  507, 1547,
 /*  2680 */  1539, 2160,  453,   49,  638,  393, 1202, 1466, 2148,  568,
 /*  2690 */   129, 1235,  442,  393, 1202, 1488,  643, 1557, 1556, 1611,
 /*  2700 */  1053, 1054, 1142,  393, 1202, 1458,  609,  137, 1022, 1121,
 /*  2710 */   443, 1406, 1194, 1339, 1477, 1470, 1468, 1465,  801,  790,
 /*  2720 */  1454,  260, 1371,  594,  865, 1451, 1204,   81,  717,  719,
 /*  2730 */  1405, 1404,  654, 1449, 1448, 1446, 1445, 1443, 1442,   28,
 /*  2740 */   519,  573,  571, 1154,  537,  534, 1395, 1394, 1393, 1387,
 /*  2750 */  1613,  122, 1272, 1286, 1314, 1347, 1342, 1338, 1337, 1336,
 /*  2760 */  1335, 1501, 1334, 1333,  669, 2160, 2161,  849,  509,  478,
 /*  2770 */  1452, 1341, 2148, 2149,  302, 1301, 1299,  479, 1294,  117,
 /*  2780 */  1289, 1287, 1271, 1285, 1273, 1340,  795, 1295, 1489, 1488,
 /*  2790 */  1479, 1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535, 1458,
 /*  2800 */   609,  460, 1209, 1361, 1396, 1406, 1322, 1339, 1477, 1470,
 /*  2810 */  1468, 1465,  742,  790, 1454, 2162,   89,   87, 1032, 1209,
 /*  2820 */  1146, 1147, 1189, 1014,  507, 1009,  302, 1225, 1343,  429,
 /*  2830 */   302, 1386,  850, 1008,  402,  439,  120,   93,  782,  963,
 /*  2840 */   958,  266, 1437,  674,  679,  677, 1405, 1404,  654, 1005,
 /*  2850 */  1211, 1225, 1195, 1209,  953,  507,  603,  606,  604, 1137,
 /*  2860 */   463, 1225, 1155, 1003, 1452, 1341,   66, 1411,   67, 1115,
 /*  2870 */  1436, 1347, 1342, 1338, 1337, 1336, 1335,  198, 1334, 1333,
 /*  2880 */  1038,  727,  269,   76,  923,  489,  538, 1175,  324,  931,
 /*  2890 */   628, 1301, 1299,  465, 1294, 1599,  998,  996,  981,  745,
 /*  2900 */  1489, 1488, 1479, 1557, 1556, 1551, 1550, 1548, 1546, 1536,
 /*  2910 */  1535, 1458,  609, 2070, 1438,  188, 1396, 1406, 1322, 1339,
 /*  2920 */  1477, 1470, 1468, 1465,  801,  790, 1454,  369,  302,  302,
 /*  2930 */  1226,  928, 1225,  245, 2160,  302, 1407, 1027,  717,  719,
 /*  2940 */  1405, 1404,  654,   26,  993,  981,  991,  364,  988,  302,
 /*  2950 */   519,  573,  571, 1192,  537,  534, 1395, 1394, 1393, 1387,
 /*  2960 */  2071,  368, 1272, 1286, 1314, 1347, 1342, 1338, 1337, 1336,
 /*  2970 */  1335,  932, 1334, 1333,   54, 1302, 1452, 1341,  706, 1582,
 /*  2980 */  1012, 2161,  710, 1410,  920, 1301, 1299, 1428, 1294,  150,
 /*  2990 */  1289, 1287, 1271, 1285, 1273,  202,  986,  934,  538, 1304,
 /*  3000 */   982, 2068,  988, 1563,  980,  981,  978,  110, 1225, 2072,
 /*  3010 */   975,  313,  718,  976, 1234, 1488, 2069, 1557, 1556,  971,
 /*  3020 */  1078,  988,  672, 1203,  271, 1458,  609,  111, 1161, 2040,
 /*  3030 */  2162, 1406, 1099, 1339, 1477, 1470, 1468, 1465,  801,  790,
 /*  3040 */  1454, 1162,  302,  949, 2041,  302,  688,  743, 1407,  499,
 /*  3050 */   717,  719, 1405, 1404,  654,  788,  412, 1548,  415,  422,
 /*  3060 */   424,  897,  519,  573,  571,  955,  537,  534, 1395, 1394,
 /*  3070 */  1393, 1387,  291,  222, 1272, 1286, 1314, 1347, 1342, 1338,
 /*  3080 */  1337, 1336, 1335,   26, 1334, 1333,  381,  139,  947,  305,
 /*  3090 */  1452, 1341, 1191,  912,  960,  897,  500, 1301, 1299,  497,
 /*  3100 */  1294,  369, 1289, 1287, 1271, 1285, 1273, 1489, 1488, 1479,
 /*  3110 */  1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535, 1458,  609,
 /*  3120 */   897,  661,  966, 1396, 1406, 1322, 1339, 1477, 1470, 1468,
 /*  3130 */  1465,  801,  790, 1454, 1370, 1368,  959, 1269,  352,  389,
 /*  3140 */  1610,  111,  162,  388, 1251,  234,  759,  786,  861,  910,
 /*  3150 */   559,  743,  989,  990,  111, 1532,  113,  111,  109,  752,
 /*  3160 */  1267,  735,  762,  948, 1352, 1349, 1405, 1404,  601,   77,
 /*  3170 */  1460,   27, 1041, 1040,  114, 1315,  620,  633,  632,  945,
 /*  3180 */  1504,  111, 1547, 1452, 1341, 1547, 1539,  759,  114,  652,
 /*  3190 */   458, 1347, 1342, 1338, 1337, 1336, 1335, 1628, 1334, 1333,
 /*  3200 */  1345, 1346,  830,  204,  353,  538,  217,   80,  876, 1203,
 /*  3210 */   914, 1301, 1299, 1216, 1294, 1000,  997,  627, 1069, 1489,
 /*  3220 */  1488, 1479, 1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535,
 /*  3230 */  1458,  609, 1457,   97,  625, 1396, 1406, 1322, 1339, 1477,
 /*  3240 */  1470, 1468, 1465,  801,  790, 1454,  662,  329,  114, 1098,
 /*  3250 */  1300,  179, 1222,  838,  684, 1407,  642,  717,  719, 1405,
 /*  3260 */  1404,  654,  447, 1439,  258,  651, 1228,  992, 1552,  519,
 /*  3270 */   573,  571, 1267,  537,  534, 1395, 1394, 1393, 1387,  657,
 /*  3280 */  1623, 1272, 1286, 1314, 1347, 1342, 1338, 1337, 1336, 1335,
 /*  3290 */   560, 1334, 1333,  663, 1373, 1452, 1341, 1101, 1453, 1173,
 /*  3300 */  1450,  277,   77, 1103, 1301, 1299,  482, 1294,  484, 1289,
 /*  3310 */  1287, 1271, 1285, 1273, 1264, 1252,  376,  538,  281, 1079,
 /*  3320 */   486,  283,  744, 1110,  737,  983, 1112, 1526,  206, 1528,
 /*  3330 */   325,  893,  979, 1447, 1331, 1488,  972, 1557, 1556,  343,
 /*  3340 */   716,  502,  505, 1257,  504, 1458,  609,  740,  802, 1369,
 /*  3350 */   339, 1406,  317, 1339, 1477, 1470, 1468, 1465,  801,  790,
 /*  3360 */  1454, 1259,  494, 1498,  338, 1621,  831, 1407, 2108,  717,
 /*  3370 */   719, 1405, 1404,  654,  148, 1469, 1444, 1310,  168,  436,
 /*  3380 */    50,  519,  573,  571,  807,  537,  534, 1395, 1394, 1393,
 /*  3390 */  1387, 1305,  656, 1272, 1286, 1314, 1347, 1342, 1338, 1337,
 /*  3400 */  1336, 1335,  432, 1334, 1333,  340, 1306,  473,  753,  332,
 /*  3410 */  1452, 1341, 1459, 1530, 1042,  165, 1301, 1299, 1189, 1294,
 /*  3420 */   890, 1289, 1287, 1271, 1285, 1273, 1264, 1489, 1488, 1479,
 /*  3430 */  1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535, 1458,  609,
 /*  3440 */  1637,  336, 1045, 1396, 1406, 1322, 1339, 1477, 1470, 1468,
 /*  3450 */  1465,  742,  790, 1454,  233, 1529,  866,  496,  793,  259,
 /*  3460 */   580,   51,  700,  974,  306,  789, 1311, 1365,   15,  146,
 /*  3470 */   722,  154,  906, 1503,  905, 1502,  783, 1634,  957,  958,
 /*  3480 */   266,  302,  124, 1531, 1352, 1349, 1405, 1404,  592,  913,
 /*  3490 */   123,  779,  915,  371,   91,  917,  620,  633,  632,   17,
 /*  3500 */   378, 1587,  767, 1452, 1341,  156,   99,  157,  374,  125,
 /*  3510 */   145, 1347, 1342, 1338, 1337, 1336, 1335,  287, 1334, 1333,
 /*  3520 */   189,  771, 1296, 1372,  373,  538, 1323,  969,  414,   88,
 /*  3530 */  1478, 1301, 1299,  249, 1294,   37, 1126, 1362,  464, 1057,
 /*  3540 */   160,  925,  425,  836, 1476,  837, 1489, 1488, 1479, 1557,
 /*  3550 */  1556, 1551, 1550, 1548, 1546, 1536, 1535, 1458,  609,  116,
 /*  3560 */   839, 1196, 1396, 1406, 1322, 1339, 1477, 1470, 1468, 1465,
 /*  3570 */   801,  790, 1454,  806,  133, 1407, 1604,  717,  719, 1405,
 /*  3580 */  1404,  654,  828, 1232, 1471,  861,  869,   67,  508,  519,
 /*  3590 */   573,  571,  184,  537,  534, 1395, 1394, 1393, 1387,  430,
 /*  3600 */   754, 1272, 1286, 1314, 1347, 1342, 1338, 1337, 1336, 1335,
 /*  3610 */  1467, 1334, 1333,  827,  114,  164,   23,  161,  825,    5,
 /*  3620 */   490, 2068, 1452, 1341, 1301, 1299,   19, 1294, 1367, 1289,
 /*  3630 */  1287, 1271, 1285, 1273,  935,  139,  937,  813,  159,  427,
 /*  3640 */   938, 1036,    8,  312,  538, 2098, 1499, 1497, 1475, 1472,
 /*  3650 */  1466, 1464, 1463, 1462, 1461,  824, 2097,   65,  284,  190,
 /*  3660 */    10, 1123,  128, 2069,  152,   39,   75, 1458,  609,  401,
 /*  3670 */   431,  109,    7,  940,   41, 1339, 1477, 1470, 1468, 1465,
 /*  3680 */   801,  582, 1454, 1293,  944, 1119,  796,   82,   98,  872,
 /*  3690 */  1292,  326,  269,  946, 1407,  833,  717,  719, 1405, 1404,
 /*  3700 */   654, 1456,  322,  370, 1288,  423,   22,  321,  519,  573,
 /*  3710 */   571,  952,  537,  534, 1395, 1394, 1393, 1387,   69, 1274,
 /*  3720 */  1272, 1286, 1314, 1347, 1342, 1338, 1337, 1336, 1335,  784,
 /*  3730 */  1334, 1333, 1452, 1341,  956,   16,  330,  163, 2162,   45,
 /*  3740 */   878,  879,  852, 1301, 1299,  320, 1294, 1615, 1289, 1287,
 /*  3750 */  1271, 1285, 1273, 1489, 1488, 1479, 1557, 1556, 1551, 1550,
 /*  3760 */  1548, 1546, 1536, 1535, 1458,  609,   20,  207, 1598, 1396,
 /*  3770 */  1406, 1322, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454,
 /*  3780 */   964, 1089,  106,  397,  635,  965, 1091,  385, 1082,  195,
 /*  3790 */   400,   34, 1090,  967,   90, 1071, 1114, 1270,   95, 1185,
 /*  3800 */  2149, 1062,  774, 2161,  518, 2160, 1290, 1065, 2148,   47,
 /*  3810 */   318,  100,  347, 1265,   78,  395,  118, 1262,  891, 1258,
 /*  3820 */  1256, 1113, 1350,  237, 1626, 1254,  751,  194,  421, 1452,
 /*  3830 */  1341, 1093,  108, 1347, 1342, 1338, 1337, 1336, 1335,  477,
 /*  3840 */  1334, 1333, 1249, 1250, 1402, 1111, 2074,  192,  670,  649,
 /*  3850 */  1572,  538,  761, 1301, 1299,  428, 1294,  351, 1348,  398,
 /*  3860 */  1094,  107,   21,  297,  129, 1489, 1488, 1479, 1557, 1556,
 /*  3870 */  1551, 1550, 1548, 1546, 1536, 1535, 1458,  609,  434, 1109,
 /*  3880 */   728, 1396, 1406, 1322, 1339, 1477, 1470, 1468, 1465,  801,
 /*  3890 */   790, 1454,  275,  230, 2073,  214,  265, 1441, 1190,  399,
 /*  3900 */   408, 1407,  987,  717,  719, 1405, 1404,  654,   70,   46,
 /*  3910 */   712, 1233,  166,  220,  182,  519,  573,  571, 1267,  537,
 /*  3920 */   534, 1395, 1394, 1393, 1387, 1097,  714, 1272, 1286, 1314,
 /*  3930 */  1347, 1342, 1338, 1337, 1336, 1335, 1718, 1334, 1333,  763,
 /*  3940 */    35, 1452, 1341, 1374,  104,  131,  316,   74,  411,  354,
 /*  3950 */  1301, 1299,  605, 1294, 1260, 1289, 1287, 1271, 1285, 1273,
 /*  3960 */  1033,  723,  474,  538, 1108,  244,  105,   53, 1403, 1100,
 /*  3970 */   112, 2041, 1004,  186, 1578,  298, 2040, 1105,   40,  248,
 /*  3980 */    73,   71,  132,  315, 1207,  176, 1376,  304,  232,  290,
 /*  3990 */  1581,  250,  197,   54, 1102, 1413,   12,  699,  291, 1198,
 /*  4000 */   357, 1205, 1197, 1200,  659,  246, 1021, 1018,  308,  102,
 /*  4010 */   199, 2580, 2580, 1407, 2580,  717,  719, 1405, 1404,  654,
 /*  4020 */  2580, 2580, 2580, 2580, 2580, 2580,  692,  519,  573,  571,
 /*  4030 */  2580,  537,  534, 1395, 1394, 1393, 1387, 2580, 2580, 1272,
 /*  4040 */  1286, 1314, 1347, 1342, 1338, 1337, 1336, 1335,  577, 1334,
 /*  4050 */  1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4060 */  2580, 2580, 1301, 1299, 2580, 1294, 2580, 1289, 1287, 1271,
 /*  4070 */  1285, 1273, 1264, 1489, 1488, 1479, 1557, 1556, 1551, 1550,
 /*  4080 */  1548, 1546, 1536, 1535, 1458,  609, 2580,  227, 1203, 1396,
 /*  4090 */  1406, 1322, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454,
 /*  4100 */  2580, 2580, 2580,  260, 2580, 2580, 2580, 1451, 2580, 2580,
 /*  4110 */  2580, 2580, 2580, 2580, 2580, 1449, 1448, 1446, 1445, 1443,
 /*  4120 */  1442, 2580, 2580, 2580, 2580, 2580, 1267, 2580, 2580, 2580,
 /*  4130 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4140 */  2580, 2580,  386,  892,  870, 2580,  228,  226, 2580, 1452,
 /*  4150 */  1341,  900, 1209, 2580,  901,  902,  903,  904, 2580, 2580,
 /*  4160 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4170 */  2580,  538, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4180 */  2580, 2580, 2580, 2580, 2580, 1489, 1488, 1479, 1557, 1556,
 /*  4190 */  1551, 1550, 1548, 1546, 1536, 1535, 1458,  609, 2580, 2580,
 /*  4200 */  2580, 1396, 1406, 1322, 1339, 1477, 1470, 1468, 1465,  801,
 /*  4210 */   790, 1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4220 */  2580, 1407, 2580,  717,  719, 1405, 1404,  654, 2580, 2580,
 /*  4230 */  2580, 2580, 2580, 2580, 2580,  519,  573,  571, 1238,  537,
 /*  4240 */   534, 1395, 1394, 1393, 1387, 2580, 2580, 1272, 1286, 1314,
 /*  4250 */  1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580,
 /*  4260 */  2580, 1452, 1341, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4270 */  1301, 1299, 2580, 1294, 2580, 1289, 1287, 1271, 1285, 1273,
 /*  4280 */  1268, 2580, 2580,  538, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4290 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4300 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4310 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4320 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4330 */  2580, 2580, 2580, 1407, 2580,  717,  719, 1405, 1404,  654,
 /*  4340 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  519,  573,  571,
 /*  4350 */  2580,  537,  534, 1395, 1394, 1393, 1387, 2580, 2580, 1272,
 /*  4360 */  1286, 1314, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334,
 /*  4370 */  1333, 2580, 2580, 2580, 2580, 2580,  564, 2580, 2580, 2580,
 /*  4380 */  2580, 2580, 1301, 1299, 2580, 1294, 2580, 1289, 1287, 1271,
 /*  4390 */  1285, 1273, 1489, 1488, 1479, 1557, 1556, 1551, 1550, 1548,
 /*  4400 */  1546, 1536, 1535, 1458,  609, 2580, 2580, 2580, 1396, 1406,
 /*  4410 */  1322, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 2580,
 /*  4420 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4430 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4440 */  2580, 2580, 2580, 2580, 2580, 1215, 2580, 2580, 2580, 2580,
 /*  4450 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4460 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1452, 1341,
 /*  4470 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4480 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4490 */   538, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4500 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4510 */  2580, 1489, 1488, 1479, 1557, 1556, 1551, 1550, 1548, 1546,
 /*  4520 */  1536, 1535, 1458,  609, 2580, 2580, 2580, 1396, 1406, 1322,
 /*  4530 */  1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 2580, 2580,
 /*  4540 */  1407, 2580,  717,  719, 1405, 1404,  654, 2580, 2580, 2580,
 /*  4550 */  2580, 2580, 2580, 2580,  519,  573,  571, 2580,  537,  534,
 /*  4560 */  1395, 1394, 1393, 1387, 1215, 2580, 1272, 1286, 1314, 1347,
 /*  4570 */  1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580,
 /*  4580 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1452, 1341, 1301,
 /*  4590 */  1299, 2580, 1294, 2580, 1289, 1287, 1271, 1285, 1273, 2580,
 /*  4600 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  538,
 /*  4610 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4620 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4630 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4640 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4650 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1217, 1407,
 /*  4660 */  2580,  717,  719, 1405, 1404,  654, 2580, 2580, 2580, 2580,
 /*  4670 */  2580, 2580, 2580,  519,  573,  571, 2580,  537,  534, 1395,
 /*  4680 */  1394, 1393, 1387, 2580, 2580, 1272, 1286, 1314, 1347, 1342,
 /*  4690 */  1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580, 2580,
 /*  4700 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1301, 1299,
 /*  4710 */  2580, 1294, 2580, 1289, 1287, 1271, 1285, 1273, 1489, 1488,
 /*  4720 */  1479, 1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535, 1458,
 /*  4730 */   609, 2580, 2580, 2580, 1396, 1406, 1322, 1339, 1477, 1470,
 /*  4740 */  1468, 1465,  801,  790, 1454, 2580, 2580, 2580, 2580, 2580,
 /*  4750 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4760 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4770 */  2580,  430, 2580, 2580, 2580, 2580, 2580, 1214, 2580, 2580,
 /*  4780 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4790 */  2580, 2580, 2580, 2580, 1452, 1341, 2580, 2580, 2580, 2580,
 /*  4800 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4810 */  2580, 2580, 2580, 1044, 2580, 2580,  538, 2580, 2580, 2580,
 /*  4820 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4830 */  1489, 1488, 1479, 1557, 1556, 1551, 1550, 1548, 1546, 1536,
 /*  4840 */  1535, 1458,  609, 2580, 2580, 2580, 1396, 1406, 1322, 1339,
 /*  4850 */  1477, 1470, 1468, 1465,  801,  790, 1454, 2580, 2580, 2580,
 /*  4860 */  2580, 2580, 2580, 2580, 2580, 2580, 1407, 2580,  717,  719,
 /*  4870 */  1405, 1404,  654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4880 */   519,  573,  571, 1290,  537,  534, 1395, 1394, 1393, 1387,
 /*  4890 */  2580, 2580, 1272, 1286, 1314, 1347, 1342, 1338, 1337, 1336,
 /*  4900 */  1335, 2580, 1334, 1333, 2580, 2580, 1452, 1341, 2580, 2580,
 /*  4910 */  2580, 2580, 2580, 2580, 2580, 1301, 1299, 2580, 1294, 2580,
 /*  4920 */  1289, 1287, 1271, 1285, 1273, 2580, 2580, 2580,  538, 2580,
 /*  4930 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4940 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4950 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4960 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  4970 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1407, 2580,
 /*  4980 */   717,  719, 1405, 1404,  654, 2580, 2580, 2580, 2580, 2580,
 /*  4990 */  2580, 2580,  519,  573,  571, 2580,  537,  534, 1395, 1394,
 /*  5000 */  1393, 1387, 2580, 2580, 1272, 1286, 1314, 1347, 1342, 1338,
 /*  5010 */  1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580, 2580, 2580,
 /*  5020 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1301, 1299, 2580,
 /*  5030 */  1294, 1291, 1289, 1287, 1271, 1285, 1273, 1489, 1488, 1479,
 /*  5040 */  1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535, 1458,  609,
 /*  5050 */  2580, 2580, 2580, 1396, 1406, 1322, 1339, 1477, 1470, 1468,
 /*  5060 */  1465,  801,  790, 1454, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5070 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5080 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5090 */  1052, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5100 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5110 */  2580, 2580, 2580, 1452, 1341, 2580, 2580, 2580, 2580, 2580,
 /*  5120 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5130 */  2580, 2580, 2580, 2580, 2580,  538, 2580, 2580, 2580, 2580,
 /*  5140 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1489,
 /*  5150 */  1488, 1479, 1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535,
 /*  5160 */  1458,  609, 2580, 2580, 2580, 1396, 1406, 1322, 1339, 1477,
 /*  5170 */  1470, 1468, 1465,  801,  790, 1454, 2580, 2580, 2580, 2580,
 /*  5180 */  2580, 2580, 2580, 2580, 2580, 1407, 2580,  717,  719, 1405,
 /*  5190 */  1404,  654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  519,
 /*  5200 */   573,  571,  880,  537,  534, 1395, 1394, 1393, 1387, 2580,
 /*  5210 */  2580, 1272, 1286, 1314, 1347, 1342, 1338, 1337, 1336, 1335,
 /*  5220 */  2580, 1334, 1333, 2580, 2580, 1452, 1341, 2580, 2580, 2580,
 /*  5230 */  2580, 2580, 2580, 2580, 1301, 1299, 2580, 1294, 2580, 1289,
 /*  5240 */  1287, 1271, 1285, 1273, 2580, 2580, 2580,  538, 2580, 2580,
 /*  5250 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5260 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5270 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5280 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5290 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1407, 2580,  717,
 /*  5300 */   719, 1405, 1404,  654, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5310 */  2580,  519,  573,  571, 2580,  537,  534, 1395, 1394, 1393,
 /*  5320 */  1387, 2580, 2580, 1272, 1286, 1314, 1347, 1342, 1338, 1337,
 /*  5330 */  1336, 1335, 2580, 1334, 1333, 2580, 2580, 2580, 2580, 2580,
 /*  5340 */  2580, 2580, 2580, 2580, 2580, 2580, 1301, 1299, 2580, 1294,
 /*  5350 */  2580, 1289, 1287, 1271, 1285, 1273, 1489, 1488, 1479, 1557,
 /*  5360 */  1556, 1551, 1550, 1548, 1546, 1536, 1535, 1458,  609, 2580,
 /*  5370 */  2580, 2580, 1396, 1406, 1322, 1339, 1477, 1470, 1468, 1465,
 /*  5380 */   801,  790, 1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5390 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5400 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1037,
 /*  5410 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5420 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5430 */  2580, 2580, 1452, 1341, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5440 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5450 */  2580, 2580, 2580, 2580,  538, 2580, 2580, 2580, 2580, 2580,
 /*  5460 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1489, 1488,
 /*  5470 */  1479, 1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535, 1458,
 /*  5480 */   609, 2580, 2580, 2580, 1396, 1406, 1322, 1339, 1477, 1470,
 /*  5490 */  1468, 1465,  801,  790, 1454, 2580, 2580, 2580, 2580, 2580,
 /*  5500 */  2580, 2580, 2580, 2580, 1407, 2580,  717,  719, 1405, 1404,
 /*  5510 */   654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  519,  573,
 /*  5520 */   571, 1055,  537,  534, 1395, 1394, 1393, 1387, 2580, 2580,
 /*  5530 */  1272, 1286, 1314, 1347, 1342, 1338, 1337, 1336, 1335, 2580,
 /*  5540 */  1334, 1333, 2580, 2580, 1452, 1341, 2580, 2580, 2580, 2580,
 /*  5550 */  2580, 2580, 2580, 1301, 1299, 2580, 1294, 2580, 1289, 1287,
 /*  5560 */  1271, 1285, 1273, 2580, 2580, 2580,  538, 2580, 2580, 2580,
 /*  5570 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5580 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5590 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5600 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5610 */  2580, 2580, 2580, 2580, 2580, 2580, 1407, 2580,  717,  719,
 /*  5620 */  1405, 1404,  654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5630 */   519,  573,  571, 2580,  537,  534, 1395, 1394, 1393, 1387,
 /*  5640 */  2580, 2580, 1272, 1286, 1314, 1347, 1342, 1338, 1337, 1336,
 /*  5650 */  1335, 2580, 1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5660 */  2580, 2580, 2580, 2580, 2580, 1301, 1299, 2580, 1294, 2580,
 /*  5670 */  1289, 1287, 1271, 1285, 1273, 1489, 1488, 1479, 1557, 1556,
 /*  5680 */  1551, 1550, 1548, 1546, 1536, 1535, 1458,  609, 2580, 2580,
 /*  5690 */  2580, 1396, 1406, 1322, 1339, 1477, 1470, 1468, 1465,  801,
 /*  5700 */   790, 1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5710 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5720 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1422, 2580,
 /*  5730 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5740 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5750 */  2580, 1452, 1341, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5760 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5770 */  2580, 2580, 2580,  538, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5780 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1489, 1488, 1479,
 /*  5790 */  1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535, 1458,  609,
 /*  5800 */  2580, 2580, 2580, 1396, 1406, 1322, 1339, 1477, 1470, 1468,
 /*  5810 */  1465,  801,  790, 1454, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5820 */  2580, 2580, 2580, 1407, 2580,  717,  719, 1405, 1404,  654,
 /*  5830 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  519,  573,  571,
 /*  5840 */   863,  537,  534, 1395, 1394, 1393, 1387, 2580, 2580, 1272,
 /*  5850 */  1286, 1314, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334,
 /*  5860 */  1333, 2580, 2580, 1452, 1341, 2580, 2580, 2580, 2580, 2580,
 /*  5870 */  2580, 2580, 1301, 1299, 2580, 1294, 2580, 1289, 1287, 1271,
 /*  5880 */  1285, 1273, 2580, 2580, 2580,  538, 2580, 2580, 2580, 2580,
 /*  5890 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5900 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5910 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5920 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5930 */  2580, 2580, 2580, 2580, 2580, 1407, 2580,  717,  719, 1405,
 /*  5940 */  1404,  654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  519,
 /*  5950 */   573,  571, 2580,  537,  534, 1395, 1394, 1393, 1387, 2580,
 /*  5960 */  2580, 1272, 1286, 1314, 1347, 1342, 1338, 1337, 1336, 1335,
 /*  5970 */  2580, 1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  5980 */  2580, 2580, 2580, 2580, 1301, 1299, 2580, 1294, 2580, 1289,
 /*  5990 */  1287, 1271, 1285, 1273, 1489, 1488, 1479, 1557, 1556, 1551,
 /*  6000 */  1550, 1548, 1546, 1536, 1535, 1458,  609, 2580, 2580, 2580,
 /*  6010 */  1396, 1406, 1322, 1339, 1477, 1470, 1468, 1465,  801,  790,
 /*  6020 */  1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6030 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6040 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1242, 2580, 2580,
 /*  6050 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6060 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6070 */  1452, 1341, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6080 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6090 */  2580, 2580,  538, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6100 */  2580, 2580, 2580, 2580, 2580, 2580, 1489, 1488, 1479, 1557,
 /*  6110 */  1556, 1551, 1550, 1548, 1546, 1536, 1535, 1458,  609, 2580,
 /*  6120 */  2580, 2580, 1396, 1406, 1322, 1339, 1477, 1470, 1468, 1465,
 /*  6130 */   801,  790, 1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6140 */  2580, 2580, 1407, 2580,  717,  719, 1405, 1404,  654, 2580,
 /*  6150 */  2580, 2580, 2580, 2580, 2580, 2580,  519,  573,  571,  804,
 /*  6160 */   537,  534, 1395, 1394, 1393, 1387, 2580, 2580, 1272, 1286,
 /*  6170 */  1314, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333,
 /*  6180 */  2580, 2580, 1452, 1341, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6190 */  2580, 1301, 1299, 2580, 1294, 2580, 1289, 1287, 1271, 1285,
 /*  6200 */  1273, 2580, 2580, 2580,  538, 2580, 2580, 2580, 2580, 2580,
 /*  6210 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6220 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6230 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6240 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6250 */  2580, 2580, 2580, 2580, 1407, 2580,  717,  719, 1405, 1404,
 /*  6260 */   654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  519,  573,
 /*  6270 */   571, 2580,  537,  534, 1395, 1394, 1393, 1387, 2580, 2580,
 /*  6280 */  1272, 1286, 1314, 1347, 1342, 1338, 1337, 1336, 1335, 2580,
 /*  6290 */  1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6300 */  2580, 2580, 2580, 1301, 1299, 2580, 1294, 2580, 1289, 1287,
 /*  6310 */  1271, 1285, 1273, 1489, 1488, 1479, 1557, 1556, 1551, 1550,
 /*  6320 */  1548, 1546, 1536, 1535, 1458,  609, 2580, 2580, 2580, 1396,
 /*  6330 */  1406, 1322, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454,
 /*  6340 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6350 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6360 */  2580, 2580, 2580, 2580, 2580, 2580, 1240, 2580, 2580, 2580,
 /*  6370 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6380 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1452,
 /*  6390 */  1341, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6400 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6410 */  2580,  538, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6420 */  2580, 2580, 2580, 2580, 2580, 1489, 1488, 1479, 1557, 1556,
 /*  6430 */  1551, 1550, 1548, 1546, 1536, 1535, 1458,  609, 2580, 2580,
 /*  6440 */  2580, 1396, 1406, 1322, 1339, 1477, 1470, 1468, 1465,  801,
 /*  6450 */   790, 1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6460 */  2580, 1407, 2580,  717,  719, 1405, 1404,  654, 2580, 2580,
 /*  6470 */  2580, 2580, 2580, 2580, 2580,  519,  573,  571, 1193,  537,
 /*  6480 */   534, 1395, 1394, 1393, 1387, 2580, 2580, 1272, 1286, 1314,
 /*  6490 */  1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580,
 /*  6500 */  2580, 1452, 1341, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6510 */  1301, 1299, 2580, 1294, 2580, 1289, 1287, 1271, 1285, 1273,
 /*  6520 */  2580, 2580, 2580,  538, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6530 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6540 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6550 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6560 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6570 */  2580, 2580, 2580, 1407, 2580,  717,  719, 1405, 1404,  654,
 /*  6580 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  519,  573,  571,
 /*  6590 */  2580,  537,  534, 1395, 1394, 1393, 1387, 2580, 2580, 1272,
 /*  6600 */  1286, 1314, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334,
 /*  6610 */  1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6620 */  2580, 2580, 1301, 1299, 2580, 1294, 2580, 1289, 1287, 1271,
 /*  6630 */  1285, 1273, 1489, 1488, 1479, 1557, 1556, 1551, 1550, 1548,
 /*  6640 */  1546, 1536, 1535, 1458,  609, 2580, 2580, 2580, 1396, 1406,
 /*  6650 */  1322, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 2580,
 /*  6660 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6670 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6680 */  2580, 2580, 2580, 2580, 2580, 1237, 2580, 2580, 2580, 2580,
 /*  6690 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6700 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1452, 1341,
 /*  6710 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6720 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6730 */   538, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6740 */  2580, 2580, 2580, 2580, 1489, 1488, 1479, 1557, 1556, 1551,
 /*  6750 */  1550, 1548, 1546, 1536, 1535, 1458,  609, 2580, 2580, 2580,
 /*  6760 */  1396, 1406, 1322, 1339, 1477, 1470, 1468, 1465,  801,  790,
 /*  6770 */  1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6780 */  1407, 2580,  717,  719, 1405, 1404,  654, 2580, 2580, 2580,
 /*  6790 */  2580, 2580, 2580, 2580,  519,  573,  571, 1164,  537,  534,
 /*  6800 */  1395, 1394, 1393, 1387, 2580, 2580, 1272, 1286, 1314, 1347,
 /*  6810 */  1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580,
 /*  6820 */  1452, 1341, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1301,
 /*  6830 */  1299, 2580, 1294, 2580, 1289, 1287, 1271, 1285, 1273, 2580,
 /*  6840 */  2580, 2580,  538, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6850 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6860 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6870 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6880 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6890 */  2580, 2580, 1407, 2580,  717,  719, 1405, 1404,  654, 2580,
 /*  6900 */  2580, 2580, 2580, 2580, 2580, 2580,  519,  573,  571, 2580,
 /*  6910 */   537,  534, 1395, 1394, 1393, 1387, 2580, 2580, 1272, 1286,
 /*  6920 */  1314, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333,
 /*  6930 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6940 */  2580, 1301, 1299, 2580, 1294, 2580, 1289, 1287, 1271, 1285,
 /*  6950 */  1273, 1489, 1488, 1479, 1557, 1556, 1551, 1550, 1548, 1546,
 /*  6960 */  1536, 1535, 1458,  609, 2580, 2580, 2580, 1396, 1406, 1322,
 /*  6970 */  1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 2580, 2580,
 /*  6980 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  6990 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7000 */  2580, 2580, 2580, 2580,  939, 2580, 2580, 2580, 2580, 2580,
 /*  7010 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7020 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1452, 1341, 2580,
 /*  7030 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7040 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  538,
 /*  7050 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7060 */  2580, 2580, 2580, 1489, 1488, 1479, 1557, 1556, 1551, 1550,
 /*  7070 */  1548, 1546, 1536, 1535, 1458,  609, 2580, 2580, 2580, 1396,
 /*  7080 */  1406, 1322, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454,
 /*  7090 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1407,
 /*  7100 */  2580,  717,  719, 1405, 1404,  654, 2580, 2580, 2580, 2580,
 /*  7110 */  2580, 2580, 2580,  519,  573,  571, 1171,  537,  534, 1395,
 /*  7120 */  1394, 1393, 1387, 2580, 2580, 1272, 1286, 1314, 1347, 1342,
 /*  7130 */  1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580, 1452,
 /*  7140 */  1341, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1301, 1299,
 /*  7150 */  2580, 1294, 2580, 1289, 1287, 1271, 1285, 1273, 2580, 2580,
 /*  7160 */  2580,  538, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7170 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7180 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7190 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7200 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7210 */  2580, 1407, 2580,  717,  719, 1405, 1404,  654, 2580, 2580,
 /*  7220 */  2580, 2580, 2580, 2580, 2580,  519,  573,  571, 2580,  537,
 /*  7230 */   534, 1395, 1394, 1393, 1387, 2580, 2580, 1272, 1286, 1314,
 /*  7240 */  1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580,
 /*  7250 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7260 */  1301, 1299, 2580, 1294, 2580, 1289, 1287, 1271, 1285, 1273,
 /*  7270 */  1489, 1488, 1479, 1557, 1556, 1551, 1550, 1548, 1546, 1536,
 /*  7280 */  1535, 1458,  609, 2580, 2580, 2580, 1396, 1406, 1322, 1339,
 /*  7290 */  1477, 1470, 1468, 1465,  801,  790, 1454, 2580, 2580, 2580,
 /*  7300 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7310 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7320 */  2580, 2580, 2580, 1031, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7330 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7340 */  2580, 2580, 2580, 2580, 2580, 2580, 1452, 1341, 2580, 2580,
 /*  7350 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7360 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  538, 2580,
 /*  7370 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7380 */  2580, 2580, 1489, 1488, 1479, 1557, 1556, 1551, 1550, 1548,
 /*  7390 */  1546, 1536, 1535, 1458,  609, 2580, 2580, 2580, 1396, 1406,
 /*  7400 */  1322, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 2580,
 /*  7410 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1407, 2580,
 /*  7420 */   717,  719, 1405, 1404,  654, 2580, 2580, 2580, 2580, 2580,
 /*  7430 */  2580, 2580,  519,  573,  571, 1170,  537,  534, 1395, 1394,
 /*  7440 */  1393, 1387, 2580, 2580, 1272, 1286, 1314, 1347, 1342, 1338,
 /*  7450 */  1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580, 1452, 1341,
 /*  7460 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1301, 1299, 2580,
 /*  7470 */  1294, 2580, 1289, 1287, 1271, 1285, 1273, 2580, 2580, 2580,
 /*  7480 */   538, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7490 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7500 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7510 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7520 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7530 */  1407, 2580,  717,  719, 1405, 1404,  654, 2580, 2580, 2580,
 /*  7540 */  2580, 2580, 2580, 2580,  519,  573,  571, 2580,  537,  534,
 /*  7550 */  1395, 1394, 1393, 1387, 2580, 2580, 1272, 1286, 1314, 1347,
 /*  7560 */  1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580,
 /*  7570 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1301,
 /*  7580 */  1299, 2580, 1294, 2580, 1289, 1287, 1271, 1285, 1273, 1489,
 /*  7590 */  1488, 1479, 1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535,
 /*  7600 */  1458,  609, 2580, 2580, 2580, 1396, 1406, 1322, 1339, 1477,
 /*  7610 */  1470, 1468, 1465,  801,  790, 1454, 2580, 2580, 2580, 2580,
 /*  7620 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7630 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7640 */  2580, 2580, 1163, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7650 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7660 */  2580, 2580, 2580, 2580, 2580, 1452, 1341, 2580, 2580, 2580,
 /*  7670 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7680 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  538, 2580, 2580,
 /*  7690 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7700 */  2580, 1489, 1488, 1479, 1557, 1556, 1551, 1550, 1548, 1546,
 /*  7710 */  1536, 1535, 1458,  609, 2580, 2580, 2580, 1396, 1406, 1322,
 /*  7720 */  1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 2580, 2580,
 /*  7730 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1407, 2580,  717,
 /*  7740 */   719, 1405, 1404,  654, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7750 */  2580,  519,  573,  571,  764,  537,  534, 1395, 1394, 1393,
 /*  7760 */  1387, 2580, 2580, 1272, 1286, 1314, 1347, 1342, 1338, 1337,
 /*  7770 */  1336, 1335, 2580, 1334, 1333, 2580, 2580, 1452, 1341, 2580,
 /*  7780 */  2580, 2580, 2580, 2580, 2580, 2580, 1301, 1299, 2580, 1294,
 /*  7790 */  2580, 1289, 1287, 1271, 1285, 1273, 2580, 2580, 2580,  538,
 /*  7800 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7810 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7820 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7830 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7840 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1407,
 /*  7850 */  2580,  717,  719, 1405, 1404,  654, 2580, 2580, 2580, 2580,
 /*  7860 */  2580, 2580, 2580,  519,  573,  571, 2580,  537,  534, 1395,
 /*  7870 */  1394, 1393, 1387, 2580, 2580, 1272, 1286, 1314, 1347, 1342,
 /*  7880 */  1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580, 2580,
 /*  7890 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1301, 1299,
 /*  7900 */  2580, 1294, 2580, 1289, 1287, 1271, 1285, 1273, 1489, 1488,
 /*  7910 */  1479, 1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535, 1458,
 /*  7920 */   609, 2580, 2580, 2580, 1396, 1406, 1322, 1339, 1477, 1470,
 /*  7930 */  1468, 1465,  801,  790, 1454, 2580, 2580, 2580, 2580, 2580,
 /*  7940 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7950 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7960 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7970 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  7980 */  2580, 2580, 2580, 2580, 1452, 1341, 2580, 2580, 2580, 2580,
 /*  7990 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  8000 */  2580, 2580, 2580, 2580, 2580, 2580,  538, 2580, 2580, 2580,
 /*  8010 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  704,
 /*  8020 */  1489, 1488, 1479, 1557, 1556, 1551, 1550, 1548, 1546, 1536,
 /*  8030 */  1535, 1458,  609, 2580, 2580, 2580, 1396, 1406, 1322, 1339,
 /*  8040 */  1477, 1470, 1468, 1465,  801,  790, 1454, 2580, 2580, 2580,
 /*  8050 */  2580, 2580, 2580, 2580, 2580, 2580, 1204, 2580,  717,  719,
 /*  8060 */  1405, 1404,  654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  8070 */   519,  573,  571, 1169,  537,  534, 1395, 1394, 1393, 1387,
 /*  8080 */  2580, 2580, 1272, 1286, 1314, 1347, 1342, 1338, 1337, 1336,
 /*  8090 */  1335, 2580, 1334, 1333, 2580, 2580, 1452, 1341, 2580, 2580,
 /*  8100 */  2580, 2580, 2580, 2580, 2580, 1301, 1299, 2580, 1294, 2580,
 /*  8110 */  1289, 1287, 1271, 1285, 1273, 2580, 2580, 2580,  538, 2580,
 /*  8120 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  8130 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  8140 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  8150 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  8160 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1407, 2580,
 /*  8170 */   717,  719, 1405, 1404,  654, 2580, 2580, 2580, 2580, 2580,
 /*  8180 */  2580, 2580,  519,  573,  571, 2580,  537,  534, 1395, 1394,
 /*  8190 */  1393, 1387, 2580, 2580, 1272, 1286, 1314, 1347, 1342, 1338,
 /*  8200 */  1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580, 2580, 2580,
 /*  8210 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1301, 1299, 2580,
 /*  8220 */  1294, 2580, 1289, 1287, 1271, 1285, 1273, 1489, 1488, 1479,
 /*  8230 */  1557, 1556, 1551, 1550, 1548, 1546, 1536, 1535, 1458,  609,
 /*  8240 */  2580, 2580, 2580, 1396, 1406, 1322, 1339, 1477, 1470, 1468,
 /*  8250 */  1465,  801,  790, 1454, 2580, 2580, 2580, 2580,   86,   85,
 /*  8260 */  2580, 2580, 2580, 2580, 1554, 1553, 1552, 1547, 1539,  873,
 /*  8270 */   868, 1499, 1497, 1475, 1472, 1466, 1464, 1463, 1462, 1461,
 /*  8280 */   658, 2580, 1261, 2580, 2580, 2580, 2580,    3, 2580, 2580,
 /*  8290 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  8300 */  2580, 2580, 2580, 1452, 1341, 2580, 2580, 2580, 2580, 2580,
 /*  8310 */  2580, 2580, 2580, 2580,  872, 2580, 2580, 2580, 2580, 2580,
 /*  8320 */   833, 2580, 2580, 2580, 2580,  538, 2580, 2580, 2580, 2580,
 /*  8330 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  663, 2580, 2580,
 /*  8340 */  2580, 2580, 2580,  683, 2580,  667, 2580,  854,  882, 2580,
 /*  8350 */  2580,  636,  626,  621,  784,  770,  724,  734, 1313, 1312,
 /*  8360 */    16, 2580, 2580, 2580, 2580,  878,  879,  852,  775, 2580,
 /*  8370 */  2580, 2580, 2580, 2580, 2580, 1407, 2580,  717,  719, 1405,
 /*  8380 */  1404,  654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  519,
 /*  8390 */   573,  571, 2580,  537,  534, 1395, 1394, 1393, 1387, 2580,
 /*  8400 */  2580, 1272, 1286, 1314, 1347, 1342, 1338, 1337, 1336, 1335,
 /*  8410 */  2580, 1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  8420 */  2580, 2580, 2580, 2580, 1301, 1299, 2580, 1294, 2580, 1289,
 /*  8430 */  1287, 1271, 1285, 1273, 2579,   55, 1646, 1642, 1641, 1640,
 /*  8440 */  1639, 1636, 1633, 1632, 1631, 1630, 1629, 1627, 1625, 1624,
 /*  8450 */  1622, 1620, 1619, 1618, 1617, 1616, 1614, 1603, 1602, 1601,
 /*  8460 */  1600, 1597, 1596, 1595, 1594, 1589, 1588, 1586, 1585, 1584,
 /*  8470 */  1583, 1580, 1579, 1577, 1576, 1575, 1574, 1573, 1571, 1570,
 /*  8480 */  1569, 1568, 1567, 1566, 1564, 1562, 2580, 2580, 2580, 2580,
 /*  8490 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  8500 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  8510 */  2580, 2580, 2580, 2580,  260, 2580, 2580, 2580, 1451, 2580,
 /*  8520 */  2580, 2580, 2580, 2580, 2580, 2580, 1449, 1448, 1446, 1445,
 /*  8530 */  1443, 1442, 2580, 2580, 2580, 2580, 1489, 1488, 1479, 1557,
 /*  8540 */  1556, 1551, 1550, 1548, 1546, 1536, 1535, 1458,  609, 2580,
 /*  8550 */  2580, 2580, 1396, 1406, 1322, 1339, 1477, 1470, 1468, 1465,
 /*  8560 */   801,  790, 1454, 2580,   86,   85, 2580, 2580, 2580, 2580,
 /*  8570 */  1554, 1553, 1552, 1547, 1539,  873,  868, 1499, 1497, 1475,
 /*  8580 */  1472, 1466, 1464, 1463, 1462, 1461, 2580, 2580, 2580, 1408,
 /*  8590 */  2580, 2580, 2580,    3,  768, 2580, 2580, 2580, 2580, 2580,
 /*  8600 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  8610 */  2580, 2580, 1452, 1341, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  8620 */   872, 2580, 2580, 2580, 2580, 2580,  833, 2580, 2580, 2580,
 /*  8630 */  2580, 2580, 2580, 2580,  538, 2580, 2580, 2580, 2580, 2580,
 /*  8640 */  2580, 2580, 2580,  663, 2580, 2580, 2580, 2580, 2580,  683,
 /*  8650 */  2580,  667, 2580,  854,  882, 2580, 2580,  636,  626,  621,
 /*  8660 */   784,  770,  724,  734, 1313, 1312,   16, 2580, 2580, 2580,
 /*  8670 */  2580,  878,  879,  852,  775, 2580, 2580, 2580, 2580, 2580,
 /*  8680 */  2580, 2580, 2580, 2580, 1407, 2580,  717,  719, 1405, 1404,
 /*  8690 */   654, 2580, 2580, 2580, 2580,  253, 2580,  300,  519,  573,
 /*  8700 */   571, 2580,  537,  534, 1395, 1394, 1393, 1387, 2580, 2580,
 /*  8710 */  1272, 1286, 1314, 1347, 1342, 1338, 1337, 1336, 1335, 2580,
 /*  8720 */  1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  8730 */  2580, 2580, 2580, 1301, 1299, 2580, 1294, 2580, 1289, 1287,
 /*  8740 */  1271, 1285, 1273, 1489, 1488, 1479, 1557, 1556, 1551, 1550,
 /*  8750 */  1548, 1546, 1536, 1535, 1458,  609, 2580, 2580, 2580, 1396,
 /*  8760 */  1406, 1322, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454,
 /*  8770 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  8780 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  8790 */  2580, 2580, 1489, 2580, 2580, 2580, 1172, 1551, 1550, 1548,
 /*  8800 */  1546, 2580, 2580, 1458,  609, 2580, 2580, 2580, 1396, 2580,
 /*  8810 */  2580, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 1452,
 /*  8820 */  1341, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  8830 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  8840 */  2580,  538, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  8850 */  2580, 2580, 2580, 2580, 2580, 1489, 1488, 1479, 1557, 1556,
 /*  8860 */  1551, 1550, 1548, 1546, 1536, 1535, 1458,  609, 1452, 1341,
 /*  8870 */  2580, 1396, 1406, 1322, 1339, 1477, 1470, 1468, 1465,  801,
 /*  8880 */   790, 1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  8890 */   528, 1407, 2580,  717,  719, 1405, 1404,  654, 2580, 2580,
 /*  8900 */  2580, 2580, 2580, 2580, 2580,  519,  573,  571, 1167,  537,
 /*  8910 */   534, 1395, 1394, 1393, 1387, 2580, 2580, 1272, 1286, 1314,
 /*  8920 */  1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580,
 /*  8930 */  2580, 1452, 1341, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  8940 */  1301, 1299, 2580, 1294, 2580, 1289, 1287, 1271, 1285, 1273,
 /*  8950 */  2580, 2580, 2580,  538,  777, 1258, 1256, 2580, 1326, 1325,
 /*  8960 */  1395, 1394, 1393, 1387, 2580, 2580, 2580, 2580, 2580, 1347,
 /*  8970 */  1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580,
 /*  8980 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1301,
 /*  8990 */  1299, 2580, 1294, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9000 */  2580, 2580, 2580, 1407, 2580,  717,  719, 1405, 1404,  654,
 /*  9010 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  519,  573,  571,
 /*  9020 */  2580,  537,  534, 1395, 1394, 1393, 1387, 2580, 2580, 1272,
 /*  9030 */  1286, 1314, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334,
 /*  9040 */  1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9050 */  2580, 2580, 1301, 1299, 2580, 1294, 2580, 1289, 1287, 1271,
 /*  9060 */  1285, 1273, 1489, 1488, 1479, 1557, 1556, 1551, 1550, 1548,
 /*  9070 */  1546, 1536, 1535, 1458,  609, 2580, 2580, 2580, 1396, 1406,
 /*  9080 */  1322, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 2580,
 /*  9090 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9100 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9110 */  2580, 1489, 2580, 2580, 2580, 2580, 1551, 1550, 1548, 1546,
 /*  9120 */  2580, 2580, 1458,  609, 2580, 2580, 2580, 1396, 2580, 2580,
 /*  9130 */  1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 1452, 1341,
 /*  9140 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9150 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9160 */   538, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9170 */  2580, 2580, 2580, 2580, 1489, 1488, 1479, 1557, 1556, 1551,
 /*  9180 */  1550, 1548, 1546, 1536, 1535, 1458,  609, 1452, 1341, 2580,
 /*  9190 */  1396, 1406, 1322, 1339, 1477, 1470, 1468, 1465,  801,  790,
 /*  9200 */  1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  546,
 /*  9210 */  1206, 2580,  717,  719, 1405, 1404,  654, 2580, 2580, 2580,
 /*  9220 */  2580, 2580, 2580, 2580,  519,  573,  571, 2580,  537,  534,
 /*  9230 */  1395, 1394, 1393, 1387, 2580, 2580, 1272, 1286, 1314, 1347,
 /*  9240 */  1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580,
 /*  9250 */  1452, 1341, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1301,
 /*  9260 */  1299, 2580, 1294, 2580, 1289, 1287, 1271, 1285, 1273, 2580,
 /*  9270 */  2580, 2580,  538,  777, 1258, 1256, 2580, 1326, 1325, 1395,
 /*  9280 */  1394, 1393, 1387, 2580, 2580, 2580, 2580, 2580, 1347, 1342,
 /*  9290 */  1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580, 2580,
 /*  9300 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1301, 1299,
 /*  9310 */  2580, 1294, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9320 */  2580, 2580, 1034, 2580,  717,  719, 1405, 1404,  654, 2580,
 /*  9330 */  2580, 2580, 2580, 2580, 2580, 2580,  519,  573,  571, 2580,
 /*  9340 */   537,  534, 1395, 1394, 1393, 1387, 2580, 2580, 1272, 1286,
 /*  9350 */  1314, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333,
 /*  9360 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9370 */  2580, 1301, 1299, 2580, 1294, 2580, 1289, 1287, 1271, 1285,
 /*  9380 */  1273, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9390 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9400 */  2580, 2580, 2580, 2580, 2580, 2580, 1644, 1642, 1641, 1640,
 /*  9410 */  1639, 1636, 1633, 1632, 1631, 1630, 1629, 1627, 1625, 1624,
 /*  9420 */  1622, 1620, 1619, 1618, 1617, 1616, 1614, 1603, 1602, 1601,
 /*  9430 */  1600, 1597, 1596, 1595, 1594, 1589, 1588, 1586, 1585, 1584,
 /*  9440 */  1583, 1580, 1579, 1577, 1576, 1575, 1574, 1573, 1571, 1570,
 /*  9450 */  1569, 1568, 1567, 1566, 1564, 1562, 2580, 2580, 2580, 2580,
 /*  9460 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9470 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9480 */  2580, 2580, 2580, 2580,  260, 2580, 2580, 2580, 1451, 2580,
 /*  9490 */  2580, 2580, 2580, 2580, 2580, 2580, 1449, 1448, 1446, 1445,
 /*  9500 */  1443, 1442, 2580, 2580, 1645, 1642, 1641, 1640, 1639, 1636,
 /*  9510 */  1633, 1632, 1631, 1630, 1629, 1627, 1625, 1624, 1622, 1620,
 /*  9520 */  1619, 1618, 1617, 1616, 1614, 1603, 1602, 1601, 1600, 1597,
 /*  9530 */  1596, 1595, 1594, 1589, 1588, 1586, 1585, 1584, 1583, 1580,
 /*  9540 */  1579, 1577, 1576, 1575, 1574, 1573, 1571, 1570, 1569, 1568,
 /*  9550 */  1567, 1566, 1564, 1562, 1554, 1553, 1552, 2580, 2580, 2580,
 /*  9560 */  2580, 1499, 1497, 1475, 1472, 1466, 1464, 1463, 1462, 1461,
 /*  9570 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,   61, 2580, 2580,
 /*  9580 */  2580, 2580,  260, 2580, 2580, 2580, 1451, 2580, 2580, 2580,
 /*  9590 */  2580, 2580, 2580, 2580, 1449, 1448, 1446, 1445, 1443, 1442,
 /*  9600 */  2580, 2580, 2580, 2580,  872, 2580, 2580,  760, 2580,  803,
 /*  9610 */   696,  681,  668,  660,  348,  350,  772,  750,  741,  726,
 /*  9620 */   720, 2580,   98, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9630 */  2580, 2580, 2580,  683, 2580,  667, 2580,  854,  882, 2580,
 /*  9640 */  2580, 2580, 2580, 2580,  784, 2580, 2580, 2580, 2580, 2580,
 /*  9650 */    16, 2580, 2580, 2580, 2580,  878,  879,  852, 1488, 2580,
 /*  9660 */  1557, 1556, 2580, 2580, 2580,  253, 2580,  300, 1458,  609,
 /*  9670 */  2580, 2580, 2580, 2580, 1406, 2580, 1339, 1477, 1470, 1468,
 /*  9680 */  1465,  801,  790, 1454,  260, 2580, 2580, 2580, 1451, 2580,
 /*  9690 */  2580, 2580, 2580, 2580, 2580, 2580, 1449, 1448, 1446, 1445,
 /*  9700 */  1443, 1442, 2580, 2580, 2580, 2580, 1499, 1497, 1475, 1472,
 /*  9710 */  1466, 1464, 1463, 1462, 1461, 2580, 2580, 2580, 2580, 2580,
 /*  9720 */  2580, 2580,  127, 2580,  420, 2580, 2580, 2580, 2580, 2580,
 /*  9730 */  2580, 2580, 2580, 1452, 1341, 2580, 2580, 2580, 2580, 2580,
 /*  9740 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  872,
 /*  9750 */  2580, 2580, 2580, 2580, 2580,  833, 2580, 2580, 2580, 2580,
 /*  9760 */  2580, 2580, 2580,  253, 2580,  300, 2580, 2580, 2580,  491,
 /*  9770 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9780 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  390,  784,
 /*  9790 */  1127, 2580, 1120, 2580, 2580,   16, 2580,  692, 1125, 2580,
 /*  9800 */   878,  879,  852, 1116,   38,  279,  674,  617,  616, 1405,
 /*  9810 */  1404,  654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  549,
 /*  9820 */   606,  604, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9830 */  2580, 2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335,
 /*  9840 */  2580, 1334, 1333, 2580, 2580, 2580, 2580, 2580, 1488, 2580,
 /*  9850 */  1557, 1556, 2580,  628, 1301, 1299, 2580, 1294, 1458,  609,
 /*  9860 */  2580, 2580, 2580, 2580, 1406, 2580, 1339, 1477, 1470, 1468,
 /*  9870 */  1465,  801,  790, 1454,  260, 2580, 2580, 2580, 1451, 2580,
 /*  9880 */  2580, 2580, 2580, 2580, 2580, 2580, 1449, 1448, 1446, 1445,
 /*  9890 */  1443, 1442, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9900 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9910 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9920 */  2580, 2580, 2580, 1452, 1341, 2580, 2580, 2580, 2580, 2580,
 /*  9930 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9940 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9950 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  491,
 /*  9960 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /*  9970 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  390, 2580,
 /*  9980 */  1127, 2580, 1120, 2580, 2580, 2580, 2580, 2580, 1125, 2580,
 /*  9990 */  2580, 2580, 2580, 1116, 2580, 2580,  674,  617,  616, 1405,
 /* 10000 */  1404,  654,  692, 2580, 2580, 2580, 2580, 2580, 2580,  549,
 /* 10010 */   606,  604, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10020 */  2580, 2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335,
 /* 10030 */  2580, 1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10040 */  2580, 2580, 2580,  628, 1301, 1299, 2580, 1294, 2580, 2580,
 /* 10050 */  2580, 2580, 1489, 2580, 2580, 2580, 2580, 1551, 1550, 1548,
 /* 10060 */  1546, 2580, 2580, 1458,  609, 2580, 2580, 2580, 1396, 2580,
 /* 10070 */  2580, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454,  260,
 /* 10080 */  2580, 2580, 2580, 1451, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10090 */  2580, 1449, 1448, 1446, 1445, 1443, 1442, 2580, 2580, 2580,
 /* 10100 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10110 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  760, 2580, 2580,
 /* 10120 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1452, 1341,
 /* 10130 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10140 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10150 */   538, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10160 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1489, 2580, 2580,
 /* 10170 */  2580, 2580, 1551, 1550, 1548, 1546, 2580, 2580, 1458,  609,
 /* 10180 */  2580, 2580, 2580, 1396, 2580, 2580, 1339, 1477, 1470, 1468,
 /* 10190 */  1465,  801,  790, 1454,  260, 2580, 2580, 2580, 1451, 2580,
 /* 10200 */  2580, 2580, 2580, 2580, 2580, 2580, 1449, 1448, 1446, 1445,
 /* 10210 */  1443, 1442, 2580, 2580,  599,  634,  629,  645,  655,  646,
 /* 10220 */  1395, 1394, 1393, 1387, 2580, 2580, 2580, 2580,  760, 1347,
 /* 10230 */  1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580,
 /* 10240 */  2580, 2580, 2580, 1452, 1341, 2580, 2580, 2580,  628, 1301,
 /* 10250 */  1299, 2580, 1294, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10260 */  2580, 2580, 2580, 2580, 2580,  538, 2580, 2580, 2580, 2580,
 /* 10270 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1488,
 /* 10280 */  2580, 1557, 1556, 2580, 2580, 2580, 2580, 2580, 2580, 1458,
 /* 10290 */   609, 2580, 2580, 2580, 2580, 1406, 2580, 1339, 1477, 1470,
 /* 10300 */  1468, 1465,  801,  790, 1454,  260, 2580, 2580, 2580, 1451,
 /* 10310 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1449, 1448, 1446,
 /* 10320 */  1445, 1443, 1442, 2580, 2580, 2580, 2580, 2580, 2580,  599,
 /* 10330 */   634,  629,  645,  655,  646, 1395, 1394, 1393, 1387, 2580,
 /* 10340 */  2580, 2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335,
 /* 10350 */  2580, 1334, 1333, 2580, 1452, 1341, 2580, 2580, 2580, 2580,
 /* 10360 */  2580, 2580, 2580,  628, 1301, 1299, 2580, 1294, 2580, 2580,
 /* 10370 */  2580,   11, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10380 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10390 */  2580, 2580,   86,   85, 2580, 2580, 2580, 2580, 1554, 1553,
 /* 10400 */  1552, 1547, 1539,  873,  868, 1499, 1497, 1475, 1472, 1466,
 /* 10410 */  1464, 1463, 1462, 1461, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10420 */  2580,    2, 2580,  420, 2580, 2580, 2580,  674,  679,  677,
 /* 10430 */  1405, 1404,  654, 2580, 2580,  362, 2580, 2580, 2580, 2580,
 /* 10440 */   603,  606,  604, 2580, 2580, 2580, 2580, 2580,  872, 2580,
 /* 10450 */  2580, 2580, 2580, 2580,  833, 1347, 1342, 1338, 1337, 1336,
 /* 10460 */  1335, 2580, 1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10470 */  2580,  663, 2580, 2580,  628, 1301, 1299,  683, 1294,  667,
 /* 10480 */  2580,  854,  882, 2580, 2580,  636,  626,  621,  784,  770,
 /* 10490 */   724,  734, 1313, 1312,   16,   11, 2580, 2580, 2580,  878,
 /* 10500 */   879,  852,  775,   38,  279, 2580, 2580, 2580, 2580, 2580,
 /* 10510 */  2580, 2580, 2580, 2580, 2580, 2580,   86,   85, 2580, 2580,
 /* 10520 */  2580, 2580, 1554, 1553, 1552, 1547, 1539,  873,  868, 1499,
 /* 10530 */  1497, 1475, 1472, 1466, 1464, 1463, 1462, 1461, 2580, 2580,
 /* 10540 */  2580, 2580, 2580, 2580, 2580,    1, 2580, 2580, 2580, 2580,
 /* 10550 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  362,
 /* 10560 */  2580, 2580, 2580, 1488, 2580, 1557, 1556, 2580, 2580, 2580,
 /* 10570 */  2580, 2580,  872, 1458,  609, 2580, 2580, 2580,  833, 1406,
 /* 10580 */  2580, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 2580,
 /* 10590 */  2580, 2580, 2580, 2580, 2580,  663, 2580, 2580, 2580, 2580,
 /* 10600 */  2580,  683, 2580,  667, 2580,  854,  882, 2580, 2580,  636,
 /* 10610 */   626,  621,  784,  770,  724,  734, 1313, 1312,   16, 2580,
 /* 10620 */  2580, 2580, 2580,  878,  879,  852,  775, 2580, 2580, 2580,
 /* 10630 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1452, 1341,
 /* 10640 */  2580, 2580, 1488, 2580, 1557, 1556, 2580, 2580, 2580, 2580,
 /* 10650 */  2580, 2580, 1458,  609, 2580, 2580, 2580, 2580, 1406, 2580,
 /* 10660 */  1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 2580, 2580,
 /* 10670 */  2580, 2580, 2580, 2580,  491, 2580, 2580, 2580, 2580, 2580,
 /* 10680 */   511, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10690 */  2580, 2580, 2580,  555, 2580, 1127, 2580, 1120, 2580, 2580,
 /* 10700 */  2580, 2580, 2580, 1125, 2580, 2580, 2580, 2580, 1116, 2580,
 /* 10710 */  2580, 2580,  819,  805, 1405, 1404,  654, 1452, 1341, 2580,
 /* 10720 */  2580, 2580, 2580, 2580,  566,  633,  632, 2580, 2580, 2580,
 /* 10730 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1347,
 /* 10740 */  1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580,
 /* 10750 */  2580, 2580, 2580,  491, 2580, 2580, 2580, 2580, 2580, 1301,
 /* 10760 */  1299, 2580, 1294, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10770 */  2580, 2580,  829, 2580, 1127, 2580, 1120, 2580, 2580, 2580,
 /* 10780 */  2580, 2580, 1125, 2580, 2580, 2580, 2580, 1116, 2580, 2580,
 /* 10790 */  2580,  819,  805, 1405, 1404,  654, 2580, 2580, 2580, 2580,
 /* 10800 */  2580, 2580, 2580,  566,  633,  632, 2580, 2580, 2580, 2580,
 /* 10810 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1347, 1342,
 /* 10820 */  1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580, 2580,
 /* 10830 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1301, 1299,
 /* 10840 */  2580, 1294, 1488, 2580, 1557, 1556, 2580, 2580, 2580, 2580,
 /* 10850 */  2580, 2580, 1458,  609, 2580, 2580, 2580, 2580, 1406, 2580,
 /* 10860 */  1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 2580, 2580,
 /* 10870 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10880 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10890 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10900 */  2580, 2580, 2580, 1488, 2580, 1557, 1556, 2580, 2580, 2580,
 /* 10910 */  2580, 2580, 2580, 1458,  609, 2580, 2580, 1452, 1341, 1406,
 /* 10920 */  2580, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 2580,
 /* 10930 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10940 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10950 */  2580, 2580, 2580,  491, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10960 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 10970 */  2580, 2580,  820, 2580, 1127, 2580, 1120, 2580, 1452, 1341,
 /* 10980 */  2580, 2580, 1125, 2580, 2580, 2580, 2580, 1116, 2580, 2580,
 /* 10990 */  2580,  819,  805, 1405, 1404,  654, 2580, 2580, 2580, 2580,
 /* 11000 */  2580, 2580, 2580,  566,  633,  632, 2580, 2580, 2580, 2580,
 /* 11010 */  2580, 2580, 2580, 2580,  491, 2580, 2580, 2580, 1347, 1342,
 /* 11020 */  1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580, 2580,
 /* 11030 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1120, 1301, 1299,
 /* 11040 */  2580, 1294, 2580, 1095, 2580, 2580,  475, 2580, 1116, 1092,
 /* 11050 */  2580, 2580,  819,  805, 1405, 1404,  654, 2580, 2580, 2580,
 /* 11060 */  2580, 2580, 2580, 2580,  566,  633,  632, 2580, 2580, 2580,
 /* 11070 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1347,
 /* 11080 */  1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580,
 /* 11090 */  2580, 2580, 2580, 2580, 1488, 2580, 1557, 1556, 2580, 1301,
 /* 11100 */  1299, 2580, 1294, 2580, 1458,  609, 2580, 2580, 2580, 2580,
 /* 11110 */  1406, 2580, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454,
 /* 11120 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11130 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11140 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11150 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11160 */  2580, 2580, 2580, 2580, 2580, 1488, 2580, 1557, 1556, 1452,
 /* 11170 */  1341, 2580, 2580, 2580, 2580, 1458,  609, 2580, 2580, 2580,
 /* 11180 */  2580, 1406, 2580, 1339, 1477, 1470, 1468, 1465,  801,  790,
 /* 11190 */  1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11200 */  2580, 2580, 2580, 2580, 2580,  491, 2580, 2580, 2580, 2580,
 /* 11210 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11220 */  2580, 2580, 2580, 2580,  585, 2580, 1127, 2580, 1120, 2580,
 /* 11230 */  2580, 2580, 2580, 2580, 1125, 2580, 2580, 2580, 2580, 1116,
 /* 11240 */  1452, 1341, 2580,  819,  805, 1405, 1404,  654, 2580, 2580,
 /* 11250 */  2580, 2580, 2580, 2580, 2580,  566,  633,  632, 2580, 2580,
 /* 11260 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11270 */  1347, 1342, 1338, 1337, 1336, 1335,  491, 1334, 1333, 2580,
 /* 11280 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11290 */  1301, 1299, 2580, 1294, 2580,  391, 2580, 1127, 2580, 1120,
 /* 11300 */  2580, 2580, 2580, 2580, 2580, 1125, 2580, 2580, 2580, 2580,
 /* 11310 */  1116, 2580, 2580, 2580,  819,  805, 1405, 1404,  654, 2580,
 /* 11320 */  2580, 2580, 2580, 2580, 2580, 2580,  566,  633,  632, 2580,
 /* 11330 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11340 */  2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333,
 /* 11350 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11360 */  2580, 1301, 1299, 2580, 1294,   86,   85, 2580, 2580, 2580,
 /* 11370 */  2580, 1554, 1553, 1552, 1547, 1539,  873,  868, 1499, 1497,
 /* 11380 */  1475, 1472, 1466, 1464, 1463, 1462, 1461, 2580, 2580, 2580,
 /* 11390 */  2580, 2580, 2580, 2580,    3, 2580, 2580, 2580, 2580, 2580,
 /* 11400 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11410 */  2580, 2580, 2580, 2580, 1488, 2580, 1557, 1556, 2580, 2580,
 /* 11420 */  2580,  872, 2580, 2580, 1458,  609, 2580,  833, 2580, 2580,
 /* 11430 */  1406, 2580, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454,
 /* 11440 */  2580, 2580, 2580, 2580,  663, 2580, 2580, 2580, 2580, 2580,
 /* 11450 */   683, 2580,  667, 2580,  854,  882, 2580, 2580,  636,  626,
 /* 11460 */   621,  784,  770,  724,  734, 1313, 1312,   16, 2580, 2580,
 /* 11470 */  2580, 2580,  878,  879,  852,  775, 2580, 2580, 2580, 2580,
 /* 11480 */  2580, 2580, 2580, 2580, 2580, 1488, 2580, 1557, 1556, 1452,
 /* 11490 */  1341, 2580, 2580, 2580, 2580, 1458,  609, 2580, 2580, 2580,
 /* 11500 */  2580, 1406, 2580, 1339, 1477, 1470, 1468, 1465,  801,  790,
 /* 11510 */  1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11520 */  2580, 2580, 2580, 2580, 2580,  491, 2580, 2580, 2580, 2580,
 /* 11530 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11540 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1120, 2580,
 /* 11550 */  2580, 2580, 2580, 2580,   72,   64, 2580, 2580, 2580, 1116,
 /* 11560 */  1452, 1341, 2580,  819,  805, 1405, 1404,  654, 2580, 2580,
 /* 11570 */  2580, 2580, 2580, 2580, 2580,  566,  633,  632, 2580, 2580,
 /* 11580 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11590 */  1347, 1342, 1338, 1337, 1336, 1335,  491, 1334, 1333, 2580,
 /* 11600 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11610 */  1301, 1299, 2580, 1294, 2580, 2580,  583, 2580,  970,  191,
 /* 11620 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11630 */  1116, 2580, 2580, 2580,  819,  805, 1405, 1404,  654, 2580,
 /* 11640 */  2580, 2580, 2580, 2580, 2580, 2580,  566,  633,  632, 2580,
 /* 11650 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11660 */  2580, 1347, 1342, 1338, 1337, 1336, 1335, 1489, 1334, 1333,
 /* 11670 */  2580, 2580, 1551, 1550, 1548, 1546, 2580, 2580, 1458,  609,
 /* 11680 */  2580, 1301, 1299, 1396, 1294, 2580, 1339, 1477, 1470, 1468,
 /* 11690 */  1465,  801,  790, 1454, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11700 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11710 */  2580, 2580, 2580, 1489, 2580, 2580, 2580, 2580, 1551, 1550,
 /* 11720 */  1548, 1546, 2580, 2580, 1458,  609, 2580, 2580, 2580, 1396,
 /* 11730 */  2580, 2580, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454,
 /* 11740 */  2580, 2580, 2580, 1452, 1341, 2580, 2580, 2580, 2580, 2580,
 /* 11750 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11760 */  2580, 2580, 2580, 2580, 2580,  525, 2580, 2580, 2580, 2580,
 /* 11770 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11780 */  1489, 2580, 2580, 2580, 2580, 1551, 1550, 1548, 1546, 1452,
 /* 11790 */  1341, 1458,  609, 2580, 2580, 2580, 1396, 2580, 2580, 1339,
 /* 11800 */  1477, 1470, 1468, 1465,  801,  790, 1454, 2580, 2580, 2580,
 /* 11810 */  2580,  524, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11820 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  777,
 /* 11830 */  1258, 1256, 2580, 1326, 1325, 1395, 1394, 1393, 1387, 2580,
 /* 11840 */  2580, 2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335,
 /* 11850 */  2580, 1334, 1333, 2580, 2580, 2580, 1452, 1341, 2580, 2580,
 /* 11860 */  2580, 2580, 2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580,
 /* 11870 */  2580, 2580, 2580, 2580, 2580,  777, 1258, 1256, 1253, 1326,
 /* 11880 */  1325, 1395, 1394, 1393, 1387, 2580, 2580, 2580, 2580, 2580,
 /* 11890 */  1347, 1342, 1338, 1337, 1336, 1335, 1489, 1334, 1333, 2580,
 /* 11900 */  2580, 1551, 1550, 1548, 1546, 2580, 2580, 1458,  609, 2580,
 /* 11910 */  1301, 1299, 1396, 1294, 2580, 1339, 1477, 1470, 1468, 1465,
 /* 11920 */   801,  790, 1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11930 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11940 */  2580, 2580,  777, 1258, 1256, 2580, 1326, 1325, 1395, 1394,
 /* 11950 */  1393, 1387, 2580, 2580, 2580, 2580, 2580, 1347, 1342, 1338,
 /* 11960 */  1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580, 2580, 2580,
 /* 11970 */  2580, 2580, 1452, 1341, 2580, 2580, 2580, 1301, 1299, 2580,
 /* 11980 */  1294, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 11990 */  2580, 2580, 1489, 2580,  547, 2580, 2580, 1551, 1550, 1548,
 /* 12000 */  1546, 2580, 2580, 1458,  609, 2580, 2580, 2580, 1396, 2580,
 /* 12010 */  2580, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 2580,
 /* 12020 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 12030 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 12040 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 12050 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  777, 1258,
 /* 12060 */  1256, 2580, 1326, 1325, 1395, 1394, 1393, 1387, 1452, 1341,
 /* 12070 */  2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580,
 /* 12080 */  1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 12090 */   530, 2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580, 2580,
 /* 12100 */  2580, 2580, 2580, 2580, 1489, 2580, 2580, 2580, 2580, 1551,
 /* 12110 */  1550, 1548, 1546, 2580, 2580, 1458,  609, 2580, 2580, 2580,
 /* 12120 */  1396, 2580, 2580, 1339, 1477, 1470, 1468, 1465,  801,  790,
 /* 12130 */  1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 12140 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 12150 */  2580, 2580, 2580, 2580,  777, 1258, 1256, 2580, 1326, 1325,
 /* 12160 */  1395, 1394, 1393, 1387, 2580, 2580, 2580, 2580, 2580, 1347,
 /* 12170 */  1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580,
 /* 12180 */  1452, 1341, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1301,
 /* 12190 */  1299, 2580, 1294, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 12200 */  1489, 2580,  597, 2580, 2580, 1551, 1550, 1548, 1546, 2580,
 /* 12210 */  2580, 1458,  609, 2580, 2580, 2580, 1396, 2580, 2580, 1339,
 /* 12220 */  1477, 1470, 1468, 1465,  801,  790, 1454, 2580, 2580, 2580,
 /* 12230 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1489,
 /* 12240 */  2580, 2580, 2580, 2580, 1551, 1550, 1548, 1546, 2580, 2580,
 /* 12250 */  1458,  609, 2580, 2580, 2580, 1396, 2580, 2580, 1339, 1477,
 /* 12260 */  1470, 1468, 1465,  801,  790, 1454,  777, 1258, 1256, 2580,
 /* 12270 */  1326, 1325, 1395, 1394, 1393, 1387, 1452, 1341, 2580, 2580,
 /* 12280 */  2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333,
 /* 12290 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1329, 2580,
 /* 12300 */  2580, 1301, 1299, 2580, 1294, 2580, 2580, 2580, 2580, 2580,
 /* 12310 */  2580, 2580, 2580, 2580, 2580, 1452, 1341, 2580, 2580, 2580,
 /* 12320 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 12330 */  2580, 2580, 2580, 2580, 2580, 1489, 2580,  542, 2580, 2580,
 /* 12340 */  1551, 1550, 1548, 1546, 2580, 2580, 1458,  609, 2580, 2580,
 /* 12350 */  2580, 1396, 2580, 2580, 1339, 1477, 1470, 1468, 1465,  801,
 /* 12360 */   790, 1454,  777, 1258, 1256, 2580, 1326, 1325, 1395, 1394,
 /* 12370 */  1393, 1387, 2580, 2580, 2580, 2580, 2580, 1347, 1342, 1338,
 /* 12380 */  1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580, 2580, 2580,
 /* 12390 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1301, 1299, 2580,
 /* 12400 */  1294,  777, 1258, 1256, 2580, 1326, 1325, 1395, 1394, 1393,
 /* 12410 */  1387, 1452, 1341, 2580, 2580, 2580, 1347, 1342, 1338, 1337,
 /* 12420 */  1336, 1335, 2580, 1334, 1333, 2580, 2580, 2580, 2580, 2580,
 /* 12430 */  2580, 2580, 2580, 1328, 2580, 2580, 1301, 1299, 2580, 1294,
 /* 12440 */  2580, 2580, 2580, 2580, 2580, 1489, 2580, 2580, 2580, 2580,
 /* 12450 */  1551, 1550, 1548, 1546, 2580, 2580, 1458,  609, 2580, 2580,
 /* 12460 */  2580, 1396, 2580, 2580, 1339, 1477, 1470, 1468, 1465,  801,
 /* 12470 */   790, 1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 12480 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 12490 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  777, 1258, 1256,
 /* 12500 */  2580, 1326, 1325, 1395, 1394, 1393, 1387, 2580, 2580, 2580,
 /* 12510 */  2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334,
 /* 12520 */  1333, 1452, 1341, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 12530 */  2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580, 2580, 2580,
 /* 12540 */  2580, 1489, 2580,  535, 2580, 2580, 1551, 1550, 1548, 1546,
 /* 12550 */  2580, 2580, 1458,  609, 2580, 2580, 2580, 1396, 2580, 2580,
 /* 12560 */  1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 2580, 2580,
 /* 12570 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 12580 */  1489, 2580, 2580, 2580, 2580, 1551, 1550, 1548, 1546, 2580,
 /* 12590 */  2580, 1458,  609, 2580, 2580, 2580, 1396, 2580, 2580, 1339,
 /* 12600 */  1477, 1470, 1468, 1465,  801,  790, 1454,  777, 1258, 1256,
 /* 12610 */  2580, 1326, 1325, 1395, 1394, 1393, 1387, 1452, 1341, 2580,
 /* 12620 */  2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334,
 /* 12630 */  1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1327,
 /* 12640 */  2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580, 2580, 2580,
 /* 12650 */  2580, 2580, 2580, 2580, 2580, 2580, 1452, 1341, 2580, 2580,
 /* 12660 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 12670 */  2580, 2580, 2580, 2580, 2580, 2580, 1489, 2580,  541, 2580,
 /* 12680 */  2580, 1551, 1550, 1548, 1546, 2580, 2580, 1458,  609, 2580,
 /* 12690 */  2580, 2580, 1396, 2580, 2580, 1339, 1477, 1470, 1468, 1465,
 /* 12700 */   801,  790, 1454,  777, 1258, 1256, 2580, 1326, 1325, 1395,
 /* 12710 */  1394, 1393, 1387, 2580, 2580, 2580, 2580, 2580, 1347, 1342,
 /* 12720 */  1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580, 2580,
 /* 12730 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1301, 1299,
 /* 12740 */  2580, 1294,  777, 1258, 1256, 2580, 1326, 1325, 1395, 1394,
 /* 12750 */  1393, 1387, 1452, 1341, 2580, 2580, 2580, 1347, 1342, 1338,
 /* 12760 */  1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580, 2580, 2580,
 /* 12770 */  2580, 2580, 2580, 2580,  522, 2580, 2580, 1301, 1299, 2580,
 /* 12780 */  1294, 2580, 2580, 2580, 2580, 2580, 1489, 2580, 2580, 2580,
 /* 12790 */  2580, 1551, 1550, 1548, 1546, 2580, 2580, 1458,  609, 2580,
 /* 12800 */  2580, 2580, 1396, 2580, 2580, 1339, 1477, 1470, 1468, 1465,
 /* 12810 */   801,  790, 1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 12820 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 12830 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  777, 1258,
 /* 12840 */  1256, 2580, 1326, 1325, 1395, 1394, 1393, 1387, 2580, 2580,
 /* 12850 */  2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580,
 /* 12860 */  1334, 1333, 1452, 1341, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 12870 */  2580, 2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580, 2580,
 /* 12880 */  2580, 2580, 1489, 2580,  536, 2580, 2580, 1551, 1550, 1548,
 /* 12890 */  1546, 2580, 2580, 1458,  609, 2580, 2580, 2580, 1396, 2580,
 /* 12900 */  2580, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 2580,
 /* 12910 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 12920 */  2580, 1489, 2580, 2580, 2580, 2580, 1551, 1550, 1548, 1546,
 /* 12930 */  2580, 2580, 1458,  609, 2580, 2580, 2580, 1396, 2580, 2580,
 /* 12940 */  1339, 1477, 1470, 1468, 1465,  801,  790, 1454,  777, 1258,
 /* 12950 */  1256, 2580, 1326, 1325, 1395, 1394, 1393, 1387, 1452, 1341,
 /* 12960 */  2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580,
 /* 12970 */  1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 12980 */   598, 2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580, 2580,
 /* 12990 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1452, 1341, 2580,
 /* 13000 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 13010 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1489, 2580,  531,
 /* 13020 */  2580, 2580, 1551, 1550, 1548, 1546, 2580, 2580, 1458,  609,
 /* 13030 */  2580, 2580, 2580, 1396, 2580, 2580, 1339, 1477, 1470, 1468,
 /* 13040 */  1465,  801,  790, 1454,  777, 1258, 1256, 2580, 1326, 1325,
 /* 13050 */  1395, 1394, 1393, 1387, 2580, 2580, 2580, 2580, 2580, 1347,
 /* 13060 */  1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580,
 /* 13070 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1301,
 /* 13080 */  1299, 2580, 1294,  777, 1258, 1256, 2580, 1326, 1325, 1395,
 /* 13090 */  1394, 1393, 1387, 1452, 1341, 2580, 2580, 2580, 1347, 1342,
 /* 13100 */  1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580, 2580,
 /* 13110 */  2580, 2580, 2580, 2580, 1488,  532, 1557, 1556, 1301, 1299,
 /* 13120 */  2580, 1294, 2580, 2580, 1458,  609, 2580, 2580, 2580, 2580,
 /* 13130 */  1406, 2580, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454,
 /* 13140 */  2580, 2580, 2580, 2580,   86,   85, 2580, 2580, 2580, 2580,
 /* 13150 */  2580, 2580, 2580, 1547, 1539, 2580, 2580, 1499, 1497, 1475,
 /* 13160 */  1472, 1466, 1464, 1463, 1462, 1461, 2580, 2580, 2580, 2580,
 /* 13170 */  2580, 2580, 2580,   59, 2580,  420, 2580, 2580, 2580,  777,
 /* 13180 */  1258, 1256, 2580, 1326, 1325, 1395, 1394, 1393, 1387, 1452,
 /* 13190 */  1341, 2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335,
 /* 13200 */   872, 1334, 1333, 2580, 2580, 2580,  833, 2580, 2580, 2580,
 /* 13210 */  2580, 2580, 2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580,
 /* 13220 */  2580, 2580, 2580,  663, 2580,  491, 2580, 2580, 2580, 2580,
 /* 13230 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  636,  626,  621,
 /* 13240 */   784,  770,  724,  734, 2580, 2580,   16, 2580, 1120, 2580,
 /* 13250 */  2580,  878,  879,  852, 1096,   38,  279, 2580, 2580, 1116,
 /* 13260 */  2580, 2580, 2580,  819,  805, 1405, 1404,  654, 2580, 2580,
 /* 13270 */  2580, 2580, 2580, 2580, 2580,  566,  633,  632, 2580, 2580,
 /* 13280 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 13290 */  1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580,
 /* 13300 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 13310 */  1301, 1299, 2580, 1294, 2580, 2580, 1489, 2580, 2580, 2580,
 /* 13320 */  2580, 1551, 1550, 1548, 1546, 2580, 2580, 1458,  609, 2580,
 /* 13330 */  2580, 2580, 1396, 2580, 2580, 1339, 1477, 1470, 1468, 1465,
 /* 13340 */   801,  790, 1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 13350 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 13360 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 13370 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 13380 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 13390 */  2580, 2580, 1452, 1341, 2580, 2580, 2580, 2580, 2580, 1488,
 /* 13400 */  2580, 1557, 1556, 2580, 2580, 2580, 2580, 2580, 2580, 1458,
 /* 13410 */   609, 2580, 2580, 2580,  520, 1406, 2580, 1339, 1477, 1470,
 /* 13420 */  1468, 1465,  801,  790, 1454, 2580, 2580, 2580, 2580, 2580,
 /* 13430 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 13440 */  2580, 2580, 2580, 1489, 2580, 2580, 2580, 2580, 1551, 1550,
 /* 13450 */  1548, 1546, 2580, 2580, 1458,  609, 2580, 2580, 2580, 1396,
 /* 13460 */  2580, 2580, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454,
 /* 13470 */  2580, 2580, 2580, 2580, 1452, 1341, 2580, 2580,  777, 1258,
 /* 13480 */  1256, 2580, 1326, 1325, 1395, 1394, 1393, 1387, 2580, 2580,
 /* 13490 */  2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580,
 /* 13500 */  1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 13510 */   491, 2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580, 1452,
 /* 13520 */  1341, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 13530 */  2580, 2580, 2580, 1120, 2580, 2580, 2580, 2580, 2580,  676,
 /* 13540 */  2580,  544, 2580, 2580, 1116, 2580, 2580, 2580,  819,  805,
 /* 13550 */  1405, 1404,  654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 13560 */   566,  633,  632, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 13570 */  2580, 2580, 2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336,
 /* 13580 */  1335, 2580, 1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 13590 */  2580, 2580, 2580, 2580, 2580, 1301, 1299, 2580, 1294, 2580,
 /* 13600 */  2580, 2580, 2580, 2580, 2580,  777, 1258, 1256, 2580, 1326,
 /* 13610 */  1325, 1395, 1394, 1393, 1387, 2580, 2580, 2580, 2580, 2580,
 /* 13620 */  1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580,
 /* 13630 */  2580, 2580, 2580, 2580, 2580, 2580, 1488, 2580, 1557, 1556,
 /* 13640 */  1301, 1299, 2580, 1294, 2580, 2580, 1458,  609, 2580, 2580,
 /* 13650 */  2580, 2580, 1406, 2580, 1339, 1477, 1470, 1468, 1465,  801,
 /* 13660 */   790, 1454, 2580, 2580, 2580,   86,   85, 2580, 2580, 2580,
 /* 13670 */  2580, 2580, 2580, 2580, 1547, 1539, 2580, 2580, 1499, 1497,
 /* 13680 */  1475, 1472, 1466, 1464, 1463, 1462, 1461, 2580, 2580, 2580,
 /* 13690 */  2580, 2580, 2580, 2580,   60, 2580, 2580, 2580, 2580, 2580,
 /* 13700 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 13710 */  2580, 1452, 1341, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 13720 */  2580,  872, 2580, 2580, 2580, 2580, 2580,  833, 2580, 1489,
 /* 13730 */  2580, 2580, 2580, 2580, 1551, 1550, 1548, 1546, 2580, 2580,
 /* 13740 */  1458,  609, 2580, 2580,  663, 1396, 2580,  491, 1339, 1477,
 /* 13750 */  1470, 1468, 1465,  801,  790, 1454, 2580, 2580,  636,  626,
 /* 13760 */   621,  784,  770,  724,  734, 2580, 2580,   16, 2580, 2580,
 /* 13770 */  1120, 2580,  878,  879,  852, 2580,  664, 2580, 2580, 2580,
 /* 13780 */  2580, 1116, 2580, 2580, 2580,  819,  805, 1405, 1404,  654,
 /* 13790 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  566,  633,  632,
 /* 13800 */  2580, 2580, 2580, 2580, 2580, 1452, 1341, 2580, 2580, 2580,
 /* 13810 */  2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334,
 /* 13820 */  1333, 2580, 2580, 2580, 2580, 2580, 2580,  527, 2580, 2580,
 /* 13830 */  2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580, 2580, 2580,
 /* 13840 */  1488, 2580, 1557, 1556, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 13850 */  1458,  609, 2580, 2580, 2580, 2580, 1406, 2580, 1339, 1477,
 /* 13860 */  1470, 1468, 1465,  801,  790, 1454, 2580, 2580, 2580, 2580,
 /* 13870 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 13880 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 13890 */  2580,  777, 1258, 1256, 2580, 1326, 1325, 1395, 1394, 1393,
 /* 13900 */  1387, 2580, 2580, 2580, 2580, 2580, 1347, 1342, 1338, 1337,
 /* 13910 */  1336, 1335, 2580, 1334, 1333, 1452, 1341, 2580, 2580, 2580,
 /* 13920 */  2580, 2580, 2580, 2580, 2580, 2580, 1301, 1299, 2580, 1294,
 /* 13930 */  2580, 2580, 2580, 1489, 2580, 2580, 2580, 2580, 1551, 1550,
 /* 13940 */  1548, 1546, 2580, 2580, 1458,  609, 2580, 2580, 2580, 1396,
 /* 13950 */  2580,  491, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454,
 /* 13960 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 13970 */  2580, 2580, 2580, 2580,  103, 2580, 2580, 2580, 2580, 2580,
 /* 13980 */  2580, 2580,  101, 2580, 2580, 1116, 2580, 2580, 2580,  819,
 /* 13990 */   805, 1405, 1404,  654, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14000 */  2580,  566,  633,  632, 2580, 2580, 2580, 2580, 2580, 1452,
 /* 14010 */  1341, 2580, 2580, 2580, 2580, 2580, 1347, 1342, 1338, 1337,
 /* 14020 */  1336, 1335, 2580, 1334, 1333, 2580, 2580, 2580, 2580, 2580,
 /* 14030 */  2580,  526, 1488, 2580, 1557, 1556, 1301, 1299, 2580, 1294,
 /* 14040 */  2580, 2580, 1458,  609, 2580, 2580, 2580, 2580, 1406, 2580,
 /* 14050 */  1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 2580, 2580,
 /* 14060 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14070 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14080 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14090 */  2580, 2580, 2580, 2580, 2580,  777, 1258, 1256, 2580, 1326,
 /* 14100 */  1325, 1395, 1394, 1393, 1387, 2580, 2580, 1452, 1341, 2580,
 /* 14110 */  1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580,
 /* 14120 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14130 */  1301, 1299, 2580, 1294, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14140 */  2580, 2580, 2580,  491, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14150 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14160 */  2580, 2580, 2580, 2580, 2580, 1025,  191, 2580, 2580, 2580,
 /* 14170 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1116, 2580, 2580,
 /* 14180 */  2580,  819,  805, 1405, 1404,  654, 2580, 2580, 2580, 2580,
 /* 14190 */  2580, 2580, 2580,  566,  633,  632, 2580, 2580, 2580, 2580,
 /* 14200 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1347, 1342,
 /* 14210 */  1338, 1337, 1336, 1335, 1489, 1334, 1333, 2580, 2580, 1551,
 /* 14220 */  1550, 1548, 1546, 2580, 2580, 1458,  609, 2580, 1301, 1299,
 /* 14230 */  1396, 1294, 2580, 1339, 1477, 1470, 1468, 1465,  801,  790,
 /* 14240 */  1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14250 */  2580, 2580, 1554, 1553, 1552, 2580, 2580, 2580, 2580, 1499,
 /* 14260 */  1497, 1475, 1472, 1466, 1464, 1463, 1462, 1461, 2580, 2580,
 /* 14270 */  2580, 2580, 2580, 2580, 2580,   58, 1488,  420, 1557, 1556,
 /* 14280 */  2580, 2580, 2580, 2580, 2580, 2580, 1458,  609, 2580, 2580,
 /* 14290 */  1452, 1341, 1406, 2580, 1339, 1477, 1470, 1468, 1465,  801,
 /* 14300 */   790, 1454,  872, 2580, 2580, 2580,  809,  803,  696,  681,
 /* 14310 */   668,  660,  545, 2580,  772,  750,  741,  726,  720, 2580,
 /* 14320 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14330 */  2580,  683, 2580,  667, 2580,  854,  882, 2580, 2580, 2580,
 /* 14340 */  2580, 2580,  784, 2580, 2580, 2580, 2580, 2580,   16, 2580,
 /* 14350 */  2580, 1452, 1341,  878,  879,  852, 2580,   38,  279, 2580,
 /* 14360 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14370 */  2580, 2580, 2580, 2580, 2580, 2580,  777, 1258, 1256, 2580,
 /* 14380 */  1326, 1325, 1395, 1394, 1393, 1387, 2580,  407, 2580, 2580,
 /* 14390 */  2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333,
 /* 14400 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14410 */   689, 1301, 1299, 2580, 1294, 2580, 2580, 2580, 2580, 2580,
 /* 14420 */  2580, 1116, 2580, 2580, 2580,  819,  805, 1405, 1404,  654,
 /* 14430 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  566,  633,  632,
 /* 14440 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14450 */  2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334,
 /* 14460 */  1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14470 */  2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580, 2580, 2580,
 /* 14480 */  2580, 2580, 2580, 2580, 2580, 1488, 2580, 1557, 1556, 2580,
 /* 14490 */  2580, 2580, 2580, 2580, 2580, 1458,  609, 2580, 2580, 2580,
 /* 14500 */  2580, 1406, 2580, 1339, 1477, 1470, 1468, 1465,  801,  790,
 /* 14510 */  1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14520 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14530 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14540 */  2580, 2580, 2580, 2580, 2580, 2580, 1488, 2580, 1557, 1556,
 /* 14550 */  2580, 2580, 2580, 2580, 2580, 2580, 1458,  609, 2580, 2580,
 /* 14560 */  1452, 1341, 1406, 2580, 1339, 1477, 1470, 1468, 1465,  801,
 /* 14570 */   790, 1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14580 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14590 */  2580, 2580, 2580, 2580, 2580, 2580,  491, 2580, 2580, 2580,
 /* 14600 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14610 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1104,
 /* 14620 */  2580, 1452, 1341, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14630 */  1116, 2580, 2580, 2580,  819,  805, 1405, 1404,  654, 2580,
 /* 14640 */  2580, 2580, 2580, 2580, 2580, 2580,  566,  633,  632, 2580,
 /* 14650 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  491, 2580, 2580,
 /* 14660 */  2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333,
 /* 14670 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14680 */  1117, 1301, 1299, 2580, 1294, 2580, 2580, 2580, 2580, 2580,
 /* 14690 */  2580, 1116, 2580, 2580, 2580,  819,  805, 1405, 1404,  654,
 /* 14700 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  566,  633,  632,
 /* 14710 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14720 */  2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334,
 /* 14730 */  1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14740 */  2580, 2580, 1301, 1299, 2580, 1294, 1488, 2580, 1557, 1556,
 /* 14750 */  2580, 2580, 2580, 2580, 2580, 2580, 1458,  609, 2580, 2580,
 /* 14760 */  2580, 2580, 1406, 2580, 1339, 1477, 1470, 1468, 1465,  801,
 /* 14770 */   790, 1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14780 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14790 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14800 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1488, 2580, 1557,
 /* 14810 */  1556, 2580, 2580, 2580, 2580, 2580, 2580, 1458,  609, 2580,
 /* 14820 */  2580, 1452, 1341, 1406, 2580, 1339, 1477, 1470, 1468, 1465,
 /* 14830 */   801,  790, 1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14840 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14850 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  491, 2580, 2580,
 /* 14860 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14870 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14880 */  2580, 2580, 1452, 1341, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14890 */  2580,  766, 2580, 2580, 2580,  819,  805, 1405, 1404,  654,
 /* 14900 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  566,  633,  632,
 /* 14910 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  491, 2580,
 /* 14920 */  2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334,
 /* 14930 */  1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14940 */  2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580, 2580, 2580,
 /* 14950 */  2580, 2580,  713, 2580, 2580, 2580,  819,  805, 1405, 1404,
 /* 14960 */   654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  566,  633,
 /* 14970 */   632, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 14980 */  2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580,
 /* 14990 */  1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 15000 */  2580, 2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580, 2580,
 /* 15010 */  2580, 1488, 2580, 1557, 1556, 2580, 2580, 2580, 2580, 2580,
 /* 15020 */  2580, 1458,  609, 2580, 2580, 2580, 2580, 1406, 2580, 1339,
 /* 15030 */  1477, 1470, 1468, 1465,  801,  790, 1454, 2580, 2580, 2580,
 /* 15040 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 15050 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 15060 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 15070 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 15080 */  2580, 2580, 1488, 2580, 1557, 1556, 1452, 1341, 2580, 2580,
 /* 15090 */  2580, 2580, 1458,  609, 2580, 2580, 2580, 2580, 1406, 2580,
 /* 15100 */  1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 2580, 2580,
 /* 15110 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 15120 */  2580, 2580,  491, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 15130 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 15140 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 15150 */  2580, 2580, 2580, 2580, 2580, 2580,  739, 1452, 1341, 2580,
 /* 15160 */   819,  805, 1405, 1404,  654, 2580, 2580, 2580, 2580, 2580,
 /* 15170 */  2580, 2580,  566,  633,  632, 2580, 2580, 2580, 2580, 2580,
 /* 15180 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1347, 1342, 1338,
 /* 15190 */  1337, 1336, 1335,  491, 1334, 1333, 2580, 2580, 2580, 2580,
 /* 15200 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1301, 1299, 2580,
 /* 15210 */  1294, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 15220 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  721, 2580, 2580,
 /* 15230 */  2580,  819,  805, 1405, 1404,  654, 2580, 2580, 2580, 2580,
 /* 15240 */  2580, 2580, 2580,  566,  633,  632, 2580, 2580, 2580, 2580,
 /* 15250 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1347, 1342,
 /* 15260 */  1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580, 2580,
 /* 15270 */  2580, 2580, 1488, 2580, 1557, 1556, 2580, 2580, 1301, 1299,
 /* 15280 */  2580, 1294, 1458,  609, 2580, 2580, 2580, 2580, 1406, 2580,
 /* 15290 */  1339, 1477, 1470, 1468, 1465,  801,  790, 1454, 2580, 2580,
 /* 15300 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1554,
 /* 15310 */  1553, 1552, 2580, 2580, 2580, 2580, 1499, 1497, 1475, 1472,
 /* 15320 */  1466, 1464, 1463, 1462, 1461, 2580, 2580, 2580, 2580, 2580,
 /* 15330 */  2580, 2580,   57, 1488, 2580, 1557, 1556, 2580, 2580, 2580,
 /* 15340 */  2580, 2580, 2580, 1458,  609, 2580, 2580, 1452, 1341, 1406,
 /* 15350 */  2580, 1339, 1477, 1470, 1468, 1465,  801,  790, 1454,  872,
 /* 15360 */   682,  755, 2580,  809,  803,  696,  681,  668,  660, 2580,
 /* 15370 */  2580,  772,  750,  741,  726,  720, 2580, 2580, 2580, 2580,
 /* 15380 */  2580, 2580, 2580,  491, 2580, 2580, 2580, 2580,  683, 2580,
 /* 15390 */   667, 2580,  854,  882, 2580, 2580, 2580, 2580, 2580,  784,
 /* 15400 */  2580, 2580, 2580, 2580, 2580,   16,  843, 2580, 1452, 1341,
 /* 15410 */   878,  879,  852, 2580, 2580, 2580, 2580,  747, 2580, 2580,
 /* 15420 */  2580,  819,  805, 1405, 1404,  654, 2580, 2580, 2580, 2580,
 /* 15430 */  2580, 2580, 2580,  566,  633,  632, 2580, 2580, 2580, 2580,
 /* 15440 */  2580, 2580, 2580, 2580,  800, 2580, 2580, 2580, 1347, 1342,
 /* 15450 */  1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 1318, 2580,
 /* 15460 */  2580,  310, 2580, 2580, 2580, 1316, 2580, 2580, 1301, 1299,
 /* 15470 */  2580, 1294, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 15480 */  2580, 2580,  819,  805, 1405, 1404,  654, 2580, 2580, 2580,
 /* 15490 */  1320, 2580, 2580, 2297,  566,  633,  632, 2580, 2580, 2580,
 /* 15500 */   690, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1347,
 /* 15510 */  1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333, 2580, 2580,
 /* 15520 */  2580, 2580, 2580,  419, 2580, 2580, 2580, 2580, 2580, 1301,
 /* 15530 */  1299, 2580, 1294, 2580, 2580, 2580,  650, 1351,  640, 2580,
 /* 15540 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1488, 2580, 1557,
 /* 15550 */  1556, 2580, 2580, 2580, 2580, 2580, 2580, 1458,  609, 2580,
 /* 15560 */  2580, 1321, 2580, 1406, 2580, 1339, 1477, 1470, 1468, 1465,
 /* 15570 */   801,  790, 1454, 2580, 2451, 2580, 2580, 2580, 2580,  299,
 /* 15580 */  2580, 2580, 2580, 1317, 1319, 2580, 1324, 2580, 2580, 2580,
 /* 15590 */  2580, 2580, 2580, 2580,  314, 2580, 2580, 2580, 2580, 2580,
 /* 15600 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1488, 2580,
 /* 15610 */  1557, 1556, 2580, 2580, 2580, 2580, 2580, 2580, 1458,  609,
 /* 15620 */  2580, 2580, 1452, 1341, 1406, 2580, 1339, 1477, 1470, 1468,
 /* 15630 */  1465,  801,  790, 1454, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 15640 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 15650 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  794, 2580,
 /* 15660 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 15670 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 15680 */  2580, 2580, 2580, 1452, 1341, 2580, 2580, 2580, 2580, 2580,
 /* 15690 */  2580, 2580, 2580, 2580, 2580, 2580,  819,  805, 1405, 1404,
 /* 15700 */   654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  566,  633,
 /* 15710 */   632, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1017,
 /* 15720 */  2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580,
 /* 15730 */  1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 15740 */  2580, 2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580, 2580,
 /* 15750 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  819,  805, 1405,
 /* 15760 */  1404,  654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  566,
 /* 15770 */   633,  632, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 15780 */  2580, 2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335,
 /* 15790 */  2580, 1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 15800 */  2580, 2580, 2580, 2580, 1301, 1299, 1488, 1294, 1557, 1556,
 /* 15810 */  2580, 2580, 2580, 2580, 2580, 2580, 1458,  609, 2580, 2580,
 /* 15820 */  2580, 2580, 1406, 2580, 1339, 1477, 1470, 1468, 1465,  801,
 /* 15830 */   790, 1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 15840 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1554, 1553,
 /* 15850 */  1552, 2580, 2580, 2580, 2580, 1499, 1497, 1475, 1472, 1466,
 /* 15860 */  1464, 1463, 1462, 1461, 2580, 2580, 2580, 1488, 2580, 1557,
 /* 15870 */  1556,   57, 2580, 2580, 2580, 2580, 2580, 1458,  609, 2580,
 /* 15880 */  2580, 1452, 1341, 1406, 2580, 1339, 1477, 1470, 1468, 1465,
 /* 15890 */   801,  790, 1454, 2580, 2580, 2580, 2580, 2580,  872, 2580,
 /* 15900 */  2580, 2580,  809,  803,  696,  681,  668,  660, 2580, 2580,
 /* 15910 */   772,  750,  741,  726,  720, 2580, 2580,  251, 2580, 2580,
 /* 15920 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  683, 2580,  667,
 /* 15930 */  2580,  854,  882, 2580, 2580, 2580, 2580, 2580,  784, 2580,
 /* 15940 */  2580, 2580, 1452, 1341,   16, 2580, 2580, 2580, 2580,  878,
 /* 15950 */   879,  852, 2580, 2580, 2580,  819,  805, 1405, 1404,  654,
 /* 15960 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  566,  633,  632,
 /* 15970 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  239, 2580,
 /* 15980 */  2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334,
 /* 15990 */  1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16000 */  2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580, 2580, 2580,
 /* 16010 */  2580, 2580, 2580, 2580, 2580, 2580,  819,  805, 1405, 1404,
 /* 16020 */   654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  566,  633,
 /* 16030 */   632, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16040 */  2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580,
 /* 16050 */  1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16060 */  2580, 2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580, 2580,
 /* 16070 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1488, 2580, 1557,
 /* 16080 */  1556, 2580, 2580, 2580, 2580, 2580, 2580, 1458,  609, 2580,
 /* 16090 */  2580, 2580, 2580, 1406, 2580, 1339, 1477, 1470, 1468, 1465,
 /* 16100 */   801,  790, 1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16110 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16120 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16130 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16140 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1488, 2580,
 /* 16150 */  1557, 1556, 1452, 1341, 2580, 2580, 2580, 2580, 1458,  609,
 /* 16160 */  2580, 2580, 2580, 2580, 1406, 2580, 1339, 1477, 1470, 1468,
 /* 16170 */  1465,  801,  790, 1454, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16180 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  210, 2580,
 /* 16190 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16200 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16210 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16220 */  2580, 2580, 2580, 1452, 1341, 2580,  819,  805, 1405, 1404,
 /* 16230 */   654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  566,  633,
 /* 16240 */   632, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16250 */  2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335,  238,
 /* 16260 */  1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16270 */  2580, 2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580, 2580,
 /* 16280 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  760, 2580, 2580,
 /* 16290 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  819,  805, 1405,
 /* 16300 */  1404,  654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  566,
 /* 16310 */   633,  632, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16320 */  2580, 2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335,
 /* 16330 */  2580, 1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16340 */  2580, 2580, 2580, 2580, 1301, 1299, 2580, 1294, 1458,  609,
 /* 16350 */  2580, 2580, 2580, 2580, 2580, 2580, 1339, 1477, 1470, 1468,
 /* 16360 */  1465,  801,  790, 1454,  260, 2580, 2580, 2580, 1451, 2580,
 /* 16370 */  2580, 2580, 2580, 2580, 2580, 2580, 1449, 1448, 1446, 1445,
 /* 16380 */  1443, 1442, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16390 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 1488,
 /* 16400 */  2580, 1557, 1556, 2580, 2580, 2580, 2580, 2580, 2580, 1458,
 /* 16410 */   609, 2580, 2580, 1452, 1341, 1406, 2580, 1339, 1477, 1470,
 /* 16420 */  1468, 1465,  801,  790, 1454, 2580, 2580, 2580, 2580, 2580,
 /* 16430 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16440 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16450 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16460 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16470 */  1488, 2580, 1557, 1556, 1452, 1341, 2580, 2580, 2580, 2580,
 /* 16480 */  1458,  609, 2580, 2580, 2580, 2580, 1406, 2580, 1339, 1477,
 /* 16490 */  1470, 1468, 1465,  801,  790, 1454, 2580, 2580, 2580,  871,
 /* 16500 */   634,  629, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16510 */  1088, 2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335,
 /* 16520 */  2580, 1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16530 */  2580, 2580, 2580,  628, 1301, 1299, 2580, 1294, 2580, 2580,
 /* 16540 */  2580, 2580, 2580, 2580, 2580, 1452, 1341, 2580,  819,  805,
 /* 16550 */  1405, 1404,  654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16560 */   566,  633,  632, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16570 */  2580, 2580, 2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336,
 /* 16580 */  1335,  862, 1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16590 */  2580, 2580, 2580, 2580, 2580, 1301, 1299, 2580, 1294, 2580,
 /* 16600 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16610 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  819,
 /* 16620 */   805, 1405, 1404,  654, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16630 */  2580,  566,  633,  632, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16640 */  2580, 2580, 2580, 2580, 2580,  692, 1347, 1342, 1338, 1337,
 /* 16650 */  1336, 1335, 2580, 1334, 1333, 2580, 2580, 2580, 2580, 2580,
 /* 16660 */  2580, 2580, 2580, 2580, 2580, 2580, 1301, 1299, 1488, 1294,
 /* 16670 */  1557, 1556, 2580, 2580, 2580, 2580, 2580, 2580, 1458,  609,
 /* 16680 */  2580, 2580, 2580, 2580, 1406, 2580, 1339, 1477, 1470, 1468,
 /* 16690 */  1465,  801,  790, 1454, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16700 */  2580, 2580, 2580, 2580, 2580, 2580, 1458,  609, 2580, 2580,
 /* 16710 */  2580, 2580, 2580, 2580, 1339, 1477, 1470, 1468, 1465,  801,
 /* 16720 */   790, 1454,  260, 2580, 2580, 2580, 1451, 2580, 2580, 2580,
 /* 16730 */  2580, 2580, 2580, 2580, 1449, 1448, 1446, 1445, 1443, 1442,
 /* 16740 */  2580, 2580, 2580, 1452, 1341, 2580, 2580, 2580, 2580, 2580,
 /* 16750 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16760 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16770 */  2580, 1452, 1341, 2580, 2580, 2580, 2580, 2580, 2580, 1218,
 /* 16780 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16790 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16800 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16810 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  819,  805, 1405,
 /* 16820 */  1404,  654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  566,
 /* 16830 */   633,  632, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16840 */  2580, 2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335,
 /* 16850 */  2580, 1334, 1333, 2580, 2580, 2580, 2580,  871,  634,  629,
 /* 16860 */  2580, 2580, 2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580,
 /* 16870 */  2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334,
 /* 16880 */  1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16890 */  2580,  628, 1301, 1299, 2580, 1294, 1488, 2580, 1557, 1556,
 /* 16900 */  2580, 2580, 2580, 2580, 2580, 2580, 1458,  609, 2580, 2580,
 /* 16910 */  2580, 2580, 1406, 2580, 1339, 1477, 1470, 1468, 1465,  801,
 /* 16920 */   790, 1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16930 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16940 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16950 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 16960 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1488, 2580, 1557,
 /* 16970 */  1556, 1452, 1341, 2580, 2580, 2580, 2580, 1458,  609, 2580,
 /* 16980 */  2580, 2580, 2580, 1406, 2580, 1339, 1477, 1470, 1468, 1465,
 /* 16990 */   801,  790, 1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17000 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1029, 2580, 2580,
 /* 17010 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17020 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17030 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17040 */  2580, 2580, 1452, 1341, 2580,  819,  805, 1405, 1404,  654,
 /* 17050 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  566,  633,  632,
 /* 17060 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17070 */  2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 1224, 1334,
 /* 17080 */  1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17090 */  2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580, 2580, 2580,
 /* 17100 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17110 */  2580, 2580, 2580, 2580, 2580, 2580,  819,  805, 1405, 1404,
 /* 17120 */   654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  566,  633,
 /* 17130 */   632, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17140 */  2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580,
 /* 17150 */  1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17160 */  2580, 2580, 2580, 1301, 1299, 1488, 1294, 1557, 1556, 2580,
 /* 17170 */  2580, 2580, 2580, 2580, 2580, 1458,  609, 2580, 2580, 2580,
 /* 17180 */  2580, 1406, 2580, 1339, 1477, 1470, 1468, 1465,  801,  790,
 /* 17190 */  1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17200 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1554, 1553, 1552,
 /* 17210 */  2580, 2580, 2580, 2580, 1499, 1497, 1475, 1472, 1466, 1464,
 /* 17220 */  1463, 1462, 1461, 2580, 2580, 2580, 1488, 2580, 1557, 1556,
 /* 17230 */    61, 2580, 2580, 2580, 2580, 2580, 1458,  609, 2580, 2580,
 /* 17240 */  1452, 1341, 1406, 2580, 1339, 1477, 1470, 1468, 1465,  801,
 /* 17250 */   790, 1454, 2580, 2580, 2580, 2580, 2580,  872, 2580, 2580,
 /* 17260 */  2580, 2580,  803,  696,  681,  668,  660, 2580, 2580,  772,
 /* 17270 */   750,  741,  726,  720, 2580, 2580, 1046, 2580, 2580, 2580,
 /* 17280 */  2580, 2580, 2580, 2580, 2580, 2580,  683, 2580,  667, 2580,
 /* 17290 */   854,  882, 2580, 2580, 2580, 2580, 2580,  784, 2580, 2580,
 /* 17300 */  2580, 1452, 1341,   16, 2580, 2580, 2580, 2580,  878,  879,
 /* 17310 */   852, 2580, 2580, 2580,  819,  805, 1405, 1404,  654, 2580,
 /* 17320 */  2580, 2580, 2580, 2580, 2580, 2580,  566,  633,  632, 2580,
 /* 17330 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1030, 2580, 2580,
 /* 17340 */  2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334, 1333,
 /* 17350 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17360 */  2580, 1301, 1299, 2580, 1294, 2580, 2580, 2580, 2580, 2580,
 /* 17370 */  2580, 2580, 2580, 2580, 2580,  819,  805, 1405, 1404,  654,
 /* 17380 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  566,  633,  632,
 /* 17390 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17400 */  2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580, 1334,
 /* 17410 */  1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17420 */  2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580, 2580, 2580,
 /* 17430 */  2580, 2580, 2580, 2580, 2580, 2580, 1488, 2580, 1557, 1556,
 /* 17440 */  2580, 2580, 2580, 2580, 2580, 2580, 1458,  609, 2580, 2580,
 /* 17450 */  2580, 2580, 1406, 2580, 1339, 1477, 1470, 1468, 1465,  801,
 /* 17460 */   790, 1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17470 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17480 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17490 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17500 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 1488, 2580, 1557,
 /* 17510 */  1556, 1452, 1341, 2580, 2580, 2580, 2580, 1458,  609, 2580,
 /* 17520 */  2580, 2580, 2580, 1406, 2580, 1339, 1477, 1470, 1468, 1465,
 /* 17530 */   801,  790, 1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17540 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  856, 2580, 2580,
 /* 17550 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17560 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17570 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17580 */  2580, 2580, 1452, 1341, 2580,  819,  805, 1405, 1404,  654,
 /* 17590 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  566,  633,  632,
 /* 17600 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17610 */  2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 1056, 1334,
 /* 17620 */  1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17630 */  2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580, 2580, 2580,
 /* 17640 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17650 */  2580, 2580, 2580, 2580, 2580, 2580,  819,  805, 1405, 1404,
 /* 17660 */   654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  566,  633,
 /* 17670 */   632, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17680 */  2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580,
 /* 17690 */  1334, 1333, 2580, 2580, 2580, 2580, 2580, 1488, 2580, 1557,
 /* 17700 */  1556, 2580, 2580, 1301, 1299, 2580, 1294, 1458,  609, 2580,
 /* 17710 */  2580, 2580, 2580, 1406, 2580, 1339, 1477, 1470, 1468, 1465,
 /* 17720 */   801,  790, 1454, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17730 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17740 */  2580, 1554, 1553, 1552, 2580, 2580, 2580, 2580, 1499, 1497,
 /* 17750 */  1475, 1472, 1466, 1464, 1463, 1462, 1461, 2580, 1488, 2580,
 /* 17760 */  1557, 1556, 2580, 2580,   61, 1118, 2580, 2580, 1458,  609,
 /* 17770 */  2580, 2580, 1452, 1341, 1406, 2580, 1339, 1477, 1470, 1468,
 /* 17780 */  1465,  801,  790, 1454, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17790 */  2580,  872, 2580, 2580, 2580, 2580, 2580,  833, 2580, 2580,
 /* 17800 */  2580, 2580, 2580,  772,  750,  741,  726,  720, 1047, 2580,
 /* 17810 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17820 */   683, 2580,  667, 2580,  854,  882, 2580, 2580, 2580, 2580,
 /* 17830 */  2580,  784, 2580, 1452, 1341, 2580, 2580,   16, 2580, 2580,
 /* 17840 */  2580, 2580,  878,  879,  852, 2580,  819,  805, 1405, 1404,
 /* 17850 */   654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  566,  633,
 /* 17860 */   632, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  243,
 /* 17870 */  2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335, 2580,
 /* 17880 */  1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17890 */  2580, 2580, 2580, 1301, 1299, 2580, 1294, 2580, 2580, 2580,
 /* 17900 */  2580, 2580, 2580, 2580, 2580, 2580, 2580,  819,  805, 1405,
 /* 17910 */  1404,  654, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  566,
 /* 17920 */   633,  632, 1647, 1643, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17930 */  2580, 2580, 2580, 2580, 1347, 1342, 1338, 1337, 1336, 1335,
 /* 17940 */  2580, 1334, 1333, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 17950 */  2580, 1554, 1553, 1552, 1301, 1299, 2580, 1294, 1499, 1497,
 /* 17960 */  1475, 1472, 1466, 1464, 1463, 1462, 1461, 2580, 2580, 2580,
 /* 17970 */  2580, 2580, 2580, 2580,   61, 2580, 2580, 2580, 2580, 2580,
 /* 17980 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  151, 2580,
 /* 17990 */   420, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 18000 */  2580,  872, 2580, 2580, 2580, 2580, 2580,  833, 2580, 2580,
 /* 18010 */  2580, 2580, 2580,  772,  750,  741,  726,  720, 2580, 2580,
 /* 18020 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 18030 */   683, 2580,  667, 2580,  854,  882, 2580, 2580, 2580, 2580,
 /* 18040 */  2580,  784, 2580, 2580, 2580, 2580, 2580,   16, 2580, 1643,
 /* 18050 */  2580, 2580,  878,  879,  852, 2580, 2580, 2580, 2580, 2580,
 /* 18060 */  2580, 2580,  572, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 18070 */    38,  279,  715,  695,  252,  623,  557, 2580, 2580, 2580,
 /* 18080 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  619, 2580,
 /* 18090 */   622,  517, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 18100 */   218, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  459,  516,
 /* 18110 */   521, 2580, 2580, 2580,  151, 2580,  420, 2580, 2580, 2580,
 /* 18120 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 18130 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 18140 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 18150 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 18160 */  2580, 2580, 2580, 2580, 2580, 2580,  323,  334, 2580,  394,
 /* 18170 */  2580, 2580, 2580, 2580, 2580,  438,  602, 2580, 2580,  319,
 /* 18180 */   276,  278,  209, 2580, 2580, 2580, 2580, 2580,  572, 2580,
 /* 18190 */  2580, 2580, 2580, 2580, 2580, 2580,   38,  279,  715,  695,
 /* 18200 */   252,  623,  557, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 18210 */  2580, 2580, 2580, 2580,  619, 2580,  622,  517, 2580, 2580,
 /* 18220 */  2580, 2580, 2580, 2580, 2580, 2580,  218, 2580, 2580, 2580,
 /* 18230 */  2580, 2580, 2580, 2580,  459,  516,  521, 2580, 2580, 2580,
 /* 18240 */  1554, 1553, 1552, 2580, 2580, 2580, 2580, 1499, 1497, 1475,
 /* 18250 */  1472, 1466, 1464, 1463, 1462, 1461, 2580, 2580, 2580, 2580,
 /* 18260 */  2580, 2580, 2580,   62, 2580,  420, 2580, 2580, 2580, 2580,
 /* 18270 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 18280 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 18290 */   872, 2580,  323,  334, 2580,  394,  833, 2580, 2580, 2580,
 /* 18300 */  2580,  438,  602, 2580, 2580,  319,  276,  278,  209, 2580,
 /* 18310 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  683,
 /* 18320 */  2580,  667, 2580,  854,  882, 2580, 2580, 2580, 2580, 2580,
 /* 18330 */   784, 2580, 2580, 2580, 2580, 2580,   16, 2580, 2580, 2580,
 /* 18340 */  2580,  878,  879,  852, 2580,   38,  279, 2580, 2580, 1554,
 /* 18350 */  1553, 1552, 2580, 2580, 2580, 2580, 1499, 1497, 1475, 1472,
 /* 18360 */  1466, 1464, 1463, 1462, 1461, 2580, 2580, 2580, 2580, 2580,
 /* 18370 */  2580, 2580,   61, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 18380 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 18390 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  872,
 /* 18400 */  2580, 2580, 2580, 2580, 2580,  833, 2580, 2580, 2580, 2580,
 /* 18410 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,
 /* 18420 */  2580, 2580, 2580, 2580, 2580, 2580, 2580, 2580,  683, 2580,
 /* 18430 */   667, 2580,  854,  882, 2580, 2580, 2580, 2580, 2580,  784,
 /* 18440 */  2580, 2580, 2580, 2580, 2580,   16, 2580, 2580, 2580, 2580,
 /* 18450 */   878,  879,  852,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   268,  544,  545,  546,  547,  548,  549,  550,  551,  318,
 /*    10 */   319,  320,  321,  322,  323,  324,  325,  326,  327,  328,
 /*    20 */   329,  330,  330,  331,  333,  334,  335,  336,  337,  338,
 /*    30 */   339,  340,  341,  342,  343,  344,  317,  318,  319,  320,
 /*    40 */   321,  322,  323,  324,  325,  326,  327,  328,  356,   29,
 /*    50 */   318,  319,  320,  321,  322,  323,  324,  325,  326,  327,
 /*    60 */   328,  329,  330,   29,  329,  330,  334,  335,  336,  337,
 /*    70 */   338,  339,  340,  341,  342,  343,  344,  345,   30,  321,
 /*    80 */    32,  349,  330,  330,  392,  394,  395,   50,   51,  357,
 /*    90 */   358,  359,  360,  361,  362,    5,    6,    7,    8,    9,
 /*   100 */    10,   11,  433,  371,  349,  431,   16,  433,  434,  435,
 /*   110 */    55,   18,  357,  358,  359,  360,  361,  362,  383,  384,
 /*   120 */   385,  386,  593,  388,  389,   91,  394,  395,  393,  394,
 /*   130 */    96,  396,  397,  398,  399,  330,   43,   44,   45,   46,
 /*   140 */    47,   48,   49,  248,  249,  250,  251,  252,  416,  417,
 /*   150 */   418,  419,  420,  421,  422,  423,  424,  425,  426,   66,
 /*   160 */   112,  321,  430,  115,  116,  330,  118,  119,  120,  121,
 /*   170 */    80,  480,  481,  482,  317,  318,  319,  320,  321,  322,
 /*   180 */   323,  324,  325,  326,  327,  328,  495,  496,  497,  498,
 /*   190 */   499,  500,  387,  502,  503,  390,   37,   38,  466,  467,
 /*   200 */   468,  469,  470,  471,  472,   46,  515,  516,  268,  518,
 /*   210 */    67,  156,  480,  481,  482,  483,  484,  485,  486,  487,
 /*   220 */   488,  489,  433,  491,  492,  493,  494,  495,  496,  497,
 /*   230 */   498,  499,  500,  433,  502,  503,   93,  182,  183,  268,
 /*   240 */   185,  441,  149,  454,  455,  456,  514,  515,  516,  330,
 /*   250 */   518,  330,  520,  521,  522,  523,  524,  525,  318,  319,
 /*   260 */   320,  321,  322,  323,  324,  325,  326,  327,  328,  329,
 /*   270 */   330,  454,  455,  456,  334,  335,  336,  337,  338,  339,
 /*   280 */   340,  341,  342,  343,  344,  345,    2,    3,    4,  349,
 /*   290 */   545,  546,  547,  548,  549,  550,  551,  357,  358,  359,
 /*   300 */   360,  361,  362,   43,   44,   45,   46,   47,   48,   49,
 /*   310 */   217,  371,   52,  594,  595,  596,  345,  564,  565,  566,
 /*   320 */   349,  228,  229,  230,  231,  232,  233,   29,  357,  358,
 /*   330 */   359,  360,  361,  362,  394,  395,  317,  318,  319,  320,
 /*   340 */   321,  322,  323,  324,  325,  326,  327,  328,  598,  599,
 /*   350 */   600,  601,  602,  603,  604,  330,  416,  417,  418,  419,
 /*   360 */   420,  421,  422,  423,  424,  425,  426,   17,   18,   85,
 /*   370 */   430,  656,  319,  330,  321,  322,   26,  662,  663,  433,
 /*   380 */   635,   31,  329,  330,  626,  329,  330,  441,  335,   91,
 /*   390 */   337,  338,  339,  340,  341,  342,  343,  344,  321,   66,
 /*   400 */   454,  455,  456,  329,  330,  653,  466,  467,  468,  469,
 /*   410 */   470,  471,  472,   50,   51,  341,  342,  268,  329,  330,
 /*   420 */   480,  481,  482,  483,  484,  485,  486,  487,  488,  489,
 /*   430 */    67,  491,  492,  493,  494,  495,  496,  497,  498,  499,
 /*   440 */   500,  385,  502,  503,  388,  389,  611,  394,  395,  393,
 /*   450 */   394,  594,  595,  325,  514,  515,  516,  321,  518,  330,
 /*   460 */   520,  521,  522,  523,  524,  525,  626,  318,  319,  320,
 /*   470 */   321,  322,  323,  324,  325,  326,  327,  328,  329,  330,
 /*   480 */   406,  407,  408,  334,  335,  336,  337,  338,  339,  340,
 /*   490 */   341,  342,  343,  344,  345,  268,  325,  318,  349,   13,
 /*   500 */   529,  530,  323,  324,  325,  326,  357,  358,  359,  360,
 /*   510 */   361,  362,  376,  334,  329,  330,  387,  338,   16,  390,
 /*   520 */   371,  468,  469,  470,  471,  472,  605,  606,  153,  330,
 /*   530 */   611,  332,  611,  480,  481,  482,  548,  549,  550,  551,
 /*   540 */   330,   73,  554,  394,  395,  557,  558,  559,  495,  496,
 /*   550 */   497,  498,  499,  500,   52,  502,  503,  182,  183,   50,
 /*   560 */    51,   75,  187,   37,   38,  416,   40,   41,  515,  516,
 /*   570 */   385,  518,  345,  388,  389,   66,  349,   68,  393,  394,
 /*   580 */   319,  330,  321,  322,  357,  358,  359,  360,  361,  362,
 /*   590 */   329,  330,  393,  394,   50,   51,  335,  547,  337,  338,
 /*   600 */   339,  340,  341,  342,  343,  344,  536,  537,  538,  539,
 /*   610 */   329,  330,  237,  594,  595,  466,  467,  468,  469,  470,
 /*   620 */   471,  472,  341,  342,  122,  268,  427,  428,   29,  480,
 /*   630 */   481,  482,  483,  484,  485,  486,  487,  488,  489,   55,
 /*   640 */   491,  492,  493,  494,  495,  496,  497,  498,  499,  500,
 /*   650 */   330,  502,  503,  474,  611,  394,  395,  148,  149,  462,
 /*   660 */   330,  331,  465,  514,  515,  516,   67,  518,  643,  520,
 /*   670 */   521,  522,  523,  524,  525,  318,  319,  320,  321,  322,
 /*   680 */   323,  324,  325,  326,  327,  328,  329,  330,  407,  408,
 /*   690 */    91,  334,  335,  336,  337,  338,  339,  340,  341,  342,
 /*   700 */   343,  344,  345,  626,  627,  577,  349,  330,  631,  632,
 /*   710 */   633,  634,  433,  542,  357,  358,  359,  360,  361,  362,
 /*   720 */   441,  568,  329,  330,  571,  572,  329,  330,  371,  468,
 /*   730 */   469,  470,  471,  472,  455,   13,  583,  153,  154,  330,
 /*   740 */   156,  480,  481,  482,    6,    7,    8,    9,   10,   11,
 /*   750 */   153,  394,  395,   91,   16,   93,  495,  496,  497,  498,
 /*   760 */   499,  500,  591,  502,  503,  330,  182,  183,  330,  185,
 /*   770 */   332,  187,  228,  416,  190,   26,  515,  516,  385,  518,
 /*   780 */    31,  388,  389,   61,  187,  188,  393,  394,   39,  317,
 /*   790 */   318,  319,  320,  321,  322,  323,  324,  325,  326,  327,
 /*   800 */   328,  317,  318,  319,  320,  321,  322,  323,  324,  325,
 /*   810 */   326,  327,  328,  562,  318,  564,  565,  566,   80,  323,
 /*   820 */   324,  325,  326,  466,  467,  468,  469,  470,  471,  472,
 /*   830 */   334,  393,  394,   33,  237,  238,  433,  480,  481,  482,
 /*   840 */   483,  484,  485,  486,  487,  488,  489,  330,  491,  492,
 /*   850 */   493,  494,  495,  496,  497,  498,  499,  500,  455,  502,
 /*   860 */   503,  531,  532,  533,  534,  427,  428,  657,  658,  659,
 /*   870 */    70,  514,  515,  516,   74,  518,  556,  520,  521,  522,
 /*   880 */   523,  524,  525,   29,  318,  319,  320,  321,  322,  323,
 /*   890 */   324,  325,  326,  327,  328,  329,  330,   66,   75,   68,
 /*   900 */   334,  335,  336,  337,  338,  339,  340,  341,  342,  343,
 /*   910 */   344,    6,    7,    8,    9,   37,   38,  330,  331,  330,
 /*   920 */   331,   43,   44,   45,   46,   47,   48,   49,   50,   51,
 /*   930 */    52,   53,   54,   55,   56,   57,   58,  371,  321,   37,
 /*   940 */    38,   39,   40,   41,   66,   91,   68,  317,  318,  319,
 /*   950 */   320,  321,  322,  323,  324,  325,  326,  327,  328,  318,
 /*   960 */   394,  395,   60,   29,  323,  324,  325,  326,  402,  115,
 /*   970 */   404,   93,   32,  321,   34,  334,   36,   99,   38,  148,
 /*   980 */   149,  348,  416,  417,  418,  419,  420,  421,  422,  423,
 /*   990 */   424,  425,  426,  376,  116,   66,  430,   68,  115,   34,
 /*  1000 */   122,   36,  124,   38,  126,  127,   77,   67,  130,  131,
 /*  1010 */   132,  133,  134,  135,  136,  137,  138,  139,   43,   44,
 /*  1020 */    45,  644,  144,  145,  146,  147,  148,  149,  376,   54,
 /*  1030 */   329,  330,  466,  567,  468,  469,  470,  471,  472,  573,
 /*  1040 */   574,   29,  341,  342,  578,  579,  480,  481,  482,  115,
 /*  1050 */   484,  485,  486,  487,  488,  489,   91,  648,  492,  493,
 /*  1060 */   494,  495,  496,  497,  498,  499,  500,  595,  502,  503,
 /*  1070 */   586,  546,  547,  548,  549,  550,  551,  148,  149,   67,
 /*  1080 */   330,  515,  516,  648,  518,  277,  520,  521,  522,  523,
 /*  1090 */   524,  283,  318,  319,  320,  321,  322,  323,  324,  325,
 /*  1100 */   326,  327,  328,  329,  330,   93,  329,  330,  334,  335,
 /*  1110 */   336,  337,  338,  339,  340,  341,  342,  343,  344,  132,
 /*  1120 */   531,  532,  533,  534,  380,   43,   44,   45,   46,   47,
 /*  1130 */    48,   49,   50,   51,   52,   53,   54,   55,   56,   57,
 /*  1140 */    58,  154,  262,   50,   51,  371,  650,  403,   66,   16,
 /*  1150 */    17,   18,   19,   20,   21,   22,   23,   24,   25,   66,
 /*  1160 */    27,  644,  385,  330,  331,  388,  389,  330,  394,  395,
 /*  1170 */   393,  394,   26,  441,  473,   93,  402,   31,  404,  330,
 /*  1180 */   331,   99,  655,   37,   38,   39,   40,   41,  355,  356,
 /*  1190 */   416,  417,  418,  419,  420,  421,  422,  423,  424,  425,
 /*  1200 */   426,  214,   50,   51,  430,  553,   60,   43,   44,  222,
 /*  1210 */   223,  224,  225,   67,  513,  133,  586,  321,   66,   37,
 /*  1220 */    38,  139,   40,   41,  330,  331,  144,  145,  146,  438,
 /*  1230 */   439,  440,  441,  442,  443,  444,  445,  446,  447,  448,
 /*  1240 */   466,  567,  468,  469,  470,  471,  472,  573,  574,   67,
 /*  1250 */   356,  330,  578,  579,  480,  481,  482,  330,  484,  485,
 /*  1260 */   486,  487,  488,  489,   28,   55,  492,  493,  494,  495,
 /*  1270 */   496,  497,  498,  499,  500,   66,  502,  503,  535,  536,
 /*  1280 */   537,  538,  539,   73,   37,   38,   13,   40,   41,  515,
 /*  1290 */   516,  650,  518,  477,  520,  521,  522,  523,  524,  329,
 /*  1300 */   330,  318,  319,  320,  321,  322,  323,  324,  325,  326,
 /*  1310 */   327,  328,  329,  330,   67,  565,  566,  334,  335,  336,
 /*  1320 */   337,  338,  339,  340,  341,  342,  343,  344,  431,  432,
 /*  1330 */   433,  330,   37,   38,  660,   40,   43,   44,   43,   44,
 /*  1340 */    45,   46,   47,   48,   49,   50,   51,   52,   53,   54,
 /*  1350 */    55,   56,   57,   58,  371,   82,   37,   38,  560,   40,
 /*  1360 */    41,   66,  612,  567,   50,   51,  156,  329,  330,  573,
 /*  1370 */   574,   29,  329,  330,  578,  579,   15,  394,  395,  341,
 /*  1380 */   342,  532,  533,  534,   70,  402,   67,  404,   93,  433,
 /*  1390 */   592,   49,  182,  183,   99,  185,   82,   78,  330,  416,
 /*  1400 */   417,  418,  419,  420,  421,  422,  423,  424,  425,  426,
 /*  1410 */   454,  116,  456,  430,   50,   51,  325,  122,  330,  124,
 /*  1420 */    46,  126,  127,  329,  330,  130,  131,  132,  133,  134,
 /*  1430 */   135,  136,  137,  138,  139,  341,  342,   33,  654,  144,
 /*  1440 */   145,  146,  147,  380,  636,  637,  408,  409,  611,  466,
 /*  1450 */   652,  468,  469,  470,  471,  472,  114,  661,  618,  619,
 /*  1460 */   620,  621,  622,  480,  481,  482,  403,  484,  485,  486,
 /*  1470 */   487,  488,  489,  180,  181,  492,  493,  494,  495,  496,
 /*  1480 */   497,  498,  499,  500,  268,  502,  503,  434,  435,  548,
 /*  1490 */   549,  550,  551,   37,   38,  554,   40,   41,  515,  516,
 /*  1500 */   559,  518,  321,  520,  521,  522,  523,  524,   88,  318,
 /*  1510 */   319,  320,  321,  322,  323,  324,  325,  326,  327,  328,
 /*  1520 */   329,  330,  626,   67,  628,  334,  335,  336,  337,  338,
 /*  1530 */   339,  340,  341,  342,  343,  344,  321,  117,  611,  197,
 /*  1540 */   198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
 /*  1550 */   208,  209,  210,  211,  212,  213,   50,   51,  330,  330,
 /*  1560 */   156,  345,  371,  159,  643,  349,  565,  473,  330,  149,
 /*  1570 */   329,  330,   66,  357,  358,  359,  360,  361,  362,  215,
 /*  1580 */    34,  217,   36,   77,   38,  394,  395,   81,  214,   26,
 /*  1590 */   226,  376,  228,  402,   31,  404,  330,   62,  330,  179,
 /*  1600 */    37,   38,   39,   40,   41,  511,  512,  416,  417,  418,
 /*  1610 */   419,  420,  421,  422,  423,  424,  425,  426,  380,   50,
 /*  1620 */    51,  430,   53,   60,  556,  384,  385,  386,  390,  388,
 /*  1630 */   389,  329,  330,  542,  393,  394,  330,  396,  397,  398,
 /*  1640 */   399,  403,    6,    7,    8,    9,   10,   11,   12,  114,
 /*  1650 */   230,  462,   16,  565,  465,  235,  121,  466,  325,  468,
 /*  1660 */   469,  470,  471,  472,  535,  536,  537,  538,  539,   33,
 /*  1670 */   250,  480,  481,  482,   13,  484,  485,  486,  487,  488,
 /*  1680 */   489,  146,  591,  492,  493,  494,  495,  496,  497,  498,
 /*  1690 */   499,  500,   26,  502,  503,  268,  156,   31,   37,   38,
 /*  1700 */   612,   40,   41,  163,  164,   39,  515,  516,  330,  518,
 /*  1710 */   332,  520,  521,  522,  523,  524,   80,  330,  318,  319,
 /*  1720 */   320,  321,  322,  323,  324,  325,  326,  327,  328,  329,
 /*  1730 */   330,   50,   51,   67,  334,  335,  336,  337,  338,  339,
 /*  1740 */   340,  341,  342,  343,  344,  367,  530,  330,  331,   37,
 /*  1750 */    38,   70,  217,   72,   16,   43,   44,   45,   46,   47,
 /*  1760 */    48,   49,   50,   51,   52,   53,   54,   55,   56,   57,
 /*  1770 */    58,  371,  345,  356,  239,  240,  349,  242,   66,   37,
 /*  1780 */    38,  330,   40,   41,  357,  358,  359,  360,  361,  362,
 /*  1790 */     2,    3,    4,  565,  394,  395,  319,   39,  321,  322,
 /*  1800 */   329,  330,  402,  563,  404,   93,  625,  626,  627,   67,
 /*  1810 */   330,   99,  335,   50,   51,  338,  416,  417,  418,  419,
 /*  1820 */   420,  421,  422,  423,  424,  425,  426,    9,  116,  527,
 /*  1830 */   430,  565,    5,   70,  122,  606,  124,  597,  126,  127,
 /*  1840 */   611,  613,  130,  131,  132,  133,  134,  135,  136,  137,
 /*  1850 */   138,  139,  623,  141,   13,   67,  144,  145,  146,  147,
 /*  1860 */    33,   37,   38,   75,   40,   41,  466,  325,  468,  469,
 /*  1870 */   470,  471,  472,   85,  476,  330,  331,  268,   90,  613,
 /*  1880 */   480,  481,  482,  125,  484,  485,  486,  487,  488,  489,
 /*  1890 */   325,   67,  492,  493,  494,  495,  496,  497,  498,  499,
 /*  1900 */   500,  356,  502,  503,  535,  536,  537,  538,  539,  319,
 /*  1910 */   577,  321,  322,  330,  331,  515,  516,   76,  518,  651,
 /*  1920 */   520,  521,  522,  523,  524,  335,  318,  319,  320,  321,
 /*  1930 */   322,  323,  324,  325,  326,  327,  328,  329,  330,  330,
 /*  1940 */   331,  380,  334,  335,  336,  337,  338,  339,  340,  341,
 /*  1950 */   342,  343,  344,  215,  345,  217,  479,  651,  349,  330,
 /*  1960 */    50,   51,   50,   51,  403,  356,  357,  358,  359,  360,
 /*  1970 */   361,  362,  329,  330,   50,   51,  329,  330,   66,  371,
 /*  1980 */   140,   43,   44,  156,  341,  342,  159,  433,  341,  342,
 /*  1990 */    66,  141,   68,  143,  154,  441,  441,  170,   60,   50,
 /*  2000 */    51,   77,  394,  395,  186,   81,  166,  556,  168,  454,
 /*  2010 */   402,  456,  404,  173,  330,   66,  176,  177,  431,  432,
 /*  2020 */   433,   88,   67,  347,  416,  417,  418,  419,  420,  421,
 /*  2030 */   422,  423,  424,  425,  426,  648,  329,  330,  430,   37,
 /*  2040 */    38,  348,   40,   41,   39,  318,  319,  320,  321,  322,
 /*  2050 */   323,  324,  325,  326,  327,  328,  329,  330,  454,  455,
 /*  2060 */   456,  334,  335,  336,  337,  338,  339,  340,  341,  342,
 /*  2070 */   343,  344,  148,  149,  466,  610,  468,  469,  470,  471,
 /*  2080 */   472,   76,  149,  319,  146,  321,  322,  132,  480,  481,
 /*  2090 */   482,  415,  484,  485,  486,  487,  488,  489,  371,  335,
 /*  2100 */   492,  493,  494,  495,  496,  497,  498,  499,  500,  154,
 /*  2110 */   502,  503,  179,  348,   37,   38,  473,   40,   41,  577,
 /*  2120 */   473,  394,  395,  515,  516,  215,  518,  217,  520,  521,
 /*  2130 */   522,  523,  524,  653,   37,   38,  226,   40,   41,   43,
 /*  2140 */    44,   45,  577,  416,  417,  418,  419,  420,  421,  422,
 /*  2150 */   423,  424,  425,  426,  511,  512,  277,  430,  511,  512,
 /*  2160 */   329,  330,  283,  230,   67,  431,  432,  433,  235,  214,
 /*  2170 */    19,   29,  341,  342,   46,   78,   75,  222,  223,  224,
 /*  2180 */   225,   50,   51,  250,  431,  432,  433,   37,   38,   61,
 /*  2190 */    40,   41,  141,  466,  143,  468,  469,  470,  471,  472,
 /*  2200 */   236,   70,  506,   72,   53,  268,  510,  480,  481,  482,
 /*  2210 */   321,  484,  485,  486,  487,  488,  489,   67,   40,  492,
 /*  2220 */   493,  494,  495,  496,  497,  498,  499,  500,  325,  502,
 /*  2230 */   503,  330,  331,   91,  527,   93,  223,  224,  225,  649,
 /*  2240 */    62,   63,  515,  516,  330,  518,  332,  520,  521,  522,
 /*  2250 */   523,  524,  318,  319,  320,  321,  322,  323,  324,  325,
 /*  2260 */   326,  327,  328,  329,  330,  376,  329,  330,  334,  335,
 /*  2270 */   336,  337,  338,  339,  340,  341,  342,  343,  344,  235,
 /*  2280 */    37,   38,  345,   40,   41,  322,  349,  658,  659,   37,
 /*  2290 */    38,  325,   40,   41,  357,  358,  359,  360,  361,  362,
 /*  2300 */   329,  330,  325,   53,  473,  371,  330,  331,  329,  330,
 /*  2310 */    67,  375,  341,  342,  378,  214,   66,   59,   68,   67,
 /*  2320 */   325,  384,  385,  386,   66,  388,  389,   77,  394,  395,
 /*  2330 */   393,  394,  356,  396,  397,  398,  399,  653,  645,  646,
 /*  2340 */   647,  325,  511,  512,  325,  506,  195,  508,   50,   51,
 /*  2350 */   416,  417,  418,  419,  420,  421,  422,  423,  424,  425,
 /*  2360 */   426,  431,  261,  433,  430,  330,  331,   13,   70,  218,
 /*  2370 */   219,  318,  319,  320,  321,  322,  323,  324,  325,  326,
 /*  2380 */   327,  328,  329,  330,  329,  330,  330,  334,  335,  336,
 /*  2390 */   337,  338,  339,  340,  341,  342,  343,  344,  148,  149,
 /*  2400 */   466,  441,  468,  469,  470,  471,  472,  321,   43,   44,
 /*  2410 */   645,  646,  647,  649,  480,  481,  482,  457,  484,  485,
 /*  2420 */   486,  487,  488,  489,  371,  325,  492,  493,  494,  495,
 /*  2430 */   496,  497,  498,  499,  500,   13,  502,  503,  329,  330,
 /*  2440 */   597,  552,  553,  387,  473,   29,  390,  394,  395,  515,
 /*  2450 */   516,  153,  518,   40,  520,  521,  522,  523,  524,  330,
 /*  2460 */   331,   39,  376,   50,   51,  319,   13,  321,  322,  416,
 /*  2470 */   417,  418,  419,  420,  421,  422,  423,  424,  425,  426,
 /*  2480 */   577,  335,   60,  430,  338,  356,    9,  329,  330,   67,
 /*  2490 */   322,  330,  331,  384,  385,  386,  142,  388,  389,  341,
 /*  2500 */   342,   28,  393,  394,  541,  396,  397,  398,  399,   14,
 /*  2510 */    15,  146,   96,  319,  441,  321,  322,  356,  348,  466,
 /*  2520 */    67,  468,  469,  470,  471,  472,  329,  330,  268,  335,
 /*  2530 */   457,  115,  338,  480,  481,  482,  433,  484,  485,  486,
 /*  2540 */   487,  488,  489,  577,  441,  492,  493,  494,  495,  496,
 /*  2550 */   497,  498,  499,  500,  577,  502,  503,  454,  431,  456,
 /*  2560 */   433,  542,   67,  329,  330,   29,  408,  322,  515,  516,
 /*  2570 */   155,  518,  577,  520,  521,  522,  523,  524,  318,  319,
 /*  2580 */   320,  321,  322,  323,  324,  325,  326,  327,  328,  329,
 /*  2590 */   330,   14,   15,  577,  334,  335,  336,  337,  338,  339,
 /*  2600 */   340,  341,  342,  343,  344,  345,  330,  330,  331,  349,
 /*  2610 */   591,  330,  331,   39,  330,  331,   13,  357,  358,  359,
 /*  2620 */   360,  361,  362,  329,  330,  479,   26,   91,   39,  629,
 /*  2630 */   630,   31,   96,  356,   60,  341,  342,  356,  432,   39,
 /*  2640 */   356,   67,  542,  319,  268,  321,  322,  161,  162,   60,
 /*  2650 */   322,  115,   50,   51,  394,  395,   67,  180,   26,  335,
 /*  2660 */    39,  246,  338,   31,  616,  617,  322,   67,  191,  149,
 /*  2670 */    67,   39,   70,  479,  570,  260,  416,  372,  373,   46,
 /*  2680 */    47,   60,  570,  113,  114,  581,  582,   54,   67,  429,
 /*  2690 */    39,  591,  570,  581,  582,  319,  322,  321,  322,  179,
 /*  2700 */   157,  158,  432,  581,  582,  329,  330,   13,  454,  541,
 /*  2710 */   456,  335,  348,  337,  338,  339,  340,  341,  342,  343,
 /*  2720 */   344,  345,  489,  490,   33,  349,  466,   76,  468,  469,
 /*  2730 */   470,  471,  472,  357,  358,  359,  360,  361,  362,   13,
 /*  2740 */   480,  481,  482,   62,  484,  485,  486,  487,  488,  489,
 /*  2750 */   230,   32,  492,  493,  494,  495,  496,  497,  498,  499,
 /*  2760 */   500,   67,  502,  503,  347,   60,   60,  473,  255,  256,
 /*  2770 */   394,  395,   67,   67,   13,  515,  516,   13,  518,   32,
 /*  2780 */   520,  521,  522,  523,  524,  348,  541,   61,  318,  319,
 /*  2790 */   320,  321,  322,  323,  324,  325,  326,  327,  328,  329,
 /*  2800 */   330,  393,  394,  479,  334,  335,  336,  337,  338,  339,
 /*  2810 */   340,  341,  342,  343,  344,   60,   40,   41,  393,  394,
 /*  2820 */   157,  158,   67,  372,  373,  431,   13,  433,   67,   13,
 /*  2830 */    13,   67,  415,  454,  364,  456,  117,   90,  368,  369,
 /*  2840 */   370,  371,  382,  467,  468,  469,  470,  471,  472,  431,
 /*  2850 */   348,  433,  393,  394,  372,  373,  480,  481,  482,  431,
 /*  2860 */   455,  433,  181,  458,  394,  395,   36,  330,   38,  541,
 /*  2870 */   410,  495,  496,  497,  498,  499,  500,   13,  502,  503,
 /*  2880 */    67,  246,   60,   13,   67,  541,  416,  611,   72,   67,
 /*  2890 */   514,  515,  516,  455,  518,  260,  458,  352,  353,   62,
 /*  2900 */   318,  319,  320,  321,  322,  323,  324,  325,  326,  327,
 /*  2910 */   328,  329,  330,   39,  366,  541,  334,  335,  336,  337,
 /*  2920 */   338,  339,  340,  341,  342,  343,  344,  379,   13,   13,
 /*  2930 */   431,   67,  433,   13,   60,   13,  466,   67,  468,  469,
 /*  2940 */   470,  471,  472,   13,  352,  353,  454,  381,  456,   13,
 /*  2950 */   480,  481,  482,  371,  484,  485,  486,  487,  488,  489,
 /*  2960 */    39,  380,  492,  493,  494,  495,  496,  497,  498,  499,
 /*  2970 */   500,  405,  502,  503,   13,   91,  394,  395,  184,  185,
 /*  2980 */   441,   60,   67,   67,  403,  515,  516,   67,  518,   67,
 /*  2990 */   520,  521,  522,  523,  524,   13,  457,   67,  416,  115,
 /*  3000 */   454,   39,  456,   67,  352,  353,  431,   26,  433,   39,
 /*  3010 */   455,  505,   31,  458,  508,  319,   39,  321,  322,  454,
 /*  3020 */   348,  456,  329,  330,   13,  329,  330,   29,   67,   67,
 /*  3030 */    60,  335,  325,  337,  338,  339,  340,  341,  342,  343,
 /*  3040 */   344,  330,   13,  332,   67,   13,  187,  188,  466,   67,
 /*  3050 */   468,  469,  470,  471,  472,  323,  433,  325,  435,  433,
 /*  3060 */   434,  330,  480,  481,  482,   67,  484,  485,  486,  487,
 /*  3070 */   488,  489,  235,  569,  492,  493,  494,  495,  496,  497,
 /*  3080 */   498,  499,  500,   13,  502,  503,  504,   76,  366,  507,
 /*  3090 */   394,  395,  510,  330,  331,  330,   67,  515,  516,   67,
 /*  3100 */   518,  379,  520,  521,  522,  523,  524,  318,  319,  320,
 /*  3110 */   321,  322,  323,  324,  325,  326,  327,  328,  329,  330,
 /*  3120 */   330,  390,   67,  334,  335,  336,  337,  338,  339,  340,
 /*  3130 */   341,  342,  343,  344,   62,   63,   67,   67,  346,  641,
 /*  3140 */   642,   29,  350,  589,  590,   69,   91,   71,  400,  401,
 /*  3150 */   187,  188,   62,   63,   29,  390,   28,   29,   33,   65,
 /*  3160 */   371,  234,   93,   67,  468,  469,  470,  471,  472,   91,
 /*  3170 */   555,   13,   86,   87,   96,  348,  480,  481,  482,   67,
 /*  3180 */   390,   29,   46,  394,  395,   46,   47,   91,   96,   85,
 /*  3190 */   653,  495,  496,  497,  498,  499,  500,  325,  502,  503,
 /*  3200 */   195,  196,   72,   73,  346,  416,   66,  115,  329,  330,
 /*  3210 */   391,  515,  516,  432,  518,  441,  433,  184,  639,  318,
 /*  3220 */   319,  320,  321,  322,  323,  324,  325,  326,  327,  328,
 /*  3230 */   329,  330,  555,  110,  463,  334,  335,  336,  337,  338,
 /*  3240 */   339,  340,  341,  342,  343,  344,   88,   66,   96,  542,
 /*  3250 */   580,  129,  432,  478,  128,  466,  463,  468,  469,  470,
 /*  3260 */   471,  472,  475,  555,   66,  463,  588,  441,   45,  480,
 /*  3270 */   481,  482,  371,  484,  485,  486,  487,  488,  489,  322,
 /*  3280 */   325,  492,  493,  494,  495,  496,  497,  498,  499,  500,
 /*  3290 */   501,  502,  503,  116,  489,  394,  395,  325,  555,  610,
 /*  3300 */   555,  114,   91,  325,  515,  516,  609,  518,  608,  520,
 /*  3310 */   521,  522,  523,  524,  525,  221,  455,  416,  230,  647,
 /*  3320 */   607,  232,  171,  543,   65,  354,  433,  617,  235,  617,
 /*  3330 */    73,  377,  433,  555,  348,  319,  455,  321,  322,  348,
 /*  3340 */    29,  614,  146,  575,  615,  329,  330,  116,   75,  624,
 /*  3350 */   348,  335,   60,  337,  338,  339,  340,  341,  342,  343,
 /*  3360 */   344,  576,   74,  597,  374,  325,  325,  466,   60,  468,
 /*  3370 */   469,  470,  471,  472,  437,  547,  555,   67,   66,   66,
 /*  3380 */   363,  480,  481,  482,  561,  484,  485,  486,  487,  488,
 /*  3390 */   489,   67,  330,  492,  493,  494,  495,  496,  497,  498,
 /*  3400 */   499,  500,  501,  502,  503,   76,   67,  330,  348,   78,
 /*  3410 */   394,  395,  330,   43,  414,   66,  515,  516,   67,  518,
 /*  3420 */    67,  520,  521,  522,  523,  524,  525,  318,  319,  320,
 /*  3430 */   321,  322,  323,  324,  325,  326,  327,  328,  329,  330,
 /*  3440 */   330,  330,  412,  334,  335,  336,  337,  338,  339,  340,
 /*  3450 */   341,  342,  343,  344,   66,   43,   67,  330,  433,  330,
 /*  3460 */    59,  363,   12,  330,   13,  434,   67,   67,  363,    5,
 /*  3470 */   587,  330,   67,  330,  330,   85,  433,  330,  369,  370,
 /*  3480 */   371,   13,   33,  330,  468,  469,  470,  471,  472,   79,
 /*  3490 */    66,  435,   79,  351,  363,   79,  480,  481,  482,   60,
 /*  3500 */   351,  321,  435,  394,  395,   78,   89,    5,  351,   72,
 /*  3510 */    13,  495,  496,  497,  498,  499,  500,   61,  502,  503,
 /*  3520 */   330,  434,   67,  321,  365,  416,  241,  330,   13,  363,
 /*  3530 */   189,  515,  516,   66,  518,  363,   67,   67,  638,  540,
 /*  3540 */     5,   61,  640,   60,  189,  400,  318,  319,  320,  321,
 /*  3550 */   322,  323,  324,  325,  326,  327,  328,  329,  330,   66,
 /*  3560 */   439,  582,  334,  335,  336,  337,  338,  339,  340,  341,
 /*  3570 */   342,  343,  344,  455,   66,  466,  642,  468,  469,  470,
 /*  3580 */   471,  472,  123,  590,  191,  400,  592,   38,  256,  480,
 /*  3590 */   481,  482,   13,  484,  485,  486,  487,  488,  489,  371,
 /*  3600 */   592,  492,  493,  494,  495,  496,  497,  498,  499,  500,
 /*  3610 */   180,  502,  503,  184,   96,   65,  141,    5,   74,   12,
 /*  3620 */    64,   39,  394,  395,  515,  516,   13,  518,   67,  520,
 /*  3630 */   521,  522,  523,  524,   67,   76,   67,   80,    5,  411,
 /*  3640 */    67,  413,   82,   73,  416,   67,   50,   51,   52,   53,
 /*  3650 */    54,   55,   56,   57,   58,   83,   67,   66,  149,   66,
 /*  3660 */    84,   67,   66,   39,   66,   15,   66,  329,  330,  235,
 /*  3670 */    59,   33,   12,   52,  123,  337,  338,  339,  340,  341,
 /*  3680 */   342,  343,  344,   67,   67,  175,  174,   90,  111,   93,
 /*  3690 */    67,   66,   60,   67,  466,   99,  468,  469,  470,  471,
 /*  3700 */   472,   61,   66,   72,   67,   66,   13,   66,  480,  481,
 /*  3710 */   482,   67,  484,  485,  486,  487,  488,  489,   75,   67,
 /*  3720 */   492,  493,  494,  495,  496,  497,  498,  499,  500,  133,
 /*  3730 */   502,  503,  394,  395,   67,  139,   12,  243,   60,  263,
 /*  3740 */   144,  145,  146,  515,  516,   66,  518,  325,  520,  521,
 /*  3750 */   522,  523,  524,  318,  319,  320,  321,  322,  323,  324,
 /*  3760 */   325,  326,  327,  328,  329,  330,   66,   13,  180,  334,
 /*  3770 */   335,  336,  337,  338,  339,  340,  341,  342,  343,  344,
 /*  3780 */    67,  167,   66,   66,  133,   67,  167,  216,  261,  155,
 /*  3790 */    59,   15,   67,   67,   66,  165,   67,   67,   90,   67,
 /*  3800 */    67,  156,  184,   60,   67,   60,  371,  165,   67,  113,
 /*  3810 */    66,   92,   66,   90,   66,  160,   66,   61,  480,  481,
 /*  3820 */   482,  172,  193,   66,  240,   53,   67,   12,   59,  394,
 /*  3830 */   395,   67,   66,  495,  496,  497,  498,  499,  500,   13,
 /*  3840 */   502,  503,  140,  133,   67,   67,   67,   72,   88,   66,
 /*  3850 */   235,  416,   78,  515,  516,  235,  518,   76,  193,   59,
 /*  3860 */    67,   66,   65,  228,   39,  318,  319,  320,  321,  322,
 /*  3870 */   323,  324,  325,  326,  327,  328,  329,  330,  230,   67,
 /*  3880 */   165,  334,  335,  336,  337,  338,  339,  340,  341,  342,
 /*  3890 */   343,  344,   12,   65,   67,   66,   13,   80,   67,   66,
 /*  3900 */   191,  466,   67,  468,  469,  470,  471,  472,   66,   65,
 /*  3910 */   216,  140,   66,   74,  153,  480,  481,  482,  371,  484,
 /*  3920 */   485,  486,  487,  488,  489,   67,   74,  492,  493,  494,
 /*  3930 */   495,  496,  497,  498,  499,  500,   59,  502,  503,   74,
 /*  3940 */   142,  394,  395,   67,   66,   66,   12,   66,   66,   76,
 /*  3950 */   515,  516,  517,  518,  519,  520,  521,  522,  523,  524,
 /*  3960 */    67,   70,  220,  416,   67,   66,   66,   19,   67,   67,
 /*  3970 */    72,   67,   76,   13,  185,  228,   67,   67,   19,   66,
 /*  3980 */    66,   66,   66,   65,   67,   74,   67,   12,   66,  227,
 /*  3990 */   180,   66,   13,   13,   67,  157,   15,  189,  235,   52,
 /*  4000 */    76,  152,   67,  216,   76,   60,   69,  148,   72,   66,
 /*  4010 */    66,  664,  664,  466,  664,  468,  469,  470,  471,  472,
 /*  4020 */   664,  664,  664,  664,  664,  664,  268,  480,  481,  482,
 /*  4030 */   664,  484,  485,  486,  487,  488,  489,  664,  664,  492,
 /*  4040 */   493,  494,  495,  496,  497,  498,  499,  500,  501,  502,
 /*  4050 */   503,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4060 */   664,  664,  515,  516,  664,  518,  664,  520,  521,  522,
 /*  4070 */   523,  524,  525,  318,  319,  320,  321,  322,  323,  324,
 /*  4080 */   325,  326,  327,  328,  329,  330,  664,  329,  330,  334,
 /*  4090 */   335,  336,  337,  338,  339,  340,  341,  342,  343,  344,
 /*  4100 */   664,  664,  664,  345,  664,  664,  664,  349,  664,  664,
 /*  4110 */   664,  664,  664,  664,  664,  357,  358,  359,  360,  361,
 /*  4120 */   362,  664,  664,  664,  664,  664,  371,  664,  664,  664,
 /*  4130 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4140 */   664,  664,  384,  385,  386,  664,  388,  389,  664,  394,
 /*  4150 */   395,  393,  394,  664,  396,  397,  398,  399,  664,  664,
 /*  4160 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4170 */   664,  416,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4180 */   664,  664,  664,  664,  664,  318,  319,  320,  321,  322,
 /*  4190 */   323,  324,  325,  326,  327,  328,  329,  330,  664,  664,
 /*  4200 */   664,  334,  335,  336,  337,  338,  339,  340,  341,  342,
 /*  4210 */   343,  344,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4220 */   664,  466,  664,  468,  469,  470,  471,  472,  664,  664,
 /*  4230 */   664,  664,  664,  664,  664,  480,  481,  482,  371,  484,
 /*  4240 */   485,  486,  487,  488,  489,  664,  664,  492,  493,  494,
 /*  4250 */   495,  496,  497,  498,  499,  500,  664,  502,  503,  664,
 /*  4260 */   664,  394,  395,  664,  664,  664,  664,  664,  664,  664,
 /*  4270 */   515,  516,  664,  518,  664,  520,  521,  522,  523,  524,
 /*  4280 */   525,  664,  664,  416,  664,  664,  664,  664,  664,  664,
 /*  4290 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4300 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4310 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4320 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4330 */   664,  664,  664,  466,  664,  468,  469,  470,  471,  472,
 /*  4340 */   664,  664,  664,  664,  664,  664,  664,  480,  481,  482,
 /*  4350 */   664,  484,  485,  486,  487,  488,  489,  664,  664,  492,
 /*  4360 */   493,  494,  495,  496,  497,  498,  499,  500,  664,  502,
 /*  4370 */   503,  664,  664,  664,  664,  664,  509,  664,  664,  664,
 /*  4380 */   664,  664,  515,  516,  664,  518,  664,  520,  521,  522,
 /*  4390 */   523,  524,  318,  319,  320,  321,  322,  323,  324,  325,
 /*  4400 */   326,  327,  328,  329,  330,  664,  664,  664,  334,  335,
 /*  4410 */   336,  337,  338,  339,  340,  341,  342,  343,  344,  664,
 /*  4420 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4430 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4440 */   664,  664,  664,  664,  664,  371,  664,  664,  664,  664,
 /*  4450 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4460 */   664,  664,  664,  664,  664,  664,  664,  664,  394,  395,
 /*  4470 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4480 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4490 */   416,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4500 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4510 */   664,  318,  319,  320,  321,  322,  323,  324,  325,  326,
 /*  4520 */   327,  328,  329,  330,  664,  664,  664,  334,  335,  336,
 /*  4530 */   337,  338,  339,  340,  341,  342,  343,  344,  664,  664,
 /*  4540 */   466,  664,  468,  469,  470,  471,  472,  664,  664,  664,
 /*  4550 */   664,  664,  664,  664,  480,  481,  482,  664,  484,  485,
 /*  4560 */   486,  487,  488,  489,  371,  664,  492,  493,  494,  495,
 /*  4570 */   496,  497,  498,  499,  500,  664,  502,  503,  664,  664,
 /*  4580 */   664,  664,  664,  664,  664,  664,  664,  394,  395,  515,
 /*  4590 */   516,  664,  518,  664,  520,  521,  522,  523,  524,  664,
 /*  4600 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  416,
 /*  4610 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4620 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4630 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4640 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4650 */   664,  664,  664,  664,  664,  664,  664,  664,  584,  466,
 /*  4660 */   664,  468,  469,  470,  471,  472,  664,  664,  664,  664,
 /*  4670 */   664,  664,  664,  480,  481,  482,  664,  484,  485,  486,
 /*  4680 */   487,  488,  489,  664,  664,  492,  493,  494,  495,  496,
 /*  4690 */   497,  498,  499,  500,  664,  502,  503,  664,  664,  664,
 /*  4700 */   664,  664,  664,  664,  664,  664,  664,  664,  515,  516,
 /*  4710 */   664,  518,  664,  520,  521,  522,  523,  524,  318,  319,
 /*  4720 */   320,  321,  322,  323,  324,  325,  326,  327,  328,  329,
 /*  4730 */   330,  664,  664,  664,  334,  335,  336,  337,  338,  339,
 /*  4740 */   340,  341,  342,  343,  344,  664,  664,  664,  664,  664,
 /*  4750 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4760 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4770 */   664,  371,  664,  664,  664,  664,  664,  584,  664,  664,
 /*  4780 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4790 */   664,  664,  664,  664,  394,  395,  664,  664,  664,  664,
 /*  4800 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4810 */   664,  664,  664,  413,  664,  664,  416,  664,  664,  664,
 /*  4820 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4830 */   318,  319,  320,  321,  322,  323,  324,  325,  326,  327,
 /*  4840 */   328,  329,  330,  664,  664,  664,  334,  335,  336,  337,
 /*  4850 */   338,  339,  340,  341,  342,  343,  344,  664,  664,  664,
 /*  4860 */   664,  664,  664,  664,  664,  664,  466,  664,  468,  469,
 /*  4870 */   470,  471,  472,  664,  664,  664,  664,  664,  664,  664,
 /*  4880 */   480,  481,  482,  371,  484,  485,  486,  487,  488,  489,
 /*  4890 */   664,  664,  492,  493,  494,  495,  496,  497,  498,  499,
 /*  4900 */   500,  664,  502,  503,  664,  664,  394,  395,  664,  664,
 /*  4910 */   664,  664,  664,  664,  664,  515,  516,  664,  518,  664,
 /*  4920 */   520,  521,  522,  523,  524,  664,  664,  664,  416,  664,
 /*  4930 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4940 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4950 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4960 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  4970 */   664,  664,  664,  664,  664,  664,  664,  664,  466,  664,
 /*  4980 */   468,  469,  470,  471,  472,  664,  664,  664,  664,  664,
 /*  4990 */   664,  664,  480,  481,  482,  664,  484,  485,  486,  487,
 /*  5000 */   488,  489,  664,  664,  492,  493,  494,  495,  496,  497,
 /*  5010 */   498,  499,  500,  664,  502,  503,  664,  664,  664,  664,
 /*  5020 */   664,  664,  664,  664,  664,  664,  664,  515,  516,  664,
 /*  5030 */   518,  519,  520,  521,  522,  523,  524,  318,  319,  320,
 /*  5040 */   321,  322,  323,  324,  325,  326,  327,  328,  329,  330,
 /*  5050 */   664,  664,  664,  334,  335,  336,  337,  338,  339,  340,
 /*  5060 */   341,  342,  343,  344,  664,  664,  664,  664,  664,  664,
 /*  5070 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5080 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5090 */   371,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5100 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5110 */   664,  664,  664,  394,  395,  664,  664,  664,  664,  664,
 /*  5120 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5130 */   664,  664,  664,  664,  664,  416,  664,  664,  664,  664,
 /*  5140 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  318,
 /*  5150 */   319,  320,  321,  322,  323,  324,  325,  326,  327,  328,
 /*  5160 */   329,  330,  664,  664,  664,  334,  335,  336,  337,  338,
 /*  5170 */   339,  340,  341,  342,  343,  344,  664,  664,  664,  664,
 /*  5180 */   664,  664,  664,  664,  664,  466,  664,  468,  469,  470,
 /*  5190 */   471,  472,  664,  664,  664,  664,  664,  664,  664,  480,
 /*  5200 */   481,  482,  371,  484,  485,  486,  487,  488,  489,  664,
 /*  5210 */   664,  492,  493,  494,  495,  496,  497,  498,  499,  500,
 /*  5220 */   664,  502,  503,  664,  664,  394,  395,  664,  664,  664,
 /*  5230 */   664,  664,  664,  664,  515,  516,  664,  518,  664,  520,
 /*  5240 */   521,  522,  523,  524,  664,  664,  664,  416,  664,  664,
 /*  5250 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5260 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5270 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5280 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5290 */   664,  664,  664,  664,  664,  664,  664,  466,  664,  468,
 /*  5300 */   469,  470,  471,  472,  664,  664,  664,  664,  664,  664,
 /*  5310 */   664,  480,  481,  482,  664,  484,  485,  486,  487,  488,
 /*  5320 */   489,  664,  664,  492,  493,  494,  495,  496,  497,  498,
 /*  5330 */   499,  500,  664,  502,  503,  664,  664,  664,  664,  664,
 /*  5340 */   664,  664,  664,  664,  664,  664,  515,  516,  664,  518,
 /*  5350 */   664,  520,  521,  522,  523,  524,  318,  319,  320,  321,
 /*  5360 */   322,  323,  324,  325,  326,  327,  328,  329,  330,  664,
 /*  5370 */   664,  664,  334,  335,  336,  337,  338,  339,  340,  341,
 /*  5380 */   342,  343,  344,  664,  664,  664,  664,  664,  664,  664,
 /*  5390 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5400 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  371,
 /*  5410 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5420 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5430 */   664,  664,  394,  395,  664,  664,  664,  664,  664,  664,
 /*  5440 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5450 */   664,  664,  664,  664,  416,  664,  664,  664,  664,  664,
 /*  5460 */   664,  664,  664,  664,  664,  664,  664,  664,  318,  319,
 /*  5470 */   320,  321,  322,  323,  324,  325,  326,  327,  328,  329,
 /*  5480 */   330,  664,  664,  664,  334,  335,  336,  337,  338,  339,
 /*  5490 */   340,  341,  342,  343,  344,  664,  664,  664,  664,  664,
 /*  5500 */   664,  664,  664,  664,  466,  664,  468,  469,  470,  471,
 /*  5510 */   472,  664,  664,  664,  664,  664,  664,  664,  480,  481,
 /*  5520 */   482,  371,  484,  485,  486,  487,  488,  489,  664,  664,
 /*  5530 */   492,  493,  494,  495,  496,  497,  498,  499,  500,  664,
 /*  5540 */   502,  503,  664,  664,  394,  395,  664,  664,  664,  664,
 /*  5550 */   664,  664,  664,  515,  516,  664,  518,  664,  520,  521,
 /*  5560 */   522,  523,  524,  664,  664,  664,  416,  664,  664,  664,
 /*  5570 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5580 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5590 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5600 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5610 */   664,  664,  664,  664,  664,  664,  466,  664,  468,  469,
 /*  5620 */   470,  471,  472,  664,  664,  664,  664,  664,  664,  664,
 /*  5630 */   480,  481,  482,  664,  484,  485,  486,  487,  488,  489,
 /*  5640 */   664,  664,  492,  493,  494,  495,  496,  497,  498,  499,
 /*  5650 */   500,  664,  502,  503,  664,  664,  664,  664,  664,  664,
 /*  5660 */   664,  664,  664,  664,  664,  515,  516,  664,  518,  664,
 /*  5670 */   520,  521,  522,  523,  524,  318,  319,  320,  321,  322,
 /*  5680 */   323,  324,  325,  326,  327,  328,  329,  330,  664,  664,
 /*  5690 */   664,  334,  335,  336,  337,  338,  339,  340,  341,  342,
 /*  5700 */   343,  344,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5710 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5720 */   664,  664,  664,  664,  664,  664,  664,  664,  371,  664,
 /*  5730 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5740 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5750 */   664,  394,  395,  664,  664,  664,  664,  664,  664,  664,
 /*  5760 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5770 */   664,  664,  664,  416,  664,  664,  664,  664,  664,  664,
 /*  5780 */   664,  664,  664,  664,  664,  664,  664,  318,  319,  320,
 /*  5790 */   321,  322,  323,  324,  325,  326,  327,  328,  329,  330,
 /*  5800 */   664,  664,  664,  334,  335,  336,  337,  338,  339,  340,
 /*  5810 */   341,  342,  343,  344,  664,  664,  664,  664,  664,  664,
 /*  5820 */   664,  664,  664,  466,  664,  468,  469,  470,  471,  472,
 /*  5830 */   664,  664,  664,  664,  664,  664,  664,  480,  481,  482,
 /*  5840 */   371,  484,  485,  486,  487,  488,  489,  664,  664,  492,
 /*  5850 */   493,  494,  495,  496,  497,  498,  499,  500,  664,  502,
 /*  5860 */   503,  664,  664,  394,  395,  664,  664,  664,  664,  664,
 /*  5870 */   664,  664,  515,  516,  664,  518,  664,  520,  521,  522,
 /*  5880 */   523,  524,  664,  664,  664,  416,  664,  664,  664,  664,
 /*  5890 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5900 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5910 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5920 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  5930 */   664,  664,  664,  664,  664,  466,  664,  468,  469,  470,
 /*  5940 */   471,  472,  664,  664,  664,  664,  664,  664,  664,  480,
 /*  5950 */   481,  482,  664,  484,  485,  486,  487,  488,  489,  664,
 /*  5960 */   664,  492,  493,  494,  495,  496,  497,  498,  499,  500,
 /*  5970 */   664,  502,  503,  664,  664,  664,  664,  664,  664,  664,
 /*  5980 */   664,  664,  664,  664,  515,  516,  664,  518,  664,  520,
 /*  5990 */   521,  522,  523,  524,  318,  319,  320,  321,  322,  323,
 /*  6000 */   324,  325,  326,  327,  328,  329,  330,  664,  664,  664,
 /*  6010 */   334,  335,  336,  337,  338,  339,  340,  341,  342,  343,
 /*  6020 */   344,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6030 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6040 */   664,  664,  664,  664,  664,  664,  664,  371,  664,  664,
 /*  6050 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6060 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6070 */   394,  395,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6080 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6090 */   664,  664,  416,  664,  664,  664,  664,  664,  664,  664,
 /*  6100 */   664,  664,  664,  664,  664,  664,  318,  319,  320,  321,
 /*  6110 */   322,  323,  324,  325,  326,  327,  328,  329,  330,  664,
 /*  6120 */   664,  664,  334,  335,  336,  337,  338,  339,  340,  341,
 /*  6130 */   342,  343,  344,  664,  664,  664,  664,  664,  664,  664,
 /*  6140 */   664,  664,  466,  664,  468,  469,  470,  471,  472,  664,
 /*  6150 */   664,  664,  664,  664,  664,  664,  480,  481,  482,  371,
 /*  6160 */   484,  485,  486,  487,  488,  489,  664,  664,  492,  493,
 /*  6170 */   494,  495,  496,  497,  498,  499,  500,  664,  502,  503,
 /*  6180 */   664,  664,  394,  395,  664,  664,  664,  664,  664,  664,
 /*  6190 */   664,  515,  516,  664,  518,  664,  520,  521,  522,  523,
 /*  6200 */   524,  664,  664,  664,  416,  664,  664,  664,  664,  664,
 /*  6210 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6220 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6230 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6240 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6250 */   664,  664,  664,  664,  466,  664,  468,  469,  470,  471,
 /*  6260 */   472,  664,  664,  664,  664,  664,  664,  664,  480,  481,
 /*  6270 */   482,  664,  484,  485,  486,  487,  488,  489,  664,  664,
 /*  6280 */   492,  493,  494,  495,  496,  497,  498,  499,  500,  664,
 /*  6290 */   502,  503,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6300 */   664,  664,  664,  515,  516,  664,  518,  664,  520,  521,
 /*  6310 */   522,  523,  524,  318,  319,  320,  321,  322,  323,  324,
 /*  6320 */   325,  326,  327,  328,  329,  330,  664,  664,  664,  334,
 /*  6330 */   335,  336,  337,  338,  339,  340,  341,  342,  343,  344,
 /*  6340 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6350 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6360 */   664,  664,  664,  664,  664,  664,  371,  664,  664,  664,
 /*  6370 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6380 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  394,
 /*  6390 */   395,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6400 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6410 */   664,  416,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6420 */   664,  664,  664,  664,  664,  318,  319,  320,  321,  322,
 /*  6430 */   323,  324,  325,  326,  327,  328,  329,  330,  664,  664,
 /*  6440 */   664,  334,  335,  336,  337,  338,  339,  340,  341,  342,
 /*  6450 */   343,  344,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6460 */   664,  466,  664,  468,  469,  470,  471,  472,  664,  664,
 /*  6470 */   664,  664,  664,  664,  664,  480,  481,  482,  371,  484,
 /*  6480 */   485,  486,  487,  488,  489,  664,  664,  492,  493,  494,
 /*  6490 */   495,  496,  497,  498,  499,  500,  664,  502,  503,  664,
 /*  6500 */   664,  394,  395,  664,  664,  664,  664,  664,  664,  664,
 /*  6510 */   515,  516,  664,  518,  664,  520,  521,  522,  523,  524,
 /*  6520 */   664,  664,  664,  416,  664,  664,  664,  664,  664,  664,
 /*  6530 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6540 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6550 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6560 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6570 */   664,  664,  664,  466,  664,  468,  469,  470,  471,  472,
 /*  6580 */   664,  664,  664,  664,  664,  664,  664,  480,  481,  482,
 /*  6590 */   664,  484,  485,  486,  487,  488,  489,  664,  664,  492,
 /*  6600 */   493,  494,  495,  496,  497,  498,  499,  500,  664,  502,
 /*  6610 */   503,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6620 */   664,  664,  515,  516,  664,  518,  664,  520,  521,  522,
 /*  6630 */   523,  524,  318,  319,  320,  321,  322,  323,  324,  325,
 /*  6640 */   326,  327,  328,  329,  330,  664,  664,  664,  334,  335,
 /*  6650 */   336,  337,  338,  339,  340,  341,  342,  343,  344,  664,
 /*  6660 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6670 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6680 */   664,  664,  664,  664,  664,  371,  664,  664,  664,  664,
 /*  6690 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6700 */   664,  664,  664,  664,  664,  664,  664,  664,  394,  395,
 /*  6710 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6720 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6730 */   416,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6740 */   664,  664,  664,  664,  318,  319,  320,  321,  322,  323,
 /*  6750 */   324,  325,  326,  327,  328,  329,  330,  664,  664,  664,
 /*  6760 */   334,  335,  336,  337,  338,  339,  340,  341,  342,  343,
 /*  6770 */   344,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6780 */   466,  664,  468,  469,  470,  471,  472,  664,  664,  664,
 /*  6790 */   664,  664,  664,  664,  480,  481,  482,  371,  484,  485,
 /*  6800 */   486,  487,  488,  489,  664,  664,  492,  493,  494,  495,
 /*  6810 */   496,  497,  498,  499,  500,  664,  502,  503,  664,  664,
 /*  6820 */   394,  395,  664,  664,  664,  664,  664,  664,  664,  515,
 /*  6830 */   516,  664,  518,  664,  520,  521,  522,  523,  524,  664,
 /*  6840 */   664,  664,  416,  664,  664,  664,  664,  664,  664,  664,
 /*  6850 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6860 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6870 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6880 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6890 */   664,  664,  466,  664,  468,  469,  470,  471,  472,  664,
 /*  6900 */   664,  664,  664,  664,  664,  664,  480,  481,  482,  664,
 /*  6910 */   484,  485,  486,  487,  488,  489,  664,  664,  492,  493,
 /*  6920 */   494,  495,  496,  497,  498,  499,  500,  664,  502,  503,
 /*  6930 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6940 */   664,  515,  516,  664,  518,  664,  520,  521,  522,  523,
 /*  6950 */   524,  318,  319,  320,  321,  322,  323,  324,  325,  326,
 /*  6960 */   327,  328,  329,  330,  664,  664,  664,  334,  335,  336,
 /*  6970 */   337,  338,  339,  340,  341,  342,  343,  344,  664,  664,
 /*  6980 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  6990 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7000 */   664,  664,  664,  664,  371,  664,  664,  664,  664,  664,
 /*  7010 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7020 */   664,  664,  664,  664,  664,  664,  664,  394,  395,  664,
 /*  7030 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7040 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  416,
 /*  7050 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7060 */   664,  664,  664,  318,  319,  320,  321,  322,  323,  324,
 /*  7070 */   325,  326,  327,  328,  329,  330,  664,  664,  664,  334,
 /*  7080 */   335,  336,  337,  338,  339,  340,  341,  342,  343,  344,
 /*  7090 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  466,
 /*  7100 */   664,  468,  469,  470,  471,  472,  664,  664,  664,  664,
 /*  7110 */   664,  664,  664,  480,  481,  482,  371,  484,  485,  486,
 /*  7120 */   487,  488,  489,  664,  664,  492,  493,  494,  495,  496,
 /*  7130 */   497,  498,  499,  500,  664,  502,  503,  664,  664,  394,
 /*  7140 */   395,  664,  664,  664,  664,  664,  664,  664,  515,  516,
 /*  7150 */   664,  518,  664,  520,  521,  522,  523,  524,  664,  664,
 /*  7160 */   664,  416,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7170 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7180 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7190 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7200 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7210 */   664,  466,  664,  468,  469,  470,  471,  472,  664,  664,
 /*  7220 */   664,  664,  664,  664,  664,  480,  481,  482,  664,  484,
 /*  7230 */   485,  486,  487,  488,  489,  664,  664,  492,  493,  494,
 /*  7240 */   495,  496,  497,  498,  499,  500,  664,  502,  503,  664,
 /*  7250 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7260 */   515,  516,  664,  518,  664,  520,  521,  522,  523,  524,
 /*  7270 */   318,  319,  320,  321,  322,  323,  324,  325,  326,  327,
 /*  7280 */   328,  329,  330,  664,  664,  664,  334,  335,  336,  337,
 /*  7290 */   338,  339,  340,  341,  342,  343,  344,  664,  664,  664,
 /*  7300 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7310 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7320 */   664,  664,  664,  371,  664,  664,  664,  664,  664,  664,
 /*  7330 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7340 */   664,  664,  664,  664,  664,  664,  394,  395,  664,  664,
 /*  7350 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7360 */   664,  664,  664,  664,  664,  664,  664,  664,  416,  664,
 /*  7370 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7380 */   664,  664,  318,  319,  320,  321,  322,  323,  324,  325,
 /*  7390 */   326,  327,  328,  329,  330,  664,  664,  664,  334,  335,
 /*  7400 */   336,  337,  338,  339,  340,  341,  342,  343,  344,  664,
 /*  7410 */   664,  664,  664,  664,  664,  664,  664,  664,  466,  664,
 /*  7420 */   468,  469,  470,  471,  472,  664,  664,  664,  664,  664,
 /*  7430 */   664,  664,  480,  481,  482,  371,  484,  485,  486,  487,
 /*  7440 */   488,  489,  664,  664,  492,  493,  494,  495,  496,  497,
 /*  7450 */   498,  499,  500,  664,  502,  503,  664,  664,  394,  395,
 /*  7460 */   664,  664,  664,  664,  664,  664,  664,  515,  516,  664,
 /*  7470 */   518,  664,  520,  521,  522,  523,  524,  664,  664,  664,
 /*  7480 */   416,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7490 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7500 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7510 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7520 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7530 */   466,  664,  468,  469,  470,  471,  472,  664,  664,  664,
 /*  7540 */   664,  664,  664,  664,  480,  481,  482,  664,  484,  485,
 /*  7550 */   486,  487,  488,  489,  664,  664,  492,  493,  494,  495,
 /*  7560 */   496,  497,  498,  499,  500,  664,  502,  503,  664,  664,
 /*  7570 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  515,
 /*  7580 */   516,  664,  518,  664,  520,  521,  522,  523,  524,  318,
 /*  7590 */   319,  320,  321,  322,  323,  324,  325,  326,  327,  328,
 /*  7600 */   329,  330,  664,  664,  664,  334,  335,  336,  337,  338,
 /*  7610 */   339,  340,  341,  342,  343,  344,  664,  664,  664,  664,
 /*  7620 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7630 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7640 */   664,  664,  371,  664,  664,  664,  664,  664,  664,  664,
 /*  7650 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7660 */   664,  664,  664,  664,  664,  394,  395,  664,  664,  664,
 /*  7670 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7680 */   664,  664,  664,  664,  664,  664,  664,  416,  664,  664,
 /*  7690 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7700 */   664,  318,  319,  320,  321,  322,  323,  324,  325,  326,
 /*  7710 */   327,  328,  329,  330,  664,  664,  664,  334,  335,  336,
 /*  7720 */   337,  338,  339,  340,  341,  342,  343,  344,  664,  664,
 /*  7730 */   664,  664,  664,  664,  664,  664,  664,  466,  664,  468,
 /*  7740 */   469,  470,  471,  472,  664,  664,  664,  664,  664,  664,
 /*  7750 */   664,  480,  481,  482,  371,  484,  485,  486,  487,  488,
 /*  7760 */   489,  664,  664,  492,  493,  494,  495,  496,  497,  498,
 /*  7770 */   499,  500,  664,  502,  503,  664,  664,  394,  395,  664,
 /*  7780 */   664,  664,  664,  664,  664,  664,  515,  516,  664,  518,
 /*  7790 */   664,  520,  521,  522,  523,  524,  664,  664,  664,  416,
 /*  7800 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7810 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7820 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7830 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7840 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  466,
 /*  7850 */   664,  468,  469,  470,  471,  472,  664,  664,  664,  664,
 /*  7860 */   664,  664,  664,  480,  481,  482,  664,  484,  485,  486,
 /*  7870 */   487,  488,  489,  664,  664,  492,  493,  494,  495,  496,
 /*  7880 */   497,  498,  499,  500,  664,  502,  503,  664,  664,  664,
 /*  7890 */   664,  664,  664,  664,  664,  664,  664,  664,  515,  516,
 /*  7900 */   664,  518,  664,  520,  521,  522,  523,  524,  318,  319,
 /*  7910 */   320,  321,  322,  323,  324,  325,  326,  327,  328,  329,
 /*  7920 */   330,  664,  664,  664,  334,  335,  336,  337,  338,  339,
 /*  7930 */   340,  341,  342,  343,  344,  664,  664,  664,  664,  664,
 /*  7940 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7950 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7960 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7970 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  7980 */   664,  664,  664,  664,  394,  395,  664,  664,  664,  664,
 /*  7990 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  8000 */   664,  664,  664,  664,  664,  664,  416,  664,  664,  664,
 /*  8010 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  429,
 /*  8020 */   318,  319,  320,  321,  322,  323,  324,  325,  326,  327,
 /*  8030 */   328,  329,  330,  664,  664,  664,  334,  335,  336,  337,
 /*  8040 */   338,  339,  340,  341,  342,  343,  344,  664,  664,  664,
 /*  8050 */   664,  664,  664,  664,  664,  664,  466,  664,  468,  469,
 /*  8060 */   470,  471,  472,  664,  664,  664,  664,  664,  664,  664,
 /*  8070 */   480,  481,  482,  371,  484,  485,  486,  487,  488,  489,
 /*  8080 */   664,  664,  492,  493,  494,  495,  496,  497,  498,  499,
 /*  8090 */   500,  664,  502,  503,  664,  664,  394,  395,  664,  664,
 /*  8100 */   664,  664,  664,  664,  664,  515,  516,  664,  518,  664,
 /*  8110 */   520,  521,  522,  523,  524,  664,  664,  664,  416,  664,
 /*  8120 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  8130 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  8140 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  8150 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  8160 */   664,  664,  664,  664,  664,  664,  664,  664,  466,  664,
 /*  8170 */   468,  469,  470,  471,  472,  664,  664,  664,  664,  664,
 /*  8180 */   664,  664,  480,  481,  482,  664,  484,  485,  486,  487,
 /*  8190 */   488,  489,  664,  664,  492,  493,  494,  495,  496,  497,
 /*  8200 */   498,  499,  500,  664,  502,  503,  664,  664,  664,  664,
 /*  8210 */   664,  664,  664,  664,  664,  664,  664,  515,  516,  664,
 /*  8220 */   518,  664,  520,  521,  522,  523,  524,  318,  319,  320,
 /*  8230 */   321,  322,  323,  324,  325,  326,  327,  328,  329,  330,
 /*  8240 */   664,  664,  664,  334,  335,  336,  337,  338,  339,  340,
 /*  8250 */   341,  342,  343,  344,  664,  664,  664,  664,   37,   38,
 /*  8260 */   664,  664,  664,  664,   43,   44,   45,   46,   47,   48,
 /*  8270 */    49,   50,   51,   52,   53,   54,   55,   56,   57,   58,
 /*  8280 */   371,  664,   61,  664,  664,  664,  664,   66,  664,  664,
 /*  8290 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  8300 */   664,  664,  664,  394,  395,  664,  664,  664,  664,  664,
 /*  8310 */   664,  664,  664,  664,   93,  664,  664,  664,  664,  664,
 /*  8320 */    99,  664,  664,  664,  664,  416,  664,  664,  664,  664,
 /*  8330 */   664,  664,  664,  664,  664,  664,  664,  116,  664,  664,
 /*  8340 */   664,  664,  664,  122,  664,  124,  664,  126,  127,  664,
 /*  8350 */   664,  130,  131,  132,  133,  134,  135,  136,  137,  138,
 /*  8360 */   139,  664,  664,  664,  664,  144,  145,  146,  147,  664,
 /*  8370 */   664,  664,  664,  664,  664,  466,  664,  468,  469,  470,
 /*  8380 */   471,  472,  664,  664,  664,  664,  664,  664,  664,  480,
 /*  8390 */   481,  482,  664,  484,  485,  486,  487,  488,  489,  664,
 /*  8400 */   664,  492,  493,  494,  495,  496,  497,  498,  499,  500,
 /*  8410 */   664,  502,  503,  664,  664,  664,  664,  664,  664,  664,
 /*  8420 */   664,  664,  664,  664,  515,  516,  664,  518,  664,  520,
 /*  8430 */   521,  522,  523,  524,  265,  266,  267,  268,  269,  270,
 /*  8440 */   271,  272,  273,  274,  275,  276,  277,  278,  279,  280,
 /*  8450 */   281,  282,  283,  284,  285,  286,  287,  288,  289,  290,
 /*  8460 */   291,  292,  293,  294,  295,  296,  297,  298,  299,  300,
 /*  8470 */   301,  302,  303,  304,  305,  306,  307,  308,  309,  310,
 /*  8480 */   311,  312,  313,  314,  315,  316,  664,  664,  664,  664,
 /*  8490 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  8500 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  8510 */   664,  664,  664,  664,  345,  664,  664,  664,  349,  664,
 /*  8520 */   664,  664,  664,  664,  664,  664,  357,  358,  359,  360,
 /*  8530 */   361,  362,  664,  664,  664,  664,  318,  319,  320,  321,
 /*  8540 */   322,  323,  324,  325,  326,  327,  328,  329,  330,  664,
 /*  8550 */   664,  664,  334,  335,  336,  337,  338,  339,  340,  341,
 /*  8560 */   342,  343,  344,  664,   37,   38,  664,  664,  664,  664,
 /*  8570 */    43,   44,   45,   46,   47,   48,   49,   50,   51,   52,
 /*  8580 */    53,   54,   55,   56,   57,   58,  664,  664,  664,  371,
 /*  8590 */   664,  664,  664,   66,   67,  664,  664,  664,  664,  664,
 /*  8600 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  8610 */   664,  664,  394,  395,  664,  664,  664,  664,  664,  664,
 /*  8620 */    93,  664,  664,  664,  664,  664,   99,  664,  664,  664,
 /*  8630 */   664,  664,  664,  664,  416,  664,  664,  664,  664,  664,
 /*  8640 */   664,  664,  664,  116,  664,  664,  664,  664,  664,  122,
 /*  8650 */   664,  124,  664,  126,  127,  664,  664,  130,  131,  132,
 /*  8660 */   133,  134,  135,  136,  137,  138,  139,  664,  664,  664,
 /*  8670 */   664,  144,  145,  146,  147,  664,  664,  664,  664,  664,
 /*  8680 */   664,  664,  664,  664,  466,  664,  468,  469,  470,  471,
 /*  8690 */   472,  664,  664,  664,  664,  526,  664,  528,  480,  481,
 /*  8700 */   482,  664,  484,  485,  486,  487,  488,  489,  664,  664,
 /*  8710 */   492,  493,  494,  495,  496,  497,  498,  499,  500,  664,
 /*  8720 */   502,  503,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  8730 */   664,  664,  664,  515,  516,  664,  518,  664,  520,  521,
 /*  8740 */   522,  523,  524,  318,  319,  320,  321,  322,  323,  324,
 /*  8750 */   325,  326,  327,  328,  329,  330,  664,  664,  664,  334,
 /*  8760 */   335,  336,  337,  338,  339,  340,  341,  342,  343,  344,
 /*  8770 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  8780 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  8790 */   664,  664,  318,  664,  664,  664,  371,  323,  324,  325,
 /*  8800 */   326,  664,  664,  329,  330,  664,  664,  664,  334,  664,
 /*  8810 */   664,  337,  338,  339,  340,  341,  342,  343,  344,  394,
 /*  8820 */   395,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  8830 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  8840 */   664,  416,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  8850 */   664,  664,  664,  664,  664,  318,  319,  320,  321,  322,
 /*  8860 */   323,  324,  325,  326,  327,  328,  329,  330,  394,  395,
 /*  8870 */   664,  334,  335,  336,  337,  338,  339,  340,  341,  342,
 /*  8880 */   343,  344,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  8890 */   416,  466,  664,  468,  469,  470,  471,  472,  664,  664,
 /*  8900 */   664,  664,  664,  664,  664,  480,  481,  482,  371,  484,
 /*  8910 */   485,  486,  487,  488,  489,  664,  664,  492,  493,  494,
 /*  8920 */   495,  496,  497,  498,  499,  500,  664,  502,  503,  664,
 /*  8930 */   664,  394,  395,  664,  664,  664,  664,  664,  664,  664,
 /*  8940 */   515,  516,  664,  518,  664,  520,  521,  522,  523,  524,
 /*  8950 */   664,  664,  664,  416,  480,  481,  482,  664,  484,  485,
 /*  8960 */   486,  487,  488,  489,  664,  664,  664,  664,  664,  495,
 /*  8970 */   496,  497,  498,  499,  500,  664,  502,  503,  664,  664,
 /*  8980 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  515,
 /*  8990 */   516,  664,  518,  664,  664,  664,  664,  664,  664,  664,
 /*  9000 */   664,  664,  664,  466,  664,  468,  469,  470,  471,  472,
 /*  9010 */   664,  664,  664,  664,  664,  664,  664,  480,  481,  482,
 /*  9020 */   664,  484,  485,  486,  487,  488,  489,  664,  664,  492,
 /*  9030 */   493,  494,  495,  496,  497,  498,  499,  500,  664,  502,
 /*  9040 */   503,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  9050 */   664,  664,  515,  516,  664,  518,  664,  520,  521,  522,
 /*  9060 */   523,  524,  318,  319,  320,  321,  322,  323,  324,  325,
 /*  9070 */   326,  327,  328,  329,  330,  664,  664,  664,  334,  335,
 /*  9080 */   336,  337,  338,  339,  340,  341,  342,  343,  344,  664,
 /*  9090 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  9100 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  9110 */   664,  318,  664,  664,  664,  664,  323,  324,  325,  326,
 /*  9120 */   664,  664,  329,  330,  664,  664,  664,  334,  664,  664,
 /*  9130 */   337,  338,  339,  340,  341,  342,  343,  344,  394,  395,
 /*  9140 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  9150 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  9160 */   416,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  9170 */   664,  664,  664,  664,  318,  319,  320,  321,  322,  323,
 /*  9180 */   324,  325,  326,  327,  328,  329,  330,  394,  395,  664,
 /*  9190 */   334,  335,  336,  337,  338,  339,  340,  341,  342,  343,
 /*  9200 */   344,  664,  664,  664,  664,  664,  664,  664,  664,  416,
 /*  9210 */   466,  664,  468,  469,  470,  471,  472,  664,  664,  664,
 /*  9220 */   664,  664,  664,  664,  480,  481,  482,  664,  484,  485,
 /*  9230 */   486,  487,  488,  489,  664,  664,  492,  493,  494,  495,
 /*  9240 */   496,  497,  498,  499,  500,  664,  502,  503,  664,  664,
 /*  9250 */   394,  395,  664,  664,  664,  664,  664,  664,  664,  515,
 /*  9260 */   516,  664,  518,  664,  520,  521,  522,  523,  524,  664,
 /*  9270 */   664,  664,  416,  480,  481,  482,  664,  484,  485,  486,
 /*  9280 */   487,  488,  489,  664,  664,  664,  664,  664,  495,  496,
 /*  9290 */   497,  498,  499,  500,  664,  502,  503,  664,  664,  664,
 /*  9300 */   664,  664,  664,  664,  664,  664,  664,  664,  515,  516,
 /*  9310 */   664,  518,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  9320 */   664,  664,  466,  664,  468,  469,  470,  471,  472,  664,
 /*  9330 */   664,  664,  664,  664,  664,  664,  480,  481,  482,  664,
 /*  9340 */   484,  485,  486,  487,  488,  489,  664,  664,  492,  493,
 /*  9350 */   494,  495,  496,  497,  498,  499,  500,  664,  502,  503,
 /*  9360 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  9370 */   664,  515,  516,  664,  518,  664,  520,  521,  522,  523,
 /*  9380 */   524,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  9390 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  9400 */   664,  664,  664,  664,  664,  664,  267,  268,  269,  270,
 /*  9410 */   271,  272,  273,  274,  275,  276,  277,  278,  279,  280,
 /*  9420 */   281,  282,  283,  284,  285,  286,  287,  288,  289,  290,
 /*  9430 */   291,  292,  293,  294,  295,  296,  297,  298,  299,  300,
 /*  9440 */   301,  302,  303,  304,  305,  306,  307,  308,  309,  310,
 /*  9450 */   311,  312,  313,  314,  315,  316,  664,  664,  664,  664,
 /*  9460 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  9470 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  9480 */   664,  664,  664,  664,  345,  664,  664,  664,  349,  664,
 /*  9490 */   664,  664,  664,  664,  664,  664,  357,  358,  359,  360,
 /*  9500 */   361,  362,  664,  664,  267,  268,  269,  270,  271,  272,
 /*  9510 */   273,  274,  275,  276,  277,  278,  279,  280,  281,  282,
 /*  9520 */   283,  284,  285,  286,  287,  288,  289,  290,  291,  292,
 /*  9530 */   293,  294,  295,  296,  297,  298,  299,  300,  301,  302,
 /*  9540 */   303,  304,  305,  306,  307,  308,  309,  310,  311,  312,
 /*  9550 */   313,  314,  315,  316,   43,   44,   45,  664,  664,  664,
 /*  9560 */   664,   50,   51,   52,   53,   54,   55,   56,   57,   58,
 /*  9570 */   664,  664,  664,  664,  664,  664,  664,   66,  664,  664,
 /*  9580 */   664,  664,  345,  664,  664,  664,  349,  664,  664,  664,
 /*  9590 */   664,  664,  664,  664,  357,  358,  359,  360,  361,  362,
 /*  9600 */   664,  664,  664,  664,   93,  664,  664,  268,  664,   98,
 /*  9610 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*  9620 */   109,  664,  111,  664,  664,  664,  664,  664,  664,  664,
 /*  9630 */   664,  664,  664,  122,  664,  124,  664,  126,  127,  664,
 /*  9640 */   664,  664,  664,  664,  133,  664,  664,  664,  664,  664,
 /*  9650 */   139,  664,  664,  664,  664,  144,  145,  146,  319,  664,
 /*  9660 */   321,  322,  664,  664,  664,  526,  664,  528,  329,  330,
 /*  9670 */   664,  664,  664,  664,  335,  664,  337,  338,  339,  340,
 /*  9680 */   341,  342,  343,  344,  345,  664,  664,  664,  349,  664,
 /*  9690 */   664,  664,  664,  664,  664,  664,  357,  358,  359,  360,
 /*  9700 */   361,  362,  664,  664,  664,  664,   50,   51,   52,   53,
 /*  9710 */    54,   55,   56,   57,   58,  664,  664,  664,  664,  664,
 /*  9720 */   664,  664,   66,  664,   68,  664,  664,  664,  664,  664,
 /*  9730 */   664,  664,  664,  394,  395,  664,  664,  664,  664,  664,
 /*  9740 */   664,  664,  664,  664,  664,  664,  664,  664,  664,   93,
 /*  9750 */   664,  664,  664,  664,  664,   99,  664,  664,  664,  664,
 /*  9760 */   664,  664,  664,  526,  664,  528,  664,  664,  664,  430,
 /*  9770 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  9780 */   664,  664,  664,  664,  664,  664,  664,  664,  449,  133,
 /*  9790 */   451,  664,  453,  664,  664,  139,  664,  268,  459,  664,
 /*  9800 */   144,  145,  146,  464,  148,  149,  467,  468,  469,  470,
 /*  9810 */   471,  472,  664,  664,  664,  664,  664,  664,  664,  480,
 /*  9820 */   481,  482,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  9830 */   664,  664,  664,  664,  495,  496,  497,  498,  499,  500,
 /*  9840 */   664,  502,  503,  664,  664,  664,  664,  664,  319,  664,
 /*  9850 */   321,  322,  664,  514,  515,  516,  664,  518,  329,  330,
 /*  9860 */   664,  664,  664,  664,  335,  664,  337,  338,  339,  340,
 /*  9870 */   341,  342,  343,  344,  345,  664,  664,  664,  349,  664,
 /*  9880 */   664,  664,  664,  664,  664,  664,  357,  358,  359,  360,
 /*  9890 */   361,  362,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  9900 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  9910 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  9920 */   664,  664,  664,  394,  395,  664,  664,  664,  664,  664,
 /*  9930 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  9940 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  9950 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  430,
 /*  9960 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /*  9970 */   664,  664,  664,  664,  664,  664,  664,  664,  449,  664,
 /*  9980 */   451,  664,  453,  664,  664,  664,  664,  664,  459,  664,
 /*  9990 */   664,  664,  664,  464,  664,  664,  467,  468,  469,  470,
 /* 10000 */   471,  472,  268,  664,  664,  664,  664,  664,  664,  480,
 /* 10010 */   481,  482,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 10020 */   664,  664,  664,  664,  495,  496,  497,  498,  499,  500,
 /* 10030 */   664,  502,  503,  664,  664,  664,  664,  664,  664,  664,
 /* 10040 */   664,  664,  664,  514,  515,  516,  664,  518,  664,  664,
 /* 10050 */   664,  664,  318,  664,  664,  664,  664,  323,  324,  325,
 /* 10060 */   326,  664,  664,  329,  330,  664,  664,  664,  334,  664,
 /* 10070 */   664,  337,  338,  339,  340,  341,  342,  343,  344,  345,
 /* 10080 */   664,  664,  664,  349,  664,  664,  664,  664,  664,  664,
 /* 10090 */   664,  357,  358,  359,  360,  361,  362,  664,  664,  664,
 /* 10100 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 10110 */   664,  664,  664,  664,  664,  664,  664,  268,  664,  664,
 /* 10120 */   664,  664,  664,  664,  664,  664,  664,  664,  394,  395,
 /* 10130 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 10140 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 10150 */   416,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 10160 */   664,  664,  664,  664,  664,  664,  664,  318,  664,  664,
 /* 10170 */   664,  664,  323,  324,  325,  326,  664,  664,  329,  330,
 /* 10180 */   664,  664,  664,  334,  664,  664,  337,  338,  339,  340,
 /* 10190 */   341,  342,  343,  344,  345,  664,  664,  664,  349,  664,
 /* 10200 */   664,  664,  664,  664,  664,  664,  357,  358,  359,  360,
 /* 10210 */   361,  362,  664,  664,  480,  481,  482,  483,  484,  485,
 /* 10220 */   486,  487,  488,  489,  664,  664,  664,  664,  268,  495,
 /* 10230 */   496,  497,  498,  499,  500,  664,  502,  503,  664,  664,
 /* 10240 */   664,  664,  664,  394,  395,  664,  664,  664,  514,  515,
 /* 10250 */   516,  664,  518,  664,  664,  664,  664,  664,  664,  664,
 /* 10260 */   664,  664,  664,  664,  664,  416,  664,  664,  664,  664,
 /* 10270 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  319,
 /* 10280 */   664,  321,  322,  664,  664,  664,  664,  664,  664,  329,
 /* 10290 */   330,  664,  664,  664,  664,  335,  664,  337,  338,  339,
 /* 10300 */   340,  341,  342,  343,  344,  345,  664,  664,  664,  349,
 /* 10310 */   664,  664,  664,  664,  664,  664,  664,  357,  358,  359,
 /* 10320 */   360,  361,  362,  664,  664,  664,  664,  664,  664,  480,
 /* 10330 */   481,  482,  483,  484,  485,  486,  487,  488,  489,  664,
 /* 10340 */   664,  664,  664,  664,  495,  496,  497,  498,  499,  500,
 /* 10350 */   664,  502,  503,  664,  394,  395,  664,  664,  664,  664,
 /* 10360 */   664,  664,  664,  514,  515,  516,  664,  518,  664,  664,
 /* 10370 */   664,   16,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 10380 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 10390 */   664,  664,   37,   38,  664,  664,  664,  664,   43,   44,
 /* 10400 */    45,   46,   47,   48,   49,   50,   51,   52,   53,   54,
 /* 10410 */    55,   56,   57,   58,  664,  664,  664,  664,  664,  664,
 /* 10420 */   664,   66,  664,   68,  664,  664,  664,  467,  468,  469,
 /* 10430 */   470,  471,  472,  664,  664,   80,  664,  664,  664,  664,
 /* 10440 */   480,  481,  482,  664,  664,  664,  664,  664,   93,  664,
 /* 10450 */   664,  664,  664,  664,   99,  495,  496,  497,  498,  499,
 /* 10460 */   500,  664,  502,  503,  664,  664,  664,  664,  664,  664,
 /* 10470 */   664,  116,  664,  664,  514,  515,  516,  122,  518,  124,
 /* 10480 */   664,  126,  127,  664,  664,  130,  131,  132,  133,  134,
 /* 10490 */   135,  136,  137,  138,  139,   16,  664,  664,  664,  144,
 /* 10500 */   145,  146,  147,  148,  149,  664,  664,  664,  664,  664,
 /* 10510 */   664,  664,  664,  664,  664,  664,   37,   38,  664,  664,
 /* 10520 */   664,  664,   43,   44,   45,   46,   47,   48,   49,   50,
 /* 10530 */    51,   52,   53,   54,   55,   56,   57,   58,  664,  664,
 /* 10540 */   664,  664,  664,  664,  664,   66,  664,  664,  664,  664,
 /* 10550 */   664,  664,  664,  664,  664,  664,  664,  664,  664,   80,
 /* 10560 */   664,  664,  664,  319,  664,  321,  322,  664,  664,  664,
 /* 10570 */   664,  664,   93,  329,  330,  664,  664,  664,   99,  335,
 /* 10580 */   664,  337,  338,  339,  340,  341,  342,  343,  344,  664,
 /* 10590 */   664,  664,  664,  664,  664,  116,  664,  664,  664,  664,
 /* 10600 */   664,  122,  664,  124,  664,  126,  127,  664,  664,  130,
 /* 10610 */   131,  132,  133,  134,  135,  136,  137,  138,  139,  664,
 /* 10620 */   664,  664,  664,  144,  145,  146,  147,  664,  664,  664,
 /* 10630 */   664,  664,  664,  664,  664,  664,  664,  664,  394,  395,
 /* 10640 */   664,  664,  319,  664,  321,  322,  664,  664,  664,  664,
 /* 10650 */   664,  664,  329,  330,  664,  664,  664,  664,  335,  664,
 /* 10660 */   337,  338,  339,  340,  341,  342,  343,  344,  664,  664,
 /* 10670 */   664,  664,  664,  664,  430,  664,  664,  664,  664,  664,
 /* 10680 */   436,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 10690 */   664,  664,  664,  449,  664,  451,  664,  453,  664,  664,
 /* 10700 */   664,  664,  664,  459,  664,  664,  664,  664,  464,  664,
 /* 10710 */   664,  664,  468,  469,  470,  471,  472,  394,  395,  664,
 /* 10720 */   664,  664,  664,  664,  480,  481,  482,  664,  664,  664,
 /* 10730 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  495,
 /* 10740 */   496,  497,  498,  499,  500,  664,  502,  503,  664,  664,
 /* 10750 */   664,  664,  664,  430,  664,  664,  664,  664,  664,  515,
 /* 10760 */   516,  664,  518,  664,  664,  664,  664,  664,  664,  664,
 /* 10770 */   664,  664,  449,  664,  451,  664,  453,  664,  664,  664,
 /* 10780 */   664,  664,  459,  664,  664,  664,  664,  464,  664,  664,
 /* 10790 */   664,  468,  469,  470,  471,  472,  664,  664,  664,  664,
 /* 10800 */   664,  664,  664,  480,  481,  482,  664,  664,  664,  664,
 /* 10810 */   664,  664,  664,  664,  664,  664,  664,  664,  495,  496,
 /* 10820 */   497,  498,  499,  500,  664,  502,  503,  664,  664,  664,
 /* 10830 */   664,  664,  664,  664,  664,  664,  664,  664,  515,  516,
 /* 10840 */   664,  518,  319,  664,  321,  322,  664,  664,  664,  664,
 /* 10850 */   664,  664,  329,  330,  664,  664,  664,  664,  335,  664,
 /* 10860 */   337,  338,  339,  340,  341,  342,  343,  344,  664,  664,
 /* 10870 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 10880 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 10890 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 10900 */   664,  664,  664,  319,  664,  321,  322,  664,  664,  664,
 /* 10910 */   664,  664,  664,  329,  330,  664,  664,  394,  395,  335,
 /* 10920 */   664,  337,  338,  339,  340,  341,  342,  343,  344,  664,
 /* 10930 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 10940 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 10950 */   664,  664,  664,  430,  664,  664,  664,  664,  664,  664,
 /* 10960 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 10970 */   664,  664,  449,  664,  451,  664,  453,  664,  394,  395,
 /* 10980 */   664,  664,  459,  664,  664,  664,  664,  464,  664,  664,
 /* 10990 */   664,  468,  469,  470,  471,  472,  664,  664,  664,  664,
 /* 11000 */   664,  664,  664,  480,  481,  482,  664,  664,  664,  664,
 /* 11010 */   664,  664,  664,  664,  430,  664,  664,  664,  495,  496,
 /* 11020 */   497,  498,  499,  500,  664,  502,  503,  664,  664,  664,
 /* 11030 */   664,  664,  664,  664,  664,  664,  664,  453,  515,  516,
 /* 11040 */   664,  518,  664,  459,  664,  664,  462,  664,  464,  465,
 /* 11050 */   664,  664,  468,  469,  470,  471,  472,  664,  664,  664,
 /* 11060 */   664,  664,  664,  664,  480,  481,  482,  664,  664,  664,
 /* 11070 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  495,
 /* 11080 */   496,  497,  498,  499,  500,  664,  502,  503,  664,  664,
 /* 11090 */   664,  664,  664,  664,  319,  664,  321,  322,  664,  515,
 /* 11100 */   516,  664,  518,  664,  329,  330,  664,  664,  664,  664,
 /* 11110 */   335,  664,  337,  338,  339,  340,  341,  342,  343,  344,
 /* 11120 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11130 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11140 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11150 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11160 */   664,  664,  664,  664,  664,  319,  664,  321,  322,  394,
 /* 11170 */   395,  664,  664,  664,  664,  329,  330,  664,  664,  664,
 /* 11180 */   664,  335,  664,  337,  338,  339,  340,  341,  342,  343,
 /* 11190 */   344,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11200 */   664,  664,  664,  664,  664,  430,  664,  664,  664,  664,
 /* 11210 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11220 */   664,  664,  664,  664,  449,  664,  451,  664,  453,  664,
 /* 11230 */   664,  664,  664,  664,  459,  664,  664,  664,  664,  464,
 /* 11240 */   394,  395,  664,  468,  469,  470,  471,  472,  664,  664,
 /* 11250 */   664,  664,  664,  664,  664,  480,  481,  482,  664,  664,
 /* 11260 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11270 */   495,  496,  497,  498,  499,  500,  430,  502,  503,  664,
 /* 11280 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11290 */   515,  516,  664,  518,  664,  449,  664,  451,  664,  453,
 /* 11300 */   664,  664,  664,  664,  664,  459,  664,  664,  664,  664,
 /* 11310 */   464,  664,  664,  664,  468,  469,  470,  471,  472,  664,
 /* 11320 */   664,  664,  664,  664,  664,  664,  480,  481,  482,  664,
 /* 11330 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11340 */   664,  495,  496,  497,  498,  499,  500,  664,  502,  503,
 /* 11350 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11360 */   664,  515,  516,  664,  518,   37,   38,  664,  664,  664,
 /* 11370 */   664,   43,   44,   45,   46,   47,   48,   49,   50,   51,
 /* 11380 */    52,   53,   54,   55,   56,   57,   58,  664,  664,  664,
 /* 11390 */   664,  664,  664,  664,   66,  664,  664,  664,  664,  664,
 /* 11400 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11410 */   664,  664,  664,  664,  319,  664,  321,  322,  664,  664,
 /* 11420 */   664,   93,  664,  664,  329,  330,  664,   99,  664,  664,
 /* 11430 */   335,  664,  337,  338,  339,  340,  341,  342,  343,  344,
 /* 11440 */   664,  664,  664,  664,  116,  664,  664,  664,  664,  664,
 /* 11450 */   122,  664,  124,  664,  126,  127,  664,  664,  130,  131,
 /* 11460 */   132,  133,  134,  135,  136,  137,  138,  139,  664,  664,
 /* 11470 */   664,  664,  144,  145,  146,  147,  664,  664,  664,  664,
 /* 11480 */   664,  664,  664,  664,  664,  319,  664,  321,  322,  394,
 /* 11490 */   395,  664,  664,  664,  664,  329,  330,  664,  664,  664,
 /* 11500 */   664,  335,  664,  337,  338,  339,  340,  341,  342,  343,
 /* 11510 */   344,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11520 */   664,  664,  664,  664,  664,  430,  664,  664,  664,  664,
 /* 11530 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11540 */   664,  664,  664,  664,  664,  664,  664,  664,  453,  664,
 /* 11550 */   664,  664,  664,  664,  459,  460,  664,  664,  664,  464,
 /* 11560 */   394,  395,  664,  468,  469,  470,  471,  472,  664,  664,
 /* 11570 */   664,  664,  664,  664,  664,  480,  481,  482,  664,  664,
 /* 11580 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11590 */   495,  496,  497,  498,  499,  500,  430,  502,  503,  664,
 /* 11600 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11610 */   515,  516,  664,  518,  664,  664,  450,  664,  452,  453,
 /* 11620 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11630 */   464,  664,  664,  664,  468,  469,  470,  471,  472,  664,
 /* 11640 */   664,  664,  664,  664,  664,  664,  480,  481,  482,  664,
 /* 11650 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11660 */   664,  495,  496,  497,  498,  499,  500,  318,  502,  503,
 /* 11670 */   664,  664,  323,  324,  325,  326,  664,  664,  329,  330,
 /* 11680 */   664,  515,  516,  334,  518,  664,  337,  338,  339,  340,
 /* 11690 */   341,  342,  343,  344,  664,  664,  664,  664,  664,  664,
 /* 11700 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11710 */   664,  664,  664,  318,  664,  664,  664,  664,  323,  324,
 /* 11720 */   325,  326,  664,  664,  329,  330,  664,  664,  664,  334,
 /* 11730 */   664,  664,  337,  338,  339,  340,  341,  342,  343,  344,
 /* 11740 */   664,  664,  664,  394,  395,  664,  664,  664,  664,  664,
 /* 11750 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11760 */   664,  664,  664,  664,  664,  416,  664,  664,  664,  664,
 /* 11770 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11780 */   318,  664,  664,  664,  664,  323,  324,  325,  326,  394,
 /* 11790 */   395,  329,  330,  664,  664,  664,  334,  664,  664,  337,
 /* 11800 */   338,  339,  340,  341,  342,  343,  344,  664,  664,  664,
 /* 11810 */   664,  416,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11820 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  480,
 /* 11830 */   481,  482,  664,  484,  485,  486,  487,  488,  489,  664,
 /* 11840 */   664,  664,  664,  664,  495,  496,  497,  498,  499,  500,
 /* 11850 */   664,  502,  503,  664,  664,  664,  394,  395,  664,  664,
 /* 11860 */   664,  664,  664,  664,  515,  516,  664,  518,  664,  664,
 /* 11870 */   664,  664,  664,  664,  664,  480,  481,  482,  416,  484,
 /* 11880 */   485,  486,  487,  488,  489,  664,  664,  664,  664,  664,
 /* 11890 */   495,  496,  497,  498,  499,  500,  318,  502,  503,  664,
 /* 11900 */   664,  323,  324,  325,  326,  664,  664,  329,  330,  664,
 /* 11910 */   515,  516,  334,  518,  664,  337,  338,  339,  340,  341,
 /* 11920 */   342,  343,  344,  664,  664,  664,  664,  664,  664,  664,
 /* 11930 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11940 */   664,  664,  480,  481,  482,  664,  484,  485,  486,  487,
 /* 11950 */   488,  489,  664,  664,  664,  664,  664,  495,  496,  497,
 /* 11960 */   498,  499,  500,  664,  502,  503,  664,  664,  664,  664,
 /* 11970 */   664,  664,  394,  395,  664,  664,  664,  515,  516,  664,
 /* 11980 */   518,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 11990 */   664,  664,  318,  664,  416,  664,  664,  323,  324,  325,
 /* 12000 */   326,  664,  664,  329,  330,  664,  664,  664,  334,  664,
 /* 12010 */   664,  337,  338,  339,  340,  341,  342,  343,  344,  664,
 /* 12020 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 12030 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 12040 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 12050 */   664,  664,  664,  664,  664,  664,  664,  664,  480,  481,
 /* 12060 */   482,  664,  484,  485,  486,  487,  488,  489,  394,  395,
 /* 12070 */   664,  664,  664,  495,  496,  497,  498,  499,  500,  664,
 /* 12080 */   502,  503,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 12090 */   416,  664,  664,  515,  516,  664,  518,  664,  664,  664,
 /* 12100 */   664,  664,  664,  664,  318,  664,  664,  664,  664,  323,
 /* 12110 */   324,  325,  326,  664,  664,  329,  330,  664,  664,  664,
 /* 12120 */   334,  664,  664,  337,  338,  339,  340,  341,  342,  343,
 /* 12130 */   344,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 12140 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 12150 */   664,  664,  664,  664,  480,  481,  482,  664,  484,  485,
 /* 12160 */   486,  487,  488,  489,  664,  664,  664,  664,  664,  495,
 /* 12170 */   496,  497,  498,  499,  500,  664,  502,  503,  664,  664,
 /* 12180 */   394,  395,  664,  664,  664,  664,  664,  664,  664,  515,
 /* 12190 */   516,  664,  518,  664,  664,  664,  664,  664,  664,  664,
 /* 12200 */   318,  664,  416,  664,  664,  323,  324,  325,  326,  664,
 /* 12210 */   664,  329,  330,  664,  664,  664,  334,  664,  664,  337,
 /* 12220 */   338,  339,  340,  341,  342,  343,  344,  664,  664,  664,
 /* 12230 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  318,
 /* 12240 */   664,  664,  664,  664,  323,  324,  325,  326,  664,  664,
 /* 12250 */   329,  330,  664,  664,  664,  334,  664,  664,  337,  338,
 /* 12260 */   339,  340,  341,  342,  343,  344,  480,  481,  482,  664,
 /* 12270 */   484,  485,  486,  487,  488,  489,  394,  395,  664,  664,
 /* 12280 */   664,  495,  496,  497,  498,  499,  500,  664,  502,  503,
 /* 12290 */   664,  664,  664,  664,  664,  664,  664,  664,  416,  664,
 /* 12300 */   664,  515,  516,  664,  518,  664,  664,  664,  664,  664,
 /* 12310 */   664,  664,  664,  664,  664,  394,  395,  664,  664,  664,
 /* 12320 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 12330 */   664,  664,  664,  664,  664,  318,  664,  416,  664,  664,
 /* 12340 */   323,  324,  325,  326,  664,  664,  329,  330,  664,  664,
 /* 12350 */   664,  334,  664,  664,  337,  338,  339,  340,  341,  342,
 /* 12360 */   343,  344,  480,  481,  482,  664,  484,  485,  486,  487,
 /* 12370 */   488,  489,  664,  664,  664,  664,  664,  495,  496,  497,
 /* 12380 */   498,  499,  500,  664,  502,  503,  664,  664,  664,  664,
 /* 12390 */   664,  664,  664,  664,  664,  664,  664,  515,  516,  664,
 /* 12400 */   518,  480,  481,  482,  664,  484,  485,  486,  487,  488,
 /* 12410 */   489,  394,  395,  664,  664,  664,  495,  496,  497,  498,
 /* 12420 */   499,  500,  664,  502,  503,  664,  664,  664,  664,  664,
 /* 12430 */   664,  664,  664,  416,  664,  664,  515,  516,  664,  518,
 /* 12440 */   664,  664,  664,  664,  664,  318,  664,  664,  664,  664,
 /* 12450 */   323,  324,  325,  326,  664,  664,  329,  330,  664,  664,
 /* 12460 */   664,  334,  664,  664,  337,  338,  339,  340,  341,  342,
 /* 12470 */   343,  344,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 12480 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 12490 */   664,  664,  664,  664,  664,  664,  664,  480,  481,  482,
 /* 12500 */   664,  484,  485,  486,  487,  488,  489,  664,  664,  664,
 /* 12510 */   664,  664,  495,  496,  497,  498,  499,  500,  664,  502,
 /* 12520 */   503,  394,  395,  664,  664,  664,  664,  664,  664,  664,
 /* 12530 */   664,  664,  515,  516,  664,  518,  664,  664,  664,  664,
 /* 12540 */   664,  318,  664,  416,  664,  664,  323,  324,  325,  326,
 /* 12550 */   664,  664,  329,  330,  664,  664,  664,  334,  664,  664,
 /* 12560 */   337,  338,  339,  340,  341,  342,  343,  344,  664,  664,
 /* 12570 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 12580 */   318,  664,  664,  664,  664,  323,  324,  325,  326,  664,
 /* 12590 */   664,  329,  330,  664,  664,  664,  334,  664,  664,  337,
 /* 12600 */   338,  339,  340,  341,  342,  343,  344,  480,  481,  482,
 /* 12610 */   664,  484,  485,  486,  487,  488,  489,  394,  395,  664,
 /* 12620 */   664,  664,  495,  496,  497,  498,  499,  500,  664,  502,
 /* 12630 */   503,  664,  664,  664,  664,  664,  664,  664,  664,  416,
 /* 12640 */   664,  664,  515,  516,  664,  518,  664,  664,  664,  664,
 /* 12650 */   664,  664,  664,  664,  664,  664,  394,  395,  664,  664,
 /* 12660 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 12670 */   664,  664,  664,  664,  664,  664,  318,  664,  416,  664,
 /* 12680 */   664,  323,  324,  325,  326,  664,  664,  329,  330,  664,
 /* 12690 */   664,  664,  334,  664,  664,  337,  338,  339,  340,  341,
 /* 12700 */   342,  343,  344,  480,  481,  482,  664,  484,  485,  486,
 /* 12710 */   487,  488,  489,  664,  664,  664,  664,  664,  495,  496,
 /* 12720 */   497,  498,  499,  500,  664,  502,  503,  664,  664,  664,
 /* 12730 */   664,  664,  664,  664,  664,  664,  664,  664,  515,  516,
 /* 12740 */   664,  518,  480,  481,  482,  664,  484,  485,  486,  487,
 /* 12750 */   488,  489,  394,  395,  664,  664,  664,  495,  496,  497,
 /* 12760 */   498,  499,  500,  664,  502,  503,  664,  664,  664,  664,
 /* 12770 */   664,  664,  664,  664,  416,  664,  664,  515,  516,  664,
 /* 12780 */   518,  664,  664,  664,  664,  664,  318,  664,  664,  664,
 /* 12790 */   664,  323,  324,  325,  326,  664,  664,  329,  330,  664,
 /* 12800 */   664,  664,  334,  664,  664,  337,  338,  339,  340,  341,
 /* 12810 */   342,  343,  344,  664,  664,  664,  664,  664,  664,  664,
 /* 12820 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 12830 */   664,  664,  664,  664,  664,  664,  664,  664,  480,  481,
 /* 12840 */   482,  664,  484,  485,  486,  487,  488,  489,  664,  664,
 /* 12850 */   664,  664,  664,  495,  496,  497,  498,  499,  500,  664,
 /* 12860 */   502,  503,  394,  395,  664,  664,  664,  664,  664,  664,
 /* 12870 */   664,  664,  664,  515,  516,  664,  518,  664,  664,  664,
 /* 12880 */   664,  664,  318,  664,  416,  664,  664,  323,  324,  325,
 /* 12890 */   326,  664,  664,  329,  330,  664,  664,  664,  334,  664,
 /* 12900 */   664,  337,  338,  339,  340,  341,  342,  343,  344,  664,
 /* 12910 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 12920 */   664,  318,  664,  664,  664,  664,  323,  324,  325,  326,
 /* 12930 */   664,  664,  329,  330,  664,  664,  664,  334,  664,  664,
 /* 12940 */   337,  338,  339,  340,  341,  342,  343,  344,  480,  481,
 /* 12950 */   482,  664,  484,  485,  486,  487,  488,  489,  394,  395,
 /* 12960 */   664,  664,  664,  495,  496,  497,  498,  499,  500,  664,
 /* 12970 */   502,  503,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 12980 */   416,  664,  664,  515,  516,  664,  518,  664,  664,  664,
 /* 12990 */   664,  664,  664,  664,  664,  664,  664,  394,  395,  664,
 /* 13000 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 13010 */   664,  664,  664,  664,  664,  664,  664,  318,  664,  416,
 /* 13020 */   664,  664,  323,  324,  325,  326,  664,  664,  329,  330,
 /* 13030 */   664,  664,  664,  334,  664,  664,  337,  338,  339,  340,
 /* 13040 */   341,  342,  343,  344,  480,  481,  482,  664,  484,  485,
 /* 13050 */   486,  487,  488,  489,  664,  664,  664,  664,  664,  495,
 /* 13060 */   496,  497,  498,  499,  500,  664,  502,  503,  664,  664,
 /* 13070 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  515,
 /* 13080 */   516,  664,  518,  480,  481,  482,  664,  484,  485,  486,
 /* 13090 */   487,  488,  489,  394,  395,  664,  664,  664,  495,  496,
 /* 13100 */   497,  498,  499,  500,  664,  502,  503,  664,  664,  664,
 /* 13110 */   664,  664,  664,  664,  319,  416,  321,  322,  515,  516,
 /* 13120 */   664,  518,  664,  664,  329,  330,  664,  664,  664,  664,
 /* 13130 */   335,  664,  337,  338,  339,  340,  341,  342,  343,  344,
 /* 13140 */   664,  664,  664,  664,   37,   38,  664,  664,  664,  664,
 /* 13150 */   664,  664,  664,   46,   47,  664,  664,   50,   51,   52,
 /* 13160 */    53,   54,   55,   56,   57,   58,  664,  664,  664,  664,
 /* 13170 */   664,  664,  664,   66,  664,   68,  664,  664,  664,  480,
 /* 13180 */   481,  482,  664,  484,  485,  486,  487,  488,  489,  394,
 /* 13190 */   395,  664,  664,  664,  495,  496,  497,  498,  499,  500,
 /* 13200 */    93,  502,  503,  664,  664,  664,   99,  664,  664,  664,
 /* 13210 */   664,  664,  664,  664,  515,  516,  664,  518,  664,  664,
 /* 13220 */   664,  664,  664,  116,  664,  430,  664,  664,  664,  664,
 /* 13230 */   664,  664,  664,  664,  664,  664,  664,  130,  131,  132,
 /* 13240 */   133,  134,  135,  136,  664,  664,  139,  664,  453,  664,
 /* 13250 */   664,  144,  145,  146,  459,  148,  149,  664,  664,  464,
 /* 13260 */   664,  664,  664,  468,  469,  470,  471,  472,  664,  664,
 /* 13270 */   664,  664,  664,  664,  664,  480,  481,  482,  664,  664,
 /* 13280 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 13290 */   495,  496,  497,  498,  499,  500,  664,  502,  503,  664,
 /* 13300 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 13310 */   515,  516,  664,  518,  664,  664,  318,  664,  664,  664,
 /* 13320 */   664,  323,  324,  325,  326,  664,  664,  329,  330,  664,
 /* 13330 */   664,  664,  334,  664,  664,  337,  338,  339,  340,  341,
 /* 13340 */   342,  343,  344,  664,  664,  664,  664,  664,  664,  664,
 /* 13350 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 13360 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 13370 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 13380 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 13390 */   664,  664,  394,  395,  664,  664,  664,  664,  664,  319,
 /* 13400 */   664,  321,  322,  664,  664,  664,  664,  664,  664,  329,
 /* 13410 */   330,  664,  664,  664,  416,  335,  664,  337,  338,  339,
 /* 13420 */   340,  341,  342,  343,  344,  664,  664,  664,  664,  664,
 /* 13430 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 13440 */   664,  664,  664,  318,  664,  664,  664,  664,  323,  324,
 /* 13450 */   325,  326,  664,  664,  329,  330,  664,  664,  664,  334,
 /* 13460 */   664,  664,  337,  338,  339,  340,  341,  342,  343,  344,
 /* 13470 */   664,  664,  664,  664,  394,  395,  664,  664,  480,  481,
 /* 13480 */   482,  664,  484,  485,  486,  487,  488,  489,  664,  664,
 /* 13490 */   664,  664,  664,  495,  496,  497,  498,  499,  500,  664,
 /* 13500 */   502,  503,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 13510 */   430,  664,  664,  515,  516,  664,  518,  664,  664,  394,
 /* 13520 */   395,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 13530 */   664,  664,  664,  453,  664,  664,  664,  664,  664,  459,
 /* 13540 */   664,  416,  664,  664,  464,  664,  664,  664,  468,  469,
 /* 13550 */   470,  471,  472,  664,  664,  664,  664,  664,  664,  664,
 /* 13560 */   480,  481,  482,  664,  664,  664,  664,  664,  664,  664,
 /* 13570 */   664,  664,  664,  664,  664,  495,  496,  497,  498,  499,
 /* 13580 */   500,  664,  502,  503,  664,  664,  664,  664,  664,  664,
 /* 13590 */   664,  664,  664,  664,  664,  515,  516,  664,  518,  664,
 /* 13600 */   664,  664,  664,  664,  664,  480,  481,  482,  664,  484,
 /* 13610 */   485,  486,  487,  488,  489,  664,  664,  664,  664,  664,
 /* 13620 */   495,  496,  497,  498,  499,  500,  664,  502,  503,  664,
 /* 13630 */   664,  664,  664,  664,  664,  664,  319,  664,  321,  322,
 /* 13640 */   515,  516,  664,  518,  664,  664,  329,  330,  664,  664,
 /* 13650 */   664,  664,  335,  664,  337,  338,  339,  340,  341,  342,
 /* 13660 */   343,  344,  664,  664,  664,   37,   38,  664,  664,  664,
 /* 13670 */   664,  664,  664,  664,   46,   47,  664,  664,   50,   51,
 /* 13680 */    52,   53,   54,   55,   56,   57,   58,  664,  664,  664,
 /* 13690 */   664,  664,  664,  664,   66,  664,  664,  664,  664,  664,
 /* 13700 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 13710 */   664,  394,  395,  664,  664,  664,  664,  664,  664,  664,
 /* 13720 */   664,   93,  664,  664,  664,  664,  664,   99,  664,  318,
 /* 13730 */   664,  664,  664,  664,  323,  324,  325,  326,  664,  664,
 /* 13740 */   329,  330,  664,  664,  116,  334,  664,  430,  337,  338,
 /* 13750 */   339,  340,  341,  342,  343,  344,  664,  664,  130,  131,
 /* 13760 */   132,  133,  134,  135,  136,  664,  664,  139,  664,  664,
 /* 13770 */   453,  664,  144,  145,  146,  664,  459,  664,  664,  664,
 /* 13780 */   664,  464,  664,  664,  664,  468,  469,  470,  471,  472,
 /* 13790 */   664,  664,  664,  664,  664,  664,  664,  480,  481,  482,
 /* 13800 */   664,  664,  664,  664,  664,  394,  395,  664,  664,  664,
 /* 13810 */   664,  664,  495,  496,  497,  498,  499,  500,  664,  502,
 /* 13820 */   503,  664,  664,  664,  664,  664,  664,  416,  664,  664,
 /* 13830 */   664,  664,  515,  516,  664,  518,  664,  664,  664,  664,
 /* 13840 */   319,  664,  321,  322,  664,  664,  664,  664,  664,  664,
 /* 13850 */   329,  330,  664,  664,  664,  664,  335,  664,  337,  338,
 /* 13860 */   339,  340,  341,  342,  343,  344,  664,  664,  664,  664,
 /* 13870 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 13880 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 13890 */   664,  480,  481,  482,  664,  484,  485,  486,  487,  488,
 /* 13900 */   489,  664,  664,  664,  664,  664,  495,  496,  497,  498,
 /* 13910 */   499,  500,  664,  502,  503,  394,  395,  664,  664,  664,
 /* 13920 */   664,  664,  664,  664,  664,  664,  515,  516,  664,  518,
 /* 13930 */   664,  664,  664,  318,  664,  664,  664,  664,  323,  324,
 /* 13940 */   325,  326,  664,  664,  329,  330,  664,  664,  664,  334,
 /* 13950 */   664,  430,  337,  338,  339,  340,  341,  342,  343,  344,
 /* 13960 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 13970 */   664,  664,  664,  664,  453,  664,  664,  664,  664,  664,
 /* 13980 */   664,  664,  461,  664,  664,  464,  664,  664,  664,  468,
 /* 13990 */   469,  470,  471,  472,  664,  664,  664,  664,  664,  664,
 /* 14000 */   664,  480,  481,  482,  664,  664,  664,  664,  664,  394,
 /* 14010 */   395,  664,  664,  664,  664,  664,  495,  496,  497,  498,
 /* 14020 */   499,  500,  664,  502,  503,  664,  664,  664,  664,  664,
 /* 14030 */   664,  416,  319,  664,  321,  322,  515,  516,  664,  518,
 /* 14040 */   664,  664,  329,  330,  664,  664,  664,  664,  335,  664,
 /* 14050 */   337,  338,  339,  340,  341,  342,  343,  344,  664,  664,
 /* 14060 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14070 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14080 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14090 */   664,  664,  664,  664,  664,  480,  481,  482,  664,  484,
 /* 14100 */   485,  486,  487,  488,  489,  664,  664,  394,  395,  664,
 /* 14110 */   495,  496,  497,  498,  499,  500,  664,  502,  503,  664,
 /* 14120 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14130 */   515,  516,  664,  518,  664,  664,  664,  664,  664,  664,
 /* 14140 */   664,  664,  664,  430,  664,  664,  664,  664,  664,  664,
 /* 14150 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14160 */   664,  664,  664,  664,  664,  452,  453,  664,  664,  664,
 /* 14170 */   664,  664,  664,  664,  664,  664,  664,  464,  664,  664,
 /* 14180 */   664,  468,  469,  470,  471,  472,  664,  664,  664,  664,
 /* 14190 */   664,  664,  664,  480,  481,  482,  664,  664,  664,  664,
 /* 14200 */   664,  664,  664,  664,  664,  664,  664,  664,  495,  496,
 /* 14210 */   497,  498,  499,  500,  318,  502,  503,  664,  664,  323,
 /* 14220 */   324,  325,  326,  664,  664,  329,  330,  664,  515,  516,
 /* 14230 */   334,  518,  664,  337,  338,  339,  340,  341,  342,  343,
 /* 14240 */   344,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14250 */   664,  664,   43,   44,   45,  664,  664,  664,  664,   50,
 /* 14260 */    51,   52,   53,   54,   55,   56,   57,   58,  664,  664,
 /* 14270 */   664,  664,  664,  664,  664,   66,  319,   68,  321,  322,
 /* 14280 */   664,  664,  664,  664,  664,  664,  329,  330,  664,  664,
 /* 14290 */   394,  395,  335,  664,  337,  338,  339,  340,  341,  342,
 /* 14300 */   343,  344,   93,  664,  664,  664,   97,   98,   99,  100,
 /* 14310 */   101,  102,  416,  664,  105,  106,  107,  108,  109,  664,
 /* 14320 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14330 */   664,  122,  664,  124,  664,  126,  127,  664,  664,  664,
 /* 14340 */   664,  664,  133,  664,  664,  664,  664,  664,  139,  664,
 /* 14350 */   664,  394,  395,  144,  145,  146,  664,  148,  149,  664,
 /* 14360 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14370 */   664,  664,  664,  664,  664,  664,  480,  481,  482,  664,
 /* 14380 */   484,  485,  486,  487,  488,  489,  664,  430,  664,  664,
 /* 14390 */   664,  495,  496,  497,  498,  499,  500,  664,  502,  503,
 /* 14400 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14410 */   453,  515,  516,  664,  518,  664,  664,  664,  664,  664,
 /* 14420 */   664,  464,  664,  664,  664,  468,  469,  470,  471,  472,
 /* 14430 */   664,  664,  664,  664,  664,  664,  664,  480,  481,  482,
 /* 14440 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14450 */   664,  664,  495,  496,  497,  498,  499,  500,  664,  502,
 /* 14460 */   503,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14470 */   664,  664,  515,  516,  664,  518,  664,  664,  664,  664,
 /* 14480 */   664,  664,  664,  664,  664,  319,  664,  321,  322,  664,
 /* 14490 */   664,  664,  664,  664,  664,  329,  330,  664,  664,  664,
 /* 14500 */   664,  335,  664,  337,  338,  339,  340,  341,  342,  343,
 /* 14510 */   344,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14520 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14530 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14540 */   664,  664,  664,  664,  664,  664,  319,  664,  321,  322,
 /* 14550 */   664,  664,  664,  664,  664,  664,  329,  330,  664,  664,
 /* 14560 */   394,  395,  335,  664,  337,  338,  339,  340,  341,  342,
 /* 14570 */   343,  344,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14580 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14590 */   664,  664,  664,  664,  664,  664,  430,  664,  664,  664,
 /* 14600 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14610 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  453,
 /* 14620 */   664,  394,  395,  664,  664,  664,  664,  664,  664,  664,
 /* 14630 */   464,  664,  664,  664,  468,  469,  470,  471,  472,  664,
 /* 14640 */   664,  664,  664,  664,  664,  664,  480,  481,  482,  664,
 /* 14650 */   664,  664,  664,  664,  664,  664,  664,  430,  664,  664,
 /* 14660 */   664,  495,  496,  497,  498,  499,  500,  664,  502,  503,
 /* 14670 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14680 */   453,  515,  516,  664,  518,  664,  664,  664,  664,  664,
 /* 14690 */   664,  464,  664,  664,  664,  468,  469,  470,  471,  472,
 /* 14700 */   664,  664,  664,  664,  664,  664,  664,  480,  481,  482,
 /* 14710 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14720 */   664,  664,  495,  496,  497,  498,  499,  500,  664,  502,
 /* 14730 */   503,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14740 */   664,  664,  515,  516,  664,  518,  319,  664,  321,  322,
 /* 14750 */   664,  664,  664,  664,  664,  664,  329,  330,  664,  664,
 /* 14760 */   664,  664,  335,  664,  337,  338,  339,  340,  341,  342,
 /* 14770 */   343,  344,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14780 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14790 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14800 */   664,  664,  664,  664,  664,  664,  664,  319,  664,  321,
 /* 14810 */   322,  664,  664,  664,  664,  664,  664,  329,  330,  664,
 /* 14820 */   664,  394,  395,  335,  664,  337,  338,  339,  340,  341,
 /* 14830 */   342,  343,  344,  664,  664,  664,  664,  664,  664,  664,
 /* 14840 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14850 */   664,  664,  664,  664,  664,  664,  664,  430,  664,  664,
 /* 14860 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14870 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14880 */   664,  664,  394,  395,  664,  664,  664,  664,  664,  664,
 /* 14890 */   664,  464,  664,  664,  664,  468,  469,  470,  471,  472,
 /* 14900 */   664,  664,  664,  664,  664,  664,  664,  480,  481,  482,
 /* 14910 */   664,  664,  664,  664,  664,  664,  664,  664,  430,  664,
 /* 14920 */   664,  664,  495,  496,  497,  498,  499,  500,  664,  502,
 /* 14930 */   503,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14940 */   664,  664,  515,  516,  664,  518,  664,  664,  664,  664,
 /* 14950 */   664,  664,  464,  664,  664,  664,  468,  469,  470,  471,
 /* 14960 */   472,  664,  664,  664,  664,  664,  664,  664,  480,  481,
 /* 14970 */   482,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 14980 */   664,  664,  664,  495,  496,  497,  498,  499,  500,  664,
 /* 14990 */   502,  503,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 15000 */   664,  664,  664,  515,  516,  664,  518,  664,  664,  664,
 /* 15010 */   664,  319,  664,  321,  322,  664,  664,  664,  664,  664,
 /* 15020 */   664,  329,  330,  664,  664,  664,  664,  335,  664,  337,
 /* 15030 */   338,  339,  340,  341,  342,  343,  344,  664,  664,  664,
 /* 15040 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 15050 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 15060 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 15070 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 15080 */   664,  664,  319,  664,  321,  322,  394,  395,  664,  664,
 /* 15090 */   664,  664,  329,  330,  664,  664,  664,  664,  335,  664,
 /* 15100 */   337,  338,  339,  340,  341,  342,  343,  344,  664,  664,
 /* 15110 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 15120 */   664,  664,  430,  664,  664,  664,  664,  664,  664,  664,
 /* 15130 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 15140 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 15150 */   664,  664,  664,  664,  664,  664,  464,  394,  395,  664,
 /* 15160 */   468,  469,  470,  471,  472,  664,  664,  664,  664,  664,
 /* 15170 */   664,  664,  480,  481,  482,  664,  664,  664,  664,  664,
 /* 15180 */   664,  664,  664,  664,  664,  664,  664,  495,  496,  497,
 /* 15190 */   498,  499,  500,  430,  502,  503,  664,  664,  664,  664,
 /* 15200 */   664,  664,  664,  664,  664,  664,  664,  515,  516,  664,
 /* 15210 */   518,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 15220 */   664,  664,  664,  664,  664,  664,  664,  464,  664,  664,
 /* 15230 */   664,  468,  469,  470,  471,  472,  664,  664,  664,  664,
 /* 15240 */   664,  664,  664,  480,  481,  482,  664,  664,  664,  664,
 /* 15250 */   664,  664,  664,  664,  664,  664,  664,  664,  495,  496,
 /* 15260 */   497,  498,  499,  500,  664,  502,  503,  664,  664,  664,
 /* 15270 */   664,  664,  319,  664,  321,  322,  664,  664,  515,  516,
 /* 15280 */   664,  518,  329,  330,  664,  664,  664,  664,  335,  664,
 /* 15290 */   337,  338,  339,  340,  341,  342,  343,  344,  664,  664,
 /* 15300 */   664,  664,  664,  664,  664,  664,  664,  664,  664,   43,
 /* 15310 */    44,   45,  664,  664,  664,  664,   50,   51,   52,   53,
 /* 15320 */    54,   55,   56,   57,   58,  664,  664,  664,  664,  664,
 /* 15330 */   664,  664,   66,  319,  664,  321,  322,  664,  664,  664,
 /* 15340 */   664,  664,  664,  329,  330,  664,  664,  394,  395,  335,
 /* 15350 */   664,  337,  338,  339,  340,  341,  342,  343,  344,   93,
 /* 15360 */    94,   95,  664,   97,   98,   99,  100,  101,  102,  664,
 /* 15370 */   664,  105,  106,  107,  108,  109,  664,  664,  664,  664,
 /* 15380 */   664,  664,  664,  430,  664,  664,  664,  664,  122,  664,
 /* 15390 */   124,  664,  126,  127,  664,  664,  664,  664,  664,  133,
 /* 15400 */   664,  664,  664,  664,  664,  139,   62,  664,  394,  395,
 /* 15410 */   144,  145,  146,  664,  664,  664,  664,  464,  664,  664,
 /* 15420 */   664,  468,  469,  470,  471,  472,  664,  664,  664,  664,
 /* 15430 */   664,  664,  664,  480,  481,  482,  664,  664,  664,  664,
 /* 15440 */   664,  664,  664,  664,  430,  664,  664,  664,  495,  496,
 /* 15450 */   497,  498,  499,  500,  664,  502,  503,  664,  114,  664,
 /* 15460 */   664,  117,  664,  664,  664,  121,  664,  664,  515,  516,
 /* 15470 */   664,  518,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 15480 */   664,  664,  468,  469,  470,  471,  472,  664,  664,  664,
 /* 15490 */   146,  664,  664,  149,  480,  481,  482,  664,  664,  664,
 /* 15500 */   156,  664,  664,  664,  664,  664,  664,  664,  664,  495,
 /* 15510 */   496,  497,  498,  499,  500,  664,  502,  503,  664,  664,
 /* 15520 */   664,  664,  664,  179,  664,  664,  664,  664,  664,  515,
 /* 15530 */   516,  664,  518,  664,  664,  664,  192,  193,  194,  664,
 /* 15540 */   664,  664,  664,  664,  664,  664,  664,  319,  664,  321,
 /* 15550 */   322,  664,  664,  664,  664,  664,  664,  329,  330,  664,
 /* 15560 */   664,  217,  664,  335,  664,  337,  338,  339,  340,  341,
 /* 15570 */   342,  343,  344,  664,  230,  664,  664,  664,  664,  235,
 /* 15580 */   664,  664,  664,  239,  240,  664,  242,  664,  664,  664,
 /* 15590 */   664,  664,  664,  664,  250,  664,  664,  664,  664,  664,
 /* 15600 */   664,  664,  664,  664,  664,  664,  664,  664,  319,  664,
 /* 15610 */   321,  322,  664,  664,  664,  664,  664,  664,  329,  330,
 /* 15620 */   664,  664,  394,  395,  335,  664,  337,  338,  339,  340,
 /* 15630 */   341,  342,  343,  344,  664,  664,  664,  664,  664,  664,
 /* 15640 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 15650 */   664,  664,  664,  664,  664,  664,  664,  664,  430,  664,
 /* 15660 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 15670 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 15680 */   664,  664,  664,  394,  395,  664,  664,  664,  664,  664,
 /* 15690 */   664,  664,  664,  664,  664,  664,  468,  469,  470,  471,
 /* 15700 */   472,  664,  664,  664,  664,  664,  664,  664,  480,  481,
 /* 15710 */   482,  664,  664,  664,  664,  664,  664,  664,  664,  430,
 /* 15720 */   664,  664,  664,  495,  496,  497,  498,  499,  500,  664,
 /* 15730 */   502,  503,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 15740 */   664,  664,  664,  515,  516,  664,  518,  664,  664,  664,
 /* 15750 */   664,  664,  664,  664,  664,  664,  664,  468,  469,  470,
 /* 15760 */   471,  472,  664,  664,  664,  664,  664,  664,  664,  480,
 /* 15770 */   481,  482,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 15780 */   664,  664,  664,  664,  495,  496,  497,  498,  499,  500,
 /* 15790 */   664,  502,  503,  664,  664,  664,  664,  664,  664,  664,
 /* 15800 */   664,  664,  664,  664,  515,  516,  319,  518,  321,  322,
 /* 15810 */   664,  664,  664,  664,  664,  664,  329,  330,  664,  664,
 /* 15820 */   664,  664,  335,  664,  337,  338,  339,  340,  341,  342,
 /* 15830 */   343,  344,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 15840 */   664,  664,  664,  664,  664,  664,  664,  664,   43,   44,
 /* 15850 */    45,  664,  664,  664,  664,   50,   51,   52,   53,   54,
 /* 15860 */    55,   56,   57,   58,  664,  664,  664,  319,  664,  321,
 /* 15870 */   322,   66,  664,  664,  664,  664,  664,  329,  330,  664,
 /* 15880 */   664,  394,  395,  335,  664,  337,  338,  339,  340,  341,
 /* 15890 */   342,  343,  344,  664,  664,  664,  664,  664,   93,  664,
 /* 15900 */   664,  664,   97,   98,   99,  100,  101,  102,  664,  664,
 /* 15910 */   105,  106,  107,  108,  109,  664,  664,  430,  664,  664,
 /* 15920 */   664,  664,  664,  664,  664,  664,  664,  122,  664,  124,
 /* 15930 */   664,  126,  127,  664,  664,  664,  664,  664,  133,  664,
 /* 15940 */   664,  664,  394,  395,  139,  664,  664,  664,  664,  144,
 /* 15950 */   145,  146,  664,  664,  664,  468,  469,  470,  471,  472,
 /* 15960 */   664,  664,  664,  664,  664,  664,  664,  480,  481,  482,
 /* 15970 */   664,  664,  664,  664,  664,  664,  664,  664,  430,  664,
 /* 15980 */   664,  664,  495,  496,  497,  498,  499,  500,  664,  502,
 /* 15990 */   503,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16000 */   664,  664,  515,  516,  664,  518,  664,  664,  664,  664,
 /* 16010 */   664,  664,  664,  664,  664,  664,  468,  469,  470,  471,
 /* 16020 */   472,  664,  664,  664,  664,  664,  664,  664,  480,  481,
 /* 16030 */   482,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16040 */   664,  664,  664,  495,  496,  497,  498,  499,  500,  664,
 /* 16050 */   502,  503,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16060 */   664,  664,  664,  515,  516,  664,  518,  664,  664,  664,
 /* 16070 */   664,  664,  664,  664,  664,  664,  664,  319,  664,  321,
 /* 16080 */   322,  664,  664,  664,  664,  664,  664,  329,  330,  664,
 /* 16090 */   664,  664,  664,  335,  664,  337,  338,  339,  340,  341,
 /* 16100 */   342,  343,  344,  664,  664,  664,  664,  664,  664,  664,
 /* 16110 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16120 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16130 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16140 */   664,  664,  664,  664,  664,  664,  664,  664,  319,  664,
 /* 16150 */   321,  322,  394,  395,  664,  664,  664,  664,  329,  330,
 /* 16160 */   664,  664,  664,  664,  335,  664,  337,  338,  339,  340,
 /* 16170 */   341,  342,  343,  344,  664,  664,  664,  664,  664,  664,
 /* 16180 */   664,  664,  664,  664,  664,  664,  664,  664,  430,  664,
 /* 16190 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16200 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16210 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16220 */   664,  664,  664,  394,  395,  664,  468,  469,  470,  471,
 /* 16230 */   472,  664,  664,  664,  664,  664,  664,  664,  480,  481,
 /* 16240 */   482,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16250 */   664,  664,  664,  495,  496,  497,  498,  499,  500,  430,
 /* 16260 */   502,  503,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16270 */   664,  664,  664,  515,  516,  664,  518,  664,  664,  664,
 /* 16280 */   664,  664,  664,  664,  664,  664,  664,  268,  664,  664,
 /* 16290 */   664,  664,  664,  664,  664,  664,  664,  468,  469,  470,
 /* 16300 */   471,  472,  664,  664,  664,  664,  664,  664,  664,  480,
 /* 16310 */   481,  482,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16320 */   664,  664,  664,  664,  495,  496,  497,  498,  499,  500,
 /* 16330 */   664,  502,  503,  664,  664,  664,  664,  664,  664,  664,
 /* 16340 */   664,  664,  664,  664,  515,  516,  664,  518,  329,  330,
 /* 16350 */   664,  664,  664,  664,  664,  664,  337,  338,  339,  340,
 /* 16360 */   341,  342,  343,  344,  345,  664,  664,  664,  349,  664,
 /* 16370 */   664,  664,  664,  664,  664,  664,  357,  358,  359,  360,
 /* 16380 */   361,  362,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16390 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  319,
 /* 16400 */   664,  321,  322,  664,  664,  664,  664,  664,  664,  329,
 /* 16410 */   330,  664,  664,  394,  395,  335,  664,  337,  338,  339,
 /* 16420 */   340,  341,  342,  343,  344,  664,  664,  664,  664,  664,
 /* 16430 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16440 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16450 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16460 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16470 */   319,  664,  321,  322,  394,  395,  664,  664,  664,  664,
 /* 16480 */   329,  330,  664,  664,  664,  664,  335,  664,  337,  338,
 /* 16490 */   339,  340,  341,  342,  343,  344,  664,  664,  664,  480,
 /* 16500 */   481,  482,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16510 */   430,  664,  664,  664,  495,  496,  497,  498,  499,  500,
 /* 16520 */   664,  502,  503,  664,  664,  664,  664,  664,  664,  664,
 /* 16530 */   664,  664,  664,  514,  515,  516,  664,  518,  664,  664,
 /* 16540 */   664,  664,  664,  664,  664,  394,  395,  664,  468,  469,
 /* 16550 */   470,  471,  472,  664,  664,  664,  664,  664,  664,  664,
 /* 16560 */   480,  481,  482,  664,  664,  664,  664,  664,  664,  664,
 /* 16570 */   664,  664,  664,  664,  664,  495,  496,  497,  498,  499,
 /* 16580 */   500,  430,  502,  503,  664,  664,  664,  664,  664,  664,
 /* 16590 */   664,  664,  664,  664,  664,  515,  516,  664,  518,  664,
 /* 16600 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16610 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  468,
 /* 16620 */   469,  470,  471,  472,  664,  664,  664,  664,  664,  664,
 /* 16630 */   664,  480,  481,  482,  664,  664,  664,  664,  664,  664,
 /* 16640 */   664,  664,  664,  664,  664,  268,  495,  496,  497,  498,
 /* 16650 */   499,  500,  664,  502,  503,  664,  664,  664,  664,  664,
 /* 16660 */   664,  664,  664,  664,  664,  664,  515,  516,  319,  518,
 /* 16670 */   321,  322,  664,  664,  664,  664,  664,  664,  329,  330,
 /* 16680 */   664,  664,  664,  664,  335,  664,  337,  338,  339,  340,
 /* 16690 */   341,  342,  343,  344,  664,  664,  664,  664,  664,  664,
 /* 16700 */   664,  664,  664,  664,  664,  664,  329,  330,  664,  664,
 /* 16710 */   664,  664,  664,  664,  337,  338,  339,  340,  341,  342,
 /* 16720 */   343,  344,  345,  664,  664,  664,  349,  664,  664,  664,
 /* 16730 */   664,  664,  664,  664,  357,  358,  359,  360,  361,  362,
 /* 16740 */   664,  664,  664,  394,  395,  664,  664,  664,  664,  664,
 /* 16750 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16760 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16770 */   664,  394,  395,  664,  664,  664,  664,  664,  664,  430,
 /* 16780 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16790 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16800 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16810 */   664,  664,  664,  664,  664,  664,  664,  468,  469,  470,
 /* 16820 */   471,  472,  664,  664,  664,  664,  664,  664,  664,  480,
 /* 16830 */   481,  482,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16840 */   664,  664,  664,  664,  495,  496,  497,  498,  499,  500,
 /* 16850 */   664,  502,  503,  664,  664,  664,  664,  480,  481,  482,
 /* 16860 */   664,  664,  664,  664,  515,  516,  664,  518,  664,  664,
 /* 16870 */   664,  664,  495,  496,  497,  498,  499,  500,  664,  502,
 /* 16880 */   503,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16890 */   664,  514,  515,  516,  664,  518,  319,  664,  321,  322,
 /* 16900 */   664,  664,  664,  664,  664,  664,  329,  330,  664,  664,
 /* 16910 */   664,  664,  335,  664,  337,  338,  339,  340,  341,  342,
 /* 16920 */   343,  344,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16930 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16940 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16950 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 16960 */   664,  664,  664,  664,  664,  664,  664,  319,  664,  321,
 /* 16970 */   322,  394,  395,  664,  664,  664,  664,  329,  330,  664,
 /* 16980 */   664,  664,  664,  335,  664,  337,  338,  339,  340,  341,
 /* 16990 */   342,  343,  344,  664,  664,  664,  664,  664,  664,  664,
 /* 17000 */   664,  664,  664,  664,  664,  664,  664,  430,  664,  664,
 /* 17010 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17020 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17030 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17040 */   664,  664,  394,  395,  664,  468,  469,  470,  471,  472,
 /* 17050 */   664,  664,  664,  664,  664,  664,  664,  480,  481,  482,
 /* 17060 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17070 */   664,  664,  495,  496,  497,  498,  499,  500,  430,  502,
 /* 17080 */   503,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17090 */   664,  664,  515,  516,  664,  518,  664,  664,  664,  664,
 /* 17100 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17110 */   664,  664,  664,  664,  664,  664,  468,  469,  470,  471,
 /* 17120 */   472,  664,  664,  664,  664,  664,  664,  664,  480,  481,
 /* 17130 */   482,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17140 */   664,  664,  664,  495,  496,  497,  498,  499,  500,  664,
 /* 17150 */   502,  503,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17160 */   664,  664,  664,  515,  516,  319,  518,  321,  322,  664,
 /* 17170 */   664,  664,  664,  664,  664,  329,  330,  664,  664,  664,
 /* 17180 */   664,  335,  664,  337,  338,  339,  340,  341,  342,  343,
 /* 17190 */   344,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17200 */   664,  664,  664,  664,  664,  664,  664,   43,   44,   45,
 /* 17210 */   664,  664,  664,  664,   50,   51,   52,   53,   54,   55,
 /* 17220 */    56,   57,   58,  664,  664,  664,  319,  664,  321,  322,
 /* 17230 */    66,  664,  664,  664,  664,  664,  329,  330,  664,  664,
 /* 17240 */   394,  395,  335,  664,  337,  338,  339,  340,  341,  342,
 /* 17250 */   343,  344,  664,  664,  664,  664,  664,   93,  664,  664,
 /* 17260 */   664,  664,   98,   99,  100,  101,  102,  664,  664,  105,
 /* 17270 */   106,  107,  108,  109,  664,  664,  430,  664,  664,  664,
 /* 17280 */   664,  664,  664,  664,  664,  664,  122,  664,  124,  664,
 /* 17290 */   126,  127,  664,  664,  664,  664,  664,  133,  664,  664,
 /* 17300 */   664,  394,  395,  139,  664,  664,  664,  664,  144,  145,
 /* 17310 */   146,  664,  664,  664,  468,  469,  470,  471,  472,  664,
 /* 17320 */   664,  664,  664,  664,  664,  664,  480,  481,  482,  664,
 /* 17330 */   664,  664,  664,  664,  664,  664,  664,  430,  664,  664,
 /* 17340 */   664,  495,  496,  497,  498,  499,  500,  664,  502,  503,
 /* 17350 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17360 */   664,  515,  516,  664,  518,  664,  664,  664,  664,  664,
 /* 17370 */   664,  664,  664,  664,  664,  468,  469,  470,  471,  472,
 /* 17380 */   664,  664,  664,  664,  664,  664,  664,  480,  481,  482,
 /* 17390 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17400 */   664,  664,  495,  496,  497,  498,  499,  500,  664,  502,
 /* 17410 */   503,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17420 */   664,  664,  515,  516,  664,  518,  664,  664,  664,  664,
 /* 17430 */   664,  664,  664,  664,  664,  664,  319,  664,  321,  322,
 /* 17440 */   664,  664,  664,  664,  664,  664,  329,  330,  664,  664,
 /* 17450 */   664,  664,  335,  664,  337,  338,  339,  340,  341,  342,
 /* 17460 */   343,  344,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17470 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17480 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17490 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17500 */   664,  664,  664,  664,  664,  664,  664,  319,  664,  321,
 /* 17510 */   322,  394,  395,  664,  664,  664,  664,  329,  330,  664,
 /* 17520 */   664,  664,  664,  335,  664,  337,  338,  339,  340,  341,
 /* 17530 */   342,  343,  344,  664,  664,  664,  664,  664,  664,  664,
 /* 17540 */   664,  664,  664,  664,  664,  664,  664,  430,  664,  664,
 /* 17550 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17560 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17570 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17580 */   664,  664,  394,  395,  664,  468,  469,  470,  471,  472,
 /* 17590 */   664,  664,  664,  664,  664,  664,  664,  480,  481,  482,
 /* 17600 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17610 */   664,  664,  495,  496,  497,  498,  499,  500,  430,  502,
 /* 17620 */   503,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17630 */   664,  664,  515,  516,  664,  518,  664,  664,  664,  664,
 /* 17640 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17650 */   664,  664,  664,  664,  664,  664,  468,  469,  470,  471,
 /* 17660 */   472,  664,  664,  664,  664,  664,  664,  664,  480,  481,
 /* 17670 */   482,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17680 */   664,  664,  664,  495,  496,  497,  498,  499,  500,  664,
 /* 17690 */   502,  503,  664,  664,  664,  664,  664,  319,  664,  321,
 /* 17700 */   322,  664,  664,  515,  516,  664,  518,  329,  330,  664,
 /* 17710 */   664,  664,  664,  335,  664,  337,  338,  339,  340,  341,
 /* 17720 */   342,  343,  344,  664,  664,  664,  664,  664,  664,  664,
 /* 17730 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17740 */   664,   43,   44,   45,  664,  664,  664,  664,   50,   51,
 /* 17750 */    52,   53,   54,   55,   56,   57,   58,  664,  319,  664,
 /* 17760 */   321,  322,  664,  664,   66,   67,  664,  664,  329,  330,
 /* 17770 */   664,  664,  394,  395,  335,  664,  337,  338,  339,  340,
 /* 17780 */   341,  342,  343,  344,  664,  664,  664,  664,  664,  664,
 /* 17790 */   664,   93,  664,  664,  664,  664,  664,   99,  664,  664,
 /* 17800 */   664,  664,  664,  105,  106,  107,  108,  109,  430,  664,
 /* 17810 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17820 */   122,  664,  124,  664,  126,  127,  664,  664,  664,  664,
 /* 17830 */   664,  133,  664,  394,  395,  664,  664,  139,  664,  664,
 /* 17840 */   664,  664,  144,  145,  146,  664,  468,  469,  470,  471,
 /* 17850 */   472,  664,  664,  664,  664,  664,  664,  664,  480,  481,
 /* 17860 */   482,  664,  664,  664,  664,  664,  664,  664,  664,  430,
 /* 17870 */   664,  664,  664,  495,  496,  497,  498,  499,  500,  664,
 /* 17880 */   502,  503,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 17890 */   664,  664,  664,  515,  516,  664,  518,  664,  664,  664,
 /* 17900 */   664,  664,  664,  664,  664,  664,  664,  468,  469,  470,
 /* 17910 */   471,  472,  664,  664,  664,  664,  664,  664,  664,  480,
 /* 17920 */   481,  482,    0,    1,  664,  664,  664,  664,  664,  664,
 /* 17930 */   664,  664,  664,  664,  495,  496,  497,  498,  499,  500,
 /* 17940 */   664,  502,  503,  664,  664,  664,  664,  664,  664,  664,
 /* 17950 */   664,   43,   44,   45,  515,  516,  664,  518,   50,   51,
 /* 17960 */    52,   53,   54,   55,   56,   57,   58,  664,  664,  664,
 /* 17970 */   664,  664,  664,  664,   66,  664,  664,  664,  664,  664,
 /* 17980 */   664,  664,  664,  664,  664,  664,  664,  664,   66,  664,
 /* 17990 */    68,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 18000 */   664,   93,  664,  664,  664,  664,  664,   99,  664,  664,
 /* 18010 */   664,  664,  664,  105,  106,  107,  108,  109,  664,  664,
 /* 18020 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 18030 */   122,  664,  124,  664,  126,  127,  664,  664,  664,  664,
 /* 18040 */   664,  133,  664,  664,  664,  664,  664,  139,  664,    1,
 /* 18050 */   664,  664,  144,  145,  146,  664,  664,  664,  664,  664,
 /* 18060 */   664,  664,  140,  664,  664,  664,  664,  664,  664,  664,
 /* 18070 */   148,  149,  150,  151,  152,  153,  154,  664,  664,  664,
 /* 18080 */   664,  664,  664,  664,  664,  664,  664,  664,  166,  664,
 /* 18090 */   168,  169,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 18100 */   178,  664,  664,  664,  664,  664,  664,  664,  186,  187,
 /* 18110 */   188,  664,  664,  664,   66,  664,   68,  664,  664,  664,
 /* 18120 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 18130 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 18140 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 18150 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 18160 */   664,  664,  664,  664,  664,  664,  244,  245,  664,  247,
 /* 18170 */   664,  664,  664,  664,  664,  253,  254,  664,  664,  257,
 /* 18180 */   258,  259,  260,  664,  664,  664,  664,  664,  140,  664,
 /* 18190 */   664,  664,  664,  664,  664,  664,  148,  149,  150,  151,
 /* 18200 */   152,  153,  154,  664,  664,  664,  664,  664,  664,  664,
 /* 18210 */   664,  664,  664,  664,  166,  664,  168,  169,  664,  664,
 /* 18220 */   664,  664,  664,  664,  664,  664,  178,  664,  664,  664,
 /* 18230 */   664,  664,  664,  664,  186,  187,  188,  664,  664,  664,
 /* 18240 */    43,   44,   45,  664,  664,  664,  664,   50,   51,   52,
 /* 18250 */    53,   54,   55,   56,   57,   58,  664,  664,  664,  664,
 /* 18260 */   664,  664,  664,   66,  664,   68,  664,  664,  664,  664,
 /* 18270 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 18280 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 18290 */    93,  664,  244,  245,  664,  247,   99,  664,  664,  664,
 /* 18300 */   664,  253,  254,  664,  664,  257,  258,  259,  260,  664,
 /* 18310 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  122,
 /* 18320 */   664,  124,  664,  126,  127,  664,  664,  664,  664,  664,
 /* 18330 */   133,  664,  664,  664,  664,  664,  139,  664,  664,  664,
 /* 18340 */   664,  144,  145,  146,  664,  148,  149,  664,  664,   43,
 /* 18350 */    44,   45,  664,  664,  664,  664,   50,   51,   52,   53,
 /* 18360 */    54,   55,   56,   57,   58,  664,  664,  664,  664,  664,
 /* 18370 */   664,  664,   66,  664,  664,  664,  664,  664,  664,  664,
 /* 18380 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 18390 */   664,  664,  664,  664,  664,  664,  664,  664,  664,   93,
 /* 18400 */   664,  664,  664,  664,  664,   99,  664,  664,  664,  664,
 /* 18410 */   664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
 /* 18420 */   664,  664,  664,  664,  664,  664,  664,  664,  122,  664,
 /* 18430 */   124,  664,  126,  127,  664,  664,  664,  664,  664,  133,
 /* 18440 */   664,  664,  664,  664,  664,  139,  664,  664,  664,  664,
 /* 18450 */   144,  145,  146,
};
#define YY_SHIFT_USE_DFLT (-106)
#define YY_SHIFT_MAX 882
static const short yy_shift_ofst[] = {
 /*     0 */  18048, 10355, 10355,  878,  878, 10479, 10479, 10479, 10479, 10479,
 /*    10 */  10479, 10479, 10479, 10479,  878, 1295, 1712, 8221, 8527, 11328,
 /*    20 */  11328, 11328, 11328, 11328, 11328, 11328, 11328, 11328, 11328, 11328,
 /*    30 */  11328, 11328, 11328, 11328, 11328, 11328, 11328, 11328, 11328, 11328,
 /*    40 */  11328, 11328, 11328, 11328, 11328, 11328, 11328, 11328, 11328, 11328,
 /*    50 */  11328, 11328, 11328, 11328, 11328, 17922, 18048, 14209, 14209, 13107,
 /*    60 */  13107, 18197, 18197, 15266, 9511, 15805, 15805, 15805, 15805, 1082,
 /*    70 */  17164, 17908, 17164, 17164, 17164, 17908, 17908, 13628, 13628, 13628,
 /*    80 */  13628, 13628, 13628, 13628, 13628, 13628, 13628, 13628, 13628, 13628,
 /*    90 */  13628, 13628, 13628, 13628, 13628, 13628, 13628, 13628, 13628, 13628,
 /*   100 */  13628, 17698, 17908, 17908, 18306, 18306, 18306, 18306, 18306, 18306,
 /*   110 */  18306, 18306, 18306, 18306, 18306, 18306, 18306, 18306, 18306, 18306,
 /*   120 */  18306, 18306, 18306, 18306, 18306, 18306, 18306, 9656, 9656, 18306,
 /*   130 */  18306, 18306, 18306, 3596, 1924, 1924,   93,   93,   93, 1506,
 /*   140 */    93,   93,   93,  260,  260, 1506, 1506,  509,   48, 2250,
 /*   150 */   929,  831,  831,  584, 1210, 1210, 2633, 1506,  597, 1506,
 /*   160 */  1506, 1506,  831, 1938, 1093, 1152, 1152, 1152, 1152, 3139,
 /*   170 */  3139, 1342, 1342, 1210, 1210,   55,  975,  975,  975,  975,
 /*   180 */   363, 1912, 1912, 1949, 1093, 1949,   37, 1342, 1827,  375,
 /*   190 */  1910, 2536, 2096, 1912, 2096, 1404, 1404,   37,   37,   37,
 /*   200 */  1364, 2151, 1910, 1314, 1293,   34, 1569, 1404, 2101, 2101,
 /*   210 */  2142, 1569, 2416, 2365,   37, 2963,   37,   37, 15344, 1293,
 /*   220 */   159, 1738, 1738, 1738,  159,  854, 1763, 1763, 1763,  159,
 /*   230 */   159,  544,   37,   37,   37, 3078, 3092,   37, 3128, 3128,
 /*   240 */  3152,   37, 3078, 3128,   37,   37, 1164,   37,   37,   37,
 /*   250 */    37, 3128,   37,   37,   37,   37, 3476, 1636,  987, -105,
 /*   260 */   284, 2131, 1681, 2298, 2101,  159, 2602,  599, 1012, 2128,
 /*   270 */  3011,   37, 2859,   37,   37,   37,   37,   37,   37,   37,
 /*   280 */    37,   37,   37,   37,   37,   37, 1164, 1164, 1164,   37,
 /*   290 */    37,   37,   37,   37,  662,   37,  298,   37,   37,   37,
 /*   300 */    37,  934,   37,   37,   37, 1850,   37,  934,   37, 1164,
 /*   310 */    37, 1273, 1164, 2051,   37,   37,   37, 1374, 1374,   37,
 /*   320 */  1374, 1374, 1374,   37,   37, 1164, 1374,   37, 1273, 1374,
 /*   330 */    37, 1374,   37, 1374,   37,   20, 3494,   20, 3643, 3093,
 /*   340 */  3570, 3223, 3223, 2044, 3223, 3223, 3223, 3177, 3577, 3223,
 /*   350 */  3577, 3598, 3597, 3597, 3598, 3518,  883, 3570,   20, 3518,
 /*   360 */   883,   20, 3598,   20, 3576, 3211, 3560, 3211, 3572, 3560,
 /*   370 */  3570, 3556,   20, 3559, 3556, 3518,  883, 3518, 3556,   20,
 /*   380 */  3211, 3475, 3518,   90,   90, 1535,  738, 1535, 1955, -105,
 /*   390 */   940,  965,  905, 1738, 2520, 1540, 2477, 2178, 2413, 3072,
 /*   400 */    37, 1164, 3076, 3055,   37, 3090,  143, 3125, 1164, 3090,
 /*   410 */  3090, 3072, 3069,   37,   37, 2998,   37,   37, 3094,   37,
 /*   420 */  3072,   37, 3096, 3072, 3112,   37,   37, 3158,   37,   37,
 /*   430 */  3086,   37,  486,   37,   37, 3005, 3072, 3130, 3136,   20,
 /*   440 */   333,  468,  823,  883,  880, 1236, 1209, 1361, 1964, 2044,
 /*   450 */  2473, 2473,  823,  823,  823, 2691,  823,  823, 2927, 3136,
 /*   460 */  3104, 3140, 2473,  883, 3033,   20, 2927, 3123, 3181, 2473,
 /*   470 */  3122, 3126, 3123, 2927, 3198, 3123,  883, 3223, 3136, 3177,
 /*   480 */  3136, 2927, 1964, 2927, 3187, 3136, 3088, 3211, 3089, 3151,
 /*   490 */  3259,   20, 3093, 3093, 3257,   20, 2927,  823, 3211,  823,
 /*   500 */  3311, 3196, 3231, 3273,  823, 3292, 2044, 3288, 3136, 3136,
 /*   510 */  2927, -106, 1133, 1133, 1146, 1563, 1420, 1840, 1788,  902,
 /*   520 */  1319, 1933, 2097, 1182, 1247, 1661, 1456, 1742, 1824, 2150,
 /*   530 */  2243, 2252,  526, 2422, 2077,  526,  526, 2002,  526,  350,
 /*   540 */  1666,  526,  526, 2600,  526,  526,  526,  526, 2574, 2589,
 /*   550 */   800, 2495,  749,  502, 2013, 1546, 2632, 2415, 2621, 2837,
 /*   560 */  3070, 3032, 3029, 2977, 2354, 2962, 2970, 2982, 2961, 1841,
 /*   570 */  2981, 2921, 2635, 2874, 2936, 2794, 2915, 2930, 2922, 2920,
 /*   580 */  2884, 2916, 2822, 2870, 2864, 2830, 2747, 2681, 2817, 1758,
 /*   590 */  2813, 2816, 2005, 1818, 2764, 2663, 2761, 2776, 2776, 2755,
 /*   600 */  2719, 2651, 2513, 2755, 2706, 2726, 2705, 2543, 2570, 2258,
 /*   610 */  2694, 2486, 2603, 2453,  722, 2577, 2977, 2962, 3754, 3614,
 /*   620 */  3678, 3651, 3619, 3634, 3527, 3725, 3728, 3630, 3732, 3733,
 /*   630 */  3642, 3645, 3743, 3745, 3741, 3746, 3748, 3655, 3696, 3584,
 /*   640 */  3629, 3815, 3764, 3826, 3760, 3777, 3779, 3754, 3783, 3781,
 /*   650 */  3665, 3793, 3797, 3648, 3825, 3827, 3880, 3883, 3831, 3709,
 /*   660 */  3842, 3761, 3844, 3846, 3858, 3877, 3798, 3879, 3881, 3893,
 /*   670 */  3934, 3873, 3899, 3948, 3901, 3515, 3902, 3904, 3960, 3909,
 /*   680 */  3959, 3914, 3915, 3916, 3911, 3918, 3922, 3925, 3763, 3927,
 /*   690 */  3838, 3947, 3935, 3787, 3945, 3937, 3943, 3859, 3936, 3928,
 /*   700 */  3849, 3924, 3808, 3981, 3980, 3979, 3810, 3975, 3919, 3917,
 /*   710 */  3762, 3754, 3913, 3910, 3789, 3896, 3747, 3582, 3898, 3624,
 /*   720 */  3900, 3897, 3891, 3742, 3882, 3876, 3878, 3865, 3852, 3839,
 /*   730 */  3468, 3771, 3694, 3835, 3833, 3817, 3828, 3829, 3715, 3812,
 /*   740 */  3635, 3795, 3800, 3620, 3774, 3615, 3775, 3778, 3710, 3702,
 /*   750 */  3766, 3769, 3772, 3759, 3757, 3750, 3756, 3723, 3744, 3719,
 /*   760 */  3737, 3649, 3708, 3618, 3776, 3730, 3729, 3726, 3731, 3571,
 /*   770 */  3717, 3718, 3716, 3713, 3588, 3700, 3679, 3678, 3724, 3667,
 /*   780 */  3652, 3641, 3693, 3644, 3639, 3637, 3631, 3636, 3640, 3626,
 /*   790 */  3632, 3623, 3625, 3617, 3616, 3512, 3510, 3621, 3660, 3551,
 /*   800 */  3638, 3611, 3434, 3600, 3650, 3624, 3594, 3593, 3509, 3591,
 /*   810 */  3589, 3578, 3573, 3633, 3569, 3557, 3567, 3561, 3613, 3582,
 /*   820 */  3549, 3607, 3544, 3612, 3550, 3429, 3579, 3430, 3332, 3549,
 /*   830 */  3393, 3459, 3508, 3493, 3355, 3483, 3480, 3535, 3470, 3469,
 /*   840 */  3341, 3467, 3515, 3285, 3455, 3497, 3456, 3437, 3502, 3427,
 /*   850 */  3417, 3416, 3439, 3413, 3424, 3410, 3449, 3468, 3390, 3451,
 /*   860 */  3405, 3464, 3400, 3399, 3451, 3450, 3401, 3389, 3412, 3388,
 /*   870 */  3353, 3351, 3349, 3370, 3331, 3339, 3329, 3324, 3313, 3312,
 /*   880 */  3310, 3308, 3944,
};
#define YY_REDUCE_USE_DFLT (-544)
#define YY_REDUCE_MAX 511
static const short yy_reduce_ofst[] = {
 /*     0 */  8169, -268,  -60,  149,  357, 1608,  983,  566, 1400, 1191,
 /*    10 */   774, 2053, 1934, 1727, 2260, 2470, 2582, 3435, 2901, 3547,
 /*    20 */  2789, 3228, 3109, 3867, 4074, 4193, 3755, 4400, 4512, 7383,
 /*    30 */  8537, 7702, 7064, 6745, 6426, 6107, 8218, 7909, 7590, 7271,
 /*    40 */  6952, 6633, 6314, 5995, 5676, 5357, 5038, 4719, 8425, 5150,
 /*    50 */  4831, 5469, 5788, 8856, 8744, 9139, 9237, 9529, 9339, 9849,
 /*    60 */  9734, 2376, 9960, 10244, 10584, 10846, 10523, 10323, 10775, -309,
 /*    70 */  11095, 11166, 12795, 13080, 13317, 13521, 13713, 13896, 13615, 13411,
 /*    80 */  13125, 12998, 12699, 12564, 12358, 12223, 12017, 11882, 11674, 11462,
 /*    90 */  11349, 8474, 12603, 8793, 11395, 11578, 11786, 11921, 12262, 12468,
 /*   100 */  12127, 14227, 13957, 14166, 14763, 14488, 14427, 14692, 14953, 15228,
 /*   110 */  15829, 16648, 17439, 16349, 15289, 17188, 15014, 16577, 15758, 16907,
 /*   120 */  17378, 16080, 16846, 17117, 16151, 15548, 15487, 16019, 16377,  261,
 /*   130 */  3016,   53, 2696, 3338, 1937, 3758, -281,   19, -143, -265,
 /*   140 */   472,  472,  472,  484,  630, 1241, 2109, 1609,  791,  -29,
 /*   150 */  1216,  227, 1427,  -12, -543, -255,  179,   56, -250,  185,
 /*   160 */   393,  777, -245,   77,   74, 1643, 1647, 1831, 1094,  641,
 /*   170 */   496,  674,  796,  525,  525,  941, 2194, 1477, 2146, 2324,
 /*   180 */  1038,  589,  330,  199,  281,  438,  701,  466,  743,  840,
 /*   190 */   251,  -54, 1590,  849, 1764, 1129, 1369, 1971, 2158, 2294,
 /*   200 */   750,  153, -247, 1238, 1889, -211, 1229,   70, 1765, 1693,
 /*   210 */  -326,  -79, 2103, 1181,  833,  808,  210, -308,  798,  652,
 /*   220 */  2100, 2104, 2112, 2122, 2019,  279, 2056, -195,  129,  171,
 /*   230 */  1091, 1228,  894, 1417, 1378, -183, 1555, 1545,  897, 1587,
 /*   240 */   956, 1266, 1604, 1734, 1976, 1629,  896, 2129, 2161, 2277,
 /*   250 */  2281, 1753, 1302, 1707, 1088, 2284, -285, 2748, 2554, 2498,
 /*   260 */  2792, 2790, 2765, 2731, 2672, 2707, 2763, 2626, 2623, 2732,
 /*   270 */  2722, 2711, 1879, 2537, 2276, 2693,  921, -165,   25,   89,
 /*   280 */   377,  -81,  320,   43,  397,  587,  136, -242,  617,  409,
 /*   290 */   970,  927, 1043,  435, 1053, 1471,  403, 1583, 1901,  837,
 /*   300 */  1979, -200, 2035, 1268, 2055, 1696, 1001, 1554, -248, -160,
 /*   310 */  1480,  744, 1215, 1839, 1387, 1684, 2197,  128, 1333, 1914,
 /*   320 */  1542, 1565, 1903, 1068,  517, 2086, 1966, 1306, 1063, 1977,
 /*   330 */  2234, 1995, 2879, 2016, 1451, 1930, 2000, 2127, 1936, 2048,
 /*   340 */  2305, 1963, 2168, 1240, 2245, 2328, 2344, 2233,  197, 2374,
 /*   350 */  1189, 2408, 1676, 2417, 2425, 2254, 1960, 2451, 2394, 2379,
 /*   360 */  2073, 2418, 2459, 2428, 2460, 2405, 1561, 2438, 2566, 2581,
 /*   370 */  2482, 2545, 2499, 2548, 2592, 2492, 2539, 2546, 2652, 2575,
 /*   380 */  2555, 2506, 2565, 3185, 3185, 3008, 3185, 2994, 2993, 2934,
 /*   390 */  3121, 3118, 3145, 2979, 2902, 2999, 2900, 3172, 3082, 3166,
 /*   400 */  3197, 3202, 3159, 3087, 3190, 3157, 3067, 2893, 3180, 3149,
 /*   410 */  3142, 3131, 3056, 3153, 3147, 3043, 3144, 3143, 2883, 3141,
 /*   420 */  3105, 3133, 3031, 3098, 3025, 3129, 3127, 3030, 3111, 3110,
 /*   430 */  3000, 3082, 3060, 3077, 3062, 2823, 3017, 2828, 3422, -331,
 /*   440 */  -471,   50,  633,  732,  527,  816,  784, 1398, 1465, 1843,
 /*   450 */  2206, 2270, 2170, 2364, 2437, 2504, 2502, 2827, 2615, 2872,
 /*   460 */  2858, 2819, 2781, 2774, 2579, 2783, 2677, 2771, 2670, 2820,
 /*   470 */  2775, 2787, 2793, 2708, 2678, 2802, 2826, 2957, 2955, 2805,
 /*   480 */  2972, 2743, 2689, 2745, 2697, 2978, 2700, 2861, 2713, 2780,
 /*   490 */  2971, 2893, 2710, 2712, 2954, 2899, 2778, 2986, 2881, 2991,
 /*   500 */  2727, 2768, 2729, 2725, 3002, 2785, 2766, 2990, 3040, 3041,
 /*   510 */  2821, 2937,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578,
 /*    10 */  2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578,
 /*    20 */  2578, 2578, 1781, 2578, 2578, 2578, 2578, 2578, 2578, 2578,
 /*    30 */  2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578,
 /*    40 */  2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578,
 /*    50 */  2578, 2578, 2578, 2578, 2187, 2578, 2578, 2578, 2578, 2578,
 /*    60 */  2578, 2578, 2578, 2578, 2013, 2578, 2578, 2578, 2578, 2578,
 /*    70 */  2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578,
 /*    80 */  2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578,
 /*    90 */  2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578,
 /*   100 */  2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578,
 /*   110 */  2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578,
 /*   120 */  2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578,
 /*   130 */  2578, 2578, 2578, 2578, 2578, 2578, 2578, 2399, 2578, 2578,
 /*   140 */  2397, 2398, 2382, 2578, 2578, 1803, 2578, 2578, 1916, 2578,
 /*   150 */  2578, 2578, 2578, 2578, 2253, 2578, 2578, 2578, 2578, 2578,
 /*   160 */  2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578,
 /*   170 */  2578, 2578, 2578, 2252, 2500, 2285, 2578, 2578, 2578, 2578,
 /*   180 */  2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2237, 2578,
 /*   190 */  2578, 1983, 2578, 2207, 2578, 2578, 2578, 2578, 2578, 2578,
 /*   200 */  2578, 2349, 2303, 1842, 2578, 1983, 2418, 2578, 2383, 2383,
 /*   210 */  1911, 2418, 1983, 2578, 2578, 2503, 2578, 2578, 2560, 2261,
 /*   220 */  2578, 2342, 2342, 2342, 2578, 1984, 2578, 1807, 2578, 2578,
 /*   230 */  2578, 2578, 2578, 2578, 2578, 1983, 1983, 2578, 1911, 1911,
 /*   240 */  1983, 2578, 1983, 1911, 2578, 2578, 2578, 2578, 2578, 2578,
 /*   250 */  2578, 1911, 2578, 2578, 2578, 2578, 2578, 1828, 2578, 2517,
 /*   260 */  1861, 2578, 2578, 2578, 2383, 2578, 1786, 2578, 2578, 2578,
 /*   270 */  2578, 2578, 2501, 2578, 2429, 2578, 2578, 2426, 2578, 2578,
 /*   280 */  2578, 2423, 2578, 2420, 2578, 2578, 2578, 2578, 2578, 2578,
 /*   290 */  2578, 2578, 2578, 2578, 1912, 2578, 1984, 2578, 2578, 2578,
 /*   300 */  2578, 1956, 1764, 2552, 2578, 2130, 2437, 1984, 2578, 2482,
 /*   310 */  2578, 1842, 2578, 2130, 2578, 2578, 2578, 2578, 2578, 2578,
 /*   320 */  2578, 2578, 2578, 2578, 2578, 2578, 2578, 2552, 1842, 2578,
 /*   330 */  2578, 2578, 2578, 2578, 2578, 1911, 2578, 1911, 1796, 2457,
 /*   340 */  2578, 2578, 2578, 2401, 2578, 2578, 2578, 2578, 2013, 2578,
 /*   350 */  2013, 2578, 1871, 1871, 2578, 1983, 2019, 2578, 1911, 1983,
 /*   360 */  2019, 1911, 2578, 1911, 1858, 1986, 1842, 1986, 1846, 1842,
 /*   370 */  2578, 1756, 1911, 2578, 1756, 1983, 2019, 1983, 1756, 1911,
 /*   380 */  1986, 2578, 1983, 1802, 1801, 2451, 1828, 2451, 2578, 2518,
 /*   390 */  2578, 2578, 1828, 2343, 2578, 2578, 2512, 1774, 2578, 1774,
 /*   400 */  2578, 2578, 1789, 2578, 2578, 1753, 2578, 2010, 2578, 1753,
 /*   410 */  1753, 1774, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578,
 /*   420 */  1774, 2578, 2578, 1774, 2578, 2578, 2578, 1869, 2578, 2578,
 /*   430 */  1868, 2578, 2383, 2578, 2578, 2300, 1774, 2578, 2529, 1984,
 /*   440 */  2380, 2578, 2383, 1984, 2578, 2056, 2578, 2054, 2430, 2578,
 /*   450 */  1912, 1912, 2383, 2383, 2383, 2354, 2383, 2383, 2403, 2534,
 /*   460 */  1861, 1815, 1912, 1987, 2514, 1987, 2403, 2578, 2337, 1912,
 /*   470 */  2058, 2052, 2578, 2403, 2363, 2578, 1984, 2578, 2578, 2578,
 /*   480 */  2578, 2403, 2430, 2403, 2427, 2578, 2424, 1984, 2421, 2242,
 /*   490 */  1759, 2010, 2578, 2578, 2578, 1984, 2403, 2383, 1984, 2383,
 /*   500 */  2453, 2310, 2455, 2469, 2383, 2314, 2578, 1793, 2578, 2578,
 /*   510 */  2403, 1917, 2183, 2578, 2165, 2165, 2578, 2578, 1821, 2165,
 /*   520 */  2578, 2578, 2578, 2168, 2578, 2578, 2578, 2578, 2578, 2174,
 /*   530 */  2578, 2578, 1874, 2096, 2168, 1914, 1873, 2174, 2578, 2578,
 /*   540 */  2175, 2015, 2012, 2169, 2021, 1988, 2026, 1915, 2171, 2067,
 /*   550 */  2498, 2578, 2175, 2578, 2578, 1929, 2169, 2578, 2177, 2578,
 /*   560 */  2578, 2578, 2578, 2169, 2578, 2175, 2067, 2578, 2578, 2578,
 /*   570 */  2578, 2171, 2578, 2177, 2578, 2578, 2578, 2578, 2578, 2578,
 /*   580 */  2578, 2578, 2578, 2578, 2578, 1948, 2578, 2578, 2578, 2578,
 /*   590 */  2578, 2578, 2578, 2578, 2578, 2578, 2578, 2089, 2088, 2096,
 /*   600 */  2578, 2578, 2578, 2072, 2071, 2578, 2070, 2578, 2578, 1742,
 /*   610 */  2578, 2578, 2578, 2578, 2578, 1875, 2066, 2065, 2226, 2227,
 /*   620 */  2072, 2578, 2229, 2578, 2578, 2578, 2578, 2578, 2578, 2161,
 /*   630 */  2578, 2578, 2071, 2070, 2160, 2578, 2578, 2578, 2578, 2578,
 /*   640 */  2578, 2578, 2578, 2231, 2578, 2578, 2095, 2212, 2578, 2578,
 /*   650 */  2578, 2578, 2578, 2578, 2578, 2094, 2578, 2232, 2578, 2578,
 /*   660 */  2578, 2578, 2578, 2578, 2578, 1742, 2578, 2578, 2578, 2578,
 /*   670 */  2578, 2578, 2578, 2578, 2578, 2536, 2578, 2069, 2138, 2068,
 /*   680 */  2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578,
 /*   690 */  2578, 2578, 2578, 2578, 2578, 2196, 2578, 2578, 2578, 2578,
 /*   700 */  2578, 2578, 2578, 1877, 2184, 2142, 2578, 2578, 2578, 2578,
 /*   710 */  2578, 2238, 2578, 2578, 2578, 2192, 2578, 2175, 2578, 2169,
 /*   720 */  2578, 2578, 2578, 2578, 2578, 2578, 2578, 2516, 2495, 2578,
 /*   730 */  1761, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578,
 /*   740 */  2578, 2578, 2578, 2578, 2243, 2578, 2578, 2578, 2578, 2578,
 /*   750 */  2578, 2115, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578,
 /*   760 */  2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2113, 2578,
 /*   770 */  2578, 2578, 2578, 2578, 2578, 2578, 2578, 2096, 2578, 2578,
 /*   780 */  2578, 2578, 1778, 2578, 2578, 2578, 2578, 2578, 2578, 2578,
 /*   790 */  2578, 2578, 2578, 2578, 2578, 2246, 2578, 2578, 2578, 2578,
 /*   800 */  2578, 2578, 2578, 2578, 2578, 2066, 2578, 2578, 2578, 2578,
 /*   810 */  2176, 2170, 2578, 2578, 2172, 2578, 2173, 2578, 2578, 2065,
 /*   820 */  1950, 2578, 2270, 2578, 2578, 2578, 1848, 2578, 2578, 1949,
 /*   830 */  2578, 2578, 2578, 2578, 2578, 1856, 2578, 2578, 2578, 2578,
 /*   840 */  2578, 2578, 2541, 2578, 2578, 1800, 2578, 2578, 2578, 2578,
 /*   850 */  1872, 1834, 2578, 1832, 2578, 1830, 2578, 1817, 2578, 2433,
 /*   860 */  2578, 2578, 2578, 2578, 2434, 2578, 2135, 2578, 2578, 2578,
 /*   870 */  1805, 2162, 2578, 2578, 2578, 2578, 2578, 2578, 2578, 2578,
 /*   880 */  2578, 1726, 2578, 1723, 1724, 1725, 1797, 1798, 1791, 1810,
 /*   890 */  1809, 2162, 1804, 1794, 1808, 1795, 2267, 1814, 1792, 1811,
 /*   900 */  1818, 1822, 1823, 1824, 1825, 1813, 1816, 1763, 1805, 1762,
 /*   910 */  1827, 1829, 1719, 1831, 1812, 1833, 1806, 1835, 1844, 1836,
 /*   920 */  1843, 1849, 1854, 1837, 1853, 1857, 1855, 1838, 1852, 1851,
 /*   930 */  1850, 1841, 1847, 1860, 2179, 2167, 1839, 2166, 2099, 2038,
 /*   940 */  2030, 2029, 1840, 1826, 1945, 1939, 1944, 1773, 1937, 1785,
 /*   950 */  1784, 1933, 1942, 1790, 1777, 1938, 1943, 1780, 1782, 1935,
 /*   960 */  1787, 1932, 1788, 1779, 1931, 1941, 1936, 1940, 1934, 2114,
 /*   970 */  1952, 1971, 1970, 1969, 2116, 1987, 1967, 1749, 1966, 1982,
 /*   980 */  1750, 1757, 1968, 1758, 1965, 1964, 1959, 1760, 1984, 1754,
 /*   990 */  1755, 1981, 1980, 1751, 1958, 1957, 1752, 1977, 1972, 2189,
 /*  1000 */  1976, 2190, 2193, 1960, 2191, 1974, 1962, 1979, 1973, 1975,
 /*  1010 */  2197, 2200, 2020, 1963, 2202, 2194, 2198, 1985, 2199, 2201,
 /*  1020 */  1978, 2195, 1961, 1955, 1954, 1953, 2203, 1930, 2206, 2028,
 /*  1030 */  2025, 2208, 2024, 2023, 2209, 2210, 1863, 1870, 2211, 2205,
 /*  1040 */  1867, 1866, 1865, 2204, 1864, 1862, 2027, 2022, 2214, 2215,
 /*  1050 */  2216, 2217, 2018, 2218, 2219, 2017, 2016, 2220, 1928, 2221,
 /*  1060 */  2222, 1927, 2223, 2224, 1926, 2225, 2213, 1925, 1924, 2508,
 /*  1070 */  1923, 2513, 2509, 2510, 2511, 1922, 2543, 1921, 2544, 2546,
 /*  1080 */  2547, 1920, 2548, 2545, 2549, 1919, 1918, 1990, 1951, 2228,
 /*  1090 */  2001, 2230, 2014, 2000, 1999, 1993, 1992, 1998, 2233, 2234,
 /*  1100 */  1997, 2235, 1996, 2236, 2002, 2009, 2239, 2240, 2008, 2007,
 /*  1110 */  2241, 2006, 2011, 2244, 2005, 2245, 2004, 2003, 1995, 2247,
 /*  1120 */  1994, 2248, 2249, 1991, 2250, 1989, 1947, 1946, 2251, 1898,
 /*  1130 */  2255, 2256, 2257, 2258, 2259, 2260, 1897, 2036, 2263, 2264,
 /*  1140 */  2035, 2265, 2037, 2266, 2262, 1909, 2268, 2269, 2270, 2271,
 /*  1150 */  1908, 2273, 2274, 1907, 2275, 2276, 2254, 1903, 1901, 1900,
 /*  1160 */  1899, 1902, 1720, 1896, 1895, 2293, 2400, 1894, 2414, 1893,
 /*  1170 */  1892, 1891, 1890, 2415, 2047, 2428, 2475, 2046, 2425, 2049,
 /*  1180 */  2422, 2048, 2419, 2416, 2417, 2150, 2302, 2304, 2305, 2106,
 /*  1190 */  2085, 2127, 2121, 2129, 2306, 2031, 2345, 1821, 2346, 2188,
 /*  1200 */  2347, 2348, 2344, 1718, 2185, 2355, 2186, 1768, 2307, 1819,
 /*  1210 */  2033, 2308, 2350, 2032, 2351, 2353, 2034, 2352, 1910, 2356,
 /*  1220 */  2358, 2359, 1906, 2357, 1913, 1912, 1905, 1904, 2360, 1845,
 /*  1230 */  2128, 2364, 2366, 2120, 2122, 2367, 2376, 2131, 2125, 2368,
 /*  1240 */  2126, 2369, 2124, 2370, 2372, 2374, 2123, 2371, 2373, 2119,
 /*  1250 */  2375, 2365, 2361, 2090, 2362, 2309, 2161, 2311, 2160, 2312,
 /*  1260 */  2157, 2154, 2313, 2340, 2181, 2341, 2315, 2183, 2182, 2180,
 /*  1270 */  2316, 2178, 2176, 2173, 2317, 2318, 2319, 2320, 2321, 2322,
 /*  1280 */  2323, 2324, 2325, 2326, 2327, 2172, 2170, 2164, 2328, 2163,
 /*  1290 */  2159, 2158, 2329, 2156, 2155, 2153, 2330, 2331, 2332, 2152,
 /*  1300 */  2333, 2151, 2137, 2338, 2136, 2134, 2339, 2334, 2335, 2336,
 /*  1310 */  2133, 2132, 2103, 2102, 2101, 2377, 2443, 2444, 2445, 2446,
 /*  1320 */  2447, 2448, 2100, 2449, 2450, 2095, 2094, 2093, 2092, 2091,
 /*  1330 */  2087, 2378, 2086, 2118, 2117, 2112, 2111, 2110, 2109, 2108,
 /*  1340 */  2379, 2107, 2105, 2381, 2301, 2298, 2299, 2104, 2294, 2069,
 /*  1350 */  2295, 2296, 2068, 2064, 2063, 2062, 2053, 2055, 2057, 2061,
 /*  1360 */  2060, 2059, 2051, 2442, 2456, 2050, 2466, 2084, 1776, 2467,
 /*  1370 */  1775, 2146, 2468, 2147, 2145, 2454, 2140, 2139, 2452, 2143,
 /*  1380 */  2144, 2474, 2476, 2477, 2478, 2141, 2083, 2082, 2479, 2081,
 /*  1390 */  2481, 2480, 2080, 2079, 2078, 2077, 2076, 2551, 2553, 2558,
 /*  1400 */  2557, 2556, 2075, 2042, 2045, 2044, 2043, 2039, 1889, 1888,
 /*  1410 */  2559, 2566, 1887, 2561, 1886, 1885, 1884, 1883, 2564, 2575,
 /*  1420 */  2576, 1882, 2577, 1881, 2573, 2574, 1880, 1879, 2567, 1878,
 /*  1430 */  2569, 1876, 2570, 2572, 2571, 2568, 1859, 1799, 1772, 2277,
 /*  1440 */  1783, 2404, 1771, 1770, 2402, 1769, 1767, 2458, 1766, 1765,
 /*  1450 */  2483, 1748, 1820, 2555, 1745, 1746, 1744, 2563, 1743, 1741,
 /*  1460 */  2565, 1740, 1739, 1738, 1737, 1736, 1735, 2272, 1734, 2278,
 /*  1470 */  1733, 2283, 1732, 2279, 2280, 1731, 2281, 1730, 2282, 1729,
 /*  1480 */  2287, 2288, 2289, 2290, 2291, 2292, 2286, 2284, 1728, 1727,
 /*  1490 */  2405, 2406, 2407, 2408, 2409, 2410, 2411, 1722, 2412, 1721,
 /*  1500 */  2413, 2387, 2396, 2431, 2432, 2395, 2394, 2393, 2436, 2392,
 /*  1510 */  2391, 2435, 2441, 2390, 2438, 2389, 2439, 2440, 2388, 2384,
 /*  1520 */  2459, 2460, 2461, 2462, 2463, 2386, 2464, 2385, 2465, 1717,
 /*  1530 */  1716, 2470, 2471, 2472, 2473, 1715, 1714, 2484, 2485, 1713,
 /*  1540 */  2486, 2487, 2488, 2489, 2490, 2491, 1712, 1711, 1710, 2492,
 /*  1550 */  1709, 1708, 1707, 1706, 1705, 2554, 1704, 1703, 1702, 1701,
 /*  1560 */  1700, 1747, 1699, 2562, 1698, 2493, 1697, 1696, 1695, 1694,
 /*  1570 */  1693, 1692, 2502, 1691, 1690, 1689, 1688, 1687, 2494, 1686,
 /*  1580 */  1685, 2496, 2497, 1684, 1683, 1682, 1681, 2499, 1680, 1679,
 /*  1590 */  2506, 2507, 2504, 2505, 1678, 1677, 1676, 1675, 2515, 2550,
 /*  1600 */  1674, 1673, 1672, 1671, 2523, 2524, 2525, 2526, 2527, 2528,
 /*  1610 */  2522, 2519, 2520, 2521, 1670, 2530, 1669, 1668, 1667, 1666,
 /*  1620 */  1665, 2531, 1664, 2532, 1663, 1662, 2533, 1661, 2535, 1660,
 /*  1630 */  1659, 1658, 1657, 1656, 2540, 2539, 1655, 2538, 2537, 1654,
 /*  1640 */  1653, 1652, 1651, 1650, 1649, 2542, 1648,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  SQLParserEngineARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void SQLParserEngineTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMICOLON",     "UNION",         "EXCEPT",      
  "INTERSECT",     "JOIN",          "INNER",         "LEFT",        
  "RIGHT",         "FULL",          "NATURAL",       "CROSS",       
  "ON",            "COMMA",         "OR",            "AND",         
  "NOT",           "BETWEEN",       "IN",            "EQUALS",      
  "NOT_EQUALS",    "LESS_THAN",     "GREATER_THAN",  "LESS_THAN_OR_EQUALS",
  "GREATER_THAN_OR_EQUALS",  "IS",            "LIKE",          "CONTAINS",    
  "ESCAPE",        "LANGUAGE",      "CALCULATOR",    "SIMILAR",     
  "COMBINER",      "USING",         "VERTICALLINE",  "CONTAINS_MINUS",
  "AMPERSAND",     "PLUS",          "MINUS",         "STRING_CONCAT",
  "ASTERISK",      "SOLIDUS",       "UNARY_MINUS",   "STRING",      
  "STRING_WITH_QUOTE",  "BINARY_STRING",  "INTEGER_LITERAL",  "FLOAT_LITERAL",
  "DATE",          "TIMESTAMP",     "IDENTIFIER",    "IDENTIFIER_WITH_QUOTE",
  "NULL",          "DEFAULT",       "QUESTION_MARK",  "USER",        
  "CURRENT_USER",  "SESSION_USER",  "CURRENT_PATH",  "PERIOD",      
  "LEFT_BRACKET",  "RIGHT_BRACKET",  "ALL",           "DISTINCT",    
  "CORRESPONDING",  "BY",            "LEFT_PARENTHESIS",  "RIGHT_PARENTHESIS",
  "SELECT",        "INTO",          "AS",            "OUTPUT",      
  "TO",            "PATH",          "WITH",          "HINT",        
  "FROM",          "INPUT",         "FOR",           "OUTER",       
  "EXISTS",        "UNNEST",        "WHERE",         "GROUP",       
  "HAVING",        "ORDER",         "ASC",           "DESC",        
  "PARTITION",     "OFFSET",        "LIMIT",         "SCALE",       
  "PARAMETER",     "WORD",          "WORDLIST",      "FREETEXT",    
  "CATEGORY",      "WEIGHT",        "SYNONYM",       "EXPAND_SYNONYM",
  "HEAD",          "TAIL",          "WITHIN",        "SYMMETRIC",   
  "ASYMMETRIC",    "EXACTWORD",     "SIMPLEWORD",    "CONTAINS_STRING",
  "WORDHEAD",      "WORDTAIL",      "UPPER",         "LOWER",       
  "AVERAGE",       "LENGTH",        "FULLTEXT",      "DF",          
  "SCORE",         "FUNCTION",      "EXPAND",        "RANK",        
  "EXTRACTOR",     "CLUSTERED",     "SUBSTRING",     "OF",          
  "OVERLAY",       "PLACING",       "NORMALIZE",     "KWIC",        
  "ENCLOSE",       "ELLIPSIS",      "ABS",           "MOD",         
  "GET",           "MAX",           "COUNT",         "AVG",         
  "SUM",           "CURRENT_DATE",  "CURRENT_TIMESTAMP",  "CASE",        
  "END",           "WHEN",          "THEN",          "ELSE",        
  "MIN",           "SECTIONIZED",   "ARRAY",         "ROW",         
  "VALUES",        "TABLE",         "DELETE",        "INSERT",      
  "UPDATE",        "SET",           "START",         "TRANSACTION", 
  "READ",          "ONLY",          "WRITE",         "ISOLATION",   
  "LEVEL",         "UNCOMMITTED",   "COMMITTED",     "REPEATABLE",  
  "SERIALIZABLE",  "SNAPSHOT",      "COMMIT",        "WORK",        
  "ROLLBACK",      "XA",            "RESUME",        "SUSPEND",     
  "MIGRATE",       "PREPARE",       "ONE",           "PHASE",       
  "RECOVER",       "FORGET",        "CREATE",        "DATABASE",    
  "LOGICALLOG",    "SYSTEM",        "ONLINE",        "OFFLINE",     
  "DISCARD",       "RECOVERY",      "CHECKPOINT",    "DROP",        
  "ALTER",         "SLAVE",         "STOP",          "MASTER",      
  "GLOBAL",        "TEMPORARY",     "LOCAL",         "CONSTANT",    
  "UPDATABLE",     "NVARCHAR",      "VARCHAR",       "NTEXT",       
  "INT",           "BIGINT",        "FLOAT",         "DATETIME",    
  "UNIQUEIDENTIFIER",  "IMAGE",         "NCHAR",         "CHAR",        
  "BINARY",        "BLOB",          "NCLOB",         "DEC",         
  "DECIMAL",       "NUMERIC",       "NO",            "PRIMARY",     
  "KEY",           "UNIQUE",        "CONST",         "GENERATED",   
  "IDENTITY",      "ALWAYS",        "INCREMENT",     "MAXVALUE",    
  "MINVALUE",      "CYCLE",         "FOREIGN",       "REFERENCES",  
  "COLUMN",        "FILE",          "INDEX",         "TRIGGER",     
  "HEAP",          "NONTRUNCATE",   "IF",            "AREA",        
  "PHYSICALLOG",   "RENAME",        "ADD",           "NONCLUSTERED",
  "BITMAP",        "ROWS",          "KDTREE",        "MODIFY",      
  "UNMOUNT",       "MOUNT",         "BACKUP",        "VERIFY",      
  "CORRECT",       "CONTINUE",      "CASCADE",       "VERBOSE",     
  "VALUE",         "SYNC",          "DISCONNECT",    "SESSION",     
  "CONNECTION",    "DECLARE",       "GRANT",         "REVOKE",      
  "EXPLAIN",       "EXECUTE",       "RETURNS",       "RETURN",      
  "error",         "start",         "sqlStatementList",  "sqlStatement",
  "queryExpression",  "deleteStatement",  "insertStatement",  "updateStatement",
  "tableDefinition",  "indexDefinition",  "dropIndexStatement",  "dropTableStatement",
  "areaDefinition",  "dropAreaStatement",  "databaseDefinition",  "dropDatabaseStatement",
  "alterTableStatement",  "alterIndexStatement",  "alterDatabaseStatement",  "alterAreaStatement",
  "cascadeDefinition",  "partitionDefinition",  "functionDefinition",  "alterCascadeStatement",
  "alterPartitionStatement",  "dropCascadeStatement",  "dropPartitionStatement",  "dropFunctionStatement",
  "startTransactionStatement",  "setTransactionStatement",  "commitStatement",  "rollbackStatement",
  "unmountDatabaseStatement",  "mountDatabaseStatement",  "startBackupStatement",  "endBackupStatement",
  "verifyStatement",  "syncStatement",  "checkpointStatement",  "disconnectStatement",
  "declareStatement",  "xa_StartStatement",  "xa_EndStatement",  "xa_PrepareStatement",
  "xa_CommitStatement",  "xa_RollbackStatement",  "xa_RecoverStatement",  "xa_ForgetStatement",
  "grantStatement",  "revokeStatement",  "explainStatement",  "startExplainStatement",
  "endExplainStatement",  "literal",       "numericLiteral",  "stringLiteral",
  "datetimeLiteral",  "characterStringLiteral",  "binaryStringLiteral",  "exactNumericLiteral",
  "approximateNumericLiteral",  "unsignedIntegerLiteral",  "floatLiteral",  "dateLiteral", 
  "timestampLiteral",  "tableName",     "identifier",    "columnName",  
  "variableName",  "valueSpecification",  "numericValueSpecification",  "stringValueSpecification",
  "datetimeValueSpecification",  "noTypeValueSpecification",  "placeHolder",   "generalValueSpecification",
  "elementReference",  "itemReference",  "itemQualifier",  "arrayValueOperand",
  "anyElementReference",  "queryExpressionBody",  "optionalSortSpecificationList",  "optionalLimitSpecification",
  "hint",          "queryTerm",     "queryOperator",  "optionalAll", 
  "optionalCorrespondingSpec",  "correspondingSpec",  "optionalByCorrespondingColumnList",  "correspondingColumnList",
  "columnNameList",  "queryPrimary",  "nonJoinQueryPrimary",  "simpleTable", 
  "querySpecification",  "tableValueConstructor",  "explicitTable",  "optionalSetQuantifier",
  "selectList",    "optionalBulkOutput",  "tableExpression",  "selectTargetList",
  "selectSubListList",  "selectSubList",  "derivedColumn",  "nonPredicateValueExpression",
  "bulkSpecification",  "inputData",     "optionalWithClause",  "optionalBulkHint",
  "pathName",      "withClause",    "bulkHint",      "fromClause",  
  "optionalWhereClause",  "optionalGroupByClause",  "optionalHavingClause",  "tableReferenceList",
  "tableReference",  "tablePrimary",  "joinedTable",   "tableCorrelationSpec",
  "derivedTable",  "collectionDerivedTable",  "asCorrelationName",  "optionalDerivedColumnList",
  "derivedColumnList",  "tableSubquery",  "subquery",      "rowSubquery", 
  "crossJoin",     "qualifiedJoin",  "naturalJoin",   "existsJoin",  
  "optionalJoinType",  "joinSpecification",  "searchCondition",  "whereClause", 
  "booleanValueExpression",  "groupByClause",  "groupingElementList",  "groupingElement",
  "groupingColumnReference",  "groupingColumnReferenceList",  "havingClause",  "sortSpecificationList",
  "optionalPartitionBy",  "sortSpecification",  "orderingSpecification",  "limitSpecification",
  "numericValueOperand",  "predicateValueExpression",  "comparisonPredicate",  "betweenPredicate",
  "inPredicate",   "likePredicate",  "containsPredicate",  "isNullPredicate",
  "existsPredicate",  "similarPredicate",  "isSubstringOfPredicate",  "inPredicateSubquery",
  "inPredicateValue",  "tableValueConstructorList",  "stringValueOperand",  "optionalLanguage",
  "escape",        "language",      "scaleParameter",  "wordLimit",   
  "containsOperand",  "containsOption",  "calculator",    "combiner",    
  "averageLength",  "df",            "scoreFunction",  "expand",      
  "extractor",     "clusteredLimit",  "scoreCombiner",  "clusteredCombiner",
  "rankFrom",      "containsOperandList",  "wordList",      "containsOperandPrimary",
  "word",          "containsOperandWord",  "optionalCategory",  "scale",       
  "category",      "optionalDf",    "optionalScale",  "containsOperandParticle",
  "containsOperandParticleList",  "containsOperandWordList",  "optionalLowerDist",  "upperDist",   
  "containsOperandPattern",  "lowerDist",     "rowValueExpression",  "stringValueExpression",
  "stringRowValueExpression",  "stringValueExpressionPrimary",  "stringValueFunction",  "stringConcatenation",
  "stringOrArrayValueOperand",  "singleElementFulltextOperand",  "kwicNumericOption",  "optionalKwicStartTag",
  "optionalKwicEndTag",  "optionalKwicEscape",  "optionalKwicEllipsis",  "kwicStringOption",
  "generalValueExpression",  "arrayRowValueExpression",  "arrayValueExpressionPrimary",  "numericValueExpression",
  "numericRowValueExpression",  "numericValueExpressionPrimary",  "numericValueFunction",  "arithmeticOperation",
  "numericValueSetFunction",  "score",         "scoreList",     "datetimeValueExpression",
  "datetimeRowValueExpression",  "datetimeValueExpressionPrimary",  "datetimeValueFunction",  "generalRowValueExpression",
  "generalValueExpressionPrimary",  "generalFunction0Arg",  "generalFunctionNArgs",  "caseExpression",
  "generalSetFunction",  "rowValueConstructorList",  "caseSimpleCase",  "caseSearchedCase",
  "caseOperand",   "simpleWhenClauseList",  "optionalElseClause",  "searchedWhenClauseList",
  "simpleWhenClause",  "simpleWhenOperandList",  "searchedWhenClause",  "fulltextOperand",
  "multiElementFulltextOperand",  "fulltextOperandList",  "arrayValueExpression",  "arrayValueConstructor",
  "arrayStringFunction",  "arrayElementList",  "expandStringFunction",  "arrayElement",
  "nonPredicateValueExpressionPrimary",  "rowValueConstructor",  "rowRowValueExpression",  "rowValueExpressionPrimary",
  "multiElementRowValueConstructor",  "rowValueConstructorElement",  "delete",        "targetTable", 
  "insert",        "insertColumnsAndSource",  "bulkInput",     "setClauseList",
  "setClause",     "updateTarget",  "updateTargetList",  "transactModeList",
  "transactMode",  "transactAccMode",  "isolationLevel",  "usingSnapshotMode",
  "levelOfIsolation",  "xa_Identifier",  "signedIntegerLiteral",  "xa_EndStatement_SuspensionMode",
  "optionalDatabaseCreateOption",  "databaseCreateOptionList",  "databaseCreateOption",  "dbPathClause",
  "readwriteAttribute",  "onlineAttribute",  "recoveryAttribute",  "userModeAttribute",
  "dbPathElementList",  "dbPathElement",  "onlineAttributeForAlter",  "optionalIfExists",
  "dbName",        "alterDatabaseOption",  "alterDatabaseAttributeList",  "alterDatabaseAttribute",
  "tableScopeClause",  "tableConstantClause",  "tableElementList",  "tableAreaOption",
  "tableElement",  "columnDefinition",  "tableConstraintDefinition",  "dataType",    
  "optionalDefaultClause",  "optionalUsingOnUpdate",  "optionalColumnConstraintList",  "constClause", 
  "generatorClause",  "collectionType",  "nonCollectionDataType",  "arraySpecification",
  "optionalArrayCardinality",  "length",        "preDefinedType",  "decimalTypeName",
  "optionalDecimalLength",  "columnConstraintList",  "columnConstraint",  "defaultClause",
  "defaultOption",  "constClacuse",  "constOption",   "generateAlways",
  "optionalGeneratorOptions",  "generatorOptions",  "generatorOption",  "generatorOptionValue",
  "indexType",     "referencedColumnName",  "hintElement",   "hintPrimary", 
  "hintElementList",  "tableAreaClause",  "alterTableAction",  "setTableAreaClause",
  "dropTableAreaClause",  "renameTableClause",  "addColumnDefinition",  "alterColumnDefinition",
  "addTableConstraintDefinition",  "tblAreaOption",  "defArea",       "heapArea",    
  "indexArea",     "ftsArea",       "pycllogArea",   "areaName",    
  "addColumnDefinitionBody",  "alterColumnAction",  "languageColumnOption",  "scoreColumnOption",
  "indexAreaOption",  "indexAreaClause",  "alterIndexAction",  "setIndexAreaClause",
  "dropIndexAreaClause",  "renameIndexClause",  "offlineIndexClause",  "idxAreaOption",
  "hintArea",      "areaPath",      "areaPathElement",  "areaPathArray",
  "areaArrayElement",  "alterAreaAction",  "modifyAreaDefinition",  "singleModifyAreaClause",
  "arrayFullModifyAreaClause",  "arrayElementModifyAreaClause",  "newAreaSpecifiedPathElement",  "databaseMountOptionList",
  "optionalAreaParameter",  "optionalAreaParameterList",  "backupType",    "versionType", 
  "verifySchemaType",  "optionList",    "verifyOption",  "roles",       
  "granteeList",   "explainOption",  "explainOptionValueList",  "explainOptionValue",
  "cascadeName",   "hostName",      "portNumber",    "optionalIdentifier",
  "optionalPartitionCategory",  "functionName",  "parameterSpecification",  "returnsClause",
  "routineBody",   "parameterDeclarationList",  "parameterDeclaration",  "parameterName",
  "parameterType",  "returnsDataType",  "routineStatement",  "returnStatement",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "start ::= sqlStatementList",
 /*   1 */ "sqlStatementList ::= sqlStatement",
 /*   2 */ "sqlStatementList ::= sqlStatementList sqlStatement",
 /*   3 */ "sqlStatement ::= SEMICOLON",
 /*   4 */ "sqlStatement ::= queryExpression",
 /*   5 */ "sqlStatement ::= deleteStatement",
 /*   6 */ "sqlStatement ::= insertStatement",
 /*   7 */ "sqlStatement ::= updateStatement",
 /*   8 */ "sqlStatement ::= tableDefinition",
 /*   9 */ "sqlStatement ::= indexDefinition",
 /*  10 */ "sqlStatement ::= dropIndexStatement",
 /*  11 */ "sqlStatement ::= dropTableStatement",
 /*  12 */ "sqlStatement ::= areaDefinition",
 /*  13 */ "sqlStatement ::= dropAreaStatement",
 /*  14 */ "sqlStatement ::= databaseDefinition",
 /*  15 */ "sqlStatement ::= dropDatabaseStatement",
 /*  16 */ "sqlStatement ::= alterTableStatement",
 /*  17 */ "sqlStatement ::= alterIndexStatement",
 /*  18 */ "sqlStatement ::= alterDatabaseStatement",
 /*  19 */ "sqlStatement ::= alterAreaStatement",
 /*  20 */ "sqlStatement ::= cascadeDefinition",
 /*  21 */ "sqlStatement ::= partitionDefinition",
 /*  22 */ "sqlStatement ::= functionDefinition",
 /*  23 */ "sqlStatement ::= alterCascadeStatement",
 /*  24 */ "sqlStatement ::= alterPartitionStatement",
 /*  25 */ "sqlStatement ::= dropCascadeStatement",
 /*  26 */ "sqlStatement ::= dropPartitionStatement",
 /*  27 */ "sqlStatement ::= dropFunctionStatement",
 /*  28 */ "sqlStatement ::= startTransactionStatement",
 /*  29 */ "sqlStatement ::= setTransactionStatement",
 /*  30 */ "sqlStatement ::= commitStatement",
 /*  31 */ "sqlStatement ::= rollbackStatement",
 /*  32 */ "sqlStatement ::= unmountDatabaseStatement",
 /*  33 */ "sqlStatement ::= mountDatabaseStatement",
 /*  34 */ "sqlStatement ::= startBackupStatement",
 /*  35 */ "sqlStatement ::= endBackupStatement",
 /*  36 */ "sqlStatement ::= verifyStatement",
 /*  37 */ "sqlStatement ::= syncStatement",
 /*  38 */ "sqlStatement ::= checkpointStatement",
 /*  39 */ "sqlStatement ::= disconnectStatement",
 /*  40 */ "sqlStatement ::= declareStatement",
 /*  41 */ "sqlStatement ::= xa_StartStatement",
 /*  42 */ "sqlStatement ::= xa_EndStatement",
 /*  43 */ "sqlStatement ::= xa_PrepareStatement",
 /*  44 */ "sqlStatement ::= xa_CommitStatement",
 /*  45 */ "sqlStatement ::= xa_RollbackStatement",
 /*  46 */ "sqlStatement ::= xa_RecoverStatement",
 /*  47 */ "sqlStatement ::= xa_ForgetStatement",
 /*  48 */ "sqlStatement ::= grantStatement",
 /*  49 */ "sqlStatement ::= revokeStatement",
 /*  50 */ "sqlStatement ::= explainStatement",
 /*  51 */ "sqlStatement ::= startExplainStatement",
 /*  52 */ "sqlStatement ::= endExplainStatement",
 /*  53 */ "literal ::= numericLiteral",
 /*  54 */ "literal ::= stringLiteral",
 /*  55 */ "literal ::= datetimeLiteral",
 /*  56 */ "stringLiteral ::= characterStringLiteral",
 /*  57 */ "stringLiteral ::= binaryStringLiteral",
 /*  58 */ "characterStringLiteral ::= STRING",
 /*  59 */ "characterStringLiteral ::= STRING_WITH_QUOTE",
 /*  60 */ "binaryStringLiteral ::= BINARY_STRING",
 /*  61 */ "numericLiteral ::= exactNumericLiteral",
 /*  62 */ "numericLiteral ::= approximateNumericLiteral",
 /*  63 */ "exactNumericLiteral ::= unsignedIntegerLiteral",
 /*  64 */ "unsignedIntegerLiteral ::= INTEGER_LITERAL",
 /*  65 */ "approximateNumericLiteral ::= floatLiteral",
 /*  66 */ "floatLiteral ::= FLOAT_LITERAL",
 /*  67 */ "datetimeLiteral ::= dateLiteral",
 /*  68 */ "datetimeLiteral ::= timestampLiteral",
 /*  69 */ "dateLiteral ::= DATE STRING",
 /*  70 */ "timestampLiteral ::= TIMESTAMP STRING",
 /*  71 */ "tableName ::= identifier",
 /*  72 */ "columnName ::= identifier",
 /*  73 */ "variableName ::= identifier",
 /*  74 */ "identifier ::= IDENTIFIER",
 /*  75 */ "identifier ::= IDENTIFIER_WITH_QUOTE",
 /*  76 */ "valueSpecification ::= numericValueSpecification",
 /*  77 */ "valueSpecification ::= stringValueSpecification",
 /*  78 */ "valueSpecification ::= datetimeValueSpecification",
 /*  79 */ "valueSpecification ::= noTypeValueSpecification",
 /*  80 */ "numericValueSpecification ::= numericLiteral",
 /*  81 */ "stringValueSpecification ::= stringLiteral",
 /*  82 */ "datetimeValueSpecification ::= datetimeLiteral",
 /*  83 */ "noTypeValueSpecification ::= placeHolder",
 /*  84 */ "noTypeValueSpecification ::= NULL",
 /*  85 */ "noTypeValueSpecification ::= DEFAULT",
 /*  86 */ "noTypeValueSpecification ::= generalValueSpecification",
 /*  87 */ "noTypeValueSpecification ::= elementReference",
 /*  88 */ "placeHolder ::= QUESTION_MARK",
 /*  89 */ "generalValueSpecification ::= itemReference",
 /*  90 */ "generalValueSpecification ::= USER",
 /*  91 */ "generalValueSpecification ::= CURRENT_USER",
 /*  92 */ "generalValueSpecification ::= SESSION_USER",
 /*  93 */ "generalValueSpecification ::= CURRENT_PATH",
 /*  94 */ "itemReference ::= itemQualifier PERIOD identifier",
 /*  95 */ "itemReference ::= identifier",
 /*  96 */ "itemQualifier ::= tableName",
 /*  97 */ "elementReference ::= arrayValueOperand LEFT_BRACKET exactNumericLiteral RIGHT_BRACKET",
 /*  98 */ "elementReference ::= anyElementReference",
 /*  99 */ "anyElementReference ::= arrayValueOperand LEFT_BRACKET RIGHT_BRACKET",
 /* 100 */ "queryExpression ::= queryExpressionBody optionalSortSpecificationList optionalLimitSpecification hint",
 /* 101 */ "queryExpressionBody ::= queryTerm",
 /* 102 */ "queryExpressionBody ::= queryExpressionBody queryOperator queryTerm",
 /* 103 */ "queryOperator ::= UNION optionalAll optionalCorrespondingSpec",
 /* 104 */ "queryOperator ::= EXCEPT optionalAll optionalCorrespondingSpec",
 /* 105 */ "queryOperator ::= INTERSECT optionalAll optionalCorrespondingSpec",
 /* 106 */ "optionalAll ::=",
 /* 107 */ "optionalAll ::= ALL",
 /* 108 */ "optionalAll ::= DISTINCT",
 /* 109 */ "optionalCorrespondingSpec ::=",
 /* 110 */ "optionalCorrespondingSpec ::= correspondingSpec",
 /* 111 */ "correspondingSpec ::= CORRESPONDING optionalByCorrespondingColumnList",
 /* 112 */ "optionalByCorrespondingColumnList ::=",
 /* 113 */ "optionalByCorrespondingColumnList ::= BY LEFT_PARENTHESIS correspondingColumnList RIGHT_PARENTHESIS",
 /* 114 */ "correspondingColumnList ::= columnNameList",
 /* 115 */ "columnNameList ::= columnName",
 /* 116 */ "columnNameList ::= columnNameList COMMA columnName",
 /* 117 */ "columnNameList ::= columnNameList COMMA",
 /* 118 */ "queryTerm ::= queryPrimary",
 /* 119 */ "queryPrimary ::= nonJoinQueryPrimary",
 /* 120 */ "nonJoinQueryPrimary ::= simpleTable",
 /* 121 */ "nonJoinQueryPrimary ::= LEFT_PARENTHESIS queryExpression RIGHT_PARENTHESIS",
 /* 122 */ "simpleTable ::= querySpecification",
 /* 123 */ "simpleTable ::= tableValueConstructor",
 /* 124 */ "simpleTable ::= explicitTable",
 /* 125 */ "querySpecification ::= SELECT optionalSetQuantifier selectList optionalBulkOutput tableExpression",
 /* 126 */ "querySpecification ::= SELECT optionalSetQuantifier selectList INTO selectTargetList tableExpression",
 /* 127 */ "optionalSetQuantifier ::=",
 /* 128 */ "optionalSetQuantifier ::= ALL",
 /* 129 */ "optionalSetQuantifier ::= DISTINCT",
 /* 130 */ "selectList ::= ASTERISK",
 /* 131 */ "selectList ::= selectSubListList",
 /* 132 */ "selectSubListList ::= selectSubList",
 /* 133 */ "selectSubListList ::= selectSubListList COMMA selectSubList",
 /* 134 */ "selectSubListList ::= selectSubListList COMMA",
 /* 135 */ "selectSubList ::= derivedColumn",
 /* 136 */ "selectSubList ::= itemQualifier PERIOD ASTERISK",
 /* 137 */ "selectTargetList ::= variableName",
 /* 138 */ "selectTargetList ::= selectTargetList COMMA variableName",
 /* 139 */ "derivedColumn ::= nonPredicateValueExpression",
 /* 140 */ "derivedColumn ::= nonPredicateValueExpression columnName",
 /* 141 */ "derivedColumn ::= nonPredicateValueExpression AS columnName",
 /* 142 */ "optionalBulkOutput ::=",
 /* 143 */ "optionalBulkOutput ::= OUTPUT TO bulkSpecification",
 /* 144 */ "bulkSpecification ::= inputData optionalWithClause optionalBulkHint",
 /* 145 */ "inputData ::= PATH pathName",
 /* 146 */ "optionalWithClause ::=",
 /* 147 */ "optionalWithClause ::= WITH withClause",
 /* 148 */ "withClause ::= PATH pathName",
 /* 149 */ "optionalBulkHint ::=",
 /* 150 */ "optionalBulkHint ::= bulkHint",
 /* 151 */ "bulkHint ::= HINT valueSpecification",
 /* 152 */ "tableExpression ::= fromClause optionalWhereClause optionalGroupByClause optionalHavingClause",
 /* 153 */ "fromClause ::= FROM tableReferenceList",
 /* 154 */ "tableReferenceList ::= tableReference",
 /* 155 */ "tableReferenceList ::= tableReferenceList COMMA tableReference",
 /* 156 */ "tableReferenceList ::= tableReferenceList COMMA",
 /* 157 */ "tableReference ::= tablePrimary",
 /* 158 */ "tableReference ::= joinedTable",
 /* 159 */ "tablePrimary ::= tableName tableCorrelationSpec",
 /* 160 */ "tablePrimary ::= tableName",
 /* 161 */ "tablePrimary ::= derivedTable tableCorrelationSpec",
 /* 162 */ "tablePrimary ::= LEFT_PARENTHESIS joinedTable RIGHT_PARENTHESIS",
 /* 163 */ "tablePrimary ::= collectionDerivedTable tableCorrelationSpec",
 /* 164 */ "tablePrimary ::= INPUT FOR tableName FROM bulkSpecification",
 /* 165 */ "tableCorrelationSpec ::= asCorrelationName optionalDerivedColumnList",
 /* 166 */ "asCorrelationName ::= AS identifier",
 /* 167 */ "asCorrelationName ::= identifier",
 /* 168 */ "optionalDerivedColumnList ::=",
 /* 169 */ "optionalDerivedColumnList ::= LEFT_PARENTHESIS derivedColumnList RIGHT_PARENTHESIS",
 /* 170 */ "derivedColumnList ::= columnNameList",
 /* 171 */ "derivedTable ::= tableSubquery",
 /* 172 */ "tableSubquery ::= subquery",
 /* 173 */ "rowSubquery ::= subquery",
 /* 174 */ "subquery ::= LEFT_PARENTHESIS queryExpression RIGHT_PARENTHESIS",
 /* 175 */ "joinedTable ::= crossJoin",
 /* 176 */ "joinedTable ::= qualifiedJoin",
 /* 177 */ "joinedTable ::= naturalJoin",
 /* 178 */ "joinedTable ::= existsJoin",
 /* 179 */ "crossJoin ::= tableReference CROSS JOIN tablePrimary",
 /* 180 */ "qualifiedJoin ::= tableReference optionalJoinType JOIN tableReference joinSpecification",
 /* 181 */ "optionalJoinType ::=",
 /* 182 */ "optionalJoinType ::= INNER",
 /* 183 */ "optionalJoinType ::= LEFT",
 /* 184 */ "optionalJoinType ::= LEFT OUTER",
 /* 185 */ "optionalJoinType ::= RIGHT",
 /* 186 */ "optionalJoinType ::= RIGHT OUTER",
 /* 187 */ "optionalJoinType ::= FULL",
 /* 188 */ "optionalJoinType ::= FULL OUTER",
 /* 189 */ "joinSpecification ::= ON searchCondition",
 /* 190 */ "joinSpecification ::= USING LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS",
 /* 191 */ "naturalJoin ::= tableReference NATURAL optionalJoinType JOIN tablePrimary",
 /* 192 */ "existsJoin ::= tableReference EXISTS JOIN tablePrimary ON searchCondition",
 /* 193 */ "existsJoin ::= tableReference NOT EXISTS JOIN tablePrimary ON searchCondition",
 /* 194 */ "collectionDerivedTable ::= UNNEST LEFT_PARENTHESIS arrayValueOperand RIGHT_PARENTHESIS",
 /* 195 */ "optionalWhereClause ::=",
 /* 196 */ "optionalWhereClause ::= whereClause",
 /* 197 */ "whereClause ::= WHERE searchCondition",
 /* 198 */ "searchCondition ::= booleanValueExpression",
 /* 199 */ "optionalGroupByClause ::=",
 /* 200 */ "optionalGroupByClause ::= groupByClause",
 /* 201 */ "groupByClause ::= GROUP BY groupingElementList",
 /* 202 */ "groupingElementList ::= groupingElement",
 /* 203 */ "groupingElementList ::= groupingElementList COMMA groupingElement",
 /* 204 */ "groupingElement ::= groupingColumnReference",
 /* 205 */ "groupingElement ::= LEFT_PARENTHESIS groupingColumnReferenceList RIGHT_PARENTHESIS",
 /* 206 */ "groupingElement ::= LEFT_PARENTHESIS RIGHT_PARENTHESIS",
 /* 207 */ "groupingColumnReferenceList ::= groupingColumnReference",
 /* 208 */ "groupingColumnReferenceList ::= groupingColumnReferenceList COMMA groupingColumnReference",
 /* 209 */ "groupingColumnReference ::= itemReference",
 /* 210 */ "groupingColumnReference ::= itemReference LEFT_BRACKET RIGHT_BRACKET",
 /* 211 */ "optionalHavingClause ::=",
 /* 212 */ "optionalHavingClause ::= havingClause",
 /* 213 */ "havingClause ::= HAVING searchCondition",
 /* 214 */ "optionalSortSpecificationList ::=",
 /* 215 */ "optionalSortSpecificationList ::= ORDER BY sortSpecificationList optionalPartitionBy",
 /* 216 */ "sortSpecificationList ::= sortSpecification",
 /* 217 */ "sortSpecificationList ::= sortSpecificationList COMMA sortSpecification",
 /* 218 */ "sortSpecification ::= nonPredicateValueExpression orderingSpecification",
 /* 219 */ "orderingSpecification ::= ASC",
 /* 220 */ "orderingSpecification ::= DESC",
 /* 221 */ "orderingSpecification ::=",
 /* 222 */ "optionalPartitionBy ::=",
 /* 223 */ "optionalPartitionBy ::= PARTITION BY nonPredicateValueExpression",
 /* 224 */ "optionalLimitSpecification ::=",
 /* 225 */ "optionalLimitSpecification ::= limitSpecification",
 /* 226 */ "optionalLimitSpecification ::= limitSpecification OFFSET numericValueOperand",
 /* 227 */ "limitSpecification ::= LIMIT numericValueOperand",
 /* 228 */ "booleanValueExpression ::= predicateValueExpression",
 /* 229 */ "predicateValueExpression ::= LEFT_PARENTHESIS predicateValueExpression RIGHT_PARENTHESIS",
 /* 230 */ "predicateValueExpression ::= predicateValueExpression OR predicateValueExpression",
 /* 231 */ "predicateValueExpression ::= predicateValueExpression AND predicateValueExpression",
 /* 232 */ "predicateValueExpression ::= NOT predicateValueExpression",
 /* 233 */ "predicateValueExpression ::= comparisonPredicate",
 /* 234 */ "predicateValueExpression ::= betweenPredicate",
 /* 235 */ "predicateValueExpression ::= inPredicate",
 /* 236 */ "predicateValueExpression ::= likePredicate",
 /* 237 */ "predicateValueExpression ::= containsPredicate",
 /* 238 */ "predicateValueExpression ::= isNullPredicate",
 /* 239 */ "predicateValueExpression ::= existsPredicate",
 /* 240 */ "predicateValueExpression ::= similarPredicate",
 /* 241 */ "predicateValueExpression ::= isSubstringOfPredicate",
 /* 242 */ "comparisonPredicate ::= nonPredicateValueExpression EQUALS nonPredicateValueExpression",
 /* 243 */ "comparisonPredicate ::= nonPredicateValueExpression NOT_EQUALS nonPredicateValueExpression",
 /* 244 */ "comparisonPredicate ::= nonPredicateValueExpression LESS_THAN nonPredicateValueExpression",
 /* 245 */ "comparisonPredicate ::= nonPredicateValueExpression LESS_THAN_OR_EQUALS nonPredicateValueExpression",
 /* 246 */ "comparisonPredicate ::= nonPredicateValueExpression GREATER_THAN nonPredicateValueExpression",
 /* 247 */ "comparisonPredicate ::= nonPredicateValueExpression GREATER_THAN_OR_EQUALS nonPredicateValueExpression",
 /* 248 */ "betweenPredicate ::= nonPredicateValueExpression BETWEEN nonPredicateValueExpression AND nonPredicateValueExpression",
 /* 249 */ "betweenPredicate ::= nonPredicateValueExpression NOT BETWEEN nonPredicateValueExpression AND nonPredicateValueExpression",
 /* 250 */ "inPredicate ::= nonPredicateValueExpression IN inPredicateSubquery",
 /* 251 */ "inPredicate ::= nonPredicateValueExpression IN inPredicateValue",
 /* 252 */ "inPredicate ::= nonPredicateValueExpression NOT IN inPredicateSubquery",
 /* 253 */ "inPredicate ::= nonPredicateValueExpression NOT IN inPredicateValue",
 /* 254 */ "inPredicateSubquery ::= tableSubquery",
 /* 255 */ "inPredicateValue ::= LEFT_PARENTHESIS tableValueConstructorList RIGHT_PARENTHESIS",
 /* 256 */ "inPredicateValue ::= variableName",
 /* 257 */ "likePredicate ::= stringValueOperand LIKE stringValueOperand optionalLanguage",
 /* 258 */ "likePredicate ::= stringValueOperand LIKE stringValueOperand escape optionalLanguage",
 /* 259 */ "likePredicate ::= stringValueOperand LIKE stringValueOperand language escape",
 /* 260 */ "likePredicate ::= nonPredicateValueExpression NOT LIKE stringValueOperand optionalLanguage",
 /* 261 */ "likePredicate ::= nonPredicateValueExpression NOT LIKE stringValueOperand escape optionalLanguage",
 /* 262 */ "likePredicate ::= nonPredicateValueExpression NOT LIKE stringValueOperand language escape",
 /* 263 */ "escape ::= ESCAPE stringValueOperand",
 /* 264 */ "optionalLanguage ::=",
 /* 265 */ "optionalLanguage ::= language",
 /* 266 */ "language ::= LANGUAGE stringValueOperand",
 /* 267 */ "scaleParameter ::= SCALE PARAMETER numericValueOperand",
 /* 268 */ "wordLimit ::= WORD LIMIT numericValueOperand",
 /* 269 */ "containsPredicate ::= nonPredicateValueExpression CONTAINS containsOperand containsOption",
 /* 270 */ "containsOption ::=",
 /* 271 */ "containsOption ::= containsOption calculator",
 /* 272 */ "containsOption ::= containsOption combiner",
 /* 273 */ "containsOption ::= containsOption averageLength",
 /* 274 */ "containsOption ::= containsOption df",
 /* 275 */ "containsOption ::= containsOption scoreFunction",
 /* 276 */ "containsOption ::= containsOption expand",
 /* 277 */ "containsOption ::= containsOption extractor",
 /* 278 */ "containsOption ::= containsOption clusteredLimit",
 /* 279 */ "containsOption ::= containsOption scoreCombiner",
 /* 280 */ "containsOption ::= containsOption clusteredCombiner",
 /* 281 */ "containsOption ::= containsOption rankFrom",
 /* 282 */ "containsOperand ::= containsOperandList",
 /* 283 */ "containsOperand ::= WORDLIST LEFT_PARENTHESIS wordList RIGHT_PARENTHESIS",
 /* 284 */ "containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand optionalLanguage RIGHT_PARENTHESIS",
 /* 285 */ "containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand scaleParameter RIGHT_PARENTHESIS",
 /* 286 */ "containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand wordLimit RIGHT_PARENTHESIS",
 /* 287 */ "containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand language scaleParameter RIGHT_PARENTHESIS",
 /* 288 */ "containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand scaleParameter language RIGHT_PARENTHESIS",
 /* 289 */ "containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand language wordLimit RIGHT_PARENTHESIS",
 /* 290 */ "containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand wordLimit language RIGHT_PARENTHESIS",
 /* 291 */ "containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand scaleParameter wordLimit RIGHT_PARENTHESIS",
 /* 292 */ "containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand wordLimit scaleParameter RIGHT_PARENTHESIS",
 /* 293 */ "containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand language scaleParameter wordLimit RIGHT_PARENTHESIS",
 /* 294 */ "containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand language wordLimit scaleParameter RIGHT_PARENTHESIS",
 /* 295 */ "containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand scaleParameter wordLimit language RIGHT_PARENTHESIS",
 /* 296 */ "containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand scaleParameter language wordLimit RIGHT_PARENTHESIS",
 /* 297 */ "containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand wordLimit language scaleParameter RIGHT_PARENTHESIS",
 /* 298 */ "containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand wordLimit scaleParameter language RIGHT_PARENTHESIS",
 /* 299 */ "containsOperandList ::= containsOperandPrimary",
 /* 300 */ "containsOperandList ::= LEFT_PARENTHESIS containsOperandList combiner RIGHT_PARENTHESIS",
 /* 301 */ "containsOperandList ::= containsOperandList VERTICALLINE containsOperandList",
 /* 302 */ "containsOperandList ::= containsOperandList MINUS containsOperandList",
 /* 303 */ "containsOperandList ::= containsOperandList AMPERSAND containsOperandList",
 /* 304 */ "combiner ::= COMBINER stringValueOperand",
 /* 305 */ "wordList ::= word",
 /* 306 */ "wordList ::= wordList COMMA word",
 /* 307 */ "word ::= containsOperandWord optionalCategory",
 /* 308 */ "word ::= containsOperandWord scale optionalCategory",
 /* 309 */ "word ::= containsOperandWord category scale",
 /* 310 */ "word ::= containsOperandWord language optionalCategory",
 /* 311 */ "word ::= containsOperandWord language scale optionalCategory",
 /* 312 */ "word ::= containsOperandWord language category scale optionalDf",
 /* 313 */ "word ::= containsOperandWord category language optionalScale",
 /* 314 */ "word ::= containsOperandWord scale language optionalCategory",
 /* 315 */ "word ::= containsOperandWord category scale language optionalDf",
 /* 316 */ "word ::= containsOperandWord scale category language optionalDf",
 /* 317 */ "word ::= containsOperandWord df optionalCategory",
 /* 318 */ "word ::= containsOperandWord df scale optionalCategory",
 /* 319 */ "word ::= containsOperandWord df category scale optionalLanguage",
 /* 320 */ "word ::= containsOperandWord df category language optionalScale",
 /* 321 */ "word ::= containsOperandWord df scale language optionalCategory",
 /* 322 */ "word ::= containsOperandWord df language optionalCategory",
 /* 323 */ "word ::= containsOperandWord df language category scale",
 /* 324 */ "word ::= containsOperandWord df language scale optionalCategory",
 /* 325 */ "word ::= containsOperandWord category df optionalScale",
 /* 326 */ "word ::= containsOperandWord scale df optionalCategory",
 /* 327 */ "word ::= containsOperandWord category scale df optionalLanguage",
 /* 328 */ "word ::= containsOperandWord scale category df optionalLanguage",
 /* 329 */ "word ::= containsOperandWord category language scale df",
 /* 330 */ "word ::= containsOperandWord category df scale language",
 /* 331 */ "word ::= containsOperandWord scale language category df",
 /* 332 */ "word ::= containsOperandWord scale df category language",
 /* 333 */ "word ::= containsOperandWord language scale category df",
 /* 334 */ "word ::= containsOperandWord language scale df optionalCategory",
 /* 335 */ "word ::= containsOperandWord df scale category language",
 /* 336 */ "optionalCategory ::=",
 /* 337 */ "optionalCategory ::= category",
 /* 338 */ "category ::= CATEGORY stringValueOperand",
 /* 339 */ "optionalScale ::=",
 /* 340 */ "optionalScale ::= scale",
 /* 341 */ "scale ::= SCALE numericValueOperand",
 /* 342 */ "containsOperandPrimary ::= containsOperandParticle",
 /* 343 */ "containsOperandPrimary ::= LEFT_PARENTHESIS containsOperandList RIGHT_PARENTHESIS",
 /* 344 */ "containsOperandPrimary ::= WEIGHT LEFT_PARENTHESIS containsOperandList scale RIGHT_PARENTHESIS",
 /* 345 */ "containsOperandParticleList ::= containsOperandParticle containsOperandParticle",
 /* 346 */ "containsOperandParticleList ::= containsOperandParticleList containsOperandParticle",
 /* 347 */ "containsOperandParticle ::= containsOperandWord",
 /* 348 */ "containsOperandParticle ::= SYNONYM LEFT_PARENTHESIS containsOperandWordList RIGHT_PARENTHESIS",
 /* 349 */ "containsOperandParticle ::= EXPAND_SYNONYM LEFT_PARENTHESIS containsOperandWord RIGHT_PARENTHESIS",
 /* 350 */ "containsOperandParticle ::= HEAD LEFT_PARENTHESIS containsOperandParticle RIGHT_PARENTHESIS",
 /* 351 */ "containsOperandParticle ::= TAIL LEFT_PARENTHESIS containsOperandParticle RIGHT_PARENTHESIS",
 /* 352 */ "containsOperandParticle ::= WITHIN LEFT_PARENTHESIS containsOperandParticleList optionalLowerDist upperDist RIGHT_PARENTHESIS",
 /* 353 */ "containsOperandParticle ::= WITHIN LEFT_PARENTHESIS containsOperandParticleList SYMMETRIC optionalLowerDist upperDist RIGHT_PARENTHESIS",
 /* 354 */ "containsOperandParticle ::= WITHIN LEFT_PARENTHESIS containsOperandParticleList ASYMMETRIC optionalLowerDist upperDist RIGHT_PARENTHESIS",
 /* 355 */ "containsOperandWordList ::= containsOperandWord containsOperandWord",
 /* 356 */ "containsOperandWordList ::= containsOperandWordList containsOperandWord",
 /* 357 */ "containsOperandWord ::= containsOperandPattern",
 /* 358 */ "containsOperandWord ::= EXACTWORD LEFT_PARENTHESIS containsOperandPattern RIGHT_PARENTHESIS",
 /* 359 */ "containsOperandWord ::= SIMPLEWORD LEFT_PARENTHESIS containsOperandPattern RIGHT_PARENTHESIS",
 /* 360 */ "containsOperandWord ::= CONTAINS_STRING LEFT_PARENTHESIS containsOperandPattern RIGHT_PARENTHESIS",
 /* 361 */ "containsOperandWord ::= WORDHEAD LEFT_PARENTHESIS containsOperandPattern RIGHT_PARENTHESIS",
 /* 362 */ "containsOperandWord ::= WORDTAIL LEFT_PARENTHESIS containsOperandPattern RIGHT_PARENTHESIS",
 /* 363 */ "containsOperandPattern ::= stringValueOperand",
 /* 364 */ "containsOperandPattern ::= stringValueOperand language",
 /* 365 */ "upperDist ::= UPPER numericValueOperand",
 /* 366 */ "optionalLowerDist ::=",
 /* 367 */ "optionalLowerDist ::= lowerDist",
 /* 368 */ "lowerDist ::= LOWER numericValueOperand",
 /* 369 */ "calculator ::= CALCULATOR stringValueOperand",
 /* 370 */ "averageLength ::= AVERAGE LENGTH nonPredicateValueExpression",
 /* 371 */ "averageLength ::= AVERAGE FULLTEXT LENGTH nonPredicateValueExpression",
 /* 372 */ "optionalDf ::=",
 /* 373 */ "optionalDf ::= df",
 /* 374 */ "df ::= DF numericValueOperand",
 /* 375 */ "scoreFunction ::= SCORE FUNCTION stringValueOperand",
 /* 376 */ "expand ::= EXPAND LEFT_PARENTHESIS FROM tableSubquery optionalSortSpecificationList optionalLimitSpecification RIGHT_PARENTHESIS",
 /* 377 */ "rankFrom ::= RANK FROM tableSubquery",
 /* 378 */ "extractor ::= EXTRACTOR stringValueOperand",
 /* 379 */ "clusteredLimit ::= CLUSTERED LIMIT numericValueOperand",
 /* 380 */ "scoreCombiner ::= SCORE COMBINER stringValueOperand",
 /* 381 */ "clusteredCombiner ::= CLUSTERED COMBINER stringValueOperand",
 /* 382 */ "isNullPredicate ::= nonPredicateValueExpression IS NULL",
 /* 383 */ "isNullPredicate ::= nonPredicateValueExpression IS NOT NULL",
 /* 384 */ "existsPredicate ::= EXISTS tableSubquery",
 /* 385 */ "similarPredicate ::= stringValueOperand SIMILAR TO stringValueOperand optionalLanguage",
 /* 386 */ "similarPredicate ::= stringValueOperand SIMILAR TO stringValueOperand escape optionalLanguage",
 /* 387 */ "similarPredicate ::= stringValueOperand SIMILAR TO stringValueOperand language escape",
 /* 388 */ "similarPredicate ::= nonPredicateValueExpression NOT SIMILAR TO stringValueOperand optionalLanguage",
 /* 389 */ "similarPredicate ::= nonPredicateValueExpression NOT SIMILAR TO stringValueOperand escape optionalLanguage",
 /* 390 */ "similarPredicate ::= nonPredicateValueExpression NOT SIMILAR TO stringValueOperand language escape",
 /* 391 */ "isSubstringOfPredicate ::= nonPredicateValueExpression IS SUBSTRING OF nonPredicateValueExpression",
 /* 392 */ "nonPredicateValueExpression ::= rowValueExpression",
 /* 393 */ "stringValueExpression ::= stringRowValueExpression",
 /* 394 */ "stringValueExpression ::= stringValueExpressionPrimary",
 /* 395 */ "stringRowValueExpression ::= LEFT_PARENTHESIS stringValueExpression RIGHT_PARENTHESIS",
 /* 396 */ "stringValueExpressionPrimary ::= stringValueSpecification",
 /* 397 */ "stringValueExpressionPrimary ::= stringValueFunction",
 /* 398 */ "stringValueExpressionPrimary ::= stringConcatenation",
 /* 399 */ "stringValueFunction ::= SUBSTRING LEFT_PARENTHESIS stringOrArrayValueOperand FROM numericValueOperand RIGHT_PARENTHESIS",
 /* 400 */ "stringValueFunction ::= SUBSTRING LEFT_PARENTHESIS stringOrArrayValueOperand FROM numericValueOperand FOR numericValueOperand RIGHT_PARENTHESIS",
 /* 401 */ "stringValueFunction ::= OVERLAY LEFT_PARENTHESIS stringOrArrayValueOperand PLACING stringOrArrayValueOperand FROM numericValueOperand RIGHT_PARENTHESIS",
 /* 402 */ "stringValueFunction ::= OVERLAY LEFT_PARENTHESIS stringOrArrayValueOperand PLACING stringOrArrayValueOperand FROM numericValueOperand FOR numericValueOperand RIGHT_PARENTHESIS",
 /* 403 */ "stringValueFunction ::= NORMALIZE LEFT_PARENTHESIS stringValueOperand USING stringValueOperand RIGHT_PARENTHESIS",
 /* 404 */ "stringValueFunction ::= KWIC LEFT_PARENTHESIS singleElementFulltextOperand FOR kwicNumericOption optionalKwicStartTag optionalKwicEndTag optionalKwicEscape optionalKwicEllipsis RIGHT_PARENTHESIS",
 /* 405 */ "optionalKwicStartTag ::=",
 /* 406 */ "optionalKwicStartTag ::= ENCLOSE WITH kwicStringOption",
 /* 407 */ "optionalKwicEndTag ::=",
 /* 408 */ "optionalKwicEndTag ::= AND kwicStringOption",
 /* 409 */ "optionalKwicEscape ::=",
 /* 410 */ "optionalKwicEscape ::= ESCAPE kwicStringOption",
 /* 411 */ "optionalKwicEllipsis ::=",
 /* 412 */ "optionalKwicEllipsis ::= ELLIPSIS kwicStringOption",
 /* 413 */ "kwicStringOption ::= stringValueSpecification",
 /* 414 */ "kwicStringOption ::= placeHolder",
 /* 415 */ "kwicNumericOption ::= numericValueSpecification",
 /* 416 */ "kwicNumericOption ::= placeHolder",
 /* 417 */ "stringConcatenation ::= stringOrArrayValueOperand STRING_CONCAT stringOrArrayValueOperand",
 /* 418 */ "stringValueOperand ::= stringRowValueExpression",
 /* 419 */ "stringValueOperand ::= stringValueExpressionPrimary",
 /* 420 */ "stringValueOperand ::= generalValueExpression",
 /* 421 */ "stringOrArrayValueOperand ::= stringRowValueExpression",
 /* 422 */ "stringOrArrayValueOperand ::= stringValueExpressionPrimary",
 /* 423 */ "stringOrArrayValueOperand ::= arrayRowValueExpression",
 /* 424 */ "stringOrArrayValueOperand ::= arrayValueExpressionPrimary",
 /* 425 */ "stringOrArrayValueOperand ::= generalValueExpression",
 /* 426 */ "numericValueExpression ::= numericRowValueExpression",
 /* 427 */ "numericValueExpression ::= numericValueExpressionPrimary",
 /* 428 */ "numericRowValueExpression ::= LEFT_PARENTHESIS numericValueExpression RIGHT_PARENTHESIS",
 /* 429 */ "numericValueExpressionPrimary ::= numericValueSpecification",
 /* 430 */ "numericValueExpressionPrimary ::= numericValueFunction",
 /* 431 */ "numericValueExpressionPrimary ::= arithmeticOperation",
 /* 432 */ "numericValueFunction ::= numericValueSetFunction",
 /* 433 */ "numericValueFunction ::= ABS LEFT_PARENTHESIS numericValueOperand RIGHT_PARENTHESIS",
 /* 434 */ "numericValueFunction ::= MOD LEFT_PARENTHESIS numericValueOperand COMMA numericValueOperand RIGHT_PARENTHESIS",
 /* 435 */ "numericValueFunction ::= score",
 /* 436 */ "numericValueFunction ::= GET MAX LEFT_PARENTHESIS scoreList RIGHT_PARENTHESIS",
 /* 437 */ "numericValueSetFunction ::= COUNT LEFT_PARENTHESIS ASTERISK RIGHT_PARENTHESIS",
 /* 438 */ "numericValueSetFunction ::= COUNT LEFT_PARENTHESIS optionalSetQuantifier nonPredicateValueExpression RIGHT_PARENTHESIS",
 /* 439 */ "numericValueSetFunction ::= AVG LEFT_PARENTHESIS optionalSetQuantifier numericValueOperand RIGHT_PARENTHESIS",
 /* 440 */ "numericValueSetFunction ::= SUM LEFT_PARENTHESIS optionalSetQuantifier numericValueOperand RIGHT_PARENTHESIS",
 /* 441 */ "arithmeticOperation ::= numericValueOperand PLUS numericValueOperand",
 /* 442 */ "arithmeticOperation ::= numericValueOperand MINUS numericValueOperand",
 /* 443 */ "arithmeticOperation ::= numericValueOperand ASTERISK numericValueOperand",
 /* 444 */ "arithmeticOperation ::= numericValueOperand SOLIDUS numericValueOperand",
 /* 445 */ "arithmeticOperation ::= PLUS numericValueOperand",
 /* 446 */ "arithmeticOperation ::= MINUS numericValueOperand",
 /* 447 */ "numericValueOperand ::= numericRowValueExpression",
 /* 448 */ "numericValueOperand ::= numericValueExpressionPrimary",
 /* 449 */ "numericValueOperand ::= generalValueExpression",
 /* 450 */ "datetimeValueExpression ::= datetimeRowValueExpression",
 /* 451 */ "datetimeValueExpression ::= datetimeValueExpressionPrimary",
 /* 452 */ "datetimeRowValueExpression ::= LEFT_PARENTHESIS datetimeValueExpression RIGHT_PARENTHESIS",
 /* 453 */ "datetimeValueExpressionPrimary ::= datetimeValueSpecification",
 /* 454 */ "datetimeValueExpressionPrimary ::= datetimeValueFunction",
 /* 455 */ "datetimeValueFunction ::= CURRENT_DATE",
 /* 456 */ "datetimeValueFunction ::= CURRENT_TIMESTAMP",
 /* 457 */ "generalValueExpression ::= generalRowValueExpression",
 /* 458 */ "generalValueExpression ::= generalValueExpressionPrimary",
 /* 459 */ "generalRowValueExpression ::= LEFT_PARENTHESIS generalValueExpression RIGHT_PARENTHESIS",
 /* 460 */ "generalRowValueExpression ::= rowSubquery",
 /* 461 */ "generalValueExpressionPrimary ::= noTypeValueSpecification",
 /* 462 */ "generalValueExpressionPrimary ::= generalFunction0Arg",
 /* 463 */ "generalValueExpressionPrimary ::= generalFunctionNArgs",
 /* 464 */ "generalValueExpressionPrimary ::= caseExpression",
 /* 465 */ "generalValueExpressionPrimary ::= generalSetFunction",
 /* 466 */ "generalFunction0Arg ::= identifier LEFT_PARENTHESIS RIGHT_PARENTHESIS",
 /* 467 */ "generalFunction0Arg ::= identifier LEFT_PARENTHESIS RIGHT_PARENTHESIS PERIOD identifier",
 /* 468 */ "generalFunctionNArgs ::= identifier LEFT_PARENTHESIS rowValueConstructorList hint RIGHT_PARENTHESIS",
 /* 469 */ "generalFunctionNArgs ::= identifier LEFT_PARENTHESIS rowValueConstructorList hint RIGHT_PARENTHESIS PERIOD identifier",
 /* 470 */ "caseExpression ::= caseSimpleCase",
 /* 471 */ "caseExpression ::= caseSearchedCase",
 /* 472 */ "caseSimpleCase ::= CASE caseOperand simpleWhenClauseList optionalElseClause END",
 /* 473 */ "caseSearchedCase ::= CASE searchedWhenClauseList optionalElseClause END",
 /* 474 */ "caseOperand ::= nonPredicateValueExpression",
 /* 475 */ "simpleWhenClauseList ::= simpleWhenClause",
 /* 476 */ "simpleWhenClauseList ::= simpleWhenClauseList simpleWhenClause",
 /* 477 */ "simpleWhenClause ::= WHEN simpleWhenOperandList THEN nonPredicateValueExpression",
 /* 478 */ "simpleWhenOperandList ::= nonPredicateValueExpression",
 /* 479 */ "simpleWhenOperandList ::= simpleWhenOperandList COMMA nonPredicateValueExpression",
 /* 480 */ "searchedWhenClauseList ::= searchedWhenClause",
 /* 481 */ "searchedWhenClauseList ::= searchedWhenClauseList searchedWhenClause",
 /* 482 */ "searchedWhenClause ::= WHEN searchCondition THEN nonPredicateValueExpression",
 /* 483 */ "optionalElseClause ::=",
 /* 484 */ "optionalElseClause ::= ELSE nonPredicateValueExpression",
 /* 485 */ "generalSetFunction ::= MAX LEFT_PARENTHESIS optionalSetQuantifier nonPredicateValueExpression RIGHT_PARENTHESIS",
 /* 486 */ "generalSetFunction ::= MIN LEFT_PARENTHESIS optionalSetQuantifier nonPredicateValueExpression RIGHT_PARENTHESIS",
 /* 487 */ "generalSetFunction ::= SECTIONIZED LEFT_PARENTHESIS fulltextOperand RIGHT_PARENTHESIS",
 /* 488 */ "generalSetFunction ::= WORD LEFT_PARENTHESIS fulltextOperand RIGHT_PARENTHESIS",
 /* 489 */ "generalSetFunction ::= WORD LEFT_PARENTHESIS fulltextOperand RIGHT_PARENTHESIS PERIOD DF",
 /* 490 */ "generalSetFunction ::= WORD LEFT_PARENTHESIS fulltextOperand RIGHT_PARENTHESIS PERIOD SCALE",
 /* 491 */ "fulltextOperand ::= singleElementFulltextOperand",
 /* 492 */ "fulltextOperand ::= multiElementFulltextOperand",
 /* 493 */ "fulltextOperand ::= LEFT_PARENTHESIS fulltextOperand RIGHT_PARENTHESIS",
 /* 494 */ "singleElementFulltextOperand ::= itemReference",
 /* 495 */ "multiElementFulltextOperand ::= singleElementFulltextOperand COMMA fulltextOperandList",
 /* 496 */ "fulltextOperandList ::= singleElementFulltextOperand",
 /* 497 */ "fulltextOperandList ::= fulltextOperandList COMMA singleElementFulltextOperand",
 /* 498 */ "score ::= SCORE LEFT_PARENTHESIS fulltextOperand RIGHT_PARENTHESIS",
 /* 499 */ "scoreList ::= score",
 /* 500 */ "scoreList ::= scoreList COMMA score",
 /* 501 */ "arrayValueExpression ::= arrayRowValueExpression",
 /* 502 */ "arrayValueExpression ::= arrayValueExpressionPrimary",
 /* 503 */ "arrayRowValueExpression ::= LEFT_PARENTHESIS arrayValueExpression RIGHT_PARENTHESIS",
 /* 504 */ "arrayValueExpressionPrimary ::= arrayValueConstructor",
 /* 505 */ "arrayValueExpressionPrimary ::= arrayStringFunction",
 /* 506 */ "arrayValueConstructor ::= ARRAY LEFT_BRACKET arrayElementList RIGHT_BRACKET",
 /* 507 */ "arrayValueConstructor ::= ARRAY LEFT_BRACKET RIGHT_BRACKET",
 /* 508 */ "arrayStringFunction ::= expandStringFunction",
 /* 509 */ "expandStringFunction ::= EXPAND_SYNONYM LEFT_PARENTHESIS stringValueOperand USING stringValueOperand RIGHT_PARENTHESIS",
 /* 510 */ "arrayElementList ::= arrayElement",
 /* 511 */ "arrayElementList ::= arrayElementList COMMA arrayElement",
 /* 512 */ "arrayElement ::= nonPredicateValueExpression",
 /* 513 */ "arrayValueOperand ::= arrayRowValueExpression",
 /* 514 */ "arrayValueOperand ::= arrayValueExpressionPrimary",
 /* 515 */ "arrayValueOperand ::= generalValueExpression",
 /* 516 */ "rowValueExpression ::= nonPredicateValueExpressionPrimary",
 /* 517 */ "rowValueExpression ::= rowValueConstructor",
 /* 518 */ "rowValueExpression ::= generalValueExpression",
 /* 519 */ "rowRowValueExpression ::= LEFT_PARENTHESIS rowValueExpressionPrimary RIGHT_PARENTHESIS",
 /* 520 */ "rowValueExpressionPrimary ::= LEFT_PARENTHESIS multiElementRowValueConstructor RIGHT_PARENTHESIS",
 /* 521 */ "nonPredicateValueExpressionPrimary ::= numericValueExpressionPrimary",
 /* 522 */ "nonPredicateValueExpressionPrimary ::= stringValueExpressionPrimary",
 /* 523 */ "nonPredicateValueExpressionPrimary ::= datetimeValueExpressionPrimary",
 /* 524 */ "nonPredicateValueExpressionPrimary ::= arrayValueExpressionPrimary",
 /* 525 */ "nonPredicateValueExpressionPrimary ::= rowValueExpressionPrimary",
 /* 526 */ "rowValueConstructor ::= multiElementRowValueConstructor",
 /* 527 */ "rowValueConstructor ::= numericRowValueExpression",
 /* 528 */ "rowValueConstructor ::= stringRowValueExpression",
 /* 529 */ "rowValueConstructor ::= datetimeRowValueExpression",
 /* 530 */ "rowValueConstructor ::= arrayRowValueExpression",
 /* 531 */ "rowValueConstructor ::= rowRowValueExpression",
 /* 532 */ "multiElementRowValueConstructor ::= LEFT_PARENTHESIS rowValueConstructorElement COMMA rowValueConstructorList RIGHT_PARENTHESIS",
 /* 533 */ "multiElementRowValueConstructor ::= ROW LEFT_PARENTHESIS rowValueConstructorList RIGHT_PARENTHESIS",
 /* 534 */ "rowValueConstructorList ::= rowValueConstructorElement",
 /* 535 */ "rowValueConstructorList ::= rowValueConstructorList COMMA rowValueConstructorElement",
 /* 536 */ "rowValueConstructorElement ::= nonPredicateValueExpression",
 /* 537 */ "tableValueConstructor ::= VALUES tableValueConstructorList",
 /* 538 */ "tableValueConstructorList ::= rowValueExpression",
 /* 539 */ "tableValueConstructorList ::= tableValueConstructorList COMMA rowValueExpression",
 /* 540 */ "tableValueConstructorList ::= tableValueConstructorList COMMA",
 /* 541 */ "explicitTable ::= TABLE tableName",
 /* 542 */ "deleteStatement ::= delete targetTable optionalWhereClause",
 /* 543 */ "deleteStatement ::= delete targetTable asCorrelationName optionalWhereClause",
 /* 544 */ "delete ::= DELETE FROM",
 /* 545 */ "delete ::= DELETE",
 /* 546 */ "targetTable ::= tableName",
 /* 547 */ "insertStatement ::= insert tableName insertColumnsAndSource",
 /* 548 */ "insert ::= INSERT INTO",
 /* 549 */ "insert ::= INSERT",
 /* 550 */ "insertColumnsAndSource ::= LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS queryExpression",
 /* 551 */ "insertColumnsAndSource ::= queryExpression",
 /* 552 */ "insertColumnsAndSource ::= DEFAULT VALUES",
 /* 553 */ "insertColumnsAndSource ::= LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS bulkInput",
 /* 554 */ "insertColumnsAndSource ::= bulkInput",
 /* 555 */ "bulkInput ::= INPUT FROM bulkSpecification",
 /* 556 */ "updateStatement ::= UPDATE targetTable SET setClauseList optionalWhereClause",
 /* 557 */ "updateStatement ::= UPDATE targetTable asCorrelationName SET setClauseList optionalWhereClause",
 /* 558 */ "setClauseList ::= setClause",
 /* 559 */ "setClauseList ::= setClauseList COMMA setClause",
 /* 560 */ "setClauseList ::= setClauseList COMMA",
 /* 561 */ "setClause ::= updateTarget EQUALS nonPredicateValueExpression",
 /* 562 */ "setClause ::= updateTargetList EQUALS rowValueExpression",
 /* 563 */ "updateTarget ::= columnName",
 /* 564 */ "updateTargetList ::= LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS",
 /* 565 */ "startTransactionStatement ::= START TRANSACTION transactModeList",
 /* 566 */ "transactModeList ::= transactMode",
 /* 567 */ "transactModeList ::= transactModeList COMMA transactMode",
 /* 568 */ "transactMode ::= transactAccMode",
 /* 569 */ "transactMode ::= isolationLevel",
 /* 570 */ "transactMode ::= usingSnapshotMode",
 /* 571 */ "transactAccMode ::= READ ONLY",
 /* 572 */ "transactAccMode ::= READ WRITE",
 /* 573 */ "isolationLevel ::= ISOLATION LEVEL levelOfIsolation",
 /* 574 */ "levelOfIsolation ::= READ UNCOMMITTED",
 /* 575 */ "levelOfIsolation ::= READ COMMITTED",
 /* 576 */ "levelOfIsolation ::= REPEATABLE READ",
 /* 577 */ "levelOfIsolation ::= SERIALIZABLE",
 /* 578 */ "usingSnapshotMode ::= USING SNAPSHOT",
 /* 579 */ "setTransactionStatement ::= SET TRANSACTION transactModeList",
 /* 580 */ "commitStatement ::= COMMIT",
 /* 581 */ "commitStatement ::= COMMIT WORK",
 /* 582 */ "rollbackStatement ::= ROLLBACK",
 /* 583 */ "rollbackStatement ::= ROLLBACK WORK",
 /* 584 */ "xa_Identifier ::= binaryStringLiteral",
 /* 585 */ "xa_Identifier ::= binaryStringLiteral COMMA binaryStringLiteral",
 /* 586 */ "xa_Identifier ::= binaryStringLiteral COMMA binaryStringLiteral COMMA signedIntegerLiteral",
 /* 587 */ "signedIntegerLiteral ::= unsignedIntegerLiteral",
 /* 588 */ "signedIntegerLiteral ::= PLUS unsignedIntegerLiteral",
 /* 589 */ "signedIntegerLiteral ::= MINUS unsignedIntegerLiteral",
 /* 590 */ "xa_StartStatement ::= XA START xa_Identifier",
 /* 591 */ "xa_StartStatement ::= XA START xa_Identifier transactModeList",
 /* 592 */ "xa_StartStatement ::= XA START xa_Identifier JOIN",
 /* 593 */ "xa_StartStatement ::= XA START xa_Identifier RESUME",
 /* 594 */ "xa_EndStatement ::= XA END xa_Identifier xa_EndStatement_SuspensionMode",
 /* 595 */ "xa_EndStatement_SuspensionMode ::=",
 /* 596 */ "xa_EndStatement_SuspensionMode ::= SUSPEND",
 /* 597 */ "xa_EndStatement_SuspensionMode ::= SUSPEND FOR MIGRATE",
 /* 598 */ "xa_PrepareStatement ::= XA PREPARE xa_Identifier",
 /* 599 */ "xa_CommitStatement ::= XA COMMIT xa_Identifier",
 /* 600 */ "xa_CommitStatement ::= XA COMMIT xa_Identifier ONE PHASE",
 /* 601 */ "xa_RollbackStatement ::= XA ROLLBACK xa_Identifier",
 /* 602 */ "xa_RecoverStatement ::= XA RECOVER",
 /* 603 */ "xa_ForgetStatement ::= XA FORGET xa_Identifier",
 /* 604 */ "databaseDefinition ::= CREATE DATABASE identifier optionalDatabaseCreateOption",
 /* 605 */ "optionalDatabaseCreateOption ::= databaseCreateOptionList",
 /* 606 */ "optionalDatabaseCreateOption ::=",
 /* 607 */ "databaseCreateOptionList ::= databaseCreateOption",
 /* 608 */ "databaseCreateOptionList ::= databaseCreateOptionList databaseCreateOption",
 /* 609 */ "databaseCreateOption ::= dbPathClause",
 /* 610 */ "databaseCreateOption ::= readwriteAttribute",
 /* 611 */ "databaseCreateOption ::= onlineAttribute",
 /* 612 */ "databaseCreateOption ::= recoveryAttribute",
 /* 613 */ "databaseCreateOption ::= userModeAttribute",
 /* 614 */ "dbPathClause ::= PATH dbPathElementList",
 /* 615 */ "dbPathElementList ::= dbPathElement",
 /* 616 */ "dbPathElementList ::= dbPathElementList dbPathElement",
 /* 617 */ "dbPathElement ::= pathName",
 /* 618 */ "dbPathElement ::= LOGICALLOG pathName",
 /* 619 */ "dbPathElement ::= SYSTEM pathName",
 /* 620 */ "pathName ::= characterStringLiteral",
 /* 621 */ "readwriteAttribute ::= READ ONLY",
 /* 622 */ "readwriteAttribute ::= READ WRITE",
 /* 623 */ "onlineAttribute ::= ONLINE",
 /* 624 */ "onlineAttribute ::= OFFLINE",
 /* 625 */ "onlineAttributeForAlter ::= ONLINE WITH DISCARD LOGICALLOG",
 /* 626 */ "recoveryAttribute ::= RECOVERY FULL",
 /* 627 */ "recoveryAttribute ::= RECOVERY CHECKPOINT",
 /* 628 */ "userModeAttribute ::= USER ALL",
 /* 629 */ "userModeAttribute ::= USER SYSTEM",
 /* 630 */ "dropDatabaseStatement ::= DROP DATABASE identifier optionalIfExists",
 /* 631 */ "alterDatabaseStatement ::= ALTER DATABASE dbName SET dbPathClause",
 /* 632 */ "alterDatabaseStatement ::= ALTER DATABASE dbName DROP dbPathClause",
 /* 633 */ "alterDatabaseStatement ::= ALTER DATABASE dbName alterDatabaseOption",
 /* 634 */ "alterDatabaseStatement ::= ALTER DATABASE dbName START SLAVE",
 /* 635 */ "alterDatabaseStatement ::= ALTER DATABASE dbName STOP SLAVE",
 /* 636 */ "alterDatabaseStatement ::= ALTER DATABASE dbName SET TO MASTER",
 /* 637 */ "dbName ::= identifier",
 /* 638 */ "alterDatabaseOption ::= alterDatabaseAttributeList",
 /* 639 */ "alterDatabaseAttributeList ::= alterDatabaseAttribute",
 /* 640 */ "alterDatabaseAttributeList ::= alterDatabaseAttributeList alterDatabaseAttribute",
 /* 641 */ "alterDatabaseAttribute ::= readwriteAttribute",
 /* 642 */ "alterDatabaseAttribute ::= onlineAttribute",
 /* 643 */ "alterDatabaseAttribute ::= onlineAttributeForAlter",
 /* 644 */ "alterDatabaseAttribute ::= recoveryAttribute",
 /* 645 */ "alterDatabaseAttribute ::= userModeAttribute",
 /* 646 */ "tableDefinition ::= CREATE tableScopeClause TABLE tableName tableConstantClause LEFT_PARENTHESIS tableElementList RIGHT_PARENTHESIS hint tableAreaOption",
 /* 647 */ "tableScopeClause ::= GLOBAL TEMPORARY",
 /* 648 */ "tableScopeClause ::= LOCAL TEMPORARY",
 /* 649 */ "tableScopeClause ::= TEMPORARY",
 /* 650 */ "tableScopeClause ::=",
 /* 651 */ "tableConstantClause ::= CONSTANT",
 /* 652 */ "tableConstantClause ::= UPDATABLE",
 /* 653 */ "tableConstantClause ::=",
 /* 654 */ "tableElementList ::= tableElement",
 /* 655 */ "tableElementList ::= tableElementList COMMA tableElement",
 /* 656 */ "tableElementList ::= tableElementList COMMA",
 /* 657 */ "tableElement ::= columnDefinition",
 /* 658 */ "tableElement ::= tableConstraintDefinition",
 /* 659 */ "columnDefinition ::= identifier dataType optionalDefaultClause optionalUsingOnUpdate optionalColumnConstraintList hint",
 /* 660 */ "columnDefinition ::= identifier dataType constClause optionalColumnConstraintList hint",
 /* 661 */ "columnDefinition ::= identifier dataType generatorClause optionalColumnConstraintList hint",
 /* 662 */ "dataType ::= collectionType",
 /* 663 */ "dataType ::= nonCollectionDataType",
 /* 664 */ "collectionType ::= nonCollectionDataType arraySpecification",
 /* 665 */ "arraySpecification ::= ARRAY optionalArrayCardinality",
 /* 666 */ "optionalArrayCardinality ::= LEFT_BRACKET length RIGHT_BRACKET",
 /* 667 */ "optionalArrayCardinality ::=",
 /* 668 */ "nonCollectionDataType ::= preDefinedType",
 /* 669 */ "preDefinedType ::= NVARCHAR LEFT_PARENTHESIS length RIGHT_PARENTHESIS",
 /* 670 */ "preDefinedType ::= VARCHAR LEFT_PARENTHESIS length RIGHT_PARENTHESIS",
 /* 671 */ "preDefinedType ::= NTEXT",
 /* 672 */ "preDefinedType ::= FULLTEXT",
 /* 673 */ "preDefinedType ::= INT",
 /* 674 */ "preDefinedType ::= BIGINT",
 /* 675 */ "preDefinedType ::= FLOAT",
 /* 676 */ "preDefinedType ::= DATETIME",
 /* 677 */ "preDefinedType ::= TIMESTAMP",
 /* 678 */ "preDefinedType ::= UNIQUEIDENTIFIER",
 /* 679 */ "preDefinedType ::= IMAGE",
 /* 680 */ "preDefinedType ::= LANGUAGE",
 /* 681 */ "preDefinedType ::= NCHAR LEFT_PARENTHESIS length RIGHT_PARENTHESIS",
 /* 682 */ "preDefinedType ::= CHAR LEFT_PARENTHESIS length RIGHT_PARENTHESIS",
 /* 683 */ "preDefinedType ::= BINARY LEFT_PARENTHESIS length RIGHT_PARENTHESIS",
 /* 684 */ "preDefinedType ::= BLOB",
 /* 685 */ "preDefinedType ::= NCLOB",
 /* 686 */ "preDefinedType ::= decimalTypeName optionalDecimalLength",
 /* 687 */ "decimalTypeName ::= DEC",
 /* 688 */ "decimalTypeName ::= DECIMAL",
 /* 689 */ "decimalTypeName ::= NUMERIC",
 /* 690 */ "optionalDecimalLength ::=",
 /* 691 */ "optionalDecimalLength ::= LEFT_PARENTHESIS length RIGHT_PARENTHESIS",
 /* 692 */ "optionalDecimalLength ::= LEFT_PARENTHESIS length COMMA length RIGHT_PARENTHESIS",
 /* 693 */ "length ::= unsignedIntegerLiteral",
 /* 694 */ "length ::= NO LIMIT",
 /* 695 */ "optionalColumnConstraintList ::=",
 /* 696 */ "optionalColumnConstraintList ::= columnConstraintList",
 /* 697 */ "columnConstraintList ::= columnConstraint",
 /* 698 */ "columnConstraintList ::= columnConstraintList columnConstraint",
 /* 699 */ "columnConstraint ::= NOT NULL",
 /* 700 */ "columnConstraint ::= PRIMARY KEY",
 /* 701 */ "columnConstraint ::= UNIQUE",
 /* 702 */ "optionalDefaultClause ::=",
 /* 703 */ "optionalDefaultClause ::= defaultClause",
 /* 704 */ "defaultClause ::= DEFAULT defaultOption",
 /* 705 */ "defaultClause ::= EQUALS defaultOption",
 /* 706 */ "defaultOption ::= nonPredicateValueExpression",
 /* 707 */ "optionalUsingOnUpdate ::=",
 /* 708 */ "optionalUsingOnUpdate ::= USING ON UPDATE",
 /* 709 */ "constClause ::= CONST constOption",
 /* 710 */ "constClause ::= CONSTANT constOption",
 /* 711 */ "constOption ::= literal",
 /* 712 */ "constOption ::= NULL",
 /* 713 */ "generatorClause ::= GENERATED generateAlways AS IDENTITY optionalGeneratorOptions",
 /* 714 */ "generateAlways ::= ALWAYS",
 /* 715 */ "generateAlways ::= BY DEFAULT",
 /* 716 */ "optionalGeneratorOptions ::=",
 /* 717 */ "optionalGeneratorOptions ::= LEFT_PARENTHESIS generatorOptions RIGHT_PARENTHESIS",
 /* 718 */ "generatorOptions ::= generatorOption",
 /* 719 */ "generatorOptions ::= generatorOptions generatorOption",
 /* 720 */ "generatorOption ::= START WITH generatorOptionValue",
 /* 721 */ "generatorOption ::= INCREMENT BY generatorOptionValue",
 /* 722 */ "generatorOption ::= MAXVALUE generatorOptionValue",
 /* 723 */ "generatorOption ::= NO MAXVALUE",
 /* 724 */ "generatorOption ::= MINVALUE generatorOptionValue",
 /* 725 */ "generatorOption ::= NO MINVALUE",
 /* 726 */ "generatorOption ::= CYCLE",
 /* 727 */ "generatorOption ::= NO CYCLE",
 /* 728 */ "generatorOption ::= GET MAX",
 /* 729 */ "generatorOptionValue ::= signedIntegerLiteral",
 /* 730 */ "tableConstraintDefinition ::= UNIQUE indexType LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS hint",
 /* 731 */ "tableConstraintDefinition ::= PRIMARY KEY indexType LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS hint",
 /* 732 */ "tableConstraintDefinition ::= FOREIGN KEY LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS REFERENCES tableName referencedColumnName hint",
 /* 733 */ "referencedColumnName ::=",
 /* 734 */ "referencedColumnName ::= LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS",
 /* 735 */ "hint ::= HINT hintElement",
 /* 736 */ "hint ::=",
 /* 737 */ "hintElement ::= hintPrimary",
 /* 738 */ "hintElement ::= hintElement hintPrimary",
 /* 739 */ "hintPrimary ::= literal",
 /* 740 */ "hintPrimary ::= LEFT_PARENTHESIS hintElementList RIGHT_PARENTHESIS",
 /* 741 */ "hintPrimary ::= TABLE",
 /* 742 */ "hintPrimary ::= COLUMN",
 /* 743 */ "hintPrimary ::= FILE",
 /* 744 */ "hintPrimary ::= INDEX",
 /* 745 */ "hintPrimary ::= TRIGGER",
 /* 746 */ "hintPrimary ::= HEAP",
 /* 747 */ "hintPrimary ::= NONTRUNCATE",
 /* 748 */ "hintPrimary ::= UNIQUE",
 /* 749 */ "hintPrimary ::= IN ORDER",
 /* 750 */ "hintElementList ::= hintElement",
 /* 751 */ "hintElementList ::= hintElementList COMMA hintElement",
 /* 752 */ "hintElementList ::= hintElementList COMMA",
 /* 753 */ "tableAreaOption ::= tableAreaClause",
 /* 754 */ "tableAreaOption ::=",
 /* 755 */ "dropTableStatement ::= DROP TABLE tableName optionalIfExists",
 /* 756 */ "optionalIfExists ::=",
 /* 757 */ "optionalIfExists ::= IF EXISTS",
 /* 758 */ "alterTableStatement ::= ALTER TABLE tableName alterTableAction",
 /* 759 */ "alterTableAction ::= setTableAreaClause",
 /* 760 */ "alterTableAction ::= dropTableAreaClause",
 /* 761 */ "alterTableAction ::= renameTableClause",
 /* 762 */ "alterTableAction ::= addColumnDefinition",
 /* 763 */ "alterTableAction ::= alterColumnDefinition",
 /* 764 */ "alterTableAction ::= addTableConstraintDefinition",
 /* 765 */ "setTableAreaClause ::= SET tableAreaClause",
 /* 766 */ "dropTableAreaClause ::= DROP tableAreaClause",
 /* 767 */ "tableAreaClause ::= AREA tblAreaOption",
 /* 768 */ "tblAreaOption ::= defArea heapArea indexArea ftsArea pycllogArea",
 /* 769 */ "defArea ::= areaName",
 /* 770 */ "defArea ::= DEFAULT",
 /* 771 */ "defArea ::=",
 /* 772 */ "heapArea ::= HEAP areaName",
 /* 773 */ "heapArea ::= HEAP",
 /* 774 */ "heapArea ::=",
 /* 775 */ "indexArea ::= INDEX areaName",
 /* 776 */ "indexArea ::= INDEX",
 /* 777 */ "indexArea ::=",
 /* 778 */ "ftsArea ::= FULLTEXT areaName",
 /* 779 */ "ftsArea ::= FULLTEXT",
 /* 780 */ "ftsArea ::=",
 /* 781 */ "pycllogArea ::= PHYSICALLOG areaName",
 /* 782 */ "pycllogArea ::= PHYSICALLOG",
 /* 783 */ "pycllogArea ::=",
 /* 784 */ "renameTableClause ::= RENAME TO identifier",
 /* 785 */ "renameTableClause ::= RENAME asCorrelationName",
 /* 786 */ "addColumnDefinition ::= ADD addColumnDefinitionBody",
 /* 787 */ "addColumnDefinition ::= ADD COLUMN addColumnDefinitionBody",
 /* 788 */ "addColumnDefinitionBody ::= columnDefinition",
 /* 789 */ "addColumnDefinitionBody ::= addColumnDefinitionBody COMMA columnDefinition",
 /* 790 */ "addColumnDefinitionBody ::= addColumnDefinitionBody COMMA",
 /* 791 */ "alterColumnDefinition ::= ALTER alterColumnAction",
 /* 792 */ "alterColumnDefinition ::= ALTER COLUMN alterColumnAction",
 /* 793 */ "alterColumnAction ::= columnDefinition",
 /* 794 */ "addTableConstraintDefinition ::= ADD tableConstraintDefinition",
 /* 795 */ "indexDefinition ::= CREATE indexType INDEX identifier ON tableName LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS languageColumnOption scoreColumnOption hint indexAreaOption",
 /* 796 */ "indexType ::= CLUSTERED",
 /* 797 */ "indexType ::= NONCLUSTERED",
 /* 798 */ "indexType ::= FULLTEXT",
 /* 799 */ "indexType ::= BITMAP",
 /* 800 */ "indexType ::= ARRAY",
 /* 801 */ "indexType ::= UNIQUE",
 /* 802 */ "indexType ::= ALL ROWS",
 /* 803 */ "indexType ::= KDTREE",
 /* 804 */ "indexType ::=",
 /* 805 */ "languageColumnOption ::= LANGUAGE COLUMN columnName",
 /* 806 */ "languageColumnOption ::=",
 /* 807 */ "scoreColumnOption ::= SCORE COLUMN columnName",
 /* 808 */ "scoreColumnOption ::=",
 /* 809 */ "indexAreaOption ::= indexAreaClause",
 /* 810 */ "indexAreaOption ::=",
 /* 811 */ "dropIndexStatement ::= DROP INDEX identifier optionalIfExists",
 /* 812 */ "alterIndexStatement ::= ALTER INDEX identifier alterIndexAction",
 /* 813 */ "alterIndexAction ::= setIndexAreaClause",
 /* 814 */ "alterIndexAction ::= dropIndexAreaClause",
 /* 815 */ "alterIndexAction ::= renameIndexClause",
 /* 816 */ "alterIndexAction ::= offlineIndexClause",
 /* 817 */ "setIndexAreaClause ::= SET indexAreaClause",
 /* 818 */ "dropIndexAreaClause ::= DROP indexAreaClause",
 /* 819 */ "indexAreaClause ::= AREA idxAreaOption",
 /* 820 */ "idxAreaOption ::= defArea pycllogArea hintArea",
 /* 821 */ "hintArea ::= HINT AREA characterStringLiteral",
 /* 822 */ "hintArea ::=",
 /* 823 */ "renameIndexClause ::= RENAME TO identifier",
 /* 824 */ "renameIndexClause ::= RENAME asCorrelationName",
 /* 825 */ "offlineIndexClause ::= ONLINE",
 /* 826 */ "offlineIndexClause ::= OFFLINE",
 /* 827 */ "areaDefinition ::= CREATE AREA areaName areaPath",
 /* 828 */ "areaName ::= identifier",
 /* 829 */ "areaPath ::= areaPathElement",
 /* 830 */ "areaPath ::= areaPathArray",
 /* 831 */ "areaPathElement ::= characterStringLiteral",
 /* 832 */ "areaPathArray ::= ARRAY LEFT_BRACKET areaArrayElement RIGHT_BRACKET",
 /* 833 */ "areaArrayElement ::= areaPathElement",
 /* 834 */ "areaArrayElement ::= areaArrayElement COMMA areaPathElement",
 /* 835 */ "areaArrayElement ::= areaArrayElement COMMA",
 /* 836 */ "dropAreaStatement ::= DROP AREA areaName optionalIfExists",
 /* 837 */ "alterAreaStatement ::= ALTER AREA identifier alterAreaAction",
 /* 838 */ "alterAreaAction ::= modifyAreaDefinition",
 /* 839 */ "modifyAreaDefinition ::= MODIFY singleModifyAreaClause",
 /* 840 */ "modifyAreaDefinition ::= MODIFY arrayFullModifyAreaClause",
 /* 841 */ "modifyAreaDefinition ::= MODIFY arrayElementModifyAreaClause",
 /* 842 */ "singleModifyAreaClause ::= areaPathElement",
 /* 843 */ "arrayFullModifyAreaClause ::= areaPathArray",
 /* 844 */ "arrayElementModifyAreaClause ::= newAreaSpecifiedPathElement",
 /* 845 */ "newAreaSpecifiedPathElement ::= LEFT_BRACKET length RIGHT_BRACKET areaPathElement",
 /* 846 */ "unmountDatabaseStatement ::= UNMOUNT dbName",
 /* 847 */ "mountDatabaseStatement ::= MOUNT dbName databaseMountOptionList optionalAreaParameter USING SNAPSHOT WITH RECOVERY",
 /* 848 */ "mountDatabaseStatement ::= MOUNT dbName databaseMountOptionList optionalAreaParameter USING SNAPSHOT",
 /* 849 */ "mountDatabaseStatement ::= MOUNT dbName databaseMountOptionList optionalAreaParameter WITH DISCARD LOGICALLOG",
 /* 850 */ "mountDatabaseStatement ::= MOUNT dbName databaseMountOptionList optionalAreaParameter WITH RECOVERY",
 /* 851 */ "mountDatabaseStatement ::= MOUNT dbName databaseMountOptionList optionalAreaParameter",
 /* 852 */ "mountDatabaseStatement ::= MOUNT dbName databaseMountOptionList optionalAreaParameter AS SLAVE FROM MASTER characterStringLiteral",
 /* 853 */ "databaseMountOptionList ::= databaseCreateOptionList",
 /* 854 */ "optionalAreaParameter ::= optionalAreaParameterList",
 /* 855 */ "optionalAreaParameter ::= DROP ALL AREA",
 /* 856 */ "optionalAreaParameter ::=",
 /* 857 */ "optionalAreaParameterList ::= alterAreaStatement",
 /* 858 */ "optionalAreaParameterList ::= dropAreaStatement",
 /* 859 */ "optionalAreaParameterList ::= optionalAreaParameterList alterAreaStatement",
 /* 860 */ "optionalAreaParameterList ::= optionalAreaParameterList dropAreaStatement",
 /* 861 */ "startBackupStatement ::= START BACKUP backupType versionType",
 /* 862 */ "backupType ::= FULL",
 /* 863 */ "backupType ::= MASTER",
 /* 864 */ "backupType ::= LOGICALLOG",
 /* 865 */ "backupType ::=",
 /* 866 */ "versionType ::= DISCARD SNAPSHOT",
 /* 867 */ "versionType ::=",
 /* 868 */ "endBackupStatement ::= END BACKUP WITH DISCARD LOGICALLOG",
 /* 869 */ "endBackupStatement ::= END BACKUP",
 /* 870 */ "verifyStatement ::= VERIFY verifySchemaType identifier",
 /* 871 */ "verifyStatement ::= VERIFY verifySchemaType identifier optionList",
 /* 872 */ "verifySchemaType ::= DATABASE",
 /* 873 */ "verifySchemaType ::= TABLE",
 /* 874 */ "verifySchemaType ::= INDEX",
 /* 875 */ "optionList ::= verifyOption",
 /* 876 */ "optionList ::= optionList verifyOption",
 /* 877 */ "verifyOption ::= CORRECT",
 /* 878 */ "verifyOption ::= CONTINUE",
 /* 879 */ "verifyOption ::= CASCADE",
 /* 880 */ "verifyOption ::= VERBOSE",
 /* 881 */ "verifyOption ::= VALUE",
 /* 882 */ "syncStatement ::= SYNC",
 /* 883 */ "syncStatement ::= SYNC unsignedIntegerLiteral",
 /* 884 */ "disconnectStatement ::= DISCONNECT SESSION unsignedIntegerLiteral OF CONNECTION unsignedIntegerLiteral",
 /* 885 */ "disconnectStatement ::= DISCONNECT CONNECTION unsignedIntegerLiteral",
 /* 886 */ "declareStatement ::= DECLARE variableName BITMAP",
 /* 887 */ "checkpointStatement ::= CHECKPOINT",
 /* 888 */ "checkpointStatement ::= CHECKPOINT unsignedIntegerLiteral",
 /* 889 */ "grantStatement ::= GRANT roles TO granteeList",
 /* 890 */ "roles ::= identifier",
 /* 891 */ "roles ::= roles COMMA identifier",
 /* 892 */ "granteeList ::= identifier",
 /* 893 */ "granteeList ::= granteeList COMMA identifier",
 /* 894 */ "revokeStatement ::= REVOKE roles FROM granteeList",
 /* 895 */ "explainStatement ::= EXPLAIN explainOption sqlStatement",
 /* 896 */ "explainOption ::= hint",
 /* 897 */ "explainOption ::= explainOptionValueList hint",
 /* 898 */ "explainOptionValueList ::= explainOptionValue",
 /* 899 */ "explainOptionValueList ::= explainOptionValueList explainOptionValue",
 /* 900 */ "explainOptionValue ::= EXECUTE",
 /* 901 */ "explainOptionValue ::= NO EXECUTE",
 /* 902 */ "startExplainStatement ::= START EXPLAIN explainOption",
 /* 903 */ "endExplainStatement ::= END EXPLAIN",
 /* 904 */ "cascadeDefinition ::= CREATE CASCADE cascadeName ON hostName portNumber optionalIdentifier",
 /* 905 */ "optionalIdentifier ::=",
 /* 906 */ "optionalIdentifier ::= identifier",
 /* 907 */ "alterCascadeStatement ::= ALTER CASCADE cascadeName TO hostName portNumber optionalIdentifier",
 /* 908 */ "dropCascadeStatement ::= DROP CASCADE cascadeName optionalIfExists",
 /* 909 */ "cascadeName ::= identifier",
 /* 910 */ "hostName ::= stringValueSpecification",
 /* 911 */ "portNumber ::= numericValueSpecification",
 /* 912 */ "partitionDefinition ::= CREATE optionalPartitionCategory PARTITION ON tableName BY functionName LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS",
 /* 913 */ "optionalPartitionCategory ::=",
 /* 914 */ "optionalPartitionCategory ::= READ ONLY",
 /* 915 */ "alterPartitionStatement ::= ALTER PARTITION ON tableName TO functionName LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS",
 /* 916 */ "dropPartitionStatement ::= DROP PARTITION ON tableName optionalIfExists",
 /* 917 */ "functionDefinition ::= CREATE FUNCTION functionName parameterSpecification returnsClause routineBody",
 /* 918 */ "dropFunctionStatement ::= DROP FUNCTION functionName optionalIfExists",
 /* 919 */ "functionName ::= identifier",
 /* 920 */ "parameterSpecification ::= LEFT_PARENTHESIS parameterDeclarationList RIGHT_PARENTHESIS",
 /* 921 */ "parameterDeclarationList ::= parameterDeclaration",
 /* 922 */ "parameterDeclarationList ::= parameterDeclarationList COMMA parameterDeclaration",
 /* 923 */ "parameterDeclaration ::= parameterName parameterType",
 /* 924 */ "parameterName ::= identifier",
 /* 925 */ "parameterType ::= dataType",
 /* 926 */ "returnsClause ::= RETURNS returnsDataType",
 /* 927 */ "returnsDataType ::= dataType",
 /* 928 */ "routineBody ::= routineStatement",
 /* 929 */ "routineStatement ::= returnStatement",
 /* 930 */ "returnStatement ::= RETURN nonPredicateValueExpression",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to SQLParserEngine and SQLParserEngineFree.
*/
void *SQLParserEngineAlloc(void *(*mallocProc)(ModSize n, const char* file, int line)){
  yyParser *pParser;
  /******************************************
   * RICOH modification: add file and line  */
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser), __FILE__, __LINE__ );
  /******************************************/
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  SQLParserEngineARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
      /* TERMINAL Destructor */
    case 1: /* SEMICOLON */
    case 2: /* UNION */
    case 3: /* EXCEPT */
    case 4: /* INTERSECT */
    case 5: /* JOIN */
    case 6: /* INNER */
    case 7: /* LEFT */
    case 8: /* RIGHT */
    case 9: /* FULL */
    case 10: /* NATURAL */
    case 11: /* CROSS */
    case 12: /* ON */
    case 13: /* COMMA */
    case 14: /* OR */
    case 15: /* AND */
    case 16: /* NOT */
    case 17: /* BETWEEN */
    case 18: /* IN */
    case 19: /* EQUALS */
    case 20: /* NOT_EQUALS */
    case 21: /* LESS_THAN */
    case 22: /* GREATER_THAN */
    case 23: /* LESS_THAN_OR_EQUALS */
    case 24: /* GREATER_THAN_OR_EQUALS */
    case 25: /* IS */
    case 26: /* LIKE */
    case 27: /* CONTAINS */
    case 28: /* ESCAPE */
    case 29: /* LANGUAGE */
    case 30: /* CALCULATOR */
    case 31: /* SIMILAR */
    case 32: /* COMBINER */
    case 33: /* USING */
    case 34: /* VERTICALLINE */
    case 35: /* CONTAINS_MINUS */
    case 36: /* AMPERSAND */
    case 37: /* PLUS */
    case 38: /* MINUS */
    case 39: /* STRING_CONCAT */
    case 40: /* ASTERISK */
    case 41: /* SOLIDUS */
    case 42: /* UNARY_MINUS */
    case 43: /* STRING */
    case 44: /* STRING_WITH_QUOTE */
    case 45: /* BINARY_STRING */
    case 46: /* INTEGER_LITERAL */
    case 47: /* FLOAT_LITERAL */
    case 48: /* DATE */
    case 49: /* TIMESTAMP */
    case 50: /* IDENTIFIER */
    case 51: /* IDENTIFIER_WITH_QUOTE */
    case 52: /* NULL */
    case 53: /* DEFAULT */
    case 54: /* QUESTION_MARK */
    case 55: /* USER */
    case 56: /* CURRENT_USER */
    case 57: /* SESSION_USER */
    case 58: /* CURRENT_PATH */
    case 59: /* PERIOD */
    case 60: /* LEFT_BRACKET */
    case 61: /* RIGHT_BRACKET */
    case 62: /* ALL */
    case 63: /* DISTINCT */
    case 64: /* CORRESPONDING */
    case 65: /* BY */
    case 66: /* LEFT_PARENTHESIS */
    case 67: /* RIGHT_PARENTHESIS */
    case 68: /* SELECT */
    case 69: /* INTO */
    case 70: /* AS */
    case 71: /* OUTPUT */
    case 72: /* TO */
    case 73: /* PATH */
    case 74: /* WITH */
    case 75: /* HINT */
    case 76: /* FROM */
    case 77: /* INPUT */
    case 78: /* FOR */
    case 79: /* OUTER */
    case 80: /* EXISTS */
    case 81: /* UNNEST */
    case 82: /* WHERE */
    case 83: /* GROUP */
    case 84: /* HAVING */
    case 85: /* ORDER */
    case 86: /* ASC */
    case 87: /* DESC */
    case 88: /* PARTITION */
    case 89: /* OFFSET */
    case 90: /* LIMIT */
    case 91: /* SCALE */
    case 92: /* PARAMETER */
    case 93: /* WORD */
    case 94: /* WORDLIST */
    case 95: /* FREETEXT */
    case 96: /* CATEGORY */
    case 97: /* WEIGHT */
    case 98: /* SYNONYM */
    case 99: /* EXPAND_SYNONYM */
    case 100: /* HEAD */
    case 101: /* TAIL */
    case 102: /* WITHIN */
    case 103: /* SYMMETRIC */
    case 104: /* ASYMMETRIC */
    case 105: /* EXACTWORD */
    case 106: /* SIMPLEWORD */
    case 107: /* CONTAINS_STRING */
    case 108: /* WORDHEAD */
    case 109: /* WORDTAIL */
    case 110: /* UPPER */
    case 111: /* LOWER */
    case 112: /* AVERAGE */
    case 113: /* LENGTH */
    case 114: /* FULLTEXT */
    case 115: /* DF */
    case 116: /* SCORE */
    case 117: /* FUNCTION */
    case 118: /* EXPAND */
    case 119: /* RANK */
    case 120: /* EXTRACTOR */
    case 121: /* CLUSTERED */
    case 122: /* SUBSTRING */
    case 123: /* OF */
    case 124: /* OVERLAY */
    case 125: /* PLACING */
    case 126: /* NORMALIZE */
    case 127: /* KWIC */
    case 128: /* ENCLOSE */
    case 129: /* ELLIPSIS */
    case 130: /* ABS */
    case 131: /* MOD */
    case 132: /* GET */
    case 133: /* MAX */
    case 134: /* COUNT */
    case 135: /* AVG */
    case 136: /* SUM */
    case 137: /* CURRENT_DATE */
    case 138: /* CURRENT_TIMESTAMP */
    case 139: /* CASE */
    case 140: /* END */
    case 141: /* WHEN */
    case 142: /* THEN */
    case 143: /* ELSE */
    case 144: /* MIN */
    case 145: /* SECTIONIZED */
    case 146: /* ARRAY */
    case 147: /* ROW */
    case 148: /* VALUES */
    case 149: /* TABLE */
    case 150: /* DELETE */
    case 151: /* INSERT */
    case 152: /* UPDATE */
    case 153: /* SET */
    case 154: /* START */
    case 155: /* TRANSACTION */
    case 156: /* READ */
    case 157: /* ONLY */
    case 158: /* WRITE */
    case 159: /* ISOLATION */
    case 160: /* LEVEL */
    case 161: /* UNCOMMITTED */
    case 162: /* COMMITTED */
    case 163: /* REPEATABLE */
    case 164: /* SERIALIZABLE */
    case 165: /* SNAPSHOT */
    case 166: /* COMMIT */
    case 167: /* WORK */
    case 168: /* ROLLBACK */
    case 169: /* XA */
    case 170: /* RESUME */
    case 171: /* SUSPEND */
    case 172: /* MIGRATE */
    case 173: /* PREPARE */
    case 174: /* ONE */
    case 175: /* PHASE */
    case 176: /* RECOVER */
    case 177: /* FORGET */
    case 178: /* CREATE */
    case 179: /* DATABASE */
    case 180: /* LOGICALLOG */
    case 181: /* SYSTEM */
    case 182: /* ONLINE */
    case 183: /* OFFLINE */
    case 184: /* DISCARD */
    case 185: /* RECOVERY */
    case 186: /* CHECKPOINT */
    case 187: /* DROP */
    case 188: /* ALTER */
    case 189: /* SLAVE */
    case 190: /* STOP */
    case 191: /* MASTER */
    case 192: /* GLOBAL */
    case 193: /* TEMPORARY */
    case 194: /* LOCAL */
    case 195: /* CONSTANT */
    case 196: /* UPDATABLE */
    case 197: /* NVARCHAR */
    case 198: /* VARCHAR */
    case 199: /* NTEXT */
    case 200: /* INT */
    case 201: /* BIGINT */
    case 202: /* FLOAT */
    case 203: /* DATETIME */
    case 204: /* UNIQUEIDENTIFIER */
    case 205: /* IMAGE */
    case 206: /* NCHAR */
    case 207: /* CHAR */
    case 208: /* BINARY */
    case 209: /* BLOB */
    case 210: /* NCLOB */
    case 211: /* DEC */
    case 212: /* DECIMAL */
    case 213: /* NUMERIC */
    case 214: /* NO */
    case 215: /* PRIMARY */
    case 216: /* KEY */
    case 217: /* UNIQUE */
    case 218: /* CONST */
    case 219: /* GENERATED */
    case 220: /* IDENTITY */
    case 221: /* ALWAYS */
    case 222: /* INCREMENT */
    case 223: /* MAXVALUE */
    case 224: /* MINVALUE */
    case 225: /* CYCLE */
    case 226: /* FOREIGN */
    case 227: /* REFERENCES */
    case 228: /* COLUMN */
    case 229: /* FILE */
    case 230: /* INDEX */
    case 231: /* TRIGGER */
    case 232: /* HEAP */
    case 233: /* NONTRUNCATE */
    case 234: /* IF */
    case 235: /* AREA */
    case 236: /* PHYSICALLOG */
    case 237: /* RENAME */
    case 238: /* ADD */
    case 239: /* NONCLUSTERED */
    case 240: /* BITMAP */
    case 241: /* ROWS */
    case 242: /* KDTREE */
    case 243: /* MODIFY */
    case 244: /* UNMOUNT */
    case 245: /* MOUNT */
    case 246: /* BACKUP */
    case 247: /* VERIFY */
    case 248: /* CORRECT */
    case 249: /* CONTINUE */
    case 250: /* CASCADE */
    case 251: /* VERBOSE */
    case 252: /* VALUE */
    case 253: /* SYNC */
    case 254: /* DISCONNECT */
    case 255: /* SESSION */
    case 256: /* CONNECTION */
    case 257: /* DECLARE */
    case 258: /* GRANT */
    case 259: /* REVOKE */
    case 260: /* EXPLAIN */
    case 261: /* EXECUTE */
    case 262: /* RETURNS */
    case 263: /* RETURN */
{
#line 114 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy0); 
#line 5886 "../LemonSrc/SQLParserL.c"
}
      break;
    case 265: /* start */
    case 266: /* sqlStatementList */
    case 526: /* delete */
    case 528: /* insert */
{
#line 144 "../LemonSrc/SQLParserL.lemon"
 
#line 5896 "../LemonSrc/SQLParserL.c"
}
      break;
    case 267: /* sqlStatement */
    case 282: /* alterDatabaseStatement */
    case 349: /* queryTerm */
    case 357: /* queryPrimary */
    case 358: /* nonJoinQueryPrimary */
    case 359: /* simpleTable */
    case 362: /* explicitTable */
    case 384: /* tableReference */
    case 386: /* joinedTable */
    case 396: /* crossJoin */
    case 401: /* joinSpecification */
    case 407: /* groupingElement */
    case 536: /* transactMode */
    case 564: /* tableElement */
    case 595: /* hintPrimary */
    case 613: /* alterColumnAction */
    case 662: /* routineStatement */
{
#line 167 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy934); 
#line 5919 "../LemonSrc/SQLParserL.c"
}
      break;
    case 268: /* queryExpression */
    case 345: /* queryExpressionBody */
    case 388: /* derivedTable */
    case 393: /* tableSubquery */
    case 394: /* subquery */
    case 427: /* inPredicateSubquery */
    case 448: /* rankFrom */
    case 530: /* bulkInput */
{
#line 695 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy533); 
#line 5933 "../LemonSrc/SQLParserL.c"
}
      break;
    case 269: /* deleteStatement */
{
#line 3709 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy171); 
#line 5940 "../LemonSrc/SQLParserL.c"
}
      break;
    case 270: /* insertStatement */
{
#line 3740 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy13); 
#line 5947 "../LemonSrc/SQLParserL.c"
}
      break;
    case 271: /* updateStatement */
{
#line 3804 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy351); 
#line 5954 "../LemonSrc/SQLParserL.c"
}
      break;
    case 272: /* tableDefinition */
{
#line 4505 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1000); 
#line 5961 "../LemonSrc/SQLParserL.c"
}
      break;
    case 273: /* indexDefinition */
{
#line 5411 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy456); 
#line 5968 "../LemonSrc/SQLParserL.c"
}
      break;
    case 274: /* dropIndexStatement */
{
#line 5488 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy745); 
#line 5975 "../LemonSrc/SQLParserL.c"
}
      break;
    case 275: /* dropTableStatement */
{
#line 5163 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy41); 
#line 5982 "../LemonSrc/SQLParserL.c"
}
      break;
    case 276: /* areaDefinition */
{
#line 5625 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy857); 
#line 5989 "../LemonSrc/SQLParserL.c"
}
      break;
    case 277: /* dropAreaStatement */
{
#line 5692 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy706); 
#line 5996 "../LemonSrc/SQLParserL.c"
}
      break;
    case 278: /* databaseDefinition */
{
#line 4212 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy809); 
#line 6003 "../LemonSrc/SQLParserL.c"
}
      break;
    case 279: /* dropDatabaseStatement */
{
#line 4389 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1074); 
#line 6010 "../LemonSrc/SQLParserL.c"
}
      break;
    case 280: /* alterTableStatement */
{
#line 5183 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy568); 
#line 6017 "../LemonSrc/SQLParserL.c"
}
      break;
    case 281: /* alterIndexStatement */
{
#line 5499 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1192); 
#line 6024 "../LemonSrc/SQLParserL.c"
}
      break;
    case 283: /* alterAreaStatement */
{
#line 5703 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy37); 
#line 6031 "../LemonSrc/SQLParserL.c"
}
      break;
    case 284: /* cascadeDefinition */
{
#line 6237 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy720); 
#line 6038 "../LemonSrc/SQLParserL.c"
}
      break;
    case 285: /* partitionDefinition */
{
#line 6312 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy726); 
#line 6045 "../LemonSrc/SQLParserL.c"
}
      break;
    case 286: /* functionDefinition */
{
#line 6357 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy862); 
#line 6052 "../LemonSrc/SQLParserL.c"
}
      break;
    case 287: /* alterCascadeStatement */
{
#line 6260 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy496); 
#line 6059 "../LemonSrc/SQLParserL.c"
}
      break;
    case 288: /* alterPartitionStatement */
{
#line 6335 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1246); 
#line 6066 "../LemonSrc/SQLParserL.c"
}
      break;
    case 289: /* dropCascadeStatement */
{
#line 6271 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1161); 
#line 6073 "../LemonSrc/SQLParserL.c"
}
      break;
    case 290: /* dropPartitionStatement */
{
#line 6346 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1071); 
#line 6080 "../LemonSrc/SQLParserL.c"
}
      break;
    case 291: /* dropFunctionStatement */
{
#line 6372 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy371); 
#line 6087 "../LemonSrc/SQLParserL.c"
}
      break;
    case 292: /* startTransactionStatement */
{
#line 3872 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy516); 
#line 6094 "../LemonSrc/SQLParserL.c"
}
      break;
    case 293: /* setTransactionStatement */
{
#line 3968 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy918); 
#line 6101 "../LemonSrc/SQLParserL.c"
}
      break;
    case 294: /* commitStatement */
{
#line 3980 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1197); 
#line 6108 "../LemonSrc/SQLParserL.c"
}
      break;
    case 295: /* rollbackStatement */
{
#line 3995 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy110); 
#line 6115 "../LemonSrc/SQLParserL.c"
}
      break;
    case 296: /* unmountDatabaseStatement */
{
#line 5792 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1043); 
#line 6122 "../LemonSrc/SQLParserL.c"
}
      break;
    case 297: /* mountDatabaseStatement */
{
#line 5803 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy936); 
#line 6129 "../LemonSrc/SQLParserL.c"
}
      break;
    case 298: /* startBackupStatement */
{
#line 5928 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1108); 
#line 6136 "../LemonSrc/SQLParserL.c"
}
      break;
    case 299: /* endBackupStatement */
{
#line 5961 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy861); 
#line 6143 "../LemonSrc/SQLParserL.c"
}
      break;
    case 300: /* verifyStatement */
{
#line 5976 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy133); 
#line 6150 "../LemonSrc/SQLParserL.c"
}
      break;
    case 301: /* syncStatement */
{
#line 6041 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1057); 
#line 6157 "../LemonSrc/SQLParserL.c"
}
      break;
    case 302: /* checkpointStatement */
{
#line 6100 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1248); 
#line 6164 "../LemonSrc/SQLParserL.c"
}
      break;
    case 303: /* disconnectStatement */
{
#line 6060 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy822); 
#line 6171 "../LemonSrc/SQLParserL.c"
}
      break;
    case 304: /* declareStatement */
{
#line 6087 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy124); 
#line 6178 "../LemonSrc/SQLParserL.c"
}
      break;
    case 305: /* xa_StartStatement */
{
#line 4069 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy882); 
#line 6185 "../LemonSrc/SQLParserL.c"
}
      break;
    case 306: /* xa_EndStatement */
{
#line 4112 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy931); 
#line 6192 "../LemonSrc/SQLParserL.c"
}
      break;
    case 307: /* xa_PrepareStatement */
{
#line 4141 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy563); 
#line 6199 "../LemonSrc/SQLParserL.c"
}
      break;
    case 308: /* xa_CommitStatement */
{
#line 4154 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy777); 
#line 6206 "../LemonSrc/SQLParserL.c"
}
      break;
    case 309: /* xa_RollbackStatement */
{
#line 4175 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy938); 
#line 6213 "../LemonSrc/SQLParserL.c"
}
      break;
    case 310: /* xa_RecoverStatement */
{
#line 4188 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy134); 
#line 6220 "../LemonSrc/SQLParserL.c"
}
      break;
    case 311: /* xa_ForgetStatement */
{
#line 4198 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy367); 
#line 6227 "../LemonSrc/SQLParserL.c"
}
      break;
    case 312: /* grantStatement */
{
#line 6119 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1276); 
#line 6234 "../LemonSrc/SQLParserL.c"
}
      break;
    case 313: /* revokeStatement */
{
#line 6160 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1256); 
#line 6241 "../LemonSrc/SQLParserL.c"
}
      break;
    case 314: /* explainStatement */
{
#line 6171 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1045); 
#line 6248 "../LemonSrc/SQLParserL.c"
}
      break;
    case 315: /* startExplainStatement */
{
#line 6215 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy555); 
#line 6255 "../LemonSrc/SQLParserL.c"
}
      break;
    case 316: /* endExplainStatement */
{
#line 6226 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy232); 
#line 6262 "../LemonSrc/SQLParserL.c"
}
      break;
    case 317: /* literal */
    case 318: /* numericLiteral */
    case 319: /* stringLiteral */
    case 320: /* datetimeLiteral */
    case 321: /* characterStringLiteral */
    case 322: /* binaryStringLiteral */
    case 323: /* exactNumericLiteral */
    case 324: /* approximateNumericLiteral */
    case 325: /* unsignedIntegerLiteral */
    case 326: /* floatLiteral */
    case 327: /* dateLiteral */
    case 328: /* timestampLiteral */
    case 376: /* pathName */
    case 542: /* signedIntegerLiteral */
    case 591: /* generatorOptionValue */
{
#line 332 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1200); 
#line 6283 "../LemonSrc/SQLParserL.c"
}
      break;
    case 329: /* tableName */
    case 330: /* identifier */
    case 342: /* itemQualifier */
    case 390: /* asCorrelationName */
    case 527: /* targetTable */
    case 556: /* dbName */
    case 606: /* defArea */
    case 607: /* heapArea */
    case 608: /* indexArea */
    case 609: /* ftsArea */
    case 610: /* pycllogArea */
    case 611: /* areaName */
    case 648: /* cascadeName */
    case 651: /* optionalIdentifier */
    case 653: /* functionName */
    case 659: /* parameterName */
{
#line 479 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1118); 
#line 6305 "../LemonSrc/SQLParserL.c"
}
      break;
    case 331: /* columnName */
    case 533: /* updateTarget */
    case 614: /* languageColumnOption */
    case 615: /* scoreColumnOption */
{
#line 489 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy370); 
#line 6315 "../LemonSrc/SQLParserL.c"
}
      break;
    case 332: /* variableName */
{
#line 499 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy278); 
#line 6322 "../LemonSrc/SQLParserL.c"
}
      break;
    case 333: /* valueSpecification */
    case 334: /* numericValueSpecification */
    case 335: /* stringValueSpecification */
    case 336: /* datetimeValueSpecification */
    case 337: /* noTypeValueSpecification */
    case 338: /* placeHolder */
    case 339: /* generalValueSpecification */
    case 340: /* elementReference */
    case 344: /* anyElementReference */
    case 361: /* tableValueConstructor */
    case 371: /* nonPredicateValueExpression */
    case 373: /* inputData */
    case 374: /* optionalWithClause */
    case 375: /* optionalBulkHint */
    case 377: /* withClause */
    case 378: /* bulkHint */
    case 380: /* optionalWhereClause */
    case 389: /* collectionDerivedTable */
    case 395: /* rowSubquery */
    case 402: /* searchCondition */
    case 403: /* whereClause */
    case 404: /* booleanValueExpression */
    case 412: /* optionalPartitionBy */
    case 415: /* limitSpecification */
    case 416: /* numericValueOperand */
    case 417: /* predicateValueExpression */
    case 418: /* comparisonPredicate */
    case 419: /* betweenPredicate */
    case 420: /* inPredicate */
    case 421: /* likePredicate */
    case 422: /* containsPredicate */
    case 423: /* isNullPredicate */
    case 424: /* existsPredicate */
    case 425: /* similarPredicate */
    case 426: /* isSubstringOfPredicate */
    case 428: /* inPredicateValue */
    case 430: /* stringValueOperand */
    case 431: /* optionalLanguage */
    case 432: /* escape */
    case 433: /* language */
    case 434: /* scaleParameter */
    case 435: /* wordLimit */
    case 438: /* calculator */
    case 439: /* combiner */
    case 440: /* averageLength */
    case 441: /* df */
    case 442: /* scoreFunction */
    case 444: /* extractor */
    case 445: /* clusteredLimit */
    case 446: /* scoreCombiner */
    case 447: /* clusteredCombiner */
    case 454: /* optionalCategory */
    case 455: /* scale */
    case 456: /* category */
    case 457: /* optionalDf */
    case 458: /* optionalScale */
    case 462: /* optionalLowerDist */
    case 463: /* upperDist */
    case 465: /* lowerDist */
    case 466: /* rowValueExpression */
    case 467: /* stringValueExpression */
    case 468: /* stringRowValueExpression */
    case 469: /* stringValueExpressionPrimary */
    case 470: /* stringValueFunction */
    case 471: /* stringConcatenation */
    case 472: /* stringOrArrayValueOperand */
    case 473: /* singleElementFulltextOperand */
    case 474: /* kwicNumericOption */
    case 475: /* optionalKwicStartTag */
    case 476: /* optionalKwicEndTag */
    case 477: /* optionalKwicEscape */
    case 478: /* optionalKwicEllipsis */
    case 479: /* kwicStringOption */
    case 480: /* generalValueExpression */
    case 483: /* numericValueExpression */
    case 484: /* numericRowValueExpression */
    case 485: /* numericValueExpressionPrimary */
    case 486: /* numericValueFunction */
    case 487: /* arithmeticOperation */
    case 488: /* numericValueSetFunction */
    case 489: /* score */
    case 491: /* datetimeValueExpression */
    case 492: /* datetimeRowValueExpression */
    case 493: /* datetimeValueExpressionPrimary */
    case 494: /* datetimeValueFunction */
    case 495: /* generalRowValueExpression */
    case 496: /* generalValueExpressionPrimary */
    case 497: /* generalFunction0Arg */
    case 498: /* generalFunctionNArgs */
    case 499: /* caseExpression */
    case 500: /* generalSetFunction */
    case 502: /* caseSimpleCase */
    case 503: /* caseSearchedCase */
    case 504: /* caseOperand */
    case 506: /* optionalElseClause */
    case 508: /* simpleWhenClause */
    case 510: /* searchedWhenClause */
    case 516: /* arrayStringFunction */
    case 518: /* expandStringFunction */
    case 520: /* nonPredicateValueExpressionPrimary */
    case 521: /* rowValueConstructor */
    case 522: /* rowRowValueExpression */
    case 523: /* rowValueExpressionPrimary */
    case 524: /* multiElementRowValueConstructor */
    case 525: /* rowValueConstructorElement */
    case 568: /* optionalDefaultClause */
    case 572: /* generatorClause */
    case 583: /* defaultClause */
    case 584: /* defaultOption */
    case 586: /* constOption */
    case 590: /* generatorOption */
    case 649: /* hostName */
    case 650: /* portNumber */
{
#line 526 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1172); 
#line 6441 "../LemonSrc/SQLParserL.c"
}
      break;
    case 341: /* itemReference */
{
#line 639 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy85); 
#line 6448 "../LemonSrc/SQLParserL.c"
}
      break;
    case 343: /* arrayValueOperand */
    case 481: /* arrayRowValueExpression */
    case 482: /* arrayValueExpressionPrimary */
    case 514: /* arrayValueExpression */
    case 515: /* arrayValueConstructor */
    case 519: /* arrayElement */
{
#line 3540 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy584); 
#line 6460 "../LemonSrc/SQLParserL.c"
}
      break;
    case 346: /* optionalSortSpecificationList */
    case 411: /* sortSpecificationList */
{
#line 1530 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy640); 
#line 6468 "../LemonSrc/SQLParserL.c"
}
      break;
    case 347: /* optionalLimitSpecification */
{
#line 1589 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy579); 
#line 6475 "../LemonSrc/SQLParserL.c"
}
      break;
    case 348: /* hint */
    case 624: /* hintArea */
{
#line 5066 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy858); 
#line 6483 "../LemonSrc/SQLParserL.c"
}
      break;
    case 350: /* queryOperator */
{
#line 732 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1313); 
#line 6490 "../LemonSrc/SQLParserL.c"
}
      break;
    case 352: /* optionalCorrespondingSpec */
    case 353: /* correspondingSpec */
    case 354: /* optionalByCorrespondingColumnList */
    case 355: /* correspondingColumnList */
    case 356: /* columnNameList */
    case 391: /* optionalDerivedColumnList */
    case 392: /* derivedColumnList */
    case 534: /* updateTargetList */
    case 593: /* referencedColumnName */
{
#line 771 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1234); 
#line 6505 "../LemonSrc/SQLParserL.c"
}
      break;
    case 360: /* querySpecification */
{
#line 874 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1078); 
#line 6512 "../LemonSrc/SQLParserL.c"
}
      break;
    case 364: /* selectList */
{
#line 915 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy587); 
#line 6519 "../LemonSrc/SQLParserL.c"
}
      break;
    case 365: /* optionalBulkOutput */
    case 372: /* bulkSpecification */
{
#line 1002 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy707); 
#line 6527 "../LemonSrc/SQLParserL.c"
}
      break;
    case 366: /* tableExpression */
{
#line 1088 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy415); 
#line 6534 "../LemonSrc/SQLParserL.c"
}
      break;
    case 367: /* selectTargetList */
{
#line 966 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy82); 
#line 6541 "../LemonSrc/SQLParserL.c"
}
      break;
    case 368: /* selectSubListList */
{
#line 930 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy57); 
#line 6548 "../LemonSrc/SQLParserL.c"
}
      break;
    case 369: /* selectSubList */
{
#line 950 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy329); 
#line 6555 "../LemonSrc/SQLParserL.c"
}
      break;
    case 370: /* derivedColumn */
{
#line 982 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1268); 
#line 6562 "../LemonSrc/SQLParserL.c"
}
      break;
    case 379: /* fromClause */
    case 383: /* tableReferenceList */
{
#line 1099 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy178); 
#line 6570 "../LemonSrc/SQLParserL.c"
}
      break;
    case 381: /* optionalGroupByClause */
    case 405: /* groupByClause */
{
#line 1409 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy244); 
#line 6578 "../LemonSrc/SQLParserL.c"
}
      break;
    case 382: /* optionalHavingClause */
    case 410: /* havingClause */
{
#line 1508 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy729); 
#line 6586 "../LemonSrc/SQLParserL.c"
}
      break;
    case 385: /* tablePrimary */
{
#line 1142 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy183); 
#line 6593 "../LemonSrc/SQLParserL.c"
}
      break;
    case 387: /* tableCorrelationSpec */
{
#line 1186 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy272); 
#line 6600 "../LemonSrc/SQLParserL.c"
}
      break;
    case 397: /* qualifiedJoin */
    case 398: /* naturalJoin */
{
#line 1292 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1083); 
#line 6608 "../LemonSrc/SQLParserL.c"
}
      break;
    case 399: /* existsJoin */
{
#line 1353 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1255); 
#line 6615 "../LemonSrc/SQLParserL.c"
}
      break;
    case 406: /* groupingElementList */
{
#line 1431 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy604); 
#line 6622 "../LemonSrc/SQLParserL.c"
}
      break;
    case 408: /* groupingColumnReference */
{
#line 1484 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1215); 
#line 6629 "../LemonSrc/SQLParserL.c"
}
      break;
    case 409: /* groupingColumnReferenceList */
{
#line 1467 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy511); 
#line 6636 "../LemonSrc/SQLParserL.c"
}
      break;
    case 413: /* sortSpecification */
{
#line 1556 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy816); 
#line 6643 "../LemonSrc/SQLParserL.c"
}
      break;
    case 429: /* tableValueConstructorList */
    case 490: /* scoreList */
    case 501: /* rowValueConstructorList */
    case 505: /* simpleWhenClauseList */
    case 507: /* searchedWhenClauseList */
    case 509: /* simpleWhenOperandList */
    case 511: /* fulltextOperand */
    case 512: /* multiElementFulltextOperand */
    case 513: /* fulltextOperandList */
    case 588: /* optionalGeneratorOptions */
    case 589: /* generatorOptions */
{
#line 3679 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1140); 
#line 6660 "../LemonSrc/SQLParserL.c"
}
      break;
    case 436: /* containsOperand */
    case 449: /* containsOperandList */
    case 451: /* containsOperandPrimary */
    case 452: /* word */
    case 453: /* containsOperandWord */
    case 459: /* containsOperandParticle */
    case 464: /* containsOperandPattern */
{
#line 1970 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy231); 
#line 6673 "../LemonSrc/SQLParserL.c"
}
      break;
    case 437: /* containsOption */
{
#line 1907 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy11); 
#line 6680 "../LemonSrc/SQLParserL.c"
}
      break;
    case 443: /* expand */
{
#line 2517 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy416); 
#line 6687 "../LemonSrc/SQLParserL.c"
}
      break;
    case 450: /* wordList */
    case 460: /* containsOperandParticleList */
    case 461: /* containsOperandWordList */
{
#line 2110 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy647); 
#line 6696 "../LemonSrc/SQLParserL.c"
}
      break;
    case 517: /* arrayElementList */
{
#line 3517 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy616); 
#line 6703 "../LemonSrc/SQLParserL.c"
}
      break;
    case 529: /* insertColumnsAndSource */
{
#line 3760 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy853); 
#line 6710 "../LemonSrc/SQLParserL.c"
}
      break;
    case 531: /* setClauseList */
{
#line 3821 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1207); 
#line 6717 "../LemonSrc/SQLParserL.c"
}
      break;
    case 532: /* setClause */
{
#line 3840 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy263); 
#line 6724 "../LemonSrc/SQLParserL.c"
}
      break;
    case 535: /* transactModeList */
{
#line 3883 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy662); 
#line 6731 "../LemonSrc/SQLParserL.c"
}
      break;
    case 537: /* transactAccMode */
{
#line 3910 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy715); 
#line 6738 "../LemonSrc/SQLParserL.c"
}
      break;
    case 538: /* isolationLevel */
    case 540: /* levelOfIsolation */
{
#line 3926 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy565); 
#line 6746 "../LemonSrc/SQLParserL.c"
}
      break;
    case 539: /* usingSnapshotMode */
{
#line 3957 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy754); 
#line 6753 "../LemonSrc/SQLParserL.c"
}
      break;
    case 541: /* xa_Identifier */
{
#line 4011 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1146); 
#line 6760 "../LemonSrc/SQLParserL.c"
}
      break;
    case 544: /* optionalDatabaseCreateOption */
    case 545: /* databaseCreateOptionList */
    case 635: /* databaseMountOptionList */
{
#line 4222 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy553); 
#line 6769 "../LemonSrc/SQLParserL.c"
}
      break;
    case 546: /* databaseCreateOption */
{
#line 4247 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1241); 
#line 6776 "../LemonSrc/SQLParserL.c"
}
      break;
    case 547: /* dbPathClause */
    case 552: /* dbPathElementList */
{
#line 4273 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy159); 
#line 6784 "../LemonSrc/SQLParserL.c"
}
      break;
    case 553: /* dbPathElement */
{
#line 4299 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy287); 
#line 6791 "../LemonSrc/SQLParserL.c"
}
      break;
    case 557: /* alterDatabaseOption */
    case 558: /* alterDatabaseAttributeList */
{
#line 4446 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy388); 
#line 6799 "../LemonSrc/SQLParserL.c"
}
      break;
    case 559: /* alterDatabaseAttribute */
{
#line 4472 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy532); 
#line 6806 "../LemonSrc/SQLParserL.c"
}
      break;
    case 562: /* tableElementList */
    case 612: /* addColumnDefinitionBody */
{
#line 4548 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy117); 
#line 6814 "../LemonSrc/SQLParserL.c"
}
      break;
    case 563: /* tableAreaOption */
    case 597: /* tableAreaClause */
    case 605: /* tblAreaOption */
    case 616: /* indexAreaOption */
    case 617: /* indexAreaClause */
    case 623: /* idxAreaOption */
{
#line 5152 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1053); 
#line 6826 "../LemonSrc/SQLParserL.c"
}
      break;
    case 565: /* columnDefinition */
{
#line 4582 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy418); 
#line 6833 "../LemonSrc/SQLParserL.c"
}
      break;
    case 566: /* tableConstraintDefinition */
{
#line 5030 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy641); 
#line 6840 "../LemonSrc/SQLParserL.c"
}
      break;
    case 567: /* dataType */
    case 573: /* collectionType */
    case 574: /* nonCollectionDataType */
    case 578: /* preDefinedType */
    case 660: /* parameterType */
    case 661: /* returnsDataType */
{
#line 4619 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1194); 
#line 6852 "../LemonSrc/SQLParserL.c"
}
      break;
    case 570: /* optionalColumnConstraintList */
    case 581: /* columnConstraintList */
{
#line 4828 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy139); 
#line 6860 "../LemonSrc/SQLParserL.c"
}
      break;
    case 580: /* optionalDecimalLength */
{
#line 4793 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy727); 
#line 6867 "../LemonSrc/SQLParserL.c"
}
      break;
    case 582: /* columnConstraint */
{
#line 4854 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy123); 
#line 6874 "../LemonSrc/SQLParserL.c"
}
      break;
    case 585: /* constClacuse */
{
#line 4908 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy0); 
#line 6881 "../LemonSrc/SQLParserL.c"
}
      break;
    case 594: /* hintElement */
{
#line 5079 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy564); 
#line 6888 "../LemonSrc/SQLParserL.c"
}
      break;
    case 596: /* hintElementList */
{
#line 5133 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy484); 
#line 6895 "../LemonSrc/SQLParserL.c"
}
      break;
    case 598: /* alterTableAction */
    case 599: /* setTableAreaClause */
    case 600: /* dropTableAreaClause */
    case 601: /* renameTableClause */
    case 602: /* addColumnDefinition */
    case 603: /* alterColumnDefinition */
    case 604: /* addTableConstraintDefinition */
{
#line 5193 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy810); 
#line 6908 "../LemonSrc/SQLParserL.c"
}
      break;
    case 618: /* alterIndexAction */
    case 619: /* setIndexAreaClause */
    case 620: /* dropIndexAreaClause */
    case 621: /* renameIndexClause */
    case 622: /* offlineIndexClause */
{
#line 5509 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy25); 
#line 6919 "../LemonSrc/SQLParserL.c"
}
      break;
    case 625: /* areaPath */
    case 627: /* areaPathArray */
    case 628: /* areaArrayElement */
    case 631: /* singleModifyAreaClause */
    case 632: /* arrayFullModifyAreaClause */
    case 633: /* arrayElementModifyAreaClause */
    case 634: /* newAreaSpecifiedPathElement */
{
#line 5643 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy586); 
#line 6932 "../LemonSrc/SQLParserL.c"
}
      break;
    case 626: /* areaPathElement */
{
#line 5655 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1187); 
#line 6939 "../LemonSrc/SQLParserL.c"
}
      break;
    case 629: /* alterAreaAction */
    case 630: /* modifyAreaDefinition */
{
#line 5713 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy490); 
#line 6947 "../LemonSrc/SQLParserL.c"
}
      break;
    case 636: /* optionalAreaParameter */
{
#line 5885 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy515); 
#line 6954 "../LemonSrc/SQLParserL.c"
}
      break;
    case 637: /* optionalAreaParameterList */
{
#line 5903 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy243); 
#line 6961 "../LemonSrc/SQLParserL.c"
}
      break;
    case 641: /* optionList */
{
#line 6008 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy409); 
#line 6968 "../LemonSrc/SQLParserL.c"
}
      break;
    case 643: /* roles */
    case 644: /* granteeList */
{
#line 6129 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1134); 
#line 6976 "../LemonSrc/SQLParserL.c"
}
      break;
    case 645: /* explainOption */
{
#line 6181 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1289); 
#line 6983 "../LemonSrc/SQLParserL.c"
}
      break;
    case 652: /* optionalPartitionCategory */
{
#line 6320 "../LemonSrc/SQLParserL.lemon"

#line 6990 "../LemonSrc/SQLParserL.c"
}
      break;
    case 654: /* parameterSpecification */
    case 657: /* parameterDeclarationList */
{
#line 6392 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1075); 
#line 6998 "../LemonSrc/SQLParserL.c"
}
      break;
    case 655: /* returnsClause */
{
#line 6447 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy407); 
#line 7005 "../LemonSrc/SQLParserL.c"
}
      break;
    case 656: /* routineBody */
{
#line 6466 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy891); 
#line 7012 "../LemonSrc/SQLParserL.c"
}
      break;
    case 658: /* parameterDeclaration */
{
#line 6418 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy1010); 
#line 7019 "../LemonSrc/SQLParserL.c"
}
      break;
    case 663: /* returnStatement */
{
#line 6486 "../LemonSrc/SQLParserL.lemon"
 delete (yypminor->yy592); 
#line 7026 "../LemonSrc/SQLParserL.c"
}
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from SQLParserEngineAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void SQLParserEngineFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void* pMem, const char* file, int)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  /******************************************
   * RICOH modification: add file and line  */
  (*freeProc)((void*)pParser, __FILE__, __LINE__);
  /******************************************/
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int SQLParserEngineStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_MAX ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_MAX );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_SZ_ACTTAB );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   SQLParserEngineARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
   SQLParserEngineARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 265, 1 },
  { 266, 1 },
  { 266, 2 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 317, 1 },
  { 317, 1 },
  { 317, 1 },
  { 319, 1 },
  { 319, 1 },
  { 321, 1 },
  { 321, 1 },
  { 322, 1 },
  { 318, 1 },
  { 318, 1 },
  { 323, 1 },
  { 325, 1 },
  { 324, 1 },
  { 326, 1 },
  { 320, 1 },
  { 320, 1 },
  { 327, 2 },
  { 328, 2 },
  { 329, 1 },
  { 331, 1 },
  { 332, 1 },
  { 330, 1 },
  { 330, 1 },
  { 333, 1 },
  { 333, 1 },
  { 333, 1 },
  { 333, 1 },
  { 334, 1 },
  { 335, 1 },
  { 336, 1 },
  { 337, 1 },
  { 337, 1 },
  { 337, 1 },
  { 337, 1 },
  { 337, 1 },
  { 338, 1 },
  { 339, 1 },
  { 339, 1 },
  { 339, 1 },
  { 339, 1 },
  { 339, 1 },
  { 341, 3 },
  { 341, 1 },
  { 342, 1 },
  { 340, 4 },
  { 340, 1 },
  { 344, 3 },
  { 268, 4 },
  { 345, 1 },
  { 345, 3 },
  { 350, 3 },
  { 350, 3 },
  { 350, 3 },
  { 351, 0 },
  { 351, 1 },
  { 351, 1 },
  { 352, 0 },
  { 352, 1 },
  { 353, 2 },
  { 354, 0 },
  { 354, 4 },
  { 355, 1 },
  { 356, 1 },
  { 356, 3 },
  { 356, 2 },
  { 349, 1 },
  { 357, 1 },
  { 358, 1 },
  { 358, 3 },
  { 359, 1 },
  { 359, 1 },
  { 359, 1 },
  { 360, 5 },
  { 360, 6 },
  { 363, 0 },
  { 363, 1 },
  { 363, 1 },
  { 364, 1 },
  { 364, 1 },
  { 368, 1 },
  { 368, 3 },
  { 368, 2 },
  { 369, 1 },
  { 369, 3 },
  { 367, 1 },
  { 367, 3 },
  { 370, 1 },
  { 370, 2 },
  { 370, 3 },
  { 365, 0 },
  { 365, 3 },
  { 372, 3 },
  { 373, 2 },
  { 374, 0 },
  { 374, 2 },
  { 377, 2 },
  { 375, 0 },
  { 375, 1 },
  { 378, 2 },
  { 366, 4 },
  { 379, 2 },
  { 383, 1 },
  { 383, 3 },
  { 383, 2 },
  { 384, 1 },
  { 384, 1 },
  { 385, 2 },
  { 385, 1 },
  { 385, 2 },
  { 385, 3 },
  { 385, 2 },
  { 385, 5 },
  { 387, 2 },
  { 390, 2 },
  { 390, 1 },
  { 391, 0 },
  { 391, 3 },
  { 392, 1 },
  { 388, 1 },
  { 393, 1 },
  { 395, 1 },
  { 394, 3 },
  { 386, 1 },
  { 386, 1 },
  { 386, 1 },
  { 386, 1 },
  { 396, 4 },
  { 397, 5 },
  { 400, 0 },
  { 400, 1 },
  { 400, 1 },
  { 400, 2 },
  { 400, 1 },
  { 400, 2 },
  { 400, 1 },
  { 400, 2 },
  { 401, 2 },
  { 401, 4 },
  { 398, 5 },
  { 399, 6 },
  { 399, 7 },
  { 389, 4 },
  { 380, 0 },
  { 380, 1 },
  { 403, 2 },
  { 402, 1 },
  { 381, 0 },
  { 381, 1 },
  { 405, 3 },
  { 406, 1 },
  { 406, 3 },
  { 407, 1 },
  { 407, 3 },
  { 407, 2 },
  { 409, 1 },
  { 409, 3 },
  { 408, 1 },
  { 408, 3 },
  { 382, 0 },
  { 382, 1 },
  { 410, 2 },
  { 346, 0 },
  { 346, 4 },
  { 411, 1 },
  { 411, 3 },
  { 413, 2 },
  { 414, 1 },
  { 414, 1 },
  { 414, 0 },
  { 412, 0 },
  { 412, 3 },
  { 347, 0 },
  { 347, 1 },
  { 347, 3 },
  { 415, 2 },
  { 404, 1 },
  { 417, 3 },
  { 417, 3 },
  { 417, 3 },
  { 417, 2 },
  { 417, 1 },
  { 417, 1 },
  { 417, 1 },
  { 417, 1 },
  { 417, 1 },
  { 417, 1 },
  { 417, 1 },
  { 417, 1 },
  { 417, 1 },
  { 418, 3 },
  { 418, 3 },
  { 418, 3 },
  { 418, 3 },
  { 418, 3 },
  { 418, 3 },
  { 419, 5 },
  { 419, 6 },
  { 420, 3 },
  { 420, 3 },
  { 420, 4 },
  { 420, 4 },
  { 427, 1 },
  { 428, 3 },
  { 428, 1 },
  { 421, 4 },
  { 421, 5 },
  { 421, 5 },
  { 421, 5 },
  { 421, 6 },
  { 421, 6 },
  { 432, 2 },
  { 431, 0 },
  { 431, 1 },
  { 433, 2 },
  { 434, 3 },
  { 435, 3 },
  { 422, 4 },
  { 437, 0 },
  { 437, 2 },
  { 437, 2 },
  { 437, 2 },
  { 437, 2 },
  { 437, 2 },
  { 437, 2 },
  { 437, 2 },
  { 437, 2 },
  { 437, 2 },
  { 437, 2 },
  { 437, 2 },
  { 436, 1 },
  { 436, 4 },
  { 436, 5 },
  { 436, 5 },
  { 436, 5 },
  { 436, 6 },
  { 436, 6 },
  { 436, 6 },
  { 436, 6 },
  { 436, 6 },
  { 436, 6 },
  { 436, 7 },
  { 436, 7 },
  { 436, 7 },
  { 436, 7 },
  { 436, 7 },
  { 436, 7 },
  { 449, 1 },
  { 449, 4 },
  { 449, 3 },
  { 449, 3 },
  { 449, 3 },
  { 439, 2 },
  { 450, 1 },
  { 450, 3 },
  { 452, 2 },
  { 452, 3 },
  { 452, 3 },
  { 452, 3 },
  { 452, 4 },
  { 452, 5 },
  { 452, 4 },
  { 452, 4 },
  { 452, 5 },
  { 452, 5 },
  { 452, 3 },
  { 452, 4 },
  { 452, 5 },
  { 452, 5 },
  { 452, 5 },
  { 452, 4 },
  { 452, 5 },
  { 452, 5 },
  { 452, 4 },
  { 452, 4 },
  { 452, 5 },
  { 452, 5 },
  { 452, 5 },
  { 452, 5 },
  { 452, 5 },
  { 452, 5 },
  { 452, 5 },
  { 452, 5 },
  { 452, 5 },
  { 454, 0 },
  { 454, 1 },
  { 456, 2 },
  { 458, 0 },
  { 458, 1 },
  { 455, 2 },
  { 451, 1 },
  { 451, 3 },
  { 451, 5 },
  { 460, 2 },
  { 460, 2 },
  { 459, 1 },
  { 459, 4 },
  { 459, 4 },
  { 459, 4 },
  { 459, 4 },
  { 459, 6 },
  { 459, 7 },
  { 459, 7 },
  { 461, 2 },
  { 461, 2 },
  { 453, 1 },
  { 453, 4 },
  { 453, 4 },
  { 453, 4 },
  { 453, 4 },
  { 453, 4 },
  { 464, 1 },
  { 464, 2 },
  { 463, 2 },
  { 462, 0 },
  { 462, 1 },
  { 465, 2 },
  { 438, 2 },
  { 440, 3 },
  { 440, 4 },
  { 457, 0 },
  { 457, 1 },
  { 441, 2 },
  { 442, 3 },
  { 443, 7 },
  { 448, 3 },
  { 444, 2 },
  { 445, 3 },
  { 446, 3 },
  { 447, 3 },
  { 423, 3 },
  { 423, 4 },
  { 424, 2 },
  { 425, 5 },
  { 425, 6 },
  { 425, 6 },
  { 425, 6 },
  { 425, 7 },
  { 425, 7 },
  { 426, 5 },
  { 371, 1 },
  { 467, 1 },
  { 467, 1 },
  { 468, 3 },
  { 469, 1 },
  { 469, 1 },
  { 469, 1 },
  { 470, 6 },
  { 470, 8 },
  { 470, 8 },
  { 470, 10 },
  { 470, 6 },
  { 470, 10 },
  { 475, 0 },
  { 475, 3 },
  { 476, 0 },
  { 476, 2 },
  { 477, 0 },
  { 477, 2 },
  { 478, 0 },
  { 478, 2 },
  { 479, 1 },
  { 479, 1 },
  { 474, 1 },
  { 474, 1 },
  { 471, 3 },
  { 430, 1 },
  { 430, 1 },
  { 430, 1 },
  { 472, 1 },
  { 472, 1 },
  { 472, 1 },
  { 472, 1 },
  { 472, 1 },
  { 483, 1 },
  { 483, 1 },
  { 484, 3 },
  { 485, 1 },
  { 485, 1 },
  { 485, 1 },
  { 486, 1 },
  { 486, 4 },
  { 486, 6 },
  { 486, 1 },
  { 486, 5 },
  { 488, 4 },
  { 488, 5 },
  { 488, 5 },
  { 488, 5 },
  { 487, 3 },
  { 487, 3 },
  { 487, 3 },
  { 487, 3 },
  { 487, 2 },
  { 487, 2 },
  { 416, 1 },
  { 416, 1 },
  { 416, 1 },
  { 491, 1 },
  { 491, 1 },
  { 492, 3 },
  { 493, 1 },
  { 493, 1 },
  { 494, 1 },
  { 494, 1 },
  { 480, 1 },
  { 480, 1 },
  { 495, 3 },
  { 495, 1 },
  { 496, 1 },
  { 496, 1 },
  { 496, 1 },
  { 496, 1 },
  { 496, 1 },
  { 497, 3 },
  { 497, 5 },
  { 498, 5 },
  { 498, 7 },
  { 499, 1 },
  { 499, 1 },
  { 502, 5 },
  { 503, 4 },
  { 504, 1 },
  { 505, 1 },
  { 505, 2 },
  { 508, 4 },
  { 509, 1 },
  { 509, 3 },
  { 507, 1 },
  { 507, 2 },
  { 510, 4 },
  { 506, 0 },
  { 506, 2 },
  { 500, 5 },
  { 500, 5 },
  { 500, 4 },
  { 500, 4 },
  { 500, 6 },
  { 500, 6 },
  { 511, 1 },
  { 511, 1 },
  { 511, 3 },
  { 473, 1 },
  { 512, 3 },
  { 513, 1 },
  { 513, 3 },
  { 489, 4 },
  { 490, 1 },
  { 490, 3 },
  { 514, 1 },
  { 514, 1 },
  { 481, 3 },
  { 482, 1 },
  { 482, 1 },
  { 515, 4 },
  { 515, 3 },
  { 516, 1 },
  { 518, 6 },
  { 517, 1 },
  { 517, 3 },
  { 519, 1 },
  { 343, 1 },
  { 343, 1 },
  { 343, 1 },
  { 466, 1 },
  { 466, 1 },
  { 466, 1 },
  { 522, 3 },
  { 523, 3 },
  { 520, 1 },
  { 520, 1 },
  { 520, 1 },
  { 520, 1 },
  { 520, 1 },
  { 521, 1 },
  { 521, 1 },
  { 521, 1 },
  { 521, 1 },
  { 521, 1 },
  { 521, 1 },
  { 524, 5 },
  { 524, 4 },
  { 501, 1 },
  { 501, 3 },
  { 525, 1 },
  { 361, 2 },
  { 429, 1 },
  { 429, 3 },
  { 429, 2 },
  { 362, 2 },
  { 269, 3 },
  { 269, 4 },
  { 526, 2 },
  { 526, 1 },
  { 527, 1 },
  { 270, 3 },
  { 528, 2 },
  { 528, 1 },
  { 529, 4 },
  { 529, 1 },
  { 529, 2 },
  { 529, 4 },
  { 529, 1 },
  { 530, 3 },
  { 271, 5 },
  { 271, 6 },
  { 531, 1 },
  { 531, 3 },
  { 531, 2 },
  { 532, 3 },
  { 532, 3 },
  { 533, 1 },
  { 534, 3 },
  { 292, 3 },
  { 535, 1 },
  { 535, 3 },
  { 536, 1 },
  { 536, 1 },
  { 536, 1 },
  { 537, 2 },
  { 537, 2 },
  { 538, 3 },
  { 540, 2 },
  { 540, 2 },
  { 540, 2 },
  { 540, 1 },
  { 539, 2 },
  { 293, 3 },
  { 294, 1 },
  { 294, 2 },
  { 295, 1 },
  { 295, 2 },
  { 541, 1 },
  { 541, 3 },
  { 541, 5 },
  { 542, 1 },
  { 542, 2 },
  { 542, 2 },
  { 305, 3 },
  { 305, 4 },
  { 305, 4 },
  { 305, 4 },
  { 306, 4 },
  { 543, 0 },
  { 543, 1 },
  { 543, 3 },
  { 307, 3 },
  { 308, 3 },
  { 308, 5 },
  { 309, 3 },
  { 310, 2 },
  { 311, 3 },
  { 278, 4 },
  { 544, 1 },
  { 544, 0 },
  { 545, 1 },
  { 545, 2 },
  { 546, 1 },
  { 546, 1 },
  { 546, 1 },
  { 546, 1 },
  { 546, 1 },
  { 547, 2 },
  { 552, 1 },
  { 552, 2 },
  { 553, 1 },
  { 553, 2 },
  { 553, 2 },
  { 376, 1 },
  { 548, 2 },
  { 548, 2 },
  { 549, 1 },
  { 549, 1 },
  { 554, 4 },
  { 550, 2 },
  { 550, 2 },
  { 551, 2 },
  { 551, 2 },
  { 279, 4 },
  { 282, 5 },
  { 282, 5 },
  { 282, 4 },
  { 282, 5 },
  { 282, 5 },
  { 282, 6 },
  { 556, 1 },
  { 557, 1 },
  { 558, 1 },
  { 558, 2 },
  { 559, 1 },
  { 559, 1 },
  { 559, 1 },
  { 559, 1 },
  { 559, 1 },
  { 272, 10 },
  { 560, 2 },
  { 560, 2 },
  { 560, 1 },
  { 560, 0 },
  { 561, 1 },
  { 561, 1 },
  { 561, 0 },
  { 562, 1 },
  { 562, 3 },
  { 562, 2 },
  { 564, 1 },
  { 564, 1 },
  { 565, 6 },
  { 565, 5 },
  { 565, 5 },
  { 567, 1 },
  { 567, 1 },
  { 573, 2 },
  { 575, 2 },
  { 576, 3 },
  { 576, 0 },
  { 574, 1 },
  { 578, 4 },
  { 578, 4 },
  { 578, 1 },
  { 578, 1 },
  { 578, 1 },
  { 578, 1 },
  { 578, 1 },
  { 578, 1 },
  { 578, 1 },
  { 578, 1 },
  { 578, 1 },
  { 578, 1 },
  { 578, 4 },
  { 578, 4 },
  { 578, 4 },
  { 578, 1 },
  { 578, 1 },
  { 578, 2 },
  { 579, 1 },
  { 579, 1 },
  { 579, 1 },
  { 580, 0 },
  { 580, 3 },
  { 580, 5 },
  { 577, 1 },
  { 577, 2 },
  { 570, 0 },
  { 570, 1 },
  { 581, 1 },
  { 581, 2 },
  { 582, 2 },
  { 582, 2 },
  { 582, 1 },
  { 568, 0 },
  { 568, 1 },
  { 583, 2 },
  { 583, 2 },
  { 584, 1 },
  { 569, 0 },
  { 569, 3 },
  { 571, 2 },
  { 571, 2 },
  { 586, 1 },
  { 586, 1 },
  { 572, 5 },
  { 587, 1 },
  { 587, 2 },
  { 588, 0 },
  { 588, 3 },
  { 589, 1 },
  { 589, 2 },
  { 590, 3 },
  { 590, 3 },
  { 590, 2 },
  { 590, 2 },
  { 590, 2 },
  { 590, 2 },
  { 590, 1 },
  { 590, 2 },
  { 590, 2 },
  { 591, 1 },
  { 566, 6 },
  { 566, 7 },
  { 566, 9 },
  { 593, 0 },
  { 593, 3 },
  { 348, 2 },
  { 348, 0 },
  { 594, 1 },
  { 594, 2 },
  { 595, 1 },
  { 595, 3 },
  { 595, 1 },
  { 595, 1 },
  { 595, 1 },
  { 595, 1 },
  { 595, 1 },
  { 595, 1 },
  { 595, 1 },
  { 595, 1 },
  { 595, 2 },
  { 596, 1 },
  { 596, 3 },
  { 596, 2 },
  { 563, 1 },
  { 563, 0 },
  { 275, 4 },
  { 555, 0 },
  { 555, 2 },
  { 280, 4 },
  { 598, 1 },
  { 598, 1 },
  { 598, 1 },
  { 598, 1 },
  { 598, 1 },
  { 598, 1 },
  { 599, 2 },
  { 600, 2 },
  { 597, 2 },
  { 605, 5 },
  { 606, 1 },
  { 606, 1 },
  { 606, 0 },
  { 607, 2 },
  { 607, 1 },
  { 607, 0 },
  { 608, 2 },
  { 608, 1 },
  { 608, 0 },
  { 609, 2 },
  { 609, 1 },
  { 609, 0 },
  { 610, 2 },
  { 610, 1 },
  { 610, 0 },
  { 601, 3 },
  { 601, 2 },
  { 602, 2 },
  { 602, 3 },
  { 612, 1 },
  { 612, 3 },
  { 612, 2 },
  { 603, 2 },
  { 603, 3 },
  { 613, 1 },
  { 604, 2 },
  { 273, 13 },
  { 592, 1 },
  { 592, 1 },
  { 592, 1 },
  { 592, 1 },
  { 592, 1 },
  { 592, 1 },
  { 592, 2 },
  { 592, 1 },
  { 592, 0 },
  { 614, 3 },
  { 614, 0 },
  { 615, 3 },
  { 615, 0 },
  { 616, 1 },
  { 616, 0 },
  { 274, 4 },
  { 281, 4 },
  { 618, 1 },
  { 618, 1 },
  { 618, 1 },
  { 618, 1 },
  { 619, 2 },
  { 620, 2 },
  { 617, 2 },
  { 623, 3 },
  { 624, 3 },
  { 624, 0 },
  { 621, 3 },
  { 621, 2 },
  { 622, 1 },
  { 622, 1 },
  { 276, 4 },
  { 611, 1 },
  { 625, 1 },
  { 625, 1 },
  { 626, 1 },
  { 627, 4 },
  { 628, 1 },
  { 628, 3 },
  { 628, 2 },
  { 277, 4 },
  { 283, 4 },
  { 629, 1 },
  { 630, 2 },
  { 630, 2 },
  { 630, 2 },
  { 631, 1 },
  { 632, 1 },
  { 633, 1 },
  { 634, 4 },
  { 296, 2 },
  { 297, 8 },
  { 297, 6 },
  { 297, 7 },
  { 297, 6 },
  { 297, 4 },
  { 297, 9 },
  { 635, 1 },
  { 636, 1 },
  { 636, 3 },
  { 636, 0 },
  { 637, 1 },
  { 637, 1 },
  { 637, 2 },
  { 637, 2 },
  { 298, 4 },
  { 638, 1 },
  { 638, 1 },
  { 638, 1 },
  { 638, 0 },
  { 639, 2 },
  { 639, 0 },
  { 299, 5 },
  { 299, 2 },
  { 300, 3 },
  { 300, 4 },
  { 640, 1 },
  { 640, 1 },
  { 640, 1 },
  { 641, 1 },
  { 641, 2 },
  { 642, 1 },
  { 642, 1 },
  { 642, 1 },
  { 642, 1 },
  { 642, 1 },
  { 301, 1 },
  { 301, 2 },
  { 303, 6 },
  { 303, 3 },
  { 304, 3 },
  { 302, 1 },
  { 302, 2 },
  { 312, 4 },
  { 643, 1 },
  { 643, 3 },
  { 644, 1 },
  { 644, 3 },
  { 313, 4 },
  { 314, 3 },
  { 645, 1 },
  { 645, 2 },
  { 646, 1 },
  { 646, 2 },
  { 647, 1 },
  { 647, 2 },
  { 315, 3 },
  { 316, 2 },
  { 284, 7 },
  { 651, 0 },
  { 651, 1 },
  { 287, 7 },
  { 289, 4 },
  { 648, 1 },
  { 649, 1 },
  { 650, 1 },
  { 285, 10 },
  { 652, 0 },
  { 652, 2 },
  { 288, 9 },
  { 290, 5 },
  { 286, 6 },
  { 291, 4 },
  { 653, 1 },
  { 654, 3 },
  { 657, 1 },
  { 657, 3 },
  { 658, 2 },
  { 659, 1 },
  { 660, 1 },
  { 655, 2 },
  { 661, 1 },
  { 656, 1 },
  { 662, 1 },
  { 663, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  SQLParserEngineARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 1: /* sqlStatementList ::= sqlStatement */
      case 2: /* sqlStatementList ::= sqlStatementList sqlStatement */ yytestcase(yyruleno==2);
#line 152 "../LemonSrc/SQLParserL.lemon"
{
		pParser->setResult(yymsp[0].minor.yy934);
		pParser->setState(Statement::SQLParser::PARSE_ACCEPT);
	}
#line 8250 "../LemonSrc/SQLParserL.c"
        break;
      case 3: /* sqlStatement ::= SEMICOLON */
#line 173 "../LemonSrc/SQLParserL.lemon"
{yygotominor.yy934 = 0;  yy_destructor(yypParser,1,&yymsp[0].minor);
}
#line 8256 "../LemonSrc/SQLParserL.c"
        break;
      case 4: /* sqlStatement ::= queryExpression */
#line 179 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy533; }
#line 8261 "../LemonSrc/SQLParserL.c"
        break;
      case 5: /* sqlStatement ::= deleteStatement */
#line 185 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy171; }
#line 8266 "../LemonSrc/SQLParserL.c"
        break;
      case 6: /* sqlStatement ::= insertStatement */
#line 187 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy13; }
#line 8271 "../LemonSrc/SQLParserL.c"
        break;
      case 7: /* sqlStatement ::= updateStatement */
#line 190 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy351; }
#line 8276 "../LemonSrc/SQLParserL.c"
        break;
      case 8: /* sqlStatement ::= tableDefinition */
#line 196 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy1000; }
#line 8281 "../LemonSrc/SQLParserL.c"
        break;
      case 9: /* sqlStatement ::= indexDefinition */
#line 198 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy456; }
#line 8286 "../LemonSrc/SQLParserL.c"
        break;
      case 10: /* sqlStatement ::= dropIndexStatement */
#line 200 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy745; }
#line 8291 "../LemonSrc/SQLParserL.c"
        break;
      case 11: /* sqlStatement ::= dropTableStatement */
#line 202 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy41; }
#line 8296 "../LemonSrc/SQLParserL.c"
        break;
      case 12: /* sqlStatement ::= areaDefinition */
#line 204 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy857; }
#line 8301 "../LemonSrc/SQLParserL.c"
        break;
      case 13: /* sqlStatement ::= dropAreaStatement */
#line 206 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy706; }
#line 8306 "../LemonSrc/SQLParserL.c"
        break;
      case 14: /* sqlStatement ::= databaseDefinition */
#line 208 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy809; }
#line 8311 "../LemonSrc/SQLParserL.c"
        break;
      case 15: /* sqlStatement ::= dropDatabaseStatement */
#line 210 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy1074; }
#line 8316 "../LemonSrc/SQLParserL.c"
        break;
      case 16: /* sqlStatement ::= alterTableStatement */
#line 212 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy568; }
#line 8321 "../LemonSrc/SQLParserL.c"
        break;
      case 17: /* sqlStatement ::= alterIndexStatement */
#line 214 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy1192; }
#line 8326 "../LemonSrc/SQLParserL.c"
        break;
      case 18: /* sqlStatement ::= alterDatabaseStatement */
      case 118: /* queryTerm ::= queryPrimary */ yytestcase(yyruleno==118);
      case 119: /* queryPrimary ::= nonJoinQueryPrimary */ yytestcase(yyruleno==119);
      case 124: /* simpleTable ::= explicitTable */ yytestcase(yyruleno==124);
      case 175: /* joinedTable ::= crossJoin */ yytestcase(yyruleno==175);
#line 216 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy934; }
#line 8335 "../LemonSrc/SQLParserL.c"
        break;
      case 19: /* sqlStatement ::= alterAreaStatement */
#line 218 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy37; }
#line 8340 "../LemonSrc/SQLParserL.c"
        break;
      case 20: /* sqlStatement ::= cascadeDefinition */
#line 224 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy720; }
#line 8345 "../LemonSrc/SQLParserL.c"
        break;
      case 21: /* sqlStatement ::= partitionDefinition */
#line 226 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy726; }
#line 8350 "../LemonSrc/SQLParserL.c"
        break;
      case 22: /* sqlStatement ::= functionDefinition */
#line 228 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy862; }
#line 8355 "../LemonSrc/SQLParserL.c"
        break;
      case 23: /* sqlStatement ::= alterCascadeStatement */
#line 230 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy496; }
#line 8360 "../LemonSrc/SQLParserL.c"
        break;
      case 24: /* sqlStatement ::= alterPartitionStatement */
#line 232 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy1246; }
#line 8365 "../LemonSrc/SQLParserL.c"
        break;
      case 25: /* sqlStatement ::= dropCascadeStatement */
#line 236 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy1161; }
#line 8370 "../LemonSrc/SQLParserL.c"
        break;
      case 26: /* sqlStatement ::= dropPartitionStatement */
#line 238 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy1071; }
#line 8375 "../LemonSrc/SQLParserL.c"
        break;
      case 27: /* sqlStatement ::= dropFunctionStatement */
#line 240 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy371; }
#line 8380 "../LemonSrc/SQLParserL.c"
        break;
      case 28: /* sqlStatement ::= startTransactionStatement */
#line 246 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy516; }
#line 8385 "../LemonSrc/SQLParserL.c"
        break;
      case 29: /* sqlStatement ::= setTransactionStatement */
#line 248 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy918; }
#line 8390 "../LemonSrc/SQLParserL.c"
        break;
      case 30: /* sqlStatement ::= commitStatement */
#line 250 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy1197; }
#line 8395 "../LemonSrc/SQLParserL.c"
        break;
      case 31: /* sqlStatement ::= rollbackStatement */
#line 252 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy110; }
#line 8400 "../LemonSrc/SQLParserL.c"
        break;
      case 32: /* sqlStatement ::= unmountDatabaseStatement */
#line 258 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy1043; }
#line 8405 "../LemonSrc/SQLParserL.c"
        break;
      case 33: /* sqlStatement ::= mountDatabaseStatement */
#line 260 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy936; }
#line 8410 "../LemonSrc/SQLParserL.c"
        break;
      case 34: /* sqlStatement ::= startBackupStatement */
#line 262 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy1108; }
#line 8415 "../LemonSrc/SQLParserL.c"
        break;
      case 35: /* sqlStatement ::= endBackupStatement */
#line 264 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy861; }
#line 8420 "../LemonSrc/SQLParserL.c"
        break;
      case 36: /* sqlStatement ::= verifyStatement */
#line 266 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy133; }
#line 8425 "../LemonSrc/SQLParserL.c"
        break;
      case 37: /* sqlStatement ::= syncStatement */
#line 272 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy1057; }
#line 8430 "../LemonSrc/SQLParserL.c"
        break;
      case 38: /* sqlStatement ::= checkpointStatement */
#line 274 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy1248; }
#line 8435 "../LemonSrc/SQLParserL.c"
        break;
      case 39: /* sqlStatement ::= disconnectStatement */
#line 280 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy822; }
#line 8440 "../LemonSrc/SQLParserL.c"
        break;
      case 40: /* sqlStatement ::= declareStatement */
#line 286 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy124; }
#line 8445 "../LemonSrc/SQLParserL.c"
        break;
      case 41: /* sqlStatement ::= xa_StartStatement */
#line 292 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy882; }
#line 8450 "../LemonSrc/SQLParserL.c"
        break;
      case 42: /* sqlStatement ::= xa_EndStatement */
#line 294 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy931; }
#line 8455 "../LemonSrc/SQLParserL.c"
        break;
      case 43: /* sqlStatement ::= xa_PrepareStatement */
#line 296 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy563; }
#line 8460 "../LemonSrc/SQLParserL.c"
        break;
      case 44: /* sqlStatement ::= xa_CommitStatement */
#line 298 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy777; }
#line 8465 "../LemonSrc/SQLParserL.c"
        break;
      case 45: /* sqlStatement ::= xa_RollbackStatement */
#line 300 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy938; }
#line 8470 "../LemonSrc/SQLParserL.c"
        break;
      case 46: /* sqlStatement ::= xa_RecoverStatement */
#line 302 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy134; }
#line 8475 "../LemonSrc/SQLParserL.c"
        break;
      case 47: /* sqlStatement ::= xa_ForgetStatement */
#line 304 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy367; }
#line 8480 "../LemonSrc/SQLParserL.c"
        break;
      case 48: /* sqlStatement ::= grantStatement */
#line 310 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy1276; }
#line 8485 "../LemonSrc/SQLParserL.c"
        break;
      case 49: /* sqlStatement ::= revokeStatement */
#line 312 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy1256; }
#line 8490 "../LemonSrc/SQLParserL.c"
        break;
      case 50: /* sqlStatement ::= explainStatement */
#line 318 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy1045; }
#line 8495 "../LemonSrc/SQLParserL.c"
        break;
      case 51: /* sqlStatement ::= startExplainStatement */
#line 321 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy555; }
#line 8500 "../LemonSrc/SQLParserL.c"
        break;
      case 52: /* sqlStatement ::= endExplainStatement */
#line 324 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy232; }
#line 8505 "../LemonSrc/SQLParserL.c"
        break;
      case 53: /* literal ::= numericLiteral */
      case 54: /* literal ::= stringLiteral */ yytestcase(yyruleno==54);
      case 55: /* literal ::= datetimeLiteral */ yytestcase(yyruleno==55);
#line 333 "../LemonSrc/SQLParserL.lemon"
{yygotominor.yy1200 = yymsp[0].minor.yy1200;}
#line 8512 "../LemonSrc/SQLParserL.c"
        break;
      case 56: /* stringLiteral ::= characterStringLiteral */
      case 57: /* stringLiteral ::= binaryStringLiteral */ yytestcase(yyruleno==57);
      case 67: /* datetimeLiteral ::= dateLiteral */ yytestcase(yyruleno==67);
      case 68: /* datetimeLiteral ::= timestampLiteral */ yytestcase(yyruleno==68);
#line 343 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1200 = yymsp[0].minor.yy1200; }
#line 8520 "../LemonSrc/SQLParserL.c"
        break;
      case 58: /* characterStringLiteral ::= STRING */
      case 59: /* characterStringLiteral ::= STRING_WITH_QUOTE */ yytestcase(yyruleno==59);
      case 60: /* binaryStringLiteral ::= BINARY_STRING */ yytestcase(yyruleno==60);
      case 64: /* unsignedIntegerLiteral ::= INTEGER_LITERAL */ yytestcase(yyruleno==64);
      case 66: /* floatLiteral ::= FLOAT_LITERAL */ yytestcase(yyruleno==66);
#line 357 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1200 = new Literal(*yymsp[0].minor.yy0);
		delete yymsp[0].minor.yy0;
	}
#line 8532 "../LemonSrc/SQLParserL.c"
        break;
      case 61: /* numericLiteral ::= exactNumericLiteral */
      case 62: /* numericLiteral ::= approximateNumericLiteral */ yytestcase(yyruleno==62);
      case 63: /* exactNumericLiteral ::= unsignedIntegerLiteral */ yytestcase(yyruleno==63);
      case 65: /* approximateNumericLiteral ::= floatLiteral */ yytestcase(yyruleno==65);
      case 587: /* signedIntegerLiteral ::= unsignedIntegerLiteral */ yytestcase(yyruleno==587);
      case 620: /* pathName ::= characterStringLiteral */ yytestcase(yyruleno==620);
      case 729: /* generatorOptionValue ::= signedIntegerLiteral */ yytestcase(yyruleno==729);
#line 391 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1200 = yymsp[0].minor.yy1200;
	}
#line 8545 "../LemonSrc/SQLParserL.c"
        break;
      case 69: /* dateLiteral ::= DATE STRING */
#line 455 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1200 = new Literal(Token(TOKEN__DATE, yymsp[0].minor.yy0->getHead(), yymsp[0].minor.yy0->getTail()));
		delete yymsp[0].minor.yy0;
	  yy_destructor(yypParser,48,&yymsp[-1].minor);
}
#line 8554 "../LemonSrc/SQLParserL.c"
        break;
      case 70: /* timestampLiteral ::= TIMESTAMP STRING */
#line 465 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1200 = new Literal(Token(TOKEN__TIMESTAMP, yymsp[0].minor.yy0->getHead(), yymsp[0].minor.yy0->getTail()));
		delete yymsp[0].minor.yy0;
	  yy_destructor(yypParser,49,&yymsp[-1].minor);
}
#line 8563 "../LemonSrc/SQLParserL.c"
        break;
      case 71: /* tableName ::= identifier */
      case 167: /* asCorrelationName ::= identifier */ yytestcase(yyruleno==167);
      case 546: /* targetTable ::= tableName */ yytestcase(yyruleno==546);
      case 637: /* dbName ::= identifier */ yytestcase(yyruleno==637);
      case 906: /* optionalIdentifier ::= identifier */ yytestcase(yyruleno==906);
      case 909: /* cascadeName ::= identifier */ yytestcase(yyruleno==909);
      case 919: /* functionName ::= identifier */ yytestcase(yyruleno==919);
      case 924: /* parameterName ::= identifier */ yytestcase(yyruleno==924);
#line 481 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1118 = yymsp[0].minor.yy1118;
	}
#line 8577 "../LemonSrc/SQLParserL.c"
        break;
      case 72: /* columnName ::= identifier */
#line 491 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy370 = new ColumnName(yymsp[0].minor.yy1118);
	}
#line 8584 "../LemonSrc/SQLParserL.c"
        break;
      case 73: /* variableName ::= identifier */
#line 501 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy278 = new VariableName(yymsp[0].minor.yy1118);
	}
#line 8591 "../LemonSrc/SQLParserL.c"
        break;
      case 74: /* identifier ::= IDENTIFIER */
      case 75: /* identifier ::= IDENTIFIER_WITH_QUOTE */ yytestcase(yyruleno==75);
#line 511 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1118 = new Identifier(*yymsp[0].minor.yy0);
		delete yymsp[0].minor.yy0;
	}
#line 8600 "../LemonSrc/SQLParserL.c"
        break;
      case 76: /* valueSpecification ::= numericValueSpecification */
      case 77: /* valueSpecification ::= stringValueSpecification */ yytestcase(yyruleno==77);
      case 78: /* valueSpecification ::= datetimeValueSpecification */ yytestcase(yyruleno==78);
      case 79: /* valueSpecification ::= noTypeValueSpecification */ yytestcase(yyruleno==79);
      case 83: /* noTypeValueSpecification ::= placeHolder */ yytestcase(yyruleno==83);
      case 86: /* noTypeValueSpecification ::= generalValueSpecification */ yytestcase(yyruleno==86);
      case 87: /* noTypeValueSpecification ::= elementReference */ yytestcase(yyruleno==87);
      case 198: /* searchCondition ::= booleanValueExpression */ yytestcase(yyruleno==198);
      case 228: /* booleanValueExpression ::= predicateValueExpression */ yytestcase(yyruleno==228);
      case 233: /* predicateValueExpression ::= comparisonPredicate */ yytestcase(yyruleno==233);
      case 234: /* predicateValueExpression ::= betweenPredicate */ yytestcase(yyruleno==234);
      case 235: /* predicateValueExpression ::= inPredicate */ yytestcase(yyruleno==235);
      case 236: /* predicateValueExpression ::= likePredicate */ yytestcase(yyruleno==236);
      case 237: /* predicateValueExpression ::= containsPredicate */ yytestcase(yyruleno==237);
      case 238: /* predicateValueExpression ::= isNullPredicate */ yytestcase(yyruleno==238);
      case 239: /* predicateValueExpression ::= existsPredicate */ yytestcase(yyruleno==239);
      case 240: /* predicateValueExpression ::= similarPredicate */ yytestcase(yyruleno==240);
      case 241: /* predicateValueExpression ::= isSubstringOfPredicate */ yytestcase(yyruleno==241);
      case 265: /* optionalLanguage ::= language */ yytestcase(yyruleno==265);
      case 337: /* optionalCategory ::= category */ yytestcase(yyruleno==337);
      case 340: /* optionalScale ::= scale */ yytestcase(yyruleno==340);
      case 367: /* optionalLowerDist ::= lowerDist */ yytestcase(yyruleno==367);
      case 373: /* optionalDf ::= df */ yytestcase(yyruleno==373);
      case 393: /* stringValueExpression ::= stringRowValueExpression */ yytestcase(yyruleno==393);
      case 394: /* stringValueExpression ::= stringValueExpressionPrimary */ yytestcase(yyruleno==394);
      case 396: /* stringValueExpressionPrimary ::= stringValueSpecification */ yytestcase(yyruleno==396);
      case 397: /* stringValueExpressionPrimary ::= stringValueFunction */ yytestcase(yyruleno==397);
      case 398: /* stringValueExpressionPrimary ::= stringConcatenation */ yytestcase(yyruleno==398);
      case 413: /* kwicStringOption ::= stringValueSpecification */ yytestcase(yyruleno==413);
      case 414: /* kwicStringOption ::= placeHolder */ yytestcase(yyruleno==414);
      case 415: /* kwicNumericOption ::= numericValueSpecification */ yytestcase(yyruleno==415);
      case 416: /* kwicNumericOption ::= placeHolder */ yytestcase(yyruleno==416);
      case 418: /* stringValueOperand ::= stringRowValueExpression */ yytestcase(yyruleno==418);
      case 419: /* stringValueOperand ::= stringValueExpressionPrimary */ yytestcase(yyruleno==419);
      case 420: /* stringValueOperand ::= generalValueExpression */ yytestcase(yyruleno==420);
      case 421: /* stringOrArrayValueOperand ::= stringRowValueExpression */ yytestcase(yyruleno==421);
      case 422: /* stringOrArrayValueOperand ::= stringValueExpressionPrimary */ yytestcase(yyruleno==422);
      case 425: /* stringOrArrayValueOperand ::= generalValueExpression */ yytestcase(yyruleno==425);
      case 426: /* numericValueExpression ::= numericRowValueExpression */ yytestcase(yyruleno==426);
      case 427: /* numericValueExpression ::= numericValueExpressionPrimary */ yytestcase(yyruleno==427);
      case 429: /* numericValueExpressionPrimary ::= numericValueSpecification */ yytestcase(yyruleno==429);
      case 430: /* numericValueExpressionPrimary ::= numericValueFunction */ yytestcase(yyruleno==430);
      case 431: /* numericValueExpressionPrimary ::= arithmeticOperation */ yytestcase(yyruleno==431);
      case 432: /* numericValueFunction ::= numericValueSetFunction */ yytestcase(yyruleno==432);
      case 447: /* numericValueOperand ::= numericRowValueExpression */ yytestcase(yyruleno==447);
      case 448: /* numericValueOperand ::= numericValueExpressionPrimary */ yytestcase(yyruleno==448);
      case 449: /* numericValueOperand ::= generalValueExpression */ yytestcase(yyruleno==449);
      case 450: /* datetimeValueExpression ::= datetimeRowValueExpression */ yytestcase(yyruleno==450);
      case 451: /* datetimeValueExpression ::= datetimeValueExpressionPrimary */ yytestcase(yyruleno==451);
      case 453: /* datetimeValueExpressionPrimary ::= datetimeValueSpecification */ yytestcase(yyruleno==453);
      case 454: /* datetimeValueExpressionPrimary ::= datetimeValueFunction */ yytestcase(yyruleno==454);
      case 457: /* generalValueExpression ::= generalRowValueExpression */ yytestcase(yyruleno==457);
      case 458: /* generalValueExpression ::= generalValueExpressionPrimary */ yytestcase(yyruleno==458);
      case 460: /* generalRowValueExpression ::= rowSubquery */ yytestcase(yyruleno==460);
      case 461: /* generalValueExpressionPrimary ::= noTypeValueSpecification */ yytestcase(yyruleno==461);
      case 462: /* generalValueExpressionPrimary ::= generalFunction0Arg */ yytestcase(yyruleno==462);
      case 463: /* generalValueExpressionPrimary ::= generalFunctionNArgs */ yytestcase(yyruleno==463);
      case 464: /* generalValueExpressionPrimary ::= caseExpression */ yytestcase(yyruleno==464);
      case 465: /* generalValueExpressionPrimary ::= generalSetFunction */ yytestcase(yyruleno==465);
      case 508: /* arrayStringFunction ::= expandStringFunction */ yytestcase(yyruleno==508);
      case 516: /* rowValueExpression ::= nonPredicateValueExpressionPrimary */ yytestcase(yyruleno==516);
      case 517: /* rowValueExpression ::= rowValueConstructor */ yytestcase(yyruleno==517);
      case 518: /* rowValueExpression ::= generalValueExpression */ yytestcase(yyruleno==518);
      case 521: /* nonPredicateValueExpressionPrimary ::= numericValueExpressionPrimary */ yytestcase(yyruleno==521);
      case 522: /* nonPredicateValueExpressionPrimary ::= stringValueExpressionPrimary */ yytestcase(yyruleno==522);
      case 523: /* nonPredicateValueExpressionPrimary ::= datetimeValueExpressionPrimary */ yytestcase(yyruleno==523);
      case 525: /* nonPredicateValueExpressionPrimary ::= rowValueExpressionPrimary */ yytestcase(yyruleno==525);
      case 526: /* rowValueConstructor ::= multiElementRowValueConstructor */ yytestcase(yyruleno==526);
      case 527: /* rowValueConstructor ::= numericRowValueExpression */ yytestcase(yyruleno==527);
      case 528: /* rowValueConstructor ::= stringRowValueExpression */ yytestcase(yyruleno==528);
      case 529: /* rowValueConstructor ::= datetimeRowValueExpression */ yytestcase(yyruleno==529);
      case 531: /* rowValueConstructor ::= rowRowValueExpression */ yytestcase(yyruleno==531);
      case 536: /* rowValueConstructorElement ::= nonPredicateValueExpression */ yytestcase(yyruleno==536);
      case 706: /* defaultOption ::= nonPredicateValueExpression */ yytestcase(yyruleno==706);
#line 528 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172; }
#line 8678 "../LemonSrc/SQLParserL.c"
        break;
      case 80: /* numericValueSpecification ::= numericLiteral */
      case 81: /* stringValueSpecification ::= stringLiteral */ yytestcase(yyruleno==81);
      case 82: /* datetimeValueSpecification ::= datetimeLiteral */ yytestcase(yyruleno==82);
      case 711: /* constOption ::= literal */ yytestcase(yyruleno==711);
#line 545 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = new ValueExpression(yymsp[0].minor.yy1200); }
#line 8686 "../LemonSrc/SQLParserL.c"
        break;
      case 84: /* noTypeValueSpecification ::= NULL */
#line 571 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = ValueExpression::nullExpression();   yy_destructor(yypParser,52,&yymsp[0].minor);
}
#line 8692 "../LemonSrc/SQLParserL.c"
        break;
      case 85: /* noTypeValueSpecification ::= DEFAULT */
#line 573 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = ValueExpression::defaultExpression();   yy_destructor(yypParser,53,&yymsp[0].minor);
}
#line 8698 "../LemonSrc/SQLParserL.c"
        break;
      case 88: /* placeHolder ::= QUESTION_MARK */
#line 585 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Placeholder,
									 new IntegerValue(yymsp[0].minor.yy0->getInteger()),
									 ValueExpression::Unknown,
									 ValueExpression::type_Value);
		delete yymsp[0].minor.yy0;
	}
#line 8709 "../LemonSrc/SQLParserL.c"
        break;
      case 89: /* generalValueSpecification ::= itemReference */
      case 494: /* singleElementFulltextOperand ::= itemReference */ yytestcase(yyruleno==494);
#line 598 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Itemref, yymsp[0].minor.yy85,
									 ValueExpression::Unknown,
									 ValueExpression::type_SingleColumn);
	}
#line 8719 "../LemonSrc/SQLParserL.c"
        break;
      case 90: /* generalValueSpecification ::= USER */
#line 604 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Func,
									 ValueExpression::func_User,
									 ValueExpression::CharString, 0, 0,
									 ValueExpression::type_Value);
	  yy_destructor(yypParser,55,&yymsp[0].minor);
}
#line 8730 "../LemonSrc/SQLParserL.c"
        break;
      case 91: /* generalValueSpecification ::= CURRENT_USER */
#line 612 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Func,
									 ValueExpression::func_Current_User,
									 ValueExpression::CharString, 0, 0,
									 ValueExpression::type_Value);
	  yy_destructor(yypParser,56,&yymsp[0].minor);
}
#line 8741 "../LemonSrc/SQLParserL.c"
        break;
      case 92: /* generalValueSpecification ::= SESSION_USER */
#line 620 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Func,
									 ValueExpression::func_Session_User,
									 ValueExpression::CharString, 0, 0,
									 ValueExpression::type_Value);
	  yy_destructor(yypParser,57,&yymsp[0].minor);
}
#line 8752 "../LemonSrc/SQLParserL.c"
        break;
      case 93: /* generalValueSpecification ::= CURRENT_PATH */
#line 628 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Func,
									 ValueExpression::func_Current_Path,
									 ValueExpression::CharString, 0, 0,
									 ValueExpression::type_Value);
	  yy_destructor(yypParser,58,&yymsp[0].minor);
}
#line 8763 "../LemonSrc/SQLParserL.c"
        break;
      case 94: /* itemReference ::= itemQualifier PERIOD identifier */
#line 641 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy85 = new ItemReference(yymsp[-2].minor.yy1118, yymsp[0].minor.yy1118);
	  yy_destructor(yypParser,59,&yymsp[-1].minor);
}
#line 8771 "../LemonSrc/SQLParserL.c"
        break;
      case 95: /* itemReference ::= identifier */
#line 646 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy85 = new ItemReference(0, yymsp[0].minor.yy1118);
	}
#line 8778 "../LemonSrc/SQLParserL.c"
        break;
      case 96: /* itemQualifier ::= tableName */
      case 769: /* defArea ::= areaName */ yytestcase(yyruleno==769);
      case 828: /* areaName ::= identifier */ yytestcase(yyruleno==828);
#line 655 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1118 = yymsp[0].minor.yy1118; }
#line 8785 "../LemonSrc/SQLParserL.c"
        break;
      case 97: /* elementReference ::= arrayValueOperand LEFT_BRACKET exactNumericLiteral RIGHT_BRACKET */
#line 666 "../LemonSrc/SQLParserL.lemon"
{
		ValueExpression * right = new ValueExpression(yymsp[-1].minor.yy1200);

		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Arrayref,
									 yymsp[-3].minor.yy584, right);
	  yy_destructor(yypParser,60,&yymsp[-2].minor);
  yy_destructor(yypParser,61,&yymsp[0].minor);
}
#line 8797 "../LemonSrc/SQLParserL.c"
        break;
      case 98: /* elementReference ::= anyElementReference */
#line 673 "../LemonSrc/SQLParserL.lemon"
{
	   yygotominor.yy1172 = yymsp[0].minor.yy1172; 
   }
#line 8804 "../LemonSrc/SQLParserL.c"
        break;
      case 99: /* anyElementReference ::= arrayValueOperand LEFT_BRACKET RIGHT_BRACKET */
#line 685 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Arrayref,
									 yymsp[-2].minor.yy584);
	  yy_destructor(yypParser,60,&yymsp[-1].minor);
  yy_destructor(yypParser,61,&yymsp[0].minor);
}
#line 8814 "../LemonSrc/SQLParserL.c"
        break;
      case 100: /* queryExpression ::= queryExpressionBody optionalSortSpecificationList optionalLimitSpecification hint */
#line 700 "../LemonSrc/SQLParserL.lemon"
{
		if (yymsp[-2].minor.yy640) {
			yymsp[-3].minor.yy533->setSortSpecification(yymsp[-2].minor.yy640);
		}
		if (yymsp[-1].minor.yy579) {
			yymsp[-3].minor.yy533->setLimitSpecification(yymsp[-1].minor.yy579);
		}
		if (yymsp[0].minor.yy858) {
			yymsp[-3].minor.yy533->setHint(yymsp[0].minor.yy858);
		}
		yygotominor.yy533 = yymsp[-3].minor.yy533;
	}
#line 8830 "../LemonSrc/SQLParserL.c"
        break;
      case 101: /* queryExpressionBody ::= queryTerm */
#line 719 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy533 = new QueryExpression(yymsp[0].minor.yy934);
	}
#line 8837 "../LemonSrc/SQLParserL.c"
        break;
      case 102: /* queryExpressionBody ::= queryExpressionBody queryOperator queryTerm */
#line 724 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy533 = new QueryExpression(yymsp[-1].minor.yy1313, yymsp[-2].minor.yy533, yymsp[0].minor.yy934);
	}
#line 8844 "../LemonSrc/SQLParserL.c"
        break;
      case 103: /* queryOperator ::= UNION optionalAll optionalCorrespondingSpec */
#line 734 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1313 = new QueryOperator(QueryOperator::Union, yymsp[-1].minor.yy764, yymsp[0].minor.yy1234);
	  yy_destructor(yypParser,2,&yymsp[-2].minor);
}
#line 8852 "../LemonSrc/SQLParserL.c"
        break;
      case 104: /* queryOperator ::= EXCEPT optionalAll optionalCorrespondingSpec */
#line 739 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1313 = new QueryOperator(QueryOperator::Except, yymsp[-1].minor.yy764, yymsp[0].minor.yy1234);
	  yy_destructor(yypParser,3,&yymsp[-2].minor);
}
#line 8860 "../LemonSrc/SQLParserL.c"
        break;
      case 105: /* queryOperator ::= INTERSECT optionalAll optionalCorrespondingSpec */
#line 744 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1313 = new QueryOperator(QueryOperator::Intersect, yymsp[-1].minor.yy764, yymsp[0].minor.yy1234);
	  yy_destructor(yypParser,4,&yymsp[-2].minor);
}
#line 8868 "../LemonSrc/SQLParserL.c"
        break;
      case 106: /* optionalAll ::= */
      case 127: /* optionalSetQuantifier ::= */ yytestcase(yyruleno==127);
#line 753 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy764 = ValueExpression::quant_None;
	}
#line 8876 "../LemonSrc/SQLParserL.c"
        break;
      case 107: /* optionalAll ::= ALL */
      case 128: /* optionalSetQuantifier ::= ALL */ yytestcase(yyruleno==128);
#line 758 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy764 = ValueExpression::quant_All;
	  yy_destructor(yypParser,62,&yymsp[0].minor);
}
#line 8885 "../LemonSrc/SQLParserL.c"
        break;
      case 108: /* optionalAll ::= DISTINCT */
      case 129: /* optionalSetQuantifier ::= DISTINCT */ yytestcase(yyruleno==129);
#line 763 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy764 = ValueExpression::quant_Distinct;
	  yy_destructor(yypParser,63,&yymsp[0].minor);
}
#line 8894 "../LemonSrc/SQLParserL.c"
        break;
      case 109: /* optionalCorrespondingSpec ::= */
      case 112: /* optionalByCorrespondingColumnList ::= */ yytestcase(yyruleno==112);
      case 733: /* referencedColumnName ::= */ yytestcase(yyruleno==733);
#line 773 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1234 = 0; }
#line 8901 "../LemonSrc/SQLParserL.c"
        break;
      case 110: /* optionalCorrespondingSpec ::= correspondingSpec */
      case 114: /* correspondingColumnList ::= columnNameList */ yytestcase(yyruleno==114);
#line 776 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1234 = yymsp[0].minor.yy1234; }
#line 8907 "../LemonSrc/SQLParserL.c"
        break;
      case 111: /* correspondingSpec ::= CORRESPONDING optionalByCorrespondingColumnList */
#line 781 "../LemonSrc/SQLParserL.lemon"
{
		if (!yymsp[0].minor.yy1234) {
			yygotominor.yy1234 = new ColumnNameList;
		} else {
			yygotominor.yy1234 = yymsp[0].minor.yy1234;
		}
	  yy_destructor(yypParser,64,&yymsp[-1].minor);
}
#line 8919 "../LemonSrc/SQLParserL.c"
        break;
      case 113: /* optionalByCorrespondingColumnList ::= BY LEFT_PARENTHESIS correspondingColumnList RIGHT_PARENTHESIS */
#line 798 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1234 = yymsp[-1].minor.yy1234;   yy_destructor(yypParser,65,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 8927 "../LemonSrc/SQLParserL.c"
        break;
      case 115: /* columnNameList ::= columnName */
#line 811 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1234 = new ColumnNameList(yymsp[0].minor.yy370);
	}
#line 8934 "../LemonSrc/SQLParserL.c"
        break;
      case 116: /* columnNameList ::= columnNameList COMMA columnName */
#line 816 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-2].minor.yy1234->append(yymsp[0].minor.yy370);
		yygotominor.yy1234 = yymsp[-2].minor.yy1234;
	  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 8943 "../LemonSrc/SQLParserL.c"
        break;
      case 117: /* columnNameList ::= columnNameList COMMA */
#line 822 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1234 = yymsp[-1].minor.yy1234;   yy_destructor(yypParser,13,&yymsp[0].minor);
}
#line 8949 "../LemonSrc/SQLParserL.c"
        break;
      case 120: /* nonJoinQueryPrimary ::= simpleTable */
      case 158: /* tableReference ::= joinedTable */ yytestcase(yyruleno==158);
#line 846 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy934 = yymsp[0].minor.yy934;
	}
#line 8957 "../LemonSrc/SQLParserL.c"
        break;
      case 121: /* nonJoinQueryPrimary ::= LEFT_PARENTHESIS queryExpression RIGHT_PARENTHESIS */
#line 851 "../LemonSrc/SQLParserL.lemon"
{
		//	check the queryExpression is NOT joined table
		yygotominor.yy934 = yymsp[-1].minor.yy533;
	  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 8967 "../LemonSrc/SQLParserL.c"
        break;
      case 122: /* simpleTable ::= querySpecification */
#line 862 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy1078; }
#line 8972 "../LemonSrc/SQLParserL.c"
        break;
      case 123: /* simpleTable ::= tableValueConstructor */
#line 865 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy1172; }
#line 8977 "../LemonSrc/SQLParserL.c"
        break;
      case 125: /* querySpecification ::= SELECT optionalSetQuantifier selectList optionalBulkOutput tableExpression */
#line 879 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1078 = new QuerySpecification(yymsp[-3].minor.yy764, yymsp[-2].minor.yy587, yymsp[0].minor.yy415, yymsp[-1].minor.yy707);
	  yy_destructor(yypParser,68,&yymsp[-4].minor);
}
#line 8985 "../LemonSrc/SQLParserL.c"
        break;
      case 126: /* querySpecification ::= SELECT optionalSetQuantifier selectList INTO selectTargetList tableExpression */
#line 887 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1078 = new QuerySpecification(yymsp[-4].minor.yy764, yymsp[-3].minor.yy587, yymsp[0].minor.yy415, 0, yymsp[-1].minor.yy82);	   
	  yy_destructor(yypParser,68,&yymsp[-5].minor);
  yy_destructor(yypParser,69,&yymsp[-2].minor);
}
#line 8994 "../LemonSrc/SQLParserL.c"
        break;
      case 130: /* selectList ::= ASTERISK */
#line 917 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy587 = SelectList::asterisk();
	  yy_destructor(yypParser,40,&yymsp[0].minor);
}
#line 9002 "../LemonSrc/SQLParserL.c"
        break;
      case 131: /* selectList ::= selectSubListList */
#line 922 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy587 = new SelectList(yymsp[0].minor.yy57);
	}
#line 9009 "../LemonSrc/SQLParserL.c"
        break;
      case 132: /* selectSubListList ::= selectSubList */
#line 932 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy57 = new SelectSubListList(yymsp[0].minor.yy329);
	}
#line 9016 "../LemonSrc/SQLParserL.c"
        break;
      case 133: /* selectSubListList ::= selectSubListList COMMA selectSubList */
#line 937 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-2].minor.yy57->append(yymsp[0].minor.yy329);
		yymsp[-2].minor.yy57->mergeExpressionType(yymsp[0].minor.yy329->getExpressionType());
		yygotominor.yy57 = yymsp[-2].minor.yy57;
	  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 9026 "../LemonSrc/SQLParserL.c"
        break;
      case 134: /* selectSubListList ::= selectSubListList COMMA */
#line 944 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy57 = yymsp[-1].minor.yy57;   yy_destructor(yypParser,13,&yymsp[0].minor);
}
#line 9032 "../LemonSrc/SQLParserL.c"
        break;
      case 135: /* selectSubList ::= derivedColumn */
#line 952 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy329 = new SelectSubList(yymsp[0].minor.yy1268);
	}
#line 9039 "../LemonSrc/SQLParserL.c"
        break;
      case 136: /* selectSubList ::= itemQualifier PERIOD ASTERISK */
#line 957 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy329 = new SelectSubList(yymsp[-2].minor.yy1118);
	  yy_destructor(yypParser,59,&yymsp[-1].minor);
  yy_destructor(yypParser,40,&yymsp[0].minor);
}
#line 9048 "../LemonSrc/SQLParserL.c"
        break;
      case 137: /* selectTargetList ::= variableName */
#line 968 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy82 = new SelectTargetList(yymsp[0].minor.yy278);
	}
#line 9055 "../LemonSrc/SQLParserL.c"
        break;
      case 138: /* selectTargetList ::= selectTargetList COMMA variableName */
#line 972 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-2].minor.yy82->append(yymsp[0].minor.yy278);
		yygotominor.yy82 = yymsp[-2].minor.yy82;
	  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 9064 "../LemonSrc/SQLParserL.c"
        break;
      case 139: /* derivedColumn ::= nonPredicateValueExpression */
#line 984 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1268 = new DerivedColumn(yymsp[0].minor.yy1172, 0);
	}
#line 9071 "../LemonSrc/SQLParserL.c"
        break;
      case 140: /* derivedColumn ::= nonPredicateValueExpression columnName */
#line 989 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1268 = new DerivedColumn(yymsp[-1].minor.yy1172, yymsp[0].minor.yy370);
	}
#line 9078 "../LemonSrc/SQLParserL.c"
        break;
      case 141: /* derivedColumn ::= nonPredicateValueExpression AS columnName */
#line 994 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1268 = new DerivedColumn(yymsp[-2].minor.yy1172, yymsp[0].minor.yy370);
	  yy_destructor(yypParser,70,&yymsp[-1].minor);
}
#line 9086 "../LemonSrc/SQLParserL.c"
        break;
      case 142: /* optionalBulkOutput ::= */
#line 1005 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy707 = 0;
	}
#line 9093 "../LemonSrc/SQLParserL.c"
        break;
      case 143: /* optionalBulkOutput ::= OUTPUT TO bulkSpecification */
#line 1009 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[0].minor.yy707->setInput(false);
		yygotominor.yy707 = yymsp[0].minor.yy707;
	  yy_destructor(yypParser,71,&yymsp[-2].minor);
  yy_destructor(yypParser,72,&yymsp[-1].minor);
}
#line 9103 "../LemonSrc/SQLParserL.c"
        break;
      case 144: /* bulkSpecification ::= inputData optionalWithClause optionalBulkHint */
#line 1021 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy707 = new BulkSpecification(yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1172);
	}
#line 9110 "../LemonSrc/SQLParserL.c"
        break;
      case 145: /* inputData ::= PATH pathName */
      case 148: /* withClause ::= PATH pathName */ yytestcase(yyruleno==148);
#line 1032 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(yymsp[0].minor.yy1200);
		yygotominor.yy1172->setOperator(ValueExpression::op_PathName);
	  yy_destructor(yypParser,73,&yymsp[-1].minor);
}
#line 9120 "../LemonSrc/SQLParserL.c"
        break;
      case 146: /* optionalWithClause ::= */
      case 149: /* optionalBulkHint ::= */ yytestcase(yyruleno==149);
      case 195: /* optionalWhereClause ::= */ yytestcase(yyruleno==195);
#line 1044 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = 0;
	}
#line 9129 "../LemonSrc/SQLParserL.c"
        break;
      case 147: /* optionalWithClause ::= WITH withClause */
#line 1048 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = yymsp[0].minor.yy1172;
	  yy_destructor(yypParser,74,&yymsp[-1].minor);
}
#line 9137 "../LemonSrc/SQLParserL.c"
        break;
      case 150: /* optionalBulkHint ::= bulkHint */
      case 196: /* optionalWhereClause ::= whereClause */ yytestcase(yyruleno==196);
      case 392: /* nonPredicateValueExpression ::= rowValueExpression */ yytestcase(yyruleno==392);
      case 435: /* numericValueFunction ::= score */ yytestcase(yyruleno==435);
      case 910: /* hostName ::= stringValueSpecification */ yytestcase(yyruleno==910);
      case 911: /* portNumber ::= numericValueSpecification */ yytestcase(yyruleno==911);
#line 1072 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = yymsp[0].minor.yy1172;
	}
#line 9149 "../LemonSrc/SQLParserL.c"
        break;
      case 151: /* bulkHint ::= HINT valueSpecification */
#line 1080 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = yymsp[0].minor.yy1172;
	  yy_destructor(yypParser,75,&yymsp[-1].minor);
}
#line 9157 "../LemonSrc/SQLParserL.c"
        break;
      case 152: /* tableExpression ::= fromClause optionalWhereClause optionalGroupByClause optionalHavingClause */
#line 1091 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy415 = new TableExpression(yymsp[-3].minor.yy178, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy244, yymsp[0].minor.yy729);
	}
#line 9164 "../LemonSrc/SQLParserL.c"
        break;
      case 153: /* fromClause ::= FROM tableReferenceList */
#line 1101 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy178 = yymsp[0].minor.yy178;
	  yy_destructor(yypParser,76,&yymsp[-1].minor);
}
#line 9172 "../LemonSrc/SQLParserL.c"
        break;
      case 154: /* tableReferenceList ::= tableReference */
#line 1111 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy178 = new TableReferenceList(yymsp[0].minor.yy934);
	}
#line 9179 "../LemonSrc/SQLParserL.c"
        break;
      case 155: /* tableReferenceList ::= tableReferenceList COMMA tableReference */
#line 1116 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-2].minor.yy178->append(yymsp[0].minor.yy934);
		yygotominor.yy178 = yymsp[-2].minor.yy178;
	  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 9188 "../LemonSrc/SQLParserL.c"
        break;
      case 156: /* tableReferenceList ::= tableReferenceList COMMA */
#line 1122 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy178 = yymsp[-1].minor.yy178;   yy_destructor(yypParser,13,&yymsp[0].minor);
}
#line 9194 "../LemonSrc/SQLParserL.c"
        break;
      case 157: /* tableReference ::= tablePrimary */
#line 1130 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy934 = yymsp[0].minor.yy183;
	}
#line 9201 "../LemonSrc/SQLParserL.c"
        break;
      case 159: /* tablePrimary ::= tableName tableCorrelationSpec */
#line 1145 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy183 = new TablePrimary(yymsp[-1].minor.yy1118, yymsp[0].minor.yy272->getCorrelation(), yymsp[0].minor.yy272->getDerived());
		// 下位オブジェクトは使う。corだけを解放
		yymsp[0].minor.yy272->clearBody();
		delete yymsp[0].minor.yy272;
	}
#line 9211 "../LemonSrc/SQLParserL.c"
        break;
      case 160: /* tablePrimary ::= tableName */
#line 1153 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy183 = new TablePrimary(yymsp[0].minor.yy1118, 0, 0);
	}
#line 9218 "../LemonSrc/SQLParserL.c"
        break;
      case 161: /* tablePrimary ::= derivedTable tableCorrelationSpec */
#line 1157 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy183 = new TablePrimary(yymsp[-1].minor.yy533, yymsp[0].minor.yy272->getCorrelation(), yymsp[0].minor.yy272->getDerived());
		// 下位オブジェクトは使う。corだけを解放
		yymsp[0].minor.yy272->clearBody();
		delete yymsp[0].minor.yy272;
	}
#line 9228 "../LemonSrc/SQLParserL.c"
        break;
      case 162: /* tablePrimary ::= LEFT_PARENTHESIS joinedTable RIGHT_PARENTHESIS */
#line 1164 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy183 = new TablePrimary(TablePrimary::Type::JoinedTable, yymsp[-1].minor.yy934);
	  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 9237 "../LemonSrc/SQLParserL.c"
        break;
      case 163: /* tablePrimary ::= collectionDerivedTable tableCorrelationSpec */
#line 1168 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy183 = new TablePrimary(yymsp[-1].minor.yy1172, yymsp[0].minor.yy272->getCorrelation(), yymsp[0].minor.yy272->getDerived());
		// 下位オブジェクトは使う。corだけを解放
		yymsp[0].minor.yy272->clearBody();
		delete yymsp[0].minor.yy272;
	}
#line 9247 "../LemonSrc/SQLParserL.c"
        break;
      case 164: /* tablePrimary ::= INPUT FOR tableName FROM bulkSpecification */
#line 1176 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[0].minor.yy707->setInput(true);
		yygotominor.yy183 = new TablePrimary(TablePrimary::Type::Bulk, yymsp[0].minor.yy707);
		yygotominor.yy183->setCorrelationName(yymsp[-2].minor.yy1118);
	  yy_destructor(yypParser,77,&yymsp[-4].minor);
  yy_destructor(yypParser,78,&yymsp[-3].minor);
  yy_destructor(yypParser,76,&yymsp[-1].minor);
}
#line 9259 "../LemonSrc/SQLParserL.c"
        break;
      case 165: /* tableCorrelationSpec ::= asCorrelationName optionalDerivedColumnList */
#line 1188 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy272 = new TableCorrelationSpec(yymsp[-1].minor.yy1118, yymsp[0].minor.yy1234);
	}
#line 9266 "../LemonSrc/SQLParserL.c"
        break;
      case 166: /* asCorrelationName ::= AS identifier */
#line 1198 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1118 = yymsp[0].minor.yy1118;
	  yy_destructor(yypParser,70,&yymsp[-1].minor);
}
#line 9274 "../LemonSrc/SQLParserL.c"
        break;
      case 168: /* optionalDerivedColumnList ::= */
#line 1212 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1234 = 0;
	}
#line 9281 "../LemonSrc/SQLParserL.c"
        break;
      case 169: /* optionalDerivedColumnList ::= LEFT_PARENTHESIS derivedColumnList RIGHT_PARENTHESIS */
      case 564: /* updateTargetList ::= LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS */ yytestcase(yyruleno==564);
#line 1216 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1234 = yymsp[-1].minor.yy1234;
	  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 9291 "../LemonSrc/SQLParserL.c"
        break;
      case 170: /* derivedColumnList ::= columnNameList */
#line 1223 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1234 = yymsp[0].minor.yy1234;
	}
#line 9298 "../LemonSrc/SQLParserL.c"
        break;
      case 171: /* derivedTable ::= tableSubquery */
      case 254: /* inPredicateSubquery ::= tableSubquery */ yytestcase(yyruleno==254);
#line 1233 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy533 = yymsp[0].minor.yy533;
	}
#line 9306 "../LemonSrc/SQLParserL.c"
        break;
      case 172: /* tableSubquery ::= subquery */
#line 1243 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy533 = yymsp[0].minor.yy533; }
#line 9311 "../LemonSrc/SQLParserL.c"
        break;
      case 173: /* rowSubquery ::= subquery */
#line 1251 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_RowSubquery,
									 yymsp[0].minor.yy533,
									 ValueExpression::Unknown,
									 ValueExpression::type_Unknown);
	}
#line 9321 "../LemonSrc/SQLParserL.c"
        break;
      case 174: /* subquery ::= LEFT_PARENTHESIS queryExpression RIGHT_PARENTHESIS */
#line 1261 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy533 = yymsp[-1].minor.yy533;   yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 9328 "../LemonSrc/SQLParserL.c"
        break;
      case 176: /* joinedTable ::= qualifiedJoin */
      case 177: /* joinedTable ::= naturalJoin */ yytestcase(yyruleno==177);
#line 1271 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy1083; }
#line 9334 "../LemonSrc/SQLParserL.c"
        break;
      case 178: /* joinedTable ::= existsJoin */
#line 1276 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy1255; }
#line 9339 "../LemonSrc/SQLParserL.c"
        break;
      case 179: /* crossJoin ::= tableReference CROSS JOIN tablePrimary */
#line 1284 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy934 = new CrossJoin(yymsp[-3].minor.yy934, yymsp[0].minor.yy183);
	  yy_destructor(yypParser,11,&yymsp[-2].minor);
  yy_destructor(yypParser,5,&yymsp[-1].minor);
}
#line 9348 "../LemonSrc/SQLParserL.c"
        break;
      case 180: /* qualifiedJoin ::= tableReference optionalJoinType JOIN tableReference joinSpecification */
#line 1296 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1083 = new QualifiedJoin(yymsp[-3].minor.yy880, yymsp[-4].minor.yy934, yymsp[-1].minor.yy934, yymsp[0].minor.yy934);
	  yy_destructor(yypParser,5,&yymsp[-2].minor);
}
#line 9356 "../LemonSrc/SQLParserL.c"
        break;
      case 181: /* optionalJoinType ::= */
#line 1305 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy880 = JoinType::Inner; }
#line 9361 "../LemonSrc/SQLParserL.c"
        break;
      case 182: /* optionalJoinType ::= INNER */
#line 1307 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy880 = JoinType::Inner;   yy_destructor(yypParser,6,&yymsp[0].minor);
}
#line 9367 "../LemonSrc/SQLParserL.c"
        break;
      case 183: /* optionalJoinType ::= LEFT */
#line 1309 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy880 = JoinType::Left;   yy_destructor(yypParser,7,&yymsp[0].minor);
}
#line 9373 "../LemonSrc/SQLParserL.c"
        break;
      case 184: /* optionalJoinType ::= LEFT OUTER */
#line 1311 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy880 = JoinType::Left;   yy_destructor(yypParser,7,&yymsp[-1].minor);
  yy_destructor(yypParser,79,&yymsp[0].minor);
}
#line 9380 "../LemonSrc/SQLParserL.c"
        break;
      case 185: /* optionalJoinType ::= RIGHT */
#line 1313 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy880 = JoinType::Right;   yy_destructor(yypParser,8,&yymsp[0].minor);
}
#line 9386 "../LemonSrc/SQLParserL.c"
        break;
      case 186: /* optionalJoinType ::= RIGHT OUTER */
#line 1315 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy880 = JoinType::Right;   yy_destructor(yypParser,8,&yymsp[-1].minor);
  yy_destructor(yypParser,79,&yymsp[0].minor);
}
#line 9393 "../LemonSrc/SQLParserL.c"
        break;
      case 187: /* optionalJoinType ::= FULL */
#line 1317 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy880 = JoinType::Full;   yy_destructor(yypParser,9,&yymsp[0].minor);
}
#line 9399 "../LemonSrc/SQLParserL.c"
        break;
      case 188: /* optionalJoinType ::= FULL OUTER */
#line 1319 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy880 = JoinType::Full;   yy_destructor(yypParser,9,&yymsp[-1].minor);
  yy_destructor(yypParser,79,&yymsp[0].minor);
}
#line 9406 "../LemonSrc/SQLParserL.c"
        break;
      case 189: /* joinSpecification ::= ON searchCondition */
#line 1327 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy934 = yymsp[0].minor.yy1172;
	  yy_destructor(yypParser,12,&yymsp[-1].minor);
}
#line 9414 "../LemonSrc/SQLParserL.c"
        break;
      case 190: /* joinSpecification ::= USING LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS */
#line 1331 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy934 = yymsp[-1].minor.yy1234;
	  yy_destructor(yypParser,33,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 9424 "../LemonSrc/SQLParserL.c"
        break;
      case 191: /* naturalJoin ::= tableReference NATURAL optionalJoinType JOIN tablePrimary */
#line 1343 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1083 = new QualifiedJoin(yymsp[-2].minor.yy880, yymsp[-4].minor.yy934, yymsp[0].minor.yy183, 0);
	  yy_destructor(yypParser,10,&yymsp[-3].minor);
  yy_destructor(yypParser,5,&yymsp[-1].minor);
}
#line 9433 "../LemonSrc/SQLParserL.c"
        break;
      case 192: /* existsJoin ::= tableReference EXISTS JOIN tablePrimary ON searchCondition */
#line 1356 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1255 = new ExistsJoin(yymsp[-5].minor.yy934, yymsp[-2].minor.yy183, yymsp[0].minor.yy1172, true);
	  yy_destructor(yypParser,80,&yymsp[-4].minor);
  yy_destructor(yypParser,5,&yymsp[-3].minor);
  yy_destructor(yypParser,12,&yymsp[-1].minor);
}
#line 9443 "../LemonSrc/SQLParserL.c"
        break;
      case 193: /* existsJoin ::= tableReference NOT EXISTS JOIN tablePrimary ON searchCondition */
#line 1361 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1255 = new ExistsJoin(yymsp[-6].minor.yy934, yymsp[-2].minor.yy183, yymsp[0].minor.yy1172, false);
	  yy_destructor(yypParser,16,&yymsp[-5].minor);
  yy_destructor(yypParser,80,&yymsp[-4].minor);
  yy_destructor(yypParser,5,&yymsp[-3].minor);
  yy_destructor(yypParser,12,&yymsp[-1].minor);
}
#line 9454 "../LemonSrc/SQLParserL.c"
        break;
      case 194: /* collectionDerivedTable ::= UNNEST LEFT_PARENTHESIS arrayValueOperand RIGHT_PARENTHESIS */
#line 1371 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = yymsp[-1].minor.yy584;
	  yy_destructor(yypParser,81,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 9464 "../LemonSrc/SQLParserL.c"
        break;
      case 197: /* whereClause ::= WHERE searchCondition */
#line 1393 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = yymsp[0].minor.yy1172;
	  yy_destructor(yypParser,82,&yymsp[-1].minor);
}
#line 9472 "../LemonSrc/SQLParserL.c"
        break;
      case 199: /* optionalGroupByClause ::= */
#line 1411 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy244 = 0;
	}
#line 9479 "../LemonSrc/SQLParserL.c"
        break;
      case 200: /* optionalGroupByClause ::= groupByClause */
#line 1416 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy244 = yymsp[0].minor.yy244;
	}
#line 9486 "../LemonSrc/SQLParserL.c"
        break;
      case 201: /* groupByClause ::= GROUP BY groupingElementList */
#line 1423 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy244 = new GroupByClause(yymsp[0].minor.yy604);
	  yy_destructor(yypParser,83,&yymsp[-2].minor);
  yy_destructor(yypParser,65,&yymsp[-1].minor);
}
#line 9495 "../LemonSrc/SQLParserL.c"
        break;
      case 202: /* groupingElementList ::= groupingElement */
#line 1433 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy604 = new GroupingElementList(yymsp[0].minor.yy934);
	}
#line 9502 "../LemonSrc/SQLParserL.c"
        break;
      case 203: /* groupingElementList ::= groupingElementList COMMA groupingElement */
#line 1439 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-2].minor.yy604->addElement(yymsp[0].minor.yy934); // yymsp[0].minor.yy934 might be deleted
		yygotominor.yy604 = yymsp[-2].minor.yy604;
	  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 9511 "../LemonSrc/SQLParserL.c"
        break;
      case 204: /* groupingElement ::= groupingColumnReference */
#line 1450 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy934 = new GroupingColumnReferenceList(yymsp[0].minor.yy1215);
	}
#line 9518 "../LemonSrc/SQLParserL.c"
        break;
      case 205: /* groupingElement ::= LEFT_PARENTHESIS groupingColumnReferenceList RIGHT_PARENTHESIS */
#line 1455 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy934 = yymsp[-1].minor.yy511;
	  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 9527 "../LemonSrc/SQLParserL.c"
        break;
      case 206: /* groupingElement ::= LEFT_PARENTHESIS RIGHT_PARENTHESIS */
#line 1459 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy934 = new GroupingColumnReferenceList();
	  yy_destructor(yypParser,66,&yymsp[-1].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 9536 "../LemonSrc/SQLParserL.c"
        break;
      case 207: /* groupingColumnReferenceList ::= groupingColumnReference */
#line 1469 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy511 = new GroupingColumnReferenceList(yymsp[0].minor.yy1215);
	}
#line 9543 "../LemonSrc/SQLParserL.c"
        break;
      case 208: /* groupingColumnReferenceList ::= groupingColumnReferenceList COMMA groupingColumnReference */
#line 1475 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-2].minor.yy511->append(yymsp[0].minor.yy1215);
		yygotominor.yy511 = yymsp[-2].minor.yy511;
	  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 9552 "../LemonSrc/SQLParserL.c"
        break;
      case 209: /* groupingColumnReference ::= itemReference */
#line 1486 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1215 = new GroupingColumnReference(yymsp[0].minor.yy85);
	}
#line 9559 "../LemonSrc/SQLParserL.c"
        break;
      case 210: /* groupingColumnReference ::= itemReference LEFT_BRACKET RIGHT_BRACKET */
#line 1493 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<ValueExpression> pItemReference =
			new ValueExpression(ValueExpression::op_Itemref, yymsp[-2].minor.yy85,
								ValueExpression::Unknown,
								ValueExpression::type_SingleColumn);
		ModAutoPointer<ValueExpression> pArrayRef =
			new ValueExpression(ValueExpression::op_Arrayref,
								pItemReference.release());
		yygotominor.yy1215 = new GroupingColumnReference(pArrayRef.release());
	  yy_destructor(yypParser,60,&yymsp[-1].minor);
  yy_destructor(yypParser,61,&yymsp[0].minor);
}
#line 9575 "../LemonSrc/SQLParserL.c"
        break;
      case 211: /* optionalHavingClause ::= */
#line 1510 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy729 = 0;
	}
#line 9582 "../LemonSrc/SQLParserL.c"
        break;
      case 212: /* optionalHavingClause ::= havingClause */
#line 1515 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy729 = yymsp[0].minor.yy729;
	}
#line 9589 "../LemonSrc/SQLParserL.c"
        break;
      case 213: /* havingClause ::= HAVING searchCondition */
#line 1522 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy729 = new HavingClause(yymsp[0].minor.yy1172);
	  yy_destructor(yypParser,84,&yymsp[-1].minor);
}
#line 9597 "../LemonSrc/SQLParserL.c"
        break;
      case 214: /* optionalSortSpecificationList ::= */
#line 1532 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy640 = 0; }
#line 9602 "../LemonSrc/SQLParserL.c"
        break;
      case 215: /* optionalSortSpecificationList ::= ORDER BY sortSpecificationList optionalPartitionBy */
#line 1534 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-1].minor.yy640->setPartitionBy(yymsp[0].minor.yy1172);
		yygotominor.yy640 = yymsp[-1].minor.yy640;
	  yy_destructor(yypParser,85,&yymsp[-3].minor);
  yy_destructor(yypParser,65,&yymsp[-2].minor);
}
#line 9612 "../LemonSrc/SQLParserL.c"
        break;
      case 216: /* sortSpecificationList ::= sortSpecification */
#line 1542 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy640 = new SortSpecificationList(yymsp[0].minor.yy816);
	}
#line 9619 "../LemonSrc/SQLParserL.c"
        break;
      case 217: /* sortSpecificationList ::= sortSpecificationList COMMA sortSpecification */
#line 1547 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-2].minor.yy640->append(yymsp[0].minor.yy816);
		yygotominor.yy640 = yymsp[-2].minor.yy640;
	  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 9628 "../LemonSrc/SQLParserL.c"
        break;
      case 218: /* sortSpecification ::= nonPredicateValueExpression orderingSpecification */
#line 1558 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy816 =  new SortSpecification(yymsp[-1].minor.yy1172, yymsp[0].minor.yy764);
	}
#line 9635 "../LemonSrc/SQLParserL.c"
        break;
      case 219: /* orderingSpecification ::= ASC */
#line 1567 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = SortSpecification::Ascending;   yy_destructor(yypParser,86,&yymsp[0].minor);
}
#line 9641 "../LemonSrc/SQLParserL.c"
        break;
      case 220: /* orderingSpecification ::= DESC */
#line 1570 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = SortSpecification::Descending;   yy_destructor(yypParser,87,&yymsp[0].minor);
}
#line 9647 "../LemonSrc/SQLParserL.c"
        break;
      case 221: /* orderingSpecification ::= */
#line 1573 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = SortSpecification::Ascending; }
#line 9652 "../LemonSrc/SQLParserL.c"
        break;
      case 222: /* optionalPartitionBy ::= */
      case 702: /* optionalDefaultClause ::= */ yytestcase(yyruleno==702);
#line 1581 "../LemonSrc/SQLParserL.lemon"
{yygotominor.yy1172 = 0;}
#line 9658 "../LemonSrc/SQLParserL.c"
        break;
      case 223: /* optionalPartitionBy ::= PARTITION BY nonPredicateValueExpression */
#line 1583 "../LemonSrc/SQLParserL.lemon"
{yygotominor.yy1172 = yymsp[0].minor.yy1172;  yy_destructor(yypParser,88,&yymsp[-2].minor);
  yy_destructor(yypParser,65,&yymsp[-1].minor);
}
#line 9665 "../LemonSrc/SQLParserL.c"
        break;
      case 224: /* optionalLimitSpecification ::= */
#line 1591 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy579 = 0; }
#line 9670 "../LemonSrc/SQLParserL.c"
        break;
      case 225: /* optionalLimitSpecification ::= limitSpecification */
#line 1593 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy579 = new LimitSpecification(yymsp[0].minor.yy1172);
	}
#line 9677 "../LemonSrc/SQLParserL.c"
        break;
      case 226: /* optionalLimitSpecification ::= limitSpecification OFFSET numericValueOperand */
#line 1597 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy579 = new LimitSpecification(yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172);
	  yy_destructor(yypParser,89,&yymsp[-1].minor);
}
#line 9685 "../LemonSrc/SQLParserL.c"
        break;
      case 227: /* limitSpecification ::= LIMIT numericValueOperand */
#line 1604 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,90,&yymsp[-1].minor);
}
#line 9691 "../LemonSrc/SQLParserL.c"
        break;
      case 229: /* predicateValueExpression ::= LEFT_PARENTHESIS predicateValueExpression RIGHT_PARENTHESIS */
      case 519: /* rowRowValueExpression ::= LEFT_PARENTHESIS rowValueExpressionPrimary RIGHT_PARENTHESIS */ yytestcase(yyruleno==519);
      case 520: /* rowValueExpressionPrimary ::= LEFT_PARENTHESIS multiElementRowValueConstructor RIGHT_PARENTHESIS */ yytestcase(yyruleno==520);
#line 1627 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[-1].minor.yy1172;   yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 9700 "../LemonSrc/SQLParserL.c"
        break;
      case 230: /* predicateValueExpression ::= predicateValueExpression OR predicateValueExpression */
#line 1629 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Or, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172);
	  yy_destructor(yypParser,14,&yymsp[-1].minor);
}
#line 9708 "../LemonSrc/SQLParserL.c"
        break;
      case 231: /* predicateValueExpression ::= predicateValueExpression AND predicateValueExpression */
#line 1633 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_And, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172);
	  yy_destructor(yypParser,15,&yymsp[-1].minor);
}
#line 9716 "../LemonSrc/SQLParserL.c"
        break;
      case 232: /* predicateValueExpression ::= NOT predicateValueExpression */
#line 1637 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Not, yymsp[0].minor.yy1172);
	  yy_destructor(yypParser,16,&yymsp[-1].minor);
}
#line 9724 "../LemonSrc/SQLParserL.c"
        break;
      case 242: /* comparisonPredicate ::= nonPredicateValueExpression EQUALS nonPredicateValueExpression */
#line 1666 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Eq, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172, ValueExpression::Boolean);
	  yy_destructor(yypParser,19,&yymsp[-1].minor);
}
#line 9732 "../LemonSrc/SQLParserL.c"
        break;
      case 243: /* comparisonPredicate ::= nonPredicateValueExpression NOT_EQUALS nonPredicateValueExpression */
#line 1671 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Ne, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172, ValueExpression::Boolean);
	  yy_destructor(yypParser,20,&yymsp[-1].minor);
}
#line 9740 "../LemonSrc/SQLParserL.c"
        break;
      case 244: /* comparisonPredicate ::= nonPredicateValueExpression LESS_THAN nonPredicateValueExpression */
#line 1676 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Lt, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172, ValueExpression::Boolean);
	  yy_destructor(yypParser,21,&yymsp[-1].minor);
}
#line 9748 "../LemonSrc/SQLParserL.c"
        break;
      case 245: /* comparisonPredicate ::= nonPredicateValueExpression LESS_THAN_OR_EQUALS nonPredicateValueExpression */
#line 1681 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Le, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172, ValueExpression::Boolean);
	  yy_destructor(yypParser,23,&yymsp[-1].minor);
}
#line 9756 "../LemonSrc/SQLParserL.c"
        break;
      case 246: /* comparisonPredicate ::= nonPredicateValueExpression GREATER_THAN nonPredicateValueExpression */
#line 1686 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Gt, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172, ValueExpression::Boolean);
	  yy_destructor(yypParser,22,&yymsp[-1].minor);
}
#line 9764 "../LemonSrc/SQLParserL.c"
        break;
      case 247: /* comparisonPredicate ::= nonPredicateValueExpression GREATER_THAN_OR_EQUALS nonPredicateValueExpression */
#line 1691 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Ge, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172, ValueExpression::Boolean);
	  yy_destructor(yypParser,24,&yymsp[-1].minor);
}
#line 9772 "../LemonSrc/SQLParserL.c"
        break;
      case 248: /* betweenPredicate ::= nonPredicateValueExpression BETWEEN nonPredicateValueExpression AND nonPredicateValueExpression */
#line 1703 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Between, yymsp[-4].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172,
									 ValueExpression::Boolean);
	  yy_destructor(yypParser,17,&yymsp[-3].minor);
  yy_destructor(yypParser,15,&yymsp[-1].minor);
}
#line 9782 "../LemonSrc/SQLParserL.c"
        break;
      case 249: /* betweenPredicate ::= nonPredicateValueExpression NOT BETWEEN nonPredicateValueExpression AND nonPredicateValueExpression */
#line 1709 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_NotBetween, yymsp[-5].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172,
									 ValueExpression::Boolean);
	  yy_destructor(yypParser,16,&yymsp[-4].minor);
  yy_destructor(yypParser,17,&yymsp[-3].minor);
  yy_destructor(yypParser,15,&yymsp[-1].minor);
}
#line 9793 "../LemonSrc/SQLParserL.c"
        break;
      case 250: /* inPredicate ::= nonPredicateValueExpression IN inPredicateSubquery */
#line 1720 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<InPredicate> p = new InPredicate(yymsp[-2].minor.yy1172, yymsp[0].minor.yy533);
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_In,
									 p, ValueExpression::Boolean,
									 ValueExpression::mergeExpressionType(yymsp[-2].minor.yy1172->getExpressionType(),
																		  ValueExpression::type_SingleColumn));
		p.release();
	  yy_destructor(yypParser,18,&yymsp[-1].minor);
}
#line 9806 "../LemonSrc/SQLParserL.c"
        break;
      case 251: /* inPredicate ::= nonPredicateValueExpression IN inPredicateValue */
#line 1729 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<InPredicate> p = new InPredicate(yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172);
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_In,
									 p, ValueExpression::Boolean,
									 ValueExpression::mergeExpressionType(yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172));
		p.release();
	  yy_destructor(yypParser,18,&yymsp[-1].minor);
}
#line 9818 "../LemonSrc/SQLParserL.c"
        break;
      case 252: /* inPredicate ::= nonPredicateValueExpression NOT IN inPredicateSubquery */
#line 1737 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<InPredicate> p = new InPredicate(yymsp[-3].minor.yy1172, yymsp[0].minor.yy533);
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_NotIn,
									 p, ValueExpression::Boolean,
									 ValueExpression::mergeExpressionType(yymsp[-3].minor.yy1172->getExpressionType(),
																		  ValueExpression::type_SingleColumn));
		p.release();
	  yy_destructor(yypParser,16,&yymsp[-2].minor);
  yy_destructor(yypParser,18,&yymsp[-1].minor);
}
#line 9832 "../LemonSrc/SQLParserL.c"
        break;
      case 253: /* inPredicate ::= nonPredicateValueExpression NOT IN inPredicateValue */
#line 1746 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<InPredicate> p = new InPredicate(yymsp[-3].minor.yy1172, yymsp[0].minor.yy1172);
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_NotIn,
									 p, ValueExpression::Boolean,
									 ValueExpression::mergeExpressionType(yymsp[-3].minor.yy1172, yymsp[0].minor.yy1172));
		p.release();
	  yy_destructor(yypParser,16,&yymsp[-2].minor);
  yy_destructor(yypParser,18,&yymsp[-1].minor);
}
#line 9845 "../LemonSrc/SQLParserL.c"
        break;
      case 255: /* inPredicateValue ::= LEFT_PARENTHESIS tableValueConstructorList RIGHT_PARENTHESIS */
#line 1766 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Tblconst,
									 yymsp[-1].minor.yy1140,
									 ValueExpression::Table,
									 yymsp[-1].minor.yy1140->getExpressionType());
	  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 9857 "../LemonSrc/SQLParserL.c"
        break;
      case 256: /* inPredicateValue ::= variableName */
#line 1773 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(yymsp[0].minor.yy278);
	}
#line 9864 "../LemonSrc/SQLParserL.c"
        break;
      case 257: /* likePredicate ::= stringValueOperand LIKE stringValueOperand optionalLanguage */
#line 1784 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<LikePredicate> p = new LikePredicate(yymsp[-3].minor.yy1172, yymsp[-1].minor.yy1172, 0, yymsp[0].minor.yy1172);

		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Like,
									 p, ValueExpression::Boolean,
									 ValueExpression::mergeExpressionType(yymsp[-3].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1172));
		p.release();
	  yy_destructor(yypParser,26,&yymsp[-2].minor);
}
#line 9877 "../LemonSrc/SQLParserL.c"
        break;
      case 258: /* likePredicate ::= stringValueOperand LIKE stringValueOperand escape optionalLanguage */
#line 1795 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<LikePredicate> p = new LikePredicate(yymsp[-4].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1172);

		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Like,
									 p, ValueExpression::Boolean,
									 ValueExpression::mergeExpressionType(yymsp[-4].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1172));
		p.release();
	  yy_destructor(yypParser,26,&yymsp[-3].minor);
}
#line 9890 "../LemonSrc/SQLParserL.c"
        break;
      case 259: /* likePredicate ::= stringValueOperand LIKE stringValueOperand language escape */
#line 1805 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<LikePredicate> p = new LikePredicate(yymsp[-4].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172, yymsp[-1].minor.yy1172);

		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Like,
									 p, ValueExpression::Boolean,
									 ValueExpression::mergeExpressionType(yymsp[-4].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172, yymsp[-1].minor.yy1172));
		p.release();
	  yy_destructor(yypParser,26,&yymsp[-3].minor);
}
#line 9903 "../LemonSrc/SQLParserL.c"
        break;
      case 260: /* likePredicate ::= nonPredicateValueExpression NOT LIKE stringValueOperand optionalLanguage */
#line 1817 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<LikePredicate> p0 = new LikePredicate(yymsp[-4].minor.yy1172, yymsp[-1].minor.yy1172, 0, yymsp[0].minor.yy1172);

		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_NotLike,
									 p0, ValueExpression::Boolean,
									 ValueExpression::mergeExpressionType(yymsp[-4].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1172));
		p0.release();
	  yy_destructor(yypParser,16,&yymsp[-3].minor);
  yy_destructor(yypParser,26,&yymsp[-2].minor);
}
#line 9917 "../LemonSrc/SQLParserL.c"
        break;
      case 261: /* likePredicate ::= nonPredicateValueExpression NOT LIKE stringValueOperand escape optionalLanguage */
#line 1829 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<LikePredicate> p0 = new LikePredicate(yymsp[-5].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1172);

		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_NotLike,
									 p0, ValueExpression::Boolean,
									 ValueExpression::mergeExpressionType(yymsp[-5].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1172));
		p0.release();
	  yy_destructor(yypParser,16,&yymsp[-4].minor);
  yy_destructor(yypParser,26,&yymsp[-3].minor);
}
#line 9931 "../LemonSrc/SQLParserL.c"
        break;
      case 262: /* likePredicate ::= nonPredicateValueExpression NOT LIKE stringValueOperand language escape */
#line 1840 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<LikePredicate> p0 = new LikePredicate(yymsp[-5].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172, yymsp[-1].minor.yy1172);

		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_NotLike,
									 p0,	ValueExpression::Boolean,
									 ValueExpression::mergeExpressionType(yymsp[-5].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172, yymsp[-1].minor.yy1172));
		p0.release();
	  yy_destructor(yypParser,16,&yymsp[-4].minor);
  yy_destructor(yypParser,26,&yymsp[-3].minor);
}
#line 9945 "../LemonSrc/SQLParserL.c"
        break;
      case 263: /* escape ::= ESCAPE stringValueOperand */
      case 410: /* optionalKwicEscape ::= ESCAPE kwicStringOption */ yytestcase(yyruleno==410);
#line 1855 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,28,&yymsp[-1].minor);
}
#line 9952 "../LemonSrc/SQLParserL.c"
        break;
      case 264: /* optionalLanguage ::= */
      case 336: /* optionalCategory ::= */ yytestcase(yyruleno==336);
      case 339: /* optionalScale ::= */ yytestcase(yyruleno==339);
      case 366: /* optionalLowerDist ::= */ yytestcase(yyruleno==366);
      case 372: /* optionalDf ::= */ yytestcase(yyruleno==372);
      case 405: /* optionalKwicStartTag ::= */ yytestcase(yyruleno==405);
      case 407: /* optionalKwicEndTag ::= */ yytestcase(yyruleno==407);
      case 409: /* optionalKwicEscape ::= */ yytestcase(yyruleno==409);
      case 411: /* optionalKwicEllipsis ::= */ yytestcase(yyruleno==411);
#line 1863 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = 0; }
#line 9965 "../LemonSrc/SQLParserL.c"
        break;
      case 266: /* language ::= LANGUAGE stringValueOperand */
#line 1870 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,29,&yymsp[-1].minor);
}
#line 9971 "../LemonSrc/SQLParserL.c"
        break;
      case 267: /* scaleParameter ::= SCALE PARAMETER numericValueOperand */
#line 1878 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,91,&yymsp[-2].minor);
  yy_destructor(yypParser,92,&yymsp[-1].minor);
}
#line 9978 "../LemonSrc/SQLParserL.c"
        break;
      case 268: /* wordLimit ::= WORD LIMIT numericValueOperand */
#line 1886 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,93,&yymsp[-2].minor);
  yy_destructor(yypParser,90,&yymsp[-1].minor);
}
#line 9985 "../LemonSrc/SQLParserL.c"
        break;
      case 269: /* containsPredicate ::= nonPredicateValueExpression CONTAINS containsOperand containsOption */
#line 1895 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<ContainsPredicate> p = new ContainsPredicate(yymsp[-3].minor.yy1172, yymsp[-1].minor.yy231, yymsp[0].minor.yy11);
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Contains,
									 p, ValueExpression::Boolean,
									 yymsp[-3].minor.yy1172->getExpressionType());
		p.release();
	  yy_destructor(yypParser,27,&yymsp[-2].minor);
}
#line 9997 "../LemonSrc/SQLParserL.c"
        break;
      case 270: /* containsOption ::= */
#line 1909 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy11 = 0; }
#line 10002 "../LemonSrc/SQLParserL.c"
        break;
      case 271: /* containsOption ::= containsOption calculator */
#line 1911 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy11 = yymsp[-1].minor.yy11 ? yymsp[-1].minor.yy11 : new ContainsOption;
	yygotominor.yy11->setCalculator(yymsp[0].minor.yy1172);
}
#line 10010 "../LemonSrc/SQLParserL.c"
        break;
      case 272: /* containsOption ::= containsOption combiner */
#line 1916 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy11 = yymsp[-1].minor.yy11 ? yymsp[-1].minor.yy11 : new ContainsOption;
	yygotominor.yy11->setCombiner(yymsp[0].minor.yy1172);
}
#line 10018 "../LemonSrc/SQLParserL.c"
        break;
      case 273: /* containsOption ::= containsOption averageLength */
#line 1921 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy11 = yymsp[-1].minor.yy11 ? yymsp[-1].minor.yy11 : new ContainsOption;
	yygotominor.yy11->setAverageLength(yymsp[0].minor.yy1172);
}
#line 10026 "../LemonSrc/SQLParserL.c"
        break;
      case 274: /* containsOption ::= containsOption df */
#line 1926 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy11 = yymsp[-1].minor.yy11 ? yymsp[-1].minor.yy11 : new ContainsOption;
	yygotominor.yy11->setDf(yymsp[0].minor.yy1172);
}
#line 10034 "../LemonSrc/SQLParserL.c"
        break;
      case 275: /* containsOption ::= containsOption scoreFunction */
#line 1931 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy11 = yymsp[-1].minor.yy11 ? yymsp[-1].minor.yy11 : new ContainsOption;
	yygotominor.yy11->setScoreFunction(yymsp[0].minor.yy1172);
}
#line 10042 "../LemonSrc/SQLParserL.c"
        break;
      case 276: /* containsOption ::= containsOption expand */
#line 1936 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy11 = yymsp[-1].minor.yy11 ? yymsp[-1].minor.yy11 : new ContainsOption;
	yygotominor.yy11->setExpand(yymsp[0].minor.yy416);
}
#line 10050 "../LemonSrc/SQLParserL.c"
        break;
      case 277: /* containsOption ::= containsOption extractor */
#line 1941 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy11 = yymsp[-1].minor.yy11 ? yymsp[-1].minor.yy11 : new ContainsOption;
	yygotominor.yy11->setExtractor(yymsp[0].minor.yy1172);
}
#line 10058 "../LemonSrc/SQLParserL.c"
        break;
      case 278: /* containsOption ::= containsOption clusteredLimit */
#line 1946 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy11 = yymsp[-1].minor.yy11 ? yymsp[-1].minor.yy11 : new ContainsOption;
	yygotominor.yy11->setClusteredLimit(yymsp[0].minor.yy1172);
}
#line 10066 "../LemonSrc/SQLParserL.c"
        break;
      case 279: /* containsOption ::= containsOption scoreCombiner */
#line 1951 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy11 = yymsp[-1].minor.yy11 ? yymsp[-1].minor.yy11 : new ContainsOption;
	yygotominor.yy11->setScoreCombiner(yymsp[0].minor.yy1172);
}
#line 10074 "../LemonSrc/SQLParserL.c"
        break;
      case 280: /* containsOption ::= containsOption clusteredCombiner */
#line 1956 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy11 = yymsp[-1].minor.yy11 ? yymsp[-1].minor.yy11 : new ContainsOption;
	yygotominor.yy11->setClusteredCombiner(yymsp[0].minor.yy1172);
}
#line 10082 "../LemonSrc/SQLParserL.c"
        break;
      case 281: /* containsOption ::= containsOption rankFrom */
#line 1961 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy11 = yymsp[-1].minor.yy11 ? yymsp[-1].minor.yy11 : new ContainsOption;
	yygotominor.yy11->setRankFrom(yymsp[0].minor.yy533);
}
#line 10090 "../LemonSrc/SQLParserL.c"
        break;
      case 282: /* containsOperand ::= containsOperandList */
      case 342: /* containsOperandPrimary ::= containsOperandParticle */ yytestcase(yyruleno==342);
      case 347: /* containsOperandParticle ::= containsOperandWord */ yytestcase(yyruleno==347);
      case 357: /* containsOperandWord ::= containsOperandPattern */ yytestcase(yyruleno==357);
#line 1972 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy231 = yymsp[0].minor.yy231; }
#line 10098 "../LemonSrc/SQLParserL.c"
        break;
      case 283: /* containsOperand ::= WORDLIST LEFT_PARENTHESIS wordList RIGHT_PARENTHESIS */
#line 1974 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::WordList(yymsp[-1].minor.yy647);
	  yy_destructor(yypParser,94,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10108 "../LemonSrc/SQLParserL.c"
        break;
      case 284: /* containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand optionalLanguage RIGHT_PARENTHESIS */
#line 1979 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::FreeText(yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, 0, 0);
	  yy_destructor(yypParser,95,&yymsp[-4].minor);
  yy_destructor(yypParser,66,&yymsp[-3].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10118 "../LemonSrc/SQLParserL.c"
        break;
      case 285: /* containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand scaleParameter RIGHT_PARENTHESIS */
#line 1984 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::FreeText(yymsp[-2].minor.yy1172, 0, yymsp[-1].minor.yy1172, 0);
	  yy_destructor(yypParser,95,&yymsp[-4].minor);
  yy_destructor(yypParser,66,&yymsp[-3].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10128 "../LemonSrc/SQLParserL.c"
        break;
      case 286: /* containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand wordLimit RIGHT_PARENTHESIS */
#line 1989 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::FreeText(yymsp[-2].minor.yy1172, 0, 0, yymsp[-1].minor.yy1172);
	  yy_destructor(yypParser,95,&yymsp[-4].minor);
  yy_destructor(yypParser,66,&yymsp[-3].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10138 "../LemonSrc/SQLParserL.c"
        break;
      case 287: /* containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand language scaleParameter RIGHT_PARENTHESIS */
#line 1994 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::FreeText(yymsp[-3].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, 0);
	  yy_destructor(yypParser,95,&yymsp[-5].minor);
  yy_destructor(yypParser,66,&yymsp[-4].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10148 "../LemonSrc/SQLParserL.c"
        break;
      case 288: /* containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand scaleParameter language RIGHT_PARENTHESIS */
#line 1999 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::FreeText(yymsp[-3].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[-2].minor.yy1172, 0);
	  yy_destructor(yypParser,95,&yymsp[-5].minor);
  yy_destructor(yypParser,66,&yymsp[-4].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10158 "../LemonSrc/SQLParserL.c"
        break;
      case 289: /* containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand language wordLimit RIGHT_PARENTHESIS */
#line 2004 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::FreeText(yymsp[-3].minor.yy1172, yymsp[-2].minor.yy1172, 0, yymsp[-1].minor.yy1172);
	  yy_destructor(yypParser,95,&yymsp[-5].minor);
  yy_destructor(yypParser,66,&yymsp[-4].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10168 "../LemonSrc/SQLParserL.c"
        break;
      case 290: /* containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand wordLimit language RIGHT_PARENTHESIS */
#line 2009 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::FreeText(yymsp[-3].minor.yy1172, yymsp[-1].minor.yy1172, 0, yymsp[-2].minor.yy1172);
	  yy_destructor(yypParser,95,&yymsp[-5].minor);
  yy_destructor(yypParser,66,&yymsp[-4].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10178 "../LemonSrc/SQLParserL.c"
        break;
      case 291: /* containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand scaleParameter wordLimit RIGHT_PARENTHESIS */
#line 2014 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::FreeText(yymsp[-3].minor.yy1172, 0, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172);
	  yy_destructor(yypParser,95,&yymsp[-5].minor);
  yy_destructor(yypParser,66,&yymsp[-4].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10188 "../LemonSrc/SQLParserL.c"
        break;
      case 292: /* containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand wordLimit scaleParameter RIGHT_PARENTHESIS */
#line 2019 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::FreeText(yymsp[-3].minor.yy1172, 0, yymsp[-1].minor.yy1172, yymsp[-2].minor.yy1172);
	  yy_destructor(yypParser,95,&yymsp[-5].minor);
  yy_destructor(yypParser,66,&yymsp[-4].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10198 "../LemonSrc/SQLParserL.c"
        break;
      case 293: /* containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand language scaleParameter wordLimit RIGHT_PARENTHESIS */
#line 2024 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::FreeText(yymsp[-4].minor.yy1172, yymsp[-3].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172);
	  yy_destructor(yypParser,95,&yymsp[-6].minor);
  yy_destructor(yypParser,66,&yymsp[-5].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10208 "../LemonSrc/SQLParserL.c"
        break;
      case 294: /* containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand language wordLimit scaleParameter RIGHT_PARENTHESIS */
#line 2029 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::FreeText(yymsp[-4].minor.yy1172, yymsp[-3].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[-2].minor.yy1172);
	  yy_destructor(yypParser,95,&yymsp[-6].minor);
  yy_destructor(yypParser,66,&yymsp[-5].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10218 "../LemonSrc/SQLParserL.c"
        break;
      case 295: /* containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand scaleParameter wordLimit language RIGHT_PARENTHESIS */
#line 2034 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::FreeText(yymsp[-4].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[-3].minor.yy1172, yymsp[-2].minor.yy1172);
	  yy_destructor(yypParser,95,&yymsp[-6].minor);
  yy_destructor(yypParser,66,&yymsp[-5].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10228 "../LemonSrc/SQLParserL.c"
        break;
      case 296: /* containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand scaleParameter language wordLimit RIGHT_PARENTHESIS */
#line 2039 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::FreeText(yymsp[-4].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-3].minor.yy1172, yymsp[-1].minor.yy1172);
	  yy_destructor(yypParser,95,&yymsp[-6].minor);
  yy_destructor(yypParser,66,&yymsp[-5].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10238 "../LemonSrc/SQLParserL.c"
        break;
      case 297: /* containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand wordLimit language scaleParameter RIGHT_PARENTHESIS */
#line 2044 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::FreeText(yymsp[-4].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[-3].minor.yy1172);
	  yy_destructor(yypParser,95,&yymsp[-6].minor);
  yy_destructor(yypParser,66,&yymsp[-5].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10248 "../LemonSrc/SQLParserL.c"
        break;
      case 298: /* containsOperand ::= FREETEXT LEFT_PARENTHESIS stringValueOperand wordLimit scaleParameter language RIGHT_PARENTHESIS */
#line 2049 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::FreeText(yymsp[-4].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-3].minor.yy1172);
	  yy_destructor(yypParser,95,&yymsp[-6].minor);
  yy_destructor(yypParser,66,&yymsp[-5].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10258 "../LemonSrc/SQLParserL.c"
        break;
      case 299: /* containsOperandList ::= containsOperandPrimary */
#line 2059 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = yymsp[0].minor.yy231;
	}
#line 10265 "../LemonSrc/SQLParserL.c"
        break;
      case 300: /* containsOperandList ::= LEFT_PARENTHESIS containsOperandList combiner RIGHT_PARENTHESIS */
#line 2063 "../LemonSrc/SQLParserL.lemon"
{
		switch (yymsp[-2].minor.yy231->getType())
		{
		case ContainsOperand::Type::And:
		case ContainsOperand::Type::Or:
		case ContainsOperand::Type::AndNot:
		{
			Contains::LogicalOperation* p
				= _SYDNEY_DYNAMIC_CAST(Contains::LogicalOperation*, yymsp[-2].minor.yy231);
			p->setCombiner(yymsp[-1].minor.yy1172);
			break;
		}
		default:
		{
			yygotominor.yy231 = 0;
			pParser->throwSyntaxErrorException(srcFile ,__LINE__);
			break;
		}
		}
		yygotominor.yy231 = yymsp[-2].minor.yy231;
	  yy_destructor(yypParser,66,&yymsp[-3].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10292 "../LemonSrc/SQLParserL.c"
        break;
      case 301: /* containsOperandList ::= containsOperandList VERTICALLINE containsOperandList */
#line 2085 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Or(yymsp[-2].minor.yy231, yymsp[0].minor.yy231, 0);
	  yy_destructor(yypParser,34,&yymsp[-1].minor);
}
#line 10300 "../LemonSrc/SQLParserL.c"
        break;
      case 302: /* containsOperandList ::= containsOperandList MINUS containsOperandList */
#line 2090 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::AndNot(yymsp[-2].minor.yy231, yymsp[0].minor.yy231, 0);
	  yy_destructor(yypParser,38,&yymsp[-1].minor);
}
#line 10308 "../LemonSrc/SQLParserL.c"
        break;
      case 303: /* containsOperandList ::= containsOperandList AMPERSAND containsOperandList */
#line 2094 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::And(yymsp[-2].minor.yy231, yymsp[0].minor.yy231, 0);
	  yy_destructor(yypParser,36,&yymsp[-1].minor);
}
#line 10316 "../LemonSrc/SQLParserL.c"
        break;
      case 304: /* combiner ::= COMBINER stringValueOperand */
#line 2104 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,32,&yymsp[-1].minor);
}
#line 10322 "../LemonSrc/SQLParserL.c"
        break;
      case 305: /* wordList ::= word */
#line 2112 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<ContainsOperandList> p = new ContainsOperandList;
		p->append(yymsp[0].minor.yy231);
		yygotominor.yy647 = p.release();
	}
#line 10331 "../LemonSrc/SQLParserL.c"
        break;
      case 306: /* wordList ::= wordList COMMA word */
#line 2118 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-2].minor.yy647->append(yymsp[0].minor.yy231);
		yygotominor.yy647 = yymsp[-2].minor.yy647;
	  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 10340 "../LemonSrc/SQLParserL.c"
        break;
      case 307: /* word ::= containsOperandWord optionalCategory */
#line 2130 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-1].minor.yy231, yymsp[0].minor.yy1172, 0, 0, 0);
	}
#line 10347 "../LemonSrc/SQLParserL.c"
        break;
      case 308: /* word ::= containsOperandWord scale optionalCategory */
#line 2135 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-2].minor.yy231, yymsp[0].minor.yy1172, yymsp[-1].minor.yy1172, 0, 0);
	}
#line 10354 "../LemonSrc/SQLParserL.c"
        break;
      case 309: /* word ::= containsOperandWord category scale */
#line 2140 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-2].minor.yy231, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1172, 0, 0);
	}
#line 10361 "../LemonSrc/SQLParserL.c"
        break;
      case 310: /* word ::= containsOperandWord language optionalCategory */
#line 2145 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-2].minor.yy231, yymsp[0].minor.yy1172, 0, yymsp[-1].minor.yy1172, 0);
	}
#line 10368 "../LemonSrc/SQLParserL.c"
        break;
      case 311: /* word ::= containsOperandWord language scale optionalCategory */
#line 2150 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-3].minor.yy231, yymsp[0].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[-2].minor.yy1172, 0);
	}
#line 10375 "../LemonSrc/SQLParserL.c"
        break;
      case 312: /* word ::= containsOperandWord language category scale optionalDf */
#line 2155 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-4].minor.yy231, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[-3].minor.yy1172, yymsp[0].minor.yy1172);
	}
#line 10382 "../LemonSrc/SQLParserL.c"
        break;
      case 313: /* word ::= containsOperandWord category language optionalScale */
#line 2160 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-3].minor.yy231, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172, yymsp[-1].minor.yy1172, 0);
	}
#line 10389 "../LemonSrc/SQLParserL.c"
        break;
      case 314: /* word ::= containsOperandWord scale language optionalCategory */
#line 2165 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-3].minor.yy231, yymsp[0].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, 0);
	}
#line 10396 "../LemonSrc/SQLParserL.c"
        break;
      case 315: /* word ::= containsOperandWord category scale language optionalDf */
#line 2170 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-4].minor.yy231, yymsp[-3].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1172);
	}
#line 10403 "../LemonSrc/SQLParserL.c"
        break;
      case 316: /* word ::= containsOperandWord scale category language optionalDf */
#line 2175 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-4].minor.yy231, yymsp[-2].minor.yy1172, yymsp[-3].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1172);
	}
#line 10410 "../LemonSrc/SQLParserL.c"
        break;
      case 317: /* word ::= containsOperandWord df optionalCategory */
#line 2180 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-2].minor.yy231, yymsp[0].minor.yy1172, 0, 0, yymsp[-1].minor.yy1172);
	}
#line 10417 "../LemonSrc/SQLParserL.c"
        break;
      case 318: /* word ::= containsOperandWord df scale optionalCategory */
#line 2185 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-3].minor.yy231, yymsp[0].minor.yy1172, yymsp[-1].minor.yy1172, 0, yymsp[-2].minor.yy1172);
	}
#line 10424 "../LemonSrc/SQLParserL.c"
        break;
      case 319: /* word ::= containsOperandWord df category scale optionalLanguage */
#line 2190 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-4].minor.yy231, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1172, yymsp[-3].minor.yy1172);
	}
#line 10431 "../LemonSrc/SQLParserL.c"
        break;
      case 320: /* word ::= containsOperandWord df category language optionalScale */
#line 2195 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-4].minor.yy231, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[-3].minor.yy1172);
	}
#line 10438 "../LemonSrc/SQLParserL.c"
        break;
      case 321: /* word ::= containsOperandWord df scale language optionalCategory */
#line 2200 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-4].minor.yy231, yymsp[0].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[-3].minor.yy1172);
	}
#line 10445 "../LemonSrc/SQLParserL.c"
        break;
      case 322: /* word ::= containsOperandWord df language optionalCategory */
#line 2205 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-3].minor.yy231, yymsp[0].minor.yy1172, 0, yymsp[-1].minor.yy1172, yymsp[-2].minor.yy1172);
	}
#line 10452 "../LemonSrc/SQLParserL.c"
        break;
      case 323: /* word ::= containsOperandWord df language category scale */
#line 2210 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-4].minor.yy231, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-3].minor.yy1172);
	}
#line 10459 "../LemonSrc/SQLParserL.c"
        break;
      case 324: /* word ::= containsOperandWord df language scale optionalCategory */
#line 2215 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-4].minor.yy231, yymsp[0].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-3].minor.yy1172);
	}
#line 10466 "../LemonSrc/SQLParserL.c"
        break;
      case 325: /* word ::= containsOperandWord category df optionalScale */
#line 2220 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-3].minor.yy231, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172, 0, yymsp[-1].minor.yy1172);
	}
#line 10473 "../LemonSrc/SQLParserL.c"
        break;
      case 326: /* word ::= containsOperandWord scale df optionalCategory */
#line 2225 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-3].minor.yy231, yymsp[0].minor.yy1172, yymsp[-2].minor.yy1172, 0, yymsp[-1].minor.yy1172);
	}
#line 10480 "../LemonSrc/SQLParserL.c"
        break;
      case 327: /* word ::= containsOperandWord category scale df optionalLanguage */
#line 2230 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-4].minor.yy231, yymsp[-3].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172, yymsp[-1].minor.yy1172);
	}
#line 10487 "../LemonSrc/SQLParserL.c"
        break;
      case 328: /* word ::= containsOperandWord scale category df optionalLanguage */
#line 2235 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-4].minor.yy231, yymsp[-2].minor.yy1172, yymsp[-3].minor.yy1172, yymsp[0].minor.yy1172, yymsp[-1].minor.yy1172);
	}
#line 10494 "../LemonSrc/SQLParserL.c"
        break;
      case 329: /* word ::= containsOperandWord category language scale df */
#line 2240 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-4].minor.yy231, yymsp[-3].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172);
	}
#line 10501 "../LemonSrc/SQLParserL.c"
        break;
      case 330: /* word ::= containsOperandWord category df scale language */
#line 2245 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-4].minor.yy231, yymsp[-3].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1172, yymsp[-2].minor.yy1172);
	}
#line 10508 "../LemonSrc/SQLParserL.c"
        break;
      case 331: /* word ::= containsOperandWord scale language category df */
#line 2250 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-4].minor.yy231, yymsp[-1].minor.yy1172, yymsp[-3].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172);
	}
#line 10515 "../LemonSrc/SQLParserL.c"
        break;
      case 332: /* word ::= containsOperandWord scale df category language */
#line 2255 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-4].minor.yy231, yymsp[-1].minor.yy1172, yymsp[-3].minor.yy1172, yymsp[0].minor.yy1172, yymsp[-2].minor.yy1172);
	}
#line 10522 "../LemonSrc/SQLParserL.c"
        break;
      case 333: /* word ::= containsOperandWord language scale category df */
#line 2260 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-4].minor.yy231, yymsp[-1].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-3].minor.yy1172, yymsp[0].minor.yy1172);
	}
#line 10529 "../LemonSrc/SQLParserL.c"
        break;
      case 334: /* word ::= containsOperandWord language scale df optionalCategory */
#line 2265 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-4].minor.yy231, yymsp[0].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-3].minor.yy1172, yymsp[-1].minor.yy1172);
	}
#line 10536 "../LemonSrc/SQLParserL.c"
        break;
      case 335: /* word ::= containsOperandWord df scale category language */
#line 2270 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Word(yymsp[-4].minor.yy231, yymsp[-1].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172, yymsp[-3].minor.yy1172);
	}
#line 10543 "../LemonSrc/SQLParserL.c"
        break;
      case 338: /* category ::= CATEGORY stringValueOperand */
#line 2287 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,96,&yymsp[-1].minor);
}
#line 10549 "../LemonSrc/SQLParserL.c"
        break;
      case 341: /* scale ::= SCALE numericValueOperand */
#line 2302 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,91,&yymsp[-1].minor);
}
#line 10555 "../LemonSrc/SQLParserL.c"
        break;
      case 343: /* containsOperandPrimary ::= LEFT_PARENTHESIS containsOperandList RIGHT_PARENTHESIS */
#line 2312 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy231 = yymsp[-1].minor.yy231;   yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10562 "../LemonSrc/SQLParserL.c"
        break;
      case 344: /* containsOperandPrimary ::= WEIGHT LEFT_PARENTHESIS containsOperandList scale RIGHT_PARENTHESIS */
#line 2314 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Weight(yymsp[-2].minor.yy231, yymsp[-1].minor.yy1172);
	  yy_destructor(yypParser,97,&yymsp[-4].minor);
  yy_destructor(yypParser,66,&yymsp[-3].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10572 "../LemonSrc/SQLParserL.c"
        break;
      case 345: /* containsOperandParticleList ::= containsOperandParticle containsOperandParticle */
      case 355: /* containsOperandWordList ::= containsOperandWord containsOperandWord */ yytestcase(yyruleno==355);
#line 2324 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<ContainsOperandList> p = new ContainsOperandList;
		p->append(yymsp[-1].minor.yy231);
		p->append(yymsp[0].minor.yy231);
		yygotominor.yy647 = p.release();
	}
#line 10583 "../LemonSrc/SQLParserL.c"
        break;
      case 346: /* containsOperandParticleList ::= containsOperandParticleList containsOperandParticle */
      case 356: /* containsOperandWordList ::= containsOperandWordList containsOperandWord */ yytestcase(yyruleno==356);
#line 2331 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-1].minor.yy647->append(yymsp[0].minor.yy231);
		yygotominor.yy647 = yymsp[-1].minor.yy647;
	}
#line 10592 "../LemonSrc/SQLParserL.c"
        break;
      case 348: /* containsOperandParticle ::= SYNONYM LEFT_PARENTHESIS containsOperandWordList RIGHT_PARENTHESIS */
#line 2344 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Synonym(yymsp[-1].minor.yy647);
	  yy_destructor(yypParser,98,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10602 "../LemonSrc/SQLParserL.c"
        break;
      case 349: /* containsOperandParticle ::= EXPAND_SYNONYM LEFT_PARENTHESIS containsOperandWord RIGHT_PARENTHESIS */
#line 2348 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::ExpandSynonym(yymsp[-1].minor.yy231);
	  yy_destructor(yypParser,99,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10612 "../LemonSrc/SQLParserL.c"
        break;
      case 350: /* containsOperandParticle ::= HEAD LEFT_PARENTHESIS containsOperandParticle RIGHT_PARENTHESIS */
#line 2352 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Head(yymsp[-1].minor.yy231);
	  yy_destructor(yypParser,100,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10622 "../LemonSrc/SQLParserL.c"
        break;
      case 351: /* containsOperandParticle ::= TAIL LEFT_PARENTHESIS containsOperandParticle RIGHT_PARENTHESIS */
#line 2356 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Tail(yymsp[-1].minor.yy231);
	  yy_destructor(yypParser,101,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10632 "../LemonSrc/SQLParserL.c"
        break;
      case 352: /* containsOperandParticle ::= WITHIN LEFT_PARENTHESIS containsOperandParticleList optionalLowerDist upperDist RIGHT_PARENTHESIS */
#line 2363 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Within(yymsp[-3].minor.yy647,
									  Contains::Within::Symmetric,
									  yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, 0);
	  yy_destructor(yypParser,102,&yymsp[-5].minor);
  yy_destructor(yypParser,66,&yymsp[-4].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10644 "../LemonSrc/SQLParserL.c"
        break;
      case 353: /* containsOperandParticle ::= WITHIN LEFT_PARENTHESIS containsOperandParticleList SYMMETRIC optionalLowerDist upperDist RIGHT_PARENTHESIS */
#line 2373 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Within(yymsp[-4].minor.yy647,
									  Contains::Within::Symmetric,
									  yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, 0);
	  yy_destructor(yypParser,102,&yymsp[-6].minor);
  yy_destructor(yypParser,66,&yymsp[-5].minor);
  yy_destructor(yypParser,103,&yymsp[-3].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10657 "../LemonSrc/SQLParserL.c"
        break;
      case 354: /* containsOperandParticle ::= WITHIN LEFT_PARENTHESIS containsOperandParticleList ASYMMETRIC optionalLowerDist upperDist RIGHT_PARENTHESIS */
#line 2383 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Within(yymsp[-4].minor.yy647,
									  Contains::Within::Asymmetric,
									  yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, 0);
	  yy_destructor(yypParser,102,&yymsp[-6].minor);
  yy_destructor(yypParser,66,&yymsp[-5].minor);
  yy_destructor(yypParser,104,&yymsp[-3].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10670 "../LemonSrc/SQLParserL.c"
        break;
      case 358: /* containsOperandWord ::= EXACTWORD LEFT_PARENTHESIS containsOperandPattern RIGHT_PARENTHESIS */
#line 2415 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::ExactWord(yymsp[-1].minor.yy231);
	  yy_destructor(yypParser,105,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10680 "../LemonSrc/SQLParserL.c"
        break;
      case 359: /* containsOperandWord ::= SIMPLEWORD LEFT_PARENTHESIS containsOperandPattern RIGHT_PARENTHESIS */
#line 2419 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::SimpleWord(yymsp[-1].minor.yy231);
	  yy_destructor(yypParser,106,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10690 "../LemonSrc/SQLParserL.c"
        break;
      case 360: /* containsOperandWord ::= CONTAINS_STRING LEFT_PARENTHESIS containsOperandPattern RIGHT_PARENTHESIS */
#line 2423 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::String(yymsp[-1].minor.yy231);
	  yy_destructor(yypParser,107,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10700 "../LemonSrc/SQLParserL.c"
        break;
      case 361: /* containsOperandWord ::= WORDHEAD LEFT_PARENTHESIS containsOperandPattern RIGHT_PARENTHESIS */
#line 2427 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::WordHead(yymsp[-1].minor.yy231);
	  yy_destructor(yypParser,108,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10710 "../LemonSrc/SQLParserL.c"
        break;
      case 362: /* containsOperandWord ::= WORDTAIL LEFT_PARENTHESIS containsOperandPattern RIGHT_PARENTHESIS */
#line 2431 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::WordTail(yymsp[-1].minor.yy231);
	  yy_destructor(yypParser,109,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10720 "../LemonSrc/SQLParserL.c"
        break;
      case 363: /* containsOperandPattern ::= stringValueOperand */
#line 2441 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Pattern(yymsp[0].minor.yy1172, 0);
	}
#line 10727 "../LemonSrc/SQLParserL.c"
        break;
      case 364: /* containsOperandPattern ::= stringValueOperand language */
#line 2445 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy231 = new Contains::Pattern(yymsp[-1].minor.yy1172, yymsp[0].minor.yy1172);
	}
#line 10734 "../LemonSrc/SQLParserL.c"
        break;
      case 365: /* upperDist ::= UPPER numericValueOperand */
#line 2455 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,110,&yymsp[-1].minor);
}
#line 10740 "../LemonSrc/SQLParserL.c"
        break;
      case 368: /* lowerDist ::= LOWER numericValueOperand */
#line 2470 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,111,&yymsp[-1].minor);
}
#line 10746 "../LemonSrc/SQLParserL.c"
        break;
      case 369: /* calculator ::= CALCULATOR stringValueOperand */
#line 2478 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,30,&yymsp[-1].minor);
}
#line 10752 "../LemonSrc/SQLParserL.c"
        break;
      case 370: /* averageLength ::= AVERAGE LENGTH nonPredicateValueExpression */
#line 2486 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,112,&yymsp[-2].minor);
  yy_destructor(yypParser,113,&yymsp[-1].minor);
}
#line 10759 "../LemonSrc/SQLParserL.c"
        break;
      case 371: /* averageLength ::= AVERAGE FULLTEXT LENGTH nonPredicateValueExpression */
#line 2488 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,112,&yymsp[-3].minor);
  yy_destructor(yypParser,114,&yymsp[-2].minor);
  yy_destructor(yypParser,113,&yymsp[-1].minor);
}
#line 10767 "../LemonSrc/SQLParserL.c"
        break;
      case 374: /* df ::= DF numericValueOperand */
#line 2503 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,115,&yymsp[-1].minor);
}
#line 10773 "../LemonSrc/SQLParserL.c"
        break;
      case 375: /* scoreFunction ::= SCORE FUNCTION stringValueOperand */
#line 2511 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,116,&yymsp[-2].minor);
  yy_destructor(yypParser,117,&yymsp[-1].minor);
}
#line 10780 "../LemonSrc/SQLParserL.c"
        break;
      case 376: /* expand ::= EXPAND LEFT_PARENTHESIS FROM tableSubquery optionalSortSpecificationList optionalLimitSpecification RIGHT_PARENTHESIS */
#line 2522 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy416 = new Expand(yymsp[-3].minor.yy533, yymsp[-2].minor.yy640, yymsp[-1].minor.yy579);
	  yy_destructor(yypParser,118,&yymsp[-6].minor);
  yy_destructor(yypParser,66,&yymsp[-5].minor);
  yy_destructor(yypParser,76,&yymsp[-4].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10791 "../LemonSrc/SQLParserL.c"
        break;
      case 377: /* rankFrom ::= RANK FROM tableSubquery */
#line 2532 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy533 = yymsp[0].minor.yy533;
	  yy_destructor(yypParser,119,&yymsp[-2].minor);
  yy_destructor(yypParser,76,&yymsp[-1].minor);
}
#line 10800 "../LemonSrc/SQLParserL.c"
        break;
      case 378: /* extractor ::= EXTRACTOR stringValueOperand */
#line 2542 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,120,&yymsp[-1].minor);
}
#line 10806 "../LemonSrc/SQLParserL.c"
        break;
      case 379: /* clusteredLimit ::= CLUSTERED LIMIT numericValueOperand */
#line 2550 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,121,&yymsp[-2].minor);
  yy_destructor(yypParser,90,&yymsp[-1].minor);
}
#line 10813 "../LemonSrc/SQLParserL.c"
        break;
      case 380: /* scoreCombiner ::= SCORE COMBINER stringValueOperand */
#line 2558 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,116,&yymsp[-2].minor);
  yy_destructor(yypParser,32,&yymsp[-1].minor);
}
#line 10820 "../LemonSrc/SQLParserL.c"
        break;
      case 381: /* clusteredCombiner ::= CLUSTERED COMBINER stringValueOperand */
#line 2566 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,121,&yymsp[-2].minor);
  yy_destructor(yypParser,32,&yymsp[-1].minor);
}
#line 10827 "../LemonSrc/SQLParserL.c"
        break;
      case 382: /* isNullPredicate ::= nonPredicateValueExpression IS NULL */
#line 2574 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_IsNull,
									 yymsp[-2].minor.yy1172,
									 ValueExpression::Boolean,
									 yymsp[-2].minor.yy1172->getExpressionType());
	  yy_destructor(yypParser,25,&yymsp[-1].minor);
  yy_destructor(yypParser,52,&yymsp[0].minor);
}
#line 10839 "../LemonSrc/SQLParserL.c"
        break;
      case 383: /* isNullPredicate ::= nonPredicateValueExpression IS NOT NULL */
#line 2581 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_IsNotNull,
									 yymsp[-3].minor.yy1172,
									 ValueExpression::Boolean,
									 yymsp[-3].minor.yy1172->getExpressionType());
	  yy_destructor(yypParser,25,&yymsp[-2].minor);
  yy_destructor(yypParser,16,&yymsp[-1].minor);
  yy_destructor(yypParser,52,&yymsp[0].minor);
}
#line 10852 "../LemonSrc/SQLParserL.c"
        break;
      case 384: /* existsPredicate ::= EXISTS tableSubquery */
#line 2594 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Exists,
									 yymsp[0].minor.yy533,
									 ValueExpression::Boolean,
									 ValueExpression::type_Unknown);
	  yy_destructor(yypParser,80,&yymsp[-1].minor);
}
#line 10863 "../LemonSrc/SQLParserL.c"
        break;
      case 385: /* similarPredicate ::= stringValueOperand SIMILAR TO stringValueOperand optionalLanguage */
#line 2608 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<SimilarPredicate> p = new SimilarPredicate(yymsp[-4].minor.yy1172, yymsp[-1].minor.yy1172, 0, yymsp[0].minor.yy1172);

		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Similar,
									 p, ValueExpression::Boolean,
									 ValueExpression::mergeExpressionType(yymsp[-4].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1172));
		p.release();
	  yy_destructor(yypParser,31,&yymsp[-3].minor);
  yy_destructor(yypParser,72,&yymsp[-2].minor);
}
#line 10877 "../LemonSrc/SQLParserL.c"
        break;
      case 386: /* similarPredicate ::= stringValueOperand SIMILAR TO stringValueOperand escape optionalLanguage */
#line 2619 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<SimilarPredicate> p = new SimilarPredicate(yymsp[-5].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1172);

		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Similar,
									 p, ValueExpression::Boolean,
									 ValueExpression::mergeExpressionType(yymsp[-5].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1172));
		p.release();
	  yy_destructor(yypParser,31,&yymsp[-4].minor);
  yy_destructor(yypParser,72,&yymsp[-3].minor);
}
#line 10891 "../LemonSrc/SQLParserL.c"
        break;
      case 387: /* similarPredicate ::= stringValueOperand SIMILAR TO stringValueOperand language escape */
#line 2629 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<SimilarPredicate> p = new SimilarPredicate(yymsp[-5].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172, yymsp[-1].minor.yy1172);

		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Similar,
									 p, ValueExpression::Boolean,
									 ValueExpression::mergeExpressionType(yymsp[-5].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172, yymsp[-1].minor.yy1172));
		p.release();
	  yy_destructor(yypParser,31,&yymsp[-4].minor);
  yy_destructor(yypParser,72,&yymsp[-3].minor);
}
#line 10905 "../LemonSrc/SQLParserL.c"
        break;
      case 388: /* similarPredicate ::= nonPredicateValueExpression NOT SIMILAR TO stringValueOperand optionalLanguage */
#line 2641 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<SimilarPredicate> p0 = new SimilarPredicate(yymsp[-5].minor.yy1172, yymsp[-1].minor.yy1172, 0, yymsp[0].minor.yy1172);

		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_NotSimilar,
									 p0, ValueExpression::Boolean,
									 ValueExpression::mergeExpressionType(yymsp[-5].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1172));
		p0.release();
	  yy_destructor(yypParser,16,&yymsp[-4].minor);
  yy_destructor(yypParser,31,&yymsp[-3].minor);
  yy_destructor(yypParser,72,&yymsp[-2].minor);
}
#line 10920 "../LemonSrc/SQLParserL.c"
        break;
      case 389: /* similarPredicate ::= nonPredicateValueExpression NOT SIMILAR TO stringValueOperand escape optionalLanguage */
#line 2653 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<SimilarPredicate> p0 = new SimilarPredicate(yymsp[-6].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1172);

		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_NotSimilar,
									 p0, ValueExpression::Boolean,
									 ValueExpression::mergeExpressionType(yymsp[-6].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1172));
		p0.release();
	  yy_destructor(yypParser,16,&yymsp[-5].minor);
  yy_destructor(yypParser,31,&yymsp[-4].minor);
  yy_destructor(yypParser,72,&yymsp[-3].minor);
}
#line 10935 "../LemonSrc/SQLParserL.c"
        break;
      case 390: /* similarPredicate ::= nonPredicateValueExpression NOT SIMILAR TO stringValueOperand language escape */
#line 2664 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<SimilarPredicate> p0 = new SimilarPredicate(yymsp[-6].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172, yymsp[-1].minor.yy1172);

		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_NotSimilar,
									 p0, ValueExpression::Boolean,
									 ValueExpression::mergeExpressionType(yymsp[-6].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172, yymsp[-1].minor.yy1172));
		p0.release();
	  yy_destructor(yypParser,16,&yymsp[-5].minor);
  yy_destructor(yypParser,31,&yymsp[-4].minor);
  yy_destructor(yypParser,72,&yymsp[-3].minor);
}
#line 10950 "../LemonSrc/SQLParserL.c"
        break;
      case 391: /* isSubstringOfPredicate ::= nonPredicateValueExpression IS SUBSTRING OF nonPredicateValueExpression */
#line 2679 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_IsSubstringOf,
									 yymsp[-4].minor.yy1172, yymsp[0].minor.yy1172,
									 ValueExpression::Boolean);
	  yy_destructor(yypParser,25,&yymsp[-3].minor);
  yy_destructor(yypParser,122,&yymsp[-2].minor);
  yy_destructor(yypParser,123,&yymsp[-1].minor);
}
#line 10962 "../LemonSrc/SQLParserL.c"
        break;
      case 395: /* stringRowValueExpression ::= LEFT_PARENTHESIS stringValueExpression RIGHT_PARENTHESIS */
      case 428: /* numericRowValueExpression ::= LEFT_PARENTHESIS numericValueExpression RIGHT_PARENTHESIS */ yytestcase(yyruleno==428);
      case 452: /* datetimeRowValueExpression ::= LEFT_PARENTHESIS datetimeValueExpression RIGHT_PARENTHESIS */ yytestcase(yyruleno==452);
      case 459: /* generalRowValueExpression ::= LEFT_PARENTHESIS generalValueExpression RIGHT_PARENTHESIS */ yytestcase(yyruleno==459);
#line 2716 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-1].minor.yy1172->setSeparated();
		yygotominor.yy1172 = yymsp[-1].minor.yy1172;
	  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10975 "../LemonSrc/SQLParserL.c"
        break;
      case 399: /* stringValueFunction ::= SUBSTRING LEFT_PARENTHESIS stringOrArrayValueOperand FROM numericValueOperand RIGHT_PARENTHESIS */
#line 2741 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new Function::SubString(yymsp[-3].minor.yy1172, yymsp[-1].minor.yy1172);
	  yy_destructor(yypParser,122,&yymsp[-5].minor);
  yy_destructor(yypParser,66,&yymsp[-4].minor);
  yy_destructor(yypParser,76,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10986 "../LemonSrc/SQLParserL.c"
        break;
      case 400: /* stringValueFunction ::= SUBSTRING LEFT_PARENTHESIS stringOrArrayValueOperand FROM numericValueOperand FOR numericValueOperand RIGHT_PARENTHESIS */
#line 2747 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new Function::SubString(yymsp[-5].minor.yy1172, yymsp[-3].minor.yy1172, yymsp[-1].minor.yy1172);
	  yy_destructor(yypParser,122,&yymsp[-7].minor);
  yy_destructor(yypParser,66,&yymsp[-6].minor);
  yy_destructor(yypParser,76,&yymsp[-4].minor);
  yy_destructor(yypParser,78,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 10998 "../LemonSrc/SQLParserL.c"
        break;
      case 401: /* stringValueFunction ::= OVERLAY LEFT_PARENTHESIS stringOrArrayValueOperand PLACING stringOrArrayValueOperand FROM numericValueOperand RIGHT_PARENTHESIS */
#line 2753 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new Function::Overlay(yymsp[-5].minor.yy1172, yymsp[-3].minor.yy1172, yymsp[-1].minor.yy1172);
	  yy_destructor(yypParser,124,&yymsp[-7].minor);
  yy_destructor(yypParser,66,&yymsp[-6].minor);
  yy_destructor(yypParser,125,&yymsp[-4].minor);
  yy_destructor(yypParser,76,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11010 "../LemonSrc/SQLParserL.c"
        break;
      case 402: /* stringValueFunction ::= OVERLAY LEFT_PARENTHESIS stringOrArrayValueOperand PLACING stringOrArrayValueOperand FROM numericValueOperand FOR numericValueOperand RIGHT_PARENTHESIS */
#line 2760 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new Function::Overlay(yymsp[-7].minor.yy1172, yymsp[-5].minor.yy1172, yymsp[-3].minor.yy1172, yymsp[-1].minor.yy1172);
	  yy_destructor(yypParser,124,&yymsp[-9].minor);
  yy_destructor(yypParser,66,&yymsp[-8].minor);
  yy_destructor(yypParser,125,&yymsp[-6].minor);
  yy_destructor(yypParser,76,&yymsp[-4].minor);
  yy_destructor(yypParser,78,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11023 "../LemonSrc/SQLParserL.c"
        break;
      case 403: /* stringValueFunction ::= NORMALIZE LEFT_PARENTHESIS stringValueOperand USING stringValueOperand RIGHT_PARENTHESIS */
#line 2767 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new Function::Normalize(yymsp[-3].minor.yy1172, yymsp[-1].minor.yy1172);
	  yy_destructor(yypParser,126,&yymsp[-5].minor);
  yy_destructor(yypParser,66,&yymsp[-4].minor);
  yy_destructor(yypParser,33,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11034 "../LemonSrc/SQLParserL.c"
        break;
      case 404: /* stringValueFunction ::= KWIC LEFT_PARENTHESIS singleElementFulltextOperand FOR kwicNumericOption optionalKwicStartTag optionalKwicEndTag optionalKwicEscape optionalKwicEllipsis RIGHT_PARENTHESIS */
#line 2774 "../LemonSrc/SQLParserL.lemon"
{
		if (yymsp[-4].minor.yy1172 == 0 && yymsp[-3].minor.yy1172 != 0)
		{
			// yymsp[-3].minor.yy1172 needs yymsp[-4].minor.yy1172.
			pParser->throwSyntaxErrorException(srcFile ,__LINE__);
		}
		yygotominor.yy1172 = new Function::Kwic(yymsp[-7].minor.yy1172, yymsp[-5].minor.yy1172, yymsp[-4].minor.yy1172, yymsp[-3].minor.yy1172, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172);
	  yy_destructor(yypParser,127,&yymsp[-9].minor);
  yy_destructor(yypParser,66,&yymsp[-8].minor);
  yy_destructor(yypParser,78,&yymsp[-6].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11050 "../LemonSrc/SQLParserL.c"
        break;
      case 406: /* optionalKwicStartTag ::= ENCLOSE WITH kwicStringOption */
#line 2791 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,128,&yymsp[-2].minor);
  yy_destructor(yypParser,74,&yymsp[-1].minor);
}
#line 11057 "../LemonSrc/SQLParserL.c"
        break;
      case 408: /* optionalKwicEndTag ::= AND kwicStringOption */
#line 2801 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,15,&yymsp[-1].minor);
}
#line 11063 "../LemonSrc/SQLParserL.c"
        break;
      case 412: /* optionalKwicEllipsis ::= ELLIPSIS kwicStringOption */
#line 2821 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,129,&yymsp[-1].minor);
}
#line 11069 "../LemonSrc/SQLParserL.c"
        break;
      case 417: /* stringConcatenation ::= stringOrArrayValueOperand STRING_CONCAT stringOrArrayValueOperand */
#line 2850 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_String_concat, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172);
	  yy_destructor(yypParser,39,&yymsp[-1].minor);
}
#line 11077 "../LemonSrc/SQLParserL.c"
        break;
      case 423: /* stringOrArrayValueOperand ::= arrayRowValueExpression */
      case 424: /* stringOrArrayValueOperand ::= arrayValueExpressionPrimary */ yytestcase(yyruleno==424);
      case 524: /* nonPredicateValueExpressionPrimary ::= arrayValueExpressionPrimary */ yytestcase(yyruleno==524);
      case 530: /* rowValueConstructor ::= arrayRowValueExpression */ yytestcase(yyruleno==530);
#line 2876 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy584; }
#line 11085 "../LemonSrc/SQLParserL.c"
        break;
      case 433: /* numericValueFunction ::= ABS LEFT_PARENTHESIS numericValueOperand RIGHT_PARENTHESIS */
#line 2928 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Abs, yymsp[-1].minor.yy1172);
	  yy_destructor(yypParser,130,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11095 "../LemonSrc/SQLParserL.c"
        break;
      case 434: /* numericValueFunction ::= MOD LEFT_PARENTHESIS numericValueOperand COMMA numericValueOperand RIGHT_PARENTHESIS */
#line 2933 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Mod, yymsp[-3].minor.yy1172, yymsp[-1].minor.yy1172);
	  yy_destructor(yypParser,131,&yymsp[-5].minor);
  yy_destructor(yypParser,66,&yymsp[-4].minor);
  yy_destructor(yypParser,13,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11106 "../LemonSrc/SQLParserL.c"
        break;
      case 436: /* numericValueFunction ::= GET MAX LEFT_PARENTHESIS scoreList RIGHT_PARENTHESIS */
#line 2942 "../LemonSrc/SQLParserL.lemon"
{
		if (yymsp[-1].minor.yy1140->getCount() == 1) {
			yygotominor.yy1172 = yymsp[-1].minor.yy1140->getValueExpressionAt(0);
		} else {
			yygotominor.yy1172 = ValueExpression::create(ValueExpression::func_GetMax,
											 yymsp[-1].minor.yy1140);
			delete yymsp[-1].minor.yy1140;
		}
	  yy_destructor(yypParser,132,&yymsp[-4].minor);
  yy_destructor(yypParser,133,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11123 "../LemonSrc/SQLParserL.c"
        break;
      case 437: /* numericValueSetFunction ::= COUNT LEFT_PARENTHESIS ASTERISK RIGHT_PARENTHESIS */
#line 2958 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Func,
									 ValueExpression::func_Count,
									 ValueExpression::Numeric,
									 0,
									 0,
									 ValueExpression::type_Aggregation);
	  yy_destructor(yypParser,134,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,40,&yymsp[-1].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11139 "../LemonSrc/SQLParserL.c"
        break;
      case 438: /* numericValueSetFunction ::= COUNT LEFT_PARENTHESIS optionalSetQuantifier nonPredicateValueExpression RIGHT_PARENTHESIS */
#line 2968 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Func,
									 ValueExpression::func_Count,
									 ValueExpression::Numeric,
									 yymsp[-2].minor.yy764,
									 yymsp[-1].minor.yy1172,
									 ValueExpression::type_Aggregation);
	  yy_destructor(yypParser,134,&yymsp[-4].minor);
  yy_destructor(yypParser,66,&yymsp[-3].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11154 "../LemonSrc/SQLParserL.c"
        break;
      case 439: /* numericValueSetFunction ::= AVG LEFT_PARENTHESIS optionalSetQuantifier numericValueOperand RIGHT_PARENTHESIS */
#line 2978 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Func,
									 ValueExpression::func_Avg,
									 ValueExpression::Numeric,
									 yymsp[-2].minor.yy764,
									 yymsp[-1].minor.yy1172,
									 ValueExpression::type_Aggregation);
	  yy_destructor(yypParser,135,&yymsp[-4].minor);
  yy_destructor(yypParser,66,&yymsp[-3].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11169 "../LemonSrc/SQLParserL.c"
        break;
      case 440: /* numericValueSetFunction ::= SUM LEFT_PARENTHESIS optionalSetQuantifier numericValueOperand RIGHT_PARENTHESIS */
#line 2989 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Func,
									 ValueExpression::func_Sum,
									 ValueExpression::Numeric,
									 yymsp[-2].minor.yy764,
									 yymsp[-1].minor.yy1172,
									 ValueExpression::type_Aggregation);
	  yy_destructor(yypParser,136,&yymsp[-4].minor);
  yy_destructor(yypParser,66,&yymsp[-3].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11184 "../LemonSrc/SQLParserL.c"
        break;
      case 441: /* arithmeticOperation ::= numericValueOperand PLUS numericValueOperand */
#line 3004 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Add, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172);
	  yy_destructor(yypParser,37,&yymsp[-1].minor);
}
#line 11192 "../LemonSrc/SQLParserL.c"
        break;
      case 442: /* arithmeticOperation ::= numericValueOperand MINUS numericValueOperand */
#line 3009 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Sub, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172);
	  yy_destructor(yypParser,38,&yymsp[-1].minor);
}
#line 11200 "../LemonSrc/SQLParserL.c"
        break;
      case 443: /* arithmeticOperation ::= numericValueOperand ASTERISK numericValueOperand */
#line 3014 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Mul, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172);
	  yy_destructor(yypParser,40,&yymsp[-1].minor);
}
#line 11208 "../LemonSrc/SQLParserL.c"
        break;
      case 444: /* arithmeticOperation ::= numericValueOperand SOLIDUS numericValueOperand */
#line 3019 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Div, yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172);
	  yy_destructor(yypParser,41,&yymsp[-1].minor);
}
#line 11216 "../LemonSrc/SQLParserL.c"
        break;
      case 445: /* arithmeticOperation ::= PLUS numericValueOperand */
#line 3025 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = yymsp[0].minor.yy1172;
	  yy_destructor(yypParser,37,&yymsp[-1].minor);
}
#line 11224 "../LemonSrc/SQLParserL.c"
        break;
      case 446: /* arithmeticOperation ::= MINUS numericValueOperand */
#line 3031 "../LemonSrc/SQLParserL.lemon"
{
		if (yymsp[0].minor.yy1172->isNumberLiteral() && !yymsp[0].minor.yy1172->isSeparated()) {
			yymsp[0].minor.yy1172->setSignNegative(yymsp[-1].minor.yy0);
			yygotominor.yy1172 = yymsp[0].minor.yy1172;
		} else {
			yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Neg, yymsp[0].minor.yy1172);
		}
		delete yymsp[-1].minor.yy0;
	}
#line 11237 "../LemonSrc/SQLParserL.c"
        break;
      case 455: /* datetimeValueFunction ::= CURRENT_DATE */
#line 3095 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Func,
									 ValueExpression::func_Current_Date,
									 ValueExpression::Datetime, 0, 0,
									 ValueExpression::type_Value);
	  yy_destructor(yypParser,137,&yymsp[0].minor);
}
#line 11248 "../LemonSrc/SQLParserL.c"
        break;
      case 456: /* datetimeValueFunction ::= CURRENT_TIMESTAMP */
#line 3102 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Func,
									 ValueExpression::func_Current_Timestamp,
									 ValueExpression::Datetime, 0, 0,
									 ValueExpression::type_Value);
	  yy_destructor(yypParser,138,&yymsp[0].minor);
}
#line 11259 "../LemonSrc/SQLParserL.c"
        break;
      case 466: /* generalFunction0Arg ::= identifier LEFT_PARENTHESIS RIGHT_PARENTHESIS */
#line 3155 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = ValueExpression::create(yymsp[-2].minor.yy1118);
		delete yymsp[-2].minor.yy1118;
	  yy_destructor(yypParser,66,&yymsp[-1].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11269 "../LemonSrc/SQLParserL.c"
        break;
      case 467: /* generalFunction0Arg ::= identifier LEFT_PARENTHESIS RIGHT_PARENTHESIS PERIOD identifier */
#line 3161 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = ValueExpression::create(yymsp[-4].minor.yy1118, yymsp[0].minor.yy1118);
		delete yymsp[-4].minor.yy1118;
		delete yymsp[0].minor.yy1118;
	  yy_destructor(yypParser,66,&yymsp[-3].minor);
  yy_destructor(yypParser,67,&yymsp[-2].minor);
  yy_destructor(yypParser,59,&yymsp[-1].minor);
}
#line 11281 "../LemonSrc/SQLParserL.c"
        break;
      case 468: /* generalFunctionNArgs ::= identifier LEFT_PARENTHESIS rowValueConstructorList hint RIGHT_PARENTHESIS */
#line 3170 "../LemonSrc/SQLParserL.lemon"
{
		Hint* pHint = yymsp[-1].minor.yy858;
		yymsp[-1].minor.yy858 = 0;
		yygotominor.yy1172 = ValueExpression::create(yymsp[-4].minor.yy1118, yymsp[-2].minor.yy1140, pHint);
		delete yymsp[-4].minor.yy1118;
		delete yymsp[-2].minor.yy1140;
	  yy_destructor(yypParser,66,&yymsp[-3].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11294 "../LemonSrc/SQLParserL.c"
        break;
      case 469: /* generalFunctionNArgs ::= identifier LEFT_PARENTHESIS rowValueConstructorList hint RIGHT_PARENTHESIS PERIOD identifier */
#line 3179 "../LemonSrc/SQLParserL.lemon"
{
		Hint* pHint = yymsp[-3].minor.yy858;
		yymsp[-3].minor.yy858 = 0;
		yygotominor.yy1172 = ValueExpression::create(yymsp[-6].minor.yy1118, yymsp[0].minor.yy1118, yymsp[-4].minor.yy1140, pHint);
		delete yymsp[-6].minor.yy1118;
		delete yymsp[0].minor.yy1118;
		delete yymsp[-4].minor.yy1140;
	  yy_destructor(yypParser,66,&yymsp[-5].minor);
  yy_destructor(yypParser,67,&yymsp[-2].minor);
  yy_destructor(yypParser,59,&yymsp[-1].minor);
}
#line 11309 "../LemonSrc/SQLParserL.c"
        break;
      case 470: /* caseExpression ::= caseSimpleCase */
      case 471: /* caseExpression ::= caseSearchedCase */ yytestcase(yyruleno==471);
      case 474: /* caseOperand ::= nonPredicateValueExpression */ yytestcase(yyruleno==474);
#line 3195 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy1172 = yymsp[0].minor.yy1172;
}
#line 11318 "../LemonSrc/SQLParserL.c"
        break;
      case 472: /* caseSimpleCase ::= CASE caseOperand simpleWhenClauseList optionalElseClause END */
#line 3210 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy1172 = new Expression::SimpleCase(yymsp[-3].minor.yy1172, yymsp[-2].minor.yy1140, yymsp[-1].minor.yy1172);
  yy_destructor(yypParser,139,&yymsp[-4].minor);
  yy_destructor(yypParser,140,&yymsp[0].minor);
}
#line 11327 "../LemonSrc/SQLParserL.c"
        break;
      case 473: /* caseSearchedCase ::= CASE searchedWhenClauseList optionalElseClause END */
#line 3221 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy1172 = new Expression::SearchedCase(yymsp[-2].minor.yy1140, yymsp[-1].minor.yy1172);
  yy_destructor(yypParser,139,&yymsp[-3].minor);
  yy_destructor(yypParser,140,&yymsp[0].minor);
}
#line 11336 "../LemonSrc/SQLParserL.c"
        break;
      case 475: /* simpleWhenClauseList ::= simpleWhenClause */
      case 478: /* simpleWhenOperandList ::= nonPredicateValueExpression */ yytestcase(yyruleno==478);
      case 480: /* searchedWhenClauseList ::= searchedWhenClause */ yytestcase(yyruleno==480);
#line 3239 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy1140 = new ValueExpressionList(yymsp[0].minor.yy1172);
}
#line 11345 "../LemonSrc/SQLParserL.c"
        break;
      case 476: /* simpleWhenClauseList ::= simpleWhenClauseList simpleWhenClause */
      case 481: /* searchedWhenClauseList ::= searchedWhenClauseList searchedWhenClause */ yytestcase(yyruleno==481);
#line 3244 "../LemonSrc/SQLParserL.lemon"
{
	yymsp[-1].minor.yy1140->appendValueExpression(yymsp[0].minor.yy1172);
	yygotominor.yy1140 = yymsp[-1].minor.yy1140;
}
#line 11354 "../LemonSrc/SQLParserL.c"
        break;
      case 477: /* simpleWhenClause ::= WHEN simpleWhenOperandList THEN nonPredicateValueExpression */
#line 3254 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy1172 = new Expression::SimpleWhen(yymsp[-2].minor.yy1140, yymsp[0].minor.yy1172);
  yy_destructor(yypParser,141,&yymsp[-3].minor);
  yy_destructor(yypParser,142,&yymsp[-1].minor);
}
#line 11363 "../LemonSrc/SQLParserL.c"
        break;
      case 479: /* simpleWhenOperandList ::= simpleWhenOperandList COMMA nonPredicateValueExpression */
#line 3268 "../LemonSrc/SQLParserL.lemon"
{
	yymsp[-2].minor.yy1140->appendValueExpression(yymsp[0].minor.yy1172);
	yygotominor.yy1140 = yymsp[-2].minor.yy1140;
  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 11372 "../LemonSrc/SQLParserL.c"
        break;
      case 482: /* searchedWhenClause ::= WHEN searchCondition THEN nonPredicateValueExpression */
#line 3293 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy1172 = new Expression::SearchedWhen(yymsp[-2].minor.yy1172, yymsp[0].minor.yy1172);
  yy_destructor(yypParser,141,&yymsp[-3].minor);
  yy_destructor(yypParser,142,&yymsp[-1].minor);
}
#line 11381 "../LemonSrc/SQLParserL.c"
        break;
      case 483: /* optionalElseClause ::= */
#line 3302 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy1172 = 0;
}
#line 11388 "../LemonSrc/SQLParserL.c"
        break;
      case 484: /* optionalElseClause ::= ELSE nonPredicateValueExpression */
#line 3307 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy1172 = yymsp[0].minor.yy1172;
  yy_destructor(yypParser,143,&yymsp[-1].minor);
}
#line 11396 "../LemonSrc/SQLParserL.c"
        break;
      case 485: /* generalSetFunction ::= MAX LEFT_PARENTHESIS optionalSetQuantifier nonPredicateValueExpression RIGHT_PARENTHESIS */
#line 3319 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Func,
									 ValueExpression::func_Max,
									 ValueExpression::Numeric,
									 yymsp[-2].minor.yy764,
									 yymsp[-1].minor.yy1172,
									 ValueExpression::type_Aggregation);
	  yy_destructor(yypParser,133,&yymsp[-4].minor);
  yy_destructor(yypParser,66,&yymsp[-3].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11411 "../LemonSrc/SQLParserL.c"
        break;
      case 486: /* generalSetFunction ::= MIN LEFT_PARENTHESIS optionalSetQuantifier nonPredicateValueExpression RIGHT_PARENTHESIS */
#line 3330 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Func,
									 ValueExpression::func_Min,
									 ValueExpression::Numeric,
									 yymsp[-2].minor.yy764,
									 yymsp[-1].minor.yy1172,
									 ValueExpression::type_Aggregation);
	  yy_destructor(yypParser,144,&yymsp[-4].minor);
  yy_destructor(yypParser,66,&yymsp[-3].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11426 "../LemonSrc/SQLParserL.c"
        break;
      case 487: /* generalSetFunction ::= SECTIONIZED LEFT_PARENTHESIS fulltextOperand RIGHT_PARENTHESIS */
#line 3341 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = ValueExpression::create(ValueExpression::func_Sectionized,
										 yymsp[-1].minor.yy1140);
		delete yymsp[-1].minor.yy1140;
	  yy_destructor(yypParser,145,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11438 "../LemonSrc/SQLParserL.c"
        break;
      case 488: /* generalSetFunction ::= WORD LEFT_PARENTHESIS fulltextOperand RIGHT_PARENTHESIS */
#line 3349 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = ValueExpression::create(ValueExpression::func_Word,
										 yymsp[-1].minor.yy1140);
		delete yymsp[-1].minor.yy1140;
	  yy_destructor(yypParser,93,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11450 "../LemonSrc/SQLParserL.c"
        break;
      case 489: /* generalSetFunction ::= WORD LEFT_PARENTHESIS fulltextOperand RIGHT_PARENTHESIS PERIOD DF */
#line 3358 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = ValueExpression::create(ValueExpression::func_WordDf,
										 yymsp[-3].minor.yy1140);
		delete yymsp[-3].minor.yy1140;
	  yy_destructor(yypParser,93,&yymsp[-5].minor);
  yy_destructor(yypParser,66,&yymsp[-4].minor);
  yy_destructor(yypParser,67,&yymsp[-2].minor);
  yy_destructor(yypParser,59,&yymsp[-1].minor);
  yy_destructor(yypParser,115,&yymsp[0].minor);
}
#line 11464 "../LemonSrc/SQLParserL.c"
        break;
      case 490: /* generalSetFunction ::= WORD LEFT_PARENTHESIS fulltextOperand RIGHT_PARENTHESIS PERIOD SCALE */
#line 3367 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = ValueExpression::create(ValueExpression::func_WordScale,
										 yymsp[-3].minor.yy1140);
		delete yymsp[-3].minor.yy1140;
	  yy_destructor(yypParser,93,&yymsp[-5].minor);
  yy_destructor(yypParser,66,&yymsp[-4].minor);
  yy_destructor(yypParser,67,&yymsp[-2].minor);
  yy_destructor(yypParser,59,&yymsp[-1].minor);
  yy_destructor(yypParser,91,&yymsp[0].minor);
}
#line 11478 "../LemonSrc/SQLParserL.c"
        break;
      case 491: /* fulltextOperand ::= singleElementFulltextOperand */
      case 496: /* fulltextOperandList ::= singleElementFulltextOperand */ yytestcase(yyruleno==496);
      case 499: /* scoreList ::= score */ yytestcase(yyruleno==499);
      case 534: /* rowValueConstructorList ::= rowValueConstructorElement */ yytestcase(yyruleno==534);
      case 538: /* tableValueConstructorList ::= rowValueExpression */ yytestcase(yyruleno==538);
#line 3379 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1140 = new ValueExpressionList(yymsp[0].minor.yy1172);
	}
#line 11489 "../LemonSrc/SQLParserL.c"
        break;
      case 492: /* fulltextOperand ::= multiElementFulltextOperand */
#line 3383 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1140 = yymsp[0].minor.yy1140;
	}
#line 11496 "../LemonSrc/SQLParserL.c"
        break;
      case 493: /* fulltextOperand ::= LEFT_PARENTHESIS fulltextOperand RIGHT_PARENTHESIS */
#line 3387 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1140 = yymsp[-1].minor.yy1140;
	  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11505 "../LemonSrc/SQLParserL.c"
        break;
      case 495: /* multiElementFulltextOperand ::= singleElementFulltextOperand COMMA fulltextOperandList */
#line 3406 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[0].minor.yy1140->insertValueExpression(yymsp[-2].minor.yy1172);
		yygotominor.yy1140 = yymsp[0].minor.yy1140;
	  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 11514 "../LemonSrc/SQLParserL.c"
        break;
      case 497: /* fulltextOperandList ::= fulltextOperandList COMMA singleElementFulltextOperand */
      case 500: /* scoreList ::= scoreList COMMA score */ yytestcase(yyruleno==500);
      case 535: /* rowValueConstructorList ::= rowValueConstructorList COMMA rowValueConstructorElement */ yytestcase(yyruleno==535);
      case 539: /* tableValueConstructorList ::= tableValueConstructorList COMMA rowValueExpression */ yytestcase(yyruleno==539);
#line 3418 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-2].minor.yy1140->appendValueExpression(yymsp[0].minor.yy1172);
		yygotominor.yy1140 = yymsp[-2].minor.yy1140;
	  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 11526 "../LemonSrc/SQLParserL.c"
        break;
      case 498: /* score ::= SCORE LEFT_PARENTHESIS fulltextOperand RIGHT_PARENTHESIS */
#line 3427 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = ValueExpression::create(ValueExpression::func_Score,
										 yymsp[-1].minor.yy1140);
		delete yymsp[-1].minor.yy1140;
	  yy_destructor(yypParser,116,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11538 "../LemonSrc/SQLParserL.c"
        break;
      case 501: /* arrayValueExpression ::= arrayRowValueExpression */
      case 502: /* arrayValueExpression ::= arrayValueExpressionPrimary */ yytestcase(yyruleno==502);
      case 504: /* arrayValueExpressionPrimary ::= arrayValueConstructor */ yytestcase(yyruleno==504);
      case 513: /* arrayValueOperand ::= arrayRowValueExpression */ yytestcase(yyruleno==513);
      case 514: /* arrayValueOperand ::= arrayValueExpressionPrimary */ yytestcase(yyruleno==514);
#line 3450 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy584 = yymsp[0].minor.yy584; }
#line 11547 "../LemonSrc/SQLParserL.c"
        break;
      case 503: /* arrayRowValueExpression ::= LEFT_PARENTHESIS arrayValueExpression RIGHT_PARENTHESIS */
#line 3461 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-1].minor.yy584->setSeparated();
		yygotominor.yy584 = yymsp[-1].minor.yy584;
	  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11557 "../LemonSrc/SQLParserL.c"
        break;
      case 505: /* arrayValueExpressionPrimary ::= arrayStringFunction */
      case 512: /* arrayElement ::= nonPredicateValueExpression */ yytestcase(yyruleno==512);
      case 515: /* arrayValueOperand ::= generalValueExpression */ yytestcase(yyruleno==515);
#line 3474 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy584 = yymsp[0].minor.yy1172; }
#line 11564 "../LemonSrc/SQLParserL.c"
        break;
      case 506: /* arrayValueConstructor ::= ARRAY LEFT_BRACKET arrayElementList RIGHT_BRACKET */
#line 3483 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy584 = new ValueExpression(ValueExpression::op_Arrayconst,
									 yymsp[-1].minor.yy616,
									 ValueExpression::Array,
									 yymsp[-1].minor.yy616->getExpressionType());
	  yy_destructor(yypParser,146,&yymsp[-3].minor);
  yy_destructor(yypParser,60,&yymsp[-2].minor);
  yy_destructor(yypParser,61,&yymsp[0].minor);
}
#line 11577 "../LemonSrc/SQLParserL.c"
        break;
      case 507: /* arrayValueConstructor ::= ARRAY LEFT_BRACKET RIGHT_BRACKET */
#line 3490 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy584 = new ValueExpression(ValueExpression::op_Arrayconst,
									 0,
									 ValueExpression::Array,
									 ValueExpression::type_Value);
	  yy_destructor(yypParser,146,&yymsp[-2].minor);
  yy_destructor(yypParser,60,&yymsp[-1].minor);
  yy_destructor(yypParser,61,&yymsp[0].minor);
}
#line 11590 "../LemonSrc/SQLParserL.c"
        break;
      case 509: /* expandStringFunction ::= EXPAND_SYNONYM LEFT_PARENTHESIS stringValueOperand USING stringValueOperand RIGHT_PARENTHESIS */
#line 3509 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new Function::ExpandSynonym(yymsp[-3].minor.yy1172, yymsp[-1].minor.yy1172);
	  yy_destructor(yypParser,99,&yymsp[-5].minor);
  yy_destructor(yypParser,66,&yymsp[-4].minor);
  yy_destructor(yypParser,33,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11601 "../LemonSrc/SQLParserL.c"
        break;
      case 510: /* arrayElementList ::= arrayElement */
#line 3519 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy616 = new ValueExpressionList(yymsp[0].minor.yy584);
	}
#line 11608 "../LemonSrc/SQLParserL.c"
        break;
      case 511: /* arrayElementList ::= arrayElementList COMMA arrayElement */
#line 3523 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-2].minor.yy616->appendValueExpression(yymsp[0].minor.yy584);
		yygotominor.yy616 = yymsp[-2].minor.yy616;
	  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 11617 "../LemonSrc/SQLParserL.c"
        break;
      case 532: /* multiElementRowValueConstructor ::= LEFT_PARENTHESIS rowValueConstructorElement COMMA rowValueConstructorList RIGHT_PARENTHESIS */
#line 3622 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-1].minor.yy1140->insertValueExpression(yymsp[-3].minor.yy1172);
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Rowconst,
									 yymsp[-1].minor.yy1140,
									 ValueExpression::Row,
									 yymsp[-1].minor.yy1140->getExpressionType());
	  yy_destructor(yypParser,66,&yymsp[-4].minor);
  yy_destructor(yypParser,13,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11631 "../LemonSrc/SQLParserL.c"
        break;
      case 533: /* multiElementRowValueConstructor ::= ROW LEFT_PARENTHESIS rowValueConstructorList RIGHT_PARENTHESIS */
#line 3631 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Rowconst,
									   yymsp[-1].minor.yy1140,
									   ValueExpression::Row,
									   yymsp[-1].minor.yy1140->getExpressionType());
	  yy_destructor(yypParser,147,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 11644 "../LemonSrc/SQLParserL.c"
        break;
      case 537: /* tableValueConstructor ::= VALUES tableValueConstructorList */
#line 3668 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new ValueExpression(ValueExpression::op_Tblconst,
									 yymsp[0].minor.yy1140,
									 ValueExpression::Table,
									 yymsp[0].minor.yy1140->getExpressionType());
	  yy_destructor(yypParser,148,&yymsp[-1].minor);
}
#line 11655 "../LemonSrc/SQLParserL.c"
        break;
      case 540: /* tableValueConstructorList ::= tableValueConstructorList COMMA */
#line 3692 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1140 = yymsp[-1].minor.yy1140;   yy_destructor(yypParser,13,&yymsp[0].minor);
}
#line 11661 "../LemonSrc/SQLParserL.c"
        break;
      case 541: /* explicitTable ::= TABLE tableName */
#line 3700 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy934 = yymsp[0].minor.yy1118;
	  yy_destructor(yypParser,149,&yymsp[-1].minor);
}
#line 11669 "../LemonSrc/SQLParserL.c"
        break;
      case 542: /* deleteStatement ::= delete targetTable optionalWhereClause */
#line 3711 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy171 = new DeleteStatement(yymsp[-1].minor.yy1118, yymsp[0].minor.yy1172);
	}
#line 11676 "../LemonSrc/SQLParserL.c"
        break;
      case 543: /* deleteStatement ::= delete targetTable asCorrelationName optionalWhereClause */
#line 3716 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy171 = new DeleteStatement(yymsp[-2].minor.yy1118, yymsp[0].minor.yy1172, yymsp[-1].minor.yy1118);
	}
#line 11683 "../LemonSrc/SQLParserL.c"
        break;
      case 544: /* delete ::= DELETE FROM */
#line 3722 "../LemonSrc/SQLParserL.lemon"
{
  yy_destructor(yypParser,150,&yymsp[-1].minor);
  yy_destructor(yypParser,76,&yymsp[0].minor);
}
#line 11691 "../LemonSrc/SQLParserL.c"
        break;
      case 545: /* delete ::= DELETE */
#line 3723 "../LemonSrc/SQLParserL.lemon"
{
  yy_destructor(yypParser,150,&yymsp[0].minor);
}
#line 11698 "../LemonSrc/SQLParserL.c"
        break;
      case 547: /* insertStatement ::= insert tableName insertColumnsAndSource */
#line 3742 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy13 = new InsertStatement(yymsp[-1].minor.yy1118,
									 yymsp[0].minor.yy853->getQuery(),
									 yymsp[0].minor.yy853->getColumnList());
		// 下位オブジェクトは使う。destruct()してはいけない。
		yymsp[0].minor.yy853->clearBody();
		delete yymsp[0].minor.yy853;
	}
#line 11710 "../LemonSrc/SQLParserL.c"
        break;
      case 548: /* insert ::= INSERT INTO */
#line 3753 "../LemonSrc/SQLParserL.lemon"
{
  yy_destructor(yypParser,151,&yymsp[-1].minor);
  yy_destructor(yypParser,69,&yymsp[0].minor);
}
#line 11718 "../LemonSrc/SQLParserL.c"
        break;
      case 549: /* insert ::= INSERT */
#line 3754 "../LemonSrc/SQLParserL.lemon"
{
  yy_destructor(yypParser,151,&yymsp[0].minor);
}
#line 11725 "../LemonSrc/SQLParserL.c"
        break;
      case 550: /* insertColumnsAndSource ::= LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS queryExpression */
      case 553: /* insertColumnsAndSource ::= LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS bulkInput */ yytestcase(yyruleno==553);
#line 3763 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy853 = new InsertColumnsAndSource(yymsp[0].minor.yy533, yymsp[-2].minor.yy1234);
	  yy_destructor(yypParser,66,&yymsp[-3].minor);
  yy_destructor(yypParser,67,&yymsp[-1].minor);
}
#line 11735 "../LemonSrc/SQLParserL.c"
        break;
      case 551: /* insertColumnsAndSource ::= queryExpression */
      case 554: /* insertColumnsAndSource ::= bulkInput */ yytestcase(yyruleno==554);
#line 3768 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy853 = new InsertColumnsAndSource(yymsp[0].minor.yy533, 0);
	}
#line 11743 "../LemonSrc/SQLParserL.c"
        break;
      case 552: /* insertColumnsAndSource ::= DEFAULT VALUES */
#line 3773 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy853 = new InsertColumnsAndSource();
	  yy_destructor(yypParser,53,&yymsp[-1].minor);
  yy_destructor(yypParser,148,&yymsp[0].minor);
}
#line 11752 "../LemonSrc/SQLParserL.c"
        break;
      case 555: /* bulkInput ::= INPUT FROM bulkSpecification */
#line 3794 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[0].minor.yy707->setInput(true);
		yygotominor.yy533 = new QueryExpression(yymsp[0].minor.yy707);
	  yy_destructor(yypParser,77,&yymsp[-2].minor);
  yy_destructor(yypParser,76,&yymsp[-1].minor);
}
#line 11762 "../LemonSrc/SQLParserL.c"
        break;
      case 556: /* updateStatement ::= UPDATE targetTable SET setClauseList optionalWhereClause */
#line 3807 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy351 = new UpdateStatement(yymsp[-3].minor.yy1118, yymsp[-1].minor.yy1207, yymsp[0].minor.yy1172);
	  yy_destructor(yypParser,152,&yymsp[-4].minor);
  yy_destructor(yypParser,153,&yymsp[-2].minor);
}
#line 11771 "../LemonSrc/SQLParserL.c"
        break;
      case 557: /* updateStatement ::= UPDATE targetTable asCorrelationName SET setClauseList optionalWhereClause */
#line 3813 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy351 = new UpdateStatement(yymsp[-4].minor.yy1118, yymsp[-1].minor.yy1207, yymsp[0].minor.yy1172, yymsp[-3].minor.yy1118);
	  yy_destructor(yypParser,152,&yymsp[-5].minor);
  yy_destructor(yypParser,153,&yymsp[-2].minor);
}
#line 11780 "../LemonSrc/SQLParserL.c"
        break;
      case 558: /* setClauseList ::= setClause */
#line 3823 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1207 = new UpdateSetClauseList(yymsp[0].minor.yy263);
	}
#line 11787 "../LemonSrc/SQLParserL.c"
        break;
      case 559: /* setClauseList ::= setClauseList COMMA setClause */
#line 3828 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-2].minor.yy1207->append(yymsp[0].minor.yy263);
		yygotominor.yy1207 = yymsp[-2].minor.yy1207;
	  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 11796 "../LemonSrc/SQLParserL.c"
        break;
      case 560: /* setClauseList ::= setClauseList COMMA */
#line 3834 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1207 = yymsp[-1].minor.yy1207;   yy_destructor(yypParser,13,&yymsp[0].minor);
}
#line 11802 "../LemonSrc/SQLParserL.c"
        break;
      case 561: /* setClause ::= updateTarget EQUALS nonPredicateValueExpression */
#line 3842 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy263 = new UpdateSetClause(yymsp[-2].minor.yy370, yymsp[0].minor.yy1172);
	  yy_destructor(yypParser,19,&yymsp[-1].minor);
}
#line 11810 "../LemonSrc/SQLParserL.c"
        break;
      case 562: /* setClause ::= updateTargetList EQUALS rowValueExpression */
#line 3846 "../LemonSrc/SQLParserL.lemon"
{
		// updateTarget null means ROW
		yygotominor.yy263 = new UpdateSetClause(yymsp[-2].minor.yy1234, yymsp[0].minor.yy1172);
	  yy_destructor(yypParser,19,&yymsp[-1].minor);
}
#line 11819 "../LemonSrc/SQLParserL.c"
        break;
      case 563: /* updateTarget ::= columnName */
#line 3857 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy370 = yymsp[0].minor.yy370;
	}
#line 11826 "../LemonSrc/SQLParserL.c"
        break;
      case 565: /* startTransactionStatement ::= START TRANSACTION transactModeList */
#line 3874 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy516 = new StartTransactionStatement(yymsp[0].minor.yy662);
		delete yymsp[0].minor.yy662;
	  yy_destructor(yypParser,154,&yymsp[-2].minor);
  yy_destructor(yypParser,155,&yymsp[-1].minor);
}
#line 11836 "../LemonSrc/SQLParserL.c"
        break;
      case 566: /* transactModeList ::= transactMode */
#line 3885 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy662 = new TransactionModeList(yymsp[0].minor.yy934);
	}
#line 11843 "../LemonSrc/SQLParserL.c"
        break;
      case 567: /* transactModeList ::= transactModeList COMMA transactMode */
#line 3889 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-2].minor.yy662->append(yymsp[0].minor.yy934);
		yygotominor.yy662 = yymsp[-2].minor.yy662;
	  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 11852 "../LemonSrc/SQLParserL.c"
        break;
      case 568: /* transactMode ::= transactAccMode */
#line 3900 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy715; }
#line 11857 "../LemonSrc/SQLParserL.c"
        break;
      case 569: /* transactMode ::= isolationLevel */
#line 3902 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy565; }
#line 11862 "../LemonSrc/SQLParserL.c"
        break;
      case 570: /* transactMode ::= usingSnapshotMode */
#line 3904 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy754; }
#line 11867 "../LemonSrc/SQLParserL.c"
        break;
      case 571: /* transactAccMode ::= READ ONLY */
#line 3912 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy715 = new TransactAccMode(
					new IntegerValue(TransactionMode::ReadOnly));
	  yy_destructor(yypParser,156,&yymsp[-1].minor);
  yy_destructor(yypParser,157,&yymsp[0].minor);
}
#line 11877 "../LemonSrc/SQLParserL.c"
        break;
      case 572: /* transactAccMode ::= READ WRITE */
#line 3917 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy715 = new TransactAccMode(
					new IntegerValue(TransactionMode::ReadWrite));
	  yy_destructor(yypParser,156,&yymsp[-1].minor);
  yy_destructor(yypParser,158,&yymsp[0].minor);
}
#line 11887 "../LemonSrc/SQLParserL.c"
        break;
      case 573: /* isolationLevel ::= ISOLATION LEVEL levelOfIsolation */
#line 3928 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy565 = yymsp[0].minor.yy565;   yy_destructor(yypParser,159,&yymsp[-2].minor);
  yy_destructor(yypParser,160,&yymsp[-1].minor);
}
#line 11894 "../LemonSrc/SQLParserL.c"
        break;
      case 574: /* levelOfIsolation ::= READ UNCOMMITTED */
#line 3933 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy565 = new IsolationLevel(
					new IntegerValue(TransactionMode::ReadUncommitted));
	  yy_destructor(yypParser,156,&yymsp[-1].minor);
  yy_destructor(yypParser,161,&yymsp[0].minor);
}
#line 11904 "../LemonSrc/SQLParserL.c"
        break;
      case 575: /* levelOfIsolation ::= READ COMMITTED */
#line 3938 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy565 = new IsolationLevel(
					new IntegerValue(TransactionMode::ReadCommitted));
	  yy_destructor(yypParser,156,&yymsp[-1].minor);
  yy_destructor(yypParser,162,&yymsp[0].minor);
}
#line 11914 "../LemonSrc/SQLParserL.c"
        break;
      case 576: /* levelOfIsolation ::= REPEATABLE READ */
#line 3943 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy565 = new IsolationLevel(
					new IntegerValue(TransactionMode::RepeatableRead));
	  yy_destructor(yypParser,163,&yymsp[-1].minor);
  yy_destructor(yypParser,156,&yymsp[0].minor);
}
#line 11924 "../LemonSrc/SQLParserL.c"
        break;
      case 577: /* levelOfIsolation ::= SERIALIZABLE */
#line 3948 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy565 = new IsolationLevel(
					new IntegerValue(TransactionMode::Serializable));
	  yy_destructor(yypParser,164,&yymsp[0].minor);
}
#line 11933 "../LemonSrc/SQLParserL.c"
        break;
      case 578: /* usingSnapshotMode ::= USING SNAPSHOT */
#line 3959 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy754 = new IntegerValue(1);
	  yy_destructor(yypParser,33,&yymsp[-1].minor);
  yy_destructor(yypParser,165,&yymsp[0].minor);
}
#line 11942 "../LemonSrc/SQLParserL.c"
        break;
      case 579: /* setTransactionStatement ::= SET TRANSACTION transactModeList */
#line 3970 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy918 = new SetTransactionStatement(yymsp[0].minor.yy662);
		delete yymsp[0].minor.yy662;
	  yy_destructor(yypParser,153,&yymsp[-2].minor);
  yy_destructor(yypParser,155,&yymsp[-1].minor);
}
#line 11952 "../LemonSrc/SQLParserL.c"
        break;
      case 580: /* commitStatement ::= COMMIT */
#line 3982 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1197 = new CommitStatement();
	  yy_destructor(yypParser,166,&yymsp[0].minor);
}
#line 11960 "../LemonSrc/SQLParserL.c"
        break;
      case 581: /* commitStatement ::= COMMIT WORK */
#line 3986 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1197 = new CommitStatement();
	  yy_destructor(yypParser,166,&yymsp[-1].minor);
  yy_destructor(yypParser,167,&yymsp[0].minor);
}
#line 11969 "../LemonSrc/SQLParserL.c"
        break;
      case 582: /* rollbackStatement ::= ROLLBACK */
#line 3997 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy110 = new RollbackStatement();
	  yy_destructor(yypParser,168,&yymsp[0].minor);
}
#line 11977 "../LemonSrc/SQLParserL.c"
        break;
      case 583: /* rollbackStatement ::= ROLLBACK WORK */
#line 4001 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy110 = new RollbackStatement();
	  yy_destructor(yypParser,168,&yymsp[-1].minor);
  yy_destructor(yypParser,167,&yymsp[0].minor);
}
#line 11986 "../LemonSrc/SQLParserL.c"
        break;
      case 584: /* xa_Identifier ::= binaryStringLiteral */
#line 4013 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<XA_Identifier> p = new XA_Identifier;
		p->setGlobalTransactionIdentifier(*yymsp[0].minor.yy1200);
		delete yymsp[0].minor.yy1200;

		yygotominor.yy1146 = p.release();
	}
#line 11997 "../LemonSrc/SQLParserL.c"
        break;
      case 585: /* xa_Identifier ::= binaryStringLiteral COMMA binaryStringLiteral */
#line 4021 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<XA_Identifier> p = new XA_Identifier;
		p->setGlobalTransactionIdentifier(*yymsp[-2].minor.yy1200);
		p->setBranchQualifier(*yymsp[0].minor.yy1200);
		delete yymsp[-2].minor.yy1200;
		delete yymsp[0].minor.yy1200;

		yygotominor.yy1146 = p.release();
	  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 12011 "../LemonSrc/SQLParserL.c"
        break;
      case 586: /* xa_Identifier ::= binaryStringLiteral COMMA binaryStringLiteral COMMA signedIntegerLiteral */
#line 4031 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<XA_Identifier> p = new XA_Identifier;
		p->setGlobalTransactionIdentifier(*yymsp[-4].minor.yy1200);
		p->setBranchQualifier(*yymsp[-2].minor.yy1200);
		p->setFormatIdentifier(*yymsp[0].minor.yy1200);
		delete yymsp[-4].minor.yy1200;
		delete yymsp[-2].minor.yy1200;
		delete yymsp[0].minor.yy1200;

		yygotominor.yy1146 = p.release();
	  yy_destructor(yypParser,13,&yymsp[-3].minor);
  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 12028 "../LemonSrc/SQLParserL.c"
        break;
      case 588: /* signedIntegerLiteral ::= PLUS unsignedIntegerLiteral */
#line 4053 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1200 = yymsp[0].minor.yy1200;
	  yy_destructor(yypParser,37,&yymsp[-1].minor);
}
#line 12036 "../LemonSrc/SQLParserL.c"
        break;
      case 589: /* signedIntegerLiteral ::= MINUS unsignedIntegerLiteral */
#line 4057 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1200 = new Literal(Token(yymsp[0].minor.yy1200->getToken().getToken(),
								   yymsp[-1].minor.yy0->getHead(),
								   yymsp[0].minor.yy1200->getToken().getTail()));
		delete yymsp[0].minor.yy1200;
		delete yymsp[-1].minor.yy0;
	}
#line 12047 "../LemonSrc/SQLParserL.c"
        break;
      case 590: /* xa_StartStatement ::= XA START xa_Identifier */
#line 4071 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<XA_StartStatement> p = new XA_StartStatement;
		p->setIdentifier(yymsp[0].minor.yy1146);
		// can't delete yymsp[0].minor.yy1146
		yygotominor.yy882 = p.release();
	  yy_destructor(yypParser,169,&yymsp[-2].minor);
  yy_destructor(yypParser,154,&yymsp[-1].minor);
}
#line 12059 "../LemonSrc/SQLParserL.c"
        break;
      case 591: /* xa_StartStatement ::= XA START xa_Identifier transactModeList */
#line 4078 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<XA_StartStatement> p = new XA_StartStatement;
		p->setTransactionMode(*yymsp[0].minor.yy662);
		delete yymsp[0].minor.yy662;

		// setIdentifier should be placed here
		p->setIdentifier(yymsp[-1].minor.yy1146);
		// can't delete yymsp[-1].minor.yy1146

		yygotominor.yy882 = p.release();
	  yy_destructor(yypParser,169,&yymsp[-3].minor);
  yy_destructor(yypParser,154,&yymsp[-2].minor);
}
#line 12076 "../LemonSrc/SQLParserL.c"
        break;
      case 592: /* xa_StartStatement ::= XA START xa_Identifier JOIN */
#line 4090 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<XA_StartStatement> p = new XA_StartStatement;
		p->setIdentifier(yymsp[-1].minor.yy1146);
		// can't delete yymsp[-1].minor.yy1146
		p->setJoin(true);

		yygotominor.yy882 = p.release();
	  yy_destructor(yypParser,169,&yymsp[-3].minor);
  yy_destructor(yypParser,154,&yymsp[-2].minor);
  yy_destructor(yypParser,5,&yymsp[0].minor);
}
#line 12091 "../LemonSrc/SQLParserL.c"
        break;
      case 593: /* xa_StartStatement ::= XA START xa_Identifier RESUME */
#line 4099 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<XA_StartStatement> p = new XA_StartStatement;
		p->setIdentifier(yymsp[-1].minor.yy1146);
		// can't delete yymsp[-1].minor.yy1146
		p->setResume(true);

		yygotominor.yy882 = p.release();
	  yy_destructor(yypParser,169,&yymsp[-3].minor);
  yy_destructor(yypParser,154,&yymsp[-2].minor);
  yy_destructor(yypParser,170,&yymsp[0].minor);
}
#line 12106 "../LemonSrc/SQLParserL.c"
        break;
      case 594: /* xa_EndStatement ::= XA END xa_Identifier xa_EndStatement_SuspensionMode */
#line 4114 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<XA_EndStatement> p = new XA_EndStatement;
		p->setIdentifier(yymsp[-1].minor.yy1146);
		// can't delete yymsp[-1].minor.yy1146
		p->setSuspensionMode(yymsp[0].minor.yy764);

		yygotominor.yy931 = p.release();
	  yy_destructor(yypParser,169,&yymsp[-3].minor);
  yy_destructor(yypParser,140,&yymsp[-2].minor);
}
#line 12120 "../LemonSrc/SQLParserL.c"
        break;
      case 595: /* xa_EndStatement_SuspensionMode ::= */
#line 4125 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy764 = XA_EndStatement::SuspensionMode::Unknown;
	}
#line 12127 "../LemonSrc/SQLParserL.c"
        break;
      case 596: /* xa_EndStatement_SuspensionMode ::= SUSPEND */
#line 4129 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy764 = XA_EndStatement::SuspensionMode::Normal;
	  yy_destructor(yypParser,171,&yymsp[0].minor);
}
#line 12135 "../LemonSrc/SQLParserL.c"
        break;
      case 597: /* xa_EndStatement_SuspensionMode ::= SUSPEND FOR MIGRATE */
#line 4133 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy764 = XA_EndStatement::SuspensionMode::ForMigrate;
	  yy_destructor(yypParser,171,&yymsp[-2].minor);
  yy_destructor(yypParser,78,&yymsp[-1].minor);
  yy_destructor(yypParser,172,&yymsp[0].minor);
}
#line 12145 "../LemonSrc/SQLParserL.c"
        break;
      case 598: /* xa_PrepareStatement ::= XA PREPARE xa_Identifier */
#line 4143 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<XA_PrepareStatement> p = new XA_PrepareStatement;
		p->setIdentifier(yymsp[0].minor.yy1146);
		// can't delete yymsp[0].minor.yy1146
		yygotominor.yy563 = p.release();
	  yy_destructor(yypParser,169,&yymsp[-2].minor);
  yy_destructor(yypParser,173,&yymsp[-1].minor);
}
#line 12157 "../LemonSrc/SQLParserL.c"
        break;
      case 599: /* xa_CommitStatement ::= XA COMMIT xa_Identifier */
#line 4156 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<XA_CommitStatement> p = new XA_CommitStatement;
		p->setIdentifier(yymsp[0].minor.yy1146);
		// can't delete yymsp[0].minor.yy1146
		yygotominor.yy777 = p.release();
	  yy_destructor(yypParser,169,&yymsp[-2].minor);
  yy_destructor(yypParser,166,&yymsp[-1].minor);
}
#line 12169 "../LemonSrc/SQLParserL.c"
        break;
      case 600: /* xa_CommitStatement ::= XA COMMIT xa_Identifier ONE PHASE */
#line 4163 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<XA_CommitStatement> p = new XA_CommitStatement;
		p->setIdentifier(yymsp[-2].minor.yy1146);
		// can't delete yymsp[-2].minor.yy1146
		p->setOnePhase(true);
		yygotominor.yy777 = p.release();
	  yy_destructor(yypParser,169,&yymsp[-4].minor);
  yy_destructor(yypParser,166,&yymsp[-3].minor);
  yy_destructor(yypParser,174,&yymsp[-1].minor);
  yy_destructor(yypParser,175,&yymsp[0].minor);
}
#line 12184 "../LemonSrc/SQLParserL.c"
        break;
      case 601: /* xa_RollbackStatement ::= XA ROLLBACK xa_Identifier */
#line 4177 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<XA_RollbackStatement> p = new XA_RollbackStatement;
		p->setIdentifier(yymsp[0].minor.yy1146);
		// can't delete yymsp[0].minor.yy1146
		yygotominor.yy938 = p.release();
	  yy_destructor(yypParser,169,&yymsp[-2].minor);
  yy_destructor(yypParser,168,&yymsp[-1].minor);
}
#line 12196 "../LemonSrc/SQLParserL.c"
        break;
      case 602: /* xa_RecoverStatement ::= XA RECOVER */
#line 4190 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy134 = new XA_RecoverStatement;
	  yy_destructor(yypParser,169,&yymsp[-1].minor);
  yy_destructor(yypParser,176,&yymsp[0].minor);
}
#line 12205 "../LemonSrc/SQLParserL.c"
        break;
      case 603: /* xa_ForgetStatement ::= XA FORGET xa_Identifier */
#line 4200 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<XA_ForgetStatement> p = new XA_ForgetStatement;
		p->setIdentifier(yymsp[0].minor.yy1146);
		// can't delete yymsp[0].minor.yy1146
		yygotominor.yy367 = p.release();
	  yy_destructor(yypParser,169,&yymsp[-2].minor);
  yy_destructor(yypParser,177,&yymsp[-1].minor);
}
#line 12217 "../LemonSrc/SQLParserL.c"
        break;
      case 604: /* databaseDefinition ::= CREATE DATABASE identifier optionalDatabaseCreateOption */
#line 4214 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy809 = new DatabaseDefinition(yymsp[-1].minor.yy1118, 0, yymsp[0].minor.yy553);
	  yy_destructor(yypParser,178,&yymsp[-3].minor);
  yy_destructor(yypParser,179,&yymsp[-2].minor);
}
#line 12226 "../LemonSrc/SQLParserL.c"
        break;
      case 605: /* optionalDatabaseCreateOption ::= databaseCreateOptionList */
#line 4224 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[0].minor.yy553->assureCreateOptions(*pParser);
		yygotominor.yy553 = yymsp[0].minor.yy553;
	}
#line 12234 "../LemonSrc/SQLParserL.c"
        break;
      case 606: /* optionalDatabaseCreateOption ::= */
#line 4229 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy553 = 0; }
#line 12239 "../LemonSrc/SQLParserL.c"
        break;
      case 607: /* databaseCreateOptionList ::= databaseCreateOption */
#line 4234 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy553 = new DatabaseCreateOptionList(yymsp[0].minor.yy1241);
	}
#line 12246 "../LemonSrc/SQLParserL.c"
        break;
      case 608: /* databaseCreateOptionList ::= databaseCreateOptionList databaseCreateOption */
#line 4238 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-1].minor.yy553->append(yymsp[0].minor.yy1241);
		yygotominor.yy553 = yymsp[-1].minor.yy553;
	}
#line 12254 "../LemonSrc/SQLParserL.c"
        break;
      case 609: /* databaseCreateOption ::= dbPathClause */
#line 4249 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1241 = new DatabaseCreateOption( DatabaseCreateOption::PathOption ,yymsp[0].minor.yy159 );
	}
#line 12261 "../LemonSrc/SQLParserL.c"
        break;
      case 610: /* databaseCreateOption ::= readwriteAttribute */
#line 4253 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1241 = new DatabaseCreateOption( DatabaseCreateOption::ReadWriteOption ,new IntegerValue( yymsp[0].minor.yy764 ) );
	}
#line 12268 "../LemonSrc/SQLParserL.c"
        break;
      case 611: /* databaseCreateOption ::= onlineAttribute */
#line 4257 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1241 = new DatabaseCreateOption( DatabaseCreateOption::OnlineOption ,new IntegerValue( yymsp[0].minor.yy764 ) );
	}
#line 12275 "../LemonSrc/SQLParserL.c"
        break;
      case 612: /* databaseCreateOption ::= recoveryAttribute */
#line 4261 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1241 = new DatabaseCreateOption(DatabaseCreateOption::RecoveryOption, new IntegerValue(yymsp[0].minor.yy764));
	}
#line 12282 "../LemonSrc/SQLParserL.c"
        break;
      case 613: /* databaseCreateOption ::= userModeAttribute */
#line 4265 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1241 = new DatabaseCreateOption(DatabaseCreateOption::UserModeOption, new IntegerValue(yymsp[0].minor.yy764));
	}
#line 12289 "../LemonSrc/SQLParserL.c"
        break;
      case 614: /* dbPathClause ::= PATH dbPathElementList */
#line 4275 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[0].minor.yy159->assurePathElements(*pParser);
		yygotominor.yy159 = yymsp[0].minor.yy159;
	  yy_destructor(yypParser,73,&yymsp[-1].minor);
}
#line 12298 "../LemonSrc/SQLParserL.c"
        break;
      case 615: /* dbPathElementList ::= dbPathElement */
#line 4286 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy159 = new DatabasePathElementList(yymsp[0].minor.yy287);
	}
#line 12305 "../LemonSrc/SQLParserL.c"
        break;
      case 616: /* dbPathElementList ::= dbPathElementList dbPathElement */
#line 4290 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-1].minor.yy159->append(yymsp[0].minor.yy287);
		yygotominor.yy159 = yymsp[-1].minor.yy159;
	}
#line 12313 "../LemonSrc/SQLParserL.c"
        break;
      case 617: /* dbPathElement ::= pathName */
#line 4301 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy287 = new DatabasePathElement( DatabasePathElement::Database ,yymsp[0].minor.yy1200 );
	}
#line 12320 "../LemonSrc/SQLParserL.c"
        break;
      case 618: /* dbPathElement ::= LOGICALLOG pathName */
#line 4305 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy287 = new DatabasePathElement( DatabasePathElement::LogicalLog ,yymsp[0].minor.yy1200 );
	  yy_destructor(yypParser,180,&yymsp[-1].minor);
}
#line 12328 "../LemonSrc/SQLParserL.c"
        break;
      case 619: /* dbPathElement ::= SYSTEM pathName */
#line 4309 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy287 = new DatabasePathElement( DatabasePathElement::System ,yymsp[0].minor.yy1200 );
	  yy_destructor(yypParser,181,&yymsp[-1].minor);
}
#line 12336 "../LemonSrc/SQLParserL.c"
        break;
      case 621: /* readwriteAttribute ::= READ ONLY */
#line 4328 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy764 = DatabaseCreateOption::ReadOnly;
	  yy_destructor(yypParser,156,&yymsp[-1].minor);
  yy_destructor(yypParser,157,&yymsp[0].minor);
}
#line 12345 "../LemonSrc/SQLParserL.c"
        break;
      case 622: /* readwriteAttribute ::= READ WRITE */
#line 4332 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy764 = DatabaseCreateOption::ReadWrite;
	  yy_destructor(yypParser,156,&yymsp[-1].minor);
  yy_destructor(yypParser,158,&yymsp[0].minor);
}
#line 12354 "../LemonSrc/SQLParserL.c"
        break;
      case 623: /* onlineAttribute ::= ONLINE */
#line 4341 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy764 = DatabaseCreateOption::Online;
	  yy_destructor(yypParser,182,&yymsp[0].minor);
}
#line 12362 "../LemonSrc/SQLParserL.c"
        break;
      case 624: /* onlineAttribute ::= OFFLINE */
#line 4345 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy764 = DatabaseCreateOption::Offline;
	  yy_destructor(yypParser,183,&yymsp[0].minor);
}
#line 12370 "../LemonSrc/SQLParserL.c"
        break;
      case 625: /* onlineAttributeForAlter ::= ONLINE WITH DISCARD LOGICALLOG */
#line 4354 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy764 = DatabaseCreateOption::OnlineWithDiscardLogicalLog;
	  yy_destructor(yypParser,182,&yymsp[-3].minor);
  yy_destructor(yypParser,74,&yymsp[-2].minor);
  yy_destructor(yypParser,184,&yymsp[-1].minor);
  yy_destructor(yypParser,180,&yymsp[0].minor);
}
#line 12381 "../LemonSrc/SQLParserL.c"
        break;
      case 626: /* recoveryAttribute ::= RECOVERY FULL */
#line 4363 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy764 = DatabaseCreateOption::RecoveryFull;
	  yy_destructor(yypParser,185,&yymsp[-1].minor);
  yy_destructor(yypParser,9,&yymsp[0].minor);
}
#line 12390 "../LemonSrc/SQLParserL.c"
        break;
      case 627: /* recoveryAttribute ::= RECOVERY CHECKPOINT */
#line 4367 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy764 = DatabaseCreateOption::RecoveryCheckpoint;
	  yy_destructor(yypParser,185,&yymsp[-1].minor);
  yy_destructor(yypParser,186,&yymsp[0].minor);
}
#line 12399 "../LemonSrc/SQLParserL.c"
        break;
      case 628: /* userModeAttribute ::= USER ALL */
#line 4376 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy764 = DatabaseCreateOption::AllUser;
	  yy_destructor(yypParser,55,&yymsp[-1].minor);
  yy_destructor(yypParser,62,&yymsp[0].minor);
}
#line 12408 "../LemonSrc/SQLParserL.c"
        break;
      case 629: /* userModeAttribute ::= USER SYSTEM */
#line 4380 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy764 = DatabaseCreateOption::SuperUser;
	  yy_destructor(yypParser,55,&yymsp[-1].minor);
  yy_destructor(yypParser,181,&yymsp[0].minor);
}
#line 12417 "../LemonSrc/SQLParserL.c"
        break;
      case 630: /* dropDatabaseStatement ::= DROP DATABASE identifier optionalIfExists */
#line 4391 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1074 = new DropDatabaseStatement(yymsp[-1].minor.yy1118, yymsp[0].minor.yy937);
	  yy_destructor(yypParser,187,&yymsp[-3].minor);
  yy_destructor(yypParser,179,&yymsp[-2].minor);
}
#line 12426 "../LemonSrc/SQLParserL.c"
        break;
      case 631: /* alterDatabaseStatement ::= ALTER DATABASE dbName SET dbPathClause */
#line 4402 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy934 = new MoveDatabaseStatement(yymsp[-2].minor.yy1118, yymsp[0].minor.yy159, MoveDatabaseStatement::Set);
	  yy_destructor(yypParser,188,&yymsp[-4].minor);
  yy_destructor(yypParser,179,&yymsp[-3].minor);
  yy_destructor(yypParser,153,&yymsp[-1].minor);
}
#line 12436 "../LemonSrc/SQLParserL.c"
        break;
      case 632: /* alterDatabaseStatement ::= ALTER DATABASE dbName DROP dbPathClause */
#line 4406 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy934 = new MoveDatabaseStatement(yymsp[-2].minor.yy1118, yymsp[0].minor.yy159, MoveDatabaseStatement::Drop);
	  yy_destructor(yypParser,188,&yymsp[-4].minor);
  yy_destructor(yypParser,179,&yymsp[-3].minor);
  yy_destructor(yypParser,187,&yymsp[-1].minor);
}
#line 12446 "../LemonSrc/SQLParserL.c"
        break;
      case 633: /* alterDatabaseStatement ::= ALTER DATABASE dbName alterDatabaseOption */
#line 4410 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy934 = new AlterDatabaseStatement(yymsp[-1].minor.yy1118, yymsp[0].minor.yy388);
	  yy_destructor(yypParser,188,&yymsp[-3].minor);
  yy_destructor(yypParser,179,&yymsp[-2].minor);
}
#line 12455 "../LemonSrc/SQLParserL.c"
        break;
      case 634: /* alterDatabaseStatement ::= ALTER DATABASE dbName START SLAVE */
#line 4414 "../LemonSrc/SQLParserL.lemon"
{
		AlterDatabaseStatement* p =new AlterDatabaseStatement(yymsp[-2].minor.yy1118, 0);
		p->setReplicationType(AlterDatabaseStatement::StartSlave);
		yygotominor.yy934 = p;
	  yy_destructor(yypParser,188,&yymsp[-4].minor);
  yy_destructor(yypParser,179,&yymsp[-3].minor);
  yy_destructor(yypParser,154,&yymsp[-1].minor);
  yy_destructor(yypParser,189,&yymsp[0].minor);
}
#line 12468 "../LemonSrc/SQLParserL.c"
        break;
      case 635: /* alterDatabaseStatement ::= ALTER DATABASE dbName STOP SLAVE */
#line 4420 "../LemonSrc/SQLParserL.lemon"
{
		AlterDatabaseStatement* p =new AlterDatabaseStatement(yymsp[-2].minor.yy1118, 0);
		p->setReplicationType(AlterDatabaseStatement::StopSlave);
		yygotominor.yy934 = p;
	  yy_destructor(yypParser,188,&yymsp[-4].minor);
  yy_destructor(yypParser,179,&yymsp[-3].minor);
  yy_destructor(yypParser,190,&yymsp[-1].minor);
  yy_destructor(yypParser,189,&yymsp[0].minor);
}
#line 12481 "../LemonSrc/SQLParserL.c"
        break;
      case 636: /* alterDatabaseStatement ::= ALTER DATABASE dbName SET TO MASTER */
#line 4426 "../LemonSrc/SQLParserL.lemon"
{
		AlterDatabaseStatement* p =new AlterDatabaseStatement(yymsp[-3].minor.yy1118, 0);
		p->setReplicationType(AlterDatabaseStatement::SetToMaster);
		yygotominor.yy934 = p;
	  yy_destructor(yypParser,188,&yymsp[-5].minor);
  yy_destructor(yypParser,179,&yymsp[-4].minor);
  yy_destructor(yypParser,153,&yymsp[-2].minor);
  yy_destructor(yypParser,72,&yymsp[-1].minor);
  yy_destructor(yypParser,191,&yymsp[0].minor);
}
#line 12495 "../LemonSrc/SQLParserL.c"
        break;
      case 638: /* alterDatabaseOption ::= alterDatabaseAttributeList */
#line 4448 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[0].minor.yy388->assureDatabaseAttributes(*pParser);
		yygotominor.yy388 = yymsp[0].minor.yy388;
	}
#line 12503 "../LemonSrc/SQLParserL.c"
        break;
      case 639: /* alterDatabaseAttributeList ::= alterDatabaseAttribute */
#line 4459 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy388 = new AlterDatabaseAttributeList(yymsp[0].minor.yy532);
	}
#line 12510 "../LemonSrc/SQLParserL.c"
        break;
      case 640: /* alterDatabaseAttributeList ::= alterDatabaseAttributeList alterDatabaseAttribute */
#line 4463 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-1].minor.yy388->append(yymsp[0].minor.yy532);
		yygotominor.yy388 = yymsp[-1].minor.yy388;
	}
#line 12518 "../LemonSrc/SQLParserL.c"
        break;
      case 641: /* alterDatabaseAttribute ::= readwriteAttribute */
#line 4474 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy532 = new AlterDatabaseAttribute(
			AlterDatabaseAttribute::ReadWrite, yymsp[0].minor.yy764 );
	}
#line 12526 "../LemonSrc/SQLParserL.c"
        break;
      case 642: /* alterDatabaseAttribute ::= onlineAttribute */
      case 643: /* alterDatabaseAttribute ::= onlineAttributeForAlter */ yytestcase(yyruleno==643);
#line 4479 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy532 = new AlterDatabaseAttribute(
			AlterDatabaseAttribute::Online, yymsp[0].minor.yy764);
	}
#line 12535 "../LemonSrc/SQLParserL.c"
        break;
      case 644: /* alterDatabaseAttribute ::= recoveryAttribute */
#line 4489 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy532 = new AlterDatabaseAttribute(
			AlterDatabaseAttribute::RecoveryFull, yymsp[0].minor.yy764);
	}
#line 12543 "../LemonSrc/SQLParserL.c"
        break;
      case 645: /* alterDatabaseAttribute ::= userModeAttribute */
#line 4495 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy532 = new AlterDatabaseAttribute(
			AlterDatabaseAttribute::SuperUserMode, yymsp[0].minor.yy764);
	}
#line 12551 "../LemonSrc/SQLParserL.c"
        break;
      case 646: /* tableDefinition ::= CREATE tableScopeClause TABLE tableName tableConstantClause LEFT_PARENTHESIS tableElementList RIGHT_PARENTHESIS hint tableAreaOption */
#line 4510 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1000 = new TableDefinition(yymsp[-6].minor.yy1118, yymsp[-8].minor.yy764, yymsp[-5].minor.yy764, yymsp[-3].minor.yy117,
									 0, yymsp[-1].minor.yy858, yymsp[0].minor.yy1053);
	  yy_destructor(yypParser,178,&yymsp[-9].minor);
  yy_destructor(yypParser,149,&yymsp[-7].minor);
  yy_destructor(yypParser,66,&yymsp[-4].minor);
  yy_destructor(yypParser,67,&yymsp[-2].minor);
}
#line 12563 "../LemonSrc/SQLParserL.c"
        break;
      case 647: /* tableScopeClause ::= GLOBAL TEMPORARY */
#line 4520 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = TableDefinition::GlobalTemporary;   yy_destructor(yypParser,192,&yymsp[-1].minor);
  yy_destructor(yypParser,193,&yymsp[0].minor);
}
#line 12570 "../LemonSrc/SQLParserL.c"
        break;
      case 648: /* tableScopeClause ::= LOCAL TEMPORARY */
#line 4523 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = TableDefinition::LocalTemporary;   yy_destructor(yypParser,194,&yymsp[-1].minor);
  yy_destructor(yypParser,193,&yymsp[0].minor);
}
#line 12577 "../LemonSrc/SQLParserL.c"
        break;
      case 649: /* tableScopeClause ::= TEMPORARY */
#line 4526 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = TableDefinition::LocalTemporary;   yy_destructor(yypParser,193,&yymsp[0].minor);
}
#line 12583 "../LemonSrc/SQLParserL.c"
        break;
      case 650: /* tableScopeClause ::= */
#line 4529 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = TableDefinition::Permanent; }
#line 12588 "../LemonSrc/SQLParserL.c"
        break;
      case 651: /* tableConstantClause ::= CONSTANT */
#line 4536 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = TableDefinition::Constant;   yy_destructor(yypParser,195,&yymsp[0].minor);
}
#line 12594 "../LemonSrc/SQLParserL.c"
        break;
      case 652: /* tableConstantClause ::= UPDATABLE */
#line 4539 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = TableDefinition::Updatable;   yy_destructor(yypParser,196,&yymsp[0].minor);
}
#line 12600 "../LemonSrc/SQLParserL.c"
        break;
      case 653: /* tableConstantClause ::= */
#line 4542 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = TableDefinition::Updatable; }
#line 12605 "../LemonSrc/SQLParserL.c"
        break;
      case 654: /* tableElementList ::= tableElement */
#line 4550 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy117 = new TableElementList(yymsp[0].minor.yy934);
	}
#line 12612 "../LemonSrc/SQLParserL.c"
        break;
      case 655: /* tableElementList ::= tableElementList COMMA tableElement */
#line 4555 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-2].minor.yy117->append(yymsp[0].minor.yy934);
		yygotominor.yy117 = yymsp[-2].minor.yy117;
	  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 12621 "../LemonSrc/SQLParserL.c"
        break;
      case 656: /* tableElementList ::= tableElementList COMMA */
      case 790: /* addColumnDefinitionBody ::= addColumnDefinitionBody COMMA */ yytestcase(yyruleno==790);
#line 4561 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy117 = yymsp[-1].minor.yy117;   yy_destructor(yypParser,13,&yymsp[0].minor);
}
#line 12628 "../LemonSrc/SQLParserL.c"
        break;
      case 657: /* tableElement ::= columnDefinition */
#line 4569 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy934 = yymsp[0].minor.yy418;
	}
#line 12635 "../LemonSrc/SQLParserL.c"
        break;
      case 658: /* tableElement ::= tableConstraintDefinition */
#line 4574 "../LemonSrc/SQLParserL.lemon"
{
	yygotominor.yy934 = yymsp[0].minor.yy641;
	}
#line 12642 "../LemonSrc/SQLParserL.c"
        break;
      case 659: /* columnDefinition ::= identifier dataType optionalDefaultClause optionalUsingOnUpdate optionalColumnConstraintList hint */
#line 4588 "../LemonSrc/SQLParserL.lemon"
{
		if (!yymsp[-3].minor.yy1172 && yymsp[-2].minor.yy937) {
			// 'using on update' should specified with default clause
			pParser->throwSyntaxErrorException(srcFile ,__LINE__);
		}
		yygotominor.yy418 = new ColumnDefinition(yymsp[-5].minor.yy1118, yymsp[-4].minor.yy1194, yymsp[-3].minor.yy1172, yymsp[-1].minor.yy139, 0, yymsp[0].minor.yy858, yymsp[-2].minor.yy937);
		delete yymsp[-4].minor.yy1194;
	}
#line 12654 "../LemonSrc/SQLParserL.c"
        break;
      case 660: /* columnDefinition ::= identifier dataType constClause optionalColumnConstraintList hint */
#line 4601 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy418 = new ColumnDefinition(yymsp[-4].minor.yy1118, yymsp[-3].minor.yy1194, 0, yymsp[-1].minor.yy139, yymsp[-2].minor.yy1172, yymsp[0].minor.yy858, false);
		delete yymsp[-3].minor.yy1194;
	}
#line 12662 "../LemonSrc/SQLParserL.c"
        break;
      case 661: /* columnDefinition ::= identifier dataType generatorClause optionalColumnConstraintList hint */
#line 4610 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy418 = new ColumnDefinition(yymsp[-4].minor.yy1118, yymsp[-3].minor.yy1194, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy139, 0, yymsp[0].minor.yy858, false);
		delete yymsp[-3].minor.yy1194;
	}
#line 12670 "../LemonSrc/SQLParserL.c"
        break;
      case 662: /* dataType ::= collectionType */
      case 663: /* dataType ::= nonCollectionDataType */ yytestcase(yyruleno==663);
      case 668: /* nonCollectionDataType ::= preDefinedType */ yytestcase(yyruleno==668);
#line 4621 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1194 = yymsp[0].minor.yy1194; }
#line 12677 "../LemonSrc/SQLParserL.c"
        break;
      case 664: /* collectionType ::= nonCollectionDataType arraySpecification */
#line 4632 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-1].minor.yy1194->setMaxCardinality(yymsp[0].minor.yy764);
		yygotominor.yy1194 = yymsp[-1].minor.yy1194;
	}
#line 12685 "../LemonSrc/SQLParserL.c"
        break;
      case 665: /* arraySpecification ::= ARRAY optionalArrayCardinality */
#line 4642 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = yymsp[0].minor.yy764;   yy_destructor(yypParser,146,&yymsp[-1].minor);
}
#line 12691 "../LemonSrc/SQLParserL.c"
        break;
      case 666: /* optionalArrayCardinality ::= LEFT_BRACKET length RIGHT_BRACKET */
#line 4646 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = yymsp[-1].minor.yy764;   yy_destructor(yypParser,60,&yymsp[-2].minor);
  yy_destructor(yypParser,61,&yymsp[0].minor);
}
#line 12698 "../LemonSrc/SQLParserL.c"
        break;
      case 667: /* optionalArrayCardinality ::= */
#line 4648 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = -1; }
#line 12703 "../LemonSrc/SQLParserL.c"
        break;
      case 669: /* preDefinedType ::= NVARCHAR LEFT_PARENTHESIS length RIGHT_PARENTHESIS */
#line 4664 "../LemonSrc/SQLParserL.lemon"
{
		if (yymsp[-1].minor.yy764 < 0)
			yygotominor.yy1194 = new Common::SQLData(Common::SQLData::Type::NChar, Common::SQLData::Flag::Variable, 0, 0);
		else
			yygotominor.yy1194 = new Common::SQLData(Common::SQLData::Type::NChar, Common::SQLData::Flag::Variable, yymsp[-1].minor.yy764, 0);
	  yy_destructor(yypParser,197,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 12716 "../LemonSrc/SQLParserL.c"
        break;
      case 670: /* preDefinedType ::= VARCHAR LEFT_PARENTHESIS length RIGHT_PARENTHESIS */
#line 4672 "../LemonSrc/SQLParserL.lemon"
{
		if (yymsp[-1].minor.yy764 < 0)
			yygotominor.yy1194 = new Common::SQLData(Common::SQLData::Type::Char, Common::SQLData::Flag::Variable, 0, 0);
		else
			yygotominor.yy1194 = new Common::SQLData(Common::SQLData::Type::Char, Common::SQLData::Flag::Variable, yymsp[-1].minor.yy764, 0);
	  yy_destructor(yypParser,198,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 12729 "../LemonSrc/SQLParserL.c"
        break;
      case 671: /* preDefinedType ::= NTEXT */
#line 4680 "../LemonSrc/SQLParserL.lemon"
{
		// defined as nvarchar different from SQL Server (which define as nclob)
		yygotominor.yy1194 = new Common::SQLData(Common::SQLData::Type::NChar, Common::SQLData::Flag::Variable, 0, 0);
	  yy_destructor(yypParser,199,&yymsp[0].minor);
}
#line 12738 "../LemonSrc/SQLParserL.c"
        break;
      case 672: /* preDefinedType ::= FULLTEXT */
#line 4686 "../LemonSrc/SQLParserL.lemon"
{
		// defined as nvarchar different from SQL Server (which define as nclob)
		yygotominor.yy1194 = new Common::SQLData(Common::SQLData::Type::NChar, Common::SQLData::Flag::Variable, 0, 0);
	  yy_destructor(yypParser,114,&yymsp[0].minor);
}
#line 12747 "../LemonSrc/SQLParserL.c"
        break;
      case 673: /* preDefinedType ::= INT */
#line 4692 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1194 = new Common::SQLData;
		(void) Common::Data::getSQLType(Common::DataType::Integer, *yygotominor.yy1194);
	  yy_destructor(yypParser,200,&yymsp[0].minor);
}
#line 12756 "../LemonSrc/SQLParserL.c"
        break;
      case 674: /* preDefinedType ::= BIGINT */
#line 4698 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1194 = new Common::SQLData;
		(void) Common::Data::getSQLType(Common::DataType::Integer64, *yygotominor.yy1194);
	  yy_destructor(yypParser,201,&yymsp[0].minor);
}
#line 12765 "../LemonSrc/SQLParserL.c"
        break;
      case 675: /* preDefinedType ::= FLOAT */
#line 4704 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1194 = new Common::SQLData;
		(void) Common::Data::getSQLType(Common::DataType::Double, *yygotominor.yy1194);
	  yy_destructor(yypParser,202,&yymsp[0].minor);
}
#line 12774 "../LemonSrc/SQLParserL.c"
        break;
      case 676: /* preDefinedType ::= DATETIME */
#line 4710 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1194 = new Common::SQLData;
		(void) Common::Data::getSQLType(Common::DataType::DateTime, *yygotominor.yy1194);
		// When it is defined as DATETIME, SQL type becomes DATETIME instead of TIMESTAMP
		yygotominor.yy1194->setType(Common::SQLData::Type::DateTime);
	  yy_destructor(yypParser,203,&yymsp[0].minor);
}
#line 12785 "../LemonSrc/SQLParserL.c"
        break;
      case 677: /* preDefinedType ::= TIMESTAMP */
#line 4718 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1194 = new Common::SQLData;
		(void) Common::Data::getSQLType(Common::DataType::DateTime, *yygotominor.yy1194);
	  yy_destructor(yypParser,49,&yymsp[0].minor);
}
#line 12794 "../LemonSrc/SQLParserL.c"
        break;
      case 678: /* preDefinedType ::= UNIQUEIDENTIFIER */
#line 4724 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1194 = new Common::SQLData(Common::SQLData::Type::Char, Common::SQLData::Flag::Fixed, 36, 0);
	  yy_destructor(yypParser,204,&yymsp[0].minor);
}
#line 12802 "../LemonSrc/SQLParserL.c"
        break;
      case 679: /* preDefinedType ::= IMAGE */
#line 4729 "../LemonSrc/SQLParserL.lemon"
{
		// defined as binary different from SQL Server (which define as blob)
		yygotominor.yy1194 = new Common::SQLData(Common::SQLData::Type::Binary, Common::SQLData::Flag::Unlimited, 0, 0);
	  yy_destructor(yypParser,205,&yymsp[0].minor);
}
#line 12811 "../LemonSrc/SQLParserL.c"
        break;
      case 680: /* preDefinedType ::= LANGUAGE */
#line 4735 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1194 = new Common::SQLData(Common::SQLData::Type::Language, Common::SQLData::Flag::Fixed, 0, 0);
	  yy_destructor(yypParser,29,&yymsp[0].minor);
}
#line 12819 "../LemonSrc/SQLParserL.c"
        break;
      case 681: /* preDefinedType ::= NCHAR LEFT_PARENTHESIS length RIGHT_PARENTHESIS */
#line 4740 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1194 = new Common::SQLData(Common::SQLData::Type::NChar, Common::SQLData::Flag::Fixed, yymsp[-1].minor.yy764, 0);
	  yy_destructor(yypParser,206,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 12829 "../LemonSrc/SQLParserL.c"
        break;
      case 682: /* preDefinedType ::= CHAR LEFT_PARENTHESIS length RIGHT_PARENTHESIS */
#line 4745 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1194 = new Common::SQLData(Common::SQLData::Type::Char, Common::SQLData::Flag::Fixed, yymsp[-1].minor.yy764, 0);
	  yy_destructor(yypParser,207,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 12839 "../LemonSrc/SQLParserL.c"
        break;
      case 683: /* preDefinedType ::= BINARY LEFT_PARENTHESIS length RIGHT_PARENTHESIS */
#line 4750 "../LemonSrc/SQLParserL.lemon"
{
		if (yymsp[-1].minor.yy764 < 0) {
			yygotominor.yy1194 = new Common::SQLData(Common::SQLData::Type::Binary, Common::SQLData::Flag::Unlimited, 0, 0);
		} else {
			yygotominor.yy1194 = new Common::SQLData(Common::SQLData::Type::Binary, Common::SQLData::Flag::Fixed, yymsp[-1].minor.yy764, 0);
		}
	  yy_destructor(yypParser,208,&yymsp[-3].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 12853 "../LemonSrc/SQLParserL.c"
        break;
      case 684: /* preDefinedType ::= BLOB */
#line 4759 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1194 = new Common::SQLData(Common::SQLData::Type::BLOB, Common::SQLData::Flag::Unlimited, 0, 0);
	  yy_destructor(yypParser,209,&yymsp[0].minor);
}
#line 12861 "../LemonSrc/SQLParserL.c"
        break;
      case 685: /* preDefinedType ::= NCLOB */
#line 4764 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1194 = new Common::SQLData(Common::SQLData::Type::NCLOB, Common::SQLData::Flag::Unlimited, 0, 0);
	  yy_destructor(yypParser,210,&yymsp[0].minor);
}
#line 12869 "../LemonSrc/SQLParserL.c"
        break;
      case 686: /* preDefinedType ::= decimalTypeName optionalDecimalLength */
#line 4771 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1194 = new Common::SQLData(yymsp[-1].minor.yy439,
									 Common::SQLData::Flag::Fixed,
									 yymsp[0].minor.yy727->first, yymsp[0].minor.yy727->second);
		delete yymsp[0].minor.yy727;
	}
#line 12879 "../LemonSrc/SQLParserL.c"
        break;
      case 687: /* decimalTypeName ::= DEC */
#line 4783 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy439 = Common::SQLData::Type::Decimal;   yy_destructor(yypParser,211,&yymsp[0].minor);
}
#line 12885 "../LemonSrc/SQLParserL.c"
        break;
      case 688: /* decimalTypeName ::= DECIMAL */
#line 4785 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy439 = Common::SQLData::Type::Decimal;   yy_destructor(yypParser,212,&yymsp[0].minor);
}
#line 12891 "../LemonSrc/SQLParserL.c"
        break;
      case 689: /* decimalTypeName ::= NUMERIC */
#line 4787 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy439 = Common::SQLData::Type::Decimal;   yy_destructor(yypParser,213,&yymsp[0].minor);
}
#line 12897 "../LemonSrc/SQLParserL.c"
        break;
      case 690: /* optionalDecimalLength ::= */
#line 4795 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy727 = new ModPair<int, int>(9, 0);
	}
#line 12904 "../LemonSrc/SQLParserL.c"
        break;
      case 691: /* optionalDecimalLength ::= LEFT_PARENTHESIS length RIGHT_PARENTHESIS */
#line 4799 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy727 = new ModPair<int, int>(yymsp[-1].minor.yy764, 0);
	  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 12913 "../LemonSrc/SQLParserL.c"
        break;
      case 692: /* optionalDecimalLength ::= LEFT_PARENTHESIS length COMMA length RIGHT_PARENTHESIS */
#line 4803 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy727 = new ModPair<int, int>(yymsp[-3].minor.yy764, yymsp[-1].minor.yy764);
	  yy_destructor(yypParser,66,&yymsp[-4].minor);
  yy_destructor(yypParser,13,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 12923 "../LemonSrc/SQLParserL.c"
        break;
      case 693: /* length ::= unsignedIntegerLiteral */
#line 4812 "../LemonSrc/SQLParserL.lemon"
{
		Common::Data::Pointer pIntData = yymsp[0].minor.yy1200->createData(Common::DataType::Integer);
		if (!pIntData->isNull())
			yygotominor.yy764 = _SYDNEY_DYNAMIC_CAST(const Common::IntegerData&, *pIntData).getValue();
		else
			// intで表せないほど大きな値は無制限と解釈する
			yygotominor.yy764 = -1;
		delete yymsp[0].minor.yy1200;
	}
#line 12936 "../LemonSrc/SQLParserL.c"
        break;
      case 694: /* length ::= NO LIMIT */
#line 4822 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = -1;   yy_destructor(yypParser,214,&yymsp[-1].minor);
  yy_destructor(yypParser,90,&yymsp[0].minor);
}
#line 12943 "../LemonSrc/SQLParserL.c"
        break;
      case 695: /* optionalColumnConstraintList ::= */
#line 4830 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy139 = 0;
	}
#line 12950 "../LemonSrc/SQLParserL.c"
        break;
      case 696: /* optionalColumnConstraintList ::= columnConstraintList */
#line 4834 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy139 = yymsp[0].minor.yy139;
	}
#line 12957 "../LemonSrc/SQLParserL.c"
        break;
      case 697: /* columnConstraintList ::= columnConstraint */
#line 4841 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy139 = new ColumnConstraintDefinitionList(yymsp[0].minor.yy123);
	}
#line 12964 "../LemonSrc/SQLParserL.c"
        break;
      case 698: /* columnConstraintList ::= columnConstraintList columnConstraint */
#line 4845 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-1].minor.yy139->append(yymsp[0].minor.yy123);
		yygotominor.yy139 = yymsp[-1].minor.yy139;
	}
#line 12972 "../LemonSrc/SQLParserL.c"
        break;
      case 699: /* columnConstraint ::= NOT NULL */
#line 4856 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy123 = new ColumnConstraintDefinition(ColumnConstraintDefinition::NotNull);
	  yy_destructor(yypParser,16,&yymsp[-1].minor);
  yy_destructor(yypParser,52,&yymsp[0].minor);
}
#line 12981 "../LemonSrc/SQLParserL.c"
        break;
      case 700: /* columnConstraint ::= PRIMARY KEY */
#line 4860 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy123 = new ColumnConstraintDefinition(ColumnConstraintDefinition::PrimaryKey);
	  yy_destructor(yypParser,215,&yymsp[-1].minor);
  yy_destructor(yypParser,216,&yymsp[0].minor);
}
#line 12990 "../LemonSrc/SQLParserL.c"
        break;
      case 701: /* columnConstraint ::= UNIQUE */
#line 4864 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy123 = new ColumnConstraintDefinition(ColumnConstraintDefinition::Unique);
	  yy_destructor(yypParser,217,&yymsp[0].minor);
}
#line 12998 "../LemonSrc/SQLParserL.c"
        break;
      case 703: /* optionalDefaultClause ::= defaultClause */
#line 4876 "../LemonSrc/SQLParserL.lemon"
{yygotominor.yy1172 = yymsp[0].minor.yy1172;}
#line 13003 "../LemonSrc/SQLParserL.c"
        break;
      case 704: /* defaultClause ::= DEFAULT defaultOption */
#line 4881 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,53,&yymsp[-1].minor);
}
#line 13009 "../LemonSrc/SQLParserL.c"
        break;
      case 705: /* defaultClause ::= EQUALS defaultOption */
#line 4884 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,19,&yymsp[-1].minor);
}
#line 13015 "../LemonSrc/SQLParserL.c"
        break;
      case 707: /* optionalUsingOnUpdate ::= */
      case 756: /* optionalIfExists ::= */ yytestcase(yyruleno==756);
#line 4899 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy937 = false; }
#line 13021 "../LemonSrc/SQLParserL.c"
        break;
      case 708: /* optionalUsingOnUpdate ::= USING ON UPDATE */
#line 4902 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy937 = true;   yy_destructor(yypParser,33,&yymsp[-2].minor);
  yy_destructor(yypParser,12,&yymsp[-1].minor);
  yy_destructor(yypParser,152,&yymsp[0].minor);
}
#line 13029 "../LemonSrc/SQLParserL.c"
        break;
      case 709: /* constClause ::= CONST constOption */
#line 4910 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,218,&yymsp[-1].minor);
}
#line 13035 "../LemonSrc/SQLParserL.c"
        break;
      case 710: /* constClause ::= CONSTANT constOption */
#line 4912 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = yymsp[0].minor.yy1172;   yy_destructor(yypParser,195,&yymsp[-1].minor);
}
#line 13041 "../LemonSrc/SQLParserL.c"
        break;
      case 712: /* constOption ::= NULL */
#line 4923 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = 0;   yy_destructor(yypParser,52,&yymsp[0].minor);
}
#line 13047 "../LemonSrc/SQLParserL.c"
        break;
      case 713: /* generatorClause ::= GENERATED generateAlways AS IDENTITY optionalGeneratorOptions */
#line 4931 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new Generator::Definition(yymsp[-3].minor.yy311, yymsp[0].minor.yy1140, true /* identity */);
	  yy_destructor(yypParser,219,&yymsp[-4].minor);
  yy_destructor(yypParser,70,&yymsp[-2].minor);
  yy_destructor(yypParser,220,&yymsp[-1].minor);
}
#line 13057 "../LemonSrc/SQLParserL.c"
        break;
      case 714: /* generateAlways ::= ALWAYS */
#line 4940 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy311 = Generator::Definition::Always;   yy_destructor(yypParser,221,&yymsp[0].minor);
}
#line 13063 "../LemonSrc/SQLParserL.c"
        break;
      case 715: /* generateAlways ::= BY DEFAULT */
#line 4942 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy311 = Generator::Definition::ByDefault;   yy_destructor(yypParser,65,&yymsp[-1].minor);
  yy_destructor(yypParser,53,&yymsp[0].minor);
}
#line 13070 "../LemonSrc/SQLParserL.c"
        break;
      case 716: /* optionalGeneratorOptions ::= */
#line 4950 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1140 = 0; }
#line 13075 "../LemonSrc/SQLParserL.c"
        break;
      case 717: /* optionalGeneratorOptions ::= LEFT_PARENTHESIS generatorOptions RIGHT_PARENTHESIS */
#line 4952 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1140 = yymsp[-1].minor.yy1140;   yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 13082 "../LemonSrc/SQLParserL.c"
        break;
      case 718: /* generatorOptions ::= generatorOption */
#line 4957 "../LemonSrc/SQLParserL.lemon"
{
		if (yymsp[0].minor.yy1172) {
			yygotominor.yy1140 = new ValueExpressionList(yymsp[0].minor.yy1172);
		} else {
			yygotominor.yy1140 = 0;
		}
	}
#line 13093 "../LemonSrc/SQLParserL.c"
        break;
      case 719: /* generatorOptions ::= generatorOptions generatorOption */
#line 4965 "../LemonSrc/SQLParserL.lemon"
{
		if (yymsp[-1].minor.yy1140 == 0) {
			if (yymsp[0].minor.yy1172) {
				yygotominor.yy1140 = new ValueExpressionList(yymsp[0].minor.yy1172);
			} else {
				yygotominor.yy1140 = 0;
			}
		} else {
			if (yymsp[0].minor.yy1172) {
				yymsp[-1].minor.yy1140->appendValueExpression(yymsp[0].minor.yy1172);
			}
			yygotominor.yy1140 = yymsp[-1].minor.yy1140;
		}
	}
#line 13111 "../LemonSrc/SQLParserL.c"
        break;
      case 720: /* generatorOption ::= START WITH generatorOptionValue */
#line 4986 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new Generator::Option(Generator::Option::Start, yymsp[0].minor.yy1200);
	  yy_destructor(yypParser,154,&yymsp[-2].minor);
  yy_destructor(yypParser,74,&yymsp[-1].minor);
}
#line 13120 "../LemonSrc/SQLParserL.c"
        break;
      case 721: /* generatorOption ::= INCREMENT BY generatorOptionValue */
#line 4990 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new Generator::Option(Generator::Option::Increment, yymsp[0].minor.yy1200);
	  yy_destructor(yypParser,222,&yymsp[-2].minor);
  yy_destructor(yypParser,65,&yymsp[-1].minor);
}
#line 13129 "../LemonSrc/SQLParserL.c"
        break;
      case 722: /* generatorOption ::= MAXVALUE generatorOptionValue */
#line 4994 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new Generator::Option(Generator::Option::MaxValue, yymsp[0].minor.yy1200);
	  yy_destructor(yypParser,223,&yymsp[-1].minor);
}
#line 13137 "../LemonSrc/SQLParserL.c"
        break;
      case 723: /* generatorOption ::= NO MAXVALUE */
#line 4998 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = 0;   yy_destructor(yypParser,214,&yymsp[-1].minor);
  yy_destructor(yypParser,223,&yymsp[0].minor);
}
#line 13144 "../LemonSrc/SQLParserL.c"
        break;
      case 724: /* generatorOption ::= MINVALUE generatorOptionValue */
#line 5000 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new Generator::Option(Generator::Option::MinValue, yymsp[0].minor.yy1200);
	  yy_destructor(yypParser,224,&yymsp[-1].minor);
}
#line 13152 "../LemonSrc/SQLParserL.c"
        break;
      case 725: /* generatorOption ::= NO MINVALUE */
#line 5004 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = 0;   yy_destructor(yypParser,214,&yymsp[-1].minor);
  yy_destructor(yypParser,224,&yymsp[0].minor);
}
#line 13159 "../LemonSrc/SQLParserL.c"
        break;
      case 726: /* generatorOption ::= CYCLE */
#line 5006 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new Generator::Option(Generator::Option::Cycle, 0);
	  yy_destructor(yypParser,225,&yymsp[0].minor);
}
#line 13167 "../LemonSrc/SQLParserL.c"
        break;
      case 727: /* generatorOption ::= NO CYCLE */
#line 5010 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1172 = 0;   yy_destructor(yypParser,214,&yymsp[-1].minor);
  yy_destructor(yypParser,225,&yymsp[0].minor);
}
#line 13174 "../LemonSrc/SQLParserL.c"
        break;
      case 728: /* generatorOption ::= GET MAX */
#line 5012 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1172 = new Generator::Option(Generator::Option::GetMax, 0);
	  yy_destructor(yypParser,132,&yymsp[-1].minor);
  yy_destructor(yypParser,133,&yymsp[0].minor);
}
#line 13183 "../LemonSrc/SQLParserL.c"
        break;
      case 730: /* tableConstraintDefinition ::= UNIQUE indexType LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS hint */
#line 5033 "../LemonSrc/SQLParserL.lemon"
{
		TableConstraintDefinition* v = new TableConstraintDefinition(TableConstraintDefinition::Unique, yymsp[-2].minor.yy1234, yymsp[-4].minor.yy764, yymsp[0].minor.yy858);
		yygotominor.yy641 = v;
	  yy_destructor(yypParser,217,&yymsp[-5].minor);
  yy_destructor(yypParser,66,&yymsp[-3].minor);
  yy_destructor(yypParser,67,&yymsp[-1].minor);
}
#line 13194 "../LemonSrc/SQLParserL.c"
        break;
      case 731: /* tableConstraintDefinition ::= PRIMARY KEY indexType LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS hint */
#line 5039 "../LemonSrc/SQLParserL.lemon"
{
		TableConstraintDefinition* v = new TableConstraintDefinition(TableConstraintDefinition::PrimaryKey, yymsp[-2].minor.yy1234, yymsp[-4].minor.yy764, yymsp[0].minor.yy858);
		yygotominor.yy641 = v;
	  yy_destructor(yypParser,215,&yymsp[-6].minor);
  yy_destructor(yypParser,216,&yymsp[-5].minor);
  yy_destructor(yypParser,66,&yymsp[-3].minor);
  yy_destructor(yypParser,67,&yymsp[-1].minor);
}
#line 13206 "../LemonSrc/SQLParserL.c"
        break;
      case 732: /* tableConstraintDefinition ::= FOREIGN KEY LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS REFERENCES tableName referencedColumnName hint */
#line 5047 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy641 = new TableConstraintDefinition(TableConstraintDefinition::ForeignKey,
											   yymsp[-5].minor.yy1234, 0, yymsp[0].minor.yy858, yymsp[-2].minor.yy1118, yymsp[-1].minor.yy1234);
	  yy_destructor(yypParser,226,&yymsp[-8].minor);
  yy_destructor(yypParser,216,&yymsp[-7].minor);
  yy_destructor(yypParser,66,&yymsp[-6].minor);
  yy_destructor(yypParser,67,&yymsp[-4].minor);
  yy_destructor(yypParser,227,&yymsp[-3].minor);
}
#line 13219 "../LemonSrc/SQLParserL.c"
        break;
      case 734: /* referencedColumnName ::= LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS */
#line 5060 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1234 = yymsp[-1].minor.yy1234;   yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 13226 "../LemonSrc/SQLParserL.c"
        break;
      case 735: /* hint ::= HINT hintElement */
#line 5068 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy858 = new Hint(yymsp[0].minor.yy564);
	  yy_destructor(yypParser,75,&yymsp[-1].minor);
}
#line 13234 "../LemonSrc/SQLParserL.c"
        break;
      case 736: /* hint ::= */
      case 822: /* hintArea ::= */ yytestcase(yyruleno==822);
#line 5073 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy858 = 0; }
#line 13240 "../LemonSrc/SQLParserL.c"
        break;
      case 737: /* hintElement ::= hintPrimary */
#line 5081 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy564 = new HintElement(yymsp[0].minor.yy934);
	}
#line 13247 "../LemonSrc/SQLParserL.c"
        break;
      case 738: /* hintElement ::= hintElement hintPrimary */
#line 5086 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-1].minor.yy564->append(yymsp[0].minor.yy934);
		yygotominor.yy564 = yymsp[-1].minor.yy564;
	}
#line 13255 "../LemonSrc/SQLParserL.c"
        break;
      case 739: /* hintPrimary ::= literal */
#line 5097 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy1200; }
#line 13260 "../LemonSrc/SQLParserL.c"
        break;
      case 740: /* hintPrimary ::= LEFT_PARENTHESIS hintElementList RIGHT_PARENTHESIS */
#line 5100 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[-1].minor.yy484;   yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 13267 "../LemonSrc/SQLParserL.c"
        break;
      case 741: /* hintPrimary ::= TABLE */
#line 5103 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = new StringValue("TABLE");   yy_destructor(yypParser,149,&yymsp[0].minor);
}
#line 13273 "../LemonSrc/SQLParserL.c"
        break;
      case 742: /* hintPrimary ::= COLUMN */
#line 5106 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = new StringValue("COLUMN");   yy_destructor(yypParser,228,&yymsp[0].minor);
}
#line 13279 "../LemonSrc/SQLParserL.c"
        break;
      case 743: /* hintPrimary ::= FILE */
#line 5109 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = new StringValue("FILE");   yy_destructor(yypParser,229,&yymsp[0].minor);
}
#line 13285 "../LemonSrc/SQLParserL.c"
        break;
      case 744: /* hintPrimary ::= INDEX */
#line 5112 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = new StringValue("INDEX");   yy_destructor(yypParser,230,&yymsp[0].minor);
}
#line 13291 "../LemonSrc/SQLParserL.c"
        break;
      case 745: /* hintPrimary ::= TRIGGER */
#line 5115 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = new StringValue("TRIGGER");   yy_destructor(yypParser,231,&yymsp[0].minor);
}
#line 13297 "../LemonSrc/SQLParserL.c"
        break;
      case 746: /* hintPrimary ::= HEAP */
#line 5118 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = new StringValue("HEAP");   yy_destructor(yypParser,232,&yymsp[0].minor);
}
#line 13303 "../LemonSrc/SQLParserL.c"
        break;
      case 747: /* hintPrimary ::= NONTRUNCATE */
#line 5121 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = new StringValue("NONTRUNCATE");   yy_destructor(yypParser,233,&yymsp[0].minor);
}
#line 13309 "../LemonSrc/SQLParserL.c"
        break;
      case 748: /* hintPrimary ::= UNIQUE */
#line 5124 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = new StringValue("UNIQUE");   yy_destructor(yypParser,217,&yymsp[0].minor);
}
#line 13315 "../LemonSrc/SQLParserL.c"
        break;
      case 749: /* hintPrimary ::= IN ORDER */
#line 5127 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = new StringValue("ORDER");   yy_destructor(yypParser,18,&yymsp[-1].minor);
  yy_destructor(yypParser,85,&yymsp[0].minor);
}
#line 13322 "../LemonSrc/SQLParserL.c"
        break;
      case 750: /* hintElementList ::= hintElement */
#line 5135 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy484 = new HintElementList(yymsp[0].minor.yy564);
	}
#line 13329 "../LemonSrc/SQLParserL.c"
        break;
      case 751: /* hintElementList ::= hintElementList COMMA hintElement */
#line 5140 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-2].minor.yy484->append(yymsp[0].minor.yy564);
		yygotominor.yy484 = yymsp[-2].minor.yy484;
	  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 13338 "../LemonSrc/SQLParserL.c"
        break;
      case 752: /* hintElementList ::= hintElementList COMMA */
#line 5146 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy484 = yymsp[-1].minor.yy484;   yy_destructor(yypParser,13,&yymsp[0].minor);
}
#line 13344 "../LemonSrc/SQLParserL.c"
        break;
      case 753: /* tableAreaOption ::= tableAreaClause */
      case 809: /* indexAreaOption ::= indexAreaClause */ yytestcase(yyruleno==809);
#line 5154 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1053 = yymsp[0].minor.yy1053; }
#line 13350 "../LemonSrc/SQLParserL.c"
        break;
      case 754: /* tableAreaOption ::= */
      case 810: /* indexAreaOption ::= */ yytestcase(yyruleno==810);
#line 5156 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1053 = 0; }
#line 13356 "../LemonSrc/SQLParserL.c"
        break;
      case 755: /* dropTableStatement ::= DROP TABLE tableName optionalIfExists */
#line 5165 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy41 = new DropTableStatement(yymsp[-1].minor.yy1118, yymsp[0].minor.yy937);
	  yy_destructor(yypParser,187,&yymsp[-3].minor);
  yy_destructor(yypParser,149,&yymsp[-2].minor);
}
#line 13365 "../LemonSrc/SQLParserL.c"
        break;
      case 757: /* optionalIfExists ::= IF EXISTS */
#line 5176 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy937 = true;   yy_destructor(yypParser,234,&yymsp[-1].minor);
  yy_destructor(yypParser,80,&yymsp[0].minor);
}
#line 13372 "../LemonSrc/SQLParserL.c"
        break;
      case 758: /* alterTableStatement ::= ALTER TABLE tableName alterTableAction */
#line 5185 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy568 = new AlterTableStatement(yymsp[-1].minor.yy1118, yymsp[0].minor.yy810);
	  yy_destructor(yypParser,188,&yymsp[-3].minor);
  yy_destructor(yypParser,149,&yymsp[-2].minor);
}
#line 13381 "../LemonSrc/SQLParserL.c"
        break;
      case 759: /* alterTableAction ::= setTableAreaClause */
      case 760: /* alterTableAction ::= dropTableAreaClause */ yytestcase(yyruleno==760);
      case 761: /* alterTableAction ::= renameTableClause */ yytestcase(yyruleno==761);
      case 762: /* alterTableAction ::= addColumnDefinition */ yytestcase(yyruleno==762);
      case 763: /* alterTableAction ::= alterColumnDefinition */ yytestcase(yyruleno==763);
      case 764: /* alterTableAction ::= addTableConstraintDefinition */ yytestcase(yyruleno==764);
#line 5195 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy810 = yymsp[0].minor.yy810; }
#line 13391 "../LemonSrc/SQLParserL.c"
        break;
      case 765: /* setTableAreaClause ::= SET tableAreaClause */
#line 5214 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy810 = new AlterTableAction(AlterTableAction::SetArea, yymsp[0].minor.yy1053);
	  yy_destructor(yypParser,153,&yymsp[-1].minor);
}
#line 13399 "../LemonSrc/SQLParserL.c"
        break;
      case 766: /* dropTableAreaClause ::= DROP tableAreaClause */
#line 5224 "../LemonSrc/SQLParserL.lemon"
{
        int iIdx;
        for ( iIdx = 0; iIdx < AreaOption::ValueNum; iIdx++ )
        {
            // AreaName が設定されているかチェック
            if ( yymsp[0].minor.yy1053->getAreaName(static_cast<AreaOption::AreaType>(iIdx)) )
            {
                // AreaName は１つ以上設定されている
                break;
            }
        }

        if ( iIdx == AreaOption::ValueNum )
        {
            // AreaName は全て Null ポインタであったので Default のみ有効にする
            yymsp[0].minor.yy1053->setAreaName(AreaOption::Default, new Identifier());
        }

        // この字句が返すオブジェクトを作成
        yygotominor.yy810 = new AlterTableAction(AlterTableAction::DropArea, yymsp[0].minor.yy1053);
	  yy_destructor(yypParser,187,&yymsp[-1].minor);
}
#line 13425 "../LemonSrc/SQLParserL.c"
        break;
      case 767: /* tableAreaClause ::= AREA tblAreaOption */
      case 819: /* indexAreaClause ::= AREA idxAreaOption */ yytestcase(yyruleno==819);
#line 5252 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1053 = yymsp[0].minor.yy1053;
	  yy_destructor(yypParser,235,&yymsp[-1].minor);
}
#line 13434 "../LemonSrc/SQLParserL.c"
        break;
      case 768: /* tblAreaOption ::= defArea heapArea indexArea ftsArea pycllogArea */
#line 5264 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1053 = new AreaOption(yymsp[-4].minor.yy1118, 0, yymsp[-3].minor.yy1118, yymsp[-2].minor.yy1118,
								yymsp[-1].minor.yy1118, 0, yymsp[0].minor.yy1118, 0);
	}
#line 13442 "../LemonSrc/SQLParserL.c"
        break;
      case 770: /* defArea ::= DEFAULT */
#line 5277 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1118 = new Identifier();   yy_destructor(yypParser,53,&yymsp[0].minor);
}
#line 13448 "../LemonSrc/SQLParserL.c"
        break;
      case 771: /* defArea ::= */
      case 774: /* heapArea ::= */ yytestcase(yyruleno==774);
      case 777: /* indexArea ::= */ yytestcase(yyruleno==777);
      case 780: /* ftsArea ::= */ yytestcase(yyruleno==780);
      case 783: /* pycllogArea ::= */ yytestcase(yyruleno==783);
#line 5279 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1118 = 0; }
#line 13457 "../LemonSrc/SQLParserL.c"
        break;
      case 772: /* heapArea ::= HEAP areaName */
#line 5287 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1118 = yymsp[0].minor.yy1118;   yy_destructor(yypParser,232,&yymsp[-1].minor);
}
#line 13463 "../LemonSrc/SQLParserL.c"
        break;
      case 773: /* heapArea ::= HEAP */
#line 5289 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1118 = new Identifier();   yy_destructor(yypParser,232,&yymsp[0].minor);
}
#line 13469 "../LemonSrc/SQLParserL.c"
        break;
      case 775: /* indexArea ::= INDEX areaName */
#line 5299 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1118 = yymsp[0].minor.yy1118;   yy_destructor(yypParser,230,&yymsp[-1].minor);
}
#line 13475 "../LemonSrc/SQLParserL.c"
        break;
      case 776: /* indexArea ::= INDEX */
#line 5301 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1118 = new Identifier();   yy_destructor(yypParser,230,&yymsp[0].minor);
}
#line 13481 "../LemonSrc/SQLParserL.c"
        break;
      case 778: /* ftsArea ::= FULLTEXT areaName */
#line 5311 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1118 = yymsp[0].minor.yy1118;   yy_destructor(yypParser,114,&yymsp[-1].minor);
}
#line 13487 "../LemonSrc/SQLParserL.c"
        break;
      case 779: /* ftsArea ::= FULLTEXT */
#line 5313 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1118 = new Identifier();   yy_destructor(yypParser,114,&yymsp[0].minor);
}
#line 13493 "../LemonSrc/SQLParserL.c"
        break;
      case 781: /* pycllogArea ::= PHYSICALLOG areaName */
#line 5323 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1118 = yymsp[0].minor.yy1118;   yy_destructor(yypParser,236,&yymsp[-1].minor);
}
#line 13499 "../LemonSrc/SQLParserL.c"
        break;
      case 782: /* pycllogArea ::= PHYSICALLOG */
#line 5325 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy1118 = new Identifier();   yy_destructor(yypParser,236,&yymsp[0].minor);
}
#line 13505 "../LemonSrc/SQLParserL.c"
        break;
      case 784: /* renameTableClause ::= RENAME TO identifier */
#line 5335 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy810 = new AlterTableAction(AlterTableAction::Rename, yymsp[0].minor.yy1118);
	  yy_destructor(yypParser,237,&yymsp[-2].minor);
  yy_destructor(yypParser,72,&yymsp[-1].minor);
}
#line 13514 "../LemonSrc/SQLParserL.c"
        break;
      case 785: /* renameTableClause ::= RENAME asCorrelationName */
#line 5339 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy810 = new AlterTableAction(AlterTableAction::Rename, yymsp[0].minor.yy1118);
	  yy_destructor(yypParser,237,&yymsp[-1].minor);
}
#line 13522 "../LemonSrc/SQLParserL.c"
        break;
      case 786: /* addColumnDefinition ::= ADD addColumnDefinitionBody */
#line 5349 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy810 = new AlterTableAction(AlterTableAction::AddColumn, yymsp[0].minor.yy117);
	  yy_destructor(yypParser,238,&yymsp[-1].minor);
}
#line 13530 "../LemonSrc/SQLParserL.c"
        break;
      case 787: /* addColumnDefinition ::= ADD COLUMN addColumnDefinitionBody */
#line 5353 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy810 = new AlterTableAction(AlterTableAction::AddColumn, yymsp[0].minor.yy117);
	  yy_destructor(yypParser,238,&yymsp[-2].minor);
  yy_destructor(yypParser,228,&yymsp[-1].minor);
}
#line 13539 "../LemonSrc/SQLParserL.c"
        break;
      case 788: /* addColumnDefinitionBody ::= columnDefinition */
#line 5363 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy117 = new TableElementList(yymsp[0].minor.yy418);
	}
#line 13546 "../LemonSrc/SQLParserL.c"
        break;
      case 789: /* addColumnDefinitionBody ::= addColumnDefinitionBody COMMA columnDefinition */
#line 5367 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-2].minor.yy117->append(yymsp[0].minor.yy418);
		yygotominor.yy117 = yymsp[-2].minor.yy117;
	  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 13555 "../LemonSrc/SQLParserL.c"
        break;
      case 791: /* alterColumnDefinition ::= ALTER alterColumnAction */
#line 5380 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy810 = new AlterTableAction(AlterTableAction::AlterColumn, yymsp[0].minor.yy934);
	  yy_destructor(yypParser,188,&yymsp[-1].minor);
}
#line 13563 "../LemonSrc/SQLParserL.c"
        break;
      case 792: /* alterColumnDefinition ::= ALTER COLUMN alterColumnAction */
#line 5384 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy810 = new AlterTableAction(AlterTableAction::AlterColumn, yymsp[0].minor.yy934);
	  yy_destructor(yypParser,188,&yymsp[-2].minor);
  yy_destructor(yypParser,228,&yymsp[-1].minor);
}
#line 13572 "../LemonSrc/SQLParserL.c"
        break;
      case 793: /* alterColumnAction ::= columnDefinition */
#line 5394 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy934 = yymsp[0].minor.yy418; }
#line 13577 "../LemonSrc/SQLParserL.c"
        break;
      case 794: /* addTableConstraintDefinition ::= ADD tableConstraintDefinition */
#line 5402 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy810 = new AlterTableAction(AlterTableAction::AddTableConstraint, yymsp[0].minor.yy641);
	  yy_destructor(yypParser,238,&yymsp[-1].minor);
}
#line 13585 "../LemonSrc/SQLParserL.c"
        break;
      case 795: /* indexDefinition ::= CREATE indexType INDEX identifier ON tableName LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS languageColumnOption scoreColumnOption hint indexAreaOption */
#line 5417 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy456 = new IndexDefinition(
			yymsp[-9].minor.yy1118, yymsp[-7].minor.yy1118, yymsp[-5].minor.yy1234, yymsp[-11].minor.yy764, yymsp[-3].minor.yy370, yymsp[-2].minor.yy370, yymsp[-1].minor.yy858, yymsp[0].minor.yy1053);
	  yy_destructor(yypParser,178,&yymsp[-12].minor);
  yy_destructor(yypParser,230,&yymsp[-10].minor);
  yy_destructor(yypParser,12,&yymsp[-8].minor);
  yy_destructor(yypParser,66,&yymsp[-6].minor);
  yy_destructor(yypParser,67,&yymsp[-4].minor);
}
#line 13598 "../LemonSrc/SQLParserL.c"
        break;
      case 796: /* indexType ::= CLUSTERED */
#line 5427 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = IndexDefinition::Clustered;   yy_destructor(yypParser,121,&yymsp[0].minor);
}
#line 13604 "../LemonSrc/SQLParserL.c"
        break;
      case 797: /* indexType ::= NONCLUSTERED */
#line 5430 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = IndexDefinition::NonClustered;   yy_destructor(yypParser,239,&yymsp[0].minor);
}
#line 13610 "../LemonSrc/SQLParserL.c"
        break;
      case 798: /* indexType ::= FULLTEXT */
#line 5433 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = IndexDefinition::FullText;   yy_destructor(yypParser,114,&yymsp[0].minor);
}
#line 13616 "../LemonSrc/SQLParserL.c"
        break;
      case 799: /* indexType ::= BITMAP */
#line 5436 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = IndexDefinition::Bitmap;   yy_destructor(yypParser,240,&yymsp[0].minor);
}
#line 13622 "../LemonSrc/SQLParserL.c"
        break;
      case 800: /* indexType ::= ARRAY */
#line 5439 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = IndexDefinition::Array;   yy_destructor(yypParser,146,&yymsp[0].minor);
}
#line 13628 "../LemonSrc/SQLParserL.c"
        break;
      case 801: /* indexType ::= UNIQUE */
#line 5442 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = IndexDefinition::Unique;   yy_destructor(yypParser,217,&yymsp[0].minor);
}
#line 13634 "../LemonSrc/SQLParserL.c"
        break;
      case 802: /* indexType ::= ALL ROWS */
#line 5445 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = IndexDefinition::AllRows;   yy_destructor(yypParser,62,&yymsp[-1].minor);
  yy_destructor(yypParser,241,&yymsp[0].minor);
}
#line 13641 "../LemonSrc/SQLParserL.c"
        break;
      case 803: /* indexType ::= KDTREE */
#line 5448 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = IndexDefinition::KdTree;   yy_destructor(yypParser,242,&yymsp[0].minor);
}
#line 13647 "../LemonSrc/SQLParserL.c"
        break;
      case 804: /* indexType ::= */
#line 5451 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = IndexDefinition::None; }
#line 13652 "../LemonSrc/SQLParserL.c"
        break;
      case 805: /* languageColumnOption ::= LANGUAGE COLUMN columnName */
#line 5459 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy370 = yymsp[0].minor.yy370;   yy_destructor(yypParser,29,&yymsp[-2].minor);
  yy_destructor(yypParser,228,&yymsp[-1].minor);
}
#line 13659 "../LemonSrc/SQLParserL.c"
        break;
      case 806: /* languageColumnOption ::= */
      case 808: /* scoreColumnOption ::= */ yytestcase(yyruleno==808);
#line 5461 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy370 = 0; }
#line 13665 "../LemonSrc/SQLParserL.c"
        break;
      case 807: /* scoreColumnOption ::= SCORE COLUMN columnName */
#line 5469 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy370 = yymsp[0].minor.yy370;   yy_destructor(yypParser,116,&yymsp[-2].minor);
  yy_destructor(yypParser,228,&yymsp[-1].minor);
}
#line 13672 "../LemonSrc/SQLParserL.c"
        break;
      case 811: /* dropIndexStatement ::= DROP INDEX identifier optionalIfExists */
#line 5490 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy745 = new DropIndexStatement(yymsp[-1].minor.yy1118, yymsp[0].minor.yy937);
	  yy_destructor(yypParser,187,&yymsp[-3].minor);
  yy_destructor(yypParser,230,&yymsp[-2].minor);
}
#line 13681 "../LemonSrc/SQLParserL.c"
        break;
      case 812: /* alterIndexStatement ::= ALTER INDEX identifier alterIndexAction */
#line 5501 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1192 = new AlterIndexStatement(yymsp[-1].minor.yy1118, yymsp[0].minor.yy25);
	  yy_destructor(yypParser,188,&yymsp[-3].minor);
  yy_destructor(yypParser,230,&yymsp[-2].minor);
}
#line 13690 "../LemonSrc/SQLParserL.c"
        break;
      case 813: /* alterIndexAction ::= setIndexAreaClause */
      case 814: /* alterIndexAction ::= dropIndexAreaClause */ yytestcase(yyruleno==814);
      case 815: /* alterIndexAction ::= renameIndexClause */ yytestcase(yyruleno==815);
      case 816: /* alterIndexAction ::= offlineIndexClause */ yytestcase(yyruleno==816);
#line 5511 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy25 = yymsp[0].minor.yy25; }
#line 13698 "../LemonSrc/SQLParserL.c"
        break;
      case 817: /* setIndexAreaClause ::= SET indexAreaClause */
#line 5525 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy25 = new AlterIndexAction(AlterIndexAction::SetArea,
									  yymsp[0].minor.yy1053);
	  yy_destructor(yypParser,153,&yymsp[-1].minor);
}
#line 13707 "../LemonSrc/SQLParserL.c"
        break;
      case 818: /* dropIndexAreaClause ::= DROP indexAreaClause */
#line 5536 "../LemonSrc/SQLParserL.lemon"
{
        int iIdx;
        for ( iIdx = 0; iIdx < AreaOption::ValueNum; iIdx++ )
        {
            // AreaName が設定されているかチェック
            if ( yymsp[0].minor.yy1053->getAreaName(static_cast<AreaOption::AreaType>(iIdx)) )
            {
                // AreaName は１つ以上設定されている
                break;
            }
        }

        if ( iIdx == AreaOption::ValueNum )
        {
            // AreaName は全て Null ポインタであったので Default のみ有効にする
            yymsp[0].minor.yy1053->setAreaName(AreaOption::Default, new Identifier());
        }
        // この字句が返すオブジェクトを作成
        yygotominor.yy25 = new AlterIndexAction(AlterIndexAction::DropArea, yymsp[0].minor.yy1053);
      yy_destructor(yypParser,187,&yymsp[-1].minor);
}
#line 13732 "../LemonSrc/SQLParserL.c"
        break;
      case 820: /* idxAreaOption ::= defArea pycllogArea hintArea */
#line 5574 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1053 = new AreaOption(yymsp[-2].minor.yy1118, 0, 0, 0, 0, 0, yymsp[-1].minor.yy1118, yymsp[0].minor.yy858);
	}
#line 13739 "../LemonSrc/SQLParserL.c"
        break;
      case 821: /* hintArea ::= HINT AREA characterStringLiteral */
#line 5584 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy858 = new Hint(new HintElement(yymsp[0].minor.yy1200));
	  yy_destructor(yypParser,75,&yymsp[-2].minor);
  yy_destructor(yypParser,235,&yymsp[-1].minor);
}
#line 13748 "../LemonSrc/SQLParserL.c"
        break;
      case 823: /* renameIndexClause ::= RENAME TO identifier */
#line 5596 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy25 = new AlterIndexAction(AlterIndexAction::Rename,
									  yymsp[0].minor.yy1118);
	  yy_destructor(yypParser,237,&yymsp[-2].minor);
  yy_destructor(yypParser,72,&yymsp[-1].minor);
}
#line 13758 "../LemonSrc/SQLParserL.c"
        break;
      case 824: /* renameIndexClause ::= RENAME asCorrelationName */
#line 5601 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy25 = new AlterIndexAction(AlterIndexAction::Rename,
									  yymsp[0].minor.yy1118);
	  yy_destructor(yypParser,237,&yymsp[-1].minor);
}
#line 13767 "../LemonSrc/SQLParserL.c"
        break;
      case 825: /* offlineIndexClause ::= ONLINE */
#line 5612 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy25 = new AlterIndexAction(AlterIndexAction::Online);
	  yy_destructor(yypParser,182,&yymsp[0].minor);
}
#line 13775 "../LemonSrc/SQLParserL.c"
        break;
      case 826: /* offlineIndexClause ::= OFFLINE */
#line 5616 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy25 = new AlterIndexAction(AlterIndexAction::Offline);
	  yy_destructor(yypParser,183,&yymsp[0].minor);
}
#line 13783 "../LemonSrc/SQLParserL.c"
        break;
      case 827: /* areaDefinition ::= CREATE AREA areaName areaPath */
#line 5627 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy857 = new AreaDefinition(yymsp[-1].minor.yy1118, yymsp[0].minor.yy586);
	  yy_destructor(yypParser,178,&yymsp[-3].minor);
  yy_destructor(yypParser,235,&yymsp[-2].minor);
}
#line 13792 "../LemonSrc/SQLParserL.c"
        break;
      case 829: /* areaPath ::= areaPathElement */
      case 833: /* areaArrayElement ::= areaPathElement */ yytestcase(yyruleno==833);
      case 842: /* singleModifyAreaClause ::= areaPathElement */ yytestcase(yyruleno==842);
#line 5645 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy586 = new AreaElementList(yymsp[0].minor.yy1187);
	}
#line 13801 "../LemonSrc/SQLParserL.c"
        break;
      case 830: /* areaPath ::= areaPathArray */
      case 843: /* arrayFullModifyAreaClause ::= areaPathArray */ yytestcase(yyruleno==843);
      case 844: /* arrayElementModifyAreaClause ::= newAreaSpecifiedPathElement */ yytestcase(yyruleno==844);
#line 5649 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy586 = yymsp[0].minor.yy586; }
#line 13808 "../LemonSrc/SQLParserL.c"
        break;
      case 831: /* areaPathElement ::= characterStringLiteral */
#line 5657 "../LemonSrc/SQLParserL.lemon"
{
		// Hint は未実装。
		yygotominor.yy1187 = new AreaDataDefinition(yymsp[0].minor.yy1200, 0);
	}
#line 13816 "../LemonSrc/SQLParserL.c"
        break;
      case 832: /* areaPathArray ::= ARRAY LEFT_BRACKET areaArrayElement RIGHT_BRACKET */
#line 5668 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy586 = yymsp[-1].minor.yy586;   yy_destructor(yypParser,146,&yymsp[-3].minor);
  yy_destructor(yypParser,60,&yymsp[-2].minor);
  yy_destructor(yypParser,61,&yymsp[0].minor);
}
#line 13824 "../LemonSrc/SQLParserL.c"
        break;
      case 834: /* areaArrayElement ::= areaArrayElement COMMA areaPathElement */
#line 5680 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-2].minor.yy586->append(yymsp[0].minor.yy1187);
		yygotominor.yy586 = yymsp[-2].minor.yy586;
	  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 13833 "../LemonSrc/SQLParserL.c"
        break;
      case 835: /* areaArrayElement ::= areaArrayElement COMMA */
#line 5685 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy586 = yymsp[-1].minor.yy586;   yy_destructor(yypParser,13,&yymsp[0].minor);
}
#line 13839 "../LemonSrc/SQLParserL.c"
        break;
      case 836: /* dropAreaStatement ::= DROP AREA areaName optionalIfExists */
#line 5694 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy706 = new DropAreaStatement(yymsp[-1].minor.yy1118, yymsp[0].minor.yy937);
	  yy_destructor(yypParser,187,&yymsp[-3].minor);
  yy_destructor(yypParser,235,&yymsp[-2].minor);
}
#line 13848 "../LemonSrc/SQLParserL.c"
        break;
      case 837: /* alterAreaStatement ::= ALTER AREA identifier alterAreaAction */
#line 5705 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy37 = new AlterAreaStatement(yymsp[-1].minor.yy1118, yymsp[0].minor.yy490);
	  yy_destructor(yypParser,188,&yymsp[-3].minor);
  yy_destructor(yypParser,235,&yymsp[-2].minor);
}
#line 13857 "../LemonSrc/SQLParserL.c"
        break;
      case 838: /* alterAreaAction ::= modifyAreaDefinition */
#line 5715 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy490 = yymsp[0].minor.yy490; }
#line 13862 "../LemonSrc/SQLParserL.c"
        break;
      case 839: /* modifyAreaDefinition ::= MODIFY singleModifyAreaClause */
#line 5723 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy490 = new AlterAreaAction(AlterAreaAction::SingleModify,
									 yymsp[0].minor.yy586);
	  yy_destructor(yypParser,243,&yymsp[-1].minor);
}
#line 13871 "../LemonSrc/SQLParserL.c"
        break;
      case 840: /* modifyAreaDefinition ::= MODIFY arrayFullModifyAreaClause */
#line 5728 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy490 = new AlterAreaAction(AlterAreaAction::FullAryModify,
									 yymsp[0].minor.yy586);
	  yy_destructor(yypParser,243,&yymsp[-1].minor);
}
#line 13880 "../LemonSrc/SQLParserL.c"
        break;
      case 841: /* modifyAreaDefinition ::= MODIFY arrayElementModifyAreaClause */
#line 5733 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy490 = new AlterAreaAction(AlterAreaAction::ElemAryModify,
									 yymsp[0].minor.yy586);
	  yy_destructor(yypParser,243,&yymsp[-1].minor);
}
#line 13889 "../LemonSrc/SQLParserL.c"
        break;
      case 845: /* newAreaSpecifiedPathElement ::= LEFT_BRACKET length RIGHT_BRACKET areaPathElement */
#line 5772 "../LemonSrc/SQLParserL.lemon"
{
		if (yymsp[-2].minor.yy764 >= 0) {
			AreaElementList* pList = new AreaElementList();
			for ( int iCnt = 0; iCnt < static_cast<int>(yymsp[-2].minor.yy764); iCnt++ )
			{
				pList->setAt(iCnt, 0);
			}
			pList->setAt(yymsp[-2].minor.yy764, yymsp[0].minor.yy1187);
			yygotominor.yy586 = pList;
		} else {
			yygotominor.yy586 = 0;
			pParser->throwSyntaxErrorException(srcFile ,__LINE__);
		}
	  yy_destructor(yypParser,60,&yymsp[-3].minor);
  yy_destructor(yypParser,61,&yymsp[-1].minor);
}
#line 13909 "../LemonSrc/SQLParserL.c"
        break;
      case 846: /* unmountDatabaseStatement ::= UNMOUNT dbName */
#line 5794 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1043 = new UnmountDatabaseStatement(yymsp[0].minor.yy1118);
	  yy_destructor(yypParser,244,&yymsp[-1].minor);
}
#line 13917 "../LemonSrc/SQLParserL.c"
        break;
      case 847: /* mountDatabaseStatement ::= MOUNT dbName databaseMountOptionList optionalAreaParameter USING SNAPSHOT WITH RECOVERY */
#line 5807 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy936 = new MountDatabaseStatement(
			yymsp[-6].minor.yy1118, yymsp[-5].minor.yy553, yymsp[-4].minor.yy515, true, true, false);
	  yy_destructor(yypParser,245,&yymsp[-7].minor);
  yy_destructor(yypParser,33,&yymsp[-3].minor);
  yy_destructor(yypParser,165,&yymsp[-2].minor);
  yy_destructor(yypParser,74,&yymsp[-1].minor);
  yy_destructor(yypParser,185,&yymsp[0].minor);
}
#line 13930 "../LemonSrc/SQLParserL.c"
        break;
      case 848: /* mountDatabaseStatement ::= MOUNT dbName databaseMountOptionList optionalAreaParameter USING SNAPSHOT */
#line 5815 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy936 = new MountDatabaseStatement(
			yymsp[-4].minor.yy1118, yymsp[-3].minor.yy553, yymsp[-2].minor.yy515, true, false, false);
	  yy_destructor(yypParser,245,&yymsp[-5].minor);
  yy_destructor(yypParser,33,&yymsp[-1].minor);
  yy_destructor(yypParser,165,&yymsp[0].minor);
}
#line 13941 "../LemonSrc/SQLParserL.c"
        break;
      case 849: /* mountDatabaseStatement ::= MOUNT dbName databaseMountOptionList optionalAreaParameter WITH DISCARD LOGICALLOG */
#line 5823 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy936 = new MountDatabaseStatement(
			yymsp[-5].minor.yy1118, yymsp[-4].minor.yy553, yymsp[-3].minor.yy515, false, false, true);
	  yy_destructor(yypParser,245,&yymsp[-6].minor);
  yy_destructor(yypParser,74,&yymsp[-2].minor);
  yy_destructor(yypParser,184,&yymsp[-1].minor);
  yy_destructor(yypParser,180,&yymsp[0].minor);
}
#line 13953 "../LemonSrc/SQLParserL.c"
        break;
      case 850: /* mountDatabaseStatement ::= MOUNT dbName databaseMountOptionList optionalAreaParameter WITH RECOVERY */
#line 5831 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy936 = new MountDatabaseStatement(
			yymsp[-4].minor.yy1118, yymsp[-3].minor.yy553, yymsp[-2].minor.yy515, false, true, false);
	  yy_destructor(yypParser,245,&yymsp[-5].minor);
  yy_destructor(yypParser,74,&yymsp[-1].minor);
  yy_destructor(yypParser,185,&yymsp[0].minor);
}
#line 13964 "../LemonSrc/SQLParserL.c"
        break;
      case 851: /* mountDatabaseStatement ::= MOUNT dbName databaseMountOptionList optionalAreaParameter */
#line 5839 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy936 = new MountDatabaseStatement(
			yymsp[-2].minor.yy1118, yymsp[-1].minor.yy553, yymsp[0].minor.yy515, false, false, false);
	  yy_destructor(yypParser,245,&yymsp[-3].minor);
}
#line 13973 "../LemonSrc/SQLParserL.c"
        break;
      case 852: /* mountDatabaseStatement ::= MOUNT dbName databaseMountOptionList optionalAreaParameter AS SLAVE FROM MASTER characterStringLiteral */
#line 5848 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy936 = new MountDatabaseStatement(
			yymsp[-7].minor.yy1118, yymsp[-6].minor.yy553, yymsp[-5].minor.yy515, false, false, false);
		yygotominor.yy936->setMasterUrl(yymsp[0].minor.yy1200);
	  yy_destructor(yypParser,245,&yymsp[-8].minor);
  yy_destructor(yypParser,70,&yymsp[-4].minor);
  yy_destructor(yypParser,189,&yymsp[-3].minor);
  yy_destructor(yypParser,76,&yymsp[-2].minor);
  yy_destructor(yypParser,191,&yymsp[-1].minor);
}
#line 13987 "../LemonSrc/SQLParserL.c"
        break;
      case 853: /* databaseMountOptionList ::= databaseCreateOptionList */
#line 5860 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[0].minor.yy553->assureCreateOptions(*pParser);

		//PathOption 要素が必須
		bool bPathExist = false;
		for ( int i = yymsp[0].minor.yy553->getCount() ; 0 < i ; --i ) {
			Statement::DatabaseCreateOption* pObj = yymsp[0].minor.yy553->getCreateOptionAt(i-1);
			if ( pObj && ( pObj->getOptionType() == Statement::DatabaseCreateOption::PathOption ) ) {
				bPathExist = true;
				break;
			}
		}
		if ( !bPathExist ) {
			//PathOption 要素が不足
			yygotominor.yy553 = 0;
			pParser->throwSyntaxErrorException(srcFile ,__LINE__);
		} else {
			yygotominor.yy553 = yymsp[0].minor.yy553;//正常
		}
	}
#line 14011 "../LemonSrc/SQLParserL.c"
        break;
      case 854: /* optionalAreaParameter ::= optionalAreaParameterList */
#line 5887 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy515 = new OptionalAreaParameter( OptionalAreaParameter::ParameterList ,yymsp[0].minor.yy243 );
	}
#line 14018 "../LemonSrc/SQLParserL.c"
        break;
      case 855: /* optionalAreaParameter ::= DROP ALL AREA */
#line 5891 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy515 = new OptionalAreaParameter( OptionalAreaParameter::DropAllArea ,0 );
	  yy_destructor(yypParser,187,&yymsp[-2].minor);
  yy_destructor(yypParser,62,&yymsp[-1].minor);
  yy_destructor(yypParser,235,&yymsp[0].minor);
}
#line 14028 "../LemonSrc/SQLParserL.c"
        break;
      case 856: /* optionalAreaParameter ::= */
#line 5895 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy515 = 0;
	}
#line 14035 "../LemonSrc/SQLParserL.c"
        break;
      case 857: /* optionalAreaParameterList ::= alterAreaStatement */
#line 5905 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy243 = new OptionalAreaParameterList(yymsp[0].minor.yy37);
	}
#line 14042 "../LemonSrc/SQLParserL.c"
        break;
      case 858: /* optionalAreaParameterList ::= dropAreaStatement */
#line 5909 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy243 = new OptionalAreaParameterList(yymsp[0].minor.yy706);
	}
#line 14049 "../LemonSrc/SQLParserL.c"
        break;
      case 859: /* optionalAreaParameterList ::= optionalAreaParameterList alterAreaStatement */
#line 5913 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-1].minor.yy243->append(yymsp[0].minor.yy37);
		yygotominor.yy243 = yymsp[-1].minor.yy243;
	}
#line 14057 "../LemonSrc/SQLParserL.c"
        break;
      case 860: /* optionalAreaParameterList ::= optionalAreaParameterList dropAreaStatement */
#line 5918 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-1].minor.yy243->append(yymsp[0].minor.yy706);
		yygotominor.yy243 = yymsp[-1].minor.yy243;
	}
#line 14065 "../LemonSrc/SQLParserL.c"
        break;
      case 861: /* startBackupStatement ::= START BACKUP backupType versionType */
#line 5930 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1108 = new StartBackupStatement( yymsp[-1].minor.yy764, yymsp[0].minor.yy764 );
	  yy_destructor(yypParser,154,&yymsp[-3].minor);
  yy_destructor(yypParser,246,&yymsp[-2].minor);
}
#line 14074 "../LemonSrc/SQLParserL.c"
        break;
      case 862: /* backupType ::= FULL */
#line 5939 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = StartBackupStatement::Full;   yy_destructor(yypParser,9,&yymsp[0].minor);
}
#line 14080 "../LemonSrc/SQLParserL.c"
        break;
      case 863: /* backupType ::= MASTER */
#line 5941 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = StartBackupStatement::Master;   yy_destructor(yypParser,191,&yymsp[0].minor);
}
#line 14086 "../LemonSrc/SQLParserL.c"
        break;
      case 864: /* backupType ::= LOGICALLOG */
#line 5943 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = StartBackupStatement::LogicalLog;   yy_destructor(yypParser,180,&yymsp[0].minor);
}
#line 14092 "../LemonSrc/SQLParserL.c"
        break;
      case 865: /* backupType ::= */
#line 5945 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = StartBackupStatement::Unknown; }
#line 14097 "../LemonSrc/SQLParserL.c"
        break;
      case 866: /* versionType ::= DISCARD SNAPSHOT */
#line 5952 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = StartBackupStatement::DiscardSnapshot;   yy_destructor(yypParser,184,&yymsp[-1].minor);
  yy_destructor(yypParser,165,&yymsp[0].minor);
}
#line 14104 "../LemonSrc/SQLParserL.c"
        break;
      case 867: /* versionType ::= */
#line 5954 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = StartBackupStatement::UnknownVersion; }
#line 14109 "../LemonSrc/SQLParserL.c"
        break;
      case 868: /* endBackupStatement ::= END BACKUP WITH DISCARD LOGICALLOG */
#line 5963 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy861 = new EndBackupStatement(LogicalLogOption::Discard);
	  yy_destructor(yypParser,140,&yymsp[-4].minor);
  yy_destructor(yypParser,246,&yymsp[-3].minor);
  yy_destructor(yypParser,74,&yymsp[-2].minor);
  yy_destructor(yypParser,184,&yymsp[-1].minor);
  yy_destructor(yypParser,180,&yymsp[0].minor);
}
#line 14121 "../LemonSrc/SQLParserL.c"
        break;
      case 869: /* endBackupStatement ::= END BACKUP */
#line 5967 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy861 = new EndBackupStatement();
	  yy_destructor(yypParser,140,&yymsp[-1].minor);
  yy_destructor(yypParser,246,&yymsp[0].minor);
}
#line 14130 "../LemonSrc/SQLParserL.c"
        break;
      case 870: /* verifyStatement ::= VERIFY verifySchemaType identifier */
#line 5978 "../LemonSrc/SQLParserL.lemon"
{
        yygotominor.yy133 = new VerifyStatement(yymsp[-1].minor.yy754, yymsp[0].minor.yy1118, 0);
      yy_destructor(yypParser,247,&yymsp[-2].minor);
}
#line 14138 "../LemonSrc/SQLParserL.c"
        break;
      case 871: /* verifyStatement ::= VERIFY verifySchemaType identifier optionList */
#line 5982 "../LemonSrc/SQLParserL.lemon"
{
        yygotominor.yy133 = new VerifyStatement(yymsp[-2].minor.yy754, yymsp[-1].minor.yy1118, yymsp[0].minor.yy409);
		delete yymsp[0].minor.yy409;
      yy_destructor(yypParser,247,&yymsp[-3].minor);
}
#line 14147 "../LemonSrc/SQLParserL.c"
        break;
      case 872: /* verifySchemaType ::= DATABASE */
#line 5992 "../LemonSrc/SQLParserL.lemon"
{
        yygotominor.yy754 = new IntegerValue(VerifyStatement::SchemaType::Database);
      yy_destructor(yypParser,179,&yymsp[0].minor);
}
#line 14155 "../LemonSrc/SQLParserL.c"
        break;
      case 873: /* verifySchemaType ::= TABLE */
#line 5996 "../LemonSrc/SQLParserL.lemon"
{
        yygotominor.yy754 = new IntegerValue(VerifyStatement::SchemaType::Table);
      yy_destructor(yypParser,149,&yymsp[0].minor);
}
#line 14163 "../LemonSrc/SQLParserL.c"
        break;
      case 874: /* verifySchemaType ::= INDEX */
#line 6000 "../LemonSrc/SQLParserL.lemon"
{
        yygotominor.yy754 = new IntegerValue(VerifyStatement::SchemaType::Index);
      yy_destructor(yypParser,230,&yymsp[0].minor);
}
#line 14171 "../LemonSrc/SQLParserL.c"
        break;
      case 875: /* optionList ::= verifyOption */
#line 6010 "../LemonSrc/SQLParserL.lemon"
{
        ModAutoPointer<VerifyOptionList> p = new VerifyOptionList();
        p->pushBack(yymsp[0].minor.yy764);
		yygotominor.yy409 = p.release();
    }
#line 14180 "../LemonSrc/SQLParserL.c"
        break;
      case 876: /* optionList ::= optionList verifyOption */
#line 6016 "../LemonSrc/SQLParserL.lemon"
{
        yymsp[-1].minor.yy409->pushBack(yymsp[0].minor.yy764);
        yygotominor.yy409 = yymsp[-1].minor.yy409;
    }
#line 14188 "../LemonSrc/SQLParserL.c"
        break;
      case 877: /* verifyOption ::= CORRECT */
#line 6026 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = VerifyStatement::Option::Correct;   yy_destructor(yypParser,248,&yymsp[0].minor);
}
#line 14194 "../LemonSrc/SQLParserL.c"
        break;
      case 878: /* verifyOption ::= CONTINUE */
#line 6028 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = VerifyStatement::Option::Continue;   yy_destructor(yypParser,249,&yymsp[0].minor);
}
#line 14200 "../LemonSrc/SQLParserL.c"
        break;
      case 879: /* verifyOption ::= CASCADE */
#line 6030 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = VerifyStatement::Option::Cascade;   yy_destructor(yypParser,250,&yymsp[0].minor);
}
#line 14206 "../LemonSrc/SQLParserL.c"
        break;
      case 880: /* verifyOption ::= VERBOSE */
#line 6032 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = VerifyStatement::Option::Verbose;   yy_destructor(yypParser,251,&yymsp[0].minor);
}
#line 14212 "../LemonSrc/SQLParserL.c"
        break;
      case 881: /* verifyOption ::= VALUE */
#line 6034 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy764 = VerifyStatement::Option::Data;   yy_destructor(yypParser,252,&yymsp[0].minor);
}
#line 14218 "../LemonSrc/SQLParserL.c"
        break;
      case 882: /* syncStatement ::= SYNC */
#line 6043 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1057 = new SyncStatement();
	  yy_destructor(yypParser,253,&yymsp[0].minor);
}
#line 14226 "../LemonSrc/SQLParserL.c"
        break;
      case 883: /* syncStatement ::= SYNC unsignedIntegerLiteral */
#line 6047 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<SyncStatement> p = new SyncStatement();
		p->setCount(*yymsp[0].minor.yy1200);
		delete yymsp[0].minor.yy1200;

		yygotominor.yy1057 = p.release();
	  yy_destructor(yypParser,253,&yymsp[-1].minor);
}
#line 14238 "../LemonSrc/SQLParserL.c"
        break;
      case 884: /* disconnectStatement ::= DISCONNECT SESSION unsignedIntegerLiteral OF CONNECTION unsignedIntegerLiteral */
#line 6062 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<DisconnectStatement> p = new DisconnectStatement(DisconnectStatement::Mode::SESSION_MODE);
		p->setClientId(*yymsp[0].minor.yy1200);
		p->setSessionId(*yymsp[-3].minor.yy1200);
		delete yymsp[0].minor.yy1200;
		delete yymsp[-3].minor.yy1200;

		yygotominor.yy822 = p.release();
	  yy_destructor(yypParser,254,&yymsp[-5].minor);
  yy_destructor(yypParser,255,&yymsp[-4].minor);
  yy_destructor(yypParser,123,&yymsp[-2].minor);
  yy_destructor(yypParser,256,&yymsp[-1].minor);
}
#line 14255 "../LemonSrc/SQLParserL.c"
        break;
      case 885: /* disconnectStatement ::= DISCONNECT CONNECTION unsignedIntegerLiteral */
#line 6073 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<DisconnectStatement> p = new DisconnectStatement(DisconnectStatement::Mode::CLIENT_MODE);
		p->setClientId(*yymsp[0].minor.yy1200);
		delete yymsp[0].minor.yy1200;

		yygotominor.yy822 = p.release();
	  yy_destructor(yypParser,254,&yymsp[-2].minor);
  yy_destructor(yypParser,256,&yymsp[-1].minor);
}
#line 14268 "../LemonSrc/SQLParserL.c"
        break;
      case 886: /* declareStatement ::= DECLARE variableName BITMAP */
#line 6089 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy124 = new DeclareStatement(yymsp[-1].minor.yy278);
	  yy_destructor(yypParser,257,&yymsp[-2].minor);
  yy_destructor(yypParser,240,&yymsp[0].minor);
}
#line 14277 "../LemonSrc/SQLParserL.c"
        break;
      case 887: /* checkpointStatement ::= CHECKPOINT */
#line 6102 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1248 = new CheckpointStatement();
	  yy_destructor(yypParser,186,&yymsp[0].minor);
}
#line 14285 "../LemonSrc/SQLParserL.c"
        break;
      case 888: /* checkpointStatement ::= CHECKPOINT unsignedIntegerLiteral */
#line 6106 "../LemonSrc/SQLParserL.lemon"
{
		ModAutoPointer<CheckpointStatement> p = new CheckpointStatement();
		p->setCount(*yymsp[0].minor.yy1200);
		delete yymsp[0].minor.yy1200;

		yygotominor.yy1248 = p.release();
	  yy_destructor(yypParser,186,&yymsp[-1].minor);
}
#line 14297 "../LemonSrc/SQLParserL.c"
        break;
      case 889: /* grantStatement ::= GRANT roles TO granteeList */
#line 6121 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1276 = new GrantStatement(yymsp[-2].minor.yy1134, yymsp[0].minor.yy1134);
	  yy_destructor(yypParser,258,&yymsp[-3].minor);
  yy_destructor(yypParser,72,&yymsp[-1].minor);
}
#line 14306 "../LemonSrc/SQLParserL.c"
        break;
      case 890: /* roles ::= identifier */
      case 892: /* granteeList ::= identifier */ yytestcase(yyruleno==892);
#line 6131 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1134 = new IdentifierList(yymsp[0].minor.yy1118);
	}
#line 14314 "../LemonSrc/SQLParserL.c"
        break;
      case 891: /* roles ::= roles COMMA identifier */
      case 893: /* granteeList ::= granteeList COMMA identifier */ yytestcase(yyruleno==893);
#line 6135 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-2].minor.yy1134->append(yymsp[0].minor.yy1118);
		yygotominor.yy1134 = yymsp[-2].minor.yy1134;
	  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 14324 "../LemonSrc/SQLParserL.c"
        break;
      case 894: /* revokeStatement ::= REVOKE roles FROM granteeList */
#line 6162 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1256 = new RevokeStatement(yymsp[-2].minor.yy1134, yymsp[0].minor.yy1134);
	  yy_destructor(yypParser,259,&yymsp[-3].minor);
  yy_destructor(yypParser,76,&yymsp[-1].minor);
}
#line 14333 "../LemonSrc/SQLParserL.c"
        break;
      case 895: /* explainStatement ::= EXPLAIN explainOption sqlStatement */
#line 6173 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1045 = new ExplainStatement(yymsp[0].minor.yy934, yymsp[-1].minor.yy1289);
	  yy_destructor(yypParser,260,&yymsp[-2].minor);
}
#line 14341 "../LemonSrc/SQLParserL.c"
        break;
      case 896: /* explainOption ::= hint */
#line 6183 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1289 = new ExplainOption(0, yymsp[0].minor.yy858);
	}
#line 14348 "../LemonSrc/SQLParserL.c"
        break;
      case 897: /* explainOption ::= explainOptionValueList hint */
#line 6187 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1289 = new ExplainOption(yymsp[-1].minor.yy360, yymsp[0].minor.yy858);
	}
#line 14355 "../LemonSrc/SQLParserL.c"
        break;
      case 898: /* explainOptionValueList ::= explainOptionValue */
#line 6193 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy360 = yymsp[0].minor.yy360;
	}
#line 14362 "../LemonSrc/SQLParserL.c"
        break;
      case 899: /* explainOptionValueList ::= explainOptionValueList explainOptionValue */
#line 6197 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy360 = yymsp[-1].minor.yy360 | yymsp[0].minor.yy360;
	}
#line 14369 "../LemonSrc/SQLParserL.c"
        break;
      case 900: /* explainOptionValue ::= EXECUTE */
#line 6206 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy360 = ExplainOption::Execute;   yy_destructor(yypParser,261,&yymsp[0].minor);
}
#line 14375 "../LemonSrc/SQLParserL.c"
        break;
      case 901: /* explainOptionValue ::= NO EXECUTE */
#line 6208 "../LemonSrc/SQLParserL.lemon"
{ yygotominor.yy360 = ExplainOption::None;   yy_destructor(yypParser,214,&yymsp[-1].minor);
  yy_destructor(yypParser,261,&yymsp[0].minor);
}
#line 14382 "../LemonSrc/SQLParserL.c"
        break;
      case 902: /* startExplainStatement ::= START EXPLAIN explainOption */
#line 6217 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy555 = new StartExplainStatement(yymsp[0].minor.yy1289);
	  yy_destructor(yypParser,154,&yymsp[-2].minor);
  yy_destructor(yypParser,260,&yymsp[-1].minor);
}
#line 14391 "../LemonSrc/SQLParserL.c"
        break;
      case 903: /* endExplainStatement ::= END EXPLAIN */
#line 6228 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy232 = new EndExplainStatement;
	  yy_destructor(yypParser,140,&yymsp[-1].minor);
  yy_destructor(yypParser,260,&yymsp[0].minor);
}
#line 14400 "../LemonSrc/SQLParserL.c"
        break;
      case 904: /* cascadeDefinition ::= CREATE CASCADE cascadeName ON hostName portNumber optionalIdentifier */
#line 6239 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy720 = new CascadeDefinition(yymsp[-4].minor.yy1118, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1118);
	  yy_destructor(yypParser,178,&yymsp[-6].minor);
  yy_destructor(yypParser,250,&yymsp[-5].minor);
  yy_destructor(yypParser,12,&yymsp[-3].minor);
}
#line 14410 "../LemonSrc/SQLParserL.c"
        break;
      case 905: /* optionalIdentifier ::= */
#line 6246 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1118 = 0;
	}
#line 14417 "../LemonSrc/SQLParserL.c"
        break;
      case 907: /* alterCascadeStatement ::= ALTER CASCADE cascadeName TO hostName portNumber optionalIdentifier */
#line 6262 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy496 = new AlterCascadeStatement(yymsp[-4].minor.yy1118, yymsp[-2].minor.yy1172, yymsp[-1].minor.yy1172, yymsp[0].minor.yy1118);
	  yy_destructor(yypParser,188,&yymsp[-6].minor);
  yy_destructor(yypParser,250,&yymsp[-5].minor);
  yy_destructor(yypParser,72,&yymsp[-3].minor);
}
#line 14427 "../LemonSrc/SQLParserL.c"
        break;
      case 908: /* dropCascadeStatement ::= DROP CASCADE cascadeName optionalIfExists */
#line 6273 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1161 = new DropCascadeStatement(yymsp[-1].minor.yy1118, yymsp[0].minor.yy937);
	  yy_destructor(yypParser,187,&yymsp[-3].minor);
  yy_destructor(yypParser,250,&yymsp[-2].minor);
}
#line 14436 "../LemonSrc/SQLParserL.c"
        break;
      case 912: /* partitionDefinition ::= CREATE optionalPartitionCategory PARTITION ON tableName BY functionName LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS */
#line 6314 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy726 = new PartitionDefinition(yymsp[-5].minor.yy1118, yymsp[-3].minor.yy1118, yymsp[-1].minor.yy1234, yymsp[-8].minor.yy648);
	  yy_destructor(yypParser,178,&yymsp[-9].minor);
  yy_destructor(yypParser,88,&yymsp[-7].minor);
  yy_destructor(yypParser,12,&yymsp[-6].minor);
  yy_destructor(yypParser,65,&yymsp[-4].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 14449 "../LemonSrc/SQLParserL.c"
        break;
      case 913: /* optionalPartitionCategory ::= */
#line 6322 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy648 = PartitionDefinition::Category::Normal;
	}
#line 14456 "../LemonSrc/SQLParserL.c"
        break;
      case 914: /* optionalPartitionCategory ::= READ ONLY */
#line 6326 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy648 = PartitionDefinition::Category::ReadOnly;
	  yy_destructor(yypParser,156,&yymsp[-1].minor);
  yy_destructor(yypParser,157,&yymsp[0].minor);
}
#line 14465 "../LemonSrc/SQLParserL.c"
        break;
      case 915: /* alterPartitionStatement ::= ALTER PARTITION ON tableName TO functionName LEFT_PARENTHESIS columnNameList RIGHT_PARENTHESIS */
#line 6337 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1246 = new AlterPartitionStatement(yymsp[-5].minor.yy1118, yymsp[-3].minor.yy1118, yymsp[-1].minor.yy1234);
	  yy_destructor(yypParser,188,&yymsp[-8].minor);
  yy_destructor(yypParser,88,&yymsp[-7].minor);
  yy_destructor(yypParser,12,&yymsp[-6].minor);
  yy_destructor(yypParser,72,&yymsp[-4].minor);
  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 14478 "../LemonSrc/SQLParserL.c"
        break;
      case 916: /* dropPartitionStatement ::= DROP PARTITION ON tableName optionalIfExists */
#line 6348 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1071 = new DropPartitionStatement(yymsp[-1].minor.yy1118, yymsp[0].minor.yy937);
	  yy_destructor(yypParser,187,&yymsp[-4].minor);
  yy_destructor(yypParser,88,&yymsp[-3].minor);
  yy_destructor(yypParser,12,&yymsp[-2].minor);
}
#line 14488 "../LemonSrc/SQLParserL.c"
        break;
      case 917: /* functionDefinition ::= CREATE FUNCTION functionName parameterSpecification returnsClause routineBody */
#line 6363 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy862 = new FunctionDefinition(yymsp[-3].minor.yy1118, yymsp[-2].minor.yy1075, yymsp[-1].minor.yy407, yymsp[0].minor.yy891);
	  yy_destructor(yypParser,178,&yymsp[-5].minor);
  yy_destructor(yypParser,117,&yymsp[-4].minor);
}
#line 14497 "../LemonSrc/SQLParserL.c"
        break;
      case 918: /* dropFunctionStatement ::= DROP FUNCTION functionName optionalIfExists */
#line 6374 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy371 = new DropFunctionStatement(yymsp[-1].minor.yy1118, yymsp[0].minor.yy937);
	  yy_destructor(yypParser,187,&yymsp[-3].minor);
  yy_destructor(yypParser,117,&yymsp[-2].minor);
}
#line 14506 "../LemonSrc/SQLParserL.c"
        break;
      case 920: /* parameterSpecification ::= LEFT_PARENTHESIS parameterDeclarationList RIGHT_PARENTHESIS */
#line 6394 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1075 = yymsp[-1].minor.yy1075;
	  yy_destructor(yypParser,66,&yymsp[-2].minor);
  yy_destructor(yypParser,67,&yymsp[0].minor);
}
#line 14515 "../LemonSrc/SQLParserL.c"
        break;
      case 921: /* parameterDeclarationList ::= parameterDeclaration */
#line 6404 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1075 = new ParameterDeclarationList(yymsp[0].minor.yy1010);
	}
#line 14522 "../LemonSrc/SQLParserL.c"
        break;
      case 922: /* parameterDeclarationList ::= parameterDeclarationList COMMA parameterDeclaration */
#line 6409 "../LemonSrc/SQLParserL.lemon"
{
		yymsp[-2].minor.yy1075->append(yymsp[0].minor.yy1010);
		yygotominor.yy1075 = yymsp[-2].minor.yy1075;
	  yy_destructor(yypParser,13,&yymsp[-1].minor);
}
#line 14531 "../LemonSrc/SQLParserL.c"
        break;
      case 923: /* parameterDeclaration ::= parameterName parameterType */
#line 6420 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1010 = new ParameterDeclaration(yymsp[-1].minor.yy1118, *yymsp[0].minor.yy1194);
		delete yymsp[0].minor.yy1194;
	}
#line 14539 "../LemonSrc/SQLParserL.c"
        break;
      case 925: /* parameterType ::= dataType */
      case 927: /* returnsDataType ::= dataType */ yytestcase(yyruleno==927);
#line 6439 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy1194 = yymsp[0].minor.yy1194;
	}
#line 14547 "../LemonSrc/SQLParserL.c"
        break;
      case 926: /* returnsClause ::= RETURNS returnsDataType */
#line 6449 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy407 = new ReturnsClause(*yymsp[0].minor.yy1194);
		delete yymsp[0].minor.yy1194;
	  yy_destructor(yypParser,262,&yymsp[-1].minor);
}
#line 14556 "../LemonSrc/SQLParserL.c"
        break;
      case 928: /* routineBody ::= routineStatement */
#line 6468 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy891 = new RoutineBody(yymsp[0].minor.yy934);
	}
#line 14563 "../LemonSrc/SQLParserL.c"
        break;
      case 929: /* routineStatement ::= returnStatement */
#line 6478 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy934 = yymsp[0].minor.yy592;
	}
#line 14570 "../LemonSrc/SQLParserL.c"
        break;
      case 930: /* returnStatement ::= RETURN nonPredicateValueExpression */
#line 6488 "../LemonSrc/SQLParserL.lemon"
{
		yygotominor.yy592 = new ReturnStatement(yymsp[0].minor.yy1172);
	  yy_destructor(yypParser,263,&yymsp[-1].minor);
}
#line 14578 "../LemonSrc/SQLParserL.c"
        break;
      default:
      /* (0) start ::= sqlStatementList */ yytestcase(yyruleno==0);
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  SQLParserEngineARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
#line 73 "../LemonSrc/SQLParserL.lemon"

	if (pParser->getState() != Statement::SQLParser::PARSE_NO_TEXT) {
		pParser->setState(Statement::SQLParser::PARSE_SYNTAX_ERROR);
	}
#line 14632 "../LemonSrc/SQLParserL.c"
  SQLParserEngineARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  SQLParserEngineARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 78 "../LemonSrc/SQLParserL.lemon"

	if (pParser->getState() != Statement::SQLParser::PARSE_NO_TEXT) {
		pParser->setState(Statement::SQLParser::PARSE_SYNTAX_ERROR);
		ModUnicodeOstrStream& cMessage = pParser->getMessage();
		cMessage << " near token ";
#ifndef NDEBUG
		cMessage << yyTokenName[yymajor];
#else
		cMessage << yymajor;
#endif

		if (TOKEN && TOKEN->getToken() != 0)
		{
			if (TOKEN->getTail() > TOKEN->getHead())
			{
				ModUnicodeString strToken(
					TOKEN->getHead(),
					static_cast<ModSize>(TOKEN->getTail() - TOKEN->getHead()));
				cMessage << " \"" << strToken << "\"";
				SydMessage << "SQL syntax error:" << strToken << ModEndl;
			} else {
				SydMessage << "SQL syntax error" << ModEndl;
			}
		}
		else
		{
			SydMessage << "SQL syntax error: unknown token" << ModEndl;
		}
	}
#line 14677 "../LemonSrc/SQLParserL.c"
  SQLParserEngineARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  SQLParserEngineARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
#line 72 "../LemonSrc/SQLParserL.lemon"
 pParser->setState(Statement::SQLParser::PARSE_ACCEPT); 
#line 14698 "../LemonSrc/SQLParserL.c"
  SQLParserEngineARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "SQLParserEngineAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void SQLParserEngine(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  SQLParserEngineTOKENTYPE yyminor       /* The value for the token */
  SQLParserEngineARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  SQLParserEngineARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor,yyminorunion);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;
      
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
