// -*-Mode: C++; tab-width: 4; c-basic-offset: 4;-*-
// vi:set ts=4 sw=4:
//
// DatabaseMap.cpp -- スキーマオブジェクトのマップを表すクラス関連の関数定義
// 
// Copyright (c) 2002, 2007, 2023 Ricoh Company, Ltd.
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//     http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// 

namespace {
const char srcFile[] = __FILE__;
const char moduleName[] = "Schema";
}

#include "SyDefault.h"
#include "SyReinterpretCast.h"

#include "Schema/DatabaseMap.h"

namespace {

	// DatabaseMapのコンストラクターに与えるパラメーター
	const ModSize _databaseMapSize = 3;
	const ModBoolean _databaseMapEnableLink = ModTrue; // Iterationするので
	bool _databaseUseView = false; // 要求されるまでVectorを作らない
	bool _databaseUseCache = false; // Cacheには入れない
}

_SYDNEY_USING
_SYDNEY_SCHEMA_USING

//	FUNCTION public
//	Schema::DatabaseMap::DatabaseMap -- コンストラクター
//
//	NOTES
//
//	ARGUMENTS
//		なし
//
//	RETURN
//		なし
//
//	EXCEPTIONS

DatabaseMap::
DatabaseMap()
	: ObjectMap<Database, DatabasePointer>(_databaseMapSize, _databaseMapEnableLink, _databaseUseView, _databaseUseCache)
{
}

//	FUNCTION public
//	Schema::ObjectMap::reset -- 中身を初期化する
//
//	NOTES
//
//	ARGUMENTS
//		Database& cDatabase_
//
//	RETURN
//		なし
//
//	EXCEPTIONS

void
DatabaseMap::
reset(Database& cDatabase_)
{
	// Databaseはいきなりすべて空にしてよい
	reset();
}

//
// Copyright (c) 2002, 2007, 2023 Ricoh Company, Ltd.
// All rights reserved.
//
