// -*-Mode: C++; tab-width: 4; c-basic-offset: 4;-*-
// vi:set ts=4 sw=4:
//
// Execution/Parallel/OpenMP.h --
// 
// Copyright (c) 2011, 2023 Ricoh Company, Ltd.
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//     http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// 

#ifndef __SYDNEY_EXECUTION_PARALLEL_OPENMP_H
#define __SYDNEY_EXECUTION_PARALLEL_OPENMP_H

#include "Execution/Parallel/Module.h"

#include "Execution/Interface/IParallel.h"

_SYDNEY_BEGIN
_SYDNEY_EXECUTION_BEGIN
_SYDNEY_EXECUTION_PARALLEL_BEGIN

////////////////////////////////////
//	CLASS
//	Execution::Parallel::OpenMP -- openMP execution
//
//	NOTES

class OpenMP
	: public Interface::IParallel
{
public:
	typedef Interface::IParallel Super;
	typedef OpenMP This;

	// constructor
	static This* create(Interface::IProgram& cProgram_,
						Interface::IIterator* pIterator_);

	// destructor
	virtual ~OpenMP() {}

	// for serialize
	static This* getInstance(int iCategory_);

protected:
	// constructor
	OpenMP() : Super() {}

private:
};


_SYDNEY_EXECUTION_PARALLEL_END
_SYDNEY_EXECUTION_END
_SYDNEY_END

#endif // __SYDNEY_EXECUTION_PARALLEL_OPENMP_H

//
//	Copyright (c) 2011, 2023 Ricoh Company, Ltd.
//	All rights reserved.
//
