// -*-Mode: C++; tab-width: 4; c-basic-offset: 4;-*-
// vi:set ts=4 sw=4:
//
// BatchList.h --
// 
// Copyright (c) 2008, 2023 Ricoh Company, Ltd.
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//     http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// 

#ifndef __SYDNEY_INVERTED_BATCHLIST_H
#define __SYDNEY_INVERTED_BATCHLIST_H

#include "Inverted/Module.h"
#include "Inverted/LeafPage.h"
#include "Inverted/AutoPointer.h"
#include "Inverted/BatchBaseList.h"

_SYDNEY_BEGIN
_SYDNEY_INVERTED_BEGIN

class BatchListMap;
class InvertedUnit;

//
//	CLASS
//	Inverted::BatchList --
//
//	NOTES
//
//
class BatchList : public BatchBaseList
{
public:
	// コンストラクタ(1)
	BatchList(InvertedUnit& cInvertedUnit_,
			  BatchListMap& cBatchListMap_,
			  const ModUnicodeChar* pszKey_);
	// コンストラクタ(2)
	BatchList(InvertedUnit& cInvertedUnit_, LeafPage::Area* pArea_);
	// デストラクタ
	virtual ~BatchList();

	// 位置情報リストを格納していないか
	bool isNolocation() const { return false; }
	// TFを格納していないか (TFを格納しない時は位置情報リストも格納しない)
	bool isNoTF() const { return false; }
	
	// イテレータを得る -- 得られたインスタンスは呼び出し元で開放する
	InvertedIterator* begin() const;

	// エリアを得る
	LeafPage::Area* getArea() { return m_pArea; }
	const LeafPage::Area* getArea() const { return m_pArea; }

private:
	// バッチリストマップを取得する
	BatchListMap* getMap() { return m_pMap; }
	
	// エリアを設定する
	void setArea(LeafPage::Area* pArea_) { m_pArea = pArea_; }
	
	// バッチリストマップ
	BatchListMap* m_pMap;

	// エリア
	AutoPointer<LeafPage::Area> m_pArea;
};

_SYDNEY_INVERTED_END
_SYDNEY_END

#endif //__SYDNEY_INVERTED_BATCHLIST_H

//
//	Copyright (c) 2008, 2023 Ricoh Company, Ltd.
//	All rights reserved.
//
