// -*-Mode: C++; tab-width: 4; c-basic-offset: 4;-*-
// vi:set ts=4 sw=4:
//
// InvertedFile.cpp --
// 
// Copyright (c) 2010, 2023 Ricoh Company, Ltd.
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//     http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// 

namespace {
const char srcFile[] = __FILE__;
const char moduleName[] = "FullText2";
}

#include "SyDefault.h"
#include "SyReinterpretCast.h"
#include "FullText2/InvertedFile.h"
#include "FullText2/FileID.h"

_SYDNEY_USING
_SYDNEY_FULLTEXT2_USING

namespace
{
}

//
//  FUNCTION public
//  FullText2::InvertedFile::InvertedFile -- コンストラクタ
//
//  NOTES
//
//  ARGUMENTS
//	FullText2::FileID& cFileID_
//		ファイルID
//  const Os::Path& cPath_
//		パス
//
//  RETURN
//  なし
//
//  EXCEPTIONS
//  なし
//
InvertedFile::InvertedFile(FileID& cFileID_, const Os::Path& cPath_)
	: MultiFile(cPath_), m_cFileID(cFileID_)
{
	// 高速化のためのキャッシュ
	m_bWordIndex = (cFileID_.getIndexingType() == IndexingType::Word);
	m_bNolocation = cFileID_.isNolocation();
	m_bNoTF = cFileID_.isNoTF();
}

//
//  FUNCTION public
//  FullText2::InvertedFile::~InvertedFile -- デストラクタ
//
//  NOTES
//
//  ARGUMENTS
//  なし
//
//  RETURN
//  なし
//
//  EXCEPTIONS
//  なし
//
InvertedFile::~InvertedFile()
{
}

//
//	FUNCTION protected
//	FullText2::InvertedFile::getLockName -- ロック名を得る
//
//	NOTES
//
//	ARGUMETNS
//	なし
//
//	RETURN
//	const Lock::FileName&
//		このファイルのロック名
//
//	EXCEPTIONS
//
const Lock::FileName&
InvertedFile::getLockName() const
{
	return m_cFileID.getLockName();
}

//
//  Copyright (c) 2010, 2023 Ricoh Company, Ltd.
//  All rights reserved.
//
