// -*-Mode: C++; tab-width: 4; c-basic-offset: 4;-*-
// vi:set ts=4 sw=4:
//
// FieldType.h --
// 
// Copyright (c) 2010, 2011, 2023 Ricoh Company, Ltd.
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//     http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// 
#ifndef __SYDNEY_FULLTEXT2_FIELDTYPE_H
#define __SYDNEY_FULLTEXT2_FIELDTYPE_H

#include "FullText2/Module.h"

_SYDNEY_BEGIN
_SYDNEY_FULLTEXT2_BEGIN

namespace FieldType
{
	// 全文で取得できるフィールド
	// Plan が設定してくる順番になっている
	//
	//【注意】
	//	複合索引、言語情報、スコア調整カラムなどがあると、
	//	RowID以上の数値はシフトする
	
	enum Value
	{
		Unknown = -1,
		
		Key = 0,			// キー(文字列)
		RowID,				// ROWID
		
		Last
	};
}

_SYDNEY_FULLTEXT2_END
_SYDNEY_END

#endif //__SYDNEY_FULLTEXT2_FIELDTYPE_H

//
//	Copyright (c) 2010, 2011, 2023 Ricoh Company, Ltd.
//	All rights reserved.
//
