// -*-Mode: C++; tab-width: 4; c-basic-offset: 4;-*-
// vi:set ts=4 sw=4:
//
// DoSearch.h --
// 
// Copyright (c) 2010, 2011, 2023 Ricoh Company, Ltd.
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//     http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// 

#ifndef __SYDNEY_FULLTEXT2_DOSEARCH_H
#define __SYDNEY_FULLTEXT2_DOSEARCH_H

#include "FullText2/Module.h"
#include "FullText2/Types.h"
#include "Utility/OpenMP.h"

_SYDNEY_BEGIN
_SYDNEY_FULLTEXT2_BEGIN

//
//	CLASS
//	FullText2::DoSearch -- 
//
//	NOTES
//
class DoSearch : public Utility::OpenMP
{
public:
	// コンストラクタ
	DoSearch();
	// デストラクタ
	virtual ~DoSearch();

protected:
	//
	// 以下のメソッドは、prepare(), parallel(), dispose() 内でのみ利用可能
	//
	
	// 実行スレッド数を得る
	ModSize getExecuteThreadSize(DocumentID maxID_);
};

_SYDNEY_FULLTEXT2_END
_SYDNEY_END

#endif //__SYDNEY_FULLTEXT2_DOSEARCH_H

//
//  Copyright (c) 2010, 2011, 2023 Ricoh Company, Ltd.
//	All rights reserved.
//
