// -*-Mode: C++; tab-width: 4; c-basic-offset: 4;-*-
// vi:set ts=4 sw=4:
//
// PageVector.h -- ページベクター関連のヘッダファイル
// 
// Copyright (c) 2001, 2003, 2023 Ricoh Company, Ltd.
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//     http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// 

#ifndef __SYDNEY_BTREE_PAGEVECTOR_H
#define __SYDNEY_BTREE_PAGEVECTOR_H

#include "Btree/Module.h"

#include "Common/Common.h"
#include "PhysicalFile/Types.h"

#include "ModVector.h"

_SYDNEY_BEGIN

namespace PhysicalFile
{
class Page;
}

_SYDNEY_BTREE_BEGIN

//
//	TYPEDEF
//	Btree::PageVector --
//		物理ページ記述子をキャッシュするためのベクターのデータ型
//
//	NOTES
//	物理ページ記述子をキャッシュするためのベクターのデータ型。
//
typedef	ModVector<PhysicalFile::Page*>	PageVector;

//
//	TYPEDEF
//	Btree::PageIDVector --
//		物理ページ識別子をキャッシュするためのベクターのデータ型
//
//	NOTES
//	物理ページ識別子をキャッシュするためのベクターのデータ型。
//
typedef ModVector<PhysicalFile::PageID>	PageIDVector;

_SYDNEY_BTREE_END
_SYDNEY_END

#endif // __SYDNEY_BTREE_PAGEVECTOR_H

//
//	Copyright (c) 2001, 2003, 2023 Ricoh Company, Ltd.
//	All rights reserved.
//
