# DolphinScheduler任务参数附录

`DolphinScheduler`任务插件有一些公共参数，我们将这些公共参数列在文档中供您查阅。每种任务都有如下的所有或者**部分**默认参数：

## 默认任务参数

| **任务参数** |                                                                **描述**                                                                |
|----------|--------------------------------------------------------------------------------------------------------------------------------------|
| 任务名称     | 任务的名称，同一个工作流定义中的节点名称不能重复。                                                                                                            |
| 运行标志     | 标识这个节点是否需要调度执行，如果不需要执行，可以打开禁止执行开关。                                                                                                   |
| 缓存执行     | 标识这个节点是否需要进行缓存，如果缓存，则对于相同标识（相同任务版本，相同任务定义，相同参数传入）的任务进行缓存，运行时若已经存在缓存过的任务时，不在重复执行，直接复用结果。                                              |
| 描述       | 当前节点的功能描述。                                                                                                                           |
| 任务优先级    | worker线程数不足时，根据优先级从高到低依次执行任务，优先级一样时根据先到先得原则执行。                                                                                       |
| Worker分组 | 设置分组后，任务会被分配给worker组的机器机执行。若选择Default，则会随机选择一个worker执行。                                                                              |
| 任务组名称    | 任务资源组，未配置则不生效。                                                                                                                       |
| 组内优先级    | 一个任务组内此任务的优先级。                                                                                                                       |
| 环境名称     | 配置任务执行的环境。                                                                                                                           |
| 失败重试次数   | 任务失败重新提交的次数，可以在下拉菜单中选择或者手动填充。                                                                                                        |
| 失败重试间隔   | 任务失败重新提交任务的时间间隔，可以在下拉菜单中选择或者手动填充。                                                                                                    |
| CPU 配额   | 为执行的任务分配指定的CPU时间配额，单位为百分比，默认-1代表不限制，例如1个核心的CPU满载是100%，16个核心的是1600%。 [task.resource.limit.state](../../architecture/configuration.md) |
| 最大内存     | 为执行的任务分配指定的内存大小，超过会触发OOM被Kill同时不会进行自动重试，单位MB，默认-1代表不限制。该功能由 [task.resource.limit.state](../../architecture/configuration.md) 控制。     |
| 超时告警     | 设置超时告警、超时失败。当任务超过"超时时长"后，会发送告警邮件并且任务执行失败。该功能由 [task.resource.limit.state](../../architecture/configuration.md) 控制。                   |
| 资源       | 任务执行时所需资源文件                                                                                                                          |
| 前置任务     | 设置当前任务的前置（上游）任务。                                                                                                                     |
| 延时执行时间   | 任务延迟执行的时间，以分为单位                                                                                                                      |

