<?php
	header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html prefix="og: http://ogp.me/ns#">
<html lang="pt">
<head>
	<meta charset="utf-8">
	<meta id="viewport" name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">
	<!-- Global site tag (gtag.js) - Google Analytics -->
	<script async src="https://www.googletagmanager.com/gtag/js?id=UA-122228703-1"></script>
	<script>
	  window.dataLayer = window.dataLayer || [];
	  function gtag(){dataLayer.push(arguments);}
	  gtag('js', new Date());

	  gtag('config', 'UA-122228703-1');
	</script>
	<meta height="device-height">
	<title>Seguro Saúde para Empresas</title>
	<!-- SCHEMA.ORG -->
	<script type="application/ld+json">
      {
        "@context": "http://schema.org",
        "@type": "Organization",
        "url": "https://agatamacsaude.com.br",
        "logo": "https://agatamacsaude.com.br/assets/img/common/logo.png",
        "description": "Agata Mac - Soluções em Planos de Saúde e Seguro de Saúde para Empresas | Seguro de Saúde Empresarial, Planos de Seguro Saúde Corporativo (PJ) | Consultoria e Assessoria para Empresas e departamentos de RH",
        "additionalType": "http://www.productontology.org/doc/Health_insurance_companies",
        "telephone" : "+55-11-4302-6044",
        "email" : "contato@agatamacsaude.com.br",
        "name" : "Agata Mac Saúde",
        "alternateName" : "Agata Mac | Seguro Saúde para Empresas",
        "address" : {
          "@type" : "PostalAddress",
          "streetAddress" : "Alameda Grajaú, 129, 8º andar, conjunto 809 – Alphaville",
          "addressLocality" : "Barueri",
          "addressRegion" : "São Paulo",
          "postalCode" : "06454-050"
        },
        "sameAs" : [ "https://www.facebook.com/agatamacsaude" ],
        "contactPoint": [{
          "@type": "ContactPoint",
          "telephone": "+55-11-4302-6044",
          "contactType": "customer service"
        }]
      }
    </script>
	<!-- META DATA OG -->
    <meta property="og:site_name" content="Agata Mac | Seguro Saúde para Empresas">
    <meta property="og:title" content="Agata Mac Saúde">
    <meta property="og:description" content="Agata Mac - Soluções em Planos de Saúde e Seguro de Saúde para Empresas | Seguro de Saúde Empresarial, Planos de Seguro Saúde Corporativo (PJ) | Consultoria e Assessoria para Empresas e departamentos de RH">
    <meta property="og:url" content="https://agatamacsaude.com.br">
    <meta property="og:locale" content="pt-BR">
    <meta property="og:type" content="website">
    <meta property="og:image" content="https://agatamacsaude.com.br/assets/img/common/logo.png">
    <meta property="og:image:alt" content="Agata Mac Seguro Saúde para Empresas">
    <meta property="og:image:url" content="https://agatamacsaude.com.br/assets/img/common/logo.png">
    <meta property="og:image:type" content="img/png">
    <!-- for ios 7 style, multi-resolution icon of 152x152 -->
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-barstyle" content="black-translucent">
    <link rel="apple-touch-icon" href="https://agatamacsaude.com.br/assets/img/common/logo.png">
    <!-- for Chrome on Android, multi-resolution icon of 196x196 -->
    <meta name="mobile-web-app-capable" content="yes">
    <link rel="shortcut icon" sizes="196x196" href="https://agatamacsaude.com.br/assets/img/common/logo.png">
	<!-- META DATA -->
	<meta name="title" content="Agata Mac | Seguro de Saúde para Empresas">
	<meta name="author" content="Djament Comunicação">
	<meta name="description" content="Agata Mac - Soluções em Planos de Saúde e Seguro de Saúde para Empresas | Seguro de Saúde Empresarial, Planos de Seguro Saúde Corporativo (PJ) | Consultoria e Assessoria para Empresas e departamentos de RH">
	<meta name="keywords" content="plano de saúde para empresa, seguro de saúde para empresa, seguro saúde pj, plano de saúde corporativo, seguros para empresa, consultoria em seguros">
	<meta name="robots" content="index,follow">
	<meta name="theme-color" content="#0085c4">
	<meta name="reply-to" content="contato@agatamacsaude.com.br">
	<link defer ="defer" rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
	<script defer="defer" src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
	<script defer="defer" src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js" integrity="sha384-ZMP7rVo3mIykV+2+9J3UJ46jBk0WLaUAdn689aCwoqbBJiSnjAK/l8WvCWPIPm49" crossorigin="anonymous"></script>
	<script defer="defer" src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js" integrity="sha384-ChfqqxuZUCnJSK3+MXmPNIyE6ZbWh2IMqE241rYiqJxyMiZ6OW/JmZQ5stwEULTy" crossorigin="anonymous"></script>
	<link defer="defer" href="https://fonts.googleapis.com/css?family=Anton|Poiret+One|Raleway|Marcellus" rel="stylesheet">
	<link defer="defer" rel="stylesheet" href="https://use.fontawesome.com/releases/v5.2.0/css/all.css" integrity="sha384-hWVjflwFxL6sNzntih27bfxkr27PmbbK/iSvJ+a4+0owXq79v+lsFkW54bOGbiDQ" crossorigin="anonymous">
	<link rel="stylesheet" href="assets/css/style.min.css">
	<link rel="shortcut icon" sizes="196x196" href="https://agatamacsaude.com.br/favicon-agata-mac-32.ico">
</head>
<body>
	<!-- INÍCIO DOBRA 1 -->
	<header id="segurosaude-topo" class="container-fluid">
		<section class="row">
			<article class="col-12">
				<img src="assets/img/common/logo.png" alt="Agata Mac Saúde - Seguro Saúde PJ" title="Agata Mac Saúde | Especialista em Seguro Saúde para Empresas" width="90px" height="auto">
				<h2 id="agatamac">Agata Mac</h2>
				<h1>Especialistas em<br/><strong>Seguro Saúde para Empresas</strong></h1>
				<a title="Solicitar cotação de Seguro Saúde para sua empresa" rel="next" hreflang="pt" target="_self" href="#cotacao"><button>Solicitar Cotação</button></a>
			</article>
		</section>
	</header>
	<!-- FIM DOBRA 1 -->
	<!-- INÍCIO DOBRA 2 -->
	<main>
		<section class"row">
			<article id="intro" class="col-12">
				<h3>Seja qual for o objetivo, nós temos o melhor plano de saúde</h3>
			</article>
			<article id="vantagens" class="col-12">
				<h2>Vantagens</h2>
				<ul>
					<li><i class="fas fa-check-square"></i>Condições Exclusivas</li>
					<li><i class="fas fa-check-square"></i>Valores Competitivos</li>
					<li><i class="fas fa-check-square"></i>Suporte ao RH</li>
					<li><i class="fas fa-check-square"></i>Atendimento Humanizado</li>
					<li><i class="fas fa-check-square"></i>Planos de Saúde Flexíveis</li>
					<li><i class="fas fa-check-square"></i>Implantação de Benefícios</li>
					<li><i class="fas fa-check-square"></i>Cobertura Médica Nacional</li>
					<li><i class="fas fa-check-square"></i>Inúmeras opções de Convênios</li>
				</ul>
			</article>
			<article id="apresentacao" class="col-12">
				<h4>Descubra quais os <strong>planos de saúde</strong> mais adequados para sua empresa.</h4>
			</article>
		</section>
		<!-- FIM DOBRA 2 -->
		<!-- INÍCIO DOBRA 3 -->
		<section class="row">
			<article id="seguradoras" class="col-12">
				<h2>Nossas Seguradoras</h2>
					<div class="seguradoras" class="col-6 col-md-1">
						<img title="Seguradora de Saúde para Empresas operada pela Agata Mac Saúde" src="assets/img/seguradoras/allianz.jpg" alt="Seguradora Conveniada Allianz">
					</div>
					<div class="seguradoras" class="col-6 col-md-1">
						<img title="Seguradora de Saúde para Empresas operada pela Agata Mac Saúde" src="assets/img/seguradoras/amil.jpg" alt="Seguradora Conveniada Amil">
					</div>
					<br/ class="mobile-only">
					<div class="seguradoras" class="col-6 col-md-1">
						<img title="Seguradora de Saúde para Empresas operada pela Agata Mac Saúde" src="assets/img/seguradoras/bradesco.png" alt="Seguradora Conveniada Bradesco">
					</div>
					<div class="seguradoras" class="col-6 col-md-1">
						<img title="Seguradora de Saúde para Empresas operada pela Agata Mac Saúde" src="assets/img/seguradoras/notredame.png" alt="Seguradora Conveniada Notre Dame">
					</div>
					<br/>
					<div class="seguradoras" class="col-6 col-md-1">
						<img title="Seguradora de Saúde para Empresas operada pela Agata Mac Saúde" src="assets/img/seguradoras/onehealth.jpg" alt="Seguradora Conveniada One Health">
					</div>
					<div class="seguradoras" class="col-6 col-md-1">
						<img title="Seguradora de Saúde para Empresas operada pela Agata Mac Saúde" src="assets/img/seguradoras/portoseguro.jpg" alt="Seguradora Conveniada Porto Seguro">
					</div>
					<br/ class="mobile-only">
					<div class="seguradoras" class="col-6 col-md-1">
						<img title="Seguradora de Saúde para Empresas operada pela Agata Mac Saúde" src="assets/img/seguradoras/sompo.png" alt="Seguradora Conveniada Sompo">
					</div>
					<div class="seguradoras" class="col-6 col-md-1">
						<img title="Seguradora de Saúde para Empresas operada pela Agata Mac Saúde" src="assets/img/seguradoras/sulamerica.jpg" alt="Seguradora Conveniada SulAmérica">
					</div>
					<br/>
			</article>
		</section>
		<!-- FIM DOBRA 3 -->
	</main>
	<footer id="segurosaude-rodape" class="container-fluid">
		<section id="cotacao" class="row">
			<article class="col-12">
				<h5>Preencha o formulário a seguir:</h5>
				<form action="mensagem-enviada.php" method="post">
					<label for="nome">Nome do Contato*: </label><br/>
					<input type="text" id="nome" name="nome" required placeholder=" Insira o nome do responsável">
					<br/>
					<label for="empresa">Nome da Empresa*: </label><br/>
					<input type="text" id="empresa" name="empresa" required placeholder=" Insira o nome da empresa">
					<br/>
					<label for="email">Email de Contato*: </label><br/>
					<input type="email" id="email" name="email" required placeholder=" Insira o email de contato">
					<br/>
					<label for="tel">Telefone de Contato: </label><br/>
					<input type="number" id="tel" name="tel" placeholder=" Insira o telefone de contato">
					<br/>
					<label for="contatar">Como prefere ser contatado?</label><br/>
					<span class="clearfix"></span>
					<fieldset>
						<input type="radio" name="contatar" value="telefone"><p> Telefone</p>
	  					<input type="radio" name="contatar" value="email"><p> email</p>
	  				</fieldset>
	  				<br/>
	  				<span class="clearfix"></span>
					<label for="msg">Mensagem: </label><br/>
					<textarea name="msg" id="msg" cols="30" rows="10" resize="horizontal" placeholder=" Insira observações ou dúvidas"></textarea>
					<br/>
					<input type="submit" value="Enviar">
					<br/>
					<span class="clearfix"></span>
				</form>
			</article>
		</section>
	</footer>
</body>
</html>