# [![Djament](https://djament.com.br/favicons/favicon-32x32.png)](https://djament.com.br) Agata Mac | Landing Page
___
###### Desenvolvido por [Djament Comunicação] | [Marcelo Diament] em Agosto de 2018
###### Versão: 0.0.1 | [ver site] | [ver repositório]

### // Apresentação
Projeto desenvolvido para a captação de clientes para a seguradora [Agata Mac Saúde] através de anúncios no [GoogleAds] voltados a empresas que buscam reduzir custos com o seguro saúde de seus colaboradores.

---

### // Contextualização do Projeto

##### Objetivo:
Página de destino para anúncios no [GoogleAds] para a captação de *leads* (B2B).

##### Premissas:
- Fácil solicitação de cotações
-- Formulário breve com poucos campos obrigatórios
-- *Call to Action* (CTA) localizado na primeira dobra
- Navegação dinâmica e objetiva
-- *Single Page* com interação mínima
-- Textos breves, legíveis e diretos
- Design/Layout Responsivo
-- Media queries para dispositivos *mobile*, *mobile landscape*, *tablets* e *desktop*
-- Conteúdo adaptado para diferentes resoluções
- Aplicação de boas práticas de SEO
-- *Structured Data* (Schema.org - ld/json)
-- Meta Data
-- [OpenGraph] (Meta OG)


##### Desejáveis:
- Boa acessibiliadde
-- Fontes legíveis
-- Imagens com atributo *alt* setados
- Comunicar identidade do negócio
-- Redação
-- Uso de cores
-- Elementos de acordo com site institucional
- Expor maior diferencial (atendimento pessoal)
-- Figura humana e diversidade através da escolha da imagem
-- Confirmação de envio utilizando nome do contato e da empresa
-- Opção de escolher como se deseja receber o retorno

---

### // Tecnologia
O projeto faz uso de tecnologias básicas, visando melhor performance do código

##### Linguagens
- [HTML5]
- [CSS3]
- [PHP7]

##### Recursos Externos
- [PHPMailer] 5.2
- [BootStrap 4.1.3] (CSS/Js)
- [JQuery] 3.3.1
- [Google Fonts] ([Anton]/[Raleway]/[Marcellus]/[Poiret One])
- [Font Awesome] ([Check Square]/[Phone]/[Whatsapp]/[Envelope]/[Globe])
- [Google Analytics]


##### Organização dos Arquivos

Links referentes aos arquivos no [GitHub].

| Pasta | Arquivo |
| ------ | ------ |
| / | [**RAÍZ**][root] |
| / | [seguro-saude-para-empresa.php][index] |
| / | [mensagem-enviada.php][enviado] |
| / | [README.md][readme] |
| /assets | [**- ASSETS**][assets]|
| assets/class | [**-- PHPMAILER**][class] |
| assets/class | [class.phpmailer.php][phpmailer] |
| assets/class | [smtp.phpmailer.php][smtp] |
| /assets/css | [**-- CSS**][css] |
| /assets/css | [style.css][style] |
| /assets/css | [style.min.css][cssmin] |
| /assets/img | [**-- IMAGENS**][img] |
| /assets/img/common | [**--- IMAGENS GERAIS**][common] |
| /assets/img/common | [bg.png][bg] |
| /assets/img/common | [logo.png][logo] |
| /assets/img/common | [topo.jpg][topo] |
| /assets/img/seguradoras | [**--- IMAGENS SEGURADORAS**][seguradoras] |
| /assets/img/seguradoras | [allianz.jpg][allianz] |
| /assets/img/seguradoras | [amil.jpg][amil] |
| /assets/img/seguradoras | [bradesco.png][bradesco] |
| /assets/img/seguradoras | [notredame.png][notredame] |
| /assets/img/seguradoras | [onehealth.jpg][onehealth] |
| /assets/img/seguradoras | [portoseguro.jpg][portoseguro] |
| /assets/img/seguradoras | [sompo.png][sompo] |
| /assets/img/seguradoras | [sulamerica.jpg][sulamerica] |



**Sugestões, dúvidas e comentários são bem vindos, envie um [email] ou [comente por aqui][issue]!**

   [Marcelo Diament]: <https://github.com/Marcelo-Diament>
   [Djament Comunicação]: <https://djament.com.br>
   [Agata Mac Saúde]: <https://agatamacsaude.com.br>
   [email]: <mailto:contato@djament.com.br>
   [ver site]: <https://agatamacsaude.com.br/seguro-saude-para-empresa>
   [ver repositório]: <https://github.com/Djament/agatamac-lp-segurosaude>
   [root]: <https://github.com/Djament/agatamac-lp-segurosaude>
   [index]: <https://github.com/Djament/agatamac-lp-segurosaude/blob/master/seguro-saude-para-empresa.php>
   [enviado]: <https://github.com/Djament/agatamac-lp-segurosaude/blob/master/mensagem-enviada.php>
   [readme]: <https://github.com/Djament/agatamac-lp-segurosaude/blob/master/README.md>
   [assets]: <https://github.com/Djament/agatamac-lp-segurosaude/tree/master/assets>
   [class]: <https://github.com/Djament/agatamac-lp-segurosaude/tree/master/assets/class>
   [phpmailer]: <https://github.com/Djament/agatamac-lp-segurosaude/blob/master/assets/class/class.phpmailer.php>
   [smtp]: <https://github.com/Djament/agatamac-lp-segurosaude/blob/master/assets/class/class.smtp.php>
   [css]: <https://github.com/Djament/agatamac-lp-segurosaude/tree/master/assets/css>
   [style]: <https://github.com/Djament/agatamac-lp-segurosaude/blob/master/assets/css/style.css>
   [cssmin]: <https://github.com/Djament/agatamac-lp-segurosaude/blob/master/assets/css/style.min.css>
   [img]: <https://github.com/Djament/agatamac-lp-segurosaude/tree/master/assets/img>
   [common]: <https://github.com/Djament/agatamac-lp-segurosaude/tree/master/assets/img/common>
   [bg]: <https://github.com/Djament/agatamac-lp-segurosaude/blob/master/assets/img/common/bg.png>
   [logo]: <https://github.com/Djament/agatamac-lp-segurosaude/blob/master/assets/img/common/logo.png>
   [topo]: <https://github.com/Djament/agatamac-lp-segurosaude/blob/master/assets/img/common/topo.jpg>
   [seguradoras]: <https://github.com/Djament/agatamac-lp-segurosaude/tree/master/assets/img/seguradoras>
   [allianz]: <https://github.com/Djament/agatamac-lp-segurosaude/blob/master/assets/img/seguradoras/allianz.jpg>
   [amil]: <https://github.com/Djament/agatamac-lp-segurosaude/blob/master/assets/img/seguradoras/amil.jpg>
   [bradesco]: <https://github.com/Djament/agatamac-lp-segurosaude/blob/master/assets/img/seguradoras/bradesco.png>
   [notredame]: <https://github.com/Djament/agatamac-lp-segurosaude/blob/master/assets/img/seguradoras/notredame.png>
   [onehealth]: <https://github.com/Djament/agatamac-lp-segurosaude/blob/master/assets/img/seguradoras/onehealth.jpg>
   [portoseguro]: <https://github.com/Djament/agatamac-lp-segurosaude/blob/master/assets/img/seguradoras/portoseguro.jpg>
   [sompo]: <https://github.com/Djament/agatamac-lp-segurosaude/blob/master/assets/img/seguradoras/sompo.png>
   [sulamerica]: <https://github.com/Djament/agatamac-lp-segurosaude/blob/master/assets/img/seguradoras/sulamerica.jpg>
   [issue]: <https://github.com/Djament/agatamac-lp-segurosaude/issues/new>
   [GoogleAds]: <https://ads.google.com>
   [HTML5]: <https://www.w3.org/html/>
   [CSS3]: <https://www.w3.org/Style/CSS/>
   [PHP7]: <https://secure.php.net/>
   [PHPMailer]: <https://github.com/PHPMailer>
   [BootStrap 4.1.3]: <https://getbootstrap.com/docs/4.1/getting-started/introduction/>
   [Google Fonts]: <https://fonts.google.com/>
   [Anton]: <https://fonts.google.com/specimen/Anton>
   [Raleway]: <https://fonts.google.com/specimen/Raleway>
   [Marcellus]: <https://fonts.google.com/specimen/Marcellus>
   [Poiret One]: <https://fonts.google.com/specimen/Poiret+One>
   [Font Awesome]: <https://fontawesome.com/>
   [Check Square]: <https://fontawesome.com/icons/check-square?style=solid>
   [Phone]: <https://fontawesome.com/icons/phone?style=solid>
   [Whatsapp]: <https://fontawesome.com/icons/whatsapp?style=brands>
   [Envelope]: <https://fontawesome.com/icons/envelope?style=solid>
   [Glove]: <https://fontawesome.com/icons/globe?style=solid>
   [Google Analytics]: <https://analytics.google.com/analytics/web/>
   [OpenGraph]: <http://ogp.me/>
   [GitHub]: <https://github.com/>
   [JQuery]: <https://jquery.com/>
