/*
 * Copyright (c) 2015-2020, www.dibo.ltd (service@dibo.ltd).
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * <p>
 * https://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.diboot.file.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author diboot
 */
@Getter
@Setter
@ConfigurationProperties(prefix = "diboot.file")
public class FileProperties {

    /**
     * 文件存储路径
     */
    private String storageDirectory;

    private OSS oss;

    @Getter
    @Setter
    public static class OSS {

        private Aliyun aliyun;

        @Getter
        @Setter
        public static class Aliyun {
            private String endpoint;
            private String accessKeyId;
            private String accessKeySecret;
            private String bucketName;
            // 过期时间（单位：分钟）
            private long expiration = 30 * 365L * 24 * 60;
        }
    }
}
