-- create schema diboot_example collate utf8_general_ci;
-- 建表
CREATE TABLE `dictionary` (
    `id` varchar(32) NOT NULL  COMMENT 'ID',
    `parent_id` bigint unsigned NOT NULL COMMENT '父ID',
    `tenant_id` bigint NOT NULL DEFAULT 0 COMMENT '租户ID',
    `app_module`  varchar(50)   null comment '应用模块',
    `type` varchar(50) NOT NULL COMMENT '字典类型',
    `item_name` varchar(100) NOT NULL COMMENT '显示名',
    `item_value` varchar(100) DEFAULT NULL COMMENT '存储值',
    `description` varchar(100) DEFAULT NULL COMMENT '描述说明',
    `extdata` varchar(200) DEFAULT NULL COMMENT '扩展JSON',
    `sort_id` smallint NOT NULL DEFAULT '99' COMMENT '排序号',
    `is_editable` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否可改',
    `is_deletable` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否可删',
    `is_deleted` tinyint(1) NOT NULL DEFAULT '0' COMMENT '删除标记',
    `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8 COMMENT '数据字典';

create table department(
    id varchar(32) not null comment 'ID' primary key,
    parent_id varchar(32) default 0 not null comment '上级部门ID',
    org_id varchar(32) not null comment '单位ID',
    name varchar(50) not null comment '名称',
    extdata varchar(100) null comment '扩展字段',
    extjsonarr JSON null comment '扩展Json数组',
    extjsonobj JSON null comment '扩展json对象',
    `character` varchar(100) null comment '关键字',
    is_deleted tinyint(1) default 0 not null comment '已删除',
    create_time datetime default CURRENT_TIMESTAMP not null comment '创建时间'
) comment '部门' charset=utf8mb4;

create table organization
(
    id varchar(32)  comment 'ID' primary key,
    parent_id int default 0 not null comment '上级单位ID',
    name varchar(100) not null comment '名称',
    telphone varchar(20) null comment '电话',
    manager_id varchar(32) not null comment '负责人id',
    is_deleted tinyint(1) default 0 not null comment '是否有效',
    create_time datetime default CURRENT_TIMESTAMP not null comment '创建时间'
) comment '单位' charset=utf8mb4;

create table role
(
    id varchar(32)  comment 'ID' primary key,
    name varchar(20) null,
    code varchar(20) null,
    is_deleted tinyint(1) default 0 null,
    create_time datetime default CURRENT_TIMESTAMP null comment '创建时间'
) comment '角色' charset=utf8mb4;

create table user
(
    id varchar(32)  comment 'ID' primary key,
    department_id varchar(32) default 0 not null,
    username varchar(20) null,
    gender varchar(20) null,
    birthdate date null,
    `character` varchar(100) null comment '关键字',
    is_deleted tinyint(1) default 0 null,
    create_time datetime default CURRENT_TIMESTAMP null comment '创建时间',
    local_datetime datetime null comment '本地时间'
) comment '用户' charset=utf8mb4;

create table user_role
(
    user_type varchar(20) not null comment '用户类型',
    user_id varchar(32) not null comment '用户ID',
    role_id varchar(32) not null comment '角色ID'
) comment '用户角色' charset=utf8mb4;

create table cc_city_info
(
    id          varchar(32)  primary key,
    parent_id   varchar(32)          null,
    region_id   varchar(32)          not null,
    region_name varchar(100) null
) comment '行政区划' charset=utf8mb4;

CREATE TABLE `db_goods_goods_info` (
   `goods_id` bigint DEFAULT NULL,
   `goods_nm` varchar(10) DEFAULT NULL,
   `create_ts` datetime default CURRENT_TIMESTAMP null,
   `update_ts`  datetime null,
   `is_del` tinyint DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `db_purchase_rel_plan_goods` (
  `rel_id` bigint DEFAULT NULL,
  `purchase_form_plan_id` bigint DEFAULT NULL,
  `goods_id` bigint DEFAULT NULL,
  `create_ts` datetime default CURRENT_TIMESTAMP null,
  `update_ts`  datetime null,
  `is_del` tinyint DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `db_purchase_form_plan` (
 `purchase_form_plan_id` bigint DEFAULT NULL,
 `name` varchar(100) DEFAULT NULL,
 `is_del` tinyint DEFAULT '0',
 `create_ts` datetime default CURRENT_TIMESTAMP null,
 `update_ts`  datetime null
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 上传文件表
CREATE TABLE test_upload_file (
  id varchar(32) NOT NULL COMMENT '编号' primary key,
  rel_obj_type varchar(50) DEFAULT NULL COMMENT '关联对象类',
  rel_obj_id varchar(32) DEFAULT NULL COMMENT '关联对象ID',
  rel_obj_field varchar(50) DEFAULT NULL COMMENT '关联对象属性名称',
  file_name varchar(100) NOT NULL COMMENT '文件名',
  storage_path varchar(200) NOT NULL COMMENT '存储路径',
  access_url varchar(200) NULL COMMENT '访问地址',
  file_type varchar(20) DEFAULT NULL COMMENT '文件类型',
  is_deleted   tinyint(1)  default 0                 not null comment '是否删除',
  create_time  datetime   default CURRENT_TIMESTAMP not null comment '创建时间'
) DEFAULT CHARSET=utf8 COMMENT='测试uuid';

CREATE TABLE `demo_test` (
 `id` varchar(32) NOT NULL  COMMENT 'ID' primary key,
 `is_deleted` tinyint(1) NOT NULL DEFAULT '0' COMMENT '删除标记',
 `name` varchar(100) NOT NULL COMMENT '名称',
 `age` bigint NOT NULL COMMENT '年龄',
 `id_card` varchar(100) DEFAULT NULL COMMENT '身份证号',
 `mobile_phone` varchar(100) DEFAULT NULL COMMENT '手机号',
 `email` varchar(100) DEFAULT NULL COMMENT '邮箱',
 `sex` varchar(100) DEFAULT NULL COMMENT '性别',
 `birthday` date DEFAULT NULL COMMENT '生日',
 `sss_img` varchar(200) DEFAULT NULL COMMENT '单图片',
 `mmm_img` varchar(1000) DEFAULT NULL COMMENT '多图片',
 `data_file` varchar(1000) DEFAULT NULL COMMENT '数据文件',
 `file_test` varchar(200) DEFAULT NULL COMMENT '单文件',
 `create_by` bigint DEFAULT '0' COMMENT '创建人',
 `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
 `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间'
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Demo测试';

CREATE TABLE `demo_test_join` (
  `id` varchar(32) NOT NULL  COMMENT 'ID' primary key,
  `demo_test_id` bigint DEFAULT NULL COMMENT 'Demo测试',
  `name` varchar(100) DEFAULT NULL COMMENT '名称',
  `email` varchar(100) DEFAULT NULL COMMENT '邮箱',
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0' COMMENT '删除标记',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间'
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='关联测试';

create table customer
(
    id varchar(32) not null comment 'ID' primary key,
    realname varchar(50) not null comment '名称',
    cellphone varchar(50) not null comment '电话',
    extjsonarr JSON null comment '扩展json对象',
    is_deleted tinyint(1) default 0 not null comment '已删除',
    create_time datetime default CURRENT_TIMESTAMP not null comment '创建时间'
) comment '客户' charset=utf8mb4;

-- playground.region definition
CREATE TABLE `region` (
  `id` varchar(32) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(20) NOT NULL COMMENT '名称',
  `code` varchar(20) NOT NULL COMMENT '编码',
  `parent_id` varchar(32) NOT NULL COMMENT '父级',
  `parent_ids_path` varchar(200) NOT NULL COMMENT '父级path',
  `level` smallint NOT NULL DEFAULT '0' COMMENT '层级',
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0' COMMENT '删除标记',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='行政区划';

CREATE TABLE `problem` (
   `id` varchar(32) NOT NULL COMMENT 'ID',
   `title` varchar(20) DEFAULT NULL,
   `remark` varchar(500) DEFAULT NULL,
   `is_deleted` tinyint(1) DEFAULT '0',
   `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
   PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='问题';
CREATE TABLE `status_info` (
   `id` varchar(32) NOT NULL COMMENT 'ID',
   `user_id` varchar(32) DEFAULT NULL,
   `problem_id` varchar(32) DEFAULT NULL,
   `remark` varchar(500) DEFAULT NULL,
   `is_deleted` tinyint(1) DEFAULT '0',
   `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
   PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='问题状态';

-- 宠物及领养表，验证非id的多字段关联条件绑定
CREATE TABLE `mdl_pet` (
   `id` varchar(32) NOT NULL COMMENT '唯一标识',
   `category` varchar(20) DEFAULT NULL COMMENT '品类',
   `code` varchar(100) DEFAULT NULL COMMENT '编号',
   `remark` varchar(100) DEFAULT NULL COMMENT '备注',
   `is_deleted` tinyint NOT NULL DEFAULT '0' COMMENT '是否删除',
   `create_by` varchar(32) DEFAULT NULL COMMENT '创建人',
   `create_time` datetime DEFAULT NULL COMMENT '创建时间',
   `update_by` varchar(32) DEFAULT NULL COMMENT '更新人',
   `update_time` datetime DEFAULT NULL COMMENT '更新时间',
   PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='宠物';
CREATE TABLE `mdl_pet_adopt` (
     `id` varchar(32) NOT NULL COMMENT '唯一标识',
     `realname` varchar(100) DEFAULT NULL COMMENT '姓名',
     `pet_category` varchar(100) DEFAULT NULL COMMENT '宠物品类',
     `pet_code` varchar(100) DEFAULT NULL COMMENT '宠物编号',
     `remark` varchar(100) DEFAULT NULL COMMENT '备注',
     `is_deleted` tinyint NOT NULL DEFAULT '0' COMMENT '是否删除',
     `create_by` varchar(32) DEFAULT NULL COMMENT '创建人',
     `create_time` datetime DEFAULT NULL COMMENT '创建时间',
     `update_by` varchar(32) DEFAULT NULL COMMENT '更新人',
     `update_time` datetime DEFAULT NULL COMMENT '更新时间',
     PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='领养';

INSERT INTO customer (id, realname, cellphone, extjsonarr)
VALUES (10001, '张三', '13800001111', '["WEBSOCKET","EMAIL"]'), (10002, '李四', '13800002222', '["TEXT_MESSAGE"]');

-- 初始化样例数据
INSERT INTO department (id, parent_id, org_id, name, `character`, extjsonobj, extjsonarr)
VALUES (10001, 0, 100001, '产品部', 'WW', null, null), (10002, 10001, 100001, '研发组', '1001', null, null),
       (10003, 10001, 100001, '测试组', '[1001,1002]', '{"id": 1001, "name": "TEST"}', '[1001,1002]'), (10004, 10001, 100001, '市场部', '1001,1002', '{"id": 1001, "name": "TEST"}', '[1001,1002]'),
       (10005, 10003, 100001, '自动化测试', null, null, null), (10006, 10003, 100001, '功能测试', null, null, null);
INSERT INTO dictionary (id, parent_id, app_module, type, item_name, item_value) VALUES (1, 0, '', 'GENDER', '性别', null), (2, 1, '', 'GENDER', '男', 'M'), (3, 1, '', 'GENDER', '女', 'F');
INSERT INTO dictionary (id, parent_id, tenant_id, app_module, `type`, item_name, item_value, description, extdata, sort_id, is_editable, is_deletable)
VALUES(10050, 0, 0, NULL, 'MESSAGE_CHANNEL', '发送通道', NULL, 'message发送通道', NULL, 99, 1, 1),
      (10051, 10050, 0, NULL, 'MESSAGE_CHANNEL', '站内信', 'WEBSOCKET', NULL, NULL, 0, 1, 1),
      (10052, 10050, 0, NULL, 'MESSAGE_CHANNEL', '短信', 'TEXT_MESSAGE', NULL, NULL, 1, 1, 1),
      (10053, 10050, 0, NULL, 'MESSAGE_CHANNEL', '邮件', 'EMAIL', NULL, NULL, 2, 1, 1);
INSERT INTO organization (id, parent_id, name, telphone, manager_id) VALUES (100001, 0, '苏州帝博', '0512-62988949', 1001), (100002, 0, '成都帝博', '028-62988949', 1002);
INSERT INTO role (id, name, code) VALUES (101, '管理员', 'ADMIN'), (102, '操作员', 'OPERATOR');
INSERT INTO user (id, department_id, username, gender, `character`) VALUES (1001, 10002, '张三', 'M', 'test123456'), (1002, 10002, '李四', 'F', 'test123456,test234567'), (1003, 10001, '王五', 'M', 'WW');
INSERT INTO user_role (user_type, user_id, role_id) VALUES ('SysUser', 1001, 101),('SysUser', 1001, 102),('OrgUser', 1002, 102);
INSERT INTO cc_city_info (id, parent_id, region_id, region_name) VALUES (10000, 0, 10000, '江苏省'), (10010, 10000, 10010, '苏州市'), (10020, 10010, 10020, '园区');
INSERT INTO db_goods_goods_info (goods_id, goods_nm, is_del) VALUES(1001, 'abcde', 0), (1002, 'abcd', 0);
INSERT INTO db_purchase_rel_plan_goods(rel_id, purchase_form_plan_id, goods_id, is_del)VALUES(1, 1, 1001, 0), (2, 1, 1002, 0);
INSERT INTO db_purchase_form_plan(purchase_form_plan_id, name, is_del)VALUES(1, '5月份采购计划', 0);
INSERT INTO test_upload_file(id, rel_obj_type, rel_obj_id, file_name, access_url, storage_path)
VALUES ('test123456', 'IamUser', 1001, '123456.jpg', 'http://www.baidu.com', '/temp'),
       ('test234567', 'IamUser', 1001, '234567.jpg', 'http://www.baidu.com', '/temp');

INSERT INTO demo_test(id, is_deleted, name, age, id_card, mobile_phone, email, sex, birthday, sss_img, mmm_img, data_file, file_test, create_by)
VALUES(10000074, 0, '666', 666, 'kdt3kHX4lAEshODwXMaqAg==', 'dI7AKyanaPYiWL0c5CfuPQ==', 'kdt3kHX4lAEshODwXMaqAg==', NULL, NULL, NULL, NULL, NULL, NULL, 0),
      (10000075, 0, '1', 111, 'kBzIU3XgeowKFQnyeGZfZZHbd5B1+JQBLITg8FzGqgI=', 'AYdMZnNVJwYmpHh8VmC11A==', '5tEbe9Q9hti2Z0spAE5fsA==', NULL, NULL, NULL, NULL, NULL, NULL, 0);

INSERT INTO demo_test_join (id, demo_test_id, name, email)
VALUES(10000081, 10000074, '111', 'L9vrF7wJBKbbLRZChI33WA=='),
      (10000084, 10000074, '114', 'A2Y6CZ4tv0V7QxPbq9EYkg=='),
      (10000089, 10000075, '119', 'VVnnuR7fXzsIHCMilEsgLw=='),
      (10000091, 10000075, '112', 'BqAefnSadfixkCebXakUDg=='),
      (10000093, 10000075, '114', 'A2Y6CZ4tv0V7QxPbq9EYkg==');

INSERT INTO problem (id, title, remark, create_time)
VALUES  ('1', '问题1', '问题1秒杀失效', '2023-12-29 12:40:44'),
        ('2', '问题2', '问题2提款失败', '2023-12-29 12:40:44');

INSERT INTO status_info (id, user_id, problem_id, remark, create_time)
VALUES('1', '1001', '1', '状态备注1', '2023-12-29 12:42:14'),
      ('2', '1003', '2', '状态备注2', '2023-12-29 12:42:14');

INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('1','北京市','110000','0','1'),('2','北京城区','110100','1','2'),('3','东城区','110101','2','3'),('4','西城区','110102','2','3'),('5','朝阳区','110105','2','3'),('6','丰台区','110106','2','3'),('7','石景山区','110107','2','3'),('8','海淀区','110108','2','3'),('9','门头沟区','110109','2','3'),('10','房山区','110111','2','3'),('11','通州区','110112','2','3'),('12','顺义区','110113','2','3'),('13','昌平区','110114','2','3'),('14','大兴区','110115','2','3'),('15','怀柔区','110116','2','3'),('16','平谷区','110117','2','3'),('17','密云区','110118','2','3'),('18','延庆区','110119','2','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('19','天津市','120000','0','1'),('20','天津城区','120100','19','2'),('21','和平区','120101','20','3'),('22','河东区','120102','20','3'),('23','河西区','120103','20','3'),('24','南开区','120104','20','3'),('25','河北区','120105','20','3'),('26','红桥区','120106','20','3'),('27','东丽区','120110','20','3'),('28','西青区','120111','20','3'),('29','津南区','120112','20','3'),('30','北辰区','120113','20','3'),('31','武清区','120114','20','3'),('32','宝坻区','120115','20','3'),('33','滨海新区','120116','20','3'),('34','宁河区','120117','20','3'),('35','静海区','120118','20','3'),('36','蓟州区','120119','20','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('37','河北省','130000','0','1'),('38','石家庄市','130100','37','2'),('39','长安区','130102','38','3'),('40','桥西区','130104','38','3'),('41','新华区','130105','38','3'),('42','井陉矿区','130107','38','3'),('43','裕华区','130108','38','3'),('44','藁城区','130109','38','3'),('45','鹿泉区','130110','38','3'),('46','栾城区','130111','38','3'),('47','井陉县','130121','38','3'),('48','正定县','130123','38','3'),('49','行唐县','130125','38','3'),('50','灵寿县','130126','38','3'),('51','高邑县','130127','38','3'),('52','深泽县','130128','38','3'),('53','赞皇县','130129','38','3'),('54','无极县','130130','38','3'),('55','平山县','130131','38','3'),('56','元氏县','130132','38','3'),('57','赵县','130133','38','3'),('58','辛集市','130181','38','3'),('59','晋州市','130183','38','3'),('60','新乐市','130184','38','3'),('61','唐山市','130200','37','2'),('62','路南区','130202','61','3'),('63','路北区','130203','61','3'),('64','古冶区','130204','61','3'),('65','开平区','130205','61','3'),('66','丰南区','130207','61','3'),('67','丰润区','130208','61','3'),('68','曹妃甸区','130209','61','3'),('69','滦南县','130224','61','3'),('70','乐亭县','130225','61','3'),('71','迁西县','130227','61','3'),('72','玉田县','130229','61','3'),('73','遵化市','130281','61','3'),('74','迁安市','130283','61','3'),('75','滦州市','130284','61','3'),('76','秦皇岛市','130300','37','2'),('77','海港区','130302','76','3'),('78','山海关区','130303','76','3'),('79','北戴河区','130304','76','3'),('80','抚宁区','130306','76','3'),('81','青龙满族自治县','130321','76','3'),('82','昌黎县','130322','76','3'),('83','卢龙县','130324','76','3'),('84','邯郸市','130400','37','2'),('85','邯山区','130402','84','3'),('86','丛台区','130403','84','3'),('87','复兴区','130404','84','3'),('88','峰峰矿区','130406','84','3'),('89','肥乡区','130407','84','3'),('90','永年区','130408','84','3'),('91','临漳县','130423','84','3'),('92','成安县','130424','84','3'),('93','大名县','130425','84','3'),('94','涉县','130426','84','3'),('95','磁县','130427','84','3'),('96','邱县','130430','84','3'),('97','鸡泽县','130431','84','3'),('98','广平县','130432','84','3'),('99','馆陶县','130433','84','3'),('100','魏县','130434','84','3'),('101','曲周县','130435','84','3'),('102','武安市','130481','84','3'),('103','邢台市','130500','37','2'),('104','襄都区','130502','103','3'),('105','信都区','130503','103','3'),('106','任泽区','130505','103','3'),('107','南和区','130506','103','3'),('108','临城县','130522','103','3'),('109','内丘县','130523','103','3'),('110','柏乡县','130524','103','3'),('111','隆尧县','130525','103','3'),('112','宁晋县','130528','103','3'),('113','巨鹿县','130529','103','3'),('114','新河县','130530','103','3'),('115','广宗县','130531','103','3'),('116','平乡县','130532','103','3'),('117','威县','130533','103','3'),('118','清河县','130534','103','3'),('119','临西县','130535','103','3'),('120','南宫市','130581','103','3'),('121','沙河市','130582','103','3'),('122','保定市','130600','37','2'),('123','竞秀区','130602','122','3'),('124','莲池区','130606','122','3'),('125','满城区','130607','122','3'),('126','清苑区','130608','122','3'),('127','徐水区','130609','122','3'),('128','涞水县','130623','122','3'),('129','阜平县','130624','122','3'),('130','定兴县','130626','122','3'),('131','唐县','130627','122','3'),('132','高阳县','130628','122','3'),('133','容城县','130629','122','3'),('134','涞源县','130630','122','3'),('135','望都县','130631','122','3'),('136','安新县','130632','122','3'),('137','易县','130633','122','3'),('138','曲阳县','130634','122','3'),('139','蠡县','130635','122','3'),('140','顺平县','130636','122','3'),('141','博野县','130637','122','3'),('142','雄县','130638','122','3'),('143','涿州市','130681','122','3'),('144','定州市','130682','122','3'),('145','安国市','130683','122','3'),('146','高碑店市','130684','122','3'),('147','张家口市','130700','37','2'),('148','桥东区','130702','147','3'),('149','桥西区','130703','147','3'),('150','宣化区','130705','147','3'),('151','下花园区','130706','147','3'),('152','万全区','130708','147','3'),('153','崇礼区','130709','147','3'),('154','张北县','130722','147','3'),('155','康保县','130723','147','3'),('156','沽源县','130724','147','3'),('157','尚义县','130725','147','3'),('158','蔚县','130726','147','3'),('159','阳原县','130727','147','3'),('160','怀安县','130728','147','3'),('161','怀来县','130730','147','3'),('162','涿鹿县','130731','147','3'),('163','赤城县','130732','147','3'),('164','承德市','130800','37','2'),('165','双桥区','130802','164','3'),('166','双滦区','130803','164','3'),('167','鹰手营子矿区','130804','164','3'),('168','承德县','130821','164','3'),('169','兴隆县','130822','164','3'),('170','滦平县','130824','164','3'),('171','隆化县','130825','164','3'),('172','丰宁满族自治县','130826','164','3'),('173','宽城满族自治县','130827','164','3'),('174','围场满族蒙古族自治县','130828','164','3'),('175','平泉市','130881','164','3'),('176','沧州市','130900','37','2'),('177','新华区','130902','176','3'),('178','运河区','130903','176','3'),('179','沧县','130921','176','3'),('180','青县','130922','176','3'),('181','东光县','130923','176','3'),('182','海兴县','130924','176','3'),('183','盐山县','130925','176','3'),('184','肃宁县','130926','176','3'),('185','南皮县','130927','176','3'),('186','吴桥县','130928','176','3'),('187','献县','130929','176','3'),('188','孟村回族自治县','130930','176','3'),('189','泊头市','130981','176','3'),('190','任丘市','130982','176','3'),('191','黄骅市','130983','176','3'),('192','河间市','130984','176','3'),('193','廊坊市','131000','37','2'),('194','安次区','131002','193','3'),('195','广阳区','131003','193','3'),('196','固安县','131022','193','3'),('197','永清县','131023','193','3'),('198','香河县','131024','193','3'),('199','大城县','131025','193','3'),('200','文安县','131026','193','3'),('201','大厂回族自治县','131028','193','3'),('202','霸州市','131081','193','3'),('203','三河市','131082','193','3'),('204','衡水市','131100','37','2'),('205','桃城区','131102','204','3'),('206','冀州区','131103','204','3'),('207','枣强县','131121','204','3'),('208','武邑县','131122','204','3'),('209','武强县','131123','204','3'),('210','饶阳县','131124','204','3'),('211','安平县','131125','204','3'),('212','故城县','131126','204','3'),('213','景县','131127','204','3'),('214','阜城县','131128','204','3'),('215','深州市','131182','204','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('216','山西省','140000','0','1'),('217','太原市','140100','216','2'),('218','小店区','140105','217','3'),('219','迎泽区','140106','217','3'),('220','杏花岭区','140107','217','3'),('221','尖草坪区','140108','217','3'),('222','万柏林区','140109','217','3'),('223','晋源区','140110','217','3'),('224','清徐县','140121','217','3'),('225','阳曲县','140122','217','3'),('226','娄烦县','140123','217','3'),('227','古交市','140181','217','3'),('228','大同市','140200','216','2'),('229','新荣区','140212','228','3'),('230','平城区','140213','228','3'),('231','云冈区','140214','228','3'),('232','云州区','140215','228','3'),('233','阳高县','140221','228','3'),('234','天镇县','140222','228','3'),('235','广灵县','140223','228','3'),('236','灵丘县','140224','228','3'),('237','浑源县','140225','228','3'),('238','左云县','140226','228','3'),('239','阳泉市','140300','216','2'),('240','城区','140302','239','3'),('241','矿区','140303','239','3'),('242','郊区','140311','239','3'),('243','平定县','140321','239','3'),('244','盂县','140322','239','3'),('245','长治市','140400','216','2'),('246','潞州区','140403','245','3'),('247','上党区','140404','245','3'),('248','屯留区','140405','245','3'),('249','潞城区','140406','245','3'),('250','襄垣县','140423','245','3'),('251','平顺县','140425','245','3'),('252','黎城县','140426','245','3'),('253','壶关县','140427','245','3'),('254','长子县','140428','245','3'),('255','武乡县','140429','245','3'),('256','沁县','140430','245','3'),('257','沁源县','140431','245','3'),('258','晋城市','140500','216','2'),('259','城区','140502','258','3'),('260','沁水县','140521','258','3'),('261','阳城县','140522','258','3'),('262','陵川县','140524','258','3'),('263','泽州县','140525','258','3'),('264','高平市','140581','258','3'),('265','朔州市','140600','216','2'),('266','朔城区','140602','265','3'),('267','平鲁区','140603','265','3'),('268','山阴县','140621','265','3'),('269','应县','140622','265','3'),('270','右玉县','140623','265','3'),('271','怀仁市','140681','266','3'),('272','晋中市','140700','216','2'),('273','榆次区','140702','272','3'),('274','太谷区','140703','272','3'),('275','榆社县','140721','272','3'),('276','左权县','140722','272','3'),('277','和顺县','140723','272','3'),('278','昔阳县','140724','272','3'),('279','寿阳县','140725','272','3'),('280','祁县','140727','272','3'),('281','平遥县','140728','272','3'),('282','灵石县','140729','272','3'),('283','介休市','140781','272','3'),('284','运城市','140800','216','2'),('285','盐湖区','140802','284','3'),('286','临猗县','140821','284','3'),('287','万荣县','140822','284','3'),('288','闻喜县','140823','284','3'),('289','稷山县','140824','284','3'),('290','新绛县','140825','284','3'),('291','绛县','140826','284','3'),('292','垣曲县','140827','284','3'),('293','夏县','140828','284','3'),('294','平陆县','140829','284','3'),('295','芮城县','140830','284','3'),('296','永济市','140881','284','3'),('297','河津市','140882','284','3'),('298','忻州市','140900','216','2'),('299','忻府区','140902','298','3'),('300','定襄县','140921','298','3'),('301','五台县','140922','298','3'),('302','代县','140923','298','3'),('303','繁峙县','140924','298','3'),('304','宁武县','140925','298','3'),('305','静乐县','140926','298','3'),('306','神池县','140927','298','3'),('307','五寨县','140928','298','3'),('308','岢岚县','140929','298','3'),('309','河曲县','140930','298','3'),('310','保德县','140931','298','3'),('311','偏关县','140932','298','3'),('312','原平市','140981','298','3'),('313','临汾市','141000','216','2'),('314','尧都区','141002','313','3'),('315','曲沃县','141021','313','3'),('316','翼城县','141022','313','3'),('317','襄汾县','141023','313','3'),('318','洪洞县','141024','313','3'),('319','古县','141025','313','3'),('320','安泽县','141026','313','3'),('321','浮山县','141027','313','3'),('322','吉县','141028','313','3'),('323','乡宁县','141029','313','3'),('324','大宁县','141030','313','3'),('325','隰县','141031','313','3'),('326','永和县','141032','313','3'),('327','蒲县','141033','313','3'),('328','汾西县','141034','313','3'),('329','侯马市','141081','313','3'),('330','霍州市','141082','313','3'),('331','吕梁市','141100','216','2'),('332','离石区','141102','331','3'),('333','文水县','141121','331','3'),('334','交城县','141122','331','3'),('335','兴县','141123','331','3'),('336','临县','141124','331','3'),('337','柳林县','141125','331','3'),('338','石楼县','141126','331','3'),('339','岚县','141127','331','3'),('340','方山县','141128','331','3'),('341','中阳县','141129','331','3'),('342','交口县','141130','331','3'),('343','孝义市','141181','331','3'),('344','汾阳市','141182','331','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('345','内蒙古自治区','150000','0','1'),('346','呼和浩特市','150100','345','2'),('347','新城区','150102','346','3'),('348','回民区','150103','346','3'),('349','玉泉区','150104','346','3'),('350','赛罕区','150105','346','3'),('351','土默特左旗','150121','346','3'),('352','托克托县','150122','346','3'),('353','和林格尔县','150123','346','3'),('354','清水河县','150124','346','3'),('355','武川县','150125','346','3'),('356','包头市','150200','345','2'),('357','东河区','150202','356','3'),('358','昆都仑区','150203','356','3'),('359','青山区','150204','356','3'),('360','石拐区','150205','356','3'),('361','白云鄂博矿区','150206','356','3'),('362','九原区','150207','356','3'),('363','土默特右旗','150221','356','3'),('364','固阳县','150222','356','3'),('365','达尔罕茂明安联合旗','150223','356','3'),('366','乌海市','150300','345','2'),('367','海勃湾区','150302','366','3'),('368','海南区','150303','366','3'),('369','乌达区','150304','366','3'),('370','赤峰市','150400','345','2'),('371','红山区','150402','370','3'),('372','元宝山区','150403','370','3'),('373','松山区','150404','370','3'),('374','阿鲁科尔沁旗','150421','370','3'),('375','巴林左旗','150422','370','3'),('376','巴林右旗','150423','370','3'),('377','林西县','150424','370','3'),('378','克什克腾旗','150425','370','3'),('379','翁牛特旗','150426','370','3'),('380','喀喇沁旗','150428','370','3'),('381','宁城县','150429','370','3'),('382','敖汉旗','150430','370','3'),('383','通辽市','150500','345','2'),('384','科尔沁区','150502','383','3'),('385','科尔沁左翼中旗','150521','383','3'),('386','科尔沁左翼后旗','150522','383','3'),('387','开鲁县','150523','383','3'),('388','库伦旗','150524','383','3'),('389','奈曼旗','150525','383','3'),('390','扎鲁特旗','150526','383','3'),('391','霍林郭勒市','150581','383','3'),('392','鄂尔多斯市','150600','345','2'),('393','东胜区','150602','392','3'),('394','康巴什区','150603','392','3'),('395','达拉特旗','150621','392','3'),('396','准格尔旗','150622','392','3'),('397','鄂托克前旗','150623','392','3'),('398','鄂托克旗','150624','392','3'),('399','杭锦旗','150625','392','3'),('400','乌审旗','150626','392','3'),('401','伊金霍洛旗','150627','392','3'),('402','呼伦贝尔市','150700','345','2'),('403','海拉尔区','150702','402','3'),('404','扎赉诺尔区','150703','402','3'),('405','阿荣旗','150721','402','3'),('406','莫力达瓦达斡尔族自治旗','150722','402','3'),('407','鄂伦春自治旗','150723','402','3'),('408','鄂温克族自治旗','150724','402','3'),('409','陈巴尔虎旗','150725','402','3'),('410','新巴尔虎左旗','150726','402','3'),('411','新巴尔虎右旗','150727','402','3'),('412','满洲里市','150781','402','3'),('413','牙克石市','150782','402','3'),('414','扎兰屯市','150783','402','3'),('415','额尔古纳市','150784','402','3'),('416','根河市','150785','402','3'),('417','巴彦淖尔市','150800','345','2'),('418','临河区','150802','417','3'),('419','五原县','150821','417','3'),('420','磴口县','150822','417','3'),('421','乌拉特前旗','150823','417','3'),('422','乌拉特中旗','150824','417','3'),('423','乌拉特后旗','150825','417','3'),('424','杭锦后旗','150826','417','3'),('425','乌兰察布市','150900','345','2'),('426','集宁区','150902','425','3'),('427','卓资县','150921','425','3'),('428','化德县','150922','425','3'),('429','商都县','150923','425','3'),('430','兴和县','150924','425','3'),('431','凉城县','150925','425','3'),('432','察哈尔右翼前旗','150926','425','3'),('433','察哈尔右翼中旗','150927','425','3'),('434','察哈尔右翼后旗','150928','425','3'),('435','四子王旗','150929','425','3'),('436','丰镇市','150981','425','3'),('437','兴安盟','152200','345','2'),('438','乌兰浩特市','152201','437','3'),('439','阿尔山市','152202','437','3'),('440','科尔沁右翼前旗','152221','437','3'),('441','科尔沁右翼中旗','152222','437','3'),('442','扎赉特旗','152223','437','3'),('443','突泉县','152224','437','3'),('444','锡林郭勒盟','152500','345','2'),('445','二连浩特市','152501','444','3'),('446','锡林浩特市','152502','444','3'),('447','阿巴嘎旗','152522','444','3'),('448','苏尼特左旗','152523','444','3'),('449','苏尼特右旗','152524','444','3'),('450','东乌珠穆沁旗','152525','444','3'),('451','西乌珠穆沁旗','152526','444','3'),('452','太仆寺旗','152527','444','3'),('453','镶黄旗','152528','444','3'),('454','正镶白旗','152529','444','3'),('455','正蓝旗','152530','444','3'),('456','多伦县','152531','444','3'),('457','阿拉善盟','152900','345','2'),('458','阿拉善左旗','152921','457','3'),('459','阿拉善右旗','152922','457','3'),('460','额济纳旗','152923','457','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('461','辽宁省','210000','0','1'),('462','沈阳市','210100','461','2'),('463','和平区','210102','462','3'),('464','沈河区','210103','462','3'),('465','大东区','210104','462','3'),('466','皇姑区','210105','462','3'),('467','铁西区','210106','462','3'),('468','苏家屯区','210111','462','3'),('469','浑南区','210112','462','3'),('470','沈北新区','210113','462','3'),('471','于洪区','210114','462','3'),('472','辽中区','210115','462','3'),('473','康平县','210123','462','3'),('474','法库县','210124','462','3'),('475','新民市','210181','462','3'),('476','大连市','210200','461','2'),('477','中山区','210202','476','3'),('478','西岗区','210203','476','3'),('479','沙河口区','210204','476','3'),('480','甘井子区','210211','476','3'),('481','旅顺口区','210212','476','3'),('482','金州区','210213','476','3'),('483','普兰店区','210214','476','3'),('484','长海县','210224','476','3'),('485','瓦房店市','210281','476','3'),('486','庄河市','210283','476','3'),('487','鞍山市','210300','461','2'),('488','铁东区','210302','487','3'),('489','铁西区','210303','487','3'),('490','立山区','210304','487','3'),('491','千山区','210311','487','3'),('492','台安县','210321','487','3'),('493','岫岩满族自治县','210323','487','3'),('494','海城市','210381','487','3'),('495','抚顺市','210400','461','2'),('496','新抚区','210402','495','3'),('497','东洲区','210403','495','3'),('498','望花区','210404','495','3'),('499','顺城区','210411','495','3'),('500','抚顺县','210421','495','3'),('501','新宾满族自治县','210422','495','3'),('502','清原满族自治县','210423','495','3'),('503','本溪市','210500','461','2'),('504','平山区','210502','503','3'),('505','溪湖区','210503','503','3'),('506','明山区','210504','503','3'),('507','南芬区','210505','503','3'),('508','本溪满族自治县','210521','503','3'),('509','桓仁满族自治县','210522','503','3'),('510','丹东市','210600','461','2'),('511','元宝区','210602','510','3'),('512','振兴区','210603','510','3'),('513','振安区','210604','510','3'),('514','宽甸满族自治县','210624','510','3'),('515','东港市','210681','510','3'),('516','凤城市','210682','510','3'),('517','锦州市','210700','461','2'),('518','古塔区','210702','517','3'),('519','凌河区','210703','517','3'),('520','太和区','210711','517','3'),('521','黑山县','210726','517','3'),('522','义县','210727','517','3'),('523','凌海市','210781','517','3'),('524','北镇市','210782','517','3'),('525','营口市','210800','461','2'),('526','站前区','210802','525','3'),('527','西市区','210803','525','3'),('528','鲅鱼圈区','210804','525','3'),('529','老边区','210811','525','3'),('530','盖州市','210881','525','3'),('531','大石桥市','210882','525','3'),('532','阜新市','210900','461','2'),('533','海州区','210902','532','3'),('534','新邱区','210903','532','3'),('535','太平区','210904','532','3'),('536','清河门区','210905','532','3'),('537','细河区','210911','532','3'),('538','阜新蒙古族自治县','210921','532','3'),('539','彰武县','210922','532','3'),('540','辽阳市','211000','461','2'),('541','白塔区','211002','540','3'),('542','文圣区','211003','540','3'),('543','宏伟区','211004','540','3'),('544','弓长岭区','211005','540','3'),('545','太子河区','211011','540','3'),('546','辽阳县','211021','540','3'),('547','灯塔市','211081','540','3'),('548','盘锦市','211100','461','2'),('549','双台子区','211102','548','3'),('550','兴隆台区','211103','548','3'),('551','大洼区','211104','548','3'),('552','盘山县','211122','548','3'),('553','铁岭市','211200','461','2'),('554','银州区','211202','553','3'),('555','清河区','211204','553','3'),('556','铁岭县','211221','553','3'),('557','西丰县','211223','553','3'),('558','昌图县','211224','553','3'),('559','调兵山市','211281','553','3'),('560','开原市','211282','553','3'),('561','朝阳市','211300','461','2'),('562','双塔区','211302','561','3'),('563','龙城区','211303','561','3'),('564','朝阳县','211321','561','3'),('565','建平县','211322','561','3'),('566','喀喇沁左翼蒙古族自治县','211324','561','3'),('567','北票市','211381','561','3'),('568','凌源市','211382','561','3'),('569','葫芦岛市','211400','461','2'),('570','连山区','211402','569','3'),('571','龙港区','211403','569','3'),('572','南票区','211404','569','3'),('573','绥中县','211421','569','3'),('574','建昌县','211422','569','3'),('575','兴城市','211481','569','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values('576','吉林省','220000','0','1'),('577','长春市','220100','576','2'),('578','南关区','220102','577','3'),('579','宽城区','220103','577','3'),('580','朝阳区','220104','577','3'),('581','二道区','220105','577','3'),('582','绿园区','220106','577','3'),('583','双阳区','220112','577','3'),('584','九台区','220113','577','3'),('585','农安县','220122','577','3'),('586','榆树市','220182','577','3'),('587','德惠市','220183','577','3'),('588','公主岭市','220184','577','3'),('589','吉林市','220200','576','2'),('590','昌邑区','220202','589','3'),('591','龙潭区','220203','589','3'),('592','船营区','220204','589','3'),('593','丰满区','220211','589','3'),('594','永吉县','220221','589','3'),('595','蛟河市','220281','589','3'),('596','桦甸市','220282','589','3'),('597','舒兰市','220283','589','3'),('598','磐石市','220284','589','3'),('599','四平市','220300','576','2'),('600','铁西区','220302','599','3'),('601','铁东区','220303','599','3'),('602','梨树县','220322','599','3'),('603','伊通满族自治县','220323','599','3'),('604','双辽市','220382','599','3'),('605','辽源市','220400','576','2'),('606','龙山区','220402','605','3'),('607','西安区','220403','605','3'),('608','东丰县','220421','605','3'),('609','东辽县','220422','605','3'),('610','通化市','220500','576','2'),('611','东昌区','220502','610','3'),('612','二道江区','220503','610','3'),('613','通化县','220521','610','3'),('614','辉南县','220523','610','3'),('615','柳河县','220524','610','3'),('616','梅河口市','220581','610','3'),('617','集安市','220582','610','3'),('618','白山市','220600','576','2'),('619','浑江区','220602','618','3'),('620','江源区','220605','618','3'),('621','抚松县','220621','618','3'),('622','靖宇县','220622','618','3'),('623','长白朝鲜族自治县','220623','618','3'),('624','临江市','220681','618','3'),('625','松原市','220700','576','2'),('626','宁江区','220702','625','3'),('627','前郭尔罗斯蒙古族自治县','220721','625','3'),('628','长岭县','220722','625','3'),('629','乾安县','220723','625','3'),('630','扶余市','220781','625','3'),('631','白城市','220800','576','2'),('632','洮北区','220802','631','3'),('633','镇赉县','220821','631','3'),('634','通榆县','220822','631','3'),('635','洮南市','220881','631','3'),('636','大安市','220882','631','3'),('637','延边朝鲜族自治州','222400','576','2'),('638','延吉市','222401','637','3'),('639','图们市','222402','637','3'),('640','敦化市','222403','637','3'),('641','珲春市','222404','637','3'),('642','龙井市','222405','637','3'),('643','和龙市','222406','637','3'),('644','汪清县','222424','637','3'),('645','安图县','222426','637','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('646','黑龙江省','230000','0','1'),('647','哈尔滨市','230100','646','2'),('648','道里区','230102','647','3'),('649','南岗区','230103','647','3'),('650','道外区','230104','647','3'),('651','平房区','230108','647','3'),('652','松北区','230109','647','3'),('653','香坊区','230110','647','3'),('654','呼兰区','230111','647','3'),('655','阿城区','230112','647','3'),('656','双城区','230113','647','3'),('657','依兰县','230123','647','3'),('658','方正县','230124','647','3'),('659','宾县','230125','647','3'),('660','巴彦县','230126','647','3'),('661','木兰县','230127','647','3'),('662','通河县','230128','647','3'),('663','延寿县','230129','647','3'),('664','尚志市','230183','647','3'),('665','五常市','230184','647','3'),('666','齐齐哈尔市','230200','646','2'),('667','龙沙区','230202','666','3'),('668','建华区','230203','666','3'),('669','铁锋区','230204','666','3'),('670','昂昂溪区','230205','666','3'),('671','富拉尔基区','230206','666','3'),('672','碾子山区','230207','666','3'),('673','梅里斯达斡尔族区','230208','666','3'),('674','龙江县','230221','666','3'),('675','依安县','230223','666','3'),('676','泰来县','230224','666','3'),('677','甘南县','230225','666','3'),('678','富裕县','230227','666','3'),('679','克山县','230229','666','3'),('680','克东县','230230','666','3'),('681','拜泉县','230231','666','3'),('682','讷河市','230281','666','3'),('683','鸡西市','230300','646','2'),('684','鸡冠区','230302','683','3'),('685','恒山区','230303','683','3'),('686','滴道区','230304','683','3'),('687','梨树区','230305','683','3'),('688','城子河区','230306','683','3'),('689','麻山区','230307','683','3'),('690','鸡东县','230321','683','3'),('691','虎林市','230381','683','3'),('692','密山市','230382','683','3'),('693','鹤岗市','230400','646','2'),('694','向阳区','230402','693','3'),('695','工农区','230403','693','3'),('696','南山区','230404','693','3'),('697','兴安区','230405','693','3'),('698','东山区','230406','693','3'),('699','兴山区','230407','693','3'),('700','萝北县','230421','693','3'),('701','绥滨县','230422','693','3'),('702','双鸭山市','230500','646','2'),('703','尖山区','230502','702','3'),('704','岭东区','230503','702','3'),('705','四方台区','230505','702','3'),('706','宝山区','230506','702','3'),('707','集贤县','230521','702','3'),('708','友谊县','230522','702','3'),('709','宝清县','230523','702','3'),('710','饶河县','230524','702','3'),('711','大庆市','230600','646','2'),('712','萨尔图区','230602','711','3'),('713','龙凤区','230603','711','3'),('714','让胡路区','230604','711','3'),('715','红岗区','230605','711','3'),('716','大同区','230606','711','3'),('717','肇州县','230621','711','3'),('718','肇源县','230622','711','3'),('719','林甸县','230623','711','3'),('720','杜尔伯特蒙古族自治县','230624','711','3'),('721','伊春市','230700','646','2'),('722','伊美区','230717','721','3'),('723','乌翠区','230718','721','3'),('724','友好区','230719','721','3'),('725','嘉荫县','230722','721','3'),('726','汤旺县','230723','721','3'),('727','丰林县','230724','721','3'),('728','大箐山县','230725','721','3'),('729','南岔县','230726','721','3'),('730','金林区','230751','721','3'),('731','铁力市','230781','721','3'),('732','佳木斯市','230800','646','2'),('733','向阳区','230803','732','3'),('734','前进区','230804','732','3'),('735','东风区','230805','732','3'),('736','郊区','230811','732','3'),('737','桦南县','230822','732','3'),('738','桦川县','230826','732','3'),('739','汤原县','230828','732','3'),('740','同江市','230881','732','3'),('741','富锦市','230882','732','3'),('742','抚远市','230883','732','3'),('743','七台河市','230900','646','2'),('744','新兴区','230902','743','3'),('745','桃山区','230903','743','3'),('746','茄子河区','230904','743','3'),('747','勃利县','230921','743','3'),('748','牡丹江市','231000','646','2'),('749','东安区','231002','748','3'),('750','阳明区','231003','748','3'),('751','爱民区','231004','748','3'),('752','西安区','231005','748','3'),('753','林口县','231025','748','3'),('754','绥芬河市','231081','748','3'),('755','海林市','231083','748','3'),('756','宁安市','231084','748','3'),('757','穆棱市','231085','748','3'),('758','东宁市','231086','748','3'),('759','黑河市','231100','646','2'),('760','爱辉区','231102','759','3'),('761','逊克县','231123','759','3'),('762','孙吴县','231124','759','3'),('763','北安市','231181','759','3'),('764','五大连池市','231182','759','3'),('765','嫩江市','231183','759','3'),('766','绥化市','231200','646','2'),('767','北林区','231202','766','3'),('768','望奎县','231221','766','3'),('769','兰西县','231222','766','3'),('770','青冈县','231223','766','3'),('771','庆安县','231224','766','3'),('772','明水县','231225','766','3'),('773','绥棱县','231226','766','3'),('774','安达市','231281','766','3'),('775','肇东市','231282','766','3'),('776','海伦市','231283','766','3'),('777','大兴安岭地区','232700','646','2'),('778','漠河市','232701','777','3'),('779','加格达奇区','232718','777','3'),('780','呼玛县','232721','777','3'),('781','塔河县','232722','777','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('782','上海市','310000','0','1'),('783','上海城区','310100','782','2'),('784','黄浦区','310101','783','3'),('785','徐汇区','310104','783','3'),('786','长宁区','310105','783','3'),('787','静安区','310106','783','3'),('788','普陀区','310107','783','3'),('789','虹口区','310109','783','3'),('790','杨浦区','310110','783','3'),('791','闵行区','310112','783','3'),('792','宝山区','310113','783','3'),('793','嘉定区','310114','783','3'),('794','浦东新区','310115','783','3'),('795','金山区','310116','783','3'),('796','松江区','310117','783','3'),('797','青浦区','310118','783','3'),('798','奉贤区','310120','783','3'),('799','崇明区','310151','783','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('800','江苏省','320000','0','1'),('801','南京市','320100','800','2'),('802','玄武区','320102','801','3'),('803','秦淮区','320104','801','3'),('804','建邺区','320105','801','3'),('805','鼓楼区','320106','801','3'),('806','浦口区','320111','801','3'),('807','栖霞区','320113','801','3'),('808','雨花台区','320114','801','3'),('809','江宁区','320115','801','3'),('810','六合区','320116','801','3'),('811','溧水区','320117','801','3'),('812','高淳区','320118','801','3'),('813','无锡市','320200','800','2'),('814','锡山区','320205','813','3'),('815','惠山区','320206','813','3'),('816','滨湖区','320211','813','3'),('817','梁溪区','320213','813','3'),('818','新吴区','320214','813','3'),('819','江阴市','320281','813','3'),('820','宜兴市','320282','813','3'),('821','徐州市','320300','800','2'),('822','鼓楼区','320302','821','3'),('823','云龙区','320303','821','3'),('824','贾汪区','320305','821','3'),('825','泉山区','320311','821','3'),('826','铜山区','320312','821','3'),('827','丰县','320321','821','3'),('828','沛县','320322','821','3'),('829','睢宁县','320324','821','3'),('830','新沂市','320381','821','3'),('831','邳州市','320382','821','3'),('832','常州市','320400','800','2'),('833','天宁区','320402','832','3'),('834','钟楼区','320404','832','3'),('835','新北区','320411','832','3'),('836','武进区','320412','832','3'),('837','金坛区','320413','832','3'),('838','溧阳市','320481','832','3'),('839','苏州市','320500','800','2'),('840','虎丘区','320505','839','3'),('841','吴中区','320506','839','3'),('842','相城区','320507','839','3'),('843','姑苏区','320508','839','3'),('844','吴江区','320509','839','3'),('845','苏州工业园区','320571','839','3'),('846','常熟市','320581','839','3'),('847','张家港市','320582','839','3'),('848','昆山市','320583','839','3'),('849','太仓市','320585','839','3'),('850','南通市','320600','800','2'),('851','崇川区','320602','850','3'),('852','通州区','320612','850','3'),('853','如东县','320623','850','3'),('854','启东市','320681','850','3'),('855','如皋市','320682','850','3'),('856','海门区','320684','850','3'),('857','海安市','320685','850','3'),('858','连云港市','320700','800','2'),('859','连云区','320703','858','3'),('860','海州区','320706','858','3'),('861','赣榆区','320707','858','3'),('862','东海县','320722','858','3'),('863','灌云县','320723','858','3'),('864','灌南县','320724','858','3'),('865','淮安市','320800','800','2'),('866','淮安区','320803','865','3'),('867','淮阴区','320804','865','3'),('868','清江浦区','320812','865','3'),('869','洪泽区','320813','865','3'),('870','涟水县','320826','865','3'),('871','盱眙县','320830','865','3'),('872','金湖县','320831','865','3'),('873','盐城市','320900','800','2'),('874','亭湖区','320902','873','3'),('875','盐都区','320903','873','3'),('876','大丰区','320904','873','3'),('877','响水县','320921','873','3'),('878','滨海县','320922','873','3'),('879','阜宁县','320923','873','3'),('880','射阳县','320924','873','3'),('881','建湖县','320925','873','3'),('882','东台市','320981','873','3'),('883','扬州市','321000','800','2'),('884','广陵区','321002','883','3'),('885','邗江区','321003','883','3'),('886','江都区','321012','883','3'),('887','宝应县','321023','883','3'),('888','仪征市','321081','883','3'),('889','高邮市','321084','883','3'),('890','镇江市','321100','800','2'),('891','京口区','321102','890','3'),('892','润州区','321111','890','3'),('893','丹徒区','321112','890','3'),('894','丹阳市','321181','890','3'),('895','扬中市','321182','890','3'),('896','句容市','321183','890','3'),('897','泰州市','321200','800','2'),('898','海陵区','321202','897','3'),('899','高港区','321203','897','3'),('900','姜堰区','321204','897','3'),('901','兴化市','321281','897','3'),('902','靖江市','321282','897','3'),('903','泰兴市','321283','897','3'),('904','宿迁市','321300','800','2'),('905','宿城区','321302','904','3'),('906','宿豫区','321311','904','3'),('907','沭阳县','321322','904','3'),('908','泗阳县','321323','904','3'),('909','泗洪县','321324','904','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('910','浙江省','330000','0','1'),('911','杭州市','330100','910','2'),('912','上城区','330102','911','3'),('913','下城区','330103','911','3'),('914','江干区','330104','911','3'),('915','拱墅区','330105','911','3'),('916','西湖区','330106','911','3'),('917','滨江区','330108','911','3'),('918','萧山区','330109','911','3'),('919','余杭区','330110','911','3'),('920','富阳区','330111','911','3'),('921','临安区','330112','911','3'),('922','桐庐县','330122','911','3'),('923','淳安县','330127','911','3'),('924','建德市','330182','911','3'),('925','宁波市','330200','910','2'),('926','海曙区','330203','925','3'),('927','江北区','330205','925','3'),('928','北仑区','330206','925','3'),('929','镇海区','330211','925','3'),('930','鄞州区','330212','925','3'),('931','奉化区','330213','925','3'),('932','象山县','330225','925','3'),('933','宁海县','330226','925','3'),('934','余姚市','330281','925','3'),('935','慈溪市','330282','925','3'),('936','温州市','330300','910','2'),('937','鹿城区','330302','936','3'),('938','龙湾区','330303','936','3'),('939','瓯海区','330304','936','3'),('940','洞头区','330305','936','3'),('941','永嘉县','330324','936','3'),('942','平阳县','330326','936','3'),('943','苍南县','330327','936','3'),('944','文成县','330328','936','3'),('945','泰顺县','330329','936','3'),('946','瑞安市','330381','936','3'),('947','乐清市','330382','936','3'),('948','龙港市','330383','936','3'),('949','嘉兴市','330400','910','2'),('950','南湖区','330402','949','3'),('951','秀洲区','330411','949','3'),('952','嘉善县','330421','949','3'),('953','海盐县','330424','949','3'),('954','海宁市','330481','949','3'),('955','平湖市','330482','949','3'),('956','桐乡市','330483','949','3'),('957','湖州市','330500','910','2'),('958','吴兴区','330502','957','3'),('959','南浔区','330503','957','3'),('960','德清县','330521','957','3'),('961','长兴县','330522','957','3'),('962','安吉县','330523','957','3'),('963','绍兴市','330600','910','2'),('964','越城区','330602','963','3'),('965','柯桥区','330603','963','3'),('966','上虞区','330604','963','3'),('967','新昌县','330624','963','3'),('968','诸暨市','330681','963','3'),('969','嵊州市','330683','963','3'),('970','金华市','330700','910','2'),('971','婺城区','330702','970','3'),('972','金东区','330703','970','3'),('973','武义县','330723','970','3'),('974','浦江县','330726','970','3'),('975','磐安县','330727','970','3'),('976','兰溪市','330781','970','3'),('977','义乌市','330782','970','3'),('978','东阳市','330783','970','3'),('979','永康市','330784','970','3'),('980','衢州市','330800','910','2'),('981','柯城区','330802','980','3'),('982','衢江区','330803','980','3'),('983','常山县','330822','980','3'),('984','开化县','330824','980','3'),('985','龙游县','330825','980','3'),('986','江山市','330881','980','3'),('987','舟山市','330900','910','2'),('988','定海区','330902','987','3'),('989','普陀区','330903','987','3'),('990','岱山县','330921','987','3'),('991','嵊泗县','330922','987','3'),('992','台州市','331000','910','2'),('993','椒江区','331002','992','3'),('994','黄岩区','331003','992','3'),('995','路桥区','331004','992','3'),('996','三门县','331022','992','3'),('997','天台县','331023','992','3'),('998','仙居县','331024','992','3'),('999','温岭市','331081','992','3'),('1000','临海市','331082','992','3'),('1001','玉环市','331083','992','3'),('1002','丽水市','331100','910','2'),('1003','莲都区','331102','1002','3'),('1004','青田县','331121','1002','3'),('1005','缙云县','331122','1002','3'),('1006','遂昌县','331123','1002','3'),('1007','松阳县','331124','1002','3'),('1008','云和县','331125','1002','3'),('1009','庆元县','331126','1002','3'),('1010','景宁畲族自治县','331127','1002','3'),('1011','龙泉市','331181','1002','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('1012','安徽省','340000','0','1'),('1013','合肥市','340100','1012','2'),('1014','瑶海区','340102','1013','3'),('1015','庐阳区','340103','1013','3'),('1016','蜀山区','340104','1013','3'),('1017','包河区','340111','1013','3'),('1018','长丰县','340121','1013','3'),('1019','肥东县','340122','1013','3'),('1020','肥西县','340123','1013','3'),('1021','庐江县','340124','1013','3'),('1022','巢湖市','340181','1013','3'),('1023','芜湖市','340200','1012','2'),('1024','镜湖区','340202','1023','3'),('1025','鸠江区','340207','1023','3'),('1026','弋江区','340209','1023','3'),('1027','湾沚区','340210','1023','3'),('1028','繁昌区','340211','1023','3'),('1029','南陵县','340223','1023','3'),('1030','无为市','340281','1023','3'),('1031','蚌埠市','340300','1012','2'),('1032','龙子湖区','340302','1031','3'),('1033','蚌山区','340303','1031','3'),('1034','禹会区','340304','1031','3'),('1035','淮上区','340311','1031','3'),('1036','怀远县','340321','1031','3'),('1037','五河县','340322','1031','3'),('1038','固镇县','340323','1031','3'),('1039','淮南市','340400','1012','2'),('1040','大通区','340402','1039','3'),('1041','田家庵区','340403','1039','3'),('1042','谢家集区','340404','1039','3'),('1043','八公山区','340405','1039','3'),('1044','潘集区','340406','1039','3'),('1045','凤台县','340421','1039','3'),('1046','寿县','340422','1039','3'),('1047','马鞍山市','340500','1012','2'),('1048','花山区','340503','1047','3'),('1049','雨山区','340504','1047','3'),('1050','博望区','340506','1047','3'),('1051','当涂县','340521','1047','3'),('1052','含山县','340522','1047','3'),('1053','和县','340523','1047','3'),('1054','淮北市','340600','1012','2'),('1055','杜集区','340602','1052','3'),('1056','相山区','340603','1052','3'),('1057','烈山区','340604','1052','3'),('1058','濉溪县','340621','1052','3'),('1059','铜陵市','340700','1012','2'),('1060','铜官区','340705','1059','3'),('1061','义安区','340706','1059','3'),('1062','郊区','340711','1059','3'),('1063','枞阳县','340722','1059','3'),('1064','安庆市','340800','1012','2'),('1065','迎江区','340802','1064','3'),('1066','大观区','340803','1064','3'),('1067','宜秀区','340811','1064','3'),('1068','怀宁县','340822','1064','3'),('1069','太湖县','340825','1064','3'),('1070','宿松县','340826','1064','3'),('1071','望江县','340827','1064','3'),('1072','岳西县','340828','1064','3'),('1073','桐城市','340881','1064','3'),('1074','潜山市','340882','1064','3'),('1075','黄山市','341000','1012','2'),('1076','屯溪区','341002','1075','3'),('1077','黄山区','341003','1075','3'),('1078','徽州区','341004','1075','3'),('1079','歙县','341021','1075','3'),('1080','休宁县','341022','1075','3'),('1081','黟县','341023','1075','3'),('1082','祁门县','341024','1075','3'),('1083','滁州市','341100','1012','2'),('1084','琅琊区','341102','1083','3'),('1085','南谯区','341103','1083','3'),('1086','来安县','341122','1083','3'),('1087','全椒县','341124','1083','3'),('1088','定远县','341125','1083','3'),('1089','凤阳县','341126','1083','3'),('1090','天长市','341181','1083','3'),('1091','明光市','341182','1083','3'),('1092','阜阳市','341200','1012','2'),('1093','颍州区','341202','1092','3'),('1094','颍东区','341203','1092','3'),('1095','颍泉区','341204','1092','3'),('1096','临泉县','341221','1092','3'),('1097','太和县','341222','1092','3'),('1098','阜南县','341225','1092','3'),('1099','颍上县','341226','1092','3'),('1100','界首市','341282','1092','3'),('1101','宿州市','341300','1012','2'),('1102','埇桥区','341302','1101','3'),('1103','砀山县','341321','1101','3'),('1104','萧县','341322','1101','3'),('1105','灵璧县','341323','1101','3'),('1106','泗县','341324','1101','3'),('1107','六安市','341500','1012','2'),('1108','金安区','341502','1107','3'),('1109','裕安区','341503','1107','3'),('1110','叶集区','341504','1107','3'),('1111','霍邱县','341522','1107','3'),('1112','舒城县','341523','1107','3'),('1113','金寨县','341524','1107','3'),('1114','霍山县','341525','1107','3'),('1115','亳州市','341600','1012','2'),('1116','谯城区','341602','1115','3'),('1117','涡阳县','341621','1115','3'),('1118','蒙城县','341622','1115','3'),('1119','利辛县','341623','1115','3'),('1120','池州市','341700','1012','2'),('1121','贵池区','341702','1120','3'),('1122','东至县','341721','1120','3'),('1123','石台县','341722','1120','3'),('1124','青阳县','341723','1120','3'),('1125','宣城市','341800','1012','2'),('1126','宣州区','341802','1125','3'),('1127','郎溪县','341821','1125','3'),('1128','泾县','341823','1125','3'),('1129','绩溪县','341824','1125','3'),('1130','旌德县','341825','1125','3'),('1131','宁国市','341881','1125','3'),('1132','广德市','341882','1125','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('1133','福建省','350000','0','1'),('1134','福州市','350100','1133','2'),('1135','鼓楼区','350102','1134','3'),('1136','台江区','350103','1134','3'),('1137','仓山区','350104','1134','3'),('1138','马尾区','350105','1134','3'),('1139','晋安区','350111','1134','3'),('1140','长乐区','350112','1134','3'),('1141','闽侯县','350121','1134','3'),('1142','连江县','350122','1134','3'),('1143','罗源县','350123','1134','3'),('1144','闽清县','350124','1134','3'),('1145','永泰县','350125','1134','3'),('1146','平潭县','350128','1134','3'),('1147','福清市','350181','1134','3'),('1148','厦门市','350200','1133','2'),('1149','思明区','350203','1148','3'),('1150','海沧区','350205','1148','3'),('1151','湖里区','350206','1148','3'),('1152','集美区','350211','1148','3'),('1153','同安区','350212','1148','3'),('1154','翔安区','350213','1148','3'),('1155','莆田市','350300','1133','2'),('1156','城厢区','350302','1155','3'),('1157','涵江区','350303','1155','3'),('1158','荔城区','350304','1155','3'),('1159','秀屿区','350305','1155','3'),('1160','仙游县','350322','1155','3'),('1161','三明市','350400','1133','2'),('1162','三元区','350403','1161','3'),('1163','明溪县','350421','1161','3'),('1164','清流县','350423','1161','3'),('1165','宁化县','350424','1161','3'),('1166','大田县','350425','1161','3'),('1167','尤溪县','350426','1161','3'),('1168','沙县区','350427','1161','3'),('1169','将乐县','350428','1161','3'),('1170','泰宁县','350429','1161','3'),('1171','建宁县','350430','1161','3'),('1172','永安市','350481','1161','3'),('1173','泉州市','350500','1133','2'),('1174','鲤城区','350502','1173','3'),('1175','丰泽区','350503','1173','3'),('1176','洛江区','350504','1173','3'),('1177','泉港区','350505','1173','3'),('1178','惠安县','350521','1173','3'),('1179','安溪县','350524','1173','3'),('1180','永春县','350525','1173','3'),('1181','德化县','350526','1173','3'),('1182','金门县','350527','1173','3'),('1183','石狮市','350581','1173','3'),('1184','晋江市','350582','1173','3'),('1185','南安市','350583','1173','3'),('1186','漳州市','350600','1133','2'),('1187','芗城区','350602','1186','3'),('1188','龙文区','350603','1186','3'),('1189','云霄县','350622','1186','3'),('1190','漳浦县','350623','1186','3'),('1191','诏安县','350624','1186','3'),('1192','长泰区','350625','1186','3'),('1193','东山县','350626','1186','3'),('1194','南靖县','350627','1186','3'),('1195','平和县','350628','1186','3'),('1196','华安县','350629','1186','3'),('1197','龙海区','350681','1186','3'),('1198','南平市','350700','1133','2'),('1199','延平区','350702','1198','3'),('1200','建阳区','350703','1198','3'),('1201','顺昌县','350721','1198','3'),('1202','浦城县','350722','1198','3'),('1203','光泽县','350723','1198','3'),('1204','松溪县','350724','1198','3'),('1205','政和县','350725','1198','3'),('1206','邵武市','350781','1198','3'),('1207','武夷山市','350782','1198','3'),('1208','建瓯市','350783','1198','3'),('1209','龙岩市','350800','1133','2'),('1210','新罗区','350802','1209','3'),('1211','永定区','350803','1209','3'),('1212','长汀县','350821','1209','3'),('1213','上杭县','350823','1209','3'),('1214','武平县','350824','1209','3'),('1215','连城县','350825','1209','3'),('1216','漳平市','350881','1209','3'),('1217','宁德市','350900','1133','2'),('1218','蕉城区','350902','1217','3'),('1219','霞浦县','350921','1217','3'),('1220','古田县','350922','1217','3'),('1221','屏南县','350923','1217','3'),('1222','寿宁县','350924','1217','3'),('1223','周宁县','350925','1217','3'),('1224','柘荣县','350926','1217','3'),('1225','福安市','350981','1217','3'),('1226','福鼎市','350982','1217','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('1227','江西省','360000','0','1'),('1228','南昌市','360100','1227','2'),('1229','东湖区','360102','1228','3'),('1230','西湖区','360103','1228','3'),('1231','青云谱区','360104','1228','3'),('1232','青山湖区','360111','1228','3'),('1233','新建区','360112','1228','3'),('1234','红谷滩区','360113','1228','3'),('1235','南昌县','360121','1228','3'),('1236','安义县','360123','1228','3'),('1237','进贤县','360124','1228','3'),('1238','景德镇市','360200','1227','2'),('1239','昌江区','360202','1238','3'),('1240','珠山区','360203','1238','3'),('1241','浮梁县','360222','1238','3'),('1242','乐平市','360281','1238','3'),('1243','萍乡市','360300','1227','2'),('1244','安源区','360302','1243','3'),('1245','湘东区','360313','1243','3'),('1246','莲花县','360321','1243','3'),('1247','上栗县','360322','1243','3'),('1248','芦溪县','360323','1243','3'),('1249','九江市','360400','1227','2'),('1250','濂溪区','360402','1249','3'),('1251','浔阳区','360403','1249','3'),('1252','柴桑区','360404','1249','3'),('1253','武宁县','360423','1249','3'),('1254','修水县','360424','1249','3'),('1255','永修县','360425','1249','3'),('1256','德安县','360426','1249','3'),('1257','都昌县','360428','1249','3'),('1258','湖口县','360429','1249','3'),('1259','彭泽县','360430','1249','3'),('1260','瑞昌市','360481','1249','3'),('1261','共青城市','360482','1249','3'),('1262','庐山市','360483','1249','3'),('1263','新余市','360500','1227','2'),('1264','渝水区','360502','1263','3'),('1265','分宜县','360521','1263','3'),('1266','鹰潭市','360600','1227','2'),('1267','月湖区','360602','1266','3'),('1268','余江区','360603','1266','3'),('1269','贵溪市','360681','1266','3'),('1270','赣州市','360700','1227','2'),('1271','章贡区','360702','1270','3'),('1272','南康区','360703','1270','3'),('1273','赣县区','360704','1270','3'),('1274','信丰县','360722','1270','3'),('1275','大余县','360723','1270','3'),('1276','上犹县','360724','1270','3'),('1277','崇义县','360725','1270','3'),('1278','安远县','360726','1270','3'),('1279','定南县','360728','1270','3'),('1280','全南县','360729','1270','3'),('1281','宁都县','360730','1270','3'),('1282','于都县','360731','1270','3'),('1283','兴国县','360732','1270','3'),('1284','会昌县','360733','1270','3'),('1285','寻乌县','360734','1270','3'),('1286','石城县','360735','1270','3'),('1287','瑞金市','360781','1270','3'),('1288','龙南市','360783','1270','3'),('1289','吉安市','360800','1227','2'),('1290','吉州区','360802','1289','3'),('1291','青原区','360803','1289','3'),('1292','吉安县','360821','1289','3'),('1293','吉水县','360822','1289','3'),('1294','峡江县','360823','1289','3'),('1295','新干县','360824','1289','3'),('1296','永丰县','360825','1289','3'),('1297','泰和县','360826','1289','3'),('1298','遂川县','360827','1289','3'),('1299','万安县','360828','1289','3'),('1300','安福县','360829','1289','3'),('1301','永新县','360830','1289','3'),('1302','井冈山市','360881','1289','3'),('1303','宜春市','360900','1227','2'),('1304','袁州区','360902','1303','3'),('1305','奉新县','360921','1303','3'),('1306','万载县','360922','1303','3'),('1307','上高县','360923','1303','3'),('1308','宜丰县','360924','1303','3'),('1309','靖安县','360925','1303','3'),('1310','铜鼓县','360926','1303','3'),('1311','丰城市','360981','1303','3'),('1312','樟树市','360982','1303','3'),('1313','高安市','360983','1303','3'),('1314','抚州市','361000','1227','2'),('1315','临川区','361002','1314','3'),('1316','东乡区','361003','1314','3'),('1317','南城县','361021','1314','3'),('1318','黎川县','361022','1314','3'),('1319','南丰县','361023','1314','3'),('1320','崇仁县','361024','1314','3'),('1321','乐安县','361025','1314','3'),('1322','宜黄县','361026','1314','3'),('1323','金溪县','361027','1314','3'),('1324','资溪县','361028','1314','3'),('1325','广昌县','361030','1314','3'),('1326','上饶市','361100','1227','2'),('1327','信州区','361102','1326','3'),('1328','广丰区','361103','1326','3'),('1329','广信区','361104','1326','3'),('1330','玉山县','361123','1326','3'),('1331','铅山县','361124','1326','3'),('1332','横峰县','361125','1326','3'),('1333','弋阳县','361126','1326','3'),('1334','余干县','361127','1326','3'),('1335','鄱阳县','361128','1326','3'),('1336','万年县','361129','1326','3'),('1337','婺源县','361130','1326','3'),('1338','德兴市','361181','1326','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values('1339','山东省','370000','0','1'),('1340','济南市','370100','1339','2'),('1341','历下区','370102','1340','3'),('1342','市中区','370103','1340','3'),('1343','槐荫区','370104','1340','3'),('1344','天桥区','370105','1340','3'),('1345','历城区','370112','1340','3'),('1346','长清区','370113','1340','3'),('1347','章丘区','370114','1340','3'),('1348','济阳区','370115','1340','3'),('1349','莱芜区','370116','1340','3'),('1350','钢城区','370117','1340','3'),('1351','平阴县','370124','1340','3'),('1352','商河县','370126','1340','3'),('1353','青岛市','370200','1339','2'),('1354','市南区','370202','1353','3'),('1355','市北区','370203','1353','3'),('1356','黄岛区','370211','1353','3'),('1357','崂山区','370212','1353','3'),('1358','李沧区','370213','1353','3'),('1359','城阳区','370214','1353','3'),('1360','即墨区','370215','1353','3'),('1361','胶州市','370281','1353','3'),('1362','平度市','370283','1353','3'),('1363','莱西市','370285','1353','3'),('1364','淄博市','370300','1339','2'),('1365','淄川区','370302','1364','3'),('1366','张店区','370303','1364','3'),('1367','博山区','370304','1364','3'),('1368','临淄区','370305','1364','3'),('1369','周村区','370306','1364','3'),('1370','桓台县','370321','1364','3'),('1371','高青县','370322','1364','3'),('1372','沂源县','370323','1364','3'),('1373','枣庄市','370400','1339','2'),('1374','市中区','370402','1373','3'),('1375','薛城区','370403','1373','3'),('1376','峄城区','370404','1373','3'),('1377','台儿庄区','370405','1373','3'),('1378','山亭区','370406','1373','3'),('1379','滕州市','370481','1373','3'),('1380','东营市','370500','1339','2'),('1381','东营区','370502','1380','3'),('1382','河口区','370503','1380','3'),('1383','垦利区','370505','1380','3'),('1384','利津县','370522','1380','3'),('1385','广饶县','370523','1380','3'),('1386','烟台市','370600','1339','2'),('1387','芝罘区','370602','1386','3'),('1388','福山区','370611','1386','3'),('1389','牟平区','370612','1386','3'),('1390','莱山区','370613','1386','3'),('1391','蓬莱区','370614','1386','3'),('1392','龙口市','370681','1386','3'),('1393','莱阳市','370682','1386','3'),('1394','莱州市','370683','1386','3'),('1395','招远市','370685','1386','3'),('1396','栖霞市','370686','1386','3'),('1397','海阳市','370687','1386','3'),('1398','潍坊市','370700','1339','2'),('1399','潍城区','370702','1398','3'),('1400','寒亭区','370703','1398','3'),('1401','坊子区','370704','1398','3'),('1402','奎文区','370705','1398','3'),('1403','临朐县','370724','1398','3'),('1404','昌乐县','370725','1398','3'),('1405','青州市','370781','1398','3'),('1406','诸城市','370782','1398','3'),('1407','寿光市','370783','1398','3'),('1408','安丘市','370784','1398','3'),('1409','高密市','370785','1398','3'),('1410','昌邑市','370786','1398','3'),('1411','济宁市','370800','1339','2'),('1412','任城区','370811','1411','3'),('1413','兖州区','370812','1411','3'),('1414','微山县','370826','1411','3'),('1415','鱼台县','370827','1411','3'),('1416','金乡县','370828','1411','3'),('1417','嘉祥县','370829','1411','3'),('1418','汶上县','370830','1411','3'),('1419','泗水县','370831','1411','3'),('1420','梁山县','370832','1411','3'),('1421','曲阜市','370881','1411','3'),('1422','邹城市','370883','1411','3'),('1423','泰安市','370900','1339','2'),('1424','泰山区','370902','1423','3'),('1425','岱岳区','370911','1423','3'),('1426','宁阳县','370921','1423','3'),('1427','东平县','370923','1423','3'),('1428','新泰市','370982','1423','3'),('1429','肥城市','370983','1423','3'),('1430','威海市','371000','1339','2'),('1431','环翠区','371002','1430','3'),('1432','文登区','371003','1430','3'),('1433','荣成市','371082','1430','3'),('1434','乳山市','371083','1430','3'),('1435','日照市','371100','1339','2'),('1436','东港区','371102','1435','3'),('1437','岚山区','371103','1435','3'),('1438','五莲县','371121','1435','3'),('1439','莒县','371122','1435','3'),('1440','临沂市','371300','1339','2'),('1441','兰山区','371302','1440','3'),('1442','罗庄区','371311','1440','3'),('1443','河东区','371312','1440','3'),('1444','沂南县','371321','1440','3'),('1445','郯城县','371322','1440','3'),('1446','沂水县','371323','1440','3'),('1447','兰陵县','371324','1440','3'),('1448','费县','371325','1440','3'),('1449','平邑县','371326','1440','3'),('1450','莒南县','371327','1440','3'),('1451','蒙阴县','371328','1440','3'),('1452','临沭县','371329','1440','3'),('1453','德州市','371400','1339','2'),('1454','德城区','371402','1453','3'),('1455','陵城区','371403','1453','3'),('1456','宁津县','371422','1453','3'),('1457','庆云县','371423','1453','3'),('1458','临邑县','371424','1453','3'),('1459','齐河县','371425','1453','3'),('1460','平原县','371426','1453','3'),('1461','夏津县','371427','1453','3'),('1462','武城县','371428','1453','3'),('1463','乐陵市','371481','1453','3'),('1464','禹城市','371482','1453','3'),('1465','聊城市','371500','1339','2'),('1466','东昌府区','371502','1465','3'),('1467','茌平区','371503','1465','3'),('1468','阳谷县','371521','1465','3'),('1469','莘县','371522','1465','3'),('1470','东阿县','371524','1465','3'),('1471','冠县','371525','1465','3'),('1472','高唐县','371526','1465','3'),('1473','临清市','371581','1465','3'),('1474','滨州市','371600','1339','2'),('1475','滨城区','371602','1474','3'),('1476','沾化区','371603','1474','3'),('1477','惠民县','371621','1474','3'),('1478','阳信县','371622','1474','3'),('1479','无棣县','371623','1474','3'),('1480','博兴县','371625','1474','3'),('1481','邹平市','371681','1474','3'),('1482','菏泽市','371700','1339','2'),('1483','牡丹区','371702','1482','3'),('1484','定陶区','371703','1482','3'),('1485','曹县','371721','1482','3'),('1486','单县','371722','1482','3'),('1487','成武县','371723','1482','3'),('1488','巨野县','371724','1482','3'),('1489','郓城县','371725','1482','3'),('1490','鄄城县','371726','1482','3'),('1491','东明县','371728','1482','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('1492','河南省','410000','0','1'),('1493','郑州市','410100','1492','2'),('1494','中原区','410102','1493','3'),('1495','二七区','410103','1493','3'),('1496','管城回族区','410104','1493','3'),('1497','金水区','410105','1493','3'),('1498','上街区','410106','1493','3'),('1499','惠济区','410108','1493','3'),('1500','中牟县','410122','1493','3'),('1501','巩义市','410181','1493','3'),('1502','荥阳市','410182','1493','3'),('1503','新密市','410183','1493','3'),('1504','新郑市','410184','1493','3'),('1505','登封市','410185','1493','3'),('1506','开封市','410200','1492','2'),('1507','龙亭区','410202','1506','3'),('1508','顺河回族区','410203','1506','3'),('1509','鼓楼区','410204','1506','3'),('1510','禹王台区','410205','1506','3'),('1511','祥符区','410212','1506','3'),('1512','杞县','410221','1506','3'),('1513','通许县','410222','1506','3'),('1514','尉氏县','410223','1506','3'),('1515','兰考县','410225','1506','3'),('1516','洛阳市','410300','1492','2'),('1517','老城区','410302','1516','3'),('1518','西工区','410303','1516','3'),('1519','瀍河回族区','410304','1516','3'),('1520','涧西区','410305','1516','3'),('1521','吉利区','410306','1516','3'),('1522','洛龙区','410311','1516','3'),('1523','孟津县','410322','1516','3'),('1524','新安县','410323','1516','3'),('1525','栾川县','410324','1516','3'),('1526','嵩县','410325','1516','3'),('1527','汝阳县','410326','1516','3'),('1528','宜阳县','410327','1516','3'),('1529','洛宁县','410328','1516','3'),('1530','伊川县','410329','1516','3'),('1531','偃师市','410381','1516','3'),('1532','平顶山市','410400','1492','2'),('1533','新华区','410402','1532','3'),('1534','卫东区','410403','1532','3'),('1535','石龙区','410404','1532','3'),('1536','湛河区','410411','1532','3'),('1537','宝丰县','410421','1532','3'),('1538','叶县','410422','1532','3'),('1539','鲁山县','410423','1532','3'),('1540','郏县','410425','1532','3'),('1541','舞钢市','410481','1532','3'),('1542','汝州市','410482','1532','3'),('1543','安阳市','410500','1492','2'),('1544','文峰区','410502','1543','3'),('1545','北关区','410503','1543','3'),('1546','殷都区','410505','1543','3'),('1547','龙安区','410506','1543','3'),('1548','安阳县','410522','1543','3'),('1549','汤阴县','410523','1543','3'),('1550','滑县','410526','1543','3'),('1551','内黄县','410527','1543','3'),('1552','林州市','410581','1543','3'),('1553','鹤壁市','410600','1492','2'),('1554','鹤山区','410602','1553','3'),('1555','山城区','410603','1553','3'),('1556','淇滨区','410611','1553','3'),('1557','浚县','410621','1553','3'),('1558','淇县','410622','1553','3'),('1559','新乡市','410700','1492','2'),('1560','红旗区','410702','1559','3'),('1561','卫滨区','410703','1559','3'),('1562','凤泉区','410704','1559','3'),('1563','牧野区','410711','1559','3'),('1564','新乡县','410721','1559','3'),('1565','获嘉县','410724','1559','3'),('1566','原阳县','410725','1559','3'),('1567','延津县','410726','1559','3'),('1568','封丘县','410727','1559','3'),('1569','卫辉市','410781','1559','3'),('1570','辉县市','410782','1559','3'),('1571','长垣市','410783','1559','3'),('1572','焦作市','410800','1492','2'),('1573','解放区','410802','1572','3'),('1574','中站区','410803','1572','3'),('1575','马村区','410804','1572','3'),('1576','山阳区','410811','1572','3'),('1577','修武县','410821','1572','3'),('1578','博爱县','410822','1572','3'),('1579','武陟县','410823','1572','3'),('1580','温县','410825','1572','3'),('1581','沁阳市','410882','1572','3'),('1582','孟州市','410883','1572','3'),('1583','濮阳市','410900','1492','2'),('1584','华龙区','410902','1583','3'),('1585','清丰县','410922','1583','3'),('1586','南乐县','410923','1583','3'),('1587','范县','410926','1583','3'),('1588','台前县','410927','1583','3'),('1589','濮阳县','410928','1583','3'),('1590','许昌市','411000','1492','2'),('1591','魏都区','411002','1590','3'),('1592','建安区','411003','1590','3'),('1593','鄢陵县','411024','1590','3'),('1594','襄城县','411025','1590','3'),('1595','禹州市','411081','1590','3'),('1596','长葛市','411082','1590','3'),('1597','漯河市','411100','1492','2'),('1598','源汇区','411102','1597','3'),('1599','郾城区','411103','1597','3'),('1600','召陵区','411104','1597','3'),('1601','舞阳县','411121','1597','3'),('1602','临颍县','411122','1597','3'),('1603','三门峡市','411200','1492','2'),('1604','湖滨区','411202','1603','3'),('1605','陕州区','411203','1603','3'),('1606','渑池县','411221','1603','3'),('1607','卢氏县','411224','1603','3'),('1608','义马市','411281','1603','3'),('1609','灵宝市','411282','1603','3'),('1610','南阳市','411300','1492','2'),('1611','宛城区','411302','1610','3'),('1612','卧龙区','411303','1610','3'),('1613','南召县','411321','1610','3'),('1614','方城县','411322','1610','3'),('1615','西峡县','411323','1610','3'),('1616','镇平县','411324','1610','3'),('1617','内乡县','411325','1610','3'),('1618','淅川县','411326','1610','3'),('1619','社旗县','411327','1610','3'),('1620','唐河县','411328','1610','3'),('1621','新野县','411329','1610','3'),('1622','桐柏县','411330','1610','3'),('1623','邓州市','411381','1610','3'),('1624','商丘市','411400','1492','2'),('1625','梁园区','411402','1624','3'),('1626','睢阳区','411403','1624','3'),('1627','民权县','411421','1624','3'),('1628','睢县','411422','1624','3'),('1629','宁陵县','411423','1624','3'),('1630','柘城县','411424','1624','3'),('1631','虞城县','411425','1624','3'),('1632','夏邑县','411426','1624','3'),('1633','永城市','411481','1624','3'),('1634','信阳市','411500','1492','2'),('1635','浉河区','411502','1634','3'),('1636','平桥区','411503','1634','3'),('1637','罗山县','411521','1634','3'),('1638','光山县','411522','1634','3'),('1639','新县','411523','1634','3'),('1640','商城县','411524','1634','3'),('1641','固始县','411525','1634','3'),('1642','潢川县','411526','1634','3'),('1643','淮滨县','411527','1634','3'),('1644','息县','411528','1634','3'),('1645','周口市','411600','1492','2'),('1646','川汇区','411602','1645','3'),('1647','淮阳区','411603','1645','3'),('1648','扶沟县','411621','1645','3'),('1649','西华县','411622','1645','3'),('1650','商水县','411623','1645','3'),('1651','沈丘县','411624','1645','3'),('1652','郸城县','411625','1645','3'),('1653','太康县','411627','1645','3'),('1654','鹿邑县','411628','1645','3'),('1655','项城市','411681','1645','3'),('1656','驻马店市','411700','1492','2'),('1657','驿城区','411702','1656','3'),('1658','西平县','411721','1656','3'),('1659','上蔡县','411722','1656','3'),('1660','平舆县','411723','1656','3'),('1661','正阳县','411724','1656','3'),('1662','确山县','411725','1656','3'),('1663','泌阳县','411726','1656','3'),('1664','汝南县','411727','1656','3'),('1665','遂平县','411728','1656','3'),('1666','新蔡县','411729','1656','3'),('1667','济源市','419001','1492','2'),('1668','济源市','419001','1667','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('1669','湖北省','420000','0','1'),('1670','武汉市','420100','1669','2'),('1671','江岸区','420102','1670','3'),('1672','江汉区','420103','1670','3'),('1673','硚口区','420104','1670','3'),('1674','汉阳区','420105','1670','3'),('1675','武昌区','420106','1670','3'),('1676','青山区','420107','1670','3'),('1677','洪山区','420111','1670','3'),('1678','东西湖区','420112','1670','3'),('1679','汉南区','420113','1670','3'),('1680','蔡甸区','420114','1670','3'),('1681','江夏区','420115','1670','3'),('1682','黄陂区','420116','1670','3'),('1683','新洲区','420117','1670','3'),('1684','黄石市','420200','1669','2'),('1685','黄石港区','420202','1684','3'),('1686','西塞山区','420203','1684','3'),('1687','下陆区','420204','1684','3'),('1688','铁山区','420205','1684','3'),('1689','阳新县','420222','1684','3'),('1690','大冶市','420281','1684','3'),('1691','十堰市','420300','1669','2'),('1692','茅箭区','420302','1691','3'),('1693','张湾区','420303','1691','3'),('1694','郧阳区','420304','1691','3'),('1695','郧西县','420322','1691','3'),('1696','竹山县','420323','1691','3'),('1697','竹溪县','420324','1691','3'),('1698','房县','420325','1691','3'),('1699','丹江口市','420381','1691','3'),('1700','宜昌市','420500','1669','2'),('1701','西陵区','420502','1700','3'),('1702','伍家岗区','420503','1700','3'),('1703','点军区','420504','1700','3'),('1704','猇亭区','420505','1700','3'),('1705','夷陵区','420506','1700','3'),('1706','远安县','420525','1700','3'),('1707','兴山县','420526','1700','3'),('1708','秭归县','420527','1700','3'),('1709','长阳土家族自治县','420528','1700','3'),('1710','五峰土家族自治县','420529','1700','3'),('1711','宜都市','420581','1700','3'),('1712','当阳市','420582','1700','3'),('1713','枝江市','420583','1700','3'),('1714','襄阳市','420600','1669','2'),('1715','襄城区','420602','1714','3'),('1716','樊城区','420606','1714','3'),('1717','襄州区','420607','1714','3'),('1718','南漳县','420624','1714','3'),('1719','谷城县','420625','1714','3'),('1720','保康县','420626','1714','3'),('1721','老河口市','420682','1714','3'),('1722','枣阳市','420683','1714','3'),('1723','宜城市','420684','1714','3'),('1724','鄂州市','420700','1669','2'),('1725','梁子湖区','420702','1724','3'),('1726','华容区','420703','1724','3'),('1727','鄂城区','420704','1724','3'),('1728','荆门市','420800','1669','2'),('1729','东宝区','420802','1728','3'),('1730','掇刀区','420804','1728','3'),('1731','沙洋县','420822','1728','3'),('1732','钟祥市','420881','1728','3'),('1733','京山市','420882','1728','3'),('1734','孝感市','420900','1669','2'),('1735','孝南区','420902','1734','3'),('1736','孝昌县','420921','1734','3'),('1737','大悟县','420922','1734','3'),('1738','云梦县','420923','1734','3'),('1739','应城市','420981','1734','3'),('1740','安陆市','420982','1734','3'),('1741','汉川市','420984','1734','3'),('1742','荆州市','421000','1669','2'),('1743','沙市区','421002','1742','3'),('1744','荆州区','421003','1742','3'),('1745','公安县','421022','1742','3'),('1746','监利市','421023','1742','3'),('1747','江陵县','421024','1742','3'),('1748','石首市','421081','1742','3'),('1749','洪湖市','421083','1742','3'),('1750','松滋市','421087','1742','3'),('1751','黄冈市','421100','1669','2'),('1752','黄州区','421102','1751','3'),('1753','团风县','421121','1751','3'),('1754','红安县','421122','1751','3'),('1755','罗田县','421123','1751','3'),('1756','英山县','421124','1751','3'),('1757','浠水县','421125','1751','3'),('1758','蕲春县','421126','1751','3'),('1759','黄梅县','421127','1751','3'),('1760','麻城市','421181','1751','3'),('1761','武穴市','421182','1751','3'),('1762','咸宁市','421200','1669','2'),('1763','咸安区','421202','1762','3'),('1764','嘉鱼县','421221','1762','3'),('1765','通城县','421222','1762','3'),('1766','崇阳县','421223','1762','3'),('1767','通山县','421224','1762','3'),('1768','赤壁市','421281','1762','3'),('1769','随州市','421300','1669','2'),('1770','曾都区','421303','1769','3'),('1771','随县','421321','1769','3'),('1772','广水市','421381','1769','3'),('1773','恩施土家族苗族自治州','422800','1669','2'),('1774','恩施市','422801','1773','3'),('1775','利川市','422802','1773','3'),('1776','建始县','422822','1773','3'),('1777','巴东县','422823','1773','3'),('1778','宣恩县','422825','1773','3'),('1779','咸丰县','422826','1773','3'),('1780','来凤县','422827','1773','3'),('1781','鹤峰县','422828','1773','3'),('1782','仙桃市','429004','1669','2'),('1783','仙桃市','429004','1782','3'),('1784','潜江市','429005','1669','2'),('1785','潜江市','429005','1784','3'),('1786','天门市','429006','1669','2'),('1787','天门市','429006','1786','3'),('1788','神农架林区','429021','1669','2'),('1789','神农架林区','429021','1788','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('1790','湖南省','430000','0','1'),('1791','长沙市','430100','1790','2'),('1792','芙蓉区','430102','1791','3'),('1793','天心区','430103','1791','3'),('1794','岳麓区','430104','1791','3'),('1795','开福区','430105','1791','3'),('1796','雨花区','430111','1791','3'),('1797','望城区','430112','1791','3'),('1798','长沙县','430121','1791','3'),('1799','浏阳市','430181','1791','3'),('1800','宁乡市','430182','1791','3'),('1801','株洲市','430200','1790','2'),('1802','荷塘区','430202','1801','3'),('1803','芦淞区','430203','1801','3'),('1804','石峰区','430204','1801','3'),('1805','天元区','430211','1801','3'),('1806','渌口区','430212','1801','3'),('1807','攸县','430223','1801','3'),('1808','茶陵县','430224','1801','3'),('1809','炎陵县','430225','1801','3'),('1810','醴陵市','430281','1801','3'),('1811','湘潭市','430300','1790','2'),('1812','雨湖区','430302','1811','3'),('1813','岳塘区','430304','1811','3'),('1814','湘潭县','430321','1811','3'),('1815','湘乡市','430381','1811','3'),('1816','韶山市','430382','1811','3'),('1817','衡阳市','430400','1790','2'),('1818','珠晖区','430405','1817','3'),('1819','雁峰区','430406','1817','3'),('1820','石鼓区','430407','1817','3'),('1821','蒸湘区','430408','1817','3'),('1822','南岳区','430412','1817','3'),('1823','衡阳县','430421','1817','3'),('1824','衡南县','430422','1817','3'),('1825','衡山县','430423','1817','3'),('1826','衡东县','430424','1817','3'),('1827','祁东县','430426','1817','3'),('1828','耒阳市','430481','1817','3'),('1829','常宁市','430482','1817','3'),('1830','邵阳市','430500','1790','2'),('1831','双清区','430502','1830','3'),('1832','大祥区','430503','1830','3'),('1833','北塔区','430511','1830','3'),('1834','新邵县','430522','1830','3'),('1835','邵阳县','430523','1830','3'),('1836','隆回县','430524','1830','3'),('1837','洞口县','430525','1830','3'),('1838','绥宁县','430527','1830','3'),('1839','新宁县','430528','1830','3'),('1840','城步苗族自治县','430529','1830','3'),('1841','武冈市','430581','1830','3'),('1842','邵东市','430582','1830','3'),('1843','岳阳市','430600','1790','2'),('1844','岳阳楼区','430602','1843','3'),('1845','云溪区','430603','1843','3'),('1846','君山区','430611','1843','3'),('1847','岳阳县','430621','1843','3'),('1848','华容县','430623','1843','3'),('1849','湘阴县','430624','1843','3'),('1850','平江县','430626','1843','3'),('1851','汨罗市','430681','1843','3'),('1852','临湘市','430682','1843','3'),('1853','常德市','430700','1790','2'),('1854','武陵区','430702','1853','3'),('1855','鼎城区','430703','1853','3'),('1856','安乡县','430721','1853','3'),('1857','汉寿县','430722','1853','3'),('1858','澧县','430723','1853','3'),('1859','临澧县','430724','1853','3'),('1860','桃源县','430725','1853','3'),('1861','石门县','430726','1853','3'),('1862','津市市','430781','1853','3'),('1863','张家界市','430800','1790','2'),('1864','永定区','430802','1863','3'),('1865','武陵源区','430811','1863','3'),('1866','慈利县','430821','1863','3'),('1867','桑植县','430822','1863','3'),('1868','益阳市','430900','1790','2'),('1869','资阳区','430902','1868','3'),('1870','赫山区','430903','1868','3'),('1871','南县','430921','1868','3'),('1872','桃江县','430922','1868','3'),('1873','安化县','430923','1868','3'),('1874','沅江市','430981','1868','3'),('1875','郴州市','431000','1790','2'),('1876','北湖区','431002','1875','3'),('1877','苏仙区','431003','1875','3'),('1878','桂阳县','431021','1875','3'),('1879','宜章县','431022','1875','3'),('1880','永兴县','431023','1875','3'),('1881','嘉禾县','431024','1875','3'),('1882','临武县','431025','1875','3'),('1883','汝城县','431026','1875','3'),('1884','桂东县','431027','1875','3'),('1885','安仁县','431028','1875','3'),('1886','资兴市','431081','1875','3'),('1887','永州市','431100','1790','2'),('1888','零陵区','431102','1887','3'),('1889','冷水滩区','431103','1887','3'),('1890','祁阳县','431121','1887','3'),('1891','东安县','431122','1887','3'),('1892','双牌县','431123','1887','3'),('1893','道县','431124','1887','3'),('1894','江永县','431125','1887','3'),('1895','宁远县','431126','1887','3'),('1896','蓝山县','431127','1887','3'),('1897','新田县','431128','1887','3'),('1898','江华瑶族自治县','431129','1887','3'),('1899','怀化市','431200','1790','2'),('1900','鹤城区','431202','1899','3'),('1901','中方县','431221','1899','3'),('1902','沅陵县','431222','1899','3'),('1903','辰溪县','431223','1899','3'),('1904','溆浦县','431224','1899','3'),('1905','会同县','431225','1899','3'),('1906','麻阳苗族自治县','431226','1899','3'),('1907','新晃侗族自治县','431227','1899','3'),('1908','芷江侗族自治县','431228','1899','3'),('1909','靖州苗族侗族自治县','431229','1899','3'),('1910','通道侗族自治县','431230','1899','3'),('1911','洪江市','431281','1899','3'),('1912','娄底市','431300','1790','2'),('1913','娄星区','431302','1912','3'),('1914','双峰县','431321','1912','3'),('1915','新化县','431322','1912','3'),('1916','冷水江市','431381','1912','3'),('1917','涟源市','431382','1912','3'),('1918','湘西土家族苗族自治州','433100','1790','2'),('1919','吉首市','433101','1918','3'),('1920','泸溪县','433122','1918','3'),('1921','凤凰县','433123','1918','3'),('1922','花垣县','433124','1918','3'),('1923','保靖县','433125','1918','3'),('1924','古丈县','433126','1918','3'),('1925','永顺县','433127','1918','3'),('1926','龙山县','433130','1918','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('1927','广东省','440000','0','1'),('1928','广州市','440100','1927','2'),('1929','荔湾区','440103','1928','3'),('1930','越秀区','440104','1928','3'),('1931','海珠区','440105','1928','3'),('1932','天河区','440106','1928','3'),('1933','白云区','440111','1928','3'),('1934','黄埔区','440112','1928','3'),('1935','番禺区','440113','1928','3'),('1936','花都区','440114','1928','3'),('1937','南沙区','440115','1928','3'),('1938','从化区','440117','1928','3'),('1939','增城区','440118','1928','3'),('1940','韶关市','440200','1927','2'),('1941','武江区','440203','1940','3'),('1942','浈江区','440204','1940','3'),('1943','曲江区','440205','1940','3'),('1944','始兴县','440222','1940','3'),('1945','仁化县','440224','1940','3'),('1946','翁源县','440229','1940','3'),('1947','乳源瑶族自治县','440232','1940','3'),('1948','新丰县','440233','1940','3'),('1949','乐昌市','440281','1940','3'),('1950','南雄市','440282','1940','3'),('1951','深圳市','440300','1927','2'),('1952','罗湖区','440303','1951','3'),('1953','福田区','440304','1951','3'),('1954','南山区','440305','1951','3'),('1955','宝安区','440306','1951','3'),('1956','龙岗区','440307','1951','3'),('1957','盐田区','440308','1951','3'),('1958','龙华区','440309','1951','3'),('1959','坪山区','440310','1951','3'),('1960','光明区','440311','1951','3'),('1961','珠海市','440400','1927','2'),('1962','香洲区','440402','1961','3'),('1963','斗门区','440403','1961','3'),('1964','金湾区','440404','1961','3'),('1965','汕头市','440500','1927','2'),('1966','龙湖区','440507','1965','3'),('1967','金平区','440511','1965','3'),('1968','濠江区','440512','1965','3'),('1969','潮阳区','440513','1965','3'),('1970','潮南区','440514','1965','3'),('1971','澄海区','440515','1965','3'),('1972','南澳县','440523','1965','3'),('1973','佛山市','440600','1927','2'),('1974','禅城区','440604','1973','3'),('1975','南海区','440605','1973','3'),('1976','顺德区','440606','1973','3'),('1977','三水区','440607','1973','3'),('1978','高明区','440608','1973','3'),('1979','江门市','440700','1927','2'),('1980','蓬江区','440703','1979','3'),('1981','江海区','440704','1979','3'),('1982','新会区','440705','1979','3'),('1983','台山市','440781','1979','3'),('1984','开平市','440783','1979','3'),('1985','鹤山市','440784','1979','3'),('1986','恩平市','440785','1979','3'),('1987','湛江市','440800','1927','2'),('1988','赤坎区','440802','1987','3'),('1989','霞山区','440803','1987','3'),('1990','坡头区','440804','1987','3'),('1991','麻章区','440811','1987','3'),('1992','遂溪县','440823','1987','3'),('1993','徐闻县','440825','1987','3'),('1994','廉江市','440881','1987','3'),('1995','雷州市','440882','1987','3'),('1996','吴川市','440883','1987','3'),('1997','茂名市','440900','1927','2'),('1998','茂南区','440902','1997','3'),('1999','电白区','440904','1997','3'),('2000','高州市','440981','1997','3'),('2001','化州市','440982','1997','3'),('2002','信宜市','440983','1997','3'),('2003','肇庆市','441200','1927','2'),('2004','端州区','441202','2003','3'),('2005','鼎湖区','441203','2003','3'),('2006','高要区','441204','2003','3'),('2007','广宁县','441223','2003','3'),('2008','怀集县','441224','2003','3'),('2009','封开县','441225','2003','3'),('2010','德庆县','441226','2003','3'),('2011','四会市','441284','2003','3'),('2012','惠州市','441300','1927','2'),('2013','惠城区','441302','2012','3'),('2014','惠阳区','441303','2012','3'),('2015','博罗县','441322','2012','3'),('2016','惠东县','441323','2012','3'),('2017','龙门县','441324','2012','3'),('2018','梅州市','441400','1927','2'),('2019','梅江区','441402','2018','3'),('2020','梅县区','441403','2018','3'),('2021','大埔县','441422','2018','3'),('2022','丰顺县','441423','2018','3'),('2023','五华县','441424','2018','3'),('2024','平远县','441426','2018','3'),('2025','蕉岭县','441427','2018','3'),('2026','兴宁市','441481','2018','3'),('2027','汕尾市','441500','1927','2'),('2028','城区','441502','2027','3'),('2029','海丰县','441521','2027','3'),('2030','陆河县','441523','2027','3'),('2031','陆丰市','441581','2027','3'),('2032','河源市','441600','1927','2'),('2033','源城区','441602','2032','3'),('2034','紫金县','441621','2032','3'),('2035','龙川县','441622','2032','3'),('2036','连平县','441623','2032','3'),('2037','和平县','441624','2032','3'),('2038','东源县','441625','2032','3'),('2039','阳江市','441700','1927','2'),('2040','江城区','441702','2039','3'),('2041','阳东区','441704','2039','3'),('2042','阳西县','441721','2039','3'),('2043','阳春市','441781','2039','3'),('2044','清远市','441800','1927','2'),('2045','清城区','441802','2044','3'),('2046','清新区','441803','2044','3'),('2047','佛冈县','441821','2044','3'),('2048','阳山县','441823','2044','3'),('2049','连山壮族瑶族自治县','441825','2044','3'),('2050','连南瑶族自治县','441826','2044','3'),('2051','英德市','441881','2044','3'),('2052','连州市','441882','2044','3'),('2053','东莞市','441900','1927','2'),('2054','东莞市','441900','2053','3'),('2055','中山市','442000','1927','2'),('2056','中山市','442000','2055','3'),('2057','潮州市','445100','1927','2'),('2058','湘桥区','445102','2057','3'),('2059','潮安区','445103','2057','3'),('2060','饶平县','445122','2057','3'),('2061','揭阳市','445200','1927','2'),('2062','榕城区','445202','2061','3'),('2063','揭东区','445203','2061','3'),('2064','揭西县','445222','2061','3'),('2065','惠来县','445224','2061','3'),('2066','普宁市','445281','2061','3'),('2067','云浮市','445300','1927','2'),('2068','云城区','445302','2067','3'),('2069','云安区','445303','2067','3'),('2070','新兴县','445321','2067','3'),('2071','郁南县','445322','2067','3'),('2072','罗定市','445381','2067','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('2073','广西壮族自治区','450000','0','1'),('2074','南宁市','450100','2073','2'),('2075','兴宁区','450102','2074','3'),('2076','青秀区','450103','2074','3'),('2077','江南区','450105','2074','3'),('2078','西乡塘区','450107','2074','3'),('2079','良庆区','450108','2074','3'),('2080','邕宁区','450109','2074','3'),('2081','武鸣区','450110','2074','3'),('2082','隆安县','450123','2074','3'),('2083','马山县','450124','2074','3'),('2084','上林县','450125','2074','3'),('2085','宾阳县','450126','2074','3'),('2086','横州市','450127','2074','3'),('2087','柳州市','450200','2073','2'),('2088','城中区','450202','2087','3'),('2089','鱼峰区','450203','2087','3'),('2090','柳南区','450204','2087','3'),('2091','柳北区','450205','2087','3'),('2092','柳江区','450206','2087','3'),('2093','柳城县','450222','2087','3'),('2094','鹿寨县','450223','2087','3'),('2095','融安县','450224','2087','3'),('2096','融水苗族自治县','450225','2087','3'),('2097','三江侗族自治县','450226','2087','3'),('2098','桂林市','450300','2073','2'),('2099','秀峰区','450302','2098','3'),('2100','叠彩区','450303','2098','3'),('2101','象山区','450304','2098','3'),('2102','七星区','450305','2098','3'),('2103','雁山区','450311','2098','3'),('2104','临桂区','450312','2098','3'),('2105','阳朔县','450321','2098','3'),('2106','灵川县','450323','2098','3'),('2107','全州县','450324','2098','3'),('2108','兴安县','450325','2098','3'),('2109','永福县','450326','2098','3'),('2110','灌阳县','450327','2098','3'),('2111','龙胜各族自治县','450328','2098','3'),('2112','资源县','450329','2098','3'),('2113','平乐县','450330','2098','3'),('2114','恭城瑶族自治县','450332','2098','3'),('2115','荔浦市','450381','2098','3'),('2116','梧州市','450400','2073','2'),('2117','万秀区','450403','2116','3'),('2118','长洲区','450405','2116','3'),('2119','龙圩区','450406','2116','3'),('2120','苍梧县','450421','2116','3'),('2121','藤县','450422','2116','3'),('2122','蒙山县','450423','2116','3'),('2123','岑溪市','450481','2116','3'),('2124','北海市','450500','2073','2'),('2125','海城区','450502','2124','3'),('2126','银海区','450503','2124','3'),('2127','铁山港区','450512','2124','3'),('2128','合浦县','450521','2124','3'),('2129','防城港市','450600','2073','2'),('2130','港口区','450602','2129','3'),('2131','防城区','450603','2129','3'),('2132','上思县','450621','2129','3'),('2133','东兴市','450681','2129','3'),('2134','钦州市','450700','2073','2'),('2135','钦南区','450702','2134','3'),('2136','钦北区','450703','2134','3'),('2137','灵山县','450721','2134','3'),('2138','浦北县','450722','2134','3'),('2139','贵港市','450800','2073','2'),('2140','港北区','450802','2139','3'),('2141','港南区','450803','2139','3'),('2142','覃塘区','450804','2139','3'),('2143','平南县','450821','2139','3'),('2144','桂平市','450881','2139','3'),('2145','玉林市','450900','2073','2'),('2146','玉州区','450902','2145','3'),('2147','福绵区','450903','2145','3'),('2148','容县','450921','2145','3'),('2149','陆川县','450922','2145','3'),('2150','博白县','450923','2145','3'),('2151','兴业县','450924','2145','3'),('2152','北流市','450981','2145','3'),('2153','百色市','451000','2073','2'),('2154','右江区','451002','2153','3'),('2155','田阳区','451003','2153','3'),('2156','田东县','451022','2153','3'),('2157','德保县','451024','2153','3'),('2158','那坡县','451026','2153','3'),('2159','凌云县','451027','2153','3'),('2160','乐业县','451028','2153','3'),('2161','田林县','451029','2153','3'),('2162','西林县','451030','2153','3'),('2163','隆林各族自治县','451031','2153','3'),('2164','靖西市','451081','2153','3'),('2165','平果市','451082','2153','3'),('2166','贺州市','451100','2073','2'),('2167','八步区','451102','2166','3'),('2168','平桂区','451103','2166','3'),('2169','昭平县','451121','2166','3'),('2170','钟山县','451122','2166','3'),('2171','富川瑶族自治县','451123','2166','3'),('2172','河池市','451200','2073','2'),('2173','金城江区','451202','2172','3'),('2174','宜州区','451203','2172','3'),('2175','南丹县','451221','2172','3'),('2176','天峨县','451222','2172','3'),('2177','凤山县','451223','2172','3'),('2178','东兰县','451224','2172','3'),('2179','罗城仫佬族自治县','451225','2172','3'),('2180','环江毛南族自治县','451226','2172','3'),('2181','巴马瑶族自治县','451227','2172','3'),('2182','都安瑶族自治县','451228','2172','3'),('2183','大化瑶族自治县','451229','2172','3'),('2184','来宾市','451300','2073','2'),('2185','兴宾区','451302','2184','3'),('2186','忻城县','451321','2184','3'),('2187','象州县','451322','2184','3'),('2188','武宣县','451323','2184','3'),('2189','金秀瑶族自治县','451324','2184','3'),('2190','合山市','451381','2184','3'),('2191','崇左市','451400','2073','2'),('2192','江州区','451402','2191','3'),('2193','扶绥县','451421','2191','3'),('2194','宁明县','451422','2191','3'),('2195','龙州县','451423','2191','3'),('2196','大新县','451424','2191','3'),('2197','天等县','451425','2191','3'),('2198','凭祥市','451481','2191','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('2199','海南省','460000','0','1'),('2200','海口市','460100','2199','2'),('2201','秀英区','460105','2200','3'),('2202','龙华区','460106','2200','3'),('2203','琼山区','460107','2200','3'),('2204','美兰区','460108','2200','3'),('2205','三亚市','460200','2199','2'),('2206','海棠区','460202','2205','3'),('2207','吉阳区','460203','2205','3'),('2208','天涯区','460204','2205','3'),('2209','崖州区','460205','2205','3'),('2210','三沙市','460300','2199','2'),('2211','西沙区','460301','2210','3'),('2212','南沙区','460302','2210','3'),('2213','儋州市','460400','2199','2'),('2214','儋州市','460400','2213','3'),('2215','五指山市','469001','2199','2'),('2216','五指山市','469001','2215','3'),('2217','琼海市','469002','2199','2'),('2218','琼海市','469002','2217','3'),('2219','文昌市','469005','2199','2'),('2220','文昌市','469005','2219','3'),('2221','万宁市','469006','2199','2'),('2222','万宁市','469006','2221','3'),('2223','东方市','469007','2199','2'),('2224','东方市','469007','2223','3'),('2225','定安县','469021','2199','2'),('2226','定安县','469021','2225','3'),('2227','屯昌县','469022','2199','2'),('2228','屯昌县','469022','2227','3'),('2229','澄迈县','469023','2199','2'),('2230','澄迈县','469023','2229','3'),('2231','临高县','469024','2199','2'),('2232','临高县','469024','2231','3'),('2233','白沙黎族自治县','469025','2199','2'),('2234','白沙黎族自治县','469025','2233','3'),('2235','昌江黎族自治县','469026','2199','2'),('2236','昌江黎族自治县','469026','2235','3'),('2237','乐东黎族自治县','469027','2199','2'),('2238','乐东黎族自治县','469027','2237','3'),('2239','陵水黎族自治县','469028','2199','2'),('2240','陵水黎族自治县','469028','2239','3'),('2241','保亭黎族苗族自治县','469029','2199','2'),('2242','保亭黎族苗族自治县','469029','2241','3'),('2243','琼中黎族苗族自治县','469030','2199','2'),('2244','琼中黎族苗族自治县','469030','2243','3'),('2245','重庆市','500000','0','1'),('2246','重庆城区','500100','2245','2'),('2247','万州区','500101','2246','3'),('2248','涪陵区','500102','2246','3'),('2249','渝中区','500103','2246','3'),('2250','大渡口区','500104','2246','3'),('2251','江北区','500105','2246','3'),('2252','沙坪坝区','500106','2246','3'),('2253','九龙坡区','500107','2246','3'),('2254','南岸区','500108','2246','3'),('2255','北碚区','500109','2246','3'),('2256','綦江区','500110','2246','3'),('2257','大足区','500111','2246','3'),('2258','渝北区','500112','2246','3'),('2259','巴南区','500113','2246','3'),('2260','黔江区','500114','2246','3'),('2261','长寿区','500115','2246','3'),('2262','江津区','500116','2246','3'),('2263','合川区','500117','2246','3'),('2264','永川区','500118','2246','3'),('2265','南川区','500119','2246','3'),('2266','璧山区','500120','2246','3'),('2267','铜梁区','500151','2246','3'),('2268','潼南区','500152','2246','3'),('2269','荣昌区','500153','2246','3'),('2270','开州区','500154','2246','3'),('2271','梁平区','500155','2246','3'),('2272','武隆区','500156','2246','3'),('2273','重庆郊县','500200','2245','2'),('2274','城口县','500229','2273','3'),('2275','丰都县','500230','2273','3'),('2276','垫江县','500231','2273','3'),('2277','忠县','500233','2273','3'),('2278','云阳县','500235','2273','3'),('2279','奉节县','500236','2273','3'),('2280','巫山县','500237','2273','3'),('2281','巫溪县','500238','2273','3'),('2282','石柱土家族自治县','500240','2273','3'),('2283','秀山土家族苗族自治县','500241','2273','3'),('2284','酉阳土家族苗族自治县','500242','2273','3'),('2285','彭水苗族土家族自治县','500243','2273','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('2286','四川省','510000','0','1'),('2287','成都市','510100','2286','2'),('2288','锦江区','510104','2287','3'),('2289','青羊区','510105','2287','3'),('2290','金牛区','510106','2287','3'),('2291','武侯区','510107','2287','3'),('2292','成华区','510108','2287','3'),('2293','龙泉驿区','510112','2287','3'),('2294','青白江区','510113','2287','3'),('2295','新都区','510114','2287','3'),('2296','温江区','510115','2287','3'),('2297','双流区','510116','2287','3'),('2298','郫都区','510117','2287','3'),('2299','新津区','510118','2287','3'),('2300','金堂县','510121','2287','3'),('2301','大邑县','510129','2287','3'),('2302','蒲江县','510131','2287','3'),('2303','都江堰市','510181','2287','3'),('2304','彭州市','510182','2287','3'),('2305','邛崃市','510183','2287','3'),('2306','崇州市','510184','2287','3'),('2307','简阳市','510185','2287','3'),('2308','自贡市','510300','2286','2'),('2309','自流井区','510302','2308','3'),('2310','贡井区','510303','2308','3'),('2311','大安区','510304','2308','3'),('2312','沿滩区','510311','2308','3'),('2313','荣县','510321','2308','3'),('2314','富顺县','510322','2308','3'),('2315','攀枝花市','510400','2286','2'),('2316','东区','510402','2315','3'),('2317','西区','510403','2315','3'),('2318','仁和区','510411','2315','3'),('2319','米易县','510421','2315','3'),('2320','盐边县','510422','2315','3'),('2321','泸州市','510500','2286','2'),('2322','江阳区','510502','2321','3'),('2323','纳溪区','510503','2321','3'),('2324','龙马潭区','510504','2321','3'),('2325','泸县','510521','2321','3'),('2326','合江县','510522','2321','3'),('2327','叙永县','510524','2321','3'),('2328','古蔺县','510525','2321','3'),('2329','德阳市','510600','2286','2'),('2330','旌阳区','510603','2329','3'),('2331','罗江区','510604','2329','3'),('2332','中江县','510623','2329','3'),('2333','广汉市','510681','2329','3'),('2334','什邡市','510682','2329','3'),('2335','绵竹市','510683','2329','3'),('2336','绵阳市','510700','2286','2'),('2337','涪城区','510703','2336','3'),('2338','游仙区','510704','2336','3'),('2339','安州区','510705','2336','3'),('2340','三台县','510722','2336','3'),('2341','盐亭县','510723','2336','3'),('2342','梓潼县','510725','2336','3'),('2343','北川羌族自治县','510726','2336','3'),('2344','平武县','510727','2336','3'),('2345','江油市','510781','2336','3'),('2346','广元市','510800','2286','2'),('2347','利州区','510802','2346','3'),('2348','昭化区','510811','2346','3'),('2349','朝天区','510812','2346','3'),('2350','旺苍县','510821','2346','3'),('2351','青川县','510822','2346','3'),('2352','剑阁县','510823','2346','3'),('2353','苍溪县','510824','2346','3'),('2354','遂宁市','510900','2286','2'),('2355','船山区','510903','2354','3'),('2356','安居区','510904','2354','3'),('2357','蓬溪县','510921','2354','3'),('2358','大英县','510923','2354','3'),('2359','射洪市','510981','2354','3'),('2360','内江市','511000','2286','2'),('2361','市中区','511002','2360','3'),('2362','东兴区','511011','2360','3'),('2363','威远县','511024','2360','3'),('2364','资中县','511025','2360','3'),('2365','隆昌市','511083','2360','3'),('2366','乐山市','511100','2286','2'),('2367','市中区','511102','2366','3'),('2368','沙湾区','511111','2366','3'),('2369','五通桥区','511112','2366','3'),('2370','金口河区','511113','2366','3'),('2371','犍为县','511123','2366','3'),('2372','井研县','511124','2366','3'),('2373','夹江县','511126','2366','3'),('2374','沐川县','511129','2366','3'),('2375','峨边彝族自治县','511132','2366','3'),('2376','马边彝族自治县','511133','2366','3'),('2377','峨眉山市','511181','2366','3'),('2378','南充市','511300','2286','2'),('2379','顺庆区','511302','2378','3'),('2380','高坪区','511303','2378','3'),('2381','嘉陵区','511304','2378','3'),('2382','南部县','511321','2378','3'),('2383','营山县','511322','2378','3'),('2384','蓬安县','511323','2378','3'),('2385','仪陇县','511324','2378','3'),('2386','西充县','511325','2378','3'),('2387','阆中市','511381','2378','3'),('2388','眉山市','511400','2286','2'),('2389','东坡区','511402','2388','3'),('2390','彭山区','511403','2388','3'),('2391','仁寿县','511421','2388','3'),('2392','洪雅县','511423','2388','3'),('2393','丹棱县','511424','2388','3'),('2394','青神县','511425','2388','3'),('2395','宜宾市','511500','2286','2'),('2396','翠屏区','511502','2395','3'),('2397','南溪区','511503','2395','3'),('2398','叙州区','511504','2395','3'),('2399','江安县','511523','2395','3'),('2400','长宁县','511524','2395','3'),('2401','高县','511525','2395','3'),('2402','珙县','511526','2395','3'),('2403','筠连县','511527','2395','3'),('2404','兴文县','511528','2395','3'),('2405','屏山县','511529','2395','3'),('2406','广安市','511600','2286','2'),('2407','广安区','511602','2406','3'),('2408','前锋区','511603','2406','3'),('2409','岳池县','511621','2406','3'),('2410','武胜县','511622','2406','3'),('2411','邻水县','511623','2406','3'),('2412','华蓥市','511681','2406','3'),('2413','达州市','511700','2286','2'),('2414','通川区','511702','2413','3'),('2415','达川区','511703','2413','3'),('2416','宣汉县','511722','2413','3'),('2417','开江县','511723','2413','3'),('2418','大竹县','511724','2413','3'),('2419','渠县','511725','2413','3'),('2420','万源市','511781','2413','3'),('2421','雅安市','511800','2286','2'),('2422','雨城区','511802','2421','3'),('2423','名山区','511803','2421','3'),('2424','荥经县','511822','2421','3'),('2425','汉源县','511823','2421','3'),('2426','石棉县','511824','2421','3'),('2427','天全县','511825','2421','3'),('2428','芦山县','511826','2421','3'),('2429','宝兴县','511827','2421','3'),('2430','巴中市','511900','2286','2'),('2431','巴州区','511902','2430','3'),('2432','恩阳区','511903','2430','3'),('2433','通江县','511921','2430','3'),('2434','南江县','511922','2430','3'),('2435','平昌县','511923','2430','3'),('2436','资阳市','512000','2286','2'),('2437','雁江区','512002','2436','3'),('2438','安岳县','512021','2436','3'),('2439','乐至县','512022','2436','3'),('2440','阿坝藏族羌族自治州','513200','2286','2'),('2441','马尔康市','513201','2440','3'),('2442','汶川县','513221','2440','3'),('2443','理县','513222','2440','3'),('2444','茂县','513223','2440','3'),('2445','松潘县','513224','2440','3'),('2446','九寨沟县','513225','2440','3'),('2447','金川县','513226','2440','3'),('2448','小金县','513227','2440','3'),('2449','黑水县','513228','2440','3'),('2450','壤塘县','513230','2440','3'),('2451','阿坝县','513231','2440','3'),('2452','若尔盖县','513232','2440','3'),('2453','红原县','513233','2440','3'),('2454','甘孜藏族自治州','513300','2286','2'),('2455','康定市','513301','2454','3'),('2456','泸定县','513322','2454','3'),('2457','丹巴县','513323','2454','3'),('2458','九龙县','513324','2454','3'),('2459','雅江县','513325','2454','3'),('2460','道孚县','513326','2454','3'),('2461','炉霍县','513327','2454','3'),('2462','甘孜县','513328','2454','3'),('2463','新龙县','513329','2454','3'),('2464','德格县','513330','2454','3'),('2465','白玉县','513331','2454','3'),('2466','石渠县','513332','2454','3'),('2467','色达县','513333','2454','3'),('2468','理塘县','513334','2454','3'),('2469','巴塘县','513335','2454','3'),('2470','乡城县','513336','2454','3'),('2471','稻城县','513337','2454','3'),('2472','得荣县','513338','2454','3'),('2473','凉山彝族自治州','513400','2286','2'),('2474','西昌市','513401','2473','3'),('2475','木里藏族自治县','513422','2473','3'),('2476','盐源县','513423','2473','3'),('2477','德昌县','513424','2473','3'),('2478','会理市','513425','2473','3'),('2479','会东县','513426','2473','3'),('2480','宁南县','513427','2473','3'),('2481','普格县','513428','2473','3'),('2482','布拖县','513429','2473','3'),('2483','金阳县','513430','2473','3'),('2484','昭觉县','513431','2473','3'),('2485','喜德县','513432','2473','3'),('2486','冕宁县','513433','2473','3'),('2487','越西县','513434','2473','3'),('2488','甘洛县','513435','2473','3'),('2489','美姑县','513436','2473','3'),('2490','雷波县','513437','2473','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values ('2491','贵州省','520000','0','1'),('2492','贵阳市','520100','2491','2'),('2493','南明区','520102','2492','3'),('2494','云岩区','520103','2492','3'),('2495','花溪区','520111','2492','3'),('2496','乌当区','520112','2492','3'),('2497','白云区','520113','2492','3'),('2498','观山湖区','520115','2492','3'),('2499','开阳县','520121','2492','3'),('2500','息烽县','520122','2492','3'),('2501','修文县','520123','2492','3'),('2502','清镇市','520181','2492','3'),('2503','六盘水市','520200','2491','2'),('2504','钟山区','520201','2503','3'),('2505','六枝特区','520203','2503','3'),('2506','水城区','520221','2503','3'),('2507','盘州市','520281','2503','3'),('2508','遵义市','520300','2491','2'),('2509','红花岗区','520302','2508','3'),('2510','汇川区','520303','2508','3'),('2511','播州区','520304','2508','3'),('2512','桐梓县','520322','2508','3'),('2513','绥阳县','520323','2508','3'),('2514','正安县','520324','2508','3'),('2515','道真仡佬族苗族自治县','520325','2508','3'),('2516','务川仡佬族苗族自治县','520326','2508','3'),('2517','凤冈县','520327','2508','3'),('2518','湄潭县','520328','2508','3'),('2519','余庆县','520329','2508','3'),('2520','习水县','520330','2508','3'),('2521','赤水市','520381','2508','3'),('2522','仁怀市','520382','2508','3'),('2523','安顺市','520400','2491','2'),('2524','西秀区','520402','2523','3'),('2525','平坝区','520403','2523','3'),('2526','普定县','520422','2523','3'),('2527','镇宁布依族苗族自治县','520423','2523','3'),('2528','关岭布依族苗族自治县','520424','2523','3'),('2529','紫云苗族布依族自治县','520425','2523','3'),('2530','毕节市','520500','2491','2'),('2531','七星关区','520502','2530','3'),('2532','大方县','520521','2530','3'),('2533','黔西县','520522','2530','3'),('2534','金沙县','520523','2530','3'),('2535','织金县','520524','2530','3'),('2536','纳雍县','520525','2530','3'),('2537','威宁彝族回族苗族自治县','520526','2530','3'),('2538','赫章县','520527','2530','3'),('2539','铜仁市','520600','2491','2'),('2540','碧江区','520602','2539','3'),('2541','万山区','520603','2539','3'),('2542','江口县','520621','2539','3'),('2543','玉屏侗族自治县','520622','2539','3'),('2544','石阡县','520623','2539','3'),('2545','思南县','520624','2539','3'),('2546','印江土家族苗族自治县','520625','2539','3'),('2547','德江县','520626','2539','3'),('2548','沿河土家族自治县','520627','2539','3'),('2549','松桃苗族自治县','520628','2539','3'),('2550','黔西南布依族苗族自治州','522300','2491','2'),('2551','兴义市','522301','2550','3'),('2552','兴仁市','522302','2550','3'),('2553','普安县','522323','2550','3'),('2554','晴隆县','522324','2550','3'),('2555','贞丰县','522325','2550','3'),('2556','望谟县','522326','2550','3'),('2557','册亨县','522327','2550','3'),('2558','安龙县','522328','2550','3'),('2559','黔东南苗族侗族自治州','522600','2491','2'),('2560','凯里市','522601','2559','3'),('2561','黄平县','522622','2559','3'),('2562','施秉县','522623','2559','3'),('2563','三穗县','522624','2559','3'),('2564','镇远县','522625','2559','3'),('2565','岑巩县','522626','2559','3'),('2566','天柱县','522627','2559','3'),('2567','锦屏县','522628','2559','3'),('2568','剑河县','522629','2559','3'),('2569','台江县','522630','2559','3'),('2570','黎平县','522631','2559','3'),('2571','榕江县','522632','2559','3'),('2572','从江县','522633','2559','3'),('2573','雷山县','522634','2559','3'),('2574','麻江县','522635','2559','3'),('2575','丹寨县','522636','2559','3'),('2576','黔南布依族苗族自治州','522700','2491','2'),('2577','都匀市','522701','2576','3'),('2578','福泉市','522702','2576','3'),('2579','荔波县','522722','2576','3'),('2580','贵定县','522723','2576','3'),('2581','瓮安县','522725','2576','3'),('2582','独山县','522726','2576','3'),('2583','平塘县','522727','2576','3'),('2584','罗甸县','522728','2576','3'),('2585','长顺县','522729','2576','3'),('2586','龙里县','522730','2576','3'),('2587','惠水县','522731','2576','3'),('2588','三都水族自治县','522732','2576','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values('2589','云南省','530000','0','1'),('2590','昆明市','530100','2589','2'),('2591','五华区','530102','2580','3'),('2592','盘龙区','530103','2580','3'),('2593','官渡区','530111','2580','3'),('2594','西山区','530112','2580','3'),('2595','东川区','530113','2580','3'),('2596','呈贡区','530114','2580','3'),('2597','晋宁区','530115','2580','3'),('2598','富民县','530124','2580','3'),('2599','宜良县','530125','2580','3'),('2600','石林彝族自治县','530126','2580','3'),('2601','嵩明县','530127','2580','3'),('2602','禄劝彝族苗族自治县','530128','2580','3'),('2603','寻甸回族彝族自治县','530129','2580','3'),('2604','安宁市','530181','2580','3'),('2605','曲靖市','530300','2589','2'),('2606','麒麟区','530302','2605','3'),('2607','沾益区','530303','2605','3'),('2608','马龙区','530304','2605','3'),('2609','陆良县','530322','2605','3'),('2610','师宗县','530323','2605','3'),('2611','罗平县','530324','2605','3'),('2612','富源县','530325','2605','3'),('2613','会泽县','530326','2605','3'),('2614','宣威市','530381','2605','3'),('2615','玉溪市','530400','2589','2'),('2616','红塔区','530402','2615','3'),('2617','江川区','530403','2615','3'),('2618','通海县','530423','2615','3'),('2619','华宁县','530424','2615','3'),('2620','易门县','530425','2615','3'),('2621','峨山彝族自治县','530426','2615','3'),('2622','新平彝族傣族自治县','530427','2615','3'),('2623','元江哈尼族彝族傣族自治','530428','2615','3'),('2624','澄江市','530481','2615','3'),('2625','保山市','530500','2589','2'),('2626','隆阳区','530502','2625','3'),('2627','施甸县','530521','2625','3'),('2628','龙陵县','530523','2625','3'),('2629','昌宁县','530524','2625','3'),('2630','腾冲市','530581','2625','3'),('2631','昭通市','530600','2589','2'),('2632','昭阳区','530602','2631','3'),('2633','鲁甸县','530621','2631','3'),('2634','巧家县','530622','2631','3'),('2635','盐津县','530623','2631','3'),('2636','大关县','530624','2631','3'),('2637','永善县','530625','2631','3'),('2638','绥江县','530626','2631','3'),('2639','镇雄县','530627','2631','3'),('2640','彝良县','530628','2631','3'),('2641','威信县','530629','2631','3'),('2642','水富市','530681','2631','3'),('2643','丽江市','530700','2589','2'),('2644','古城区','530702','2643','3'),('2645','玉龙纳西族自治县','530721','2643','3'),('2646','永胜县','530722','2643','3'),('2647','华坪县','530723','2643','3'),('2648','宁蒗彝族自治县','530724','2643','3'),('2649','普洱市','530800','2589','2'),('2650','思茅区','530802','2649','3'),('2651','宁洱哈尼族彝族自治县','530821','2649','3'),('2652','墨江哈尼族自治县','530822','2649','3'),('2653','景东彝族自治县','530823','2649','3'),('2654','景谷傣族彝族自治县','530824','2649','3'),('2655','镇沅彝族哈尼族拉祜族自','530825','2649','3'),('2656','江城哈尼族彝族自治县','530826','2649','3'),('2657','孟连傣族拉祜族佤族自治','530827','2649','3'),('2658','澜沧拉祜族自治县','530828','2649','3'),('2659','西盟佤族自治县','530829','2649','3'),('2660','临沧市','530900','2589','2'),('2661','临翔区','530902','2660','3'),('2662','凤庆县','530921','2660','3'),('2663','云县','530922','2660','3'),('2664','永德县','530923','2660','3'),('2665','镇康县','530924','2660','3'),('2666','双江拉祜族佤族布朗族傣','530925','2660','3'),('2667','耿马傣族佤族自治县','530926','2660','3'),('2668','沧源佤族自治县','530927','2660','3'),('2669','楚雄彝族自治州','532300','2589','2'),('2670','楚雄市','532301','2669','3'),('2671','双柏县','532322','2669','3'),('2672','牟定县','532323','2669','3'),('2673','南华县','532324','2669','3'),('2674','姚安县','532325','2669','3'),('2675','大姚县','532326','2669','3'),('2676','永仁县','532327','2669','3'),('2677','元谋县','532328','2669','3'),('2678','武定县','532329','2669','3'),('2679','禄丰市','532331','2669','3'),('2680','红河哈尼族彝族自治州','532500','2589','2'),('2681','个旧市','532501','2680','3'),('2682','开远市','532502','2680','3'),('2683','蒙自市','532503','2680','3'),('2684','弥勒市','532504','2680','3'),('2685','屏边苗族自治县','532523','2680','3'),('2686','建水县','532524','2680','3'),('2687','石屏县','532525','2680','3'),('2688','泸西县','532527','2680','3'),('2689','元阳县','532528','2680','3'),('2690','红河县','532529','2680','3'),('2691','金平苗族瑶族傣族自治县','532530','2680','3'),('2692','绿春县','532531','2680','3'),('2693','河口瑶族自治县','532532','2680','3'),('2694','文山壮族苗族自治州','532600','2589','2'),('2695','文山市','532601','2694','3'),('2696','砚山县','532622','2694','3'),('2697','西畴县','532623','2694','3'),('2698','麻栗坡县','532624','2694','3'),('2699','马关县','532625','2694','3'),('2700','丘北县','532626','2694','3'),('2701','广南县','532627','2694','3'),('2702','富宁县','532628','2694','3'),('2703','西双版纳傣族自治州','532800','2589','2'),('2704','景洪市','532801','2703','3'),('2705','勐海县','532822','2703','3'),('2706','勐腊县','532823','2703','3'),('2707','大理白族自治州','532900','2589','2'),('2708','大理市','532901','2707','3'),('2709','漾濞彝族自治县','532922','2707','3'),('2710','祥云县','532923','2707','3'),('2711','宾川县','532924','2707','3'),('2712','弥渡县','532925','2707','3'),('2713','南涧彝族自治县','532926','2707','3'),('2714','巍山彝族回族自治县','532927','2707','3'),('2715','永平县','532928','2707','3'),('2716','云龙县','532929','2707','3'),('2717','洱源县','532930','2707','3'),('2718','剑川县','532931','2707','3'),('2719','鹤庆县','532932','2707','3'),('2720','德宏傣族景颇族自治州','533100','2589','2'),('2721','瑞丽市','533102','2720','3'),('2722','芒市','533103','2720','3'),('2723','梁河县','533122','2720','3'),('2724','盈江县','533123','2720','3'),('2725','陇川县','533124','2720','3'),('2726','怒江傈僳族自治州','533300','2589','2'),('2727','泸水市','533301','2726','3'),('2728','福贡县','533323','2726','3'),('2729','贡山独龙族怒族自治县','533324','2726','3'),('2730','兰坪白族普米族自治县','533325','2726','3'),('2731','迪庆藏族自治州','533400','2589','2'),('2732','香格里拉市','533401','2731','3'),('2733','德钦县','533422','2731','3'),('2734','维西傈僳族自治县','533423','2731','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values('2735','西藏自治区','540000','0','1'),('2736','拉萨市','540100','2735','2'),('2737','城关区','540102','2736','3'),('2738','堆龙德庆区','540103','2736','3'),('2739','达孜区','540104','2736','3'),('2740','林周县','540121','2736','3'),('2741','当雄县','540122','2736','3'),('2742','尼木县','540123','2736','3'),('2743','曲水县','540124','2736','3'),('2744','墨竹工卡县','540127','2736','3'),('2745','日喀则市','540200','2735','2'),('2746','桑珠孜区','540202','2745','3'),('2747','南木林县','540221','2745','3'),('2748','江孜县','540222','2745','3'),('2749','定日县','540223','2745','3'),('2750','萨迦县','540224','2745','3'),('2751','拉孜县','540225','2745','3'),('2752','昂仁县','540226','2745','3'),('2753','谢通门县','540227','2745','3'),('2754','白朗县','540228','2745','3'),('2755','仁布县','540229','2745','3'),('2756','康马县','540230','2745','3'),('2757','定结县','540231','2745','3'),('2758','仲巴县','540232','2745','3'),('2759','亚东县','540233','2745','3'),('2760','吉隆县','540234','2745','3'),('2761','聂拉木县','540235','2745','3'),('2762','萨嘎县','540236','2745','3'),('2763','岗巴县','540237','2745','3'),('2764','昌都市','540300','2735','2'),('2765','卡若区','540302','2764','3'),('2766','江达县','540321','2764','3'),('2767','贡觉县','540322','2764','3'),('2768','类乌齐县','540323','2764','3'),('2769','丁青县','540324','2764','3'),('2770','察雅县','540325','2764','3'),('2771','八宿县','540326','2764','3'),('2772','左贡县','540327','2764','3'),('2773','芒康县','540328','2764','3'),('2774','洛隆县','540329','2764','3'),('2775','边坝县','540330','2764','3'),('2776','林芝市','540400','2735','2'),('2777','巴宜区','540402','2776','3'),('2778','工布江达县','540421','2776','3'),('2779','米林县','540422','2776','3'),('2780','墨脱县','540423','2776','3'),('2781','波密县','540424','2776','3'),('2782','察隅县','540425','2776','3'),('2783','朗县','540426','2776','3'),('2784','山南市','540500','2735','2'),('2785','乃东区','540502','2784','3'),('2786','扎囊县','540521','2784','3'),('2787','贡嘎县','540522','2784','3'),('2788','桑日县','540523','2784','3'),('2789','琼结县','540524','2784','3'),('2790','曲松县','540525','2784','3'),('2791','措美县','540526','2784','3'),('2792','洛扎县','540527','2784','3'),('2793','加查县','540528','2784','3'),('2794','隆子县','540529','2784','3'),('2795','错那县','540530','2784','3'),('2796','浪卡子县','540531','2784','3'),('2797','那曲市','540600','2735','2'),('2798','色尼区','540602','2797','3'),('2799','嘉黎县','540621','2797','3'),('2800','比如县','540622','2797','3'),('2801','聂荣县','540623','2797','3'),('2802','安多县','540624','2797','3'),('2803','申扎县','540625','2797','3'),('2804','索县','540626','2797','3'),('2805','班戈县','540627','2797','3'),('2806','巴青县','540628','2797','3'),('2807','尼玛县','540629','2797','3'),('2808','双湖县','540630','2797','3'),('2809','阿里地区','542500','2735','2'),('2810','普兰县','542521','2809','3'),('2811','札达县','542522','2809','3'),('2812','噶尔县','542523','2809','3'),('2813','日土县','542524','2809','3'),('2814','革吉县','542525','2809','3'),('2815','改则县','542526','2809','3'),('2816','措勤县','542527','2809','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values('2817','陕西省','610000','0','1'),('2818','西安市','610100','2817','2'),('2819','新城区','610102','2818','3'),('2820','碑林区','610103','2818','3'),('2821','莲湖区','610104','2818','3'),('2822','灞桥区','610111','2818','3'),('2823','未央区','610112','2818','3'),('2824','雁塔区','610113','2818','3'),('2825','阎良区','610114','2818','3'),('2826','临潼区','610115','2818','3'),('2827','长安区','610116','2818','3'),('2828','高陵区','610117','2818','3'),('2829','鄠邑区','610118','2818','3'),('2830','蓝田县','610122','2818','3'),('2831','周至县','610124','2818','3'),('2832','铜川市','610200','2817','2'),('2833','王益区','610202','2832','3'),('2834','印台区','610203','2832','3'),('2835','耀州区','610204','2832','3'),('2836','宜君县','610222','2832','3'),('2837','宝鸡市','610300','2817','2'),('2838','渭滨区','610302','2837','3'),('2839','金台区','610303','2837','3'),('2840','陈仓区','610304','2837','3'),('2841','凤翔区','610322','2837','3'),('2842','岐山县','610323','2837','3'),('2843','扶风县','610324','2837','3'),('2844','眉县','610326','2837','3'),('2845','陇县','610327','2837','3'),('2846','千阳县','610328','2837','3'),('2847','麟游县','610329','2837','3'),('2848','凤县','610330','2837','3'),('2849','太白县','610331','2837','3'),('2850','咸阳市','610400','2817','2'),('2851','秦都区','610402','2850','3'),('2852','杨陵区','610403','2850','3'),('2853','渭城区','610404','2850','3'),('2854','三原县','610422','2850','3'),('2855','泾阳县','610423','2850','3'),('2856','乾县','610424','2850','3'),('2857','礼泉县','610425','2850','3'),('2858','永寿县','610426','2850','3'),('2859','长武县','610428','2850','3'),('2860','旬邑县','610429','2850','3'),('2861','淳化县','610430','2850','3'),('2862','武功县','610431','2850','3'),('2863','兴平市','610481','2850','3'),('2864','彬州市','610482','2850','3'),('2865','渭南市','610500','2817','2'),('2866','临渭区','610502','2865','3'),('2867','华州区','610503','2865','3'),('2868','潼关县','610522','2865','3'),('2869','大荔县','610523','2865','3'),('2870','合阳县','610524','2865','3'),('2871','澄城县','610525','2865','3'),('2872','蒲城县','610526','2865','3'),('2873','白水县','610527','2865','3'),('2874','富平县','610528','2865','3'),('2875','韩城市','610581','2865','3'),('2876','华阴市','610582','2865','3'),('2877','延安市','610600','2817','2'),('2878','宝塔区','610602','2877','3'),('2879','安塞区','610603','2877','3'),('2880','延长县','610621','2877','3'),('2881','延川县','610622','2877','3'),('2882','志丹县','610625','2877','3'),('2883','吴起县','610626','2877','3'),('2884','甘泉县','610627','2877','3'),('2885','富县','610628','2877','3'),('2886','洛川县','610629','2877','3'),('2887','宜川县','610630','2877','3'),('2888','黄龙县','610631','2877','3'),('2889','黄陵县','610632','2877','3'),('2890','子长市','610681','2877','3'),('2891','汉中市','610700','2817','2'),('2892','汉台区','610702','2891','3'),('2893','南郑区','610703','2891','3'),('2894','城固县','610722','2891','3'),('2895','洋县','610723','2891','3'),('2896','西乡县','610724','2891','3'),('2897','勉县','610725','2891','3'),('2898','宁强县','610726','2891','3'),('2899','略阳县','610727','2891','3'),('2900','镇巴县','610728','2891','3'),('2901','留坝县','610729','2891','3'),('2902','佛坪县','610730','2891','3'),('2903','榆林市','610800','2817','2'),('2904','榆阳区','610802','2903','3'),('2905','横山区','610803','2903','3'),('2906','府谷县','610822','2903','3'),('2907','靖边县','610824','2903','3'),('2908','定边县','610825','2903','3'),('2909','绥德县','610826','2903','3'),('2910','米脂县','610827','2903','3'),('2911','佳县','610828','2903','3'),('2912','吴堡县','610829','2903','3'),('2913','清涧县','610830','2903','3'),('2914','子洲县','610831','2903','3'),('2915','神木市','610881','2903','3'),('2916','安康市','610900','2817','2'),('2917','汉滨区','610902','2916','3'),('2918','汉阴县','610921','2916','3'),('2919','石泉县','610922','2916','3'),('2920','宁陕县','610923','2916','3'),('2921','紫阳县','610924','2916','3'),('2922','岚皋县','610925','2916','3'),('2923','平利县','610926','2916','3'),('2924','镇坪县','610927','2916','3'),('2925','旬阳市','610928','2916','3'),('2926','白河县','610929','2916','3'),('2927','商洛市','611000','2817','2'),('2928','商州区','611002','2927','3'),('2929','洛南县','611021','2927','3'),('2930','丹凤县','611022','2927','3'),('2931','商南县','611023','2927','3'),('2932','山阳县','611024','2927','3'),('2933','镇安县','611025','2927','3'),('2934','柞水县','611026','2927','3'),('2935','甘肃省','620000','0','1'),('2936','兰州市','620100','2935','2'),('2937','城关区','620102','2936','3'),('2938','七里河区','620103','2936','3'),('2939','西固区','620104','2936','3'),('2940','安宁区','620105','2936','3'),('2941','红古区','620111','2936','3'),('2942','永登县','620121','2936','3'),('2943','皋兰县','620122','2936','3'),('2944','榆中县','620123','2936','3'),('2945','嘉峪关市','620200','2935','2'),('2946','嘉峪关市','620200','2945','3'),('2947','金昌市','620300','2935','2'),('2948','金川区','620302','2947','3'),('2949','永昌县','620321','2947','3'),('2950','白银市','620400','2935','2'),('2951','白银区','620402','2950','3'),('2952','平川区','620403','2950','3'),('2953','靖远县','620421','2950','3'),('2954','会宁县','620422','2950','3'),('2955','景泰县','620423','2950','3'),('2956','天水市','620500','2935','2'),('2957','秦州区','620502','2956','3'),('2958','麦积区','620503','2956','3'),('2959','清水县','620521','2956','3'),('2960','秦安县','620522','2956','3'),('2961','甘谷县','620523','2956','3'),('2962','武山县','620524','2956','3'),('2963','张家川回族自治县','620525','2956','3'),('2964','武威市','620600','2935','2'),('2965','凉州区','620602','2964','3'),('2966','民勤县','620621','2964','3'),('2967','古浪县','620622','2964','3'),('2968','天祝藏族自治县','620623','2964','3'),('2969','张掖市','620700','2935','2'),('2970','甘州区','620702','2969','3'),('2971','肃南裕固族自治县','620721','2969','3'),('2972','民乐县','620722','2969','3'),('2973','临泽县','620723','2969','3'),('2974','高台县','620724','2969','3'),('2975','山丹县','620725','2969','3'),('2976','平凉市','620800','2935','2'),('2977','崆峒区','620802','2976','3'),('2978','泾川县','620821','2976','3'),('2979','灵台县','620822','2976','3'),('2980','崇信县','620823','2976','3'),('2981','庄浪县','620825','2976','3'),('2982','静宁县','620826','2976','3'),('2983','华亭市','620881','2976','3'),('2984','酒泉市','620900','2935','2'),('2985','肃州区','620902','2984','3'),('2986','金塔县','620921','2984','3'),('2987','瓜州县','620922','2984','3'),('2988','肃北蒙古族自治县','620923','2984','3'),('2989','阿克塞哈萨克族自治县','620924','2984','3'),('2990','玉门市','620981','2984','3'),('2991','敦煌市','620982','2984','3'),('2992','庆阳市','621000','2935','2'),('2993','西峰区','621002','2992','3'),('2994','庆城县','621021','2992','3'),('2995','环县','621022','2992','3'),('2996','华池县','621023','2992','3'),('2997','合水县','621024','2992','3'),('2998','正宁县','621025','2992','3'),('2999','宁县','621026','2992','3'),('3000','镇原县','621027','2992','3'),('3001','定西市','621100','2935','2'),('3002','安定区','621102','3001','3'),('3003','通渭县','621121','3001','3'),('3004','陇西县','621122','3001','3'),('3005','渭源县','621123','3001','3'),('3006','临洮县','621124','3001','3'),('3007','漳县','621125','3001','3'),('3008','岷县','621126','3001','3'),('3009','陇南市','621200','2935','2'),('3010','武都区','621202','3009','3'),('3011','成县','621221','3009','3'),('3012','文县','621222','3009','3'),('3013','宕昌县','621223','3009','3'),('3014','康县','621224','3009','3'),('3015','西和县','621225','3009','3'),('3016','礼县','621226','3009','3'),('3017','徽县','621227','3009','3'),('3018','两当县','621228','3009','3'),('3019','临夏回族自治州','622900','2935','2'),('3020','临夏市','622901','3019','3'),('3021','临夏县','622921','3019','3'),('3022','康乐县','622922','3019','3'),('3023','永靖县','622923','3019','3'),('3024','广河县','622924','3019','3'),('3025','和政县','622925','3019','3'),('3026','东乡族自治县','622926','3019','3'),('3027','积石山保安族东乡族撒拉','622927','3019','3'),('3028','甘南藏族自治州','623000','2935','2'),('3029','合作市','623001','3028','3'),('3030','临潭县','623021','3028','3'),('3031','卓尼县','623022','3028','3'),('3032','舟曲县','623023','3028','3'),('3033','迭部县','623024','3028','3'),('3034','玛曲县','623025','3028','3'),('3035','碌曲县','623026','3028','3'),('3036','夏河县','623027','3028','3'),('3037','宁夏回族自治区','630000','0','1'),('3038','银川市','630100','3037','2'),('3039','兴庆区','630102','3038','3'),('3040','西夏区','630103','3038','3'),('3041','金凤区','630104','3038','3'),('3042','永宁县','630105','3038','3'),('3043','贺兰县','630106','3038','3'),('3044','灵武市','630121','3038','3'),('3045','石嘴山市','630123','3037','2'),('3046','大武口区','630200','3045','3'),('3047','惠农区','630202','3045','3'),('3048','平罗县','630203','3045','3'),('3049','吴忠市','630222','3037','2'),('3050','利通区','630223','3049','3'),('3051','红寺堡区','630224','3049','3'),('3052','盐池县','630225','3049','3'),('3053','同心县','632200','3049','3'),('3054','青铜峡市','632221','3049','3'),('3055','固原市','632222','3037','2'),('3056','原州区','632223','3055','3'),('3057','西吉县','632224','3055','3'),('3058','隆德县','632300','3055','3'),('3059','泾源县','632301','3055','3'),('3060','彭阳县','632322','3055','3'),('3061','中卫市','632323','3037','2'),('3062','沙坡头区','632324','3061','3'),('3063','中宁县','632500','3061','3'),('3064','海原县','632521','3061','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values('3065','新疆维吾尔自治区','632522','0','1'),('3066','乌鲁木齐市','632523','3065','2'),('3067','天山区','632524','3066','3'),('3068','沙依巴克区','632525','3166','3'),('3069','新市区','632600','3166','3'),('3070','水磨沟区','632621','3166','3'),('3071','头屯河区','632622','3166','3'),('3072','达坂城区','632623','3166','3'),('3073','米东区','632624','3166','3'),('3074','乌鲁木齐县','632625','3166','3'),('3075','克拉玛依市','632626','3065','2'),('3076','独山子区','632700','3075','3'),('3077','克拉玛依区','632701','3075','3'),('3078','白碱滩区','632722','3075','3'),('3079','乌尔禾区','632723','3075','3'),('3080','吐鲁番市','632724','3065','2'),('3081','高昌区','632725','3080','3'),('3082','鄯善县','632726','3080','3'),('3083','托克逊县','632800','3180','3'),('3084','哈密市','632801','3065','2'),('3085','伊州区','632802','3084','3'),('3086','巴里坤哈萨克自治县','632803','3084','3'),('3087','伊吾县','632821','3084','3'),('3088','昌吉回族自治州','632822','3065','2'),('3089','昌吉市','632823','3088','3'),('3090','阜康市','632825','3088','3'),('3091','呼图壁县','640000','3088','3'),('3092','玛纳斯县','640100','3088','3'),('3093','奇台县','640104','3088','3'),('3094','吉木萨尔县','640105','3088','3'),('3095','木垒哈萨克自治县','640106','3088','3'),('3096','博尔塔拉蒙古自治州','640121','3065','2'),('3097','博乐市','640122','3096','3'),('3098','阿拉山口市','640181','3096','3'),('3099','精河县','640200','3096','3'),('3100','温泉县','640202','3096','3'),('3101','巴音郭楞蒙古自治州','640205','3065','2'),('3102','库尔勒市','640221','3101','3'),('3103','轮台县','640300','3101','3'),('3104','尉犁县','640302','3101','3'),('3105','若羌县','640303','3101','3'),('3106','且末县','640323','3101','3'),('3107','焉耆回族自治县','640324','3101','3'),('3108','和静县','640381','3101','3'),('3109','和硕县','640400','3101','3'),('3110','博湖县','640402','3101','3'),('3111','阿克苏地区','640422','3065','2'),('3112','阿克苏市','640423','3111','3'),('3113','库车市','640424','3111','3'),('3114','温宿县','640425','3111','3'),('3115','沙雅县','640500','3111','3'),('3116','新和县','640502','3111','3'),('3117','拜城县','640521','3111','3'),('3118','乌什县','640522','3111','3'),('3119','阿瓦提县','650000','3111','3'),('3120','柯坪县','650100','3111','3'),('3121','克孜勒苏柯尔克孜自治州','650102','3065','2'),('3122','阿图什市','650103','3121','3'),('3123','阿克陶县','650104','3121','3'),('3124','阿合奇县','650105','3121','3'),('3125','乌恰县','650106','3121','3'),('3126','喀什地区','650107','3065','2'),('3127','喀什市','650109','3126','3'),('3128','疏附县','650121','3126','3'),('3129','疏勒县','650200','3126','3'),('3130','英吉沙县','650202','3126','3'),('3131','泽普县','650203','3126','3'),('3132','莎车县','650204','3126','3'),('3133','叶城县','650205','3126','3'),('3134','麦盖提县','650400','3126','3'),('3135','岳普湖县','650402','3126','3'),('3136','伽师县','650421','3126','3'),('3137','巴楚县','650422','3126','3'),('3138','塔什库尔干塔吉克自治县','650500','3126','3'),('3139','和田地区','650502','3065','2'),('3140','和田市','650521','3139','3'),('3141','和田县','650522','3139','3'),('3142','墨玉县','652300','3139','3'),('3143','皮山县','652301','3139','3'),('3144','洛浦县','652302','3139','3'),('3145','策勒县','652323','3139','3'),('3146','于田县','652324','3139','3'),('3147','民丰县','652325','3139','3'),('3148','伊犁哈萨克自治州','652327','3065','2'),('3149','伊宁市','652328','3148','3'),('3150','奎屯市','652700','3148','3'),('3151','霍尔果斯市','652701','3148','3'),('3152','伊宁县','652702','3148','3'),('3153','察布查尔锡伯自治县','652722','3148','3'),('3154','霍城县','652723','3148','3'),('3155','巩留县','652800','3148','3'),('3156','新源县','652801','3148','3'),('3157','昭苏县','652822','3148','3'),('3158','特克斯县','652823','3148','3'),('3159','尼勒克县','652824','3148','3'),('3160','塔城地区','652825','3065','2'),('3161','塔城市','652826','3160','3'),('3162','乌苏市','652827','3160','3'),('3163','额敏县','652828','3160','3'),('3164','沙湾市','652829','3160','3'),('3165','托里县','652900','3160','3'),('3166','裕民县','652901','3160','3'),('3167','和布克赛尔蒙古自治县','652902','3160','3'),('3168','阿勒泰地区','652922','3065','2'),('3169','阿勒泰市','652924','3168','3'),('3170','布尔津县','652925','3168','3'),('3171','富蕴县','652926','3168','3'),('3172','福海县','652927','3168','3'),('3173','哈巴河县','652928','3168','3'),('3174','青河县','652929','3168','3'),('3175','吉木乃县','653000','3168','3'),('3176','石河子市','653001','3065','2'),('3177','石河子市','653022','3176','3'),('3178','阿拉尔市','653023','3065','2'),('3179','阿拉尔市','653024','3178','3'),('3180','图木舒克市','653100','3065','2'),('3181','图木舒克市','653101','3180','3'),('3182','五家渠市','653121','3065','2'),('3183','五家渠市','653122','3182','3'),('3184','北屯市','653123','3065','2'),('3185','北屯市','653124','3184','3'),('3186','铁门关市','653125','3065','2'),('3187','铁门关市','653126','3186','3'),('3188','双河市','653127','3065','2'),('3189','双河市','653128','3188','3'),('3190','可克达拉市','653129','3065','2'),('3191','可克达拉市','653130','3190','3'),('3192','昆玉市','653131','3065','2'),('3193','昆玉市','653200','3192','3'),('3194','胡杨河市','653201','3065','2'),('3195','胡杨河市','653221','3194','3');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values('3196','台湾省','653222','0','1');
INSERT INTO region (`id`, `name`, `code`, `parent_id`, `level`) values('3197','香港特别行政区','653223','0','1'),('3198','香港特别行政区','653224','3197','2'),('3199','中西区','653225','3198','3'),('3200','湾仔区','653226','3198','3'),('3201','东区','653227','3198','3'),('3202','南区','654000','3198','3'),('3203','油尖旺区','654002','3198','3'),('3204','深水埗区','654003','3198','3'),('3205','九龙城区','654004','3198','3'),('3206','黄大仙区','654021','3198','3'),('3207','观塘区','654022','3198','3'),('3208','荃湾区','654023','3198','3'),('3209','屯门区','654024','3198','3'),('3210','元朗区','654025','3198','3'),('3211','北区','654026','3198','3'),('3212','大埔区','654027','3198','3'),('3213','西贡区','654028','3198','3'),('3214','沙田区','654200','3198','3'),('3215','葵青区','654201','3198','3'),('3216','离岛区','654202','3198','3');

UPDATE region SET `parent_ids_path` = '0' WHERE `parent_id` = '0';
UPDATE region SET `parent_ids_path` = '0,1' WHERE `parent_id` = '1';
UPDATE region SET `parent_ids_path` = '0,1,2' WHERE `parent_id` = '2';

INSERT INTO mdl_pet (id, category, code, remark, is_deleted) VALUES ('1000001', 'CAT', '#1', '1号猫咪', 0), ('1000002', 'DOG', '#1', '1号狗狗', 0), ('1000003', 'CAT', '#2', '2号猫咪', 0), ('1000004', 'DOG', '#2', '2号狗狗', 0), ('1000005', 'DOG', '#3', '3号狗狗', 0);
INSERT INTO mdl_pet_adopt (id, realname, pet_category, pet_code, remark, is_deleted) VALUES('122222221', '张三', 'CAT', '#1', '张三领养1号猫', 0), ('122222222', '张三', 'DOG', '#2', '张三领养2号狗', 0), ('122222223', '李四', 'CAT', '#2', '李四领养2号猫', 0);
