/*
 * Copyright (c) 2015-2020, www.dibo.ltd (service@dibo.ltd).
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * <p>
 * https://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package diboot.core.test.binder.vo;

import com.diboot.core.binding.annotation.BindDict;
import com.diboot.core.binding.annotation.BindEntity;
import com.diboot.core.binding.annotation.BindField;
import diboot.core.test.binder.entity.Organization;
import diboot.core.test.binder.entity.User;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <Description>
 *
 * @author mazc@dibo.ltd
 * @version v2.0
 * @date 2019/12/06
 */
@Getter
@Setter
@Accessors(chain = true)
public class OrganizationVO {

    private Long id;

    private Long parentId;

    private String name;

    private Long managerId;

    // 关联Entity
    @BindEntity(entity = Organization.class, condition = "this.parent_id=id") // AND ...
    private Organization parentOrg;

    // 关联Entity
    @BindField(entity = Organization.class, field = "name", condition = "this.parent_id=id") // AND ...
    private String parentOrgName;

    @BindDict(type = "GENDER", field = "managerGenderLabel")
    @BindField(entity = User.class, field = "gender", condition = "this.manager_id=id")
    private String managerGenderLabel;

}
