# Contributing to Task Manager

First off, thank you for considering contributing to the Task Manager project! 🎉 Your contributions are greatly appreciated and help make this project better for everyone.

## Table of Contents

- [How Can I Contribute?](#how-can-i-contribute)
  - [Reporting Bugs](#reporting-bugs)
  - [Suggesting Enhancements](#suggesting-enhancements)
  - [Submitting Pull Requests](#submitting-pull-requests)
    - [Steps to Contribute](#steps-to-contribute)
- [Code Style Guidelines](#code-style-guidelines)
- [Reviewing Changes](#reviewing-changes)
- [Code of Conduct](#code-of-conduct)
- [Thank You](#thank-you)

## How Can I Contribute?

### Reporting Bugs

If you find a bug in the application, please help us fix it by following these steps:

1. **Check for Existing Issues**: Look through [existing issues](https://github.com/DhanushNehru/task-manager/issues) to see if the bug has already been reported.
2. **Open a New Issue**: If the bug is not listed, open a new issue with the following details:
   - **Title**: A clear and descriptive title.
   - **Description**: A detailed description of the bug.
   - **Steps to Reproduce**: Step-by-step instructions to reproduce the issue.
   - **Expected Behavior**: What you expected to happen.
   - **Actual Behavior**: What actually happened.
   - **Screenshots or Logs**: Any relevant screenshots or log files.

### Suggesting Enhancements

We welcome your ideas to improve the Task Manager! To suggest enhancements:

1. **Check Existing Suggestions**: Browse through [open issues](https://github.com/DhanushNehru/task-manager/issues) to see if your idea has already been proposed.
2. **Open a New Issue**: If not, create a new issue with:
   - **Title**: A clear and descriptive title for the enhancement.
   - **Description**: A detailed explanation of the enhancement and its benefits.
   - **Possible Implementation**: Any ideas on how to implement the enhancement (optional).

### Submitting Pull Requests

Pull requests are the best way to contribute to the Task Manager. Follow these steps to submit a PR:

#### Steps to Contribute

1. **Fork the Repository**: Click the "Fork" button at the top right of the repository page to create your own copy.

2. **Clone Your Fork**:

    ```bash
    git clone https://github.com/DhanushNehru/task-manager.git
    cd task-manager
    ```

3. **Create a New Branch** for your feature or fix:

    ```bash
    git checkout -b feature-or-fix-name
    ```

4. **Make Your Changes**: Implement your feature or fix. Ensure your code follows the existing coding style.

5. **Commit Your Changes**:

    ```bash
    git commit -m "A brief description of the feature or fix"
    ```

6. **Push to Your Fork**:

    ```bash
    git push origin feature-or-fix-name
    ```

7. **Create a Pull Request**:
   - Navigate to your fork on GitHub.
   - Click the "Compare & pull request" button.
   - Provide a clear description of your changes.
   - Reference any related issues by using keywords like `Closes #issue-number`.

## Code Style Guidelines

Maintaining a consistent code style helps keep the codebase readable and maintainable. Please adhere to the following guidelines:

- **Indentation**: Use 2 spaces for JavaScript and JSX files.
- **Naming Conventions**:
  - Use `camelCase` for variables and functions.
  - Use `PascalCase` for React components.
- **Commit Messages**:
  - Write clear and concise commit messages.
  - Use the imperative mood (e.g., "Add new feature" instead of "Added new feature").
- **Code Formatting**: Ensure your code is properly formatted. Consider using tools like [Prettier](https://prettier.io/).
- **Linting**: Follow the project's linting rules to catch potential errors and enforce coding standards.

## Reviewing Changes

After you submit a pull request, the maintainers will review your code. Here's what to expect:

- **Review Process**: Your PR will be reviewed for code quality, adherence to guidelines, and functionality.
- **Feedback**: If changes are needed, we will leave comments on your PR. Address the feedback by making additional commits to your branch.
- **Approval and Merge**: Once your PR meets all requirements and passes all checks, it will be approved and merged.



## Thank You

Thank you for taking the time to contribute to the Task Manager! Your efforts help make this project better and more useful for everyone. If you have any questions or need assistance, feel free to reach out by opening an issue or contacting the maintainers.

Happy coding! 🚀
