<?php
    $this->load->view('backend/header');
    $this->load->view('backend/sidebar'); 
?>

        <div class="page-wrapper">
            <div class="container-fluid p-t-10">
                <div class="row m-b-10"> 
                    <div class="col-12">
                        <button type="button" class="btn btn-info"><i class="fa fa-plus"></i><a href="<?php echo base_url();?>Supplier/Create" class="text-white"><i class="" aria-hidden="true"></i> Add Supplier</a></button>
                        <button type="button" class="btn btn-primary"><i class="fa fa-bars"></i><a href="<?php echo base_url();?>Supplier/Balance" class="text-white"><i class="" aria-hidden="true"></i>  Supplier Balance </a></button>
                    </div>
                </div>
            <div class="flashmessage"></div>
                <div class="row">

                    <div class="col-12">
                        <div class="card card-outline-info">
                            <div class="card-header">
                                <h4 class="m-b-0 text-white">Manage Supplier </h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive ">
                                    <table id="myTable" class="display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
                                        <thead>
                                            <tr>
                                                <th>Supplier ID </th>
                                                <th>Supplier Name</th>
                                                <th>Phone Number</th>
                                                <th>Address</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                           <?php foreach($supplierList as $value): ?>
                                            <tr>
                                                <td><?php echo $value->s_id; ?></td>
                                                <td><?php echo $value->s_name; ?></td>
                                                <td><?php echo $value->s_phone; ?></td>
                                                <td><?php echo $value->s_address; ?></td>
                                                <td class="jsgrid-align-center ">
                                                    <a href="" title="Edit" class="btn btn-sm btn-info waves-effect waves-light supplierid" data-id="<?php echo $value->s_id ?>"><i class="fa fa-pencil-square-o"></i></a><!--
                                                    <a href="<?php echo base_url();?>supplier/delete?id=<?php echo $value->id;?>" title="Delete" class="btn btn-sm btn-info waves-effect waves-light"><i class="fa fa-trash-o"></i></a>-->

                                                </td>

                                            </tr>

                                            <?php endforeach; ?>

                                        </tbody>

                                    </table>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

                        </div>

            <footer class="footer"> © 2017 GenIT Bangladesh </footer>

        </div>
<!--Modal-->
<div class="modal fade" id="supplierModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Update Supplier</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form action="Update" method="post" id="supplierfORM" class="form-horizontal" enctype="multipart/form-data" accept-charset="utf-8">
      <div class="modal-body">
        <div class="row">
            <div class="col-md-6">
                <div class="form-group row">
                    <label class="control-label text-right col-md-3">Supplier Name</label>
                    <div class="col-md-9">
                        <input type="text" name="sname" class="form-control" placeholder="Supplier name" value="" required minlength="1">
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group row">
                    <label class="control-label text-right col-md-3">Phone Name</label>
                    <div class="col-md-9">
                        <input type="number" name="sphone" value="" class="form-control" placeholder="Phone name">
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group row">
                    <label class="control-label text-right col-md-3">Email</label>
                    <div class="col-md-9">
                        <input type="text" name="semail" value="" class="form-control" placeholder="Email">
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group row">
                    <label class="control-label text-right col-md-3">Address</label>
                    <div class="col-md-9">
                        <input type="text" name="saddress" value=""  class="form-control" placeholder="Address">
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group row">
                    <label class="control-label text-right col-md-3">Note</label>
                    <div class="col-md-9">
                        <textarea class="form-control" name="snote" value="" rows="3"></textarea>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-group row">
                    <label class="control-label text-right col-md-3">Status</label>
                        <div class="col-md-9">
                        <select class="form-control" name="status" id="status" value="">
                            <option value="">Select Here</option>
                            <option value="Active">Active</option>
                            <option value="Inactive">Inactive</option>
                        </select>
                        </div>
                </div>
            </div>
             <div class="col-md-6 col-sm-12">
                 <div class="form-group row">
                     <label class="control-label text-right col-md-3 col-sm-12"> Image</label>
                     <div class="col-md-6 col-sm-12">
                         <input type="file" name="img_url" id="img_url" class="form-control" aria-describedby="fileHelp">
                     </div>
                     <div class="col-md-3 col-sm-12">
                        <div class="file_prev modal_prev">
                            <img src="" name="img_url" class="img-responsive postimg" id="image" height="35px" width="60px">
                        </div>
                     </div>
                 </div>
             </div>            
        </div>
      </div>
      <div class="modal-footer">
       <input type="hidden" name="sid" value="">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-info">Submit</button>
      </div>
      </form>
    </div>
  </div>
</div>
       <script type="text/javascript">
            $(document).ready(function () {
                $(".supplierid").click(function (e) {
                    e.preventDefault(e);
                    // Get the record's ID via attribute  
                    var iid = $(this).attr('data-id');
                    //console.log(iid);
                     $('#supplierfORM').trigger("reset");
                     $('#supplierModal').modal('show'); 
                    $.ajax({
                        url: '<?php echo base_url();?>Supplier/GetSupplierById?id=' + iid,
                        method: 'GET',
                        data: '',
                        dataType: 'json',
                    }).done(function (response) {
                        console.log(response);
                        // Populate the form fields with the data returned from server
                        $('#supplierfORM').find('[name="sid"]').val(response.mvalue.s_id).end();
                        $('#supplierfORM').find('[name="sname"]').val(response.mvalue.s_name).end();
                        $('#supplierfORM').find('[name="sphone"]').val(response.mvalue.s_phone).end();
                        $('#supplierfORM').find('[name="semail"]').val(response.mvalue.s_email).end();
                        $('#supplierfORM').find('[name="saddress"]').val(response.mvalue.s_address).end();
                        $('#supplierfORM').find('[name="snote"]').val(response.mvalue.s_note).end();
                        $('#supplierfORM').find('[id="status"]').val(response.mvalue.status).end();
                        $('#image').attr('src','<?php echo base_url()?>assets/images/supplier/'+response.mvalue.s_img);
                    });
                });
            });               
        </script> 
<script>
$("#img_url").on("change", function() {
    if (typeof FileReader == "undefined") {
        alert("Your browser doesn't support HTML5, Please upgrade your browser");
    } else {
        var container = $(".file_prev");
        //remove all previous selected files
        container.empty();

        //create instance of FileReader
        var reader = new FileReader();
        reader.onload = function(e) {
            $("<img />", {
                src: e.target.result
            }).appendTo(container);
        };
        reader.readAsDataURL($(this)[0].files[0]);
    }
});
    </script>        
<?php 

    $this->load->view('backend/footer');

?>