<?php

defined('BASEPATH') OR exit('No direct script access allowed');



class Accounts extends CI_Controller {



	function __construct() {
        parent::__construct();
        $this->load->database();
        $this->load->model('login_model');
        $this->load->model('user_model');
        $this->load->model('medicine_model');
        $this->load->model('customer_model');
        $this->load->model('user_model');
        $this->load->model('supplier_model');
    }

    public function index(){
    	if ($this->session->userdata('user_login_access') != 1) 
    		redirect(base_url('login'));
    	if ($this->session->userdata('user_login_access') == 1) 
    		$data = array();
    		redirect('dashboard/Dashboard');
    }
    

    public function Account(){
    	if ($this->session->userdata('user_login_access') != False) {
    		$this->load->view('backend/account');
    	}else{	
    		redirect(base_url());
    	}
    }
    

    public function Summary(){
    	if ($this->session->userdata('user_login_access') != False) {
    		$this->load->view('backend/summary');
    	}else{	
    		redirect(base_url());
    	}
    }
    

    public function Closing(){
        if ($this->session->userdata('user_login_access') != False) {
            $this->load->view('backend/closing');
        }else{  
            redirect(base_url());
        }
    }
    

    public function Closing_report(){
        if ($this->session->userdata('user_login_access') != False) {
            $this->load->view('backend/closing_report');
        }else{  
            redirect(base_url());
        }
    }
    

    public function Tax(){
    	if ($this->session->userdata('user_login_access') != False) {
    		$this->load->view('backend/tax');
    	}else{	
    		redirect(base_url());
    	}
    }
    

    public function Bank(){
    	if ($this->session->userdata('user_login_access') != False) {
            $data['bankinfo'] = $this->user_model->Getbankinfowithsupplier();
    		$this->load->view('backend/bank',$data);
    	}else{	
    		redirect(base_url());
    	}
    }
    

    public function Payment(){
    	if ($this->session->userdata('user_login_access') != False) {
            $data['bankinfo'] = $this->user_model->Getbankinfowithsupplier();
    		$this->load->view('backend/payment',$data);
    	}else{	
    		redirect(base_url());
    	}
    }
    public function Save()
    {
        if($this->session->userdata('user_login_access') != False) {

            $supplier = $this->input->post('supplier');
            $mtype = $this->input->post('mtype');
            $issudate = $this->input->post('issuedate');
            $details = $this->input->post('details');
            $cheque = $this->input->post('cheque');
            $bank = $this->input->post('bankid');
            $amount = $this->input->post('amount');
            $balance = $this->supplier_model->Getsupplierbalance($supplier);
            if($balance->total_due < $amount){
                    $response['status'] = 'error';
                    $response['message'] = "Payment Method Is Not Valid";
                    $response['curl'] = base_url()."Accounts/Payment";
                    $this->output->set_output(json_encode($response));             
            } else{
            $this->form_validation->set_rules('supplier','supplier','trim|required|min_length[5]|max_length[100]|xss_clean');

            if ($this->form_validation->run() == FALSE) {
                $feedback['error'] = validation_errors();
                echo json_encode($feedback);
            } else {
                $data=array(
                    'supplier_id'=> $supplier,
                    'type'=> $mtype,
                    'bank_id'=> $bank,
                    'details'=> $details,
                    'issue_date'=> $issudate,
                    'amount'=> $amount
                );
                $success = $this->user_model->insertSPAYMENT($data);
                if($this->db->affected_rows()){
                    
                    $paid = $balance->total_paid + $amount;
                    $due = $balance->total_due - $amount;
                $data=array(
                    'supplier_id'=> $supplier,
                    'total_paid'=> $paid,
                    'total_due'=> $due
                );
                $success = $this->user_model->UPDATEsPAYMENT($supplier,$data);                    
                    $response['status'] = 'success';
                    $response['message'] = "Successfully Added";
                    $response['curl'] = base_url()."Accounts/Payment";
                    $this->output->set_output(json_encode($response));                    
                }

            }
        }
        }
        else{
            redirect(base_url() , 'refresh');
        } 
    }    
}