/// <summary>
/// ***************************************************************************
///
/// Samples from blog Dveloppeur Pascal
///
/// Copyright 2017-2024 Patrick Prmartin under AGPL 3.0 license.
///
/// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
/// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
/// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
/// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
/// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
/// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
/// DEALINGS IN THE SOFTWARE.
///
/// ***************************************************************************
///
/// Author(s) :
///      Patrick PREMARTIN
///
/// Site :
///      https://developpeur-pascal.fr/
///
/// Project site :
///      https://github.com/DeveloppeurPascal/exemples
///
/// ***************************************************************************
/// File last update : 30/05/2024 20:10:15
/// Signature : c3a2749d1ed8978c58d8fbd82eb484b74ad57832
/// ***************************************************************************
/// </summary>

unit Unit1;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs,
  FMX.Controls.Presentation, FMX.StdCtrls, FMX.Layouts, FMX.TreeView,
  FMX.ScrollBox, FMX.Memo, FMX.Objects, FMX.Memo.Types;

type
  TForm1 = class(TForm)
    TreeView1: TTreeView;
    Button1: TButton;
    Memo1: TMemo;
    Rectangle1: TRectangle;
    procedure Button1Click(Sender: TObject);
    procedure TreeView1Click(Sender: TObject);
    procedure TreeView1DragChange(SourceItem, DestItem: TTreeViewItem; var Allow: Boolean);
    procedure TreeView1DragDrop(Sender: TObject; const Data: TDragObject; const Point: TPointF);
    procedure TreeView1DragEnd(Sender: TObject);
    procedure TreeView1DragEnter(Sender: TObject; const Data: TDragObject; const Point: TPointF);
    procedure TreeView1DragLeave(Sender: TObject);
    procedure TreeView1DragOver(Sender: TObject; const Data: TDragObject; const Point: TPointF;
      var Operation: TDragOperation);
    procedure TreeViewItemDragDrop(Sender: TObject; const Data: TDragObject; const Point: TPointF);
  private
    { Dclarations prives }
    ItemNumber: integer;
    procedure generate_datas(node: TTreeViewItem = nil; profondeur: integer = 1);
    procedure affiche(text: string);
  public
    { Dclarations publiques }
  end;

var
  Form1: TForm1;

implementation

{$R *.fmx}

var
  previous: string = '';

procedure TForm1.affiche(text: string);
begin
  if (previous <> text) then
  begin
    Memo1.lines.add(text);
    Memo1.GoToTextEnd;
    previous := text;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  ItemNumber := 0;
  generate_datas(nil, 5);
end;

procedure TForm1.generate_datas(node: TTreeViewItem; profondeur: integer);
var
  item: TTreeViewItem;
  i, nb: integer;
begin
  if (profondeur > 0) then
  begin
    nb := random(10);
    for i := 0 to nb do
    begin
      inc(ItemNumber);
      item := TTreeViewItem.Create(Self);
      item.text := 'Item : ' + ItemNumber.ToString;
      item.OnDragDrop := TreeViewItemDragDrop;
      if assigned(node) then
        node.AddObject(item)
      else
        TreeView1.AddObject(item);
      generate_datas(item, profondeur - 1);
    end;
  end;
end;

procedure TForm1.TreeView1Click(Sender: TObject);
begin
  if (TreeView1.Selected.IsExpanded) then
    TreeView1.Selected.collapse
  else if TreeView1.Selected.Count > 0 then
    TreeView1.Selected.expand;
end;

procedure TForm1.TreeView1DragChange(SourceItem, DestItem: TTreeViewItem; var Allow: Boolean);
begin
  affiche('TreeView1DragChange');
  Allow := true;
end;

procedure TForm1.TreeView1DragDrop(Sender: TObject; const Data: TDragObject; const Point: TPointF);
begin
  affiche('TreeView1DragDrop');
end;

procedure TForm1.TreeView1DragEnd(Sender: TObject);
begin
  affiche('TreeView1DragEnd');
end;

procedure TForm1.TreeView1DragEnter(Sender: TObject; const Data: TDragObject; const Point: TPointF);
begin
  affiche('TreeView1DragEnter');
end;

procedure TForm1.TreeView1DragLeave(Sender: TObject);
begin
  affiche('TreeView1DragLeave');
end;

procedure TForm1.TreeView1DragOver(Sender: TObject; const Data: TDragObject; const Point: TPointF;
  var Operation: TDragOperation);
begin
  affiche('TreeView1DragOver');
  Operation := TDragOperation.Move;
end;

procedure TForm1.TreeViewItemDragDrop(Sender: TObject; const Data: TDragObject; const Point: TPointF);
begin
  if Sender is TTreeViewItem then
    affiche('TreeViewItemDragDrop : ' + (Sender as TTreeViewItem).text);
end;

end.
