/// <summary>
/// ***************************************************************************
///
/// Samples from blog Dveloppeur Pascal
///
/// Copyright 2017-2024 Patrick Prmartin under AGPL 3.0 license.
///
/// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
/// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
/// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
/// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
/// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
/// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
/// DEALINGS IN THE SOFTWARE.
///
/// ***************************************************************************
///
/// Author(s) :
///      Patrick PREMARTIN
///
/// Site :
///      https://developpeur-pascal.fr/
///
/// Project site :
///      https://github.com/DeveloppeurPascal/exemples
///
/// ***************************************************************************
/// File last update : 30/05/2024 20:10:15
/// Signature : c1d69f89729c66b098a2c88b452e2ed9a7a36106
/// ***************************************************************************
/// </summary>

unit Unit1;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes,
  System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.Ani,
  FMX.StdCtrls, FMX.Controls.Presentation, FMX.ScrollBox, FMX.Memo, FMX.Layouts;

type
  TForm1 = class(TForm)
    btnFuture: TButton;
    ProgressBar1: TProgressBar;
    FloatAnimation1: TFloatAnimation;
    Memo1: TMemo;
    GridLayout1: TGridLayout;
    btnThread: TButton;
    btnAniIndicator: TButton;
    procedure btnFutureClick(Sender: TObject);
    procedure GridLayout1Resize(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnThreadClick(Sender: TObject);
    procedure btnAniIndicatorClick(Sender: TObject);
  private
    { Dclarations prives }
    procedure CalculLaChaineUserFriendly(Parent: TFmxObject;
      FinTraitement: tproc<string>);
  public
    { Dclarations publiques }
  end;

var
  Form1: TForm1;

implementation

{$R *.fmx}

uses System.Threading;

procedure TForm1.btnThreadClick(Sender: TObject);
var
  Resultat: string;
begin
  Memo1.Lines.Add('btnThreadClick dmarre');
  application.ProcessMessages;
  // lance le calcul en tche de fond
  tthread.CreateAnonymousThread(
    procedure
    begin
      sleep(5000);
      Resultat := 'Hello World btnThreadClick';
    end).Start;
  // affiche la variable avant la fin du calcul
  Memo1.Lines.Add('btnThreadClick rsultat : ' + Resultat);
  application.ProcessMessages;
  Memo1.Lines.Add('btnThreadClick termine');
  application.ProcessMessages;
end;

procedure TForm1.CalculLaChaineUserFriendly(Parent: TFmxObject;
FinTraitement: tproc<string>);
var
  logoAttente: taniindicator;
begin
  Memo1.Lines.Add('CalculLaChaineUserFriendly dmarre');
  application.ProcessMessages;
  logoAttente := taniindicator.Create(Parent);
  try
    logoAttente.Parent := Parent;
    logoAttente.Align := TAlignLayout.Client;
    logoAttente.Enabled := true;
    tthread.CreateAnonymousThread(
      procedure
      var
        Resultat: string;
      begin
        sleep(5000);
        Resultat := 'Hello World CalculLaChaineUserFriendly';
        tthread.Synchronize(nil,
          procedure
          begin
            logoAttente.Free;
            if assigned(FinTraitement) then
              FinTraitement(Resultat);
          end);
      end).Start;
  except
    logoAttente.Free;
  end;
  Memo1.Lines.Add('CalculLaChaineUserFriendly termine');
  application.ProcessMessages;
end;

procedure TForm1.btnAniIndicatorClick(Sender: TObject);
begin
  Memo1.Lines.Add('btnAniIndicatorClick dmarre');
  application.ProcessMessages;
  btnAniIndicator.Enabled := false;
  CalculLaChaineUserFriendly(btnAniIndicator,
    procedure(Resultat: string)
    begin
      Memo1.Lines.Add('btnAniIndicatorClick rsultat : ' + Resultat);
      application.ProcessMessages;
      btnAniIndicator.Enabled := true;
    end);
  Memo1.Lines.Add('btnAniIndicatorClick termine');
  application.ProcessMessages;
end;

procedure TForm1.btnFutureClick(Sender: TObject);
var
  ChaineCalculee: IFuture<string>;
  Resultat: string;
begin
  Memo1.Lines.Add('btnFutureClick dmarre');
  application.ProcessMessages;
  // lance le thread et effectue le calcul demand
  ChaineCalculee := ttask.Future<string>(
    function: string
    begin
      sleep(5000);
      Result := 'Hello World btnFutureClick';
    end);
  // traitement normal
  Memo1.Lines.Add('btnFutureClick calcul lanc');
  application.ProcessMessages;
  // bloque le processus en cours jusqu' avoir la rponse
  Resultat := ChaineCalculee.Value;
  // reprend son traitement normal
  Memo1.Lines.Add('btnFutureClick rsultat : ' + Resultat);
  application.ProcessMessages;
  Memo1.Lines.Add('btnFutureClick termine');
  application.ProcessMessages;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  GridLayout1Resize(Sender);
end;

procedure TForm1.GridLayout1Resize(Sender: TObject);
begin
  GridLayout1.ItemWidth := GridLayout1.Width / GridLayout1.ChildrenCount;
end;

end.
