<!-- default badges list -->
![](https://img.shields.io/endpoint?url=https://codecentral.devexpress.com/api/v1/VersionRange/269085923/20.1.3%2B)
[![](https://img.shields.io/badge/Open_in_DevExpress_Support_Center-FF7200?style=flat-square&logo=DevExpress&logoColor=white)](https://supportcenter.devexpress.com/ticket/details/T896073)
[![](https://img.shields.io/badge/📖_How_to_use_DevExpress_Examples-e9f6fc?style=flat-square)](https://docs.devexpress.com/GeneralInformation/403183)
[![](https://img.shields.io/badge/💬_Leave_Feedback-feecdd?style=flat-square)](#does-this-example-address-your-development-requirementsobjectives)
<!-- default badges end -->
# RichEdit for ASP.NET Core - How to integrate a control into an ASP.NET Web Forms application

This example illustrates how to integrate a client part of ASP.NET Core [RichEdit](https://docs.devexpress.com/AspNetCore/400373/office-inspired-controls/controls/rich-edit) componentt into an ASP.NET Web Forms application.
## Requirements
* To use the RichEdit control in an ASP.NET Web Forms application, you need to have a [Universal, DXperience, or ASP.NET subscription](https://www.devexpress.com/buy/net/).
* Versions of the devexpress npm packages should be identical (their major and minor versions should be the same).

> **NOTE** 
The client-side RichEdit libraries are added via NPM. It is necessary to restore the NPM packages before starting the project.
Use the "Restore packages" command for the package.json file from Visual Studio ([Add npm support to a project](https://learn.microsoft.com/en-us/visualstudio/javascript/npm-package-management)) or run [npm install](https://docs.npmjs.com/cli/install).  


<!-- default file list -->
## Files to Look At

* [Default.aspx](./CS/RichWebForms/Default.aspx) (VB:[Default.aspx](./VB/RichWebForms/Default.aspx))
* [Default.aspx.cs](./CS/RichWebForms/Default.aspx.cs) (VB:[Default.aspx.vb](./VB/RichWebForms/Default.aspx.vb))
* [creator.js](./CS/RichWebForms/Scripts/creator.js)
<!-- default file list end -->

## Documentation

- [Rich Text Editor](https://docs.devexpress.com/AspNetCore/400373/rich-edit)
- [Get Started: Add RichEdit to a Web Forms Application](https://docs.devexpress.com/AspNetCore/401876/rich-edit/get-started/web-forms-application)

## More Examples

- [RichEdit for ASP.NET Core - How to integrate a control into an MVC application](https://github.com/DevExpress-Examples/richedit-for-core-how-to-integrate-a-control-into-an-mvc-application)
<!-- feedback -->
## Does this example address your development requirements/objectives?

[<img src="https://www.devexpress.com/support/examples/i/yes-button.svg"/>](https://www.devexpress.com/support/examples/survey.xml?utm_source=github&utm_campaign=richedit-for-core-how-to-integrate-a-control-into-an-asp-net-web-forms-application&~~~was_helpful=yes) [<img src="https://www.devexpress.com/support/examples/i/no-button.svg"/>](https://www.devexpress.com/support/examples/survey.xml?utm_source=github&utm_campaign=richedit-for-core-how-to-integrate-a-control-into-an-asp-net-web-forms-application&~~~was_helpful=no)

(you will be redirected to DevExpress.com to submit your response)
<!-- feedback end -->
