<!-- default badges list -->
![](https://img.shields.io/endpoint?url=https://codecentral.devexpress.com/api/v1/VersionRange/797233931/24.1.3%2B)
[![](https://img.shields.io/badge/Open_in_DevExpress_Support_Center-FF7200?style=flat-square&logo=DevExpress&logoColor=white)](https://supportcenter.devexpress.com/ticket/details/T1234967)
[![](https://img.shields.io/badge/📖_How_to_use_DevExpress_Examples-e9f6fc?style=flat-square)](https://docs.devexpress.com/GeneralInformation/403183)
[![](https://img.shields.io/badge/💬_Leave_Feedback-feecdd?style=flat-square)](#does-this-example-address-your-development-requirementsobjectives)
<!-- default badges end -->
# DevExpress CRM Demo for .NET MAUI

This repository includes a sample CRM application created with the [DevExpress .NET MAUI UI](https://www.devexpress.com/maui/) component suite.

![DevExpress Mobile UI for .NET MAUI](./images/crm-overview.png)

Use the following link to obtain the CRM Demo on Test Flight/Google Play:

[CRM Demo on Google Play](https://play.google.com/store/apps/details?id=com.devexpress.CrmDemo&pcampaignid=web_share) | [CRM Demo on TestFlight](https://testflight.apple.com/join/R4YeuQ49)

The demo app includes the following features/capabilities: 

## CRUD Views

Mobile-friendly CRUD flow (using an SQLite database): 

<img src="./images/crm-crud.png" alt="DevExpress CRM Demo - CRUD" height="700"> 

[Related Documentation Topic](https://docs.devexpress.com/MAUI/404421/collection-view/crud/crud-overview)

## Filtering UI

Basic and advanced .NET MAUI filtering UI elements:

<img src="./images/crm-filter-elements.png" alt="DevExpress CRM Demo - Filtering UI" height="700"> 

[Related Documentation Topic](https://docs.devexpress.com/MAUI/404126/collection-view/filter-sort-and-group-data#create-filtering-ui)

## CollectionView Master-Detail

Master-detail view that leverages the DevExpress .NET MAUI BottomSheet control to display selected item info:

<img src="./images/crm-master-detail.png" alt="DevExpress CRM Demo - Master-Detail" height="700"> 

[Related Documentation Topic](https://docs.devexpress.com/MAUI/404351/scenarios/bottomsheet)

## DataGrid Export

Export .NET MAUI DataGrid data to Excel and PDF:

<img src="./images/crm-export-data.png" alt="DevExpress CRM Demo - DataGrid Export" height="700"> 

[Related Documentation Topic](https://docs.devexpress.com/MAUI/404377/data-grid/export)

## Import to a DataGrid

Import Excel file data and display it within the DevExpress .NET MAUI DataGrid:

<img src="./images/crm-import-from-excel.png" alt="DevExpress CRM Demo - Import to a DataGrid" height="700"> 

## Document Processing

Document processing using the DevExpress Office File API library:

<img src="./images/crm-document-processing.png" alt="DevExpress CRM Demo - Document Processing" height="700"> 

[Related Documentation Topic](https://docs.devexpress.com/MAUI/404434/office-file-api-support)

## Reporting

Report generation powered by DevExpress Reports:

<img src="./images/crm-reports.png" alt="DevExpress CRM Demo - Reporting" height="700"> 

[Related Documentation Topic](https://docs.devexpress.com/XtraReports/404425/dot-net-maui-reporting/use-reporting-in-maui-apps)

## Material Design 3

Material Design 3 theme support:

<img src="./images/crm-material-design.png" alt="DevExpress CRM Demo - Material Design 3" height="700"> 

[Related Documentation Topic](https://docs.devexpress.com/MAUI/404636/common-concepts/themes)

## Data Visualization

Data visualization using charts and circular gauge:

<img src="./images/crm-charts.png" alt="DevExpress CRM Demo - Charts" height="700"> 

[Related Documentation Topic](https://docs.devexpress.com/MAUI/403300/charts/charts)

## Requirements

To build the project, please register the DevExpress NuGet Gallery in Visual Studio and restore NuGet packages used in this solution. See the following topic for more information in this regard: [Get Started with DevExpress Mobile UI for .NET MAUI](https://docs.devexpress.com/MAUI/403249/get-started).

> The DevExpress .NET MAUI PDF Viewer and HTML Edit controls require a DevExpress [Universal Subscription](https://www.devexpress.com/subscriptions/universal.xml). Without a valid/active license, you cannot use these controls within your .NET MAUI application.

If you are new to our .NET MAUI product line, please refer to the following YouTube video to get started and learn some of what’s possible when using our .NET MAUI libraries: [Setting up a .NET MAUI Project](https://www.youtube.com/watch?v=juJvl5UicIQ).

## Documentation

- [Data Grid](https://docs.devexpress.com/MAUI/403255/data-grid/data-grid)
- [Charts](https://docs.devexpress.com/MAUI/403300/charts/charts)
- [Data Form](https://docs.devexpress.com/MAUI/403640/data-form)
- [Navigation](https://docs.devexpress.com/MAUI/403297/navigation/index)
- [Data Editors](https://docs.devexpress.com/MAUI/403427/editors/index)
- [Collection View](https://docs.devexpress.com/MAUI/403324/collection-view/index)
- [Form Items](https://docs.devexpress.com/MAUI/404418/form-items/form-items)

## More Examples

* [Demo Center](https://github.com/DevExpress-Examples/maui-demo-app)
* [Data Grid](https://github.com/DevExpress-Examples/maui-data-grid-get-started)
* [Collection View](https://github.com/DevExpress-Examples/maui-collection-view-get-started)
* [Data Editors](https://github.com/DevExpress-Examples/maui-editors-get-started)
* [Data Form](https://github.com/DevExpress-Examples/maui-data-form-get-started)
* [Charts](https://github.com/DevExpress-Examples/maui-charts)
* [Scheduler](https://github.com/DevExpress-Examples/maui-scheduler-get-started)
* [Popup](https://github.com/DevExpress-Examples/maui-popup-get-started)
<!-- feedback -->
## Does this example address your development requirements/objectives?

[<img src="https://www.devexpress.com/support/examples/i/yes-button.svg"/>](https://www.devexpress.com/support/examples/survey.xml?utm_source=github&utm_campaign=maui-crm-demo&~~~was_helpful=yes) [<img src="https://www.devexpress.com/support/examples/i/no-button.svg"/>](https://www.devexpress.com/support/examples/survey.xml?utm_source=github&utm_campaign=maui-crm-demo&~~~was_helpful=no)

(you will be redirected to DevExpress.com to submit your response)
<!-- feedback end -->
