/*!
 * jQuery JavaScript Library v3.6.0
 * https://jquery.com/
 *
 * Includes Sizzle.js
 * https://sizzlejs.com/
 *
 * Copyright OpenJS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 * Date: 2021-03-02T17:08Z
 */
( function( global, factory ) {

	"use strict";

	if ( typeof module === "object" && typeof module.exports === "object" ) {

		// For CommonJS and CommonJS-like environments where a proper `window`
		// is present, execute the factory and get jQuery.
		// For environments that do not have a `window` with a `document`
		// (such as Node.js), expose a factory as module.exports.
		// This accentuates the need for the creation of a real `window`.
		// e.g. var jQuery = require("jquery")(window);
		// See ticket #14549 for more info.
		module.exports = global.document ?
			factory( global, true ) :
			function( w ) {
				if ( !w.document ) {
					throw new Error( "jQuery requires a window with a document" );
				}
				return factory( w );
			};
	} else {
		factory( global );
	}

// Pass this if window is not defined yet
} )( typeof window !== "undefined" ? window : this, function( window, noGlobal ) {

// Edge <= 12 - 13+, Firefox <=18 - 45+, IE 10 - 11, Safari 5.1 - 9+, iOS 6 - 9.1
// throw exceptions when non-strict code (e.g., ASP.NET 4.5) accesses strict mode
// arguments.callee.caller (trac-13335). But as of jQuery 3.0 (2016), strict mode should be common
// enough that all such attempts are guarded in a try block.
"use strict";

var arr = [];

var getProto = Object.getPrototypeOf;

var slice = arr.slice;

var flat = arr.flat ? function( array ) {
	return arr.flat.call( array );
} : function( array ) {
	return arr.concat.apply( [], array );
};


var push = arr.push;

var indexOf = arr.indexOf;

var class2type = {};

var toString = class2type.toString;

var hasOwn = class2type.hasOwnProperty;

var fnToString = hasOwn.toString;

var ObjectFunctionString = fnToString.call( Object );

var support = {};

var isFunction = function isFunction( obj ) {

		// Support: Chrome <=57, Firefox <=52
		// In some browsers, typeof returns "function" for HTML <object> elements
		// (i.e., `typeof document.createElement( "object" ) === "function"`).
		// We don't want to classify *any* DOM node as a function.
		// Support: QtWeb <=3.8.5, WebKit <=534.34, wkhtmltopdf tool <=0.12.5
		// Plus for old WebKit, typeof returns "function" for HTML collections
		// (e.g., `typeof document.getElementsByTagName("div") === "function"`). (gh-4756)
		return typeof obj === "function" && typeof obj.nodeType !== "number" &&
			typeof obj.item !== "function";
	};


var isWindow = function isWindow( obj ) {
		return obj != null && obj === obj.window;
	};


var document = window.document;



	var preservedScriptAttributes = {
		type: true,
		src: true,
		nonce: true,
		noModule: true
	};

	function DOMEval( code, node, doc ) {
		doc = doc || document;

		var i, val,
			script = doc.createElement( "script" );

		script.text = code;
		if ( node ) {
			for ( i in preservedScriptAttributes ) {

				// Support: Firefox 64+, Edge 18+
				// Some browsers don't support the "nonce" property on scripts.
				// On the other hand, just using `getAttribute` is not enough as
				// the `nonce` attribute is reset to an empty string whenever it
				// becomes browsing-context connected.
				// See https://github.com/whatwg/html/issues/2369
				// See https://html.spec.whatwg.org/#nonce-attributes
				// The `node.getAttribute` check was added for the sake of
				// `jQuery.globalEval` so that it can fake a nonce-containing node
				// via an object.
				val = node[ i ] || node.getAttribute && node.getAttribute( i );
				if ( val ) {
					script.setAttribute( i, val );
				}
			}
		}
		doc.head.appendChild( script ).parentNode.removeChild( script );
	}


function toType( obj ) {
	if ( obj == null ) {
		return obj + "";
	}

	// Support: Android <=2.3 only (functionish RegExp)
	return typeof obj === "object" || typeof obj === "function" ?
		class2type[ toString.call( obj ) ] || "object" :
		typeof obj;
}
/* global Symbol */
// Defining this global in .eslintrc.json would create a danger of using the global
// unguarded in another place, it seems safer to define global only for this module



var
	version = "3.6.0",

	// Define a local copy of jQuery
	jQuery = function( selector, context ) {

		// The jQuery object is actually just the init constructor 'enhanced'
		// Need init if jQuery is called (just allow error to be thrown if not included)
		return new jQuery.fn.init( selector, context );
	};

jQuery.fn = jQuery.prototype = {

	// The current version of jQuery being used
	jquery: version,

	constructor: jQuery,

	// The default length of a jQuery object is 0
	length: 0,

	toArray: function() {
		return slice.call( this );
	},

	// Get the Nth element in the matched element set OR
	// Get the whole matched element set as a clean array
	get: function( num ) {

		// Return all the elements in a clean array
		if ( num == null ) {
			return slice.call( this );
		}

		// Return just the one element from the set
		return num < 0 ? this[ num + this.length ] : this[ num ];
	},

	// Take an array of elements and push it onto the stack
	// (returning the new matched element set)
	pushStack: function( elems ) {

		// Build a new jQuery matched element set
		var ret = jQuery.merge( this.constructor(), elems );

		// Add the old object onto the stack (as a reference)
		ret.prevObject = this;

		// Return the newly-formed element set
		return ret;
	},

	// Execute a callback for every element in the matched set.
	each: function( callback ) {
		return jQuery.each( this, callback );
	},

	map: function( callback ) {
		return this.pushStack( jQuery.map( this, function( elem, i ) {
			return callback.call( elem, i, elem );
		} ) );
	},

	slice: function() {
		return this.pushStack( slice.apply( this, arguments ) );
	},

	first: function() {
		return this.eq( 0 );
	},

	last: function() {
		return this.eq( -1 );
	},

	even: function() {
		return this.pushStack( jQuery.grep( this, function( _elem, i ) {
			return ( i + 1 ) % 2;
		} ) );
	},

	odd: function() {
		return this.pushStack( jQuery.grep( this, function( _elem, i ) {
			return i % 2;
		} ) );
	},

	eq: function( i ) {
		var len = this.length,
			j = +i + ( i < 0 ? len : 0 );
		return this.pushStack( j >= 0 && j < len ? [ this[ j ] ] : [] );
	},

	end: function() {
		return this.prevObject || this.constructor();
	},

	// For internal use only.
	// Behaves like an Array's method, not like a jQuery method.
	push: push,
	sort: arr.sort,
	splice: arr.splice
};

jQuery.extend = jQuery.fn.extend = function() {
	var options, name, src, copy, copyIsArray, clone,
		target = arguments[ 0 ] || {},
		i = 1,
		length = arguments.length,
		deep = false;

	// Handle a deep copy situation
	if ( typeof target === "boolean" ) {
		deep = target;

		// Skip the boolean and the target
		target = arguments[ i ] || {};
		i++;
	}

	// Handle case when target is a string or something (possible in deep copy)
	if ( typeof target !== "object" && !isFunction( target ) ) {
		target = {};
	}

	// Extend jQuery itself if only one argument is passed
	if ( i === length ) {
		target = this;
		i--;
	}

	for ( ; i < length; i++ ) {

		// Only deal with non-null/undefined values
		if ( ( options = arguments[ i ] ) != null ) {

			// Extend the base object
			for ( name in options ) {
				copy = options[ name ];

				// Prevent Object.prototype pollution
				// Prevent never-ending loop
				if ( name === "__proto__" || target === copy ) {
					continue;
				}

				// Recurse if we're merging plain objects or arrays
				if ( deep && copy && ( jQuery.isPlainObject( copy ) ||
					( copyIsArray = Array.isArray( copy ) ) ) ) {
					src = target[ name ];

					// Ensure proper type for the source value
					if ( copyIsArray && !Array.isArray( src ) ) {
						clone = [];
					} else if ( !copyIsArray && !jQuery.isPlainObject( src ) ) {
						clone = {};
					} else {
						clone = src;
					}
					copyIsArray = false;

					// Never move original objects, clone them
					target[ name ] = jQuery.extend( deep, clone, copy );

				// Don't bring in undefined values
				} else if ( copy !== undefined ) {
					target[ name ] = copy;
				}
			}
		}
	}

	// Return the modified object
	return target;
};

jQuery.extend( {

	// Unique for each copy of jQuery on the page
	expando: "jQuery" + ( version + Math.random() ).replace( /\D/g, "" ),

	// Assume jQuery is ready without the ready module
	isReady: true,

	error: function( msg ) {
		throw new Error( msg );
	},

	noop: function() {},

	isPlainObject: function( obj ) {
		var proto, Ctor;

		// Detect obvious negatives
		// Use toString instead of jQuery.type to catch host objects
		if ( !obj || toString.call( obj ) !== "[object Object]" ) {
			return false;
		}

		proto = getProto( obj );

		// Objects with no prototype (e.g., `Object.create( null )`) are plain
		if ( !proto ) {
			return true;
		}

		// Objects with prototype are plain iff they were constructed by a global Object function
		Ctor = hasOwn.call( proto, "constructor" ) && proto.constructor;
		return typeof Ctor === "function" && fnToString.call( Ctor ) === ObjectFunctionString;
	},

	isEmptyObject: function( obj ) {
		var name;

		for ( name in obj ) {
			return false;
		}
		return true;
	},

	// Evaluates a script in a provided context; falls back to the global one
	// if not specified.
	globalEval: function( code, options, doc ) {
		DOMEval( code, { nonce: options && options.nonce }, doc );
	},

	each: function( obj, callback ) {
		var length, i = 0;

		if ( isArrayLike( obj ) ) {
			length = obj.length;
			for ( ; i < length; i++ ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		} else {
			for ( i in obj ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		}

		return obj;
	},

	// results is for internal usage only
	makeArray: function( arr, results ) {
		var ret = results || [];

		if ( arr != null ) {
			if ( isArrayLike( Object( arr ) ) ) {
				jQuery.merge( ret,
					typeof arr === "string" ?
						[ arr ] : arr
				);
			} else {
				push.call( ret, arr );
			}
		}

		return ret;
	},

	inArray: function( elem, arr, i ) {
		return arr == null ? -1 : indexOf.call( arr, elem, i );
	},

	// Support: Android <=4.0 only, PhantomJS 1 only
	// push.apply(_, arraylike) throws on ancient WebKit
	merge: function( first, second ) {
		var len = +second.length,
			j = 0,
			i = first.length;

		for ( ; j < len; j++ ) {
			first[ i++ ] = second[ j ];
		}

		first.length = i;

		return first;
	},

	grep: function( elems, callback, invert ) {
		var callbackInverse,
			matches = [],
			i = 0,
			length = elems.length,
			callbackExpect = !invert;

		// Go through the array, only saving the items
		// that pass the validator function
		for ( ; i < length; i++ ) {
			callbackInverse = !callback( elems[ i ], i );
			if ( callbackInverse !== callbackExpect ) {
				matches.push( elems[ i ] );
			}
		}

		return matches;
	},

	// arg is for internal usage only
	map: function( elems, callback, arg ) {
		var length, value,
			i = 0,
			ret = [];

		// Go through the array, translating each of the items to their new values
		if ( isArrayLike( elems ) ) {
			length = elems.length;
			for ( ; i < length; i++ ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}

		// Go through every key on the object,
		} else {
			for ( i in elems ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}
		}

		// Flatten any nested arrays
		return flat( ret );
	},

	// A global GUID counter for objects
	guid: 1,

	// jQuery.support is not used in Core but other projects attach their
	// properties to it so it needs to exist.
	support: support
} );

if ( typeof Symbol === "function" ) {
	jQuery.fn[ Symbol.iterator ] = arr[ Symbol.iterator ];
}

// Populate the class2type map
jQuery.each( "Boolean Number String Function Array Date RegExp Object Error Symbol".split( " " ),
	function( _i, name ) {
		class2type[ "[object " + name + "]" ] = name.toLowerCase();
	} );

function isArrayLike( obj ) {

	// Support: real iOS 8.2 only (not reproducible in simulator)
	// `in` check used to prevent JIT error (gh-2145)
	// hasOwn isn't used here due to false negatives
	// regarding Nodelist length in IE
	var length = !!obj && "length" in obj && obj.length,
		type = toType( obj );

	if ( isFunction( obj ) || isWindow( obj ) ) {
		return false;
	}

	return type === "array" || length === 0 ||
		typeof length === "number" && length > 0 && ( length - 1 ) in obj;
}
var Sizzle =
/*!
 * Sizzle CSS Selector Engine v2.3.6
 * https://sizzlejs.com/
 *
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://js.foundation/
 *
 * Date: 2021-02-16
 */
( function( window ) {
var i,
	support,
	Expr,
	getText,
	isXML,
	tokenize,
	compile,
	select,
	outermostContext,
	sortInput,
	hasDuplicate,

	// Local document vars
	setDocument,
	document,
	docElem,
	documentIsHTML,
	rbuggyQSA,
	rbuggyMatches,
	matches,
	contains,

	// Instance-specific data
	expando = "sizzle" + 1 * new Date(),
	preferredDoc = window.document,
	dirruns = 0,
	done = 0,
	classCache = createCache(),
	tokenCache = createCache(),
	compilerCache = createCache(),
	nonnativeSelectorCache = createCache(),
	sortOrder = function( a, b ) {
		if ( a === b ) {
			hasDuplicate = true;
		}
		return 0;
	},

	// Instance methods
	hasOwn = ( {} ).hasOwnProperty,
	arr = [],
	pop = arr.pop,
	pushNative = arr.push,
	push = arr.push,
	slice = arr.slice,

	// Use a stripped-down indexOf as it's faster than native
	// https://jsperf.com/thor-indexof-vs-for/5
	indexOf = function( list, elem ) {
		var i = 0,
			len = list.length;
		for ( ; i < len; i++ ) {
			if ( list[ i ] === elem ) {
				return i;
			}
		}
		return -1;
	},

	booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|" +
		"ismap|loop|multiple|open|readonly|required|scoped",

	// Regular expressions

	// http://www.w3.org/TR/css3-selectors/#whitespace
	whitespace = "[\\x20\\t\\r\\n\\f]",

	// https://www.w3.org/TR/css-syntax-3/#ident-token-diagram
	identifier = "(?:\\\\[\\da-fA-F]{1,6}" + whitespace +
		"?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",

	// Attribute selectors: http://www.w3.org/TR/selectors/#attribute-selectors
	attributes = "\\[" + whitespace + "*(" + identifier + ")(?:" + whitespace +

		// Operator (capture 2)
		"*([*^$|!~]?=)" + whitespace +

		// "Attribute values must be CSS identifiers [capture 5]
		// or strings [capture 3 or capture 4]"
		"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + identifier + "))|)" +
		whitespace + "*\\]",

	pseudos = ":(" + identifier + ")(?:\\((" +

		// To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:
		// 1. quoted (capture 3; capture 4 or capture 5)
		"('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" +

		// 2. simple (capture 6)
		"((?:\\\\.|[^\\\\()[\\]]|" + attributes + ")*)|" +

		// 3. anything else (capture 2)
		".*" +
		")\\)|)",

	// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
	rwhitespace = new RegExp( whitespace + "+", "g" ),
	rtrim = new RegExp( "^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" +
		whitespace + "+$", "g" ),

	rcomma = new RegExp( "^" + whitespace + "*," + whitespace + "*" ),
	rcombinators = new RegExp( "^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace +
		"*" ),
	rdescend = new RegExp( whitespace + "|>" ),

	rpseudo = new RegExp( pseudos ),
	ridentifier = new RegExp( "^" + identifier + "$" ),

	matchExpr = {
		"ID": new RegExp( "^#(" + identifier + ")" ),
		"CLASS": new RegExp( "^\\.(" + identifier + ")" ),
		"TAG": new RegExp( "^(" + identifier + "|[*])" ),
		"ATTR": new RegExp( "^" + attributes ),
		"PSEUDO": new RegExp( "^" + pseudos ),
		"CHILD": new RegExp( "^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" +
			whitespace + "*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" +
			whitespace + "*(\\d+)|))" + whitespace + "*\\)|)", "i" ),
		"bool": new RegExp( "^(?:" + booleans + ")$", "i" ),

		// For use in libraries implementing .is()
		// We use this for POS matching in `select`
		"needsContext": new RegExp( "^" + whitespace +
			"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace +
			"*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i" )
	},

	rhtml = /HTML$/i,
	rinputs = /^(?:input|select|textarea|button)$/i,
	rheader = /^h\d$/i,

	rnative = /^[^{]+\{\s*\[native \w/,

	// Easily-parseable/retrievable ID or TAG or CLASS selectors
	rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,

	rsibling = /[+~]/,

	// CSS escapes
	// http://www.w3.org/TR/CSS21/syndata.html#escaped-characters
	runescape = new RegExp( "\\\\[\\da-fA-F]{1,6}" + whitespace + "?|\\\\([^\\r\\n\\f])", "g" ),
	funescape = function( escape, nonHex ) {
		var high = "0x" + escape.slice( 1 ) - 0x10000;

		return nonHex ?

			// Strip the backslash prefix from a non-hex escape sequence
			nonHex :

			// Replace a hexadecimal escape sequence with the encoded Unicode code point
			// Support: IE <=11+
			// For values outside the Basic Multilingual Plane (BMP), manually construct a
			// surrogate pair
			high < 0 ?
				String.fromCharCode( high + 0x10000 ) :
				String.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );
	},

	// CSS string/identifier serialization
	// https://drafts.csswg.org/cssom/#common-serializing-idioms
	rcssescape = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,
	fcssescape = function( ch, asCodePoint ) {
		if ( asCodePoint ) {

			// U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER
			if ( ch === "\0" ) {
				return "\uFFFD";
			}

			// Control characters and (dependent upon position) numbers get escaped as code points
			return ch.slice( 0, -1 ) + "\\" +
				ch.charCodeAt( ch.length - 1 ).toString( 16 ) + " ";
		}

		// Other potentially-special ASCII characters get backslash-escaped
		return "\\" + ch;
	},

	// Used for iframes
	// See setDocument()
	// Removing the function wrapper causes a "Permission Denied"
	// error in IE
	unloadHandler = function() {
		setDocument();
	},

	inDisabledFieldset = addCombinator(
		function( elem ) {
			return elem.disabled === true && elem.nodeName.toLowerCase() === "fieldset";
		},
		{ dir: "parentNode", next: "legend" }
	);

// Optimize for push.apply( _, NodeList )
try {
	push.apply(
		( arr = slice.call( preferredDoc.childNodes ) ),
		preferredDoc.childNodes
	);

	// Support: Android<4.0
	// Detect silently failing push.apply
	// eslint-disable-next-line no-unused-expressions
	arr[ preferredDoc.childNodes.length ].nodeType;
} catch ( e ) {
	push = { apply: arr.length ?

		// Leverage slice if possible
		function( target, els ) {
			pushNative.apply( target, slice.call( els ) );
		} :

		// Support: IE<9
		// Otherwise append directly
		function( target, els ) {
			var j = target.length,
				i = 0;

			// Can't trust NodeList.length
			while ( ( target[ j++ ] = els[ i++ ] ) ) {}
			target.length = j - 1;
		}
	};
}

function Sizzle( selector, context, results, seed ) {
	var m, i, elem, nid, match, groups, newSelector,
		newContext = context && context.ownerDocument,

		// nodeType defaults to 9, since context defaults to document
		nodeType = context ? context.nodeType : 9;

	results = results || [];

	// Return early from calls with invalid selector or context
	if ( typeof selector !== "string" || !selector ||
		nodeType !== 1 && nodeType !== 9 && nodeType !== 11 ) {

		return results;
	}

	// Try to shortcut find operations (as opposed to filters) in HTML documents
	if ( !seed ) {
		setDocument( context );
		context = context || document;

		if ( documentIsHTML ) {

			// If the selector is sufficiently simple, try using a "get*By*" DOM method
			// (excepting DocumentFragment context, where the methods don't exist)
			if ( nodeType !== 11 && ( match = rquickExpr.exec( selector ) ) ) {

				// ID selector
				if ( ( m = match[ 1 ] ) ) {

					// Document context
					if ( nodeType === 9 ) {
						if ( ( elem = context.getElementById( m ) ) ) {

							// Support: IE, Opera, Webkit
							// TODO: identify versions
							// getElementById can match elements by name instead of ID
							if ( elem.id === m ) {
								results.push( elem );
								return results;
							}
						} else {
							return results;
						}

					// Element context
					} else {

						// Support: IE, Opera, Webkit
						// TODO: identify versions
						// getElementById can match elements by name instead of ID
						if ( newContext && ( elem = newContext.getElementById( m ) ) &&
							contains( context, elem ) &&
							elem.id === m ) {

							results.push( elem );
							return results;
						}
					}

				// Type selector
				} else if ( match[ 2 ] ) {
					push.apply( results, context.getElementsByTagName( selector ) );
					return results;

				// Class selector
				} else if ( ( m = match[ 3 ] ) && support.getElementsByClassName &&
					context.getElementsByClassName ) {

					push.apply( results, context.getElementsByClassName( m ) );
					return results;
				}
			}

			// Take advantage of querySelectorAll
			if ( support.qsa &&
				!nonnativeSelectorCache[ selector + " " ] &&
				( !rbuggyQSA || !rbuggyQSA.test( selector ) ) &&

				// Support: IE 8 only
				// Exclude object elements
				( nodeType !== 1 || context.nodeName.toLowerCase() !== "object" ) ) {

				newSelector = selector;
				newContext = context;

				// qSA considers elements outside a scoping root when evaluating child or
				// descendant combinators, which is not what we want.
				// In such cases, we work around the behavior by prefixing every selector in the
				// list with an ID selector referencing the scope context.
				// The technique has to be used as well when a leading combinator is used
				// as such selectors are not recognized by querySelectorAll.
				// Thanks to Andrew Dupont for this technique.
				if ( nodeType === 1 &&
					( rdescend.test( selector ) || rcombinators.test( selector ) ) ) {

					// Expand context for sibling selectors
					newContext = rsibling.test( selector ) && testContext( context.parentNode ) ||
						context;

					// We can use :scope instead of the ID hack if the browser
					// supports it & if we're not changing the context.
					if ( newContext !== context || !support.scope ) {

						// Capture the context ID, setting it first if necessary
						if ( ( nid = context.getAttribute( "id" ) ) ) {
							nid = nid.replace( rcssescape, fcssescape );
						} else {
							context.setAttribute( "id", ( nid = expando ) );
						}
					}

					// Prefix every selector in the list
					groups = tokenize( selector );
					i = groups.length;
					while ( i-- ) {
						groups[ i ] = ( nid ? "#" + nid : ":scope" ) + " " +
							toSelector( groups[ i ] );
					}
					newSelector = groups.join( "," );
				}

				try {
					push.apply( results,
						newContext.querySelectorAll( newSelector )
					);
					return results;
				} catch ( qsaError ) {
					nonnativeSelectorCache( selector, true );
				} finally {
					if ( nid === expando ) {
						context.removeAttribute( "id" );
					}
				}
			}
		}
	}

	// All others
	return select( selector.replace( rtrim, "$1" ), context, results, seed );
}

/**
 * Create key-value caches of limited size
 * @returns {function(string, object)} Returns the Object data after storing it on itself with
 *	property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)
 *	deleting the oldest entry
 */
function createCache() {
	var keys = [];

	function cache( key, value ) {

		// Use (key + " ") to avoid collision with native prototype properties (see Issue #157)
		if ( keys.push( key + " " ) > Expr.cacheLength ) {

			// Only keep the most recent entries
			delete cache[ keys.shift() ];
		}
		return ( cache[ key + " " ] = value );
	}
	return cache;
}

/**
 * Mark a function for special use by Sizzle
 * @param {Function} fn The function to mark
 */
function markFunction( fn ) {
	fn[ expando ] = true;
	return fn;
}

/**
 * Support testing using an element
 * @param {Function} fn Passed the created element and returns a boolean result
 */
function assert( fn ) {
	var el = document.createElement( "fieldset" );

	try {
		return !!fn( el );
	} catch ( e ) {
		return false;
	} finally {

		// Remove from its parent by default
		if ( el.parentNode ) {
			el.parentNode.removeChild( el );
		}

		// release memory in IE
		el = null;
	}
}

/**
 * Adds the same handler for all of the specified attrs
 * @param {String} attrs Pipe-separated list of attributes
 * @param {Function} handler The method that will be applied
 */
function addHandle( attrs, handler ) {
	var arr = attrs.split( "|" ),
		i = arr.length;

	while ( i-- ) {
		Expr.attrHandle[ arr[ i ] ] = handler;
	}
}

/**
 * Checks document order of two siblings
 * @param {Element} a
 * @param {Element} b
 * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b
 */
function siblingCheck( a, b ) {
	var cur = b && a,
		diff = cur && a.nodeType === 1 && b.nodeType === 1 &&
			a.sourceIndex - b.sourceIndex;

	// Use IE sourceIndex if available on both nodes
	if ( diff ) {
		return diff;
	}

	// Check if b follows a
	if ( cur ) {
		while ( ( cur = cur.nextSibling ) ) {
			if ( cur === b ) {
				return -1;
			}
		}
	}

	return a ? 1 : -1;
}

/**
 * Returns a function to use in pseudos for input types
 * @param {String} type
 */
function createInputPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return name === "input" && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for buttons
 * @param {String} type
 */
function createButtonPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return ( name === "input" || name === "button" ) && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for :enabled/:disabled
 * @param {Boolean} disabled true for :disabled; false for :enabled
 */
function createDisabledPseudo( disabled ) {

	// Known :disabled false positives: fieldset[disabled] > legend:nth-of-type(n+2) :can-disable
	return function( elem ) {

		// Only certain elements can match :enabled or :disabled
		// https://html.spec.whatwg.org/multipage/scripting.html#selector-enabled
		// https://html.spec.whatwg.org/multipage/scripting.html#selector-disabled
		if ( "form" in elem ) {

			// Check for inherited disabledness on relevant non-disabled elements:
			// * listed form-associated elements in a disabled fieldset
			//   https://html.spec.whatwg.org/multipage/forms.html#category-listed
			//   https://html.spec.whatwg.org/multipage/forms.html#concept-fe-disabled
			// * option elements in a disabled optgroup
			//   https://html.spec.whatwg.org/multipage/forms.html#concept-option-disabled
			// All such elements have a "form" property.
			if ( elem.parentNode && elem.disabled === false ) {

				// Option elements defer to a parent optgroup if present
				if ( "label" in elem ) {
					if ( "label" in elem.parentNode ) {
						return elem.parentNode.disabled === disabled;
					} else {
						return elem.disabled === disabled;
					}
				}

				// Support: IE 6 - 11
				// Use the isDisabled shortcut property to check for disabled fieldset ancestors
				return elem.isDisabled === disabled ||

					// Where there is no isDisabled, check manually
					/* jshint -W018 */
					elem.isDisabled !== !disabled &&
					inDisabledFieldset( elem ) === disabled;
			}

			return elem.disabled === disabled;

		// Try to winnow out elements that can't be disabled before trusting the disabled property.
		// Some victims get caught in our net (label, legend, menu, track), but it shouldn't
		// even exist on them, let alone have a boolean value.
		} else if ( "label" in elem ) {
			return elem.disabled === disabled;
		}

		// Remaining elements are neither :enabled nor :disabled
		return false;
	};
}

/**
 * Returns a function to use in pseudos for positionals
 * @param {Function} fn
 */
function createPositionalPseudo( fn ) {
	return markFunction( function( argument ) {
		argument = +argument;
		return markFunction( function( seed, matches ) {
			var j,
				matchIndexes = fn( [], seed.length, argument ),
				i = matchIndexes.length;

			// Match elements found at the specified indexes
			while ( i-- ) {
				if ( seed[ ( j = matchIndexes[ i ] ) ] ) {
					seed[ j ] = !( matches[ j ] = seed[ j ] );
				}
			}
		} );
	} );
}

/**
 * Checks a node for validity as a Sizzle context
 * @param {Element|Object=} context
 * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value
 */
function testContext( context ) {
	return context && typeof context.getElementsByTagName !== "undefined" && context;
}

// Expose support vars for convenience
support = Sizzle.support = {};

/**
 * Detects XML nodes
 * @param {Element|Object} elem An element or a document
 * @returns {Boolean} True iff elem is a non-HTML XML node
 */
isXML = Sizzle.isXML = function( elem ) {
	var namespace = elem && elem.namespaceURI,
		docElem = elem && ( elem.ownerDocument || elem ).documentElement;

	// Support: IE <=8
	// Assume HTML when documentElement doesn't yet exist, such as inside loading iframes
	// https://bugs.jquery.com/ticket/4833
	return !rhtml.test( namespace || docElem && docElem.nodeName || "HTML" );
};

/**
 * Sets document-related variables once based on the current document
 * @param {Element|Object} [doc] An element or document object to use to set the document
 * @returns {Object} Returns the current document
 */
setDocument = Sizzle.setDocument = function( node ) {
	var hasCompare, subWindow,
		doc = node ? node.ownerDocument || node : preferredDoc;

	// Return early if doc is invalid or already selected
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( doc == document || doc.nodeType !== 9 || !doc.documentElement ) {
		return document;
	}

	// Update global variables
	document = doc;
	docElem = document.documentElement;
	documentIsHTML = !isXML( document );

	// Support: IE 9 - 11+, Edge 12 - 18+
	// Accessing iframe documents after unload throws "permission denied" errors (jQuery #13936)
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( preferredDoc != document &&
		( subWindow = document.defaultView ) && subWindow.top !== subWindow ) {

		// Support: IE 11, Edge
		if ( subWindow.addEventListener ) {
			subWindow.addEventListener( "unload", unloadHandler, false );

		// Support: IE 9 - 10 only
		} else if ( subWindow.attachEvent ) {
			subWindow.attachEvent( "onunload", unloadHandler );
		}
	}

	// Support: IE 8 - 11+, Edge 12 - 18+, Chrome <=16 - 25 only, Firefox <=3.6 - 31 only,
	// Safari 4 - 5 only, Opera <=11.6 - 12.x only
	// IE/Edge & older browsers don't support the :scope pseudo-class.
	// Support: Safari 6.0 only
	// Safari 6.0 supports :scope but it's an alias of :root there.
	support.scope = assert( function( el ) {
		docElem.appendChild( el ).appendChild( document.createElement( "div" ) );
		return typeof el.querySelectorAll !== "undefined" &&
			!el.querySelectorAll( ":scope fieldset div" ).length;
	} );

	/* Attributes
	---------------------------------------------------------------------- */

	// Support: IE<8
	// Verify that getAttribute really returns attributes and not properties
	// (excepting IE8 booleans)
	support.attributes = assert( function( el ) {
		el.className = "i";
		return !el.getAttribute( "className" );
	} );

	/* getElement(s)By*
	---------------------------------------------------------------------- */

	// Check if getElementsByTagName("*") returns only elements
	support.getElementsByTagName = assert( function( el ) {
		el.appendChild( document.createComment( "" ) );
		return !el.getElementsByTagName( "*" ).length;
	} );

	// Support: IE<9
	support.getElementsByClassName = rnative.test( document.getElementsByClassName );

	// Support: IE<10
	// Check if getElementById returns elements by name
	// The broken getElementById methods don't pick up programmatically-set names,
	// so use a roundabout getElementsByName test
	support.getById = assert( function( el ) {
		docElem.appendChild( el ).id = expando;
		return !document.getElementsByName || !document.getElementsByName( expando ).length;
	} );

	// ID filter and find
	if ( support.getById ) {
		Expr.filter[ "ID" ] = function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				return elem.getAttribute( "id" ) === attrId;
			};
		};
		Expr.find[ "ID" ] = function( id, context ) {
			if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
				var elem = context.getElementById( id );
				return elem ? [ elem ] : [];
			}
		};
	} else {
		Expr.filter[ "ID" ] =  function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				var node = typeof elem.getAttributeNode !== "undefined" &&
					elem.getAttributeNode( "id" );
				return node && node.value === attrId;
			};
		};

		// Support: IE 6 - 7 only
		// getElementById is not reliable as a find shortcut
		Expr.find[ "ID" ] = function( id, context ) {
			if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
				var node, i, elems,
					elem = context.getElementById( id );

				if ( elem ) {

					// Verify the id attribute
					node = elem.getAttributeNode( "id" );
					if ( node && node.value === id ) {
						return [ elem ];
					}

					// Fall back on getElementsByName
					elems = context.getElementsByName( id );
					i = 0;
					while ( ( elem = elems[ i++ ] ) ) {
						node = elem.getAttributeNode( "id" );
						if ( node && node.value === id ) {
							return [ elem ];
						}
					}
				}

				return [];
			}
		};
	}

	// Tag
	Expr.find[ "TAG" ] = support.getElementsByTagName ?
		function( tag, context ) {
			if ( typeof context.getElementsByTagName !== "undefined" ) {
				return context.getElementsByTagName( tag );

			// DocumentFragment nodes don't have gEBTN
			} else if ( support.qsa ) {
				return context.querySelectorAll( tag );
			}
		} :

		function( tag, context ) {
			var elem,
				tmp = [],
				i = 0,

				// By happy coincidence, a (broken) gEBTN appears on DocumentFragment nodes too
				results = context.getElementsByTagName( tag );

			// Filter out possible comments
			if ( tag === "*" ) {
				while ( ( elem = results[ i++ ] ) ) {
					if ( elem.nodeType === 1 ) {
						tmp.push( elem );
					}
				}

				return tmp;
			}
			return results;
		};

	// Class
	Expr.find[ "CLASS" ] = support.getElementsByClassName && function( className, context ) {
		if ( typeof context.getElementsByClassName !== "undefined" && documentIsHTML ) {
			return context.getElementsByClassName( className );
		}
	};

	/* QSA/matchesSelector
	---------------------------------------------------------------------- */

	// QSA and matchesSelector support

	// matchesSelector(:active) reports false when true (IE9/Opera 11.5)
	rbuggyMatches = [];

	// qSa(:focus) reports false when true (Chrome 21)
	// We allow this because of a bug in IE8/9 that throws an error
	// whenever `document.activeElement` is accessed on an iframe
	// So, we allow :focus to pass through QSA all the time to avoid the IE error
	// See https://bugs.jquery.com/ticket/13378
	rbuggyQSA = [];

	if ( ( support.qsa = rnative.test( document.querySelectorAll ) ) ) {

		// Build QSA regex
		// Regex strategy adopted from Diego Perini
		assert( function( el ) {

			var input;

			// Select is set to empty string on purpose
			// This is to test IE's treatment of not explicitly
			// setting a boolean content attribute,
			// since its presence should be enough
			// https://bugs.jquery.com/ticket/12359
			docElem.appendChild( el ).innerHTML = "<a id='" + expando + "'></a>" +
				"<select id='" + expando + "-\r\\' msallowcapture=''>" +
				"<option selected=''></option></select>";

			// Support: IE8, Opera 11-12.16
			// Nothing should be selected when empty strings follow ^= or $= or *=
			// The test attribute must be unknown in Opera but "safe" for WinRT
			// https://msdn.microsoft.com/en-us/library/ie/hh465388.aspx#attribute_section
			if ( el.querySelectorAll( "[msallowcapture^='']" ).length ) {
				rbuggyQSA.push( "[*^$]=" + whitespace + "*(?:''|\"\")" );
			}

			// Support: IE8
			// Boolean attributes and "value" are not treated correctly
			if ( !el.querySelectorAll( "[selected]" ).length ) {
				rbuggyQSA.push( "\\[" + whitespace + "*(?:value|" + booleans + ")" );
			}

			// Support: Chrome<29, Android<4.4, Safari<7.0+, iOS<7.0+, PhantomJS<1.9.8+
			if ( !el.querySelectorAll( "[id~=" + expando + "-]" ).length ) {
				rbuggyQSA.push( "~=" );
			}

			// Support: IE 11+, Edge 15 - 18+
			// IE 11/Edge don't find elements on a `[name='']` query in some cases.
			// Adding a temporary attribute to the document before the selection works
			// around the issue.
			// Interestingly, IE 10 & older don't seem to have the issue.
			input = document.createElement( "input" );
			input.setAttribute( "name", "" );
			el.appendChild( input );
			if ( !el.querySelectorAll( "[name='']" ).length ) {
				rbuggyQSA.push( "\\[" + whitespace + "*name" + whitespace + "*=" +
					whitespace + "*(?:''|\"\")" );
			}

			// Webkit/Opera - :checked should return selected option elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			// IE8 throws error here and will not see later tests
			if ( !el.querySelectorAll( ":checked" ).length ) {
				rbuggyQSA.push( ":checked" );
			}

			// Support: Safari 8+, iOS 8+
			// https://bugs.webkit.org/show_bug.cgi?id=136851
			// In-page `selector#id sibling-combinator selector` fails
			if ( !el.querySelectorAll( "a#" + expando + "+*" ).length ) {
				rbuggyQSA.push( ".#.+[+~]" );
			}

			// Support: Firefox <=3.6 - 5 only
			// Old Firefox doesn't throw on a badly-escaped identifier.
			el.querySelectorAll( "\\\f" );
			rbuggyQSA.push( "[\\r\\n\\f]" );
		} );

		assert( function( el ) {
			el.innerHTML = "<a href='' disabled='disabled'></a>" +
				"<select disabled='disabled'><option/></select>";

			// Support: Windows 8 Native Apps
			// The type and name attributes are restricted during .innerHTML assignment
			var input = document.createElement( "input" );
			input.setAttribute( "type", "hidden" );
			el.appendChild( input ).setAttribute( "name", "D" );

			// Support: IE8
			// Enforce case-sensitivity of name attribute
			if ( el.querySelectorAll( "[name=d]" ).length ) {
				rbuggyQSA.push( "name" + whitespace + "*[*^$|!~]?=" );
			}

			// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
			// IE8 throws error here and will not see later tests
			if ( el.querySelectorAll( ":enabled" ).length !== 2 ) {
				rbuggyQSA.push( ":enabled", ":disabled" );
			}

			// Support: IE9-11+
			// IE's :disabled selector does not pick up the children of disabled fieldsets
			docElem.appendChild( el ).disabled = true;
			if ( el.querySelectorAll( ":disabled" ).length !== 2 ) {
				rbuggyQSA.push( ":enabled", ":disabled" );
			}

			// Support: Opera 10 - 11 only
			// Opera 10-11 does not throw on post-comma invalid pseudos
			el.querySelectorAll( "*,:x" );
			rbuggyQSA.push( ",.*:" );
		} );
	}

	if ( ( support.matchesSelector = rnative.test( ( matches = docElem.matches ||
		docElem.webkitMatchesSelector ||
		docElem.mozMatchesSelector ||
		docElem.oMatchesSelector ||
		docElem.msMatchesSelector ) ) ) ) {

		assert( function( el ) {

			// Check to see if it's possible to do matchesSelector
			// on a disconnected node (IE 9)
			support.disconnectedMatch = matches.call( el, "*" );

			// This should fail with an exception
			// Gecko does not error, returns false instead
			matches.call( el, "[s!='']:x" );
			rbuggyMatches.push( "!=", pseudos );
		} );
	}

	rbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join( "|" ) );
	rbuggyMatches = rbuggyMatches.length && new RegExp( rbuggyMatches.join( "|" ) );

	/* Contains
	---------------------------------------------------------------------- */
	hasCompare = rnative.test( docElem.compareDocumentPosition );

	// Element contains another
	// Purposefully self-exclusive
	// As in, an element does not contain itself
	contains = hasCompare || rnative.test( docElem.contains ) ?
		function( a, b ) {
			var adown = a.nodeType === 9 ? a.documentElement : a,
				bup = b && b.parentNode;
			return a === bup || !!( bup && bup.nodeType === 1 && (
				adown.contains ?
					adown.contains( bup ) :
					a.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16
			) );
		} :
		function( a, b ) {
			if ( b ) {
				while ( ( b = b.parentNode ) ) {
					if ( b === a ) {
						return true;
					}
				}
			}
			return false;
		};

	/* Sorting
	---------------------------------------------------------------------- */

	// Document order sorting
	sortOrder = hasCompare ?
	function( a, b ) {

		// Flag for duplicate removal
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		// Sort on method existence if only one input has compareDocumentPosition
		var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;
		if ( compare ) {
			return compare;
		}

		// Calculate position if both inputs belong to the same document
		// Support: IE 11+, Edge 17 - 18+
		// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
		// two documents; shallow comparisons work.
		// eslint-disable-next-line eqeqeq
		compare = ( a.ownerDocument || a ) == ( b.ownerDocument || b ) ?
			a.compareDocumentPosition( b ) :

			// Otherwise we know they are disconnected
			1;

		// Disconnected nodes
		if ( compare & 1 ||
			( !support.sortDetached && b.compareDocumentPosition( a ) === compare ) ) {

			// Choose the first element that is related to our preferred document
			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			// eslint-disable-next-line eqeqeq
			if ( a == document || a.ownerDocument == preferredDoc &&
				contains( preferredDoc, a ) ) {
				return -1;
			}

			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			// eslint-disable-next-line eqeqeq
			if ( b == document || b.ownerDocument == preferredDoc &&
				contains( preferredDoc, b ) ) {
				return 1;
			}

			// Maintain original order
			return sortInput ?
				( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :
				0;
		}

		return compare & 4 ? -1 : 1;
	} :
	function( a, b ) {

		// Exit early if the nodes are identical
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		var cur,
			i = 0,
			aup = a.parentNode,
			bup = b.parentNode,
			ap = [ a ],
			bp = [ b ];

		// Parentless nodes are either documents or disconnected
		if ( !aup || !bup ) {

			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			/* eslint-disable eqeqeq */
			return a == document ? -1 :
				b == document ? 1 :
				/* eslint-enable eqeqeq */
				aup ? -1 :
				bup ? 1 :
				sortInput ?
				( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :
				0;

		// If the nodes are siblings, we can do a quick check
		} else if ( aup === bup ) {
			return siblingCheck( a, b );
		}

		// Otherwise we need full lists of their ancestors for comparison
		cur = a;
		while ( ( cur = cur.parentNode ) ) {
			ap.unshift( cur );
		}
		cur = b;
		while ( ( cur = cur.parentNode ) ) {
			bp.unshift( cur );
		}

		// Walk down the tree looking for a discrepancy
		while ( ap[ i ] === bp[ i ] ) {
			i++;
		}

		return i ?

			// Do a sibling check if the nodes have a common ancestor
			siblingCheck( ap[ i ], bp[ i ] ) :

			// Otherwise nodes in our document sort first
			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			/* eslint-disable eqeqeq */
			ap[ i ] == preferredDoc ? -1 :
			bp[ i ] == preferredDoc ? 1 :
			/* eslint-enable eqeqeq */
			0;
	};

	return document;
};

Sizzle.matches = function( expr, elements ) {
	return Sizzle( expr, null, null, elements );
};

Sizzle.matchesSelector = function( elem, expr ) {
	setDocument( elem );

	if ( support.matchesSelector && documentIsHTML &&
		!nonnativeSelectorCache[ expr + " " ] &&
		( !rbuggyMatches || !rbuggyMatches.test( expr ) ) &&
		( !rbuggyQSA     || !rbuggyQSA.test( expr ) ) ) {

		try {
			var ret = matches.call( elem, expr );

			// IE 9's matchesSelector returns false on disconnected nodes
			if ( ret || support.disconnectedMatch ||

				// As well, disconnected nodes are said to be in a document
				// fragment in IE 9
				elem.document && elem.document.nodeType !== 11 ) {
				return ret;
			}
		} catch ( e ) {
			nonnativeSelectorCache( expr, true );
		}
	}

	return Sizzle( expr, document, null, [ elem ] ).length > 0;
};

Sizzle.contains = function( context, elem ) {

	// Set document vars if needed
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( ( context.ownerDocument || context ) != document ) {
		setDocument( context );
	}
	return contains( context, elem );
};

Sizzle.attr = function( elem, name ) {

	// Set document vars if needed
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( ( elem.ownerDocument || elem ) != document ) {
		setDocument( elem );
	}

	var fn = Expr.attrHandle[ name.toLowerCase() ],

		// Don't get fooled by Object.prototype properties (jQuery #13807)
		val = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?
			fn( elem, name, !documentIsHTML ) :
			undefined;

	return val !== undefined ?
		val :
		support.attributes || !documentIsHTML ?
			elem.getAttribute( name ) :
			( val = elem.getAttributeNode( name ) ) && val.specified ?
				val.value :
				null;
};

Sizzle.escape = function( sel ) {
	return ( sel + "" ).replace( rcssescape, fcssescape );
};

Sizzle.error = function( msg ) {
	throw new Error( "Syntax error, unrecognized expression: " + msg );
};

/**
 * Document sorting and removing duplicates
 * @param {ArrayLike} results
 */
Sizzle.uniqueSort = function( results ) {
	var elem,
		duplicates = [],
		j = 0,
		i = 0;

	// Unless we *know* we can detect duplicates, assume their presence
	hasDuplicate = !support.detectDuplicates;
	sortInput = !support.sortStable && results.slice( 0 );
	results.sort( sortOrder );

	if ( hasDuplicate ) {
		while ( ( elem = results[ i++ ] ) ) {
			if ( elem === results[ i ] ) {
				j = duplicates.push( i );
			}
		}
		while ( j-- ) {
			results.splice( duplicates[ j ], 1 );
		}
	}

	// Clear input after sorting to release objects
	// See https://github.com/jquery/sizzle/pull/225
	sortInput = null;

	return results;
};

/**
 * Utility function for retrieving the text value of an array of DOM nodes
 * @param {Array|Element} elem
 */
getText = Sizzle.getText = function( elem ) {
	var node,
		ret = "",
		i = 0,
		nodeType = elem.nodeType;

	if ( !nodeType ) {

		// If no nodeType, this is expected to be an array
		while ( ( node = elem[ i++ ] ) ) {

			// Do not traverse comment nodes
			ret += getText( node );
		}
	} else if ( nodeType === 1 || nodeType === 9 || nodeType === 11 ) {

		// Use textContent for elements
		// innerText usage removed for consistency of new lines (jQuery #11153)
		if ( typeof elem.textContent === "string" ) {
			return elem.textContent;
		} else {

			// Traverse its children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				ret += getText( elem );
			}
		}
	} else if ( nodeType === 3 || nodeType === 4 ) {
		return elem.nodeValue;
	}

	// Do not include comment or processing instruction nodes

	return ret;
};

Expr = Sizzle.selectors = {

	// Can be adjusted by the user
	cacheLength: 50,

	createPseudo: markFunction,

	match: matchExpr,

	attrHandle: {},

	find: {},

	relative: {
		">": { dir: "parentNode", first: true },
		" ": { dir: "parentNode" },
		"+": { dir: "previousSibling", first: true },
		"~": { dir: "previousSibling" }
	},

	preFilter: {
		"ATTR": function( match ) {
			match[ 1 ] = match[ 1 ].replace( runescape, funescape );

			// Move the given value to match[3] whether quoted or unquoted
			match[ 3 ] = ( match[ 3 ] || match[ 4 ] ||
				match[ 5 ] || "" ).replace( runescape, funescape );

			if ( match[ 2 ] === "~=" ) {
				match[ 3 ] = " " + match[ 3 ] + " ";
			}

			return match.slice( 0, 4 );
		},

		"CHILD": function( match ) {

			/* matches from matchExpr["CHILD"]
				1 type (only|nth|...)
				2 what (child|of-type)
				3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
				4 xn-component of xn+y argument ([+-]?\d*n|)
				5 sign of xn-component
				6 x of xn-component
				7 sign of y-component
				8 y of y-component
			*/
			match[ 1 ] = match[ 1 ].toLowerCase();

			if ( match[ 1 ].slice( 0, 3 ) === "nth" ) {

				// nth-* requires argument
				if ( !match[ 3 ] ) {
					Sizzle.error( match[ 0 ] );
				}

				// numeric x and y parameters for Expr.filter.CHILD
				// remember that false/true cast respectively to 0/1
				match[ 4 ] = +( match[ 4 ] ?
					match[ 5 ] + ( match[ 6 ] || 1 ) :
					2 * ( match[ 3 ] === "even" || match[ 3 ] === "odd" ) );
				match[ 5 ] = +( ( match[ 7 ] + match[ 8 ] ) || match[ 3 ] === "odd" );

				// other types prohibit arguments
			} else if ( match[ 3 ] ) {
				Sizzle.error( match[ 0 ] );
			}

			return match;
		},

		"PSEUDO": function( match ) {
			var excess,
				unquoted = !match[ 6 ] && match[ 2 ];

			if ( matchExpr[ "CHILD" ].test( match[ 0 ] ) ) {
				return null;
			}

			// Accept quoted arguments as-is
			if ( match[ 3 ] ) {
				match[ 2 ] = match[ 4 ] || match[ 5 ] || "";

			// Strip excess characters from unquoted arguments
			} else if ( unquoted && rpseudo.test( unquoted ) &&

				// Get excess from tokenize (recursively)
				( excess = tokenize( unquoted, true ) ) &&

				// advance to the next closing parenthesis
				( excess = unquoted.indexOf( ")", unquoted.length - excess ) - unquoted.length ) ) {

				// excess is a negative index
				match[ 0 ] = match[ 0 ].slice( 0, excess );
				match[ 2 ] = unquoted.slice( 0, excess );
			}

			// Return only captures needed by the pseudo filter method (type and argument)
			return match.slice( 0, 3 );
		}
	},

	filter: {

		"TAG": function( nodeNameSelector ) {
			var nodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();
			return nodeNameSelector === "*" ?
				function() {
					return true;
				} :
				function( elem ) {
					return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
				};
		},

		"CLASS": function( className ) {
			var pattern = classCache[ className + " " ];

			return pattern ||
				( pattern = new RegExp( "(^|" + whitespace +
					")" + className + "(" + whitespace + "|$)" ) ) && classCache(
						className, function( elem ) {
							return pattern.test(
								typeof elem.className === "string" && elem.className ||
								typeof elem.getAttribute !== "undefined" &&
									elem.getAttribute( "class" ) ||
								""
							);
				} );
		},

		"ATTR": function( name, operator, check ) {
			return function( elem ) {
				var result = Sizzle.attr( elem, name );

				if ( result == null ) {
					return operator === "!=";
				}
				if ( !operator ) {
					return true;
				}

				result += "";

				/* eslint-disable max-len */

				return operator === "=" ? result === check :
					operator === "!=" ? result !== check :
					operator === "^=" ? check && result.indexOf( check ) === 0 :
					operator === "*=" ? check && result.indexOf( check ) > -1 :
					operator === "$=" ? check && result.slice( -check.length ) === check :
					operator === "~=" ? ( " " + result.replace( rwhitespace, " " ) + " " ).indexOf( check ) > -1 :
					operator === "|=" ? result === check || result.slice( 0, check.length + 1 ) === check + "-" :
					false;
				/* eslint-enable max-len */

			};
		},

		"CHILD": function( type, what, _argument, first, last ) {
			var simple = type.slice( 0, 3 ) !== "nth",
				forward = type.slice( -4 ) !== "last",
				ofType = what === "of-type";

			return first === 1 && last === 0 ?

				// Shortcut for :nth-*(n)
				function( elem ) {
					return !!elem.parentNode;
				} :

				function( elem, _context, xml ) {
					var cache, uniqueCache, outerCache, node, nodeIndex, start,
						dir = simple !== forward ? "nextSibling" : "previousSibling",
						parent = elem.parentNode,
						name = ofType && elem.nodeName.toLowerCase(),
						useCache = !xml && !ofType,
						diff = false;

					if ( parent ) {

						// :(first|last|only)-(child|of-type)
						if ( simple ) {
							while ( dir ) {
								node = elem;
								while ( ( node = node[ dir ] ) ) {
									if ( ofType ?
										node.nodeName.toLowerCase() === name :
										node.nodeType === 1 ) {

										return false;
									}
								}

								// Reverse direction for :only-* (if we haven't yet done so)
								start = dir = type === "only" && !start && "nextSibling";
							}
							return true;
						}

						start = [ forward ? parent.firstChild : parent.lastChild ];

						// non-xml :nth-child(...) stores cache data on `parent`
						if ( forward && useCache ) {

							// Seek `elem` from a previously-cached index

							// ...in a gzip-friendly way
							node = parent;
							outerCache = node[ expando ] || ( node[ expando ] = {} );

							// Support: IE <9 only
							// Defend against cloned attroperties (jQuery gh-1709)
							uniqueCache = outerCache[ node.uniqueID ] ||
								( outerCache[ node.uniqueID ] = {} );

							cache = uniqueCache[ type ] || [];
							nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
							diff = nodeIndex && cache[ 2 ];
							node = nodeIndex && parent.childNodes[ nodeIndex ];

							while ( ( node = ++nodeIndex && node && node[ dir ] ||

								// Fallback to seeking `elem` from the start
								( diff = nodeIndex = 0 ) || start.pop() ) ) {

								// When found, cache indexes on `parent` and break
								if ( node.nodeType === 1 && ++diff && node === elem ) {
									uniqueCache[ type ] = [ dirruns, nodeIndex, diff ];
									break;
								}
							}

						} else {

							// Use previously-cached element index if available
							if ( useCache ) {

								// ...in a gzip-friendly way
								node = elem;
								outerCache = node[ expando ] || ( node[ expando ] = {} );

								// Support: IE <9 only
								// Defend against cloned attroperties (jQuery gh-1709)
								uniqueCache = outerCache[ node.uniqueID ] ||
									( outerCache[ node.uniqueID ] = {} );

								cache = uniqueCache[ type ] || [];
								nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
								diff = nodeIndex;
							}

							// xml :nth-child(...)
							// or :nth-last-child(...) or :nth(-last)?-of-type(...)
							if ( diff === false ) {

								// Use the same loop as above to seek `elem` from the start
								while ( ( node = ++nodeIndex && node && node[ dir ] ||
									( diff = nodeIndex = 0 ) || start.pop() ) ) {

									if ( ( ofType ?
										node.nodeName.toLowerCase() === name :
										node.nodeType === 1 ) &&
										++diff ) {

										// Cache the index of each encountered element
										if ( useCache ) {
											outerCache = node[ expando ] ||
												( node[ expando ] = {} );

											// Support: IE <9 only
											// Defend against cloned attroperties (jQuery gh-1709)
											uniqueCache = outerCache[ node.uniqueID ] ||
												( outerCache[ node.uniqueID ] = {} );

											uniqueCache[ type ] = [ dirruns, diff ];
										}

										if ( node === elem ) {
											break;
										}
									}
								}
							}
						}

						// Incorporate the offset, then check against cycle size
						diff -= last;
						return diff === first || ( diff % first === 0 && diff / first >= 0 );
					}
				};
		},

		"PSEUDO": function( pseudo, argument ) {

			// pseudo-class names are case-insensitive
			// http://www.w3.org/TR/selectors/#pseudo-classes
			// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
			// Remember that setFilters inherits from pseudos
			var args,
				fn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||
					Sizzle.error( "unsupported pseudo: " + pseudo );

			// The user may use createPseudo to indicate that
			// arguments are needed to create the filter function
			// just as Sizzle does
			if ( fn[ expando ] ) {
				return fn( argument );
			}

			// But maintain support for old signatures
			if ( fn.length > 1 ) {
				args = [ pseudo, pseudo, "", argument ];
				return Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?
					markFunction( function( seed, matches ) {
						var idx,
							matched = fn( seed, argument ),
							i = matched.length;
						while ( i-- ) {
							idx = indexOf( seed, matched[ i ] );
							seed[ idx ] = !( matches[ idx ] = matched[ i ] );
						}
					} ) :
					function( elem ) {
						return fn( elem, 0, args );
					};
			}

			return fn;
		}
	},

	pseudos: {

		// Potentially complex pseudos
		"not": markFunction( function( selector ) {

			// Trim the selector passed to compile
			// to avoid treating leading and trailing
			// spaces as combinators
			var input = [],
				results = [],
				matcher = compile( selector.replace( rtrim, "$1" ) );

			return matcher[ expando ] ?
				markFunction( function( seed, matches, _context, xml ) {
					var elem,
						unmatched = matcher( seed, null, xml, [] ),
						i = seed.length;

					// Match elements unmatched by `matcher`
					while ( i-- ) {
						if ( ( elem = unmatched[ i ] ) ) {
							seed[ i ] = !( matches[ i ] = elem );
						}
					}
				} ) :
				function( elem, _context, xml ) {
					input[ 0 ] = elem;
					matcher( input, null, xml, results );

					// Don't keep the element (issue #299)
					input[ 0 ] = null;
					return !results.pop();
				};
		} ),

		"has": markFunction( function( selector ) {
			return function( elem ) {
				return Sizzle( selector, elem ).length > 0;
			};
		} ),

		"contains": markFunction( function( text ) {
			text = text.replace( runescape, funescape );
			return function( elem ) {
				return ( elem.textContent || getText( elem ) ).indexOf( text ) > -1;
			};
		} ),

		// "Whether an element is represented by a :lang() selector
		// is based solely on the element's language value
		// being equal to the identifier C,
		// or beginning with the identifier C immediately followed by "-".
		// The matching of C against the element's language value is performed case-insensitively.
		// The identifier C does not have to be a valid language name."
		// http://www.w3.org/TR/selectors/#lang-pseudo
		"lang": markFunction( function( lang ) {

			// lang value must be a valid identifier
			if ( !ridentifier.test( lang || "" ) ) {
				Sizzle.error( "unsupported lang: " + lang );
			}
			lang = lang.replace( runescape, funescape ).toLowerCase();
			return function( elem ) {
				var elemLang;
				do {
					if ( ( elemLang = documentIsHTML ?
						elem.lang :
						elem.getAttribute( "xml:lang" ) || elem.getAttribute( "lang" ) ) ) {

						elemLang = elemLang.toLowerCase();
						return elemLang === lang || elemLang.indexOf( lang + "-" ) === 0;
					}
				} while ( ( elem = elem.parentNode ) && elem.nodeType === 1 );
				return false;
			};
		} ),

		// Miscellaneous
		"target": function( elem ) {
			var hash = window.location && window.location.hash;
			return hash && hash.slice( 1 ) === elem.id;
		},

		"root": function( elem ) {
			return elem === docElem;
		},

		"focus": function( elem ) {
			return elem === document.activeElement &&
				( !document.hasFocus || document.hasFocus() ) &&
				!!( elem.type || elem.href || ~elem.tabIndex );
		},

		// Boolean properties
		"enabled": createDisabledPseudo( false ),
		"disabled": createDisabledPseudo( true ),

		"checked": function( elem ) {

			// In CSS3, :checked should return both checked and selected elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			var nodeName = elem.nodeName.toLowerCase();
			return ( nodeName === "input" && !!elem.checked ) ||
				( nodeName === "option" && !!elem.selected );
		},

		"selected": function( elem ) {

			// Accessing this property makes selected-by-default
			// options in Safari work properly
			if ( elem.parentNode ) {
				// eslint-disable-next-line no-unused-expressions
				elem.parentNode.selectedIndex;
			}

			return elem.selected === true;
		},

		// Contents
		"empty": function( elem ) {

			// http://www.w3.org/TR/selectors/#empty-pseudo
			// :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),
			//   but not by others (comment: 8; processing instruction: 7; etc.)
			// nodeType < 6 works because attributes (2) do not appear as children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				if ( elem.nodeType < 6 ) {
					return false;
				}
			}
			return true;
		},

		"parent": function( elem ) {
			return !Expr.pseudos[ "empty" ]( elem );
		},

		// Element/input types
		"header": function( elem ) {
			return rheader.test( elem.nodeName );
		},

		"input": function( elem ) {
			return rinputs.test( elem.nodeName );
		},

		"button": function( elem ) {
			var name = elem.nodeName.toLowerCase();
			return name === "input" && elem.type === "button" || name === "button";
		},

		"text": function( elem ) {
			var attr;
			return elem.nodeName.toLowerCase() === "input" &&
				elem.type === "text" &&

				// Support: IE<8
				// New HTML5 attribute values (e.g., "search") appear with elem.type === "text"
				( ( attr = elem.getAttribute( "type" ) ) == null ||
					attr.toLowerCase() === "text" );
		},

		// Position-in-collection
		"first": createPositionalPseudo( function() {
			return [ 0 ];
		} ),

		"last": createPositionalPseudo( function( _matchIndexes, length ) {
			return [ length - 1 ];
		} ),

		"eq": createPositionalPseudo( function( _matchIndexes, length, argument ) {
			return [ argument < 0 ? argument + length : argument ];
		} ),

		"even": createPositionalPseudo( function( matchIndexes, length ) {
			var i = 0;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} ),

		"odd": createPositionalPseudo( function( matchIndexes, length ) {
			var i = 1;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} ),

		"lt": createPositionalPseudo( function( matchIndexes, length, argument ) {
			var i = argument < 0 ?
				argument + length :
				argument > length ?
					length :
					argument;
			for ( ; --i >= 0; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} ),

		"gt": createPositionalPseudo( function( matchIndexes, length, argument ) {
			var i = argument < 0 ? argument + length : argument;
			for ( ; ++i < length; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} )
	}
};

Expr.pseudos[ "nth" ] = Expr.pseudos[ "eq" ];

// Add button/input type pseudos
for ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {
	Expr.pseudos[ i ] = createInputPseudo( i );
}
for ( i in { submit: true, reset: true } ) {
	Expr.pseudos[ i ] = createButtonPseudo( i );
}

// Easy API for creating new setFilters
function setFilters() {}
setFilters.prototype = Expr.filters = Expr.pseudos;
Expr.setFilters = new setFilters();

tokenize = Sizzle.tokenize = function( selector, parseOnly ) {
	var matched, match, tokens, type,
		soFar, groups, preFilters,
		cached = tokenCache[ selector + " " ];

	if ( cached ) {
		return parseOnly ? 0 : cached.slice( 0 );
	}

	soFar = selector;
	groups = [];
	preFilters = Expr.preFilter;

	while ( soFar ) {

		// Comma and first run
		if ( !matched || ( match = rcomma.exec( soFar ) ) ) {
			if ( match ) {

				// Don't consume trailing commas as valid
				soFar = soFar.slice( match[ 0 ].length ) || soFar;
			}
			groups.push( ( tokens = [] ) );
		}

		matched = false;

		// Combinators
		if ( ( match = rcombinators.exec( soFar ) ) ) {
			matched = match.shift();
			tokens.push( {
				value: matched,

				// Cast descendant combinators to space
				type: match[ 0 ].replace( rtrim, " " )
			} );
			soFar = soFar.slice( matched.length );
		}

		// Filters
		for ( type in Expr.filter ) {
			if ( ( match = matchExpr[ type ].exec( soFar ) ) && ( !preFilters[ type ] ||
				( match = preFilters[ type ]( match ) ) ) ) {
				matched = match.shift();
				tokens.push( {
					value: matched,
					type: type,
					matches: match
				} );
				soFar = soFar.slice( matched.length );
			}
		}

		if ( !matched ) {
			break;
		}
	}

	// Return the length of the invalid excess
	// if we're just parsing
	// Otherwise, throw an error or return tokens
	return parseOnly ?
		soFar.length :
		soFar ?
			Sizzle.error( selector ) :

			// Cache the tokens
			tokenCache( selector, groups ).slice( 0 );
};

function toSelector( tokens ) {
	var i = 0,
		len = tokens.length,
		selector = "";
	for ( ; i < len; i++ ) {
		selector += tokens[ i ].value;
	}
	return selector;
}

function addCombinator( matcher, combinator, base ) {
	var dir = combinator.dir,
		skip = combinator.next,
		key = skip || dir,
		checkNonElements = base && key === "parentNode",
		doneName = done++;

	return combinator.first ?

		// Check against closest ancestor/preceding element
		function( elem, context, xml ) {
			while ( ( elem = elem[ dir ] ) ) {
				if ( elem.nodeType === 1 || checkNonElements ) {
					return matcher( elem, context, xml );
				}
			}
			return false;
		} :

		// Check against all ancestor/preceding elements
		function( elem, context, xml ) {
			var oldCache, uniqueCache, outerCache,
				newCache = [ dirruns, doneName ];

			// We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching
			if ( xml ) {
				while ( ( elem = elem[ dir ] ) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						if ( matcher( elem, context, xml ) ) {
							return true;
						}
					}
				}
			} else {
				while ( ( elem = elem[ dir ] ) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						outerCache = elem[ expando ] || ( elem[ expando ] = {} );

						// Support: IE <9 only
						// Defend against cloned attroperties (jQuery gh-1709)
						uniqueCache = outerCache[ elem.uniqueID ] ||
							( outerCache[ elem.uniqueID ] = {} );

						if ( skip && skip === elem.nodeName.toLowerCase() ) {
							elem = elem[ dir ] || elem;
						} else if ( ( oldCache = uniqueCache[ key ] ) &&
							oldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {

							// Assign to newCache so results back-propagate to previous elements
							return ( newCache[ 2 ] = oldCache[ 2 ] );
						} else {

							// Reuse newcache so results back-propagate to previous elements
							uniqueCache[ key ] = newCache;

							// A match means we're done; a fail means we have to keep checking
							if ( ( newCache[ 2 ] = matcher( elem, context, xml ) ) ) {
								return true;
							}
						}
					}
				}
			}
			return false;
		};
}

function elementMatcher( matchers ) {
	return matchers.length > 1 ?
		function( elem, context, xml ) {
			var i = matchers.length;
			while ( i-- ) {
				if ( !matchers[ i ]( elem, context, xml ) ) {
					return false;
				}
			}
			return true;
		} :
		matchers[ 0 ];
}

function multipleContexts( selector, contexts, results ) {
	var i = 0,
		len = contexts.length;
	for ( ; i < len; i++ ) {
		Sizzle( selector, contexts[ i ], results );
	}
	return results;
}

function condense( unmatched, map, filter, context, xml ) {
	var elem,
		newUnmatched = [],
		i = 0,
		len = unmatched.length,
		mapped = map != null;

	for ( ; i < len; i++ ) {
		if ( ( elem = unmatched[ i ] ) ) {
			if ( !filter || filter( elem, context, xml ) ) {
				newUnmatched.push( elem );
				if ( mapped ) {
					map.push( i );
				}
			}
		}
	}

	return newUnmatched;
}

function setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {
	if ( postFilter && !postFilter[ expando ] ) {
		postFilter = setMatcher( postFilter );
	}
	if ( postFinder && !postFinder[ expando ] ) {
		postFinder = setMatcher( postFinder, postSelector );
	}
	return markFunction( function( seed, results, context, xml ) {
		var temp, i, elem,
			preMap = [],
			postMap = [],
			preexisting = results.length,

			// Get initial elements from seed or context
			elems = seed || multipleContexts(
				selector || "*",
				context.nodeType ? [ context ] : context,
				[]
			),

			// Prefilter to get matcher input, preserving a map for seed-results synchronization
			matcherIn = preFilter && ( seed || !selector ) ?
				condense( elems, preMap, preFilter, context, xml ) :
				elems,

			matcherOut = matcher ?

				// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
				postFinder || ( seed ? preFilter : preexisting || postFilter ) ?

					// ...intermediate processing is necessary
					[] :

					// ...otherwise use results directly
					results :
				matcherIn;

		// Find primary matches
		if ( matcher ) {
			matcher( matcherIn, matcherOut, context, xml );
		}

		// Apply postFilter
		if ( postFilter ) {
			temp = condense( matcherOut, postMap );
			postFilter( temp, [], context, xml );

			// Un-match failing elements by moving them back to matcherIn
			i = temp.length;
			while ( i-- ) {
				if ( ( elem = temp[ i ] ) ) {
					matcherOut[ postMap[ i ] ] = !( matcherIn[ postMap[ i ] ] = elem );
				}
			}
		}

		if ( seed ) {
			if ( postFinder || preFilter ) {
				if ( postFinder ) {

					// Get the final matcherOut by condensing this intermediate into postFinder contexts
					temp = [];
					i = matcherOut.length;
					while ( i-- ) {
						if ( ( elem = matcherOut[ i ] ) ) {

							// Restore matcherIn since elem is not yet a final match
							temp.push( ( matcherIn[ i ] = elem ) );
						}
					}
					postFinder( null, ( matcherOut = [] ), temp, xml );
				}

				// Move matched elements from seed to results to keep them synchronized
				i = matcherOut.length;
				while ( i-- ) {
					if ( ( elem = matcherOut[ i ] ) &&
						( temp = postFinder ? indexOf( seed, elem ) : preMap[ i ] ) > -1 ) {

						seed[ temp ] = !( results[ temp ] = elem );
					}
				}
			}

		// Add elements to results, through postFinder if defined
		} else {
			matcherOut = condense(
				matcherOut === results ?
					matcherOut.splice( preexisting, matcherOut.length ) :
					matcherOut
			);
			if ( postFinder ) {
				postFinder( null, results, matcherOut, xml );
			} else {
				push.apply( results, matcherOut );
			}
		}
	} );
}

function matcherFromTokens( tokens ) {
	var checkContext, matcher, j,
		len = tokens.length,
		leadingRelative = Expr.relative[ tokens[ 0 ].type ],
		implicitRelative = leadingRelative || Expr.relative[ " " ],
		i = leadingRelative ? 1 : 0,

		// The foundational matcher ensures that elements are reachable from top-level context(s)
		matchContext = addCombinator( function( elem ) {
			return elem === checkContext;
		}, implicitRelative, true ),
		matchAnyContext = addCombinator( function( elem ) {
			return indexOf( checkContext, elem ) > -1;
		}, implicitRelative, true ),
		matchers = [ function( elem, context, xml ) {
			var ret = ( !leadingRelative && ( xml || context !== outermostContext ) ) || (
				( checkContext = context ).nodeType ?
					matchContext( elem, context, xml ) :
					matchAnyContext( elem, context, xml ) );

			// Avoid hanging onto element (issue #299)
			checkContext = null;
			return ret;
		} ];

	for ( ; i < len; i++ ) {
		if ( ( matcher = Expr.relative[ tokens[ i ].type ] ) ) {
			matchers = [ addCombinator( elementMatcher( matchers ), matcher ) ];
		} else {
			matcher = Expr.filter[ tokens[ i ].type ].apply( null, tokens[ i ].matches );

			// Return special upon seeing a positional matcher
			if ( matcher[ expando ] ) {

				// Find the next relative operator (if any) for proper handling
				j = ++i;
				for ( ; j < len; j++ ) {
					if ( Expr.relative[ tokens[ j ].type ] ) {
						break;
					}
				}
				return setMatcher(
					i > 1 && elementMatcher( matchers ),
					i > 1 && toSelector(

					// If the preceding token was a descendant combinator, insert an implicit any-element `*`
					tokens
						.slice( 0, i - 1 )
						.concat( { value: tokens[ i - 2 ].type === " " ? "*" : "" } )
					).replace( rtrim, "$1" ),
					matcher,
					i < j && matcherFromTokens( tokens.slice( i, j ) ),
					j < len && matcherFromTokens( ( tokens = tokens.slice( j ) ) ),
					j < len && toSelector( tokens )
				);
			}
			matchers.push( matcher );
		}
	}

	return elementMatcher( matchers );
}

function matcherFromGroupMatchers( elementMatchers, setMatchers ) {
	var bySet = setMatchers.length > 0,
		byElement = elementMatchers.length > 0,
		superMatcher = function( seed, context, xml, results, outermost ) {
			var elem, j, matcher,
				matchedCount = 0,
				i = "0",
				unmatched = seed && [],
				setMatched = [],
				contextBackup = outermostContext,

				// We must always have either seed elements or outermost context
				elems = seed || byElement && Expr.find[ "TAG" ]( "*", outermost ),

				// Use integer dirruns iff this is the outermost matcher
				dirrunsUnique = ( dirruns += contextBackup == null ? 1 : Math.random() || 0.1 ),
				len = elems.length;

			if ( outermost ) {

				// Support: IE 11+, Edge 17 - 18+
				// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
				// two documents; shallow comparisons work.
				// eslint-disable-next-line eqeqeq
				outermostContext = context == document || context || outermost;
			}

			// Add elements passing elementMatchers directly to results
			// Support: IE<9, Safari
			// Tolerate NodeList properties (IE: "length"; Safari: <number>) matching elements by id
			for ( ; i !== len && ( elem = elems[ i ] ) != null; i++ ) {
				if ( byElement && elem ) {
					j = 0;

					// Support: IE 11+, Edge 17 - 18+
					// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
					// two documents; shallow comparisons work.
					// eslint-disable-next-line eqeqeq
					if ( !context && elem.ownerDocument != document ) {
						setDocument( elem );
						xml = !documentIsHTML;
					}
					while ( ( matcher = elementMatchers[ j++ ] ) ) {
						if ( matcher( elem, context || document, xml ) ) {
							results.push( elem );
							break;
						}
					}
					if ( outermost ) {
						dirruns = dirrunsUnique;
					}
				}

				// Track unmatched elements for set filters
				if ( bySet ) {

					// They will have gone through all possible matchers
					if ( ( elem = !matcher && elem ) ) {
						matchedCount--;
					}

					// Lengthen the array for every element, matched or not
					if ( seed ) {
						unmatched.push( elem );
					}
				}
			}

			// `i` is now the count of elements visited above, and adding it to `matchedCount`
			// makes the latter nonnegative.
			matchedCount += i;

			// Apply set filters to unmatched elements
			// NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`
			// equals `i`), unless we didn't visit _any_ elements in the above loop because we have
			// no element matchers and no seed.
			// Incrementing an initially-string "0" `i` allows `i` to remain a string only in that
			// case, which will result in a "00" `matchedCount` that differs from `i` but is also
			// numerically zero.
			if ( bySet && i !== matchedCount ) {
				j = 0;
				while ( ( matcher = setMatchers[ j++ ] ) ) {
					matcher( unmatched, setMatched, context, xml );
				}

				if ( seed ) {

					// Reintegrate element matches to eliminate the need for sorting
					if ( matchedCount > 0 ) {
						while ( i-- ) {
							if ( !( unmatched[ i ] || setMatched[ i ] ) ) {
								setMatched[ i ] = pop.call( results );
							}
						}
					}

					// Discard index placeholder values to get only actual matches
					setMatched = condense( setMatched );
				}

				// Add matches to results
				push.apply( results, setMatched );

				// Seedless set matches succeeding multiple successful matchers stipulate sorting
				if ( outermost && !seed && setMatched.length > 0 &&
					( matchedCount + setMatchers.length ) > 1 ) {

					Sizzle.uniqueSort( results );
				}
			}

			// Override manipulation of globals by nested matchers
			if ( outermost ) {
				dirruns = dirrunsUnique;
				outermostContext = contextBackup;
			}

			return unmatched;
		};

	return bySet ?
		markFunction( superMatcher ) :
		superMatcher;
}

compile = Sizzle.compile = function( selector, match /* Internal Use Only */ ) {
	var i,
		setMatchers = [],
		elementMatchers = [],
		cached = compilerCache[ selector + " " ];

	if ( !cached ) {

		// Generate a function of recursive functions that can be used to check each element
		if ( !match ) {
			match = tokenize( selector );
		}
		i = match.length;
		while ( i-- ) {
			cached = matcherFromTokens( match[ i ] );
			if ( cached[ expando ] ) {
				setMatchers.push( cached );
			} else {
				elementMatchers.push( cached );
			}
		}

		// Cache the compiled function
		cached = compilerCache(
			selector,
			matcherFromGroupMatchers( elementMatchers, setMatchers )
		);

		// Save selector and tokenization
		cached.selector = selector;
	}
	return cached;
};

/**
 * A low-level selection function that works with Sizzle's compiled
 *  selector functions
 * @param {String|Function} selector A selector or a pre-compiled
 *  selector function built with Sizzle.compile
 * @param {Element} context
 * @param {Array} [results]
 * @param {Array} [seed] A set of elements to match against
 */
select = Sizzle.select = function( selector, context, results, seed ) {
	var i, tokens, token, type, find,
		compiled = typeof selector === "function" && selector,
		match = !seed && tokenize( ( selector = compiled.selector || selector ) );

	results = results || [];

	// Try to minimize operations if there is only one selector in the list and no seed
	// (the latter of which guarantees us context)
	if ( match.length === 1 ) {

		// Reduce context if the leading compound selector is an ID
		tokens = match[ 0 ] = match[ 0 ].slice( 0 );
		if ( tokens.length > 2 && ( token = tokens[ 0 ] ).type === "ID" &&
			context.nodeType === 9 && documentIsHTML && Expr.relative[ tokens[ 1 ].type ] ) {

			context = ( Expr.find[ "ID" ]( token.matches[ 0 ]
				.replace( runescape, funescape ), context ) || [] )[ 0 ];
			if ( !context ) {
				return results;

			// Precompiled matchers will still verify ancestry, so step up a level
			} else if ( compiled ) {
				context = context.parentNode;
			}

			selector = selector.slice( tokens.shift().value.length );
		}

		// Fetch a seed set for right-to-left matching
		i = matchExpr[ "needsContext" ].test( selector ) ? 0 : tokens.length;
		while ( i-- ) {
			token = tokens[ i ];

			// Abort if we hit a combinator
			if ( Expr.relative[ ( type = token.type ) ] ) {
				break;
			}
			if ( ( find = Expr.find[ type ] ) ) {

				// Search, expanding context for leading sibling combinators
				if ( ( seed = find(
					token.matches[ 0 ].replace( runescape, funescape ),
					rsibling.test( tokens[ 0 ].type ) && testContext( context.parentNode ) ||
						context
				) ) ) {

					// If seed is empty or no tokens remain, we can return early
					tokens.splice( i, 1 );
					selector = seed.length && toSelector( tokens );
					if ( !selector ) {
						push.apply( results, seed );
						return results;
					}

					break;
				}
			}
		}
	}

	// Compile and execute a filtering function if one is not provided
	// Provide `match` to avoid retokenization if we modified the selector above
	( compiled || compile( selector, match ) )(
		seed,
		context,
		!documentIsHTML,
		results,
		!context || rsibling.test( selector ) && testContext( context.parentNode ) || context
	);
	return results;
};

// One-time assignments

// Sort stability
support.sortStable = expando.split( "" ).sort( sortOrder ).join( "" ) === expando;

// Support: Chrome 14-35+
// Always assume duplicates if they aren't passed to the comparison function
support.detectDuplicates = !!hasDuplicate;

// Initialize against the default document
setDocument();

// Support: Webkit<537.32 - Safari 6.0.3/Chrome 25 (fixed in Chrome 27)
// Detached nodes confoundingly follow *each other*
support.sortDetached = assert( function( el ) {

	// Should return 1, but returns 4 (following)
	return el.compareDocumentPosition( document.createElement( "fieldset" ) ) & 1;
} );

// Support: IE<8
// Prevent attribute/property "interpolation"
// https://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx
if ( !assert( function( el ) {
	el.innerHTML = "<a href='#'></a>";
	return el.firstChild.getAttribute( "href" ) === "#";
} ) ) {
	addHandle( "type|href|height|width", function( elem, name, isXML ) {
		if ( !isXML ) {
			return elem.getAttribute( name, name.toLowerCase() === "type" ? 1 : 2 );
		}
	} );
}

// Support: IE<9
// Use defaultValue in place of getAttribute("value")
if ( !support.attributes || !assert( function( el ) {
	el.innerHTML = "<input/>";
	el.firstChild.setAttribute( "value", "" );
	return el.firstChild.getAttribute( "value" ) === "";
} ) ) {
	addHandle( "value", function( elem, _name, isXML ) {
		if ( !isXML && elem.nodeName.toLowerCase() === "input" ) {
			return elem.defaultValue;
		}
	} );
}

// Support: IE<9
// Use getAttributeNode to fetch booleans when getAttribute lies
if ( !assert( function( el ) {
	return el.getAttribute( "disabled" ) == null;
} ) ) {
	addHandle( booleans, function( elem, name, isXML ) {
		var val;
		if ( !isXML ) {
			return elem[ name ] === true ? name.toLowerCase() :
				( val = elem.getAttributeNode( name ) ) && val.specified ?
					val.value :
					null;
		}
	} );
}

return Sizzle;

} )( window );



jQuery.find = Sizzle;
jQuery.expr = Sizzle.selectors;

// Deprecated
jQuery.expr[ ":" ] = jQuery.expr.pseudos;
jQuery.uniqueSort = jQuery.unique = Sizzle.uniqueSort;
jQuery.text = Sizzle.getText;
jQuery.isXMLDoc = Sizzle.isXML;
jQuery.contains = Sizzle.contains;
jQuery.escapeSelector = Sizzle.escape;




var dir = function( elem, dir, until ) {
	var matched = [],
		truncate = until !== undefined;

	while ( ( elem = elem[ dir ] ) && elem.nodeType !== 9 ) {
		if ( elem.nodeType === 1 ) {
			if ( truncate && jQuery( elem ).is( until ) ) {
				break;
			}
			matched.push( elem );
		}
	}
	return matched;
};


var siblings = function( n, elem ) {
	var matched = [];

	for ( ; n; n = n.nextSibling ) {
		if ( n.nodeType === 1 && n !== elem ) {
			matched.push( n );
		}
	}

	return matched;
};


var rneedsContext = jQuery.expr.match.needsContext;



function nodeName( elem, name ) {

	return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();

}
var rsingleTag = ( /^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i );



// Implement the identical functionality for filter and not
function winnow( elements, qualifier, not ) {
	if ( isFunction( qualifier ) ) {
		return jQuery.grep( elements, function( elem, i ) {
			return !!qualifier.call( elem, i, elem ) !== not;
		} );
	}

	// Single element
	if ( qualifier.nodeType ) {
		return jQuery.grep( elements, function( elem ) {
			return ( elem === qualifier ) !== not;
		} );
	}

	// Arraylike of elements (jQuery, arguments, Array)
	if ( typeof qualifier !== "string" ) {
		return jQuery.grep( elements, function( elem ) {
			return ( indexOf.call( qualifier, elem ) > -1 ) !== not;
		} );
	}

	// Filtered directly for both simple and complex selectors
	return jQuery.filter( qualifier, elements, not );
}

jQuery.filter = function( expr, elems, not ) {
	var elem = elems[ 0 ];

	if ( not ) {
		expr = ":not(" + expr + ")";
	}

	if ( elems.length === 1 && elem.nodeType === 1 ) {
		return jQuery.find.matchesSelector( elem, expr ) ? [ elem ] : [];
	}

	return jQuery.find.matches( expr, jQuery.grep( elems, function( elem ) {
		return elem.nodeType === 1;
	} ) );
};

jQuery.fn.extend( {
	find: function( selector ) {
		var i, ret,
			len = this.length,
			self = this;

		if ( typeof selector !== "string" ) {
			return this.pushStack( jQuery( selector ).filter( function() {
				for ( i = 0; i < len; i++ ) {
					if ( jQuery.contains( self[ i ], this ) ) {
						return true;
					}
				}
			} ) );
		}

		ret = this.pushStack( [] );

		for ( i = 0; i < len; i++ ) {
			jQuery.find( selector, self[ i ], ret );
		}

		return len > 1 ? jQuery.uniqueSort( ret ) : ret;
	},
	filter: function( selector ) {
		return this.pushStack( winnow( this, selector || [], false ) );
	},
	not: function( selector ) {
		return this.pushStack( winnow( this, selector || [], true ) );
	},
	is: function( selector ) {
		return !!winnow(
			this,

			// If this is a positional/relative selector, check membership in the returned set
			// so $("p:first").is("p:last") won't return true for a doc with two "p".
			typeof selector === "string" && rneedsContext.test( selector ) ?
				jQuery( selector ) :
				selector || [],
			false
		).length;
	}
} );


// Initialize a jQuery object


// A central reference to the root jQuery(document)
var rootjQuery,

	// A simple way to check for HTML strings
	// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
	// Strict HTML recognition (#11290: must start with <)
	// Shortcut simple #id case for speed
	rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,

	init = jQuery.fn.init = function( selector, context, root ) {
		var match, elem;

		// HANDLE: $(""), $(null), $(undefined), $(false)
		if ( !selector ) {
			return this;
		}

		// Method init() accepts an alternate rootjQuery
		// so migrate can support jQuery.sub (gh-2101)
		root = root || rootjQuery;

		// Handle HTML strings
		if ( typeof selector === "string" ) {
			if ( selector[ 0 ] === "<" &&
				selector[ selector.length - 1 ] === ">" &&
				selector.length >= 3 ) {

				// Assume that strings that start and end with <> are HTML and skip the regex check
				match = [ null, selector, null ];

			} else {
				match = rquickExpr.exec( selector );
			}

			// Match html or make sure no context is specified for #id
			if ( match && ( match[ 1 ] || !context ) ) {

				// HANDLE: $(html) -> $(array)
				if ( match[ 1 ] ) {
					context = context instanceof jQuery ? context[ 0 ] : context;

					// Option to run scripts is true for back-compat
					// Intentionally let the error be thrown if parseHTML is not present
					jQuery.merge( this, jQuery.parseHTML(
						match[ 1 ],
						context && context.nodeType ? context.ownerDocument || context : document,
						true
					) );

					// HANDLE: $(html, props)
					if ( rsingleTag.test( match[ 1 ] ) && jQuery.isPlainObject( context ) ) {
						for ( match in context ) {

							// Properties of context are called as methods if possible
							if ( isFunction( this[ match ] ) ) {
								this[ match ]( context[ match ] );

							// ...and otherwise set as attributes
							} else {
								this.attr( match, context[ match ] );
							}
						}
					}

					return this;

				// HANDLE: $(#id)
				} else {
					elem = document.getElementById( match[ 2 ] );

					if ( elem ) {

						// Inject the element directly into the jQuery object
						this[ 0 ] = elem;
						this.length = 1;
					}
					return this;
				}

			// HANDLE: $(expr, $(...))
			} else if ( !context || context.jquery ) {
				return ( context || root ).find( selector );

			// HANDLE: $(expr, context)
			// (which is just equivalent to: $(context).find(expr)
			} else {
				return this.constructor( context ).find( selector );
			}

		// HANDLE: $(DOMElement)
		} else if ( selector.nodeType ) {
			this[ 0 ] = selector;
			this.length = 1;
			return this;

		// HANDLE: $(function)
		// Shortcut for document ready
		} else if ( isFunction( selector ) ) {
			return root.ready !== undefined ?
				root.ready( selector ) :

				// Execute immediately if ready is not present
				selector( jQuery );
		}

		return jQuery.makeArray( selector, this );
	};

// Give the init function the jQuery prototype for later instantiation
init.prototype = jQuery.fn;

// Initialize central reference
rootjQuery = jQuery( document );


var rparentsprev = /^(?:parents|prev(?:Until|All))/,

	// Methods guaranteed to produce a unique set when starting from a unique set
	guaranteedUnique = {
		children: true,
		contents: true,
		next: true,
		prev: true
	};

jQuery.fn.extend( {
	has: function( target ) {
		var targets = jQuery( target, this ),
			l = targets.length;

		return this.filter( function() {
			var i = 0;
			for ( ; i < l; i++ ) {
				if ( jQuery.contains( this, targets[ i ] ) ) {
					return true;
				}
			}
		} );
	},

	closest: function( selectors, context ) {
		var cur,
			i = 0,
			l = this.length,
			matched = [],
			targets = typeof selectors !== "string" && jQuery( selectors );

		// Positional selectors never match, since there's no _selection_ context
		if ( !rneedsContext.test( selectors ) ) {
			for ( ; i < l; i++ ) {
				for ( cur = this[ i ]; cur && cur !== context; cur = cur.parentNode ) {

					// Always skip document fragments
					if ( cur.nodeType < 11 && ( targets ?
						targets.index( cur ) > -1 :

						// Don't pass non-elements to Sizzle
						cur.nodeType === 1 &&
							jQuery.find.matchesSelector( cur, selectors ) ) ) {

						matched.push( cur );
						break;
					}
				}
			}
		}

		return this.pushStack( matched.length > 1 ? jQuery.uniqueSort( matched ) : matched );
	},

	// Determine the position of an element within the set
	index: function( elem ) {

		// No argument, return index in parent
		if ( !elem ) {
			return ( this[ 0 ] && this[ 0 ].parentNode ) ? this.first().prevAll().length : -1;
		}

		// Index in selector
		if ( typeof elem === "string" ) {
			return indexOf.call( jQuery( elem ), this[ 0 ] );
		}

		// Locate the position of the desired element
		return indexOf.call( this,

			// If it receives a jQuery object, the first element is used
			elem.jquery ? elem[ 0 ] : elem
		);
	},

	add: function( selector, context ) {
		return this.pushStack(
			jQuery.uniqueSort(
				jQuery.merge( this.get(), jQuery( selector, context ) )
			)
		);
	},

	addBack: function( selector ) {
		return this.add( selector == null ?
			this.prevObject : this.prevObject.filter( selector )
		);
	}
} );

function sibling( cur, dir ) {
	while ( ( cur = cur[ dir ] ) && cur.nodeType !== 1 ) {}
	return cur;
}

jQuery.each( {
	parent: function( elem ) {
		var parent = elem.parentNode;
		return parent && parent.nodeType !== 11 ? parent : null;
	},
	parents: function( elem ) {
		return dir( elem, "parentNode" );
	},
	parentsUntil: function( elem, _i, until ) {
		return dir( elem, "parentNode", until );
	},
	next: function( elem ) {
		return sibling( elem, "nextSibling" );
	},
	prev: function( elem ) {
		return sibling( elem, "previousSibling" );
	},
	nextAll: function( elem ) {
		return dir( elem, "nextSibling" );
	},
	prevAll: function( elem ) {
		return dir( elem, "previousSibling" );
	},
	nextUntil: function( elem, _i, until ) {
		return dir( elem, "nextSibling", until );
	},
	prevUntil: function( elem, _i, until ) {
		return dir( elem, "previousSibling", until );
	},
	siblings: function( elem ) {
		return siblings( ( elem.parentNode || {} ).firstChild, elem );
	},
	children: function( elem ) {
		return siblings( elem.firstChild );
	},
	contents: function( elem ) {
		if ( elem.contentDocument != null &&

			// Support: IE 11+
			// <object> elements with no `data` attribute has an object
			// `contentDocument` with a `null` prototype.
			getProto( elem.contentDocument ) ) {

			return elem.contentDocument;
		}

		// Support: IE 9 - 11 only, iOS 7 only, Android Browser <=4.3 only
		// Treat the template element as a regular one in browsers that
		// don't support it.
		if ( nodeName( elem, "template" ) ) {
			elem = elem.content || elem;
		}

		return jQuery.merge( [], elem.childNodes );
	}
}, function( name, fn ) {
	jQuery.fn[ name ] = function( until, selector ) {
		var matched = jQuery.map( this, fn, until );

		if ( name.slice( -5 ) !== "Until" ) {
			selector = until;
		}

		if ( selector && typeof selector === "string" ) {
			matched = jQuery.filter( selector, matched );
		}

		if ( this.length > 1 ) {

			// Remove duplicates
			if ( !guaranteedUnique[ name ] ) {
				jQuery.uniqueSort( matched );
			}

			// Reverse order for parents* and prev-derivatives
			if ( rparentsprev.test( name ) ) {
				matched.reverse();
			}
		}

		return this.pushStack( matched );
	};
} );
var rnothtmlwhite = ( /[^\x20\t\r\n\f]+/g );



// Convert String-formatted options into Object-formatted ones
function createOptions( options ) {
	var object = {};
	jQuery.each( options.match( rnothtmlwhite ) || [], function( _, flag ) {
		object[ flag ] = true;
	} );
	return object;
}

/*
 * Create a callback list using the following parameters:
 *
 *	options: an optional list of space-separated options that will change how
 *			the callback list behaves or a more traditional option object
 *
 * By default a callback list will act like an event callback list and can be
 * "fired" multiple times.
 *
 * Possible options:
 *
 *	once:			will ensure the callback list can only be fired once (like a Deferred)
 *
 *	memory:			will keep track of previous values and will call any callback added
 *					after the list has been fired right away with the latest "memorized"
 *					values (like a Deferred)
 *
 *	unique:			will ensure a callback can only be added once (no duplicate in the list)
 *
 *	stopOnFalse:	interrupt callings when a callback returns false
 *
 */
jQuery.Callbacks = function( options ) {

	// Convert options from String-formatted to Object-formatted if needed
	// (we check in cache first)
	options = typeof options === "string" ?
		createOptions( options ) :
		jQuery.extend( {}, options );

	var // Flag to know if list is currently firing
		firing,

		// Last fire value for non-forgettable lists
		memory,

		// Flag to know if list was already fired
		fired,

		// Flag to prevent firing
		locked,

		// Actual callback list
		list = [],

		// Queue of execution data for repeatable lists
		queue = [],

		// Index of currently firing callback (modified by add/remove as needed)
		firingIndex = -1,

		// Fire callbacks
		fire = function() {

			// Enforce single-firing
			locked = locked || options.once;

			// Execute callbacks for all pending executions,
			// respecting firingIndex overrides and runtime changes
			fired = firing = true;
			for ( ; queue.length; firingIndex = -1 ) {
				memory = queue.shift();
				while ( ++firingIndex < list.length ) {

					// Run callback and check for early termination
					if ( list[ firingIndex ].apply( memory[ 0 ], memory[ 1 ] ) === false &&
						options.stopOnFalse ) {

						// Jump to end and forget the data so .add doesn't re-fire
						firingIndex = list.length;
						memory = false;
					}
				}
			}

			// Forget the data if we're done with it
			if ( !options.memory ) {
				memory = false;
			}

			firing = false;

			// Clean up if we're done firing for good
			if ( locked ) {

				// Keep an empty list if we have data for future add calls
				if ( memory ) {
					list = [];

				// Otherwise, this object is spent
				} else {
					list = "";
				}
			}
		},

		// Actual Callbacks object
		self = {

			// Add a callback or a collection of callbacks to the list
			add: function() {
				if ( list ) {

					// If we have memory from a past run, we should fire after adding
					if ( memory && !firing ) {
						firingIndex = list.length - 1;
						queue.push( memory );
					}

					( function add( args ) {
						jQuery.each( args, function( _, arg ) {
							if ( isFunction( arg ) ) {
								if ( !options.unique || !self.has( arg ) ) {
									list.push( arg );
								}
							} else if ( arg && arg.length && toType( arg ) !== "string" ) {

								// Inspect recursively
								add( arg );
							}
						} );
					} )( arguments );

					if ( memory && !firing ) {
						fire();
					}
				}
				return this;
			},

			// Remove a callback from the list
			remove: function() {
				jQuery.each( arguments, function( _, arg ) {
					var index;
					while ( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {
						list.splice( index, 1 );

						// Handle firing indexes
						if ( index <= firingIndex ) {
							firingIndex--;
						}
					}
				} );
				return this;
			},

			// Check if a given callback is in the list.
			// If no argument is given, return whether or not list has callbacks attached.
			has: function( fn ) {
				return fn ?
					jQuery.inArray( fn, list ) > -1 :
					list.length > 0;
			},

			// Remove all callbacks from the list
			empty: function() {
				if ( list ) {
					list = [];
				}
				return this;
			},

			// Disable .fire and .add
			// Abort any current/pending executions
			// Clear all callbacks and values
			disable: function() {
				locked = queue = [];
				list = memory = "";
				return this;
			},
			disabled: function() {
				return !list;
			},

			// Disable .fire
			// Also disable .add unless we have memory (since it would have no effect)
			// Abort any pending executions
			lock: function() {
				locked = queue = [];
				if ( !memory && !firing ) {
					list = memory = "";
				}
				return this;
			},
			locked: function() {
				return !!locked;
			},

			// Call all callbacks with the given context and arguments
			fireWith: function( context, args ) {
				if ( !locked ) {
					args = args || [];
					args = [ context, args.slice ? args.slice() : args ];
					queue.push( args );
					if ( !firing ) {
						fire();
					}
				}
				return this;
			},

			// Call all the callbacks with the given arguments
			fire: function() {
				self.fireWith( this, arguments );
				return this;
			},

			// To know if the callbacks have already been called at least once
			fired: function() {
				return !!fired;
			}
		};

	return self;
};


function Identity( v ) {
	return v;
}
function Thrower( ex ) {
	throw ex;
}

function adoptValue( value, resolve, reject, noValue ) {
	var method;

	try {

		// Check for promise aspect first to privilege synchronous behavior
		if ( value && isFunction( ( method = value.promise ) ) ) {
			method.call( value ).done( resolve ).fail( reject );

		// Other thenables
		} else if ( value && isFunction( ( method = value.then ) ) ) {
			method.call( value, resolve, reject );

		// Other non-thenables
		} else {

			// Control `resolve` arguments by letting Array#slice cast boolean `noValue` to integer:
			// * false: [ value ].slice( 0 ) => resolve( value )
			// * true: [ value ].slice( 1 ) => resolve()
			resolve.apply( undefined, [ value ].slice( noValue ) );
		}

	// For Promises/A+, convert exceptions into rejections
	// Since jQuery.when doesn't unwrap thenables, we can skip the extra checks appearing in
	// Deferred#then to conditionally suppress rejection.
	} catch ( value ) {

		// Support: Android 4.0 only
		// Strict mode functions invoked without .call/.apply get global-object context
		reject.apply( undefined, [ value ] );
	}
}

jQuery.extend( {

	Deferred: function( func ) {
		var tuples = [

				// action, add listener, callbacks,
				// ... .then handlers, argument index, [final state]
				[ "notify", "progress", jQuery.Callbacks( "memory" ),
					jQuery.Callbacks( "memory" ), 2 ],
				[ "resolve", "done", jQuery.Callbacks( "once memory" ),
					jQuery.Callbacks( "once memory" ), 0, "resolved" ],
				[ "reject", "fail", jQuery.Callbacks( "once memory" ),
					jQuery.Callbacks( "once memory" ), 1, "rejected" ]
			],
			state = "pending",
			promise = {
				state: function() {
					return state;
				},
				always: function() {
					deferred.done( arguments ).fail( arguments );
					return this;
				},
				"catch": function( fn ) {
					return promise.then( null, fn );
				},

				// Keep pipe for back-compat
				pipe: function( /* fnDone, fnFail, fnProgress */ ) {
					var fns = arguments;

					return jQuery.Deferred( function( newDefer ) {
						jQuery.each( tuples, function( _i, tuple ) {

							// Map tuples (progress, done, fail) to arguments (done, fail, progress)
							var fn = isFunction( fns[ tuple[ 4 ] ] ) && fns[ tuple[ 4 ] ];

							// deferred.progress(function() { bind to newDefer or newDefer.notify })
							// deferred.done(function() { bind to newDefer or newDefer.resolve })
							// deferred.fail(function() { bind to newDefer or newDefer.reject })
							deferred[ tuple[ 1 ] ]( function() {
								var returned = fn && fn.apply( this, arguments );
								if ( returned && isFunction( returned.promise ) ) {
									returned.promise()
										.progress( newDefer.notify )
										.done( newDefer.resolve )
										.fail( newDefer.reject );
								} else {
									newDefer[ tuple[ 0 ] + "With" ](
										this,
										fn ? [ returned ] : arguments
									);
								}
							} );
						} );
						fns = null;
					} ).promise();
				},
				then: function( onFulfilled, onRejected, onProgress ) {
					var maxDepth = 0;
					function resolve( depth, deferred, handler, special ) {
						return function() {
							var that = this,
								args = arguments,
								mightThrow = function() {
									var returned, then;

									// Support: Promises/A+ section 2.3.3.3.3
									// https://promisesaplus.com/#point-59
									// Ignore double-resolution attempts
									if ( depth < maxDepth ) {
										return;
									}

									returned = handler.apply( that, args );

									// Support: Promises/A+ section 2.3.1
									// https://promisesaplus.com/#point-48
									if ( returned === deferred.promise() ) {
										throw new TypeError( "Thenable self-resolution" );
									}

									// Support: Promises/A+ sections 2.3.3.1, 3.5
									// https://promisesaplus.com/#point-54
									// https://promisesaplus.com/#point-75
									// Retrieve `then` only once
									then = returned &&

										// Support: Promises/A+ section 2.3.4
										// https://promisesaplus.com/#point-64
										// Only check objects and functions for thenability
										( typeof returned === "object" ||
											typeof returned === "function" ) &&
										returned.then;

									// Handle a returned thenable
									if ( isFunction( then ) ) {

										// Special processors (notify) just wait for resolution
										if ( special ) {
											then.call(
												returned,
												resolve( maxDepth, deferred, Identity, special ),
												resolve( maxDepth, deferred, Thrower, special )
											);

										// Normal processors (resolve) also hook into progress
										} else {

											// ...and disregard older resolution values
											maxDepth++;

											then.call(
												returned,
												resolve( maxDepth, deferred, Identity, special ),
												resolve( maxDepth, deferred, Thrower, special ),
												resolve( maxDepth, deferred, Identity,
													deferred.notifyWith )
											);
										}

									// Handle all other returned values
									} else {

										// Only substitute handlers pass on context
										// and multiple values (non-spec behavior)
										if ( handler !== Identity ) {
											that = undefined;
											args = [ returned ];
										}

										// Process the value(s)
										// Default process is resolve
										( special || deferred.resolveWith )( that, args );
									}
								},

								// Only normal processors (resolve) catch and reject exceptions
								process = special ?
									mightThrow :
									function() {
										try {
											mightThrow();
										} catch ( e ) {

											if ( jQuery.Deferred.exceptionHook ) {
												jQuery.Deferred.exceptionHook( e,
													process.stackTrace );
											}

											// Support: Promises/A+ section 2.3.3.3.4.1
											// https://promisesaplus.com/#point-61
											// Ignore post-resolution exceptions
											if ( depth + 1 >= maxDepth ) {

												// Only substitute handlers pass on context
												// and multiple values (non-spec behavior)
												if ( handler !== Thrower ) {
													that = undefined;
													args = [ e ];
												}

												deferred.rejectWith( that, args );
											}
										}
									};

							// Support: Promises/A+ section 2.3.3.3.1
							// https://promisesaplus.com/#point-57
							// Re-resolve promises immediately to dodge false rejection from
							// subsequent errors
							if ( depth ) {
								process();
							} else {

								// Call an optional hook to record the stack, in case of exception
								// since it's otherwise lost when execution goes async
								if ( jQuery.Deferred.getStackHook ) {
									process.stackTrace = jQuery.Deferred.getStackHook();
								}
								window.setTimeout( process );
							}
						};
					}

					return jQuery.Deferred( function( newDefer ) {

						// progress_handlers.add( ... )
						tuples[ 0 ][ 3 ].add(
							resolve(
								0,
								newDefer,
								isFunction( onProgress ) ?
									onProgress :
									Identity,
								newDefer.notifyWith
							)
						);

						// fulfilled_handlers.add( ... )
						tuples[ 1 ][ 3 ].add(
							resolve(
								0,
								newDefer,
								isFunction( onFulfilled ) ?
									onFulfilled :
									Identity
							)
						);

						// rejected_handlers.add( ... )
						tuples[ 2 ][ 3 ].add(
							resolve(
								0,
								newDefer,
								isFunction( onRejected ) ?
									onRejected :
									Thrower
							)
						);
					} ).promise();
				},

				// Get a promise for this deferred
				// If obj is provided, the promise aspect is added to the object
				promise: function( obj ) {
					return obj != null ? jQuery.extend( obj, promise ) : promise;
				}
			},
			deferred = {};

		// Add list-specific methods
		jQuery.each( tuples, function( i, tuple ) {
			var list = tuple[ 2 ],
				stateString = tuple[ 5 ];

			// promise.progress = list.add
			// promise.done = list.add
			// promise.fail = list.add
			promise[ tuple[ 1 ] ] = list.add;

			// Handle state
			if ( stateString ) {
				list.add(
					function() {

						// state = "resolved" (i.e., fulfilled)
						// state = "rejected"
						state = stateString;
					},

					// rejected_callbacks.disable
					// fulfilled_callbacks.disable
					tuples[ 3 - i ][ 2 ].disable,

					// rejected_handlers.disable
					// fulfilled_handlers.disable
					tuples[ 3 - i ][ 3 ].disable,

					// progress_callbacks.lock
					tuples[ 0 ][ 2 ].lock,

					// progress_handlers.lock
					tuples[ 0 ][ 3 ].lock
				);
			}

			// progress_handlers.fire
			// fulfilled_handlers.fire
			// rejected_handlers.fire
			list.add( tuple[ 3 ].fire );

			// deferred.notify = function() { deferred.notifyWith(...) }
			// deferred.resolve = function() { deferred.resolveWith(...) }
			// deferred.reject = function() { deferred.rejectWith(...) }
			deferred[ tuple[ 0 ] ] = function() {
				deferred[ tuple[ 0 ] + "With" ]( this === deferred ? undefined : this, arguments );
				return this;
			};

			// deferred.notifyWith = list.fireWith
			// deferred.resolveWith = list.fireWith
			// deferred.rejectWith = list.fireWith
			deferred[ tuple[ 0 ] + "With" ] = list.fireWith;
		} );

		// Make the deferred a promise
		promise.promise( deferred );

		// Call given func if any
		if ( func ) {
			func.call( deferred, deferred );
		}

		// All done!
		return deferred;
	},

	// Deferred helper
	when: function( singleValue ) {
		var

			// count of uncompleted subordinates
			remaining = arguments.length,

			// count of unprocessed arguments
			i = remaining,

			// subordinate fulfillment data
			resolveContexts = Array( i ),
			resolveValues = slice.call( arguments ),

			// the primary Deferred
			primary = jQuery.Deferred(),

			// subordinate callback factory
			updateFunc = function( i ) {
				return function( value ) {
					resolveContexts[ i ] = this;
					resolveValues[ i ] = arguments.length > 1 ? slice.call( arguments ) : value;
					if ( !( --remaining ) ) {
						primary.resolveWith( resolveContexts, resolveValues );
					}
				};
			};

		// Single- and empty arguments are adopted like Promise.resolve
		if ( remaining <= 1 ) {
			adoptValue( singleValue, primary.done( updateFunc( i ) ).resolve, primary.reject,
				!remaining );

			// Use .then() to unwrap secondary thenables (cf. gh-3000)
			if ( primary.state() === "pending" ||
				isFunction( resolveValues[ i ] && resolveValues[ i ].then ) ) {

				return primary.then();
			}
		}

		// Multiple arguments are aggregated like Promise.all array elements
		while ( i-- ) {
			adoptValue( resolveValues[ i ], updateFunc( i ), primary.reject );
		}

		return primary.promise();
	}
} );


// These usually indicate a programmer mistake during development,
// warn about them ASAP rather than swallowing them by default.
var rerrorNames = /^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;

jQuery.Deferred.exceptionHook = function( error, stack ) {

	// Support: IE 8 - 9 only
	// Console exists when dev tools are open, which can happen at any time
	if ( window.console && window.console.warn && error && rerrorNames.test( error.name ) ) {
		window.console.warn( "jQuery.Deferred exception: " + error.message, error.stack, stack );
	}
};




jQuery.readyException = function( error ) {
	window.setTimeout( function() {
		throw error;
	} );
};




// The deferred used on DOM ready
var readyList = jQuery.Deferred();

jQuery.fn.ready = function( fn ) {

	readyList
		.then( fn )

		// Wrap jQuery.readyException in a function so that the lookup
		// happens at the time of error handling instead of callback
		// registration.
		.catch( function( error ) {
			jQuery.readyException( error );
		} );

	return this;
};

jQuery.extend( {

	// Is the DOM ready to be used? Set to true once it occurs.
	isReady: false,

	// A counter to track how many items to wait for before
	// the ready event fires. See #6781
	readyWait: 1,

	// Handle when the DOM is ready
	ready: function( wait ) {

		// Abort if there are pending holds or we're already ready
		if ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {
			return;
		}

		// Remember that the DOM is ready
		jQuery.isReady = true;

		// If a normal DOM Ready event fired, decrement, and wait if need be
		if ( wait !== true && --jQuery.readyWait > 0 ) {
			return;
		}

		// If there are functions bound, to execute
		readyList.resolveWith( document, [ jQuery ] );
	}
} );

jQuery.ready.then = readyList.then;

// The ready event handler and self cleanup method
function completed() {
	document.removeEventListener( "DOMContentLoaded", completed );
	window.removeEventListener( "load", completed );
	jQuery.ready();
}

// Catch cases where $(document).ready() is called
// after the browser event has already occurred.
// Support: IE <=9 - 10 only
// Older IE sometimes signals "interactive" too soon
if ( document.readyState === "complete" ||
	( document.readyState !== "loading" && !document.documentElement.doScroll ) ) {

	// Handle it asynchronously to allow scripts the opportunity to delay ready
	window.setTimeout( jQuery.ready );

} else {

	// Use the handy event callback
	document.addEventListener( "DOMContentLoaded", completed );

	// A fallback to window.onload, that will always work
	window.addEventListener( "load", completed );
}




// Multifunctional method to get and set values of a collection
// The value/s can optionally be executed if it's a function
var access = function( elems, fn, key, value, chainable, emptyGet, raw ) {
	var i = 0,
		len = elems.length,
		bulk = key == null;

	// Sets many values
	if ( toType( key ) === "object" ) {
		chainable = true;
		for ( i in key ) {
			access( elems, fn, i, key[ i ], true, emptyGet, raw );
		}

	// Sets one value
	} else if ( value !== undefined ) {
		chainable = true;

		if ( !isFunction( value ) ) {
			raw = true;
		}

		if ( bulk ) {

			// Bulk operations run against the entire set
			if ( raw ) {
				fn.call( elems, value );
				fn = null;

			// ...except when executing function values
			} else {
				bulk = fn;
				fn = function( elem, _key, value ) {
					return bulk.call( jQuery( elem ), value );
				};
			}
		}

		if ( fn ) {
			for ( ; i < len; i++ ) {
				fn(
					elems[ i ], key, raw ?
						value :
						value.call( elems[ i ], i, fn( elems[ i ], key ) )
				);
			}
		}
	}

	if ( chainable ) {
		return elems;
	}

	// Gets
	if ( bulk ) {
		return fn.call( elems );
	}

	return len ? fn( elems[ 0 ], key ) : emptyGet;
};


// Matches dashed string for camelizing
var rmsPrefix = /^-ms-/,
	rdashAlpha = /-([a-z])/g;

// Used by camelCase as callback to replace()
function fcamelCase( _all, letter ) {
	return letter.toUpperCase();
}

// Convert dashed to camelCase; used by the css and data modules
// Support: IE <=9 - 11, Edge 12 - 15
// Microsoft forgot to hump their vendor prefix (#9572)
function camelCase( string ) {
	return string.replace( rmsPrefix, "ms-" ).replace( rdashAlpha, fcamelCase );
}
var acceptData = function( owner ) {

	// Accepts only:
	//  - Node
	//    - Node.ELEMENT_NODE
	//    - Node.DOCUMENT_NODE
	//  - Object
	//    - Any
	return owner.nodeType === 1 || owner.nodeType === 9 || !( +owner.nodeType );
};




function Data() {
	this.expando = jQuery.expando + Data.uid++;
}

Data.uid = 1;

Data.prototype = {

	cache: function( owner ) {

		// Check if the owner object already has a cache
		var value = owner[ this.expando ];

		// If not, create one
		if ( !value ) {
			value = {};

			// We can accept data for non-element nodes in modern browsers,
			// but we should not, see #8335.
			// Always return an empty object.
			if ( acceptData( owner ) ) {

				// If it is a node unlikely to be stringify-ed or looped over
				// use plain assignment
				if ( owner.nodeType ) {
					owner[ this.expando ] = value;

				// Otherwise secure it in a non-enumerable property
				// configurable must be true to allow the property to be
				// deleted when data is removed
				} else {
					Object.defineProperty( owner, this.expando, {
						value: value,
						configurable: true
					} );
				}
			}
		}

		return value;
	},
	set: function( owner, data, value ) {
		var prop,
			cache = this.cache( owner );

		// Handle: [ owner, key, value ] args
		// Always use camelCase key (gh-2257)
		if ( typeof data === "string" ) {
			cache[ camelCase( data ) ] = value;

		// Handle: [ owner, { properties } ] args
		} else {

			// Copy the properties one-by-one to the cache object
			for ( prop in data ) {
				cache[ camelCase( prop ) ] = data[ prop ];
			}
		}
		return cache;
	},
	get: function( owner, key ) {
		return key === undefined ?
			this.cache( owner ) :

			// Always use camelCase key (gh-2257)
			owner[ this.expando ] && owner[ this.expando ][ camelCase( key ) ];
	},
	access: function( owner, key, value ) {

		// In cases where either:
		//
		//   1. No key was specified
		//   2. A string key was specified, but no value provided
		//
		// Take the "read" path and allow the get method to determine
		// which value to return, respectively either:
		//
		//   1. The entire cache object
		//   2. The data stored at the key
		//
		if ( key === undefined ||
				( ( key && typeof key === "string" ) && value === undefined ) ) {

			return this.get( owner, key );
		}

		// When the key is not a string, or both a key and value
		// are specified, set or extend (existing objects) with either:
		//
		//   1. An object of properties
		//   2. A key and value
		//
		this.set( owner, key, value );

		// Since the "set" path can have two possible entry points
		// return the expected data based on which path was taken[*]
		return value !== undefined ? value : key;
	},
	remove: function( owner, key ) {
		var i,
			cache = owner[ this.expando ];

		if ( cache === undefined ) {
			return;
		}

		if ( key !== undefined ) {

			// Support array or space separated string of keys
			if ( Array.isArray( key ) ) {

				// If key is an array of keys...
				// We always set camelCase keys, so remove that.
				key = key.map( camelCase );
			} else {
				key = camelCase( key );

				// If a key with the spaces exists, use it.
				// Otherwise, create an array by matching non-whitespace
				key = key in cache ?
					[ key ] :
					( key.match( rnothtmlwhite ) || [] );
			}

			i = key.length;

			while ( i-- ) {
				delete cache[ key[ i ] ];
			}
		}

		// Remove the expando if there's no more data
		if ( key === undefined || jQuery.isEmptyObject( cache ) ) {

			// Support: Chrome <=35 - 45
			// Webkit & Blink performance suffers when deleting properties
			// from DOM nodes, so set to undefined instead
			// https://bugs.chromium.org/p/chromium/issues/detail?id=378607 (bug restricted)
			if ( owner.nodeType ) {
				owner[ this.expando ] = undefined;
			} else {
				delete owner[ this.expando ];
			}
		}
	},
	hasData: function( owner ) {
		var cache = owner[ this.expando ];
		return cache !== undefined && !jQuery.isEmptyObject( cache );
	}
};
var dataPriv = new Data();

var dataUser = new Data();



//	Implementation Summary
//
//	1. Enforce API surface and semantic compatibility with 1.9.x branch
//	2. Improve the module's maintainability by reducing the storage
//		paths to a single mechanism.
//	3. Use the same single mechanism to support "private" and "user" data.
//	4. _Never_ expose "private" data to user code (TODO: Drop _data, _removeData)
//	5. Avoid exposing implementation details on user objects (eg. expando properties)
//	6. Provide a clear path for implementation upgrade to WeakMap in 2014

var rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,
	rmultiDash = /[A-Z]/g;

function getData( data ) {
	if ( data === "true" ) {
		return true;
	}

	if ( data === "false" ) {
		return false;
	}

	if ( data === "null" ) {
		return null;
	}

	// Only convert to a number if it doesn't change the string
	if ( data === +data + "" ) {
		return +data;
	}

	if ( rbrace.test( data ) ) {
		return JSON.parse( data );
	}

	return data;
}

function dataAttr( elem, key, data ) {
	var name;

	// If nothing was found internally, try to fetch any
	// data from the HTML5 data-* attribute
	if ( data === undefined && elem.nodeType === 1 ) {
		name = "data-" + key.replace( rmultiDash, "-$&" ).toLowerCase();
		data = elem.getAttribute( name );

		if ( typeof data === "string" ) {
			try {
				data = getData( data );
			} catch ( e ) {}

			// Make sure we set the data so it isn't changed later
			dataUser.set( elem, key, data );
		} else {
			data = undefined;
		}
	}
	return data;
}

jQuery.extend( {
	hasData: function( elem ) {
		return dataUser.hasData( elem ) || dataPriv.hasData( elem );
	},

	data: function( elem, name, data ) {
		return dataUser.access( elem, name, data );
	},

	removeData: function( elem, name ) {
		dataUser.remove( elem, name );
	},

	// TODO: Now that all calls to _data and _removeData have been replaced
	// with direct calls to dataPriv methods, these can be deprecated.
	_data: function( elem, name, data ) {
		return dataPriv.access( elem, name, data );
	},

	_removeData: function( elem, name ) {
		dataPriv.remove( elem, name );
	}
} );

jQuery.fn.extend( {
	data: function( key, value ) {
		var i, name, data,
			elem = this[ 0 ],
			attrs = elem && elem.attributes;

		// Gets all values
		if ( key === undefined ) {
			if ( this.length ) {
				data = dataUser.get( elem );

				if ( elem.nodeType === 1 && !dataPriv.get( elem, "hasDataAttrs" ) ) {
					i = attrs.length;
					while ( i-- ) {

						// Support: IE 11 only
						// The attrs elements can be null (#14894)
						if ( attrs[ i ] ) {
							name = attrs[ i ].name;
							if ( name.indexOf( "data-" ) === 0 ) {
								name = camelCase( name.slice( 5 ) );
								dataAttr( elem, name, data[ name ] );
							}
						}
					}
					dataPriv.set( elem, "hasDataAttrs", true );
				}
			}

			return data;
		}

		// Sets multiple values
		if ( typeof key === "object" ) {
			return this.each( function() {
				dataUser.set( this, key );
			} );
		}

		return access( this, function( value ) {
			var data;

			// The calling jQuery object (element matches) is not empty
			// (and therefore has an element appears at this[ 0 ]) and the
			// `value` parameter was not undefined. An empty jQuery object
			// will result in `undefined` for elem = this[ 0 ] which will
			// throw an exception if an attempt to read a data cache is made.
			if ( elem && value === undefined ) {

				// Attempt to get data from the cache
				// The key will always be camelCased in Data
				data = dataUser.get( elem, key );
				if ( data !== undefined ) {
					return data;
				}

				// Attempt to "discover" the data in
				// HTML5 custom data-* attrs
				data = dataAttr( elem, key );
				if ( data !== undefined ) {
					return data;
				}

				// We tried really hard, but the data doesn't exist.
				return;
			}

			// Set the data...
			this.each( function() {

				// We always store the camelCased key
				dataUser.set( this, key, value );
			} );
		}, null, value, arguments.length > 1, null, true );
	},

	removeData: function( key ) {
		return this.each( function() {
			dataUser.remove( this, key );
		} );
	}
} );


jQuery.extend( {
	queue: function( elem, type, data ) {
		var queue;

		if ( elem ) {
			type = ( type || "fx" ) + "queue";
			queue = dataPriv.get( elem, type );

			// Speed up dequeue by getting out quickly if this is just a lookup
			if ( data ) {
				if ( !queue || Array.isArray( data ) ) {
					queue = dataPriv.access( elem, type, jQuery.makeArray( data ) );
				} else {
					queue.push( data );
				}
			}
			return queue || [];
		}
	},

	dequeue: function( elem, type ) {
		type = type || "fx";

		var queue = jQuery.queue( elem, type ),
			startLength = queue.length,
			fn = queue.shift(),
			hooks = jQuery._queueHooks( elem, type ),
			next = function() {
				jQuery.dequeue( elem, type );
			};

		// If the fx queue is dequeued, always remove the progress sentinel
		if ( fn === "inprogress" ) {
			fn = queue.shift();
			startLength--;
		}

		if ( fn ) {

			// Add a progress sentinel to prevent the fx queue from being
			// automatically dequeued
			if ( type === "fx" ) {
				queue.unshift( "inprogress" );
			}

			// Clear up the last queue stop function
			delete hooks.stop;
			fn.call( elem, next, hooks );
		}

		if ( !startLength && hooks ) {
			hooks.empty.fire();
		}
	},

	// Not public - generate a queueHooks object, or return the current one
	_queueHooks: function( elem, type ) {
		var key = type + "queueHooks";
		return dataPriv.get( elem, key ) || dataPriv.access( elem, key, {
			empty: jQuery.Callbacks( "once memory" ).add( function() {
				dataPriv.remove( elem, [ type + "queue", key ] );
			} )
		} );
	}
} );

jQuery.fn.extend( {
	queue: function( type, data ) {
		var setter = 2;

		if ( typeof type !== "string" ) {
			data = type;
			type = "fx";
			setter--;
		}

		if ( arguments.length < setter ) {
			return jQuery.queue( this[ 0 ], type );
		}

		return data === undefined ?
			this :
			this.each( function() {
				var queue = jQuery.queue( this, type, data );

				// Ensure a hooks for this queue
				jQuery._queueHooks( this, type );

				if ( type === "fx" && queue[ 0 ] !== "inprogress" ) {
					jQuery.dequeue( this, type );
				}
			} );
	},
	dequeue: function( type ) {
		return this.each( function() {
			jQuery.dequeue( this, type );
		} );
	},
	clearQueue: function( type ) {
		return this.queue( type || "fx", [] );
	},

	// Get a promise resolved when queues of a certain type
	// are emptied (fx is the type by default)
	promise: function( type, obj ) {
		var tmp,
			count = 1,
			defer = jQuery.Deferred(),
			elements = this,
			i = this.length,
			resolve = function() {
				if ( !( --count ) ) {
					defer.resolveWith( elements, [ elements ] );
				}
			};

		if ( typeof type !== "string" ) {
			obj = type;
			type = undefined;
		}
		type = type || "fx";

		while ( i-- ) {
			tmp = dataPriv.get( elements[ i ], type + "queueHooks" );
			if ( tmp && tmp.empty ) {
				count++;
				tmp.empty.add( resolve );
			}
		}
		resolve();
		return defer.promise( obj );
	}
} );
var pnum = ( /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/ ).source;

var rcssNum = new RegExp( "^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i" );


var cssExpand = [ "Top", "Right", "Bottom", "Left" ];

var documentElement = document.documentElement;



	var isAttached = function( elem ) {
			return jQuery.contains( elem.ownerDocument, elem );
		},
		composed = { composed: true };

	// Support: IE 9 - 11+, Edge 12 - 18+, iOS 10.0 - 10.2 only
	// Check attachment across shadow DOM boundaries when possible (gh-3504)
	// Support: iOS 10.0-10.2 only
	// Early iOS 10 versions support `attachShadow` but not `getRootNode`,
	// leading to errors. We need to check for `getRootNode`.
	if ( documentElement.getRootNode ) {
		isAttached = function( elem ) {
			return jQuery.contains( elem.ownerDocument, elem ) ||
				elem.getRootNode( composed ) === elem.ownerDocument;
		};
	}
var isHiddenWithinTree = function( elem, el ) {

		// isHiddenWithinTree might be called from jQuery#filter function;
		// in that case, element will be second argument
		elem = el || elem;

		// Inline style trumps all
		return elem.style.display === "none" ||
			elem.style.display === "" &&

			// Otherwise, check computed style
			// Support: Firefox <=43 - 45
			// Disconnected elements can have computed display: none, so first confirm that elem is
			// in the document.
			isAttached( elem ) &&

			jQuery.css( elem, "display" ) === "none";
	};



function adjustCSS( elem, prop, valueParts, tween ) {
	var adjusted, scale,
		maxIterations = 20,
		currentValue = tween ?
			function() {
				return tween.cur();
			} :
			function() {
				return jQuery.css( elem, prop, "" );
			},
		initial = currentValue(),
		unit = valueParts && valueParts[ 3 ] || ( jQuery.cssNumber[ prop ] ? "" : "px" ),

		// Starting value computation is required for potential unit mismatches
		initialInUnit = elem.nodeType &&
			( jQuery.cssNumber[ prop ] || unit !== "px" && +initial ) &&
			rcssNum.exec( jQuery.css( elem, prop ) );

	if ( initialInUnit && initialInUnit[ 3 ] !== unit ) {

		// Support: Firefox <=54
		// Halve the iteration target value to prevent interference from CSS upper bounds (gh-2144)
		initial = initial / 2;

		// Trust units reported by jQuery.css
		unit = unit || initialInUnit[ 3 ];

		// Iteratively approximate from a nonzero starting point
		initialInUnit = +initial || 1;

		while ( maxIterations-- ) {

			// Evaluate and update our best guess (doubling guesses that zero out).
			// Finish if the scale equals or crosses 1 (making the old*new product non-positive).
			jQuery.style( elem, prop, initialInUnit + unit );
			if ( ( 1 - scale ) * ( 1 - ( scale = currentValue() / initial || 0.5 ) ) <= 0 ) {
				maxIterations = 0;
			}
			initialInUnit = initialInUnit / scale;

		}

		initialInUnit = initialInUnit * 2;
		jQuery.style( elem, prop, initialInUnit + unit );

		// Make sure we update the tween properties later on
		valueParts = valueParts || [];
	}

	if ( valueParts ) {
		initialInUnit = +initialInUnit || +initial || 0;

		// Apply relative offset (+=/-=) if specified
		adjusted = valueParts[ 1 ] ?
			initialInUnit + ( valueParts[ 1 ] + 1 ) * valueParts[ 2 ] :
			+valueParts[ 2 ];
		if ( tween ) {
			tween.unit = unit;
			tween.start = initialInUnit;
			tween.end = adjusted;
		}
	}
	return adjusted;
}


var defaultDisplayMap = {};

function getDefaultDisplay( elem ) {
	var temp,
		doc = elem.ownerDocument,
		nodeName = elem.nodeName,
		display = defaultDisplayMap[ nodeName ];

	if ( display ) {
		return display;
	}

	temp = doc.body.appendChild( doc.createElement( nodeName ) );
	display = jQuery.css( temp, "display" );

	temp.parentNode.removeChild( temp );

	if ( display === "none" ) {
		display = "block";
	}
	defaultDisplayMap[ nodeName ] = display;

	return display;
}

function showHide( elements, show ) {
	var display, elem,
		values = [],
		index = 0,
		length = elements.length;

	// Determine new display value for elements that need to change
	for ( ; index < length; index++ ) {
		elem = elements[ index ];
		if ( !elem.style ) {
			continue;
		}

		display = elem.style.display;
		if ( show ) {

			// Since we force visibility upon cascade-hidden elements, an immediate (and slow)
			// check is required in this first loop unless we have a nonempty display value (either
			// inline or about-to-be-restored)
			if ( display === "none" ) {
				values[ index ] = dataPriv.get( elem, "display" ) || null;
				if ( !values[ index ] ) {
					elem.style.display = "";
				}
			}
			if ( elem.style.display === "" && isHiddenWithinTree( elem ) ) {
				values[ index ] = getDefaultDisplay( elem );
			}
		} else {
			if ( display !== "none" ) {
				values[ index ] = "none";

				// Remember what we're overwriting
				dataPriv.set( elem, "display", display );
			}
		}
	}

	// Set the display of the elements in a second loop to avoid constant reflow
	for ( index = 0; index < length; index++ ) {
		if ( values[ index ] != null ) {
			elements[ index ].style.display = values[ index ];
		}
	}

	return elements;
}

jQuery.fn.extend( {
	show: function() {
		return showHide( this, true );
	},
	hide: function() {
		return showHide( this );
	},
	toggle: function( state ) {
		if ( typeof state === "boolean" ) {
			return state ? this.show() : this.hide();
		}

		return this.each( function() {
			if ( isHiddenWithinTree( this ) ) {
				jQuery( this ).show();
			} else {
				jQuery( this ).hide();
			}
		} );
	}
} );
var rcheckableType = ( /^(?:checkbox|radio)$/i );

var rtagName = ( /<([a-z][^\/\0>\x20\t\r\n\f]*)/i );

var rscriptType = ( /^$|^module$|\/(?:java|ecma)script/i );



( function() {
	var fragment = document.createDocumentFragment(),
		div = fragment.appendChild( document.createElement( "div" ) ),
		input = document.createElement( "input" );

	// Support: Android 4.0 - 4.3 only
	// Check state lost if the name is set (#11217)
	// Support: Windows Web Apps (WWA)
	// `name` and `type` must use .setAttribute for WWA (#14901)
	input.setAttribute( "type", "radio" );
	input.setAttribute( "checked", "checked" );
	input.setAttribute( "name", "t" );

	div.appendChild( input );

	// Support: Android <=4.1 only
	// Older WebKit doesn't clone checked state correctly in fragments
	support.checkClone = div.cloneNode( true ).cloneNode( true ).lastChild.checked;

	// Support: IE <=11 only
	// Make sure textarea (and checkbox) defaultValue is properly cloned
	div.innerHTML = "<textarea>x</textarea>";
	support.noCloneChecked = !!div.cloneNode( true ).lastChild.defaultValue;

	// Support: IE <=9 only
	// IE <=9 replaces <option> tags with their contents when inserted outside of
	// the select element.
	div.innerHTML = "<option></option>";
	support.option = !!div.lastChild;
} )();


// We have to close these tags to support XHTML (#13200)
var wrapMap = {

	// XHTML parsers do not magically insert elements in the
	// same way that tag soup parsers do. So we cannot shorten
	// this by omitting <tbody> or other required elements.
	thead: [ 1, "<table>", "</table>" ],
	col: [ 2, "<table><colgroup>", "</colgroup></table>" ],
	tr: [ 2, "<table><tbody>", "</tbody></table>" ],
	td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],

	_default: [ 0, "", "" ]
};

wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
wrapMap.th = wrapMap.td;

// Support: IE <=9 only
if ( !support.option ) {
	wrapMap.optgroup = wrapMap.option = [ 1, "<select multiple='multiple'>", "</select>" ];
}


function getAll( context, tag ) {

	// Support: IE <=9 - 11 only
	// Use typeof to avoid zero-argument method invocation on host objects (#15151)
	var ret;

	if ( typeof context.getElementsByTagName !== "undefined" ) {
		ret = context.getElementsByTagName( tag || "*" );

	} else if ( typeof context.querySelectorAll !== "undefined" ) {
		ret = context.querySelectorAll( tag || "*" );

	} else {
		ret = [];
	}

	if ( tag === undefined || tag && nodeName( context, tag ) ) {
		return jQuery.merge( [ context ], ret );
	}

	return ret;
}


// Mark scripts as having already been evaluated
function setGlobalEval( elems, refElements ) {
	var i = 0,
		l = elems.length;

	for ( ; i < l; i++ ) {
		dataPriv.set(
			elems[ i ],
			"globalEval",
			!refElements || dataPriv.get( refElements[ i ], "globalEval" )
		);
	}
}


var rhtml = /<|&#?\w+;/;

function buildFragment( elems, context, scripts, selection, ignored ) {
	var elem, tmp, tag, wrap, attached, j,
		fragment = context.createDocumentFragment(),
		nodes = [],
		i = 0,
		l = elems.length;

	for ( ; i < l; i++ ) {
		elem = elems[ i ];

		if ( elem || elem === 0 ) {

			// Add nodes directly
			if ( toType( elem ) === "object" ) {

				// Support: Android <=4.0 only, PhantomJS 1 only
				// push.apply(_, arraylike) throws on ancient WebKit
				jQuery.merge( nodes, elem.nodeType ? [ elem ] : elem );

			// Convert non-html into a text node
			} else if ( !rhtml.test( elem ) ) {
				nodes.push( context.createTextNode( elem ) );

			// Convert html into DOM nodes
			} else {
				tmp = tmp || fragment.appendChild( context.createElement( "div" ) );

				// Deserialize a standard representation
				tag = ( rtagName.exec( elem ) || [ "", "" ] )[ 1 ].toLowerCase();
				wrap = wrapMap[ tag ] || wrapMap._default;
				tmp.innerHTML = wrap[ 1 ] + jQuery.htmlPrefilter( elem ) + wrap[ 2 ];

				// Descend through wrappers to the right content
				j = wrap[ 0 ];
				while ( j-- ) {
					tmp = tmp.lastChild;
				}

				// Support: Android <=4.0 only, PhantomJS 1 only
				// push.apply(_, arraylike) throws on ancient WebKit
				jQuery.merge( nodes, tmp.childNodes );

				// Remember the top-level container
				tmp = fragment.firstChild;

				// Ensure the created nodes are orphaned (#12392)
				tmp.textContent = "";
			}
		}
	}

	// Remove wrapper from fragment
	fragment.textContent = "";

	i = 0;
	while ( ( elem = nodes[ i++ ] ) ) {

		// Skip elements already in the context collection (trac-4087)
		if ( selection && jQuery.inArray( elem, selection ) > -1 ) {
			if ( ignored ) {
				ignored.push( elem );
			}
			continue;
		}

		attached = isAttached( elem );

		// Append to fragment
		tmp = getAll( fragment.appendChild( elem ), "script" );

		// Preserve script evaluation history
		if ( attached ) {
			setGlobalEval( tmp );
		}

		// Capture executables
		if ( scripts ) {
			j = 0;
			while ( ( elem = tmp[ j++ ] ) ) {
				if ( rscriptType.test( elem.type || "" ) ) {
					scripts.push( elem );
				}
			}
		}
	}

	return fragment;
}


var rtypenamespace = /^([^.]*)(?:\.(.+)|)/;

function returnTrue() {
	return true;
}

function returnFalse() {
	return false;
}

// Support: IE <=9 - 11+
// focus() and blur() are asynchronous, except when they are no-op.
// So expect focus to be synchronous when the element is already active,
// and blur to be synchronous when the element is not already active.
// (focus and blur are always synchronous in other supported browsers,
// this just defines when we can count on it).
function expectSync( elem, type ) {
	return ( elem === safeActiveElement() ) === ( type === "focus" );
}

// Support: IE <=9 only
// Accessing document.activeElement can throw unexpectedly
// https://bugs.jquery.com/ticket/13393
function safeActiveElement() {
	try {
		return document.activeElement;
	} catch ( err ) { }
}

function on( elem, types, selector, data, fn, one ) {
	var origFn, type;

	// Types can be a map of types/handlers
	if ( typeof types === "object" ) {

		// ( types-Object, selector, data )
		if ( typeof selector !== "string" ) {

			// ( types-Object, data )
			data = data || selector;
			selector = undefined;
		}
		for ( type in types ) {
			on( elem, type, selector, data, types[ type ], one );
		}
		return elem;
	}

	if ( data == null && fn == null ) {

		// ( types, fn )
		fn = selector;
		data = selector = undefined;
	} else if ( fn == null ) {
		if ( typeof selector === "string" ) {

			// ( types, selector, fn )
			fn = data;
			data = undefined;
		} else {

			// ( types, data, fn )
			fn = data;
			data = selector;
			selector = undefined;
		}
	}
	if ( fn === false ) {
		fn = returnFalse;
	} else if ( !fn ) {
		return elem;
	}

	if ( one === 1 ) {
		origFn = fn;
		fn = function( event ) {

			// Can use an empty set, since event contains the info
			jQuery().off( event );
			return origFn.apply( this, arguments );
		};

		// Use same guid so caller can remove using origFn
		fn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );
	}
	return elem.each( function() {
		jQuery.event.add( this, types, fn, data, selector );
	} );
}

/*
 * Helper functions for managing events -- not part of the public interface.
 * Props to Dean Edwards' addEvent library for many of the ideas.
 */
jQuery.event = {

	global: {},

	add: function( elem, types, handler, data, selector ) {

		var handleObjIn, eventHandle, tmp,
			events, t, handleObj,
			special, handlers, type, namespaces, origType,
			elemData = dataPriv.get( elem );

		// Only attach events to objects that accept data
		if ( !acceptData( elem ) ) {
			return;
		}

		// Caller can pass in an object of custom data in lieu of the handler
		if ( handler.handler ) {
			handleObjIn = handler;
			handler = handleObjIn.handler;
			selector = handleObjIn.selector;
		}

		// Ensure that invalid selectors throw exceptions at attach time
		// Evaluate against documentElement in case elem is a non-element node (e.g., document)
		if ( selector ) {
			jQuery.find.matchesSelector( documentElement, selector );
		}

		// Make sure that the handler has a unique ID, used to find/remove it later
		if ( !handler.guid ) {
			handler.guid = jQuery.guid++;
		}

		// Init the element's event structure and main handler, if this is the first
		if ( !( events = elemData.events ) ) {
			events = elemData.events = Object.create( null );
		}
		if ( !( eventHandle = elemData.handle ) ) {
			eventHandle = elemData.handle = function( e ) {

				// Discard the second event of a jQuery.event.trigger() and
				// when an event is called after a page has unloaded
				return typeof jQuery !== "undefined" && jQuery.event.triggered !== e.type ?
					jQuery.event.dispatch.apply( elem, arguments ) : undefined;
			};
		}

		// Handle multiple events separated by a space
		types = ( types || "" ).match( rnothtmlwhite ) || [ "" ];
		t = types.length;
		while ( t-- ) {
			tmp = rtypenamespace.exec( types[ t ] ) || [];
			type = origType = tmp[ 1 ];
			namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();

			// There *must* be a type, no attaching namespace-only handlers
			if ( !type ) {
				continue;
			}

			// If event changes its type, use the special event handlers for the changed type
			special = jQuery.event.special[ type ] || {};

			// If selector defined, determine special event api type, otherwise given type
			type = ( selector ? special.delegateType : special.bindType ) || type;

			// Update special based on newly reset type
			special = jQuery.event.special[ type ] || {};

			// handleObj is passed to all event handlers
			handleObj = jQuery.extend( {
				type: type,
				origType: origType,
				data: data,
				handler: handler,
				guid: handler.guid,
				selector: selector,
				needsContext: selector && jQuery.expr.match.needsContext.test( selector ),
				namespace: namespaces.join( "." )
			}, handleObjIn );

			// Init the event handler queue if we're the first
			if ( !( handlers = events[ type ] ) ) {
				handlers = events[ type ] = [];
				handlers.delegateCount = 0;

				// Only use addEventListener if the special events handler returns false
				if ( !special.setup ||
					special.setup.call( elem, data, namespaces, eventHandle ) === false ) {

					if ( elem.addEventListener ) {
						elem.addEventListener( type, eventHandle );
					}
				}
			}

			if ( special.add ) {
				special.add.call( elem, handleObj );

				if ( !handleObj.handler.guid ) {
					handleObj.handler.guid = handler.guid;
				}
			}

			// Add to the element's handler list, delegates in front
			if ( selector ) {
				handlers.splice( handlers.delegateCount++, 0, handleObj );
			} else {
				handlers.push( handleObj );
			}

			// Keep track of which events have ever been used, for event optimization
			jQuery.event.global[ type ] = true;
		}

	},

	// Detach an event or set of events from an element
	remove: function( elem, types, handler, selector, mappedTypes ) {

		var j, origCount, tmp,
			events, t, handleObj,
			special, handlers, type, namespaces, origType,
			elemData = dataPriv.hasData( elem ) && dataPriv.get( elem );

		if ( !elemData || !( events = elemData.events ) ) {
			return;
		}

		// Once for each type.namespace in types; type may be omitted
		types = ( types || "" ).match( rnothtmlwhite ) || [ "" ];
		t = types.length;
		while ( t-- ) {
			tmp = rtypenamespace.exec( types[ t ] ) || [];
			type = origType = tmp[ 1 ];
			namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();

			// Unbind all events (on this namespace, if provided) for the element
			if ( !type ) {
				for ( type in events ) {
					jQuery.event.remove( elem, type + types[ t ], handler, selector, true );
				}
				continue;
			}

			special = jQuery.event.special[ type ] || {};
			type = ( selector ? special.delegateType : special.bindType ) || type;
			handlers = events[ type ] || [];
			tmp = tmp[ 2 ] &&
				new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" );

			// Remove matching events
			origCount = j = handlers.length;
			while ( j-- ) {
				handleObj = handlers[ j ];

				if ( ( mappedTypes || origType === handleObj.origType ) &&
					( !handler || handler.guid === handleObj.guid ) &&
					( !tmp || tmp.test( handleObj.namespace ) ) &&
					( !selector || selector === handleObj.selector ||
						selector === "**" && handleObj.selector ) ) {
					handlers.splice( j, 1 );

					if ( handleObj.selector ) {
						handlers.delegateCount--;
					}
					if ( special.remove ) {
						special.remove.call( elem, handleObj );
					}
				}
			}

			// Remove generic event handler if we removed something and no more handlers exist
			// (avoids potential for endless recursion during removal of special event handlers)
			if ( origCount && !handlers.length ) {
				if ( !special.teardown ||
					special.teardown.call( elem, namespaces, elemData.handle ) === false ) {

					jQuery.removeEvent( elem, type, elemData.handle );
				}

				delete events[ type ];
			}
		}

		// Remove data and the expando if it's no longer used
		if ( jQuery.isEmptyObject( events ) ) {
			dataPriv.remove( elem, "handle events" );
		}
	},

	dispatch: function( nativeEvent ) {

		var i, j, ret, matched, handleObj, handlerQueue,
			args = new Array( arguments.length ),

			// Make a writable jQuery.Event from the native event object
			event = jQuery.event.fix( nativeEvent ),

			handlers = (
				dataPriv.get( this, "events" ) || Object.create( null )
			)[ event.type ] || [],
			special = jQuery.event.special[ event.type ] || {};

		// Use the fix-ed jQuery.Event rather than the (read-only) native event
		args[ 0 ] = event;

		for ( i = 1; i < arguments.length; i++ ) {
			args[ i ] = arguments[ i ];
		}

		event.delegateTarget = this;

		// Call the preDispatch hook for the mapped type, and let it bail if desired
		if ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {
			return;
		}

		// Determine handlers
		handlerQueue = jQuery.event.handlers.call( this, event, handlers );

		// Run delegates first; they may want to stop propagation beneath us
		i = 0;
		while ( ( matched = handlerQueue[ i++ ] ) && !event.isPropagationStopped() ) {
			event.currentTarget = matched.elem;

			j = 0;
			while ( ( handleObj = matched.handlers[ j++ ] ) &&
				!event.isImmediatePropagationStopped() ) {

				// If the event is namespaced, then each handler is only invoked if it is
				// specially universal or its namespaces are a superset of the event's.
				if ( !event.rnamespace || handleObj.namespace === false ||
					event.rnamespace.test( handleObj.namespace ) ) {

					event.handleObj = handleObj;
					event.data = handleObj.data;

					ret = ( ( jQuery.event.special[ handleObj.origType ] || {} ).handle ||
						handleObj.handler ).apply( matched.elem, args );

					if ( ret !== undefined ) {
						if ( ( event.result = ret ) === false ) {
							event.preventDefault();
							event.stopPropagation();
						}
					}
				}
			}
		}

		// Call the postDispatch hook for the mapped type
		if ( special.postDispatch ) {
			special.postDispatch.call( this, event );
		}

		return event.result;
	},

	handlers: function( event, handlers ) {
		var i, handleObj, sel, matchedHandlers, matchedSelectors,
			handlerQueue = [],
			delegateCount = handlers.delegateCount,
			cur = event.target;

		// Find delegate handlers
		if ( delegateCount &&

			// Support: IE <=9
			// Black-hole SVG <use> instance trees (trac-13180)
			cur.nodeType &&

			// Support: Firefox <=42
			// Suppress spec-violating clicks indicating a non-primary pointer button (trac-3861)
			// https://www.w3.org/TR/DOM-Level-3-Events/#event-type-click
			// Support: IE 11 only
			// ...but not arrow key "clicks" of radio inputs, which can have `button` -1 (gh-2343)
			!( event.type === "click" && event.button >= 1 ) ) {

			for ( ; cur !== this; cur = cur.parentNode || this ) {

				// Don't check non-elements (#13208)
				// Don't process clicks on disabled elements (#6911, #8165, #11382, #11764)
				if ( cur.nodeType === 1 && !( event.type === "click" && cur.disabled === true ) ) {
					matchedHandlers = [];
					matchedSelectors = {};
					for ( i = 0; i < delegateCount; i++ ) {
						handleObj = handlers[ i ];

						// Don't conflict with Object.prototype properties (#13203)
						sel = handleObj.selector + " ";

						if ( matchedSelectors[ sel ] === undefined ) {
							matchedSelectors[ sel ] = handleObj.needsContext ?
								jQuery( sel, this ).index( cur ) > -1 :
								jQuery.find( sel, this, null, [ cur ] ).length;
						}
						if ( matchedSelectors[ sel ] ) {
							matchedHandlers.push( handleObj );
						}
					}
					if ( matchedHandlers.length ) {
						handlerQueue.push( { elem: cur, handlers: matchedHandlers } );
					}
				}
			}
		}

		// Add the remaining (directly-bound) handlers
		cur = this;
		if ( delegateCount < handlers.length ) {
			handlerQueue.push( { elem: cur, handlers: handlers.slice( delegateCount ) } );
		}

		return handlerQueue;
	},

	addProp: function( name, hook ) {
		Object.defineProperty( jQuery.Event.prototype, name, {
			enumerable: true,
			configurable: true,

			get: isFunction( hook ) ?
				function() {
					if ( this.originalEvent ) {
						return hook( this.originalEvent );
					}
				} :
				function() {
					if ( this.originalEvent ) {
						return this.originalEvent[ name ];
					}
				},

			set: function( value ) {
				Object.defineProperty( this, name, {
					enumerable: true,
					configurable: true,
					writable: true,
					value: value
				} );
			}
		} );
	},

	fix: function( originalEvent ) {
		return originalEvent[ jQuery.expando ] ?
			originalEvent :
			new jQuery.Event( originalEvent );
	},

	special: {
		load: {

			// Prevent triggered image.load events from bubbling to window.load
			noBubble: true
		},
		click: {

			// Utilize native event to ensure correct state for checkable inputs
			setup: function( data ) {

				// For mutual compressibility with _default, replace `this` access with a local var.
				// `|| data` is dead code meant only to preserve the variable through minification.
				var el = this || data;

				// Claim the first handler
				if ( rcheckableType.test( el.type ) &&
					el.click && nodeName( el, "input" ) ) {

					// dataPriv.set( el, "click", ... )
					leverageNative( el, "click", returnTrue );
				}

				// Return false to allow normal processing in the caller
				return false;
			},
			trigger: function( data ) {

				// For mutual compressibility with _default, replace `this` access with a local var.
				// `|| data` is dead code meant only to preserve the variable through minification.
				var el = this || data;

				// Force setup before triggering a click
				if ( rcheckableType.test( el.type ) &&
					el.click && nodeName( el, "input" ) ) {

					leverageNative( el, "click" );
				}

				// Return non-false to allow normal event-path propagation
				return true;
			},

			// For cross-browser consistency, suppress native .click() on links
			// Also prevent it if we're currently inside a leveraged native-event stack
			_default: function( event ) {
				var target = event.target;
				return rcheckableType.test( target.type ) &&
					target.click && nodeName( target, "input" ) &&
					dataPriv.get( target, "click" ) ||
					nodeName( target, "a" );
			}
		},

		beforeunload: {
			postDispatch: function( event ) {

				// Support: Firefox 20+
				// Firefox doesn't alert if the returnValue field is not set.
				if ( event.result !== undefined && event.originalEvent ) {
					event.originalEvent.returnValue = event.result;
				}
			}
		}
	}
};

// Ensure the presence of an event listener that handles manually-triggered
// synthetic events by interrupting progress until reinvoked in response to
// *native* events that it fires directly, ensuring that state changes have
// already occurred before other listeners are invoked.
function leverageNative( el, type, expectSync ) {

	// Missing expectSync indicates a trigger call, which must force setup through jQuery.event.add
	if ( !expectSync ) {
		if ( dataPriv.get( el, type ) === undefined ) {
			jQuery.event.add( el, type, returnTrue );
		}
		return;
	}

	// Register the controller as a special universal handler for all event namespaces
	dataPriv.set( el, type, false );
	jQuery.event.add( el, type, {
		namespace: false,
		handler: function( event ) {
			var notAsync, result,
				saved = dataPriv.get( this, type );

			if ( ( event.isTrigger & 1 ) && this[ type ] ) {

				// Interrupt processing of the outer synthetic .trigger()ed event
				// Saved data should be false in such cases, but might be a leftover capture object
				// from an async native handler (gh-4350)
				if ( !saved.length ) {

					// Store arguments for use when handling the inner native event
					// There will always be at least one argument (an event object), so this array
					// will not be confused with a leftover capture object.
					saved = slice.call( arguments );
					dataPriv.set( this, type, saved );

					// Trigger the native event and capture its result
					// Support: IE <=9 - 11+
					// focus() and blur() are asynchronous
					notAsync = expectSync( this, type );
					this[ type ]();
					result = dataPriv.get( this, type );
					if ( saved !== result || notAsync ) {
						dataPriv.set( this, type, false );
					} else {
						result = {};
					}
					if ( saved !== result ) {

						// Cancel the outer synthetic event
						event.stopImmediatePropagation();
						event.preventDefault();

						// Support: Chrome 86+
						// In Chrome, if an element having a focusout handler is blurred by
						// clicking outside of it, it invokes the handler synchronously. If
						// that handler calls `.remove()` on the element, the data is cleared,
						// leaving `result` undefined. We need to guard against this.
						return result && result.value;
					}

				// If this is an inner synthetic event for an event with a bubbling surrogate
				// (focus or blur), assume that the surrogate already propagated from triggering the
				// native event and prevent that from happening again here.
				// This technically gets the ordering wrong w.r.t. to `.trigger()` (in which the
				// bubbling surrogate propagates *after* the non-bubbling base), but that seems
				// less bad than duplication.
				} else if ( ( jQuery.event.special[ type ] || {} ).delegateType ) {
					event.stopPropagation();
				}

			// If this is a native event triggered above, everything is now in order
			// Fire an inner synthetic event with the original arguments
			} else if ( saved.length ) {

				// ...and capture the result
				dataPriv.set( this, type, {
					value: jQuery.event.trigger(

						// Support: IE <=9 - 11+
						// Extend with the prototype to reset the above stopImmediatePropagation()
						jQuery.extend( saved[ 0 ], jQuery.Event.prototype ),
						saved.slice( 1 ),
						this
					)
				} );

				// Abort handling of the native event
				event.stopImmediatePropagation();
			}
		}
	} );
}

jQuery.removeEvent = function( elem, type, handle ) {

	// This "if" is needed for plain objects
	if ( elem.removeEventListener ) {
		elem.removeEventListener( type, handle );
	}
};

jQuery.Event = function( src, props ) {

	// Allow instantiation without the 'new' keyword
	if ( !( this instanceof jQuery.Event ) ) {
		return new jQuery.Event( src, props );
	}

	// Event object
	if ( src && src.type ) {
		this.originalEvent = src;
		this.type = src.type;

		// Events bubbling up the document may have been marked as prevented
		// by a handler lower down the tree; reflect the correct value.
		this.isDefaultPrevented = src.defaultPrevented ||
				src.defaultPrevented === undefined &&

				// Support: Android <=2.3 only
				src.returnValue === false ?
			returnTrue :
			returnFalse;

		// Create target properties
		// Support: Safari <=6 - 7 only
		// Target should not be a text node (#504, #13143)
		this.target = ( src.target && src.target.nodeType === 3 ) ?
			src.target.parentNode :
			src.target;

		this.currentTarget = src.currentTarget;
		this.relatedTarget = src.relatedTarget;

	// Event type
	} else {
		this.type = src;
	}

	// Put explicitly provided properties onto the event object
	if ( props ) {
		jQuery.extend( this, props );
	}

	// Create a timestamp if incoming event doesn't have one
	this.timeStamp = src && src.timeStamp || Date.now();

	// Mark it as fixed
	this[ jQuery.expando ] = true;
};

// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
// https://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html
jQuery.Event.prototype = {
	constructor: jQuery.Event,
	isDefaultPrevented: returnFalse,
	isPropagationStopped: returnFalse,
	isImmediatePropagationStopped: returnFalse,
	isSimulated: false,

	preventDefault: function() {
		var e = this.originalEvent;

		this.isDefaultPrevented = returnTrue;

		if ( e && !this.isSimulated ) {
			e.preventDefault();
		}
	},
	stopPropagation: function() {
		var e = this.originalEvent;

		this.isPropagationStopped = returnTrue;

		if ( e && !this.isSimulated ) {
			e.stopPropagation();
		}
	},
	stopImmediatePropagation: function() {
		var e = this.originalEvent;

		this.isImmediatePropagationStopped = returnTrue;

		if ( e && !this.isSimulated ) {
			e.stopImmediatePropagation();
		}

		this.stopPropagation();
	}
};

// Includes all common event props including KeyEvent and MouseEvent specific props
jQuery.each( {
	altKey: true,
	bubbles: true,
	cancelable: true,
	changedTouches: true,
	ctrlKey: true,
	detail: true,
	eventPhase: true,
	metaKey: true,
	pageX: true,
	pageY: true,
	shiftKey: true,
	view: true,
	"char": true,
	code: true,
	charCode: true,
	key: true,
	keyCode: true,
	button: true,
	buttons: true,
	clientX: true,
	clientY: true,
	offsetX: true,
	offsetY: true,
	pointerId: true,
	pointerType: true,
	screenX: true,
	screenY: true,
	targetTouches: true,
	toElement: true,
	touches: true,
	which: true
}, jQuery.event.addProp );

jQuery.each( { focus: "focusin", blur: "focusout" }, function( type, delegateType ) {
	jQuery.event.special[ type ] = {

		// Utilize native event if possible so blur/focus sequence is correct
		setup: function() {

			// Claim the first handler
			// dataPriv.set( this, "focus", ... )
			// dataPriv.set( this, "blur", ... )
			leverageNative( this, type, expectSync );

			// Return false to allow normal processing in the caller
			return false;
		},
		trigger: function() {

			// Force setup before trigger
			leverageNative( this, type );

			// Return non-false to allow normal event-path propagation
			return true;
		},

		// Suppress native focus or blur as it's already being fired
		// in leverageNative.
		_default: function() {
			return true;
		},

		delegateType: delegateType
	};
} );

// Create mouseenter/leave events using mouseover/out and event-time checks
// so that event delegation works in jQuery.
// Do the same for pointerenter/pointerleave and pointerover/pointerout
//
// Support: Safari 7 only
// Safari sends mouseenter too often; see:
// https://bugs.chromium.org/p/chromium/issues/detail?id=470258
// for the description of the bug (it existed in older Chrome versions as well).
jQuery.each( {
	mouseenter: "mouseover",
	mouseleave: "mouseout",
	pointerenter: "pointerover",
	pointerleave: "pointerout"
}, function( orig, fix ) {
	jQuery.event.special[ orig ] = {
		delegateType: fix,
		bindType: fix,

		handle: function( event ) {
			var ret,
				target = this,
				related = event.relatedTarget,
				handleObj = event.handleObj;

			// For mouseenter/leave call the handler if related is outside the target.
			// NB: No relatedTarget if the mouse left/entered the browser window
			if ( !related || ( related !== target && !jQuery.contains( target, related ) ) ) {
				event.type = handleObj.origType;
				ret = handleObj.handler.apply( this, arguments );
				event.type = fix;
			}
			return ret;
		}
	};
} );

jQuery.fn.extend( {

	on: function( types, selector, data, fn ) {
		return on( this, types, selector, data, fn );
	},
	one: function( types, selector, data, fn ) {
		return on( this, types, selector, data, fn, 1 );
	},
	off: function( types, selector, fn ) {
		var handleObj, type;
		if ( types && types.preventDefault && types.handleObj ) {

			// ( event )  dispatched jQuery.Event
			handleObj = types.handleObj;
			jQuery( types.delegateTarget ).off(
				handleObj.namespace ?
					handleObj.origType + "." + handleObj.namespace :
					handleObj.origType,
				handleObj.selector,
				handleObj.handler
			);
			return this;
		}
		if ( typeof types === "object" ) {

			// ( types-object [, selector] )
			for ( type in types ) {
				this.off( type, selector, types[ type ] );
			}
			return this;
		}
		if ( selector === false || typeof selector === "function" ) {

			// ( types [, fn] )
			fn = selector;
			selector = undefined;
		}
		if ( fn === false ) {
			fn = returnFalse;
		}
		return this.each( function() {
			jQuery.event.remove( this, types, fn, selector );
		} );
	}
} );


var

	// Support: IE <=10 - 11, Edge 12 - 13 only
	// In IE/Edge using regex groups here causes severe slowdowns.
	// See https://connect.microsoft.com/IE/feedback/details/1736512/
	rnoInnerhtml = /<script|<style|<link/i,

	// checked="checked" or checked
	rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,
	rcleanScript = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;

// Prefer a tbody over its parent table for containing new rows
function manipulationTarget( elem, content ) {
	if ( nodeName( elem, "table" ) &&
		nodeName( content.nodeType !== 11 ? content : content.firstChild, "tr" ) ) {

		return jQuery( elem ).children( "tbody" )[ 0 ] || elem;
	}

	return elem;
}

// Replace/restore the type attribute of script elements for safe DOM manipulation
function disableScript( elem ) {
	elem.type = ( elem.getAttribute( "type" ) !== null ) + "/" + elem.type;
	return elem;
}
function restoreScript( elem ) {
	if ( ( elem.type || "" ).slice( 0, 5 ) === "true/" ) {
		elem.type = elem.type.slice( 5 );
	} else {
		elem.removeAttribute( "type" );
	}

	return elem;
}

function cloneCopyEvent( src, dest ) {
	var i, l, type, pdataOld, udataOld, udataCur, events;

	if ( dest.nodeType !== 1 ) {
		return;
	}

	// 1. Copy private data: events, handlers, etc.
	if ( dataPriv.hasData( src ) ) {
		pdataOld = dataPriv.get( src );
		events = pdataOld.events;

		if ( events ) {
			dataPriv.remove( dest, "handle events" );

			for ( type in events ) {
				for ( i = 0, l = events[ type ].length; i < l; i++ ) {
					jQuery.event.add( dest, type, events[ type ][ i ] );
				}
			}
		}
	}

	// 2. Copy user data
	if ( dataUser.hasData( src ) ) {
		udataOld = dataUser.access( src );
		udataCur = jQuery.extend( {}, udataOld );

		dataUser.set( dest, udataCur );
	}
}

// Fix IE bugs, see support tests
function fixInput( src, dest ) {
	var nodeName = dest.nodeName.toLowerCase();

	// Fails to persist the checked state of a cloned checkbox or radio button.
	if ( nodeName === "input" && rcheckableType.test( src.type ) ) {
		dest.checked = src.checked;

	// Fails to return the selected option to the default selected state when cloning options
	} else if ( nodeName === "input" || nodeName === "textarea" ) {
		dest.defaultValue = src.defaultValue;
	}
}

function domManip( collection, args, callback, ignored ) {

	// Flatten any nested arrays
	args = flat( args );

	var fragment, first, scripts, hasScripts, node, doc,
		i = 0,
		l = collection.length,
		iNoClone = l - 1,
		value = args[ 0 ],
		valueIsFunction = isFunction( value );

	// We can't cloneNode fragments that contain checked, in WebKit
	if ( valueIsFunction ||
			( l > 1 && typeof value === "string" &&
				!support.checkClone && rchecked.test( value ) ) ) {
		return collection.each( function( index ) {
			var self = collection.eq( index );
			if ( valueIsFunction ) {
				args[ 0 ] = value.call( this, index, self.html() );
			}
			domManip( self, args, callback, ignored );
		} );
	}

	if ( l ) {
		fragment = buildFragment( args, collection[ 0 ].ownerDocument, false, collection, ignored );
		first = fragment.firstChild;

		if ( fragment.childNodes.length === 1 ) {
			fragment = first;
		}

		// Require either new content or an interest in ignored elements to invoke the callback
		if ( first || ignored ) {
			scripts = jQuery.map( getAll( fragment, "script" ), disableScript );
			hasScripts = scripts.length;

			// Use the original fragment for the last item
			// instead of the first because it can end up
			// being emptied incorrectly in certain situations (#8070).
			for ( ; i < l; i++ ) {
				node = fragment;

				if ( i !== iNoClone ) {
					node = jQuery.clone( node, true, true );

					// Keep references to cloned scripts for later restoration
					if ( hasScripts ) {

						// Support: Android <=4.0 only, PhantomJS 1 only
						// push.apply(_, arraylike) throws on ancient WebKit
						jQuery.merge( scripts, getAll( node, "script" ) );
					}
				}

				callback.call( collection[ i ], node, i );
			}

			if ( hasScripts ) {
				doc = scripts[ scripts.length - 1 ].ownerDocument;

				// Reenable scripts
				jQuery.map( scripts, restoreScript );

				// Evaluate executable scripts on first document insertion
				for ( i = 0; i < hasScripts; i++ ) {
					node = scripts[ i ];
					if ( rscriptType.test( node.type || "" ) &&
						!dataPriv.access( node, "globalEval" ) &&
						jQuery.contains( doc, node ) ) {

						if ( node.src && ( node.type || "" ).toLowerCase()  !== "module" ) {

							// Optional AJAX dependency, but won't run scripts if not present
							if ( jQuery._evalUrl && !node.noModule ) {
								jQuery._evalUrl( node.src, {
									nonce: node.nonce || node.getAttribute( "nonce" )
								}, doc );
							}
						} else {
							DOMEval( node.textContent.replace( rcleanScript, "" ), node, doc );
						}
					}
				}
			}
		}
	}

	return collection;
}

function remove( elem, selector, keepData ) {
	var node,
		nodes = selector ? jQuery.filter( selector, elem ) : elem,
		i = 0;

	for ( ; ( node = nodes[ i ] ) != null; i++ ) {
		if ( !keepData && node.nodeType === 1 ) {
			jQuery.cleanData( getAll( node ) );
		}

		if ( node.parentNode ) {
			if ( keepData && isAttached( node ) ) {
				setGlobalEval( getAll( node, "script" ) );
			}
			node.parentNode.removeChild( node );
		}
	}

	return elem;
}

jQuery.extend( {
	htmlPrefilter: function( html ) {
		return html;
	},

	clone: function( elem, dataAndEvents, deepDataAndEvents ) {
		var i, l, srcElements, destElements,
			clone = elem.cloneNode( true ),
			inPage = isAttached( elem );

		// Fix IE cloning issues
		if ( !support.noCloneChecked && ( elem.nodeType === 1 || elem.nodeType === 11 ) &&
				!jQuery.isXMLDoc( elem ) ) {

			// We eschew Sizzle here for performance reasons: https://jsperf.com/getall-vs-sizzle/2
			destElements = getAll( clone );
			srcElements = getAll( elem );

			for ( i = 0, l = srcElements.length; i < l; i++ ) {
				fixInput( srcElements[ i ], destElements[ i ] );
			}
		}

		// Copy the events from the original to the clone
		if ( dataAndEvents ) {
			if ( deepDataAndEvents ) {
				srcElements = srcElements || getAll( elem );
				destElements = destElements || getAll( clone );

				for ( i = 0, l = srcElements.length; i < l; i++ ) {
					cloneCopyEvent( srcElements[ i ], destElements[ i ] );
				}
			} else {
				cloneCopyEvent( elem, clone );
			}
		}

		// Preserve script evaluation history
		destElements = getAll( clone, "script" );
		if ( destElements.length > 0 ) {
			setGlobalEval( destElements, !inPage && getAll( elem, "script" ) );
		}

		// Return the cloned set
		return clone;
	},

	cleanData: function( elems ) {
		var data, elem, type,
			special = jQuery.event.special,
			i = 0;

		for ( ; ( elem = elems[ i ] ) !== undefined; i++ ) {
			if ( acceptData( elem ) ) {
				if ( ( data = elem[ dataPriv.expando ] ) ) {
					if ( data.events ) {
						for ( type in data.events ) {
							if ( special[ type ] ) {
								jQuery.event.remove( elem, type );

							// This is a shortcut to avoid jQuery.event.remove's overhead
							} else {
								jQuery.removeEvent( elem, type, data.handle );
							}
						}
					}

					// Support: Chrome <=35 - 45+
					// Assign undefined instead of using delete, see Data#remove
					elem[ dataPriv.expando ] = undefined;
				}
				if ( elem[ dataUser.expando ] ) {

					// Support: Chrome <=35 - 45+
					// Assign undefined instead of using delete, see Data#remove
					elem[ dataUser.expando ] = undefined;
				}
			}
		}
	}
} );

jQuery.fn.extend( {
	detach: function( selector ) {
		return remove( this, selector, true );
	},

	remove: function( selector ) {
		return remove( this, selector );
	},

	text: function( value ) {
		return access( this, function( value ) {
			return value === undefined ?
				jQuery.text( this ) :
				this.empty().each( function() {
					if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
						this.textContent = value;
					}
				} );
		}, null, value, arguments.length );
	},

	append: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
				var target = manipulationTarget( this, elem );
				target.appendChild( elem );
			}
		} );
	},

	prepend: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
				var target = manipulationTarget( this, elem );
				target.insertBefore( elem, target.firstChild );
			}
		} );
	},

	before: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.parentNode ) {
				this.parentNode.insertBefore( elem, this );
			}
		} );
	},

	after: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.parentNode ) {
				this.parentNode.insertBefore( elem, this.nextSibling );
			}
		} );
	},

	empty: function() {
		var elem,
			i = 0;

		for ( ; ( elem = this[ i ] ) != null; i++ ) {
			if ( elem.nodeType === 1 ) {

				// Prevent memory leaks
				jQuery.cleanData( getAll( elem, false ) );

				// Remove any remaining nodes
				elem.textContent = "";
			}
		}

		return this;
	},

	clone: function( dataAndEvents, deepDataAndEvents ) {
		dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
		deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;

		return this.map( function() {
			return jQuery.clone( this, dataAndEvents, deepDataAndEvents );
		} );
	},

	html: function( value ) {
		return access( this, function( value ) {
			var elem = this[ 0 ] || {},
				i = 0,
				l = this.length;

			if ( value === undefined && elem.nodeType === 1 ) {
				return elem.innerHTML;
			}

			// See if we can take a shortcut and just use innerHTML
			if ( typeof value === "string" && !rnoInnerhtml.test( value ) &&
				!wrapMap[ ( rtagName.exec( value ) || [ "", "" ] )[ 1 ].toLowerCase() ] ) {

				value = jQuery.htmlPrefilter( value );

				try {
					for ( ; i < l; i++ ) {
						elem = this[ i ] || {};

						// Remove element nodes and prevent memory leaks
						if ( elem.nodeType === 1 ) {
							jQuery.cleanData( getAll( elem, false ) );
							elem.innerHTML = value;
						}
					}

					elem = 0;

				// If using innerHTML throws an exception, use the fallback method
				} catch ( e ) {}
			}

			if ( elem ) {
				this.empty().append( value );
			}
		}, null, value, arguments.length );
	},

	replaceWith: function() {
		var ignored = [];

		// Make the changes, replacing each non-ignored context element with the new content
		return domManip( this, arguments, function( elem ) {
			var parent = this.parentNode;

			if ( jQuery.inArray( this, ignored ) < 0 ) {
				jQuery.cleanData( getAll( this ) );
				if ( parent ) {
					parent.replaceChild( elem, this );
				}
			}

		// Force callback invocation
		}, ignored );
	}
} );

jQuery.each( {
	appendTo: "append",
	prependTo: "prepend",
	insertBefore: "before",
	insertAfter: "after",
	replaceAll: "replaceWith"
}, function( name, original ) {
	jQuery.fn[ name ] = function( selector ) {
		var elems,
			ret = [],
			insert = jQuery( selector ),
			last = insert.length - 1,
			i = 0;

		for ( ; i <= last; i++ ) {
			elems = i === last ? this : this.clone( true );
			jQuery( insert[ i ] )[ original ]( elems );

			// Support: Android <=4.0 only, PhantomJS 1 only
			// .get() because push.apply(_, arraylike) throws on ancient WebKit
			push.apply( ret, elems.get() );
		}

		return this.pushStack( ret );
	};
} );
var rnumnonpx = new RegExp( "^(" + pnum + ")(?!px)[a-z%]+$", "i" );

var getStyles = function( elem ) {

		// Support: IE <=11 only, Firefox <=30 (#15098, #14150)
		// IE throws on elements created in popups
		// FF meanwhile throws on frame elements through "defaultView.getComputedStyle"
		var view = elem.ownerDocument.defaultView;

		if ( !view || !view.opener ) {
			view = window;
		}

		return view.getComputedStyle( elem );
	};

var swap = function( elem, options, callback ) {
	var ret, name,
		old = {};

	// Remember the old values, and insert the new ones
	for ( name in options ) {
		old[ name ] = elem.style[ name ];
		elem.style[ name ] = options[ name ];
	}

	ret = callback.call( elem );

	// Revert the old values
	for ( name in options ) {
		elem.style[ name ] = old[ name ];
	}

	return ret;
};


var rboxStyle = new RegExp( cssExpand.join( "|" ), "i" );



( function() {

	// Executing both pixelPosition & boxSizingReliable tests require only one layout
	// so they're executed at the same time to save the second computation.
	function computeStyleTests() {

		// This is a singleton, we need to execute it only once
		if ( !div ) {
			return;
		}

		container.style.cssText = "position:absolute;left:-11111px;width:60px;" +
			"margin-top:1px;padding:0;border:0";
		div.style.cssText =
			"position:relative;display:block;box-sizing:border-box;overflow:scroll;" +
			"margin:auto;border:1px;padding:1px;" +
			"width:60%;top:1%";
		documentElement.appendChild( container ).appendChild( div );

		var divStyle = window.getComputedStyle( div );
		pixelPositionVal = divStyle.top !== "1%";

		// Support: Android 4.0 - 4.3 only, Firefox <=3 - 44
		reliableMarginLeftVal = roundPixelMeasures( divStyle.marginLeft ) === 12;

		// Support: Android 4.0 - 4.3 only, Safari <=9.1 - 10.1, iOS <=7.0 - 9.3
		// Some styles come back with percentage values, even though they shouldn't
		div.style.right = "60%";
		pixelBoxStylesVal = roundPixelMeasures( divStyle.right ) === 36;

		// Support: IE 9 - 11 only
		// Detect misreporting of content dimensions for box-sizing:border-box elements
		boxSizingReliableVal = roundPixelMeasures( divStyle.width ) === 36;

		// Support: IE 9 only
		// Detect overflow:scroll screwiness (gh-3699)
		// Support: Chrome <=64
		// Don't get tricked when zoom affects offsetWidth (gh-4029)
		div.style.position = "absolute";
		scrollboxSizeVal = roundPixelMeasures( div.offsetWidth / 3 ) === 12;

		documentElement.removeChild( container );

		// Nullify the div so it wouldn't be stored in the memory and
		// it will also be a sign that checks already performed
		div = null;
	}

	function roundPixelMeasures( measure ) {
		return Math.round( parseFloat( measure ) );
	}

	var pixelPositionVal, boxSizingReliableVal, scrollboxSizeVal, pixelBoxStylesVal,
		reliableTrDimensionsVal, reliableMarginLeftVal,
		container = document.createElement( "div" ),
		div = document.createElement( "div" );

	// Finish early in limited (non-browser) environments
	if ( !div.style ) {
		return;
	}

	// Support: IE <=9 - 11 only
	// Style of cloned element affects source element cloned (#8908)
	div.style.backgroundClip = "content-box";
	div.cloneNode( true ).style.backgroundClip = "";
	support.clearCloneStyle = div.style.backgroundClip === "content-box";

	jQuery.extend( support, {
		boxSizingReliable: function() {
			computeStyleTests();
			return boxSizingReliableVal;
		},
		pixelBoxStyles: function() {
			computeStyleTests();
			return pixelBoxStylesVal;
		},
		pixelPosition: function() {
			computeStyleTests();
			return pixelPositionVal;
		},
		reliableMarginLeft: function() {
			computeStyleTests();
			return reliableMarginLeftVal;
		},
		scrollboxSize: function() {
			computeStyleTests();
			return scrollboxSizeVal;
		},

		// Support: IE 9 - 11+, Edge 15 - 18+
		// IE/Edge misreport `getComputedStyle` of table rows with width/height
		// set in CSS while `offset*` properties report correct values.
		// Behavior in IE 9 is more subtle than in newer versions & it passes
		// some versions of this test; make sure not to make it pass there!
		//
		// Support: Firefox 70+
		// Only Firefox includes border widths
		// in computed dimensions. (gh-4529)
		reliableTrDimensions: function() {
			var table, tr, trChild, trStyle;
			if ( reliableTrDimensionsVal == null ) {
				table = document.createElement( "table" );
				tr = document.createElement( "tr" );
				trChild = document.createElement( "div" );

				table.style.cssText = "position:absolute;left:-11111px;border-collapse:separate";
				tr.style.cssText = "border:1px solid";

				// Support: Chrome 86+
				// Height set through cssText does not get applied.
				// Computed height then comes back as 0.
				tr.style.height = "1px";
				trChild.style.height = "9px";

				// Support: Android 8 Chrome 86+
				// In our bodyBackground.html iframe,
				// display for all div elements is set to "inline",
				// which causes a problem only in Android 8 Chrome 86.
				// Ensuring the div is display: block
				// gets around this issue.
				trChild.style.display = "block";

				documentElement
					.appendChild( table )
					.appendChild( tr )
					.appendChild( trChild );

				trStyle = window.getComputedStyle( tr );
				reliableTrDimensionsVal = ( parseInt( trStyle.height, 10 ) +
					parseInt( trStyle.borderTopWidth, 10 ) +
					parseInt( trStyle.borderBottomWidth, 10 ) ) === tr.offsetHeight;

				documentElement.removeChild( table );
			}
			return reliableTrDimensionsVal;
		}
	} );
} )();


function curCSS( elem, name, computed ) {
	var width, minWidth, maxWidth, ret,

		// Support: Firefox 51+
		// Retrieving style before computed somehow
		// fixes an issue with getting wrong values
		// on detached elements
		style = elem.style;

	computed = computed || getStyles( elem );

	// getPropertyValue is needed for:
	//   .css('filter') (IE 9 only, #12537)
	//   .css('--customProperty) (#3144)
	if ( computed ) {
		ret = computed.getPropertyValue( name ) || computed[ name ];

		if ( ret === "" && !isAttached( elem ) ) {
			ret = jQuery.style( elem, name );
		}

		// A tribute to the "awesome hack by Dean Edwards"
		// Android Browser returns percentage for some values,
		// but width seems to be reliably pixels.
		// This is against the CSSOM draft spec:
		// https://drafts.csswg.org/cssom/#resolved-values
		if ( !support.pixelBoxStyles() && rnumnonpx.test( ret ) && rboxStyle.test( name ) ) {

			// Remember the original values
			width = style.width;
			minWidth = style.minWidth;
			maxWidth = style.maxWidth;

			// Put in the new values to get a computed value out
			style.minWidth = style.maxWidth = style.width = ret;
			ret = computed.width;

			// Revert the changed values
			style.width = width;
			style.minWidth = minWidth;
			style.maxWidth = maxWidth;
		}
	}

	return ret !== undefined ?

		// Support: IE <=9 - 11 only
		// IE returns zIndex value as an integer.
		ret + "" :
		ret;
}


function addGetHookIf( conditionFn, hookFn ) {

	// Define the hook, we'll check on the first run if it's really needed.
	return {
		get: function() {
			if ( conditionFn() ) {

				// Hook not needed (or it's not possible to use it due
				// to missing dependency), remove it.
				delete this.get;
				return;
			}

			// Hook needed; redefine it so that the support test is not executed again.
			return ( this.get = hookFn ).apply( this, arguments );
		}
	};
}


var cssPrefixes = [ "Webkit", "Moz", "ms" ],
	emptyStyle = document.createElement( "div" ).style,
	vendorProps = {};

// Return a vendor-prefixed property or undefined
function vendorPropName( name ) {

	// Check for vendor prefixed names
	var capName = name[ 0 ].toUpperCase() + name.slice( 1 ),
		i = cssPrefixes.length;

	while ( i-- ) {
		name = cssPrefixes[ i ] + capName;
		if ( name in emptyStyle ) {
			return name;
		}
	}
}

// Return a potentially-mapped jQuery.cssProps or vendor prefixed property
function finalPropName( name ) {
	var final = jQuery.cssProps[ name ] || vendorProps[ name ];

	if ( final ) {
		return final;
	}
	if ( name in emptyStyle ) {
		return name;
	}
	return vendorProps[ name ] = vendorPropName( name ) || name;
}


var

	// Swappable if display is none or starts with table
	// except "table", "table-cell", or "table-caption"
	// See here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
	rdisplayswap = /^(none|table(?!-c[ea]).+)/,
	rcustomProp = /^--/,
	cssShow = { position: "absolute", visibility: "hidden", display: "block" },
	cssNormalTransform = {
		letterSpacing: "0",
		fontWeight: "400"
	};

function setPositiveNumber( _elem, value, subtract ) {

	// Any relative (+/-) values have already been
	// normalized at this point
	var matches = rcssNum.exec( value );
	return matches ?

		// Guard against undefined "subtract", e.g., when used as in cssHooks
		Math.max( 0, matches[ 2 ] - ( subtract || 0 ) ) + ( matches[ 3 ] || "px" ) :
		value;
}

function boxModelAdjustment( elem, dimension, box, isBorderBox, styles, computedVal ) {
	var i = dimension === "width" ? 1 : 0,
		extra = 0,
		delta = 0;

	// Adjustment may not be necessary
	if ( box === ( isBorderBox ? "border" : "content" ) ) {
		return 0;
	}

	for ( ; i < 4; i += 2 ) {

		// Both box models exclude margin
		if ( box === "margin" ) {
			delta += jQuery.css( elem, box + cssExpand[ i ], true, styles );
		}

		// If we get here with a content-box, we're seeking "padding" or "border" or "margin"
		if ( !isBorderBox ) {

			// Add padding
			delta += jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );

			// For "border" or "margin", add border
			if ( box !== "padding" ) {
				delta += jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );

			// But still keep track of it otherwise
			} else {
				extra += jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );
			}

		// If we get here with a border-box (content + padding + border), we're seeking "content" or
		// "padding" or "margin"
		} else {

			// For "content", subtract padding
			if ( box === "content" ) {
				delta -= jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );
			}

			// For "content" or "padding", subtract border
			if ( box !== "margin" ) {
				delta -= jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );
			}
		}
	}

	// Account for positive content-box scroll gutter when requested by providing computedVal
	if ( !isBorderBox && computedVal >= 0 ) {

		// offsetWidth/offsetHeight is a rounded sum of content, padding, scroll gutter, and border
		// Assuming integer scroll gutter, subtract the rest and round down
		delta += Math.max( 0, Math.ceil(
			elem[ "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 ) ] -
			computedVal -
			delta -
			extra -
			0.5

		// If offsetWidth/offsetHeight is unknown, then we can't determine content-box scroll gutter
		// Use an explicit zero to avoid NaN (gh-3964)
		) ) || 0;
	}

	return delta;
}

function getWidthOrHeight( elem, dimension, extra ) {

	// Start with computed style
	var styles = getStyles( elem ),

		// To avoid forcing a reflow, only fetch boxSizing if we need it (gh-4322).
		// Fake content-box until we know it's needed to know the true value.
		boxSizingNeeded = !support.boxSizingReliable() || extra,
		isBorderBox = boxSizingNeeded &&
			jQuery.css( elem, "boxSizing", false, styles ) === "border-box",
		valueIsBorderBox = isBorderBox,

		val = curCSS( elem, dimension, styles ),
		offsetProp = "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 );

	// Support: Firefox <=54
	// Return a confounding non-pixel value or feign ignorance, as appropriate.
	if ( rnumnonpx.test( val ) ) {
		if ( !extra ) {
			return val;
		}
		val = "auto";
	}


	// Support: IE 9 - 11 only
	// Use offsetWidth/offsetHeight for when box sizing is unreliable.
	// In those cases, the computed value can be trusted to be border-box.
	if ( ( !support.boxSizingReliable() && isBorderBox ||

		// Support: IE 10 - 11+, Edge 15 - 18+
		// IE/Edge misreport `getComputedStyle` of table rows with width/height
		// set in CSS while `offset*` properties report correct values.
		// Interestingly, in some cases IE 9 doesn't suffer from this issue.
		!support.reliableTrDimensions() && nodeName( elem, "tr" ) ||

		// Fall back to offsetWidth/offsetHeight when value is "auto"
		// This happens for inline elements with no explicit setting (gh-3571)
		val === "auto" ||

		// Support: Android <=4.1 - 4.3 only
		// Also use offsetWidth/offsetHeight for misreported inline dimensions (gh-3602)
		!parseFloat( val ) && jQuery.css( elem, "display", false, styles ) === "inline" ) &&

		// Make sure the element is visible & connected
		elem.getClientRects().length ) {

		isBorderBox = jQuery.css( elem, "boxSizing", false, styles ) === "border-box";

		// Where available, offsetWidth/offsetHeight approximate border box dimensions.
		// Where not available (e.g., SVG), assume unreliable box-sizing and interpret the
		// retrieved value as a content box dimension.
		valueIsBorderBox = offsetProp in elem;
		if ( valueIsBorderBox ) {
			val = elem[ offsetProp ];
		}
	}

	// Normalize "" and auto
	val = parseFloat( val ) || 0;

	// Adjust for the element's box model
	return ( val +
		boxModelAdjustment(
			elem,
			dimension,
			extra || ( isBorderBox ? "border" : "content" ),
			valueIsBorderBox,
			styles,

			// Provide the current computed size to request scroll gutter calculation (gh-3589)
			val
		)
	) + "px";
}

jQuery.extend( {

	// Add in style property hooks for overriding the default
	// behavior of getting and setting a style property
	cssHooks: {
		opacity: {
			get: function( elem, computed ) {
				if ( computed ) {

					// We should always get a number back from opacity
					var ret = curCSS( elem, "opacity" );
					return ret === "" ? "1" : ret;
				}
			}
		}
	},

	// Don't automatically add "px" to these possibly-unitless properties
	cssNumber: {
		"animationIterationCount": true,
		"columnCount": true,
		"fillOpacity": true,
		"flexGrow": true,
		"flexShrink": true,
		"fontWeight": true,
		"gridArea": true,
		"gridColumn": true,
		"gridColumnEnd": true,
		"gridColumnStart": true,
		"gridRow": true,
		"gridRowEnd": true,
		"gridRowStart": true,
		"lineHeight": true,
		"opacity": true,
		"order": true,
		"orphans": true,
		"widows": true,
		"zIndex": true,
		"zoom": true
	},

	// Add in properties whose names you wish to fix before
	// setting or getting the value
	cssProps: {},

	// Get and set the style property on a DOM Node
	style: function( elem, name, value, extra ) {

		// Don't set styles on text and comment nodes
		if ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {
			return;
		}

		// Make sure that we're working with the right name
		var ret, type, hooks,
			origName = camelCase( name ),
			isCustomProp = rcustomProp.test( name ),
			style = elem.style;

		// Make sure that we're working with the right name. We don't
		// want to query the value if it is a CSS custom property
		// since they are user-defined.
		if ( !isCustomProp ) {
			name = finalPropName( origName );
		}

		// Gets hook for the prefixed version, then unprefixed version
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

		// Check if we're setting a value
		if ( value !== undefined ) {
			type = typeof value;

			// Convert "+=" or "-=" to relative numbers (#7345)
			if ( type === "string" && ( ret = rcssNum.exec( value ) ) && ret[ 1 ] ) {
				value = adjustCSS( elem, name, ret );

				// Fixes bug #9237
				type = "number";
			}

			// Make sure that null and NaN values aren't set (#7116)
			if ( value == null || value !== value ) {
				return;
			}

			// If a number was passed in, add the unit (except for certain CSS properties)
			// The isCustomProp check can be removed in jQuery 4.0 when we only auto-append
			// "px" to a few hardcoded values.
			if ( type === "number" && !isCustomProp ) {
				value += ret && ret[ 3 ] || ( jQuery.cssNumber[ origName ] ? "" : "px" );
			}

			// background-* props affect original clone's values
			if ( !support.clearCloneStyle && value === "" && name.indexOf( "background" ) === 0 ) {
				style[ name ] = "inherit";
			}

			// If a hook was provided, use that value, otherwise just set the specified value
			if ( !hooks || !( "set" in hooks ) ||
				( value = hooks.set( elem, value, extra ) ) !== undefined ) {

				if ( isCustomProp ) {
					style.setProperty( name, value );
				} else {
					style[ name ] = value;
				}
			}

		} else {

			// If a hook was provided get the non-computed value from there
			if ( hooks && "get" in hooks &&
				( ret = hooks.get( elem, false, extra ) ) !== undefined ) {

				return ret;
			}

			// Otherwise just get the value from the style object
			return style[ name ];
		}
	},

	css: function( elem, name, extra, styles ) {
		var val, num, hooks,
			origName = camelCase( name ),
			isCustomProp = rcustomProp.test( name );

		// Make sure that we're working with the right name. We don't
		// want to modify the value if it is a CSS custom property
		// since they are user-defined.
		if ( !isCustomProp ) {
			name = finalPropName( origName );
		}

		// Try prefixed name followed by the unprefixed name
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

		// If a hook was provided get the computed value from there
		if ( hooks && "get" in hooks ) {
			val = hooks.get( elem, true, extra );
		}

		// Otherwise, if a way to get the computed value exists, use that
		if ( val === undefined ) {
			val = curCSS( elem, name, styles );
		}

		// Convert "normal" to computed value
		if ( val === "normal" && name in cssNormalTransform ) {
			val = cssNormalTransform[ name ];
		}

		// Make numeric if forced or a qualifier was provided and val looks numeric
		if ( extra === "" || extra ) {
			num = parseFloat( val );
			return extra === true || isFinite( num ) ? num || 0 : val;
		}

		return val;
	}
} );

jQuery.each( [ "height", "width" ], function( _i, dimension ) {
	jQuery.cssHooks[ dimension ] = {
		get: function( elem, computed, extra ) {
			if ( computed ) {

				// Certain elements can have dimension info if we invisibly show them
				// but it must have a current display style that would benefit
				return rdisplayswap.test( jQuery.css( elem, "display" ) ) &&

					// Support: Safari 8+
					// Table columns in Safari have non-zero offsetWidth & zero
					// getBoundingClientRect().width unless display is changed.
					// Support: IE <=11 only
					// Running getBoundingClientRect on a disconnected node
					// in IE throws an error.
					( !elem.getClientRects().length || !elem.getBoundingClientRect().width ) ?
					swap( elem, cssShow, function() {
						return getWidthOrHeight( elem, dimension, extra );
					} ) :
					getWidthOrHeight( elem, dimension, extra );
			}
		},

		set: function( elem, value, extra ) {
			var matches,
				styles = getStyles( elem ),

				// Only read styles.position if the test has a chance to fail
				// to avoid forcing a reflow.
				scrollboxSizeBuggy = !support.scrollboxSize() &&
					styles.position === "absolute",

				// To avoid forcing a reflow, only fetch boxSizing if we need it (gh-3991)
				boxSizingNeeded = scrollboxSizeBuggy || extra,
				isBorderBox = boxSizingNeeded &&
					jQuery.css( elem, "boxSizing", false, styles ) === "border-box",
				subtract = extra ?
					boxModelAdjustment(
						elem,
						dimension,
						extra,
						isBorderBox,
						styles
					) :
					0;

			// Account for unreliable border-box dimensions by comparing offset* to computed and
			// faking a content-box to get border and padding (gh-3699)
			if ( isBorderBox && scrollboxSizeBuggy ) {
				subtract -= Math.ceil(
					elem[ "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 ) ] -
					parseFloat( styles[ dimension ] ) -
					boxModelAdjustment( elem, dimension, "border", false, styles ) -
					0.5
				);
			}

			// Convert to pixels if value adjustment is needed
			if ( subtract && ( matches = rcssNum.exec( value ) ) &&
				( matches[ 3 ] || "px" ) !== "px" ) {

				elem.style[ dimension ] = value;
				value = jQuery.css( elem, dimension );
			}

			return setPositiveNumber( elem, value, subtract );
		}
	};
} );

jQuery.cssHooks.marginLeft = addGetHookIf( support.reliableMarginLeft,
	function( elem, computed ) {
		if ( computed ) {
			return ( parseFloat( curCSS( elem, "marginLeft" ) ) ||
				elem.getBoundingClientRect().left -
					swap( elem, { marginLeft: 0 }, function() {
						return elem.getBoundingClientRect().left;
					} )
			) + "px";
		}
	}
);

// These hooks are used by animate to expand properties
jQuery.each( {
	margin: "",
	padding: "",
	border: "Width"
}, function( prefix, suffix ) {
	jQuery.cssHooks[ prefix + suffix ] = {
		expand: function( value ) {
			var i = 0,
				expanded = {},

				// Assumes a single number if not a string
				parts = typeof value === "string" ? value.split( " " ) : [ value ];

			for ( ; i < 4; i++ ) {
				expanded[ prefix + cssExpand[ i ] + suffix ] =
					parts[ i ] || parts[ i - 2 ] || parts[ 0 ];
			}

			return expanded;
		}
	};

	if ( prefix !== "margin" ) {
		jQuery.cssHooks[ prefix + suffix ].set = setPositiveNumber;
	}
} );

jQuery.fn.extend( {
	css: function( name, value ) {
		return access( this, function( elem, name, value ) {
			var styles, len,
				map = {},
				i = 0;

			if ( Array.isArray( name ) ) {
				styles = getStyles( elem );
				len = name.length;

				for ( ; i < len; i++ ) {
					map[ name[ i ] ] = jQuery.css( elem, name[ i ], false, styles );
				}

				return map;
			}

			return value !== undefined ?
				jQuery.style( elem, name, value ) :
				jQuery.css( elem, name );
		}, name, value, arguments.length > 1 );
	}
} );


function Tween( elem, options, prop, end, easing ) {
	return new Tween.prototype.init( elem, options, prop, end, easing );
}
jQuery.Tween = Tween;

Tween.prototype = {
	constructor: Tween,
	init: function( elem, options, prop, end, easing, unit ) {
		this.elem = elem;
		this.prop = prop;
		this.easing = easing || jQuery.easing._default;
		this.options = options;
		this.start = this.now = this.cur();
		this.end = end;
		this.unit = unit || ( jQuery.cssNumber[ prop ] ? "" : "px" );
	},
	cur: function() {
		var hooks = Tween.propHooks[ this.prop ];

		return hooks && hooks.get ?
			hooks.get( this ) :
			Tween.propHooks._default.get( this );
	},
	run: function( percent ) {
		var eased,
			hooks = Tween.propHooks[ this.prop ];

		if ( this.options.duration ) {
			this.pos = eased = jQuery.easing[ this.easing ](
				percent, this.options.duration * percent, 0, 1, this.options.duration
			);
		} else {
			this.pos = eased = percent;
		}
		this.now = ( this.end - this.start ) * eased + this.start;

		if ( this.options.step ) {
			this.options.step.call( this.elem, this.now, this );
		}

		if ( hooks && hooks.set ) {
			hooks.set( this );
		} else {
			Tween.propHooks._default.set( this );
		}
		return this;
	}
};

Tween.prototype.init.prototype = Tween.prototype;

Tween.propHooks = {
	_default: {
		get: function( tween ) {
			var result;

			// Use a property on the element directly when it is not a DOM element,
			// or when there is no matching style property that exists.
			if ( tween.elem.nodeType !== 1 ||
				tween.elem[ tween.prop ] != null && tween.elem.style[ tween.prop ] == null ) {
				return tween.elem[ tween.prop ];
			}

			// Passing an empty string as a 3rd parameter to .css will automatically
			// attempt a parseFloat and fallback to a string if the parse fails.
			// Simple values such as "10px" are parsed to Float;
			// complex values such as "rotate(1rad)" are returned as-is.
			result = jQuery.css( tween.elem, tween.prop, "" );

			// Empty strings, null, undefined and "auto" are converted to 0.
			return !result || result === "auto" ? 0 : result;
		},
		set: function( tween ) {

			// Use step hook for back compat.
			// Use cssHook if its there.
			// Use .style if available and use plain properties where available.
			if ( jQuery.fx.step[ tween.prop ] ) {
				jQuery.fx.step[ tween.prop ]( tween );
			} else if ( tween.elem.nodeType === 1 && (
				jQuery.cssHooks[ tween.prop ] ||
					tween.elem.style[ finalPropName( tween.prop ) ] != null ) ) {
				jQuery.style( tween.elem, tween.prop, tween.now + tween.unit );
			} else {
				tween.elem[ tween.prop ] = tween.now;
			}
		}
	}
};

// Support: IE <=9 only
// Panic based approach to setting things on disconnected nodes
Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {
	set: function( tween ) {
		if ( tween.elem.nodeType && tween.elem.parentNode ) {
			tween.elem[ tween.prop ] = tween.now;
		}
	}
};

jQuery.easing = {
	linear: function( p ) {
		return p;
	},
	swing: function( p ) {
		return 0.5 - Math.cos( p * Math.PI ) / 2;
	},
	_default: "swing"
};

jQuery.fx = Tween.prototype.init;

// Back compat <1.8 extension point
jQuery.fx.step = {};




var
	fxNow, inProgress,
	rfxtypes = /^(?:toggle|show|hide)$/,
	rrun = /queueHooks$/;

function schedule() {
	if ( inProgress ) {
		if ( document.hidden === false && window.requestAnimationFrame ) {
			window.requestAnimationFrame( schedule );
		} else {
			window.setTimeout( schedule, jQuery.fx.interval );
		}

		jQuery.fx.tick();
	}
}

// Animations created synchronously will run synchronously
function createFxNow() {
	window.setTimeout( function() {
		fxNow = undefined;
	} );
	return ( fxNow = Date.now() );
}

// Generate parameters to create a standard animation
function genFx( type, includeWidth ) {
	var which,
		i = 0,
		attrs = { height: type };

	// If we include width, step value is 1 to do all cssExpand values,
	// otherwise step value is 2 to skip over Left and Right
	includeWidth = includeWidth ? 1 : 0;
	for ( ; i < 4; i += 2 - includeWidth ) {
		which = cssExpand[ i ];
		attrs[ "margin" + which ] = attrs[ "padding" + which ] = type;
	}

	if ( includeWidth ) {
		attrs.opacity = attrs.width = type;
	}

	return attrs;
}

function createTween( value, prop, animation ) {
	var tween,
		collection = ( Animation.tweeners[ prop ] || [] ).concat( Animation.tweeners[ "*" ] ),
		index = 0,
		length = collection.length;
	for ( ; index < length; index++ ) {
		if ( ( tween = collection[ index ].call( animation, prop, value ) ) ) {

			// We're done with this property
			return tween;
		}
	}
}

function defaultPrefilter( elem, props, opts ) {
	var prop, value, toggle, hooks, oldfire, propTween, restoreDisplay, display,
		isBox = "width" in props || "height" in props,
		anim = this,
		orig = {},
		style = elem.style,
		hidden = elem.nodeType && isHiddenWithinTree( elem ),
		dataShow = dataPriv.get( elem, "fxshow" );

	// Queue-skipping animations hijack the fx hooks
	if ( !opts.queue ) {
		hooks = jQuery._queueHooks( elem, "fx" );
		if ( hooks.unqueued == null ) {
			hooks.unqueued = 0;
			oldfire = hooks.empty.fire;
			hooks.empty.fire = function() {
				if ( !hooks.unqueued ) {
					oldfire();
				}
			};
		}
		hooks.unqueued++;

		anim.always( function() {

			// Ensure the complete handler is called before this completes
			anim.always( function() {
				hooks.unqueued--;
				if ( !jQuery.queue( elem, "fx" ).length ) {
					hooks.empty.fire();
				}
			} );
		} );
	}

	// Detect show/hide animations
	for ( prop in props ) {
		value = props[ prop ];
		if ( rfxtypes.test( value ) ) {
			delete props[ prop ];
			toggle = toggle || value === "toggle";
			if ( value === ( hidden ? "hide" : "show" ) ) {

				// Pretend to be hidden if this is a "show" and
				// there is still data from a stopped show/hide
				if ( value === "show" && dataShow && dataShow[ prop ] !== undefined ) {
					hidden = true;

				// Ignore all other no-op show/hide data
				} else {
					continue;
				}
			}
			orig[ prop ] = dataShow && dataShow[ prop ] || jQuery.style( elem, prop );
		}
	}

	// Bail out if this is a no-op like .hide().hide()
	propTween = !jQuery.isEmptyObject( props );
	if ( !propTween && jQuery.isEmptyObject( orig ) ) {
		return;
	}

	// Restrict "overflow" and "display" styles during box animations
	if ( isBox && elem.nodeType === 1 ) {

		// Support: IE <=9 - 11, Edge 12 - 15
		// Record all 3 overflow attributes because IE does not infer the shorthand
		// from identically-valued overflowX and overflowY and Edge just mirrors
		// the overflowX value there.
		opts.overflow = [ style.overflow, style.overflowX, style.overflowY ];

		// Identify a display type, preferring old show/hide data over the CSS cascade
		restoreDisplay = dataShow && dataShow.display;
		if ( restoreDisplay == null ) {
			restoreDisplay = dataPriv.get( elem, "display" );
		}
		display = jQuery.css( elem, "display" );
		if ( display === "none" ) {
			if ( restoreDisplay ) {
				display = restoreDisplay;
			} else {

				// Get nonempty value(s) by temporarily forcing visibility
				showHide( [ elem ], true );
				restoreDisplay = elem.style.display || restoreDisplay;
				display = jQuery.css( elem, "display" );
				showHide( [ elem ] );
			}
		}

		// Animate inline elements as inline-block
		if ( display === "inline" || display === "inline-block" && restoreDisplay != null ) {
			if ( jQuery.css( elem, "float" ) === "none" ) {

				// Restore the original display value at the end of pure show/hide animations
				if ( !propTween ) {
					anim.done( function() {
						style.display = restoreDisplay;
					} );
					if ( restoreDisplay == null ) {
						display = style.display;
						restoreDisplay = display === "none" ? "" : display;
					}
				}
				style.display = "inline-block";
			}
		}
	}

	if ( opts.overflow ) {
		style.overflow = "hidden";
		anim.always( function() {
			style.overflow = opts.overflow[ 0 ];
			style.overflowX = opts.overflow[ 1 ];
			style.overflowY = opts.overflow[ 2 ];
		} );
	}

	// Implement show/hide animations
	propTween = false;
	for ( prop in orig ) {

		// General show/hide setup for this element animation
		if ( !propTween ) {
			if ( dataShow ) {
				if ( "hidden" in dataShow ) {
					hidden = dataShow.hidden;
				}
			} else {
				dataShow = dataPriv.access( elem, "fxshow", { display: restoreDisplay } );
			}

			// Store hidden/visible for toggle so `.stop().toggle()` "reverses"
			if ( toggle ) {
				dataShow.hidden = !hidden;
			}

			// Show elements before animating them
			if ( hidden ) {
				showHide( [ elem ], true );
			}

			/* eslint-disable no-loop-func */

			anim.done( function() {

				/* eslint-enable no-loop-func */

				// The final step of a "hide" animation is actually hiding the element
				if ( !hidden ) {
					showHide( [ elem ] );
				}
				dataPriv.remove( elem, "fxshow" );
				for ( prop in orig ) {
					jQuery.style( elem, prop, orig[ prop ] );
				}
			} );
		}

		// Per-property setup
		propTween = createTween( hidden ? dataShow[ prop ] : 0, prop, anim );
		if ( !( prop in dataShow ) ) {
			dataShow[ prop ] = propTween.start;
			if ( hidden ) {
				propTween.end = propTween.start;
				propTween.start = 0;
			}
		}
	}
}

function propFilter( props, specialEasing ) {
	var index, name, easing, value, hooks;

	// camelCase, specialEasing and expand cssHook pass
	for ( index in props ) {
		name = camelCase( index );
		easing = specialEasing[ name ];
		value = props[ index ];
		if ( Array.isArray( value ) ) {
			easing = value[ 1 ];
			value = props[ index ] = value[ 0 ];
		}

		if ( index !== name ) {
			props[ name ] = value;
			delete props[ index ];
		}

		hooks = jQuery.cssHooks[ name ];
		if ( hooks && "expand" in hooks ) {
			value = hooks.expand( value );
			delete props[ name ];

			// Not quite $.extend, this won't overwrite existing keys.
			// Reusing 'index' because we have the correct "name"
			for ( index in value ) {
				if ( !( index in props ) ) {
					props[ index ] = value[ index ];
					specialEasing[ index ] = easing;
				}
			}
		} else {
			specialEasing[ name ] = easing;
		}
	}
}

function Animation( elem, properties, options ) {
	var result,
		stopped,
		index = 0,
		length = Animation.prefilters.length,
		deferred = jQuery.Deferred().always( function() {

			// Don't match elem in the :animated selector
			delete tick.elem;
		} ),
		tick = function() {
			if ( stopped ) {
				return false;
			}
			var currentTime = fxNow || createFxNow(),
				remaining = Math.max( 0, animation.startTime + animation.duration - currentTime ),

				// Support: Android 2.3 only
				// Archaic crash bug won't allow us to use `1 - ( 0.5 || 0 )` (#12497)
				temp = remaining / animation.duration || 0,
				percent = 1 - temp,
				index = 0,
				length = animation.tweens.length;

			for ( ; index < length; index++ ) {
				animation.tweens[ index ].run( percent );
			}

			deferred.notifyWith( elem, [ animation, percent, remaining ] );

			// If there's more to do, yield
			if ( percent < 1 && length ) {
				return remaining;
			}

			// If this was an empty animation, synthesize a final progress notification
			if ( !length ) {
				deferred.notifyWith( elem, [ animation, 1, 0 ] );
			}

			// Resolve the animation and report its conclusion
			deferred.resolveWith( elem, [ animation ] );
			return false;
		},
		animation = deferred.promise( {
			elem: elem,
			props: jQuery.extend( {}, properties ),
			opts: jQuery.extend( true, {
				specialEasing: {},
				easing: jQuery.easing._default
			}, options ),
			originalProperties: properties,
			originalOptions: options,
			startTime: fxNow || createFxNow(),
			duration: options.duration,
			tweens: [],
			createTween: function( prop, end ) {
				var tween = jQuery.Tween( elem, animation.opts, prop, end,
					animation.opts.specialEasing[ prop ] || animation.opts.easing );
				animation.tweens.push( tween );
				return tween;
			},
			stop: function( gotoEnd ) {
				var index = 0,

					// If we are going to the end, we want to run all the tweens
					// otherwise we skip this part
					length = gotoEnd ? animation.tweens.length : 0;
				if ( stopped ) {
					return this;
				}
				stopped = true;
				for ( ; index < length; index++ ) {
					animation.tweens[ index ].run( 1 );
				}

				// Resolve when we played the last frame; otherwise, reject
				if ( gotoEnd ) {
					deferred.notifyWith( elem, [ animation, 1, 0 ] );
					deferred.resolveWith( elem, [ animation, gotoEnd ] );
				} else {
					deferred.rejectWith( elem, [ animation, gotoEnd ] );
				}
				return this;
			}
		} ),
		props = animation.props;

	propFilter( props, animation.opts.specialEasing );

	for ( ; index < length; index++ ) {
		result = Animation.prefilters[ index ].call( animation, elem, props, animation.opts );
		if ( result ) {
			if ( isFunction( result.stop ) ) {
				jQuery._queueHooks( animation.elem, animation.opts.queue ).stop =
					result.stop.bind( result );
			}
			return result;
		}
	}

	jQuery.map( props, createTween, animation );

	if ( isFunction( animation.opts.start ) ) {
		animation.opts.start.call( elem, animation );
	}

	// Attach callbacks from options
	animation
		.progress( animation.opts.progress )
		.done( animation.opts.done, animation.opts.complete )
		.fail( animation.opts.fail )
		.always( animation.opts.always );

	jQuery.fx.timer(
		jQuery.extend( tick, {
			elem: elem,
			anim: animation,
			queue: animation.opts.queue
		} )
	);

	return animation;
}

jQuery.Animation = jQuery.extend( Animation, {

	tweeners: {
		"*": [ function( prop, value ) {
			var tween = this.createTween( prop, value );
			adjustCSS( tween.elem, prop, rcssNum.exec( value ), tween );
			return tween;
		} ]
	},

	tweener: function( props, callback ) {
		if ( isFunction( props ) ) {
			callback = props;
			props = [ "*" ];
		} else {
			props = props.match( rnothtmlwhite );
		}

		var prop,
			index = 0,
			length = props.length;

		for ( ; index < length; index++ ) {
			prop = props[ index ];
			Animation.tweeners[ prop ] = Animation.tweeners[ prop ] || [];
			Animation.tweeners[ prop ].unshift( callback );
		}
	},

	prefilters: [ defaultPrefilter ],

	prefilter: function( callback, prepend ) {
		if ( prepend ) {
			Animation.prefilters.unshift( callback );
		} else {
			Animation.prefilters.push( callback );
		}
	}
} );

jQuery.speed = function( speed, easing, fn ) {
	var opt = speed && typeof speed === "object" ? jQuery.extend( {}, speed ) : {
		complete: fn || !fn && easing ||
			isFunction( speed ) && speed,
		duration: speed,
		easing: fn && easing || easing && !isFunction( easing ) && easing
	};

	// Go to the end state if fx are off
	if ( jQuery.fx.off ) {
		opt.duration = 0;

	} else {
		if ( typeof opt.duration !== "number" ) {
			if ( opt.duration in jQuery.fx.speeds ) {
				opt.duration = jQuery.fx.speeds[ opt.duration ];

			} else {
				opt.duration = jQuery.fx.speeds._default;
			}
		}
	}

	// Normalize opt.queue - true/undefined/null -> "fx"
	if ( opt.queue == null || opt.queue === true ) {
		opt.queue = "fx";
	}

	// Queueing
	opt.old = opt.complete;

	opt.complete = function() {
		if ( isFunction( opt.old ) ) {
			opt.old.call( this );
		}

		if ( opt.queue ) {
			jQuery.dequeue( this, opt.queue );
		}
	};

	return opt;
};

jQuery.fn.extend( {
	fadeTo: function( speed, to, easing, callback ) {

		// Show any hidden elements after setting opacity to 0
		return this.filter( isHiddenWithinTree ).css( "opacity", 0 ).show()

			// Animate to the value specified
			.end().animate( { opacity: to }, speed, easing, callback );
	},
	animate: function( prop, speed, easing, callback ) {
		var empty = jQuery.isEmptyObject( prop ),
			optall = jQuery.speed( speed, easing, callback ),
			doAnimation = function() {

				// Operate on a copy of prop so per-property easing won't be lost
				var anim = Animation( this, jQuery.extend( {}, prop ), optall );

				// Empty animations, or finishing resolves immediately
				if ( empty || dataPriv.get( this, "finish" ) ) {
					anim.stop( true );
				}
			};

		doAnimation.finish = doAnimation;

		return empty || optall.queue === false ?
			this.each( doAnimation ) :
			this.queue( optall.queue, doAnimation );
	},
	stop: function( type, clearQueue, gotoEnd ) {
		var stopQueue = function( hooks ) {
			var stop = hooks.stop;
			delete hooks.stop;
			stop( gotoEnd );
		};

		if ( typeof type !== "string" ) {
			gotoEnd = clearQueue;
			clearQueue = type;
			type = undefined;
		}
		if ( clearQueue ) {
			this.queue( type || "fx", [] );
		}

		return this.each( function() {
			var dequeue = true,
				index = type != null && type + "queueHooks",
				timers = jQuery.timers,
				data = dataPriv.get( this );

			if ( index ) {
				if ( data[ index ] && data[ index ].stop ) {
					stopQueue( data[ index ] );
				}
			} else {
				for ( index in data ) {
					if ( data[ index ] && data[ index ].stop && rrun.test( index ) ) {
						stopQueue( data[ index ] );
					}
				}
			}

			for ( index = timers.length; index--; ) {
				if ( timers[ index ].elem === this &&
					( type == null || timers[ index ].queue === type ) ) {

					timers[ index ].anim.stop( gotoEnd );
					dequeue = false;
					timers.splice( index, 1 );
				}
			}

			// Start the next in the queue if the last step wasn't forced.
			// Timers currently will call their complete callbacks, which
			// will dequeue but only if they were gotoEnd.
			if ( dequeue || !gotoEnd ) {
				jQuery.dequeue( this, type );
			}
		} );
	},
	finish: function( type ) {
		if ( type !== false ) {
			type = type || "fx";
		}
		return this.each( function() {
			var index,
				data = dataPriv.get( this ),
				queue = data[ type + "queue" ],
				hooks = data[ type + "queueHooks" ],
				timers = jQuery.timers,
				length = queue ? queue.length : 0;

			// Enable finishing flag on private data
			data.finish = true;

			// Empty the queue first
			jQuery.queue( this, type, [] );

			if ( hooks && hooks.stop ) {
				hooks.stop.call( this, true );
			}

			// Look for any active animations, and finish them
			for ( index = timers.length; index--; ) {
				if ( timers[ index ].elem === this && timers[ index ].queue === type ) {
					timers[ index ].anim.stop( true );
					timers.splice( index, 1 );
				}
			}

			// Look for any animations in the old queue and finish them
			for ( index = 0; index < length; index++ ) {
				if ( queue[ index ] && queue[ index ].finish ) {
					queue[ index ].finish.call( this );
				}
			}

			// Turn off finishing flag
			delete data.finish;
		} );
	}
} );

jQuery.each( [ "toggle", "show", "hide" ], function( _i, name ) {
	var cssFn = jQuery.fn[ name ];
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return speed == null || typeof speed === "boolean" ?
			cssFn.apply( this, arguments ) :
			this.animate( genFx( name, true ), speed, easing, callback );
	};
} );

// Generate shortcuts for custom animations
jQuery.each( {
	slideDown: genFx( "show" ),
	slideUp: genFx( "hide" ),
	slideToggle: genFx( "toggle" ),
	fadeIn: { opacity: "show" },
	fadeOut: { opacity: "hide" },
	fadeToggle: { opacity: "toggle" }
}, function( name, props ) {
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return this.animate( props, speed, easing, callback );
	};
} );

jQuery.timers = [];
jQuery.fx.tick = function() {
	var timer,
		i = 0,
		timers = jQuery.timers;

	fxNow = Date.now();

	for ( ; i < timers.length; i++ ) {
		timer = timers[ i ];

		// Run the timer and safely remove it when done (allowing for external removal)
		if ( !timer() && timers[ i ] === timer ) {
			timers.splice( i--, 1 );
		}
	}

	if ( !timers.length ) {
		jQuery.fx.stop();
	}
	fxNow = undefined;
};

jQuery.fx.timer = function( timer ) {
	jQuery.timers.push( timer );
	jQuery.fx.start();
};

jQuery.fx.interval = 13;
jQuery.fx.start = function() {
	if ( inProgress ) {
		return;
	}

	inProgress = true;
	schedule();
};

jQuery.fx.stop = function() {
	inProgress = null;
};

jQuery.fx.speeds = {
	slow: 600,
	fast: 200,

	// Default speed
	_default: 400
};


// Based off of the plugin by Clint Helfers, with permission.
// https://web.archive.org/web/20100324014747/http://blindsignals.com/index.php/2009/07/jquery-delay/
jQuery.fn.delay = function( time, type ) {
	time = jQuery.fx ? jQuery.fx.speeds[ time ] || time : time;
	type = type || "fx";

	return this.queue( type, function( next, hooks ) {
		var timeout = window.setTimeout( next, time );
		hooks.stop = function() {
			window.clearTimeout( timeout );
		};
	} );
};


( function() {
	var input = document.createElement( "input" ),
		select = document.createElement( "select" ),
		opt = select.appendChild( document.createElement( "option" ) );

	input.type = "checkbox";

	// Support: Android <=4.3 only
	// Default value for a checkbox should be "on"
	support.checkOn = input.value !== "";

	// Support: IE <=11 only
	// Must access selectedIndex to make default options select
	support.optSelected = opt.selected;

	// Support: IE <=11 only
	// An input loses its value after becoming a radio
	input = document.createElement( "input" );
	input.value = "t";
	input.type = "radio";
	support.radioValue = input.value === "t";
} )();


var boolHook,
	attrHandle = jQuery.expr.attrHandle;

jQuery.fn.extend( {
	attr: function( name, value ) {
		return access( this, jQuery.attr, name, value, arguments.length > 1 );
	},

	removeAttr: function( name ) {
		return this.each( function() {
			jQuery.removeAttr( this, name );
		} );
	}
} );

jQuery.extend( {
	attr: function( elem, name, value ) {
		var ret, hooks,
			nType = elem.nodeType;

		// Don't get/set attributes on text, comment and attribute nodes
		if ( nType === 3 || nType === 8 || nType === 2 ) {
			return;
		}

		// Fallback to prop when attributes are not supported
		if ( typeof elem.getAttribute === "undefined" ) {
			return jQuery.prop( elem, name, value );
		}

		// Attribute hooks are determined by the lowercase version
		// Grab necessary hook if one is defined
		if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {
			hooks = jQuery.attrHooks[ name.toLowerCase() ] ||
				( jQuery.expr.match.bool.test( name ) ? boolHook : undefined );
		}

		if ( value !== undefined ) {
			if ( value === null ) {
				jQuery.removeAttr( elem, name );
				return;
			}

			if ( hooks && "set" in hooks &&
				( ret = hooks.set( elem, value, name ) ) !== undefined ) {
				return ret;
			}

			elem.setAttribute( name, value + "" );
			return value;
		}

		if ( hooks && "get" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {
			return ret;
		}

		ret = jQuery.find.attr( elem, name );

		// Non-existent attributes return null, we normalize to undefined
		return ret == null ? undefined : ret;
	},

	attrHooks: {
		type: {
			set: function( elem, value ) {
				if ( !support.radioValue && value === "radio" &&
					nodeName( elem, "input" ) ) {
					var val = elem.value;
					elem.setAttribute( "type", value );
					if ( val ) {
						elem.value = val;
					}
					return value;
				}
			}
		}
	},

	removeAttr: function( elem, value ) {
		var name,
			i = 0,

			// Attribute names can contain non-HTML whitespace characters
			// https://html.spec.whatwg.org/multipage/syntax.html#attributes-2
			attrNames = value && value.match( rnothtmlwhite );

		if ( attrNames && elem.nodeType === 1 ) {
			while ( ( name = attrNames[ i++ ] ) ) {
				elem.removeAttribute( name );
			}
		}
	}
} );

// Hooks for boolean attributes
boolHook = {
	set: function( elem, value, name ) {
		if ( value === false ) {

			// Remove boolean attributes when set to false
			jQuery.removeAttr( elem, name );
		} else {
			elem.setAttribute( name, name );
		}
		return name;
	}
};

jQuery.each( jQuery.expr.match.bool.source.match( /\w+/g ), function( _i, name ) {
	var getter = attrHandle[ name ] || jQuery.find.attr;

	attrHandle[ name ] = function( elem, name, isXML ) {
		var ret, handle,
			lowercaseName = name.toLowerCase();

		if ( !isXML ) {

			// Avoid an infinite loop by temporarily removing this function from the getter
			handle = attrHandle[ lowercaseName ];
			attrHandle[ lowercaseName ] = ret;
			ret = getter( elem, name, isXML ) != null ?
				lowercaseName :
				null;
			attrHandle[ lowercaseName ] = handle;
		}
		return ret;
	};
} );




var rfocusable = /^(?:input|select|textarea|button)$/i,
	rclickable = /^(?:a|area)$/i;

jQuery.fn.extend( {
	prop: function( name, value ) {
		return access( this, jQuery.prop, name, value, arguments.length > 1 );
	},

	removeProp: function( name ) {
		return this.each( function() {
			delete this[ jQuery.propFix[ name ] || name ];
		} );
	}
} );

jQuery.extend( {
	prop: function( elem, name, value ) {
		var ret, hooks,
			nType = elem.nodeType;

		// Don't get/set properties on text, comment and attribute nodes
		if ( nType === 3 || nType === 8 || nType === 2 ) {
			return;
		}

		if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {

			// Fix name and attach hooks
			name = jQuery.propFix[ name ] || name;
			hooks = jQuery.propHooks[ name ];
		}

		if ( value !== undefined ) {
			if ( hooks && "set" in hooks &&
				( ret = hooks.set( elem, value, name ) ) !== undefined ) {
				return ret;
			}

			return ( elem[ name ] = value );
		}

		if ( hooks && "get" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {
			return ret;
		}

		return elem[ name ];
	},

	propHooks: {
		tabIndex: {
			get: function( elem ) {

				// Support: IE <=9 - 11 only
				// elem.tabIndex doesn't always return the
				// correct value when it hasn't been explicitly set
				// https://web.archive.org/web/20141116233347/http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/
				// Use proper attribute retrieval(#12072)
				var tabindex = jQuery.find.attr( elem, "tabindex" );

				if ( tabindex ) {
					return parseInt( tabindex, 10 );
				}

				if (
					rfocusable.test( elem.nodeName ) ||
					rclickable.test( elem.nodeName ) &&
					elem.href
				) {
					return 0;
				}

				return -1;
			}
		}
	},

	propFix: {
		"for": "htmlFor",
		"class": "className"
	}
} );

// Support: IE <=11 only
// Accessing the selectedIndex property
// forces the browser to respect setting selected
// on the option
// The getter ensures a default option is selected
// when in an optgroup
// eslint rule "no-unused-expressions" is disabled for this code
// since it considers such accessions noop
if ( !support.optSelected ) {
	jQuery.propHooks.selected = {
		get: function( elem ) {

			/* eslint no-unused-expressions: "off" */

			var parent = elem.parentNode;
			if ( parent && parent.parentNode ) {
				parent.parentNode.selectedIndex;
			}
			return null;
		},
		set: function( elem ) {

			/* eslint no-unused-expressions: "off" */

			var parent = elem.parentNode;
			if ( parent ) {
				parent.selectedIndex;

				if ( parent.parentNode ) {
					parent.parentNode.selectedIndex;
				}
			}
		}
	};
}

jQuery.each( [
	"tabIndex",
	"readOnly",
	"maxLength",
	"cellSpacing",
	"cellPadding",
	"rowSpan",
	"colSpan",
	"useMap",
	"frameBorder",
	"contentEditable"
], function() {
	jQuery.propFix[ this.toLowerCase() ] = this;
} );




	// Strip and collapse whitespace according to HTML spec
	// https://infra.spec.whatwg.org/#strip-and-collapse-ascii-whitespace
	function stripAndCollapse( value ) {
		var tokens = value.match( rnothtmlwhite ) || [];
		return tokens.join( " " );
	}


function getClass( elem ) {
	return elem.getAttribute && elem.getAttribute( "class" ) || "";
}

function classesToArray( value ) {
	if ( Array.isArray( value ) ) {
		return value;
	}
	if ( typeof value === "string" ) {
		return value.match( rnothtmlwhite ) || [];
	}
	return [];
}

jQuery.fn.extend( {
	addClass: function( value ) {
		var classes, elem, cur, curValue, clazz, j, finalValue,
			i = 0;

		if ( isFunction( value ) ) {
			return this.each( function( j ) {
				jQuery( this ).addClass( value.call( this, j, getClass( this ) ) );
			} );
		}

		classes = classesToArray( value );

		if ( classes.length ) {
			while ( ( elem = this[ i++ ] ) ) {
				curValue = getClass( elem );
				cur = elem.nodeType === 1 && ( " " + stripAndCollapse( curValue ) + " " );

				if ( cur ) {
					j = 0;
					while ( ( clazz = classes[ j++ ] ) ) {
						if ( cur.indexOf( " " + clazz + " " ) < 0 ) {
							cur += clazz + " ";
						}
					}

					// Only assign if different to avoid unneeded rendering.
					finalValue = stripAndCollapse( cur );
					if ( curValue !== finalValue ) {
						elem.setAttribute( "class", finalValue );
					}
				}
			}
		}

		return this;
	},

	removeClass: function( value ) {
		var classes, elem, cur, curValue, clazz, j, finalValue,
			i = 0;

		if ( isFunction( value ) ) {
			return this.each( function( j ) {
				jQuery( this ).removeClass( value.call( this, j, getClass( this ) ) );
			} );
		}

		if ( !arguments.length ) {
			return this.attr( "class", "" );
		}

		classes = classesToArray( value );

		if ( classes.length ) {
			while ( ( elem = this[ i++ ] ) ) {
				curValue = getClass( elem );

				// This expression is here for better compressibility (see addClass)
				cur = elem.nodeType === 1 && ( " " + stripAndCollapse( curValue ) + " " );

				if ( cur ) {
					j = 0;
					while ( ( clazz = classes[ j++ ] ) ) {

						// Remove *all* instances
						while ( cur.indexOf( " " + clazz + " " ) > -1 ) {
							cur = cur.replace( " " + clazz + " ", " " );
						}
					}

					// Only assign if different to avoid unneeded rendering.
					finalValue = stripAndCollapse( cur );
					if ( curValue !== finalValue ) {
						elem.setAttribute( "class", finalValue );
					}
				}
			}
		}

		return this;
	},

	toggleClass: function( value, stateVal ) {
		var type = typeof value,
			isValidValue = type === "string" || Array.isArray( value );

		if ( typeof stateVal === "boolean" && isValidValue ) {
			return stateVal ? this.addClass( value ) : this.removeClass( value );
		}

		if ( isFunction( value ) ) {
			return this.each( function( i ) {
				jQuery( this ).toggleClass(
					value.call( this, i, getClass( this ), stateVal ),
					stateVal
				);
			} );
		}

		return this.each( function() {
			var className, i, self, classNames;

			if ( isValidValue ) {

				// Toggle individual class names
				i = 0;
				self = jQuery( this );
				classNames = classesToArray( value );

				while ( ( className = classNames[ i++ ] ) ) {

					// Check each className given, space separated list
					if ( self.hasClass( className ) ) {
						self.removeClass( className );
					} else {
						self.addClass( className );
					}
				}

			// Toggle whole class name
			} else if ( value === undefined || type === "boolean" ) {
				className = getClass( this );
				if ( className ) {

					// Store className if set
					dataPriv.set( this, "__className__", className );
				}

				// If the element has a class name or if we're passed `false`,
				// then remove the whole classname (if there was one, the above saved it).
				// Otherwise bring back whatever was previously saved (if anything),
				// falling back to the empty string if nothing was stored.
				if ( this.setAttribute ) {
					this.setAttribute( "class",
						className || value === false ?
							"" :
							dataPriv.get( this, "__className__" ) || ""
					);
				}
			}
		} );
	},

	hasClass: function( selector ) {
		var className, elem,
			i = 0;

		className = " " + selector + " ";
		while ( ( elem = this[ i++ ] ) ) {
			if ( elem.nodeType === 1 &&
				( " " + stripAndCollapse( getClass( elem ) ) + " " ).indexOf( className ) > -1 ) {
				return true;
			}
		}

		return false;
	}
} );




var rreturn = /\r/g;

jQuery.fn.extend( {
	val: function( value ) {
		var hooks, ret, valueIsFunction,
			elem = this[ 0 ];

		if ( !arguments.length ) {
			if ( elem ) {
				hooks = jQuery.valHooks[ elem.type ] ||
					jQuery.valHooks[ elem.nodeName.toLowerCase() ];

				if ( hooks &&
					"get" in hooks &&
					( ret = hooks.get( elem, "value" ) ) !== undefined
				) {
					return ret;
				}

				ret = elem.value;

				// Handle most common string cases
				if ( typeof ret === "string" ) {
					return ret.replace( rreturn, "" );
				}

				// Handle cases where value is null/undef or number
				return ret == null ? "" : ret;
			}

			return;
		}

		valueIsFunction = isFunction( value );

		return this.each( function( i ) {
			var val;

			if ( this.nodeType !== 1 ) {
				return;
			}

			if ( valueIsFunction ) {
				val = value.call( this, i, jQuery( this ).val() );
			} else {
				val = value;
			}

			// Treat null/undefined as ""; convert numbers to string
			if ( val == null ) {
				val = "";

			} else if ( typeof val === "number" ) {
				val += "";

			} else if ( Array.isArray( val ) ) {
				val = jQuery.map( val, function( value ) {
					return value == null ? "" : value + "";
				} );
			}

			hooks = jQuery.valHooks[ this.type ] || jQuery.valHooks[ this.nodeName.toLowerCase() ];

			// If set returns undefined, fall back to normal setting
			if ( !hooks || !( "set" in hooks ) || hooks.set( this, val, "value" ) === undefined ) {
				this.value = val;
			}
		} );
	}
} );

jQuery.extend( {
	valHooks: {
		option: {
			get: function( elem ) {

				var val = jQuery.find.attr( elem, "value" );
				return val != null ?
					val :

					// Support: IE <=10 - 11 only
					// option.text throws exceptions (#14686, #14858)
					// Strip and collapse whitespace
					// https://html.spec.whatwg.org/#strip-and-collapse-whitespace
					stripAndCollapse( jQuery.text( elem ) );
			}
		},
		select: {
			get: function( elem ) {
				var value, option, i,
					options = elem.options,
					index = elem.selectedIndex,
					one = elem.type === "select-one",
					values = one ? null : [],
					max = one ? index + 1 : options.length;

				if ( index < 0 ) {
					i = max;

				} else {
					i = one ? index : 0;
				}

				// Loop through all the selected options
				for ( ; i < max; i++ ) {
					option = options[ i ];

					// Support: IE <=9 only
					// IE8-9 doesn't update selected after form reset (#2551)
					if ( ( option.selected || i === index ) &&

							// Don't return options that are disabled or in a disabled optgroup
							!option.disabled &&
							( !option.parentNode.disabled ||
								!nodeName( option.parentNode, "optgroup" ) ) ) {

						// Get the specific value for the option
						value = jQuery( option ).val();

						// We don't need an array for one selects
						if ( one ) {
							return value;
						}

						// Multi-Selects return an array
						values.push( value );
					}
				}

				return values;
			},

			set: function( elem, value ) {
				var optionSet, option,
					options = elem.options,
					values = jQuery.makeArray( value ),
					i = options.length;

				while ( i-- ) {
					option = options[ i ];

					/* eslint-disable no-cond-assign */

					if ( option.selected =
						jQuery.inArray( jQuery.valHooks.option.get( option ), values ) > -1
					) {
						optionSet = true;
					}

					/* eslint-enable no-cond-assign */
				}

				// Force browsers to behave consistently when non-matching value is set
				if ( !optionSet ) {
					elem.selectedIndex = -1;
				}
				return values;
			}
		}
	}
} );

// Radios and checkboxes getter/setter
jQuery.each( [ "radio", "checkbox" ], function() {
	jQuery.valHooks[ this ] = {
		set: function( elem, value ) {
			if ( Array.isArray( value ) ) {
				return ( elem.checked = jQuery.inArray( jQuery( elem ).val(), value ) > -1 );
			}
		}
	};
	if ( !support.checkOn ) {
		jQuery.valHooks[ this ].get = function( elem ) {
			return elem.getAttribute( "value" ) === null ? "on" : elem.value;
		};
	}
} );




// Return jQuery for attributes-only inclusion


support.focusin = "onfocusin" in window;


var rfocusMorph = /^(?:focusinfocus|focusoutblur)$/,
	stopPropagationCallback = function( e ) {
		e.stopPropagation();
	};

jQuery.extend( jQuery.event, {

	trigger: function( event, data, elem, onlyHandlers ) {

		var i, cur, tmp, bubbleType, ontype, handle, special, lastElement,
			eventPath = [ elem || document ],
			type = hasOwn.call( event, "type" ) ? event.type : event,
			namespaces = hasOwn.call( event, "namespace" ) ? event.namespace.split( "." ) : [];

		cur = lastElement = tmp = elem = elem || document;

		// Don't do events on text and comment nodes
		if ( elem.nodeType === 3 || elem.nodeType === 8 ) {
			return;
		}

		// focus/blur morphs to focusin/out; ensure we're not firing them right now
		if ( rfocusMorph.test( type + jQuery.event.triggered ) ) {
			return;
		}

		if ( type.indexOf( "." ) > -1 ) {

			// Namespaced trigger; create a regexp to match event type in handle()
			namespaces = type.split( "." );
			type = namespaces.shift();
			namespaces.sort();
		}
		ontype = type.indexOf( ":" ) < 0 && "on" + type;

		// Caller can pass in a jQuery.Event object, Object, or just an event type string
		event = event[ jQuery.expando ] ?
			event :
			new jQuery.Event( type, typeof event === "object" && event );

		// Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)
		event.isTrigger = onlyHandlers ? 2 : 3;
		event.namespace = namespaces.join( "." );
		event.rnamespace = event.namespace ?
			new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" ) :
			null;

		// Clean up the event in case it is being reused
		event.result = undefined;
		if ( !event.target ) {
			event.target = elem;
		}

		// Clone any incoming data and prepend the event, creating the handler arg list
		data = data == null ?
			[ event ] :
			jQuery.makeArray( data, [ event ] );

		// Allow special events to draw outside the lines
		special = jQuery.event.special[ type ] || {};
		if ( !onlyHandlers && special.trigger && special.trigger.apply( elem, data ) === false ) {
			return;
		}

		// Determine event propagation path in advance, per W3C events spec (#9951)
		// Bubble up to document, then to window; watch for a global ownerDocument var (#9724)
		if ( !onlyHandlers && !special.noBubble && !isWindow( elem ) ) {

			bubbleType = special.delegateType || type;
			if ( !rfocusMorph.test( bubbleType + type ) ) {
				cur = cur.parentNode;
			}
			for ( ; cur; cur = cur.parentNode ) {
				eventPath.push( cur );
				tmp = cur;
			}

			// Only add window if we got to document (e.g., not plain obj or detached DOM)
			if ( tmp === ( elem.ownerDocument || document ) ) {
				eventPath.push( tmp.defaultView || tmp.parentWindow || window );
			}
		}

		// Fire handlers on the event path
		i = 0;
		while ( ( cur = eventPath[ i++ ] ) && !event.isPropagationStopped() ) {
			lastElement = cur;
			event.type = i > 1 ?
				bubbleType :
				special.bindType || type;

			// jQuery handler
			handle = ( dataPriv.get( cur, "events" ) || Object.create( null ) )[ event.type ] &&
				dataPriv.get( cur, "handle" );
			if ( handle ) {
				handle.apply( cur, data );
			}

			// Native handler
			handle = ontype && cur[ ontype ];
			if ( handle && handle.apply && acceptData( cur ) ) {
				event.result = handle.apply( cur, data );
				if ( event.result === false ) {
					event.preventDefault();
				}
			}
		}
		event.type = type;

		// If nobody prevented the default action, do it now
		if ( !onlyHandlers && !event.isDefaultPrevented() ) {

			if ( ( !special._default ||
				special._default.apply( eventPath.pop(), data ) === false ) &&
				acceptData( elem ) ) {

				// Call a native DOM method on the target with the same name as the event.
				// Don't do default actions on window, that's where global variables be (#6170)
				if ( ontype && isFunction( elem[ type ] ) && !isWindow( elem ) ) {

					// Don't re-trigger an onFOO event when we call its FOO() method
					tmp = elem[ ontype ];

					if ( tmp ) {
						elem[ ontype ] = null;
					}

					// Prevent re-triggering of the same event, since we already bubbled it above
					jQuery.event.triggered = type;

					if ( event.isPropagationStopped() ) {
						lastElement.addEventListener( type, stopPropagationCallback );
					}

					elem[ type ]();

					if ( event.isPropagationStopped() ) {
						lastElement.removeEventListener( type, stopPropagationCallback );
					}

					jQuery.event.triggered = undefined;

					if ( tmp ) {
						elem[ ontype ] = tmp;
					}
				}
			}
		}

		return event.result;
	},

	// Piggyback on a donor event to simulate a different one
	// Used only for `focus(in | out)` events
	simulate: function( type, elem, event ) {
		var e = jQuery.extend(
			new jQuery.Event(),
			event,
			{
				type: type,
				isSimulated: true
			}
		);

		jQuery.event.trigger( e, null, elem );
	}

} );

jQuery.fn.extend( {

	trigger: function( type, data ) {
		return this.each( function() {
			jQuery.event.trigger( type, data, this );
		} );
	},
	triggerHandler: function( type, data ) {
		var elem = this[ 0 ];
		if ( elem ) {
			return jQuery.event.trigger( type, data, elem, true );
		}
	}
} );


// Support: Firefox <=44
// Firefox doesn't have focus(in | out) events
// Related ticket - https://bugzilla.mozilla.org/show_bug.cgi?id=687787
//
// Support: Chrome <=48 - 49, Safari <=9.0 - 9.1
// focus(in | out) events fire after focus & blur events,
// which is spec violation - http://www.w3.org/TR/DOM-Level-3-Events/#events-focusevent-event-order
// Related ticket - https://bugs.chromium.org/p/chromium/issues/detail?id=449857
if ( !support.focusin ) {
	jQuery.each( { focus: "focusin", blur: "focusout" }, function( orig, fix ) {

		// Attach a single capturing handler on the document while someone wants focusin/focusout
		var handler = function( event ) {
			jQuery.event.simulate( fix, event.target, jQuery.event.fix( event ) );
		};

		jQuery.event.special[ fix ] = {
			setup: function() {

				// Handle: regular nodes (via `this.ownerDocument`), window
				// (via `this.document`) & document (via `this`).
				var doc = this.ownerDocument || this.document || this,
					attaches = dataPriv.access( doc, fix );

				if ( !attaches ) {
					doc.addEventListener( orig, handler, true );
				}
				dataPriv.access( doc, fix, ( attaches || 0 ) + 1 );
			},
			teardown: function() {
				var doc = this.ownerDocument || this.document || this,
					attaches = dataPriv.access( doc, fix ) - 1;

				if ( !attaches ) {
					doc.removeEventListener( orig, handler, true );
					dataPriv.remove( doc, fix );

				} else {
					dataPriv.access( doc, fix, attaches );
				}
			}
		};
	} );
}
var location = window.location;

var nonce = { guid: Date.now() };

var rquery = ( /\?/ );



// Cross-browser xml parsing
jQuery.parseXML = function( data ) {
	var xml, parserErrorElem;
	if ( !data || typeof data !== "string" ) {
		return null;
	}

	// Support: IE 9 - 11 only
	// IE throws on parseFromString with invalid input.
	try {
		xml = ( new window.DOMParser() ).parseFromString( data, "text/xml" );
	} catch ( e ) {}

	parserErrorElem = xml && xml.getElementsByTagName( "parsererror" )[ 0 ];
	if ( !xml || parserErrorElem ) {
		jQuery.error( "Invalid XML: " + (
			parserErrorElem ?
				jQuery.map( parserErrorElem.childNodes, function( el ) {
					return el.textContent;
				} ).join( "\n" ) :
				data
		) );
	}
	return xml;
};


var
	rbracket = /\[\]$/,
	rCRLF = /\r?\n/g,
	rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,
	rsubmittable = /^(?:input|select|textarea|keygen)/i;

function buildParams( prefix, obj, traditional, add ) {
	var name;

	if ( Array.isArray( obj ) ) {

		// Serialize array item.
		jQuery.each( obj, function( i, v ) {
			if ( traditional || rbracket.test( prefix ) ) {

				// Treat each array item as a scalar.
				add( prefix, v );

			} else {

				// Item is non-scalar (array or object), encode its numeric index.
				buildParams(
					prefix + "[" + ( typeof v === "object" && v != null ? i : "" ) + "]",
					v,
					traditional,
					add
				);
			}
		} );

	} else if ( !traditional && toType( obj ) === "object" ) {

		// Serialize object item.
		for ( name in obj ) {
			buildParams( prefix + "[" + name + "]", obj[ name ], traditional, add );
		}

	} else {

		// Serialize scalar item.
		add( prefix, obj );
	}
}

// Serialize an array of form elements or a set of
// key/values into a query string
jQuery.param = function( a, traditional ) {
	var prefix,
		s = [],
		add = function( key, valueOrFunction ) {

			// If value is a function, invoke it and use its return value
			var value = isFunction( valueOrFunction ) ?
				valueOrFunction() :
				valueOrFunction;

			s[ s.length ] = encodeURIComponent( key ) + "=" +
				encodeURIComponent( value == null ? "" : value );
		};

	if ( a == null ) {
		return "";
	}

	// If an array was passed in, assume that it is an array of form elements.
	if ( Array.isArray( a ) || ( a.jquery && !jQuery.isPlainObject( a ) ) ) {

		// Serialize the form elements
		jQuery.each( a, function() {
			add( this.name, this.value );
		} );

	} else {

		// If traditional, encode the "old" way (the way 1.3.2 or older
		// did it), otherwise encode params recursively.
		for ( prefix in a ) {
			buildParams( prefix, a[ prefix ], traditional, add );
		}
	}

	// Return the resulting serialization
	return s.join( "&" );
};

jQuery.fn.extend( {
	serialize: function() {
		return jQuery.param( this.serializeArray() );
	},
	serializeArray: function() {
		return this.map( function() {

			// Can add propHook for "elements" to filter or add form elements
			var elements = jQuery.prop( this, "elements" );
			return elements ? jQuery.makeArray( elements ) : this;
		} ).filter( function() {
			var type = this.type;

			// Use .is( ":disabled" ) so that fieldset[disabled] works
			return this.name && !jQuery( this ).is( ":disabled" ) &&
				rsubmittable.test( this.nodeName ) && !rsubmitterTypes.test( type ) &&
				( this.checked || !rcheckableType.test( type ) );
		} ).map( function( _i, elem ) {
			var val = jQuery( this ).val();

			if ( val == null ) {
				return null;
			}

			if ( Array.isArray( val ) ) {
				return jQuery.map( val, function( val ) {
					return { name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
				} );
			}

			return { name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
		} ).get();
	}
} );


var
	r20 = /%20/g,
	rhash = /#.*$/,
	rantiCache = /([?&])_=[^&]*/,
	rheaders = /^(.*?):[ \t]*([^\r\n]*)$/mg,

	// #7653, #8125, #8152: local protocol detection
	rlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/,
	rnoContent = /^(?:GET|HEAD)$/,
	rprotocol = /^\/\//,

	/* Prefilters
	 * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)
	 * 2) These are called:
	 *    - BEFORE asking for a transport
	 *    - AFTER param serialization (s.data is a string if s.processData is true)
	 * 3) key is the dataType
	 * 4) the catchall symbol "*" can be used
	 * 5) execution will start with transport dataType and THEN continue down to "*" if needed
	 */
	prefilters = {},

	/* Transports bindings
	 * 1) key is the dataType
	 * 2) the catchall symbol "*" can be used
	 * 3) selection will start with transport dataType and THEN go to "*" if needed
	 */
	transports = {},

	// Avoid comment-prolog char sequence (#10098); must appease lint and evade compression
	allTypes = "*/".concat( "*" ),

	// Anchor tag for parsing the document origin
	originAnchor = document.createElement( "a" );

originAnchor.href = location.href;

// Base "constructor" for jQuery.ajaxPrefilter and jQuery.ajaxTransport
function addToPrefiltersOrTransports( structure ) {

	// dataTypeExpression is optional and defaults to "*"
	return function( dataTypeExpression, func ) {

		if ( typeof dataTypeExpression !== "string" ) {
			func = dataTypeExpression;
			dataTypeExpression = "*";
		}

		var dataType,
			i = 0,
			dataTypes = dataTypeExpression.toLowerCase().match( rnothtmlwhite ) || [];

		if ( isFunction( func ) ) {

			// For each dataType in the dataTypeExpression
			while ( ( dataType = dataTypes[ i++ ] ) ) {

				// Prepend if requested
				if ( dataType[ 0 ] === "+" ) {
					dataType = dataType.slice( 1 ) || "*";
					( structure[ dataType ] = structure[ dataType ] || [] ).unshift( func );

				// Otherwise append
				} else {
					( structure[ dataType ] = structure[ dataType ] || [] ).push( func );
				}
			}
		}
	};
}

// Base inspection function for prefilters and transports
function inspectPrefiltersOrTransports( structure, options, originalOptions, jqXHR ) {

	var inspected = {},
		seekingTransport = ( structure === transports );

	function inspect( dataType ) {
		var selected;
		inspected[ dataType ] = true;
		jQuery.each( structure[ dataType ] || [], function( _, prefilterOrFactory ) {
			var dataTypeOrTransport = prefilterOrFactory( options, originalOptions, jqXHR );
			if ( typeof dataTypeOrTransport === "string" &&
				!seekingTransport && !inspected[ dataTypeOrTransport ] ) {

				options.dataTypes.unshift( dataTypeOrTransport );
				inspect( dataTypeOrTransport );
				return false;
			} else if ( seekingTransport ) {
				return !( selected = dataTypeOrTransport );
			}
		} );
		return selected;
	}

	return inspect( options.dataTypes[ 0 ] ) || !inspected[ "*" ] && inspect( "*" );
}

// A special extend for ajax options
// that takes "flat" options (not to be deep extended)
// Fixes #9887
function ajaxExtend( target, src ) {
	var key, deep,
		flatOptions = jQuery.ajaxSettings.flatOptions || {};

	for ( key in src ) {
		if ( src[ key ] !== undefined ) {
			( flatOptions[ key ] ? target : ( deep || ( deep = {} ) ) )[ key ] = src[ key ];
		}
	}
	if ( deep ) {
		jQuery.extend( true, target, deep );
	}

	return target;
}

/* Handles responses to an ajax request:
 * - finds the right dataType (mediates between content-type and expected dataType)
 * - returns the corresponding response
 */
function ajaxHandleResponses( s, jqXHR, responses ) {

	var ct, type, finalDataType, firstDataType,
		contents = s.contents,
		dataTypes = s.dataTypes;

	// Remove auto dataType and get content-type in the process
	while ( dataTypes[ 0 ] === "*" ) {
		dataTypes.shift();
		if ( ct === undefined ) {
			ct = s.mimeType || jqXHR.getResponseHeader( "Content-Type" );
		}
	}

	// Check if we're dealing with a known content-type
	if ( ct ) {
		for ( type in contents ) {
			if ( contents[ type ] && contents[ type ].test( ct ) ) {
				dataTypes.unshift( type );
				break;
			}
		}
	}

	// Check to see if we have a response for the expected dataType
	if ( dataTypes[ 0 ] in responses ) {
		finalDataType = dataTypes[ 0 ];
	} else {

		// Try convertible dataTypes
		for ( type in responses ) {
			if ( !dataTypes[ 0 ] || s.converters[ type + " " + dataTypes[ 0 ] ] ) {
				finalDataType = type;
				break;
			}
			if ( !firstDataType ) {
				firstDataType = type;
			}
		}

		// Or just use first one
		finalDataType = finalDataType || firstDataType;
	}

	// If we found a dataType
	// We add the dataType to the list if needed
	// and return the corresponding response
	if ( finalDataType ) {
		if ( finalDataType !== dataTypes[ 0 ] ) {
			dataTypes.unshift( finalDataType );
		}
		return responses[ finalDataType ];
	}
}

/* Chain conversions given the request and the original response
 * Also sets the responseXXX fields on the jqXHR instance
 */
function ajaxConvert( s, response, jqXHR, isSuccess ) {
	var conv2, current, conv, tmp, prev,
		converters = {},

		// Work with a copy of dataTypes in case we need to modify it for conversion
		dataTypes = s.dataTypes.slice();

	// Create converters map with lowercased keys
	if ( dataTypes[ 1 ] ) {
		for ( conv in s.converters ) {
			converters[ conv.toLowerCase() ] = s.converters[ conv ];
		}
	}

	current = dataTypes.shift();

	// Convert to each sequential dataType
	while ( current ) {

		if ( s.responseFields[ current ] ) {
			jqXHR[ s.responseFields[ current ] ] = response;
		}

		// Apply the dataFilter if provided
		if ( !prev && isSuccess && s.dataFilter ) {
			response = s.dataFilter( response, s.dataType );
		}

		prev = current;
		current = dataTypes.shift();

		if ( current ) {

			// There's only work to do if current dataType is non-auto
			if ( current === "*" ) {

				current = prev;

			// Convert response if prev dataType is non-auto and differs from current
			} else if ( prev !== "*" && prev !== current ) {

				// Seek a direct converter
				conv = converters[ prev + " " + current ] || converters[ "* " + current ];

				// If none found, seek a pair
				if ( !conv ) {
					for ( conv2 in converters ) {

						// If conv2 outputs current
						tmp = conv2.split( " " );
						if ( tmp[ 1 ] === current ) {

							// If prev can be converted to accepted input
							conv = converters[ prev + " " + tmp[ 0 ] ] ||
								converters[ "* " + tmp[ 0 ] ];
							if ( conv ) {

								// Condense equivalence converters
								if ( conv === true ) {
									conv = converters[ conv2 ];

								// Otherwise, insert the intermediate dataType
								} else if ( converters[ conv2 ] !== true ) {
									current = tmp[ 0 ];
									dataTypes.unshift( tmp[ 1 ] );
								}
								break;
							}
						}
					}
				}

				// Apply converter (if not an equivalence)
				if ( conv !== true ) {

					// Unless errors are allowed to bubble, catch and return them
					if ( conv && s.throws ) {
						response = conv( response );
					} else {
						try {
							response = conv( response );
						} catch ( e ) {
							return {
								state: "parsererror",
								error: conv ? e : "No conversion from " + prev + " to " + current
							};
						}
					}
				}
			}
		}
	}

	return { state: "success", data: response };
}

jQuery.extend( {

	// Counter for holding the number of active queries
	active: 0,

	// Last-Modified header cache for next request
	lastModified: {},
	etag: {},

	ajaxSettings: {
		url: location.href,
		type: "GET",
		isLocal: rlocalProtocol.test( location.protocol ),
		global: true,
		processData: true,
		async: true,
		contentType: "application/x-www-form-urlencoded; charset=UTF-8",

		/*
		timeout: 0,
		data: null,
		dataType: null,
		username: null,
		password: null,
		cache: null,
		throws: false,
		traditional: false,
		headers: {},
		*/

		accepts: {
			"*": allTypes,
			text: "text/plain",
			html: "text/html",
			xml: "application/xml, text/xml",
			json: "application/json, text/javascript"
		},

		contents: {
			xml: /\bxml\b/,
			html: /\bhtml/,
			json: /\bjson\b/
		},

		responseFields: {
			xml: "responseXML",
			text: "responseText",
			json: "responseJSON"
		},

		// Data converters
		// Keys separate source (or catchall "*") and destination types with a single space
		converters: {

			// Convert anything to text
			"* text": String,

			// Text to html (true = no transformation)
			"text html": true,

			// Evaluate text as a json expression
			"text json": JSON.parse,

			// Parse text as xml
			"text xml": jQuery.parseXML
		},

		// For options that shouldn't be deep extended:
		// you can add your own custom options here if
		// and when you create one that shouldn't be
		// deep extended (see ajaxExtend)
		flatOptions: {
			url: true,
			context: true
		}
	},

	// Creates a full fledged settings object into target
	// with both ajaxSettings and settings fields.
	// If target is omitted, writes into ajaxSettings.
	ajaxSetup: function( target, settings ) {
		return settings ?

			// Building a settings object
			ajaxExtend( ajaxExtend( target, jQuery.ajaxSettings ), settings ) :

			// Extending ajaxSettings
			ajaxExtend( jQuery.ajaxSettings, target );
	},

	ajaxPrefilter: addToPrefiltersOrTransports( prefilters ),
	ajaxTransport: addToPrefiltersOrTransports( transports ),

	// Main method
	ajax: function( url, options ) {

		// If url is an object, simulate pre-1.5 signature
		if ( typeof url === "object" ) {
			options = url;
			url = undefined;
		}

		// Force options to be an object
		options = options || {};

		var transport,

			// URL without anti-cache param
			cacheURL,

			// Response headers
			responseHeadersString,
			responseHeaders,

			// timeout handle
			timeoutTimer,

			// Url cleanup var
			urlAnchor,

			// Request state (becomes false upon send and true upon completion)
			completed,

			// To know if global events are to be dispatched
			fireGlobals,

			// Loop variable
			i,

			// uncached part of the url
			uncached,

			// Create the final options object
			s = jQuery.ajaxSetup( {}, options ),

			// Callbacks context
			callbackContext = s.context || s,

			// Context for global events is callbackContext if it is a DOM node or jQuery collection
			globalEventContext = s.context &&
				( callbackContext.nodeType || callbackContext.jquery ) ?
				jQuery( callbackContext ) :
				jQuery.event,

			// Deferreds
			deferred = jQuery.Deferred(),
			completeDeferred = jQuery.Callbacks( "once memory" ),

			// Status-dependent callbacks
			statusCode = s.statusCode || {},

			// Headers (they are sent all at once)
			requestHeaders = {},
			requestHeadersNames = {},

			// Default abort message
			strAbort = "canceled",

			// Fake xhr
			jqXHR = {
				readyState: 0,

				// Builds headers hashtable if needed
				getResponseHeader: function( key ) {
					var match;
					if ( completed ) {
						if ( !responseHeaders ) {
							responseHeaders = {};
							while ( ( match = rheaders.exec( responseHeadersString ) ) ) {
								responseHeaders[ match[ 1 ].toLowerCase() + " " ] =
									( responseHeaders[ match[ 1 ].toLowerCase() + " " ] || [] )
										.concat( match[ 2 ] );
							}
						}
						match = responseHeaders[ key.toLowerCase() + " " ];
					}
					return match == null ? null : match.join( ", " );
				},

				// Raw string
				getAllResponseHeaders: function() {
					return completed ? responseHeadersString : null;
				},

				// Caches the header
				setRequestHeader: function( name, value ) {
					if ( completed == null ) {
						name = requestHeadersNames[ name.toLowerCase() ] =
							requestHeadersNames[ name.toLowerCase() ] || name;
						requestHeaders[ name ] = value;
					}
					return this;
				},

				// Overrides response content-type header
				overrideMimeType: function( type ) {
					if ( completed == null ) {
						s.mimeType = type;
					}
					return this;
				},

				// Status-dependent callbacks
				statusCode: function( map ) {
					var code;
					if ( map ) {
						if ( completed ) {

							// Execute the appropriate callbacks
							jqXHR.always( map[ jqXHR.status ] );
						} else {

							// Lazy-add the new callbacks in a way that preserves old ones
							for ( code in map ) {
								statusCode[ code ] = [ statusCode[ code ], map[ code ] ];
							}
						}
					}
					return this;
				},

				// Cancel the request
				abort: function( statusText ) {
					var finalText = statusText || strAbort;
					if ( transport ) {
						transport.abort( finalText );
					}
					done( 0, finalText );
					return this;
				}
			};

		// Attach deferreds
		deferred.promise( jqXHR );

		// Add protocol if not provided (prefilters might expect it)
		// Handle falsy url in the settings object (#10093: consistency with old signature)
		// We also use the url parameter if available
		s.url = ( ( url || s.url || location.href ) + "" )
			.replace( rprotocol, location.protocol + "//" );

		// Alias method option to type as per ticket #12004
		s.type = options.method || options.type || s.method || s.type;

		// Extract dataTypes list
		s.dataTypes = ( s.dataType || "*" ).toLowerCase().match( rnothtmlwhite ) || [ "" ];

		// A cross-domain request is in order when the origin doesn't match the current origin.
		if ( s.crossDomain == null ) {
			urlAnchor = document.createElement( "a" );

			// Support: IE <=8 - 11, Edge 12 - 15
			// IE throws exception on accessing the href property if url is malformed,
			// e.g. http://example.com:80x/
			try {
				urlAnchor.href = s.url;

				// Support: IE <=8 - 11 only
				// Anchor's host property isn't correctly set when s.url is relative
				urlAnchor.href = urlAnchor.href;
				s.crossDomain = originAnchor.protocol + "//" + originAnchor.host !==
					urlAnchor.protocol + "//" + urlAnchor.host;
			} catch ( e ) {

				// If there is an error parsing the URL, assume it is crossDomain,
				// it can be rejected by the transport if it is invalid
				s.crossDomain = true;
			}
		}

		// Convert data if not already a string
		if ( s.data && s.processData && typeof s.data !== "string" ) {
			s.data = jQuery.param( s.data, s.traditional );
		}

		// Apply prefilters
		inspectPrefiltersOrTransports( prefilters, s, options, jqXHR );

		// If request was aborted inside a prefilter, stop there
		if ( completed ) {
			return jqXHR;
		}

		// We can fire global events as of now if asked to
		// Don't fire events if jQuery.event is undefined in an AMD-usage scenario (#15118)
		fireGlobals = jQuery.event && s.global;

		// Watch for a new set of requests
		if ( fireGlobals && jQuery.active++ === 0 ) {
			jQuery.event.trigger( "ajaxStart" );
		}

		// Uppercase the type
		s.type = s.type.toUpperCase();

		// Determine if request has content
		s.hasContent = !rnoContent.test( s.type );

		// Save the URL in case we're toying with the If-Modified-Since
		// and/or If-None-Match header later on
		// Remove hash to simplify url manipulation
		cacheURL = s.url.replace( rhash, "" );

		// More options handling for requests with no content
		if ( !s.hasContent ) {

			// Remember the hash so we can put it back
			uncached = s.url.slice( cacheURL.length );

			// If data is available and should be processed, append data to url
			if ( s.data && ( s.processData || typeof s.data === "string" ) ) {
				cacheURL += ( rquery.test( cacheURL ) ? "&" : "?" ) + s.data;

				// #9682: remove data so that it's not used in an eventual retry
				delete s.data;
			}

			// Add or update anti-cache param if needed
			if ( s.cache === false ) {
				cacheURL = cacheURL.replace( rantiCache, "$1" );
				uncached = ( rquery.test( cacheURL ) ? "&" : "?" ) + "_=" + ( nonce.guid++ ) +
					uncached;
			}

			// Put hash and anti-cache on the URL that will be requested (gh-1732)
			s.url = cacheURL + uncached;

		// Change '%20' to '+' if this is encoded form body content (gh-2658)
		} else if ( s.data && s.processData &&
			( s.contentType || "" ).indexOf( "application/x-www-form-urlencoded" ) === 0 ) {
			s.data = s.data.replace( r20, "+" );
		}

		// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
		if ( s.ifModified ) {
			if ( jQuery.lastModified[ cacheURL ] ) {
				jqXHR.setRequestHeader( "If-Modified-Since", jQuery.lastModified[ cacheURL ] );
			}
			if ( jQuery.etag[ cacheURL ] ) {
				jqXHR.setRequestHeader( "If-None-Match", jQuery.etag[ cacheURL ] );
			}
		}

		// Set the correct header, if data is being sent
		if ( s.data && s.hasContent && s.contentType !== false || options.contentType ) {
			jqXHR.setRequestHeader( "Content-Type", s.contentType );
		}

		// Set the Accepts header for the server, depending on the dataType
		jqXHR.setRequestHeader(
			"Accept",
			s.dataTypes[ 0 ] && s.accepts[ s.dataTypes[ 0 ] ] ?
				s.accepts[ s.dataTypes[ 0 ] ] +
					( s.dataTypes[ 0 ] !== "*" ? ", " + allTypes + "; q=0.01" : "" ) :
				s.accepts[ "*" ]
		);

		// Check for headers option
		for ( i in s.headers ) {
			jqXHR.setRequestHeader( i, s.headers[ i ] );
		}

		// Allow custom headers/mimetypes and early abort
		if ( s.beforeSend &&
			( s.beforeSend.call( callbackContext, jqXHR, s ) === false || completed ) ) {

			// Abort if not done already and return
			return jqXHR.abort();
		}

		// Aborting is no longer a cancellation
		strAbort = "abort";

		// Install callbacks on deferreds
		completeDeferred.add( s.complete );
		jqXHR.done( s.success );
		jqXHR.fail( s.error );

		// Get transport
		transport = inspectPrefiltersOrTransports( transports, s, options, jqXHR );

		// If no transport, we auto-abort
		if ( !transport ) {
			done( -1, "No Transport" );
		} else {
			jqXHR.readyState = 1;

			// Send global event
			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxSend", [ jqXHR, s ] );
			}

			// If request was aborted inside ajaxSend, stop there
			if ( completed ) {
				return jqXHR;
			}

			// Timeout
			if ( s.async && s.timeout > 0 ) {
				timeoutTimer = window.setTimeout( function() {
					jqXHR.abort( "timeout" );
				}, s.timeout );
			}

			try {
				completed = false;
				transport.send( requestHeaders, done );
			} catch ( e ) {

				// Rethrow post-completion exceptions
				if ( completed ) {
					throw e;
				}

				// Propagate others as results
				done( -1, e );
			}
		}

		// Callback for when everything is done
		function done( status, nativeStatusText, responses, headers ) {
			var isSuccess, success, error, response, modified,
				statusText = nativeStatusText;

			// Ignore repeat invocations
			if ( completed ) {
				return;
			}

			completed = true;

			// Clear timeout if it exists
			if ( timeoutTimer ) {
				window.clearTimeout( timeoutTimer );
			}

			// Dereference transport for early garbage collection
			// (no matter how long the jqXHR object will be used)
			transport = undefined;

			// Cache response headers
			responseHeadersString = headers || "";

			// Set readyState
			jqXHR.readyState = status > 0 ? 4 : 0;

			// Determine if successful
			isSuccess = status >= 200 && status < 300 || status === 304;

			// Get response data
			if ( responses ) {
				response = ajaxHandleResponses( s, jqXHR, responses );
			}

			// Use a noop converter for missing script but not if jsonp
			if ( !isSuccess &&
				jQuery.inArray( "script", s.dataTypes ) > -1 &&
				jQuery.inArray( "json", s.dataTypes ) < 0 ) {
				s.converters[ "text script" ] = function() {};
			}

			// Convert no matter what (that way responseXXX fields are always set)
			response = ajaxConvert( s, response, jqXHR, isSuccess );

			// If successful, handle type chaining
			if ( isSuccess ) {

				// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
				if ( s.ifModified ) {
					modified = jqXHR.getResponseHeader( "Last-Modified" );
					if ( modified ) {
						jQuery.lastModified[ cacheURL ] = modified;
					}
					modified = jqXHR.getResponseHeader( "etag" );
					if ( modified ) {
						jQuery.etag[ cacheURL ] = modified;
					}
				}

				// if no content
				if ( status === 204 || s.type === "HEAD" ) {
					statusText = "nocontent";

				// if not modified
				} else if ( status === 304 ) {
					statusText = "notmodified";

				// If we have data, let's convert it
				} else {
					statusText = response.state;
					success = response.data;
					error = response.error;
					isSuccess = !error;
				}
			} else {

				// Extract error from statusText and normalize for non-aborts
				error = statusText;
				if ( status || !statusText ) {
					statusText = "error";
					if ( status < 0 ) {
						status = 0;
					}
				}
			}

			// Set data for the fake xhr object
			jqXHR.status = status;
			jqXHR.statusText = ( nativeStatusText || statusText ) + "";

			// Success/Error
			if ( isSuccess ) {
				deferred.resolveWith( callbackContext, [ success, statusText, jqXHR ] );
			} else {
				deferred.rejectWith( callbackContext, [ jqXHR, statusText, error ] );
			}

			// Status-dependent callbacks
			jqXHR.statusCode( statusCode );
			statusCode = undefined;

			if ( fireGlobals ) {
				globalEventContext.trigger( isSuccess ? "ajaxSuccess" : "ajaxError",
					[ jqXHR, s, isSuccess ? success : error ] );
			}

			// Complete
			completeDeferred.fireWith( callbackContext, [ jqXHR, statusText ] );

			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxComplete", [ jqXHR, s ] );

				// Handle the global AJAX counter
				if ( !( --jQuery.active ) ) {
					jQuery.event.trigger( "ajaxStop" );
				}
			}
		}

		return jqXHR;
	},

	getJSON: function( url, data, callback ) {
		return jQuery.get( url, data, callback, "json" );
	},

	getScript: function( url, callback ) {
		return jQuery.get( url, undefined, callback, "script" );
	}
} );

jQuery.each( [ "get", "post" ], function( _i, method ) {
	jQuery[ method ] = function( url, data, callback, type ) {

		// Shift arguments if data argument was omitted
		if ( isFunction( data ) ) {
			type = type || callback;
			callback = data;
			data = undefined;
		}

		// The url can be an options object (which then must have .url)
		return jQuery.ajax( jQuery.extend( {
			url: url,
			type: method,
			dataType: type,
			data: data,
			success: callback
		}, jQuery.isPlainObject( url ) && url ) );
	};
} );

jQuery.ajaxPrefilter( function( s ) {
	var i;
	for ( i in s.headers ) {
		if ( i.toLowerCase() === "content-type" ) {
			s.contentType = s.headers[ i ] || "";
		}
	}
} );


jQuery._evalUrl = function( url, options, doc ) {
	return jQuery.ajax( {
		url: url,

		// Make this explicit, since user can override this through ajaxSetup (#11264)
		type: "GET",
		dataType: "script",
		cache: true,
		async: false,
		global: false,

		// Only evaluate the response if it is successful (gh-4126)
		// dataFilter is not invoked for failure responses, so using it instead
		// of the default converter is kludgy but it works.
		converters: {
			"text script": function() {}
		},
		dataFilter: function( response ) {
			jQuery.globalEval( response, options, doc );
		}
	} );
};


jQuery.fn.extend( {
	wrapAll: function( html ) {
		var wrap;

		if ( this[ 0 ] ) {
			if ( isFunction( html ) ) {
				html = html.call( this[ 0 ] );
			}

			// The elements to wrap the target around
			wrap = jQuery( html, this[ 0 ].ownerDocument ).eq( 0 ).clone( true );

			if ( this[ 0 ].parentNode ) {
				wrap.insertBefore( this[ 0 ] );
			}

			wrap.map( function() {
				var elem = this;

				while ( elem.firstElementChild ) {
					elem = elem.firstElementChild;
				}

				return elem;
			} ).append( this );
		}

		return this;
	},

	wrapInner: function( html ) {
		if ( isFunction( html ) ) {
			return this.each( function( i ) {
				jQuery( this ).wrapInner( html.call( this, i ) );
			} );
		}

		return this.each( function() {
			var self = jQuery( this ),
				contents = self.contents();

			if ( contents.length ) {
				contents.wrapAll( html );

			} else {
				self.append( html );
			}
		} );
	},

	wrap: function( html ) {
		var htmlIsFunction = isFunction( html );

		return this.each( function( i ) {
			jQuery( this ).wrapAll( htmlIsFunction ? html.call( this, i ) : html );
		} );
	},

	unwrap: function( selector ) {
		this.parent( selector ).not( "body" ).each( function() {
			jQuery( this ).replaceWith( this.childNodes );
		} );
		return this;
	}
} );


jQuery.expr.pseudos.hidden = function( elem ) {
	return !jQuery.expr.pseudos.visible( elem );
};
jQuery.expr.pseudos.visible = function( elem ) {
	return !!( elem.offsetWidth || elem.offsetHeight || elem.getClientRects().length );
};




jQuery.ajaxSettings.xhr = function() {
	try {
		return new window.XMLHttpRequest();
	} catch ( e ) {}
};

var xhrSuccessStatus = {

		// File protocol always yields status code 0, assume 200
		0: 200,

		// Support: IE <=9 only
		// #1450: sometimes IE returns 1223 when it should be 204
		1223: 204
	},
	xhrSupported = jQuery.ajaxSettings.xhr();

support.cors = !!xhrSupported && ( "withCredentials" in xhrSupported );
support.ajax = xhrSupported = !!xhrSupported;

jQuery.ajaxTransport( function( options ) {
	var callback, errorCallback;

	// Cross domain only allowed if supported through XMLHttpRequest
	if ( support.cors || xhrSupported && !options.crossDomain ) {
		return {
			send: function( headers, complete ) {
				var i,
					xhr = options.xhr();

				xhr.open(
					options.type,
					options.url,
					options.async,
					options.username,
					options.password
				);

				// Apply custom fields if provided
				if ( options.xhrFields ) {
					for ( i in options.xhrFields ) {
						xhr[ i ] = options.xhrFields[ i ];
					}
				}

				// Override mime type if needed
				if ( options.mimeType && xhr.overrideMimeType ) {
					xhr.overrideMimeType( options.mimeType );
				}

				// X-Requested-With header
				// For cross-domain requests, seeing as conditions for a preflight are
				// akin to a jigsaw puzzle, we simply never set it to be sure.
				// (it can always be set on a per-request basis or even using ajaxSetup)
				// For same-domain requests, won't change header if already provided.
				if ( !options.crossDomain && !headers[ "X-Requested-With" ] ) {
					headers[ "X-Requested-With" ] = "XMLHttpRequest";
				}

				// Set headers
				for ( i in headers ) {
					xhr.setRequestHeader( i, headers[ i ] );
				}

				// Callback
				callback = function( type ) {
					return function() {
						if ( callback ) {
							callback = errorCallback = xhr.onload =
								xhr.onerror = xhr.onabort = xhr.ontimeout =
									xhr.onreadystatechange = null;

							if ( type === "abort" ) {
								xhr.abort();
							} else if ( type === "error" ) {

								// Support: IE <=9 only
								// On a manual native abort, IE9 throws
								// errors on any property access that is not readyState
								if ( typeof xhr.status !== "number" ) {
									complete( 0, "error" );
								} else {
									complete(

										// File: protocol always yields status 0; see #8605, #14207
										xhr.status,
										xhr.statusText
									);
								}
							} else {
								complete(
									xhrSuccessStatus[ xhr.status ] || xhr.status,
									xhr.statusText,

									// Support: IE <=9 only
									// IE9 has no XHR2 but throws on binary (trac-11426)
									// For XHR2 non-text, let the caller handle it (gh-2498)
									( xhr.responseType || "text" ) !== "text"  ||
									typeof xhr.responseText !== "string" ?
										{ binary: xhr.response } :
										{ text: xhr.responseText },
									xhr.getAllResponseHeaders()
								);
							}
						}
					};
				};

				// Listen to events
				xhr.onload = callback();
				errorCallback = xhr.onerror = xhr.ontimeout = callback( "error" );

				// Support: IE 9 only
				// Use onreadystatechange to replace onabort
				// to handle uncaught aborts
				if ( xhr.onabort !== undefined ) {
					xhr.onabort = errorCallback;
				} else {
					xhr.onreadystatechange = function() {

						// Check readyState before timeout as it changes
						if ( xhr.readyState === 4 ) {

							// Allow onerror to be called first,
							// but that will not handle a native abort
							// Also, save errorCallback to a variable
							// as xhr.onerror cannot be accessed
							window.setTimeout( function() {
								if ( callback ) {
									errorCallback();
								}
							} );
						}
					};
				}

				// Create the abort callback
				callback = callback( "abort" );

				try {

					// Do send the request (this may raise an exception)
					xhr.send( options.hasContent && options.data || null );
				} catch ( e ) {

					// #14683: Only rethrow if this hasn't been notified as an error yet
					if ( callback ) {
						throw e;
					}
				}
			},

			abort: function() {
				if ( callback ) {
					callback();
				}
			}
		};
	}
} );




// Prevent auto-execution of scripts when no explicit dataType was provided (See gh-2432)
jQuery.ajaxPrefilter( function( s ) {
	if ( s.crossDomain ) {
		s.contents.script = false;
	}
} );

// Install script dataType
jQuery.ajaxSetup( {
	accepts: {
		script: "text/javascript, application/javascript, " +
			"application/ecmascript, application/x-ecmascript"
	},
	contents: {
		script: /\b(?:java|ecma)script\b/
	},
	converters: {
		"text script": function( text ) {
			jQuery.globalEval( text );
			return text;
		}
	}
} );

// Handle cache's special case and crossDomain
jQuery.ajaxPrefilter( "script", function( s ) {
	if ( s.cache === undefined ) {
		s.cache = false;
	}
	if ( s.crossDomain ) {
		s.type = "GET";
	}
} );

// Bind script tag hack transport
jQuery.ajaxTransport( "script", function( s ) {

	// This transport only deals with cross domain or forced-by-attrs requests
	if ( s.crossDomain || s.scriptAttrs ) {
		var script, callback;
		return {
			send: function( _, complete ) {
				script = jQuery( "<script>" )
					.attr( s.scriptAttrs || {} )
					.prop( { charset: s.scriptCharset, src: s.url } )
					.on( "load error", callback = function( evt ) {
						script.remove();
						callback = null;
						if ( evt ) {
							complete( evt.type === "error" ? 404 : 200, evt.type );
						}
					} );

				// Use native DOM manipulation to avoid our domManip AJAX trickery
				document.head.appendChild( script[ 0 ] );
			},
			abort: function() {
				if ( callback ) {
					callback();
				}
			}
		};
	}
} );




var oldCallbacks = [],
	rjsonp = /(=)\?(?=&|$)|\?\?/;

// Default jsonp settings
jQuery.ajaxSetup( {
	jsonp: "callback",
	jsonpCallback: function() {
		var callback = oldCallbacks.pop() || ( jQuery.expando + "_" + ( nonce.guid++ ) );
		this[ callback ] = true;
		return callback;
	}
} );

// Detect, normalize options and install callbacks for jsonp requests
jQuery.ajaxPrefilter( "json jsonp", function( s, originalSettings, jqXHR ) {

	var callbackName, overwritten, responseContainer,
		jsonProp = s.jsonp !== false && ( rjsonp.test( s.url ) ?
			"url" :
			typeof s.data === "string" &&
				( s.contentType || "" )
					.indexOf( "application/x-www-form-urlencoded" ) === 0 &&
				rjsonp.test( s.data ) && "data"
		);

	// Handle iff the expected data type is "jsonp" or we have a parameter to set
	if ( jsonProp || s.dataTypes[ 0 ] === "jsonp" ) {

		// Get callback name, remembering preexisting value associated with it
		callbackName = s.jsonpCallback = isFunction( s.jsonpCallback ) ?
			s.jsonpCallback() :
			s.jsonpCallback;

		// Insert callback into url or form data
		if ( jsonProp ) {
			s[ jsonProp ] = s[ jsonProp ].replace( rjsonp, "$1" + callbackName );
		} else if ( s.jsonp !== false ) {
			s.url += ( rquery.test( s.url ) ? "&" : "?" ) + s.jsonp + "=" + callbackName;
		}

		// Use data converter to retrieve json after script execution
		s.converters[ "script json" ] = function() {
			if ( !responseContainer ) {
				jQuery.error( callbackName + " was not called" );
			}
			return responseContainer[ 0 ];
		};

		// Force json dataType
		s.dataTypes[ 0 ] = "json";

		// Install callback
		overwritten = window[ callbackName ];
		window[ callbackName ] = function() {
			responseContainer = arguments;
		};

		// Clean-up function (fires after converters)
		jqXHR.always( function() {

			// If previous value didn't exist - remove it
			if ( overwritten === undefined ) {
				jQuery( window ).removeProp( callbackName );

			// Otherwise restore preexisting value
			} else {
				window[ callbackName ] = overwritten;
			}

			// Save back as free
			if ( s[ callbackName ] ) {

				// Make sure that re-using the options doesn't screw things around
				s.jsonpCallback = originalSettings.jsonpCallback;

				// Save the callback name for future use
				oldCallbacks.push( callbackName );
			}

			// Call if it was a function and we have a response
			if ( responseContainer && isFunction( overwritten ) ) {
				overwritten( responseContainer[ 0 ] );
			}

			responseContainer = overwritten = undefined;
		} );

		// Delegate to script
		return "script";
	}
} );




// Support: Safari 8 only
// In Safari 8 documents created via document.implementation.createHTMLDocument
// collapse sibling forms: the second one becomes a child of the first one.
// Because of that, this security measure has to be disabled in Safari 8.
// https://bugs.webkit.org/show_bug.cgi?id=137337
support.createHTMLDocument = ( function() {
	var body = document.implementation.createHTMLDocument( "" ).body;
	body.innerHTML = "<form></form><form></form>";
	return body.childNodes.length === 2;
} )();


// Argument "data" should be string of html
// context (optional): If specified, the fragment will be created in this context,
// defaults to document
// keepScripts (optional): If true, will include scripts passed in the html string
jQuery.parseHTML = function( data, context, keepScripts ) {
	if ( typeof data !== "string" ) {
		return [];
	}
	if ( typeof context === "boolean" ) {
		keepScripts = context;
		context = false;
	}

	var base, parsed, scripts;

	if ( !context ) {

		// Stop scripts or inline event handlers from being executed immediately
		// by using document.implementation
		if ( support.createHTMLDocument ) {
			context = document.implementation.createHTMLDocument( "" );

			// Set the base href for the created document
			// so any parsed elements with URLs
			// are based on the document's URL (gh-2965)
			base = context.createElement( "base" );
			base.href = document.location.href;
			context.head.appendChild( base );
		} else {
			context = document;
		}
	}

	parsed = rsingleTag.exec( data );
	scripts = !keepScripts && [];

	// Single tag
	if ( parsed ) {
		return [ context.createElement( parsed[ 1 ] ) ];
	}

	parsed = buildFragment( [ data ], context, scripts );

	if ( scripts && scripts.length ) {
		jQuery( scripts ).remove();
	}

	return jQuery.merge( [], parsed.childNodes );
};


/**
 * Load a url into a page
 */
jQuery.fn.load = function( url, params, callback ) {
	var selector, type, response,
		self = this,
		off = url.indexOf( " " );

	if ( off > -1 ) {
		selector = stripAndCollapse( url.slice( off ) );
		url = url.slice( 0, off );
	}

	// If it's a function
	if ( isFunction( params ) ) {

		// We assume that it's the callback
		callback = params;
		params = undefined;

	// Otherwise, build a param string
	} else if ( params && typeof params === "object" ) {
		type = "POST";
	}

	// If we have elements to modify, make the request
	if ( self.length > 0 ) {
		jQuery.ajax( {
			url: url,

			// If "type" variable is undefined, then "GET" method will be used.
			// Make value of this field explicit since
			// user can override it through ajaxSetup method
			type: type || "GET",
			dataType: "html",
			data: params
		} ).done( function( responseText ) {

			// Save response for use in complete callback
			response = arguments;

			self.html( selector ?

				// If a selector was specified, locate the right elements in a dummy div
				// Exclude scripts to avoid IE 'Permission Denied' errors
				jQuery( "<div>" ).append( jQuery.parseHTML( responseText ) ).find( selector ) :

				// Otherwise use the full result
				responseText );

		// If the request succeeds, this function gets "data", "status", "jqXHR"
		// but they are ignored because response was set above.
		// If it fails, this function gets "jqXHR", "status", "error"
		} ).always( callback && function( jqXHR, status ) {
			self.each( function() {
				callback.apply( this, response || [ jqXHR.responseText, status, jqXHR ] );
			} );
		} );
	}

	return this;
};




jQuery.expr.pseudos.animated = function( elem ) {
	return jQuery.grep( jQuery.timers, function( fn ) {
		return elem === fn.elem;
	} ).length;
};




jQuery.offset = {
	setOffset: function( elem, options, i ) {
		var curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition,
			position = jQuery.css( elem, "position" ),
			curElem = jQuery( elem ),
			props = {};

		// Set position first, in-case top/left are set even on static elem
		if ( position === "static" ) {
			elem.style.position = "relative";
		}

		curOffset = curElem.offset();
		curCSSTop = jQuery.css( elem, "top" );
		curCSSLeft = jQuery.css( elem, "left" );
		calculatePosition = ( position === "absolute" || position === "fixed" ) &&
			( curCSSTop + curCSSLeft ).indexOf( "auto" ) > -1;

		// Need to be able to calculate position if either
		// top or left is auto and position is either absolute or fixed
		if ( calculatePosition ) {
			curPosition = curElem.position();
			curTop = curPosition.top;
			curLeft = curPosition.left;

		} else {
			curTop = parseFloat( curCSSTop ) || 0;
			curLeft = parseFloat( curCSSLeft ) || 0;
		}

		if ( isFunction( options ) ) {

			// Use jQuery.extend here to allow modification of coordinates argument (gh-1848)
			options = options.call( elem, i, jQuery.extend( {}, curOffset ) );
		}

		if ( options.top != null ) {
			props.top = ( options.top - curOffset.top ) + curTop;
		}
		if ( options.left != null ) {
			props.left = ( options.left - curOffset.left ) + curLeft;
		}

		if ( "using" in options ) {
			options.using.call( elem, props );

		} else {
			curElem.css( props );
		}
	}
};

jQuery.fn.extend( {

	// offset() relates an element's border box to the document origin
	offset: function( options ) {

		// Preserve chaining for setter
		if ( arguments.length ) {
			return options === undefined ?
				this :
				this.each( function( i ) {
					jQuery.offset.setOffset( this, options, i );
				} );
		}

		var rect, win,
			elem = this[ 0 ];

		if ( !elem ) {
			return;
		}

		// Return zeros for disconnected and hidden (display: none) elements (gh-2310)
		// Support: IE <=11 only
		// Running getBoundingClientRect on a
		// disconnected node in IE throws an error
		if ( !elem.getClientRects().length ) {
			return { top: 0, left: 0 };
		}

		// Get document-relative position by adding viewport scroll to viewport-relative gBCR
		rect = elem.getBoundingClientRect();
		win = elem.ownerDocument.defaultView;
		return {
			top: rect.top + win.pageYOffset,
			left: rect.left + win.pageXOffset
		};
	},

	// position() relates an element's margin box to its offset parent's padding box
	// This corresponds to the behavior of CSS absolute positioning
	position: function() {
		if ( !this[ 0 ] ) {
			return;
		}

		var offsetParent, offset, doc,
			elem = this[ 0 ],
			parentOffset = { top: 0, left: 0 };

		// position:fixed elements are offset from the viewport, which itself always has zero offset
		if ( jQuery.css( elem, "position" ) === "fixed" ) {

			// Assume position:fixed implies availability of getBoundingClientRect
			offset = elem.getBoundingClientRect();

		} else {
			offset = this.offset();

			// Account for the *real* offset parent, which can be the document or its root element
			// when a statically positioned element is identified
			doc = elem.ownerDocument;
			offsetParent = elem.offsetParent || doc.documentElement;
			while ( offsetParent &&
				( offsetParent === doc.body || offsetParent === doc.documentElement ) &&
				jQuery.css( offsetParent, "position" ) === "static" ) {

				offsetParent = offsetParent.parentNode;
			}
			if ( offsetParent && offsetParent !== elem && offsetParent.nodeType === 1 ) {

				// Incorporate borders into its offset, since they are outside its content origin
				parentOffset = jQuery( offsetParent ).offset();
				parentOffset.top += jQuery.css( offsetParent, "borderTopWidth", true );
				parentOffset.left += jQuery.css( offsetParent, "borderLeftWidth", true );
			}
		}

		// Subtract parent offsets and element margins
		return {
			top: offset.top - parentOffset.top - jQuery.css( elem, "marginTop", true ),
			left: offset.left - parentOffset.left - jQuery.css( elem, "marginLeft", true )
		};
	},

	// This method will return documentElement in the following cases:
	// 1) For the element inside the iframe without offsetParent, this method will return
	//    documentElement of the parent window
	// 2) For the hidden or detached element
	// 3) For body or html element, i.e. in case of the html node - it will return itself
	//
	// but those exceptions were never presented as a real life use-cases
	// and might be considered as more preferable results.
	//
	// This logic, however, is not guaranteed and can change at any point in the future
	offsetParent: function() {
		return this.map( function() {
			var offsetParent = this.offsetParent;

			while ( offsetParent && jQuery.css( offsetParent, "position" ) === "static" ) {
				offsetParent = offsetParent.offsetParent;
			}

			return offsetParent || documentElement;
		} );
	}
} );

// Create scrollLeft and scrollTop methods
jQuery.each( { scrollLeft: "pageXOffset", scrollTop: "pageYOffset" }, function( method, prop ) {
	var top = "pageYOffset" === prop;

	jQuery.fn[ method ] = function( val ) {
		return access( this, function( elem, method, val ) {

			// Coalesce documents and windows
			var win;
			if ( isWindow( elem ) ) {
				win = elem;
			} else if ( elem.nodeType === 9 ) {
				win = elem.defaultView;
			}

			if ( val === undefined ) {
				return win ? win[ prop ] : elem[ method ];
			}

			if ( win ) {
				win.scrollTo(
					!top ? val : win.pageXOffset,
					top ? val : win.pageYOffset
				);

			} else {
				elem[ method ] = val;
			}
		}, method, val, arguments.length );
	};
} );

// Support: Safari <=7 - 9.1, Chrome <=37 - 49
// Add the top/left cssHooks using jQuery.fn.position
// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084
// Blink bug: https://bugs.chromium.org/p/chromium/issues/detail?id=589347
// getComputedStyle returns percent when specified for top/left/bottom/right;
// rather than make the css module depend on the offset module, just check for it here
jQuery.each( [ "top", "left" ], function( _i, prop ) {
	jQuery.cssHooks[ prop ] = addGetHookIf( support.pixelPosition,
		function( elem, computed ) {
			if ( computed ) {
				computed = curCSS( elem, prop );

				// If curCSS returns percentage, fallback to offset
				return rnumnonpx.test( computed ) ?
					jQuery( elem ).position()[ prop ] + "px" :
					computed;
			}
		}
	);
} );


// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods
jQuery.each( { Height: "height", Width: "width" }, function( name, type ) {
	jQuery.each( {
		padding: "inner" + name,
		content: type,
		"": "outer" + name
	}, function( defaultExtra, funcName ) {

		// Margin is only for outerHeight, outerWidth
		jQuery.fn[ funcName ] = function( margin, value ) {
			var chainable = arguments.length && ( defaultExtra || typeof margin !== "boolean" ),
				extra = defaultExtra || ( margin === true || value === true ? "margin" : "border" );

			return access( this, function( elem, type, value ) {
				var doc;

				if ( isWindow( elem ) ) {

					// $( window ).outerWidth/Height return w/h including scrollbars (gh-1729)
					return funcName.indexOf( "outer" ) === 0 ?
						elem[ "inner" + name ] :
						elem.document.documentElement[ "client" + name ];
				}

				// Get document width or height
				if ( elem.nodeType === 9 ) {
					doc = elem.documentElement;

					// Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height],
					// whichever is greatest
					return Math.max(
						elem.body[ "scroll" + name ], doc[ "scroll" + name ],
						elem.body[ "offset" + name ], doc[ "offset" + name ],
						doc[ "client" + name ]
					);
				}

				return value === undefined ?

					// Get width or height on the element, requesting but not forcing parseFloat
					jQuery.css( elem, type, extra ) :

					// Set width or height on the element
					jQuery.style( elem, type, value, extra );
			}, type, chainable ? margin : undefined, chainable );
		};
	} );
} );


jQuery.each( [
	"ajaxStart",
	"ajaxStop",
	"ajaxComplete",
	"ajaxError",
	"ajaxSuccess",
	"ajaxSend"
], function( _i, type ) {
	jQuery.fn[ type ] = function( fn ) {
		return this.on( type, fn );
	};
} );




jQuery.fn.extend( {

	bind: function( types, data, fn ) {
		return this.on( types, null, data, fn );
	},
	unbind: function( types, fn ) {
		return this.off( types, null, fn );
	},

	delegate: function( selector, types, data, fn ) {
		return this.on( types, selector, data, fn );
	},
	undelegate: function( selector, types, fn ) {

		// ( namespace ) or ( selector, types [, fn] )
		return arguments.length === 1 ?
			this.off( selector, "**" ) :
			this.off( types, selector || "**", fn );
	},

	hover: function( fnOver, fnOut ) {
		return this.mouseenter( fnOver ).mouseleave( fnOut || fnOver );
	}
} );

jQuery.each(
	( "blur focus focusin focusout resize scroll click dblclick " +
	"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " +
	"change select submit keydown keypress keyup contextmenu" ).split( " " ),
	function( _i, name ) {

		// Handle event binding
		jQuery.fn[ name ] = function( data, fn ) {
			return arguments.length > 0 ?
				this.on( name, null, data, fn ) :
				this.trigger( name );
		};
	}
);




// Support: Android <=4.0 only
// Make sure we trim BOM and NBSP
var rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;

// Bind a function to a context, optionally partially applying any
// arguments.
// jQuery.proxy is deprecated to promote standards (specifically Function#bind)
// However, it is not slated for removal any time soon
jQuery.proxy = function( fn, context ) {
	var tmp, args, proxy;

	if ( typeof context === "string" ) {
		tmp = fn[ context ];
		context = fn;
		fn = tmp;
	}

	// Quick check to determine if target is callable, in the spec
	// this throws a TypeError, but we will just return undefined.
	if ( !isFunction( fn ) ) {
		return undefined;
	}

	// Simulated bind
	args = slice.call( arguments, 2 );
	proxy = function() {
		return fn.apply( context || this, args.concat( slice.call( arguments ) ) );
	};

	// Set the guid of unique handler to the same of original handler, so it can be removed
	proxy.guid = fn.guid = fn.guid || jQuery.guid++;

	return proxy;
};

jQuery.holdReady = function( hold ) {
	if ( hold ) {
		jQuery.readyWait++;
	} else {
		jQuery.ready( true );
	}
};
jQuery.isArray = Array.isArray;
jQuery.parseJSON = JSON.parse;
jQuery.nodeName = nodeName;
jQuery.isFunction = isFunction;
jQuery.isWindow = isWindow;
jQuery.camelCase = camelCase;
jQuery.type = toType;

jQuery.now = Date.now;

jQuery.isNumeric = function( obj ) {

	// As of jQuery 3.0, isNumeric is limited to
	// strings and numbers (primitives or objects)
	// that can be coerced to finite numbers (gh-2662)
	var type = jQuery.type( obj );
	return ( type === "number" || type === "string" ) &&

		// parseFloat NaNs numeric-cast false positives ("")
		// ...but misinterprets leading-number strings, particularly hex literals ("0x...")
		// subtraction forces infinities to NaN
		!isNaN( obj - parseFloat( obj ) );
};

jQuery.trim = function( text ) {
	return text == null ?
		"" :
		( text + "" ).replace( rtrim, "" );
};



// Register as a named AMD module, since jQuery can be concatenated with other
// files that may use define, but not via a proper concatenation script that
// understands anonymous AMD modules. A named AMD is safest and most robust
// way to register. Lowercase jquery is used because AMD module names are
// derived from file names, and jQuery is normally delivered in a lowercase
// file name. Do this after creating the global so that if an AMD module wants
// to call noConflict to hide this version of jQuery, it will work.

// Note that for maximum portability, libraries that are not jQuery should
// declare themselves as anonymous modules, and avoid setting a global if an
// AMD loader is present. jQuery is a special case. For more information, see
// https://github.com/jrburke/requirejs/wiki/Updating-existing-libraries#wiki-anon

if ( typeof define === "function" && define.amd ) {
	define( "jquery", [], function() {
		return jQuery;
	} );
}




var

	// Map over jQuery in case of overwrite
	_jQuery = window.jQuery,

	// Map over the $ in case of overwrite
	_$ = window.$;

jQuery.noConflict = function( deep ) {
	if ( window.$ === jQuery ) {
		window.$ = _$;
	}

	if ( deep && window.jQuery === jQuery ) {
		window.jQuery = _jQuery;
	}

	return jQuery;
};

// Expose jQuery and $ identifiers, even in AMD
// (#7102#comment:10, https://github.com/jquery/jquery/pull/557)
// and CommonJS for browser emulators (#13566)
if ( typeof noGlobal === "undefined" ) {
	window.jQuery = window.$ = jQuery;
}




return jQuery;
} );

/*!
  * Bootstrap v4.6.1 (https://getbootstrap.com/)
  * Copyright 2011-2021 The Bootstrap Authors (https://github.com/twbs/bootstrap/graphs/contributors)
  * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
  */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('jquery'), require('popper.js')) :
  typeof define === 'function' && define.amd ? define(['exports', 'jquery', 'popper.js'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.bootstrap = {}, global.jQuery, global.Popper));
})(this, (function (exports, $, Popper) { 'use strict';

  function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

  var $__default = /*#__PURE__*/_interopDefaultLegacy($);
  var Popper__default = /*#__PURE__*/_interopDefaultLegacy(Popper);

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _inheritsLoose(subClass, superClass) {
    subClass.prototype = Object.create(superClass.prototype);
    subClass.prototype.constructor = subClass;

    _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v4.6.1): util.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  /**
   * Private TransitionEnd Helpers
   */

  var TRANSITION_END = 'transitionend';
  var MAX_UID = 1000000;
  var MILLISECONDS_MULTIPLIER = 1000; // Shoutout AngusCroll (https://goo.gl/pxwQGp)

  function toType(obj) {
    if (obj === null || typeof obj === 'undefined') {
      return "" + obj;
    }

    return {}.toString.call(obj).match(/\s([a-z]+)/i)[1].toLowerCase();
  }

  function getSpecialTransitionEndEvent() {
    return {
      bindType: TRANSITION_END,
      delegateType: TRANSITION_END,
      handle: function handle(event) {
        if ($__default["default"](event.target).is(this)) {
          return event.handleObj.handler.apply(this, arguments); // eslint-disable-line prefer-rest-params
        }

        return undefined;
      }
    };
  }

  function transitionEndEmulator(duration) {
    var _this = this;

    var called = false;
    $__default["default"](this).one(Util.TRANSITION_END, function () {
      called = true;
    });
    setTimeout(function () {
      if (!called) {
        Util.triggerTransitionEnd(_this);
      }
    }, duration);
    return this;
  }

  function setTransitionEndSupport() {
    $__default["default"].fn.emulateTransitionEnd = transitionEndEmulator;
    $__default["default"].event.special[Util.TRANSITION_END] = getSpecialTransitionEndEvent();
  }
  /**
   * Public Util API
   */


  var Util = {
    TRANSITION_END: 'bsTransitionEnd',
    getUID: function getUID(prefix) {
      do {
        // eslint-disable-next-line no-bitwise
        prefix += ~~(Math.random() * MAX_UID); // "~~" acts like a faster Math.floor() here
      } while (document.getElementById(prefix));

      return prefix;
    },
    getSelectorFromElement: function getSelectorFromElement(element) {
      var selector = element.getAttribute('data-target');

      if (!selector || selector === '#') {
        var hrefAttr = element.getAttribute('href');
        selector = hrefAttr && hrefAttr !== '#' ? hrefAttr.trim() : '';
      }

      try {
        return document.querySelector(selector) ? selector : null;
      } catch (_) {
        return null;
      }
    },
    getTransitionDurationFromElement: function getTransitionDurationFromElement(element) {
      if (!element) {
        return 0;
      } // Get transition-duration of the element


      var transitionDuration = $__default["default"](element).css('transition-duration');
      var transitionDelay = $__default["default"](element).css('transition-delay');
      var floatTransitionDuration = parseFloat(transitionDuration);
      var floatTransitionDelay = parseFloat(transitionDelay); // Return 0 if element or transition duration is not found

      if (!floatTransitionDuration && !floatTransitionDelay) {
        return 0;
      } // If multiple durations are defined, take the first


      transitionDuration = transitionDuration.split(',')[0];
      transitionDelay = transitionDelay.split(',')[0];
      return (parseFloat(transitionDuration) + parseFloat(transitionDelay)) * MILLISECONDS_MULTIPLIER;
    },
    reflow: function reflow(element) {
      return element.offsetHeight;
    },
    triggerTransitionEnd: function triggerTransitionEnd(element) {
      $__default["default"](element).trigger(TRANSITION_END);
    },
    supportsTransitionEnd: function supportsTransitionEnd() {
      return Boolean(TRANSITION_END);
    },
    isElement: function isElement(obj) {
      return (obj[0] || obj).nodeType;
    },
    typeCheckConfig: function typeCheckConfig(componentName, config, configTypes) {
      for (var property in configTypes) {
        if (Object.prototype.hasOwnProperty.call(configTypes, property)) {
          var expectedTypes = configTypes[property];
          var value = config[property];
          var valueType = value && Util.isElement(value) ? 'element' : toType(value);

          if (!new RegExp(expectedTypes).test(valueType)) {
            throw new Error(componentName.toUpperCase() + ": " + ("Option \"" + property + "\" provided type \"" + valueType + "\" ") + ("but expected type \"" + expectedTypes + "\"."));
          }
        }
      }
    },
    findShadowRoot: function findShadowRoot(element) {
      if (!document.documentElement.attachShadow) {
        return null;
      } // Can find the shadow root otherwise it'll return the document


      if (typeof element.getRootNode === 'function') {
        var root = element.getRootNode();
        return root instanceof ShadowRoot ? root : null;
      }

      if (element instanceof ShadowRoot) {
        return element;
      } // when we don't find a shadow root


      if (!element.parentNode) {
        return null;
      }

      return Util.findShadowRoot(element.parentNode);
    },
    jQueryDetection: function jQueryDetection() {
      if (typeof $__default["default"] === 'undefined') {
        throw new TypeError('Bootstrap\'s JavaScript requires jQuery. jQuery must be included before Bootstrap\'s JavaScript.');
      }

      var version = $__default["default"].fn.jquery.split(' ')[0].split('.');
      var minMajor = 1;
      var ltMajor = 2;
      var minMinor = 9;
      var minPatch = 1;
      var maxMajor = 4;

      if (version[0] < ltMajor && version[1] < minMinor || version[0] === minMajor && version[1] === minMinor && version[2] < minPatch || version[0] >= maxMajor) {
        throw new Error('Bootstrap\'s JavaScript requires at least jQuery v1.9.1 but less than v4.0.0');
      }
    }
  };
  Util.jQueryDetection();
  setTransitionEndSupport();

  /**
   * Constants
   */

  var NAME$a = 'alert';
  var VERSION$a = '4.6.1';
  var DATA_KEY$a = 'bs.alert';
  var EVENT_KEY$a = "." + DATA_KEY$a;
  var DATA_API_KEY$7 = '.data-api';
  var JQUERY_NO_CONFLICT$a = $__default["default"].fn[NAME$a];
  var CLASS_NAME_ALERT = 'alert';
  var CLASS_NAME_FADE$5 = 'fade';
  var CLASS_NAME_SHOW$7 = 'show';
  var EVENT_CLOSE = "close" + EVENT_KEY$a;
  var EVENT_CLOSED = "closed" + EVENT_KEY$a;
  var EVENT_CLICK_DATA_API$6 = "click" + EVENT_KEY$a + DATA_API_KEY$7;
  var SELECTOR_DISMISS = '[data-dismiss="alert"]';
  /**
   * Class definition
   */

  var Alert = /*#__PURE__*/function () {
    function Alert(element) {
      this._element = element;
    } // Getters


    var _proto = Alert.prototype;

    // Public
    _proto.close = function close(element) {
      var rootElement = this._element;

      if (element) {
        rootElement = this._getRootElement(element);
      }

      var customEvent = this._triggerCloseEvent(rootElement);

      if (customEvent.isDefaultPrevented()) {
        return;
      }

      this._removeElement(rootElement);
    };

    _proto.dispose = function dispose() {
      $__default["default"].removeData(this._element, DATA_KEY$a);
      this._element = null;
    } // Private
    ;

    _proto._getRootElement = function _getRootElement(element) {
      var selector = Util.getSelectorFromElement(element);
      var parent = false;

      if (selector) {
        parent = document.querySelector(selector);
      }

      if (!parent) {
        parent = $__default["default"](element).closest("." + CLASS_NAME_ALERT)[0];
      }

      return parent;
    };

    _proto._triggerCloseEvent = function _triggerCloseEvent(element) {
      var closeEvent = $__default["default"].Event(EVENT_CLOSE);
      $__default["default"](element).trigger(closeEvent);
      return closeEvent;
    };

    _proto._removeElement = function _removeElement(element) {
      var _this = this;

      $__default["default"](element).removeClass(CLASS_NAME_SHOW$7);

      if (!$__default["default"](element).hasClass(CLASS_NAME_FADE$5)) {
        this._destroyElement(element);

        return;
      }

      var transitionDuration = Util.getTransitionDurationFromElement(element);
      $__default["default"](element).one(Util.TRANSITION_END, function (event) {
        return _this._destroyElement(element, event);
      }).emulateTransitionEnd(transitionDuration);
    };

    _proto._destroyElement = function _destroyElement(element) {
      $__default["default"](element).detach().trigger(EVENT_CLOSED).remove();
    } // Static
    ;

    Alert._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var $element = $__default["default"](this);
        var data = $element.data(DATA_KEY$a);

        if (!data) {
          data = new Alert(this);
          $element.data(DATA_KEY$a, data);
        }

        if (config === 'close') {
          data[config](this);
        }
      });
    };

    Alert._handleDismiss = function _handleDismiss(alertInstance) {
      return function (event) {
        if (event) {
          event.preventDefault();
        }

        alertInstance.close(this);
      };
    };

    _createClass(Alert, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$a;
      }
    }]);

    return Alert;
  }();
  /**
   * Data API implementation
   */


  $__default["default"](document).on(EVENT_CLICK_DATA_API$6, SELECTOR_DISMISS, Alert._handleDismiss(new Alert()));
  /**
   * jQuery
   */

  $__default["default"].fn[NAME$a] = Alert._jQueryInterface;
  $__default["default"].fn[NAME$a].Constructor = Alert;

  $__default["default"].fn[NAME$a].noConflict = function () {
    $__default["default"].fn[NAME$a] = JQUERY_NO_CONFLICT$a;
    return Alert._jQueryInterface;
  };

  /**
   * Constants
   */

  var NAME$9 = 'button';
  var VERSION$9 = '4.6.1';
  var DATA_KEY$9 = 'bs.button';
  var EVENT_KEY$9 = "." + DATA_KEY$9;
  var DATA_API_KEY$6 = '.data-api';
  var JQUERY_NO_CONFLICT$9 = $__default["default"].fn[NAME$9];
  var CLASS_NAME_ACTIVE$3 = 'active';
  var CLASS_NAME_BUTTON = 'btn';
  var CLASS_NAME_FOCUS = 'focus';
  var EVENT_CLICK_DATA_API$5 = "click" + EVENT_KEY$9 + DATA_API_KEY$6;
  var EVENT_FOCUS_BLUR_DATA_API = "focus" + EVENT_KEY$9 + DATA_API_KEY$6 + " " + ("blur" + EVENT_KEY$9 + DATA_API_KEY$6);
  var EVENT_LOAD_DATA_API$2 = "load" + EVENT_KEY$9 + DATA_API_KEY$6;
  var SELECTOR_DATA_TOGGLE_CARROT = '[data-toggle^="button"]';
  var SELECTOR_DATA_TOGGLES = '[data-toggle="buttons"]';
  var SELECTOR_DATA_TOGGLE$4 = '[data-toggle="button"]';
  var SELECTOR_DATA_TOGGLES_BUTTONS = '[data-toggle="buttons"] .btn';
  var SELECTOR_INPUT = 'input:not([type="hidden"])';
  var SELECTOR_ACTIVE$2 = '.active';
  var SELECTOR_BUTTON = '.btn';
  /**
   * Class definition
   */

  var Button = /*#__PURE__*/function () {
    function Button(element) {
      this._element = element;
      this.shouldAvoidTriggerChange = false;
    } // Getters


    var _proto = Button.prototype;

    // Public
    _proto.toggle = function toggle() {
      var triggerChangeEvent = true;
      var addAriaPressed = true;
      var rootElement = $__default["default"](this._element).closest(SELECTOR_DATA_TOGGLES)[0];

      if (rootElement) {
        var input = this._element.querySelector(SELECTOR_INPUT);

        if (input) {
          if (input.type === 'radio') {
            if (input.checked && this._element.classList.contains(CLASS_NAME_ACTIVE$3)) {
              triggerChangeEvent = false;
            } else {
              var activeElement = rootElement.querySelector(SELECTOR_ACTIVE$2);

              if (activeElement) {
                $__default["default"](activeElement).removeClass(CLASS_NAME_ACTIVE$3);
              }
            }
          }

          if (triggerChangeEvent) {
            // if it's not a radio button or checkbox don't add a pointless/invalid checked property to the input
            if (input.type === 'checkbox' || input.type === 'radio') {
              input.checked = !this._element.classList.contains(CLASS_NAME_ACTIVE$3);
            }

            if (!this.shouldAvoidTriggerChange) {
              $__default["default"](input).trigger('change');
            }
          }

          input.focus();
          addAriaPressed = false;
        }
      }

      if (!(this._element.hasAttribute('disabled') || this._element.classList.contains('disabled'))) {
        if (addAriaPressed) {
          this._element.setAttribute('aria-pressed', !this._element.classList.contains(CLASS_NAME_ACTIVE$3));
        }

        if (triggerChangeEvent) {
          $__default["default"](this._element).toggleClass(CLASS_NAME_ACTIVE$3);
        }
      }
    };

    _proto.dispose = function dispose() {
      $__default["default"].removeData(this._element, DATA_KEY$9);
      this._element = null;
    } // Static
    ;

    Button._jQueryInterface = function _jQueryInterface(config, avoidTriggerChange) {
      return this.each(function () {
        var $element = $__default["default"](this);
        var data = $element.data(DATA_KEY$9);

        if (!data) {
          data = new Button(this);
          $element.data(DATA_KEY$9, data);
        }

        data.shouldAvoidTriggerChange = avoidTriggerChange;

        if (config === 'toggle') {
          data[config]();
        }
      });
    };

    _createClass(Button, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$9;
      }
    }]);

    return Button;
  }();
  /**
   * Data API implementation
   */


  $__default["default"](document).on(EVENT_CLICK_DATA_API$5, SELECTOR_DATA_TOGGLE_CARROT, function (event) {
    var button = event.target;
    var initialButton = button;

    if (!$__default["default"](button).hasClass(CLASS_NAME_BUTTON)) {
      button = $__default["default"](button).closest(SELECTOR_BUTTON)[0];
    }

    if (!button || button.hasAttribute('disabled') || button.classList.contains('disabled')) {
      event.preventDefault(); // work around Firefox bug #1540995
    } else {
      var inputBtn = button.querySelector(SELECTOR_INPUT);

      if (inputBtn && (inputBtn.hasAttribute('disabled') || inputBtn.classList.contains('disabled'))) {
        event.preventDefault(); // work around Firefox bug #1540995

        return;
      }

      if (initialButton.tagName === 'INPUT' || button.tagName !== 'LABEL') {
        Button._jQueryInterface.call($__default["default"](button), 'toggle', initialButton.tagName === 'INPUT');
      }
    }
  }).on(EVENT_FOCUS_BLUR_DATA_API, SELECTOR_DATA_TOGGLE_CARROT, function (event) {
    var button = $__default["default"](event.target).closest(SELECTOR_BUTTON)[0];
    $__default["default"](button).toggleClass(CLASS_NAME_FOCUS, /^focus(in)?$/.test(event.type));
  });
  $__default["default"](window).on(EVENT_LOAD_DATA_API$2, function () {
    // ensure correct active class is set to match the controls' actual values/states
    // find all checkboxes/readio buttons inside data-toggle groups
    var buttons = [].slice.call(document.querySelectorAll(SELECTOR_DATA_TOGGLES_BUTTONS));

    for (var i = 0, len = buttons.length; i < len; i++) {
      var button = buttons[i];
      var input = button.querySelector(SELECTOR_INPUT);

      if (input.checked || input.hasAttribute('checked')) {
        button.classList.add(CLASS_NAME_ACTIVE$3);
      } else {
        button.classList.remove(CLASS_NAME_ACTIVE$3);
      }
    } // find all button toggles


    buttons = [].slice.call(document.querySelectorAll(SELECTOR_DATA_TOGGLE$4));

    for (var _i = 0, _len = buttons.length; _i < _len; _i++) {
      var _button = buttons[_i];

      if (_button.getAttribute('aria-pressed') === 'true') {
        _button.classList.add(CLASS_NAME_ACTIVE$3);
      } else {
        _button.classList.remove(CLASS_NAME_ACTIVE$3);
      }
    }
  });
  /**
   * jQuery
   */

  $__default["default"].fn[NAME$9] = Button._jQueryInterface;
  $__default["default"].fn[NAME$9].Constructor = Button;

  $__default["default"].fn[NAME$9].noConflict = function () {
    $__default["default"].fn[NAME$9] = JQUERY_NO_CONFLICT$9;
    return Button._jQueryInterface;
  };

  /**
   * Constants
   */

  var NAME$8 = 'carousel';
  var VERSION$8 = '4.6.1';
  var DATA_KEY$8 = 'bs.carousel';
  var EVENT_KEY$8 = "." + DATA_KEY$8;
  var DATA_API_KEY$5 = '.data-api';
  var JQUERY_NO_CONFLICT$8 = $__default["default"].fn[NAME$8];
  var ARROW_LEFT_KEYCODE = 37; // KeyboardEvent.which value for left arrow key

  var ARROW_RIGHT_KEYCODE = 39; // KeyboardEvent.which value for right arrow key

  var TOUCHEVENT_COMPAT_WAIT = 500; // Time for mouse compat events to fire after touch

  var SWIPE_THRESHOLD = 40;
  var CLASS_NAME_CAROUSEL = 'carousel';
  var CLASS_NAME_ACTIVE$2 = 'active';
  var CLASS_NAME_SLIDE = 'slide';
  var CLASS_NAME_RIGHT = 'carousel-item-right';
  var CLASS_NAME_LEFT = 'carousel-item-left';
  var CLASS_NAME_NEXT = 'carousel-item-next';
  var CLASS_NAME_PREV = 'carousel-item-prev';
  var CLASS_NAME_POINTER_EVENT = 'pointer-event';
  var DIRECTION_NEXT = 'next';
  var DIRECTION_PREV = 'prev';
  var DIRECTION_LEFT = 'left';
  var DIRECTION_RIGHT = 'right';
  var EVENT_SLIDE = "slide" + EVENT_KEY$8;
  var EVENT_SLID = "slid" + EVENT_KEY$8;
  var EVENT_KEYDOWN = "keydown" + EVENT_KEY$8;
  var EVENT_MOUSEENTER = "mouseenter" + EVENT_KEY$8;
  var EVENT_MOUSELEAVE = "mouseleave" + EVENT_KEY$8;
  var EVENT_TOUCHSTART = "touchstart" + EVENT_KEY$8;
  var EVENT_TOUCHMOVE = "touchmove" + EVENT_KEY$8;
  var EVENT_TOUCHEND = "touchend" + EVENT_KEY$8;
  var EVENT_POINTERDOWN = "pointerdown" + EVENT_KEY$8;
  var EVENT_POINTERUP = "pointerup" + EVENT_KEY$8;
  var EVENT_DRAG_START = "dragstart" + EVENT_KEY$8;
  var EVENT_LOAD_DATA_API$1 = "load" + EVENT_KEY$8 + DATA_API_KEY$5;
  var EVENT_CLICK_DATA_API$4 = "click" + EVENT_KEY$8 + DATA_API_KEY$5;
  var SELECTOR_ACTIVE$1 = '.active';
  var SELECTOR_ACTIVE_ITEM = '.active.carousel-item';
  var SELECTOR_ITEM = '.carousel-item';
  var SELECTOR_ITEM_IMG = '.carousel-item img';
  var SELECTOR_NEXT_PREV = '.carousel-item-next, .carousel-item-prev';
  var SELECTOR_INDICATORS = '.carousel-indicators';
  var SELECTOR_DATA_SLIDE = '[data-slide], [data-slide-to]';
  var SELECTOR_DATA_RIDE = '[data-ride="carousel"]';
  var Default$7 = {
    interval: 5000,
    keyboard: true,
    slide: false,
    pause: 'hover',
    wrap: true,
    touch: true
  };
  var DefaultType$7 = {
    interval: '(number|boolean)',
    keyboard: 'boolean',
    slide: '(boolean|string)',
    pause: '(string|boolean)',
    wrap: 'boolean',
    touch: 'boolean'
  };
  var PointerType = {
    TOUCH: 'touch',
    PEN: 'pen'
  };
  /**
   * Class definition
   */

  var Carousel = /*#__PURE__*/function () {
    function Carousel(element, config) {
      this._items = null;
      this._interval = null;
      this._activeElement = null;
      this._isPaused = false;
      this._isSliding = false;
      this.touchTimeout = null;
      this.touchStartX = 0;
      this.touchDeltaX = 0;
      this._config = this._getConfig(config);
      this._element = element;
      this._indicatorsElement = this._element.querySelector(SELECTOR_INDICATORS);
      this._touchSupported = 'ontouchstart' in document.documentElement || navigator.maxTouchPoints > 0;
      this._pointerEvent = Boolean(window.PointerEvent || window.MSPointerEvent);

      this._addEventListeners();
    } // Getters


    var _proto = Carousel.prototype;

    // Public
    _proto.next = function next() {
      if (!this._isSliding) {
        this._slide(DIRECTION_NEXT);
      }
    };

    _proto.nextWhenVisible = function nextWhenVisible() {
      var $element = $__default["default"](this._element); // Don't call next when the page isn't visible
      // or the carousel or its parent isn't visible

      if (!document.hidden && $element.is(':visible') && $element.css('visibility') !== 'hidden') {
        this.next();
      }
    };

    _proto.prev = function prev() {
      if (!this._isSliding) {
        this._slide(DIRECTION_PREV);
      }
    };

    _proto.pause = function pause(event) {
      if (!event) {
        this._isPaused = true;
      }

      if (this._element.querySelector(SELECTOR_NEXT_PREV)) {
        Util.triggerTransitionEnd(this._element);
        this.cycle(true);
      }

      clearInterval(this._interval);
      this._interval = null;
    };

    _proto.cycle = function cycle(event) {
      if (!event) {
        this._isPaused = false;
      }

      if (this._interval) {
        clearInterval(this._interval);
        this._interval = null;
      }

      if (this._config.interval && !this._isPaused) {
        this._updateInterval();

        this._interval = setInterval((document.visibilityState ? this.nextWhenVisible : this.next).bind(this), this._config.interval);
      }
    };

    _proto.to = function to(index) {
      var _this = this;

      this._activeElement = this._element.querySelector(SELECTOR_ACTIVE_ITEM);

      var activeIndex = this._getItemIndex(this._activeElement);

      if (index > this._items.length - 1 || index < 0) {
        return;
      }

      if (this._isSliding) {
        $__default["default"](this._element).one(EVENT_SLID, function () {
          return _this.to(index);
        });
        return;
      }

      if (activeIndex === index) {
        this.pause();
        this.cycle();
        return;
      }

      var direction = index > activeIndex ? DIRECTION_NEXT : DIRECTION_PREV;

      this._slide(direction, this._items[index]);
    };

    _proto.dispose = function dispose() {
      $__default["default"](this._element).off(EVENT_KEY$8);
      $__default["default"].removeData(this._element, DATA_KEY$8);
      this._items = null;
      this._config = null;
      this._element = null;
      this._interval = null;
      this._isPaused = null;
      this._isSliding = null;
      this._activeElement = null;
      this._indicatorsElement = null;
    } // Private
    ;

    _proto._getConfig = function _getConfig(config) {
      config = _extends({}, Default$7, config);
      Util.typeCheckConfig(NAME$8, config, DefaultType$7);
      return config;
    };

    _proto._handleSwipe = function _handleSwipe() {
      var absDeltax = Math.abs(this.touchDeltaX);

      if (absDeltax <= SWIPE_THRESHOLD) {
        return;
      }

      var direction = absDeltax / this.touchDeltaX;
      this.touchDeltaX = 0; // swipe left

      if (direction > 0) {
        this.prev();
      } // swipe right


      if (direction < 0) {
        this.next();
      }
    };

    _proto._addEventListeners = function _addEventListeners() {
      var _this2 = this;

      if (this._config.keyboard) {
        $__default["default"](this._element).on(EVENT_KEYDOWN, function (event) {
          return _this2._keydown(event);
        });
      }

      if (this._config.pause === 'hover') {
        $__default["default"](this._element).on(EVENT_MOUSEENTER, function (event) {
          return _this2.pause(event);
        }).on(EVENT_MOUSELEAVE, function (event) {
          return _this2.cycle(event);
        });
      }

      if (this._config.touch) {
        this._addTouchEventListeners();
      }
    };

    _proto._addTouchEventListeners = function _addTouchEventListeners() {
      var _this3 = this;

      if (!this._touchSupported) {
        return;
      }

      var start = function start(event) {
        if (_this3._pointerEvent && PointerType[event.originalEvent.pointerType.toUpperCase()]) {
          _this3.touchStartX = event.originalEvent.clientX;
        } else if (!_this3._pointerEvent) {
          _this3.touchStartX = event.originalEvent.touches[0].clientX;
        }
      };

      var move = function move(event) {
        // ensure swiping with one touch and not pinching
        _this3.touchDeltaX = event.originalEvent.touches && event.originalEvent.touches.length > 1 ? 0 : event.originalEvent.touches[0].clientX - _this3.touchStartX;
      };

      var end = function end(event) {
        if (_this3._pointerEvent && PointerType[event.originalEvent.pointerType.toUpperCase()]) {
          _this3.touchDeltaX = event.originalEvent.clientX - _this3.touchStartX;
        }

        _this3._handleSwipe();

        if (_this3._config.pause === 'hover') {
          // If it's a touch-enabled device, mouseenter/leave are fired as
          // part of the mouse compatibility events on first tap - the carousel
          // would stop cycling until user tapped out of it;
          // here, we listen for touchend, explicitly pause the carousel
          // (as if it's the second time we tap on it, mouseenter compat event
          // is NOT fired) and after a timeout (to allow for mouse compatibility
          // events to fire) we explicitly restart cycling
          _this3.pause();

          if (_this3.touchTimeout) {
            clearTimeout(_this3.touchTimeout);
          }

          _this3.touchTimeout = setTimeout(function (event) {
            return _this3.cycle(event);
          }, TOUCHEVENT_COMPAT_WAIT + _this3._config.interval);
        }
      };

      $__default["default"](this._element.querySelectorAll(SELECTOR_ITEM_IMG)).on(EVENT_DRAG_START, function (e) {
        return e.preventDefault();
      });

      if (this._pointerEvent) {
        $__default["default"](this._element).on(EVENT_POINTERDOWN, function (event) {
          return start(event);
        });
        $__default["default"](this._element).on(EVENT_POINTERUP, function (event) {
          return end(event);
        });

        this._element.classList.add(CLASS_NAME_POINTER_EVENT);
      } else {
        $__default["default"](this._element).on(EVENT_TOUCHSTART, function (event) {
          return start(event);
        });
        $__default["default"](this._element).on(EVENT_TOUCHMOVE, function (event) {
          return move(event);
        });
        $__default["default"](this._element).on(EVENT_TOUCHEND, function (event) {
          return end(event);
        });
      }
    };

    _proto._keydown = function _keydown(event) {
      if (/input|textarea/i.test(event.target.tagName)) {
        return;
      }

      switch (event.which) {
        case ARROW_LEFT_KEYCODE:
          event.preventDefault();
          this.prev();
          break;

        case ARROW_RIGHT_KEYCODE:
          event.preventDefault();
          this.next();
          break;
      }
    };

    _proto._getItemIndex = function _getItemIndex(element) {
      this._items = element && element.parentNode ? [].slice.call(element.parentNode.querySelectorAll(SELECTOR_ITEM)) : [];
      return this._items.indexOf(element);
    };

    _proto._getItemByDirection = function _getItemByDirection(direction, activeElement) {
      var isNextDirection = direction === DIRECTION_NEXT;
      var isPrevDirection = direction === DIRECTION_PREV;

      var activeIndex = this._getItemIndex(activeElement);

      var lastItemIndex = this._items.length - 1;
      var isGoingToWrap = isPrevDirection && activeIndex === 0 || isNextDirection && activeIndex === lastItemIndex;

      if (isGoingToWrap && !this._config.wrap) {
        return activeElement;
      }

      var delta = direction === DIRECTION_PREV ? -1 : 1;
      var itemIndex = (activeIndex + delta) % this._items.length;
      return itemIndex === -1 ? this._items[this._items.length - 1] : this._items[itemIndex];
    };

    _proto._triggerSlideEvent = function _triggerSlideEvent(relatedTarget, eventDirectionName) {
      var targetIndex = this._getItemIndex(relatedTarget);

      var fromIndex = this._getItemIndex(this._element.querySelector(SELECTOR_ACTIVE_ITEM));

      var slideEvent = $__default["default"].Event(EVENT_SLIDE, {
        relatedTarget: relatedTarget,
        direction: eventDirectionName,
        from: fromIndex,
        to: targetIndex
      });
      $__default["default"](this._element).trigger(slideEvent);
      return slideEvent;
    };

    _proto._setActiveIndicatorElement = function _setActiveIndicatorElement(element) {
      if (this._indicatorsElement) {
        var indicators = [].slice.call(this._indicatorsElement.querySelectorAll(SELECTOR_ACTIVE$1));
        $__default["default"](indicators).removeClass(CLASS_NAME_ACTIVE$2);

        var nextIndicator = this._indicatorsElement.children[this._getItemIndex(element)];

        if (nextIndicator) {
          $__default["default"](nextIndicator).addClass(CLASS_NAME_ACTIVE$2);
        }
      }
    };

    _proto._updateInterval = function _updateInterval() {
      var element = this._activeElement || this._element.querySelector(SELECTOR_ACTIVE_ITEM);

      if (!element) {
        return;
      }

      var elementInterval = parseInt(element.getAttribute('data-interval'), 10);

      if (elementInterval) {
        this._config.defaultInterval = this._config.defaultInterval || this._config.interval;
        this._config.interval = elementInterval;
      } else {
        this._config.interval = this._config.defaultInterval || this._config.interval;
      }
    };

    _proto._slide = function _slide(direction, element) {
      var _this4 = this;

      var activeElement = this._element.querySelector(SELECTOR_ACTIVE_ITEM);

      var activeElementIndex = this._getItemIndex(activeElement);

      var nextElement = element || activeElement && this._getItemByDirection(direction, activeElement);

      var nextElementIndex = this._getItemIndex(nextElement);

      var isCycling = Boolean(this._interval);
      var directionalClassName;
      var orderClassName;
      var eventDirectionName;

      if (direction === DIRECTION_NEXT) {
        directionalClassName = CLASS_NAME_LEFT;
        orderClassName = CLASS_NAME_NEXT;
        eventDirectionName = DIRECTION_LEFT;
      } else {
        directionalClassName = CLASS_NAME_RIGHT;
        orderClassName = CLASS_NAME_PREV;
        eventDirectionName = DIRECTION_RIGHT;
      }

      if (nextElement && $__default["default"](nextElement).hasClass(CLASS_NAME_ACTIVE$2)) {
        this._isSliding = false;
        return;
      }

      var slideEvent = this._triggerSlideEvent(nextElement, eventDirectionName);

      if (slideEvent.isDefaultPrevented()) {
        return;
      }

      if (!activeElement || !nextElement) {
        // Some weirdness is happening, so we bail
        return;
      }

      this._isSliding = true;

      if (isCycling) {
        this.pause();
      }

      this._setActiveIndicatorElement(nextElement);

      this._activeElement = nextElement;
      var slidEvent = $__default["default"].Event(EVENT_SLID, {
        relatedTarget: nextElement,
        direction: eventDirectionName,
        from: activeElementIndex,
        to: nextElementIndex
      });

      if ($__default["default"](this._element).hasClass(CLASS_NAME_SLIDE)) {
        $__default["default"](nextElement).addClass(orderClassName);
        Util.reflow(nextElement);
        $__default["default"](activeElement).addClass(directionalClassName);
        $__default["default"](nextElement).addClass(directionalClassName);
        var transitionDuration = Util.getTransitionDurationFromElement(activeElement);
        $__default["default"](activeElement).one(Util.TRANSITION_END, function () {
          $__default["default"](nextElement).removeClass(directionalClassName + " " + orderClassName).addClass(CLASS_NAME_ACTIVE$2);
          $__default["default"](activeElement).removeClass(CLASS_NAME_ACTIVE$2 + " " + orderClassName + " " + directionalClassName);
          _this4._isSliding = false;
          setTimeout(function () {
            return $__default["default"](_this4._element).trigger(slidEvent);
          }, 0);
        }).emulateTransitionEnd(transitionDuration);
      } else {
        $__default["default"](activeElement).removeClass(CLASS_NAME_ACTIVE$2);
        $__default["default"](nextElement).addClass(CLASS_NAME_ACTIVE$2);
        this._isSliding = false;
        $__default["default"](this._element).trigger(slidEvent);
      }

      if (isCycling) {
        this.cycle();
      }
    } // Static
    ;

    Carousel._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var data = $__default["default"](this).data(DATA_KEY$8);

        var _config = _extends({}, Default$7, $__default["default"](this).data());

        if (typeof config === 'object') {
          _config = _extends({}, _config, config);
        }

        var action = typeof config === 'string' ? config : _config.slide;

        if (!data) {
          data = new Carousel(this, _config);
          $__default["default"](this).data(DATA_KEY$8, data);
        }

        if (typeof config === 'number') {
          data.to(config);
        } else if (typeof action === 'string') {
          if (typeof data[action] === 'undefined') {
            throw new TypeError("No method named \"" + action + "\"");
          }

          data[action]();
        } else if (_config.interval && _config.ride) {
          data.pause();
          data.cycle();
        }
      });
    };

    Carousel._dataApiClickHandler = function _dataApiClickHandler(event) {
      var selector = Util.getSelectorFromElement(this);

      if (!selector) {
        return;
      }

      var target = $__default["default"](selector)[0];

      if (!target || !$__default["default"](target).hasClass(CLASS_NAME_CAROUSEL)) {
        return;
      }

      var config = _extends({}, $__default["default"](target).data(), $__default["default"](this).data());

      var slideIndex = this.getAttribute('data-slide-to');

      if (slideIndex) {
        config.interval = false;
      }

      Carousel._jQueryInterface.call($__default["default"](target), config);

      if (slideIndex) {
        $__default["default"](target).data(DATA_KEY$8).to(slideIndex);
      }

      event.preventDefault();
    };

    _createClass(Carousel, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$8;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default$7;
      }
    }]);

    return Carousel;
  }();
  /**
   * Data API implementation
   */


  $__default["default"](document).on(EVENT_CLICK_DATA_API$4, SELECTOR_DATA_SLIDE, Carousel._dataApiClickHandler);
  $__default["default"](window).on(EVENT_LOAD_DATA_API$1, function () {
    var carousels = [].slice.call(document.querySelectorAll(SELECTOR_DATA_RIDE));

    for (var i = 0, len = carousels.length; i < len; i++) {
      var $carousel = $__default["default"](carousels[i]);

      Carousel._jQueryInterface.call($carousel, $carousel.data());
    }
  });
  /**
   * jQuery
   */

  $__default["default"].fn[NAME$8] = Carousel._jQueryInterface;
  $__default["default"].fn[NAME$8].Constructor = Carousel;

  $__default["default"].fn[NAME$8].noConflict = function () {
    $__default["default"].fn[NAME$8] = JQUERY_NO_CONFLICT$8;
    return Carousel._jQueryInterface;
  };

  /**
   * Constants
   */

  var NAME$7 = 'collapse';
  var VERSION$7 = '4.6.1';
  var DATA_KEY$7 = 'bs.collapse';
  var EVENT_KEY$7 = "." + DATA_KEY$7;
  var DATA_API_KEY$4 = '.data-api';
  var JQUERY_NO_CONFLICT$7 = $__default["default"].fn[NAME$7];
  var CLASS_NAME_SHOW$6 = 'show';
  var CLASS_NAME_COLLAPSE = 'collapse';
  var CLASS_NAME_COLLAPSING = 'collapsing';
  var CLASS_NAME_COLLAPSED = 'collapsed';
  var DIMENSION_WIDTH = 'width';
  var DIMENSION_HEIGHT = 'height';
  var EVENT_SHOW$4 = "show" + EVENT_KEY$7;
  var EVENT_SHOWN$4 = "shown" + EVENT_KEY$7;
  var EVENT_HIDE$4 = "hide" + EVENT_KEY$7;
  var EVENT_HIDDEN$4 = "hidden" + EVENT_KEY$7;
  var EVENT_CLICK_DATA_API$3 = "click" + EVENT_KEY$7 + DATA_API_KEY$4;
  var SELECTOR_ACTIVES = '.show, .collapsing';
  var SELECTOR_DATA_TOGGLE$3 = '[data-toggle="collapse"]';
  var Default$6 = {
    toggle: true,
    parent: ''
  };
  var DefaultType$6 = {
    toggle: 'boolean',
    parent: '(string|element)'
  };
  /**
   * Class definition
   */

  var Collapse = /*#__PURE__*/function () {
    function Collapse(element, config) {
      this._isTransitioning = false;
      this._element = element;
      this._config = this._getConfig(config);
      this._triggerArray = [].slice.call(document.querySelectorAll("[data-toggle=\"collapse\"][href=\"#" + element.id + "\"]," + ("[data-toggle=\"collapse\"][data-target=\"#" + element.id + "\"]")));
      var toggleList = [].slice.call(document.querySelectorAll(SELECTOR_DATA_TOGGLE$3));

      for (var i = 0, len = toggleList.length; i < len; i++) {
        var elem = toggleList[i];
        var selector = Util.getSelectorFromElement(elem);
        var filterElement = [].slice.call(document.querySelectorAll(selector)).filter(function (foundElem) {
          return foundElem === element;
        });

        if (selector !== null && filterElement.length > 0) {
          this._selector = selector;

          this._triggerArray.push(elem);
        }
      }

      this._parent = this._config.parent ? this._getParent() : null;

      if (!this._config.parent) {
        this._addAriaAndCollapsedClass(this._element, this._triggerArray);
      }

      if (this._config.toggle) {
        this.toggle();
      }
    } // Getters


    var _proto = Collapse.prototype;

    // Public
    _proto.toggle = function toggle() {
      if ($__default["default"](this._element).hasClass(CLASS_NAME_SHOW$6)) {
        this.hide();
      } else {
        this.show();
      }
    };

    _proto.show = function show() {
      var _this = this;

      if (this._isTransitioning || $__default["default"](this._element).hasClass(CLASS_NAME_SHOW$6)) {
        return;
      }

      var actives;
      var activesData;

      if (this._parent) {
        actives = [].slice.call(this._parent.querySelectorAll(SELECTOR_ACTIVES)).filter(function (elem) {
          if (typeof _this._config.parent === 'string') {
            return elem.getAttribute('data-parent') === _this._config.parent;
          }

          return elem.classList.contains(CLASS_NAME_COLLAPSE);
        });

        if (actives.length === 0) {
          actives = null;
        }
      }

      if (actives) {
        activesData = $__default["default"](actives).not(this._selector).data(DATA_KEY$7);

        if (activesData && activesData._isTransitioning) {
          return;
        }
      }

      var startEvent = $__default["default"].Event(EVENT_SHOW$4);
      $__default["default"](this._element).trigger(startEvent);

      if (startEvent.isDefaultPrevented()) {
        return;
      }

      if (actives) {
        Collapse._jQueryInterface.call($__default["default"](actives).not(this._selector), 'hide');

        if (!activesData) {
          $__default["default"](actives).data(DATA_KEY$7, null);
        }
      }

      var dimension = this._getDimension();

      $__default["default"](this._element).removeClass(CLASS_NAME_COLLAPSE).addClass(CLASS_NAME_COLLAPSING);
      this._element.style[dimension] = 0;

      if (this._triggerArray.length) {
        $__default["default"](this._triggerArray).removeClass(CLASS_NAME_COLLAPSED).attr('aria-expanded', true);
      }

      this.setTransitioning(true);

      var complete = function complete() {
        $__default["default"](_this._element).removeClass(CLASS_NAME_COLLAPSING).addClass(CLASS_NAME_COLLAPSE + " " + CLASS_NAME_SHOW$6);
        _this._element.style[dimension] = '';

        _this.setTransitioning(false);

        $__default["default"](_this._element).trigger(EVENT_SHOWN$4);
      };

      var capitalizedDimension = dimension[0].toUpperCase() + dimension.slice(1);
      var scrollSize = "scroll" + capitalizedDimension;
      var transitionDuration = Util.getTransitionDurationFromElement(this._element);
      $__default["default"](this._element).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);
      this._element.style[dimension] = this._element[scrollSize] + "px";
    };

    _proto.hide = function hide() {
      var _this2 = this;

      if (this._isTransitioning || !$__default["default"](this._element).hasClass(CLASS_NAME_SHOW$6)) {
        return;
      }

      var startEvent = $__default["default"].Event(EVENT_HIDE$4);
      $__default["default"](this._element).trigger(startEvent);

      if (startEvent.isDefaultPrevented()) {
        return;
      }

      var dimension = this._getDimension();

      this._element.style[dimension] = this._element.getBoundingClientRect()[dimension] + "px";
      Util.reflow(this._element);
      $__default["default"](this._element).addClass(CLASS_NAME_COLLAPSING).removeClass(CLASS_NAME_COLLAPSE + " " + CLASS_NAME_SHOW$6);
      var triggerArrayLength = this._triggerArray.length;

      if (triggerArrayLength > 0) {
        for (var i = 0; i < triggerArrayLength; i++) {
          var trigger = this._triggerArray[i];
          var selector = Util.getSelectorFromElement(trigger);

          if (selector !== null) {
            var $elem = $__default["default"]([].slice.call(document.querySelectorAll(selector)));

            if (!$elem.hasClass(CLASS_NAME_SHOW$6)) {
              $__default["default"](trigger).addClass(CLASS_NAME_COLLAPSED).attr('aria-expanded', false);
            }
          }
        }
      }

      this.setTransitioning(true);

      var complete = function complete() {
        _this2.setTransitioning(false);

        $__default["default"](_this2._element).removeClass(CLASS_NAME_COLLAPSING).addClass(CLASS_NAME_COLLAPSE).trigger(EVENT_HIDDEN$4);
      };

      this._element.style[dimension] = '';
      var transitionDuration = Util.getTransitionDurationFromElement(this._element);
      $__default["default"](this._element).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);
    };

    _proto.setTransitioning = function setTransitioning(isTransitioning) {
      this._isTransitioning = isTransitioning;
    };

    _proto.dispose = function dispose() {
      $__default["default"].removeData(this._element, DATA_KEY$7);
      this._config = null;
      this._parent = null;
      this._element = null;
      this._triggerArray = null;
      this._isTransitioning = null;
    } // Private
    ;

    _proto._getConfig = function _getConfig(config) {
      config = _extends({}, Default$6, config);
      config.toggle = Boolean(config.toggle); // Coerce string values

      Util.typeCheckConfig(NAME$7, config, DefaultType$6);
      return config;
    };

    _proto._getDimension = function _getDimension() {
      var hasWidth = $__default["default"](this._element).hasClass(DIMENSION_WIDTH);
      return hasWidth ? DIMENSION_WIDTH : DIMENSION_HEIGHT;
    };

    _proto._getParent = function _getParent() {
      var _this3 = this;

      var parent;

      if (Util.isElement(this._config.parent)) {
        parent = this._config.parent; // It's a jQuery object

        if (typeof this._config.parent.jquery !== 'undefined') {
          parent = this._config.parent[0];
        }
      } else {
        parent = document.querySelector(this._config.parent);
      }

      var selector = "[data-toggle=\"collapse\"][data-parent=\"" + this._config.parent + "\"]";
      var children = [].slice.call(parent.querySelectorAll(selector));
      $__default["default"](children).each(function (i, element) {
        _this3._addAriaAndCollapsedClass(Collapse._getTargetFromElement(element), [element]);
      });
      return parent;
    };

    _proto._addAriaAndCollapsedClass = function _addAriaAndCollapsedClass(element, triggerArray) {
      var isOpen = $__default["default"](element).hasClass(CLASS_NAME_SHOW$6);

      if (triggerArray.length) {
        $__default["default"](triggerArray).toggleClass(CLASS_NAME_COLLAPSED, !isOpen).attr('aria-expanded', isOpen);
      }
    } // Static
    ;

    Collapse._getTargetFromElement = function _getTargetFromElement(element) {
      var selector = Util.getSelectorFromElement(element);
      return selector ? document.querySelector(selector) : null;
    };

    Collapse._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var $element = $__default["default"](this);
        var data = $element.data(DATA_KEY$7);

        var _config = _extends({}, Default$6, $element.data(), typeof config === 'object' && config ? config : {});

        if (!data && _config.toggle && typeof config === 'string' && /show|hide/.test(config)) {
          _config.toggle = false;
        }

        if (!data) {
          data = new Collapse(this, _config);
          $element.data(DATA_KEY$7, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config]();
        }
      });
    };

    _createClass(Collapse, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$7;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default$6;
      }
    }]);

    return Collapse;
  }();
  /**
   * Data API implementation
   */


  $__default["default"](document).on(EVENT_CLICK_DATA_API$3, SELECTOR_DATA_TOGGLE$3, function (event) {
    // preventDefault only for <a> elements (which change the URL) not inside the collapsible element
    if (event.currentTarget.tagName === 'A') {
      event.preventDefault();
    }

    var $trigger = $__default["default"](this);
    var selector = Util.getSelectorFromElement(this);
    var selectors = [].slice.call(document.querySelectorAll(selector));
    $__default["default"](selectors).each(function () {
      var $target = $__default["default"](this);
      var data = $target.data(DATA_KEY$7);
      var config = data ? 'toggle' : $trigger.data();

      Collapse._jQueryInterface.call($target, config);
    });
  });
  /**
   * jQuery
   */

  $__default["default"].fn[NAME$7] = Collapse._jQueryInterface;
  $__default["default"].fn[NAME$7].Constructor = Collapse;

  $__default["default"].fn[NAME$7].noConflict = function () {
    $__default["default"].fn[NAME$7] = JQUERY_NO_CONFLICT$7;
    return Collapse._jQueryInterface;
  };

  /**
   * Constants
   */

  var NAME$6 = 'dropdown';
  var VERSION$6 = '4.6.1';
  var DATA_KEY$6 = 'bs.dropdown';
  var EVENT_KEY$6 = "." + DATA_KEY$6;
  var DATA_API_KEY$3 = '.data-api';
  var JQUERY_NO_CONFLICT$6 = $__default["default"].fn[NAME$6];
  var ESCAPE_KEYCODE$1 = 27; // KeyboardEvent.which value for Escape (Esc) key

  var SPACE_KEYCODE = 32; // KeyboardEvent.which value for space key

  var TAB_KEYCODE = 9; // KeyboardEvent.which value for tab key

  var ARROW_UP_KEYCODE = 38; // KeyboardEvent.which value for up arrow key

  var ARROW_DOWN_KEYCODE = 40; // KeyboardEvent.which value for down arrow key

  var RIGHT_MOUSE_BUTTON_WHICH = 3; // MouseEvent.which value for the right button (assuming a right-handed mouse)

  var REGEXP_KEYDOWN = new RegExp(ARROW_UP_KEYCODE + "|" + ARROW_DOWN_KEYCODE + "|" + ESCAPE_KEYCODE$1);
  var CLASS_NAME_DISABLED$1 = 'disabled';
  var CLASS_NAME_SHOW$5 = 'show';
  var CLASS_NAME_DROPUP = 'dropup';
  var CLASS_NAME_DROPRIGHT = 'dropright';
  var CLASS_NAME_DROPLEFT = 'dropleft';
  var CLASS_NAME_MENURIGHT = 'dropdown-menu-right';
  var CLASS_NAME_POSITION_STATIC = 'position-static';
  var EVENT_HIDE$3 = "hide" + EVENT_KEY$6;
  var EVENT_HIDDEN$3 = "hidden" + EVENT_KEY$6;
  var EVENT_SHOW$3 = "show" + EVENT_KEY$6;
  var EVENT_SHOWN$3 = "shown" + EVENT_KEY$6;
  var EVENT_CLICK = "click" + EVENT_KEY$6;
  var EVENT_CLICK_DATA_API$2 = "click" + EVENT_KEY$6 + DATA_API_KEY$3;
  var EVENT_KEYDOWN_DATA_API = "keydown" + EVENT_KEY$6 + DATA_API_KEY$3;
  var EVENT_KEYUP_DATA_API = "keyup" + EVENT_KEY$6 + DATA_API_KEY$3;
  var SELECTOR_DATA_TOGGLE$2 = '[data-toggle="dropdown"]';
  var SELECTOR_FORM_CHILD = '.dropdown form';
  var SELECTOR_MENU = '.dropdown-menu';
  var SELECTOR_NAVBAR_NAV = '.navbar-nav';
  var SELECTOR_VISIBLE_ITEMS = '.dropdown-menu .dropdown-item:not(.disabled):not(:disabled)';
  var PLACEMENT_TOP = 'top-start';
  var PLACEMENT_TOPEND = 'top-end';
  var PLACEMENT_BOTTOM = 'bottom-start';
  var PLACEMENT_BOTTOMEND = 'bottom-end';
  var PLACEMENT_RIGHT = 'right-start';
  var PLACEMENT_LEFT = 'left-start';
  var Default$5 = {
    offset: 0,
    flip: true,
    boundary: 'scrollParent',
    reference: 'toggle',
    display: 'dynamic',
    popperConfig: null
  };
  var DefaultType$5 = {
    offset: '(number|string|function)',
    flip: 'boolean',
    boundary: '(string|element)',
    reference: '(string|element)',
    display: 'string',
    popperConfig: '(null|object)'
  };
  /**
   * Class definition
   */

  var Dropdown = /*#__PURE__*/function () {
    function Dropdown(element, config) {
      this._element = element;
      this._popper = null;
      this._config = this._getConfig(config);
      this._menu = this._getMenuElement();
      this._inNavbar = this._detectNavbar();

      this._addEventListeners();
    } // Getters


    var _proto = Dropdown.prototype;

    // Public
    _proto.toggle = function toggle() {
      if (this._element.disabled || $__default["default"](this._element).hasClass(CLASS_NAME_DISABLED$1)) {
        return;
      }

      var isActive = $__default["default"](this._menu).hasClass(CLASS_NAME_SHOW$5);

      Dropdown._clearMenus();

      if (isActive) {
        return;
      }

      this.show(true);
    };

    _proto.show = function show(usePopper) {
      if (usePopper === void 0) {
        usePopper = false;
      }

      if (this._element.disabled || $__default["default"](this._element).hasClass(CLASS_NAME_DISABLED$1) || $__default["default"](this._menu).hasClass(CLASS_NAME_SHOW$5)) {
        return;
      }

      var relatedTarget = {
        relatedTarget: this._element
      };
      var showEvent = $__default["default"].Event(EVENT_SHOW$3, relatedTarget);

      var parent = Dropdown._getParentFromElement(this._element);

      $__default["default"](parent).trigger(showEvent);

      if (showEvent.isDefaultPrevented()) {
        return;
      } // Totally disable Popper for Dropdowns in Navbar


      if (!this._inNavbar && usePopper) {
        // Check for Popper dependency
        if (typeof Popper__default["default"] === 'undefined') {
          throw new TypeError('Bootstrap\'s dropdowns require Popper (https://popper.js.org)');
        }

        var referenceElement = this._element;

        if (this._config.reference === 'parent') {
          referenceElement = parent;
        } else if (Util.isElement(this._config.reference)) {
          referenceElement = this._config.reference; // Check if it's jQuery element

          if (typeof this._config.reference.jquery !== 'undefined') {
            referenceElement = this._config.reference[0];
          }
        } // If boundary is not `scrollParent`, then set position to `static`
        // to allow the menu to "escape" the scroll parent's boundaries
        // https://github.com/twbs/bootstrap/issues/24251


        if (this._config.boundary !== 'scrollParent') {
          $__default["default"](parent).addClass(CLASS_NAME_POSITION_STATIC);
        }

        this._popper = new Popper__default["default"](referenceElement, this._menu, this._getPopperConfig());
      } // If this is a touch-enabled device we add extra
      // empty mouseover listeners to the body's immediate children;
      // only needed because of broken event delegation on iOS
      // https://www.quirksmode.org/blog/archives/2014/02/mouse_event_bub.html


      if ('ontouchstart' in document.documentElement && $__default["default"](parent).closest(SELECTOR_NAVBAR_NAV).length === 0) {
        $__default["default"](document.body).children().on('mouseover', null, $__default["default"].noop);
      }

      this._element.focus();

      this._element.setAttribute('aria-expanded', true);

      $__default["default"](this._menu).toggleClass(CLASS_NAME_SHOW$5);
      $__default["default"](parent).toggleClass(CLASS_NAME_SHOW$5).trigger($__default["default"].Event(EVENT_SHOWN$3, relatedTarget));
    };

    _proto.hide = function hide() {
      if (this._element.disabled || $__default["default"](this._element).hasClass(CLASS_NAME_DISABLED$1) || !$__default["default"](this._menu).hasClass(CLASS_NAME_SHOW$5)) {
        return;
      }

      var relatedTarget = {
        relatedTarget: this._element
      };
      var hideEvent = $__default["default"].Event(EVENT_HIDE$3, relatedTarget);

      var parent = Dropdown._getParentFromElement(this._element);

      $__default["default"](parent).trigger(hideEvent);

      if (hideEvent.isDefaultPrevented()) {
        return;
      }

      if (this._popper) {
        this._popper.destroy();
      }

      $__default["default"](this._menu).toggleClass(CLASS_NAME_SHOW$5);
      $__default["default"](parent).toggleClass(CLASS_NAME_SHOW$5).trigger($__default["default"].Event(EVENT_HIDDEN$3, relatedTarget));
    };

    _proto.dispose = function dispose() {
      $__default["default"].removeData(this._element, DATA_KEY$6);
      $__default["default"](this._element).off(EVENT_KEY$6);
      this._element = null;
      this._menu = null;

      if (this._popper !== null) {
        this._popper.destroy();

        this._popper = null;
      }
    };

    _proto.update = function update() {
      this._inNavbar = this._detectNavbar();

      if (this._popper !== null) {
        this._popper.scheduleUpdate();
      }
    } // Private
    ;

    _proto._addEventListeners = function _addEventListeners() {
      var _this = this;

      $__default["default"](this._element).on(EVENT_CLICK, function (event) {
        event.preventDefault();
        event.stopPropagation();

        _this.toggle();
      });
    };

    _proto._getConfig = function _getConfig(config) {
      config = _extends({}, this.constructor.Default, $__default["default"](this._element).data(), config);
      Util.typeCheckConfig(NAME$6, config, this.constructor.DefaultType);
      return config;
    };

    _proto._getMenuElement = function _getMenuElement() {
      if (!this._menu) {
        var parent = Dropdown._getParentFromElement(this._element);

        if (parent) {
          this._menu = parent.querySelector(SELECTOR_MENU);
        }
      }

      return this._menu;
    };

    _proto._getPlacement = function _getPlacement() {
      var $parentDropdown = $__default["default"](this._element.parentNode);
      var placement = PLACEMENT_BOTTOM; // Handle dropup

      if ($parentDropdown.hasClass(CLASS_NAME_DROPUP)) {
        placement = $__default["default"](this._menu).hasClass(CLASS_NAME_MENURIGHT) ? PLACEMENT_TOPEND : PLACEMENT_TOP;
      } else if ($parentDropdown.hasClass(CLASS_NAME_DROPRIGHT)) {
        placement = PLACEMENT_RIGHT;
      } else if ($parentDropdown.hasClass(CLASS_NAME_DROPLEFT)) {
        placement = PLACEMENT_LEFT;
      } else if ($__default["default"](this._menu).hasClass(CLASS_NAME_MENURIGHT)) {
        placement = PLACEMENT_BOTTOMEND;
      }

      return placement;
    };

    _proto._detectNavbar = function _detectNavbar() {
      return $__default["default"](this._element).closest('.navbar').length > 0;
    };

    _proto._getOffset = function _getOffset() {
      var _this2 = this;

      var offset = {};

      if (typeof this._config.offset === 'function') {
        offset.fn = function (data) {
          data.offsets = _extends({}, data.offsets, _this2._config.offset(data.offsets, _this2._element));
          return data;
        };
      } else {
        offset.offset = this._config.offset;
      }

      return offset;
    };

    _proto._getPopperConfig = function _getPopperConfig() {
      var popperConfig = {
        placement: this._getPlacement(),
        modifiers: {
          offset: this._getOffset(),
          flip: {
            enabled: this._config.flip
          },
          preventOverflow: {
            boundariesElement: this._config.boundary
          }
        }
      }; // Disable Popper if we have a static display

      if (this._config.display === 'static') {
        popperConfig.modifiers.applyStyle = {
          enabled: false
        };
      }

      return _extends({}, popperConfig, this._config.popperConfig);
    } // Static
    ;

    Dropdown._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var data = $__default["default"](this).data(DATA_KEY$6);

        var _config = typeof config === 'object' ? config : null;

        if (!data) {
          data = new Dropdown(this, _config);
          $__default["default"](this).data(DATA_KEY$6, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config]();
        }
      });
    };

    Dropdown._clearMenus = function _clearMenus(event) {
      if (event && (event.which === RIGHT_MOUSE_BUTTON_WHICH || event.type === 'keyup' && event.which !== TAB_KEYCODE)) {
        return;
      }

      var toggles = [].slice.call(document.querySelectorAll(SELECTOR_DATA_TOGGLE$2));

      for (var i = 0, len = toggles.length; i < len; i++) {
        var parent = Dropdown._getParentFromElement(toggles[i]);

        var context = $__default["default"](toggles[i]).data(DATA_KEY$6);
        var relatedTarget = {
          relatedTarget: toggles[i]
        };

        if (event && event.type === 'click') {
          relatedTarget.clickEvent = event;
        }

        if (!context) {
          continue;
        }

        var dropdownMenu = context._menu;

        if (!$__default["default"](parent).hasClass(CLASS_NAME_SHOW$5)) {
          continue;
        }

        if (event && (event.type === 'click' && /input|textarea/i.test(event.target.tagName) || event.type === 'keyup' && event.which === TAB_KEYCODE) && $__default["default"].contains(parent, event.target)) {
          continue;
        }

        var hideEvent = $__default["default"].Event(EVENT_HIDE$3, relatedTarget);
        $__default["default"](parent).trigger(hideEvent);

        if (hideEvent.isDefaultPrevented()) {
          continue;
        } // If this is a touch-enabled device we remove the extra
        // empty mouseover listeners we added for iOS support


        if ('ontouchstart' in document.documentElement) {
          $__default["default"](document.body).children().off('mouseover', null, $__default["default"].noop);
        }

        toggles[i].setAttribute('aria-expanded', 'false');

        if (context._popper) {
          context._popper.destroy();
        }

        $__default["default"](dropdownMenu).removeClass(CLASS_NAME_SHOW$5);
        $__default["default"](parent).removeClass(CLASS_NAME_SHOW$5).trigger($__default["default"].Event(EVENT_HIDDEN$3, relatedTarget));
      }
    };

    Dropdown._getParentFromElement = function _getParentFromElement(element) {
      var parent;
      var selector = Util.getSelectorFromElement(element);

      if (selector) {
        parent = document.querySelector(selector);
      }

      return parent || element.parentNode;
    } // eslint-disable-next-line complexity
    ;

    Dropdown._dataApiKeydownHandler = function _dataApiKeydownHandler(event) {
      // If not input/textarea:
      //  - And not a key in REGEXP_KEYDOWN => not a dropdown command
      // If input/textarea:
      //  - If space key => not a dropdown command
      //  - If key is other than escape
      //    - If key is not up or down => not a dropdown command
      //    - If trigger inside the menu => not a dropdown command
      if (/input|textarea/i.test(event.target.tagName) ? event.which === SPACE_KEYCODE || event.which !== ESCAPE_KEYCODE$1 && (event.which !== ARROW_DOWN_KEYCODE && event.which !== ARROW_UP_KEYCODE || $__default["default"](event.target).closest(SELECTOR_MENU).length) : !REGEXP_KEYDOWN.test(event.which)) {
        return;
      }

      if (this.disabled || $__default["default"](this).hasClass(CLASS_NAME_DISABLED$1)) {
        return;
      }

      var parent = Dropdown._getParentFromElement(this);

      var isActive = $__default["default"](parent).hasClass(CLASS_NAME_SHOW$5);

      if (!isActive && event.which === ESCAPE_KEYCODE$1) {
        return;
      }

      event.preventDefault();
      event.stopPropagation();

      if (!isActive || event.which === ESCAPE_KEYCODE$1 || event.which === SPACE_KEYCODE) {
        if (event.which === ESCAPE_KEYCODE$1) {
          $__default["default"](parent.querySelector(SELECTOR_DATA_TOGGLE$2)).trigger('focus');
        }

        $__default["default"](this).trigger('click');
        return;
      }

      var items = [].slice.call(parent.querySelectorAll(SELECTOR_VISIBLE_ITEMS)).filter(function (item) {
        return $__default["default"](item).is(':visible');
      });

      if (items.length === 0) {
        return;
      }

      var index = items.indexOf(event.target);

      if (event.which === ARROW_UP_KEYCODE && index > 0) {
        // Up
        index--;
      }

      if (event.which === ARROW_DOWN_KEYCODE && index < items.length - 1) {
        // Down
        index++;
      }

      if (index < 0) {
        index = 0;
      }

      items[index].focus();
    };

    _createClass(Dropdown, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$6;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default$5;
      }
    }, {
      key: "DefaultType",
      get: function get() {
        return DefaultType$5;
      }
    }]);

    return Dropdown;
  }();
  /**
   * Data API implementation
   */


  $__default["default"](document).on(EVENT_KEYDOWN_DATA_API, SELECTOR_DATA_TOGGLE$2, Dropdown._dataApiKeydownHandler).on(EVENT_KEYDOWN_DATA_API, SELECTOR_MENU, Dropdown._dataApiKeydownHandler).on(EVENT_CLICK_DATA_API$2 + " " + EVENT_KEYUP_DATA_API, Dropdown._clearMenus).on(EVENT_CLICK_DATA_API$2, SELECTOR_DATA_TOGGLE$2, function (event) {
    event.preventDefault();
    event.stopPropagation();

    Dropdown._jQueryInterface.call($__default["default"](this), 'toggle');
  }).on(EVENT_CLICK_DATA_API$2, SELECTOR_FORM_CHILD, function (e) {
    e.stopPropagation();
  });
  /**
   * jQuery
   */

  $__default["default"].fn[NAME$6] = Dropdown._jQueryInterface;
  $__default["default"].fn[NAME$6].Constructor = Dropdown;

  $__default["default"].fn[NAME$6].noConflict = function () {
    $__default["default"].fn[NAME$6] = JQUERY_NO_CONFLICT$6;
    return Dropdown._jQueryInterface;
  };

  /**
   * Constants
   */

  var NAME$5 = 'modal';
  var VERSION$5 = '4.6.1';
  var DATA_KEY$5 = 'bs.modal';
  var EVENT_KEY$5 = "." + DATA_KEY$5;
  var DATA_API_KEY$2 = '.data-api';
  var JQUERY_NO_CONFLICT$5 = $__default["default"].fn[NAME$5];
  var ESCAPE_KEYCODE = 27; // KeyboardEvent.which value for Escape (Esc) key

  var CLASS_NAME_SCROLLABLE = 'modal-dialog-scrollable';
  var CLASS_NAME_SCROLLBAR_MEASURER = 'modal-scrollbar-measure';
  var CLASS_NAME_BACKDROP = 'modal-backdrop';
  var CLASS_NAME_OPEN = 'modal-open';
  var CLASS_NAME_FADE$4 = 'fade';
  var CLASS_NAME_SHOW$4 = 'show';
  var CLASS_NAME_STATIC = 'modal-static';
  var EVENT_HIDE$2 = "hide" + EVENT_KEY$5;
  var EVENT_HIDE_PREVENTED = "hidePrevented" + EVENT_KEY$5;
  var EVENT_HIDDEN$2 = "hidden" + EVENT_KEY$5;
  var EVENT_SHOW$2 = "show" + EVENT_KEY$5;
  var EVENT_SHOWN$2 = "shown" + EVENT_KEY$5;
  var EVENT_FOCUSIN = "focusin" + EVENT_KEY$5;
  var EVENT_RESIZE = "resize" + EVENT_KEY$5;
  var EVENT_CLICK_DISMISS$1 = "click.dismiss" + EVENT_KEY$5;
  var EVENT_KEYDOWN_DISMISS = "keydown.dismiss" + EVENT_KEY$5;
  var EVENT_MOUSEUP_DISMISS = "mouseup.dismiss" + EVENT_KEY$5;
  var EVENT_MOUSEDOWN_DISMISS = "mousedown.dismiss" + EVENT_KEY$5;
  var EVENT_CLICK_DATA_API$1 = "click" + EVENT_KEY$5 + DATA_API_KEY$2;
  var SELECTOR_DIALOG = '.modal-dialog';
  var SELECTOR_MODAL_BODY = '.modal-body';
  var SELECTOR_DATA_TOGGLE$1 = '[data-toggle="modal"]';
  var SELECTOR_DATA_DISMISS$1 = '[data-dismiss="modal"]';
  var SELECTOR_FIXED_CONTENT = '.fixed-top, .fixed-bottom, .is-fixed, .sticky-top';
  var SELECTOR_STICKY_CONTENT = '.sticky-top';
  var Default$4 = {
    backdrop: true,
    keyboard: true,
    focus: true,
    show: true
  };
  var DefaultType$4 = {
    backdrop: '(boolean|string)',
    keyboard: 'boolean',
    focus: 'boolean',
    show: 'boolean'
  };
  /**
   * Class definition
   */

  var Modal = /*#__PURE__*/function () {
    function Modal(element, config) {
      this._config = this._getConfig(config);
      this._element = element;
      this._dialog = element.querySelector(SELECTOR_DIALOG);
      this._backdrop = null;
      this._isShown = false;
      this._isBodyOverflowing = false;
      this._ignoreBackdropClick = false;
      this._isTransitioning = false;
      this._scrollbarWidth = 0;
    } // Getters


    var _proto = Modal.prototype;

    // Public
    _proto.toggle = function toggle(relatedTarget) {
      return this._isShown ? this.hide() : this.show(relatedTarget);
    };

    _proto.show = function show(relatedTarget) {
      var _this = this;

      if (this._isShown || this._isTransitioning) {
        return;
      }

      var showEvent = $__default["default"].Event(EVENT_SHOW$2, {
        relatedTarget: relatedTarget
      });
      $__default["default"](this._element).trigger(showEvent);

      if (showEvent.isDefaultPrevented()) {
        return;
      }

      this._isShown = true;

      if ($__default["default"](this._element).hasClass(CLASS_NAME_FADE$4)) {
        this._isTransitioning = true;
      }

      this._checkScrollbar();

      this._setScrollbar();

      this._adjustDialog();

      this._setEscapeEvent();

      this._setResizeEvent();

      $__default["default"](this._element).on(EVENT_CLICK_DISMISS$1, SELECTOR_DATA_DISMISS$1, function (event) {
        return _this.hide(event);
      });
      $__default["default"](this._dialog).on(EVENT_MOUSEDOWN_DISMISS, function () {
        $__default["default"](_this._element).one(EVENT_MOUSEUP_DISMISS, function (event) {
          if ($__default["default"](event.target).is(_this._element)) {
            _this._ignoreBackdropClick = true;
          }
        });
      });

      this._showBackdrop(function () {
        return _this._showElement(relatedTarget);
      });
    };

    _proto.hide = function hide(event) {
      var _this2 = this;

      if (event) {
        event.preventDefault();
      }

      if (!this._isShown || this._isTransitioning) {
        return;
      }

      var hideEvent = $__default["default"].Event(EVENT_HIDE$2);
      $__default["default"](this._element).trigger(hideEvent);

      if (!this._isShown || hideEvent.isDefaultPrevented()) {
        return;
      }

      this._isShown = false;
      var transition = $__default["default"](this._element).hasClass(CLASS_NAME_FADE$4);

      if (transition) {
        this._isTransitioning = true;
      }

      this._setEscapeEvent();

      this._setResizeEvent();

      $__default["default"](document).off(EVENT_FOCUSIN);
      $__default["default"](this._element).removeClass(CLASS_NAME_SHOW$4);
      $__default["default"](this._element).off(EVENT_CLICK_DISMISS$1);
      $__default["default"](this._dialog).off(EVENT_MOUSEDOWN_DISMISS);

      if (transition) {
        var transitionDuration = Util.getTransitionDurationFromElement(this._element);
        $__default["default"](this._element).one(Util.TRANSITION_END, function (event) {
          return _this2._hideModal(event);
        }).emulateTransitionEnd(transitionDuration);
      } else {
        this._hideModal();
      }
    };

    _proto.dispose = function dispose() {
      [window, this._element, this._dialog].forEach(function (htmlElement) {
        return $__default["default"](htmlElement).off(EVENT_KEY$5);
      });
      /**
       * `document` has 2 events `EVENT_FOCUSIN` and `EVENT_CLICK_DATA_API`
       * Do not move `document` in `htmlElements` array
       * It will remove `EVENT_CLICK_DATA_API` event that should remain
       */

      $__default["default"](document).off(EVENT_FOCUSIN);
      $__default["default"].removeData(this._element, DATA_KEY$5);
      this._config = null;
      this._element = null;
      this._dialog = null;
      this._backdrop = null;
      this._isShown = null;
      this._isBodyOverflowing = null;
      this._ignoreBackdropClick = null;
      this._isTransitioning = null;
      this._scrollbarWidth = null;
    };

    _proto.handleUpdate = function handleUpdate() {
      this._adjustDialog();
    } // Private
    ;

    _proto._getConfig = function _getConfig(config) {
      config = _extends({}, Default$4, config);
      Util.typeCheckConfig(NAME$5, config, DefaultType$4);
      return config;
    };

    _proto._triggerBackdropTransition = function _triggerBackdropTransition() {
      var _this3 = this;

      var hideEventPrevented = $__default["default"].Event(EVENT_HIDE_PREVENTED);
      $__default["default"](this._element).trigger(hideEventPrevented);

      if (hideEventPrevented.isDefaultPrevented()) {
        return;
      }

      var isModalOverflowing = this._element.scrollHeight > document.documentElement.clientHeight;

      if (!isModalOverflowing) {
        this._element.style.overflowY = 'hidden';
      }

      this._element.classList.add(CLASS_NAME_STATIC);

      var modalTransitionDuration = Util.getTransitionDurationFromElement(this._dialog);
      $__default["default"](this._element).off(Util.TRANSITION_END);
      $__default["default"](this._element).one(Util.TRANSITION_END, function () {
        _this3._element.classList.remove(CLASS_NAME_STATIC);

        if (!isModalOverflowing) {
          $__default["default"](_this3._element).one(Util.TRANSITION_END, function () {
            _this3._element.style.overflowY = '';
          }).emulateTransitionEnd(_this3._element, modalTransitionDuration);
        }
      }).emulateTransitionEnd(modalTransitionDuration);

      this._element.focus();
    };

    _proto._showElement = function _showElement(relatedTarget) {
      var _this4 = this;

      var transition = $__default["default"](this._element).hasClass(CLASS_NAME_FADE$4);
      var modalBody = this._dialog ? this._dialog.querySelector(SELECTOR_MODAL_BODY) : null;

      if (!this._element.parentNode || this._element.parentNode.nodeType !== Node.ELEMENT_NODE) {
        // Don't move modal's DOM position
        document.body.appendChild(this._element);
      }

      this._element.style.display = 'block';

      this._element.removeAttribute('aria-hidden');

      this._element.setAttribute('aria-modal', true);

      this._element.setAttribute('role', 'dialog');

      if ($__default["default"](this._dialog).hasClass(CLASS_NAME_SCROLLABLE) && modalBody) {
        modalBody.scrollTop = 0;
      } else {
        this._element.scrollTop = 0;
      }

      if (transition) {
        Util.reflow(this._element);
      }

      $__default["default"](this._element).addClass(CLASS_NAME_SHOW$4);

      if (this._config.focus) {
        this._enforceFocus();
      }

      var shownEvent = $__default["default"].Event(EVENT_SHOWN$2, {
        relatedTarget: relatedTarget
      });

      var transitionComplete = function transitionComplete() {
        if (_this4._config.focus) {
          _this4._element.focus();
        }

        _this4._isTransitioning = false;
        $__default["default"](_this4._element).trigger(shownEvent);
      };

      if (transition) {
        var transitionDuration = Util.getTransitionDurationFromElement(this._dialog);
        $__default["default"](this._dialog).one(Util.TRANSITION_END, transitionComplete).emulateTransitionEnd(transitionDuration);
      } else {
        transitionComplete();
      }
    };

    _proto._enforceFocus = function _enforceFocus() {
      var _this5 = this;

      $__default["default"](document).off(EVENT_FOCUSIN) // Guard against infinite focus loop
      .on(EVENT_FOCUSIN, function (event) {
        if (document !== event.target && _this5._element !== event.target && $__default["default"](_this5._element).has(event.target).length === 0) {
          _this5._element.focus();
        }
      });
    };

    _proto._setEscapeEvent = function _setEscapeEvent() {
      var _this6 = this;

      if (this._isShown) {
        $__default["default"](this._element).on(EVENT_KEYDOWN_DISMISS, function (event) {
          if (_this6._config.keyboard && event.which === ESCAPE_KEYCODE) {
            event.preventDefault();

            _this6.hide();
          } else if (!_this6._config.keyboard && event.which === ESCAPE_KEYCODE) {
            _this6._triggerBackdropTransition();
          }
        });
      } else if (!this._isShown) {
        $__default["default"](this._element).off(EVENT_KEYDOWN_DISMISS);
      }
    };

    _proto._setResizeEvent = function _setResizeEvent() {
      var _this7 = this;

      if (this._isShown) {
        $__default["default"](window).on(EVENT_RESIZE, function (event) {
          return _this7.handleUpdate(event);
        });
      } else {
        $__default["default"](window).off(EVENT_RESIZE);
      }
    };

    _proto._hideModal = function _hideModal() {
      var _this8 = this;

      this._element.style.display = 'none';

      this._element.setAttribute('aria-hidden', true);

      this._element.removeAttribute('aria-modal');

      this._element.removeAttribute('role');

      this._isTransitioning = false;

      this._showBackdrop(function () {
        $__default["default"](document.body).removeClass(CLASS_NAME_OPEN);

        _this8._resetAdjustments();

        _this8._resetScrollbar();

        $__default["default"](_this8._element).trigger(EVENT_HIDDEN$2);
      });
    };

    _proto._removeBackdrop = function _removeBackdrop() {
      if (this._backdrop) {
        $__default["default"](this._backdrop).remove();
        this._backdrop = null;
      }
    };

    _proto._showBackdrop = function _showBackdrop(callback) {
      var _this9 = this;

      var animate = $__default["default"](this._element).hasClass(CLASS_NAME_FADE$4) ? CLASS_NAME_FADE$4 : '';

      if (this._isShown && this._config.backdrop) {
        this._backdrop = document.createElement('div');
        this._backdrop.className = CLASS_NAME_BACKDROP;

        if (animate) {
          this._backdrop.classList.add(animate);
        }

        $__default["default"](this._backdrop).appendTo(document.body);
        $__default["default"](this._element).on(EVENT_CLICK_DISMISS$1, function (event) {
          if (_this9._ignoreBackdropClick) {
            _this9._ignoreBackdropClick = false;
            return;
          }

          if (event.target !== event.currentTarget) {
            return;
          }

          if (_this9._config.backdrop === 'static') {
            _this9._triggerBackdropTransition();
          } else {
            _this9.hide();
          }
        });

        if (animate) {
          Util.reflow(this._backdrop);
        }

        $__default["default"](this._backdrop).addClass(CLASS_NAME_SHOW$4);

        if (!callback) {
          return;
        }

        if (!animate) {
          callback();
          return;
        }

        var backdropTransitionDuration = Util.getTransitionDurationFromElement(this._backdrop);
        $__default["default"](this._backdrop).one(Util.TRANSITION_END, callback).emulateTransitionEnd(backdropTransitionDuration);
      } else if (!this._isShown && this._backdrop) {
        $__default["default"](this._backdrop).removeClass(CLASS_NAME_SHOW$4);

        var callbackRemove = function callbackRemove() {
          _this9._removeBackdrop();

          if (callback) {
            callback();
          }
        };

        if ($__default["default"](this._element).hasClass(CLASS_NAME_FADE$4)) {
          var _backdropTransitionDuration = Util.getTransitionDurationFromElement(this._backdrop);

          $__default["default"](this._backdrop).one(Util.TRANSITION_END, callbackRemove).emulateTransitionEnd(_backdropTransitionDuration);
        } else {
          callbackRemove();
        }
      } else if (callback) {
        callback();
      }
    } // ----------------------------------------------------------------------
    // the following methods are used to handle overflowing modals
    // todo (fat): these should probably be refactored out of modal.js
    // ----------------------------------------------------------------------
    ;

    _proto._adjustDialog = function _adjustDialog() {
      var isModalOverflowing = this._element.scrollHeight > document.documentElement.clientHeight;

      if (!this._isBodyOverflowing && isModalOverflowing) {
        this._element.style.paddingLeft = this._scrollbarWidth + "px";
      }

      if (this._isBodyOverflowing && !isModalOverflowing) {
        this._element.style.paddingRight = this._scrollbarWidth + "px";
      }
    };

    _proto._resetAdjustments = function _resetAdjustments() {
      this._element.style.paddingLeft = '';
      this._element.style.paddingRight = '';
    };

    _proto._checkScrollbar = function _checkScrollbar() {
      var rect = document.body.getBoundingClientRect();
      this._isBodyOverflowing = Math.round(rect.left + rect.right) < window.innerWidth;
      this._scrollbarWidth = this._getScrollbarWidth();
    };

    _proto._setScrollbar = function _setScrollbar() {
      var _this10 = this;

      if (this._isBodyOverflowing) {
        // Note: DOMNode.style.paddingRight returns the actual value or '' if not set
        //   while $(DOMNode).css('padding-right') returns the calculated value or 0 if not set
        var fixedContent = [].slice.call(document.querySelectorAll(SELECTOR_FIXED_CONTENT));
        var stickyContent = [].slice.call(document.querySelectorAll(SELECTOR_STICKY_CONTENT)); // Adjust fixed content padding

        $__default["default"](fixedContent).each(function (index, element) {
          var actualPadding = element.style.paddingRight;
          var calculatedPadding = $__default["default"](element).css('padding-right');
          $__default["default"](element).data('padding-right', actualPadding).css('padding-right', parseFloat(calculatedPadding) + _this10._scrollbarWidth + "px");
        }); // Adjust sticky content margin

        $__default["default"](stickyContent).each(function (index, element) {
          var actualMargin = element.style.marginRight;
          var calculatedMargin = $__default["default"](element).css('margin-right');
          $__default["default"](element).data('margin-right', actualMargin).css('margin-right', parseFloat(calculatedMargin) - _this10._scrollbarWidth + "px");
        }); // Adjust body padding

        var actualPadding = document.body.style.paddingRight;
        var calculatedPadding = $__default["default"](document.body).css('padding-right');
        $__default["default"](document.body).data('padding-right', actualPadding).css('padding-right', parseFloat(calculatedPadding) + this._scrollbarWidth + "px");
      }

      $__default["default"](document.body).addClass(CLASS_NAME_OPEN);
    };

    _proto._resetScrollbar = function _resetScrollbar() {
      // Restore fixed content padding
      var fixedContent = [].slice.call(document.querySelectorAll(SELECTOR_FIXED_CONTENT));
      $__default["default"](fixedContent).each(function (index, element) {
        var padding = $__default["default"](element).data('padding-right');
        $__default["default"](element).removeData('padding-right');
        element.style.paddingRight = padding ? padding : '';
      }); // Restore sticky content

      var elements = [].slice.call(document.querySelectorAll("" + SELECTOR_STICKY_CONTENT));
      $__default["default"](elements).each(function (index, element) {
        var margin = $__default["default"](element).data('margin-right');

        if (typeof margin !== 'undefined') {
          $__default["default"](element).css('margin-right', margin).removeData('margin-right');
        }
      }); // Restore body padding

      var padding = $__default["default"](document.body).data('padding-right');
      $__default["default"](document.body).removeData('padding-right');
      document.body.style.paddingRight = padding ? padding : '';
    };

    _proto._getScrollbarWidth = function _getScrollbarWidth() {
      // thx d.walsh
      var scrollDiv = document.createElement('div');
      scrollDiv.className = CLASS_NAME_SCROLLBAR_MEASURER;
      document.body.appendChild(scrollDiv);
      var scrollbarWidth = scrollDiv.getBoundingClientRect().width - scrollDiv.clientWidth;
      document.body.removeChild(scrollDiv);
      return scrollbarWidth;
    } // Static
    ;

    Modal._jQueryInterface = function _jQueryInterface(config, relatedTarget) {
      return this.each(function () {
        var data = $__default["default"](this).data(DATA_KEY$5);

        var _config = _extends({}, Default$4, $__default["default"](this).data(), typeof config === 'object' && config ? config : {});

        if (!data) {
          data = new Modal(this, _config);
          $__default["default"](this).data(DATA_KEY$5, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config](relatedTarget);
        } else if (_config.show) {
          data.show(relatedTarget);
        }
      });
    };

    _createClass(Modal, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$5;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default$4;
      }
    }]);

    return Modal;
  }();
  /**
   * Data API implementation
   */


  $__default["default"](document).on(EVENT_CLICK_DATA_API$1, SELECTOR_DATA_TOGGLE$1, function (event) {
    var _this11 = this;

    var target;
    var selector = Util.getSelectorFromElement(this);

    if (selector) {
      target = document.querySelector(selector);
    }

    var config = $__default["default"](target).data(DATA_KEY$5) ? 'toggle' : _extends({}, $__default["default"](target).data(), $__default["default"](this).data());

    if (this.tagName === 'A' || this.tagName === 'AREA') {
      event.preventDefault();
    }

    var $target = $__default["default"](target).one(EVENT_SHOW$2, function (showEvent) {
      if (showEvent.isDefaultPrevented()) {
        // Only register focus restorer if modal will actually get shown
        return;
      }

      $target.one(EVENT_HIDDEN$2, function () {
        if ($__default["default"](_this11).is(':visible')) {
          _this11.focus();
        }
      });
    });

    Modal._jQueryInterface.call($__default["default"](target), config, this);
  });
  /**
   * jQuery
   */

  $__default["default"].fn[NAME$5] = Modal._jQueryInterface;
  $__default["default"].fn[NAME$5].Constructor = Modal;

  $__default["default"].fn[NAME$5].noConflict = function () {
    $__default["default"].fn[NAME$5] = JQUERY_NO_CONFLICT$5;
    return Modal._jQueryInterface;
  };

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v4.6.1): tools/sanitizer.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  var uriAttrs = ['background', 'cite', 'href', 'itemtype', 'longdesc', 'poster', 'src', 'xlink:href'];
  var ARIA_ATTRIBUTE_PATTERN = /^aria-[\w-]*$/i;
  var DefaultWhitelist = {
    // Global attributes allowed on any supplied element below.
    '*': ['class', 'dir', 'id', 'lang', 'role', ARIA_ATTRIBUTE_PATTERN],
    a: ['target', 'href', 'title', 'rel'],
    area: [],
    b: [],
    br: [],
    col: [],
    code: [],
    div: [],
    em: [],
    hr: [],
    h1: [],
    h2: [],
    h3: [],
    h4: [],
    h5: [],
    h6: [],
    i: [],
    img: ['src', 'srcset', 'alt', 'title', 'width', 'height'],
    li: [],
    ol: [],
    p: [],
    pre: [],
    s: [],
    small: [],
    span: [],
    sub: [],
    sup: [],
    strong: [],
    u: [],
    ul: []
  };
  /**
   * A pattern that recognizes a commonly useful subset of URLs that are safe.
   *
   * Shoutout to Angular https://github.com/angular/angular/blob/12.2.x/packages/core/src/sanitization/url_sanitizer.ts
   */

  var SAFE_URL_PATTERN = /^(?:(?:https?|mailto|ftp|tel|file|sms):|[^#&/:?]*(?:[#/?]|$))/i;
  /**
   * A pattern that matches safe data URLs. Only matches image, video and audio types.
   *
   * Shoutout to Angular https://github.com/angular/angular/blob/12.2.x/packages/core/src/sanitization/url_sanitizer.ts
   */

  var DATA_URL_PATTERN = /^data:(?:image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\/(?:mpeg|mp4|ogg|webm)|audio\/(?:mp3|oga|ogg|opus));base64,[\d+/a-z]+=*$/i;

  function allowedAttribute(attr, allowedAttributeList) {
    var attrName = attr.nodeName.toLowerCase();

    if (allowedAttributeList.indexOf(attrName) !== -1) {
      if (uriAttrs.indexOf(attrName) !== -1) {
        return Boolean(SAFE_URL_PATTERN.test(attr.nodeValue) || DATA_URL_PATTERN.test(attr.nodeValue));
      }

      return true;
    }

    var regExp = allowedAttributeList.filter(function (attrRegex) {
      return attrRegex instanceof RegExp;
    }); // Check if a regular expression validates the attribute.

    for (var i = 0, len = regExp.length; i < len; i++) {
      if (regExp[i].test(attrName)) {
        return true;
      }
    }

    return false;
  }

  function sanitizeHtml(unsafeHtml, whiteList, sanitizeFn) {
    if (unsafeHtml.length === 0) {
      return unsafeHtml;
    }

    if (sanitizeFn && typeof sanitizeFn === 'function') {
      return sanitizeFn(unsafeHtml);
    }

    var domParser = new window.DOMParser();
    var createdDocument = domParser.parseFromString(unsafeHtml, 'text/html');
    var whitelistKeys = Object.keys(whiteList);
    var elements = [].slice.call(createdDocument.body.querySelectorAll('*'));

    var _loop = function _loop(i, len) {
      var el = elements[i];
      var elName = el.nodeName.toLowerCase();

      if (whitelistKeys.indexOf(el.nodeName.toLowerCase()) === -1) {
        el.parentNode.removeChild(el);
        return "continue";
      }

      var attributeList = [].slice.call(el.attributes); // eslint-disable-next-line unicorn/prefer-spread

      var whitelistedAttributes = [].concat(whiteList['*'] || [], whiteList[elName] || []);
      attributeList.forEach(function (attr) {
        if (!allowedAttribute(attr, whitelistedAttributes)) {
          el.removeAttribute(attr.nodeName);
        }
      });
    };

    for (var i = 0, len = elements.length; i < len; i++) {
      var _ret = _loop(i);

      if (_ret === "continue") continue;
    }

    return createdDocument.body.innerHTML;
  }

  /**
   * Constants
   */

  var NAME$4 = 'tooltip';
  var VERSION$4 = '4.6.1';
  var DATA_KEY$4 = 'bs.tooltip';
  var EVENT_KEY$4 = "." + DATA_KEY$4;
  var JQUERY_NO_CONFLICT$4 = $__default["default"].fn[NAME$4];
  var CLASS_PREFIX$1 = 'bs-tooltip';
  var BSCLS_PREFIX_REGEX$1 = new RegExp("(^|\\s)" + CLASS_PREFIX$1 + "\\S+", 'g');
  var DISALLOWED_ATTRIBUTES = ['sanitize', 'whiteList', 'sanitizeFn'];
  var CLASS_NAME_FADE$3 = 'fade';
  var CLASS_NAME_SHOW$3 = 'show';
  var HOVER_STATE_SHOW = 'show';
  var HOVER_STATE_OUT = 'out';
  var SELECTOR_TOOLTIP_INNER = '.tooltip-inner';
  var SELECTOR_ARROW = '.arrow';
  var TRIGGER_HOVER = 'hover';
  var TRIGGER_FOCUS = 'focus';
  var TRIGGER_CLICK = 'click';
  var TRIGGER_MANUAL = 'manual';
  var AttachmentMap = {
    AUTO: 'auto',
    TOP: 'top',
    RIGHT: 'right',
    BOTTOM: 'bottom',
    LEFT: 'left'
  };
  var Default$3 = {
    animation: true,
    template: '<div class="tooltip" role="tooltip">' + '<div class="arrow"></div>' + '<div class="tooltip-inner"></div></div>',
    trigger: 'hover focus',
    title: '',
    delay: 0,
    html: false,
    selector: false,
    placement: 'top',
    offset: 0,
    container: false,
    fallbackPlacement: 'flip',
    boundary: 'scrollParent',
    customClass: '',
    sanitize: true,
    sanitizeFn: null,
    whiteList: DefaultWhitelist,
    popperConfig: null
  };
  var DefaultType$3 = {
    animation: 'boolean',
    template: 'string',
    title: '(string|element|function)',
    trigger: 'string',
    delay: '(number|object)',
    html: 'boolean',
    selector: '(string|boolean)',
    placement: '(string|function)',
    offset: '(number|string|function)',
    container: '(string|element|boolean)',
    fallbackPlacement: '(string|array)',
    boundary: '(string|element)',
    customClass: '(string|function)',
    sanitize: 'boolean',
    sanitizeFn: '(null|function)',
    whiteList: 'object',
    popperConfig: '(null|object)'
  };
  var Event$1 = {
    HIDE: "hide" + EVENT_KEY$4,
    HIDDEN: "hidden" + EVENT_KEY$4,
    SHOW: "show" + EVENT_KEY$4,
    SHOWN: "shown" + EVENT_KEY$4,
    INSERTED: "inserted" + EVENT_KEY$4,
    CLICK: "click" + EVENT_KEY$4,
    FOCUSIN: "focusin" + EVENT_KEY$4,
    FOCUSOUT: "focusout" + EVENT_KEY$4,
    MOUSEENTER: "mouseenter" + EVENT_KEY$4,
    MOUSELEAVE: "mouseleave" + EVENT_KEY$4
  };
  /**
   * Class definition
   */

  var Tooltip = /*#__PURE__*/function () {
    function Tooltip(element, config) {
      if (typeof Popper__default["default"] === 'undefined') {
        throw new TypeError('Bootstrap\'s tooltips require Popper (https://popper.js.org)');
      } // Private


      this._isEnabled = true;
      this._timeout = 0;
      this._hoverState = '';
      this._activeTrigger = {};
      this._popper = null; // Protected

      this.element = element;
      this.config = this._getConfig(config);
      this.tip = null;

      this._setListeners();
    } // Getters


    var _proto = Tooltip.prototype;

    // Public
    _proto.enable = function enable() {
      this._isEnabled = true;
    };

    _proto.disable = function disable() {
      this._isEnabled = false;
    };

    _proto.toggleEnabled = function toggleEnabled() {
      this._isEnabled = !this._isEnabled;
    };

    _proto.toggle = function toggle(event) {
      if (!this._isEnabled) {
        return;
      }

      if (event) {
        var dataKey = this.constructor.DATA_KEY;
        var context = $__default["default"](event.currentTarget).data(dataKey);

        if (!context) {
          context = new this.constructor(event.currentTarget, this._getDelegateConfig());
          $__default["default"](event.currentTarget).data(dataKey, context);
        }

        context._activeTrigger.click = !context._activeTrigger.click;

        if (context._isWithActiveTrigger()) {
          context._enter(null, context);
        } else {
          context._leave(null, context);
        }
      } else {
        if ($__default["default"](this.getTipElement()).hasClass(CLASS_NAME_SHOW$3)) {
          this._leave(null, this);

          return;
        }

        this._enter(null, this);
      }
    };

    _proto.dispose = function dispose() {
      clearTimeout(this._timeout);
      $__default["default"].removeData(this.element, this.constructor.DATA_KEY);
      $__default["default"](this.element).off(this.constructor.EVENT_KEY);
      $__default["default"](this.element).closest('.modal').off('hide.bs.modal', this._hideModalHandler);

      if (this.tip) {
        $__default["default"](this.tip).remove();
      }

      this._isEnabled = null;
      this._timeout = null;
      this._hoverState = null;
      this._activeTrigger = null;

      if (this._popper) {
        this._popper.destroy();
      }

      this._popper = null;
      this.element = null;
      this.config = null;
      this.tip = null;
    };

    _proto.show = function show() {
      var _this = this;

      if ($__default["default"](this.element).css('display') === 'none') {
        throw new Error('Please use show on visible elements');
      }

      var showEvent = $__default["default"].Event(this.constructor.Event.SHOW);

      if (this.isWithContent() && this._isEnabled) {
        $__default["default"](this.element).trigger(showEvent);
        var shadowRoot = Util.findShadowRoot(this.element);
        var isInTheDom = $__default["default"].contains(shadowRoot !== null ? shadowRoot : this.element.ownerDocument.documentElement, this.element);

        if (showEvent.isDefaultPrevented() || !isInTheDom) {
          return;
        }

        var tip = this.getTipElement();
        var tipId = Util.getUID(this.constructor.NAME);
        tip.setAttribute('id', tipId);
        this.element.setAttribute('aria-describedby', tipId);
        this.setContent();

        if (this.config.animation) {
          $__default["default"](tip).addClass(CLASS_NAME_FADE$3);
        }

        var placement = typeof this.config.placement === 'function' ? this.config.placement.call(this, tip, this.element) : this.config.placement;

        var attachment = this._getAttachment(placement);

        this.addAttachmentClass(attachment);

        var container = this._getContainer();

        $__default["default"](tip).data(this.constructor.DATA_KEY, this);

        if (!$__default["default"].contains(this.element.ownerDocument.documentElement, this.tip)) {
          $__default["default"](tip).appendTo(container);
        }

        $__default["default"](this.element).trigger(this.constructor.Event.INSERTED);
        this._popper = new Popper__default["default"](this.element, tip, this._getPopperConfig(attachment));
        $__default["default"](tip).addClass(CLASS_NAME_SHOW$3);
        $__default["default"](tip).addClass(this.config.customClass); // If this is a touch-enabled device we add extra
        // empty mouseover listeners to the body's immediate children;
        // only needed because of broken event delegation on iOS
        // https://www.quirksmode.org/blog/archives/2014/02/mouse_event_bub.html

        if ('ontouchstart' in document.documentElement) {
          $__default["default"](document.body).children().on('mouseover', null, $__default["default"].noop);
        }

        var complete = function complete() {
          if (_this.config.animation) {
            _this._fixTransition();
          }

          var prevHoverState = _this._hoverState;
          _this._hoverState = null;
          $__default["default"](_this.element).trigger(_this.constructor.Event.SHOWN);

          if (prevHoverState === HOVER_STATE_OUT) {
            _this._leave(null, _this);
          }
        };

        if ($__default["default"](this.tip).hasClass(CLASS_NAME_FADE$3)) {
          var transitionDuration = Util.getTransitionDurationFromElement(this.tip);
          $__default["default"](this.tip).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);
        } else {
          complete();
        }
      }
    };

    _proto.hide = function hide(callback) {
      var _this2 = this;

      var tip = this.getTipElement();
      var hideEvent = $__default["default"].Event(this.constructor.Event.HIDE);

      var complete = function complete() {
        if (_this2._hoverState !== HOVER_STATE_SHOW && tip.parentNode) {
          tip.parentNode.removeChild(tip);
        }

        _this2._cleanTipClass();

        _this2.element.removeAttribute('aria-describedby');

        $__default["default"](_this2.element).trigger(_this2.constructor.Event.HIDDEN);

        if (_this2._popper !== null) {
          _this2._popper.destroy();
        }

        if (callback) {
          callback();
        }
      };

      $__default["default"](this.element).trigger(hideEvent);

      if (hideEvent.isDefaultPrevented()) {
        return;
      }

      $__default["default"](tip).removeClass(CLASS_NAME_SHOW$3); // If this is a touch-enabled device we remove the extra
      // empty mouseover listeners we added for iOS support

      if ('ontouchstart' in document.documentElement) {
        $__default["default"](document.body).children().off('mouseover', null, $__default["default"].noop);
      }

      this._activeTrigger[TRIGGER_CLICK] = false;
      this._activeTrigger[TRIGGER_FOCUS] = false;
      this._activeTrigger[TRIGGER_HOVER] = false;

      if ($__default["default"](this.tip).hasClass(CLASS_NAME_FADE$3)) {
        var transitionDuration = Util.getTransitionDurationFromElement(tip);
        $__default["default"](tip).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);
      } else {
        complete();
      }

      this._hoverState = '';
    };

    _proto.update = function update() {
      if (this._popper !== null) {
        this._popper.scheduleUpdate();
      }
    } // Protected
    ;

    _proto.isWithContent = function isWithContent() {
      return Boolean(this.getTitle());
    };

    _proto.addAttachmentClass = function addAttachmentClass(attachment) {
      $__default["default"](this.getTipElement()).addClass(CLASS_PREFIX$1 + "-" + attachment);
    };

    _proto.getTipElement = function getTipElement() {
      this.tip = this.tip || $__default["default"](this.config.template)[0];
      return this.tip;
    };

    _proto.setContent = function setContent() {
      var tip = this.getTipElement();
      this.setElementContent($__default["default"](tip.querySelectorAll(SELECTOR_TOOLTIP_INNER)), this.getTitle());
      $__default["default"](tip).removeClass(CLASS_NAME_FADE$3 + " " + CLASS_NAME_SHOW$3);
    };

    _proto.setElementContent = function setElementContent($element, content) {
      if (typeof content === 'object' && (content.nodeType || content.jquery)) {
        // Content is a DOM node or a jQuery
        if (this.config.html) {
          if (!$__default["default"](content).parent().is($element)) {
            $element.empty().append(content);
          }
        } else {
          $element.text($__default["default"](content).text());
        }

        return;
      }

      if (this.config.html) {
        if (this.config.sanitize) {
          content = sanitizeHtml(content, this.config.whiteList, this.config.sanitizeFn);
        }

        $element.html(content);
      } else {
        $element.text(content);
      }
    };

    _proto.getTitle = function getTitle() {
      var title = this.element.getAttribute('data-original-title');

      if (!title) {
        title = typeof this.config.title === 'function' ? this.config.title.call(this.element) : this.config.title;
      }

      return title;
    } // Private
    ;

    _proto._getPopperConfig = function _getPopperConfig(attachment) {
      var _this3 = this;

      var defaultBsConfig = {
        placement: attachment,
        modifiers: {
          offset: this._getOffset(),
          flip: {
            behavior: this.config.fallbackPlacement
          },
          arrow: {
            element: SELECTOR_ARROW
          },
          preventOverflow: {
            boundariesElement: this.config.boundary
          }
        },
        onCreate: function onCreate(data) {
          if (data.originalPlacement !== data.placement) {
            _this3._handlePopperPlacementChange(data);
          }
        },
        onUpdate: function onUpdate(data) {
          return _this3._handlePopperPlacementChange(data);
        }
      };
      return _extends({}, defaultBsConfig, this.config.popperConfig);
    };

    _proto._getOffset = function _getOffset() {
      var _this4 = this;

      var offset = {};

      if (typeof this.config.offset === 'function') {
        offset.fn = function (data) {
          data.offsets = _extends({}, data.offsets, _this4.config.offset(data.offsets, _this4.element));
          return data;
        };
      } else {
        offset.offset = this.config.offset;
      }

      return offset;
    };

    _proto._getContainer = function _getContainer() {
      if (this.config.container === false) {
        return document.body;
      }

      if (Util.isElement(this.config.container)) {
        return $__default["default"](this.config.container);
      }

      return $__default["default"](document).find(this.config.container);
    };

    _proto._getAttachment = function _getAttachment(placement) {
      return AttachmentMap[placement.toUpperCase()];
    };

    _proto._setListeners = function _setListeners() {
      var _this5 = this;

      var triggers = this.config.trigger.split(' ');
      triggers.forEach(function (trigger) {
        if (trigger === 'click') {
          $__default["default"](_this5.element).on(_this5.constructor.Event.CLICK, _this5.config.selector, function (event) {
            return _this5.toggle(event);
          });
        } else if (trigger !== TRIGGER_MANUAL) {
          var eventIn = trigger === TRIGGER_HOVER ? _this5.constructor.Event.MOUSEENTER : _this5.constructor.Event.FOCUSIN;
          var eventOut = trigger === TRIGGER_HOVER ? _this5.constructor.Event.MOUSELEAVE : _this5.constructor.Event.FOCUSOUT;
          $__default["default"](_this5.element).on(eventIn, _this5.config.selector, function (event) {
            return _this5._enter(event);
          }).on(eventOut, _this5.config.selector, function (event) {
            return _this5._leave(event);
          });
        }
      });

      this._hideModalHandler = function () {
        if (_this5.element) {
          _this5.hide();
        }
      };

      $__default["default"](this.element).closest('.modal').on('hide.bs.modal', this._hideModalHandler);

      if (this.config.selector) {
        this.config = _extends({}, this.config, {
          trigger: 'manual',
          selector: ''
        });
      } else {
        this._fixTitle();
      }
    };

    _proto._fixTitle = function _fixTitle() {
      var titleType = typeof this.element.getAttribute('data-original-title');

      if (this.element.getAttribute('title') || titleType !== 'string') {
        this.element.setAttribute('data-original-title', this.element.getAttribute('title') || '');
        this.element.setAttribute('title', '');
      }
    };

    _proto._enter = function _enter(event, context) {
      var dataKey = this.constructor.DATA_KEY;
      context = context || $__default["default"](event.currentTarget).data(dataKey);

      if (!context) {
        context = new this.constructor(event.currentTarget, this._getDelegateConfig());
        $__default["default"](event.currentTarget).data(dataKey, context);
      }

      if (event) {
        context._activeTrigger[event.type === 'focusin' ? TRIGGER_FOCUS : TRIGGER_HOVER] = true;
      }

      if ($__default["default"](context.getTipElement()).hasClass(CLASS_NAME_SHOW$3) || context._hoverState === HOVER_STATE_SHOW) {
        context._hoverState = HOVER_STATE_SHOW;
        return;
      }

      clearTimeout(context._timeout);
      context._hoverState = HOVER_STATE_SHOW;

      if (!context.config.delay || !context.config.delay.show) {
        context.show();
        return;
      }

      context._timeout = setTimeout(function () {
        if (context._hoverState === HOVER_STATE_SHOW) {
          context.show();
        }
      }, context.config.delay.show);
    };

    _proto._leave = function _leave(event, context) {
      var dataKey = this.constructor.DATA_KEY;
      context = context || $__default["default"](event.currentTarget).data(dataKey);

      if (!context) {
        context = new this.constructor(event.currentTarget, this._getDelegateConfig());
        $__default["default"](event.currentTarget).data(dataKey, context);
      }

      if (event) {
        context._activeTrigger[event.type === 'focusout' ? TRIGGER_FOCUS : TRIGGER_HOVER] = false;
      }

      if (context._isWithActiveTrigger()) {
        return;
      }

      clearTimeout(context._timeout);
      context._hoverState = HOVER_STATE_OUT;

      if (!context.config.delay || !context.config.delay.hide) {
        context.hide();
        return;
      }

      context._timeout = setTimeout(function () {
        if (context._hoverState === HOVER_STATE_OUT) {
          context.hide();
        }
      }, context.config.delay.hide);
    };

    _proto._isWithActiveTrigger = function _isWithActiveTrigger() {
      for (var trigger in this._activeTrigger) {
        if (this._activeTrigger[trigger]) {
          return true;
        }
      }

      return false;
    };

    _proto._getConfig = function _getConfig(config) {
      var dataAttributes = $__default["default"](this.element).data();
      Object.keys(dataAttributes).forEach(function (dataAttr) {
        if (DISALLOWED_ATTRIBUTES.indexOf(dataAttr) !== -1) {
          delete dataAttributes[dataAttr];
        }
      });
      config = _extends({}, this.constructor.Default, dataAttributes, typeof config === 'object' && config ? config : {});

      if (typeof config.delay === 'number') {
        config.delay = {
          show: config.delay,
          hide: config.delay
        };
      }

      if (typeof config.title === 'number') {
        config.title = config.title.toString();
      }

      if (typeof config.content === 'number') {
        config.content = config.content.toString();
      }

      Util.typeCheckConfig(NAME$4, config, this.constructor.DefaultType);

      if (config.sanitize) {
        config.template = sanitizeHtml(config.template, config.whiteList, config.sanitizeFn);
      }

      return config;
    };

    _proto._getDelegateConfig = function _getDelegateConfig() {
      var config = {};

      if (this.config) {
        for (var key in this.config) {
          if (this.constructor.Default[key] !== this.config[key]) {
            config[key] = this.config[key];
          }
        }
      }

      return config;
    };

    _proto._cleanTipClass = function _cleanTipClass() {
      var $tip = $__default["default"](this.getTipElement());
      var tabClass = $tip.attr('class').match(BSCLS_PREFIX_REGEX$1);

      if (tabClass !== null && tabClass.length) {
        $tip.removeClass(tabClass.join(''));
      }
    };

    _proto._handlePopperPlacementChange = function _handlePopperPlacementChange(popperData) {
      this.tip = popperData.instance.popper;

      this._cleanTipClass();

      this.addAttachmentClass(this._getAttachment(popperData.placement));
    };

    _proto._fixTransition = function _fixTransition() {
      var tip = this.getTipElement();
      var initConfigAnimation = this.config.animation;

      if (tip.getAttribute('x-placement') !== null) {
        return;
      }

      $__default["default"](tip).removeClass(CLASS_NAME_FADE$3);
      this.config.animation = false;
      this.hide();
      this.show();
      this.config.animation = initConfigAnimation;
    } // Static
    ;

    Tooltip._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var $element = $__default["default"](this);
        var data = $element.data(DATA_KEY$4);

        var _config = typeof config === 'object' && config;

        if (!data && /dispose|hide/.test(config)) {
          return;
        }

        if (!data) {
          data = new Tooltip(this, _config);
          $element.data(DATA_KEY$4, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config]();
        }
      });
    };

    _createClass(Tooltip, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$4;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default$3;
      }
    }, {
      key: "NAME",
      get: function get() {
        return NAME$4;
      }
    }, {
      key: "DATA_KEY",
      get: function get() {
        return DATA_KEY$4;
      }
    }, {
      key: "Event",
      get: function get() {
        return Event$1;
      }
    }, {
      key: "EVENT_KEY",
      get: function get() {
        return EVENT_KEY$4;
      }
    }, {
      key: "DefaultType",
      get: function get() {
        return DefaultType$3;
      }
    }]);

    return Tooltip;
  }();
  /**
   * jQuery
   */


  $__default["default"].fn[NAME$4] = Tooltip._jQueryInterface;
  $__default["default"].fn[NAME$4].Constructor = Tooltip;

  $__default["default"].fn[NAME$4].noConflict = function () {
    $__default["default"].fn[NAME$4] = JQUERY_NO_CONFLICT$4;
    return Tooltip._jQueryInterface;
  };

  /**
   * Constants
   */

  var NAME$3 = 'popover';
  var VERSION$3 = '4.6.1';
  var DATA_KEY$3 = 'bs.popover';
  var EVENT_KEY$3 = "." + DATA_KEY$3;
  var JQUERY_NO_CONFLICT$3 = $__default["default"].fn[NAME$3];
  var CLASS_PREFIX = 'bs-popover';
  var BSCLS_PREFIX_REGEX = new RegExp("(^|\\s)" + CLASS_PREFIX + "\\S+", 'g');
  var CLASS_NAME_FADE$2 = 'fade';
  var CLASS_NAME_SHOW$2 = 'show';
  var SELECTOR_TITLE = '.popover-header';
  var SELECTOR_CONTENT = '.popover-body';

  var Default$2 = _extends({}, Tooltip.Default, {
    placement: 'right',
    trigger: 'click',
    content: '',
    template: '<div class="popover" role="tooltip">' + '<div class="arrow"></div>' + '<h3 class="popover-header"></h3>' + '<div class="popover-body"></div></div>'
  });

  var DefaultType$2 = _extends({}, Tooltip.DefaultType, {
    content: '(string|element|function)'
  });

  var Event = {
    HIDE: "hide" + EVENT_KEY$3,
    HIDDEN: "hidden" + EVENT_KEY$3,
    SHOW: "show" + EVENT_KEY$3,
    SHOWN: "shown" + EVENT_KEY$3,
    INSERTED: "inserted" + EVENT_KEY$3,
    CLICK: "click" + EVENT_KEY$3,
    FOCUSIN: "focusin" + EVENT_KEY$3,
    FOCUSOUT: "focusout" + EVENT_KEY$3,
    MOUSEENTER: "mouseenter" + EVENT_KEY$3,
    MOUSELEAVE: "mouseleave" + EVENT_KEY$3
  };
  /**
   * Class definition
   */

  var Popover = /*#__PURE__*/function (_Tooltip) {
    _inheritsLoose(Popover, _Tooltip);

    function Popover() {
      return _Tooltip.apply(this, arguments) || this;
    }

    var _proto = Popover.prototype;

    // Overrides
    _proto.isWithContent = function isWithContent() {
      return this.getTitle() || this._getContent();
    };

    _proto.addAttachmentClass = function addAttachmentClass(attachment) {
      $__default["default"](this.getTipElement()).addClass(CLASS_PREFIX + "-" + attachment);
    };

    _proto.getTipElement = function getTipElement() {
      this.tip = this.tip || $__default["default"](this.config.template)[0];
      return this.tip;
    };

    _proto.setContent = function setContent() {
      var $tip = $__default["default"](this.getTipElement()); // We use append for html objects to maintain js events

      this.setElementContent($tip.find(SELECTOR_TITLE), this.getTitle());

      var content = this._getContent();

      if (typeof content === 'function') {
        content = content.call(this.element);
      }

      this.setElementContent($tip.find(SELECTOR_CONTENT), content);
      $tip.removeClass(CLASS_NAME_FADE$2 + " " + CLASS_NAME_SHOW$2);
    } // Private
    ;

    _proto._getContent = function _getContent() {
      return this.element.getAttribute('data-content') || this.config.content;
    };

    _proto._cleanTipClass = function _cleanTipClass() {
      var $tip = $__default["default"](this.getTipElement());
      var tabClass = $tip.attr('class').match(BSCLS_PREFIX_REGEX);

      if (tabClass !== null && tabClass.length > 0) {
        $tip.removeClass(tabClass.join(''));
      }
    } // Static
    ;

    Popover._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var data = $__default["default"](this).data(DATA_KEY$3);

        var _config = typeof config === 'object' ? config : null;

        if (!data && /dispose|hide/.test(config)) {
          return;
        }

        if (!data) {
          data = new Popover(this, _config);
          $__default["default"](this).data(DATA_KEY$3, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config]();
        }
      });
    };

    _createClass(Popover, null, [{
      key: "VERSION",
      get: // Getters
      function get() {
        return VERSION$3;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default$2;
      }
    }, {
      key: "NAME",
      get: function get() {
        return NAME$3;
      }
    }, {
      key: "DATA_KEY",
      get: function get() {
        return DATA_KEY$3;
      }
    }, {
      key: "Event",
      get: function get() {
        return Event;
      }
    }, {
      key: "EVENT_KEY",
      get: function get() {
        return EVENT_KEY$3;
      }
    }, {
      key: "DefaultType",
      get: function get() {
        return DefaultType$2;
      }
    }]);

    return Popover;
  }(Tooltip);
  /**
   * jQuery
   */


  $__default["default"].fn[NAME$3] = Popover._jQueryInterface;
  $__default["default"].fn[NAME$3].Constructor = Popover;

  $__default["default"].fn[NAME$3].noConflict = function () {
    $__default["default"].fn[NAME$3] = JQUERY_NO_CONFLICT$3;
    return Popover._jQueryInterface;
  };

  /**
   * Constants
   */

  var NAME$2 = 'scrollspy';
  var VERSION$2 = '4.6.1';
  var DATA_KEY$2 = 'bs.scrollspy';
  var EVENT_KEY$2 = "." + DATA_KEY$2;
  var DATA_API_KEY$1 = '.data-api';
  var JQUERY_NO_CONFLICT$2 = $__default["default"].fn[NAME$2];
  var CLASS_NAME_DROPDOWN_ITEM = 'dropdown-item';
  var CLASS_NAME_ACTIVE$1 = 'active';
  var EVENT_ACTIVATE = "activate" + EVENT_KEY$2;
  var EVENT_SCROLL = "scroll" + EVENT_KEY$2;
  var EVENT_LOAD_DATA_API = "load" + EVENT_KEY$2 + DATA_API_KEY$1;
  var METHOD_OFFSET = 'offset';
  var METHOD_POSITION = 'position';
  var SELECTOR_DATA_SPY = '[data-spy="scroll"]';
  var SELECTOR_NAV_LIST_GROUP$1 = '.nav, .list-group';
  var SELECTOR_NAV_LINKS = '.nav-link';
  var SELECTOR_NAV_ITEMS = '.nav-item';
  var SELECTOR_LIST_ITEMS = '.list-group-item';
  var SELECTOR_DROPDOWN$1 = '.dropdown';
  var SELECTOR_DROPDOWN_ITEMS = '.dropdown-item';
  var SELECTOR_DROPDOWN_TOGGLE$1 = '.dropdown-toggle';
  var Default$1 = {
    offset: 10,
    method: 'auto',
    target: ''
  };
  var DefaultType$1 = {
    offset: 'number',
    method: 'string',
    target: '(string|element)'
  };
  /**
   * Class definition
   */

  var ScrollSpy = /*#__PURE__*/function () {
    function ScrollSpy(element, config) {
      var _this = this;

      this._element = element;
      this._scrollElement = element.tagName === 'BODY' ? window : element;
      this._config = this._getConfig(config);
      this._selector = this._config.target + " " + SELECTOR_NAV_LINKS + "," + (this._config.target + " " + SELECTOR_LIST_ITEMS + ",") + (this._config.target + " " + SELECTOR_DROPDOWN_ITEMS);
      this._offsets = [];
      this._targets = [];
      this._activeTarget = null;
      this._scrollHeight = 0;
      $__default["default"](this._scrollElement).on(EVENT_SCROLL, function (event) {
        return _this._process(event);
      });
      this.refresh();

      this._process();
    } // Getters


    var _proto = ScrollSpy.prototype;

    // Public
    _proto.refresh = function refresh() {
      var _this2 = this;

      var autoMethod = this._scrollElement === this._scrollElement.window ? METHOD_OFFSET : METHOD_POSITION;
      var offsetMethod = this._config.method === 'auto' ? autoMethod : this._config.method;
      var offsetBase = offsetMethod === METHOD_POSITION ? this._getScrollTop() : 0;
      this._offsets = [];
      this._targets = [];
      this._scrollHeight = this._getScrollHeight();
      var targets = [].slice.call(document.querySelectorAll(this._selector));
      targets.map(function (element) {
        var target;
        var targetSelector = Util.getSelectorFromElement(element);

        if (targetSelector) {
          target = document.querySelector(targetSelector);
        }

        if (target) {
          var targetBCR = target.getBoundingClientRect();

          if (targetBCR.width || targetBCR.height) {
            // TODO (fat): remove sketch reliance on jQuery position/offset
            return [$__default["default"](target)[offsetMethod]().top + offsetBase, targetSelector];
          }
        }

        return null;
      }).filter(function (item) {
        return item;
      }).sort(function (a, b) {
        return a[0] - b[0];
      }).forEach(function (item) {
        _this2._offsets.push(item[0]);

        _this2._targets.push(item[1]);
      });
    };

    _proto.dispose = function dispose() {
      $__default["default"].removeData(this._element, DATA_KEY$2);
      $__default["default"](this._scrollElement).off(EVENT_KEY$2);
      this._element = null;
      this._scrollElement = null;
      this._config = null;
      this._selector = null;
      this._offsets = null;
      this._targets = null;
      this._activeTarget = null;
      this._scrollHeight = null;
    } // Private
    ;

    _proto._getConfig = function _getConfig(config) {
      config = _extends({}, Default$1, typeof config === 'object' && config ? config : {});

      if (typeof config.target !== 'string' && Util.isElement(config.target)) {
        var id = $__default["default"](config.target).attr('id');

        if (!id) {
          id = Util.getUID(NAME$2);
          $__default["default"](config.target).attr('id', id);
        }

        config.target = "#" + id;
      }

      Util.typeCheckConfig(NAME$2, config, DefaultType$1);
      return config;
    };

    _proto._getScrollTop = function _getScrollTop() {
      return this._scrollElement === window ? this._scrollElement.pageYOffset : this._scrollElement.scrollTop;
    };

    _proto._getScrollHeight = function _getScrollHeight() {
      return this._scrollElement.scrollHeight || Math.max(document.body.scrollHeight, document.documentElement.scrollHeight);
    };

    _proto._getOffsetHeight = function _getOffsetHeight() {
      return this._scrollElement === window ? window.innerHeight : this._scrollElement.getBoundingClientRect().height;
    };

    _proto._process = function _process() {
      var scrollTop = this._getScrollTop() + this._config.offset;

      var scrollHeight = this._getScrollHeight();

      var maxScroll = this._config.offset + scrollHeight - this._getOffsetHeight();

      if (this._scrollHeight !== scrollHeight) {
        this.refresh();
      }

      if (scrollTop >= maxScroll) {
        var target = this._targets[this._targets.length - 1];

        if (this._activeTarget !== target) {
          this._activate(target);
        }

        return;
      }

      if (this._activeTarget && scrollTop < this._offsets[0] && this._offsets[0] > 0) {
        this._activeTarget = null;

        this._clear();

        return;
      }

      for (var i = this._offsets.length; i--;) {
        var isActiveTarget = this._activeTarget !== this._targets[i] && scrollTop >= this._offsets[i] && (typeof this._offsets[i + 1] === 'undefined' || scrollTop < this._offsets[i + 1]);

        if (isActiveTarget) {
          this._activate(this._targets[i]);
        }
      }
    };

    _proto._activate = function _activate(target) {
      this._activeTarget = target;

      this._clear();

      var queries = this._selector.split(',').map(function (selector) {
        return selector + "[data-target=\"" + target + "\"]," + selector + "[href=\"" + target + "\"]";
      });

      var $link = $__default["default"]([].slice.call(document.querySelectorAll(queries.join(','))));

      if ($link.hasClass(CLASS_NAME_DROPDOWN_ITEM)) {
        $link.closest(SELECTOR_DROPDOWN$1).find(SELECTOR_DROPDOWN_TOGGLE$1).addClass(CLASS_NAME_ACTIVE$1);
        $link.addClass(CLASS_NAME_ACTIVE$1);
      } else {
        // Set triggered link as active
        $link.addClass(CLASS_NAME_ACTIVE$1); // Set triggered links parents as active
        // With both <ul> and <nav> markup a parent is the previous sibling of any nav ancestor

        $link.parents(SELECTOR_NAV_LIST_GROUP$1).prev(SELECTOR_NAV_LINKS + ", " + SELECTOR_LIST_ITEMS).addClass(CLASS_NAME_ACTIVE$1); // Handle special case when .nav-link is inside .nav-item

        $link.parents(SELECTOR_NAV_LIST_GROUP$1).prev(SELECTOR_NAV_ITEMS).children(SELECTOR_NAV_LINKS).addClass(CLASS_NAME_ACTIVE$1);
      }

      $__default["default"](this._scrollElement).trigger(EVENT_ACTIVATE, {
        relatedTarget: target
      });
    };

    _proto._clear = function _clear() {
      [].slice.call(document.querySelectorAll(this._selector)).filter(function (node) {
        return node.classList.contains(CLASS_NAME_ACTIVE$1);
      }).forEach(function (node) {
        return node.classList.remove(CLASS_NAME_ACTIVE$1);
      });
    } // Static
    ;

    ScrollSpy._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var data = $__default["default"](this).data(DATA_KEY$2);

        var _config = typeof config === 'object' && config;

        if (!data) {
          data = new ScrollSpy(this, _config);
          $__default["default"](this).data(DATA_KEY$2, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config]();
        }
      });
    };

    _createClass(ScrollSpy, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$2;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default$1;
      }
    }]);

    return ScrollSpy;
  }();
  /**
   * Data API implementation
   */


  $__default["default"](window).on(EVENT_LOAD_DATA_API, function () {
    var scrollSpys = [].slice.call(document.querySelectorAll(SELECTOR_DATA_SPY));
    var scrollSpysLength = scrollSpys.length;

    for (var i = scrollSpysLength; i--;) {
      var $spy = $__default["default"](scrollSpys[i]);

      ScrollSpy._jQueryInterface.call($spy, $spy.data());
    }
  });
  /**
   * jQuery
   */

  $__default["default"].fn[NAME$2] = ScrollSpy._jQueryInterface;
  $__default["default"].fn[NAME$2].Constructor = ScrollSpy;

  $__default["default"].fn[NAME$2].noConflict = function () {
    $__default["default"].fn[NAME$2] = JQUERY_NO_CONFLICT$2;
    return ScrollSpy._jQueryInterface;
  };

  /**
   * Constants
   */

  var NAME$1 = 'tab';
  var VERSION$1 = '4.6.1';
  var DATA_KEY$1 = 'bs.tab';
  var EVENT_KEY$1 = "." + DATA_KEY$1;
  var DATA_API_KEY = '.data-api';
  var JQUERY_NO_CONFLICT$1 = $__default["default"].fn[NAME$1];
  var CLASS_NAME_DROPDOWN_MENU = 'dropdown-menu';
  var CLASS_NAME_ACTIVE = 'active';
  var CLASS_NAME_DISABLED = 'disabled';
  var CLASS_NAME_FADE$1 = 'fade';
  var CLASS_NAME_SHOW$1 = 'show';
  var EVENT_HIDE$1 = "hide" + EVENT_KEY$1;
  var EVENT_HIDDEN$1 = "hidden" + EVENT_KEY$1;
  var EVENT_SHOW$1 = "show" + EVENT_KEY$1;
  var EVENT_SHOWN$1 = "shown" + EVENT_KEY$1;
  var EVENT_CLICK_DATA_API = "click" + EVENT_KEY$1 + DATA_API_KEY;
  var SELECTOR_DROPDOWN = '.dropdown';
  var SELECTOR_NAV_LIST_GROUP = '.nav, .list-group';
  var SELECTOR_ACTIVE = '.active';
  var SELECTOR_ACTIVE_UL = '> li > .active';
  var SELECTOR_DATA_TOGGLE = '[data-toggle="tab"], [data-toggle="pill"], [data-toggle="list"]';
  var SELECTOR_DROPDOWN_TOGGLE = '.dropdown-toggle';
  var SELECTOR_DROPDOWN_ACTIVE_CHILD = '> .dropdown-menu .active';
  /**
   * Class definition
   */

  var Tab = /*#__PURE__*/function () {
    function Tab(element) {
      this._element = element;
    } // Getters


    var _proto = Tab.prototype;

    // Public
    _proto.show = function show() {
      var _this = this;

      if (this._element.parentNode && this._element.parentNode.nodeType === Node.ELEMENT_NODE && $__default["default"](this._element).hasClass(CLASS_NAME_ACTIVE) || $__default["default"](this._element).hasClass(CLASS_NAME_DISABLED)) {
        return;
      }

      var target;
      var previous;
      var listElement = $__default["default"](this._element).closest(SELECTOR_NAV_LIST_GROUP)[0];
      var selector = Util.getSelectorFromElement(this._element);

      if (listElement) {
        var itemSelector = listElement.nodeName === 'UL' || listElement.nodeName === 'OL' ? SELECTOR_ACTIVE_UL : SELECTOR_ACTIVE;
        previous = $__default["default"].makeArray($__default["default"](listElement).find(itemSelector));
        previous = previous[previous.length - 1];
      }

      var hideEvent = $__default["default"].Event(EVENT_HIDE$1, {
        relatedTarget: this._element
      });
      var showEvent = $__default["default"].Event(EVENT_SHOW$1, {
        relatedTarget: previous
      });

      if (previous) {
        $__default["default"](previous).trigger(hideEvent);
      }

      $__default["default"](this._element).trigger(showEvent);

      if (showEvent.isDefaultPrevented() || hideEvent.isDefaultPrevented()) {
        return;
      }

      if (selector) {
        target = document.querySelector(selector);
      }

      this._activate(this._element, listElement);

      var complete = function complete() {
        var hiddenEvent = $__default["default"].Event(EVENT_HIDDEN$1, {
          relatedTarget: _this._element
        });
        var shownEvent = $__default["default"].Event(EVENT_SHOWN$1, {
          relatedTarget: previous
        });
        $__default["default"](previous).trigger(hiddenEvent);
        $__default["default"](_this._element).trigger(shownEvent);
      };

      if (target) {
        this._activate(target, target.parentNode, complete);
      } else {
        complete();
      }
    };

    _proto.dispose = function dispose() {
      $__default["default"].removeData(this._element, DATA_KEY$1);
      this._element = null;
    } // Private
    ;

    _proto._activate = function _activate(element, container, callback) {
      var _this2 = this;

      var activeElements = container && (container.nodeName === 'UL' || container.nodeName === 'OL') ? $__default["default"](container).find(SELECTOR_ACTIVE_UL) : $__default["default"](container).children(SELECTOR_ACTIVE);
      var active = activeElements[0];
      var isTransitioning = callback && active && $__default["default"](active).hasClass(CLASS_NAME_FADE$1);

      var complete = function complete() {
        return _this2._transitionComplete(element, active, callback);
      };

      if (active && isTransitioning) {
        var transitionDuration = Util.getTransitionDurationFromElement(active);
        $__default["default"](active).removeClass(CLASS_NAME_SHOW$1).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);
      } else {
        complete();
      }
    };

    _proto._transitionComplete = function _transitionComplete(element, active, callback) {
      if (active) {
        $__default["default"](active).removeClass(CLASS_NAME_ACTIVE);
        var dropdownChild = $__default["default"](active.parentNode).find(SELECTOR_DROPDOWN_ACTIVE_CHILD)[0];

        if (dropdownChild) {
          $__default["default"](dropdownChild).removeClass(CLASS_NAME_ACTIVE);
        }

        if (active.getAttribute('role') === 'tab') {
          active.setAttribute('aria-selected', false);
        }
      }

      $__default["default"](element).addClass(CLASS_NAME_ACTIVE);

      if (element.getAttribute('role') === 'tab') {
        element.setAttribute('aria-selected', true);
      }

      Util.reflow(element);

      if (element.classList.contains(CLASS_NAME_FADE$1)) {
        element.classList.add(CLASS_NAME_SHOW$1);
      }

      var parent = element.parentNode;

      if (parent && parent.nodeName === 'LI') {
        parent = parent.parentNode;
      }

      if (parent && $__default["default"](parent).hasClass(CLASS_NAME_DROPDOWN_MENU)) {
        var dropdownElement = $__default["default"](element).closest(SELECTOR_DROPDOWN)[0];

        if (dropdownElement) {
          var dropdownToggleList = [].slice.call(dropdownElement.querySelectorAll(SELECTOR_DROPDOWN_TOGGLE));
          $__default["default"](dropdownToggleList).addClass(CLASS_NAME_ACTIVE);
        }

        element.setAttribute('aria-expanded', true);
      }

      if (callback) {
        callback();
      }
    } // Static
    ;

    Tab._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var $this = $__default["default"](this);
        var data = $this.data(DATA_KEY$1);

        if (!data) {
          data = new Tab(this);
          $this.data(DATA_KEY$1, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config]();
        }
      });
    };

    _createClass(Tab, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$1;
      }
    }]);

    return Tab;
  }();
  /**
   * Data API implementation
   */


  $__default["default"](document).on(EVENT_CLICK_DATA_API, SELECTOR_DATA_TOGGLE, function (event) {
    event.preventDefault();

    Tab._jQueryInterface.call($__default["default"](this), 'show');
  });
  /**
   * jQuery
   */

  $__default["default"].fn[NAME$1] = Tab._jQueryInterface;
  $__default["default"].fn[NAME$1].Constructor = Tab;

  $__default["default"].fn[NAME$1].noConflict = function () {
    $__default["default"].fn[NAME$1] = JQUERY_NO_CONFLICT$1;
    return Tab._jQueryInterface;
  };

  /**
   * Constants
   */

  var NAME = 'toast';
  var VERSION = '4.6.1';
  var DATA_KEY = 'bs.toast';
  var EVENT_KEY = "." + DATA_KEY;
  var JQUERY_NO_CONFLICT = $__default["default"].fn[NAME];
  var CLASS_NAME_FADE = 'fade';
  var CLASS_NAME_HIDE = 'hide';
  var CLASS_NAME_SHOW = 'show';
  var CLASS_NAME_SHOWING = 'showing';
  var EVENT_CLICK_DISMISS = "click.dismiss" + EVENT_KEY;
  var EVENT_HIDE = "hide" + EVENT_KEY;
  var EVENT_HIDDEN = "hidden" + EVENT_KEY;
  var EVENT_SHOW = "show" + EVENT_KEY;
  var EVENT_SHOWN = "shown" + EVENT_KEY;
  var SELECTOR_DATA_DISMISS = '[data-dismiss="toast"]';
  var Default = {
    animation: true,
    autohide: true,
    delay: 500
  };
  var DefaultType = {
    animation: 'boolean',
    autohide: 'boolean',
    delay: 'number'
  };
  /**
   * Class definition
   */

  var Toast = /*#__PURE__*/function () {
    function Toast(element, config) {
      this._element = element;
      this._config = this._getConfig(config);
      this._timeout = null;

      this._setListeners();
    } // Getters


    var _proto = Toast.prototype;

    // Public
    _proto.show = function show() {
      var _this = this;

      var showEvent = $__default["default"].Event(EVENT_SHOW);
      $__default["default"](this._element).trigger(showEvent);

      if (showEvent.isDefaultPrevented()) {
        return;
      }

      this._clearTimeout();

      if (this._config.animation) {
        this._element.classList.add(CLASS_NAME_FADE);
      }

      var complete = function complete() {
        _this._element.classList.remove(CLASS_NAME_SHOWING);

        _this._element.classList.add(CLASS_NAME_SHOW);

        $__default["default"](_this._element).trigger(EVENT_SHOWN);

        if (_this._config.autohide) {
          _this._timeout = setTimeout(function () {
            _this.hide();
          }, _this._config.delay);
        }
      };

      this._element.classList.remove(CLASS_NAME_HIDE);

      Util.reflow(this._element);

      this._element.classList.add(CLASS_NAME_SHOWING);

      if (this._config.animation) {
        var transitionDuration = Util.getTransitionDurationFromElement(this._element);
        $__default["default"](this._element).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);
      } else {
        complete();
      }
    };

    _proto.hide = function hide() {
      if (!this._element.classList.contains(CLASS_NAME_SHOW)) {
        return;
      }

      var hideEvent = $__default["default"].Event(EVENT_HIDE);
      $__default["default"](this._element).trigger(hideEvent);

      if (hideEvent.isDefaultPrevented()) {
        return;
      }

      this._close();
    };

    _proto.dispose = function dispose() {
      this._clearTimeout();

      if (this._element.classList.contains(CLASS_NAME_SHOW)) {
        this._element.classList.remove(CLASS_NAME_SHOW);
      }

      $__default["default"](this._element).off(EVENT_CLICK_DISMISS);
      $__default["default"].removeData(this._element, DATA_KEY);
      this._element = null;
      this._config = null;
    } // Private
    ;

    _proto._getConfig = function _getConfig(config) {
      config = _extends({}, Default, $__default["default"](this._element).data(), typeof config === 'object' && config ? config : {});
      Util.typeCheckConfig(NAME, config, this.constructor.DefaultType);
      return config;
    };

    _proto._setListeners = function _setListeners() {
      var _this2 = this;

      $__default["default"](this._element).on(EVENT_CLICK_DISMISS, SELECTOR_DATA_DISMISS, function () {
        return _this2.hide();
      });
    };

    _proto._close = function _close() {
      var _this3 = this;

      var complete = function complete() {
        _this3._element.classList.add(CLASS_NAME_HIDE);

        $__default["default"](_this3._element).trigger(EVENT_HIDDEN);
      };

      this._element.classList.remove(CLASS_NAME_SHOW);

      if (this._config.animation) {
        var transitionDuration = Util.getTransitionDurationFromElement(this._element);
        $__default["default"](this._element).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);
      } else {
        complete();
      }
    };

    _proto._clearTimeout = function _clearTimeout() {
      clearTimeout(this._timeout);
      this._timeout = null;
    } // Static
    ;

    Toast._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var $element = $__default["default"](this);
        var data = $element.data(DATA_KEY);

        var _config = typeof config === 'object' && config;

        if (!data) {
          data = new Toast(this, _config);
          $element.data(DATA_KEY, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config](this);
        }
      });
    };

    _createClass(Toast, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION;
      }
    }, {
      key: "DefaultType",
      get: function get() {
        return DefaultType;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default;
      }
    }]);

    return Toast;
  }();
  /**
   * jQuery
   */


  $__default["default"].fn[NAME] = Toast._jQueryInterface;
  $__default["default"].fn[NAME].Constructor = Toast;

  $__default["default"].fn[NAME].noConflict = function () {
    $__default["default"].fn[NAME] = JQUERY_NO_CONFLICT;
    return Toast._jQueryInterface;
  };

  exports.Alert = Alert;
  exports.Button = Button;
  exports.Carousel = Carousel;
  exports.Collapse = Collapse;
  exports.Dropdown = Dropdown;
  exports.Modal = Modal;
  exports.Popover = Popover;
  exports.Scrollspy = ScrollSpy;
  exports.Tab = Tab;
  exports.Toast = Toast;
  exports.Tooltip = Tooltip;
  exports.Util = Util;

  Object.defineProperty(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=bootstrap.js.map

/*!
* DevExtreme (dx.all.js)
* Version: 22.1.4
* Build date: Fri Jul 22 2022
*
* Copyright (c) 2012 - 2022 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";!function(){var e={23908:function(e,t,n){t.convertTransitionTimingFuncToEasing=void 0,t.getEasing=function(e){return s[e]},t.setEasing=function(e){s=e};var i=n(35922),o=/cubic-bezier\((\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\)/,a={linear:"cubic-bezier(0, 0, 1, 1)",swing:"cubic-bezier(0.445, 0.05, 0.55, 0.95)",ease:"cubic-bezier(0.25, 0.1, 0.25, 1)","ease-in":"cubic-bezier(0.42, 0, 1, 1)","ease-out":"cubic-bezier(0, 0, 0.58, 1)","ease-in-out":"cubic-bezier(0.42, 0, 0.58, 1)"},r=function(e,t,n,i){var o=3*e,a=3*(n-e)-o,r=1-o-a,s=3*t,l=3*(i-t)-s,u=1-s-l,d=function(e){return e*(o+e*(a+e*r))},c=function(e){return o+e*(2*a+3*e*r)};return function(e){return function(e){return e*(s+e*(l+e*u))}(function(e){for(var t,n=e,i=0;i<14&&(t=d(n)-e,!(Math.abs(t)<.001));)n-=t/c(n),i++;return n}(e))}},s={};t.convertTransitionTimingFuncToEasing=function(e){var t,n=(e=a[e]||e).match(o);n||(n=a[t="linear"].match(o)),n=n.slice(1,5);for(var l=0;l<n.length;l++)n[l]=parseFloat(n[l]);var u=t||"cubicbezier_"+n.join("_").replace(/\./g,"p");return(0,i.isFunction)(s[u])||(s[u]=function(e,t,i,o,a){return o*r(n[0],n[1],n[2],n[3])(t/a)+i}),u}},90057:function(e,t,n){t.cancelAnimationFrame=function(){u(),l.apply(r,arguments)},t.requestAnimationFrame=function(){return u(),s.apply(r,arguments)};var i,o=n(58201),a=(i=n(39618))&&i.__esModule?i:{default:i};var r=(0,o.hasWindow)()?(0,o.getWindow)():{},s=function(e){return setTimeout(e,1e3/60)},l=function(e){clearTimeout(e)},u=(0,a.default)((function(){var e=r.requestAnimationFrame||r.webkitRequestAnimationFrame||r.mozRequestAnimationFrame||r.oRequestAnimationFrame||r.msRequestAnimationFrame,t=r.cancelAnimationFrame||r.webkitCancelAnimationFrame||r.mozCancelAnimationFrame||r.oCancelAnimationFrame||r.msCancelAnimationFrame;e&&t&&(s=e,l=t)}))},87209:function(e,t,n){t.default=void 0;var i=b(n(68374)),o=n(58201),a=b(n(55994)),r=b(n(17381)),s=n(6415),l=n(13306),u=n(35922),d=n(95479),c=n(31648),h=n(23908),p=n(90057),f=n(60137),g=b(n(49387)),m=n(29007),_=n(39611),v=n(62754),y=n(20576);function b(e){return e&&e.__esModule?e:{default:e}}function x(e){return(x="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var w=(0,o.getWindow)(),C=(0,_.addNamespace)(m.removeEvent,"dxFX"),S=/^([+-])=(.*)/i,k={initAnimation:function(e,t){e.css({transitionProperty:"none"}),"string"==typeof t.from?e.addClass(t.from):$(e,t.from);var n=this,i=new v.Deferred,o=t.cleanupWhen;t.transitionAnimation={deferred:i,finish:function(){n._finishTransition(e),o?(0,v.when)(i,o).always((function(){n._cleanup(e,t)})):n._cleanup(e,t),i.resolveWith(e,[t,e])}},this._completeAnimationCallback(e,t).done((function(){t.transitionAnimation.finish()})).fail((function(){i.rejectWith(e,[t,e])})),t.duration||t.transitionAnimation.finish(),e.css("transform")},animate:function(e,t){return this._startAnimation(e,t),t.transitionAnimation.deferred.promise()},_completeAnimationCallback:function(e,t){var n,i=this,o=Date.now()+t.delay,r=new v.Deferred,s=new v.Deferred,l=new v.Deferred,u=(0,f.transitionEndEventName)()+".dxFX";t.transitionAnimation.cleanup=function(){clearTimeout(n),clearTimeout(d),a.default.off(e,u),a.default.off(e,C)},a.default.one(e,u,(function(){Date.now()-o>=t.duration&&s.reject()})),a.default.off(e,C),a.default.on(e,C,(function(){i.stop(e,t),r.reject()}));var d=setTimeout((function(){n=setTimeout((function(){l.reject()}),t.duration+t.delay+U._simulatedTransitionEndDelay),(0,v.when)(s,l).fail(function(){r.resolve()}.bind(this))}));return r.promise()},_startAnimation:function(e,t){e.css({transitionProperty:"all",transitionDelay:t.delay+"ms",transitionDuration:t.duration+"ms",transitionTimingFunction:t.easing}),"string"==typeof t.to?e[0].className+=" "+t.to:t.to&&$(e,t.to)},_finishTransition:function(e){e.css("transition","none")},_cleanup:function(e,t){t.transitionAnimation.cleanup(),"string"==typeof t.from&&(e.removeClass(t.from),e.removeClass(t.to))},stop:function(e,t,n){t&&(n?t.transitionAnimation.finish():((0,u.isPlainObject)(t.to)&&(0,d.each)(t.to,(function(t){e.css(t,e.css(t))})),this._finishTransition(e),this._cleanup(e,t)))}},D={initAnimation:function(e,t){$(e,t.from)},animate:function(e,t){var n=new v.Deferred,i=this;return t?((0,d.each)(t.to,(function(n){void 0===t.from[n]&&(t.from[n]=i._normalizeValue(e.css(n)))})),t.to.transform&&(t.from.transform=i._parseTransform(t.from.transform),t.to.transform=i._parseTransform(t.to.transform)),t.frameAnimation={to:t.to,from:t.from,currentValue:t.from,easing:(0,h.convertTransitionTimingFuncToEasing)(t.easing),duration:t.duration,startTime:(new Date).valueOf(),finish:function(){this.currentValue=this.to,this.draw(),(0,p.cancelAnimationFrame)(t.frameAnimation.animationFrameId),n.resolve()},draw:function(){if(t.draw)t.draw(this.currentValue);else{var n=(0,l.extend)({},this.currentValue);n.transform&&(n.transform=(0,d.map)(n.transform,(function(e,t){return"translate"===t?(0,c.getTranslateCss)(e):"scale"===t?"scale("+e+")":"rotate"===t.substr(0,t.length-1)?t+"("+e+"deg)":void 0})).join(" ")),e.css(n)}}},t.delay?(t.frameAnimation.startTime+=t.delay,t.frameAnimation.delayTimeout=setTimeout((function(){i._startAnimation(e,t)}),t.delay)):i._startAnimation(e,t),n.promise()):n.reject().promise()},_startAnimation:function(e,t){a.default.off(e,C),a.default.on(e,C,(function(){t.frameAnimation&&(0,p.cancelAnimationFrame)(t.frameAnimation.animationFrameId)})),this._animationStep(e,t)},_parseTransform:function(e){var t={};return(0,d.each)(e.match(/\w+\d*\w*\([^)]*\)\s*/g),(function(e,n){var i=(0,c.parseTranslate)(n),o=n.match(/scale\((.+?)\)/),a=n.match(/(rotate.)\((.+)deg\)/);i&&(t.translate=i),o&&o[1]&&(t.scale=parseFloat(o[1])),a&&a[1]&&(t[a[1]]=parseFloat(a[2]))})),t},stop:function(e,t,n){var i=t&&t.frameAnimation;i&&((0,p.cancelAnimationFrame)(i.animationFrameId),clearTimeout(i.delayTimeout),n&&i.finish(),delete t.frameAnimation)},_animationStep:function(e,t){var n=t&&t.frameAnimation;if(n){var i=(new Date).valueOf();if(i>=n.startTime+n.duration)n.finish();else{n.currentValue=this._calcStepValue(n,i-n.startTime),n.draw();var o=this;n.animationFrameId=(0,p.requestAnimationFrame)((function(){o._animationStep(e,t)}))}}},_calcStepValue:function(e,t){return function n(i,o){var a=Array.isArray(o)?[]:{};return(0,d.each)(o,(function(r,s){if("string"==typeof s&&!1===parseFloat(s,10))return!0;a[r]="object"===x(s)?n(i[r],s):function(n){var a=t/e.duration,r=t,s=1*i[n],l=o[n]-i[n],u=e.duration;return(0,h.getEasing)(e.easing)(a,r,s,l,u)}(r)})),a}(e.from,e.to)},_normalizeValue:function(e){var t=parseFloat(e,10);return!1===t?e:t}},I={initAnimation:function(){},animate:function(){return(new v.Deferred).resolve().promise()},stop:y.noop,isSynchronous:!0},T=function(e,t,n,i){(0,d.each)(["from","to"],(function(){if(!n(e[this]))throw r.default.Error("E0010",t,this,i)}))},E=function(e,t){return T(e,t,(function(e){return(0,u.isPlainObject)(e)}),"a plain object")},O={top:{my:"bottom center",at:"top center"},bottom:{my:"top center",at:"bottom center"},right:{my:"left center",at:"right center"},left:{my:"right center",at:"left center"}},A={validateConfig:function(e){E(e,"slide")},setup:function(e,t){var n=(0,c.locate)(e);if("slide"!==t.type){var i="slideIn"===t.type?t.from:t.to;i.position=(0,l.extend)({of:w},O[t.direction]),q(e,i)}this._setUpConfig(n,t.from),this._setUpConfig(n,t.to),(0,c.clearCache)(e)},_setUpConfig:function(e,t){t.left="left"in t?t.left:"+=0",t.top="top"in t?t.top:"+=0",this._initNewPosition(e,t)},_initNewPosition:function(e,t){var n={left:t.left,top:t.top};delete t.left,delete t.top;var i=this._getRelativeValue(n.left);void 0!==i?n.left=i+e.left:t.left=0,void 0!==(i=this._getRelativeValue(n.top))?n.top=i+e.top:t.top=0,t.transform=(0,c.getTranslateCss)({x:n.left,y:n.top})},_getRelativeValue:function(e){var t;if("string"==typeof e&&(t=S.exec(e)))return parseInt(t[1]+"1")*t[2]}},P={setup:function(e,t){var n,i,o=t.from,a=t.to,r="fadeOut"===t.type?1:0,s="fadeOut"===t.type?0:1,l=(0,u.isPlainObject)(o)?String(null!==(n=o.opacity)&&void 0!==n?n:r):String(o),d=(0,u.isPlainObject)(a)?String(null!==(i=a.opacity)&&void 0!==i?i:s):String(a);switch(t.skipElementInitialStyles||(l=e.css("opacity")),t.type){case"fadeIn":d=1;break;case"fadeOut":d=0}t.from={visibility:"visible",opacity:l},t.to={opacity:d}}},R={custom:{setup:function(){}},slide:A,slideIn:A,slideOut:A,fade:P,fadeIn:P,fadeOut:P,pop:{validateConfig:function(e){E(e,"pop")},setup:function(e,t){var n=t.from,i=t.to,o="opacity"in n?n.opacity:e.css("opacity"),a="opacity"in i?i.opacity:1,r="scale"in n?n.scale:0,s="scale"in i?i.scale:1;t.from={opacity:o};var l=(0,c.getTranslate)(e);t.from.transform=this._getCssTransform(l,r),t.to={opacity:a},t.to.transform=this._getCssTransform(l,s)},_getCssTransform:function(e,t){return(0,c.getTranslateCss)(e)+"scale("+t+")"}},css:{validateConfig:function(e){!function(e,t){T(e,t,(function(e){return"string"==typeof e}),"a string")}(e,"css")},setup:function(){}}},M={type:"custom",from:{},to:{},duration:400,start:y.noop,complete:y.noop,easing:"ease",delay:0},B={duration:400,easing:"ease",delay:0};function L(){var e=this.element,t=this.config;if(q(e,t.from),q(e,t.to),this.configurator.setup(e,t),e.data("dxAnimData",this),U.off&&(t.duration=0,t.delay=0),this.strategy.initAnimation(e,t),t.start){var n=(0,s.getPublicElement)(e);t.start.apply(this,[n,t])}}var V=function(){var e=this,t=e.element,n=e.config;return e.isStarted=!0,e.strategy.animate(t,n).done((function(){!function(e){var t=e.element,n=e.config;if(t.removeData("dxAnimData"),n.complete){var i=(0,s.getPublicElement)(t);n.complete.apply(this,[i,n])}e.deferred.resolveWith(this,[t,n])}(e)})).fail((function(){e.deferred.rejectWith(this,[t,n])}))},F=function(e){var t=this.element,n=this.config;clearTimeout(this.startTimeout),this.isStarted||this.start(),this.strategy.stop(t,n,e)},H=(0,_.addNamespace)(m.removeEvent,"dxFXStartAnimation"),N=function(e,t){var n="css"===t.type?B:M,o=(0,l.extend)(!0,{},n,t),s=function(e){var t=R[e.type];if(!t)throw r.default.Error("E0011",e.type);return t}(o),d=function(e){e=e||{};var t={transition:(0,f.transition)()?k:D,frame:D,noAnimation:I},n=e.strategy||"transition";return"css"!==e.type||(0,f.transition)()||(n="noAnimation"),t[n]}(o),c={element:(0,i.default)(e),config:o,configurator:s,strategy:d,isSynchronous:d.isSynchronous,setup:L,start:V,stop:F,deferred:new v.Deferred};return(0,u.isFunction)(s.validateConfig)&&s.validateConfig(o),function(e){a.default.off(e.element,H),a.default.on(e.element,H,(function(){U.stop(e.element)})),e.deferred.always((function(){a.default.off(e.element,H)}))}(c),c};function z(e){return e.data("dxAnimQueue")||[]}var W=function(e){e.removeData("dxAnimQueue")};function j(e){return!!e.data("dxAnimData")}function G(e,t){if((t=z(e)).length){var n=t.shift();0===t.length&&W(e),function(e){e.setup(),U.off||e.isSynchronous?e.start():e.startTimeout=setTimeout((function(){e.start()}));return e.deferred.promise()}(n).done((function(){j(e)||G(e)}))}}function q(e,t){if(t&&t.position){var n=(0,i.default)(w),o=0,a=0,r=g.default.calculate(e,t.position),s=e.offset(),u=e.position();u.top>s.top&&(a=n.scrollTop()),u.left>s.left&&(o=n.scrollLeft()),(0,l.extend)(t,{left:r.h.location-s.left+u.left-o,top:r.v.location-s.top+u.top-a}),delete t.position}}function $(e,t){(0,d.each)(t,(function(t,n){try{e.css(t,(0,u.isFunction)(n)?n():n)}catch(e){}}))}var U={off:!1,animationTypes:R,animate:function(e,t){var n=(0,i.default)(e);if(!n.length)return(new v.Deferred).resolve().promise();var o=N(n,t);return function(e,t){var n=z(e);(function(e,t){e.data("dxAnimQueue",t)})(e,n),n.push(t),j(e)||G(e,n)}(n,o),o.deferred.promise()},createAnimation:N,isAnimating:j,stop:function(e,t){var n=(0,i.default)(e),o=z(n);(0,d.each)(o,(function(e,t){t.config.delay=0,t.config.duration=0,t.isSynchronous=!0})),j(n)||G(n,o);var a=n.data("dxAnimData");a&&a.stop(t),n.removeData("dxAnimData"),W(n)},_simulatedTransitionEndDelay:100},K=U;t.default=K,e.exports=t.default,e.exports.default=t.default},49387:function(e,t,n){t.default=void 0;var i=n(58664),o=m(n(68374)),a=n(20576),r=n(95479),s=n(58201),l=m(n(73349)),u=n(35922),d=n(13306),c=n(37518),h=m(n(47810)),p=n(31648),f=n(60137),g=m(n(20530));function m(e){return e&&e.__esModule?e:{default:e}}var _,v=(0,s.getWindow)(),y=/left|right/,b=/top|bottom/,x=/fit|flip|none/,w=/scale\(.+?\)/,C=h.default.safari,S=function(e){var t={h:"center",v:"center"},n=(0,a.splitPair)(e);return n&&(0,r.each)(n,(function(){var e=String(this).toLowerCase();y.test(e)?t.h=e:b.test(e)&&(t.v=e)})),t},k=function(e){return(0,a.pairToObject)(e)},D=function(e){switch(e){case"center":return.5;case"right":case"bottom":return 1;default:return 0}},I=function(e){switch(e){case"left":return"right";case"right":return"left";case"top":return"bottom";case"bottom":return"top";default:return e}},T=function(e,t){var n=0;return e.myLocation<t.min&&(n+=t.min-e.myLocation),e.myLocation>t.max&&(n+=e.myLocation-t.max),n},E=function(e,t,n){return t.myLocation<n.min?"h"===e?"left":"top":t.myLocation>n.max?"h"===e?"right":"bottom":"none"},O=function(e){e.myLocation=e.atLocation+D(e.atAlign)*e.atSize-D(e.myAlign)*e.mySize+e.offset},A={fit:function(e,t){var n=!1;e.myLocation>t.max&&(e.myLocation=t.max,n=!0),e.myLocation<t.min&&(e.myLocation=t.min,n=!0),e.fit=n},flip:function(e,t){if(e.flip=!1,("center"!==e.myAlign||"center"!==e.atAlign)&&(e.myLocation<t.min||e.myLocation>t.max)){var n=(0,d.extend)({},e,{myAlign:I(e.myAlign),atAlign:I(e.atAlign),offset:-e.offset});O(n),n.oversize=T(n,t),(n.myLocation>=t.min&&n.myLocation<=t.max||e.oversize>n.oversize)&&(e.myLocation=n.myLocation,e.oversize=n.oversize,e.flip=!0)}},flipfit:function(e,t){this.flip(e,t),this.fit(e,t)},none:function(e){e.oversize=0}},P=function(){var e=(0,o.default)("<div>").css({width:100,height:100,overflow:"scroll",position:"absolute",top:-9999}).appendTo((0,o.default)("body")),t=e.get(0).offsetWidth-e.get(0).clientWidth;e.remove(),_=t},R={h:{location:0,flip:!1,fit:!1,oversize:0},v:{location:0,flip:!1,fit:!1,oversize:0}},M=function(e,t){var n=(0,o.default)(e),r=n.offset(),s=(0,d.extend)(!0,{},R,{h:{location:r.left},v:{location:r.top}});if(!t)return s;var h=S(t.my),p=S(t.at),m=(0,o.default)(t.of).length&&t.of||v,y=k(t.offset),b=function(e){var t=(0,a.splitPair)(e),n=String(t&&t[0]).toLowerCase(),i=String(t&&t[1]).toLowerCase();return x.test(n)||(n="none"),x.test(i)||(i=n),{h:n,v:i}}(t.collision),w=t.boundary,D=k(t.boundaryOffset),I={mySize:(0,i.getOuterWidth)(n),myAlign:h.h,atAlign:p.h,offset:y.h,collision:b.h,boundaryOffset:D.h},M={mySize:(0,i.getOuterHeight)(n),myAlign:h.v,atAlign:p.v,offset:y.v,collision:b.v,boundaryOffset:D.v};if(m.preventDefault)I.atLocation=m.pageX,M.atLocation=m.pageY,I.atSize=0,M.atSize=0;else if(m=(0,o.default)(m),(0,u.isWindow)(m[0]))I.atLocation=m.scrollLeft(),M.atLocation=m.scrollTop(),"phone"===g.default.real().deviceType&&m[0].visualViewport?(I.atLocation=Math.max(I.atLocation,m[0].visualViewport.offsetLeft),M.atLocation=Math.max(M.atLocation,m[0].visualViewport.offsetTop),I.atSize=m[0].visualViewport.width,M.atSize=m[0].visualViewport.height):(I.atSize=m[0].innerWidth>m[0].outerWidth?m[0].innerWidth:(0,i.getWidth)(m),M.atSize=m[0].innerHeight>m[0].outerHeight||C?m[0].innerHeight:(0,i.getHeight)(m));else if(9===m[0].nodeType)I.atLocation=0,M.atLocation=0,I.atSize=(0,i.getWidth)(m),M.atSize=(0,i.getHeight)(m);else{var B=(0,c.getBoundingRect)(m.get(0)),V=L(m);I.atLocation=V.left,M.atLocation=V.top,I.atSize=Math.max(B.width,(0,i.getOuterWidth)(m)),M.atSize=Math.max(B.height,(0,i.getOuterHeight)(m))}O(I),O(M);var F=function(){var e=(0,o.default)(v),t=(0,i.getWidth)(e),n=(0,i.getHeight)(e),a=e.scrollLeft(),r=e.scrollTop(),s=l.default.getDocumentElement(),u=f.touch?s.clientWidth/t:1,d=f.touch?s.clientHeight/n:1;void 0===_&&P();var c=t,h=n;if(w){var p=(0,o.default)(w),g=p.offset();a=g.left,r=g.top,c=(0,i.getWidth)(p),h=(0,i.getHeight)(p)}return{h:{min:a+I.boundaryOffset,max:a+c/u-I.mySize-I.boundaryOffset},v:{min:r+M.boundaryOffset,max:r+h/d-M.mySize-M.boundaryOffset}}}();I.oversize=T(I,F.h),M.oversize=T(M,F.v),I.collisionSide=E("h",I,F.h),M.collisionSide=E("v",M,F.v),A[I.collision]&&A[I.collision](I,F.h),A[M.collision]&&A[M.collision](M,F.v);var H=function(e){return t.precise?e:Math.round(e)};return(0,d.extend)(!0,s,{h:{location:H(I.myLocation),oversize:H(I.oversize),fit:I.fit,flip:I.flip,collisionSide:I.collisionSide},v:{location:H(M.myLocation),oversize:H(M.oversize),fit:M.fit,flip:M.flip,collisionSide:M.collisionSide},precise:t.precise}),s},B=function(e,t,n,i,o){(0,u.isDefined)(e.style)&&!l.default.isNode(e.style)?e.style.transform=o?n.replace(t,""):n:e.setAttribute("style",o?i.replace(t,""):i)},L=function e(t){var n,i,o,a=arguments.length>1&&void 0!==arguments[1]?arguments[1]:t,r=a.get(0);if(!r)return t.offset();var s,l=(null===(n=r.getAttribute)||void 0===n?void 0:n.call(r,"style"))||"",u=null===(i=r.style)||void 0===i?void 0:i.transform,d=null===(o=l.match(w))||void 0===o?void 0:o[0];return d?(B(r,d,u,l,!0),s=e(t,a.parent()),B(r,d,u,l,!1)):s=e(t,a.parent()),s},V=function(e,t){var n=(0,o.default)(e);if(!t)return n.offset();(0,p.resetPosition)(n,!0);var i=L(n),a=t.h&&t.v?t:M(n,t),r=function(e){return t.precise?e:Math.round(e)};return(0,p.move)(n,{left:a.h.location-r(i.left),top:a.v.location-r(i.top)}),a};V.inverseAlign||(V.inverseAlign=I),V.normalizeAlign||(V.normalizeAlign=S);var F={calculateScrollbarWidth:P,calculate:M,setup:V,offset:function(e){return e=(0,o.default)(e).get(0),(0,u.isWindow)(e)?null:e&&"pageY"in e&&"pageX"in e?{top:e.pageY,left:e.pageX}:(0,o.default)(e).offset()}};t.default=F,e.exports=t.default,e.exports.default=t.default},42814:function(e,t,n){t.presets=t.PresetCollection=void 0;var i=n(58664),o=n(44297),a=n(95479),r=n(13306),s=u(n(20530)),l=u(n(87209));function u(e){return e&&e.__esModule?e:{default:e}}var d={forward:" dx-forward",backward:" dx-backward",none:" dx-no-direction",undefined:" dx-no-direction"},c=o.Component.inherit({ctor:function(){this.callBase.apply(this,arguments),this._registeredPresets=[],this.resetToDefaults()},_getDefaultOptions:function(){return(0,r.extend)(this.callBase(),{defaultAnimationDuration:400,defaultAnimationDelay:0,defaultStaggerAnimationDuration:300,defaultStaggerAnimationDelay:40,defaultStaggerAnimationStartDelay:500})},_defaultOptionsRules:function(){return this.callBase().concat([{device:function(e){return e.phone},options:{defaultStaggerAnimationDuration:350,defaultStaggerAnimationDelay:50,defaultStaggerAnimationStartDelay:0}},{device:function(){return s.default.current().android||s.default.real.android},options:{defaultAnimationDelay:100}}])},_getPresetOptionName:function(e){return"preset_"+e},_createAndroidSlideAnimationConfig:function(e,t){var n=this,o=function(e){return{type:"slide",delay:void 0===e.delay?n.option("defaultAnimationDelay"):e.delay,duration:void 0===e.duration?n.option("defaultAnimationDuration"):e.duration}};return{enter:function(n,a){var r=(0,i.getWidth)(n.parent())*t,s=a.direction,u=o(a);return u.to={left:0,opacity:1},u.from="forward"===s?{left:r,opacity:e}:"backward"===s?{left:-r,opacity:e}:{left:0,opacity:0},l.default.createAnimation(n,u)},leave:function(n,a){var r=(0,i.getWidth)(n.parent())*t,s=a.direction,u=o(a);return u.from={left:0,opacity:1},u.to="forward"===s?{left:-r,opacity:e}:"backward"===s?{left:r,opacity:e}:{left:0,opacity:0},l.default.createAnimation(n,u)}}},_createOpenDoorConfig:function(){var e=this,t=function(t){return{type:"css",extraCssClasses:"dx-opendoor-animation",delay:void 0===t.delay?e.option("defaultAnimationDelay"):t.delay,duration:void 0===t.duration?e.option("defaultAnimationDuration"):t.duration}};return{enter:function(e,n){var i=n.direction,o=t(n);return o.delay="none"===i?o.delay:o.duration,o.from="dx-enter dx-opendoor-animation"+d[i],o.to="dx-enter-active",l.default.createAnimation(e,o)},leave:function(e,n){var i=n.direction,o=t(n);return o.from="dx-leave dx-opendoor-animation"+d[i],o.to="dx-leave-active",l.default.createAnimation(e,o)}}},_createWinPopConfig:function(){var e=this,t={type:"css",extraCssClasses:"dx-win-pop-animation",duration:e.option("defaultAnimationDuration")};return{enter:function(n,i){var o=t,a=i.direction;return o.delay="none"===a?e.option("defaultAnimationDelay"):e.option("defaultAnimationDuration")/2,o.from="dx-enter dx-win-pop-animation"+d[a],o.to="dx-enter-active",l.default.createAnimation(n,o)},leave:function(n,i){var o=t,a=i.direction;return o.delay=e.option("defaultAnimationDelay"),o.from="dx-leave dx-win-pop-animation"+d[a],o.to="dx-leave-active",l.default.createAnimation(n,o)}}},resetToDefaults:function(){this.clear(),this.registerDefaultPresets(),this.applyChanges()},clear:function(e){var t=this,n=[];(0,a.each)(this._registeredPresets,(function(i,o){e&&e!==o.name?n.push(o):t.option(t._getPresetOptionName(o.name),void 0)})),this._registeredPresets=n,this.applyChanges()},registerPreset:function(e,t){this._registeredPresets.push({name:e,config:t})},applyChanges:function(){var e=this,t=[];(0,a.each)(this._registeredPresets,(function(n,i){var o={device:i.config.device,options:{}};o.options[e._getPresetOptionName(i.name)]=i.config.animation,t.push(o)})),this._setOptionsByDevice(t)},getPreset:function(e){for(var t=e;"string"==typeof t;)t=this.option(this._getPresetOptionName(t));return t},registerDefaultPresets:function(){this.registerPreset("pop",{animation:{extraCssClasses:"dx-android-pop-animation",delay:this.option("defaultAnimationDelay"),duration:this.option("defaultAnimationDuration")}}),this.registerPreset("openDoor",{animation:this._createOpenDoorConfig()}),this.registerPreset("win-pop",{animation:this._createWinPopConfig()}),this.registerPreset("fade",{animation:{extraCssClasses:"dx-fade-animation",delay:this.option("defaultAnimationDelay"),duration:this.option("defaultAnimationDuration")}}),this.registerPreset("slide",{device:function(){return s.default.current().android||s.default.real.android},animation:this._createAndroidSlideAnimationConfig(1,1)}),this.registerPreset("slide",{device:function(){return!s.default.current().android&&!s.default.real.android},animation:{extraCssClasses:"dx-slide-animation",delay:this.option("defaultAnimationDelay"),duration:this.option("defaultAnimationDuration")}}),this.registerPreset("ios7-slide",{animation:{extraCssClasses:"dx-ios7-slide-animation",delay:this.option("defaultAnimationDelay"),duration:this.option("defaultAnimationDuration")}}),this.registerPreset("overflow",{animation:{extraCssClasses:"dx-overflow-animation",delay:this.option("defaultAnimationDelay"),duration:this.option("defaultAnimationDuration")}}),this.registerPreset("ios7-toolbar",{device:function(){return!s.default.current().android&&!s.default.real.android},animation:{extraCssClasses:"dx-ios7-toolbar-animation",delay:this.option("defaultAnimationDelay"),duration:this.option("defaultAnimationDuration")}}),this.registerPreset("ios7-toolbar",{device:function(){return s.default.current().android||s.default.real.android},animation:this._createAndroidSlideAnimationConfig(0,.4)}),this.registerPreset("stagger-fade",{animation:{extraCssClasses:"dx-fade-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-slide",{animation:{extraCssClasses:"dx-slide-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-fade-slide",{animation:{extraCssClasses:"dx-fade-slide-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-drop",{animation:{extraCssClasses:"dx-drop-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-fade-drop",{animation:{extraCssClasses:"dx-fade-drop-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-fade-rise",{animation:{extraCssClasses:"dx-fade-rise-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-3d-drop",{animation:{extraCssClasses:"dx-3d-drop-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-fade-zoom",{animation:{extraCssClasses:"dx-fade-zoom-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}})}});t.PresetCollection=c;var h=new c;t.presets=h},52431:function(e,t,n){t.TransitionExecutor=void 0;var i=h(n(68374)),o=h(n(38377)),a=n(13306),r=n(20576),s=n(35922),l=n(95479),u=h(n(87209)),d=n(42814),c=n(62754);function h(e){return e&&e.__esModule?e:{default:e}}var p={forward:" dx-forward",backward:" dx-backward",none:" dx-no-direction",undefined:" dx-no-direction"},f=o.default.inherit({ctor:function(){this._accumulatedDelays={enter:0,leave:0},this._animations=[],this.reset()},_createAnimations:function(e,t,n,o){e=(0,i.default)(e);var a=this,r=[];n=n||{};var s=this._prepareElementAnimationConfig(t,n,o);return s&&e.each((function(){var e=a._createAnimation((0,i.default)(this),s,n);e&&(e.element.addClass("dx-animating"),e.setup(),r.push(e))})),r},_prepareElementAnimationConfig:function(e,t,n){var i;if("string"==typeof e){var o=e;e=d.presets.getPreset(o)}if(e)if((0,s.isFunction)(e[n]))i=e[n];else{if(!(i=(0,a.extend)({skipElementInitialStyles:!0,cleanupWhen:this._completePromise},e,t)).type||"css"===i.type){var r="dx-"+n,l=(i.extraCssClasses?" "+i.extraCssClasses:"")+p[i.direction];i.type="css",i.from=(i.from||r)+l,i.to=i.to||r+"-active"}i.staggerDelay=i.staggerDelay||0,i.delay=i.delay||0,i.staggerDelay&&(i.delay+=this._accumulatedDelays[n],this._accumulatedDelays[n]+=i.staggerDelay)}else i=void 0;return i},_createAnimation:function(e,t,n){var i;return(0,s.isPlainObject)(t)?i=u.default.createAnimation(e,t):(0,s.isFunction)(t)&&(i=t(e,n)),i},_startAnimations:function(){for(var e=this._animations,t=0;t<e.length;t++)e[t].start()},_stopAnimations:function(e){for(var t=this._animations,n=0;n<t.length;n++)t[n].stop(e)},_clearAnimations:function(){for(var e=this._animations,t=0;t<e.length;t++)e[t].element.removeClass("dx-animating");this._animations.length=0},reset:function(){this._accumulatedDelays.enter=0,this._accumulatedDelays.leave=0,this._clearAnimations(),this._completeDeferred=new c.Deferred,this._completePromise=this._completeDeferred.promise()},enter:function(e,t,n){var i=this._createAnimations(e,t,n,"enter");this._animations.push.apply(this._animations,i)},leave:function(e,t,n){var i=this._createAnimations(e,t,n,"leave");this._animations.push.apply(this._animations,i)},start:function(){var e,t=this;if(this._animations.length){var n=(0,l.map)(this._animations,(function(e){var t=new c.Deferred;return e.deferred.always((function(){t.resolve()})),t.promise()}));e=c.when.apply(i.default,n).always((function(){t._completeDeferred.resolve(),t.reset()})),(0,r.executeAsync)((function(){t._startAnimations()}))}else t.reset(),e=(new c.Deferred).resolve().promise();return e},stop:function(e){this._stopAnimations(e)}});t.TransitionExecutor=f},31648:function(e,t,n){t.resetPosition=t.parseTranslate=t.move=t.locate=t.getTranslateCss=t.getTranslate=t.clearCache=void 0;var i,o=(i=n(68374))&&i.__esModule?i:{default:i},a=n(97906),r=n(35922);var s=/matrix(3d)?\((.+?)\)/,l=/translate(?:3d)?\((.+?)\)/;function u(e){return"string"===(0,r.type)(e)&&"%"===e[e.length-1]}function d(e,t){e.length&&(0,a.data)(e.get(0),"dxTranslator",t)}t.locate=function(e){e=(0,o.default)(e);var t=p(e);return{left:t.x,top:t.y}};var c=function(e){e.length&&(0,a.removeData)(e.get(0),"dxTranslator")};t.clearCache=c;var h=function(e){return e.x=e.x||0,e.y=e.y||0,"translate("+(u(e.x)?e.x:e.x+"px")+", "+(u(e.y)?e.y:e.y+"px")+")"};t.getTranslateCss=h;var p=function(e){var t=e.length?(0,a.data)(e.get(0),"dxTranslator"):null;if(!t){var n=(e.css("transform")||h({x:0,y:0})).match(s),i=n&&n[1];n?(n=n[2].split(","),"3d"===i?n=n.slice(12,15):(n.push(0),n=n.slice(4,7))):n=[0,0,0],d(e,t={x:parseFloat(n[0]),y:parseFloat(n[1]),z:parseFloat(n[2])})}return t};t.getTranslate=p;t.move=function(e,t){e=(0,o.default)(e);var n,i=t.left,a=t.top;void 0===i?(n=p(e)).y=a||0:void 0===a?(n=p(e)).x=i||0:d(e,n={x:i||0,y:a||0,z:0}),e.css({transform:h(n)}),(u(i)||u(a))&&c(e)};t.resetPosition=function(e,t){var n;e=(0,o.default)(e);var i={left:0,top:0,transform:"none"};t&&(n=e.css("transition"),i.transition="none"),e.css(i),c(e),t&&(e.get(0).offsetHeight,e.css("transition",n))};t.parseTranslate=function(e){var t=e.match(l);if(t&&t[1])return t=t[1].split(","),t={x:parseFloat(t[0]),y:parseFloat(t[1]),z:parseFloat(t[2])}}},16354:function(e,t,n){t.default=void 0,n(85866),n(66312);var i,o=(i=n(36991))&&i.__esModule?i:{default:i},a=n(80566),r=n(95683);o.default.integration={},o.default.integration.EventsStrategy=a.EventsStrategy,o.default.integration.Options=r.Options;var s=o.default;t.default=s,e.exports=t.default,e.exports.default=t.default},36991:function(e,t,n){var i=n(58201).getWindow(),o=i.DevExpress=i.DevExpress||{},a=o.errors=n(17381);if(o._DEVEXTREME_BUNDLE_INITIALIZED)throw a.Error("E0024");o._DEVEXTREME_BUNDLE_INITIALIZED=!0,o.clientExporter=n(78292),o.excelExporter=n(2994),o.pdfExporter=n(44194),o.VERSION=n(36739).version,o.Class=n(38377),o.DOMComponent=n(13046),o.Component=n(44297).Component,o.registerComponent=n(99393),o.devices=n(20530),o.Color=n(52752);var r=n(90057);o.utils={},o.utils.requestAnimationFrame=r.requestAnimationFrame,o.utils.cancelAnimationFrame=r.cancelAnimationFrame,o.utils.initMobileViewport=n(88185).p,o.utils.getTimeZones=n(88673).Z,o.utils.extendFromObject=n(13306).extendFromObject,o.utils.triggerShownEvent=n(80506).triggerShownEvent,o.utils.triggerHidingEvent=n(80506).triggerHidingEvent,o.utils.resetActiveElement=n(3532).resetActiveElement,o.utils.findBestMatches=n(20576).findBestMatches,o.createQueue=n(59504).create,o.utils.dom=n(3532),o.utils.common=n(20576),o.utils.date=n(91198),o.utils.browser=n(47810),o.utils.inflector=n(78008),o.utils.iterator=n(95479),o.utils.readyCallbacks=n(24311),o.utils.resizeCallbacks=n(55814),o.utils.console=n(30869),o.utils.string=n(68752),o.utils.support=n(60137),o.utils.ajax=n(37208),o.viewPort=n(77695).value,o.hideTopOverlay=n(60628),o.formatHelper=n(30343),o.config=n(80209),o.animationPresets=n(42814).presets,o.fx=n(87209),o.TransitionExecutor=n(52431).TransitionExecutor,o.AnimationPresetCollection=n(42814).PresetCollection,o.events=n(66365),o.events.click=n(95429),o.events.utils=n(39611),o.events.GestureEmitter=n(98621),o.localization=n(94484),o.templateRendered=n(81033).renderedCallbacks,o.setTemplateEngine=n(72987).setTemplateEngine,e.exports=o},86635:function(e,t,n){var i=n(36991),o=n(17381);e.exports=i.data=i.data||{},Object.defineProperty(i.data,"errorHandler",{get:function(){return n(18438).errorHandler},set:function(e){o.log("W0003","DevExpress.data","errorHandler","21.1","Use the 'setErrorHandler' method instead"),n(18438).setErrorHandler(e)}}),Object.defineProperty(i.data,"_errorHandler",{get:function(){return n(18438).handleError},set:function(e){o.log("W0003","DevExpress.data","_errorHandler","21.1","Use the 'setErrorHandler' method instead"),n(18438).setErrorHandler(e)}}),i.data.setErrorHandler=n(18438).setErrorHandler,i.data.DataSource=n(33546),i.data.query=n(96687),i.data.Store=n(67403),i.data.ArrayStore=n(26562),i.data.CustomStore=n(88036),i.data.LocalStore=n(82837),i.data.base64_encode=n(16454).base64_encode,i.data.applyChanges=n(36893),i.data.Guid=n(73176),i.data.utils={},i.data.utils.compileGetter=n(47617).compileGetter,i.data.utils.compileSetter=n(47617).compileSetter,i.EndpointSelector=n(8162),i.data.queryImpl=n(77549).queryImpl,i.data.queryAdapters=n(16135);var a=n(16454);i.data.utils.normalizeBinaryCriterion=a.normalizeBinaryCriterion,i.data.utils.normalizeSortingInfo=a.normalizeSortingInfo,i.data.utils.errorMessageFromXhr=a.errorMessageFromXhr,i.data.utils.aggregators=a.aggregators,i.data.utils.keysEqual=a.keysEqual,i.data.utils.isDisjunctiveOperator=a.isDisjunctiveOperator,i.data.utils.isConjunctiveOperator=a.isConjunctiveOperator,i.data.utils.processRequestResultLock=a.processRequestResultLock,i.data.utils.toComparable=n(47617).toComparable,i.data.utils.multiLevelGroup=n(99236).multiLevelGroup,i.data.utils.arrangeSortingInfo=n(99236).arrangeSortingInfo,i.data.utils.normalizeDataSourceOptions=n(9234).normalizeDataSourceOptions},72343:function(e,t,n){n(86635),DevExpress.data.ODataStore=n(341),DevExpress.data.ODataContext=n(47256),DevExpress.data.utils=DevExpress.data.utils||{},DevExpress.data.utils.odata={},DevExpress.data.utils.odata.keyConverters=n(77869).keyConverters,DevExpress.data.EdmLiteral=n(77869).EdmLiteral;var i=n(77869);DevExpress.data.utils.odata.serializePropName=i.serializePropName,DevExpress.data.utils.odata.serializeValue=i.serializeValue,DevExpress.data.utils.odata.serializeKey=i.serializeKey,DevExpress.data.utils.odata.sendRequest=i.sendRequest,DevExpress.data.queryAdapters=DevExpress.data.queryAdapters||{},DevExpress.data.queryAdapters.odata=n(54263).odata},56208:function(e,t,n){var i=u(n(36991)),o=u(n(49816)),a=u(n(45765)),r=u(n(4323)),s=u(n(41332)),l=u(n(98831));function u(e){return e&&e.__esModule?e:{default:e}}e.exports=i.default.fileManagement=i.default.fileManagement||{},i.default.fileManagement.FileSystemError=o.default,i.default.fileManagement.FileSystemItem=a.default,i.default.fileManagement.ObjectFileSystemProvider=r.default,i.default.fileManagement.RemoteFileSystemProvider=s.default,i.default.fileManagement.CustomFileSystemProvider=l.default},85357:function(e,t,n){var i=n(36991);n(78475),n(71582),n(49281),n(74872),n(46949),n(908),n(60316),n(7239),n(95429),n(49166),n(85272),n(23174),n(11699),n(24028),n(93786),n(34309),n(91093),e.exports=i},94620:function(e,t,n){var i=n(85357).data=n(86635);i.odata=n(72343),e.exports=i},70527:function(e,t,n){var i,o=(i=n(85357))&&i.__esModule?i:{default:i};var a=n(56208);o.default.fileManagement=a,e.exports=a},66312:function(e,t,n){var i=n(85357);n(94620);var o=i.viz=n(20802);o.currentTheme=n(86231).currentTheme,o.registerTheme=n(86231).registerTheme,o.exportFromMarkup=n(5259).exportFromMarkup,o.getMarkup=n(5259).getMarkup,o.exportWidgets=n(5259).exportWidgets,o.currentPalette=n(23696).currentPalette,o.getPalette=n(23696).getPalette,o.generateColors=n(23696).generateColors,o.registerPalette=n(23696).registerPalette,o.refreshTheme=n(86231).refreshTheme,o.dxChart=n(99511),o.dxPieChart=n(72111),o.dxPolarChart=n(80919),o.dxLinearGauge=n(99630),o.dxCircularGauge=n(39847),o.dxBarGauge=n(45888),o.dxRangeSelector=n(82879),o.dxVectorMap=n(81849),o.map={},o.map.sources={},o.map.projection=n(102).projection,o.dxSparkline=n(43759),o.dxBullet=n(88950),o.dxTreeMap=n(15584),o.dxFunnel=n(30187),o.dxSankey=n(34377),o.BaseWidget=n(59063),o.getTheme=n(86231).getTheme,o.findTheme=n(86231).getTheme,o.refreshAll=n(86231).refreshTheme,o.refreshPaths=n(34434).refreshPaths,o.gauges={__internals:{}},o._dashboard={},o._dashboard.Renderer=n(56453).Renderer,o._dashboard.SvgElement=n(56453).SvgElement,o._dashboard.patchFontOptions=n(19157).patchFontOptions,e.exports=o},85866:function(e,t,n){n(64178),n(2025)},50779:function(e,t,n){var i=n(85357);n(94620),n(70527);var o=i.ui=n(26864);o.themes=n(75811),o.setTemplateEngine=n(72987).setTemplateEngine,o.dialog=n(15029),o.notify=n(59958),o.repaintFloatingActionButton=n(81374),o.hideToasts=n(33964),o.dxActionSheet=n(81476),o.dxAutocomplete=n(65418),o.dxBox=n(55551),o.dxButton=n(63008),o.dxDropDownButton=n(45231),o.dxButtonGroup=n(28236),o.dxCalendar=n(26559),o.dxCheckBox=n(18859),o.dxColorBox=n(4278),o.dxDateBox=n(29589),o.dxDrawer=n(45065),o.dxDeferRendering=n(28414),o.dxDropDownBox=n(36646),o.dxDropDownMenu=n(79561),o.dxFileUploader=n(53749),o.dxForm=n(17737),o.dxGallery=n(49433),o.dxHtmlEditor=n(9619),o.dxList=n(86e3),o.dxLoadIndicator=n(2492),o.dxLoadPanel=n(97218),o.dxLookup=n(55935),o.dxMap=n(64304),o.dxMultiView=n(86478),o.dxNavBar=n(65089),o.dxNumberBox=n(34171),o.dxOverlay=n(89799),o.dxPopover=n(22348),o.dxPopup=n(39114),o.dxProgressBar=n(28080),o.dxRadioGroup=n(14305),o.dxRangeSlider=n(36992),o.dxResizable=n(46743),o.dxResponsiveBox=n(21643),o.dxScrollView=n(4741),o.dxSelectBox=n(78665),o.dxSlider=n(97834),o.dxSpeedDialAction=n(17017),o.dxSwitch=n(31609),o.dxTabPanel=n(21807),o.dxTabs=n(13453),o.dxTagBox=n(31362),o.dxTextArea=n(51237),o.dxTextBox=n(29837),o.dxTileView=n(93094),o.dxToast=n(37748),o.dxToolbar=n(71042),o.dxTooltip=n(94920),o.dxTrackBar=n(39661),o.dxDraggable=n(42160),o.dxSortable=n(66843),i.validationEngine=n(90964),o.dxValidationSummary=n(97289),o.dxValidationGroup=n(4401),o.dxValidator=n(39562),n(52935),o.CollectionWidget=n(11050),o.dxDropDownEditor=n(44687),e.exports=o},64178:function(e,t,n){var i=n(50779);i.dxSlideOut=n(85643),i.dxSlideOutView=n(92719)},2025:function(e,t,n){var i=n(94620),o=n(50779);o.dxAccordion=n(76219),o.dxContextMenu=n(10042),o.dxDataGrid=n(1186),o.dxDataGridNext=n(84063),o.dxTreeList=n(82655),o.dxMenu=n(76995),o.dxPivotGrid=n(96089),o.dxPivotGridFieldChooser=n(32014),i.PivotGridDataSource=n(98713),i.XmlaStore=n(9170),o.dxScheduler=n(9508),o.dxTreeView=n(30254),o.dxFilterBuilder=n(20301),o.dxFileManager=n(87446),o.dxDiagram=n(52311),o.dxGantt=n(33465)},26864:function(e,t,n){n(36991),e.exports=DevExpress.ui={}},20802:function(e,t,n){n(36991),e.exports=DevExpress.viz=DevExpress.viz||{}},52752:function(e,t){t.default=void 0;var n={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dimgrey:"696969",dodgerblue:"1e90ff",feldspar:"d19275",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",grey:"808080",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightslategrey:"778899",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta:"ff00ff",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370d8",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"d87093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",rebeccapurple:"663399",red:"ff0000",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",slategrey:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",violetred:"d02090",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow:"ffff00",yellowgreen:"9acd32"},i=[{re:/^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process:function(e){return[parseInt(e[1],10),parseInt(e[2],10),parseInt(e[3],10)]}},{re:/^rgba\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3}),\s*(\d*\.*\d+)\)$/,process:function(e){return[parseInt(e[1],10),parseInt(e[2],10),parseInt(e[3],10),parseFloat(e[4])]}},{re:/^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/,process:function(e){return[parseInt(e[1],16),parseInt(e[2],16),parseInt(e[3],16)]}},{re:/^#([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})$/,process:function(e){return[parseInt(e[1]+e[1],16),parseInt(e[2]+e[2],16),parseInt(e[3]+e[3],16)]}},{re:/^hsv\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process:function(e){var t=parseInt(e[1],10),n=parseInt(e[2],10),i=parseInt(e[3],10),o=s(t,n,i);return[o[0],o[1],o[2],1,[t,n,i]]}},{re:/^hsl\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process:function(e){var t=parseInt(e[1],10),n=parseInt(e[2],10),i=parseInt(e[3],10),o=d(t,n,i);return[o[0],o[1],o[2],1,null,[t,n,i]]}}],o=Math.round;function a(e){var t;this.baseColor=e,e&&(t=String(e).toLowerCase().replace(/ /g,""),t=function(e){if("transparent"===e)return[0,0,0,0];for(var t,n=0,o=i.length;n<o;++n)if(t=i[n].re.exec(e))return i[n].process(t);return null}(t=n[t]?"#"+n[t]:t)),t||(this.colorIsInvalid=!0),t=t||{},this.r=r(t[0]),this.g=r(t[1]),this.b=r(t[2]),this.a=r(t[3],1,1),t[4]?this.hsv={h:t[4][0],s:t[4][1],v:t[4][2]}:this.hsv=function(e,t,n){var i,o,a=Math.max(e,t,n),r=Math.min(e,t,n),s=a-r,l=a;if(o=0===a?0:1-r/a,a===r)i=0;else switch(a){case e:i=(t-n)/s*60,t<n&&(i+=360);break;case t:i=(n-e)/s*60+120;break;case n:i=(e-t)/s*60+240}return o*=100,l*=100/255,{h:Math.round(i),s:Math.round(o),v:Math.round(l)}}(this.r,this.g,this.b),t[5]?this.hsl={h:t[5][0],s:t[5][1],l:t[5][2]}:this.hsl=function(e,t,n){e=c(e,255),t=c(t,255),n=c(n,255);var i,a,r=Math.max(e,t,n),s=Math.min(e,t,n),l=r+s,u=l/2;if(r===s)i=a=0;else{var d=r-s;a=u>.5?d/(2-l):d/l,i=function(e,t,n,i){switch(Math.max(e,t,n)){case e:return(t-n)/i+(t<n?6:0);case t:return(n-e)/i+2;case n:return(e-t)/i+4}}(e,t,n,d),i/=6}return{h:o(360*i),s:o(100*a),l:o(100*u)}}(this.r,this.g,this.b)}function r(e,t,n){return t=t||0,n=n||255,e<0||isNaN(e)?t:e>n?n:e}function s(e,t,n){var i,o,a,r=(100-t)*n/100,s=e%60/60*(n-r),l=r+s,u=n-s;switch(Math.floor(e%360/60)){case 0:i=n,o=l,a=r;break;case 1:i=u,o=n,a=r;break;case 2:i=r,o=n,a=l;break;case 3:i=r,o=u,a=n;break;case 4:i=l,o=r,a=n;break;case 5:i=n,o=r,a=u}return[Math.round(2.55*i),Math.round(2.55*o),Math.round(2.55*a)]}function l(e,t){var n=t;return"r"===e&&(n=t+1/3),"b"===e&&(n=t-1/3),n}function u(e,t,n){return(n=function(e){return e<0&&(e+=1),e>1&&(e-=1),e}(n))<1/6?e+6*(t-e)*n:n<.5?t:n<2/3?e+(t-e)*(2/3-n)*6:e}function d(e,t,n){var i,a,r;if(e=c(e,360),t=c(t,100),n=c(n,100),0===t)i=a=r=n;else{var s=n<.5?n*(1+t):n+t-n*t,d=2*n-s;i=u(d,s,l("r",e)),a=u(d,s,l("g",e)),r=u(d,s,l("b",e))}return[o(255*i),o(255*a),o(255*r)]}function c(e,t){return e=Math.min(t,Math.max(0,parseFloat(e))),Math.abs(e-t)<1e-6?1:e%t/parseFloat(t)}function h(e,t,n){return t=t||0,n=n||255,!(e%1!=0||e<t||e>n||"number"!=typeof e||isNaN(e))}a.prototype={constructor:a,highlight:function(e){return e=e||10,this.alter(e).toHex()},darken:function(e){return e=e||10,this.alter(-e).toHex()},alter:function(e){var t=new a;return t.r=r(this.r+e),t.g=r(this.g+e),t.b=r(this.b+e),t},blend:function(e,t){var n=e instanceof a?e:new a(e),i=new a;return i.r=r(o(this.r*(1-t)+n.r*t)),i.g=r(o(this.g*(1-t)+n.g*t)),i.b=r(o(this.b*(1-t)+n.b*t)),i},toHex:function(){return e=this.r,t=this.g,n=this.b,"#"+(16777216|e<<16|t<<8|n).toString(16).slice(1);var e,t,n},getPureColor:function(){return new a("rgb("+s(this.hsv.h,100,100).join(",")+")")},isValidHex:function(e){return/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(e)},isValidRGB:function(e,t,n){return!!(h(e)&&h(t)&&h(n))},isValidAlpha:function(e){return!(isNaN(e)||e<0||e>1||"number"!=typeof e)},colorIsInvalid:!1,fromHSL:function(e){var t=new a,n=d(e.h,e.s,e.l);return t.r=n[0],t.g=n[1],t.b=n[2],t}};var p=a;t.default=p,e.exports=t.default,e.exports.default=t.default},62414:function(e,t,n){t.default=void 0;var i,o=(i=n(68374))&&i.__esModule?i:{default:i},a=n(58201),r=n(35922),s=n(95479);var l=function(){function e(e,t){t=t||{},this._action=e,this._context=t.context||(0,a.getWindow)(),this._beforeExecute=t.beforeExecute,this._afterExecute=t.afterExecute,this._component=t.component,this._validatingTargetName=t.validatingTargetName;var n=this._excludeValidators={};if(t.excludeValidators)for(var i=0;i<t.excludeValidators.length;i++)n[t.excludeValidators[i]]=!0}var t=e.prototype;return t.execute=function(){var e={action:this._action,args:Array.prototype.slice.call(arguments),context:this._context,component:this._component,validatingTargetName:this._validatingTargetName,cancel:!1,handled:!1},t=this._beforeExecute,n=this._afterExecute,i=e.args[0]||{};if(this._validateAction(e)&&(null==t||t.call(this._context,e),!e.cancel)){var o=this._executeAction(e);if(!i.cancel)return null==n||n.call(this._context,e),o}},t._validateAction=function(t){var n=this._excludeValidators,i=e.executors;for(var o in i)if(!n[o]){var a,r=i[o];if(null===(a=r.validate)||void 0===a||a.call(r,t),t.cancel)return!1}return!0},t._executeAction=function(t){var n,i=e.executors;for(var o in i){var a,r=i[o];if(null===(a=r.execute)||void 0===a||a.call(r,t),t.handled){n=t.result;break}}return n},e.registerExecutor=function(t,n){(0,r.isPlainObject)(t)?(0,s.each)(t,e.registerExecutor):e.executors[t]=n},e.unregisterExecutor=function(){for(var t=arguments.length,n=new Array(t),i=0;i<t;i++)n[i]=arguments[i];(0,s.each)(n,(function(){delete e.executors[this]}))},e}();t.default=l,l.executors={};var u=function(e){return function(t){if(t.args.length){var n=t.args[0],i=n[t.validatingTargetName]||n.element;i&&e((0,o.default)(i))&&(t.cancel=!0)}}};l.registerExecutor({disabled:{validate:u((function(e){return e.is(".dx-state-disabled, .dx-state-disabled *")}))},readOnly:{validate:u((function(e){return e.is(".dx-state-readonly, .dx-state-readonly *:not(.dx-state-independent)")}))},undefined:{execute:function(e){e.action||(e.result=void 0,e.handled=!0)}},func:{execute:function(e){(0,r.isFunction)(e.action)&&(e.result=e.action.call(e.context,e.args[0]),e.handled=!0)}}}),e.exports=t.default,e.exports.default=t.default},38377:function(e,t,n){t.default=void 0;var i,o=(i=n(17381))&&i.__esModule?i:{default:i},a=n(35922);var r,s=function(e,t,n){return function(){var i=this.callBase;this.callBase=e[t];try{return n.apply(this,arguments)}finally{this.callBase=i}}},l=function(e){var t,n,i;if(!e)return this;for(n in e)i=e[n],t="function"==typeof this.prototype[n]&&"function"==typeof i,this.prototype[n]=t?s(this.parent.prototype,n,i):i;return this},u=function(){var e,t,n,i=this,o=Object.prototype.hasOwnProperty.bind(i),a=!o("_includedCtors")&&!o("_includedPostCtors");for(a&&(i._includedCtors=i._includedCtors.slice(0),i._includedPostCtors=i._includedPostCtors.slice(0)),n=0;n<arguments.length;n++)for(t in(e=arguments[n]).ctor&&i._includedCtors.push(e.ctor),e.postCtor&&i._includedPostCtors.push(e.postCtor),e)"ctor"!==t&&"postCtor"!==t&&"default"!==t&&(i.prototype[t]=e[t]);return i},d=function(e){if(!Object.prototype.hasOwnProperty.bind(this)("parent")&&this.parent){var t=Object.getPrototypeOf(this);return t===e||t.subclassOf(e)}return this.parent===e||!(!this.parent||!this.parent.subclassOf)&&this.parent.subclassOf(e)},c=function(){throw o.default.Error("E0001")},h=(r=Object.prototype.hasOwnProperty,function(e,t){for(var n in e){if(!r.call(e,n))return;t[n]=e[n]}}),p=function(){};p.inherit=function(e){var t=function(){if(!this||(0,a.isWindow)(this)||"function"!=typeof this.constructor)throw o.default.Error("E0003");var e,t=this,n=t.ctor,i=t.constructor._includedCtors,r=t.constructor._includedPostCtors;for(e=0;e<i.length;e++)i[e].call(t);for(n&&n.apply(t,arguments),e=0;e<r.length;e++)r[e].call(t)};return t.prototype=function(e){var t=function(){};return t.prototype=e.prototype,new t}(this),h(this,t),t.inherit=this.inherit,t.abstract=c,t.redefine=l,t.include=u,t.subclassOf=d,t.parent=this,t._includedCtors=this._includedCtors?this._includedCtors.slice(0):[],t._includedPostCtors=this._includedPostCtors?this._includedPostCtors.slice(0):[],t.prototype.constructor=t,t.redefine(e),t},p.abstract=c;var f=p;t.default=f,e.exports=t.default,e.exports.default=t.default},44297:function(e,t,n){t.Component=void 0;var i=_(n(80209)),o=n(13306),a=n(95683),r=n(45434),s=_(n(38377)),l=_(n(62414)),u=_(n(17381)),d=_(n(44504)),c=n(80566),h=n(9321),p=n(90889),f=n(35922),g=n(20576),m=n(47617);function _(e){return e&&e.__esModule?e:{default:e}}var v=function(e){return e.charAt(2).toLowerCase()+e.substr(3)},y=s.default.inherit({_setDeprecatedOptions:function(){this._deprecatedOptions={}},_getDeprecatedOptions:function(){return this._deprecatedOptions},_getDefaultOptions:function(){return{onInitialized:null,onOptionChanged:null,onDisposing:null,defaultOptionsRules:null}},_defaultOptionsRules:function(){return[]},_setOptionsByDevice:function(e){this._options.applyRules(e)},_convertRulesToOptions:function(e){return(0,r.convertRulesToOptions)(e)},_isInitialOptionValue:function(e){return this._options.isInitial(e)},_setOptionsByReference:function(){this._optionsByReference={}},_getOptionsByReference:function(){return this._optionsByReference},ctor:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},t=e._optionChangedCallbacks,n=e._disposingCallbacks;this.NAME=(0,h.name)(this.constructor),this._eventsStrategy=c.EventsStrategy.create(this,e.eventsStrategy),this._updateLockCount=0,this._optionChangedCallbacks=t||(0,d.default)(),this._disposingCallbacks=n||(0,d.default)(),this.postponedOperations=new p.PostponedOperations,this._createOptions(e)},_createOptions:function(e){var t=this;this.beginUpdate();try{this._setOptionsByReference(),this._setDeprecatedOptions(),this._options=new a.Options(this._getDefaultOptions(),this._getDefaultOptions(),this._getOptionsByReference(),this._getDeprecatedOptions()),this._options.onChanging((function(e,n,i){return t._initialized&&t._optionChanging(e,n,i)})),this._options.onDeprecated((function(e,n){return t._logDeprecatedOptionWarning(e,n)})),this._options.onChanged((function(e,n,i){return t._notifyOptionChanged(e,n,i)})),this._options.onStartChange((function(){return t.beginUpdate()})),this._options.onEndChange((function(){return t.endUpdate()})),this._options.addRules(this._defaultOptionsRules()),e&&e.onInitializing&&e.onInitializing.apply(this,[e]),this._setOptionsByDevice(e.defaultOptionsRules),this._initOptions(e)}finally{this.endUpdate()}},_initOptions:function(e){this.option(e)},_init:function(){var e=this;this._createOptionChangedAction(),this.on("disposing",(function(t){e._disposingCallbacks.fireWith(e,[t])}))},_logDeprecatedOptionWarning:function(e,t){var n=t.message||"Use the '".concat(t.alias,"' option instead");u.default.log("W0001",this.NAME,e,t.since,n)},_logDeprecatedComponentWarning:function(e,t){u.default.log("W0000",this.NAME,e,"Use the '".concat(t,"' widget instead"))},_createOptionChangedAction:function(){this._optionChangedAction=this._createActionByOption("onOptionChanged",{excludeValidators:["disabled","readOnly"]})},_createDisposingAction:function(){this._disposingAction=this._createActionByOption("onDisposing",{excludeValidators:["disabled","readOnly"]})},_optionChanged:function(e){switch(e.name){case"onDisposing":case"onInitialized":break;case"onOptionChanged":this._createOptionChangedAction()}},_dispose:function(){this._optionChangedCallbacks.empty(),this._createDisposingAction(),this._disposingAction(),this._eventsStrategy.dispose(),this._options.dispose(),this._disposed=!0},_lockUpdate:function(){this._updateLockCount++},_unlockUpdate:function(){this._updateLockCount=Math.max(this._updateLockCount-1,0)},_isUpdateAllowed:function(){return 0===this._updateLockCount},_isInitializingRequired:function(){return!this._initializing&&!this._initialized},isInitialized:function(){return this._initialized},_commitUpdate:function(){this.postponedOperations.callPostponedOperations(),this._isInitializingRequired()&&this._initializeComponent()},_initializeComponent:function(){this._initializing=!0;try{this._init()}finally{this._initializing=!1,this._lockUpdate(),this._createActionByOption("onInitialized",{excludeValidators:["disabled","readOnly"]})(),this._unlockUpdate(),this._initialized=!0}},instance:function(){return this},beginUpdate:function(){this._lockUpdate()},endUpdate:function(){this._unlockUpdate(),this._isUpdateAllowed()&&this._commitUpdate()},_optionChanging:g.noop,_notifyOptionChanged:function(e,t,n){if(this._initialized)for(var i=[e].concat(this._options.getAliasesByName(e)),a=0;a<i.length;a++){var r=i[a],s={name:(0,m.getPathParts)(r)[0],fullName:r,value:t,previousValue:n};0!==r.indexOf("_",0)&&(this._optionChangedCallbacks.fireWith(this,[(0,o.extend)(this._defaultActionArgs(),s)]),this._optionChangedAction((0,o.extend)({},s))),this._disposed||this._cancelOptionChange===r||this._optionChanged(s)}},initialOption:function(e){return this._options.initial(e)},_defaultActionConfig:function(){return{context:this,component:this}},_defaultActionArgs:function(){return{component:this}},_createAction:function(e,t){var n,i=this;return function(a){return(0,f.isDefined)(a)||(a={}),(0,f.isPlainObject)(a)||(a={actionValue:a}),(n=n||new l.default(e,(0,o.extend)(t,i._defaultActionConfig()))).execute.call(n,(0,o.extend)(a,i._defaultActionArgs()))}},_createActionByOption:function(e,t){var n,o,a,r=this,s=function(){if(!o){if(t=t||{},"string"!=typeof e)throw u.default.Error("E0008");0===e.indexOf("on")&&(o=v(e)),a=r.option(e)}if(n||a||t.beforeExecute||t.afterExecute||r._eventsStrategy.hasEvent(o)){if(!n){var s=t.beforeExecute;t.beforeExecute=function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];s&&s.apply(r,t),r._eventsStrategy.fireEvent(o,t[0].args)},n=r._createAction(a,t)}for(var l=arguments.length,d=new Array(l),c=0;c<l;c++)d[c]=arguments[c];if((0,i.default)().wrapActionsBeforeExecute){var h=r.option("beforeActionExecute")||g.noop,p=h(r,n,t)||n;return p.apply(r,d)}return n.apply(r,d)}};return(0,i.default)().wrapActionsBeforeExecute?s:(this.option("onActionCreated")||g.noop)(this,s,t)||s},on:function(e,t){return this._eventsStrategy.on(e,t),this},off:function(e,t){return this._eventsStrategy.off(e,t),this},hasActionSubscription:function(e){return!!this._options.silent(e)||this._eventsStrategy.hasEvent(v(e))},isOptionDeprecated:function(e){return this._options.isDeprecated(e)},_setOptionWithoutOptionChange:function(e,t){this._cancelOptionChange=e,this.option(e,t),this._cancelOptionChange=!1},_getOptionValue:function(e,t){var n=this.option(e);return(0,f.isFunction)(n)?n.bind(t)():n},option:function(){var e;return(e=this._options).option.apply(e,arguments)},resetOption:function(e){this.beginUpdate(),this._options.reset(e),this.endUpdate()}});t.Component=y},99393:function(e,t,n){t.default=void 0;var i=s(n(68374)),o=s(n(5554)),a=s(n(17381)),r=n(9321);function s(e){return e&&e.__esModule?e:{default:e}}o.default.add((function(e,t){i.default.fn[e]=function(n){var i,o="string"==typeof n;if(o){var r=n,s=[].slice.call(arguments).slice(1);this.each((function(){var n=t.getInstance(this);if(!n)throw a.default.Error("E0009",e);var o=n[r].apply(n,s);void 0===i&&(i=o)}))}else this.each((function(){var e=t.getInstance(this);e?e.option(n):new t(this,n)})),i=this;return i}}));var l=function(e,t,n){n?t[e]=n:n=t,(0,r.name)(n,e),o.default.fire(e,n)};t.default=l,e.exports=t.default,e.exports.default=t.default},5554:function(e,t,n){var i;t.default=void 0;var o=new(((i=n(83358))&&i.__esModule?i:{default:i}).default);t.default=o,e.exports=t.default,e.exports.default=t.default},80209:function(e,t,n){t.default=void 0;var i,o=n(13306),a=(i=n(17381))&&i.__esModule?i:{default:i};var r={rtlEnabled:!1,defaultCurrency:"USD",defaultUseCurrencyAccountingStyle:!0,oDataFilterToLower:!0,serverDecimalSeparator:".",decimalSeparator:".",thousandsSeparator:",",forceIsoDateParsing:!0,wrapActionsBeforeExecute:!0,useLegacyStoreResult:!1,useJQuery:void 0,editorStylingMode:void 0,useLegacyVisibleIndex:!1,floatingActionButtonConfig:{icon:"add",closeIcon:"close",label:"",position:{at:"right bottom",my:"right bottom",offset:{x:-16,y:-16}},maxSpeedDialActionCount:5,shading:!1,direction:"auto"},optionsParser:function(e){"{"!==e.trim().charAt(0)&&(e="{"+e+"}");try{return new Function("return "+e)()}catch(t){throw a.default.Error("E3018",t,e)}}},s=["decimalSeparator","thousandsSeparator"],l=function(){if(!arguments.length)return r;var e=arguments.length<=0?void 0:arguments[0];s.forEach((function(t){if(e[t]){var n="Now, the ".concat(t," is selected based on the specified locale.");a.default.log("W0003","config",t,"19.2",n)}})),(0,o.extend)(r,e)};"undefined"!=typeof DevExpress&&DevExpress.config&&l(DevExpress.config);var u=l;t.default=u,e.exports=t.default,e.exports.default=t.default},20530:function(e,t,n){t.default=void 0;var i=n(58664),o=_(n(68374)),a=n(58201),r=n(13306),s=n(35922),l=n(95479),u=_(n(17381)),d=_(n(44504)),c=_(n(24311)),h=_(n(55814)),p=n(80566),f=n(36613),g=n(77695),m=_(n(80209));function _(e){return e&&e.__esModule?e:{default:e}}var v=(0,a.getNavigator)(),y=(0,a.getWindow)(),b={iPhone:"iPhone",iPhone5:"iPhone",iPhone6:"iPhone",iPhone6plus:"iPhone",iPad:"iPad",iPadMini:"iPad Mini",androidPhone:"Android Mobile",androidTablet:"Android",msSurface:"Windows ARM Tablet PC",desktop:"desktop"},x={deviceType:"desktop",platform:"generic",version:[],phone:!1,tablet:!1,android:!1,ios:!1,generic:!0,grade:"A",mac:!1},w={generic:function(e){var t=/windows phone/i.test(e)||e.match(/WPDesktop/),n=!t&&/Windows(.*)arm(.*)Tablet PC/i.test(e),i=!t&&!n&&/msapphost/i.test(e),o=/((intel|ppc) mac os x)/.test(e.toLowerCase());if(t||n||i||o)return{deviceType:t?"phone":n?"tablet":"desktop",platform:"generic",version:[],grade:"A",mac:o}},ios:function(e){if(/ip(hone|od|ad)/i.test(e)){var t=/ip(hone|od)/i.test(e),n=e.match(/os (\d+)_(\d+)_?(\d+)?/i);return{deviceType:t?"phone":"tablet",platform:"ios",version:n?[parseInt(n[1],10),parseInt(n[2],10),parseInt(n[3]||0,10)]:[],grade:480===y.screen.height?"B":"A"}}},android:function(e){if(/android|htc_|silk/i.test(e)){var t=/mobile/i.test(e),n=e.match(/android (\d+)\.?(\d+)?\.?(\d+)?/i),i=n?[parseInt(n[1],10),parseInt(n[2]||0,10),parseInt(n[3]||0,10)]:[];return{deviceType:t?"phone":"tablet",platform:"android",version:i,grade:i.length>1&&(i[0]<4||4===i[0]&&i[1]<4)?"B":"A"}}}},C=new(function(){function e(e){this._window=(null==e?void 0:e.window)||y,this._realDevice=this._getDevice(),this._currentDevice=void 0,this._currentOrientation=void 0,this._eventsStrategy=new p.EventsStrategy(this),this.changed=(0,d.default)(),(0,a.hasWindow)()&&(c.default.add(this._recalculateOrientation.bind(this)),h.default.add(this._recalculateOrientation.bind(this)))}var t=e.prototype;return t.current=function(e){if(e)return this._currentDevice=this._getDevice(e),this._forced=!0,void this.changed.fire();if(!this._currentDevice){e=void 0;try{e=this._getDeviceOrNameFromWindowScope()}catch(t){e=this._getDeviceNameFromSessionStorage()}finally{e||(e=this._getDeviceNameFromSessionStorage()),e&&(this._forced=!0)}this._currentDevice=this._getDevice(e)}return this._currentDevice},t.real=function(e){return(0,r.extend)({},this._realDevice)},t.orientation=function(){return this._currentOrientation},t.isForced=function(){return this._forced},t.isRippleEmulator=function(){return!!this._window.tinyHippos},t._getCssClasses=function(e){var t=[],n=this._realDevice;return(e=e||this.current()).deviceType&&(t.push("dx-device-".concat(e.deviceType)),"desktop"!==e.deviceType&&t.push("dx-device-mobile")),t.push("dx-device-".concat(n.platform)),n.version&&n.version.length&&t.push("dx-device-".concat(n.platform,"-").concat(n.version[0])),this.isSimulator()&&t.push("dx-simulator"),(0,m.default)().rtlEnabled&&t.push("dx-rtl"),t},t.attachCssClasses=function(e,t){this._deviceClasses=this._getCssClasses(t).join(" "),(0,o.default)(e).addClass(this._deviceClasses)},t.detachCssClasses=function(e){(0,o.default)(e).removeClass(this._deviceClasses)},t.isSimulator=function(){try{return this._isSimulator||(0,a.hasWindow)()&&this._window.top!==this._window.self&&this._window.top["dx-force-device"]||this.isRippleEmulator()}catch(e){return!1}},t.forceSimulator=function(){this._isSimulator=!0},t._getDevice=function(e){if("genericPhone"===e&&(e={deviceType:"phone",platform:"generic",generic:!0}),(0,s.isPlainObject)(e))return this._fromConfig(e);var t;if(e){if(!(t=b[e]))throw u.default.Error("E0005")}else t=v.userAgent;return this._fromUA(t)},t._getDeviceOrNameFromWindowScope=function(){var e;return(0,a.hasWindow)()&&(this._window.top["dx-force-device-object"]||this._window.top["dx-force-device"])&&(e=this._window.top["dx-force-device-object"]||this._window.top["dx-force-device"]),e},t._getDeviceNameFromSessionStorage=function(){var e=(0,f.sessionStorage)();if(e){var t=e.getItem("dx-force-device");try{return JSON.parse(t)}catch(e){return t}}},t._fromConfig=function(e){var t=(0,r.extend)({},x,this._currentDevice,e),n={phone:"phone"===t.deviceType,tablet:"tablet"===t.deviceType,android:"android"===t.platform,ios:"ios"===t.platform,generic:"generic"===t.platform};return(0,r.extend)(t,n)},t._fromUA=function(e){var t;return(0,l.each)(w,(function(n,i){return!(t=i(e))})),t?this._fromConfig(t):x},t._changeOrientation=function(){var e=(0,o.default)(this._window),t=(0,i.getHeight)(e)>(0,i.getWidth)(e)?"portrait":"landscape";this._currentOrientation!==t&&(this._currentOrientation=t,this._eventsStrategy.fireEvent("orientationChanged",[{orientation:t}]))},t._recalculateOrientation=function(){var e=(0,i.getWidth)(this._window);this._currentWidth!==e&&(this._currentWidth=e,this._changeOrientation())},t.on=function(e,t){return this._eventsStrategy.on(e,t),this},t.off=function(e,t){return this._eventsStrategy.off(e,t),this},e}()),S=(0,g.value)();S&&C.attachCssClasses(S),g.changeCallback.add((function(e,t){C.detachCssClasses(t),C.attachCssClasses(e)}));var k=C;t.default=k,e.exports=t.default,e.exports.default=t.default},73349:function(e,t,n){t.default=void 0;var i,o=(i=n(20476))&&i.__esModule?i:{default:i},a=n(20576);function r(e){return(r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var s={querySelectorAll:function(e,t){return e.querySelectorAll(t)},elementMatches:function(e,t){var n=this;return(e.matches||e.matchesSelector||e.mozMatchesSelector||e.msMatchesSelector||e.oMatchesSelector||e.webkitMatchesSelector||function(t){var i=e.document||e.ownerDocument;if(!i)return!1;for(var o=n.querySelectorAll(i,t),a=0;a<o.length;a++)if(o[a]===e)return!0}).call(e,t)},createElement:function(e,t){return(t=t||this._document).createElement(e)},createElementNS:function(e,t,n){return(n=n||this._document).createElementNS(e,t)},createTextNode:function(e,t){return(t=t||this._document).createTextNode(e)},isNode:function(e){return e&&"object"===r(e)&&"nodeType"in e&&"nodeName"in e},isElementNode:function(e){return e&&1===e.nodeType},isTextNode:function(e){return e&&3===e.nodeType},isDocument:function(e){return e&&9===e.nodeType},removeElement:function(e){var t=e&&e.parentNode;t&&t.removeChild(e)},insertElement:function(e,t,n){e&&t&&e!==t&&(n?e.insertBefore(t,n):e.appendChild(t))},getAttribute:function(e,t){return e.getAttribute(t)},setAttribute:function(e,t,n){e.setAttribute(t,n)},removeAttribute:function(e,t){e.removeAttribute(t)},setProperty:function(e,t,n){e[t]=n},setText:function(e,t){e&&(e.textContent=t)},setClass:function(e,t,n){1===e.nodeType&&t&&(n?e.classList.add(t):e.classList.remove(t))},setStyle:function(e,t,n){e.style[t]=n||""},_document:"undefined"==typeof document?void 0:document,getDocument:function(){return this._document},getActiveElement:function(e){var t,n;return(null!==(t=null==e||null===(n=e.getRootNode)||void 0===n?void 0:n.call(e))&&void 0!==t?t:this._document).activeElement},getBody:function(){return this._document.body},createDocumentFragment:function(){return this._document.createDocumentFragment()},getDocumentElement:function(){return this._document.documentElement},getLocation:function(){return this._document.location},getSelection:function(){return this._document.selection},getReadyState:function(){return this._document.readyState},getHead:function(){return this._document.head},hasDocumentProperty:function(e){return e in this._document},listen:function(e,t,n,i){return e&&"addEventListener"in e?(e.addEventListener(t,n,i),function(){e.removeEventListener(t,n)}):a.noop},elementsFromPoint:function(e,t){return this._document.elementsFromPoint(e,t)}},l=(0,o.default)(s);t.default=l,e.exports=t.default,e.exports.default=t.default},13046:function(e,t,n){t.default=void 0;var i=v(n(68374)),o=v(n(80209)),a=v(n(17381)),r=v(n(55814)),s=n(44297),l=n(14192),u=n(9321),d=n(97906),c=n(95479),h=n(13306),p=n(6415),f=n(20576),g=n(35922),m=n(58201),_=n(72918);function v(e){return e&&e.__esModule?e:{default:e}}var y=s.Component.abstract,b=s.Component.inherit({_getDefaultOptions:function(){return(0,h.extend)(this.callBase(),{width:void 0,height:void 0,rtlEnabled:(0,o.default)().rtlEnabled,elementAttr:{},disabled:!1,integrationOptions:{}},this._useTemplates()?l.TemplateManager.createDefaultOptions():{})},ctor:function(e,t){this._customClass=null,this._createElement(e),(0,u.attachInstanceToElement)(this._$element,this,this._dispose),this.callBase(t)},_createElement:function(e){this._$element=(0,i.default)(e)},_getSynchronizableOptionsForCreateComponent:function(){return["rtlEnabled","disabled","templatesRenderAsynchronously"]},_checkFunctionValueDeprecation:function(e){var t=this;this.option("_ignoreFunctionValueDeprecation")||e.forEach((function(e){(0,g.isFunction)(t.option(e))&&a.default.log("W0017",e)}))},_visibilityChanged:y,_dimensionChanged:y,_init:function(){this.callBase(),this._checkFunctionValueDeprecation(["width","height","maxHeight","maxWidth","minHeight","minWidth","popupHeight","popupWidth"]),this._attachWindowResizeCallback(),this._initTemplateManager()},_setOptionsByDevice:function(e){this.callBase([].concat(this.constructor._classCustomRules||[],e||[]))},_isInitialOptionValue:function(e){return!(this.constructor._classCustomRules&&Object.prototype.hasOwnProperty.call(this._convertRulesToOptions(this.constructor._classCustomRules),e))&&this.callBase(e)},_attachWindowResizeCallback:function(){if(this._isDimensionChangeSupported()){var e=this._windowResizeCallBack=this._dimensionChanged.bind(this);r.default.add(e)}},_isDimensionChangeSupported:function(){return this._dimensionChanged!==y},_renderComponent:function(){this._initMarkup(),(0,m.hasWindow)()&&this._render()},_initMarkup:function(){var e=(this.option()||{}).rtlEnabled;this._renderElementAttributes(),this._toggleRTLDirection(e),this._renderVisibilityChange(),this._renderDimensions()},_render:function(){this._attachVisibilityChangeHandlers()},_renderElementAttributes:function(){var e=(this.option()||{}).elementAttr,t=(0,h.extend)({},e),n=t.class;delete t.class,this.$element().attr(t).removeClass(this._customClass).addClass(n),this._customClass=n},_renderVisibilityChange:function(){(this._isDimensionChangeSupported()&&this._attachDimensionChangeHandlers(),this._isVisibilityChangeSupported())&&this.$element().addClass("dx-visibility-change-handler")},_renderDimensions:function(){var e=this.$element(),t=e.get(0),n=this._getOptionValue("width",t),i=this._getOptionValue("height",t);this._isCssUpdateRequired(t,i,n)&&e.css({width:null===n?"":n,height:null===i?"":i})},_isCssUpdateRequired:function(e,t,n){return!!((0,g.isDefined)(n)||(0,g.isDefined)(t)||e.style.width||e.style.height)},_attachDimensionChangeHandlers:function(){var e=this,t=this.$element(),n="".concat(this.NAME,"VisibilityChange");_.resize.off(t,{namespace:n}),_.resize.on(t,(function(){return e._dimensionChanged()}),{namespace:n})},_attachVisibilityChangeHandlers:function(){var e=this;if(this._isVisibilityChangeSupported()){var t=this.$element(),n="".concat(this.NAME,"VisibilityChange");this._isHidden=!this._isVisible(),_.visibility.off(t,{namespace:n}),_.visibility.on(t,(function(){return e._checkVisibilityChanged("shown")}),(function(){return e._checkVisibilityChanged("hiding")}),{namespace:n})}},_isVisible:function(){return this.$element().is(":visible")},_checkVisibilityChanged:function(e){this._isVisible()&&("hiding"!==e||this._isHidden?"shown"===e&&this._isHidden&&(this._isHidden=!1,this._visibilityChanged(!0)):(this._visibilityChanged(!1),this._isHidden=!0))},_isVisibilityChangeSupported:function(){return this._visibilityChanged!==y&&(0,m.hasWindow)()},_clean:f.noop,_modelByElement:function(){var e=this.option().modelByElement,t=this.$element();return e?e(t):void 0},_invalidate:function(){if(this._isUpdateAllowed())throw a.default.Error("E0007");this._requireRefresh=!0},_refresh:function(){this._clean(),this._renderComponent()},_dispose:function(){this._templateManager&&this._templateManager.dispose(),this.callBase(),this._clean(),this._detachWindowResizeCallback()},_detachWindowResizeCallback:function(){this._isDimensionChangeSupported()&&r.default.remove(this._windowResizeCallBack)},_toggleRTLDirection:function(e){this.$element().toggleClass("dx-rtl",e)},_createComponent:function(e,t){var n=this,o=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},a=(0,f.grep)(this._getSynchronizableOptionsForCreateComponent(),(function(e){return!(e in o)})),r=this.option(),s=r.integrationOptions,l=this.option(),u=l.nestedComponentOptions;u=u||f.noop;var d=(0,h.extend)({integrationOptions:s},u(this));a.forEach((function(e){return d[e]=n.option(e)})),this._extendConfig(o,d);var c=void 0;if((0,g.isString)(t)){var p=(0,i.default)(e)[t](o);c=p[t]("instance")}else e&&((c=t.getInstance(e))?c.option(o):c=new t(e,o));if(c){var m=function(e){var t=e.name,n=e.value;a.includes(t)&&c.option(t,n)};this.on("optionChanged",m),c.on("disposing",(function(){return n.off("optionChanged",m)}))}return c},_extendConfig:function(e,t){(0,c.each)(t,(function(t,n){!Object.prototype.hasOwnProperty.call(e,t)&&(e[t]=n)}))},_defaultActionConfig:function(){var e=this.$element(),t=this._modelByElement(e);return(0,h.extend)(this.callBase(),{context:t})},_defaultActionArgs:function(){var e=this.$element(),t=this._modelByElement(e),n=this.element();return(0,h.extend)(this.callBase(),{element:n,model:t})},_optionChanged:function(e){switch(e.name){case"width":case"height":this._renderDimensions();break;case"rtlEnabled":this._invalidate();break;case"elementAttr":this._renderElementAttributes();break;case"disabled":case"integrationOptions":break;default:this.callBase(e)}},_removeAttributes:function(e){for(var t=e.attributes,n=t.length-1;n>=0;n--){var i=t[n];if(i){var o=i.name;o.indexOf("aria-")&&-1===o.indexOf("dx-")&&"role"!==o&&"style"!==o&&"tabindex"!==o||e.removeAttribute(o)}}},_removeClasses:function(e){e.className=e.className.split(" ").filter((function(e){return 0!==e.lastIndexOf("dx-",0)})).join(" ")},_updateDOMComponent:function(e){e?this._renderComponent():this._requireRefresh&&(this._requireRefresh=!1,this._refresh())},endUpdate:function(){var e=this._isInitializingRequired();this.callBase(),this._isUpdateAllowed()&&this._updateDOMComponent(e)},$element:function(){return this._$element},element:function(){var e=this.$element();return(0,p.getPublicElement)(e)},dispose:function(){var e=this.$element().get(0);(0,d.cleanDataRecursive)(e,!0),e.textContent="",this._removeAttributes(e),this._removeClasses(e)},resetOption:function(e){if(this.callBase(e),"width"===e||"height"===e){var t=this.initialOption(e);!(0,g.isDefined)(t)&&this.$element().css(e,"")}},_getAnonymousTemplateName:function(){},_initTemplateManager:function(){if(!this._templateManager&&this._useTemplates()){var e=this.option().integrationOptions,t=(void 0===e?{}:e).createTemplate;this._templateManager=new l.TemplateManager(t,this._getAnonymousTemplateName()),this._initTemplates()}},_initTemplates:function(){var e=this,t=this._templateManager.extractTemplates(this.$element()),n=t.templates,i=t.anonymousTemplateMeta,o=this.option("integrationOptions.templates.".concat(i.name));n.forEach((function(t){var n=t.name,i=t.template;e._options.silent("integrationOptions.templates.".concat(n),i)})),i.name&&!o&&(this._options.silent("integrationOptions.templates.".concat(i.name),i.template),this._options.silent("_hasAnonymousTemplateContent",!0))},_getTemplateByOption:function(e){return this._getTemplate(this.option(e))},_getTemplate:function(e){var t=this.option("integrationOptions.templates"),n=this.option("templatesRenderAsynchronously"),i=this.option("integrationOptions.skipTemplates");return this._templateManager.getTemplate(e,t,{isAsyncTemplate:n,skipTemplates:i},this)},_saveTemplate:function(e,t){this._setOptionWithoutOptionChange("integrationOptions.templates."+e,this._templateManager._createTemplate(t))},_useTemplates:function(){return!0}});b.getInstance=function(e){return(0,u.getInstanceByElement)((0,i.default)(e),this)},b.defaultOptions=function(e){this._classCustomRules=this._classCustomRules||[],this._classCustomRules.push(e)};var x=b;t.default=x,e.exports=t.default,e.exports.default=t.default},6415:function(e,t){t.getPublicElement=function(e){return n(e)},t.setPublicElementWrapper=function(e){n=e};var n=function(e){return e&&e.get(0)}},97906:function(e,t,n){t.afterCleanData=function(e){c=e},t.beforeCleanData=function(e){d=e},t.cleanData=function(e){return s.cleanData.call(this,e)},t.cleanDataRecursive=function(e,t){if(!i.default.isElementNode(e))return;var n=e.getElementsByTagName("*");s.cleanData(n),t&&s.cleanData([e])},t.data=function(){return s.data.apply(this,arguments)},t.getDataStrategy=function(){return s},t.removeData=function(e,t){return s.removeData.call(this,e,t)},t.strategyChanging=t.setDataStrategy=void 0;var i=r(n(73349)),o=r(n(55994)),a=r(n(83358));function r(e){return e&&e.__esModule?e:{default:e}}var s,l=new WeakMap,u=new a.default;t.strategyChanging=u;var d=function(){},c=function(){},h=function(e){u.fire(e);var t=(s=e).cleanData;s.cleanData=function(e){d(e);var n=t.call(this,e);return c(e),n}};t.setDataStrategy=h,h({data:function(){var e=arguments[0],t=arguments[1],n=arguments[2];if(e){var i=l.get(e);return i||(i={},l.set(e,i)),void 0===t?i:2===arguments.length?i[t]:(i[t]=n,n)}},removeData:function(e,t){if(e)if(void 0===t)l.delete(e);else{var n=l.get(e);n&&delete n[t]}},cleanData:function(e){for(var t=0;t<e.length;t++)o.default.off(e[t]),l.delete(e[t])}})},17381:function(e,t,n){var i;t.default=void 0;var o=(0,((i=n(95640))&&i.__esModule?i:{default:i}).default)({E0001:"Method is not implemented",E0002:"Member name collision: {0}",E0003:"A class must be instantiated using the 'new' keyword",E0004:"The NAME property of the component is not specified",E0005:"Unknown device",E0006:"Unknown endpoint key is requested",E0007:"'Invalidate' method is called outside the update transaction",E0008:"Type of the option name is not appropriate to create an action",E0009:"Component '{0}' has not been initialized for an element",E0010:"Animation configuration with the '{0}' type requires '{1}' configuration as {2}",E0011:"Unknown animation type '{0}'",E0012:"jQuery version is too old. Please upgrade jQuery to 1.10.0 or later",E0013:"KnockoutJS version is too old. Please upgrade KnockoutJS to 2.3.0 or later",E0014:"The 'release' method shouldn't be called for an unlocked Lock object",E0015:"Queued task returned an unexpected result",E0017:"Event namespace is not defined",E0018:"DevExpress.ui.DevExpressPopup widget is required",E0020:"Template engine '{0}' is not supported",E0021:"Unknown theme is set: {0}",E0022:"LINK[rel=DevExpress-theme] tags must go before DevExpress included scripts",E0023:"Template name is not specified",E0024:"DevExtreme bundle already included",E0025:"Unexpected argument type",E0100:"Unknown validation type is detected",E0101:"Misconfigured range validation rule is detected",E0102:"Misconfigured comparison validation rule is detected",E0103:"validationCallback of an asynchronous rule should return a jQuery or a native promise",E0110:"Unknown validation group is detected",E0120:"Adapter for a DevExpressValidator component cannot be configured",E0121:"The 'customItem' parameter of the 'onCustomItemCreating' function is empty or contains invalid data. Assign a custom object or a Promise that is resolved after the item is created.",W0000:"'{0}' is deprecated in {1}. {2}",W0001:"{0} - '{1}' option is deprecated in {2}. {3}",W0002:"{0} - '{1}' method is deprecated in {2}. {3}",W0003:"{0} - '{1}' property is deprecated in {2}. {3}",W0004:"Timeout for theme loading is over: {0}",W0005:"'{0}' event is deprecated in {1}. {2}",W0006:"Invalid recurrence rule: '{0}'",W0007:"'{0}' Globalize culture is not defined",W0008:"Invalid view name: '{0}'",W0009:"Invalid time zone name: '{0}'",W0010:"{0} is deprecated in {1}. {2}",W0011:"Number parsing is invoked while the parser is not defined",W0012:"Date parsing is invoked while the parser is not defined",W0013:"'{0}' file is deprecated in {1}. {2}",W0014:"{0} - '{1}' type is deprecated in {2}. {3}",W0015:"Instead of returning a value from the '{0}' function, write it into the '{1}' field of the function's parameter.",W0016:'The "{0}" option does not accept the "{1}" value since v{2}. {3}.',W0017:'Setting the "{0}" property with a function is deprecated since v21.2',W0018:'Setting the "position" property with a function is deprecated since v21.2'});t.default=o,e.exports=t.default,e.exports.default=t.default},80566:function(e,t,n){t.EventsStrategy=void 0;var i,o=(i=n(44504))&&i.__esModule?i:{default:i},a=n(95479),r=n(35922);var s=function(){function e(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};this._events={},this._owner=e,this._options=t}e.create=function(t,n){return n?(0,r.isFunction)(n)?n(t):n:new e(t)};var t=e.prototype;return t.hasEvent=function(e){var t=this._events[e];return!!t&&t.has()},t.fireEvent=function(e,t){var n=this._events[e];return n&&n.fireWith(this._owner,t),this._owner},t.on=function(e,t){var n=this;if((0,r.isPlainObject)(e))(0,a.each)(e,(function(e,t){n.on(e,t)}));else{var i=this._events[e];i||(i=(0,o.default)({syncStrategy:this._options.syncStrategy}),this._events[e]=i),(i.originalAdd||i.add).call(i,t)}},t.off=function(e,t){var n=this._events[e];n&&((0,r.isFunction)(t)?n.remove(t):n.empty())},t.dispose=function(){(0,a.each)(this._events,(function(e,t){t.empty()}))},e}();t.EventsStrategy=s},73176:function(e,t,n){var i;t.default=void 0;var o=((i=n(38377))&&i.__esModule?i:{default:i}).default.inherit({ctor:function(e){e&&(e=String(e)),this._value=this._normalize(e||this._generate())},_normalize:function(e){for(e=e.replace(/[^a-f0-9]/gi,"").toLowerCase();e.length<32;)e+="0";return[e.substr(0,8),e.substr(8,4),e.substr(12,4),e.substr(16,4),e.substr(20,12)].join("-")},_generate:function(){for(var e="",t=0;t<32;t++)e+=Math.round(15*Math.random()).toString(16);return e},toString:function(){return this._value},valueOf:function(){return this._value},toJSON:function(){return this._value}});t.default=o,e.exports=t.default,e.exports.default=t.default},83448:function(e,t,n){t.default=void 0;var i,o=n(58201),a=(i=n(20476))&&i.__esModule?i:{default:i};var r=(0,o.getWindow)(),s={getXhr:function(){return new r.XMLHttpRequest}},l=(0,a.default)(s);t.default=l,e.exports=t.default,e.exports.default=t.default},15334:function(e,t,n){t.default=void 0;var i=n(55285),o=n(44105),a=n(87456),r=u(n(73349)),s=n(97906),l=u(n(20476));function u(e){return e&&e.__esModule?e:{default:e}}var d=function(e){var t=e.parentNode;t&&((0,s.cleanDataRecursive)(e),t.$V=e.$V,(0,i.render)(null,t),t.appendChild(e),e.innerHTML="",delete t.$V),delete e.$V},c=(0,l.default)({createElement:function(e,t){return(0,a.createElement)(e,t)},remove:d,onAfterRender:function(){o.InfernoEffectHost.callEffects()},onPreRender:function(){o.InfernoEffectHost.lock()},render:function(e,t,n,s){if(s)(0,i.render)((0,a.createElement)(e,t),n);else{var l=n.parentNode,u=null==n?void 0:n.nextSibling,c=r.default.createElement("div");c.appendChild(n);var h=r.default.createDocumentFragment().appendChild(c);!!n.$V&&d(n),(0,o.hydrate)((0,a.createElement)(e,t),h),n.$V=h.$V,l&&l.insertBefore(n,u)}}});t.default=c,e.exports=t.default,e.exports.default=t.default},83358:function(e,t,n){t.default=void 0;var i,o=n(95479),a=(i=n(44504))&&i.__esModule?i:{default:i};var r=function(){function e(){this.memory=[],this.callbacks=(0,a.default)()}var t=e.prototype;return t.add=function(e){(0,o.each)(this.memory,(function(t,n){return e.apply(e,n)})),this.callbacks.add(e)},t.remove=function(e){this.callbacks.remove(e)},t.fire=function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];this.memory.push(t),this.callbacks.fire.apply(this.callbacks,t)},e}();t.default=r,e.exports=t.default,e.exports.default=t.default},95683:function(e,t,n){t.Options=void 0;var i=n(35922),o=n(20576),a=n(9030),r=n(47617),s=n(45434),l=n(13306);function u(){return(u=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(e[i]=n[i])}return e}).apply(this,arguments)}function d(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}var c=function(){function e(e,t,n,i){var o=this;this._deprecatedCallback,this._startChangeCallback,this._endChangeCallback,this._default=t,this._deprecated=i,this._deprecatedNames=[],this._initDeprecatedNames(),this._optionManager=new a.OptionManager(e,n),this._optionManager.onRelevantNamesPrepared((function(e,t,n,i){return o._setRelevantNames(e,t,n,i)})),this._cachedOptions={},this._rules=[]}var t,n,c,h=e.prototype;return h._initDeprecatedNames=function(){for(var e in this._deprecated)this._deprecatedNames.push(e)},h._getByRules=function(e){return e=Array.isArray(e)?this._rules.concat(e):this._rules,(0,s.convertRulesToOptions)(e)},h._notifyDeprecated=function(e){var t=this._deprecated[e];t&&this._deprecatedCallback(e,t)},h._setRelevantNames=function(e,t,n,i){if(t){var o=this._normalizeName(t,i);o&&o!==t&&(this._setField(e,o,n),this._clearField(e,t))}},h._setField=function(e,t,n){var i="",o=null;do{i=i?".".concat(i):"",i=(0,s.getFieldName)(t)+i,o=(t=(0,s.getParentName)(t))?this._optionManager.get(e,t,!1):e}while(!o);o[i]=n},h._clearField=function(e,t){delete e[t];var n=(0,s.getParentName)(t),i=n?this._optionManager.get(e,n,!1):e;i&&delete i[(0,s.getFieldName)(t)]},h._normalizeName=function(e,t){if(this._deprecatedNames.length&&e)for(var n=0;n<this._deprecatedNames.length;n++)if(this._deprecatedNames[n]===e){var i=this._deprecated[e];if(i)return!t&&this._notifyDeprecated(e),i.alias||e}return e},h.addRules=function(e){this._rules=e.concat(this._rules)},h.applyRules=function(e){var t=this._getByRules(e);this.silent(t)},h.dispose=function(){this._deprecatedCallback=o.noop,this._startChangeCallback=o.noop,this._endChangeCallback=o.noop,this._optionManager.dispose()},h.onChanging=function(e){this._optionManager.onChanging(e)},h.onChanged=function(e){this._optionManager.onChanged(e)},h.onDeprecated=function(e){this._deprecatedCallback=e},h.onStartChange=function(e){this._startChangeCallback=e},h.onEndChange=function(e){this._endChangeCallback=e},h.isInitial=function(e){var t=this.silent(e),n=this.initial(e);return(0,i.isFunction)(t)&&(0,i.isFunction)(n)?t.toString()===n.toString():(0,o.equalByValue)(t,n)},h.initial=function(e){return(0,s.getNestedOptionValue)(this._initial,e)},h.option=function(e,t){var n=arguments.length<2&&"object"!==(0,i.type)(e);if(n)return this._optionManager.get(void 0,this._normalizeName(e));this._startChangeCallback();try{this._optionManager.set(e,t)}finally{this._endChangeCallback()}},h.silent=function(e,t){var n=arguments.length<2&&"object"!==(0,i.type)(e);if(n)return this._optionManager.get(void 0,e,void 0,!0);this._optionManager.set(e,t,void 0,!0)},h.reset=function(e){var t=this;if(e){var n=(0,r.getPathParts)(e).reduce((function(e,n){return e?e[n]:t.initial(n)}),null),o=(0,i.isObject)(n)?u({},n):n;this._optionManager.set(e,o,!1)}},h.getAliasesByName=function(e){var t=this;return Object.keys(this._deprecated).filter((function(n){return e===t._deprecated[n].alias}))},h.isDeprecated=function(e){return Object.prototype.hasOwnProperty.call(this._deprecated,e)},h.cache=function(e,t){var n=arguments.length<2;if(n)return this._cachedOptions[e];this._cachedOptions[e]=(0,l.extend)(this._cachedOptions[e],t)},t=e,(n=[{key:"_initial",get:function(){if(!this._initialOptions){var e=this._getByRules(this.silent("defaultOptionsRules"));this._initialOptions=this._default,this._optionManager._setByReference(this._initialOptions,e)}return this._initialOptions},set:function(e){this._initialOptions=e}}])&&d(t.prototype,n),c&&d(t,c),Object.defineProperty(t,"prototype",{writable:!1}),e}();t.Options=c},9030:function(e,t,n){t.OptionManager=void 0;var i=n(47617),o=n(20576),a=n(49036),r=n(13306),s=n(35922),l=n(45434),u={},d={},c=function(){function e(e,t){this._options=e,this._optionsByReference=t,this._changingCallback,this._changedCallback,this._namePreparedCallbacks}var t=e.prototype;return t._setByReference=function(e,t){for(var n in(0,r.extend)(!0,e,t),this._optionsByReference)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])},t._setPreparedValue=function(e,t,n,o){var r=this.get(this._options,e,!1);if(!(0,a.equals)(r,t)){var l=(0,i.getPathParts)(e);!o&&this._changingCallback(e,r,t),d[e]=d[e]||(0,i.compileSetter)(e),d[e](this._options,t,{functionsAsIs:!0,merge:(0,s.isDefined)(n)?n:!this._optionsByReference[e],unwrapObservables:l.length>1&&!!this._optionsByReference[l[0]]}),!o&&this._changedCallback(e,t,r)}},t._prepareRelevantNames=function(e,t,n,i){if((0,s.isPlainObject)(n))for(var o in n)this._prepareRelevantNames(e,"".concat(t,".").concat(o),n[o]);this._namePreparedCallbacks(e,t,n,i)},t.get=function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this._options,t=arguments.length>1?arguments[1]:void 0,n=arguments.length>2?arguments[2]:void 0;return u[t]=u[t]||(0,i.compileGetter)(t),u[t](e,{functionsAsIs:!0,unwrapObservables:n})},t.set=function(e,t,n,i){for(var o in e=(0,l.normalizeOptions)(e,t))this._prepareRelevantNames(e,o,e[o],i);for(var a in e)this._setPreparedValue(a,e[a],n,i)},t.onRelevantNamesPrepared=function(e){this._namePreparedCallbacks=e},t.onChanging=function(e){this._changingCallback=e},t.onChanged=function(e){this._changedCallback=e},t.dispose=function(){this._changingCallback=o.noop,this._changedCallback=o.noop},e}();t.OptionManager=c},45434:function(e,t,n){t.normalizeOptions=t.getParentName=t.getNestedOptionValue=t.getFieldName=t.deviceMatch=t.createDefaultOptionRules=t.convertRulesToOptions=void 0;var i,o=(i=n(20530))&&i.__esModule?i:{default:i},a=n(35922),r=n(20576),s=n(13306),l=n(47617);var u={};t.convertRulesToOptions=function(e){var t=o.default.current();return e.reduce((function(e,n){var i=n.device,o=n.options,r=i||{};return((0,a.isFunction)(r)?r(t):d(t,r))&&(0,s.extend)(!0,e,o),e}),{})};t.normalizeOptions=function(e,t){return"string"!=typeof e?e:function(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}({},e,t)};var d=function(e,t){return(0,a.isEmptyObject)(t)||(0,r.findBestMatches)(e,[t]).length>0};t.deviceMatch=d;t.getFieldName=function(e){return e.substr(e.lastIndexOf(".")+1)};t.getParentName=function(e){return e.substr(0,e.lastIndexOf("."))};t.getNestedOptionValue=function(e,t){return u[t]=u[t]||(0,l.compileGetter)(t),u[t](e,{functionsAsIs:!0})};t.createDefaultOptionRules=function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[];return e}},90889:function(e,t,n){t.PostponedOperations=void 0;var i=n(62754),o=n(35922);function a(e){return function(e){if(Array.isArray(e))return r(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return r(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return r(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function r(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}var s=function(){function e(){this._postponedOperations={}}var t=e.prototype;return t.add=function(e,t,n){if(e in this._postponedOperations)n&&this._postponedOperations[e].promises.push(n);else{var o=new i.Deferred;this._postponedOperations[e]={fn:t,completePromise:o,promises:n?[n]:[]}}return this._postponedOperations[e].completePromise.promise()},t.callPostponedOperations=function(){for(var e in this._postponedOperations){var t=this._postponedOperations[e];(0,o.isDefined)(t)&&(t.promises&&t.promises.length?i.when.apply(void 0,a(t.promises)).done(t.fn).then(t.completePromise.resolve):t.fn().done(t.completePromise.resolve))}this._postponedOperations={}},e}();t.PostponedOperations=s},68374:function(e,t,n){var i;t.default=void 0;var o=((i=n(82981))&&i.__esModule?i:{default:i}).default.get();t.default=o,e.exports=t.default,e.exports.default=t.default},82981:function(e,t,n){t.default=void 0;var i,o=n(97906),a=(i=n(73349))&&i.__esModule?i:{default:i},r=n(58201),s=n(35922),l=n(80968),u=n(58664),d=n(61371);var c,h=(0,r.getWindow)(),p=function(e,t){return e?"string"==typeof e?"body"===e?(this[0]=t?t.body:a.default.getBody(),this.length=1,this):(t=t||a.default.getDocument(),"<"===e[0]?(this[0]=a.default.createElement(e.slice(1,-1),t),this.length=1,this):([].push.apply(this,a.default.querySelectorAll(t,e)),this)):a.default.isNode(e)||(0,s.isWindow)(e)?(this[0]=e,this.length=1,this):Array.isArray(e)?([].push.apply(this,e),this):c(e.toArray?e.toArray():[e]):(this.length=0,this)};(c=function(e,t){return new p(e,t)}).fn={dxRenderer:!0},p.prototype=c.fn;var f=function(e,t){for(var n=0;n<this.length;n++){var i=c(this[n]);i[e].apply(i,t)}return this},g=function(e,t,n){null!=n?a.default.setAttribute(e,t,n):a.default.removeAttribute(e,t)};p.prototype.show=function(){return this.toggle(!0)},p.prototype.hide=function(){return this.toggle(!1)},p.prototype.toggle=function(e){return this[0]&&this.toggleClass("dx-state-invisible",!e),this},p.prototype.attr=function(e,t){if(this.length>1&&arguments.length>1)return f.call(this,"attr",arguments);if(!this[0])return(0,s.isObject)(e)||void 0!==t?this:void 0;if(!this[0].getAttribute)return this.prop(e,t);if("string"==typeof e&&1===arguments.length){var n=this[0].getAttribute(e);return null==n?void 0:n}if((0,s.isPlainObject)(e))for(var i in e)this.attr(i,e[i]);else g(this[0],e,t);return this},p.prototype.removeAttr=function(e){return this[0]&&a.default.removeAttribute(this[0],e),this},p.prototype.prop=function(e,t){if(!this[0])return this;if("string"==typeof e&&1===arguments.length)return this[0][e];if((0,s.isPlainObject)(e))for(var n in e)this.prop(n,e[n]);else a.default.setProperty(this[0],e,t);return this},p.prototype.addClass=function(e){return this.toggleClass(e,!0)},p.prototype.removeClass=function(e){return this.toggleClass(e,!1)},p.prototype.hasClass=function(e){if(!this[0]||void 0===this[0].className)return!1;for(var t=e.split(" "),n=0;n<t.length;n++){if(this[0].classList){if(this[0].classList.contains(t[n]))return!0}else if((((0,s.isString)(this[0].className)?this[0].className:a.default.getAttribute(this[0],"class"))||"").split(" ").indexOf(t[n])>=0)return!0}return!1},p.prototype.toggleClass=function(e,t){if(this.length>1)return f.call(this,"toggleClass",arguments);if(!this[0]||!e)return this;t=void 0===t?!this.hasClass(e):t;for(var n=e.split(" "),i=0;i<n.length;i++)a.default.setClass(this[0],n[i],t);return this},p.prototype.html=function(e){return arguments.length?(this.empty(),"string"==typeof e&&!(0,d.isTablePart)(e)||"number"==typeof e?(this[0].innerHTML=e,this):this.append((0,d.parseHTML)(e))):this[0].innerHTML};var m=function(e,t){if(this[0]&&e){"string"==typeof e?e=(0,d.parseHTML)(e):e.nodeType?e=[e]:(0,s.isNumeric)(e)&&(e=[a.default.createTextNode(e)]);for(var n=0;n<e.length;n++){var i=e[n],o=this[0];"TABLE"===o.tagName&&"TR"===i.tagName&&o.tBodies&&o.tBodies.length&&(o=o.tBodies[0]),a.default.insertElement(o,i.nodeType?i:i[0],t)}}},_=function(e,t){if(this[0]&&this[0].style&&!(null===t||"number"==typeof t&&isNaN(t))){e=(0,l.styleProp)(e);for(var n=0;n<this.length;n++)this[n].style[e]=(0,l.normalizeStyleProp)(e,t)}};p.prototype.css=function(e,t){if((0,s.isString)(e)){if(2!==arguments.length){if(!this[0])return;e=(0,l.styleProp)(e);var n=h.getComputedStyle(this[0])[e]||this[0].style[e];return(0,s.isNumeric)(n)?n.toString():n}_.call(this,e,t)}else if((0,s.isPlainObject)(e))for(var i in e)_.call(this,i,e[i]);return this},p.prototype.prepend=function(e){if(arguments.length>1){for(var t=0;t<arguments.length;t++)this.prepend(arguments[t]);return this}return m.apply(this,[e,this[0].firstChild]),this},p.prototype.append=function(e){if(arguments.length>1){for(var t=0;t<arguments.length;t++)this.append(arguments[t]);return this}return m.apply(this,[e]),this},p.prototype.prependTo=function(e){if(this.length>1){for(var t=this.length-1;t>=0;t--)c(this[t]).prependTo(e);return this}return(e=c(e))[0]&&a.default.insertElement(e[0],this[0],e[0].firstChild),this},p.prototype.appendTo=function(e){return this.length>1?f.call(this,"appendTo",arguments):(a.default.insertElement(c(e)[0],this[0]),this)},p.prototype.insertBefore=function(e){return e&&e[0]&&a.default.insertElement(e[0].parentNode,this[0],e[0]),this},p.prototype.insertAfter=function(e){return e&&e[0]&&a.default.insertElement(e[0].parentNode,this[0],e[0].nextSibling),this},p.prototype.before=function(e){return this[0]&&a.default.insertElement(this[0].parentNode,e[0],this[0]),this},p.prototype.after=function(e){return this[0]&&a.default.insertElement(this[0].parentNode,e[0],this[0].nextSibling),this},p.prototype.wrap=function(e){if(this[0]){var t=c(e);t.insertBefore(this),t.append(this)}return this},p.prototype.wrapInner=function(e){var t=this.contents();return t.length?t.wrap(e):this.append(e),this},p.prototype.replaceWith=function(e){if(e&&e[0])return e.is(this)?this:(e.insertBefore(this),this.remove(),e)},p.prototype.remove=function(){return this.length>1?f.call(this,"remove",arguments):((0,o.cleanDataRecursive)(this[0],!0),a.default.removeElement(this[0]),this)},p.prototype.detach=function(){return this.length>1?f.call(this,"detach",arguments):(a.default.removeElement(this[0]),this)},p.prototype.empty=function(){return this.length>1?f.call(this,"empty",arguments):((0,o.cleanDataRecursive)(this[0]),a.default.setText(this[0],""),this)},p.prototype.clone=function(){for(var e=[],t=0;t<this.length;t++)e.push(this[t].cloneNode(!0));return c(e)},p.prototype.text=function(e){if(!arguments.length){for(var t="",n=0;n<this.length;n++)t+=this[n]&&this[n].textContent||"";return t}var i=(0,s.isFunction)(e)?e():e;return(0,o.cleanDataRecursive)(this[0],!1),a.default.setText(this[0],(0,s.isDefined)(i)?i:""),this},p.prototype.val=function(e){return 1===arguments.length?this.prop("value",(0,s.isDefined)(e)?e:""):this.prop("value")},p.prototype.contents=function(){if(!this[0])return c();var e=[];return e.push.apply(e,this[0].childNodes),c(e)},p.prototype.find=function(e){var t=c();if(!e)return t;var n,i=[];if("string"==typeof e)for(e=e.trim(),n=0;n<this.length;n++){var o=this[n];if(a.default.isElementNode(o)){var r=o.getAttribute("id"),s=r||"dx-query-children";r||g(o,"id",s);var l=(s="[id='"+s+"'] ")+e.replace(/([^\\])(,)/g,"$1, "+s);i.push.apply(i,a.default.querySelectorAll(o,l)),g(o,"id",r)}else a.default.isDocument(o)&&i.push.apply(i,a.default.querySelectorAll(o,e))}else for(n=0;n<this.length;n++)e=a.default.isNode(e)?e:e[0],this[n]!==e&&this[n].contains(e)&&i.push(e);return t.add(i)};var v=function(e,t){var n;return!(t=null!==(n=t.host)&&void 0!==n?n:t).nodeType||!!(t.offsetWidth||t.offsetHeight||t.getClientRects().length)};p.prototype.filter=function(e){if(!e)return c();if(":visible"===e)return this.filter(v);if(":hidden"===e)return this.filter((function(e,t){return!v(0,t)}));for(var t=[],n=0;n<this.length;n++){var i=this[n];if(a.default.isElementNode(i)&&"string"===(0,s.type)(e))a.default.elementMatches(i,e)&&t.push(i);else if(a.default.isNode(e)||(0,s.isWindow)(e))e===i&&t.push(i);else if((0,s.isFunction)(e))e.call(i,n,i)&&t.push(i);else for(var o=0;o<e.length;o++)e[o]===i&&t.push(i)}return c(t)},p.prototype.not=function(e){for(var t=[],n=this.filter(e).toArray(),i=0;i<this.length;i++)-1===n.indexOf(this[i])&&t.push(this[i]);return c(t)},p.prototype.is=function(e){return!!this.filter(e).length},p.prototype.children=function(e){for(var t=[],n=0;n<this.length;n++)for(var i=this[n]?this[n].childNodes:[],o=0;o<i.length;o++)a.default.isElementNode(i[o])&&t.push(i[o]);return t=c(t),e?t.filter(e):t},p.prototype.siblings=function(){var e=this[0];if(!e||!e.parentNode)return c();for(var t=[],n=e.parentNode.childNodes||[],i=0;i<n.length;i++){var o=n[i];a.default.isElementNode(o)&&o!==e&&t.push(o)}return c(t)},p.prototype.each=function(e){for(var t=0;t<this.length&&!1!==e.call(this[t],t,this[t]);t++);},p.prototype.index=function(e){return e?(e=c(e),this.toArray().indexOf(e[0])):this.parent().children().index(this)},p.prototype.get=function(e){return this[e<0?this.length+e:e]},p.prototype.eq=function(e){return e=e<0?this.length+e:e,c(this[e])},p.prototype.first=function(){return this.eq(0)},p.prototype.last=function(){return this.eq(-1)},p.prototype.parent=function(e){if(!this[0])return c();var t=c(this[0].parentNode);return!e||t.is(e)?t:c()},p.prototype.parents=function(e){for(var t=[],n=this.parent();n&&n[0]&&!a.default.isDocument(n[0]);)a.default.isElementNode(n[0])&&(e&&!n.is(e)||t.push(n.get(0))),n=n.parent();return c(t)},p.prototype.closest=function(e){if(this.is(e))return this;for(var t=this.parent();t&&t.length;){if(t.is(e))return t;t=t.parent()}return c()},p.prototype.next=function(e){if(!this[0])return c();var t=c(this[0].nextSibling);if(!arguments.length)return t;for(;t&&t.length;){if(t.is(e))return t;t=t.next()}return c()},p.prototype.prev=function(){return this[0]?c(this[0].previousSibling):c()},p.prototype.add=function(e){for(var t=c(e),n=this.toArray(),i=0;i<t.length;i++){var o=t[i];-1===n.indexOf(o)&&n.push(o)}return c(n)};var y=[];p.prototype.splice=function(){return c(y.splice.apply(this,arguments))},p.prototype.slice=function(){return c(y.slice.apply(this,arguments))},p.prototype.toArray=function(){return y.slice.call(this)},p.prototype.offset=function(){if(this[0])return(0,u.getOffset)(this[0])},p.prototype.offsetParent=function(){if(!this[0])return c();for(var e=c(this[0].offsetParent);e[0]&&"static"===e.css("position");)e=c(e[0].offsetParent);return e=e[0]?e:c(a.default.getDocumentElement())},p.prototype.position=function(){if(this[0]){var e,t=parseFloat(this.css("marginTop")),n=parseFloat(this.css("marginLeft"));if("fixed"===this.css("position"))return{top:(e=this[0].getBoundingClientRect()).top-t,left:e.left-n};e=this.offset();var i=this.offsetParent(),o={top:0,left:0};return"HTML"!==i[0].nodeName&&(o=i.offset()),o={top:o.top+parseFloat(i.css("borderTopWidth")),left:o.left+parseFloat(i.css("borderLeftWidth"))},{top:e.top-o.top-t,left:e.left-o.left-n}}},[{name:"scrollLeft",offsetProp:"pageXOffset",scrollWindow:function(e,t){e.scrollTo(t,e.pageYOffset)}},{name:"scrollTop",offsetProp:"pageYOffset",scrollWindow:function(e,t){e.scrollTo(e.pageXOffset,t)}}].forEach((function(e){var t=e.name;p.prototype[t]=function(n){if(this[0]){var i=(0,u.getWindowByElement)(this[0]);return void 0===n?i?i[e.offsetProp]:this[0][t]:(i?e.scrollWindow(i,n):this[0][t]=n,this)}}})),p.prototype.data=function(e,t){if(this[0])return arguments.length<2?o.data.call(c,this[0],e):(o.data.call(c,this[0],e,t),this)},p.prototype.removeData=function(e){return this[0]&&(0,o.removeData)(this[0],e),this};var b=function(){return c.apply(this,arguments)};Object.defineProperty(b,"fn",{enumerable:!0,configurable:!0,get:function(){return c.fn},set:function(e){c.fn=e}});var x={set:function(e){c=e},get:function(){return b}};t.default=x,e.exports=t.default,e.exports.default=t.default},91784:function(e,t,n){t.default=void 0;var i=n(20576),o=n(58201),a=(0,o.getWindow)(),r={observe:i.noop,unobserve:i.noop,disconnect:i.noop},s=new(function(){function e(){var e=this;if(!(0,o.hasWindow)()||!a.ResizeObserver)return r;this._callbacksMap=new Map,this._observer=new a.ResizeObserver((function(t){t.forEach((function(t){var n;null===(n=e._callbacksMap.get(t.target))||void 0===n||n(t)}))}))}var t=e.prototype;return t.observe=function(e,t){this._callbacksMap.set(e,t),this._observer.observe(e)},t.unobserve=function(e){this._callbacksMap.delete(e),this._observer.unobserve(e)},t.disconnect=function(){this._callbacksMap.clear(),this._observer.disconnect()},e}());t.default=s,e.exports=t.default,e.exports.default=t.default},14192:function(e,t,n){t.TemplateManager=void 0;var i,o=(i=n(68374))&&i.__esModule?i:{default:i},a=n(35922),r=n(20576),s=n(13306),l=n(68494),u=n(10688),d=n(69697);function c(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}var h=new l.FunctionTemplate((function(e){var t=e.model,n=e.parent,i=t.widget;if(!i)return(0,o.default)();var a=(0,o.default)("<div>"),r=t.options||{};return n?n._createComponent(a,i,r):a[i](r),a})),p=function(){function e(e,t){this._tempTemplates=[],this._defaultTemplates={},this._anonymousTemplateName=t||"template",this._createElement=e||d.defaultCreateElement,this._createTemplateIfNeeded=this._createTemplateIfNeeded.bind(this)}e.createDefaultOptions=function(){return{integrationOptions:{watchMethod:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};return n.skipImmediate||t(e()),r.noop},templates:{"dx-polymorph-widget":h},useDeferUpdateForTemplates:!0}}};var t,n,i,p=e.prototype;return p.addDefaultTemplates=function(e){this._defaultTemplates=(0,s.extend)({},this._defaultTemplates,e)},p.dispose=function(){this._tempTemplates.forEach((function(e){e.template.dispose&&e.template.dispose()})),this._tempTemplates=[]},p.extractTemplates=function(e){return{templates:this._extractTemplates(e),anonymousTemplateMeta:this._extractAnonymousTemplate(e)}},p._extractTemplates=function(e){var t=this,n=(0,d.findTemplates)(e,"dxTemplate"),i=(0,d.suitableTemplatesByName)(n);return n.forEach((function(e){var t=e.element,n=e.options.name;t===i[n]?(0,o.default)(t).addClass("dx-template-wrapper").detach():(0,o.default)(t).remove()})),Object.keys(i).map((function(e){return{name:e,template:t._createTemplate(i[e])}}))},p._extractAnonymousTemplate=function(e){var t=e.contents().detach();return t.filter((function(e,t){var n=3===t.nodeType,i=(0,o.default)(t).text().trim().length<1;return!(n&&i)})).length>0?{template:this._createTemplate(t),name:this._anonymousTemplateName}:{}},p._createTemplateIfNeeded=function(e){var t=this._tempTemplates.filter((function(t){return t.source===(0,d.templateKey)(e)}))[0];if(t)return t.template;var n=this._createTemplate(e);return this._tempTemplates.push({template:n,source:(0,d.templateKey)(e)}),n},p._createTemplate=function(e){return this._createElement((0,d.validateTemplateSource)(e))},p.getTemplate=function(e,t,n,i){var r=this,s=n.isAsyncTemplate,c=n.skipTemplates;return(0,a.isFunction)(e)?new l.FunctionTemplate((function(n){var h=e.apply(i,(0,d.getNormalizedTemplateArgs)(n));if(!(0,a.isDefined)(h))return new u.EmptyTemplate;var p=!1,f=(0,d.acquireTemplate)(h,(function(e){return e.nodeType||(0,a.isRenderer)(e)&&!(0,o.default)(e).is("script")?new l.FunctionTemplate((function(){return e})):(p=!0,r._createTemplate(e))}),t,s,c,r._defaultTemplates),g=f.render(n);return p&&f.dispose&&f.dispose(),g})):(0,d.acquireTemplate)(e,this._createTemplateIfNeeded,t,s,c,this._defaultTemplates)},t=e,(n=[{key:"anonymousTemplateName",get:function(){return this._anonymousTemplateName}}])&&c(t.prototype,n),i&&c(t,i),Object.defineProperty(t,"prototype",{writable:!1}),e}();t.TemplateManager=p},93280:function(e,t,n){t.BindableTemplate=void 0;var i=l(n(68374)),o=n(81033),a=l(n(55994)),r=n(29007),s=n(35922);function l(e){return e&&e.__esModule?e:{default:e}}function u(e,t){return(u=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e})(e,t)}var d=function(e,t,n,i,o){var a,r=function(e,t,n){return t((function(){return e}),n)}(e,t,(function(e){a&&a(),(0,s.isPrimitive)(e)?o(e):a=function(e,t,n,i,o){var a={},r=n.slice(),s=n.map((function(n){var s=i[n];return t(s?function(){return s(e)}:function(){return e[n]},(function(e){if(a[n]=e,r.length){var t=r.indexOf(n);t>=0&&r.splice(t,1)}r.length||o(a)}))}));return function(){s.forEach((function(e){return e()}))}}(e,t,n,i,o)}));return function(){a&&a(),r&&r()}},c=function(e){var t,n;function o(t,n,i,o){var a;return(a=e.call(this)||this)._render=t,a._fields=n,a._fieldsMap=o||{},a._watchMethod=i,a}return n=e,(t=o).prototype=Object.create(n.prototype),t.prototype.constructor=t,u(t,n),o.prototype._renderCore=function(e){var t=this,n=(0,i.default)(e.container),o=d(e.model,this._watchMethod,this._fields,this._fieldsMap,(function(i){n.empty(),t._render(n,i,e.model)}));return a.default.on(n,r.removeEvent,o),n.contents()},o}(o.TemplateBase);t.BindableTemplate=c},91627:function(e,t,n){function i(e,t){return(i=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e})(e,t)}t.ChildDefaultTemplate=void 0;var o=function(e){var t,n;function o(t){var n;return(n=e.call(this)||this).name=t,n}return n=e,(t=o).prototype=Object.create(n.prototype),t.prototype.constructor=t,i(t,n),o}(n(81033).TemplateBase);t.ChildDefaultTemplate=o},10688:function(e,t,n){t.EmptyTemplate=void 0;var i,o=(i=n(68374))&&i.__esModule?i:{default:i};function a(e,t){return(a=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e})(e,t)}var r=function(e){var t,n;function i(){return e.apply(this,arguments)||this}return n=e,(t=i).prototype=Object.create(n.prototype),t.prototype.constructor=t,a(t,n),i.prototype._renderCore=function(){return(0,o.default)()},i}(n(81033).TemplateBase);t.EmptyTemplate=r},68494:function(e,t,n){t.FunctionTemplate=void 0;var i=n(81033),o=n(3532);function a(e,t){return(a=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e})(e,t)}var r=function(e){var t,n;function i(t){var n;return(n=e.call(this)||this)._render=t,n}return n=e,(t=i).prototype=Object.create(n.prototype),t.prototype.constructor=t,a(t,n),i.prototype._renderCore=function(e){return(0,o.normalizeTemplateElement)(this._render(e))},i}(i.TemplateBase);t.FunctionTemplate=r},9545:function(e,t,n){t.Template=void 0;var i,o=(i=n(68374))&&i.__esModule?i:{default:i},a=n(81033),r=n(3532),s=n(72987);function l(e,t){return(l=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e})(e,t)}n(32468),(0,s.registerTemplateEngine)("default",{compile:function(e){return(0,r.normalizeTemplateElement)(e)},render:function(e,t,n){return e.clone()}}),(0,s.setTemplateEngine)("default");var u=function(e){var t,n;function i(t){var n;return(n=e.call(this)||this)._element=t,n}n=e,(t=i).prototype=Object.create(n.prototype),t.prototype.constructor=t,l(t,n);var a=i.prototype;return a._renderCore=function(e){var t=e.transclude;return t||this._compiledTemplate||(this._compiledTemplate=(0,s.getCurrentTemplateEngine)().compile(this._element)),(0,o.default)("<div>").append(t?this._element:(0,s.getCurrentTemplateEngine)().render(this._compiledTemplate,e.model,e.index)).contents()},a.source=function(){return(0,o.default)(this._element).clone()},i}(a.TemplateBase);t.Template=u},81033:function(e,t,n){t.renderedCallbacks=t.TemplateBase=void 0;var i=u(n(68374)),o=u(n(73349)),a=u(n(44504)),r=n(3532),s=n(80506),l=u(n(17381));function u(e){return e&&e.__esModule?e:{default:e}}var d=(0,a.default)({syncStrategy:!0});t.renderedCallbacks=d;var c=function(){function e(){}var t=e.prototype;return t.render=function(e){var t,n=(e=e||{}).onRendered;return delete e.onRendered,t=e.renovated&&e.transclude&&this._element?(0,i.default)("<div>").append(this._element).contents():this._renderCore(e),this._ensureResultInContainer(t,e.container),d.fire(t,e.container),n&&n(),t},t._ensureResultInContainer=function(e,t){if(t){var n=(0,i.default)(t),a=(0,r.contains)(n.get(0),e.get(0));if(n.append(e),!a)o.default.getBody().contains(n.get(0))&&(0,s.triggerShownEvent)(e)}},t._renderCore=function(){throw l.default.Error("E0001")},e}();t.TemplateBase=c},72987:function(e,t,n){t.getCurrentTemplateEngine=function(){return r},t.registerTemplateEngine=function(e,t){s[e]=t},t.setTemplateEngine=function(e){if((0,o.isString)(e)){if(!(r=s[e]))throw a.default.Error("E0020",e)}else r=e};var i,o=n(35922),a=(i=n(17381))&&i.__esModule?i:{default:i};var r,s={}},32468:function(e,t,n){var i=n(3532),o=n(72987);(0,o.registerTemplateEngine)("jquery-tmpl",{compile:function(e){return(0,i.extractTemplateMarkup)(e)},render:function(e,t){return jQuery.tmpl(e,t)}}),(0,o.registerTemplateEngine)("jsrender",{compile:function(e){return(jQuery||jsrender).templates((0,i.extractTemplateMarkup)(e))},render:function(e,t){return e.render(t)}}),(0,o.registerTemplateEngine)("mustache",{compile:function(e){return(0,i.extractTemplateMarkup)(e)},render:function(e,t){return Mustache.render(e,t)}}),(0,o.registerTemplateEngine)("hogan",{compile:function(e){return Hogan.compile((0,i.extractTemplateMarkup)(e))},render:function(e,t){return e.render(t)}}),(0,o.registerTemplateEngine)("underscore",{compile:function(e){return _.template((0,i.extractTemplateMarkup)(e))},render:function(e,t){return e(t)}}),(0,o.registerTemplateEngine)("handlebars",{compile:function(e){return Handlebars.compile((0,i.extractTemplateMarkup)(e))},render:function(e,t){return e(t)}}),(0,o.registerTemplateEngine)("doT",{compile:function(e){return doT.template((0,i.extractTemplateMarkup)(e))},render:function(e,t){return e(t)}})},37208:function(e,t,n){t.default=void 0;var i=n(62754),o=d(n(73349)),a=d(n(83448)),r=n(58201),s=n(13306),l=n(35922),u=d(n(20476));function d(e){return e&&e.__esModule?e:{default:e}}var c=(0,r.getWindow)(),h=function(e){var t=o.default.createElement("script");for(var n in e)t[n]=e[n];return t},p=function(e){e.parentNode.removeChild(e)},f=function(e){return o.default.getHead().appendChild(e)},g=function(e){var t=h({text:e});f(t),p(t)},m=function(e,t){var n=e.data,i="string"==typeof n,o=e.url||c.location.href;return i||e.cache||((n=n||{})._=Date.now()),n&&!e.upload&&(i||(n=function(e){var t=[];for(var n in e){var i=e[n];void 0!==i&&(null===i&&(i=""),"function"==typeof i&&(i=i()),t.push(encodeURIComponent(n)+"="+encodeURIComponent(i)))}return t.join("&")}(n)),"GET"===_(e)?(""!==n&&(o+=(o.indexOf("?")>-1?"&":"?")+n),n=null):t["Content-Type"]&&t["Content-Type"].indexOf("application/x-www-form-urlencoded")>-1&&(n=n.replace(/%20/g,"+"))),{url:o,parameters:n}};function _(e){return(e.method||"GET").toUpperCase()}var v=function(e){var t=e.headers||{};return t["Content-Type"]=t["Content-Type"]||function(e){var t;return e.data&&!e.upload&&"GET"!==_(e)&&(t="application/x-www-form-urlencoded;charset=utf-8"),e.contentType||t}(e),t.Accept=t.Accept||function(e){var t=e.dataType||"*",n="text/javascript, application/javascript, application/ecmascript, application/x-ecmascript",i={"*":"*/*",text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript",jsonp:n,script:n};return(0,s.extendFromObject)(i,e.accepts,!0),i[t]?i[t]+("*"!==t?", */*; q=0.01":""):i["*"]}(e),e.crossDomain||t["X-Requested-With"]||(t["X-Requested-With"]="XMLHttpRequest"),t},y=(0,u.default)({sendRequest:function(e){var t,n=a.default.getXhr(),s=new i.Deferred,u=s.promise(),d=!(0,l.isDefined)(e.async)||e.async,y=e.dataType,b=e.timeout||0;e.crossDomain=function(e){if(!(0,r.hasWindow)())return!0;var t=!1,n=o.default.createElement("a"),i=o.default.createElement("a");n.href=c.location.href;try{i.href=e,i.href=i.href,t=n.protocol+"//"+n.host!=i.protocol+"//"+i.host}catch(e){t=!0}return t}(e.url);var x="jsonp"===y||"script"===y;void 0===e.cache&&(e.cache=!x);var w=function(e){if("jsonp"===e.dataType){var t=Math.random().toString().replace(/\D/g,""),n=e.jsonpCallback||"dxCallback"+Date.now()+"_"+t,i=e.jsonp||"callback";return e.data=e.data||{},e.data[i]=n,n}}(e),C=v(e),S=m(e,C),k=S.url,D=S.parameters;if(w&&(c[w]=function(e){s.resolve(e,"success",n)}),e.crossDomain&&x){return function(e){var t=h({src:e});return new Promise((function(e,n){var i={load:e,error:n},a=function(e){i[e.type](),p(t)};for(var r in i)o.default.listen(t,r,a);f(t)}))}(k).then((function(){"jsonp"!==y&&s.resolve(null,"success",n)}),(function(){s.reject(n,"error")})),u}if(e.crossDomain&&!("withCredentials"in n))return s.reject(n,"error"),u;if(n.open(_(e),k,d,e.username,e.password),d&&(n.timeout=b,t=function(e,t){return e&&setTimeout((function(){t.customStatus="timeout",t.abort()}),e)}(b,n)),n.onreadystatechange=function(e){var i;4===n.readyState&&(clearTimeout(t),200<=(i=n.status)&&i<300?function(e){return 204!==e}(n.status)?function(e,t,n){var i=function(e){return e.responseType&&"text"!==e.responseType||"string"!=typeof e.responseText?e.response:e.responseText}(t);switch(n){case"jsonp":g(i);break;case"script":g(i),e.resolve(i,"success",t);break;case"json":try{e.resolve(JSON.parse(i),"success",t)}catch(n){e.reject(t,"parsererror",n)}break;default:e.resolve(i,"success",t)}}(s,n,y):s.resolve(null,"nocontent",n):s.reject(n,n.customStatus||"error"))},e.upload&&(n.upload.onprogress=e.upload.onprogress,n.upload.onloadstart=e.upload.onloadstart,n.upload.onabort=e.upload.onabort),e.xhrFields)for(var I in e.xhrFields)n[I]=e.xhrFields[I];for(var T in"arraybuffer"===e.responseType&&(n.responseType=e.responseType),C)Object.prototype.hasOwnProperty.call(C,T)&&(0,l.isDefined)(C[T])&&n.setRequestHeader(T,C[T]);return e.beforeSend&&e.beforeSend(n),n.send(D),u.abort=function(){n.abort()},u}});t.default=y,e.exports=t.default,e.exports.default=t.default},89386:function(e,t,n){t.wrapToArray=t.removeDuplicates=t.normalizeIndexes=t.groupBy=t.getUniqueValues=t.getIntersection=void 0;var i,o=n(35922),a=n(48013),r=(i=n(80209))&&i.__esModule?i:{default:i};function s(e){return function(e){if(Array.isArray(e))return l(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return l(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return l(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function l(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}function u(e){return e.reduce((function(e,t){var n;return e[t]=(null!==(n=e[t])&&void 0!==n?n:0)+1,e}),{})}t.wrapToArray=function(e){return Array.isArray(e)?e:[e]};t.getUniqueValues=function(e){return s(new Set(e))};t.getIntersection=function(e,t){var n=u(t);return e.filter((function(e){return n[e]--}))};t.removeDuplicates=function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],n=u(t);return e.filter((function(e){return!n[e]--}))};t.normalizeIndexes=function(e,t,n,i){var s={},l=(0,r.default)().useLegacyVisibleIndex,u=0,d=function(e){return!(0,o.isDefined)(e[t])&&(!i||i(e))};e.forEach((function(e){var i=e[t];i>=0?(s[i]=s[i]||[],e===n?s[i].unshift(e):s[i].push(e)):e[t]=void 0})),l||e.forEach((function(e){if(d(e)){for(;s[u];)u++;s[u]=[e],u++}})),u=0,(0,a.orderEach)(s,(function(e,n){n.forEach((function(n){e>=0&&(n[t]=u++)}))})),l&&e.forEach((function(e){d(e)&&(e[t]=u++)}))};t.groupBy=function(e,t){return e.reduce((function(e,n){var i,o=t(n);return e[o]=null!==(i=e[o])&&void 0!==i?i:[],e[o].push(n),e}),{})}},34671:function(e,t,n){t.isKeysEqual=t.findChanges=void 0;var i=n(35922),o=function(e,t){var n=t(e);if((0,i.isObject)(n))try{return JSON.stringify(n)}catch(e){return n}return n},a=function(e,t,n,i){return t[n[o(e,i)]]};t.isKeysEqual=function(e,t){if(e.length!==t.length)return!1;for(var n=0;n<t.length;n++)if(e[n]!==t[n])return!1;return!0};t.findChanges=function(e,t,n,i){var r={},s={},l=0,u=0,d=[];e.forEach((function(e,t){var i=o(e,n);r[i]=t})),t.forEach((function(e,t){var i=o(e,n);s[i]=t}));for(var c=Math.max(e.length,t.length),h=0;h<c+l;h++){var p=t[h],f=h-l+u,g=e[f];if(!p||g&&!a(g,t,s,n))g&&(d.push({type:"remove",key:n(g),index:h,oldItem:g}),u++,h--);else{var m=o(p,n),_=r[m],v=e[_];if(v){if(_!==f)return;i(v,p)||d.push({type:"update",data:p,key:n(p),index:h,oldItem:v})}else l++,d.push({type:"insert",data:p,index:h})}}return d}},47810:function(e,t,n){t.default=void 0;var i=n(13306),o=(0,n(58201).getNavigator)(),a=/(webkit)[ /]([\w.]+)/,r=/(mozilla)(?:.*? rv:([\w.]+))/,s=function(e){e=e.toLowerCase();var t={},n=a.exec(e)||e.indexOf("compatible")<0&&r.exec(e)||[],i=n[1],o=n[2];return"webkit"===i&&(t.webkit=!0,e.indexOf("chrome")>=0||e.indexOf("crios")>=0?(i="chrome",o=(o=/(?:chrome|crios)\/(\d+\.\d+)/.exec(e))&&o[1]):e.indexOf("fxios")>=0?(i="mozilla",o=(o=/fxios\/(\d+\.\d+)/.exec(e))&&o[1]):e.indexOf("safari")>=0&&/version|phantomjs/.test(e)?(i="safari",o=(o=/(?:version|phantomjs)\/([0-9.]+)/.exec(e))&&o[1]):(i="unknown",o=(o=/applewebkit\/([0-9.]+)/.exec(e))&&o[1])),i&&(t[i]=!0,t.version=o),t},l=(0,i.extend)({_fromUA:s},s(o.userAgent));t.default=l,e.exports=t.default,e.exports.default=t.default},39618:function(e,t){t.default=void 0;var n=function(e){var t,n=function(){return t=e.apply(this,arguments),n=function(){return t},t};return function(){return n.apply(this,arguments)}};t.default=n,e.exports=t.default,e.exports.default=t.default},44504:function(e,t){t.default=void 0;var n=function(e){this._options=e||{},this._list=[],this._queue=[],this._firing=!1,this._fired=!1,this._firingIndexes=[]};n.prototype._fireCore=function(e,t){var n=this._firingIndexes,i=this._list,o=this._options.stopOnFalse,a=n.length;for(n[a]=0;n[a]<i.length;n[a]++){if(!1===i[n[a]].apply(e,t)&&o)break}n.pop()},n.prototype.add=function(e){return"function"!=typeof e||this._options.unique&&this.has(e)||this._list.push(e),this},n.prototype.remove=function(e){var t=this._list,n=this._firingIndexes,i=t.indexOf(e);if(i>-1&&(t.splice(i,1),this._firing&&n.length))for(var o=0;o<n.length;o++)i<=n[o]&&n[o]--;return this},n.prototype.has=function(e){var t=this._list;return e?t.indexOf(e)>-1:!!t.length},n.prototype.empty=function(e){return this._list=[],this},n.prototype.fireWith=function(e,t){var n=this._queue;if(t=(t=t||[]).slice?t.slice():t,this._options.syncStrategy)this._firing=!0,this._fireCore(e,t);else{if(n.push([e,t]),this._firing)return;for(this._firing=!0;n.length;){var i=n.shift();this._fireCore(i[0],i[1])}}return this._firing=!1,this._fired=!0,this},n.prototype.fire=function(){this.fireWith(this,arguments)},n.prototype.fired=function(){return this._fired};var i=function(e){return new n(e)};t.default=i,e.exports=t.default,e.exports.default=t.default},20576:function(e,t,n){t.splitPair=t.pairToObject=t.normalizeKey=t.noop=t.grep=t.getKeyHash=t.findBestMatches=t.executeAsync=t.escapeRegExp=t.equalByValue=t.ensureDefined=t.denormalizeKey=t.deferUpdater=t.deferUpdate=t.deferRenderer=t.deferRender=t.asyncNoop=t.applyServerDecimalSeparator=void 0;var i=u(n(80209)),o=u(n(73176)),a=n(62754),r=n(47617),s=n(95479),l=n(35922);function u(e){return e&&e.__esModule?e:{default:e}}t.ensureDefined=function(e,t){return(0,l.isDefined)(e)?e:t};t.executeAsync=function(e,t){var n=new a.Deferred,i=t||this,o={promise:n.promise(),abort:function(){clearTimeout(s),n.rejectWith(i)}},r=function(){var t=e.call(i);t&&t.done&&(0,l.isFunction)(t.done)?t.done((function(){n.resolveWith(i)})):n.resolveWith(i)},s=(arguments[2]||setTimeout)(r,"number"==typeof t?t:0);return o};var d,c=[],h=[],p=[],f=function(e,t,n){if(d&&d!==e)return c.push(t),h.push(e),n=n||new a.Deferred,p.push(n),n;var i=d,o=p.length;d=e;var r=t();return r||(p.length>o?r=a.when.apply(this,p.slice(o)):n&&n.resolve()),d=i,n&&r&&r.done&&r.done(n.resolve).fail(n.reject),!d&&c.length&&("render"===h.shift()?g:m)(c.shift(),p.shift()),r||(0,a.when)()},g=function(e,t){return f("render",e,t)};t.deferRender=g;var m=function(e,t){return f("update",e,t)};t.deferUpdate=m;t.deferRenderer=function(e){return function(){var t=this;return f("render",(function(){return e.call(t)}))}};t.deferUpdater=function(e){return function(){var t=this;return f("update",(function(){return e.call(t)}))}};t.findBestMatches=function(e,t,n){var i=[],o=0;return(0,s.each)(t,(function(t,a){var r=0,l=n?n(a):a;(0,s.each)(e,(function(e,t){var n=l[e];if(void 0!==n){if(!_(n,t))return r=-1,!1;r++}})),r<o||(r>o&&(i.length=0,o=r),i.push(a))})),i};var _=function(e,t){if(Array.isArray(e)&&Array.isArray(t)){var n=!1;return(0,s.each)(e,(function(e,i){if(i!==t[e])return n=!0,!1})),!n}return e===t},v=function(e){var t,n;switch((0,l.type)(e)){case"string":return e.split(/\s+/,2);case"object":return[null!==(t=e.x)&&void 0!==t?t:e.h,null!==(n=e.y)&&void 0!==n?n:e.v];case"number":return[e];case"array":return e;default:return null}};t.splitPair=v;t.normalizeKey=function(e){var t=(0,l.isString)(e)?e:e.toString(),n=t.match(/[^a-zA-Z0-9_]/g);return n&&(0,s.each)(n,(function(e,n){t=t.replace(n,"__"+n.charCodeAt()+"__")})),t};t.denormalizeKey=function(e){var t=e.match(/__\d+__/g);return t&&t.forEach((function(t){var n=parseInt(t.replace("__",""));e=e.replace(t,String.fromCharCode(n))})),e};t.pairToObject=function(e,t){var n=v(e),i=t?parseFloat(n&&n[0]):parseInt(n&&n[0],10),o=t?parseFloat(n&&n[1]):parseInt(n&&n[1],10);return isFinite(i)||(i=0),isFinite(o)||(o=i),{h:i,v:o}};t.getKeyHash=function(e){if(e instanceof o.default)return e.toString();if((0,l.isObject)(e)||Array.isArray(e))try{var t=JSON.stringify(e);return"{}"===t?e:t}catch(t){return e}return e};t.escapeRegExp=function(e){return e.replace(/[[\]{}\-()*+?.\\^$|\s]/g,"\\$&")};t.applyServerDecimalSeparator=function(e){var t=(0,i.default)().serverDecimalSeparator;return(0,l.isDefined)(e)&&(e=e.toString().replace(".",t)),e};t.noop=function(){};t.asyncNoop=function(){return(new a.Deferred).resolve().promise()};t.grep=function(e,t,n){for(var i=[],o=!n,a=0;a<e.length;a++)!!t(e[a],a)===o&&i.push(e[a]);return i};var y=function(e,t,n){if(e.length!==t.length)return!1;for(var i=0;i<e.length;i++)if(!x(e[i],t[i],n+1))return!1;return!0},b=function(e,t,n,i){for(var o in e)if(Object.prototype.hasOwnProperty.call(e,o)&&!x(e[o],t[o],n+1,i))return!1;for(var a in t)if(!(a in e))return!1;return!0},x=function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0,i=!(arguments.length>3&&void 0!==arguments[3])||arguments[3];e=(0,r.toComparable)(e,!0),t=(0,r.toComparable)(t,!0);var o=i?e===t:e==t;return!!(o||n>=3)||((0,l.isObject)(e)&&(0,l.isObject)(t)?b(e,t,n,i):!(!Array.isArray(e)||!Array.isArray(t))&&y(e,t,n))};t.equalByValue=x},49036:function(e,t,n){t.equals=void 0;var i,o=(i=n(73349))&&i.__esModule?i:{default:i},a=n(47617),r=n(35922);function s(e){return(s="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}t.equals=function(e,t){return e=(0,a.toComparable)(e,!0),t=(0,a.toComparable)(t,!0),e&&t&&(0,r.isRenderer)(e)&&(0,r.isRenderer)(t)?t.is(e):!(e==e||t==t)||(0===e&&0===t?function(e,t){return 1/e==1/t}(e,t):!(null!==e&&"object"===s(e)&&!o.default.isElementNode(e))&&e===t)}},30869:function(e,t,n){t.logger=t.debug=void 0;var i=n(35922),o=function(){},a=function(e){return"undefined"!=typeof console&&(0,i.isFunction)(console[e])?console[e].bind(console):o},r={info:a("info"),warn:a("warn"),error:a("error")};t.logger=r;var s=function(){function e(e,t){if(!e)throw new Error(t)}return{assert:e,assertParam:function(t,n){e(null!=t,n)}}}();t.debug=s},47617:function(e,t,n){t.toComparable=t.getPathParts=t.compileSetter=t.compileGetter=void 0;var i=u(n(17381)),o=u(n(38377)),a=n(48013),r=n(35922),s=n(95479),l=u(n(26974));function u(e){return e&&e.__esModule?e:{default:e}}var d=l.default.unwrap,c=l.default.isWrapped,h=l.default.assign,p=function(e){return(t=e,t.replace(/\[/g,".").replace(/\]/g,"")).split(".");var t};t.getPathParts=p;var f=function(e,t,n,o){if("this"===t)throw new i.default.Error("E4016");var a=e[t];o.unwrapObservables&&c(a)?h(a,n):e[t]=n},g=function(e){return(e=e||{}).unwrapObservables=void 0===e.unwrapObservables||e.unwrapObservables,e};function m(e,t){return t.unwrapObservables?d(e):e}var _=function(e){if(arguments.length>1&&(e=[].slice.call(arguments)),!e||"this"===e)return function(e){return e};if("string"==typeof e){var t=p(e);return function(e,n){for(var i=(n=g(n)).functionsAsIs,o=("defaultValue"in n),a=m(e,n),s=0;s<t.length;s++){if(!a){if(null==a&&o)return n.defaultValue;break}var l=t[s];if(o&&(0,r.isObject)(a)&&!(l in a))return n.defaultValue;var u=m(a[l],n);!i&&(0,r.isFunction)(u)&&(u=u.call(a)),a=u}return a}}return Array.isArray(e)?v(e):(0,r.isFunction)(e)?e:void 0};function v(e){for(var t={},n=0,i=e.length;n<i;n++){var o=e[n];t[o]=_(o)}return function(e,n){var i;return(0,s.each)(t,(function(t){var o=this(e,n);if(void 0!==o){for(var a=i||(i={}),r=t.split("."),s=r.length-1,l=0;l<s;l++){var u=r[l];u in a||(a[u]={}),a=a[u]}a[r[s]]=o}})),i}}t.compileGetter=_;var y=function(e,t,n,i){if((0,r.isDefined)(n))return n;var o={};return f(e,t,o,i),o};t.compileSetter=function(e){var t=(e=p(e||"this")).length-1;return function(n,i,o){var s=m(n,o=g(o));e.forEach((function(e,n){var l=function(e,t,n){return n=n||{},m("this"===t?e:e[t],n)}(s,e,o),u=!o.functionsAsIs&&(0,r.isFunction)(l)&&!c(l);n===t?o.merge&&(0,r.isPlainObject)(i)&&(!(0,r.isDefined)(l)||(0,r.isPlainObject)(l))?(l=y(s,e,l,o),(0,a.deepExtendArraySafe)(l,i,!1,!0)):u?s[e](i):f(s,e,i,o):(l=y(s,e,l,o),u&&(l=l.call(s)),s=l)}))}};t.toComparable=function(e,t){return e instanceof Date?e.getTime():e&&e instanceof o.default&&e.valueOf?e.valueOf():t||"string"!=typeof e?e:e.toLowerCase()}},91198:function(e,t,n){t.default=void 0;var i=n(35922),o=n(60810),a=n(95479),r=n(78008);function s(e,t,n){return(s=l()?Reflect.construct.bind():function(e,t,n){var i=[null];i.push.apply(i,t);var o=new(Function.bind.apply(e,i));return n&&u(o,n.prototype),o}).apply(null,arguments)}function l(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}function u(e,t){return(u=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e})(e,t)}var d=["millisecond","second","minute","hour","day","week","month","quarter","year"],c=function e(t){switch(t){case"millisecond":return 1;case"second":return 1e3*e("millisecond");case"minute":return 60*e("second");case"hour":return 60*e("minute");case"day":return 24*e("hour");case"week":return 7*e("day");case"month":return 30*e("day");case"quarter":return 3*e("month");case"year":return 365*e("day");default:return 0}},h=function(e){var t,n,i,o=["millisecond","second","minute","hour","day","month","year"],a={};for(t=o.length-1;t>=0;t--)i=o[t],(n=Math.floor(e/c(i)))>0&&(a[i+"s"]=n,e-=p(i,n));return a};function p(e,t){return c(e)*t}function f(e){var t,n=-1;return(0,i.isString)(e)?e:(0,i.isObject)(e)?((0,a.each)(e,(function(e,i){for(t=0;t<d.length;t++)i&&(e===d[t]+"s"||e===d[t])&&n<t&&(n=t)})),d[n]):""}var g={millisecond:"millisecond",second:"longtime",minute:"shorttime",hour:"shorttime",day:"day",week:"day",month:"month",quarter:"quarter",year:"year"};var m=function(e){return Math.floor(e/3)},_=function(e){return 3*m(e)};function v(e,t,n,i){e=new Date(e.getTime());var o,a,r=new Date(e.getTime()),s=f(t);switch(s){case"second":e=new Date(1e3*Math.floor(r.getTime()/1e3));break;case"minute":e=new Date(6e4*Math.floor(r.getTime()/6e4));break;case"hour":e=new Date(36e5*Math.floor(r.getTime()/36e5));break;case"year":e.setMonth(0);case"month":e.setDate(1);case"day":e.setHours(0,0,0,0);break;case"week":(e=T(e,i||0)).setHours(0,0,0,0);break;case"quarter":o=_(e.getMonth()),a=e.getMonth(),e.setDate(1),e.setHours(0,0,0,0),a!==o&&e.setMonth(o)}return n&&"hour"!==s&&"minute"!==s&&"second"!==s&&O(r,e),e}function y(e){return v(e,"day")}function b(e,t,n){var o=new Date(e.getTime()),a=(0,i.isString)(t)?C(t.toLowerCase()):(0,i.isNumeric)(t)?h(t):t;return a.years&&o.setFullYear(o.getFullYear()+a.years*n),a.quarters&&o.setMonth(o.getMonth()+3*a.quarters*n),a.months&&o.setMonth(o.getMonth()+a.months*n),a.weeks&&o.setDate(o.getDate()+7*a.weeks*n),a.days&&o.setDate(o.getDate()+a.days*n),a.hours&&o.setTime(o.getTime()+36e5*a.hours*n),a.minutes&&o.setTime(o.getTime()+6e4*a.minutes*n),a.seconds&&o.setTime(o.getTime()+1e3*a.seconds*n),a.milliseconds&&o.setTime(o.getTime()+a.milliseconds*n),o}var x=function(e,t,n){var a=n?-1:1;return(0,i.isDate)(e)?b(e,t,a):(0,o.adjust)(e+t*a,t)};function w(e){return P(e.getFullYear(),e.getMonth()+1,0).getDate()}function C(e){var t={};switch(e){case"year":t.years=1;break;case"month":t.months=1;break;case"quarter":t.months=3;break;case"week":t.weeks=1;break;case"day":t.days=1;break;case"hour":t.hours=1;break;case"minute":t.minutes=1;break;case"second":t.seconds=1;break;case"millisecond":t.milliseconds=1}return t}function S(e,t){return k(e,t)&&e.getMonth()===t.getMonth()}function k(e,t){return e&&t&&e.getFullYear()===t.getFullYear()}function D(e){return e&&e.getFullYear()-e.getFullYear()%100}function I(e){return e&&e.getFullYear()-e.getFullYear()%10}function T(e,t){var n=(e.getDay()-t+7)%7,i=new Date(e);return i.setDate(e.getDate()-n),i}function E(e,t,n){var o=e;return(0,i.isDefined)(e)?((0,i.isDefined)(t)&&e<t&&(o=t),(0,i.isDefined)(n)&&e>n&&(o=n),o):e}function O(e,t){if((0,i.isDefined)(e)){var n=t.getHours()-e.getHours();if(0!==n){var o=1===n||-23===n?-1:1,a=new Date(t.getTime()+36e5*o);(o>0||a.getDate()===t.getDate())&&t.setTime(a.getTime())}}}function A(e,t){return 60*(t.getTimezoneOffset()-e.getTimezoneOffset())*1e3}var P=function(e){var t=s(Date,Array.prototype.slice.call(arguments));return t.setFullYear(e),t},R={dateUnitIntervals:d,convertMillisecondsToDateUnits:h,dateToMilliseconds:function(e){var t=0;return(0,i.isObject)(e)&&(0,a.each)(e,(function(e,n){t+=p(e.substr(0,e.length-1),n)})),(0,i.isString)(e)&&(t=p(e,1)),t},getNextDateUnit:function(e,t){switch(f(e)){case"millisecond":return"second";case"second":return"minute";case"minute":return"hour";case"hour":return"day";case"day":return t?"week":"month";case"week":return"month";case"month":return"quarter";case"quarter":case"year":return"year";default:return 0}},convertDateUnitToMilliseconds:p,getDateUnitInterval:f,getDateFormatByTickInterval:function(e){return g[f(e)]||""},getDatesDifferences:function(e,t){var n=0,i={year:e.getFullYear()!==t.getFullYear(),month:e.getMonth()!==t.getMonth(),day:e.getDate()!==t.getDate(),hour:e.getHours()!==t.getHours(),minute:e.getMinutes()!==t.getMinutes(),second:e.getSeconds()!==t.getSeconds(),millisecond:e.getMilliseconds()!==t.getMilliseconds()};return(0,a.each)(i,(function(e,t){t&&n++})),0===n&&0!==A(e,t)&&(i.hour=!0,n++),i.count=n,i},correctDateWithUnitBeginning:v,trimTime:y,setToDayEnd:function(e){var t=y(e);return t.setDate(t.getDate()+1),new Date(t.getTime()-1)},roundDateByStartDayHour:function(e,t){var n=this.dateTimeFromDecimal(t),i=new Date(e);return(e.getHours()===n.hours&&e.getMinutes()<n.minutes||e.getHours()<n.hours)&&i.setHours(n.hours,n.minutes,0,0),i},dateTimeFromDecimal:function(e){return{hours:Math.floor(e),minutes:e%1*60}},addDateInterval:b,addInterval:x,getSequenceByInterval:function(e,t,n){var o,a=[];for(a.push((0,i.isDate)(e)?new Date(e.getTime()):e),o=e;o<t;)o=x(o,n),a.push(o);return a},getDateIntervalByString:C,sameHoursAndMinutes:function(e,t){return e&&t&&e.getHours()===t.getHours()&&e.getMinutes()===t.getMinutes()},sameDate:function(e,t){return S(e,t)&&e.getDate()===t.getDate()},sameMonthAndYear:S,sameMonth:S,sameYear:k,sameDecade:function(e,t){if((0,i.isDefined)(e)&&(0,i.isDefined)(t)){var n=e.getFullYear()-e.getFullYear()%10,o=t.getFullYear()-t.getFullYear()%10;return e&&t&&n===o}},sameCentury:function(e,t){if((0,i.isDefined)(e)&&(0,i.isDefined)(t)){var n=e.getFullYear()-e.getFullYear()%100,o=t.getFullYear()-t.getFullYear()%100;return e&&t&&n===o}},getDifferenceInMonth:function(e){var t=1;return"year"===e&&(t=12),"decade"===e&&(t=120),"century"===e&&(t=1200),t},getDifferenceInMonthForCells:function(e){var t=1;return"decade"===e&&(t=12),"century"===e&&(t=120),t},getFirstYearInDecade:I,getFirstDecadeInCentury:D,getShortDateFormat:function(){return"yyyy/MM/dd"},getViewFirstCellDate:function(e,t){return"month"===e?P(t.getFullYear(),t.getMonth(),1):"year"===e?P(t.getFullYear(),0,t.getDate()):"decade"===e?P(I(t),t.getMonth(),t.getDate()):"century"===e?P(D(t),t.getMonth(),t.getDate()):void 0},getViewLastCellDate:function(e,t){return"month"===e?P(t.getFullYear(),t.getMonth(),w(t)):"year"===e?P(t.getFullYear(),11,t.getDate()):"decade"===e?P(I(t)+9,t.getMonth(),t.getDate()):"century"===e?P(D(t)+90,t.getMonth(),t.getDate()):void 0},getViewDown:function(e){switch(e){case"century":return"decade";case"decade":return"year";case"year":return"month"}},getViewUp:function(e){switch(e){case"month":return"year";case"year":return"decade";case"decade":return"century"}},getLastMonthDay:w,getLastMonthDate:function(e){if((0,i.isDefined)(e))return P(e.getFullYear(),e.getMonth()+1,0)},getFirstMonthDate:function(e){if((0,i.isDefined)(e))return P(e.getFullYear(),e.getMonth(),1)},getFirstWeekDate:T,normalizeDateByWeek:function(e,t){var n=R.getDatesInterval(e,t,"day"),i=new Date(e);return n>=6&&(i=new Date(i.setDate(i.getDate()+7))),i},getQuarter:m,getFirstQuarterMonth:_,dateInRange:function(e,t,n,i){return"date"===i&&(t=t&&R.correctDateWithUnitBeginning(t,"day"),n=n&&R.correctDateWithUnitBeginning(n,"day"),e=e&&R.correctDateWithUnitBeginning(e,"day")),E(e,t,n)===e},intervalsOverlap:function(e){var t=e.firstMin,n=e.firstMax,i=e.secondMin,o=e.secondMax;return t<=i&&i<=n||t>i&&t<o||t<o&&n>o},roundToHour:function(e){var t=new Date(e.getTime());return t.setHours(t.getHours()+1),t.setMinutes(0),t},normalizeDate:E,getViewMinBoundaryDate:function(e,t){var n=P(t.getFullYear(),t.getMonth(),1);return"month"===e?n:(n.setMonth(0),"year"===e||("decade"===e&&n.setFullYear(I(t)),"century"===e&&n.setFullYear(D(t))),n)},getViewMaxBoundaryDate:function(e,t){var n=new Date(t);return n.setDate(w(t)),"month"===e?n:(n.setMonth(11),n.setDate(w(n)),"year"===e||("decade"===e&&n.setFullYear(I(t)+9),"century"===e&&n.setFullYear(D(t)+99)),n)},fixTimezoneGap:O,getTimezonesDifference:A,makeDate:function(e){return new Date(e)},getDatesInterval:function(e,t,n){var i=t.getTime()-e.getTime(),o=c(n)||1;return Math.floor(i/o)},getDatesOfInterval:function(e,t,n){for(var i=[],o=new Date(e.getTime());o<t;)i.push(new Date(o.getTime())),o=this.addInterval(o,n);return i},createDateWithFullYear:P,sameView:function(e,t,n){return R[(0,r.camelize)("same "+e)](t,n)}},M=R;t.default=M,e.exports=t.default,e.exports.default=t.default},69434:function(e,t,n){t.default=void 0;var i=s(n(80209)),o=n(40594),a=s(n(15564)),r=n(35922);function s(e){return e&&e.__esModule?e:{default:e}}var l=/^(\d{4,})(-)?(\d{2})(-)?(\d{2})(?:T(\d{2})(:)?(\d{2})?(:)?(\d{2}(?:\.(\d{1,3})\d*)?)?)?(Z|([+-])(\d{2})(:)?(\d{2})?)?$/,u=/^(\d{2}):(\d{2})(:(\d{2}))?$/,d=["","yyyy","","MM","","dd","THH","","mm","","ss",".SSS"],c=/^(\d{4})\/(\d{2})\/(\d{2})$/,h=function(e,t){var n;return(0,r.isString)(e)&&!t&&(n=function(e){var t=e.match(l);if(!t)return(t=e.match(u))?new Date(0,0,0,p(t[1]),p(t[2]),p(t[4])):void 0;var n=p(t[1]),i=--t[3],o=t[5],a=0,r=0,s=function(e){return n<100&&e.setFullYear(n),e};a=p(t[14]),r=p(t[16]),"-"===t[13]&&(a=-a,r=-r);var d=p(t[6])-a,c=p(t[8])-r,h=p(t[10]),f=(g=t[11],p(g=g||"")*Math.pow(10,3-g.length));var g;if(t[12])return s(new Date(Date.UTC(n,i,o,d,c,h,f)));return s(new Date(n,i,o,d,c,h,f))}(e)),n||function(e){var t="yyyy/MM/dd"===f(e),n=!(0,r.isDate)(e)&&Date.parse(e);if(!n&&t){var i=e.match(c);if(i){var o=new Date(p(i[1]),p(i[2]),p(i[3]));return o.setFullYear(p(i[1])),o.setMonth(p(i[2])-1),o.setDate(p(i[3])),o}}return(0,r.isNumeric)(n)?new Date(n):e}(e)};function p(e){return+e||0}var f=function(e){return"number"==typeof e?"number":(0,r.isString)(e)?((0,i.default)().forceIsoDateParsing&&(t=function(e,t){var n=e.match(l),i="";if(!n)return(n=e.match(u))?n[3]?"HH:mm:ss":"HH:mm":void 0;for(var o=1;o<d.length;o++)n[o]&&(i+=d[o]||n[o]);return"Z"===n[12]&&(i+="'Z'"),n[14]&&(n[15]?i+="xxx":n[16]?i+="xx":i+="x"),i}(e)),t||(e.indexOf(":")>=0?"yyyy/MM/dd HH:mm:ss":"yyyy/MM/dd")):e?null:void 0;var t},g={dateParser:h,deserializeDate:function(e){return"number"==typeof e?new Date(e):h(e,!(0,i.default)().forceIsoDateParsing)},serializeDate:function(e,t){return t?(0,r.isDate)(e)?"number"===t?e&&e.valueOf?e.valueOf():null:(0,o.getFormatter)(t,a.default)(e):null:e},getDateSerializationFormat:f};t.default=g,e.exports=t.default,e.exports.default=t.default},62754:function(e,t,n){t.Deferred=function(){return new l},t.fromPromise=u,t.setStrategy=function(e){l=e.Deferred,d=e.when},t.when=function(){return d.apply(this,arguments)};var i,o=n(35922),a=n(13306),r=(i=n(44504))&&i.__esModule?i:{default:i};var s=[{method:"resolve",handler:"done",state:"resolved"},{method:"reject",handler:"fail",state:"rejected"},{method:"notify",handler:"progress"}],l=function(){var e=this;this._state="pending",this._promise={},s.forEach(function(t){var n=t.method;this[n+"Callbacks"]=new r.default,this[n]=function(){return this[n+"With"](this._promise,arguments)}.bind(this),this._promise[t.handler]=function(t){if(!t)return this;var i=e[n+"Callbacks"];return i.fired()?t.apply(e[n+"Context"],e[n+"Args"]):i.add(function(e,n){t.apply(e,n)}.bind(this)),this}}.bind(this)),this._promise.always=function(e){return this.done(e).fail(e)},this._promise.catch=function(e){return this.then(null,e)},this._promise.then=function(e,t){var n=new l;return["done","fail"].forEach(function(i){var a="done"===i?e:t;this[i]((function(){if(a){var e=a&&a.apply(this,arguments);(0,o.isDeferred)(e)?e.done(n.resolve).fail(n.reject):(0,o.isPromise)(e)?e.then(n.resolve,n.reject):n.resolve.apply(this,(0,o.isDefined)(e)?[e]:arguments)}else n["done"===i?"resolve":"reject"].apply(this,arguments)}))}.bind(this)),n.promise()},this._promise.state=function(){return e._state},this._promise.promise=function(t){return t?(0,a.extend)(t,e._promise):e._promise},this._promise.promise(this)};function u(e,t){if((0,o.isDeferred)(e))return e;if((0,o.isPromise)(e)){var n=new l;return e.then((function(){n.resolveWith.apply(n,[t].concat([[].slice.call(arguments)]))}),(function(){n.rejectWith.apply(n,[t].concat([[].slice.call(arguments)]))})),n}return(new l).resolveWith(t,[e])}s.forEach((function(e){var t=e.method,n=e.state;l.prototype[t+"With"]=function(e,i){var o=this[t+"Callbacks"];return"pending"===this.state()&&(this[t+"Args"]=i,this[t+"Context"]=e,n&&(this._state=n),o.fire(e,i)),this}}));var d=function(){if(1===arguments.length)return u(arguments[0]);for(var e=[].slice.call(arguments),t=[],n=0,i=new l,a=function(o){return function(a){t[o]=this,e[o]=arguments.length>1?[].slice.call(arguments):a,++n===e.length&&i.resolveWith(t,e)}},r=0;r<e.length;r++)(0,o.isDeferred)(e[r])?e[r].promise().done(a(r)).fail(i.reject):n++;return n===e.length&&i.resolveWith(t,e),i.promise()}},20476:function(e,t,n){t.default=function(e){var t=s.default.inherit(e),n=t,i=new n(e),l={},u=function(t,n){(0,r.each)(t,(function(t){(0,a.isFunction)(i[t])?!n&&e[t]||(e[t]=function(){return i[t].apply(e,arguments)}):(n&&(l[t]=e[t]),e[t]=i[t])}))};return u(e,!0),e.inject=function(e){n=n.inherit(e),i=new n,u(e)},e.resetInjection=function(){(0,o.extend)(e,l),n=t,i=new t},e};var i,o=n(13306),a=n(35922),r=n(95479),s=(i=n(38377))&&i.__esModule?i:{default:i};e.exports=t.default,e.exports.default=t.default},3532:function(e,t,n){t.resetActiveElement=t.replaceWith=t.normalizeTemplateElement=t.insertBefore=t.extractTemplateMarkup=t.createTextElementHiddenCopy=t.contains=t.closestCommonParent=t.clipboardText=t.clearSelection=void 0;var i=s(n(73349)),o=s(n(68374)),a=n(95479),r=n(35922);function s(e){return e&&e.__esModule?e:{default:e}}var l=(0,n(58201).getWindow)();t.resetActiveElement=function(){var e,t=i.default.getActiveElement();t&&t!==i.default.getBody()&&(null===(e=t.blur)||void 0===e||e.call(t))};t.clearSelection=function(){var e=l.getSelection();if(e&&"Caret"!==e.type)if(e.empty)e.empty();else if(e.removeAllRanges)try{e.removeAllRanges()}catch(e){}};t.closestCommonParent=function(e,t){var n=(0,o.default)(e),i=(0,o.default)(t);if(n[0]===i[0])return n[0];for(var a=n.parents(),r=i.parents(),s=-Math.min(a.length,r.length);s<0;s++)if(a.get(s)===r.get(s))return a.get(s)};t.extractTemplateMarkup=function(e){var t=(e=(0,o.default)(e)).length&&e.filter((function(){var e=(0,o.default)(this);return e.is("script[type]")&&e.attr("type").indexOf("script")<0}));return t.length?t.eq(0).html():(e=(0,o.default)("<div>").append(e)).html()};t.normalizeTemplateElement=function e(t){var n=(0,r.isDefined)(t)&&(t.nodeType||(0,r.isRenderer)(t))?(0,o.default)(t):(0,o.default)("<div>").html(t).contents();return 1===n.length&&(n.is("script")?n=e(n.html().trim()):n.is("table")&&(n=n.children("tbody").contents())),n};t.clipboardText=function(e,t){var n=e.originalEvent&&e.originalEvent.clipboardData||l.clipboardData;if(!t)return n&&n.getData("Text");n&&n.setData("Text",t)};t.contains=function e(t,n){return!!n&&(i.default.isTextNode(n)&&(n=n.parentNode),i.default.isDocument(t)?t.documentElement.contains(n):(0,r.isWindow)(t)?e(t.document,n):t.contains?t.contains(n):!!(n.compareDocumentPosition(t)&n.DOCUMENT_POSITION_CONTAINS))};t.createTextElementHiddenCopy=function(e,t,n){var i=l.getComputedStyle((0,o.default)(e).get(0)),a=n&&n.includePaddings;return(0,o.default)("<div>").text(t).css({fontStyle:i.fontStyle,fontVariant:i.fontVariant,fontWeight:i.fontWeight,fontSize:i.fontSize,fontFamily:i.fontFamily,letterSpacing:i.letterSpacing,border:i.border,paddingTop:a?i.paddingTop:"",paddingRight:a?i.paddingRight:"",paddingBottom:a?i.paddingBottom:"",paddingLeft:a?i.paddingLeft:"",visibility:"hidden",whiteSpace:"pre",position:"absolute",float:"left"})};var u=function(e,t){return t&&i.default.insertElement(e.parentNode,t,e),e};t.insertBefore=u;t.replaceWith=function(e,t){if(t&&t[0])return t.is(e)?e:((0,a.each)(t,(function(t,n){u(e[0],n)})),e.remove(),t)}},95640:function(e,t,n){t.default=function(e,t){var n={ERROR_MESSAGES:(0,i.extend)(t,e),Error:function(){return d([].slice.call(arguments))},log:function(e){var t="log";/^E\d+$/.test(e)?t="error":/^W\d+$/.test(e)&&(t="warn"),o.logger[t]("log"===t?e:s([].slice.call(arguments)))}};function s(e){var t=e[0];return u(t,l(t,e=e.slice(1)))}function l(e,t){return t=[n.ERROR_MESSAGES[e]].concat(t),a.format.apply(this,t).replace(/\.*\s*?$/,"")}function u(e,t){return a.format.apply(this,["{0} - {1}. See:\n{2}",e,t,c(e)])}function d(e){var t=e[0],n=l(t,e=e.slice(1)),o=c(t),a=u(t,n);return(0,i.extend)(new Error(a),{__id:t,__details:n,url:o})}function c(e){return r+e}return n};var i=n(13306),o=n(30869),a=n(68752),r="http://js.devexpress.com/error/"+n(36739).version.split(".").slice(0,2).join("_")+"/";e.exports=t.default,e.exports.default=t.default},13306:function(e,t,n){t.extendFromObject=t.extend=void 0;var i=n(35922);t.extendFromObject=function(e,t,n){for(var i in e=e||{},t)if(Object.prototype.hasOwnProperty.call(t,i)){var o=t[i];i in e&&!n||(e[i]=o)}return e};t.extend=function e(t){var n=1,o=!1;for("boolean"==typeof(t=t||{})&&(o=t,t=arguments[1]||{},n++);n<arguments.length;n++){var a=arguments[n];if(null!=a)for(var r in a){var s=t[r],l=a[r],u=!1,d=void 0;"__proto__"!==r&&"constructor"!==r&&t!==l&&(o&&l&&((0,i.isPlainObject)(l)||(u=Array.isArray(l)))?(d=u?s&&Array.isArray(s)?s:[]:s&&(0,i.isPlainObject)(s)?s:{},t[r]=e(o,d,l)):void 0!==l&&(t[r]=l))}}return t}},61371:function(e,t,n){t.parseHTML=t.isTablePart=void 0;var i,o=(i=n(73349))&&i.__esModule?i:{default:i};function a(e){return function(e){if(Array.isArray(e))return r(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return r(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return r(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function r(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}var s=/<([a-z][^/\0>\x20\t\r\n\f]+)/i,l={default:{tagsCount:0,startTags:"",endTags:""},thead:{tagsCount:1,startTags:"<table>",endTags:"</table>"},td:{tagsCount:3,startTags:"<table><tbody><tr>",endTags:"</tr></tbody></table>"},col:{tagsCount:2,startTags:"<table><colgroup>",endTags:"</colgroup></table>"},tr:{tagsCount:2,startTags:"<table><tbody>",endTags:"</tbody></table>"}};l.tbody=l.colgroup=l.caption=l.tfoot=l.thead,l.th=l.td;t.parseHTML=function(e){if("string"!=typeof e)return null;var t=o.default.createDocumentFragment().appendChild(o.default.createElement("div")),n=s.exec(e),i=n&&n[1].toLowerCase(),r=l[i]||l.default;t.innerHTML=r.startTags+e+r.endTags;for(var u=0;u<r.tagsCount;u++)t=t.lastChild;return a(t.childNodes)};t.isTablePart=function(e){var t=s.exec(e);return t&&t[1]in l}},44899:function(e,t,n){t.getImageSourceType=t.getImageContainer=void 0;var i,o=(i=n(68374))&&i.__esModule?i:{default:i};var a=function(e){return!(!e||"string"!=typeof e)&&(/^\s*<svg[^>]*>(.|\r?\n)*?<\/svg>\s*$/i.test(e)?"svg":/data:.*base64|\.|[^<\s]\//.test(e)?"image":/^[\w-_]+$/.test(e)?"dxIcon":!!/^\s?([\w-_]\s?)+$/.test(e)&&"fontIcon")};t.getImageSourceType=a;t.getImageContainer=function(e){switch(a(e)){case"image":return(0,o.default)("<img>").attr("src",e).addClass("dx-icon");case"fontIcon":return(0,o.default)("<i>").addClass("".concat("dx-icon"," ").concat(e));case"dxIcon":return(0,o.default)("<i>").addClass("".concat("dx-icon"," ").concat("dx-icon","-").concat(e));case"svg":return(0,o.default)("<i>").addClass("".concat("dx-icon"," ").concat("dx-svg-icon")).append(e);default:return null}}},78008:function(e,t,n){t.underscore=t.titleize=t.humanize=t.dasherize=t.captionize=t.camelize=void 0;var i=n(95479),o=function(e){return null==e?"":String(e)},a=function(e){return o(e).charAt(0).toUpperCase()+e.substr(1)},r=function(e){return o(e).replace(/([a-z\d])([A-Z])/g,"$1 $2").split(/[\s_-]+/)},s=function(e){return(0,i.map)(r(e),(function(e){return e.toLowerCase()})).join("-")};t.dasherize=s;t.underscore=function(e){return s(e).replace(/-/g,"_")};t.camelize=function(e,t){return(0,i.map)(r(e),(function(e,n){return e=e.toLowerCase(),(t||n>0)&&(e=a(e)),e})).join("")};t.humanize=function(e){return a(s(e).replace(/-/g," "))};t.titleize=function(e){return(0,i.map)(r(e),(function(e){return a(e.toLowerCase())})).join(" ")};var l=["0","1","2","3","4","5","6","7","8","9"];t.captionize=function(e){var t,n,i=[],o=!1,a=!1;for(t=0;t<e.length;t++)a=(n=e.charAt(t))===n.toUpperCase()&&"-"!==n&&")"!==n&&"/"!==n||n in l,"_"===n||"."===n?(n=" ",a=!0):0===t?(n=n.toUpperCase(),a=!0):!o&&a&&i.length>0&&i.push(" "),i.push(n),o=a;return i.join("")}},95479:function(e,t){t.reverseEach=t.map=t.each=void 0;t.map=function(e,t){if(Array.isArray(e))return e.map(t);var n=[];for(var i in e)n.push(t(e[i],i));return n};t.each=function(e,t){if(e){if("length"in e)for(var n=0;n<e.length&&!1!==t.call(e[n],n,e[n]);n++);else for(var i in e)if(!1===t.call(e[i],i,e[i]))break;return e}};t.reverseEach=function(e,t){if(e&&"length"in e&&0!==e.length)for(var n=e.length-1;n>=0&&!1!==t.call(e[n],n,e[n]);n--);}},88933:function(e,t,n){t.default=void 0;var i,o=(i=n(17381))&&i.__esModule?i:{default:i};var a=function(){var e={},t=function(t){return e[t]||0};return{obtain:function(n){e[n]=t(n)+1},release:function(n){var i=t(n);if(i<1)throw o.default.Error("E0014");1===i?delete e[n]:e[n]=i-1},locked:function(e){return t(e)>0}}};t.default=a,e.exports=t.default,e.exports.default=t.default},60810:function(e,t,n){t.adjust=function(e,t){var n,r=a(t||0)+2,s=e.toString().split("."),l=e,u=Math.abs(e),d=(0,i.isExponential)(e),c=u>1?10:0;if(1===s.length)return e;d||((0,i.isExponential)(t)&&(r=s[0].length+o(t)),e=(e=u)-Math.floor(e)+c);if(r=function(){return"0.000300"!==3e-4.toPrecision(3)}()&&o(e)>6||r>7?15:7,!d&&(n=parseFloat(e.toPrecision(r)).toString().split("."))[0]===c.toString())return parseFloat(s[0]+"."+n[1]);return parseFloat(l.toPrecision(r))},t.fitIntoRange=void 0,t.getExponent=o,t.getExponentLength=function(e){var t,n=e.toString();return(null===(t=n.split(".")[1])||void 0===t?void 0:t.length)||parseInt(n.split("e-")[1])||0},t.getPrecision=a,t.getRemainderByDivision=function(e,t,n){if(t===parseInt(t))return e%t;var i=s(e/t,n);return(i-parseInt(i))*t},t.getRoot=r,t.inRange=void 0,t.multiplyInExponentialForm=function(e,t){var n=function(e){var t=e.toExponential().split("e"),n=parseFloat(t[0]);return{exponent:parseInt(t[1]),mantissa:n}}(e);return parseFloat("".concat(n.mantissa,"e").concat(n.exponent+t))},t.roundFloatPart=s,t.sign=void 0,t.solveCubicEquation=function(e,t,n,i){if(Math.abs(e)<1e-8){if(e=t,t=n,n=i,Math.abs(e)<1e-8)return e=t,t=n,Math.abs(e)<1e-8?[]:[-t/e];var o=t*t-4*e*n;return Math.abs(o)<1e-8?[-t/(2*e)]:o>0?[(-t+Math.sqrt(o))/(2*e),(-t-Math.sqrt(o))/(2*e)]:[]}var a,s,l=(3*e*n-t*t)/(3*e*e),u=(2*t*t*t-9*e*t*n+27*e*e*i)/(27*e*e*e);if(Math.abs(l)<1e-8)a=[r(-u,3)];else if(Math.abs(u)<1e-8)a=[0].concat(l<0?[Math.sqrt(-l),-Math.sqrt(-l)]:[]);else{var d=u*u/4+l*l*l/27;if(Math.abs(d)<1e-8)a=[-1.5*u/l,3*u/l];else if(d>0)s=r(-u/2-Math.sqrt(d),3),a=[s-l/(3*s)];else{s=2*Math.sqrt(-l/3);var c=Math.acos(3*u/l/s)/3,h=2*Math.PI/3;a=[s*Math.cos(c),s*Math.cos(c-h),s*Math.cos(c-2*h)]}}for(var p=0;p<a.length;p++)a[p]-=t/(3*e);return a},t.trunc=function(e){return Math.trunc?Math.trunc(e):e>0?Math.floor(e):Math.ceil(e)};var i=n(35922);t.sign=function(e){return 0===e?0:e/Math.abs(e)};t.fitIntoRange=function(e,t,n){var i=!t&&0!==t,o=!n&&0!==n;return i&&(t=o?e:Math.min(e,n)),o&&(n=i?e:Math.max(e,t)),Math.min(Math.max(e,t),n)};function o(e){return Math.abs(parseInt(e.toExponential().split("e")[1]))}function a(e){var t=e.toString();if(t.indexOf(".")<0)return 0;var n=t.split("."),i=n[1].indexOf("e");return i>=0?i:n[1].length}function r(e,t){if(e<0&&t%2!=1)return NaN;var n=Math.pow(Math.abs(e),1/t);return t%2==1&&e<0?-n:n}function s(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;return parseFloat(e.toFixed(t))}t.inRange=function(e,t,n){return e>=t&&e<=n}},48013:function(e,t,n){t.orderEach=t.deepExtendArraySafe=t.clone=void 0;var i,o=n(35922),a=(i=n(26974))&&i.__esModule?i:{default:i};var r=function(){function e(){}return function(t){return e.prototype=t,new e}}();t.clone=r;t.orderEach=function(e,t){var n,i,a=[];for(n in e)Object.prototype.hasOwnProperty.call(e,n)&&a.push(n);for(a.sort((function(e,t){var n=(0,o.isNumeric)(e),i=(0,o.isNumeric)(t);return n&&i?e-t:n&&!i?-1:!n&&i?1:e<t?-1:e>t?1:0})),i=0;i<a.length;i++)t(n=a[i],e[n])};var s=function(e,t,n,i){!i&&a.default.isWrapped(e[t])?a.default.assign(e[t],n):e[t]=n};t.deepExtendArraySafe=function e(t,n,i,a){var r,l;for(var u in n)if(r=t[u],l=n[u],"__proto__"!==u&&"constructor"!==u&&t!==l){if((0,o.isPlainObject)(l))l=e((i?(0,o.isObject)(r):(0,o.isPlainObject)(r))?r:{},l,i,a);void 0!==l&&r!==l&&s(t,u,l,a)}return t}},37518:function(e,t,n){t.getDefaultAlignment=t.getBoundingRect=void 0;var i,o=(i=n(80209))&&i.__esModule?i:{default:i},a=n(35922);t.getDefaultAlignment=function(e){return(null!=e?e:(0,o.default)().rtlEnabled)?"right":"left"};t.getBoundingRect=function(e){return(0,a.isWindow)(e)?{width:e.outerWidth,height:e.outerHeight}:e.getBoundingClientRect()}},9321:function(e,t,n){t.attachInstanceToElement=function(e,t,n){var i=(0,o.data)(e.get(0)),r=d(t.constructor);i[r]=t,n&&a.default.one(e,s.removeEvent,(function(){n.call(t)}));i.dxComponents||(i.dxComponents=[]);i.dxComponents.push(r)},t.getInstanceByElement=function(e,t){var n=d(t);return(0,o.data)(e.get(0),n)},t.name=void 0;var i,o=n(97906),a=(i=n(55994))&&i.__esModule?i:{default:i},r=n(35922),s=n(29007);var l=new WeakMap,u=0,d=function(e,t){if(!(0,r.isDefined)(t)){if(!l.has(e)){var n="dxPrivateComponent"+u++;return l.set(e,n),n}return l.get(e)}l.set(e,t)};t.name=d},59504:function(e,t,n){t.create=r,t.enqueue=void 0;var i,o=(i=n(17381))&&i.__esModule?i:{default:i},a=n(62754);function r(e){var t=[],n=!1;function i(){for(;t.length;){n=!0;var e=t.shift()();if(void 0!==e){if(e.then)return void(0,a.when)(e).always(i);throw o.default.Error("E0015")}}n=!1}return{add:function(o,a){e?(t[0]&&a&&a(t[0]),t=[o]):t.push(o),n||i()},busy:function(){return n}}}var s=r().add;t.enqueue=s},24311:function(e,t,n){t.default=void 0;var i=s(n(73349)),o=s(n(20476)),a=n(58201),r=s(n(39618));function s(e){return e&&e.__esModule?e:{default:e}}var l=[],u=(0,r.default)((function(){var e=i.default.listen(i.default.getDocument(),"DOMContentLoaded",(function(){d.fire(),e()}))})),d={add:function(e){var t=(0,a.hasWindow)();t&&"loading"!==i.default.getReadyState()?e():(l.push(e),t&&u())},fire:function(){l.forEach((function(e){return e()})),l=[]}},c=(0,o.default)(d);t.default=c,e.exports=t.default,e.exports.default=t.default},55814:function(e,t,n){t.default=void 0;var i=n(58201),o=l(n(73349)),a=l(n(44504)),r=l(n(24311)),s=l(n(39618));function l(e){return e&&e.__esModule?e:{default:e}}var u=function(){var e,t=(0,a.default)(),n=t.add,l=t.remove;if(!(0,i.hasWindow)())return t;var u,d=function(){var e=(0,i.getWindow)();return{width:e.innerWidth,height:e.innerHeight}},c=function(){var n,i=d();i.width===e.width&&i.height===e.height||(i.width===e.width&&(n="height"),i.height===e.height&&(n="width"),e=i,t.fire(n))},h=(0,s.default)((function(){e=d()}));return t.add=function(){var e=n.apply(t,arguments);return h(),r.default.add((function(){!u&&t.has()&&(u=o.default.listen((0,i.getWindow)(),"resize",c))})),e},t.remove=function(){var e=l.apply(t,arguments);return!t.has()&&u&&(u(),u=void 0),e},t}();t.default=u,e.exports=t.default,e.exports.default=t.default},49601:function(e,t,n){t.SelectionFilterCreator=void 0;var i=n(20576),o=n(35922);t.SelectionFilterCreator=function(e,t){var n;this.getLocalFilter=function(e,t,n,o){return t=void 0===t?i.equalByValue:t,r.bind(this,t,e,n,o)},this.getExpr=function(n){var i;if(n)return e.forEach((function(e,a){var r;i=i||[],a>0&&i.push(t?"and":"or"),r=(0,o.isString)(n)?s(n,e):function(e,n){for(var i=[],o=0,a=e.length;o<a;o++){var r=e[o],l=n&&n[r],u=s(r,l);if(!u)break;o>0&&i.push(t?"or":"and"),i.push(u)}return i}(n,e),i.push(r)})),i&&1===i.length&&(i=i[0]),i},this.getCombinedFilter=function(e,n){var i=this.getExpr(e),o=i;return t&&n&&(i?((o=[]).push(i),o.push(n)):o=n),o};var a=function(e,t,n){return Array.isArray(n)?e.map((function(e){return t(e)})):e};function r(r,s,l,u,d){var c,h,p=s(d);if(!l&&(c=(0,i.getKeyHash)(p),!(0,o.isObject)(c)))return function(t,o){if(!n){n={};for(var r=a(e,t,o),s=0;s<r.length;s++)n[(0,i.getKeyHash)(r[s])]=!0}return n}(s,u)[c]?!t:!!t;for(h=0;h<e.length;h++)if(r(e[h],p))return!t;return!!t}function s(e,n){if(void 0!==n)return[e,t?"<>":"=",n]}}},58664:function(e,t,n){t.setWidth=t.setOuterWidth=t.setOuterHeight=t.setInnerWidth=t.setInnerHeight=t.setHeight=t.parseHeight=t.implementationsMap=t.getWindowByElement=t.getWidth=t.getVisibleHeight=t.getVerticalOffsets=t.getSize=t.getOuterWidth=t.getOuterHeight=t.getOffset=t.getInnerWidth=t.getInnerHeight=t.getHeight=t.getElementBoxParams=t.addOffsetToMinHeight=t.addOffsetToMaxHeight=void 0;var i,o=n(58201),a=(i=n(73349))&&i.__esModule?i:{default:i},r=n(35922);var s=(0,o.getWindow)(),l=["auto","none","inherit","initial"],u=function(e,t){var n=0;return t.forEach((function(t){n+=parseFloat(e[t])||0})),n},d=function(e,t){var n="width"===e?"Left":"Top",i="width"===e?"Right":"Bottom";return{padding:u(t,["padding"+n,"padding"+i]),border:u(t,["border"+n+"Width","border"+i+"Width"]),margin:u(t,["margin"+n,"margin"+i])}};t.getElementBoxParams=d;var c=function(e){var t,n=(null==e||null===(t=e.ownerDocument)||void 0===t?void 0:t.defaultView)||s;return n.getComputedStyle&&n.getComputedStyle(e)},h=function(e,t,n,i){var o;return(null==t?void 0:t[n])||(null===(o=e.style)||void 0===o?void 0:o[n])||i},p={content:0,padding:1,border:2,margin:3,"content-box":0,"border-box":2},f={width:["left","right"],height:["top","bottom"]};function g(e,t,n,i){var o=function(e,t,n){return parseFloat(h(e,t,n,"0"))||0},a="border"===n?"-width":"";return o(e,i,"".concat(n,"-").concat(f[t][0]).concat(a))+o(e,i,"".concat(n,"-").concat(f[t][1]).concat(a))}var m=function(e,t,n){var i="width"===t?"offsetWidth":"offsetHeight",o=c(e),a=h(e,o,t);""!==a&&"auto"!==a||(a=e[i]),a=parseFloat(a)||0;var r=h(e,o,"boxSizing","content-box"),s=p[n||r],l=p[r];if(void 0===s||void 0===l)throw new Error;if(l===s)return a;var u=Math.sign(s-l),d=!1,f=!1,m=!1,_=!1;1===u&&(s+=1,l+=1);for(var v=l;v!==s;v+=u)switch(v){case p.content:break;case p.padding:d=u*g(e,t,"padding",o);break;case p.border:f=u*g(e,t,"border",o);break;case p.margin:m=u*g(e,t,"margin",o)}if(d||f){var y=(!1===d?u*g(e,t,"padding",o):d)+(!1===f?u*g(e,t,"border",o):f);_=u*Math.max(0,Math.floor(e[i]-a-u*y))||0}return a+m+d+f+_};t.getSize=m;var _=function(e,t){return e.indexOf("px")>0?e=parseInt(e.replace("px","")):e.indexOf("%")>0?e=parseInt(e.replace("%",""))*function(e){return(0,r.isWindow)(e)?e.innerHeight:e.offsetHeight}(t)/100:isNaN(e)?e.indexOf("vh")>0&&(e=s.innerHeight/100*parseInt(e.replace("vh",""))):e=parseInt(e),e};t.parseHeight=_;var v=function(e,t,n){return e?l.indexOf(e)>-1?t?null:e:((0,r.isString)(e)&&(e=_(e,n)),(0,r.isNumeric)(e)?Math.max(0,e+t):"calc("+e+(t<0?" - ":" ")+Math.abs(t)+"px)"):null};t.addOffsetToMaxHeight=function(e,t,n){var i=v(e,t,n);return null!==i?i:"none"};t.addOffsetToMinHeight=function(e,t,n){var i=v(e,t,n);return null!==i?i:0};t.getVerticalOffsets=function(e,t){if(!e)return 0;var n=d("height",s.getComputedStyle(e));return n.padding+n.border+(t?n.margin:0)};t.getVisibleHeight=function(e){if(e){var t=e.getBoundingClientRect();if(t.height)return t.height}return 0};var y={getWidth:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["width"].concat(t))},setWidth:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["width"].concat(t))},getHeight:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["height"].concat(t))},setHeight:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["height"].concat(t))},getOuterWidth:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["outerWidth"].concat(t))},setOuterWidth:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["outerWidth"].concat(t))},getOuterHeight:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["outerHeight"].concat(t))},setOuterHeight:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["outerHeight"].concat(t))},getInnerWidth:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["innerWidth"].concat(t))},setInnerWidth:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["innerWidth"].concat(t))},getInnerHeight:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["innerHeight"].concat(t))},setInnerHeight:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["innerHeight"].concat(t))}};function b(e,t,n){return 2===arguments.length?x(t,e):x(t,e,n)}t.implementationsMap=y;t.getWidth=function(e){return y.getWidth(e)};t.setWidth=function(e,t){return y.setWidth(e,t)};t.getHeight=function(e){return y.getHeight(e)};t.setHeight=function(e,t){return y.setHeight(e,t)};t.getOuterWidth=function(e,t){return y.getOuterWidth(e,t||!1)};t.setOuterWidth=function(e,t){return y.setOuterWidth(e,t)};t.getOuterHeight=function(e,t){return y.getOuterHeight(e,t||!1)};t.setOuterHeight=function(e,t){return y.setOuterHeight(e,t)};t.getInnerWidth=function(e){return y.getInnerWidth(e)};t.setInnerWidth=function(e,t){return y.setInnerWidth(e,t)};t.getInnerHeight=function(e){return y.getInnerHeight(e)};t.setInnerHeight=function(e,t){return y.setInnerHeight(e,t)};var x=function e(t,n,i){var o=n.toLowerCase().indexOf("width")>=0?"Width":"Height",s=o.toLowerCase(),l=0===n.indexOf("outer"),u=0===n.indexOf("inner"),h=2===arguments.length||"boolean"==typeof i;if((0,r.isRenderer)(t)){if(t.length>1&&!h){for(var p=0;p<t.length;p++)e(t[p],n,i);return}t=t[0]}if(t){if((0,r.isWindow)(t))return l?t["inner"+o]:a.default.getDocumentElement()["client"+o];if(a.default.isDocument(t)){var f=a.default.getDocumentElement(),g=a.default.getBody();return Math.max(g["scroll"+o],g["offset"+o],f["scroll"+o],f["offset"+o],f["client"+o])}if(h){var _="content";return l&&(_=i?"margin":"border"),u&&(_="padding"),m(t,s,_)}if((0,r.isNumeric)(i)){var v=c(t),y=d(s,v),b="border-box"===v.boxSizing;i=Number(i),l?i-=b?0:y.border+y.padding:u?i+=b?y.border:-y.padding:b&&(i+=y.border+y.padding)}return i+=(0,r.isNumeric)(i)?"px":"",a.default.setStyle(t,s,i),null}},w=function(e){return(0,r.isWindow)(e)?e:e.defaultView};t.getWindowByElement=w;t.getOffset=function(e){if(!e.getClientRects().length)return{top:0,left:0};var t=e.getBoundingClientRect(),n=w(e.ownerDocument),i=e.ownerDocument.documentElement;return{top:t.top+n.pageYOffset-i.clientTop,left:t.left+n.pageXOffset-i.clientLeft}}},36613:function(e,t,n){t.sessionStorage=void 0;var i=(0,n(58201).getWindow)();t.sessionStorage=function(){var e;try{e=i.sessionStorage}catch(e){}return e}},68752:function(e,t,n){t.encodeHtml=void 0,t.format=function(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),o=1;o<t;o++)n[o-1]=arguments[o];if((0,i.isFunction)(e))return e.apply(void 0,n);return n.forEach((function(t,n){(0,i.isString)(t)&&(t=t.replace(/\$/g,"$$$$"));var o=new RegExp("\\{"+n+"\\}","gm");e=e.replace(o,t)})),e},t.replaceAll=t.quadToObject=t.isEmpty=void 0;var i=n(35922);function o(e){return(o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var a,r=(a=[new RegExp("&","g"),new RegExp('"',"g"),new RegExp("'","g"),new RegExp("<","g"),new RegExp(">","g")],function(e){return String(e).replace(a[0],"&amp;").replace(a[1],"&quot;").replace(a[2],"&#39;").replace(a[3],"&lt;").replace(a[4],"&gt;")});t.encodeHtml=r;t.quadToObject=function(e){var t=function(e){switch(o(e)){case"string":return e.split(/\s+/,4);case"object":return[e.x||e.h||e.left,e.y||e.v||e.top,e.x||e.h||e.right,e.y||e.v||e.bottom];case"number":return[e];default:return e}}(e),n=parseInt(t&&t[0],10),i=parseInt(t&&t[1],10),a=parseInt(t&&t[2],10),r=parseInt(t&&t[3],10);return isFinite(n)||(n=0),isFinite(i)||(i=n),isFinite(a)||(a=n),isFinite(r)||(r=i),{top:i,right:a,bottom:r,left:n}};var s=function(e,t,n){return e.replace(new RegExp("("+(t+"").replace(/([+*?.[^\]$(){}><|=!:])/g,"\\$1")+")","gi"),n)};t.replaceAll=s;var l,u=(l=/\s/g,function(e){return!e||!e.replace(l,"")});t.isEmpty=u},2146:function(e,t){t.stubComponent=function(e){return function(){function t(){throw new Error("Module '".concat(e,"' not found"))}return t.getInstance=function(){},t}()}},80968:function(e,t,n){t.stylePropPrefix=t.styleProp=t.setWidth=t.setHeight=t.parsePixelValue=t.normalizeStyleProp=void 0;var i=n(78008),o=s(n(39618)),a=n(35922),r=s(n(73349));function s(e){return e&&e.__esModule?e:{default:e}}var l=["","Webkit","Moz","O","Ms"],u={"":"",Webkit:"-webkit-",Moz:"-moz-",O:"-o-",ms:"-ms-"},d=(0,o.default)((function(){return r.default.createElement("dx").style}));t.styleProp=function(e){if(e in d())return e;var t=e;e=e.charAt(0).toUpperCase()+e.substr(1);for(var n=1;n<l.length;n++){var i=l[n].toLowerCase()+e;if(i in d())return i}return t};t.stylePropPrefix=function(e){return function(e,t){var n;e=(0,i.camelize)(e,!0);for(var o=0,a=l.length;o<a;o++){var r=l[o],s=r+e;if(void 0===(n=t((0,i.camelize)(s),r))&&(n=t(s,r)),void 0!==n)break}return n||""}(e,(function(e,t){if(e in d())return u[t]}))};var c=["fillOpacity","columnCount","flexGrow","flexShrink","fontWeight","lineHeight","opacity","zIndex","zoom"];t.parsePixelValue=function(e){return(0,a.isNumeric)(e)?e:(0,a.isString)(e)?Number(e.replace("px","")):NaN};t.normalizeStyleProp=function(e,t){return(0,a.isNumeric)(t)&&-1===c.indexOf(e)&&(t+="px"),t};var h=function(e,t,n){if(e){n=(0,a.isNumeric)(n)?n+="px":n;for(var i=0;i<e.length;++i)e[i].style[t]=n}};t.setWidth=function(e,t){h(e,"width",t)};t.setHeight=function(e,t){h(e,"height",t)}},60137:function(e,t,n){t.pointerEvents=t.nativeScrolling=t.inputType=t.animation=void 0,Object.defineProperty(t,"styleProp",{enumerable:!0,get:function(){return s.styleProp}}),Object.defineProperty(t,"stylePropPrefix",{enumerable:!0,get:function(){return s.stylePropPrefix}}),t.transitionEndEventName=t.transition=t.touchEvents=t.touch=t.supportProp=void 0;var i=l(n(73349)),o=l(n(39618)),a=n(58201),r=l(n(20530)),s=n(80968);function l(e){return e&&e.__esModule?e:{default:e}}var u=(0,a.getNavigator)().maxTouchPoints,d={webkitTransition:"webkitTransitionEnd",MozTransition:"transitionend",OTransition:"oTransitionEnd",transition:"transitionend"},c=function(e){return!!(0,s.styleProp)(e)};t.supportProp=c;t.inputType=function(e){if("text"===e)return!0;var t=i.default.createElement("input");try{return t.setAttribute("type",e),t.value="wrongValue",!t.value}catch(e){return!1}};var h=function(e,t){return(e("ontouchstart")||!!t)&&!e("callPhantom")}(a.hasProperty,u);t.touchEvents=h;var p=(0,a.hasProperty)("PointerEvent");t.pointerEvents=p;var f=h||p&&!!u;t.touch=f;var g=(0,o.default)((function(){return c("transition")}));t.transition=g;var m=(0,o.default)((function(){return d[(0,s.styleProp)("transition")]}));t.transitionEndEventName=m;var _=(0,o.default)((function(){return c("animation")}));t.animation=_;var v,y,b,x=(v=r.default.real(),y=v.platform,b=v.mac,"ios"===y||"android"===y||b);t.nativeScrolling=x},19155:function(e,t,n){t.HIDDEN_FOR_EXPORT=void 0,t.getSvgElement=function(e){return i.default.isNode(e)?e:(new s.DOMParser).parseFromString(e,"image/svg+xml").childNodes[0]},t.getSvgMarkup=function(e,t){return function(e){var t=!0;-1===e.indexOf("xmlns:xlink")&&(e=e.replace("<svg",'<svg xmlns:xlink="http://www.w3.org/1999/xlink"'));return(e=e.replace(/xmlns="[\s\S]*?"/gi,(function(e){return t?(t=!1,e):""}))).replace(/xmlns:NS1="[\s\S]*?"/gi,"").replace(/NS1:xmlns:xlink="([\s\S]*?)"/gi,'xmlns:xlink="$1"')}((n=function(e,t){var n=i.default.createElement("div"),o=e.cloneNode(!0);return t&&(0,a.default)(o).css("backgroundColor",t),n.appendChild(o),n.innerHTML}(e,t),n.replace(/&quot;/gi,"&#34;").replace(/&amp;/gi,"&#38;").replace(/&apos;/gi,"&#39;").replace(/&lt;/gi,"&#60;").replace(/&gt;/gi,"&#62;").replace(/&nbsp;/gi,"&#160;").replace(/&shy;/gi,"&#173;")));var n};var i=r(n(73349)),o=n(58201),a=r(n(68374));function r(e){return e&&e.__esModule?e:{default:e}}var s=(0,o.getWindow)();t.HIDDEN_FOR_EXPORT="hidden-for-export"},69697:function(e,t,n){t.validateTemplateSource=t.templateKey=t.suitableTemplatesByName=t.getNormalizedTemplateArgs=t.findTemplates=t.defaultCreateElement=t.addOneRenderedCall=t.acquireTemplate=t.acquireIntegrationTemplate=void 0;var i=m(n(80209)),o=m(n(20530)),a=m(n(17381)),r=m(n(68374)),s=n(91627),l=n(10688),u=n(9545),d=n(81033),c=n(89386),h=n(20576),p=n(3532),f=n(13306),g=n(35922);function m(e){return e&&e.__esModule?e:{default:e}}t.findTemplates=function(e,t){var n=(0,r.default)(e).contents().filter("[".concat("data-options",'*="').concat(t,'"]'));return[].slice.call(n).map((function(e){var n=(0,r.default)(e).attr("data-options")||"";return{element:e,options:(0,i.default)().optionsParser(n)[t]}})).filter((function(e){return!!e.options}))};t.suitableTemplatesByName=function(e){var t=(0,c.groupBy)(e,(function(e){return e.options.name}));if(t[void 0])throw a.default.Error("E0023");var n={};return Object.keys(t).forEach((function(e){var i,a=null===(i=(0,h.findBestMatches)(o.default.current(),t[e],(function(e){return e.options}))[0])||void 0===i?void 0:i.element;a&&(n[e]=a)})),n};var _=function(e){var t=e.render.bind(e);return(0,f.extend)({},e,{render:function(e){var n=t(e);return e&&e.onRendered&&e.onRendered(),n}})};t.addOneRenderedCall=_;t.getNormalizedTemplateArgs=function(e){var t=[];return"model"in e&&t.push(e.model),"index"in e&&t.push(e.index),t.push(e.container),t};t.validateTemplateSource=function(e){return"string"==typeof e?(0,p.normalizeTemplateElement)(e):e};t.templateKey=function(e){return(0,g.isRenderer)(e)&&e[0]||e};t.defaultCreateElement=function(e){return new u.Template(e)};var v=function(e,t,n,i){var o=null;return i&&-1!==i.indexOf(e)||!(o=t[e])||o instanceof d.TemplateBase||n||(o=_(o)),o};t.acquireIntegrationTemplate=v;t.acquireTemplate=function(e,t,n,i,o,a){return null==e?new l.EmptyTemplate:e instanceof s.ChildDefaultTemplate?a[e.name]:e instanceof d.TemplateBase?e:(0,g.isFunction)(e.render)&&!(0,g.isRenderer)(e)?i?e:_(e):e.nodeType||(0,g.isRenderer)(e)?t((0,r.default)(e)):v(e,n,i,o)||a[e]||t(e)}},35922:function(e,t){function n(e){return(n="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}t.type=t.isWindow=t.isString=t.isRenderer=t.isPromise=t.isPrimitive=t.isPlainObject=t.isObject=t.isNumeric=t.isFunction=t.isExponential=t.isEvent=t.isEmptyObject=t.isDefined=t.isDeferred=t.isDate=t.isBoolean=void 0;var i={"[object Array]":"array","[object Date]":"date","[object Object]":"object","[object String]":"string","[object Null]":"null"},o=function(e){var t=Object.prototype.toString.call(e);return"object"===n(e)?i[t]||"object":n(e)};t.type=o;t.isBoolean=function(e){return"boolean"==typeof e};t.isExponential=function(e){return r(e)&&-1!==e.toString().indexOf("e")};t.isDate=function(e){return"date"===o(e)};t.isDefined=function(e){return null!=e};var a=function(e){return"function"==typeof e};t.isFunction=a;t.isString=function(e){return"string"==typeof e};var r=function(e){return"number"==typeof e&&isFinite(e)||!isNaN(e-parseFloat(e))};t.isNumeric=r;t.isObject=function(e){return"object"===o(e)};t.isEmptyObject=function(e){var t;for(t in e)return!1;return!0};t.isPlainObject=function(e){if(!e||"[object Object]"!==Object.prototype.toString.call(e))return!1;var t=Object.getPrototypeOf(e),n=Object.hasOwnProperty.call(t,"constructor")&&t.constructor;return"function"==typeof n&&Object.toString.call(n)===Object.toString.call(Object)};t.isPrimitive=function(e){return-1===["object","array","function"].indexOf(o(e))};t.isWindow=function(e){return null!=e&&e===e.window};t.isRenderer=function(e){return!(!e||!e.jquery&&!e.dxRenderer)};t.isPromise=function(e){return!!e&&a(e.then)};t.isDeferred=function(e){return!!e&&a(e.done)&&a(e.fail)};t.isEvent=function(e){return!(!e||!e.preventDefault)}},26974:function(e,t,n){t.default=void 0;var i,o=n(30869);var a=(0,((i=n(20476))&&i.__esModule?i:{default:i}).default)({isWrapped:function(){return!1},isWritableWrapped:function(){return!1},wrap:function(e){return e},unwrap:function(e){return e},assign:function(){o.logger.error("Method 'assign' should not be used for not wrapped variables. Use 'isWrapped' method for ensuring.")}});t.default=a,e.exports=t.default,e.exports.default=t.default},58020:function(e,t){t.compare=function(e,t,n){function i(e){return"string"==typeof e?e.split("."):"number"==typeof e?[e]:e}e=i(e),t=i(t);var o=Math.max(e.length,t.length);isFinite(n)&&(o=Math.min(o,n));for(var a=0;a<o;a++){var r=parseInt(e[a]||0,10),s=parseInt(t[a]||0,10);if(r<s)return-1;if(r>s)return 1}return 0}},77695:function(e,t,n){t.changeCallback=void 0,t.originalViewPort=function(){return d},t.value=void 0;var i=r(n(68374)),o=r(n(24311)),a=r(n(44504));function r(e){return e&&e.__esModule?e:{default:e}}var s=o.default.add,l=(0,a.default)();t.changeCallback=l;var u,d=(0,i.default)(),c=function(e){if(!arguments.length)return u;var t=(0,i.default)(e);d=t;var n=!!t.length,o=c();u=n?t:(0,i.default)("body"),l.fire(n?c():(0,i.default)(),o)};t.value=c,s((function(){c(".dx-viewport")}))},58201:function(e,t,n){t.setWindow=t.hasWindow=t.hasProperty=t.getWindow=t.getNavigator=t.getCurrentScreenFactor=t.defaultScreenFactorFunc=void 0;var i,o=(i=n(73349))&&i.__esModule?i:{default:i};var a="undefined"!=typeof window,r=function(){return a};t.hasWindow=r;var s=r()?window:void 0;s||((s={}).window=s);t.getWindow=function(){return s};t.setWindow=function(e,t){a=void 0===t?"undefined"!=typeof window&&window===e:t,s=e};t.hasProperty=function(e){return r()&&e in s};var l=function(e){return e<768?"xs":e<992?"sm":e<1200?"md":"lg"};t.defaultScreenFactorFunc=l;t.getCurrentScreenFactor=function(e){return(e||l)(o.default.getDocumentElement().clientWidth)};t.getNavigator=function(){return r()?s.navigator:{userAgent:""}}},36739:function(e,t){t.version=void 0;t.version="22.1.4"},67403:function(e,t,n){t.default=void 0;var i=h(n(38377)),o=n(80566),a=n(95479),r=n(18438),s=n(16454),l=n(47617),u=h(n(99236)),d=n(62754),c=n(20576);function h(e){return e&&e.__esModule?e:{default:e}}function p(e){return function(e){if(Array.isArray(e))return f(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return f(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return f(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function f(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}var g,m=i.default.abstract,_=u.default.queryByOptions,v={},y=i.default.inherit({ctor:function(e){var t=this;e=e||{},this._eventsStrategy=new o.EventsStrategy(this),(0,a.each)(["onLoaded","onLoading","onInserted","onInserting","onUpdated","onUpdating","onPush","onRemoved","onRemoving","onModified","onModifying"],(function(n,i){i in e&&t.on(i.slice(2).toLowerCase(),e[i])})),this._key=e.key,this._errorHandler=e.errorHandler,this._useDefaultSearch=!0},_customLoadOptions:function(){return null},key:function(){return this._key},keyOf:function(e){return this._keyGetter||(this._keyGetter=(0,l.compileGetter)(this.key())),this._keyGetter(e)},_requireKey:function(){if(!this.key())throw r.errors.Error("E4005")},load:function(e){var t=this;return e=e||{},this._eventsStrategy.fireEvent("loading",[e]),this._withLock(this._loadImpl(e)).done((function(n){t._eventsStrategy.fireEvent("loaded",[n,e])}))},_loadImpl:function(e){return _(this.createQuery(e),e).enumerate()},_withLock:function(e){var t=new d.Deferred;return e.done((function(){var e=this,n=arguments;s.processRequestResultLock.promise().done((function(){t.resolveWith(e,n)}))})).fail((function(){t.rejectWith(this,arguments)})),t},createQuery:m,totalCount:function(e){return this._totalCountImpl(e)},_totalCountImpl:function(e){return _(this.createQuery(e),e,!0).count()},byKey:function(e,t){return this._addFailHandlers(this._withLock(this._byKeyImpl(e,t)))},_byKeyImpl:m,insert:function(e){var t=this;return t._eventsStrategy.fireEvent("modifying"),t._eventsStrategy.fireEvent("inserting",[e]),t._addFailHandlers(t._insertImpl(e).done((function(e,n){t._eventsStrategy.fireEvent("inserted",[e,n]),t._eventsStrategy.fireEvent("modified")})))},_insertImpl:m,update:function(e,t){var n=this;return n._eventsStrategy.fireEvent("modifying"),n._eventsStrategy.fireEvent("updating",[e,t]),n._addFailHandlers(n._updateImpl(e,t).done((function(){n._eventsStrategy.fireEvent("updated",[e,t]),n._eventsStrategy.fireEvent("modified")})))},_updateImpl:m,push:function(e){var t=this,n={changes:e,waitFor:[]};this._eventsStrategy.fireEvent("beforePush",[n]),d.when.apply(void 0,p(n.waitFor)).done((function(){t._pushImpl(e),t._eventsStrategy.fireEvent("push",[e])}))},_pushImpl:c.noop,remove:function(e){var t=this;return t._eventsStrategy.fireEvent("modifying"),t._eventsStrategy.fireEvent("removing",[e]),t._addFailHandlers(t._removeImpl(e).done((function(e){t._eventsStrategy.fireEvent("removed",[e]),t._eventsStrategy.fireEvent("modified")})))},_removeImpl:m,_addFailHandlers:function(e){return e.fail(this._errorHandler).fail(r.handleError)},on:function(e,t){return this._eventsStrategy.on(e,t),this},off:function(e,t){return this._eventsStrategy.off(e,t),this}});y.create=function(e,t){if(!(e in v))throw r.errors.Error("E4020",e);return new v[e](t)},y.registerClass=function(e,t){return t&&(v[t]=e),e},y.inherit=(g=y.inherit,function(e,t){var n=g.apply(this,[e]);return y.registerClass(n,t),n});var b=y;t.default=b,e.exports=t.default,e.exports.default=t.default},36893:function(e,t,n){t.default=void 0;var i=n(60637).applyChanges;t.default=i,e.exports=t.default,e.exports.default=t.default},35042:function(e,t,n){t.default=void 0;var i,o=(i=n(38377))&&i.__esModule?i:{default:i},a=n(35922),r=n(95479),s=n(47617),l=n(62754),u=n(18438),d=n(16454);var c=o.default.inherit({toArray:function(){var e=[];for(this.reset();this.next();)e.push(this.current());return e},countable:function(){return!1}}),h=c.inherit({ctor:function(e){this.array=e,this.index=-1},next:function(){return this.index+1<this.array.length&&(this.index++,!0)},current:function(){return this.array[this.index]},reset:function(){this.index=-1},toArray:function(){return this.array.slice(0)},countable:function(){return!0},count:function(){return this.array.length}}),p=c.inherit({ctor:function(e){this.iter=e},next:function(){return this.iter.next()},current:function(){return this.iter.current()},reset:function(){return this.iter.reset()}}),f=p.inherit({ctor:function(e,t){this.callBase(e),this.index=-1,this.mapper=t},current:function(){return this.mapper(this.callBase(),this.index)},next:function(){var e=this.callBase();return e&&this.index++,e}}),g=function(e,t){return e=(0,s.toComparable)(e),t=(0,s.toComparable)(t),null===e&&null!==t?-1:null!==e&&null===t||void 0===e&&void 0!==t?1:void 0!==e&&void 0===t||e<t?-1:e>t?1:0},m=c.inherit({ctor:function(e,t,n,i){e instanceof f||(e=new f(e,this._wrap)),this.iter=e,this.rules=[{getter:t,desc:n,compare:i}]},thenBy:function(e,t,n){var i=new m(this.sortedIter||this.iter,e,t,n);return this.sortedIter||(i.rules=this.rules.concat(i.rules)),i},next:function(){return this._ensureSorted(),this.sortedIter.next()},current:function(){return this._ensureSorted(),this.sortedIter.current()},reset:function(){delete this.sortedIter},countable:function(){return this.sortedIter||this.iter.countable()},count:function(){return this.sortedIter?this.sortedIter.count():this.iter.count()},_ensureSorted:function(){var e=this;e.sortedIter||((0,r.each)(e.rules,(function(){this.getter=(0,s.compileGetter)(this.getter)})),e.sortedIter=new f(new h(this.iter.toArray().sort((function(t,n){return e._compare(t,n)}))),e._unwrap))},_wrap:function(e,t){return{index:t,value:e}},_unwrap:function(e){return e.value},_compare:function(e,t){var n=e.index,i=t.index;if((e=e.value)===(t=t.value))return n-i;for(var o=0,a=this.rules.length;o<a;o++){var r=this.rules[o],s=r.getter(e),l=r.getter(t),u=(r.compare||g)(s,l);if(u)return r.desc?-u:u}return n-i}}),_=function(){var e=function(e){return(0,a.isDefined)(e)?e.toString():""};function t(e,t,n){return function(i){i=(0,s.toComparable)(e(i));var o=function(e){return""===e||0===e||!1===e}(t)?i===t:i==t;return n&&(o=!o),o}}return function(n){return(0,a.isFunction)(n)?n:(0,d.isGroupCriterion)(n)?function(e){var t=[],n=!1,i=!1;return(0,r.each)(e,(function(){if(Array.isArray(this)||(0,a.isFunction)(this)){if(t.length>1&&n!==i)throw new u.errors.Error("E4019");t.push(_(this)),n=i,i=!0}else i=(0,d.isConjunctiveOperator)(this)})),function(e){for(var i=n,o=0;o<t.length;o++)if(t[o](e)!==n){i=!n;break}return i}}(n):(0,d.isUnaryOperation)(n)?function(e){var t=e[0],n=_(e[1]);if("!"===t)return function(e){return!n(e)};throw u.errors.Error("E4003",t)}(n):function(n){n=(0,d.normalizeBinaryCriterion)(n);var i=(0,s.compileGetter)(n[0]),o=n[1],a=n[2];a=(0,s.toComparable)(a);var r=function(e,t){return e=(0,s.toComparable)(i(e)),(![a,e].includes(null)||a===e)&&t(e,a)};switch(o.toLowerCase()){case"=":return t(i,a);case"<>":return t(i,a,!0);case">":return function(e){return r(e,(function(e,t){return e>t}))};case"<":return function(e){return r(e,(function(e,t){return e<t}))};case">=":return function(e){return r(e,(function(e,t){return e>=t}))};case"<=":return function(e){return r(e,(function(e,t){return e<=t}))};case"startswith":return function(t){return 0===(0,s.toComparable)(e(i(t))).indexOf(a)};case"endswith":return function(t){var n=(0,s.toComparable)(e(i(t))),o=e(a);if(n.length<o.length)return!1;var r=n.lastIndexOf(a);return-1!==r&&r===n.length-a.length};case"contains":return function(t){return(0,s.toComparable)(e(i(t))).indexOf(a)>-1};case"notcontains":return function(t){return-1===(0,s.toComparable)(e(i(t))).indexOf(a)}}throw u.errors.Error("E4003",o)}(n)}}(),v=p.inherit({ctor:function(e,t){this.callBase(e),this.criteria=_(t)},next:function(){for(;this.iter.next();)if(this.criteria(this.current()))return!0;return!1}}),y=c.inherit({ctor:function(e,t){this.iter=e,this.getter=t},next:function(){return this._ensureGrouped(),this.groupedIter.next()},current:function(){return this._ensureGrouped(),this.groupedIter.current()},reset:function(){delete this.groupedIter},countable:function(){return!!this.groupedIter},count:function(){return this.groupedIter.count()},_ensureGrouped:function(){if(!this.groupedIter){var e={},t=[],n=this.iter,i=(0,s.compileGetter)(this.getter);for(n.reset();n.next();){var o=n.current(),a=i(o);a in e?e[a].push(o):(e[a]=[o],t.push(a))}this.groupedIter=new h((0,r.map)(t,(function(t){return{key:t,items:e[t]}})))}}}),b=p.inherit({ctor:function(e,t){this.callBase(e),this.getter=(0,s.compileGetter)(t)},current:function(){return this.getter(this.callBase())},countable:function(){return this.iter.countable()},count:function(){return this.iter.count()}}),x=p.inherit({ctor:function(e,t,n){this.callBase(e),this.skip=Math.max(0,t),this.take=Math.max(0,n),this.pos=0},next:function(){if(this.pos>=this.skip+this.take)return!1;for(;this.pos<this.skip&&this.iter.next();)this.pos++;return this.pos++,this.iter.next()},reset:function(){this.callBase(),this.pos=0},countable:function(){return this.iter.countable()},count:function(){return Math.min(this.iter.count()-this.skip,this.take)}}),w=function e(t,n){n=n||{},t instanceof c||(t=new h(t));var i=function(e){var t=n.errorHandler;t&&t(e),(0,u.handleError)(e)},o=function(e){var n=(new l.Deferred).fail(i),o=e.step,a=e.finalize;try{t.reset();for(var r=("seed"in e?e.seed:t.next()?t.current():NaN);t.next();)r=o(r,t.current());n.resolve(a?a(r):r)}catch(e){n.reject(e)}return n.promise()},r=function(e){return o(d.aggregators[e])},p=function(e){return(0,a.isFunction)(e)||Array.isArray(e)||(e=[].slice.call(arguments)),g(new b(t,e))},f=function(e){return p((0,s.compileGetter)(e))};function g(t){return e(t,n)}return{toArray:function(){return t.toArray()},enumerate:function(){var e=(new l.Deferred).fail(i);try{e.resolve(t.toArray())}catch(t){e.reject(t)}return e.promise()},sortBy:function(e,n,i){return g(new m(t,e,n,i))},thenBy:function(e,n,i){if(t instanceof m)return g(t.thenBy(e,n,i));throw u.errors.Error("E4004")},filter:function(e){return Array.isArray(e)||(e=[].slice.call(arguments)),g(new v(t,e))},slice:function(e,n){return void 0===n&&(n=Number.MAX_VALUE),g(new x(t,e,n))},select:p,groupBy:function(e){return g(new y(t,e))},aggregate:function(e,t,n){return o(arguments.length<2?{step:arguments[0]}:{seed:e,step:t,finalize:n})},count:function(){if(t.countable()){var e=(new l.Deferred).fail(i);try{e.resolve(t.count())}catch(t){e.reject(t)}return e.promise()}return r("count")},sum:function(e){return e?f(e).sum():r("sum")},min:function(e){return e?f(e).min():r("min")},max:function(e){return e?f(e).max():r("max")},avg:function(e){return e?f(e).avg():r("avg")}}};t.default=w,e.exports=t.default,e.exports.default=t.default},26562:function(e,t,n){t.default=void 0;var i=n(16454),o=l(n(96687)),a=n(18438),r=l(n(67403)),s=n(60637);function l(e){return e&&e.__esModule?e:{default:e}}var u=r.default.inherit({ctor:function(e){e=Array.isArray(e)?{data:e}:e||{},this.callBase(e);var t=e.data;if(t&&!Array.isArray(t))throw a.errors.Error("E4006");this._array=t||[]},createQuery:function(){return(0,o.default)(this._array,{errorHandler:this._errorHandler})},_byKeyImpl:function(e){var t=(0,s.indexByKey)(this,this._array,e);return-1===t?(0,i.rejectedPromise)(a.errors.Error("E4009")):(0,i.trivialPromise)(this._array[t])},_insertImpl:function(e){return(0,s.insert)(this,this._array,e)},_pushImpl:function(e){(0,s.applyBatch)({keyInfo:this,data:this._array,changes:e})},_updateImpl:function(e,t){return(0,s.update)(this,this._array,e,t)},_removeImpl:function(e){return(0,s.remove)(this,this._array,e)},clear:function(){this._eventsStrategy.fireEvent("modifying"),this._array=[],this._eventsStrategy.fireEvent("modified")}},"array");t.default=u,e.exports=t.default,e.exports.default=t.default},60637:function(e,t,n){t.applyBatch=v,t.applyChanges=function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},i=n.keyExpr,o=void 0===i?"id":i,a=n.immutable,r=void 0===a||a,s=(0,u.compileGetter)(o),l={key:function(){return o},keyOf:function(e){return s(e)}};return v({keyInfo:l,data:e,changes:t,immutable:r,disableCache:!0,logError:!0})},t.createObjectWithChanges=_,t.indexByKey=C,t.insert=x,t.remove=w,t.update=b;var i=n(35922),o=c(n(80209)),a=c(n(73176)),r=n(13306),s=n(18438),l=n(48013),u=n(47617),d=n(16454);function c(e){return e&&e.__esModule?e:{default:e}}function h(e){return(h="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function p(e){return function(e){if(Array.isArray(e))return f(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return f(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return f(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function f(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}function g(e,t,n,i){return i?function e(t,n,i,o){var a;if(o){for(var r=0;r<n.length;r++)if(a=e(t,n[r].items||n[r].collapsedItems||[]||[],i,o-1))return a}else if(C(t,n,i)>=0)return n}(e,t,n,i)||[]:t}function m(e,t,n){e._dataByKeyMap&&(e._dataByKeyMap[JSON.stringify(t)]=n,e._dataByKeyMapLength+=n?1:-1)}function _(e,t){var n=function e(t,n){n=n||new WeakMap;var o=t?Object.create(Object.getPrototypeOf(t)):{};t&&n.set(t,o);var a=(0,r.extendFromObject)({},t);for(var s in a){var u=a[s];!(0,i.isObject)(u)||(0,i.isPlainObject)(u)||n.has(u)||(a[s]=e(u,n))}for(var d in(0,l.deepExtendArraySafe)(o,a,!0,!0),o){var c=o[d];(0,i.isObject)(c)&&n.has(c)&&(o[d]=n.get(c))}return o}(e);return(0,l.deepExtendArraySafe)(n,t,!0,!0)}function v(e){var t=e.keyInfo,n=e.data,o=e.changes,a=e.groupCount,r=e.useInsertIndex,s=e.immutable,l=e.disableCache,u=e.logError,d=!0===s?p(n):n;return o.forEach((function(e){var n="insert"===e.type?d:g(t,d,e.key,a);switch(!l&&function(e,t){if(e.key()&&(!t._dataByKeyMap||t._dataByKeyMapLength!==t.length)){for(var n={},i=t.length,o=0;o<i;o++)n[JSON.stringify(e.keyOf(t[o]))]=t[o];t._dataByKeyMap=n,t._dataByKeyMapLength=i}}(t,n),e.type){case"update":b(t,n,e.key,e.data,!0,s,u);break;case"insert":x(t,n,e.data,r&&(0,i.isDefined)(e.index)?e.index:-1,!0,u);break;case"remove":w(t,n,e.key,!0,u)}})),d}function y(e,t,n){return e?t&&s.errors.log(n):(0,d.rejectedPromise)(s.errors.Error(n))}function b(e,t,n,a,r,s,u){var c,h=e.key();if(h){if(function(e,t){for(var n="string"==typeof t?t.split():t.slice();n.length;)if(n.shift()in e)return!0;return!1}(a,h)&&!(0,d.keysEqual)(h,n,e.keyOf(a)))return y(r,u,"E4017");if(!(c=function(e,t){if(e._dataByKeyMap)return e._dataByKeyMap[JSON.stringify(t)]}(t,n))){var p=C(e,t,n);if(p<0)return y(r,u,"E4009");if(c=t[p],!0===s&&(0,i.isDefined)(c)){var f=_(c,a);return t[p]=f,!r&&(0,d.trivialPromise)(f,n)}}}else c=n;if((0,l.deepExtendArraySafe)(c,a,!0),!r)return(0,o.default)().useLegacyStoreResult?(0,d.trivialPromise)(n,a):(0,d.trivialPromise)(c,n)}function x(e,t,n,l,u,c){var p,f=e.key(),g=(0,i.isPlainObject)(n)?(0,r.extend)({},n):n;if(f){if(void 0===(p=e.keyOf(g))||"object"===h(p)&&(0,i.isEmptyObject)(p)){if(Array.isArray(f))throw s.errors.Error("E4007");p=g[f]=String(new a.default)}else if(void 0!==t[C(e,t,p)])return y(u,c,"E4008")}else p=g;if(l>=0?t.splice(l,0,g):t.push(g),m(t,p,g),!u)return(0,d.trivialPromise)((0,o.default)().useLegacyStoreResult?n:g,p)}function w(e,t,n,i,o){var a=C(e,t,n);return a>-1&&(t.splice(a,1),m(t,n,null)),i?a<0?y(i,o,"E4009"):void 0:(0,d.trivialPromise)(n)}function C(e,t,n){var i=e.key();if(!function(e,t){return!e._dataByKeyMap||e._dataByKeyMap[JSON.stringify(t)]}(t,n))return-1;for(var o=0,a=t.length;o<a;o++)if((0,d.keysEqual)(i,e.keyOf(t[o]),n))return o;return-1}},88036:function(e,t,n){t.default=void 0;var i=p(n(68374)),o=n(16454),a=n(60637),r=n(35922),s=p(n(80209)),l=n(18438),u=p(n(67403)),d=p(n(35042)),c=p(n(99236)),h=n(62754);function p(e){return e&&e.__esModule?e:{default:e}}function f(e){return e&&(0,r.isFunction)(e.then)}function g(e){return(new h.Deferred).resolve(e).promise()}function m(e,t){if(!(0,r.isFunction)(t))throw l.errors.Error("E4011",e)}function _(e){throw l.errors.Error("E4012",e)}function v(e){function t(e){var t=e[0],n=e[1];return t&&t.getResponseHeader?(0,o.errorMessageFromXhr)(t,n):null}return function(n){var i;(i=n instanceof Error?n:new Error(t(arguments)||n&&String(n)||"Unknown error")).message!==o.XHR_ERROR_UNLOAD&&e.reject(i)}}function y(e,t){var n,i=e._loadFunc;return m("load",i),n=i.apply(e,[t]),Array.isArray(n)?n=g(n):null==n?n=g([]):f(n)||_("load"),(0,h.fromPromise)(n)}function b(e,t,n,i){if(t.__rawData)i(t.__rawData);else{var o=t.__rawDataPromise||y(t,n);t._cacheRawData&&(t.__rawDataPromise=o),o.always((function(){delete t.__rawDataPromise})).done((function(e){t._cacheRawData&&(t.__rawData=e),i(e)})).fail(v(e))}}function x(e,t,n,o){var a={};"userData"in(n=n||{})&&(a.userData=n.userData),b(e,t,a,(function(a){var r,s,l,u,p=(0,d.default)(a,{errorHandler:t._errorHandler}),f=[];o||((r=c.default.queryByOptions(p,n))===p?l=a.slice(0):f.push(r.enumerate().done((function(e){l=e})))),(n.requireTotalCount||o)&&((s=c.default.queryByOptions(p,n,!0))===p?u=a.length:f.push(s.count().done((function(e){u=e})))),h.when.apply(i.default,f).done((function(){o?e.resolve(u):n.requireTotalCount?e.resolve(l,{totalCount:u}):e.resolve(l)})).fail((function(t){e.reject(t)}))}))}var w=u.default.inherit({ctor:function(e){e=e||{},this.callBase(e),this._useDefaultSearch=!!e.useDefaultSearch||"raw"===e.loadMode,this._loadMode=e.loadMode,this._cacheRawData=!1!==e.cacheRawData,this._loadFunc=e.load,this._totalCountFunc=e.totalCount,this._byKeyFunc=e.byKey,this._insertFunc=e.insert,this._updateFunc=e.update,this._removeFunc=e.remove},createQuery:function(){throw l.errors.Error("E4010")},clearRawDataCache:function(){delete this.__rawData},_totalCountImpl:function(e){var t=new h.Deferred;return"raw"!==this._loadMode||this._totalCountFunc?(function(e,t){var n,i=e._totalCountFunc;if(!(0,r.isFunction)(i))throw l.errors.Error("E4021");return f(n=i.apply(e,[t]))||(n=Number(n),isFinite(n)||_("totalCount"),n=g(n)),(0,h.fromPromise)(n)}(this,e).done((function(e){t.resolve(Number(e))})).fail(v(t)),t=this._addFailHandlers(t)):x(t,this,e,!0),t.promise()},_pushImpl:function(e){this.__rawData&&(0,a.applyBatch)({keyInfo:this,data:this.__rawData,changes:e})},_loadImpl:function(e){var t=new h.Deferred;return"raw"===this._loadMode?x(t,this,e,!1):(y(this,e).done((function(e,n){t.resolve(e,n)})).fail(v(t)),t=this._addFailHandlers(t)),t.promise()},_byKeyImpl:function(e,t){var n=new h.Deferred;return this._byKeyViaLoad()?(this._requireKey(),function(e,t,n){b(e,t,{},(function(i){for(var a,r=t.key(),s=0,u=i.length;s<u;s++)if(a=i[s],(0,o.keysEqual)(r,t.keyOf(i[s]),n))return void e.resolve(a);e.reject(l.errors.Error("E4009"))}))}(n,this,e)):function(e,t,n){var i,o=e._byKeyFunc;return m("byKey",o),f(i=o.apply(e,[t,n]))||(i=g(i)),(0,h.fromPromise)(i)}(this,e,t).done((function(e){n.resolve(e)})).fail(v(n)),n.promise()},_byKeyViaLoad:function(){return"raw"===this._loadMode&&!this._byKeyFunc},_insertImpl:function(e){var t,n=this,i=n._insertFunc,o=new h.Deferred;return m("insert",i),f(t=i.apply(n,[e]))||(t=g(t)),(0,h.fromPromise)(t).done((function(t){(0,s.default)().useLegacyStoreResult?o.resolve(e,t):o.resolve(t||e,n.keyOf(t))})).fail(v(o)),o.promise()},_updateImpl:function(e,t){var n,i=this._updateFunc,o=new h.Deferred;return m("update",i),f(n=i.apply(this,[e,t]))||(n=g(n)),(0,h.fromPromise)(n).done((function(n){(0,s.default)().useLegacyStoreResult?o.resolve(e,t):o.resolve(n||t,e)})).fail(v(o)),o.promise()},_removeImpl:function(e){var t,n=this._removeFunc,i=new h.Deferred;return m("remove",n),f(t=n.apply(this,[e]))||(t=g()),(0,h.fromPromise)(t).done((function(){i.resolve(e)})).fail(v(i)),i.promise()}});t.default=w,e.exports=t.default,e.exports.default=t.default},33546:function(e,t,n){t.default=void 0;var i=n(85273).DataSource;t.default=i,e.exports=t.default,e.exports.default=t.default},85273:function(e,t,n){t.DataSource=void 0;var i=_(n(38377)),o=n(13306),a=n(20576),r=n(95479),s=n(35922),l=n(16454),u=n(60637),d=_(n(88036)),c=n(80566),h=n(18438),p=n(59504),f=n(62754),g=_(n(88665)),m=n(9234);function _(e){return e&&e.__esModule?e:{default:e}}function v(e){return function(e){if(Array.isArray(e))return y(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return y(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return y(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function y(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}var b=i.default.inherit({ctor:function(e){var t,n=this;if(e=(0,m.normalizeDataSourceOptions)(e),this._eventsStrategy=new c.EventsStrategy(this,{syncStrategy:!0}),this._store=e.store,this._changedTime=0,0!==e.pushAggregationTimeout){var i,o,a=void 0===e.pushAggregationTimeout?function(){return 5*n._changedTime}:e.pushAggregationTimeout,s=(0,l.throttleChanges)((function(e){i.resolve(),f.when.apply(void 0,v(o)).done((function(){return n._onPush(e)})),o=void 0,i=void 0}),a);this._onPushHandler=function(e){n._aggregationTimeoutId=s(e.changes),i||(i=new f.Deferred),o=e.waitFor,e.waitFor.push(i.promise())},this._store.on("beforePush",this._onPushHandler)}else this._onPushHandler=function(e){return n._onPush(e)},this._store.on("push",this._onPushHandler);this._storeLoadOptions=this._extractLoadOptions(e),this._mapFunc=e.map,this._postProcessFunc=e.postProcess,this._pageIndex=void 0!==e.pageIndex?e.pageIndex:0,this._pageSize=void 0!==e.pageSize?e.pageSize:20,this._loadingCount=0,this._loadQueue=this._createLoadQueue(),this._searchValue="searchValue"in e?e.searchValue:null,this._searchOperation=e.searchOperation||"contains",this._searchExpr=e.searchExpr,this._paginate=e.paginate,this._reshapeOnPush=null!==(t=e.reshapeOnPush)&&void 0!==t&&t,(0,r.each)(["onChanged","onLoadError","onLoadingChanged","onCustomizeLoadResult","onCustomizeStoreLoadOptions"],(function(t,i){i in e&&n.on(i.substr(2,1).toLowerCase()+i.substr(3),e[i])})),this._operationManager=new g.default,this._init()},_init:function(){this._items=[],this._userData={},this._totalCount=-1,this._isLoaded=!1,(0,s.isDefined)(this._paginate)||(this._paginate=!this.group()),this._isLastPage=!this._paginate},dispose:function(){var e;this._store.off("beforePush",this._onPushHandler),this._store.off("push",this._onPushHandler),this._eventsStrategy.dispose(),clearTimeout(this._aggregationTimeoutId),null===(e=this._delayedLoadTask)||void 0===e||e.abort(),this._operationManager.cancelAll(),delete this._store,delete this._items,delete this._delayedLoadTask,this._disposed=!0},_extractLoadOptions:function(e){var t={},n=["sort","filter","select","group","requireTotalCount"],i=this._store._customLoadOptions();return i&&(n=n.concat(i)),(0,r.each)(n,(function(){t[this]=e[this]})),t},loadOptions:function(){return this._storeLoadOptions},items:function(){return this._items},pageIndex:function(e){if(!(0,s.isNumeric)(e))return this._pageIndex;this._pageIndex=e,this._isLastPage=!this._paginate},paginate:function(e){if(!(0,s.isBoolean)(e))return this._paginate;this._paginate!==e&&(this._paginate=e,this.pageIndex(0))},pageSize:function(e){if(!(0,s.isNumeric)(e))return this._pageSize;this._pageSize=e},isLastPage:function(){return this._isLastPage},generateStoreLoadOptionAccessor:function(e){var t=this;return function(n){var i=(0,m.normalizeStoreLoadOptionAccessorArguments)(n);if(void 0===i)return t._storeLoadOptions[e];t._storeLoadOptions[e]=i}},sort:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return this.generateStoreLoadOptionAccessor("sort")(t)},filter:function(){var e=(0,m.normalizeStoreLoadOptionAccessorArguments)(arguments);if(void 0===e)return this._storeLoadOptions.filter;this._storeLoadOptions.filter=e,this.pageIndex(0)},group:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return this.generateStoreLoadOptionAccessor("group")(t)},select:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return this.generateStoreLoadOptionAccessor("select")(t)},requireTotalCount:function(e){if(!(0,s.isBoolean)(e))return this._storeLoadOptions.requireTotalCount;this._storeLoadOptions.requireTotalCount=e},searchValue:function(e){if(arguments.length<1)return this._searchValue;this._searchValue=e,this.pageIndex(0)},searchOperation:function(e){if(!(0,s.isString)(e))return this._searchOperation;this._searchOperation=e,this.pageIndex(0)},searchExpr:function(e){var t=arguments.length;if(0===t)return this._searchExpr;t>1&&(e=[].slice.call(arguments)),this._searchExpr=e,this.pageIndex(0)},store:function(){return this._store},key:function(){var e;return null===(e=this._store)||void 0===e?void 0:e.key()},totalCount:function(){return this._totalCount},isLoaded:function(){return this._isLoaded},isLoading:function(){return this._loadingCount>0},beginLoading:function(){this._changeLoadingCount(1)},endLoading:function(){this._changeLoadingCount(-1)},_createLoadQueue:function(){return(0,p.create)()},_changeLoadingCount:function(e){var t=this.isLoading();this._loadingCount+=e;var n=this.isLoading();t^n&&this._eventsStrategy.fireEvent("loadingChanged",[n])},_scheduleLoadCallbacks:function(e){var t=this;this.beginLoading(),e.always((function(){t.endLoading()}))},_scheduleFailCallbacks:function(e){var t=this;e.fail((function(){for(var e=arguments.length,n=new Array(e),i=0;i<e;i++)n[i]=arguments[i];n[0]!==m.CANCELED_TOKEN&&t._eventsStrategy.fireEvent("loadError",n)}))},_fireChanged:function(e){var t=new Date;this._eventsStrategy.fireEvent("changed",e),this._changedTime=new Date-t},_scheduleChangedCallbacks:function(e){var t=this;e.done((function(){return t._fireChanged()}))},loadSingle:function(e,t){var n=this,i=new f.Deferred,o=this.key(),a=this._store,r=this._createStoreLoadOptions(),l=function(e){var t=Array.isArray(e)&&!e.length;!(0,s.isDefined)(e)||t?i.reject(new h.errors.Error("E4009")):(Array.isArray(e)||(e=[e]),i.resolve(n._applyMapFunction(e)[0]))};this._scheduleFailCallbacks(i),arguments.length<2&&(t=e,e=o),delete r.skip,delete r.group,delete r.refresh,delete r.pageIndex,delete r.searchString;var u=function(){return a instanceof d.default&&!a._byKeyViaLoad()};return(e===o||u()?a.byKey(t,r):(r.take=1,r.filter=r.filter?[r.filter,[e,t]]:[e,t],a.load(r))).fail(i.reject).done(l),i.promise()},load:function(){var e=this,t=new f.Deferred,n=function(){if(!e._disposed&&(0,m.isPending)(t))return e._loadFromStore(i,t)};this._scheduleLoadCallbacks(t),this._scheduleFailCallbacks(t),this._scheduleChangedCallbacks(t);var i=this._createLoadOperation(t);return this._eventsStrategy.fireEvent("customizeStoreLoadOptions",[i]),this._loadQueue.add((function(){return"number"==typeof i.delay?e._delayedLoadTask=(0,a.executeAsync)(n,i.delay):n(),t.promise()})),t.promise({operationId:i.operationId})},_onPush:function(e){var t=this;if(this._reshapeOnPush)this.load();else{this._eventsStrategy.fireEvent("changing",[{changes:e}]);var n=this.group(),i=this.items(),o=0,a=this.paginate()||n?e.filter((function(e){return"update"===e.type})):e;n&&(o=Array.isArray(n)?n.length:1),this._mapFunc&&a.forEach((function(e){"insert"===e.type&&(e.data=t._mapFunc(e.data))})),(0,u.applyBatch)({keyInfo:this.store(),data:i,changes:a,groupCount:o,useInsertIndex:!0}),this._fireChanged([{changes:e}])}},_createLoadOperation:function(e){var t=this,n=this._operationManager.add(e),i=this._createStoreLoadOptions();return e.always((function(){return t._operationManager.remove(n)})),{operationId:n,storeLoadOptions:i}},reload:function(){var e=this.store();return e instanceof d.default&&e.clearRawDataCache(),this._init(),this.load()},cancel:function(e){return this._operationManager.cancel(e)},cancelAll:function(){return this._operationManager.cancelAll()},_addSearchOptions:function(e){this._disposed||(this.store()._useDefaultSearch?this._addSearchFilter(e):(e.searchOperation=this._searchOperation,e.searchValue=this._searchValue,e.searchExpr=this._searchExpr))},_createStoreLoadOptions:function(){var e=(0,o.extend)({},this._storeLoadOptions);return this._addSearchOptions(e),this._paginate&&this._pageSize&&(e.skip=this._pageIndex*this._pageSize,e.take=this._pageSize),e.userData=this._userData,e},_addSearchFilter:function(e){var t=this._searchValue,n=this._searchOperation,i=this._searchExpr,o=[];t&&(i||(i="this"),Array.isArray(i)||(i=[i]),(0,r.each)(i,(function(e,i){o.length&&o.push("or"),o.push([i,n,t])})),e.filter?e.filter=[o,e.filter]:e.filter=o)},_loadFromStore:function(e,t){var n=this,i=function(i,a){if(!n._disposed&&(0,m.isPending)(t)){var r=(0,o.extend)((0,m.normalizeLoadResult)(i,a),e);n._eventsStrategy.fireEvent("customizeLoadResult",[r]),(0,f.when)(r.data).done((function(e){r.data=e,n._processStoreLoadResult(r,t)})).fail(t.reject)}};return e.data?(new f.Deferred).resolve(e.data).done(i):this.store().load(e.storeLoadOptions).done(i).fail(t.reject)},_processStoreLoadResult:function(e,t){var n=this,i=e.data,o=e.extra,a=e.storeLoadOptions,r=function(){return n._isLoaded=!0,n._totalCount=isFinite(o.totalCount)?o.totalCount:-1,t.resolve(i,o)};this._disposed||(i=this._applyPostProcessFunction(this._applyMapFunction(i)),(0,s.isPlainObject)(o)||(o={}),this._items=i,(!i.length||!this._paginate||this._pageSize&&i.length<this._pageSize)&&(this._isLastPage=!0),a.requireTotalCount&&!isFinite(o.totalCount)?n.store().totalCount(a).done((function(e){o.totalCount=e,r()})).fail(t.reject):r())},_applyMapFunction:function(e){return this._mapFunc?(0,m.mapDataRespectingGrouping)(e,this._mapFunc,this.group()):e},_applyPostProcessFunction:function(e){return this._postProcessFunc?this._postProcessFunc(e):e},on:function(e,t){return this._eventsStrategy.on(e,t),this},off:function(e,t){return this._eventsStrategy.off(e,t),this}});t.DataSource=b},88665:function(e,t,n){t.default=void 0;var i=n(9234),o=function(){function e(){this._counter=-1,this._deferreds={}}var t=e.prototype;return t.add=function(e){return this._counter++,this._deferreds[this._counter]=e,this._counter},t.remove=function(e){return delete this._deferreds[e]},t.cancel=function(e){return e in this._deferreds&&(this._deferreds[e].reject(i.CANCELED_TOKEN),!0)},t.cancelAll=function(){for(;this._counter>-1;)this.cancel(this._counter),this._counter--},e}();t.default=o,e.exports=t.default,e.exports.default=t.default},9234:function(e,t,n){t.normalizeStoreLoadOptionAccessorArguments=t.normalizeLoadResult=t.normalizeDataSourceOptions=t.mapDataRespectingGrouping=t.isPending=t.CANCELED_TOKEN=void 0;var i=h(n(37208)),o=h(n(67403)),a=h(n(26562)),r=n(95479),s=h(n(88036)),l=n(13306),u=n(35922),d=n(16454),c=["items"];function h(e){return e&&e.__esModule?e:{default:e}}function p(){return(p=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(e[i]=n[i])}return e}).apply(this,arguments)}function f(e,t){if(null==e)return{};var n,i,o=function(e,t){if(null==e)return{};var n,i,o={},a=Object.keys(e);for(i=0;i<a.length;i++)n=a[i],t.indexOf(n)>=0||(o[n]=e[n]);return o}(e,t);if(Object.getOwnPropertySymbols){var a=Object.getOwnPropertySymbols(e);for(i=0;i<a.length;i++)n=a[i],t.indexOf(n)>=0||Object.prototype.propertyIsEnumerable.call(e,n)&&(o[n]=e[n])}return o}t.CANCELED_TOKEN="canceled";t.isPending=function(e){return"pending"===e.state()};t.normalizeStoreLoadOptionAccessorArguments=function(e){switch(e.length){case 0:return;case 1:return e[0]}return[].slice.call(e)};var g=function(e,t,n){return(0,r.map)(e,(function(e){e.items;return p({},f(e,c),{items:m(e.items,t-1,n)})}))},m=function(e,t,n){return Array.isArray(e)?t?g(e,t,n):(0,r.map)(e,n):e};t.mapDataRespectingGrouping=function(e,t,n){var i=n?(0,d.normalizeSortingInfo)(n).length:0;return m(e,i,t)};t.normalizeLoadResult=function(e,t){var n;return null!==(n=e)&&void 0!==n&&n.data&&(t=e,e=e.data),Array.isArray(e)||(e=[e]),{data:e,extra:t}};var _=function(e,t){return new s.default({load:function(){return i.default.sendRequest({url:e,dataType:"json"})},loadMode:null==t?void 0:t.fromUrlLoadMode})};t.normalizeDataSourceOptions=function(e,t){var n,i,d;return"string"==typeof e&&(e={paginate:!1,store:_(e,t)}),void 0===e&&(e=[]),void 0===(e=Array.isArray(e)||e instanceof o.default?{store:e}:(0,l.extend)({},e)).store&&(e.store=[]),n=e.store,"load"in e?n=function(e){var t={};return(0,r.each)(["useDefaultSearch","key","load","loadMode","cacheRawData","byKey","lookup","totalCount","insert","update","remove"],(function(){t[this]=e[this],delete e[this]})),new s.default(t)}(e):Array.isArray(n)?n=new a.default(n):(0,u.isPlainObject)(n)&&(i=(0,l.extend)({},n),d=i.type,delete i.type,n=o.default.create(d,i)),e.store=n,e}},8162:function(e,t,n){t.default=void 0;var i,o=(i=n(17381))&&i.__esModule?i:{default:i};var a,r,s=(0,n(58201).getWindow)();var l=function(e){var t;this.config=e,a="ms-appx:"===s.location.protocol,t=s.location.hostname,r=/^(localhost$|127\.)/i.test(t)};l.prototype={urlFor:function(e){var t=this.config[e];if(!t)throw o.default.Error("E0006");return t.production&&(a&&!Debug.debuggerEnabled||!a&&!r)?t.production:t.local}};var u=l;t.default=u,e.exports=t.default,e.exports.default=t.default},18438:function(e,t,n){t.setErrorHandler=t.handleError=t.errors=t.errorHandler=void 0;var i=a(n(95640)),o=a(n(17381));function a(e){return e&&e.__esModule?e:{default:e}}var r=(0,i.default)(o.default.ERROR_MESSAGES,{E4000:"[DevExpress.data]: {0}",E4001:"Unknown aggregating function is detected: '{0}'",E4002:"Unsupported OData protocol version is used",E4003:"Unknown filter operation is used: {0}",E4004:"The thenby() method is called before the sortby() method",E4005:"Store requires a key expression for this operation",E4006:"ArrayStore 'data' option must be an array",E4007:"Compound keys cannot be auto-generated",E4008:"Attempt to insert an item with a duplicated key",E4009:"Data item cannot be found",E4010:"CustomStore does not support creating queries",E4011:"Custom Store method is not implemented or is not a function: {0}",E4012:"Custom Store method returns an invalid value: {0}",E4013:"Local Store requires the 'name' configuration option is specified",E4014:"Unknown data type is specified for ODataStore: {0}",E4015:"Unknown entity name or alias is used: {0}",E4016:"The compileSetter(expr) method is called with 'self' passed as a parameter",E4017:"Keys cannot be modified",E4018:"The server has returned a non-numeric value in a response to an item count request",E4019:"Mixing of group operators inside a single group of filter expression is not allowed",E4020:"Unknown store type is detected: {0}",E4021:"The server response does not provide the totalCount value",E4022:"The server response does not provide the groupCount value",E4023:"Could not parse the following XML: {0}",E4024:"String function {0} cannot be used with the data field {1} of type {2}.",W4000:"Data returned from the server has an incorrect structure",W4001:'The {0} field is listed in both "keyType" and "fieldTypes". The value of "fieldTypes" is used.',W4002:"Data loading has failed for some cells due to the following error: {0}"});t.errors=r;var s=null;t.errorHandler=s;t.handleError=function(e){var t;null===(t=s)||void 0===t||t(e)};t.setErrorHandler=function(e){return t.errorHandler=s=e}},82837:function(e,t,n){t.default=void 0;var i=d(n(55994)),o=d(n(73349)),a=n(58201),r=d(n(38377)),s=n(18438),l=d(n(26562)),u=d(n(96687));function d(e){return e&&e.__esModule?e:{default:e}}var c=(0,a.getWindow)(),h=r.default.abstract,p={dom:r.default.inherit({ctor:function(e,t){this._store=e,this._dirty=!!t.data,this.save();var n=this._immediate=t.immediate,a=Math.max(100,t.flushInterval||1e4);if(!n){var r=this.save.bind(this);setInterval(r,a),i.default.on(c,"beforeunload",r),c.cordova&&o.default.listen(o.default.getDocument(),"pause",r,!1)}},notifyChanged:function(){this._dirty=!0,this._immediate&&this.save()},load:function(){this._store._array=this._loadImpl(),this._dirty=!1},save:function(){this._dirty&&(this._saveImpl(this._store._array),this._dirty=!1)},_loadImpl:h,_saveImpl:h}).inherit({ctor:function(e,t){var n=t.name;if(!n)throw s.errors.Error("E4013");this._key="dx-data-localStore-"+n,this.callBase(e,t)},_loadImpl:function(){var e=c.localStorage.getItem(this._key);return e?JSON.parse(e):[]},_saveImpl:function(e){e.length?c.localStorage.setItem(this._key,JSON.stringify(e)):c.localStorage.removeItem(this._key)}})},f=l.default.inherit({ctor:function(e){e="string"==typeof e?{name:e}:e||{},this.callBase(e),this._backend=new p[e.backend||"dom"](this,e),this._backend.load()},clear:function(){this.callBase(),this._backend.notifyChanged()},createQuery:function(){return(0,u.default)(this._backend._loadImpl(),{errorHandler:this._errorHandler})},_insertImpl:function(e){var t=this._backend;return this.callBase(e).done(t.notifyChanged.bind(t))},_updateImpl:function(e,t){var n=this._backend;return this.callBase(e,t).done(n.notifyChanged.bind(n))},_removeImpl:function(e){var t=this._backend;return this.callBase(e).done(t.notifyChanged.bind(t))}},"local");t.default=f,e.exports=t.default,e.exports.default=t.default},47256:function(e,t,n){t.default=void 0;var i=h(n(38377)),o=n(13306),a=n(35922),r=n(95479),s=n(18438),l=h(n(341)),u=h(n(63081)),d=n(77869),c=n(62754);function h(e){return e&&e.__esModule?e:{default:e}}n(54263);var p=i.default.inherit({ctor:function(e){var t=this;this._requestDispatcher=new u.default(e),this._errorHandler=e.errorHandler,(0,r.each)(e.entities||[],(function(n,i){t[n]=new l.default((0,o.extend)({},e,{url:"".concat(t._requestDispatcher.url,"/").concat(encodeURIComponent(i.name||n))},i))}))},get:function(e,t){return this.invoke(e,t,"GET")},invoke:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"POST";n=n.toLowerCase();var i,o=new c.Deferred,r="".concat(this._requestDispatcher.url,"/").concat(encodeURIComponent(e));return 4===this.version()&&("get"===n?(r=(0,d.formatFunctionInvocationUrl)(r,(0,d.escapeServiceOperationParams)(t,this.version())),t=null):"post"===n&&(i=t,t=null)),(0,c.when)(this._requestDispatcher.sendRequest(r,n,(0,d.escapeServiceOperationParams)(t,this.version()),i)).done((function(t){(0,a.isPlainObject)(t)&&e in t&&(t=t[e]),o.resolve(t)})).fail(this._errorHandler).fail(s.handleError).fail(o.reject),o.promise()},objectLink:function(e,t){var n=this[e];if(!n)throw s.errors.Error("E4015",e);return(0,a.isDefined)(t)?{__metadata:{uri:n._byKeyUrl(t)}}:null},version:function(){return this._requestDispatcher.version}});t.default=p,e.exports=t.default,e.exports.default=t.default},54263:function(e,t,n){t.odata=void 0;var i=n(35922),o=n(95479),a=c(n(80209)),r=n(13306),s=c(n(16135)),l=n(77869),u=n(18438),d=n(16454);function c(e){return e&&e.__esModule?e:{default:e}}var h,p,f,g,m,_,v,y,b,x,w,C,S=["contains","notcontains","startswith","endswith"],k=(m=function(e,t){return function(n,i){var o=[e,"("];return p&&(n=-1===n.indexOf("tolower(")?"tolower(".concat(n,")"):n,i=i.toLowerCase()),t?o.push(i,",",n):o.push(n,",",i),o.push(")"),o.join("")}},_={"=":(g=function(e){return function(t,n){return"".concat(t," ").concat(e," ").concat(n)}})("eq"),"<>":g("ne"),">":g("gt"),">=":g("ge"),"<":g("lt"),"<=":g("le"),startswith:m("startswith"),endswith:m("endswith")},v=(0,r.extend)({},_,{contains:m("substringof",!0),notcontains:m("not substringof",!0)}),y=(0,r.extend)({},_,{contains:m("contains"),notcontains:m("not contains")}),b=function(e){var t,n,i=(e=(0,d.normalizeBinaryCriterion)(e))[1],o=e[0],a=f&&f[o];if(a&&(n=i,S.some((function(e){return e===n})))&&"String"!==a)throw new u.errors.Error("E4024",i,o,a);var r=(4===h?y:v)[i.toLowerCase()];if(!r)throw u.errors.Error("E4003",i);var s=e[2];return null!==(t=f)&&void 0!==t&&t[o]&&(s=(0,l.convertPrimitiveValue)(f[o],s)),r((0,l.serializePropName)(o),(0,l.serializeValue)(s,h))},x=function(e){var t=e[0],n=C(e[1]);if("!"===t)return"not (".concat(n,")");throw u.errors.Error("E4003",t)},w=function(e){var t,n,i=[];return(0,o.each)(e,(function(e,o){if(Array.isArray(o)){if(i.length>1&&t!==n)throw new u.errors.Error("E4019");i.push("(".concat(C(o),")")),t=n,n="and"}else n=(0,d.isConjunctiveOperator)(this)?"and":"or"})),i.join(" ".concat(t," "))},C=function(e){return Array.isArray(e[0])?w(e):(0,d.isUnaryOperation)(e)?x(e):b(e)},function(e,t,n,i){return f=n,p=null!=i?i:(0,a.default)().oDataFilterToLower,h=t,C(e)}),D=function(e){var t,n,o,a,s=[],u=[],d=e.expand,c=e.version||2,h=function(){return n||void 0!==o},p=function e(t){for(var n=0;n<t.length;n++){if((0,i.isFunction)(t[n]))return!0;if(Array.isArray(t[n])&&e(t[n]))return!0}return!1},f=function(){var i={};if(a||(s.length&&(i.$orderby=s.join(",")),n&&(i.$skip=n),void 0!==o&&(i.$top=o),i.$select=(0,l.generateSelect)(c,t)||void 0,i.$expand=(0,l.generateExpand)(c,d,t)||void 0),u.length){var r=u.length<2?u[0]:u,h=null==e?void 0:e.fieldTypes,p=null==e?void 0:e.filterToLower;i.$filter=k(r,c,h,p)}return a&&(i.$top=0),(e.requireTotalCount||a)&&(4!==c?i.$inlinecount="allpages":i.$count="true"),i};return{optimize:function(e){for(var t=-1,n=0;n<e.length;n++)if("select"===e[n].name){t=n;break}if(!(t<0)&&(0,i.isFunction)(e[t].args[0])){var o=e[1+t];o&&"slice"===o.name&&(e[1+t]=e[t],e[t]=o)}},exec:function(t){return(0,l.sendRequest)(c,{url:t,params:(0,r.extend)(f(),null==e?void 0:e.params)},{beforeSend:e.beforeSend,jsonp:e.jsonp,withCredentials:e.withCredentials,countOnly:a,deserializeDates:e.deserializeDates,fieldTypes:e.fieldTypes,isPaged:isFinite(o)})},multiSort:function(e){var t;if(h())return!1;for(var n=0;n<e.length;n++){var i=e[n][0],o=!!e[n][1],a=void 0;if("string"!=typeof i)return!1;a=(0,l.serializePropName)(i),o&&(a+=" desc"),(t=t||[]).push(a)}s=t},slice:function(e,t){if(h())return!1;n=e,o=t},filter:function(e){return!h()&&(Array.isArray(e)||(e=[].slice.call(arguments)),!p(e)&&(u.length&&u.push("and"),void u.push(e)))},select:function(e){if(t||(0,i.isFunction)(e))return!1;Array.isArray(e)||(e=[].slice.call(arguments)),t=e},count:function(){return a=!0}}};s.default.odata=D;var I=D;t.odata=I},63081:function(e,t,n){t.default=void 0;var i=n(77869);function o(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}n(54263);var a=function(){function e(e){e=e||{},this._url=String(e.url).replace(/\/+$/,""),this._beforeSend=e.beforeSend,this._jsonp=e.jsonp,this._version=e.version||2,this._withCredentials=e.withCredentials,this._deserializeDates=e.deserializeDates,this._filterToLower=e.filterToLower}var t,n,a;return e.prototype.sendRequest=function(e,t,n,o){return(0,i.sendRequest)(this.version,{url:e,method:t,params:n||{},payload:o},{beforeSend:this._beforeSend,jsonp:this._jsonp,withCredentials:this._withCredentials,deserializeDates:this._deserializeDates})},t=e,(n=[{key:"version",get:function(){return this._version}},{key:"beforeSend",get:function(){return this._beforeSend}},{key:"url",get:function(){return this._url}},{key:"jsonp",get:function(){return this._jsonp}},{key:"filterToLower",get:function(){return this._filterToLower}}])&&o(t.prototype,n),a&&o(t,a),Object.defineProperty(t,"prototype",{writable:!1}),e}();t.default=a,e.exports=t.default,e.exports.default=t.default},341:function(e,t,n){t.default=void 0;var i=n(35922),o=c(n(80209)),a=n(77869),r=n(18438),s=c(n(96687)),l=c(n(67403)),u=c(n(63081)),d=n(62754);function c(e){return e&&e.__esModule?e:{default:e}}n(54263);var h=function(e,t){return function(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}({},e,t)},p=l.default.inherit({ctor:function(e){this.callBase(e),this._requestDispatcher=new u.default(e);var t=this.key(),n=e.fieldTypes,i=e.keyType;if(i){var o="string"==typeof i;t||(t=o?"5d46402c-7899-4ea9-bd81-8b73c47c7683":Object.keys(i),this._legacyAnonymousKey=t),o&&(i=h(t,i)),n=function(e,t){var n={};for(var i in e)n[i]=e[i];for(var o in t)o in n?n[o]!==t[o]&&r.errors.log("W4001",o):n[o]=t[o];return n}(n,i)}this._fieldTypes=n||{},2===this.version()?this._updateMethod="MERGE":this._updateMethod="PATCH"},_customLoadOptions:function(){return["expand","customQueryParams"]},_byKeyImpl:function(e,t){var n={};return t&&(n.$expand=(0,a.generateExpand)(this.version(),t.expand,t.select)||void 0,n.$select=(0,a.generateSelect)(this.version(),t.select)||void 0),this._requestDispatcher.sendRequest(this._byKeyUrl(e),"GET",n)},createQuery:function(e){var t,n,o={adapter:"odata",beforeSend:this._requestDispatcher.beforeSend,errorHandler:this._errorHandler,jsonp:this._requestDispatcher.jsonp,version:this._requestDispatcher.version,withCredentials:this._requestDispatcher._withCredentials,expand:null==e?void 0:e.expand,requireTotalCount:null==e?void 0:e.requireTotalCount,deserializeDates:this._requestDispatcher._deserializeDates,fieldTypes:this._fieldTypes};if(n=null!==(t=null==e?void 0:e.urlOverride)&&void 0!==t?t:this._requestDispatcher.url,(0,i.isDefined)(this._requestDispatcher.filterToLower)&&(o.filterToLower=this._requestDispatcher.filterToLower),null!=e&&e.customQueryParams){var r=(0,a.escapeServiceOperationParams)(null==e?void 0:e.customQueryParams,this.version());4===this.version()?n=(0,a.formatFunctionInvocationUrl)(n,r):o.params=r}return(0,s.default)(n,o)},_insertImpl:function(e){var t=this;this._requireKey();var n=new d.Deferred;return(0,d.when)(this._requestDispatcher.sendRequest(this._requestDispatcher.url,"POST",null,e)).done((function(i){return n.resolve(i&&!(0,o.default)().useLegacyStoreResult?i:e,t.keyOf(i))})).fail(n.reject),n.promise()},_updateImpl:function(e,t){var n=new d.Deferred;return(0,d.when)(this._requestDispatcher.sendRequest(this._byKeyUrl(e),this._updateMethod,null,t)).done((function(i){return(0,o.default)().useLegacyStoreResult?n.resolve(e,t):n.resolve(i||t,e)})).fail(n.reject),n.promise()},_removeImpl:function(e){var t=new d.Deferred;return(0,d.when)(this._requestDispatcher.sendRequest(this._byKeyUrl(e),"DELETE")).done((function(){return t.resolve(e)})).fail(t.reject),t.promise()},_convertKey:function(e){var t=e,n=this._fieldTypes,i=this.key()||this._legacyAnonymousKey;if(Array.isArray(i)){t={};for(var o=0;o<i.length;o++){var r=i[o];t[r]=(0,a.convertPrimitiveValue)(n[r],e[r])}}else n[i]&&(t=(0,a.convertPrimitiveValue)(n[i],e));return t},_byKeyUrl:function(e){var t=this._requestDispatcher.url,n=this._convertKey(e);return"".concat(t,"(").concat(encodeURIComponent((0,a.serializeKey)(n,this.version())),")")},version:function(){return this._requestDispatcher.version}},"odata");t.default=p,e.exports=t.default,e.exports.default=t.default},77869:function(e,t,n){t.serializeValue=t.serializePropName=t.serializeKey=t.sendRequest=t.keyConverters=t.generateSelect=t.generateExpand=t.formatFunctionInvocationUrl=t.escapeServiceOperationParams=t.convertPrimitiveValue=t.EdmLiteral=void 0;var i=f(n(38377)),o=n(13306),a=n(35922),r=n(95479),s=f(n(37208)),l=f(n(73176)),u=n(20576),d=n(62754),c=n(18438),h=n(16454),p=n(68752);function f(e){return e&&e.__esModule?e:{default:e}}function g(e){return(g="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var m=/^(\{{0,1}([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}\}{0,1})$/,_=/^\/Date\((-?\d+)((\+|-)?(\d+)?)\)\/$/,v=/^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d+)?(Z|[-+]{1}\d{2}(:?)(\d{2})?)?$/,y="application/json;odata=verbose",b=function(e){return"string"===(0,a.type)(e)?e.split():e},x=function(e){return/\./.test(e)},w=function(e,t,n){for(e=String(e);e.length<t;)e=n?"".concat(e,"0"):"0".concat(e);return e},C=function(e,t,n){var i=[],o=function(e){return w(e,2)};return i.push(e.getFullYear()),i.push("-"),i.push(o(e.getMonth()+1)),i.push("-"),i.push(o(e.getDate())),t&&e.getHours()+e.getMinutes()+e.getSeconds()+e.getMilliseconds()<1||(i.push("T"),i.push(o(e.getHours())),i.push(":"),i.push(o(e.getMinutes())),i.push(":"),i.push(o(e.getSeconds())),e.getMilliseconds()&&(i.push("."),i.push(w(e.getMilliseconds(),3))),n||i.push("Z")),i.join("")},S=function(e){var t=new Date(60*new Date(0).getTimezoneOffset()*1e3),n=e.replace("Z","").split("T"),i=/(\d{4})-(\d{2})-(\d{2})/.exec(n[0]),o=/(\d{2}):(\d{2}):(\d{2})\.?(\d{0,7})?/.exec(n[1]);if(t.setFullYear(Number(i[1])),t.setMonth(Number(i[2])-1),t.setDate(Number(i[3])),Array.isArray(o)&&o.length){t.setHours(Number(o[1])),t.setMinutes(Number(o[2])),t.setSeconds(Number(o[3]));var a=(o[4]||"").slice(0,3);a=w(a,3,!0),t.setMilliseconds(Number(a))}return t},k=function(e){var t=[];for(var n in e)t.push(n+"="+e[n]);return t.join("&")};t.sendRequest=function e(t,n,i){var a=i.deserializeDates,r=i.fieldTypes,l=i.countOnly,u=i.isPaged,p=new d.Deferred,f=function(e,t){var n,i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},a=function(t){return JSON.stringify(t,(function(t,n){if(!(this[t]instanceof Date))return n;switch(n=C(this[t]),e){case 2:return n.substr(0,n.length-1);case 3:case 4:return n;default:throw c.errors.Error("E4002")}}))};t=(0,o.extend)({async:!0,method:"get",url:"",params:{},payload:null,headers:{},timeout:3e4},t),null===(n=i.beforeSend)||void 0===n||n.call(i,t);var r=t,s=r.async,l=r.timeout,u=r.headers,d=t,h=d.url,p=d.method,f=i.jsonp,g=i.withCredentials,m="get"===(p=(p||"get").toLowerCase()),_=m&&f,v=(0,o.extend)({},t.params),b=m?v:a(t.payload),x=!m&&k(v),w=!m&&y;return x&&(h+=(h.indexOf("?")>-1?"&":"?")+x),_&&(b.$format="json"),{url:h,data:b,dataType:_?"jsonp":"json",jsonp:_&&"$callback",method:p,async:s,timeout:l,headers:u,contentType:w,accepts:{json:[y,"text/plain"].join()},xhrFields:{withCredentials:g}}}(t,n,i);return s.default.sendRequest(f).always((function(n,o){var s=D(n,o,{deserializeDates:a,fieldTypes:r},f),d=s.error,g=s.data,m=s.count,_=s.nextUrl;if(d)d.message!==h.XHR_ERROR_UNLOAD&&p.reject(d);else if(l)isFinite(m)?p.resolve(m):p.reject(new c.errors.Error("E4018"));else if(_&&!u)/^(?:[a-z]+:)?\/\//i.test(_)||(_=function(e,t){var n,i,o,a=(i=e,o=i.indexOf("?"),o>-1?i.substr(0,o):i).split("/"),r=t.split("/");for(a.pop();r.length;)".."===(n=r.shift())?a.pop():a.push(n);return a.join("/")}(f.url,_)),e(t,{url:_},i).fail(p.reject).done((function(e){return p.resolve(g.concat(e))}));else{var v=isFinite(m)?{totalCount:m}:void 0;p.resolve(g,v)}})),p.promise()};var D=function(e,t,n,i){var r=function(e,t,n){var i,a,r,s;if("nocontent"===t)return null;var l="Unknown error",u=e,d=200,c={requestOptions:n};if("success"!==t){var p=e.status,f=e.responseText;d=p,l=(0,h.errorMessageFromXhr)(e,t);try{u=JSON.parse(f)}catch(e){}}var g=(null===(i=u)||void 0===i?void 0:i.then)||(null===(a=u)||void 0===a?void 0:a.error)||(null===(r=u)||void 0===r?void 0:r["odata.error"])||(null===(s=u)||void 0===s?void 0:s["@odata.error"]);if(g){l=function(e){var t,n,i=e;"message"in e&&(t=(null===(n=e.message)||void 0===n?void 0:n.value)||e.message);for(;i=i.innererror||i.internalexception;){var o;if(t=null!==(o=i.message)&&void 0!==o?o:t,i.internalexception&&-1===t.indexOf("inner exception"))break}return t}(g)||l,c.errorDetails=g,200===d&&(d=500);var m=Number(g.code);isFinite(m)&&m>=400&&(d=m)}return d>=400||0===d?(c.httpStatus=d,(0,o.extend)(Error(l),c)):null}(e,t,i);if(r)return{error:r};if(!(0,a.isPlainObject)(e))return{data:e};var s="d"in e&&(Array.isArray(e.d)||(0,a.isObject)(e.d))?I(e,t):T(e,t);return O(s,n),s},I=function(e){var t,n=e.d;return(0,a.isDefined)(n)?{data:null!==(t=n.results)&&void 0!==t?t:n,nextUrl:n.__next,count:parseInt(n.__count,10)}:{error:Error("Malformed or unsupported JSON response received")}},T=function(e){var t;return{data:null!==(t=e.value)&&void 0!==t?t:e,nextUrl:e["@odata.nextLink"],count:parseInt(e["@odata.count"],10)}},E=i.default.inherit({ctor:function(e){this._value=e},valueOf:function(){return this._value}});t.EdmLiteral=E;var O=function e(t){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};(0,r.each)(t,(function(i,o){if(null!==o&&"object"===g(o))"results"in o&&(t[i]=o.results),e(t[i],n);else if("string"==typeof o){var a=n.fieldTypes,r=n.deserializeDates;if((!a||"String"!==a[i])&&m.test(o)&&(t[i]=new l.default(o)),!1!==r)if(o.match(_)){var s=new Date(Number(RegExp.$1)+60*RegExp.$2*1e3);t[i]=new Date(s.valueOf()+60*s.getTimezoneOffset()*1e3)}else v.test(o)&&(t[i]=new Date(S(t[i]).valueOf()))}}))},A=function(e){return e instanceof E?e.valueOf():e.replace(/\./g,"/")};t.serializePropName=A;var P=function(e){return e instanceof Date?"datetime'".concat(C(e,!0,!0),"'"):e instanceof l.default?"guid'".concat(e,"'"):e instanceof E?e.valueOf():"string"==typeof e?function(e){return"'".concat(e.replace(/'/g,"''"),"'")}(e):String(e)},R=function(e,t){switch(t){case 2:case 3:return P(e);case 4:return function e(t){return t instanceof Date?C(t,!1,!1):t instanceof l.default?t.valueOf():Array.isArray(t)?"[".concat(t.map((function(t){return e(t)})).join(","),"]"):P(t)}(e);default:throw c.errors.Error("E4002")}};t.serializeValue=R;t.serializeKey=function(e,t){if((0,a.isPlainObject)(e)){var n=[];return(0,r.each)(e,(function(e,i){return n.push("".concat(A(e),"=").concat(R(i,t)))})),n.join()}return R(e,t)};var M={String:function(e){return"".concat(e)},Int32:function(e){return Math.floor(e)},Int64:function(e){return e instanceof E?e:new E("".concat(e,"L"))},Guid:function(e){return e instanceof l.default?e:new l.default(e)},Boolean:function(e){return!!e},Single:function(e){return e instanceof E?e:new E(e+"f")},Decimal:function(e){return e instanceof E?e:new E(e+"m")}};t.keyConverters=M;t.convertPrimitiveValue=function(e,t){if(null===t)return null;var n=M[e];if(!n)throw c.errors.Error("E4014",e);return n(t)};t.generateSelect=function(e,t){if(t)return e<4?A(t.join()):(0,u.grep)(t,x,!0).join()};var B=function(e){var t=[];return(0,r.each)(e,(function(e,n){return t.push("".concat(e).concat(function e(t){var n="",i=[],o=[];return(0,r.each)(t,(function(t,n){Array.isArray(n)&&[].push.apply(i,n),(0,a.isPlainObject)(n)&&o.push("".concat(t).concat(e(n)))})),(i.length||o.length)&&(n+="(",i.length&&(n+="$select=".concat((0,r.map)(i,A).join())),o.length&&(i.length&&(n+=";"),n+="$expand=".concat((0,r.map)(o,A).join())),n+=")"),n}(n)))})),t.join()},L=function(e,t,n){return(0,r.each)(e,(function(e,i){return function e(t,n,i){var o=i(n,t.shift(),t);!1!==o&&e(t,o,i)}(i.split("."),t,n)}))};t.generateExpand=function(e,t,n){return e<4?function(e,t){var n={};return e&&(0,r.each)(b(e),(function(){n[A(this)]=1})),t&&(0,r.each)(b(t),(function(){var e=this.split(".");e.length<2||(e.pop(),n[A(e.join("."))]=1)})),(0,r.map)(n,(function(e,t){return t})).join()}(t,n):function(e,t){var n={};if(e||t)return e&&L(b(e),n,(function(e,t,n){return e[t]=e[t]||{},!!n.length&&e[t]})),t&&L((0,u.grep)(b(t),x),n,(function(e,t,n){return n.length?e[t]=e[t]||{}:(e[t]=e[t]||[],e[t].push(t),!1)})),B(n)}(t,n)};t.formatFunctionInvocationUrl=function(e,t){return(0,p.format)("{0}({1})",e,(0,r.map)(t||{},(function(e,t){return(0,p.format)("{0}={1}",t,e)})).join(","))};t.escapeServiceOperationParams=function(e,t){if(!e)return e;var n={};return(0,r.each)(e,(function(e,i){n[e]=R(i,t)})),n}},96687:function(e,t,n){t.default=void 0;var i=n(77549),o=function(){var e=Array.isArray(arguments[0])?"array":"remote";return i.queryImpl[e].apply(this,arguments)};t.default=o,e.exports=t.default,e.exports.default=t.default},16135:function(e,t){t.default=void 0;t.default={},e.exports=t.default,e.exports.default=t.default},77549:function(e,t,n){t.queryImpl=void 0;var i=a(n(35042)),o=a(n(41428));function a(e){return e&&e.__esModule?e:{default:e}}var r={array:i.default,remote:o.default};t.queryImpl=r},41428:function(e,t,n){t.default=void 0;var i=u(n(16135)),o=n(18438),a=n(95479),r=n(35922),s=n(62754),l=u(n(35042));function u(e){return e&&e.__esModule?e:{default:e}}var d=function e(t,n,u){u=u||[],n=n||{};var d=function(e,t){return{name:e,args:t}},c=function(e){var c,h,p,f,g,m,_,v=new s.Deferred,y=function(e){var t=n.errorHandler;t&&t(e),(0,o.handleError)(e),v.reject(e)};function b(e){switch(e.name){case"sortBy":return g=[e.args],!0;case"thenBy":if(!g)throw o.errors.Error("E4004");return g.push(e.args),!0}return!1}try{c=n.adapter,(0,r.isFunction)(c)||(c=i.default[c]),h=c(n),p=[].concat(u).concat(e);var x=h.optimize;for(x&&x(p);p.length;){if(!b(f=p[0])){if(g){p.unshift(d("multiSort",[g])),g=null;continue}if("enumerate"!==String(f.name)&&(!h[f.name]||!1===h[f.name].apply(h,f.args)))break}p.shift()}m=p[0],_=[],m&&"multiSort"===m.name&&(p.shift(),(0,a.each)(m.args[0],(function(){_.push(d(_.length?"thenBy":"sortBy",this))}))),p=_.concat(p),h.exec(t).done((function(e,t){if(p.length){var i=(0,l.default)(e,{errorHandler:n.errorHandler});(0,a.each)(p,(function(){i=i[this.name].apply(i,this.args)})),i.done(v.resolve).fail(v.reject)}else v.resolve(e,t)})).fail(y)}catch(e){y(e)}return v.promise()},h={};return(0,a.each)(["sortBy","thenBy","filter","slice","select","groupBy"],(function(){var i=String(this);h[i]=function(){return e(t,n,u.concat(d(i,arguments)))}})),(0,a.each)(["count","min","max","sum","avg","aggregate","enumerate"],(function(){var e=String(this);h[e]=function(){return c.call(this,d(e,arguments))}})),h};t.default=d,e.exports=t.default,e.exports.default=t.default},99236:function(e,t,n){t.default=void 0;var i,o=n(20576),a=n(13306),r=n(95479),s=(i=n(35042))&&i.__esModule?i:{default:i},l=n(16454);function u(e,t){return e=e.groupBy(t[0].selector),t.length>1&&(e=e.select((function(e){return(0,a.extend)({},e,{items:u((0,s.default)(e.items),t.slice(1)).toArray()})}))),e}function d(e,t){var n=[];return(0,r.each)(e,(function(e,i){(0,o.grep)(t,(function(e){return i.selector===e.selector})).length<1&&n.push(i)})),n.concat(t)}var c={multiLevelGroup:u,arrangeSortingInfo:d,queryByOptions:function(e,t,n){var i=(t=t||{}).filter;if(i&&(e=e.filter(i)),n)return e;var o=t.sort,a=t.select,s=t.group,c=t.skip,h=t.take;return s&&((s=(0,l.normalizeSortingInfo)(s)).keepInitialKeyOrder=!!t.group.keepInitialKeyOrder),(o||s)&&(o=(0,l.normalizeSortingInfo)(o||[]),s&&!s.keepInitialKeyOrder&&(o=d(s,o)),(0,r.each)(o,(function(t){e=e[t?"thenBy":"sortBy"](this.selector,this.desc,this.compare)}))),a&&(e=e.select(a)),s&&(e=u(e,s)),(h||c)&&(e=e.slice(c||0,h)),e}};t.default=c,e.exports=t.default,e.exports.default=t.default},16454:function(e,t,n){t.errorMessageFromXhr=t.base64_encode=t.aggregators=t.XHR_ERROR_UNLOAD=void 0,t.isConjunctiveOperator=function(e){return/^(and|&&|&)$/i.test(e)},t.isDisjunctiveOperator=function(e){return/^(or|\|\||\|)$/i.test(e)},t.rejectedPromise=t.processRequestResultLock=t.normalizeSortingInfo=t.normalizeBinaryCriterion=t.keysEqual=t.isUnaryOperation=t.isGroupCriterion=void 0,t.throttleChanges=function(e,t){var n=[],o=function(e,t){var n,o;return function(){var a=this;return o=arguments,n||(n=setTimeout((function(){n=void 0,o&&e.call(a,o)}),(0,i.isFunction)(t)?t():t)),n}}((function(){e.call(this,n),n=[]}),t);return function(e){var t,i;Array.isArray(e)&&(t=n).push.apply(t,function(e){if(Array.isArray(e))return c(e)}(i=e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(i)||function(e,t){if(e){if("string"==typeof e)return c(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?c(e,t):void 0}}(i)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}());return o.call(this,n)}},t.trivialPromise=void 0;var i=n(35922),o=d(n(73349)),a=d(n(24311)),r=n(58201),s=n(95479),l=n(62754),u=n(20576);function d(e){return e&&e.__esModule?e:{default:e}}function c(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}var h=a.default.add;t.XHR_ERROR_UNLOAD="DEVEXTREME_XHR_ERROR_UNLOAD";t.normalizeBinaryCriterion=function(e){return[e[0],e.length<3?"=":String(e[1]).toLowerCase(),e.length<2||e[e.length-1]]};t.normalizeSortingInfo=function(e){return Array.isArray(e)||(e=[e]),(0,s.map)(e,(function(e){var t={selector:(0,i.isFunction)(e)||"string"==typeof e?e:e.getter||e.field||e.selector,desc:!(!e.desc&&"d"!==String(e.dir).charAt(0).toLowerCase())};return e.compare&&(t.compare=e.compare),t}))};var p,f,g=(f={timeout:"Network connection timeout",error:"Unspecified network error",parsererror:"Unexpected server response"},h((function(){var e=(0,r.getWindow)();o.default.listen(e,"beforeunload",(function(){p=!0}))})),function(e,t){return p?"DEVEXTREME_XHR_ERROR_UNLOAD":e.status<400?function(e){var t=f[e];return t||e}(t):e.statusText});t.errorMessageFromXhr=g;var m={count:{seed:0,step:function(e){return 1+e}},sum:{seed:0,step:function(e,t){return e+t}},min:{step:function(e,t){return t<e?t:e}},max:{step:function(e,t){return t>e?t:e}},avg:{seed:[0,0],step:function(e,t){return[e[0]+t,e[1]+1]},finalize:function(e){return e[1]?e[0]/e[1]:NaN}}};t.aggregators=m;var _,v,y=(v=0,{obtain:function(){0===v&&(_=new l.Deferred),v++},release:function(){--v<1&&_.resolve()},promise:function(){return(0===v?(new l.Deferred).resolve():_).promise()},reset:function(){v=0,_&&_.resolve()}});t.processRequestResultLock=y;t.keysEqual=function(e,t,n){if(Array.isArray(e)){for(var i,o=(0,s.map)(t,(function(e,t){return t})),a=0;a<o.length;a++)if(i=o[a],!(0,u.equalByValue)(t[i],n[i],0,!1))return!1;return!0}return(0,u.equalByValue)(t,n,0,!1)};t.base64_encode=function(e){Array.isArray(e)||(e=function(e){var t,n,i=[];for(n=0;n<e.length;n++)(t=e.charCodeAt(n))<128?i.push(t):t<2048?i.push(192+(t>>6),128+(63&t)):t<65536?i.push(224+(t>>12),128+(t>>6&63),128+(63&t)):t<2097152&&i.push(240+(t>>18),128+(t>>12&63),128+(t>>6&63),128+(63&t));return i}(String(e)));var t="";function n(e){return"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(e)}for(var i=0;i<e.length;i+=3){var o=e[i],a=e[i+1],r=e[i+2];t+=(0,s.map)([o>>2,(3&o)<<4|a>>4,isNaN(a)?64:(15&a)<<2|r>>6,isNaN(r)?64:63&r],n).join("")}return t};t.isUnaryOperation=function(e){return"!"===e[0]&&Array.isArray(e[1])};t.isGroupCriterion=function(e){var t,n=e[0],o=e[1];return!!Array.isArray(n)||!(!(0,i.isFunction)(n)||!Array.isArray(o)&&!(0,i.isFunction)(o)&&"and"!==(t=o)&&"or"!==t)};t.trivialPromise=function(){var e=new l.Deferred;return e.resolve.apply(e,arguments).promise()};t.rejectedPromise=function(){var e=new l.Deferred;return e.reject.apply(e,arguments).promise()}},53305:function(e,t,n){t.default=void 0;var i=n(85273),o=n(13306),a=n(9234),r={postCtor:function(){this.on("disposing",function(){this._disposeDataSource()}.bind(this))},_refreshDataSource:function(){this._initDataSource(),this._loadDataSource()},_initDataSource:function(){var e,t,n="_getSpecificDataSourceOption"in this?this._getSpecificDataSourceOption():this.option("dataSource");this._disposeDataSource(),n&&(n instanceof i.DataSource?(this._isSharedDataSource=!0,this._dataSource=n):(e="_dataSourceOptions"in this?this._dataSourceOptions():{},t=this._dataSourceType?this._dataSourceType():i.DataSource,n=(0,a.normalizeDataSourceOptions)(n,{fromUrlLoadMode:"_dataSourceFromUrlLoadMode"in this&&this._dataSourceFromUrlLoadMode()}),this._dataSource=new t((0,o.extend)(!0,{},e,n))),"_normalizeDataSource"in this&&(this._dataSource=this._normalizeDataSource(this._dataSource)),this._addDataSourceHandlers())},_addDataSourceHandlers:function(){"_dataSourceChangedHandler"in this&&this._addDataSourceChangeHandler(),"_dataSourceLoadErrorHandler"in this&&this._addDataSourceLoadErrorHandler(),"_dataSourceLoadingChangedHandler"in this&&this._addDataSourceLoadingChangedHandler(),this._addReadyWatcher()},_addReadyWatcher:function(){this._dataSource.on("loadingChanged",function(e){this._ready&&this._ready(!e)}.bind(this))},_addDataSourceChangeHandler:function(){var e=this._dataSource;this._proxiedDataSourceChangedHandler=function(t){this._dataSourceChangedHandler(e.items(),t)}.bind(this),e.on("changed",this._proxiedDataSourceChangedHandler)},_addDataSourceLoadErrorHandler:function(){this._proxiedDataSourceLoadErrorHandler=this._dataSourceLoadErrorHandler.bind(this),this._dataSource.on("loadError",this._proxiedDataSourceLoadErrorHandler)},_addDataSourceLoadingChangedHandler:function(){this._proxiedDataSourceLoadingChangedHandler=this._dataSourceLoadingChangedHandler.bind(this),this._dataSource.on("loadingChanged",this._proxiedDataSourceLoadingChangedHandler)},_loadDataSource:function(){if(this._dataSource){var e=this._dataSource;e.isLoaded()?this._proxiedDataSourceChangedHandler&&this._proxiedDataSourceChangedHandler():e.load()}},_loadSingle:function(e,t){return e="this"===e?this._dataSource.key()||"this":e,this._dataSource.loadSingle(e,t)},_isLastPage:function(){return!this._dataSource||this._dataSource.isLastPage()||!this._dataSource._pageSize},_isDataSourceLoading:function(){return this._dataSource&&this._dataSource.isLoading()},_disposeDataSource:function(){this._dataSource&&(this._isSharedDataSource?(delete this._isSharedDataSource,this._proxiedDataSourceChangedHandler&&this._dataSource.off("changed",this._proxiedDataSourceChangedHandler),this._proxiedDataSourceLoadErrorHandler&&this._dataSource.off("loadError",this._proxiedDataSourceLoadErrorHandler),this._proxiedDataSourceLoadingChangedHandler&&this._dataSource.off("loadingChanged",this._proxiedDataSourceLoadingChangedHandler)):this._dataSource.dispose(),delete this._dataSource,delete this._proxiedDataSourceChangedHandler,delete this._proxiedDataSourceLoadErrorHandler,delete this._proxiedDataSourceLoadingChangedHandler)},getDataSource:function(){return this._dataSource||null}};t.default=r,e.exports=t.default,e.exports.default=t.default},95429:function(e,t,n){t.name=void 0;var i=f(n(68374)),o=f(n(55994)),a=f(n(20530)),r=f(n(73349)),s=n(3532),l=n(90057),u=n(39611),d=n(27575),c=f(n(93786)),h=f(n(31391)),p=f(n(82495));function f(e){return e&&e.__esModule?e:{default:e}}t.name="dxclick";l.requestAnimationFrame,l.cancelAnimationFrame;var g=null,m=null,_=function(){m=null},v=function(e){var t=e.originalEvent,n=m===t||t&&t.DXCLICK_FIRED;!(!e.which||1===e.which)||g||n||(t&&(t.DXCLICK_FIRED=!0),(0,d.unsubscribeNodesDisposing)(m,_),m=t,(0,d.subscribeNodesDisposing)(m,_),(0,u.fireEvent)({type:"dxclick",originalEvent:e}))},y=h.default.inherit({ctor:function(e){this.callBase(e),o.default.on(this.getElement(),"click",v)},start:function(e){g=null},cancel:function(){g=!0},dispose:function(){o.default.off(this.getElement(),"click",v)}});!function(){if(!a.default.real().generic){var e=null,t=!1,n=r.default.getDocument();o.default.subscribeGlobal(n,(0,u.addNamespace)(c.default.down,"NATIVE_CLICK_FIXER"),(function(n){e=n.target,t=n.isDefaultPrevented()})),o.default.subscribeGlobal(n,(0,u.addNamespace)("click","NATIVE_CLICK_FIXER"),(function(n){var o,a=(0,i.default)(n.target);t||!e||a.is(e)||(0,i.default)(e).is("label")||(o=a,!(0,i.default)(o).is("input, textarea, select, button ,:focus, :focus *"))||(0,s.resetActiveElement)(),e=null,t=!1}))}}(),(0,p.default)({emitter:y,bubble:!0,events:["dxclick"]})},49166:function(e,t,n){t.name=void 0;var i=c(n(68374)),o=c(n(55994)),a=n(60137),r=c(n(20530)),s=c(n(38377)),l=c(n(85788)),u=n(39611),d=c(n(11699));function c(e){return e&&e.__esModule?e:{default:e}}var h=(0,u.addNamespace)("contextmenu","dxContexMenu"),p=(0,u.addNamespace)(d.default.name,"dxContexMenu"),f=s.default.inherit({setup:function(e){var t=(0,i.default)(e);o.default.on(t,h,this._contextMenuHandler.bind(this)),(a.touch||r.default.isSimulator())&&o.default.on(t,p,this._holdHandler.bind(this))},_holdHandler:function(e){(0,u.isMouseEvent)(e)&&!r.default.isSimulator()||this._fireContextMenu(e)},_contextMenuHandler:function(e){this._fireContextMenu(e)},_fireContextMenu:function(e){return(0,u.fireEvent)({type:"dxcontextmenu",originalEvent:e})},teardown:function(e){o.default.off(e,".dxContexMenu")}});(0,l.default)("dxcontextmenu",new f);t.name="dxcontextmenu"},91633:function(e,t,n){t.lock=t.inactive=t.active=void 0;var i=c(n(38377)),o=n(20576),a=n(3532),r=c(n(20530)),s=n(39611),l=c(n(93786)),u=c(n(31391)),d=c(n(82495));function c(e){return e&&e.__esModule?e:{default:e}}t.active="dxactive";t.inactive="dxinactive";var h,p=i.default.inherit({ctor:function(e,t){this._timeout=e,this._fire=t},start:function(){var e=this;this._schedule((function(){e.force()}))},_schedule:function(e){this.stop(),this._timer=setTimeout(e,this._timeout)},stop:function(){clearTimeout(this._timer)},force:function(){this._fired||(this.stop(),this._fire(),this._fired=!0)},fired:function(){return this._fired}}),f=u.default.inherit({ctor:function(){this.callBase.apply(this,arguments),this._active=new p(0,o.noop),this._inactive=new p(0,o.noop)},configure:function(e,t){switch(t){case"dxactive":e.activeTimeout=e.timeout;break;case"dxinactive":e.inactiveTimeout=e.timeout}this.callBase(e)},start:function(e){if(h){var t=(0,a.contains)(this.getElement().get(0),h.getElement().get(0)),n=!h._active.fired();if(t&&n)return void this._cancel();h._inactive.force()}h=this,this._initEvents(e),this._active.start()},_initEvents:function(e){var t=this,n=this._getEmitterTarget(e),i=(0,s.isMouseEvent)(e),a=r.default.isSimulator()||!i,l=(0,o.ensureDefined)(this.activeTimeout,30),u=(0,o.ensureDefined)(this.inactiveTimeout,400);this._active=new p(a?l:0,(function(){t._fireEvent("dxactive",e,{target:n})})),this._inactive=new p(a?u:0,(function(){t._fireEvent("dxinactive",e,{target:n}),h=null}))},cancel:function(e){this.end(e)},end:function(e){var t=e.type!==l.default.up;t?this._active.stop():this._active.force(),this._inactive.start(),t&&this._inactive.force()},dispose:function(){this._active.stop(),this._inactive.stop(),h===this&&(h=null),this.callBase()},lockInactive:function(){return this._active.force(),this._inactive.stop(),h=null,this._cancel(),this._inactive.force.bind(this._inactive)}});f.lock=function(e){var t=h?h.lockInactive():o.noop;e.done(t)},(0,d.default)({emitter:f,events:["dxactive","dxinactive"]});var g=f.lock;t.lock=g},31391:function(e,t,n){t.default=void 0;var i=u(n(68374)),o=n(20576),a=u(n(38377)),r=u(n(44504)),s=n(13306),l=n(39611);function u(e){return e&&e.__esModule?e:{default:e}}var d=a.default.inherit({ctor:function(e){this._$element=(0,i.default)(e),this._cancelCallback=(0,r.default)(),this._acceptCallback=(0,r.default)()},getElement:function(){return this._$element},validate:function(e){return!(0,l.isDxMouseWheelEvent)(e)},validatePointers:function(e){return 1===(0,l.hasTouches)(e)},allowInterruptionByMouseWheel:function(){return!0},configure:function(e){(0,s.extend)(this,e)},addCancelCallback:function(e){this._cancelCallback.add(e)},removeCancelCallback:function(){this._cancelCallback.empty()},_cancel:function(e){this._cancelCallback.fire(this,e)},addAcceptCallback:function(e){this._acceptCallback.add(e)},removeAcceptCallback:function(){this._acceptCallback.empty()},_accept:function(e){this._acceptCallback.fire(this,e)},_requestAccept:function(e){this._acceptRequestEvent=e},_forgetAccept:function(){this._accept(this._acceptRequestEvent),this._acceptRequestEvent=null},start:o.noop,move:o.noop,end:o.noop,cancel:o.noop,reset:function(){this._acceptRequestEvent&&this._accept(this._acceptRequestEvent)},_fireEvent:function(e,t,n){var i=(0,s.extend)({type:e,originalEvent:t,target:this._getEmitterTarget(t),delegateTarget:this.getElement().get(0)},n);return(t=(0,l.fireEvent)(i)).cancel&&this._cancel(t),t},_getEmitterTarget:function(e){return(this.delegateSelector?(0,i.default)(e.target).closest(this.delegateSelector):this.getElement()).get(0)},dispose:o.noop});t.default=d,e.exports=t.default,e.exports.default=t.default},82495:function(e,t,n){t.default=void 0;var i=g(n(68374)),o=g(n(24311)),a=g(n(73349)),r=g(n(55994)),s=n(97906),l=g(n(38377)),u=n(13306),d=n(95479),c=g(n(85788)),h=n(39611),p=g(n(93786)),f=n(765);function g(e){return e&&e.__esModule?e:{default:e}}var m=new(l.default.inherit({ctor:function(){this._attachHandlers(),this.reset(),this._proxiedCancelHandler=this._cancelHandler.bind(this),this._proxiedAcceptHandler=this._acceptHandler.bind(this)},_attachHandlers:function(){o.default.add(function(){var e=a.default.getDocument();r.default.subscribeGlobal(e,(0,h.addNamespace)(p.default.down,"dxEventManager"),this._pointerDownHandler.bind(this)),r.default.subscribeGlobal(e,(0,h.addNamespace)(p.default.move,"dxEventManager"),this._pointerMoveHandler.bind(this)),r.default.subscribeGlobal(e,(0,h.addNamespace)([p.default.up,p.default.cancel].join(" "),"dxEventManager"),this._pointerUpHandler.bind(this)),r.default.subscribeGlobal(e,(0,h.addNamespace)(f.name,"dxEventManager"),this._mouseWheelHandler.bind(this))}.bind(this))},_eachEmitter:function(e){for(var t=this._activeEmitters||[],n=0;t.length>n;){var i=t[n];if(!1===e(i))break;t[n]===i&&n++}},_applyToEmitters:function(e,t){this._eachEmitter((function(n){n[e].call(n,t)}))},reset:function(){this._eachEmitter(this._proxiedCancelHandler),this._activeEmitters=[]},resetEmitter:function(e){this._proxiedCancelHandler(e)},_pointerDownHandler:function(e){(0,h.isMouseEvent)(e)&&e.which>1||this._updateEmitters(e)},_updateEmitters:function(e){this._isSetChanged(e)&&(this._cleanEmitters(e),this._fetchEmitters(e))},_isSetChanged:function(e){var t=this._closestEmitter(e),n=this._emittersSet||[],i=t.length!==n.length;return(0,d.each)(t,(function(e,t){return!(i=i||n[e]!==t)})),this._emittersSet=t,i},_closestEmitter:function(e){var t=this,n=[],o=(0,i.default)(e.target);function a(i,o){o&&o.validatePointers(e)&&o.validate(e)&&(o.addCancelCallback(t._proxiedCancelHandler),o.addAcceptCallback(t._proxiedAcceptHandler),n.push(o))}for(;o.length;){var r=(0,s.data)(o.get(0),"dxEmitter")||[];(0,d.each)(r,a),o=o.parent()}return n},_acceptHandler:function(e,t){var n=this;this._eachEmitter((function(i){i!==e&&n._cancelEmitter(i,t)}))},_cancelHandler:function(e,t){this._cancelEmitter(e,t)},_cancelEmitter:function(e,t){var n=this._activeEmitters;t?e.cancel(t):e.reset(),e.removeCancelCallback(),e.removeAcceptCallback();var i=n.indexOf(e);i>-1&&n.splice(i,1)},_cleanEmitters:function(e){this._applyToEmitters("end",e),this.reset(e)},_fetchEmitters:function(e){this._activeEmitters=this._emittersSet.slice(),this._applyToEmitters("start",e)},_pointerMoveHandler:function(e){this._applyToEmitters("move",e)},_pointerUpHandler:function(e){this._updateEmitters(e)},_mouseWheelHandler:function(e){this._allowInterruptionByMouseWheel()&&(e.pointers=[null],this._pointerDownHandler(e),this._adjustWheelEvent(e),this._pointerMoveHandler(e),e.pointers=[],this._pointerUpHandler(e))},_allowInterruptionByMouseWheel:function(){var e=!0;return this._eachEmitter((function(t){return e=t.allowInterruptionByMouseWheel()&&e})),e},_adjustWheelEvent:function(e){var t=null;if(this._eachEmitter((function(n){if(n.gesture){var i=n.getDirection(e);return"horizontal"!==i&&!e.shiftKey||"vertical"!==i&&e.shiftKey?(t=n,!1):void 0}})),t){var n=t.getDirection(e),i="both"===n&&!e.shiftKey||"vertical"===n;e[i?"pageY":"pageX"]+=e.delta}},isActive:function(e){var t=!1;return this._eachEmitter((function(n){t=t||n.getElement().is(e)})),t}})),_=function(e){var t=e.emitter,n=e.events[0],i=e.events;(0,d.each)(i,(function(o,a){(0,c.default)(a,{noBubble:!e.bubble,setup:function(e){var i=(0,s.data)(e,"dxEmitterSubscription")||{},o=(0,s.data)(e,"dxEmitter")||{},r=o[n]||new t(e);i[a]=!0,o[n]=r,(0,s.data)(e,"dxEmitter",o),(0,s.data)(e,"dxEmitterSubscription",i)},add:function(e,t){(0,s.data)(e,"dxEmitter")[n].configure((0,u.extend)({delegateSelector:t.selector},t.data),t.type)},teardown:function(e){var t=(0,s.data)(e,"dxEmitterSubscription"),o=(0,s.data)(e,"dxEmitter"),r=o[n];delete t[a];var l=!0;(0,d.each)(i,(function(e,n){return l=l&&!t[n]})),l&&(m.isActive(e)&&m.resetEmitter(r),r&&r.dispose(),delete o[n])}})}))};t.default=_,e.exports=t.default,e.exports.default=t.default},85788:function(e,t,n){t.default=void 0;var i,o=n(95479),a=(i=n(94553))&&i.__esModule?i:{default:i};var r=function(e,t){var n={};"noBubble"in t&&(n.noBubble=t.noBubble),"bindType"in t&&(n.bindType=t.bindType),"delegateType"in t&&(n.delegateType=t.delegateType),(0,o.each)(["setup","teardown","add","remove","trigger","handle","_default","dispose"],(function(e,i){t[i]&&(n[i]=function(){var e=[].slice.call(arguments);return e.unshift(this),t[i].apply(t,e)})})),a.default.fire(e,n)};r.callbacks=a.default;var s=r;t.default=s,e.exports=t.default,e.exports.default=t.default},94553:function(e,t,n){var i;t.default=void 0;var o=new(((i=n(83358))&&i.__esModule?i:{default:i}).default);t.default=o,e.exports=t.default,e.exports.default=t.default},55994:function(e,t,n){t.default=void 0;var i=p(n(94553)),o=n(13306),a=p(n(73349)),r=n(58201),s=p(n(20476)),l=n(35922),u=p(n(44504)),d=p(n(17381)),c=p(n(2418)),h=p(n(39618));function p(e){return e&&e.__esModule?e:{default:e}}function f(e){return(f="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function g(){return(g=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(e[i]=n[i])}return e}).apply(this,arguments)}var m=(0,r.getWindow)(),_={mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},v={focusin:"focus",focusout:"blur"},y=["blur","focus","load"],b=["touchmove","wheel","mousewheel","touchstart"];function x(e,t){return!(0,l.isWindow)(e)&&"#document"!==e.nodeName&&a.default.elementMatches(e,t)}var w,C,S,k=new WeakMap,D=0,I=(C={},i.default.add((function(e,t){C[e]=t})),{getField:function(e,t){return C[e]&&C[e][t]},callMethod:function(e,t,n,i){return C[e]&&C[e][t]&&C[e][t].apply(n,i)}}),T=(0,s.default)({on:O(M(L((function(e,t,n,i,o){P(e,t).addHandler(o,n,i)})))),one:O(M((function(e,t,n,i,o){T.on(e,t,n,i,(function i(){T.off(e,t,n,i),o.apply(this,arguments)}))}))),off:O((S=L((function(e,t,n,i){P(e,t).removeHandler(i,n)})),function(e,t,n,i){"function"==typeof n&&(i=n,n=void 0),S(e,t,n,i)})),trigger:O(B((function(e,t,n){var i=t.type,a=P(e,t.type);if(I.callMethod(i,"trigger",e,[t,n]),a.callHandlers(t,n),!(I.getField(i,"noBubble")||t.isPropagationStopped()||-1!==y.indexOf(i))){var r=[];!function e(t){var n,i=null!==(n=t.parentNode)&&void 0!==n?n:t.host;i&&(r.push(i),e(i))}(e),r.push(m);for(var s=0;r[s]&&!t.isPropagationStopped();){P(r[s],t.type).callHandlers((0,o.extend)(t,{currentTarget:r[s]}),n),s++}}(e.nodeType||(0,l.isWindow)(e))&&(I.callMethod(i,"_default",e,[t,n]),function(e,t){var n=v[e]||e;if(function(e,t){return"click"===e&&"a"===t.localName}(e,t))return;(0,l.isFunction)(t[n])&&(w=e,t[n](),w=void 0)}(i,e))}))),triggerHandler:O(B((function(e,t,n){P(e,t.type).callHandlers(t,n)})))});function E(e,t){var n=e[0];if(n)if(a.default.isNode(n)||(0,l.isWindow)(n))t.apply(T,e);else{if((0,l.isString)(n)||!("length"in n))throw d.default.Error("E0025");var i=Array.prototype.slice.call(e,0);Array.prototype.forEach.call(n,(function(e){i[0]=e,E(i,t)}))}}function O(e){return function(){E(arguments,e)}}var A=(0,h.default)((function(){var e=!1;try{var t=Object.defineProperty({},"passive",{get:function(){return e=!0,!0}});m.addEventListener("test",null,t)}catch(e){}return e}));function P(e,t){var n=k.get(e),i=(t=t||"").split("."),o=i.slice(1),r=!!i[0];t=i[0]||"dxEmptyEventType",n||(n={},k.set(e,n)),n[t]||(n[t]={handleObjects:[],nativeHandler:null});var s=n[t];return{addHandler:function(n,i,u){var d=function(i,o){var a,r,s=[i],d=i.currentTarget,c=i.relatedTarget;t in _&&(a=c&&d&&(c===d||function e(t,n){return(0,l.isWindow)(t)?e(t.document,n):t.contains?t.contains(n):!!(n.compareDocumentPosition(t)&n.DOCUMENT_POSITION_CONTAINS)}(d,c))),void 0!==o&&s.push(o),I.callMethod(t,"handle",e,[i,u]),a||(r=n.apply(d,s)),!1===r&&(i.preventDefault(),i.stopPropagation())},c={handler:n,wrappedHandler:function(t,n){if(!w||t.type!==w)if(t.data=u,t.delegateTarget=e,i)for(var o=t.target;o&&o!==e;)x(o,i)&&(t.currentTarget=o,d(t,n)),o=o.parentNode;else t.currentTarget=t.delegateTarget||t.target,d(t,n)},selector:i,type:t,data:u,namespace:o.join("."),namespaces:o,guid:++D};s.handleObjects.push(c);var h,p,f=1===s.handleObjects.length&&r;f&&(f=!I.callMethod(t,"setup",e,[u,o,n])),f&&(s.nativeHandler=(p=t,function(e,t){var n=P(this,p);e=T.Event(e),n.callHandlers(e,t)}),A()&&b.indexOf(t)>-1&&(h={passive:!1}),s.removeListener=a.default.listen(e,_[t]||t,s.nativeHandler,h)),I.callMethod(t,"add",e,[c])},removeHandler:function(i,a){var s=function(t){var r,s=n[t];s.handleObjects.length?(s.handleObjects=s.handleObjects.filter((function(n){var s=o.length&&!R(n.namespaces,o)||i&&n.handler!==i||a&&n.selector!==a;return s||(r=n.handler,I.callMethod(t,"remove",e,[n])),s})),!s.handleObjects.length&&"dxEmptyEventType"!==t&&(I.callMethod(t,"teardown",e,[o,r]),s.nativeHandler&&s.removeListener(),delete n[t])):delete n[t]};if(r)s(t);else for(var l in n)s(l);0===Object.keys(n).length&&k.delete(e)},callHandlers:function(e,t){var i=!1,a=function(n){i||o.length&&!R(n.namespaces,o)||(n.wrappedHandler(e,t),i=e.isImmediatePropagationStopped())};s.handleObjects.forEach(a),o.length&&n.dxEmptyEventType&&n.dxEmptyEventType.handleObjects.forEach(a)}}}function R(e,t){for(var n=0;n<t.length;n++)if(e.indexOf(t[n])<0)return!1;return!0}function M(e){return function(t,n,i,o,a){a||(a=o,o=void 0),"string"!=typeof i&&(o=i,i=void 0),a||"string"!=typeof n||(a=o||i,i=void 0,o=void 0),e(t,n,i,o,a)}}function B(e){return function(t,n,i){"string"==typeof n&&(n={type:n}),n.target||(n.target=t),n.currentTarget=t,n.delegateTarget||(n.delegateTarget=t),!n.type&&n.originalEvent&&(n.type=n.originalEvent.type),e(t,n instanceof T.Event?n:T.Event(n),i)}}function L(e){var t=function(t,n){if(n&&n.indexOf(" ")>-1){var i=Array.prototype.slice.call(arguments,0);n.split(" ").forEach((function(t){i[1]=t,e.apply(this,i)}))}else e.apply(this,arguments)};return function(e,n){if("object"===f(n)){var i=Array.prototype.slice.call(arguments,0);for(var o in n)i[1]=o,i[i.length-1]=n[o],t.apply(this,i)}else t.apply(this,arguments)}}function V(e){if(function(e){return null==e.which&&0===e.type.indexOf("key")}(e))return null!=e.charCode?e.charCode:e.keyCode;if(function(e){return!e.which&&void 0!==e.button&&/^(?:mouse|pointer|contextmenu|drag|drop)|click/.test(e.type)}(e)){return{1:1,2:3,3:1,4:2}[e.button]}return e.which}function F(e){e&&(T.Event=e,T.Event.prototype=e.prototype)}function H(e,t,n){Object.defineProperty(n||T.Event.prototype,e,{enumerable:!0,configurable:!0,get:function(){return this.originalEvent&&t(this.originalEvent)},set:function(t){Object.defineProperty(this,e,{enumerable:!0,configurable:!0,writable:!0,value:t})}})}F(function(e){return T.Event=function(t,n){if(!(this instanceof T.Event))return new T.Event(t,n);t||(t={}),"string"==typeof t&&(t={type:t}),n||(n={}),e.call(this,t,n)},g(T.Event.prototype,{_propagationStopped:!1,_immediatePropagationStopped:!1,_defaultPrevented:!1,isPropagationStopped:function(){return!!(this._propagationStopped||this.originalEvent&&this.originalEvent.propagationStopped)},stopPropagation:function(){this._propagationStopped=!0,this.originalEvent&&this.originalEvent.stopPropagation()},isImmediatePropagationStopped:function(){return this._immediatePropagationStopped},stopImmediatePropagation:function(){this.stopPropagation(),this._immediatePropagationStopped=!0,this.originalEvent&&this.originalEvent.stopImmediatePropagation()},isDefaultPrevented:function(){return!!(this._defaultPrevented||this.originalEvent&&this.originalEvent.defaultPrevented)},preventDefault:function(){this._defaultPrevented=!0,this.originalEvent&&this.originalEvent.preventDefault()}}),T.Event}((function(e,t){var n;e instanceof T.Event||(0,r.hasWindow)()&&e instanceof m.Event||(null===(n=e.view)||void 0===n?void 0:n.Event)&&e instanceof e.view.Event?(this.originalEvent=e,this.type=e.type,this.currentTarget=void 0,Object.prototype.hasOwnProperty.call(e,"isTrusted")&&(this.isTrusted=e.isTrusted),this.timeStamp=e.timeStamp||Date.now()):g(this,e),H("which",V,this),0===e.type.indexOf("touch")&&(delete t.pageX,delete t.pageY),g(this,t),this.guid=++D}))),["target","relatedTarget","delegateTarget","altKey","bubbles","cancelable","changedTouches","ctrlKey","detail","eventPhase","metaKey","shiftKey","view","char","code","charCode","key","keyCode","button","buttons","offsetX","offsetY","pointerId","pointerType","targetTouches","toElement","touches"].forEach((function(e){return H(e,(function(t){return t[e]}))})),(0,c.default)(H);var N=(0,u.default)(),z=(0,u.default)();T.set=function(e){N.fire(),T.inject(e),F(e.Event),z.fire()},T.subscribeGlobal=function(){E(arguments,M((function(){var e=arguments;T.on.apply(this,e),N.add((function(){var t=Array.prototype.slice.call(e,0);t.splice(3,1),T.off.apply(this,t)})),z.add((function(){T.on.apply(this,e)}))})))},T.forcePassiveFalseEventNames=b,T.passiveEventHandlersSupported=A;var W=T;t.default=W,e.exports=t.default,e.exports.default=t.default},2418:function(e,t){t.default=function(e){n.forEach((function(t){e(t,(function(e){return function(e,t){if(t[e]&&!t.touches||!t.touches)return t[e];var n=t.touches.length?t.touches:t.changedTouches;if(!n.length)return;return n[0][e]}(t,e)}))}),this)};var n=["pageX","pageY","screenX","screenY","clientX","clientY"];e.exports=t.default,e.exports.default=t.default},51661:function(e,t,n){t.default=void 0;var i=s(n(68374)),o=s(n(55994)),a=s(n(38377)),r=n(39611);function s(e){return e&&e.__esModule?e:{default:e}}var l=function(e){return{keyName:(0,r.normalizeKeyName)(e),key:e.key,code:e.code,ctrl:e.ctrlKey,location:e.location,metaKey:e.metaKey,shift:e.shiftKey,alt:e.altKey,which:e.which,originalEvent:e}},u=a.default.inherit({_keydown:(0,r.addNamespace)("keydown","KeyboardProcessor"),_compositionStart:(0,r.addNamespace)("compositionstart","KeyboardProcessor"),_compositionEnd:(0,r.addNamespace)("compositionend","KeyboardProcessor"),ctor:function(e){var t=this;(e=e||{}).element&&(this._element=(0,i.default)(e.element)),e.focusTarget&&(this._focusTarget=e.focusTarget),this._handler=e.handler,this._element&&(this._processFunction=function(e){var n=(0,i.default)(t._focusTarget).toArray(),o=t._focusTarget&&t._focusTarget!==e.target&&!n.includes(e.target),a=t._isComposingJustFinished&&229===e.which||t._isComposing||o;t._isComposingJustFinished=!1,a||t.process(e)},this._toggleProcessingWithContext=this.toggleProcessing.bind(this),o.default.on(this._element,this._keydown,this._processFunction),o.default.on(this._element,this._compositionStart,this._toggleProcessingWithContext),o.default.on(this._element,this._compositionEnd,this._toggleProcessingWithContext))},dispose:function(){this._element&&(o.default.off(this._element,this._keydown,this._processFunction),o.default.off(this._element,this._compositionStart,this._toggleProcessingWithContext),o.default.off(this._element,this._compositionEnd,this._toggleProcessingWithContext)),this._element=void 0,this._handler=void 0},process:function(e){this._handler(l(e))},toggleProcessing:function(e){var t=e.type;this._isComposing="compositionstart"===t,this._isComposingJustFinished=!this._isComposing}});u.createKeyDownOptions=l;var d=u;t.default=d,e.exports=t.default,e.exports.default=t.default},765:function(e,t,n){t.name=void 0;var i=s(n(68374)),o=s(n(55994)),a=s(n(85788)),r=n(39611);function s(e){return e&&e.__esModule?e:{default:e}}t.name="dxmousewheel";var l={setup:function(e){var t=(0,i.default)(e);o.default.on(t,(0,r.addNamespace)("wheel","dxWheel"),l._wheelHandler.bind(l))},teardown:function(e){o.default.off(e,".".concat("dxWheel"))},_wheelHandler:function(e){var t=e.originalEvent,n=t.deltaMode,i=t.deltaY,o=t.deltaX,a=t.deltaZ;(0,r.fireEvent)({type:"dxmousewheel",originalEvent:e,delta:this._normalizeDelta(i,n),deltaX:o,deltaY:i,deltaZ:a,deltaMode:n,pointerType:"mouse"}),e.stopPropagation()},_normalizeDelta:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;return 0===t?-e:-30*e}};(0,a.default)("dxmousewheel",l)},85272:function(e,t,n){t.name=void 0;var i=d(n(55994)),o=n(3532),a=d(n(73349)),r=d(n(38377)),s=d(n(85788)),l=n(95429),u=n(39611);function d(e){return e&&e.__esModule?e:{default:e}}t.name="dxdblclick";var c=(0,u.addNamespace)(l.name,"dxDblClick"),h=r.default.inherit({ctor:function(){this._handlerCount=0,this._forgetLastClick()},_forgetLastClick:function(){this._firstClickTarget=null,this._lastClickTimeStamp=-300},add:function(){this._handlerCount<=0&&i.default.on(a.default.getDocument(),c,this._clickHandler.bind(this)),this._handlerCount++},_clickHandler:function(e){var t=e.timeStamp||Date.now(),n=t-this._lastClickTimeStamp;!(n<0)&&n<300?((0,u.fireEvent)({type:"dxdblclick",target:(0,o.closestCommonParent)(this._firstClickTarget,e.target),originalEvent:e}),this._forgetLastClick()):(this._firstClickTarget=e.target,this._lastClickTimeStamp=t)},remove:function(){this._handlerCount--,this._handlerCount<=0&&(this._forgetLastClick(),i.default.off(a.default.getDocument(),c))}});(0,s.default)("dxdblclick",new h)},23174:function(e,t,n){function i(e){return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}t.start=t.move=t.leave=t.enter=t.end=t.drop=void 0;var o=f(n(68374)),a=n(97906),r=n(89386),s=function(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!==i(e)&&"function"!=typeof e)return{default:e};var n=p(t);if(n&&n.has(e))return n.get(e);var o={},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var r in e)if("default"!==r&&Object.prototype.hasOwnProperty.call(e,r)){var s=a?Object.getOwnPropertyDescriptor(e,r):null;s&&(s.get||s.set)?Object.defineProperty(o,r,s):o[r]=e[r]}o.default=e,n&&n.set(e,o);return o}(n(95479)),l=n(3532),u=f(n(85788)),d=n(39611),c=f(n(98621)),h=f(n(82495));function p(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,n=new WeakMap;return(p=function(e){return e?n:t})(e)}function f(e){return e&&e.__esModule?e:{default:e}}t.start="dxdragstart";t.move="dxdrag";t.end="dxdragend";var g="dxdragenter";t.enter=g;var m="dxdragleave";t.leave=m;var _="dxdrop";t.drop=_;var v=[],y=[],b=[],x={setup:function(e,t){v.includes(e)||(v.push(e),y.push([]),b.push(t||{}))},add:function(e,t){var n=v.indexOf(e);this.updateEventsCounter(e,t.type,1);var i=t.selector;y[n].includes(i)||y[n].push(i)},updateEventsCounter:function(e,t,n){if([g,m,_].indexOf(t)>-1){var i=(0,a.data)(e,"dxDragEventsCount")||0;(0,a.data)(e,"dxDragEventsCount",Math.max(0,i+n))}},remove:function(e,t){this.updateEventsCounter(e,t.type,-1)},teardown:function(e){if(!(0,a.data)(e,"dxDragEventsCount")){var t=v.indexOf(e);v.splice(t,1),y.splice(t,1),b.splice(t,1),(0,a.removeData)(e,"dxDragEventsCount")}}};(0,u.default)(g,x),(0,u.default)(m,x),(0,u.default)(_,x);var w=c.default.inherit({ctor:function(e){this.callBase(e),this.direction="both"},_init:function(e){this._initEvent=e},_start:function(e){e=this._fireEvent("dxdragstart",this._initEvent),this._maxLeftOffset=e.maxLeftOffset,this._maxRightOffset=e.maxRightOffset,this._maxTopOffset=e.maxTopOffset,this._maxBottomOffset=e.maxBottomOffset;var t=(0,r.wrapToArray)(e.targetElements||(null===e.targetElements?[]:v));this._dropTargets=s.map(t,(function(e){return(0,o.default)(e).get(0)}))},_move:function(e){var t=(0,d.eventData)(e),n=this._calculateOffset(t);e=this._fireEvent("dxdrag",e,{offset:n}),this._processDropTargets(e),e._cancelPreventDefault||e.preventDefault()},_calculateOffset:function(e){return{x:this._calculateXOffset(e),y:this._calculateYOffset(e)}},_calculateXOffset:function(e){if("vertical"!==this.direction){var t=e.x-this._startEventData.x;return this._fitOffset(t,this._maxLeftOffset,this._maxRightOffset)}return 0},_calculateYOffset:function(e){if("horizontal"!==this.direction){var t=e.y-this._startEventData.y;return this._fitOffset(t,this._maxTopOffset,this._maxBottomOffset)}return 0},_fitOffset:function(e,t,n){return null!=t&&(e=Math.max(e,-t)),null!=n&&(e=Math.min(e,n)),e},_processDropTargets:function(e){var t=this._findDropTarget(e);t===this._currentDropTarget||(this._fireDropTargetEvent(e,m),this._currentDropTarget=t,this._fireDropTargetEvent(e,g))},_fireDropTargetEvent:function(e,t){if(this._currentDropTarget){var n={type:t,originalEvent:e,draggingElement:this._$element.get(0),target:this._currentDropTarget};(0,d.fireEvent)(n)}},_findDropTarget:function(e){var t,n=this;return s.each(v,(function(i,a){if(n._checkDropTargetActive(a)){var r,l,u,d,c=(0,o.default)(a);s.each((r=c,l=v.indexOf(r.get(0)),u=y[l].filter((function(e){return e})),d=r.find(u.join(", ")),y[l].includes(void 0)&&(d=d.add(r)),d),(function(i,a){var r=(0,o.default)(a);n._checkDropTarget(function(e){var t=v.indexOf(e.get(0));return b[t]}(c),r,(0,o.default)(t),e)&&(t=a)}))}})),t},_checkDropTargetActive:function(e){var t=!1;return s.each(this._dropTargets,(function(n,i){return!(t=t||i===e||(0,l.contains)(i,e))})),t},_checkDropTarget:function(e,t,n,i){if(t.get(0)===(0,o.default)(i.target).get(0))return!1;var a,r,s=(r=t,(a=e).itemPositionFunc?a.itemPositionFunc(r):r.offset());if(i.pageX<s.left)return!1;if(i.pageY<s.top)return!1;var l=function(e,t){return e.itemSizeFunc?e.itemSizeFunc(t):{width:t.get(0).getBoundingClientRect().width,height:t.get(0).getBoundingClientRect().height}}(e,t);return!(i.pageX>s.left+l.width)&&(!(i.pageY>s.top+l.height)&&((!n.length||!n.closest(t).length)&&(!(e.checkDropTarget&&!e.checkDropTarget(t,i))&&t)))},_end:function(e){var t=(0,d.eventData)(e);this._fireEvent("dxdragend",e,{offset:this._calculateOffset(t)}),this._fireDropTargetEvent(e,_),delete this._currentDropTarget}});(0,h.default)({emitter:w,events:["dxdragstart","dxdrag","dxdragend"]})},98621:function(e,t,n){t.default=void 0;var i=g(n(68374)),o=g(n(55994)),a=g(n(20530)),r=n(80968),s=g(n(39618)),l=n(3532),u=g(n(24311)),d=n(60810),c=n(20576),h=n(35922),p=n(39611),f=g(n(31391));function g(e){return e&&e.__esModule?e:{default:e}}var m=u.default.add,_=Math.abs,v=10,y=(0,s.default)((function(){var e="desktop"===a.default.real().deviceType;if(!(0,r.styleProp)("pointer-events")||!e)return c.noop;var t=(0,i.default)("<div>").addClass("dx-gesture-cover").css("pointerEvents","none");return o.default.subscribeGlobal(t,"dxmousewheel",(function(e){e.preventDefault()})),m((function(){t.appendTo("body")})),function(e,n){t.css("pointerEvents",e?"all":"none"),e&&t.css("cursor",n)}})),b=f.default.inherit({gesture:!0,configure:function(e){this.getElement().css("msTouchAction",e.immediate?"pinch-zoom":""),this.callBase(e)},allowInterruptionByMouseWheel:function(){return 2!==this._stage},getDirection:function(){return this.direction},_cancel:function(){this.callBase.apply(this,arguments),this._toggleGestureCover(!1),this._stage=0},start:function(e){e._needSkipEvent||(0,p.needSkipEvent)(e)?this._cancel(e):(this._startEvent=(0,p.createEvent)(e),this._startEventData=(0,p.eventData)(e),this._stage=1,this._init(e),this._setupImmediateTimer())},_setupImmediateTimer:function(){clearTimeout(this._immediateTimer),this._immediateAccepted=!1,this.immediate&&(this._immediateTimer=setTimeout(function(){this._immediateAccepted=!0}.bind(this),180))},move:function(e){if(1===this._stage&&this._directionConfirmed(e)){if(this._stage=2,this._resetActiveElement(),this._toggleGestureCover(!0),this._clearSelection(e),this._adjustStartEvent(e),this._start(this._startEvent),0===this._stage)return;this._requestAccept(e),this._move(e),this._forgetAccept()}else 2===this._stage&&(this._clearSelection(e),this._move(e))},_directionConfirmed:function(e){var t=this._getTouchBoundary(e),n=(0,p.eventDelta)(this._startEventData,(0,p.eventData)(e)),i=_(n.x),o=_(n.y),a=this._validateMove(t,i,o),r=this._validateMove(t,o,i),s=this.getDirection(e);return"both"===s&&(a||r)||"horizontal"===s&&a||"vertical"===s&&r||this._immediateAccepted},_validateMove:function(e,t,n){return t&&t>=e&&(!this.immediate||t>=n)},_getTouchBoundary:function(e){return this.immediate||(0,p.isDxMouseWheelEvent)(e)?0:v},_adjustStartEvent:function(e){var t=this._getTouchBoundary(e),n=(0,p.eventDelta)(this._startEventData,(0,p.eventData)(e));this._startEvent.pageX+=(0,d.sign)(n.x)*t,this._startEvent.pageY+=(0,d.sign)(n.y)*t},_resetActiveElement:function(){"ios"===a.default.real().platform&&this.getElement().find(":focus").length&&(0,l.resetActiveElement)()},_toggleGestureCover:function(e){this._toggleGestureCoverImpl(e)},_toggleGestureCoverImpl:function(e){2===this._stage&&function(e,t){y()(e,t)}(e,this.getElement().css("cursor"))},_clearSelection:function(e){(0,p.isDxMouseWheelEvent)(e)||(0,p.isTouchEvent)(e)||(0,l.clearSelection)()},end:function(e){this._toggleGestureCover(!1),2===this._stage?this._end(e):1===this._stage&&this._stop(e),this._stage=0},dispose:function(){clearTimeout(this._immediateTimer),this.callBase.apply(this,arguments),this._toggleGestureCover(!1)},_init:c.noop,_start:c.noop,_move:c.noop,_stop:c.noop,_end:c.noop});b.initialTouchBoundary=v,b.touchBoundary=function(e){if(!(0,h.isDefined)(e))return v;v=e};var x=b;t.default=x,e.exports=t.default,e.exports.default=t.default},37334:function(e,t,n){t.default=void 0;var i=d(n(55994)),o=d(n(38377)),a=n(39611),r=d(n(98621)),s=d(n(82495)),l=n(90057),u=d(n(20530));function d(e){return e&&e.__esModule?e:{default:e}}var c,h,p,f=o.default.abstract,g=u.default.real(),m=o.default.inherit((c=(0,a.addNamespace)("scroll","dxScrollEmitter"),{ctor:function(e){var t=this;this._element=e,this._locked=!1,this._proxiedScroll=function(e){t._disposed||t._scroll(e)},i.default.on(this._element,c,this._proxiedScroll)},_scroll:f,check:function(e,t){this._locked&&t()},dispose:function(){this._disposed=!0,i.default.off(this._element,c,this._proxiedScroll)}})),_=m.inherit({ctor:function(e,t){this.callBase(e),this._timeout=t},_scroll:function(){this._prepare(),this._forget()},_prepare:function(){this._timer&&this._clearTimer(),this._locked=!0},_clearTimer:function(){clearTimeout(this._timer),this._locked=!1,this._timer=null},_forget:function(){var e=this;this._timer=setTimeout((function(){e._clearTimer()}),this._timeout)},dispose:function(){this.callBase(),this._clearTimer()}}),v=_.inherit({ctor:function(e){this.callBase(e,400),this._lastWheelDirection=null},check:function(e,t){this._checkDirectionChanged(e),this.callBase(e,t)},_checkDirectionChanged:function(e){if((0,a.isDxMouseWheelEvent)(e)){var t=e.shiftKey||!1,n=null!==this._lastWheelDirection&&t!==this._lastWheelDirection;this._lastWheelDirection=t,this._locked=this._locked&&!n}else this._lastWheelDirection=null}}),y=_.inherit({ctor:function(e){this.callBase(e,400)}});h=g.ios,p=g.android,(h||p)&&(y=m.inherit({_scroll:function(){this._locked=!0;var e=this;(0,l.cancelAnimationFrame)(this._scrollFrame),this._scrollFrame=(0,l.requestAnimationFrame)((function(){e._locked=!1}))},check:function(e,t){(0,l.cancelAnimationFrame)(this._scrollFrame),(0,l.cancelAnimationFrame)(this._checkFrame);var n=this,i=this.callBase;this._checkFrame=(0,l.requestAnimationFrame)((function(){i.call(n,e,t),n._locked=!1}))},dispose:function(){this.callBase(),(0,l.cancelAnimationFrame)(this._scrollFrame),(0,l.cancelAnimationFrame)(this._checkFrame)}}));var b,x=r.default.inherit((b=Math.round(1e3/60),{ctor:function(e){this.callBase.apply(this,arguments),this.direction="both",this._pointerLocker=new y(e),this._wheelLocker=new v(e)},validate:function(){return!0},configure:function(e){e.scrollTarget&&(this._pointerLocker.dispose(),this._wheelLocker.dispose(),this._pointerLocker=new y(e.scrollTarget),this._wheelLocker=new v(e.scrollTarget)),this.callBase(e)},_init:function(e){this._wheelLocker.check(e,function(){(0,a.isDxMouseWheelEvent)(e)&&this._accept(e)}.bind(this)),this._pointerLocker.check(e,function(){var t=this.isNative&&(0,a.isMouseEvent)(e);(0,a.isDxMouseWheelEvent)(e)||t||this._accept(e)}.bind(this)),this._fireEvent("dxscrollinit",e),this._prevEventData=(0,a.eventData)(e)},move:function(e){this.callBase.apply(this,arguments),e.isScrollingEvent=this.isNative||e.isScrollingEvent},_start:function(e){this._savedEventData=(0,a.eventData)(e),this._fireEvent("dxscrollstart",e),this._prevEventData=(0,a.eventData)(e)},_move:function(e){var t=(0,a.eventData)(e);this._fireEvent("dxscroll",e,{delta:(0,a.eventDelta)(this._prevEventData,t)}),(0,a.eventDelta)(this._savedEventData,t).time>200&&(this._savedEventData=this._prevEventData),this._prevEventData=(0,a.eventData)(e)},_end:function(e){var t=(0,a.eventDelta)(this._prevEventData,(0,a.eventData)(e)),n={x:0,y:0};if(!(0,a.isDxMouseWheelEvent)(e)&&t.time<100){var i=(0,a.eventDelta)(this._savedEventData,this._prevEventData),o=b/i.time;n={x:i.x*o,y:i.y*o}}this._fireEvent("dxscrollend",e,{velocity:n})},_stop:function(e){this._fireEvent("dxscrollstop",e)},cancel:function(e){this.callBase.apply(this,arguments),this._fireEvent("dxscrollcancel",e)},dispose:function(){this.callBase.apply(this,arguments),this._pointerLocker.dispose(),this._wheelLocker.dispose()},_clearSelection:function(){if(!this.isNative)return this.callBase.apply(this,arguments)},_toggleGestureCover:function(){if(!this.isNative)return this.callBase.apply(this,arguments)}}));(0,s.default)({emitter:x,events:["dxscrollinit","dxscrollstart","dxscroll","dxscrollend","dxscrollstop","dxscrollcancel"]});var w={init:"dxscrollinit",start:"dxscrollstart",move:"dxscroll",end:"dxscrollend",stop:"dxscrollstop",cancel:"dxscrollcancel",scroll:"scroll"};t.default=w,e.exports=t.default,e.exports.default=t.default},66894:function(e,t,n){t.default=void 0;var i=n(34309),o=d(n(55994)),a=d(n(13046)),r=n(95479),s=n(39611),l=n(13306),u=n(9321);function d(e){return e&&e.__esModule?e:{default:e}}var c={onStart:i.start,onUpdated:i.swipe,onEnd:i.end,onCancel:"dxswipecancel"},h=a.default.inherit({_getDefaultOptions:function(){return(0,l.extend)(this.callBase(),{elastic:!0,immediate:!1,direction:"horizontal",itemSizeFunc:null,onStart:null,onUpdated:null,onEnd:null,onCancel:null})},_render:function(){this.callBase(),this.$element().addClass("dx-swipeable"),this._attachEventHandlers()},_attachEventHandlers:function(){if(this._detachEventHandlers(),!this.option("disabled")){var e=this.NAME;this._createEventData(),(0,r.each)(c,function(t,n){var i=this._createActionByOption(t,{context:this});n=(0,s.addNamespace)(n,e),o.default.on(this.$element(),n,this._eventData,(function(e){return i({event:e})}))}.bind(this))}},_createEventData:function(){this._eventData={elastic:this.option("elastic"),itemSizeFunc:this.option("itemSizeFunc"),direction:this.option("direction"),immediate:this.option("immediate")}},_detachEventHandlers:function(){o.default.off(this.$element(),".dxSwipeable")},_optionChanged:function(e){switch(e.name){case"disabled":case"onStart":case"onUpdated":case"onEnd":case"onCancel":case"elastic":case"immediate":case"itemSizeFunc":case"direction":this._detachEventHandlers(),this._attachEventHandlers();break;case"rtlEnabled":break;default:this.callBase(e)}},_useTemplates:function(){return!1}});(0,u.name)(h,"dxSwipeable");var p=h;t.default=p,e.exports=t.default,e.exports.default=t.default},11699:function(e,t,n){t.default=void 0;var i=n(39611),o=r(n(31391)),a=r(n(82495));function r(e){return e&&e.__esModule?e:{default:e}}var s=Math.abs,l=o.default.inherit({start:function(e){this._startEventData=(0,i.eventData)(e),this._startTimer(e)},_startTimer:function(e){var t="timeout"in this?this.timeout:750;this._holdTimer=setTimeout(function(){this._requestAccept(e),this._fireEvent("dxhold",e,{target:e.target}),this._forgetAccept()}.bind(this),t)},move:function(e){this._touchWasMoved(e)&&this._cancel(e)},_touchWasMoved:function(e){var t=(0,i.eventDelta)(this._startEventData,(0,i.eventData)(e));return s(t.x)>5||s(t.y)>5},end:function(){this._stopTimer()},_stopTimer:function(){clearTimeout(this._holdTimer)},cancel:function(){this._stopTimer()},dispose:function(){this._stopTimer()}});(0,a.default)({emitter:l,bubble:!0,events:["dxhold"]});var u={name:"dxhold"};t.default=u,e.exports=t.default,e.exports.default=t.default},24028:function(e,t,n){t.start=t.end=void 0;var i=d(n(55994)),o=n(97906),a=d(n(38377)),r=d(n(20530)),s=d(n(85788)),l=n(39611),u=d(n(93786));function d(e){return e&&e.__esModule?e:{default:e}}t.start="dxhoverstart";var c=(0,l.addNamespace)(u.default.enter,"dxHoverStart");t.end="dxhoverend";var h=(0,l.addNamespace)(u.default.leave,"dxHoverEnd"),p=a.default.inherit({noBubble:!0,ctor:function(){this._handlerArrayKeyPath=this._eventNamespace+"_HandlerStore"},setup:function(e){(0,o.data)(e,this._handlerArrayKeyPath,{})},add:function(e,t){var n=this,a=function(e){n._handler(e)};i.default.on(e,this._originalEventName,t.selector,a),(0,o.data)(e,this._handlerArrayKeyPath)[t.guid]=a},_handler:function(e){(0,l.isTouchEvent)(e)||r.default.isSimulator()||(0,l.fireEvent)({type:this._eventName,originalEvent:e,delegateTarget:e.delegateTarget})},remove:function(e,t){var n=(0,o.data)(e,this._handlerArrayKeyPath)[t.guid];i.default.off(e,this._originalEventName,t.selector,n)},teardown:function(e){(0,o.removeData)(e,this._handlerArrayKeyPath)}}),f=p.inherit({ctor:function(){this._eventNamespace="dxHoverStart",this._eventName="dxhoverstart",this._originalEventName=c,this.callBase()},_handler:function(e){(e.pointers||[]).length||this.callBase(e)}}),g=p.inherit({ctor:function(){this._eventNamespace="dxHoverEnd",this._eventName="dxhoverend",this._originalEventName=h,this.callBase()}});(0,s.default)("dxhoverstart",new f),(0,s.default)("dxhoverend",new g)},66365:function(e,t,n){t.triggerHandler=t.trigger=t.one=t.on=t.off=t.Event=void 0;var i,o=(i=n(55994))&&i.__esModule?i:{default:i};var a=o.default.on;t.on=a;var r=o.default.one;t.one=r;var s=o.default.off;t.off=s;var l=o.default.trigger;t.trigger=l;var u=o.default.triggerHandler;t.triggerHandler=u;var d=o.default.Event;t.Event=d},93786:function(e,t,n){function i(e){return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}t.default=void 0;var o=function(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!==i(e)&&"function"!=typeof e)return{default:e};var n=h(t);if(n&&n.has(e))return n.get(e);var o={},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var r in e)if("default"!==r&&Object.prototype.hasOwnProperty.call(e,r)){var s=a?Object.getOwnPropertyDescriptor(e,r):null;s&&(s.get||s.set)?Object.defineProperty(o,r,s):o[r]=e[r]}o.default=e,n&&n.set(e,o);return o}(n(60137)),a=n(95479),r=c(n(20530)),s=c(n(85788)),l=c(n(69120)),u=c(n(66509)),d=c(n(87720));function c(e){return e&&e.__esModule?e:{default:e}}function h(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,n=new WeakMap;return(h=function(e){return e?n:t})(e)}var p=function(e,t){var n=t.tablet,i=t.phone;return!e.touch||n||i?e.touch?l.default:u.default:d.default}(o,r.default.real());(0,a.each)(p.map,(function(e,t){(0,s.default)(e,new p(e,t))}));var f={down:"dxpointerdown",up:"dxpointerup",move:"dxpointermove",cancel:"dxpointercancel",enter:"dxpointerenter",leave:"dxpointerleave",over:"dxpointerover",out:"dxpointerout"};t.default=f,e.exports=t.default,e.exports.default=t.default},88136:function(e,t,n){t.default=void 0;var i=l(n(55994)),o=l(n(47810)),a=l(n(73349)),r=l(n(38377)),s=n(39611);function l(e){return e&&e.__esModule?e:{default:e}}var u=r.default.inherit({ctor:function(e,t){this._eventName=e,this._originalEvents=(0,s.addNamespace)(t,"dxPointerEvents"),this._handlerCount=0,this.noBubble=this._isNoBubble()},_isNoBubble:function(){var e=this._eventName;return"dxpointerenter"===e||"dxpointerleave"===e},_handler:function(e){var t=this._getDelegateTarget(e),n={type:this._eventName,pointerType:e.pointerType||(0,s.eventSource)(e),originalEvent:e,delegateTarget:t,timeStamp:o.default.mozilla?(new Date).getTime():e.timeStamp},i=e.originalEvent;if(null!=i&&i.target.shadowRoot){var a,r,l=null!==(a=i.path)&&void 0!==a?a:null===(r=i.composedPath)||void 0===r?void 0:r.call(i);n.target=l[0]}return this._fireEvent(n)},_getDelegateTarget:function(e){var t;return this.noBubble&&(t=e.delegateTarget),t},_fireEvent:function(e){return(0,s.fireEvent)(e)},_setSelector:function(e){this._selector=this.noBubble&&e?e.selector:null},_getSelector:function(){return this._selector},setup:function(){return!0},add:function(e,t){if(this._handlerCount<=0||this.noBubble){e=this.noBubble?e:a.default.getDocument(),this._setSelector(t);var n=this;i.default.on(e,this._originalEvents,this._getSelector(),(function(e){n._handler(e)}))}this.noBubble||this._handlerCount++},remove:function(e){this._setSelector(e),this.noBubble||this._handlerCount--},teardown:function(e){this._handlerCount&&!this.noBubble||(e=this.noBubble?e:a.default.getDocument(),".dxPointerEvents"!==this._originalEvents&&i.default.off(e,this._originalEvents,this._getSelector()))},dispose:function(e){e=this.noBubble?e:a.default.getDocument(),i.default.off(e,this._originalEvents)}});t.default=u,e.exports=t.default,e.exports.default=t.default},66509:function(e,t,n){t.default=void 0;var i=n(13306),o=r(n(88136)),a=r(n(25544));function r(e){return e&&e.__esModule?e:{default:e}}var s,l={dxpointerdown:"mousedown",dxpointermove:"mousemove",dxpointerup:"mouseup",dxpointercancel:"",dxpointerover:"mouseover",dxpointerout:"mouseout",dxpointerenter:"mouseenter",dxpointerleave:"mouseleave"},u=function(e){return e.pointerId=1,{pointers:s.pointers(),pointerId:1}},d=!1,c=function(){d||(s=new a.default(l,(function(){return!0})),d=!0)},h=o.default.inherit({ctor:function(){this.callBase.apply(this,arguments),c()},_fireEvent:function(e){return this.callBase((0,i.extend)(u(e.originalEvent),e))}});h.map=l,h.normalize=u,h.activate=c,h.resetObserver=function(){s.reset()};var p=h;t.default=p,e.exports=t.default,e.exports.default=t.default},87720:function(e,t,n){t.default=void 0;var i=n(13306),o=l(n(88136)),a=l(n(66509)),r=l(n(69120)),s=n(39611);function l(e){return e&&e.__esModule?e:{default:e}}var u=!1,d=function(){u||(a.default.activate(),u=!0)},c=o.default.inherit({EVENT_LOCK_TIMEOUT:100,ctor:function(){this.callBase.apply(this,arguments),d()},_handler:function(e){var t=(0,s.isMouseEvent)(e);if(t||(this._skipNextEvents=!0),!t||!this._mouseLocked){if(!t||!this._skipNextEvents)return this.callBase(e);this._skipNextEvents=!1,this._mouseLocked=!0,clearTimeout(this._unlockMouseTimer);var n=this;this._unlockMouseTimer=setTimeout((function(){n._mouseLocked=!1}),this.EVENT_LOCK_TIMEOUT)}},_fireEvent:function(e){var t=(0,s.isMouseEvent)(e.originalEvent)?a.default.normalize:r.default.normalize;return this.callBase((0,i.extend)(t(e.originalEvent),e))},dispose:function(){this.callBase(),this._skipNextEvents=!1,this._mouseLocked=!1,clearTimeout(this._unlockMouseTimer)}});c.map={dxpointerdown:"touchstart mousedown",dxpointermove:"touchmove mousemove",dxpointerup:"touchend mouseup",dxpointercancel:"touchcancel",dxpointerover:"mouseover",dxpointerout:"mouseout",dxpointerenter:"mouseenter",dxpointerleave:"mouseleave"},c.resetObserver=a.default.resetObserver;var h=c;t.default=h,e.exports=t.default,e.exports.default=t.default},25544:function(e,t,n){t.default=void 0;var i=n(95479),o=r(n(24311)),a=r(n(73349));function r(e){return e&&e.__esModule?e:{default:e}}var s=function(e,t){o.default.add((function(){e.split(" ").forEach((function(e){a.default.listen(a.default.getDocument(),e,t,!0)}))}))},l=function(e,t,n){n=n||function(){};var o=[],a=function(e){var n=-1;return(0,i.each)(o,(function(i,o){return!t(e,o)||(n=i,!1)})),n},r=function(e){var t=a(e);t>-1&&o.splice(t,1)};s(e.dxpointerdown,(function(e){-1===a(e)&&(n(e),o.push(e))})),s(e.dxpointermove,(function(e){o[a(e)]=e})),s(e.dxpointerup,r),s(e.dxpointercancel,r),this.pointers=function(){return o},this.reset=function(){o=[]}};t.default=l,e.exports=t.default,e.exports.default=t.default},69120:function(e,t,n){t.default=void 0;var i=s(n(20530)),o=n(13306),a=n(95479),r=s(n(88136));function s(e){return e&&e.__esModule?e:{default:e}}var l=function(e){var t=[];return(0,a.each)(e.touches,(function(e,n){t.push((0,o.extend)({pointerId:n.identifier},n))})),{pointers:t,pointerId:e.changedTouches[0].identifier}},u=function(e){return"ios"===i.default.real().platform&&("dxpointerdown"===e||"dxpointerup"===e)},d=r.default.inherit({ctor:function(){this.callBase.apply(this,arguments),this._pointerId=0},_handler:function(e){if(u(this._eventName)){var t=e.changedTouches[0];if(this._pointerId===t.identifier&&0!==this._pointerId)return;this._pointerId=t.identifier}return this.callBase.apply(this,arguments)},_fireEvent:function(e){return this.callBase((0,o.extend)(l(e.originalEvent),e))}});d.map={dxpointerdown:"touchstart",dxpointermove:"touchmove",dxpointerup:"touchend",dxpointercancel:"touchcancel",dxpointerover:"",dxpointerout:"",dxpointerenter:"",dxpointerleave:""},d.normalize=l;var c=d;t.default=c,e.exports=t.default,e.exports.default=t.default},29007:function(e,t,n){t.removeEvent=void 0;var i=s(n(68374)),o=n(97906),a=s(n(55994)),r=s(n(85788));function s(e){return e&&e.__esModule?e:{default:e}}t.removeEvent="dxremove";(0,o.beforeCleanData)((function(e){e=[].slice.call(e);for(var t=0;t<e.length;t++){var n=(0,i.default)(e[t]);n.prop("dxRemoveEvent")&&(n[0].dxRemoveEvent=null,a.default.triggerHandler(n,"dxremove"))}})),(0,r.default)("dxremove",{noBubble:!0,setup:function(e){(0,i.default)(e).prop("dxRemoveEvent",!0)}})},72918:function(e,t,n){t.visibility=t.resize=t.keyboard=t.hover=t.focus=t.dxClick=t.click=t.active=void 0;var i=r(n(55994)),o=r(n(51661)),a=n(39611);function r(e){return e&&e.__esModule?e:{default:e}}function s(e,t){return t?(0,a.addNamespace)(e,t):e}function l(e,t){return"function"==typeof e?e(t):e.execute(t)}var u={on:function(e,t,n,o){var a=o.selector,r=o.showTimeout,u=o.hideTimeout,d=o.namespace;i.default.on(e,s("dxactive",d),a,{timeout:r},(function(e){return l(t,{event:e,element:e.currentTarget})})),i.default.on(e,s("dxinactive",d),a,{timeout:u},(function(e){return l(n,{event:e,element:e.currentTarget})}))},off:function(e,t){var n=t.namespace,o=t.selector;i.default.off(e,s("dxactive",n),o),i.default.off(e,s("dxinactive",n),o)}};t.active=u;var d={on:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},o=n.namespace;i.default.on(e,s("dxresize",o),t)},off:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t.namespace;i.default.off(e,s("dxresize",n))}};t.resize=d;var c={on:function(e,t,n,o){var a=o.selector,r=o.namespace;i.default.on(e,s("dxhoverend",r),a,(function(e){return n(e)})),i.default.on(e,s("dxhoverstart",r),a,(function(e){return l(t,{element:e.target,event:e})}))},off:function(e,t){var n=t.selector,o=t.namespace;i.default.off(e,s("dxhoverstart",o),n),i.default.off(e,s("dxhoverend",o),n)}};t.hover=c;var h={on:function(e,t,n,o){var a=o.namespace;i.default.on(e,s("dxhiding",a),n),i.default.on(e,s("dxshown",a),t)},off:function(e,t){var n=t.namespace;i.default.off(e,s("dxhiding",n)),i.default.off(e,s("dxshown",n))}};t.visibility=h;var p={on:function(e,t,n,o){var a=o.namespace;i.default.on(e,s("focusin",a),t),i.default.on(e,s("focusout",a),n)},off:function(e,t){var n=t.namespace;i.default.off(e,s("focusin",n)),i.default.off(e,s("focusout",n))},trigger:function(e){return i.default.trigger(e,"focus")}};t.focus=p;var f={on:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},o=n.namespace;i.default.on(e,s("dxclick",o),t)},off:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t.namespace;i.default.off(e,s("dxclick",n))}};t.dxClick=f;var g={on:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},o=n.namespace;i.default.on(e,s("click",o),t)},off:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t.namespace;i.default.off(e,s("click",n))}};t.click=g;var m=0,_={},v={on:function(e,t,n){var i="keyboardProcessorId".concat(m++);return _[i]=new o.default({element:e,focusTarget:t,handler:n}),i},off:function(e){e&&_[e]&&(_[e].dispose(),delete _[e])},_getProcessor:function(e){return _[e]}};t.keyboard=v},34309:function(e,t,n){t.swipe=t.start=t.end=void 0;var i=n(58664),o=n(39611),a=s(n(98621)),r=s(n(82495));function s(e){return e&&e.__esModule?e:{default:e}}t.start="dxswipestart";t.swipe="dxswipe";t.end="dxswipeend";var l={horizontal:{defaultItemSizeFunc:function(){return(0,i.getWidth)(this.getElement())},getBounds:function(){return[this._maxLeftOffset,this._maxRightOffset]},calcOffsetRatio:function(e){return((0,o.eventData)(e).x-(this._savedEventData&&this._savedEventData.x||0))/this._itemSizeFunc().call(this,e)},isFastSwipe:function(e){var t=(0,o.eventData)(e);return this.FAST_SWIPE_SPEED_LIMIT*Math.abs(t.x-this._tickData.x)>=t.time-this._tickData.time}},vertical:{defaultItemSizeFunc:function(){return(0,i.getHeight)(this.getElement())},getBounds:function(){return[this._maxTopOffset,this._maxBottomOffset]},calcOffsetRatio:function(e){return((0,o.eventData)(e).y-(this._savedEventData&&this._savedEventData.y||0))/this._itemSizeFunc().call(this,e)},isFastSwipe:function(e){var t=(0,o.eventData)(e);return this.FAST_SWIPE_SPEED_LIMIT*Math.abs(t.y-this._tickData.y)>=t.time-this._tickData.time}}},u=a.default.inherit({TICK_INTERVAL:300,FAST_SWIPE_SPEED_LIMIT:10,ctor:function(e){this.callBase(e),this.direction="horizontal",this.elastic=!0},_getStrategy:function(){return l[this.direction]},_defaultItemSizeFunc:function(){return this._getStrategy().defaultItemSizeFunc.call(this)},_itemSizeFunc:function(){return this.itemSizeFunc||this._defaultItemSizeFunc},_init:function(e){this._tickData=(0,o.eventData)(e)},_start:function(e){this._savedEventData=(0,o.eventData)(e),(e=this._fireEvent("dxswipestart",e)).cancel||(this._maxLeftOffset=e.maxLeftOffset,this._maxRightOffset=e.maxRightOffset,this._maxTopOffset=e.maxTopOffset,this._maxBottomOffset=e.maxBottomOffset)},_move:function(e){var t=this._getStrategy(),n=(0,o.eventData)(e),i=t.calcOffsetRatio.call(this,e);i=this._fitOffset(i,this.elastic),n.time-this._tickData.time>this.TICK_INTERVAL&&(this._tickData=n),this._fireEvent("dxswipe",e,{offset:i}),e.preventDefault()},_end:function(e){var t=this._getStrategy(),n=t.calcOffsetRatio.call(this,e),i=t.isFastSwipe.call(this,e),o=n,a=this._calcTargetOffset(n,i);o=this._fitOffset(o,this.elastic),a=this._fitOffset(a,!1),this._fireEvent("dxswipeend",e,{offset:o,targetOffset:a})},_fitOffset:function(e,t){var n=this._getStrategy().getBounds.call(this);return e<-n[0]?t?(-2*n[0]+e)/3:-n[0]:e>n[1]?t?(2*n[1]+e)/3:n[1]:e},_calcTargetOffset:function(e,t){var n;return t?(n=Math.ceil(Math.abs(e)),e<0&&(n=-n)):n=Math.round(e),n}});(0,r.default)({emitter:u,events:["dxswipestart","dxswipe","dxswipeend"]})},91093:function(e,t,n){function i(e){return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}t.zoomstart=t.zoomend=t.zoom=t.translatestart=t.translateend=t.translate=t.transformstart=t.transformend=t.transform=t.rotatestart=t.rotateend=t.rotate=t.pinchstart=t.pinchend=t.pinch=void 0;var o=n(60810),a=function(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!==i(e)&&"function"!=typeof e)return{default:e};var n=d(t);if(n&&n.has(e))return n.get(e);var o={},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var r in e)if("default"!==r&&Object.prototype.hasOwnProperty.call(e,r)){var s=a?Object.getOwnPropertyDescriptor(e,r):null;s&&(s.get||s.set)?Object.defineProperty(o,r,s):o[r]=e[r]}o.default=e,n&&n.set(e,o);return o}(n(95479)),r=n(39611),s=u(n(31391)),l=u(n(82495));function u(e){return e&&e.__esModule?e:{default:e}}function d(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,n=new WeakMap;return(d=function(e){return e?n:t})(e)}var c="start",h="",p="end",f=[],g=function(e,t){f.push({name:e,args:t})};g("transform",{scale:!0,deltaScale:!0,rotation:!0,deltaRotation:!0,translation:!0,deltaTranslation:!0}),g("translate",{translation:!0,deltaTranslation:!0}),g("pinch",{scale:!0,deltaScale:!0}),g("rotate",{rotation:!0,deltaRotation:!0});var m=function(e){var t,n,i=e.pointers;return t=i[0],{x:(n=i[1]).pageX-t.pageX,y:-n.pageY+t.pageY,centerX:.5*(n.pageX+t.pageX),centerY:.5*(n.pageY+t.pageY)}},_=function(e){return Math.sqrt(e.x*e.x+e.y*e.y)},v=function(e,t){return _(e)/_(t)},y=function(e,t){var n=e.x*t.x+e.y*t.y,i=_(e)*_(t);return 0===i?0:(0,o.sign)(e.x*t.y-t.x*e.y)*Math.acos((0,o.fitIntoRange)(n/i,-1,1))},b=function(e,t){return{x:e.centerX-t.centerX,y:e.centerY-t.centerY}},x=s.default.inherit({validatePointers:function(e){return(0,r.hasTouches)(e)>1},start:function(e){this._accept(e);var t=m(e);this._startVector=t,this._prevVector=t,this._fireEventAliases(c,e)},move:function(e){var t=m(e),n=this._getEventArgs(t);this._fireEventAliases(h,e,n),this._prevVector=t},end:function(e){var t=this._getEventArgs(this._prevVector);this._fireEventAliases(p,e,t)},_getEventArgs:function(e){return{scale:v(e,this._startVector),deltaScale:v(e,this._prevVector),rotation:y(e,this._startVector),deltaRotation:y(e,this._prevVector),translation:b(e,this._startVector),deltaTranslation:b(e,this._prevVector)}},_fireEventAliases:function(e,t,n){n=n||{},a.each(f,function(i,o){var r={};a.each(o.args,(function(e){e in n&&(r[e]=n[e])})),this._fireEvent("dx"+o.name+e,t,r)}.bind(this))}}),w=f.reduce((function(e,t){return[c,h,p].forEach((function(n){e.push("dx"+t.name+n)})),e}),[]);(0,l.default)({emitter:x,events:w});var C={};a.each(w,(function(e,t){C[t.substring("dx".length)]=t}));var S=C.transformstart,k=C.transform,D=C.transformend,I=C.translatestart,T=C.translate,E=C.translateend,O=C.zoomstart,A=C.zoom,P=C.zoomend,R=C.pinchstart,M=C.pinch,B=C.pinchend,L=C.rotatestart,V=C.rotate,F=C.rotateend;t.rotateend=F,t.rotate=V,t.rotatestart=L,t.pinchend=B,t.pinch=M,t.pinchstart=R,t.zoomend=P,t.zoom=A,t.zoomstart=O,t.translateend=E,t.translate=T,t.translatestart=I,t.transformend=D,t.transform=k,t.transformstart=S},19141:function(e,t,n){t.default=void 0;var i,o=(i=n(17381))&&i.__esModule?i:{default:i};var a=function e(t,n){if(!n)throw o.default.Error("E0017");return Array.isArray(t)?t.map((function(t){return e(t,n)})).join(" "):-1!==t.indexOf(" ")?e(t.split(/\s+/g),n):"".concat(t,".").concat(n)};t.default=a,e.exports=t.default,e.exports.default=t.default},27575:function(e,t,n){t.unsubscribeNodesDisposing=t.subscribeNodesDisposing=void 0;var i,o=(i=n(55994))&&i.__esModule?i:{default:i},a=n(29007);function r(e){return e&&[e.target,e.delegateTarget,e.relatedTarget,e.currentTarget].filter((function(e){return!!e}))}t.subscribeNodesDisposing=function(e,t){o.default.one(r(e),a.removeEvent,t)};t.unsubscribeNodesDisposing=function(e,t){o.default.off(r(e),a.removeEvent,t)}},39611:function(e,t,n){t.stopEventsSkipping=t.setEventFixMethod=t.normalizeKeyName=t.needSkipEvent=t.isTouchEvent=t.isPointerEvent=t.isMouseEvent=t.isKeyboardEvent=t.isFakeClickEvent=t.isDxMouseWheelEvent=t.isCommandKeyPressed=t.hasTouches=t.getChar=t.forceSkipEvents=t.fireEvent=t.eventSource=t.eventDelta=t.eventData=t.createEvent=t.addNamespace=void 0;var i=u(n(68374)),o=u(n(19141)),a=u(n(55994)),r=n(95479),s=n(13306),l=n(31421);function u(e){return e&&e.__esModule?e:{default:e}}var d={backspace:"backspace",tab:"tab",enter:"enter",escape:"escape",pageup:"pageUp",pagedown:"pageDown",end:"end",home:"home",arrowleft:"leftArrow",arrowup:"upArrow",arrowright:"rightArrow",arrowdown:"downArrow",delete:"del"," ":"space",f:"F",a:"A","*":"asterisk","-":"minus",alt:"alt",control:"control",shift:"shift"},c={8:"backspace",9:"tab",13:"enter",27:"escape",33:"pageUp",34:"pageDown",35:"end",36:"home",37:"leftArrow",38:"upArrow",39:"rightArrow",40:"downArrow",46:"del",32:"space",70:"F",65:"A",106:"asterisk",109:"minus",189:"minus",173:"minus",16:"shift",17:"control",18:"alt"},h={dx:/^dx/i,mouse:/(mouse|wheel)/i,touch:/^touch/i,keyboard:/^key/i,pointer:/^(ms)?pointer/i},p=function(e){return e},f=function(e){return"dx"===m(e)},g=function(e){return"touch"===m(e)},m=function(e){var t=e.type,n="other";return(0,r.each)(h,(function(e){if(this.test(t))return n=e,!1})),n};t.eventSource=m;var _=function(e){return"pointer"===m(e)};t.isPointerEvent=_;var v=function(e){return function(e){return"mouse"===m(e)}(e)||(_(e)||f(e))&&"mouse"===e.pointerType};t.isMouseEvent=v;var y=function(e){return e&&"dxmousewheel"===e.type};t.isDxMouseWheelEvent=y;var b=function(e){return g(e)||(_(e)||f(e))&&"touch"===e.pointerType};t.isTouchEvent=b;t.isKeyboardEvent=function(e){return"keyboard"===m(e)};t.isFakeClickEvent=function(e){var t=e.screenX,n=e.offsetX,i=e.pageX;return 0===t&&!n&&0===i};t.eventData=function(e){return{x:e.pageX,y:e.pageY,time:e.timeStamp}};t.eventDelta=function(e,t){return{x:t.x-e.x,y:t.y-e.y,time:t.time-e.time||1}};t.hasTouches=function(e){var t=e.originalEvent,n=e.pointers;return g(e)?(t.touches||[]).length:f(e)?(n||[]).length:0};var x=!1;t.forceSkipEvents=function(){return x=!0};t.stopEventsSkipping=function(){return x=!1};t.needSkipEvent=function(e){if(x)return!0;var t=e.target,n=(0,i.default)(t),o=(null==t?void 0:t.isContentEditable)||(null==t?void 0:t.hasAttribute("contenteditable")),a=n.is("input, textarea, select")||o;return y(e)?!(n.is("textarea")&&n.hasClass("dx-texteditor-input")||o)&&(n.is("input[type='number'], textarea, select")&&n.is(":focus")):v(e)?a||e.which>1:b(e)?a&&(0,l.focused)(n):void 0};t.setEventFixMethod=function(e){return p=e};var w=function(e,t){var n=function(e){return p(a.default.Event(e,e),e)}(e);return t&&(0,s.extend)(n,t),n};t.createEvent=w;t.fireEvent=function(e){var t=e.originalEvent,n=e.delegateTarget,i=w(t,e);return a.default.trigger(n||i.target,i),i};t.normalizeKeyName=function(e){var t=e.key,n=e.which,i=d[null==t?void 0:t.toLowerCase()]||t,o=c[n];return o&&i===t?o:!i&&n?String.fromCharCode(n):i};t.getChar=function(e){var t=e.key,n=e.which;return t||String.fromCharCode(n)};var C=o.default;t.addNamespace=C;t.isCommandKeyPressed=function(e){var t=e.ctrlKey,n=e.metaKey;return t||n}},80506:function(e,t,n){t.triggerShownEvent=t.triggerResizeEvent=t.triggerHidingEvent=void 0;var i=a(n(68374)),o=a(n(55994));function a(e){return e&&e.__esModule?e:{default:e}}var r=function(e){return function(t){for(var n=(0,i.default)(t||"body"),a=n.filter(".dx-visibility-change-handler").add(n.find(".dx-visibility-change-handler")),r=0;r<a.length;r++)o.default.triggerHandler(a[r],e)}},s=r("dxshown");t.triggerShownEvent=s;var l=r("dxhiding");t.triggerHidingEvent=l;var u=r("dxresize");t.triggerResizeEvent=u},2994:function(e,t,n){Object.defineProperty(t,"exportDataGrid",{enumerable:!0,get:function(){return i.exportDataGrid}}),Object.defineProperty(t,"exportPivotGrid",{enumerable:!0,get:function(){return o.exportPivotGrid}});var i=n(8572),o=n(77328)},78292:function(e,t,n){t.excel=void 0,t.export=function(e,t,n){if(!e)return(new u.Deferred).resolve();var i=t.exportingAction,a=t.exportedAction,r=t.fileSavingAction,s={fileName:t.fileName,format:t.format,cancel:!1};(0,l.isBoolean)(t.selectedRowsOnly)&&(s.selectedRowsOnly=t.selectedRowsOnly);if((0,l.isFunction)(i)&&i(s),!s.cancel)return n(e,t).then((function(e){if((0,l.isFunction)(a)&&a(),(0,l.isFunction)(r)&&(s.data=e,r(s)),!s.cancel){var n="xlsx"===t.format?"EXCEL":t.format;o.fileSaver.saveAs(s.fileName,n,e,t.proxyUrl,t.forceProxy)}}));return(new u.Deferred).resolve()},Object.defineProperty(t,"fileSaver",{enumerable:!0,get:function(){return o.fileSaver}}),t.svg=t.pdf=t.image=void 0;var i,o=n(48351),a=n(13571),r=n(12173),s=n(37596),l=n(35922),u=n(62754),d=(i=n(45401))&&i.__esModule?i:{default:i},c=n(30855);var h={creator:a.ExcelCreator,getData:a.getData,formatConverter:d.default};t.excel=h;var p={creator:r.imageCreator,getData:r.getData,testFormats:r.testFormats};t.image=p;var f={getData:c.getData};t.pdf=f;var g={creator:s.svgCreator,getData:s.getData};t.svg=g},5332:function(e,t,n){t.ExportLoadPanel=void 0;var i=u(n(68374)),o=n(13306),a=u(n(28109)),r=n(35922),s=u(n(97218)),l=u(n(13615));function u(e){return e&&e.__esModule?e:{default:e}}var d=function(){function e(e,t,n,o){this._$targetElement=t,this._$container=n,this._loadPanel=e._createComponent((0,i.default)("<div>").addClass("dx-export-loadpanel").appendTo(this._$container),s.default,this.getOptions(o))}var t=e.prototype;return t.getDefaultOptions=function(){return{animation:null,shading:!1,height:90,width:200,container:this._$container}},t.getOptions=function(e){return(0,r.isDefined)(e.text)?e.message=e.text:e.message=a.default.format("dxDataGrid-exporting"),(0,o.extend)(this.getDefaultOptions(),e)},t.show=function(){this._loadPanel.option("position",l.default.calculateLoadPanelPosition(this._$targetElement)),this._loadPanel.show()},t.dispose=function(){(0,i.default)(this._loadPanel.element()).remove(),delete this._loadPanel},e}();t.ExportLoadPanel=d},56985:function(e,t,n){t.default=void 0;var i,o=n(35922),a=(i=n(95320))&&i.__esModule?i:{default:i};var r={tryCreateTag:function(e){var t=null;return(0,o.isDefined)(e)&&(t={vertical:e.vertical,wrapText:e.wrapText,horizontal:e.horizontal},r.isEmpty(t)&&(t=null)),t},copy:function(e){var t=null;return(0,o.isDefined)(e)&&(t={},void 0!==e.horizontal&&(t.horizontal=e.horizontal),void 0!==e.vertical&&(t.vertical=e.vertical),void 0!==e.wrapText&&(t.wrapText=e.wrapText)),t},areEqual:function(e,t){return r.isEmpty(e)&&r.isEmpty(t)||(0,o.isDefined)(e)&&(0,o.isDefined)(t)&&e.vertical===t.vertical&&e.wrapText===t.wrapText&&e.horizontal===t.horizontal},isEmpty:function(e){return!(0,o.isDefined)(e)||!(0,o.isDefined)(e.vertical)&&!(0,o.isDefined)(e.wrapText)&&!(0,o.isDefined)(e.horizontal)},toXml:function(e){return a.default.toXml("alignment",{vertical:e.vertical,wrapText:(0,o.isDefined)(e.wrapText)?Number(e.wrapText):void 0,horizontal:e.horizontal})}},s=r;t.default=s,e.exports=t.default,e.exports.default=t.default},2159:function(e,t,n){t.default=void 0;var i=n(35922),o=l(n(95320)),a=l(n(56985)),r=l(n(8808)),s=l(n(50394));function l(e){return e&&e.__esModule?e:{default:e}}var u={tryCreateTag:function(e,t){var n=null;if((0,i.isDefined)(e)){var o;o="number"==typeof e.numberFormat?e.numberFormat:t.registerNumberFormat(e.numberFormat);var s=e.fill;(0,i.isDefined)(s)||(s=r.default.tryCreateFillFromSimpleFormat(e)),n={numberFormatId:o,alignment:a.default.tryCreateTag(e.alignment),fontId:t.registerFont(e.font),fillId:t.registerFill(s)},u.isEmpty(n)&&(n=null)}return n},copy:function(e){var t;return null===e?t=null:(0,i.isDefined)(e)&&(t={},void 0!==e.numberFormat&&(t.numberFormat=e.numberFormat),void 0!==e.fill?t.fill=r.default.copy(e.fill):r.default.copySimpleFormat(e,t),void 0!==e.alignment&&(t.alignment=a.default.copy(e.alignment)),void 0!==e.font&&(t.font=s.default.copy(e.font))),t},areEqual:function(e,t){return u.isEmpty(e)&&u.isEmpty(t)||(0,i.isDefined)(e)&&(0,i.isDefined)(t)&&e.fontId===t.fontId&&e.numberFormatId===t.numberFormatId&&e.fillId===t.fillId&&a.default.areEqual(e.alignment,t.alignment)},isEmpty:function(e){return!(0,i.isDefined)(e)||!(0,i.isDefined)(e.fontId)&&!(0,i.isDefined)(e.numberFormatId)&&!(0,i.isDefined)(e.fillId)&&a.default.isEmpty(e.alignment)},toXml:function(e){var t,n=a.default.isEmpty(e.alignment);return(0,i.isDefined)(e.numberFormatId)&&(t=e.numberFormatId>0?1:0),o.default.toXml("xf",{xfId:0,applyAlignment:n?null:1,fontId:e.fontId,applyNumberFormat:t,fillId:e.fillId,numFmtId:e.numberFormatId},n?null:a.default.toXml(e.alignment))}},d=u;t.default=d,e.exports=t.default,e.exports.default=t.default},21879:function(e,t,n){t.default=void 0;var i,o=n(35922),a=(i=n(95320))&&i.__esModule?i:{default:i};var r={_tryConvertColor:function(e){if("string"!=typeof e)return e;var t;if(e.length>0&&"#"===e[0]){var n=e.substr(1,e.length);t=6===n.length?"FF"+n:8===n.length?n[6]+n[7]+n.substr(0,6):n}else t=e;return t},tryCreateTag:function(e){var t=null;return(0,o.isDefined)(e)&&(t="string"==typeof e?{rgb:this._tryConvertColor(e)}:{rgb:this._tryConvertColor(e.rgb),theme:e.theme},r.isEmpty(t)&&(t=null)),t},copy:function(e){var t=null;return(0,o.isDefined)(e)&&("string"==typeof e?t=e:(t={},void 0!==e.rgb&&(t.rgb=e.rgb),void 0!==e.theme&&(t.theme=e.theme))),t},isEmpty:function(e){return!(0,o.isDefined)(e)||!(0,o.isDefined)(e.rgb)&&!(0,o.isDefined)(e.theme)},areEqual:function(e,t){return r.isEmpty(e)&&r.isEmpty(t)||(0,o.isDefined)(e)&&(0,o.isDefined)(t)&&e.rgb===t.rgb&&e.theme===t.theme},toXml:function(e,t){return a.default.toXml(e,{rgb:t.rgb,theme:t.theme})}},s=r;t.default=s,e.exports=t.default,e.exports.default=t.default},50587:function(e,t,n){t.default=void 0;var i=n(35922),o=u(n(95320)),a=u(n(2159)),r=u(n(8808)),s=u(n(50394)),l=u(n(10794));function u(e){return e&&e.__esModule?e:{default:e}}var d=function(){function e(){this._cellFormatTags=[],this._fillTags=[],this._fontTags=[],this._numberFormatTags=[],this._fillTags.push(r.default.tryCreateTag({patternFill:{patternType:"none"}}))}var t=e.prototype;return t.registerCellFormat=function(e){var t,n=a.default.tryCreateTag(e,{registerFill:this.registerFill.bind(this),registerFont:this.registerFont.bind(this),registerNumberFormat:this.registerNumberFormat.bind(this)});if((0,i.isDefined)(n)){for(var o=0;o<this._cellFormatTags.length;o++)if(a.default.areEqual(this._cellFormatTags[o],n)){t=o;break}void 0===t&&(t=this._cellFormatTags.push(n)-1)}return t},e.copyCellFormat=function(e){return a.default.copy(e)},t.generateCellFormatsXml=function(){var e=this._cellFormatTags.map((function(e){return a.default.toXml(e)}));return o.default.toXml("cellXfs",{count:e.length},e.join(""))},t.registerFill=function(e){var t,n=r.default.tryCreateTag(e);if((0,i.isDefined)(n)){for(var o=0;o<this._fillTags.length;o++)if(r.default.areEqual(this._fillTags[o],n)){t=o;break}void 0===t&&(this._fillTags.length<2&&this._fillTags.push(r.default.tryCreateTag({patternFill:{patternType:"Gray125"}})),t=this._fillTags.push(n)-1)}return t},t.generateFillsXml=function(){var e=this._fillTags.map((function(e){return r.default.toXml(e)}));return o.default.toXml("fills",{count:e.length},e.join(""))},t.registerFont=function(e){var t,n=s.default.tryCreateTag(e);if((0,i.isDefined)(n)){for(var o=0;o<this._fontTags.length;o++)if(s.default.areEqual(this._fontTags[o],n)){t=o;break}void 0===t&&(t=this._fontTags.push(n)-1)}return t},t.generateFontsXml=function(){var e=this._fontTags.map((function(e){return s.default.toXml(e)}));return o.default.toXml("fonts",{count:e.length},e.join(""))},t._convertNumberFormatIndexToId=function(e){return 165+e},t.registerNumberFormat=function(e){var t,n=l.default.tryCreateTag(e);if((0,i.isDefined)(n)){for(var o=0;o<this._numberFormatTags.length;o++)if(l.default.areEqual(this._numberFormatTags[o],n)){t=this._numberFormatTags[o][l.default.ID_PROPERTY_NAME];break}void 0===t&&(n[l.default.ID_PROPERTY_NAME]=this._convertNumberFormatIndexToId(this._numberFormatTags.length),t=n[l.default.ID_PROPERTY_NAME],this._numberFormatTags.push(n))}return t},t.generateNumberFormatsXml=function(){if(this._numberFormatTags.length>0){var e=this._numberFormatTags.map((function(e){return l.default.toXml(e)}));return o.default.toXml("numFmts",{count:e.length},e.join(""))}return""},e}();t.default=d,e.exports=t.default,e.exports.default=t.default},8808:function(e,t,n){t.default=void 0;var i=n(35922),o=r(n(95320)),a=r(n(40027));function r(e){return e&&e.__esModule?e:{default:e}}var s={tryCreateTag:function(e){var t=null;return(0,i.isDefined)(e)&&(t={patternFill:a.default.tryCreateTag(e.patternFill)},s.isEmpty(t)&&(t=null)),t},tryCreateFillFromSimpleFormat:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},t=e.backgroundColor,n=e.fillPatternType,o=e.fillPatternColor;return!(0,i.isDefined)(t)||(0,i.isDefined)(n)&&(0,i.isDefined)(o)?(0,i.isDefined)(n)&&(0,i.isDefined)(o)?{patternFill:{patternType:n,foregroundColor:{rgb:o},backgroundColor:{rgb:t}}}:void 0:{patternFill:{patternType:"solid",foregroundColor:{rgb:t}}}},copySimpleFormat:function(e,t){void 0!==e.backgroundColor&&(t.backgroundColor=e.backgroundColor),void 0!==e.fillPatternType&&(t.fillPatternType=e.fillPatternType),void 0!==e.fillPatternColor&&(t.fillPatternColor=e.fillPatternColor)},copy:function(e){var t=null;return(0,i.isDefined)(e)&&(t={},void 0!==e.patternFill&&(t.patternFill=a.default.copy(e.patternFill))),t},areEqual:function(e,t){return s.isEmpty(e)&&s.isEmpty(t)||(0,i.isDefined)(e)&&(0,i.isDefined)(t)&&a.default.areEqual(e.patternFill,t.patternFill)},isEmpty:function(e){return!(0,i.isDefined)(e)||a.default.isEmpty(e.patternFill)},toXml:function(e){return o.default.toXml("fill",{},a.default.toXml(e.patternFill))}},l=s;t.default=l,e.exports=t.default,e.exports.default=t.default},50394:function(e,t,n){t.default=void 0;var i=n(35922),o=r(n(95320)),a=r(n(21879));function r(e){return e&&e.__esModule?e:{default:e}}var s={tryCreateTag:function(e){var t=null;return(0,i.isDefined)(e)&&(t={size:e.size,name:e.name,family:e.family,scheme:e.scheme,bold:e.bold,italic:e.italic,underline:e.underline,color:a.default.tryCreateTag(e.color)},s.isEmpty(t)&&(t=null)),t},copy:function(e){var t=null;return(0,i.isDefined)(e)&&(t={},void 0!==e.size&&(t.size=e.size),void 0!==e.name&&(t.name=e.name),void 0!==e.family&&(t.family=e.family),void 0!==e.scheme&&(t.scheme=e.scheme),void 0!==e.bold&&(t.bold=e.bold),void 0!==e.italic&&(t.italic=e.italic),void 0!==e.underline&&(t.underline=e.underline),void 0!==e.color&&(t.color=a.default.copy(e.color))),t},areEqual:function(e,t){return s.isEmpty(e)&&s.isEmpty(t)||(0,i.isDefined)(e)&&(0,i.isDefined)(t)&&e.size===t.size&&e.name===t.name&&e.family===t.family&&e.scheme===t.scheme&&(e.bold===t.bold||!e.bold==!t.bold)&&(e.italic===t.italic||!e.italic==!t.italic)&&e.underline===t.underline&&a.default.areEqual(e.color,t.color)},isEmpty:function(e){return!(0,i.isDefined)(e)||!(0,i.isDefined)(e.size)&&!(0,i.isDefined)(e.name)&&!(0,i.isDefined)(e.family)&&!(0,i.isDefined)(e.scheme)&&(!(0,i.isDefined)(e.bold)||!e.bold)&&(!(0,i.isDefined)(e.italic)||!e.italic)&&!(0,i.isDefined)(e.underline)&&a.default.isEmpty(e.color)},toXml:function(e){var t=[(0,i.isDefined)(e.bold)&&e.bold?o.default.toXml("b",{}):"",(0,i.isDefined)(e.size)?o.default.toXml("sz",{val:e.size}):"",(0,i.isDefined)(e.color)?a.default.toXml("color",e.color):"",(0,i.isDefined)(e.name)?o.default.toXml("name",{val:e.name}):"",(0,i.isDefined)(e.family)?o.default.toXml("family",{val:e.family}):"",(0,i.isDefined)(e.scheme)?o.default.toXml("scheme",{val:e.scheme}):"",(0,i.isDefined)(e.italic)&&e.italic?o.default.toXml("i",{}):"",(0,i.isDefined)(e.underline)?o.default.toXml("u",{val:e.underline}):""].join("");return o.default.toXml("font",{},t)}},l=s;t.default=l,e.exports=t.default,e.exports.default=t.default},10794:function(e,t,n){t.default=void 0;var i,o=n(35922),a=(i=n(95320))&&i.__esModule?i:{default:i};var r={ID_PROPERTY_NAME:"id",tryCreateTag:function(e){var t=null;return"string"==typeof e&&(t={formatCode:e},r.isEmpty(t)&&(t=null)),t},areEqual:function(e,t){return r.isEmpty(e)&&r.isEmpty(t)||(0,o.isDefined)(e)&&(0,o.isDefined)(t)&&e.formatCode===t.formatCode},isEmpty:function(e){return!(0,o.isDefined)(e)||!(0,o.isDefined)(e.formatCode)||""===e.formatCode},toXml:function(e){return a.default.toXml("numFmt",{numFmtId:e[r.ID_PROPERTY_NAME],formatCode:e.formatCode})}},s=r;t.default=s,e.exports=t.default,e.exports.default=t.default},40027:function(e,t,n){t.default=void 0;var i=n(35922),o=r(n(95320)),a=r(n(21879));function r(e){return e&&e.__esModule?e:{default:e}}var s={tryCreateTag:function(e){var t=null;return(0,i.isDefined)(e)&&(t={patternType:e.patternType,backgroundColor:a.default.tryCreateTag(e.backgroundColor),foregroundColor:a.default.tryCreateTag(e.foregroundColor)},s.isEmpty(t)&&(t=null)),t},copy:function(e){var t=null;return(0,i.isDefined)(e)&&(t={},void 0!==e.patternType&&(t.patternType=e.patternType),void 0!==e.backgroundColor&&(t.backgroundColor=a.default.copy(e.backgroundColor)),void 0!==e.foregroundColor&&(t.foregroundColor=a.default.copy(e.foregroundColor))),t},areEqual:function(e,t){return s.isEmpty(e)&&s.isEmpty(t)||(0,i.isDefined)(e)&&(0,i.isDefined)(t)&&e.patternType===t.patternType&&a.default.areEqual(e.backgroundColor,t.backgroundColor)&&a.default.areEqual(e.foregroundColor,t.foregroundColor)},isEmpty:function(e){return!(0,i.isDefined)(e)||!(0,i.isDefined)(e.patternType)},toXml:function(e){var t=[(0,i.isDefined)(e.foregroundColor)?a.default.toXml("fgColor",e.foregroundColor):"",(0,i.isDefined)(e.backgroundColor)?a.default.toXml("bgColor",e.backgroundColor):""].join("");return o.default.toXml("patternFill",{patternType:e.patternType},t)}},l=s;t.default=l,e.exports=t.default,e.exports.default=t.default},95320:function(e,t,n){t.default=void 0;var i=n(35922),o={toXml:function(e,t,n){var o=["<",e];for(var a in t){var r=t[a];(0,i.isDefined)(r)&&o.push(" ",a,'="',r,'"')}return(0,i.isDefined)(n)&&""!==n?o.push(">",n,"</",e,">"):o.push(" />"),o.join("")}};t.default=o,e.exports=t.default,e.exports.default=t.default},13571:function(e,t,n){t.ExcelCreator=void 0,t.getData=function(e,t){var n=new x(e,t);return n._checkZipState(),n.ready().then((function(){return n.getData((0,a.isFunction)((0,o.getWindow)().Blob))}))};var i=f(n(38377)),o=n(58201),a=n(35922),r=n(13306),s=f(n(96688)),l=n(68752),u=f(n(97405)),d=n(48351),c=f(n(45401)),h=f(n(50587)),p=n(62754);function f(e){return e&&e.__esModule?e:{default:e}}function g(e){return(g="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var m='<?xml version="1.0" encoding="utf-8"?>',_="http://schemas.openxmlformats.org",v={boolean:"b",date:"d",number:"n",string:"s"},y=Date.UTC(1899,11,30),b={quarter:"shortDate",quarterAndYear:"shortDate",minute:"longTime",millisecond:"longTime"},x=i.default.inherit({_getXMLTag:function(e,t,n){var i,o,r="<"+e,s=t.length;for(i=0;i<s;i++)void 0!==(o=t[i]).value&&(r=r+" "+o.name+'="'+o.value+'"');return(0,a.isDefined)(n)?r+">"+n+"</"+e+">":r+" />"},_convertToExcelCellRef:function(e,t){for(var n,i,o="";!i;)n=65+(t>=26?t%26:Math.ceil(t)),o=String.fromCharCode(n)+o,t>=26?t=Math.floor(t/26)-1:i=!0;return o+(e+1)},_convertToExcelCellRefAndTrackMaxIndex:function(e,t){return this._maxRowIndex<Number(e)&&(this._maxRowIndex=Number(e)),this._maxColumnIndex<Number(t)&&(this._maxColumnIndex=Number(t)),this._convertToExcelCellRef(e,t)},_getDataType:function(e){return v[e]||v.string},_tryGetExcelCellDataType:function(e){if((0,a.isDefined)(e)){if("number"==typeof e)return isFinite(e)?v.number:v.string;if((0,a.isString)(e))return v.string;if((0,a.isDate)(e))return v.number;if((0,a.isBoolean)(e))return v.boolean}},_formatObjectConverter:function(e,t){var n={format:e,precision:e&&e.precision,dataType:t};return(0,a.isObject)(e)?(0,r.extend)(n,e,{format:e.formatter||e.type,currency:e.currency}):n},_tryConvertToExcelNumberFormat:function(e,t){var n=this._formatObjectConverter(e,t);e=n.format;var i=n.currency;return t=n.dataType,(0,a.isDefined)(e)&&"date"===t&&(e=b[e&&e.type||e]||e),c.default.convertFormat(e,n.precision,t,i)},_appendString:function(e){if((0,a.isDefined)(e)&&(e=String(e)).length)return e=(0,l.encodeHtml)(e),void 0===this._stringHash[e]&&(this._stringHash[e]=this._stringArray.length,this._stringArray.push(e)),this._stringHash[e]},_tryGetExcelDateValue:function(e){var t;if((0,a.isDate)(e))return(t=Math.floor((Date.UTC(e.getFullYear(),e.getMonth(),e.getDate())-y)/864e5))<60&&t--,t+(3600*e.getHours()+60*e.getMinutes()+e.getSeconds())/86400},_prepareValue:function(e,t){var n,i=this._dataProvider,o=(i.getCellData(e,t)||{}).cellSourceData,r=(i.getCellData(e,t)||{}).value,s=this._getDataType(i.getCellType(e,t));switch(s!==v.date||(0,a.isDate)(r)||(s=v.string),s){case v.string:n=r,r=this._appendString(r);break;case v.date:n=r,r=this._tryGetExcelDateValue(r),s=v.number}return{value:r,type:s,sourceValue:n,cellSourceData:o}},_callCustomizeExcelCell:function(e){var t=e.dataProvider,n=e.value,i=e.style,o=e.sourceData,r=h.default.copyCellFormat(i),s={value:n,numberFormat:r.numberFormat,clearStyle:function(){this.horizontalAlignment=null,this.verticalAlignment=null,this.wrapTextEnabled=null,this.font=null,this.numberFormat=null}};(0,a.isDefined)(r)&&((0,a.isDefined)(r.alignment)&&(s.horizontalAlignment=r.alignment.horizontal,s.verticalAlignment=r.alignment.vertical,s.wrapTextEnabled=r.alignment.wrapText),s.backgroundColor=r.backgroundColor,s.fillPatternType=r.fillPatternType,s.fillPatternColor=r.fillPatternColor,s.font=r.font),t.customizeExcelCell(s,o);var l=r||{};return l.font=s.font,l.alignment=l.alignment||{},l.alignment.horizontal=s.horizontalAlignment,l.alignment.vertical=s.verticalAlignment,l.alignment.wrapText=s.wrapTextEnabled,l.backgroundColor=s.backgroundColor,l.fillPatternType=s.fillPatternType,l.fillPatternColor=s.fillPatternColor,l.numberFormat=s.numberFormat,{value:s.value,style:l}},_getDataArray:function(){var e,t,n,i,o,r=[],s=this._dataProvider,l=s.getRowsCount(),u=s.getColumns();for(e=0;e<l;e++){for(n=[],o=u.length,t=0;t!==o;t++){i=this._prepareValue(e,t);var d=s.getStyleId(e,t),c=this._styleArrayIndexToCellStyleIdMap[d];if(s.hasCustomizeExcelCell&&s.hasCustomizeExcelCell()){var h=i.sourceValue||i.value,p=this._callCustomizeExcelCell({dataProvider:s,value:h,style:this._styleArray[d],sourceData:i.cellSourceData});if(p.value!==h){if(g(p.value)!==g(h)||"number"==typeof p.value&&!isFinite(p.value)){var f=this._tryGetExcelCellDataType(p.value);(0,a.isDefined)(f)&&(i.type=f)}switch(i.type){case v.string:i.value=this._appendString(p.value);break;case v.date:i.value=p.value;break;case v.number:var m=p.value,_=this._tryGetExcelDateValue(m);(0,a.isDefined)(_)&&(m=_),i.value=m;break;default:i.value=p.value}}c=this._excelFile.registerCellFormat(p.style)}n.push({style:c,value:i.value,type:i.type})}!this._needSheetPr&&s.getGroupLevel(e)>0&&(this._needSheetPr=!0),r.push(n)}return r},_calculateWidth:function(e){return(!(e=parseInt(e,10))||e<5)&&(e=100),Math.min(255,Math.floor((e-5)/7*100+.5)/100)},_prepareStyleData:function(){var e=this,t=this,n=t._dataProvider.getStyles();t._dataProvider.getColumns().forEach((function(e){t._colsArray.push(t._calculateWidth(e.width))}));var i=[{size:11,color:{theme:1},name:"Calibri",family:2,scheme:"minor",bold:!1},{size:11,color:{theme:1},name:"Calibri",family:2,scheme:"minor",bold:!0}];this._excelFile.registerFont(i[0]),this._excelFile.registerFont(i[1]),n.forEach((function(e){var n=t._tryConvertToExcelNumberFormat(e.format,e.dataType);(0,a.isDefined)(n)||(n=0),t._styleArray.push({font:i[Number(!!e.bold)],numberFormat:n,alignment:{vertical:"top",wrapText:!!e.wrapText,horizontal:e.alignment||"left"}})})),t._styleArrayIndexToCellStyleIdMap=t._styleArray.map((function(t){return e._excelFile.registerCellFormat(t)}))},_prepareCellData:function(){this._cellsArray=this._getDataArray()},_createXMLRelationships:function(e){return this._getXMLTag("Relationships",[{name:"xmlns",value:_+"/package/2006/relationships"}],e)},_createXMLRelationship:function(e,t,n){return this._getXMLTag("Relationship",[{name:"Id",value:"rId"+e},{name:"Type",value:_+"/officeDocument/2006/relationships/"+t},{name:"Target",value:n}])},_getWorkbookContent:function(){return m+this._getXMLTag("workbook",[{name:"xmlns:r",value:_+"/officeDocument/2006/relationships"},{name:"xmlns",value:_+"/spreadsheetml/2006/main"}],'<bookViews><workbookView xWindow="0" yWindow="0" windowWidth="0" windowHeight="0"/></bookViews><sheets><sheet name="Sheet" sheetId="1" r:id="rId1" /></sheets><definedNames><definedName name="_xlnm.Print_Titles" localSheetId="0">Sheet!$1:$1</definedName><definedName name="_xlnm._FilterDatabase" hidden="0" localSheetId="0">Sheet!$A$1:$F$6332</definedName></definedNames>')},_getContentTypesContent:function(){return m+'<Types xmlns="'+_+'/package/2006/content-types"><Default Extension="rels" ContentType="application/vnd.openxmlformats-package.relationships+xml" /><Default Extension="xml" ContentType="application/xml" /><Override PartName="/xl/worksheets/sheet1.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml" /><Override PartName="/xl/styles.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml" /><Override PartName="/xl/sharedStrings.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml" /><Override PartName="/xl/workbook.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml" /></Types>'},_generateStylesXML:function(){var e=this._zip.folder("xl"),t="";t+=this._excelFile.generateNumberFormatsXml(),t+=this._excelFile.generateFontsXml(),t+=this._excelFile.generateFillsXml(),t+='<borders count="1"><border><left style="thin"><color rgb="FFD3D3D3"/></left><right style="thin"><color rgb="FFD3D3D3"/></right><top style="thin"><color rgb="FFD3D3D3"/></top><bottom style="thin"><color rgb="FFD3D3D3"/></bottom></border></borders><cellStyleXfs count="1"><xf numFmtId="0" fontId="0" fillId="0" borderId="0"/></cellStyleXfs>',t+=this._excelFile.generateCellFormatsXml(),t+=this._getXMLTag("cellStyles",[{name:"count",value:1}],this._getXMLTag("cellStyle",[{name:"name",value:"Normal"},{name:"xfId",value:0},{name:"builtinId",value:0}])),t=m+this._getXMLTag("styleSheet",[{name:"xmlns",value:_+"/spreadsheetml/2006/main"}],t),e.file("styles.xml",t),this._styleArray=[]},_generateStringsXML:function(){var e,t=this._zip.folder("xl"),n=this._stringArray.length,i=m;for(e=0;e<n;e++)this._stringArray[e]=this._getXMLTag("si",[],this._getXMLTag("t",[],this._stringArray[e]));i+=this._getXMLTag("sst",[{name:"xmlns",value:_+"/spreadsheetml/2006/main"},{name:"count",value:this._stringArray.length},{name:"uniqueCount",value:this._stringArray.length}],this._stringArray.join("")),t.file("sharedStrings.xml",i),this._stringArray=[]},_getPaneXML:function(){var e=[{name:"activePane",value:"bottomLeft"},{name:"state",value:"frozen"}],t=this._dataProvider.getFrozenArea();return t.x||t.y?(t.x&&e.push({name:"xSplit",value:t.x}),t.y&&e.push({name:"ySplit",value:t.y}),e.push({name:"topLeftCell",value:this._convertToExcelCellRefAndTrackMaxIndex(t.y,t.x)}),this._getXMLTag("pane",e)):""},_getAutoFilterXML:function(e){return this._options.autoFilterEnabled?'<autoFilter ref="A'+this._dataProvider.getHeaderRowCount()+":"+e+'" />':""},_getIgnoredErrorsXML:function(e){return this._options.ignoreErrors?'<ignoredErrors><ignoredError sqref="A1:'+e+'" numberStoredAsText="1" /></ignoredErrors>':""},_generateWorksheetXML:function(){var e,t,n,i,o,r=[],s=this._cellsArray.length,l=this._colsArray.length,u="1:"+l,d=this._dataProvider.getHeaderRowCount?this._dataProvider.getHeaderRowCount():1,c=['<?xml version="1.0" encoding="UTF-8" standalone="yes"?><worksheet xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships" xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006" mc:Ignorable="x14ac" xmlns:x14ac="http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac">'];for(c.push(this._needSheetPr?'<sheetPr><outlinePr summaryBelow="0"/></sheetPr>':"<sheetPr/>"),c.push('<dimension ref="A1:C1"/>'),c.push("<sheetViews><sheetView "),c.push(this._rtlEnabled?'rightToLeft="1" ':""),c.push('tabSelected="1" workbookViewId="0">'),c.push(this._getPaneXML()),c.push("</sheetView></sheetViews>"),c.push('<sheetFormatPr defaultRowHeight="15"'),c.push(' outlineLevelRow="'+(this._dataProvider.getRowsCount()>0?this._dataProvider.getGroupLevel(0):0)+'"'),c.push(' x14ac:dyDescent="0.25"/>'),e=0;e<l;e++)this._colsArray[e]=this._getXMLTag("col",[{name:"width",value:this._colsArray[e]},{name:"min",value:Number(e)+1},{name:"max",value:Number(e)+1},{name:"customWidth",value:1}]);for(c.push(this._getXMLTag("cols",[],this._colsArray.join(""))+"<sheetData>"),t=0;t<s;t++){for(i=[],o=this._cellsArray[t].length,e=0;e<o;e++)t=Number(t),n=this._cellsArray[t][e],i.push(this._getXMLTag("c",[{name:"r",value:this._convertToExcelCellRefAndTrackMaxIndex(t,e)},{name:"s",value:n.style},{name:"t",value:n.type}],(0,a.isDefined)(n.value)?this._getXMLTag("v",[],n.value):null));r.push(this._getXMLTag("row",[{name:"r",value:Number(t)+1},{name:"spans",value:u},{name:"outlineLevel",value:t>=d?this._dataProvider.getGroupLevel(t):0},{name:"x14ac:dyDescent",value:"0.25"}],i.join(""))),this._cellsArray[t]=null,r.length>1e4&&(c.push(r.join("")),r=[])}c.push(r.join("")),r=[];var h=this._convertToExcelCellRef(this._maxRowIndex,this._maxColumnIndex);c.push("</sheetData>"+this._getAutoFilterXML(h)+this._generateMergingXML()+this._getIgnoredErrorsXML(h)+"</worksheet>"),this._zip.folder("xl").folder("worksheets").file("sheet1.xml",c.join("")),this._colsArray=[],this._cellsArray=[],c=[]},_generateMergingXML:function(){var e,t,n,i,o,r=(0,a.isDefined)(this._dataProvider.getHeaderRowCount)?this._dataProvider.getHeaderRowCount():this._dataProvider.getRowsCount(),s=this._dataProvider.getColumns().length,l=[],u=[],d="";for(i=0;i<r;i++)for(n=0;n!==s;n++)if(!(0,a.isDefined)(l[i])||!(0,a.isDefined)(l[i][n])){var c=this._dataProvider.getCellMerging(i,n);if(c.colspan||c.rowspan)for(u.push({start:this._convertToExcelCellRefAndTrackMaxIndex(i,n),end:this._convertToExcelCellRefAndTrackMaxIndex(i+(c.rowspan||0),n+(c.colspan||0))}),e=i;e<=i+c.rowspan;e++)for(t=n;t<=n+c.colspan;t++)(0,a.isDefined)(l[e])||(l[e]=[]),l[e][t]=!0}var h=u.length;for(o=0;o<h;o++)d+=this._getXMLTag("mergeCell",[{name:"ref",value:u[o].start+":"+u[o].end}]);return d.length?this._getXMLTag("mergeCells",[{name:"count",value:h}],d):""},_generateCommonXML:function(){var e=m+this._createXMLRelationships(this._createXMLRelationship(1,"officeDocument","xl/workbook.xml")),t=this._zip.folder("xl"),n=m;this._zip.folder("_rels").file(".rels",e);var i=this._createXMLRelationship(1,"worksheet","worksheets/sheet1.xml")+this._createXMLRelationship(2,"styles","styles.xml")+this._createXMLRelationship(3,"sharedStrings","sharedStrings.xml");n+=this._createXMLRelationships(i),t.folder("_rels").file("workbook.xml.rels",n),t.file("workbook.xml",this._getWorkbookContent()),this._zip.file("[Content_Types].xml",this._getContentTypesContent())},_generateContent:function(){this._prepareStyleData(),this._prepareCellData(),this._generateWorkXML(),this._generateCommonXML()},_generateWorkXML:function(){this._generateStylesXML(),this._generateStringsXML(),this._generateWorksheetXML()},ctor:function(e,t){this._rtlEnabled=t&&!!t.rtlEnabled,this._options=t,this._maxRowIndex=0,this._maxColumnIndex=0,this._stringArray=[],this._stringHash={},this._styleArray=[],this._colsArray=[],this._cellsArray=[],this._needSheetPr=!1,this._dataProvider=e,this._excelFile=new h.default,(0,a.isDefined)(x.JSZip)?this._zip=new x.JSZip:this._zip=null},_checkZipState:function(){if(!this._zip)throw s.default.Error("E1041","JSZip")},ready:function(){return this._dataProvider.ready()},getData:function(e){var t={type:e?"blob":"base64",compression:"DEFLATE",mimeType:d.MIME_TYPES.EXCEL},n=new p.Deferred;return this._checkZipState(),this._generateContent(),this._zip.generateAsync?this._zip.generateAsync(t).then(n.resolve):n.resolve(this._zip.generate(t)),n}});t.ExcelCreator=x,x.JSZip=u.default},45401:function(e,t,n){t.default=void 0;var i=n(68752),o=u(n(18016)),a=u(n(91500)),r=n(35922),s=n(59937),l=n(9821);function u(e){return e&&e.__esModule?e:{default:e}}n(89740);var d={thousands:"#,##0{0},&quot;K&quot;",millions:"#,##0{0},,&quot;M&quot;",billions:"#,##0{0},,,&quot;B&quot;",trillions:"#,##0{0},,,,&quot;T&quot;",percent:"0{0}%",decimal:"#{0}",fixedpoint:"#,##0{0}",exponential:"0{0}E+00",currency:" "},c=/a+/g,h=/E/g,p=/dE+/g,f=/L/g,g=/h/g,m=/./g,_={_applyPrecision:function(e,t){var n,i;if(t>0){for(n="decimal"!==e?".":"",i=0;i<t;i++)n+="0";return n}return""},_hasArabicDigits:function(e){for(var t,n=0;n<e.length;n++)if((t=e.charCodeAt(n))>=1632&&t<1642)return!0;return!1},_convertDateFormatToOpenXml:function(e){return e.split("/").join("\\/").split("'").map((function(e,t){return t%2==0?e.replace(c,"AM/PM").replace(p,"d").replace(h,"d").replace(f,"M").replace(g,"H").split("[").join("\\[").split("]").join("\\]"):e?e.replace(m,"\\$&"):"'"})).join("")},_convertDateFormat:function(e){var t=(a.default.format(new Date(2009,8,8,6,5,4),e)||"").toString(),n=(0,s.getFormat)((function(t){return a.default.format(t,e)}));return n&&(n=this._convertDateFormatToOpenXml(n),n=this._getLanguageInfo(t)+n),n},_getLanguageInfo:function(e){var t=(0,l.getLanguageId)(),n=t?t.toString(16):"",i="";if(this._hasArabicDigits(e)){for(;n.length<3;)n="0"+n;i="[$-2010"+n+"]"}else n&&(i="[$-"+n+"]");return i},_convertNumberFormat:function(e,t,n){var a,r;return(r="currency"===e?o.default.getOpenXmlCurrencyFormat(n):d[e.toLowerCase()])&&(a=(0,i.format)(r,this._applyPrecision(e,t))),a},convertFormat:function(e,t,n,i){if((0,r.isDefined)(e)){if("date"===n)return _._convertDateFormat(e);if((0,r.isString)(e)&&d[e.toLowerCase()])return _._convertNumberFormat(e,t,i)}}},v=_;t.default=v,e.exports=t.default,e.exports.default=t.default},11385:function(e,t,n){t.Export=void 0;var i=n(35922),o=n(38526),a=n(31980),r=n(13306),s=n(5332),l=n(58201),u={getFullOptions:function(e){var t=(0,r.extend)({},e);if(!(0,i.isDefined)(t.worksheet)||!(0,i.isObject)(t.worksheet))throw Error('The "worksheet" field must contain an object.');if((0,i.isDefined)(t.topLeftCell)){if((0,i.isString)(t.topLeftCell)){var n=t.worksheet.getCell(t.topLeftCell),o=n.row,a=n.col;t.topLeftCell={row:o,column:a}}}else t.topLeftCell={row:1,column:1};return(0,i.isDefined)(t.keepColumnWidths)||(t.keepColumnWidths=!0),(0,i.isDefined)(t.loadPanel)||(t.loadPanel={}),(0,i.isDefined)(t.loadPanel.enabled)||(t.loadPanel.enabled=!0),t},convertDateForExcelJS:function(e){return new Date(Date.UTC(e.getFullYear(),e.getMonth(),e.getDate(),e.getHours(),e.getMinutes(),e.getSeconds(),e.getMilliseconds()))},setNumberFormat:function(e,t){e.numFmt=t},getCellStyles:function(e){var t=this,n=e.getStyles();return n.forEach((function(e){var n=t.tryConvertToExcelNumberFormat(e.format,e.dataType);(0,i.isDefined)(n)&&(n=n.replace(/&quot;/g,'"')),e.numberFormat=n})),n},tryConvertToExcelNumberFormat:function(e,t){var n=o.ExportFormat.formatObjectConverter(e,t),i=n.currency;return e=n.format,t=n.dataType,o.ExportFormat.convertFormat(e,n.precision,t,i)},setAlignment:function(e,t,n){e.alignment=e.alignment||{},(0,i.isDefined)(t)&&(e.alignment.wrapText=t),(0,i.isDefined)(n)&&(e.alignment.horizontal=n),e.alignment.vertical="top"},setColumnsWidth:function(e,t,n){if((0,i.isDefined)(t))for(var o=0;o<t.length;o++){var a=t[o];"number"==typeof a&&isFinite(a)&&(e.getColumn(n+o).width=Math.min(255,Math.floor(a/7*100)/100))}},export:function(e,t){var n,i,o=this,u=e.customizeCell,d=e.component,c=e.worksheet,h=e.topLeftCell,p=e.autoFilterEnabled,f=e.keepColumnWidths,g=e.selectedRowsOnly,m=e.loadPanel,_=e.mergeRowFieldValues,v=e.mergeColumnFieldValues,y=(null===(n=d._getInternalInstance)||void 0===n?void 0:n.call(d))||d,b=y.option("loadPanel")&&y.option("loadPanel").enabled;if(b&&d.option("loadPanel.enabled",!1),m.enabled&&(0,l.hasWindow)()){var x=t._getLoadPanelTargetElement(d),w=t._getLoadPanelContainer(d);(i=new s.ExportLoadPanel(d,x,w,m)).show()}var C=!!d.option("wordWrapEnabled");c.properties.outlineProperties={summaryBelow:!1,summaryRight:!1};var S={from:{row:h.row,column:h.column},to:{row:h.row,column:h.column}},k=d.getDataProvider(g);return new Promise((function(e){k.ready().done((function(){var n=k.getColumns(),i=k.getRowsCount();f&&o.setColumnsWidth(c,k.getColumnsWidths(),S.from.column);for(var s=new a.MergedRangesManager(k,t,_,v),l=o.getCellStyles(k),h=0;h<i;h++){var g=c.getRow(S.from.row+h);t._trySetOutlineLevel(k,g,h),o.exportRow(k,t,s,h,n.length,g,S.from.column,u,C,l),h>=1&&S.to.row++}s.applyMergedRages(c),S.to.column+=n.length>0?n.length-1:0;var m=c.views[0]||{};d.option("rtlEnabled")&&(m.rightToLeft=!0),t._isFrozenZone(k)&&(-1===Object.keys(m).indexOf("state")&&(0,r.extend)(m,t._getWorksheetFrozenState(k,S)),t._trySetAutoFilter(k,c,S,p)),Object.keys(m).length>0&&(c.views=[m]),e(S)})).always((function(){b&&d.option("loadPanel.enabled",b),m.enabled&&(0,l.hasWindow)()&&i.dispose()}))}))},exportRow:function(e,t,n,o,a,r,s,l,u,d){for(var c=0;c<a;c++){var h=e.getCellData(o,c,!0),p=r.getCell(s+c);n.updateMergedRanges(p,o,c);var f=n.findMergedCellInfo(o,c);if((0,i.isDefined)(f)&&p!==f.masterCell)p.style=f.masterCell.style,p.value=f.masterCell.value;else if((0,i.isDate)(h.value)?p.value=this.convertDateForExcelJS(h.value):p.value=h.value,(0,i.isDefined)(p.value)){var g=d[e.getStyleId(o,c)],m=g.bold,_=g.alignment,v=g.numberFormat;(0,i.isDefined)(v)?this.setNumberFormat(p,v):(0,i.isString)(p.value)&&/^[@=+-]/.test(p.value)&&this.setNumberFormat(p,"@"),t._trySetFont(p,m),this.setAlignment(p,u,_)}(0,i.isFunction)(l)&&l(t._getCustomizeCellOptions(p,h.cellSourceData))}}};t.Export=u},8572:function(e,t,n){t.exportDataGrid=function(e){return a.Export.export(function(e){if(!(0,o.isDefined)(e)||!(0,o.isObject)(e))throw Error('The "exportDataGrid" method requires a configuration object.');if(!(0,o.isDefined)(e.component)||!(0,o.isObject)(e.component)||"dxDataGrid"!==e.component.NAME)throw Error('The "component" field must contain a DataGrid instance.');(0,o.isDefined)(e.selectedRowsOnly)||(e.selectedRowsOnly=!1);(0,o.isDefined)(e.autoFilterEnabled)||(e.autoFilterEnabled=!1);return a.Export.getFullOptions(e)}(e),s)};var i,o=n(35922),a=n(11385),r=(i=n(17381))&&i.__esModule?i:{default:i};var s={_trySetAutoFilter:function(e,t,n,i){if(i&&!(0,o.isDefined)(t.autoFilter)&&e.getRowsCount()>0){var a={from:{row:n.from.row+e.getHeaderRowCount()-1,column:n.from.column},to:n.to};t.autoFilter=a}},_trySetFont:function(e,t){(0,o.isDefined)(t)&&(e.font=e.font||{},e.font.bold=t)},_getWorksheetFrozenState:function(e,t){return{state:"frozen",ySplit:t.from.row+e.getFrozenArea().y-1}},_trySetOutlineLevel:function(e,t,n){n>=e.getHeaderRowCount()&&(t.outlineLevel=e.getGroupLevel(n))},_getCustomizeCellOptions:function(e,t){var n={excelCell:e,gridCell:t};return Object.defineProperty(n,"cell",{get:function(){return r.default.log("W0003","CustomizeCell handler argument","cell","20.1","Use the 'excelCell' field instead"),e}}),n},_isFrozenZone:function(e){return e.getHeaderRowCount()>0},_isHeaderCell:function(e,t){return t<e.getHeaderRowCount()},_allowToMergeRange:function(){return!0},_getLoadPanelTargetElement:function(e){return e.getView("rowsView").element()},_getLoadPanelContainer:function(e){return e.getView("rowsView").element().parent()}}},38526:function(e,t,n){t.ExportFormat=void 0;var i=n(68752),o=d(n(18016)),a=d(n(91500)),r=n(35922),s=n(59937),l=n(9821),u=n(13306);function d(e){return e&&e.__esModule?e:{default:e}}n(89740);var c={thousands:"#,##0{0},&quot;K&quot;",millions:"#,##0{0},,&quot;M&quot;",billions:"#,##0{0},,,&quot;B&quot;",trillions:"#,##0{0},,,,&quot;T&quot;",percent:"0{0}%",decimal:"#{0}",fixedpoint:"#,##0{0}",exponential:"0{0}E+00",currency:" "},h=/a+/g,p=/E/g,f=/dE+/g,g=/L/g,m=/h/g,_=/./g;function v(e){var t=(a.default.format(new Date(2009,8,8,6,5,4),e)||"").toString(),n=(0,s.getFormat)((function(t){return a.default.format(t,e)}));return n&&(n=function(e){return e.split("/").join("\\/").split("'").map((function(e,t){return t%2==0?e.replace(h,"AM/PM").replace(f,"d").replace(p,"d").replace(g,"M").replace(m,"H").split("[").join("\\[").split("]").join("\\]"):e?e.replace(_,"\\$&"):"'"})).join("")}(n),n=function(e){var t=(0,l.getLanguageId)(),n=t?t.toString(16):"",i="";if(function(e){for(var t,n=0;n<e.length;n++)if((t=e.charCodeAt(n))>=1632&&t<1642)return!0;return!1}(e)){for(;n.length<3;)n="0"+n;i="[$-2010"+n+"]"}else n&&(i="[$-"+n+"]");return i}(t)+n),n}var y={formatObjectConverter:function(e,t){var n={format:e,precision:e&&e.precision,dataType:t};return(0,r.isObject)(e)?(0,u.extend)(n,e,{format:e.formatter||e.type,currency:e.currency}):n},convertFormat:function(e,t,n,a){if((0,r.isDefined)(e)){if("date"===n)return v(e);if((0,r.isString)(e)&&c[e.toLowerCase()])return function(e,t,n){var a,r;return(r="currency"===e?o.default.getOpenXmlCurrencyFormat(n):c[e.toLowerCase()])&&(a=(0,i.format)(r,function(e,t){var n,i;if(t>0){for(n="decimal"!==e?".":"",i=0;i<t;i++)n+="0";return n}return""}(e,t))),a}(e,t,a)}}};t.ExportFormat=y},31980:function(e,t){function n(){return(n=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(e[i]=n[i])}return e}).apply(this,arguments)}t.MergedRangesManager=void 0;var i=function(){function e(e,t,n,i){this.mergedCells=[],this.mergedRanges=[],this.dataProvider=e,this.helpers=t,this.mergeRowFieldValues=n,this.mergeColumnFieldValues=i}var t=e.prototype;return t.updateMergedRanges=function(e,t,i){if(this.helpers._isHeaderCell(this.dataProvider,t,i)&&!this.isCellInMergedRanges(t,i)){var o=this.dataProvider.getCellMerging(t,i),a=o.rowspan,r=o.colspan;if(r||a){var s=this.helpers._allowToMergeRange(this.dataProvider,t,i,a,r,this.mergeRowFieldValues,this.mergeColumnFieldValues);this.updateMergedCells(e,t,i,a,r,s),s&&this.mergedRanges.push(n({masterCell:e},{rowspan:a,colspan:r}))}}},t.isCellInMergedRanges=function(e,t){return this.mergedCells[e]&&this.mergedCells[e][t]},t.findMergedCellInfo=function(e,t){if(this.helpers._isHeaderCell(this.dataProvider,e,t)&&this.isCellInMergedRanges(e,t))return this.mergedCells[e][t]},t.updateMergedCells=function(e,t,n,i,o,a){for(var r=t;r<=t+i;r++)for(var s=n;s<=n+o;s++)this.mergedCells[r]||(this.mergedCells[r]=[]),this.mergedCells[r][s]={masterCell:e,unmerged:!a}},t.applyMergedRages=function(e){this.mergedRanges.forEach((function(t){var n=t.masterCell.fullAddress.row,i=t.masterCell.fullAddress.col,o=n+t.rowspan,a=i+t.colspan;e.mergeCells(n,i,o,a)}))},e}();t.MergedRangesManager=i},77328:function(e,t,n){t.exportPivotGrid=function(e){return o.Export.export(function(e){if(!(0,i.isDefined)(e)||!(0,i.isObject)(e))throw Error('The "exportPivotGrid" method requires a configuration object.');if(!(0,i.isDefined)(e.component)||!(0,i.isObject)(e.component)||"dxPivotGrid"!==e.component.NAME)throw Error('The "component" field must contain a PivotGrid instance.');(0,i.isDefined)(e.mergeRowFieldValues)||(e.mergeRowFieldValues=!0);(0,i.isDefined)(e.mergeColumnFieldValues)||(e.mergeColumnFieldValues=!0);return o.Export.getFullOptions(e)}(e),r)};var i=n(35922),o=n(11385),a=n(20576),r={_getWorksheetFrozenState:function(e,t){return{state:"frozen",xSplit:t.from.column+e.getFrozenArea().x-1,ySplit:t.from.row+e.getFrozenArea().y-1}},_getCustomizeCellOptions:function(e,t){return{excelCell:e,pivotCell:t}},_isFrozenZone:function(){return!0},_isHeaderCell:function(e,t,n){return t<e.getColumnAreaRowCount()||n<e.getRowAreaColCount()},_allowToMergeRange:function(e,t,n,i,o,a,r){return!(e.isColumnAreaCell(t,n)&&!r&&o||e.isRowAreaCell(t,n)&&!a&&i)},_getLoadPanelTargetElement:function(e){return e._dataArea.groupElement()},_getLoadPanelContainer:function(e){return e.$element()},_trySetAutoFilter:a.noop,_trySetFont:a.noop,_trySetOutlineLevel:a.noop}},48351:function(e,t,n){t.fileSaver=t.MIME_TYPES=void 0;var i=d(n(68374)),o=d(n(73349)),a=n(58201),r=d(n(55994)),s=d(n(96688)),l=n(35922),u=n(30869);function d(e){return e&&e.__esModule?e:{default:e}}var c=(0,a.getWindow)(),h=(0,a.getNavigator)(),p={EXCEL:"xlsx",CSS:"css",PNG:"png",JPEG:"jpeg",GIF:"gif",SVG:"svg",PDF:"pdf"},f={CSS:"text/css",EXCEL:"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",PNG:"image/png",JPEG:"image/jpeg",GIF:"image/gif",SVG:"image/svg+xml",PDF:"application/pdf"};t.MIME_TYPES=f;var g={_revokeObjectURLTimeout:3e4,_getDataUri:function(e,t){var n=this._getMimeType(e);return"data:".concat(n,";base64,").concat(t)},_getMimeType:function(e){return f[e]||"application/octet-stream"},_linkDownloader:function(e,t){var n=o.default.createElement("a");return n.download=e,n.href=t,n.target="_blank",n},_formDownloader:function(e,t,n,a){var s={method:"post",action:e,enctype:"multipart/form-data"},l=(0,i.default)("<form>").css({display:"none"}).attr(s);function u(e,t){for(var n in t)e.setAttribute(n,t[n]);return e}l.append(u(o.default.createElement("input"),{type:"hidden",name:"fileName",value:t})),l.append(u(o.default.createElement("input"),{type:"hidden",name:"contentType",value:n})),l.append(u(o.default.createElement("input"),{type:"hidden",name:"data",value:a})),l.appendTo("body"),r.default.trigger(l,"submit"),r.default.trigger(l,"submit")&&l.remove()},_saveByProxy:function(e,t,n,i){var o=this._getMimeType(n);return this._formDownloader(e,t,o,i)},_winJSBlobSave:function(e,t,n){var i=new Windows.Storage.Pickers.FileSavePicker;i.suggestedStartLocation=Windows.Storage.Pickers.PickerLocationId.documentsLibrary;var o=p[n];if(o){var a=this._getMimeType(n);i.fileTypeChoices.insert(a,["."+o])}i.suggestedFileName=t,i.pickSaveFileAsync().then((function(t){t&&t.openAsync(Windows.Storage.FileAccessMode.readWrite).then((function(t){var n=e.msDetachStream();Windows.Storage.Streams.RandomAccessStream.copyAsync(n,t).then((function(){t.flushAsync().done((function(){n.close(),t.close()}))}))}))}))},_click:function(e){try{e.dispatchEvent(new MouseEvent("click",{cancelable:!0}))}catch(n){var t=o.default.getDocument().createEvent("MouseEvents");t.initMouseEvent("click",!0,!0,c,0,0,0,80,20,!1,!1,!1,!1,0,null),e.dispatchEvent(t)}},_saveBlobAs:function(e,t,n){var i=this;if(this._blobSaved=!1,(0,l.isDefined)(h.msSaveOrOpenBlob))h.msSaveOrOpenBlob(n,e),this._blobSaved=!0;else if((0,l.isDefined)(c.WinJS))this._winJSBlobSave(n,e,t),this._blobSaved=!0;else{var o=c.URL||c.webkitURL||c.mozURL||c.msURL||c.oURL;if((0,l.isDefined)(o)){var a=o.createObjectURL(n),r=this._linkDownloader(e,a);setTimeout((function(){o.revokeObjectURL(a),i._objectUrlRevoked=!0}),this._revokeObjectURLTimeout),this._click(r)}else u.logger.warn("window.URL || window.webkitURL || window.mozURL || window.msURL || window.oURL is not defined")}},saveAs:function(e,t,n,i,o){var a=p[t];if(a&&(e+="."+a),(0,l.isDefined)(i)&&s.default.log("W0001","Export","proxyURL","19.2","This option is no longer required"),o)this._saveByProxy(i,e,t,n);else if((0,l.isFunction)(c.Blob))this._saveBlobAs(e,t,n);else if((0,l.isDefined)(i)&&!(0,l.isDefined)(h.userAgent.match(/iPad/i)))this._saveByProxy(i,e,t,n);else{(0,l.isDefined)(h.userAgent.match(/iPad/i))||s.default.log("E1034");var r=this._linkDownloader(e,this._getDataUri(t,n));this._click(r)}}};t.fileSaver=g},12173:function(e,t,n){t.calcScaledInfo=G,t.getData=function(e,t){return j.getData(e,t)},t.imageCreator=void 0,t.testFormats=function(e){var t=j._createCanvas(100,100,0);return e.reduce((function(e,n){var i=("image/"+n).toLowerCase();return-1!==t.toDataURL(i).indexOf(i)?e.supported.push(n):e.unsupported.push(n),e}),{supported:[],unsupported:[]})};var i=f(n(68374)),o=f(n(52752)),a=n(35922),r=n(19155),s=n(95479),l=n(13306),u=f(n(73349)),d=n(3532),c=n(58201),h=n(78008),p=n(62754);function f(e){return e&&e.__esModule?e:{default:e}}var g,m=(0,c.getWindow)(),_=Math,v=_.PI,y=_.min,b=_.abs,x=_.sqrt,w=_.pow,C=_.atan2,S=_.cos,k=_.sin,D=Number;function I(e,t,n,i,o,a,r,s){var l=(e+n)/2,u=(t+i)/2,d=C(t-i,e-n),c=a?1:-1;d+=v/180*90*(r?1:-1);var h=x(w(n-e,2)+w(i-t,2))/2,p=x(b(w(o,2)-w(h,2))),f=l+c*(p*S(d)),g=u+c*(p*k(d)),m=C(t-g,e-f),_=C(i-g,n-f);s.arc(f,g,o,m,_,!r)}function T(e,t){var n,i=g(e.attributes||{}),o=(0,l.extend)({},i,{text:e.textContent.replace(/\s+/g," "),textAlign:"middle"===i["text-anchor"]?"center":i["text-anchor"]}),r=i.transform;return r&&((n=r.match(/translate\(-*\d+([.]\d+)*(,*\s*-*\d+([.]\d+)*)*/))&&(n=n[0].match(/-*\d+([.]\d+)*/g),o.translateX=D(n[0]),o.translateY=n[1]?D(n[1]):0),(n=r.match(/rotate\(-*\d+([.]\d+)*(,*\s*-*\d+([.]\d+)*,*\s*-*\d+([.]\d+)*)*/))&&(n=n[0].match(/-*\d+([.]\d+)*/g),o.rotationAngle=D(n[0]),o.rotationX=n[1]&&D(n[1]),o.rotationY=n[2]&&D(n[2])),(n=r.match(/scale\(-*\d+([.]\d+)*(,*\s*-*\d+([.]\d+)*)*/))&&(n=n[0].match(/-*\d+([.]\d+)*/g),o.scaleX=D(n[0]),n.length>1?o.scaleY=D(n[1]):o.scaleY=o.scaleX)),function(e,t,n){var i,o=e.style||{};for(i in o)""!==o[i]&&(t[(0,h.camelize)(i)]=o[i]);n&&u.default.isElementNode(e)&&(o=m.getComputedStyle(e),["fill","stroke","stroke-width","font-family","font-size","font-style","font-weight"].forEach((function(e){e in o&&""!==o[e]&&(t[(0,h.camelize)(e)]=o[e])})),["opacity","fill-opacity","stroke-opacity"].forEach((function(e){e in o&&""!==o[e]&&"1"!==o[e]&&(t[e]=D(o[e]))})));t.textDecoration=t.textDecoration||t.textDecorationLine,t.globalAlpha=(0,a.isDefined)(t.opacity)?t.opacity:t.globalAlpha}(e,o,t),o}function E(e){var t=e&&e.match(/url\(.*#(.*?)["']?\)/i);return t&&t[1]}function O(e,t){var n=[];t.fontSize=t.fontSize||"10px",t.fontFamily=t.fontFamily||"sans-serif",t.fill=t.fill||"#000",t.fontStyle&&n.push(t.fontStyle),t.fontWeight&&n.push(t.fontWeight),n.push(t.fontSize),n.push(t.fontFamily),e.font=n.join(" "),e.textAlign=t.textAlign,e.fillStyle=t.fill,e.globalAlpha=t.globalAlpha}function A(e,t,n){O(e,t),M(e,t,n),t.text&&e.fillText(t.text,t.x||0,t.y||0),H(e,t,!0),function(e,t,n){if(!t.textDecoration||"none"===t.textDecoration)return;var i=t.x,o=e.measureText(t.text).width,a=parseInt(t.fontSize,10),r=.05*a<1?1:.05*a,s=t.y;switch(t.textDecoration){case"line-through":s-=a/3+r/2;break;case"overline":s-=a-r;break;case"underline":s+=r}e.rect(i,s,o,r),N(e,t,n),H(e,t)}(e,t,n)}function P(e){for(var t=e.childNodes,n=0;n<t.length;n++)if("tspan"===t[n].tagName)return!0;return!1}function R(e,t,n,i){var o=e.tagName,a="text"===o||"tspan"===o||void 0===o,s="image"===o,u=(0,l.extend)({},n,T(e,i.rootAppended));if("hidden"!==u.visibility&&!u[r.HIDDEN_FOR_EXPORT]){var d;switch(t.save(),!s&&B(t,u),L(t,u,i),function(e){e.strokeOpacity=void 0!==e["stroke-opacity"]?e["stroke-opacity"]:1,e.fillOpacity=void 0!==e["fill-opacity"]?e["fill-opacity"]:1,void 0!==e.opacity&&(e.strokeOpacity*=e.opacity,e.fillOpacity*=e.opacity)}(u),t.beginPath(),e.tagName){case void 0:A(t,u,i);break;case"text":case"tspan":!function e(t,n,i,o){for(var a,r=[],s=0,u=0;u<t.length;u++){var d=t[u];if(void 0===d.tagName)R(d,n,i,o);else if("tspan"===d.tagName||"text"===d.tagName){var c=T(d,o.rootAppended),h=(0,l.extend)({},i,c);if("tspan"===d.tagName&&P(d)){e(d.childNodes,n,h,o);continue}h.textAlign="start",a&&void 0===c.x||(a={elements:[],options:[],widths:[],offsets:[]},r.push(a)),void 0!==c.y&&(s=0),void 0!==c.dy&&(s+=parseFloat(c.dy)),a.elements.push(d),a.options.push(h),a.offsets.push(s),O(n,h),a.widths.push(n.measureText(h.text).width)}}r.forEach((function(t){var a=t.widths.reduce((function(e,t){return e+t}),0),r=0,s=0;"center"===i.textAlign&&(r=a/2),"end"===i.textAlign&&(r=a),t.options.forEach((function(e,n){var i=t.widths[n];e.x=e.x-r+s,e.y+=t.offsets[n],s+=i})),t.elements.forEach((function(i,a){e(i.childNodes,n,t.options[a],o)}))}))}(e.childNodes,t,u,i);break;case"image":d=function(e,t,n){var i=new p.Deferred,o=new m.Image;return o.onload=function(){e.save(),e.globalAlpha=t.globalAlpha,B(e,t),L(e,t,n),e.drawImage(o,t.x||0,t.y||0,t.width,t.height),e.restore(),i.resolve()},o.onerror=function(){i.resolve()},o.setAttribute("crossOrigin","anonymous"),o.src=t.href||t["xlink:href"],i}(t,u,i);break;case"path":!function(e,t){var n,i,o,a=t.replace(/,/g," ").split(/([A-Z])/i).filter((function(e){return""!==e.trim()})),r=0;do{switch(n=(a[r+1]||"").trim().split(" "),a[r]){case"M":e.moveTo(D(n[0]),D(n[1])),r+=2;break;case"L":for(var s=0;s<n.length/2;s++)e.lineTo(D(n[2*s]),D(n[2*s+1]));r+=2;break;case"C":e.bezierCurveTo(D(n[0]),D(n[1]),D(n[2]),D(n[3]),D(n[4]),D(n[5])),r+=2;break;case"a":o=(i=a[r-1].trim().split(" ")).length-1,I(D(i[o-1]),D(i[o]),D(i[o-1])+D(n[5]),D(i[o])+D(n[6]),D(n[0]),D(n[3]),D(n[4]),e),r+=2;break;case"A":o=(i=a[r-1].trim().split(" ")).length-1,I(D(i[o-1]),D(i[o]),D(n[5]),D(n[6]),D(n[0]),D(n[3]),D(n[4]),e),r+=2;break;case"Z":e.closePath(),r+=1;break;default:r++}}while(r<a.length)}(t,u.d);break;case"rect":!function(e,t){var n=t.x,i=t.y,o=t.width,a=t.height,r=t.rx;r?(r=y(r,o/2,a/2),e.save(),e.translate(n,i),e.moveTo(o/2,0),e.arcTo(o,0,o,a,r),e.arcTo(o,a,0,a,r),e.arcTo(0,a,0,0,r),e.arcTo(0,0,r,0,r),e.lineTo(o/2,0),e.restore()):e.rect(n,i,o,a)}(t,u),t.closePath();break;case"circle":t.arc(u.cx,u.cy,u.r,0,2*v,1)}return a||(M(t,u,i),N(t,u,i),H(t,u)),function(e,t,n,i){var o=n.gradients;if(0===o.length)return;var a=E(t.fill);if(a&&o[a]){var r=i.getBBox(),s=e.createLinearGradient(r.x,0,r.x+r.width,0);o[a].forEach((function(e){var t=parseInt(e.offset.replace(/%/,""));s.addColorStop(t/100,e.stopColor)})),e.globalAlpha=t.opacity,e.fillStyle=s,e.fill()}}(t,u,i,e),t.restore(),d}}function M(e,t,n){var i,o=E(t.filter);o&&((i=n.filters[o])||(i={offsetX:0,offsetY:0,blur:0,color:"#000"}),e.shadowOffsetX=i.offsetX,e.shadowOffsetY=i.offsetY,e.shadowColor=i.color,e.shadowBlur=i.blur)}function B(e,t){e.translate(t.translateX||0,t.translateY||0),t.translateX=void 0,t.translateY=void 0,t.rotationAngle&&(e.translate(t.rotationX||0,t.rotationY||0),e.rotate(t.rotationAngle*v/180),e.translate(-(t.rotationX||0),-(t.rotationY||0)),t.rotationAngle=void 0,t.rotationX=void 0,t.rotationY=void 0),isFinite(t.scaleX)&&(e.scale(t.scaleX,t.scaleY),t.scaleX=void 0,t.scaleY=void 0)}function L(e,t,n){t["clip-path"]&&(R(n.clipPaths[E(t["clip-path"])],e,{},n),e.clip(),t["clip-path"]=void 0)}function V(e){var t,n,i={};return(0,s.each)(e.childNodes,(function(e,a){var r=a.attributes;if(r.result)switch(r.result.value){case"gaussianBlurResult":i.blur=D(r.stdDeviation.value);break;case"offsetResult":i.offsetX=D(r.dx.value),i.offsetY=D(r.dy.value);break;case"floodResult":t=r["flood-color"]?r["flood-color"].value:"#000",n=r["flood-opacity"]?r["flood-opacity"].value:1,i.color=function(e,t){var n=new o.default(e);return"rgba("+n.r+","+n.g+","+n.b+","+t+")"}(t,n)}})),i}function F(e,t,n,i){return function e(t,n){for(var i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:new p.Deferred,o=0;o<t.length;o++){var r=n(t[o]);if((0,a.isPromise)(r)){r.then((function(){e(Array.prototype.slice.call(t,o+1),n,i)}));break}}return o===t.length&&i.resolve(),i}(e,(function(e){switch(e.tagName&&e.tagName.toLowerCase()){case"g":case"svg":var o=(0,l.extend)({},n,T(e,i.rootAppended));t.save(),B(t,o),L(t,o,i);var r=function(){t.restore()},u=F(e.childNodes,t,o,i);return(0,a.isPromise)(u)?u.then(r):r(),u;case"defs":return F(e.childNodes,t,{},i);case"clippath":i.clipPaths[e.attributes.id.textContent]=e.childNodes[0];break;case"pattern":i.patterns[e.attributes.id.textContent]=e;break;case"filter":i.filters[e.id]=V(e);break;case"lineargradient":i.gradients[e.attributes.id.textContent]=function(e){var t=[];return(0,s.each)(e.childNodes,(function(e,n){var i=n.attributes;t.push({offset:i.offset.value,stopColor:i["stop-color"].value})})),t}(e);break;default:return R(e,t,n,i)}}))}function H(e,t,n){var i=t.stroke;i&&"none"!==i&&0!==t["stroke-width"]&&(!function(e,t){var n=t["stroke-dasharray"]&&t["stroke-dasharray"].match(/(\d+)/g);n&&n.length&&(n=(0,s.map)(n,(function(e){return D(e)})),e.setLineDash(n))}(e,t),e.lineJoin=t["stroke-linejoin"],e.lineWidth=t["stroke-width"],e.globalAlpha=t.strokeOpacity,e.strokeStyle=i,n?e.strokeText(t.text,t.x,t.y):e.stroke(),e.globalAlpha=1)}function N(e,t,n){var i=t.fill;if(i&&"none"!==i){if(-1===i.search(/url/))e.fillStyle=i;else{var o=n.patterns[E(i)];if(!o)return;e.fillStyle=function(e,t,n){var i=T(t,n.rootAppended),o=j._createCanvas(i.width,i.height,0),a=o.getContext("2d");return F(t.childNodes,a,i,n),e.createPattern(o,"repeat")}(e,o,n)}e.globalAlpha=t.fillOpacity,e.fill(),e.globalAlpha=1}}function z(e,t,n){return F(e.childNodes,t.getContext("2d"),{},{clipPaths:{},patterns:{},filters:{},gradients:{},rootAppended:n})}function W(e,t){var n=t.width,i=t.height,o=t.backgroundColor,a=t.margin,s=t.svgToCanvas,l=void 0===s?z:s,c=G(n,i),h=j._createCanvas(c.width,c.height,a),f=h.getContext("2d");f.setTransform(c.pixelRatio,0,0,c.pixelRatio,0,0);var g,m=(0,r.getSvgElement)(e),_=u.default.isElementNode(e);return f.translate(a,a),u.default.getBody().appendChild(h),_||((g=function(){var e=u.default.createElement("div");return e.style.left="-9999px",e.style.position="absolute",e}()).appendChild(m),u.default.getBody().appendChild(g)),m.attributes.direction&&(h.dir=m.attributes.direction.textContent),function(e,t,n,i,o){e.fillStyle=i||"#ffffff",e.fillRect(-o,-o,t+2*o,n+2*o)}(f,n,i,o,a),(0,p.fromPromise)(l(m,h,_&&(0,d.contains)(u.default.getBody(),e))).then((function(){return h})).always((function(){g&&u.default.getBody().removeChild(g),u.default.getBody().removeChild(h)}))}g=function(e){var t,n={};return(0,s.each)(e,(function(e,i){t=i.textContent,isFinite(t)&&(t=D(t)),n[i.name.toLowerCase()]=t})),n};var j={getImageData:function(e,t){var n="image/"+t.format;return(0,a.isFunction)(t.__parseAttributesFn)&&(g=t.__parseAttributesFn),W(e,t).then((function(e){return function(e,t){var n=e.toDataURL(t,1);return m.atob(n.substring(("data:"+t+";base64,").length))}(e,n)}))},getData:function(e,t){var n=this;return j.getImageData(e,t).then((function(e){var i="image/"+t.format;return(0,a.isFunction)(m.Blob)&&!t.forceProxy?n._getBlob(e,i):n._getBase64(e)}))},_getBlob:function(e,t){var n,i=new Uint8Array(e.length);for(n=0;n<e.length;n++)i[n]=e.charCodeAt(n);return new m.Blob([i.buffer],{type:t})},_getBase64:function(e){return m.btoa(e)},_createCanvas:function(e,t,n){var o=(0,i.default)("<canvas>")[0];return o.width=e+2*n,o.height=t+2*n,o.hidden=!0,o}};function G(e,t){var n=m.devicePixelRatio||1;return{pixelRatio:n,width:e*n,height:t*n}}t.imageCreator=j},18577:function(e,t,n){t.Export=void 0;var i=n(35922),o=n(13306),a=d(n(91500)),r=d(n(18016)),s=d(n(28109)),l=n(5332),u=n(58201);function d(e){return e&&e.__esModule?e:{default:e}}var c={getFullOptions:function(e){var t=(0,o.extend)({},e);if(!(0,i.isDefined)(t.jsPDFDocument)||!(0,i.isObject)(t.jsPDFDocument))throw Error('The "jsPDFDocument" field must contain a jsPDF instance.');if(!(0,i.isDefined)(t.jsPDFDocument.autoTable)||!(0,i.isFunction)(t.jsPDFDocument.autoTable))throw Error('The "exportDataGrid" method requires a autoTable plugin for jsPDF object.');if((0,i.isDefined)(t.keepColumnWidths)||(t.keepColumnWidths=!0),(0,i.isDefined)(t.autoTableOptions)){if(!(0,i.isObject)(t.autoTableOptions))throw Error('The "autoTableOptions" option must be of object type.');t.autoTableOptions=(0,o.extend)(!0,{},this._getDefaultAutoTableOptions(),t.autoTableOptions)}else t.autoTableOptions=this._getDefaultAutoTableOptions();return(0,i.isDefined)(t.loadPanel)||(t.loadPanel={}),(0,i.isDefined)(t.loadPanel.enabled)||(t.loadPanel.enabled=!0),(0,i.isDefined)(t.loadPanel.text)||(t.loadPanel.text=s.default.format("dxDataGrid-exporting")),t},_getDefaultAutoTableOptions:function(){return{theme:"plain",tableLineColor:149,tableLineWidth:.1,styles:{textColor:51,lineColor:149,lineWidth:0},columnStyles:{},headStyles:{fontStyle:"normal",textColor:149,lineWidth:.1},bodyStyles:{lineWidth:.1},head:[],body:[]}},export:function(e){var t,n,o=this,a=e.jsPDFDocument,r=e.autoTableOptions,s=e.component,d=e.customizeCell,c=e.keepColumnWidths,h=e.selectedRowsOnly,p=e.loadPanel,f=(null===(t=s._getInternalInstance)||void 0===t?void 0:t.call(s))||s,g=f.option("loadPanel")&&f.option("loadPanel").enabled;if(g&&s.option("loadPanel.enabled",!1),p.enabled&&(0,u.hasWindow)()){var m=s.getView("rowsView");(n=new l.ExportLoadPanel(s,m.element(),m.element().parent(),p)).show()}var _=s.getDataProvider(h),v=!!s.option("wordWrapEnabled");return new Promise((function(e){_.ready().done((function(){var t=_.getColumns(),n=_.getStyles(),s=_.getRowsCount(),l=_.getHeaderRowCount(),u=[];if(c){var h=o._tryGetPdfColumnWidths(r.tableWidth,_.getColumnsWidths());(0,i.isDefined)(h)&&(0,i.isDefined)(r.columnStyles)&&o._setColumnWidths(r.columnStyles,h)}for(var p=0;p<s;p++){for(var f=[],g=0;g<t.length;g++){var m=_.getCellData(p,g,!0),y=m.value,b=m.cellSourceData,x=n[_.getStyleId(p,g)],w={content:o._getFormattedValue(y,x.format),styles:o._getPDFCellStyles(b.rowType,t[g].alignment,x,v)};if("header"===b.rowType){var C=o._tryGetMergeRange(p,g,u,_);C&&C.rowSpan>0&&(w.rowSpan=C.rowSpan+1),C&&C.colSpan>0&&(w.colSpan=C.colSpan+1),(!(u[p]&&u[p][g])||w.rowSpan>1||w.colSpan>1)&&((0,i.isFunction)(d)&&d({gridCell:b,pdfCell:w}),f.push(w))}else if("group"!==b.rowType||(0,i.isDefined)(w.content)||1!==f.length){var S;w.content=null!==(S=w.content)&&void 0!==S?S:"",(0,i.isFunction)(d)&&d({gridCell:b,pdfCell:w}),f.push(w)}else{var k;f[0].colSpan=null!==(k=f[0].colSpan)&&void 0!==k?k:1,f[0].colSpan++}}p<l?r.head.push(f):r.body.push(f)}a.autoTable(r),e()})).always((function(){g&&s.option("loadPanel.enabled",g),p.enabled&&(0,u.hasWindow)()&&n.dispose()}))}))},_getFormattedValue:function(e,t){if((0,i.isDefined)(t)){if((0,i.isDate)(e))return a.default.format(e,t);if((0,i.isNumeric)(e))return r.default.format(e,t)}return e},_getPDFCellStyles:function(e,t,n,i){var o=n.alignment,a=n.bold,r="header"===e?t:o,s={};return r&&(s.halign=r),a&&"header"!==e&&(s.fontStyle="bold"),i&&(s.cellWidth="wrap"),s},_tryGetMergeRange:function(e,t,n,i){if(!n[e]||!n[e][t]){var o=i.getCellMerging(e,t),a=o.colspan,r=o.rowspan;if(a||r){for(var s=e;s<=e+r;s++)for(var l=t;l<=t+a;l++)n[s]||(n[s]=[]),n[s][l]=!0;return{rowSpan:r,colSpan:a}}}},_tryGetPdfColumnWidths:function(e,t){if((0,i.isNumeric)(e)&&(0,i.isDefined)(t)){var n=t.reduce((function(e,t){return e+t}),0);return t.map((function(t){return e*t/n}))}},_setColumnWidths:function(e,t){t.forEach((function(t,n){e[n]=e[n]||{},e[n].cellWidth=t}))}};t.Export=c},83152:function(e,t,n){t.exportDataGrid=function(e){return o.Export.export(function(e){if(!(0,i.isDefined)(e)||!(0,i.isObject)(e))throw Error('The "exportDataGrid" method requires a configuration object.');if(!(0,i.isDefined)(e.component)||!(0,i.isObject)(e.component)||"dxDataGrid"!==e.component.NAME)throw Error('The "component" field must contain a DataGrid instance.');(0,i.isDefined)(e.selectedRowsOnly)||(e.selectedRowsOnly=!1);return o.Export.getFullOptions(e)}(e))};var i=n(35922),o=n(18577)},66867:function(e,t,n){t.addNewPage=function(e){e.addPage(),function(e){(0,i.isDefined)(e.getLineWidth)||(e.__borderWidth=null)}(e)},t.drawCellsContent=function(e,t,n,a){n.forEach((function(n){var r=n._rect,u=n.gridCell,h=function(e,t){if(null==e)return{};var n,i,o=function(e,t){if(null==e)return{};var n,i,o={},a=Object.keys(e);for(i=0;i<a.length;i++)n=a[i],t.indexOf(n)>=0||(o[n]=e[n]);return o}(e,t);if(Object.getOwnPropertySymbols){var a=Object.getOwnPropertySymbols(e);for(i=0;i<a.length;i++)n=a[i],t.indexOf(n)>=0||Object.prototype.propertyIsEnumerable.call(e,n)&&(o[n]=e[n])}return o}(n,s),p=r.x,g=r.y,m=r.w,_=r.h,v={doc:e,rect:{x:p,y:g,w:m,h:_},pdfCell:h,gridCell:u,cancel:!1};null==t||t(v),v.cancel||(function(e,t){(0,i.isDefined)(t.backgroundColor)&&(f(e,"fill",t.backgroundColor),d(e,t._rect.x,t._rect.y,t._rect.w,t._rect.h,"F"))}(e,n),function(e,t,n){if((0,i.isDefined)(t.text)&&""!==t.text){var a=t.textColor,r=t.font,s=t._rect,u=t.padding;!function(e,t,n){var a=t.textColor,r=t.font;f(e,"text",(0,i.isDefined)(a)?a:n.textColor);var s=(0,i.isDefined)(r)?(0,o.extend)({},n.font,r):n.font,l=e.getFont();(s.name!==l.fontName||s.style!==l.fontStyle||(0,i.isDefined)(s.weight))&&e.setFont(s.name,s.style,s.weight);s.size!==e.getFontSize()&&e.setFontSize(s.size)}(e,{textColor:a,font:r},n);var d,h,p={x:s.x+u.left,y:s.y+u.top,w:s.w-(u.left+u.right),h:s.h-(u.top+u.bottom)};if((0,i.isDefined)(t._textLeftOffset)||(0,i.isDefined)(t._textTopOffset))p.x=p.x+(null!==(d=t._textLeftOffset)&&void 0!==d?d:0),p.y=p.y+(null!==(h=t._textTopOffset)&&void 0!==h?h:0),e.saveGraphicsState(),function(e,t,n,i,o){e.moveTo(l(t),l(n)),e.lineTo(l(t+i),l(n)),e.lineTo(l(t+i),l(n+o)),e.lineTo(l(t),l(n+o)),e.clip(),e.discardPath()}(e,t._rect.x,t._rect.y,t._rect.w,t._rect.h);c(e,t.text,p,t.verticalAlign,t.horizontalAlign,t._internalTextOptions),((0,i.isDefined)(t._textLeftOffset)||(0,i.isDefined)(t._textTopOffset))&&e.restoreGraphicsState()}}(e,n,a))}))},t.drawCellsLines=function(e,t,n){t.filter((function(e){return!(0,i.isDefined)(e.borderColor)})).forEach((function(t){h(e,t._rect,t,n)})),t.filter((function(e){return(0,i.isDefined)(e.borderColor)})).forEach((function(t){h(e,t._rect,t,n)}))},t.drawGridLines=function(e,t,n,i){h(e,t,n,i)},t.drawLine=u,t.drawRect=d,t.drawTextInRect=c,t.getDocumentStyles=function(e){var t=e.getFont();return{borderWidth:g(e),borderColor:e.getDrawColor(),font:{name:t.fontName,style:t.fontStyle,size:e.getFontSize()},textColor:e.getTextColor()}},t.roundToThreeDecimals=l,t.setDocumentStyles=function(e,t){var n=t.borderWidth,i=t.borderColor,o=t.font,a=t.textColor,r=e.getFont();r.fontName===o.name&&r.fontStyle===o.style||e.setFont(o.name,o.style,void 0);e.getFontSize()!==o.size&&e.setFontSize(o.size);g(e)!==n&&m(e,n);e.getDrawColor()!==i&&e.setDrawColor(i);e.getTextColor()!==a&&e.setTextColor(a)};var i=n(35922),o=n(13306),a=n(79262),r=n(87280),s=["_rect","gridCell"];function l(e){return Math.round(1e3*e)/1e3}function u(e,t,n,i,o){e.line(l(t),l(n),l(i),l(o))}function d(e,t,n,o,a,r){(0,i.isDefined)(r)?e.rect(l(t),l(n),l(o),l(a),r):e.rect(l(t),l(n),l(o),l(a))}function c(e,t,n,i,r,s){var u=t.split("\n"),d=u.length,c=(0,a.calculateTextHeight)(e,u[0],e.getFont(),{wordWrapEnabled:!1,targetRectWidth:1e9}),h=null!=i?i:"middle",p=null!=r?r:"left",f={top:0,middle:.5,bottom:1},g=n.y+n.h*f[h]-c*(d-1)*f[h]+function(e){return(e.getLineHeightFactor()-1.15)*e.getFontSize()}(e),m=n.x+n.w*{left:0,center:.5,right:1}[p],_=(0,o.extend)({baseline:h,align:p},s);e.text(u.join("\n"),l(m),l(g),_)}function h(e,t,n,o){var a=n.borderWidth,r=n.borderColor,s=n.drawLeftBorder,l=void 0===s||s,c=n.drawRightBorder,h=void 0===c||c,f=n.drawTopBorder,g=void 0===f||f,m=n.drawBottomBorder,_=void 0===m||m;if(!(0,i.isDefined)(t))throw"rect is required";(l||h||g||_)&&(l&&h&&g&&_?(p(e,{borderWidth:a,borderColor:r},o),d(e,t.x,t.y,t.w,t.h)):(p(e,{borderWidth:a,borderColor:r},o),g&&u(e,t.x,t.y,t.x+t.w,t.y),l&&u(e,t.x,t.y,t.x,t.y+t.h),h&&u(e,t.x+t.w,t.y,t.x+t.w,t.y+t.h),_&&u(e,t.x,t.y+t.h,t.x+t.w,t.y+t.h)))}function p(e,t,n){var o=t.borderWidth,r=t.borderColor,s=(0,i.isDefined)(o)?o:n.borderWidth;s!==g(e)&&m(e,(0,a.toPdfUnit)(e,s)),f(e,"draw",(0,i.isDefined)(r)?r:n.borderColor)}function f(e,t,n){var i="get".concat((0,r.capitalizeFirstLetter)(t),"Color"),o="set".concat((0,r.capitalizeFirstLetter)(t),"Color"),a=n.ch1,s=void 0===a?n:a,l=n.ch2,u=n.ch3,d=n.ch4;e.__private__.decodeColorString(e.__private__.encodeColorString({ch1:s,ch2:l,ch3:u,ch4:d,precision:"text"===t?3:2}))===e[i]()&&"fill"!==t||e[o].apply(e,[s,l,u,d].filter((function(e){return void 0!==e})))}function g(e){var t;return(0,i.isDefined)(e.getLineWidth)?e.getLineWidth():null!==(t=e.__borderWidth)&&void 0!==t?t:.200025}function m(e,t){e.setLineWidth(t),(0,i.isDefined)(e.getLineWidth)||(e.__borderWidth=t)}},17195:function(e,t,n){t.Export=void 0;var i,o=n(35922),a=n(13306),r=n(30646),s=n(65322),l=n(41269),u=n(27504),d=n(22775),c=n(66867),h=n(79262),p=(i=n(28109))&&i.__esModule?i:{default:i},f=n(5332),g=n(58201);function m(){return(m=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(e[i]=n[i])}return e}).apply(this,arguments)}var _={getFullOptions:function(e){var t=e.jsPDFDocument,n=(0,a.extend)({},e);return(0,o.isDefined)(n.topLeft)||(n.topLeft={x:0,y:0}),(0,o.isDefined)(n.indent)||(n.indent=0),(0,o.isDefined)(n.repeatHeaders)||(n.repeatHeaders=!0),(0,o.isDefined)(n.margin)||(n.margin=(0,h.toPdfUnit)(t,40)),n.margin=(0,r.normalizeBoundaryValue)(n.margin),Array.isArray(n.columnWidths)||(n.columnWidths=[]),(0,o.isDefined)(n.loadPanel)||(n.loadPanel={}),(0,o.isDefined)(n.loadPanel.enabled)||(n.loadPanel.enabled=!0),(0,o.isDefined)(n.loadPanel.text)||(n.loadPanel.text=p.default.format("dxDataGrid-exporting")),n},export:function(e){var t,n,i=e.jsPDFDocument,a=e.component,p=e.selectedRowsOnly,_=e.loadPanel,v=(null===(t=a._getInternalInstance)||void 0===t?void 0:t.call(a))||a,y=v.option("loadPanel")&&v.option("loadPanel").enabled;if(y&&a.option("loadPanel.enabled",!1),_.enabled&&(0,g.hasWindow)()){var b=a.getView("rowsView");(n=new f.ExportLoadPanel(a,b.element(),b.element().parent(),_)).show()}var x=a.getDataProvider(p);return new Promise((function(t){x.ready().done((function(){var n,p,f=(0,u.generateRowsInfo)(i,x,a,null===(n=e.rowOptions)||void 0===n||null===(p=n.headerStyles)||void 0===p?void 0:p.backgroundColor);e.customizeCell&&f.forEach((function(t){return t.cells.forEach((function(t){return e.customizeCell(t)}))})),(0,r.normalizeRowsInfo)(f),(0,s.initializeCellsWidth)(i,x,f,e),(0,s.resizeFirstColumnByIndentLevel)(f,e),(0,s.applyColSpans)(f),(0,s.calculateHeights)(i,f,e),(0,s.applyRowSpans)(f),(0,l.updateRowsAndCellsHeights)(i,f),(0,s.calculateCoordinates)(i,f,e),(0,s.applyBordersConfig)(f),(0,h.applyWordWrap)(i,f);var g=(0,c.getDocumentStyles)(i),_=!!a.option("rtlEnabled"),v=(0,d.splitByPages)(i,f,e,(function(e){var t,n=e.sourceRect,a=e.leftRect,r=e.rightRect,s={},l={};if((null===(t=n.sourceCellInfo.text)||void 0===t?void 0:t.length)>0)if(_){var u=i.getTextWidth(n.sourceCellInfo.text)>a.w,d=!(0,o.isDefined)(n.sourceCellInfo.horizontalAlign)||"right"===n.sourceCellInfo.horizontalAlign;if(u||!d){var c,h,p,f,g,v;if("right"===(null===(c=n.sourceCellInfo)||void 0===c?void 0:c.horizontalAlign))g=(f=null!==(v=n.sourceCellInfo._textLeftOffset)&&void 0!==v?v:0)+a.w;else"center"===(null===(h=n.sourceCellInfo)||void 0===h?void 0:h.horizontalAlign)?f=(g=n.x+n.w-(r.x+r.w)+n.sourceCellInfo._rect.w/2-a.w/2)-r.w:"left"===(null===(p=n.sourceCellInfo)||void 0===p?void 0:p.horizontalAlign)&&(f=(g=n.x+n.w-(r.x+r.w))-r.w);s=m({},{_textLeftOffset:f}),l=m({},{_textLeftOffset:g})}else l=m({},{text:""})}else{var y=i.getTextWidth(n.sourceCellInfo.text)>a.w,b=!(0,o.isDefined)(n.sourceCellInfo.horizontalAlign)||"left"===n.sourceCellInfo.horizontalAlign;if(y||!b){var x,w,C,S,k,D;if("left"===(null===(x=n.sourceCellInfo)||void 0===x?void 0:x.horizontalAlign))k=(S=null!==(D=n.sourceCellInfo._textLeftOffset)&&void 0!==D?D:0)-a.w;else if("center"===(null===(w=n.sourceCellInfo)||void 0===w?void 0:w.horizontalAlign)){var I,T=null!==(I=n.sourceCellInfo._textLeftOffset)&&void 0!==I?I:0;S=T+(n.x+n.w/2)-(a.x+a.w/2),k=T+(n.x+n.w/2)-(r.x+r.w/2)}else"right"===(null===(C=n.sourceCellInfo)||void 0===C?void 0:C.horizontalAlign)&&(S=n.x+n.w-(a.x+a.w),k=n.x+n.w-(r.x+r.w));s=m({},{_textLeftOffset:S}),l=m({},{_textLeftOffset:k})}else l=m({},{text:""})}a.sourceCellInfo=m({},n.sourceCellInfo,{debugSourceCellInfo:n.sourceCellInfo},s),r.sourceCellInfo=m({},n.sourceCellInfo,{debugSourceCellInfo:n.sourceCellInfo},l)}),(function(e){var t,n=e.sourceRect,o=e.topRect,a=e.bottomRect,r={},s={};if((null===(t=n.sourceCellInfo.text)||void 0===t?void 0:t.length)>0){var l,u=i.getTextDimensions(n.sourceCellInfo.text).h>o.h,d="top"===(null===(l=n.sourceCellInfo)||void 0===l?void 0:l.verticalAlign);if(u||!d){var c,h,p,f,g,_;if("top"===(null===(c=n.sourceCellInfo)||void 0===c?void 0:c.verticalAlign))g=(f=null!==(_=n.sourceCellInfo._textTopOffset)&&void 0!==_?_:0)-o.h;else if("middle"===(null===(h=n.sourceCellInfo)||void 0===h?void 0:h.verticalAlign)){var v,y=null!==(v=n.sourceCellInfo._textTopOffset)&&void 0!==v?v:0;f=y+(n.y+n.h/2)-(o.y+o.h/2),g=y+(n.y+n.h/2)-(a.y+a.h/2)}else"bottom"===(null===(p=n.sourceCellInfo)||void 0===p?void 0:p.verticalAlign)&&(f=n.y+n.h-(o.y+o.h),g=n.y+n.h-(a.y+a.h));r=m({},{_textTopOffset:f}),s=m({},{_textTopOffset:g})}else s=m({},{text:""})}o.sourceCellInfo=m({},n.sourceCellInfo,{debugSourceCellInfo:n.sourceCellInfo},r),a.sourceCellInfo=m({},n.sourceCellInfo,{debugSourceCellInfo:n.sourceCellInfo},s)}));_&&(0,h.applyRtl)(i,v,e),v.forEach((function(t,n){if(n>0&&(0,c.addNewPage)(i),(0,c.drawCellsContent)(i,e.customDrawCell,t,g),(0,c.drawCellsLines)(i,t,g),(0,o.isDefined)(t)&&0===t.length){var a=(0,s.calculateTableSize)(i,t,e),r=(0,u.getBaseTableStyle)();(0,c.drawGridLines)(i,a,r,g)}})),(0,c.setDocumentStyles)(i,g),t()})).always((function(){y&&a.option("loadPanel.enabled",y),_.enabled&&(0,g.hasWindow)()&&n.dispose()}))}))}};t.Export=_},41269:function(e,t,n){t.updateRowsAndCellsHeights=function(e,t){var n=function(e,t){var n=Array.from({length:t.length},(function(){return 0}));return s(t).forEach((function(a){a.cells.filter((function(e){return(0,i.isDefined)(e.rowSpan)})).forEach((function(i){var r=(0,o.calculateTargetRectWidth)(i.pdfCell._rect.w,i.pdfCell.padding),s=(0,o.calculateTextHeight)(e,i.pdfCell.text,i.pdfCell.font,{wordWrapEnabled:i.pdfCell.wordWrapEnabled,targetRectWidth:r})+i.pdfCell.padding.top+i.pdfCell.padding.bottom,l=i.rowSpan+1,u=t.slice(a.rowIndex,a.rowIndex+l).reduce((function(e,t){return e+t.height+n[t.rowIndex]}),0);if(s>u)for(var d=(s-u)/l,c=a.rowIndex;c<a.rowIndex+l;c++)n[c]+=d}))})),n}(e,t);t.forEach((function(e){e.height+=n[e.rowIndex]})),t.forEach((function(e){e.cells.forEach((function(n){var i,o=(null!==(i=n.rowSpan)&&void 0!==i?i:0)+1;n.pdfCell._rect.h=t.slice(e.rowIndex,e.rowIndex+o).reduce((function(e,t){return e+t.height}),0)}))}))};var i=n(35922),o=n(79262);function a(e){return function(e){if(Array.isArray(e))return r(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return r(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return r(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function r(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}function s(e){var t=function(e){var t=e.cells.map((function(e){var t;return null!==(t=e.rowSpan)&&void 0!==t?t:0}));return Math.max.apply(Math,a(t))};return a(e).sort((function(e,n){var i=t(e),o=t(n);return i>o?1:o>i?-1:0}))}},30646:function(e,t,n){t.normalizeBoundaryValue=o,t.normalizeRowsInfo=function(e){e.forEach((function(e){e.cells.forEach((function(e){var t=e.pdfCell;t.padding=o(t.padding)}))}))};var i=n(35922);function o(e){var t,n,o,a;return(0,i.isNumeric)(e)?{top:e,right:e,bottom:e,left:e}:{top:null!==(t=null==e?void 0:e.top)&&void 0!==t?t:0,right:null!==(n=null==e?void 0:e.right)&&void 0!==n?n:0,bottom:null!==(o=null==e?void 0:e.bottom)&&void 0!==o?o:0,left:null!==(a=null==e?void 0:e.left)&&void 0!==a?a:0}}},79262:function(e,t,n){t.applyRtl=function(e,t,n){t.forEach((function(t){t.forEach((function(t){var i=o(e)-(t._rect.x+t._rect.w),a=n.margin.left-n.margin.right;t._rect.x=i+a}))}))},t.applyWordWrap=function(e,t){t.forEach((function(t){t.cells.forEach((function(t){var n=t.pdfCell;if((0,i.isDefined)(n.text)){var o=a(e,n.text,n.font,{wordWrapEnabled:n.wordWrapEnabled,targetRectWidth:r(n._rect.w,n.padding)});n.text=o.join("\n")}}))}))},t.calculateRowHeight=function(e,t,n){if(t.length!==n.length)throw"the cells count must be equal to the count of the columns";for(var o=0,a=0;a<t.length;a++)if(!(0,i.isDefined)(t[a].rowSpan)){var s=t[a].pdfCell.text,u=t[a].pdfCell.padding,d=t[a].pdfCell.font,c=t[a].pdfCell.wordWrapEnabled,h=r(n[a],u);if((0,i.isDefined)(s)){var p=(""!==s?l(e,s,d,{wordWrapEnabled:c,targetRectWidth:h}):0)+u.top+u.bottom;o<p&&(o=p)}}return o},t.calculateTargetRectWidth=r,t.calculateTextHeight=l,t.getPageHeight=function(e){return e.internal.pageSize.getHeight()},t.getPageWidth=o,t.getTextLines=a,t.toPdfUnit=function(e,t){var n=1/e.internal.scaleFactor;return t*n};var i=n(35922);function o(e){return e.internal.pageSize.getWidth()}function a(e,t,n,i){var o=i.wordWrapEnabled,a=i.targetRectWidth;if(o){var r=e.getFont(null==n?void 0:n.name,null==n?void 0:n.style);return e.splitTextToSize(t,a,{fontSize:(null==n?void 0:n.size)||e.getFontSize(),fontName:r.fontName,fontStyle:r.fontStyle})}var l=t.split("\n").filter((function(e){return""!==e})).join(" ");if(s(e,l,n).w<=a)return[l];for(var u=s(e,l+"...",n).w;l.length>0&&u>a;){var d=0;u>=2*a&&(d=l.length/2),d<1&&(d=1),u=s(e,(l=l.substring(0,l.length-d))+"...",n).w}return[l+"..."]}function r(e,t){var n=e-(t.left+t.right);return n>=0?n:0}function s(e,t,n){return e.getTextDimensions(t,{font:e.getFont(null==n?void 0:n.name,null==n?void 0:n.style),fontSize:(null==n?void 0:n.size)||e.getFontSize()})}function l(e,t,n,i){var o=i.wordWrapEnabled,r=i.targetRectWidth;return s(e,t,n).h*a(e,t,n,{wordWrapEnabled:o,targetRectWidth:r}).length*e.getLineHeightFactor()}},65322:function(e,t,n){t.applyBordersConfig=function(e){for(var t=0;t<e.length;t++)for(var n=e[t].cells,o=0;o<n.length;o++){var a=n[o].pdfCell,r=o>=1?n[o-1].pdfCell:null,s=t>=1?e[t-1].cells[o].pdfCell:null;!1!==a.drawLeftBorder||(0,i.isDefined)(n[o].colSpan)?(0,i.isDefined)(a.drawLeftBorder)||(0,i.isDefined)(r)&&!1===r.drawRightBorder&&(a.drawLeftBorder=!1):(0,i.isDefined)(r)&&(r.drawRightBorder=!1),!1===a.drawTopBorder?(0,i.isDefined)(s)&&(s.drawBottomBorder=!1):(0,i.isDefined)(a.drawTopBorder)||(0,i.isDefined)(s)&&!1===s.drawBottomBorder&&(a.drawTopBorder=!1)}},t.applyColSpans=function(e){for(var t=0;t<e.length;t++)for(var n=e[t],o=0;o<n.cells.length;o++){var a=n.cells[o];if((0,i.isDefined)(a.colSpan)&&!(0,i.isDefined)(a.pdfCell.isMerged))for(var r=1;r<=a.colSpan;r++){var s=e[t].cells[o+r];a.pdfCell._rect.w+=s.pdfCell._rect.w,s.pdfCell._rect.w=0,s.pdfCell.isMerged=!0}}},t.applyRowSpans=function(e){for(var t=0;t<e.length;t++)for(var n=e[t],o=0;o<n.cells.length;o++){var a=n.cells[o];if((0,i.isDefined)(a.rowSpan)&&!(0,i.isDefined)(a.pdfCell.isMerged))for(var r=1;r<=a.rowSpan;r++){var s=e[t+r].cells[o];a.pdfCell._rect.h+=s.pdfCell._rect.h,s.pdfCell._rect.h=0,s.pdfCell.isMerged=!0}}},t.calculateCoordinates=function(e,t,n){var i,o=null==n?void 0:n.topLeft,a=null==n?void 0:n.margin,r=(null!==(i=null==o?void 0:o.y)&&void 0!==i?i:0)+a.top;t.forEach((function(e){var t,i=(null!==(t=null==o?void 0:o.x)&&void 0!==t?t:0)+a.left,s=e.indentLevel*n.indent;e.cells.forEach((function(e){e.pdfCell._rect.x=i+s,e.pdfCell._rect.y=r,i+=e.pdfCell._rect.w})),r+=e.height}))},t.calculateHeights=function(e,t,n){t.forEach((function(t){var a,r=t.cells.map((function(e){return e.pdfCell}));if(n.onRowExporting){var s={rowCells:r};n.onRowExporting(s),(0,i.isDefined)(s.rowHeight)&&(a=s.rowHeight)}t.height=(0,i.isDefined)(a)?a:(0,o.calculateRowHeight)(e,t.cells,r.map((function(e){return e._rect.w}))),r.forEach((function(e){e._rect.h=t.height}))}))},t.calculateTableSize=function(e,t,n){var o,a,r,s,l,u,d,c,h,p;t.forEach((function(e){(!(0,i.isDefined)(d)||d>e._rect.x)&&(d=e._rect.x),(!(0,i.isDefined)(c)||c>e._rect.y)&&(c=e._rect.y),(!(0,i.isDefined)(h)||h<e._rect.x+e._rect.w)&&(h=e._rect.x+e._rect.w),(!(0,i.isDefined)(p)||p<e._rect.y+e._rect.h)&&(p=e._rect.y+e._rect.h)}));var f=null!==(o=null!==(a=d)&&void 0!==a?a:null==n||null===(r=n.topLeft)||void 0===r?void 0:r.x)&&void 0!==o?o:0,g=null!==(s=null!==(l=c)&&void 0!==l?l:null==n||null===(u=n.topLeft)||void 0===u?void 0:u.y)&&void 0!==s?s:0,m=(0,i.isDefined)(h)?h-f:0,_=(0,i.isDefined)(p)?p-g:0;return{x:f,y:g,w:m,h:_}},t.initializeCellsWidth=function(e,t,n,r){var s=function(e,t,n,r,s){var l=t.getColumnsWidths().map((function(t){return(0,o.toPdfUnit)(e,null!=t?t:150)})),u=l.filter((function(e,t){return!(0,i.isDefined)(s[t])})).reduce(a,0),d=s.filter((function(e){return(0,i.isNumeric)(e)})).reduce(a,0),c=function(e,t,n){return(0,o.getPageWidth)(e)-t-n.left-n.right}(e,n,r),h=d<c?(c-d)/u:1;return l.map((function(e,t){var n;return null!==(n=s[t])&&void 0!==n?n:e*h}))}(e,t,r.topLeft.x,r.margin,r.columnWidths);n.forEach((function(e){e.cells.forEach((function(e,t){e.gridCell;e.pdfCell._rect.w=s[t]}))}))},t.resizeFirstColumnByIndentLevel=function(e,t){e.forEach((function(e){e.cells[0].pdfCell._rect.w-=e.indentLevel*t.indent}))};var i=n(35922),o=n(79262),a=function(e,t){return e+t}},27504:function(e,t,n){t.generateRowsInfo=function(e,t,n,i){for(var o=[],a=t.getRowsCount(),r=!!n.option("wordWrapEnabled"),s=!!n.option("rtlEnabled"),l=t.getColumns(),u=t.getStyles(),c=0;c<a;c++){var h=t.getCellData(c,0,!0).cellSourceData.rowType,p="header"!==h?t.getGroupLevel(c):0,f=o[c-1];"groupFooter"===h&&"groupFooter"===(null==f?void 0:f.rowType)&&(p=f.indentLevel-1),o.push({rowType:h,indentLevel:p,cells:d({doc:e,dataProvider:t,rowIndex:c,wordWrapEnabled:r,columns:l,styles:u,rowType:h,backgroundColor:"header"===h?i:void 0,rtlEnabled:s}),rowIndex:c})}return o},t.getBaseTableStyle=function(){return u.base};var i=n(35922),o=s(n(91500)),a=s(n(18016)),r=n(79262);function s(e){return e&&e.__esModule?e:{default:e}}function l(){return(l=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(e[i]=n[i])}return e}).apply(this,arguments)}var u={base:{font:{size:10},borderWidth:.5,borderColor:"#979797"},header:{textColor:"#979797"},group:{},data:{},groupFooter:{},totalFooter:{}};function d(e){for(var t=e.doc,n=e.dataProvider,o=e.rowIndex,a=e.wordWrapEnabled,s=e.columns,u=e.styles,d=e.rowType,p=e.backgroundColor,f=e.rtlEnabled,g=[],m=0;m<s.length;m++){var _,v=n.getCellData(o,m,!0),y=u[n.getStyleId(o,m)],b=c(s[m],d,y),x=f?"right":"left",w=(0,r.toPdfUnit)(t,5),C={text:h(v.value,y.format),verticalAlign:"middle",horizontalAlign:null!==(_=b.alignment)&&void 0!==_?_:x,wordWrapEnabled:a,backgroundColor:p,padding:{top:w,right:w,bottom:w,left:w},_rect:{},_internalTextOptions:{}};f&&(C._internalTextOptions.isInputVisual=!1,C._internalTextOptions.isOutputVisual=!0,C._internalTextOptions.isInputRtl=!0,C._internalTextOptions.isOutputRtl=!1);var S={gridCell:v.cellSourceData,pdfCell:l({},C,b)};if("header"===d){var k=n.getCellMerging(o,m);k&&k.rowspan>0&&(S.rowSpan=k.rowspan),k&&k.colspan>0&&(S.colSpan=k.colspan)}else if("group"===d){var D=f?"drawRightBorder":"drawLeftBorder",I=f?"drawLeftBorder":"drawRightBorder";if(S.pdfCell[D]=0===m,S.pdfCell[I]=m===s.length-1,m>0){var T=g.slice(1).reduce((function(e,t){return e&&!(0,i.isDefined)(t.pdfCell.text)}),!0);if(!(0,i.isDefined)(S.pdfCell.text)&&T){g[0].pdfCell[I]=!0;for(var E=0;E<g.length;E++)g[E].colSpan=g.length;S.colSpan=g.length}}}g.push(S)}return g}function c(e,t,n){var i=l({},u.base,u[t]),o="header"===t?e.alignment:n.alignment;return o&&(i.alignment=o),n.bold&&"header"!==t&&(i.font=l({},i.font,{style:"bold"})),i}function h(e,t){if((0,i.isDefined)(t)){if((0,i.isDate)(e))return o.default.format(e,t);if((0,i.isNumeric)(e))return a.default.format(e,t)}return null==e?void 0:e.toString()}},22775:function(e,t,n){t.splitByPages=function(e,t,n,i,s){if(0===t.length)return[[]];var c={x:(0,o.getPageWidth)(e)-n.margin.right,y:(0,o.getPageHeight)(e)-n.margin.bottom},h=t.filter((function(e){return"header"===e.rowType})),p=h.reduce((function(e,t){return e+t.height}),0),f=d(u(t),n.margin.top,"y","h",(function(e,t){var i=e>0&&n.repeatHeaders?p:0;return(0,a.roundToThreeDecimals)(t+i)<=(0,a.roundToThreeDecimals)(c.y)}),(function(e,t,n,i){var o={sourceRect:e,topRect:{x:e.x,y:e.y,w:e.w,h:t-e.y},bottomRect:{x:e.x,y:t,w:e.w,h:e.h-(t-e.y)}};s(o),n.push(o.topRect),i.push(o.bottomRect)}));if(n.repeatHeaders)for(var g=1;g<f.length;g++){f[g].forEach((function(e){return e.y+=p}));var m=u(h);m.forEach((function(e){e.y-=n.topLeft.y})),f[g]=[].concat(r(m),r(f[g]))}var _=0;for(;_<f.length;){var v=d(f[_],n.margin.left,"x","w",(function(e,t){return(0,a.roundToThreeDecimals)(t)<=(0,a.roundToThreeDecimals)(c.x)}),(function(e,t,n,o){var a={sourceRect:e,leftRect:{x:e.x,y:e.y,w:t-e.x,h:e.h},rightRect:{x:t,y:e.y,w:e.w-(t-e.x),h:e.h}};i(a),n.push(a.leftRect),o.push(a.rightRect)}));v.length>1?(f.splice.apply(f,[_,1].concat(r(v))),_+=v.length):_+=1}return f.map((function(e){return e.map((function(e){return l({},e.sourceCellInfo,{_rect:e})}))}))};var i=n(35922),o=n(79262),a=n(66867);function r(e){return function(e){if(Array.isArray(e))return s(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return s(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return s(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function s(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}function l(){return(l=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(e[i]=n[i])}return e}).apply(this,arguments)}function u(e){return[].concat.apply([],e.map((function(e){return e.cells.filter((function(e){return!(0,i.isDefined)(e.pdfCell.isMerged)})).map((function(e){return l({},e.pdfCell._rect,{sourceCellInfo:l({},e.pdfCell,{gridCell:e.gridCell})})}))})))}function d(e,t,n,o,a,s){for(var l=[],u=r(e),d=function(){var e=0,r=u.filter((function(t){var i=t[n]+t[o];return!!a(l.length,i)&&(e<=i&&(e=i),!0)}));if(u.filter((function(t){var i=t[n],a=t[n]+t[o];if(i<e&&e<a)return!0})).forEach((function(t){s(t,e,r,u);var n=u.indexOf(t);-1!==n&&u.splice(n,1)})),r.forEach((function(e){var t=u.indexOf(e);-1!==t&&u.splice(t,1)})),u.forEach((function(o){o[n]=(0,i.isDefined)(e)?o[n]-e+t:o[n]})),!(r.length>0))return l.push(u),"break";l.push(r)};u.length>0;){if("break"===d())break}return l}},654:function(e,t,n){t.exportDataGrid=function(e){return r.Export.export(function(e){if(!(0,o.isDefined)(e)||!(0,o.isObject)(e))throw Error('The "exportDataGrid" method requires a configuration object.');if(!(0,o.isDefined)(e.component)||!(0,o.isObject)(e.component)||"dxDataGrid"!==e.component.NAME)throw Error('The "component" field must contain a DataGrid instance.');if(!(0,o.isDefined)(e.jsPDFDocument)||!(0,o.isObject)(e.jsPDFDocument))throw Error('The "jsPDFDocument" field must contain a jsPDF instance.');(0,o.isDefined)(e.autoTableOptions)&&a.default.log("W0001","Export","autoTableOptions","22.1","You can migrate from exporting to PDF with the AutoTable plugin to a new export system. See the following topic for more information: ".concat("https://supportcenter.devexpress.com/ticket/details/t1077554"));return r.Export.getFullOptions(e)}(e))};var i,o=n(35922),a=(i=n(17381))&&i.__esModule?i:{default:i},r=n(17195)},29982:function(e,t){t.exportGantt=function(e){var t=e.component;return null==t?void 0:t.exportToPdf(e)}},30855:function(e,t,n){t.getData=function(e,t){return a.imageCreator.getImageData(e,(0,s.extend)({},t,{format:"JPEG"})).then((function(e){var n=function(e,t,n){var o=2*(t.margin||0),r=(0,a.calcScaledInfo)(t.width,t.height),s=r.width,l=r.height;l+=o;var d=(.75*(s+=o)).toFixed(2),c=(.75*l).toFixed(2),h="%PDF-1.3\r\n2 0 obj\r\n<</ProcSet[/PDF/ImageB/ImageC/ImageI]/XObject<</I0 5 0 R>>>>\r\nendobj\r\n4 0 obj\r\n<</Type/Pages/Kids[1 0 R]/Count 1>>\r\nendobj\r\n7 0 obj\r\n<</OpenAction[1 0 R /FitH null]/Type/Catalog/Pages 4 0 R/PageLayout/OneColumn>>\r\nendobj\r\n1 0 obj\r\n<</Type/Page/Resources 2 0 R/MediaBox[0 0 _width_ _height_]/Contents 3 0 R/Parent 4 0 R>>\r\nendobj\r\n".replace("_width_",d).replace("_height_",c),p="3 0 obj\r\n<</Length 52>>stream\r\n0.20 w\n0 G\nq _width_ 0 0 _height_ 0.00 0.00 cm /I0 Do Q\r\nendstream\r\nendobj\r\n".replace("_width_",d).replace("_height_",c),f="6 0 obj\r\n<</CreationDate _date_/Producer(DevExtreme _version_)>>\r\nendobj\r\n".replace("_date_",n).replace("_version_",i.version),g="5 0 obj\r\n<</Type/XObject/Subtype/Image/Width _width_/Height _height_/ColorSpace/DeviceRGB/BitsPerComponent 8/Filter/DCTDecode/Length _length_>>stream\r\n".replace("_width_",s).replace("_height_",l).replace("_length_",e.length)+e+"\r\nendstream\r\nendobj\r\n",m=(y=h.length,b=p.length,x=f.length,"xref\r\n0 8\r\n0000000000 65535 f\r\n0000000241 00000 n\r\n0000000010 00000 n\r\n_main_ 00000 n\r\n0000000089 00000 n\r\n_image_ 00000 n\r\n_info_ 00000 n\r\n0000000143 00000 n\r\n".replace("_main_",u(y+"",10)).replace("_info_",u(y+b+"",10)).replace("_image_",u(y+b+x+"",10))),_=h+p+f+g,v="trailer\r\n<<\r\n/Size 8\r\n/Root 7 0 R\r\n/Info 6 0 R\r\n>>\r\nstartxref\r\n_length_\r\n%%EOF".replace("_length_",_.length);var y,b,x;return _+m+v}(e,t,new Date);return(0,r.isFunction)(l.Blob)?function(e){for(var t=0,n=new Uint8Array(e.length);t<e.length;t++)n[t]=e.charCodeAt(t);return new l.Blob([n.buffer],{type:"application/pdf"})}(n):function(e){return l.btoa(e)}(n)}))};var i=n(36739),o=n(58201),a=n(12173),r=n(35922),s=n(13306),l=(0,o.getWindow)(),u=function e(t,n){return t.length<n?e("0"+t,n):t}},37596:function(e,t,n){t.getData=function(e,t){return h.getData(e,t)},t.svgCreator=void 0;var i=d(n(68374)),o=d(n(37208)),a=n(58201),r=n(35922),s=n(95479),l=n(19155),u=n(62754);function d(e){return e&&e.__esModule?e:{default:e}}var c=(0,a.getWindow)(),h={_markup:"",_imageArray:{},_imageDeferreds:[],_getBinaryFile:function(e,t){o.default.sendRequest({url:e,method:"GET",responseType:"arraybuffer"}).done(t).fail((function(){t(!1)}))},_loadImages:function(){var e=this;(0,s.each)(e._imageArray,(function(t){var n=new u.Deferred;e._imageDeferreds.push(n),e._getBinaryFile(t,(function(i){if(!i)return delete e._imageArray[t],void n.resolve();var o,a="",r=new Uint8Array(i),s=r.byteLength;for(o=0;o<s;o++)a+=String.fromCharCode(r[o]);e._imageArray[t]="data:image/png;base64,"+c.btoa(a),n.resolve()}))}))},_parseImages:function(e){var t,n=this;"image"===e.tagName&&(t=(0,i.default)(e).attr("href")||(0,i.default)(e).attr("xlink:href"),n._imageArray[t]||(n._imageArray[t]="")),(0,s.each)(e.childNodes,(function(e,t){n._parseImages(t)}))},_prepareImages:function(e){return this._parseImages(e),this._loadImages(),u.when.apply(i.default,this._imageDeferreds)},getData:function(e,t){var n,o=this,a=(0,l.getSvgElement)(e),u=(0,i.default)(a);return u.find("[".concat(l.HIDDEN_FOR_EXPORT,"]")).remove(),n='<?xml version="1.0" encoding="UTF-8" standalone="yes" ?>'+(0,l.getSvgMarkup)(u.get(0),t.backgroundColor),o._prepareImages(a).then((function(){return(0,s.each)(o._imageArray,(function(e,t){var i="href=['|\"]".concat(e,"['|\"]");n=n.replace(new RegExp(i,"gi"),'href="'.concat(t,'"'))})),(0,r.isFunction)(c.Blob)?o._getBlob(n):o._getBase64(n)}))},_getBlob:function(e){return new c.Blob([e],{type:"image/svg+xml"})},_getBase64:function(e){return c.btoa(e)}};t.svgCreator=h},98831:function(e,t,n){t.default=void 0;var i,o=n(20576),a=n(35922),r=n(47617);function s(e,t){return(s=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e})(e,t)}var l=function(e){var t,n;function i(t){var n;return t=(0,o.ensureDefined)(t,{}),(n=e.call(this,t)||this)._hasSubDirsGetter=(0,r.compileGetter)(t.hasSubDirectoriesExpr||"hasSubDirectories"),n._getItemsFunction=n._ensureFunction(t.getItems,(function(){return[]})),n._renameItemFunction=n._ensureFunction(t.renameItem),n._createDirectoryFunction=n._ensureFunction(t.createDirectory),n._deleteItemFunction=n._ensureFunction(t.deleteItem),n._moveItemFunction=n._ensureFunction(t.moveItem),n._copyItemFunction=n._ensureFunction(t.copyItem),n._uploadFileChunkFunction=n._ensureFunction(t.uploadFileChunk),n._abortFileUploadFunction=n._ensureFunction(t.abortFileUpload),n._downloadItemsFunction=n._ensureFunction(t.downloadItems),n._getItemsContentFunction=n._ensureFunction(t.getItemsContent),n}n=e,(t=i).prototype=Object.create(n.prototype),t.prototype.constructor=t,s(t,n);var l=i.prototype;return l.getItems=function(e){var t=this,n=e.getFullPathInfo();return this._executeActionAsDeferred((function(){return t._getItemsFunction(e)}),!0).then((function(e){return t._convertDataObjectsToFileItems(e,n)}))},l.renameItem=function(e,t){var n=this;return this._executeActionAsDeferred((function(){return n._renameItemFunction(e,t)}))},l.createDirectory=function(e,t){var n=this;return this._executeActionAsDeferred((function(){return n._createDirectoryFunction(e,t)}))},l.deleteItems=function(e){var t=this;return e.map((function(e){return t._executeActionAsDeferred((function(){return t._deleteItemFunction(e)}))}))},l.moveItems=function(e,t){var n=this;return e.map((function(e){return n._executeActionAsDeferred((function(){return n._moveItemFunction(e,t)}))}))},l.copyItems=function(e,t){var n=this;return e.map((function(e){return n._executeActionAsDeferred((function(){return n._copyItemFunction(e,t)}))}))},l.uploadFileChunk=function(e,t,n){var i=this;return this._executeActionAsDeferred((function(){return i._uploadFileChunkFunction(e,t,n)}))},l.abortFileUpload=function(e,t,n){var i=this;return this._executeActionAsDeferred((function(){return i._abortFileUploadFunction(e,t,n)}))},l.downloadItems=function(e){var t=this;return this._executeActionAsDeferred((function(){return t._downloadItemsFunction(e)}))},l.getItemsContent=function(e){var t=this;return this._executeActionAsDeferred((function(){return t._getItemsContentFunction(e)}))},l._hasSubDirs=function(e){var t=this._hasSubDirsGetter(e);return"boolean"!=typeof t||t},l._getKeyExpr=function(e){return e.keyExpr||"key"},l._ensureFunction=function(e,t){return t=t||o.noop,(0,a.isFunction)(e)?e:t},i}(((i=n(19073))&&i.__esModule?i:{default:i}).default);t.default=l,e.exports=t.default,e.exports.default=t.default},49816:function(e,t){t.default=void 0;var n=function(e,t,n){this.errorCode=e,this.fileSystemItem=t,this.errorText=n};t.default=n,e.exports=t.default,e.exports.default=t.default},41011:function(e,t){t.default=void 0;var n={NoAccess:0,FileExists:1,FileNotFound:2,DirectoryExists:3,DirectoryNotFound:4,WrongFileExtension:5,MaxFileSizeExceeded:6,InvalidSymbols:7,Other:32767};t.default=n,e.exports=t.default,e.exports.default=t.default},45765:function(e,t,n){t.default=void 0;var i=n(35922),o=n(73173);function a(e){return function(e){if(Array.isArray(e))return r(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return r(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return r(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function r(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}var s=function(){function e(){var e=(0,i.isString)(arguments[0])?this._publicCtor:this._internalCtor;e.apply(this,arguments)}var t=e.prototype;return t._internalCtor=function(e,t,n,i){this.name=t||"",this.pathInfo=e&&a(e)||[],this.parentPath=this._getPathByPathInfo(this.pathInfo),this.relativeName=(0,o.pathCombine)(this.parentPath,t),this.key=i||this._getPathByPathInfo(this.getFullPathInfo(),!0),this.path=(0,o.pathCombine)(this.parentPath,t),this.pathKeys=this.pathInfo.map((function(e){return e.key})),this.isRoot()||this.pathKeys.push(this.key),this._initialize(n)},t._publicCtor=function(e,t,n){this.path=e||"",this.pathKeys=n||[];for(var i=[],a=(0,o.getPathParts)(e,!0),r=0;r<a.length-1;r++){var s=a[r],l={key:this.pathKeys[r]||s,name:(0,o.getName)(s)};i.push(l)}this.pathInfo=i,this.relativeName=e,this.name=(0,o.getName)(e),this.key=this.pathKeys.length?this.pathKeys[this.pathKeys.length-1]:e,this.parentPath=a.length>1?a[a.length-2]:"",this._initialize(t)},t._initialize=function(e){this.isDirectory=!!e,this.size=0,this.dateModified=new Date,this.thumbnail="",this.tooltipText=""},t.getFullPathInfo=function(){var e=a(this.pathInfo);return this.isRoot()||e.push({key:this.key,name:this.name}),e},t.isRoot=function(){return""===this.path},t.getFileExtension=function(){return this.isDirectory?"":(0,o.getFileExtension)(this.name)},t.equals=function(e){return e&&this.key===e.key},t.createClone=function(){var t=new e(this.pathInfo,this.name,this.isDirectory,this.key);return t.key=this.key,t.size=this.size,t.dateModified=this.dateModified,t.thumbnail=this.thumbnail,t.tooltipText=this.tooltipText,t.hasSubDirectories=this.hasSubDirectories,t.dataItem=this.dataItem,t},t._getPathByPathInfo=function(e,t){return e.map((function(e){return t?(0,o.getEscapedFileName)(e.name):e.name})).join(o.PATH_SEPARATOR)},e}();t.default=s,e.exports=t.default,e.exports.default=t.default},4323:function(e,t,n){t.default=void 0;var i=n(20576),o=n(47617),a=_(n(73176)),r=n(35922),s=n(18438),l=n(62754),u=n(58201),d=n(48351),c=_(n(96688)),h=_(n(97405)),p=_(n(19073)),f=_(n(49816)),g=_(n(41011)),m=n(73173);function _(e){return e&&e.__esModule?e:{default:e}}function v(e,t){return(v=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e})(e,t)}var y=(0,u.getWindow)();var b=function(e){var t,n;function u(t){var n;t=(0,i.ensureDefined)(t,{}),n=e.call(this,t)||this;var a=t.data;if(a&&!Array.isArray(a))throw s.errors.Error("E4006");var r=t.itemsExpr||"items";n._subFileItemsGetter=(0,o.compileGetter)(r),n._subFileItemsSetter=n._getSetter(r);var l=t.contentExpr||"content";n._contentGetter=(0,o.compileGetter)(l),n._contentSetter=n._getSetter(l);var u=n._getNameExpr(t);n._nameSetter=n._getSetter(u);var d=n._getIsDirExpr(t);n._getIsDirSetter=n._getSetter(d);var c=n._getKeyExpr(t);n._keySetter=n._getSetter(c);var h=n._getSizeExpr(t);n._sizeSetter=n._getSetter(h);var p=n._getDateModifiedExpr(t);return n._dateModifiedSetter=n._getSetter(p),n._data=a||[],n}n=e,(t=u).prototype=Object.create(n.prototype),t.prototype.constructor=t,v(t,n);var p=u.prototype;return p.getItems=function(e){var t=this;return this._executeActionAsDeferred((function(){return t._getItems(e)}),!0)},p.renameItem=function(e,t){var n=this;return this._executeActionAsDeferred((function(){return n._renameItemCore(e,t)}))},p._renameItemCore=function(e,t){if(e){var n=this._findDataObject(e);this._nameSetter(n,t),e.name=t,e.key=this._ensureDataObjectKey(n)}},p.createDirectory=function(e,t){var n=this;return this._executeActionAsDeferred((function(){n._validateDirectoryExists(e),n._createDataObject(e,t,!0)}))},p.deleteItems=function(e){var t=this;return e.map((function(e){return t._executeActionAsDeferred((function(){return t._deleteItem(e)}))}))},p.moveItems=function(e,t){var n=this,i=this._findDataObject(t),o=this._getDirectoryDataItems(i);return e.map((function(e){return n._executeActionAsDeferred((function(){n._checkAbilityToMoveOrCopyItem(e,t);var i=n._findDataObject(e);n._deleteItem(e),o.push(i)}))}))},p.copyItems=function(e,t){var n=this,i=this._findDataObject(t),o=this._getDirectoryDataItems(i);return e.map((function(e){return n._executeActionAsDeferred((function(){n._checkAbilityToMoveOrCopyItem(e,t);var i=n._findDataObject(e),a=n._createCopy(i);o.push(a)}))}))},p.uploadFileChunk=function(e,t,n){var i=this;if(t.chunkIndex>0)return t.customData.deferred;this._validateDirectoryExists(n);var o=t.customData.deferred=new l.Deferred,a=this._createFileReader();return a.readAsDataURL(e),a.onload=function(){var t=a.result.split(",")[1],r=i._createDataObject(n,e.name,!1);i._sizeSetter(r,e.size),i._dateModifiedSetter(r,e.lastModifiedDate),i._contentSetter(r,t),o.resolve()},a.onerror=function(e){return o.reject(e)},o},p.downloadItems=function(e){1===e.length?this._downloadSingleFile(e[0]):this._downloadMultipleFiles(e)},p._downloadSingleFile=function(e){for(var t=this._getFileContent(e),n=y.atob(t),i=new ArrayBuffer(n.length),o=new Uint8Array(i),a=0;a<n.length;a++)o[a]=n.charCodeAt(a);var r=new y.Blob([i],{type:"application/octet-stream"});d.fileSaver.saveAs(e.name,null,r)},p._downloadMultipleFiles=function(e){var t=this,n=new(function(){if(!h.default)throw c.default.Error("E1041","JSZip");return h.default}());e.forEach((function(e){return n.file(e.name,t._getFileContent(e),{base64:!0})}));var i={type:"blob",compression:"DEFLATE",mimeType:"application/zip"},o=new l.Deferred;n.generateAsync?n.generateAsync(i).then(o.resolve):o.resolve(n.generate(i)),o.done((function(e){return d.fileSaver.saveAs("files.zip",null,e)}))},p._getFileContent=function(e){var t=this._findDataObject(e);return this._contentGetter(t)||""},p._validateDirectoryExists=function(e){if(!this._isFileItemExists(e)||this._isDirGetter(e.fileItem))throw new f.default(g.default.DirectoryNotFound,e)},p._checkAbilityToMoveOrCopyItem=function(e,t){var n=this,i=this._findDataObject(e),o=this._getKeyFromDataObject(i,e.parentPath),a=t.getFullPathInfo(),r="";a.forEach((function(t){if(r=(0,m.pathCombine)(r,t.name),n._getDataObjectKey(t.key,r)===o)throw new f.default(g.default.Other,e)}))},p._createDataObject=function(e,t,n){var i={};this._nameSetter(i,t),this._getIsDirSetter(i,n),this._keySetter(i,String(new a.default));var o=this._findDataObject(e);return this._getDirectoryDataItems(o).push(i),i},p._createCopy=function(e){var t=this,n={};this._nameSetter(n,this._nameGetter(e)),this._getIsDirSetter(n,this._isDirGetter(e));var i=this._subFileItemsGetter(e);if(Array.isArray(i)){var o=[];i.forEach((function(e){var n=t._createCopy(e);o.push(n)})),this._subFileItemsSetter(n,o)}return n},p._deleteItem=function(e){var t=this._findDataObject(e),n=this._findFileItemObj(e.pathInfo),i=this._getDirectoryDataItems(n),o=i.indexOf(t);i.splice(o,1)},p._getDirectoryDataItems=function(e){if(!e)return this._data;var t=this._subFileItemsGetter(e);return Array.isArray(t)||(t=[],this._subFileItemsSetter(e,t)),t},p._getItems=function(e){this._validateDirectoryExists(e);var t=e.getFullPathInfo(),n=t&&t.length>0?t[t.length-1].key:null,i=this._data;if(n){var o=this._findFileItemObj(t);i=o&&this._subFileItemsGetter(o)||[]}return this._ensureKeysForDuplicateNameItems(i),this._convertDataObjectsToFileItems(i,t)},p._ensureKeysForDuplicateNameItems=function(e){var t=this,n={};e.forEach((function(e){var i=t._nameGetter(e);n[i]?t._ensureDataObjectKey(e):n[i]=!0}))},p._findDataObject=function(e){if(e.isRoot())return null;var t=this._findFileItemObj(e.getFullPathInfo());if(!t){var n=e.isDirectory?g.default.DirectoryNotFound:g.default.FileNotFound;throw new f.default(n,e)}return t},p._findFileItemObj=function(e){var t=this;Array.isArray(e)||(e=[]);for(var n="",i=null,o=this._data,a=function(a){(i=o.find((function(i){var o=t._isDirGetter(i)||a===e.length-1;return t._getKeyFromDataObject(i,n)===e[a].key&&t._nameGetter(i)===e[a].name&&o})))&&(n=(0,m.pathCombine)(n,t._nameGetter(i)),o=t._subFileItemsGetter(i))},r=0;r<e.length&&(0===r||i);r++)a(r);return i},p._getKeyFromDataObject=function(e,t){var n=this._keyGetter(e),i=(0,m.pathCombine)(t,this._nameGetter(e));return this._getDataObjectKey(n,i)},p._getDataObjectKey=function(e,t){return e||t},p._ensureDataObjectKey=function(e){var t=this._keyGetter(e);return t||(t=String(new a.default),this._keySetter(e,t)),t},p._hasSubDirs=function(e){var t=(0,i.ensureDefined)(this._subFileItemsGetter(e),[]);if(!Array.isArray(t))return!0;for(var n=0;n<t.length;n++)if(!0===this._isDirGetter(t[n]))return!0;return!1},p._getSetter=function(e){return(0,r.isFunction)(e)?e:(0,o.compileSetter)(e)},p._isFileItemExists=function(e){return e.isDirectory&&e.isRoot()||!!this._findFileItemObj(e.getFullPathInfo())},p._createFileReader=function(){return new y.FileReader},u}(p.default);t.default=b,e.exports=t.default,e.exports.default=t.default},19073:function(e,t,n){t.default=void 0;var i=n(47617),o=n(20576),a=d(n(69434)),r=n(95479),s=n(35922),l=n(62754),u=d(n(45765));function d(e){return e&&e.__esModule?e:{default:e}}var c=function(){function e(e){e=(0,o.ensureDefined)(e,{}),this._keyGetter=(0,i.compileGetter)(this._getKeyExpr(e)),this._nameGetter=(0,i.compileGetter)(this._getNameExpr(e)),this._isDirGetter=(0,i.compileGetter)(this._getIsDirExpr(e)),this._sizeGetter=(0,i.compileGetter)(this._getSizeExpr(e)),this._dateModifiedGetter=(0,i.compileGetter)(this._getDateModifiedExpr(e)),this._thumbnailGetter=(0,i.compileGetter)(e.thumbnailExpr||"thumbnail")}var t=e.prototype;return t.getItems=function(e){return[]},t.renameItem=function(e,t){},t.createDirectory=function(e,t){},t.deleteItems=function(e){},t.moveItems=function(e,t){},t.copyItems=function(e,t){},t.uploadFileChunk=function(e,t,n){},t.abortFileUpload=function(e,t,n){},t.downloadItems=function(e){},t.getItemsContent=function(e){},t.getFileUploadChunkSize=function(){return 2e5},t._convertDataObjectsToFileItems=function(e,t){var n=this,i=[];return(0,r.each)(e,(function(e,o){var a=n._createFileItem(o,t);i.push(a)})),i},t._createFileItem=function(e,t){var n=this._keyGetter(e),i=new u.default(t,this._nameGetter(e),!!this._isDirGetter(e),n);return i.size=this._sizeGetter(e),void 0===i.size&&(i.size=0),i.dateModified=a.default.deserializeDate(this._dateModifiedGetter(e)),void 0===i.dateModified&&(i.dateModified=new Date),i.isDirectory&&(i.hasSubDirectories=this._hasSubDirs(e)),n||(i.key=i.relativeName),i.thumbnail=this._thumbnailGetter(e)||"",i.dataItem=e,i},t._hasSubDirs=function(e){return!0},t._getKeyExpr=function(e){return e.keyExpr||this._defaultKeyExpr},t._defaultKeyExpr=function(e){if(2!==arguments.length)return Object.prototype.hasOwnProperty.call(e,"__KEY__")?e.__KEY__:null;e.__KEY__=arguments[1]},t._getNameExpr=function(e){return e.nameExpr||"name"},t._getIsDirExpr=function(e){return e.isDirectoryExpr||"isDirectory"},t._getSizeExpr=function(e){return e.sizeExpr||"size"},t._getDateModifiedExpr=function(e){return e.dateModifiedExpr||"dateModified"},t._executeActionAsDeferred=function(e,t){var n=new l.Deferred;try{var i=e();(0,s.isPromise)(i)?(0,l.fromPromise)(i).done((function(e){return n.resolve(t&&e||void 0)})).fail((function(e){return n.reject(e)})):n.resolve(t&&i||void 0)}catch(e){return n.reject(e)}return n.promise()},e}();t.default=c,e.exports=t.default,e.exports.default=t.default},41332:function(e,t,n){t.default=void 0;var i=f(n(68374)),o=f(n(37208)),a=n(20576),r=f(n(73176)),s=n(58201),l=n(95479),u=n(62754),d=f(n(55994)),c=f(n(19073)),h=n(47617),p=n(35922);function f(e){return e&&e.__esModule?e:{default:e}}function g(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function m(e,t){return(m=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e})(e,t)}var _=(0,s.getWindow)(),v="GetDirContents",y="CreateDir",b="Rename",x="Move",w="Copy",C="Remove",S="UploadChunk",k="AbortUpload",D="Download",I="GET",T="POST",E=function(e){var t,n;function s(t){var n;return t=(0,a.ensureDefined)(t,{}),(n=e.call(this,t)||this)._endpointUrl=t.endpointUrl,n._beforeAjaxSend=t.beforeAjaxSend,n._beforeSubmit=t.beforeSubmit,n._requestHeaders=t.requestHeaders,n._hasSubDirsGetter=(0,h.compileGetter)(t.hasSubDirectoriesExpr||"hasSubDirectories"),n}n=e,(t=s).prototype=Object.create(n.prototype),t.prototype.constructor=t,m(t,n);var c=s.prototype;return c.getItems=function(e){var t=this,n=e.getFullPathInfo();return this._executeRequest(v,{pathInfo:n}).then((function(e){return t._convertDataObjectsToFileItems(e.result,n)}))},c.renameItem=function(e,t){return this._executeRequest(b,{pathInfo:e.getFullPathInfo(),isDirectory:e.isDirectory,name:t})},c.createDirectory=function(e,t){return this._executeRequest(y,{pathInfo:e.getFullPathInfo(),name:t})},c.deleteItems=function(e){var t=this;return e.map((function(e){return t._executeRequest(C,{pathInfo:e.getFullPathInfo(),isDirectory:e.isDirectory})}))},c.moveItems=function(e,t){var n=this;return e.map((function(e){return n._executeRequest(x,{sourcePathInfo:e.getFullPathInfo(),sourceIsDirectory:e.isDirectory,destinationPathInfo:t.getFullPathInfo()})}))},c.copyItems=function(e,t){var n=this;return e.map((function(e){return n._executeRequest(w,{sourcePathInfo:e.getFullPathInfo(),sourceIsDirectory:e.isDirectory,destinationPathInfo:t.getFullPathInfo()})}))},c.uploadFileChunk=function(e,t,n){var i;0===t.chunkIndex&&(t.customData.uploadId=new r.default);var s={destinationPathInfo:n.getFullPathInfo(),chunkMetadata:JSON.stringify({UploadId:t.customData.uploadId,FileName:e.name,Index:t.chunkIndex,TotalCount:t.chunkCount,FileSize:e.size})},l={url:this._endpointUrl,headers:this._requestHeaders||{},method:T,dataType:"json",data:(i={},g(i,"chunk",t.chunkBlob),g(i,"arguments",JSON.stringify(s)),g(i,"command",S),i),upload:{onprogress:a.noop,onloadstart:a.noop,onabort:a.noop},xhrFields:{},cache:!1},d=new u.Deferred;return this._beforeSendInternal(l),o.default.sendRequest(l).done((function(e){!e.success&&d.reject(e)||d.resolve()})).fail(d.reject),d.promise()},c.abortFileUpload=function(e,t,n){return this._executeRequest(k,{uploadId:t.customData.uploadId})},c.downloadItems=function(e){var t=this._getDownloadArgs(e),n=(0,i.default)("<form>").css({display:"none"}).attr({method:T,action:t.url}),o={command:t.command,arguments:t.arguments};this._beforeSubmitInternal(o),this._appendFormDataInputsToForm(o,n),n.appendTo("body"),d.default.trigger(n,"submit"),setTimeout((function(){return n.remove()}))},c.getItemsContent=function(e){var t=this._getDownloadArgs(e),n={url:t.url,headers:this._requestHeaders||{},method:T,responseType:"arraybuffer",data:{command:t.command,arguments:t.arguments},upload:{onprogress:a.noop,onloadstart:a.noop,onabort:a.noop},xhrFields:{},cache:!1};return this._beforeSendInternal(n),o.default.sendRequest(n)},c._getDownloadArgs=function(e){var t={pathInfoList:e.map((function(e){return e.getFullPathInfo()}))},n=JSON.stringify(t);return{url:this._endpointUrl,arguments:n,command:D}},c._getItemsIds=function(e){return e.map((function(e){return e.relativeName}))},c._executeRequest=function(e,t){var n=e===v?I:T,i=new u.Deferred,a={url:this._getEndpointUrl(e,t),headers:this._requestHeaders||{},method:n,dataType:"json",data:{},xhrFields:{},cache:!1};return this._beforeSendInternal(a),o.default.sendRequest(a).then((function(e){!e.success&&i.reject(e)||i.resolve(e)}),(function(e){return i.reject(e)})),i.promise()},c._beforeSubmitInternal=function(e){(0,p.isFunction)(this._beforeSubmit)&&this._beforeSubmit({formData:e})},c._beforeSendInternal=function(e){if((0,p.isFunction)(this._beforeAjaxSend)){var t={headers:e.headers,formData:e.data,xhrFields:e.xhrFields};this._beforeAjaxSend(t),e.headers=t.headers,e.data=t.formData,e.xhrFields=t.xhrFields}(0,p.isEmptyObject)(e.data)?delete e.data:(e.responseType||e.upload)&&(e.data=this._createFormData(e.data))},c._createFormData=function(e){var t=new _.FormData;for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(0,p.isDefined)(e[n])&&t.append(n,e[n]);return t},c._appendFormDataInputsToForm=function(e,t){for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(0,p.isDefined)(e[n])&&(0,i.default)("<input>").attr({type:"hidden",name:n,value:e[n]}).appendTo(t)},c._getEndpointUrl=function(e,t){var n=this._getQueryString({command:e,arguments:JSON.stringify(t)}),i=this._endpointUrl&&this._endpointUrl.indexOf("?")>0?"&":"?";return this._endpointUrl+i+n},c._getQueryString=function(e){for(var t=[],n=Object.keys(e),i=0;i<n.length;i++){var o=n[i],a=e[o];if(void 0!==a)if(null===a&&(a=""),Array.isArray(a))this._processQueryStringArrayParam(o,a,t);else{var r=this._getQueryStringPair(o,a);t.push(r)}}return t.join("&")},c._processQueryStringArrayParam=function(e,t,n){var i=this;(0,l.each)(t,(function(t,o){var a=i._getQueryStringPair(e,o);n.push(a)}))},c._getQueryStringPair=function(e,t){return encodeURIComponent(e)+"="+encodeURIComponent(t)},c._hasSubDirs=function(e){var t=this._hasSubDirsGetter(e);return"boolean"!=typeof t||t},c._getKeyExpr=function(e){return e.keyExpr||"key"},s}(c.default);t.default=E,e.exports=t.default,e.exports.default=t.default},73173:function(e,t,n){t.pathCombine=t.getPathParts=t.getParentPath=t.getName=t.getFileExtension=t.getEscapedFileName=t.PATH_SEPARATOR=void 0;var i=n(95479);t.PATH_SEPARATOR="/";t.getFileExtension=function(e){var t=e.lastIndexOf(".");return-1!==t?e.substr(t):""};t.getName=function(e){var t=e.lastIndexOf("/");return-1!==t?e.substr(t+"/".length):e};t.getParentPath=function(e){var t=e.lastIndexOf("/");return-1!==t?e.substr(0,t):""};t.getPathParts=function(e,t){if(!e||"/"===e)return[];for(var n=[],i="",r=0;r<e.length;r++){var s=e.charAt(r);if("/"===s){var l=e.charAt(r+1);"/"!==l&&(i&&(n.push(i),i=""),s=l),r++}i+=s}if(i&&n.push(i),t)for(var u=0;u<n.length;u++)n[u]=a(0===u?"":n[u-1],o(n[u]));return n};var o=function(e){return e.replace(/\//g,"//")};t.getEscapedFileName=o;var a=function(){var e="";return(0,i.each)(arguments,(function(t,n){n&&(e&&(e+="/"),e+=n)})),e};t.pathCombine=a},30343:function(e,t,n){t.default=void 0;var i=n(35922),o=l(n(91198)),a=l(n(18016)),r=l(n(91500)),s=l(n(20476));function l(e){return e&&e.__esModule?e:{default:e}}n(89740);var u=(0,s.default)({format:function(e,t){var n=(0,i.isString)(t)&&""!==t||(0,i.isPlainObject)(t)||(0,i.isFunction)(t),o=(0,i.isNumeric)(e)||(0,i.isDate)(e);return n&&o?(0,i.isFunction)(t)?t(e):((0,i.isString)(t)&&(t={type:t}),(0,i.isNumeric)(e)?a.default.format(e,t):(0,i.isDate)(e)?r.default.format(e,t):void 0):(0,i.isDefined)(e)?e.toString():""},getTimeFormat:function(e){return e?"longtime":"shorttime"},_normalizeFormat:function(e){return Array.isArray(e)?1===e.length?e[0]:function(t){return e.map((function(e){return r.default.format(t,e)})).join(" ")}:e},getDateFormatByDifferences:function(e,t){var n=[],i=t&&e.millisecond&&!(e.year||e.month||e.day);if(i){n.push((function(e){return e.getSeconds()+e.getMilliseconds()/1e3+"s"}))}else e.millisecond&&n.push("millisecond");if((e.hour||e.minute||!i&&e.second)&&n.unshift(this.getTimeFormat(e.second)),e.year&&e.month&&e.day)return t&&"month"===t?"monthandyear":(n.unshift("shortdate"),this._normalizeFormat(n));if(e.year&&e.month)return"monthandyear";if(e.year&&e.quarter)return"quarterandyear";if(e.year)return"year";if(e.quarter)return"quarter";if(e.month&&e.day){if(t){n.unshift((function(e){return r.default.getMonthNames("abbreviated")[e.getMonth()]+" "+r.default.format(e,"day")}))}else n.unshift("monthandday");return this._normalizeFormat(n)}if(e.month)return"month";if(e.day){if(t)n.unshift("day");else{n.unshift((function(e){return r.default.format(e,"dayofweek")+", "+r.default.format(e,"day")}))}return this._normalizeFormat(n)}return this._normalizeFormat(n)},getDateFormatByTicks:function(e){var t,n,i;if(e.length>1)for(t=o.default.getDatesDifferences(e[0],e[1]),i=1;i<e.length-1;i++)n=o.default.getDatesDifferences(e[i],e[i+1]),t.count<n.count&&(t=n);else t={year:!0,month:!0,day:!0,hour:e[0].getHours()>0,minute:e[0].getMinutes()>0,second:e[0].getSeconds()>0,millisecond:e[0].getMilliseconds()>0};return this.getDateFormatByDifferences(t)},getDateFormatByTickInterval:function(e,t,n){var a,r=function(e,t,n){switch(t){case"year":case"quarter":e.month=n;case"month":e.day=n;case"week":case"day":e.hour=n;case"hour":e.minute=n;case"minute":e.second=n;case"second":e.millisecond=n}};n=(0,i.isString)(n)?n.toLowerCase():n;var s,l,u,d=o.default.getDatesDifferences(e,t);return e!==t&&(s=d,l=e>t?t:e,!(u=e>t?e:t).getMilliseconds()&&u.getSeconds()?u.getSeconds()-l.getSeconds()==1&&(s.millisecond=!0,s.second=!1):!u.getSeconds()&&u.getMinutes()?u.getMinutes()-l.getMinutes()==1&&(s.second=!0,s.minute=!1):!u.getMinutes()&&u.getHours()?u.getHours()-l.getHours()==1&&(s.minute=!0,s.hour=!1):!u.getHours()&&u.getDate()>1?u.getDate()-l.getDate()==1&&(s.hour=!0,s.day=!1):1===u.getDate()&&u.getMonth()?u.getMonth()-l.getMonth()==1&&(s.day=!0,s.month=!1):!u.getMonth()&&u.getFullYear()&&u.getFullYear()-l.getFullYear()==1&&(s.month=!0,s.year=!1)),r(d,a=o.default.getDateUnitInterval(d),!0),r(d,a=o.default.getDateUnitInterval(n||"second"),!1),d[{week:"day"}[a]||a]=!0,this.getDateFormatByDifferences(d)}});t.default=u,e.exports=t.default,e.exports.default=t.default},71582:function(e,t,n){n(78475),n(38971),n(12993),n(11579),n(21298)},21298:function(e,t,n){var i=o(n(62414));function o(e){return e&&e.__esModule?e:{default:e}}o(n(62387)).default&&i.default.registerExecutor({ngExpression:{execute:function(e){"string"==typeof e.action&&e.context.$eval(e.action)}}})},38971:function(e,t,n){var i=x(n(68374)),o=x(n(62387)),a=x(n(55994)),r=x(n(80209)),s=x(n(5554)),l=x(n(38377)),u=x(n(44504)),d=n(35922),c=n(95479),h=x(n(88933)),p=x(n(96452)),f=n(76165),g=x(n(69155)),m=x(n(11050)),_=n(47617),v=n(13306),y=n(49036),b=n(78008);function x(e){return e&&e.__esModule?e:{default:e}}function w(e){return(w="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}if(o.default){var C=function(e,t){return t.$root.$$phase?e(t):t.$apply((function(){return e(t)}))},S=l.default.inherit({ctor:function(e){this._componentDisposing=(0,u.default)(),this._optionChangedCallbacks=(0,u.default)(),this._ngLocker=new h.default,this._scope=e.scope,this._$element=e.$element,this._$templates=e.$templates,this._componentClass=e.componentClass,this._parse=e.parse,this._compile=e.compile,this._itemAlias=e.itemAlias,this._transcludeFn=e.transcludeFn,this._digestCallbacks=e.dxDigestCallbacks,this._normalizeOptions(e.ngOptions),this._initComponentBindings(),this._initComponent(this._scope),e.ngOptions||this._addOptionsStringWatcher(e.ngOptionsString)},_addOptionsStringWatcher:function(e){var t=this,n=this._scope.$watch(e,(function(e){e&&(n(),t._normalizeOptions(e),t._initComponentBindings(),t._component.option(t._evalOptions(t._scope)))}));this._componentDisposing.add(n)},_normalizeOptions:function(e){var t=this;this._ngOptions=(0,v.extendFromObject)({},e),e&&(!Object.prototype.hasOwnProperty.call(e,"bindingOptions")&&e.bindingOptions&&(this._ngOptions.bindingOptions=e.bindingOptions),e.bindingOptions&&(0,c.each)(e.bindingOptions,(function(e,n){"string"===(0,d.type)(n)&&(t._ngOptions.bindingOptions[e]={dataPath:n})})))},_initComponent:function(e){this._component=new this._componentClass(this._$element,this._evalOptions(e)),this._component._isHidden=!0,this._handleDigestPhase()},_handleDigestPhase:function(){var e=this,t=function(){e._component.beginUpdate()},n=function(){e._component.endUpdate()};this._digestCallbacks.begin.add(t),this._digestCallbacks.end.add(n),this._componentDisposing.add((function(){e._digestCallbacks.begin.remove(t),e._digestCallbacks.end.remove(n)}))},_initComponentBindings:function(){var e=this,t={};this._ngOptions.bindingOptions&&((0,c.each)(this._ngOptions.bindingOptions,(function(n,i){var o,a,r=n.search(/\[|\./),s=r>-1?n.substring(0,r):n,l=i.dataPath,u=!0,d=!1;void 0!==i.deep&&(d=u=!!i.deep),t[s]||(t[s]={}),t[s][n]=l;!function t(){var i=Array.isArray(e._scope.$eval(l))&&!d?"$watchCollection":"$watch";o!==i&&(a&&a(),a=e._scope[i](l,(function(i,o){e._ngLocker.locked(n)||(e._ngLocker.obtain(n),e._component.option(n,i),t(),(0,y.equals)(o,i)&&e._ngLocker.locked(n)&&e._ngLocker.release(n))}),u),o=i)}(),e._componentDisposing.add(a)})),this._optionChangedCallbacks.add((function(n){var i=n.name,o=n.fullName,a=n.component;if(e._ngLocker.locked(o))e._ngLocker.release(o);else if(t&&t[i]){var r=e._scope.$root.$$phase,s=function(){e._ngLocker.obtain(o)};r?e._digestCallbacks.begin.add(s):s(),C((function(){(0,c.each)(t[i],(function(t,i){if(e._optionsAreLinked(o,t)){var r=a.option(t);e._parse(i).assign(e._scope,r);var s=e._parse(i)(e._scope);s!==r&&n.component.option(t,s)}}))}),e._scope);var l=function t(){e._ngLocker.locked(o)&&e._ngLocker.release(o),e._digestCallbacks.begin.remove(s),e._digestCallbacks.end.remove(t)};r?e._digestCallbacks.end.addPrioritized(l):l()}})))},_optionsAreNested:function(e,t){var n=e[t.length];return 0===e.indexOf(t)&&("."===n||"["===n)},_optionsAreLinked:function(e,t){return e===t||(e.length>t.length?this._optionsAreNested(e,t):this._optionsAreNested(t,e))},_compilerByTemplate:function(e){var t=this,n=this._getScopeItemsPath();return function(o){var r=(0,i.default)(e).clone(),s=o.model&&o.model.constructor===t._scope.$root.constructor?o.model:o.noModel?t._scope:t._createScopeWithData(o);n&&t._synchronizeScopes(s,n,o.index),r.appendTo(o.container),o.noModel||a.default.on(r,"$destroy",(function(){!s.$parent||s.$destroy()}));var l=t._compile(r,t._transcludeFn);return t._applyAsync((function(e){l(e,null,{parentBoundTranscludeFn:t._transcludeFn})}),s),r}},_applyAsync:function(e,t){var n=this;if(e(t),!t.$root.$$phase&&!this._renderingTimer){var i=function(){clearTimeout(n._renderingTimer)};this._renderingTimer=setTimeout((function(){t.$apply(),n._renderingTimer=null,n._componentDisposing.remove(i)})),this._componentDisposing.add(i)}},_getScopeItemsPath:function(){if(this._componentClass.subclassOf(m.default)&&this._ngOptions.bindingOptions&&this._ngOptions.bindingOptions.items)return this._ngOptions.bindingOptions.items.dataPath},_createScopeWithData:function(e){var t=this._scope.$new();return this._itemAlias&&(t[this._itemAlias]=e.model),(0,d.isDefined)(e.index)&&(t.$index=e.index),t},_synchronizeScopes:function(e,t,n){this._itemAlias&&"object"!==w(e[this._itemAlias])&&this._synchronizeScopeField({parentScope:this._scope,childScope:e,fieldPath:this._itemAlias,parentPrefix:t,itemIndex:n})},_synchronizeScopeField:function(e){var t=e.parentScope,n=e.childScope,i=e.fieldPath,o=e.parentPrefix,a=e.itemIndex,r=i===this._itemAlias?"":"."+i,s=void 0!==a,l=[o];if(s){if(!(0,d.isNumeric)(a))return;l.push("[",a,"]")}l.push(r);var u=l.join(""),c=t.$watch(u,(function(e,t){e!==t&&(0,_.compileSetter)(i)(n,e)})),h=n.$watch(i,(function(e,n){if(e!==n){if(s&&!(0,_.compileGetter)(o)(t)[a])return void h();(0,_.compileSetter)(u)(t,e)}}));this._componentDisposing.add([c,h])},_evalOptions:function(e){var t=this,n=(0,v.extendFromObject)({},this._ngOptions);return delete n.bindingOptions,this._ngOptions.bindingOptions&&(0,c.each)(this._ngOptions.bindingOptions,(function(t,i){n[t]=e.$eval(i.dataPath)})),n._optionChangedCallbacks=this._optionChangedCallbacks,n._disposingCallbacks=this._componentDisposing,n.onActionCreated=function(t,n,i){if(i&&"rendering"===i.category)return n;return function(){var t=this,i=arguments;return e&&e.$root&&!e.$root.$$phase?C((function(){return n.apply(t,i)}),e):n.apply(this,i)}},n.beforeActionExecute=n.onActionCreated,n.nestedComponentOptions=function(e){return{templatesRenderAsynchronously:e.option("templatesRenderAsynchronously"),forceApplyBindings:e.option("forceApplyBindings"),modelByElement:e.option("modelByElement"),onActionCreated:e.option("onActionCreated"),beforeActionExecute:e.option("beforeActionExecute"),nestedComponentOptions:e.option("nestedComponentOptions")}},n.templatesRenderAsynchronously=!0,(0,r.default)().wrapActionsBeforeExecute&&(n.forceApplyBindings=function(){C((function(){}),e)}),n.integrationOptions={createTemplate:function(e){return new f.NgTemplate(e,t._compilerByTemplate.bind(t))},watchMethod:function(n,i,o){var a,s=(o=o||{}).skipImmediate,l=e.$watch((function(){var e=n();return e instanceof Date&&(e=e.valueOf()),e}),(function(e){var t=a===e;!s&&(!t||t&&o.deep)&&i(e),s=!1}),o.deep);return s||(a=n(),i(a)),(0,r.default)().wrapActionsBeforeExecute&&t._applyAsync((function(){}),e),l},templates:{"dx-polymorph-widget":{render:function(e){var n=e.model.widget;if(n){var o=(0,i.default)("<div>").attr((0,b.dasherize)(n),"options").get(0),a=t._scope.$new();a.options=e.model.options,e.container.append(o),t._compile(o)(a)}}}}},n.modelByElement=function(){return e},n}});S=S.inherit({ctor:function(e){this._componentName=e.componentName,this._ngModel=e.ngModel,this._ngModelController=e.ngModelController,this.callBase.apply(this,arguments)},_isNgModelRequired:function(){return p.default.isEditor(this._componentClass.prototype)&&this._ngModel},_initComponentBindings:function(){this.callBase.apply(this,arguments),this._initNgModelBinding()},_initNgModelBinding:function(){var e=this;if(this._isNgModelRequired()){var t=this._scope.$watch(this._ngModel,(function(t,n){e._ngLocker.locked("value")||t!==n&&e._component.option("value",t)}));this._optionChangedCallbacks.add((function(t){e._ngLocker.obtain("value");try{if("value"!==t.name)return;e._ngModelController.$setViewValue(t.value)}finally{e._ngLocker.locked("value")&&e._ngLocker.release("value")}})),this._componentDisposing.add(t)}},_evalOptions:function(){if(!this._isNgModelRequired())return this.callBase.apply(this,arguments);var e=this.callBase.apply(this,arguments);return e.value=this._parse(this._ngModel)(this._scope),e}});var k={},D=function(e){var t="dxValidator"!==e?1:10;g.default.directive(e,["$compile","$parse","dxDigestCallbacks",function(n,i,o){return{restrict:"A",require:"^?ngModel",priority:t,compile:function(t){var a=k[e],r=(a.prototype._useTemplates?a.prototype._useTemplates():function e(t,n){if(!Object.prototype.hasOwnProperty.bind(t)("parent")&&t.parent){var i=Object.getPrototypeOf(t);return i.prototype[n]?function(){return i.prototype[n]()}:e(i,n)}var o=t.parent.prototype[n];return o?function(){return o()}:o&&t.parent.subclassOf?e(t.parent,n):function(){}}(a,"_useTemplates")())?t.contents().detach():null;return function(t,s,l,u,d){s.append(r),C((function(){new S({componentClass:a,componentName:e,compile:n,parse:i,$element:s,scope:t,ngOptionsString:l[e],ngOptions:l[e]?t.$eval(l[e]):{},ngModel:l.ngModel,ngModelController:u,transcludeFn:d,itemAlias:l.dxItemAlias,dxDigestCallbacks:o})}),t)}}}}])};s.default.add((function(e,t){k[e]||D(e),k[e]=t}))}},11579:function(e,t,n){var i=a(n(44504)),o=a(n(69155));function a(e){return e&&e.__esModule?e:{default:e}}a(n(62387)).default&&o.default.service("dxDigestCallbacks",["$rootScope",function(e){var t=(0,i.default)(),n=(0,i.default)(),o=(0,i.default)(),a=!1;return e.$watch((function(){a||(a=!0,t.fire(),e.$$postDigest((function(){a=!1,n.fire(),o.fire()})))})),{begin:{add:function(e){a&&e(),t.add(e)},remove:t.remove.bind(t)},end:{add:o.add.bind(o),addPrioritized:n.add.bind(n),remove:o.remove.bind(o)}}}])},12993:function(e,t,n){var i=r(n(94553)),o=r(n(55994)),a=r(n(69155));function r(e){return e&&e.__esModule?e:{default:e}}r(n(62387)).default&&i.default.add((function(e){var t=e.slice(0,2)+e.charAt(2).toUpperCase()+e.slice(3);a.default.directive(t,["$parse",function(n){return function(i,a,r){var s,l=r[t].trim(),u={};"{"===l.charAt(0)?(u=i.$eval(l),s=n(u.execute)):s=n(r[t]),o.default.on(a,e,u,(function(e){i.$apply((function(){s(i,{$event:e})}))}))}}])}))},69155:function(e,t,n){t.default=void 0;var i,o=(i=n(62387))&&i.__esModule?i:{default:i};var a={};o.default&&(a=o.default.module("dx",[]));var r=a;t.default=r,e.exports=t.default,e.exports.default=t.default},76165:function(e,t,n){t.NgTemplate=void 0;var i,o=(i=n(68374))&&i.__esModule?i:{default:i},a=n(81033),r=n(35922),s=n(3532);function l(e,t){return(l=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e})(e,t)}var u=function(e){var t,n;function i(t,n){var i;return(i=e.call(this)||this)._element=t,i._compiledTemplate=n((0,s.normalizeTemplateElement)(i._element)),i}n=e,(t=i).prototype=Object.create(n.prototype),t.prototype.constructor=t,l(t,n);var a=i.prototype;return a._renderCore=function(e){var t=this._compiledTemplate;return(0,r.isFunction)(t)?t(e):t},a.source=function(){return(0,o.default)(this._element).clone()},i}(a.TemplateBase);t.NgTemplate=u},78475:function(e,t,n){var i=s(n(96073)),o=n(58020),a=s(n(95640)),r=s(n(72722));function s(e){return e&&e.__esModule?e:{default:e}}if(n(17394),n(59228),n(66809),n(32185),n(711),n(27387),n(95063),n(63200),n(87481),n(30829),(0,r.default)()&&(0,o.compare)(i.default.fn.jquery,[1,10])<0)throw a.default.Error("E0012")},30829:function(e,t,n){var i=a(n(96073)),o=a(n(37208));function a(e){return e&&e.__esModule?e:{default:e}}(0,a(n(72722)).default)()&&o.default.inject({sendRequest:function(e){return e.responseType||e.upload?this.callBase.apply(this,[e]):i.default.ajax(e)}})},87481:function(e,t,n){var i=r(n(96073)),o=r(n(5554)),a=r(n(17381));function r(e){return e&&e.__esModule?e:{default:e}}if(i.default){o.default.add((function(e,t){i.default.fn[e]=function(n){var i,o="string"==typeof n;if(o){var r=n,s=[].slice.call(arguments).slice(1);this.each((function(){var n=t.getInstance(this);if(!n)throw a.default.Error("E0009",e);var o=n[r].apply(n,s);void 0===i&&(i=o)}))}else this.each((function(){var e=t.getInstance(this);e?e.option(n):new t(this,n)})),i=this;return i}}))}},66809:function(e,t,n){var i=r(n(96073)),o=n(62754),a=n(58020);function r(e){return e&&e.__esModule?e:{default:e}}if((0,r(n(72722)).default)()){var s=i.default.Deferred,l={Deferred:s};l.when=(0,a.compare)(i.default.fn.jquery,[3])<0?i.default.when:function(e){return 0===arguments.length?(new s).resolve():1===arguments.length?e&&e.then?e:(new s).resolve(e):i.default.when.apply(i.default,arguments)},(0,o.setStrategy)(l)}},27387:function(e,t,n){var i,o=(i=n(96073))&&i.__esModule?i:{default:i},a=n(23908);o.default&&(0,a.setEasing)(o.default.easing)},63200:function(e,t,n){var i,o=n(6415);(0,((i=n(72722))&&i.__esModule?i:{default:i}).default)()&&(0,o.setPublicElementWrapper)((function(e){return e}))},95063:function(e,t,n){var i=a(n(96073)),o=n(97906);function a(e){return e&&e.__esModule?e:{default:e}}(0,a(n(72722)).default)()&&(0,o.setDataStrategy)(i.default)},711:function(e,t,n){var i=l(n(96073)),o=l(n(55994)),a=l(n(72722)),r=l(n(94553)),s=l(n(73349));function l(e){return e&&e.__esModule?e:{default:e}}(0,a.default)()&&(r.default.add((function(e,t){i.default.event.special[e]=t})),o.default.passiveEventHandlersSupported()&&o.default.forcePassiveFalseEventNames.forEach((function(e){i.default.event.special[e]={setup:function(t,n,i){s.default.listen(this,e,i,{passive:!1})}}})),o.default.set({on:function(e){(0,i.default)(e).on.apply((0,i.default)(e),Array.prototype.slice.call(arguments,1))},one:function(e){(0,i.default)(e).one.apply((0,i.default)(e),Array.prototype.slice.call(arguments,1))},off:function(e){(0,i.default)(e).off.apply((0,i.default)(e),Array.prototype.slice.call(arguments,1))},trigger:function(e){(0,i.default)(e).trigger.apply((0,i.default)(e),Array.prototype.slice.call(arguments,1))},triggerHandler:function(e){(0,i.default)(e).triggerHandler.apply((0,i.default)(e),Array.prototype.slice.call(arguments,1))},Event:i.default.Event}))},32185:function(e,t,n){var i=r(n(96073)),o=n(89729),a=r(n(24311));function r(e){return e&&e.__esModule?e:{default:e}}if(i.default&&!o.themeReadyCallback.fired()){var s=i.default.holdReady||i.default.fn.holdReady;s(!0),o.themeReadyCallback.add((function(){a.default.add((function(){s(!1)}))}))}},59228:function(e,t,n){var i=c(n(96073)),o=c(n(72722)),a=n(58020),r=n(95479),s=n(35922),l=n(39611),u=c(n(85788)),d=c(n(2418));function c(e){return e&&e.__esModule?e:{default:e}}if((0,o.default)())if((0,a.compare)(i.default.fn.jquery,[3])<0){var h={2:"touch",3:"pen",4:"mouse"};(0,r.each)(["MSPointerDown","MSPointerMove","MSPointerUp","MSPointerCancel","MSPointerOver","MSPointerOut","mouseenter","mouseleave","pointerdown","pointermove","pointerup","pointercancel","pointerover","pointerout","pointerenter","pointerleave"],(function(){i.default.event.fixHooks[this]={filter:function(e,t){var n=t.pointerType;return(0,s.isNumeric)(n)&&(e.pointerType=h[n]),e},props:i.default.event.mouseHooks.props.concat(["pointerId","pointerType","originalTarget","width","height","pressure","result","tiltX","charCode","tiltY","detail","isPrimary","prevValue"])}})),(0,r.each)(["touchstart","touchmove","touchend","touchcancel"],(function(){i.default.event.fixHooks[this]={filter:function(e,t){return(0,d.default)((function(n,i){e[n]=i(t)})),e},props:i.default.event.mouseHooks.props.concat(["touches","changedTouches","targetTouches","detail","result","originalTarget","charCode","prevValue"])}})),i.default.event.fixHooks.wheel=i.default.event.mouseHooks;var p={props:i.default.event.mouseHooks.props.concat(["pointerType","pointerId","pointers"])};u.default.callbacks.add((function(e){i.default.event.fixHooks[e]=p}));(0,l.setEventFixMethod)((function(e,t){for(var n=i.default.event.fixHooks[t.type]||i.default.event.mouseHooks,o=n.props?i.default.event.props.concat(n.props):i.default.event.props,a=o.length;a--;){var r=o[a];e[r]=t[r]}return n.filter?n.filter(e,t):e}))}else(0,d.default)((function(e,t){i.default.event.addProp(e,t)}))},17394:function(e,t,n){var i=a(n(96073)),o=a(n(82981));function a(e){return e&&e.__esModule?e:{default:e}}(0,a(n(72722)).default)()&&o.default.set(i.default)},72722:function(e,t,n){t.default=function(){return i.default&&(0,o.default)().useJQuery};var i=a(n(96073)),o=a(n(80209));function a(e){return e&&e.__esModule?e:{default:e}}var r=(0,o.default)().useJQuery;i.default&&!1!==r&&(0,o.default)({useJQuery:!0}),e.exports=t.default,e.exports.default=t.default},49281:function(e,t,n){var i=r(n(76130)),o=r(n(17381)),a=n(58020);function r(e){return e&&e.__esModule?e:{default:e}}if(n(89135),n(70883),n(89620),n(24935),n(74942),n(27521),n(61823),i.default&&(0,a.compare)(i.default.version,[2,3])<0)throw o.default.Error("E0013")},27521:function(e,t,n){var i,o=n(97906),a=(i=n(76130))&&i.__esModule?i:{default:i},r=n(58020),s=n(45994);if(a.default){var l=a.default.utils.domNodeDisposal.cleanExternalData;(0,o.afterCleanData)((function(e){var t;for(t=0;t<e.length;t++)e[t].cleanedByJquery=!0;for(t=0;t<e.length;t++)e[t].cleanedByKo||a.default.cleanNode(e[t]),delete e[t].cleanedByKo;for(t=0;t<e.length;t++)delete e[t].cleanedByJquery})),a.default.utils.domNodeDisposal.cleanExternalData=function(e){e.cleanedByKo=!0,(0,s.getClosestNodeWithKoCreation)(e)&&(e.cleanedByJquery||(0,o.cleanData)([e]))},o.strategyChanging.add((function(e){!!e.fn&&(0,r.compare)(e.fn.jquery,[2,0])<0&&((0,o.afterCleanData)((function(){})),a.default.utils.domNodeDisposal.cleanExternalData=l)}))}},61823:function(e,t,n){var i,o=(i=n(76130))&&i.__esModule?i:{default:i},a=n(58020),r=n(97906);if(o.default){r.strategyChanging.add((function(e){!!e.fn&&(0,a.compare)(e.fn.jquery,[2,0])<0&&function(e){var t=function(e,t){var n=function(){o.default.cleanNode(this)};t?e.each(n):e.find("*").each(n)},n=e.fn.empty;e.fn.empty=function(){return t(this,!1),n.apply(this,arguments)};var i=e.fn.remove;e.fn.remove=function(e,n){if(!n){var o=this;e&&(o=o.filter(e)),t(o,!0)}return i.call(this,e,n)};var a=e.fn.html;e.fn.html=function(e){return"string"==typeof e&&t(this,!1),a.apply(this,arguments)};var r=e.fn.replaceWith;e.fn.replaceWith=function(){var e=r.apply(this,arguments);return this.parent().length||t(this,!0),e}}(e)}))}},89135:function(e,t,n){var i=_(n(68374)),o=_(n(76130)),a=_(n(44504)),r=n(35922),s=_(n(5554)),l=_(n(14390)),u=_(n(59063)),d=_(n(27135)),c=_(n(42160)),h=n(1129),p=_(n(96452)),f=_(n(88933)),g=n(45994),m=_(n(80209));function _(e){return e&&e.__esModule?e:{default:e}}if(o.default){var v=[];s.default.add((function(e,t){!function(e,t){p.default.isEditor(t.prototype)&&v.push(e),o.default.bindingHandlers[e]={init:function(e,n){var s,p,_=(0,i.default)(e),v=(0,a.default)(),y={},b=(0,m.default)().knockout,x=b&&b.isBindingPropertyPredicateName,w={onInitializing:function(t){var i=this;y=this._getOptionsByReference(),o.default.computed((function(){var e,a=o.default.unwrap(n());(s&&s.beginUpdate(),p=x&&a&&a[x],I(a),s)?s.endUpdate():null==a||null===(e=a.onInitializing)||void 0===e||e.call(i,t)}),null,{disposeWhenNodeIsRemoved:e}),s=this},modelByElement:function(e){if(e.length){var t=(0,g.getClosestNodeWithContext)(e.get(0));return o.default.dataFor(t)}},nestedComponentOptions:function(e){return{modelByElement:e.option("modelByElement"),nestedComponentOptions:e.option("nestedComponentOptions")}},_optionChangedCallbacks:v,integrationOptions:{watchMethod:function(e,t,n){var i=(n=n||{}).skipImmediate,a=o.default.computed((function(){var n=o.default.unwrap(e());i||t(n),i=!1}));return function(){a.dispose()}},templates:{"dx-polymorph-widget":{render:function(e){var t=o.default.utils.unwrapObservable(e.model.widget);if(t){var n=(0,i.default)("<div>").attr("data-bind",t+": options").get(0);(0,i.default)(e.container).append(n),o.default.applyBindings(e.model,n)}}}},createTemplate:function(e){return new h.KoTemplate(e)}}},C={},S=function(e,t,n){var i=_.data("dxKoLocks"),a=n?o.default.unwrap(t):t;if(o.default.isWriteableObservable(t)&&(C[e]=t),s){if(i.locked(e))return;i.obtain(e);try{o.default.ignoreDependencies?o.default.ignoreDependencies(s.option,s,[e,a]):s.option(e,a)}finally{i.release(e)}}else w[e]=a},k=function(e){var t=e.fullName,n=e.value;if(t in C){var i=this._$element.data("dxKoLocks");if(!i.locked(t)){i.obtain(t);try{C[t](n)}finally{i.release(t)}}}},D=function(t,n,i){var a;i!==x&&(!p||p(i,n,t)?(o.default.computed((function(){var e=t[n];S(i,e,!0),a=o.default.unwrap(e)}),null,{disposeWhenNodeIsRemoved:e}),(0,r.isPlainObject)(a)&&(y[i]||I(a,i))):S(i,t[n],!1))};function I(e,t){for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&D(e,n,t?[t,n].join("."):n)}return v.add(k),_.data("dxKoCreation",!0).data("dxKoLocks",new f.default),new t(_,w),w=null,{controlsDescendantBindings:t.subclassOf(l.default)||t.subclassOf(u.default)||t.subclassOf(d.default)||s instanceof c.default}}},"dxValidator"===e&&(o.default.bindingHandlers.dxValidator.after=v)}(e,t)}))}},89620:function(e,t,n){var i,o=(i=n(76130))&&i.__esModule?i:{default:i},a=n(44899);o.default&&(o.default.bindingHandlers.dxControlsDescendantBindings={init:function(e,t){return{controlsDescendantBindings:o.default.unwrap(t())}}},o.default.bindingHandlers.dxIcon={init:function(e,t){var n=o.default.utils.unwrapObservable(t())||{},i=(0,a.getImageContainer)(n);o.default.virtualElements.emptyNode(e),i&&o.default.virtualElements.prepend(e,i.get(0))},update:function(e,t){var n=o.default.utils.unwrapObservable(t())||{},i=(0,a.getImageContainer)(n);o.default.virtualElements.emptyNode(e),i&&o.default.virtualElements.prepend(e,i.get(0))}},o.default.virtualElements.allowedBindings.dxIcon=!0)},70883:function(e,t,n){var i=u(n(68374)),o=u(n(55994)),a=u(n(76130)),r=n(35922),s=u(n(94553)),l=n(39611);function u(e){return e&&e.__esModule?e:{default:e}}a.default&&s.default.add((function(e){var t=(0,l.addNamespace)(e,e+"Binding");a.default.bindingHandlers[e]={update:function(e,n,s,l){var u=(0,i.default)(e),d=a.default.utils.unwrapObservable(n()),c=d.execute?d.execute:d;o.default.off(u,t),o.default.on(u,t,(0,r.isPlainObject)(d)?d:{},(function(e){c.call(l,l,e)}))}}}))},1129:function(e,t,n){t.KoTemplate=void 0;var i=d(n(68374)),o=d(n(73349)),a=d(n(76130)),r=n(35922),s=n(81033),l=n(3532),u=n(45994);function d(e){return e&&e.__esModule?e:{default:e}}function c(e,t){return(c=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e})(e,t)}var h=function(e){var t,n;function s(t){var n;return(n=e.call(this)||this)._element=t,n._template=(0,i.default)("<div>").append((0,l.normalizeTemplateElement)(t)),n._registerKoTemplate(),n}n=e,(t=s).prototype=Object.create(n.prototype),t.prototype.constructor=t,c(t,n);var d=s.prototype;return d._registerKoTemplate=function(){var e=this._template.get(0);new a.default.templateSources.anonymousTemplate(e).nodes(e)},d._prepareDataForContainer=function(e,t){if(t&&t.length){var n=(0,u.getClosestNodeWithContext)(t.get(0)),i=a.default.contextFor(n);if(e=void 0!==e?e:a.default.dataFor(n)||{},i)return e===i.$data?i:i.createChildContext(e)}return function(e){var t=o.default.createElement("div");a.default.applyBindingsToNode(t,null,e);var n=a.default.contextFor(t);return a.default.cleanNode(t),n}(e).createChildContext(e)},d._renderCore=function(e){var t=this._prepareDataForContainer(e.model,(0,i.default)(e.container));(0,r.isDefined)(e.index)&&(t.$index=e.index);var n,o=(0,i.default)("<div>").appendTo(e.container);return a.default.renderTemplate(this._template.get(0),t,{afterRender:function(e){n=(0,i.default)(e)}},o.get(0),"replaceNode"),n},d.source=function(){return(0,i.default)(this._element).clone()},d.dispose=function(){this._template.remove()},s}(s.TemplateBase);t.KoTemplate=h},45994:function(e,t,n){t.getClosestNodeWithKoCreation=t.getClosestNodeWithContext=void 0;var i=a(n(76130)),o=a(n(68374));function a(e){return e&&e.__esModule?e:{default:e}}t.getClosestNodeWithContext=function e(t){return!i.default.contextFor(t)&&t.parentNode?e(t.parentNode):t};t.getClosestNodeWithKoCreation=function e(t){var n=(0,o.default)(t).data();return n&&n.dxKoCreation?t:t.parentNode?e(t.parentNode):null}},24935:function(e,t,n){var i=n(95479),o=n(13306),a=c(n(38377)),r=n(80566),s=c(n(90964)),l=n(62754),u=c(n(73176)),d=c(n(76130));function c(e){return e&&e.__esModule?e:{default:e}}if(d.default){var h=a.default.inherit({ctor:function(e,t){var n=this,a=t.name,s=t.validationRules;this.target=e,this.name=a,this.isValid=d.default.observable(!0),this.validationError=d.default.observable(),this.validationErrors=d.default.observable(),this.validationStatus=d.default.observable("valid"),this._eventsStrategy=new r.EventsStrategy(this),this.validationRules=(0,i.map)(s,(function(e,t){return(0,o.extend)({},e,{validator:n,index:t})})),this._validationInfo={result:null,deferred:null}},_updateValidationResult:function(e){if(this._validationInfo.result&&this._validationInfo.result.id===e.id)for(var t in e)"id"!==t&&"complete"!==t&&(this._validationInfo.result[t]=e[t]);else{var n=this._validationInfo.deferred&&this._validationInfo.result.complete;this._validationInfo.result=(0,o.extend)({},e,{complete:n})}},validate:function(){var e=this,t=this._validationInfo&&this._validationInfo.result,n=this.target();if(t&&"pending"===t.status&&t.value===n)return(0,o.extend)({},t);var i=s.default.validate(n,this.validationRules,this.name);return i.id=(new u.default).toString(),this._applyValidationResult(i),i.complete&&i.complete.then((function(t){t.id===e._validationInfo.result.id&&e._applyValidationResult(t)})),(0,o.extend)({},this._validationInfo.result)},reset:function(){this.target(null);var e={id:null,isValid:!0,brokenRule:null,pendingRules:null,status:"valid",complete:null};return this._applyValidationResult(e),e},_applyValidationResult:function(e){if(e.validator=this,this._updateValidationResult(e),this.target.dxValidator.isValid(this._validationInfo.result.isValid),this.target.dxValidator.validationError(this._validationInfo.result.brokenRule),this.target.dxValidator.validationErrors(this._validationInfo.result.brokenRules),this.target.dxValidator.validationStatus(this._validationInfo.result.status),"pending"===e.status)return this._validationInfo.deferred||(this._validationInfo.deferred=new l.Deferred,this._validationInfo.result.complete=this._validationInfo.deferred.promise()),void this._eventsStrategy.fireEvent("validating",[this._validationInfo.result]);"pending"!==e.status&&(this._eventsStrategy.fireEvent("validated",[e]),this._validationInfo.deferred&&(this._validationInfo.deferred.resolve(e),this._validationInfo.deferred=null))},on:function(e,t){return this._eventsStrategy.on(e,t),this},off:function(e,t){return this._eventsStrategy.off(e,t),this}});d.default.extenders.dxValidator=function(e,t){return e.dxValidator=new h(e,t),e.subscribe(e.dxValidator.validate.bind(e.dxValidator)),e},s.default.registerModelForValidation=function(e){(0,i.each)(e,(function(t,n){d.default.isObservable(n)&&n.dxValidator&&s.default.registerValidatorInGroup(e,n.dxValidator)}))},s.default.unregisterModelForValidation=function(e){(0,i.each)(e,(function(t,n){d.default.isObservable(n)&&n.dxValidator&&s.default.removeRegisteredValidator(e,n.dxValidator)}))},s.default.validateModel=s.default.validateGroup}},74942:function(e,t,n){var i=a(n(76130)),o=a(n(26974));function a(e){return e&&e.__esModule?e:{default:e}}i.default&&o.default.inject({isWrapped:i.default.isObservable,isWritableWrapped:i.default.isWritableObservable,wrap:i.default.observable,unwrap:function(e){return i.default.isObservable(e)?i.default.utils.unwrapObservable(e):this.callBase(e)},assign:function(e,t){i.default.isObservable(e)?e(t):this.callBase(e,t)}})},94484:function(e,t,n){Object.defineProperty(t,"date",{enumerable:!0,get:function(){return r.default}}),t.disableIntl=function(){"intl"===a.default.engine()&&a.default.resetInjection();"intl"===r.default.engine()&&r.default.resetInjection()},t.locale=t.loadMessages=t.formatNumber=t.formatMessage=t.formatDate=void 0,Object.defineProperty(t,"message",{enumerable:!0,get:function(){return o.default}}),Object.defineProperty(t,"number",{enumerable:!0,get:function(){return a.default}}),t.parseNumber=t.parseDate=void 0;var i=s(n(91331)),o=s(n(28109)),a=s(n(18016)),r=s(n(91500));function s(e){return e&&e.__esModule?e:{default:e}}n(89740);var l=i.default.locale.bind(i.default);t.locale=l;var u=o.default.load.bind(o.default);t.loadMessages=u;var d=o.default.format.bind(o.default);t.formatMessage=d;var c=a.default.format.bind(a.default);t.formatNumber=c;var h=a.default.parse.bind(a.default);t.parseNumber=h;var p=r.default.format.bind(r.default);t.formatDate=p;var f=r.default.parse.bind(r.default);t.parseDate=f},71868:function(e,t){t.default=void 0;t.default={af:"\xa4#,##0.00;(\xa4#,##0.00)","af-NA":"\xa4#,##0.00;(\xa4#,##0.00)",agq:"#,##0.00\xa4",ak:"\xa4#,##0.00",am:"\xa4#,##0.00;(\xa4#,##0.00)",ar:"\xa4#,##0.00;(\xa4#,##0.00)","ar-AE":"\xa4#,##0.00;(\xa4#,##0.00)","ar-BH":"\xa4#,##0.00;(\xa4#,##0.00)","ar-DJ":"\xa4#,##0.00;(\xa4#,##0.00)","ar-DZ":"\xa4#,##0.00;(\xa4#,##0.00)","ar-EG":"\xa4#,##0.00;(\xa4#,##0.00)","ar-EH":"\xa4#,##0.00;(\xa4#,##0.00)","ar-ER":"\xa4#,##0.00;(\xa4#,##0.00)","ar-IL":"\xa4#,##0.00;(\xa4#,##0.00)","ar-IQ":"\xa4#,##0.00;(\xa4#,##0.00)","ar-JO":"\xa4#,##0.00;(\xa4#,##0.00)","ar-KM":"\xa4#,##0.00;(\xa4#,##0.00)","ar-KW":"\xa4#,##0.00;(\xa4#,##0.00)","ar-LB":"\xa4#,##0.00;(\xa4#,##0.00)","ar-LY":"\xa4#,##0.00;(\xa4#,##0.00)","ar-MA":"\xa4#,##0.00;(\xa4#,##0.00)","ar-MR":"\xa4#,##0.00;(\xa4#,##0.00)","ar-OM":"\xa4#,##0.00;(\xa4#,##0.00)","ar-PS":"\xa4#,##0.00;(\xa4#,##0.00)","ar-QA":"\xa4#,##0.00;(\xa4#,##0.00)","ar-SA":"\xa4#,##0.00;(\xa4#,##0.00)","ar-SD":"\xa4#,##0.00;(\xa4#,##0.00)","ar-SO":"\xa4#,##0.00;(\xa4#,##0.00)","ar-SS":"\xa4#,##0.00;(\xa4#,##0.00)","ar-SY":"\xa4#,##0.00;(\xa4#,##0.00)","ar-TD":"\xa4#,##0.00;(\xa4#,##0.00)","ar-TN":"\xa4#,##0.00;(\xa4#,##0.00)","ar-YE":"\xa4#,##0.00;(\xa4#,##0.00)",as:"\xa4\xa0#,##,##0.00",asa:"#,##0.00\xa0\xa4",ast:"#,##0.00\xa0\xa4",az:"#,##0.00\xa0\xa4","az-Cyrl":"#,##0.00\xa0\xa4","az-Latn":"#,##0.00\xa0\xa4",bas:"#,##0.00\xa0\xa4",be:"#,##0.00\xa0\xa4","be-tarask":"#,##0.00\xa0\xa4",bem:"\xa4#,##0.00;(\xa4#,##0.00)",bez:"#,##0.00\xa4",bg:"0.00\xa0\xa4;(0.00\xa0\xa4)",bm:"\xa4#,##0.00;(\xa4#,##0.00)",bn:"#,##,##0.00\xa4;(#,##,##0.00\xa4)","bn-IN":"#,##,##0.00\xa4;(#,##,##0.00\xa4)",bo:"\xa4\xa0#,##0.00","bo-IN":"\xa4\xa0#,##0.00",br:"#,##0.00\xa0\xa4",brx:"\xa4\xa0#,##,##0.00",bs:"#,##0.00\xa0\xa4","bs-Cyrl":"#,##0.00\xa0\xa4","bs-Latn":"#,##0.00\xa0\xa4",ca:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","ca-AD":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","ca-ES-valencia":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","ca-FR":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","ca-IT":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",ccp:"#,##,##0.00\xa4;(#,##,##0.00\xa4)","ccp-IN":"#,##,##0.00\xa4;(#,##,##0.00\xa4)",ce:"#,##0.00\xa0\xa4",ceb:"\xa4#,##0.00;(\xa4#,##0.00)",cgg:"\xa4#,##0.00",chr:"\xa4#,##0.00;(\xa4#,##0.00)",ckb:"\xa4\xa0#,##0.00","ckb-IR":"\xa4\xa0#,##0.00",cs:"#,##0.00\xa0\xa4",cy:"\xa4#,##0.00;(\xa4#,##0.00)",da:"#,##0.00\xa0\xa4","da-GL":"#,##0.00\xa0\xa4",dav:"\xa4#,##0.00;(\xa4#,##0.00)",de:"#,##0.00\xa0\xa4","de-AT":"#,##0.00\xa0\xa4","de-BE":"#,##0.00\xa0\xa4","de-CH":"#,##0.00\xa0\xa4","de-IT":"#,##0.00\xa0\xa4","de-LI":"#,##0.00\xa0\xa4","de-LU":"#,##0.00\xa0\xa4",dje:"#,##0.00\xa4",doi:"\xa4#,##0.00",dsb:"#,##0.00\xa0\xa4",dua:"#,##0.00\xa0\xa4",dyo:"#,##0.00\xa0\xa4",dz:"\xa4#,##,##0.00",ebu:"\xa4#,##0.00;(\xa4#,##0.00)",ee:"\xa4#,##0.00;(\xa4#,##0.00)","ee-TG":"\xa4#,##0.00;(\xa4#,##0.00)",el:"#,##0.00\xa0\xa4","el-CY":"#,##0.00\xa0\xa4",en:"\xa4#,##0.00;(\xa4#,##0.00)","en-001":"\xa4#,##0.00;(\xa4#,##0.00)","en-150":"#,##0.00\xa0\xa4","en-AE":"\xa4#,##0.00;(\xa4#,##0.00)","en-AG":"\xa4#,##0.00;(\xa4#,##0.00)","en-AI":"\xa4#,##0.00;(\xa4#,##0.00)","en-AS":"\xa4#,##0.00;(\xa4#,##0.00)","en-AT":"\xa4\xa0#,##0.00","en-AU":"\xa4#,##0.00;(\xa4#,##0.00)","en-BB":"\xa4#,##0.00;(\xa4#,##0.00)","en-BE":"#,##0.00\xa0\xa4","en-BI":"\xa4#,##0.00;(\xa4#,##0.00)","en-BM":"\xa4#,##0.00;(\xa4#,##0.00)","en-BS":"\xa4#,##0.00;(\xa4#,##0.00)","en-BW":"\xa4#,##0.00;(\xa4#,##0.00)","en-BZ":"\xa4#,##0.00;(\xa4#,##0.00)","en-CA":"\xa4#,##0.00;(\xa4#,##0.00)","en-CC":"\xa4#,##0.00;(\xa4#,##0.00)","en-CH":"\xa4\xa0#,##0.00;\xa4-#,##0.00","en-CK":"\xa4#,##0.00;(\xa4#,##0.00)","en-CM":"\xa4#,##0.00;(\xa4#,##0.00)","en-CX":"\xa4#,##0.00;(\xa4#,##0.00)","en-CY":"\xa4#,##0.00;(\xa4#,##0.00)","en-DE":"#,##0.00\xa0\xa4","en-DG":"\xa4#,##0.00;(\xa4#,##0.00)","en-DK":"#,##0.00\xa0\xa4","en-DM":"\xa4#,##0.00;(\xa4#,##0.00)","en-ER":"\xa4#,##0.00;(\xa4#,##0.00)","en-FI":"#,##0.00\xa0\xa4","en-FJ":"\xa4#,##0.00;(\xa4#,##0.00)","en-FK":"\xa4#,##0.00;(\xa4#,##0.00)","en-FM":"\xa4#,##0.00;(\xa4#,##0.00)","en-GB":"\xa4#,##0.00;(\xa4#,##0.00)","en-GD":"\xa4#,##0.00;(\xa4#,##0.00)","en-GG":"\xa4#,##0.00;(\xa4#,##0.00)","en-GH":"\xa4#,##0.00;(\xa4#,##0.00)","en-GI":"\xa4#,##0.00;(\xa4#,##0.00)","en-GM":"\xa4#,##0.00;(\xa4#,##0.00)","en-GU":"\xa4#,##0.00;(\xa4#,##0.00)","en-GY":"\xa4#,##0.00;(\xa4#,##0.00)","en-HK":"\xa4#,##0.00;(\xa4#,##0.00)","en-IE":"\xa4#,##0.00;(\xa4#,##0.00)","en-IL":"\xa4#,##0.00;(\xa4#,##0.00)","en-IM":"\xa4#,##0.00;(\xa4#,##0.00)","en-IN":"\xa4#,##0.00;(\xa4#,##0.00)","en-IO":"\xa4#,##0.00;(\xa4#,##0.00)","en-JE":"\xa4#,##0.00;(\xa4#,##0.00)","en-JM":"\xa4#,##0.00;(\xa4#,##0.00)","en-KE":"\xa4#,##0.00;(\xa4#,##0.00)","en-KI":"\xa4#,##0.00;(\xa4#,##0.00)","en-KN":"\xa4#,##0.00;(\xa4#,##0.00)","en-KY":"\xa4#,##0.00;(\xa4#,##0.00)","en-LC":"\xa4#,##0.00;(\xa4#,##0.00)","en-LR":"\xa4#,##0.00;(\xa4#,##0.00)","en-LS":"\xa4#,##0.00;(\xa4#,##0.00)","en-MG":"\xa4#,##0.00;(\xa4#,##0.00)","en-MH":"\xa4#,##0.00;(\xa4#,##0.00)","en-MO":"\xa4#,##0.00;(\xa4#,##0.00)","en-MP":"\xa4#,##0.00;(\xa4#,##0.00)","en-MS":"\xa4#,##0.00;(\xa4#,##0.00)","en-MT":"\xa4#,##0.00;(\xa4#,##0.00)","en-MU":"\xa4#,##0.00;(\xa4#,##0.00)","en-MV":"\xa4\xa0#,##0.00","en-MW":"\xa4#,##0.00;(\xa4#,##0.00)","en-MY":"\xa4#,##0.00;(\xa4#,##0.00)","en-NA":"\xa4#,##0.00;(\xa4#,##0.00)","en-NF":"\xa4#,##0.00;(\xa4#,##0.00)","en-NG":"\xa4#,##0.00;(\xa4#,##0.00)","en-NL":"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)","en-NR":"\xa4#,##0.00;(\xa4#,##0.00)","en-NU":"\xa4#,##0.00;(\xa4#,##0.00)","en-NZ":"\xa4#,##0.00;(\xa4#,##0.00)","en-PG":"\xa4#,##0.00;(\xa4#,##0.00)","en-PH":"\xa4#,##0.00;(\xa4#,##0.00)","en-PK":"\xa4#,##0.00;(\xa4#,##0.00)","en-PN":"\xa4#,##0.00;(\xa4#,##0.00)","en-PR":"\xa4#,##0.00;(\xa4#,##0.00)","en-PW":"\xa4#,##0.00;(\xa4#,##0.00)","en-RW":"\xa4#,##0.00;(\xa4#,##0.00)","en-SB":"\xa4#,##0.00;(\xa4#,##0.00)","en-SC":"\xa4#,##0.00;(\xa4#,##0.00)","en-SD":"\xa4#,##0.00;(\xa4#,##0.00)","en-SE":"#,##0.00\xa0\xa4","en-SG":"\xa4#,##0.00;(\xa4#,##0.00)","en-SH":"\xa4#,##0.00;(\xa4#,##0.00)","en-SI":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","en-SL":"\xa4#,##0.00;(\xa4#,##0.00)","en-SS":"\xa4#,##0.00;(\xa4#,##0.00)","en-SX":"\xa4#,##0.00;(\xa4#,##0.00)","en-SZ":"\xa4#,##0.00;(\xa4#,##0.00)","en-TC":"\xa4#,##0.00;(\xa4#,##0.00)","en-TK":"\xa4#,##0.00;(\xa4#,##0.00)","en-TO":"\xa4#,##0.00;(\xa4#,##0.00)","en-TT":"\xa4#,##0.00;(\xa4#,##0.00)","en-TV":"\xa4#,##0.00;(\xa4#,##0.00)","en-TZ":"\xa4#,##0.00;(\xa4#,##0.00)","en-UG":"\xa4#,##0.00;(\xa4#,##0.00)","en-UM":"\xa4#,##0.00;(\xa4#,##0.00)","en-VC":"\xa4#,##0.00;(\xa4#,##0.00)","en-VG":"\xa4#,##0.00;(\xa4#,##0.00)","en-VI":"\xa4#,##0.00;(\xa4#,##0.00)","en-VU":"\xa4#,##0.00;(\xa4#,##0.00)","en-WS":"\xa4#,##0.00;(\xa4#,##0.00)","en-ZA":"\xa4#,##0.00;(\xa4#,##0.00)","en-ZM":"\xa4#,##0.00;(\xa4#,##0.00)","en-ZW":"\xa4#,##0.00;(\xa4#,##0.00)",eo:"\xa4\xa0#,##0.00",es:"#,##0.00\xa0\xa4","es-419":"\xa4#,##0.00","es-AR":"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)","es-BO":"\xa4#,##0.00","es-BR":"\xa4#,##0.00","es-BZ":"\xa4#,##0.00","es-CL":"\xa4#,##0.00","es-CO":"\xa4#,##0.00","es-CR":"\xa4#,##0.00","es-CU":"\xa4#,##0.00","es-DO":"\xa4#,##0.00;(\xa4#,##0.00)","es-EA":"#,##0.00\xa0\xa4","es-EC":"\xa4#,##0.00","es-GQ":"#,##0.00\xa0\xa4","es-GT":"\xa4#,##0.00","es-HN":"\xa4#,##0.00","es-IC":"#,##0.00\xa0\xa4","es-MX":"\xa4#,##0.00","es-NI":"\xa4#,##0.00","es-PA":"\xa4#,##0.00","es-PE":"\xa4#,##0.00","es-PH":"#,##0.00\xa0\xa4","es-PR":"\xa4#,##0.00","es-PY":"\xa4#,##0.00","es-SV":"\xa4#,##0.00","es-US":"\xa4#,##0.00","es-UY":"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)","es-VE":"\xa4#,##0.00",et:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",eu:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",ewo:"#,##0.00\xa0\xa4",fa:"\u200e\xa4\xa0#,##0.00;\u200e(\xa4\xa0#,##0.00)","fa-AF":"\xa4\xa0#,##0.00;\u200e(\xa4\xa0#,##0.00)",ff:"#,##0.00\xa0\xa4","ff-Adlm":"\xa4\xa0#,##0.00","ff-Adlm-BF":"\xa4\xa0#,##0.00","ff-Adlm-CM":"\xa4\xa0#,##0.00","ff-Adlm-GH":"\xa4\xa0#,##0.00","ff-Adlm-GM":"\xa4\xa0#,##0.00","ff-Adlm-GW":"\xa4\xa0#,##0.00","ff-Adlm-LR":"\xa4\xa0#,##0.00","ff-Adlm-MR":"\xa4\xa0#,##0.00","ff-Adlm-NE":"\xa4\xa0#,##0.00","ff-Adlm-NG":"\xa4\xa0#,##0.00","ff-Adlm-SL":"\xa4\xa0#,##0.00","ff-Adlm-SN":"\xa4\xa0#,##0.00","ff-Latn":"#,##0.00\xa0\xa4","ff-Latn-BF":"#,##0.00\xa0\xa4","ff-Latn-CM":"#,##0.00\xa0\xa4","ff-Latn-GH":"#,##0.00\xa0\xa4","ff-Latn-GM":"#,##0.00\xa0\xa4","ff-Latn-GN":"#,##0.00\xa0\xa4","ff-Latn-GW":"#,##0.00\xa0\xa4","ff-Latn-LR":"#,##0.00\xa0\xa4","ff-Latn-MR":"#,##0.00\xa0\xa4","ff-Latn-NE":"#,##0.00\xa0\xa4","ff-Latn-NG":"#,##0.00\xa0\xa4","ff-Latn-SL":"#,##0.00\xa0\xa4",fi:"#,##0.00\xa0\xa4",fil:"\xa4#,##0.00;(\xa4#,##0.00)",fo:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fo-DK":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",fr:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-BE":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-BF":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-BI":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-BJ":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-BL":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-CA":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-CD":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-CF":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-CG":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-CH":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-CI":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-CM":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-DJ":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-DZ":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-GA":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-GF":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-GN":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-GP":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-GQ":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-HT":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-KM":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-LU":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-MA":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-MC":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-MF":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-MG":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-ML":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-MQ":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-MR":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-MU":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-NC":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-NE":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-PF":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-PM":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-RE":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-RW":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-SC":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-SN":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-SY":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-TD":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-TG":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-TN":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-VU":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-WF":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-YT":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",fur:"\xa4\xa0#,##0.00",fy:"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)",ga:"\xa4#,##0.00;(\xa4#,##0.00)","ga-GB":"\xa4#,##0.00;(\xa4#,##0.00)",gd:"\xa4#,##0.00;(\xa4#,##0.00)",gl:"#,##0.00\xa0\xa4",gsw:"#,##0.00\xa0\xa4","gsw-FR":"#,##0.00\xa0\xa4","gsw-LI":"#,##0.00\xa0\xa4",gu:"\xa4#,##,##0.00;(\xa4#,##,##0.00)",guz:"\xa4#,##0.00;(\xa4#,##0.00)",gv:"\xa4#,##0.00",ha:"\xa4\xa0#,##0.00","ha-GH":"\xa4\xa0#,##0.00","ha-NE":"\xa4\xa0#,##0.00",haw:"\xa4#,##0.00;(\xa4#,##0.00)",he:"#,##0.00\xa0\xa4",hi:"\xa4#,##,##0.00","hi-Latn":"\xa4#,##,##0.00",hr:"#,##0.00\xa0\xa4","hr-BA":"#,##0.00\xa0\xa4",hsb:"#,##0.00\xa0\xa4",hu:"#,##0.00\xa0\xa4",hy:"#,##0.00\xa0\xa4",ia:"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)",id:"\xa4#,##0.00",ig:"\xa4#,##0.00;(\xa4#,##0.00)",ii:"\xa4\xa0#,##0.00",is:"#,##0.00\xa0\xa4",it:"#,##0.00\xa0\xa4","it-CH":"#,##0.00\xa0\xa4","it-SM":"#,##0.00\xa0\xa4","it-VA":"#,##0.00\xa0\xa4",ja:"\xa4#,##0.00;(\xa4#,##0.00)",jgo:"\xa4\xa0#,##0.00",jmc:"\xa4#,##0.00",jv:"\xa4\xa0#,##0.00",ka:"#,##0.00\xa0\xa4",kab:"#,##0.00\xa4",kam:"\xa4#,##0.00;(\xa4#,##0.00)",kde:"\xa4#,##0.00;(\xa4#,##0.00)",kea:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",kgp:"\xa4\xa0#,##0.00",khq:"#,##0.00\xa4",ki:"\xa4#,##0.00;(\xa4#,##0.00)",kk:"#,##0.00\xa0\xa4",kkj:"\xa4\xa0#,##0.00",kl:"\xa4#,##0.00;\xa4-#,##0.00",kln:"\xa4#,##0.00;(\xa4#,##0.00)",km:"#,##0.00\xa4;(#,##0.00\xa4)",kn:"\xa4#,##0.00;(\xa4#,##0.00)",ko:"\xa4#,##0.00;(\xa4#,##0.00)","ko-KP":"\xa4#,##0.00;(\xa4#,##0.00)",kok:"\xa4#,##0.00;(\xa4#,##0.00)",ks:"\xa4#,##0.00","ks-Arab":"\xa4#,##0.00","ks-Deva":"\xa4\xa0#,##0.00",ksb:"#,##0.00\xa4",ksf:"#,##0.00\xa0\xa4",ksh:"#,##0.00\xa0\xa4",ku:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",kw:"\xa4#,##0.00",ky:"#,##0.00\xa0\xa4",lag:"\xa4\xa0#,##0.00",lb:"#,##0.00\xa0\xa4",lg:"#,##0.00\xa4",lkt:"\xa4\xa0#,##0.00",ln:"#,##0.00\xa0\xa4","ln-AO":"#,##0.00\xa0\xa4","ln-CF":"#,##0.00\xa0\xa4","ln-CG":"#,##0.00\xa0\xa4",lo:"\xa4#,##0.00;\xa4-#,##0.00",lrc:"\xa4\xa0#,##0.00","lrc-IQ":"\xa4\xa0#,##0.00",lt:"#,##0.00\xa0\xa4",lu:"#,##0.00\xa4",luo:"#,##0.00\xa4",luy:"\xa4#,##0.00;\xa4-\xa0#,##0.00",lv:"#,##0.00\xa0\xa4",mai:"\xa4\xa0#,##0.00",mas:"\xa4#,##0.00;(\xa4#,##0.00)","mas-TZ":"\xa4#,##0.00;(\xa4#,##0.00)",mer:"\xa4#,##0.00;(\xa4#,##0.00)",mfe:"\xa4\xa0#,##0.00",mg:"\xa4#,##0.00",mgh:"\xa4\xa0#,##0.00",mgo:"\xa4\xa0#,##0.00",mi:"\xa4\xa0#,##0.00",mk:"#,##0.00\xa0\xa4",ml:"\xa4#,##0.00;(\xa4#,##0.00)",mn:"\xa4\xa0#,##0.00",mni:"\xa4\xa0#,##0.00","mni-Beng":"\xa4\xa0#,##0.00",mr:"\xa4#,##0.00;(\xa4#,##0.00)",ms:"\xa4#,##0.00;(\xa4#,##0.00)","ms-BN":"\xa4#,##0.00;(\xa4#,##0.00)","ms-ID":"\xa4#,##0.00","ms-SG":"\xa4#,##0.00;(\xa4#,##0.00)",mt:"\xa4#,##0.00",mua:"\xa4#,##0.00;(\xa4#,##0.00)",my:"\xa4\xa0#,##0.00",mzn:"\xa4\xa0#,##0.00",naq:"\xa4#,##0.00",nb:"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)","nb-SJ":"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)",nd:"\xa4#,##0.00;(\xa4#,##0.00)",nds:"\xa4\xa0#,##0.00","nds-NL":"\xa4\xa0#,##0.00",ne:"\xa4\xa0#,##,##0.00","ne-IN":"\xa4\xa0#,##,##0.00",nl:"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)","nl-AW":"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)","nl-BE":"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)","nl-BQ":"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)","nl-CW":"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)","nl-SR":"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)","nl-SX":"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)",nmg:"#,##0.00\xa0\xa4",nn:"#,##0.00\xa0\xa4",nnh:"\xa4\xa0#,##0.00",no:"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)",nus:"\xa4#,##0.00;(\xa4#,##0.00)",nyn:"\xa4#,##0.00",om:"\xa4#,##0.00","om-KE":"\xa4#,##0.00",or:"\xa4#,##0.00;(\xa4#,##0.00)",os:"\xa4\xa0#,##0.00","os-RU":"\xa4\xa0#,##0.00",pa:"\xa4\xa0#,##0.00","pa-Arab":"\xa4\xa0#,##0.00","pa-Guru":"\xa4\xa0#,##0.00",pcm:"\xa4#,##0.00",pl:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",ps:"\xa4#,##0.00;(\xa4#,##0.00)","ps-PK":"\xa4#,##0.00;(\xa4#,##0.00)",pt:"\xa4\xa0#,##0.00","pt-AO":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","pt-CH":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","pt-CV":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","pt-GQ":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","pt-GW":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","pt-LU":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","pt-MO":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","pt-MZ":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","pt-PT":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","pt-ST":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","pt-TL":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",qu:"\xa4\xa0#,##0.00","qu-BO":"\xa4\xa0#,##0.00","qu-EC":"\xa4\xa0#,##0.00",rm:"#,##0.00\xa0\xa4",rn:"#,##0.00\xa4",ro:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","ro-MD":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",rof:"\xa4#,##0.00",ru:"#,##0.00\xa0\xa4","ru-BY":"#,##0.00\xa0\xa4","ru-KG":"#,##0.00\xa0\xa4","ru-KZ":"#,##0.00\xa0\xa4","ru-MD":"#,##0.00\xa0\xa4","ru-UA":"#,##0.00\xa0\xa4",rw:"\xa4\xa0#,##0.00",rwk:"#,##0.00\xa4",sa:"\xa4\xa0#,##0.00",sah:"#,##0.00\xa0\xa4",saq:"\xa4#,##0.00;(\xa4#,##0.00)",sat:"\xa4\xa0#,##0.00","sat-Olck":"\xa4\xa0#,##0.00",sbp:"#,##0.00\xa4",sc:"#,##0.00\xa0\xa4",sd:"\xa4\xa0#,##0.00","sd-Arab":"\xa4\xa0#,##0.00","sd-Deva":"\xa4\xa0#,##0.00",se:"#,##0.00\xa0\xa4","se-FI":"#,##0.00\xa0\xa4","se-SE":"#,##0.00\xa0\xa4",seh:"#,##0.00\xa4",ses:"#,##0.00\xa4",sg:"\xa4#,##0.00;\xa4-#,##0.00",shi:"#,##0.00\xa4","shi-Latn":"#,##0.00\xa4","shi-Tfng":"#,##0.00\xa4",si:"\xa4#,##0.00;(\xa4#,##0.00)",sk:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",sl:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",smn:"#,##0.00\xa0\xa4",sn:"\xa4#,##0.00;(\xa4#,##0.00)",so:"\xa4#,##0.00;(\xa4#,##0.00)","so-DJ":"\xa4#,##0.00;(\xa4#,##0.00)","so-ET":"\xa4#,##0.00;(\xa4#,##0.00)","so-KE":"\xa4#,##0.00;(\xa4#,##0.00)",sq:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","sq-MK":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","sq-XK":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",sr:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","sr-Cyrl":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","sr-Cyrl-BA":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","sr-Cyrl-ME":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","sr-Cyrl-XK":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","sr-Latn":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","sr-Latn-BA":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","sr-Latn-ME":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","sr-Latn-XK":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",su:"\xa4#,##0.00","su-Latn":"\xa4#,##0.00",sv:"#,##0.00\xa0\xa4","sv-AX":"#,##0.00\xa0\xa4","sv-FI":"#,##0.00\xa0\xa4",sw:"\xa4\xa0#,##0.00","sw-CD":"\xa4\xa0#,##0.00","sw-KE":"\xa4\xa0#,##0.00","sw-UG":"\xa4\xa0#,##0.00",ta:"\xa4#,##0.00;(\xa4#,##0.00)","ta-LK":"\xa4#,##0.00;(\xa4#,##0.00)","ta-MY":"\xa4#,##0.00;(\xa4#,##0.00)","ta-SG":"\xa4#,##0.00;(\xa4#,##0.00)",te:"\xa4#,##0.00;(\xa4#,##0.00)",teo:"\xa4#,##0.00;(\xa4#,##0.00)","teo-KE":"\xa4#,##0.00;(\xa4#,##0.00)",tg:"#,##0.00\xa0\xa4",th:"\xa4#,##0.00;(\xa4#,##0.00)",ti:"\xa4#,##0.00","ti-ER":"\xa4#,##0.00",tk:"#,##0.00\xa0\xa4",to:"\xa4\xa0#,##0.00",tr:"\xa4#,##0.00;(\xa4#,##0.00)","tr-CY":"\xa4#,##0.00;(\xa4#,##0.00)",tt:"#,##0.00\xa0\xa4",twq:"#,##0.00\xa4",tzm:"#,##0.00\xa0\xa4",ug:"\xa4#,##0.00;(\xa4#,##0.00)",uk:"#,##0.00\xa0\xa4",und:"\xa4\xa0#,##0.00",ur:"\xa4#,##0.00;(\xa4#,##0.00)","ur-IN":"\xa4#,##0.00;(\xa4#,##0.00)",uz:"#,##0.00\xa0\xa4","uz-Arab":"\xa4\xa0#,##0.00","uz-Cyrl":"#,##0.00\xa0\xa4","uz-Latn":"#,##0.00\xa0\xa4",vai:"\xa4#,##0.00;(\xa4#,##0.00)","vai-Latn":"\xa4#,##0.00;(\xa4#,##0.00)","vai-Vaii":"\xa4#,##0.00;(\xa4#,##0.00)",vi:"#,##0.00\xa0\xa4",vun:"\xa4#,##0.00",wae:"\xa4\xa0#,##0.00",wo:"\xa4\xa0#,##0.00",xh:"\xa4#,##0.00",xog:"#,##0.00\xa0\xa4",yav:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",yi:"\xa4\xa0#,##0.00",yo:"\xa4#,##0.00;(\xa4#,##0.00)","yo-BJ":"\xa4#,##0.00;(\xa4#,##0.00)",yrl:"\xa4\xa0#,##0.00","yrl-CO":"\xa4\xa0#,##0.00","yrl-VE":"\xa4\xa0#,##0.00",yue:"\xa4#,##0.00;(\xa4#,##0.00)","yue-Hans":"\xa4#,##0.00;(\xa4#,##0.00)","yue-Hant":"\xa4#,##0.00;(\xa4#,##0.00)",zgh:"#,##0.00\xa4",zh:"\xa4#,##0.00;(\xa4#,##0.00)","zh-Hans":"\xa4#,##0.00;(\xa4#,##0.00)","zh-Hans-HK":"\xa4#,##0.00;(\xa4#,##0.00)","zh-Hans-MO":"\xa4#,##0.00;(\xa4#,##0.00)","zh-Hans-SG":"\xa4#,##0.00;(\xa4#,##0.00)","zh-Hant":"\xa4#,##0.00;(\xa4#,##0.00)","zh-Hant-HK":"\xa4#,##0.00;(\xa4#,##0.00)","zh-Hant-MO":"\xa4#,##0.00;(\xa4#,##0.00)",zu:"\xa4#,##0.00;(\xa4#,##0.00)"},e.exports=t.default,e.exports.default=t.default},35608:function(e,t){t.enCldr=void 0;t.enCldr={main:{en:{identity:{version:{_cldrVersion:"36"}},dates:{calendars:{gregorian:{months:{format:{abbreviated:{1:"Jan",2:"Feb",3:"Mar",4:"Apr",5:"May",6:"Jun",7:"Jul",8:"Aug",9:"Sep",10:"Oct",11:"Nov",12:"Dec"},narrow:{1:"J",2:"F",3:"M",4:"A",5:"M",6:"J",7:"J",8:"A",9:"S",10:"O",11:"N",12:"D"},wide:{1:"January",2:"February",3:"March",4:"April",5:"May",6:"June",7:"July",8:"August",9:"September",10:"October",11:"November",12:"December"}},"stand-alone":{abbreviated:{1:"Jan",2:"Feb",3:"Mar",4:"Apr",5:"May",6:"Jun",7:"Jul",8:"Aug",9:"Sep",10:"Oct",11:"Nov",12:"Dec"},narrow:{1:"J",2:"F",3:"M",4:"A",5:"M",6:"J",7:"J",8:"A",9:"S",10:"O",11:"N",12:"D"},wide:{1:"January",2:"February",3:"March",4:"April",5:"May",6:"June",7:"July",8:"August",9:"September",10:"October",11:"November",12:"December"}}},days:{format:{abbreviated:{sun:"Sun",mon:"Mon",tue:"Tue",wed:"Wed",thu:"Thu",fri:"Fri",sat:"Sat"},narrow:{sun:"S",mon:"M",tue:"T",wed:"W",thu:"T",fri:"F",sat:"S"},short:{sun:"Su",mon:"Mo",tue:"Tu",wed:"We",thu:"Th",fri:"Fr",sat:"Sa"},wide:{sun:"Sunday",mon:"Monday",tue:"Tuesday",wed:"Wednesday",thu:"Thursday",fri:"Friday",sat:"Saturday"}},"stand-alone":{abbreviated:{sun:"Sun",mon:"Mon",tue:"Tue",wed:"Wed",thu:"Thu",fri:"Fri",sat:"Sat"},narrow:{sun:"S",mon:"M",tue:"T",wed:"W",thu:"T",fri:"F",sat:"S"},short:{sun:"Su",mon:"Mo",tue:"Tu",wed:"We",thu:"Th",fri:"Fr",sat:"Sa"},wide:{sun:"Sunday",mon:"Monday",tue:"Tuesday",wed:"Wednesday",thu:"Thursday",fri:"Friday",sat:"Saturday"}}},quarters:{format:{abbreviated:{1:"Q1",2:"Q2",3:"Q3",4:"Q4"},narrow:{1:"1",2:"2",3:"3",4:"4"},wide:{1:"1st quarter",2:"2nd quarter",3:"3rd quarter",4:"4th quarter"}},"stand-alone":{abbreviated:{1:"Q1",2:"Q2",3:"Q3",4:"Q4"},narrow:{1:"1",2:"2",3:"3",4:"4"},wide:{1:"1st quarter",2:"2nd quarter",3:"3rd quarter",4:"4th quarter"}}},dayPeriods:{format:{abbreviated:{midnight:"midnight",am:"AM","am-alt-variant":"am",noon:"noon",pm:"PM","pm-alt-variant":"pm",morning1:"in the morning",afternoon1:"in the afternoon",evening1:"in the evening",night1:"at night"},narrow:{midnight:"mi",am:"a","am-alt-variant":"am",noon:"n",pm:"p","pm-alt-variant":"pm",morning1:"in the morning",afternoon1:"in the afternoon",evening1:"in the evening",night1:"at night"},wide:{midnight:"midnight",am:"AM","am-alt-variant":"am",noon:"noon",pm:"PM","pm-alt-variant":"pm",morning1:"in the morning",afternoon1:"in the afternoon",evening1:"in the evening",night1:"at night"}},"stand-alone":{abbreviated:{midnight:"midnight",am:"AM","am-alt-variant":"am",noon:"noon",pm:"PM","pm-alt-variant":"pm",morning1:"morning",afternoon1:"afternoon",evening1:"evening",night1:"night"},narrow:{midnight:"midnight",am:"AM","am-alt-variant":"am",noon:"noon",pm:"PM","pm-alt-variant":"pm",morning1:"morning",afternoon1:"afternoon",evening1:"evening",night1:"night"},wide:{midnight:"midnight",am:"AM","am-alt-variant":"am",noon:"noon",pm:"PM","pm-alt-variant":"pm",morning1:"morning",afternoon1:"afternoon",evening1:"evening",night1:"night"}}},eras:{eraNames:{0:"Before Christ",1:"Anno Domini","0-alt-variant":"Before Common Era","1-alt-variant":"Common Era"},eraAbbr:{0:"BC",1:"AD","0-alt-variant":"BCE","1-alt-variant":"CE"},eraNarrow:{0:"B",1:"A","0-alt-variant":"BCE","1-alt-variant":"CE"}},dateFormats:{full:"EEEE, MMMM d, y",long:"MMMM d, y",medium:"MMM d, y",short:"M/d/yy"},timeFormats:{full:"h:mm:ss a zzzz",long:"h:mm:ss a z",medium:"h:mm:ss a",short:"h:mm a"},dateTimeFormats:{full:"{1} 'at' {0}",long:"{1} 'at' {0}",medium:"{1}, {0}",short:"{1}, {0}",availableFormats:{Bh:"h B",Bhm:"h:mm B",Bhms:"h:mm:ss B",d:"d",E:"ccc",EBhm:"E h:mm B",EBhms:"E h:mm:ss B",Ed:"d E",Ehm:"E h:mm a",EHm:"E HH:mm",Ehms:"E h:mm:ss a",EHms:"E HH:mm:ss",Gy:"y G",GyMMM:"MMM y G",GyMMMd:"MMM d, y G",GyMMMEd:"E, MMM d, y G",h:"h a",H:"HH",hm:"h:mm a",Hm:"HH:mm",hms:"h:mm:ss a",Hms:"HH:mm:ss",hmsv:"h:mm:ss a v",Hmsv:"HH:mm:ss v",hmv:"h:mm a v",Hmv:"HH:mm v",M:"L",Md:"M/d",MEd:"E, M/d",MMM:"LLL",MMMd:"MMM d",MMMEd:"E, MMM d",MMMMd:"MMMM d","MMMMW-count-one":"'week' W 'of' MMMM","MMMMW-count-other":"'week' W 'of' MMMM",ms:"mm:ss",y:"y",yM:"M/y",yMd:"M/d/y",yMEd:"E, M/d/y",yMMM:"MMM y",yMMMd:"MMM d, y",yMMMEd:"E, MMM d, y",yMMMM:"MMMM y",yQQQ:"QQQ y",yQQQQ:"QQQQ y","yw-count-one":"'week' w 'of' Y","yw-count-other":"'week' w 'of' Y"}}}}},numbers:{defaultNumberingSystem:"latn",otherNumberingSystems:{native:"latn"},minimumGroupingDigits:"1","symbols-numberSystem-latn":{decimal:".",group:",",list:";",percentSign:"%",plusSign:"+",minusSign:"-",exponential:"E",superscriptingExponent:"\xd7",perMille:"\u2030",infinity:"\u221e",nan:"NaN",timeSeparator:":"},"decimalFormats-numberSystem-latn":{standard:"#,##0.###"},"scientificFormats-numberSystem-latn":{standard:"#E0"},"percentFormats-numberSystem-latn":{standard:"#,##0%"},"currencyFormats-numberSystem-latn":{currencySpacing:{beforeCurrency:{currencyMatch:"[:^S:]",surroundingMatch:"[:digit:]",insertBetween:"\xa0"},afterCurrency:{currencyMatch:"[:^S:]",surroundingMatch:"[:digit:]",insertBetween:"\xa0"}},standard:"\xa4#,##0.00",accounting:"\xa4#,##0.00;(\xa4#,##0.00)"},currencies:{ADP:{symbol:"ADP"},AED:{symbol:"AED"},AFA:{symbol:"AFA"},AFN:{symbol:"AFN"},ALK:{symbol:"ALK"},ALL:{symbol:"ALL"},AMD:{symbol:"AMD"},ANG:{symbol:"ANG"},AOA:{symbol:"AOA","symbol-alt-narrow":"Kz"},AOK:{symbol:"AOK"},AON:{symbol:"AON"},AOR:{symbol:"AOR"},ARA:{symbol:"ARA"},ARL:{symbol:"ARL"},ARM:{symbol:"ARM"},ARP:{symbol:"ARP"},ARS:{symbol:"ARS","symbol-alt-narrow":"$"},ATS:{symbol:"ATS"},AUD:{symbol:"A$","symbol-alt-narrow":"$"},AWG:{symbol:"AWG"},AZM:{symbol:"AZM"},AZN:{symbol:"AZN"},BAD:{symbol:"BAD"},BAM:{symbol:"BAM","symbol-alt-narrow":"KM"},BAN:{symbol:"BAN"},BBD:{symbol:"BBD","symbol-alt-narrow":"$"},BDT:{symbol:"BDT","symbol-alt-narrow":"\u09f3"},BEC:{symbol:"BEC"},BEF:{symbol:"BEF"},BEL:{symbol:"BEL"},BGL:{symbol:"BGL"},BGM:{symbol:"BGM"},BGN:{symbol:"BGN"},BGO:{symbol:"BGO"},BHD:{symbol:"BHD"},BIF:{symbol:"BIF"},BMD:{symbol:"BMD","symbol-alt-narrow":"$"},BND:{symbol:"BND","symbol-alt-narrow":"$"},BOB:{symbol:"BOB","symbol-alt-narrow":"Bs"},BOL:{symbol:"BOL"},BOP:{symbol:"BOP"},BOV:{symbol:"BOV"},BRB:{symbol:"BRB"},BRC:{symbol:"BRC"},BRE:{symbol:"BRE"},BRL:{symbol:"R$","symbol-alt-narrow":"R$"},BRN:{symbol:"BRN"},BRR:{symbol:"BRR"},BRZ:{symbol:"BRZ"},BSD:{symbol:"BSD","symbol-alt-narrow":"$"},BTN:{symbol:"BTN"},BUK:{symbol:"BUK"},BWP:{symbol:"BWP","symbol-alt-narrow":"P"},BYB:{symbol:"BYB"},BYN:{symbol:"BYN","symbol-alt-narrow":"\u0440."},BYR:{symbol:"BYR"},BZD:{symbol:"BZD","symbol-alt-narrow":"$"},CAD:{symbol:"CA$","symbol-alt-narrow":"$"},CDF:{symbol:"CDF"},CHE:{symbol:"CHE"},CHF:{symbol:"CHF"},CHW:{symbol:"CHW"},CLE:{symbol:"CLE"},CLF:{symbol:"CLF"},CLP:{symbol:"CLP","symbol-alt-narrow":"$"},CNH:{symbol:"CNH"},CNX:{symbol:"CNX"},CNY:{symbol:"CN\xa5","symbol-alt-narrow":"\xa5"},COP:{symbol:"COP","symbol-alt-narrow":"$"},COU:{symbol:"COU"},CRC:{symbol:"CRC","symbol-alt-narrow":"\u20a1"},CSD:{symbol:"CSD"},CSK:{symbol:"CSK"},CUC:{symbol:"CUC","symbol-alt-narrow":"$"},CUP:{symbol:"CUP","symbol-alt-narrow":"$"},CVE:{symbol:"CVE"},CYP:{symbol:"CYP"},CZK:{symbol:"CZK","symbol-alt-narrow":"K\u010d"},DDM:{symbol:"DDM"},DEM:{symbol:"DEM"},DJF:{symbol:"DJF"},DKK:{symbol:"DKK","symbol-alt-narrow":"kr"},DOP:{symbol:"DOP","symbol-alt-narrow":"$"},DZD:{symbol:"DZD"},ECS:{symbol:"ECS"},ECV:{symbol:"ECV"},EEK:{symbol:"EEK"},EGP:{symbol:"EGP","symbol-alt-narrow":"E\xa3"},ERN:{symbol:"ERN"},ESA:{symbol:"ESA"},ESB:{symbol:"ESB"},ESP:{symbol:"ESP","symbol-alt-narrow":"\u20a7"},ETB:{symbol:"ETB"},EUR:{symbol:"\u20ac","symbol-alt-narrow":"\u20ac"},FIM:{symbol:"FIM"},FJD:{symbol:"FJD","symbol-alt-narrow":"$"},FKP:{symbol:"FKP","symbol-alt-narrow":"\xa3"},FRF:{symbol:"FRF"},GBP:{symbol:"\xa3","symbol-alt-narrow":"\xa3"},GEK:{symbol:"GEK"},GEL:{symbol:"GEL","symbol-alt-narrow":"\u20be"},GHC:{symbol:"GHC"},GHS:{symbol:"GHS"},GIP:{symbol:"GIP","symbol-alt-narrow":"\xa3"},GMD:{symbol:"GMD"},GNF:{symbol:"GNF","symbol-alt-narrow":"FG"},GNS:{symbol:"GNS"},GQE:{symbol:"GQE"},GRD:{symbol:"GRD"},GTQ:{symbol:"GTQ","symbol-alt-narrow":"Q"},GWE:{symbol:"GWE"},GWP:{symbol:"GWP"},GYD:{symbol:"GYD","symbol-alt-narrow":"$"},HKD:{symbol:"HK$","symbol-alt-narrow":"$"},HNL:{symbol:"HNL","symbol-alt-narrow":"L"},HRD:{symbol:"HRD"},HRK:{symbol:"HRK","symbol-alt-narrow":"kn"},HTG:{symbol:"HTG"},HUF:{symbol:"HUF","symbol-alt-narrow":"Ft"},IDR:{symbol:"IDR","symbol-alt-narrow":"Rp"},IEP:{symbol:"IEP"},ILP:{symbol:"ILP"},ILR:{symbol:"ILR"},ILS:{symbol:"\u20aa","symbol-alt-narrow":"\u20aa"},INR:{symbol:"\u20b9","symbol-alt-narrow":"\u20b9"},IQD:{symbol:"IQD"},IRR:{symbol:"IRR"},ISJ:{symbol:"ISJ"},ISK:{symbol:"ISK","symbol-alt-narrow":"kr"},ITL:{symbol:"ITL"},JMD:{symbol:"JMD","symbol-alt-narrow":"$"},JOD:{symbol:"JOD"},JPY:{symbol:"\xa5","symbol-alt-narrow":"\xa5"},KES:{symbol:"KES"},KGS:{symbol:"KGS"},KHR:{symbol:"KHR","symbol-alt-narrow":"\u17db"},KMF:{symbol:"KMF","symbol-alt-narrow":"CF"},KPW:{symbol:"KPW","symbol-alt-narrow":"\u20a9"},KRH:{symbol:"KRH"},KRO:{symbol:"KRO"},KRW:{symbol:"\u20a9","symbol-alt-narrow":"\u20a9"},KWD:{symbol:"KWD"},KYD:{symbol:"KYD","symbol-alt-narrow":"$"},KZT:{symbol:"KZT","symbol-alt-narrow":"\u20b8"},LAK:{symbol:"LAK","symbol-alt-narrow":"\u20ad"},LBP:{symbol:"LBP","symbol-alt-narrow":"L\xa3"},LKR:{symbol:"LKR","symbol-alt-narrow":"Rs"},LRD:{symbol:"LRD","symbol-alt-narrow":"$"},LSL:{symbol:"LSL"},LTL:{symbol:"LTL","symbol-alt-narrow":"Lt"},LTT:{symbol:"LTT"},LUC:{symbol:"LUC"},LUF:{symbol:"LUF"},LUL:{symbol:"LUL"},LVL:{symbol:"LVL","symbol-alt-narrow":"Ls"},LVR:{symbol:"LVR"},LYD:{symbol:"LYD"},MAD:{symbol:"MAD"},MAF:{symbol:"MAF"},MCF:{symbol:"MCF"},MDC:{symbol:"MDC"},MDL:{symbol:"MDL"},MGA:{symbol:"MGA","symbol-alt-narrow":"Ar"},MGF:{symbol:"MGF"},MKD:{symbol:"MKD"},MKN:{symbol:"MKN"},MLF:{symbol:"MLF"},MMK:{symbol:"MMK","symbol-alt-narrow":"K"},MNT:{symbol:"MNT","symbol-alt-narrow":"\u20ae"},MOP:{symbol:"MOP"},MRO:{symbol:"MRO"},MRU:{symbol:"MRU"},MTL:{symbol:"MTL"},MTP:{symbol:"MTP"},MUR:{symbol:"MUR","symbol-alt-narrow":"Rs"},MVP:{symbol:"MVP"},MVR:{symbol:"MVR"},MWK:{symbol:"MWK"},MXN:{symbol:"MX$","symbol-alt-narrow":"$"},MXP:{symbol:"MXP"},MXV:{symbol:"MXV"},MYR:{symbol:"MYR","symbol-alt-narrow":"RM"},MZE:{symbol:"MZE"},MZM:{symbol:"MZM"},MZN:{symbol:"MZN"},NAD:{symbol:"NAD","symbol-alt-narrow":"$"},NGN:{symbol:"NGN","symbol-alt-narrow":"\u20a6"},NIC:{symbol:"NIC"},NIO:{symbol:"NIO","symbol-alt-narrow":"C$"},NLG:{symbol:"NLG"},NOK:{symbol:"NOK","symbol-alt-narrow":"kr"},NPR:{symbol:"NPR","symbol-alt-narrow":"Rs"},NZD:{symbol:"NZ$","symbol-alt-narrow":"$"},OMR:{symbol:"OMR"},PAB:{symbol:"PAB"},PEI:{symbol:"PEI"},PEN:{symbol:"PEN"},PES:{symbol:"PES"},PGK:{symbol:"PGK"},PHP:{symbol:"PHP","symbol-alt-narrow":"\u20b1"},PKR:{symbol:"PKR","symbol-alt-narrow":"Rs"},PLN:{symbol:"PLN","symbol-alt-narrow":"z\u0142"},PLZ:{symbol:"PLZ"},PTE:{symbol:"PTE"},PYG:{symbol:"PYG","symbol-alt-narrow":"\u20b2"},QAR:{symbol:"QAR"},RHD:{symbol:"RHD"},ROL:{symbol:"ROL"},RON:{symbol:"RON","symbol-alt-narrow":"lei"},RSD:{symbol:"RSD"},RUB:{symbol:"RUB","symbol-alt-narrow":"\u20bd"},RUR:{symbol:"RUR","symbol-alt-narrow":"\u0440."},RWF:{symbol:"RWF","symbol-alt-narrow":"RF"},SAR:{symbol:"SAR"},SBD:{symbol:"SBD","symbol-alt-narrow":"$"},SCR:{symbol:"SCR"},SDD:{symbol:"SDD"},SDG:{symbol:"SDG"},SDP:{symbol:"SDP"},SEK:{symbol:"SEK","symbol-alt-narrow":"kr"},SGD:{symbol:"SGD","symbol-alt-narrow":"$"},SHP:{symbol:"SHP","symbol-alt-narrow":"\xa3"},SIT:{symbol:"SIT"},SKK:{symbol:"SKK"},SLL:{symbol:"SLL"},SOS:{symbol:"SOS"},SRD:{symbol:"SRD","symbol-alt-narrow":"$"},SRG:{symbol:"SRG"},SSP:{symbol:"SSP","symbol-alt-narrow":"\xa3"},STD:{symbol:"STD"},STN:{symbol:"STN","symbol-alt-narrow":"Db"},SUR:{symbol:"SUR"},SVC:{symbol:"SVC"},SYP:{symbol:"SYP","symbol-alt-narrow":"\xa3"},SZL:{symbol:"SZL"},THB:{symbol:"THB","symbol-alt-narrow":"\u0e3f"},TJR:{symbol:"TJR"},TJS:{symbol:"TJS"},TMM:{symbol:"TMM"},TMT:{symbol:"TMT"},TND:{symbol:"TND"},TOP:{symbol:"TOP","symbol-alt-narrow":"T$"},TPE:{symbol:"TPE"},TRL:{symbol:"TRL"},TRY:{symbol:"TRY","symbol-alt-narrow":"\u20ba"},TTD:{symbol:"TTD","symbol-alt-narrow":"$"},TWD:{symbol:"NT$","symbol-alt-narrow":"$"},TZS:{symbol:"TZS"},UAH:{symbol:"UAH","symbol-alt-narrow":"\u20b4"},UAK:{symbol:"UAK"},UGS:{symbol:"UGS"},UGX:{symbol:"UGX"},USD:{symbol:"$","symbol-alt-narrow":"$"},USN:{symbol:"USN"},USS:{symbol:"USS"},UYI:{symbol:"UYI"},UYP:{symbol:"UYP"},UYU:{symbol:"UYU","symbol-alt-narrow":"$"},UYW:{symbol:"UYW"},UZS:{symbol:"UZS"},VEB:{symbol:"VEB"},VEF:{symbol:"VEF","symbol-alt-narrow":"Bs"},VES:{symbol:"VES"},VND:{symbol:"\u20ab","symbol-alt-narrow":"\u20ab"},VNN:{symbol:"VNN"},VUV:{symbol:"VUV"},WST:{symbol:"WST"},XAF:{symbol:"FCFA"},XAG:{symbol:"XAG"},XAU:{symbol:"XAU"},XBA:{symbol:"XBA"},XBB:{symbol:"XBB"},XBC:{symbol:"XBC"},XBD:{symbol:"XBD"},XCD:{symbol:"EC$","symbol-alt-narrow":"$"},XDR:{symbol:"XDR"},XEU:{symbol:"XEU"},XFO:{symbol:"XFO"},XFU:{symbol:"XFU"},XOF:{symbol:"CFA"},XPD:{symbol:"XPD"},XPF:{symbol:"CFPF"},XPT:{symbol:"XPT"},XRE:{symbol:"XRE"},XSU:{symbol:"XSU"},XTS:{symbol:"XTS"},XUA:{symbol:"XUA"},XXX:{symbol:"\xa4"},YDD:{symbol:"YDD"},YER:{symbol:"YER"},YUD:{symbol:"YUD"},YUM:{symbol:"YUM"},YUN:{symbol:"YUN"},YUR:{symbol:"YUR"},ZAL:{symbol:"ZAL"},ZAR:{symbol:"ZAR","symbol-alt-narrow":"R"},ZMK:{symbol:"ZMK"},ZMW:{symbol:"ZMW","symbol-alt-narrow":"ZK"},ZRN:{symbol:"ZRN"},ZRZ:{symbol:"ZRZ"},ZWD:{symbol:"ZWD"},ZWL:{symbol:"ZWL"},ZWR:{symbol:"ZWR"}}}}}}},92286:function(e,t){t.default=void 0;t.default={"af-NA":1,agq:1,ak:1,ar:6,"ar-EH":1,"ar-ER":1,"ar-KM":1,"ar-LB":1,"ar-MA":1,"ar-MR":1,"ar-PS":1,"ar-SO":1,"ar-SS":1,"ar-TD":1,"ar-TN":1,asa:1,ast:1,az:1,"az-Cyrl":1,bas:1,be:1,bem:1,bez:1,bg:1,bm:1,br:1,bs:1,"bs-Cyrl":1,ca:1,ce:1,cgg:1,ckb:6,cs:1,cy:1,da:1,de:1,dje:1,dsb:1,dua:1,dyo:1,ee:1,el:1,"en-001":1,"en-AE":6,"en-BI":1,"en-MP":1,"en-MV":5,"en-SD":6,eo:1,es:1,et:1,eu:1,ewo:1,fa:6,ff:1,"ff-Adlm":1,fi:1,fo:1,fr:1,"fr-DJ":6,"fr-DZ":6,"fr-SY":6,fur:1,fy:1,ga:1,gd:1,gl:1,gsw:1,gv:1,ha:1,hr:1,hsb:1,hu:1,hy:1,ia:1,ig:1,is:1,it:1,jgo:1,jmc:1,ka:1,kab:6,kde:1,kea:1,khq:1,kk:1,kkj:1,kl:1,"ko-KP":1,ksb:1,ksf:1,ksh:1,ku:1,kw:1,ky:1,lag:1,lb:1,lg:1,ln:1,lrc:6,lt:1,lu:1,lv:1,"mas-TZ":1,mfe:1,mg:1,mgo:1,mi:1,mk:1,mn:1,ms:1,mua:1,mzn:6,naq:1,nds:1,nl:1,nmg:1,nnh:1,no:1,nus:1,nyn:1,os:1,pcm:1,pl:1,ps:6,"pt-AO":1,"pt-CH":1,"pt-CV":1,"pt-GQ":1,"pt-GW":1,"pt-LU":1,"pt-ST":1,"pt-TL":1,"qu-BO":1,"qu-EC":1,rm:1,rn:1,ro:1,rof:1,ru:1,rw:1,rwk:1,sah:1,sbp:1,sc:1,se:1,ses:1,sg:1,shi:1,"shi-Latn":1,si:1,sk:1,sl:1,smn:1,so:1,"so-DJ":6,sq:1,sr:1,"sr-Latn":1,sv:1,sw:1,"ta-LK":1,"ta-MY":1,teo:1,tg:1,"ti-ER":1,tk:1,to:1,tr:1,tt:1,twq:1,tzm:1,uk:1,uz:1,"uz-Arab":6,"uz-Cyrl":1,vai:1,"vai-Latn":1,vi:1,vun:1,wae:1,wo:1,xog:1,yav:1,yi:1,yo:1,zgh:1},e.exports=t.default,e.exports.default=t.default},73806:function(e,t){t.default=void 0;t.default={"en-150":"en-001","en-AG":"en-001","en-AI":"en-001","en-AU":"en-001","en-BB":"en-001","en-BM":"en-001","en-BS":"en-001","en-BW":"en-001","en-BZ":"en-001","en-CC":"en-001","en-CK":"en-001","en-CM":"en-001","en-CX":"en-001","en-CY":"en-001","en-DG":"en-001","en-DM":"en-001","en-ER":"en-001","en-FJ":"en-001","en-FK":"en-001","en-FM":"en-001","en-GB":"en-001","en-GD":"en-001","en-GG":"en-001","en-GH":"en-001","en-GI":"en-001","en-GM":"en-001","en-GY":"en-001","en-HK":"en-001","en-IE":"en-001","en-IL":"en-001","en-IM":"en-001","en-IN":"en-001","en-IO":"en-001","en-JE":"en-001","en-JM":"en-001","en-KE":"en-001","en-KI":"en-001","en-KN":"en-001","en-KY":"en-001","en-LC":"en-001","en-LR":"en-001","en-LS":"en-001","en-MG":"en-001","en-MO":"en-001","en-MS":"en-001","en-MT":"en-001","en-MU":"en-001","en-MV":"en-001","en-MW":"en-001","en-MY":"en-001","en-NA":"en-001","en-NF":"en-001","en-NG":"en-001","en-NR":"en-001","en-NU":"en-001","en-NZ":"en-001","en-PG":"en-001","en-PK":"en-001","en-PN":"en-001","en-PW":"en-001","en-RW":"en-001","en-SB":"en-001","en-SC":"en-001","en-SD":"en-001","en-SG":"en-001","en-SH":"en-001","en-SL":"en-001","en-SS":"en-001","en-SX":"en-001","en-SZ":"en-001","en-TC":"en-001","en-TK":"en-001","en-TO":"en-001","en-TT":"en-001","en-TV":"en-001","en-TZ":"en-001","en-UG":"en-001","en-VC":"en-001","en-VG":"en-001","en-VU":"en-001","en-WS":"en-001","en-ZA":"en-001","en-ZM":"en-001","en-ZW":"en-001","en-AT":"en-150","en-BE":"en-150","en-CH":"en-150","en-DE":"en-150","en-DK":"en-150","en-FI":"en-150","en-NL":"en-150","en-SE":"en-150","en-SI":"en-150","hi-Latn":"en-IN","es-AR":"es-419","es-BO":"es-419","es-BR":"es-419","es-BZ":"es-419","es-CL":"es-419","es-CO":"es-419","es-CR":"es-419","es-CU":"es-419","es-DO":"es-419","es-EC":"es-419","es-GT":"es-419","es-HN":"es-419","es-MX":"es-419","es-NI":"es-419","es-PA":"es-419","es-PE":"es-419","es-PR":"es-419","es-PY":"es-419","es-SV":"es-419","es-US":"es-419","es-UY":"es-419","es-VE":"es-419",nb:"no",nn:"no","pt-AO":"pt-PT","pt-CH":"pt-PT","pt-CV":"pt-PT","pt-FR":"pt-PT","pt-GQ":"pt-PT","pt-GW":"pt-PT","pt-LU":"pt-PT","pt-MO":"pt-PT","pt-MZ":"pt-PT","pt-ST":"pt-PT","pt-TL":"pt-PT","az-Arab":"und","az-Cyrl":"und","bal-Latn":"und","blt-Latn":"und","bm-Nkoo":"und","bs-Cyrl":"und","byn-Latn":"und","cu-Glag":"und","dje-Arab":"und","dyo-Arab":"und","en-Dsrt":"und","en-Shaw":"und","ff-Adlm":"und","ff-Arab":"und","ha-Arab":"und","iu-Latn":"und","kk-Arab":"und","ks-Deva":"und","ku-Arab":"und","ky-Arab":"und","ky-Latn":"und","ml-Arab":"und","mn-Mong":"und","mni-Mtei":"und","ms-Arab":"und","pa-Arab":"und","sat-Deva":"und","sd-Deva":"und","sd-Khoj":"und","sd-Sind":"und","shi-Latn":"und","so-Arab":"und","sr-Latn":"und","sw-Arab":"und","tg-Arab":"und","ug-Cyrl":"und","uz-Arab":"und","uz-Cyrl":"und","vai-Latn":"und","wo-Arab":"und","yo-Arab":"und","yue-Hans":"und","zh-Hant":"und","zh-Hant-MO":"zh-Hant-HK"},e.exports=t.default,e.exports.default=t.default},57421:function(e,t){t.supplementalCldr=void 0;t.supplementalCldr={supplemental:{version:{_unicodeVersion:"12.1.0",_cldrVersion:"36"},likelySubtags:{aa:"aa-Latn-ET",aai:"aai-Latn-ZZ",aak:"aak-Latn-ZZ",aau:"aau-Latn-ZZ",ab:"ab-Cyrl-GE",abi:"abi-Latn-ZZ",abq:"abq-Cyrl-ZZ",abr:"abr-Latn-GH",abt:"abt-Latn-ZZ",aby:"aby-Latn-ZZ",acd:"acd-Latn-ZZ",ace:"ace-Latn-ID",ach:"ach-Latn-UG",ada:"ada-Latn-GH",ade:"ade-Latn-ZZ",adj:"adj-Latn-ZZ",adp:"adp-Tibt-BT",ady:"ady-Cyrl-RU",adz:"adz-Latn-ZZ",ae:"ae-Avst-IR",aeb:"aeb-Arab-TN",aey:"aey-Latn-ZZ",af:"af-Latn-ZA",agc:"agc-Latn-ZZ",agd:"agd-Latn-ZZ",agg:"agg-Latn-ZZ",agm:"agm-Latn-ZZ",ago:"ago-Latn-ZZ",agq:"agq-Latn-CM",aha:"aha-Latn-ZZ",ahl:"ahl-Latn-ZZ",aho:"aho-Ahom-IN",ajg:"ajg-Latn-ZZ",ak:"ak-Latn-GH",akk:"akk-Xsux-IQ",ala:"ala-Latn-ZZ",ali:"ali-Latn-ZZ",aln:"aln-Latn-XK",alt:"alt-Cyrl-RU",am:"am-Ethi-ET",amm:"amm-Latn-ZZ",amn:"amn-Latn-ZZ",amo:"amo-Latn-NG",amp:"amp-Latn-ZZ",an:"an-Latn-ES",anc:"anc-Latn-ZZ",ank:"ank-Latn-ZZ",ann:"ann-Latn-ZZ",any:"any-Latn-ZZ",aoj:"aoj-Latn-ZZ",aom:"aom-Latn-ZZ",aoz:"aoz-Latn-ID",apc:"apc-Arab-ZZ",apd:"apd-Arab-TG",ape:"ape-Latn-ZZ",apr:"apr-Latn-ZZ",aps:"aps-Latn-ZZ",apz:"apz-Latn-ZZ",ar:"ar-Arab-EG",arc:"arc-Armi-IR","arc-Nbat":"arc-Nbat-JO","arc-Palm":"arc-Palm-SY",arh:"arh-Latn-ZZ",arn:"arn-Latn-CL",aro:"aro-Latn-BO",arq:"arq-Arab-DZ",ars:"ars-Arab-SA",ary:"ary-Arab-MA",arz:"arz-Arab-EG",as:"as-Beng-IN",asa:"asa-Latn-TZ",ase:"ase-Sgnw-US",asg:"asg-Latn-ZZ",aso:"aso-Latn-ZZ",ast:"ast-Latn-ES",ata:"ata-Latn-ZZ",atg:"atg-Latn-ZZ",atj:"atj-Latn-CA",auy:"auy-Latn-ZZ",av:"av-Cyrl-RU",avl:"avl-Arab-ZZ",avn:"avn-Latn-ZZ",avt:"avt-Latn-ZZ",avu:"avu-Latn-ZZ",awa:"awa-Deva-IN",awb:"awb-Latn-ZZ",awo:"awo-Latn-ZZ",awx:"awx-Latn-ZZ",ay:"ay-Latn-BO",ayb:"ayb-Latn-ZZ",az:"az-Latn-AZ","az-Arab":"az-Arab-IR","az-IQ":"az-Arab-IQ","az-IR":"az-Arab-IR","az-RU":"az-Cyrl-RU",ba:"ba-Cyrl-RU",bal:"bal-Arab-PK",ban:"ban-Latn-ID",bap:"bap-Deva-NP",bar:"bar-Latn-AT",bas:"bas-Latn-CM",bav:"bav-Latn-ZZ",bax:"bax-Bamu-CM",bba:"bba-Latn-ZZ",bbb:"bbb-Latn-ZZ",bbc:"bbc-Latn-ID",bbd:"bbd-Latn-ZZ",bbj:"bbj-Latn-CM",bbp:"bbp-Latn-ZZ",bbr:"bbr-Latn-ZZ",bcf:"bcf-Latn-ZZ",bch:"bch-Latn-ZZ",bci:"bci-Latn-CI",bcm:"bcm-Latn-ZZ",bcn:"bcn-Latn-ZZ",bco:"bco-Latn-ZZ",bcq:"bcq-Ethi-ZZ",bcu:"bcu-Latn-ZZ",bdd:"bdd-Latn-ZZ",be:"be-Cyrl-BY",bef:"bef-Latn-ZZ",beh:"beh-Latn-ZZ",bej:"bej-Arab-SD",bem:"bem-Latn-ZM",bet:"bet-Latn-ZZ",bew:"bew-Latn-ID",bex:"bex-Latn-ZZ",bez:"bez-Latn-TZ",bfd:"bfd-Latn-CM",bfq:"bfq-Taml-IN",bft:"bft-Arab-PK",bfy:"bfy-Deva-IN",bg:"bg-Cyrl-BG",bgc:"bgc-Deva-IN",bgn:"bgn-Arab-PK",bgx:"bgx-Grek-TR",bhb:"bhb-Deva-IN",bhg:"bhg-Latn-ZZ",bhi:"bhi-Deva-IN",bhl:"bhl-Latn-ZZ",bho:"bho-Deva-IN",bhy:"bhy-Latn-ZZ",bi:"bi-Latn-VU",bib:"bib-Latn-ZZ",big:"big-Latn-ZZ",bik:"bik-Latn-PH",bim:"bim-Latn-ZZ",bin:"bin-Latn-NG",bio:"bio-Latn-ZZ",biq:"biq-Latn-ZZ",bjh:"bjh-Latn-ZZ",bji:"bji-Ethi-ZZ",bjj:"bjj-Deva-IN",bjn:"bjn-Latn-ID",bjo:"bjo-Latn-ZZ",bjr:"bjr-Latn-ZZ",bjt:"bjt-Latn-SN",bjz:"bjz-Latn-ZZ",bkc:"bkc-Latn-ZZ",bkm:"bkm-Latn-CM",bkq:"bkq-Latn-ZZ",bku:"bku-Latn-PH",bkv:"bkv-Latn-ZZ",blt:"blt-Tavt-VN",bm:"bm-Latn-ML",bmh:"bmh-Latn-ZZ",bmk:"bmk-Latn-ZZ",bmq:"bmq-Latn-ML",bmu:"bmu-Latn-ZZ",bn:"bn-Beng-BD",bng:"bng-Latn-ZZ",bnm:"bnm-Latn-ZZ",bnp:"bnp-Latn-ZZ",bo:"bo-Tibt-CN",boj:"boj-Latn-ZZ",bom:"bom-Latn-ZZ",bon:"bon-Latn-ZZ",bpy:"bpy-Beng-IN",bqc:"bqc-Latn-ZZ",bqi:"bqi-Arab-IR",bqp:"bqp-Latn-ZZ",bqv:"bqv-Latn-CI",br:"br-Latn-FR",bra:"bra-Deva-IN",brh:"brh-Arab-PK",brx:"brx-Deva-IN",brz:"brz-Latn-ZZ",bs:"bs-Latn-BA",bsj:"bsj-Latn-ZZ",bsq:"bsq-Bass-LR",bss:"bss-Latn-CM",bst:"bst-Ethi-ZZ",bto:"bto-Latn-PH",btt:"btt-Latn-ZZ",btv:"btv-Deva-PK",bua:"bua-Cyrl-RU",buc:"buc-Latn-YT",bud:"bud-Latn-ZZ",bug:"bug-Latn-ID",buk:"buk-Latn-ZZ",bum:"bum-Latn-CM",buo:"buo-Latn-ZZ",bus:"bus-Latn-ZZ",buu:"buu-Latn-ZZ",bvb:"bvb-Latn-GQ",bwd:"bwd-Latn-ZZ",bwr:"bwr-Latn-ZZ",bxh:"bxh-Latn-ZZ",bye:"bye-Latn-ZZ",byn:"byn-Ethi-ER",byr:"byr-Latn-ZZ",bys:"bys-Latn-ZZ",byv:"byv-Latn-CM",byx:"byx-Latn-ZZ",bza:"bza-Latn-ZZ",bze:"bze-Latn-ML",bzf:"bzf-Latn-ZZ",bzh:"bzh-Latn-ZZ",bzw:"bzw-Latn-ZZ",ca:"ca-Latn-ES",can:"can-Latn-ZZ",cbj:"cbj-Latn-ZZ",cch:"cch-Latn-NG",ccp:"ccp-Cakm-BD",ce:"ce-Cyrl-RU",ceb:"ceb-Latn-PH",cfa:"cfa-Latn-ZZ",cgg:"cgg-Latn-UG",ch:"ch-Latn-GU",chk:"chk-Latn-FM",chm:"chm-Cyrl-RU",cho:"cho-Latn-US",chp:"chp-Latn-CA",chr:"chr-Cher-US",cic:"cic-Latn-US",cja:"cja-Arab-KH",cjm:"cjm-Cham-VN",cjv:"cjv-Latn-ZZ",ckb:"ckb-Arab-IQ",ckl:"ckl-Latn-ZZ",cko:"cko-Latn-ZZ",cky:"cky-Latn-ZZ",cla:"cla-Latn-ZZ",cme:"cme-Latn-ZZ",cmg:"cmg-Soyo-MN",co:"co-Latn-FR",cop:"cop-Copt-EG",cps:"cps-Latn-PH",cr:"cr-Cans-CA",crh:"crh-Cyrl-UA",crj:"crj-Cans-CA",crk:"crk-Cans-CA",crl:"crl-Cans-CA",crm:"crm-Cans-CA",crs:"crs-Latn-SC",cs:"cs-Latn-CZ",csb:"csb-Latn-PL",csw:"csw-Cans-CA",ctd:"ctd-Pauc-MM",cu:"cu-Cyrl-RU","cu-Glag":"cu-Glag-BG",cv:"cv-Cyrl-RU",cy:"cy-Latn-GB",da:"da-Latn-DK",dad:"dad-Latn-ZZ",daf:"daf-Latn-ZZ",dag:"dag-Latn-ZZ",dah:"dah-Latn-ZZ",dak:"dak-Latn-US",dar:"dar-Cyrl-RU",dav:"dav-Latn-KE",dbd:"dbd-Latn-ZZ",dbq:"dbq-Latn-ZZ",dcc:"dcc-Arab-IN",ddn:"ddn-Latn-ZZ",de:"de-Latn-DE",ded:"ded-Latn-ZZ",den:"den-Latn-CA",dga:"dga-Latn-ZZ",dgh:"dgh-Latn-ZZ",dgi:"dgi-Latn-ZZ",dgl:"dgl-Arab-ZZ",dgr:"dgr-Latn-CA",dgz:"dgz-Latn-ZZ",dia:"dia-Latn-ZZ",dje:"dje-Latn-NE",dnj:"dnj-Latn-CI",dob:"dob-Latn-ZZ",doi:"doi-Arab-IN",dop:"dop-Latn-ZZ",dow:"dow-Latn-ZZ",drh:"drh-Mong-CN",dri:"dri-Latn-ZZ",drs:"drs-Ethi-ZZ",dsb:"dsb-Latn-DE",dtm:"dtm-Latn-ML",dtp:"dtp-Latn-MY",dts:"dts-Latn-ZZ",dty:"dty-Deva-NP",dua:"dua-Latn-CM",duc:"duc-Latn-ZZ",dud:"dud-Latn-ZZ",dug:"dug-Latn-ZZ",dv:"dv-Thaa-MV",dva:"dva-Latn-ZZ",dww:"dww-Latn-ZZ",dyo:"dyo-Latn-SN",dyu:"dyu-Latn-BF",dz:"dz-Tibt-BT",dzg:"dzg-Latn-ZZ",ebu:"ebu-Latn-KE",ee:"ee-Latn-GH",efi:"efi-Latn-NG",egl:"egl-Latn-IT",egy:"egy-Egyp-EG",eka:"eka-Latn-ZZ",eky:"eky-Kali-MM",el:"el-Grek-GR",ema:"ema-Latn-ZZ",emi:"emi-Latn-ZZ",en:"en-Latn-US","en-Shaw":"en-Shaw-GB",enn:"enn-Latn-ZZ",enq:"enq-Latn-ZZ",eo:"eo-Latn-001",eri:"eri-Latn-ZZ",es:"es-Latn-ES",esg:"esg-Gonm-IN",esu:"esu-Latn-US",et:"et-Latn-EE",etr:"etr-Latn-ZZ",ett:"ett-Ital-IT",etu:"etu-Latn-ZZ",etx:"etx-Latn-ZZ",eu:"eu-Latn-ES",ewo:"ewo-Latn-CM",ext:"ext-Latn-ES",fa:"fa-Arab-IR",faa:"faa-Latn-ZZ",fab:"fab-Latn-ZZ",fag:"fag-Latn-ZZ",fai:"fai-Latn-ZZ",fan:"fan-Latn-GQ",ff:"ff-Latn-SN","ff-Adlm":"ff-Adlm-GN",ffi:"ffi-Latn-ZZ",ffm:"ffm-Latn-ML",fi:"fi-Latn-FI",fia:"fia-Arab-SD",fil:"fil-Latn-PH",fit:"fit-Latn-SE",fj:"fj-Latn-FJ",flr:"flr-Latn-ZZ",fmp:"fmp-Latn-ZZ",fo:"fo-Latn-FO",fod:"fod-Latn-ZZ",fon:"fon-Latn-BJ",for:"for-Latn-ZZ",fpe:"fpe-Latn-ZZ",fqs:"fqs-Latn-ZZ",fr:"fr-Latn-FR",frc:"frc-Latn-US",frp:"frp-Latn-FR",frr:"frr-Latn-DE",frs:"frs-Latn-DE",fub:"fub-Arab-CM",fud:"fud-Latn-WF",fue:"fue-Latn-ZZ",fuf:"fuf-Latn-GN",fuh:"fuh-Latn-ZZ",fuq:"fuq-Latn-NE",fur:"fur-Latn-IT",fuv:"fuv-Latn-NG",fuy:"fuy-Latn-ZZ",fvr:"fvr-Latn-SD",fy:"fy-Latn-NL",ga:"ga-Latn-IE",gaa:"gaa-Latn-GH",gaf:"gaf-Latn-ZZ",gag:"gag-Latn-MD",gah:"gah-Latn-ZZ",gaj:"gaj-Latn-ZZ",gam:"gam-Latn-ZZ",gan:"gan-Hans-CN",gaw:"gaw-Latn-ZZ",gay:"gay-Latn-ID",gba:"gba-Latn-ZZ",gbf:"gbf-Latn-ZZ",gbm:"gbm-Deva-IN",gby:"gby-Latn-ZZ",gbz:"gbz-Arab-IR",gcr:"gcr-Latn-GF",gd:"gd-Latn-GB",gde:"gde-Latn-ZZ",gdn:"gdn-Latn-ZZ",gdr:"gdr-Latn-ZZ",geb:"geb-Latn-ZZ",gej:"gej-Latn-ZZ",gel:"gel-Latn-ZZ",gez:"gez-Ethi-ET",gfk:"gfk-Latn-ZZ",ggn:"ggn-Deva-NP",ghs:"ghs-Latn-ZZ",gil:"gil-Latn-KI",gim:"gim-Latn-ZZ",gjk:"gjk-Arab-PK",gjn:"gjn-Latn-ZZ",gju:"gju-Arab-PK",gkn:"gkn-Latn-ZZ",gkp:"gkp-Latn-ZZ",gl:"gl-Latn-ES",glk:"glk-Arab-IR",gmm:"gmm-Latn-ZZ",gmv:"gmv-Ethi-ZZ",gn:"gn-Latn-PY",gnd:"gnd-Latn-ZZ",gng:"gng-Latn-ZZ",god:"god-Latn-ZZ",gof:"gof-Ethi-ZZ",goi:"goi-Latn-ZZ",gom:"gom-Deva-IN",gon:"gon-Telu-IN",gor:"gor-Latn-ID",gos:"gos-Latn-NL",got:"got-Goth-UA",grb:"grb-Latn-ZZ",grc:"grc-Cprt-CY","grc-Linb":"grc-Linb-GR",grt:"grt-Beng-IN",grw:"grw-Latn-ZZ",gsw:"gsw-Latn-CH",gu:"gu-Gujr-IN",gub:"gub-Latn-BR",guc:"guc-Latn-CO",gud:"gud-Latn-ZZ",gur:"gur-Latn-GH",guw:"guw-Latn-ZZ",gux:"gux-Latn-ZZ",guz:"guz-Latn-KE",gv:"gv-Latn-IM",gvf:"gvf-Latn-ZZ",gvr:"gvr-Deva-NP",gvs:"gvs-Latn-ZZ",gwc:"gwc-Arab-ZZ",gwi:"gwi-Latn-CA",gwt:"gwt-Arab-ZZ",gyi:"gyi-Latn-ZZ",ha:"ha-Latn-NG","ha-CM":"ha-Arab-CM","ha-SD":"ha-Arab-SD",hag:"hag-Latn-ZZ",hak:"hak-Hans-CN",ham:"ham-Latn-ZZ",haw:"haw-Latn-US",haz:"haz-Arab-AF",hbb:"hbb-Latn-ZZ",hdy:"hdy-Ethi-ZZ",he:"he-Hebr-IL",hhy:"hhy-Latn-ZZ",hi:"hi-Deva-IN",hia:"hia-Latn-ZZ",hif:"hif-Latn-FJ",hig:"hig-Latn-ZZ",hih:"hih-Latn-ZZ",hil:"hil-Latn-PH",hla:"hla-Latn-ZZ",hlu:"hlu-Hluw-TR",hmd:"hmd-Plrd-CN",hmt:"hmt-Latn-ZZ",hnd:"hnd-Arab-PK",hne:"hne-Deva-IN",hnj:"hnj-Hmng-LA",hnn:"hnn-Latn-PH",hno:"hno-Arab-PK",ho:"ho-Latn-PG",hoc:"hoc-Deva-IN",hoj:"hoj-Deva-IN",hot:"hot-Latn-ZZ",hr:"hr-Latn-HR",hsb:"hsb-Latn-DE",hsn:"hsn-Hans-CN",ht:"ht-Latn-HT",hu:"hu-Latn-HU",hui:"hui-Latn-ZZ",hy:"hy-Armn-AM",hz:"hz-Latn-NA",ia:"ia-Latn-001",ian:"ian-Latn-ZZ",iar:"iar-Latn-ZZ",iba:"iba-Latn-MY",ibb:"ibb-Latn-NG",iby:"iby-Latn-ZZ",ica:"ica-Latn-ZZ",ich:"ich-Latn-ZZ",id:"id-Latn-ID",idd:"idd-Latn-ZZ",idi:"idi-Latn-ZZ",idu:"idu-Latn-ZZ",ife:"ife-Latn-TG",ig:"ig-Latn-NG",igb:"igb-Latn-ZZ",ige:"ige-Latn-ZZ",ii:"ii-Yiii-CN",ijj:"ijj-Latn-ZZ",ik:"ik-Latn-US",ikk:"ikk-Latn-ZZ",ikt:"ikt-Latn-CA",ikw:"ikw-Latn-ZZ",ikx:"ikx-Latn-ZZ",ilo:"ilo-Latn-PH",imo:"imo-Latn-ZZ",in:"in-Latn-ID",inh:"inh-Cyrl-RU",io:"io-Latn-001",iou:"iou-Latn-ZZ",iri:"iri-Latn-ZZ",is:"is-Latn-IS",it:"it-Latn-IT",iu:"iu-Cans-CA",iw:"iw-Hebr-IL",iwm:"iwm-Latn-ZZ",iws:"iws-Latn-ZZ",izh:"izh-Latn-RU",izi:"izi-Latn-ZZ",ja:"ja-Jpan-JP",jab:"jab-Latn-ZZ",jam:"jam-Latn-JM",jbo:"jbo-Latn-001",jbu:"jbu-Latn-ZZ",jen:"jen-Latn-ZZ",jgk:"jgk-Latn-ZZ",jgo:"jgo-Latn-CM",ji:"ji-Hebr-UA",jib:"jib-Latn-ZZ",jmc:"jmc-Latn-TZ",jml:"jml-Deva-NP",jra:"jra-Latn-ZZ",jut:"jut-Latn-DK",jv:"jv-Latn-ID",jw:"jw-Latn-ID",ka:"ka-Geor-GE",kaa:"kaa-Cyrl-UZ",kab:"kab-Latn-DZ",kac:"kac-Latn-MM",kad:"kad-Latn-ZZ",kai:"kai-Latn-ZZ",kaj:"kaj-Latn-NG",kam:"kam-Latn-KE",kao:"kao-Latn-ML",kbd:"kbd-Cyrl-RU",kbm:"kbm-Latn-ZZ",kbp:"kbp-Latn-ZZ",kbq:"kbq-Latn-ZZ",kbx:"kbx-Latn-ZZ",kby:"kby-Arab-NE",kcg:"kcg-Latn-NG",kck:"kck-Latn-ZW",kcl:"kcl-Latn-ZZ",kct:"kct-Latn-ZZ",kde:"kde-Latn-TZ",kdh:"kdh-Arab-TG",kdl:"kdl-Latn-ZZ",kdt:"kdt-Thai-TH",kea:"kea-Latn-CV",ken:"ken-Latn-CM",kez:"kez-Latn-ZZ",kfo:"kfo-Latn-CI",kfr:"kfr-Deva-IN",kfy:"kfy-Deva-IN",kg:"kg-Latn-CD",kge:"kge-Latn-ID",kgf:"kgf-Latn-ZZ",kgp:"kgp-Latn-BR",kha:"kha-Latn-IN",khb:"khb-Talu-CN",khn:"khn-Deva-IN",khq:"khq-Latn-ML",khs:"khs-Latn-ZZ",kht:"kht-Mymr-IN",khw:"khw-Arab-PK",khz:"khz-Latn-ZZ",ki:"ki-Latn-KE",kij:"kij-Latn-ZZ",kiu:"kiu-Latn-TR",kiw:"kiw-Latn-ZZ",kj:"kj-Latn-NA",kjd:"kjd-Latn-ZZ",kjg:"kjg-Laoo-LA",kjs:"kjs-Latn-ZZ",kjy:"kjy-Latn-ZZ",kk:"kk-Cyrl-KZ","kk-AF":"kk-Arab-AF","kk-Arab":"kk-Arab-CN","kk-CN":"kk-Arab-CN","kk-IR":"kk-Arab-IR","kk-MN":"kk-Arab-MN",kkc:"kkc-Latn-ZZ",kkj:"kkj-Latn-CM",kl:"kl-Latn-GL",kln:"kln-Latn-KE",klq:"klq-Latn-ZZ",klt:"klt-Latn-ZZ",klx:"klx-Latn-ZZ",km:"km-Khmr-KH",kmb:"kmb-Latn-AO",kmh:"kmh-Latn-ZZ",kmo:"kmo-Latn-ZZ",kms:"kms-Latn-ZZ",kmu:"kmu-Latn-ZZ",kmw:"kmw-Latn-ZZ",kn:"kn-Knda-IN",knf:"knf-Latn-GW",knp:"knp-Latn-ZZ",ko:"ko-Kore-KR",koi:"koi-Cyrl-RU",kok:"kok-Deva-IN",kol:"kol-Latn-ZZ",kos:"kos-Latn-FM",koz:"koz-Latn-ZZ",kpe:"kpe-Latn-LR",kpf:"kpf-Latn-ZZ",kpo:"kpo-Latn-ZZ",kpr:"kpr-Latn-ZZ",kpx:"kpx-Latn-ZZ",kqb:"kqb-Latn-ZZ",kqf:"kqf-Latn-ZZ",kqs:"kqs-Latn-ZZ",kqy:"kqy-Ethi-ZZ",kr:"kr-Latn-ZZ",krc:"krc-Cyrl-RU",kri:"kri-Latn-SL",krj:"krj-Latn-PH",krl:"krl-Latn-RU",krs:"krs-Latn-ZZ",kru:"kru-Deva-IN",ks:"ks-Arab-IN",ksb:"ksb-Latn-TZ",ksd:"ksd-Latn-ZZ",ksf:"ksf-Latn-CM",ksh:"ksh-Latn-DE",ksj:"ksj-Latn-ZZ",ksr:"ksr-Latn-ZZ",ktb:"ktb-Ethi-ZZ",ktm:"ktm-Latn-ZZ",kto:"kto-Latn-ZZ",ktr:"ktr-Latn-MY",ku:"ku-Latn-TR","ku-Arab":"ku-Arab-IQ","ku-LB":"ku-Arab-LB",kub:"kub-Latn-ZZ",kud:"kud-Latn-ZZ",kue:"kue-Latn-ZZ",kuj:"kuj-Latn-ZZ",kum:"kum-Cyrl-RU",kun:"kun-Latn-ZZ",kup:"kup-Latn-ZZ",kus:"kus-Latn-ZZ",kv:"kv-Cyrl-RU",kvg:"kvg-Latn-ZZ",kvr:"kvr-Latn-ID",kvx:"kvx-Arab-PK",kw:"kw-Latn-GB",kwj:"kwj-Latn-ZZ",kwo:"kwo-Latn-ZZ",kwq:"kwq-Latn-ZZ",kxa:"kxa-Latn-ZZ",kxc:"kxc-Ethi-ZZ",kxe:"kxe-Latn-ZZ",kxm:"kxm-Thai-TH",kxp:"kxp-Arab-PK",kxw:"kxw-Latn-ZZ",kxz:"kxz-Latn-ZZ",ky:"ky-Cyrl-KG","ky-Arab":"ky-Arab-CN","ky-CN":"ky-Arab-CN","ky-Latn":"ky-Latn-TR","ky-TR":"ky-Latn-TR",kye:"kye-Latn-ZZ",kyx:"kyx-Latn-ZZ",kzj:"kzj-Latn-MY",kzr:"kzr-Latn-ZZ",kzt:"kzt-Latn-MY",la:"la-Latn-VA",lab:"lab-Lina-GR",lad:"lad-Hebr-IL",lag:"lag-Latn-TZ",lah:"lah-Arab-PK",laj:"laj-Latn-UG",las:"las-Latn-ZZ",lb:"lb-Latn-LU",lbe:"lbe-Cyrl-RU",lbu:"lbu-Latn-ZZ",lbw:"lbw-Latn-ID",lcm:"lcm-Latn-ZZ",lcp:"lcp-Thai-CN",ldb:"ldb-Latn-ZZ",led:"led-Latn-ZZ",lee:"lee-Latn-ZZ",lem:"lem-Latn-ZZ",lep:"lep-Lepc-IN",leq:"leq-Latn-ZZ",leu:"leu-Latn-ZZ",lez:"lez-Cyrl-RU",lg:"lg-Latn-UG",lgg:"lgg-Latn-ZZ",li:"li-Latn-NL",lia:"lia-Latn-ZZ",lid:"lid-Latn-ZZ",lif:"lif-Deva-NP","lif-Limb":"lif-Limb-IN",lig:"lig-Latn-ZZ",lih:"lih-Latn-ZZ",lij:"lij-Latn-IT",lis:"lis-Lisu-CN",ljp:"ljp-Latn-ID",lki:"lki-Arab-IR",lkt:"lkt-Latn-US",lle:"lle-Latn-ZZ",lln:"lln-Latn-ZZ",lmn:"lmn-Telu-IN",lmo:"lmo-Latn-IT",lmp:"lmp-Latn-ZZ",ln:"ln-Latn-CD",lns:"lns-Latn-ZZ",lnu:"lnu-Latn-ZZ",lo:"lo-Laoo-LA",loj:"loj-Latn-ZZ",lok:"lok-Latn-ZZ",lol:"lol-Latn-CD",lor:"lor-Latn-ZZ",los:"los-Latn-ZZ",loz:"loz-Latn-ZM",lrc:"lrc-Arab-IR",lt:"lt-Latn-LT",ltg:"ltg-Latn-LV",lu:"lu-Latn-CD",lua:"lua-Latn-CD",luo:"luo-Latn-KE",luy:"luy-Latn-KE",luz:"luz-Arab-IR",lv:"lv-Latn-LV",lwl:"lwl-Thai-TH",lzh:"lzh-Hans-CN",lzz:"lzz-Latn-TR",mad:"mad-Latn-ID",maf:"maf-Latn-CM",mag:"mag-Deva-IN",mai:"mai-Deva-IN",mak:"mak-Latn-ID",man:"man-Latn-GM","man-GN":"man-Nkoo-GN","man-Nkoo":"man-Nkoo-GN",mas:"mas-Latn-KE",maw:"maw-Latn-ZZ",maz:"maz-Latn-MX",mbh:"mbh-Latn-ZZ",mbo:"mbo-Latn-ZZ",mbq:"mbq-Latn-ZZ",mbu:"mbu-Latn-ZZ",mbw:"mbw-Latn-ZZ",mci:"mci-Latn-ZZ",mcp:"mcp-Latn-ZZ",mcq:"mcq-Latn-ZZ",mcr:"mcr-Latn-ZZ",mcu:"mcu-Latn-ZZ",mda:"mda-Latn-ZZ",mde:"mde-Arab-ZZ",mdf:"mdf-Cyrl-RU",mdh:"mdh-Latn-PH",mdj:"mdj-Latn-ZZ",mdr:"mdr-Latn-ID",mdx:"mdx-Ethi-ZZ",med:"med-Latn-ZZ",mee:"mee-Latn-ZZ",mek:"mek-Latn-ZZ",men:"men-Latn-SL",mer:"mer-Latn-KE",met:"met-Latn-ZZ",meu:"meu-Latn-ZZ",mfa:"mfa-Arab-TH",mfe:"mfe-Latn-MU",mfn:"mfn-Latn-ZZ",mfo:"mfo-Latn-ZZ",mfq:"mfq-Latn-ZZ",mg:"mg-Latn-MG",mgh:"mgh-Latn-MZ",mgl:"mgl-Latn-ZZ",mgo:"mgo-Latn-CM",mgp:"mgp-Deva-NP",mgy:"mgy-Latn-TZ",mh:"mh-Latn-MH",mhi:"mhi-Latn-ZZ",mhl:"mhl-Latn-ZZ",mi:"mi-Latn-NZ",mif:"mif-Latn-ZZ",min:"min-Latn-ID",mis:"mis-Hatr-IQ","mis-Medf":"mis-Medf-NG",miw:"miw-Latn-ZZ",mk:"mk-Cyrl-MK",mki:"mki-Arab-ZZ",mkl:"mkl-Latn-ZZ",mkp:"mkp-Latn-ZZ",mkw:"mkw-Latn-ZZ",ml:"ml-Mlym-IN",mle:"mle-Latn-ZZ",mlp:"mlp-Latn-ZZ",mls:"mls-Latn-SD",mmo:"mmo-Latn-ZZ",mmu:"mmu-Latn-ZZ",mmx:"mmx-Latn-ZZ",mn:"mn-Cyrl-MN","mn-CN":"mn-Mong-CN","mn-Mong":"mn-Mong-CN",mna:"mna-Latn-ZZ",mnf:"mnf-Latn-ZZ",mni:"mni-Beng-IN",mnw:"mnw-Mymr-MM",mo:"mo-Latn-RO",moa:"moa-Latn-ZZ",moe:"moe-Latn-CA",moh:"moh-Latn-CA",mos:"mos-Latn-BF",mox:"mox-Latn-ZZ",mpp:"mpp-Latn-ZZ",mps:"mps-Latn-ZZ",mpt:"mpt-Latn-ZZ",mpx:"mpx-Latn-ZZ",mql:"mql-Latn-ZZ",mr:"mr-Deva-IN",mrd:"mrd-Deva-NP",mrj:"mrj-Cyrl-RU",mro:"mro-Mroo-BD",ms:"ms-Latn-MY","ms-CC":"ms-Arab-CC","ms-ID":"ms-Arab-ID",mt:"mt-Latn-MT",mtc:"mtc-Latn-ZZ",mtf:"mtf-Latn-ZZ",mti:"mti-Latn-ZZ",mtr:"mtr-Deva-IN",mua:"mua-Latn-CM",mur:"mur-Latn-ZZ",mus:"mus-Latn-US",mva:"mva-Latn-ZZ",mvn:"mvn-Latn-ZZ",mvy:"mvy-Arab-PK",mwk:"mwk-Latn-ML",mwr:"mwr-Deva-IN",mwv:"mwv-Latn-ID",mww:"mww-Hmnp-US",mxc:"mxc-Latn-ZW",mxm:"mxm-Latn-ZZ",my:"my-Mymr-MM",myk:"myk-Latn-ZZ",mym:"mym-Ethi-ZZ",myv:"myv-Cyrl-RU",myw:"myw-Latn-ZZ",myx:"myx-Latn-UG",myz:"myz-Mand-IR",mzk:"mzk-Latn-ZZ",mzm:"mzm-Latn-ZZ",mzn:"mzn-Arab-IR",mzp:"mzp-Latn-ZZ",mzw:"mzw-Latn-ZZ",mzz:"mzz-Latn-ZZ",na:"na-Latn-NR",nac:"nac-Latn-ZZ",naf:"naf-Latn-ZZ",nak:"nak-Latn-ZZ",nan:"nan-Hans-CN",nap:"nap-Latn-IT",naq:"naq-Latn-NA",nas:"nas-Latn-ZZ",nb:"nb-Latn-NO",nca:"nca-Latn-ZZ",nce:"nce-Latn-ZZ",ncf:"ncf-Latn-ZZ",nch:"nch-Latn-MX",nco:"nco-Latn-ZZ",ncu:"ncu-Latn-ZZ",nd:"nd-Latn-ZW",ndc:"ndc-Latn-MZ",nds:"nds-Latn-DE",ne:"ne-Deva-NP",neb:"neb-Latn-ZZ",new:"new-Deva-NP",nex:"nex-Latn-ZZ",nfr:"nfr-Latn-ZZ",ng:"ng-Latn-NA",nga:"nga-Latn-ZZ",ngb:"ngb-Latn-ZZ",ngl:"ngl-Latn-MZ",nhb:"nhb-Latn-ZZ",nhe:"nhe-Latn-MX",nhw:"nhw-Latn-MX",nif:"nif-Latn-ZZ",nii:"nii-Latn-ZZ",nij:"nij-Latn-ID",nin:"nin-Latn-ZZ",niu:"niu-Latn-NU",niy:"niy-Latn-ZZ",niz:"niz-Latn-ZZ",njo:"njo-Latn-IN",nkg:"nkg-Latn-ZZ",nko:"nko-Latn-ZZ",nl:"nl-Latn-NL",nmg:"nmg-Latn-CM",nmz:"nmz-Latn-ZZ",nn:"nn-Latn-NO",nnf:"nnf-Latn-ZZ",nnh:"nnh-Latn-CM",nnk:"nnk-Latn-ZZ",nnm:"nnm-Latn-ZZ",nnp:"nnp-Wcho-IN",no:"no-Latn-NO",nod:"nod-Lana-TH",noe:"noe-Deva-IN",non:"non-Runr-SE",nop:"nop-Latn-ZZ",nou:"nou-Latn-ZZ",nqo:"nqo-Nkoo-GN",nr:"nr-Latn-ZA",nrb:"nrb-Latn-ZZ",nsk:"nsk-Cans-CA",nsn:"nsn-Latn-ZZ",nso:"nso-Latn-ZA",nss:"nss-Latn-ZZ",ntm:"ntm-Latn-ZZ",ntr:"ntr-Latn-ZZ",nui:"nui-Latn-ZZ",nup:"nup-Latn-ZZ",nus:"nus-Latn-SS",nuv:"nuv-Latn-ZZ",nux:"nux-Latn-ZZ",nv:"nv-Latn-US",nwb:"nwb-Latn-ZZ",nxq:"nxq-Latn-CN",nxr:"nxr-Latn-ZZ",ny:"ny-Latn-MW",nym:"nym-Latn-TZ",nyn:"nyn-Latn-UG",nzi:"nzi-Latn-GH",oc:"oc-Latn-FR",ogc:"ogc-Latn-ZZ",okr:"okr-Latn-ZZ",okv:"okv-Latn-ZZ",om:"om-Latn-ET",ong:"ong-Latn-ZZ",onn:"onn-Latn-ZZ",ons:"ons-Latn-ZZ",opm:"opm-Latn-ZZ",or:"or-Orya-IN",oro:"oro-Latn-ZZ",oru:"oru-Arab-ZZ",os:"os-Cyrl-GE",osa:"osa-Osge-US",ota:"ota-Arab-ZZ",otk:"otk-Orkh-MN",ozm:"ozm-Latn-ZZ",pa:"pa-Guru-IN","pa-Arab":"pa-Arab-PK","pa-PK":"pa-Arab-PK",pag:"pag-Latn-PH",pal:"pal-Phli-IR","pal-Phlp":"pal-Phlp-CN",pam:"pam-Latn-PH",pap:"pap-Latn-AW",pau:"pau-Latn-PW",pbi:"pbi-Latn-ZZ",pcd:"pcd-Latn-FR",pcm:"pcm-Latn-NG",pdc:"pdc-Latn-US",pdt:"pdt-Latn-CA",ped:"ped-Latn-ZZ",peo:"peo-Xpeo-IR",pex:"pex-Latn-ZZ",pfl:"pfl-Latn-DE",phl:"phl-Arab-ZZ",phn:"phn-Phnx-LB",pil:"pil-Latn-ZZ",pip:"pip-Latn-ZZ",pka:"pka-Brah-IN",pko:"pko-Latn-KE",pl:"pl-Latn-PL",pla:"pla-Latn-ZZ",pms:"pms-Latn-IT",png:"png-Latn-ZZ",pnn:"pnn-Latn-ZZ",pnt:"pnt-Grek-GR",pon:"pon-Latn-FM",ppa:"ppa-Deva-IN",ppo:"ppo-Latn-ZZ",pra:"pra-Khar-PK",prd:"prd-Arab-IR",prg:"prg-Latn-001",ps:"ps-Arab-AF",pss:"pss-Latn-ZZ",pt:"pt-Latn-BR",ptp:"ptp-Latn-ZZ",puu:"puu-Latn-GA",pwa:"pwa-Latn-ZZ",qu:"qu-Latn-PE",quc:"quc-Latn-GT",qug:"qug-Latn-EC",rai:"rai-Latn-ZZ",raj:"raj-Deva-IN",rao:"rao-Latn-ZZ",rcf:"rcf-Latn-RE",rej:"rej-Latn-ID",rel:"rel-Latn-ZZ",res:"res-Latn-ZZ",rgn:"rgn-Latn-IT",rhg:"rhg-Arab-MM",ria:"ria-Latn-IN",rif:"rif-Tfng-MA","rif-NL":"rif-Latn-NL",rjs:"rjs-Deva-NP",rkt:"rkt-Beng-BD",rm:"rm-Latn-CH",rmf:"rmf-Latn-FI",rmo:"rmo-Latn-CH",rmt:"rmt-Arab-IR",rmu:"rmu-Latn-SE",rn:"rn-Latn-BI",rna:"rna-Latn-ZZ",rng:"rng-Latn-MZ",ro:"ro-Latn-RO",rob:"rob-Latn-ID",rof:"rof-Latn-TZ",roo:"roo-Latn-ZZ",rro:"rro-Latn-ZZ",rtm:"rtm-Latn-FJ",ru:"ru-Cyrl-RU",rue:"rue-Cyrl-UA",rug:"rug-Latn-SB",rw:"rw-Latn-RW",rwk:"rwk-Latn-TZ",rwo:"rwo-Latn-ZZ",ryu:"ryu-Kana-JP",sa:"sa-Deva-IN",saf:"saf-Latn-GH",sah:"sah-Cyrl-RU",saq:"saq-Latn-KE",sas:"sas-Latn-ID",sat:"sat-Latn-IN",sav:"sav-Latn-SN",saz:"saz-Saur-IN",sba:"sba-Latn-ZZ",sbe:"sbe-Latn-ZZ",sbp:"sbp-Latn-TZ",sc:"sc-Latn-IT",sck:"sck-Deva-IN",scl:"scl-Arab-ZZ",scn:"scn-Latn-IT",sco:"sco-Latn-GB",scs:"scs-Latn-CA",sd:"sd-Arab-PK","sd-Deva":"sd-Deva-IN","sd-Khoj":"sd-Khoj-IN","sd-Sind":"sd-Sind-IN",sdc:"sdc-Latn-IT",sdh:"sdh-Arab-IR",se:"se-Latn-NO",sef:"sef-Latn-CI",seh:"seh-Latn-MZ",sei:"sei-Latn-MX",ses:"ses-Latn-ML",sg:"sg-Latn-CF",sga:"sga-Ogam-IE",sgs:"sgs-Latn-LT",sgw:"sgw-Ethi-ZZ",sgz:"sgz-Latn-ZZ",shi:"shi-Tfng-MA",shk:"shk-Latn-ZZ",shn:"shn-Mymr-MM",shu:"shu-Arab-ZZ",si:"si-Sinh-LK",sid:"sid-Latn-ET",sig:"sig-Latn-ZZ",sil:"sil-Latn-ZZ",sim:"sim-Latn-ZZ",sjr:"sjr-Latn-ZZ",sk:"sk-Latn-SK",skc:"skc-Latn-ZZ",skr:"skr-Arab-PK",sks:"sks-Latn-ZZ",sl:"sl-Latn-SI",sld:"sld-Latn-ZZ",sli:"sli-Latn-PL",sll:"sll-Latn-ZZ",sly:"sly-Latn-ID",sm:"sm-Latn-WS",sma:"sma-Latn-SE",smj:"smj-Latn-SE",smn:"smn-Latn-FI",smp:"smp-Samr-IL",smq:"smq-Latn-ZZ",sms:"sms-Latn-FI",sn:"sn-Latn-ZW",snc:"snc-Latn-ZZ",snk:"snk-Latn-ML",snp:"snp-Latn-ZZ",snx:"snx-Latn-ZZ",sny:"sny-Latn-ZZ",so:"so-Latn-SO",sog:"sog-Sogd-UZ",sok:"sok-Latn-ZZ",soq:"soq-Latn-ZZ",sou:"sou-Thai-TH",soy:"soy-Latn-ZZ",spd:"spd-Latn-ZZ",spl:"spl-Latn-ZZ",sps:"sps-Latn-ZZ",sq:"sq-Latn-AL",sr:"sr-Cyrl-RS","sr-ME":"sr-Latn-ME","sr-RO":"sr-Latn-RO","sr-RU":"sr-Latn-RU","sr-TR":"sr-Latn-TR",srb:"srb-Sora-IN",srn:"srn-Latn-SR",srr:"srr-Latn-SN",srx:"srx-Deva-IN",ss:"ss-Latn-ZA",ssd:"ssd-Latn-ZZ",ssg:"ssg-Latn-ZZ",ssy:"ssy-Latn-ER",st:"st-Latn-ZA",stk:"stk-Latn-ZZ",stq:"stq-Latn-DE",su:"su-Latn-ID",sua:"sua-Latn-ZZ",sue:"sue-Latn-ZZ",suk:"suk-Latn-TZ",sur:"sur-Latn-ZZ",sus:"sus-Latn-GN",sv:"sv-Latn-SE",sw:"sw-Latn-TZ",swb:"swb-Arab-YT",swc:"swc-Latn-CD",swg:"swg-Latn-DE",swp:"swp-Latn-ZZ",swv:"swv-Deva-IN",sxn:"sxn-Latn-ID",sxw:"sxw-Latn-ZZ",syl:"syl-Beng-BD",syr:"syr-Syrc-IQ",szl:"szl-Latn-PL",ta:"ta-Taml-IN",taj:"taj-Deva-NP",tal:"tal-Latn-ZZ",tan:"tan-Latn-ZZ",taq:"taq-Latn-ZZ",tbc:"tbc-Latn-ZZ",tbd:"tbd-Latn-ZZ",tbf:"tbf-Latn-ZZ",tbg:"tbg-Latn-ZZ",tbo:"tbo-Latn-ZZ",tbw:"tbw-Latn-PH",tbz:"tbz-Latn-ZZ",tci:"tci-Latn-ZZ",tcy:"tcy-Knda-IN",tdd:"tdd-Tale-CN",tdg:"tdg-Deva-NP",tdh:"tdh-Deva-NP",tdu:"tdu-Latn-MY",te:"te-Telu-IN",ted:"ted-Latn-ZZ",tem:"tem-Latn-SL",teo:"teo-Latn-UG",tet:"tet-Latn-TL",tfi:"tfi-Latn-ZZ",tg:"tg-Cyrl-TJ","tg-Arab":"tg-Arab-PK","tg-PK":"tg-Arab-PK",tgc:"tgc-Latn-ZZ",tgo:"tgo-Latn-ZZ",tgu:"tgu-Latn-ZZ",th:"th-Thai-TH",thl:"thl-Deva-NP",thq:"thq-Deva-NP",thr:"thr-Deva-NP",ti:"ti-Ethi-ET",tif:"tif-Latn-ZZ",tig:"tig-Ethi-ER",tik:"tik-Latn-ZZ",tim:"tim-Latn-ZZ",tio:"tio-Latn-ZZ",tiv:"tiv-Latn-NG",tk:"tk-Latn-TM",tkl:"tkl-Latn-TK",tkr:"tkr-Latn-AZ",tkt:"tkt-Deva-NP",tl:"tl-Latn-PH",tlf:"tlf-Latn-ZZ",tlx:"tlx-Latn-ZZ",tly:"tly-Latn-AZ",tmh:"tmh-Latn-NE",tmy:"tmy-Latn-ZZ",tn:"tn-Latn-ZA",tnh:"tnh-Latn-ZZ",to:"to-Latn-TO",tof:"tof-Latn-ZZ",tog:"tog-Latn-MW",toq:"toq-Latn-ZZ",tpi:"tpi-Latn-PG",tpm:"tpm-Latn-ZZ",tpz:"tpz-Latn-ZZ",tqo:"tqo-Latn-ZZ",tr:"tr-Latn-TR",tru:"tru-Latn-TR",trv:"trv-Latn-TW",trw:"trw-Arab-ZZ",ts:"ts-Latn-ZA",tsd:"tsd-Grek-GR",tsf:"tsf-Deva-NP",tsg:"tsg-Latn-PH",tsj:"tsj-Tibt-BT",tsw:"tsw-Latn-ZZ",tt:"tt-Cyrl-RU",ttd:"ttd-Latn-ZZ",tte:"tte-Latn-ZZ",ttj:"ttj-Latn-UG",ttr:"ttr-Latn-ZZ",tts:"tts-Thai-TH",ttt:"ttt-Latn-AZ",tuh:"tuh-Latn-ZZ",tul:"tul-Latn-ZZ",tum:"tum-Latn-MW",tuq:"tuq-Latn-ZZ",tvd:"tvd-Latn-ZZ",tvl:"tvl-Latn-TV",tvu:"tvu-Latn-ZZ",twh:"twh-Latn-ZZ",twq:"twq-Latn-NE",txg:"txg-Tang-CN",ty:"ty-Latn-PF",tya:"tya-Latn-ZZ",tyv:"tyv-Cyrl-RU",tzm:"tzm-Latn-MA",ubu:"ubu-Latn-ZZ",udm:"udm-Cyrl-RU",ug:"ug-Arab-CN","ug-Cyrl":"ug-Cyrl-KZ","ug-KZ":"ug-Cyrl-KZ","ug-MN":"ug-Cyrl-MN",uga:"uga-Ugar-SY",uk:"uk-Cyrl-UA",uli:"uli-Latn-FM",umb:"umb-Latn-AO",und:"en-Latn-US","und-002":"en-Latn-NG","und-003":"en-Latn-US","und-005":"pt-Latn-BR","und-009":"en-Latn-AU","und-011":"en-Latn-NG","und-013":"es-Latn-MX","und-014":"sw-Latn-TZ","und-015":"ar-Arab-EG","und-017":"sw-Latn-CD","und-018":"en-Latn-ZA","und-019":"en-Latn-US","und-021":"en-Latn-US","und-029":"es-Latn-CU","und-030":"zh-Hans-CN","und-034":"hi-Deva-IN","und-035":"id-Latn-ID","und-039":"it-Latn-IT","und-053":"en-Latn-AU","und-054":"en-Latn-PG","und-057":"en-Latn-GU","und-061":"sm-Latn-WS","und-142":"zh-Hans-CN","und-143":"uz-Latn-UZ","und-145":"ar-Arab-SA","und-150":"ru-Cyrl-RU","und-151":"ru-Cyrl-RU","und-154":"en-Latn-GB","und-155":"de-Latn-DE","und-202":"en-Latn-NG","und-419":"es-Latn-419","und-AD":"ca-Latn-AD","und-Adlm":"ff-Adlm-GN","und-AE":"ar-Arab-AE","und-AF":"fa-Arab-AF","und-Aghb":"lez-Aghb-RU","und-Ahom":"aho-Ahom-IN","und-AL":"sq-Latn-AL","und-AM":"hy-Armn-AM","und-AO":"pt-Latn-AO","und-AQ":"und-Latn-AQ","und-AR":"es-Latn-AR","und-Arab":"ar-Arab-EG","und-Arab-CC":"ms-Arab-CC","und-Arab-CN":"ug-Arab-CN","und-Arab-GB":"ks-Arab-GB","und-Arab-ID":"ms-Arab-ID","und-Arab-IN":"ur-Arab-IN","und-Arab-KH":"cja-Arab-KH","und-Arab-MM":"rhg-Arab-MM","und-Arab-MN":"kk-Arab-MN","und-Arab-MU":"ur-Arab-MU","und-Arab-NG":"ha-Arab-NG","und-Arab-PK":"ur-Arab-PK","und-Arab-TG":"apd-Arab-TG","und-Arab-TH":"mfa-Arab-TH","und-Arab-TJ":"fa-Arab-TJ","und-Arab-TR":"az-Arab-TR","und-Arab-YT":"swb-Arab-YT","und-Armi":"arc-Armi-IR","und-Armn":"hy-Armn-AM","und-AS":"sm-Latn-AS","und-AT":"de-Latn-AT","und-Avst":"ae-Avst-IR","und-AW":"nl-Latn-AW","und-AX":"sv-Latn-AX","und-AZ":"az-Latn-AZ","und-BA":"bs-Latn-BA","und-Bali":"ban-Bali-ID","und-Bamu":"bax-Bamu-CM","und-Bass":"bsq-Bass-LR","und-Batk":"bbc-Batk-ID","und-BD":"bn-Beng-BD","und-BE":"nl-Latn-BE","und-Beng":"bn-Beng-BD","und-BF":"fr-Latn-BF","und-BG":"bg-Cyrl-BG","und-BH":"ar-Arab-BH","und-Bhks":"sa-Bhks-IN","und-BI":"rn-Latn-BI","und-BJ":"fr-Latn-BJ","und-BL":"fr-Latn-BL","und-BN":"ms-Latn-BN","und-BO":"es-Latn-BO","und-Bopo":"zh-Bopo-TW","und-BQ":"pap-Latn-BQ","und-BR":"pt-Latn-BR","und-Brah":"pka-Brah-IN","und-Brai":"fr-Brai-FR","und-BT":"dz-Tibt-BT","und-Bugi":"bug-Bugi-ID","und-Buhd":"bku-Buhd-PH","und-BV":"und-Latn-BV","und-BY":"be-Cyrl-BY","und-Cakm":"ccp-Cakm-BD","und-Cans":"cr-Cans-CA","und-Cari":"xcr-Cari-TR","und-CD":"sw-Latn-CD","und-CF":"fr-Latn-CF","und-CG":"fr-Latn-CG","und-CH":"de-Latn-CH","und-Cham":"cjm-Cham-VN","und-Cher":"chr-Cher-US","und-CI":"fr-Latn-CI","und-CL":"es-Latn-CL","und-CM":"fr-Latn-CM","und-CN":"zh-Hans-CN","und-CO":"es-Latn-CO","und-Copt":"cop-Copt-EG","und-CP":"und-Latn-CP","und-Cprt":"grc-Cprt-CY","und-CR":"es-Latn-CR","und-CU":"es-Latn-CU","und-CV":"pt-Latn-CV","und-CW":"pap-Latn-CW","und-CY":"el-Grek-CY","und-Cyrl":"ru-Cyrl-RU","und-Cyrl-AL":"mk-Cyrl-AL","und-Cyrl-BA":"sr-Cyrl-BA","und-Cyrl-GE":"ab-Cyrl-GE","und-Cyrl-GR":"mk-Cyrl-GR","und-Cyrl-MD":"uk-Cyrl-MD","und-Cyrl-RO":"bg-Cyrl-RO","und-Cyrl-SK":"uk-Cyrl-SK","und-Cyrl-TR":"kbd-Cyrl-TR","und-Cyrl-XK":"sr-Cyrl-XK","und-CZ":"cs-Latn-CZ","und-DE":"de-Latn-DE","und-Deva":"hi-Deva-IN","und-Deva-BT":"ne-Deva-BT","und-Deva-FJ":"hif-Deva-FJ","und-Deva-MU":"bho-Deva-MU","und-Deva-PK":"btv-Deva-PK","und-DJ":"aa-Latn-DJ","und-DK":"da-Latn-DK","und-DO":"es-Latn-DO","und-Dogr":"doi-Dogr-IN","und-Dupl":"fr-Dupl-FR","und-DZ":"ar-Arab-DZ","und-EA":"es-Latn-EA","und-EC":"es-Latn-EC","und-EE":"et-Latn-EE","und-EG":"ar-Arab-EG","und-Egyp":"egy-Egyp-EG","und-EH":"ar-Arab-EH","und-Elba":"sq-Elba-AL","und-Elym":"arc-Elym-IR","und-ER":"ti-Ethi-ER","und-ES":"es-Latn-ES","und-ET":"am-Ethi-ET","und-Ethi":"am-Ethi-ET","und-EU":"en-Latn-GB","und-EZ":"de-Latn-EZ","und-FI":"fi-Latn-FI","und-FO":"fo-Latn-FO","und-FR":"fr-Latn-FR","und-GA":"fr-Latn-GA","und-GE":"ka-Geor-GE","und-Geor":"ka-Geor-GE","und-GF":"fr-Latn-GF","und-GH":"ak-Latn-GH","und-GL":"kl-Latn-GL","und-Glag":"cu-Glag-BG","und-GN":"fr-Latn-GN","und-Gong":"wsg-Gong-IN","und-Gonm":"esg-Gonm-IN","und-Goth":"got-Goth-UA","und-GP":"fr-Latn-GP","und-GQ":"es-Latn-GQ","und-GR":"el-Grek-GR","und-Gran":"sa-Gran-IN","und-Grek":"el-Grek-GR","und-Grek-TR":"bgx-Grek-TR","und-GS":"und-Latn-GS","und-GT":"es-Latn-GT","und-Gujr":"gu-Gujr-IN","und-Guru":"pa-Guru-IN","und-GW":"pt-Latn-GW","und-Hanb":"zh-Hanb-TW","und-Hang":"ko-Hang-KR","und-Hani":"zh-Hani-CN","und-Hano":"hnn-Hano-PH","und-Hans":"zh-Hans-CN","und-Hant":"zh-Hant-TW","und-Hatr":"mis-Hatr-IQ","und-Hebr":"he-Hebr-IL","und-Hebr-CA":"yi-Hebr-CA","und-Hebr-GB":"yi-Hebr-GB","und-Hebr-SE":"yi-Hebr-SE","und-Hebr-UA":"yi-Hebr-UA","und-Hebr-US":"yi-Hebr-US","und-Hira":"ja-Hira-JP","und-HK":"zh-Hant-HK","und-Hluw":"hlu-Hluw-TR","und-HM":"und-Latn-HM","und-Hmng":"hnj-Hmng-LA","und-Hmnp":"mww-Hmnp-US","und-HN":"es-Latn-HN","und-HR":"hr-Latn-HR","und-HT":"ht-Latn-HT","und-HU":"hu-Latn-HU","und-Hung":"hu-Hung-HU","und-IC":"es-Latn-IC","und-ID":"id-Latn-ID","und-IL":"he-Hebr-IL","und-IN":"hi-Deva-IN","und-IQ":"ar-Arab-IQ","und-IR":"fa-Arab-IR","und-IS":"is-Latn-IS","und-IT":"it-Latn-IT","und-Ital":"ett-Ital-IT","und-Jamo":"ko-Jamo-KR","und-Java":"jv-Java-ID","und-JO":"ar-Arab-JO","und-JP":"ja-Jpan-JP","und-Jpan":"ja-Jpan-JP","und-Kali":"eky-Kali-MM","und-Kana":"ja-Kana-JP","und-KE":"sw-Latn-KE","und-KG":"ky-Cyrl-KG","und-KH":"km-Khmr-KH","und-Khar":"pra-Khar-PK","und-Khmr":"km-Khmr-KH","und-Khoj":"sd-Khoj-IN","und-KM":"ar-Arab-KM","und-Knda":"kn-Knda-IN","und-Kore":"ko-Kore-KR","und-KP":"ko-Kore-KP","und-KR":"ko-Kore-KR","und-Kthi":"bho-Kthi-IN","und-KW":"ar-Arab-KW","und-KZ":"ru-Cyrl-KZ","und-LA":"lo-Laoo-LA","und-Lana":"nod-Lana-TH","und-Laoo":"lo-Laoo-LA","und-Latn-AF":"tk-Latn-AF","und-Latn-AM":"ku-Latn-AM","und-Latn-CN":"za-Latn-CN","und-Latn-CY":"tr-Latn-CY","und-Latn-DZ":"fr-Latn-DZ","und-Latn-ET":"en-Latn-ET","und-Latn-GE":"ku-Latn-GE","und-Latn-IR":"tk-Latn-IR","und-Latn-KM":"fr-Latn-KM","und-Latn-MA":"fr-Latn-MA","und-Latn-MK":"sq-Latn-MK","und-Latn-MM":"kac-Latn-MM","und-Latn-MO":"pt-Latn-MO","und-Latn-MR":"fr-Latn-MR","und-Latn-RU":"krl-Latn-RU","und-Latn-SY":"fr-Latn-SY","und-Latn-TN":"fr-Latn-TN","und-Latn-TW":"trv-Latn-TW","und-Latn-UA":"pl-Latn-UA","und-LB":"ar-Arab-LB","und-Lepc":"lep-Lepc-IN","und-LI":"de-Latn-LI","und-Limb":"lif-Limb-IN","und-Lina":"lab-Lina-GR","und-Linb":"grc-Linb-GR","und-Lisu":"lis-Lisu-CN","und-LK":"si-Sinh-LK","und-LS":"st-Latn-LS","und-LT":"lt-Latn-LT","und-LU":"fr-Latn-LU","und-LV":"lv-Latn-LV","und-LY":"ar-Arab-LY","und-Lyci":"xlc-Lyci-TR","und-Lydi":"xld-Lydi-TR","und-MA":"ar-Arab-MA","und-Mahj":"hi-Mahj-IN","und-Maka":"mak-Maka-ID","und-Mand":"myz-Mand-IR","und-Mani":"xmn-Mani-CN","und-Marc":"bo-Marc-CN","und-MC":"fr-Latn-MC","und-MD":"ro-Latn-MD","und-ME":"sr-Latn-ME","und-Medf":"mis-Medf-NG","und-Mend":"men-Mend-SL","und-Merc":"xmr-Merc-SD","und-Mero":"xmr-Mero-SD","und-MF":"fr-Latn-MF","und-MG":"mg-Latn-MG","und-MK":"mk-Cyrl-MK","und-ML":"bm-Latn-ML","und-Mlym":"ml-Mlym-IN","und-MM":"my-Mymr-MM","und-MN":"mn-Cyrl-MN","und-MO":"zh-Hant-MO","und-Modi":"mr-Modi-IN","und-Mong":"mn-Mong-CN","und-MQ":"fr-Latn-MQ","und-MR":"ar-Arab-MR","und-Mroo":"mro-Mroo-BD","und-MT":"mt-Latn-MT","und-Mtei":"mni-Mtei-IN","und-MU":"mfe-Latn-MU","und-Mult":"skr-Mult-PK","und-MV":"dv-Thaa-MV","und-MX":"es-Latn-MX","und-MY":"ms-Latn-MY","und-Mymr":"my-Mymr-MM","und-Mymr-IN":"kht-Mymr-IN","und-Mymr-TH":"mnw-Mymr-TH","und-MZ":"pt-Latn-MZ","und-NA":"af-Latn-NA","und-Nand":"sa-Nand-IN","und-Narb":"xna-Narb-SA","und-Nbat":"arc-Nbat-JO","und-NC":"fr-Latn-NC","und-NE":"ha-Latn-NE","und-Newa":"new-Newa-NP","und-NI":"es-Latn-NI","und-Nkoo":"man-Nkoo-GN","und-NL":"nl-Latn-NL","und-NO":"nb-Latn-NO","und-NP":"ne-Deva-NP","und-Nshu":"zhx-Nshu-CN","und-Ogam":"sga-Ogam-IE","und-Olck":"sat-Olck-IN","und-OM":"ar-Arab-OM","und-Orkh":"otk-Orkh-MN","und-Orya":"or-Orya-IN","und-Osge":"osa-Osge-US","und-Osma":"so-Osma-SO","und-PA":"es-Latn-PA","und-Palm":"arc-Palm-SY","und-Pauc":"ctd-Pauc-MM","und-PE":"es-Latn-PE","und-Perm":"kv-Perm-RU","und-PF":"fr-Latn-PF","und-PG":"tpi-Latn-PG","und-PH":"fil-Latn-PH","und-Phag":"lzh-Phag-CN","und-Phli":"pal-Phli-IR","und-Phlp":"pal-Phlp-CN","und-Phnx":"phn-Phnx-LB","und-PK":"ur-Arab-PK","und-PL":"pl-Latn-PL","und-Plrd":"hmd-Plrd-CN","und-PM":"fr-Latn-PM","und-PR":"es-Latn-PR","und-Prti":"xpr-Prti-IR","und-PS":"ar-Arab-PS","und-PT":"pt-Latn-PT","und-PW":"pau-Latn-PW","und-PY":"gn-Latn-PY","und-QA":"ar-Arab-QA","und-QO":"en-Latn-DG","und-RE":"fr-Latn-RE","und-Rjng":"rej-Rjng-ID","und-RO":"ro-Latn-RO","und-Rohg":"rhg-Rohg-MM","und-RS":"sr-Cyrl-RS","und-RU":"ru-Cyrl-RU","und-Runr":"non-Runr-SE","und-RW":"rw-Latn-RW","und-SA":"ar-Arab-SA","und-Samr":"smp-Samr-IL","und-Sarb":"xsa-Sarb-YE","und-Saur":"saz-Saur-IN","und-SC":"fr-Latn-SC","und-SD":"ar-Arab-SD","und-SE":"sv-Latn-SE","und-Sgnw":"ase-Sgnw-US","und-Shaw":"en-Shaw-GB","und-Shrd":"sa-Shrd-IN","und-SI":"sl-Latn-SI","und-Sidd":"sa-Sidd-IN","und-Sind":"sd-Sind-IN","und-Sinh":"si-Sinh-LK","und-SJ":"nb-Latn-SJ","und-SK":"sk-Latn-SK","und-SM":"it-Latn-SM","und-SN":"fr-Latn-SN","und-SO":"so-Latn-SO","und-Sogd":"sog-Sogd-UZ","und-Sogo":"sog-Sogo-UZ","und-Sora":"srb-Sora-IN","und-Soyo":"cmg-Soyo-MN","und-SR":"nl-Latn-SR","und-ST":"pt-Latn-ST","und-Sund":"su-Sund-ID","und-SV":"es-Latn-SV","und-SY":"ar-Arab-SY","und-Sylo":"syl-Sylo-BD","und-Syrc":"syr-Syrc-IQ","und-Tagb":"tbw-Tagb-PH","und-Takr":"doi-Takr-IN","und-Tale":"tdd-Tale-CN","und-Talu":"khb-Talu-CN","und-Taml":"ta-Taml-IN","und-Tang":"txg-Tang-CN","und-Tavt":"blt-Tavt-VN","und-TD":"fr-Latn-TD","und-Telu":"te-Telu-IN","und-TF":"fr-Latn-TF","und-Tfng":"zgh-Tfng-MA","und-TG":"fr-Latn-TG","und-Tglg":"fil-Tglg-PH","und-TH":"th-Thai-TH","und-Thaa":"dv-Thaa-MV","und-Thai":"th-Thai-TH","und-Thai-CN":"lcp-Thai-CN","und-Thai-KH":"kdt-Thai-KH","und-Thai-LA":"kdt-Thai-LA","und-Tibt":"bo-Tibt-CN","und-Tirh":"mai-Tirh-IN","und-TJ":"tg-Cyrl-TJ","und-TK":"tkl-Latn-TK","und-TL":"pt-Latn-TL","und-TM":"tk-Latn-TM","und-TN":"ar-Arab-TN","und-TO":"to-Latn-TO","und-TR":"tr-Latn-TR","und-TV":"tvl-Latn-TV","und-TW":"zh-Hant-TW","und-TZ":"sw-Latn-TZ","und-UA":"uk-Cyrl-UA","und-UG":"sw-Latn-UG","und-Ugar":"uga-Ugar-SY","und-UY":"es-Latn-UY","und-UZ":"uz-Latn-UZ","und-VA":"it-Latn-VA","und-Vaii":"vai-Vaii-LR","und-VE":"es-Latn-VE","und-VN":"vi-Latn-VN","und-VU":"bi-Latn-VU","und-Wara":"hoc-Wara-IN","und-Wcho":"nnp-Wcho-IN","und-WF":"fr-Latn-WF","und-WS":"sm-Latn-WS","und-XK":"sq-Latn-XK","und-Xpeo":"peo-Xpeo-IR","und-Xsux":"akk-Xsux-IQ","und-YE":"ar-Arab-YE","und-Yiii":"ii-Yiii-CN","und-YT":"fr-Latn-YT","und-Zanb":"cmg-Zanb-MN","und-ZW":"sn-Latn-ZW",unr:"unr-Beng-IN","unr-Deva":"unr-Deva-NP","unr-NP":"unr-Deva-NP",unx:"unx-Beng-IN",uok:"uok-Latn-ZZ",ur:"ur-Arab-PK",uri:"uri-Latn-ZZ",urt:"urt-Latn-ZZ",urw:"urw-Latn-ZZ",usa:"usa-Latn-ZZ",utr:"utr-Latn-ZZ",uvh:"uvh-Latn-ZZ",uvl:"uvl-Latn-ZZ",uz:"uz-Latn-UZ","uz-AF":"uz-Arab-AF","uz-Arab":"uz-Arab-AF","uz-CN":"uz-Cyrl-CN",vag:"vag-Latn-ZZ",vai:"vai-Vaii-LR",van:"van-Latn-ZZ",ve:"ve-Latn-ZA",vec:"vec-Latn-IT",vep:"vep-Latn-RU",vi:"vi-Latn-VN",vic:"vic-Latn-SX",viv:"viv-Latn-ZZ",vls:"vls-Latn-BE",vmf:"vmf-Latn-DE",vmw:"vmw-Latn-MZ",vo:"vo-Latn-001",vot:"vot-Latn-RU",vro:"vro-Latn-EE",vun:"vun-Latn-TZ",vut:"vut-Latn-ZZ",wa:"wa-Latn-BE",wae:"wae-Latn-CH",waj:"waj-Latn-ZZ",wal:"wal-Ethi-ET",wan:"wan-Latn-ZZ",war:"war-Latn-PH",wbp:"wbp-Latn-AU",wbq:"wbq-Telu-IN",wbr:"wbr-Deva-IN",wci:"wci-Latn-ZZ",wer:"wer-Latn-ZZ",wgi:"wgi-Latn-ZZ",whg:"whg-Latn-ZZ",wib:"wib-Latn-ZZ",wiu:"wiu-Latn-ZZ",wiv:"wiv-Latn-ZZ",wja:"wja-Latn-ZZ",wji:"wji-Latn-ZZ",wls:"wls-Latn-WF",wmo:"wmo-Latn-ZZ",wnc:"wnc-Latn-ZZ",wni:"wni-Arab-KM",wnu:"wnu-Latn-ZZ",wo:"wo-Latn-SN",wob:"wob-Latn-ZZ",wos:"wos-Latn-ZZ",wrs:"wrs-Latn-ZZ",wsg:"wsg-Gong-IN",wsk:"wsk-Latn-ZZ",wtm:"wtm-Deva-IN",wuu:"wuu-Hans-CN",wuv:"wuv-Latn-ZZ",wwa:"wwa-Latn-ZZ",xav:"xav-Latn-BR",xbi:"xbi-Latn-ZZ",xcr:"xcr-Cari-TR",xes:"xes-Latn-ZZ",xh:"xh-Latn-ZA",xla:"xla-Latn-ZZ",xlc:"xlc-Lyci-TR",xld:"xld-Lydi-TR",xmf:"xmf-Geor-GE",xmn:"xmn-Mani-CN",xmr:"xmr-Merc-SD",xna:"xna-Narb-SA",xnr:"xnr-Deva-IN",xog:"xog-Latn-UG",xon:"xon-Latn-ZZ",xpr:"xpr-Prti-IR",xrb:"xrb-Latn-ZZ",xsa:"xsa-Sarb-YE",xsi:"xsi-Latn-ZZ",xsm:"xsm-Latn-ZZ",xsr:"xsr-Deva-NP",xwe:"xwe-Latn-ZZ",yam:"yam-Latn-ZZ",yao:"yao-Latn-MZ",yap:"yap-Latn-FM",yas:"yas-Latn-ZZ",yat:"yat-Latn-ZZ",yav:"yav-Latn-CM",yay:"yay-Latn-ZZ",yaz:"yaz-Latn-ZZ",yba:"yba-Latn-ZZ",ybb:"ybb-Latn-CM",yby:"yby-Latn-ZZ",yer:"yer-Latn-ZZ",ygr:"ygr-Latn-ZZ",ygw:"ygw-Latn-ZZ",yi:"yi-Hebr-001",yko:"yko-Latn-ZZ",yle:"yle-Latn-ZZ",ylg:"ylg-Latn-ZZ",yll:"yll-Latn-ZZ",yml:"yml-Latn-ZZ",yo:"yo-Latn-NG",yon:"yon-Latn-ZZ",yrb:"yrb-Latn-ZZ",yre:"yre-Latn-ZZ",yrl:"yrl-Latn-BR",yss:"yss-Latn-ZZ",yua:"yua-Latn-MX",yue:"yue-Hant-HK","yue-CN":"yue-Hans-CN","yue-Hans":"yue-Hans-CN",yuj:"yuj-Latn-ZZ",yut:"yut-Latn-ZZ",yuw:"yuw-Latn-ZZ",za:"za-Latn-CN",zag:"zag-Latn-SD",zdj:"zdj-Arab-KM",zea:"zea-Latn-NL",zgh:"zgh-Tfng-MA",zh:"zh-Hans-CN","zh-AU":"zh-Hant-AU","zh-BN":"zh-Hant-BN","zh-Bopo":"zh-Bopo-TW","zh-GB":"zh-Hant-GB","zh-GF":"zh-Hant-GF","zh-Hanb":"zh-Hanb-TW","zh-Hant":"zh-Hant-TW","zh-HK":"zh-Hant-HK","zh-ID":"zh-Hant-ID","zh-MO":"zh-Hant-MO","zh-MY":"zh-Hant-MY","zh-PA":"zh-Hant-PA","zh-PF":"zh-Hant-PF","zh-PH":"zh-Hant-PH","zh-SR":"zh-Hant-SR","zh-TH":"zh-Hant-TH","zh-TW":"zh-Hant-TW","zh-US":"zh-Hant-US","zh-VN":"zh-Hant-VN",zhx:"zhx-Nshu-CN",zia:"zia-Latn-ZZ",zlm:"zlm-Latn-TG",zmi:"zmi-Latn-MY",zne:"zne-Latn-ZZ",zu:"zu-Latn-ZA",zza:"zza-Latn-TR"},timeData:{AX:{_allowed:"H",_preferred:"H"},BQ:{_allowed:"H",_preferred:"H"},CP:{_allowed:"H",_preferred:"H"},CZ:{_allowed:"H",_preferred:"H"},DK:{_allowed:"H",_preferred:"H"},FI:{_allowed:"H",_preferred:"H"},ID:{_allowed:"H",_preferred:"H"},IS:{_allowed:"H",_preferred:"H"},ML:{_allowed:"H",_preferred:"H"},NE:{_allowed:"H",_preferred:"H"},RU:{_allowed:"H",_preferred:"H"},SE:{_allowed:"H",_preferred:"H"},SJ:{_allowed:"H",_preferred:"H"},SK:{_allowed:"H",_preferred:"H"},AS:{_allowed:"h H",_preferred:"h"},BT:{_allowed:"h H",_preferred:"h"},DJ:{_allowed:"h H",_preferred:"h"},ER:{_allowed:"h H",_preferred:"h"},GH:{_allowed:"h H",_preferred:"h"},IN:{_allowed:"h H",_preferred:"h"},LS:{_allowed:"h H",_preferred:"h"},PG:{_allowed:"h H",_preferred:"h"},PW:{_allowed:"h H",_preferred:"h"},SO:{_allowed:"h H",_preferred:"h"},TO:{_allowed:"h H",_preferred:"h"},VU:{_allowed:"h H",_preferred:"h"},WS:{_allowed:"h H",_preferred:"h"},"001":{_allowed:"H h",_preferred:"H"},AL:{_allowed:"h H hB",_preferred:"h"},TD:{_allowed:"h H hB",_preferred:"h"},ca_ES:{_allowed:"H h hB",_preferred:"H"},CF:{_allowed:"H h hB",_preferred:"H"},CM:{_allowed:"H h hB",_preferred:"H"},fr_CA:{_allowed:"H h hB",_preferred:"H"},gl_ES:{_allowed:"H h hB",_preferred:"H"},it_CH:{_allowed:"H h hB",_preferred:"H"},it_IT:{_allowed:"H h hB",_preferred:"H"},LU:{_allowed:"H h hB",_preferred:"H"},NP:{_allowed:"H h hB",_preferred:"H"},PF:{_allowed:"H h hB",_preferred:"H"},SC:{_allowed:"H h hB",_preferred:"H"},SM:{_allowed:"H h hB",_preferred:"H"},SN:{_allowed:"H h hB",_preferred:"H"},TF:{_allowed:"H h hB",_preferred:"H"},VA:{_allowed:"H h hB",_preferred:"H"},CY:{_allowed:"h H hb hB",_preferred:"h"},GR:{_allowed:"h H hb hB",_preferred:"h"},CO:{_allowed:"h H hB hb",_preferred:"h"},DO:{_allowed:"h H hB hb",_preferred:"h"},KP:{_allowed:"h H hB hb",_preferred:"h"},KR:{_allowed:"h H hB hb",_preferred:"h"},NA:{_allowed:"h H hB hb",_preferred:"h"},PA:{_allowed:"h H hB hb",_preferred:"h"},PR:{_allowed:"h H hB hb",_preferred:"h"},VE:{_allowed:"h H hB hb",_preferred:"h"},AC:{_allowed:"H h hb hB",_preferred:"H"},AI:{_allowed:"H h hb hB",_preferred:"H"},BW:{_allowed:"H h hb hB",_preferred:"H"},BZ:{_allowed:"H h hb hB",_preferred:"H"},CC:{_allowed:"H h hb hB",_preferred:"H"},CK:{_allowed:"H h hb hB",_preferred:"H"},CX:{_allowed:"H h hb hB",_preferred:"H"},DG:{_allowed:"H h hb hB",_preferred:"H"},FK:{_allowed:"H h hb hB",_preferred:"H"},GB:{_allowed:"H h hb hB",_preferred:"H"},GG:{_allowed:"H h hb hB",_preferred:"H"},GI:{_allowed:"H h hb hB",_preferred:"H"},IE:{_allowed:"H h hb hB",_preferred:"H"},IM:{_allowed:"H h hb hB",_preferred:"H"},IO:{_allowed:"H h hb hB",_preferred:"H"},JE:{_allowed:"H h hb hB",_preferred:"H"},LT:{_allowed:"H h hb hB",_preferred:"H"},MK:{_allowed:"H h hb hB",_preferred:"H"},MN:{_allowed:"H h hb hB",_preferred:"H"},MS:{_allowed:"H h hb hB",_preferred:"H"},NF:{_allowed:"H h hb hB",_preferred:"H"},NG:{_allowed:"H h hb hB",_preferred:"H"},NR:{_allowed:"H h hb hB",_preferred:"H"},NU:{_allowed:"H h hb hB",_preferred:"H"},PN:{_allowed:"H h hb hB",_preferred:"H"},SH:{_allowed:"H h hb hB",_preferred:"H"},SX:{_allowed:"H h hb hB",_preferred:"H"},TA:{_allowed:"H h hb hB",_preferred:"H"},ZA:{_allowed:"H h hb hB",_preferred:"H"},af_ZA:{_allowed:"H h hB hb",_preferred:"H"},AR:{_allowed:"H h hB hb",_preferred:"H"},CL:{_allowed:"H h hB hb",_preferred:"H"},CR:{_allowed:"H h hB hb",_preferred:"H"},CU:{_allowed:"H h hB hb",_preferred:"H"},EA:{_allowed:"H h hB hb",_preferred:"H"},es_BO:{_allowed:"H h hB hb",_preferred:"H"},es_BR:{_allowed:"H h hB hb",_preferred:"H"},es_EC:{_allowed:"H h hB hb",_preferred:"H"},es_ES:{_allowed:"H h hB hb",_preferred:"H"},es_GQ:{_allowed:"H h hB hb",_preferred:"H"},es_PE:{_allowed:"H h hB hb",_preferred:"H"},GT:{_allowed:"H h hB hb",_preferred:"H"},HN:{_allowed:"H h hB hb",_preferred:"H"},IC:{_allowed:"H h hB hb",_preferred:"H"},KG:{_allowed:"H h hB hb",_preferred:"H"},KM:{_allowed:"H h hB hb",_preferred:"H"},LK:{_allowed:"H h hB hb",_preferred:"H"},MA:{_allowed:"H h hB hb",_preferred:"H"},MX:{_allowed:"H h hB hb",_preferred:"H"},NI:{_allowed:"H h hB hb",_preferred:"H"},PY:{_allowed:"H h hB hb",_preferred:"H"},SV:{_allowed:"H h hB hb",_preferred:"H"},UY:{_allowed:"H h hB hb",_preferred:"H"},JP:{_allowed:"H h K",_preferred:"H"},AD:{_allowed:"H hB",_preferred:"H"},AM:{_allowed:"H hB",_preferred:"H"},AO:{_allowed:"H hB",_preferred:"H"},AT:{_allowed:"H hB",_preferred:"H"},AW:{_allowed:"H hB",_preferred:"H"},BE:{_allowed:"H hB",_preferred:"H"},BF:{_allowed:"H hB",_preferred:"H"},BJ:{_allowed:"H hB",_preferred:"H"},BL:{_allowed:"H hB",_preferred:"H"},BR:{_allowed:"H hB",_preferred:"H"},CG:{_allowed:"H hB",_preferred:"H"},CI:{_allowed:"H hB",_preferred:"H"},CV:{_allowed:"H hB",_preferred:"H"},DE:{_allowed:"H hB",_preferred:"H"},EE:{_allowed:"H hB",_preferred:"H"},FR:{_allowed:"H hB",_preferred:"H"},GA:{_allowed:"H hB",_preferred:"H"},GF:{_allowed:"H hB",_preferred:"H"},GN:{_allowed:"H hB",_preferred:"H"},GP:{_allowed:"H hB",_preferred:"H"},GW:{_allowed:"H hB",_preferred:"H"},HR:{_allowed:"H hB",_preferred:"H"},IL:{_allowed:"H hB",_preferred:"H"},IT:{_allowed:"H hB",_preferred:"H"},KZ:{_allowed:"H hB",_preferred:"H"},MC:{_allowed:"H hB",_preferred:"H"},MD:{_allowed:"H hB",_preferred:"H"},MF:{_allowed:"H hB",_preferred:"H"},MQ:{_allowed:"H hB",_preferred:"H"},MZ:{_allowed:"H hB",_preferred:"H"},NC:{_allowed:"H hB",_preferred:"H"},NL:{_allowed:"H hB",_preferred:"H"},PM:{_allowed:"H hB",_preferred:"H"},PT:{_allowed:"H hB",_preferred:"H"},RE:{_allowed:"H hB",_preferred:"H"},RO:{_allowed:"H hB",_preferred:"H"},SI:{_allowed:"H hB",_preferred:"H"},SR:{_allowed:"H hB",_preferred:"H"},ST:{_allowed:"H hB",_preferred:"H"},TG:{_allowed:"H hB",_preferred:"H"},TR:{_allowed:"H hB",_preferred:"H"},WF:{_allowed:"H hB",_preferred:"H"},YT:{_allowed:"H hB",_preferred:"H"},BD:{_allowed:"h hB H",_preferred:"h"},PK:{_allowed:"h hB H",_preferred:"h"},AZ:{_allowed:"H hB h",_preferred:"H"},BA:{_allowed:"H hB h",_preferred:"H"},BG:{_allowed:"H hB h",_preferred:"H"},CH:{_allowed:"H hB h",_preferred:"H"},GE:{_allowed:"H hB h",_preferred:"H"},LI:{_allowed:"H hB h",_preferred:"H"},ME:{_allowed:"H hB h",_preferred:"H"},RS:{_allowed:"H hB h",_preferred:"H"},UA:{_allowed:"H hB h",_preferred:"H"},UZ:{_allowed:"H hB h",_preferred:"H"},XK:{_allowed:"H hB h",_preferred:"H"},AG:{_allowed:"h hb H hB",_preferred:"h"},AU:{_allowed:"h hb H hB",_preferred:"h"},BB:{_allowed:"h hb H hB",_preferred:"h"},BM:{_allowed:"h hb H hB",_preferred:"h"},BS:{_allowed:"h hb H hB",_preferred:"h"},CA:{_allowed:"h hb H hB",_preferred:"h"},DM:{_allowed:"h hb H hB",_preferred:"h"},en_001:{_allowed:"h hb H hB",_preferred:"h"},FJ:{_allowed:"h hb H hB",_preferred:"h"},FM:{_allowed:"h hb H hB",_preferred:"h"},GD:{_allowed:"h hb H hB",_preferred:"h"},GM:{_allowed:"h hb H hB",_preferred:"h"},GU:{_allowed:"h hb H hB",_preferred:"h"},GY:{_allowed:"h hb H hB",_preferred:"h"},JM:{_allowed:"h hb H hB",_preferred:"h"},KI:{_allowed:"h hb H hB",_preferred:"h"},KN:{_allowed:"h hb H hB",_preferred:"h"},KY:{_allowed:"h hb H hB",_preferred:"h"},LC:{_allowed:"h hb H hB",_preferred:"h"},LR:{_allowed:"h hb H hB",_preferred:"h"},MH:{_allowed:"h hb H hB",_preferred:"h"},MP:{_allowed:"h hb H hB",_preferred:"h"},MW:{_allowed:"h hb H hB",_preferred:"h"},NZ:{_allowed:"h hb H hB",_preferred:"h"},SB:{_allowed:"h hb H hB",_preferred:"h"},SG:{_allowed:"h hb H hB",_preferred:"h"},SL:{_allowed:"h hb H hB",_preferred:"h"},SS:{_allowed:"h hb H hB",_preferred:"h"},SZ:{_allowed:"h hb H hB",_preferred:"h"},TC:{_allowed:"h hb H hB",_preferred:"h"},TT:{_allowed:"h hb H hB",_preferred:"h"},UM:{_allowed:"h hb H hB",_preferred:"h"},US:{_allowed:"h hb H hB",_preferred:"h"},VC:{_allowed:"h hb H hB",_preferred:"h"},VG:{_allowed:"h hb H hB",_preferred:"h"},VI:{_allowed:"h hb H hB",_preferred:"h"},ZM:{_allowed:"h hb H hB",_preferred:"h"},BO:{_allowed:"H hB h hb",_preferred:"H"},EC:{_allowed:"H hB h hb",_preferred:"H"},ES:{_allowed:"H hB h hb",_preferred:"H"},GQ:{_allowed:"H hB h hb",_preferred:"H"},PE:{_allowed:"H hB h hb",_preferred:"H"},AE:{_allowed:"h hB hb H",_preferred:"h"},ar_001:{_allowed:"h hB hb H",_preferred:"h"},BH:{_allowed:"h hB hb H",_preferred:"h"},DZ:{_allowed:"h hB hb H",_preferred:"h"},EG:{_allowed:"h hB hb H",_preferred:"h"},EH:{_allowed:"h hB hb H",_preferred:"h"},IQ:{_allowed:"h hB hb H",_preferred:"h"},JO:{_allowed:"h hB hb H",_preferred:"h"},KW:{_allowed:"h hB hb H",_preferred:"h"},LB:{_allowed:"h hB hb H",_preferred:"h"},LY:{_allowed:"h hB hb H",_preferred:"h"},MR:{_allowed:"h hB hb H",_preferred:"h"},OM:{_allowed:"h hB hb H",_preferred:"h"},PH:{_allowed:"h hB hb H",_preferred:"h"},PS:{_allowed:"h hB hb H",_preferred:"h"},QA:{_allowed:"h hB hb H",_preferred:"h"},SA:{_allowed:"h hB hb H",_preferred:"h"},SD:{_allowed:"h hB hb H",_preferred:"h"},SY:{_allowed:"h hB hb H",_preferred:"h"},TN:{_allowed:"h hB hb H",_preferred:"h"},YE:{_allowed:"h hB hb H",_preferred:"h"},AF:{_allowed:"H hb hB h",_preferred:"H"},LA:{_allowed:"H hb hB h",_preferred:"H"},LV:{_allowed:"H hB hb h",_preferred:"H"},TL:{_allowed:"H hB hb h",_preferred:"H"},zu_ZA:{_allowed:"H hB hb h",_preferred:"H"},CD:{_allowed:"hB H",_preferred:"H"},IR:{_allowed:"hB H",_preferred:"H"},hi_IN:{_allowed:"hB h H",_preferred:"h"},kn_IN:{_allowed:"hB h H",_preferred:"h"},ml_IN:{_allowed:"hB h H",_preferred:"h"},te_IN:{_allowed:"hB h H",_preferred:"h"},KH:{_allowed:"hB h H hb",_preferred:"h"},ta_IN:{_allowed:"hB h hb H",_preferred:"h"},BN:{_allowed:"hb hB h H",_preferred:"h"},MY:{_allowed:"hb hB h H",_preferred:"h"},CN:{_allowed:"hB hb h H",_preferred:"h"},ET:{_allowed:"hB hb h H",_preferred:"h"},gu_IN:{_allowed:"hB hb h H",_preferred:"h"},HK:{_allowed:"hB hb h H",_preferred:"h"},MO:{_allowed:"hB hb h H",_preferred:"h"},mr_IN:{_allowed:"hB hb h H",_preferred:"h"},pa_IN:{_allowed:"hB hb h H",_preferred:"h"},TW:{_allowed:"hB hb h H",_preferred:"h"},KE:{_allowed:"hB hb H h",_preferred:"H"},MM:{_allowed:"hB hb H h",_preferred:"H"},TZ:{_allowed:"hB hb H h",_preferred:"H"},UG:{_allowed:"hB hb H h",_preferred:"H"}},weekData:{minDays:{"001":"1",AD:"4",AN:"4",AT:"4",AX:"4",BE:"4",BG:"4",CH:"4",CZ:"4",DE:"4",DK:"4",EE:"4",ES:"4",FI:"4",FJ:"4",FO:"4",FR:"4",GB:"4",GF:"4",GG:"4",GI:"4",GP:"4",GR:"4",GU:"1",HU:"4",IE:"4",IM:"4",IS:"4",IT:"4",JE:"4",LI:"4",LT:"4",LU:"4",MC:"4",MQ:"4",NL:"4",NO:"4",PL:"4",PT:"4",RE:"4",RU:"4",SE:"4",SJ:"4",SK:"4",SM:"4",UM:"1",US:"1",VA:"4",VI:"1"},firstDay:{"001":"mon",AD:"mon",AE:"sat",AF:"sat",AG:"sun",AI:"mon",AL:"mon",AM:"mon",AN:"mon",AR:"mon",AS:"sun",AT:"mon",AU:"sun",AX:"mon",AZ:"mon",BA:"mon",BD:"sun",BE:"mon",BG:"mon",BH:"sat",BM:"mon",BN:"mon",BR:"sun",BS:"sun",BT:"sun",BW:"sun",BY:"mon",BZ:"sun",CA:"sun",CH:"mon",CL:"mon",CM:"mon",CN:"sun",CO:"sun",CR:"mon",CY:"mon",CZ:"mon",DE:"mon",DJ:"sat",DK:"mon",DM:"sun",DO:"sun",DZ:"sat",EC:"mon",EE:"mon",EG:"sat",ES:"mon",ET:"sun",FI:"mon",FJ:"mon",FO:"mon",FR:"mon",GB:"mon","GB-alt-variant":"sun",GE:"mon",GF:"mon",GP:"mon",GR:"mon",GT:"sun",GU:"sun",HK:"sun",HN:"sun",HR:"mon",HU:"mon",ID:"sun",IE:"mon",IL:"sun",IN:"sun",IQ:"sat",IR:"sat",IS:"mon",IT:"mon",JM:"sun",JO:"sat",JP:"sun",KE:"sun",KG:"mon",KH:"sun",KR:"sun",KW:"sat",KZ:"mon",LA:"sun",LB:"mon",LI:"mon",LK:"mon",LT:"mon",LU:"mon",LV:"mon",LY:"sat",MC:"mon",MD:"mon",ME:"mon",MH:"sun",MK:"mon",MM:"sun",MN:"mon",MO:"sun",MQ:"mon",MT:"sun",MV:"fri",MX:"sun",MY:"mon",MZ:"sun",NI:"sun",NL:"mon",NO:"mon",NP:"sun",NZ:"mon",OM:"sat",PA:"sun",PE:"sun",PH:"sun",PK:"sun",PL:"mon",PR:"sun",PT:"sun",PY:"sun",QA:"sat",RE:"mon",RO:"mon",RS:"mon",RU:"mon",SA:"sun",SD:"sat",SE:"mon",SG:"sun",SI:"mon",SK:"mon",SM:"mon",SV:"sun",SY:"sat",TH:"sun",TJ:"mon",TM:"mon",TR:"mon",TT:"sun",TW:"sun",UA:"mon",UM:"sun",US:"sun",UY:"mon",UZ:"mon",VA:"mon",VE:"sun",VI:"sun",VN:"mon",WS:"sun",XK:"mon",YE:"sun",ZA:"sun",ZW:"sun"},weekendStart:{"001":"sat",AE:"fri",AF:"thu",BH:"fri",DZ:"fri",EG:"fri",IL:"fri",IN:"sun",IQ:"fri",IR:"fri",JO:"fri",KW:"fri",LY:"fri",OM:"fri",QA:"fri",SA:"fri",SD:"fri",SY:"fri",UG:"sun",YE:"fri"},weekendEnd:{"001":"sun",AE:"sat",AF:"fri",BH:"sat",DZ:"sat",EG:"sat",IL:"sat",IQ:"sat",IR:"fri",JO:"sat",KW:"sat",LY:"sat",OM:"sat",QA:"sat",SA:"sat",SD:"sat",SY:"sat",YE:"sat"},af:{_ordering:"weekOfDate weekOfInterval weekOfMonth"},"am az bs cs cy da el et hi ky lt mk sk ta th":{_ordering:"weekOfYear weekOfMonth"},"ar fil gu hu hy id kk ko":{_ordering:"weekOfMonth"},"be ro ru":{_ordering:"weekOfInterval weekOfMonth"},"bg de iw pt ur zh":{_ordering:"weekOfDate weekOfMonth weekOfInterval"},"ca es fr gl":{_ordering:"weekOfDate"},"en bn ja ka":{_ordering:"weekOfDate weekOfMonth"},eu:{_ordering:"weekOfMonth weekOfDate"},"fa hr it lv pl si sr uk uz":{_ordering:"weekOfMonth weekOfInterval"},"fi zh-TW":{_ordering:"weekOfYear weekOfDate weekOfMonth"},"is mn no sv vi":{_ordering:"weekOfYear weekOfMonth weekOfInterval"},"km mr":{_ordering:"weekOfMonth weekOfYear"},"kn ml pa":{_ordering:"weekOfMonth weekOfDate weekOfYear"},"lo sq":{_ordering:"weekOfMonth weekOfInterval weekOfDate weekOfYear"},"ms tr":{_ordering:"weekOfMonth weekOfYear weekOfInterval weekOfDate"},nl:{_ordering:"weekOfDate weekOfYear weekOfMonth"},sl:{_ordering:"weekOfInterval"},"sw te":{_ordering:"weekOfMonth weekOfInterval weekOfYear"},und:{_ordering:"weekOfYear"},zu:{_ordering:"weekOfYear weekOfInterval"}},currencyData:{fractions:{ADP:{_rounding:"0",_digits:"0"},AFN:{_rounding:"0",_digits:"0"},ALL:{_rounding:"0",_digits:"0"},AMD:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},BHD:{_rounding:"0",_digits:"3"},BIF:{_rounding:"0",_digits:"0"},BYN:{_rounding:"0",_digits:"2"},BYR:{_rounding:"0",_digits:"0"},CAD:{_rounding:"0",_digits:"2",_cashRounding:"5"},CHF:{_rounding:"0",_digits:"2",_cashRounding:"5"},CLF:{_rounding:"0",_digits:"4"},CLP:{_rounding:"0",_digits:"0"},COP:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},CRC:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},CZK:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},DEFAULT:{_rounding:"0",_digits:"2"},DJF:{_rounding:"0",_digits:"0"},DKK:{_rounding:"0",_digits:"2",_cashRounding:"50"},ESP:{_rounding:"0",_digits:"0"},GNF:{_rounding:"0",_digits:"0"},GYD:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},HUF:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},IDR:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},IQD:{_rounding:"0",_digits:"0"},IRR:{_rounding:"0",_digits:"0"},ISK:{_rounding:"0",_digits:"0"},ITL:{_rounding:"0",_digits:"0"},JOD:{_rounding:"0",_digits:"3"},JPY:{_rounding:"0",_digits:"0"},KMF:{_rounding:"0",_digits:"0"},KPW:{_rounding:"0",_digits:"0"},KRW:{_rounding:"0",_digits:"0"},KWD:{_rounding:"0",_digits:"3"},LAK:{_rounding:"0",_digits:"0"},LBP:{_rounding:"0",_digits:"0"},LUF:{_rounding:"0",_digits:"0"},LYD:{_rounding:"0",_digits:"3"},MGA:{_rounding:"0",_digits:"0"},MGF:{_rounding:"0",_digits:"0"},MMK:{_rounding:"0",_digits:"0"},MNT:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},MRO:{_rounding:"0",_digits:"0"},MUR:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},NOK:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},OMR:{_rounding:"0",_digits:"3"},PKR:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},PYG:{_rounding:"0",_digits:"0"},RSD:{_rounding:"0",_digits:"0"},RWF:{_rounding:"0",_digits:"0"},SEK:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},SLL:{_rounding:"0",_digits:"0"},SOS:{_rounding:"0",_digits:"0"},STD:{_rounding:"0",_digits:"0"},SYP:{_rounding:"0",_digits:"0"},TMM:{_rounding:"0",_digits:"0"},TND:{_rounding:"0",_digits:"3"},TRL:{_rounding:"0",_digits:"0"},TWD:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},TZS:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},UGX:{_rounding:"0",_digits:"0"},UYI:{_rounding:"0",_digits:"0"},UYW:{_rounding:"0",_digits:"4"},UZS:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},VEF:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},VND:{_rounding:"0",_digits:"0"},VUV:{_rounding:"0",_digits:"0"},XAF:{_rounding:"0",_digits:"0"},XOF:{_rounding:"0",_digits:"0"},XPF:{_rounding:"0",_digits:"0"},YER:{_rounding:"0",_digits:"0"},ZMK:{_rounding:"0",_digits:"0"},ZWD:{_rounding:"0",_digits:"0"}},region:{AC:[{SHP:{_from:"1976-01-01"}}],AD:[{ESP:{_from:"1873-01-01",_to:"2002-02-28"}},{ADP:{_from:"1936-01-01",_to:"2001-12-31"}},{FRF:{_from:"1960-01-01",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],AE:[{AED:{_from:"1973-05-19"}}],AF:[{AFA:{_from:"1927-03-14",_to:"2002-12-31"}},{AFN:{_from:"2002-10-07"}}],AG:[{XCD:{_from:"1965-10-06"}}],AI:[{XCD:{_from:"1965-10-06"}}],AL:[{ALK:{_from:"1946-11-01",_to:"1965-08-16"}},{ALL:{_from:"1965-08-16"}}],AM:[{SUR:{_from:"1961-01-01",_to:"1991-12-25"}},{RUR:{_from:"1991-12-25",_to:"1993-11-22"}},{AMD:{_from:"1993-11-22"}}],AO:[{AOK:{_from:"1977-01-08",_to:"1991-03-01"}},{AON:{_from:"1990-09-25",_to:"2000-02-01"}},{AOR:{_from:"1995-07-01",_to:"2000-02-01"}},{AOA:{_from:"1999-12-13"}}],AQ:[{XXX:{_tender:"false"}}],AR:[{ARM:{_from:"1881-11-05",_to:"1970-01-01"}},{ARL:{_from:"1970-01-01",_to:"1983-06-01"}},{ARP:{_from:"1983-06-01",_to:"1985-06-14"}},{ARA:{_from:"1985-06-14",_to:"1992-01-01"}},{ARS:{_from:"1992-01-01"}}],AS:[{USD:{_from:"1904-07-16"}}],AT:[{ATS:{_from:"1947-12-04",_to:"2002-02-28"}},{EUR:{_from:"1999-01-01"}}],AU:[{AUD:{_from:"1966-02-14"}}],AW:[{ANG:{_from:"1940-05-10",_to:"1986-01-01"}},{AWG:{_from:"1986-01-01"}}],AX:[{EUR:{_from:"1999-01-01"}}],AZ:[{SUR:{_from:"1961-01-01",_to:"1991-12-25"}},{RUR:{_from:"1991-12-25",_to:"1994-01-01"}},{AZM:{_from:"1993-11-22",_to:"2006-12-31"}},{AZN:{_from:"2006-01-01"}}],BA:[{YUD:{_from:"1966-01-01",_to:"1990-01-01"}},{YUN:{_from:"1990-01-01",_to:"1992-07-01"}},{YUR:{_from:"1992-07-01",_to:"1993-10-01"}},{BAD:{_from:"1992-07-01",_to:"1994-08-15"}},{BAN:{_from:"1994-08-15",_to:"1997-07-01"}},{BAM:{_from:"1995-01-01"}}],BB:[{XCD:{_from:"1965-10-06",_to:"1973-12-03"}},{BBD:{_from:"1973-12-03"}}],BD:[{INR:{_from:"1835-08-17",_to:"1948-04-01"}},{PKR:{_from:"1948-04-01",_to:"1972-01-01"}},{BDT:{_from:"1972-01-01"}}],BE:[{NLG:{_from:"1816-12-15",_to:"1831-02-07"}},{BEF:{_from:"1831-02-07",_to:"2002-02-28"}},{BEC:{_tender:"false",_from:"1970-01-01",_to:"1990-03-05"}},{BEL:{_tender:"false",_from:"1970-01-01",_to:"1990-03-05"}},{EUR:{_from:"1999-01-01"}}],BF:[{XOF:{_from:"1984-08-04"}}],BG:[{BGO:{_from:"1879-07-08",_to:"1952-05-12"}},{BGM:{_from:"1952-05-12",_to:"1962-01-01"}},{BGL:{_from:"1962-01-01",_to:"1999-07-05"}},{BGN:{_from:"1999-07-05"}}],BH:[{BHD:{_from:"1965-10-16"}}],BI:[{BIF:{_from:"1964-05-19"}}],BJ:[{XOF:{_from:"1975-11-30"}}],BL:[{FRF:{_from:"1960-01-01",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],BM:[{BMD:{_from:"1970-02-06"}}],BN:[{MYR:{_from:"1963-09-16",_to:"1967-06-12"}},{BND:{_from:"1967-06-12"}}],BO:[{BOV:{_tender:"false"}},{BOL:{_from:"1863-06-23",_to:"1963-01-01"}},{BOP:{_from:"1963-01-01",_to:"1986-12-31"}},{BOB:{_from:"1987-01-01"}}],BQ:[{ANG:{_from:"2010-10-10",_to:"2011-01-01"}},{USD:{_from:"2011-01-01"}}],BR:[{BRZ:{_from:"1942-11-01",_to:"1967-02-13"}},{BRB:{_from:"1967-02-13",_to:"1986-02-28"}},{BRC:{_from:"1986-02-28",_to:"1989-01-15"}},{BRN:{_from:"1989-01-15",_to:"1990-03-16"}},{BRE:{_from:"1990-03-16",_to:"1993-08-01"}},{BRR:{_from:"1993-08-01",_to:"1994-07-01"}},{BRL:{_from:"1994-07-01"}}],BS:[{BSD:{_from:"1966-05-25"}}],BT:[{INR:{_from:"1907-01-01"}},{BTN:{_from:"1974-04-16"}}],BU:[{BUK:{_from:"1952-07-01",_to:"1989-06-18"}}],BV:[{NOK:{_from:"1905-06-07"}}],BW:[{ZAR:{_from:"1961-02-14",_to:"1976-08-23"}},{BWP:{_from:"1976-08-23"}}],BY:[{SUR:{_from:"1961-01-01",_to:"1991-12-25"}},{RUR:{_from:"1991-12-25",_to:"1994-11-08"}},{BYB:{_from:"1994-08-01",_to:"2000-12-31"}},{BYR:{_from:"2000-01-01",_to:"2017-01-01"}},{BYN:{_from:"2016-07-01"}}],BZ:[{BZD:{_from:"1974-01-01"}}],CA:[{CAD:{_from:"1858-01-01"}}],CC:[{AUD:{_from:"1966-02-14"}}],CD:[{ZRZ:{_from:"1971-10-27",_to:"1993-11-01"}},{ZRN:{_from:"1993-11-01",_to:"1998-07-01"}},{CDF:{_from:"1998-07-01"}}],CF:[{XAF:{_from:"1993-01-01"}}],CG:[{XAF:{_from:"1993-01-01"}}],CH:[{CHE:{_tender:"false"}},{CHW:{_tender:"false"}},{CHF:{_from:"1799-03-17"}}],CI:[{XOF:{_from:"1958-12-04"}}],CK:[{NZD:{_from:"1967-07-10"}}],CL:[{CLF:{_tender:"false"}},{CLE:{_from:"1960-01-01",_to:"1975-09-29"}},{CLP:{_from:"1975-09-29"}}],CM:[{XAF:{_from:"1973-04-01"}}],CN:[{CNY:{_from:"1953-03-01"}},{CNX:{_tender:"false",_from:"1979-01-01",_to:"1998-12-31"}},{CNH:{_tender:"false",_from:"2010-07-19"}}],CO:[{COU:{_tender:"false"}},{COP:{_from:"1905-01-01"}}],CP:[{XXX:{_tender:"false"}}],CR:[{CRC:{_from:"1896-10-26"}}],CS:[{YUM:{_from:"1994-01-24",_to:"2002-05-15"}},{CSD:{_from:"2002-05-15",_to:"2006-06-03"}},{EUR:{_from:"2003-02-04",_to:"2006-06-03"}}],CU:[{CUP:{_from:"1859-01-01"}},{USD:{_from:"1899-01-01",_to:"1959-01-01"}},{CUC:{_from:"1994-01-01"}}],CV:[{PTE:{_from:"1911-05-22",_to:"1975-07-05"}},{CVE:{_from:"1914-01-01"}}],CW:[{ANG:{_from:"2010-10-10"}}],CX:[{AUD:{_from:"1966-02-14"}}],CY:[{CYP:{_from:"1914-09-10",_to:"2008-01-31"}},{EUR:{_from:"2008-01-01"}}],CZ:[{CSK:{_from:"1953-06-01",_to:"1993-03-01"}},{CZK:{_from:"1993-01-01"}}],DD:[{DDM:{_from:"1948-07-20",_to:"1990-10-02"}}],DE:[{DEM:{_from:"1948-06-20",_to:"2002-02-28"}},{EUR:{_from:"1999-01-01"}}],DG:[{USD:{_from:"1965-11-08"}}],DJ:[{DJF:{_from:"1977-06-27"}}],DK:[{DKK:{_from:"1873-05-27"}}],DM:[{XCD:{_from:"1965-10-06"}}],DO:[{USD:{_from:"1905-06-21",_to:"1947-10-01"}},{DOP:{_from:"1947-10-01"}}],DZ:[{DZD:{_from:"1964-04-01"}}],EA:[{EUR:{_from:"1999-01-01"}}],EC:[{ECS:{_from:"1884-04-01",_to:"2000-10-02"}},{ECV:{_tender:"false",_from:"1993-05-23",_to:"2000-01-09"}},{USD:{_from:"2000-10-02"}}],EE:[{SUR:{_from:"1961-01-01",_to:"1992-06-20"}},{EEK:{_from:"1992-06-21",_to:"2010-12-31"}},{EUR:{_from:"2011-01-01"}}],EG:[{EGP:{_from:"1885-11-14"}}],EH:[{MAD:{_from:"1976-02-26"}}],ER:[{ETB:{_from:"1993-05-24",_to:"1997-11-08"}},{ERN:{_from:"1997-11-08"}}],ES:[{ESP:{_from:"1868-10-19",_to:"2002-02-28"}},{ESB:{_tender:"false",_from:"1975-01-01",_to:"1994-12-31"}},{ESA:{_tender:"false",_from:"1978-01-01",_to:"1981-12-31"}},{EUR:{_from:"1999-01-01"}}],ET:[{ETB:{_from:"1976-09-15"}}],EU:[{XEU:{_tender:"false",_from:"1979-01-01",_to:"1998-12-31"}},{EUR:{_from:"1999-01-01"}}],FI:[{FIM:{_from:"1963-01-01",_to:"2002-02-28"}},{EUR:{_from:"1999-01-01"}}],FJ:[{FJD:{_from:"1969-01-13"}}],FK:[{FKP:{_from:"1901-01-01"}}],FM:[{JPY:{_from:"1914-10-03",_to:"1944-01-01"}},{USD:{_from:"1944-01-01"}}],FO:[{DKK:{_from:"1948-01-01"}}],FR:[{FRF:{_from:"1960-01-01",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],GA:[{XAF:{_from:"1993-01-01"}}],GB:[{GBP:{_from:"1694-07-27"}}],GD:[{XCD:{_from:"1967-02-27"}}],GE:[{SUR:{_from:"1961-01-01",_to:"1991-12-25"}},{RUR:{_from:"1991-12-25",_to:"1993-06-11"}},{GEK:{_from:"1993-04-05",_to:"1995-09-25"}},{GEL:{_from:"1995-09-23"}}],GF:[{FRF:{_from:"1960-01-01",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],GG:[{GBP:{_from:"1830-01-01"}}],GH:[{GHC:{_from:"1979-03-09",_to:"2007-12-31"}},{GHS:{_from:"2007-07-03"}}],GI:[{GIP:{_from:"1713-01-01"}}],GL:[{DKK:{_from:"1873-05-27"}}],GM:[{GMD:{_from:"1971-07-01"}}],GN:[{GNS:{_from:"1972-10-02",_to:"1986-01-06"}},{GNF:{_from:"1986-01-06"}}],GP:[{FRF:{_from:"1960-01-01",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],GQ:[{GQE:{_from:"1975-07-07",_to:"1986-06-01"}},{XAF:{_from:"1993-01-01"}}],GR:[{GRD:{_from:"1954-05-01",_to:"2002-02-28"}},{EUR:{_from:"2001-01-01"}}],GS:[{GBP:{_from:"1908-01-01"}}],GT:[{GTQ:{_from:"1925-05-27"}}],GU:[{USD:{_from:"1944-08-21"}}],GW:[{GWE:{_from:"1914-01-01",_to:"1976-02-28"}},{GWP:{_from:"1976-02-28",_to:"1997-03-31"}},{XOF:{_from:"1997-03-31"}}],GY:[{GYD:{_from:"1966-05-26"}}],HK:[{HKD:{_from:"1895-02-02"}}],HM:[{AUD:{_from:"1967-02-16"}}],HN:[{HNL:{_from:"1926-04-03"}}],HR:[{YUD:{_from:"1966-01-01",_to:"1990-01-01"}},{YUN:{_from:"1990-01-01",_to:"1991-12-23"}},{HRD:{_from:"1991-12-23",_to:"1995-01-01"}},{HRK:{_from:"1994-05-30"}}],HT:[{HTG:{_from:"1872-08-26"}},{USD:{_from:"1915-01-01"}}],HU:[{HUF:{_from:"1946-07-23"}}],IC:[{EUR:{_from:"1999-01-01"}}],ID:[{IDR:{_from:"1965-12-13"}}],IE:[{GBP:{_from:"1800-01-01",_to:"1922-01-01"}},{IEP:{_from:"1922-01-01",_to:"2002-02-09"}},{EUR:{_from:"1999-01-01"}}],IL:[{ILP:{_from:"1948-08-16",_to:"1980-02-22"}},{ILR:{_from:"1980-02-22",_to:"1985-09-04"}},{ILS:{_from:"1985-09-04"}}],IM:[{GBP:{_from:"1840-01-03"}}],IN:[{INR:{_from:"1835-08-17"}}],IO:[{USD:{_from:"1965-11-08"}}],IQ:[{EGP:{_from:"1920-11-11",_to:"1931-04-19"}},{INR:{_from:"1920-11-11",_to:"1931-04-19"}},{IQD:{_from:"1931-04-19"}}],IR:[{IRR:{_from:"1932-05-13"}}],IS:[{DKK:{_from:"1873-05-27",_to:"1918-12-01"}},{ISJ:{_from:"1918-12-01",_to:"1981-01-01"}},{ISK:{_from:"1981-01-01"}}],IT:[{ITL:{_from:"1862-08-24",_to:"2002-02-28"}},{EUR:{_from:"1999-01-01"}}],JE:[{GBP:{_from:"1837-01-01"}}],JM:[{JMD:{_from:"1969-09-08"}}],JO:[{JOD:{_from:"1950-07-01"}}],JP:[{JPY:{_from:"1871-06-01"}}],KE:[{KES:{_from:"1966-09-14"}}],KG:[{SUR:{_from:"1961-01-01",_to:"1991-12-25"}},{RUR:{_from:"1991-12-25",_to:"1993-05-10"}},{KGS:{_from:"1993-05-10"}}],KH:[{KHR:{_from:"1980-03-20"}}],KI:[{AUD:{_from:"1966-02-14"}}],KM:[{KMF:{_from:"1975-07-06"}}],KN:[{XCD:{_from:"1965-10-06"}}],KP:[{KPW:{_from:"1959-04-17"}}],KR:[{KRO:{_from:"1945-08-15",_to:"1953-02-15"}},{KRH:{_from:"1953-02-15",_to:"1962-06-10"}},{KRW:{_from:"1962-06-10"}}],KW:[{KWD:{_from:"1961-04-01"}}],KY:[{JMD:{_from:"1969-09-08",_to:"1971-01-01"}},{KYD:{_from:"1971-01-01"}}],KZ:[{KZT:{_from:"1993-11-05"}}],LA:[{LAK:{_from:"1979-12-10"}}],LB:[{LBP:{_from:"1948-02-02"}}],LC:[{XCD:{_from:"1965-10-06"}}],LI:[{CHF:{_from:"1921-02-01"}}],LK:[{LKR:{_from:"1978-05-22"}}],LR:[{LRD:{_from:"1944-01-01"}}],LS:[{ZAR:{_from:"1961-02-14"}},{LSL:{_from:"1980-01-22"}}],LT:[{SUR:{_from:"1961-01-01",_to:"1992-10-01"}},{LTT:{_from:"1992-10-01",_to:"1993-06-25"}},{LTL:{_from:"1993-06-25",_to:"2014-12-31"}},{EUR:{_from:"2015-01-01"}}],LU:[{LUF:{_from:"1944-09-04",_to:"2002-02-28"}},{LUC:{_tender:"false",_from:"1970-01-01",_to:"1990-03-05"}},{LUL:{_tender:"false",_from:"1970-01-01",_to:"1990-03-05"}},{EUR:{_from:"1999-01-01"}}],LV:[{SUR:{_from:"1961-01-01",_to:"1992-07-20"}},{LVR:{_from:"1992-05-07",_to:"1993-10-17"}},{LVL:{_from:"1993-06-28",_to:"2013-12-31"}},{EUR:{_from:"2014-01-01"}}],LY:[{LYD:{_from:"1971-09-01"}}],MA:[{MAF:{_from:"1881-01-01",_to:"1959-10-17"}},{MAD:{_from:"1959-10-17"}}],MC:[{FRF:{_from:"1960-01-01",_to:"2002-02-17"}},{MCF:{_from:"1960-01-01",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],MD:[{MDC:{_from:"1992-06-01",_to:"1993-11-29"}},{MDL:{_from:"1993-11-29"}}],ME:[{YUM:{_from:"1994-01-24",_to:"2002-05-15"}},{DEM:{_from:"1999-10-02",_to:"2002-05-15"}},{EUR:{_from:"2002-01-01"}}],MF:[{FRF:{_from:"1960-01-01",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],MG:[{MGF:{_from:"1963-07-01",_to:"2004-12-31"}},{MGA:{_from:"1983-11-01"}}],MH:[{USD:{_from:"1944-01-01"}}],MK:[{MKN:{_from:"1992-04-26",_to:"1993-05-20"}},{MKD:{_from:"1993-05-20"}}],ML:[{XOF:{_from:"1958-11-24",_to:"1962-07-02"}},{MLF:{_from:"1962-07-02",_to:"1984-08-31"}},{XOF:{_from:"1984-06-01"}}],MM:[{BUK:{_from:"1952-07-01",_to:"1989-06-18"}},{MMK:{_from:"1989-06-18"}}],MN:[{MNT:{_from:"1915-03-01"}}],MO:[{MOP:{_from:"1901-01-01"}}],MP:[{USD:{_from:"1944-01-01"}}],MQ:[{FRF:{_from:"1960-01-01",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],MR:[{XOF:{_from:"1958-11-28",_to:"1973-06-29"}},{MRO:{_from:"1973-06-29",_to:"2018-06-30"}},{MRU:{_from:"2018-01-01"}}],MS:[{XCD:{_from:"1967-02-27"}}],MT:[{MTP:{_from:"1914-08-13",_to:"1968-06-07"}},{MTL:{_from:"1968-06-07",_to:"2008-01-31"}},{EUR:{_from:"2008-01-01"}}],MU:[{MUR:{_from:"1934-04-01"}}],MV:[{MVP:{_from:"1947-01-01",_to:"1981-07-01"}},{MVR:{_from:"1981-07-01"}}],MW:[{MWK:{_from:"1971-02-15"}}],MX:[{MXV:{_tender:"false"}},{MXP:{_from:"1822-01-01",_to:"1992-12-31"}},{MXN:{_from:"1993-01-01"}}],MY:[{MYR:{_from:"1963-09-16"}}],MZ:[{MZE:{_from:"1975-06-25",_to:"1980-06-16"}},{MZM:{_from:"1980-06-16",_to:"2006-12-31"}},{MZN:{_from:"2006-07-01"}}],NA:[{ZAR:{_from:"1961-02-14"}},{NAD:{_from:"1993-01-01"}}],NC:[{XPF:{_from:"1985-01-01"}}],NE:[{XOF:{_from:"1958-12-19"}}],NF:[{AUD:{_from:"1966-02-14"}}],NG:[{NGN:{_from:"1973-01-01"}}],NI:[{NIC:{_from:"1988-02-15",_to:"1991-04-30"}},{NIO:{_from:"1991-04-30"}}],NL:[{NLG:{_from:"1813-01-01",_to:"2002-02-28"}},{EUR:{_from:"1999-01-01"}}],NO:[{SEK:{_from:"1873-05-27",_to:"1905-06-07"}},{NOK:{_from:"1905-06-07"}}],NP:[{INR:{_from:"1870-01-01",_to:"1966-10-17"}},{NPR:{_from:"1933-01-01"}}],NR:[{AUD:{_from:"1966-02-14"}}],NU:[{NZD:{_from:"1967-07-10"}}],NZ:[{NZD:{_from:"1967-07-10"}}],OM:[{OMR:{_from:"1972-11-11"}}],PA:[{PAB:{_from:"1903-11-04"}},{USD:{_from:"1903-11-18"}}],PE:[{PES:{_from:"1863-02-14",_to:"1985-02-01"}},{PEI:{_from:"1985-02-01",_to:"1991-07-01"}},{PEN:{_from:"1991-07-01"}}],PF:[{XPF:{_from:"1945-12-26"}}],PG:[{AUD:{_from:"1966-02-14",_to:"1975-09-16"}},{PGK:{_from:"1975-09-16"}}],PH:[{PHP:{_from:"1946-07-04"}}],PK:[{INR:{_from:"1835-08-17",_to:"1947-08-15"}},{PKR:{_from:"1948-04-01"}}],PL:[{PLZ:{_from:"1950-10-28",_to:"1994-12-31"}},{PLN:{_from:"1995-01-01"}}],PM:[{FRF:{_from:"1972-12-21",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],PN:[{NZD:{_from:"1969-01-13"}}],PR:[{ESP:{_from:"1800-01-01",_to:"1898-12-10"}},{USD:{_from:"1898-12-10"}}],PS:[{JOD:{_from:"1950-07-01",_to:"1967-06-01"}},{ILP:{_from:"1967-06-01",_to:"1980-02-22"}},{ILS:{_from:"1985-09-04"}},{JOD:{_from:"1996-02-12"}}],PT:[{PTE:{_from:"1911-05-22",_to:"2002-02-28"}},{EUR:{_from:"1999-01-01"}}],PW:[{USD:{_from:"1944-01-01"}}],PY:[{PYG:{_from:"1943-11-01"}}],QA:[{QAR:{_from:"1973-05-19"}}],RE:[{FRF:{_from:"1975-01-01",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],RO:[{ROL:{_from:"1952-01-28",_to:"2006-12-31"}},{RON:{_from:"2005-07-01"}}],RS:[{YUM:{_from:"1994-01-24",_to:"2002-05-15"}},{CSD:{_from:"2002-05-15",_to:"2006-10-25"}},{RSD:{_from:"2006-10-25"}}],RU:[{RUR:{_from:"1991-12-25",_to:"1998-12-31"}},{RUB:{_from:"1999-01-01"}}],RW:[{RWF:{_from:"1964-05-19"}}],SA:[{SAR:{_from:"1952-10-22"}}],SB:[{AUD:{_from:"1966-02-14",_to:"1978-06-30"}},{SBD:{_from:"1977-10-24"}}],SC:[{SCR:{_from:"1903-11-01"}}],SD:[{EGP:{_from:"1889-01-19",_to:"1958-01-01"}},{GBP:{_from:"1889-01-19",_to:"1958-01-01"}},{SDP:{_from:"1957-04-08",_to:"1998-06-01"}},{SDD:{_from:"1992-06-08",_to:"2007-06-30"}},{SDG:{_from:"2007-01-10"}}],SE:[{SEK:{_from:"1873-05-27"}}],SG:[{MYR:{_from:"1963-09-16",_to:"1967-06-12"}},{SGD:{_from:"1967-06-12"}}],SH:[{SHP:{_from:"1917-02-15"}}],SI:[{SIT:{_from:"1992-10-07",_to:"2007-01-14"}},{EUR:{_from:"2007-01-01"}}],SJ:[{NOK:{_from:"1905-06-07"}}],SK:[{CSK:{_from:"1953-06-01",_to:"1992-12-31"}},{SKK:{_from:"1992-12-31",_to:"2009-01-01"}},{EUR:{_from:"2009-01-01"}}],SL:[{GBP:{_from:"1808-11-30",_to:"1966-02-04"}},{SLL:{_from:"1964-08-04"}}],SM:[{ITL:{_from:"1865-12-23",_to:"2001-02-28"}},{EUR:{_from:"1999-01-01"}}],SN:[{XOF:{_from:"1959-04-04"}}],SO:[{SOS:{_from:"1960-07-01"}}],SR:[{NLG:{_from:"1815-11-20",_to:"1940-05-10"}},{SRG:{_from:"1940-05-10",_to:"2003-12-31"}},{SRD:{_from:"2004-01-01"}}],SS:[{SDG:{_from:"2007-01-10",_to:"2011-09-01"}},{SSP:{_from:"2011-07-18"}}],ST:[{STD:{_from:"1977-09-08",_to:"2017-12-31"}},{STN:{_from:"2018-01-01"}}],SU:[{SUR:{_from:"1961-01-01",_to:"1991-12-25"}}],SV:[{SVC:{_from:"1919-11-11",_to:"2001-01-01"}},{USD:{_from:"2001-01-01"}}],SX:[{ANG:{_from:"2010-10-10"}}],SY:[{SYP:{_from:"1948-01-01"}}],SZ:[{SZL:{_from:"1974-09-06"}}],TA:[{GBP:{_from:"1938-01-12"}}],TC:[{USD:{_from:"1969-09-08"}}],TD:[{XAF:{_from:"1993-01-01"}}],TF:[{FRF:{_from:"1959-01-01",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],TG:[{XOF:{_from:"1958-11-28"}}],TH:[{THB:{_from:"1928-04-15"}}],TJ:[{RUR:{_from:"1991-12-25",_to:"1995-05-10"}},{TJR:{_from:"1995-05-10",_to:"2000-10-25"}},{TJS:{_from:"2000-10-26"}}],TK:[{NZD:{_from:"1967-07-10"}}],TL:[{TPE:{_from:"1959-01-02",_to:"2002-05-20"}},{IDR:{_from:"1975-12-07",_to:"2002-05-20"}},{USD:{_from:"1999-10-20"}}],TM:[{SUR:{_from:"1961-01-01",_to:"1991-12-25"}},{RUR:{_from:"1991-12-25",_to:"1993-11-01"}},{TMM:{_from:"1993-11-01",_to:"2009-01-01"}},{TMT:{_from:"2009-01-01"}}],TN:[{TND:{_from:"1958-11-01"}}],TO:[{TOP:{_from:"1966-02-14"}}],TP:[{TPE:{_from:"1959-01-02",_to:"2002-05-20"}},{IDR:{_from:"1975-12-07",_to:"2002-05-20"}}],TR:[{TRL:{_from:"1922-11-01",_to:"2005-12-31"}},{TRY:{_from:"2005-01-01"}}],TT:[{TTD:{_from:"1964-01-01"}}],TV:[{AUD:{_from:"1966-02-14"}}],TW:[{TWD:{_from:"1949-06-15"}}],TZ:[{TZS:{_from:"1966-06-14"}}],UA:[{SUR:{_from:"1961-01-01",_to:"1991-12-25"}},{RUR:{_from:"1991-12-25",_to:"1992-11-13"}},{UAK:{_from:"1992-11-13",_to:"1993-10-17"}},{UAH:{_from:"1996-09-02"}}],UG:[{UGS:{_from:"1966-08-15",_to:"1987-05-15"}},{UGX:{_from:"1987-05-15"}}],UM:[{USD:{_from:"1944-01-01"}}],US:[{USN:{_tender:"false"}},{USS:{_tender:"false",_to:"2014-03-01"}},{USD:{_from:"1792-01-01"}}],UY:[{UYI:{_tender:"false"}},{UYW:{_tender:"false"}},{UYP:{_from:"1975-07-01",_to:"1993-03-01"}},{UYU:{_from:"1993-03-01"}}],UZ:[{UZS:{_from:"1994-07-01"}}],VA:[{ITL:{_from:"1870-10-19",_to:"2002-02-28"}},{EUR:{_from:"1999-01-01"}}],VC:[{XCD:{_from:"1965-10-06"}}],VE:[{VEB:{_from:"1871-05-11",_to:"2008-06-30"}},{VEF:{_from:"2008-01-01",_to:"2018-08-20"}},{VES:{_from:"2018-08-20"}}],VG:[{USD:{_from:"1833-01-01"}},{GBP:{_from:"1833-01-01",_to:"1959-01-01"}}],VI:[{USD:{_from:"1837-01-01"}}],VN:[{VNN:{_from:"1978-05-03",_to:"1985-09-14"}},{VND:{_from:"1985-09-14"}}],VU:[{VUV:{_from:"1981-01-01"}}],WF:[{XPF:{_from:"1961-07-30"}}],WS:[{WST:{_from:"1967-07-10"}}],XK:[{YUM:{_from:"1994-01-24",_to:"1999-09-30"}},{DEM:{_from:"1999-09-01",_to:"2002-03-09"}},{EUR:{_from:"2002-01-01"}}],YD:[{YDD:{_from:"1965-04-01",_to:"1996-01-01"}}],YE:[{YER:{_from:"1990-05-22"}}],YT:[{KMF:{_from:"1975-01-01",_to:"1976-02-23"}},{FRF:{_from:"1976-02-23",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],YU:[{YUD:{_from:"1966-01-01",_to:"1990-01-01"}},{YUN:{_from:"1990-01-01",_to:"1992-07-24"}},{YUM:{_from:"1994-01-24",_to:"2002-05-15"}}],ZA:[{ZAR:{_from:"1961-02-14"}},{ZAL:{_tender:"false",_from:"1985-09-01",_to:"1995-03-13"}}],ZM:[{ZMK:{_from:"1968-01-16",_to:"2013-01-01"}},{ZMW:{_from:"2013-01-01"}}],ZR:[{ZRZ:{_from:"1971-10-27",_to:"1993-11-01"}},{ZRN:{_from:"1993-11-01",_to:"1998-07-31"}}],ZW:[{RHD:{_from:"1970-02-17",_to:"1980-04-18"}},{ZWD:{_from:"1980-04-18",_to:"2008-08-01"}},{ZWR:{_from:"2008-08-01",_to:"2009-02-02"}},{ZWL:{_from:"2009-02-02",_to:"2009-04-12"}},{USD:{_from:"2009-04-12"}}],ZZ:[{XAG:{_tender:"false"}},{XAU:{_tender:"false"}},{XBA:{_tender:"false"}},{XBB:{_tender:"false"}},{XBC:{_tender:"false"}},{XBD:{_tender:"false"}},{XDR:{_tender:"false"}},{XPD:{_tender:"false"}},{XPT:{_tender:"false"}},{XSU:{_tender:"false"}},{XTS:{_tender:"false"}},{XUA:{_tender:"false"}},{XXX:{_tender:"false"}},{XRE:{_tender:"false",_to:"1999-11-30"}},{XFU:{_tender:"false",_to:"2013-11-30"}},{XFO:{_tender:"false",_from:"1930-01-01",_to:"2003-04-01"}}]}},numberingSystems:{adlm:{_digits:"\ud83a\udd50\ud83a\udd51\ud83a\udd52\ud83a\udd53\ud83a\udd54\ud83a\udd55\ud83a\udd56\ud83a\udd57\ud83a\udd58\ud83a\udd59",_type:"numeric"},ahom:{_digits:"\ud805\udf30\ud805\udf31\ud805\udf32\ud805\udf33\ud805\udf34\ud805\udf35\ud805\udf36\ud805\udf37\ud805\udf38\ud805\udf39",_type:"numeric"},arab:{_digits:"\u0660\u0661\u0662\u0663\u0664\u0665\u0666\u0667\u0668\u0669",_type:"numeric"},arabext:{_digits:"\u06f0\u06f1\u06f2\u06f3\u06f4\u06f5\u06f6\u06f7\u06f8\u06f9",_type:"numeric"},armn:{_rules:"armenian-upper",_type:"algorithmic"},armnlow:{_rules:"armenian-lower",_type:"algorithmic"},bali:{_digits:"\u1b50\u1b51\u1b52\u1b53\u1b54\u1b55\u1b56\u1b57\u1b58\u1b59",_type:"numeric"},beng:{_digits:"\u09e6\u09e7\u09e8\u09e9\u09ea\u09eb\u09ec\u09ed\u09ee\u09ef",_type:"numeric"},bhks:{_digits:"\ud807\udc50\ud807\udc51\ud807\udc52\ud807\udc53\ud807\udc54\ud807\udc55\ud807\udc56\ud807\udc57\ud807\udc58\ud807\udc59",_type:"numeric"},brah:{_digits:"\ud804\udc66\ud804\udc67\ud804\udc68\ud804\udc69\ud804\udc6a\ud804\udc6b\ud804\udc6c\ud804\udc6d\ud804\udc6e\ud804\udc6f",_type:"numeric"},cakm:{_digits:"\ud804\udd36\ud804\udd37\ud804\udd38\ud804\udd39\ud804\udd3a\ud804\udd3b\ud804\udd3c\ud804\udd3d\ud804\udd3e\ud804\udd3f",_type:"numeric"},cham:{_digits:"\uaa50\uaa51\uaa52\uaa53\uaa54\uaa55\uaa56\uaa57\uaa58\uaa59",_type:"numeric"},cyrl:{_rules:"cyrillic-lower",_type:"algorithmic"},deva:{_digits:"\u0966\u0967\u0968\u0969\u096a\u096b\u096c\u096d\u096e\u096f",_type:"numeric"},ethi:{_rules:"ethiopic",_type:"algorithmic"},fullwide:{_digits:"\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19",_type:"numeric"},geor:{_rules:"georgian",_type:"algorithmic"},gong:{_digits:"\ud807\udda0\ud807\udda1\ud807\udda2\ud807\udda3\ud807\udda4\ud807\udda5\ud807\udda6\ud807\udda7\ud807\udda8\ud807\udda9",_type:"numeric"},gonm:{_digits:"\ud807\udd50\ud807\udd51\ud807\udd52\ud807\udd53\ud807\udd54\ud807\udd55\ud807\udd56\ud807\udd57\ud807\udd58\ud807\udd59",_type:"numeric"},grek:{_rules:"greek-upper",_type:"algorithmic"},greklow:{_rules:"greek-lower",_type:"algorithmic"},gujr:{_digits:"\u0ae6\u0ae7\u0ae8\u0ae9\u0aea\u0aeb\u0aec\u0aed\u0aee\u0aef",_type:"numeric"},guru:{_digits:"\u0a66\u0a67\u0a68\u0a69\u0a6a\u0a6b\u0a6c\u0a6d\u0a6e\u0a6f",_type:"numeric"},hanidays:{_rules:"zh/SpelloutRules/spellout-numbering-days",_type:"algorithmic"},hanidec:{_digits:"\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d",_type:"numeric"},hans:{_rules:"zh/SpelloutRules/spellout-cardinal",_type:"algorithmic"},hansfin:{_rules:"zh/SpelloutRules/spellout-cardinal-financial",_type:"algorithmic"},hant:{_rules:"zh_Hant/SpelloutRules/spellout-cardinal",_type:"algorithmic"},hantfin:{_rules:"zh_Hant/SpelloutRules/spellout-cardinal-financial",_type:"algorithmic"},hebr:{_rules:"hebrew",_type:"algorithmic"},hmng:{_digits:"\ud81a\udf50\ud81a\udf51\ud81a\udf52\ud81a\udf53\ud81a\udf54\ud81a\udf55\ud81a\udf56\ud81a\udf57\ud81a\udf58\ud81a\udf59",_type:"numeric"},hmnp:{_digits:"\ud838\udd40\ud838\udd41\ud838\udd42\ud838\udd43\ud838\udd44\ud838\udd45\ud838\udd46\ud838\udd47\ud838\udd48\ud838\udd49",_type:"numeric"},java:{_digits:"\ua9d0\ua9d1\ua9d2\ua9d3\ua9d4\ua9d5\ua9d6\ua9d7\ua9d8\ua9d9",_type:"numeric"},jpan:{_rules:"ja/SpelloutRules/spellout-cardinal",_type:"algorithmic"},jpanfin:{_rules:"ja/SpelloutRules/spellout-cardinal-financial",_type:"algorithmic"},jpanyear:{_rules:"ja/SpelloutRules/spellout-numbering-year-latn",_type:"algorithmic"},kali:{_digits:"\ua900\ua901\ua902\ua903\ua904\ua905\ua906\ua907\ua908\ua909",_type:"numeric"},khmr:{_digits:"\u17e0\u17e1\u17e2\u17e3\u17e4\u17e5\u17e6\u17e7\u17e8\u17e9",_type:"numeric"},knda:{_digits:"\u0ce6\u0ce7\u0ce8\u0ce9\u0cea\u0ceb\u0cec\u0ced\u0cee\u0cef",_type:"numeric"},lana:{_digits:"\u1a80\u1a81\u1a82\u1a83\u1a84\u1a85\u1a86\u1a87\u1a88\u1a89",_type:"numeric"},lanatham:{_digits:"\u1a90\u1a91\u1a92\u1a93\u1a94\u1a95\u1a96\u1a97\u1a98\u1a99",_type:"numeric"},laoo:{_digits:"\u0ed0\u0ed1\u0ed2\u0ed3\u0ed4\u0ed5\u0ed6\u0ed7\u0ed8\u0ed9",_type:"numeric"},latn:{_digits:"0123456789",_type:"numeric"},lepc:{_digits:"\u1c40\u1c41\u1c42\u1c43\u1c44\u1c45\u1c46\u1c47\u1c48\u1c49",_type:"numeric"},limb:{_digits:"\u1946\u1947\u1948\u1949\u194a\u194b\u194c\u194d\u194e\u194f",_type:"numeric"},mathbold:{_digits:"\ud835\udfce\ud835\udfcf\ud835\udfd0\ud835\udfd1\ud835\udfd2\ud835\udfd3\ud835\udfd4\ud835\udfd5\ud835\udfd6\ud835\udfd7",_type:"numeric"},mathdbl:{_digits:"\ud835\udfd8\ud835\udfd9\ud835\udfda\ud835\udfdb\ud835\udfdc\ud835\udfdd\ud835\udfde\ud835\udfdf\ud835\udfe0\ud835\udfe1",_type:"numeric"},mathmono:{_digits:"\ud835\udff6\ud835\udff7\ud835\udff8\ud835\udff9\ud835\udffa\ud835\udffb\ud835\udffc\ud835\udffd\ud835\udffe\ud835\udfff",_type:"numeric"},mathsanb:{_digits:"\ud835\udfec\ud835\udfed\ud835\udfee\ud835\udfef\ud835\udff0\ud835\udff1\ud835\udff2\ud835\udff3\ud835\udff4\ud835\udff5",_type:"numeric"},mathsans:{_digits:"\ud835\udfe2\ud835\udfe3\ud835\udfe4\ud835\udfe5\ud835\udfe6\ud835\udfe7\ud835\udfe8\ud835\udfe9\ud835\udfea\ud835\udfeb",_type:"numeric"},mlym:{_digits:"\u0d66\u0d67\u0d68\u0d69\u0d6a\u0d6b\u0d6c\u0d6d\u0d6e\u0d6f",_type:"numeric"},modi:{_digits:"\ud805\ude50\ud805\ude51\ud805\ude52\ud805\ude53\ud805\ude54\ud805\ude55\ud805\ude56\ud805\ude57\ud805\ude58\ud805\ude59",_type:"numeric"},mong:{_digits:"\u1810\u1811\u1812\u1813\u1814\u1815\u1816\u1817\u1818\u1819",_type:"numeric"},mroo:{_digits:"\ud81a\ude60\ud81a\ude61\ud81a\ude62\ud81a\ude63\ud81a\ude64\ud81a\ude65\ud81a\ude66\ud81a\ude67\ud81a\ude68\ud81a\ude69",_type:"numeric"},mtei:{_digits:"\uabf0\uabf1\uabf2\uabf3\uabf4\uabf5\uabf6\uabf7\uabf8\uabf9",_type:"numeric"},mymr:{_digits:"\u1040\u1041\u1042\u1043\u1044\u1045\u1046\u1047\u1048\u1049",_type:"numeric"},mymrshan:{_digits:"\u1090\u1091\u1092\u1093\u1094\u1095\u1096\u1097\u1098\u1099",_type:"numeric"},mymrtlng:{_digits:"\ua9f0\ua9f1\ua9f2\ua9f3\ua9f4\ua9f5\ua9f6\ua9f7\ua9f8\ua9f9",_type:"numeric"},newa:{_digits:"\ud805\udc50\ud805\udc51\ud805\udc52\ud805\udc53\ud805\udc54\ud805\udc55\ud805\udc56\ud805\udc57\ud805\udc58\ud805\udc59",_type:"numeric"},nkoo:{_digits:"\u07c0\u07c1\u07c2\u07c3\u07c4\u07c5\u07c6\u07c7\u07c8\u07c9",_type:"numeric"},olck:{_digits:"\u1c50\u1c51\u1c52\u1c53\u1c54\u1c55\u1c56\u1c57\u1c58\u1c59",_type:"numeric"},orya:{_digits:"\u0b66\u0b67\u0b68\u0b69\u0b6a\u0b6b\u0b6c\u0b6d\u0b6e\u0b6f",_type:"numeric"},osma:{_digits:"\ud801\udca0\ud801\udca1\ud801\udca2\ud801\udca3\ud801\udca4\ud801\udca5\ud801\udca6\ud801\udca7\ud801\udca8\ud801\udca9",_type:"numeric"},rohg:{_digits:"\ud803\udd30\ud803\udd31\ud803\udd32\ud803\udd33\ud803\udd34\ud803\udd35\ud803\udd36\ud803\udd37\ud803\udd38\ud803\udd39",_type:"numeric"},roman:{_rules:"roman-upper",_type:"algorithmic"},romanlow:{_rules:"roman-lower",_type:"algorithmic"},saur:{_digits:"\ua8d0\ua8d1\ua8d2\ua8d3\ua8d4\ua8d5\ua8d6\ua8d7\ua8d8\ua8d9",_type:"numeric"},shrd:{_digits:"\ud804\uddd0\ud804\uddd1\ud804\uddd2\ud804\uddd3\ud804\uddd4\ud804\uddd5\ud804\uddd6\ud804\uddd7\ud804\uddd8\ud804\uddd9",_type:"numeric"},sind:{_digits:"\ud804\udef0\ud804\udef1\ud804\udef2\ud804\udef3\ud804\udef4\ud804\udef5\ud804\udef6\ud804\udef7\ud804\udef8\ud804\udef9",_type:"numeric"},sinh:{_digits:"\u0de6\u0de7\u0de8\u0de9\u0dea\u0deb\u0dec\u0ded\u0dee\u0def",_type:"numeric"},sora:{_digits:"\ud804\udcf0\ud804\udcf1\ud804\udcf2\ud804\udcf3\ud804\udcf4\ud804\udcf5\ud804\udcf6\ud804\udcf7\ud804\udcf8\ud804\udcf9",_type:"numeric"},sund:{_digits:"\u1bb0\u1bb1\u1bb2\u1bb3\u1bb4\u1bb5\u1bb6\u1bb7\u1bb8\u1bb9",_type:"numeric"},takr:{_digits:"\ud805\udec0\ud805\udec1\ud805\udec2\ud805\udec3\ud805\udec4\ud805\udec5\ud805\udec6\ud805\udec7\ud805\udec8\ud805\udec9",_type:"numeric"},talu:{_digits:"\u19d0\u19d1\u19d2\u19d3\u19d4\u19d5\u19d6\u19d7\u19d8\u19d9",_type:"numeric"},taml:{_rules:"tamil",_type:"algorithmic"},tamldec:{_digits:"\u0be6\u0be7\u0be8\u0be9\u0bea\u0beb\u0bec\u0bed\u0bee\u0bef",_type:"numeric"},telu:{_digits:"\u0c66\u0c67\u0c68\u0c69\u0c6a\u0c6b\u0c6c\u0c6d\u0c6e\u0c6f",_type:"numeric"},thai:{_digits:"\u0e50\u0e51\u0e52\u0e53\u0e54\u0e55\u0e56\u0e57\u0e58\u0e59",_type:"numeric"},tibt:{_digits:"\u0f20\u0f21\u0f22\u0f23\u0f24\u0f25\u0f26\u0f27\u0f28\u0f29",_type:"numeric"},tirh:{_digits:"\ud805\udcd0\ud805\udcd1\ud805\udcd2\ud805\udcd3\ud805\udcd4\ud805\udcd5\ud805\udcd6\ud805\udcd7\ud805\udcd8\ud805\udcd9",_type:"numeric"},vaii:{_digits:"\ua620\ua621\ua622\ua623\ua624\ua625\ua626\ua627\ua628\ua629",_type:"numeric"},wara:{_digits:"\ud806\udce0\ud806\udce1\ud806\udce2\ud806\udce3\ud806\udce4\ud806\udce5\ud806\udce6\ud806\udce7\ud806\udce8\ud806\udce9",_type:"numeric"},wcho:{_digits:"\ud838\udef0\ud838\udef1\ud838\udef2\ud838\udef3\ud838\udef4\ud838\udef5\ud838\udef6\ud838\udef7\ud838\udef8\ud838\udef9",_type:"numeric"}}}}},91331:function(e,t,n){t.default=void 0;var i=r(n(20476)),o=r(n(73806)),a=r(n(49198));function r(e){return e&&e.__esModule?e:{default:e}}var s,l=(0,i.default)({locale:(s="en",function(e){if(!e)return s;s=e}),getValueByClosestLocale:function(e){for(var t,n=this.locale(),i=e(n);!i&&!t;)(n=(0,a.default)(o.default,n))?i=e(n):t=!0;return void 0===i&&"en"!==n?e("en"):i}});t.default=l,e.exports=t.default,e.exports.default=t.default},89740:function(e,t,n){t.default=void 0;var i=n(13306),o={_formatNumberCore:function(e,t,n){if("currency"===t){n.precision=n.precision||0;var o=this.format(e,(0,i.extend)({},n,{type:"fixedpoint"})),a=this.getCurrencySymbol().symbol.replace(/\$/g,"$$$$");return o=o.replace(/^(\D*)(\d.*)/,"$1"+a+"$2")}return this.callBase.apply(this,arguments)},getCurrencySymbol:function(){return{symbol:"$"}},getOpenXmlCurrencyFormat:function(){return"$#,##0{0}_);\\($#,##0{0}\\)"}};t.default=o,e.exports=t.default,e.exports.default=t.default},91500:function(e,t,n){t.default=void 0;var i=g(n(20476)),o=n(35922),a=n(95479),r=g(n(17381)),s=n(40594),l=n(59937),u=n(2892),d=g(n(15564)),c=g(n(92286)),h=g(n(91331)),p=g(n(18016)),f=g(n(13024));function g(e){return e&&e.__esModule?e:{default:e}}var m="undefined"!=typeof Intl,_={shortdate:"M/d/y",shorttime:"h:mm a",longdate:"EEEE, MMMM d, y",longtime:"h:mm:ss a",monthandday:"MMMM d",monthandyear:"MMMM y",quarterandyear:"QQQ y",day:"d",year:"y",shortdateshorttime:"M/d/y, h:mm a",longdatelongtime:"EEEE, MMMM d, y, h:mm:ss a",month:"LLLL",shortyear:"yy",dayofweek:"EEEE",quarter:"QQQ",hour:"HH",minute:"mm",second:"ss",millisecond:"SSS","datetime-local":"yyyy-MM-ddTHH':'mm':'ss"},v={year:["y","yy","yyyy"],day:["d","dd"],month:["M","MM","MMM","MMMM"],hours:["H","HH","h","hh","ah"],minutes:["m","mm"],seconds:["s","ss"],milliseconds:["S","SS","SSS"]},y=(0,i.default)({engine:function(){return"base"},_getPatternByFormat:function(e){return _[e.toLowerCase()]},_expandPattern:function(e){return this._getPatternByFormat(e)||e},formatUsesMonthName:function(e){return-1!==this._expandPattern(e).indexOf("MMMM")},formatUsesDayName:function(e){return-1!==this._expandPattern(e).indexOf("EEEE")},getFormatParts:function(e){var t=this._getPatternByFormat(e)||e,n=[];return(0,a.each)(t.split(/\W+/),(function(e,t){(0,a.each)(v,(function(e,i){i.includes(t)&&n.push(e)}))})),n},getMonthNames:function(e){return d.default.getMonthNames(e)},getDayNames:function(e){return d.default.getDayNames(e)},getQuarterNames:function(e){return d.default.getQuarterNames(e)},getPeriodNames:function(e){return d.default.getPeriodNames(e)},getTimeSeparator:function(){return":"},is24HourFormat:function(e){for(var t=new Date(2017,0,20,11,0,0,0),n=new Date(2017,0,20,23,0,0,0),i=this.format(t,e),o=this.format(n,e),a=0;a<i.length;a++)if(i[a]!==o[a])return!isNaN(parseInt(i[a]))},format:function(e,t){if(e){if(!t)return e;var n;if("function"==typeof t)n=t;else if(t.formatter)n=t.formatter;else if(t=t.type||t,(0,o.isString)(t))return t=_[t.toLowerCase()]||t,p.default.convertDigits((0,s.getFormatter)(t,this)(e));if(n)return n(e)}},parse:function(e,t){var n,i,o=this;if(e){if(!t)return this.parse(e,"shortdate");if(t.parser)return t.parser(e);if("string"!=typeof t||_[t.toLowerCase()]){i=function(e){var n=o.format(e,t);return p.default.convertDigits(n,!0)};try{n=(0,l.getFormat)(i)}catch(e){}}else n=t;if(n)return e=p.default.convertDigits(e,!0),(0,u.getParser)(n,this)(e);r.default.log("W0012");var a=new Date(e);if(a&&!isNaN(a.getTime()))return a}},firstDayOfWeekIndex:function(){var e=h.default.getValueByClosestLocale((function(e){return c.default[e]}));return void 0===e?0:e}});m&&y.inject(f.default);var b=y;t.default=b,e.exports=t.default,e.exports.default=t.default},15564:function(e,t,n){t.default=void 0;var i=n(95479),o=["January","February","March","April","May","June","July","August","September","October","November","December"],a=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],r=["AM","PM"],s=["Q1","Q2","Q3","Q4"],l=function(e,t){var n={abbreviated:3,short:2,narrow:1};return(0,i.map)(e,(function(e){return e.substr(0,n[t])}))},u={getMonthNames:function(e){return l(o,e)},getDayNames:function(e){return l(a,e)},getQuarterNames:function(e){return s},getPeriodNames:function(e){return r}};t.default=u,e.exports=t.default,e.exports.default=t.default},18121:function(e,t){t.defaultMessages=void 0;t.defaultMessages={en:{Yes:"Yes",No:"No",Cancel:"Cancel",Clear:"Clear",Done:"Done",Loading:"Loading...",Select:"Select...",Search:"Search",Back:"Back",OK:"OK","dxCollectionWidget-noDataText":"No data to display","dxDropDownEditor-selectLabel":"Select","validation-required":"Required","validation-required-formatted":"{0} is required","validation-numeric":"Value must be a number","validation-numeric-formatted":"{0} must be a number","validation-range":"Value is out of range","validation-range-formatted":"{0} is out of range","validation-stringLength":"The length of the value is not correct","validation-stringLength-formatted":"The length of {0} is not correct","validation-custom":"Value is invalid","validation-custom-formatted":"{0} is invalid","validation-async":"Value is invalid","validation-async-formatted":"{0} is invalid","validation-compare":"Values do not match","validation-compare-formatted":"{0} does not match","validation-pattern":"Value does not match pattern","validation-pattern-formatted":"{0} does not match pattern","validation-email":"Email is invalid","validation-email-formatted":"{0} is invalid","validation-mask":"Value is invalid","dxLookup-searchPlaceholder":"Minimum character number: {0}","dxList-pullingDownText":"Pull down to refresh...","dxList-pulledDownText":"Release to refresh...","dxList-refreshingText":"Refreshing...","dxList-pageLoadingText":"Loading...","dxList-nextButtonText":"More","dxList-selectAll":"Select All","dxListEditDecorator-delete":"Delete","dxListEditDecorator-more":"More","dxScrollView-pullingDownText":"Pull down to refresh...","dxScrollView-pulledDownText":"Release to refresh...","dxScrollView-refreshingText":"Refreshing...","dxScrollView-reachBottomText":"Loading...","dxDateBox-simulatedDataPickerTitleTime":"Select time","dxDateBox-simulatedDataPickerTitleDate":"Select date","dxDateBox-simulatedDataPickerTitleDateTime":"Select date and time","dxDateBox-validation-datetime":"Value must be a date or time","dxFileUploader-selectFile":"Select a file","dxFileUploader-dropFile":"or Drop a file here","dxFileUploader-bytes":"bytes","dxFileUploader-kb":"kb","dxFileUploader-Mb":"Mb","dxFileUploader-Gb":"Gb","dxFileUploader-upload":"Upload","dxFileUploader-uploaded":"Uploaded","dxFileUploader-readyToUpload":"Ready to upload","dxFileUploader-uploadAbortedMessage":"Upload cancelled","dxFileUploader-uploadFailedMessage":"Upload failed","dxFileUploader-invalidFileExtension":"File type is not allowed","dxFileUploader-invalidMaxFileSize":"File is too large","dxFileUploader-invalidMinFileSize":"File is too small","dxRangeSlider-ariaFrom":"From","dxRangeSlider-ariaTill":"Till","dxSwitch-switchedOnText":"ON","dxSwitch-switchedOffText":"OFF","dxForm-optionalMark":"optional","dxForm-requiredMessage":"{0} is required","dxNumberBox-invalidValueMessage":"Value must be a number","dxNumberBox-noDataText":"No data","dxDataGrid-columnChooserTitle":"Column Chooser","dxDataGrid-columnChooserEmptyText":"Drag a column here to hide it","dxDataGrid-groupContinuesMessage":"Continues on the next page","dxDataGrid-groupContinuedMessage":"Continued from the previous page","dxDataGrid-groupHeaderText":"Group by This Column","dxDataGrid-ungroupHeaderText":"Ungroup","dxDataGrid-ungroupAllText":"Ungroup All","dxDataGrid-editingEditRow":"Edit","dxDataGrid-editingSaveRowChanges":"Save","dxDataGrid-editingCancelRowChanges":"Cancel","dxDataGrid-editingDeleteRow":"Delete","dxDataGrid-editingUndeleteRow":"Undelete","dxDataGrid-editingConfirmDeleteMessage":"Are you sure you want to delete this record?","dxDataGrid-validationCancelChanges":"Cancel changes","dxDataGrid-groupPanelEmptyText":"Drag a column header here to group by that column","dxDataGrid-noDataText":"No data","dxDataGrid-searchPanelPlaceholder":"Search...","dxDataGrid-filterRowShowAllText":"(All)","dxDataGrid-filterRowResetOperationText":"Reset","dxDataGrid-filterRowOperationEquals":"Equals","dxDataGrid-filterRowOperationNotEquals":"Does not equal","dxDataGrid-filterRowOperationLess":"Less than","dxDataGrid-filterRowOperationLessOrEquals":"Less than or equal to","dxDataGrid-filterRowOperationGreater":"Greater than","dxDataGrid-filterRowOperationGreaterOrEquals":"Greater than or equal to","dxDataGrid-filterRowOperationStartsWith":"Starts with","dxDataGrid-filterRowOperationContains":"Contains","dxDataGrid-filterRowOperationNotContains":"Does not contain","dxDataGrid-filterRowOperationEndsWith":"Ends with","dxDataGrid-filterRowOperationBetween":"Between","dxDataGrid-filterRowOperationBetweenStartText":"Start","dxDataGrid-filterRowOperationBetweenEndText":"End","dxDataGrid-applyFilterText":"Apply filter","dxDataGrid-trueText":"true","dxDataGrid-falseText":"false","dxDataGrid-sortingAscendingText":"Sort Ascending","dxDataGrid-sortingDescendingText":"Sort Descending","dxDataGrid-sortingClearText":"Clear Sorting","dxDataGrid-editingSaveAllChanges":"Save changes","dxDataGrid-editingCancelAllChanges":"Discard changes","dxDataGrid-editingAddRow":"Add a row","dxDataGrid-summaryMin":"Min: {0}","dxDataGrid-summaryMinOtherColumn":"Min of {1} is {0}","dxDataGrid-summaryMax":"Max: {0}","dxDataGrid-summaryMaxOtherColumn":"Max of {1} is {0}","dxDataGrid-summaryAvg":"Avg: {0}","dxDataGrid-summaryAvgOtherColumn":"Avg of {1} is {0}","dxDataGrid-summarySum":"Sum: {0}","dxDataGrid-summarySumOtherColumn":"Sum of {1} is {0}","dxDataGrid-summaryCount":"Count: {0}","dxDataGrid-columnFixingFix":"Fix","dxDataGrid-columnFixingUnfix":"Unfix","dxDataGrid-columnFixingLeftPosition":"To the left","dxDataGrid-columnFixingRightPosition":"To the right","dxDataGrid-exportTo":"Export","dxDataGrid-exportToExcel":"Export to Excel file","dxDataGrid-exporting":"Exporting...","dxDataGrid-excelFormat":"Excel file","dxDataGrid-selectedRows":"Selected rows","dxDataGrid-exportSelectedRows":"Export selected rows to {0}","dxDataGrid-exportAll":"Export all data to {0}","dxDataGrid-headerFilterEmptyValue":"(Blanks)","dxDataGrid-headerFilterOK":"OK","dxDataGrid-headerFilterCancel":"Cancel","dxDataGrid-ariaAdaptiveCollapse":"Hide additional data","dxDataGrid-ariaAdaptiveExpand":"Display additional data","dxDataGrid-ariaColumn":"Column","dxDataGrid-ariaValue":"Value","dxDataGrid-ariaFilterCell":"Filter cell","dxDataGrid-ariaCollapse":"Collapse","dxDataGrid-ariaExpand":"Expand","dxDataGrid-ariaDataGrid":"Data grid","dxDataGrid-ariaSearchInGrid":"Search in the data grid","dxDataGrid-ariaSelectAll":"Select all","dxDataGrid-ariaSelectRow":"Select row","dxDataGrid-ariaToolbar":"Data grid toolbar","dxDataGrid-filterBuilderPopupTitle":"Filter Builder","dxDataGrid-filterPanelCreateFilter":"Create Filter","dxDataGrid-filterPanelClearFilter":"Clear","dxDataGrid-filterPanelFilterEnabledHint":"Enable the filter","dxTreeList-ariaTreeList":"Tree list","dxTreeList-ariaSearchInGrid":"Search in the tree list","dxTreeList-ariaToolbar":"Tree list toolbar","dxTreeList-editingAddRowToNode":"Add","dxPager-infoText":"Page {0} of {1} ({2} items)","dxPager-pagesCountText":"of","dxPager-pageSizesAllText":"All","dxPivotGrid-grandTotal":"Grand Total","dxPivotGrid-total":"{0} Total","dxPivotGrid-fieldChooserTitle":"Field Chooser","dxPivotGrid-showFieldChooser":"Show Field Chooser","dxPivotGrid-expandAll":"Expand All","dxPivotGrid-collapseAll":"Collapse All","dxPivotGrid-sortColumnBySummary":'Sort "{0}" by This Column',"dxPivotGrid-sortRowBySummary":'Sort "{0}" by This Row',"dxPivotGrid-removeAllSorting":"Remove All Sorting","dxPivotGrid-dataNotAvailable":"N/A","dxPivotGrid-rowFields":"Row Fields","dxPivotGrid-columnFields":"Column Fields","dxPivotGrid-dataFields":"Data Fields","dxPivotGrid-filterFields":"Filter Fields","dxPivotGrid-allFields":"All Fields","dxPivotGrid-columnFieldArea":"Drop Column Fields Here","dxPivotGrid-dataFieldArea":"Drop Data Fields Here","