"use strict";

(function(root, factory) {
    if(typeof define === "function" && define.amd) {
        define(function(require, exports, module) {
            factory(exports);
        });
    } else if(typeof module === "object" && module.exports) {
        factory(exports);
    } else {
        factory(DevExpress.viz.map.sources);
    }
}(this, function(sources) {
    sources.eurasia = {"type":"FeatureCollection","features":[{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[123.5945,-12.4257],[123.5952,-12.4359],[123.5731,-12.4342],[123.5725,-12.4239],[123.5945,-12.4257]]]},"properties":{"scalerank":5,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Australia","sov_a3":"AU1","adm0_dif":1,"level":2,"type":"Dependency","admin":"Ashmore and Cartier Islands","adm0_a3":"ATC","geou_dif":0,"geounit":"Ashmore and Cartier Islands","gu_a3":"ATC","su_dif":0,"subunit":"Ashmore and Cartier Islands","su_a3":"ATC","brk_diff":0,"name":"Ashmore and Cartier Is.","name_long":"Ashmore and Cartier Islands","brk_a3":"ATC","brk_name":"Ashmore and Cartier Is.","brk_group":"","abbrev":"A.C.Is.","postal":"AU","formal_en":"Territory of Ashmore and Cartier Islands","formal_fr":"","note_adm0":"Auz.","note_brk":"","name_sort":"Ashmore and Cartier Islands","name_alt":"","mapcolor7":1,"mapcolor8":2,"mapcolor9":2,"mapcolor13":7,"pop_est":-99,"gdp_md_est":-99,"pop_year":-99,"lastcensus":-99,"gdp_year":-99,"economy":"7. Least developed region","income_grp":"5. Low income","wikipedia":-99,"fips_10":"","iso_a2":"-99","iso_a3":"-99","iso_n3":"036","un_a3":"-099","wb_a2":"-99","wb_a3":"-99","woe_id":-99,"adm0_a3_is":"AUS","adm0_a3_us":"ATC","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Oceania","region_un":"Oceania","subregion":"Australia and New Zealand","region_wb":"East Asia & Pacific","name_len":23,"long_len":27,"abbrev_len":7,"tiny":-99,"homepart":-99}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[12.4392,41.8984],[12.4306,41.8976],[12.4275,41.9007],[12.4306,41.9055],[12.4384,41.9062],[12.4392,41.8984]]]},"properties":{"scalerank":6,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Vatican","sov_a3":"VAT","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Vatican","adm0_a3":"VAT","geou_dif":0,"geounit":"Vatican","gu_a3":"VAT","su_dif":0,"subunit":"Vatican","su_a3":"VAT","brk_diff":0,"name":"Vatican","name_long":"Vatican","brk_a3":"VAT","brk_name":"Vatican","brk_group":"","abbrev":"Vat.","postal":"V","formal_en":"State of the Vatican City","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Vatican (Holy Sea)","name_alt":"Holy Sea","mapcolor7":1,"mapcolor8":3,"mapcolor9":4,"mapcolor13":2,"pop_est":832,"gdp_md_est":355,"pop_year":0,"lastcensus":-99,"gdp_year":0,"economy":"2. Developed region: nonG7","income_grp":"2. High income: nonOECD","wikipedia":0,"fips_10":"","iso_a2":"VA","iso_a3":"VAT","iso_n3":"336","un_a3":"336","wb_a2":"-99","wb_a3":"-99","woe_id":-99,"adm0_a3_is":"VAT","adm0_a3_us":"VAT","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Southern Europe","region_wb":"Europe & Central Asia","name_len":7,"long_len":7,"abbrev_len":4,"tiny":4,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[4.816,51.4328],[4.8207,51.4121],[4.848,51.4033],[4.9439,51.4078],[4.9926,51.4454],[5.031,51.4691],[5.0595,51.4531],[5.0734,51.4068],[5.0999,51.3465],[5.2142,51.279],[5.3108,51.2597],[5.4298,51.273],[5.4769,51.2851],[5.5088,51.275],[5.5404,51.2393],[5.6088,51.1984],[5.7523,51.1695],[5.7965,51.1531],[5.8271,51.1256],[5.8183,51.0864],[5.7498,50.9888],[5.7408,50.9599],[5.75,50.9502],[5.7366,50.9321],[5.6476,50.8667],[5.6395,50.8436],[5.6691,50.806],[5.6936,50.7748],[5.6945,50.7811],[5.831,50.8091],[5.8925,50.7526],[5.9939,50.7504],[6.006,50.7322],[6.1194,50.6792],[6.1545,50.6373],[6.2359,50.5967],[6.1685,50.5454],[6.1787,50.5225],[6.203,50.4991],[6.2949,50.4855],[6.3409,50.4518],[6.3437,50.4002],[6.3645,50.3162],[6.1751,50.2327],[6.1213,50.1394],[6.1165,50.121],[6.1101,50.1238],[6.0891,50.1546],[6.0548,50.1543],[5.9763,50.1672],[5.8669,50.0828],[5.8174,50.0127],[5.7881,49.9612],[5.744,49.9196],[5.7353,49.8756],[5.7408,49.8572],[5.7258,49.8333],[5.725,49.8083],[5.788,49.7589],[5.8037,49.7322],[5.8804,49.6448],[5.8565,49.6128],[5.8376,49.5783],[5.8154,49.5538],[5.7897,49.5383],[5.7104,49.5392],[5.6101,49.5282],[5.5424,49.511],[5.5073,49.5109],[5.4347,49.5545],[5.3535,49.6198],[5.302,49.651],[5.2788,49.6779],[5.215,49.6893],[5.1241,49.7215],[5.061,49.7565],[5.0069,49.7784],[4.9306,49.7893],[4.8676,49.7881],[4.8491,49.8471],[4.8415,49.9145],[4.79,49.9596],[4.8605,50.1359],[4.8187,50.1532],[4.7729,50.1391],[4.7066,50.0971],[4.6751,50.0469],[4.6562,50.0024],[4.545,49.9603],[4.3688,49.945],[4.1761,49.9603],[4.1493,49.9716],[4.137,49.9845],[4.1368,50],[4.1503,50.0239],[4.1839,50.0528],[4.1922,50.0941],[4.1577,50.1299],[4.1353,50.1438],[4.1441,50.1784],[4.1696,50.2218],[4.1746,50.2465],[4.0441,50.3213],[3.9497,50.3359],[3.8581,50.3386],[3.7886,50.347],[3.748,50.3435],[3.7188,50.3217],[3.6894,50.3061],[3.6673,50.3248],[3.6268,50.4573],[3.5954,50.4773],[3.477,50.4995],[3.3162,50.5074],[3.2733,50.5315],[3.2498,50.5912],[3.235,50.6629],[3.182,50.7317],[3.1549,50.7489],[3.1068,50.7794],[3.0229,50.7669],[2.922,50.7271],[2.8624,50.716],[2.8397,50.7118],[2.7594,50.7506],[2.6691,50.8114],[2.5968,50.8759],[2.5793,50.9118],[2.6015,50.9553],[2.5748,50.9886],[2.536,51.0495],[2.5249,51.0971],[2.9602,51.2654],[3.2252,51.3516],[3.3501,51.3777],[3.3801,51.2911],[3.4028,51.2636],[3.4325,51.2458],[3.472,51.2422],[3.5171,51.2636],[3.5803,51.2862],[3.6818,51.2757],[3.7557,51.2548],[3.7819,51.2332],[3.8308,51.2126],[3.9021,51.2077],[4.04,51.2471],[4.1726,51.3071],[4.2114,51.3487],[4.2262,51.3865],[4.3045,51.3615],[4.3737,51.356],[4.404,51.3671],[4.3848,51.4276],[4.4409,51.4598],[4.5034,51.4747],[4.5316,51.4486],[4.5888,51.4219],[4.634,51.4217],[4.7557,51.4911],[4.7842,51.4774],[4.8105,51.4527],[4.816,51.4328]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Belgium","sov_a3":"BEL","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Belgium","adm0_a3":"BEL","geou_dif":0,"geounit":"Belgium","gu_a3":"BEL","su_dif":0,"subunit":"Belgium","su_a3":"BEL","brk_diff":0,"name":"Belgium","name_long":"Belgium","brk_a3":"BEL","brk_name":"Belgium","brk_group":"","abbrev":"Belg.","postal":"B","formal_en":"Kingdom of Belgium","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Belgium","name_alt":"","mapcolor7":3,"mapcolor8":2,"mapcolor9":1,"mapcolor13":8,"pop_est":10414336,"gdp_md_est":389300,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"BE","iso_a3":"BEL","iso_n3":"056","un_a3":"056","wb_a2":"BE","wb_a3":"BEL","woe_id":-99,"adm0_a3_is":"BEL","adm0_a3_us":"BEL","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Western Europe","region_wb":"Europe & Central Asia","name_len":7,"long_len":7,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[16.9531,48.5988],[16.9488,48.5886],[16.9434,48.5509],[16.9045,48.5035],[16.8627,48.4414],[16.8654,48.3869],[16.9727,48.1981],[17.0679,48.0833],[17.0859,48.0396],[17.1474,48.006],[17.0891,47.9636],[17.0777,47.9009],[17.0399,47.8729],[17.0301,47.8371],[17.0459,47.8045],[17.0456,47.7638],[17.0666,47.7076],[16.9734,47.6953],[16.8627,47.6973],[16.823,47.694],[16.7859,47.6787],[16.7476,47.6863],[16.6475,47.739],[16.5909,47.7505],[16.551,47.7474],[16.5211,47.7245],[16.4696,47.6951],[16.4213,47.6745],[16.4321,47.6563],[16.6397,47.6089],[16.6766,47.536],[16.6366,47.4766],[16.623,47.4476],[16.5744,47.4247],[16.5147,47.4045],[16.4429,47.3995],[16.4344,47.3674],[16.4626,47.2731],[16.4397,47.2527],[16.4169,47.2234],[16.4384,47.1459],[16.4828,47.1404],[16.4927,47.1227],[16.4848,47.0913],[16.477,47.0579],[16.4612,47.0225],[16.4534,47.0068],[16.4239,46.997],[16.3318,47.0022],[16.2525,46.9719],[16.0931,46.8633],[16.0372,46.8448],[15.9769,46.8014],[15.9805,46.7059],[15.9723,46.6972],[15.9576,46.6776],[15.7669,46.7113],[15.7603,46.7107],[15.6326,46.6984],[15.5453,46.6546],[15.4393,46.6296],[15.217,46.643],[15.0007,46.626],[14.9494,46.6132],[14.8933,46.6059],[14.8406,46.5805],[14.8105,46.5446],[14.7567,46.4991],[14.6802,46.4634],[14.597,46.4361],[14.5771,46.4129],[14.5498,46.3997],[14.5035,46.417],[14.4659,46.4161],[14.4199,46.4279],[14.2673,46.4407],[14.0995,46.4619],[14.0196,46.4822],[13.9288,46.4982],[13.8313,46.5112],[13.7439,46.5143],[13.7,46.5203],[13.49,46.5556],[13.3516,46.5579],[13.1688,46.5727],[12.8056,46.6259],[12.6998,46.6475],[12.5986,46.6541],[12.4792,46.6725],[12.3883,46.7026],[12.3301,46.7598],[12.268,46.8359],[12.1541,46.9353],[12.1308,46.9848],[12.1655,47.0282],[12.2013,47.0609],[12.1972,47.075],[12.1694,47.0821],[11.9695,47.0397],[11.7757,46.9861],[11.6994,46.9847],[11.6255,46.9966],[11.5275,46.9974],[11.4332,46.9831],[11.2444,46.9757],[11.1339,46.9362],[11.0635,46.8591],[11.0251,46.797],[10.9933,46.777],[10.9273,46.7695],[10.8289,46.7752],[10.7598,46.7933],[10.6893,46.8464],[10.5798,46.8537],[10.4794,46.8551],[10.4528,46.8649],[10.4546,46.8994],[10.4149,46.9644],[10.3494,46.9848],[10.1798,46.8624],[10.1335,46.8515],[9.9969,46.8854],[9.8777,46.9377],[9.8646,46.976],[9.8453,47.0074],[9.745,47.0371],[9.6199,47.0575],[9.5803,47.0574],[9.5957,47.0758],[9.6105,47.1071],[9.6012,47.1321],[9.5719,47.1579],[9.5558,47.1855],[9.5511,47.2123],[9.5422,47.2341],[9.5368,47.2546],[9.5275,47.2708],[9.6091,47.3918],[9.6259,47.467],[9.5544,47.5111],[9.524,47.5242],[9.5489,47.534],[9.6506,47.5259],[9.7151,47.5508],[9.7489,47.5755],[9.8392,47.5523],[9.9716,47.5053],[10.0341,47.4736],[10.0599,47.4491],[10.0742,47.4285],[10.0663,47.3934],[10.0965,47.3796],[10.1588,47.3743],[10.2003,47.3634],[10.1857,47.3172],[10.183,47.2788],[10.2406,47.2841],[10.3128,47.3134],[10.3691,47.3661],[10.4039,47.417],[10.4304,47.5411],[10.4395,47.5516],[10.4828,47.5418],[10.6587,47.5472],[10.7416,47.5241],[10.873,47.5202],[10.8706,47.5008],[10.8939,47.4705],[10.9521,47.4267],[10.9809,47.3981],[11.042,47.3931],[11.136,47.4089],[11.1912,47.4252],[11.2119,47.4136],[11.2979,47.4249],[11.3741,47.4603],[11.393,47.4872],[11.4699,47.5061],[11.5739,47.5498],[11.7168,47.5835],[12.1856,47.6195],[12.2038,47.6467],[12.1969,47.7091],[12.2093,47.7183],[12.2684,47.7027],[12.3632,47.6882],[12.4357,47.6661],[12.4829,47.6373],[12.5266,47.6361],[12.5942,47.6563],[12.6858,47.6693],[12.7714,47.6394],[12.7962,47.607],[12.7812,47.5904],[12.7828,47.5642],[12.8094,47.5422],[12.8789,47.5064],[12.9681,47.4757],[13.0144,47.4781],[13.0315,47.508],[13.0479,47.5792],[13.0541,47.6551],[13.0336,47.6987],[12.9855,47.7094],[12.9281,47.7128],[12.8977,47.7219],[12.9083,47.7458],[12.9542,47.8078],[12.9535,47.8906],[12.8499,47.9848],[12.7601,48.076],[12.7604,48.107],[12.8143,48.1608],[12.8975,48.2037],[13.0821,48.2751],[13.1404,48.2899],[13.2152,48.3019],[13.3229,48.3313],[13.3746,48.3614],[13.4094,48.3941],[13.4599,48.5646],[13.4717,48.5718],[13.4866,48.5818],[13.6752,48.523],[13.6922,48.5328],[13.7239,48.5424],[13.7854,48.5875],[13.7988,48.6217],[13.7975,48.6864],[13.8029,48.7475],[13.8147,48.7669],[13.8432,48.7599],[13.9243,48.728],[13.9888,48.6924],[14.0491,48.6025],[14.1898,48.5786],[14.3676,48.5762],[14.4311,48.6163],[14.4887,48.6255],[14.5539,48.6133],[14.6913,48.5992],[14.7066,48.6719],[14.7859,48.7474],[14.8219,48.774],[14.9226,48.7714],[14.9474,48.8277],[14.9722,48.9839],[14.9935,49.0011],[15.0668,48.9979],[15.1397,48.9693],[15.1617,48.9463],[15.1996,48.9481],[15.2527,48.9639],[15.3109,48.974],[15.4029,48.9574],[15.5994,48.8864],[15.7008,48.8604],[15.765,48.8654],[15.8252,48.8645],[16.0572,48.7548],[16.2193,48.7394],[16.3673,48.739],[16.4148,48.7721],[16.4779,48.8001],[16.5436,48.7962],[16.601,48.7819],[16.7127,48.7342],[16.7645,48.722],[16.8332,48.7143],[16.8837,48.7037],[16.9283,48.6209],[16.9531,48.5988]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":4,"sovereignt":"Austria","sov_a3":"AUT","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Austria","adm0_a3":"AUT","geou_dif":0,"geounit":"Austria","gu_a3":"AUT","su_dif":0,"subunit":"Austria","su_a3":"AUT","brk_diff":0,"name":"Austria","name_long":"Austria","brk_a3":"AUT","brk_name":"Austria","brk_group":"","abbrev":"Aust.","postal":"A","formal_en":"Republic of Austria","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Austria","name_alt":"","mapcolor7":3,"mapcolor8":1,"mapcolor9":3,"mapcolor13":4,"pop_est":8210281,"gdp_md_est":329500,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"AT","iso_a3":"AUT","iso_n3":"040","un_a3":"040","wb_a2":"AT","wb_a3":"AUT","woe_id":-99,"adm0_a3_is":"AUT","adm0_a3_us":"AUT","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Western Europe","region_wb":"Europe & Central Asia","name_len":7,"long_len":7,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[106.6175,8.6828],[106.5893,8.6805],[106.568,8.7009],[106.6586,8.7664],[106.6495,8.723],[106.6525,8.7011],[106.6175,8.6828]],[[104.064,10.3908],[104.083,10.3411],[104.0758,10.2249],[104.0368,10.1107],[104.0483,10.061],[104.0185,10.0292],[103.9521,10.2429],[103.868,10.3354],[103.8495,10.3711],[103.8984,10.3685],[103.9858,10.427],[104.0277,10.4284],[104.064,10.3908]],[[107.1677,10.3972],[107.0838,10.3366],[107.0779,10.3875],[107.1509,10.4203],[107.1766,10.4462],[107.1949,10.4457],[107.1677,10.3972]],[[107.0313,20.747],[106.99,20.7431],[106.9106,20.8242],[106.9534,20.867],[107.0438,20.8368],[107.0645,20.8173],[107.064,20.7998],[107.0423,20.761],[107.0313,20.747]],[[106.8656,20.8157],[106.8541,20.7964],[106.8031,20.8437],[106.7694,20.8642],[106.7953,20.9279],[106.8551,20.8583],[106.8656,20.8157]],[[107.5213,20.9266],[107.4655,20.9005],[107.3992,20.9035],[107.4786,20.9523],[107.5189,21.0128],[107.5513,21.034],[107.5511,20.9812],[107.5213,20.9266]],[[107.6027,21.2168],[107.4587,21.0917],[107.4035,21.0937],[107.4525,21.2353],[107.4763,21.2689],[107.5627,21.2204],[107.6027,21.2168]],[[105.7823,22.9693],[105.843,22.9228],[105.9026,22.925],[105.9623,22.9375],[106.001,22.9748],[106.0685,22.9755],[106.1484,22.9701],[106.184,22.9551],[106.2494,22.8694],[106.279,22.8575],[106.3381,22.8635],[106.4509,22.8939],[106.5418,22.9083],[106.624,22.8743],[106.7803,22.7789],[106.7363,22.7109],[106.7016,22.6377],[106.6331,22.586],[106.5824,22.5732],[106.5504,22.5014],[106.5363,22.3954],[106.5536,22.3417],[106.5932,22.3245],[106.6365,22.2886],[106.6542,22.2415],[106.6601,22.1365],[106.6577,22.0182],[106.6636,21.9789],[106.6977,21.9862],[106.7295,22.0003],[106.7941,21.982],[106.8745,21.9513],[106.9252,21.9201],[106.971,21.9239],[107.0064,21.8934],[107.0198,21.8349],[107.0616,21.7942],[107.1785,21.7171],[107.2721,21.7106],[107.3512,21.6089],[107.4335,21.6423],[107.4714,21.5983],[107.641,21.6139],[107.7593,21.655],[107.8021,21.6452],[107.9084,21.5604],[107.9727,21.508],[107.9258,21.4989],[107.8091,21.4971],[107.7072,21.4059],[107.6367,21.3681],[107.527,21.3362],[107.41,21.2848],[107.3762,21.1941],[107.3733,21.1285],[107.3543,21.0552],[107.1647,20.9487],[107.1117,20.9596],[107.0752,20.9993],[107.0192,20.9912],[106.9814,20.9714],[106.9364,20.9741],[106.8862,20.95],[106.8206,20.9575],[106.7603,20.9911],[106.7252,20.9999],[106.6834,21.0003],[106.6755,20.9605],[106.7373,20.8062],[106.7534,20.7351],[106.5508,20.5266],[106.5729,20.3922],[106.518,20.2889],[106.3955,20.2059],[106.1657,19.992],[106.0622,19.9874],[105.9841,19.9391],[105.814,19.5875],[105.8121,19.467],[105.7854,19.3789],[105.7911,19.2942],[105.7164,19.1278],[105.6391,19.0572],[105.6218,18.9663],[105.732,18.7793],[105.7442,18.7463],[105.8082,18.6458],[105.8393,18.5742],[105.8883,18.5025],[106.0656,18.3164],[106.1445,18.2594],[106.2396,18.2207],[106.4119,18.0532],[106.499,17.9464],[106.4594,17.8737],[106.4789,17.7196],[106.3559,17.765],[106.3705,17.7469],[106.5168,17.6628],[106.7357,17.3672],[106.9262,17.2214],[107.1199,17.0555],[107.1804,16.8979],[107.3551,16.7937],[107.5493,16.6426],[107.5408,16.6086],[107.5935,16.5681],[107.7241,16.4878],[107.8031,16.4031],[107.8338,16.3225],[107.882,16.3096],[107.9363,16.3294],[107.9907,16.3371],[108.0294,16.3311],[108.088,16.2427],[108.1697,16.1637],[108.209,16.0911],[108.2408,16.1008],[108.2674,16.0898],[108.274,16.0291],[108.286,15.9891],[108.3953,15.8725],[108.4475,15.7627],[108.5778,15.5847],[108.6742,15.4836],[108.7428,15.4266],[108.8213,15.3779],[108.8982,15.1805],[108.9399,15.0015],[109.0225,14.8028],[109.0849,14.7162],[109.087,14.5526],[109.1373,14.3841],[109.1914,14.2705],[109.2073,14.1543],[109.2239,14.0967],[109.2446,14.0534],[109.3033,13.8564],[109.2881,13.765],[109.2471,13.8547],[109.2521,13.5905],[109.2881,13.4508],[109.2719,13.2793],[109.3096,13.2192],[109.3768,13.0255],[109.4239,12.956],[109.42,12.719],[109.4449,12.5996],[109.3814,12.6708],[109.3355,12.7519],[109.274,12.709],[109.2189,12.6458],[109.3047,12.3912],[109.2068,12.4154],[109.2157,12.0729],[109.2563,11.9929],[109.2592,11.9545],[109.2473,11.9087],[109.2202,11.9588],[109.2146,12.0104],[109.1991,11.999],[109.1999,11.9725],[109.1673,11.912],[109.1575,11.8371],[109.1927,11.7734],[109.1986,11.7249],[109.1732,11.6647],[109.1325,11.6011],[109.0396,11.5927],[109.0185,11.4684],[108.9867,11.3364],[108.8208,11.3154],[108.7003,11.1993],[108.5513,11.156],[108.4186,11.0407],[108.2717,10.9343],[108.1762,10.9202],[108.0949,10.8973],[108.0014,10.7204],[107.8451,10.7001],[107.5645,10.5555],[107.4703,10.4858],[107.3845,10.4586],[107.2615,10.3984],[107.2351,10.4199],[107.1941,10.4716],[107.0878,10.4983],[107.0357,10.5563],[107.0207,10.631],[107.0066,10.6605],[106.9837,10.6183],[106.9661,10.4407],[106.9475,10.4003],[106.9021,10.3828],[106.8127,10.4333],[106.7273,10.5356],[106.6059,10.4649],[106.6431,10.4563],[106.6984,10.4621],[106.7412,10.4444],[106.7775,10.3761],[106.7763,10.339],[106.7574,10.2958],[106.6436,10.2889],[106.4917,10.3041],[106.4641,10.2983],[106.6024,10.2317],[106.729,10.1933],[106.7853,10.1512],[106.7853,10.1165],[106.7142,10.0602],[106.6592,9.9914],[106.6581,9.9487],[106.6568,9.9011],[106.5956,9.8599],[106.5573,9.8681],[106.4491,9.9396],[106.1364,10.2217],[106.1836,10.1421],[106.5074,9.8212],[106.5644,9.7156],[106.5725,9.6411],[106.5392,9.6036],[106.4841,9.5594],[106.378,9.5561],[106.204,9.6754],[105.9257,9.9617],[105.831,10.0007],[106.1125,9.6736],[106.1586,9.5941],[106.2062,9.5023],[106.1926,9.4478],[106.1684,9.3967],[105.501,9.0932],[105.4014,8.9624],[105.3223,8.8011],[105.1912,8.7113],[105.1144,8.6292],[104.8919,8.5833],[104.7704,8.5977],[104.8963,8.7466],[104.8186,8.8019],[104.8146,9.1855],[104.8452,9.6062],[104.9032,9.8163],[104.9871,9.8687],[105.0926,9.901],[105.0949,9.9453],[105.0845,9.9957],[105.0278,10.0674],[104.9658,10.1006],[104.8732,10.1148],[104.802,10.2027],[104.7477,10.1991],[104.6635,10.1699],[104.6127,10.2077],[104.594,10.2669],[104.5161,10.34],[104.4264,10.4112],[104.467,10.4224],[104.5141,10.4633],[104.5643,10.516],[104.6896,10.5232],[104.8154,10.5208],[104.8506,10.5345],[104.9013,10.5902],[104.9839,10.6619],[105.0464,10.7017],[105.0611,10.7338],[105.0361,10.8094],[105.0223,10.8869],[105.0457,10.9114],[105.1595,10.8976],[105.2843,10.8615],[105.3146,10.8452],[105.3865,10.9401],[105.4058,10.9516],[105.4527,10.9514],[105.5766,10.9689],[105.6978,10.994],[105.7551,10.99],[105.8107,10.9261],[105.8533,10.8636],[105.8752,10.8585],[105.9382,10.8852],[105.9901,10.8518],[106.0988,10.7973],[106.164,10.7949],[106.1315,10.922],[106.168,11.0123],[106.1609,11.0371],[106.0995,11.0787],[105.8916,11.2448],[105.8561,11.2943],[105.8609,11.3724],[105.854,11.4871],[105.8354,11.5591],[105.8385,11.6013],[105.8515,11.635],[105.8898,11.6484],[105.9266,11.6529],[105.9563,11.6825],[106.0061,11.758],[106.1029,11.7513],[106.2392,11.7083],[106.3398,11.6818],[106.3992,11.687],[106.4125,11.6978],[106.4107,11.7384],[106.4178,11.9117],[106.4139,11.9484],[106.4996,11.9655],[106.631,11.9692],[106.7001,11.9793],[106.7646,12.0523],[106.9307,12.0775],[107.0507,12.1759],[107.159,12.2771],[107.2121,12.304],[107.2797,12.3216],[107.3301,12.319],[107.3934,12.2605],[107.446,12.2957],[107.5064,12.3646],[107.5381,12.4318],[107.5555,12.54],[107.5436,12.7059],[107.5115,12.8357],[107.4815,12.9331],[107.4754,13.0304],[107.5455,13.2254],[107.6055,13.4378],[107.5939,13.5217],[107.5286,13.6542],[107.4623,13.8156],[107.3895,13.993],[107.3621,14.0195],[107.3426,14.0689],[107.3314,14.1266],[107.3604,14.3079],[107.3645,14.3687],[107.4484,14.4512],[107.4932,14.5458],[107.5353,14.65],[107.5194,14.7051],[107.5138,14.8174],[107.5245,14.8718],[107.5047,14.9159],[107.4804,14.9799],[107.4963,15.0214],[107.5553,15.057],[107.5896,15.1185],[107.6337,15.1898],[107.6531,15.2552],[107.6217,15.3099],[107.5643,15.3916],[107.4596,15.4658],[107.3388,15.5605],[107.2794,15.6187],[107.2326,15.6781],[107.1896,15.7473],[107.1659,15.8025],[107.1889,15.8386],[107.3606,15.9217],[107.392,15.9517],[107.4102,15.9979],[107.3964,16.043],[107.3501,16.0674],[107.2965,16.084],[107.2174,16.1363],[107.0697,16.2798],[107.002,16.3118],[106.9307,16.3531],[106.8928,16.3965],[106.8511,16.5156],[106.8324,16.5263],[106.7916,16.4903],[106.7396,16.4525],[106.6961,16.459],[106.6564,16.4926],[106.6375,16.5379],[106.5937,16.6001],[106.5462,16.6507],[106.5337,16.821],[106.526,16.8766],[106.5022,16.9541],[106.4653,16.9818],[106.426,17.0025],[106.3334,17.1437],[106.2695,17.2168],[106.0063,17.4153],[105.9735,17.447],[105.9027,17.5287],[105.7795,17.6444],[105.6914,17.7378],[105.6272,17.8344],[105.5977,17.9183],[105.5885,17.9837],[105.5186,18.0774],[105.4582,18.1543],[105.4,18.1792],[105.3335,18.1896],[105.2732,18.2354],[105.1633,18.3387],[105.1146,18.4053],[105.0858,18.4501],[105.087,18.4962],[105.1135,18.573],[105.1454,18.6168],[105.1465,18.651],[105.1151,18.6789],[104.9932,18.7283],[104.7165,18.8034],[104.6133,18.8606],[104.518,18.9341],[104.4458,18.9838],[104.1086,19.1956],[104.0063,19.2309],[103.9184,19.2685],[103.8916,19.305],[103.8964,19.34],[103.932,19.3661],[104.0275,19.4205],[104.0629,19.4826],[104.0516,19.5642],[104.0135,19.6465],[104.032,19.6751],[104.0628,19.6784],[104.1271,19.6809],[104.2599,19.6855],[104.5463,19.6105],[104.5879,19.6187],[104.7432,19.7547],[104.8018,19.8361],[104.8151,19.904],[104.8458,19.9472],[104.9279,20.0181],[104.9292,20.0828],[104.8887,20.1691],[104.8479,20.2024],[104.8127,20.2168],[104.6987,20.2053],[104.677,20.2247],[104.6619,20.289],[104.6564,20.3285],[104.6188,20.3745],[104.4962,20.4137],[104.3922,20.4248],[104.3678,20.4414],[104.4078,20.4857],[104.4786,20.5296],[104.5327,20.5549],[104.5752,20.6002],[104.5832,20.6467],[104.5304,20.688],[104.4614,20.7337],[104.3496,20.8211],[104.1953,20.914],[104.1014,20.9455],[104.0521,20.9412],[103.882,20.8614],[103.7905,20.8095],[103.7145,20.7169],[103.6351,20.6971],[103.5547,20.7378],[103.4636,20.7798],[103.2107,20.8406],[103.1045,20.8917],[102.8838,21.2026],[102.8512,21.2659],[102.8723,21.3375],[102.8875,21.4399],[102.9096,21.5063],[102.9486,21.5698],[102.9592,21.6262],[102.9496,21.6813],[102.9177,21.7129],[102.8762,21.7223],[102.8452,21.7348],[102.8159,21.8074],[102.7982,21.7979],[102.7711,21.7097],[102.7386,21.6779],[102.6953,21.6621],[102.662,21.676],[102.6408,21.7114],[102.6313,21.7713],[102.6097,21.8518],[102.5825,21.9043],[102.4875,21.9578],[102.4427,22.0271],[102.3014,22.1782],[102.183,22.284],[102.1274,22.3792],[102.176,22.4146],[102.237,22.466],[102.3022,22.546],[102.3758,22.6466],[102.4064,22.708],[102.4279,22.7328],[102.4709,22.7509],[102.5172,22.741],[102.5985,22.7004],[102.721,22.6485],[102.8301,22.5872],[102.8742,22.5254],[102.9352,22.4662],[102.9819,22.4482],[103.0054,22.453],[103.0759,22.4975],[103.1363,22.5422],[103.1376,22.593],[103.1934,22.6385],[103.2663,22.7135],[103.3006,22.7644],[103.3267,22.7698],[103.3561,22.7547],[103.471,22.5974],[103.493,22.588],[103.5254,22.6116],[103.5707,22.7344],[103.6202,22.782],[103.6373,22.77],[103.915,22.5382],[103.9415,22.5401],[103.9714,22.5505],[103.9908,22.5861],[104.0127,22.6664],[104.0539,22.7523],[104.1431,22.8001],[104.2125,22.8094],[104.2383,22.7685],[104.2983,22.712],[104.3718,22.7041],[104.5269,22.8041],[104.5775,22.82],[104.6317,22.8182],[104.6873,22.8222],[104.74,22.8605],[104.7957,22.9111],[104.8147,23.0108],[104.8266,23.1002],[104.8647,23.1364],[104.9102,23.1605],[104.9957,23.1943],[105.1891,23.2811],[105.2388,23.3221],[105.2754,23.3452],[105.3505,23.3077],[105.4401,23.2354],[105.4945,23.1809],[105.5309,23.122],[105.5481,23.0727],[105.6912,23.0299],[105.7823,22.9693]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Vietnam","sov_a3":"VNM","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Vietnam","adm0_a3":"VNM","geou_dif":0,"geounit":"Vietnam","gu_a3":"VNM","su_dif":0,"subunit":"Vietnam","su_a3":"VNM","brk_diff":0,"name":"Vietnam","name_long":"Vietnam","brk_a3":"VNM","brk_name":"Vietnam","brk_group":"","abbrev":"Viet.","postal":"VN","formal_en":"Socialist Republic of Vietnam","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Vietnam","name_alt":"","mapcolor7":5,"mapcolor8":6,"mapcolor9":5,"mapcolor13":4,"pop_est":86967524,"gdp_md_est":241700,"pop_year":-99,"lastcensus":2009,"gdp_year":-99,"economy":"5. Emerging region: G20","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"VN","iso_a3":"VNM","iso_n3":"704","un_a3":"704","wb_a2":"VN","wb_a3":"VNM","woe_id":-99,"adm0_a3_is":"VNM","adm0_a3_us":"VNM","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"South-Eastern Asia","region_wb":"East Asia & Pacific","name_len":7,"long_len":7,"abbrev_len":5,"tiny":2,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[45.1528,39.5827],[45.1726,39.5706],[45.2525,39.5955],[45.2883,39.5656],[45.3499,39.5299],[45.4568,39.4945],[45.6107,39.5498],[45.6874,39.5641],[45.7505,39.5629],[45.7845,39.5456],[45.7965,39.4881],[45.7842,39.4172],[45.7663,39.3785],[45.7986,39.3502],[45.925,39.2819],[45.9774,39.2439],[45.9519,39.1781],[46.0459,39.0175],[46.0774,38.9549],[46.1145,38.8778],[45.9219,38.9079],[45.575,38.9728],[45.4797,39.0062],[45.3893,39.0959],[45.3355,39.1392],[45.256,39.1947],[45.1906,39.2156],[45.1412,39.2543],[45.1131,39.3116],[45.0717,39.3629],[45.0002,39.4235],[44.8382,39.6291],[44.8172,39.6504],[44.7834,39.6847],[44.7683,39.7035],[44.8672,39.7191],[45.0316,39.7651],[45.0765,39.7428],[45.1246,39.6963],[45.1486,39.6566],[45.1528,39.5827]],[[45.0236,41.0272],[45.0021,41.0158],[44.969,41.0272],[44.9589,41.0526],[44.9614,41.0792],[44.9943,41.0856],[45.0211,41.078],[45.0287,41.0539],[45.0236,41.0272]],[[46.5521,41.8123],[46.5713,41.8001],[46.616,41.8069],[46.6903,41.8313],[46.7493,41.8126],[46.8256,41.7434],[46.9309,41.6704],[46.9878,41.6214],[47.0102,41.5875],[47.064,41.5547],[47.1426,41.5161],[47.2053,41.4556],[47.2611,41.3151],[47.3177,41.2824],[47.5206,41.2291],[47.5918,41.2181],[47.791,41.1993],[47.8611,41.2127],[47.9637,41.334],[48.0561,41.4587],[48.1423,41.4848],[48.2981,41.545],[48.3914,41.6019],[48.4307,41.6633],[48.5187,41.7793],[48.5729,41.8445],[48.6646,41.7866],[48.8239,41.6296],[49.0509,41.374],[49.1066,41.3017],[49.1433,41.2178],[49.1747,41.1161],[49.2265,41.0262],[49.4567,40.7999],[49.5562,40.7163],[49.7184,40.6081],[49.776,40.584],[49.8518,40.5772],[49.9906,40.5768],[50.1191,40.5345],[50.1825,40.5048],[50.248,40.4618],[50.3068,40.4122],[50.3659,40.2795],[50.1432,40.3232],[49.9188,40.3164],[49.792,40.2879],[49.669,40.249],[49.5512,40.1941],[49.4773,40.0873],[49.4151,39.8398],[49.3244,39.6083],[49.3275,39.5012],[49.3674,39.3984],[49.3628,39.3496],[49.3212,39.3289],[49.2693,39.2852],[49.1998,39.0727],[49.1653,39.0303],[49.121,39.0039],[49.1087,39.0291],[49.1113,39.0847],[49.0135,39.134],[48.9617,39.0788],[48.9262,38.9618],[48.8545,38.8388],[48.8509,38.8153],[48.8688,38.4355],[48.8403,38.4373],[48.6355,38.3987],[48.5927,38.4111],[48.4174,38.5862],[48.3813,38.6056],[48.3056,38.6135],[48.2613,38.6423],[48.2252,38.6892],[48.2047,38.7241],[48.0232,38.819],[47.9965,38.8538],[47.9927,38.8843],[48.0193,38.9118],[48.0501,38.935],[48.1386,38.9586],[48.242,38.979],[48.2751,38.9936],[48.2921,39.0188],[48.291,39.0593],[48.2741,39.0991],[48.1255,39.1716],[48.1092,39.2028],[48.1044,39.2411],[48.1129,39.2811],[48.136,39.3124],[48.2572,39.355],[48.3222,39.3991],[48.2817,39.4483],[48.1511,39.5605],[47.9959,39.6839],[47.8923,39.6851],[47.7729,39.6486],[47.5818,39.5434],[47.4762,39.4983],[47.3385,39.4239],[47.1884,39.341],[47.0654,39.2529],[46.9889,39.1802],[46.8525,39.1484],[46.7832,39.0874],[46.5548,38.9044],[46.4906,38.9067],[46.4867,38.9975],[46.4898,39.0694],[46.4754,39.1109],[46.4015,39.1677],[46.4003,39.1922],[46.4203,39.2074],[46.4771,39.1982],[46.55,39.2014],[46.5848,39.2237],[46.5066,39.2985],[46.4373,39.3485],[46.3784,39.3823],[46.3652,39.4025],[46.3651,39.4168],[46.3776,39.4339],[46.4781,39.4751],[46.4881,39.5128],[46.4814,39.5552],[46.3217,39.6174],[46.2021,39.5945],[46.0948,39.6645],[46.0259,39.7186],[45.9399,39.7766],[45.8632,39.8083],[45.7896,39.8811],[45.6618,39.9562],[45.5798,39.9775],[45.581,39.989],[45.596,40.0028],[45.6302,40.0142],[45.8581,40.0113],[45.8859,40.0249],[45.9001,40.0571],[45.9313,40.1047],[45.9676,40.1748],[45.9646,40.2338],[45.7357,40.3291],[45.5695,40.4168],[45.4544,40.5324],[45.3762,40.6381],[45.3789,40.6736],[45.4014,40.7071],[45.5794,40.8045],[45.5914,40.8297],[45.5875,40.8469],[45.524,40.8967],[45.4442,40.948],[45.4191,40.9857],[45.3689,41.0049],[45.2734,41.0062],[45.1061,41.0693],[45.0705,41.0756],[45.0626,41.0881],[45.0707,41.1008],[45.1902,41.1264],[45.1886,41.1474],[45.1523,41.1751],[45.0848,41.1955],[45.0229,41.2457],[45.0014,41.291],[45.2172,41.4232],[45.281,41.4496],[45.4223,41.4253],[45.7156,41.3376],[45.6957,41.289],[45.7255,41.2616],[45.7928,41.2244],[45.922,41.1867],[46.0313,41.1673],[46.0865,41.1838],[46.1707,41.1979],[46.28,41.1544],[46.3808,41.0993],[46.431,41.0771],[46.4579,41.0702],[46.5344,41.0886],[46.6264,41.1597],[46.6624,41.2455],[46.6726,41.2868],[46.6189,41.3437],[46.5088,41.4056],[46.385,41.4599],[46.3055,41.5077],[46.2547,41.6021],[46.2035,41.6126],[46.1905,41.6249],[46.1821,41.6571],[46.1843,41.7021],[46.2019,41.7369],[46.2519,41.7518],[46.3025,41.7571],[46.3482,41.7902],[46.4055,41.8551],[46.4299,41.891],[46.5377,41.8704],[46.5521,41.8123]],[[45.4788,40.607],[45.5144,40.5996],[45.5523,40.6161],[45.5623,40.6492],[45.5342,40.664],[45.5045,40.6648],[45.4788,40.6483],[45.4788,40.607]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Azerbaijan","sov_a3":"AZE","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Azerbaijan","adm0_a3":"AZE","geou_dif":0,"geounit":"Azerbaijan","gu_a3":"AZE","su_dif":0,"subunit":"Azerbaijan","su_a3":"AZE","brk_diff":0,"name":"Azerbaijan","name_long":"Azerbaijan","brk_a3":"AZE","brk_name":"Azerbaijan","brk_group":"","abbrev":"Aze.","postal":"AZ","formal_en":"Republic of Azerbaijan","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Azerbaijan","name_alt":"","mapcolor7":1,"mapcolor8":6,"mapcolor9":5,"mapcolor13":8,"pop_est":8238672,"gdp_md_est":77610,"pop_year":-99,"lastcensus":2009,"gdp_year":-99,"economy":"6. Developing region","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"AZ","iso_a3":"AZE","iso_n3":"031","un_a3":"031","wb_a2":"AZ","wb_a3":"AZE","woe_id":-99,"adm0_a3_is":"AZE","adm0_a3_us":"AZE","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Western Asia","region_wb":"Europe & Central Asia","name_len":10,"long_len":10,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[91.9492,21.5081],[91.8889,21.5033],[91.8595,21.533],[91.8732,21.5744],[91.857,21.7088],[91.9077,21.7229],[91.934,21.7222],[91.9486,21.6826],[91.9619,21.6098],[91.9492,21.5081]],[[91.8738,21.8321],[91.8376,21.7502],[91.8197,21.8098],[91.8352,21.8854],[91.8507,21.9271],[91.8613,21.9267],[91.8825,21.8836],[91.8738,21.8321]],[[91.1508,22.1752],[91.0447,22.1052],[91.0795,22.5197],[91.1583,22.3654],[91.1782,22.283],[91.1508,22.1752]],[[91.5567,22.3822],[91.5104,22.3528],[91.4669,22.3784],[91.4113,22.4757],[91.4389,22.5988],[91.4561,22.6165],[91.484,22.5766],[91.523,22.4907],[91.5483,22.4254],[91.5567,22.3822]],[[90.7776,22.0893],[90.6036,22.0542],[90.515,22.0651],[90.6805,22.3275],[90.6749,22.445],[90.6492,22.5407],[90.5649,22.6176],[90.5604,22.6726],[90.5226,22.7475],[90.5029,22.8354],[90.5965,22.8635],[90.6723,22.8132],[90.683,22.7853],[90.6992,22.7135],[90.7369,22.6387],[90.8682,22.4849],[90.8658,22.3906],[90.8299,22.16],[90.7776,22.0893]],[[90.6418,22.963],[90.6596,22.92],[90.6039,22.9456],[90.5623,22.9754],[90.5363,23.0149],[90.5799,23.0354],[90.6418,22.963]],[[88.7619,26.2794],[88.828,26.2522],[88.8965,26.2605],[88.9407,26.2454],[88.9704,26.2509],[88.9815,26.2861],[88.9482,26.338],[88.9241,26.3751],[88.952,26.4121],[88.9834,26.4195],[89.0187,26.4103],[89.0668,26.3769],[89.102,26.3083],[89.1083,26.2022],[89.1864,26.106],[89.2893,26.0376],[89.3697,26.0061],[89.4669,25.9835],[89.5499,26.0053],[89.5914,26.0724],[89.5728,26.1323],[89.5857,26.186],[89.619,26.2157],[89.6709,26.2138],[89.7099,26.1712],[89.8229,25.9414],[89.7996,25.8396],[89.8249,25.5602],[89.7963,25.3758],[89.8009,25.3361],[89.8141,25.3054],[89.8333,25.2928],[89.8663,25.2932],[90.0038,25.2583],[90.1196,25.22],[90.2504,25.185],[90.4394,25.1577],[90.5553,25.1666],[90.6131,25.1677],[90.7302,25.1595],[91.0383,25.1741],[91.2932,25.178],[91.3967,25.1516],[91.4797,25.1421],[91.7635,25.1606],[92.0497,25.1695],[92.2047,25.1109],[92.3734,25.0151],[92.4684,24.9441],[92.4854,24.9033],[92.475,24.8685],[92.4432,24.8494],[92.385,24.8488],[92.2513,24.8951],[92.2283,24.8813],[92.2306,24.7862],[92.2267,24.771],[92.198,24.6857],[92.1175,24.4939],[92.102,24.4081],[92.0851,24.3862],[92.0642,24.3744],[92.0011,24.3709],[91.9517,24.3567],[91.9311,24.3255],[91.899,24.2607],[91.877,24.1953],[91.8462,24.1753],[91.7725,24.2106],[91.7266,24.2051],[91.6688,24.1901],[91.6111,24.1528],[91.5714,24.1066],[91.5264,24.0908],[91.3927,24.1001],[91.3671,24.0935],[91.3502,24.0605],[91.3364,24.0188],[91.232,23.9205],[91.1925,23.7629],[91.1604,23.6606],[91.1655,23.5811],[91.2538,23.3736],[91.3152,23.1044],[91.3389,23.077],[91.3594,23.0684],[91.3687,23.0746],[91.3668,23.1305],[91.3706,23.198],[91.3994,23.2139],[91.4362,23.1999],[91.4714,23.1413],[91.5112,23.0337],[91.5535,22.9916],[91.6195,22.9797],[91.6949,23.0048],[91.751,23.0535],[91.7738,23.1061],[91.7579,23.2098],[91.7542,23.2873],[91.79,23.361],[91.9191,23.471],[91.9379,23.5047],[91.9295,23.5982],[91.9296,23.686],[91.9785,23.692],[92.044,23.6778],[92.1271,23.721],[92.1523,23.7219],[92.1871,23.6755],[92.2461,23.6836],[92.2894,23.4925],[92.3342,23.3238],[92.3338,23.2424],[92.3412,23.0698],[92.3616,22.929],[92.3932,22.897],[92.4305,22.8218],[92.4645,22.7344],[92.4914,22.6854],[92.5096,22.5257],[92.5318,22.4103],[92.5612,22.048],[92.5749,21.9781],[92.5828,21.9403],[92.5843,21.609],[92.5935,21.4673],[92.6253,21.3507],[92.6316,21.3062],[92.5998,21.2702],[92.5686,21.2633],[92.5392,21.3198],[92.4719,21.363],[92.3727,21.409],[92.3306,21.4398],[92.2797,21.4276],[92.2082,21.3579],[92.1796,21.2931],[92.192,21.2022],[92.2147,21.1127],[92.2645,21.0615],[92.2685,21.0047],[92.2862,20.9316],[92.3119,20.8645],[92.3241,20.7918],[92.3078,20.7904],[92.2481,20.8836],[92.1946,20.9843],[92.0561,21.1748],[92.0109,21.5163],[92.008,21.6848],[91.9132,21.8831],[91.85,22.1574],[91.8248,22.2287],[91.8578,22.3173],[91.8634,22.3505],[91.8454,22.3431],[91.7971,22.2975],[91.7341,22.4067],[91.693,22.5048],[91.5297,22.7077],[91.4821,22.7974],[91.4801,22.8848],[91.4096,22.797],[91.3138,22.7352],[91.2162,22.6422],[91.1514,22.6141],[90.9456,22.597],[90.8268,22.7214],[90.6563,23.0255],[90.6336,23.0942],[90.6561,23.273],[90.6156,23.4423],[90.6161,23.5316],[90.604,23.5914],[90.5734,23.5781],[90.5616,23.5371],[90.5681,23.4743],[90.5557,23.4215],[90.408,23.4319],[90.2691,23.4559],[90.3915,23.3669],[90.5228,23.3461],[90.5909,23.2664],[90.5992,23.2042],[90.5951,23.1339],[90.5277,23.085],[90.466,23.0539],[90.4775,22.9868],[90.5522,22.9049],[90.4616,22.8818],[90.4369,22.8282],[90.4351,22.7519],[90.4807,22.6847],[90.4984,22.6348],[90.4874,22.5887],[90.5317,22.5393],[90.5955,22.4358],[90.6161,22.3622],[90.5895,22.2584],[90.5528,22.2182],[90.4941,22.1789],[90.3558,22.0482],[90.2882,21.8994],[90.2306,21.8298],[90.1588,21.8168],[90.1308,21.8474],[90.0712,21.8873],[90.07,21.9599],[90.0879,22.0175],[90.2096,22.1566],[90.1435,22.1379],[90.0686,22.0982],[89.9542,22.0229],[89.9181,22.1162],[89.894,22.2026],[89.8938,22.3084],[89.9852,22.4664],[89.8818,22.3876],[89.8532,22.289],[89.8658,22.173],[89.8525,22.0909],[89.8119,21.9835],[89.7568,21.919],[89.6678,21.8777],[89.6281,21.8142],[89.5686,21.7674],[89.5666,21.8606],[89.5475,21.9837],[89.4832,22.2755],[89.4693,22.2129],[89.5025,22.0319],[89.5006,21.9144],[89.452,21.8211],[89.3537,21.7211],[89.2786,21.707],[89.2343,21.7224],[89.1671,21.7843],[89.0939,21.8728],[89.0816,22.0149],[89.0515,22.0932],[89.0559,22.1862],[89.05,22.2746],[88.9715,22.5109],[88.9207,22.632],[88.927,22.6711],[88.9234,22.6875],[88.8997,22.8435],[88.867,22.9389],[88.8506,23.0405],[88.9281,23.1866],[88.8971,23.2104],[88.8076,23.2297],[88.7244,23.255],[88.704,23.2928],[88.7408,23.4366],[88.6977,23.493],[88.6357,23.55],[88.6164,23.5728],[88.596,23.6022],[88.5674,23.6744],[88.6226,23.8264],[88.6998,24.0025],[88.7138,24.0696],[88.7266,24.1862],[88.7336,24.2309],[88.7235,24.2749],[88.6423,24.326],[88.4985,24.3466],[88.397,24.3893],[88.3375,24.4539],[88.2871,24.4797],[88.225,24.4606],[88.1455,24.4858],[88.0791,24.5499],[88.0234,24.6278],[88.0303,24.6645],[88.0451,24.713],[88.1498,24.9146],[88.1889,24.9206],[88.2795,24.8819],[88.3134,24.8818],[88.3729,24.9615],[88.4563,25.1884],[88.5738,25.1879],[88.6775,25.1805],[88.7476,25.1689],[88.8173,25.1762],[88.8901,25.1944],[88.9298,25.223],[88.9517,25.2593],[88.9441,25.2908],[88.8548,25.3335],[88.8203,25.3655],[88.7954,25.4562],[88.7691,25.4905],[88.5935,25.4953],[88.5024,25.537],[88.4523,25.5744],[88.3631,25.6982],[88.2529,25.7898],[88.1475,25.8114],[88.1066,25.8411],[88.0846,25.8882],[88.0974,25.9563],[88.129,26.0182],[88.1508,26.0872],[88.2352,26.1781],[88.334,26.2575],[88.378,26.312],[88.4404,26.3695],[88.4479,26.401],[88.4367,26.4371],[88.3862,26.4715],[88.3515,26.4826],[88.3459,26.5048],[88.3699,26.5641],[88.4182,26.5715],[88.5183,26.5178],[88.6201,26.4307],[88.6807,26.353],[88.6828,26.2917],[88.7222,26.2818],[88.7619,26.2794]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Bangladesh","sov_a3":"BGD","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Bangladesh","adm0_a3":"BGD","geou_dif":0,"geounit":"Bangladesh","gu_a3":"BGD","su_dif":0,"subunit":"Bangladesh","su_a3":"BGD","brk_diff":0,"name":"Bangladesh","name_long":"Bangladesh","brk_a3":"BGD","brk_name":"Bangladesh","brk_group":"","abbrev":"Bang.","postal":"BD","formal_en":"People's Republic of Bangladesh","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Bangladesh","name_alt":"","mapcolor7":3,"mapcolor8":4,"mapcolor9":7,"mapcolor13":7,"pop_est":156050883,"gdp_md_est":224000,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"7. Least developed region","income_grp":"5. Low income","wikipedia":-99,"fips_10":"","iso_a2":"BD","iso_a3":"BGD","iso_n3":"050","un_a3":"050","wb_a2":"BD","wb_a3":"BGD","woe_id":-99,"adm0_a3_is":"BGD","adm0_a3_us":"BGD","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Southern Asia","region_wb":"South Asia","name_len":10,"long_len":10,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[28.5854,43.7422],[28.5618,43.5013],[28.4654,43.3893],[28.3196,43.4269],[28.1337,43.3956],[28.0352,43.2683],[27.9793,43.2305],[27.9289,43.1861],[27.8965,43.0207],[27.8889,42.7497],[27.8184,42.7167],[27.7537,42.7065],[27.4848,42.4681],[27.6396,42.401],[27.7082,42.35],[27.8214,42.208],[27.9827,42.0474],[28.0145,41.969],[27.8792,41.9866],[27.8319,41.9813],[27.8017,41.9565],[27.7389,41.9615],[27.6611,41.9613],[27.5799,41.9329],[27.5349,41.9208],[27.4748,41.9469],[27.3629,42.025],[27.2949,42.0795],[27.2443,42.0933],[27.1934,42.0771],[27.0117,42.0586],[26.9688,42.0269],[26.8849,41.9918],[26.8004,41.9751],[26.6792,41.9633],[26.6153,41.9649],[26.5797,41.9479],[26.5497,41.8967],[26.5293,41.8467],[26.5114,41.8264],[26.3604,41.8016],[26.3272,41.7728],[26.318,41.7447],[26.3209,41.7166],[26.2006,41.7438],[26.1074,41.7257],[26.0855,41.7042],[26.066,41.6732],[26.077,41.6402],[26.1112,41.6082],[26.1436,41.5215],[26.1552,41.4349],[26.1354,41.3857],[26.0664,41.3507],[25.9233,41.3119],[25.785,41.3304],[25.7239,41.315],[25.6215,41.3101],[25.5271,41.2998],[25.3819,41.2644],[25.2512,41.2436],[25.1334,41.3158],[24.9936,41.365],[24.8469,41.3942],[24.7958,41.3729],[24.7737,41.3561],[24.6511,41.42],[24.596,41.4427],[24.5693,41.4674],[24.5183,41.5525],[24.4879,41.5552],[24.3867,41.5235],[24.2895,41.525],[24.2304,41.5308],[24.0561,41.5272],[24.0329,41.4691],[24.0113,41.4601],[23.9735,41.4523],[23.8809,41.456],[23.7623,41.413],[23.6352,41.3868],[23.5358,41.386],[23.4334,41.3987],[23.3721,41.3896],[23.2398,41.385],[23.156,41.3221],[23.0256,41.3256],[22.916,41.3363],[22.9297,41.3561],[22.9515,41.6056],[23.0057,41.7169],[23.0036,41.7398],[22.992,41.7572],[22.9439,41.7751],[22.9092,41.8352],[22.8368,41.9936],[22.7961,42.0257],[22.6823,42.0591],[22.5827,42.1048],[22.4982,42.1651],[22.344,42.314],[22.4221,42.3289],[22.4457,42.3591],[22.5235,42.441],[22.5324,42.4812],[22.5242,42.5039],[22.4721,42.5433],[22.4362,42.6291],[22.4633,42.7095],[22.4656,42.7508],[22.4393,42.7917],[22.4668,42.8425],[22.5228,42.8703],[22.5581,42.8785],[22.7062,42.8839],[22.7999,42.9857],[22.8568,43.0183],[22.9152,43.076],[22.9423,43.0971],[22.968,43.142],[22.9769,43.188],[22.8596,43.2523],[22.8197,43.3007],[22.7676,43.3542],[22.697,43.3911],[22.5546,43.4545],[22.4991,43.5188],[22.4741,43.6022],[22.4363,43.6655],[22.3948,43.7066],[22.3869,43.7401],[22.3696,43.7813],[22.3654,43.8621],[22.399,43.9695],[22.4208,44.0074],[22.469,44.018],[22.5975,44.0753],[22.6034,44.1486],[22.6266,44.1941],[22.6675,44.2202],[22.7051,44.2378],[22.7752,44.1952],[22.9454,44.1273],[23.0285,44.078],[23.0244,44.0472],[22.9854,44.017],[22.9113,43.9872],[22.8683,43.9479],[22.8564,43.899],[22.8677,43.8646],[22.919,43.8345],[23.2246,43.8739],[23.5346,43.8536],[23.9508,43.7867],[24.2268,43.7635],[24.4306,43.7944],[24.8082,43.7384],[25.1597,43.6863],[25.4971,43.6708],[25.6861,43.7118],[25.8188,43.7668],[25.9334,43.8706],[26.2158,44.0073],[26.4893,44.084],[26.8478,44.1462],[27.0869,44.1674],[27.1207,44.1461],[27.4254,44.0205],[27.561,44.0201],[27.6709,43.9978],[27.7107,43.9646],[27.7386,43.9563],[27.8843,43.9874],[27.9489,43.9186],[28.05,43.8224],[28.222,43.7729],[28.3752,43.7448],[28.4234,43.7405],[28.5854,43.7422]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":4,"sovereignt":"Bulgaria","sov_a3":"BGR","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Bulgaria","adm0_a3":"BGR","geou_dif":0,"geounit":"Bulgaria","gu_a3":"BGR","su_dif":0,"subunit":"Bulgaria","su_a3":"BGR","brk_diff":0,"name":"Bulgaria","name_long":"Bulgaria","brk_a3":"BGR","brk_name":"Bulgaria","brk_group":"","abbrev":"Bulg.","postal":"BG","formal_en":"Republic of Bulgaria","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Bulgaria","name_alt":"","mapcolor7":4,"mapcolor8":5,"mapcolor9":1,"mapcolor13":8,"pop_est":7204687,"gdp_md_est":93750,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"BG","iso_a3":"BGR","iso_n3":"100","un_a3":"100","wb_a2":"BG","wb_a3":"BGR","woe_id":-99,"adm0_a3_is":"BGR","adm0_a3_us":"BGR","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Eastern Europe","region_wb":"Europe & Central Asia","name_len":8,"long_len":8,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[118.4074,24.5221],[118.4512,24.4556],[118.4327,24.4144],[118.2951,24.4363],[118.2873,24.4766],[118.3394,24.4691],[118.4074,24.5221]],[[121.0088,22.6204],[120.9469,22.5031],[120.8974,22.3792],[120.8773,22.2622],[120.8784,22.1416],[120.8643,22.0327],[120.8398,21.925],[120.7428,21.956],[120.6901,22.0331],[120.678,22.1597],[120.6076,22.3125],[120.5813,22.3564],[120.4798,22.4419],[120.3876,22.4845],[120.3162,22.5476],[120.3256,22.5424],[120.2729,22.6274],[120.2328,22.7179],[120.1501,22.9749],[120.1216,23.037],[120.0834,23.0937],[120.0725,23.1498],[120.0855,23.2121],[120.1212,23.3052],[120.143,23.3991],[120.1254,23.5266],[120.1321,23.6529],[120.159,23.709],[120.6297,24.4785],[120.7574,24.6423],[120.8359,24.7227],[120.9016,24.8133],[120.9641,24.928],[121.0406,25.0328],[121.0954,25.0651],[121.3654,25.1592],[121.4496,25.249],[121.5171,25.2769],[121.5937,25.2753],[121.6431,25.2324],[121.6871,25.1816],[121.7333,25.1541],[121.8528,25.1044],[121.9052,25.0564],[121.929,24.9737],[121.8563,24.8953],[121.8201,24.8245],[121.8134,24.7463],[121.8264,24.6405],[121.828,24.5344],[121.737,24.2853],[121.6394,24.1301],[121.6131,24.0527],[121.5834,23.8609],[121.5261,23.6683],[121.4771,23.4241],[121.3975,23.1725],[121.3522,23.0673],[121.2959,22.9666],[121.1612,22.7764],[121.0088,22.6204]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Taiwan","sov_a3":"TWN","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Taiwan","adm0_a3":"TWN","geou_dif":0,"geounit":"Taiwan","gu_a3":"TWN","su_dif":0,"subunit":"Taiwan","su_a3":"TWN","brk_diff":1,"name":"Taiwan","name_long":"Taiwan","brk_a3":"B77","brk_name":"Taiwan","brk_group":"","abbrev":"Taiwan","postal":"TW","formal_en":"","formal_fr":"","note_adm0":"","note_brk":"Self admin.; Claimed by China","name_sort":"Taiwan","name_alt":"","mapcolor7":1,"mapcolor8":5,"mapcolor9":7,"mapcolor13":2,"pop_est":22974347,"gdp_md_est":712000,"pop_year":-99,"lastcensus":-99,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"TW","iso_a3":"TWN","iso_n3":"158","un_a3":"-099","wb_a2":"-99","wb_a3":"-99","woe_id":-99,"adm0_a3_is":"TWN","adm0_a3_us":"TWN","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Eastern Asia","region_wb":"East Asia & Pacific","name_len":6,"long_len":6,"abbrev_len":6,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[25.97,40.1363],[25.7402,40.1055],[25.6689,40.1359],[25.7409,40.1963],[25.8748,40.2337],[25.9184,40.238],[25.9771,40.1778],[25.97,40.1363]],[[35.1141,41.957],[35.1221,41.8911],[35.2092,41.7944],[35.2978,41.7285],[35.558,41.634],[35.9198,41.7137],[35.9781,41.7048],[36.0518,41.6826],[36.1792,41.4266],[36.2784,41.3361],[36.4054,41.2746],[36.5097,41.2625],[36.5871,41.3267],[36.6471,41.3525],[36.7777,41.3635],[36.992,41.2754],[37.0662,41.1844],[37.431,41.1141],[37.7656,41.0789],[37.9101,41.0019],[38.3811,40.9245],[38.5569,40.9365],[38.8521,41.0177],[39.4264,41.1064],[39.8079,40.9825],[39.9111,40.9665],[40.0002,40.9771],[40.1284,40.943],[40.2652,40.9613],[40.6875,41.1074],[40.8195,41.1902],[40.9595,41.2116],[41.0836,41.2612],[41.4144,41.4236],[41.5101,41.5175],[41.5766,41.4973],[41.7018,41.4716],[41.7794,41.4405],[41.8235,41.4324],[41.9258,41.4957],[42.0777,41.4941],[42.2111,41.4867],[42.28,41.475],[42.3644,41.454],[42.4664,41.4398],[42.5079,41.4701],[42.5674,41.5593],[42.5904,41.5707],[42.6068,41.5788],[42.6824,41.5857],[42.7541,41.5789],[42.7879,41.5637],[42.8217,41.4924],[42.9067,41.4668],[43.0571,41.3528],[43.149,41.3071],[43.1713,41.2879],[43.141,41.2648],[43.1528,41.2364],[43.2055,41.1992],[43.2793,41.1852],[43.359,41.1901],[43.4023,41.1766],[43.4334,41.1555],[43.4416,41.126],[43.4395,41.1071],[43.4553,41.0647],[43.5175,41.0048],[43.5917,40.9682],[43.6316,40.929],[43.6965,40.7941],[43.7227,40.7195],[43.7129,40.6478],[43.6679,40.5741],[43.5693,40.4824],[43.5938,40.444],[43.6158,40.3933],[43.6084,40.3566],[43.6781,40.2393],[43.7099,40.1665],[43.6833,40.1497],[43.6662,40.1264],[43.7917,40.0703],[43.942,40.0231],[44.0054,40.0141],[44.178,40.0357],[44.2893,40.0404],[44.3996,39.9958],[44.5604,39.8876],[44.7338,39.7465],[44.7683,39.7035],[44.7834,39.6847],[44.8172,39.6504],[44.7821,39.6511],[44.725,39.6817],[44.5871,39.7686],[44.5167,39.7313],[44.456,39.6667],[44.3894,39.4221],[44.3354,39.396],[44.2404,39.3968],[44.124,39.4052],[44.0439,39.393],[44.0232,39.3774],[44.0338,39.351],[44.0575,39.3108],[44.0743,39.26],[44.0791,39.2183],[44.1213,39.1806],[44.178,39.1448],[44.1806,39.1081],[44.1719,39.0562],[44.1588,39.0167],[44.1445,38.9944],[44.1708,38.9344],[44.2324,38.8632],[44.2717,38.836],[44.257,38.7006],[44.2802,38.6407],[44.2979,38.5578],[44.2908,38.4201],[44.2985,38.3863],[44.3196,38.3747],[44.3758,38.3696],[44.4309,38.3568],[44.4499,38.3342],[44.4496,38.3178],[44.3809,38.2546],[44.3728,38.2097],[44.3489,38.1465],[44.3294,38.1093],[44.268,38.0388],[44.2289,37.9672],[44.2113,37.9081],[44.2229,37.8802],[44.3362,37.8718],[44.3978,37.8292],[44.5612,37.7446],[44.5899,37.7104],[44.5453,37.6582],[44.5461,37.6363],[44.5672,37.6086],[44.5771,37.5602],[44.5731,37.5064],[44.574,37.4354],[44.6041,37.4237],[44.7151,37.3571],[44.7941,37.2904],[44.7968,37.2698],[44.7583,37.2171],[44.7667,37.1563],[44.7651,37.1424],[44.731,37.1653],[44.6693,37.1736],[44.606,37.176],[44.566,37.1583],[44.496,37.1105],[44.402,37.0585],[44.3256,37.0107],[44.2818,36.978],[44.2457,36.9833],[44.2175,37.0119],[44.2017,37.0518],[44.2084,37.2026],[44.1918,37.2499],[44.1562,37.283],[44.1145,37.3019],[44.0646,37.3125],[44.0132,37.3135],[43.94,37.2693],[43.8364,37.2235],[43.6758,37.2272],[43.568,37.2358],[43.5158,37.2445],[43.3067,37.3146],[43.2631,37.3165],[43.1852,37.3449],[43.0925,37.3674],[42.9366,37.3248],[42.8691,37.3349],[42.7746,37.3719],[42.7411,37.3619],[42.6354,37.2493],[42.4559,37.1287],[42.359,37.1086],[42.3129,37.2296],[42.2686,37.2766],[42.2476,37.2822],[42.2027,37.2973],[42.1679,37.2886],[42.0599,37.2061],[41.8868,37.1564],[41.7436,37.1261],[41.5155,37.0892],[41.3396,37.0708],[41.2646,37.0693],[41.1021,37.0859],[40.9589,37.1092],[40.8156,37.1082],[40.7057,37.0977],[40.4504,37.0089],[40.0164,36.8261],[39.6865,36.7386],[39.5015,36.7022],[39.3566,36.6816],[39.1084,36.6806],[38.9064,36.6947],[38.7666,36.6931],[38.6889,36.7151],[38.578,36.7891],[38.4438,36.8623],[38.384,36.8792],[38.3059,36.8934],[38.1917,36.9016],[37.9066,36.7946],[37.818,36.7656],[37.7203,36.7437],[37.5235,36.6783],[37.4363,36.6433],[37.3271,36.6466],[37.1874,36.6559],[37.0662,36.6526],[36.9854,36.7024],[36.9418,36.7584],[36.7766,36.7927],[36.6586,36.8025],[36.6284,36.7777],[36.5969,36.7014],[36.5467,36.5063],[36.5375,36.4574],[36.6414,36.2635],[36.6367,36.234],[36.5624,36.2239],[36.4771,36.2207],[36.4215,36.2035],[36.3754,36.1712],[36.3476,36.0035],[36.2488,35.9727],[36.202,35.9375],[36.1536,35.8339],[36.1273,35.8314],[35.9676,35.9101],[35.8927,35.9166],[35.9569,35.9981],[35.8871,36.1591],[35.8109,36.3099],[35.8828,36.4063],[36.0317,36.5227],[36.1885,36.659],[36.1882,36.7431],[36.1801,36.8072],[36.1352,36.8516],[36.0489,36.9106],[35.9046,36.8476],[35.8016,36.7781],[35.7343,36.764],[35.6611,36.7243],[35.6256,36.6528],[35.5374,36.597],[35.3932,36.5752],[35.1762,36.6349],[34.9432,36.7257],[34.8112,36.7993],[34.7036,36.8168],[34.6014,36.7845],[34.2996,36.6042],[34.0234,36.3408],[33.9549,36.2952],[33.6947,36.182],[33.5228,36.144],[33.4418,36.1528],[33.0995,36.103],[32.9295,36.0957],[32.7948,36.0359],[32.5338,36.1007],[32.3777,36.1836],[32.2838,36.2679],[32.1306,36.4491],[32.022,36.5353],[31.7779,36.6128],[31.3525,36.8011],[31.2406,36.8217],[30.9503,36.8487],[30.644,36.8657],[30.582,36.7972],[30.5585,36.5258],[30.5061,36.4511],[30.4836,36.3104],[30.4461,36.2699],[30.3873,36.2433],[30.2954,36.2877],[30.2316,36.3073],[30.0832,36.2494],[29.7893,36.1681],[29.6891,36.1567],[29.3483,36.2588],[29.2236,36.3245],[29.1433,36.3972],[29.1161,36.5201],[29.0655,36.5901],[29.0581,36.6381],[29.0383,36.6935],[28.9696,36.7153],[28.8959,36.6736],[28.8169,36.6753],[28.7177,36.7009],[28.4836,36.8038],[28.3037,36.812],[28.1956,36.6863],[28.1115,36.6464],[28.0194,36.6345],[28.0142,36.6702],[28.084,36.7515],[27.8038,36.7365],[27.6559,36.6746],[27.5404,36.6842],[27.4539,36.7122],[27.4669,36.7463],[27.5547,36.7589],[27.6309,36.7867],[27.9345,36.8093],[28.0054,36.832],[28.083,36.9203],[28.2244,36.9964],[28.2424,37.0291],[28.1337,37.0295],[27.6684,37.0074],[27.3489,37.0196],[27.311,36.9819],[27.263,36.9766],[27.2497,37.0792],[27.3002,37.1269],[27.3682,37.1224],[27.5351,37.1639],[27.5201,37.2491],[27.4006,37.3067],[27.3763,37.3407],[27.2896,37.3487],[27.2192,37.3892],[27.2039,37.4914],[27.1479,37.6036],[27.068,37.6579],[27.0778,37.6877],[27.2244,37.7254],[27.2548,37.8823],[27.2324,37.9787],[27.1587,37.9869],[26.9438,38.0629],[26.8786,38.0548],[26.8074,38.1383],[26.6828,38.1983],[26.6211,38.1764],[26.5824,38.1493],[26.5247,38.1623],[26.4279,38.2144],[26.3329,38.2425],[26.2907,38.2772],[26.3437,38.3701],[26.4164,38.3679],[26.4297,38.4406],[26.3723,38.5619],[26.3778,38.6242],[26.4413,38.6412],[26.5136,38.6295],[26.5865,38.557],[26.6104,38.4869],[26.595,38.4186],[26.6413,38.3524],[26.6742,38.3357],[26.6964,38.4054],[26.7273,38.4186],[26.7699,38.3882],[26.8614,38.3729],[27.0986,38.4157],[27.1442,38.452],[26.9704,38.4479],[26.9068,38.4817],[26.8378,38.5576],[26.7953,38.6264],[26.7877,38.6602],[26.7637,38.7096],[26.7901,38.7361],[26.9092,38.7758],[27.0137,38.8869],[26.9701,38.919],[26.9203,38.9342],[26.8662,38.9229],[26.8149,38.961],[26.8083,39.0139],[26.8493,39.0567],[26.8536,39.1156],[26.7193,39.2606],[26.6818,39.2922],[26.7107,39.3396],[26.8133,39.419],[26.9109,39.5173],[26.8992,39.5497],[26.8271,39.5629],[26.4841,39.5207],[26.3508,39.4841],[26.1131,39.4674],[26.096,39.5208],[26.1014,39.5689],[26.1547,39.6566],[26.1498,39.8729],[26.1813,39.9901],[26.3134,40.025],[26.4754,40.1973],[26.7381,40.4002],[27.0121,40.3963],[27.1217,40.4523],[27.2846,40.4556],[27.3142,40.4149],[27.3326,40.3759],[27.4756,40.3199],[27.728,40.3288],[27.7894,40.3509],[27.8485,40.3817],[27.7318,40.4815],[27.7691,40.5096],[27.8749,40.5129],[27.9896,40.4895],[27.9948,40.4666],[27.9644,40.4353],[27.9289,40.3804],[27.9626,40.3699],[28.2891,40.403],[28.6303,40.3765],[28.7389,40.3909],[29.0071,40.3897],[29.0552,40.4242],[28.974,40.4674],[28.8946,40.4824],[28.8412,40.5035],[28.7879,40.534],[28.958,40.6306],[29.0541,40.6491],[29.5076,40.7084],[29.8449,40.7381],[29.8492,40.7601],[29.8006,40.7602],[29.3647,40.8093],[29.2598,40.8473],[29.1139,40.9378],[29.0822,40.9634],[29.0455,41.0076],[29.0674,41.1017],[29.0943,41.1772],[29.1481,41.221],[29.3223,41.2277],[29.9193,41.1508],[30.3449,41.1969],[30.8101,41.0849],[31.2549,41.1076],[31.3467,41.1579],[31.458,41.32],[32.0864,41.5892],[32.3064,41.7296],[32.5422,41.8064],[32.9467,41.8917],[33.2848,42.0046],[33.3813,42.0176],[34.193,41.9637],[34.7505,41.9568],[35.0064,42.0633],[35.1549,42.0275],[35.141,41.9895],[35.1141,41.957]],[[27.3629,42.025],[27.4748,41.9469],[27.5349,41.9208],[27.5799,41.9329],[27.6611,41.9613],[27.7389,41.9615],[27.8017,41.9565],[27.8319,41.9813],[27.8792,41.9866],[28.0145,41.969],[27.9873,41.8549],[28.0503,41.7292],[28.1979,41.5545],[28.3464,41.4664],[28.9468,41.2484],[29.0572,41.2297],[29.0321,41.1405],[28.996,41.0611],[28.9563,41.0082],[28.7804,40.9742],[28.2949,41.0715],[28.1722,41.0807],[28.0855,41.0613],[27.9252,40.9906],[27.7474,41.0133],[27.4994,40.9731],[27.4302,40.8399],[27.258,40.6874],[26.9746,40.564],[26.7721,40.498],[26.468,40.2615],[26.33,40.1234],[26.2718,40.0966],[26.2027,40.0754],[26.226,40.1417],[26.2602,40.2024],[26.2523,40.2481],[26.2538,40.3147],[26.3553,40.3902],[26.4475,40.445],[26.7203,40.5442],[26.7921,40.6266],[26.5781,40.6247],[26.3609,40.6063],[26.2242,40.6181],[26.1055,40.6113],[26.0678,40.6834],[26.039,40.7268],[26.0697,40.7403],[26.1092,40.7497],[26.1789,40.8265],[26.2412,40.8832],[26.3311,40.9545],[26.3541,40.9971],[26.3541,41.0368],[26.3326,41.0643],[26.3284,41.097],[26.3257,41.1433],[26.3307,41.2388],[26.5364,41.3431],[26.6023,41.3542],[26.6249,41.4018],[26.6098,41.5122],[26.5813,41.6013],[26.5445,41.6072],[26.495,41.6333],[26.4625,41.6634],[26.4105,41.6963],[26.3209,41.7166],[26.318,41.7447],[26.3272,41.7728],[26.3604,41.8016],[26.5114,41.8264],[26.5293,41.8467],[26.5497,41.8967],[26.5797,41.9479],[26.6153,41.9649],[26.6792,41.9633],[26.8004,41.9751],[26.8849,41.9918],[26.9688,42.0269],[27.0117,42.0586],[27.1934,42.0771],[27.2443,42.0933],[27.2949,42.0795],[27.3629,42.025]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Turkey","sov_a3":"TUR","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Turkey","adm0_a3":"TUR","geou_dif":0,"geounit":"Turkey","gu_a3":"TUR","su_dif":0,"subunit":"Turkey","su_a3":"TUR","brk_diff":0,"name":"Turkey","name_long":"Turkey","brk_a3":"TUR","brk_name":"Turkey","brk_group":"","abbrev":"Tur.","postal":"TR","formal_en":"Republic of Turkey","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Turkey","name_alt":"","mapcolor7":6,"mapcolor8":3,"mapcolor9":8,"mapcolor13":4,"pop_est":76805524,"gdp_md_est":902700,"pop_year":-99,"lastcensus":2000,"gdp_year":-99,"economy":"4. Emerging region: MIKT","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"TR","iso_a3":"TUR","iso_n3":"792","un_a3":"792","wb_a2":"TR","wb_a3":"TUR","woe_id":-99,"adm0_a3_is":"TUR","adm0_a3_us":"TUR","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Western Asia","region_wb":"Europe & Central Asia","name_len":6,"long_len":6,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[16.9187,45.2766],[17.1254,45.1718],[17.2106,45.1561],[17.2587,45.1706],[17.3241,45.164],[17.4691,45.1333],[17.5026,45.1204],[17.5463,45.1226],[17.6535,45.1635],[17.6901,45.1584],[17.8128,45.0781],[17.8744,45.0772],[17.9486,45.1119],[17.9963,45.1418],[18.1372,45.1194],[18.218,45.1329],[18.285,45.1343],[18.3576,45.1206],[18.4239,45.102],[18.4883,45.0858],[18.6626,45.0774],[18.7461,45.0265],[18.7794,44.9772],[18.7802,44.9472],[18.7884,44.9149],[18.8364,44.8833],[18.9413,44.8652],[19.0071,44.8692],[19.0421,44.8713],[19.1315,44.8996],[19.2368,44.9143],[19.3127,44.8975],[19.3486,44.8809],[19.3568,44.8585],[19.3345,44.7807],[19.2919,44.6968],[19.2231,44.6096],[19.1514,44.5273],[19.1324,44.4838],[19.1273,44.4146],[19.1185,44.36],[19.1283,44.3303],[19.1519,44.3025],[19.2315,44.2806],[19.3389,44.2258],[19.4302,44.1545],[19.5472,44.0735],[19.5838,44.0435],[19.5837,44.0111],[19.5495,43.9871],[19.4494,43.978],[19.3452,43.9851],[19.3053,43.9934],[19.2681,43.9834],[19.245,43.965],[19.2572,43.9433],[19.3641,43.8448],[19.4882,43.7036],[19.4951,43.6429],[19.48,43.5952],[19.4513,43.5621],[19.3996,43.5676],[19.3604,43.5935],[19.3008,43.5918],[19.2545,43.5844],[19.1943,43.5333],[19.1644,43.5354],[19.1128,43.5277],[19.0801,43.5177],[19.0283,43.5325],[18.9742,43.5423],[18.9507,43.5267],[18.9402,43.4967],[18.9738,43.4424],[19.0367,43.3573],[19.0267,43.2924],[18.9787,43.2854],[18.9347,43.3395],[18.8956,43.3482],[18.8511,43.3463],[18.7492,43.2835],[18.6742,43.2308],[18.6568,43.1939],[18.63,43.1537],[18.6219,43.1246],[18.6236,43.0277],[18.4885,43.0122],[18.4602,42.9979],[18.4438,42.9685],[18.4551,42.8441],[18.466,42.7772],[18.5433,42.6742],[18.5459,42.6416],[18.535,42.6201],[18.4801,42.5792],[18.4539,42.5645],[18.4363,42.5597],[18.3466,42.5867],[18.304,42.5994],[18.1239,42.6906],[18.0445,42.7413],[17.9188,42.8074],[17.8413,42.8451],[17.802,42.9022],[17.7402,42.9155],[17.6676,42.8971],[17.5852,42.9384],[17.6435,42.9598],[17.6578,42.9801],[17.6505,43.0066],[17.6248,43.0428],[17.4022,43.1989],[17.2931,43.3056],[17.2753,43.3438],[17.2738,43.4458],[17.248,43.4702],[17.0846,43.5166],[16.9019,43.649],[16.7135,43.7788],[16.6877,43.815],[16.5905,43.9132],[16.4721,44.0026],[16.3775,44.0596],[16.3001,44.1245],[16.2143,44.2151],[16.1698,44.352],[16.1303,44.4737],[16.1034,44.521],[16.049,44.5376],[15.8801,44.6819],[15.7366,44.7658],[15.738,44.8564],[15.7615,45.0075],[15.7881,45.179],[15.8229,45.2028],[15.8883,45.2157],[15.9632,45.2108],[16.0283,45.1896],[16.1573,45.0722],[16.2311,45.0266],[16.2934,45.0088],[16.365,45.0583],[16.4535,45.162],[16.5307,45.2167],[16.7908,45.1969],[16.9187,45.2766]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Bosnia and Herzegovina","sov_a3":"BIH","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Bosnia and Herzegovina","adm0_a3":"BIH","geou_dif":0,"geounit":"Bosnia and Herzegovina","gu_a3":"BIH","su_dif":0,"subunit":"Bosnia and Herzegovina","su_a3":"BIH","brk_diff":0,"name":"Bosnia and Herz.","name_long":"Bosnia and Herzegovina","brk_a3":"BIH","brk_name":"Bosnia and Herz.","brk_group":"","abbrev":"B.H.","postal":"BiH","formal_en":"Bosnia and Herzegovina","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Bosnia and Herzegovina","name_alt":"","mapcolor7":1,"mapcolor8":1,"mapcolor9":1,"mapcolor13":2,"pop_est":4613414,"gdp_md_est":29700,"pop_year":-99,"lastcensus":1991,"gdp_year":-99,"economy":"6. Developing region","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"BA","iso_a3":"BIH","iso_n3":"070","un_a3":"070","wb_a2":"BA","wb_a3":"BIH","woe_id":-99,"adm0_a3_is":"BIH","adm0_a3_us":"BIH","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Southern Europe","region_wb":"Europe & Central Asia","name_len":16,"long_len":22,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[71.7797,39.9502],[71.7529,39.9071],[71.7059,39.9174],[71.6689,39.9461],[71.6813,39.9687],[71.7365,39.981],[71.7653,39.9933],[71.7899,39.9953],[71.7797,39.9502]],[[71.2062,39.8926],[71.1562,39.8834],[71.0643,39.8849],[71.0117,39.8951],[71.0437,39.9763],[71.0448,39.9925],[71.041,39.9949],[71.0145,40.0058],[70.9744,40.0389],[70.9606,40.088],[70.9763,40.1333],[71.0055,40.1523],[71.0241,40.1492],[71.0804,40.0799],[71.1303,40.0597],[71.2287,40.0481],[71.1793,39.9798],[71.2156,39.9068],[71.2062,39.8926]],[[61.9902,43.4921],[62.072,43.4894],[62.2379,43.5096],[62.4594,43.5366],[62.6345,43.558],[62.8462,43.5839],[63.0477,43.6085],[63.207,43.628],[63.4448,43.6132],[63.6797,43.5986],[63.8481,43.5881],[64.0133,43.5778],[64.2088,43.5657],[64.3182,43.5589],[64.4432,43.5512],[64.4961,43.5716],[64.6041,43.6135],[64.7061,43.653],[64.8118,43.6939],[64.9055,43.7147],[65.0031,43.6491],[65.0849,43.5737],[65.1709,43.4942],[65.2705,43.4175],[65.3665,43.372],[65.4962,43.3105],[65.5707,43.2052],[65.6702,43.0646],[65.7356,42.9721],[65.803,42.877],[65.9011,42.9145],[66.0057,42.9546],[66.1003,42.9908],[66.0889,42.8734],[66.0785,42.7667],[66.0627,42.6052],[66.0498,42.4728],[66.0155,42.3148],[66.0132,42.1945],[66.0112,42.0888],[66.0096,42.0049],[66.1932,42.0011],[66.3288,41.9983],[66.4986,41.9949],[66.515,41.8894],[66.5379,41.7413],[66.5726,41.607],[66.6017,41.4943],[66.6453,41.3486],[66.6687,41.2708],[66.7097,41.1792],[66.7498,41.1571],[66.8143,41.1424],[67.0387,41.1533],[67.225,41.1624],[67.3716,41.1695],[67.528,41.1771],[67.7351,41.1873],[67.8051,41.1639],[67.8657,41.1803],[67.9357,41.1966],[67.9914,41.13],[68.0197,41.0962],[68.0594,41.0613],[68.1131,41.0286],[68.0903,40.9603],[68.057,40.8606],[68.0477,40.8093],[68.1123,40.7541],[68.1603,40.7218],[68.2919,40.6561],[68.415,40.6194],[68.4957,40.6086],[68.5727,40.6227],[68.6007,40.66],[68.5937,40.7113],[68.5565,40.7651],[68.5593,40.8293],[68.5841,40.8763],[68.6628,40.9615],[68.7371,41.0419],[68.8512,41.1238],[68.9869,41.205],[69.0435,41.2641],[69.0649,41.3669],[69.1536,41.4252],[69.2493,41.4603],[69.3684,41.4906],[69.401,41.5419],[69.5651,41.6291],[69.6639,41.6721],[69.7881,41.6973],[69.96,41.7541],[70.0956,41.8205],[70.2259,41.946],[70.3289,42.028],[70.416,42.0786],[70.4891,42.0803],[70.5401,42.0395],[70.5843,42.036],[70.6133,42.0547],[70.6625,42.1075],[70.7152,42.1687],[70.7646,42.1942],[70.8604,42.2072],[70.9468,42.2487],[70.979,42.2666],[71.036,42.2847],[71.13,42.25],[71.2127,42.2064],[71.2323,42.1863],[71.2285,42.1629],[71.0322,42.0778],[70.9104,42.038],[70.8566,42.0308],[70.8419,42.0196],[70.8033,41.9227],[70.7277,41.9052],[70.6309,41.8755],[70.5629,41.8308],[70.455,41.725],[70.181,41.5714],[70.177,41.54],[70.2009,41.5145],[70.29,41.4968],[70.4078,41.4496],[70.4714,41.4126],[70.6459,41.4604],[70.6889,41.4498],[70.7344,41.4005],[70.7824,41.2625],[70.8604,41.2249],[70.9626,41.196],[71.026,41.1866],[71.1107,41.1526],[71.2234,41.1399],[71.2988,41.1525],[71.3931,41.1234],[71.4084,41.136],[71.4209,41.3419],[71.5,41.3075],[71.5456,41.3081],[71.5855,41.3333],[71.6063,41.3674],[71.6196,41.4354],[71.6022,41.5033],[71.6375,41.5342],[71.6649,41.5412],[71.6852,41.533],[71.6973,41.5156],[71.7007,41.454],[71.7577,41.428],[71.7925,41.4131],[71.8258,41.361],[71.858,41.3114],[71.8786,41.195],[71.9585,41.1871],[72.0524,41.1647],[72.1154,41.1866],[72.1643,41.1737],[72.181,41.1185],[72.1807,41.0668],[72.1873,41.0259],[72.2131,41.0143],[72.2949,41.0399],[72.3641,41.0435],[72.4273,41.0189],[72.506,40.9817],[72.6204,40.8838],[72.6583,40.8699],[72.831,40.8622],[72.8666,40.8423],[72.926,40.8424],[72.99,40.8601],[73.1321,40.8285],[73.1369,40.8106],[73.1129,40.786],[72.7738,40.6504],[72.7488,40.6087],[72.6796,40.5556],[72.6041,40.5254],[72.5675,40.5244],[72.4021,40.5781],[72.3826,40.5651],[72.369,40.5435],[72.3697,40.5197],[72.406,40.4631],[72.3893,40.4274],[72.3577,40.4017],[72.254,40.4242],[72.2347,40.4386],[72.2328,40.4544],[72.1929,40.4544],[72.1313,40.4386],[72.0126,40.3407],[71.9711,40.2895],[71.9557,40.2586],[71.9027,40.241],[71.8454,40.2343],[71.7727,40.188],[71.6925,40.1523],[71.6668,40.1786],[71.6509,40.208],[71.6299,40.2171],[71.5805,40.2103],[71.5204,40.209],[71.4574,40.242],[71.3762,40.2752],[71.3047,40.2869],[71.0945,40.2712],[70.9906,40.2549],[70.958,40.2389],[70.8994,40.2346],[70.6531,40.2012],[70.6027,40.2142],[70.5658,40.2671],[70.5336,40.3245],[70.4699,40.3454],[70.3982,40.3614],[70.3716,40.3841],[70.3697,40.412],[70.3771,40.4393],[70.3826,40.4535],[70.5488,40.5628],[70.6983,40.6612],[70.712,40.6691],[70.7256,40.6878],[70.7511,40.7218],[70.751,40.7396],[70.6392,40.7786],[70.6348,40.7966],[70.6573,40.8151],[70.6573,40.8396],[70.5782,40.9115],[70.4415,41.0234],[70.402,41.0351],[70.3727,41.0276],[70.3189,40.9192],[70.2921,40.8917],[70.1363,40.8204],[70.0057,40.7714],[69.7732,40.6843],[69.7129,40.657],[69.6708,40.662],[69.6284,40.6791],[69.4982,40.7671],[69.4139,40.7972],[69.3572,40.7674],[69.3094,40.7239],[69.314,40.6348],[69.26,40.5876],[69.2063,40.5666],[69.3042,40.3274],[69.2944,40.2966],[69.2195,40.2881],[69.2749,40.1981],[69.2283,40.1876],[69.1104,40.2087],[68.9518,40.2226],[68.6525,40.1827],[68.6307,40.1671],[68.6225,40.1473],[68.6397,40.1292],[68.7846,40.1271],[68.9269,40.1363],[68.966,40.1196],[68.9721,40.0899],[68.9557,40.0713],[68.9085,40.0682],[68.8047,40.0503],[68.7928,40.0315],[68.7895,40.0133],[68.8244,39.9608],[68.8639,39.9273],[68.8688,39.9075],[68.8522,39.891],[68.8324,39.8843],[68.7977,39.9091],[68.7778,39.9042],[68.768,39.8818],[68.7582,39.8556],[68.7353,39.8362],[68.6869,39.8463],[68.639,39.8389],[68.6104,39.7433],[68.5861,39.635],[68.5069,39.5628],[68.4633,39.5367],[68.399,39.5289],[68.303,39.5377],[68.2449,39.5483],[68.0771,39.5642],[67.9086,39.5938],[67.719,39.6214],[67.5425,39.5576],[67.4917,39.5187],[67.4596,39.4824],[67.4262,39.4656],[67.3496,39.2421],[67.3576,39.2167],[67.4004,39.1967],[67.6165,39.1503],[67.6483,39.1311],[67.6673,39.1092],[67.6766,39.0085],[67.6944,38.9946],[67.7686,38.9822],[67.8757,38.983],[67.9596,38.9929],[68.0443,38.9836],[68.1035,38.962],[68.1325,38.9276],[68.1485,38.8906],[68.0479,38.6693],[68.056,38.5889],[68.0872,38.4735],[68.1441,38.3831],[68.2514,38.2945],[68.3331,38.2378],[68.3503,38.211],[68.3545,38.1695],[68.3412,38.1168],[68.294,38.0329],[68.2365,37.9597],[68.174,37.9284],[68.0876,37.8354],[68.0109,37.7209],[67.8636,37.5707],[67.8144,37.487],[67.798,37.245],[67.759,37.1722],[67.7529,37.1998],[67.7,37.2272],[67.6074,37.2225],[67.5465,37.2356],[67.5173,37.2667],[67.4417,37.258],[67.3197,37.2096],[67.1955,37.2352],[67.0688,37.3348],[66.8277,37.3713],[66.5223,37.3485],[66.5106,37.4587],[66.5113,37.5992],[66.5256,37.7857],[66.6293,37.932],[66.6264,37.9599],[66.6063,37.9867],[66.5745,38.0108],[66.3897,38.0509],[66.3354,38.0722],[66.2637,38.1181],[66.1731,38.1667],[66.0948,38.2001],[65.9712,38.2442],[65.8571,38.2688],[65.7902,38.25],[65.7285,38.2264],[65.6709,38.2257],[65.6129,38.2386],[65.3996,38.3488],[65.0767,38.5395],[64.8207,38.6725],[64.66,38.736],[64.6219,38.7564],[64.5316,38.8162],[64.31,38.9773],[64.1628,38.9536],[63.9525,39.0583],[63.7637,39.1605],[63.7208,39.1881],[63.5061,39.3771],[63.2919,39.4995],[63.0581,39.6332],[62.9068,39.7168],[62.6507,39.8585],[62.5255,39.9441],[62.4832,39.9756],[62.4416,40.0362],[62.375,40.3321],[62.298,40.4675],[62.1885,40.5412],[62.095,40.6833],[62.0176,40.8938],[61.9535,41.0306],[61.9028,41.0937],[61.7999,41.1634],[61.6445,41.2398],[61.497,41.2761],[61.4437,41.2746],[61.4174,41.2651],[61.3875,41.2521],[61.3289,41.1951],[61.2424,41.1892],[61.1793,41.1906],[61.1199,41.2109],[60.9332,41.229],[60.8672,41.2487],[60.7549,41.2458],[60.5136,41.2162],[60.455,41.2216],[60.2,41.349],[60.0896,41.3994],[60.0674,41.4273],[60.0688,41.4762],[60.1061,41.5452],[60.138,41.5941],[60.124,41.645],[60.0756,41.7005],[60.0756,41.7597],[60.1086,41.7927],[60.1764,41.7823],[60.2008,41.8031],[60.1921,41.8344],[60.1556,41.857],[60.1069,41.9074],[59.9626,41.9544],[59.9418,41.9735],[59.9493,41.9954],[59.9741,42.0188],[59.9792,42.0681],[59.9816,42.1317],[60.0008,42.1647],[60.0061,42.1908],[59.9852,42.2117],[59.9365,42.236],[59.8583,42.2952],[59.7626,42.3016],[59.4511,42.2995],[59.3543,42.3233],[59.2766,42.3562],[59.1991,42.4817],[59.1596,42.5114],[59.1231,42.5238],[59.0358,42.5281],[58.9309,42.5403],[58.877,42.5615],[58.73,42.6762],[58.5891,42.7785],[58.5323,42.6819],[58.4771,42.6628],[58.3531,42.6717],[58.2597,42.6881],[58.2064,42.6663],[58.1516,42.6281],[58.162,42.603],[58.2041,42.5764],[58.2887,42.5273],[58.4182,42.4067],[58.477,42.3401],[58.4858,42.3168],[58.4744,42.2994],[58.457,42.2918],[58.4314,42.2921],[58.3971,42.2925],[58.3771,42.3125],[58.3705,42.3468],[58.3272,42.3989],[58.2829,42.4289],[58.2341,42.4477],[58.1656,42.4616],[58.0755,42.4865],[58.0289,42.4876],[57.9835,42.4588],[57.9457,42.42],[57.9234,42.3352],[57.856,42.2311],[57.8143,42.1898],[57.6861,42.1648],[57.3817,42.1563],[57.2906,42.1238],[57.2288,42.0845],[57.1136,41.9571],[57.0337,41.9148],[56.9641,41.8565],[56.9849,41.6693],[57.0182,41.4506],[57.0767,41.39],[57.1139,41.3718],[57.1188,41.3503],[57.0948,41.3313],[57.0643,41.3073],[57.018,41.2635],[56.9658,41.2651],[56.8608,41.2761],[56.7736,41.288],[56.4799,41.3006],[56.242,41.3108],[55.9774,41.3222],[55.9773,41.5518],[55.9771,41.7813],[55.9771,42.0109],[55.977,42.2404],[55.9769,42.47],[55.9768,42.6995],[55.9767,42.9291],[55.9766,43.1586],[55.9765,43.3881],[55.9764,43.6176],[55.9763,43.8472],[55.9762,44.0768],[55.9761,44.3063],[55.976,44.5358],[55.9758,44.7654],[55.9757,44.9949],[56.1005,45.0234],[56.2579,45.0593],[56.4092,45.0938],[56.5888,45.1348],[56.7919,45.1811],[56.965,45.2206],[57.1717,45.2677],[57.3293,45.3037],[57.4773,45.3375],[57.6667,45.3774],[57.961,45.4397],[58.1252,45.4744],[58.2911,45.5094],[58.4494,45.5429],[58.5553,45.5554],[58.6689,45.5076],[58.807,45.4418],[58.9451,45.376],[59.0834,45.3102],[59.2215,45.2444],[59.3596,45.1786],[59.4979,45.1128],[59.6359,45.0471],[59.774,44.9813],[59.9122,44.9156],[60.0503,44.8498],[60.1885,44.784],[60.3267,44.7182],[60.4647,44.6524],[60.6029,44.5866],[60.7411,44.5208],[60.8792,44.4551],[61.0079,44.3938],[61.0653,44.3484],[61.0971,44.2482],[61.1607,44.1686],[61.2715,44.0823],[61.3851,43.9939],[61.5259,43.8772],[61.6236,43.7962],[61.7232,43.7136],[61.8876,43.5772],[61.9902,43.4921]],[[70.5688,40.9818],[70.6228,40.9344],[70.6525,40.9366],[70.6492,40.9608],[70.6184,41.0017],[70.5721,41.0248],[70.55,41.0149],[70.5688,40.9818]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Uzbekistan","sov_a3":"UZB","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Uzbekistan","adm0_a3":"UZB","geou_dif":0,"geounit":"Uzbekistan","gu_a3":"UZB","su_dif":0,"subunit":"Uzbekistan","su_a3":"UZB","brk_diff":0,"name":"Uzbekistan","name_long":"Uzbekistan","brk_a3":"UZB","brk_name":"Uzbekistan","brk_group":"","abbrev":"Uzb.","postal":"UZ","formal_en":"Republic of Uzbekistan","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Uzbekistan","name_alt":"","mapcolor7":2,"mapcolor8":3,"mapcolor9":5,"mapcolor13":4,"pop_est":27606007,"gdp_md_est":71670,"pop_year":-99,"lastcensus":1989,"gdp_year":-99,"economy":"6. Developing region","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"UZ","iso_a3":"UZB","iso_n3":"860","un_a3":"860","wb_a2":"UZ","wb_a3":"UZB","woe_id":-99,"adm0_a3_is":"UZB","adm0_a3_us":"UZB","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Central Asia","region_wb":"Europe & Central Asia","name_len":10,"long_len":10,"abbrev_len":4,"tiny":5,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[50.6072,25.8831],[50.5749,25.8068],[50.544,25.8335],[50.4659,25.9655],[50.4895,26.0584],[50.4524,26.1908],[50.4699,26.229],[50.5641,26.2464],[50.5859,26.2407],[50.5578,26.1983],[50.6098,26.1245],[50.6175,26.0023],[50.6072,25.8831]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":4,"sovereignt":"Bahrain","sov_a3":"BHR","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Bahrain","adm0_a3":"BHR","geou_dif":0,"geounit":"Bahrain","gu_a3":"BHR","su_dif":0,"subunit":"Bahrain","su_a3":"BHR","brk_diff":0,"name":"Bahrain","name_long":"Bahrain","brk_a3":"BHR","brk_name":"Bahrain","brk_group":"","abbrev":"Bahr.","postal":"BH","formal_en":"Kingdom of Bahrain","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Bahrain","name_alt":"","mapcolor7":1,"mapcolor8":1,"mapcolor9":1,"mapcolor13":9,"pop_est":727785,"gdp_md_est":26820,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"6. Developing region","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"BH","iso_a3":"BHR","iso_n3":"048","un_a3":"048","wb_a2":"BH","wb_a3":"BHR","woe_id":-99,"adm0_a3_is":"BHR","adm0_a3_us":"BHR","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Western Asia","region_wb":"Middle East & North Africa","name_len":7,"long_len":7,"abbrev_len":5,"tiny":2,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[32.0122,46.2039],[32.1501,46.1547],[32.0094,46.1678],[31.7002,46.2141],[31.5639,46.2578],[31.5287,46.3066],[31.5088,46.3731],[31.5849,46.3032],[31.6385,46.2726],[32.0122,46.2039]],[[33.4519,52.3338],[33.6134,52.3326],[33.7353,52.3448],[33.8188,52.3156],[33.9221,52.2515],[34.0153,52.156],[34.1131,51.9796],[34.3979,51.7804],[34.4027,51.7415],[34.3793,51.7165],[34.2392,51.6922],[34.1211,51.6792],[34.1154,51.645],[34.1468,51.608],[34.2009,51.5538],[34.2093,51.4841],[34.2065,51.4199],[34.2299,51.3632],[34.275,51.3402],[34.2807,51.3117],[34.2284,51.2769],[34.2139,51.2554],[34.2342,51.2438],[34.491,51.2371],[34.6168,51.2031],[34.7123,51.1722],[34.7604,51.1693],[34.8686,51.1892],[34.9902,51.2018],[35.0641,51.2034],[35.0926,51.1807],[35.1153,51.1208],[35.1581,51.061],[35.198,51.0439],[35.2691,51.0468],[35.3119,51.0439],[35.3348,51.0211],[35.3091,50.9869],[35.3147,50.9499],[35.3461,50.9043],[35.3832,50.7989],[35.4174,50.7676],[35.4401,50.7277],[35.4401,50.6821],[35.4116,50.6422],[35.3917,50.6109],[35.4116,50.5397],[35.4885,50.4599],[35.5455,50.44],[35.5911,50.3688],[35.6737,50.346],[35.7962,50.4058],[35.8902,50.4371],[36.0078,50.4197],[36.1164,50.4085],[36.1895,50.3678],[36.2434,50.3118],[36.3061,50.2805],[36.3688,50.2968],[36.4998,50.2805],[36.5597,50.2349],[36.6194,50.2092],[36.6964,50.2462],[36.7591,50.2918],[36.9885,50.3396],[37.1312,50.3515],[37.1711,50.3609],[37.2549,50.395],[37.3432,50.4176],[37.4229,50.4115],[37.5014,50.3407],[37.5823,50.2918],[37.6051,50.2149],[37.7042,50.1091],[37.9503,49.9642],[38.0469,49.92],[38.1125,49.9278],[38.1468,49.9394],[38.1627,49.9545],[38.1775,50.0254],[38.2087,50.0515],[38.2586,50.0523],[38.4512,49.9641],[38.552,49.9546],[38.6478,49.9529],[38.7767,49.8843],[38.9184,49.8247],[39.0277,49.8184],[39.1149,49.8417],[39.1748,49.856],[39.2118,49.8332],[39.246,49.7819],[39.3029,49.742],[39.3685,49.7307],[39.4628,49.728],[39.6266,49.6507],[39.7806,49.572],[39.8769,49.5677],[39.9585,49.5908],[40.0307,49.5967],[40.0807,49.5769],[40.0949,49.5427],[40.0578,49.4971],[40.0578,49.4315],[40.1262,49.3688],[40.1283,49.3072],[40.1088,49.2516],[40.07,49.2003],[39.9764,49.1298],[39.8897,49.0641],[39.7595,49.0366],[39.6865,49.0079],[39.7057,48.9596],[39.7533,48.9145],[39.8638,48.878],[39.9892,48.8514],[40.0036,48.8221],[39.9845,48.8074],[39.9041,48.7938],[39.7929,48.8077],[39.7559,48.7821],[39.7046,48.7394],[39.6704,48.6625],[39.6447,48.5912],[39.7654,48.5719],[39.8356,48.5428],[39.8575,48.4842],[39.8826,48.4191],[39.8898,48.3604],[39.8499,48.3319],[39.8475,48.3028],[39.8663,48.2884],[39.9182,48.2819],[39.9579,48.2689],[39.961,48.2379],[39.8851,48.1684],[39.814,48.0353],[39.7758,47.9645],[39.7787,47.8875],[39.7359,47.8448],[39.6585,47.8412],[39.391,47.8337],[39.1585,47.8374],[39.0578,47.8485],[38.9003,47.8551],[38.8223,47.837],[38.7189,47.7141],[38.6406,47.6659],[38.5109,47.6224],[38.3688,47.61],[38.2874,47.5592],[38.2588,47.4795],[38.2565,47.4089],[38.2433,47.3737],[38.2124,47.3428],[38.2014,47.3208],[38.208,47.2965],[38.241,47.2877],[38.2808,47.2767],[38.2808,47.259],[38.2653,47.237],[38.2212,47.2127],[38.2014,47.1752],[38.2059,47.1356],[38.2144,47.0915],[38.1783,47.0802],[37.8287,47.0958],[37.5434,47.0746],[37.3398,46.9169],[37.2186,46.9173],[37.0476,46.8762],[36.932,46.8251],[36.7948,46.7144],[36.6887,46.7641],[36.5588,46.7627],[36.432,46.7326],[36.2795,46.6586],[36.1946,46.6455],[36.0249,46.6668],[35.8271,46.6243],[35.4002,46.3814],[35.2566,46.2039],[35.2044,46.1692],[35.1323,46.1259],[35.0553,46.104],[35.0146,46.106],[35.2178,46.2322],[35.2802,46.2795],[35.2909,46.3144],[35.292,46.3707],[35.2304,46.4406],[35.0641,46.2672],[34.9695,46.2421],[34.8496,46.1899],[34.8437,46.0736],[34.8573,45.9874],[34.9066,45.8788],[35.0229,45.701],[35.2602,45.4469],[35.3739,45.3536],[35.4575,45.3163],[35.558,45.3109],[35.751,45.3894],[35.8335,45.4016],[36.0129,45.3717],[36.0771,45.4241],[36.1705,45.4531],[36.2903,45.4567],[36.4271,45.4333],[36.575,45.3936],[36.5143,45.3038],[36.4508,45.2323],[36.4284,45.1533],[36.3934,45.0654],[36.2299,45.026],[36.0548,45.0308],[35.8701,45.0053],[35.8036,45.0396],[35.7595,45.0708],[35.6775,45.102],[35.5695,45.1193],[35.4726,45.0985],[35.3578,44.9784],[35.1548,44.8963],[35.0877,44.8026],[34.8878,44.8236],[34.7169,44.8071],[34.4699,44.7217],[34.2817,44.5384],[34.0744,44.4238],[33.91,44.3876],[33.7557,44.3989],[33.6559,44.4332],[33.4507,44.5537],[33.4627,44.5968],[33.4913,44.6186],[33.5301,44.6805],[33.6122,44.9078],[33.6012,44.9815],[33.5552,45.0977],[33.3925,45.1878],[33.2615,45.1708],[33.1869,45.1948],[32.9187,45.3481],[32.7727,45.359],[32.6113,45.3281],[32.5519,45.3504],[32.508,45.4038],[32.828,45.593],[33.1423,45.7492],[33.2801,45.7652],[33.4662,45.8379],[33.6648,45.9471],[33.6367,46.0329],[33.5941,46.0962],[33.4988,46.0789],[33.4299,46.0576],[33.2635,46.1257],[33.2022,46.1757],[32.9418,46.1238],[32.7969,46.1315],[32.4768,46.0837],[32.3299,46.1304],[32.0357,46.261],[31.9252,46.2873],[31.8313,46.2817],[31.78,46.3247],[31.8429,46.3461],[31.9159,46.3487],[31.9917,46.3644],[32.0131,46.3872],[32.0085,46.43],[31.8558,46.4625],[31.7137,46.4718],[31.6236,46.5103],[31.5549,46.5543],[31.716,46.555],[31.8779,46.5217],[32.1314,46.5094],[32.3613,46.475],[32.4189,46.5178],[32.5525,46.592],[32.578,46.6156],[32.3541,46.5648],[32.1272,46.5972],[32.0443,46.6425],[31.9743,46.7088],[31.9449,46.7844],[31.9641,46.8548],[31.9396,46.982],[31.8647,47.0951],[31.8382,47.1572],[31.7592,47.2128],[31.8369,47.087],[31.8659,47.0033],[31.9127,46.9261],[31.9017,46.7216],[31.8729,46.6498],[31.7796,46.6316],[31.657,46.6424],[31.5321,46.6647],[31.5634,46.7773],[31.4969,46.7384],[31.4029,46.6288],[31.3203,46.6125],[31.1368,46.6245],[30.7963,46.552],[30.7729,46.473],[30.7217,46.3662],[30.6723,46.304],[30.6567,46.2665],[30.5115,46.1054],[30.493,46.0901],[30.219,45.8667],[30.1842,45.85],[30.0066,45.7979],[29.9017,45.7524],[29.8212,45.7321],[29.6851,45.7547],[29.6284,45.7225],[29.6017,45.6825],[29.6012,45.6],[29.6703,45.5407],[29.727,45.3433],[29.7059,45.2599],[29.652,45.3139],[29.5677,45.3708],[29.4037,45.4197],[29.2235,45.4029],[29.0274,45.3206],[28.8943,45.2899],[28.8243,45.3111],[28.7817,45.3099],[28.7666,45.2862],[28.7698,45.2669],[28.7914,45.2519],[28.7883,45.241],[28.7607,45.2341],[28.4513,45.2922],[28.3177,45.3471],[28.2125,45.4504],[28.2648,45.4839],[28.3104,45.4986],[28.4714,45.5072],[28.499,45.5177],[28.5018,45.5416],[28.5138,45.5724],[28.5095,45.6178],[28.4916,45.6658],[28.5623,45.7358],[28.6676,45.7938],[28.7293,45.852],[28.7388,45.9372],[28.8495,45.9787],[28.9478,46.05],[28.9719,46.1276],[29.0063,46.1765],[28.9438,46.2884],[28.9306,46.3623],[28.9274,46.4241],[28.9584,46.4585],[29.0499,46.497],[29.1463,46.5269],[29.1862,46.524],[29.2008,46.505],[29.2046,46.3793],[29.2238,46.377],[29.2546,46.3926],[29.3049,46.4666],[29.3396,46.4451],[29.3929,46.4369],[29.4328,46.456],[29.4588,46.4538],[29.491,46.4347],[29.5551,46.4078],[29.6149,46.3988],[29.6646,46.4167],[29.7068,46.4487],[29.752,46.4378],[29.8379,46.3505],[29.878,46.3602],[30.0757,46.3778],[30.1075,46.4016],[30.1311,46.4231],[29.9243,46.5389],[29.9348,46.625],[29.9425,46.7238],[29.9181,46.7824],[29.8778,46.8289],[29.7197,46.8829],[29.5978,46.9388],[29.572,46.964],[29.5687,46.9967],[29.5635,47.0475],[29.515,47.0911],[29.5109,47.128],[29.5418,47.1855],[29.5493,47.2468],[29.5392,47.271],[29.5106,47.2907],[29.4557,47.2926],[29.3834,47.328],[29.3338,47.3757],[29.2006,47.4445],[29.1598,47.4557],[29.1349,47.4897],[29.1229,47.5304],[29.1509,47.5809],[29.186,47.6586],[29.2107,47.7315],[29.2111,47.775],[29.1948,47.8824],[29.1254,47.9646],[29.093,47.9754],[29.0369,47.9523],[28.9733,47.933],[28.9231,47.9511],[28.8658,47.9957],[28.7738,48.1196],[28.6017,48.1444],[28.5305,48.1503],[28.4631,48.0905],[28.442,48.1087],[28.423,48.1469],[28.3875,48.1621],[28.3405,48.1444],[28.327,48.1614],[28.3472,48.213],[28.291,48.2386],[28.1588,48.238],[28.0885,48.257],[28.0801,48.2958],[28.0385,48.3213],[27.9634,48.3335],[27.8906,48.3652],[27.82,48.4163],[27.7145,48.4495],[27.5737,48.4649],[27.5622,48.4704],[27.5492,48.4777],[27.4584,48.4431],[27.4038,48.4156],[27.3369,48.4327],[27.2285,48.3714],[27.0085,48.3683],[26.9006,48.3719],[26.8471,48.3872],[26.6404,48.2941],[26.6189,48.2599],[26.5725,48.2485],[26.4424,48.23],[26.3057,48.2038],[26.277,48.1132],[26.2362,48.0644],[26.1627,47.9925],[25.9087,47.9676],[25.6893,47.9325],[25.4643,47.9108],[25.1696,47.8231],[25.0738,47.7457],[24.9791,47.7241],[24.8934,47.7178],[24.8379,47.7608],[24.651,47.8765],[24.5789,47.9311],[24.4841,47.9471],[24.381,47.938],[24.2819,47.9112],[24.1777,47.9061],[24.0598,47.9448],[24.0474,47.941],[24.0019,47.9358],[23.709,47.9826],[23.682,47.9904],[23.669,47.9923],[23.6287,47.9958],[23.4082,47.99],[23.2026,48.0845],[23.1395,48.0874],[23.0908,48.0491],[23.0548,48.0065],[22.9129,47.9643],[22.8767,47.9473],[22.8561,47.9603],[22.8465,47.9971],[22.8572,48.0295],[22.8362,48.0603],[22.7822,48.0952],[22.7691,48.1096],[22.7016,48.107],[22.6831,48.1036],[22.6764,48.1044],[22.5824,48.134],[22.5201,48.2054],[22.4238,48.2433],[22.3502,48.2561],[22.3167,48.2866],[22.2951,48.3273],[22.2722,48.358],[22.2694,48.3609],[22.2537,48.4074],[22.2312,48.4122],[22.2271,48.4134],[22.1318,48.4053],[22.1429,48.5685],[22.2952,48.6858],[22.3326,48.7451],[22.3895,48.8735],[22.432,48.9335],[22.4832,48.9833],[22.5241,49.0314],[22.5387,49.0727],[22.58,49.0772],[22.7013,49.0399],[22.8098,49.0208],[22.8397,49.0389],[22.8521,49.0627],[22.8471,49.0812],[22.7602,49.1362],[22.7057,49.1712],[22.7023,49.1927],[22.722,49.241],[22.7324,49.2952],[22.7199,49.3538],[22.6606,49.4837],[22.6494,49.539],[22.7062,49.6062],[22.8907,49.7663],[22.9522,49.8264],[23.0363,49.8991],[23.2645,50.0729],[23.4086,50.1739],[23.5062,50.2298],[23.649,50.3271],[23.7117,50.3773],[23.9727,50.4101],[24.005,50.457],[24.0526,50.5084],[24.0899,50.5305],[24.0947,50.617],[24.0463,50.7228],[24.0073,50.7602],[23.9784,50.7856],[23.9971,50.8094],[24.026,50.8162],[24.0616,50.8195],[24.1058,50.845],[24.0958,50.8728],[23.9857,50.9404],[23.9381,50.9925],[23.8635,51.1262],[23.7122,51.2651],[23.6645,51.3101],[23.6576,51.3525],[23.6797,51.3949],[23.6589,51.449],[23.6053,51.5179],[23.6138,51.5254],[23.6086,51.6105],[23.6467,51.6289],[23.7068,51.6413],[23.7917,51.6371],[23.8643,51.624],[23.9512,51.5851],[23.9783,51.5913],[24.1269,51.6646],[24.2801,51.7747],[24.3237,51.8384],[24.3619,51.8675],[24.4952,51.8831],[24.6113,51.8895],[24.6852,51.8883],[24.8664,51.8991],[24.9738,51.9111],[25.0667,51.9305],[25.2672,51.9377],[25.5803,51.9248],[25.7857,51.9238],[25.9253,51.9135],[26.2671,51.855],[26.3943,51.8444],[26.4534,51.8134],[26.5669,51.8019],[26.7734,51.7707],[26.9528,51.754],[27.0741,51.7608],[27.142,51.7521],[27.2701,51.6136],[27.2963,51.5974],[27.3477,51.5941],[27.4523,51.6061],[27.6014,51.6016],[27.6897,51.5724],[27.6768,51.4899],[27.7,51.478],[27.7413,51.4826],[27.7889,51.5292],[27.8288,51.5774],[27.8586,51.5924],[28.0107,51.5598],[28.0803,51.565],[28.1444,51.6017],[28.1838,51.6079],[28.2916,51.5818],[28.4246,51.5636],[28.532,51.5625],[28.599,51.5426],[28.6478,51.4565],[28.6902,51.4389],[28.7313,51.4334],[28.7933,51.5104],[28.8495,51.5402],[28.9275,51.5622],[28.9777,51.5718],[29.0131,51.5989],[29.0607,51.6254],[29.1021,51.6275],[29.1356,51.6173],[29.1742,51.5806],[29.2305,51.497],[29.2988,51.413],[29.3465,51.3826],[29.4696,51.4083],[29.5531,51.4346],[29.7061,51.4396],[29.9088,51.458],[30.0638,51.482],[30.1607,51.4779],[30.2195,51.4512],[30.309,51.3996],[30.3334,51.3255],[30.4495,51.2743],[30.5445,51.265],[30.577,51.3184],[30.6325,51.3554],[30.6117,51.4063],[30.6023,51.4712],[30.5607,51.5315],[30.533,51.5963],[30.5839,51.689],[30.6395,51.7701],[30.6673,51.8141],[30.7553,51.8952],[30.8457,51.9531],[30.9807,52.0462],[31.0793,52.077],[31.1685,52.0629],[31.218,52.0502],[31.346,52.1054],[31.5737,52.1081],[31.7634,52.1011],[31.7824,52.0994],[31.8756,52.0709],[31.9738,52.0466],[32.0416,52.045],[32.1223,52.0506],[32.2168,52.083],[32.2828,52.114],[32.363,52.2721],[32.3913,52.2948],[32.4354,52.3072],[32.5079,52.3085],[32.6454,52.2791],[32.8064,52.2526],[32.8997,52.2563],[33.1484,52.3404],[33.2871,52.3536],[33.4519,52.3338]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Ukraine","sov_a3":"UKR","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Ukraine","adm0_a3":"UKR","geou_dif":0,"geounit":"Ukraine","gu_a3":"UKR","su_dif":0,"subunit":"Ukraine","su_a3":"UKR","brk_diff":0,"name":"Ukraine","name_long":"Ukraine","brk_a3":"UKR","brk_name":"Ukraine","brk_group":"","abbrev":"Ukr.","postal":"UA","formal_en":"Ukraine","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Ukraine","name_alt":"","mapcolor7":5,"mapcolor8":1,"mapcolor9":6,"mapcolor13":3,"pop_est":45700395,"gdp_md_est":339800,"pop_year":-99,"lastcensus":2001,"gdp_year":-99,"economy":"6. Developing region","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"UA","iso_a3":"UKR","iso_n3":"804","un_a3":"804","wb_a2":"UA","wb_a3":"UKR","woe_id":-99,"adm0_a3_is":"UKR","adm0_a3_us":"UKR","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Eastern Europe","region_wb":"Europe & Central Asia","name_len":7,"long_len":7,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[3.9491,51.7395],[4.0468,51.6849],[4.0676,51.6675],[4.0751,51.6488],[3.951,51.6271],[3.819,51.694],[3.7318,51.6782],[3.699,51.7099],[3.6985,51.7297],[3.7891,51.7464],[3.9491,51.7395]],[[4.8861,53.0707],[4.7871,52.9998],[4.7268,53.0196],[4.7092,53.036],[4.7398,53.0913],[4.8864,53.1833],[4.8861,53.0707]],[[5.1086,53.308],[4.9237,53.2346],[4.9079,53.2462],[5.0271,53.3102],[5.1086,53.308]],[[5.9293,53.4588],[5.732,53.4426],[5.6653,53.4549],[5.6543,53.4665],[5.7081,53.4734],[5.8763,53.4751],[5.9282,53.465],[5.9293,53.4588]],[[6.3334,53.5107],[6.1933,53.4768],[6.1593,53.4839],[6.1677,53.4938],[6.2909,53.515],[6.3334,53.5107]],[[6.7348,53.5825],[6.6421,53.5792],[6.6686,53.6057],[6.7546,53.6255],[6.8009,53.6255],[6.7348,53.5825]],[[4.2262,51.3865],[4.1389,51.4015],[4.0065,51.4432],[3.8219,51.4094],[3.6936,51.4499],[3.5869,51.4539],[3.5205,51.4862],[3.4489,51.5408],[3.4996,51.5767],[3.5486,51.5891],[3.7439,51.596],[3.886,51.5742],[4.1413,51.4558],[4.2058,51.4567],[4.2741,51.4716],[4.2394,51.5039],[4.1755,51.5193],[4.0805,51.5511],[4.0048,51.5958],[4.1826,51.6103],[4.158,51.6334],[4.1346,51.6729],[3.9469,51.8105],[3.9789,51.8478],[4.0261,51.9277],[4.0849,51.9941],[4.1317,52.0119],[4.2088,52.059],[4.3763,52.1968],[4.4828,52.3092],[4.5621,52.4426],[4.6783,52.8098],[4.7127,52.8721],[4.7688,52.9413],[4.8391,52.9283],[4.888,52.9083],[5.0612,52.9606],[5.3584,53.0965],[5.446,53.2141],[5.532,53.2687],[5.8735,53.3752],[6.0622,53.4071],[6.3532,53.4153],[6.5636,53.4343],[6.8162,53.4412],[6.9124,53.3754],[6.9682,53.3273],[7.058,53.3006],[7.1973,53.2823],[7.189,53.1872],[7.1899,52.9995],[7.1795,52.9662],[7.1171,52.887],[7.0509,52.7448],[7.033,52.6514],[7.0132,52.6335],[6.7484,52.6341],[6.7107,52.6179],[6.7054,52.5977],[6.7187,52.5736],[6.7124,52.5497],[6.6916,52.5302],[6.7029,52.4992],[6.7488,52.464],[6.8325,52.4423],[6.9221,52.4403],[6.9682,52.4441],[7.0019,52.419],[7.0352,52.3802],[7.0326,52.3315],[7.0196,52.266],[6.9772,52.2055],[6.8551,52.1358],[6.8004,52.1112],[6.749,52.0987],[6.7245,52.0802],[6.713,52.0569],[6.7156,52.0362],[6.8024,51.9802],[6.8004,51.9674],[6.7752,51.9383],[6.7418,51.9109],[6.5176,51.854],[6.425,51.8584],[6.3722,51.83],[6.3557,51.8247],[6.2971,51.8507],[6.1665,51.8808],[6.1172,51.8704],[6.0898,51.854],[6.0076,51.834],[5.9487,51.8027],[5.9485,51.7624],[6.0527,51.6583],[6.0894,51.6378],[6.0911,51.5989],[6.1416,51.5501],[6.1933,51.4889],[6.1988,51.45],[6.1929,51.4106],[6.1662,51.3548],[6.0759,51.2241],[6.0748,51.199],[6.0824,51.18],[6.1134,51.1747],[6.1369,51.1648],[6.13,51.1474],[5.961,51.0567],[5.9393,51.0408],[5.8684,51.0453],[5.8575,51.0301],[5.8672,51.0057],[5.8947,50.9842],[5.9551,50.9729],[6.0068,50.95],[6.0484,50.9049],[5.9939,50.7504],[5.7974,50.7545],[5.7471,50.7596],[5.6937,50.7747],[5.6936,50.7748],[5.6691,50.806],[5.6395,50.8436],[5.6476,50.8667],[5.7366,50.9321],[5.75,50.9502],[5.7408,50.9599],[5.7498,50.9888],[5.8183,51.0864],[5.8271,51.1256],[5.7965,51.1531],[5.7523,51.1695],[5.6088,51.1984],[5.5404,51.2393],[5.5088,51.275],[5.4769,51.2851],[5.4298,51.273],[5.3108,51.2597],[5.2142,51.279],[5.0999,51.3465],[5.0734,51.4068],[5.0595,51.4531],[5.031,51.4691],[4.9926,51.4454],[4.9439,51.4078],[4.848,51.4033],[4.8207,51.4121],[4.816,51.4328],[4.8105,51.4527],[4.7842,51.4774],[4.7557,51.4911],[4.634,51.4217],[4.5888,51.4219],[4.5316,51.4486],[4.5034,51.4747],[4.4409,51.4598],[4.3848,51.4276],[4.404,51.3671],[4.3737,51.356],[4.3045,51.3615],[4.2262,51.3865]],[[5.3258,53.3857],[5.2326,53.3778],[5.1902,53.3918],[5.4151,53.4314],[5.5574,53.4436],[5.5826,53.4381],[5.3258,53.3857]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Netherlands","sov_a3":"NL1","adm0_dif":1,"level":2,"type":"Country","admin":"Netherlands","adm0_a3":"NLD","geou_dif":0,"geounit":"Netherlands","gu_a3":"NLD","su_dif":0,"subunit":"Netherlands","su_a3":"NLD","brk_diff":0,"name":"Netherlands","name_long":"Netherlands","brk_a3":"NLD","brk_name":"Netherlands","brk_group":"","abbrev":"Neth.","postal":"NL","formal_en":"Kingdom of the Netherlands","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Netherlands","name_alt":"","mapcolor7":4,"mapcolor8":2,"mapcolor9":2,"mapcolor13":9,"pop_est":16715999,"gdp_md_est":672000,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"NL","iso_a3":"NLD","iso_n3":"528","un_a3":"528","wb_a2":"NL","wb_a3":"NLD","woe_id":-99,"adm0_a3_is":"NLD","adm0_a3_us":"NLD","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Western Europe","region_wb":"Europe & Central Asia","name_len":11,"long_len":11,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[4.2262,51.3865],[4.2114,51.3487],[4.1726,51.3071],[4.04,51.2471],[3.9021,51.2077],[3.8308,51.2126],[3.7819,51.2332],[3.7557,51.2548],[3.6818,51.2757],[3.5803,51.2862],[3.5171,51.2636],[3.472,51.2422],[3.4325,51.2458],[3.4028,51.2636],[3.3801,51.2911],[3.3501,51.3777],[3.4258,51.3935],[3.5895,51.3994],[3.7165,51.3691],[3.8834,51.3545],[4.011,51.3959],[4.1115,51.3606],[4.2262,51.3865]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Netherlands","sov_a3":"NL1","adm0_dif":1,"level":2,"type":"Country","admin":"Netherlands","adm0_a3":"NLD","geou_dif":0,"geounit":"Netherlands","gu_a3":"NLD","su_dif":0,"subunit":"Netherlands","su_a3":"NLD","brk_diff":0,"name":"Netherlands","name_long":"Netherlands","brk_a3":"NLD","brk_name":"Netherlands","brk_group":"","abbrev":"Neth.","postal":"NL","formal_en":"Kingdom of the Netherlands","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Netherlands","name_alt":"","mapcolor7":4,"mapcolor8":2,"mapcolor9":2,"mapcolor13":9,"pop_est":16715999,"gdp_md_est":672000,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"NL","iso_a3":"NLD","iso_n3":"528","un_a3":"528","wb_a2":"NL","wb_a3":"NLD","woe_id":-99,"adm0_a3_is":"NLD","adm0_a3_us":"NLD","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Western Europe","region_wb":"Europe & Central Asia","name_len":11,"long_len":11,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[74.8913,37.2316],[74.8402,37.225],[74.7674,37.2492],[74.739,37.2856],[74.7267,37.2907],[74.6689,37.2667],[74.559,37.2366],[74.3722,37.1577],[74.3762,37.1374],[74.4979,37.0572],[74.5265,37.0307],[74.5414,37.0222],[74.4311,36.9837],[74.1947,36.8969],[74.0389,36.8257],[74.0019,36.8231],[73.9078,36.8529],[73.7691,36.8885],[73.7318,36.8878],[73.4111,36.8817],[73.1168,36.8686],[72.9938,36.8516],[72.7662,36.835],[72.6229,36.8296],[72.5313,36.802],[72.4312,36.7658],[72.327,36.7424],[72.2498,36.7347],[72.1567,36.7009],[72.0956,36.6337],[71.9207,36.5342],[71.8223,36.4861],[71.7727,36.4318],[71.7164,36.4266],[71.6205,36.4365],[71.5459,36.3777],[71.4633,36.2933],[71.3126,36.1712],[71.2329,36.1218],[71.1851,36.0421],[71.2202,36.0007],[71.3429,35.9385],[71.3976,35.8802],[71.4275,35.8337],[71.4836,35.7146],[71.519,35.5975],[71.572,35.5468],[71.5874,35.4608],[71.6006,35.4079],[71.572,35.3704],[71.5455,35.3285],[71.5455,35.2889],[71.5772,35.248],[71.6053,35.2118],[71.6205,35.183],[71.6017,35.1507],[71.5455,35.1014],[71.5171,35.0511],[71.4551,34.9669],[71.3581,34.9096],[71.2941,34.8677],[71.2258,34.7795],[71.1133,34.6816],[71.0656,34.5996],[71.0163,34.5546],[70.9656,34.5304],[70.9789,34.4863],[71.0229,34.4312],[71.0957,34.3694],[71.0924,34.2732],[71.0891,34.2041],[71.0913,34.1203],[71.0516,34.0497],[70.8484,33.9819],[70.654,33.9523],[70.4157,33.9504],[70.3257,33.9611],[70.2536,33.976],[69.9947,34.0518],[69.8896,34.0073],[69.8681,33.8977],[70.0566,33.7199],[70.1342,33.6208],[70.2197,33.4547],[70.2842,33.369],[70.2611,33.289],[70.0902,33.1981],[69.9201,33.1125],[69.7037,33.0947],[69.5678,33.0642],[69.5016,33.0201],[69.4531,32.8328],[69.4046,32.7643],[69.4054,32.6827],[69.3595,32.5903],[69.2899,32.5306],[69.2414,32.4335],[69.2565,32.2495],[69.2793,31.9368],[69.1869,31.8381],[69.0831,31.7385],[68.9734,31.6674],[68.8689,31.6342],[68.7823,31.6464],[68.7137,31.7081],[68.6732,31.7597],[68.5977,31.803],[68.5207,31.7941],[68.4433,31.7545],[68.3198,31.7677],[68.214,31.8074],[68.161,31.803],[68.1302,31.7633],[68.0172,31.678],[67.7398,31.5482],[67.6268,31.5388],[67.5782,31.5065],[67.5976,31.4533],[67.6471,31.41],[67.7335,31.3792],[67.7379,31.3439],[67.6615,31.313],[67.5964,31.2777],[67.4528,31.2346],[67.2873,31.2178],[67.1159,31.2429],[67.0277,31.3002],[66.9243,31.3056],[66.8293,31.2637],[66.7313,31.1945],[66.6242,31.046],[66.5958,31.02],[66.5668,30.9966],[66.4974,30.9646],[66.3972,30.9122],[66.3469,30.8028],[66.2869,30.6079],[66.301,30.503],[66.3055,30.3211],[66.2818,30.1935],[66.2385,30.1096],[66.2472,30.0435],[66.3134,29.9686],[66.2869,29.92],[66.2313,29.8657],[66.1771,29.8356],[65.9616,29.7789],[65.6662,29.7013],[65.471,29.6516],[65.1805,29.5776],[65.0955,29.5595],[64.9189,29.5528],[64.8273,29.5642],[64.7035,29.5671],[64.5211,29.5645],[64.3938,29.5443],[64.2661,29.5069],[64.1722,29.4604],[64.118,29.4143],[64.0987,29.3919],[63.971,29.4301],[63.5676,29.498],[62.4766,29.4083],[62.3734,29.4254],[62.001,29.5304],[61.5215,29.6657],[61.2244,29.7494],[60.8434,29.8587],[61.1041,30.1284],[61.3316,30.3637],[61.5595,30.5994],[61.7842,30.8319],[61.8108,30.9133],[61.8143,31.0726],[61.7551,31.2853],[61.6602,31.3824],[61.3465,31.4216],[61.1107,31.4511],[60.8541,31.4833],[60.8207,31.4952],[60.7916,31.6606],[60.8043,31.7345],[60.7875,31.8772],[60.7899,31.9871],[60.8272,32.168],[60.8293,32.2494],[60.7104,32.6],[60.6445,32.7944],[60.5766,32.9949],[60.5619,33.0588],[60.5605,33.1378],[60.7181,33.3235],[60.7669,33.3638],[60.8593,33.4563],[60.917,33.5052],[60.9069,33.539],[60.8064,33.5587],[60.6546,33.5604],[60.5738,33.5883],[60.5108,33.6389],[60.4859,33.7119],[60.5271,33.842],[60.4857,34.0948],[60.5702,34.2196],[60.6427,34.3072],[60.8895,34.3194],[60.8039,34.418],[60.7626,34.4752],[60.7361,34.4918],[60.7263,34.5183],[60.7395,34.5447],[60.8023,34.5546],[60.8453,34.5877],[60.9147,34.634],[60.9512,34.6539],[60.9578,34.7101],[60.9908,34.7498],[61.0404,34.7994],[61.0801,34.8556],[61.0702,34.9217],[61.1066,35.0011],[61.1231,35.0507],[61.1496,35.0938],[61.1265,35.1565],[61.1066,35.2095],[61.1,35.2723],[61.1396,35.2889],[61.1893,35.312],[61.1992,35.3616],[61.2257,35.4245],[61.2455,35.4741],[61.2785,35.5138],[61.2818,35.5534],[61.262,35.6196],[61.3447,35.6295],[61.3777,35.5931],[61.4218,35.5458],[61.5428,35.4579],[61.621,35.4323],[61.7197,35.4194],[61.841,35.4315],[61.9381,35.4479],[61.9839,35.4437],[62.0896,35.3797],[62.2131,35.2899],[62.2528,35.2502],[62.2712,35.1891],[62.3078,35.1708],[62.3866,35.2312],[62.4629,35.2514],[62.5331,35.2399],[62.6105,35.2332],[62.6881,35.2553],[62.7227,35.2713],[62.858,35.3497],[62.9803,35.4092],[63.0566,35.4458],[63.0842,35.5681],[63.1193,35.6375],[63.1697,35.6781],[63.1508,35.7283],[63.13,35.7667],[63.1086,35.8187],[63.13,35.8462],[63.1789,35.8584],[63.3017,35.8584],[63.517,35.9131],[63.6966,35.9678],[63.8625,36.0124],[63.9381,36.0197],[64.0097,36.0121],[64.0424,36.0251],[64.0514,36.0676],[64.0922,36.1127],[64.1844,36.1489],[64.358,36.2261],[64.511,36.3407],[64.5658,36.4276],[64.6025,36.5545],[64.6743,36.7502],[64.7531,36.9648],[64.7824,37.0593],[64.8163,37.1321],[64.9516,37.1936],[65.0896,37.2379],[65.3036,37.2468],[65.555,37.2512],[65.608,37.3684],[65.6412,37.4678],[65.683,37.5191],[65.7438,37.5608],[65.765,37.5691],[65.9007,37.5081],[66.1084,37.4147],[66.3503,37.3682],[66.4719,37.3447],[66.5223,37.3485],[66.8277,37.3713],[67.0688,37.3348],[67.1955,37.2352],[67.3197,37.2096],[67.4417,37.258],[67.5173,37.2667],[67.5465,37.2356],[67.6074,37.2225],[67.7,37.2272],[67.7529,37.1998],[67.759,37.1722],[67.766,37.1401],[67.8345,37.0642],[67.958,36.972],[68.0678,36.9498],[68.2121,37.0215],[68.2609,37.0131],[68.2848,37.0363],[68.2995,37.0884],[68.3869,37.1375],[68.5465,37.1834],[68.637,37.2245],[68.6691,37.2584],[68.7232,37.268],[68.782,37.258],[68.8237,37.2707],[68.8385,37.3028],[68.8554,37.3168],[68.8853,37.3281],[68.9118,37.3339],[68.9604,37.325],[69.05,37.2665],[69.1802,37.1583],[69.2648,37.1084],[69.3039,37.1169],[69.3538,37.15],[69.4145,37.2078],[69.4297,37.2909],[69.3992,37.3993],[69.4201,37.4867],[69.4921,37.5531],[69.6258,37.594],[69.8209,37.6096],[69.9406,37.6003],[69.985,37.5662],[70.0447,37.5472],[70.1198,37.5435],[70.1887,37.5825],[70.2515,37.6642],[70.255,37.7654],[70.1994,37.886],[70.2146,37.9244],[70.2388,37.9412],[70.3133,37.9848],[70.4178,38.0754],[70.5186,38.192],[70.6158,38.3344],[70.7359,38.4226],[70.8789,38.4564],[71.0521,38.4179],[71.2559,38.307],[71.3327,38.1703],[71.2828,38.0079],[71.2785,37.9184],[71.3199,37.9019],[71.3896,37.9063],[71.4878,37.9319],[71.552,37.9332],[71.5822,37.9101],[71.5804,37.8643],[71.5462,37.7957],[71.5051,37.6029],[71.4797,37.436],[71.4548,37.2718],[71.4329,37.1275],[71.4719,37.0151],[71.5309,36.8451],[71.5975,36.7329],[71.6656,36.6969],[71.7338,36.684],[71.8021,36.6943],[71.942,36.7665],[72.1535,36.9005],[72.3588,36.9829],[72.6574,37.0291],[72.757,37.1727],[72.8955,37.2675],[73.2111,37.4085],[73.3829,37.4623],[73.4813,37.4717],[73.6047,37.446],[73.6326,37.4372],[73.6571,37.4305],[73.7206,37.4187],[73.7338,37.3758],[73.7173,37.3294],[73.6488,37.2912],[73.6275,37.2616],[73.6535,37.2394],[73.7496,37.2318],[73.9488,37.2832],[74.0777,37.3162],[74.1671,37.3294],[74.2035,37.3725],[74.2597,37.4154],[74.349,37.4187],[74.4449,37.3956],[74.5242,37.3824],[74.6594,37.3945],[74.7306,37.357],[74.8305,37.2859],[74.8754,37.242],[74.8913,37.2316]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Afghanistan","sov_a3":"AFG","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Afghanistan","adm0_a3":"AFG","geou_dif":0,"geounit":"Afghanistan","gu_a3":"AFG","su_dif":0,"subunit":"Afghanistan","su_a3":"AFG","brk_diff":0,"name":"Afghanistan","name_long":"Afghanistan","brk_a3":"AFG","brk_name":"Afghanistan","brk_group":"","abbrev":"Afg.","postal":"AF","formal_en":"Islamic State of Afghanistan","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Afghanistan","name_alt":"","mapcolor7":5,"mapcolor8":6,"mapcolor9":8,"mapcolor13":7,"pop_est":28400000,"gdp_md_est":22270,"pop_year":-99,"lastcensus":1979,"gdp_year":-99,"economy":"7. Least developed region","income_grp":"5. Low income","wikipedia":-99,"fips_10":"","iso_a2":"AF","iso_a3":"AFG","iso_n3":"004","un_a3":"004","wb_a2":"AF","wb_a3":"AFG","woe_id":-99,"adm0_a3_is":"AFG","adm0_a3_us":"AFG","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Southern Asia","region_wb":"South Asia","name_len":11,"long_len":11,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[53.9278,24.1772],[53.9281,24.1434],[53.8264,24.1531],[53.7991,24.1355],[53.7158,24.1453],[53.6345,24.1698],[53.6896,24.2108],[53.8338,24.2589],[53.8938,24.2151],[53.9278,24.1772]],[[52.6169,24.2886],[52.6,24.2813],[52.5822,24.3353],[52.5836,24.3523],[52.6294,24.3768],[52.6576,24.3326],[52.6169,24.2886]],[[53.3322,24.2586],[53.2583,24.2529],[53.1909,24.2909],[53.3325,24.3416],[53.3709,24.3645],[53.4124,24.411],[53.4453,24.3712],[53.409,24.3079],[53.3826,24.2809],[53.3322,24.2586]],[[54.4654,24.4428],[54.4566,24.4233],[54.4284,24.4251],[54.3577,24.4428],[54.3348,24.471],[54.3789,24.5046],[54.3983,24.5063],[54.4266,24.471],[54.4654,24.4428]],[[56.1836,25.6449],[56.2495,25.6254],[56.2785,25.6277],[56.2979,25.6507],[56.3635,25.5694],[56.3729,25.0183],[56.388,24.9792],[56.3529,24.9733],[56.3136,24.9313],[56.2679,24.8667],[56.2047,24.8333],[56.1545,24.7955],[56.1065,24.7487],[56.0639,24.7388],[56.0084,24.7982],[55.9703,24.8589],[55.9797,24.8721],[56.0063,24.8764],[56.0167,24.9077],[56.0006,24.9532],[55.9631,24.9703],[55.9158,24.9718],[55.8707,24.9514],[55.8229,24.9113],[55.7957,24.8681],[55.7916,24.7813],[55.8042,24.6836],[55.8039,24.6362],[55.7775,24.5773],[55.7682,24.4906],[55.7868,24.4235],[55.804,24.3835],[55.8057,24.3498],[55.7608,24.2427],[55.7997,24.2227],[55.9286,24.2151],[55.9663,24.1426],[55.9922,24.093],[55.9852,24.0634],[55.8941,24.0414],[55.7791,24.0171],[55.6966,24.0241],[55.5479,23.9914],[55.4685,23.9411],[55.4918,23.9097],[55.5193,23.8855],[55.5316,23.819],[55.5085,23.7246],[55.4663,23.6329],[55.4139,23.5187],[55.3532,23.3875],[55.2702,23.1899],[55.1999,23.0348],[55.1922,22.9229],[55.194,22.85],[55.1858,22.7041],[55.1194,22.6239],[55.1043,22.6215],[55.025,22.6312],[54.9982,22.6344],[54.9225,22.6437],[54.8049,22.658],[54.6522,22.6767],[54.4717,22.6987],[54.2701,22.7233],[54.0546,22.7497],[53.8321,22.7768],[53.6096,22.804],[53.394,22.8303],[53.1924,22.8549],[53.0119,22.877],[52.8593,22.8956],[52.7416,22.91],[52.6659,22.9193],[52.6392,22.9225],[52.5551,22.9328],[52.5096,22.987],[52.4546,23.0524],[52.3996,23.118],[52.3445,23.1835],[52.2896,23.249],[52.2346,23.3145],[52.1795,23.38],[52.1245,23.4455],[52.0694,23.511],[52.0145,23.5765],[51.9595,23.642],[51.9044,23.7075],[51.8494,23.773],[51.7943,23.8385],[51.7394,23.904],[51.6844,23.9695],[51.6293,24.035],[51.5926,24.0789],[51.5722,24.1283],[51.5684,24.2579],[51.5684,24.2862],[51.6055,24.3384],[51.6231,24.3011],[51.6646,24.2504],[51.7348,24.2628],[51.7676,24.2544],[51.7917,24.0748],[51.8432,24.0109],[51.9061,23.9854],[52.1186,23.9711],[52.2509,23.9952],[52.5114,24.1125],[52.6482,24.1546],[53.0264,24.1473],[53.3296,24.0984],[53.8018,24.0695],[53.8934,24.0771],[54.1479,24.1712],[54.3043,24.2543],[54.3971,24.2782],[54.4584,24.3583],[54.4988,24.4627],[54.5347,24.531],[54.5805,24.5635],[54.6241,24.6213],[54.659,24.7155],[54.7468,24.8104],[55.0981,25.0416],[55.3035,25.2368],[55.3217,25.2998],[55.4334,25.3945],[55.5229,25.4981],[55.9412,25.794],[56.0252,25.916],[56.0746,26.0528],[56.0805,26.0626],[56.1165,26.0682],[56.1675,26.0475],[56.1726,25.9452],[56.1541,25.8485],[56.152,25.7461],[56.1446,25.6905],[56.1836,25.6449]],[[56.2105,25.2133],[56.2402,25.2088],[56.2818,25.2355],[56.2878,25.2786],[56.2773,25.3009],[56.2343,25.3038],[56.2165,25.2667],[56.2105,25.2133]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":4,"sovereignt":"United Arab Emirates","sov_a3":"ARE","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"United Arab Emirates","adm0_a3":"ARE","geou_dif":0,"geounit":"United Arab Emirates","gu_a3":"ARE","su_dif":0,"subunit":"United Arab Emirates","su_a3":"ARE","brk_diff":0,"name":"United Arab Emirates","name_long":"United Arab Emirates","brk_a3":"ARE","brk_name":"United Arab Emirates","brk_group":"","abbrev":"U.A.E.","postal":"AE","formal_en":"United Arab Emirates","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"United Arab Emirates","name_alt":"","mapcolor7":2,"mapcolor8":1,"mapcolor9":3,"mapcolor13":3,"pop_est":4798491,"gdp_md_est":184300,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"6. Developing region","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"AE","iso_a3":"ARE","iso_n3":"784","un_a3":"784","wb_a2":"AE","wb_a3":"ARE","woe_id":-99,"adm0_a3_is":"ARE","adm0_a3_us":"ARE","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Western Asia","region_wb":"Middle East & North Africa","name_len":20,"long_len":20,"abbrev_len":6,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[1.7061,42.5033],[1.6785,42.4967],[1.5864,42.456],[1.5341,42.4417],[1.4862,42.4345],[1.4488,42.4375],[1.4281,42.4613],[1.4303,42.4979],[1.422,42.5308],[1.4148,42.5484],[1.4283,42.5959],[1.4589,42.6217],[1.5014,42.6427],[1.5682,42.635],[1.7099,42.6044],[1.7395,42.5759],[1.7402,42.5567],[1.714,42.5256],[1.7061,42.5033]]]},"properties":{"scalerank":3,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Andorra","sov_a3":"AND","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Andorra","adm0_a3":"AND","geou_dif":0,"geounit":"Andorra","gu_a3":"AND","su_dif":0,"subunit":"Andorra","su_a3":"AND","brk_diff":0,"name":"Andorra","name_long":"Andorra","brk_a3":"AND","brk_name":"Andorra","brk_group":"","abbrev":"And.","postal":"AND","formal_en":"Principality of Andorra","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Andorra","name_alt":"","mapcolor7":1,"mapcolor8":4,"mapcolor9":1,"mapcolor13":8,"pop_est":83888,"gdp_md_est":3660,"pop_year":-99,"lastcensus":1989,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"AD","iso_a3":"AND","iso_n3":"020","un_a3":"020","wb_a2":"AD","wb_a3":"ADO","woe_id":-99,"adm0_a3_is":"AND","adm0_a3_us":"AND","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Southern Europe","region_wb":"Europe & Central Asia","name_len":7,"long_len":7,"abbrev_len":4,"tiny":5,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[20.6113,60.0407],[20.6034,60.0169],[20.5218,60.0117],[20.4875,60.0328],[20.4112,60.0301],[20.3979,60.0407],[20.4296,60.0617],[20.4901,60.0749],[20.5691,60.0696],[20.6113,60.0407]],[[19.6623,60.1872],[19.6675,60.1647],[19.6292,60.1704],[19.5998,60.1627],[19.5799,60.1351],[19.5365,60.145],[19.519,60.1846],[19.5514,60.2438],[19.6288,60.2461],[19.6623,60.1872]],[[19.9896,60.3512],[20.0202,60.3509],[20.0339,60.3593],[20.0874,60.3534],[20.1679,60.3147],[20.1841,60.2938],[20.2396,60.283],[20.2589,60.2613],[20.1947,60.1936],[20.1551,60.1923],[20.1255,60.2009],[20.0732,60.1935],[20.0426,60.1807],[20.0323,60.1525],[20.034,60.0936],[19.7998,60.0817],[19.746,60.099],[19.6723,60.233],[19.6869,60.2676],[19.7365,60.2824],[19.779,60.2855],[19.7853,60.2134],[19.8477,60.2206],[19.8672,60.2681],[19.8716,60.3016],[19.8547,60.3185],[19.8123,60.3316],[19.7878,60.3541],[19.823,60.3902],[19.8883,60.4058],[19.9445,60.3575],[19.9896,60.3512]]]},"properties":{"scalerank":3,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Finland","sov_a3":"FI1","adm0_dif":1,"level":2,"type":"Country","admin":"Aland","adm0_a3":"ALD","geou_dif":0,"geounit":"Aland","gu_a3":"ALD","su_dif":0,"subunit":"Aland","su_a3":"ALD","brk_diff":0,"name":"Aland","name_long":"Aland Islands","brk_a3":"ALD","brk_name":"Aland","brk_group":"","abbrev":"Aland","postal":"AI","formal_en":"Åland Islands","formal_fr":"","note_adm0":"Fin.","note_brk":"","name_sort":"Aland","name_alt":"","mapcolor7":4,"mapcolor8":1,"mapcolor9":4,"mapcolor13":6,"pop_est":27153,"gdp_md_est":1563,"pop_year":-99,"lastcensus":-99,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"AX","iso_a3":"ALA","iso_n3":"248","un_a3":"248","wb_a2":"-99","wb_a3":"-99","woe_id":-99,"adm0_a3_is":"ALA","adm0_a3_us":"ALD","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Northern Europe","region_wb":"Europe & Central Asia","name_len":5,"long_len":13,"abbrev_len":5,"tiny":5,"homepart":-99}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[53.7632,12.6368],[53.8248,12.6248],[53.9186,12.6594],[54.1874,12.664],[54.5111,12.5528],[54.45,12.5234],[54.4138,12.4833],[54.2713,12.4466],[54.1295,12.3606],[53.7188,12.319],[53.5983,12.3423],[53.4994,12.4253],[53.3158,12.5332],[53.3885,12.6019],[53.4039,12.6333],[53.431,12.6636],[53.535,12.7158],[53.6385,12.7074],[53.7632,12.6368]],[[42.7559,13.7043],[42.6897,13.6736],[42.735,13.753],[42.7812,13.7693],[42.7941,13.7661],[42.7559,13.7043]],[[42.7874,13.9715],[42.7742,13.9502],[42.7561,13.9549],[42.694,14.0079],[42.7621,14.0675],[42.7983,14.0123],[42.7874,13.9715]],[[42.5902,15.3034],[42.5587,15.2812],[42.549,15.3201],[42.5697,15.4073],[42.6023,15.4325],[42.6245,15.368],[42.6104,15.3323],[42.5902,15.3034]],[[52.9037,17.0438],[52.9644,16.9121],[53.025,16.7802],[53.0856,16.6484],[52.5814,16.4704],[52.4484,16.3913],[52.3277,16.2936],[52.2373,16.1714],[52.174,15.9568],[52.2221,15.7606],[52.2175,15.6555],[52.0873,15.5859],[51.9658,15.5357],[51.8308,15.4593],[51.7486,15.4401],[51.6815,15.3791],[51.6037,15.3368],[51.3225,15.2263],[51.0151,15.1408],[50.5271,15.0382],[50.3386,14.9272],[50.1669,14.851],[49.9063,14.8281],[49.5486,14.7224],[49.3499,14.6378],[49.1029,14.5],[49.048,14.4564],[49.0047,14.355],[48.9287,14.2675],[48.78,14.1239],[48.6684,14.0501],[48.5938,14.0462],[48.449,14.0059],[48.2778,13.9977],[47.9899,14.0481],[47.916,14.0128],[47.8551,13.9569],[47.6334,13.8584],[47.4077,13.6616],[47.2426,13.6094],[46.9757,13.5475],[46.7889,13.4656],[46.6635,13.4327],[46.502,13.4156],[46.2031,13.4238],[45.9197,13.3943],[45.6573,13.3387],[45.534,13.2335],[45.3936,13.067],[45.1639,12.9983],[45.1098,12.9386],[45.0387,12.8159],[44.8898,12.7842],[44.7553,12.7638],[44.6178,12.8172],[44.3585,12.6691],[44.2604,12.6446],[44.1115,12.6387],[44.0059,12.6077],[43.9298,12.6165],[43.8354,12.6744],[43.6344,12.7445],[43.4876,12.6988],[43.4753,12.839],[43.2319,13.2671],[43.2826,13.6398],[43.2824,13.6925],[43.2341,13.8589],[43.0891,14.011],[43.0934,14.2037],[43.0448,14.3416],[43.0063,14.4831],[43.0188,14.5208],[43.0211,14.5549],[42.947,14.7731],[42.9222,14.8174],[42.913,14.8631],[42.9373,14.898],[42.9364,14.9386],[42.8971,15.0056],[42.8557,15.133],[42.6578,15.2328],[42.6979,15.3263],[42.7364,15.2936],[42.7885,15.2657],[42.799,15.3263],[42.7999,15.3716],[42.7172,15.6546],[42.8396,16.032],[42.7993,16.3718],[42.9863,16.5091],[43.0336,16.5504],[43.0607,16.5866],[43.1048,16.6642],[43.165,16.6894],[43.1863,16.771],[43.1845,16.8118],[43.1456,16.8468],[43.1165,16.942],[43.1262,17.0625],[43.1359,17.113],[43.156,17.205],[43.2214,17.2393],[43.2369,17.2665],[43.1863,17.3247],[43.1909,17.3594],[43.3021,17.4568],[43.3461,17.486],[43.418,17.5163],[43.4742,17.5159],[43.5393,17.4987],[43.5973,17.4714],[43.6534,17.4219],[43.713,17.3655],[43.8043,17.3441],[43.8664,17.3496],[43.917,17.3247],[43.9597,17.3383],[44.0082,17.3675],[44.0859,17.3655],[44.156,17.3985],[44.3547,17.4144],[44.5465,17.4043],[44.7468,17.4317],[44.9465,17.4296],[45.148,17.4274],[45.1928,17.4234],[45.2366,17.4062],[45.4065,17.3198],[45.5354,17.3021],[45.7944,17.2784],[46.0708,17.2532],[46.3104,17.2313],[46.5135,17.2517],[46.682,17.2686],[46.7276,17.2656],[46.7785,17.2121],[46.88,17.079],[46.9757,16.9535],[47.1436,16.9467],[47.2513,16.9939],[47.3696,17.0604],[47.4418,17.1119],[47.5254,17.3161],[47.5796,17.4483],[47.7037,17.5968],[47.8078,17.7211],[47.9455,17.8858],[48.0217,17.977],[48.1722,18.1569],[48.3158,18.2271],[48.593,18.3624],[48.8648,18.4952],[49.042,18.5818],[49.1924,18.6213],[49.4451,18.6553],[49.7421,18.6953],[50.039,18.7353],[50.3553,18.7778],[50.7082,18.8253],[50.95,18.8579],[51.2584,18.8994],[51.5149,18.9339],[51.743,18.9646],[51.9776,18.9961],[52.0219,18.8963],[52.0662,18.7964],[52.1104,18.6965],[52.1547,18.5966],[52.199,18.4967],[52.2433,18.3968],[52.2875,18.2969],[52.3317,18.1971],[52.3761,18.0972],[52.4203,17.9973],[52.4646,17.8974],[52.5089,17.7975],[52.5531,17.6976],[52.5974,17.5978],[52.6417,17.4979],[52.6859,17.3979],[52.7292,17.3004],[52.8006,17.2679],[52.843,17.1757],[52.9037,17.0438]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Yemen","sov_a3":"YEM","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Yemen","adm0_a3":"YEM","geou_dif":0,"geounit":"Yemen","gu_a3":"YEM","su_dif":0,"subunit":"Yemen","su_a3":"YEM","brk_diff":0,"name":"Yemen","name_long":"Yemen","brk_a3":"YEM","brk_name":"Yemen","brk_group":"","abbrev":"Yem.","postal":"YE","formal_en":"Republic of Yemen","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Yemen, Rep.","name_alt":"","mapcolor7":5,"mapcolor8":3,"mapcolor9":3,"mapcolor13":11,"pop_est":23822783,"gdp_md_est":55280,"pop_year":-99,"lastcensus":2004,"gdp_year":-99,"economy":"7. Least developed region","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"YE","iso_a3":"YEM","iso_n3":"887","un_a3":"887","wb_a2":"RY","wb_a3":"YEM","woe_id":-99,"adm0_a3_is":"YEM","adm0_a3_us":"YEM","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Western Asia","region_wb":"Middle East & North Africa","name_len":5,"long_len":5,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[20.064,42.5473],[20.1035,42.5247],[20.1857,42.4259],[20.2405,42.339],[20.3482,42.3088],[20.4083,42.275],[20.4854,42.2234],[20.5229,42.1715],[20.5754,42.0131],[20.5814,41.9174],[20.5662,41.8737],[20.5531,41.8624],[20.5052,41.7065],[20.5166,41.6271],[20.5162,41.5748],[20.4756,41.5541],[20.4486,41.5213],[20.4924,41.3914],[20.487,41.3361],[20.489,41.2726],[20.5679,41.1278],[20.6145,41.0831],[20.6561,41.0617],[20.7093,40.9284],[20.7408,40.9053],[20.8702,40.9179],[20.9335,40.9031],[20.9586,40.8715],[20.9643,40.8499],[20.9558,40.7753],[20.9879,40.7178],[21.0311,40.6586],[21.0309,40.6225],[21.002,40.5634],[20.9502,40.4944],[20.8816,40.4679],[20.8061,40.4455],[20.77,40.3919],[20.7517,40.3349],[20.7179,40.2927],[20.697,40.2464],[20.6649,40.1518],[20.6574,40.1174],[20.6063,40.0827],[20.5271,40.0685],[20.4561,40.0656],[20.408,40.0495],[20.3837,40.0172],[20.3385,39.9911],[20.3111,39.9794],[20.3113,39.9508],[20.3442,39.8906],[20.3816,39.8418],[20.3824,39.8026],[20.3641,39.7917],[20.3062,39.7967],[20.2938,39.7822],[20.2876,39.7386],[20.2721,39.7012],[20.2482,39.6784],[20.2068,39.6535],[20.1311,39.6616],[20.0598,39.6991],[20.0226,39.7107],[20.0013,39.7094],[19.9956,39.801],[19.9648,39.8723],[19.8519,40.0436],[19.4846,40.21],[19.3981,40.2849],[19.3602,40.3477],[19.3223,40.4071],[19.3586,40.4087],[19.3945,40.3937],[19.4405,40.3757],[19.4592,40.4054],[19.4393,40.4703],[19.3446,40.6221],[19.3375,40.6638],[19.3839,40.7907],[19.4612,40.9333],[19.4561,41.1061],[19.4801,41.2364],[19.4534,41.321],[19.4406,41.4248],[19.4974,41.5627],[19.5458,41.5968],[19.5757,41.6404],[19.5775,41.7875],[19.4683,41.8562],[19.3424,41.8691],[19.3455,41.9188],[19.3611,41.9978],[19.3521,42.024],[19.3614,42.0691],[19.3309,42.1293],[19.2807,42.1726],[19.329,42.2493],[19.3996,42.3419],[19.4651,42.4154],[19.5445,42.4919],[19.5975,42.5654],[19.6545,42.6286],[19.7034,42.6479],[19.7278,42.6345],[19.7407,42.6069],[19.7378,42.5251],[19.7545,42.4969],[19.7883,42.4762],[19.8598,42.4863],[19.9391,42.5067],[20.0457,42.5499],[20.064,42.5473]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Albania","sov_a3":"ALB","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Albania","adm0_a3":"ALB","geou_dif":0,"geounit":"Albania","gu_a3":"ALB","su_dif":0,"subunit":"Albania","su_a3":"ALB","brk_diff":0,"name":"Albania","name_long":"Albania","brk_a3":"ALB","brk_name":"Albania","brk_group":"","abbrev":"Alb.","postal":"AL","formal_en":"Republic of Albania","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Albania","name_alt":"","mapcolor7":1,"mapcolor8":4,"mapcolor9":1,"mapcolor13":6,"pop_est":3639453,"gdp_md_est":21810,"pop_year":-99,"lastcensus":2001,"gdp_year":-99,"economy":"6. Developing region","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"AL","iso_a3":"ALB","iso_n3":"008","un_a3":"008","wb_a2":"AL","wb_a3":"ALB","woe_id":-99,"adm0_a3_is":"ALB","adm0_a3_us":"ALB","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Southern Europe","region_wb":"Europe & Central Asia","name_len":7,"long_len":7,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[45.5523,40.6161],[45.5144,40.5996],[45.4788,40.607],[45.4788,40.6483],[45.5045,40.6648],[45.5342,40.664],[45.5623,40.6492],[45.5523,40.6161]],[[45.0848,41.1955],[45.1523,41.1751],[45.1886,41.1474],[45.1902,41.1264],[45.0707,41.1008],[45.0626,41.0881],[45.0705,41.0756],[45.1061,41.0693],[45.2734,41.0062],[45.3689,41.0049],[45.4191,40.9857],[45.4442,40.948],[45.524,40.8967],[45.5875,40.8469],[45.5914,40.8297],[45.5794,40.8045],[45.4014,40.7071],[45.3789,40.6736],[45.3762,40.6381],[45.4544,40.5324],[45.5695,40.4168],[45.7357,40.3291],[45.9646,40.2338],[45.9676,40.1748],[45.9313,40.1047],[45.9001,40.0571],[45.8859,40.0249],[45.8581,40.0113],[45.6302,40.0142],[45.596,40.0028],[45.581,39.989],[45.5798,39.9775],[45.6618,39.9562],[45.7896,39.8811],[45.8632,39.8083],[45.9399,39.7766],[46.0259,39.7186],[46.0948,39.6645],[46.2021,39.5945],[46.3217,39.6174],[46.4814,39.5552],[46.4881,39.5128],[46.4781,39.4751],[46.3776,39.4339],[46.3651,39.4168],[46.3652,39.4025],[46.3784,39.3823],[46.4373,39.3485],[46.5066,39.2985],[46.5848,39.2237],[46.55,39.2014],[46.4771,39.1982],[46.4203,39.2074],[46.4003,39.1922],[46.4015,39.1677],[46.4754,39.1109],[46.4898,39.0694],[46.4867,38.9975],[46.4906,38.9067],[46.3178,38.9126],[46.1701,38.869],[46.1145,38.8778],[46.0774,38.9549],[46.0459,39.0175],[45.9519,39.1781],[45.9774,39.2439],[45.925,39.2819],[45.7986,39.3502],[45.7663,39.3785],[45.7842,39.4172],[45.7965,39.4881],[45.7845,39.5456],[45.7505,39.5629],[45.6874,39.5641],[45.6107,39.5498],[45.4568,39.4945],[45.3499,39.5299],[45.2883,39.5656],[45.2525,39.5955],[45.1726,39.5706],[45.1528,39.5827],[45.1486,39.6566],[45.1246,39.6963],[45.0765,39.7428],[45.0316,39.7651],[44.8672,39.7191],[44.7683,39.7035],[44.7338,39.7465],[44.5604,39.8876],[44.3996,39.9958],[44.2893,40.0404],[44.178,40.0357],[44.0054,40.0141],[43.942,40.0231],[43.7917,40.0703],[43.6662,40.1264],[43.6833,40.1497],[43.7099,40.1665],[43.6781,40.2393],[43.6084,40.3566],[43.6158,40.3933],[43.5938,40.444],[43.5693,40.4824],[43.6679,40.5741],[43.7129,40.6478],[43.7227,40.7195],[43.6965,40.7941],[43.6316,40.929],[43.5917,40.9682],[43.5175,41.0048],[43.4553,41.0647],[43.4395,41.1071],[43.492,41.1155],[43.645,41.1167],[43.7932,41.1311],[43.9092,41.159],[44.0772,41.1825],[44.1465,41.2034],[44.2273,41.2133],[44.473,41.191],[44.5648,41.2082],[44.8414,41.2114],[44.8485,41.2202],[44.8109,41.2486],[44.8113,41.2594],[44.9759,41.2775],[45.0014,41.291],[45.0229,41.2457],[45.0848,41.1955]],[[44.969,41.0272],[45.0021,41.0158],[45.0236,41.0272],[45.0287,41.0539],[45.0211,41.078],[44.9943,41.0856],[44.9614,41.0792],[44.9589,41.0526],[44.969,41.0272]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Armenia","sov_a3":"ARM","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Armenia","adm0_a3":"ARM","geou_dif":0,"geounit":"Armenia","gu_a3":"ARM","su_dif":0,"subunit":"Armenia","su_a3":"ARM","brk_diff":0,"name":"Armenia","name_long":"Armenia","brk_a3":"ARM","brk_name":"Armenia","brk_group":"","abbrev":"Arm.","postal":"ARM","formal_en":"Republic of Armenia","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Armenia","name_alt":"","mapcolor7":3,"mapcolor8":1,"mapcolor9":2,"mapcolor13":10,"pop_est":2967004,"gdp_md_est":18770,"pop_year":-99,"lastcensus":2001,"gdp_year":-99,"economy":"6. Developing region","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"AM","iso_a3":"ARM","iso_n3":"051","un_a3":"051","wb_a2":"AM","wb_a3":"ARM","woe_id":-99,"adm0_a3_is":"ARM","adm0_a3_us":"ARM","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Western Asia","region_wb":"Europe & Central Asia","name_len":7,"long_len":7,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[12.4853,43.9014],[12.4264,43.8941],[12.3969,43.9346],[12.4411,43.9824],[12.5037,43.9897],[12.5146,43.953],[12.4853,43.9014]]]},"properties":{"scalerank":3,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"San Marino","sov_a3":"SMR","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"San Marino","adm0_a3":"SMR","geou_dif":0,"geounit":"San Marino","gu_a3":"SMR","su_dif":0,"subunit":"San Marino","su_a3":"SMR","brk_diff":0,"name":"San Marino","name_long":"San Marino","brk_a3":"SMR","brk_name":"San Marino","brk_group":"","abbrev":"S.M.","postal":"RSM","formal_en":"Republic of San Marino","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"San Marino","name_alt":"","mapcolor7":2,"mapcolor8":3,"mapcolor9":1,"mapcolor13":6,"pop_est":30324,"gdp_md_est":1662,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"SM","iso_a3":"SMR","iso_n3":"674","un_a3":"674","wb_a2":"SM","wb_a3":"SMR","woe_id":-99,"adm0_a3_is":"SMR","adm0_a3_us":"SMR","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Southern Europe","region_wb":"Europe & Central Asia","name_len":10,"long_len":10,"abbrev_len":4,"tiny":5,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[19.7245,46.1519],[19.8444,46.1459],[19.9341,46.1615],[20.1614,46.1419],[20.2102,46.126],[20.2418,46.1086],[20.3014,46.0507],[20.3586,45.9755],[20.438,45.9408],[20.5326,45.8995],[20.5812,45.8695],[20.6527,45.7794],[20.7093,45.7353],[20.7278,45.7374],[20.7469,45.749],[20.7602,45.7581],[20.775,45.7498],[20.7758,45.7225],[20.7793,45.662],[20.7658,45.5975],[20.786,45.5365],[20.7865,45.5175],[20.7725,45.5001],[20.7742,45.4844],[20.794,45.4679],[20.8708,45.4275],[20.9418,45.3653],[21.0238,45.3215],[21.0999,45.2936],[21.1479,45.2917],[21.2265,45.2413],[21.3817,45.2051],[21.4314,45.1925],[21.4654,45.1719],[21.4902,45.1479],[21.4918,45.1223],[21.4679,45.1099],[21.4345,45.0751],[21.4207,45.033],[21.3959,45.0222],[21.3711,45.0214],[21.3529,45.009],[21.357,44.9908],[21.3777,44.9734],[21.41,44.9577],[21.472,44.942],[21.5332,44.9188],[21.5323,44.9007],[21.5199,44.8808],[21.4422,44.8734],[21.3844,44.8701],[21.3579,44.8618],[21.3601,44.8267],[21.5231,44.7901],[21.5971,44.7554],[21.6361,44.7104],[21.7402,44.6807],[21.9093,44.6661],[22.027,44.6199],[22.0931,44.5419],[22.201,44.5607],[22.3507,44.6761],[22.4977,44.7062],[22.6421,44.651],[22.7209,44.6055],[22.7344,44.5699],[22.7008,44.5555],[22.6201,44.5624],[22.554,44.5403],[22.5023,44.4896],[22.4945,44.4354],[22.5307,44.378],[22.5818,44.3383],[22.6479,44.3165],[22.6833,44.2865],[22.6879,44.2483],[22.7051,44.2378],[22.6675,44.2202],[22.6266,44.1941],[22.6034,44.1486],[22.5975,44.0753],[22.469,44.018],[22.4208,44.0074],[22.399,43.9695],[22.3654,43.8621],[22.3696,43.7813],[22.3869,43.7401],[22.3948,43.7066],[22.4363,43.6655],[22.4741,43.6022],[22.4991,43.5188],[22.5546,43.4545],[22.697,43.3911],[22.7676,43.3542],[22.8197,43.3007],[22.8596,43.2523],[22.9769,43.188],[22.968,43.142],[22.9423,43.0971],[22.9152,43.076],[22.8568,43.0183],[22.7999,42.9857],[22.7062,42.8839],[22.5581,42.8785],[22.5228,42.8703],[22.4668,42.8425],[22.4393,42.7917],[22.4656,42.7508],[22.4633,42.7095],[22.4362,42.6291],[22.4721,42.5433],[22.5242,42.5039],[22.5324,42.4812],[22.5235,42.441],[22.4457,42.3591],[22.4221,42.3289],[22.344,42.314],[22.3174,42.3217],[22.2771,42.3499],[22.2397,42.3582],[22.1467,42.325],[22.0521,42.3046],[21.9775,42.3201],[21.9041,42.3221],[21.853,42.3084],[21.8146,42.3031],[21.7393,42.2677],[21.6183,42.2421],[21.5625,42.2475],[21.5416,42.2808],[21.5189,42.3284],[21.53,42.35],[21.6099,42.3875],[21.619,42.4232],[21.7307,42.5955],[21.7521,42.6515],[21.7529,42.6698],[21.7238,42.682],[21.6625,42.6815],[21.3906,42.7514],[21.403,42.8315],[21.3231,42.8747],[21.2371,42.9132],[21.2227,42.9562],[21.1271,43.043],[21.057,43.0917],[20.9677,43.116],[20.8907,43.1517],[20.8444,43.1734],[20.8238,43.214],[20.8238,43.2379],[20.8006,43.2611],[20.7634,43.2586],[20.7006,43.2264],[20.6231,43.1986],[20.6097,43.1784],[20.6376,43.1304],[20.6576,43.0999],[20.6485,43.0709],[20.624,43.0342],[20.4751,42.953],[20.4584,42.9246],[20.4868,42.8791],[20.4688,42.8579],[20.3443,42.8279],[20.3477,42.8528],[20.3399,42.8929],[20.2685,42.9354],[20.1679,42.9685],[19.944,43.0816],[19.858,43.0965],[19.7812,43.1098],[19.671,43.164],[19.6145,43.1734],[19.5516,43.2123],[19.4146,43.3428],[19.2982,43.414],[19.2187,43.45],[19.1965,43.485],[19.1916,43.521],[19.1943,43.5333],[19.2545,43.5844],[19.3008,43.5918],[19.3604,43.5935],[19.3996,43.5676],[19.4513,43.5621],[19.48,43.5952],[19.4951,43.6429],[19.4882,43.7036],[19.3641,43.8448],[19.2572,43.9433],[19.245,43.965],[19.2681,43.9834],[19.3053,43.9934],[19.3452,43.9851],[19.4494,43.978],[19.5495,43.9871],[19.5837,44.0111],[19.5838,44.0435],[19.5472,44.0735],[19.4302,44.1545],[19.3389,44.2258],[19.2315,44.2806],[19.1519,44.3025],[19.1283,44.3303],[19.1185,44.36],[19.1273,44.4146],[19.1324,44.4838],[19.1514,44.5273],[19.2231,44.6096],[19.2919,44.6968],[19.3345,44.7807],[19.3568,44.8585],[19.3486,44.8809],[19.3127,44.8975],[19.2368,44.9143],[19.1315,44.8996],[19.0421,44.8713],[19.0071,44.8692],[18.9955,44.904],[19.0096,44.9194],[19.0376,44.9175],[19.0605,44.911],[19.0853,44.9268],[19.1,44.9738],[19.0629,45.1372],[19.1297,45.1517],[19.1308,45.1755],[19.1369,45.1962],[19.206,45.1678],[19.303,45.1673],[19.3881,45.173],[19.401,45.1891],[19.4,45.2125],[19.3823,45.2306],[19.3522,45.2454],[19.3303,45.2681],[19.2729,45.278],[19.0931,45.3369],[19.0047,45.3995],[19.0076,45.4658],[19.0333,45.5022],[19.0643,45.515],[19.0551,45.5272],[18.9537,45.558],[18.9179,45.6008],[18.9473,45.6558],[18.8945,45.7671],[18.8391,45.8357],[18.8936,45.8655],[18.9011,45.9076],[18.9054,45.9317],[18.9278,45.9314],[19.0157,45.9597],[19.0477,45.9827],[19.0662,46.0095],[19.0873,46.0162],[19.1463,45.987],[19.2084,45.9844],[19.2781,46.0029],[19.3303,46.0285],[19.3929,46.0498],[19.4213,46.0645],[19.4575,46.0874],[19.5308,46.1552],[19.6135,46.1692],[19.7245,46.1519]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Republic of Serbia","sov_a3":"SRB","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Republic of Serbia","adm0_a3":"SRB","geou_dif":0,"geounit":"Republic of Serbia","gu_a3":"SRB","su_dif":0,"subunit":"Republic of Serbia","su_a3":"SRB","brk_diff":0,"name":"Serbia","name_long":"Serbia","brk_a3":"SRB","brk_name":"Serbia","brk_group":"","abbrev":"Serb.","postal":"RS","formal_en":"Republic of Serbia","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Serbia","name_alt":"","mapcolor7":3,"mapcolor8":3,"mapcolor9":2,"mapcolor13":10,"pop_est":7379339,"gdp_md_est":80340,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"6. Developing region","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"RS","iso_a3":"SRB","iso_n3":"688","un_a3":"688","wb_a2":"YF","wb_a3":"SRB","woe_id":-99,"adm0_a3_is":"SRB","adm0_a3_us":"SRB","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Southern Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":6,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[22.5387,49.0727],[22.5241,49.0314],[22.4832,48.9833],[22.432,48.9335],[22.3895,48.8735],[22.3326,48.7451],[22.2952,48.6858],[22.1429,48.5685],[22.1318,48.4053],[22.1113,48.3934],[21.767,48.3381],[21.7215,48.3466],[21.6746,48.3784],[21.6486,48.4015],[21.6325,48.4185],[21.6026,48.4637],[21.5632,48.4957],[21.5047,48.5219],[21.4514,48.5522],[21.3824,48.5535],[21.1964,48.5106],[21.0673,48.5059],[20.9812,48.5197],[20.8666,48.5457],[20.6432,48.5497],[20.49,48.5269],[20.475,48.4951],[20.3338,48.2956],[20.1286,48.222],[19.9504,48.1466],[19.8986,48.1313],[19.8101,48.155],[19.7092,48.1998],[19.6254,48.2231],[19.5643,48.2128],[19.4975,48.1621],[19.467,48.1107],[19.2651,48.073],[18.9142,48.0508],[18.7919,48.0003],[18.7501,47.9395],[18.7483,47.8927],[18.778,47.8529],[18.7406,47.8065],[18.7242,47.7872],[18.4763,47.777],[18.1456,47.7634],[17.9479,47.7669],[17.7619,47.7702],[17.6353,47.8099],[17.4807,47.8876],[17.3173,47.9909],[17.3016,47.9934],[17.2772,48.0043],[17.1746,48.0121],[17.1474,48.006],[17.0859,48.0396],[17.0679,48.0833],[16.9727,48.1981],[16.8654,48.3869],[16.8627,48.4414],[16.9045,48.5035],[16.9434,48.5509],[16.9488,48.5886],[16.9531,48.5988],[16.9853,48.6769],[17.0633,48.7808],[17.1356,48.8411],[17.1885,48.8609],[17.2969,48.8428],[17.4826,48.8278],[17.6254,48.8418],[17.7585,48.8881],[17.8309,48.9286],[17.8927,48.9711],[17.9133,48.9987],[17.9407,49.012],[18.0509,49.0365],[18.0859,49.0651],[18.1004,49.1193],[18.11,49.1798],[18.1326,49.2246],[18.1609,49.2574],[18.3648,49.3362],[18.3831,49.3639],[18.4158,49.3909],[18.4761,49.4211],[18.5346,49.4647],[18.5965,49.4915],[18.6762,49.4885],[18.7497,49.494],[18.807,49.5092],[18.8322,49.5108],[18.9382,49.4983],[18.9572,49.4483],[18.9684,49.3962],[19.1494,49.4],[19.2502,49.5114],[19.3023,49.5249],[19.3862,49.5636],[19.4416,49.5977],[19.4797,49.5764],[19.5348,49.5048],[19.5931,49.4471],[19.6267,49.4244],[19.6303,49.4066],[19.6642,49.396],[19.7301,49.3896],[19.7739,49.3722],[19.787,49.3186],[19.788,49.27],[19.7674,49.2352],[19.7566,49.2044],[19.8022,49.1923],[19.8689,49.204],[19.9161,49.2214],[20.0576,49.1813],[20.1076,49.2708],[20.1637,49.3164],[20.2365,49.3376],[20.3025,49.3655],[20.363,49.3853],[20.4047,49.3841],[20.4227,49.3923],[20.4745,49.3902],[20.5346,49.3812],[20.6161,49.3917],[20.729,49.3699],[20.7995,49.3287],[20.8685,49.3147],[20.9473,49.3171],[21.0012,49.3398],[21.0794,49.4183],[21.1361,49.417],[21.225,49.4294],[21.3505,49.4288],[21.6396,49.412],[21.7121,49.3819],[21.8901,49.3435],[21.9677,49.2991],[22.0021,49.2461],[22.0201,49.2095],[22.2025,49.1532],[22.473,49.0813],[22.5387,49.0727]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Slovakia","sov_a3":"SVK","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Slovakia","adm0_a3":"SVK","geou_dif":0,"geounit":"Slovakia","gu_a3":"SVK","su_dif":0,"subunit":"Slovakia","su_a3":"SVK","brk_diff":0,"name":"Slovakia","name_long":"Slovakia","brk_a3":"SVK","brk_name":"Slovakia","brk_group":"","abbrev":"Svk.","postal":"SK","formal_en":"Slovak Republic","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Slovak Republic","name_alt":"","mapcolor7":2,"mapcolor8":4,"mapcolor9":4,"mapcolor13":9,"pop_est":5463046,"gdp_md_est":119500,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"SK","iso_a3":"SVK","iso_n3":"703","un_a3":"703","wb_a2":"SK","wb_a3":"SVK","woe_id":-99,"adm0_a3_is":"SVK","adm0_a3_us":"SVK","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Eastern Europe","region_wb":"Europe & Central Asia","name_len":8,"long_len":8,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[34.0045,35.0652],[33.9657,35.0568],[33.9033,35.0854],[33.8664,35.0936],[33.832,35.0672],[33.7923,35.0482],[33.7569,35.0397],[33.7258,35.0373],[33.6754,35.0179],[33.6145,35.0228],[33.5257,35.0387],[33.4758,35.0003],[33.4639,35.0049],[33.456,35.1014],[33.4242,35.1409],[33.3838,35.1627],[33.3256,35.1536],[33.2483,35.1569],[33.191,35.1731],[33.0775,35.1462],[32.9859,35.1164],[32.9195,35.0878],[32.8694,35.0894],[32.7841,35.1158],[32.7202,35.1454],[32.7127,35.171],[32.7724,35.1596],[32.8799,35.1806],[32.9264,35.2781],[32.9416,35.3904],[33.1234,35.3582],[33.3078,35.3415],[33.4588,35.3359],[33.6076,35.3542],[34.0635,35.474],[34.1925,35.5457],[34.2724,35.57],[34.4111,35.6293],[34.5561,35.6621],[34.4632,35.5935],[33.942,35.292],[33.9079,35.2024],[33.9313,35.1404],[34.0045,35.0652]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Northern Cyprus","sov_a3":"CYN","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Northern Cyprus","adm0_a3":"CYN","geou_dif":0,"geounit":"Northern Cyprus","gu_a3":"CYN","su_dif":0,"subunit":"Northern Cyprus","su_a3":"CYN","brk_diff":1,"name":"N. Cyprus","name_long":"Northern Cyprus","brk_a3":"B20","brk_name":"N. Cyprus","brk_group":"","abbrev":"N. Cy.","postal":"CN","formal_en":"Turkish Republic of Northern Cyprus","formal_fr":"","note_adm0":"Self admin.","note_brk":"Self admin.; Claimed by Cyprus","name_sort":"Cyprus, Northern","name_alt":"","mapcolor7":3,"mapcolor8":1,"mapcolor9":4,"mapcolor13":8,"pop_est":265100,"gdp_md_est":3600,"pop_year":-99,"lastcensus":-99,"gdp_year":-99,"economy":"6. Developing region","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"-99","iso_a3":"-99","iso_n3":"-99","un_a3":"-099","wb_a2":"-99","wb_a3":"-99","woe_id":-99,"adm0_a3_is":"CYP","adm0_a3_us":"CYP","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Western Asia","region_wb":"Europe & Central Asia","name_len":9,"long_len":15,"abbrev_len":6,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[32.7127,35.171],[32.7202,35.1454],[32.7841,35.1158],[32.8694,35.0894],[32.9195,35.0878],[32.9859,35.1164],[33.0775,35.1462],[33.191,35.1731],[33.2483,35.1569],[33.3256,35.1536],[33.3838,35.1627],[33.4242,35.1409],[33.456,35.1014],[33.4639,35.0049],[33.4758,35.0003],[33.5257,35.0387],[33.6145,35.0228],[33.6754,35.0179],[33.7258,35.0373],[33.7569,35.0397],[33.7923,35.0482],[33.832,35.0672],[33.8664,35.0936],[33.9033,35.0854],[33.9657,35.0568],[34.0045,35.0652],[34.0236,35.0456],[34.0502,34.9884],[33.9365,34.9715],[33.8225,34.9659],[33.759,34.9732],[33.6994,34.9699],[33.5145,34.8064],[33.4149,34.7509],[33.2966,34.7177],[33.1761,34.698],[33.1155,34.6956],[33.0623,34.6748],[33.0249,34.6369],[33.0239,34.6],[33.0079,34.5696],[32.9418,34.5759],[32.9143,34.6355],[32.8672,34.6611],[32.7501,34.6478],[32.693,34.6494],[32.5056,34.7063],[32.449,34.7294],[32.4138,34.778],[32.3172,34.9533],[32.301,35.083],[32.3909,35.0498],[32.475,35.09],[32.556,35.1558],[32.6523,35.1827],[32.7127,35.171]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Cyprus","sov_a3":"CYP","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Cyprus","adm0_a3":"CYP","geou_dif":0,"geounit":"Cyprus","gu_a3":"CYP","su_dif":0,"subunit":"Cyprus","su_a3":"CYP","brk_diff":0,"name":"Cyprus","name_long":"Cyprus","brk_a3":"CYP","brk_name":"Cyprus","brk_group":"","abbrev":"Cyp.","postal":"CY","formal_en":"Republic of Cyprus","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Cyprus","name_alt":"","mapcolor7":1,"mapcolor8":2,"mapcolor9":3,"mapcolor13":7,"pop_est":531640,"gdp_md_est":22700,"pop_year":-99,"lastcensus":2001,"gdp_year":-99,"economy":"6. Developing region","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"CY","iso_a3":"CYP","iso_n3":"196","un_a3":"196","wb_a2":"CY","wb_a3":"CYP","woe_id":-99,"adm0_a3_is":"CYP","adm0_a3_us":"CYP","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Western Asia","region_wb":"Europe & Central Asia","name_len":6,"long_len":6,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[103.9697,1.3314],[103.8199,1.2654],[103.6502,1.3255],[103.7053,1.4234],[103.818,1.4471],[103.909,1.416],[103.9608,1.3922],[103.9964,1.3652],[103.9697,1.3314]]]},"properties":{"scalerank":3,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Singapore","sov_a3":"SGP","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Singapore","adm0_a3":"SGP","geou_dif":0,"geounit":"Singapore","gu_a3":"SGP","su_dif":0,"subunit":"Singapore","su_a3":"SGP","brk_diff":0,"name":"Singapore","name_long":"Singapore","brk_a3":"SGP","brk_name":"Singapore","brk_group":"","abbrev":"Sing.","postal":"SG","formal_en":"Republic of Singapore","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Singapore","name_alt":"","mapcolor7":5,"mapcolor8":3,"mapcolor9":7,"mapcolor13":3,"pop_est":4657542,"gdp_md_est":237300,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"6. Developing region","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"SG","iso_a3":"SGP","iso_n3":"702","un_a3":"702","wb_a2":"SG","wb_a3":"SGP","woe_id":-99,"adm0_a3_is":"SGP","adm0_a3_us":"SGP","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"South-Eastern Asia","region_wb":"East Asia & Pacific","name_len":9,"long_len":9,"abbrev_len":5,"tiny":3,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[14.8094,50.859],[14.8958,50.8614],[14.9829,50.8866],[14.9899,50.9272],[14.9845,51.0034],[14.9938,51.0144],[15.126,50.9929],[15.2586,50.9585],[15.2771,50.883],[15.3126,50.8458],[15.3544,50.8118],[15.3946,50.7963],[15.464,50.7938],[15.6439,50.7489],[15.7306,50.7397],[15.8192,50.7087],[15.8939,50.6769],[15.9485,50.6703],[15.9738,50.6354],[16.0072,50.6116],[16.0664,50.6299],[16.2822,50.6556],[16.36,50.6214],[16.4125,50.5852],[16.4197,50.5736],[16.3923,50.5417],[16.3791,50.5169],[16.3566,50.5005],[16.2825,50.483],[16.2407,50.4547],[16.2104,50.4237],[16.2308,50.3941],[16.2913,50.3719],[16.3342,50.3669],[16.3505,50.3452],[16.4876,50.2484],[16.5967,50.1219],[16.6392,50.1021],[16.6791,50.0975],[16.7253,50.1161],[16.7786,50.157],[16.8418,50.1867],[16.8953,50.202],[16.9896,50.2369],[16.9934,50.2597],[16.9147,50.3452],[16.8691,50.4145],[16.8801,50.4271],[16.9808,50.4161],[17.152,50.3783],[17.4152,50.2548],[17.4623,50.2548],[17.5546,50.2641],[17.6547,50.2842],[17.7022,50.3072],[17.7201,50.2986],[17.7354,50.2308],[17.7093,50.1936],[17.5894,50.1575],[17.5963,50.1395],[17.6271,50.1164],[17.6811,50.1008],[17.7466,50.0568],[17.7917,50.0066],[17.8313,49.9833],[17.8748,49.9723],[17.9838,49.9991],[18.0146,50.0203],[18.0283,50.0353],[18.0495,50.0319],[18.0877,50.0073],[18.0992,49.9928],[18.2053,49.9647],[18.2663,49.9303],[18.3053,49.9141],[18.3484,49.9298],[18.5162,49.9024],[18.5624,49.8793],[18.5771,49.8411],[18.5688,49.8179],[18.5946,49.7578],[18.8069,49.6137],[18.8293,49.5401],[18.8322,49.5108],[18.807,49.5092],[18.7497,49.494],[18.6762,49.4885],[18.5965,49.4915],[18.5346,49.4647],[18.4761,49.4211],[18.4158,49.3909],[18.3831,49.3639],[18.3648,49.3362],[18.1609,49.2574],[18.1326,49.2246],[18.11,49.1798],[18.1004,49.1193],[18.0859,49.0651],[18.0509,49.0365],[17.9407,49.012],[17.9133,48.9987],[17.8927,48.9711],[17.8309,48.9286],[17.7585,48.8881],[17.6254,48.8418],[17.4826,48.8278],[17.2969,48.8428],[17.1885,48.8609],[17.1356,48.8411],[17.0633,48.7808],[16.9853,48.6769],[16.9531,48.5988],[16.9283,48.6209],[16.8837,48.7037],[16.8332,48.7143],[16.7645,48.722],[16.7127,48.7342],[16.601,48.7819],[16.5436,48.7962],[16.4779,48.8001],[16.4148,48.7721],[16.3673,48.739],[16.2193,48.7394],[16.0572,48.7548],[15.8252,48.8645],[15.765,48.8654],[15.7008,48.8604],[15.5994,48.8864],[15.4029,48.9574],[15.3109,48.974],[15.2527,48.9639],[15.1996,48.9481],[15.1617,48.9463],[15.1397,48.9693],[15.0668,48.9979],[14.9935,49.0011],[14.9722,48.9839],[14.9474,48.8277],[14.9226,48.7714],[14.8219,48.774],[14.7859,48.7474],[14.7066,48.6719],[14.6913,48.5992],[14.5539,48.6133],[14.4887,48.6255],[14.4311,48.6163],[14.3676,48.5762],[14.1898,48.5786],[14.0491,48.6025],[13.9888,48.6924],[13.9243,48.728],[13.8432,48.7599],[13.8147,48.7669],[13.7699,48.816],[13.685,48.8767],[13.5477,48.9597],[13.4407,48.9556],[13.4012,48.9776],[13.3837,49.0081],[13.3391,49.0608],[13.2888,49.0975],[13.2278,49.1117],[13.1405,49.1583],[13.0237,49.2601],[12.9167,49.3305],[12.8134,49.3293],[12.7479,49.3662],[12.6812,49.4145],[12.632,49.4612],[12.5558,49.5749],[12.5003,49.6397],[12.457,49.6798],[12.4082,49.7132],[12.3905,49.7396],[12.4502,49.8001],[12.4719,49.8301],[12.4976,49.8531],[12.5125,49.8774],[12.512,49.8958],[12.4576,49.9555],[12.3842,49.9986],[12.2765,50.0423],[12.2078,50.0975],[12.1825,50.148],[12.175,50.1758],[12.1278,50.2134],[12.0897,50.2686],[12.0898,50.3018],[12.0992,50.311],[12.1349,50.3109],[12.1748,50.2884],[12.2312,50.2449],[12.2773,50.1814],[12.3057,50.2057],[12.3586,50.2732],[12.4526,50.3498],[12.549,50.3934],[12.6355,50.3971],[12.7064,50.4091],[12.7654,50.431],[12.8683,50.4222],[12.9427,50.4064],[12.9668,50.4162],[12.9971,50.4561],[13.0164,50.4904],[13.1812,50.5105],[13.2377,50.5768],[13.2695,50.5764],[13.3061,50.5863],[13.341,50.6114],[13.3746,50.6217],[13.4012,50.6093],[13.4361,50.6011],[13.4726,50.6169],[13.5266,50.6928],[13.5567,50.7046],[13.7014,50.7165],[13.8985,50.7613],[13.9984,50.8011],[14.0965,50.8228],[14.2018,50.8612],[14.369,50.8987],[14.3771,50.9141],[14.2994,50.9526],[14.2733,50.9769],[14.2559,51.0019],[14.2832,51.0295],[14.3197,51.0378],[14.3673,51.0263],[14.5073,51.0099],[14.5457,50.9939],[14.5597,50.9549],[14.5952,50.9186],[14.6238,50.9147],[14.6136,50.8556],[14.6582,50.8326],[14.7233,50.8147],[14.7665,50.8183],[14.7975,50.8423],[14.8094,50.859]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Czech Republic","sov_a3":"CZE","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Czech Republic","adm0_a3":"CZE","geou_dif":0,"geounit":"Czech Republic","gu_a3":"CZE","su_dif":0,"subunit":"Czech Republic","su_a3":"CZE","brk_diff":0,"name":"Czech Rep.","name_long":"Czech Republic","brk_a3":"CZE","brk_name":"Czech Rep.","brk_group":"","abbrev":"Cz. Rep.","postal":"CZ","formal_en":"Czech Republic","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Czech Republic","name_alt":"","mapcolor7":1,"mapcolor8":1,"mapcolor9":2,"mapcolor13":6,"pop_est":10211904,"gdp_md_est":265200,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"CZ","iso_a3":"CZE","iso_n3":"203","un_a3":"203","wb_a2":"CZ","wb_a3":"CZE","woe_id":-99,"adm0_a3_is":"CZE","adm0_a3_us":"CZE","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Eastern Europe","region_wb":"Europe & Central Asia","name_len":10,"long_len":14,"abbrev_len":8,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[14.1982,53.919],[14.2137,53.8708],[14.1722,53.8744],[14.0483,53.8631],[13.9258,53.8791],[13.9021,53.939],[13.9217,53.9966],[13.8725,54.0363],[13.8271,54.0596],[13.8204,54.0928],[13.8277,54.1272],[14.0389,54.0346],[14.2114,53.9503],[14.1982,53.919]],[[11.2828,54.418],[11.1293,54.416],[11.0707,54.456],[11.0117,54.4662],[11.0435,54.5155],[11.085,54.5334],[11.2336,54.5013],[11.2803,54.4384],[11.2828,54.418]],[[13.7092,54.3827],[13.7342,54.3154],[13.7073,54.2812],[13.5949,54.3382],[13.482,54.3374],[13.4146,54.2496],[13.3644,54.2458],[13.19,54.3256],[13.1621,54.3646],[13.1563,54.3969],[13.1813,54.509],[13.1767,54.5442],[13.2314,54.5828],[13.2399,54.6384],[13.3368,54.6971],[13.4228,54.6993],[13.4501,54.6496],[13.4912,54.6154],[13.636,54.577],[13.6576,54.5596],[13.6707,54.5354],[13.6033,54.4882],[13.5805,54.464],[13.6019,54.4251],[13.7092,54.3827]],[[8.5879,54.7127],[8.5489,54.6882],[8.4538,54.6911],[8.4004,54.7141],[8.4177,54.7387],[8.4682,54.7574],[8.51,54.7603],[8.5734,54.7487],[8.5879,54.7127]],[[9.255,54.808],[9.342,54.8063],[9.4987,54.8404],[9.6158,54.8554],[9.6612,54.8344],[9.725,54.8255],[9.7397,54.8255],[9.7459,54.8072],[9.8923,54.7806],[9.9538,54.7383],[10.0222,54.6739],[10.0288,54.5813],[9.9413,54.5146],[9.8687,54.4725],[10.1435,54.4884],[10.1708,54.4502],[10.2124,54.4089],[10.3604,54.4383],[10.7315,54.3163],[10.956,54.3757],[11.0134,54.3792],[11.0644,54.2805],[11.0086,54.1812],[10.8107,54.0751],[10.8546,54.0098],[10.9178,53.9953],[11.1043,54.0092],[11.3996,53.9446],[11.4611,53.9647],[11.7006,54.1135],[11.7963,54.1455],[12.1113,54.1683],[12.1687,54.2259],[12.2963,54.2838],[12.3785,54.347],[12.5754,54.4674],[12.7791,54.4457],[12.898,54.4227],[13.0286,54.411],[13.1475,54.2827],[13.448,54.1409],[13.7242,54.1532],[13.8223,54.019],[13.8655,53.8534],[13.9504,53.8014],[14.025,53.7674],[14.25,53.7319],[14.2589,53.7296],[14.2661,53.7071],[14.2799,53.6248],[14.2987,53.5564],[14.4146,53.2835],[14.4123,53.2167],[14.4109,53.199],[14.3686,53.1056],[14.2932,53.0268],[14.1937,52.9823],[14.1389,52.9329],[14.1286,52.8782],[14.2537,52.7825],[14.5141,52.6456],[14.6194,52.5285],[14.5697,52.4311],[14.5546,52.3597],[14.5739,52.3142],[14.6156,52.2776],[14.6799,52.25],[14.7054,52.2075],[14.6924,52.15],[14.7046,52.1102],[14.7525,52.0818],[14.7481,52.0708],[14.7248,52.0309],[14.693,51.958],[14.6749,51.9048],[14.6017,51.8324],[14.6239,51.7708],[14.6813,51.6982],[14.7249,51.6617],[14.7387,51.6271],[14.7109,51.5449],[14.7247,51.5239],[14.906,51.4633],[14.9355,51.4354],[14.9531,51.3771],[15.0166,51.2527],[14.9639,51.0951],[14.9175,51.0087],[14.8143,50.8716],[14.8094,50.859],[14.7975,50.8423],[14.7665,50.8183],[14.7233,50.8147],[14.6582,50.8326],[14.6136,50.8556],[14.6238,50.9147],[14.5952,50.9186],[14.5597,50.9549],[14.5457,50.9939],[14.5073,51.0099],[14.3673,51.0263],[14.3197,51.0378],[14.2832,51.0295],[14.2559,51.0019],[14.2733,50.9769],[14.2994,50.9526],[14.3771,50.9141],[14.369,50.8987],[14.2018,50.8612],[14.0965,50.8228],[13.9984,50.8011],[13.8985,50.7613],[13.7014,50.7165],[13.5567,50.7046],[13.5266,50.6928],[13.4726,50.6169],[13.4361,50.6011],[13.4012,50.6093],[13.3746,50.6217],[13.341,50.6114],[13.3061,50.5863],[13.2695,50.5764],[13.2377,50.5768],[13.1812,50.5105],[13.0164,50.4904],[12.9971,50.4561],[12.9668,50.4162],[12.9427,50.4064],[12.8683,50.4222],[12.7654,50.431],[12.7064,50.4091],[12.6355,50.3971],[12.549,50.3934],[12.4526,50.3498],[12.3586,50.2732],[12.3057,50.2057],[12.2773,50.1814],[12.2312,50.2449],[12.1748,50.2884],[12.1349,50.3109],[12.0992,50.311],[12.0898,50.3018],[12.0897,50.2686],[12.1278,50.2134],[12.175,50.1758],[12.1825,50.148],[12.2078,50.0975],[12.2765,50.0423],[12.3842,49.9986],[12.4576,49.9555],[12.512,49.8958],[12.5125,49.8774],[12.4976,49.8531],[12.4719,49.8301],[12.4502,49.8001],[12.3905,49.7396],[12.4082,49.7132],[12.457,49.6798],[12.5003,49.6397],[12.5558,49.5749],[12.632,49.4612],[12.6812,49.4145],[12.7479,49.3662],[12.8134,49.3293],[12.9167,49.3305],[13.0237,49.2601],[13.1405,49.1583],[13.2278,49.1117],[13.2888,49.0975],[13.3391,49.0608],[13.3837,49.0081],[13.4012,48.9776],[13.4407,48.9556],[13.5477,48.9597],[13.685,48.8767],[13.7699,48.816],[13.8147,48.7669],[13.8029,48.7475],[13.7975,48.6864],[13.7988,48.6217],[13.7854,48.5875],[13.7239,48.5424],[13.6922,48.5328],[13.6752,48.523],[13.4866,48.5818],[13.4717,48.5718],[13.4599,48.5646],[13.4094,48.3941],[13.3746,48.3614],[13.3229,48.3313],[13.2152,48.3019],[13.1404,48.2899],[13.0821,48.2751],[12.8975,48.2037],[12.8143,48.1608],[12.7604,48.107],[12.7601,48.076],[12.8499,47.9848],[12.9535,47.8906],[12.9542,47.8078],[12.9083,47.7458],[12.8977,47.7219],[12.9281,47.7128],[12.9855,47.7094],[13.0336,47.6987],[13.0541,47.6551],[13.0479,47.5792],[13.0315,47.508],[13.0144,47.4781],[12.9681,47.4757],[12.8789,47.5064],[12.8094,47.5422],[12.7828,47.5642],[12.7812,47.5904],[12.7962,47.607],[12.7714,47.6394],[12.6858,47.6693],[12.5942,47.6563],[12.5266,47.6361],[12.4829,47.6373],[12.4357,47.6661],[12.3632,47.6882],[12.2684,47.7027],[12.2093,47.7183],[12.1969,47.7091],[12.2038,47.6467],[12.1856,47.6195],[11.7168,47.5835],[11.5739,47.5498],[11.4699,47.5061],[11.393,47.4872],[11.3741,47.4603],[11.2979,47.4249],[11.2119,47.4136],[11.1912,47.4252],[11.136,47.4089],[11.042,47.3931],[10.9809,47.3981],[10.9521,47.4267],[10.8939,47.4705],[10.8706,47.5008],[10.873,47.5202],[10.7416,47.5241],[10.6587,47.5472],[10.4828,47.5418],[10.4395,47.5516],[10.4304,47.5411],[10.4039,47.417],[10.3691,47.3661],[10.3128,47.3134],[10.2406,47.2841],[10.183,47.2788],[10.1857,47.3172],[10.2003,47.3634],[10.1588,47.3743],[10.0965,47.3796],[10.0663,47.3934],[10.0742,47.4285],[10.0599,47.4491],[10.0341,47.4736],[9.9716,47.5053],[9.8392,47.5523],[9.7489,47.5755],[9.7151,47.5508],[9.6506,47.5259],[9.5489,47.534],[9.524,47.5242],[9.35,47.5989],[9.1828,47.6707],[9.1275,47.6707],[8.8812,47.6564],[8.874,47.6627],[8.8312,47.7036],[8.7931,47.7166],[8.7701,47.7099],[8.7548,47.698],[8.7283,47.7],[8.6179,47.7661],[8.5727,47.7756],[8.5099,47.7669],[8.4357,47.7313],[8.4034,47.6878],[8.4133,47.6627],[8.4518,47.6518],[8.5523,47.6591],[8.5671,47.6519],[8.5705,47.6378],[8.5595,47.624],[8.4776,47.6127],[8.454,47.5962],[8.4301,47.5921],[8.4147,47.5896],[8.3278,47.6069],[8.1982,47.6069],[8.0938,47.5762],[7.9271,47.5639],[7.698,47.5699],[7.6156,47.5927],[7.5654,47.6065],[7.5294,47.6739],[7.5386,47.7736],[7.5933,47.9057],[7.6085,48.0026],[7.5842,48.0643],[7.6166,48.1568],[7.7057,48.28],[7.7651,48.41],[7.7948,48.5468],[7.838,48.636],[7.9228,48.6985],[8.124,48.8733],[8.1403,48.8864],[8.1349,48.9736],[8.0807,48.9859],[8.0013,49.0109],[7.7992,49.0419],[7.6109,49.0618],[7.5255,49.0864],[7.4506,49.1522],[7.4042,49.1531],[7.3134,49.1295],[7.1999,49.1136],[7.1174,49.1275],[7.0657,49.1249],[7.0367,49.1127],[7.0222,49.1234],[7.0015,49.1799],[6.9583,49.1946],[6.8912,49.2075],[6.8495,49.202],[6.8207,49.1739],[6.7763,49.1542],[6.7354,49.1606],[6.6076,49.2909],[6.5747,49.3197],[6.5663,49.3462],[6.5343,49.3947],[6.4581,49.4429],[6.3822,49.4582],[6.3443,49.4527],[6.3484,49.5127],[6.3783,49.5996],[6.4067,49.645],[6.4446,49.682],[6.4848,49.7078],[6.4938,49.7544],[6.4873,49.7985],[6.4409,49.8053],[6.3246,49.8379],[6.2561,49.8722],[6.2049,49.9151],[6.1382,49.9743],[6.1098,50.0344],[6.1083,50.0942],[6.1165,50.121],[6.1213,50.1394],[6.1751,50.2327],[6.3645,50.3162],[6.3437,50.4002],[6.3409,50.4518],[6.2949,50.4855],[6.203,50.4991],[6.1787,50.5225],[6.1685,50.5454],[6.2359,50.5967],[6.1545,50.6373],[6.1194,50.6792],[6.006,50.7322],[5.9939,50.7504],[6.0484,50.9049],[6.0068,50.95],[5.9551,50.9729],[5.8947,50.9842],[5.8672,51.0057],[5.8575,51.0301],[5.8684,51.0453],[5.9393,51.0408],[5.961,51.0567],[6.13,51.1474],[6.1369,51.1648],[6.1134,51.1747],[6.0824,51.18],[6.0748,51.199],[6.0759,51.2241],[6.1662,51.3548],[6.1929,51.4106],[6.1988,51.45],[6.1933,51.4889],[6.1416,51.5501],[6.0911,51.5989],[6.0894,51.6378],[6.0527,51.6583],[5.9485,51.7624],[5.9487,51.8027],[6.0076,51.834],[6.0898,51.854],[6.1172,51.8704],[6.1665,51.8808],[6.2971,51.8507],[6.3557,51.8247],[6.3722,51.83],[6.425,51.8584],[6.5176,51.854],[6.7418,51.9109],[6.7752,51.9383],[6.8004,51.9674],[6.8024,51.9802],[6.7156,52.0362],[6.713,52.0569],[6.7245,52.0802],[6.749,52.0987],[6.8004,52.1112],[6.8551,52.1358],[6.9772,52.2055],[7.0196,52.266],[7.0326,52.3315],[7.0352,52.3802],[7.0019,52.419],[6.9682,52.4441],[6.9221,52.4403],[6.8325,52.4423],[6.7488,52.464],[6.7029,52.4992],[6.6916,52.5302],[6.7124,52.5497],[6.7187,52.5736],[6.7054,52.5977],[6.7107,52.6179],[6.7484,52.6341],[7.0132,52.6335],[7.033,52.6514],[7.0509,52.7448],[7.1171,52.887],[7.1795,52.9662],[7.1899,52.9995],[7.189,53.1872],[7.1973,53.2823],[7.1521,53.327],[7.0533,53.3758],[7.0743,53.4776],[7.1071,53.557],[7.2064,53.6545],[7.2853,53.6813],[7.6292,53.6973],[8.0093,53.6907],[8.1671,53.5434],[8.1085,53.4677],[8.2008,53.4324],[8.2452,53.4453],[8.279,53.5112],[8.3016,53.5841],[8.3339,53.6062],[8.4514,53.5517],[8.4927,53.5144],[8.4952,53.3942],[8.5385,53.5569],[8.5063,53.6708],[8.5284,53.7811],[8.5756,53.8385],[8.6189,53.875],[8.8978,53.8357],[9.2056,53.856],[9.322,53.8135],[9.5854,53.6005],[9.6731,53.5656],[9.784,53.5546],[9.6313,53.6002],[9.312,53.8591],[9.2164,53.8912],[9.0696,53.9009],[8.9781,53.9262],[8.9204,53.9653],[8.9035,54.0003],[8.9066,54.2608],[8.8516,54.2996],[8.7804,54.313],[8.736,54.2952],[8.6449,54.295],[8.6258,54.354],[8.648,54.3977],[8.8312,54.4275],[8.9519,54.4676],[8.9572,54.5383],[8.881,54.5939],[8.7896,54.6959],[8.6823,54.7918],[8.6703,54.9034],[8.6707,54.9033],[8.8572,54.9011],[8.9029,54.8969],[9.1858,54.8447],[9.255,54.808]],[[8.3077,54.787],[8.2847,54.7671],[8.2957,54.9083],[8.4052,55.0587],[8.4515,55.0554],[8.4041,55.0147],[8.3904,54.9863],[8.3712,54.9294],[8.3799,54.8999],[8.6296,54.8917],[8.6006,54.8654],[8.3474,54.8476],[8.3077,54.787]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Germany","sov_a3":"DEU","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Germany","adm0_a3":"DEU","geou_dif":0,"geounit":"Germany","gu_a3":"DEU","su_dif":0,"subunit":"Germany","su_a3":"DEU","brk_diff":0,"name":"Germany","name_long":"Germany","brk_a3":"DEU","brk_name":"Germany","brk_group":"","abbrev":"Ger.","postal":"D","formal_en":"Federal Republic of Germany","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Germany","name_alt":"","mapcolor7":2,"mapcolor8":5,"mapcolor9":5,"mapcolor13":1,"pop_est":82329758,"gdp_md_est":2918000,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"1. Developed region: G7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"DE","iso_a3":"DEU","iso_n3":"276","un_a3":"276","wb_a2":"DE","wb_a3":"DEU","woe_id":-99,"adm0_a3_is":"DEU","adm0_a3_us":"DEU","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Western Europe","region_wb":"Europe & Central Asia","name_len":7,"long_len":7,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[43.246,11.4998],[43.1594,11.3657],[43.0486,11.1943],[42.9228,10.9993],[42.8441,10.9979],[42.783,11.0093],[42.7412,11.0424],[42.655,11.0783],[42.5577,11.0808],[42.4651,11.0471],[42.3081,11.0052],[42.1662,10.9916],[42.0521,10.9684],[41.9574,10.941],[41.8722,10.9558],[41.7982,10.9805],[41.782,11.1878],[41.7646,11.4129],[41.7665,11.5891],[41.7927,11.686],[41.8156,11.7238],[41.9496,11.8579],[41.9959,11.9124],[42.1491,12.1341],[42.2804,12.3243],[42.3785,12.4664],[42.4086,12.4944],[42.45,12.5213],[42.4794,12.5136],[42.6701,12.3766],[42.7037,12.3803],[42.7675,12.4229],[42.8253,12.5693],[42.8659,12.6228],[42.8833,12.6213],[43.0057,12.6623],[43.1167,12.7086],[43.1309,12.6604],[43.2986,12.4639],[43.3535,12.367],[43.4098,12.1899],[43.3803,12.0913],[43.3367,12.027],[43.2721,11.9695],[43.048,11.8291],[42.799,11.7394],[42.64,11.5601],[42.5218,11.5722],[42.5397,11.5043],[42.5838,11.4968],[42.6527,11.5096],[42.7897,11.5617],[42.9115,11.5866],[43.0428,11.5885],[43.1617,11.566],[43.246,11.4998]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Djibouti","sov_a3":"DJI","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Djibouti","adm0_a3":"DJI","geou_dif":0,"geounit":"Djibouti","gu_a3":"DJI","su_dif":0,"subunit":"Djibouti","su_a3":"DJI","brk_diff":0,"name":"Djibouti","name_long":"Djibouti","brk_a3":"DJI","brk_name":"Djibouti","brk_group":"","abbrev":"Dji.","postal":"DJ","formal_en":"Republic of Djibouti","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Djibouti","name_alt":"","mapcolor7":1,"mapcolor8":2,"mapcolor9":4,"mapcolor13":8,"pop_est":516055,"gdp_md_est":1885,"pop_year":-99,"lastcensus":2009,"gdp_year":-99,"economy":"7. Least developed region","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"DJ","iso_a3":"DJI","iso_n3":"262","un_a3":"262","wb_a2":"DJ","wb_a3":"DJI","woe_id":-99,"adm0_a3_is":"DJI","adm0_a3_us":"DJI","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Africa","region_un":"Africa","subregion":"Eastern Africa","region_wb":"Middle East & North Africa","name_len":8,"long_len":8,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[28.1479,56.1429],[28.2843,56.0559],[28.3163,56.0525],[28.3921,56.0867],[28.407,56.089],[28.564,56.092],[28.6369,56.0618],[28.6908,56.0026],[28.7408,55.9554],[28.7947,55.9426],[28.9475,56.0021],[29.0317,56.0218],[29.0874,56.0211],[29.283,55.9679],[29.375,55.9387],[29.3961,55.9122],[29.3979,55.8811],[29.3731,55.8347],[29.3534,55.7844],[29.413,55.7249],[29.4822,55.6846],[29.6301,55.7512],[29.6846,55.7697],[29.7441,55.7704],[29.8239,55.7951],[29.8816,55.8323],[29.937,55.8453],[30.0427,55.8364],[30.2336,55.8452],[30.4563,55.7868],[30.4754,55.7688],[30.5867,55.7003],[30.6256,55.6663],[30.6623,55.6555],[30.7217,55.6221],[30.8008,55.6011],[30.856,55.6075],[30.8822,55.5964],[30.9068,55.57],[30.9088,55.5253],[30.9006,55.3974],[30.8618,55.3604],[30.821,55.3303],[30.8105,55.307],[30.8145,55.2787],[30.8774,55.2234],[30.9589,55.1376],[30.9777,55.0878],[30.9777,55.0505],[30.8668,54.9407],[30.8299,54.915],[30.8045,54.8609],[30.791,54.806],[30.7988,54.7833],[30.9842,54.6959],[31.1213,54.6485],[31.1521,54.6253],[31.1549,54.6109],[31.0819,54.5171],[31.0748,54.4918],[31.1848,54.453],[31.2455,54.3917],[31.2991,54.2917],[31.4036,54.1959],[31.6284,54.1112],[31.792,54.0559],[31.826,54.0307],[31.8378,54.0008],[31.8253,53.935],[31.783,53.855],[31.7542,53.8104],[31.8208,53.7919],[31.9922,53.7969],[32.2004,53.7813],[32.4502,53.6929],[32.451,53.6533],[32.4252,53.6173],[32.4424,53.5792],[32.4696,53.547],[32.6857,53.4481],[32.7064,53.4194],[32.7103,53.3714],[32.7043,53.3363],[32.6444,53.3289],[32.578,53.3124],[32.4693,53.2703],[32.4263,53.2106],[32.2507,53.1284],[32.142,53.0912],[32.0555,53.0895],[31.8497,53.1062],[31.7774,53.1469],[31.7475,53.1842],[31.6683,53.2009],[31.563,53.2025],[31.4179,53.196],[31.3884,53.1848],[31.3646,53.139],[31.3029,53.0609],[31.2588,53.0167],[31.2951,52.9898],[31.353,52.9334],[31.4428,52.8618],[31.5352,52.7982],[31.5648,52.7592],[31.5635,52.7314],[31.5194,52.6987],[31.5262,52.633],[31.6159,52.5462],[31.5855,52.5325],[31.5766,52.426],[31.5773,52.3123],[31.6016,52.2848],[31.6499,52.2622],[31.6906,52.2207],[31.7586,52.1258],[31.7634,52.1011],[31.5737,52.1081],[31.346,52.1054],[31.218,52.0502],[31.1685,52.0629],[31.0793,52.077],[30.9807,52.0462],[30.8457,51.9531],[30.7553,51.8952],[30.6673,51.8141],[30.6395,51.7701],[30.5839,51.689],[30.533,51.5963],[30.5607,51.5315],[30.6023,51.4712],[30.6117,51.4063],[30.6325,51.3554],[30.577,51.3184],[30.5445,51.265],[30.4495,51.2743],[30.3334,51.3255],[30.309,51.3996],[30.2195,51.4512],[30.1607,51.4779],[30.0638,51.482],[29.9088,51.458],[29.7061,51.4396],[29.5531,51.4346],[29.4696,51.4083],[29.3465,51.3826],[29.2988,51.413],[29.2305,51.497],[29.1742,51.5806],[29.1356,51.6173],[29.1021,51.6275],[29.0607,51.6254],[29.0131,51.5989],[28.9777,51.5718],[28.9275,51.5622],[28.8495,51.5402],[28.7933,51.5104],[28.7313,51.4334],[28.6902,51.4389],[28.6478,51.4565],[28.599,51.5426],[28.532,51.5625],[28.4246,51.5636],[28.2916,51.5818],[28.1838,51.6079],[28.1444,51.6017],[28.0803,51.565],[28.0107,51.5598],[27.8586,51.5924],[27.8288,51.5774],[27.7889,51.5292],[27.7413,51.4826],[27.7,51.478],[27.6768,51.4899],[27.6897,51.5724],[27.6014,51.6016],[27.4523,51.6061],[27.3477,51.5941],[27.2963,51.5974],[27.2701,51.6136],[27.142,51.7521],[27.0741,51.7608],[26.9528,51.754],[26.7734,51.7707],[26.5669,51.8019],[26.4534,51.8134],[26.3943,51.8444],[26.2671,51.855],[25.9253,51.9135],[25.7857,51.9238],[25.5803,51.9248],[25.2672,51.9377],[25.0667,51.9305],[24.9738,51.9111],[24.8664,51.8991],[24.6852,51.8883],[24.6113,51.8895],[24.4952,51.8831],[24.3619,51.8675],[24.3237,51.8384],[24.2801,51.7747],[24.1269,51.6646],[23.9783,51.5913],[23.9512,51.5851],[23.8643,51.624],[23.7917,51.6371],[23.7068,51.6413],[23.6467,51.6289],[23.6086,51.6105],[23.6138,51.5254],[23.6053,51.5179],[23.5396,51.6189],[23.5448,51.7103],[23.5813,51.7624],[23.6257,51.8093],[23.6074,51.8798],[23.6511,51.973],[23.6524,52.0404],[23.6333,52.0696],[23.5979,52.1031],[23.5012,52.1404],[23.4584,52.1695],[23.3271,52.2084],[23.197,52.2569],[23.1751,52.2866],[23.1813,52.307],[23.2041,52.3379],[23.3033,52.4284],[23.4109,52.5162],[23.4796,52.5516],[23.8447,52.6642],[23.9013,52.7036],[23.9154,52.7703],[23.9163,52.8188],[23.9094,52.9049],[23.8871,53.0275],[23.8592,53.1121],[23.7893,53.2709],[23.5989,53.5992],[23.4847,53.9398],[23.5591,53.9198],[23.7337,53.9123],[23.8726,53.9357],[23.9444,53.939],[24.0085,53.9316],[24.1039,53.945],[24.1913,53.9504],[24.2366,53.92],[24.318,53.893],[24.4785,53.9318],[24.6207,53.9798],[24.7682,53.9747],[24.7893,53.9982],[24.8257,54.119],[24.8695,54.1452],[25.0461,54.1331],[25.1114,54.1549],[25.1795,54.2143],[25.2837,54.2513],[25.3706,54.2512],[25.4611,54.2928],[25.5057,54.2649],[25.5273,54.2151],[25.4974,54.1752],[25.5104,54.1596],[25.573,54.1399],[25.6806,54.1405],[25.7492,54.157],[25.7652,54.1798],[25.765,54.2212],[25.7481,54.2597],[25.7025,54.293],[25.6169,54.3101],[25.5575,54.3107],[25.5474,54.3318],[25.5676,54.3771],[25.6203,54.4604],[25.6852,54.5358],[25.7248,54.5643],[25.7316,54.5904],[25.7239,54.636],[25.7225,54.7179],[25.7809,54.8333],[25.8593,54.9193],[25.9645,54.9472],[26.093,54.9623],[26.1752,55.0033],[26.2158,55.0504],[26.2313,55.0901],[26.2508,55.1245],[26.2918,55.1396],[26.6012,55.1302],[26.6484,55.2042],[26.675,55.2249],[26.7344,55.2468],[26.7757,55.2731],[26.7602,55.2934],[26.6813,55.3064],[26.4953,55.318],[26.4576,55.3425],[26.4695,55.3719],[26.5192,55.4481],[26.5666,55.5465],[26.5908,55.6227],[26.5936,55.6675],[26.6202,55.6796],[26.7719,55.694],[26.8225,55.7092],[26.953,55.8129],[27.0525,55.8306],[27.3092,55.8039],[27.4271,55.806],[27.4592,55.8035],[27.5768,55.7988],[27.5895,55.8092],[27.6423,55.9117],[27.6942,55.9416],[27.8963,56.0762],[28.032,56.1333],[28.1179,56.1458],[28.1479,56.1429]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":4,"sovereignt":"Belarus","sov_a3":"BLR","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Belarus","adm0_a3":"BLR","geou_dif":0,"geounit":"Belarus","gu_a3":"BLR","su_dif":0,"subunit":"Belarus","su_a3":"BLR","brk_diff":0,"name":"Belarus","name_long":"Belarus","brk_a3":"BLR","brk_name":"Belarus","brk_group":"","abbrev":"Bela.","postal":"BY","formal_en":"Republic of Belarus","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Belarus","name_alt":"","mapcolor7":1,"mapcolor8":1,"mapcolor9":5,"mapcolor13":11,"pop_est":9648533,"gdp_md_est":114100,"pop_year":-99,"lastcensus":2009,"gdp_year":-99,"economy":"6. Developing region","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"BY","iso_a3":"BLR","iso_n3":"112","un_a3":"112","wb_a2":"BY","wb_a3":"BLR","woe_id":-99,"adm0_a3_is":"BLR","adm0_a3_us":"BLR","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Eastern Europe","region_wb":"Europe & Central Asia","name_len":7,"long_len":7,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[99.6631,6.5219],[99.644,6.5161],[99.6066,6.5968],[99.654,6.7141],[99.7014,6.5706],[99.6631,6.5219]],[[99.0784,7.5918],[99.1044,7.4713],[99.0679,7.4959],[99.0377,7.5485],[99.0381,7.6257],[99.0451,7.6365],[99.0784,7.5918]],[[98.592,7.9339],[98.58,7.917],[98.5294,8.1085],[98.6043,8.0573],[98.592,7.9339]],[[98.4091,7.9021],[98.3984,7.8284],[98.3574,7.8294],[98.3156,7.7823],[98.2963,7.7761],[98.2623,7.9261],[98.3014,8.1362],[98.3221,8.1663],[98.351,8.1106],[98.435,8.0856],[98.3988,7.9646],[98.4091,7.9021]],[[98.3075,9.0515],[98.2508,9.0408],[98.2584,9.0954],[98.2736,9.1299],[98.3012,9.1391],[98.3125,9.0804],[98.3075,9.0515]],[[100.0707,9.586],[100.0753,9.5294],[100.0537,9.4614],[99.9624,9.4216],[99.9313,9.4761],[99.9396,9.56],[99.9536,9.581],[100.043,9.5769],[100.0707,9.586]],[[100.0741,9.6967],[100.0645,9.68],[100.0257,9.7117],[99.998,9.7476],[99.9834,9.7936],[100.0435,9.7917],[100.073,9.7491],[100.0741,9.6967]],[[102.6064,11.6765],[102.5899,11.5722],[102.5328,11.6149],[102.5465,11.6678],[102.5689,11.6917],[102.6064,11.6765]],[[102.4268,11.9887],[102.43,11.9647],[102.3781,11.983],[102.36,11.9744],[102.302,11.9808],[102.2733,12.1193],[102.2774,12.1519],[102.3188,12.1417],[102.3781,12.0729],[102.4084,12.0251],[102.4268,11.9887]],[[100.0036,20.3796],[100.1225,20.3167],[100.1149,20.2577],[100.1397,20.2454],[100.1741,20.2728],[100.2181,20.3396],[100.266,20.3773],[100.318,20.3859],[100.3731,20.3404],[100.4315,20.2407],[100.4916,20.1841],[100.5195,20.1779],[100.5399,20.1324],[100.5431,20.0887],[100.5146,19.9963],[100.4662,19.8889],[100.3977,19.7561],[100.4201,19.6445],[100.5136,19.5535],[100.6255,19.4999],[100.7439,19.5147],[100.8068,19.5419],[100.8582,19.5851],[100.9061,19.6054],[100.9665,19.6108],[101.1547,19.5792],[101.2119,19.5483],[101.2208,19.4866],[101.1976,19.3279],[101.2266,19.2115],[101.2799,19.0889],[101.2863,18.9771],[101.2205,18.7928],[101.1655,18.6183],[101.1063,18.5335],[101.0604,18.479],[101.047,18.442],[101.0506,18.407],[101.0928,18.3545],[101.1375,18.2869],[101.1487,18.2222],[101.1439,18.1426],[101.1133,18.0335],[100.999,17.7972],[100.9085,17.5839],[100.9559,17.5411],[101.0457,17.51],[101.1052,17.4795],[101.1675,17.499],[101.2997,17.625],[101.4137,17.7187],[101.5551,17.8124],[101.5637,17.8205],[101.6875,17.8894],[101.7441,17.9527],[101.7748,18.0334],[101.8187,18.0646],[101.8755,18.0464],[101.9475,18.0815],[102.0346,18.1698],[102.1015,18.2106],[102.1482,18.2039],[102.2316,18.149],[102.3519,18.0459],[102.4588,17.9846],[102.5525,17.9651],[102.5982,17.9268],[102.5961,17.8696],[102.6168,17.8333],[102.6606,17.818],[102.6801,17.8241],[102.6752,17.8518],[102.7176,17.8922],[102.8074,17.9456],[102.8986,17.9769],[102.9914,17.9862],[103.0514,18.0285],[103.0912,18.1382],[103.1485,18.2217],[103.1997,18.2595],[103.2632,18.2785],[103.2796,18.305],[103.2489,18.339],[103.2518,18.3735],[103.2883,18.4084],[103.367,18.4233],[103.488,18.4182],[103.6297,18.3826],[103.7923,18.3165],[103.8988,18.2953],[103.9496,18.319],[104.0487,18.2167],[104.1962,17.9884],[104.3227,17.8158],[104.4281,17.699],[104.5393,17.6093],[104.6559,17.5467],[104.7396,17.4617],[104.816,17.3003],[104.759,17.0771],[104.7436,16.8844],[104.7506,16.6476],[104.8193,16.4661],[104.9499,16.3399],[105.0258,16.238],[105.0472,16.1603],[105.1487,16.0936],[105.3307,16.0379],[105.4063,15.9875],[105.3756,15.9422],[105.3732,15.8897],[105.3989,15.8299],[105.462,15.7804],[105.5624,15.7413],[105.6221,15.7],[105.641,15.6565],[105.6389,15.5859],[105.6156,15.4883],[105.5737,15.4132],[105.5132,15.3609],[105.5059,15.3196],[105.4904,15.2566],[105.4904,15.1276],[105.5334,15.0416],[105.5467,14.9325],[105.523,14.8433],[105.5002,14.6612],[105.4974,14.5907],[105.4756,14.5301],[105.4227,14.4716],[105.3422,14.4167],[105.2437,14.3679],[105.1833,14.3462],[105.1691,14.3361],[105.126,14.281],[105.0741,14.2274],[105.0337,14.2274],[105.0034,14.2544],[104.9824,14.2895],[104.9697,14.3661],[104.8788,14.404],[104.779,14.4278],[104.5758,14.39],[104.4116,14.3696],[104.2277,14.3955],[104.0543,14.3627],[103.9818,14.3579],[103.8986,14.3628],[103.8184,14.3622],[103.7419,14.3742],[103.6004,14.4211],[103.5464,14.4174],[103.4324,14.3786],[103.3135,14.3513],[103.1994,14.3326],[103.0311,14.2525],[102.9093,14.1367],[102.8732,14.0549],[102.8128,13.9725],[102.7289,13.8419],[102.6204,13.7169],[102.5447,13.66],[102.5655,13.6264],[102.5469,13.5857],[102.4285,13.5676],[102.3363,13.5603],[102.3197,13.54],[102.3308,13.2882],[102.363,13.193],[102.4227,13.078],[102.4617,13.015],[102.4907,12.8283],[102.4996,12.67],[102.6297,12.5699],[102.7033,12.4935],[102.7557,12.4263],[102.7374,12.3834],[102.7063,12.2557],[102.7366,12.0898],[102.9181,11.7321],[102.9339,11.7067],[102.9123,11.7039],[102.8837,11.7728],[102.7916,11.8886],[102.763,12.0125],[102.6549,12.1488],[102.5941,12.203],[102.5748,12.1578],[102.5402,12.1092],[102.4341,12.1792],[102.3432,12.2526],[102.2591,12.3943],[102.2484,12.3614],[102.2296,12.3316],[102.1342,12.443],[102.0344,12.5319],[101.9445,12.5637],[101.8891,12.5933],[101.8357,12.6404],[101.7236,12.6894],[101.4449,12.6189],[101.0902,12.6736],[100.9537,12.6212],[100.8978,12.6538],[100.8633,12.7145],[100.8964,12.8182],[100.9039,13.0349],[100.9461,13.1873],[100.9263,13.303],[100.947,13.3576],[100.9627,13.432],[100.9065,13.4624],[100.6561,13.5213],[100.6029,13.5682],[100.5364,13.5145],[100.2356,13.4845],[100.1224,13.4396],[100.0175,13.3532],[99.9905,13.2435],[100.0511,13.1712],[100.0899,13.0457],[99.982,12.7715],[99.964,12.69],[100.0057,12.3547],[99.9891,12.1708],[99.9303,12.0475],[99.8371,11.9366],[99.7987,11.7488],[99.7255,11.6618],[99.6273,11.4629],[99.5613,11.2152],[99.5144,11.1006],[99.4869,10.8896],[99.2848,10.5691],[99.2373,10.3881],[99.165,10.3198],[99.1903,10.2659],[99.1946,10.1754],[99.1693,9.9342],[99.1607,9.734],[99.1913,9.6271],[99.2883,9.4146],[99.265,9.353],[99.2539,9.2652],[99.3354,9.2254],[99.3938,9.2137],[99.7238,9.3142],[99.8355,9.2884],[99.8775,9.1946],[99.9047,9.1129],[99.9606,8.6712],[99.9896,8.5892],[100.0563,8.5111],[100.1293,8.4281],[100.1541,8.443],[100.1589,8.4738],[100.1635,8.5084],[100.2287,8.4247],[100.2794,8.2685],[100.4535,7.4423],[100.5037,7.3373],[100.5452,7.2269],[100.4394,7.2808],[100.4107,7.4643],[100.3804,7.5415],[100.343,7.5529],[100.2838,7.5515],[100.28,7.5843],[100.3243,7.6442],[100.3174,7.716],[100.2566,7.7749],[100.1582,7.7281],[100.1607,7.5993],[100.2049,7.5005],[100.3714,7.2801],[100.4235,7.1878],[100.4897,7.1614],[100.5862,7.176],[100.7017,7.082],[100.7926,6.9947],[101.0179,6.8609],[101.1544,6.8751],[101.302,6.9083],[101.4009,6.8996],[101.4979,6.8653],[101.6143,6.754],[101.7992,6.4746],[102.1011,6.2422],[102.0684,6.1847],[102.0552,6.0967],[101.9361,5.9793],[101.9172,5.9114],[101.8736,5.8253],[101.7907,5.7793],[101.7195,5.7706],[101.6784,5.7788],[101.65,5.796],[101.6014,5.8771],[101.5768,5.902],[101.5561,5.9078],[101.4042,5.8517],[101.257,5.7894],[101.2298,5.7337],[101.1906,5.6687],[101.1477,5.6431],[101.114,5.6368],[101.0817,5.6749],[101.0252,5.7245],[100.9816,5.771],[100.9928,5.8462],[101.0756,5.9565],[101.0865,6.0337],[101.076,6.1661],[101.0535,6.2426],[101.0294,6.2453],[100.9888,6.2577],[100.8739,6.2454],[100.8165,6.3316],[100.7938,6.4262],[100.7545,6.4601],[100.7156,6.4807],[100.6295,6.448],[100.5639,6.4675],[100.3454,6.5499],[100.2614,6.6827],[100.2166,6.6866],[100.1768,6.6718],[100.1612,6.6416],[100.138,6.4887],[100.1191,6.442],[99.8687,6.7499],[99.696,6.8767],[99.7203,7.1062],[99.6678,7.1509],[99.6024,7.1553],[99.553,7.2188],[99.597,7.3556],[99.5291,7.3295],[99.4352,7.3344],[99.3586,7.3722],[99.3004,7.5613],[99.2637,7.619],[99.1834,7.7181],[99.0776,7.7181],[99.0427,7.7656],[99.0511,7.8878],[98.9739,7.9628],[98.8725,8.0239],[98.7887,8.0598],[98.7035,8.2567],[98.6363,8.305],[98.5792,8.3443],[98.4998,8.3178],[98.474,8.2469],[98.421,8.1782],[98.3607,8.187],[98.3055,8.2262],[98.2382,8.4231],[98.227,8.5437],[98.2418,8.7679],[98.326,8.9689],[98.3714,9.2905],[98.4432,9.4928],[98.493,9.5614],[98.5619,9.8375],[98.7025,10.1904],[98.7185,10.266],[98.7469,10.3508],[98.7684,10.4309],[98.7754,10.557],[98.7572,10.6236],[98.7572,10.6609],[98.7869,10.7084],[98.8871,10.7883],[99.0254,10.92],[99.1901,11.1053],[99.3588,11.3895],[99.4427,11.5544],[99.4779,11.6125],[99.5152,11.6307],[99.5729,11.6872],[99.6125,11.7497],[99.6147,11.7812],[99.5229,12.0896],[99.4629,12.1902],[99.4324,12.309],[99.4163,12.3948],[99.3942,12.4736],[99.4051,12.5479],[99.372,12.5942],[99.2974,12.6529],[99.2198,12.7397],[99.1735,12.8819],[99.1735,12.9613],[99.1239,13.0308],[99.1074,13.1035],[99.1371,13.173],[99.1762,13.2331],[99.1717,13.4969],[99.1561,13.5758],[99.1368,13.7167],[99.0862,13.8228],[99.0146,13.9472],[98.9336,14.0499],[98.7212,14.2357],[98.57,14.3599],[98.495,14.4729],[98.4002,14.603],[98.3321,14.6965],[98.246,14.8147],[98.2021,14.9759],[98.1779,15.1474],[98.191,15.2041],[98.2322,15.2414],[98.2861,15.2716],[98.3294,15.2786],[98.4521,15.3574],[98.5373,15.3507],[98.5569,15.3677],[98.5652,15.4036],[98.5545,15.5598],[98.5582,15.7686],[98.574,15.9386],[98.5924,16.0507],[98.818,16.1808],[98.8655,16.2371],[98.8885,16.2981],[98.8883,16.3519],[98.8693,16.3942],[98.8354,16.4176],[98.6893,16.3054],[98.6607,16.3304],[98.5937,16.5148],[98.5647,16.5709],[98.5231,16.6382],[98.4781,16.7322],[98.4712,16.895],[98.4389,16.9757],[98.2565,17.1477],[98.1746,17.2399],[98.0631,17.3733],[97.9293,17.5333],[97.793,17.6813],[97.7291,17.7758],[97.7064,17.7971],[97.6985,17.8335],[97.7399,17.9353],[97.7197,18.0374],[97.6516,18.1737],[97.6225,18.258],[97.6322,18.2903],[97.5993,18.303],[97.5238,18.2959],[97.4508,18.3597],[97.3807,18.4943],[97.3739,18.518],[97.3971,18.5175],[97.485,18.4942],[97.5151,18.4978],[97.5773,18.5287],[97.6716,18.5612],[97.7277,18.572],[97.7459,18.5882],[97.754,18.6208],[97.7061,18.9318],[97.7142,18.9965],[97.8039,19.1305],[97.7936,19.2659],[97.8168,19.46],[97.9164,19.5929],[97.9912,19.6537],[98.015,19.7495],[98.049,19.7697],[98.111,19.7622],[98.2391,19.6907],[98.2937,19.6873],[98.3713,19.6892],[98.455,19.6944],[98.4938,19.7013],[98.7606,19.7711],[98.8195,19.7785],[98.8758,19.7696],[98.9167,19.7729],[98.958,19.8049],[98.9874,19.8614],[99.0207,20.0418],[99.0397,20.0736],[99.0742,20.0994],[99.1308,20.1166],[99.1969,20.1151],[99.2837,20.0804],[99.3379,20.0789],[99.3992,20.0935],[99.4516,20.1183],[99.4859,20.1499],[99.5017,20.1877],[99.4875,20.2606],[99.4479,20.3521],[99.4589,20.363],[99.5316,20.3428],[99.6387,20.3205],[99.7201,20.3254],[99.7733,20.3413],[99.8252,20.3845],[99.8903,20.4244],[99.9543,20.4154],[100.0036,20.3796]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Thailand","sov_a3":"THA","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Thailand","adm0_a3":"THA","geou_dif":0,"geounit":"Thailand","gu_a3":"THA","su_dif":0,"subunit":"Thailand","su_a3":"THA","brk_diff":0,"name":"Thailand","name_long":"Thailand","brk_a3":"THA","brk_name":"Thailand","brk_group":"","abbrev":"Thai.","postal":"TH","formal_en":"Kingdom of Thailand","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Thailand","name_alt":"","mapcolor7":3,"mapcolor8":6,"mapcolor9":8,"mapcolor13":1,"pop_est":65905410,"gdp_md_est":547400,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"5. Emerging region: G20","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"TH","iso_a3":"THA","iso_n3":"764","un_a3":"764","wb_a2":"TH","wb_a3":"THA","woe_id":-99,"adm0_a3_is":"THA","adm0_a3_us":"THA","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"South-Eastern Asia","region_wb":"East Asia & Pacific","name_len":8,"long_len":8,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[70.7017,39.8253],[70.6121,39.7868],[70.5596,39.7909],[70.5187,39.8282],[70.4893,39.863],[70.4828,39.8827],[70.4978,39.8824],[70.5671,39.8666],[70.6642,39.8555],[70.6982,39.8458],[70.7017,39.8253]],[[70.6525,40.9366],[70.6228,40.9344],[70.5688,40.9818],[70.55,41.0149],[70.5721,41.0248],[70.6184,41.0017],[70.6492,40.9608],[70.6525,40.9366]],[[70.6983,40.6612],[70.5488,40.5628],[70.3826,40.4535],[70.3771,40.4393],[70.3697,40.412],[70.3716,40.3841],[70.3982,40.3614],[70.4699,40.3454],[70.5336,40.3245],[70.5658,40.2671],[70.6027,40.2142],[70.6531,40.2012],[70.8994,40.2346],[70.958,40.2389],[70.9609,40.2207],[70.9464,40.1876],[70.7386,40.1312],[70.6443,40.0834],[70.6241,39.999],[70.5992,39.9745],[70.5568,39.9545],[70.5151,39.9499],[70.4514,40.0492],[70.3789,40.0699],[70.2744,40.1048],[70.0715,40.1728],[69.9668,40.2022],[69.7652,40.158],[69.5303,40.0973],[69.4937,40.0604],[69.4688,40.0208],[69.471,39.9906],[69.4879,39.9504],[69.4763,39.9197],[69.4319,39.9098],[69.3654,39.9471],[69.3072,39.9686],[69.2788,39.9178],[69.2447,39.8271],[69.2291,39.7611],[69.2803,39.6659],[69.2977,39.5248],[69.3915,39.5325],[69.4633,39.5321],[69.5988,39.5738],[69.667,39.5749],[69.7721,39.5567],[69.956,39.5531],[70.1017,39.5606],[70.1368,39.5576],[70.1711,39.5842],[70.2093,39.575],[70.2448,39.5426],[70.3921,39.5819],[70.5012,39.5874],[70.568,39.5759],[70.6078,39.5644],[70.6786,39.4713],[70.7331,39.4133],[70.7993,39.3947],[71.0049,39.4119],[71.065,39.4934],[71.1181,39.5136],[71.2027,39.5198],[71.2729,39.5353],[71.3285,39.5687],[71.4043,39.5979],[71.4703,39.6037],[71.503,39.5822],[71.5174,39.5539],[71.5059,39.5171],[71.5033,39.4788],[71.5463,39.4531],[71.6727,39.4471],[71.7322,39.423],[71.7354,39.3777],[71.7257,39.3066],[71.7786,39.278],[71.806,39.2756],[71.991,39.3509],[72.0428,39.3521],[72.0842,39.3106],[72.1474,39.2607],[72.23,39.2075],[72.2498,39.2157],[72.2872,39.2737],[72.3577,39.3369],[72.4902,39.3574],[72.5634,39.3772],[72.6399,39.386],[72.8725,39.3604],[72.9494,39.3571],[73.1093,39.3619],[73.235,39.3746],[73.3361,39.4124],[73.3874,39.4427],[73.4704,39.4606],[73.5756,39.4576],[73.6316,39.4489],[73.6363,39.3967],[73.6231,39.2979],[73.6073,39.2292],[73.6904,39.1045],[73.7438,39.0445],[73.7956,39.0021],[73.8053,38.9687],[73.7945,38.9413],[73.73,38.9147],[73.7068,38.8862],[73.6961,38.8543],[73.7168,38.8172],[73.7541,38.6989],[73.8017,38.6069],[73.8691,38.5629],[73.97,38.5337],[74.0256,38.5398],[74.0653,38.6085],[74.1313,38.6612],[74.1873,38.6575],[74.2774,38.6598],[74.5141,38.6],[74.745,38.51],[74.8123,38.4603],[74.8359,38.4043],[74.7721,38.2748],[74.7751,38.1919],[74.7896,38.1036],[74.8425,38.0381],[74.8908,37.9258],[74.9003,37.8327],[74.9213,37.805],[74.9383,37.7725],[74.9123,37.6873],[74.8942,37.6014],[74.9158,37.5728],[74.9864,37.5304],[75.0975,37.4513],[75.1188,37.3857],[75.079,37.344],[75.0084,37.2936],[74.9182,37.25],[74.8913,37.2316],[74.8754,37.242],[74.8305,37.2859],[74.7306,37.357],[74.6594,37.3945],[74.5242,37.3824],[74.4449,37.3956],[74.349,37.4187],[74.2597,37.4154],[74.2035,37.3725],[74.1671,37.3294],[74.0777,37.3162],[73.9488,37.2832],[73.7496,37.2318],[73.6535,37.2394],[73.6275,37.2616],[73.6488,37.2912],[73.7173,37.3294],[73.7338,37.3758],[73.7206,37.4187],[73.6571,37.4305],[73.6326,37.4372],[73.6047,37.446],[73.4813,37.4717],[73.3829,37.4623],[73.2111,37.4085],[72.8955,37.2675],[72.757,37.1727],[72.6574,37.0291],[72.3588,36.9829],[72.1535,36.9005],[71.942,36.7665],[71.8021,36.6943],[71.7338,36.684],[71.6656,36.6969],[71.5975,36.7329],[71.5309,36.8451],[71.4719,37.0151],[71.4329,37.1275],[71.4548,37.2718],[71.4797,37.436],[71.5051,37.6029],[71.5462,37.7957],[71.5804,37.8643],[71.5822,37.9101],[71.552,37.9332],[71.4878,37.9319],[71.3896,37.9063],[71.3199,37.9019],[71.2785,37.9184],[71.2828,38.0079],[71.3327,38.1703],[71.2559,38.307],[71.0521,38.4179],[70.8789,38.4564],[70.7359,38.4226],[70.6158,38.3344],[70.5186,38.192],[70.4178,38.0754],[70.3133,37.9848],[70.2388,37.9412],[70.2146,37.9244],[70.1994,37.886],[70.255,37.7654],[70.2515,37.6642],[70.1887,37.5825],[70.1198,37.5435],[70.0447,37.5472],[69.985,37.5662],[69.9406,37.6003],[69.8209,37.6096],[69.6258,37.594],[69.4921,37.5531],[69.4201,37.4867],[69.3992,37.3993],[69.4297,37.2909],[69.4145,37.2078],[69.3538,37.15],[69.3039,37.1169],[69.2648,37.1084],[69.1802,37.1583],[69.05,37.2665],[68.9604,37.325],[68.9118,37.3339],[68.8853,37.3281],[68.8554,37.3168],[68.8385,37.3028],[68.8237,37.2707],[68.782,37.258],[68.7232,37.268],[68.6691,37.2584],[68.637,37.2245],[68.5465,37.1834],[68.3869,37.1375],[68.2995,37.0884],[68.2848,37.0363],[68.2609,37.0131],[68.2121,37.0215],[68.0678,36.9498],[67.958,36.972],[67.8345,37.0642],[67.766,37.1401],[67.759,37.1722],[67.798,37.245],[67.8144,37.487],[67.8636,37.5707],[68.0109,37.7209],[68.0876,37.8354],[68.174,37.9284],[68.2365,37.9597],[68.294,38.0329],[68.3412,38.1168],[68.3545,38.1695],[68.3503,38.211],[68.3331,38.2378],[68.2514,38.2945],[68.1441,38.3831],[68.0872,38.4735],[68.056,38.5889],[68.0479,38.6693],[68.1485,38.8906],[68.1325,38.9276],[68.1035,38.962],[68.0443,38.9836],[67.9596,38.9929],[67.8757,38.983],[67.7686,38.9822],[67.6944,38.9946],[67.6766,39.0085],[67.6673,39.1092],[67.6483,39.1311],[67.6165,39.1503],[67.4004,39.1967],[67.3576,39.2167],[67.3496,39.2421],[67.4262,39.4656],[67.4596,39.4824],[67.4917,39.5187],[67.5425,39.5576],[67.719,39.6214],[67.9086,39.5938],[68.0771,39.5642],[68.2449,39.5483],[68.303,39.5377],[68.399,39.5289],[68.4633,39.5367],[68.5069,39.5628],[68.5861,39.635],[68.6104,39.7433],[68.639,39.8389],[68.6869,39.8463],[68.7353,39.8362],[68.7582,39.8556],[68.768,39.8818],[68.7778,39.9042],[68.7977,39.9091],[68.8324,39.8843],[68.8522,39.891],[68.8688,39.9075],[68.8639,39.9273],[68.8244,39.9608],[68.7895,40.0133],[68.7928,40.0315],[68.8047,40.0503],[68.9085,40.0682],[68.9557,40.0713],[68.9721,40.0899],[68.966,40.1196],[68.9269,40.1363],[68.7846,40.1271],[68.6397,40.1292],[68.6225,40.1473],[68.6307,40.1671],[68.6525,40.1827],[68.9518,40.2226],[69.1104,40.2087],[69.2283,40.1876],[69.2749,40.1981],[69.2195,40.2881],[69.2944,40.2966],[69.3042,40.3274],[69.2063,40.5666],[69.26,40.5876],[69.314,40.6348],[69.3094,40.7239],[69.3572,40.7674],[69.4139,40.7972],[69.4982,40.7671],[69.6284,40.6791],[69.6708,40.662],[69.7129,40.657],[69.7732,40.6843],[70.0057,40.7714],[70.1363,40.8204],[70.2921,40.8917],[70.3189,40.9192],[70.3727,41.0276],[70.402,41.0351],[70.4415,41.0234],[70.5782,40.9115],[70.6573,40.8396],[70.6573,40.8151],[70.6348,40.7966],[70.6392,40.7786],[70.751,40.7396],[70.7511,40.7218],[70.7256,40.6878],[70.712,40.6691],[70.6983,40.6612]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":4,"sovereignt":"Tajikistan","sov_a3":"TJK","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Tajikistan","adm0_a3":"TJK","geou_dif":0,"geounit":"Tajikistan","gu_a3":"TJK","su_dif":0,"subunit":"Tajikistan","su_a3":"TJK","brk_diff":0,"name":"Tajikistan","name_long":"Tajikistan","brk_a3":"TJK","brk_name":"Tajikistan","brk_group":"","abbrev":"Tjk.","postal":"TJ","formal_en":"Republic of Tajikistan","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Tajikistan","name_alt":"","mapcolor7":3,"mapcolor8":6,"mapcolor9":2,"mapcolor13":5,"pop_est":7349145,"gdp_md_est":13160,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"6. Developing region","income_grp":"5. Low income","wikipedia":-99,"fips_10":"","iso_a2":"TJ","iso_a3":"TJK","iso_n3":"762","un_a3":"762","wb_a2":"TJ","wb_a3":"TJK","woe_id":-99,"adm0_a3_is":"TJK","adm0_a3_us":"TJK","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Central Asia","region_wb":"Europe & Central Asia","name_len":10,"long_len":10,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[53.1096,38.8031],[53.1002,38.7562],[53.0459,38.8972],[53.0186,39.0527],[53.0533,39.0966],[53.0922,39.0941],[53.0552,39.0379],[53.1096,38.8031]],[[58.73,42.6762],[58.877,42.5615],[58.9309,42.5403],[59.0358,42.5281],[59.1231,42.5238],[59.1596,42.5114],[59.1991,42.4817],[59.2766,42.3562],[59.3543,42.3233],[59.4511,42.2995],[59.7626,42.3016],[59.8583,42.2952],[59.9365,42.236],[59.9852,42.2117],[60.0061,42.1908],[60.0008,42.1647],[59.9816,42.1317],[59.9792,42.0681],[59.9741,42.0188],[59.9493,41.9954],[59.9418,41.9735],[59.9626,41.9544],[60.1069,41.9074],[60.1556,41.857],[60.1921,41.8344],[60.2008,41.8031],[60.1764,41.7823],[60.1086,41.7927],[60.0756,41.7597],[60.0756,41.7005],[60.124,41.645],[60.138,41.5941],[60.1061,41.5452],[60.0688,41.4762],[60.0674,41.4273],[60.0896,41.3994],[60.2,41.349],[60.455,41.2216],[60.5136,41.2162],[60.7549,41.2458],[60.8672,41.2487],[60.9332,41.229],[61.1199,41.2109],[61.1793,41.1906],[61.2424,41.1892],[61.3289,41.1951],[61.3875,41.2521],[61.4174,41.2651],[61.4437,41.2746],[61.497,41.2761],[61.6445,41.2398],[61.7999,41.1634],[61.9028,41.0937],[61.9535,41.0306],[62.0176,40.8938],[62.095,40.6833],[62.1885,40.5412],[62.298,40.4675],[62.375,40.3321],[62.4416,40.0362],[62.4832,39.9756],[62.5255,39.9441],[62.6507,39.8585],[62.9068,39.7168],[63.0581,39.6332],[63.2919,39.4995],[63.5061,39.3771],[63.7208,39.1881],[63.7637,39.1605],[63.9525,39.0583],[64.1628,38.9536],[64.31,38.9773],[64.5316,38.8162],[64.6219,38.7564],[64.66,38.736],[64.8207,38.6725],[65.0767,38.5395],[65.3996,38.3488],[65.6129,38.2386],[65.6709,38.2257],[65.7285,38.2264],[65.7902,38.25],[65.8571,38.2688],[65.9712,38.2442],[66.0948,38.2001],[66.1731,38.1667],[66.2637,38.1181],[66.3354,38.0722],[66.3897,38.0509],[66.5745,38.0108],[66.6063,37.9867],[66.6264,37.9599],[66.6293,37.932],[66.5256,37.7857],[66.5113,37.5992],[66.5106,37.4587],[66.5223,37.3485],[66.4719,37.3447],[66.3503,37.3682],[66.1084,37.4147],[65.9007,37.5081],[65.765,37.5691],[65.7438,37.5608],[65.683,37.5191],[65.6412,37.4678],[65.608,37.3684],[65.555,37.2512],[65.3036,37.2468],[65.0896,37.2379],[64.9516,37.1936],[64.8163,37.1321],[64.7824,37.0593],[64.7531,36.9648],[64.6743,36.7502],[64.6025,36.5545],[64.5658,36.4276],[64.511,36.3407],[64.358,36.2261],[64.1844,36.1489],[64.0922,36.1127],[64.0514,36.0676],[64.0424,36.0251],[64.0097,36.0121],[63.9381,36.0197],[63.8625,36.0124],[63.6966,35.9678],[63.517,35.9131],[63.3017,35.8584],[63.1789,35.8584],[63.13,35.8462],[63.1086,35.8187],[63.13,35.7667],[63.1508,35.7283],[63.1697,35.6781],[63.1193,35.6375],[63.0842,35.5681],[63.0566,35.4458],[62.9803,35.4092],[62.858,35.3497],[62.7227,35.2713],[62.6881,35.2553],[62.6105,35.2332],[62.5331,35.2399],[62.4629,35.2514],[62.3866,35.2313],[62.3078,35.1708],[62.2712,35.1891],[62.2528,35.2502],[62.2131,35.2899],[62.0896,35.3797],[61.9839,35.4437],[61.9381,35.4479],[61.841,35.4315],[61.7197,35.4194],[61.621,35.4323],[61.5428,35.4579],[61.4218,35.5458],[61.3777,35.5931],[61.3447,35.6295],[61.262,35.6196],[61.2389,35.6593],[61.2355,35.7056],[61.2587,35.7618],[61.2521,35.8676],[61.2059,35.9437],[61.1529,35.9768],[61.1595,35.9999],[61.1826,36.0528],[61.2124,36.0991],[61.212,36.1905],[61.1751,36.2897],[61.1604,36.4327],[61.1699,36.5723],[61.1196,36.6426],[60.7079,36.643],[60.3413,36.6376],[60.3207,36.6536],[60.1783,36.8294],[60.0628,36.9629],[59.9486,37.0416],[59.6872,37.1385],[59.5622,37.1789],[59.455,37.2528],[59.3674,37.3337],[59.3447,37.4447],[59.327,37.4812],[59.3018,37.5106],[59.2741,37.5237],[59.2408,37.5208],[58.9372,37.6497],[58.8154,37.6835],[58.7008,37.6563],[58.6502,37.6516],[58.5505,37.6882],[58.4357,37.6385],[58.3867,37.6354],[58.3182,37.6472],[58.2616,37.6658],[58.1088,37.7831],[57.9806,37.8305],[57.8882,37.8608],[57.7105,37.9053],[57.521,37.9285],[57.4238,37.9477],[57.3537,37.9733],[57.3357,37.9899],[57.3367,38.0329],[57.3314,38.0893],[57.3081,38.1304],[57.2602,38.1796],[57.1936,38.2164],[57.079,38.21],[56.9066,38.213],[56.7746,38.25],[56.6699,38.2566],[56.544,38.2496],[56.4406,38.2494],[56.3669,38.2225],[56.3241,38.1911],[56.297,38.0948],[56.2721,38.0804],[56.2288,38.0734],[56.1712,38.0784],[56.0503,38.0775],[55.8413,38.0946],[55.5784,38.0998],[55.3809,38.0511],[55.2247,37.9813],[55.0756,37.9025],[54.9001,37.7779],[54.8486,37.7227],[54.7452,37.5019],[54.6994,37.4702],[54.6396,37.4447],[54.5789,37.4402],[54.4587,37.4076],[54.2998,37.3536],[54.1916,37.3325],[53.9142,37.3436],[53.8979,37.4136],[53.8479,37.6696],[53.8235,37.9279],[53.8252,38.0469],[53.8541,38.2856],[53.8519,38.4059],[53.84,38.5149],[53.8516,38.6218],[53.8737,38.7419],[53.8854,38.8641],[53.8687,38.9493],[53.8149,39.018],[53.7241,39.1031],[53.7098,39.1534],[53.7046,39.2096],[53.6176,39.216],[53.5395,39.2741],[53.475,39.3057],[53.3363,39.3408],[53.2668,39.3426],[53.2033,39.3168],[53.1566,39.265],[53.124,39.3467],[53.1248,39.4321],[53.2356,39.6085],[53.305,39.5571],[53.3896,39.5364],[53.4974,39.5333],[53.6031,39.547],[53.5824,39.6074],[53.5333,39.6417],[53.4723,39.6688],[53.4505,39.7485],[53.4583,39.8312],[53.4873,39.9094],[53.4543,39.9409],[53.4042,39.9604],[53.2886,39.958],[53.1386,39.9787],[52.9875,39.9876],[52.9521,39.8955],[53.0355,39.7744],[52.9648,39.8339],[52.8982,39.9125],[52.8047,40.054],[52.7444,40.2198],[52.7337,40.3987],[52.7848,40.5467],[52.8499,40.6856],[52.8893,40.8635],[52.9435,41.0381],[52.9977,40.9599],[53.0596,40.8897],[53.1452,40.825],[53.192,40.8095],[53.3329,40.7827],[53.4236,40.7928],[53.5203,40.8311],[53.6152,40.8185],[53.6938,40.7464],[53.7638,40.6657],[53.87,40.6487],[54.0889,40.7071],[54.193,40.7204],[54.2833,40.6937],[54.3299,40.6888],[54.3773,40.6933],[54.3362,40.7649],[54.3194,40.8346],[54.3744,40.8714],[54.5471,40.8323],[54.657,40.8583],[54.6851,40.873],[54.7101,40.8911],[54.7232,40.9513],[54.718,41.013],[54.7037,41.0711],[54.6715,41.1222],[54.5922,41.1936],[54.2846,41.3637],[54.1811,41.4316],[54.0948,41.5194],[54.0398,41.6434],[53.9952,41.7726],[53.9538,41.8685],[53.8465,42.0912],[53.8047,42.1176],[53.7523,42.1294],[53.6249,42.1364],[53.4959,42.1202],[53.285,42.0818],[53.1642,42.0938],[53.1083,42.0701],[52.97,41.9762],[52.9053,41.8958],[52.8148,41.7118],[52.8835,41.6525],[52.8822,41.6137],[52.8302,41.3419],[52.8618,41.2101],[52.8504,41.2003],[52.8256,41.2309],[52.7473,41.3654],[52.6094,41.5294],[52.4938,41.7804],[52.6969,41.9444],[52.8705,42.0606],[53.0125,42.1307],[53.0559,42.1478],[53.2501,42.2059],[53.5008,42.2583],[53.6854,42.2969],[53.9264,42.3298],[54.0052,42.3359],[54.121,42.3352],[54.2149,42.3042],[54.2719,42.28],[54.4729,42.1802],[54.6779,42.0782],[54.8538,41.9652],[54.9037,41.9191],[54.9316,41.864],[54.9523,41.81],[55.1019,41.6387],[55.1623,41.5603],[55.2496,41.4581],[55.3197,41.4084],[55.3884,41.3469],[55.4344,41.2963],[55.487,41.2723],[55.5452,41.2627],[55.6786,41.2788],[55.8391,41.3108],[55.935,41.3241],[55.9774,41.3222],[56.242,41.3108],[56.4799,41.3006],[56.7736,41.288],[56.8608,41.2761],[56.9658,41.2651],[57.018,41.2635],[57.0643,41.3073],[57.0948,41.3313],[57.1188,41.3503],[57.1139,41.3718],[57.0767,41.39],[57.0182,41.4506],[56.9849,41.6693],[56.9641,41.8565],[57.0337,41.9148],[57.1136,41.9571],[57.2288,42.0845],[57.2906,42.1238],[57.3817,42.1563],[57.6861,42.1648],[57.8143,42.1898],[57.856,42.2311],[57.9234,42.3352],[57.9457,42.42],[57.9835,42.4588],[58.0289,42.4876],[58.0755,42.4865],[58.1656,42.4616],[58.2341,42.4477],[58.2829,42.4289],[58.3272,42.3989],[58.3705,42.3468],[58.3771,42.3125],[58.3971,42.2925],[58.4314,42.2921],[58.457,42.2918],[58.4744,42.2994],[58.4858,42.3168],[58.477,42.3401],[58.4182,42.4067],[58.2887,42.5273],[58.2041,42.5764],[58.162,42.603],[58.1516,42.6281],[58.2064,42.6663],[58.2597,42.6881],[58.3531,42.6717],[58.4771,42.6628],[58.5323,42.6819],[58.5891,42.7785],[58.73,42.6762]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":4,"sovereignt":"Turkmenistan","sov_a3":"TKM","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Turkmenistan","adm0_a3":"TKM","geou_dif":0,"geounit":"Turkmenistan","gu_a3":"TKM","su_dif":0,"subunit":"Turkmenistan","su_a3":"TKM","brk_diff":0,"name":"Turkmenistan","name_long":"Turkmenistan","brk_a3":"TKM","brk_name":"Turkmenistan","brk_group":"","abbrev":"Turkm.","postal":"TM","formal_en":"Turkmenistan","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Turkmenistan","name_alt":"","mapcolor7":3,"mapcolor8":2,"mapcolor9":1,"mapcolor13":9,"pop_est":4884887,"gdp_md_est":29780,"pop_year":-99,"lastcensus":1995,"gdp_year":-99,"economy":"6. Developing region","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"TM","iso_a3":"TKM","iso_n3":"795","un_a3":"795","wb_a2":"TM","wb_a3":"TKM","woe_id":-99,"adm0_a3_is":"TKM","adm0_a3_us":"TKM","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Central Asia","region_wb":"Europe & Central Asia","name_len":12,"long_len":12,"abbrev_len":6,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[124.3193,-9.4138],[124.2823,-9.4279],[124.1346,-9.4139],[124.1155,-9.4231],[124.0901,-9.4164],[124.0524,-9.3754],[124.0363,-9.3416],[124.1981,-9.2562],[124.4444,-9.1903],[124.4383,-9.2386],[124.413,-9.3144],[124.3757,-9.3499],[124.3193,-9.4138]],[[127.2961,-8.4245],[127.1146,-8.5836],[126.9152,-8.7152],[126.7925,-8.7551],[126.6654,-8.782],[126.5686,-8.8329],[126.4869,-8.9127],[126.3825,-8.9576],[126.2647,-8.9728],[126.1643,-8.9967],[126.073,-9.0436],[125.9461,-9.1239],[125.8947,-9.1321],[125.8403,-9.1302],[125.7352,-9.1609],[125.408,-9.2758],[125.2103,-9.4035],[125.0682,-9.5119],[125.0336,-9.3818],[124.997,-9.326],[124.9683,-9.2942],[124.9586,-9.2547],[124.9602,-9.2138],[124.9775,-9.1949],[125.1005,-9.1898],[125.1494,-9.1229],[125.149,-9.0426],[125.1244,-9.0154],[125.1004,-9.004],[124.9732,-9.0643],[124.9368,-9.0534],[124.915,-9.0315],[124.9223,-8.9425],[125.027,-8.8591],[125.1157,-8.708],[125.178,-8.6479],[125.3231,-8.5913],[125.3818,-8.5754],[125.8043,-8.4922],[125.9051,-8.4865],[126.1729,-8.489],[126.5311,-8.4708],[126.6197,-8.4595],[126.7346,-8.4228],[126.8457,-8.3773],[126.9047,-8.3416],[126.9664,-8.3157],[127.0585,-8.3482],[127.2148,-8.3729],[127.257,-8.3945],[127.2961,-8.4245]],[[125.6461,-8.1399],[125.5795,-8.3118],[125.5071,-8.2751],[125.5841,-8.1786],[125.6211,-8.15],[125.6461,-8.1399]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"East Timor","sov_a3":"TLS","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"East Timor","adm0_a3":"TLS","geou_dif":0,"geounit":"East Timor","gu_a3":"TLS","su_dif":0,"subunit":"East Timor","su_a3":"TLS","brk_diff":0,"name":"Timor-Leste","name_long":"Timor-Leste","brk_a3":"TLS","brk_name":"Timor-Leste","brk_group":"","abbrev":"T.L.","postal":"TL","formal_en":"Democratic Republic of Timor-Leste","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Timor-Leste","name_alt":"East Timor","mapcolor7":2,"mapcolor8":2,"mapcolor9":4,"mapcolor13":3,"pop_est":1131612,"gdp_md_est":2520,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"7. Least developed region","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"TL","iso_a3":"TLS","iso_n3":"626","un_a3":"626","wb_a2":"TP","wb_a3":"TMP","woe_id":-99,"adm0_a3_is":"TLS","adm0_a3_us":"TLS","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"South-Eastern Asia","region_wb":"East Asia & Pacific","name_len":11,"long_len":11,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[91.6319,27.76],[91.6259,27.7373],[91.5977,27.677],[91.5793,27.6114],[91.5947,27.5577],[91.6581,27.4936],[91.7431,27.4425],[91.8513,27.4386],[91.951,27.4583],[91.9908,27.4502],[92.0449,27.3647],[92.0834,27.2906],[92.0312,27.2143],[92.0025,27.1474],[91.9923,27.0999],[91.9986,27.0793],[92.0309,27.0408],[92.0682,26.9752],[92.0734,26.9148],[92.0497,26.8749],[91.9983,26.855],[91.9438,26.8608],[91.8986,26.8601],[91.8421,26.853],[91.7537,26.8308],[91.6716,26.802],[91.5176,26.8073],[91.4559,26.8669],[91.4268,26.8671],[91.2865,26.7899],[91.1339,26.8034],[90.8558,26.7777],[90.7396,26.7717],[90.6203,26.7802],[90.5599,26.7966],[90.4477,26.8508],[90.3459,26.8903],[90.2424,26.8542],[90.2061,26.8475],[90.1229,26.7546],[89.9432,26.7239],[89.7639,26.7016],[89.7109,26.7139],[89.61,26.7194],[89.6062,26.7411],[89.6092,26.7622],[89.5861,26.779],[89.5451,26.7962],[89.4746,26.8034],[89.3842,26.8266],[89.3321,26.8486],[89.1482,26.8162],[89.0409,26.865],[88.9191,26.9322],[88.8576,26.9615],[88.8352,27.0656],[88.8136,27.099],[88.7656,27.1342],[88.7388,27.1756],[88.7604,27.2181],[88.8816,27.2975],[88.8914,27.3161],[88.9476,27.464],[89.0255,27.5179],[89.1023,27.5926],[89.1604,27.7113],[89.2727,27.8332],[89.3959,27.9582],[89.4807,28.06],[89.5369,28.1074],[89.6527,28.1583],[89.7498,28.1882],[89.8169,28.2563],[89.8979,28.2941],[89.9811,28.3112],[90.1045,28.3021],[90.2208,28.2777],[90.3482,28.2439],[90.363,28.2165],[90.3521,28.1682],[90.3338,28.1191],[90.3331,28.094],[90.3527,28.0802],[90.4773,28.0708],[90.6301,28.0786],[90.7157,28.0717],[90.9066,28.0265],[90.9625,27.9946],[91.0208,27.9701],[91.0777,27.9745],[91.1499,28.0268],[91.2259,28.0712],[91.273,28.0784],[91.3068,28.064],[91.3676,28.0216],[91.4934,27.9818],[91.6056,27.9517],[91.6419,27.9232],[91.6294,27.8009],[91.6319,27.76]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Bhutan","sov_a3":"BTN","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Bhutan","adm0_a3":"BTN","geou_dif":0,"geounit":"Bhutan","gu_a3":"BTN","su_dif":0,"subunit":"Bhutan","su_a3":"BTN","brk_diff":0,"name":"Bhutan","name_long":"Bhutan","brk_a3":"BTN","brk_name":"Bhutan","brk_group":"","abbrev":"Bhutan","postal":"BT","formal_en":"Kingdom of Bhutan","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Bhutan","name_alt":"","mapcolor7":5,"mapcolor8":6,"mapcolor9":1,"mapcolor13":8,"pop_est":691141,"gdp_md_est":3524,"pop_year":-99,"lastcensus":2005,"gdp_year":-99,"economy":"7. Least developed region","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"BT","iso_a3":"BTN","iso_n3":"064","un_a3":"064","wb_a2":"BT","wb_a3":"BTN","woe_id":-99,"adm0_a3_is":"BTN","adm0_a3_us":"BTN","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Southern Asia","region_wb":"South Asia","name_len":6,"long_len":6,"abbrev_len":6,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[115.0268,4.8997],[115.14,4.8998],[115.1685,4.8667],[115.2279,4.7506],[115.2667,4.634],[115.2793,4.4563],[115.3268,4.3808],[115.3192,4.3653],[115.2906,4.3526],[115.2467,4.3472],[115.1706,4.3642],[115.107,4.3904],[115.0516,4.5827],[115.0268,4.6914],[115.0288,4.8211],[115.0268,4.8997]],[[115.0268,4.8997],[114.9447,4.8563],[114.8646,4.8018],[114.7842,4.7548],[114.7467,4.7181],[114.76,4.6665],[114.7793,4.553],[114.7901,4.4639],[114.8183,4.4288],[114.8402,4.3932],[114.8311,4.3545],[114.7835,4.2808],[114.8104,4.2665],[114.7762,4.1688],[114.725,4.0965],[114.6541,4.0376],[114.6083,4.024],[114.5718,4.0491],[114.5122,4.1136],[114.4471,4.2036],[114.4166,4.2559],[114.3229,4.2628],[114.2896,4.3042],[114.2876,4.3547],[114.261,4.4143],[114.2241,4.4779],[114.1688,4.527],[114.0951,4.5652],[114.0639,4.5927],[114.1779,4.591],[114.2994,4.6072],[114.4244,4.6604],[114.5447,4.7246],[114.6459,4.7981],[114.7408,4.881],[114.8406,4.9464],[114.9954,5.0224],[115.0477,5.0164],[115.0471,4.9625],[115.0268,4.8997]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Brunei","sov_a3":"BRN","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Brunei","adm0_a3":"BRN","geou_dif":0,"geounit":"Brunei","gu_a3":"BRN","su_dif":0,"subunit":"Brunei","su_a3":"BRN","brk_diff":0,"name":"Brunei","name_long":"Brunei Darussalam","brk_a3":"BRN","brk_name":"Brunei","brk_group":"","abbrev":"Brunei","postal":"BN","formal_en":"Negara Brunei Darussalam","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Brunei","name_alt":"","mapcolor7":4,"mapcolor8":6,"mapcolor9":6,"mapcolor13":12,"pop_est":388190,"gdp_md_est":20250,"pop_year":-99,"lastcensus":2001,"gdp_year":-99,"economy":"6. Developing region","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"BN","iso_a3":"BRN","iso_n3":"096","un_a3":"096","wb_a2":"BN","wb_a3":"BRN","woe_id":-99,"adm0_a3_is":"BRN","adm0_a3_us":"BRN","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"South-Eastern Asia","region_wb":"East Asia & Pacific","name_len":6,"long_len":17,"abbrev_len":6,"tiny":2,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[16.5162,46.4999],[16.4276,46.5244],[16.3212,46.5346],[16.3012,46.5214],[16.2584,46.5079],[16.2367,46.4838],[16.2533,46.3891],[16.2274,46.3729],[16.1064,46.3822],[16.0665,46.3713],[16.0007,46.3054],[15.9333,46.2776],[15.8476,46.2579],[15.7843,46.234],[15.7042,46.2132],[15.6359,46.2007],[15.609,46.1719],[15.5926,46.14],[15.5969,46.1092],[15.6662,46.0485],[15.6756,45.9837],[15.6681,45.9044],[15.6521,45.8622],[15.6248,45.834],[15.4541,45.7976],[15.2771,45.7326],[15.2729,45.7177],[15.3537,45.6599],[15.3569,45.6455],[15.2901,45.6126],[15.2836,45.5797],[15.2912,45.5416],[15.3267,45.5023],[15.3395,45.467],[15.2421,45.4414],[15.1104,45.4508],[14.9546,45.4999],[14.9,45.4927],[14.8471,45.4673],[14.7931,45.4782],[14.7336,45.5085],[14.6495,45.5715],[14.6086,45.6101],[14.5918,45.6513],[14.5688,45.6572],[14.534,45.6453],[14.5052,45.5952],[14.4273,45.5058],[14.3699,45.4814],[14.283,45.4866],[14.1612,45.4852],[14.0855,45.4778],[13.9928,45.5094],[13.9703,45.5034],[13.9701,45.4826],[13.9356,45.4498],[13.8787,45.4284],[13.6152,45.4768],[13.5779,45.5169],[13.6373,45.5359],[13.7198,45.5876],[13.776,45.582],[13.8447,45.5929],[13.8747,45.6148],[13.8312,45.6804],[13.7217,45.7613],[13.6635,45.792],[13.5834,45.8124],[13.5696,45.8341],[13.614,45.9617],[13.6006,45.9798],[13.5092,45.9738],[13.4877,45.9871],[13.4803,46.0092],[13.4864,46.0396],[13.548,46.0891],[13.6166,46.1331],[13.635,46.1578],[13.6325,46.1771],[13.5447,46.1966],[13.4918,46.2166],[13.4498,46.2235],[13.421,46.2123],[13.3996,46.225],[13.3782,46.2616],[13.3995,46.3175],[13.4785,46.3692],[13.5633,46.4151],[13.6371,46.4485],[13.6797,46.4629],[13.7,46.5203],[13.7439,46.5143],[13.8313,46.5112],[13.9288,46.4982],[14.0196,46.4822],[14.0995,46.4619],[14.2673,46.4407],[14.4199,46.4279],[14.4659,46.4161],[14.5035,46.417],[14.5498,46.3997],[14.5771,46.4129],[14.597,46.4361],[14.6802,46.4634],[14.7567,46.4991],[14.8105,46.5446],[14.8406,46.5805],[14.8933,46.6059],[14.9494,46.6132],[15.0007,46.626],[15.217,46.643],[15.4393,46.6296],[15.5453,46.6546],[15.6326,46.6984],[15.7603,46.7107],[15.7669,46.7113],[15.9576,46.6776],[15.9723,46.6972],[15.9805,46.7059],[15.9769,46.8014],[16.0372,46.8448],[16.0931,46.8633],[16.2836,46.8573],[16.3085,46.828],[16.3185,46.7825],[16.3354,46.7216],[16.3672,46.7048],[16.3846,46.6808],[16.3813,46.6387],[16.4185,46.6072],[16.5057,46.5221],[16.5162,46.4999]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Slovenia","sov_a3":"SVN","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Slovenia","adm0_a3":"SVN","geou_dif":0,"geounit":"Slovenia","gu_a3":"SVN","su_dif":0,"subunit":"Slovenia","su_a3":"SVN","brk_diff":0,"name":"Slovenia","name_long":"Slovenia","brk_a3":"SVN","brk_name":"Slovenia","brk_group":"","abbrev":"Slo.","postal":"SLO","formal_en":"Republic of Slovenia","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Slovenia","name_alt":"","mapcolor7":2,"mapcolor8":3,"mapcolor9":2,"mapcolor13":12,"pop_est":2005692,"gdp_md_est":59340,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"SI","iso_a3":"SVN","iso_n3":"705","un_a3":"705","wb_a2":"SI","wb_a3":"SVN","woe_id":-99,"adm0_a3_is":"SVN","adm0_a3_us":"SVN","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Southern Europe","region_wb":"Europe & Central Asia","name_len":8,"long_len":8,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[16.5285,56.2905],[16.4771,56.2402],[16.4316,56.2437],[16.4013,56.3109],[16.3941,56.4836],[16.4123,56.569],[16.6304,56.8769],[16.7277,56.902],[16.8646,57.0907],[16.9016,57.1746],[16.9609,57.2502],[16.996,57.3178],[17.0254,57.3451],[17.0893,57.3323],[17.1177,57.3198],[17.0504,57.2805],[17.0582,57.2292],[17.0535,57.208],[16.8837,56.9852],[16.8383,56.8405],[16.778,56.8052],[16.5285,56.2905]],[[19.0765,57.8359],[18.9938,57.8121],[18.9451,57.7416],[18.8781,57.7297],[18.8139,57.7062],[18.7909,57.4831],[18.9079,57.3983],[18.8437,57.3865],[18.7849,57.3611],[18.7429,57.3235],[18.6999,57.2427],[18.5385,57.1969],[18.4773,57.163],[18.3872,57.0876],[18.3402,56.9782],[18.2489,56.9315],[18.1464,56.9205],[18.2065,57.0102],[18.2854,57.0832],[18.2096,57.1333],[18.164,57.2117],[18.1051,57.2719],[18.152,57.3391],[18.1289,57.4492],[18.1365,57.5566],[18.2049,57.6109],[18.2832,57.6551],[18.4052,57.7568],[18.5374,57.8306],[18.7219,57.8637],[18.8052,57.8332],[18.8411,57.9002],[18.9006,57.9155],[18.9564,57.9],[19.0765,57.8359]],[[19.1563,57.9226],[19.1384,57.8603],[19.0865,57.865],[19.0393,57.911],[19.1349,57.9813],[19.2812,57.9775],[19.3314,57.9629],[19.1563,57.9226]],[[18.4162,59.0291],[18.3719,59.0196],[18.3499,59.0226],[18.3772,59.069],[18.3976,59.0891],[18.4649,59.1079],[18.4855,59.1046],[18.4162,59.0291]],[[18.5954,59.4704],[18.5703,59.4373],[18.5451,59.4778],[18.5552,59.4858],[18.5724,59.5258],[18.6209,59.5478],[18.6984,59.5346],[18.6979,59.5246],[18.6238,59.4922],[18.5954,59.4704]],[[22.8541,68.3673],[22.9754,68.3165],[23.0979,68.2576],[23.1825,68.1366],[23.3186,68.1303],[23.3555,68.0887],[23.4742,68.0173],[23.6389,67.9544],[23.6329,67.9332],[23.5019,67.8752],[23.4878,67.7966],[23.5002,67.6962],[23.5413,67.6143],[23.537,67.5904],[23.5045,67.5622],[23.4654,67.5179],[23.4515,67.4792],[23.4549,67.4603],[23.4681,67.45],[23.5371,67.4492],[23.6608,67.44],[23.7336,67.4229],[23.7749,67.3286],[23.7609,67.3105],[23.6566,67.2678],[23.6261,67.2339],[23.623,67.1841],[23.6415,67.1294],[23.6773,67.0681],[23.759,67.0026],[23.8693,66.934],[23.9418,66.8778],[23.9761,66.8382],[23.9886,66.8105],[23.9389,66.7757],[23.8941,66.7069],[23.8858,66.628],[23.8655,66.5766],[23.7684,66.5059],[23.7012,66.4808],[23.682,66.4434],[23.6738,66.3807],[23.6936,66.3043],[23.7003,66.2526],[23.721,66.2154],[23.7515,66.1912],[23.9073,66.1482],[23.9946,66.0604],[24.049,65.9898],[24.1555,65.8053],[23.8905,65.7822],[23.6914,65.8285],[23.5921,65.8053],[23.4184,65.8043],[23.2211,65.7861],[23.1546,65.7499],[23.1023,65.7354],[22.9193,65.7865],[22.7466,65.8709],[22.6203,65.8065],[22.5386,65.7943],[22.4651,65.8526],[22.401,65.8621],[22.3663,65.8427],[22.3359,65.7912],[22.2876,65.7506],[22.275,65.725],[22.2666,65.6215],[22.254,65.5976],[22.0862,65.6109],[22.0963,65.5838],[22.1328,65.5701],[22.1476,65.5529],[22.0867,65.5302],[21.9201,65.5324],[21.9031,65.5083],[21.95,65.4704],[21.9135,65.4371],[21.8796,65.424],[21.6807,65.4034],[21.5655,65.4081],[21.5326,65.3866],[21.5234,65.3586],[21.5452,65.3312],[21.596,65.3166],[21.6127,65.2991],[21.6092,65.2614],[21.5669,65.2545],[21.4469,65.3208],[21.4104,65.3174],[21.4378,65.283],[21.5063,65.2454],[21.546,65.207],[21.5807,65.1608],[21.5739,65.1258],[21.4249,65.0127],[21.2938,64.9413],[21.1959,64.8769],[21.1382,64.8087],[21.205,64.7743],[21.2793,64.7247],[21.3315,64.6293],[21.3938,64.5443],[21.5196,64.4631],[21.4943,64.4161],[21.465,64.3796],[21.2558,64.2992],[21.0185,64.178],[20.7627,63.8678],[20.6776,63.8263],[20.4537,63.7737],[20.3714,63.7229],[20.2047,63.6625],[19.9137,63.6105],[19.7816,63.5382],[19.7221,63.4633],[19.6558,63.458],[19.59,63.4873],[19.5023,63.509],[19.4909,63.4602],[19.4946,63.4244],[19.3543,63.4775],[19.2881,63.4288],[19.2363,63.3474],[19.0344,63.2377],[18.8167,63.2575],[18.7923,63.2381],[18.8502,63.2241],[18.859,63.2066],[18.8194,63.1973],[18.7596,63.1982],[18.6672,63.1766],[18.6064,63.1783],[18.5776,63.1264],[18.5307,63.0635],[18.4077,63.0375],[18.3442,63.0321],[18.3129,62.9964],[18.5021,62.9889],[18.4869,62.9586],[18.4826,62.9283],[18.4631,62.8958],[18.248,62.8491],[18.2149,62.8122],[18.17,62.7894],[18.0744,62.7907],[18.0779,62.812],[18.0936,62.836],[17.9511,62.8339],[17.9066,62.8868],[17.8796,62.8732],[17.8956,62.8305],[17.9329,62.7861],[17.9744,62.721],[17.9407,62.6799],[17.903,62.6595],[17.9305,62.6406],[18.0065,62.6263],[18.0373,62.6005],[17.9471,62.5785],[17.8345,62.5027],[17.7178,62.5009],[17.6464,62.4509],[17.5706,62.451],[17.509,62.4825],[17.4103,62.5084],[17.3784,62.4628],[17.3733,62.4265],[17.429,62.3347],[17.5353,62.2637],[17.6337,62.233],[17.5629,62.2123],[17.5102,62.1663],[17.4466,62.0227],[17.412,61.9661],[17.3745,61.8663],[17.3982,61.7821],[17.4173,61.7407],[17.4654,61.6845],[17.3346,61.6917],[17.1964,61.7246],[17.2156,61.6563],[17.1308,61.5757],[17.1466,61.5046],[17.1643,61.4583],[17.138,61.3817],[17.1779,61.3576],[17.1996,61.312],[17.1639,61.2783],[17.1798,61.2493],[17.1857,61.1465],[17.2129,60.9858],[17.2029,60.9519],[17.2789,60.8122],[17.2612,60.7632],[17.251,60.7008],[17.3599,60.6408],[17.457,60.6418],[17.5555,60.6427],[17.5931,60.6277],[17.6308,60.5853],[17.6611,60.5352],[17.7422,60.5393],[17.8716,60.5801],[17.9558,60.5898],[18.0113,60.5114],[18.1625,60.4079],[18.2505,60.3615],[18.4,60.3371],[18.5575,60.2536],[18.5354,60.1529],[18.6012,60.1192],[18.787,60.0795],[18.8527,60.0259],[18.8843,59.9802],[18.9332,59.9423],[18.9904,59.8278],[18.9705,59.7572],[18.8956,59.733],[18.7188,59.6574],[18.6399,59.6009],[18.5781,59.5658],[18.4024,59.4904],[18.3381,59.4769],[18.2765,59.4376],[18.2169,59.4205],[18.1636,59.4304],[17.9643,59.3594],[17.9798,59.3291],[18.1326,59.3162],[18.2105,59.3314],[18.2705,59.3671],[18.336,59.3753],[18.3958,59.3686],[18.4592,59.3967],[18.5089,59.408],[18.5603,59.3945],[18.6176,59.3271],[18.4986,59.2919],[18.4143,59.2903],[18.373,59.1797],[18.322,59.1322],[18.2854,59.1094],[18.0981,59.0623],[17.9746,59.0026],[17.829,58.9546],[17.7654,58.965],[17.6696,58.9162],[17.4567,58.8584],[17.3477,58.7805],[17.1028,58.7108],[16.9781,58.6542],[16.6394,58.6512],[16.3158,58.6636],[16.2143,58.6367],[16.3181,58.6283],[16.3908,58.6019],[16.478,58.6129],[16.683,58.5997],[16.7885,58.5853],[16.9238,58.4926],[16.8243,58.4596],[16.652,58.4343],[16.7166,58.3029],[16.7699,58.2143],[16.7001,58.1608],[16.6949,57.9175],[16.597,57.9129],[16.5554,57.8123],[16.5862,57.7609],[16.5838,57.6417],[16.6042,57.5683],[16.6522,57.5007],[16.6309,57.4302],[16.476,57.2651],[16.4795,57.1877],[16.5073,57.1417],[16.5279,57.0682],[16.4575,56.9268],[16.4078,56.8087],[16.3487,56.7093],[16.2165,56.59],[16.1507,56.5008],[15.9967,56.2226],[15.9203,56.1674],[15.8267,56.125],[15.7223,56.1642],[15.6266,56.1856],[15.5097,56.183],[15.3266,56.1508],[15.0512,56.1722],[14.782,56.1619],[14.714,56.1341],[14.7548,56.0332],[14.6556,56.0199],[14.5586,56.0486],[14.4732,56.0144],[14.402,55.9768],[14.2619,55.8875],[14.215,55.8326],[14.2029,55.7292],[14.2765,55.6364],[14.3417,55.5277],[14.1737,55.3966],[14.08,55.3922],[13.8063,55.4286],[13.3214,55.3464],[12.8858,55.4114],[12.9406,55.4816],[12.9388,55.5332],[12.9634,55.6126],[12.978,55.6938],[12.9739,55.7481],[12.942,55.8061],[12.8346,55.8818],[12.5926,56.1376],[12.521,56.2456],[12.4712,56.2905],[12.507,56.293],[12.7063,56.235],[12.7528,56.2421],[12.8017,56.2639],[12.7422,56.3469],[12.6911,56.3844],[12.6564,56.4406],[12.7731,56.4558],[12.8574,56.4524],[12.9195,56.5156],[12.8837,56.6177],[12.7932,56.6492],[12.7176,56.6628],[12.5727,56.8233],[12.4215,56.9064],[12.1519,57.227],[12.0532,57.447],[11.9615,57.4261],[11.917,57.5219],[11.8851,57.6127],[11.8787,57.6794],[11.735,57.7177],[11.7291,57.7645],[11.7032,57.9732],[11.549,58.0012],[11.4493,58.1184],[11.4315,58.34],[11.33,58.3803],[11.2482,58.3691],[11.2521,58.4241],[11.2716,58.4756],[11.2238,58.6799],[11.2079,58.8664],[11.1691,58.9227],[11.1472,58.9886],[11.1669,59.0456],[11.1958,59.0783],[11.2953,59.0869],[11.3883,59.0365],[11.4707,58.9095],[11.5436,58.893],[11.6428,58.9261],[11.7122,59.0187],[11.7519,59.1576],[11.7981,59.2899],[11.7434,59.4314],[11.6849,59.5558],[11.6808,59.5923],[11.8343,59.6972],[11.8813,59.7825],[11.9321,59.8637],[11.9883,59.8913],[12.0719,59.8976],[12.1692,59.9129],[12.292,59.9672],[12.4021,60.04],[12.4861,60.1068],[12.5146,60.2389],[12.5158,60.3052],[12.5528,60.3545],[12.5887,60.4507],[12.5538,60.5457],[12.4453,60.6896],[12.3146,60.8921],[12.2941,61.0027],[12.3537,61.0232],[12.4676,61.0415],[12.683,61.0468],[12.7061,61.0599],[12.7278,61.1083],[12.7764,61.174],[12.8282,61.2218],[12.8637,61.2903],[12.8808,61.3523],[12.7575,61.4457],[12.5961,61.5413],[12.4868,61.573],[12.2921,61.6535],[12.1554,61.7208],[12.2337,61.9769],[12.292,62.1674],[12.3014,62.2138],[12.3035,62.2856],[12.1146,62.5919],[12.1219,62.66],[12.1398,62.7213],[12.1196,62.8259],[12.1086,62.9195],[12.141,62.9479],[12.2182,63.0006],[12.1446,63.0825],[12.1387,63.0892],[11.9999,63.2917],[12.2121,63.4922],[12.1752,63.5959],[12.302,63.6712],[12.5327,63.8436],[12.6625,63.9405],[12.69,63.9574],[12.7928,64],[12.9876,64.0505],[13.2035,64.0751],[13.2996,64.0748],[13.6707,64.0406],[13.9605,64.014],[14.0027,64.0407],[14.0633,64.0955],[14.1412,64.1735],[14.148,64.2603],[14.1199,64.3877],[14.0776,64.464],[13.8735,64.5136],[13.6503,64.5815],[13.9248,64.7968],[14.1151,64.9461],[14.3524,65.1708],[14.4263,65.2644],[14.4797,65.3015],[14.5495,65.6464],[14.5958,65.7429],[14.6346,65.7933],[14.6352,65.845],[14.61,65.9323],[14.5433,66.1293],[14.918,66.1537],[15.04,66.1675],[15.1533,66.1911],[15.3749,66.2521],[15.4838,66.306],[15.4229,66.4898],[15.557,66.5521],[15.8842,66.7688],[16.2377,66.9764],[16.4035,67.055],[16.4207,67.0934],[16.4343,67.1551],[16.3606,67.252],[16.2815,67.3121],[16.1274,67.4258],[16.1936,67.5052],[16.3071,67.5206],[16.4571,67.5518],[16.5741,67.6196],[16.5855,67.6283],[16.7836,67.895],[17.1705,68.0301],[17.3246,68.1038],[17.5647,68.0484],[17.9167,67.9649],[18.0732,68.0878],[18.125,68.1334],[18.1767,68.2006],[18.156,68.3168],[18.1471,68.4678],[18.1626,68.5284],[18.303,68.5554],[18.3786,68.5624],[18.7698,68.5],[18.8683,68.5011],[19.0526,68.4927],[19.259,68.4653],[19.6912,68.3924],[19.87,68.3623],[19.9698,68.3564],[20.056,68.3904],[20.24,68.4775],[19.9688,68.542],[20.1475,68.6073],[20.24,68.6731],[20.3194,68.7541],[20.348,68.8487],[20.3371,68.8997],[20.2823,68.9343],[20.1167,69.0209],[20.492,69.0333],[20.6222,69.0369],[20.8951,68.9798],[20.907,68.9675],[20.909,68.9377],[20.9186,68.9069],[21.1834,68.8288],[21.2598,68.7875],[21.4224,68.7246],[21.4654,68.6907],[21.616,68.651],[21.724,68.6085],[21.8502,68.5741],[21.9975,68.5206],[22.1951,68.478],[22.3621,68.4641],[22.7824,68.391],[22.8541,68.3673]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Sweden","sov_a3":"SWE","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Sweden","adm0_a3":"SWE","geou_dif":0,"geounit":"Sweden","gu_a3":"SWE","su_dif":0,"subunit":"Sweden","su_a3":"SWE","brk_diff":0,"name":"Sweden","name_long":"Sweden","brk_a3":"SWE","brk_name":"Sweden","brk_group":"","abbrev":"Swe.","postal":"S","formal_en":"Kingdom of Sweden","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Sweden","name_alt":"","mapcolor7":1,"mapcolor8":4,"mapcolor9":2,"mapcolor13":4,"pop_est":9059651,"gdp_md_est":344300,"pop_year":-99,"lastcensus":-99,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"SE","iso_a3":"SWE","iso_n3":"752","un_a3":"752","wb_a2":"SE","wb_a3":"SWE","woe_id":-99,"adm0_a3_is":"SWE","adm0_a3_us":"SWE","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Northern Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":6,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[9.524,47.5242],[9.5544,47.5111],[9.6259,47.467],[9.6091,47.3918],[9.5275,47.2708],[9.4843,47.1727],[9.4795,47.0975],[9.4877,47.0623],[9.5023,47.0627],[9.5803,47.0574],[9.6199,47.0575],[9.745,47.0371],[9.8453,47.0074],[9.8646,46.976],[9.8777,46.9377],[9.9969,46.8854],[10.1335,46.8515],[10.1798,46.8624],[10.3494,46.9848],[10.4149,46.9644],[10.4546,46.8994],[10.4528,46.8649],[10.4061,46.7349],[10.3979,46.665],[10.4383,46.6188],[10.4425,46.5829],[10.4307,46.55],[10.3631,46.5471],[10.2723,46.5648],[10.1955,46.6211],[10.1375,46.6144],[10.087,46.5999],[10.0612,46.5468],[10.0383,46.4832],[10.0456,46.4479],[10.0819,46.4208],[10.1097,46.3628],[10.1299,46.288],[10.1452,46.2535],[10.1283,46.2382],[10.0806,46.228],[10.041,46.2381],[9.9717,46.3277],[9.9393,46.3618],[9.8845,46.3678],[9.7878,46.346],[9.6395,46.2959],[9.5796,46.2961],[9.5287,46.3062],[9.4811,46.3488],[9.4406,46.4308],[9.4276,46.4823],[9.3993,46.4807],[9.3044,46.4956],[9.2602,46.4752],[9.2598,46.3913],[9.2511,46.2868],[9.2034,46.2192],[9.071,46.1024],[9.0224,46.0515],[9.003,46.0149],[8.9989,45.9831],[9.0191,45.9281],[9.0467,45.8756],[9.0237,45.8457],[8.9537,45.83],[8.9043,45.862],[8.8852,45.9187],[8.778,45.9962],[8.8268,46.061],[8.8186,46.0771],[8.6417,46.1108],[8.5654,46.1598],[8.4584,46.2459],[8.4385,46.2829],[8.443,46.4028],[8.4368,46.4319],[8.4226,46.446],[8.3707,46.4451],[8.2985,46.4034],[8.2319,46.3412],[8.0957,46.271],[8.0815,46.256],[8.1272,46.1876],[8.1252,46.1609],[8.0143,46.0519],[7.9932,46.0159],[7.8523,45.9475],[7.7879,45.9218],[7.5926,45.9722],[7.5386,45.9782],[7.4516,45.9444],[7.3279,45.9124],[7.129,45.8804],[7.0558,45.9038],[7.0211,45.9258],[7.0039,45.9588],[6.9537,46.0171],[6.8973,46.0518],[6.858,46.0894],[6.8057,46.1307],[6.7721,46.1651],[6.8168,46.2752],[6.7842,46.314],[6.7674,46.3692],[6.7761,46.4066],[6.7581,46.4158],[6.5782,46.4374],[6.4289,46.4305],[6.3219,46.3937],[6.2347,46.3326],[6.2242,46.3194],[6.2296,46.3084],[6.2729,46.2522],[6.1994,46.1931],[6.0866,46.147],[6.0066,46.1423],[5.9715,46.1512],[5.97,46.2147],[6.0361,46.2381],[6.0959,46.2794],[6.1159,46.3376],[6.1232,46.3786],[6.0603,46.4282],[6.068,46.4585],[6.107,46.5161],[6.1297,46.567],[6.1607,46.611],[6.2852,46.6831],[6.4102,46.7554],[6.429,46.8323],[6.4386,46.9259],[6.4563,46.9483],[6.6248,47.0043],[6.6669,47.0265],[6.6881,47.0583],[6.8207,47.1632],[6.9521,47.2672],[6.9785,47.3021],[7.0006,47.3225],[7.0006,47.3395],[6.9841,47.3525],[6.9215,47.3612],[6.9004,47.3942],[6.9684,47.4532],[7.0534,47.4894],[7.136,47.4898],[7.1692,47.4732],[7.1675,47.4537],[7.2031,47.4327],[7.2657,47.4258],[7.3432,47.4331],[7.42,47.4552],[7.4674,47.5077],[7.4949,47.5474],[7.6156,47.5927],[7.698,47.5699],[7.9271,47.5639],[8.0938,47.5762],[8.1982,47.6069],[8.3278,47.6069],[8.4147,47.5896],[8.4301,47.5921],[8.454,47.5962],[8.4776,47.6127],[8.5595,47.624],[8.5705,47.6378],[8.5671,47.6519],[8.5523,47.6591],[8.4518,47.6518],[8.4133,47.6627],[8.4034,47.6878],[8.4357,47.7313],[8.5099,47.7669],[8.5727,47.7756],[8.6179,47.7661],[8.7283,47.7],[8.7548,47.698],[8.7701,47.7099],[8.7931,47.7166],[8.8312,47.7036],[8.874,47.6627],[8.8812,47.6564],[9.1275,47.6707],[9.1828,47.6707],[9.35,47.5989],[9.524,47.5242]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":4,"sovereignt":"Switzerland","sov_a3":"CHE","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Switzerland","adm0_a3":"CHE","geou_dif":0,"geounit":"Switzerland","gu_a3":"CHE","su_dif":0,"subunit":"Switzerland","su_a3":"CHE","brk_diff":0,"name":"Switzerland","name_long":"Switzerland","brk_a3":"CHE","brk_name":"Switzerland","brk_group":"","abbrev":"Switz.","postal":"CH","formal_en":"Swiss Confederation","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Switzerland","name_alt":"","mapcolor7":5,"mapcolor8":2,"mapcolor9":7,"mapcolor13":3,"pop_est":7604467,"gdp_md_est":316700,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"CH","iso_a3":"CHE","iso_n3":"756","un_a3":"756","wb_a2":"CH","wb_a3":"CHE","woe_id":-99,"adm0_a3_is":"CHE","adm0_a3_us":"CHE","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Western Europe","region_wb":"Europe & Central Asia","name_len":11,"long_len":11,"abbrev_len":6,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[110.8888,19.9919],[110.9383,19.9476],[110.9707,19.8833],[110.9977,19.7647],[111.0137,19.6555],[110.9127,19.5861],[110.8223,19.5579],[110.6409,19.2912],[110.6031,19.207],[110.5722,19.1719],[110.5625,19.1352],[110.566,19.0985],[110.5193,18.9702],[110.4776,18.8126],[110.4513,18.7479],[110.3995,18.6983],[110.3337,18.6733],[110.2908,18.6695],[110.2518,18.6558],[110.1562,18.5698],[110.0485,18.5052],[110.0664,18.4756],[110.0674,18.4476],[110.0202,18.4163],[109.9677,18.4221],[109.8156,18.3967],[109.7598,18.3483],[109.7027,18.2591],[109.6811,18.2471],[109.5896,18.2263],[109.5193,18.2183],[109.4001,18.2811],[109.3409,18.2996],[109.1832,18.3251],[109.0299,18.3678],[108.9223,18.4161],[108.7016,18.5353],[108.6761,18.7502],[108.6381,18.8663],[108.6356,18.9077],[108.65,19.265],[108.6655,19.3041],[108.6936,19.3383],[108.791,19.4182],[108.9028,19.4813],[109.0629,19.6136],[109.1791,19.6741],[109.2767,19.7611],[109.2195,19.7575],[109.1774,19.7685],[109.2189,19.8428],[109.2635,19.8827],[109.3148,19.9044],[109.4182,19.8888],[109.5137,19.9042],[109.5843,19.9703],[109.6514,19.9844],[109.9063,19.9627],[110.083,19.9929],[110.1716,20.0537],[110.2134,20.0561],[110.3439,20.0388],[110.3923,19.9756],[110.388,20.018],[110.3936,20.0592],[110.4176,20.0547],[110.5882,19.9764],[110.5888,20.0725],[110.5983,20.0976],[110.6518,20.1377],[110.6785,20.1371],[110.7445,20.0595],[110.8091,20.0144],[110.8888,19.9919]],[[110.3852,21.0932],[110.4224,21.0586],[110.5216,21.0831],[110.5396,21.039],[110.5389,21.0185],[110.5039,20.9677],[110.4219,21.0069],[110.3399,20.9978],[110.281,21.0012],[110.2646,21.0252],[110.3099,21.0748],[110.3852,21.0932]],[[112.6438,21.6396],[112.5456,21.6185],[112.525,21.623],[112.559,21.6748],[112.6477,21.7103],[112.6438,21.6396]],[[112.7902,21.6019],[112.7711,21.5818],[112.742,21.6181],[112.7335,21.6699],[112.7127,21.6979],[112.7605,21.7333],[112.782,21.7723],[112.8391,21.7645],[112.8626,21.7526],[112.8126,21.7122],[112.8007,21.6949],[112.7902,21.6019]],[[113.5553,22.8042],[113.5637,22.7579],[113.4856,22.8283],[113.4634,22.8324],[113.4261,22.8586],[113.4044,22.9028],[113.4649,22.9045],[113.5205,22.8521],[113.5553,22.8042]],[[118.183,24.4963],[118.1495,24.4361],[118.0905,24.4461],[118.0888,24.4889],[118.0768,24.5014],[118.093,24.5412],[118.1038,24.5523],[118.1707,24.5185],[118.183,24.4963]],[[119.8209,25.457],[119.7467,25.4107],[119.7003,25.4327],[119.6994,25.4947],[119.723,25.5506],[119.696,25.5909],[119.7226,25.6388],[119.7779,25.6532],[119.7975,25.6232],[119.8287,25.6074],[119.8384,25.5911],[119.8387,25.5597],[119.8091,25.5078],[119.8324,25.4796],[119.8209,25.457]],[[121.2514,28.0864],[121.1643,28.0625],[121.1315,28.0626],[121.134,28.1353],[121.2055,28.2044],[121.2344,28.1813],[121.251,28.1452],[121.2514,28.0864]],[[122.1726,29.679],[122.169,29.6603],[122.0838,29.7253],[122.0427,29.7359],[122.0623,29.7728],[122.1196,29.7822],[122.165,29.7008],[122.1726,29.679]],[[122.4039,29.8924],[122.394,29.8461],[122.3676,29.8527],[122.3318,29.935],[122.351,29.9552],[122.4016,29.9502],[122.4039,29.8924]],[[122.2959,29.9634],[122.2815,29.9438],[122.1578,30.0013],[122.024,30.0133],[121.9778,30.0638],[121.9694,30.1431],[122.1105,30.1397],[122.2845,30.068],[122.3223,30.0314],[122.2959,29.9634]],[[121.8627,31.4923],[121.7805,31.4638],[121.5199,31.5496],[121.3364,31.6438],[121.2269,31.7581],[121.2111,31.8054],[121.339,31.7974],[121.4642,31.7564],[121.4918,31.6937],[121.5423,31.6739],[121.5766,31.6373],[121.8083,31.5521],[121.8437,31.5264],[121.8627,31.4923]],[[123.4895,53.5294],[123.5348,53.5265],[123.5598,53.5267],[123.6078,53.5465],[123.7409,53.511],[123.9947,53.4056],[124.1543,53.3587],[124.2199,53.3701],[124.2914,53.3409],[124.3691,53.2709],[124.4659,53.2296],[124.6398,53.2106],[124.8123,53.1338],[124.8821,53.1297],[124.9066,53.1727],[124.9709,53.1973],[125.075,53.2037],[125.2256,53.1658],[125.4225,53.0837],[125.546,53.0476],[125.596,53.0575],[125.649,53.0423],[125.6917,53.0037],[125.6953,52.9563],[125.6808,52.9308],[125.7281,52.8907],[125.7828,52.8907],[125.8719,52.8715],[125.9416,52.8007],[126.0043,52.7679],[126.0481,52.7395],[126.0561,52.7159],[126.0602,52.692],[126.0471,52.6735],[126.0232,52.643],[126.016,52.6102],[126.0459,52.5733],[126.1566,52.5466],[126.1944,52.5191],[126.2029,52.4838],[126.2376,52.4448],[126.3129,52.3998],[126.3417,52.362],[126.3242,52.3316],[126.3463,52.3063],[126.3835,52.2865],[126.3915,52.2145],[126.3948,52.173],[126.4556,52.1265],[126.4681,52.0313],[126.5105,51.9258],[126.6537,51.7813],[126.7008,51.703],[126.6887,51.6099],[126.7092,51.5663],[126.7745,51.5451],[126.8055,51.5057],[126.8018,51.448],[126.8273,51.4123],[126.8478,51.3742],[126.8338,51.3149],[126.8544,51.2614],[126.8877,51.2301],[126.9115,51.1723],[126.9248,51.1001],[127.0204,50.9859],[127.1982,50.8294],[127.307,50.708],[127.3469,50.6213],[127.3472,50.5501],[127.3082,50.4942],[127.3061,50.4535],[127.3408,50.4281],[127.3512,50.3936],[127.3372,50.3501],[127.3953,50.2986],[127.5902,50.209],[127.5123,50.0717],[127.4918,49.975],[127.5024,49.8734],[127.5508,49.8018],[127.6367,49.7602],[127.6901,49.7167],[127.7111,49.6715],[127.8143,49.6221],[127.9996,49.5686],[128.2371,49.5593],[128.5268,49.5942],[128.704,49.6001],[128.769,49.577],[128.791,49.5418],[128.7703,49.4947],[128.8193,49.4638],[128.9383,49.4489],[129.0203,49.4192],[129.0651,49.3747],[129.1201,49.3621],[129.1852,49.3814],[129.2484,49.3787],[129.3099,49.3539],[129.3501,49.3624],[129.3847,49.3895],[129.4407,49.3895],[129.4981,49.3888],[129.5337,49.3234],[129.5914,49.2867],[129.6711,49.2785],[129.7926,49.1989],[130.0371,48.9723],[130.196,48.8917],[130.3553,48.8664],[130.5531,48.8612],[130.6172,48.7732],[130.5656,48.6801],[130.5521,48.6025],[130.5973,48.5747],[130.6592,48.4834],[130.7469,48.4304],[130.7635,48.3884],[130.8043,48.3415],[130.7872,48.2546],[130.7121,48.1276],[130.7326,48.0192],[130.8486,47.9294],[130.9154,47.8429],[130.9328,47.7598],[130.9619,47.7093],[131.0027,47.6915],[131.1219,47.6977],[131.3193,47.7278],[131.4643,47.7226],[131.5567,47.682],[131.7853,47.6805],[132.1498,47.718],[132.3802,47.7295],[132.4763,47.715],[132.5619,47.7685],[132.6369,47.8901],[132.7072,47.9473],[132.7729,47.9401],[132.8771,47.9791],[133.0201,48.0644],[133.144,48.1057],[133.3012,48.1015],[133.4684,48.0972],[133.5732,48.133],[133.6718,48.2077],[133.8422,48.2737],[134.2059,48.3599],[134.2934,48.3734],[134.335,48.3688],[134.4562,48.3553],[134.5636,48.3217],[134.6652,48.2539],[134.6809,48.2104],[134.6693,48.1533],[134.6473,48.1202],[134.6054,48.0829],[134.566,48.0225],[134.5913,47.9752],[134.6503,47.8743],[134.6986,47.8014],[134.7523,47.7154],[134.7281,47.6845],[134.6958,47.6249],[134.5962,47.5239],[134.5419,47.4852],[134.4835,47.4474],[134.3825,47.4382],[134.3395,47.4295],[134.2908,47.4136],[134.2601,47.3777],[134.2252,47.3526],[134.1677,47.3022],[134.163,47.2587],[134.1893,47.1942],[134.2021,47.1281],[134.1369,47.069],[134.0864,46.9781],[134.0714,46.9508],[134.046,46.882],[134.0386,46.8582],[134.0227,46.7132],[133.9575,46.6143],[133.8666,46.4991],[133.8867,46.4306],[133.9027,46.3669],[133.8803,46.336],[133.8748,46.3091],[133.8613,46.2478],[133.8328,46.2243],[133.7502,46.1859],[133.7007,46.1397],[133.7111,46.0696],[133.6857,46.0089],[133.6479,45.9552],[133.608,45.9203],[133.5512,45.8978],[133.5131,45.8788],[133.4847,45.8104],[133.4758,45.7577],[133.4491,45.7051],[133.4656,45.6512],[133.4364,45.6047],[133.3555,45.5722],[133.3096,45.5531],[133.267,45.5453],[133.186,45.4948],[133.1134,45.3214],[133.0969,45.2205],[133.1135,45.1307],[133.0117,45.0746],[132.936,45.0299],[132.8888,45.046],[132.8387,45.0611],[132.7231,45.0806],[132.6656,45.0937],[132.549,45.1228],[132.363,45.16],[132.1813,45.2033],[132.0674,45.226],[131.9775,45.244],[131.9093,45.2737],[131.8519,45.3269],[131.7949,45.3053],[131.7421,45.2426],[131.654,45.2054],[131.614,45.1366],[131.5787,45.0836],[131.4875,45.0131],[131.4469,44.984],[131.2683,44.9361],[131.2279,44.9202],[131.0823,44.91],[131.033,44.8889],[130.9816,44.8443],[130.9678,44.8],[131.0039,44.7532],[131.0606,44.6597],[131.0869,44.5957],[131.1258,44.4692],[131.2553,44.0716],[131.2133,44.0029],[131.1742,43.7047],[131.1836,43.6509],[131.1801,43.5671],[131.1824,43.5056],[131.2092,43.4904],[131.2439,43.469],[131.2618,43.4331],[131.2573,43.3781],[131.2394,43.3376],[131.2119,43.2578],[131.1756,43.1422],[131.1355,43.0976],[131.109,43.0625],[131.0861,43.0381],[131.0835,42.9563],[131.0686,42.9022],[131.0056,42.8831],[130.9429,42.8518],[130.8686,42.8633],[130.8033,42.8568],[130.7225,42.8358],[130.5772,42.8116],[130.493,42.7791],[130.4527,42.7554],[130.4248,42.7271],[130.4199,42.6999],[130.4393,42.6855],[130.5206,42.6743],[130.5766,42.6232],[130.5845,42.5673],[130.527,42.5354],[130.4982,42.5705],[130.4503,42.5817],[130.3607,42.6309],[130.2956,42.685],[130.2467,42.7448],[130.2488,42.8726],[130.2403,42.8918],[130.1513,42.918],[130.1248,42.956],[130.0826,42.9742],[130.0223,42.9626],[129.977,42.9749],[129.9412,42.9957],[129.8982,42.9981],[129.861,42.9651],[129.8415,42.8942],[129.7792,42.7766],[129.7734,42.7055],[129.7465,42.6038],[129.7197,42.475],[129.6979,42.4481],[129.6279,42.4443],[129.6039,42.4359],[129.5676,42.3921],[129.5237,42.3847],[129.4849,42.4103],[129.4236,42.4359],[129.3658,42.4392],[129.3137,42.4136],[129.2525,42.3579],[129.2178,42.3127],[129.2054,42.2706],[129.1955,42.2185],[129.1337,42.1685],[129.0772,42.1424],[128.9606,42.0688],[128.9234,42.0382],[128.8398,42.0378],[128.749,42.0407],[128.6268,42.0208],[128.4272,42.0107],[128.3078,42.0256],[128.1602,42.0116],[128.0452,41.9875],[128.0287,41.9516],[128.0329,41.8985],[128.0561,41.8638],[128.0842,41.8406],[128.1319,41.7691],[128.1817,41.7],[128.2578,41.6554],[128.2893,41.6074],[128.2909,41.5628],[128.2549,41.5065],[128.2003,41.433],[128.1494,41.3877],[128.1112,41.3893],[128.0527,41.4156],[128.0131,41.4487],[127.9187,41.4611],[127.6877,41.44],[127.5722,41.4547],[127.517,41.4817],[127.4203,41.4838],[127.2708,41.5198],[127.1797,41.5313],[127.1367,41.5545],[127.1284,41.6074],[127.0854,41.6438],[127.0613,41.6874],[127.0069,41.742],[126.9548,41.7695],[126.9035,41.7811],[126.8473,41.748],[126.7877,41.7182],[126.7431,41.7249],[126.7216,41.7166],[126.697,41.6919],[126.6013,41.641],[126.5783,41.5943],[126.5401,41.4956],[126.5136,41.394],[126.4904,41.3581],[126.4515,41.3519],[126.4118,41.3213],[126.3287,41.2257],[126.2536,41.1378],[126.1445,41.0783],[126.0932,41.0237],[126.0668,40.9741],[125.9891,40.9046],[125.8749,40.8922],[125.784,40.872],[125.7283,40.8667],[125.6883,40.8387],[125.6592,40.7959],[125.6451,40.779],[125.5938,40.779],[125.5426,40.7426],[125.4169,40.6599],[125.3145,40.6446],[125.1859,40.5894],[125.0729,40.5475],[125.026,40.5239],[125.0134,40.4979],[124.9969,40.4647],[124.9423,40.4582],[124.8894,40.4598],[124.772,40.3837],[124.7124,40.3192],[124.4811,40.1816],[124.3866,40.1042],[124.3621,40.0041],[124.35,40.0116],[124.2675,39.9242],[124.1058,39.841],[123.7602,39.8224],[123.6509,39.8816],[123.6112,39.8408],[123.5807,39.7861],[123.49,39.7679],[123.3481,39.7629],[123.2689,39.7269],[123.2266,39.6866],[123.0322,39.6735],[122.9609,39.6199],[122.84,39.6008],[122.3349,39.3661],[122.225,39.2673],[122.1209,39.1519],[122.0477,39.0938],[121.9823,39.0532],[121.9227,39.0365],[121.8644,38.9965],[121.8052,38.9914],[121.7448,39.0097],[121.6772,39.0034],[121.6328,38.9548],[121.6704,38.8918],[121.6499,38.8651],[121.5172,38.8308],[121.3201,38.8082],[121.2363,38.7669],[121.2074,38.7435],[121.1636,38.7316],[121.1217,38.8133],[121.1067,38.9208],[121.1883,38.9467],[121.2633,38.9603],[121.6799,39.1087],[121.6276,39.2202],[121.6646,39.2688],[121.7578,39.3476],[121.8185,39.3865],[121.7854,39.4008],[121.5125,39.3749],[121.3557,39.3768],[121.2755,39.3848],[121.2998,39.4522],[121.2863,39.5194],[121.2675,39.5447],[121.4064,39.6212],[121.4695,39.6401],[121.5176,39.639],[121.5143,39.6853],[121.4742,39.7549],[121.5174,39.8448],[121.801,39.9505],[121.8689,40.0464],[121.9828,40.1358],[122.1909,40.3583],[122.2033,40.396],[122.2639,40.5002],[122.275,40.5418],[122.1787,40.6027],[122.1404,40.6882],[121.8588,40.8421],[121.8349,40.9743],[121.8086,40.9685],[121.7656,40.8759],[121.7293,40.8461],[121.5989,40.8434],[121.5371,40.8784],[121.1745,40.9013],[121.0859,40.8416],[121.0029,40.7491],[120.9223,40.6831],[120.8413,40.6492],[120.7707,40.5891],[120.4791,40.231],[120.3689,40.2039],[119.8504,39.9875],[119.5911,39.9026],[119.3911,39.7525],[119.3224,39.6616],[119.2613,39.5609],[119.2246,39.4081],[119.0401,39.2224],[118.977,39.1826],[118.9123,39.1664],[118.8265,39.1721],[118.7524,39.1605],[118.6264,39.1769],[118.472,39.118],[118.2979,39.0671],[118.1479,39.1951],[118.0409,39.2268],[117.8657,39.1913],[117.7847,39.1345],[117.6167,38.8529],[117.5538,38.6915],[117.5578,38.6251],[117.6561,38.4242],[117.7667,38.3117],[118.0149,38.1834],[118.5433,38.0949],[118.6671,38.1264],[118.8,38.1267],[118.94,38.0428],[119.0275,37.904],[119.0356,37.8092],[119.0385,37.7765],[119.0703,37.7486],[119.0892,37.7007],[119.0335,37.661],[118.9908,37.6414],[118.9549,37.4941],[118.9526,37.3312],[118.9981,37.2771],[119.1118,37.2012],[119.2874,37.1383],[119.4499,37.1248],[119.7605,37.1551],[119.8875,37.2534],[119.88,37.2958],[119.8829,37.3508],[120.1559,37.495],[120.3115,37.6227],[120.2871,37.6565],[120.2572,37.679],[120.2847,37.6921],[120.3701,37.701],[120.75,37.8339],[121.049,37.7252],[121.2195,37.6001],[121.3881,37.579],[121.5053,37.515],[121.6402,37.4604],[121.8164,37.4566],[121.9648,37.4453],[122.0102,37.4958],[122.0566,37.5289],[122.1096,37.5223],[122.1691,37.4562],[122.3377,37.4053],[122.4933,37.408],[122.6023,37.4264],[122.667,37.4028],[122.5733,37.3179],[122.5873,37.1811],[122.5155,37.1378],[122.4467,37.0681],[122.4874,37.0223],[122.5234,37.0026],[122.5197,36.9468],[122.457,36.9151],[122.3409,36.8322],[122.2742,36.8338],[122.2423,36.8499],[122.2197,36.8795],[122.2032,36.9272],[122.1624,36.9586],[122.0495,36.9708],[121.9327,36.9595],[121.6696,36.8364],[121.4131,36.7384],[121.144,36.6604],[121.0538,36.6114],[120.9899,36.5979],[120.8785,36.6352],[120.8108,36.6328],[120.7967,36.6072],[120.8826,36.5389],[120.905,36.4853],[120.8958,36.4441],[120.8471,36.4261],[120.7762,36.4563],[120.7115,36.4133],[120.6822,36.3407],[120.681,36.1684],[120.6379,36.1299],[120.5193,36.1087],[120.3931,36.0539],[120.3482,36.0792],[120.3303,36.1101],[120.3435,36.1895],[120.3277,36.2282],[120.2701,36.2262],[120.1833,36.2024],[120.117,36.1503],[120.0941,36.1189],[120.1814,36.0175],[120.2647,36.0072],[120.2848,35.9844],[120.219,35.9349],[120.0547,35.8611],[120.0274,35.7994],[119.9787,35.7402],[119.9117,35.6932],[119.8662,35.6437],[119.8105,35.6177],[119.7197,35.5887],[119.6084,35.4699],[119.5265,35.3586],[119.4297,35.3014],[119.3528,35.1138],[119.2158,35.0118],[119.1653,34.8488],[119.201,34.7484],[119.3514,34.7494],[119.4268,34.7142],[119.5829,34.5822],[119.7697,34.4962],[119.9637,34.4478],[120.2015,34.3257],[120.2667,34.274],[120.3227,34.169],[120.4257,33.8663],[120.4998,33.7165],[120.5048,33.6382],[120.6156,33.4905],[120.7345,33.2366],[120.8711,33.0165],[120.8974,32.8432],[120.853,32.7641],[120.8532,32.6614],[120.9899,32.567],[121.2934,32.4573],[121.3417,32.425],[121.401,32.3719],[121.4039,32.2062],[121.4508,32.1533],[121.4905,32.1211],[121.6742,32.051],[121.7511,31.9929],[121.8324,31.8998],[121.8563,31.8165],[121.8663,31.7036],[121.7636,31.6995],[121.6809,31.7122],[121.352,31.8588],[121.2664,31.8627],[121.1458,31.8423],[120.9735,31.8694],[120.7917,32.0317],[120.6605,32.0811],[120.5201,32.1059],[120.1841,31.9662],[120.0987,31.976],[120.0739,31.9603],[120.0359,31.9363],[120.1916,31.9063],[120.3475,31.9521],[120.4972,32.0198],[120.7155,31.9837],[120.7522,31.9229],[120.7878,31.8198],[120.9375,31.7502],[121.0554,31.7194],[121.2049,31.6281],[121.351,31.4854],[121.6606,31.3197],[121.7859,31.1629],[121.8345,31.0616],[121.8779,30.917],[121.7694,30.8704],[121.6752,30.8638],[121.5275,30.841],[121.4189,30.7898],[121.31,30.6997],[120.9977,30.5583],[120.9383,30.4697],[120.8975,30.3926],[120.8215,30.3546],[120.63,30.3909],[120.4498,30.3878],[120.2455,30.2835],[120.1946,30.2413],[120.2285,30.2496],[120.2605,30.263],[120.3525,30.2474],[120.4945,30.3031],[120.6334,30.1332],[120.9045,30.1606],[121.1594,30.3018],[121.258,30.3041],[121.3406,30.2824],[121.4327,30.2267],[121.6779,29.9791],[121.8123,29.9521],[121.9443,29.8941],[122.0173,29.8877],[122.0829,29.8704],[121.9058,29.7797],[121.6766,29.5838],[121.5746,29.537],[121.5063,29.4846],[121.6904,29.511],[121.8219,29.6046],[121.888,29.6278],[121.9412,29.6059],[121.9684,29.4906],[121.9178,29.135],[121.8535,29.1289],[121.7908,29.2257],[121.7175,29.2563],[121.656,29.2361],[121.5337,29.2367],[121.4871,29.1932],[121.4477,29.1313],[121.5209,29.1185],[121.6649,29.0106],[121.6797,28.9531],[121.641,28.9159],[121.54,28.9319],[121.6625,28.8514],[121.6301,28.7679],[121.5903,28.7348],[121.5191,28.7137],[121.4752,28.6414],[121.5381,28.5211],[121.6021,28.3666],[121.61,28.2921],[121.51,28.3243],[121.3546,28.2299],[121.2723,28.2221],[121.2168,28.3462],[121.1457,28.3267],[121.0984,28.2905],[121.0354,28.1573],[120.9586,28.037],[120.8925,28.0039],[120.813,28.0134],[120.7477,28.01],[120.7635,27.9774],[120.833,27.9378],[120.833,27.8915],[120.6852,27.7446],[120.6613,27.6879],[120.6648,27.6395],[120.5875,27.5808],[120.6291,27.4821],[120.6075,27.4124],[120.5398,27.3184],[120.4687,27.2563],[120.3846,27.1555],[120.2787,27.0971],[120.1386,26.8861],[120.0975,26.7807],[120.0867,26.6716],[120.043,26.6338],[119.9678,26.5864],[119.8822,26.6104],[119.8795,26.683],[119.8424,26.6893],[119.8213,26.7369],[119.8151,26.7976],[119.8242,26.8464],[119.7887,26.8315],[119.7667,26.7747],[119.7104,26.7287],[119.6516,26.7473],[119.5882,26.785],[119.5899,26.7305],[119.6236,26.6759],[119.6382,26.6212],[119.726,26.6094],[119.7848,26.5466],[119.8312,26.4502],[119.8403,26.4142],[119.8765,26.3709],[119.8811,26.3342],[119.7973,26.3001],[119.6927,26.2364],[119.5671,26.1273],[119.4631,26.0547],[119.3697,26.0541],[119.3131,26.0625],[119.2321,26.1044],[119.1395,26.1218],[119.2638,25.9748],[119.332,25.9487],[119.4178,25.9543],[119.5009,26.0092],[119.6188,26.0036],[119.6482,25.9187],[119.6169,25.8229],[119.5528,25.6987],[119.5395,25.5913],[119.6191,25.4375],[119.6225,25.3912],[119.5928,25.368],[119.4992,25.4086],[119.4218,25.4596],[119.3437,25.4463],[119.2631,25.468],[119.1801,25.4498],[119.1463,25.4143],[119.1693,25.3557],[119.2436,25.307],[119.2855,25.2322],[119.2355,25.206],[119.0246,25.2234],[118.9775,25.2093],[118.9145,25.1268],[118.9557,25.0048],[118.9091,24.9289],[118.8221,24.9111],[118.7075,24.8498],[118.6369,24.8355],[118.6402,24.8091],[118.6918,24.7823],[118.7191,24.7461],[118.657,24.6214],[118.5604,24.5804],[118.412,24.6007],[118.2953,24.5728],[118.1945,24.6258],[118.0871,24.627],[118.0139,24.5599],[118.006,24.482],[117.9351,24.4742],[117.8969,24.4798],[117.8427,24.4743],[117.8482,24.4325],[117.879,24.3959],[118.0242,24.3796],[118.0506,24.3271],[118.0561,24.2461],[117.9041,24.1064],[117.8395,24.0123],[117.7417,24.0148],[117.6679,23.9393],[117.6282,23.8367],[117.5792,23.857],[117.4664,23.8406],[117.4331,23.7917],[117.4596,23.7715],[117.4622,23.7362],[117.417,23.621],[117.3677,23.5886],[117.3467,23.6357],[117.3308,23.7088],[117.2908,23.7144],[117.225,23.647],[117.1481,23.5988],[117.0825,23.5788],[117.0328,23.6234],[116.9106,23.6467],[116.8609,23.4531],[116.7596,23.3825],[116.7121,23.3605],[116.6294,23.3539],[116.6823,23.3274],[116.6988,23.2778],[116.6691,23.2282],[116.5864,23.2183],[116.5383,23.1797],[116.5198,23.0066],[116.4707,22.9459],[116.3455,22.9411],[116.2519,22.9813],[116.2221,22.9496],[116.2063,22.9187],[116.1574,22.8875],[116.0626,22.8791],[115.8521,22.8016],[115.7559,22.8239],[115.6404,22.8534],[115.5611,22.8247],[115.5347,22.7652],[115.4983,22.7188],[115.3825,22.7188],[115.2899,22.776],[115.1958,22.8173],[115.0915,22.7817],[115.0121,22.7089],[114.9145,22.6846],[114.8964,22.6395],[114.8538,22.6168],[114.7504,22.6263],[114.7111,22.7387],[114.6517,22.7553],[114.5928,22.6984],[114.572,22.6541],[114.5444,22.6206],[114.5542,22.5289],[114.4962,22.5271],[114.4201,22.5833],[114.3406,22.5932],[114.266,22.541],[114.2282,22.554],[114.1882,22.565],[114.1229,22.565],[114.0979,22.5513],[114.0504,22.543],[114.0183,22.5145],[114.0154,22.5119],[113.9312,22.5311],[113.8283,22.6072],[113.7545,22.7336],[113.6611,22.8017],[113.6196,22.8614],[113.6034,22.9689],[113.5863,23.02],[113.5922,23.077],[113.6205,23.1275],[113.5197,23.1021],[113.4453,23.0551],[113.4604,22.9957],[113.4419,22.9406],[113.3311,22.912],[113.3378,22.8888],[113.3448,22.8646],[113.432,22.7894],[113.4498,22.7261],[113.4848,22.6924],[113.553,22.594],[113.5515,22.4042],[113.5889,22.3505],[113.5765,22.2973],[113.5491,22.2252],[113.5468,22.2241],[113.5271,22.2459],[113.4941,22.2416],[113.4811,22.2175],[113.4789,22.1956],[113.4734,22.1944],[113.4157,22.1784],[113.3674,22.1648],[113.3277,22.1454],[113.2664,22.0888],[113.149,22.075],[113.0888,22.208],[113.0082,22.1193],[112.9838,21.9382],[112.9539,21.9073],[112.9038,21.8814],[112.8086,21.9446],[112.7254,21.9023],[112.6607,21.8595],[112.6341,21.8199],[112.5863,21.7769],[112.4947,21.8183],[112.4213,21.8806],[112.4395,21.9273],[112.4293,21.9581],[112.3961,21.9813],[112.3597,21.978],[112.3774,21.9175],[112.3897,21.8012],[112.3564,21.7676],[112.305,21.7417],[112.1934,21.7631],[112.1172,21.8065],[112.0252,21.843],[111.9439,21.8497],[111.9265,21.7763],[111.8734,21.7171],[111.8246,21.7098],[111.776,21.7192],[111.7119,21.6552],[111.6816,21.6085],[111.6027,21.5591],[111.3924,21.5351],[111.3191,21.4861],[111.2206,21.4939],[111.1442,21.4822],[111.1006,21.4847],[111.0611,21.511],[111.0169,21.5117],[110.9968,21.4303],[110.878,21.3959],[110.7711,21.3865],[110.6521,21.2791],[110.5672,21.2141],[110.5043,21.2074],[110.458,21.2306],[110.4346,21.3269],[110.4109,21.3381],[110.3975,21.2477],[110.3746,21.1724],[110.3312,21.1313],[110.1936,21.0376],[110.154,20.9446],[110.1804,20.8586],[110.3654,20.8376],[110.3885,20.7905],[110.3705,20.7521],[110.3262,20.7199],[110.3131,20.6717],[110.5115,20.5183],[110.5176,20.46],[110.4869,20.4269],[110.4495,20.3554],[110.3447,20.2948],[110.1231,20.2637],[109.9385,20.2951],[109.8825,20.3641],[109.8858,20.4131],[109.9316,20.3989],[109.9839,20.4033],[109.9684,20.4481],[109.9464,20.4744],[109.861,20.5143],[109.792,20.6219],[109.8053,20.7115],[109.7674,20.7807],[109.7263,20.8388],[109.6848,20.8736],[109.6626,20.9169],[109.7045,21.0527],[109.6813,21.1316],[109.7602,21.2284],[109.7796,21.3375],[109.9211,21.3765],[109.9308,21.4806],[109.8296,21.4836],[109.7594,21.5601],[109.7434,21.528],[109.6869,21.5246],[109.5943,21.672],[109.5664,21.6906],[109.5215,21.6934],[109.544,21.5379],[109.4355,21.4795],[109.3467,21.454],[109.2204,21.4434],[109.1486,21.4255],[109.0815,21.4403],[109.0981,21.4874],[109.1335,21.5436],[109.1018,21.5905],[109.0306,21.6265],[108.9218,21.6244],[108.8464,21.6345],[108.7717,21.6305],[108.7439,21.6513],[108.6745,21.7247],[108.6158,21.7705],[108.5894,21.816],[108.6158,21.8689],[108.5937,21.901],[108.4799,21.9046],[108.4809,21.8288],[108.4926,21.7394],[108.5257,21.6714],[108.5021,21.6334],[108.4443,21.6073],[108.3828,21.6792],[108.3546,21.6969],[108.3248,21.6935],[108.3021,21.6219],[108.2463,21.5584],[108.1456,21.5652],[108.0674,21.526],[107.9727,21.508],[107.9084,21.5604],[107.8021,21.6452],[107.7593,21.655],[107.641,21.6139],[107.4714,21.5983],[107.4335,21.6423],[107.3512,21.6089],[107.2721,21.7106],[107.1785,21.7171],[107.0616,21.7942],[107.0198,21.8349],[107.0064,21.8934],[106.971,21.9239],[106.9252,21.9201],[106.8745,21.9513],[106.7941,21.982],[106.7295,22.0003],[106.6977,21.9862],[106.6636,21.9789],[106.6577,22.0182],[106.6601,22.1365],[106.6542,22.2415],[106.6365,22.2886],[106.5932,22.3245],[106.5536,22.3417],[106.5363,22.3954],[106.5504,22.5014],[106.5824,22.5732],[106.6331,22.586],[106.7016,22.6377],[106.7363,22.7109],[106.7803,22.7789],[106.624,22.8743],[106.5418,22.9083],[106.4509,22.8939],[106.3381,22.8635],[106.279,22.8575],[106.2494,22.8694],[106.184,22.9551],[106.1484,22.9701],[106.0685,22.9755],[106.001,22.9748],[105.9623,22.9375],[105.9026,22.925],[105.843,22.9228],[105.7823,22.9693],[105.6912,23.0299],[105.5481,23.0727],[105.5309,23.122],[105.4945,23.1809],[105.4401,23.2354],[105.3505,23.3077],[105.2754,23.3452],[105.2388,23.3221],[105.1891,23.2811],[104.9957,23.1943],[104.9102,23.1605],[104.8647,23.1364],[104.8266,23.1002],[104.8147,23.0108],[104.7957,22.9111],[104.74,22.8605],[104.6873,22.8222],[104.6317,22.8182],[104.5775,22.82],[104.5269,22.8041],[104.3718,22.7041],[104.2983,22.712],[104.2383,22.7685],[104.2125,22.8094],[104.1431,22.8001],[104.0539,22.7523],[104.0127,22.6664],[103.9908,22.5861],[103.9714,22.5505],[103.9415,22.5401],[103.915,22.5382],[103.6373,22.77],[103.6202,22.782],[103.5707,22.7344],[103.5254,22.6116],[103.493,22.588],[103.471,22.5974],[103.3561,22.7547],[103.3267,22.7698],[103.3006,22.7644],[103.2663,22.7135],[103.1934,22.6385],[103.1376,22.593],[103.1363,22.5422],[103.0759,22.4975],[103.0054,22.453],[102.9819,22.4482],[102.9352,22.4662],[102.8742,22.5254],[102.8301,22.5872],[102.721,22.6485],[102.5985,22.7004],[102.5172,22.741],[102.4709,22.7509],[102.4279,22.7328],[102.4064,22.708],[102.3758,22.6466],[102.3022,22.546],[102.237,22.466],[102.176,22.4146],[102.1274,22.3792],[102.0915,22.4123],[102.0244,22.4392],[101.9454,22.4394],[101.8418,22.3885],[101.76,22.4903],[101.7388,22.4953],[101.7075,22.4866],[101.6715,22.4623],[101.6462,22.4054],[101.6199,22.3274],[101.5679,22.2764],[101.5245,22.2537],[101.5373,22.2099],[101.5618,22.1624],[101.5603,22.1209],[101.5758,22.0553],[101.6029,21.9897],[101.6996,21.8825],[101.7365,21.8265],[101.7439,21.778],[101.7473,21.6058],[101.7435,21.5338],[101.7242,21.395],[101.7229,21.3149],[101.7631,21.2789],[101.8021,21.236],[101.8006,21.2126],[101.7835,21.2042],[101.7281,21.1564],[101.7048,21.1501],[101.6686,21.1696],[101.6217,21.1844],[101.5839,21.2036],[101.5424,21.2343],[101.4436,21.2308],[101.2814,21.1841],[101.2479,21.1973],[101.2244,21.2237],[101.2118,21.2782],[101.2199,21.3424],[101.2056,21.3833],[101.1754,21.4075],[101.1967,21.5221],[101.1389,21.5675],[101.1473,21.5816],[101.1281,21.7051],[101.1309,21.7355],[101.1207,21.7461],[101.0798,21.7559],[101.0193,21.7364],[100.8352,21.6552],[100.6771,21.5049],[100.6046,21.4718],[100.5313,21.4581],[100.4457,21.4841],[100.3506,21.501],[100.2147,21.463],[100.1477,21.4805],[100.1168,21.5112],[100.0893,21.5579],[100.1058,21.617],[100.0955,21.6606],[100.0412,21.6828],[99.9782,21.7016],[99.9407,21.7587],[99.9256,21.8208],[99.9404,21.9016],[99.9479,21.9883],[99.9177,22.028],[99.8254,22.0497],[99.5927,22.0892],[99.3887,22.1108],[99.3031,22.1006],[99.2334,22.1102],[99.193,22.126],[99.1734,22.1533],[99.1724,22.1925],[99.2054,22.2826],[99.2431,22.3704],[99.3377,22.498],[99.3432,22.5865],[99.3383,22.6887],[99.3852,22.8251],[99.4668,22.9273],[99.5071,22.9591],[99.4973,23.0046],[99.4646,23.0462],[99.4181,23.0692],[99.3408,23.0959],[99.2203,23.1033],[99.0551,23.1306],[98.8638,23.1913],[98.8855,23.3075],[98.8826,23.3803],[98.8589,23.4401],[98.8197,23.4825],[98.7979,23.5204],[98.8322,23.6244],[98.7877,23.7378],[98.7351,23.7831],[98.6809,23.8418],[98.6768,23.9051],[98.7016,23.9641],[98.834,24.0906],[98.8351,24.1212],[98.8023,24.1187],[98.7644,24.1161],[98.5834,24.0698],[98.5642,24.0988],[98.4994,24.1157],[98.3673,24.119],[98.2125,24.1106],[98.0169,24.0654],[97.8377,23.9863],[97.7557,23.9319],[97.686,23.8981],[97.6297,23.8872],[97.5646,23.911],[97.5683,23.9885],[97.6906,24.1308],[97.7082,24.2288],[97.6707,24.3127],[97.6666,24.38],[97.6236,24.4229],[97.5633,24.4438],[97.5314,24.4917],[97.5294,24.6312],[97.5833,24.7748],[97.6707,24.8201],[97.7238,24.842],[97.7379,24.8699],[97.7107,24.9704],[97.7149,25.0343],[97.7674,25.1581],[97.8195,25.2519],[97.918,25.2361],[97.962,25.2593],[98.0107,25.2925],[98.0641,25.349],[98.0996,25.4157],[98.1429,25.5711],[98.1726,25.5945],[98.2966,25.5688],[98.3338,25.5868],[98.4017,25.678],[98.4655,25.7889],[98.5584,25.8232],[98.6254,25.8267],[98.6563,25.8636],[98.6547,25.9178],[98.591,26.0037],[98.5641,26.0724],[98.572,26.1141],[98.6632,26.1395],[98.6855,26.1894],[98.6719,26.2985],[98.7095,26.4297],[98.7318,26.5834],[98.7394,26.6981],[98.7385,26.7857],[98.7295,26.8774],[98.7165,27.0449],[98.6748,27.1906],[98.6824,27.2453],[98.6768,27.4219],[98.6512,27.5725],[98.5998,27.5988],[98.5045,27.6477],[98.4525,27.6572],[98.4089,27.6395],[98.3924,27.5871],[98.3505,27.5381],[98.2988,27.5501],[98.2742,27.5991],[98.241,27.6632],[98.1305,27.9676],[98.1184,28.0552],[98.0989,28.1423],[98.0616,28.1859],[98.0223,28.2115],[97.9341,28.3138],[97.8876,28.3565],[97.8649,28.3636],[97.8165,28.3563],[97.769,28.3562],[97.7301,28.4071],[97.6946,28.4693],[97.6589,28.5],[97.5992,28.517],[97.5379,28.5102],[97.5021,28.4563],[97.4777,28.4256],[97.4314,28.3539],[97.3564,28.2545],[97.3225,28.218],[97.2895,28.2368],[97.1451,28.3403],[97.0754,28.3689],[96.9809,28.3377],[96.833,28.3624],[96.7758,28.367],[96.6528,28.4498],[96.6026,28.4599],[96.4277,28.406],[96.3891,28.3679],[96.3664,28.3673],[96.3198,28.3865],[96.2814,28.4121],[96.2789,28.4282],[96.3262,28.4686],[96.3299,28.4968],[96.3273,28.5254],[96.3956,28.6065],[96.5809,28.7637],[96.55,28.8296],[96.4771,28.9593],[96.4671,29.0223],[96.4357,29.0507],[96.3469,29.0274],[96.1622,28.9097],[96.1371,28.9226],[96.1414,28.9635],[96.1224,29.0821],[96.1809,29.1177],[96.2705,29.1612],[96.3397,29.2098],[96.3559,29.2491],[96.3372,29.261],[96.235,29.2458],[96.1947,29.2725],[96.1285,29.3814],[96.0796,29.4241],[96.0354,29.4472],[95.8851,29.3909],[95.7104,29.3138],[95.5158,29.2063],[95.517,29.1512],[95.4938,29.137],[95.4565,29.1023],[95.4202,29.0543],[95.3893,29.0374],[95.3531,29.0359],[95.2791,29.0496],[95.1447,29.1041],[94.9988,29.1492],[94.9675,29.144],[94.7694,29.1759],[94.7631,29.2013],[94.7334,29.2516],[94.6771,29.297],[94.623,29.3124],[94.4681,29.2162],[94.2933,29.1446],[94.1935,29.0599],[94.1115,28.9759],[94.0177,28.9595],[94.0133,28.9075],[93.9736,28.8608],[93.9022,28.8032],[93.7607,28.7298],[93.6649,28.6902],[93.3605,28.6541],[93.252,28.6295],[93.2065,28.5908],[93.1578,28.4927],[93.1192,28.4023],[93.035,28.3276],[92.8818,28.2281],[92.7019,28.1471],[92.6525,28.0934],[92.6435,28.0615],[92.6656,28.0499],[92.6875,28.0257],[92.6878,27.989],[92.6644,27.9489],[92.5467,27.8792],[92.4807,27.8459],[92.4148,27.8246],[92.341,27.8208],[92.2701,27.8302],[92.2505,27.8415],[92.2223,27.827],[92.1576,27.8123],[92.1013,27.8076],[91.9776,27.7304],[91.9094,27.7297],[91.8247,27.7464],[91.7126,27.7598],[91.6319,27.76],[91.6294,27.8009],[91.6419,27.9232],[91.6056,27.9517],[91.4934,27.9818],[91.3676,28.0216],[91.3068,28.064],[91.273,28.0784],[91.2259,28.0712],[91.1499,28.0268],[91.0777,27.9745],[91.0208,27.9701],[90.9625,27.9946],[90.9066,28.0265],[90.7157,28.0717],[90.6301,28.0786],[90.4773,28.0708],[90.3527,28.0802],[90.3331,28.094],[90.3338,28.1191],[90.3521,28.1682],[90.363,28.2165],[90.3482,28.2439],[90.2208,28.2777],[90.1045,28.3021],[89.9811,28.3112],[89.8979,28.2941],[89.8169,28.2563],[89.7498,28.1882],[89.6527,28.1583],[89.5369,28.1074],[89.4807,28.06],[89.3959,27.9582],[89.2727,27.8332],[89.1604,27.7113],[89.1023,27.5926],[89.0255,27.5179],[88.9476,27.464],[88.8914,27.3161],[88.8325,27.3628],[88.7648,27.4299],[88.749,27.5219],[88.8299,27.7674],[88.8488,27.8687],[88.8286,27.9073],[88.8037,28.0069],[88.7563,28.0397],[88.6211,28.0918],[88.5779,28.0934],[88.5316,28.0574],[88.4861,28.0345],[88.426,28.0117],[88.2752,27.9688],[88.1411,27.9489],[88.109,27.933],[88.0989,27.9045],[88.1098,27.8706],[88.0233,27.8834],[87.9334,27.8908],[87.8607,27.8861],[87.6827,27.8214],[87.6226,27.8152],[87.5553,27.8218],[87.4642,27.8238],[87.2907,27.8219],[87.1414,27.8383],[87.0201,27.9287],[86.9338,27.9685],[86.8424,27.9992],[86.7504,28.0221],[86.7196,28.0707],[86.6905,28.0949],[86.6145,28.103],[86.5545,28.0852],[86.5169,27.9635],[86.485,27.9396],[86.4087,27.9287],[86.3286,27.9595],[86.218,28.0221],[86.1742,28.0917],[86.137,28.1144],[86.0787,28.0836],[86.0755,27.9946],[86.0642,27.9347],[85.9945,27.9104],[85.9541,27.9282],[85.9217,27.9897],[85.8402,28.1354],[85.7595,28.2207],[85.6783,28.2774],[85.4106,28.276],[85.2121,28.2926],[85.1225,28.316],[85.0886,28.3723],[85.1215,28.4843],[85.1602,28.5719],[85.1591,28.5922],[85.1264,28.6026],[85.0691,28.6097],[84.8551,28.5536],[84.7969,28.5602],[84.7594,28.5792],[84.7143,28.5956],[84.6768,28.6215],[84.6506,28.6596],[84.4654,28.7529],[84.4107,28.8039],[84.3121,28.8681],[84.2287,28.9118],[84.1756,29.0364],[84.1278,29.1563],[84.1014,29.22],[84.022,29.2539],[83.9359,29.2795],[83.7904,29.2274],[83.6711,29.1876],[83.5835,29.1836],[83.4566,29.3063],[83.3552,29.4392],[83.2352,29.5546],[83.1555,29.6126],[83.014,29.6181],[82.8543,29.6834],[82.6408,29.8312],[82.4865,29.9415],[82.2207,30.0639],[82.159,30.1152],[82.1354,30.159],[82.0989,30.2451],[82.0434,30.3268],[81.8549,30.3624],[81.6419,30.3875],[81.4172,30.3376],[81.2551,30.0933],[81.1771,30.0399],[81.1104,30.0368],[81.0556,30.099],[81.0103,30.1645],[80.9854,30.2371],[80.8735,30.2906],[80.7468,30.3604],[80.6821,30.4148],[80.6089,30.4489],[80.541,30.4635],[80.4096,30.5095],[80.2609,30.5613],[80.1912,30.5684],[80.1862,30.6053],[80.2071,30.6837],[80.1943,30.7592],[80.1494,30.7898],[80.0814,30.7819],[79.9245,30.8888],[79.9166,30.8942],[79.8719,30.9246],[79.7946,30.9683],[79.6643,30.9652],[79.5654,30.9491],[79.4932,30.9937],[79.3885,31.0642],[79.3696,31.0799],[79.3388,31.1057],[79.2326,31.2417],[79.1071,31.4026],[79.0438,31.4262],[79.0111,31.4141],[78.9739,31.3286],[78.946,31.3372],[78.8995,31.3313],[78.8445,31.3015],[78.7916,31.2937],[78.7578,31.3025],[78.7436,31.3238],[78.7586,31.4366],[78.7268,31.4718],[78.7551,31.5503],[78.8029,31.6181],[78.7539,31.6684],[78.6935,31.7404],[78.687,31.8055],[78.7197,31.8876],[78.7354,31.958],[78.7256,31.9838],[78.6777,32.023],[78.4959,32.2158],[78.4861,32.2362],[78.4553,32.3003],[78.4413,32.3974],[78.4175,32.4667],[78.3896,32.5199],[78.3917,32.5447],[78.4125,32.5577],[78.5264,32.5708],[78.6315,32.579],[78.7009,32.597],[78.7367,32.5584],[78.7535,32.4993],[78.7713,32.4681],[78.8379,32.412],[78.9189,32.3582],[78.9977,32.3651],[79.067,32.3882],[79.1273,32.4758],[79.1699,32.4972],[79.2193,32.5011],[79.219,32.5076],[79.2165,32.564],[79.2339,32.7031],[79.2279,32.7588],[79.2056,32.809],[79.2096,32.8648],[79.2022,32.946],[79.1455,33.0015],[79.1086,33.0227],[79.1028,33.0525],[79.1217,33.1081],[79.1352,33.1719],[79.1156,33.2189],[79.1125,33.2263],[79.0665,33.2504],[79.0126,33.2915],[78.9484,33.3465],[78.9167,33.3868],[78.865,33.4311],[78.8019,33.4997],[78.7899,33.6503],[78.7838,33.8088],[78.7617,33.8876],[78.7267,34.0134],[78.7317,34.0556],[78.753,34.0877],[78.9317,34.189],[78.9706,34.2282],[78.977,34.2581],[78.9701,34.3026],[78.9364,34.352],[78.8648,34.3903],[78.7631,34.4529],[78.6708,34.5182],[78.5157,34.558],[78.327,34.6064],[78.282,34.6539],[78.2361,34.7698],[78.1585,34.9465],[78.0758,35.1349],[78.0122,35.251],[78.0092,35.3069],[78.0475,35.4494],[78.0427,35.4798],[78.0095,35.4902],[77.9459,35.4716],[77.8949,35.449],[77.8516,35.4608],[77.8109,35.4845],[77.8025,35.4928],[77.7994,35.4959],[77.724,35.4806],[77.5726,35.4718],[77.52,35.4734],[77.4465,35.4756],[77.2948,35.5082],[77.09,35.5521],[76.8789,35.6133],[76.7669,35.6617],[76.7275,35.6787],[76.6318,35.7294],[76.5635,35.773],[76.5513,35.8871],[76.5021,35.8782],[76.3857,35.8372],[76.2517,35.8109],[76.1778,35.8105],[76.1479,35.829],[76.1033,35.9492],[76.0709,35.983],[76.0104,35.9963],[75.9451,36.0176],[75.9123,36.049],[75.9049,36.0885],[75.9341,36.1339],[75.9687,36.1688],[75.9744,36.3824],[75.9519,36.4581],[75.933,36.5216],[75.885,36.6007],[75.8402,36.6497],[75.7722,36.6949],[75.6672,36.742],[75.5737,36.7593],[75.4603,36.725],[75.4242,36.7382],[75.3769,36.8837],[75.3467,36.9135],[75.1452,36.9732],[75.0539,36.9872],[74.9491,36.9684],[74.8893,36.9524],[74.8412,36.9791],[74.766,37.0127],[74.6922,37.0357],[74.6006,37.0367],[74.5414,37.0222],[74.5265,37.0307],[74.4979,37.0572],[74.3762,37.1374],[74.3722,37.1577],[74.559,37.2366],[74.6689,37.2667],[74.7267,37.2907],[74.739,37.2856],[74.7674,37.2492],[74.8402,37.225],[74.8913,37.2316],[74.9182,37.25],[75.0084,37.2936],[75.079,37.344],[75.1188,37.3857],[75.0975,37.4513],[74.9864,37.5304],[74.9158,37.5728],[74.8942,37.6014],[74.9123,37.6873],[74.9383,37.7725],[74.9213,37.805],[74.9003,37.8327],[74.8908,37.9258],[74.8425,38.0381],[74.7896,38.1036],[74.7751,38.1919],[74.7721,38.2748],[74.8359,38.4043],[74.8123,38.4603],[74.745,38.51],[74.5141,38.6],[74.2774,38.6598],[74.1873,38.6575],[74.1313,38.6612],[74.0653,38.6085],[74.0256,38.5398],[73.97,38.5337],[73.8691,38.5629],[73.8017,38.6069],[73.7541,38.6989],[73.7168,38.8172],[73.6961,38.8543],[73.7068,38.8862],[73.73,38.9147],[73.7945,38.9413],[73.8053,38.9687],[73.7956,39.0021],[73.7438,39.0445],[73.6904,39.1045],[73.6073,39.2292],[73.6231,39.2979],[73.6363,39.3967],[73.6316,39.4489],[73.7157,39.4623],[73.8229,39.489],[73.8728,39.5333],[73.9071,39.5785],[73.9146,39.6065],[73.8825,39.7146],[73.8397,39.7628],[73.8354,39.8001],[73.8563,39.8287],[73.8846,39.8779],[73.9388,39.9788],[73.9916,40.0431],[74.0205,40.0594],[74.0852,40.0743],[74.2427,40.092],[74.4119,40.1372],[74.6131,40.2722],[74.6799,40.3106],[74.7678,40.3299],[74.8305,40.3285],[74.8418,40.345],[74.8013,40.4285],[74.8111,40.4588],[74.8352,40.4826],[74.8656,40.4935],[75.0045,40.4495],[75.1113,40.4541],[75.241,40.4803],[75.5208,40.6275],[75.5556,40.6252],[75.5835,40.6053],[75.6174,40.5166],[75.656,40.3292],[75.6771,40.3058],[75.872,40.3032],[76.0043,40.3714],[76.0623,40.3875],[76.1566,40.3765],[76.2061,40.4084],[76.2583,40.4308],[76.3186,40.3522],[76.3964,40.3898],[76.4802,40.4495],[76.5209,40.5112],[76.5779,40.5779],[76.6222,40.6624],[76.6398,40.7422],[76.6611,40.7796],[76.7084,40.8181],[76.824,40.9823],[76.9077,41.0242],[76.9866,41.0392],[77.182,41.0107],[77.284,41.0144],[77.5817,40.9928],[77.7193,41.0243],[77.8152,41.0556],[77.9564,41.0507],[78.1234,41.0756],[78.3463,41.2814],[78.3488,41.3252],[78.3624,41.3716],[78.4429,41.4175],[78.5432,41.4596],[78.7426,41.5601],[79.1484,41.7191],[79.2936,41.7828],[79.3544,41.7811],[79.5039,41.821],[79.7661,41.8989],[79.8404,41.9958],[79.9097,42.015],[80.2162,42.0324],[80.2352,42.0435],[80.2462,42.0598],[80.2292,42.1298],[80.2094,42.19],[80.233,42.2078],[80.2591,42.2354],[80.2551,42.2742],[80.2058,42.3994],[80.1793,42.5184],[80.1619,42.6255],[80.165,42.6655],[80.2022,42.7345],[80.2503,42.7973],[80.424,42.8558],[80.539,42.8735],[80.5438,42.9117],[80.4507,42.9355],[80.3834,42.9738],[80.3713,42.9956],[80.3745,43.0204],[80.3902,43.0431],[80.507,43.0858],[80.617,43.1283],[80.7512,43.1025],[80.7777,43.1189],[80.7857,43.1616],[80.757,43.2043],[80.7298,43.2743],[80.6678,43.3101],[80.6654,43.353],[80.7038,43.4271],[80.6508,43.5642],[80.5935,43.6851],[80.496,43.8921],[80.4315,43.9518],[80.3958,44.0472],[80.3553,44.0973],[80.359,44.1713],[80.3653,44.2233],[80.3549,44.3265],[80.3363,44.4384],[80.3551,44.552],[80.391,44.6268],[80.3814,44.6554],[80.4006,44.6769],[80.4555,44.6841],[80.4815,44.7146],[80.4555,44.7461],[80.3608,44.7703],[80.2551,44.8081],[80.1278,44.8038],[79.9972,44.7972],[79.9321,44.8252],[79.8753,44.8608],[79.8719,44.8838],[79.9502,44.9441],[80.0592,45.0064],[80.2282,45.034],[80.4149,45.0751],[80.5092,45.105],[80.6348,45.1265],[80.7801,45.1355],[80.8533,45.1293],[81.0403,45.1691],[81.3348,45.2462],[81.6021,45.3108],[81.692,45.3494],[81.7589,45.3108],[81.7896,45.226],[81.8675,45.1821],[81.9449,45.1608],[81.9893,45.1619],[82.1228,45.1949],[82.2666,45.2191],[82.3234,45.2059],[82.3967,45.1625],[82.4787,45.1236],[82.5215,45.1255],[82.559,45.1554],[82.597,45.216],[82.6211,45.2931],[82.6258,45.3744],[82.6116,45.4243],[82.5825,45.4426],[82.4517,45.472],[82.3267,45.5199],[82.3122,45.5637],[82.3152,45.5949],[82.3481,45.6715],[82.4297,45.8119],[82.5117,46.0058],[82.5551,46.1587],[82.6922,46.3867],[82.8,46.6245],[82.9749,46.966],[83.0041,47.0335],[83.0201,47.1415],[83.0295,47.1859],[83.0903,47.2094],[83.1931,47.1866],[83.4436,47.1086],[83.6341,47.0432],[83.714,47.021],[83.8326,46.9979],[84.016,46.9705],[84.1221,46.9786],[84.2151,46.9947],[84.3389,46.9961],[84.5324,46.9758],[84.5923,46.975],[84.6666,46.9724],[84.7195,46.9394],[84.746,46.8644],[84.7861,46.8307],[84.8582,46.8432],[85.0122,46.9092],[85.1105,46.9612],[85.2335,47.0364],[85.3554,47.0467],[85.4848,47.0635],[85.5297,47.1008],[85.5772,47.1885],[85.6566,47.2546],[85.6698,47.3384],[85.6418,47.3974],[85.5866,47.4937],[85.5883,47.5585],[85.5616,47.7465],[85.526,47.9156],[85.5623,48.0519],[85.6264,48.204],[85.6516,48.2505],[85.6922,48.3118],[85.7494,48.3851],[85.8299,48.4081],[86.0562,48.4237],[86.2656,48.4545],[86.3726,48.4862],[86.4833,48.5054],[86.5494,48.5286],[86.6638,48.6355],[86.718,48.6972],[86.7578,48.8607],[86.7286,48.9394],[86.7531,49.0088],[86.8083,49.0497],[86.8859,49.0906],[86.938,49.0976],[87.0485,49.1099],[87.23,49.1059],[87.3229,49.0858],[87.4167,49.0766],[87.4762,49.0915],[87.5158,49.1224],[87.5766,49.1324],[87.6684,49.1472],[87.7625,49.1658],[87.8143,49.1623],[87.8252,49.1163],[87.8163,49.0803],[87.8347,49.0319],[87.8722,49.0001],[87.8599,48.9655],[87.8068,48.9455],[87.7547,48.9186],[87.7432,48.8816],[87.8092,48.8357],[87.8318,48.7917],[87.9422,48.7653],[88.0279,48.7356],[88.0601,48.7072],[88.0502,48.675],[88.0106,48.6404],[87.9723,48.6033],[87.9674,48.5811],[87.9797,48.5551],[88.0626,48.5378],[88.1582,48.5091],[88.31,48.4721],[88.414,48.4034],[88.5171,48.3845],[88.5668,48.3174],[88.576,48.2202],[88.6818,48.1706],[88.8383,48.1017],[88.9178,48.089],[88.9711,48.05],[89.0477,48.0025],[89.1156,47.9877],[89.1963,47.9809],[89.3299,48.0249],[89.4792,48.0291],[89.5609,48.004],[89.6385,47.9091],[89.6932,47.8792],[89.7256,47.8525],[89.7781,47.827],[89.8313,47.8233],[89.9104,47.8443],[89.9587,47.8863],[90.0279,47.8777],[90.0539,47.8505],[90.0666,47.8036],[90.1032,47.7454],[90.191,47.7021],[90.3133,47.6762],[90.3307,47.6552],[90.3475,47.597],[90.3807,47.5566],[90.4252,47.5041],[90.4675,47.4082],[90.4765,47.3288],[90.4962,47.2852],[90.5529,47.214],[90.6434,47.1003],[90.7155,47.0039],[90.799,46.9852],[90.8699,46.9545],[90.9105,46.8833],[90.9857,46.749],[90.9979,46.6611],[91.0043,46.5958],[91.0289,46.5661],[91.0339,46.529],[90.9715,46.388],[90.9183,46.3243],[90.9115,46.2707],[90.9476,46.1773],[90.9968,46.105],[91.0018,46.0358],[90.9598,45.9851],[90.8871,45.9216],[90.8524,45.8854],[90.7959,45.8535],[90.7097,45.7308],[90.6707,45.5952],[90.6618,45.5252],[90.6944,45.4747],[90.7496,45.4189],[90.7632,45.3707],[90.8532,45.2629],[90.8772,45.1961],[90.914,45.1939],[90.9536,45.2159],[91.05,45.2174],[91.1377,45.1939],[91.2218,45.1445],[91.3121,45.1181],[91.441,45.1248],[91.5101,45.0982],[91.5844,45.0765],[91.7378,45.0689],[91.8528,45.0693],[92.0298,45.0685],[92.1727,45.0353],[92.4238,45.0089],[92.5789,45.011],[92.7879,45.0357],[92.916,45.0202],[93.2943,44.9832],[93.5162,44.9445],[93.6564,44.901],[93.7553,44.8319],[93.8682,44.7242],[93.9579,44.675],[94.1993,44.6452],[94.3647,44.5195],[94.4943,44.4725],[94.712,44.3508],[94.866,44.3033],[95.0498,44.2594],[95.3503,44.2781],[95.3668,44.2615],[95.3437,44.1954],[95.3256,44.1049],[95.3256,44.0394],[95.3564,44.006],[95.4713,43.9862],[95.5256,43.954],[95.5672,43.8922],[95.5912,43.8536],[95.6873,43.6641],[95.842,43.3837],[95.8596,43.276],[95.9125,43.2065],[96.0803,43.0961],[96.1685,43.0145],[96.2995,42.9287],[96.3425,42.8493],[96.3523,42.7468],[96.3854,42.7204],[96.6253,42.7438],[96.833,42.7603],[97.2057,42.7898],[97.7189,42.7363],[98.2482,42.6845],[98.7163,42.6387],[98.9469,42.6162],[99.4679,42.5682],[99.7574,42.6294],[99.9838,42.6773],[100.0863,42.6708],[100.519,42.6168],[100.7726,42.5878],[101.092,42.5513],[101.3138,42.5379],[101.4953,42.5388],[101.5791,42.5235],[101.66,42.5],[101.7139,42.4658],[101.8799,42.2923],[101.9729,42.2159],[102.1566,42.1581],[102.5752,42.0921],[102.8068,42.052],[103.0729,42.006],[103.2479,41.9366],[103.4497,41.8559],[103.7111,41.7513],[103.9973,41.797],[104.3052,41.8461],[104.4982,41.877],[104.4982,41.6587],[104.7736,41.6412],[104.8604,41.6437],[104.982,41.5955],[105.0506,41.6159],[105.1154,41.6633],[105.1971,41.738],[105.3144,41.7709],[105.5171,41.8547],[105.5664,41.8751],[105.8676,41.994],[106.3172,42.1406],[106.5188,42.2116],[106.5791,42.2273],[106.6932,42.2636],[106.77,42.2887],[106.9061,42.3089],[107.0907,42.3215],[107.2924,42.3493],[107.7487,42.401],[107.806,42.4059],[108.0623,42.4272],[108.1712,42.4473],[108.334,42.4368],[108.5465,42.4293],[108.6873,42.4161],[108.8745,42.4265],[109.1316,42.4406],[109.3398,42.4384],[109.4432,42.456],[109.5955,42.5105],[109.698,42.5538],[109.8588,42.6062],[110.058,42.6606],[110.1969,42.71],[110.2889,42.7427],[110.4004,42.7737],[110.4296,42.8136],[110.4617,42.8441],[110.5209,42.8953],[110.6275,42.9905],[110.7086,43.0739],[110.7485,43.1108],[110.8396,43.1941],[110.9133,43.2569],[111.0072,43.3414],[111.0865,43.3688],[111.1868,43.392],[111.4511,43.4749],[111.5035,43.4928],[111.5474,43.4963],[111.6408,43.5632],[111.7197,43.6211],[111.7711,43.6646],[111.8781,43.6802],[111.9332,43.7114],[111.9429,43.7524],[111.9317,43.8149],[111.8803,43.8789],[111.8369,43.9347],[111.6838,44.0411],[111.6026,44.1071],[111.5197,44.1919],[111.4862,44.2716],[111.4296,44.3224],[111.4022,44.3673],[111.4109,44.4192],[111.4895,44.5116],[111.5147,44.5698],[111.5475,44.6729],[111.6213,44.8271],[111.6814,44.8992],[111.7511,44.9695],[111.898,45.0641],[112.0326,45.0816],[112.1129,45.0629],[112.2921,45.063],[112.4113,45.0582],[112.4993,45.0109],[112.5968,44.9177],[112.7067,44.8834],[113.0494,44.8104],[113.1961,44.7948],[113.301,44.7917],[113.4557,44.7674],[113.5079,44.7624],[113.587,44.7457],[113.6526,44.7635],[113.7521,44.8259],[113.8771,44.8962],[113.9309,44.9123],[114.0303,44.9426],[114.0803,44.9711],[114.1674,45.0499],[114.2811,45.1109],[114.4191,45.2026],[114.4873,45.2717],[114.5022,45.3163],[114.5172,45.3646],[114.5602,45.39],[114.6443,45.4133],[114.7388,45.4196],[114.9192,45.3783],[115.1626,45.3902],[115.2175,45.3962],[115.4395,45.42],[115.5395,45.4395],[115.6811,45.4583],[115.7892,45.5348],[115.9342,45.6262],[116.0396,45.677],[116.1099,45.6867],[116.1977,45.7394],[116.2406,45.796],[116.2291,45.8458],[116.213,45.8869],[116.2646,45.963],[116.3576,46.0966],[116.4448,46.1588],[116.5167,46.2091],[116.5626,46.2898],[116.6193,46.3131],[116.6889,46.322],[116.787,46.3767],[116.8591,46.3879],[116.9788,46.3618],[117.156,46.3551],[117.269,46.3522],[117.3334,46.362],[117.3569,46.3913],[117.3563,46.4367],[117.3922,46.5376],[117.4056,46.5709],[117.4381,46.5862],[117.5469,46.5883],[117.6205,46.552],[117.6711,46.5221],[117.7412,46.5182],[117.8135,46.5377],[117.9104,46.6193],[118.0713,46.6666],[118.1568,46.6786],[118.3087,46.717],[118.4044,46.7032],[118.5805,46.6919],[118.6487,46.7017],[118.7229,46.6919],[118.7903,46.7471],[118.8439,46.7602],[118.9571,46.7349],[119.0285,46.6922],[119.1621,46.6387],[119.3318,46.6138],[119.474,46.6267],[119.6202,46.604],[119.7066,46.606],[119.7475,46.6272],[119.8672,46.6722],[119.8959,46.7329],[119.8842,46.7915],[119.8979,46.8578],[119.8627,46.9066],[119.7885,46.9788],[119.7599,47.027],[119.7572,47.09],[119.7111,47.15],[119.6002,47.2225],[119.527,47.2559],[119.3767,47.3809],[119.326,47.4102],[119.3086,47.4307],[119.2908,47.4727],[119.2353,47.4926],[119.1624,47.5252],[119.1229,47.5585],[119.0973,47.6163],[119.0819,47.6542],[119.0176,47.6854],[118.9531,47.7029],[118.8803,47.7251],[118.76,47.7576],[118.6905,47.8223],[118.5678,47.9433],[118.4984,47.984],[118.2396,47.9995],[118.1471,48.0289],[118.0419,48.0189],[117.9792,47.9996],[117.8404,47.9999],[117.7684,47.9879],[117.6767,47.9083],[117.5554,47.8047],[117.4551,47.7414],[117.384,47.6757],[117.3508,47.6522],[117.2859,47.6664],[117.1971,47.7403],[117.0697,47.8064],[116.9517,47.8366],[116.9012,47.8531],[116.7605,47.8698],[116.652,47.8645],[116.5135,47.8396],[116.3782,47.844],[116.3172,47.8599],[116.2312,47.8582],[116.0748,47.7896],[115.9938,47.7113],[115.8982,47.6869],[115.8117,47.7382],[115.7117,47.7989],[115.6164,47.8748],[115.5576,47.945],[115.5251,48.1309],[115.6395,48.1862],[115.7855,48.2482],[115.7966,48.3463],[115.7917,48.4557],[115.8205,48.5772],[115.9538,48.6894],[116.0255,48.7823],[116.0344,48.84],[116.0982,48.9361],[116.1597,49.0375],[116.2434,49.1704],[116.4021,49.4062],[116.5897,49.6848],[116.6833,49.8238],[116.889,49.7378],[117.0217,49.693],[117.2456,49.6249],[117.4771,49.6094],[117.6984,49.5358],[117.8126,49.5135],[117.8734,49.5135],[118.1866,49.6928],[118.4516,49.8445],[118.756,49.9628],[118.9795,49.9789],[119.1475,50.0134],[119.2599,50.0664],[119.3261,50.1549],[119.3463,50.279],[119.3016,50.3539],[119.1919,50.3798],[119.1637,50.406],[119.2167,50.4325],[119.2559,50.4842],[119.2807,50.561],[119.344,50.6339],[119.4457,50.7028],[119.5018,50.7792],[119.5123,50.8631],[119.5734,50.9468],[119.685,51.0301],[119.746,51.1077],[119.7566,51.1795],[119.8132,51.267],[119.967,51.4221],[120.0669,51.6007],[120.237,51.723],[120.5105,51.8485],[120.6814,51.973],[120.7498,52.0965],[120.7445,52.2055],[120.6654,52.2999],[120.6504,52.3959],[120.6992,52.4936],[120.6562,52.5667],[120.5211,52.615],[120.3601,52.627],[120.1728,52.6025],[120.0676,52.6329],[120.0443,52.7182],[120.0945,52.7872],[120.2182,52.8399],[120.4213,52.9681],[120.7041,53.1718],[120.9854,53.2846],[121.4055,53.317],[121.7439,53.3836],[122.0889,53.4515],[122.3378,53.485],[122.3802,53.4625],[122.5158,53.457],[122.7447,53.4685],[122.9576,53.4977],[123.1541,53.5446],[123.3096,53.5556],[123.424,53.5308],[123.4895,53.5294]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"China","sov_a3":"CH1","adm0_dif":1,"level":2,"type":"Country","admin":"China","adm0_a3":"CHN","geou_dif":0,"geounit":"China","gu_a3":"CHN","su_dif":0,"subunit":"China","su_a3":"CHN","brk_diff":0,"name":"China","name_long":"China","brk_a3":"CHN","brk_name":"China","brk_group":"","abbrev":"China","postal":"CN","formal_en":"People's Republic of China","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"China","name_alt":"","mapcolor7":4,"mapcolor8":4,"mapcolor9":4,"mapcolor13":3,"pop_est":1338612970,"gdp_md_est":7973000,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"3. Emerging region: BRIC","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"CN","iso_a3":"CHN","iso_n3":"156","un_a3":"156","wb_a2":"CN","wb_a3":"CHN","woe_id":-99,"adm0_a3_is":"CHN","adm0_a3_us":"CHN","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Eastern Asia","region_wb":"East Asia & Pacific","name_len":5,"long_len":5,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[42.359,37.1086],[42.3591,37.095],[42.3501,37.0606],[42.2373,36.9611],[42.084,36.826],[41.974,36.7408],[41.7886,36.5972],[41.6502,36.5664],[41.4168,36.5146],[41.3542,36.4644],[41.296,36.3833],[41.2618,36.2725],[41.2518,36.203],[41.2456,36.0734],[41.3002,35.939],[41.3526,35.81],[41.3594,35.7246],[41.3541,35.6404],[41.3033,35.5506],[41.2483,35.4275],[41.2164,35.2882],[41.1996,35.0274],[41.1992,34.8053],[41.1947,34.769],[41.099,34.6123],[40.987,34.4291],[40.9351,34.3866],[40.6895,34.332],[40.4215,34.1978],[40.122,34.0477],[39.85,33.9114],[39.5645,33.7684],[39.2684,33.62],[39.0567,33.514],[38.7735,33.3722],[38.5156,33.2366],[38.2543,33.0992],[38.0558,32.9949],[37.7541,32.8298],[37.5774,32.7331],[37.3176,32.5908],[37.089,32.4655],[36.8184,32.3173],[36.4792,32.3613],[36.3721,32.3869],[36.2843,32.4575],[36.2197,32.4951],[36.0595,32.5338],[35.9564,32.6667],[35.8947,32.7138],[35.7873,32.7349],[35.8015,32.7823],[35.8568,32.8624],[35.9135,32.9496],[35.882,32.9981],[35.8718,33.0394],[35.8681,33.0886],[35.9066,33.1357],[35.8885,33.1925],[35.8588,33.2496],[35.837,33.2782],[35.8371,33.3305],[35.8516,33.3705],[35.8691,33.4317],[35.9147,33.4654],[35.9266,33.5003],[35.9676,33.5346],[36.0223,33.5625],[36.0345,33.5851],[36.0267,33.5979],[35.9717,33.6231],[35.9424,33.6676],[35.9685,33.7324],[35.9861,33.7526],[36.0188,33.7839],[36.0922,33.8316],[36.1498,33.8395],[36.1994,33.8396],[36.2834,33.8356],[36.3485,33.8271],[36.365,33.8394],[36.3628,33.8551],[36.2822,33.8942],[36.2778,33.9253],[36.2979,33.9586],[36.3549,34.0113],[36.4229,34.0499],[36.4575,34.0568],[36.5352,34.1343],[36.585,34.2212],[36.5044,34.4324],[36.4556,34.4662],[36.3765,34.4952],[36.3299,34.4996],[36.3263,34.5133],[36.3887,34.5669],[36.433,34.6135],[36.3839,34.6579],[36.2963,34.6787],[36.2636,34.6329],[36.1511,34.6286],[35.9763,34.6292],[35.8993,34.8521],[35.8879,34.9486],[35.8899,35.0603],[35.9431,35.2238],[35.9181,35.2995],[35.916,35.3505],[35.9024,35.4207],[35.7645,35.5716],[35.8396,35.8492],[35.8927,35.9166],[35.9676,35.9101],[36.1273,35.8314],[36.1536,35.8339],[36.202,35.9375],[36.2488,35.9727],[36.3476,36.0035],[36.3754,36.1712],[36.4215,36.2035],[36.4771,36.2207],[36.5624,36.2239],[36.6367,36.234],[36.6414,36.2635],[36.5375,36.4574],[36.5467,36.5063],[36.5969,36.7014],[36.6284,36.7777],[36.6586,36.8025],[36.7766,36.7927],[36.9418,36.7584],[36.9854,36.7024],[37.0662,36.6526],[37.1874,36.6559],[37.3271,36.6466],[37.4363,36.6433],[37.5235,36.6783],[37.7203,36.7437],[37.818,36.7656],[37.9066,36.7946],[38.1917,36.9016],[38.3059,36.8934],[38.384,36.8792],[38.4438,36.8623],[38.578,36.7891],[38.6889,36.7151],[38.7666,36.6931],[38.9064,36.6947],[39.1084,36.6806],[39.3566,36.6816],[39.5015,36.7022],[39.6865,36.7386],[40.0164,36.8261],[40.4504,37.0089],[40.7057,37.0977],[40.8156,37.1082],[40.9589,37.1092],[41.1021,37.0859],[41.2646,37.0693],[41.3396,37.0708],[41.5155,37.0892],[41.7436,37.1261],[41.8868,37.1564],[42.0599,37.2061],[42.1679,37.2886],[42.2027,37.2973],[42.2476,37.2822],[42.2686,37.2766],[42.3129,37.2296],[42.359,37.1086]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Syria","sov_a3":"SYR","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Syria","adm0_a3":"SYR","geou_dif":0,"geounit":"Syria","gu_a3":"SYR","su_dif":0,"subunit":"Syria","su_a3":"SYR","brk_diff":0,"name":"Syria","name_long":"Syria","brk_a3":"SYR","brk_name":"Syria","brk_group":"","abbrev":"Syria","postal":"SYR","formal_en":"Syrian Arab Republic","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Syrian Arab Republic","name_alt":"","mapcolor7":2,"mapcolor8":6,"mapcolor9":2,"mapcolor13":6,"pop_est":20178485,"gdp_md_est":98830,"pop_year":-99,"lastcensus":2004,"gdp_year":-99,"economy":"6. Developing region","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"SY","iso_a3":"SYR","iso_n3":"760","un_a3":"760","wb_a2":"SY","wb_a3":"SYR","woe_id":-99,"adm0_a3_is":"SYR","adm0_a3_us":"SYR","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Western Asia","region_wb":"Middle East & North Africa","name_len":5,"long_len":5,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[114.232,22.2105],[114.2072,22.1952],[114.1388,22.2684],[114.1345,22.2922],[114.1874,22.2966],[114.2469,22.2636],[114.2436,22.2335],[114.232,22.2105]],[[113.9978,22.2105],[113.8773,22.2104],[113.8516,22.2205],[113.8389,22.2417],[113.8815,22.2803],[114.0439,22.3334],[114.0033,22.2775],[113.9978,22.2105]],[[114.3353,22.3962],[114.2905,22.3738],[114.2879,22.3253],[114.268,22.2956],[114.1391,22.3484],[114.0328,22.3759],[113.9373,22.365],[113.9025,22.3961],[113.8965,22.4282],[114.0067,22.484],[114.0154,22.5119],[114.0183,22.5145],[114.0504,22.543],[114.0979,22.5513],[114.1229,22.565],[114.1882,22.565],[114.2282,22.554],[114.266,22.541],[114.2696,22.5368],[114.2911,22.4995],[114.2846,22.4576],[114.3252,22.4374],[114.3353,22.3962]]]},"properties":{"scalerank":3,"featurecla":"Admin-0 country","labelrank":4,"sovereignt":"China","sov_a3":"CH1","adm0_dif":1,"level":2,"type":"Country","admin":"Hong Kong S.A.R.","adm0_a3":"HKG","geou_dif":0,"geounit":"Hong Kong S.A.R.","gu_a3":"HKG","su_dif":0,"subunit":"Hong Kong S.A.R.","su_a3":"HKG","brk_diff":0,"name":"Hong Kong","name_long":"Hong Kong","brk_a3":"HKG","brk_name":"Hong Kong","brk_group":"","abbrev":"H.K.","postal":"HK","formal_en":"Hong Kong Special Administrative Region, PRC","formal_fr":"","note_adm0":"China","note_brk":"","name_sort":"Hong Kong SAR, China","name_alt":"","mapcolor7":4,"mapcolor8":4,"mapcolor9":4,"mapcolor13":3,"pop_est":7061200,"gdp_md_est":351119,"pop_year":2010,"lastcensus":2006,"gdp_year":2011,"economy":"6. Developing region","income_grp":"2. High income: nonOECD","wikipedia":0,"fips_10":"","iso_a2":"HK","iso_a3":"HKG","iso_n3":"344","un_a3":"344","wb_a2":"HK","wb_a3":"HKG","woe_id":-99,"adm0_a3_is":"HKG","adm0_a3_us":"HKG","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Eastern Asia","region_wb":"East Asia & Pacific","name_len":9,"long_len":9,"abbrev_len":4,"tiny":-99,"homepart":-99}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[23.8522,35.5354],[23.9206,35.5282],[24.0133,35.5294],[24.0344,35.5354],[24.0934,35.5938],[24.166,35.5952],[24.1978,35.5375],[24.124,35.5108],[24.109,35.4958],[24.1231,35.4836],[24.1785,35.4595],[24.2554,35.4686],[24.2577,35.4231],[24.2749,35.386],[24.3129,35.3638],[24.354,35.3595],[24.4449,35.366],[24.5346,35.3808],[24.627,35.4099],[24.7213,35.4248],[25.0031,35.4099],[25.1043,35.3469],[25.2968,35.3394],[25.4757,35.3062],[25.5696,35.3281],[25.7302,35.3486],[25.7559,35.3264],[25.7352,35.184],[25.745,35.1427],[25.7913,35.1229],[25.8371,35.1326],[25.8934,35.1792],[26.028,35.2153],[26.1679,35.2151],[26.2855,35.3098],[26.3202,35.3151],[26.2986,35.2686],[26.2809,35.1592],[26.2556,35.0952],[26.2443,35.0447],[26.1656,35.0186],[26.0467,35.0142],[25.8297,35.0252],[25.6109,35.0073],[25.2058,34.9593],[24.7998,34.9345],[24.7452,34.9506],[24.7439,35.0144],[24.7352,35.0583],[24.7089,35.0891],[24.5834,35.1153],[24.4637,35.1604],[23.9943,35.2219],[23.8836,35.2461],[23.7039,35.2335],[23.6381,35.2352],[23.5928,35.2572],[23.5616,35.2952],[23.5476,35.4156],[23.5698,35.5348],[23.6087,35.5663],[23.6266,35.5304],[23.6727,35.5139],[23.7154,35.5501],[23.715,35.6047],[23.7369,35.6555],[23.7708,35.6342],[23.7934,35.5562],[23.8522,35.5354]],[[27.1761,35.4653],[27.1379,35.4091],[27.0991,35.4564],[27.1158,35.5111],[27.0707,35.5978],[27.1561,35.7263],[27.158,35.7887],[27.2231,35.8205],[27.207,35.7145],[27.1572,35.6295],[27.2089,35.5589],[27.2336,35.4786],[27.1761,35.4653]],[[23.0538,36.1898],[23.0422,36.1464],[22.9395,36.1762],[22.9108,36.221],[22.9057,36.3203],[22.9326,36.3688],[22.9505,36.3839],[22.9979,36.3281],[23.0971,36.2466],[23.0538,36.1898]],[[27.8428,35.9293],[27.7706,35.9083],[27.7457,35.911],[27.7155,35.9573],[27.7573,36.0692],[27.7187,36.1411],[27.7163,36.1716],[27.7744,36.2138],[27.8152,36.277],[27.9145,36.3453],[28.1715,36.4262],[28.2318,36.4336],[28.2301,36.3703],[28.144,36.2099],[28.0677,36.1297],[28.0878,36.0653],[27.9655,36.0475],[27.8428,35.9293]],[[25.4824,36.3926],[25.4359,36.3401],[25.3705,36.3589],[25.3972,36.379],[25.4129,36.4049],[25.4146,36.4423],[25.3969,36.4653],[25.409,36.4737],[25.4674,36.4351],[25.4824,36.3926]],[[26.4606,36.5854],[26.3816,36.5615],[26.3314,36.5114],[26.27,36.5469],[26.2698,36.5954],[26.337,36.5806],[26.3842,36.6079],[26.37,36.6386],[26.4213,36.6242],[26.4606,36.5854]],[[27.8602,36.5539],[27.8383,36.538],[27.7881,36.5837],[27.7857,36.6075],[27.8368,36.6349],[27.8625,36.6412],[27.8698,36.6225],[27.869,36.5827],[27.8602,36.5539]],[[24.5357,36.7638],[24.5375,36.705],[24.5307,36.684],[24.326,36.6556],[24.3449,36.723],[24.3574,36.7443],[24.4252,36.7129],[24.4502,36.729],[24.4604,36.7475],[24.5357,36.7638]],[[25.3817,36.674],[25.3644,36.6583],[25.2887,36.7215],[25.26,36.7584],[25.2959,36.7892],[25.4069,36.7173],[25.3817,36.674]],[[26.9496,36.7271],[26.9184,36.7259],[26.9556,36.7742],[27.0611,36.8404],[27.2149,36.8986],[27.2656,36.9051],[27.3521,36.8689],[27.1932,36.8091],[27.151,36.7776],[27.0336,36.7708],[26.9496,36.7271]],[[25.8594,36.7904],[25.7711,36.7822],[25.7432,36.7897],[25.7968,36.807],[25.8344,36.8254],[25.8524,36.8476],[25.942,36.8866],[26.0007,36.9374],[26.0645,36.9027],[25.9847,36.8797],[25.8594,36.7904]],[[24.7209,36.9214],[24.7026,36.9171],[24.6765,36.9593],[24.671,36.9986],[24.6814,37.0216],[24.7161,37.0238],[24.7632,36.9492],[24.7209,36.9214]],[[27.0197,36.959],[26.9199,36.9452],[26.9377,37.0246],[26.8887,37.0873],[26.9666,37.0521],[27.016,37.0097],[27.0401,37.0016],[27.0346,36.976],[27.0197,36.959]],[[25.2789,37.0684],[25.1994,36.9913],[25.1333,36.9997],[25.1055,37.035],[25.1465,37.1074],[25.2351,37.1485],[25.2753,37.1378],[25.2715,37.0842],[25.2789,37.0684]],[[25.5459,36.9676],[25.4567,36.9297],[25.3959,36.9844],[25.3619,37.0704],[25.5253,37.1964],[25.5644,37.1851],[25.5879,37.1525],[25.5843,37.0393],[25.5459,36.9676]],[[24.5235,37.1251],[24.4865,37.1101],[24.4248,37.132],[24.4412,37.1869],[24.4838,37.2102],[24.5291,37.1923],[24.5359,37.1677],[24.5235,37.1251]],[[24.4357,37.3444],[24.3789,37.3141],[24.3978,37.3834],[24.3697,37.4196],[24.3948,37.4504],[24.4313,37.4752],[24.4485,37.4496],[24.4814,37.408],[24.4357,37.3444]],[[24.9429,37.4935],[24.9379,37.3897],[24.9115,37.3906],[24.8962,37.4066],[24.8953,37.4463],[24.9065,37.5089],[24.9429,37.4935]],[[25.4027,37.4191],[25.3071,37.413],[25.3127,37.4893],[25.3481,37.5092],[25.463,37.4711],[25.4574,37.4471],[25.4027,37.4191]],[[26.0293,37.5294],[25.9824,37.5256],[25.9968,37.5656],[26.0863,37.6349],[26.2115,37.6383],[26.3256,37.673],[26.3514,37.6743],[26.2969,37.6196],[26.2049,37.5685],[26.0293,37.5294]],[[25.2559,37.5996],[25.2188,37.5351],[25.1563,37.5451],[25.052,37.6145],[25.0163,37.6459],[24.9965,37.6769],[25.0394,37.6807],[25.0918,37.648],[25.2254,37.6307],[25.2559,37.5996]],[[24.356,37.5769],[24.289,37.5283],[24.2774,37.6011],[24.3204,37.6777],[24.3791,37.6827],[24.4008,37.649],[24.356,37.5769]],[[26.8244,37.8114],[26.9474,37.7785],[26.9815,37.782],[27.0396,37.77],[27.0551,37.7093],[26.9781,37.7005],[26.8449,37.6447],[26.7883,37.657],[26.7205,37.7055],[26.6129,37.7105],[26.5811,37.7237],[26.6387,37.7809],[26.7434,37.8098],[26.8244,37.8114]],[[20.8885,37.8054],[20.9939,37.708],[20.9091,37.7321],[20.8186,37.6647],[20.7038,37.7435],[20.6351,37.8231],[20.6195,37.855],[20.6915,37.9295],[20.7587,37.853],[20.8398,37.8407],[20.8885,37.8054]],[[24.9917,37.7596],[24.9622,37.6924],[24.8841,37.7705],[24.7985,37.824],[24.7665,37.8707],[24.7144,37.8989],[24.7002,37.9617],[24.7634,37.9875],[24.7904,37.9901],[24.8551,37.9137],[24.9563,37.9048],[24.9484,37.8577],[24.9805,37.7969],[24.9917,37.7596]],[[23.551,37.9259],[23.5114,37.9012],[23.4668,37.9024],[23.4353,37.9115],[23.4193,37.9313],[23.4391,37.9407],[23.4622,37.9804],[23.4837,37.9911],[23.5155,37.986],[23.5349,37.9702],[23.551,37.9259]],[[20.6123,38.3833],[20.6247,38.2679],[20.6952,38.2462],[20.7889,38.1421],[20.7808,38.0888],[20.7613,38.0706],[20.6062,38.1197],[20.5689,38.0977],[20.5235,38.1066],[20.4955,38.1642],[20.4987,38.1844],[20.4733,38.2188],[20.4521,38.2342],[20.391,38.1884],[20.3525,38.1799],[20.3522,38.2217],[20.4087,38.3368],[20.4351,38.3562],[20.4814,38.3182],[20.5196,38.3323],[20.5483,38.3945],[20.5503,38.4565],[20.5632,38.475],[20.6123,38.3833]],[[20.7587,38.3294],[20.7093,38.3186],[20.6464,38.4143],[20.6236,38.4803],[20.6497,38.484],[20.6748,38.4763],[20.7013,38.4514],[20.7011,38.4259],[20.7116,38.3986],[20.7392,38.3658],[20.7587,38.3294]],[[26.094,38.2181],[25.9985,38.1615],[25.8919,38.2433],[25.8743,38.2696],[25.9526,38.3026],[25.9914,38.3535],[25.96,38.416],[25.8513,38.5084],[25.8461,38.574],[26.0125,38.6017],[26.1104,38.5446],[26.1604,38.5407],[26.1412,38.4862],[26.1496,38.4685],[26.157,38.3029],[26.1107,38.2796],[26.1031,38.2342],[26.094,38.2181]],[[20.6867,38.6087],[20.6479,38.601],[20.6144,38.6062],[20.584,38.6017],[20.5547,38.5826],[20.5579,38.6619],[20.5925,38.7602],[20.6347,38.8176],[20.6941,38.8442],[20.7196,38.7992],[20.7148,38.6383],[20.6867,38.6087]],[[24.6747,38.8092],[24.569,38.7848],[24.541,38.7887],[24.5646,38.8194],[24.5664,38.8324],[24.461,38.8886],[24.4734,38.9617],[24.4856,38.9803],[24.5641,38.9422],[24.5813,38.8789],[24.6747,38.8092]],[[23.4154,38.9586],[23.472,38.8501],[23.525,38.8135],[23.6362,38.7702],[23.6885,38.7647],[23.8782,38.6866],[24.099,38.671],[24.1275,38.6485],[24.1547,38.5883],[24.1997,38.541],[24.211,38.5042],[24.1875,38.4634],[24.2201,38.3386],[24.2758,38.22],[24.3597,38.1625],[24.464,38.1451],[24.5633,38.1475],[24.5884,38.124],[24.5785,38.0202],[24.5365,37.9797],[24.5023,37.9699],[24.4727,37.9805],[24.4458,38.005],[24.4165,38.0166],[24.3595,38.0186],[24.3178,38.0604],[24.212,38.1175],[24.1926,38.1517],[24.1891,38.2043],[24.1441,38.2431],[24.1028,38.3168],[24.0636,38.3372],[24.0419,38.3741],[24.0401,38.39],[23.8862,38.4007],[23.7588,38.4012],[23.6508,38.4431],[23.6174,38.5525],[23.5533,38.582],[23.5053,38.6129],[23.4652,38.6559],[23.3641,38.735],[23.2521,38.8012],[23.1439,38.8448],[23.0291,38.8734],[22.9357,38.8396],[22.8813,38.8477],[22.8703,38.8705],[22.9863,38.9159],[23.1458,39.0027],[23.2582,39.0313],[23.3127,39.0349],[23.4154,38.9586]],[[23.7798,39.1144],[23.7352,39.0806],[23.6661,39.0954],[23.5939,39.2086],[23.7798,39.1144]],[[23.888,39.1583],[23.8412,39.1466],[23.8881,39.2264],[23.9709,39.2677],[23.9397,39.2005],[23.888,39.1583]],[[26.4102,39.3294],[26.3928,39.2701],[26.5311,39.1718],[26.5782,39.1095],[26.5956,39.0488],[26.584,39.0314],[26.5315,39.0644],[26.4887,39.0748],[26.5031,39.0314],[26.5472,38.9941],[26.4688,38.9728],[26.3901,38.9739],[26.1608,39.0259],[26.1079,39.0811],[26.2451,39.1641],[26.2731,39.1976],[26.176,39.1943],[26.0724,39.0956],[25.9063,39.139],[25.8555,39.1787],[25.8441,39.2],[25.9096,39.2875],[26.0265,39.2846],[26.0884,39.3043],[26.1648,39.332],[26.1654,39.3735],[26.3478,39.383],[26.4102,39.3294]],[[20.0779,39.4327],[20.0996,39.3766],[19.975,39.4114],[19.884,39.4615],[19.8089,39.5853],[19.6489,39.7262],[19.6465,39.7671],[19.7073,39.7981],[19.8386,39.8201],[19.8917,39.7973],[19.9261,39.7737],[19.9368,39.7467],[19.8622,39.6926],[19.8467,39.6681],[19.9041,39.6195],[19.9031,39.6],[19.9273,39.5059],[19.9553,39.4704],[20.0277,39.4421],[20.0779,39.4327]],[[25.4377,39.9833],[25.3999,39.9496],[25.3721,39.8913],[25.357,39.8081],[25.2987,39.8061],[25.2634,39.8229],[25.2518,39.8544],[25.2494,39.8941],[25.2238,39.8926],[25.2032,39.8494],[25.1852,39.8299],[25.1265,39.8258],[25.0622,39.8524],[25.0652,39.9099],[25.0523,39.9764],[25.058,39.9997],[25.2342,40.0054],[25.2857,39.9563],[25.348,39.9848],[25.3736,40.0155],[25.4491,40.0348],[25.4377,39.9833]],[[25.6857,40.4266],[25.5727,40.4004],[25.448,40.4828],[25.5686,40.5159],[25.6243,40.492],[25.6643,40.4639],[25.6857,40.4266]],[[24.7742,40.6152],[24.6459,40.5794],[24.5155,40.647],[24.5167,40.6872],[24.5855,40.7687],[24.6233,40.7929],[24.7191,40.7863],[24.7736,40.7303],[24.7863,40.7039],[24.7687,40.6589],[24.7742,40.6152]],[[26.5364,41.3431],[26.3307,41.2388],[26.3257,41.1433],[26.3284,41.097],[26.3326,41.0643],[26.3541,41.0368],[26.3541,40.9971],[26.3311,40.9545],[26.2412,40.8832],[26.1789,40.8265],[26.1092,40.7497],[26.0697,40.7403],[26.039,40.7268],[26.0107,40.7691],[25.8557,40.8441],[25.4968,40.8878],[25.3253,40.9431],[25.2501,40.9328],[25.1045,40.9947],[25.0047,40.9675],[24.793,40.8575],[24.6787,40.8695],[24.5565,40.9356],[24.4771,40.9478],[24.3838,40.9127],[24.2344,40.7861],[24.0823,40.7241],[23.9461,40.7483],[23.7628,40.7478],[23.7433,40.677],[23.7787,40.628],[23.8789,40.5444],[23.8319,40.4815],[23.8668,40.4186],[23.932,40.4058],[24.0306,40.4093],[24.2128,40.3278],[24.2925,40.2418],[24.3434,40.1477],[24.2324,40.2152],[24.1588,40.28],[24.0561,40.3036],[23.9132,40.3588],[23.8234,40.368],[23.7279,40.3297],[23.7205,40.2863],[23.8234,40.2051],[23.9176,40.1552],[23.9675,40.1146],[24.0008,40.0246],[23.9818,39.994],[23.9471,39.9656],[23.8354,40.0223],[23.6646,40.2238],[23.4263,40.264],[23.3864,40.222],[23.4332,40.1154],[23.4671,40.0739],[23.6741,39.9589],[23.6575,39.9345],[23.6273,39.9241],[23.3956,39.9898],[23.3282,40.0899],[23.312,40.2165],[23.0981,40.3043],[22.8965,40.3999],[22.8514,40.4906],[22.8929,40.5243],[22.9223,40.5909],[22.8114,40.5786],[22.7419,40.5365],[22.6295,40.4956],[22.6249,40.4286],[22.6427,40.3666],[22.6055,40.2764],[22.5693,40.1193],[22.5922,40.0369],[22.8357,39.8006],[22.919,39.6289],[22.9788,39.5638],[23.1034,39.492],[23.2334,39.3584],[23.2885,39.2888],[23.3277,39.1749],[23.2184,39.1044],[23.1547,39.1015],[23.1194,39.1328],[23.1688,39.2104],[23.1617,39.2578],[22.9929,39.3311],[22.9214,39.3063],[22.839,39.2586],[22.886,39.17],[22.939,39.1115],[22.9655,39.0309],[23.0667,39.0379],[22.9305,38.9477],[22.8026,38.9016],[22.6769,38.8989],[22.5968,38.8906],[22.5691,38.8675],[22.6343,38.8507],[22.6875,38.8492],[22.774,38.8004],[23.0203,38.7419],[23.1377,38.668],[23.2529,38.6612],[23.3689,38.5255],[23.5696,38.4894],[23.684,38.3524],[23.836,38.3255],[23.967,38.275],[24.0054,38.2268],[24.0245,38.1398],[24.033,37.9553],[24.0613,37.8179],[24.0623,37.7745],[24.0554,37.7096],[24.0197,37.6777],[23.9716,37.6768],[23.8773,37.7778],[23.7328,37.8841],[23.5805,38.0105],[23.5372,38.0328],[23.5018,38.0349],[23.4202,37.9921],[23.1937,37.959],[23.0874,37.9128],[23.0475,37.9026],[23.0363,37.8784],[23.0861,37.8531],[23.1472,37.7953],[23.1472,37.7163],[23.1976,37.6202],[23.2627,37.5954],[23.3476,37.5976],[23.3962,37.5798],[23.4088,37.5416],[23.4581,37.4969],[23.4906,37.4639],[23.4893,37.4402],[23.2525,37.3773],[23.203,37.3485],[23.1615,37.3338],[23.1,37.3638],[23.0965,37.4406],[23.0151,37.4818],[22.9405,37.5171],[22.8511,37.5322],[22.775,37.5851],[22.7254,37.5421],[22.765,37.3933],[22.8511,37.2908],[22.995,37.0159],[23.0604,36.8535],[23.0735,36.775],[23.041,36.6445],[23.1117,36.5476],[23.1602,36.4481],[23.1068,36.4519],[23.0605,36.487],[22.9829,36.5284],[22.8323,36.6871],[22.7799,36.7862],[22.7172,36.7939],[22.6084,36.7797],[22.4891,36.5682],[22.4895,36.4469],[22.4277,36.4758],[22.3748,36.5136],[22.3813,36.6462],[22.376,36.7019],[22.2312,36.8826],[22.1647,36.9028],[22.1338,36.9639],[22.0805,37.029],[22.0117,37.0165],[21.9556,36.9901],[21.94,36.8918],[21.9343,36.8037],[21.8924,36.7373],[21.7381,36.8632],[21.5829,37.081],[21.5788,37.2004],[21.6925,37.3093],[21.6789,37.3872],[21.5713,37.541],[21.4162,37.6399],[21.3293,37.6693],[21.2885,37.7745],[21.2053,37.8289],[21.138,37.8542],[21.1247,37.8916],[21.145,37.9193],[21.3081,38.0274],[21.4037,38.1967],[21.4512,38.2047],[21.5487,38.1646],[21.6584,38.1751],[21.7484,38.2742],[21.8247,38.3281],[21.9533,38.3212],[22.2438,38.1887],[22.5559,38.1132],[22.7115,38.0469],[22.7996,37.9812],[22.8464,37.9676],[22.9203,37.9583],[22.917,38.0075],[22.8932,38.0509],[22.9548,38.0746],[23.1221,38.0733],[23.1525,38.0964],[23.1835,38.1337],[23.1489,38.1761],[23.0936,38.1964],[23.0344,38.2021],[22.9954,38.2155],[22.9325,38.202],[22.8344,38.2347],[22.7837,38.2617],[22.7539,38.2895],[22.5834,38.3449],[22.4217,38.4385],[22.3853,38.3855],[22.3199,38.3568],[22.2269,38.3528],[21.9653,38.4125],[21.8047,38.3669],[21.7171,38.355],[21.6501,38.354],[21.5677,38.3336],[21.4726,38.3214],[21.3901,38.4078],[21.3555,38.4748],[21.3311,38.4873],[21.3298,38.4244],[21.3033,38.3739],[21.1826,38.3456],[21.1132,38.3847],[21.0598,38.5033],[20.9922,38.654],[20.8732,38.7757],[20.7769,38.8075],[20.7686,38.8744],[20.7773,38.9279],[20.8932,38.9411],[21.0742,38.8852],[21.1116,38.8963],[21.1523,38.9221],[21.1445,38.9792],[21.1184,39.03],[21.0686,39.0323],[21.0341,39.0263],[20.9228,39.0368],[20.7797,39.0085],[20.7134,39.0352],[20.6913,39.0675],[20.5717,39.1477],[20.4683,39.2553],[20.3008,39.3271],[20.1914,39.5458],[20.0994,39.6413],[20.0013,39.7094],[20.0226,39.7107],[20.0598,39.6991],[20.1311,39.6616],[20.2068,39.6535],[20.2482,39.6784],[20.2721,39.7012],[20.2876,39.7386],[20.2938,39.7822],[20.3062,39.7967],[20.3641,39.7917],[20.3824,39.8026],[20.3816,39.8418],[20.3442,39.8906],[20.3113,39.9508],[20.3111,39.9794],[20.3385,39.9911],[20.3837,40.0172],[20.408,40.0495],[20.4561,40.0656],[20.5271,40.0685],[20.6063,40.0827],[20.6574,40.1174],[20.6649,40.1518],[20.697,40.2464],[20.7179,40.2927],[20.7517,40.3349],[20.77,40.3919],[20.8061,40.4455],[20.8816,40.4679],[20.9502,40.4944],[21.002,40.5634],[21.0309,40.6225],[21.0311,40.6586],[20.9879,40.7178],[20.9558,40.7753],[20.9643,40.8499],[21.1,40.8562],[21.1476,40.8631],[21.3237,40.8671],[21.4041,40.9072],[21.4597,40.9036],[21.5758,40.8689],[21.6275,40.8963],[21.7795,40.9504],[21.9295,41.1074],[21.9934,41.131],[22.1389,41.1405],[22.1845,41.1586],[22.2377,41.1552],[22.4008,41.1234],[22.4936,41.1185],[22.6036,41.1402],[22.7248,41.1785],[22.7551,41.3127],[22.7839,41.332],[22.8593,41.3374],[22.916,41.3363],[23.0256,41.3256],[23.156,41.3221],[23.2398,41.385],[23.3721,41.3896],[23.4334,41.3987],[23.5358,41.386],[23.6352,41.3868],[23.7623,41.413],[23.8809,41.456],[23.9735,41.4523],[24.0113,41.4601],[24.0329,41.4691],[24.0561,41.5272],[24.2304,41.5308],[24.2895,41.525],[24.3867,41.5235],[24.4879,41.5552],[24.5183,41.5525],[24.5693,41.4674],[24.596,41.4427],[24.6511,41.42],[24.7737,41.3561],[24.7958,41.3729],[24.8469,41.3942],[24.9936,41.365],[25.1334,41.3158],[25.2512,41.2436],[25.3819,41.2644],[25.5271,41.2998],[25.6215,41.3101],[25.7239,41.315],[25.785,41.3304],[25.9233,41.3119],[26.0664,41.3507],[26.1354,41.3857],[26.1552,41.4349],[26.1436,41.5215],[26.1112,41.6082],[26.077,41.6402],[26.066,41.6732],[26.0855,41.7042],[26.1074,41.7257],[26.2006,41.7438],[26.3209,41.7166],[26.4105,41.6963],[26.4625,41.6634],[26.495,41.6333],[26.5445,41.6072],[26.5813,41.6013],[26.6098,41.5122],[26.6249,41.4018],[26.6023,41.3542],[26.5364,41.3431]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Greece","sov_a3":"GRC","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Greece","adm0_a3":"GRC","geou_dif":0,"geounit":"Greece","gu_a3":"GRC","su_dif":0,"subunit":"Greece","su_a3":"GRC","brk_diff":0,"name":"Greece","name_long":"Greece","brk_a3":"GRC","brk_name":"Greece","brk_group":"","abbrev":"Greece","postal":"GR","formal_en":"Hellenic Republic","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Greece","name_alt":"","mapcolor7":2,"mapcolor8":2,"mapcolor9":2,"mapcolor13":9,"pop_est":10737428,"gdp_md_est":343000,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"GR","iso_a3":"GRC","iso_n3":"300","un_a3":"300","wb_a2":"GR","wb_a3":"GRC","woe_id":-99,"adm0_a3_is":"GRC","adm0_a3_us":"GRC","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Southern Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":6,"abbrev_len":6,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[-2.5123,49.4945],[-2.5474,49.4287],[-2.639,49.4509],[-2.6461,49.4682],[-2.5422,49.5066],[-2.5209,49.5063],[-2.5123,49.4945]]]},"properties":{"scalerank":4,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"United Kingdom","sov_a3":"GB1","adm0_dif":1,"level":2,"type":"Country","admin":"Guernsey","adm0_a3":"GGY","geou_dif":0,"geounit":"Guernsey","gu_a3":"GGY","su_dif":0,"subunit":"Guernsey","su_a3":"GGY","brk_diff":0,"name":"Guernsey","name_long":"Guernsey","brk_a3":"GGY","brk_name":"Guernsey","brk_group":"Channel Islands","abbrev":"Guern.","postal":"GG","formal_en":"Bailiwick of Guernsey","formal_fr":"","note_adm0":"U.K. crown dependency","note_brk":"","name_sort":"Guernsey","name_alt":"","mapcolor7":6,"mapcolor8":6,"mapcolor9":6,"mapcolor13":3,"pop_est":68633,"gdp_md_est":2742,"pop_year":-99,"lastcensus":2001,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"GG","iso_a3":"GGY","iso_n3":"831","un_a3":"831","wb_a2":"JG","wb_a3":"CHI","woe_id":-99,"adm0_a3_is":"GGY","adm0_a3_us":"GGY","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Northern Europe","region_wb":"Europe & Central Asia","name_len":8,"long_len":8,"abbrev_len":6,"tiny":-99,"homepart":-99}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[4.2937,39.8418],[4.2753,39.8303],[3.9677,39.9458],[3.8672,39.9587],[3.8427,39.9764],[3.8454,40.0365],[3.8534,40.063],[4.0592,40.0751],[4.2258,40.0324],[4.3151,39.9172],[4.3221,39.8975],[4.2937,39.8418]],[[1.4452,38.9187],[1.409,38.8573],[1.2569,38.879],[1.2233,38.9039],[1.2563,38.9734],[1.2998,38.9817],[1.3025,39.0312],[1.3486,39.0808],[1.5645,39.121],[1.6132,39.0874],[1.6236,39.0388],[1.4945,38.9325],[1.4452,38.9187]],[[1.5939,38.6721],[1.5712,38.6588],[1.505,38.671],[1.4058,38.671],[1.402,38.7114],[1.4172,38.7396],[1.4363,38.7682],[1.4969,38.7119],[1.5927,38.7015],[1.5939,38.6721]],[[3.1453,39.7901],[3.2411,39.7567],[3.3422,39.7867],[3.3959,39.7773],[3.4489,39.7612],[3.4618,39.6978],[3.4146,39.6271],[3.3487,39.5557],[3.293,39.4771],[3.2447,39.3866],[3.1546,39.3333],[3.0729,39.3013],[2.9001,39.3684],[2.7998,39.3851],[2.7698,39.4103],[2.746,39.5103],[2.7006,39.5421],[2.6341,39.5562],[2.5759,39.5307],[2.4995,39.4779],[2.4588,39.5305],[2.3943,39.5404],[2.37,39.5721],[2.3713,39.6131],[2.785,39.8548],[2.9048,39.9083],[3.1587,39.9705],[3.1976,39.9611],[3.1645,39.9242],[3.167,39.9077],[3.1986,39.8898],[3.1909,39.8614],[3.1587,39.8366],[3.1453,39.7901]],[[-7.6981,43.7646],[-7.5946,43.7273],[-7.5036,43.7399],[-7.3993,43.6958],[-7.262,43.5946],[-7.061,43.554],[-6.9007,43.5856],[-6.6173,43.5924],[-6.4757,43.5789],[-6.2241,43.6039],[-6.0801,43.5949],[-5.8467,43.6451],[-5.6658,43.5825],[-5.3157,43.5532],[-5.1053,43.5019],[-4.523,43.4157],[-4.3128,43.4147],[-4.0153,43.4631],[-3.8894,43.4994],[-3.774,43.4779],[-3.6046,43.5195],[-3.5236,43.511],[-3.4179,43.4517],[-3.0456,43.3716],[-2.9477,43.4397],[-2.875,43.4544],[-2.6071,43.4127],[-2.3371,43.328],[-2.1967,43.3219],[-1.9913,43.3451],[-1.8285,43.4008],[-1.794,43.4073],[-1.7927,43.3726],[-1.7533,43.3247],[-1.7128,43.307],[-1.6271,43.2825],[-1.5615,43.2792],[-1.4717,43.2677],[-1.4107,43.2401],[-1.4073,43.1971],[-1.4226,43.1491],[-1.4594,43.105],[-1.4805,43.0711],[-1.4608,43.0518],[-1.4288,43.0368],[-1.394,43.0326],[-1.3705,43.0376],[-1.3527,43.0643],[-1.3188,43.097],[-1.3,43.101],[-1.3016,43.0825],[-1.2854,43.0596],[-1.1754,43.0211],[-0.9338,42.9495],[-0.8392,42.9482],[-0.7626,42.9398],[-0.7402,42.9095],[-0.5864,42.799],[-0.5498,42.802],[-0.4812,42.7993],[-0.3984,42.8081],[-0.3386,42.8288],[-0.2993,42.8253],[-0.2561,42.804],[-0.2053,42.7853],[-0.14,42.7489],[-0.0815,42.7039],[-0.0412,42.6891],[0.2014,42.7193],[0.2555,42.6929],[0.3129,42.6933],[0.3772,42.7001],[0.5177,42.6863],[0.6316,42.6896],[0.642,42.7006],[0.6518,42.8004],[0.6698,42.8357],[0.6969,42.8451],[0.7645,42.838],[1.0101,42.779],[1.1111,42.742],[1.2083,42.7131],[1.2933,42.71],[1.3494,42.6907],[1.4283,42.5959],[1.4148,42.5484],[1.422,42.5308],[1.4303,42.4979],[1.4281,42.4613],[1.4488,42.4375],[1.4862,42.4345],[1.5341,42.4417],[1.5864,42.456],[1.6785,42.4967],[1.7061,42.5033],[1.8598,42.4571],[1.9279,42.4263],[1.9515,42.3928],[1.9865,42.3585],[2.0327,42.3535],[2.0983,42.3861],[2.2004,42.4209],[2.3744,42.3903],[2.568,42.3458],[2.6517,42.3405],[2.6548,42.3621],[2.67,42.393],[2.7019,42.4085],[2.7494,42.413],[2.8156,42.4292],[2.8914,42.4561],[2.97,42.4672],[3.0526,42.4472],[3.1521,42.431],[3.2114,42.4312],[3.2398,42.3679],[3.2879,42.3437],[3.3067,42.289],[3.2187,42.2604],[3.1664,42.2565],[3.1504,42.1625],[3.1752,42.136],[3.2246,42.1111],[3.2381,42.0822],[3.248,41.9442],[3.1469,41.861],[3.0049,41.7674],[2.3109,41.4665],[2.1456,41.3208],[2.0826,41.2874],[1.5666,41.1956],[1.2059,41.0976],[1.0329,41.0621],[0.8169,40.8916],[0.7146,40.8229],[0.7961,40.8038],[0.8911,40.7224],[0.8592,40.6862],[0.7206,40.6305],[0.6601,40.6133],[0.6271,40.6222],[0.5961,40.6145],[0.3637,40.319],[0.1584,40.1066],[0.0431,40.014],[-0.0751,39.8759],[-0.327,39.5199],[-0.329,39.4171],[-0.2049,39.0626],[-0.1338,38.9695],[-0.0341,38.8912],[0.1549,38.8247],[0.2016,38.7592],[0.1363,38.6968],[-0.0527,38.5857],[-0.3812,38.4356],[-0.5208,38.3173],[-0.5507,38.2031],[-0.6468,38.1519],[-0.6832,37.992],[-0.7416,37.8861],[-0.7527,37.8502],[-0.8146,37.7699],[-0.8231,37.7116],[-0.7216,37.6311],[-0.7719,37.5962],[-0.8222,37.5808],[-0.9381,37.5713],[-1.3275,37.5611],[-1.641,37.387],[-1.7976,37.2329],[-1.9393,36.9458],[-2.1115,36.7767],[-2.1877,36.7455],[-2.3056,36.8198],[-2.4528,36.8312],[-2.5957,36.8065],[-2.6706,36.7476],[-2.7875,36.7147],[-2.9019,36.7432],[-3.1492,36.7585],[-3.2591,36.7558],[-3.4312,36.7079],[-3.5788,36.7398],[-3.8278,36.7561],[-4.3668,36.7181],[-4.4349,36.7002],[-4.5022,36.6292],[-4.6741,36.5064],[-4.9353,36.5021],[-5.1715,36.4238],[-5.2305,36.3736],[-5.3297,36.2357],[-5.3609,36.1349],[-5.3816,36.1341],[-5.4072,36.1589],[-5.4436,36.1506],[-5.4625,36.0738],[-5.5513,36.0388],[-5.6255,36.0259],[-5.8084,36.0883],[-5.9607,36.1817],[-6.0407,36.1884],[-6.1705,36.3338],[-6.2263,36.4265],[-6.2659,36.5265],[-6.2577,36.5648],[-6.2689,36.5967],[-6.3841,36.637],[-6.4123,36.7289],[-6.3283,36.8481],[-6.2594,36.899],[-6.2168,36.9136],[-6.3209,36.9085],[-6.3962,36.8316],[-6.4924,36.9546],[-6.8846,37.1942],[-6.8594,37.2492],[-6.8638,37.2789],[-6.9295,37.2149],[-6.9747,37.1984],[-7.175,37.2088],[-7.4062,37.1794],[-7.4672,37.428],[-7.496,37.5236],[-7.5035,37.5855],[-7.4439,37.7283],[-7.3789,37.7864],[-7.2922,37.9064],[-7.1854,38.0063],[-7.0725,38.03],[-7.0229,38.0447],[-6.9811,38.122],[-6.9576,38.1879],[-6.9748,38.1944],[-7.1064,38.181],[-7.343,38.4574],[-7.3358,38.5015],[-7.306,38.5668],[-7.2864,38.6494],[-7.2815,38.7146],[-7.2199,38.7705],[-7.1255,38.827],[-7.046,38.907],[-7.0062,38.9853],[-6.9979,39.0564],[-7.043,39.1071],[-7.1724,39.1352],[-7.3058,39.3381],[-7.3354,39.4651],[-7.3627,39.4783],[-7.4451,39.5362],[-7.5242,39.6447],[-7.5357,39.6616],[-7.4541,39.6807],[-7.1177,39.6817],[-7.0474,39.7056],[-7.0367,39.714],[-6.9754,39.7984],[-6.9112,39.9371],[-6.8961,40.0218],[-6.9164,40.0568],[-7.0278,40.1426],[-7.0326,40.1679],[-7.0147,40.2083],[-6.9484,40.2516],[-6.8589,40.3007],[-6.8102,40.3431],[-6.8218,40.3763],[-6.8479,40.411],[-6.8521,40.4433],[-6.8357,40.4832],[-6.8298,40.6191],[-6.8184,40.6541],[-6.8359,40.7775],[-6.8577,40.8783],[-6.9285,41.0091],[-6.9155,41.038],[-6.8828,41.0624],[-6.7758,41.1077],[-6.6901,41.2145],[-6.5659,41.3037],[-6.4031,41.3754],[-6.2894,41.455],[-6.2443,41.5159],[-6.2125,41.532],[-6.2217,41.5604],[-6.2431,41.6018],[-6.3081,41.6422],[-6.3917,41.6654],[-6.4847,41.6644],[-6.5422,41.6725],[-6.559,41.7041],[-6.5526,41.7896],[-6.5575,41.8741],[-6.5753,41.9131],[-6.6183,41.9424],[-6.7036,41.9346],[-6.7773,41.9585],[-6.8332,41.9642],[-6.8655,41.9453],[-7.0305,41.9506],[-7.0991,41.9642],[-7.1471,41.9812],[-7.1779,41.9717],[-7.1954,41.9552],[-7.1983,41.9294],[-7.2096,41.8953],[-7.2686,41.8644],[-7.4036,41.8337],[-7.5126,41.836],[-7.6126,41.858],[-7.6447,41.874],[-7.6931,41.8885],[-7.8964,41.8706],[-7.9208,41.8836],[-7.991,41.8519],[-8.0944,41.8142],[-8.1525,41.812],[-8.1735,41.82],[-8.1812,41.837],[-8.2248,41.8958],[-8.2133,41.9271],[-8.13,42.0182],[-8.1393,42.0399],[-8.1736,42.0694],[-8.2042,42.1119],[-8.2131,42.1337],[-8.2661,42.1374],[-8.3226,42.1151],[-8.5381,42.0693],[-8.5896,42.0527],[-8.683,42.0085],[-8.7771,41.9411],[-8.8523,41.9269],[-8.8783,41.9469],[-8.8872,42.1053],[-8.7725,42.2106],[-8.6909,42.2742],[-8.7292,42.287],[-8.8158,42.2853],[-8.81,42.3345],[-8.7694,42.3582],[-8.73,42.4117],[-8.7762,42.4348],[-8.8121,42.4701],[-8.8099,42.5624],[-8.7999,42.5999],[-8.8115,42.6403],[-8.9878,42.5856],[-9.0331,42.5938],[-9.0351,42.6624],[-8.9372,42.7667],[-8.9272,42.7986],[-9.0416,42.814],[-9.1272,42.8652],[-9.1794,42.911],[-9.2352,42.9769],[-9.2356,43.0358],[-9.1781,43.174],[-9.0956,43.2142],[-9.0245,43.239],[-8.8737,43.3344],[-8.6656,43.3166],[-8.5371,43.3371],[-8.4216,43.3858],[-8.3555,43.3968],[-8.2489,43.4394],[-8.2523,43.4969],[-8.2889,43.5396],[-8.2567,43.5799],[-8.1372,43.6291],[-8.0047,43.6944],[-7.8527,43.707],[-7.6981,43.7646]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Spain","sov_a3":"ESP","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Spain","adm0_a3":"ESP","geou_dif":0,"geounit":"Spain","gu_a3":"ESP","su_dif":0,"subunit":"Spain","su_a3":"ESP","brk_diff":0,"name":"Spain","name_long":"Spain","brk_a3":"ESP","brk_name":"Spain","brk_group":"","abbrev":"Sp.","postal":"E","formal_en":"Kingdom of Spain","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Spain","name_alt":"","mapcolor7":4,"mapcolor8":5,"mapcolor9":5,"mapcolor13":5,"pop_est":40525002,"gdp_md_est":1403000,"pop_year":-99,"lastcensus":2001,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"ES","iso_a3":"ESP","iso_n3":"724","un_a3":"724","wb_a2":"ES","wb_a3":"ESP","woe_id":-99,"adm0_a3_is":"ESP","adm0_a3_us":"ESP","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Southern Europe","region_wb":"Europe & Central Asia","name_len":5,"long_len":5,"abbrev_len":3,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[46.4299,41.891],[46.4055,41.8551],[46.3482,41.7902],[46.3025,41.7571],[46.2519,41.7518],[46.2019,41.7369],[46.1843,41.7021],[46.1821,41.6571],[46.1905,41.6249],[46.2035,41.6126],[46.2547,41.6021],[46.3055,41.5077],[46.385,41.4599],[46.5088,41.4056],[46.6189,41.3438],[46.6726,41.2868],[46.6624,41.2455],[46.6264,41.1597],[46.5344,41.0886],[46.4579,41.0702],[46.431,41.0771],[46.3808,41.0993],[46.28,41.1544],[46.1707,41.1979],[46.0865,41.1838],[46.0313,41.1673],[45.922,41.1867],[45.7928,41.2244],[45.7255,41.2616],[45.6957,41.289],[45.7156,41.3376],[45.4223,41.4253],[45.281,41.4496],[45.2172,41.4232],[45.0014,41.291],[44.9759,41.2775],[44.8113,41.2594],[44.8109,41.2486],[44.8485,41.2202],[44.8414,41.2114],[44.5648,41.2082],[44.473,41.191],[44.2273,41.2133],[44.1465,41.2034],[44.0772,41.1825],[43.9092,41.159],[43.7932,41.1311],[43.645,41.1167],[43.492,41.1155],[43.4395,41.1071],[43.4416,41.126],[43.4334,41.1555],[43.4023,41.1766],[43.359,41.1901],[43.2793,41.1852],[43.2055,41.1992],[43.1528,41.2364],[43.141,41.2648],[43.1713,41.2879],[43.149,41.3071],[43.0571,41.3528],[42.9067,41.4668],[42.8217,41.4924],[42.7879,41.5637],[42.7541,41.5789],[42.6824,41.5857],[42.6068,41.5788],[42.5904,41.5707],[42.5674,41.5593],[42.5079,41.4701],[42.4664,41.4398],[42.3644,41.454],[42.28,41.475],[42.2111,41.4867],[42.0777,41.4941],[41.9258,41.4957],[41.8235,41.4324],[41.7794,41.4405],[41.7018,41.4716],[41.5766,41.4973],[41.5101,41.5175],[41.7018,41.7054],[41.7588,41.8171],[41.7607,41.8849],[41.763,41.97],[41.6633,42.1469],[41.5777,42.3979],[41.4888,42.6593],[41.4194,42.7376],[41.1287,42.8281],[41.0616,42.9309],[40.8366,43.0635],[40.524,43.121],[40.4621,43.1457],[40.1906,43.3124],[39.9783,43.4198],[40.0237,43.4849],[40.0846,43.5531],[40.1502,43.5698],[40.3423,43.5427],[40.5189,43.512],[40.648,43.5339],[40.8017,43.4799],[40.942,43.4181],[41.0831,43.3745],[41.3582,43.3334],[41.4607,43.2763],[41.5806,43.2192],[42.05,43.1901],[42.0878,43.1991],[42.1223,43.2073],[42.2797,43.2281],[42.419,43.2242],[42.566,43.1551],[42.6603,43.1591],[42.7606,43.1696],[42.89,43.1326],[42.9916,43.0915],[43.0002,43.0497],[43.0892,42.9891],[43.3479,42.8967],[43.5578,42.8445],[43.623,42.8077],[43.7826,42.747],[43.7987,42.7278],[43.7954,42.703],[43.7499,42.6575],[43.7384,42.617],[43.7599,42.5938],[43.826,42.5715],[43.9574,42.5666],[44.0047,42.5956],[44.1027,42.6164],[44.1997,42.6536],[44.3295,42.7035],[44.5059,42.7486],[44.5765,42.7485],[44.6443,42.7347],[44.6918,42.7096],[44.7711,42.6168],[44.8505,42.7468],[44.871,42.7564],[44.9434,42.7303],[45.0716,42.6941],[45.1603,42.675],[45.2082,42.6482],[45.3438,42.5298],[45.5629,42.5357],[45.6556,42.5177],[45.7053,42.4981],[45.7275,42.475],[45.6884,42.3574],[45.6343,42.2347],[45.6386,42.2051],[45.7266,42.1589],[45.846,42.11],[45.9104,42.0707],[45.954,42.0354],[46.0484,42.0087],[46.1598,41.992],[46.2127,41.9899],[46.2678,41.9604],[46.4115,41.9046],[46.4299,41.891]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Georgia","sov_a3":"GEO","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Georgia","adm0_a3":"GEO","geou_dif":0,"geounit":"Georgia","gu_a3":"GEO","su_dif":0,"subunit":"Georgia","su_a3":"GEO","brk_diff":0,"name":"Georgia","name_long":"Georgia","brk_a3":"GEO","brk_name":"Georgia","brk_group":"","abbrev":"Geo.","postal":"GE","formal_en":"Georgia","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Georgia","name_alt":"","mapcolor7":5,"mapcolor8":1,"mapcolor9":3,"mapcolor13":2,"pop_est":4615807,"gdp_md_est":21510,"pop_year":-99,"lastcensus":2002,"gdp_year":-99,"economy":"6. Developing region","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"GE","iso_a3":"GEO","iso_n3":"268","un_a3":"268","wb_a2":"GE","wb_a3":"GEO","woe_id":-99,"adm0_a3_is":"GEO","adm0_a3_us":"GEO","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Western Asia","region_wb":"Europe & Central Asia","name_len":7,"long_len":7,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[-1.0656,50.6902],[-1.1494,50.6557],[-1.1758,50.6152],[-1.1961,50.5992],[-1.2515,50.5888],[-1.3063,50.5885],[-1.5153,50.6698],[-1.5634,50.6661],[-1.5157,50.7033],[-1.3858,50.7335],[-1.3128,50.7735],[-1.1442,50.7347],[-1.0656,50.6902]],[[-4.1968,53.3214],[-4.1549,53.3028],[-4.0494,53.3058],[-4.0843,53.2643],[-4.2004,53.2181],[-4.2786,53.1724],[-4.373,53.1342],[-4.4188,53.178],[-4.472,53.1764],[-4.5532,53.2604],[-4.5679,53.3865],[-4.4617,53.4193],[-4.3151,53.4172],[-4.1968,53.3214]],[[-6.3753,55.2418],[-6.2342,55.2168],[-6.1292,55.2174],[-6.0358,55.1445],[-5.9857,55.0297],[-5.8692,54.9162],[-5.7168,54.8175],[-5.7107,54.7571],[-5.7652,54.7247],[-5.8791,54.6844],[-5.8786,54.6413],[-5.8035,54.663],[-5.7386,54.673],[-5.5825,54.6634],[-5.5279,54.6196],[-5.4902,54.5541],[-5.4704,54.5002],[-5.4839,54.4417],[-5.5259,54.4602],[-5.5686,54.5126],[-5.616,54.5367],[-5.6711,54.5498],[-5.6461,54.4779],[-5.656,54.3817],[-5.6319,54.3727],[-5.5578,54.371],[-5.6068,54.2726],[-5.7081,54.2458],[-5.8262,54.2358],[-5.8546,54.201],[-5.8761,54.1561],[-5.9377,54.0891],[-6.019,54.0513],[-6.1195,54.0589],[-6.218,54.0887],[-6.3037,54.0949],[-6.3637,54.0771],[-6.4026,54.0606],[-6.4403,54.0636],[-6.5481,54.0573],[-6.6498,54.0586],[-6.6642,54.0848],[-6.6469,54.1634],[-6.6695,54.1847],[-6.7666,54.1956],[-6.8026,54.2144],[-6.8583,54.2687],[-6.8692,54.294],[-6.8772,54.3291],[-6.9361,54.3743],[-7.0077,54.4067],[-7.0497,54.4083],[-7.1335,54.3554],[-7.2026,54.3018],[-7.1781,54.2749],[-7.1555,54.2395],[-7.1931,54.2141],[-7.3067,54.156],[-7.3245,54.1334],[-7.3552,54.1212],[-7.4094,54.1373],[-7.5444,54.1336],[-7.6065,54.1438],[-7.6788,54.1867],[-7.8549,54.2153],[-7.8845,54.2838],[-7.9185,54.2966],[-8.1183,54.4143],[-8.1448,54.4535],[-8.1189,54.477],[-8.0443,54.5125],[-7.7938,54.5712],[-7.7544,54.5949],[-7.7463,54.6158],[-7.8198,54.6397],[-7.8861,54.6661],[-7.9087,54.6833],[-7.9106,54.6983],[-7.8729,54.7179],[-7.7973,54.7193],[-7.7375,54.7104],[-7.69,54.728],[-7.6064,54.7457],[-7.5504,54.768],[-7.5022,54.8254],[-7.4513,54.8771],[-7.446,54.9051],[-7.4014,55.0033],[-7.3769,55.0277],[-7.2187,55.092],[-7.1786,55.0569],[-7.1006,55.0483],[-7.0308,55.0806],[-6.9472,55.1825],[-6.889,55.1889],[-6.8249,55.1807],[-6.6988,55.1935],[-6.475,55.241],[-6.3753,55.2418]],[[-5.1054,55.4488],[-5.2315,55.4481],[-5.2771,55.4567],[-5.3315,55.4811],[-5.3927,55.6184],[-5.3708,55.6669],[-5.3457,55.6907],[-5.3181,55.7092],[-5.2516,55.7169],[-5.1854,55.691],[-5.1604,55.6668],[-5.105,55.574],[-5.0947,55.4943],[-5.1054,55.4488]],[[-6.1289,55.9306],[-6.0928,55.8021],[-6.0576,55.7225],[-6.0553,55.6953],[-6.0884,55.6575],[-6.2532,55.6072],[-6.3051,55.6069],[-6.3072,55.6191],[-6.27,55.6703],[-6.3021,55.7284],[-6.2864,55.7725],[-6.3018,55.7806],[-6.3339,55.7744],[-6.452,55.7042],[-6.4914,55.6973],[-6.4957,55.7116],[-6.4665,55.769],[-6.4628,55.8083],[-6.4453,55.8324],[-6.4132,55.8546],[-6.375,55.8713],[-6.3441,55.8737],[-6.3113,55.8565],[-6.2157,55.9046],[-6.1289,55.9306]],[[-5.9701,55.8146],[-5.9909,55.8038],[-6.0416,55.8068],[-6.0604,55.8229],[-6.0707,55.8477],[-6.072,55.8931],[-6.0413,55.9256],[-5.9118,55.9748],[-5.9703,55.9922],[-5.9727,56.0044],[-5.9391,56.0453],[-5.7996,56.1088],[-5.7623,56.1203],[-5.7251,56.1186],[-5.7972,56.0056],[-5.9701,55.8146]],[[-5.7779,56.3443],[-6.1762,56.2887],[-6.3134,56.2937],[-6.3258,56.3209],[-6.2985,56.3392],[-6.1849,56.3569],[-6.1389,56.4906],[-6.3106,56.5521],[-6.3197,56.5694],[-6.3062,56.5988],[-6.2863,56.6119],[-6.1821,56.643],[-6.1383,56.6499],[-6.1027,56.6457],[-6.0296,56.6098],[-5.9467,56.5345],[-5.836,56.5226],[-5.7608,56.4907],[-5.7779,56.3443]],[[-6.6076,56.585],[-6.6645,56.5794],[-6.6686,56.5936],[-6.5699,56.6612],[-6.5061,56.6724],[-6.4837,56.6658],[-6.5301,56.6266],[-6.6076,56.585]],[[-7.4169,56.9654],[-7.5048,56.9517],[-7.5374,56.9597],[-7.543,56.9724],[-7.5229,57.0068],[-7.4555,57.0189],[-7.4067,57.0003],[-7.3989,56.9833],[-7.4169,56.9654]],[[-6.2791,56.9647],[-6.3087,56.9518],[-6.3462,56.9543],[-6.3834,56.9709],[-6.4326,57.0179],[-6.3224,57.0505],[-6.2782,57.0314],[-6.2613,57.0095],[-6.2605,56.9853],[-6.2791,56.9647]],[[-7.2499,57.1153],[-7.292,57.1098],[-7.3474,57.1151],[-7.3815,57.1307],[-7.4159,57.1921],[-7.4224,57.2293],[-7.407,57.2985],[-7.4105,57.3811],[-7.2964,57.3837],[-7.2671,57.3718],[-7.2476,57.1264],[-7.2499,57.1153]],[[-6.1447,57.505],[-6.1461,57.4608],[-6.1638,57.4088],[-6.1408,57.3537],[-6.1355,57.3143],[-6.0934,57.3017],[-6.0676,57.2835],[-5.8803,57.2632],[-5.706,57.2689],[-5.6725,57.2527],[-5.6687,57.2269],[-5.6962,57.1984],[-5.7954,57.1465],[-5.9138,57.0626],[-5.9491,57.0452],[-5.9873,57.0444],[-6.0147,57.052],[-6.0344,57.2012],[-6.1627,57.1821],[-6.2661,57.1843],[-6.3227,57.2025],[-6.3624,57.2375],[-6.4424,57.3275],[-6.6754,57.3629],[-6.7413,57.4125],[-6.7611,57.4424],[-6.7527,57.4589],[-6.7042,57.4958],[-6.6435,57.4826],[-6.6059,57.4907],[-6.583,57.5071],[-6.5835,57.5207],[-6.6153,57.5527],[-6.6168,57.5627],[-6.3785,57.6033],[-6.3577,57.6668],[-6.306,57.672],[-6.2469,57.6512],[-6.1661,57.5853],[-6.1447,57.505]],[[-7.2056,57.683],[-7.0928,57.6267],[-7.1826,57.5333],[-7.3206,57.5337],[-7.5147,57.602],[-7.5156,57.6159],[-7.4994,57.6363],[-7.4703,57.6525],[-7.44,57.6564],[-7.3919,57.6452],[-7.3249,57.6631],[-7.2712,57.6575],[-7.2056,57.683]],[[-6.1987,58.3633],[-6.3258,58.1889],[-6.3756,58.1846],[-6.4193,58.141],[-6.5546,58.0929],[-6.4365,58.0919],[-6.4034,58.0759],[-6.4024,58.0414],[-6.4252,58.0213],[-6.5781,57.9414],[-6.6833,57.911],[-6.7966,57.8275],[-6.8538,57.8265],[-6.9104,57.7734],[-6.9569,57.75],[-6.9831,57.75],[-7.0132,57.7618],[-7.0834,57.8138],[-6.956,57.8649],[-6.9441,57.8937],[-6.8568,57.9235],[-6.8642,57.9329],[-7.0025,57.9749],[-7.0571,58.0032],[-7.0519,58.018],[-6.9853,58.0505],[-7.0169,58.0548],[-7.0382,58.0723],[-7.0769,58.079],[-7.0885,58.0954],[-7.0956,58.1383],[-7.0853,58.1822],[-7.0449,58.2016],[-7.0284,58.2223],[-7.0121,58.2287],[-6.9496,58.2177],[-6.8862,58.1826],[-6.8123,58.1961],[-6.7265,58.1894],[-6.7247,58.1976],[-6.7877,58.2839],[-6.7765,58.3015],[-6.7423,58.3216],[-6.5442,58.3832],[-6.2972,58.4866],[-6.2375,58.5028],[-6.2194,58.4887],[-6.1942,58.4351],[-6.1987,58.3633]],[[-3.1097,58.5155],[-3.1011,58.4337],[-3.1129,58.4089],[-3.1368,58.3783],[-3.2124,58.3212],[-3.411,58.2396],[-3.775,58.0521],[-3.99,57.959],[-4.0196,57.9143],[-4.0356,57.852],[-3.9068,57.8396],[-3.8571,57.8186],[-3.8879,57.7869],[-4.0784,57.6771],[-4.1345,57.5777],[-3.9885,57.5812],[-3.8682,57.6003],[-3.6282,57.6623],[-3.4028,57.7083],[-3.2945,57.7102],[-3.0839,57.6735],[-3.036,57.6723],[-2.9467,57.6893],[-2.8563,57.6923],[-2.2441,57.6809],[-2.0741,57.7024],[-1.9615,57.6767],[-1.8674,57.6124],[-1.7779,57.4938],[-1.7807,57.474],[-1.8347,57.42],[-1.9345,57.3522],[-2.0203,57.2589],[-2.0455,57.2085],[-2.0624,57.1535],[-2.0896,57.1025],[-2.2603,56.8633],[-2.4267,56.7307],[-2.501,56.6366],[-2.5927,56.5616],[-2.681,56.5144],[-2.7752,56.483],[-3.0474,56.4494],[-3.1236,56.4253],[-3.2145,56.3839],[-3.31,56.3635],[-3.198,56.3661],[-3.087,56.3891],[-2.8852,56.3975],[-2.6527,56.3183],[-2.6743,56.2534],[-2.7676,56.2021],[-2.9798,56.1941],[-3.1782,56.0801],[-3.2678,56.0451],[-3.3623,56.0276],[-3.4804,56.0328],[-3.6951,56.0633],[-3.7891,56.0952],[-3.7042,56.0432],[-3.6078,56.016],[-3.0487,55.952],[-3.0151,55.9586],[-2.8369,56.0263],[-2.5993,56.0273],[-2.1471,55.903],[-2.0168,55.808],[-1.8303,55.6717],[-1.7288,55.6186],[-1.6554,55.5704],[-1.6102,55.4981],[-1.5226,55.2595],[-1.4227,55.0264],[-1.2917,54.7739],[-1.2324,54.7037],[-1.1544,54.6545],[-0.7593,54.5414],[-0.6714,54.5039],[-0.5181,54.3951],[-0.3704,54.2792],[-0.2329,54.1901],[-0.0844,54.1181],[-0.1563,54.0806],[-0.2056,54.0217],[-0.1687,53.9417],[-0.1083,53.8652],[0.0105,53.7428],[0.1153,53.6093],[0.0767,53.6294],[0.0361,53.6405],[-0.0194,53.6372],[-0.0737,53.6437],[-0.1738,53.6854],[-0.27,53.7368],[-0.4614,53.7162],[-0.5677,53.7254],[-0.6599,53.724],[-0.4851,53.6944],[-0.2937,53.6923],[0.1283,53.4683],[0.271,53.3355],[0.3558,53.16],[0.298,53.0811],[0.2082,53.03],[0.1244,52.9716],[0.0459,52.9056],[0.2798,52.8087],[0.3302,52.8116],[0.3819,52.8252],[0.4316,52.8582],[0.5155,52.9384],[0.5588,52.9669],[0.7045,52.9772],[0.8268,52.9711],[0.9485,52.9534],[1.0556,52.959],[1.2713,52.9246],[1.3821,52.8935],[1.6567,52.7537],[1.7161,52.6772],[1.7434,52.5785],[1.7466,52.469],[1.7004,52.3689],[1.6474,52.2785],[1.6146,52.1618],[1.5914,52.1198],[1.559,52.0869],[1.4135,51.9948],[1.3168,51.9569],[1.276,51.9735],[1.2324,51.9712],[1.2278,51.9491],[1.2738,51.9021],[1.2744,51.8454],[1.1885,51.8034],[1.1012,51.7854],[0.9551,51.8078],[0.7522,51.7296],[0.898,51.6894],[0.9274,51.6466],[0.8909,51.5714],[0.7992,51.5379],[0.6976,51.523],[0.5935,51.5195],[0.5072,51.5011],[0.4245,51.4656],[0.5283,51.4845],[0.6003,51.468],[0.6455,51.4047],[0.6865,51.3866],[0.8894,51.3595],[1.0149,51.3597],[1.2571,51.3751],[1.3734,51.3747],[1.4149,51.3633],[1.4156,51.3108],[1.3976,51.182],[1.3655,51.1555],[1.0444,51.0473],[0.9786,50.9717],[0.9602,50.9259],[0.7724,50.934],[0.6844,50.8855],[0.5323,50.8534],[0.4147,50.8192],[0.2997,50.776],[0.2051,50.763],[-0.2039,50.8144],[-0.4508,50.8102],[-0.7853,50.7654],[-0.8714,50.7728],[-1.0006,50.8156],[-1.1329,50.8446],[-1.2851,50.8573],[-1.4165,50.8969],[-1.3345,50.8208],[-1.5167,50.7475],[-1.6008,50.7329],[-1.6879,50.7352],[-1.866,50.7152],[-2.0311,50.7254],[-2.0062,50.6732],[-1.9621,50.6278],[-1.9979,50.608],[-2.0358,50.6031],[-2.3501,50.6374],[-2.3947,50.6309],[-2.4334,50.5992],[-2.5478,50.6163],[-2.6588,50.6697],[-2.777,50.7056],[-2.9009,50.7224],[-2.9994,50.7166],[-3.4046,50.6324],[-3.4854,50.5479],[-3.5259,50.4282],[-3.5844,50.3218],[-3.6798,50.2399],[-3.7934,50.2292],[-3.9002,50.2859],[-4.1034,50.3485],[-4.1726,50.3908],[-4.1946,50.3933],[-4.2173,50.3782],[-4.297,50.3591],[-4.3795,50.3582],[-4.5067,50.3414],[-4.728,50.2905],[-4.8174,50.256],[-5.0095,50.1607],[-5.0486,50.1344],[-5.1185,50.0383],[-5.2252,50.0214],[-5.3229,50.083],[-5.434,50.1044],[-5.5512,50.0834],[-5.6221,50.0507],[-5.6552,50.0772],[-5.6562,50.1319],[-5.5707,50.197],[-5.3423,50.2461],[-5.1418,50.3737],[-5.0435,50.4515],[-5.0044,50.4953],[-4.9564,50.5231],[-4.8936,50.5337],[-4.8613,50.582],[-4.5829,50.7764],[-4.56,50.8209],[-4.5461,50.9007],[-4.5231,50.9774],[-4.2965,51.0271],[-4.1882,51.1885],[-4.1584,51.2013],[-3.8423,51.2309],[-3.6079,51.2286],[-3.3751,51.197],[-3.2558,51.1941],[-3.136,51.205],[-3.042,51.2486],[-2.8812,51.4057],[-2.7908,51.4748],[-2.6872,51.5373],[-2.5903,51.6086],[-2.4331,51.7407],[-2.5394,51.6952],[-2.6677,51.623],[-2.7421,51.5811],[-2.9785,51.5389],[-3.0804,51.4958],[-3.2588,51.3985],[-3.2931,51.3904],[-3.5624,51.4138],[-3.7627,51.5399],[-3.8908,51.5917],[-3.9437,51.5975],[-3.9983,51.5821],[-4.1153,51.5664],[-4.2346,51.5691],[-4.1737,51.6273],[-4.091,51.6599],[-4.2762,51.6825],[-4.3276,51.7002],[-4.3863,51.7411],[-4.5315,51.748],[-4.6008,51.7376],[-4.7176,51.6837],[-4.9023,51.6263],[-5.1248,51.7059],[-5.1684,51.7407],[-5.1672,51.8081],[-5.2006,51.8614],[-5.2623,51.8802],[-5.1833,51.9497],[-5.0881,51.9959],[-4.8785,52.0418],[-4.5611,52.1509],[-4.3832,52.1973],[-4.2177,52.2774],[-4.1494,52.3263],[-4.0998,52.3931],[-4.0505,52.4751],[-3.9803,52.5417],[-4.0484,52.5576],[-4.0789,52.6079],[-4.0707,52.6588],[-4.0393,52.7041],[-4.0674,52.7607],[-4.1175,52.82],[-4.1147,52.8662],[-4.1015,52.9155],[-4.2292,52.9128],[-4.3564,52.8974],[-4.4718,52.8625],[-4.5837,52.8149],[-4.6831,52.8062],[-4.6814,52.8441],[-4.6383,52.8911],[-4.5257,52.9582],[-4.4051,53.0138],[-4.3622,53.0561],[-4.3284,53.1051],[-4.2686,53.1445],[-4.111,53.2189],[-3.8093,53.3027],[-3.7642,53.3076],[-3.6459,53.2979],[-3.5296,53.3105],[-3.4277,53.3407],[-3.3262,53.3472],[-3.0976,53.2603],[-3.1656,53.3947],[-3.0647,53.4269],[-2.9186,53.3054],[-2.8642,53.2926],[-2.7495,53.3102],[-2.7937,53.3307],[-2.8454,53.3319],[-2.9131,53.3502],[-2.97,53.3892],[-3.0646,53.5128],[-3.0595,53.5862],[-2.9957,53.6625],[-2.9251,53.7328],[-2.9843,53.7467],[-3.0318,53.7736],[-3.0454,53.8438],[-3.0268,53.9059],[-2.8999,53.9607],[-2.8624,54.0438],[-2.8465,54.1353],[-2.8676,54.1772],[-2.9935,54.1705],[-3.0547,54.1534],[-3.1097,54.1263],[-3.166,54.1279],[-3.3215,54.2291],[-3.4103,54.3056],[-3.5694,54.4676],[-3.592,54.5644],[-3.4646,54.7731],[-3.2679,54.9066],[-3.0362,54.9531],[-3.0811,54.962],[-3.4341,54.9638],[-3.5504,54.9474],[-3.6583,54.8929],[-3.7192,54.8761],[-3.7833,54.8699],[-3.8416,54.8428],[-3.8986,54.8051],[-3.9579,54.781],[-4.0758,54.7872],[-4.133,54.7792],[-4.174,54.8011],[-4.2084,54.8372],[-4.2534,54.8468],[-4.3037,54.8357],[-4.4099,54.7871],[-4.5175,54.7583],[-4.6476,54.789],[-4.8181,54.8461],[-4.8517,54.8253],[-4.8895,54.7723],[-4.9112,54.6895],[-5.0323,54.7614],[-5.1355,54.8575],[-5.1701,54.9179],[-5.1727,54.9859],[-5.1167,55.0123],[-5.0559,54.9881],[-4.9652,55.1495],[-4.7848,55.3594],[-4.7211,55.421],[-4.6768,55.5013],[-4.6844,55.5539],[-4.7242,55.5983],[-4.8918,55.6991],[-4.8896,55.7812],[-4.8717,55.8739],[-4.8261,55.9295],[-4.8068,55.9401],[-4.5841,55.9387],[-4.6709,55.9674],[-4.8441,56.0512],[-4.841,56.0809],[-4.8003,56.1583],[-4.8191,56.1505],[-4.8562,56.1147],[-4.9271,56.0281],[-4.9704,56.0079],[-5.0928,55.9873],[-5.115,55.9446],[-5.1347,55.9335],[-5.1958,55.9287],[-5.2146,55.8889],[-5.2282,55.8863],[-5.2456,55.9292],[-5.2473,56.0004],[-5.2229,56.0658],[-5.1764,56.117],[-4.997,56.2333],[-5.0843,56.1975],[-5.2823,56.0899],[-5.3834,56.0192],[-5.4104,55.9954],[-5.4189,55.9752],[-5.4183,55.9521],[-5.3729,55.8277],[-5.3858,55.7701],[-5.5564,55.3896],[-5.5888,55.3514],[-5.6185,55.3314],[-5.6465,55.3269],[-5.7307,55.3341],[-5.7682,55.3626],[-5.7679,55.395],[-5.7521,55.4435],[-5.6813,55.624],[-5.6506,55.6741],[-5.605,55.7208],[-5.5045,55.8024],[-5.5069,55.8077],[-5.5739,55.7917],[-5.6024,55.797],[-5.6229,55.8131],[-5.6096,56.0553],[-5.5553,56.135],[-5.535,56.2508],[-5.4879,56.35],[-5.4334,56.4223],[-5.3919,56.5148],[-5.3294,56.5559],[-5.3127,56.6188],[-5.2426,56.6869],[-5.1884,56.7581],[-5.2176,56.751],[-5.5642,56.5657],[-5.6524,56.532],[-5.7728,56.541],[-5.8648,56.5619],[-5.9368,56.6057],[-5.9689,56.6899],[-6.0577,56.6921],[-6.1337,56.7067],[-6.1328,56.718],[-6.0347,56.7639],[-5.8776,56.7796],[-5.7306,56.8531],[-5.8614,56.9027],[-5.8504,56.9184],[-5.7363,56.9606],[-5.5913,57.1023],[-5.5619,57.2327],[-5.6313,57.2939],[-5.6563,57.3341],[-5.7949,57.3788],[-5.8181,57.4361],[-5.802,57.468],[-5.7567,57.4992],[-5.6886,57.5235],[-5.5818,57.5468],[-5.6788,57.5717],[-5.7149,57.6011],[-5.7424,57.6437],[-5.7449,57.6683],[-5.6947,57.7782],[-5.6655,57.8235],[-5.6083,57.8813],[-5.349,57.8781],[-5.3192,57.9036],[-5.2898,57.9046],[-5.1572,57.8813],[-5.1769,57.9064],[-5.3937,58.0436],[-5.4132,58.0697],[-5.3514,58.1437],[-5.3469,58.1767],[-5.356,58.2119],[-5.3383,58.2387],[-5.2695,58.2514],[-5.06,58.2501],[-5.0083,58.2626],[-5.0318,58.2983],[-5.0806,58.3452],[-5.0901,58.3845],[-5.0787,58.4193],[-5.076,58.4893],[-5.0665,58.5202],[-5.0167,58.5666],[-4.9756,58.5803],[-4.9247,58.5884],[-4.8096,58.5729],[-4.7658,58.5542],[-4.7154,58.51],[-4.6782,58.5136],[-4.535,58.5616],[-4.4919,58.5685],[-4.4333,58.5128],[-4.1886,58.5572],[-3.8595,58.5771],[-3.6618,58.6063],[-3.4536,58.6169],[-3.2591,58.65],[-3.0531,58.6348],[-3.0462,58.6155],[-3.057,58.5888],[-3.1097,58.5155]],[[-2.9294,58.7416],[-2.939,58.7386],[-2.9754,58.7569],[-3.0354,58.8227],[-2.9412,58.8357],[-2.8964,58.8276],[-2.9131,58.7996],[-2.9294,58.7416]],[[-3.1649,58.7942],[-3.2221,58.781],[-3.2788,58.7819],[-3.3672,58.8397],[-3.4008,58.8818],[-3.3947,58.9096],[-3.3574,58.919],[-3.2719,58.9053],[-3.2276,58.8572],[-3.2221,58.8259],[-3.2116,58.8136],[-3.1585,58.8012],[-3.1649,58.7942]],[[-3.0574,59.0296],[-3.0707,59.005],[-2.9947,59.0056],[-2.8846,58.9845],[-2.8179,58.9819],[-2.7625,58.9558],[-2.793,58.9069],[-2.8262,58.8933],[-2.8638,58.8905],[-2.9948,58.9394],[-3.1666,58.9191],[-3.2008,58.9253],[-3.2233,58.9388],[-3.2326,58.9555],[-3.2328,58.9896],[-3.2421,58.9997],[-3.3043,58.9674],[-3.3316,58.9712],[-3.3471,58.9867],[-3.3537,59.0187],[-3.3468,59.065],[-3.3104,59.1308],[-3.2486,59.1439],[-3.1565,59.1363],[-3.0511,59.099],[-3.0192,59.076],[-3.02,59.0577],[-3.0574,59.0296]],[[-2.5489,59.2313],[-2.6621,59.2302],[-2.6036,59.2893],[-2.5356,59.3042],[-2.407,59.2976],[-2.4298,59.271],[-2.5489,59.2313]],[[-2.7294,59.1868],[-2.8152,59.1619],[-2.8519,59.1825],[-2.8614,59.2468],[-2.9638,59.2744],[-3.0135,59.2915],[-3.0521,59.3239],[-3.0422,59.3338],[-2.9755,59.3471],[-2.8616,59.2883],[-2.815,59.2408],[-2.7307,59.2268],[-2.7199,59.2195],[-2.7294,59.1868]],[[-1.3081,60.5375],[-1.2874,60.467],[-1.2357,60.4853],[-1.1578,60.4177],[-1.118,60.4176],[-1.0524,60.4445],[-1.0657,60.3816],[-1.1337,60.207],[-1.1528,60.1773],[-1.1657,60.1243],[-1.1792,60.1139],[-1.1993,60.0066],[-1.2453,59.9712],[-1.2838,59.8869],[-1.2995,59.8787],[-1.3559,59.9111],[-1.2995,60.0398],[-1.2762,60.1146],[-1.2909,60.1535],[-1.3228,60.1884],[-1.409,60.1895],[-1.4815,60.1734],[-1.4969,60.194],[-1.4991,60.2218],[-1.5166,60.231],[-1.613,60.2291],[-1.6414,60.2368],[-1.6601,60.2623],[-1.6638,60.2825],[-1.5767,60.2984],[-1.4944,60.2925],[-1.3746,60.3329],[-1.4496,60.4686],[-1.5488,60.4813],[-1.5718,60.4944],[-1.5526,60.5174],[-1.4981,60.5298],[-1.4142,60.5987],[-1.364,60.6096],[-1.3017,60.6077],[-1.3081,60.5375]],[[-1.0425,60.5139],[-1.0679,60.5023],[-1.1655,60.6039],[-1.0933,60.7202],[-1.0056,60.7165],[-0.9917,60.686],[-1.0003,60.658],[-1.045,60.6555],[-1.049,60.6469],[-1.0351,60.5929],[-1.0342,60.5302],[-1.0425,60.5139]],[[-0.7743,60.812],[-0.7743,60.8005],[-0.8262,60.7162],[-0.8255,60.6839],[-0.9091,60.687],[-0.9223,60.6973],[-0.9381,60.7457],[-0.9275,60.7972],[-0.9158,60.8104],[-0.8914,60.8159],[-0.8649,60.8058],[-0.8234,60.8319],[-0.8018,60.8313],[-0.7743,60.812]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"United Kingdom","sov_a3":"GB1","adm0_dif":1,"level":2,"type":"Country","admin":"United Kingdom","adm0_a3":"GBR","geou_dif":0,"geounit":"United Kingdom","gu_a3":"GBR","su_dif":0,"subunit":"United Kingdom","su_a3":"GBR","brk_diff":0,"name":"United Kingdom","name_long":"United Kingdom","brk_a3":"GBR","brk_name":"United Kingdom","brk_group":"","abbrev":"U.K.","postal":"GB","formal_en":"United Kingdom of Great Britain and Northern Ireland","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"United Kingdom","name_alt":"","mapcolor7":6,"mapcolor8":6,"mapcolor9":6,"mapcolor13":3,"pop_est":62262000,"gdp_md_est":1977704,"pop_year":0,"lastcensus":2011,"gdp_year":2009,"economy":"1. Developed region: G7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"GB","iso_a3":"GBR","iso_n3":"826","un_a3":"826","wb_a2":"GB","wb_a3":"GBR","woe_id":-99,"adm0_a3_is":"GBR","adm0_a3_us":"GBR","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Northern Europe","region_wb":"Europe & Central Asia","name_len":14,"long_len":14,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[-6.6995,61.4446],[-6.6797,61.4143],[-6.703,61.4177],[-6.7705,61.4522],[-6.8881,61.5348],[-6.9292,61.6029],[-6.9349,61.6343],[-6.9059,61.6308],[-6.8816,61.6028],[-6.77,61.5844],[-6.7406,61.5705],[-6.7411,61.5364],[-6.7035,61.4959],[-6.6995,61.4446]],[[-6.6232,61.806],[-6.6428,61.7683],[-6.6702,61.7687],[-6.7643,61.8153],[-6.8392,61.8408],[-6.864,61.8623],[-6.8848,61.8991],[-6.8418,61.9037],[-6.7908,61.8954],[-6.6621,61.8618],[-6.6258,61.8267],[-6.6232,61.806]],[[-7.1869,62.1393],[-7.0971,62.1005],[-7.0652,62.0732],[-7.1168,62.0468],[-7.1794,62.04],[-7.2549,62.0461],[-7.3791,62.0748],[-7.4226,62.1403],[-7.3368,62.1387],[-7.2353,62.1512],[-7.1869,62.1393]],[[-6.6311,62.2279],[-6.6558,62.0936],[-6.6964,62.0943],[-6.7689,62.1315],[-6.8234,62.1391],[-6.8405,62.1193],[-6.8377,62.0954],[-6.8095,62.0804],[-6.7226,61.9904],[-6.7144,61.9642],[-6.7252,61.9515],[-6.8097,61.9774],[-7.0136,62.094],[-7.1722,62.2856],[-6.9586,62.3163],[-6.8037,62.266],[-6.6311,62.2279]],[[-6.4061,62.2586],[-6.4539,62.1865],[-6.5247,62.1979],[-6.5441,62.2056],[-6.5595,62.2245],[-6.5521,62.2781],[-6.5546,62.3557],[-6.473,62.2919],[-6.4061,62.2586]]]},"properties":{"scalerank":3,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Denmark","sov_a3":"DN1","adm0_dif":1,"level":2,"type":"Dependency","admin":"Faroe Islands","adm0_a3":"FRO","geou_dif":0,"geounit":"Faroe Islands","gu_a3":"FRO","su_dif":0,"subunit":"Faroe Islands","su_a3":"FRO","brk_diff":0,"name":"Faeroe Is.","name_long":"Faeroe Islands","brk_a3":"FRO","brk_name":"Faeroe Islands","brk_group":"","abbrev":"Faeroe Is.","postal":"FO","formal_en":"Føroyar Is. (Faeroe Is.)","formal_fr":"","note_adm0":"Den.","note_brk":"","name_sort":"Faeroe Islands","name_alt":"","mapcolor7":4,"mapcolor8":1,"mapcolor9":3,"mapcolor13":12,"pop_est":48856,"gdp_md_est":1000,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"FO","iso_a3":"FRO","iso_n3":"234","un_a3":"234","wb_a2":"FO","wb_a3":"FRO","woe_id":-99,"adm0_a3_is":"FRO","adm0_a3_us":"FRO","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Northern Europe","region_wb":"Europe & Central Asia","name_len":10,"long_len":14,"abbrev_len":10,"tiny":3,"homepart":-99}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[21.6283,60.1078],[21.5406,60.0979],[21.486,60.1268],[21.5067,60.1483],[21.568,60.1723],[21.6341,60.169],[21.6481,60.1409],[21.6283,60.1078]],[[21.8332,60.1405],[21.7331,60.1062],[21.695,60.1144],[21.7048,60.1723],[21.7643,60.1988],[21.8644,60.2018],[21.8332,60.1405]],[[22.1751,60.3708],[22.3018,60.3476],[22.355,60.3559],[22.4155,60.3034],[22.3129,60.27],[22.3058,60.2286],[22.3463,60.2028],[22.3605,60.1656],[22.2583,60.1656],[22.2094,60.197],[22.1881,60.2368],[22.1405,60.2649],[22.0771,60.2863],[22.1082,60.3149],[22.1259,60.3559],[22.1751,60.3708]],[[21.9942,60.3367],[21.9215,60.3323],[21.8187,60.3818],[21.8057,60.4012],[21.846,60.4125],[21.8193,60.4523],[21.8272,60.4699],[21.9068,60.4385],[21.9503,60.4017],[21.9078,60.3932],[21.9798,60.3552],[21.9942,60.3367]],[[21.4509,60.5296],[21.4369,60.4831],[21.369,60.4882],[21.3,60.4798],[21.2443,60.526],[21.2146,60.6039],[21.2247,60.6206],[21.2681,60.6383],[21.3013,60.5956],[21.4509,60.5296]],[[21.2178,63.2413],[21.2285,63.2227],[21.2871,63.2278],[21.366,63.2618],[21.422,63.2459],[21.4156,63.1974],[21.3776,63.1992],[21.3672,63.2072],[21.3185,63.1795],[21.3098,63.1627],[21.2534,63.152],[21.1493,63.1995],[21.0839,63.2775],[21.2363,63.2777],[21.2218,63.2591],[21.2178,63.2413]],[[24.8482,64.991],[24.6989,64.9578],[24.5786,64.9786],[24.5766,65.0429],[24.6512,65.074],[24.786,65.0864],[24.9706,65.0553],[24.9976,65.0387],[24.8918,65.0263],[24.8482,64.991]],[[28.0473,69.9717],[28.2691,69.8714],[28.4117,69.8228],[28.8004,69.7315],[29.1416,69.6714],[29.3334,69.473],[29.2389,69.3939],[29.1918,69.3667],[29.0249,69.288],[28.8463,69.1769],[28.8326,69.119],[28.8919,69.0606],[28.9658,69.022],[28.8989,69.0097],[28.6922,68.961],[28.566,68.9282],[28.4141,68.9042],[28.4535,68.8723],[28.706,68.8655],[28.7448,68.8564],[28.7729,68.84],[28.7776,68.8138],[28.7521,68.7714],[28.4793,68.5376],[28.4707,68.4884],[28.5602,68.3514],[28.6852,68.1898],[29.063,68.118],[29.3438,68.0619],[29.5242,67.9291],[29.8216,67.754],[29.9792,67.6886],[29.9881,67.6683],[29.9412,67.5475],[29.7506,67.4264],[29.5723,67.3244],[29.3877,67.2014],[29.2434,67.0966],[29.087,66.9709],[29.069,66.9302],[29.0662,66.8917],[29.0931,66.8492],[29.2933,66.6955],[29.3712,66.617],[29.4644,66.5322],[29.5443,66.4397],[29.5907,66.3568],[29.6709,66.2761],[29.7207,66.2349],[29.8035,66.1771],[29.9034,66.0911],[29.9366,66.0229],[30.0875,65.7865],[30.1027,65.7263],[30.0953,65.6817],[30.029,65.6707],[29.8826,65.6636],[29.7239,65.6344],[29.7159,65.6246],[29.8194,65.5688],[29.728,65.4734],[29.7148,65.337],[29.6172,65.2653],[29.608,65.2487],[29.6124,65.2348],[29.6297,65.2239],[29.8105,65.2047],[29.8262,65.1853],[29.827,65.1451],[29.8108,65.1079],[29.72,65.0803],[29.6225,65.0395],[29.6009,65.002],[29.6042,64.9684],[29.6375,64.9118],[29.7017,64.8458],[29.7832,64.8043],[30.0729,64.765],[30.1103,64.7326],[30.1262,64.6881],[30.1201,64.6446],[29.9855,64.5577],[29.9866,64.5243],[30.0419,64.4434],[30.1081,64.3661],[30.3906,64.2824],[30.4879,64.2365],[30.5138,64.2],[30.5279,64.1411],[30.5261,64.0773],[30.5039,64.0206],[30.4153,63.9475],[30.2103,63.8033],[30.0041,63.7473],[29.9915,63.7352],[30.0554,63.689],[30.4186,63.5041],[30.6553,63.4175],[30.9748,63.3006],[31.1809,63.2083],[31.2475,63.1419],[31.3367,63.0681],[31.437,63.0077],[31.5093,62.9553],[31.5365,62.9216],[31.534,62.8854],[31.4373,62.7761],[31.3824,62.6917],[31.2856,62.5678],[31.1867,62.4814],[30.9357,62.3238],[30.5656,62.1276],[30.4797,62.0682],[30.3064,61.9648],[30.01,61.7574],[29.9332,61.7116],[29.6901,61.5461],[29.5794,61.4935],[29.4924,61.4442],[29.2517,61.2878],[28.993,61.169],[28.7391,61.0587],[28.6629,61.0028],[28.5682,60.9602],[28.4551,60.9196],[28.4074,60.8969],[28.152,60.7458],[27.7977,60.5361],[27.7616,60.5329],[27.6693,60.499],[27.5251,60.4908],[27.4624,60.4648],[27.2419,60.5387],[27.2053,60.5435],[27.0756,60.5251],[26.9512,60.4715],[26.7215,60.4551],[26.6074,60.4377],[26.5347,60.4129],[26.5197,60.4716],[26.5512,60.546],[26.6018,60.5956],[26.6064,60.6279],[26.5693,60.6246],[26.4958,60.5518],[26.4564,60.4668],[26.3777,60.4241],[26.2047,60.4066],[26.036,60.4749],[25.956,60.4742],[26.0063,60.4253],[26.0402,60.3716],[26.0358,60.3415],[25.9459,60.3468],[25.8458,60.3146],[25.758,60.2675],[25.7154,60.2674],[25.6564,60.3332],[25.5482,60.3025],[25.4558,60.2612],[25.2679,60.2483],[25.1559,60.1941],[24.9576,60.1575],[24.8487,60.1583],[24.6005,60.1143],[24.518,60.0463],[24.4456,60.0213],[24.3426,60.0423],[24.0252,60.0092],[23.7218,59.9657],[23.5927,59.9682],[23.4636,59.9862],[23.3268,59.9258],[23.1814,59.8449],[23.0213,59.816],[22.9639,59.8264],[23.0098,59.8688],[23.1157,59.9127],[23.1885,59.9722],[23.1984,60.0218],[23.1484,60.0413],[23.0802,60.0473],[22.9941,60.0985],[22.9117,60.2097],[22.8671,60.2158],[22.8444,60.1866],[22.8191,60.1014],[22.7935,60.0768],[22.7498,60.0573],[22.6974,60.0376],[22.6462,60.028],[22.4627,60.0292],[22.4386,60.0723],[22.4386,60.0903],[22.4711,60.147],[22.4427,60.1569],[22.4697,60.2013],[22.513,60.1989],[22.5643,60.2055],[22.5899,60.2284],[22.588,60.2557],[22.5167,60.2627],[22.5123,60.2813],[22.5759,60.3591],[22.585,60.3806],[22.5604,60.385],[22.5205,60.3766],[22.2579,60.4009],[21.934,60.5003],[21.8543,60.5054],[21.8053,60.5941],[21.7271,60.5829],[21.6133,60.531],[21.5278,60.5704],[21.436,60.5964],[21.4106,60.637],[21.4119,60.6968],[21.404,60.7674],[21.3789,60.85],[21.3605,60.9675],[21.3777,61.0592],[21.451,61.1271],[21.4791,61.1705],[21.5135,61.2812],[21.5212,61.4108],[21.5018,61.455],[21.5066,61.4843],[21.565,61.4843],[21.5523,61.5095],[21.5267,61.5233],[21.4982,61.552],[21.5225,61.5671],[21.5924,61.5682],[21.598,61.5779],[21.606,61.5916],[21.5519,61.6668],[21.5456,61.7027],[21.4705,61.8117],[21.3849,61.9149],[21.256,61.9896],[21.3017,62.1126],[21.3537,62.2238],[21.3434,62.2774],[21.3234,62.3426],[21.1656,62.4141],[21.1422,62.5148],[21.1036,62.6229],[21.1182,62.6893],[21.1438,62.74],[21.1957,62.7905],[21.4575,62.95],[21.4735,63.0333],[21.651,63.0393],[21.5687,63.1137],[21.5492,63.1555],[21.5451,63.2043],[21.8004,63.2377],[21.8957,63.2103],[22.1203,63.2441],[22.3197,63.3104],[22.3162,63.3457],[22.2855,63.3772],[22.2433,63.4379],[22.2732,63.4548],[22.346,63.4424],[22.3126,63.4726],[22.3187,63.5044],[22.398,63.4912],[22.5276,63.58],[22.5323,63.6479],[22.7563,63.6833],[23.0145,63.8218],[23.1336,63.8649],[23.2487,63.8961],[23.4939,64.0345],[23.5989,64.0409],[23.6529,64.1342],[23.8614,64.2583],[23.9248,64.2741],[24.0223,64.386],[24.2783,64.5153],[24.4406,64.6801],[24.5302,64.7387],[24.5579,64.801],[24.6576,64.8063],[24.7476,64.8521],[24.9422,64.884],[25.1343,64.8752],[25.2143,64.8535],[25.2882,64.8604],[25.2808,64.9164],[25.228,64.951],[25.2711,64.9843],[25.3727,65.0095],[25.3623,65.0651],[25.3402,65.0986],[25.2559,65.1433],[25.2979,65.2432],[25.3079,65.3527],[25.3479,65.4792],[25.2418,65.5463],[24.8394,65.6604],[24.7643,65.6564],[24.6749,65.6707],[24.5815,65.7571],[24.6232,65.8317],[24.628,65.8592],[24.5916,65.8583],[24.5326,65.822],[24.4043,65.7805],[24.2375,65.8124],[24.1555,65.8053],[24.049,65.9898],[23.9946,66.0604],[23.9073,66.1482],[23.7515,66.1912],[23.721,66.2154],[23.7003,66.2526],[23.6936,66.3043],[23.6738,66.3807],[23.682,66.4434],[23.7012,66.4808],[23.7684,66.5059],[23.8655,66.5766],[23.8858,66.628],[23.8941,66.7069],[23.9389,66.7757],[23.9886,66.8105],[23.9761,66.8382],[23.9418,66.8778],[23.8693,66.934],[23.759,67.0026],[23.6773,67.0681],[23.6415,67.1294],[23.623,67.1841],[23.6261,67.2339],[23.6566,67.2678],[23.7609,67.3105],[23.7749,67.3286],[23.7336,67.4229],[23.6608,67.44],[23.5371,67.4492],[23.4681,67.45],[23.4549,67.4603],[23.4515,67.4792],[23.4654,67.5179],[23.5045,67.5622],[23.537,67.5904],[23.5413,67.6143],[23.5002,67.6962],[23.4878,67.7966],[23.5019,67.8752],[23.6329,67.9332],[23.6389,67.9544],[23.4742,68.0173],[23.3555,68.0887],[23.3186,68.1303],[23.1825,68.1366],[23.0979,68.2576],[22.9754,68.3165],[22.8541,68.3673],[22.7824,68.391],[22.3621,68.4641],[22.1951,68.478],[21.9975,68.5206],[21.8502,68.5741],[21.724,68.6085],[21.616,68.651],[21.4654,68.6907],[21.4224,68.7246],[21.2598,68.7875],[21.1834,68.8288],[20.9186,68.9069],[20.909,68.9377],[20.907,68.9675],[20.8951,68.9798],[20.6222,69.0369],[20.6759,69.0695],[20.8893,69.0714],[21.0657,69.0417],[21.1045,69.0544],[21.1278,69.0808],[21.0526,69.1866],[21.0661,69.2141],[21.1438,69.2473],[21.2668,69.2737],[21.4612,69.2775],[21.5938,69.2736],[21.6218,69.2707],[21.8197,69.1545],[21.9895,69.0411],[22.0797,68.9928],[22.3004,68.8559],[22.3829,68.7766],[22.4109,68.7199],[22.5007,68.7202],[22.811,68.6953],[23.0717,68.6744],[23.1443,68.6426],[23.324,68.649],[23.4625,68.6776],[23.707,68.7139],[23.7726,68.7584],[23.854,68.8059],[23.9974,68.7984],[24.1541,68.7609],[24.332,68.7115],[24.4905,68.6887],[24.7032,68.6528],[24.8024,68.6065],[24.9414,68.5933],[25.0869,68.6396],[25.1729,68.7653],[25.2491,68.8213],[25.3571,68.8625],[25.4809,68.8806],[25.5753,68.8872],[25.6467,68.9191],[25.7483,68.9901],[25.7682,69.0761],[25.7486,69.2314],[25.7672,69.2827],[25.8502,69.3665],[25.9615,69.5886],[26.0115,69.6526],[26.0725,69.6916],[26.1562,69.7147],[26.3082,69.7819],[26.5254,69.915],[26.5843,69.9263],[26.7402,69.9331],[26.9343,69.9281],[27.1087,69.9047],[27.1275,69.9065],[27.2057,69.9187],[27.348,69.9601],[27.5917,70.0422],[27.7479,70.0648],[27.8899,70.0617],[28.0473,69.9717]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Finland","sov_a3":"FI1","adm0_dif":1,"level":2,"type":"Country","admin":"Finland","adm0_a3":"FIN","geou_dif":0,"geounit":"Finland","gu_a3":"FIN","su_dif":0,"subunit":"Finland","su_a3":"FIN","brk_diff":0,"name":"Finland","name_long":"Finland","brk_a3":"FIN","brk_name":"Finland","brk_group":"","abbrev":"Fin.","postal":"FIN","formal_en":"Republic of Finland","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Finland","name_alt":"","mapcolor7":4,"mapcolor8":1,"mapcolor9":4,"mapcolor13":6,"pop_est":5250275,"gdp_md_est":193500,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"FI","iso_a3":"FIN","iso_n3":"246","un_a3":"246","wb_a2":"FI","wb_a3":"FIN","woe_id":-99,"adm0_a3_is":"FIN","adm0_a3_us":"FIN","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Northern Europe","region_wb":"Europe & Central Asia","name_len":7,"long_len":7,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[22.6174,58.6212],[22.6884,58.597],[22.7538,58.6047],[22.8201,58.6215],[22.9643,58.6057],[23.2929,58.4835],[23.3232,58.4508],[23.1271,58.436],[23.0826,58.3985],[23.0354,58.3723],[22.9799,58.3639],[22.8852,58.3113],[22.757,58.2609],[22.7303,58.2307],[22.4984,58.2362],[22.3717,58.2171],[22.2693,58.1607],[22.2273,58.0518],[22.1524,57.9668],[22.0763,57.936],[21.9969,57.9313],[21.978,57.9633],[21.9855,57.9952],[22.1529,58.1153],[22.1877,58.1543],[22.1044,58.1717],[22.0346,58.2134],[21.8821,58.2624],[21.8545,58.3017],[21.891,58.3046],[21.9244,58.3159],[21.965,58.3488],[21.9841,58.3867],[21.8623,58.4972],[21.9244,58.5143],[22.0019,58.5103],[22.0813,58.4781],[22.1686,58.5158],[22.2056,58.5214],[22.2666,58.508],[22.3281,58.5809],[22.4744,58.6049],[22.547,58.6274],[22.6174,58.6212]],[[23.3436,58.5503],[23.2604,58.54],[23.0635,58.6111],[23.1091,58.6592],[23.1654,58.6781],[23.3328,58.6486],[23.3564,58.5755],[23.3436,58.5503]],[[22.9237,58.8269],[22.8417,58.7774],[22.7929,58.7972],[22.7673,58.8209],[22.6614,58.7092],[22.5422,58.69],[22.4727,58.7121],[22.4789,58.7538],[22.411,58.8634],[22.3074,58.8955],[22.1619,58.8985],[22.0563,58.9436],[22.4626,58.9743],[22.5046,59.0265],[22.5872,59.0812],[22.6494,59.0871],[22.7022,59.0744],[22.7122,59.032],[22.7255,59.0151],[22.9099,58.9912],[22.9816,58.9198],[23.0087,58.8339],[22.9237,58.8269]],[[25.5093,59.639],[25.6157,59.6275],[25.7938,59.6347],[26.4608,59.5539],[26.625,59.5539],[26.8521,59.4718],[26.9747,59.4506],[27.3358,59.4505],[27.8926,59.4142],[28.0019,59.4698],[28.0125,59.4843],[28.0658,59.4532],[28.133,59.4031],[28.1511,59.3744],[28.1283,59.3576],[28.0613,59.3433],[28.0461,59.3278],[28.0164,59.3017],[27.9382,59.297],[27.8977,59.2776],[27.8495,59.1927],[27.7576,59.052],[27.6218,58.945],[27.5131,58.8863],[27.4645,58.8413],[27.4342,58.7873],[27.4271,58.7331],[27.5313,58.4353],[27.5301,58.3815],[27.5056,58.3263],[27.4878,58.2701],[27.5024,58.2213],[27.5711,58.1381],[27.6441,58.0139],[27.6734,57.9346],[27.722,57.9055],[27.7688,57.8841],[27.7785,57.8707],[27.777,57.8567],[27.7528,57.841],[27.5421,57.7994],[27.5147,57.7642],[27.492,57.725],[27.4,57.6668],[27.3718,57.6125],[27.3543,57.5503],[27.352,57.5281],[27.3266,57.5255],[27.1871,57.5383],[27.0334,57.5788],[26.966,57.6091],[26.8998,57.6088],[26.8197,57.5887],[26.5326,57.531],[26.4621,57.5445],[26.298,57.6011],[26.215,57.6627],[26.0304,57.7855],[26.0152,57.8147],[25.9911,57.8382],[25.7938,57.8686],[25.7209,57.9138],[25.6602,57.9202],[25.5713,57.9428],[25.34,58.0395],[25.2826,58.0485],[25.2687,58.0322],[25.2727,58.0094],[25.2583,57.9961],[25.2287,57.9966],[25.1752,58.0321],[25.111,58.0634],[24.9113,58.0046],[24.8391,57.9887],[24.7758,57.9853],[24.4589,57.9079],[24.3625,57.8662],[24.3226,57.8706],[24.332,57.9098],[24.4639,58.106],[24.4875,58.2616],[24.5357,58.283],[24.5497,58.3046],[24.5291,58.3542],[24.3922,58.3861],[24.3369,58.3814],[24.2872,58.328],[24.2356,58.2896],[24.1148,58.2661],[24.0109,58.3066],[23.7676,58.3608],[23.7061,58.433],[23.6915,58.5056],[23.5628,58.5758],[23.5093,58.6585],[23.5307,58.7163],[23.6475,58.7542],[23.6808,58.7872],[23.5336,58.7819],[23.5036,58.7898],[23.4972,58.8195],[23.432,58.9207],[23.4896,58.9605],[23.515,58.9992],[23.4678,59.0322],[23.4802,59.0697],[23.517,59.1076],[23.4944,59.1957],[23.6405,59.2423],[23.7825,59.2751],[24.0834,59.2919],[24.0536,59.3723],[24.1754,59.3759],[24.3804,59.4727],[24.5836,59.4557],[24.8775,59.5221],[25.4438,59.5211],[25.5209,59.5595],[25.5074,59.598],[25.5093,59.639]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Estonia","sov_a3":"EST","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Estonia","adm0_a3":"EST","geou_dif":0,"geounit":"Estonia","gu_a3":"EST","su_dif":0,"subunit":"Estonia","su_a3":"EST","brk_diff":0,"name":"Estonia","name_long":"Estonia","brk_a3":"EST","brk_name":"Estonia","brk_group":"","abbrev":"Est.","postal":"EST","formal_en":"Republic of Estonia","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Estonia","name_alt":"","mapcolor7":3,"mapcolor8":2,"mapcolor9":1,"mapcolor13":10,"pop_est":1299371,"gdp_md_est":27410,"pop_year":-99,"lastcensus":2000,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"EE","iso_a3":"EST","iso_n3":"233","un_a3":"233","wb_a2":"EE","wb_a3":"EST","woe_id":-99,"adm0_a3_is":"EST","adm0_a3_us":"EST","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Northern Europe","region_wb":"Europe & Central Asia","name_len":7,"long_len":7,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[40.1412,15.6961],[40.1825,15.6429],[40.2114,15.6481],[40.2341,15.6659],[40.2501,15.7035],[40.4082,15.6292],[40.399,15.5799],[40.3047,15.5773],[40.1958,15.5981],[40.0951,15.5909],[39.9752,15.6125],[39.9475,15.6961],[40.0239,15.6556],[40.0635,15.6659],[40.0705,15.6766],[40.0163,15.7333],[39.9399,15.7445],[39.9452,15.7891],[39.9794,15.8066],[40.0005,15.8283],[39.9567,15.8894],[40.0426,15.8755],[40.0968,15.8385],[40.1324,15.7953],[40.1412,15.6961]],[[40.0765,16.0824],[40.1101,15.9857],[40.0124,16.0227],[39.9961,16.0427],[40.0391,16.081],[40.0481,16.1045],[40.0765,16.0824]],[[38.6095,18.0051],[38.9117,17.4271],[39.0345,17.0855],[39.1426,16.7292],[39.2226,16.1937],[39.2989,15.9211],[39.4223,15.7867],[39.5065,15.5321],[39.5788,15.5225],[39.6312,15.4525],[39.7208,15.2137],[39.7855,15.1249],[39.8194,15.2013],[39.8156,15.2453],[39.7903,15.3188],[39.8135,15.4136],[39.8638,15.4703],[39.9783,15.3931],[40.041,15.3345],[40.0578,15.2171],[40.0841,15.152],[40.2041,15.0141],[40.3053,14.974],[40.4365,14.964],[40.5463,14.9336],[40.6344,14.883],[40.7993,14.743],[41.1765,14.6203],[41.4797,14.2439],[41.6582,13.9831],[42.2451,13.5876],[42.3465,13.3981],[42.3993,13.2126],[42.5229,13.2215],[42.7345,13.0186],[42.7962,12.8643],[42.9695,12.8083],[42.999,12.8995],[43.0829,12.8246],[43.1167,12.7086],[43.0057,12.6623],[42.8833,12.6213],[42.8659,12.6228],[42.8253,12.5693],[42.7675,12.4229],[42.7037,12.3803],[42.6701,12.3766],[42.4794,12.5136],[42.45,12.5213],[42.4086,12.4944],[42.3785,12.4664],[42.2899,12.5702],[42.225,12.662],[42.1343,12.7714],[42.0466,12.8206],[41.9521,12.8823],[41.8596,13.0259],[41.765,13.1839],[41.625,13.3132],[41.3629,13.4998],[41.1224,13.7361],[40.9386,13.9831],[40.8201,14.1117],[40.7695,14.1445],[40.5244,14.2252],[40.3531,14.3381],[40.2215,14.4312],[40.1406,14.4561],[40.0621,14.4591],[39.8951,14.4407],[39.7562,14.499],[39.6979,14.499],[39.6049,14.5161],[39.5318,14.5367],[39.4461,14.5119],[39.2701,14.4703],[39.198,14.4794],[39.1586,14.5375],[39.1354,14.5819],[39.0742,14.6282],[39.0238,14.6282],[38.9957,14.5869],[38.812,14.4823],[38.5044,14.4244],[38.4314,14.4286],[38.377,14.4704],[38.2215,14.6497],[38.1771,14.6788],[38.142,14.6815],[38.0699,14.7027],[38.0025,14.7371],[37.9435,14.8105],[37.8842,14.8523],[37.8203,14.7085],[37.7084,14.4572],[37.6484,14.3226],[37.5712,14.1491],[37.5468,14.1438],[37.5072,14.1564],[37.3537,14.3725],[37.2572,14.4538],[37.1852,14.446],[37.1326,14.4061],[37.0994,14.334],[37.0635,14.2893],[37.0245,14.272],[36.9407,14.2806],[36.8119,14.315],[36.6791,14.3076],[36.5424,14.2582],[36.5243,14.2568],[36.4923,14.5443],[36.4708,14.7365],[36.4481,14.9401],[36.4268,15.1321],[36.5218,15.2501],[36.566,15.3621],[36.6792,15.7264],[36.7245,15.7989],[36.8135,15.9939],[36.8259,16.0503],[36.9138,16.2962],[36.9055,16.4595],[36.8878,16.6247],[36.9357,16.7224],[36.9787,16.8006],[36.9758,16.8666],[36.9952,17.0206],[37.009,17.0589],[37.0615,17.0613],[37.1695,17.0414],[37.2488,17.0569],[37.3404,17.0571],[37.411,17.0617],[37.4529,17.1087],[37.5102,17.2881],[37.5475,17.3241],[37.576,17.335],[37.6567,17.3683],[37.726,17.4205],[37.7824,17.458],[37.8033,17.4655],[37.863,17.4703],[37.9226,17.4923],[37.9501,17.5177],[38.0253,17.5378],[38.0989,17.5265],[38.1485,17.5485],[38.1815,17.5628],[38.219,17.564],[38.2535,17.5848],[38.2673,17.6167],[38.2898,17.637],[38.3474,17.6836],[38.3737,17.7173],[38.3855,17.7513],[38.3972,17.7784],[38.4225,17.8239],[38.5229,17.9385],[38.6095,18.0051]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":4,"sovereignt":"Eritrea","sov_a3":"ERI","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Eritrea","adm0_a3":"ERI","geou_dif":0,"geounit":"Eritrea","gu_a3":"ERI","su_dif":0,"subunit":"Eritrea","su_a3":"ERI","brk_diff":0,"name":"Eritrea","name_long":"Eritrea","brk_a3":"ERI","brk_name":"Eritrea","brk_group":"","abbrev":"Erit.","postal":"ER","formal_en":"State of Eritrea","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Eritrea","name_alt":"","mapcolor7":3,"mapcolor8":1,"mapcolor9":2,"mapcolor13":12,"pop_est":5647168,"gdp_md_est":3945,"pop_year":-99,"lastcensus":1984,"gdp_year":-99,"economy":"7. Least developed region","income_grp":"5. Low income","wikipedia":-99,"fips_10":"","iso_a2":"ER","iso_a3":"ERI","iso_n3":"232","un_a3":"232","wb_a2":"ER","wb_a3":"ERI","woe_id":-99,"adm0_a3_is":"ERI","adm0_a3_us":"ERI","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Africa","region_un":"Africa","subregion":"Eastern Africa","region_wb":"Sub-Saharan Africa","name_len":7,"long_len":7,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[11.3614,54.8917],[11.5384,54.8296],[11.6581,54.8332],[11.7396,54.8074],[11.759,54.7677],[11.7659,54.6794],[11.6804,54.6537],[11.5859,54.6625],[11.4574,54.6289],[11.0355,54.7731],[11.0417,54.8934],[11.0586,54.9406],[11.2585,54.9518],[11.3614,54.8917]],[[10.4844,54.8476],[10.4173,54.8372],[10.3405,54.8589],[10.2156,54.941],[10.1999,54.9627],[10.2655,54.9488],[10.347,54.906],[10.4137,54.8968],[10.5049,54.8605],[10.4844,54.8476]],[[12.5492,54.9658],[12.511,54.9509],[12.3575,54.9618],[12.1845,54.8925],[12.1188,54.9144],[12.1437,54.9587],[12.1617,54.9748],[12.2199,54.9936],[12.2588,55.0211],[12.274,55.0641],[12.3101,55.0409],[12.4172,55.0312],[12.4695,55.0175],[12.5133,54.9973],[12.5492,54.9658]],[[10.0612,54.8864],[9.9571,54.8725],[9.9039,54.8966],[9.8063,54.906],[9.7712,55.0599],[9.7813,55.069],[9.8304,55.0583],[9.9988,54.9865],[10.0577,54.9079],[10.0612,54.8864]],[[10.7341,54.7507],[10.6897,54.7451],[10.6295,54.8261],[10.6217,54.8514],[10.6925,54.9033],[10.7383,54.962],[10.8567,55.0522],[10.925,55.1579],[10.9511,55.1562],[10.9208,55.0621],[10.7652,54.7997],[10.7341,54.7507]],[[15.0877,55.0219],[15.0508,55.0049],[14.8855,55.033],[14.6842,55.1022],[14.7137,55.238],[14.7653,55.2967],[15.1326,55.1445],[15.1371,55.0872],[15.0877,55.0219]],[[10.6451,55.6098],[10.6868,55.5576],[10.7381,55.4463],[10.8192,55.3219],[10.7854,55.2698],[10.8084,55.203],[10.7853,55.1334],[10.6238,55.0524],[10.4428,55.0488],[10.2546,55.0879],[9.9888,55.1632],[9.9674,55.2055],[9.9301,55.2289],[9.859,55.3572],[9.8606,55.5155],[9.9942,55.5353],[10.2861,55.6108],[10.3536,55.599],[10.424,55.5604],[10.5051,55.5581],[10.6228,55.6128],[10.6451,55.6098]],[[12.6657,55.5965],[12.5716,55.554],[12.5509,55.5562],[12.5203,55.6146],[12.5699,55.6501],[12.5992,55.6802],[12.62,55.6793],[12.6484,55.6468],[12.6657,55.5965]],[[10.6073,55.7831],[10.5903,55.7651],[10.527,55.7838],[10.5203,55.8485],[10.5443,55.9066],[10.5161,55.9585],[10.5472,55.9919],[10.6363,55.9142],[10.6617,55.8776],[10.6273,55.8339],[10.6073,55.7831]],[[12.5688,55.7851],[12.5712,55.685],[12.5452,55.6558],[12.507,55.6366],[12.4071,55.6163],[12.3206,55.5878],[12.2435,55.5379],[12.215,55.4665],[12.2754,55.4143],[12.3852,55.3856],[12.4131,55.2862],[12.3225,55.2371],[12.0899,55.1881],[12.0655,55.0699],[12.073,54.9768],[12.0688,54.909],[12.0504,54.8153],[11.8623,54.7726],[11.7409,54.9153],[11.7398,54.9725],[11.7036,55.0392],[11.6968,55.096],[11.6538,55.1869],[11.4759,55.2115],[11.4068,55.2147],[11.3103,55.1979],[11.2863,55.2044],[11.1707,55.3286],[11.1897,55.4656],[11.128,55.5348],[11.1195,55.5661],[11.121,55.6007],[11.0703,55.6293],[11.0088,55.6444],[10.9789,55.7215],[11.0496,55.7402],[11.2244,55.7312],[11.2755,55.7365],[11.3223,55.7525],[11.4637,55.8793],[11.4596,55.9072],[11.4747,55.9435],[11.6277,55.9569],[11.6959,55.9079],[11.6822,55.8295],[11.6909,55.729],[11.7836,55.7017],[11.8197,55.6977],[11.8583,55.7719],[11.8854,55.808],[11.9221,55.8281],[11.9346,55.8959],[11.9128,55.9373],[11.8664,55.9682],[12.0396,56.0521],[12.2189,56.1187],[12.3232,56.1221],[12.4282,56.1059],[12.5258,56.0834],[12.5787,56.0641],[12.6084,56.033],[12.543,55.959],[12.5248,55.9185],[12.5688,55.7851]],[[11.0521,57.2525],[11.0114,57.2291],[10.8738,57.2623],[10.9346,57.3086],[11.0857,57.3299],[11.1745,57.3229],[11.0769,57.2769],[11.0521,57.2525]],[[10.4369,57.1723],[10.3385,57.0213],[10.2961,56.9991],[10.287,56.8229],[10.2967,56.7809],[10.2827,56.6205],[10.3836,56.5548],[10.4902,56.5205],[10.8459,56.5217],[10.8828,56.4929],[10.9262,56.4433],[10.8944,56.359],[10.8564,56.2955],[10.7534,56.242],[10.6212,56.2021],[10.539,56.2003],[10.427,56.2762],[10.3737,56.2516],[10.3188,56.2129],[10.2267,56.0054],[10.183,55.8652],[10.1594,55.8538],[10.1073,55.8745],[10.0174,55.8761],[9.9037,55.8428],[9.962,55.8131],[10.0236,55.7614],[9.999,55.7355],[9.899,55.7076],[9.8104,55.651],[9.7732,55.6082],[9.6614,55.5575],[9.5911,55.4932],[9.6256,55.4136],[9.6402,55.3437],[9.671,55.2664],[9.6433,55.2047],[9.5048,55.1163],[9.4537,55.0396],[9.5724,55.0405],[9.6454,55.0228],[9.6882,55.0001],[9.7323,54.968],[9.7053,54.9283],[9.7397,54.8255],[9.725,54.8255],[9.6612,54.8344],[9.6158,54.8554],[9.4987,54.8404],[9.342,54.8063],[9.255,54.808],[9.1858,54.8447],[8.9029,54.8969],[8.8572,54.9011],[8.6707,54.9033],[8.6703,54.9034],[8.6614,54.9859],[8.6383,55.0456],[8.5729,55.1343],[8.6698,55.1557],[8.6511,55.3286],[8.6159,55.4182],[8.3453,55.5103],[8.1321,55.5998],[8.1813,55.9012],[8.2023,55.9824],[8.1215,56.1399],[8.1299,56.3212],[8.164,56.6069],[8.2317,56.6181],[8.2814,56.6167],[8.4731,56.5654],[8.5529,56.5603],[8.6076,56.5145],[8.6717,56.4957],[8.7181,56.5443],[8.7361,56.6274],[8.8881,56.7351],[8.9945,56.7748],[9.0671,56.7938],[9.1403,56.7504],[9.1964,56.7017],[9.2097,56.8084],[9.2549,57.0117],[9.1104,57.0437],[8.9928,57.0161],[8.8761,56.8873],[8.772,56.7253],[8.6031,56.7104],[8.4684,56.6646],[8.3467,56.7121],[8.2683,56.754],[8.2663,56.8153],[8.2841,56.8523],[8.4271,56.9844],[8.6186,57.1113],[8.8115,57.1101],[8.9522,57.1506],[9.0363,57.1554],[9.2988,57.1465],[9.4336,57.1743],[9.5543,57.2325],[9.8151,57.4784],[9.9623,57.581],[10.2591,57.617],[10.5333,57.7354],[10.61,57.7369],[10.481,57.6487],[10.4603,57.6146],[10.4446,57.5622],[10.5371,57.4485],[10.5176,57.3793],[10.5241,57.2432],[10.4369,57.1723]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":4,"sovereignt":"Denmark","sov_a3":"DN1","adm0_dif":1,"level":2,"type":"Country","admin":"Denmark","adm0_a3":"DNK","geou_dif":0,"geounit":"Denmark","gu_a3":"DNK","su_dif":0,"subunit":"Denmark","su_a3":"DNK","brk_diff":0,"name":"Denmark","name_long":"Denmark","brk_a3":"DNK","brk_name":"Denmark","brk_group":"","abbrev":"Den.","postal":"DK","formal_en":"Kingdom of Denmark","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Denmark","name_alt":"","mapcolor7":4,"mapcolor8":1,"mapcolor9":3,"mapcolor13":12,"pop_est":5500510,"gdp_md_est":203600,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"DK","iso_a3":"DNK","iso_n3":"208","un_a3":"208","wb_a2":"DK","wb_a3":"DNK","woe_id":-99,"adm0_a3_is":"DNK","adm0_a3_us":"DNK","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Northern Europe","region_wb":"Europe & Central Asia","name_len":7,"long_len":7,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[102.1274,22.3792],[102.183,22.284],[102.3014,22.1782],[102.4427,22.0271],[102.4875,21.9578],[102.5825,21.9043],[102.6097,21.8518],[102.6313,21.7713],[102.6408,21.7114],[102.662,21.676],[102.6953,21.6621],[102.7386,21.6779],[102.7711,21.7097],[102.7982,21.7979],[102.8159,21.8074],[102.8452,21.7348],[102.8762,21.7223],[102.9177,21.7129],[102.9496,21.6813],[102.9592,21.6262],[102.9486,21.5698],[102.9096,21.5063],[102.8875,21.4399],[102.8723,21.3375],[102.8512,21.2659],[102.8838,21.2026],[103.1045,20.8917],[103.2107,20.8406],[103.4636,20.7798],[103.5547,20.7378],[103.6351,20.6971],[103.7145,20.7169],[103.7905,20.8095],[103.882,20.8614],[104.0521,20.9412],[104.1014,20.9455],[104.1953,20.914],[104.3496,20.8211],[104.4614,20.7337],[104.5304,20.688],[104.5832,20.6467],[104.5752,20.6002],[104.5327,20.5549],[104.4786,20.5296],[104.4078,20.4857],[104.3678,20.4414],[104.3922,20.4248],[104.4962,20.4137],[104.6188,20.3745],[104.6564,20.3285],[104.6619,20.289],[104.677,20.2247],[104.6987,20.2053],[104.8127,20.2168],[104.8479,20.2024],[104.8887,20.1691],[104.9292,20.0828],[104.9279,20.0181],[104.8458,19.9472],[104.8151,19.904],[104.8018,19.8361],[104.7432,19.7547],[104.5879,19.6187],[104.5463,19.6105],[104.2599,19.6855],[104.1271,19.6809],[104.0628,19.6784],[104.032,19.6751],[104.0135,19.6465],[104.0516,19.5642],[104.0629,19.4826],[104.0275,19.4205],[103.932,19.3661],[103.8964,19.34],[103.8916,19.305],[103.9184,19.2685],[104.0063,19.2309],[104.1086,19.1956],[104.4458,18.9838],[104.518,18.9341],[104.6133,18.8606],[104.7165,18.8034],[104.9932,18.7283],[105.1151,18.6789],[105.1465,18.651],[105.1454,18.6168],[105.1135,18.573],[105.087,18.4962],[105.0858,18.4501],[105.1146,18.4053],[105.1633,18.3387],[105.2732,18.2354],[105.3335,18.1896],[105.4,18.1792],[105.4582,18.1543],[105.5186,18.0774],[105.5885,17.9837],[105.5977,17.9183],[105.6272,17.8344],[105.6914,17.7378],[105.7795,17.6444],[105.9027,17.5287],[105.9735,17.447],[106.0063,17.4153],[106.2695,17.2168],[106.3334,17.1437],[106.426,17.0025],[106.4653,16.9818],[106.5022,16.9541],[106.526,16.8766],[106.5337,16.821],[106.5462,16.6507],[106.5937,16.6001],[106.6375,16.5379],[106.6564,16.4926],[106.6961,16.459],[106.7396,16.4525],[106.7916,16.4903],[106.8324,16.5263],[106.8511,16.5156],[106.8928,16.3965],[106.9307,16.3531],[107.002,16.3118],[107.0697,16.2798],[107.2174,16.1363],[107.2965,16.084],[107.3501,16.0674],[107.3964,16.043],[107.4102,15.9979],[107.392,15.9517],[107.3606,15.9217],[107.1889,15.8386],[107.1659,15.8025],[107.1896,15.7473],[107.2326,15.6781],[107.2794,15.6187],[107.3388,15.5605],[107.4596,15.4658],[107.5643,15.3916],[107.6217,15.3099],[107.6531,15.2552],[107.6337,15.1898],[107.5896,15.1185],[107.5553,15.057],[107.4963,15.0214],[107.4804,14.9799],[107.5047,14.9159],[107.5245,14.8718],[107.5138,14.8174],[107.5194,14.7051],[107.4651,14.665],[107.4147,14.5629],[107.3799,14.5553],[107.2927,14.5924],[107.2623,14.5721],[107.2066,14.4979],[107.1094,14.4167],[107.0624,14.4158],[107.0302,14.4257],[106.9922,14.391],[106.9381,14.3273],[106.9132,14.3294],[106.8199,14.3147],[106.7835,14.3351],[106.7382,14.3877],[106.6654,14.4413],[106.5992,14.4794],[106.5637,14.5051],[106.5312,14.5494],[106.5015,14.5782],[106.447,14.515],[106.355,14.4548],[106.268,14.4662],[106.2254,14.4762],[106.1907,14.3881],[106.1652,14.3724],[106.0084,14.3572],[105.9789,14.343],[106.0041,14.2629],[106.0967,14.1271],[106.1247,14.0491],[106.0668,13.9212],[105.9045,13.9245],[105.8314,13.9766],[105.7641,14.0491],[105.7397,14.085],[105.5315,14.1562],[105.3927,14.1071],[105.3502,14.1096],[105.2849,14.1615],[105.2457,14.2005],[105.207,14.2594],[105.1855,14.3191],[105.1833,14.3462],[105.2437,14.3679],[105.3422,14.4167],[105.4227,14.4716],[105.4756,14.5301],[105.4974,14.5907],[105.5002,14.6612],[105.523,14.8433],[105.5467,14.9325],[105.5334,15.0416],[105.4904,15.1276],[105.4904,15.2566],[105.5059,15.3196],[105.5132,15.3609],[105.5737,15.4132],[105.6156,15.4883],[105.6389,15.5859],[105.641,15.6565],[105.6221,15.7],[105.5624,15.7413],[105.462,15.7804],[105.3989,15.8299],[105.3732,15.8897],[105.3756,15.9422],[105.4063,15.9875],[105.3307,16.0379],[105.1487,16.0936],[105.0472,16.1603],[105.0258,16.238],[104.9499,16.3399],[104.8193,16.4661],[104.7506,16.6476],[104.7436,16.8844],[104.759,17.0771],[104.816,17.3003],[104.7396,17.4617],[104.6559,17.5467],[104.5393,17.6093],[104.4281,17.699],[104.3227,17.8158],[104.1962,17.9884],[104.0487,18.2167],[103.9496,18.319],[103.8988,18.2953],[103.7923,18.3165],[103.6297,18.3826],[103.488,18.4182],[103.367,18.4233],[103.2883,18.4084],[103.2518,18.3735],[103.2489,18.339],[103.2796,18.305],[103.2632,18.2785],[103.1997,18.2595],[103.1485,18.2217],[103.0912,18.1382],[103.0514,18.0285],[102.9914,17.9862],[102.8986,17.9769],[102.8074,17.9456],[102.7176,17.8922],[102.6752,17.8518],[102.6801,17.8241],[102.6606,17.818],[102.6168,17.8333],[102.5961,17.8696],[102.5982,17.9268],[102.5525,17.9651],[102.4588,17.9846],[102.3519,18.0459],[102.2316,18.149],[102.1482,18.2039],[102.1015,18.2106],[102.0346,18.1698],[101.9475,18.0815],[101.8755,18.0464],[101.8187,18.0646],[101.7748,18.0334],[101.7441,17.9527],[101.6875,17.8894],[101.5637,17.8205],[101.5551,17.8124],[101.4137,17.7188],[101.2997,17.625],[101.1675,17.499],[101.1052,17.4795],[101.0457,17.51],[100.9559,17.5411],[100.9085,17.5839],[100.999,17.7972],[101.1133,18.0335],[101.1439,18.1426],[101.1487,18.2222],[101.1375,18.2869],[101.0928,18.3545],[101.0506,18.407],[101.047,18.442],[101.0604,18.479],[101.1063,18.5335],[101.1655,18.6183],[101.2205,18.7928],[101.2863,18.9771],[101.2799,19.0889],[101.2266,19.2115],[101.1976,19.3279],[101.2208,19.4866],[101.2119,19.5483],[101.1547,19.5792],[100.9665,19.6108],[100.9061,19.6054],[100.8582,19.5851],[100.8068,19.5419],[100.7439,19.5147],[100.6255,19.4999],[100.5136,19.5535],[100.4201,19.6445],[100.3977,19.7561],[100.4662,19.8889],[100.5146,19.9963],[100.5431,20.0887],[100.5399,20.1324],[100.5195,20.1779],[100.4916,20.1841],[100.4315,20.2407],[100.3731,20.3404],[100.318,20.3859],[100.266,20.3773],[100.2181,20.3396],[100.1741,20.2728],[100.1397,20.2454],[100.1149,20.2577],[100.1225,20.3167],[100.1297,20.3722],[100.1839,20.5891],[100.2493,20.7303],[100.3261,20.7957],[100.4074,20.8232],[100.4934,20.813],[100.5651,20.8251],[100.6229,20.8596],[100.6177,20.8792],[100.5493,20.8842],[100.5223,20.9219],[100.5361,20.9924],[100.5666,21.0382],[100.6137,21.0593],[100.6592,21.1304],[100.7031,21.2514],[100.7566,21.3126],[100.8195,21.3142],[100.9275,21.3662],[101.0804,21.4687],[101.1389,21.5675],[101.1967,21.5221],[101.1754,21.4075],[101.2056,21.3833],[101.2199,21.3424],[101.2118,21.2782],[101.2244,21.2237],[101.2479,21.1973],[101.2814,21.1841],[101.4436,21.2308],[101.5424,21.2343],[101.5839,21.2036],[101.6217,21.1844],[101.6686,21.1696],[101.7048,21.1501],[101.7281,21.1564],[101.7835,21.2042],[101.8006,21.2126],[101.8021,21.236],[101.7631,21.2789],[101.7229,21.3149],[101.7242,21.395],[101.7435,21.5338],[101.7473,21.6058],[101.7439,21.778],[101.7365,21.8265],[101.6996,21.8825],[101.6029,21.9897],[101.5758,22.0553],[101.5603,22.1209],[101.5618,22.1624],[101.5373,22.2099],[101.5245,22.2537],[101.5679,22.2764],[101.6199,22.3274],[101.6462,22.4054],[101.6715,22.4623],[101.7075,22.4866],[101.7388,22.4953],[101.76,22.4903],[101.8418,22.3885],[101.9454,22.4394],[102.0244,22.4392],[102.0915,22.4123],[102.1274,22.3792]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":4,"sovereignt":"Laos","sov_a3":"LAO","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Laos","adm0_a3":"LAO","geou_dif":0,"geounit":"Laos","gu_a3":"LAO","su_dif":0,"subunit":"Laos","su_a3":"LAO","brk_diff":0,"name":"Lao PDR","name_long":"Lao PDR","brk_a3":"LAO","brk_name":"Laos","brk_group":"","abbrev":"Laos","postal":"LA","formal_en":"Lao People's Democratic Republic","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Lao PDR","name_alt":"","mapcolor7":1,"mapcolor8":1,"mapcolor9":1,"mapcolor13":9,"pop_est":6834942,"gdp_md_est":13980,"pop_year":-99,"lastcensus":2005,"gdp_year":-99,"economy":"7. Least developed region","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"LA","iso_a3":"LAO","iso_n3":"418","un_a3":"418","wb_a2":"LA","wb_a3":"LAO","woe_id":-99,"adm0_a3_is":"LAO","adm0_a3_us":"LAO","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"South-Eastern Asia","region_wb":"East Asia & Pacific","name_len":7,"long_len":7,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[48.2754,29.6243],[48.2183,29.602],[48.1797,29.6114],[48.1426,29.6653],[48.0814,29.7989],[48.1147,29.8488],[48.1135,29.8702],[48.1201,29.8863],[48.1389,29.8966],[48.1586,29.9596],[48.1848,29.9789],[48.2277,29.9363],[48.3482,29.7827],[48.3474,29.72],[48.3402,29.6947],[48.2754,29.6243]],[[48.1361,29.6181],[48.1435,29.5725],[48.0895,29.5791],[48.0483,29.5975],[47.9696,29.6167],[47.8175,29.4874],[47.7253,29.4169],[47.7227,29.393],[47.8453,29.3657],[47.9354,29.3666],[47.9981,29.3855],[48.0515,29.3554],[48.0863,29.2755],[48.1004,29.2107],[48.1838,28.9794],[48.2529,28.9013],[48.3393,28.7633],[48.3713,28.6918],[48.3896,28.6316],[48.4425,28.5429],[48.2688,28.5405],[48.0496,28.5375],[47.872,28.5354],[47.6713,28.5332],[47.5831,28.628],[47.5532,28.7315],[47.5213,28.8378],[47.4332,28.9896],[47.1388,29.0262],[46.9822,29.0457],[46.7248,29.0746],[46.5314,29.0962],[46.6937,29.2597],[46.7693,29.3475],[46.9059,29.5375],[46.976,29.6729],[47.0437,29.823],[47.1021,29.94],[47.1144,29.9613],[47.1482,30.001],[47.2232,30.0415],[47.3313,30.0797],[47.5148,30.0965],[47.6438,30.0973],[47.6728,30.0956],[47.7539,30.0766],[47.9787,29.9828],[47.9736,29.9459],[48.0057,29.8358],[48.0773,29.7156],[48.1361,29.6181]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Kuwait","sov_a3":"KWT","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Kuwait","adm0_a3":"KWT","geou_dif":0,"geounit":"Kuwait","gu_a3":"KWT","su_dif":0,"subunit":"Kuwait","su_a3":"KWT","brk_diff":0,"name":"Kuwait","name_long":"Kuwait","brk_a3":"KWT","brk_name":"Kuwait","brk_group":"","abbrev":"Kwt.","postal":"KW","formal_en":"State of Kuwait","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Kuwait","name_alt":"","mapcolor7":2,"mapcolor8":2,"mapcolor9":2,"mapcolor13":2,"pop_est":2691158,"gdp_md_est":149100,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"6. Developing region","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"KW","iso_a3":"KWT","iso_n3":"414","un_a3":"414","wb_a2":"KW","wb_a3":"KWT","woe_id":-99,"adm0_a3_is":"KWT","adm0_a3_us":"KWT","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Western Asia","region_wb":"Middle East & North Africa","name_len":6,"long_len":6,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[35.8691,33.4317],[35.8407,33.4157],[35.7875,33.3698],[35.7345,33.3326],[35.6272,33.275],[35.6029,33.2406],[35.5793,33.2715],[35.5325,33.2505],[35.4932,33.1195],[35.4112,33.0757],[35.3089,33.0795],[35.2233,33.092],[35.1086,33.0837],[35.1551,33.16],[35.2035,33.259],[35.2514,33.3926],[35.3357,33.5035],[35.5108,33.8797],[35.6118,34.0322],[35.6479,34.2482],[35.8043,34.4374],[35.9214,34.4933],[35.9779,34.5474],[35.9763,34.6292],[36.1511,34.6286],[36.2636,34.6329],[36.2963,34.6787],[36.3839,34.6579],[36.433,34.6135],[36.3887,34.5669],[36.3263,34.5133],[36.3299,34.4996],[36.3765,34.4952],[36.4556,34.4662],[36.5044,34.4324],[36.585,34.2212],[36.5352,34.1343],[36.4575,34.0568],[36.4229,34.0499],[36.3549,34.0113],[36.2979,33.9586],[36.2778,33.9253],[36.2822,33.8942],[36.3628,33.8551],[36.365,33.8394],[36.3485,33.8271],[36.2834,33.8356],[36.1994,33.8396],[36.1498,33.8395],[36.0922,33.8316],[36.0188,33.7839],[35.9861,33.7526],[35.9685,33.7324],[35.9424,33.6676],[35.9717,33.6231],[36.0267,33.5979],[36.0345,33.5851],[36.0223,33.5625],[35.9676,33.5346],[35.9266,33.5003],[35.9147,33.4654],[35.8691,33.4317]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Lebanon","sov_a3":"LBN","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Lebanon","adm0_a3":"LBN","geou_dif":0,"geounit":"Lebanon","gu_a3":"LBN","su_dif":0,"subunit":"Lebanon","su_a3":"LBN","brk_diff":0,"name":"Lebanon","name_long":"Lebanon","brk_a3":"LBN","brk_name":"Lebanon","brk_group":"","abbrev":"Leb.","postal":"LB","formal_en":"Lebanese Republic","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Lebanon","name_alt":"","mapcolor7":4,"mapcolor8":4,"mapcolor9":4,"mapcolor13":12,"pop_est":4017095,"gdp_md_est":44060,"pop_year":-99,"lastcensus":1970,"gdp_year":-99,"economy":"6. Developing region","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"LB","iso_a3":"LBN","iso_n3":"422","un_a3":"422","wb_a2":"LB","wb_a3":"LBN","woe_id":-99,"adm0_a3_is":"LBN","adm0_a3_us":"LBN","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Western Asia","region_wb":"Middle East & North Africa","name_len":7,"long_len":7,"abbrev_len":4,"tiny":4,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[21.5625,42.2475],[21.5608,42.2477],[21.3896,42.2198],[21.3317,42.1872],[21.2976,42.1301],[21.2866,42.1004],[21.2563,42.0995],[21.2061,42.129],[21.1425,42.175],[21.0598,42.1713],[20.7781,42.071],[20.7504,42.0184],[20.7441,41.9043],[20.725,41.8735],[20.6949,41.8538],[20.5785,41.8662],[20.5662,41.8737],[20.5814,41.9174],[20.5754,42.0131],[20.5229,42.1715],[20.4854,42.2234],[20.4083,42.275],[20.3482,42.3088],[20.2405,42.339],[20.1857,42.4259],[20.1035,42.5247],[20.064,42.5473],[20.0703,42.5571],[20.0893,42.6315],[20.0657,42.6858],[20.0295,42.732],[20.0543,42.7601],[20.13,42.7598],[20.1926,42.7546],[20.2151,42.7988],[20.3443,42.8279],[20.4688,42.8579],[20.4868,42.8791],[20.4584,42.9246],[20.4751,42.953],[20.624,43.0342],[20.6485,43.0709],[20.6576,43.0999],[20.6376,43.1304],[20.6097,43.1784],[20.6231,43.1986],[20.7006,43.2264],[20.7634,43.2586],[20.8006,43.2611],[20.8238,43.2379],[20.8238,43.214],[20.8444,43.1734],[20.8907,43.1517],[20.9677,43.116],[21.057,43.0917],[21.1271,43.043],[21.2227,42.9562],[21.2371,42.9132],[21.3231,42.8747],[21.403,42.8315],[21.3906,42.7514],[21.6625,42.6815],[21.7238,42.682],[21.7529,42.6698],[21.7521,42.6515],[21.7307,42.5955],[21.619,42.4232],[21.6099,42.3875],[21.53,42.35],[21.5189,42.3284],[21.5416,42.2808],[21.5625,42.2475]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Kosovo","sov_a3":"KOS","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Kosovo","adm0_a3":"KOS","geou_dif":0,"geounit":"Kosovo","gu_a3":"KOS","su_dif":0,"subunit":"Kosovo","su_a3":"KOS","brk_diff":1,"name":"Kosovo","name_long":"Kosovo","brk_a3":"B57","brk_name":"Kosovo","brk_group":"","abbrev":"Kos.","postal":"KO","formal_en":"Republic of Kosovo","formal_fr":"","note_adm0":"","note_brk":"Self admin.; Claimed by Serbia","name_sort":"Kosovo","name_alt":"","mapcolor7":2,"mapcolor8":2,"mapcolor9":3,"mapcolor13":11,"pop_est":1804838,"gdp_md_est":5352,"pop_year":-99,"lastcensus":1981,"gdp_year":-99,"economy":"6. Developing region","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"-99","iso_a3":"-99","iso_n3":"-99","un_a3":"-099","wb_a2":"KV","wb_a3":"KSV","woe_id":-99,"adm0_a3_is":"SRB","adm0_a3_us":"KOS","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Southern Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":6,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[126.327,33.2236],[126.282,33.2015],[126.2402,33.2148],[126.229,33.2252],[126.1787,33.2826],[126.1656,33.312],[126.1994,33.3681],[126.3377,33.4604],[126.6955,33.5493],[126.7599,33.5532],[126.9012,33.5151],[126.9313,33.4438],[126.9054,33.3824],[126.8729,33.3412],[126.7092,33.2717],[126.5817,33.2383],[126.327,33.2236]],[[126.753,34.344],[126.7699,34.2964],[126.6891,34.3054],[126.6461,34.3511],[126.6519,34.3903],[126.7,34.3959],[126.753,34.344]],[[126.2337,34.3705],[126.1697,34.3552],[126.1338,34.3896],[126.1086,34.3987],[126.1229,34.4439],[126.2271,34.5327],[126.2475,34.5633],[126.3438,34.5449],[126.3799,34.4979],[126.3354,34.4264],[126.2337,34.3705]],[[127.799,34.615],[127.7878,34.5841],[127.7373,34.6309],[127.7871,34.6821],[127.799,34.615]],[[126.172,34.7312],[126.1588,34.707],[126.1152,34.7142],[126.0706,34.7831],[126.0521,34.8375],[126.0075,34.8675],[126.0784,34.9148],[126.1686,34.8297],[126.172,34.7312]],[[128.0658,34.8059],[128.0547,34.7081],[127.984,34.7032],[127.9418,34.7663],[127.8969,34.7355],[127.8734,34.735],[127.8383,34.8133],[127.8322,34.8745],[127.9154,34.921],[127.9656,34.893],[128.038,34.8786],[128.0658,34.8059]],[[128.741,34.7985],[128.6467,34.7369],[128.5195,34.8196],[128.4893,34.8653],[128.5859,34.9323],[128.668,35.0088],[128.7219,35.0136],[128.741,34.7985]],[[126.4176,36.4926],[126.4038,36.4279],[126.3375,36.4706],[126.3186,36.6125],[126.3866,36.5711],[126.4176,36.4926]],[[130.916,37.4785],[130.8706,37.4487],[130.8168,37.4785],[130.8103,37.5099],[130.8384,37.5372],[130.9037,37.5537],[130.9343,37.5297],[130.916,37.4785]],[[126.5207,37.7368],[126.516,37.6047],[126.4608,37.6104],[126.4233,37.6236],[126.4072,37.6494],[126.3693,37.772],[126.4116,37.8227],[126.4936,37.7826],[126.5207,37.7368]],[[128.3746,38.6234],[128.6188,38.1761],[128.8524,37.8871],[129.0516,37.6776],[129.3352,37.2746],[129.4183,37.059],[129.4262,36.9255],[129.4734,36.7419],[129.433,36.6366],[129.445,36.4707],[129.4271,36.3855],[129.3926,36.3227],[129.3913,36.2021],[129.4024,36.1376],[129.4035,36.0521],[129.4258,36.0188],[129.4583,36.0064],[129.5098,36.0376],[129.5729,36.0505],[129.5617,35.9477],[129.4854,35.6874],[129.4191,35.4979],[129.329,35.3328],[129.2142,35.1818],[129.0768,35.1227],[128.9801,35.1015],[128.7957,35.0939],[128.6426,35.1196],[128.5109,35.101],[128.4581,35.0694],[128.4188,35.0157],[128.4477,34.9321],[128.4439,34.8704],[128.3877,34.8751],[128.276,34.911],[128.1523,34.9159],[128.0945,34.9336],[128.0362,35.022],[127.9768,35.0187],[127.8732,34.9663],[127.7148,34.9547],[127.6591,34.9264],[127.6394,34.8897],[127.6625,34.8434],[127.7422,34.7826],[127.7154,34.721],[127.6324,34.6902],[127.5654,34.7659],[127.5236,34.8401],[127.477,34.8443],[127.4043,34.8231],[127.3896,34.743],[127.4234,34.6885],[127.4791,34.6252],[127.4012,34.5525],[127.3806,34.5006],[127.3246,34.4633],[127.1734,34.5461],[127.1949,34.605],[127.2605,34.6617],[127.2687,34.7204],[127.2471,34.7551],[127.0308,34.6069],[126.8975,34.4389],[126.8263,34.4511],[126.7965,34.4943],[126.7548,34.5119],[126.6108,34.4035],[126.5844,34.3175],[126.5314,34.3143],[126.5083,34.3506],[126.5064,34.4284],[126.4817,34.4939],[126.3326,34.5896],[126.2645,34.6732],[126.3011,34.72],[126.4256,34.6946],[126.5245,34.6979],[126.505,34.7375],[126.4729,34.7563],[126.5386,34.7787],[126.5934,34.8244],[126.5479,34.8368],[126.4785,34.8104],[126.4207,34.8234],[126.3979,34.9328],[126.3274,35.0451],[126.2911,35.1542],[126.3605,35.2169],[126.3959,35.3144],[126.4604,35.4556],[126.4928,35.5013],[126.5822,35.5345],[126.6141,35.571],[126.5649,35.5897],[126.4865,35.6063],[126.4885,35.6471],[126.5419,35.6693],[126.6016,35.7142],[126.7174,35.7688],[126.753,35.872],[126.7196,35.8979],[126.6475,35.9224],[126.6637,35.9745],[126.6935,36.0142],[126.6823,36.0379],[126.5971,36.105],[126.5404,36.1662],[126.5572,36.2358],[126.5442,36.3412],[126.552,36.4297],[126.5482,36.4776],[126.5066,36.5856],[126.4877,36.6938],[126.433,36.678],[126.3888,36.6512],[126.2307,36.6893],[126.1809,36.6916],[126.1605,36.7719],[126.2172,36.8709],[126.3516,36.9582],[126.4287,36.969],[126.487,37.0075],[126.5777,37.0196],[126.6867,36.9604],[126.7845,36.9484],[126.8388,36.8461],[126.8721,36.8245],[126.8791,36.8621],[126.958,36.9062],[126.9769,36.9394],[126.9598,36.9576],[126.8689,36.9757],[126.7874,37.1027],[126.7761,37.1582],[126.7464,37.1936],[126.7905,37.2949],[126.6962,37.4107],[126.6503,37.4471],[126.6568,37.5512],[126.6076,37.6174],[126.5802,37.6538],[126.5634,37.7165],[126.5777,37.7447],[126.6207,37.7555],[126.6339,37.7818],[126.6646,37.8007],[126.6665,37.8279],[126.6668,37.9172],[126.7543,37.979],[126.8789,38.1061],[126.94,38.1756],[127.0097,38.2405],[127.0903,38.2839],[127.1695,38.3045],[127.294,38.3133],[127.5327,38.305],[127.5795,38.3125],[127.7455,38.3192],[127.7847,38.3077],[127.9053,38.3004],[128.039,38.3085],[128.1063,38.3273],[128.1687,38.3593],[128.2231,38.417],[128.2793,38.5238],[128.3395,38.6079],[128.3746,38.6234]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"South Korea","sov_a3":"KOR","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"South Korea","adm0_a3":"KOR","geou_dif":0,"geounit":"South Korea","gu_a3":"KOR","su_dif":0,"subunit":"South Korea","su_a3":"KOR","brk_diff":0,"name":"Korea","name_long":"Republic of Korea","brk_a3":"KOR","brk_name":"Republic of Korea","brk_group":"","abbrev":"S.K.","postal":"KR","formal_en":"Republic of Korea","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Korea, Rep.","name_alt":"","mapcolor7":4,"mapcolor8":1,"mapcolor9":1,"mapcolor13":5,"pop_est":48508972,"gdp_md_est":1335000,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"4. Emerging region: MIKT","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"KR","iso_a3":"KOR","iso_n3":"410","un_a3":"410","wb_a2":"KR","wb_a3":"KOR","woe_id":-99,"adm0_a3_is":"KOR","adm0_a3_us":"KOR","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Eastern Asia","region_wb":"East Asia & Pacific","name_len":5,"long_len":17,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[50.1845,44.8546],[50.1487,44.8265],[50.0953,44.8306],[49.9951,44.937],[50.023,45.0447],[50.0594,45.0668],[50.1099,45.0819],[50.1166,45.0583],[50.0453,45.01],[50.0389,44.9491],[50.0981,44.8815],[50.1845,44.8546]],[[50.3117,44.9721],[50.2772,44.9586],[50.2562,45.0224],[50.2949,45.0759],[50.3497,45.083],[50.3309,44.9984],[50.3117,44.9721]],[[52.6824,45.4118],[52.6648,45.4013],[52.5983,45.4282],[52.5543,45.474],[52.6089,45.528],[52.6596,45.5181],[52.693,45.4607],[52.6824,45.4118]],[[70.0874,55.1768],[70.1824,55.1625],[70.2934,55.1836],[70.3715,55.2123],[70.4172,55.2532],[70.4863,55.2824],[70.7381,55.3052],[70.7903,55.2611],[70.9102,55.128],[70.9918,54.9505],[71.1263,54.715],[71.1855,54.5993],[71.1592,54.5386],[71.1598,54.4554],[71.1521,54.3641],[71.0527,54.2605],[71.0932,54.2122],[71.3364,54.1583],[71.6771,54.178],[71.8874,54.2215],[72.0045,54.2057],[72.0656,54.2316],[72.1054,54.3084],[72.186,54.3256],[72.2691,54.2721],[72.3295,54.1814],[72.3873,54.123],[72.383,54.0537],[72.4043,53.9645],[72.4468,53.9418],[72.5303,53.9758],[72.5859,53.9959],[72.5992,54.023],[72.5756,54.0565],[72.5643,54.0904],[72.5827,54.1216],[72.6223,54.1343],[72.741,54.1245],[72.9141,54.1073],[73.1193,53.9808],[73.2299,53.9578],[73.2766,53.9556],[73.3807,53.9628],[73.5057,53.9993],[73.5899,54.045],[73.618,54.0674],[73.6664,54.0635],[73.7124,54.0424],[73.7155,53.9962],[73.6789,53.9294],[73.5542,53.8683],[73.3994,53.8115],[73.3057,53.7072],[73.2857,53.5984],[73.3269,53.5432],[73.3619,53.5062],[73.3719,53.4544],[73.4069,53.4476],[73.4699,53.4689],[73.643,53.5763],[73.7312,53.6028],[73.859,53.6197],[74.0687,53.6114],[74.21,53.5765],[74.2773,53.5277],[74.3516,53.4876],[74.4027,53.5044],[74.4293,53.5507],[74.4305,53.6037],[74.452,53.6473],[74.6814,53.7544],[74.8342,53.8257],[74.8868,53.834],[74.989,53.8192],[75.0521,53.8267],[75.2202,53.8938],[75.3771,53.9701],[75.3924,54.0217],[75.3981,54.0685],[75.4372,54.0896],[75.6568,54.106],[75.6929,54.1148],[75.8807,54.168],[76.1405,54.2585],[76.2666,54.312],[76.4965,54.3357],[76.5392,54.3511],[76.6155,54.3871],[76.7594,54.4369],[76.8373,54.4424],[76.789,54.3219],[76.703,54.1825],[76.6546,54.1453],[76.4217,54.1515],[76.4221,54.1135],[76.4586,54.0553],[76.4848,54.0226],[76.5131,53.9932],[76.5757,53.9425],[76.8207,53.8227],[77.1324,53.6701],[77.4692,53.4988],[77.7044,53.3792],[77.7994,53.3174],[77.86,53.2692],[78.0335,53.095],[78.198,52.9297],[78.4755,52.6384],[78.7215,52.357],[78.9921,52.0474],[79.1487,51.8681],[79.4688,51.4931],[79.5543,51.378],[79.7164,51.16],[79.8597,50.9555],[79.9862,50.7746],[80.0659,50.7582],[80.0721,50.8073],[80.0863,50.84],[80.1272,50.8583],[80.2202,50.9118],[80.2704,50.9246],[80.3452,50.9191],[80.4236,50.9463],[80.4522,50.9976],[80.4336,51.0926],[80.4215,51.1364],[80.448,51.1833],[80.491,51.2018],[80.5507,51.2166],[80.6055,51.2242],[80.6505,51.2773],[80.7353,51.2934],[80.8131,51.2835],[80.8773,51.2814],[80.9341,51.2428],[80.9656,51.1898],[81.0268,51.1857],[81.1272,51.1911],[81.141,51.1466],[81.1124,51.0724],[81.0775,51.0149],[81.0715,50.9688],[81.1246,50.9463],[81.3191,50.9664],[81.3883,50.9565],[81.4102,50.9098],[81.4377,50.871],[81.4516,50.8237],[81.4314,50.7711],[81.4659,50.7398],[81.6339,50.7391],[81.7521,50.7644],[81.9337,50.7664],[82.098,50.7108],[82.2119,50.7194],[82.3264,50.7419],[82.4939,50.7276],[82.6117,50.7715],[82.693,50.8263],[82.7186,50.8695],[82.7608,50.8934],[82.919,50.8931],[83.0192,50.8973],[83.0928,50.9606],[83.1603,50.9892],[83.2737,50.9946],[83.3573,50.9946],[83.5814,50.9357],[83.7178,50.8872],[83.8598,50.818],[83.9451,50.7747],[84.0023,50.6769],[84.0993,50.6047],[84.176,50.5206],[84.1945,50.4375],[84.2578,50.2882],[84.3232,50.2392],[84.401,50.2392],[84.499,50.2188],[84.6073,50.2024],[84.839,50.0913],[84.924,50.088],[84.9895,50.0614],[84.9997,50.0103],[84.9752,49.9511],[85.0008,49.8941],[85.0765,49.8216],[85.1365,49.7507],[85.2102,49.6648],[85.2326,49.6158],[85.2919,49.5995],[85.3716,49.6239],[85.4984,49.6054],[85.8805,49.5565],[85.9336,49.5504],[85.9744,49.4993],[86.0296,49.5034],[86.093,49.5055],[86.1809,49.4993],[86.2422,49.5463],[86.2924,49.5875],[86.418,49.6385],[86.5223,49.7078],[86.6102,49.7691],[86.6755,49.7773],[86.7287,49.7487],[86.7307,49.6956],[86.6653,49.6567],[86.6143,49.6097],[86.6265,49.5627],[86.7144,49.5586],[86.8121,49.4879],[86.9529,49.3221],[87.001,49.2873],[87.0706,49.2546],[87.148,49.2398],[87.2337,49.2162],[87.2969,49.1477],[87.3229,49.0858],[87.23,49.1059],[87.0485,49.1099],[86.938,49.0976],[86.8859,49.0906],[86.8083,49.0497],[86.7531,49.0088],[86.7286,48.9394],[86.7578,48.8607],[86.718,48.6972],[86.6638,48.6355],[86.5494,48.5286],[86.4833,48.5054],[86.3726,48.4862],[86.2656,48.4545],[86.0562,48.4237],[85.8299,48.4081],[85.7494,48.3851],[85.6922,48.3118],[85.6516,48.2505],[85.6264,48.204],[85.5623,48.0519],[85.526,47.9156],[85.5616,47.7465],[85.5883,47.5585],[85.5866,47.4937],[85.6418,47.3974],[85.6698,47.3384],[85.6566,47.2546],[85.5772,47.1885],[85.5297,47.1008],[85.4848,47.0635],[85.3554,47.0467],[85.2335,47.0364],[85.1105,46.9612],[85.0122,46.9092],[84.8582,46.8432],[84.7861,46.8307],[84.746,46.8644],[84.7195,46.9394],[84.6666,46.9724],[84.5923,46.975],[84.5324,46.9758],[84.3389,46.9961],[84.2151,46.9947],[84.1221,46.9786],[84.016,46.9705],[83.8326,46.9979],[83.714,47.021],[83.6341,47.0432],[83.4436,47.1086],[83.1931,47.1866],[83.0903,47.2094],[83.0295,47.1859],[83.0201,47.1415],[83.0041,47.0335],[82.9749,46.966],[82.8,46.6245],[82.6922,46.3867],[82.5551,46.1587],[82.5117,46.0058],[82.4297,45.8119],[82.3481,45.6715],[82.3152,45.5949],[82.3122,45.5637],[82.3267,45.5199],[82.4517,45.472],[82.5825,45.4426],[82.6116,45.4243],[82.6258,45.3744],[82.6211,45.2931],[82.597,45.216],[82.559,45.1554],[82.5215,45.1255],[82.4787,45.1236],[82.3967,45.1625],[82.3234,45.2059],[82.2666,45.2191],[82.1228,45.1949],[81.9893,45.1619],[81.9449,45.1608],[81.8675,45.1821],[81.7896,45.226],[81.7589,45.3108],[81.692,45.3494],[81.6021,45.3108],[81.3348,45.2462],[81.0403,45.1691],[80.8533,45.1293],[80.7801,45.1355],[80.6348,45.1265],[80.5092,45.105],[80.4149,45.0751],[80.2282,45.034],[80.0592,45.0064],[79.9502,44.9441],[79.8719,44.8838],[79.8753,44.8608],[79.9321,44.8252],[79.9972,44.7972],[80.1278,44.8038],[80.2551,44.8081],[80.3608,44.7703],[80.4555,44.7461],[80.4815,44.7146],[80.4555,44.6841],[80.4006,44.6769],[80.3814,44.6554],[80.391,44.6268],[80.3551,44.552],[80.3363,44.4384],[80.3549,44.3265],[80.3653,44.2233],[80.359,44.1713],[80.3553,44.0973],[80.3958,44.0472],[80.4315,43.9518],[80.496,43.8921],[80.5935,43.6851],[80.6508,43.5642],[80.7038,43.4271],[80.6654,43.353],[80.6678,43.3101],[80.7298,43.2743],[80.757,43.2043],[80.7857,43.1616],[80.7777,43.1189],[80.7512,43.1025],[80.617,43.1283],[80.507,43.0858],[80.3902,43.0431],[80.3745,43.0204],[80.3713,42.9956],[80.3834,42.9738],[80.4507,42.9355],[80.5438,42.9117],[80.539,42.8735],[80.424,42.8558],[80.2503,42.7973],[80.2022,42.7345],[80.165,42.6655],[80.1619,42.6255],[80.1793,42.5184],[80.2058,42.3994],[80.2551,42.2742],[80.2591,42.2354],[80.233,42.2078],[80.2094,42.19],[80.0713,42.303],[79.9211,42.4131],[79.8034,42.4385],[79.5984,42.4566],[79.4901,42.4576],[79.4282,42.4835],[79.3678,42.5472],[79.2955,42.6048],[79.203,42.666],[79.1648,42.759],[79.1267,42.7757],[79.0599,42.7638],[78.9479,42.7667],[78.8852,42.7749],[78.7915,42.7908],[78.6423,42.8287],[78.5242,42.8646],[78.376,42.8715],[78.29,42.8644],[78.0231,42.8575],[77.8017,42.8952],[77.6225,42.9022],[77.5122,42.9],[77.4593,42.9047],[77.3686,42.9044],[77.2355,42.9126],[77.0573,42.9707],[76.9881,42.9736],[76.944,42.9715],[76.6465,42.9288],[76.5092,42.9189],[76.2182,42.9237],[75.9322,42.9285],[75.8403,42.9375],[75.7896,42.9329],[75.6817,42.8305],[75.6356,42.8146],[75.3662,42.837],[75.0477,42.9044],[74.8176,42.9782],[74.6223,43.0562],[74.3639,43.1794],[74.2091,43.2404],[74.1868,43.2053],[74.1459,43.1941],[74.0862,43.1886],[73.9492,43.195],[73.886,43.1326],[73.7186,43.0879],[73.612,43.0479],[73.5563,43.0028],[73.4502,42.703],[73.4219,42.5935],[73.493,42.409],[73.4116,42.4198],[73.316,42.467],[73.2829,42.5041],[73.1908,42.5269],[72.8551,42.5611],[72.7924,42.6035],[72.7529,42.6379],[72.6661,42.6604],[72.5432,42.6777],[72.2758,42.7577],[72.1618,42.7607],[71.8168,42.8222],[71.7605,42.8215],[71.7348,42.8189],[71.6008,42.7787],[71.5143,42.7669],[71.4221,42.7832],[71.2566,42.7335],[71.1674,42.6674],[71.0936,42.5865],[71.0228,42.5354],[71.002,42.4591],[70.9523,42.4194],[70.8929,42.34],[70.8929,42.2937],[70.9468,42.2487],[70.8604,42.2072],[70.7646,42.1942],[70.7152,42.1687],[70.6625,42.1075],[70.6133,42.0547],[70.5843,42.036],[70.5401,42.0395],[70.4891,42.0803],[70.416,42.0786],[70.3289,42.028],[70.2259,41.946],[70.0956,41.8205],[69.96,41.7541],[69.7881,41.6973],[69.6639,41.6721],[69.5651,41.6291],[69.401,41.5419],[69.3684,41.4906],[69.2493,41.4603],[69.1536,41.4252],[69.0649,41.3669],[69.0435,41.2641],[68.9869,41.205],[68.8512,41.1238],[68.7371,41.0419],[68.6628,40.9615],[68.5841,40.8763],[68.5593,40.8293],[68.5565,40.7651],[68.5937,40.7113],[68.6007,40.66],[68.5727,40.6227],[68.4957,40.6086],[68.415,40.6194],[68.2919,40.6561],[68.1603,40.7218],[68.1123,40.7541],[68.0477,40.8093],[68.057,40.8606],[68.0903,40.9603],[68.1131,41.0286],[68.0594,41.0613],[68.0197,41.0962],[67.9914,41.13],[67.9357,41.1966],[67.8657,41.1803],[67.8051,41.1639],[67.7351,41.1873],[67.528,41.1771],[67.3716,41.1695],[67.225,41.1624],[67.0387,41.1533],[66.8143,41.1424],[66.7498,41.1571],[66.7097,41.1792],[66.6687,41.2708],[66.6453,41.3486],[66.6017,41.4943],[66.5726,41.607],[66.5379,41.7413],[66.515,41.8894],[66.4986,41.9949],[66.3288,41.9983],[66.1932,42.0011],[66.0096,42.0049],[66.0112,42.0888],[66.0132,42.1945],[66.0155,42.3148],[66.0498,42.4728],[66.0627,42.6052],[66.0785,42.7667],[66.0889,42.8734],[66.1003,42.9908],[66.0057,42.9546],[65.9011,42.9145],[65.803,42.877],[65.7356,42.9721],[65.6702,43.0646],[65.5707,43.2052],[65.4962,43.3105],[65.3665,43.372],[65.2705,43.4175],[65.1709,43.4942],[65.0849,43.5737],[65.0031,43.6491],[64.9055,43.7147],[64.8118,43.6939],[64.7061,43.653],[64.6041,43.6135],[64.4961,43.5716],[64.4432,43.5512],[64.3182,43.5589],[64.2088,43.5657],[64.0133,43.5778],[63.8481,43.5881],[63.6797,43.5986],[63.4448,43.6132],[63.207,43.628],[63.0477,43.6085],[62.8462,43.5839],[62.6345,43.558],[62.4594,43.5366],[62.2379,43.5096],[62.072,43.4894],[61.9902,43.4921],[61.8876,43.5772],[61.7232,43.7136],[61.6236,43.7962],[61.5259,43.8772],[61.3851,43.9939],[61.2715,44.0823],[61.1607,44.1686],[61.0971,44.2482],[61.0653,44.3484],[61.0079,44.3938],[60.8792,44.4551],[60.7411,44.5208],[60.6029,44.5866],[60.4647,44.6524],[60.3267,44.7182],[60.1885,44.784],[60.0503,44.8498],[59.9122,44.9156],[59.774,44.9813],[59.6359,45.0471],[59.4979,45.1128],[59.3596,45.1786],[59.2215,45.2444],[59.0834,45.3102],[58.9451,45.376],[58.807,45.4418],[58.6689,45.5076],[58.5553,45.5554],[58.4494,45.5429],[58.2911,45.5094],[58.1252,45.4744],[57.961,45.4397],[57.6667,45.3774],[57.4773,45.3375],[57.3293,45.3037],[57.1717,45.2677],[56.965,45.2206],[56.7919,45.1811],[56.5888,45.1348],[56.4092,45.0938],[56.2579,45.0593],[56.1005,45.0234],[55.9757,44.9949],[55.9758,44.7654],[55.976,44.5358],[55.9761,44.3063],[55.9762,44.0768],[55.9763,43.8472],[55.9764,43.6176],[55.9765,43.3881],[55.9766,43.1586],[55.9767,42.9291],[55.9768,42.6995],[55.9769,42.47],[55.977,42.2404],[55.9771,42.0109],[55.9771,41.7813],[55.9773,41.5518],[55.9774,41.3222],[55.935,41.3241],[55.8391,41.3108],[55.6786,41.2788],[55.5452,41.2627],[55.487,41.2723],[55.4344,41.2963],[55.3884,41.3469],[55.3197,41.4084],[55.2496,41.4581],[55.1623,41.5603],[55.1019,41.6387],[54.9523,41.81],[54.9316,41.864],[54.9037,41.9191],[54.8538,41.9652],[54.6779,42.0782],[54.4729,42.1802],[54.2719,42.28],[54.2149,42.3042],[54.121,42.3352],[54.0052,42.3359],[53.9264,42.3298],[53.6854,42.2969],[53.5008,42.2583],[53.2501,42.2059],[53.0559,42.1478],[53.0125,42.1307],[52.8705,42.0606],[52.6969,41.9444],[52.4938,41.7804],[52.4676,41.8859],[52.4586,42.0483],[52.4621,42.1006],[52.5172,42.2372],[52.5732,42.3309],[52.6184,42.4282],[52.6385,42.5557],[52.5966,42.7602],[52.55,42.8055],[52.4939,42.8203],[52.4343,42.8245],[52.3244,42.8162],[52.273,42.7998],[52.1837,42.8687],[52.0756,42.8798],[52.0186,42.8605],[51.9607,42.8506],[51.8982,42.8696],[51.8441,42.9104],[51.811,42.9544],[51.7852,43.0043],[51.7004,43.1041],[51.616,43.1584],[51.5141,43.1705],[51.3479,43.1674],[51.2954,43.1741],[51.2924,43.2307],[51.3134,43.3557],[51.3139,43.4208],[51.3018,43.4824],[51.2741,43.5329],[51.239,43.5767],[51.1396,43.6488],[51.0648,43.7501],[50.9398,43.9585],[50.8308,44.1928],[50.7826,44.228],[50.685,44.2651],[50.4718,44.2948],[50.3312,44.3255],[50.2756,44.3551],[50.2525,44.4065],[50.2529,44.4615],[50.2646,44.5266],[50.2975,44.5815],[50.4095,44.624],[50.6524,44.6333],[50.8604,44.6288],[51.0488,44.5305],[51.1107,44.5078],[51.1771,44.5014],[51.3107,44.5324],[51.3767,44.5412],[51.5436,44.531],[51.4938,44.5775],[51.4311,44.602],[51.3663,44.5999],[51.3103,44.6187],[51.2182,44.709],[51.0579,44.8116],[51.0207,44.854],[51.0094,44.9218],[51.0403,44.9803],[51.1537,45.0402],[51.2499,45.1217],[51.294,45.2298],[51.3334,45.2796],[51.4157,45.3579],[51.5396,45.3429],[51.7326,45.3995],[52.0487,45.3884],[52.4268,45.4046],[52.5311,45.3986],[52.772,45.3435],[52.9107,45.3197],[53.0789,45.3075],[53.2004,45.332],[53.0857,45.4074],[52.8375,45.4967],[52.7738,45.5728],[52.8875,45.7795],[53.0416,45.9679],[53.1353,46.1917],[53.109,46.4141],[53.064,46.4753],[53.0785,46.5475],[53.1324,46.6083],[53.1702,46.669],[53.1375,46.742],[53.0694,46.8561],[53.0346,46.8929],[52.916,46.9544],[52.6776,46.9571],[52.4832,46.9907],[52.4203,46.9637],[52.3849,46.9221],[52.3403,46.8948],[52.1888,46.8395],[52.1383,46.8286],[52.0855,46.8396],[52.0111,46.9019],[51.9451,46.8949],[51.7445,46.9337],[51.6501,47.0181],[51.6152,47.0299],[51.2908,47.0973],[51.178,47.1102],[50.92,47.0407],[50.7327,46.9517],[50.6799,46.9387],[50.5829,46.8823],[50.5284,46.8733],[50.4723,46.8829],[50.4193,46.8795],[50.3063,46.7949],[50.1016,46.6964],[49.9998,46.6343],[49.8863,46.5957],[49.7605,46.5715],[49.6315,46.5676],[49.5844,46.5452],[49.4372,46.5373],[49.3475,46.5191],[49.3442,46.4855],[49.3621,46.4102],[49.2858,46.4368],[49.2057,46.3857],[49.2322,46.3372],[49.1843,46.3488],[48.959,46.4421],[48.7743,46.508],[48.6102,46.5665],[48.586,46.5771],[48.5412,46.6056],[48.5092,46.65],[48.5023,46.6986],[48.5186,46.7343],[48.5584,46.7571],[48.6053,46.7659],[48.6471,46.7587],[48.6936,46.7368],[48.7764,46.7104],[48.8836,46.7054],[48.9503,46.7258],[48.9594,46.7746],[48.8318,46.9549],[48.7144,47.1005],[48.6007,47.2623],[48.5525,47.321],[48.4131,47.4565],[48.2757,47.5899],[48.167,47.7088],[48.11,47.7454],[47.9347,47.7607],[47.6002,47.79],[47.4819,47.8039],[47.3873,47.7687],[47.2924,47.7409],[47.2021,47.7925],[47.1308,47.8768],[47.0933,47.9477],[47.1115,48.0201],[47.119,48.127],[47.0646,48.2325],[47.0043,48.2845],[46.8531,48.3236],[46.6609,48.4123],[46.6092,48.5739],[46.7026,48.8056],[46.8529,48.9696],[46.9622,49.0383],[47.0143,49.0983],[47.0313,49.1503],[47.0182,49.1999],[46.9534,49.2526],[46.8529,49.3039],[46.8021,49.3671],[46.8231,49.5022],[46.8896,49.697],[46.992,49.8527],[47.1296,49.9391],[47.2483,50.0009],[47.2952,50.0585],[47.2977,50.1402],[47.2947,50.2175],[47.3265,50.2735],[47.3764,50.3181],[47.4292,50.358],[47.5036,50.4027],[47.5996,50.4136],[47.7058,50.378],[47.8496,50.2823],[48.0607,50.0936],[48.1813,49.97],[48.2248,49.9319],[48.335,49.8583],[48.4343,49.8285],[48.6,49.8747],[48.759,49.9283],[48.8103,49.9624],[48.8433,50.0131],[48.818,50.0999],[48.7848,50.1564],[48.7494,50.2285],[48.7005,50.3538],[48.666,50.5503],[48.6251,50.6127],[48.6552,50.6199],[48.7348,50.6069],[48.8084,50.6013],[48.9138,50.6446],[49.0587,50.7261],[49.3234,50.8517],[49.3795,50.9347],[49.4246,51.027],[49.498,51.0836],[49.6663,51.1023],[49.8223,51.1319],[49.9323,51.1972],[50.1049,51.2546],[50.2469,51.2895],[50.3093,51.3216],[50.3537,51.3697],[50.5163,51.5056],[50.6439,51.5892],[50.7562,51.6751],[50.7939,51.7292],[50.8824,51.7192],[51.0179,51.6816],[51.1635,51.6475],[51.2699,51.5945],[51.2907,51.5402],[51.3011,51.4974],[51.3445,51.4753],[51.396,51.4713],[51.4734,51.482],[51.6091,51.484],[51.7754,51.5542],[52.0071,51.6727],[52.2191,51.7094],[52.3311,51.6813],[52.423,51.5942],[52.4962,51.5122],[52.5712,51.4816],[52.6178,51.4808],[52.6352,51.4795],[52.7281,51.4981],[52.7351,51.4979],[52.8205,51.4946],[52.9026,51.4669],[53.0384,51.4637],[53.2273,51.485],[53.2473,51.4936],[53.3381,51.4824],[53.4486,51.4445],[53.5347,51.3996],[53.6881,51.2518],[53.7765,51.2137],[53.9568,51.1612],[54.0415,51.1152],[54.1397,51.0408],[54.1911,50.9957],[54.2979,50.9141],[54.4215,50.7803],[54.4434,50.6739],[54.4715,50.5838],[54.5174,50.5412],[54.5553,50.5358],[54.5962,50.5507],[54.6361,50.5916],[54.65,50.6602],[54.6379,50.7811],[54.6063,50.8799],[54.5656,50.9113],[54.5461,50.946],[54.5729,50.9902],[54.6416,51.0116],[54.7271,50.9981],[54.868,50.9414],[55.0148,50.8698],[55.1952,50.7447],[55.3611,50.6653],[55.5423,50.6018],[55.6862,50.5829],[55.7977,50.6021],[55.9292,50.6538],[56.0497,50.7135],[56.1045,50.7763],[56.1439,50.8446],[56.3256,50.9361],[56.4914,51.0195],[56.5669,51.0045],[56.6202,50.9809],[56.7903,51.0316],[56.8496,51.0456],[57.0117,51.0652],[57.179,51.036],[57.3125,50.9465],[57.4422,50.8889],[57.5578,50.8956],[57.6538,50.9251],[57.717,50.981],[57.7648,51.0469],[57.8289,51.089],[57.8389,51.0917],[58.0451,51.0688],[58.1747,51.0723],[58.1885,51.0817],[58.3592,51.0638],[58.5475,50.971],[58.6646,50.8683],[58.8141,50.7372],[58.8837,50.6944],[58.9849,50.6761],[59.0644,50.6682],[59.1709,50.6479],[59.4523,50.6204],[59.4951,50.6043],[59.5239,50.5828],[59.4979,50.5111],[59.523,50.4929],[59.7512,50.5439],[59.8124,50.582],[59.8878,50.6902],[59.9552,50.7993],[60.0053,50.8397],[60.0586,50.8503],[60.1121,50.8342],[60.1867,50.7698],[60.2881,50.7042],[60.4248,50.6792],[60.5085,50.6692],[60.638,50.6637],[60.9423,50.6955],[61.2269,50.7748],[61.3895,50.861],[61.465,50.9902],[61.5122,51.137],[61.5851,51.2297],[61.5547,51.3246],[61.4113,51.4147],[61.3631,51.4419],[61.0148,51.4924],[60.9934,51.5287],[60.9735,51.5371],[60.6304,51.6169],[60.4647,51.6512],[60.4184,51.7039],[60.3875,51.773],[60.2804,51.8346],[60.0675,51.8906],[60.0303,51.9333],[60.0655,51.9765],[60.2337,52.0245],[60.4255,52.1256],[60.4993,52.1463],[60.6703,52.1508],[60.8284,52.2334],[60.9376,52.2806],[60.9945,52.3369],[60.9795,52.3948],[60.8213,52.5698],[60.7744,52.6758],[60.8023,52.7447],[60.8933,52.8194],[60.9447,52.8602],[61.0065,52.9333],[61.0475,52.9725],[61.2069,52.9891],[61.4008,52.996],[61.5336,52.9785],[61.7193,52.9694],[61.8886,52.9559],[61.9742,52.9438],[62.0371,52.9661],[62.0827,53.0054],[62.0811,53.0574],[62.0146,53.1079],[61.7662,53.1739],[61.6599,53.2285],[61.5762,53.2225],[61.4368,53.2394],[61.3109,53.2752],[61.1992,53.2872],[61.1628,53.3368],[61.1859,53.4062],[61.2289,53.4459],[61.3116,53.4657],[61.401,53.4558],[61.4985,53.4847],[61.5266,53.5016],[61.535,53.5233],[61.5191,53.5545],[61.4741,53.5803],[61.41,53.5871],[61.3361,53.5652],[61.2479,53.551],[61.0985,53.5831],[60.9795,53.6217],[60.9855,53.6574],[61.0735,53.7104],[61.1132,53.7535],[61.1132,53.813],[61.1132,53.8825],[61.1438,53.9638],[61.2311,54.0195],[61.3337,54.0493],[61.5981,53.9949],[61.9287,53.9465],[61.9856,53.9544],[62.0023,53.9799],[62.0402,54.0026],[62.499,54.0132],[62.5883,54.0444],[62.6327,54.0693],[63.0739,54.1052],[63.1266,54.1393],[63.1913,54.171],[63.2927,54.1705],[63.4137,54.1832],[63.582,54.2219],[63.7014,54.2432],[63.7212,54.245],[63.8471,54.2365],[64.0039,54.2671],[64.0374,54.2797],[64.0629,54.3029],[64.1994,54.3474],[64.4612,54.3842],[64.5251,54.3622],[64.6499,54.3522],[64.8093,54.3686],[64.9268,54.3966],[64.9954,54.3688],[65.0884,54.3402],[65.1578,54.3644],[65.1922,54.4411],[65.2374,54.5161],[65.3159,54.5516],[65.3781,54.5645],[65.4344,54.5933],[65.477,54.6233],[65.7078,54.6187],[65.9143,54.6933],[65.9547,54.6595],[66.2227,54.6674],[66.5554,54.7154],[66.7545,54.7379],[67.0983,54.7882],[67.2573,54.8288],[67.4847,54.8545],[67.6934,54.8724],[67.8299,54.9436],[67.9399,54.9537],[68.0738,54.9596],[68.1559,54.9767],[68.2094,55.003],[68.244,55.0524],[68.2253,55.1152],[68.2063,55.1609],[68.302,55.1865],[68.4385,55.1944],[68.5248,55.2048],[68.7129,55.3085],[68.843,55.3583],[68.9772,55.3896],[69.247,55.3725],[69.4933,55.3569],[69.7402,55.3074],[69.8702,55.2457],[69.9817,55.1991],[70.0874,55.1768]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Kazakhstan","sov_a3":"KAZ","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Kazakhstan","adm0_a3":"KAZ","geou_dif":0,"geounit":"Kazakhstan","gu_a3":"KAZ","su_dif":0,"subunit":"Kazakhstan","su_a3":"KAZ","brk_diff":0,"name":"Kazakhstan","name_long":"Kazakhstan","brk_a3":"KAZ","brk_name":"Kazakhstan","brk_group":"","abbrev":"Kaz.","postal":"KZ","formal_en":"Republic of Kazakhstan","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Kazakhstan","name_alt":"","mapcolor7":6,"mapcolor8":1,"mapcolor9":6,"mapcolor13":1,"pop_est":15399437,"gdp_md_est":175800,"pop_year":-99,"lastcensus":2009,"gdp_year":-99,"economy":"6. Developing region","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"KZ","iso_a3":"KAZ","iso_n3":"398","un_a3":"398","wb_a2":"KZ","wb_a3":"KAZ","woe_id":-99,"adm0_a3_is":"KAZ","adm0_a3_us":"KAZ","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Central Asia","region_wb":"Europe & Central Asia","name_len":10,"long_len":10,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[103.3178,10.7185],[103.2813,10.6797],[103.2229,10.7596],[103.2234,10.782],[103.3178,10.7185]],[[103.0451,11.2851],[103.0273,11.2755],[103.0105,11.2758],[102.9934,11.2904],[102.995,11.3481],[103.0075,11.3833],[103.0368,11.3899],[103.0451,11.2851]],[[107.5353,14.65],[107.4932,14.5458],[107.4484,14.4512],[107.3645,14.3687],[107.3604,14.3079],[107.3314,14.1266],[107.3426,14.0689],[107.3621,14.0195],[107.3895,13.993],[107.4623,13.8156],[107.5286,13.6542],[107.5939,13.5217],[107.6055,13.4378],[107.5455,13.2254],[107.4754,13.0304],[107.4815,12.9331],[107.5115,12.8357],[107.5436,12.7059],[107.5555,12.54],[107.5381,12.4318],[107.5064,12.3646],[107.446,12.2957],[107.3934,12.2605],[107.3301,12.319],[107.2797,12.3216],[107.2121,12.304],[107.159,12.2771],[107.0507,12.1759],[106.9307,12.0775],[106.7646,12.0523],[106.7001,11.9793],[106.631,11.9692],[106.4996,11.9655],[106.4139,11.9484],[106.4178,11.9117],[106.4107,11.7384],[106.4125,11.6978],[106.3992,11.687],[106.3398,11.6818],[106.2392,11.7083],[106.1029,11.7513],[106.0061,11.758],[105.9563,11.6825],[105.9266,11.6529],[105.8898,11.6484],[105.8515,11.635],[105.8385,11.6013],[105.8354,11.5591],[105.854,11.4871],[105.8609,11.3724],[105.8561,11.2943],[105.8916,11.2448],[106.0995,11.0787],[106.1609,11.0371],[106.168,11.0123],[106.1315,10.922],[106.164,10.7949],[106.0988,10.7973],[105.9901,10.8518],[105.9382,10.8852],[105.8752,10.8585],[105.8533,10.8636],[105.8107,10.9261],[105.7551,10.99],[105.6978,10.994],[105.5766,10.9689],[105.4527,10.9514],[105.4058,10.9516],[105.3865,10.9401],[105.3146,10.8452],[105.2843,10.8615],[105.1595,10.8976],[105.0457,10.9114],[105.0223,10.8869],[105.0361,10.8094],[105.0611,10.7338],[105.0464,10.7017],[104.9839,10.6619],[104.9013,10.5902],[104.8506,10.5345],[104.8154,10.5208],[104.6896,10.5232],[104.5643,10.516],[104.5141,10.4633],[104.467,10.4224],[104.4264,10.4112],[104.2624,10.5413],[103.9371,10.5866],[103.9018,10.6439],[103.8705,10.6551],[103.8405,10.5806],[103.6619,10.5089],[103.5871,10.5522],[103.5322,10.6046],[103.5404,10.6687],[103.5921,10.721],[103.6809,10.7586],[103.7219,10.8901],[103.6543,11.0587],[103.595,11.1078],[103.5324,11.1467],[103.4667,11.084],[103.4113,10.9768],[103.3536,10.9216],[103.2722,10.9093],[103.1528,10.9137],[103.1064,11.0738],[103.0911,11.2111],[103.1074,11.3678],[103.1255,11.4606],[103.0105,11.5887],[103.0042,11.7106],[102.9486,11.7735],[102.9323,11.7417],[102.9339,11.7067],[102.9181,11.7321],[102.7366,12.0898],[102.7063,12.2557],[102.7374,12.3834],[102.7557,12.4263],[102.7033,12.4935],[102.6297,12.5699],[102.4996,12.67],[102.4907,12.8283],[102.4617,13.015],[102.4227,13.078],[102.363,13.193],[102.3308,13.2882],[102.3197,13.54],[102.3363,13.5603],[102.4285,13.5676],[102.5469,13.5857],[102.5655,13.6264],[102.5447,13.66],[102.6204,13.7169],[102.7289,13.8419],[102.8128,13.9725],[102.8732,14.0549],[102.9093,14.1367],[103.0311,14.2525],[103.1994,14.3326],[103.3135,14.3513],[103.4324,14.3786],[103.5464,14.4174],[103.6004,14.4211],[103.7419,14.3742],[103.8184,14.3622],[103.8986,14.3628],[103.9818,14.3579],[104.0543,14.3627],[104.2277,14.3955],[104.4116,14.3696],[104.5758,14.39],[104.779,14.4278],[104.8788,14.404],[104.9697,14.3661],[104.9824,14.2895],[105.0034,14.2544],[105.0337,14.2274],[105.0741,14.2274],[105.126,14.281],[105.1691,14.3361],[105.1833,14.3462],[105.1855,14.3191],[105.207,14.2594],[105.2457,14.2005],[105.2849,14.1615],[105.3502,14.1096],[105.3927,14.1071],[105.5315,14.1562],[105.7397,14.085],[105.7641,14.0491],[105.8314,13.9766],[105.9045,13.9245],[106.0668,13.9212],[106.1247,14.0491],[106.0967,14.1271],[106.0041,14.2629],[105.9789,14.343],[106.0084,14.3572],[106.1652,14.3724],[106.1907,14.3881],[106.2254,14.4762],[106.268,14.4662],[106.355,14.4548],[106.447,14.515],[106.5015,14.5782],[106.5312,14.5494],[106.5637,14.5051],[106.5992,14.4794],[106.6654,14.4413],[106.7382,14.3877],[106.7835,14.3351],[106.8199,14.3147],[106.9132,14.3294],[106.9381,14.3273],[106.9922,14.391],[107.0302,14.4257],[107.0624,14.4158],[107.1094,14.4167],[107.2066,14.4979],[107.2623,14.5721],[107.2927,14.5924],[107.3799,14.5553],[107.4147,14.5629],[107.4651,14.665],[107.5194,14.7051],[107.5353,14.65]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Cambodia","sov_a3":"KHM","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Cambodia","adm0_a3":"KHM","geou_dif":0,"geounit":"Cambodia","gu_a3":"KHM","su_dif":0,"subunit":"Cambodia","su_a3":"KHM","brk_diff":0,"name":"Cambodia","name_long":"Cambodia","brk_a3":"KHM","brk_name":"Cambodia","brk_group":"","abbrev":"Camb.","postal":"KH","formal_en":"Kingdom of Cambodia","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Cambodia","name_alt":"","mapcolor7":6,"mapcolor8":3,"mapcolor9":6,"mapcolor13":5,"pop_est":14494293,"gdp_md_est":27940,"pop_year":-99,"lastcensus":2008,"gdp_year":-99,"economy":"7. Least developed region","income_grp":"5. Low income","wikipedia":-99,"fips_10":"","iso_a2":"KH","iso_a3":"KHM","iso_n3":"116","un_a3":"116","wb_a2":"KH","wb_a3":"KHM","woe_id":-99,"adm0_a3_is":"KHM","adm0_a3_us":"KHM","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"South-Eastern Asia","region_wb":"East Asia & Pacific","name_len":8,"long_len":8,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[80.2094,42.19],[80.2292,42.1298],[80.2462,42.0598],[80.2352,42.0435],[80.2162,42.0324],[79.9097,42.015],[79.8404,41.9958],[79.7661,41.8989],[79.5039,41.821],[79.3544,41.7811],[79.2936,41.7828],[79.1484,41.7191],[78.7426,41.5601],[78.5432,41.4596],[78.4429,41.4175],[78.3624,41.3716],[78.3488,41.3252],[78.3463,41.2814],[78.1234,41.0756],[77.9564,41.0507],[77.8152,41.0556],[77.7193,41.0243],[77.5817,40.9928],[77.284,41.0144],[77.182,41.0107],[76.9866,41.0392],[76.9077,41.0242],[76.824,40.9823],[76.7084,40.8181],[76.6611,40.7796],[76.6398,40.7422],[76.6222,40.6624],[76.5779,40.5779],[76.5209,40.5112],[76.4802,40.4495],[76.3964,40.3898],[76.3186,40.3522],[76.2583,40.4308],[76.2061,40.4084],[76.1566,40.3765],[76.0623,40.3875],[76.0043,40.3714],[75.872,40.3032],[75.6771,40.3058],[75.656,40.3292],[75.6174,40.5166],[75.5835,40.6053],[75.5556,40.6252],[75.5208,40.6275],[75.241,40.4803],[75.1113,40.4541],[75.0045,40.4495],[74.8656,40.4935],[74.8352,40.4826],[74.8111,40.4588],[74.8013,40.4285],[74.8418,40.345],[74.8305,40.3285],[74.7678,40.3299],[74.6799,40.3106],[74.6131,40.2722],[74.4119,40.1372],[74.2427,40.092],[74.0852,40.0743],[74.0205,40.0594],[73.9916,40.0431],[73.9388,39.9788],[73.8846,39.8779],[73.8563,39.8287],[73.8354,39.8001],[73.8397,39.7628],[73.8825,39.7146],[73.9146,39.6065],[73.9071,39.5785],[73.8728,39.5333],[73.8229,39.489],[73.7157,39.4623],[73.6316,39.4489],[73.5756,39.4576],[73.4704,39.4606],[73.3874,39.4427],[73.3361,39.4124],[73.235,39.3746],[73.1093,39.3619],[72.9494,39.3571],[72.8725,39.3604],[72.6399,39.386],[72.5634,39.3772],[72.4902,39.3574],[72.3577,39.3369],[72.2872,39.2737],[72.2498,39.2157],[72.23,39.2075],[72.1474,39.2607],[72.0842,39.3106],[72.0428,39.3521],[71.991,39.3509],[71.806,39.2756],[71.7786,39.278],[71.7257,39.3066],[71.7354,39.3777],[71.7322,39.423],[71.6727,39.4471],[71.5463,39.4531],[71.5033,39.4788],[71.5059,39.5171],[71.5174,39.5539],[71.503,39.5822],[71.4703,39.6037],[71.4043,39.5979],[71.3285,39.5687],[71.2729,39.5353],[71.2027,39.5198],[71.1181,39.5136],[71.065,39.4934],[71.0049,39.4119],[70.7993,39.3947],[70.7331,39.4133],[70.6786,39.4713],[70.6078,39.5644],[70.568,39.5759],[70.5012,39.5874],[70.3921,39.5819],[70.2448,39.5426],[70.2093,39.575],[70.1711,39.5842],[70.1368,39.5576],[70.1017,39.5606],[69.956,39.5531],[69.7721,39.5567],[69.667,39.5749],[69.5988,39.5738],[69.4633,39.5321],[69.3915,39.5325],[69.2977,39.5248],[69.2803,39.6659],[69.2291,39.7611],[69.2447,39.8271],[69.2788,39.9178],[69.3072,39.9686],[69.3654,39.9471],[69.4319,39.9098],[69.4763,39.9197],[69.4879,39.9504],[69.471,39.9906],[69.4688,40.0208],[69.4937,40.0604],[69.5303,40.0973],[69.7652,40.158],[69.9668,40.2022],[70.0715,40.1728],[70.2744,40.1048],[70.3789,40.0699],[70.4514,40.0492],[70.5151,39.9499],[70.5568,39.9545],[70.5992,39.9745],[70.6241,39.999],[70.6443,40.0834],[70.7386,40.1312],[70.9464,40.1876],[70.9609,40.2207],[70.958,40.2389],[70.9906,40.2549],[71.0945,40.2712],[71.3047,40.2869],[71.3762,40.2752],[71.4574,40.242],[71.5204,40.209],[71.5805,40.2103],[71.6299,40.2171],[71.6509,40.208],[71.6668,40.1786],[71.6925,40.1523],[71.7727,40.188],[71.8454,40.2343],[71.9027,40.241],[71.9557,40.2586],[71.9711,40.2895],[72.0126,40.3407],[72.1313,40.4386],[72.1929,40.4544],[72.2328,40.4544],[72.2347,40.4386],[72.254,40.4242],[72.3577,40.4017],[72.3893,40.4274],[72.406,40.4631],[72.3697,40.5197],[72.369,40.5435],[72.3826,40.5651],[72.4021,40.5781],[72.5675,40.5244],[72.6041,40.5254],[72.6796,40.5556],[72.7488,40.6087],[72.7738,40.6504],[73.1129,40.786],[73.1369,40.8106],[73.1321,40.8285],[72.99,40.8601],[72.926,40.8424],[72.8666,40.8423],[72.831,40.8622],[72.6583,40.8699],[72.6204,40.8838],[72.506,40.9817],[72.4273,41.0189],[72.3641,41.0435],[72.2949,41.0399],[72.2131,41.0143],[72.1873,41.0259],[72.1807,41.0668],[72.181,41.1185],[72.1643,41.1737],[72.1154,41.1866],[72.0524,41.1647],[71.9585,41.1871],[71.8786,41.195],[71.858,41.3114],[71.8258,41.361],[71.7925,41.4131],[71.7577,41.428],[71.7007,41.454],[71.6973,41.5156],[71.6852,41.533],[71.6649,41.5412],[71.6375,41.5342],[71.6022,41.5033],[71.6196,41.4354],[71.6063,41.3674],[71.5855,41.3333],[71.5456,41.3081],[71.5,41.3075],[71.4209,41.3419],[71.4084,41.136],[71.3931,41.1234],[71.2988,41.1525],[71.2234,41.1399],[71.1107,41.1526],[71.026,41.1866],[70.9626,41.196],[70.8604,41.2249],[70.7824,41.2625],[70.7344,41.4005],[70.6889,41.4498],[70.6459,41.4604],[70.4714,41.4126],[70.4078,41.4496],[70.29,41.4968],[70.2009,41.5145],[70.177,41.54],[70.181,41.5714],[70.455,41.725],[70.5629,41.8308],[70.6309,41.8755],[70.7277,41.9052],[70.8033,41.9227],[70.8419,42.0196],[70.8566,42.0308],[70.9104,42.038],[71.0322,42.0778],[71.2285,42.1629],[71.2323,42.1863],[71.2127,42.2064],[71.13,42.25],[71.036,42.2847],[70.979,42.2666],[70.9468,42.2487],[70.8929,42.2937],[70.8929,42.34],[70.9523,42.4194],[71.002,42.4591],[71.0228,42.5354],[71.0936,42.5865],[71.1674,42.6674],[71.2566,42.7335],[71.4221,42.7832],[71.5143,42.7669],[71.6008,42.7787],[71.7348,42.8189],[71.7605,42.8215],[71.8168,42.8222],[72.1618,42.7607],[72.2758,42.7577],[72.5432,42.6777],[72.6661,42.6604],[72.7529,42.6379],[72.7924,42.6035],[72.8551,42.5611],[73.1908,42.5269],[73.2829,42.5041],[73.316,42.467],[73.4116,42.4198],[73.493,42.409],[73.4219,42.5935],[73.4502,42.703],[73.5563,43.0028],[73.612,43.0479],[73.7186,43.0879],[73.886,43.1326],[73.9492,43.195],[74.0862,43.1886],[74.1459,43.1941],[74.1868,43.2053],[74.2091,43.2404],[74.3639,43.1794],[74.6223,43.0562],[74.8176,42.9782],[75.0477,42.9044],[75.3662,42.837],[75.6356,42.8146],[75.6817,42.8305],[75.7896,42.9329],[75.8403,42.9375],[75.9322,42.9285],[76.2182,42.9237],[76.5092,42.9189],[76.6465,42.9288],[76.944,42.9715],[76.9881,42.9736],[77.0573,42.9707],[77.2355,42.9126],[77.3686,42.9044],[77.4593,42.9047],[77.5122,42.9],[77.6225,42.9022],[77.8017,42.8952],[78.0231,42.8575],[78.29,42.8644],[78.376,42.8715],[78.5242,42.8646],[78.6423,42.8287],[78.7915,42.7908],[78.8852,42.7749],[78.9479,42.7667],[79.0599,42.7638],[79.1267,42.7757],[79.1648,42.759],[79.203,42.666],[79.2955,42.6048],[79.3678,42.5472],[79.4282,42.4835],[79.4901,42.4576],[79.5984,42.4566],[79.8034,42.4385],[79.9211,42.4131],[80.0713,42.303],[80.2094,42.19]],[[70.7017,39.8253],[70.6982,39.8458],[70.6642,39.8555],[70.5671,39.8666],[70.4978,39.8824],[70.4828,39.8827],[70.4893,39.863],[70.5187,39.8282],[70.5596,39.7909],[70.6121,39.7868],[70.7017,39.8253]],[[71.7797,39.9502],[71.7899,39.9953],[71.7653,39.9933],[71.7365,39.981],[71.6813,39.9687],[71.6689,39.9461],[71.7059,39.9174],[71.7529,39.9071],[71.7797,39.9502]],[[71.2062,39.8926],[71.2156,39.9068],[71.1793,39.9798],[71.2287,40.0481],[71.1303,40.0597],[71.0804,40.0799],[71.0241,40.1492],[71.0055,40.1523],[70.9763,40.1333],[70.9606,40.088],[70.9744,40.0389],[71.0145,40.0058],[71.041,39.9949],[71.0448,39.9925],[71.0437,39.9763],[71.0117,39.8951],[71.0643,39.8849],[71.1563,39.8834],[71.2062,39.8926]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":4,"sovereignt":"Kyrgyzstan","sov_a3":"KGZ","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Kyrgyzstan","adm0_a3":"KGZ","geou_dif":0,"geounit":"Kyrgyzstan","gu_a3":"KGZ","su_dif":0,"subunit":"Kyrgyzstan","su_a3":"KGZ","brk_diff":0,"name":"Kyrgyzstan","name_long":"Kyrgyzstan","brk_a3":"KGZ","brk_name":"Kyrgyzstan","brk_group":"","abbrev":"Kgz.","postal":"KG","formal_en":"Kyrgyz Republic","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Kyrgyz Republic","name_alt":"","mapcolor7":5,"mapcolor8":7,"mapcolor9":7,"mapcolor13":6,"pop_est":5431747,"gdp_md_est":11610,"pop_year":-99,"lastcensus":2009,"gdp_year":-99,"economy":"6. Developing region","income_grp":"5. Low income","wikipedia":-99,"fips_10":"","iso_a2":"KG","iso_a3":"KGZ","iso_n3":"417","un_a3":"417","wb_a2":"KG","wb_a3":"KGZ","woe_id":-99,"adm0_a3_is":"KGZ","adm0_a3_us":"KGZ","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Central Asia","region_wb":"Europe & Central Asia","name_len":10,"long_len":10,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[39.1454,32.1245],[38.9971,32.0075],[38.9623,31.9949],[38.7696,31.9465],[38.3755,31.8475],[38.1114,31.7812],[37.7738,31.6963],[37.4934,31.6259],[37.2156,31.5561],[36.9586,31.4915],[37.1053,31.3552],[37.3295,31.1468],[37.479,31.0078],[37.6555,30.829],[37.813,30.6693],[37.9801,30.5],[37.8629,30.4426],[37.6697,30.3481],[37.6499,30.331],[37.6336,30.3133],[37.5536,30.1446],[37.4907,30.0117],[37.4692,29.9951],[37.1994,29.9463],[36.9271,29.8971],[36.7553,29.866],[36.7039,29.8316],[36.5918,29.6661],[36.4761,29.4951],[36.2828,29.3554],[36.0685,29.2005],[36.0154,29.1905],[35.8604,29.2143],[35.5953,29.2549],[35.3392,29.2941],[35.1638,29.3209],[34.9508,29.3535],[34.9822,29.4845],[34.9734,29.555],[35.0239,29.7871],[35.0534,29.8969],[35.0682,29.9779],[35.1416,30.1417],[35.1326,30.1953],[35.1481,30.3843],[35.1406,30.4209],[35.174,30.5239],[35.2366,30.6735],[35.2979,30.8022],[35.3201,30.8602],[35.383,30.9823],[35.4393,31.1324],[35.4097,31.2145],[35.4007,31.2305],[35.4235,31.3249],[35.4229,31.3254],[35.4506,31.4793],[35.4654,31.5624],[35.4994,31.6724],[35.559,31.7655],[35.5314,31.9849],[35.5348,32.103],[35.5721,32.2379],[35.5515,32.3955],[35.569,32.6199],[35.5729,32.6409],[35.5945,32.668],[35.6112,32.6821],[35.7345,32.7289],[35.7873,32.7349],[35.8947,32.7138],[35.9564,32.6667],[36.0595,32.5338],[36.2197,32.4951],[36.2843,32.4575],[36.3721,32.3869],[36.4792,32.3613],[36.8184,32.3173],[37.089,32.4655],[37.3176,32.5908],[37.5774,32.7331],[37.7541,32.8298],[38.0558,32.9949],[38.2543,33.0992],[38.5156,33.2366],[38.7735,33.3722],[38.845,33.1509],[38.9148,32.9347],[38.9874,32.7107],[39.0578,32.4932],[38.9816,32.4726],[39.0414,32.3057],[39.14,32.3312],[39.2475,32.351],[39.2928,32.2438],[39.1454,32.1245]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":4,"sovereignt":"Jordan","sov_a3":"JOR","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Jordan","adm0_a3":"JOR","geou_dif":0,"geounit":"Jordan","gu_a3":"JOR","su_dif":0,"subunit":"Jordan","su_a3":"JOR","brk_diff":0,"name":"Jordan","name_long":"Jordan","brk_a3":"JOR","brk_name":"Jordan","brk_group":"","abbrev":"Jord.","postal":"J","formal_en":"Hashemite Kingdom of Jordan","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Jordan","name_alt":"","mapcolor7":5,"mapcolor8":3,"mapcolor9":4,"mapcolor13":4,"pop_est":6342948,"gdp_md_est":31610,"pop_year":-99,"lastcensus":2004,"gdp_year":-99,"economy":"6. Developing region","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"JO","iso_a3":"JOR","iso_n3":"400","un_a3":"400","wb_a2":"JO","wb_a3":"JOR","woe_id":-99,"adm0_a3_is":"JOR","adm0_a3_us":"JOR","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Western Asia","region_wb":"Middle East & North Africa","name_len":6,"long_len":6,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[-2.0187,49.2312],[-2.0099,49.1808],[-2.0538,49.1698],[-2.091,49.1874],[-2.1657,49.1874],[-2.2358,49.1764],[-2.2205,49.2664],[-2.0822,49.2554],[-2.0187,49.2312]]]},"properties":{"scalerank":4,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"United Kingdom","sov_a3":"GB1","adm0_dif":1,"level":2,"type":"Country","admin":"Jersey","adm0_a3":"JEY","geou_dif":0,"geounit":"Jersey","gu_a3":"JEY","su_dif":0,"subunit":"Jersey","su_a3":"JEY","brk_diff":0,"name":"Jersey","name_long":"Jersey","brk_a3":"JEY","brk_name":"Jersey","brk_group":"Channel Islands","abbrev":"Jey.","postal":"JE","formal_en":"Bailiwick of Jersey","formal_fr":"","note_adm0":"U.K. crown dependency","note_brk":"","name_sort":"Jersey","name_alt":"","mapcolor7":6,"mapcolor8":6,"mapcolor9":6,"mapcolor13":3,"pop_est":91626,"gdp_md_est":5100,"pop_year":-99,"lastcensus":2001,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"JE","iso_a3":"JEY","iso_n3":"832","un_a3":"832","wb_a2":"JG","wb_a3":"CHI","woe_id":-99,"adm0_a3_is":"JEY","adm0_a3_us":"JEY","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Northern Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":6,"abbrev_len":4,"tiny":-99,"homepart":-99}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[77.7994,35.4959],[77.697,35.4433],[77.5716,35.3788],[77.4234,35.3026],[77.293,35.2355],[77.1686,35.1715],[77.0486,35.1099],[77.0045,35.1963],[76.9789,35.2464],[76.9277,35.3466],[76.8822,35.4357],[76.8128,35.5718],[76.7669,35.6617],[76.8789,35.6133],[77.09,35.5521],[77.2948,35.5082],[77.4465,35.4756],[77.52,35.4734],[77.5726,35.4718],[77.724,35.4806],[77.7994,35.4959]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Kashmir","sov_a3":"KAS","adm0_dif":0,"level":2,"type":"Indeterminate","admin":"Siachen Glacier","adm0_a3":"KAS","geou_dif":0,"geounit":"Siachen Glacier","gu_a3":"KAS","su_dif":0,"subunit":"Siachen Glacier","su_a3":"KAS","brk_diff":1,"name":"Siachen Glacier","name_long":"Siachen Glacier","brk_a3":"B45","brk_name":"Siachen Glacier","brk_group":"Jammu and Kashmir","abbrev":"Siachen","postal":"SG","formal_en":"","formal_fr":"","note_adm0":"","note_brk":"Claimed by Pakistan and India","name_sort":"Kashmir","name_alt":"","mapcolor7":3,"mapcolor8":7,"mapcolor9":6,"mapcolor13":-99,"pop_est":6000,"gdp_md_est":15,"pop_year":-99,"lastcensus":-99,"gdp_year":-99,"economy":"6. Developing region","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"-99","iso_a3":"-99","iso_n3":"-99","un_a3":"-099","wb_a2":"-99","wb_a3":"-99","woe_id":-99,"adm0_a3_is":"-99","adm0_a3_us":"KAS","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Southern Asia","region_wb":"South Asia","name_len":15,"long_len":15,"abbrev_len":7,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[123.8887,24.2801],[123.8256,24.2661],[123.7498,24.2833],[123.6807,24.288],[123.6798,24.3178],[123.7523,24.3485],[123.7537,24.3913],[123.7715,24.4145],[123.9349,24.362],[123.9281,24.3236],[123.8887,24.2801]],[[124.2932,24.5159],[124.2343,24.3581],[124.1856,24.3351],[124.1357,24.3476],[124.0848,24.4358],[124.1204,24.4696],[124.1702,24.4519],[124.2105,24.4586],[124.302,24.5871],[124.324,24.5664],[124.2932,24.5159]],[[125.4441,24.7432],[125.3594,24.7171],[125.2689,24.7325],[125.2836,24.8719],[125.3149,24.8524],[125.3346,24.8047],[125.4019,24.7769],[125.4441,24.7432]],[[142.1882,26.6165],[142.1699,26.6157],[142.1071,26.7215],[142.1253,26.7265],[142.1617,26.71],[142.2021,26.6488],[142.1882,26.6165]],[[128.2588,26.6528],[128.1625,26.6069],[128.127,26.5522],[128.0379,26.5336],[127.9513,26.4565],[127.8671,26.4425],[127.8692,26.3806],[127.9048,26.3281],[127.8487,26.3189],[127.7901,26.2551],[127.7855,26.2087],[127.8064,26.1712],[127.8036,26.1525],[127.7294,26.0972],[127.6531,26.0947],[127.6497,26.1545],[127.6549,26.1992],[127.7271,26.3079],[127.7289,26.4339],[127.7959,26.4485],[127.8204,26.4661],[127.926,26.5557],[127.9455,26.5939],[127.8908,26.6311],[127.8948,26.675],[127.9072,26.6936],[127.9943,26.6794],[128.0297,26.6469],[128.0468,26.6433],[128.0977,26.6678],[128.1216,26.7114],[128.2165,26.7969],[128.2549,26.8819],[128.3316,26.8121],[128.3109,26.7207],[128.2588,26.6528]],[[128.9981,27.7208],[128.9563,27.7025],[128.9,27.7278],[128.8828,27.8424],[128.9076,27.898],[128.9517,27.9103],[128.9897,27.8111],[129.0164,27.7702],[128.9981,27.7208]],[[129.324,28.1049],[129.3306,28.0816],[129.2324,28.1011],[129.1925,28.1925],[129.2574,28.1762],[129.2773,28.1447],[129.324,28.1049]],[[129.4525,28.209],[129.3664,28.1277],[129.2749,28.2009],[129.1646,28.2498],[129.2171,28.2629],[129.2479,28.2825],[129.2509,28.3136],[129.3225,28.3596],[129.4646,28.3953],[129.5097,28.3975],[129.5605,28.4311],[129.5771,28.4613],[129.598,28.4759],[129.6896,28.5175],[129.7146,28.4696],[129.7104,28.4321],[129.6417,28.4113],[129.5746,28.3612],[129.5127,28.2987],[129.4567,28.2723],[129.4391,28.2548],[129.4525,28.209]],[[130.6228,30.263],[130.5082,30.2414],[130.4456,30.2647],[130.3881,30.3882],[130.4972,30.4655],[130.6436,30.389],[130.6732,30.3669],[130.6228,30.263]],[[130.9598,30.3969],[130.8722,30.3863],[130.8703,30.4442],[130.9399,30.5751],[130.9474,30.6712],[131.0122,30.7923],[131.0398,30.8189],[131.0604,30.8285],[131.0826,30.7909],[131.0574,30.6425],[130.9926,30.53],[130.9598,30.3969]],[[129.718,31.6571],[129.6868,31.6396],[129.7068,31.7183],[129.7873,31.7871],[129.7937,31.7425],[129.718,31.6571]],[[130.3811,32.4237],[130.2926,32.4193],[130.2561,32.431],[130.2417,32.4628],[130.3654,32.5272],[130.4614,32.5157],[130.4186,32.4577],[130.3811,32.4237]],[[130.0825,32.2297],[130.0035,32.194],[129.9934,32.2282],[129.9602,32.2438],[130.0173,32.2918],[130.0153,32.3137],[129.9793,32.3462],[130.0213,32.4688],[130.0098,32.5216],[130.1678,32.5412],[130.1967,32.4916],[130.1995,32.3406],[130.0825,32.2297]],[[128.6653,32.7839],[128.7041,32.7569],[128.761,32.7724],[128.8061,32.776],[128.8386,32.7629],[128.8794,32.6933],[128.8945,32.6521],[128.8213,32.6463],[128.7904,32.6367],[128.7505,32.5861],[128.693,32.6047],[128.6573,32.6284],[128.6491,32.662],[128.6653,32.7839]],[[139.8411,33.0561],[139.8238,33.0455],[139.7757,33.0782],[139.7689,33.1072],[139.7774,33.1251],[139.8089,33.1292],[139.8736,33.0935],[139.8411,33.0561]],[[129.077,32.8403],[129.052,32.8295],[129.0196,32.9196],[128.9973,32.9519],[129.035,32.9691],[129.1098,33.1326],[129.1236,33.0677],[129.1527,33.0033],[129.1819,32.9931],[129.1535,32.9462],[129.1116,32.9289],[129.077,32.8403]],[[129.4918,33.223],[129.4214,33.1758],[129.3704,33.176],[129.417,33.2311],[129.4231,33.2574],[129.4619,33.3313],[129.538,33.3578],[129.5699,33.361],[129.5081,33.2843],[129.4918,33.223]],[[129.7957,33.7488],[129.7266,33.7073],[129.6748,33.7397],[129.7,33.8289],[129.7173,33.8584],[129.7764,33.8292],[129.7957,33.7488]],[[131.1746,33.6026],[131.3092,33.5728],[131.366,33.5709],[131.4188,33.5844],[131.4988,33.6236],[131.583,33.6524],[131.6431,33.6378],[131.6963,33.6028],[131.7242,33.5538],[131.7106,33.5023],[131.6155,33.3918],[131.5374,33.2741],[131.7171,33.2521],[131.8966,33.2546],[131.8547,33.1816],[131.8479,33.1181],[131.9027,33.0878],[131.9493,33.0471],[131.9372,33.0102],[131.9104,32.9737],[132.0086,32.919],[132.0021,32.8824],[131.9767,32.8439],[131.7321,32.5928],[131.6604,32.4656],[131.6104,32.3255],[131.5646,32.223],[131.5312,32.1167],[131.5057,32.002],[131.4603,31.8835],[131.4753,31.7784],[131.46,31.6708],[131.3372,31.4047],[131.2497,31.4096],[131.1397,31.4418],[131.0708,31.4369],[131.0352,31.3777],[131.0984,31.2562],[130.9022,31.1121],[130.6857,31.0151],[130.6842,31.0593],[130.7045,31.0941],[130.7357,31.1221],[130.7584,31.1558],[130.7897,31.2691],[130.7742,31.3832],[130.709,31.5261],[130.7042,31.5774],[130.7494,31.5982],[130.7798,31.6041],[130.7963,31.6241],[130.7969,31.6713],[130.7763,31.7063],[130.7146,31.7177],[130.6551,31.7184],[130.6135,31.6654],[130.5561,31.5631],[130.5281,31.4597],[130.5404,31.4031],[130.5659,31.3524],[130.6445,31.2675],[130.6215,31.2175],[130.5888,31.1785],[130.3106,31.2669],[130.2506,31.2732],[130.2007,31.2919],[130.1473,31.4085],[130.2605,31.4366],[130.2941,31.4507],[130.3066,31.4878],[130.322,31.6015],[130.2689,31.6963],[130.2242,31.7301],[130.1879,31.7688],[130.2109,31.849],[130.1958,31.9499],[130.1944,32.0908],[130.2141,32.115],[130.3191,32.1435],[130.3949,32.219],[130.462,32.3049],[130.5604,32.4561],[130.6405,32.6192],[130.5633,32.6264],[130.4979,32.6569],[130.5694,32.7341],[130.5473,32.8316],[130.4404,32.9514],[130.3817,33.0926],[130.2873,33.1548],[130.2375,33.1776],[130.1769,33.1445],[130.1269,33.1048],[130.1731,33.013],[130.1678,32.9318],[130.175,32.8513],[130.2222,32.8468],[130.2801,32.8668],[130.3265,32.8526],[130.3535,32.8104],[130.3608,32.7559],[130.3404,32.7019],[130.2977,32.675],[130.2455,32.6771],[130.193,32.7063],[130.1521,32.7479],[130.0541,32.7708],[129.9508,32.7217],[129.8525,32.6217],[129.7686,32.571],[129.8081,32.6453],[129.8268,32.7253],[129.7859,32.7816],[129.69,32.8752],[129.6678,32.9294],[129.6623,32.9949],[129.6791,33.06],[129.7777,32.9855],[129.8283,32.8927],[129.9008,32.8519],[129.9917,32.8516],[129.9219,32.988],[129.8968,33.0224],[129.7987,33.0836],[129.665,33.1866],[129.5801,33.2363],[129.6102,33.3437],[129.66,33.365],[129.7021,33.3598],[129.8441,33.3218],[129.8575,33.3752],[129.8366,33.4038],[129.8257,33.437],[129.9191,33.4835],[130.0721,33.5218],[130.1034,33.5397],[130.1306,33.5782],[130.168,33.5983],[130.2751,33.5977],[130.365,33.6345],[130.4395,33.7342],[130.4572,33.789],[130.4838,33.8346],[130.6695,33.9155],[130.7156,33.9278],[130.8396,33.9178],[130.9531,33.872],[131.0091,33.7758],[131.0581,33.6729],[131.1746,33.6026]],[[132.266,33.9452],[132.3146,33.9086],[132.4305,33.9235],[132.4449,33.9132],[132.411,33.8799],[132.36,33.847],[132.2673,33.8715],[132.2088,33.8729],[132.2006,33.9278],[132.208,33.9478],[132.266,33.9452]],[[132.5784,34.1152],[132.5494,34.0751],[132.4609,34.0873],[132.4963,34.122],[132.5235,34.1641],[132.5435,34.1727],[132.5602,34.1269],[132.5784,34.1152]],[[129.2795,34.1234],[129.2145,34.0828],[129.1864,34.145],[129.2148,34.3207],[129.3371,34.2848],[129.3351,34.2308],[129.2795,34.1234]],[[134.3574,34.2563],[134.4957,34.2147],[134.6375,34.2266],[134.6353,34.0439],[134.6554,33.9826],[134.6953,33.9277],[134.6748,33.8478],[134.7389,33.8205],[134.5487,33.7293],[134.3771,33.6084],[134.3065,33.5268],[134.2427,33.4395],[134.2057,33.347],[134.1816,33.2472],[134.1241,33.2868],[133.9587,33.4483],[133.854,33.4927],[133.6856,33.5163],[133.632,33.511],[133.2859,33.36],[133.2399,33.2496],[133.1456,33.0832],[133.1009,33.0282],[133.0512,33.0125],[133.016,32.9839],[132.9772,32.842],[132.8699,32.7546],[132.8043,32.752],[132.6922,32.7759],[132.6418,32.7625],[132.709,32.9025],[132.602,32.9195],[132.4951,32.9166],[132.4926,33.0077],[132.4278,33.0594],[132.4758,33.1265],[132.4771,33.1812],[132.5053,33.2113],[132.515,33.2554],[132.5114,33.2931],[132.4454,33.3046],[132.4052,33.3313],[132.4128,33.4305],[132.3749,33.4341],[132.2811,33.4168],[132.0858,33.3401],[132.0326,33.34],[132.1145,33.3946],[132.2879,33.4695],[132.3659,33.5125],[132.536,33.6329],[132.6431,33.6899],[132.6989,33.7909],[132.7162,33.8522],[132.7523,33.9062],[132.7843,33.9924],[132.8395,34.0212],[132.9352,34.0953],[132.9901,34.0881],[133.0513,33.9971],[133.1337,33.9273],[133.1931,33.9332],[133.2988,33.969],[133.3498,33.9771],[133.4721,33.9728],[133.582,34.0171],[133.6268,34.0694],[133.6435,34.1347],[133.6026,34.2438],[133.6556,34.2329],[133.7063,34.2374],[133.8256,34.3068],[133.9483,34.348],[134.0759,34.3584],[134.2192,34.319],[134.3574,34.2563]],[[134.3519,34.4836],[134.3332,34.4638],[134.3153,34.4689],[134.2519,34.423],[134.2381,34.467],[134.1883,34.4963],[134.1821,34.5192],[134.326,34.5344],[134.3723,34.5224],[134.3519,34.4836]],[[134.9328,34.2881],[134.8244,34.2029],[134.7307,34.2089],[134.6835,34.247],[134.6679,34.2941],[134.7572,34.3682],[134.8343,34.4727],[134.9041,34.5191],[134.9607,34.5449],[135.0047,34.544],[134.9055,34.3983],[134.9328,34.2881]],[[129.3856,34.3537],[129.3653,34.3055],[129.2975,34.3396],[129.2667,34.3705],[129.3294,34.5219],[129.3221,34.5793],[129.3259,34.6073],[129.4511,34.6866],[129.4725,34.6713],[129.4802,34.6495],[129.4691,34.6155],[129.4754,34.5404],[129.3814,34.4165],[129.3856,34.3537]],[[139.4564,34.7265],[139.4457,34.6795],[139.3924,34.6899],[139.3669,34.7205],[139.37,34.7754],[139.4262,34.7759],[139.4564,34.7265]],[[133.3705,36.2039],[133.3247,36.1665],[133.2393,36.1788],[133.1899,36.2326],[133.2062,36.2934],[133.2957,36.3401],[133.3813,36.2464],[133.3705,36.2039]],[[138.344,37.8221],[138.249,37.8196],[138.2252,37.8294],[138.2828,37.8542],[138.2879,37.8958],[138.3223,37.9695],[138.3217,37.9908],[138.2462,37.9946],[138.25,38.0785],[138.3063,38.1611],[138.4613,38.2915],[138.5036,38.3159],[138.5101,38.259],[138.4628,38.1243],[138.4536,38.0757],[138.5752,38.0655],[138.497,37.9039],[138.344,37.8221]],[[141.2293,41.3727],[141.2688,41.3538],[141.4555,41.4047],[141.4199,41.2512],[141.4,41.0963],[141.4137,40.8394],[141.4305,40.7233],[141.4628,40.6111],[141.5423,40.5307],[141.6463,40.4736],[141.7971,40.2912],[141.8779,40.0672],[141.9351,39.9585],[141.9778,39.8444],[141.9908,39.7922],[141.9919,39.7399],[141.9791,39.6684],[141.9932,39.6105],[141.977,39.4288],[141.9095,39.2187],[141.9008,39.1113],[141.8421,39.09],[141.8065,39.0404],[141.7762,39.0174],[141.7425,38.9996],[141.6936,38.9952],[141.6586,38.9749],[141.6447,38.9179],[141.6223,38.8651],[141.5797,38.8165],[141.5463,38.7628],[141.5188,38.632],[141.5088,38.4979],[141.4675,38.4042],[141.3682,38.3797],[141.2543,38.3814],[141.1084,38.3379],[141.0773,38.3125],[140.9621,38.1489],[140.929,38.0529],[140.9279,37.9496],[140.96,37.8226],[141.0034,37.6984],[141.0363,37.4672],[141.0017,37.1146],[140.9684,37.0021],[140.8951,36.9257],[140.8396,36.8903],[140.7918,36.8469],[140.7299,36.7319],[140.6273,36.5028],[140.6188,36.4453],[140.6192,36.3856],[140.5916,36.3078],[140.5735,36.2313],[140.5904,36.1424],[140.622,36.0592],[140.7596,35.8457],[140.8135,35.7825],[140.874,35.725],[140.6393,35.6613],[140.5969,35.632],[140.4574,35.5103],[140.4129,35.3948],[140.4165,35.267],[140.393,35.2211],[140.3547,35.1814],[140.3147,35.155],[140.1589,35.0965],[140.0592,35.0383],[139.9598,34.9473],[139.9204,34.8996],[139.8439,34.9149],[139.7992,34.9569],[139.8433,35.0099],[139.8297,35.0722],[139.8515,35.2323],[139.8265,35.2967],[139.9062,35.3453],[139.9441,35.423],[140.0271,35.4852],[140.0863,35.5404],[140.0969,35.5852],[140.0437,35.6333],[139.9875,35.6682],[139.9098,35.6684],[139.8348,35.6581],[139.7863,35.6121],[139.7701,35.5496],[139.7739,35.5204],[139.7678,35.4948],[139.65,35.4091],[139.6655,35.3195],[139.7,35.274],[139.744,35.2524],[139.7309,35.2215],[139.675,35.1493],[139.6359,35.1421],[139.5641,35.2433],[139.4744,35.2985],[139.3635,35.2981],[139.2494,35.278],[139.1627,35.2107],[139.1341,35.1549],[139.1158,35.0971],[139.122,34.9565],[139.086,34.8392],[139.0156,34.736],[138.9826,34.6984],[138.8967,34.6284],[138.8375,34.6192],[138.7951,34.651],[138.761,34.6992],[138.8045,34.8757],[138.8027,34.9748],[138.9036,35.0252],[138.8209,35.0957],[138.7196,35.1241],[138.5771,35.0865],[138.537,35.0441],[138.5096,34.9872],[138.4331,34.9152],[138.3486,34.8477],[138.2532,34.7327],[138.1891,34.5963],[137.979,34.6409],[137.8643,34.6509],[137.7485,34.6474],[137.5434,34.6642],[137.3181,34.6364],[137.0617,34.5828],[137.0771,34.6214],[137.2878,34.7035],[137.2954,34.7276],[137.2752,34.7725],[137.2227,34.7747],[137.0966,34.759],[137.0322,34.7659],[137.006,34.8141],[136.9633,34.8349],[136.9348,34.8152],[136.9441,34.7215],[136.9129,34.709],[136.8713,34.7331],[136.8846,34.8059],[136.8562,34.9125],[136.8529,34.9787],[136.8971,35.0355],[136.8519,35.0595],[136.8042,35.0503],[136.7436,35.023],[136.69,34.9841],[136.577,34.7896],[136.533,34.6784],[136.6158,34.5891],[136.8416,34.4642],[136.8803,34.4336],[136.8812,34.3805],[136.8537,34.3241],[136.7922,34.2993],[136.5444,34.2577],[136.3299,34.1769],[136.2679,34.0949],[136.0726,33.7782],[135.9162,33.5617],[135.6953,33.487],[135.4528,33.5534],[135.3942,33.6288],[135.3468,33.722],[135.2566,33.8063],[135.1754,33.898],[135.1279,34.007],[135.1354,34.1826],[135.1001,34.2884],[135.1319,34.3166],[135.2656,34.3808],[135.3093,34.4168],[135.3848,34.5004],[135.4118,34.547],[135.4159,34.6175],[135.3552,34.6543],[135.1982,34.6529],[135.0417,34.631],[134.9299,34.6618],[134.785,34.7471],[134.74,34.7652],[134.5838,34.7706],[134.4723,34.7548],[134.3627,34.7237],[134.2469,34.7139],[134.2083,34.6977],[134.0745,34.5931],[133.9683,34.5273],[133.8764,34.4946],[133.6779,34.4859],[133.5786,34.4647],[133.4744,34.4301],[133.4453,34.4332],[133.3356,34.3854],[133.2098,34.344],[133.1424,34.3024],[133.0189,34.3296],[132.7746,34.2552],[132.6565,34.2461],[132.5345,34.2871],[132.4213,34.3534],[132.3126,34.325],[132.2381,34.227],[132.202,34.032],[132.1594,33.9442],[132.1465,33.8388],[132.0902,33.8555],[131.7632,34.0453],[131.7405,34.0521],[131.4762,34.0194],[131.4079,34.0036],[131.3228,33.9652],[131.2326,33.948],[131.1504,33.9756],[131.0719,34.0207],[130.9964,34.0073],[130.9188,33.9757],[130.8893,34.2618],[130.9043,34.2996],[130.9519,34.3497],[131.0042,34.3926],[131.1322,34.4074],[131.2618,34.3935],[131.3544,34.4132],[131.4325,34.4698],[131.515,34.5501],[131.608,34.6155],[131.7341,34.6671],[131.8561,34.7263],[131.9631,34.8094],[132.0647,34.9],[132.1582,34.9665],[132.2596,35.0223],[132.4141,35.1563],[132.619,35.3068],[132.6977,35.4183],[132.7466,35.449],[132.9229,35.5113],[133.1569,35.5588],[133.2672,35.5565],[133.3765,35.4588],[133.4354,35.4722],[133.4949,35.4975],[133.6154,35.5114],[133.7394,35.4953],[133.8603,35.4949],[133.9813,35.5072],[134.2141,35.5393],[134.3365,35.5779],[134.4561,35.6279],[134.8822,35.6632],[135.1743,35.7471],[135.2205,35.7411],[135.2654,35.7218],[135.2688,35.6597],[135.232,35.5919],[135.2678,35.5509],[135.327,35.5255],[135.6019,35.5177],[135.6803,35.5031],[135.795,35.5495],[135.9031,35.6069],[136.0162,35.6825],[136.0953,35.7676],[136.0223,35.8741],[136.0063,35.9906],[136.0675,36.1168],[136.1563,36.2233],[136.2618,36.2877],[136.359,36.3618],[136.5559,36.572],[136.6981,36.742],[136.7493,36.951],[136.7192,37.1984],[136.8435,37.3821],[136.9623,37.4137],[137.1986,37.4975],[137.3227,37.5221],[137.3412,37.4854],[137.3375,37.4375],[137.1521,37.2832],[137.0458,37.2197],[136.9822,37.2],[136.924,37.172],[136.8999,37.1177],[136.9944,37.0268],[137.0186,36.9596],[137.0127,36.8951],[137.0167,36.8372],[137.1237,36.7741],[137.2463,36.7532],[137.2977,36.7538],[137.3426,36.7704],[137.4826,36.9248],[137.5141,36.9516],[137.9132,37.0646],[138.1096,37.1511],[138.2181,37.1734],[138.3199,37.2184],[138.5483,37.3921],[138.6328,37.4722],[138.7094,37.5606],[138.7706,37.6634],[138.8188,37.7747],[138.8851,37.8439],[139.2472,38.0091],[139.3639,38.099],[139.401,38.1426],[139.4458,38.2688],[139.4768,38.3998],[139.5208,38.5025],[139.5802,38.5989],[139.6598,38.697],[139.7491,38.7881],[139.802,38.8816],[139.8786,39.1049],[139.9123,39.2286],[139.9386,39.2731],[139.9771,39.3106],[140.0108,39.3581],[140.0365,39.4111],[140.0481,39.4637],[140.0647,39.6244],[140.0547,39.7493],[139.9947,39.8551],[139.9452,39.8851],[139.8912,39.8869],[139.8104,39.8777],[139.7415,39.9208],[139.7555,39.9589],[139.8257,39.966],[139.8736,39.9857],[139.908,40.0217],[139.9725,40.137],[140.0111,40.2604],[140.0145,40.3149],[139.9641,40.4143],[139.9239,40.5339],[139.9229,40.5984],[139.9667,40.6728],[140.0293,40.7332],[140.0854,40.7474],[140.1461,40.7516],[140.2013,40.7749],[140.2523,40.8088],[140.2813,40.8461],[140.3263,40.9477],[140.3436,41.0057],[140.3152,41.1609],[140.3444,41.2033],[140.3859,41.2298],[140.4413,41.2097],[140.498,41.2057],[140.5642,41.2118],[140.6276,41.1954],[140.6396,41.1556],[140.6794,40.8933],[140.7024,40.8578],[140.7486,40.8303],[140.8008,40.8343],[140.8458,40.8751],[140.8762,40.9295],[140.936,40.9408],[141.1186,40.8823],[141.1832,40.924],[141.2254,40.9885],[141.2621,41.1027],[141.2442,41.2056],[141.2004,41.2436],[141.1551,41.2367],[141.115,41.2085],[141.0704,41.1931],[140.8006,41.1388],[140.8019,41.2537],[140.8596,41.4254],[140.8915,41.4798],[140.9369,41.5056],[141.0502,41.4757],[141.1059,41.4559],[141.2293,41.3727]],[[139.4813,42.081],[139.4584,42.0756],[139.4346,42.0841],[139.4115,42.1597],[139.4313,42.1996],[139.4958,42.2274],[139.5584,42.2352],[139.5051,42.0964],[139.4813,42.081]],[[141.2954,45.1193],[141.226,45.1122],[141.1453,45.1539],[141.1354,45.2062],[141.1938,45.2479],[141.2519,45.2325],[141.3101,45.1786],[141.3292,45.1505],[141.2954,45.1193]],[[141.0728,45.3329],[141.034,45.2693],[140.9821,45.3638],[140.9717,45.4655],[141.0017,45.4648],[141.0567,45.4496],[141.0699,45.4],[141.0728,45.3329]],[[143.8243,44.117],[143.9495,44.1119],[144.0055,44.1167],[144.1014,44.1016],[144.4818,43.9496],[144.5967,43.9302],[144.7152,43.928],[144.7985,43.9402],[144.8719,43.9819],[145.1016,44.1662],[145.3428,44.3339],[145.3695,44.3274],[145.3696,44.2813],[145.352,44.2298],[145.2452,44.0762],[145.1264,43.8694],[145.1011,43.7646],[145.1396,43.6625],[145.2141,43.5782],[145.2729,43.4629],[145.3408,43.3025],[145.4361,43.2822],[145.4879,43.2797],[145.5833,43.3278],[145.6736,43.3889],[145.7513,43.3963],[145.833,43.3859],[145.7256,43.3435],[145.6242,43.2913],[145.5374,43.1927],[145.5051,43.1742],[145.4048,43.1803],[145.3475,43.1767],[145.2301,43.1355],[145.1271,43.0889],[145.0288,43.0316],[144.9214,43.0009],[144.8071,42.9937],[144.6308,42.9469],[144.5162,42.9436],[144.3016,42.9844],[144.1973,42.9736],[143.9693,42.8814],[143.7621,42.7481],[143.581,42.5987],[143.4295,42.4189],[143.3687,42.3251],[143.3321,42.2204],[143.3271,42.151],[143.3137,42.0843],[143.2787,42.0378],[143.2365,42.0002],[143.1117,42.0222],[142.9063,42.1184],[142.5082,42.258],[142.0879,42.4717],[141.8514,42.5791],[141.4066,42.5469],[140.9861,42.3421],[140.9484,42.3596],[140.7876,42.5],[140.7098,42.5556],[140.6168,42.5713],[140.5477,42.5695],[140.4805,42.5594],[140.3854,42.4872],[140.3506,42.4351],[140.3235,42.3761],[140.3152,42.3343],[140.3267,42.2934],[140.4166,42.2007],[140.5275,42.1318],[140.5777,42.1187],[140.6843,42.1235],[140.7338,42.1164],[140.9123,41.9778],[141.1077,41.848],[141.151,41.8051],[141.0787,41.7598],[140.9995,41.7374],[140.9075,41.7433],[140.8164,41.7604],[140.6599,41.8156],[140.593,41.7686],[140.4892,41.6722],[140.4316,41.5674],[140.385,41.5193],[140.2701,41.456],[140.1486,41.4232],[140.0852,41.4341],[140.0366,41.4738],[140.0092,41.5213],[139.9953,41.5764],[140.0213,41.6958],[140.0842,41.8032],[140.1084,41.9129],[140.0568,42.0673],[140.0241,42.0996],[139.8951,42.19],[139.8354,42.2781],[139.8209,42.3876],[139.8285,42.4481],[139.8602,42.5817],[139.8911,42.6492],[139.9506,42.6714],[140.015,42.6848],[140.1146,42.733],[140.2241,42.7955],[140.3286,42.8668],[140.4322,42.9541],[140.4864,43.0499],[140.3975,43.1673],[140.3793,43.2371],[140.3924,43.3031],[140.4869,43.3382],[140.5846,43.3117],[140.7807,43.215],[140.8191,43.2055],[140.9538,43.201],[141.1382,43.1799],[141.245,43.1851],[141.2963,43.1997],[141.3741,43.2796],[141.4123,43.3815],[141.3983,43.5125],[141.3977,43.6426],[141.4468,43.7486],[141.6007,43.919],[141.6447,44.0194],[141.6608,44.2636],[141.7163,44.3712],[141.7609,44.4825],[141.7822,44.7164],[141.719,44.9411],[141.6558,45.0512],[141.583,45.156],[141.5937,45.256],[141.6525,45.3486],[141.654,45.3766],[141.668,45.4013],[141.7781,45.4189],[141.8295,45.4388],[141.8787,45.4833],[141.9377,45.5095],[141.9809,45.4835],[142.0164,45.4379],[142.1716,45.3256],[142.416,45.125],[142.7041,44.8192],[142.8848,44.6701],[143.0751,44.5349],[143.2886,44.3966],[143.5119,44.2775],[143.6546,44.2213],[143.7591,44.1316],[143.8243,44.117]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Japan","sov_a3":"JPN","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Japan","adm0_a3":"JPN","geou_dif":0,"geounit":"Japan","gu_a3":"JPN","su_dif":0,"subunit":"Japan","su_a3":"JPN","brk_diff":0,"name":"Japan","name_long":"Japan","brk_a3":"JPN","brk_name":"Japan","brk_group":"","abbrev":"Japan","postal":"J","formal_en":"Japan","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Japan","name_alt":"","mapcolor7":5,"mapcolor8":3,"mapcolor9":5,"mapcolor13":4,"pop_est":127078679,"gdp_md_est":4329000,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"1. Developed region: G7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"JP","iso_a3":"JPN","iso_n3":"392","un_a3":"392","wb_a2":"JP","wb_a3":"JPN","woe_id":-99,"adm0_a3_is":"JPN","adm0_a3_us":"JPN","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Eastern Asia","region_wb":"East Asia & Pacific","name_len":5,"long_len":5,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[-15.5431,66.2285],[-15.4285,66.2248],[-15.2409,66.2591],[-15.1624,66.2817],[-14.97,66.3597],[-14.8561,66.3814],[-14.6807,66.3761],[-14.5958,66.3815],[-14.5939,66.374],[-14.7017,66.3423],[-14.7882,66.3314],[-14.9122,66.2843],[-15.03,66.1779],[-15.1174,66.1256],[-15.1164,66.1024],[-15.0103,66.0613],[-14.894,66.0379],[-14.7872,66.0591],[-14.7404,66.0508],[-14.6982,66.0202],[-14.6744,65.9899],[-14.669,65.9599],[-14.6882,65.897],[-14.7525,65.8338],[-14.8393,65.7809],[-14.8271,65.7643],[-14.7575,65.7557],[-14.4262,65.7899],[-14.3918,65.7874],[-14.3728,65.7704],[-14.3691,65.7387],[-14.3509,65.7101],[-14.3182,65.6845],[-14.3284,65.6583],[-14.4734,65.5753],[-14.3023,65.6275],[-14.1669,65.6423],[-13.9354,65.6161],[-13.8407,65.5859],[-13.7853,65.533],[-13.7051,65.5505],[-13.6703,65.5495],[-13.6179,65.5193],[-13.616,65.4872],[-13.6544,65.4413],[-13.6678,65.399],[-13.708,65.3816],[-13.7833,65.369],[-13.8048,65.3548],[-13.7716,65.3225],[-13.7229,65.291],[-13.6535,65.2895],[-13.6411,65.275],[-13.6396,65.2575],[-13.6489,65.237],[-13.6716,65.2229],[-13.7074,65.2151],[-13.7549,65.1925],[-13.5808,65.143],[-13.5586,65.1247],[-13.5561,65.0977],[-13.5697,65.0681],[-13.5993,65.0359],[-13.6519,65.0168],[-13.7772,65.0137],[-13.854,64.9929],[-13.8278,64.958],[-13.8298,64.914],[-13.8529,64.8622],[-13.9517,64.7836],[-14.0444,64.7419],[-14.1352,64.7148],[-14.297,64.7244],[-14.3851,64.7452],[-14.3753,64.6774],[-14.4654,64.6357],[-14.4483,64.6008],[-14.417,64.5831],[-14.4326,64.5383],[-14.4754,64.494],[-14.5471,64.4459],[-14.6282,64.416],[-14.7896,64.3798],[-14.9274,64.3197],[-15.0216,64.2959],[-15.2559,64.2969],[-15.495,64.2582],[-15.8329,64.1767],[-16.0604,64.1112],[-16.236,64.0372],[-16.4681,63.9164],[-16.6403,63.8655],[-16.7397,63.8518],[-16.9331,63.8409],[-17.0951,63.8081],[-17.6334,63.7466],[-17.8157,63.713],[-17.8393,63.6824],[-17.9148,63.6364],[-17.9196,63.6197],[-17.8864,63.6069],[-17.8803,63.5902],[-17.9469,63.5357],[-18.08,63.4963],[-18.1429,63.497],[-18.219,63.5309],[-18.2522,63.5297],[-18.2652,63.5245],[-18.266,63.5139],[-18.2223,63.4732],[-18.3028,63.4542],[-18.6536,63.4067],[-19.2502,63.442],[-19.4866,63.4785],[-19.7783,63.5366],[-19.952,63.5521],[-20.1981,63.5558],[-20.4004,63.6371],[-20.494,63.6874],[-20.5016,63.7082],[-20.491,63.732],[-20.47,63.7482],[-20.4385,63.757],[-20.3717,63.7579],[-20.363,63.7649],[-20.414,63.8052],[-20.4627,63.7921],[-20.593,63.7354],[-20.6509,63.7374],[-20.7271,63.7658],[-20.7299,63.7934],[-20.8788,63.8039],[-21.0081,63.8384],[-21.1366,63.8879],[-21.1558,63.9068],[-21.094,63.9344],[-21.106,63.9398],[-21.1524,63.9445],[-21.2462,63.9354],[-21.3876,63.8728],[-21.4486,63.8584],[-22.3726,63.8438],[-22.6069,63.8373],[-22.6522,63.8277],[-22.693,63.8685],[-22.7294,63.9595],[-22.743,64.0194],[-22.7336,64.0484],[-22.7012,64.0832],[-22.6509,64.0773],[-22.6031,64.0496],[-22.5598,64.0104],[-22.5101,63.9915],[-22.1876,64.0392],[-22.0566,64.0713],[-22.001,64.1019],[-21.9354,64.1538],[-21.8659,64.1803],[-21.8328,64.2054],[-21.7676,64.2849],[-21.7226,64.3218],[-21.6687,64.349],[-21.606,64.3666],[-21.4633,64.3792],[-21.5572,64.3979],[-21.6467,64.3979],[-21.9512,64.3139],[-22.0534,64.3139],[-22.0491,64.327],[-22.006,64.3507],[-21.9013,64.3916],[-21.9732,64.3947],[-22.0007,64.4132],[-22.0038,64.4522],[-21.9503,64.515],[-21.7024,64.5978],[-21.6167,64.61],[-21.5906,64.6264],[-21.6231,64.6397],[-21.675,64.6477],[-21.9244,64.5625],[-22.106,64.5331],[-22.16,64.5388],[-22.2539,64.5719],[-22.2842,64.5866],[-22.3247,64.6244],[-22.3201,64.6472],[-22.2336,64.714],[-22.2476,64.7269],[-22.307,64.7335],[-22.467,64.795],[-22.7203,64.7888],[-23.347,64.8244],[-23.4765,64.8093],[-23.6899,64.7565],[-23.819,64.7392],[-23.8786,64.7506],[-23.9328,64.7785],[-23.982,64.8161],[-24.0262,64.8634],[-24.007,64.8964],[-23.9244,64.9152],[-23.8638,64.9242],[-23.6932,64.9127],[-23.4853,64.9458],[-23.3527,64.9528],[-23.3146,64.958],[-23.2365,64.9933],[-23.198,65.0021],[-23.1379,64.9898],[-23.1088,64.9659],[-22.8995,65.003],[-22.8277,65.0217],[-22.8196,65.0331],[-22.7881,65.0465],[-22.684,65.0264],[-22.5997,65.0257],[-22.4945,65.0396],[-22.3084,65.0457],[-21.8921,65.0488],[-21.8298,65.0791],[-21.8004,65.1059],[-21.7637,65.1737],[-21.78,65.1877],[-22.04,65.1252],[-22.0993,65.1262],[-22.4003,65.1593],[-22.5091,65.1968],[-22.4734,65.2269],[-22.314,65.2916],[-22.1493,65.3436],[-21.907,65.3997],[-21.8502,65.4215],[-21.8444,65.4474],[-22.0058,65.4935],[-22.3115,65.4807],[-22.3897,65.5354],[-22.6436,65.5678],[-22.8126,65.5474],[-22.9025,65.5805],[-23.1221,65.5348],[-23.6045,65.4686],[-23.7965,65.4228],[-23.8999,65.4076],[-24.019,65.445],[-24.224,65.4872],[-24.4548,65.5003],[-24.4757,65.5252],[-24.3411,65.6012],[-24.2489,65.615],[-24.1561,65.608],[-23.979,65.555],[-23.8567,65.5384],[-24.01,65.6162],[-24.006,65.6461],[-24.0176,65.6909],[-24.065,65.7102],[-24.1119,65.7597],[-24.0926,65.7765],[-24.0324,65.7823],[-23.9091,65.7656],[-23.6159,65.6796],[-23.472,65.6948],[-23.393,65.7265],[-23.2854,65.75],[-23.3159,65.7623],[-23.5693,65.7637],[-23.7047,65.7812],[-23.7732,65.8063],[-23.8326,65.8492],[-23.8117,65.8689],[-23.7413,65.8846],[-23.525,65.88],[-23.6675,65.9543],[-23.7666,65.997],[-23.7773,66.0176],[-23.7706,66.0435],[-23.7571,66.0608],[-23.7372,66.0694],[-23.4889,66.0261],[-23.4345,66.0242],[-23.4847,66.0522],[-23.5936,66.0934],[-23.5985,66.1088],[-23.5526,66.1216],[-23.53,66.145],[-23.5279,66.1644],[-23.4525,66.181],[-23.3766,66.1817],[-23.3,66.1666],[-23.0625,66.0862],[-23.0285,66.0637],[-23.0173,66.0339],[-23.0289,65.9971],[-23.019,65.9821],[-22.9262,65.9948],[-22.8522,65.9793],[-22.8153,65.9835],[-22.7233,66.039],[-22.6599,66.0259],[-22.6216,66],[-22.6097,65.9765],[-22.6041,65.9442],[-22.6202,65.877],[-22.616,65.8675],[-22.5516,65.9054],[-22.4417,65.9083],[-22.4275,65.9274],[-22.4242,65.9981],[-22.4332,66.0577],[-22.4453,66.07],[-22.8064,66.1526],[-22.8692,66.1721],[-22.9479,66.2127],[-22.932,66.2332],[-22.8616,66.2515],[-22.7555,66.2587],[-22.5094,66.2578],[-22.4844,66.2663],[-22.5321,66.2877],[-22.6461,66.3016],[-22.6728,66.3139],[-22.6862,66.3377],[-22.8213,66.3247],[-22.972,66.3242],[-23.1169,66.3387],[-23.1199,66.3572],[-23.0627,66.3844],[-22.9443,66.4294],[-22.8892,66.4406],[-22.7237,66.4328],[-22.5593,66.4454],[-22.4261,66.4301],[-22.3205,66.3855],[-22.1702,66.3071],[-21.967,66.257],[-21.9484,66.2413],[-21.8402,66.2002],[-21.6253,66.0897],[-21.4069,66.0256],[-21.3968,66.0093],[-21.4327,65.9901],[-21.5167,65.9676],[-21.4975,65.9551],[-21.3878,65.9388],[-21.3088,65.8953],[-21.3035,65.8765],[-21.3749,65.7419],[-21.4128,65.7133],[-21.4566,65.6982],[-21.6584,65.7236],[-21.6104,65.6808],[-21.4663,65.6352],[-21.4336,65.6097],[-21.4551,65.5847],[-21.4394,65.5789],[-21.3866,65.5924],[-21.3647,65.5782],[-21.3739,65.5364],[-21.3963,65.5017],[-21.4322,65.4741],[-21.4219,65.4622],[-21.3655,65.4658],[-21.3125,65.4587],[-21.23,65.4206],[-21.163,65.3042],[-21.1297,65.2666],[-21.1057,65.3],[-21.0756,65.385],[-21.0473,65.4284],[-21.0208,65.4303],[-20.998,65.4445],[-20.9789,65.4712],[-20.9397,65.5652],[-20.8043,65.6364],[-20.7397,65.6583],[-20.679,65.6631],[-20.6494,65.6542],[-20.5481,65.5795],[-20.4865,65.5669],[-20.4548,65.571],[-20.4115,65.6217],[-20.3566,65.719],[-20.3441,65.8277],[-20.3739,65.9477],[-20.3566,66.0333],[-20.2921,66.0844],[-20.2075,66.1001],[-20.1027,66.0805],[-20.0261,66.0493],[-19.8748,65.9301],[-19.7526,65.8678],[-19.6479,65.8008],[-19.5936,65.7791],[-19.4897,65.7681],[-19.4618,65.7724],[-19.4433,65.7878],[-19.4339,65.8145],[-19.4562,65.9849],[-19.4271,66.038],[-19.383,66.0757],[-19.1953,66.0979],[-19.0932,66.1215],[-18.9937,66.1604],[-18.9113,66.1812],[-18.8459,66.1839],[-18.7775,66.1688],[-18.7062,66.1357],[-18.5949,66.0713],[-18.4549,65.9646],[-18.277,65.8847],[-18.1836,65.758],[-18.1637,65.7366],[-18.1419,65.7341],[-18.1184,65.7505],[-18.1033,65.7739],[-18.099,65.8303],[-18.1489,65.905],[-18.3153,66.0932],[-18.3182,66.1288],[-18.2972,66.1574],[-18.1799,66.1605],[-17.907,66.1433],[-17.8198,66.1141],[-17.6343,65.9992],[-17.5822,65.9714],[-17.5504,65.9644],[-17.539,65.9783],[-17.467,65.9997],[-17.4172,66.0255],[-17.3343,66.0889],[-17.153,66.2028],[-17.1154,66.2062],[-17.0625,66.1972],[-16.9695,66.1674],[-16.9254,66.1435],[-16.838,66.1252],[-16.7484,66.1316],[-16.6248,66.1716],[-16.485,66.1959],[-16.4371,66.2525],[-16.4281,66.2784],[-16.5407,66.4467],[-16.4934,66.4812],[-16.2493,66.5229],[-16.0359,66.5261],[-15.9854,66.5146],[-15.8509,66.4329],[-15.7598,66.3917],[-15.7138,66.3586],[-15.7028,66.2857],[-15.6474,66.2588],[-15.5431,66.2285]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Iceland","sov_a3":"ISL","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Iceland","adm0_a3":"ISL","geou_dif":0,"geounit":"Iceland","gu_a3":"ISL","su_dif":0,"subunit":"Iceland","su_a3":"ISL","brk_diff":0,"name":"Iceland","name_long":"Iceland","brk_a3":"ISL","brk_name":"Iceland","brk_group":"","abbrev":"Iceland","postal":"IS","formal_en":"Republic of Iceland","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Iceland","name_alt":"","mapcolor7":1,"mapcolor8":4,"mapcolor9":4,"mapcolor13":9,"pop_est":306694,"gdp_md_est":12710,"pop_year":-99,"lastcensus":-99,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"IS","iso_a3":"ISL","iso_n3":"352","un_a3":"352","wb_a2":"IS","wb_a3":"ISL","woe_id":-99,"adm0_a3_is":"ISL","adm0_a3_us":"ISL","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Northern Europe","region_wb":"Europe & Central Asia","name_len":7,"long_len":7,"abbrev_len":7,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[-1.1783,45.9041],[-1.2136,45.8166],[-1.2803,45.8971],[-1.3687,45.9677],[-1.3889,46.033],[-1.3887,46.0504],[-1.2851,46.0027],[-1.1783,45.9041]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"France","sov_a3":"FR1","adm0_dif":1,"level":2,"type":"Country","admin":"France","adm0_a3":"FRA","geou_dif":0,"geounit":"France","gu_a3":"FRA","su_dif":0,"subunit":"France","su_a3":"FRA","brk_diff":0,"name":"France","name_long":"France","brk_a3":"FRA","brk_name":"France","brk_group":"","abbrev":"Fr.","postal":"F","formal_en":"French Republic","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"France","name_alt":"","mapcolor7":7,"mapcolor8":5,"mapcolor9":9,"mapcolor13":11,"pop_est":64057792,"gdp_md_est":2128000,"pop_year":-99,"lastcensus":-99,"gdp_year":-99,"economy":"1. Developed region: G7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"FR","iso_a3":"FRA","iso_n3":"250","un_a3":"250","wb_a2":"FR","wb_a3":"FRA","woe_id":-99,"adm0_a3_is":"FRA","adm0_a3_us":"FRA","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Western Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":6,"abbrev_len":3,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[35.7873,32.7349],[35.7345,32.7289],[35.6112,32.6821],[35.5945,32.668],[35.5729,32.6409],[35.569,32.6199],[35.5515,32.3955],[35.4844,32.4017],[35.4026,32.4506],[35.3867,32.493],[35.3621,32.5075],[35.3038,32.5129],[35.1933,32.5344],[35.065,32.4604],[35.0105,32.3382],[34.9995,32.2811],[34.956,32.1609],[34.9714,32.0871],[34.9788,31.9916],[34.9897,31.9133],[34.9783,31.8664],[34.9538,31.8413],[34.9611,31.8233],[34.983,31.8168],[35.0532,31.8379],[35.1271,31.8167],[35.198,31.7763],[35.2037,31.75],[35.1534,31.7345],[35.0347,31.6732],[34.951,31.6023],[34.9292,31.5366],[34.8728,31.3969],[34.8805,31.3682],[34.9078,31.3513],[35.1012,31.3662],[35.2767,31.4228],[35.4087,31.4829],[35.4506,31.4793],[35.4229,31.3254],[35.4235,31.3249],[35.4007,31.2305],[35.4097,31.2145],[35.4393,31.1324],[35.383,30.9823],[35.3201,30.8602],[35.2979,30.8022],[35.2366,30.6735],[35.174,30.5239],[35.1406,30.4209],[35.1481,30.3843],[35.1326,30.1953],[35.1416,30.1417],[35.0682,29.9779],[35.0534,29.8969],[35.0239,29.7871],[34.9734,29.555],[34.9043,29.4773],[34.8698,29.5639],[34.7911,29.8121],[34.7351,29.982],[34.6586,30.1915],[34.5297,30.446],[34.5178,30.5074],[34.4899,30.5963],[34.401,30.8278],[34.3285,30.995],[34.2453,31.2083],[34.3483,31.2929],[34.3502,31.3627],[34.5256,31.5256],[34.5241,31.5417],[34.4773,31.5849],[34.484,31.5923],[34.6784,31.8957],[34.8038,32.1963],[34.9219,32.6141],[35.0059,32.8266],[35.0771,32.9672],[35.1086,33.0837],[35.2233,33.092],[35.3089,33.0795],[35.4112,33.0757],[35.4932,33.1195],[35.5325,33.2505],[35.5793,33.2715],[35.6029,33.2406],[35.6272,33.275],[35.7345,33.3326],[35.7875,33.3698],[35.8407,33.4157],[35.8691,33.4317],[35.8516,33.3705],[35.8371,33.3305],[35.837,33.2782],[35.8588,33.2496],[35.8885,33.1925],[35.9066,33.1357],[35.8681,33.0886],[35.8718,33.0394],[35.882,32.9981],[35.9135,32.9496],[35.8568,32.8624],[35.8015,32.7823],[35.7873,32.7349]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":4,"sovereignt":"Israel","sov_a3":"ISR","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Israel","adm0_a3":"ISR","geou_dif":0,"geounit":"Israel","gu_a3":"ISR","su_dif":0,"subunit":"Israel","su_a3":"ISR","brk_diff":0,"name":"Israel","name_long":"Israel","brk_a3":"ISR","brk_name":"Israel","brk_group":"","abbrev":"Isr.","postal":"IS","formal_en":"State of Israel","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Israel","name_alt":"","mapcolor7":3,"mapcolor8":2,"mapcolor9":5,"mapcolor13":9,"pop_est":7233701,"gdp_md_est":201400,"pop_year":-99,"lastcensus":2009,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"IL","iso_a3":"ISR","iso_n3":"376","un_a3":"376","wb_a2":"IL","wb_a3":"ISR","woe_id":-99,"adm0_a3_is":"ISR","adm0_a3_us":"ISR","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Western Asia","region_wb":"Middle East & North Africa","name_len":6,"long_len":6,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[12.0513,36.757],[12.0033,36.746],[11.9406,36.7804],[11.9364,36.8286],[11.948,36.8431],[12.0242,36.8209],[12.048,36.7764],[12.0513,36.757]],[[15.5766,38.2203],[15.5089,38.1066],[15.4757,38.0629],[15.2345,37.7848],[15.2068,37.7206],[15.1898,37.6507],[15.1648,37.5896],[15.1311,37.5319],[15.0995,37.4586],[15.1057,37.3755],[15.117,37.3347],[15.146,37.308],[15.1937,37.2829],[15.2303,37.2443],[15.1741,37.2092],[15.236,37.1387],[15.2887,37.0969],[15.2957,37.0552],[15.2945,37.0133],[15.1852,36.9348],[15.1424,36.8916],[15.1158,36.8393],[15.1043,36.7853],[15.1163,36.7365],[15.1126,36.6878],[15.0024,36.6939],[14.8896,36.7235],[14.776,36.7104],[14.6144,36.7666],[14.5555,36.7768],[14.5019,36.7987],[14.3673,36.9729],[14.2591,37.0464],[14.143,37.1037],[14.0243,37.1071],[13.9055,37.1006],[13.8006,37.1359],[13.5871,37.2542],[13.3609,37.3487],[13.2649,37.4104],[13.2211,37.4518],[13.1699,37.4793],[13.0403,37.5065],[12.9241,37.5705],[12.8712,37.5752],[12.7573,37.5674],[12.699,37.5718],[12.6402,37.5943],[12.5268,37.6695],[12.4544,37.7738],[12.4355,37.8198],[12.4868,37.9387],[12.5477,38.0529],[12.6017,38.085],[12.6644,38.1079],[12.7023,38.1417],[12.7344,38.1831],[12.8507,38.0637],[12.9027,38.0349],[12.9555,38.0413],[13.049,38.0841],[13.0568,38.1309],[13.16,38.1903],[13.2911,38.1915],[13.3517,38.1805],[13.3835,38.1268],[13.4335,38.1103],[13.4913,38.1031],[13.6815,38.0007],[13.7349,37.984],[13.7889,37.9812],[13.9366,38.0242],[14.05,38.0405],[14.2877,38.0168],[14.4162,38.0426],[14.506,38.0455],[14.6367,38.0851],[14.7372,38.1508],[14.7896,38.167],[14.8459,38.1717],[14.9819,38.1676],[15.1188,38.1527],[15.1761,38.1681],[15.224,38.211],[15.2796,38.2304],[15.3407,38.2173],[15.4987,38.2909],[15.5684,38.2959],[15.6347,38.2676],[15.5766,38.2203]],[[8.4789,39.0675],[8.4215,38.9687],[8.3609,39.0387],[8.3586,39.0988],[8.3668,39.1159],[8.4406,39.0906],[8.4789,39.0675]],[[13.9383,40.7056],[13.8937,40.697],[13.8677,40.7087],[13.8535,40.7241],[13.8712,40.7618],[13.9621,40.7394],[13.9608,40.7182],[13.9383,40.7056]],[[8.286,41.0398],[8.2527,40.9941],[8.2057,40.9975],[8.224,41.0313],[8.2674,41.0991],[8.3202,41.1219],[8.3438,41.1016],[8.3189,41.0627],[8.286,41.0398]],[[9.632,40.882],[9.682,40.8181],[9.7943,40.5562],[9.8053,40.4996],[9.7828,40.4415],[9.7542,40.4003],[9.643,40.2684],[9.6595,40.1592],[9.7008,40.0918],[9.7067,40.017],[9.686,39.9244],[9.617,39.3544],[9.5836,39.2536],[9.5625,39.166],[9.4863,39.1396],[9.3881,39.1675],[9.2642,39.2168],[9.2069,39.2138],[9.1493,39.197],[9.1018,39.2113],[9.0563,39.2392],[9.0227,39.0433],[8.9666,38.9637],[8.8813,38.9129],[8.8012,38.9097],[8.7186,38.9267],[8.6485,38.9266],[8.5954,38.9643],[8.5533,39.0303],[8.4862,39.1105],[8.4182,39.2057],[8.4107,39.2918],[8.3991,39.4816],[8.4187,39.523],[8.4471,39.5628],[8.461,39.6477],[8.4512,39.7217],[8.4711,39.7481],[8.5107,39.7217],[8.5405,39.7316],[8.5387,39.7697],[8.5478,39.8392],[8.4959,39.8975],[8.4078,39.9172],[8.3993,39.9782],[8.4086,40.0376],[8.4551,40.0776],[8.4708,40.1307],[8.4713,40.2927],[8.4092,40.3523],[8.3854,40.4427],[8.3532,40.5005],[8.2955,40.5586],[8.2303,40.606],[8.1899,40.6516],[8.1809,40.771],[8.2038,40.8707],[8.2242,40.9133],[8.2452,40.907],[8.3102,40.8575],[8.3633,40.8463],[8.4685,40.8343],[8.5719,40.8502],[8.6989,40.8953],[8.8212,40.9499],[8.9981,41.1104],[9.1072,41.1429],[9.1631,41.1852],[9.1821,41.2422],[9.2284,41.2571],[9.283,41.2017],[9.3508,41.1959],[9.4552,41.1501],[9.5002,41.1063],[9.5388,41.0537],[9.5757,41.0305],[9.6153,41.0173],[9.6212,41.0049],[9.5897,40.9925],[9.5537,40.9321],[9.574,40.9147],[9.632,40.882]],[[10.3951,42.8582],[10.4283,42.8192],[10.4322,42.7966],[10.41,42.771],[10.4193,42.7132],[10.3356,42.7611],[10.209,42.7369],[10.1313,42.742],[10.1098,42.7851],[10.1275,42.8103],[10.2482,42.8158],[10.2857,42.8281],[10.359,42.8223],[10.3951,42.8582]],[[12.1308,46.9848],[12.1541,46.9353],[12.268,46.8359],[12.3301,46.7598],[12.3883,46.7026],[12.4792,46.6725],[12.5986,46.6541],[12.6998,46.6475],[12.8056,46.6259],[13.1688,46.5727],[13.3516,46.5579],[13.49,46.5556],[13.7,46.5203],[13.6797,46.4629],[13.6371,46.4485],[13.5633,46.4151],[13.4785,46.3692],[13.3995,46.3175],[13.3782,46.2616],[13.3996,46.225],[13.421,46.2123],[13.4498,46.2235],[13.4918,46.2166],[13.5447,46.1966],[13.6325,46.1771],[13.635,46.1578],[13.6166,46.1331],[13.548,46.0891],[13.4864,46.0396],[13.4803,46.0092],[13.4877,45.9871],[13.5092,45.9738],[13.6006,45.9798],[13.614,45.9617],[13.5696,45.8341],[13.5834,45.8124],[13.6635,45.792],[13.7217,45.7613],[13.8312,45.6804],[13.8747,45.6148],[13.8447,45.5929],[13.776,45.582],[13.7198,45.5876],[13.7833,45.6272],[13.6283,45.7709],[13.5582,45.7707],[13.4651,45.71],[13.2063,45.7714],[13.1567,45.7466],[13.1201,45.6979],[13.0303,45.6375],[12.903,45.6108],[12.7612,45.5443],[12.6117,45.4972],[12.4976,45.4617],[12.4321,45.4679],[12.5361,45.5449],[12.4918,45.5463],[12.3538,45.492],[12.2743,45.446],[12.2488,45.3688],[12.2257,45.2415],[12.2863,45.2077],[12.3925,45.0398],[12.5234,44.968],[12.4979,44.8994],[12.4636,44.8452],[12.3845,44.7983],[12.319,44.8331],[12.2789,44.8322],[12.2483,44.7225],[12.305,44.4294],[12.3963,44.2239],[12.4868,44.1342],[12.6911,43.9947],[12.907,43.9212],[13.2953,43.6861],[13.5082,43.6117],[13.5642,43.5713],[13.6933,43.3899],[13.8047,43.1804],[13.9249,42.8516],[14.0104,42.6896],[14.1827,42.5064],[14.5407,42.2443],[14.8661,42.0525],[15.1688,41.934],[15.405,41.9132],[15.9641,41.9395],[16.0615,41.9281],[16.1646,41.8962],[16.1892,41.814],[16.1513,41.7585],[16.0337,41.7008],[15.9138,41.6208],[15.9005,41.5121],[16.0126,41.4354],[16.5519,41.232],[17.1034,41.0622],[17.2752,40.9754],[17.4742,40.8406],[17.955,40.6552],[18.0361,40.5649],[18.3282,40.3708],[18.4606,40.221],[18.4858,40.1048],[18.4226,39.9869],[18.3935,39.9036],[18.3437,39.8214],[18.2193,39.8525],[18.0779,39.937],[17.865,40.2802],[17.4762,40.3149],[17.3958,40.3402],[17.2577,40.3991],[17.2494,40.4379],[17.2153,40.4864],[17.18,40.5028],[17.0313,40.5135],[16.9282,40.4581],[16.807,40.3265],[16.6696,40.1372],[16.53,39.8597],[16.5219,39.7476],[16.5978,39.6389],[16.8243,39.5783],[16.9992,39.4816],[17.1146,39.3806],[17.1229,39.1366],[17.1746,38.9981],[17.0985,38.9193],[16.9515,38.9398],[16.7555,38.8897],[16.6167,38.8001],[16.559,38.7148],[16.5742,38.4936],[16.5456,38.4091],[16.2824,38.2496],[16.1441,38.0864],[16.1098,38.0187],[16.0568,37.9418],[15.7245,37.9391],[15.6458,38.0342],[15.6431,38.1754],[15.7002,38.2623],[15.8224,38.303],[15.9048,38.4835],[15.8789,38.6139],[15.927,38.6717],[15.9724,38.7126],[16.0655,38.7364],[16.1968,38.7592],[16.21,38.9411],[16.1074,39.0238],[16.0715,39.1395],[16.0236,39.3536],[15.8544,39.6265],[15.7637,39.8701],[15.6928,39.9902],[15.5852,40.0528],[15.3909,40.0521],[15.2945,40.07],[14.9509,40.239],[14.927,40.2647],[14.9291,40.3096],[14.9861,40.3775],[14.9477,40.4693],[14.9069,40.5561],[14.8396,40.63],[14.7657,40.6684],[14.6112,40.6448],[14.5569,40.6264],[14.4594,40.6327],[14.3827,40.5999],[14.3399,40.5988],[14.4605,40.7287],[14.4281,40.7593],[14.3089,40.8126],[14.1472,40.8207],[14.1023,40.8271],[14.0759,40.7939],[14.0443,40.8123],[14.0477,40.8703],[13.8598,41.13],[13.7334,41.2356],[13.6697,41.2545],[13.5548,41.2322],[13.3619,41.2785],[13.2469,41.2889],[13.1834,41.2777],[13.0887,41.2438],[13.041,41.2662],[13.0242,41.3009],[12.8492,41.4087],[12.6309,41.4697],[12.2057,41.8126],[12.0753,41.9409],[11.807,42.082],[11.6373,42.2875],[11.4984,42.3629],[11.2963,42.4233],[11.2497,42.4157],[11.1889,42.3931],[11.1412,42.3899],[11.1032,42.4166],[11.1418,42.4441],[11.1848,42.4566],[11.1678,42.5352],[10.9378,42.7387],[10.8031,42.8043],[10.7651,42.8447],[10.7371,42.9],[10.7084,42.9363],[10.6446,42.9572],[10.5902,42.9536],[10.5148,42.9675],[10.5173,43.0651],[10.5323,43.1401],[10.5208,43.2038],[10.4476,43.3712],[10.3205,43.5131],[10.2458,43.8521],[10.1881,43.9475],[10.0477,44.02],[9.7309,44.1012],[9.2894,44.3192],[9.196,44.323],[8.9304,44.4078],[8.7658,44.4223],[8.552,44.3461],[8.2924,44.1365],[8.0816,43.9189],[8.005,43.8768],[7.7333,43.8026],[7.4932,43.7671],[7.4905,43.8229],[7.482,43.8649],[7.5227,43.9111],[7.5896,43.9654],[7.6515,44.0336],[7.6771,44.0832],[7.665,44.116],[7.6372,44.1648],[7.5994,44.1684],[7.3709,44.1274],[7.3186,44.138],[7.1494,44.2017],[6.9673,44.28],[6.9002,44.3357],[6.8748,44.392],[6.8938,44.4282],[6.8786,44.4633],[6.843,44.5107],[6.8752,44.5646],[6.9319,44.6316],[6.9604,44.6771],[7.0079,44.689],[7.0307,44.7167],[6.9927,44.8273],[6.9729,44.845],[6.9398,44.8587],[6.8894,44.8603],[6.8011,44.8832],[6.7382,44.9214],[6.7247,44.973],[6.6914,45.0226],[6.6348,45.0682],[6.6277,45.118],[6.6923,45.1443],[6.7804,45.1453],[6.8423,45.1356],[6.9813,45.2156],[7.0324,45.2226],[7.0783,45.2399],[7.1168,45.349],[7.1464,45.3817],[7.1534,45.4009],[7.1261,45.4237],[7.0137,45.5005],[6.9624,45.5806],[6.8814,45.6704],[6.8063,45.71],[6.7909,45.7409],[6.7892,45.7801],[6.8045,45.8146],[6.9408,45.8684],[7.0211,45.9258],[7.0558,45.9038],[7.129,45.8804],[7.3279,45.9124],[7.4516,45.9444],[7.5386,45.9782],[7.5926,45.9722],[7.7879,45.9218],[7.8523,45.9475],[7.9932,46.0159],[8.0143,46.0519],[8.1252,46.1609],[8.1272,46.1876],[8.0815,46.256],[8.0957,46.271],[8.2319,46.3412],[8.2985,46.4034],[8.3707,46.4451],[8.4226,46.446],[8.4368,46.4319],[8.443,46.4028],[8.4385,46.2829],[8.4584,46.2459],[8.5654,46.1598],[8.6417,46.1108],[8.8186,46.0771],[8.8268,46.061],[8.778,45.9962],[8.8852,45.9187],[8.9043,45.862],[8.9537,45.83],[9.0237,45.8457],[9.0467,45.8756],[9.0191,45.9281],[8.9989,45.9831],[9.003,46.0149],[9.0224,46.0515],[9.071,46.1024],[9.2034,46.2192],[9.2511,46.2868],[9.2598,46.3913],[9.2602,46.4752],[9.3044,46.4956],[9.3993,46.4807],[9.4276,46.4823],[9.4406,46.4308],[9.4811,46.3488],[9.5287,46.3062],[9.5796,46.2961],[9.6395,46.2959],[9.7878,46.346],[9.8845,46.3678],[9.9393,46.3618],[9.9717,46.3277],[10.041,46.2381],[10.0806,46.228],[10.1283,46.2382],[10.1452,46.2535],[10.1299,46.288],[10.1097,46.3628],[10.0819,46.4208],[10.0456,46.4479],[10.0383,46.4832],[10.0612,46.5468],[10.087,46.5999],[10.1375,46.6144],[10.1955,46.6211],[10.2723,46.5648],[10.3631,46.5471],[10.4307,46.55],[10.4425,46.5829],[10.4383,46.6188],[10.3979,46.665],[10.4061,46.7349],[10.4528,46.8649],[10.4794,46.8551],[10.5798,46.8537],[10.6893,46.8464],[10.7598,46.7933],[10.8289,46.7752],[10.9273,46.7695],[10.9933,46.777],[11.0251,46.797],[11.0635,46.8591],[11.1339,46.9362],[11.2444,46.9757],[11.4332,46.9831],[11.5275,46.9974],[11.6255,46.9966],[11.6994,46.9847],[11.7757,46.9861],[11.9695,47.0397],[12.1694,47.0821],[12.1972,47.075],[12.2013,47.0609],[12.1655,47.0282],[12.1308,46.9848]],[[12.3969,43.9346],[12.4264,43.8941],[12.4853,43.9014],[12.5146,43.953],[12.5037,43.9897],[12.4411,43.9824],[12.3969,43.9346]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Italy","sov_a3":"ITA","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Italy","adm0_a3":"ITA","geou_dif":0,"geounit":"Italy","gu_a3":"ITA","su_dif":0,"subunit":"Italy","su_a3":"ITA","brk_diff":0,"name":"Italy","name_long":"Italy","brk_a3":"ITA","brk_name":"Italy","brk_group":"","abbrev":"Italy","postal":"I","formal_en":"Italian Republic","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Italy","name_alt":"","mapcolor7":6,"mapcolor8":7,"mapcolor9":8,"mapcolor13":7,"pop_est":58126212,"gdp_md_est":1823000,"pop_year":-99,"lastcensus":2012,"gdp_year":-99,"economy":"1. Developed region: G7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"IT","iso_a3":"ITA","iso_n3":"380","un_a3":"380","wb_a2":"IT","wb_a3":"ITA","woe_id":-99,"adm0_a3_is":"ITA","adm0_a3_us":"ITA","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Southern Europe","region_wb":"Europe & Central Asia","name_len":5,"long_len":5,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[-9.9482,53.9131],[-9.9524,53.8846],[-10.0265,53.9206],[-10.0625,53.9597],[-10.2657,53.9777],[-10.1811,54.0168],[-10.1397,54.0052],[-9.9964,54.0036],[-9.9562,53.9872],[-9.9482,53.9131]],[[-7.4014,55.0033],[-7.446,54.9051],[-7.4513,54.8771],[-7.5022,54.8254],[-7.5504,54.768],[-7.6064,54.7457],[-7.69,54.728],[-7.7375,54.7104],[-7.7973,54.7193],[-7.8729,54.7179],[-7.9106,54.6983],[-7.9087,54.6833],[-7.8861,54.6661],[-7.8198,54.6397],[-7.7463,54.6158],[-7.7544,54.5949],[-7.7938,54.5712],[-8.0443,54.5125],[-8.1189,54.477],[-8.1448,54.4535],[-8.1183,54.4143],[-7.9185,54.2966],[-7.8845,54.2838],[-7.8549,54.2153],[-7.6788,54.1867],[-7.6065,54.1438],[-7.5444,54.1336],[-7.4094,54.1373],[-7.3552,54.1212],[-7.3245,54.1334],[-7.3067,54.156],[-7.1931,54.2141],[-7.1555,54.2395],[-7.1781,54.2749],[-7.2026,54.3018],[-7.1335,54.3554],[-7.0497,54.4083],[-7.0077,54.4067],[-6.9361,54.3743],[-6.8772,54.3291],[-6.8692,54.294],[-6.8583,54.2687],[-6.8026,54.2144],[-6.7666,54.1956],[-6.6695,54.1847],[-6.6469,54.1634],[-6.6642,54.0848],[-6.6498,54.0586],[-6.5481,54.0573],[-6.4403,54.0636],[-6.4026,54.0606],[-6.3637,54.0771],[-6.3037,54.0949],[-6.218,54.0887],[-6.1757,54.0535],[-6.1569,54.0172],[-6.2307,54.0036],[-6.3076,54.011],[-6.3452,53.9872],[-6.3476,53.9413],[-6.3216,53.8822],[-6.2701,53.8402],[-6.229,53.7457],[-6.1949,53.6409],[-6.1418,53.5775],[-6.131,53.4989],[-6.1388,53.4603],[-6.1291,53.3909],[-6.1517,53.3664],[-6.1347,53.3012],[-6.0723,53.1663],[-6.045,53.0912],[-6.0274,52.9271],[-6.0715,52.8656],[-6.1307,52.8073],[-6.1693,52.7381],[-6.1992,52.6635],[-6.2172,52.5431],[-6.3454,52.402],[-6.4,52.3669],[-6.4632,52.3454],[-6.325,52.2467],[-6.4379,52.2027],[-6.5611,52.1888],[-6.6973,52.2135],[-6.7822,52.2105],[-6.8597,52.1786],[-6.8902,52.1592],[-6.9146,52.1686],[-6.9658,52.2495],[-7.0033,52.1659],[-7.0818,52.1393],[-7.2162,52.145],[-7.4409,52.1227],[-7.5273,52.0989],[-7.5632,52.0616],[-7.5898,52.0186],[-7.6249,51.9931],[-7.6646,51.9797],[-7.838,51.948],[-7.8722,51.9353],[-7.9525,51.8658],[-8.0578,51.8256],[-8.145,51.8135],[-8.2225,51.854],[-8.2543,51.8783],[-8.2902,51.8907],[-8.4092,51.8888],[-8.3716,51.8763],[-8.3474,51.8477],[-8.3356,51.793],[-8.3491,51.7393],[-8.4078,51.7121],[-8.4778,51.707],[-8.5883,51.6514],[-8.7345,51.6362],[-8.8134,51.5849],[-9.2965,51.4982],[-9.3239,51.4972],[-9.3906,51.5193],[-9.4629,51.5291],[-9.5349,51.5222],[-9.7373,51.4737],[-9.8354,51.4833],[-9.7104,51.6037],[-9.5424,51.6645],[-9.5249,51.6811],[-9.5798,51.6893],[-9.899,51.6471],[-10.0099,51.6111],[-10.1208,51.6007],[-10.0694,51.6556],[-9.9264,51.7307],[-9.8497,51.7661],[-9.8029,51.7801],[-9.7495,51.8243],[-9.5988,51.8744],[-10.0842,51.771],[-10.2117,51.7836],[-10.2417,51.8125],[-10.3411,51.7989],[-10.3787,51.8688],[-10.2316,51.9745],[-10.1458,52.02],[-10.044,52.0446],[-9.946,52.0798],[-9.9097,52.1229],[-9.9558,52.1367],[-10.2495,52.1257],[-10.3902,52.1349],[-10.3826,52.1691],[-10.3567,52.2069],[-10.2109,52.2717],[-10.1321,52.2821],[-10.0618,52.2759],[-9.9931,52.2593],[-9.9373,52.2376],[-9.7721,52.2501],[-9.8411,52.2915],[-9.8532,52.3755],[-9.9061,52.4037],[-9.8385,52.4427],[-9.7611,52.4664],[-9.6322,52.5469],[-9.5863,52.5592],[-9.3313,52.5788],[-9.0562,52.6211],[-8.7834,52.6796],[-8.9233,52.7123],[-8.9903,52.7554],[-9.0979,52.6683],[-9.1754,52.6349],[-9.3942,52.6171],[-9.4635,52.6269],[-9.561,52.654],[-9.5914,52.6437],[-9.6195,52.6228],[-9.7644,52.58],[-9.9166,52.5697],[-9.7396,52.6482],[-9.515,52.7812],[-9.4649,52.8232],[-9.3937,52.8962],[-9.4157,52.9288],[-9.462,52.9473],[-9.2992,53.0976],[-9.2419,53.1249],[-9.1376,53.1292],[-9.0611,53.1531],[-9.0274,53.1532],[-8.9972,53.1621],[-8.9301,53.2071],[-9.0335,53.2357],[-9.1403,53.2505],[-9.4708,53.2349],[-9.5142,53.2382],[-9.5552,53.2521],[-9.5817,53.272],[-9.6018,53.323],[-9.626,53.3345],[-9.7006,53.3345],[-9.7741,53.3188],[-9.8254,53.3204],[-9.8758,53.3427],[-9.7954,53.395],[-9.899,53.4073],[-10.0039,53.397],[-10.0913,53.4128],[-10.094,53.4456],[-10.0544,53.4783],[-10.1062,53.5093],[-10.117,53.5485],[-10.0617,53.5678],[-10.0014,53.5614],[-9.8783,53.5904],[-9.7207,53.6045],[-9.8559,53.6331],[-9.9097,53.6576],[-9.9123,53.6951],[-9.9016,53.7272],[-9.7451,53.7815],[-9.5782,53.8054],[-9.5905,53.8412],[-9.5789,53.8798],[-9.7475,53.891],[-9.9141,53.8637],[-9.8962,53.9376],[-9.8563,54.0043],[-9.8485,54.0483],[-9.8564,54.0954],[-9.9345,54.0752],[-9.9436,54.1416],[-9.9771,54.1871],[-10.0927,54.1558],[-10.0897,54.2158],[-10.0564,54.2578],[-9.9959,54.276],[-9.9359,54.2681],[-9.8246,54.2689],[-9.7171,54.3004],[-9.5623,54.3085],[-9.3155,54.2986],[-9.1459,54.2096],[-9.1021,54.2255],[-9.0343,54.2818],[-9.0024,54.288],[-8.7468,54.2635],[-8.588,54.2311],[-8.5456,54.2412],[-8.5685,54.3036],[-8.6231,54.3469],[-8.5544,54.4036],[-8.471,54.4419],[-8.4152,54.4611],[-8.2865,54.4849],[-8.2304,54.5073],[-8.193,54.5801],[-8.1334,54.6408],[-8.4565,54.6093],[-8.7639,54.6812],[-8.7152,54.732],[-8.6503,54.7609],[-8.5383,54.783],[-8.5277,54.8095],[-8.471,54.8315],[-8.3773,54.8895],[-8.4117,54.9651],[-8.3933,55.0204],[-8.3258,55.0564],[-8.3047,55.1082],[-8.2746,55.1463],[-8.1377,55.1599],[-8.0061,55.1953],[-7.9586,55.1919],[-7.8032,55.2],[-7.7505,55.1858],[-7.7625,55.2483],[-7.6671,55.2565],[-7.6298,55.244],[-7.6134,55.1997],[-7.57,55.1714],[-7.5566,55.1222],[-7.5857,55.0842],[-7.6343,55.055],[-7.5898,55.025],[-7.6587,54.9709],[-7.5844,54.994],[-7.4784,55.047],[-7.4839,55.0903],[-7.502,55.1447],[-7.5314,55.1938],[-7.5179,55.2479],[-7.4583,55.2818],[-7.3018,55.2988],[-7.366,55.3602],[-7.3088,55.3658],[-7.2467,55.353],[-7.1553,55.3052],[-7.0603,55.2676],[-6.9617,55.2379],[-7.0564,55.1783],[-7.1729,55.137],[-7.2187,55.092],[-7.3769,55.0277],[-7.4014,55.0033]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Ireland","sov_a3":"IRL","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Ireland","adm0_a3":"IRL","geou_dif":0,"geounit":"Ireland","gu_a3":"IRL","su_dif":0,"subunit":"Ireland","su_a3":"IRL","brk_diff":0,"name":"Ireland","name_long":"Ireland","brk_a3":"IRL","brk_name":"Ireland","brk_group":"","abbrev":"Ire.","postal":"IRL","formal_en":"Ireland","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Ireland","name_alt":"","mapcolor7":2,"mapcolor8":3,"mapcolor9":2,"mapcolor13":2,"pop_est":4203200,"gdp_md_est":188400,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"IE","iso_a3":"IRL","iso_n3":"372","un_a3":"372","wb_a2":"IE","wb_a3":"IRL","woe_id":-99,"adm0_a3_is":"IRL","adm0_a3_us":"IRL","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Northern Europe","region_wb":"Europe & Central Asia","name_len":7,"long_len":7,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[56.188,26.9211],[56.0949,26.8012],[55.9543,26.7011],[55.8941,26.7323],[55.8477,26.7308],[55.7473,26.6925],[55.6746,26.6858],[55.5432,26.6175],[55.4237,26.5831],[55.3404,26.5857],[55.3115,26.5926],[55.295,26.6392],[55.2965,26.6576],[55.347,26.6479],[55.5317,26.71],[55.7626,26.812],[55.7846,26.8572],[55.7475,26.931],[55.7576,26.9477],[55.9071,26.9098],[56.0741,26.9833],[56.214,27.0033],[56.2794,26.9521],[56.188,26.9211]],[[45.0002,39.4235],[45.0717,39.3629],[45.1131,39.3116],[45.1412,39.2543],[45.1906,39.2156],[45.256,39.1947],[45.3355,39.1392],[45.3893,39.0959],[45.4797,39.0062],[45.575,38.9728],[45.9219,38.9079],[46.1145,38.8778],[46.1701,38.869],[46.3178,38.9126],[46.4906,38.9067],[46.5548,38.9044],[46.7832,39.0874],[46.8525,39.1484],[46.9889,39.1802],[47.0654,39.2529],[47.1884,39.341],[47.3385,39.4239],[47.4762,39.4983],[47.5818,39.5434],[47.7729,39.6486],[47.8923,39.6851],[47.9959,39.6839],[48.1511,39.5605],[48.2817,39.4483],[48.3222,39.3991],[48.2572,39.355],[48.136,39.3124],[48.1129,39.2811],[48.1044,39.2411],[48.1092,39.2028],[48.1255,39.1716],[48.2741,39.0991],[48.291,39.0593],[48.2921,39.0188],[48.2751,38.9936],[48.242,38.979],[48.1386,38.9586],[48.0501,38.935],[48.0193,38.9118],[47.9927,38.8843],[47.9965,38.8538],[48.0232,38.819],[48.2047,38.7241],[48.2252,38.6892],[48.2613,38.6423],[48.3056,38.6135],[48.3813,38.6056],[48.4174,38.5862],[48.5927,38.4111],[48.6355,38.3987],[48.8403,38.4373],[48.8688,38.4355],[48.8707,38.3925],[48.9014,38.1437],[48.9251,38.0151],[48.96,37.8901],[49.0153,37.7761],[49.081,37.6676],[49.1712,37.6006],[49.3725,37.52],[49.4701,37.4967],[49.727,37.4805],[49.9807,37.4449],[50.1305,37.4071],[50.1763,37.3805],[50.2141,37.3396],[50.3379,37.1492],[50.5332,37.0137],[50.9274,36.8102],[51.1186,36.7426],[51.762,36.6145],[52.1901,36.6217],[53.3741,36.8688],[53.7677,36.9303],[53.9154,36.9303],[53.8274,36.8812],[53.6795,36.8531],[53.7688,36.8185],[53.9062,36.8127],[53.9701,36.8183],[54.0162,36.8497],[54.0238,36.9013],[54.0172,36.9525],[53.952,37.1817],[53.9142,37.3436],[54.1916,37.3325],[54.2998,37.3536],[54.4587,37.4076],[54.5789,37.4402],[54.6396,37.4447],[54.6994,37.4702],[54.7452,37.5019],[54.8486,37.7227],[54.9001,37.7779],[55.0756,37.9025],[55.2247,37.9813],[55.3809,38.0511],[55.5784,38.0998],[55.8413,38.0946],[56.0503,38.0775],[56.1712,38.0784],[56.2288,38.0734],[56.2721,38.0804],[56.297,38.0948],[56.3241,38.1911],[56.3669,38.2225],[56.4406,38.2494],[56.544,38.2496],[56.6699,38.2566],[56.7746,38.25],[56.9066,38.213],[57.079,38.21],[57.1936,38.2164],[57.2602,38.1796],[57.3081,38.1304],[57.3314,38.0893],[57.3367,38.0329],[57.3357,37.9899],[57.3537,37.9733],[57.4238,37.9477],[57.521,37.9285],[57.7105,37.9053],[57.8882,37.8608],[57.9806,37.8305],[58.1088,37.7831],[58.2616,37.6658],[58.3182,37.6472],[58.3867,37.6354],[58.4357,37.6385],[58.5505,37.6882],[58.6502,37.6516],[58.7008,37.6563],[58.8154,37.6835],[58.9372,37.6497],[59.2408,37.5208],[59.2741,37.5237],[59.3018,37.5106],[59.327,37.4812],[59.3447,37.4447],[59.3674,37.3337],[59.455,37.2528],[59.5622,37.1789],[59.6872,37.1385],[59.9486,37.0416],[60.0628,36.9629],[60.1783,36.8294],[60.3207,36.6536],[60.3413,36.6376],[60.7079,36.643],[61.1196,36.6426],[61.1699,36.5723],[61.1604,36.4327],[61.1751,36.2897],[61.212,36.1905],[61.2124,36.0991],[61.1826,36.0528],[61.1595,35.9999],[61.1529,35.9768],[61.2059,35.9437],[61.2521,35.8676],[61.2587,35.7618],[61.2355,35.7056],[61.2389,35.6593],[61.262,35.6196],[61.2818,35.5534],[61.2785,35.5138],[61.2455,35.4741],[61.2257,35.4245],[61.1992,35.3616],[61.1893,35.312],[61.1396,35.2889],[61.1,35.2723],[61.1066,35.2095],[61.1265,35.1565],[61.1496,35.0937],[61.1231,35.0507],[61.1066,35.0011],[61.0702,34.9217],[61.0801,34.8556],[61.0404,34.7994],[60.9908,34.7498],[60.9578,34.7101],[60.9512,34.6539],[60.9147,34.634],[60.8453,34.5877],[60.8023,34.5546],[60.7395,34.5447],[60.7263,34.5183],[60.7361,34.4918],[60.7626,34.4752],[60.8039,34.418],[60.8895,34.3194],[60.6427,34.3072],[60.5702,34.2196],[60.4857,34.0948],[60.5271,33.842],[60.4859,33.7119],[60.5108,33.6389],[60.5738,33.5883],[60.6546,33.5604],[60.8064,33.5587],[60.9069,33.539],[60.917,33.5052],[60.8593,33.4562],[60.7669,33.3638],[60.7181,33.3235],[60.5605,33.1378],[60.5619,33.0588],[60.5766,32.9949],[60.6445,32.7944],[60.7104,32.6],[60.8293,32.2494],[60.8272,32.168],[60.7899,31.9871],[60.7875,31.8772],[60.8043,31.7345],[60.7916,31.6606],[60.8207,31.4952],[60.8541,31.4833],[61.1107,31.4511],[61.3465,31.4216],[61.6602,31.3824],[61.7551,31.2853],[61.8143,31.0726],[61.8108,30.9133],[61.7842,30.8319],[61.5595,30.5994],[61.3316,30.3637],[61.1041,30.1284],[60.8682,29.8844],[60.8434,29.8587],[61.0342,29.6634],[61.1521,29.5427],[61.3184,29.3726],[61.3395,29.3318],[61.3379,29.265],[61.5086,29.0061],[61.5688,28.8709],[61.623,28.7916],[61.758,28.6677],[61.8898,28.5465],[62.033,28.491],[62.1306,28.4788],[62.353,28.4147],[62.4339,28.3639],[62.5646,28.2352],[62.7176,28.2528],[62.7494,28.2529],[62.758,28.2436],[62.7625,28.2021],[62.7397,28.0021],[62.7823,27.8005],[62.812,27.497],[62.8009,27.4445],[62.7643,27.3567],[62.7625,27.3002],[62.7527,27.2656],[62.763,27.2502],[62.8116,27.2294],[62.9154,27.2184],[63.1668,27.2525],[63.1961,27.2439],[63.2563,27.2079],[63.3016,27.1515],[63.3052,27.1246],[63.2421,27.0777],[63.2314,26.9981],[63.2504,26.8792],[63.2416,26.8647],[63.1861,26.8376],[63.1681,26.6656],[63.1578,26.6498],[63.093,26.6323],[62.7866,26.6439],[62.7516,26.6392],[62.6364,26.5937],[62.4393,26.561],[62.3851,26.5426],[62.3123,26.4909],[62.2597,26.4275],[62.2496,26.3692],[62.2394,26.357],[62.126,26.369],[62.0891,26.3183],[61.8698,26.2424],[61.8424,26.2259],[61.81,26.1653],[61.7808,25.9958],[61.7544,25.8434],[61.7377,25.8211],[61.6687,25.769],[61.6618,25.7513],[61.6714,25.6924],[61.6401,25.5846],[61.6154,25.2861],[61.5879,25.2023],[61.5331,25.1955],[61.4903,25.1537],[61.4122,25.1021],[61.243,25.142],[61.1086,25.1839],[60.6639,25.2822],[60.6151,25.3298],[60.5875,25.4135],[60.5105,25.4371],[60.4002,25.3116],[60.0247,25.3841],[59.8971,25.3618],[59.8184,25.4009],[59.616,25.4033],[59.4561,25.4815],[59.2272,25.4277],[59.0461,25.4173],[58.7979,25.5546],[58.5309,25.5924],[58.3143,25.5809],[58.2029,25.5916],[58.0224,25.6408],[57.9366,25.6917],[57.7961,25.653],[57.7325,25.7249],[57.3346,25.7916],[57.2609,25.9188],[57.2056,26.0372],[57.2014,26.1588],[57.1043,26.3714],[57.072,26.6801],[57.036,26.8007],[56.9822,26.9055],[56.9104,26.9946],[56.8129,27.09],[56.7281,27.1277],[56.3562,27.2002],[56.2844,27.1906],[56.1181,27.1431],[55.9411,27.0376],[55.6503,26.9775],[55.5916,26.9321],[55.5186,26.8299],[55.424,26.7706],[55.2941,26.7859],[55.1546,26.7254],[54.8958,26.5567],[54.7593,26.5051],[54.6449,26.5089],[54.5221,26.5892],[54.2471,26.6966],[54.0693,26.7324],[53.8226,26.7077],[53.7058,26.7256],[53.5071,26.8518],[53.455,26.9433],[53.3417,27.0045],[52.9825,27.1419],[52.6916,27.3234],[52.6382,27.392],[52.6026,27.4934],[52.4759,27.6165],[52.1919,27.7173],[52.0308,27.8244],[51.842,27.8482],[51.6663,27.845],[51.5891,27.8642],[51.5186,27.91],[51.2789,28.1313],[51.2761,28.2188],[51.1284,28.4352],[51.0938,28.5121],[51.062,28.7261],[51.0212,28.7821],[50.867,28.8702],[50.843,28.9278],[50.8758,29.0044],[50.8758,29.0627],[50.7955,29.1174],[50.6752,29.1466],[50.6461,29.2122],[50.668,29.3398],[50.6496,29.4201],[50.5436,29.548],[50.3869,29.6791],[50.2302,29.8729],[50.1689,29.9212],[50.1289,30.0481],[50.0716,30.1985],[49.9831,30.2094],[49.5549,30.029],[49.43,30.1305],[49.0543,30.3069],[49.0281,30.3334],[49.002,30.3739],[49.049,30.3973],[49.0962,30.4068],[49.1903,30.3754],[49.2473,30.4125],[49.2245,30.4723],[49.1304,30.5094],[49.002,30.5065],[49.0371,30.4505],[48.9168,30.3973],[48.8912,30.3276],[48.9087,30.2415],[48.9191,30.1209],[48.8701,30.0624],[48.8324,30.0355],[48.6709,30.0283],[48.5955,29.975],[48.5465,29.9624],[48.4785,30.0038],[48.4346,30.0376],[48.3986,30.1096],[48.3876,30.1599],[48.4014,30.1883],[48.3826,30.2302],[48.3311,30.2854],[48.2789,30.3158],[48.2262,30.3213],[48.1824,30.355],[48.1476,30.4168],[48.0661,30.4577],[48.0149,30.4656],[48.0135,30.6564],[48.012,30.8236],[48.0106,30.9898],[47.8363,30.9964],[47.6795,31.0024],[47.6795,31.1415],[47.6795,31.4006],[47.7539,31.6014],[47.83,31.7944],[47.7146,31.9364],[47.5915,32.088],[47.5119,32.1508],[47.4182,32.3401],[47.3713,32.4237],[47.3298,32.4555],[47.2852,32.474],[47.1214,32.4666],[46.9686,32.5684],[46.7891,32.688],[46.5699,32.8339],[46.3771,32.9292],[46.2982,32.9502],[46.1128,32.9577],[46.0931,32.9759],[46.0805,33.0282],[46.0808,33.0865],[46.1411,33.1744],[46.1459,33.2296],[46.0199,33.4157],[45.9811,33.4701],[45.8732,33.492],[45.8947,33.5457],[45.8947,33.5815],[45.8794,33.6098],[45.8545,33.6233],[45.8229,33.6248],[45.7383,33.6028],[45.6737,33.6867],[45.4732,33.9255],[45.409,33.9545],[45.3971,33.9708],[45.4461,34.044],[45.5286,34.1525],[45.5428,34.2155],[45.5269,34.2847],[45.4376,34.4151],[45.4594,34.4704],[45.4978,34.5339],[45.5008,34.5816],[45.5608,34.5745],[45.6375,34.5738],[45.6615,34.6127],[45.6601,34.7488],[45.6781,34.7984],[45.9209,35.0285],[46.0418,35.0802],[46.1338,35.1276],[46.1547,35.1967],[46.1357,35.2323],[46.1178,35.2843],[46.1121,35.3217],[46.0106,35.4248],[45.9754,35.4768],[45.9711,35.5242],[45.995,35.6081],[46.0374,35.6731],[46.181,35.7114],[46.2625,35.7441],[46.2734,35.7732],[46.1675,35.8206],[45.9414,35.8354],[45.7764,35.8218],[45.7234,35.8367],[45.645,35.9284],[45.5616,35.9772],[45.4838,36.0085],[45.4077,36.0028],[45.3616,36.0153],[45.3509,36.0546],[45.2411,36.356],[45.2065,36.3972],[45.1553,36.4074],[45.1124,36.4093],[45.0838,36.43],[45.0531,36.4716],[45.0311,36.5261],[45.0294,36.5976],[45.034,36.6589],[45.0192,36.6984],[44.9814,36.7377],[44.9278,36.7659],[44.8809,36.7993],[44.7984,37.0639],[44.7654,37.135],[44.7651,37.1424],[44.7667,37.1563],[44.7583,37.2171],[44.7968,37.2698],[44.7941,37.2904],[44.7151,37.3571],[44.6041,37.4237],[44.574,37.4354],[44.5731,37.5064],[44.5771,37.5602],[44.5672,37.6086],[44.5461,37.6363],[44.5453,37.6582],[44.5899,37.7104],[44.5612,37.7446],[44.3978,37.8292],[44.3362,37.8718],[44.2229,37.8802],[44.2113,37.9081],[44.2289,37.9672],[44.268,38.0388],[44.3294,38.1093],[44.3489,38.1465],[44.3728,38.2097],[44.3809,38.2546],[44.4496,38.3178],[44.4499,38.3342],[44.4309,38.3568],[44.3758,38.3696],[44.3196,38.3747],[44.2985,38.3863],[44.2908,38.4201],[44.2979,38.5578],[44.2802,38.6407],[44.257,38.7006],[44.2717,38.836],[44.2324,38.8632],[44.1708,38.9344],[44.1445,38.9944],[44.1588,39.0167],[44.1719,39.0562],[44.1806,39.1081],[44.178,39.1448],[44.1213,39.1806],[44.0791,39.2183],[44.0743,39.26],[44.0575,39.3108],[44.0338,39.351],[44.0232,39.3774],[44.0439,39.393],[44.124,39.4052],[44.2404,39.3968],[44.3354,39.396],[44.3894,39.4221],[44.456,39.6667],[44.5167,39.7313],[44.5871,39.7686],[44.725,39.6817],[44.7821,39.6511],[44.8172,39.6504],[44.8382,39.6291],[45.0002,39.4235]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Iran","sov_a3":"IRN","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Iran","adm0_a3":"IRN","geou_dif":0,"geounit":"Iran","gu_a3":"IRN","su_dif":0,"subunit":"Iran","su_a3":"IRN","brk_diff":0,"name":"Iran","name_long":"Iran","brk_a3":"IRN","brk_name":"Iran","brk_group":"","abbrev":"Iran","postal":"IRN","formal_en":"Islamic Republic of Iran","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Iran, Islamic Rep.","name_alt":"","mapcolor7":4,"mapcolor8":3,"mapcolor9":4,"mapcolor13":13,"pop_est":66429284,"gdp_md_est":841700,"pop_year":-99,"lastcensus":2006,"gdp_year":-99,"economy":"5. Emerging region: G20","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"IR","iso_a3":"IRN","iso_n3":"364","un_a3":"364","wb_a2":"IR","wb_a3":"IRN","woe_id":-99,"adm0_a3_is":"IRN","adm0_a3_us":"IRN","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Southern Asia","region_wb":"Middle East & North Africa","name_len":4,"long_len":4,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[44.7651,37.1424],[44.7654,37.135],[44.7984,37.0639],[44.8809,36.7993],[44.9278,36.7659],[44.9814,36.7377],[45.0192,36.6984],[45.034,36.6589],[45.0294,36.5976],[45.0311,36.5261],[45.0531,36.4716],[45.0838,36.43],[45.1124,36.4093],[45.1553,36.4074],[45.2065,36.3972],[45.2411,36.356],[45.3509,36.0546],[45.3616,36.0153],[45.4077,36.0028],[45.4838,36.0085],[45.5616,35.9772],[45.645,35.9284],[45.7234,35.8367],[45.7764,35.8218],[45.9414,35.8354],[46.1675,35.8206],[46.2734,35.7732],[46.2625,35.7441],[46.181,35.7114],[46.0374,35.6731],[45.995,35.6081],[45.9711,35.5242],[45.9754,35.4768],[46.0106,35.4248],[46.1121,35.3217],[46.1178,35.2843],[46.1357,35.2323],[46.1547,35.1967],[46.1338,35.1276],[46.0418,35.0802],[45.9209,35.0285],[45.6781,34.7984],[45.6601,34.7488],[45.6615,34.6127],[45.6375,34.5738],[45.5608,34.5745],[45.5008,34.5816],[45.4978,34.5339],[45.4594,34.4704],[45.4376,34.4151],[45.5269,34.2847],[45.5428,34.2155],[45.5286,34.1525],[45.4461,34.044],[45.3971,33.9708],[45.409,33.9545],[45.4732,33.9255],[45.6737,33.6867],[45.7383,33.6028],[45.8229,33.6248],[45.8545,33.6233],[45.8794,33.6098],[45.8947,33.5815],[45.8947,33.5457],[45.8732,33.492],[45.9811,33.4701],[46.0199,33.4157],[46.1459,33.2296],[46.1411,33.1744],[46.0808,33.0865],[46.0805,33.0282],[46.0931,32.9759],[46.1128,32.9577],[46.2982,32.9502],[46.3771,32.9292],[46.5699,32.8339],[46.7891,32.688],[46.9686,32.5684],[47.1214,32.4666],[47.2852,32.474],[47.3298,32.4555],[47.3713,32.4237],[47.4182,32.3401],[47.5119,32.1508],[47.5915,32.088],[47.7146,31.9364],[47.83,31.7944],[47.7539,31.6014],[47.6795,31.4006],[47.6795,31.1415],[47.6795,31.0024],[47.8363,30.9964],[48.0106,30.9898],[48.012,30.8236],[48.0135,30.6564],[48.0149,30.4656],[48.0661,30.4577],[48.1476,30.4168],[48.1824,30.355],[48.2262,30.3213],[48.2789,30.3158],[48.3311,30.2854],[48.3826,30.2302],[48.4014,30.1883],[48.3876,30.1599],[48.3986,30.1096],[48.4346,30.0376],[48.4785,30.0038],[48.5465,29.9624],[48.4542,29.9385],[48.3546,29.9567],[48.1417,30.0409],[48.0728,30.0432],[47.9825,30.0113],[47.9787,29.9828],[47.7539,30.0766],[47.6728,30.0956],[47.6438,30.0973],[47.5148,30.0965],[47.3313,30.0797],[47.2232,30.0415],[47.1482,30.001],[47.1144,29.9613],[47.1021,29.94],[47.0437,29.823],[46.976,29.6729],[46.9059,29.5375],[46.7693,29.3475],[46.6938,29.2597],[46.5314,29.0962],[46.3564,29.0637],[45.9497,29.0958],[45.4989,29.1315],[45.0503,29.1671],[44.7165,29.1936],[44.6908,29.2023],[44.3607,29.4353],[44.0996,29.6193],[43.7737,29.8492],[43.4408,30.084],[43.1031,30.3222],[42.8577,30.4952],[42.5598,30.7178],[42.2886,30.9204],[42.0744,31.0804],[41.7997,31.2204],[41.5851,31.3297],[41.2725,31.489],[41.0225,31.6164],[40.8084,31.7254],[40.4789,31.8934],[40.3693,31.939],[40.0278,31.995],[39.7041,32.0425],[39.3687,32.0917],[39.1454,32.1245],[39.2928,32.2438],[39.2475,32.351],[39.14,32.3312],[39.0414,32.3057],[38.9816,32.4726],[39.0578,32.4932],[38.9874,32.7107],[38.9148,32.9347],[38.845,33.1509],[38.7735,33.3722],[39.0567,33.514],[39.2684,33.62],[39.5645,33.7684],[39.85,33.9114],[40.122,34.0477],[40.4215,34.1978],[40.6895,34.332],[40.9351,34.3866],[40.987,34.4291],[41.099,34.6123],[41.1947,34.769],[41.1992,34.8053],[41.1996,35.0274],[41.2164,35.2882],[41.2483,35.4275],[41.3033,35.5506],[41.3541,35.6404],[41.3594,35.7246],[41.3526,35.81],[41.3002,35.939],[41.2456,36.0734],[41.2518,36.203],[41.2618,36.2725],[41.296,36.3833],[41.3542,36.4644],[41.4168,36.5146],[41.6502,36.5664],[41.7886,36.5972],[41.974,36.7408],[42.084,36.826],[42.2373,36.9611],[42.3501,37.0606],[42.3591,37.095],[42.359,37.1086],[42.4559,37.1287],[42.6354,37.2493],[42.7411,37.3619],[42.7746,37.3719],[42.8691,37.3349],[42.9366,37.3248],[43.0925,37.3674],[43.1852,37.3449],[43.2631,37.3165],[43.3067,37.3146],[43.5158,37.2445],[43.568,37.2358],[43.6758,37.2272],[43.8364,37.2235],[43.94,37.2693],[44.0132,37.3135],[44.0646,37.3125],[44.1145,37.3019],[44.1563,37.283],[44.1918,37.2499],[44.2084,37.2026],[44.2017,37.0518],[44.2175,37.0119],[44.2457,36.9833],[44.2818,36.978],[44.3256,37.0107],[44.402,37.0585],[44.496,37.1105],[44.566,37.1583],[44.606,37.176],[44.6693,37.1736],[44.731,37.1653],[44.7651,37.1424]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Iraq","sov_a3":"IRQ","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Iraq","adm0_a3":"IRQ","geou_dif":0,"geounit":"Iraq","gu_a3":"IRQ","su_dif":0,"subunit":"Iraq","su_a3":"IRQ","brk_diff":0,"name":"Iraq","name_long":"Iraq","brk_a3":"IRQ","brk_name":"Iraq","brk_group":"","abbrev":"Iraq","postal":"IRQ","formal_en":"Republic of Iraq","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Iraq","name_alt":"","mapcolor7":1,"mapcolor8":4,"mapcolor9":3,"mapcolor13":1,"pop_est":31129225,"gdp_md_est":103900,"pop_year":-99,"lastcensus":1997,"gdp_year":-99,"economy":"6. Developing region","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"IQ","iso_a3":"IRQ","iso_n3":"368","un_a3":"368","wb_a2":"IQ","wb_a3":"IRQ","woe_id":-99,"adm0_a3_is":"IRQ","adm0_a3_us":"IRQ","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Western Asia","region_wb":"Middle East & North Africa","name_len":4,"long_len":4,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[122.9489,-10.9093],[122.8559,-10.9097],[122.8262,-10.8991],[122.8185,-10.811],[122.8457,-10.7618],[123.0614,-10.6984],[123.1458,-10.6399],[123.2654,-10.5182],[123.3396,-10.4862],[123.3585,-10.4725],[123.3711,-10.4749],[123.3831,-10.5676],[123.4129,-10.6227],[123.4182,-10.6513],[123.3107,-10.6984],[123.2148,-10.8062],[123.0053,-10.8764],[122.9489,-10.9093]],[[121.883,-10.5903],[121.8331,-10.6021],[121.7262,-10.5731],[121.7047,-10.5557],[121.7963,-10.5074],[121.867,-10.4389],[121.9495,-10.433],[121.9983,-10.447],[121.9813,-10.5284],[121.883,-10.5903]],[[123.4162,-10.3026],[123.326,-10.3375],[123.3256,-10.2642],[123.3953,-10.1714],[123.4588,-10.1399],[123.4939,-10.177],[123.4968,-10.1939],[123.4051,-10.2271],[123.4162,-10.3026]],[[120.0125,-9.3747],[120.0576,-9.4197],[120.2211,-9.5063],[120.248,-9.5429],[120.2583,-9.6031],[120.2911,-9.6479],[120.3647,-9.6547],[120.4437,-9.6456],[120.5037,-9.674],[120.5556,-9.719],[120.6326,-9.8064],[120.7004,-9.9031],[120.7845,-9.957],[120.8326,-10.0375],[120.8042,-10.1085],[120.698,-10.2066],[120.6404,-10.2279],[120.5617,-10.2356],[120.4392,-10.294],[120.3945,-10.2635],[120.2555,-10.2423],[120.1448,-10.2001],[120.052,-10.1229],[119.9984,-10.0397],[119.9307,-9.9665],[119.8128,-9.9175],[119.6011,-9.7735],[119.4703,-9.7605],[119.4165,-9.7711],[119.3626,-9.7718],[119.0854,-9.7069],[119.0424,-9.669],[119.0084,-9.6205],[118.9773,-9.5729],[118.9588,-9.5193],[118.9941,-9.4721],[119.0314,-9.4402],[119.1856,-9.3845],[119.2959,-9.3672],[119.4239,-9.3698],[119.6147,-9.3524],[119.7951,-9.3805],[119.8508,-9.3596],[119.9421,-9.3015],[119.9738,-9.3216],[120.0125,-9.3747]],[[124.9368,-9.0534],[124.9732,-9.0643],[125.1004,-9.004],[125.1244,-9.0154],[125.149,-9.0426],[125.1494,-9.1229],[125.1005,-9.1898],[124.9775,-9.1949],[124.9602,-9.2138],[124.9586,-9.2547],[124.9683,-9.2942],[124.997,-9.326],[125.0336,-9.3818],[125.0682,-9.5119],[124.9979,-9.5653],[124.9631,-9.6656],[124.8418,-9.7598],[124.7084,-9.9142],[124.6019,-9.993],[124.5082,-10.0861],[124.4275,-10.1486],[124.3268,-10.1698],[124.176,-10.1833],[123.9711,-10.2948],[123.8576,-10.3436],[123.7473,-10.3472],[123.6441,-10.3109],[123.6048,-10.2701],[123.6141,-10.215],[123.6482,-10.1678],[123.6901,-10.1288],[123.7164,-10.0786],[123.5994,-10.0151],[123.5893,-9.9668],[123.6357,-9.8381],[123.6658,-9.7053],[123.7094,-9.6148],[123.8768,-9.4531],[123.9771,-9.3729],[124.0363,-9.3416],[124.0524,-9.3754],[124.0901,-9.4164],[124.1155,-9.4231],[124.1346,-9.4139],[124.2823,-9.4279],[124.3193,-9.4138],[124.3757,-9.3499],[124.413,-9.3144],[124.4383,-9.2386],[124.4444,-9.1903],[124.5755,-9.1554],[124.6459,-9.1167],[124.7082,-9.0618],[124.8897,-8.9685],[124.9223,-8.9425],[124.915,-9.0315],[124.9368,-9.0534]],[[115.61,-8.7698],[115.5819,-8.8042],[115.5009,-8.7429],[115.4805,-8.7154],[115.5406,-8.6754],[115.5614,-8.6699],[115.6133,-8.7132],[115.61,-8.7698]],[[122.9773,-8.5452],[122.9455,-8.604],[122.8878,-8.5873],[122.9035,-8.5307],[122.9328,-8.4971],[123.0105,-8.4483],[123.0895,-8.4398],[123.1379,-8.4569],[123.1531,-8.4758],[123.0301,-8.4948],[122.9773,-8.5452]],[[119.4641,-8.741],[119.4249,-8.7505],[119.3855,-8.736],[119.4017,-8.6471],[119.3789,-8.5865],[119.4199,-8.5391],[119.4302,-8.455],[119.4465,-8.4292],[119.4705,-8.4557],[119.4817,-8.4729],[119.5021,-8.4811],[119.547,-8.4826],[119.5572,-8.5188],[119.5555,-8.5534],[119.5363,-8.5894],[119.4828,-8.6282],[119.444,-8.6718],[119.4641,-8.741]],[[123.3175,-8.3548],[123.2973,-8.3986],[123.025,-8.3955],[123.0326,-8.3378],[123.1083,-8.2748],[123.1335,-8.2538],[123.2171,-8.2354],[123.336,-8.269],[123.3175,-8.3548]],[[116.6408,-8.6139],[116.5143,-8.821],[116.5594,-8.8544],[116.5865,-8.8861],[116.3772,-8.929],[116.2898,-8.9062],[116.2394,-8.9121],[116.0268,-8.8731],[115.8746,-8.8256],[115.8573,-8.7879],[115.8693,-8.7428],[115.9145,-8.758],[116.0316,-8.7652],[116.0765,-8.7449],[116.0777,-8.6113],[116.0611,-8.4374],[116.2198,-8.2952],[116.3043,-8.238],[116.4016,-8.2042],[116.647,-8.2827],[116.6875,-8.3041],[116.7189,-8.336],[116.7341,-8.3869],[116.6408,-8.6139]],[[124.2866,-8.3295],[124.2258,-8.3913],[124.1844,-8.4987],[124.1467,-8.5314],[124.0657,-8.5517],[124.0173,-8.4438],[123.9277,-8.4489],[123.9715,-8.3541],[124.0138,-8.3187],[124.0688,-8.3178],[124.0958,-8.3562],[124.1105,-8.3643],[124.2396,-8.2034],[124.2656,-8.2018],[124.2871,-8.2087],[124.3045,-8.2288],[124.2866,-8.3295]],[[123.9248,-8.2725],[123.7839,-8.2996],[123.6979,-8.4244],[123.6292,-8.4225],[123.5916,-8.4779],[123.5826,-8.5017],[123.5879,-8.5238],[123.5802,-8.5449],[123.553,-8.5668],[123.4887,-8.5323],[123.4338,-8.5761],[123.4107,-8.5866],[123.33,-8.5356],[123.2533,-8.5386],[123.2301,-8.5307],[123.325,-8.4391],[123.4546,-8.3537],[123.4759,-8.3223],[123.4252,-8.3134],[123.3949,-8.3006],[123.3912,-8.2805],[123.4732,-8.2671],[123.53,-8.2652],[123.5731,-8.2915],[123.6006,-8.2913],[123.776,-8.1904],[123.8455,-8.2134],[123.8961,-8.2393],[123.9248,-8.2725]],[[138.8951,-8.3887],[138.8455,-8.4018],[138.5942,-8.3715],[138.5672,-8.3303],[138.5634,-8.3091],[138.621,-8.2685],[138.6767,-8.1992],[138.7627,-8.1734],[138.7962,-8.1736],[138.8977,-8.3375],[138.8951,-8.3887]],[[117.5563,-8.3673],[117.5336,-8.368],[117.4904,-8.3487],[117.506,-8.307],[117.4821,-8.2393],[117.4905,-8.1834],[117.5461,-8.152],[117.665,-8.1482],[117.6692,-8.1893],[117.5563,-8.3673]],[[119.0738,-8.2389],[119.03,-8.24],[119.0209,-8.1999],[119.0366,-8.1578],[119.0787,-8.1402],[119.0978,-8.1392],[119.1283,-8.1771],[119.1349,-8.1971],[119.1067,-8.2234],[119.0738,-8.2389]],[[124.5756,-8.1408],[124.5996,-8.2018],[124.6769,-8.1681],[124.7522,-8.1596],[124.9241,-8.166],[125.0503,-8.1796],[125.1246,-8.2048],[125.1317,-8.3265],[125.0968,-8.3528],[124.4442,-8.4446],[124.3807,-8.4151],[124.3556,-8.3859],[124.426,-8.2958],[124.3936,-8.253],[124.4307,-8.1832],[124.5086,-8.1354],[124.5756,-8.1408]],[[127.8234,-8.0988],[127.9984,-8.1391],[128.0988,-8.1349],[128.1192,-8.1707],[128.0235,-8.2554],[127.8209,-8.1902],[127.7862,-8.1203],[127.8234,-8.0988]],[[122.7829,-8.6117],[122.6415,-8.6473],[122.5538,-8.681],[122.4702,-8.7255],[122.4173,-8.7347],[122.3215,-8.7383],[122.1857,-8.7303],[122.0941,-8.7447],[121.8387,-8.8604],[121.7383,-8.8704],[121.6514,-8.8987],[121.6213,-8.8538],[121.5846,-8.8206],[121.4996,-8.8122],[121.4146,-8.8148],[121.3283,-8.9169],[121.1908,-8.8955],[121.1375,-8.9045],[121.0861,-8.926],[121.0353,-8.9354],[120.9818,-8.9283],[120.781,-8.8488],[120.5505,-8.8019],[120.3195,-8.8203],[120.1209,-8.777],[120.0121,-8.8102],[119.9094,-8.8576],[119.8791,-8.8076],[119.8414,-8.7636],[119.8079,-8.6977],[119.807,-8.6229],[119.8182,-8.5705],[119.8477,-8.5229],[119.8661,-8.4731],[119.8748,-8.4198],[119.9183,-8.4451],[119.9638,-8.4355],[120.0992,-8.3775],[120.2312,-8.2898],[120.3541,-8.2578],[120.4249,-8.2489],[120.4855,-8.2661],[120.5472,-8.2599],[120.6103,-8.2404],[120.7096,-8.3078],[120.7514,-8.3215],[120.8861,-8.3267],[121.0087,-8.3655],[121.1182,-8.4235],[121.2767,-8.4779],[121.372,-8.5509],[121.4445,-8.5778],[121.4984,-8.5852],[121.5479,-8.5753],[121.6104,-8.5262],[121.6834,-8.5059],[121.7471,-8.5066],[121.8629,-8.4939],[121.9117,-8.4821],[121.9665,-8.4552],[122.0201,-8.4719],[122.0671,-8.4967],[122.2631,-8.6249],[122.3232,-8.6283],[122.4335,-8.6008],[122.4666,-8.5664],[122.4836,-8.5136],[122.5138,-8.4696],[122.5559,-8.4315],[122.6035,-8.4024],[122.75,-8.3531],[122.8505,-8.3044],[122.9191,-8.2219],[122.7586,-8.1859],[122.7924,-8.1266],[122.8457,-8.0933],[122.917,-8.1056],[122.9783,-8.152],[123.006,-8.3291],[122.9555,-8.3541],[122.9236,-8.381],[122.9021,-8.4163],[122.8111,-8.4812],[122.8468,-8.5622],[122.82,-8.5957],[122.7829,-8.6117]],[[130.8622,-8.3188],[130.7752,-8.3499],[130.8334,-8.2708],[131.0201,-8.0913],[131.0874,-8.1245],[131.1764,-8.1308],[131.0438,-8.212],[130.9081,-8.2457],[130.8622,-8.3188]],[[118.2424,-8.3178],[118.2924,-8.3572],[118.3379,-8.3535],[118.4332,-8.2933],[118.4906,-8.2715],[118.5521,-8.2704],[118.6119,-8.2807],[118.6706,-8.3234],[118.6918,-8.3935],[118.7139,-8.4149],[118.7483,-8.3312],[118.7942,-8.3059],[118.8457,-8.2931],[118.9262,-8.2977],[118.9878,-8.3377],[119.0438,-8.4567],[119.0421,-8.5609],[119.0625,-8.5998],[119.1011,-8.6282],[119.1297,-8.6682],[119.1042,-8.71],[119.0789,-8.7305],[119.0063,-8.7496],[118.9715,-8.7412],[118.9394,-8.7131],[118.9033,-8.7027],[118.8212,-8.7121],[118.7459,-8.7354],[118.7563,-8.7736],[118.8181,-8.7908],[118.8367,-8.8089],[118.8326,-8.8334],[118.8083,-8.8383],[118.7279,-8.8053],[118.6736,-8.8119],[118.4786,-8.8564],[118.427,-8.8555],[118.3979,-8.8134],[118.3999,-8.7037],[118.3789,-8.6746],[118.234,-8.8078],[118.1899,-8.8405],[118.1315,-8.856],[118.0707,-8.8506],[117.8612,-8.9314],[117.7954,-8.9201],[117.7316,-8.9199],[117.5079,-9.0075],[117.3879,-9.0319],[117.3264,-9.0337],[117.265,-9.0262],[117.2103,-9.0341],[117.1612,-9.0692],[117.0613,-9.099],[116.9582,-9.0764],[116.8711,-9.0462],[116.7885,-9.0063],[116.768,-8.9555],[116.7721,-8.8943],[116.8069,-8.8109],[116.7831,-8.6646],[116.8013,-8.5979],[116.8351,-8.5324],[116.8862,-8.5083],[116.9531,-8.5034],[117.0637,-8.4444],[117.1648,-8.3672],[117.2236,-8.3745],[117.3566,-8.4285],[117.4346,-8.435],[117.5671,-8.4264],[117.6218,-8.4596],[117.6434,-8.5355],[117.6729,-8.5633],[117.7121,-8.5826],[117.8061,-8.7111],[117.8932,-8.7044],[117.9695,-8.728],[118.1041,-8.6503],[118.206,-8.6521],[118.2349,-8.5919],[118.174,-8.5275],[118.1005,-8.4752],[118.061,-8.4643],[118.0179,-8.4674],[117.9791,-8.4589],[117.8148,-8.3421],[117.7664,-8.279],[117.7384,-8.2046],[117.7553,-8.1495],[117.8683,-8.1009],[117.921,-8.0891],[118.1175,-8.1223],[118.1507,-8.15],[118.2028,-8.2673],[118.2424,-8.3178]],[[115.4479,-8.1552],[115.5494,-8.2083],[115.6909,-8.3636],[115.7043,-8.4071],[115.6614,-8.4482],[115.56,-8.5142],[115.3338,-8.6157],[115.295,-8.6637],[115.2472,-8.7575],[115.2361,-8.7976],[115.2202,-8.8195],[115.1942,-8.8354],[115.1449,-8.849],[115.0915,-8.8294],[115.1397,-8.7689],[115.1416,-8.6969],[115.1057,-8.6295],[115.0551,-8.573],[114.9521,-8.4964],[114.8421,-8.4285],[114.7313,-8.3939],[114.6132,-8.3783],[114.5709,-8.3454],[114.5018,-8.2608],[114.4789,-8.2147],[114.4676,-8.1663],[114.4753,-8.1194],[114.5043,-8.1166],[114.62,-8.1277],[114.833,-8.1826],[114.9385,-8.1871],[114.9981,-8.1744],[115.154,-8.0657],[115.191,-8.0675],[115.3402,-8.1154],[115.4479,-8.1552]],[[129.8389,-7.9546],[129.7798,-8.0465],[129.7135,-8.0407],[129.5919,-7.9174],[129.5987,-7.8313],[129.609,-7.8034],[129.6555,-7.7948],[129.813,-7.8197],[129.8436,-7.8894],[129.8389,-7.9546]],[[126.801,-7.6679],[126.8145,-7.7165],[126.8127,-7.7379],[126.6929,-7.7535],[126.5773,-7.8076],[126.5182,-7.8699],[126.4721,-7.9504],[126.3129,-7.9177],[126.1711,-7.9123],[126.1084,-7.884],[126.04,-7.8858],[125.9516,-7.9109],[125.8262,-7.9793],[125.7982,-7.9846],[125.8084,-7.8807],[125.8432,-7.8167],[125.9753,-7.6634],[126.0854,-7.6974],[126.2137,-7.7067],[126.3594,-7.6768],[126.4629,-7.6078],[126.6096,-7.5718],[126.7264,-7.6622],[126.801,-7.6679]],[[127.4194,-7.623],[127.3553,-7.6465],[127.375,-7.5725],[127.3707,-7.5128],[127.4752,-7.5311],[127.474,-7.5785],[127.464,-7.5969],[127.4194,-7.623]],[[138.5354,-8.2736],[138.2963,-8.4052],[137.9828,-8.3819],[137.8719,-8.3797],[137.6877,-8.4117],[137.6504,-8.3861],[137.6852,-8.2622],[137.8325,-7.9322],[138.0075,-7.6416],[138.0818,-7.5662],[138.1854,-7.4953],[138.2955,-7.4385],[138.5438,-7.3796],[138.7698,-7.3904],[138.802,-7.4146],[138.8994,-7.5116],[138.9626,-7.588],[138.9891,-7.6961],[138.893,-7.8821],[138.7859,-8.0591],[138.6117,-8.1983],[138.5354,-8.2736]],[[131.3256,-7.9995],[131.3092,-8.0108],[131.185,-7.9979],[131.1138,-7.9974],[131.1234,-7.9219],[131.0868,-7.865],[131.1368,-7.7817],[131.1378,-7.6849],[131.19,-7.6719],[131.1974,-7.6167],[131.2601,-7.4705],[131.2969,-7.4381],[131.3492,-7.4254],[131.411,-7.3401],[131.4462,-7.3153],[131.4826,-7.2507],[131.5353,-7.2206],[131.5309,-7.1651],[131.5607,-7.1357],[131.6435,-7.1128],[131.7008,-7.1402],[131.7361,-7.1971],[131.6438,-7.2669],[131.6911,-7.4389],[131.6244,-7.6262],[131.5803,-7.6822],[131.4984,-7.7307],[131.4735,-7.7767],[131.3771,-7.8691],[131.3478,-7.948],[131.3435,-7.9814],[131.3256,-7.9995]],[[131.982,-7.2021],[131.9695,-7.2514],[131.9269,-7.225],[131.8845,-7.1675],[131.8229,-7.1592],[131.7775,-7.1439],[131.7508,-7.1168],[131.9223,-7.1045],[131.982,-7.2021]],[[114.4126,-7.1335],[114.3977,-7.1731],[114.3469,-7.1633],[114.2988,-7.0976],[114.3222,-7.0804],[114.3489,-7.0734],[114.3836,-7.0807],[114.4126,-7.1335]],[[128.6701,-7.1833],[128.625,-7.2086],[128.5502,-7.1563],[128.5298,-7.1346],[128.5773,-7.0832],[128.6277,-7.0687],[128.6583,-7.0911],[128.6732,-7.1134],[128.6669,-7.138],[128.6701,-7.1833]],[[120.7744,-7.1189],[120.6724,-7.1247],[120.6408,-7.1158],[120.6334,-7.0183],[120.7455,-7.0602],[120.7817,-7.0631],[120.7744,-7.1189]],[[113.8445,-7.1054],[113.8256,-7.1199],[113.6559,-7.1117],[113.5464,-7.1934],[113.4707,-7.2185],[113.1984,-7.2184],[113.166,-7.2073],[113.1419,-7.2076],[113.127,-7.2241],[113.0404,-7.2118],[112.7638,-7.1396],[112.7259,-7.0728],[112.7688,-7.0013],[112.8681,-6.8999],[113.0674,-6.88],[113.9747,-6.873],[114.0736,-6.9602],[114.083,-6.9894],[113.8854,-7.049],[113.8445,-7.1054]],[[115.3771,-6.9708],[115.2958,-6.9878],[115.2203,-6.9525],[115.2222,-6.9052],[115.2405,-6.8612],[115.3537,-6.8385],[115.4145,-6.8397],[115.4792,-6.8702],[115.5242,-6.9019],[115.5461,-6.9387],[115.4241,-6.9406],[115.3771,-6.9708]],[[134.6744,-6.7498],[134.6574,-6.7653],[134.6314,-6.7329],[134.6291,-6.7128],[134.6635,-6.6577],[134.6977,-6.6257],[134.7357,-6.6233],[134.7261,-6.6687],[134.6744,-6.7498]],[[105.2528,-6.6404],[105.1904,-6.6625],[105.1428,-6.6431],[105.1214,-6.6149],[105.1923,-6.5456],[105.2257,-6.5291],[105.2605,-6.5239],[105.2774,-6.5614],[105.2528,-6.6404]],[[134.7161,-6.5494],[134.6608,-6.5589],[134.6337,-6.4772],[134.6791,-6.4561],[134.7285,-6.5059],[134.7161,-6.5494]],[[134.8195,-6.4342],[134.7951,-6.4424],[134.7953,-6.3931],[134.8229,-6.3496],[134.8519,-6.3246],[134.8858,-6.3235],[134.8195,-6.4342]],[[134.5368,-6.4423],[134.5204,-6.5127],[134.5043,-6.5914],[134.4125,-6.6797],[134.356,-6.8148],[134.3228,-6.8487],[134.2,-6.9088],[134.0908,-6.8338],[134.0592,-6.7693],[134.107,-6.4716],[134.1542,-6.4814],[134.1848,-6.4793],[134.1946,-6.4598],[134.1246,-6.4265],[134.1112,-6.2554],[134.1146,-6.1908],[134.1681,-6.1763],[134.2342,-6.2264],[134.3178,-6.3161],[134.415,-6.3867],[134.5368,-6.4423]],[[107.3739,-6.0076],[107.4747,-6.1218],[107.563,-6.1827],[107.6668,-6.2158],[107.7761,-6.2189],[107.8838,-6.2333],[108.0088,-6.277],[108.1376,-6.2967],[108.1975,-6.2891],[108.2545,-6.2666],[108.295,-6.265],[108.3302,-6.286],[108.4191,-6.3828],[108.5159,-6.4712],[108.538,-6.5162],[108.6036,-6.7292],[108.6778,-6.7905],[108.7797,-6.8083],[108.8994,-6.8084],[109.0184,-6.8173],[109.2942,-6.867],[109.4037,-6.8602],[109.5006,-6.8102],[109.5869,-6.8426],[109.821,-6.9024],[109.9362,-6.9158],[110.0671,-6.8987],[110.1984,-6.8951],[110.2609,-6.9124],[110.3211,-6.9384],[110.3728,-6.9478],[110.4263,-6.9473],[110.5209,-6.8973],[110.5836,-6.8057],[110.6343,-6.6901],[110.674,-6.5698],[110.7008,-6.5181],[110.7369,-6.4724],[110.7842,-6.4427],[110.8348,-6.4242],[110.9723,-6.4356],[111.0007,-6.4647],[111.1544,-6.669],[111.1815,-6.6867],[111.3421,-6.6995],[111.3865,-6.6929],[111.4845,-6.6519],[111.5403,-6.6482],[111.6436,-6.6987],[111.6881,-6.7417],[111.7376,-6.7734],[111.9898,-6.806],[112.0873,-6.8934],[112.1367,-6.9051],[112.3123,-6.8944],[112.4336,-6.903],[112.5393,-6.9265],[112.5869,-7.0506],[112.626,-7.178],[112.6487,-7.2213],[112.752,-7.265],[112.7943,-7.3045],[112.7829,-7.4316],[112.7945,-7.5524],[113.0136,-7.6577],[113.2484,-7.7182],[113.4977,-7.7238],[113.7475,-7.703],[113.8763,-7.6772],[114.0373,-7.6321],[114.0707,-7.633],[114.3827,-7.7711],[114.4093,-7.7925],[114.4442,-7.8956],[114.4433,-8.0046],[114.385,-8.2633],[114.3813,-8.3343],[114.3869,-8.4052],[114.4488,-8.5593],[114.4817,-8.6038],[114.595,-8.6848],[114.5992,-8.7272],[114.5838,-8.7696],[114.4592,-8.7405],[114.3832,-8.7054],[114.3393,-8.6474],[114.277,-8.6146],[114.1597,-8.6265],[113.9403,-8.5684],[113.6926,-8.478],[113.2533,-8.2867],[113.1337,-8.2883],[113.0189,-8.3127],[112.8978,-8.3614],[112.7717,-8.3961],[112.6788,-8.4092],[112.586,-8.3996],[112.3516,-8.3536],[112.1151,-8.3239],[111.51,-8.3051],[111.3386,-8.2617],[111.0554,-8.2396],[110.8302,-8.202],[110.6072,-8.1494],[110.0387,-7.8905],[109.8526,-7.8284],[109.2816,-7.7049],[109.1936,-7.6949],[108.9867,-7.7041],[108.8563,-7.6679],[108.7412,-7.6671],[108.5705,-7.7072],[108.518,-7.736],[108.4518,-7.797],[108.3355,-7.794],[108.2205,-7.7823],[107.9175,-7.7241],[107.8044,-7.6884],[107.6958,-7.6355],[107.5979,-7.5667],[107.5469,-7.5419],[107.285,-7.4717],[107.0712,-7.4475],[106.6314,-7.4155],[106.5354,-7.3942],[106.4553,-7.3687],[106.4113,-7.3117],[106.4169,-7.2394],[106.4484,-7.1768],[106.4915,-7.1139],[106.5197,-7.0537],[106.1982,-6.9278],[105.9443,-6.859],[105.8348,-6.8458],[105.7248,-6.8461],[105.601,-6.8604],[105.4784,-6.8537],[105.4208,-6.8332],[105.3619,-6.8262],[105.3029,-6.841],[105.2555,-6.8353],[105.2432,-6.778],[105.2734,-6.7294],[105.3356,-6.6741],[105.3709,-6.6644],[105.387,-6.7508],[105.4047,-6.768],[105.4598,-6.7869],[105.4837,-6.7815],[105.5809,-6.671],[105.608,-6.6167],[105.6551,-6.4695],[105.7061,-6.4979],[105.7574,-6.4804],[105.7869,-6.4569],[105.8683,-6.1164],[105.9361,-6.017],[106.0288,-5.9343],[106.075,-5.9142],[106.1658,-5.9647],[106.3497,-5.9841],[106.4591,-6.0176],[106.5688,-6.0219],[106.6759,-6.0384],[106.8252,-6.0982],[106.8779,-6.092],[106.9316,-6.0734],[107.0116,-6.0085],[107.0463,-5.9042],[107.1621,-5.9571],[107.3318,-5.9781],[107.3739,-6.0076]],[[124.0513,-5.9737],[124.0421,-6.0216],[124.0057,-5.9667],[123.9723,-5.9394],[123.9758,-5.8802],[124.0229,-5.9021],[124.0513,-5.9737]],[[120.5283,-6.2984],[120.4873,-6.4648],[120.468,-6.4062],[120.4607,-6.254],[120.4355,-6.1802],[120.4516,-6.0949],[120.4465,-5.8763],[120.4773,-5.7753],[120.5342,-5.9038],[120.5492,-5.9692],[120.5283,-6.2984]],[[112.7194,-5.811],[112.6979,-5.8465],[112.6021,-5.8437],[112.586,-5.8036],[112.6485,-5.7309],[112.69,-5.7262],[112.7273,-5.7527],[112.7194,-5.811]],[[132.8071,-5.8508],[132.7463,-5.9471],[132.7049,-5.9131],[132.6814,-5.9126],[132.6673,-5.8561],[132.6813,-5.7389],[132.6302,-5.607],[132.6979,-5.609],[132.7165,-5.6483],[132.7378,-5.6617],[132.8043,-5.7889],[132.8071,-5.8508]],[[134.747,-5.707],[134.7391,-5.7456],[134.7384,-5.8168],[134.755,-5.8827],[134.7122,-5.9497],[134.7521,-6.0501],[134.7581,-6.1],[134.7559,-6.1706],[134.7444,-6.2023],[134.7142,-6.2951],[134.6839,-6.3281],[134.6611,-6.3373],[134.6376,-6.3653],[134.4411,-6.3349],[134.3562,-6.2705],[134.2805,-6.2008],[134.2645,-6.1717],[134.1754,-6.0903],[134.1549,-6.0629],[134.1531,-6.0195],[134.2251,-6.0085],[134.302,-6.0098],[134.2986,-5.9707],[134.3431,-5.833],[134.2262,-5.7444],[134.2054,-5.7072],[134.2473,-5.6819],[134.3413,-5.7129],[134.4563,-5.5575],[134.4903,-5.5251],[134.5064,-5.4385],[134.5708,-5.4273],[134.6165,-5.4386],[134.6461,-5.4924],[134.6578,-5.5393],[134.6455,-5.5813],[134.7008,-5.603],[134.747,-5.707]],[[132.9263,-5.9021],[132.845,-5.988],[132.9217,-5.7853],[132.9377,-5.6826],[133.0088,-5.6214],[133.1146,-5.3106],[133.1385,-5.3179],[133.1729,-5.3481],[133.1196,-5.576],[132.9711,-5.7358],[132.9263,-5.9021]],[[102.3672,-5.4787],[102.2859,-5.4835],[102.1355,-5.3605],[102.1107,-5.3226],[102.1535,-5.2862],[102.1984,-5.2889],[102.3718,-5.3664],[102.4055,-5.4048],[102.3672,-5.4787]],[[123.6268,-5.2716],[123.6228,-5.373],[123.5826,-5.3674],[123.5501,-5.3318],[123.5409,-5.2983],[123.5428,-5.2711],[123.5606,-5.2498],[123.6268,-5.2716]],[[122.043,-5.438],[121.9796,-5.4647],[121.8594,-5.3503],[121.8085,-5.2562],[121.8207,-5.2029],[121.8566,-5.1563],[121.8737,-5.1446],[121.8663,-5.096],[121.9137,-5.0723],[121.9657,-5.0756],[121.9999,-5.1408],[122.041,-5.1588],[122.0618,-5.2213],[122.043,-5.438]],[[122.6451,-5.2694],[122.6193,-5.3358],[122.5639,-5.3875],[122.5197,-5.3912],[122.4736,-5.3807],[122.392,-5.3354],[122.3713,-5.3831],[122.307,-5.381],[122.2831,-5.3195],[122.329,-5.1377],[122.3963,-5.0698],[122.39,-4.9985],[122.3345,-4.8466],[122.3689,-4.7672],[122.5244,-4.7071],[122.66,-4.6339],[122.702,-4.6187],[122.7397,-4.675],[122.7599,-4.9339],[122.6141,-5.1387],[122.6451,-5.2694]],[[123.1798,-4.5512],[123.203,-4.7662],[123.1957,-4.8227],[123.1395,-4.7399],[123.1192,-4.7234],[123.1038,-4.7399],[123.0839,-4.749],[123.0552,-4.7482],[123.018,-4.8317],[123.0146,-4.9103],[122.9865,-4.9631],[122.9717,-5.1385],[122.9811,-5.1857],[123.0246,-5.1624],[123.0515,-5.1564],[123.1499,-5.224],[123.202,-5.2733],[123.1873,-5.333],[123.1207,-5.3932],[123.0434,-5.4193],[122.9857,-5.3936],[122.9688,-5.4058],[122.9347,-5.4367],[122.9088,-5.4774],[122.9162,-5.5193],[122.8502,-5.638],[122.8121,-5.6713],[122.7331,-5.635],[122.6844,-5.6662],[122.645,-5.6634],[122.585,-5.5446],[122.5864,-5.4889],[122.6422,-5.4263],[122.6426,-5.3812],[122.6701,-5.3309],[122.7314,-5.2619],[122.7665,-5.2102],[122.7676,-5.1772],[122.7937,-5.0524],[122.8038,-5.0001],[122.8215,-4.9444],[122.8494,-4.8312],[122.8533,-4.6184],[122.9469,-4.4427],[123.0383,-4.3947],[123.0746,-4.3869],[123.0689,-4.4336],[123.1798,-4.5512]],[[133.5708,-4.2459],[133.6219,-4.2993],[133.5029,-4.2574],[133.333,-4.1696],[133.3209,-4.111],[133.4644,-4.1998],[133.5708,-4.2459]],[[123.2424,-4.113],[123.1445,-4.2333],[123.0762,-4.2271],[122.9947,-4.148],[122.9709,-4.0613],[122.969,-4.03],[123.0249,-3.981],[123.2119,-3.9976],[123.247,-4.0409],[123.2424,-4.113]],[[128.5626,-3.5854],[128.3916,-3.6379],[128.4283,-3.5404],[128.4516,-3.5147],[128.5363,-3.5413],[128.5626,-3.5854]],[[128.2756,-3.6746],[128.2499,-3.7111],[128.1918,-3.7353],[128.1432,-3.7327],[128.159,-3.6977],[128.1469,-3.6771],[128.1108,-3.6864],[128.0522,-3.7146],[127.978,-3.771],[127.9344,-3.7431],[127.925,-3.6993],[127.9275,-3.6794],[128.0162,-3.6009],[128.1191,-3.5875],[128.2644,-3.5123],[128.3291,-3.5159],[128.3137,-3.5637],[128.291,-3.5977],[128.2774,-3.6332],[128.2756,-3.6746]],[[128.7225,-3.5469],[128.7201,-3.5892],[128.7133,-3.6025],[128.6588,-3.5878],[128.6195,-3.5886],[128.5852,-3.5122],[128.5949,-3.4948],[128.6665,-3.5167],[128.6936,-3.5245],[128.7225,-3.5469]],[[116.4241,-3.4645],[116.3878,-3.6367],[116.3266,-3.5391],[116.3953,-3.4233],[116.427,-3.3999],[116.4241,-3.4645]],[[127.6063,-3.3151],[127.6293,-3.3592],[127.5311,-3.3313],[127.4877,-3.2882],[127.5305,-3.2615],[127.5545,-3.2543],[127.6063,-3.3151]],[[116.3033,-3.8682],[116.0934,-4.0541],[116.0588,-4.0069],[116.077,-3.8175],[116.0184,-3.6999],[116.0225,-3.6124],[116.0636,-3.4579],[116.1174,-3.3396],[116.2394,-3.2604],[116.2697,-3.2511],[116.2621,-3.3948],[116.2865,-3.4488],[116.2951,-3.495],[116.282,-3.5348],[116.3052,-3.7186],[116.3187,-3.763],[116.2893,-3.8209],[116.3033,-3.8682]],[[126.8611,-3.0879],[127.0255,-3.166],[127.0629,-3.217],[127.0924,-3.2775],[127.1247,-3.3108],[127.1635,-3.3381],[127.2273,-3.391],[127.2442,-3.4711],[127.2296,-3.633],[127.1552,-3.6473],[127.0851,-3.6709],[126.9409,-3.7646],[126.8699,-3.7829],[126.7941,-3.7892],[126.7403,-3.8137],[126.6863,-3.8236],[126.5467,-3.7717],[126.4111,-3.7106],[126.2146,-3.6052],[126.1783,-3.5794],[126.1467,-3.5228],[126.0565,-3.421],[126.034,-3.3559],[126.0265,-3.1705],[126.0501,-3.1281],[126.0883,-3.1055],[126.2196,-3.1481],[126.3063,-3.1032],[126.5551,-3.0652],[126.8083,-3.0691],[126.8611,-3.0879]],[[127.9879,-2.9365],[127.9377,-3.02],[127.8496,-3.0163],[127.8343,-3.0044],[127.9384,-2.9523],[127.9879,-2.9365]],[[106.8864,-3.0053],[106.8697,-3.0253],[106.8143,-3.0145],[106.7743,-2.9868],[106.7492,-2.9604],[106.7429,-2.9328],[106.7969,-2.8989],[106.9106,-2.934],[106.8864,-3.0053]],[[107.4733,-2.8995],[107.4328,-2.9253],[107.4093,-2.9006],[107.4024,-2.8729],[107.4193,-2.8381],[107.4744,-2.8347],[107.4997,-2.845],[107.4733,-2.8995]],[[129.7547,-2.8658],[129.9844,-2.9767],[130.1034,-2.993],[130.3036,-2.9785],[130.3791,-2.9894],[130.5699,-3.1309],[130.6256,-3.228],[130.6417,-3.3119],[130.6711,-3.3915],[130.7181,-3.4113],[130.7734,-3.4187],[130.8456,-3.5333],[130.86,-3.5703],[130.8051,-3.8577],[130.5804,-3.7488],[130.3631,-3.6252],[130.2697,-3.5793],[130.0195,-3.4747],[129.9812,-3.4389],[129.9531,-3.3916],[129.8441,-3.3271],[129.6267,-3.3172],[129.545,-3.3188],[129.5117,-3.3285],[129.5204,-3.3632],[129.5217,-3.4337],[129.4677,-3.4532],[129.3328,-3.4087],[129.2121,-3.3927],[129.1076,-3.3492],[128.9675,-3.3261],[128.9521,-3.3042],[128.9641,-3.2717],[128.9578,-3.2411],[128.9254,-3.2293],[128.8625,-3.235],[128.8018,-3.2656],[128.7513,-3.3005],[128.677,-3.3966],[128.639,-3.4334],[128.5166,-3.4491],[128.4659,-3.4398],[128.4192,-3.416],[128.28,-3.2405],[128.233,-3.2026],[128.1807,-3.1717],[128.132,-3.1574],[128.0821,-3.1841],[128.0558,-3.2386],[128.0439,-3.3033],[128.0301,-3.3405],[127.97,-3.4443],[127.9204,-3.5061],[127.9023,-3.4963],[127.9278,-3.3973],[127.9279,-3.3414],[127.8972,-3.2823],[127.8779,-3.2221],[128.1134,-2.9346],[128.1985,-2.8659],[128.5698,-2.8422],[128.7905,-2.8566],[128.9107,-2.8496],[128.9911,-2.8285],[129.0577,-2.8385],[129.0743,-2.8951],[129.1163,-2.937],[129.1744,-2.9335],[129.2796,-2.8891],[129.3711,-2.8205],[129.4273,-2.7907],[129.4842,-2.7857],[129.543,-2.7903],[129.6005,-2.8062],[129.7547,-2.8658]],[[100.4251,-3.1829],[100.4651,-3.3285],[100.3461,-3.2292],[100.3484,-3.1588],[100.332,-3.1131],[100.26,-3.0569],[100.2043,-2.9868],[100.1793,-2.8202],[100.1985,-2.7855],[100.2456,-2.7832],[100.4546,-3.002],[100.4688,-3.039],[100.4643,-3.1169],[100.4339,-3.1413],[100.4251,-3.1829]],[[108.2072,-2.9977],[108.1918,-3.103],[108.1673,-3.1428],[108.0836,-3.1949],[108.0553,-3.2269],[107.9771,-3.2218],[107.9673,-3.1666],[107.9411,-3.1293],[107.8582,-3.0863],[107.8366,-3.0967],[107.8218,-3.1607],[107.6596,-3.2056],[107.6145,-3.2094],[107.6367,-3.1248],[107.5949,-3.0584],[107.5916,-2.9766],[107.5839,-2.9407],[107.5635,-2.9201],[107.6049,-2.8631],[107.5981,-2.7997],[107.6416,-2.7315],[107.6663,-2.5663],[107.8378,-2.5303],[107.8747,-2.5597],[108.0744,-2.597],[108.2151,-2.697],[108.2906,-2.83],[108.2072,-2.9977]],[[100.2041,-2.741],[100.1327,-2.8214],[100.0149,-2.8197],[99.9919,-2.7698],[99.9969,-2.6493],[99.9682,-2.6098],[99.9693,-2.5941],[99.9879,-2.5254],[100.0119,-2.5103],[100.202,-2.6797],[100.2041,-2.741]],[[134.3742,-2.1235],[134.3452,-2.1388],[134.3351,-2.0952],[134.3508,-2.0369],[134.3695,-2.0276],[134.391,-2.0308],[134.419,-2.0518],[134.3742,-2.1235]],[[99.8431,-2.3431],[99.8479,-2.3697],[99.6852,-2.2817],[99.607,-2.2575],[99.5374,-2.1615],[99.5589,-2.1154],[99.5618,-2.0512],[99.5722,-2.0258],[99.6221,-2.0166],[99.6864,-2.0634],[99.7348,-2.1777],[99.8157,-2.2844],[99.8431,-2.3431]],[[126.0551,-2.4513],[126.0379,-2.4694],[125.9779,-2.4154],[125.9376,-2.2628],[125.9032,-2.2222],[125.8629,-2.0771],[125.8732,-2.0359],[125.9228,-1.9748],[125.9628,-1.9758],[125.9927,-2.0118],[125.976,-2.1681],[126.0657,-2.3658],[126.0551,-2.4513]],[[123.8482,-1.9555],[123.866,-1.9957],[123.8035,-1.9943],[123.7772,-1.9187],[123.7835,-1.8783],[123.8482,-1.9555]],[[126.0242,-1.7897],[126.3317,-1.8229],[126.2881,-1.8589],[125.9564,-1.9166],[125.8389,-1.9062],[125.4792,-1.94],[125.4326,-1.9381],[125.426,-1.8822],[125.3872,-1.8431],[125.4447,-1.809],[125.5209,-1.8009],[125.7203,-1.8138],[126.0242,-1.7897]],[[123.1525,-1.8165],[123.0788,-1.8989],[123.0709,-1.8549],[123.0858,-1.8148],[123.1064,-1.7867],[123.1375,-1.7727],[123.1525,-1.8165]],[[130.3533,-1.6905],[130.3654,-1.7498],[130.425,-1.8046],[130.4043,-1.8898],[130.3806,-1.9026],[130.3934,-1.9416],[130.4188,-1.9713],[130.3727,-1.9919],[130.339,-1.9818],[130.2842,-2.0094],[130.248,-2.0478],[130.1335,-2.0639],[130.0934,-2.0283],[129.8865,-1.9864],[129.7544,-1.8944],[129.7377,-1.8669],[129.9937,-1.7589],[130.1058,-1.7305],[130.1996,-1.7322],[130.318,-1.692],[130.3533,-1.6905]],[[124.9695,-1.7055],[125.063,-1.741],[125.0959,-1.7408],[125.1268,-1.6993],[125.1458,-1.6926],[125.1879,-1.7129],[125.1977,-1.7803],[125.2582,-1.7709],[125.3054,-1.7939],[125.3202,-1.8101],[125.3141,-1.8771],[125.1348,-1.889],[125.0067,-1.9431],[124.8345,-1.8944],[124.6392,-1.9782],[124.5206,-2.0069],[124.4178,-2.0052],[124.3297,-1.8589],[124.3809,-1.6875],[124.4176,-1.6593],[124.483,-1.6443],[124.664,-1.6359],[124.9695,-1.7055]],[[135.4742,-1.5918],[135.8691,-1.642],[135.9762,-1.6355],[136.2016,-1.655],[136.3896,-1.7216],[136.7186,-1.734],[136.8167,-1.7538],[136.8926,-1.7997],[136.7086,-1.8377],[136.6219,-1.873],[136.4608,-1.8904],[136.3261,-1.8725],[136.2281,-1.8937],[136.1926,-1.8592],[136.0492,-1.8241],[135.8657,-1.7521],[135.4876,-1.6684],[135.4697,-1.6162],[135.4742,-1.5918]],[[108.9531,-1.6196],[108.8379,-1.6616],[108.8037,-1.5678],[108.8772,-1.5398],[108.9568,-1.5641],[108.9531,-1.6196]],[[106.0457,-1.6694],[106.0801,-1.7383],[106.1271,-1.8002],[106.1617,-1.867],[106.2088,-2.1887],[106.3659,-2.4648],[106.8185,-2.5733],[106.7443,-2.618],[106.7066,-2.658],[106.6788,-2.704],[106.612,-2.8955],[106.6186,-2.9361],[106.6576,-3.0012],[106.6672,-3.0718],[106.6105,-3.0714],[106.5468,-3.0556],[106.4961,-3.029],[106.4487,-2.9942],[106.3974,-2.9666],[106.3416,-2.9487],[106.2501,-2.894],[106.1259,-2.8554],[105.9987,-2.8249],[105.9372,-2.7436],[105.908,-2.6433],[105.9391,-2.4935],[105.9076,-2.452],[105.8624,-2.4154],[105.8068,-2.3074],[105.7858,-2.1813],[105.7053,-2.1326],[105.599,-2.1031],[105.5527,-2.079],[105.3429,-2.1251],[105.2926,-2.1143],[105.2477,-2.0794],[105.1334,-2.0426],[105.1377,-1.9727],[105.191,-1.9169],[105.3162,-1.8605],[105.3748,-1.8132],[105.3865,-1.7508],[105.3643,-1.7051],[105.3731,-1.6573],[105.4127,-1.611],[105.4596,-1.5747],[105.5854,-1.5268],[105.6404,-1.6104],[105.6676,-1.6804],[105.7009,-1.7311],[105.7545,-1.6587],[105.7204,-1.5339],[105.8161,-1.5061],[105.9101,-1.505],[105.981,-1.5392],[106.0273,-1.5932],[106.0457,-1.6694]],[[123.5976,-1.7043],[123.5286,-1.7108],[123.4825,-1.6814],[123.4866,-1.5349],[123.5285,-1.5028],[123.5485,-1.5082],[123.5613,-1.5519],[123.582,-1.5909],[123.6164,-1.6274],[123.5976,-1.7043]],[[128.153,-1.6605],[128.0918,-1.7012],[128.0612,-1.7124],[127.9138,-1.6852],[127.741,-1.6908],[127.5616,-1.7285],[127.4576,-1.6967],[127.3922,-1.6448],[127.395,-1.5898],[127.4567,-1.4537],[127.5918,-1.3508],[127.6467,-1.3324],[127.743,-1.3603],[127.9051,-1.4391],[128.0328,-1.5316],[128.1487,-1.6037],[128.153,-1.6605]],[[123.2123,-1.1713],[123.2343,-1.2337],[123.198,-1.2877],[123.2378,-1.3894],[123.3386,-1.254],[123.4348,-1.2368],[123.4894,-1.2593],[123.5269,-1.286],[123.5473,-1.3374],[123.5119,-1.4474],[123.4487,-1.4988],[123.367,-1.5071],[123.3286,-1.4431],[123.2749,-1.4372],[123.2374,-1.577],[123.2205,-1.5983],[123.1729,-1.616],[123.1304,-1.5774],[123.1229,-1.5561],[123.1829,-1.4928],[123.1504,-1.3045],[123.1052,-1.3398],[122.9844,-1.5106],[122.8904,-1.5872],[122.8585,-1.5482],[122.8108,-1.4321],[122.8322,-1.283],[122.908,-1.1822],[122.9725,-1.1892],[123.1583,-1.1575],[123.2123,-1.1713]],[[109.7103,-1.1807],[109.5108,-1.2828],[109.4637,-1.2775],[109.4281,-1.2412],[109.4503,-1.0441],[109.476,-0.9854],[109.6146,-0.9791],[109.6995,-1.0073],[109.7434,-1.0394],[109.7605,-1.1052],[109.7508,-1.145],[109.7103,-1.1807]],[[134.9653,-1.116],[134.9174,-1.1343],[134.8617,-1.1142],[134.8089,-1.0376],[134.8279,-0.9788],[134.8893,-0.9385],[134.9408,-0.9789],[134.9567,-1.0306],[134.9963,-1.0341],[134.9653,-1.116]],[[99.1639,-1.7779],[99.0718,-1.7835],[98.8743,-1.6637],[98.8277,-1.61],[98.8163,-1.5383],[98.627,-1.2613],[98.6018,-1.1979],[98.6761,-0.9705],[98.869,-0.9156],[98.9326,-0.954],[98.9548,-1.0562],[99.065,-1.2407],[99.1015,-1.3401],[99.1289,-1.3842],[99.1404,-1.4185],[99.1307,-1.4424],[99.2104,-1.5593],[99.2673,-1.6277],[99.2715,-1.7385],[99.1639,-1.7779]],[[131.0019,-1.3155],[130.9666,-1.3435],[130.8451,-1.3173],[130.7823,-1.2555],[130.7394,-1.1726],[130.7121,-1.1044],[130.7044,-1.0502],[130.668,-0.984],[130.6729,-0.9598],[130.8972,-0.89],[130.9395,-0.9153],[131.033,-0.9176],[131.0739,-0.9683],[131.0462,-1.1882],[131.0019,-1.3155]],[[130.9053,-0.7774],[130.8798,-0.8284],[130.8324,-0.8629],[130.4024,-0.9239],[130.4391,-0.8874],[130.4573,-0.8512],[130.4843,-0.8325],[130.527,-0.8373],[130.5481,-0.8263],[130.5695,-0.8219],[130.5938,-0.8267],[130.6354,-0.8116],[130.7232,-0.8225],[130.8135,-0.8139],[130.807,-0.765],[130.9053,-0.7774]],[[135.383,-0.6514],[135.5957,-0.6904],[135.6732,-0.6883],[135.749,-0.7325],[135.8412,-0.7116],[135.8936,-0.7258],[136.0688,-0.8777],[136.1547,-0.9783],[136.2826,-1.0646],[136.3753,-1.094],[136.3054,-1.1731],[136.1647,-1.2147],[136.1104,-1.2168],[136.0025,-1.1697],[135.915,-1.1784],[135.8388,-1.1194],[135.8256,-1.0283],[135.7471,-0.823],[135.6457,-0.8819],[135.5238,-0.7873],[135.4911,-0.7851],[135.4834,-0.8011],[135.4316,-0.7688],[135.3877,-0.7049],[135.383,-0.6514]],[[127.3004,-0.781],[127.2891,-0.8016],[127.1846,-0.7753],[127.1564,-0.7609],[127.2091,-0.6193],[127.2582,-0.6234],[127.3013,-0.7584],[127.3004,-0.781]],[[130.6267,-0.5287],[130.5691,-0.53],[130.4654,-0.4865],[130.5259,-0.4487],[130.5642,-0.4409],[130.5975,-0.4183],[130.6159,-0.4173],[130.6569,-0.4365],[130.6843,-0.4691],[130.6267,-0.5287]],[[121.8644,-0.4068],[121.9068,-0.4513],[121.8813,-0.5026],[121.8469,-0.4898],[121.7561,-0.4908],[121.7218,-0.4947],[121.681,-0.525],[121.6553,-0.5262],[121.6724,-0.4788],[121.7493,-0.407],[121.7974,-0.4177],[121.8644,-0.4068]],[[133.4727,-0.7262],[133.7236,-0.7414],[133.8503,-0.7314],[133.9745,-0.7443],[134.0249,-0.7697],[134.1115,-0.8468],[134.0867,-0.8974],[134.072,-1.0019],[134.1162,-1.1024],[134.1883,-1.2031],[134.2472,-1.3105],[134.2596,-1.363],[134.2372,-1.4741],[134.217,-1.5291],[134.1454,-1.6208],[134.1059,-1.721],[134.1313,-1.8445],[134.1454,-1.9687],[134.1428,-2.0829],[134.1557,-2.1952],[134.1948,-2.3091],[134.3621,-2.621],[134.46,-2.8323],[134.4912,-2.7143],[134.4833,-2.583],[134.518,-2.5356],[134.5669,-2.5104],[134.6274,-2.5367],[134.6447,-2.5898],[134.649,-2.7059],[134.7021,-2.9336],[134.7698,-2.944],[134.8434,-2.9092],[134.8554,-2.9788],[134.8527,-3.1076],[134.8868,-3.2099],[134.9172,-3.2499],[135.0374,-3.3331],[135.0922,-3.3485],[135.2516,-3.3686],[135.3716,-3.3749],[135.4866,-3.3451],[135.5607,-3.2687],[135.6277,-3.186],[135.8592,-2.9953],[135.9262,-2.9041],[135.9907,-2.7643],[136.013,-2.7343],[136.2433,-2.5831],[136.2695,-2.5295],[136.3025,-2.4257],[136.3524,-2.3252],[136.3899,-2.2733],[136.6123,-2.2243],[136.8433,-2.1977],[137.0721,-2.1051],[137.1711,-2.0255],[137.1758,-1.9731],[137.1255,-1.8813],[137.1234,-1.8409],[137.1765,-1.8021],[137.3806,-1.6856],[137.6166,-1.5658],[137.8063,-1.4832],[137.9111,-1.4838],[138.0078,-1.5565],[138.1109,-1.6159],[138.6498,-1.7911],[138.7361,-1.8455],[138.8114,-1.9178],[138.9191,-1.9679],[139.0395,-1.9921],[139.1488,-2.0389],[139.2526,-2.0992],[139.4818,-2.2118],[139.7896,-2.3482],[139.8684,-2.3564],[140.1546,-2.35],[140.204,-2.3757],[140.251,-2.412],[140.2946,-2.4204],[140.6226,-2.4458],[140.673,-2.4721],[140.7205,-2.5081],[140.7475,-2.6071],[140.9734,-2.6098],[140.9735,-2.8034],[140.9736,-3.0066],[140.9737,-3.21],[140.9738,-3.4133],[140.9739,-3.6166],[140.974,-3.8198],[140.974,-4.0231],[140.9742,-4.2265],[140.9742,-4.4298],[140.9743,-4.633],[140.9744,-4.8363],[140.9745,-5.0396],[140.9746,-5.243],[140.9746,-5.4462],[140.9747,-5.6495],[140.9748,-5.8528],[140.9749,-6.0562],[140.975,-6.2594],[140.975,-6.3461],[140.944,-6.4522],[140.8746,-6.6115],[140.8623,-6.74],[140.9195,-6.84],[140.9752,-6.9054],[140.9752,-7.0726],[140.9753,-7.2759],[140.9754,-7.4792],[140.9755,-7.6825],[140.9756,-7.8857],[140.9756,-8.0891],[140.9757,-8.2924],[140.9758,-8.4957],[140.9759,-8.6989],[140.976,-8.9022],[140.976,-9.1056],[140.9762,-9.1188],[140.9246,-9.0851],[140.7865,-8.9737],[140.6615,-8.8468],[140.5811,-8.7283],[140.4897,-8.6204],[140.1017,-8.3006],[140.0029,-8.1955],[139.9833,-8.1665],[139.9926,-8.1394],[140.0374,-8.084],[140.117,-7.9237],[140.0338,-8.0228],[139.9348,-8.1012],[139.7908,-8.1063],[139.6494,-8.1254],[139.5186,-8.1728],[139.3856,-8.1891],[139.3191,-8.1658],[139.2791,-8.1069],[139.2583,-8.0466],[139.2488,-7.9824],[139.193,-8.0861],[139.0832,-8.1429],[138.9335,-8.2624],[138.8906,-8.2378],[138.8647,-8.1923],[138.8562,-8.1451],[138.8851,-8.0947],[138.9055,-8.0412],[138.9359,-7.9131],[139.003,-7.8376],[139.0457,-7.6914],[139.0736,-7.6393],[139.088,-7.5872],[139.0489,-7.5283],[138.983,-7.5082],[138.9379,-7.4725],[138.8855,-7.3732],[138.8531,-7.3396],[138.7937,-7.2989],[138.7479,-7.2515],[138.7984,-7.2157],[138.8648,-7.2014],[138.9193,-7.2036],[139.018,-7.2259],[139.0625,-7.2271],[139.1769,-7.1904],[139.1126,-7.2018],[139.049,-7.2006],[138.8457,-7.1363],[138.72,-7.0698],[138.6014,-6.9365],[138.6002,-6.9107],[138.6838,-6.8865],[138.8646,-6.8584],[138.8085,-6.7904],[138.7267,-6.7312],[138.6981,-6.6257],[138.6422,-6.5604],[138.5216,-6.4538],[138.4387,-6.3434],[138.3684,-6.1186],[138.2963,-5.949],[138.3139,-5.8875],[138.3746,-5.8437],[138.2828,-5.8386],[138.1996,-5.807],[138.2436,-5.7244],[138.3396,-5.6757],[138.2521,-5.6882],[138.1665,-5.712],[138.1274,-5.7165],[138.0871,-5.7092],[138.0659,-5.676],[138.0631,-5.6289],[138.0756,-5.5458],[138.0608,-5.4652],[137.985,-5.4276],[137.9223,-5.3701],[137.8868,-5.3488],[137.8403,-5.3505],[137.7952,-5.312],[137.7591,-5.2562],[137.3066,-5.0144],[137.2798,-4.9454],[137.2379,-4.9757],[137.1959,-4.9904],[137.1438,-4.9508],[137.0893,-4.9244],[137.0297,-4.9287],[136.9746,-4.9073],[136.917,-4.8951],[136.8568,-4.8932],[136.6188,-4.8187],[136.3938,-4.7013],[136.2106,-4.6507],[136.0975,-4.5848],[135.9797,-4.5309],[135.7166,-4.4784],[135.4502,-4.4431],[135.3539,-4.4418],[135.2731,-4.4531],[135.1956,-4.4507],[134.7542,-4.1954],[134.6797,-4.0791],[134.6869,-4.0111],[134.7065,-3.9548],[134.8865,-3.9385],[134.7598,-3.9222],[134.7076,-3.9299],[134.6034,-3.9761],[134.5469,-3.9793],[134.4672,-3.9486],[134.391,-3.91],[134.2662,-3.9458],[134.2023,-3.887],[134.1805,-3.8251],[134.1471,-3.7968],[134.1,-3.7997],[134.0369,-3.822],[133.9738,-3.818],[133.9332,-3.7756],[133.904,-3.7201],[133.8607,-3.6804],[133.8085,-3.65],[133.723,-3.5779],[133.6783,-3.4795],[133.6834,-3.3092],[133.6972,-3.2481],[133.7816,-3.1489],[133.8415,-3.0548],[133.7674,-3.0443],[133.7004,-3.0875],[133.672,-3.1318],[133.6607,-3.1855],[133.6531,-3.3644],[133.5994,-3.4161],[133.5182,-3.4119],[133.5423,-3.5164],[133.5092,-3.6155],[133.4151,-3.7321],[133.4072,-3.7852],[133.4223,-3.8426],[133.4009,-3.899],[133.2487,-4.0623],[133.198,-4.0701],[133.0852,-4.069],[132.9686,-4.0949],[132.9145,-4.0569],[132.8701,-4.0074],[132.8371,-3.9489],[132.7909,-3.8281],[132.7539,-3.7036],[132.8697,-3.551],[132.8298,-3.413],[132.7514,-3.2946],[132.5535,-3.1307],[132.3482,-2.9751],[132.255,-2.9435],[132.1021,-2.9296],[132.0539,-2.9146],[132.0063,-2.8561],[131.9712,-2.7886],[132.0669,-2.7596],[132.2307,-2.6804],[132.3233,-2.6842],[132.5755,-2.7271],[132.6529,-2.7662],[132.725,-2.7891],[132.8973,-2.6582],[133.0338,-2.4874],[133.1188,-2.4503],[133.191,-2.4378],[133.2649,-2.4543],[133.4114,-2.514],[133.5266,-2.5417],[133.6087,-2.5472],[133.6516,-2.6006],[133.7001,-2.6246],[133.7109,-2.544],[133.7533,-2.4507],[133.8347,-2.4217],[133.8776,-2.415],[133.9049,-2.3909],[133.8989,-2.3045],[133.791,-2.2937],[133.8497,-2.2196],[133.9024,-2.1836],[133.9205,-2.1475],[133.9216,-2.1021],[133.7104,-2.1892],[133.4878,-2.2256],[133.3563,-2.2157],[133.2249,-2.2145],[132.9628,-2.2726],[132.8633,-2.2702],[132.6311,-2.2467],[132.5026,-2.2185],[132.4033,-2.2404],[132.3076,-2.2423],[132.2074,-2.1758],[132.1222,-2.0924],[132.0799,-2.0332],[132.0234,-1.9903],[131.9984,-1.9325],[131.9361,-1.7149],[131.9304,-1.5597],[131.8298,-1.5565],[131.7314,-1.5412],[131.2938,-1.3935],[131.2408,-1.4297],[131.1792,-1.4483],[131.1178,-1.4553],[131.0567,-1.4477],[130.9959,-1.4247],[131.001,-1.384],[131.0462,-1.2841],[131.0905,-1.2473],[131.1519,-1.2188],[131.1908,-1.1658],[131.2541,-1.0069],[131.259,-0.9526],[131.2521,-0.8972],[131.2572,-0.8555],[131.2964,-0.8336],[131.4615,-0.7818],[131.8043,-0.7038],[131.8909,-0.6571],[131.9624,-0.5824],[132.046,-0.537],[132.0845,-0.4911],[132.1284,-0.4541],[132.3938,-0.3555],[132.508,-0.3475],[132.6251,-0.3589],[132.8564,-0.4174],[133.0771,-0.5118],[133.2685,-0.6357],[133.4727,-0.7262]],[[104.4742,-0.3347],[104.5678,-0.4318],[104.5901,-0.4666],[104.5439,-0.5205],[104.5065,-0.5967],[104.4854,-0.6129],[104.4139,-0.5837],[104.3632,-0.6586],[104.3298,-0.5391],[104.2571,-0.4633],[104.3023,-0.3857],[104.3188,-0.3802],[104.3407,-0.3826],[104.3636,-0.4028],[104.4742,-0.3347]],[[127.567,-0.3189],[127.6824,-0.4684],[127.605,-0.6102],[127.6586,-0.6895],[127.8043,-0.6944],[127.8379,-0.7241],[127.8633,-0.7599],[127.8802,-0.8087],[127.8423,-0.8478],[127.7611,-0.8837],[127.6676,-0.832],[127.6429,-0.784],[127.6238,-0.766],[127.4979,-0.8024],[127.4627,-0.806],[127.4383,-0.7391],[127.4687,-0.643],[127.3806,-0.5996],[127.3,-0.5003],[127.2971,-0.4603],[127.3295,-0.3909],[127.3251,-0.3358],[127.3712,-0.3316],[127.4552,-0.4063],[127.4917,-0.3359],[127.5273,-0.3066],[127.567,-0.3189]],[[127.2499,-0.4953],[127.1873,-0.5212],[127.1191,-0.5205],[127.1044,-0.4139],[127.1265,-0.2786],[127.1896,-0.2558],[127.29,-0.2844],[127.253,-0.3187],[127.2806,-0.391],[127.2499,-0.4953]],[[103.7365,-0.3479],[103.6063,-0.3829],[103.4613,-0.3576],[103.479,-0.2975],[103.5489,-0.2275],[103.6109,-0.2306],[103.7239,-0.2767],[103.7643,-0.3178],[103.7365,-0.3479]],[[130.8133,-0.0041],[130.9865,-0.0466],[131.0258,-0.0399],[131.2769,-0.1498],[131.3169,-0.2043],[131.3027,-0.2411],[131.3397,-0.2903],[131.2575,-0.3657],[131.2179,-0.3741],[131.1777,-0.346],[131.0978,-0.3301],[131.0054,-0.3607],[130.9465,-0.3376],[130.8967,-0.2685],[130.8084,-0.2265],[130.6835,-0.0807],[130.6222,-0.0859],[130.6383,-0.143],[130.6913,-0.1806],[130.7613,-0.2914],[130.8016,-0.3021],[130.8432,-0.2983],[130.8992,-0.3444],[130.8963,-0.416],[130.7502,-0.4438],[130.6998,-0.3916],[130.6887,-0.2966],[130.6065,-0.3286],[130.5749,-0.3618],[130.5508,-0.3664],[130.4963,-0.2674],[130.3405,-0.2623],[130.2366,-0.2097],[130.2877,-0.1547],[130.2949,-0.1015],[130.3625,-0.0729],[130.431,-0.0985],[130.4996,-0.0601],[130.5483,-0.0699],[130.5843,-0.0454],[130.7224,-0.0298],[130.8133,-0.0041]],[[98.4593,-0.5305],[98.3997,-0.5769],[98.3097,-0.5318],[98.3399,-0.4679],[98.3548,-0.3793],[98.4088,-0.309],[98.4271,-0.2265],[98.3229,-0.0008],[98.3745,0.0071],[98.4154,-0.0175],[98.4844,-0.1677],[98.5441,-0.2576],[98.5201,-0.3797],[98.4593,-0.5305]],[[104.7786,-0.176],[104.8075,-0.1925],[104.8432,-0.1406],[104.909,-0.2117],[104.9497,-0.2473],[105.0054,-0.2828],[104.9506,-0.2845],[104.9285,-0.317],[104.9143,-0.3233],[104.7022,-0.2087],[104.5666,-0.2456],[104.4735,-0.2121],[104.4471,-0.1892],[104.4971,-0.1264],[104.5427,0.0177],[104.6356,-0.0185],[104.6584,-0.0628],[104.6527,-0.076],[104.7135,-0.103],[104.7786,-0.176]],[[129.5489,-0.187],[129.5057,-0.1898],[129.4692,-0.1314],[129.3701,-0.0664],[129.3088,0.0454],[129.542,-0.1393],[129.5489,-0.187]],[[127.4534,-0.0059],[127.4486,-0.0366],[127.4179,0.0063],[127.3968,0.0166],[127.4195,0.1244],[127.4313,0.1426],[127.4494,0.069],[127.4534,-0.0059]],[[104.6893,0.0595],[104.6981,0.0347],[104.6509,0.0627],[104.6224,0.0796],[104.6035,0.0952],[104.4992,0.2321],[104.5438,0.2233],[104.6599,0.1031],[104.6893,0.0595]],[[103.2845,0.5419],[103.1722,0.5362],[103.1396,0.5491],[103.1533,0.6431],[103.1874,0.6998],[103.2382,0.6986],[103.2951,0.614],[103.2845,0.5419]],[[127.4197,0.6421],[127.384,0.631],[127.3736,0.6349],[127.3629,0.6751],[127.3826,0.7436],[127.4248,0.7444],[127.4426,0.7334],[127.4459,0.6833],[127.4197,0.6421]],[[127.3727,0.7913],[127.3384,0.7584],[127.3061,0.7694],[127.2864,0.8119],[127.2928,0.8425],[127.3198,0.862],[127.3538,0.8475],[127.3727,0.7913]],[[103.4502,0.6645],[103.4297,0.6509],[103.3444,0.7779],[103.3657,0.8511],[103.3861,0.8696],[103.4331,0.825],[103.4703,0.7781],[103.4975,0.7227],[103.4502,0.6645]],[[103.8286,0.801],[103.834,0.7722],[103.7424,0.83],[103.74,0.8718],[103.752,0.8914],[103.8066,0.8463],[103.8286,0.801]],[[104.2394,0.834],[104.1768,0.8049],[104.0981,0.8962],[104.1011,0.9175],[104.1083,0.9335],[104.1228,0.944],[104.1705,0.8967],[104.2271,0.8799],[104.2394,0.834]],[[103.0275,0.7466],[103.0088,0.7081],[102.9715,0.7365],[102.7763,0.7796],[102.7105,0.7844],[102.5416,0.8316],[102.4904,0.8566],[102.4539,0.8895],[102.4664,0.9503],[102.4914,0.9869],[102.5066,1.0888],[102.5492,1.1302],[102.6332,1.0544],[102.7262,0.9892],[102.7801,0.9594],[102.9441,0.8927],[103.0024,0.8593],[103.0275,0.7466]],[[103.4239,1.0483],[103.4297,0.9934],[103.3633,1.0068],[103.3154,1.0713],[103.355,1.1172],[103.38,1.1336],[103.4049,1.0726],[103.4239,1.0483]],[[103.1664,0.8702],[103.1372,0.8417],[103.0867,0.8481],[103.0334,0.882],[102.964,0.9427],[102.8863,0.9968],[102.788,1.031],[102.7265,1.0413],[102.7019,1.0537],[102.7256,1.1588],[102.7901,1.1655],[102.9994,1.0678],[103.0676,1.0147],[103.1664,0.8702]],[[104.0248,1.1806],[104.0881,1.137],[104.1398,1.1656],[104.1378,1.1282],[104.1273,1.0924],[104.0661,0.9896],[103.9636,1.0132],[103.9398,1.0465],[103.9322,1.0714],[103.947,1.087],[103.9554,1.1375],[103.9998,1.1373],[104.0248,1.1806]],[[104.5854,1.2161],[104.591,1.1411],[104.6481,1.1046],[104.6629,1.0495],[104.6528,0.961],[104.5991,0.859],[104.5752,0.8319],[104.5043,0.8526],[104.4807,0.8868],[104.4712,0.9135],[104.4811,0.9325],[104.4286,0.9565],[104.4624,0.9956],[104.4393,1.0504],[104.2939,1.0161],[104.252,1.0149],[104.2442,1.0774],[104.2502,1.1026],[104.3618,1.1815],[104.4284,1.196],[104.5001,1.1802],[104.5854,1.2161]],[[102.4271,0.9901],[102.3809,0.9598],[102.3253,1.007],[102.2796,1.0757],[102.2555,1.1472],[102.2342,1.264],[102.2286,1.3479],[102.2563,1.3971],[102.2765,1.3953],[102.3586,1.3457],[102.4129,1.2608],[102.4429,1.2342],[102.4488,1.1563],[102.4289,1.0673],[102.4271,0.9901]],[[97.4815,1.4651],[97.6983,1.1837],[97.7864,1.1459],[97.9032,1.0183],[97.9319,0.9739],[97.9021,0.8842],[97.8765,0.6283],[97.8204,0.5645],[97.684,0.5961],[97.6825,0.6411],[97.6039,0.8339],[97.4612,0.9414],[97.4054,0.947],[97.3688,1.0569],[97.2969,1.1874],[97.0792,1.4255],[97.2442,1.4236],[97.3244,1.4816],[97.3428,1.5279],[97.356,1.5397],[97.4815,1.4651]],[[102.4919,1.4592],[102.4994,1.3309],[102.4252,1.3645],[102.3669,1.4155],[102.2742,1.4531],[102.1613,1.4654],[102.0787,1.4986],[102.0209,1.5582],[102.0184,1.5856],[102.024,1.608],[102.0422,1.6254],[102.4695,1.5101],[102.4919,1.4592]],[[124.8889,0.9953],[124.6981,0.8256],[124.6398,0.7436],[124.5891,0.6553],[124.5141,0.5571],[124.4275,0.4706],[124.3844,0.445],[124.278,0.3984],[124.2168,0.3804],[124.1014,0.3746],[123.7538,0.3055],[123.6396,0.2975],[123.526,0.3003],[123.3104,0.3176],[123.2654,0.3266],[123.1795,0.4155],[123.0825,0.4858],[122.9969,0.4935],[122.9096,0.486],[122.2808,0.4811],[122.0609,0.468],[121.842,0.4366],[121.7228,0.4509],[121.6046,0.4861],[121.5157,0.4984],[121.4258,0.4948],[121.013,0.4417],[120.9092,0.4468],[120.7004,0.5147],[120.579,0.5283],[120.46,0.5103],[120.349,0.4492],[120.307,0.4083],[120.1923,0.2685],[120.1273,0.1666],[120.0783,0.0397],[120.036,-0.0899],[120.0133,-0.1962],[120.0121,-0.3071],[120.0317,-0.432],[120.0629,-0.5556],[120.0975,-0.6499],[120.2406,-0.8683],[120.2698,-0.8992],[120.4254,-0.9606],[120.5176,-1.0395],[120.6051,-1.2585],[120.6674,-1.3701],[120.7286,-1.3715],[120.797,-1.3637],[120.9158,-1.3778],[121.0337,-1.4065],[121.1485,-1.3395],[121.2126,-1.2125],[121.2769,-1.1182],[121.4313,-0.9386],[121.5193,-0.8556],[121.5756,-0.8285],[121.6327,-0.8403],[121.6812,-0.8879],[121.7377,-0.9257],[121.8531,-0.946],[121.9696,-0.9333],[122.0937,-0.875],[122.1381,-0.8393],[122.1749,-0.7937],[122.28,-0.757],[122.5297,-0.7566],[122.6588,-0.7698],[122.8888,-0.7552],[122.8855,-0.7221],[122.8411,-0.687],[122.8295,-0.6589],[122.8723,-0.6407],[123.0204,-0.5998],[123.1715,-0.5707],[123.2814,-0.5915],[123.3797,-0.6485],[123.4174,-0.7074],[123.4342,-0.7782],[123.3963,-0.9616],[123.3779,-1.0041],[123.2996,-1.0261],[123.2258,-1.0018],[123.1527,-0.907],[123.0494,-0.8724],[122.9028,-0.901],[122.8525,-0.9281],[122.8074,-0.966],[122.7246,-1.0643],[122.6557,-1.1752],[122.5066,-1.3479],[122.3342,-1.4979],[122.2507,-1.5553],[122.1576,-1.5939],[121.8586,-1.6933],[121.7799,-1.767],[121.7188,-1.8628],[121.651,-1.8954],[121.5727,-1.9058],[121.5139,-1.8878],[121.3947,-1.8338],[121.3555,-1.8782],[121.3488,-1.946],[121.4075,-1.9701],[121.502,-2.045],[121.575,-2.1509],[121.6219,-2.1736],[121.726,-2.208],[121.7697,-2.2409],[121.8482,-2.3315],[121.9719,-2.5424],[122.014,-2.6564],[122.0826,-2.7495],[122.2917,-2.9076],[122.3033,-2.9522],[122.2904,-3.0042],[122.3065,-3.0516],[122.3813,-3.1424],[122.399,-3.2009],[122.3173,-3.2751],[122.3128,-3.3827],[122.2627,-3.5274],[122.2514,-3.5763],[122.2529,-3.6204],[122.2881,-3.6616],[122.3291,-3.6942],[122.3854,-3.7114],[122.4346,-3.7398],[122.5292,-3.8526],[122.5786,-3.8823],[122.61,-3.9234],[122.6067,-3.9847],[122.6499,-4.0205],[122.6896,-4.0845],[122.7504,-4.1],[122.7788,-4.0816],[122.7982,-4.0542],[122.8479,-4.0646],[122.8773,-4.1091],[122.8943,-4.1663],[122.8998,-4.2294],[122.8974,-4.3491],[122.8723,-4.392],[122.8176,-4.3899],[122.7197,-4.3407],[122.715,-4.3763],[122.7217,-4.4107],[122.6719,-4.4222],[122.6147,-4.4174],[122.4714,-4.4221],[122.2071,-4.4964],[122.1143,-4.5402],[122.0542,-4.6201],[122.05,-4.6753],[122.0732,-4.7917],[122.0381,-4.8324],[121.917,-4.8479],[121.748,-4.8167],[121.6457,-4.7856],[121.5887,-4.7596],[121.5144,-4.6812],[121.4865,-4.5811],[121.5412,-4.2829],[121.5567,-4.2446],[121.5834,-4.2105],[121.6115,-4.1563],[121.6181,-4.0927],[121.5374,-4.0148],[121.4158,-3.9843],[121.3127,-3.9194],[120.9143,-3.5558],[120.8918,-3.5206],[120.8909,-3.4604],[120.9069,-3.404],[121.0379,-3.2052],[121.0543,-3.1671],[121.0703,-3.0102],[121.0668,-2.881],[121.0521,-2.7517],[120.9901,-2.6703],[120.8794,-2.6456],[120.765,-2.6416],[120.6536,-2.6676],[120.5439,-2.7326],[120.3414,-2.8696],[120.261,-2.9493],[120.2541,-3.0528],[120.3005,-3.1543],[120.3604,-3.2469],[120.3924,-3.3481],[120.4366,-3.7073],[120.4352,-3.7479],[120.383,-3.8523],[120.3625,-4.0857],[120.3846,-4.4151],[120.4201,-4.6174],[120.405,-4.7272],[120.3102,-4.9632],[120.2814,-5.0927],[120.2793,-5.1461],[120.3909,-5.3926],[120.4166,-5.49],[120.4304,-5.591],[120.3116,-5.5416],[120.2564,-5.5441],[120.2008,-5.5594],[120.0771,-5.5755],[119.9516,-5.5776],[119.9076,-5.5963],[119.8185,-5.6618],[119.7645,-5.6883],[119.7173,-5.6934],[119.5574,-5.611],[119.4631,-5.5217],[119.3762,-5.4248],[119.3604,-5.3142],[119.3906,-5.2006],[119.4336,-5.0792],[119.5195,-4.8773],[119.5155,-4.7419],[119.5449,-4.6309],[119.594,-4.5231],[119.6117,-4.4235],[119.6236,-4.0344],[119.6114,-3.9998],[119.4937,-3.7686],[119.4801,-3.7298],[119.4793,-3.6674],[119.492,-3.6078],[119.4945,-3.5541],[119.4675,-3.513],[119.4198,-3.4754],[119.3621,-3.459],[119.24,-3.4753],[118.9946,-3.5376],[118.9222,-3.4827],[118.8677,-3.398],[118.8328,-3.2802],[118.8125,-3.1566],[118.8219,-3.0406],[118.8581,-2.9285],[118.8289,-2.8501],[118.7837,-2.7647],[118.7833,-2.7208],[118.809,-2.6823],[118.8533,-2.6502],[118.9075,-2.6314],[118.9582,-2.5975],[119.0922,-2.4829],[119.1354,-2.3823],[119.1382,-2.2585],[119.1723,-2.14],[119.2408,-2.031],[119.3219,-1.9297],[119.3482,-1.8253],[119.3083,-1.6597],[119.3241,-1.5843],[119.3104,-1.4957],[119.309,-1.4082],[119.3592,-1.2435],[119.5082,-0.9067],[119.6535,-0.7279],[119.7113,-0.6808],[119.7867,-0.764],[119.8443,-0.8619],[119.8452,-0.7732],[119.8299,-0.6863],[119.7717,-0.4836],[119.7219,-0.0885],[119.7358,-0.051],[119.7865,-0.057],[119.8383,-0.0221],[119.8656,0.0401],[119.8117,0.1869],[119.8093,0.2387],[119.9133,0.4451],[119.998,0.5202],[120.0352,0.5666],[120.0564,0.6925],[120.1006,0.7401],[120.1565,0.7742],[120.2298,0.8612],[120.2695,0.9708],[120.2938,0.9792],[120.3225,0.9832],[120.3665,0.8875],[120.416,0.8487],[120.5166,0.8175],[120.6025,0.8544],[120.6265,0.9024],[120.6589,0.9437],[120.711,0.9867],[120.7549,1.0356],[120.8036,1.1493],[120.868,1.2528],[120.9121,1.289],[120.9654,1.3118],[121.0246,1.3258],[121.0817,1.3276],[121.2084,1.2625],[121.2817,1.2498],[121.3567,1.2545],[121.4041,1.2436],[121.44,1.2144],[121.4728,1.1555],[121.5133,1.1047],[121.5507,1.0797],[121.5918,1.068],[121.8674,1.0885],[122.1082,1.0312],[122.4366,1.0181],[122.5493,0.9845],[122.6574,0.9406],[122.7898,0.8629],[122.8383,0.8457],[122.8925,0.85],[122.9601,0.923],[123.0128,0.939],[123.0665,0.9418],[123.2781,0.9281],[123.8467,0.8382],[123.9308,0.8504],[124.2736,1.0223],[124.4108,1.1851],[124.5337,1.2305],[124.5754,1.3041],[124.6002,1.3924],[124.6438,1.4162],[124.7467,1.4414],[124.7877,1.4676],[124.8606,1.576],[124.9471,1.6722],[124.9893,1.701],[125.1109,1.6857],[125.1648,1.6437],[125.2338,1.5023],[125.2217,1.4787],[125.1409,1.4084],[125.1175,1.3789],[125.028,1.1802],[124.9668,1.0826],[124.8889,0.9953]],[[101.7081,2.0784],[101.7623,1.9965],[101.7735,1.9435],[101.7341,1.8826],[101.7194,1.7892],[101.6027,1.7157],[101.5008,1.7332],[101.4678,1.7594],[101.4034,1.9013],[101.4097,2.0217],[101.4503,2.0678],[101.5447,2.0607],[101.6407,2.1267],[101.7081,2.0784]],[[127.7327,0.8481],[127.8054,0.8259],[127.8811,0.8321],[127.9187,0.8768],[127.9291,0.9347],[127.9673,1.0426],[128.0553,1.1156],[128.117,1.1271],[128.1607,1.1578],[128.1531,1.2379],[128.1574,1.3166],[128.2225,1.4006],[128.4241,1.5175],[128.5393,1.5592],[128.6884,1.5726],[128.7052,1.5277],[128.6881,1.4637],[128.7169,1.3673],[128.7026,1.1064],[128.6688,1.0694],[128.5146,0.9792],[128.346,0.9071],[128.2988,0.8768],[128.2572,0.805],[128.2606,0.7338],[128.3979,0.6388],[128.6112,0.55],[128.6553,0.5083],[128.6838,0.4385],[128.6916,0.3604],[128.7433,0.3232],[128.8154,0.3054],[128.8633,0.2684],[128.8996,0.2163],[128.5404,0.3379],[128.4465,0.3916],[128.3328,0.3979],[128.2206,0.4143],[128.1061,0.4609],[127.9831,0.4719],[127.9244,0.4381],[127.9014,0.3723],[127.8874,0.2983],[127.9146,0.2063],[127.9122,0.1505],[127.889,0.0495],[127.9778,-0.2483],[128.0895,-0.4853],[128.2535,-0.7316],[128.3346,-0.8163],[128.4255,-0.8927],[128.2781,-0.87],[128.2334,-0.7877],[128.0464,-0.7061],[128.0108,-0.6573],[127.889,-0.4235],[127.8533,-0.3799],[127.7408,-0.3004],[127.6916,-0.2419],[127.6748,-0.1629],[127.6874,-0.0799],[127.6813,0.0349],[127.6854,0.149],[127.7087,0.2881],[127.6687,0.3368],[127.6162,0.3829],[127.5554,0.4896],[127.5371,0.6109],[127.5418,0.6807],[127.567,0.7425],[127.6007,0.796],[127.608,0.8482],[127.5204,0.924],[127.4285,1.14],[127.4203,1.252],[127.5371,1.4675],[127.5347,1.5721],[127.5579,1.6342],[127.5707,1.7001],[127.6317,1.8437],[127.7314,1.9661],[127.8999,2.1374],[127.9643,2.1747],[128.0364,2.199],[128.0428,2.1571],[128.0312,2.1199],[127.9067,1.9457],[127.8901,1.9063],[127.8868,1.833],[127.9465,1.7896],[128.0109,1.7012],[128.0237,1.5835],[128.0259,1.4581],[128.0117,1.3317],[127.9877,1.2896],[127.8854,1.1628],[127.6528,1.0139],[127.633,0.9772],[127.6344,0.9361],[127.6774,0.8866],[127.7327,0.8481]],[[97.3342,2.0756],[97.3283,2.0533],[97.2251,2.1585],[97.1083,2.2169],[97.1566,2.2322],[97.2528,2.216],[97.2914,2.2008],[97.3287,2.1485],[97.3342,2.0756]],[[128.4539,2.0518],[128.2959,2.0347],[128.26,2.0825],[128.218,2.2975],[128.3304,2.4693],[128.4721,2.5705],[128.5687,2.5961],[128.6021,2.5976],[128.6885,2.4737],[128.6232,2.2244],[128.5476,2.0971],[128.4539,2.0518]],[[125.4074,2.6516],[125.3973,2.6295],[125.3601,2.7468],[125.3908,2.8054],[125.4353,2.7839],[125.4465,2.763],[125.4039,2.707],[125.4074,2.6516]],[[96.4637,2.36],[96.401,2.3507],[96.3406,2.3721],[96.2904,2.4296],[96.022,2.5958],[95.9385,2.5984],[95.8798,2.6409],[95.8086,2.6556],[95.733,2.7665],[95.7172,2.826],[95.7722,2.855],[95.8063,2.916],[95.8958,2.8891],[95.9979,2.7814],[96.1016,2.7412],[96.1298,2.7209],[96.18,2.6613],[96.4173,2.5152],[96.4431,2.4656],[96.4594,2.4158],[96.4637,2.36]],[[108.8875,2.9054],[108.8389,2.853],[108.7865,2.8856],[108.8671,2.9919],[108.8857,2.999],[108.8875,2.9054]],[[105.7604,2.863],[105.7186,2.8592],[105.7062,2.8889],[105.7079,2.9401],[105.7042,2.9809],[105.6922,3.0113],[105.6922,3.0625],[105.7307,3.037],[105.7604,3.013],[105.7945,2.9959],[105.8222,2.9844],[105.8367,2.9765],[105.8094,2.904],[105.7604,2.863]],[[106.2853,3.1571],[106.2837,3.0882],[106.2146,3.1286],[106.201,3.2049],[106.2237,3.2296],[106.2712,3.2163],[106.2853,3.1571]],[[117.6584,3.2805],[117.6458,3.2478],[117.5604,3.3282],[117.5375,3.3864],[117.5479,3.432],[117.6367,3.4361],[117.6809,3.4075],[117.6584,3.2805]],[[125.6581,3.436],[125.6332,3.4054],[125.5115,3.4611],[125.5176,3.5496],[125.5012,3.5932],[125.4686,3.6391],[125.4553,3.6842],[125.4688,3.7333],[125.5435,3.6704],[125.5856,3.5711],[125.6436,3.4765],[125.6581,3.436]],[[126.8519,3.7685],[126.8355,3.7569],[126.7996,3.7839],[126.7775,3.8134],[126.7789,3.8432],[126.8045,3.8579],[126.857,3.8124],[126.8578,3.7872],[126.8519,3.7685]],[[126.7193,3.8747],[126.7218,3.8325],[126.6612,3.9284],[126.6375,4.0419],[126.6855,4.0014],[126.7396,3.9177],[126.7193,3.8747]],[[117.8848,4.1861],[117.9179,4.0905],[117.9229,4.0543],[117.7368,4.004],[117.6251,4.1215],[117.649,4.169],[117.7454,4.1669],[117.8848,4.1861]],[[108.316,3.6896],[108.1796,3.6531],[108.1004,3.7045],[108.1861,3.768],[108.2164,3.7722],[108.2361,3.7846],[108.2433,3.8104],[108.0885,3.8521],[108.0445,3.889],[108.0023,3.9829],[108.0035,4.0426],[108.202,4.2005],[108.2483,4.2171],[108.2556,4.1518],[108.3929,3.9862],[108.3988,3.876],[108.3936,3.8362],[108.316,3.6896]],[[116.5531,4.3599],[116.5891,4.3384],[116.6387,4.3391],[116.6979,4.355],[116.8436,4.3401],[117.1006,4.3371],[117.2775,4.2993],[117.4509,4.1929],[117.5373,4.1714],[117.5744,4.1706],[117.5662,4.1623],[117.4975,4.1334],[117.4653,4.0761],[117.5594,3.9883],[117.566,3.9299],[117.6391,3.878],[117.7282,3.7967],[117.7317,3.7703],[117.762,3.7339],[117.7772,3.6893],[117.7145,3.6448],[117.6299,3.6363],[117.5674,3.6783],[117.5097,3.7304],[117.4949,3.6656],[117.4504,3.6285],[117.2879,3.6393],[117.1716,3.639],[117.056,3.6227],[117.1139,3.6126],[117.1664,3.592],[117.3463,3.4266],[117.3847,3.3654],[117.3219,3.2436],[117.3524,3.1937],[117.4221,3.1652],[117.5068,3.1046],[117.5672,3.0985],[117.6106,3.0644],[117.6124,3.0049],[117.6379,2.9508],[117.5691,2.9293],[117.6372,2.9149],[117.6977,2.8873],[117.6646,2.8593],[117.6389,2.8253],[117.6668,2.8069],[117.7497,2.7756],[117.7859,2.7468],[117.8049,2.6689],[117.8857,2.5417],[118.0342,2.3776],[118.0666,2.3178],[118.0663,2.2627],[118.0416,2.2154],[117.957,2.16],[117.8893,2.087],[117.8811,2.0606],[117.7893,2.0269],[117.8313,2.002],[117.8646,1.9684],[117.9284,1.8668],[118.0804,1.7019],[118.1568,1.6403],[118.4717,1.4165],[118.639,1.319],[118.8525,1.0958],[118.9635,1.0443],[118.985,0.9821],[118.8924,0.8869],[118.7574,0.8392],[118.5348,0.8135],[118.3115,0.8471],[118.1961,0.8744],[118.0955,0.9292],[118.0163,1.0392],[117.9116,1.0987],[117.952,1.032],[117.9773,0.9638],[117.9643,0.8896],[117.923,0.8313],[117.8525,0.7887],[117.777,0.754],[117.7451,0.7296],[117.5533,0.341],[117.5222,0.2359],[117.4638,-0.2005],[117.4629,-0.3237],[117.5489,-0.5544],[117.5568,-0.6753],[117.5738,-0.7275],[117.5625,-0.7709],[117.5218,-0.7967],[117.3571,-0.8672],[117.2407,-0.9257],[117.1465,-1.009],[117.0702,-1.1127],[117.0032,-1.1877],[116.914,-1.2236],[116.8494,-1.2183],[116.7971,-1.1838],[116.7605,-1.1172],[116.7398,-1.0442],[116.7262,-1.0981],[116.7287,-1.1508],[116.7593,-1.2071],[116.771,-1.2666],[116.7534,-1.3273],[116.7152,-1.3758],[116.6116,-1.4286],[116.5545,-1.4739],[116.5451,-1.5531],[116.5176,-1.598],[116.4779,-1.6328],[116.3321,-1.7125],[116.2996,-1.7443],[116.2755,-1.7849],[116.3532,-1.7786],[116.4243,-1.7849],[116.4296,-1.8642],[116.452,-1.9231],[116.4235,-2.0525],[116.314,-2.1398],[116.3687,-2.1582],[116.4182,-2.1867],[116.5281,-2.2079],[116.5654,-2.2997],[116.5492,-2.4108],[116.5293,-2.5105],[116.4504,-2.5383],[116.4013,-2.5198],[116.3525,-2.5216],[116.3168,-2.5519],[116.3072,-2.6033],[116.3755,-2.578],[116.3717,-2.7068],[116.3532,-2.8327],[116.3307,-2.9021],[116.2889,-2.9588],[116.2258,-2.977],[116.1663,-2.9346],[116.1541,-2.9838],[116.1723,-3.0253],[116.2572,-3.1264],[116.2051,-3.1485],[116.1671,-3.183],[116.15,-3.2332],[116.0575,-3.3482],[116.0167,-3.4328],[115.9994,-3.5233],[115.9562,-3.595],[115.2582,-3.9068],[114.6936,-4.1697],[114.6525,-4.1519],[114.6253,-4.1117],[114.606,-3.7033],[114.5361,-3.4944],[114.5256,-3.3767],[114.446,-3.4818],[114.3972,-3.4712],[114.3443,-3.4444],[114.3046,-3.4101],[114.3017,-3.3647],[114.3443,-3.2352],[114.2927,-3.3062],[114.2363,-3.3611],[114.1779,-3.3544],[114.1276,-3.3272],[114.109,-3.2852],[114.0822,-3.2789],[113.9588,-3.3943],[113.7958,-3.4562],[113.7051,-3.4553],[113.6336,-3.4199],[113.6373,-3.332],[113.6301,-3.2461],[113.6101,-3.1957],[113.5663,-3.1777],[113.526,-3.1841],[113.409,-3.2289],[113.3672,-3.2236],[113.3432,-3.2465],[113.034,-2.9335],[112.9715,-3.1871],[112.758,-3.3222],[112.6003,-3.4005],[112.4439,-3.3711],[112.285,-3.321],[112.1267,-3.3814],[111.9549,-3.5297],[111.9074,-3.5525],[111.8581,-3.5519],[111.8221,-3.5325],[111.8344,-3.4201],[111.8359,-3.3077],[111.823,-3.0572],[111.8094,-3.008],[111.7602,-2.9392],[111.6947,-2.8895],[111.6583,-2.9258],[111.6255,-2.9755],[111.4949,-2.9733],[111.3676,-2.9337],[111.2592,-2.9564],[111.0443,-3.0558],[110.9301,-3.0711],[110.8688,-3.0487],[110.8297,-2.9951],[110.8521,-2.9462],[110.8993,-2.9086],[110.8111,-2.9385],[110.7358,-2.9887],[110.7031,-3.0209],[110.6682,-3.0048],[110.574,-2.8914],[110.3775,-2.9338],[110.351,-2.9468],[110.3025,-2.9854],[110.2561,-2.9661],[110.2326,-2.9251],[110.2243,-2.6887],[110.1244,-2.2339],[110.0966,-2.0014],[110.075,-1.9464],[109.9599,-1.8628],[109.9638,-1.7429],[110.0234,-1.6426],[110.0361,-1.5257],[110.0192,-1.3988],[109.9833,-1.2748],[109.9381,-1.1812],[109.8734,-1.1011],[109.7874,-1.0113],[109.6817,-0.9442],[109.4538,-0.8687],[109.3335,-0.8754],[109.2889,-0.8458],[109.2588,-0.8074],[109.271,-0.732],[109.3117,-0.6802],[109.3663,-0.6674],[109.3728,-0.6382],[109.257,-0.5774],[109.1605,-0.4949],[109.1303,-0.4454],[109.1211,-0.3909],[109.1218,-0.265],[109.1496,-0.1855],[109.1647,-0.1425],[109.1946,-0.0094],[109.2575,0.0312],[109.2473,0.0558],[109.2202,0.0738],[109.1808,0.1175],[109.1485,0.1677],[109.0748,0.2528],[108.9445,0.3557],[108.9228,0.5328],[108.9059,0.7939],[108.9168,0.9126],[108.9586,1.1346],[109.0309,1.2045],[109.0885,1.2239],[109.1315,1.2539],[109.0961,1.2582],[109.0654,1.2472],[109.0103,1.2396],[109.0555,1.4385],[109.0759,1.4959],[109.1667,1.6071],[109.2731,1.7055],[109.3182,1.8211],[109.3785,1.9227],[109.6289,2.0275],[109.539,1.8962],[109.5489,1.8483],[109.5708,1.8063],[109.6358,1.7767],[109.654,1.6149],[109.7357,1.5229],[109.8181,1.439],[109.8785,1.3979],[109.9449,1.338],[109.9917,1.2826],[110.0408,1.2357],[110.1147,1.1901],[110.3152,0.996],[110.399,0.9391],[110.4614,0.8821],[110.5058,0.862],[110.6147,0.8781],[110.9381,1.0173],[110.9961,1.0264],[111.1014,1.0505],[111.2867,1.0432],[111.4832,0.9958],[111.5467,0.9943],[111.6074,1.0226],[111.6913,1.0142],[111.7697,0.9995],[111.809,1.0117],[111.9231,1.1133],[112.0785,1.1434],[112.1286,1.2436],[112.1674,1.3382],[112.1857,1.4391],[112.2507,1.4796],[112.3416,1.5147],[112.4762,1.5591],[112.943,1.567],[112.9883,1.5476],[112.998,1.4962],[112.9883,1.4571],[113.0065,1.4339],[113.0687,1.4318],[113.1263,1.4081],[113.359,1.3271],[113.4582,1.3021],[113.5132,1.3084],[113.6223,1.2359],[113.6816,1.2606],[113.7604,1.3114],[113.8353,1.3799],[113.9023,1.4343],[114,1.4553],[114.126,1.4523],[114.2747,1.4709],[114.3871,1.5],[114.5125,1.452],[114.5459,1.4671],[114.5675,1.5142],[114.6322,1.617],[114.6609,1.6863],[114.6861,1.819],[114.7035,1.8508],[114.7511,1.869],[114.8,1.8939],[114.8127,1.9338],[114.8306,1.98],[114.8158,2.0189],[114.788,2.0516],[114.7587,2.1624],[114.7684,2.2129],[114.7864,2.2505],[114.8363,2.2694],[114.9691,2.3508],[115.0865,2.4461],[115.1508,2.4929],[115.1791,2.5232],[115.1809,2.5669],[115.1299,2.6124],[115.0808,2.6342],[115.0771,2.687],[115.0789,2.7234],[115.0937,2.7578],[115.0865,2.7912],[115.0863,2.8411],[115.1176,2.8949],[115.1899,2.9745],[115.247,3.0259],[115.3102,2.9939],[115.3842,3.0087],[115.4544,3.0343],[115.4932,3.1281],[115.4991,3.1731],[115.4897,3.2086],[115.5143,3.3424],[115.5199,3.3617],[115.5661,3.4458],[115.5707,3.5023],[115.5445,3.6337],[115.5609,3.7331],[115.5685,3.9388],[115.5961,3.9755],[115.6275,4.082],[115.6788,4.193],[115.7824,4.2538],[115.8368,4.3333],[115.8607,4.348],[115.8962,4.3487],[116.0216,4.2907],[116.1345,4.3552],[116.2362,4.3625],[116.3203,4.3537],[116.3677,4.3273],[116.4146,4.3082],[116.5147,4.3708],[116.5531,4.3599]],[[126.8166,4.0335],[126.7763,4.0126],[126.7112,4.0203],[126.7045,4.071],[126.7701,4.1622],[126.8136,4.2585],[126.7673,4.2826],[126.7221,4.3442],[126.7205,4.4158],[126.7573,4.5479],[126.8125,4.5372],[126.8651,4.4798],[126.8867,4.3725],[126.9211,4.291],[126.8477,4.18],[126.8166,4.0335]],[[96.4926,5.2293],[96.6152,5.2202],[96.8427,5.2745],[96.9678,5.2691],[97.0857,5.2299],[97.1904,5.2073],[97.4512,5.236],[97.5002,5.2283],[97.5472,5.2059],[97.5875,5.1704],[97.7067,5.0401],[97.9084,4.88],[97.9666,4.7775],[97.9998,4.6623],[98.0207,4.6352],[98.2484,4.4146],[98.2733,4.3223],[98.2412,4.1945],[98.3073,4.0929],[98.5283,3.9976],[98.6587,3.9281],[98.6865,3.8855],[98.7058,3.8348],[98.7779,3.7594],[98.8687,3.7104],[99.1512,3.5812],[99.5215,3.3112],[99.7323,3.1831],[99.9066,2.9882],[99.9694,2.8949],[100.0213,2.7942],[100.1272,2.6476],[100.3072,2.4666],[100.3527,2.4115],[100.4012,2.3316],[100.457,2.2574],[100.5238,2.1892],[100.6036,2.137],[100.6853,2.1201],[100.8168,1.9893],[100.8879,1.9482],[100.8767,2.0506],[100.8169,2.1402],[100.8178,2.1942],[100.8282,2.2426],[100.8771,2.2833],[100.9359,2.2947],[101.0462,2.2575],[101.2252,2.1022],[101.3008,2.0118],[101.3576,1.887],[101.4051,1.7574],[101.4767,1.6931],[101.575,1.6706],[101.6843,1.6612],[101.7848,1.6214],[102.0199,1.4421],[102.098,1.3579],[102.1572,1.2589],[102.1979,1.1417],[102.2233,1.0187],[102.2391,0.9903],[102.3899,0.842],[102.4692,0.7793],[102.5664,0.7488],[102.8494,0.7155],[102.9493,0.6642],[103.0318,0.5789],[103.0665,0.492],[103.0075,0.4153],[102.7863,0.2978],[102.55,0.2165],[102.7796,0.2445],[102.8959,0.2786],[103.0028,0.332],[103.1087,0.3998],[103.2766,0.4945],[103.339,0.5137],[103.4123,0.5069],[103.4789,0.4802],[103.5787,0.3871],[103.6727,0.2889],[103.7428,0.1744],[103.7867,0.047],[103.7064,-0.0196],[103.5895,-0.0687],[103.4285,-0.1918],[103.4116,-0.2404],[103.4444,-0.2717],[103.4052,-0.3622],[103.4954,-0.4181],[103.5092,-0.4655],[103.4312,-0.5336],[103.4386,-0.5756],[103.5327,-0.7547],[103.5775,-0.7957],[103.7211,-0.8867],[103.94,-0.9791],[104.0611,-1.0214],[104.1985,-1.0543],[104.2575,-1.0534],[104.3605,-1.0384],[104.3813,-1.0742],[104.4257,-1.2507],[104.4469,-1.3624],[104.4783,-1.6001],[104.5186,-1.6987],[104.5159,-1.8194],[104.5688,-1.9218],[104.6764,-1.9872],[104.791,-2.0408],[104.8452,-2.093],[104.8445,-2.1718],[104.8261,-2.2342],[104.7873,-2.2827],[104.6685,-2.3855],[104.6473,-2.4299],[104.6306,-2.5434],[104.6508,-2.5952],[104.6983,-2.5981],[104.7357,-2.5709],[104.8784,-2.4188],[104.917,-2.3922],[104.9708,-2.3709],[105.0259,-2.3575],[105.2865,-2.3562],[105.397,-2.3802],[105.4953,-2.4297],[105.582,-2.492],[105.8991,-2.8878],[106.0443,-3.1062],[106.0558,-3.1606],[106.0584,-3.2172],[106.0337,-3.2609],[105.9015,-3.4101],[105.8851,-3.4513],[105.8437,-3.6137],[105.8516,-3.7306],[105.8955,-3.7797],[105.9305,-3.833],[105.9277,-3.8813],[105.8406,-4.1218],[105.8314,-4.1629],[105.8865,-4.5539],[105.8905,-4.6598],[105.8793,-4.7937],[105.8872,-5.0096],[105.8161,-5.6766],[105.8027,-5.7164],[105.7483,-5.8183],[105.6766,-5.8176],[105.6186,-5.7996],[105.5779,-5.7606],[105.5556,-5.7123],[105.5227,-5.6728],[105.3494,-5.5495],[105.304,-5.57],[105.1281,-5.7229],[105.0813,-5.7455],[105.0227,-5.7269],[104.9303,-5.6812],[104.6396,-5.5204],[104.6217,-5.5718],[104.6182,-5.6415],[104.676,-5.8162],[104.684,-5.8927],[104.6311,-5.9079],[104.6016,-5.9046],[104.4809,-5.8031],[104.3695,-5.6907],[104.243,-5.5389],[104.1505,-5.4666],[104.0668,-5.3859],[103.8314,-5.0796],[103.7703,-5.0328],[103.4057,-4.8164],[103.3321,-4.7652],[103.2389,-4.6757],[103.1387,-4.5962],[102.9189,-4.4707],[102.5377,-4.1521],[102.372,-3.9692],[102.1877,-3.6745],[102.1275,-3.5992],[101.8179,-3.378],[101.649,-3.244],[101.5786,-3.167],[101.4143,-2.8988],[101.3662,-2.8085],[101.3057,-2.7287],[101.2063,-2.664],[101.1186,-2.5878],[100.9444,-2.3452],[100.8896,-2.2485],[100.848,-2.1439],[100.8553,-1.9342],[100.4865,-1.2991],[100.3939,-1.1013],[100.3082,-0.8267],[100.2891,-0.7988],[100.0879,-0.5529],[100.0167,-0.4742],[99.9307,-0.4002],[99.8601,-0.3138],[99.7213,-0.033],[99.6698,0.0451],[99.5977,0.1024],[99.3346,0.2086],[99.2364,0.2678],[99.1592,0.3518],[99.1117,0.4589],[99.0596,0.6864],[98.9355,1.0319],[98.7964,1.4946],[98.7025,1.702],[98.5953,1.8646],[98.5643,1.9021],[98.0865,2.1951],[98.0051,2.2382],[97.9186,2.2642],[97.795,2.2829],[97.7008,2.3585],[97.662,2.4943],[97.6406,2.6764],[97.6168,2.7851],[97.5908,2.8466],[97.3913,2.9753],[97.3132,3.0771],[97.2479,3.189],[97.1884,3.2757],[96.9689,3.5751],[96.8939,3.6537],[96.801,3.7085],[96.5254,3.7666],[96.4447,3.8163],[96.3108,3.9863],[96.2301,4.0728],[95.988,4.2633],[95.5786,4.662],[95.4947,4.7614],[95.4319,4.865],[95.3813,4.9762],[95.2066,5.284],[95.2207,5.3462],[95.2471,5.4108],[95.243,5.4643],[95.2238,5.5171],[95.2278,5.5648],[95.2796,5.5929],[95.3961,5.6288],[95.517,5.6246],[95.6289,5.6091],[95.7373,5.5793],[95.8413,5.5145],[96.0273,5.3512],[96.1333,5.2943],[96.2509,5.267],[96.4926,5.2293]],[[95.3621,5.8124],[95.3426,5.7841],[95.2832,5.7985],[95.2177,5.8895],[95.242,5.907],[95.2825,5.8978],[95.3592,5.8768],[95.366,5.8427],[95.3621,5.8124]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Indonesia","sov_a3":"IDN","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Indonesia","adm0_a3":"IDN","geou_dif":0,"geounit":"Indonesia","gu_a3":"IDN","su_dif":0,"subunit":"Indonesia","su_a3":"IDN","brk_diff":0,"name":"Indonesia","name_long":"Indonesia","brk_a3":"IDN","brk_name":"Indonesia","brk_group":"","abbrev":"Indo.","postal":"INDO","formal_en":"Republic of Indonesia","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Indonesia","name_alt":"","mapcolor7":6,"mapcolor8":6,"mapcolor9":6,"mapcolor13":11,"pop_est":240271522,"gdp_md_est":914600,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"4. Emerging region: MIKT","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"ID","iso_a3":"IDN","iso_n3":"360","un_a3":"360","wb_a2":"ID","wb_a3":"IDN","woe_id":-99,"adm0_a3_is":"IDN","adm0_a3_us":"IDN","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"South-Eastern Asia","region_wb":"East Asia & Pacific","name_len":9,"long_len":9,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[-4.4121,54.1854],[-4.6143,54.0587],[-4.6961,54.0814],[-4.7658,54.0694],[-4.7854,54.073],[-4.7456,54.1188],[-4.6987,54.2249],[-4.6148,54.2669],[-4.5086,54.3767],[-4.4247,54.4072],[-4.3956,54.4029],[-4.3772,54.3926],[-4.338,54.2691],[-4.3923,54.2254],[-4.4121,54.1854]]]},"properties":{"scalerank":3,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"United Kingdom","sov_a3":"GB1","adm0_dif":1,"level":2,"type":"Country","admin":"Isle of Man","adm0_a3":"IMN","geou_dif":0,"geounit":"Isle of Man","gu_a3":"IMN","su_dif":0,"subunit":"Isle of Man","su_a3":"IMN","brk_diff":0,"name":"Isle of Man","name_long":"Isle of Man","brk_a3":"IMN","brk_name":"Isle of Man","brk_group":"","abbrev":"IoMan","postal":"IM","formal_en":"","formal_fr":"","note_adm0":"U.K. crown dependency","note_brk":"","name_sort":"Isle of Man","name_alt":"","mapcolor7":6,"mapcolor8":6,"mapcolor9":6,"mapcolor13":3,"pop_est":76512,"gdp_md_est":2719,"pop_year":-99,"lastcensus":2006,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"IM","iso_a3":"IMN","iso_n3":"833","un_a3":"833","wb_a2":"IM","wb_a3":"IMY","woe_id":-99,"adm0_a3_is":"IMN","adm0_a3_us":"IMN","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Northern Europe","region_wb":"Europe & Central Asia","name_len":11,"long_len":11,"abbrev_len":5,"tiny":-99,"homepart":-99}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[93.89,6.8311],[93.8288,6.7487],[93.7093,7.0007],[93.658,7.0161],[93.6563,7.1362],[93.6842,7.1836],[93.8225,7.2366],[93.859,7.2068],[93.9296,6.9735],[93.89,6.8311]],[[93.7336,7.3565],[93.6385,7.2619],[93.5973,7.3188],[93.6143,7.3581],[93.6547,7.3799],[93.6925,7.4106],[93.7336,7.3565]],[[93.4426,7.8778],[93.365,7.8766],[93.342,7.9193],[93.3094,7.964],[93.3345,8.0069],[93.3755,8.0179],[93.4337,7.9484],[93.4474,7.8991],[93.4426,7.8778]],[[93.5369,8.0566],[93.49,8.0194],[93.4782,8.0245],[93.4718,8.0527],[93.4697,8.0727],[93.4612,8.1086],[93.4564,8.1719],[93.494,8.2247],[93.5316,8.2138],[93.5116,8.1598],[93.5369,8.0566]],[[73.0674,8.2691],[73.0533,8.2567],[73.0389,8.252],[73.0285,8.2535],[73.0234,8.2659],[73.0261,8.2753],[73.039,8.2648],[73.0559,8.2746],[73.0752,8.3063],[73.0795,8.3165],[73.0836,8.311],[73.0798,8.2931],[73.0674,8.2691]],[[93.1407,8.2495],[93.1706,8.2121],[93.1152,8.2185],[93.0643,8.275],[93.0775,8.3279],[93.097,8.3494],[93.1407,8.2495]],[[92.7875,9.1367],[92.7436,9.131],[92.7166,9.1651],[92.7133,9.2049],[92.7386,9.2307],[92.7621,9.2439],[92.7857,9.2405],[92.8093,9.1734],[92.7875,9.1367]],[[92.5028,10.5549],[92.4727,10.5208],[92.3695,10.5474],[92.3771,10.6506],[92.3528,10.7511],[92.3707,10.7935],[92.4479,10.8655],[92.5104,10.8975],[92.554,10.7998],[92.5743,10.7042],[92.5028,10.5549]],[[72.7804,11.2025],[72.773,11.1961],[72.7725,11.2143],[72.7818,11.2433],[72.7927,11.2627],[72.7959,11.2604],[72.7929,11.2416],[72.7879,11.2159],[72.7804,11.2025]],[[92.6932,11.3812],[92.6445,11.3613],[92.5957,11.3864],[92.6339,11.4268],[92.6402,11.5091],[92.69,11.4634],[92.6872,11.4112],[92.6932,11.3812]],[[93.0174,12.0368],[93.0621,11.8994],[92.9817,11.9595],[92.9554,12.0024],[92.9958,12.0318],[93.0174,12.0368]],[[92.7176,12.8649],[92.6857,12.8],[92.6797,12.9393],[92.6944,12.9568],[92.7106,12.9616],[92.7309,12.9485],[92.7176,12.8649]],[[92.7228,11.5361],[92.7008,11.5125],[92.6684,11.5387],[92.5756,11.7182],[92.5597,11.8334],[92.5339,11.8734],[92.5665,11.9305],[92.6075,11.9495],[92.6318,12.0139],[92.6406,12.1122],[92.6765,12.1924],[92.6947,12.2147],[92.7692,12.2156],[92.7883,12.2258],[92.7776,12.3025],[92.7341,12.3359],[92.7189,12.3573],[92.7207,12.5413],[92.732,12.6156],[92.7592,12.6691],[92.74,12.7796],[92.7531,12.8209],[92.807,12.8789],[92.8309,13.0026],[92.809,13.0396],[92.8602,13.2306],[92.8573,13.3581],[92.9246,13.4858],[93.0294,13.5438],[93.0623,13.5455],[93.0667,13.4365],[93.0767,13.4007],[93.016,13.3362],[93.0738,13.2521],[93.0661,13.2216],[93.043,13.1549],[93.0047,13.0894],[92.9514,13.0625],[92.91,12.9752],[92.8862,12.9423],[92.965,12.8505],[92.9902,12.5385],[92.9326,12.4531],[92.8637,12.436],[92.8795,12.2279],[92.8672,12.1814],[92.7988,12.0792],[92.7862,12.0347],[92.7477,11.9928],[92.764,11.9404],[92.7968,11.9175],[92.7976,11.8747],[92.767,11.7646],[92.7646,11.6392],[92.7228,11.5361]],[[78.7197,31.8876],[78.7171,31.891],[78.6584,31.9653],[78.7197,31.8876],[78.687,31.8055],[78.6935,31.7404],[78.7539,31.6684],[78.8029,31.6181],[78.7551,31.5503],[78.7268,31.4718],[78.7586,31.4366],[78.7436,31.3238],[78.7578,31.3025],[78.7916,31.2937],[78.8445,31.3015],[78.8995,31.3313],[78.946,31.3372],[78.9739,31.3286],[79.0111,31.4141],[79.0438,31.4262],[79.1071,31.4026],[79.2326,31.2417],[79.3388,31.1057],[79.3612,31.087],[79.3696,31.0799],[79.3885,31.0642],[79.4932,30.9937],[79.5654,30.9491],[79.6643,30.9652],[79.7946,30.9683],[79.8719,30.9246],[79.9166,30.8942],[79.9186,30.8899],[79.9245,30.8888],[79.9246,30.8888],[80.0814,30.7819],[80.1494,30.7898],[80.1943,30.7592],[80.2071,30.6837],[80.1862,30.6053],[80.1912,30.5684],[80.2609,30.5613],[80.4096,30.5095],[80.541,30.4635],[80.6089,30.4489],[80.6821,30.4148],[80.7468,30.3604],[80.8735,30.2906],[80.9854,30.2371],[81.0103,30.1645],[80.9661,30.18],[80.9076,30.1719],[80.8481,30.1397],[80.8199,30.1193],[80.6841,29.9943],[80.6129,29.9559],[80.549,29.8998],[80.4019,29.7303],[80.3169,29.5721],[80.2549,29.4233],[80.256,29.318],[80.233,29.1946],[80.1695,29.1243],[80.1305,29.1004],[80.0846,28.9942],[80.0517,28.8703],[80.0707,28.8302],[80.1496,28.7761],[80.2266,28.7233],[80.3248,28.6664],[80.4186,28.612],[80.4791,28.6049],[80.4958,28.6358],[80.5179,28.6652],[80.587,28.6496],[80.6713,28.5962],[80.7262,28.5539],[80.7508,28.5397],[80.8961,28.4686],[81.0166,28.4096],[81.1689,28.335],[81.2063,28.2894],[81.239,28.2409],[81.3108,28.1764],[81.486,28.0622],[81.6355,27.9805],[81.7572,27.9138],[81.8526,27.8671],[81.8969,27.8745],[81.9452,27.8993],[81.9877,27.9138],[82.037,27.9006],[82.1119,27.8649],[82.2877,27.7565],[82.4514,27.6718],[82.6299,27.6871],[82.6773,27.6734],[82.7108,27.5967],[82.7334,27.519],[82.9328,27.4677],[83.0641,27.4445],[83.2139,27.4023],[83.2897,27.371],[83.3694,27.4103],[83.384,27.4448],[83.4472,27.4653],[83.5517,27.4563],[83.747,27.3959],[83.8288,27.3778],[83.8972,27.4351],[84.0248,27.4617],[84.091,27.4914],[84.2298,27.4278],[84.4809,27.3482],[84.6102,27.2987],[84.6407,27.2499],[84.6548,27.2037],[84.6538,27.0917],[84.6854,27.041],[84.9372,26.9269],[85.0201,26.8785],[85.0873,26.8629],[85.1254,26.861],[85.1516,26.8466],[85.1741,26.7815],[85.1918,26.7666],[85.2402,26.7503],[85.293,26.741],[85.4564,26.7972],[85.5685,26.8398],[85.6484,26.829],[85.6999,26.7816],[85.7074,26.7126],[85.7373,26.6397],[85.7945,26.6042],[85.8557,26.6002],[86.0073,26.6494],[86.1294,26.6117],[86.2416,26.598],[86.3661,26.5744],[86.4145,26.5563],[86.5437,26.496],[86.7014,26.4351],[86.7625,26.4419],[87.0164,26.5554],[87.0379,26.5416],[87.0896,26.4332],[87.1668,26.3942],[87.2874,26.3603],[87.4136,26.4229],[87.5131,26.405],[87.6334,26.3991],[87.7488,26.4293],[87.8492,26.4369],[87.9951,26.3824],[88.027,26.395],[88.0549,26.43],[88.1115,26.5864],[88.1615,26.7248],[88.1572,26.8073],[88.111,26.9285],[87.9932,27.0861],[87.9844,27.1339],[88.0241,27.4089],[88.0679,27.5674],[88.1056,27.6424],[88.147,27.7492],[88.1543,27.7987],[88.1503,27.8433],[88.1098,27.8706],[88.0989,27.9045],[88.109,27.933],[88.1411,27.9489],[88.2752,27.9688],[88.426,28.0117],[88.4861,28.0345],[88.5316,28.0574],[88.5779,28.0934],[88.6211,28.0918],[88.7563,28.0397],[88.8037,28.0069],[88.8286,27.9073],[88.8488,27.8687],[88.8299,27.7674],[88.749,27.5219],[88.7648,27.4299],[88.8325,27.3628],[88.8914,27.3161],[88.8816,27.2975],[88.7604,27.2181],[88.7388,27.1756],[88.7656,27.1342],[88.8136,27.099],[88.8352,27.0656],[88.8576,26.9615],[88.9191,26.9322],[89.0409,26.865],[89.1482,26.8162],[89.3321,26.8486],[89.3842,26.8266],[89.4746,26.8034],[89.5451,26.7962],[89.5861,26.779],[89.6092,26.7622],[89.6062,26.7411],[89.61,26.7194],[89.7109,26.7139],[89.7639,26.7016],[89.9432,26.7239],[90.1229,26.7546],[90.2061,26.8475],[90.2424,26.8542],[90.3459,26.8903],[90.4477,26.8508],[90.5599,26.7966],[90.6203,26.7802],[90.7396,26.7717],[90.8558,26.7777],[91.1339,26.8034],[91.2865,26.7899],[91.4268,26.8671],[91.4559,26.8669],[91.5176,26.8073],[91.6716,26.802],[91.7537,26.8308],[91.8421,26.853],[91.8986,26.8601],[91.9438,26.8608],[91.9983,26.855],[92.0497,26.8749],[92.0734,26.9148],[92.0682,26.9752],[92.0309,27.0408],[91.9986,27.0793],[91.9923,27.0999],[92.0025,27.1474],[92.0312,27.2143],[92.0834,27.2906],[92.0449,27.3647],[91.9908,27.4502],[91.951,27.4583],[91.8513,27.4386],[91.7431,27.4425],[91.6581,27.4936],[91.5947,27.5577],[91.5793,27.6114],[91.5977,27.677],[91.6259,27.7373],[91.6319,27.76],[91.7126,27.7598],[91.8247,27.7464],[91.9094,27.7297],[91.9776,27.7304],[92.1013,27.8076],[92.1576,27.8123],[92.2223,27.827],[92.2505,27.8415],[92.2701,27.8302],[92.341,27.8208],[92.4148,27.8246],[92.4807,27.8459],[92.5467,27.8792],[92.6644,27.9489],[92.6878,27.989],[92.6875,28.0257],[92.6656,28.0499],[92.6435,28.0615],[92.6525,28.0934],[92.7019,28.1471],[92.8818,28.2281],[93.035,28.3276],[93.1192,28.4023],[93.1578,28.4927],[93.2065,28.5908],[93.252,28.6295],[93.3605,28.6541],[93.6649,28.6902],[93.7607,28.7298],[93.9022,28.8032],[93.9736,28.8608],[94.0133,28.9075],[94.0177,28.9595],[94.1115,28.9759],[94.1935,29.0599],[94.2933,29.1446],[94.4681,29.2162],[94.623,29.3124],[94.6771,29.297],[94.7334,29.2516],[94.7631,29.2013],[94.7694,29.1759],[94.9675,29.144],[94.9988,29.1492],[95.1447,29.1041],[95.2791,29.0496],[95.3531,29.0359],[95.3893,29.0374],[95.4202,29.0543],[95.4565,29.1023],[95.4938,29.137],[95.517,29.1512],[95.5158,29.2063],[95.7104,29.3138],[95.8851,29.3909],[96.0354,29.4472],[96.0796,29.4241],[96.1285,29.3814],[96.1947,29.2725],[96.235,29.2458],[96.3372,29.261],[96.3559,29.2491],[96.3397,29.2098],[96.2705,29.1612],[96.1809,29.1177],[96.1224,29.0821],[96.1414,28.9635],[96.1371,28.9226],[96.1622,28.9097],[96.3469,29.0274],[96.4357,29.0507],[96.4671,29.0223],[96.4771,28.9593],[96.55,28.8296],[96.5809,28.7637],[96.3956,28.6065],[96.3273,28.5254],[96.3299,28.4968],[96.3262,28.4686],[96.2789,28.4282],[96.2814,28.4121],[96.3198,28.3865],[96.3664,28.3673],[96.3891,28.3679],[96.4277,28.406],[96.6026,28.4599],[96.6528,28.4498],[96.7758,28.367],[96.833,28.3624],[96.9809,28.3377],[97.0754,28.3689],[97.1451,28.3403],[97.2895,28.2368],[97.3225,28.218],[97.3103,28.1552],[97.3027,28.086],[97.3392,28.0309],[97.3436,27.9823],[97.3352,27.9377],[97.3062,27.9071],[97.2261,27.89],[97.1578,27.8369],[97.0497,27.76],[96.9628,27.6983],[96.8997,27.6438],[96.8769,27.5867],[96.8836,27.5148],[96.902,27.4396],[97.1037,27.1633],[97.1021,27.1154],[97.0381,27.1021],[96.9534,27.1333],[96.8803,27.1778],[96.7979,27.2962],[96.7316,27.3315],[96.6657,27.3393],[96.2742,27.2784],[96.1908,27.2613],[96.0614,27.2171],[95.9709,27.1281],[95.9053,27.0466],[95.8373,27.0138],[95.7384,26.9504],[95.4639,26.7561],[95.3051,26.6723],[95.2015,26.6414],[95.1287,26.5973],[95.0895,26.5255],[95.0598,26.474],[95.0509,26.3473],[95.0689,26.1911],[95.1084,26.0914],[95.1293,26.0704],[95.1324,26.0413],[95.093,25.9873],[95.0407,25.9413],[95.0152,25.9129],[94.992,25.7705],[94.9457,25.7002],[94.8611,25.5972],[94.7858,25.5193],[94.6678,25.4589],[94.6229,25.41],[94.5799,25.3198],[94.5544,25.2435],[94.553,25.2157],[94.5665,25.1915],[94.6156,25.1646],[94.6753,25.1386],[94.7037,25.0979],[94.7076,25.0487],[94.6633,24.931],[94.5841,24.7672],[94.4932,24.6376],[94.3994,24.5141],[94.3772,24.4737],[94.2931,24.3219],[94.2197,24.1132],[94.1703,23.9727],[94.1276,23.8765],[94.0748,23.8721],[94.0108,23.9029],[93.8555,23.9439],[93.7559,23.9769],[93.6834,24.0065],[93.6333,24.0054],[93.5641,23.9861],[93.4938,23.9729],[93.4521,23.9874],[93.3556,24.0741],[93.3263,24.0642],[93.3073,24.0219],[93.3726,23.7742],[93.4149,23.6821],[93.4081,23.528],[93.3913,23.3392],[93.366,23.1325],[93.3494,23.085],[93.308,23.0304],[93.2535,23.0155],[93.2039,23.037],[93.1642,23.032],[93.151,22.9973],[93.1625,22.908],[93.1143,22.8057],[93.0787,22.7182],[93.0882,22.6333],[93.1051,22.5471],[93.162,22.3602],[93.1624,22.2919],[93.1512,22.2306],[93.1215,22.2052],[93.0706,22.2094],[93.043,22.184],[93.022,22.1457],[92.9646,22.0038],[92.9095,21.9889],[92.8543,22.0102],[92.7714,22.1048],[92.721,22.1324],[92.689,22.131],[92.6747,22.106],[92.6526,22.0493],[92.6304,22.0113],[92.5749,21.9781],[92.5612,22.048],[92.5318,22.4103],[92.5096,22.5257],[92.4914,22.6854],[92.4645,22.7344],[92.4305,22.8218],[92.3932,22.897],[92.3616,22.929],[92.3412,23.0698],[92.3338,23.2424],[92.3342,23.3238],[92.2894,23.4925],[92.2461,23.6836],[92.1871,23.6755],[92.1523,23.7219],[92.1271,23.721],[92.044,23.6778],[91.9785,23.692],[91.9296,23.686],[91.9295,23.5982],[91.9379,23.5047],[91.9191,23.471],[91.79,23.361],[91.7542,23.2873],[91.7579,23.2098],[91.7738,23.1061],[91.751,23.0535],[91.6949,23.0048],[91.6195,22.9797],[91.5535,22.9916],[91.5112,23.0337],[91.4714,23.1413],[91.4362,23.1999],[91.3994,23.2139],[91.3706,23.198],[91.3668,23.1305],[91.3687,23.0746],[91.3594,23.0684],[91.3389,23.077],[91.3152,23.1044],[91.2538,23.3736],[91.1655,23.5811],[91.1604,23.6606],[91.1925,23.7629],[91.232,23.9205],[91.3364,24.0188],[91.3502,24.0605],[91.3671,24.0935],[91.3927,24.1001],[91.5264,24.0908],[91.5714,24.1066],[91.6111,24.1528],[91.6688,24.1901],[91.7266,24.2051],[91.7725,24.2106],[91.8462,24.1753],[91.877,24.1953],[91.899,24.2607],[91.9311,24.3255],[91.9517,24.3567],[92.0011,24.3709],[92.0642,24.3744],[92.0851,24.3862],[92.102,24.4081],[92.1175,24.4939],[92.198,24.6857],[92.2267,24.771],[92.2306,24.7862],[92.2283,24.8813],[92.2513,24.8951],[92.385,24.8488],[92.4432,24.8494],[92.475,24.8685],[92.4854,24.9033],[92.4684,24.9441],[92.3734,25.0151],[92.2047,25.1109],[92.0497,25.1695],[91.7635,25.1606],[91.4797,25.1421],[91.3967,25.1516],[91.2932,25.178],[91.0383,25.1741],[90.7302,25.1595],[90.6131,25.1677],[90.5553,25.1666],[90.4394,25.1577],[90.2504,25.185],[90.1196,25.22],[90.0038,25.2583],[89.8663,25.2932],[89.8333,25.2928],[89.8141,25.3054],[89.8009,25.3361],[89.7963,25.3758],[89.8249,25.5602],[89.7996,25.8396],[89.8229,25.9414],[89.7099,26.1712],[89.6709,26.2138],[89.619,26.2157],[89.5857,26.186],[89.5728,26.1323],[89.5914,26.0724],[89.5499,26.0053],[89.4669,25.9835],[89.3697,26.0061],[89.2893,26.0376],[89.1864,26.106],[89.1083,26.2022],[89.102,26.3083],[89.0668,26.3769],[89.0187,26.4103],[88.9834,26.4195],[88.952,26.4121],[88.9241,26.3751],[88.9482,26.338],[88.9815,26.2861],[88.9704,26.2509],[88.9407,26.2454],[88.8965,26.2605],[88.828,26.2522],[88.7619,26.2794],[88.7222,26.2818],[88.6828,26.2917],[88.6807,26.353],[88.6201,26.4307],[88.5183,26.5178],[88.4182,26.5715],[88.3699,26.5641],[88.3459,26.5048],[88.3515,26.4826],[88.3862,26.4715],[88.4367,26.4371],[88.4479,26.401],[88.4404,26.3695],[88.378,26.312],[88.334,26.2575],[88.2352,26.1781],[88.1508,26.0872],[88.129,26.0182],[88.0974,25.9563],[88.0846,25.8882],[88.1066,25.8411],[88.1475,25.8114],[88.2529,25.7898],[88.3631,25.6982],[88.4523,25.5744],[88.5024,25.537],[88.5935,25.4953],[88.7691,25.4905],[88.7954,25.4562],[88.8203,25.3655],[88.8548,25.3335],[88.9441,25.2908],[88.9517,25.2593],[88.9298,25.223],[88.8901,25.1944],[88.8173,25.1762],[88.7476,25.1689],[88.6775,25.1805],[88.5738,25.1879],[88.4563,25.1884],[88.3729,24.9615],[88.3134,24.8818],[88.2795,24.8819],[88.1889,24.9206],[88.1498,24.9146],[88.0451,24.713],[88.0303,24.6645],[88.0234,24.6278],[88.0791,24.5499],[88.1455,24.4858],[88.225,24.4606],[88.2871,24.4797],[88.3375,24.4539],[88.397,24.3893],[88.4985,24.3466],[88.6423,24.326],[88.7235,24.2749],[88.7336,24.2309],[88.7266,24.1862],[88.7138,24.0696],[88.6998,24.0025],[88.6226,23.8264],[88.5674,23.6744],[88.596,23.6022],[88.6164,23.5728],[88.6357,23.55],[88.6977,23.493],[88.7408,23.4366],[88.704,23.2928],[88.7244,23.255],[88.8076,23.2297],[88.8971,23.2104],[88.9281,23.1866],[88.8506,23.0405],[88.867,22.9389],[88.8997,22.8435],[88.9234,22.6875],[88.927,22.6711],[88.9207,22.632],[88.9715,22.5109],[89.05,22.2746],[89.0559,22.1862],[89.0515,22.0932],[89.0279,21.9372],[88.9493,21.9379],[89.0196,21.8336],[89.042,21.7587],[89.0517,21.6541],[88.9671,21.6414],[88.9074,21.6531],[88.8575,21.7447],[88.8344,21.6614],[88.745,21.5844],[88.713,21.622],[88.6947,21.6624],[88.6912,21.7335],[88.7402,22.0054],[88.7303,22.0361],[88.7083,22.0562],[88.6596,22.0669],[88.6416,22.122],[88.5668,21.8321],[88.5998,21.7138],[88.5847,21.6597],[88.446,21.6143],[88.3055,21.7233],[88.2875,21.7582],[88.2792,21.6969],[88.2537,21.6223],[88.1221,21.6358],[88.0568,21.6941],[88.0994,21.7936],[88.1811,22.0329],[88.1963,22.1396],[88.0871,22.2177],[87.9944,22.2657],[87.9414,22.3743],[87.9616,22.255],[88.0107,22.2126],[88.083,22.1827],[88.1593,22.1217],[88.1041,22.0474],[88.0508,22.0011],[87.9484,21.8254],[87.8237,21.7273],[87.6782,21.6535],[87.2007,21.5449],[87.1007,21.5008],[86.9541,21.3653],[86.8596,21.2367],[86.8423,21.1063],[86.8958,20.9656],[86.9394,20.7451],[86.9755,20.7001],[86.9245,20.6198],[86.8359,20.5343],[86.7625,20.4191],[86.7692,20.3559],[86.7504,20.3132],[86.4987,20.1716],[86.4458,20.0889],[86.3766,20.0067],[86.2937,20.0538],[86.2452,20.053],[86.3119,19.9878],[86.3029,19.9447],[86.2795,19.9194],[86.2162,19.8958],[85.8529,19.7917],[85.575,19.6929],[85.4969,19.6969],[85.5111,19.7269],[85.5598,19.7535],[85.5551,19.8669],[85.5041,19.8877],[85.46,19.8959],[85.2486,19.7577],[85.1628,19.6209],[85.1808,19.5949],[85.2285,19.6013],[85.3709,19.6789],[85.4369,19.6569],[85.4416,19.6266],[85.2256,19.5083],[84.771,19.1254],[84.7498,19.0501],[84.6908,18.9647],[84.6094,18.8843],[84.4628,18.6897],[84.1817,18.4006],[84.1041,18.2927],[83.6543,18.0699],[83.5723,18.0036],[83.388,17.7867],[83.1983,17.609],[82.9769,17.4618],[82.5932,17.2739],[82.3596,17.0962],[82.2865,16.9781],[82.2819,16.9361],[82.3072,16.8786],[82.35,16.8252],[82.3598,16.7828],[82.3387,16.7065],[82.3271,16.6644],[82.2588,16.5599],[82.1415,16.4854],[81.7619,16.3295],[81.7117,16.3345],[81.4019,16.3652],[81.2861,16.3371],[81.2386,16.264],[81.1321,15.9618],[81.0301,15.8814],[80.9935,15.8087],[80.9787,15.7583],[80.9178,15.7597],[80.8647,15.7822],[80.826,15.7659],[80.7818,15.8673],[80.7078,15.8881],[80.6466,15.895],[80.3849,15.7928],[80.2935,15.7107],[80.1011,15.3236],[80.0534,15.074],[80.0986,14.7982],[80.1654,14.5778],[80.1787,14.4783],[80.1701,14.3494],[80.1362,14.2866],[80.1117,14.2122],[80.1437,14.0589],[80.2244,13.8582],[80.2441,13.7735],[80.2458,13.6858],[80.3065,13.4851],[80.2656,13.5213],[80.2334,13.6058],[80.1563,13.7138],[80.0621,13.6063],[80.1143,13.5287],[80.2903,13.4367],[80.3424,13.3613],[80.2291,12.6903],[80.1431,12.452],[80.0375,12.2958],[79.9817,12.2354],[79.8585,11.9888],[79.7714,11.6902],[79.7541,11.5753],[79.7934,11.4467],[79.7489,11.3706],[79.6932,11.3125],[79.799,11.3387],[79.8353,11.2688],[79.8486,11.1969],[79.8502,10.7688],[79.8382,10.3226],[79.7569,10.3043],[79.6674,10.2997],[79.5886,10.3124],[79.5316,10.3296],[79.3905,10.306],[79.3146,10.2567],[79.2536,10.1748],[79.2578,10.0352],[78.9963,9.6831],[78.9399,9.5658],[78.9191,9.4529],[78.9531,9.3938],[79.0199,9.3333],[79.107,9.3089],[79.2755,9.2846],[79.3563,9.2521],[79.4114,9.1924],[79.2129,9.256],[78.9796,9.2686],[78.4215,9.105],[78.2745,8.9902],[78.1925,8.8909],[78.136,8.6634],[78.1264,8.5113],[78.0602,8.3846],[77.7703,8.1898],[77.5872,8.1299],[77.5176,8.0783],[77.3015,8.1453],[77.0659,8.3159],[76.9669,8.4073],[76.6173,8.8471],[76.5534,8.9028],[76.4829,9.0908],[76.4718,9.1608],[76.4523,9.1888],[76.419,9.2078],[76.4031,9.2368],[76.3246,9.4521],[76.2924,9.6765],[76.2424,9.9271],[76.2847,9.9099],[76.3431,9.8273],[76.3723,9.7074],[76.3756,9.5399],[76.4195,9.5205],[76.4588,9.5362],[76.3465,9.9221],[76.2487,10.018],[76.2228,10.0243],[76.1956,10.0861],[76.1927,10.1638],[76.2015,10.2006],[76.1233,10.327],[76.0961,10.4022],[75.9226,10.7841],[75.8446,11.0576],[75.7238,11.3618],[75.6461,11.4684],[75.5245,11.7031],[75.4227,11.8122],[75.3146,11.9584],[75.2298,12.0233],[75.1967,12.0575],[74.9455,12.5646],[74.8683,12.8446],[74.8029,12.9769],[74.7705,13.0773],[74.6823,13.5069],[74.6816,13.5837],[74.6709,13.6676],[74.6085,13.8497],[74.4985,14.0463],[74.4667,14.1688],[74.467,14.2165],[74.3972,14.4074],[74.3822,14.4947],[74.3351,14.5754],[74.2804,14.6495],[74.223,14.7089],[74.0888,14.9022],[74.0406,14.9494],[73.9492,15.0748],[73.8843,15.3064],[73.8008,15.397],[73.9319,15.397],[73.852,15.4825],[73.8139,15.5386],[73.7718,15.573],[73.8328,15.6594],[73.7328,15.6569],[73.6799,15.7089],[73.6077,15.8711],[73.4761,16.0542],[73.4537,16.1521],[73.3376,16.4599],[73.2392,17.1985],[73.149,17.5274],[73.1561,17.6219],[73.0472,17.9067],[72.9939,18.0977],[72.9721,18.2593],[72.9432,18.3656],[72.9172,18.5761],[72.8755,18.6428],[72.8709,18.6831],[72.8987,18.779],[72.9769,18.9272],[73.0056,19.0211],[72.9721,19.1533],[72.9007,19.0145],[72.8347,18.9756],[72.803,19.0793],[72.8027,19.2188],[72.7945,19.2521],[72.8116,19.2989],[72.9872,19.2774],[72.7879,19.363],[72.764,19.4132],[72.7564,19.4505],[72.7994,19.5198],[72.7266,19.5783],[72.6975,19.7571],[72.676,19.7979],[72.6678,19.831],[72.709,20.078],[72.8812,20.5632],[72.8938,20.6728],[72.8789,20.8285],[72.8405,20.9525],[72.8243,21.0836],[72.8139,21.1172],[72.7516,21.1292],[72.6924,21.1776],[72.6238,21.372],[72.6865,21.4357],[72.7348,21.4708],[72.6684,21.4559],[72.6133,21.4618],[72.7176,21.5513],[72.8105,21.6199],[73.0225,21.6996],[73.1125,21.7504],[72.9791,21.7047],[72.8397,21.6873],[72.5431,21.6966],[72.5925,21.8776],[72.644,21.938],[72.7002,21.9719],[72.6175,21.9617],[72.5223,21.9762],[72.553,22.16],[72.6279,22.1996],[72.7088,22.2072],[72.8092,22.2333],[72.702,22.2636],[72.5901,22.2781],[72.456,22.2481],[72.3326,22.2702],[72.1828,22.2697],[72.2426,22.2452],[72.3064,22.1892],[72.2744,22.0897],[72.2443,22.0276],[72.1617,21.9848],[72.0944,21.92],[72.0756,21.863],[72.0372,21.823],[72.1029,21.7946],[72.1709,21.7743],[72.2104,21.7282],[72.2566,21.6612],[72.254,21.531],[72.0766,21.2241],[72.0152,21.1557],[71.5711,20.9706],[71.3965,20.8698],[71.0246,20.7389],[70.8797,20.7145],[70.7193,20.7404],[70.4851,20.8402],[70.1273,21.0947],[70.0344,21.1788],[69.7484,21.5057],[69.542,21.6786],[69.3854,21.8396],[69.1917,21.9915],[69.0088,22.1968],[68.9699,22.2903],[68.9835,22.3854],[69.0517,22.4373],[69.1313,22.4163],[69.1942,22.3361],[69.2389,22.3002],[69.2766,22.2855],[69.5492,22.4084],[69.6552,22.4035],[69.7275,22.4652],[69.819,22.4518],[70.0059,22.5477],[70.0842,22.5535],[70.1772,22.5728],[70.3277,22.8158],[70.4404,22.9703],[70.5135,23.0025],[70.5094,23.0401],[70.4893,23.0895],[70.4346,23.0771],[70.3963,23.0301],[70.368,22.9735],[70.3395,22.9397],[70.2512,22.9709],[70.1917,22.9657],[70.1183,22.947],[69.8498,22.8564],[69.7396,22.7752],[69.6646,22.7591],[69.2359,22.8485],[68.8171,23.0537],[68.6407,23.1899],[68.5292,23.3641],[68.4175,23.5715],[68.4538,23.6295],[68.6271,23.7542],[68.7768,23.8521],[68.6424,23.8085],[68.4969,23.748],[68.4249,23.7056],[68.3434,23.6168],[68.235,23.597],[68.192,23.7289],[68.165,23.8573],[68.2342,23.9005],[68.2825,23.928],[68.3813,23.9509],[68.4887,23.9672],[68.5866,23.9666],[68.7241,23.9647],[68.7281,24.2656],[68.7396,24.292],[68.759,24.3072],[68.7812,24.3137],[68.8,24.3091],[68.8283,24.264],[68.8635,24.2665],[68.9008,24.2924],[68.9846,24.2731],[69.0516,24.2863],[69.1195,24.2687],[69.2351,24.2683],[69.4435,24.2754],[69.5592,24.2731],[69.6342,24.2252],[69.7162,24.1726],[69.8052,24.1652],[69.9338,24.1714],[70.0211,24.1916],[70.0651,24.2406],[70.0982,24.2875],[70.2891,24.3563],[70.4893,24.4122],[70.5468,24.4183],[70.565,24.3858],[70.5559,24.3311],[70.5793,24.2791],[70.6595,24.2461],[70.7163,24.238],[70.7673,24.2454],[70.8051,24.262],[70.8862,24.3437],[70.9281,24.3624],[70.9828,24.361],[71.044,24.4001],[71.0453,24.43],[71.0063,24.4443],[70.9732,24.4874],[70.9793,24.5225],[70.9698,24.5719],[70.9764,24.6188],[71.0023,24.6539],[71.0479,24.6877],[71.0207,24.7577],[70.9509,24.8916],[70.8777,25.063],[70.8005,25.2059],[70.7025,25.3311],[70.6521,25.4229],[70.6572,25.6258],[70.6484,25.6669],[70.6148,25.6919],[70.5695,25.706],[70.5059,25.6853],[70.4485,25.6813],[70.3252,25.6857],[70.2646,25.7065],[70.1002,25.9101],[70.0786,25.99],[70.0777,26.072],[70.1326,26.2148],[70.1492,26.3476],[70.1568,26.4714],[70.1477,26.5064],[70.1146,26.548],[70.0594,26.5788],[69.9114,26.5861],[69.7359,26.6271],[69.6006,26.6991],[69.5069,26.7427],[69.4813,26.771],[69.47,26.8044],[69.4945,26.9542],[69.537,27.1229],[69.568,27.1746],[69.6216,27.2281],[69.6613,27.2645],[69.7248,27.3127],[69.8963,27.4736],[70.0498,27.6947],[70.1445,27.849],[70.1939,27.8949],[70.2443,27.9341],[70.3185,27.9816],[70.4037,28.025],[70.4886,28.0231],[70.5692,27.9838],[70.6291,27.9375],[70.6491,27.8354],[70.6916,27.769],[70.7374,27.729],[70.7979,27.7096],[70.8749,27.7145],[71.1848,27.8316],[71.2901,27.8553],[71.543,27.8699],[71.7167,27.9151],[71.8703,27.9625],[71.8889,28.0475],[71.948,28.1773],[72.1285,28.3463],[72.1792,28.4218],[72.2339,28.5658],[72.292,28.6973],[72.3419,28.7519],[72.6256,28.8961],[72.9033,29.0288],[72.9487,29.0888],[73.1283,29.3639],[73.2312,29.5506],[73.2578,29.6107],[73.3173,29.773],[73.3816,29.9344],[73.4675,29.9717],[73.658,30.0332],[73.8092,30.0934],[73.8865,30.162],[73.9334,30.2221],[73.9246,30.2816],[73.8827,30.3521],[73.8916,30.394],[73.8993,30.4354],[74.009,30.5197],[74.2156,30.769],[74.3394,30.8936],[74.3804,30.8934],[74.5098,30.9597],[74.6328,31.0347],[74.6258,31.0688],[74.6104,31.1128],[74.5397,31.1327],[74.5177,31.1856],[74.535,31.2614],[74.5939,31.4654],[74.5818,31.5239],[74.51,31.7129],[74.526,31.7651],[74.5556,31.8186],[74.6357,31.8897],[74.7395,31.9488],[75.0715,32.0894],[75.1388,32.1048],[75.2541,32.1403],[75.3247,32.2153],[75.3335,32.2792],[75.3026,32.3189],[75.2337,32.3721],[75.1041,32.4204],[74.9873,32.4622],[74.7889,32.4578],[74.6857,32.4938],[74.6578,32.5189],[74.6434,32.6077],[74.6633,32.7577],[74.6324,32.7709],[74.5883,32.7532],[74.4834,32.771],[74.3546,32.7687],[74.3055,32.8104],[74.33,32.8608],[74.3228,32.928],[74.3036,32.9918],[74.2836,33.0051],[74.2221,33.0203],[74.1263,33.0754],[74.0491,33.1434],[74.0038,33.1895],[73.9898,33.2212],[73.9942,33.2422],[74.0504,33.3013],[74.1178,33.3841],[74.1426,33.4554],[74.15,33.507],[74.1313,33.5451],[74.0697,33.5917],[74.004,33.6324],[73.9775,33.6678],[73.9765,33.7213],[74.001,33.7882],[74.0784,33.8387],[74.2156,33.8866],[74.2509,33.9461],[74.2465,33.9902],[74.209,34.0034],[74.1126,34.0037],[73.9499,34.0188],[73.9224,34.0431],[73.9041,34.0757],[73.9039,34.108],[73.9383,34.1448],[73.9795,34.1913],[73.9724,34.2366],[73.9246,34.2878],[73.81,34.3253],[73.7945,34.3782],[73.8121,34.4224],[73.8501,34.4853],[73.8831,34.5291],[73.9612,34.6535],[74.0559,34.6807],[74.172,34.7209],[74.3004,34.7654],[74.4979,34.732],[74.5941,34.7158],[74.7888,34.6777],[74.9519,34.6458],[75.1185,34.6368],[75.1875,34.639],[75.2641,34.6014],[75.4525,34.5367],[75.6056,34.5027],[75.7092,34.5031],[75.8621,34.5603],[75.9383,34.6125],[76.041,34.6699],[76.1725,34.6677],[76.4567,34.7561],[76.51,34.7409],[76.5944,34.7358],[76.6963,34.7869],[76.749,34.8476],[76.7575,34.8778],[76.7829,34.9002],[76.8917,34.9387],[77.0009,34.992],[77.0307,35.0624],[77.0486,35.1099],[77.1686,35.1715],[77.293,35.2355],[77.4234,35.3026],[77.5716,35.3788],[77.697,35.4433],[77.7994,35.4959],[77.8109,35.4845],[77.8516,35.4608],[77.8949,35.449],[77.9459,35.4716],[78.0095,35.4902],[78.0427,35.4798],[78.0475,35.4494],[78.0092,35.3069],[78.0122,35.251],[78.0758,35.1349],[78.1585,34.9465],[78.2361,34.7698],[78.282,34.6539],[78.327,34.6064],[78.5157,34.558],[78.6708,34.5182],[78.7631,34.4529],[78.8648,34.3903],[78.9364,34.352],[78.9701,34.3026],[78.977,34.2581],[78.9706,34.2282],[78.9317,34.189],[78.753,34.0877],[78.7317,34.0556],[78.7267,34.0134],[78.7617,33.8876],[78.7838,33.8088],[78.7899,33.6503],[78.8019,33.4997],[78.865,33.4311],[78.9167,33.3868],[78.9484,33.3465],[79.0126,33.2915],[79.0665,33.2504],[79.1125,33.2263],[79.1352,33.1719],[79.1217,33.1081],[79.1028,33.0525],[79.1086,33.0227],[79.1455,33.0015],[79.2022,32.946],[79.2096,32.8648],[79.2056,32.809],[79.2279,32.7588],[79.2339,32.7031],[79.2165,32.564],[79.2193,32.5011],[79.1699,32.4972],[79.1273,32.4758],[79.067,32.3882],[78.9977,32.3651],[78.9189,32.3582],[78.8379,32.412],[78.7713,32.4681],[78.7535,32.4993],[78.7367,32.5584],[78.7009,32.597],[78.6315,32.579],[78.5264,32.5708],[78.4125,32.5577],[78.3917,32.5447],[78.3896,32.5199],[78.4175,32.4667],[78.4413,32.3974],[78.4553,32.3003],[78.4861,32.2362],[78.4959,32.2158],[78.6777,32.023],[78.7256,31.9838],[78.7354,31.958],[78.7197,31.8876]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"India","sov_a3":"IND","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"India","adm0_a3":"IND","geou_dif":0,"geounit":"India","gu_a3":"IND","su_dif":0,"subunit":"India","su_a3":"IND","brk_diff":0,"name":"India","name_long":"India","brk_a3":"IND","brk_name":"India","brk_group":"","abbrev":"India","postal":"IND","formal_en":"Republic of India","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"India","name_alt":"","mapcolor7":1,"mapcolor8":3,"mapcolor9":2,"mapcolor13":2,"pop_est":1166079220,"gdp_md_est":3297000,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"3. Emerging region: BRIC","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"IN","iso_a3":"IND","iso_n3":"356","un_a3":"356","wb_a2":"IN","wb_a3":"IND","woe_id":-99,"adm0_a3_is":"IND","adm0_a3_us":"IND","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Southern Asia","region_wb":"South Asia","name_len":5,"long_len":5,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[96.9183,-12.1941],[96.9065,-12.1998],[96.8968,-12.1955],[96.8939,-12.1926],[96.893,-12.1872],[96.9044,-12.1865],[96.9134,-12.1818],[96.9189,-12.1733],[96.9205,-12.1615],[96.9253,-12.1732],[96.9243,-12.1847],[96.9183,-12.1941]],[[96.8404,-12.1818],[96.852,-12.1868],[96.8674,-12.1814],[96.8736,-12.1877],[96.8495,-12.1974],[96.8349,-12.1797],[96.8277,-12.1507],[96.8259,-12.1262],[96.8326,-12.1262],[96.8326,-12.136],[96.8342,-12.1441],[96.8395,-12.1603],[96.8356,-12.1713],[96.8404,-12.1818]],[[105.7254,-10.493],[105.6969,-10.5642],[105.6443,-10.525],[105.5841,-10.5125],[105.5957,-10.4597],[105.6455,-10.4522],[105.6698,-10.4494],[105.7055,-10.4307],[105.7254,-10.493]]]},"properties":{"scalerank":5,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Australia","sov_a3":"AU1","adm0_dif":1,"level":2,"type":"Dependency","admin":"Indian Ocean Territories","adm0_a3":"IOA","geou_dif":0,"geounit":"Indian Ocean Territories","gu_a3":"IOA","su_dif":0,"subunit":"Indian Ocean Territories","su_a3":"IOA","brk_diff":0,"name":"Indian Ocean Ter.","name_long":"Indian Ocean Territories","brk_a3":"IOA","brk_name":"Indian Ocean Ter.","brk_group":"","abbrev":"Ind. Oc. Ter.","postal":"IOT","formal_en":"","formal_fr":"","note_adm0":"Auz.","note_brk":"","name_sort":"Indian Ocean Territories","name_alt":"","mapcolor7":1,"mapcolor8":2,"mapcolor9":2,"mapcolor13":7,"pop_est":2069,"gdp_md_est":31.035,"pop_year":-99,"lastcensus":-99,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"-99","iso_a3":"-99","iso_n3":"-99","un_a3":"-099","wb_a2":"-99","wb_a3":"-99","woe_id":-99,"adm0_a3_is":"AUS","adm0_a3_us":"AUS","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Seven seas (open ocean)","subregion":"Seven seas (open ocean)","region_wb":"East Asia & Pacific","name_len":17,"long_len":24,"abbrev_len":13,"tiny":-99,"homepart":-99}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[9.4804,42.8054],[9.4542,42.6586],[9.4732,42.6156],[9.5094,42.5856],[9.5262,42.5526],[9.5564,42.1609],[9.5507,42.1297],[9.4284,41.9724],[9.4009,41.9262],[9.3948,41.7312],[9.3742,41.6788],[9.3309,41.6271],[9.2534,41.4601],[9.1861,41.3849],[9.003,41.4766],[8.895,41.5162],[8.8421,41.5589],[8.8075,41.5884],[8.8298,41.6277],[8.879,41.6686],[8.8868,41.7007],[8.771,41.7371],[8.718,41.7614],[8.7187,41.804],[8.7587,41.8704],[8.7404,41.9251],[8.6736,41.9224],[8.6219,41.9307],[8.6151,41.9591],[8.6534,41.9956],[8.7025,42.0431],[8.701,42.0956],[8.6416,42.1182],[8.5878,42.1608],[8.5662,42.2188],[8.6079,42.2584],[8.6755,42.284],[8.6259,42.3434],[8.5924,42.3447],[8.5656,42.3577],[8.5875,42.3853],[8.64,42.4266],[8.7131,42.5498],[8.8148,42.6079],[8.9949,42.6453],[9.0437,42.6617],[9.0884,42.705],[9.1379,42.7329],[9.198,42.7292],[9.2535,42.7125],[9.2877,42.6946],[9.3134,42.7132],[9.3384,42.7669],[9.323,42.8141],[9.331,42.9438],[9.3632,43.0174],[9.4152,43.0215],[9.4633,42.981],[9.4608,42.9452],[9.4786,42.8605],[9.4804,42.8054]],[[2.7594,50.7506],[2.8397,50.7118],[2.8624,50.716],[2.922,50.7271],[3.0229,50.7669],[3.1068,50.7794],[3.1549,50.7489],[3.182,50.7317],[3.235,50.6629],[3.2498,50.5912],[3.2733,50.5315],[3.3162,50.5074],[3.477,50.4995],[3.5954,50.4773],[3.6268,50.4573],[3.6673,50.3248],[3.6894,50.3061],[3.7188,50.3217],[3.748,50.3435],[3.7886,50.347],[3.8581,50.3386],[3.9497,50.3359],[4.0441,50.3213],[4.1746,50.2465],[4.1696,50.2218],[4.1441,50.1784],[4.1353,50.1438],[4.1577,50.1299],[4.1922,50.0941],[4.1839,50.0528],[4.1503,50.0239],[4.1368,50],[4.137,49.9845],[4.1493,49.9716],[4.1761,49.9603],[4.3688,49.945],[4.545,49.9603],[4.6562,50.0024],[4.6751,50.0469],[4.7066,50.0971],[4.7729,50.1391],[4.8187,50.1532],[4.8605,50.1359],[4.79,49.9596],[4.8415,49.9145],[4.8491,49.8471],[4.8676,49.7881],[4.9306,49.7893],[5.0069,49.7784],[5.061,49.7565],[5.1241,49.7215],[5.215,49.6893],[5.2788,49.6779],[5.302,49.651],[5.3535,49.6198],[5.4347,49.5545],[5.5073,49.5109],[5.5424,49.511],[5.6101,49.5282],[5.7104,49.5392],[5.7897,49.5383],[5.8234,49.5051],[5.9014,49.4897],[5.9289,49.4775],[5.9595,49.4546],[6.0114,49.4455],[6.0741,49.4546],[6.1199,49.4852],[6.1811,49.4989],[6.2422,49.4943],[6.2773,49.4775],[6.3443,49.4527],[6.3822,49.4582],[6.4581,49.4429],[6.5343,49.3947],[6.5663,49.3462],[6.5747,49.3197],[6.6076,49.2909],[6.7354,49.1606],[6.7763,49.1542],[6.8207,49.1739],[6.8495,49.202],[6.8912,49.2075],[6.9583,49.1946],[7.0015,49.1799],[7.0222,49.1234],[7.0367,49.1127],[7.0657,49.1249],[7.1174,49.1275],[7.1999,49.1136],[7.3134,49.1295],[7.4042,49.1531],[7.4506,49.1522],[7.5255,49.0864],[7.6109,49.0618],[7.7992,49.0419],[8.0013,49.0109],[8.0807,48.9859],[8.1349,48.9736],[8.1403,48.8864],[8.124,48.8733],[7.9228,48.6985],[7.838,48.636],[7.7948,48.5468],[7.7651,48.41],[7.7057,48.28],[7.6166,48.1568],[7.5842,48.0643],[7.6085,48.0026],[7.5933,47.9057],[7.5386,47.7736],[7.5294,47.6739],[7.5654,47.6065],[7.6156,47.5927],[7.4949,47.5474],[7.4674,47.5077],[7.42,47.4552],[7.3432,47.4331],[7.2657,47.4258],[7.2031,47.4327],[7.1675,47.4537],[7.1692,47.4732],[7.136,47.4898],[7.0534,47.4894],[6.9684,47.4532],[6.9004,47.3942],[6.9215,47.3612],[6.9841,47.3525],[7.0006,47.3395],[7.0006,47.3225],[6.9785,47.3021],[6.9521,47.2672],[6.8207,47.1632],[6.6881,47.0583],[6.6669,47.0265],[6.6248,47.0043],[6.4563,46.9483],[6.4386,46.9259],[6.429,46.8323],[6.4102,46.7554],[6.2852,46.6831],[6.1607,46.611],[6.1297,46.567],[6.107,46.5161],[6.068,46.4585],[6.0603,46.4282],[6.1232,46.3786],[6.1159,46.3376],[6.0959,46.2794],[6.0361,46.2381],[5.97,46.2147],[5.9715,46.1512],[6.0066,46.1423],[6.0866,46.147],[6.1994,46.1931],[6.2729,46.2522],[6.2296,46.3084],[6.2242,46.3194],[6.2347,46.3326],[6.3219,46.3937],[6.4289,46.4305],[6.5782,46.4374],[6.7581,46.4158],[6.7761,46.4066],[6.7674,46.3692],[6.7842,46.314],[6.8168,46.2752],[6.7721,46.1651],[6.8057,46.1307],[6.858,46.0894],[6.8973,46.0518],[6.9537,46.0171],[7.0039,45.9588],[7.0211,45.9258],[6.9408,45.8684],[6.8045,45.8146],[6.7892,45.7801],[6.7909,45.7409],[6.8063,45.71],[6.8814,45.6704],[6.9624,45.5806],[7.0137,45.5005],[7.1261,45.4237],[7.1534,45.4009],[7.1464,45.3817],[7.1168,45.349],[7.0783,45.2399],[7.0324,45.2226],[6.9813,45.2156],[6.8423,45.1356],[6.7804,45.1453],[6.6923,45.1443],[6.6277,45.118],[6.6348,45.0682],[6.6914,45.0226],[6.7247,44.973],[6.7382,44.9214],[6.8011,44.8832],[6.8894,44.8603],[6.9398,44.8587],[6.9729,44.845],[6.9927,44.8273],[7.0307,44.7167],[7.0079,44.689],[6.9604,44.6771],[6.9319,44.6316],[6.8752,44.5646],[6.843,44.5107],[6.8786,44.4633],[6.8938,44.4282],[6.8748,44.392],[6.9002,44.3357],[6.9673,44.28],[7.1494,44.2017],[7.3186,44.138],[7.3709,44.1274],[7.5994,44.1684],[7.6372,44.1648],[7.665,44.116],[7.6771,44.0832],[7.6515,44.0336],[7.5896,43.9654],[7.5227,43.9111],[7.482,43.8649],[7.4905,43.8229],[7.4932,43.7671],[7.4387,43.7504],[7.4369,43.7615],[7.4145,43.7709],[7.395,43.7653],[7.3801,43.7532],[7.3777,43.7317],[7.2615,43.6961],[7.1814,43.6591],[6.8647,43.4383],[6.7166,43.3736],[6.6874,43.3346],[6.6572,43.2617],[6.5702,43.1991],[6.494,43.1693],[6.3054,43.1387],[6.1159,43.0724],[6.0306,43.101],[5.8095,43.0979],[5.6716,43.1778],[5.4065,43.2285],[5.3202,43.3449],[5.1995,43.3525],[5.1204,43.349],[5.0731,43.3666],[5.0608,43.4063],[5.0598,43.4445],[4.976,43.427],[4.9119,43.427],[4.8737,43.4116],[4.8436,43.3939],[4.8079,43.4052],[4.7872,43.4014],[4.7891,43.3789],[4.7121,43.3733],[4.6287,43.3871],[4.4098,43.4472],[4.3762,43.4564],[4.2242,43.4796],[4.1628,43.5037],[4.1131,43.563],[4.0751,43.5818],[4.0526,43.5931],[3.9108,43.5631],[3.8616,43.5164],[3.7848,43.4616],[3.2589,43.1932],[3.1629,43.0808],[3.0518,42.9151],[3.0431,42.8379],[3.0909,42.5909],[3.1979,42.4612],[3.2114,42.4312],[3.1521,42.431],[3.0526,42.4472],[2.97,42.4672],[2.8914,42.4561],[2.8156,42.4292],[2.7494,42.413],[2.7019,42.4085],[2.67,42.393],[2.6548,42.3621],[2.6517,42.3405],[2.568,42.3458],[2.3744,42.3903],[2.2004,42.4209],[2.0983,42.3861],[2.0327,42.3535],[1.9865,42.3585],[1.9515,42.3928],[1.9279,42.4263],[1.8598,42.4571],[1.7061,42.5033],[1.714,42.5256],[1.7402,42.5567],[1.7395,42.5759],[1.7099,42.6044],[1.5682,42.635],[1.5014,42.6427],[1.4589,42.6217],[1.4283,42.5959],[1.3494,42.6907],[1.2933,42.71],[1.2083,42.7131],[1.1111,42.742],[1.0101,42.779],[0.7645,42.838],[0.6969,42.8451],[0.6698,42.8357],[0.6518,42.8004],[0.642,42.7006],[0.6316,42.6896],[0.5177,42.6863],[0.3772,42.7001],[0.3129,42.6933],[0.2555,42.6929],[0.2014,42.7193],[-0.0412,42.6891],[-0.0815,42.7039],[-0.14,42.7489],[-0.2053,42.7853],[-0.2561,42.804],[-0.2993,42.8253],[-0.3386,42.8288],[-0.3984,42.8081],[-0.4812,42.7993],[-0.5498,42.802],[-0.5864,42.799],[-0.7402,42.9095],[-0.7626,42.9398],[-0.8392,42.9482],[-0.9338,42.9495],[-1.1754,43.0211],[-1.2854,43.0596],[-1.3016,43.0825],[-1.3,43.101],[-1.3188,43.097],[-1.3527,43.0643],[-1.3705,43.0376],[-1.394,43.0326],[-1.4288,43.0368],[-1.4608,43.0518],[-1.4805,43.0711],[-1.4594,43.105],[-1.4226,43.1491],[-1.4073,43.1971],[-1.4107,43.2401],[-1.4717,43.2677],[-1.5615,43.2792],[-1.6271,43.2825],[-1.7128,43.307],[-1.7533,43.3247],[-1.7927,43.3726],[-1.794,43.4073],[-1.6314,43.438],[-1.4849,43.5638],[-1.346,44.0202],[-1.2455,44.5599],[-1.1708,44.6618],[-1.077,44.6898],[-1.1529,44.764],[-1.2004,44.7265],[-1.2203,44.6866],[-1.2452,44.6667],[-1.1891,45.1615],[-1.1491,45.3426],[-1.081,45.5324],[-0.9417,45.4571],[-0.8263,45.3807],[-0.7667,45.3144],[-0.6911,45.0935],[-0.634,45.0471],[-0.5485,45.0006],[-0.5823,45.0514],[-0.6411,45.0902],[-0.7331,45.3846],[-0.7908,45.468],[-0.8807,45.5382],[-1.17,45.6859],[-1.196,45.7145],[-1.21,45.7709],[-1.1144,45.7685],[-1.0317,45.7411],[-1.0415,45.7727],[-1.066,45.8057],[-1.1044,45.9253],[-1.1364,46.2048],[-1.132,46.2527],[-1.1463,46.3114],[-1.2388,46.3245],[-1.3128,46.3269],[-1.3925,46.3501],[-1.7865,46.5148],[-1.9214,46.6848],[-2.0594,46.8103],[-2.0925,46.865],[-2.0903,46.9205],[-2.0189,47.0376],[-2.0819,47.1116],[-2.1436,47.1263],[-2.1971,47.1629],[-2.1486,47.2239],[-2.1083,47.2629],[-2.0276,47.2736],[-1.9217,47.2606],[-1.8213,47.2253],[-1.7425,47.216],[-1.9754,47.3107],[-2.353,47.2788],[-2.4344,47.291],[-2.5031,47.3121],[-2.53,47.3816],[-2.4763,47.4129],[-2.4277,47.4709],[-2.4827,47.5116],[-2.5541,47.5271],[-2.6659,47.5262],[-2.7703,47.5139],[-2.7968,47.5373],[-2.7331,47.6018],[-2.7872,47.6255],[-2.8594,47.6145],[-2.9641,47.6011],[-3.0642,47.6213],[-3.1588,47.6947],[-3.2216,47.6941],[-3.2647,47.6851],[-3.3286,47.7133],[-3.3959,47.7204],[-3.4439,47.711],[-3.5078,47.7531],[-3.9009,47.8375],[-4.0707,47.8479],[-4.2264,47.8096],[-4.3121,47.8229],[-4.3751,47.8774],[-4.428,47.9689],[-4.6788,48.0395],[-4.6292,48.0858],[-4.5124,48.0967],[-4.3778,48.1288],[-4.3294,48.17],[-4.4346,48.218],[-4.5122,48.2297],[-4.5443,48.247],[-4.5771,48.29],[-4.5307,48.3097],[-4.4979,48.2993],[-4.4033,48.2931],[-4.2414,48.3037],[-4.3018,48.3471],[-4.3644,48.3567],[-4.3932,48.3676],[-4.5248,48.3723],[-4.5847,48.3575],[-4.7194,48.3631],[-4.7485,48.41],[-4.7625,48.4502],[-4.7208,48.5399],[-4.5312,48.62],[-4.0589,48.7075],[-3.8557,48.6947],[-3.7148,48.7105],[-3.546,48.7657],[-3.4715,48.8129],[-3.2314,48.8408],[-3.0032,48.7907],[-2.7929,48.6011],[-2.6923,48.5368],[-2.4462,48.6483],[-2.0794,48.645],[-2.0037,48.5821],[-1.9731,48.6351],[-1.9057,48.6971],[-1.852,48.6688],[-1.8247,48.6305],[-1.4376,48.6414],[-1.3765,48.6526],[-1.4805,48.6976],[-1.5655,48.8055],[-1.5831,49.2024],[-1.6903,49.3132],[-1.8134,49.4901],[-1.8701,49.5951],[-1.8754,49.6314],[-1.8564,49.6838],[-1.7051,49.681],[-1.5882,49.6677],[-1.3657,49.7073],[-1.2586,49.6802],[-1.2649,49.5982],[-1.2323,49.4949],[-1.195,49.4448],[-1.1385,49.3879],[-0.9591,49.3932],[-0.7655,49.3597],[-0.5209,49.3545],[-0.1635,49.2968],[-0.0112,49.3302],[0.1361,49.4015],[0.4169,49.4484],[0.4393,49.4732],[0.2776,49.4633],[0.1294,49.5084],[0.1094,49.5575],[0.1266,49.6016],[0.1867,49.703],[0.6162,49.8629],[0.9241,49.9102],[1.2455,49.9982],[1.4072,50.0885],[1.5141,50.2051],[1.5484,50.2307],[1.5928,50.2522],[1.5516,50.2939],[1.5795,50.7393],[1.6096,50.8195],[1.6723,50.885],[1.7677,50.9357],[1.9125,50.9906],[2.4457,51.0665],[2.5249,51.0971],[2.536,51.0495],[2.5748,50.9886],[2.6015,50.9553],[2.5793,50.9118],[2.5968,50.8759],[2.6691,50.8114],[2.7594,50.7506]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"France","sov_a3":"FR1","adm0_dif":1,"level":2,"type":"Country","admin":"France","adm0_a3":"FRA","geou_dif":0,"geounit":"France","gu_a3":"FRA","su_dif":0,"subunit":"France","su_a3":"FRA","brk_diff":0,"name":"France","name_long":"France","brk_a3":"FRA","brk_name":"France","brk_group":"","abbrev":"Fr.","postal":"F","formal_en":"French Republic","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"France","name_alt":"","mapcolor7":7,"mapcolor8":5,"mapcolor9":9,"mapcolor13":11,"pop_est":64057792,"gdp_md_est":2128000,"pop_year":-99,"lastcensus":-99,"gdp_year":-99,"economy":"1. Developed region: G7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"FR","iso_a3":"FRA","iso_n3":"250","un_a3":"250","wb_a2":"FR","wb_a3":"FRA","woe_id":-99,"adm0_a3_is":"FRA","adm0_a3_us":"FRA","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Western Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":6,"abbrev_len":3,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[17.6078,42.769],[17.7442,42.7003],[17.3441,42.7904],[17.3896,42.7986],[17.4319,42.8004],[17.6078,42.769]],[[16.6507,42.9966],[16.8355,42.9687],[16.9711,42.9815],[17.0937,42.9644],[17.1698,42.9326],[17.1883,42.917],[17.0894,42.9149],[16.9775,42.9278],[16.8507,42.8955],[16.7389,42.9127],[16.6964,42.9337],[16.6663,42.9599],[16.6507,42.9966]],[[17.2198,43.0259],[17.7236,42.8507],[17.6676,42.8971],[17.7402,42.9155],[17.802,42.9022],[17.8413,42.8451],[17.9188,42.8074],[18.0445,42.7413],[18.1239,42.6906],[18.304,42.5994],[18.3466,42.5867],[18.4363,42.5597],[18.4381,42.5229],[18.4767,42.4811],[18.5175,42.4329],[18.333,42.5279],[18.1606,42.634],[17.8238,42.7974],[17.585,42.8372],[17.2582,42.9685],[17.0454,43.0149],[17.1265,43.0256],[17.2198,43.0259]],[[17.194,43.1258],[17.1241,43.1154],[16.6792,43.1231],[16.5498,43.1439],[16.4059,43.1974],[16.3765,43.2138],[16.5214,43.2292],[16.656,43.2138],[16.6973,43.175],[17.0611,43.1439],[17.194,43.1258]],[[16.7853,43.2707],[16.6274,43.2681],[16.4903,43.2862],[16.4231,43.3172],[16.4281,43.3434],[16.4489,43.3871],[16.6016,43.3819],[16.8344,43.3508],[16.8913,43.3146],[16.8736,43.2979],[16.7853,43.2707]],[[15.3714,43.9738],[15.4372,43.8995],[15.3742,43.9148],[15.3086,43.9608],[15.27,44.0107],[15.3714,43.9738]],[[15.2311,44.0623],[15.2467,44.0271],[15.1219,44.0933],[15.0746,44.1378],[15.0658,44.1577],[15.2311,44.0623]],[[15.1888,43.9224],[15.203,43.9077],[15.2017,43.8978],[15.1498,43.9118],[15.1358,43.9073],[14.8913,44.1255],[14.865,44.168],[14.9525,44.1172],[15.1888,43.9224]],[[15.1885,44.3357],[15.1626,44.3092],[15.0979,44.3582],[15.0386,44.393],[14.9961,44.4343],[14.9128,44.4858],[14.8847,44.5447],[14.7604,44.6647],[14.7419,44.6974],[14.8038,44.6487],[14.8554,44.6183],[14.898,44.6108],[15.0064,44.5342],[15.113,44.4357],[15.2399,44.3502],[15.2136,44.3476],[15.1885,44.3357]],[[14.8314,44.7589],[14.8566,44.7148],[14.7625,44.7546],[14.6782,44.7699],[14.6604,44.7998],[14.6725,44.8244],[14.6905,44.8481],[14.7542,44.8448],[14.7638,44.8214],[14.8314,44.7589]],[[14.4881,44.6601],[14.4804,44.6212],[14.4195,44.6703],[14.3889,44.7583],[14.3124,44.9004],[14.3025,44.9404],[14.3422,44.9799],[14.34,45.02],[14.2858,45.1446],[14.3313,45.165],[14.3582,45.1674],[14.3691,45.081],[14.3938,45.0313],[14.4674,44.9702],[14.4525,44.8692],[14.4676,44.7253],[14.4825,44.6934],[14.4881,44.6601]],[[14.8103,44.9771],[14.687,44.9556],[14.6283,44.9939],[14.613,45.0254],[14.5117,45.0354],[14.4504,45.0792],[14.4379,45.0986],[14.5246,45.1468],[14.5711,45.2248],[14.63,45.178],[14.7012,45.09],[14.7392,45.0655],[14.8103,44.9771]],[[16.748,46.4164],[16.8715,46.3393],[16.9399,46.2537],[17.0327,46.1873],[17.1496,46.1403],[17.2422,46.0766],[17.3106,45.9961],[17.4063,45.9511],[17.5292,45.9413],[17.607,45.9138],[17.6396,45.8684],[17.7064,45.8272],[17.8071,45.7904],[17.9639,45.7703],[18.264,45.7655],[18.2906,45.7645],[18.3583,45.753],[18.4373,45.7673],[18.5336,45.7961],[18.5646,45.8133],[18.666,45.9075],[18.7218,45.8994],[18.833,45.9108],[18.9003,45.9317],[18.9054,45.9317],[18.9011,45.9076],[18.8936,45.8655],[18.8391,45.8357],[18.8945,45.7671],[18.9473,45.6558],[18.9179,45.6008],[18.9537,45.558],[19.0551,45.5272],[19.0643,45.515],[19.0333,45.5022],[19.0076,45.4658],[19.0047,45.3995],[19.0931,45.3369],[19.2729,45.278],[19.3303,45.2681],[19.3522,45.2454],[19.3823,45.2306],[19.4,45.2125],[19.401,45.1891],[19.3881,45.173],[19.303,45.1673],[19.206,45.1678],[19.1369,45.1962],[19.1308,45.1755],[19.1297,45.1517],[19.0629,45.1372],[19.1,44.9738],[19.0853,44.9268],[19.0605,44.911],[19.0376,44.9175],[19.0096,44.9194],[18.9955,44.904],[19.0071,44.8692],[18.9413,44.8652],[18.8364,44.8833],[18.7884,44.9149],[18.7802,44.9472],[18.7794,44.9772],[18.7461,45.0265],[18.6626,45.0774],[18.4883,45.0858],[18.4239,45.102],[18.3576,45.1206],[18.285,45.1343],[18.218,45.1329],[18.1372,45.1194],[17.9963,45.1418],[17.9486,45.1119],[17.8744,45.0772],[17.8128,45.0781],[17.6901,45.1584],[17.6535,45.1635],[17.5463,45.1226],[17.5026,45.1204],[17.4691,45.1333],[17.3241,45.164],[17.2587,45.1706],[17.2106,45.1561],[17.1254,45.1718],[16.9187,45.2766],[16.7908,45.1969],[16.5307,45.2167],[16.4535,45.162],[16.365,45.0583],[16.2934,45.0088],[16.2311,45.0266],[16.1573,45.0722],[16.0283,45.1896],[15.9632,45.2108],[15.8883,45.2157],[15.8229,45.2028],[15.7881,45.179],[15.7615,45.0075],[15.738,44.8564],[15.7366,44.7658],[15.8801,44.6819],[16.049,44.5376],[16.1034,44.521],[16.1303,44.4737],[16.1698,44.352],[16.2143,44.2151],[16.3001,44.1245],[16.3775,44.0596],[16.4721,44.0026],[16.5905,43.9132],[16.6877,43.815],[16.7135,43.7788],[16.9019,43.649],[17.0846,43.5166],[17.248,43.4702],[17.2738,43.4458],[17.2753,43.3438],[17.2931,43.3056],[17.4022,43.1989],[17.6248,43.0428],[17.6505,43.0066],[17.6578,42.9801],[17.6435,42.9598],[17.5852,42.9384],[17.5373,42.9623],[17.3299,43.1149],[17.1294,43.2111],[16.9031,43.3924],[16.6003,43.4641],[16.3939,43.5434],[16.2689,43.5313],[16.1311,43.5063],[16.046,43.5055],[15.9855,43.5198],[15.9426,43.5689],[15.9491,43.607],[15.9415,43.6566],[15.8206,43.7359],[15.6557,43.8113],[15.4994,43.9088],[15.1858,44.1721],[15.1229,44.2568],[15.1847,44.2729],[15.2313,44.2714],[15.2843,44.2888],[15.3697,44.2893],[15.471,44.272],[15.3813,44.3283],[15.2698,44.3835],[14.9813,44.6029],[14.8952,44.7066],[14.8853,44.8183],[14.9065,44.9714],[14.8546,45.081],[14.632,45.2229],[14.5505,45.2977],[14.3861,45.3421],[14.3127,45.3378],[14.2686,45.2825],[14.2363,45.1597],[14.0906,44.9976],[14.042,44.9272],[13.9658,44.8356],[13.8998,44.8293],[13.8607,44.8374],[13.7425,44.9915],[13.6293,45.1082],[13.6135,45.1634],[13.6033,45.2314],[13.5172,45.4818],[13.5779,45.5169],[13.6152,45.4768],[13.8787,45.4284],[13.9356,45.4498],[13.9701,45.4826],[13.9703,45.5034],[13.9928,45.5094],[14.0855,45.4778],[14.1612,45.4852],[14.283,45.4866],[14.3699,45.4814],[14.4273,45.5058],[14.5052,45.5952],[14.534,45.6453],[14.5688,45.6572],[14.5918,45.6513],[14.6086,45.6101],[14.6495,45.5715],[14.7336,45.5085],[14.7931,45.4782],[14.8471,45.4673],[14.9,45.4927],[14.9546,45.4999],[15.1104,45.4508],[15.2421,45.4414],[15.3395,45.467],[15.3267,45.5023],[15.2912,45.5416],[15.2836,45.5797],[15.2901,45.6126],[15.3569,45.6455],[15.3537,45.6599],[15.2729,45.7177],[15.2771,45.7326],[15.4541,45.7976],[15.6248,45.834],[15.6521,45.8622],[15.6681,45.9044],[15.6756,45.9837],[15.6662,46.0485],[15.5969,46.1092],[15.5926,46.14],[15.609,46.1719],[15.6359,46.2007],[15.7042,46.2132],[15.7843,46.234],[15.8476,46.2579],[15.9333,46.2776],[16.0007,46.3054],[16.0665,46.3713],[16.1064,46.3822],[16.2274,46.3729],[16.2533,46.3891],[16.2367,46.4838],[16.2584,46.5079],[16.3012,46.5214],[16.3212,46.5346],[16.4276,46.5244],[16.5162,46.4999],[16.5699,46.485],[16.748,46.4164]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Croatia","sov_a3":"HRV","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Croatia","adm0_a3":"HRV","geou_dif":0,"geounit":"Croatia","gu_a3":"HRV","su_dif":0,"subunit":"Croatia","su_a3":"HRV","brk_diff":0,"name":"Croatia","name_long":"Croatia","brk_a3":"HRV","brk_name":"Croatia","brk_group":"","abbrev":"Cro.","postal":"HR","formal_en":"Republic of Croatia","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Croatia","name_alt":"","mapcolor7":5,"mapcolor8":4,"mapcolor9":5,"mapcolor13":1,"pop_est":4489409,"gdp_md_est":82390,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"HR","iso_a3":"HRV","iso_n3":"191","un_a3":"191","wb_a2":"HR","wb_a3":"HRV","woe_id":-99,"adm0_a3_is":"HRV","adm0_a3_us":"HRV","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Southern Europe","region_wb":"Europe & Central Asia","name_len":7,"long_len":7,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[22.1318,48.4053],[22.2271,48.4134],[22.2312,48.4122],[22.2537,48.4074],[22.2694,48.3609],[22.2722,48.358],[22.2951,48.3273],[22.3167,48.2866],[22.3502,48.2561],[22.4238,48.2433],[22.5201,48.2054],[22.5824,48.134],[22.6764,48.1044],[22.6831,48.1036],[22.7016,48.107],[22.7691,48.1096],[22.7822,48.0952],[22.8362,48.0603],[22.8572,48.0295],[22.8465,47.9971],[22.8561,47.9603],[22.8767,47.9473],[22.8518,47.9226],[22.6768,47.799],[22.6084,47.7663],[22.5629,47.7596],[22.4914,47.7726],[22.4175,47.7626],[22.3515,47.7362],[22.2906,47.7278],[22.2446,47.6964],[22.1851,47.6291],[22.1119,47.572],[22.038,47.5366],[21.9997,47.505],[21.9953,47.3957],[21.9543,47.3643],[21.8992,47.3326],[21.8693,47.3046],[21.7854,47.1381],[21.7218,47.0848],[21.6614,47.0439],[21.6515,47.0065],[21.6526,46.9638],[21.5842,46.8784],[21.4944,46.7897],[21.4771,46.7534],[21.4971,46.7043],[21.411,46.6479],[21.3613,46.6208],[21.3202,46.6078],[21.2945,46.5725],[21.2522,46.4864],[21.2633,46.4478],[21.2646,46.4123],[21.1918,46.3916],[21.1704,46.3527],[21.152,46.3043],[21.1217,46.2824],[21.0398,46.2422],[20.837,46.2597],[20.7603,46.2462],[20.7374,46.2175],[20.7327,46.1944],[20.7074,46.1728],[20.661,46.1457],[20.6137,46.1335],[20.5081,46.1669],[20.281,46.133],[20.2418,46.1086],[20.2102,46.126],[20.1614,46.1419],[19.9341,46.1615],[19.8444,46.1459],[19.7245,46.1519],[19.6135,46.1692],[19.5308,46.1552],[19.4575,46.0874],[19.4213,46.0645],[19.3929,46.0498],[19.3303,46.0285],[19.2781,46.0029],[19.2084,45.9844],[19.1463,45.987],[19.0873,46.0162],[19.0662,46.0095],[19.0477,45.9827],[19.0157,45.9597],[18.9278,45.9314],[18.9054,45.9317],[18.9003,45.9317],[18.833,45.9108],[18.7218,45.8994],[18.666,45.9075],[18.5646,45.8133],[18.5336,45.7961],[18.4373,45.7673],[18.3583,45.753],[18.2906,45.7645],[18.264,45.7655],[17.9639,45.7703],[17.8071,45.7904],[17.7064,45.8272],[17.6396,45.8684],[17.607,45.9138],[17.5292,45.9413],[17.4063,45.9511],[17.3106,45.9961],[17.2422,46.0766],[17.1496,46.1403],[17.0327,46.1873],[16.9399,46.2537],[16.8715,46.3393],[16.748,46.4164],[16.5699,46.485],[16.5162,46.4999],[16.5057,46.5221],[16.4185,46.6072],[16.3813,46.6387],[16.3846,46.6808],[16.3672,46.7048],[16.3354,46.7216],[16.3185,46.7825],[16.3085,46.828],[16.2836,46.8573],[16.0931,46.8633],[16.2525,46.9719],[16.3318,47.0022],[16.4239,46.997],[16.4534,47.0068],[16.4612,47.0225],[16.477,47.0579],[16.4848,47.0913],[16.4927,47.1227],[16.4828,47.1404],[16.4384,47.1459],[16.4169,47.2234],[16.4397,47.2527],[16.4626,47.2731],[16.4344,47.3674],[16.4429,47.3995],[16.5147,47.4045],[16.5744,47.4247],[16.623,47.4476],[16.6366,47.4766],[16.6766,47.536],[16.6397,47.6089],[16.4321,47.6563],[16.4213,47.6745],[16.4696,47.6951],[16.5211,47.7245],[16.551,47.7474],[16.5909,47.7505],[16.6475,47.739],[16.7476,47.6863],[16.7859,47.6787],[16.823,47.694],[16.8627,47.6973],[16.9734,47.6953],[17.0666,47.7076],[17.0456,47.7638],[17.0459,47.8045],[17.0301,47.8371],[17.0399,47.8729],[17.0777,47.9009],[17.0891,47.9636],[17.1474,48.006],[17.1746,48.0121],[17.2772,48.0043],[17.3016,47.9934],[17.3173,47.9909],[17.4807,47.8876],[17.6353,47.8099],[17.7619,47.7702],[17.9479,47.7669],[18.1456,47.7634],[18.4763,47.777],[18.7242,47.7872],[18.7406,47.8065],[18.778,47.8529],[18.7483,47.8927],[18.7501,47.9395],[18.7919,48.0003],[18.9142,48.0508],[19.2651,48.073],[19.467,48.1107],[19.4975,48.1621],[19.5643,48.2128],[19.6254,48.2231],[19.7092,48.1998],[19.8101,48.155],[19.8986,48.1313],[19.9504,48.1466],[20.1286,48.222],[20.3338,48.2956],[20.475,48.4951],[20.49,48.5269],[20.6432,48.5497],[20.8666,48.5457],[20.9812,48.5197],[21.0673,48.5059],[21.1964,48.5106],[21.3824,48.5535],[21.4514,48.5522],[21.5047,48.5219],[21.5632,48.4957],[21.6026,48.4637],[21.6325,48.4185],[21.6486,48.4015],[21.6746,48.3784],[21.7215,48.3466],[21.767,48.3381],[22.1113,48.3934],[22.1318,48.4053]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Hungary","sov_a3":"HUN","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Hungary","adm0_a3":"HUN","geou_dif":0,"geounit":"Hungary","gu_a3":"HUN","su_dif":0,"subunit":"Hungary","su_a3":"HUN","brk_diff":0,"name":"Hungary","name_long":"Hungary","brk_a3":"HUN","brk_name":"Hungary","brk_group":"","abbrev":"Hun.","postal":"HU","formal_en":"Republic of Hungary","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Hungary","name_alt":"","mapcolor7":4,"mapcolor8":6,"mapcolor9":1,"mapcolor13":5,"pop_est":9905596,"gdp_md_est":196600,"pop_year":-99,"lastcensus":2001,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"HU","iso_a3":"HUN","iso_n3":"348","un_a3":"348","wb_a2":"HU","wb_a3":"HUN","woe_id":-99,"adm0_a3_is":"HUN","adm0_a3_us":"HUN","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Eastern Europe","region_wb":"Europe & Central Asia","name_len":7,"long_len":7,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[120.2613,73.0898],[120.0079,73.0449],[119.7921,73.0454],[119.6404,73.1243],[119.7619,73.1555],[119.9645,73.1677],[120.0785,73.1567],[120.2368,73.1073],[120.2613,73.0898]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Russia","sov_a3":"RUS","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Russia","adm0_a3":"RUS","geou_dif":0,"geounit":"Russia","gu_a3":"RUS","su_dif":0,"subunit":"Russia","su_a3":"RUS","brk_diff":0,"name":"Russia","name_long":"Russian Federation","brk_a3":"RUS","brk_name":"Russia","brk_group":"","abbrev":"Rus.","postal":"RUS","formal_en":"Russian Federation","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Russian Federation","name_alt":"","mapcolor7":2,"mapcolor8":5,"mapcolor9":7,"mapcolor13":7,"pop_est":140041247,"gdp_md_est":2266000,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"3. Emerging region: BRIC","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"RU","iso_a3":"RUS","iso_n3":"643","un_a3":"643","wb_a2":"RU","wb_a3":"RUS","woe_id":-99,"adm0_a3_is":"RUS","adm0_a3_us":"RUS","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Eastern Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":18,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[124.543,73.8501],[124.4817,73.8479],[124.3664,73.8746],[124.3357,73.9103],[124.3365,73.9284],[124.4297,73.943],[124.5477,73.9338],[124.6369,73.9004],[124.6529,73.888],[124.543,73.8501]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Russia","sov_a3":"RUS","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Russia","adm0_a3":"RUS","geou_dif":0,"geounit":"Russia","gu_a3":"RUS","su_dif":0,"subunit":"Russia","su_a3":"RUS","brk_diff":0,"name":"Russia","name_long":"Russian Federation","brk_a3":"RUS","brk_name":"Russia","brk_group":"","abbrev":"Rus.","postal":"RUS","formal_en":"Russian Federation","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Russian Federation","name_alt":"","mapcolor7":2,"mapcolor8":5,"mapcolor9":7,"mapcolor13":7,"pop_est":140041247,"gdp_md_est":2266000,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"3. Emerging region: BRIC","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"RU","iso_a3":"RUS","iso_n3":"643","un_a3":"643","wb_a2":"RU","wb_a3":"RUS","woe_id":-99,"adm0_a3_is":"RUS","adm0_a3_us":"RUS","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Eastern Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":18,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[111.3893,2.4153],[111.3587,2.4022],[111.3115,2.4376],[111.3004,2.7412],[111.3335,2.7683],[111.3551,2.7645],[111.3783,2.7093],[111.3763,2.5763],[111.3805,2.4589],[111.3893,2.4153]],[[104.2216,2.7317],[104.1733,2.7213],[104.1469,2.7282],[104.1291,2.7672],[104.1698,2.8568],[104.1848,2.8717],[104.2232,2.7742],[104.2216,2.7317]],[[101.3186,2.9885],[101.2681,2.9704],[101.2654,2.9965],[101.2742,3.0328],[101.3112,3.0674],[101.3284,3.0476],[101.3186,2.9885]],[[117.8848,4.1861],[117.7454,4.1669],[117.649,4.169],[117.6668,4.204],[117.6621,4.2502],[117.708,4.2624],[117.7614,4.2523],[117.8848,4.1861]],[[100.289,5.2947],[100.2638,5.267],[100.191,5.2829],[100.2039,5.4469],[100.2455,5.4678],[100.3102,5.4379],[100.3389,5.4101],[100.289,5.2947]],[[99.848,6.4657],[99.9187,6.3586],[99.8834,6.3108],[99.8658,6.2971],[99.8232,6.3127],[99.7826,6.2716],[99.7438,6.2633],[99.7047,6.3375],[99.6566,6.3671],[99.6463,6.4184],[99.7105,6.4273],[99.7492,6.4096],[99.8217,6.445],[99.848,6.4657]],[[100.5639,6.4675],[100.6295,6.448],[100.7156,6.4807],[100.7545,6.4601],[100.7938,6.4262],[100.8165,6.3316],[100.8739,6.2454],[100.9888,6.2577],[101.0294,6.2453],[101.0535,6.2426],[101.076,6.1661],[101.0865,6.0337],[101.0756,5.9565],[100.9928,5.8462],[100.9816,5.771],[101.0252,5.7245],[101.0817,5.6749],[101.114,5.6368],[101.1477,5.6431],[101.1906,5.6687],[101.2298,5.7337],[101.257,5.7894],[101.4042,5.8517],[101.5561,5.9078],[101.5768,5.902],[101.6014,5.8771],[101.65,5.796],[101.6784,5.7788],[101.7195,5.7706],[101.7907,5.7793],[101.8736,5.8253],[101.9172,5.9114],[101.9361,5.9793],[102.0552,6.0967],[102.0684,6.1847],[102.1011,6.2422],[102.274,6.2034],[102.3401,6.172],[102.5344,5.8625],[102.7902,5.6449],[102.8985,5.5638],[102.9824,5.525],[103.0971,5.4084],[103.197,5.2622],[103.4158,4.8503],[103.4539,4.6695],[103.4688,4.3933],[103.4205,3.9769],[103.362,3.7691],[103.3733,3.6711],[103.4535,3.5206],[103.4295,3.3786],[103.445,3.2606],[103.4395,2.9331],[103.4852,2.8366],[103.5373,2.7748],[103.8122,2.5805],[103.8323,2.5085],[103.9678,2.2612],[104.2186,1.7229],[104.2885,1.4807],[104.2804,1.4156],[104.2501,1.3886],[104.1764,1.3649],[104.1149,1.4123],[104.0942,1.4462],[104.1006,1.4883],[104.0762,1.5298],[104.016,1.5793],[103.9814,1.6236],[103.9912,1.55],[103.9915,1.4548],[103.9151,1.4467],[103.8168,1.4766],[103.6945,1.4497],[103.5498,1.3328],[103.4803,1.3295],[103.4273,1.4298],[103.4,1.4979],[103.3568,1.5461],[102.8969,1.7923],[102.7271,1.8556],[102.5482,2.0424],[102.1456,2.2485],[101.8899,2.4494],[101.7813,2.5736],[101.5197,2.6836],[101.4068,2.8135],[101.3514,2.839],[101.2955,2.8852],[101.3543,3.0111],[101.3302,3.1425],[101.2999,3.2533],[101.1154,3.472],[101.0248,3.6247],[100.8513,3.7767],[100.7818,3.8645],[100.7154,3.9662],[100.757,4.0018],[100.7955,4.0234],[100.7603,4.0972],[100.661,4.2257],[100.6146,4.3734],[100.6146,4.6522],[100.4734,5.0443],[100.3526,5.5877],[100.374,5.778],[100.3433,5.9842],[100.2633,6.1825],[100.1584,6.3242],[100.1191,6.442],[100.138,6.4887],[100.1612,6.6416],[100.1768,6.6718],[100.2166,6.6866],[100.2614,6.6827],[100.3454,6.5499],[100.5639,6.4675]],[[116.8077,6.6911],[116.7881,6.6061],[116.8124,6.6079],[116.9133,6.6597],[117.0186,6.7974],[117.0779,6.9168],[117.1285,6.9689],[117.2299,6.94],[117.2524,6.9192],[117.2453,6.8334],[117.255,6.7834],[117.294,6.6769],[117.3804,6.6123],[117.4992,6.5715],[117.6097,6.5126],[117.6457,6.4737],[117.6696,6.4268],[117.6938,6.35],[117.6956,6.2723],[117.6159,6.1965],[117.6498,6.0736],[117.6445,6.0019],[117.6172,5.9407],[117.5012,5.8847],[117.8177,5.9404],[117.8958,5.9723],[118.0038,6.0533],[118.0617,5.9834],[118.1158,5.8625],[118.0723,5.8321],[117.9348,5.7875],[117.928,5.7692],[117.9736,5.7062],[118.0312,5.7121],[118.1446,5.7542],[118.2491,5.8206],[118.2998,5.8197],[118.3531,5.8061],[118.4563,5.7634],[118.5142,5.7289],[118.5631,5.6845],[118.5948,5.5921],[118.7137,5.5585],[118.9573,5.429],[119.0025,5.4178],[119.05,5.4152],[119.1784,5.4309],[119.2234,5.4126],[119.2556,5.3659],[119.2663,5.3081],[119.2628,5.2459],[119.2497,5.1987],[119.2196,5.1598],[119.1322,5.1005],[118.9125,5.0229],[118.6721,4.9641],[118.5514,4.9681],[118.3818,5.0185],[118.32,5.012],[118.2605,4.9889],[118.1854,4.8285],[118.3242,4.6687],[118.5625,4.5021],[118.5951,4.4606],[118.5863,4.4097],[118.5483,4.3792],[118.498,4.3624],[118.3641,4.3357],[118.2287,4.316],[118.1173,4.2876],[118.0082,4.2502],[117.8956,4.2629],[117.741,4.3375],[117.6965,4.3428],[117.6498,4.3045],[117.6038,4.2],[117.5744,4.1706],[117.5373,4.1714],[117.4509,4.1929],[117.2775,4.2993],[117.1006,4.3371],[116.8436,4.3401],[116.6979,4.355],[116.6387,4.3391],[116.5891,4.3384],[116.5531,4.3599],[116.5147,4.3708],[116.4146,4.3082],[116.3677,4.3273],[116.3203,4.3537],[116.2362,4.3625],[116.1345,4.3552],[116.0216,4.2907],[115.8962,4.3487],[115.8607,4.348],[115.8368,4.3333],[115.7824,4.2538],[115.6788,4.193],[115.6275,4.082],[115.5961,3.9755],[115.5685,3.9388],[115.5609,3.7331],[115.5445,3.6337],[115.5707,3.5023],[115.5661,3.4458],[115.5199,3.3617],[115.5143,3.3424],[115.4897,3.2086],[115.4991,3.1731],[115.4932,3.1281],[115.4544,3.0343],[115.3842,3.0087],[115.3102,2.9939],[115.247,3.0259],[115.1899,2.9745],[115.1176,2.8949],[115.0863,2.8411],[115.0865,2.7912],[115.0937,2.7578],[115.0789,2.7234],[115.0771,2.687],[115.0808,2.6342],[115.1299,2.6124],[115.1809,2.5669],[115.1791,2.5232],[115.1508,2.4929],[115.0865,2.4461],[114.9691,2.3508],[114.8363,2.2694],[114.7864,2.2505],[114.7684,2.2129],[114.7587,2.1624],[114.788,2.0516],[114.8158,2.0189],[114.8306,1.98],[114.8127,1.9338],[114.8,1.8939],[114.7511,1.869],[114.7035,1.8508],[114.6861,1.819],[114.6609,1.6863],[114.6322,1.617],[114.5675,1.5142],[114.5459,1.4671],[114.5125,1.452],[114.3871,1.5],[114.2747,1.4709],[114.126,1.4523],[114,1.4553],[113.9023,1.4343],[113.8353,1.3799],[113.7604,1.3114],[113.6816,1.2606],[113.6223,1.2359],[113.5132,1.3084],[113.4582,1.3021],[113.359,1.3271],[113.1263,1.4081],[113.0687,1.4318],[113.0065,1.4339],[112.9883,1.4571],[112.998,1.4962],[112.9883,1.5476],[112.943,1.567],[112.4762,1.5591],[112.3416,1.5147],[112.2507,1.4796],[112.1857,1.4391],[112.1674,1.3382],[112.1286,1.2436],[112.0785,1.1434],[111.9231,1.1133],[111.809,1.0117],[111.7697,0.9995],[111.6913,1.0142],[111.6074,1.0226],[111.5467,0.9943],[111.4832,0.9958],[111.2867,1.0432],[111.1014,1.0505],[110.9961,1.0264],[110.9381,1.0173],[110.6147,0.8781],[110.5058,0.862],[110.4614,0.8821],[110.399,0.9391],[110.3152,0.996],[110.1147,1.1901],[110.0408,1.2357],[109.9917,1.2826],[109.9449,1.338],[109.8785,1.3979],[109.8181,1.439],[109.7357,1.5229],[109.654,1.6149],[109.6358,1.7767],[109.5708,1.8063],[109.5489,1.8483],[109.539,1.8962],[109.6289,2.0275],[109.6943,1.8888],[109.7196,1.8578],[109.8648,1.7645],[109.9846,1.7176],[110.1141,1.6986],[110.2459,1.6947],[110.2983,1.7012],[110.3492,1.7197],[110.3995,1.6999],[110.6752,1.548],[110.782,1.5208],[110.8949,1.5325],[110.9399,1.5173],[111.0984,1.4009],[111.1452,1.387],[111.2232,1.3958],[111.1234,1.449],[111.058,1.4867],[111.0287,1.5578],[111.0466,1.6336],[111.1102,1.6841],[111.1542,1.7388],[111.17,1.9023],[111.198,1.9851],[111.2509,2.0639],[111.2682,2.1397],[111.2089,2.1977],[111.1955,2.2972],[111.2086,2.3796],[111.2422,2.4357],[111.2959,2.3988],[111.3514,2.3645],[111.4062,2.3679],[111.4438,2.3815],[111.4508,2.4241],[111.4404,2.4981],[111.4433,2.6343],[111.5125,2.743],[111.6232,2.818],[111.7277,2.8538],[112.1188,2.9147],[112.7373,3.0705],[112.9205,3.1307],[112.9879,3.1619],[113.0447,3.2052],[113.1402,3.3435],[113.3201,3.5615],[113.4461,3.7406],[113.7121,4.0014],[113.9239,4.2432],[113.9525,4.2887],[113.9878,4.4207],[113.9904,4.4828],[113.9843,4.5458],[114.0125,4.5752],[114.0536,4.5929],[114.0639,4.5927],[114.0951,4.5652],[114.1688,4.527],[114.2241,4.4779],[114.261,4.4143],[114.2876,4.3547],[114.2896,4.3042],[114.3229,4.2628],[114.4166,4.2559],[114.4471,4.2036],[114.5122,4.1136],[114.5718,4.0491],[114.6083,4.024],[114.6541,4.0376],[114.725,4.0965],[114.7762,4.1688],[114.8104,4.2665],[114.7835,4.2808],[114.8311,4.3545],[114.8402,4.3932],[114.8183,4.4288],[114.7901,4.4639],[114.7793,4.553],[114.76,4.6665],[114.7467,4.7181],[114.7842,4.7548],[114.8646,4.8018],[114.9447,4.8563],[115.0268,4.8997],[115.0288,4.8211],[115.0268,4.6914],[115.0516,4.5827],[115.107,4.3904],[115.1706,4.3642],[115.2467,4.3472],[115.2906,4.3526],[115.3192,4.3653],[115.3268,4.3808],[115.2793,4.4563],[115.2667,4.634],[115.2279,4.7506],[115.1685,4.8667],[115.14,4.8998],[115.3749,4.9328],[115.4276,4.9692],[115.5198,5.0489],[115.5545,5.0936],[115.582,5.1941],[115.4669,5.2541],[115.4217,5.3305],[115.419,5.4132],[115.5564,5.5667],[115.6039,5.6034],[115.6245,5.5489],[115.6851,5.5351],[115.7408,5.533],[115.7969,5.5361],[115.8771,5.6135],[115.9185,5.725],[116.0598,5.8824],[116.1101,6.0033],[116.1384,6.1295],[116.4947,6.5217],[116.5383,6.5827],[116.7498,6.9771],[116.7762,6.9902],[116.833,6.9521],[116.8498,6.8267],[116.842,6.7721],[116.8077,6.6911]],[[117.1416,7.1682],[117.0807,7.1153],[117.0602,7.1789],[117.0643,7.2607],[117.1469,7.337],[117.2641,7.3517],[117.2808,7.2906],[117.2668,7.2208],[117.2394,7.1848],[117.1416,7.1682]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Malaysia","sov_a3":"MYS","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Malaysia","adm0_a3":"MYS","geou_dif":0,"geounit":"Malaysia","gu_a3":"MYS","su_dif":0,"subunit":"Malaysia","su_a3":"MYS","brk_diff":0,"name":"Malaysia","name_long":"Malaysia","brk_a3":"MYS","brk_name":"Malaysia","brk_group":"","abbrev":"Malay.","postal":"MY","formal_en":"Malaysia","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Malaysia","name_alt":"","mapcolor7":2,"mapcolor8":4,"mapcolor9":3,"mapcolor13":6,"pop_est":25715819,"gdp_md_est":384300,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"6. Developing region","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"MY","iso_a3":"MYS","iso_n3":"458","un_a3":"458","wb_a2":"MY","wb_a3":"MYS","woe_id":-99,"adm0_a3_is":"MYS","adm0_a3_us":"MYS","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"South-Eastern Asia","region_wb":"East Asia & Pacific","name_len":8,"long_len":8,"abbrev_len":6,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[14.5662,35.8527],[14.5327,35.8202],[14.4364,35.8217],[14.3523,35.8723],[14.3513,35.9784],[14.4483,35.9574],[14.537,35.8863],[14.5662,35.8527]],[[14.3135,36.0276],[14.2536,36.0122],[14.1942,36.0422],[14.1804,36.0604],[14.2633,36.0758],[14.3037,36.0623],[14.3209,36.0362],[14.3135,36.0276]]]},"properties":{"scalerank":3,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Malta","sov_a3":"MLT","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Malta","adm0_a3":"MLT","geou_dif":0,"geounit":"Malta","gu_a3":"MLT","su_dif":0,"subunit":"Malta","su_a3":"MLT","brk_diff":0,"name":"Malta","name_long":"Malta","brk_a3":"MLT","brk_name":"Malta","brk_group":"","abbrev":"Malta","postal":"M","formal_en":"Republic of Malta","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Malta","name_alt":"","mapcolor7":1,"mapcolor8":4,"mapcolor9":1,"mapcolor13":8,"pop_est":405165,"gdp_md_est":9962,"pop_year":-99,"lastcensus":2005,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"MT","iso_a3":"MLT","iso_n3":"470","un_a3":"470","wb_a2":"MT","wb_a3":"MLT","woe_id":-99,"adm0_a3_is":"MLT","adm0_a3_us":"MLT","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Southern Europe","region_wb":"Middle East & North Africa","name_len":5,"long_len":5,"abbrev_len":5,"tiny":3,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[22.344,42.314],[22.4982,42.1651],[22.5827,42.1048],[22.6823,42.0591],[22.7961,42.0257],[22.8368,41.9936],[22.9092,41.8352],[22.9439,41.7751],[22.992,41.7572],[23.0036,41.7398],[23.0057,41.7169],[22.9515,41.6056],[22.9297,41.3561],[22.916,41.3363],[22.8593,41.3374],[22.7839,41.332],[22.7551,41.3127],[22.7248,41.1785],[22.6036,41.1402],[22.4936,41.1185],[22.4008,41.1234],[22.2377,41.1552],[22.1845,41.1586],[22.1389,41.1405],[21.9934,41.131],[21.9295,41.1074],[21.7795,40.9504],[21.6275,40.8963],[21.5758,40.8689],[21.4597,40.9036],[21.4041,40.9072],[21.3237,40.8671],[21.1476,40.8631],[21.1,40.8562],[20.9643,40.8499],[20.9586,40.8715],[20.9335,40.9031],[20.8702,40.9179],[20.7408,40.9053],[20.7093,40.9284],[20.6561,41.0617],[20.6145,41.0831],[20.5679,41.1278],[20.489,41.2726],[20.487,41.3361],[20.4924,41.3914],[20.4486,41.5213],[20.4756,41.5541],[20.5162,41.5748],[20.5166,41.6271],[20.5052,41.7065],[20.5531,41.8624],[20.5662,41.8737],[20.5785,41.8662],[20.6949,41.8538],[20.725,41.8735],[20.7441,41.9043],[20.7504,42.0184],[20.7781,42.071],[21.0598,42.1713],[21.1425,42.175],[21.2061,42.129],[21.2563,42.0995],[21.2866,42.1004],[21.2976,42.1301],[21.3317,42.1872],[21.3896,42.2198],[21.5608,42.2477],[21.5625,42.2475],[21.6183,42.2421],[21.7393,42.2677],[21.8146,42.3031],[21.853,42.3084],[21.9041,42.3221],[21.9775,42.3201],[22.0521,42.3046],[22.1467,42.325],[22.2397,42.3582],[22.2771,42.3499],[22.3174,42.3217],[22.344,42.314]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Macedonia","sov_a3":"MKD","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Macedonia","adm0_a3":"MKD","geou_dif":0,"geounit":"Macedonia","gu_a3":"MKD","su_dif":0,"subunit":"Macedonia","su_a3":"MKD","brk_diff":0,"name":"Macedonia","name_long":"Macedonia","brk_a3":"MKD","brk_name":"Macedonia","brk_group":"","abbrev":"Mkd.","postal":"MK","formal_en":"Former Yugoslav Republic of Macedonia","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Macedonia, FYR","name_alt":"","mapcolor7":5,"mapcolor8":3,"mapcolor9":7,"mapcolor13":3,"pop_est":2066718,"gdp_md_est":18780,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"6. Developing region","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"MK","iso_a3":"MKD","iso_n3":"807","un_a3":"807","wb_a2":"MK","wb_a3":"MKD","woe_id":-99,"adm0_a3_is":"MKD","adm0_a3_us":"MKD","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Southern Europe","region_wb":"Europe & Central Asia","name_len":9,"long_len":9,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[116.6833,49.8238],[116.5897,49.6848],[116.4021,49.4062],[116.2434,49.1704],[116.1597,49.0375],[116.0982,48.9361],[116.0344,48.84],[116.0255,48.7823],[115.9538,48.6894],[115.8205,48.5772],[115.7917,48.4557],[115.7966,48.3463],[115.7855,48.2482],[115.6395,48.1862],[115.5251,48.1309],[115.5576,47.945],[115.6164,47.8748],[115.7117,47.7989],[115.8117,47.7382],[115.8982,47.6869],[115.9938,47.7113],[116.0748,47.7896],[116.2312,47.8582],[116.3172,47.8599],[116.3782,47.844],[116.5135,47.8396],[116.652,47.8645],[116.7605,47.8698],[116.9012,47.8531],[116.9517,47.8366],[117.0697,47.8064],[117.1971,47.7403],[117.2859,47.6664],[117.3508,47.6522],[117.384,47.6757],[117.4551,47.7414],[117.5554,47.8047],[117.6767,47.9083],[117.7684,47.9879],[117.8404,47.9999],[117.9792,47.9996],[118.0419,48.0189],[118.1471,48.0289],[118.2396,47.9995],[118.4984,47.984],[118.5678,47.9433],[118.6905,47.8223],[118.76,47.7576],[118.8803,47.7251],[118.9531,47.7029],[119.0176,47.6854],[119.0819,47.6542],[119.0973,47.6163],[119.1229,47.5585],[119.1624,47.5252],[119.2353,47.4926],[119.2908,47.4727],[119.3086,47.4307],[119.326,47.4102],[119.3767,47.3809],[119.527,47.2559],[119.6002,47.2225],[119.7111,47.15],[119.7572,47.09],[119.7599,47.027],[119.7885,46.9788],[119.8627,46.9066],[119.8979,46.8578],[119.8842,46.7915],[119.8959,46.7329],[119.8672,46.6722],[119.7475,46.6272],[119.7066,46.606],[119.6202,46.604],[119.474,46.6267],[119.3318,46.6138],[119.1621,46.6387],[119.0285,46.6922],[118.9571,46.7349],[118.8439,46.7602],[118.7903,46.7471],[118.7229,46.6919],[118.6487,46.7017],[118.5805,46.6919],[118.4044,46.7032],[118.3087,46.717],[118.1568,46.6786],[118.0713,46.6666],[117.9104,46.6193],[117.8135,46.5377],[117.7412,46.5182],[117.6711,46.5221],[117.6205,46.552],[117.5469,46.5883],[117.4381,46.5862],[117.4056,46.5709],[117.3922,46.5376],[117.3563,46.4367],[117.3569,46.3913],[117.3334,46.362],[117.269,46.3522],[117.156,46.3551],[116.9788,46.3618],[116.8591,46.3879],[116.787,46.3767],[116.6889,46.322],[116.6193,46.3131],[116.5626,46.2898],[116.5167,46.2091],[116.4448,46.1588],[116.3576,46.0966],[116.2646,45.963],[116.213,45.8869],[116.2291,45.8458],[116.2406,45.796],[116.1977,45.7394],[116.1099,45.6867],[116.0396,45.677],[115.9342,45.6262],[115.7892,45.5348],[115.6811,45.4583],[115.5395,45.4395],[115.4395,45.42],[115.2175,45.3962],[115.1626,45.3902],[114.9192,45.3783],[114.7388,45.4196],[114.6443,45.4133],[114.5602,45.39],[114.5172,45.3646],[114.5022,45.3163],[114.4873,45.2717],[114.4191,45.2026],[114.2811,45.1109],[114.1674,45.0499],[114.0803,44.9711],[114.0303,44.9426],[113.9309,44.9123],[113.8771,44.8962],[113.7521,44.8259],[113.6526,44.7635],[113.587,44.7457],[113.5079,44.7624],[113.4557,44.7674],[113.301,44.7917],[113.1961,44.7948],[113.0494,44.8104],[112.7067,44.8834],[112.5968,44.9177],[112.4993,45.0109],[112.4113,45.0582],[112.2921,45.063],[112.1129,45.0629],[112.0326,45.0816],[111.898,45.0641],[111.7511,44.9695],[111.6814,44.8992],[111.6213,44.8271],[111.5475,44.6729],[111.5147,44.5698],[111.4895,44.5116],[111.4109,44.4192],[111.4022,44.3673],[111.4296,44.3224],[111.4862,44.2716],[111.5197,44.1919],[111.6026,44.1071],[111.6838,44.0411],[111.8369,43.9347],[111.8803,43.8789],[111.9317,43.8149],[111.9429,43.7524],[111.9332,43.7114],[111.8781,43.6802],[111.7711,43.6646],[111.7197,43.6211],[111.6408,43.5632],[111.5474,43.4963],[111.5035,43.4928],[111.4511,43.4749],[111.1868,43.392],[111.0865,43.3688],[111.0072,43.3414],[110.9133,43.2569],[110.8396,43.1941],[110.7485,43.1108],[110.7086,43.0739],[110.6275,42.9905],[110.5209,42.8953],[110.4617,42.8441],[110.4296,42.8136],[110.4004,42.7737],[110.2889,42.7427],[110.1969,42.71],[110.058,42.6606],[109.8588,42.6062],[109.698,42.5538],[109.5955,42.5105],[109.4432,42.456],[109.3398,42.4384],[109.1316,42.4406],[108.8745,42.4265],[108.6873,42.4161],[108.5465,42.4293],[108.334,42.4368],[108.1712,42.4473],[108.0623,42.4272],[107.806,42.4059],[107.7487,42.401],[107.2924,42.3493],[107.0907,42.3215],[106.9061,42.3089],[106.77,42.2887],[106.6932,42.2636],[106.5791,42.2273],[106.5188,42.2116],[106.3172,42.1406],[105.8676,41.994],[105.5664,41.8751],[105.5171,41.8547],[105.3144,41.7709],[105.1971,41.738],[105.1154,41.6633],[105.0506,41.6159],[104.982,41.5955],[104.8604,41.6438],[104.7736,41.6412],[104.4982,41.6587],[104.4982,41.877],[104.3052,41.8461],[103.9973,41.797],[103.7111,41.7513],[103.4497,41.8559],[103.2479,41.9366],[103.0729,42.006],[102.8068,42.052],[102.5752,42.0921],[102.1566,42.1581],[101.9729,42.2159],[101.8799,42.2923],[101.7139,42.4658],[101.66,42.5],[101.5791,42.5235],[101.4953,42.5388],[101.3138,42.5379],[101.092,42.5513],[100.7726,42.5878],[100.519,42.6168],[100.0863,42.6708],[99.9838,42.6773],[99.7574,42.6294],[99.4679,42.5682],[98.9469,42.6162],[98.7163,42.6387],[98.2482,42.6845],[97.7189,42.7363],[97.2057,42.7898],[96.833,42.7603],[96.6253,42.7438],[96.3854,42.7204],[96.3523,42.7468],[96.3425,42.8493],[96.2995,42.9287],[96.1685,43.0145],[96.0803,43.0961],[95.9125,43.2065],[95.8596,43.276],[95.842,43.3837],[95.6873,43.6641],[95.5912,43.8536],[95.5672,43.8922],[95.5256,43.954],[95.4713,43.9862],[95.3564,44.006],[95.3256,44.0394],[95.3256,44.1049],[95.3437,44.1954],[95.3668,44.2615],[95.3503,44.2781],[95.0498,44.2594],[94.866,44.3033],[94.712,44.3508],[94.4943,44.4725],[94.3647,44.5195],[94.1993,44.6452],[93.9579,44.675],[93.8682,44.7242],[93.7553,44.8319],[93.6564,44.901],[93.5162,44.9445],[93.2943,44.9832],[92.916,45.0202],[92.7879,45.0357],[92.5789,45.011],[92.4238,45.0089],[92.1727,45.0353],[92.0298,45.0685],[91.8528,45.0693],[91.7378,45.0689],[91.5844,45.0765],[91.5101,45.0982],[91.441,45.1248],[91.3121,45.1181],[91.2218,45.1445],[91.1377,45.1939],[91.05,45.2174],[90.9536,45.2159],[90.914,45.1939],[90.8772,45.1961],[90.8532,45.2629],[90.7632,45.3707],[90.7496,45.4189],[90.6944,45.4747],[90.6618,45.5252],[90.6707,45.5952],[90.7097,45.7308],[90.7959,45.8535],[90.8524,45.8854],[90.8871,45.9216],[90.9598,45.9851],[91.0018,46.0358],[90.9968,46.105],[90.9476,46.1773],[90.9115,46.2707],[90.9183,46.3243],[90.9715,46.388],[91.0339,46.529],[91.0289,46.5661],[91.0043,46.5958],[90.9979,46.6611],[90.9857,46.749],[90.9105,46.8833],[90.8699,46.9545],[90.799,46.9852],[90.7155,47.0039],[90.6434,47.1003],[90.5529,47.214],[90.4962,47.2852],[90.4765,47.3288],[90.4675,47.4082],[90.4252,47.5041],[90.3807,47.5566],[90.3475,47.597],[90.3307,47.6552],[90.3133,47.6762],[90.191,47.7021],[90.1032,47.7454],[90.0666,47.8036],[90.0539,47.8505],[90.0279,47.8777],[89.9587,47.8863],[89.9104,47.8443],[89.8313,47.8233],[89.7781,47.827],[89.7256,47.8525],[89.6932,47.8792],[89.6385,47.9091],[89.5609,48.004],[89.4792,48.0291],[89.3299,48.0249],[89.1963,47.9809],[89.1156,47.9877],[89.0477,48.0025],[88.9711,48.05],[88.9178,48.089],[88.8383,48.1017],[88.6818,48.1706],[88.576,48.2202],[88.5668,48.3174],[88.5171,48.3845],[88.414,48.4034],[88.31,48.4721],[88.1582,48.5091],[88.0626,48.5378],[87.9797,48.5551],[87.9674,48.5811],[87.9723,48.6033],[88.0106,48.6404],[88.0502,48.675],[88.0601,48.7072],[88.0279,48.7356],[87.9422,48.7653],[87.8318,48.7917],[87.8092,48.8357],[87.7432,48.8816],[87.7547,48.9186],[87.8068,48.9455],[87.8599,48.9655],[87.8722,49.0001],[87.8347,49.0319],[87.8163,49.0803],[87.8252,49.1163],[87.8143,49.1623],[87.8183,49.1621],[87.9348,49.1646],[87.9881,49.1869],[88.0285,49.2198],[88.1157,49.2563],[88.1343,49.2984],[88.1355,49.3815],[88.1926,49.4517],[88.3378,49.4726],[88.3934,49.4829],[88.4524,49.4727],[88.5443,49.4826],[88.6332,49.4861],[88.6827,49.4646],[88.7479,49.4462],[88.8316,49.4484],[88.8604,49.4815],[88.8639,49.5276],[88.9002,49.5397],[88.9454,49.5077],[88.9706,49.4837],[89.0084,49.4728],[89.1095,49.5014],[89.18,49.5322],[89.2029,49.5957],[89.2439,49.6271],[89.2992,49.6111],[89.3956,49.6115],[89.475,49.6605],[89.5792,49.6997],[89.6541,49.7175],[89.6695,49.7505],[89.6343,49.8233],[89.6438,49.903],[89.7442,49.9481],[89.878,49.9535],[89.9773,49.9843],[90.005,50.0693],[90.0537,50.0938],[90.1037,50.1033],[90.2245,50.1167],[90.3113,50.1512],[90.3648,50.1669],[90.5169,50.2133],[90.6551,50.2224],[90.7144,50.2594],[90.7607,50.306],[90.8381,50.3237],[90.9172,50.3642],[91.0216,50.4155],[91.0628,50.4226],[91.2338,50.4524],[91.3006,50.4634],[91.3408,50.4701],[91.415,50.468],[91.4465,50.5222],[91.5217,50.562],[91.5969,50.5755],[91.6342,50.6151],[91.7063,50.6655],[91.8043,50.6936],[91.9565,50.6976],[92.104,50.692],[92.1924,50.7006],[92.2653,50.7752],[92.279,50.8122],[92.2958,50.8498],[92.3548,50.8642],[92.4264,50.8031],[92.4864,50.7651],[92.5789,50.7254],[92.6267,50.6883],[92.6813,50.6832],[92.7387,50.7109],[92.7793,50.7787],[92.8564,50.7891],[92.9413,50.7782],[92.9636,50.7449],[92.9707,50.7125],[93.0099,50.6545],[93.1031,50.6039],[93.2226,50.6065],[93.2705,50.6156],[93.3868,50.6085],[93.5011,50.5975],[93.6256,50.5855],[93.662,50.5837],[93.7954,50.5776],[93.9898,50.5688],[94.0758,50.5729],[94.2511,50.5564],[94.287,50.5114],[94.3193,50.4049],[94.3469,50.3034],[94.3547,50.2218],[94.4002,50.1796],[94.4585,50.1657],[94.4969,50.1328],[94.5646,50.0879],[94.6147,50.0237],[94.6755,50.0281],[94.7181,50.0433],[94.8112,50.0482],[94.9303,50.0437],[95.0129,50.0083],[95.0443,49.9616],[95.1114,49.9354],[95.1662,49.9438],[95.3295,49.9441],[95.3856,49.9412],[95.4418,49.9155],[95.5227,49.9112],[95.5672,49.9438],[95.7078,49.966],[95.7894,50.0125],[95.852,50.0129],[95.8994,49.9906],[95.9357,49.96],[95.9896,49.9736],[96.0186,49.9988],[96.0655,49.9987],[96.1117,49.9825],[96.2297,49.9541],[96.315,49.9011],[96.3812,49.896],[96.4664,49.9115],[96.5058,49.9187],[96.5433,49.8925],[96.5984,49.8784],[96.6402,49.8979],[96.7117,49.9116],[96.9857,49.8828],[97.0491,49.8299],[97.0977,49.805],[97.1369,49.7617],[97.2086,49.7308],[97.3598,49.7415],[97.4184,49.773],[97.5408,49.8431],[97.5894,49.9115],[97.651,49.9336],[97.7207,49.9446],[97.7855,49.9445],[97.8539,49.9468],[97.9366,49.9968],[98.0039,50.0143],[98.1034,50.0778],[98.122,50.1066],[98.1701,50.1806],[98.2,50.2277],[98.2503,50.3024],[98.2773,50.423],[98.2927,50.487],[98.2795,50.5333],[98.2205,50.5572],[98.145,50.5686],[98.0789,50.6038],[98.0298,50.6446],[98.0012,50.7021],[97.9619,50.7691],[97.9642,50.8177],[97.9531,50.8552],[97.9198,50.8872],[97.8562,50.9434],[97.8253,50.9853],[97.8357,51.0517],[97.9108,51.1652],[97.9179,51.2179],[97.9273,51.2507],[97.9232,51.2805],[97.9469,51.3484],[97.9892,51.3771],[98.0376,51.45],[98.1031,51.4835],[98.1847,51.4857],[98.2199,51.5056],[98.2375,51.5784],[98.2769,51.6346],[98.3031,51.6743],[98.3527,51.7176],[98.6405,51.8012],[98.7602,51.9051],[98.8025,51.9575],[98.8486,52.0701],[98.8932,52.1173],[98.9581,52.1017],[99.0343,52.0354],[99.0914,52.0349],[99.1762,51.9989],[99.407,51.9235],[99.5323,51.8999],[99.6129,51.8925],[99.7192,51.8716],[99.7879,51.8275],[99.9217,51.7555],[100.0346,51.7371],[100.2304,51.7298],[100.4689,51.7261],[100.5362,51.7135],[100.7107,51.6616],[100.9036,51.6042],[101.0854,51.553],[101.2232,51.5133],[101.3045,51.4748],[101.3813,51.4526],[101.4644,51.4715],[101.5709,51.4672],[101.8212,51.421],[101.9792,51.3822],[102.1115,51.3535],[102.1557,51.3138],[102.1601,51.2608],[102.1424,51.2161],[102.152,51.1075],[102.1945,51.0507],[102.2103,50.9743],[102.2262,50.9015],[102.215,50.8294],[102.2351,50.7912],[102.2766,50.7687],[102.3166,50.7185],[102.3033,50.6655],[102.2857,50.6347],[102.2884,50.5851],[102.3364,50.5442],[102.4068,50.5362],[102.4694,50.5257],[102.5463,50.4613],[102.6833,50.3872],[102.7654,50.3666],[102.8597,50.3333],[103.0395,50.3006],[103.1617,50.2907],[103.2338,50.2643],[103.3044,50.2003],[103.4212,50.1871],[103.4963,50.1649],[103.6329,50.1386],[103.7232,50.1539],[103.8026,50.1761],[103.8562,50.1718],[103.9585,50.1573],[104.0787,50.1542],[104.1797,50.1694],[104.26,50.2145],[104.3539,50.2753],[104.4663,50.3062],[104.5964,50.3172],[104.6854,50.3418],[104.977,50.3829],[105.0947,50.3899],[105.1859,50.4296],[105.2667,50.4605],[105.3836,50.4737],[105.5416,50.4413],[105.6926,50.4142],[105.8752,50.4054],[105.9965,50.3679],[106.0825,50.3326],[106.2179,50.3046],[106.3685,50.3176],[106.5744,50.3288],[106.7111,50.3126],[106.8537,50.2483],[106.9413,50.1967],[107.0402,50.0865],[107.1431,50.033],[107.2333,49.9894],[107.3471,49.9867],[107.631,49.9831],[107.7868,49.96],[107.9166,49.9478],[107.9479,49.9247],[107.9349,49.849],[107.9388,49.7407],[107.9367,49.691],[107.9654,49.6535],[108.0096,49.6469],[108.0338,49.594],[108.098,49.5626],[108.2131,49.5248],[108.4069,49.3964],[108.5225,49.3415],[108.6137,49.3228],[108.733,49.3356],[108.9199,49.3354],[109.2367,49.3349],[109.4537,49.2963],[109.5287,49.2699],[109.7504,49.2393],[109.9945,49.2056],[110.1999,49.1704],[110.3214,49.2159],[110.4278,49.22],[110.5296,49.1871],[110.6311,49.1376],[110.7098,49.143],[110.8279,49.1662],[111.2042,49.3043],[111.3366,49.3559],[111.4293,49.3426],[111.5119,49.3609],[111.5748,49.3764],[111.7355,49.3978],[111.8334,49.4036],[111.9345,49.416],[112.0797,49.4242],[112.3752,49.5146],[112.4949,49.5323],[112.6974,49.5073],[112.8064,49.5236],[112.9148,49.5692],[113.0556,49.6163],[113.0921,49.6925],[113.1642,49.7972],[113.319,49.8743],[113.4455,49.9416],[113.5742,50.007],[113.7324,50.0615],[113.8812,50.1011],[114.0707,50.2047],[114.2218,50.2573],[114.2971,50.2744],[114.3863,50.2555],[114.554,50.2415],[114.6749,50.2457],[114.7432,50.2337],[114.8796,50.1831],[115.0033,50.1386],[115.098,50.0594],[115.2745,49.9489],[115.365,49.9118],[115.4292,49.8965],[115.588,49.886],[115.7178,49.8806],[115.7952,49.9059],[115.926,49.9521],[116.1346,50.0108],[116.2168,50.0093],[116.3512,49.9781],[116.5512,49.9203],[116.6315,49.8771],[116.6833,49.8238]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Mongolia","sov_a3":"MNG","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Mongolia","adm0_a3":"MNG","geou_dif":0,"geounit":"Mongolia","gu_a3":"MNG","su_dif":0,"subunit":"Mongolia","su_a3":"MNG","brk_diff":0,"name":"Mongolia","name_long":"Mongolia","brk_a3":"MNG","brk_name":"Mongolia","brk_group":"","abbrev":"Mong.","postal":"MN","formal_en":"Mongolia","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Mongolia","name_alt":"","mapcolor7":3,"mapcolor8":5,"mapcolor9":5,"mapcolor13":6,"pop_est":3041142,"gdp_md_est":9476,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"6. Developing region","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"MN","iso_a3":"MNG","iso_n3":"496","un_a3":"496","wb_a2":"MN","wb_a3":"MNG","woe_id":-99,"adm0_a3_is":"MNG","adm0_a3_us":"MNG","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Eastern Asia","region_wb":"East Asia & Pacific","name_len":8,"long_len":8,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[19.1943,43.5333],[19.1916,43.521],[19.1965,43.485],[19.2188,43.45],[19.2982,43.414],[19.4146,43.3428],[19.5516,43.2123],[19.6145,43.1734],[19.671,43.164],[19.7812,43.1098],[19.858,43.0965],[19.944,43.0816],[20.1679,42.9685],[20.2685,42.9354],[20.3399,42.8929],[20.3477,42.8528],[20.3443,42.8279],[20.2151,42.7988],[20.1926,42.7546],[20.13,42.7598],[20.0543,42.7601],[20.0295,42.732],[20.0657,42.6858],[20.0893,42.6315],[20.0703,42.5571],[20.064,42.5473],[20.0457,42.5499],[19.9391,42.5067],[19.8598,42.4863],[19.7883,42.4762],[19.7545,42.4969],[19.7378,42.5251],[19.7407,42.6069],[19.7278,42.6345],[19.7034,42.6479],[19.6545,42.6286],[19.5975,42.5654],[19.5445,42.4919],[19.4651,42.4154],[19.3996,42.3419],[19.329,42.2493],[19.2807,42.1726],[19.3309,42.1293],[19.3614,42.0691],[19.3521,42.024],[19.3611,41.9978],[19.3455,41.9188],[19.3424,41.8691],[19.1864,41.9486],[19.1223,42.0605],[18.8942,42.2495],[18.6329,42.3781],[18.619,42.3984],[18.6334,42.4231],[18.6459,42.4427],[18.5916,42.4442],[18.5535,42.4285],[18.5175,42.4329],[18.4767,42.4811],[18.4381,42.5229],[18.4363,42.5597],[18.4539,42.5645],[18.4801,42.5792],[18.535,42.6201],[18.5459,42.6416],[18.5433,42.6742],[18.466,42.7772],[18.4551,42.8441],[18.4438,42.9685],[18.4602,42.9979],[18.4885,43.0122],[18.6236,43.0277],[18.6219,43.1246],[18.63,43.1537],[18.6568,43.1939],[18.6742,43.2308],[18.7492,43.2835],[18.8511,43.3463],[18.8956,43.3482],[18.9347,43.3395],[18.9787,43.2854],[19.0267,43.2924],[19.0367,43.3573],[18.9738,43.4424],[18.9402,43.4967],[18.9507,43.5267],[18.9742,43.5423],[19.0283,43.5325],[19.0801,43.5177],[19.1128,43.5277],[19.1644,43.5354],[19.1943,43.5333]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Montenegro","sov_a3":"MNE","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Montenegro","adm0_a3":"MNE","geou_dif":0,"geounit":"Montenegro","gu_a3":"MNE","su_dif":0,"subunit":"Montenegro","su_a3":"MNE","brk_diff":0,"name":"Montenegro","name_long":"Montenegro","brk_a3":"MNE","brk_name":"Montenegro","brk_group":"","abbrev":"Mont.","postal":"ME","formal_en":"Montenegro","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Montenegro","name_alt":"","mapcolor7":4,"mapcolor8":1,"mapcolor9":4,"mapcolor13":5,"pop_est":672180,"gdp_md_est":6816,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"6. Developing region","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"ME","iso_a3":"MNE","iso_n3":"499","un_a3":"499","wb_a2":"ME","wb_a3":"MNE","woe_id":-99,"adm0_a3_is":"MNE","adm0_a3_us":"MNE","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Southern Europe","region_wb":"Europe & Central Asia","name_len":10,"long_len":10,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[98.1826,9.9334],[98.1344,9.8754],[98.1181,9.8779],[98.1402,9.9747],[98.2207,10.0452],[98.2917,10.0513],[98.2834,10.0076],[98.2313,9.954],[98.1826,9.9334]],[[98.2098,10.9527],[98.2935,10.7797],[98.2844,10.7531],[98.2715,10.7399],[98.2518,10.7444],[98.2182,10.8377],[98.1554,10.8979],[98.0805,10.8866],[98.1426,10.9631],[98.1673,10.9803],[98.2098,10.9527]],[[98.5417,10.9615],[98.5189,10.9594],[98.498,10.9643],[98.4774,10.9797],[98.5266,11.087],[98.5417,10.9615]],[[98.2217,11.4782],[98.2162,11.4558],[98.2094,11.4565],[98.1873,11.4724],[98.2011,11.5672],[98.2391,11.6447],[98.2781,11.7584],[98.2996,11.783],[98.3075,11.7229],[98.2838,11.5941],[98.2633,11.5236],[98.2217,11.4782]],[[98.5538,11.7449],[98.5284,11.5387],[98.4648,11.5672],[98.4348,11.5671],[98.3969,11.6835],[98.3995,11.7148],[98.3765,11.7915],[98.5235,11.8049],[98.5538,11.7449]],[[98.0755,11.6924],[98.0836,11.6368],[98.0211,11.6959],[98.0104,11.8603],[98.0596,11.7567],[98.0808,11.7332],[98.0755,11.6924]],[[98.516,11.905],[98.4743,11.8994],[98.4545,12.0613],[98.4662,12.0843],[98.5253,12.0052],[98.6096,11.9566],[98.5765,11.9251],[98.516,11.905]],[[98.1367,12.1504],[98.1251,12.1449],[98.1085,12.1481],[98.0754,12.1645],[98.0373,12.2325],[98.0573,12.2801],[98.0714,12.2918],[98.1049,12.2878],[98.1225,12.2787],[98.1284,12.2612],[98.1185,12.2234],[98.1201,12.1913],[98.1367,12.1504]],[[98.0661,12.3898],[98.0604,12.3535],[98.0023,12.279],[97.9518,12.3223],[97.9387,12.3461],[97.9902,12.3938],[98.0451,12.387],[98.0599,12.3979],[98.0661,12.3898]],[[98.414,12.5979],[98.4364,12.5705],[98.4683,12.5713],[98.4595,12.4737],[98.3809,12.3537],[98.3345,12.3362],[98.3139,12.336],[98.3314,12.5114],[98.3025,12.6116],[98.3121,12.6782],[98.3965,12.6471],[98.414,12.5979]],[[98.3154,13.0991],[98.3092,12.9347],[98.2593,13.014],[98.2508,13.1044],[98.2546,13.1886],[98.2653,13.2022],[98.2686,13.1894],[98.2986,13.1517],[98.3154,13.0991]],[[94.8049,15.8193],[94.7844,15.7938],[94.7434,15.8121],[94.7335,15.823],[94.828,15.933],[94.8382,15.8921],[94.8049,15.8193]],[[94.4768,15.9459],[94.4119,15.8484],[94.3879,15.9941],[94.4938,16.0753],[94.546,16.1528],[94.6013,16.2055],[94.6187,16.1413],[94.5661,16.0193],[94.4768,15.9459]],[[97.575,16.2532],[97.5372,16.2401],[97.4804,16.3057],[97.4691,16.461],[97.5164,16.4969],[97.542,16.5051],[97.579,16.486],[97.5933,16.4608],[97.5996,16.4295],[97.5894,16.3974],[97.575,16.2532]],[[93.6908,18.6843],[93.674,18.6757],[93.5699,18.7596],[93.4875,18.8675],[93.6183,18.8888],[93.7447,18.8655],[93.7455,18.8081],[93.7184,18.7157],[93.6908,18.6843]],[[93.7148,19.5583],[93.8295,19.4753],[93.8747,19.4811],[93.9457,19.4286],[93.9475,19.4082],[93.934,19.3654],[93.902,19.332],[93.8152,19.2987],[93.7559,19.3257],[93.7323,19.4163],[93.6622,19.4589],[93.644,19.4951],[93.6884,19.5444],[93.7148,19.5583]],[[93.4918,19.8926],[93.5133,19.7548],[93.4446,19.8064],[93.4195,19.8776],[93.4129,19.9503],[93.4918,19.8926]],[[93.0102,19.9239],[93.0232,19.8289],[92.9752,19.868],[92.9127,19.9998],[92.9146,20.0865],[92.9596,20.0462],[93.0102,19.9239]],[[97.7301,28.4071],[97.769,28.3562],[97.8165,28.3563],[97.8649,28.3636],[97.8876,28.3565],[97.9341,28.3138],[98.0223,28.2115],[98.0616,28.1859],[98.0989,28.1423],[98.1184,28.0552],[98.1305,27.9676],[98.241,27.6632],[98.2742,27.5991],[98.2988,27.5501],[98.3505,27.5381],[98.3924,27.5871],[98.4089,27.6395],[98.4525,27.6572],[98.5045,27.6477],[98.5998,27.5988],[98.6512,27.5725],[98.6768,27.4219],[98.6824,27.2453],[98.6748,27.1906],[98.7165,27.0449],[98.7295,26.8774],[98.7385,26.7857],[98.7394,26.6981],[98.7318,26.5834],[98.7095,26.4297],[98.6719,26.2985],[98.6855,26.1894],[98.6632,26.1395],[98.572,26.1141],[98.5641,26.0724],[98.591,26.0037],[98.6547,25.9178],[98.6563,25.8636],[98.6254,25.8267],[98.5584,25.8232],[98.4655,25.7889],[98.4017,25.678],[98.3338,25.5868],[98.2966,25.5688],[98.1726,25.5945],[98.1429,25.5711],[98.0996,25.4157],[98.0641,25.349],[98.0107,25.2925],[97.962,25.2593],[97.918,25.2361],[97.8195,25.2519],[97.7674,25.1581],[97.7149,25.0343],[97.7107,24.9704],[97.7379,24.8699],[97.7238,24.842],[97.6707,24.8201],[97.5833,24.7748],[97.5294,24.6312],[97.5314,24.4917],[97.5633,24.4438],[97.6236,24.4229],[97.6666,24.38],[97.6707,24.3127],[97.7082,24.2288],[97.6906,24.1308],[97.5683,23.9885],[97.5646,23.911],[97.6297,23.8872],[97.686,23.8981],[97.7557,23.9319],[97.8377,23.9863],[98.0169,24.0654],[98.2125,24.1106],[98.3673,24.119],[98.4994,24.1157],[98.5642,24.0988],[98.5834,24.0698],[98.7644,24.1161],[98.8023,24.1187],[98.8351,24.1212],[98.834,24.0906],[98.7016,23.9641],[98.6768,23.9051],[98.6809,23.8418],[98.7351,23.7831],[98.7877,23.7378],[98.8322,23.6244],[98.7979,23.5204],[98.8197,23.4825],[98.8589,23.4401],[98.8826,23.3803],[98.8855,23.3075],[98.8638,23.1913],[99.0551,23.1306],[99.2203,23.1033],[99.3408,23.0959],[99.4181,23.0692],[99.4646,23.0462],[99.4973,23.0046],[99.5071,22.9591],[99.4668,22.9273],[99.3852,22.8251],[99.3383,22.6887],[99.3432,22.5865],[99.3377,22.498],[99.2431,22.3704],[99.2054,22.2826],[99.1724,22.1925],[99.1734,22.1533],[99.193,22.126],[99.2334,22.1102],[99.3031,22.1006],[99.3887,22.1108],[99.5927,22.0892],[99.8254,22.0497],[99.9177,22.028],[99.9479,21.9883],[99.9404,21.9016],[99.9256,21.8208],[99.9407,21.7587],[99.9782,21.7016],[100.0412,21.6828],[100.0955,21.6606],[100.1058,21.617],[100.0893,21.5579],[100.1168,21.5112],[100.1477,21.4805],[100.2147,21.463],[100.3506,21.501],[100.4457,21.4841],[100.5313,21.4581],[100.6046,21.4718],[100.6771,21.5049],[100.8352,21.6552],[101.0193,21.7364],[101.0798,21.7559],[101.1207,21.7461],[101.1309,21.7355],[101.1281,21.7051],[101.1473,21.5816],[101.1389,21.5675],[101.0804,21.4687],[100.9275,21.3662],[100.8195,21.3142],[100.7566,21.3126],[100.7031,21.2514],[100.6592,21.1304],[100.6137,21.0593],[100.5666,21.0382],[100.5361,20.9924],[100.5223,20.9219],[100.5493,20.8842],[100.6177,20.8792],[100.6229,20.8596],[100.5651,20.8251],[100.4934,20.813],[100.4074,20.8232],[100.3261,20.7957],[100.2493,20.7303],[100.1839,20.5891],[100.1297,20.3722],[100.1225,20.3167],[100.0036,20.3796],[99.9543,20.4154],[99.8903,20.4244],[99.8252,20.3845],[99.7733,20.3413],[99.7201,20.3254],[99.6387,20.3205],[99.5316,20.3428],[99.4589,20.363],[99.4479,20.3521],[99.4875,20.2606],[99.5017,20.1877],[99.4859,20.1499],[99.4516,20.1183],[99.3992,20.0935],[99.3379,20.0789],[99.2837,20.0804],[99.1969,20.1151],[99.1308,20.1166],[99.0742,20.0994],[99.0397,20.0736],[99.0207,20.0418],[98.9874,19.8614],[98.958,19.8049],[98.9167,19.7729],[98.8758,19.7696],[98.8195,19.7785],[98.7606,19.7711],[98.4938,19.7013],[98.455,19.6944],[98.3713,19.6892],[98.2937,19.6873],[98.2391,19.6907],[98.111,19.7622],[98.049,19.7697],[98.015,19.7495],[97.9912,19.6537],[97.9164,19.5929],[97.8168,19.46],[97.7936,19.2659],[97.8039,19.1305],[97.7142,18.9965],[97.7061,18.9318],[97.754,18.6208],[97.7459,18.5882],[97.7277,18.572],[97.6716,18.5612],[97.5773,18.5287],[97.5151,18.4978],[97.485,18.4942],[97.3971,18.5175],[97.3739,18.518],[97.3807,18.4943],[97.4508,18.3597],[97.5238,18.2959],[97.5993,18.303],[97.6322,18.2903],[97.6225,18.258],[97.6516,18.1737],[97.7197,18.0374],[97.7399,17.9353],[97.6985,17.8335],[97.7064,17.7971],[97.7291,17.7758],[97.793,17.6813],[97.9293,17.5333],[98.0631,17.3733],[98.1746,17.2399],[98.2565,17.1477],[98.4389,16.9757],[98.4712,16.895],[98.4781,16.7322],[98.5231,16.6382],[98.5647,16.5709],[98.5937,16.5148],[98.6607,16.3304],[98.6893,16.3054],[98.8354,16.4176],[98.8693,16.3942],[98.8883,16.3519],[98.8885,16.2981],[98.8655,16.2371],[98.818,16.1808],[98.5924,16.0507],[98.574,15.9386],[98.5582,15.7686],[98.5545,15.5598],[98.5652,15.4036],[98.5569,15.3677],[98.5373,15.3507],[98.4521,15.3574],[98.3294,15.2786],[98.2861,15.2716],[98.2322,15.2414],[98.191,15.2041],[98.1779,15.1474],[98.2021,14.9759],[98.246,14.8147],[98.3321,14.6965],[98.4002,14.603],[98.495,14.4729],[98.57,14.3599],[98.7212,14.2357],[98.9336,14.0499],[99.0146,13.9472],[99.0862,13.8228],[99.1368,13.7167],[99.1561,13.5758],[99.1717,13.4969],[99.1762,13.2331],[99.1371,13.173],[99.1074,13.1035],[99.1239,13.0308],[99.1735,12.9613],[99.1735,12.8819],[99.2198,12.7397],[99.2974,12.6529],[99.372,12.5942],[99.4051,12.5479],[99.3942,12.4736],[99.4163,12.3948],[99.4324,12.309],[99.4629,12.1902],[99.5229,12.0896],[99.6147,11.7812],[99.6125,11.7497],[99.5729,11.6872],[99.5152,11.6307],[99.4779,11.6125],[99.4427,11.5544],[99.3588,11.3895],[99.1901,11.1053],[99.0254,10.92],[98.8871,10.7883],[98.7869,10.7084],[98.7572,10.6609],[98.7572,10.6236],[98.7754,10.557],[98.7684,10.4309],[98.7469,10.3508],[98.7185,10.266],[98.7025,10.1904],[98.658,10.1791],[98.5626,10.035],[98.5213,10.1072],[98.4969,10.1825],[98.523,10.3531],[98.4649,10.6758],[98.501,10.7189],[98.5356,10.7407],[98.5988,10.8644],[98.6756,10.9869],[98.6826,11.1331],[98.7447,11.2404],[98.7301,11.33],[98.7333,11.4353],[98.7464,11.5213],[98.7414,11.5917],[98.7907,11.6651],[98.876,11.7197],[98.8402,11.7393],[98.8048,11.7792],[98.6937,11.7184],[98.6363,11.7384],[98.6249,11.8015],[98.6391,11.8691],[98.6449,11.9103],[98.6895,11.9567],[98.6863,12.0471],[98.6639,12.1267],[98.6963,12.2252],[98.6306,12.2255],[98.6003,12.2453],[98.6191,12.3],[98.6787,12.3485],[98.6244,12.4407],[98.6646,12.5399],[98.6632,12.6624],[98.6356,12.7705],[98.6371,12.8482],[98.5951,12.986],[98.576,13.1619],[98.4871,13.2931],[98.4213,13.4838],[98.2454,13.7335],[98.2484,13.8404],[98.239,13.9345],[98.2004,13.9802],[98.1495,13.6476],[98.1106,13.7129],[98.0982,13.8983],[98.0727,13.9865],[98.1002,14.1615],[97.9984,14.3353],[97.9766,14.4615],[97.9098,14.6527],[97.9293,14.6956],[98.0188,14.6526],[97.9365,14.7639],[97.8691,14.7387],[97.8123,14.8589],[97.7998,15.1849],[97.7438,15.3068],[97.7742,15.431],[97.7104,15.8755],[97.5843,16.0196],[97.6093,16.1438],[97.6406,16.2539],[97.6337,16.4577],[97.6646,16.5205],[97.726,16.5686],[97.6685,16.5516],[97.6196,16.5372],[97.5051,16.5253],[97.3759,16.5229],[97.3311,16.6718],[97.2675,16.7431],[97.2117,16.8926],[97.1783,17.062],[97.2002,17.0954],[97.1002,17.1646],[97.0745,17.2069],[96.9701,17.3173],[96.8515,17.401],[96.8777,17.3422],[96.9098,17.3048],[96.8509,17.2029],[96.9086,17.031],[96.858,16.9212],[96.8106,16.7784],[96.7654,16.7104],[96.6225,16.5639],[96.5066,16.5144],[96.4312,16.5049],[96.3644,16.5205],[96.2822,16.596],[96.2621,16.6591],[96.2489,16.7653],[96.2203,16.7806],[96.1891,16.7683],[96.2377,16.6313],[96.2367,16.5674],[96.3243,16.4444],[96.2931,16.4101],[96.1351,16.3425],[96.081,16.3534],[96.0429,16.3399],[96.0321,16.2846],[96.0123,16.2537],[95.7633,16.169],[95.7114,16.0734],[95.6795,15.9768],[95.5557,15.8378],[95.3896,15.7228],[95.3484,15.7293],[95.3015,15.7562],[95.3078,15.8804],[95.3647,15.9854],[95.3468,16.0976],[95.333,16.0333],[95.2259,15.8768],[95.177,15.8257],[95.0783,15.8392],[94.9426,15.8183],[94.8912,15.9791],[94.8922,16.0382],[94.8822,16.0879],[94.8979,16.1408],[94.8932,16.1828],[94.8602,16.1024],[94.8478,16.0329],[94.7981,15.9711],[94.6615,15.9044],[94.6563,15.9888],[94.6514,16.0648],[94.6808,16.1333],[94.6766,16.242],[94.7199,16.3987],[94.7166,16.4525],[94.7033,16.5119],[94.679,16.4256],[94.6652,16.3361],[94.6377,16.3091],[94.5875,16.2888],[94.4957,16.1861],[94.4416,16.0944],[94.299,16.0076],[94.2238,16.0165],[94.2143,16.1266],[94.2713,16.5173],[94.3273,16.5722],[94.3534,16.6399],[94.4,16.8682],[94.4524,16.9545],[94.4731,17.1354],[94.4943,17.1666],[94.5645,17.3085],[94.589,17.5693],[94.5601,17.699],[94.4943,17.8246],[94.4308,18.2017],[94.2658,18.5072],[94.2521,18.6092],[94.1707,18.7324],[94.2457,18.7412],[94.0913,18.8492],[94.07,18.8934],[94.039,19.1462],[94.0449,19.2874],[94.0225,19.2688],[94.0016,19.1818],[93.941,19.1461],[93.9681,18.9951],[93.9613,18.9584],[93.9292,18.8997],[93.8001,18.9606],[93.7055,19.0269],[93.5981,19.1885],[93.4931,19.3695],[93.5306,19.3976],[93.5786,19.4012],[93.728,19.2665],[93.8249,19.2385],[93.8861,19.2719],[93.962,19.3293],[93.9981,19.4409],[93.9607,19.4817],[93.8879,19.5039],[93.8396,19.5341],[93.7699,19.6096],[93.761,19.648],[93.7396,19.6973],[93.6688,19.732],[93.6117,19.7761],[93.6599,19.8542],[93.707,19.9122],[93.5818,19.9096],[93.4391,20.0094],[93.4096,20.0383],[93.3623,20.0583],[93.25,20.0701],[93.1566,20.0408],[93.199,19.8983],[93.1906,19.8512],[93.1295,19.858],[93.002,20.0749],[93.0403,20.1298],[93.0955,20.1813],[93.0684,20.1887],[93.0151,20.1853],[93.0668,20.3776],[93.0354,20.4062],[93.0188,20.346],[92.9907,20.288],[92.8821,20.1521],[92.8283,20.1776],[92.7912,20.2114],[92.8436,20.2826],[92.8717,20.3018],[92.8911,20.3403],[92.8507,20.4148],[92.7869,20.469],[92.7356,20.5627],[92.709,20.564],[92.7326,20.4534],[92.7229,20.2956],[92.608,20.4699],[92.3783,20.7176],[92.3241,20.7918],[92.3119,20.8645],[92.2862,20.9316],[92.2685,21.0047],[92.2645,21.0615],[92.2147,21.1127],[92.192,21.2022],[92.1796,21.2931],[92.2082,21.3579],[92.2797,21.4276],[92.3306,21.4398],[92.3727,21.409],[92.4719,21.363],[92.5392,21.3198],[92.5686,21.2633],[92.5998,21.2702],[92.6316,21.3062],[92.6253,21.3507],[92.5935,21.4673],[92.5843,21.609],[92.5828,21.9403],[92.5749,21.9781],[92.6304,22.0113],[92.6526,22.0493],[92.6747,22.106],[92.689,22.131],[92.721,22.1324],[92.7714,22.1048],[92.8543,22.0102],[92.9095,21.9889],[92.9646,22.0038],[93.022,22.1457],[93.043,22.184],[93.0706,22.2094],[93.1215,22.2052],[93.1512,22.2306],[93.1624,22.2919],[93.162,22.3602],[93.1051,22.5471],[93.0882,22.6333],[93.0787,22.7182],[93.1143,22.8057],[93.1625,22.908],[93.151,22.9973],[93.1642,23.032],[93.2039,23.037],[93.2535,23.0155],[93.308,23.0304],[93.3494,23.085],[93.366,23.1325],[93.3913,23.3392],[93.4081,23.528],[93.4149,23.6821],[93.3726,23.7742],[93.3073,24.0219],[93.3263,24.0642],[93.3556,24.0741],[93.4521,23.9874],[93.4938,23.9729],[93.5641,23.9861],[93.6333,24.0054],[93.6834,24.0065],[93.7559,23.9769],[93.8555,23.9439],[94.0108,23.9029],[94.0748,23.8721],[94.1276,23.8765],[94.1703,23.9727],[94.2197,24.1132],[94.2931,24.3219],[94.3772,24.4737],[94.3994,24.5141],[94.4932,24.6376],[94.5841,24.7672],[94.6633,24.931],[94.7076,25.0487],[94.7037,25.0979],[94.6753,25.1386],[94.6156,25.1646],[94.5665,25.1915],[94.553,25.2157],[94.5544,25.2435],[94.5799,25.3198],[94.6229,25.41],[94.6678,25.4589],[94.7858,25.5193],[94.8611,25.5972],[94.9457,25.7002],[94.992,25.7705],[95.0152,25.9129],[95.0407,25.9413],[95.093,25.9873],[95.1324,26.0413],[95.1293,26.0704],[95.1084,26.0914],[95.0689,26.1911],[95.0509,26.3473],[95.0598,26.474],[95.0895,26.5255],[95.1287,26.5973],[95.2015,26.6414],[95.3051,26.6723],[95.4639,26.7561],[95.7384,26.9504],[95.8373,27.0138],[95.9053,27.0466],[95.9709,27.1281],[96.0614,27.2171],[96.1908,27.2613],[96.2742,27.2784],[96.6657,27.3393],[96.7316,27.3315],[96.7979,27.2962],[96.8803,27.1778],[96.9534,27.1333],[97.0381,27.1021],[97.1021,27.1154],[97.1037,27.1633],[96.902,27.4396],[96.8836,27.5148],[96.8769,27.5867],[96.8997,27.6438],[96.9628,27.6983],[97.0497,27.76],[97.1578,27.8369],[97.2261,27.89],[97.3062,27.9071],[97.3352,27.9377],[97.3436,27.9823],[97.3392,28.0309],[97.3027,28.086],[97.3103,28.1552],[97.3225,28.218],[97.3564,28.2545],[97.4314,28.3539],[97.4777,28.4256],[97.5021,28.4563],[97.5379,28.5102],[97.5992,28.517],[97.6589,28.5],[97.6946,28.4693],[97.7301,28.4071]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Myanmar","sov_a3":"MMR","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Myanmar","adm0_a3":"MMR","geou_dif":0,"geounit":"Myanmar","gu_a3":"MMR","su_dif":0,"subunit":"Myanmar","su_a3":"MMR","brk_diff":0,"name":"Myanmar","name_long":"Myanmar","brk_a3":"MMR","brk_name":"Myanmar","brk_group":"","abbrev":"Myan.","postal":"MM","formal_en":"Republic of the Union of Myanmar","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Myanmar","name_alt":"","mapcolor7":2,"mapcolor8":2,"mapcolor9":5,"mapcolor13":13,"pop_est":48137741,"gdp_md_est":55130,"pop_year":-99,"lastcensus":1983,"gdp_year":-99,"economy":"7. Least developed region","income_grp":"5. Low income","wikipedia":-99,"fips_10":"","iso_a2":"MM","iso_a3":"MMR","iso_n3":"104","un_a3":"104","wb_a2":"MM","wb_a3":"MMR","woe_id":-99,"adm0_a3_is":"MMR","adm0_a3_us":"MMR","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"South-Eastern Asia","region_wb":"East Asia & Pacific","name_len":7,"long_len":7,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[70.0207,66.5022],[69.8447,66.4897],[69.6514,66.5653],[69.4693,66.716],[69.5027,66.7511],[69.6164,66.739],[69.8004,66.7365],[69.9176,66.7117],[70.0767,66.6959],[70.0576,66.6272],[70.0572,66.5995],[70.1101,66.5691],[70.0592,66.5176],[70.0207,66.5022]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Russia","sov_a3":"RUS","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Russia","adm0_a3":"RUS","geou_dif":0,"geounit":"Russia","gu_a3":"RUS","su_dif":0,"subunit":"Russia","su_a3":"RUS","brk_diff":0,"name":"Russia","name_long":"Russian Federation","brk_a3":"RUS","brk_name":"Russia","brk_group":"","abbrev":"Rus.","postal":"RUS","formal_en":"Russian Federation","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Russian Federation","name_alt":"","mapcolor7":2,"mapcolor8":5,"mapcolor9":7,"mapcolor13":7,"pop_est":140041247,"gdp_md_est":2266000,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"3. Emerging region: BRIC","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"RU","iso_a3":"RUS","iso_n3":"643","un_a3":"643","wb_a2":"RU","wb_a3":"RUS","woe_id":-99,"adm0_a3_is":"RUS","adm0_a3_us":"RUS","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Eastern Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":18,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[7.4387,43.7504],[7.3777,43.7317],[7.3801,43.7532],[7.395,43.7653],[7.4145,43.7709],[7.4369,43.7615],[7.4387,43.7504]]]},"properties":{"scalerank":6,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Monaco","sov_a3":"MCO","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Monaco","adm0_a3":"MCO","geou_dif":0,"geounit":"Monaco","gu_a3":"MCO","su_dif":0,"subunit":"Monaco","su_a3":"MCO","brk_diff":0,"name":"Monaco","name_long":"Monaco","brk_a3":"MCO","brk_name":"Monaco","brk_group":"","abbrev":"Mco.","postal":"MC","formal_en":"Principality of Monaco","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Monaco","name_alt":"","mapcolor7":1,"mapcolor8":1,"mapcolor9":2,"mapcolor13":12,"pop_est":32965,"gdp_md_est":976.3,"pop_year":-99,"lastcensus":2008,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"MC","iso_a3":"MCO","iso_n3":"492","un_a3":"492","wb_a2":"MC","wb_a3":"MCO","woe_id":-99,"adm0_a3_is":"MCO","adm0_a3_us":"MCO","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Western Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":6,"abbrev_len":4,"tiny":5,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[113.4789,22.1956],[113.4811,22.2175],[113.4941,22.2416],[113.5271,22.2459],[113.5481,22.2226],[113.5455,22.2215],[113.4988,22.2017],[113.4842,22.1978],[113.4789,22.1956]]]},"properties":{"scalerank":3,"featurecla":"Admin-0 country","labelrank":4,"sovereignt":"China","sov_a3":"CH1","adm0_dif":1,"level":2,"type":"Country","admin":"Macao S.A.R","adm0_a3":"MAC","geou_dif":0,"geounit":"Macao S.A.R","gu_a3":"MAC","su_dif":0,"subunit":"Macao S.A.R","su_a3":"MAC","brk_diff":0,"name":"Macao","name_long":"Macao","brk_a3":"MAC","brk_name":"Macao","brk_group":"","abbrev":"Mac.","postal":"MO","formal_en":"Macao Special Administrative Region, PRC","formal_fr":"","note_adm0":"China","note_brk":"","name_sort":"Macao SAR, China","name_alt":"","mapcolor7":4,"mapcolor8":4,"mapcolor9":4,"mapcolor13":3,"pop_est":559846,"gdp_md_est":18140,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"6. Developing region","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"MO","iso_a3":"MAC","iso_n3":"446","un_a3":"446","wb_a2":"MO","wb_a3":"MAC","woe_id":-99,"adm0_a3_is":"MAC","adm0_a3_us":"MAC","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Eastern Asia","region_wb":"East Asia & Pacific","name_len":5,"long_len":5,"abbrev_len":4,"tiny":-99,"homepart":-99}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[67.3449,69.5298],[67.264,69.4425],[67.0979,69.4472],[67.0473,69.467],[67.0259,69.4832],[67.2161,69.5754],[67.3289,69.5721],[67.3449,69.5298]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Russia","sov_a3":"RUS","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Russia","adm0_a3":"RUS","geou_dif":0,"geounit":"Russia","gu_a3":"RUS","su_dif":0,"subunit":"Russia","su_a3":"RUS","brk_diff":0,"name":"Russia","name_long":"Russian Federation","brk_a3":"RUS","brk_name":"Russia","brk_group":"","abbrev":"Rus.","postal":"RUS","formal_en":"Russian Federation","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Russian Federation","name_alt":"","mapcolor7":2,"mapcolor8":5,"mapcolor9":7,"mapcolor13":7,"pop_est":140041247,"gdp_md_est":2266000,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"3. Emerging region: BRIC","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"RU","iso_a3":"RUS","iso_n3":"643","un_a3":"643","wb_a2":"RU","wb_a3":"RUS","woe_id":-99,"adm0_a3_is":"RUS","adm0_a3_us":"RUS","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Eastern Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":18,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[73.4166,3.2312],[73.3953,3.2294],[73.382,3.2465],[73.385,3.2714],[73.4016,3.2888],[73.4277,3.2898],[73.4428,3.2743],[73.435,3.2501],[73.4166,3.2312]],[[73.5122,4.1646],[73.4948,4.1552],[73.4786,4.1589],[73.473,4.1707],[73.4812,4.1881],[73.4947,4.2104],[73.5041,4.2346],[73.5178,4.2477],[73.5283,4.2433],[73.5271,4.2297],[73.5222,4.211],[73.519,4.1869],[73.5122,4.1646]]]},"properties":{"scalerank":3,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Maldives","sov_a3":"MDV","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Maldives","adm0_a3":"MDV","geou_dif":0,"geounit":"Maldives","gu_a3":"MDV","su_dif":0,"subunit":"Maldives","su_a3":"MDV","brk_diff":0,"name":"Maldives","name_long":"Maldives","brk_a3":"MDV","brk_name":"Maldives","brk_group":"","abbrev":"Mald.","postal":"MV","formal_en":"Republic of Maldives","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Maldives","name_alt":"","mapcolor7":2,"mapcolor8":3,"mapcolor9":1,"mapcolor13":7,"pop_est":396334,"gdp_md_est":1716,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"6. Developing region","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"MV","iso_a3":"MDV","iso_n3":"462","un_a3":"462","wb_a2":"MV","wb_a3":"MDV","woe_id":-99,"adm0_a3_is":"MDV","adm0_a3_us":"B13","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Seven seas (open ocean)","region_un":"Asia","subregion":"Southern Asia","region_wb":"South Asia","name_len":8,"long_len":8,"abbrev_len":5,"tiny":2,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[28.2125,45.4504],[28.1625,45.5138],[28.1119,45.5691],[28.0747,45.599],[28.0903,45.6127],[28.1309,45.6283],[28.1598,45.6471],[28.1563,45.7131],[28.135,45.7889],[28.1155,45.8255],[28.1136,45.8831],[28.0997,45.9726],[28.1191,46.1387],[28.1996,46.3476],[28.2443,46.4513],[28.2227,46.5081],[28.2395,46.6408],[28.2047,46.7064],[28.15,46.7921],[28.0718,46.9784],[27.9742,47.0432],[27.8538,47.1145],[27.8023,47.1683],[27.768,47.2276],[27.6962,47.2864],[27.6141,47.3405],[27.5158,47.4756],[27.4648,47.5367],[27.4492,47.5531],[27.3369,47.6397],[27.2779,47.718],[27.2481,47.7822],[27.2309,47.8417],[27.1521,47.9593],[27.0804,48.0477],[27.0122,48.1105],[26.9808,48.155],[26.901,48.2111],[26.7873,48.2558],[26.7138,48.2635],[26.6189,48.2599],[26.6404,48.2941],[26.8471,48.3872],[26.9006,48.3719],[27.0085,48.3683],[27.2285,48.3714],[27.3369,48.4327],[27.4038,48.4156],[27.4584,48.4431],[27.5492,48.4777],[27.5622,48.4704],[27.5737,48.4649],[27.7145,48.4495],[27.82,48.4163],[27.8906,48.3652],[27.9634,48.3335],[28.0385,48.3213],[28.0801,48.2958],[28.0885,48.257],[28.1588,48.238],[28.291,48.2386],[28.3472,48.213],[28.327,48.1614],[28.3405,48.1444],[28.3875,48.1621],[28.423,48.1469],[28.442,48.1087],[28.4631,48.0905],[28.5305,48.1503],[28.6017,48.1444],[28.7738,48.1196],[28.8658,47.9957],[28.9231,47.9511],[28.9733,47.933],[29.0369,47.9523],[29.093,47.9754],[29.1254,47.9646],[29.1948,47.8824],[29.2111,47.775],[29.2107,47.7315],[29.186,47.6586],[29.1509,47.5809],[29.1229,47.5304],[29.1349,47.4897],[29.1598,47.4557],[29.2006,47.4445],[29.3338,47.3757],[29.3834,47.328],[29.4557,47.2926],[29.5106,47.2907],[29.5392,47.271],[29.5493,47.2468],[29.5418,47.1855],[29.5109,47.128],[29.515,47.0911],[29.5635,47.0475],[29.5687,46.9967],[29.572,46.964],[29.5978,46.9388],[29.7197,46.8829],[29.8778,46.8289],[29.9181,46.7824],[29.9425,46.7238],[29.9348,46.625],[29.9243,46.5389],[30.1311,46.4231],[30.1075,46.4016],[30.0757,46.3778],[29.878,46.3602],[29.8379,46.3505],[29.752,46.4378],[29.7068,46.4487],[29.6646,46.4167],[29.6149,46.3988],[29.5551,46.4078],[29.491,46.4347],[29.4588,46.4538],[29.4328,46.456],[29.3929,46.4369],[29.3396,46.4451],[29.3049,46.4666],[29.2546,46.3926],[29.2238,46.377],[29.2046,46.3793],[29.2008,46.505],[29.1862,46.524],[29.1463,46.5269],[29.0499,46.497],[28.9584,46.4585],[28.9274,46.4241],[28.9306,46.3623],[28.9438,46.2884],[29.0063,46.1765],[28.9719,46.1276],[28.9478,46.05],[28.8495,45.9787],[28.7388,45.9372],[28.7293,45.852],[28.6676,45.7938],[28.5623,45.7358],[28.4916,45.6658],[28.5095,45.6178],[28.5138,45.5724],[28.5018,45.5416],[28.499,45.5177],[28.4714,45.5072],[28.3104,45.4986],[28.2648,45.4839],[28.2125,45.4504]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Moldova","sov_a3":"MDA","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Moldova","adm0_a3":"MDA","geou_dif":0,"geounit":"Moldova","gu_a3":"MDA","su_dif":0,"subunit":"Moldova","su_a3":"MDA","brk_diff":0,"name":"Moldova","name_long":"Moldova","brk_a3":"MDA","brk_name":"Moldova","brk_group":"","abbrev":"Mda.","postal":"MD","formal_en":"Republic of Moldova","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Moldova","name_alt":"","mapcolor7":3,"mapcolor8":5,"mapcolor9":4,"mapcolor13":12,"pop_est":4320748,"gdp_md_est":10670,"pop_year":-99,"lastcensus":2004,"gdp_year":-99,"economy":"6. Developing region","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"MD","iso_a3":"MDA","iso_n3":"498","un_a3":"498","wb_a2":"MD","wb_a3":"MDA","woe_id":-99,"adm0_a3_is":"MDA","adm0_a3_us":"MDA","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Eastern Europe","region_wb":"Europe & Central Asia","name_len":7,"long_len":7,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[9.5803,47.0574],[9.5023,47.0627],[9.4877,47.0623],[9.4795,47.0975],[9.4843,47.1727],[9.5275,47.2708],[9.5368,47.2546],[9.5422,47.2341],[9.5511,47.2123],[9.5558,47.1855],[9.5719,47.1579],[9.6012,47.1321],[9.6105,47.1071],[9.5957,47.0758],[9.5803,47.0574]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Liechtenstein","sov_a3":"LIE","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Liechtenstein","adm0_a3":"LIE","geou_dif":0,"geounit":"Liechtenstein","gu_a3":"LIE","su_dif":0,"subunit":"Liechtenstein","su_a3":"LIE","brk_diff":0,"name":"Liechtenstein","name_long":"Liechtenstein","brk_a3":"LIE","brk_name":"Liechtenstein","brk_group":"","abbrev":"Liech.","postal":"FL","formal_en":"Principality of Liechtenstein","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Liechtenstein","name_alt":"","mapcolor7":2,"mapcolor8":4,"mapcolor9":2,"mapcolor13":9,"pop_est":34761,"gdp_md_est":4160,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"LI","iso_a3":"LIE","iso_n3":"438","un_a3":"438","wb_a2":"LI","wb_a3":"LIE","woe_id":-99,"adm0_a3_is":"LIE","adm0_a3_us":"LIE","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Western Europe","region_wb":"Europe & Central Asia","name_len":13,"long_len":13,"abbrev_len":6,"tiny":6,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[66.5609,70.5417],[66.5686,70.5015],[66.5158,70.5149],[66.4486,70.561],[66.4076,70.6158],[66.3948,70.7273],[66.4182,70.7571],[66.4402,70.7727],[66.4629,70.7693],[66.4577,70.6988],[66.5609,70.5417]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Russia","sov_a3":"RUS","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Russia","adm0_a3":"RUS","geou_dif":0,"geounit":"Russia","gu_a3":"RUS","su_dif":0,"subunit":"Russia","su_a3":"RUS","brk_diff":0,"name":"Russia","name_long":"Russian Federation","brk_a3":"RUS","brk_name":"Russia","brk_group":"","abbrev":"Rus.","postal":"RUS","formal_en":"Russian Federation","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Russian Federation","name_alt":"","mapcolor7":2,"mapcolor8":5,"mapcolor9":7,"mapcolor13":7,"pop_est":140041247,"gdp_md_est":2266000,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"3. Emerging region: BRIC","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"RU","iso_a3":"RUS","iso_n3":"643","un_a3":"643","wb_a2":"RU","wb_a3":"RUS","woe_id":-99,"adm0_a3_is":"RUS","adm0_a3_us":"RUS","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Eastern Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":18,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[79.8748,9.0507],[79.9037,8.975],[79.8211,9.0269],[79.7668,9.0698],[79.7477,9.1046],[79.86,9.0657],[79.8748,9.0507]],[[79.9695,9.6307],[79.9068,9.6198],[79.8574,9.6864],[79.8457,9.7146],[79.8586,9.7344],[79.8723,9.7443],[79.8885,9.7412],[79.9119,9.6792],[79.9695,9.6307]],[[79.9823,9.8127],[80.0784,9.8075],[80.181,9.81],[80.2528,9.7963],[80.376,9.6423],[80.7111,9.3664],[80.8935,9.0859],[80.9101,9.0245],[80.9354,8.9715],[80.9792,8.9569],[81.016,8.9326],[81.1982,8.662],[81.2192,8.6084],[81.2162,8.5494],[81.227,8.5055],[81.2746,8.4836],[81.334,8.4721],[81.3729,8.4314],[81.4222,8.2152],[81.4222,8.1479],[81.4359,8.1189],[81.6654,7.7825],[81.6787,7.7416],[81.6763,7.7109],[81.6829,7.6845],[81.7273,7.625],[81.7967,7.4648],[81.832,7.4284],[81.8741,7.2883],[81.877,7.0205],[81.8614,6.9013],[81.8186,6.7562],[81.7678,6.6143],[81.7127,6.5119],[81.6374,6.4251],[81.38,6.2409],[81.3063,6.2039],[80.9711,6.0884],[80.7241,5.9791],[80.4958,5.9494],[80.2674,6.0098],[80.0953,6.1532],[80.0072,6.3644],[79.947,6.5845],[79.8594,6.8293],[79.7921,7.5852],[79.76,7.7965],[79.7078,8.0657],[79.713,8.1823],[79.7498,8.2942],[79.7497,8.0489],[79.7835,8.0185],[79.8089,8.05],[79.8319,8.3041],[79.8509,8.4116],[79.9418,8.6915],[79.9437,8.7412],[79.9279,8.8464],[79.9289,8.8992],[80.0648,9.0957],[80.0996,9.21],[80.1184,9.3269],[80.1109,9.4533],[80.0863,9.5778],[80.1961,9.5381],[80.2564,9.4948],[80.318,9.4654],[80.368,9.4805],[80.4283,9.481],[80.3854,9.5488],[80.2576,9.6113],[80.0458,9.6499],[79.9795,9.6994],[79.954,9.7423],[79.967,9.7926],[79.9823,9.8127]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Sri Lanka","sov_a3":"LKA","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Sri Lanka","adm0_a3":"LKA","geou_dif":0,"geounit":"Sri Lanka","gu_a3":"LKA","su_dif":0,"subunit":"Sri Lanka","su_a3":"LKA","brk_diff":0,"name":"Sri Lanka","name_long":"Sri Lanka","brk_a3":"LKA","brk_name":"Sri Lanka","brk_group":"","abbrev":"Sri L.","postal":"LK","formal_en":"Democratic Socialist Republic of Sri Lanka","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Sri Lanka","name_alt":"","mapcolor7":3,"mapcolor8":5,"mapcolor9":4,"mapcolor13":9,"pop_est":21324791,"gdp_md_est":91870,"pop_year":-99,"lastcensus":2001,"gdp_year":-99,"economy":"6. Developing region","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"LK","iso_a3":"LKA","iso_n3":"144","un_a3":"144","wb_a2":"LK","wb_a3":"LKA","woe_id":-99,"adm0_a3_is":"LKA","adm0_a3_us":"LKA","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Southern Asia","region_wb":"South Asia","name_len":9,"long_len":9,"abbrev_len":6,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[6.1165,50.121],[6.1083,50.0942],[6.1098,50.0344],[6.1382,49.9743],[6.2049,49.9151],[6.2561,49.8722],[6.3246,49.8379],[6.4409,49.8053],[6.4873,49.7985],[6.4938,49.7544],[6.4848,49.7078],[6.4446,49.682],[6.4067,49.645],[6.3783,49.5996],[6.3484,49.5127],[6.3443,49.4527],[6.2773,49.4775],[6.2422,49.4943],[6.1811,49.4989],[6.1199,49.4852],[6.0741,49.4546],[6.0114,49.4455],[5.9595,49.4546],[5.9289,49.4775],[5.9014,49.4897],[5.8234,49.5051],[5.7897,49.5383],[5.8154,49.5538],[5.8376,49.5783],[5.8565,49.6128],[5.8804,49.6448],[5.8037,49.7322],[5.788,49.7589],[5.725,49.8083],[5.7258,49.8333],[5.7408,49.8572],[5.7353,49.8756],[5.744,49.9196],[5.7881,49.9612],[5.8174,50.0127],[5.8669,50.0828],[5.9763,50.1672],[6.0548,50.1543],[6.0891,50.1546],[6.1101,50.1238],[6.1165,50.121]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Luxembourg","sov_a3":"LUX","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Luxembourg","adm0_a3":"LUX","geou_dif":0,"geounit":"Luxembourg","gu_a3":"LUX","su_dif":0,"subunit":"Luxembourg","su_a3":"LUX","brk_diff":0,"name":"Luxembourg","name_long":"Luxembourg","brk_a3":"LUX","brk_name":"Luxembourg","brk_group":"","abbrev":"Lux.","postal":"L","formal_en":"Grand Duchy of Luxembourg","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Luxembourg","name_alt":"","mapcolor7":1,"mapcolor8":7,"mapcolor9":3,"mapcolor13":7,"pop_est":491775,"gdp_md_est":39370,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"LU","iso_a3":"LUX","iso_n3":"442","un_a3":"442","wb_a2":"LU","wb_a3":"LUX","woe_id":-99,"adm0_a3_is":"LUX","adm0_a3_us":"LUX","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Western Europe","region_wb":"Europe & Central Asia","name_len":10,"long_len":10,"abbrev_len":4,"tiny":5,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[27.352,57.5281],[27.4697,57.524],[27.5111,57.5082],[27.5387,57.4298],[27.6728,57.3681],[27.7969,57.3169],[27.8286,57.2933],[27.8383,57.2477],[27.8303,57.1945],[27.8146,57.1669],[27.7628,57.1351],[27.7174,57.0546],[27.7111,56.9781],[27.6395,56.8457],[27.6557,56.8432],[27.8061,56.8671],[27.8486,56.8534],[27.8815,56.8242],[27.8921,56.7411],[27.9414,56.7037],[27.9916,56.6453],[28.0075,56.5999],[28.1031,56.5457],[28.1108,56.5107],[28.1692,56.3869],[28.1917,56.3156],[28.2021,56.2604],[28.1733,56.1903],[28.1479,56.1429],[28.1179,56.1458],[28.032,56.1333],[27.8963,56.0762],[27.6942,55.9416],[27.6423,55.9117],[27.5895,55.8092],[27.5768,55.7988],[27.4592,55.8035],[27.4271,55.806],[27.3092,55.8039],[27.0525,55.8306],[26.953,55.8129],[26.8225,55.7092],[26.7719,55.694],[26.6202,55.6796],[26.5936,55.6675],[26.5429,55.6724],[26.4011,55.7038],[26.2813,55.7504],[26.2096,55.8121],[26.0855,55.8969],[26.0042,55.9401],[25.8764,55.9943],[25.6632,56.1048],[25.5857,56.1302],[25.2069,56.1784],[25.0699,56.2004],[24.9438,56.3256],[24.903,56.3982],[24.841,56.4112],[24.7732,56.3959],[24.6995,56.3813],[24.529,56.2963],[24.4736,56.2841],[24.3679,56.283],[24.1207,56.2643],[24.0082,56.2953],[23.8127,56.3292],[23.7067,56.3346],[23.6127,56.3338],[23.1959,56.3671],[23.1198,56.3307],[23.043,56.3241],[22.9683,56.3804],[22.8756,56.3964],[22.7732,56.3773],[22.5869,56.3751],[22.3659,56.3929],[22.0846,56.4067],[22.0429,56.4008],[21.7306,56.326],[21.6535,56.3146],[21.3146,56.1881],[21.0461,56.0701],[21.0149,56.2589],[21.0314,56.6366],[21.0713,56.8237],[21.2574,56.9328],[21.3508,57.0177],[21.4051,57.131],[21.4215,57.2358],[21.4592,57.3225],[21.7287,57.571],[21.9424,57.5979],[22.2314,57.6668],[22.5546,57.7243],[22.617,57.6512],[22.6486,57.5954],[23.0378,57.3921],[23.1368,57.3238],[23.2873,57.0897],[23.6478,56.971],[23.9312,57.0085],[24.0543,57.0661],[24.2813,57.1723],[24.3826,57.25],[24.4032,57.325],[24.363,57.6453],[24.3016,57.7841],[24.3226,57.8706],[24.3625,57.8662],[24.4589,57.9079],[24.7758,57.9853],[24.8391,57.9887],[24.9113,58.0046],[25.111,58.0634],[25.1752,58.0321],[25.2287,57.9966],[25.2583,57.9961],[25.2727,58.0094],[25.2687,58.0322],[25.2826,58.0485],[25.34,58.0395],[25.5713,57.9428],[25.6602,57.9202],[25.7209,57.9138],[25.7938,57.8686],[25.9911,57.8382],[26.0152,57.8147],[26.0304,57.7855],[26.215,57.6627],[26.298,57.6011],[26.4621,57.5445],[26.5326,57.531],[26.8197,57.5887],[26.8998,57.6088],[26.966,57.6091],[27.0334,57.5788],[27.1871,57.5383],[27.3266,57.5255],[27.352,57.5281]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Latvia","sov_a3":"LVA","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Latvia","adm0_a3":"LVA","geou_dif":0,"geounit":"Latvia","gu_a3":"LVA","su_dif":0,"subunit":"Latvia","su_a3":"LVA","brk_diff":0,"name":"Latvia","name_long":"Latvia","brk_a3":"LVA","brk_name":"Latvia","brk_group":"","abbrev":"Lat.","postal":"LV","formal_en":"Republic of Latvia","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Latvia","name_alt":"","mapcolor7":4,"mapcolor8":7,"mapcolor9":6,"mapcolor13":13,"pop_est":2231503,"gdp_md_est":38860,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"LV","iso_a3":"LVA","iso_n3":"428","un_a3":"428","wb_a2":"LV","wb_a3":"LVA","woe_id":-99,"adm0_a3_is":"LVA","adm0_a3_us":"LVA","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Northern Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":6,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[77.6325,72.2913],[77.1456,72.2819],[76.906,72.2977],[76.8711,72.317],[76.9031,72.3656],[77.1495,72.4392],[77.2604,72.4861],[77.3778,72.5653],[77.5787,72.6309],[77.7485,72.6312],[78.2791,72.5532],[78.3529,72.5043],[78.3651,72.4824],[78.1545,72.417],[78.0072,72.3925],[77.7809,72.3085],[77.6325,72.2913]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Russia","sov_a3":"RUS","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Russia","adm0_a3":"RUS","geou_dif":0,"geounit":"Russia","gu_a3":"RUS","su_dif":0,"subunit":"Russia","su_a3":"RUS","brk_diff":0,"name":"Russia","name_long":"Russian Federation","brk_a3":"RUS","brk_name":"Russia","brk_group":"","abbrev":"Rus.","postal":"RUS","formal_en":"Russian Federation","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Russian Federation","name_alt":"","mapcolor7":2,"mapcolor8":5,"mapcolor9":7,"mapcolor13":7,"pop_est":140041247,"gdp_md_est":2266000,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"3. Emerging region: BRIC","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"RU","iso_a3":"RUS","iso_n3":"643","un_a3":"643","wb_a2":"RU","wb_a3":"RUS","woe_id":-99,"adm0_a3_is":"RUS","adm0_a3_us":"RUS","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Eastern Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":18,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[21.0317,55.3505],[20.9578,55.2789],[20.8998,55.2867],[21.0141,55.402],[21.0576,55.4768],[21.0879,55.5831],[21.1148,55.6165],[21.1157,55.5682],[21.1039,55.4877],[21.0317,55.3505]],[[24.9438,56.3256],[25.0699,56.2004],[25.2069,56.1784],[25.5857,56.1302],[25.6632,56.1048],[25.8764,55.9943],[26.0042,55.9401],[26.0855,55.8969],[26.2096,55.8121],[26.2813,55.7504],[26.4011,55.7038],[26.5429,55.6724],[26.5936,55.6675],[26.5908,55.6227],[26.5666,55.5465],[26.5192,55.4481],[26.4695,55.3719],[26.4576,55.3425],[26.4953,55.318],[26.6813,55.3064],[26.7602,55.2934],[26.7757,55.2731],[26.7344,55.2468],[26.675,55.2249],[26.6484,55.2042],[26.6012,55.1302],[26.2918,55.1396],[26.2508,55.1245],[26.2313,55.0901],[26.2158,55.0504],[26.1752,55.0033],[26.093,54.9623],[25.9645,54.9472],[25.8593,54.9193],[25.7809,54.8333],[25.7225,54.7179],[25.7239,54.636],[25.7316,54.5904],[25.7248,54.5643],[25.6852,54.5358],[25.6203,54.4604],[25.5676,54.3771],[25.5474,54.3318],[25.5575,54.3107],[25.6169,54.3101],[25.7025,54.293],[25.7481,54.2597],[25.765,54.2212],[25.7652,54.1798],[25.7492,54.157],[25.6806,54.1405],[25.573,54.1399],[25.5104,54.1596],[25.4974,54.1752],[25.5273,54.2151],[25.5057,54.2649],[25.4611,54.2928],[25.3706,54.2512],[25.2837,54.2513],[25.1795,54.2143],[25.1114,54.1549],[25.0461,54.1331],[24.8695,54.1452],[24.8257,54.119],[24.7893,53.9982],[24.7682,53.9747],[24.6207,53.9798],[24.4785,53.9318],[24.318,53.893],[24.2366,53.92],[24.1913,53.9504],[24.1039,53.945],[24.0085,53.9316],[23.9444,53.939],[23.8726,53.9357],[23.7337,53.9123],[23.5591,53.9198],[23.4847,53.9398],[23.4776,53.9589],[23.483,54.006],[23.4813,54.079],[23.4536,54.1435],[23.3701,54.2005],[23.2823,54.2403],[23.1703,54.2814],[23.0875,54.2995],[23.0422,54.3042],[23.0319,54.3279],[23.0155,54.3483],[22.9768,54.3664],[22.8939,54.3905],[22.8237,54.3958],[22.7662,54.3568],[22.7243,54.4056],[22.6799,54.493],[22.6845,54.5629],[22.7097,54.6326],[22.8313,54.8385],[22.8247,54.8713],[22.7365,54.9289],[22.6274,54.9707],[22.5673,55.0591],[22.3464,55.0643],[22.1379,55.0594],[22.0724,55.0637],[21.8739,55.1007],[21.6827,55.1604],[21.5547,55.1953],[21.4471,55.2344],[21.3893,55.2755],[21.2976,55.2645],[21.2357,55.2641],[21.2363,55.2712],[21.2011,55.3438],[21.2379,55.455],[21.1711,55.6177],[21.0619,55.8134],[21.0538,56.0229],[21.0461,56.0701],[21.3146,56.1881],[21.6535,56.3146],[21.7306,56.326],[22.0429,56.4008],[22.0846,56.4067],[22.3659,56.3929],[22.5869,56.3751],[22.7732,56.3773],[22.8756,56.3964],[22.9683,56.3804],[23.043,56.3241],[23.1198,56.3307],[23.1959,56.3671],[23.6127,56.3338],[23.7067,56.3346],[23.8127,56.3292],[24.0082,56.2953],[24.1207,56.2643],[24.3679,56.283],[24.4736,56.2841],[24.529,56.2963],[24.6995,56.3813],[24.7732,56.3959],[24.841,56.4112],[24.903,56.3982],[24.9438,56.3256]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Lithuania","sov_a3":"LTU","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Lithuania","adm0_a3":"LTU","geou_dif":0,"geounit":"Lithuania","gu_a3":"LTU","su_dif":0,"subunit":"Lithuania","su_a3":"LTU","brk_diff":0,"name":"Lithuania","name_long":"Lithuania","brk_a3":"LTU","brk_name":"Lithuania","brk_group":"","abbrev":"Lith.","postal":"LT","formal_en":"Republic of Lithuania","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Lithuania","name_alt":"","mapcolor7":6,"mapcolor8":3,"mapcolor9":3,"mapcolor13":9,"pop_est":3555179,"gdp_md_est":63330,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"LT","iso_a3":"LTU","iso_n3":"440","un_a3":"440","wb_a2":"LT","wb_a3":"LTU","woe_id":-99,"adm0_a3_is":"LTU","adm0_a3_us":"LTU","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Northern Europe","region_wb":"Europe & Central Asia","name_len":9,"long_len":9,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[51.268,24.6072],[51.178,24.5867],[51.0934,24.5646],[51.0228,24.5652],[50.966,24.5739],[50.9283,24.5951],[50.8557,24.6796],[50.8044,24.7893],[50.8359,24.8504],[50.8468,24.8886],[50.7773,25.1774],[50.7546,25.3993],[50.7629,25.4447],[50.8026,25.4971],[50.8687,25.6127],[50.9038,25.7241],[51.0031,25.9814],[51.1081,26.0806],[51.2623,26.1533],[51.3891,26.0111],[51.5431,25.9024],[51.5723,25.781],[51.527,25.6821],[51.4854,25.5247],[51.5103,25.4523],[51.5195,25.3897],[51.5614,25.2845],[51.602,25.1479],[51.6089,25.0529],[51.5869,24.9648],[51.5334,24.8909],[51.4279,24.6683],[51.3965,24.6451],[51.268,24.6072]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Qatar","sov_a3":"QAT","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Qatar","adm0_a3":"QAT","geou_dif":0,"geounit":"Qatar","gu_a3":"QAT","su_dif":0,"subunit":"Qatar","su_a3":"QAT","brk_diff":0,"name":"Qatar","name_long":"Qatar","brk_a3":"QAT","brk_name":"Qatar","brk_group":"","abbrev":"Qatar","postal":"QA","formal_en":"State of Qatar","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Qatar","name_alt":"","mapcolor7":3,"mapcolor8":6,"mapcolor9":2,"mapcolor13":4,"pop_est":833285,"gdp_md_est":91330,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"6. Developing region","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"QA","iso_a3":"QAT","iso_n3":"634","un_a3":"634","wb_a2":"QA","wb_a3":"QAT","woe_id":-99,"adm0_a3_is":"QAT","adm0_a3_us":"QAT","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Western Asia","region_wb":"Middle East & North Africa","name_len":5,"long_len":5,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[28.2125,45.4504],[28.3177,45.3471],[28.4513,45.2922],[28.7607,45.2341],[28.7883,45.241],[28.7914,45.2519],[28.7698,45.2669],[28.7666,45.2862],[28.7817,45.3099],[28.8243,45.3111],[28.8943,45.2899],[29.0274,45.3206],[29.2235,45.4029],[29.4037,45.4197],[29.5677,45.3708],[29.652,45.3139],[29.7059,45.2599],[29.6891,45.1932],[29.6786,45.1517],[29.6354,44.9796],[29.6055,44.9155],[29.5575,44.8434],[29.0482,44.7576],[29.0811,44.7988],[29.0691,44.8711],[29.0478,44.9257],[29.0953,44.975],[28.9807,44.9929],[28.9306,44.9658],[28.8915,44.9187],[28.9262,44.81],[28.8704,44.75],[28.849,44.7163],[28.8465,44.6369],[28.8136,44.6025],[28.807,44.565],[28.8882,44.5748],[28.8518,44.5061],[28.6992,44.3742],[28.6454,44.2957],[28.6586,43.9838],[28.5907,43.7974],[28.5854,43.7422],[28.4234,43.7405],[28.3752,43.7448],[28.222,43.7729],[28.05,43.8224],[27.9489,43.9186],[27.8843,43.9874],[27.7386,43.9563],[27.7107,43.9646],[27.6709,43.9978],[27.561,44.0201],[27.4254,44.0205],[27.1207,44.1461],[27.0869,44.1674],[26.8478,44.1462],[26.4893,44.084],[26.2158,44.0073],[25.9334,43.8706],[25.8188,43.7668],[25.6861,43.7118],[25.4971,43.6708],[25.1597,43.6863],[24.8082,43.7384],[24.4306,43.7944],[24.2268,43.7635],[23.9508,43.7867],[23.5346,43.8536],[23.2246,43.8739],[22.919,43.8345],[22.8677,43.8646],[22.8564,43.899],[22.8683,43.9479],[22.9113,43.9872],[22.9854,44.017],[23.0244,44.0472],[23.0285,44.078],[22.9454,44.1273],[22.7752,44.1952],[22.7051,44.2378],[22.6879,44.2483],[22.6833,44.2865],[22.6479,44.3165],[22.5818,44.3383],[22.5307,44.378],[22.4945,44.4354],[22.5023,44.4896],[22.554,44.5403],[22.6201,44.5624],[22.7008,44.5555],[22.7344,44.5699],[22.7209,44.6055],[22.6421,44.651],[22.4977,44.7063],[22.3507,44.6761],[22.201,44.5607],[22.0931,44.5419],[22.027,44.6199],[21.9093,44.6661],[21.7402,44.6807],[21.6361,44.7104],[21.5971,44.7554],[21.5231,44.7901],[21.3601,44.8267],[21.3579,44.8618],[21.3844,44.8701],[21.4422,44.8734],[21.5199,44.8808],[21.5323,44.9007],[21.5332,44.9188],[21.472,44.942],[21.41,44.9577],[21.3777,44.9734],[21.357,44.9908],[21.3529,45.009],[21.3711,45.0214],[21.3959,45.0222],[21.4207,45.033],[21.4345,45.0751],[21.4679,45.1099],[21.4918,45.1223],[21.4902,45.1479],[21.4654,45.1719],[21.4314,45.1925],[21.3817,45.2051],[21.2265,45.2413],[21.1479,45.2917],[21.0999,45.2936],[21.0238,45.3215],[20.9418,45.3653],[20.8708,45.4275],[20.794,45.4679],[20.7742,45.4844],[20.7725,45.5001],[20.7865,45.5175],[20.786,45.5365],[20.7658,45.5975],[20.7793,45.662],[20.7758,45.7225],[20.775,45.7498],[20.7602,45.7581],[20.7469,45.749],[20.7278,45.7374],[20.7093,45.7353],[20.6527,45.7794],[20.5812,45.8695],[20.5326,45.8995],[20.438,45.9408],[20.3586,45.9755],[20.3014,46.0507],[20.2418,46.1086],[20.281,46.133],[20.5081,46.1669],[20.6137,46.1335],[20.661,46.1457],[20.7074,46.1728],[20.7327,46.1944],[20.7374,46.2175],[20.7603,46.2462],[20.837,46.2597],[21.0398,46.2422],[21.1217,46.2824],[21.152,46.3043],[21.1704,46.3527],[21.1918,46.3916],[21.2646,46.4123],[21.2633,46.4478],[21.2522,46.4864],[21.2945,46.5725],[21.3202,46.6078],[21.3613,46.6208],[21.411,46.6479],[21.4971,46.7043],[21.4771,46.7534],[21.4944,46.7897],[21.5842,46.8784],[21.6526,46.9638],[21.6515,47.0065],[21.6614,47.0439],[21.7218,47.0848],[21.7854,47.1381],[21.8693,47.3046],[21.8992,47.3326],[21.9543,47.3643],[21.9953,47.3957],[21.9997,47.505],[22.038,47.5366],[22.1119,47.572],[22.1851,47.6291],[22.2446,47.6964],[22.2906,47.7278],[22.3515,47.7362],[22.4175,47.7626],[22.4914,47.7726],[22.5629,47.7596],[22.6084,47.7663],[22.6768,47.799],[22.8518,47.9226],[22.8767,47.9473],[22.9129,47.9643],[23.0548,48.0065],[23.0908,48.0491],[23.1395,48.0874],[23.2026,48.0845],[23.4082,47.99],[23.6287,47.9958],[23.669,47.9923],[23.682,47.9904],[23.709,47.9826],[24.0019,47.9358],[24.0474,47.941],[24.0598,47.9448],[24.1777,47.9061],[24.2819,47.9112],[24.381,47.938],[24.4841,47.9471],[24.5789,47.9311],[24.651,47.8765],[24.8379,47.7608],[24.8934,47.7178],[24.9791,47.7241],[25.0738,47.7457],[25.1696,47.8231],[25.4643,47.9108],[25.6893,47.9325],[25.9087,47.9676],[26.1627,47.9925],[26.2362,48.0644],[26.277,48.1132],[26.3057,48.2038],[26.4424,48.23],[26.5725,48.2485],[26.6189,48.2599],[26.7138,48.2635],[26.7873,48.2558],[26.901,48.2111],[26.9808,48.155],[27.0122,48.1105],[27.0804,48.0477],[27.1521,47.9593],[27.2309,47.8417],[27.2481,47.7822],[27.2779,47.718],[27.3369,47.6397],[27.4492,47.5531],[27.4648,47.5367],[27.5158,47.4756],[27.6141,47.3405],[27.6962,47.2864],[27.768,47.2276],[27.8023,47.1683],[27.8538,47.1145],[27.9742,47.0432],[28.0718,46.9784],[28.15,46.7921],[28.2047,46.7064],[28.2395,46.6408],[28.2227,46.5081],[28.2443,46.4513],[28.1996,46.3476],[28.1191,46.1387],[28.0997,45.9726],[28.1136,45.8831],[28.1155,45.8255],[28.135,45.7889],[28.1563,45.7131],[28.1598,45.6471],[28.1309,45.6283],[28.0903,45.6127],[28.0747,45.599],[28.1119,45.5691],[28.1625,45.5138],[28.2125,45.4504]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Romania","sov_a3":"ROU","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Romania","adm0_a3":"ROU","geou_dif":0,"geounit":"Romania","gu_a3":"ROU","su_dif":0,"subunit":"Romania","su_a3":"ROU","brk_diff":0,"name":"Romania","name_long":"Romania","brk_a3":"ROU","brk_name":"Romania","brk_group":"","abbrev":"Rom.","postal":"RO","formal_en":"Romania","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Romania","name_alt":"","mapcolor7":1,"mapcolor8":4,"mapcolor9":3,"mapcolor13":13,"pop_est":22215421,"gdp_md_est":271400,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"RO","iso_a3":"ROU","iso_n3":"642","un_a3":"642","wb_a2":"RO","wb_a3":"ROM","woe_id":-99,"adm0_a3_is":"ROU","adm0_a3_us":"ROU","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Eastern Europe","region_wb":"Europe & Central Asia","name_len":7,"long_len":7,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[41.9877,16.7156],[42.065,16.7101],[42.0332,16.7419],[42.0264,16.7577],[42.06,16.8035],[42.1704,16.7086],[42.1672,16.5964],[42.1578,16.5707],[42.1277,16.5948],[42.1084,16.6185],[42.1023,16.6439],[42.0718,16.6715],[41.9642,16.6535],[41.8973,16.6843],[41.8016,16.7788],[41.7761,16.8469],[41.8161,16.8602],[41.8582,16.8929],[41.885,16.9468],[41.8604,17.0025],[41.9173,16.9937],[41.9479,16.9364],[41.9539,16.8063],[41.9625,16.7787],[41.9467,16.7489],[41.9877,16.7156]],[[36.9017,25.3831],[36.8752,25.3831],[36.8051,25.4507],[36.7639,25.5006],[36.7221,25.534],[36.5303,25.6016],[36.5043,25.6451],[36.5336,25.6887],[36.5541,25.6454],[36.5888,25.6198],[36.7476,25.5587],[36.9244,25.4255],[36.9548,25.4146],[36.9017,25.3831]],[[36.5955,25.7128],[36.5861,25.6992],[36.5439,25.7343],[36.5465,25.8116],[36.5827,25.8555],[36.5799,25.7954],[36.5956,25.7349],[36.5955,25.7128]],[[44.7165,29.1936],[45.0503,29.1671],[45.4989,29.1315],[45.9497,29.0958],[46.3564,29.0637],[46.5314,29.0962],[46.7248,29.0746],[46.9822,29.0457],[47.1388,29.0262],[47.4332,28.9896],[47.5213,28.8378],[47.5532,28.7315],[47.5831,28.628],[47.6713,28.5332],[47.872,28.5354],[48.0496,28.5375],[48.2688,28.5405],[48.4425,28.5429],[48.4985,28.4489],[48.523,28.355],[48.6264,28.1326],[48.7737,27.9591],[48.809,27.8959],[48.8328,27.8007],[48.8072,27.7653],[48.7972,27.7243],[48.9064,27.6291],[49.0869,27.5486],[49.1575,27.5282],[49.2375,27.4927],[49.1751,27.4376],[49.2815,27.3105],[49.4053,27.181],[49.5377,27.1518],[49.7165,26.9559],[49.9861,26.8289],[50.1498,26.6626],[50.1347,26.6595],[50.0866,26.6764],[50.0264,26.6992],[50.0081,26.6785],[50.0113,26.6088],[50.0273,26.5269],[50.1107,26.456],[50.185,26.4049],[50.2139,26.3085],[50.1555,26.1005],[50.1353,26.1007],[50.096,26.1187],[50.0539,26.1229],[50.0316,26.111],[50.0811,25.9614],[50.1303,25.8466],[50.1896,25.7558],[50.239,25.6229],[50.2812,25.5661],[50.4552,25.4248],[50.5085,25.3067],[50.5579,25.0867],[50.6669,24.9638],[50.7256,24.8694],[50.8044,24.7893],[50.8557,24.6796],[50.9283,24.5951],[50.966,24.5739],[51.0228,24.5652],[51.0934,24.5646],[51.178,24.5867],[51.268,24.6072],[51.3385,24.5644],[51.4112,24.5708],[51.4184,24.531],[51.3699,24.4769],[51.3099,24.3404],[51.3952,24.3188],[51.4768,24.3082],[51.5348,24.2863],[51.5684,24.2862],[51.5684,24.2579],[51.5722,24.1283],[51.5926,24.0789],[51.6293,24.035],[51.6844,23.9695],[51.7394,23.904],[51.7943,23.8385],[51.8494,23.773],[51.9044,23.7075],[51.9595,23.642],[52.0145,23.5765],[52.0694,23.511],[52.1245,23.4455],[52.1795,23.38],[52.2346,23.3145],[52.2896,23.249],[52.3445,23.1835],[52.3996,23.118],[52.4546,23.0524],[52.5096,22.987],[52.5551,22.9328],[52.6392,22.9225],[52.6659,22.9193],[52.7416,22.91],[52.8593,22.8956],[53.0119,22.877],[53.1924,22.8549],[53.394,22.8303],[53.6096,22.804],[53.8321,22.7768],[54.0546,22.7497],[54.2701,22.7233],[54.4717,22.6987],[54.6522,22.6767],[54.8049,22.658],[54.9225,22.6437],[54.9982,22.6344],[55.025,22.6312],[55.1043,22.6215],[55.1194,22.6239],[55.1858,22.7041],[55.2593,22.5909],[55.3201,22.4969],[55.4038,22.3678],[55.4928,22.2307],[55.5777,22.0995],[55.641,22.0019],[55.6074,21.9004],[55.5708,21.7897],[55.5342,21.679],[55.4976,21.5683],[55.4609,21.4576],[55.4243,21.3469],[55.3877,21.2362],[55.3511,21.1255],[55.3145,21.0148],[55.2779,20.9041],[55.2412,20.7934],[55.2046,20.6827],[55.1681,20.572],[55.1314,20.4613],[55.0947,20.3506],[55.0582,20.2399],[55.0215,20.1292],[54.9773,19.9959],[54.8711,19.9605],[54.699,19.9031],[54.5271,19.8458],[54.355,19.7885],[54.183,19.7312],[54.0109,19.6738],[53.8389,19.6165],[53.6669,19.5591],[53.4948,19.5018],[53.3229,19.4445],[53.1508,19.3872],[52.9787,19.3298],[52.8067,19.2725],[52.6347,19.2151],[52.4627,19.1578],[52.2906,19.1005],[52.1186,19.0432],[51.9776,18.9961],[51.743,18.9646],[51.5149,18.9339],[51.2584,18.8994],[50.95,18.8579],[50.7082,18.8253],[50.3553,18.7778],[50.039,18.7353],[49.7421,18.6953],[49.4451,18.6553],[49.1924,18.6213],[49.042,18.5818],[48.8648,18.4952],[48.593,18.3624],[48.3158,18.2271],[48.1722,18.1569],[48.0217,17.977],[47.9455,17.8858],[47.8078,17.7211],[47.7037,17.5968],[47.5796,17.4483],[47.5254,17.3161],[47.4418,17.1119],[47.3696,17.0604],[47.2513,16.9939],[47.1436,16.9467],[46.9757,16.9535],[46.88,17.079],[46.7785,17.2121],[46.7276,17.2656],[46.682,17.2686],[46.5135,17.2517],[46.3104,17.2313],[46.0708,17.2532],[45.7944,17.2784],[45.5354,17.3021],[45.4065,17.3198],[45.2366,17.4062],[45.1928,17.4234],[45.148,17.4274],[44.9465,17.4296],[44.7468,17.4317],[44.5465,17.4043],[44.3547,17.4144],[44.156,17.3985],[44.0859,17.3655],[44.0082,17.3675],[43.9597,17.3383],[43.917,17.3247],[43.8664,17.3496],[43.8043,17.3441],[43.713,17.3655],[43.6534,17.4219],[43.5973,17.4714],[43.5393,17.4987],[43.4742,17.5159],[43.418,17.5163],[43.3461,17.486],[43.3021,17.4568],[43.1909,17.3594],[43.1863,17.3247],[43.2369,17.2665],[43.2214,17.2393],[43.156,17.205],[43.1359,17.113],[43.1262,17.0625],[43.1165,16.942],[43.1456,16.8468],[43.1845,16.8118],[43.1863,16.771],[43.165,16.6894],[43.1048,16.6642],[43.0607,16.5866],[43.0336,16.5504],[42.9863,16.5091],[42.7993,16.3718],[42.7898,16.4516],[42.7307,16.5698],[42.7264,16.6533],[42.6988,16.737],[42.6475,16.8014],[42.5529,16.8685],[42.5441,16.9597],[42.475,17.0499],[42.3833,17.1225],[42.3324,17.2566],[42.2939,17.435],[42.0522,17.6693],[41.75,17.8857],[41.658,18.0077],[41.5076,18.2561],[41.4317,18.4524],[41.2295,18.6784],[41.2208,18.7652],[41.1908,18.8712],[41.1441,18.9891],[41.116,19.0822],[40.9133,19.4901],[40.8479,19.5553],[40.7916,19.6464],[40.7771,19.7169],[40.7592,19.7555],[40.6159,19.8224],[40.4822,19.9935],[40.0807,20.2659],[39.8841,20.293],[39.7283,20.3903],[39.6137,20.5177],[39.4912,20.737],[39.2761,20.974],[39.0936,21.3104],[39.1507,21.4328],[39.1471,21.519],[39.091,21.664],[39.0298,21.776],[38.9879,21.8817],[39.0212,22.0334],[39.034,22.2034],[39.0699,22.2937],[39.0959,22.3928],[39.062,22.5922],[39.0014,22.699],[39.0074,22.7701],[38.9388,22.8048],[38.8829,22.882],[38.9411,22.8818],[38.8355,22.9891],[38.7969,23.0486],[38.757,23.1943],[38.7061,23.3055],[38.5423,23.5579],[38.4642,23.7119],[38.2889,23.911],[38.0986,24.058],[37.9778,24.1246],[37.9197,24.1854],[37.821,24.1875],[37.7134,24.2744],[37.6382,24.2777],[37.5431,24.2917],[37.431,24.459],[37.3385,24.6158],[37.1809,24.82],[37.2204,24.8733],[37.2663,24.9601],[37.2435,25.0734],[37.2184,25.1507],[37.1488,25.2911],[36.9207,25.6412],[36.8602,25.6925],[36.7627,25.7513],[36.7025,25.9029],[36.6752,26.0389],[36.5188,26.1049],[36.2496,26.5948],[36.0938,26.7658],[36.032,26.881],[35.8517,27.0705],[35.763,27.2588],[35.5813,27.4325],[35.4238,27.7338],[35.1805,28.0349],[35.0783,28.087],[34.8275,28.1086],[34.7221,28.1307],[34.625,28.0645],[34.6162,28.1483],[34.6833,28.2641],[34.7799,28.5073],[34.7991,28.7205],[34.9508,29.3535],[35.1638,29.3209],[35.3392,29.2941],[35.5953,29.2549],[35.8604,29.2143],[36.0154,29.1905],[36.0685,29.2005],[36.2828,29.3554],[36.4761,29.4951],[36.5918,29.6661],[36.7039,29.8316],[36.7553,29.866],[36.9271,29.8971],[37.1994,29.9463],[37.4692,29.9951],[37.4907,30.0117],[37.5536,30.1446],[37.6336,30.3133],[37.6499,30.331],[37.6697,30.3481],[37.8629,30.4426],[37.9801,30.5],[37.813,30.6693],[37.6555,30.829],[37.479,31.0078],[37.3295,31.1468],[37.1053,31.3552],[36.9586,31.4915],[37.2156,31.5561],[37.4934,31.6259],[37.7738,31.6963],[38.1114,31.7812],[38.3755,31.8475],[38.7696,31.9465],[38.9623,31.9949],[38.9971,32.0075],[39.1454,32.1245],[39.3687,32.0917],[39.7041,32.0425],[40.0278,31.995],[40.3693,31.939],[40.4789,31.8934],[40.8084,31.7254],[41.0225,31.6164],[41.2725,31.489],[41.5851,31.3297],[41.7997,31.2204],[42.0744,31.0804],[42.2886,30.9204],[42.5598,30.7178],[42.8577,30.4952],[43.1031,30.3222],[43.4408,30.084],[43.7737,29.8492],[44.0996,29.6193],[44.3607,29.4353],[44.6908,29.2023],[44.7165,29.1936]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Saudi Arabia","sov_a3":"SAU","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Saudi Arabia","adm0_a3":"SAU","geou_dif":0,"geounit":"Saudi Arabia","gu_a3":"SAU","su_dif":0,"subunit":"Saudi Arabia","su_a3":"SAU","brk_diff":0,"name":"Saudi Arabia","name_long":"Saudi Arabia","brk_a3":"SAU","brk_name":"Saudi Arabia","brk_group":"","abbrev":"Saud.","postal":"SA","formal_en":"Kingdom of Saudi Arabia","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Saudi Arabia","name_alt":"","mapcolor7":6,"mapcolor8":1,"mapcolor9":6,"mapcolor13":7,"pop_est":28686633,"gdp_md_est":576500,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"SA","iso_a3":"SAU","iso_n3":"682","un_a3":"682","wb_a2":"SA","wb_a3":"SAU","woe_id":-99,"adm0_a3_is":"SAU","adm0_a3_us":"SAU","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Western Asia","region_wb":"Middle East & North Africa","name_len":12,"long_len":12,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[131.1724,3.0262],[131.1496,3.0219],[131.135,3.0252],[131.1367,3.0395],[131.1516,3.0541],[131.1724,3.0606],[131.1879,3.0556],[131.1863,3.0421],[131.1724,3.0262]],[[134.5954,7.382],[134.5347,7.3606],[134.5063,7.4371],[134.5157,7.5258],[134.556,7.5939],[134.5997,7.6158],[134.6087,7.6236],[134.6512,7.7121],[134.6596,7.6633],[134.6327,7.5013],[134.5982,7.4383],[134.5954,7.382]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":6,"sovereignt":"Palau","sov_a3":"PLW","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Palau","adm0_a3":"PLW","geou_dif":0,"geounit":"Palau","gu_a3":"PLW","su_dif":0,"subunit":"Palau","su_a3":"PLW","brk_diff":0,"name":"Palau","name_long":"Palau","brk_a3":"PLW","brk_name":"Palau","brk_group":"","abbrev":"Palau","postal":"PW","formal_en":"Republic of Palau","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Palau","name_alt":"","mapcolor7":2,"mapcolor8":5,"mapcolor9":1,"mapcolor13":12,"pop_est":20796,"gdp_md_est":164,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"6. Developing region","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"PW","iso_a3":"PLW","iso_n3":"585","un_a3":"585","wb_a2":"PW","wb_a3":"PLW","woe_id":-99,"adm0_a3_is":"PLW","adm0_a3_us":"PLW","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Oceania","region_un":"Oceania","subregion":"Micronesia","region_wb":"East Asia & Pacific","name_len":5,"long_len":5,"abbrev_len":5,"tiny":2,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[19.6044,54.4592],[19.6442,54.4471],[19.9243,54.434],[20.2082,54.4208],[20.6647,54.4066],[21.1405,54.3918],[21.6342,54.3765],[22.1685,54.3599],[22.7318,54.3501],[22.7662,54.3568],[22.8237,54.3958],[22.8939,54.3905],[22.9768,54.3664],[23.0155,54.3483],[23.0319,54.3279],[23.0422,54.3042],[23.0875,54.2995],[23.1703,54.2814],[23.2823,54.2403],[23.3701,54.2005],[23.4536,54.1435],[23.4813,54.079],[23.483,54.006],[23.4776,53.9589],[23.4847,53.9398],[23.5989,53.5992],[23.7893,53.2709],[23.8592,53.1121],[23.8871,53.0275],[23.9094,52.9049],[23.9163,52.8188],[23.9154,52.7703],[23.9013,52.7036],[23.8447,52.6642],[23.4796,52.5516],[23.4109,52.5162],[23.3033,52.4284],[23.2041,52.3379],[23.1813,52.307],[23.1751,52.2866],[23.197,52.2569],[23.3271,52.2084],[23.4584,52.1695],[23.5012,52.1404],[23.5979,52.1031],[23.6333,52.0696],[23.6524,52.0404],[23.6511,51.973],[23.6074,51.8798],[23.6257,51.8093],[23.5813,51.7624],[23.5448,51.7103],[23.5396,51.6189],[23.6053,51.5179],[23.6589,51.449],[23.6797,51.3949],[23.6576,51.3525],[23.6645,51.3101],[23.7122,51.2651],[23.8635,51.1262],[23.9381,50.9925],[23.9857,50.9404],[24.0958,50.8728],[24.1058,50.845],[24.0616,50.8195],[24.026,50.8162],[23.9971,50.8094],[23.9784,50.7856],[24.0073,50.7602],[24.0463,50.7228],[24.0947,50.617],[24.0899,50.5305],[24.0526,50.5084],[24.005,50.457],[23.9727,50.4101],[23.7117,50.3773],[23.649,50.3271],[23.5062,50.2298],[23.4086,50.1739],[23.2645,50.0729],[23.0363,49.8991],[22.9522,49.8264],[22.8907,49.7663],[22.7062,49.6062],[22.6494,49.539],[22.6606,49.4837],[22.7199,49.3538],[22.7324,49.2952],[22.722,49.241],[22.7023,49.1927],[22.7057,49.1712],[22.7602,49.1362],[22.8471,49.0813],[22.8521,49.0627],[22.8397,49.0389],[22.8098,49.0208],[22.7013,49.0399],[22.58,49.0772],[22.5387,49.0727],[22.473,49.0813],[22.2025,49.1532],[22.0201,49.2095],[22.0021,49.2461],[21.9677,49.2991],[21.8901,49.3435],[21.7121,49.3819],[21.6396,49.412],[21.3505,49.4288],[21.225,49.4294],[21.1361,49.417],[21.0794,49.4183],[21.0012,49.3398],[20.9473,49.3171],[20.8685,49.3147],[20.7995,49.3287],[20.729,49.3699],[20.6161,49.3917],[20.5346,49.3812],[20.4745,49.3902],[20.4227,49.3923],[20.4047,49.3841],[20.363,49.3853],[20.3025,49.3655],[20.2365,49.3376],[20.1637,49.3164],[20.1076,49.2708],[20.0576,49.1813],[19.9161,49.2214],[19.8689,49.204],[19.8022,49.1923],[19.7566,49.2044],[19.7674,49.2352],[19.788,49.27],[19.787,49.3186],[19.7739,49.3722],[19.7301,49.3896],[19.6642,49.396],[19.6303,49.4066],[19.6267,49.4244],[19.5931,49.4471],[19.5348,49.5048],[19.4797,49.5764],[19.4416,49.5977],[19.3862,49.5636],[19.3023,49.5249],[19.2502,49.5114],[19.1494,49.4],[18.9684,49.3962],[18.9572,49.4483],[18.9382,49.4983],[18.8322,49.5108],[18.8293,49.5401],[18.8069,49.6137],[18.5946,49.7578],[18.5688,49.8179],[18.5771,49.8411],[18.5624,49.8793],[18.5162,49.9024],[18.3484,49.9298],[18.3053,49.9141],[18.2663,49.9303],[18.2053,49.9647],[18.0992,49.9928],[18.0877,50.0073],[18.0495,50.0319],[18.0283,50.0353],[18.0146,50.0203],[17.9838,49.9991],[17.8748,49.9723],[17.8313,49.9833],[17.7917,50.0066],[17.7466,50.0568],[17.6811,50.1008],[17.6271,50.1164],[17.5963,50.1395],[17.5894,50.1575],[17.7093,50.1936],[17.7354,50.2308],[17.7201,50.2986],[17.7022,50.3072],[17.6547,50.2842],[17.5546,50.2641],[17.4623,50.2548],[17.4152,50.2548],[17.152,50.3783],[16.9808,50.4161],[16.8801,50.4271],[16.8691,50.4145],[16.9147,50.3452],[16.9934,50.2597],[16.9896,50.2369],[16.8953,50.202],[16.8418,50.1867],[16.7786,50.157],[16.7253,50.1161],[16.6791,50.0975],[16.6392,50.1021],[16.5967,50.1219],[16.4876,50.2484],[16.3505,50.3452],[16.3342,50.3669],[16.2913,50.3719],[16.2308,50.3941],[16.2104,50.4237],[16.2407,50.4547],[16.2825,50.483],[16.3566,50.5005],[16.3791,50.5169],[16.3923,50.5417],[16.4197,50.5736],[16.4125,50.5852],[16.36,50.6214],[16.2822,50.6556],[16.0664,50.6299],[16.0072,50.6116],[15.9738,50.6354],[15.9485,50.6703],[15.8939,50.6769],[15.8192,50.7087],[15.7306,50.7397],[15.6439,50.7489],[15.464,50.7938],[15.3946,50.7963],[15.3544,50.8118],[15.3126,50.8458],[15.2771,50.883],[15.2586,50.9585],[15.126,50.9929],[14.9938,51.0144],[14.9845,51.0034],[14.9899,50.9272],[14.9829,50.8866],[14.8958,50.8614],[14.8094,50.859],[14.8143,50.8716],[14.9175,51.0087],[14.9639,51.0951],[15.0166,51.2527],[14.9531,51.3771],[14.9355,51.4354],[14.906,51.4633],[14.7247,51.5239],[14.7109,51.5449],[14.7387,51.6271],[14.7249,51.6617],[14.6813,51.6982],[14.6239,51.7708],[14.6017,51.8324],[14.6749,51.9048],[14.693,51.958],[14.7248,52.0309],[14.7481,52.0708],[14.7525,52.0818],[14.7046,52.1102],[14.6924,52.15],[14.7054,52.2075],[14.6799,52.25],[14.6156,52.2776],[14.5739,52.3142],[14.5546,52.3597],[14.5697,52.4311],[14.6194,52.5285],[14.5141,52.6456],[14.2537,52.7825],[14.1286,52.8782],[14.1389,52.9329],[14.1937,52.9823],[14.2932,53.0268],[14.3686,53.1056],[14.4109,53.199],[14.4123,53.2167],[14.4146,53.2835],[14.2987,53.5564],[14.2799,53.6248],[14.2661,53.7071],[14.2589,53.7296],[14.4876,53.6719],[14.5835,53.6394],[14.5716,53.6759],[14.5521,53.7073],[14.5649,53.7535],[14.5584,53.8232],[14.3509,53.8587],[14.2137,53.8708],[14.1982,53.919],[14.2114,53.9503],[14.2493,53.9319],[14.3842,53.9247],[14.7157,54.0183],[15.2884,54.1399],[15.9,54.254],[16.0428,54.2664],[16.1863,54.2904],[16.2394,54.3331],[16.2923,54.3616],[16.3756,54.4369],[16.5598,54.5538],[16.8854,54.5964],[17.007,54.6519],[17.2619,54.7295],[17.843,54.8167],[18.0856,54.8358],[18.3234,54.8382],[18.5352,54.7694],[18.7593,54.6846],[18.7996,54.6333],[18.6783,54.6653],[18.5016,54.7415],[18.4362,54.7447],[18.5871,54.5129],[18.6696,54.4309],[18.8364,54.3696],[18.9763,54.3489],[19.4071,54.3861],[19.5602,54.4346],[19.6044,54.4592]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Poland","sov_a3":"POL","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Poland","adm0_a3":"POL","geou_dif":0,"geounit":"Poland","gu_a3":"POL","su_dif":0,"subunit":"Poland","su_a3":"POL","brk_diff":0,"name":"Poland","name_long":"Poland","brk_a3":"POL","brk_name":"Poland","brk_group":"","abbrev":"Pol.","postal":"PL","formal_en":"Republic of Poland","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Poland","name_alt":"","mapcolor7":3,"mapcolor8":7,"mapcolor9":1,"mapcolor13":2,"pop_est":38482919,"gdp_md_est":667900,"pop_year":-99,"lastcensus":2011,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"PL","iso_a3":"POL","iso_n3":"616","un_a3":"616","wb_a2":"PL","wb_a3":"POL","woe_id":-99,"adm0_a3_is":"POL","adm0_a3_us":"POL","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Eastern Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":6,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[124.9053,39.5363],[124.8489,39.5076],[124.8461,39.5589],[124.8896,39.6021],[124.9346,39.6078],[124.9053,39.5363]],[[129.977,42.9749],[130.0223,42.9626],[130.0826,42.9742],[130.1248,42.956],[130.1513,42.918],[130.2403,42.8918],[130.2488,42.8726],[130.2467,42.7448],[130.2956,42.685],[130.3607,42.6309],[130.4503,42.5817],[130.4982,42.5705],[130.527,42.5354],[130.5541,42.4747],[130.618,42.4156],[130.6516,42.3725],[130.658,42.3278],[130.6873,42.3025],[130.6365,42.2749],[130.5692,42.2917],[130.4575,42.3017],[130.3147,42.2141],[130.2357,42.1832],[130.1799,42.097],[130.0683,42.0458],[130.0073,41.9912],[129.9282,41.8967],[129.8764,41.8055],[129.7563,41.7123],[129.6863,41.595],[129.6824,41.4943],[129.759,41.3915],[129.7658,41.3039],[129.7121,41.1237],[129.742,40.9323],[129.7087,40.8573],[129.3411,40.7263],[129.2451,40.661],[129.1098,40.4911],[128.9452,40.4279],[128.843,40.3585],[128.7014,40.3175],[128.6107,40.1979],[128.5112,40.1302],[128.393,40.089],[128.3045,40.0359],[128.1063,40.0326],[127.9666,39.9956],[127.8671,39.8959],[127.5682,39.782],[127.5274,39.6957],[127.5473,39.5628],[127.5489,39.4611],[127.5229,39.3774],[127.4574,39.401],[127.4223,39.3736],[127.3835,39.2961],[127.3945,39.2079],[127.497,39.1795],[127.581,39.1433],[127.6989,39.125],[127.7861,39.0841],[127.9717,38.898],[128.123,38.8164],[128.1625,38.7861],[128.2494,38.7452],[128.3295,38.6809],[128.3746,38.6234],[128.3395,38.6079],[128.2793,38.5238],[128.2231,38.417],[128.1687,38.3593],[128.1063,38.3273],[128.039,38.3085],[127.9053,38.3004],[127.7847,38.3077],[127.7455,38.3192],[127.5795,38.3125],[127.5327,38.305],[127.294,38.3133],[127.1695,38.3045],[127.0903,38.2839],[127.0097,38.2405],[126.94,38.1756],[126.8789,38.1061],[126.7543,37.979],[126.6668,37.9172],[126.6665,37.8279],[126.6646,37.8007],[126.6339,37.7818],[126.6232,37.7902],[126.5728,37.7968],[126.3699,37.8784],[126.2031,37.8285],[126.161,37.7637],[126.1167,37.7429],[126.0503,37.8698],[125.9417,37.8737],[125.7691,37.9854],[125.695,37.9627],[125.6762,37.9177],[125.5815,37.815],[125.4493,37.7302],[125.4066,37.719],[125.3578,37.7248],[125.3648,37.7482],[125.3107,37.8435],[125.102,37.8821],[125.0268,37.9226],[124.9888,37.9314],[125.1932,38.0378],[125.2467,38.0568],[125.2067,38.0815],[125.1626,38.0937],[124.995,38.0778],[124.907,38.1126],[124.7795,38.1015],[124.6909,38.1292],[124.8745,38.2334],[124.8827,38.295],[124.8806,38.3417],[124.9737,38.4801],[125.0674,38.5567],[125.3097,38.6654],[125.4153,38.6804],[125.4918,38.6761],[125.5545,38.6862],[125.4887,38.7278],[125.4242,38.7469],[125.2989,38.743],[125.1688,38.8055],[125.1573,38.8715],[125.4097,39.2884],[125.4132,39.3263],[125.3736,39.4276],[125.3608,39.5266],[125.1801,39.5835],[125.1001,39.5903],[124.8679,39.7018],[124.7753,39.7581],[124.7389,39.7415],[124.7322,39.6522],[124.6992,39.6324],[124.6383,39.6151],[124.6076,39.7169],[124.5574,39.7906],[124.4038,39.8655],[124.3486,39.9069],[124.3751,39.9961],[124.3621,40.0041],[124.3866,40.1042],[124.4811,40.1816],[124.7124,40.3192],[124.772,40.3837],[124.8894,40.4598],[124.9423,40.4582],[124.9969,40.4647],[125.0134,40.4979],[125.026,40.5239],[125.0729,40.5475],[125.1859,40.5894],[125.3145,40.6446],[125.4169,40.6599],[125.5426,40.7426],[125.5938,40.779],[125.6451,40.779],[125.6592,40.7959],[125.6883,40.8387],[125.7283,40.8667],[125.784,40.872],[125.8749,40.8922],[125.9891,40.9046],[126.0668,40.9741],[126.0932,41.0237],[126.1445,41.0783],[126.2536,41.1378],[126.3287,41.2257],[126.4118,41.3213],[126.4515,41.3519],[126.4904,41.3581],[126.5136,41.394],[126.5401,41.4956],[126.5783,41.5943],[126.6013,41.641],[126.697,41.6919],[126.7216,41.7166],[126.7431,41.7249],[126.7877,41.7182],[126.8473,41.748],[126.9035,41.7811],[126.9548,41.7695],[127.0069,41.742],[127.0613,41.6874],[127.0854,41.6438],[127.1284,41.6074],[127.1367,41.5545],[127.1797,41.5313],[127.2708,41.5198],[127.4203,41.4838],[127.517,41.4817],[127.5722,41.4547],[127.6877,41.44],[127.9187,41.4611],[128.0131,41.4487],[128.0527,41.4156],[128.1112,41.3893],[128.1494,41.3877],[128.2003,41.433],[128.2549,41.5065],[128.2909,41.5628],[128.2893,41.6074],[128.2578,41.6554],[128.1817,41.7],[128.1319,41.7691],[128.0842,41.8406],[128.0561,41.8638],[128.0329,41.8985],[128.0287,41.9516],[128.0452,41.9875],[128.1602,42.0116],[128.3078,42.0256],[128.4272,42.0107],[128.6268,42.0208],[128.749,42.0407],[128.8398,42.0378],[128.9234,42.0382],[128.9606,42.0688],[129.0772,42.1424],[129.1337,42.1685],[129.1955,42.2185],[129.2054,42.2706],[129.2178,42.3127],[129.2525,42.3579],[129.3137,42.4136],[129.3658,42.4392],[129.4236,42.4359],[129.4849,42.4103],[129.5237,42.3847],[129.5676,42.3921],[129.6039,42.4359],[129.6279,42.4443],[129.6979,42.4481],[129.7197,42.475],[129.7465,42.6038],[129.7734,42.7055],[129.7792,42.7766],[129.8415,42.8942],[129.861,42.9651],[129.8982,42.9981],[129.9412,42.9957],[129.977,42.9749]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"North Korea","sov_a3":"PRK","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"North Korea","adm0_a3":"PRK","geou_dif":0,"geounit":"North Korea","gu_a3":"PRK","su_dif":0,"subunit":"North Korea","su_a3":"PRK","brk_diff":0,"name":"Dem. Rep. Korea","name_long":"Dem. Rep. Korea","brk_a3":"PRK","brk_name":"Dem. Rep. Korea","brk_group":"","abbrev":"N.K.","postal":"KP","formal_en":"Democratic People's Republic of Korea","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Korea, Dem. Rep.","name_alt":"","mapcolor7":3,"mapcolor8":5,"mapcolor9":3,"mapcolor13":9,"pop_est":22665345,"gdp_md_est":40000,"pop_year":-99,"lastcensus":2009,"gdp_year":-99,"economy":"7. Least developed region","income_grp":"5. Low income","wikipedia":-99,"fips_10":"","iso_a2":"KP","iso_a3":"PRK","iso_n3":"408","un_a3":"408","wb_a2":"KP","wb_a3":"PRK","woe_id":-99,"adm0_a3_is":"PRK","adm0_a3_us":"PRK","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Eastern Asia","region_wb":"East Asia & Pacific","name_len":15,"long_len":15,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[163.6352,58.6034],[163.4714,58.5094],[163.4473,58.5247],[163.4318,58.5461],[163.4272,58.579],[163.5768,58.6409],[163.7266,58.7985],[163.7845,58.9297],[163.7666,58.9724],[163.7609,59.015],[164.2021,59.0962],[164.5174,59.2268],[164.5727,59.2211],[164.6293,59.1122],[164.6616,58.9708],[164.6157,58.8856],[164.2788,58.8381],[163.9601,58.7438],[163.6352,58.6034]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Russia","sov_a3":"RUS","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Russia","adm0_a3":"RUS","geou_dif":0,"geounit":"Russia","gu_a3":"RUS","su_dif":0,"subunit":"Russia","su_a3":"RUS","brk_diff":0,"name":"Russia","name_long":"Russian Federation","brk_a3":"RUS","brk_name":"Russia","brk_group":"","abbrev":"Rus.","postal":"RUS","formal_en":"Russian Federation","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Russian Federation","name_alt":"","mapcolor7":2,"mapcolor8":5,"mapcolor9":7,"mapcolor13":7,"pop_est":140041247,"gdp_md_est":2266000,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"3. Emerging region: BRIC","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"RU","iso_a3":"RUS","iso_n3":"643","un_a3":"643","wb_a2":"RU","wb_a3":"RUS","woe_id":-99,"adm0_a3_is":"RUS","adm0_a3_us":"RUS","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Eastern Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":18,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[34.3483,31.2929],[34.2453,31.2083],[34.2125,31.2923],[34.1981,31.3226],[34.3873,31.4838],[34.4773,31.5849],[34.5241,31.5417],[34.5256,31.5256],[34.3502,31.3627],[34.3483,31.2929]],[[35.5314,31.9849],[35.559,31.7655],[35.4994,31.6724],[35.4654,31.5624],[35.4506,31.4793],[35.4087,31.4829],[35.2767,31.4228],[35.1012,31.3662],[34.9078,31.3513],[34.8805,31.3682],[34.8728,31.3969],[34.9292,31.5366],[34.951,31.6023],[35.0347,31.6732],[35.1534,31.7345],[35.2037,31.75],[35.198,31.7763],[35.1271,31.8167],[35.0532,31.8379],[34.983,31.8168],[34.9611,31.8233],[34.9538,31.8413],[34.9783,31.8664],[34.9897,31.9133],[34.9788,31.9916],[34.9714,32.0871],[34.956,32.1609],[34.9995,32.2811],[35.0105,32.3382],[35.065,32.4604],[35.1933,32.5344],[35.3038,32.5129],[35.3621,32.5075],[35.3867,32.493],[35.4026,32.4506],[35.4844,32.4017],[35.5515,32.3955],[35.5721,32.2379],[35.5348,32.103],[35.5314,31.9849]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":5,"sovereignt":"Israel","sov_a3":"ISR","adm0_dif":1,"level":2,"type":"Disputed","admin":"Palestine","adm0_a3":"PSX","geou_dif":0,"geounit":"Palestine","gu_a3":"PSX","su_dif":0,"subunit":"Palestine","su_a3":"PSX","brk_diff":0,"name":"Palestine","name_long":"Palestine","brk_a3":"PSX","brk_name":"Palestine","brk_group":"","abbrev":"Pal.","postal":"PAL","formal_en":"West Bank and Gaza","formal_fr":"","note_adm0":"Partial self-admin.","note_brk":"Partial self-admin.","name_sort":"Palestine (West Bank and Gaza)","name_alt":"","mapcolor7":3,"mapcolor8":2,"mapcolor9":5,"mapcolor13":8,"pop_est":4119083,"gdp_md_est":11950.77,"pop_year":-99,"lastcensus":2007,"gdp_year":-99,"economy":"6. Developing region","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"PS","iso_a3":"PSE","iso_n3":"275","un_a3":"275","wb_a2":"GZ","wb_a3":"WBG","woe_id":-99,"adm0_a3_is":"PSE","adm0_a3_us":"PSX","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Western Asia","region_wb":"Middle East & North Africa","name_len":9,"long_len":9,"abbrev_len":4,"tiny":-99,"homepart":-99}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[150.5899,59.0187],[150.5111,59.0074],[150.4718,59.0348],[150.4702,59.0541],[150.5925,59.0972],[150.6662,59.1602],[150.7127,59.1225],[150.7277,59.0952],[150.5899,59.0187]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Russia","sov_a3":"RUS","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Russia","adm0_a3":"RUS","geou_dif":0,"geounit":"Russia","gu_a3":"RUS","su_dif":0,"subunit":"Russia","su_a3":"RUS","brk_diff":0,"name":"Russia","name_long":"Russian Federation","brk_a3":"RUS","brk_name":"Russia","brk_group":"","abbrev":"Rus.","postal":"RUS","formal_en":"Russian Federation","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Russian Federation","name_alt":"","mapcolor7":2,"mapcolor8":5,"mapcolor9":7,"mapcolor13":7,"pop_est":140041247,"gdp_md_est":2266000,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"3. Emerging region: BRIC","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"RU","iso_a3":"RUS","iso_n3":"643","un_a3":"643","wb_a2":"RU","wb_a3":"RUS","woe_id":-99,"adm0_a3_is":"RUS","adm0_a3_us":"RUS","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Eastern Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":18,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[58.7221,20.2188],[58.6591,20.2036],[58.6409,20.2107],[58.6412,20.3374],[58.788,20.4966],[58.8844,20.6806],[58.9508,20.5162],[58.8352,20.4239],[58.7723,20.2668],[58.7221,20.2188]],[[56.388,24.9792],[56.4898,24.7164],[56.6406,24.4703],[56.7741,24.3346],[56.9125,24.1502],[57.123,23.9807],[57.2198,23.9228],[57.6113,23.8037],[57.8251,23.7591],[58.1204,23.7166],[58.3245,23.6238],[58.3932,23.6182],[58.5,23.6457],[58.578,23.6435],[58.773,23.5172],[58.8304,23.3975],[58.9115,23.3342],[58.9834,23.2347],[59.0299,23.1306],[59.1947,22.9719],[59.3109,22.7934],[59.4294,22.6608],[59.5352,22.5785],[59.6956,22.5461],[59.8232,22.509],[59.8375,22.4206],[59.8244,22.3052],[59.8,22.2199],[59.6809,22.0538],[59.6525,21.9514],[59.5176,21.7823],[59.3715,21.4988],[59.3045,21.4354],[59.0688,21.2891],[58.8957,21.1128],[58.6904,20.8071],[58.5342,20.5039],[58.4742,20.4069],[58.3487,20.3869],[58.266,20.3955],[58.209,20.424],[58.2316,20.5068],[58.245,20.5992],[58.1694,20.5895],[58.1029,20.5704],[57.9472,20.3436],[57.8618,20.2441],[57.8437,20.1177],[57.8021,19.9546],[57.7412,19.8045],[57.7142,19.6784],[57.7151,19.6069],[57.7608,19.4322],[57.764,19.2533],[57.7903,19.1459],[57.8116,19.0171],[57.7385,18.9773],[57.6758,18.9579],[57.4279,18.9438],[57.1766,18.9026],[56.9572,18.8278],[56.826,18.7535],[56.6551,18.5874],[56.5508,18.166],[56.3835,17.988],[56.2703,17.9508],[55.9977,17.9352],[55.6139,17.8861],[55.4791,17.8433],[55.2554,17.5856],[55.2382,17.5047],[55.2814,17.4462],[55.2956,17.3816],[55.2752,17.3209],[55.1737,17.1576],[55.0642,17.0389],[54.7719,16.9646],[54.6646,17.0089],[54.5665,17.0312],[54.377,17.0336],[54.0682,17.0055],[53.9544,16.9178],[53.7754,16.8557],[53.6099,16.76],[53.2978,16.7233],[53.0856,16.6484],[53.025,16.7802],[52.9644,16.9121],[52.9037,17.0438],[52.843,17.1757],[52.8006,17.2679],[52.7292,17.3004],[52.6859,17.3979],[52.6417,17.4979],[52.5974,17.5978],[52.5531,17.6976],[52.5089,17.7975],[52.4646,17.8974],[52.4203,17.9973],[52.3761,18.0972],[52.3317,18.1971],[52.2875,18.2969],[52.2433,18.3968],[52.199,18.4967],[52.1547,18.5966],[52.1104,18.6965],[52.0662,18.7964],[52.0219,18.8963],[51.9776,18.9961],[52.1186,19.0432],[52.2906,19.1005],[52.4627,19.1578],[52.6347,19.2151],[52.8067,19.2725],[52.9787,19.3298],[53.1508,19.3872],[53.3229,19.4445],[53.4948,19.5018],[53.6669,19.5591],[53.8389,19.6165],[54.0109,19.6738],[54.183,19.7312],[54.355,19.7885],[54.5271,19.8458],[54.699,19.9031],[54.8711,19.9605],[54.9773,19.9959],[55.0215,20.1292],[55.0582,20.2399],[55.0947,20.3506],[55.1314,20.4613],[55.1681,20.572],[55.2046,20.6827],[55.2412,20.7934],[55.2779,20.9041],[55.3145,21.0148],[55.3511,21.1255],[55.3877,21.2362],[55.4243,21.3469],[55.4609,21.4576],[55.4976,21.5683],[55.5342,21.679],[55.5708,21.7897],[55.6074,21.9004],[55.641,22.0019],[55.5777,22.0995],[55.4928,22.2307],[55.4038,22.3678],[55.3201,22.4969],[55.2593,22.5909],[55.1858,22.7041],[55.194,22.85],[55.1922,22.9229],[55.1999,23.0348],[55.2702,23.1899],[55.3532,23.3875],[55.4139,23.5187],[55.4663,23.6329],[55.5085,23.7246],[55.5316,23.819],[55.5193,23.8855],[55.4918,23.9097],[55.4685,23.9411],[55.5479,23.9914],[55.6966,24.0241],[55.7791,24.0171],[55.8941,24.0414],[55.9852,24.0634],[55.9922,24.093],[55.9663,24.1426],[55.9286,24.2151],[55.7997,24.2227],[55.7608,24.2427],[55.8057,24.3498],[55.804,24.3835],[55.7868,24.4235],[55.7682,24.4906],[55.7775,24.5773],[55.8039,24.6362],[55.8042,24.6836],[55.7916,24.7813],[55.7957,24.8681],[55.8229,24.9113],[55.8707,24.9514],[55.9158,24.9718],[55.9631,24.9703],[56.0006,24.9532],[56.0167,24.9077],[56.0063,24.8764],[55.9797,24.8721],[55.9703,24.8589],[56.0084,24.7982],[56.0639,24.7388],[56.1065,24.7487],[56.1545,24.7955],[56.2047,24.8333],[56.2679,24.8667],[56.3136,24.9313],[56.3529,24.9733],[56.388,24.9792]],[[56.2818,25.2355],[56.2402,25.2088],[56.2105,25.2133],[56.2165,25.2667],[56.2343,25.3038],[56.2773,25.3009],[56.2878,25.2786],[56.2818,25.2355]],[[56.4298,26.3272],[56.4178,26.2082],[56.4164,26.1087],[56.3736,25.8046],[56.3293,25.752],[56.3072,25.7093],[56.2979,25.6507],[56.2785,25.6277],[56.2495,25.6254],[56.1836,25.6449],[56.1446,25.6905],[56.152,25.7461],[56.1541,25.8485],[56.1726,25.9452],[56.1675,26.0475],[56.1165,26.0682],[56.0805,26.0626],[56.1645,26.207],[56.1973,26.2292],[56.2284,26.2198],[56.3056,26.2352],[56.3465,26.3136],[56.3787,26.3563],[56.4131,26.3512],[56.4298,26.3272]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":4,"sovereignt":"Oman","sov_a3":"OMN","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Oman","adm0_a3":"OMN","geou_dif":0,"geounit":"Oman","gu_a3":"OMN","su_dif":0,"subunit":"Oman","su_a3":"OMN","brk_diff":0,"name":"Oman","name_long":"Oman","brk_a3":"OMN","brk_name":"Oman","brk_group":"","abbrev":"Oman","postal":"OM","formal_en":"Sultanate of Oman","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Oman","name_alt":"","mapcolor7":1,"mapcolor8":4,"mapcolor9":1,"mapcolor13":6,"pop_est":3418085,"gdp_md_est":66980,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"6. Developing region","income_grp":"2. High income: nonOECD","wikipedia":-99,"fips_10":"","iso_a2":"OM","iso_a3":"OMN","iso_n3":"512","un_a3":"512","wb_a2":"OM","wb_a3":"OMN","woe_id":-99,"adm0_a3_is":"OMN","adm0_a3_us":"OMN","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Western Asia","region_wb":"Middle East & North Africa","name_len":4,"long_len":4,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[76.7669,35.6617],[76.8128,35.5718],[76.8822,35.4357],[76.9277,35.3466],[76.9789,35.2464],[77.0045,35.1963],[77.0486,35.1099],[77.0307,35.0624],[77.0009,34.992],[76.8917,34.9387],[76.7829,34.9002],[76.7575,34.8778],[76.749,34.8476],[76.6963,34.7869],[76.5944,34.7358],[76.51,34.7409],[76.4567,34.7561],[76.1725,34.6677],[76.041,34.6699],[75.9383,34.6125],[75.8621,34.5603],[75.7092,34.5031],[75.6056,34.5027],[75.4525,34.5367],[75.2641,34.6014],[75.1875,34.639],[75.1185,34.6368],[74.9519,34.6458],[74.7888,34.6777],[74.5941,34.7158],[74.4979,34.732],[74.3004,34.7654],[74.172,34.7209],[74.0559,34.6807],[73.9612,34.6535],[73.8831,34.5291],[73.8501,34.4853],[73.8121,34.4224],[73.7945,34.3782],[73.81,34.3253],[73.9246,34.2878],[73.9724,34.2366],[73.9795,34.1913],[73.9383,34.1448],[73.9039,34.108],[73.9041,34.0757],[73.9224,34.0431],[73.9499,34.0188],[74.1126,34.0037],[74.209,34.0034],[74.2465,33.9902],[74.2509,33.9461],[74.2156,33.8866],[74.0784,33.8387],[74.001,33.7882],[73.9765,33.7213],[73.9775,33.6678],[74.004,33.6324],[74.0697,33.5917],[74.1313,33.5451],[74.15,33.507],[74.1426,33.4554],[74.1178,33.3841],[74.0504,33.3013],[73.9942,33.2422],[73.9898,33.2212],[74.0038,33.1895],[74.0491,33.1434],[74.1263,33.0754],[74.2221,33.0203],[74.2836,33.0051],[74.3036,32.9918],[74.3228,32.928],[74.33,32.8608],[74.3055,32.8104],[74.3546,32.7687],[74.4834,32.771],[74.5883,32.7532],[74.6324,32.7709],[74.6633,32.7577],[74.6434,32.6077],[74.6578,32.5189],[74.6857,32.4938],[74.7889,32.4578],[74.9873,32.4622],[75.1041,32.4204],[75.2337,32.3721],[75.3026,32.3189],[75.3335,32.2792],[75.3247,32.2153],[75.2541,32.1403],[75.1388,32.1048],[75.0715,32.0894],[74.7395,31.9488],[74.6357,31.8897],[74.5556,31.8186],[74.526,31.7651],[74.51,31.7129],[74.5818,31.5239],[74.5939,31.4654],[74.535,31.2614],[74.5177,31.1856],[74.5397,31.1327],[74.6104,31.1128],[74.6258,31.0687],[74.6328,31.0347],[74.5098,30.9597],[74.3804,30.8934],[74.3394,30.8936],[74.2156,30.769],[74.009,30.5197],[73.8993,30.4354],[73.8916,30.394],[73.8827,30.3521],[73.9246,30.2816],[73.9334,30.2221],[73.8865,30.162],[73.8092,30.0934],[73.658,30.0332],[73.4675,29.9717],[73.3816,29.9344],[73.3173,29.773],[73.2578,29.6107],[73.2312,29.5506],[73.1283,29.3639],[72.9487,29.0888],[72.9033,29.0288],[72.6256,28.8961],[72.3419,28.7519],[72.292,28.6973],[72.2339,28.5658],[72.1792,28.4218],[72.1285,28.3463],[71.948,28.1773],[71.8889,28.0475],[71.8703,27.9625],[71.7167,27.9151],[71.543,27.8699],[71.2901,27.8553],[71.1848,27.8316],[70.8749,27.7145],[70.7979,27.7096],[70.7374,27.729],[70.6916,27.769],[70.6491,27.8354],[70.6291,27.9375],[70.5692,27.9838],[70.4886,28.0231],[70.4037,28.025],[70.3185,27.9816],[70.2443,27.9341],[70.1939,27.8949],[70.1445,27.849],[70.0498,27.6947],[69.8963,27.4736],[69.7248,27.3127],[69.6613,27.2645],[69.6216,27.2281],[69.568,27.1746],[69.537,27.1229],[69.4945,26.9542],[69.47,26.8044],[69.4813,26.771],[69.5069,26.7427],[69.6006,26.6991],[69.7359,26.6271],[69.9114,26.5861],[70.0594,26.5788],[70.1146,26.548],[70.1477,26.5064],[70.1568,26.4714],[70.1492,26.3476],[70.1326,26.2148],[70.0777,26.072],[70.0786,25.99],[70.1002,25.9101],[70.2646,25.7065],[70.3252,25.6857],[70.4485,25.6813],[70.5059,25.6853],[70.5695,25.706],[70.6148,25.6919],[70.6484,25.6669],[70.6572,25.6258],[70.6521,25.4229],[70.7025,25.3311],[70.8005,25.2059],[70.8777,25.063],[70.9509,24.8916],[71.0207,24.7577],[71.0479,24.6877],[71.0023,24.6539],[70.9764,24.6187],[70.9698,24.5719],[70.9793,24.5225],[70.9732,24.4874],[71.0063,24.4443],[71.0453,24.43],[71.044,24.4001],[70.9828,24.361],[70.9281,24.3624],[70.8862,24.3438],[70.8051,24.262],[70.7673,24.2454],[70.7163,24.238],[70.6595,24.2461],[70.5793,24.2791],[70.5559,24.3311],[70.565,24.3858],[70.5468,24.4183],[70.4893,24.4122],[70.2891,24.3563],[70.0982,24.2875],[70.0651,24.2406],[70.0211,24.1916],[69.9338,24.1714],[69.8052,24.1652],[69.7162,24.1726],[69.6342,24.2252],[69.5592,24.2731],[69.4435,24.2754],[69.2351,24.2683],[69.1195,24.2687],[69.0516,24.2863],[68.9846,24.2731],[68.9008,24.2924],[68.8635,24.2665],[68.8283,24.264],[68.8,24.3091],[68.7812,24.3137],[68.759,24.3072],[68.7396,24.292],[68.7281,24.2656],[68.7241,23.9647],[68.5866,23.9666],[68.4887,23.9672],[68.3813,23.9509],[68.2825,23.928],[68.2342,23.9005],[68.165,23.8573],[68.1488,23.7972],[68.1155,23.7534],[68.0678,23.8184],[68.037,23.8482],[68.0015,23.8261],[67.951,23.8286],[67.86,23.9027],[67.819,23.8281],[67.6685,23.811],[67.6495,23.8673],[67.6458,23.9199],[67.5631,23.8818],[67.5036,23.94],[67.4769,24.0183],[67.4539,24.0399],[67.4276,24.0648],[67.3652,24.0916],[67.3094,24.1748],[67.3043,24.2629],[67.2887,24.3678],[67.1715,24.7561],[67.1006,24.7919],[66.703,24.8609],[66.6822,24.9289],[66.7099,25.1113],[66.6986,25.2263],[66.5699,25.3785],[66.5339,25.4844],[66.4286,25.5753],[66.3242,25.6018],[66.219,25.5899],[66.1623,25.5539],[66.1312,25.4933],[66.3564,25.5074],[66.4071,25.4851],[66.4677,25.4453],[66.4029,25.4468],[66.3283,25.4658],[66.2347,25.4644],[65.8836,25.4196],[65.6797,25.3553],[65.4063,25.3743],[65.0613,25.3111],[64.7767,25.3073],[64.659,25.1841],[64.594,25.2063],[64.5438,25.2367],[64.1521,25.3334],[64.1249,25.3739],[64.0594,25.4029],[63.9873,25.3512],[63.9355,25.3425],[63.7209,25.3859],[63.5566,25.3532],[63.4957,25.2975],[63.4914,25.2108],[63.2857,25.2276],[63.17,25.2549],[63.015,25.2247],[62.6647,25.2648],[62.5725,25.2547],[62.4447,25.1973],[62.3912,25.1525],[62.3153,25.1349],[62.2487,25.1974],[62.1986,25.2249],[62.1521,25.2066],[62.0895,25.1553],[61.9079,25.1313],[61.7437,25.1382],[61.5669,25.1863],[61.5879,25.2023],[61.6154,25.2861],[61.6401,25.5846],[61.6714,25.6924],[61.6618,25.7513],[61.6687,25.769],[61.7377,25.8211],[61.7544,25.8434],[61.7808,25.9958],[61.81,26.1653],[61.8424,26.2259],[61.8698,26.2424],[62.0891,26.3183],[62.126,26.369],[62.2394,26.357],[62.2496,26.3692],[62.2597,26.4275],[62.3123,26.4909],[62.3851,26.5426],[62.4393,26.561],[62.6364,26.5937],[62.7516,26.6392],[62.7866,26.6439],[63.093,26.6323],[63.1578,26.6498],[63.1681,26.6656],[63.1861,26.8376],[63.2416,26.8647],[63.2504,26.8792],[63.2314,26.9981],[63.2421,27.0777],[63.3052,27.1246],[63.3016,27.1515],[63.2563,27.2079],[63.1961,27.2439],[63.1668,27.2525],[62.9154,27.2184],[62.8116,27.2294],[62.763,27.2502],[62.7527,27.2656],[62.7625,27.3002],[62.7643,27.3567],[62.8009,27.4445],[62.812,27.497],[62.7823,27.8005],[62.7397,28.0021],[62.7625,28.2021],[62.758,28.2436],[62.7494,28.2529],[62.7176,28.2528],[62.5646,28.2352],[62.4339,28.3639],[62.353,28.4147],[62.1306,28.4788],[62.033,28.491],[61.8898,28.5465],[61.758,28.6677],[61.623,28.7916],[61.5688,28.8709],[61.5086,29.0061],[61.3379,29.265],[61.3395,29.3318],[61.3184,29.3726],[61.1521,29.5427],[61.0342,29.6634],[60.8434,29.8587],[61.2244,29.7494],[61.5215,29.6657],[62.001,29.5304],[62.3734,29.4254],[62.4766,29.4083],[63.5676,29.498],[63.971,29.4301],[64.0987,29.3919],[64.118,29.4143],[64.1722,29.4604],[64.2661,29.5069],[64.3938,29.5443],[64.5211,29.5645],[64.7035,29.5671],[64.8273,29.5642],[64.9189,29.5528],[65.0955,29.5595],[65.1805,29.5776],[65.471,29.6516],[65.6662,29.7013],[65.9616,29.7789],[66.1771,29.8356],[66.2313,29.8657],[66.2869,29.92],[66.3134,29.9686],[66.2472,30.0435],[66.2385,30.1096],[66.2818,30.1935],[66.3055,30.3211],[66.301,30.503],[66.2869,30.6079],[66.3469,30.8028],[66.3972,30.9122],[66.4974,30.9646],[66.5668,30.9966],[66.5958,31.02],[66.6242,31.046],[66.7313,31.1945],[66.8293,31.2637],[66.9243,31.3056],[67.0277,31.3002],[67.1159,31.2429],[67.2873,31.2178],[67.4528,31.2346],[67.5964,31.2777],[67.6615,31.313],[67.7379,31.3439],[67.7335,31.3792],[67.6471,31.41],[67.5976,31.4533],[67.5782,31.5065],[67.6268,31.5388],[67.7398,31.5482],[68.0172,31.678],[68.1302,31.7633],[68.161,31.803],[68.214,31.8074],[68.3198,31.7677],[68.4433,31.7545],[68.5207,31.7941],[68.5977,31.803],[68.6732,31.7597],[68.7137,31.7081],[68.7823,31.6464],[68.8689,31.6342],[68.9734,31.6674],[69.0831,31.7385],[69.1869,31.8381],[69.2793,31.9368],[69.2565,32.2495],[69.2414,32.4335],[69.2899,32.5306],[69.3595,32.5903],[69.4054,32.6827],[69.4046,32.7643],[69.4531,32.8328],[69.5016,33.0201],[69.5678,33.0642],[69.7037,33.0947],[69.9201,33.1125],[70.0902,33.1981],[70.2611,33.289],[70.2842,33.369],[70.2197,33.4547],[70.1342,33.6208],[70.0566,33.7199],[69.8681,33.8977],[69.8896,34.0073],[69.9947,34.0518],[70.2536,33.976],[70.3257,33.9611],[70.4157,33.9504],[70.654,33.9523],[70.8484,33.9819],[71.0516,34.0497],[71.0913,34.1203],[71.0891,34.2041],[71.0924,34.2732],[71.0957,34.3694],[71.0229,34.4312],[70.9789,34.4863],[70.9656,34.5304],[71.0163,34.5546],[71.0656,34.5996],[71.1133,34.6816],[71.2258,34.7795],[71.2941,34.8677],[71.3581,34.9096],[71.4551,34.9669],[71.5171,35.0511],[71.5455,35.1014],[71.6017,35.1507],[71.6205,35.183],[71.6053,35.2118],[71.5772,35.248],[71.5455,35.2889],[71.5455,35.3285],[71.572,35.3704],[71.6006,35.4079],[71.5874,35.4608],[71.572,35.5468],[71.519,35.5975],[71.4836,35.7146],[71.4275,35.8337],[71.3976,35.8802],[71.3429,35.9385],[71.2202,36.0007],[71.1851,36.0421],[71.2329,36.1218],[71.3126,36.1712],[71.4633,36.2933],[71.5459,36.3777],[71.6205,36.4365],[71.7164,36.4266],[71.7727,36.4318],[71.8223,36.4861],[71.9207,36.5342],[72.0956,36.6337],[72.1567,36.7009],[72.2498,36.7347],[72.327,36.7424],[72.4312,36.7658],[72.5313,36.802],[72.6229,36.8296],[72.7662,36.835],[72.9938,36.8516],[73.1168,36.8686],[73.4111,36.8817],[73.7318,36.8878],[73.7691,36.8885],[73.9078,36.8529],[74.0019,36.8231],[74.0389,36.8257],[74.1947,36.8969],[74.4311,36.9837],[74.5414,37.0222],[74.6006,37.0367],[74.6922,37.0357],[74.766,37.0127],[74.8412,36.9791],[74.8893,36.9524],[74.9491,36.9684],[75.0539,36.9872],[75.1452,36.9732],[75.3467,36.9135],[75.3769,36.8837],[75.4242,36.7382],[75.4603,36.725],[75.5737,36.7593],[75.6672,36.742],[75.7722,36.6949],[75.8402,36.6497],[75.885,36.6007],[75.933,36.5216],[75.9519,36.4581],[75.9744,36.3824],[75.9687,36.1688],[75.9341,36.1339],[75.9049,36.0885],[75.9123,36.049],[75.9451,36.0176],[76.0104,35.9963],[76.0709,35.983],[76.1033,35.9492],[76.1479,35.829],[76.1778,35.8105],[76.2517,35.8109],[76.3857,35.8372],[76.5021,35.8782],[76.5513,35.8871],[76.5635,35.773],[76.6318,35.7294],[76.7275,35.6787],[76.7669,35.6617]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Pakistan","sov_a3":"PAK","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Pakistan","adm0_a3":"PAK","geou_dif":0,"geounit":"Pakistan","gu_a3":"PAK","su_dif":0,"subunit":"Pakistan","su_a3":"PAK","brk_diff":0,"name":"Pakistan","name_long":"Pakistan","brk_a3":"PAK","brk_name":"Pakistan","brk_group":"","abbrev":"Pak.","postal":"PK","formal_en":"Islamic Republic of Pakistan","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Pakistan","name_alt":"","mapcolor7":2,"mapcolor8":2,"mapcolor9":3,"mapcolor13":11,"pop_est":176242949,"gdp_md_est":427300,"pop_year":-99,"lastcensus":1998,"gdp_year":-99,"economy":"5. Emerging region: G20","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"PK","iso_a3":"PAK","iso_n3":"586","un_a3":"586","wb_a2":"PK","wb_a3":"PAK","woe_id":-99,"adm0_a3_is":"PAK","adm0_a3_us":"PAK","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Southern Asia","region_wb":"South Asia","name_len":8,"long_len":8,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[-8.1735,41.82],[-8.1525,41.812],[-8.0944,41.8142],[-7.991,41.8519],[-7.9208,41.8836],[-7.8964,41.8706],[-7.6931,41.8885],[-7.6447,41.874],[-7.6126,41.858],[-7.5126,41.836],[-7.4036,41.8337],[-7.2686,41.8644],[-7.2096,41.8953],[-7.1983,41.9294],[-7.1954,41.9552],[-7.1779,41.9717],[-7.1471,41.9812],[-7.0991,41.9642],[-7.0305,41.9506],[-6.8655,41.9453],[-6.8332,41.9642],[-6.7773,41.9585],[-6.7036,41.9346],[-6.6183,41.9424],[-6.5753,41.9131],[-6.5575,41.8741],[-6.5526,41.7896],[-6.559,41.7041],[-6.5422,41.6725],[-6.4847,41.6644],[-6.3917,41.6654],[-6.3081,41.6422],[-6.2431,41.6018],[-6.2217,41.5604],[-6.2125,41.532],[-6.2443,41.5159],[-6.2894,41.455],[-6.4031,41.3754],[-6.5659,41.3037],[-6.6901,41.2145],[-6.7758,41.1077],[-6.8828,41.0624],[-6.9155,41.038],[-6.9285,41.0091],[-6.8577,40.8783],[-6.8359,40.7775],[-6.8184,40.6541],[-6.8298,40.6191],[-6.8357,40.4832],[-6.8521,40.4433],[-6.8479,40.411],[-6.8218,40.3763],[-6.8102,40.3431],[-6.8589,40.3007],[-6.9484,40.2516],[-7.0147,40.2083],[-7.0326,40.1679],[-7.0278,40.1426],[-6.9164,40.0568],[-6.8961,40.0218],[-6.9112,39.9371],[-6.9754,39.7984],[-7.0367,39.714],[-7.0474,39.7056],[-7.1177,39.6817],[-7.4541,39.6807],[-7.5357,39.6616],[-7.5242,39.6447],[-7.4451,39.5362],[-7.3627,39.4783],[-7.3354,39.4651],[-7.3058,39.3381],[-7.1724,39.1352],[-7.043,39.1071],[-6.9979,39.0564],[-7.0062,38.9853],[-7.046,38.907],[-7.1255,38.827],[-7.2199,38.7705],[-7.2815,38.7146],[-7.2864,38.6494],[-7.306,38.5668],[-7.3358,38.5015],[-7.343,38.4574],[-7.1064,38.181],[-6.9748,38.1944],[-6.9576,38.1879],[-6.9811,38.122],[-7.0229,38.0447],[-7.0725,38.03],[-7.1854,38.0063],[-7.2922,37.9064],[-7.3789,37.7864],[-7.4439,37.7283],[-7.5035,37.5855],[-7.496,37.5236],[-7.4672,37.428],[-7.4062,37.1794],[-7.4936,37.1683],[-7.8341,37.0057],[-7.9397,37.0054],[-8.1368,37.0771],[-8.4843,37.1],[-8.5977,37.1213],[-8.7391,37.0746],[-8.8484,37.0757],[-8.9354,37.016],[-8.9978,37.0323],[-8.9263,37.1661],[-8.8142,37.4308],[-8.8186,37.5924],[-8.7918,37.7328],[-8.8227,37.8719],[-8.879,37.9587],[-8.8022,38.1838],[-8.8109,38.2998],[-8.8811,38.4467],[-8.6683,38.4243],[-8.734,38.4824],[-8.7989,38.5182],[-8.8616,38.51],[-8.9148,38.5121],[-9.096,38.4552],[-9.1867,38.4382],[-9.2133,38.4481],[-9.2034,38.539],[-9.2504,38.6567],[-9.1778,38.6878],[-9.0933,38.6967],[-9.0215,38.7469],[-8.9771,38.8029],[-9.0005,38.903],[-8.9381,38.9981],[-8.7916,39.0782],[-8.8675,39.066],[-8.9543,39.0161],[-9.091,38.8347],[-9.1358,38.7428],[-9.2523,38.7128],[-9.3567,38.6979],[-9.4102,38.7075],[-9.4741,38.7309],[-9.4797,38.7988],[-9.4748,38.8529],[-9.4314,38.9604],[-9.4144,39.1121],[-9.3528,39.2481],[-9.3572,39.2843],[-9.3748,39.3383],[-9.3196,39.3911],[-9.2514,39.426],[-9.1483,39.5426],[-9.0041,39.8206],[-8.8378,40.1157],[-8.8513,40.1518],[-8.8866,40.1794],[-8.8727,40.2591],[-8.7724,40.6057],[-8.7316,40.6509],[-8.6846,40.7525],[-8.674,40.9165],[-8.6556,41.0295],[-8.6598,41.0863],[-8.6746,41.1545],[-8.7384,41.2847],[-8.8057,41.56],[-8.8108,41.652],[-8.7554,41.6984],[-8.8464,41.7052],[-8.8876,41.7646],[-8.8782,41.8321],[-8.7771,41.9411],[-8.683,42.0085],[-8.5896,42.0527],[-8.5381,42.0693],[-8.3226,42.1151],[-8.2661,42.1374],[-8.2131,42.1337],[-8.2042,42.1119],[-8.1736,42.0694],[-8.1393,42.0399],[-8.13,42.0182],[-8.2133,41.9271],[-8.2248,41.8958],[-8.1812,41.837],[-8.1735,41.82]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Portugal","sov_a3":"PRT","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Portugal","adm0_a3":"PRT","geou_dif":0,"geounit":"Portugal","gu_a3":"PRT","su_dif":1,"subunit":"Portugal","su_a3":"PR1","brk_diff":0,"name":"Portugal","name_long":"Portugal","brk_a3":"PR1","brk_name":"Portugal","brk_group":"","abbrev":"Port.","postal":"P","formal_en":"Portuguese Republic","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Portugal","name_alt":"","mapcolor7":1,"mapcolor8":7,"mapcolor9":1,"mapcolor13":4,"pop_est":10707924,"gdp_md_est":208627,"pop_year":-99,"lastcensus":2011,"gdp_year":0,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"PT","iso_a3":"PRT","iso_n3":"620","un_a3":"620","wb_a2":"PT","wb_a3":"PRT","woe_id":-99,"adm0_a3_is":"PRT","adm0_a3_us":"PRT","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Southern Europe","region_wb":"Europe & Central Asia","name_len":8,"long_len":8,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[120.2504,5.2566],[120.2232,5.1962],[120.1916,5.1683],[120.15,5.1841],[120.1184,5.2154],[120.1006,5.169],[120.0133,5.1511],[119.9581,5.0795],[119.8775,5.0602],[119.8215,5.0695],[119.8273,5.1332],[119.9827,5.2284],[120.0797,5.2636],[120.1652,5.3324],[120.208,5.3401],[120.2294,5.2841],[120.2504,5.2566]],[[121.1594,6.0756],[121.2139,6.0035],[121.2825,6.0223],[121.3915,6.0021],[121.4146,5.9645],[121.411,5.9398],[121.2944,5.87],[121.2182,5.9427],[121.083,5.893],[121.0186,5.9229],[120.9307,5.8962],[120.8764,5.9526],[120.8982,6.0069],[121.0377,6.096],[121.1594,6.0756]],[[122.0929,6.4283],[121.9914,6.4146],[121.9592,6.4158],[121.8799,6.5176],[121.8725,6.5627],[121.8087,6.6137],[121.832,6.6641],[121.9149,6.6762],[122.0583,6.7407],[122.2881,6.6389],[122.3235,6.6022],[122.2518,6.5798],[122.201,6.4829],[122.0929,6.4283]],[[125.7846,6.9627],[125.7689,6.9058],[125.7075,7.04],[125.683,7.0732],[125.7145,7.1855],[125.7834,7.1307],[125.7846,6.9627]],[[122.9371,7.4091],[122.948,7.3857],[122.9437,7.361],[122.8396,7.3146],[122.8047,7.316],[122.7966,7.3934],[122.8222,7.4285],[122.8712,7.3973],[122.9148,7.4334],[122.9371,7.4091]],[[117.0799,7.8834],[117.0283,7.8075],[116.9695,7.8949],[116.9758,8.0167],[116.9936,8.0505],[117.0771,8.0691],[117.0799,7.8834]],[[117.3553,8.2146],[117.287,8.191],[117.2723,8.2535],[117.2809,8.315],[117.3296,8.3085],[117.3537,8.2893],[117.3553,8.2146]],[[124.8066,9.1426],[124.7779,9.0831],[124.6658,9.1323],[124.6391,9.1751],[124.6533,9.2258],[124.7081,9.243],[124.7368,9.2432],[124.7902,9.1901],[124.8066,9.1426]],[[123.6977,9.2373],[123.7063,9.1335],[123.6145,9.1033],[123.5407,9.1297],[123.4935,9.1921],[123.4936,9.2155],[123.5352,9.2136],[123.6261,9.2683],[123.6549,9.2788],[123.6977,9.2373]],[[125.9705,9.5936],[125.9524,9.568],[125.9221,9.6215],[125.9485,9.7392],[125.9678,9.7591],[125.993,9.6846],[125.9705,9.5936]],[[126.006,9.3209],[126.0876,9.2607],[126.1934,9.2767],[126.192,9.1249],[126.2091,9.0806],[126.3046,8.9521],[126.3195,8.8447],[126.263,8.7439],[126.2202,8.6963],[126.1416,8.6273],[126.1396,8.5957],[126.173,8.5601],[126.2823,8.5393],[126.3653,8.4839],[126.3798,8.3268],[126.4587,8.2028],[126.4566,8.1488],[126.4253,7.9274],[126.4354,7.8328],[126.4944,7.757],[126.5444,7.7248],[126.5701,7.6772],[126.5934,7.5468],[126.5893,7.3251],[126.5815,7.2478],[126.5467,7.1758],[126.4391,7.0124],[126.294,6.8823],[126.2169,6.891],[126.1921,6.8525],[126.2402,6.7339],[126.2212,6.4834],[126.1894,6.3097],[126.1425,6.3976],[126.1098,6.4896],[126.0801,6.7333],[126.0431,6.8432],[125.985,6.9436],[125.9616,7.0332],[125.9012,7.117],[125.8244,7.3333],[125.7736,7.3222],[125.6893,7.263],[125.6702,7.2223],[125.6603,7.1606],[125.6407,7.1051],[125.5422,7.0166],[125.4647,6.9111],[125.401,6.7958],[125.3807,6.6899],[125.4329,6.6071],[125.4866,6.5737],[125.5646,6.4996],[125.5885,6.4658],[125.6707,6.225],[125.668,5.9787],[125.6078,5.8702],[125.4559,5.6643],[125.3465,5.599],[125.2879,5.6323],[125.241,5.7569],[125.2332,5.8083],[125.2649,5.9256],[125.2685,6.0332],[125.2315,6.0695],[125.191,6.0625],[125.174,6.047],[125.0762,5.9063],[125.0354,5.8707],[124.9752,5.8657],[124.9273,5.8753],[124.6363,5.9982],[124.3988,6.1197],[124.2128,6.2333],[124.0781,6.4044],[124.0497,6.5326],[124.0481,6.6666],[123.9879,6.863],[123.9809,6.9297],[123.9853,6.9937],[124.0451,7.1141],[124.1176,7.1751],[124.1582,7.2188],[124.1907,7.2673],[124.2129,7.3321],[124.2066,7.3964],[124.1824,7.4367],[124.068,7.5779],[123.9685,7.6646],[123.7647,7.7426],[123.7174,7.7854],[123.6658,7.8178],[123.6089,7.8316],[123.5532,7.8321],[123.4931,7.8079],[123.4774,7.7563],[123.4816,7.7103],[123.4764,7.6654],[123.3909,7.4075],[123.282,7.4641],[123.1782,7.5294],[123.1507,7.5752],[123.1388,7.6299],[123.1212,7.6669],[123.0967,7.7004],[123.0489,7.6144],[122.9896,7.5463],[122.9169,7.5305],[122.843,7.5293],[122.8188,7.5585],[122.7918,7.7225],[122.714,7.7741],[122.6162,7.7631],[122.4979,7.6728],[122.4744,7.639],[122.4486,7.5611],[122.3197,7.3402],[122.2515,7.17],[122.1762,7.0042],[122.1425,6.9497],[122.0981,6.9137],[122.0276,6.9286],[121.9643,6.9682],[121.9042,7.0752],[121.9246,7.1995],[121.9911,7.2788],[122.0472,7.3636],[122.1148,7.6599],[122.1199,7.7654],[122.1318,7.8105],[122.2434,7.9451],[122.3371,8.0284],[122.3867,8.0459],[122.5895,8.0933],[122.6729,8.1331],[122.8044,8.1337],[122.9111,8.1564],[122.9963,8.2205],[123.0027,8.2869],[122.9988,8.3561],[123.0176,8.3983],[123.0506,8.4339],[123.0959,8.4808],[123.1472,8.516],[123.2929,8.5415],[123.3412,8.5704],[123.3802,8.6156],[123.4346,8.7033],[123.4989,8.6815],[123.5637,8.6475],[123.6801,8.6206],[123.7834,8.5477],[123.8492,8.4327],[123.8605,8.3761],[123.8774,8.1888],[123.8534,8.1451],[123.7531,8.0583],[123.7994,8.0491],[123.9312,8.1284],[123.9969,8.159],[124.1594,8.2015],[124.1977,8.2295],[124.2258,8.2714],[124.2832,8.386],[124.3252,8.5084],[124.3579,8.5594],[124.4049,8.5999],[124.4513,8.6063],[124.6218,8.5227],[124.7312,8.563],[124.7617,8.6898],[124.7868,8.8741],[124.8062,8.924],[124.8689,8.9723],[124.9438,8.9567],[125.0464,8.8905],[125.141,8.8687],[125.1762,8.9221],[125.2097,9.0271],[125.2479,9.0266],[125.3756,8.9918],[125.4987,9.0147],[125.5334,9.1409],[125.5102,9.2759],[125.414,9.6692],[125.4713,9.7568],[125.5209,9.7591],[125.6425,9.6545],[125.8767,9.5131],[125.9547,9.4267],[126.006,9.3209]],[[126.0594,9.7662],[126.0468,9.7608],[125.9912,9.8385],[125.9986,9.9271],[126.0738,10.0592],[126.1295,9.9436],[126.1289,9.8911],[126.1208,9.8652],[126.1726,9.8],[126.1369,9.7678],[126.0594,9.7662]],[[125.2808,9.9822],[125.2877,9.9327],[125.159,10.0629],[125.133,10.155],[125.1759,10.1511],[125.231,10.1157],[125.2808,9.9822]],[[124.5938,9.7872],[124.5843,9.7505],[124.5057,9.7535],[124.4775,9.7479],[124.4034,9.6541],[124.3599,9.6302],[124.1225,9.5993],[123.9356,9.624],[123.8717,9.6757],[123.83,9.7611],[123.8172,9.8174],[123.8639,9.8788],[123.9089,9.9196],[124.0598,10.0002],[124.0938,10.0613],[124.1729,10.1352],[124.3357,10.1599],[124.3516,10.1414],[124.3732,10.1296],[124.4059,10.1264],[124.4863,10.0655],[124.5771,10.0267],[124.5551,9.8792],[124.5822,9.8296],[124.5938,9.7872]],[[125.6902,9.9145],[125.6726,9.8865],[125.6486,9.9441],[125.5905,9.9982],[125.5345,10.0901],[125.4948,10.1187],[125.522,10.1915],[125.5246,10.3097],[125.5802,10.3637],[125.6059,10.3796],[125.6479,10.4368],[125.6668,10.4401],[125.6846,10.392],[125.6467,10.2454],[125.7033,10.0718],[125.6844,9.9632],[125.6925,9.939],[125.6902,9.9145]],[[119.9162,10.486],[119.7932,10.4553],[119.7645,10.5516],[119.8521,10.6401],[119.9502,10.6048],[120.0084,10.5701],[119.9812,10.5387],[119.9162,10.486]],[[124.3162,10.606],[124.2885,10.6015],[124.3347,10.7067],[124.3711,10.6914],[124.3823,10.6798],[124.3813,10.6326],[124.3162,10.606]],[[122.6495,10.4727],[122.6219,10.459],[122.5972,10.461],[122.5384,10.425],[122.5167,10.4925],[122.5375,10.6076],[122.6258,10.695],[122.6484,10.7225],[122.6726,10.7388],[122.7013,10.7406],[122.7292,10.7064],[122.7372,10.6546],[122.6813,10.4982],[122.6495,10.4727]],[[123.1309,9.0641],[123.0646,9.0534],[122.9947,9.0588],[122.9479,9.108],[122.8666,9.3198],[122.7725,9.3713],[122.6646,9.4104],[122.6104,9.4432],[122.5625,9.4828],[122.4109,9.6939],[122.3995,9.823],[122.4256,9.8961],[122.4715,9.9615],[122.5232,9.9792],[122.6482,9.9815],[122.713,9.9901],[122.8556,10.0869],[122.8658,10.125],[122.8665,10.284],[122.8523,10.3953],[122.817,10.5038],[122.8556,10.5534],[122.9059,10.6025],[122.9584,10.6983],[122.9688,10.7657],[122.9697,10.8362],[122.9833,10.8866],[123.0244,10.9118],[123.2218,10.9887],[123.2566,10.9939],[123.5106,10.923],[123.5625,10.8161],[123.5676,10.7808],[123.5277,10.662],[123.4929,10.5823],[123.4069,10.459],[123.3436,10.3254],[123.2961,10.1245],[123.2662,10.059],[123.1866,9.9333],[123.162,9.8643],[123.1627,9.7146],[123.1494,9.6593],[123.1498,9.6062],[123.3084,9.357],[123.3219,9.3175],[123.3205,9.2729],[123.2934,9.2173],[123.2287,9.1214],[123.1925,9.0879],[123.1309,9.0641]],[[123.3703,9.4496],[123.3317,9.4229],[123.316,9.489],[123.3271,9.5781],[123.4037,9.8893],[123.3862,9.9671],[123.5144,10.1403],[123.5929,10.3029],[123.7114,10.4737],[123.7265,10.5622],[123.8315,10.731],[123.9299,10.9638],[123.9246,11.0409],[123.9501,11.0792],[123.9641,11.1375],[123.9672,11.1869],[124.0389,11.2735],[124.0579,11.2172],[124.0365,11.1067],[124.0398,11.0536],[124.0525,11.0288],[124.0533,10.9258],[124.0275,10.7679],[124.0513,10.5856],[124.005,10.4001],[123.9521,10.3166],[123.8739,10.2577],[123.7887,10.2208],[123.7005,10.1283],[123.6434,10.0202],[123.634,9.9217],[123.4936,9.5893],[123.3703,9.4496]],[[123.757,11.2833],[123.8156,11.1507],[123.7367,11.1515],[123.7076,11.248],[123.7414,11.2792],[123.757,11.2833]],[[117.3111,8.4396],[117.2186,8.3673],[117.2285,8.4567],[117.2559,8.541],[117.3499,8.7136],[117.4178,8.7667],[117.53,8.9026],[117.5933,8.9683],[117.7449,9.0982],[117.8848,9.2407],[117.9315,9.2513],[117.983,9.2534],[118.0238,9.2698],[118.1148,9.3467],[118.3439,9.6028],[118.5334,9.7937],[118.7275,10.035],[118.8201,10.1053],[118.8451,10.1313],[119.0238,10.3536],[119.0799,10.3858],[119.1431,10.4093],[119.186,10.4395],[119.2238,10.4773],[119.287,10.574],[119.3127,10.6871],[119.2967,10.751],[119.2611,10.8452],[119.3057,10.9736],[119.3407,11.0329],[119.4653,11.2938],[119.5013,11.3464],[119.5533,11.3135],[119.5603,11.2668],[119.5346,11.1568],[119.5326,11.1016],[119.5619,11.0455],[119.5267,10.9532],[119.6161,10.7074],[119.6844,10.5517],[119.6869,10.5003],[119.5952,10.4074],[119.5405,10.3793],[119.4225,10.3544],[119.3693,10.3273],[119.2848,10.2517],[119.2319,10.1521],[119.2186,10.1007],[119.1915,10.0611],[118.9486,9.9935],[118.8347,9.9493],[118.7821,9.9161],[118.755,9.8621],[118.7738,9.7668],[118.5696,9.4228],[118.5045,9.3327],[118.435,9.256],[118.3496,9.2015],[118.2293,9.168],[118.1341,9.1014],[118.0694,8.9835],[117.9896,8.8771],[117.8886,8.7982],[117.7798,8.7286],[117.6799,8.6778],[117.5722,8.642],[117.5396,8.5956],[117.5166,8.5383],[117.4691,8.5114],[117.4125,8.4958],[117.3111,8.4396]],[[119.8614,11.5253],[119.8829,11.4724],[119.8549,11.3931],[119.8307,11.3757],[119.7986,11.4087],[119.73,11.4319],[119.7256,11.4747],[119.7614,11.4736],[119.8268,11.5154],[119.8614,11.5253]],[[124.5746,11.3431],[124.6443,11.3081],[124.7243,11.3221],[124.8211,11.4014],[124.93,11.3729],[124.9939,11.2559],[125.0266,11.2117],[125.0443,11.1353],[125.0397,10.9519],[125.0132,10.7857],[125.0338,10.7515],[125.0839,10.7216],[125.1275,10.6847],[125.1642,10.6375],[125.1877,10.5849],[125.1972,10.4572],[125.2601,10.3496],[125.2685,10.3077],[125.2533,10.2638],[125.1484,10.2724],[125.14,10.2354],[125.1426,10.1895],[125.1054,10.2183],[125.0439,10.3234],[124.9875,10.3676],[125.0049,10.1971],[125.0235,10.1153],[125.0266,10.0331],[124.9291,10.0959],[124.8128,10.1346],[124.7808,10.1681],[124.7917,10.2746],[124.7896,10.3275],[124.7377,10.4397],[124.7986,10.6822],[124.7972,10.7318],[124.7867,10.7814],[124.7387,10.8797],[124.6627,10.962],[124.6161,10.9622],[124.5028,10.9044],[124.4455,10.9236],[124.4117,11.1503],[124.366,11.3707],[124.331,11.4271],[124.3082,11.4862],[124.3307,11.5352],[124.3741,11.515],[124.4359,11.4572],[124.5109,11.4239],[124.5482,11.395],[124.5746,11.3431]],[[124.6084,11.4922],[124.4835,11.4858],[124.4288,11.5317],[124.3604,11.6659],[124.4374,11.695],[124.5109,11.6871],[124.5649,11.6397],[124.6223,11.5496],[124.6084,11.4922]],[[124.8544,11.5948],[124.8359,11.5433],[124.8066,11.5576],[124.7811,11.5808],[124.7437,11.6585],[124.7309,11.7153],[124.7884,11.6831],[124.8215,11.6266],[124.8544,11.5948]],[[122.4962,11.6151],[122.6127,11.5642],[122.7263,11.6079],[122.8381,11.5957],[122.9313,11.5293],[122.9008,11.4874],[122.8945,11.4413],[123.1027,11.5415],[123.1583,11.5355],[123.1564,11.4425],[123.1441,11.3636],[123.1195,11.2868],[123.0755,11.1969],[123.0165,11.1165],[122.9388,11.0582],[122.8467,11.0225],[122.8029,10.99],[122.7895,10.9412],[122.7911,10.8797],[122.7699,10.8238],[122.6731,10.8009],[122.5221,10.6919],[122.1977,10.6229],[122.1086,10.5755],[122.0518,10.5141],[121.9884,10.4583],[121.954,10.4444],[121.9383,10.4709],[121.9338,10.4937],[121.9801,10.6386],[121.9724,10.6989],[121.9503,10.7574],[121.9644,10.8717],[122.0207,10.9791],[122.0509,11.0974],[122.0597,11.3257],[122.1035,11.6429],[122.1014,11.6809],[122.067,11.7237],[121.9408,11.7583],[121.8912,11.7909],[121.916,11.8543],[121.9637,11.8974],[122.0292,11.8954],[122.0868,11.8551],[122.2907,11.772],[122.3992,11.7022],[122.4962,11.6151]],[[120.0388,11.7033],[119.9639,11.6694],[119.9449,11.6907],[119.9317,11.7403],[119.9328,11.7745],[119.8609,11.954],[119.916,11.9813],[119.9565,11.9603],[119.9979,11.9321],[120.0359,11.9172],[120.0707,11.8605],[120.0624,11.8213],[120.0731,11.7835],[120.0388,11.7033]],[[120.1,12.1677],[120.1547,12.1524],[120.1938,12.167],[120.2282,12.2198],[120.2605,12.1417],[120.3414,12.0774],[120.3146,12.0124],[120.2435,12.0048],[120.1736,12.0196],[120.1001,11.9937],[120.0105,12.0083],[119.957,12.0692],[119.8961,12.1788],[119.8659,12.199],[119.8696,12.244],[119.8918,12.2725],[119.8801,12.2799],[119.8857,12.2999],[119.8967,12.3134],[119.9164,12.3191],[119.9639,12.2704],[120.0775,12.1978],[120.1,12.1677]],[[122.6545,12.309],[122.6033,12.2856],[122.4993,12.3837],[122.4389,12.4295],[122.4229,12.4551],[122.4719,12.4919],[122.6036,12.4916],[122.6736,12.4243],[122.6833,12.3823],[122.6545,12.309]],[[125.2396,12.5279],[125.3104,12.4463],[125.3275,12.3872],[125.3202,12.3218],[125.3522,12.2928],[125.4088,12.2849],[125.4813,12.252],[125.5356,12.1914],[125.5033,12.1358],[125.5134,12.0546],[125.4565,11.9525],[125.4643,11.7716],[125.4969,11.7138],[125.5,11.6554],[125.4918,11.5943],[125.5058,11.5442],[125.593,11.3782],[125.609,11.323],[125.5823,11.2795],[125.5735,11.2382],[125.6273,11.2339],[125.704,11.1648],[125.7491,11.0736],[125.7356,11.0496],[125.6744,11.1208],[125.6281,11.132],[125.4318,11.1126],[125.3115,11.1423],[125.2334,11.1451],[125.1559,11.267],[125.0879,11.2874],[125.0343,11.3413],[124.9453,11.4792],[124.917,11.5584],[124.9789,11.6385],[124.9982,11.7023],[124.995,11.7649],[124.9356,11.7546],[124.8843,11.7755],[124.8211,11.8521],[124.7958,11.8963],[124.7498,11.9333],[124.6768,12.0209],[124.5719,12.0551],[124.5291,12.0792],[124.4457,12.1528],[124.3849,12.244],[124.3258,12.4038],[124.2947,12.5693],[124.5658,12.5262],[124.8401,12.5346],[125.1502,12.5726],[125.2396,12.5279]],[[123.7166,12.2874],[123.9083,12.1691],[124.0403,11.9668],[124.0557,11.8116],[124.0455,11.7524],[123.9827,11.8189],[123.8478,11.9136],[123.754,11.9345],[123.7252,11.9516],[123.736,12.0026],[123.6748,12.05],[123.6676,12.0693],[123.612,12.0902],[123.5311,12.1966],[123.4737,12.2167],[123.4188,12.1942],[123.2927,12.0364],[123.1578,11.9256],[123.1559,11.968],[123.2105,12.1066],[123.2453,12.328],[123.2672,12.3955],[123.2398,12.4947],[123.2364,12.5835],[123.337,12.5424],[123.463,12.5012],[123.559,12.4448],[123.5748,12.4069],[123.7166,12.2874]],[[122.3108,12.5288],[122.2798,12.4983],[122.2609,12.5031],[122.2479,12.5569],[122.278,12.5929],[122.2875,12.5893],[122.3108,12.5288]],[[122.094,12.3549],[122.014,12.1056],[121.9602,12.1914],[121.9819,12.2453],[121.9356,12.2904],[121.9232,12.3313],[121.941,12.3854],[121.9895,12.4353],[122.0016,12.5985],[122.1038,12.6506],[122.145,12.6526],[122.1303,12.6126],[122.1316,12.5375],[122.094,12.3549]],[[123.7754,12.4539],[123.7791,12.3663],[123.7415,12.3985],[123.6206,12.5705],[123.5872,12.6333],[123.6215,12.6749],[123.7087,12.6108],[123.7754,12.4539]],[[123.2818,12.8534],[123.3672,12.7008],[123.2742,12.8051],[123.1664,12.8759],[123.0542,12.9935],[122.9734,13.0347],[122.949,13.0587],[122.9575,13.1072],[123.0171,13.1162],[123.0436,13.1134],[123.2063,12.9054],[123.2818,12.8534]],[[120.7044,13.4795],[120.7554,13.471],[120.9153,13.5011],[120.9808,13.486],[121.0247,13.4287],[121.0793,13.4107],[121.1225,13.3813],[121.2027,13.4323],[121.2844,13.3741],[121.3568,13.2655],[121.4422,13.1884],[121.5228,13.1312],[121.5387,13.0889],[121.4897,13.0196],[121.4748,12.9316],[121.4797,12.8371],[121.5406,12.6382],[121.5192,12.5842],[121.458,12.508],[121.4123,12.423],[121.4182,12.3888],[121.4001,12.3607],[121.3943,12.3006],[121.3568,12.3131],[121.3224,12.3036],[121.2889,12.2767],[121.2367,12.2188],[121.1555,12.2363],[121.117,12.2534],[121.1076,12.3036],[121.0834,12.339],[121.0485,12.36],[120.9625,12.4465],[120.9222,12.5116],[120.9215,12.5811],[120.8994,12.6458],[120.8548,12.7037],[120.796,12.748],[120.7764,12.7906],[120.7688,12.8409],[120.7637,12.9698],[120.6803,13.1306],[120.6514,13.1691],[120.5731,13.2089],[120.5083,13.2601],[120.4807,13.311],[120.4555,13.3935],[120.4381,13.4054],[120.3875,13.4017],[120.3385,13.4124],[120.3527,13.4729],[120.4013,13.517],[120.4684,13.5224],[120.6533,13.4976],[120.7044,13.4795]],[[121.9148,13.5403],[121.9766,13.5374],[121.9957,13.5468],[122.1146,13.4632],[122.1073,13.4208],[122.1224,13.3651],[122.0547,13.2687],[122.0424,13.2362],[122.0049,13.205],[121.8759,13.2817],[121.8292,13.3286],[121.815,13.4245],[121.8662,13.5662],[121.9148,13.5403]],[[120.2713,13.7507],[120.2729,13.683],[120.1042,13.7824],[120.0994,13.8169],[120.1034,13.8425],[120.1207,13.8581],[120.2114,13.8207],[120.2713,13.7507]],[[124.3536,13.6322],[124.3271,13.5674],[124.2945,13.5903],[124.2482,13.5867],[124.1754,13.5315],[124.057,13.6056],[124.0389,13.6631],[124.1237,13.7905],[124.1229,13.9797],[124.1537,14.0262],[124.1862,14.0595],[124.2249,14.0776],[124.3083,13.947],[124.3367,13.9311],[124.4172,13.871],[124.3963,13.7501],[124.404,13.6794],[124.3536,13.6322]],[[122.1754,14.0488],[122.1723,14.008],[121.9563,14.1561],[121.9464,14.1815],[121.946,14.2051],[121.9592,14.2288],[122.1754,14.0488]],[[122.0335,15.005],[122.0516,14.9699],[122.0317,14.9716],[122.0173,14.9653],[121.9703,14.893],[122.0217,14.7594],[121.9896,14.6622],[121.933,14.6561],[121.9106,14.6665],[121.9222,14.7146],[121.9346,14.7366],[121.923,14.8],[121.8893,14.8398],[121.8623,14.9172],[121.8203,14.9636],[121.8398,15.0381],[121.9717,15.0464],[122.0335,15.005]],[[121.1016,18.6153],[121.2545,18.5634],[121.593,18.3765],[121.7168,18.3301],[121.8456,18.2954],[121.9476,18.2852],[122.0385,18.3279],[122.077,18.3717],[122.1467,18.4866],[122.2212,18.5006],[122.2655,18.4588],[122.2998,18.4028],[122.315,18.3203],[122.2938,18.2343],[122.2229,18.1571],[122.1795,18.0643],[122.151,17.7565],[122.1523,17.6644],[122.1752,17.5757],[122.2368,17.4349],[122.269,17.3953],[122.3623,17.3449],[122.3875,17.3068],[122.3929,17.2384],[122.4075,17.1781],[122.4679,17.1551],[122.5191,17.1249],[122.5,17.058],[122.468,16.99],[122.4258,16.8227],[122.2259,16.4352],[122.2142,16.3515],[122.1352,16.1848],[121.9747,16.1579],[121.7887,16.0774],[121.6852,16.0147],[121.5953,15.9333],[121.5609,15.8268],[121.5904,15.778],[121.6092,15.726],[121.607,15.6698],[121.5792,15.6232],[121.4898,15.5095],[121.4521,15.4167],[121.4119,15.375],[121.3923,15.3244],[121.3989,15.2666],[121.435,15.2163],[121.5439,14.9992],[121.6605,14.7895],[121.6856,14.7654],[121.6954,14.7373],[121.6266,14.6817],[121.6279,14.5812],[121.6485,14.4815],[121.7519,14.2342],[121.7666,14.1681],[121.8005,14.1139],[121.8533,14.0631],[121.9117,14.0204],[122.0796,13.9471],[122.1443,13.9327],[122.2117,13.9302],[122.2284,13.9795],[122.2875,13.9962],[122.2744,14.0447],[122.2025,14.1117],[122.1997,14.148],[122.2375,14.175],[122.2826,14.1908],[122.3837,14.2639],[122.4908,14.3224],[122.6271,14.3175],[122.761,14.2849],[122.8561,14.2508],[122.9342,14.1881],[123.0146,14.0798],[123.071,13.96],[123.0707,13.9027],[123.0569,13.8455],[123.06,13.7888],[123.102,13.7502],[123.2314,13.7474],[123.297,13.8364],[123.3054,13.9366],[123.2593,13.9754],[123.2805,14.0248],[123.3203,14.0617],[123.3774,14.0287],[123.4323,13.9663],[123.6328,13.8985],[123.6841,13.897],[123.726,13.8843],[123.8157,13.8371],[123.8576,13.7996],[123.8063,13.7217],[123.6071,13.7044],[123.5496,13.6458],[123.6081,13.5281],[123.7036,13.4316],[123.7648,13.3535],[123.8192,13.2695],[123.8166,13.1916],[123.7852,13.1105],[123.8728,13.117],[123.9552,13.0997],[124.0691,13.0319],[124.1046,13.025],[124.1428,13.0358],[124.1373,12.7912],[124.0598,12.5671],[123.9617,12.595],[123.8778,12.6897],[123.8949,12.805],[123.9485,12.9164],[123.918,12.9399],[123.8639,12.9307],[123.8023,12.9056],[123.736,12.8969],[123.6268,12.9118],[123.4023,13.0331],[123.3109,13.0441],[123.2904,13.099],[123.2955,13.2156],[123.206,13.3535],[123.1916,13.4029],[123.1633,13.4417],[122.8962,13.5919],[122.8635,13.6172],[122.7813,13.7371],[122.5952,13.9076],[122.5431,13.925],[122.4863,13.93],[122.468,13.8867],[122.4938,13.8202],[122.5042,13.7631],[122.5002,13.7032],[122.508,13.6568],[122.5962,13.562],[122.6094,13.5171],[122.6679,13.3954],[122.6751,13.2532],[122.5999,13.1941],[122.5152,13.26],[122.5125,13.3136],[122.4979,13.3635],[122.4069,13.4928],[122.3766,13.5206],[122.2053,13.6482],[122.0728,13.7884],[121.7779,13.9376],[121.7429,13.9458],[121.6917,13.9346],[121.6435,13.916],[121.5011,13.8422],[121.4508,13.7908],[121.4463,13.7119],[121.3441,13.6491],[121.2035,13.6403],[121.0955,13.6795],[121.0062,13.7581],[120.9323,13.7619],[120.8407,13.8847],[120.7291,13.9005],[120.6371,13.8045],[120.6174,13.9953],[120.6168,14.188],[120.6427,14.2443],[120.6883,14.2912],[120.9221,14.4931],[120.9516,14.558],[120.9413,14.6451],[120.8881,14.7158],[120.8045,14.7588],[120.7079,14.7766],[120.6383,14.8162],[120.5837,14.8813],[120.5468,14.7661],[120.5827,14.5946],[120.5887,14.4831],[120.5557,14.4414],[120.4957,14.4402],[120.4388,14.4534],[120.3961,14.4933],[120.3652,14.6083],[120.2839,14.6844],[120.2508,14.7933],[120.2139,14.8088],[120.138,14.8004],[120.0821,14.8511],[120.0445,14.9781],[120.0366,15.1146],[120.005,15.2292],[119.9594,15.3402],[119.9328,15.4309],[119.8916,15.8377],[119.8814,15.875],[119.8597,15.9058],[119.8082,15.952],[119.7689,16.0084],[119.7618,16.055],[119.7726,16.2551],[119.7902,16.3033],[119.8308,16.3266],[119.8861,16.2874],[119.9304,16.2388],[119.9852,16.2154],[120.0334,16.1846],[120.124,16.0662],[120.1598,16.0477],[120.2713,16.0514],[120.337,16.0665],[120.3688,16.1096],[120.3888,16.1609],[120.3893,16.2216],[120.325,16.4003],[120.3053,16.5292],[120.3044,16.6455],[120.3212,16.7619],[120.4089,16.9556],[120.4201,17.0901],[120.4117,17.2699],[120.4271,17.3769],[120.4245,17.4383],[120.3721,17.5351],[120.3584,17.6382],[120.5051,18.1626],[120.551,18.2641],[120.5845,18.3688],[120.5997,18.5079],[120.7094,18.5459],[120.8138,18.6034],[120.8678,18.5989],[120.925,18.5851],[121.0514,18.6137],[121.1016,18.6153]],[[121.9217,18.8947],[121.8582,18.8229],[121.8252,18.8427],[121.8607,18.9125],[121.8598,18.9368],[121.8889,18.9916],[121.9434,19.0104],[121.9879,18.9566],[121.9217,18.8947]],[[121.2522,19.0824],[121.2467,19.0152],[121.1961,19.0507],[121.1849,19.1014],[121.1899,19.1389],[121.2132,19.1836],[121.2447,19.143],[121.2522,19.0824]],[[121.5209,19.362],[121.5313,19.2713],[121.4721,19.2733],[121.3829,19.3285],[121.3746,19.3563],[121.376,19.3797],[121.3916,19.3994],[121.5209,19.362]],[[121.9601,20.3659],[121.9413,20.3537],[121.9141,20.3594],[121.9412,20.4537],[121.9912,20.4796],[122.0312,20.4694],[121.9601,20.3659]],[[121.8781,20.7819],[121.8296,20.7003],[121.7906,20.7012],[121.7965,20.7466],[121.8479,20.8413],[121.867,20.8392],[121.8781,20.7819]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Philippines","sov_a3":"PHL","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Philippines","adm0_a3":"PHL","geou_dif":0,"geounit":"Philippines","gu_a3":"PHL","su_dif":0,"subunit":"Philippines","su_a3":"PHL","brk_diff":0,"name":"Philippines","name_long":"Philippines","brk_a3":"PHL","brk_name":"Philippines","brk_group":"","abbrev":"Phil.","postal":"PH","formal_en":"Republic of the Philippines","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Philippines","name_alt":"","mapcolor7":3,"mapcolor8":2,"mapcolor9":2,"mapcolor13":8,"pop_est":97976603,"gdp_md_est":317500,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"5. Emerging region: G20","income_grp":"4. Lower middle income","wikipedia":-99,"fips_10":"","iso_a2":"PH","iso_a3":"PHL","iso_n3":"608","un_a3":"608","wb_a2":"PH","wb_a3":"PHL","woe_id":-99,"adm0_a3_is":"PHL","adm0_a3_us":"PHL","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"South-Eastern Asia","region_wb":"East Asia & Pacific","name_len":11,"long_len":11,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[47.983,45.4882],[47.9677,45.47],[47.9203,45.5621],[47.9176,45.6182],[47.9472,45.6471],[47.9871,45.5541],[47.983,45.4882]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Russia","sov_a3":"RUS","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Russia","adm0_a3":"RUS","geou_dif":0,"geounit":"Russia","gu_a3":"RUS","su_dif":0,"subunit":"Russia","su_a3":"RUS","brk_diff":0,"name":"Russia","name_long":"Russian Federation","brk_a3":"RUS","brk_name":"Russia","brk_group":"","abbrev":"Rus.","postal":"RUS","formal_en":"Russian Federation","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Russian Federation","name_alt":"","mapcolor7":2,"mapcolor8":5,"mapcolor9":7,"mapcolor13":7,"pop_est":140041247,"gdp_md_est":2266000,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"3. Emerging region: BRIC","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"RU","iso_a3":"RUS","iso_n3":"643","un_a3":"643","wb_a2":"RU","wb_a3":"RUS","woe_id":-99,"adm0_a3_is":"RUS","adm0_a3_us":"RUS","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Eastern Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":18,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[5.0858,60.3076],[5.0891,60.1888],[4.997,60.1978],[4.9556,60.2433],[4.9436,60.2724],[4.9508,60.3412],[4.9301,60.4121],[4.9572,60.4473],[4.9906,60.4521],[5.0502,60.389],[5.0858,60.3076]],[[4.9587,61.0846],[4.8701,61.0719],[4.799,61.0827],[4.8244,61.1782],[4.8616,61.1938],[4.9154,61.1994],[4.9732,61.1482],[4.9587,61.0846]],[[8.1027,63.3376],[8.0047,63.3369],[7.8883,63.3523],[7.8153,63.3851],[7.804,63.4139],[7.9384,63.4498],[8.0735,63.4708],[8.1361,63.4313],[8.1409,63.3664],[8.1027,63.3376]],[[8.4708,63.6671],[8.3562,63.6648],[8.2871,63.6872],[8.4513,63.7318],[8.7089,63.7743],[8.7334,63.8013],[8.7646,63.8046],[8.8092,63.7714],[8.8148,63.726],[8.7865,63.7035],[8.4708,63.6671]],[[11.2314,64.8659],[11.179,64.838],[11.0625,64.8604],[10.8325,64.8431],[10.7398,64.8703],[10.8135,64.9232],[11.021,64.9787],[11.1326,64.9762],[11.2462,64.9079],[11.2314,64.8659]],[[11.968,65.6265],[11.9019,65.5957],[11.7783,65.6045],[11.7651,65.631],[11.8004,65.6839],[11.8754,65.7059],[11.9724,65.7016],[12.0032,65.6794],[11.968,65.6265]],[[12.5096,65.902],[12.4295,65.8991],[12.4302,65.9399],[12.4761,65.9771],[12.5488,66.0019],[12.6424,66.0085],[12.7471,66.0114],[12.7788,65.9917],[12.7187,65.9639],[12.5096,65.902]],[[12.4199,66.0433],[12.3273,66.0366],[12.3428,66.0808],[12.4177,66.1227],[12.4464,66.1513],[12.4613,66.185],[12.5274,66.2105],[12.6208,66.1779],[12.6227,66.1225],[12.5764,66.0719],[12.4199,66.0433]],[[12.9718,67.8741],[12.824,67.8212],[12.8779,67.9178],[12.9577,68.0155],[13.0681,68.0713],[13.1229,68.0494],[13.0978,68.0027],[13.0982,67.9564],[13.0746,67.9346],[12.9718,67.8741]],[[13.8729,68.2653],[13.9323,68.2482],[14.0877,68.2532],[14.1188,68.2468],[14.0968,68.2186],[14.0293,68.1875],[13.8877,68.1685],[13.824,68.1211],[13.7784,68.105],[13.6562,68.1048],[13.584,68.0938],[13.4952,68.0517],[13.4242,68.0828],[13.4044,68.0607],[13.3915,68.0212],[13.3521,68.0097],[13.2294,67.9954],[13.1995,68.0873],[13.256,68.1206],[13.3002,68.1604],[13.368,68.1666],[13.4287,68.1632],[13.538,68.249],[13.6877,68.2734],[13.7841,68.2761],[13.8729,68.2653]],[[15.2071,68.9431],[15.3372,68.8424],[15.3966,68.7836],[15.3484,68.6724],[15.2221,68.6163],[15.0271,68.6063],[14.8902,68.611],[14.804,68.638],[14.7933,68.6683],[14.7435,68.6772],[14.6121,68.6383],[14.5208,68.6331],[14.4047,68.6632],[14.3734,68.7114],[14.4967,68.7719],[14.5537,68.8188],[14.6904,68.8147],[14.7246,68.8001],[14.8019,68.791],[14.8488,68.8476],[14.838,68.8867],[14.8724,68.9139],[15.0375,68.8943],[15.0378,69.0005],[15.1019,69.008],[15.1281,69.004],[15.1756,68.9815],[15.2071,68.9431]],[[15.7604,68.5612],[15.7724,68.5542],[15.9086,68.6505],[16.0596,68.6805],[16.0689,68.714],[16.1274,68.7464],[16.1208,68.7994],[16.1506,68.8424],[16.2275,68.8538],[16.2756,68.8683],[16.3289,68.8763],[16.4252,68.8416],[16.4797,68.8029],[16.5474,68.7166],[16.5192,68.633],[16.338,68.5679],[16.1939,68.5385],[16.0484,68.4637],[15.9753,68.4025],[15.9125,68.3893],[15.8728,68.3942],[15.8374,68.409],[15.7637,68.4091],[15.6825,68.356],[15.4375,68.3128],[15.3414,68.3253],[15.337,68.3782],[15.2797,68.3738],[15.1879,68.3104],[15.098,68.2892],[15.0377,68.2827],[14.9269,68.3066],[14.6289,68.1985],[14.3495,68.1783],[14.2575,68.1908],[14.2572,68.2569],[14.4378,68.3416],[14.5858,68.4003],[15.0953,68.4414],[15.4126,68.6158],[15.4893,68.8053],[15.5643,68.8737],[15.529,68.9124],[15.4437,68.9192],[15.4385,68.9786],[15.483,69.0435],[15.6495,69.1326],[15.742,69.1705],[15.8927,69.2779],[15.9653,69.3021],[16.048,69.3021],[16.1295,69.2739],[16.1148,69.2164],[15.9927,69.1126],[15.8117,69.0242],[15.8338,68.9607],[15.9059,68.9085],[15.9235,68.8192],[15.9279,68.7332],[15.7907,68.617],[15.7604,68.5612]],[[17.503,69.5962],[17.6232,69.5391],[17.6773,69.5565],[17.7837,69.563],[17.8628,69.543],[17.9274,69.5066],[18.0041,69.505],[18.0522,69.4575],[18.0768,69.3958],[18.0211,69.3496],[17.9421,69.3287],[17.9207,69.2743],[17.9507,69.1981],[17.7735,69.172],[17.5682,69.1604],[17.4879,69.1968],[17.3236,69.13],[17.1609,69.0259],[17.0825,69.0137],[17.0771,69.0466],[16.9602,69.0694],[16.8104,69.0707],[16.8154,69.0951],[16.8426,69.1124],[16.9718,69.1379],[16.9976,69.1906],[16.9741,69.2847],[16.9969,69.3304],[17.0018,69.3619],[17.083,69.3988],[17.3608,69.3815],[17.3945,69.4167],[17.3734,69.4389],[17.2299,69.4777],[17.252,69.5038],[17.3556,69.5271],[17.4536,69.5302],[17.4831,69.5697],[17.4882,69.5869],[17.503,69.5962]],[[29.9562,69.7968],[29.7662,69.7675],[29.7442,69.7916],[29.7859,69.8291],[29.8358,69.9056],[29.914,69.9024],[29.993,69.8732],[30.0552,69.8384],[29.9562,69.7968]],[[20.7792,70.0897],[20.7253,70.0665],[20.6426,70.057],[20.598,70.0714],[20.5347,70.0809],[20.4643,70.0766],[20.4051,70.1191],[20.4117,70.1549],[20.4928,70.2033],[20.6549,70.2309],[20.786,70.2195],[20.8194,70.2055],[20.7792,70.0897]],[[19.2551,70.0664],[19.3438,70.012],[19.4223,70.0172],[19.4459,70.0377],[19.4995,70.0479],[19.6078,70.0191],[19.5923,69.9702],[19.4424,69.9084],[19.3348,69.8203],[19.1971,69.7998],[19.1309,69.8104],[19.0078,69.7596],[18.9092,69.7067],[18.8069,69.6398],[18.8007,69.6054],[18.7848,69.579],[18.4103,69.5528],[18.2741,69.5355],[18.1299,69.5579],[18.0615,69.6021],[18.0835,69.6261],[18.2274,69.6357],[18.232,69.6768],[18.2685,69.7018],[18.315,69.7155],[18.3493,69.7679],[18.4063,69.7815],[18.5124,69.7687],[18.584,69.8066],[18.6243,69.813],[18.674,69.7816],[18.6979,69.8249],[18.674,69.8643],[18.6865,69.8909],[18.8238,69.9601],[18.8832,70.0105],[18.9687,70.043],[19.051,70.0378],[19.0749,70.0857],[19.051,70.1347],[19.0601,70.1666],[19.1327,70.2441],[19.2127,70.2475],[19.2494,70.1786],[19.2551,70.0664]],[[19.7675,70.2167],[19.8184,70.205],[19.8687,70.2123],[19.9104,70.2019],[19.9941,70.1493],[20.0843,70.1286],[20.0885,70.1021],[20.006,70.0762],[19.8973,70.0685],[19.7809,70.0774],[19.7467,70.1105],[19.7108,70.1653],[19.6135,70.2191],[19.599,70.2662],[19.6838,70.2736],[19.7675,70.2167]],[[23.6153,70.5493],[23.634,70.5025],[23.641,70.464],[23.5478,70.4082],[23.3328,70.335],[23.3451,70.3153],[23.2707,70.2965],[23.1592,70.2826],[23.1003,70.2961],[23.1084,70.3588],[23.0906,70.3776],[23.006,70.3528],[22.9179,70.3847],[22.9178,70.4167],[22.941,70.4446],[23.0225,70.4869],[23.1584,70.5161],[23.248,70.5051],[23.5467,70.6171],[23.5789,70.5937],[23.6153,70.5493]],[[24.0176,70.5674],[23.8271,70.5275],[23.7166,70.5619],[23.6701,70.5971],[23.6633,70.6752],[23.6892,70.7228],[23.7784,70.7474],[23.8365,70.7294],[23.8521,70.7144],[23.9564,70.6996],[24.0783,70.6506],[24.0176,70.5674]],[[23.4405,70.8158],[23.4209,70.7844],[23.3871,70.7539],[23.3052,70.7217],[23.0682,70.5941],[22.9289,70.5735],[22.8848,70.5535],[22.8291,70.5416],[22.6561,70.559],[22.6054,70.5332],[22.5575,70.5159],[22.4322,70.5092],[22.3587,70.5148],[22.1688,70.5621],[22.0558,70.6133],[21.9945,70.6571],[22.17,70.6563],[22.2326,70.6669],[22.3503,70.6577],[22.421,70.7026],[22.5707,70.6972],[22.8581,70.7284],[22.9636,70.711],[23.2047,70.8155],[23.2802,70.8127],[23.3956,70.8426],[23.4405,70.8158]],[[27.898,70.6779],[27.9988,70.6643],[28.2156,70.7043],[28.2718,70.668],[28.2027,70.5769],[28.191,70.4402],[28.166,70.3604],[28.166,70.2876],[28.193,70.2486],[28.2801,70.4034],[28.3099,70.4431],[28.4373,70.5014],[28.4848,70.6188],[28.6094,70.7597],[28.7498,70.8415],[28.8315,70.864],[29.1023,70.8607],[29.2186,70.8299],[29.3211,70.7615],[29.3977,70.7341],[29.6391,70.705],[29.722,70.6686],[29.7375,70.6468],[29.7965,70.6425],[29.9594,70.6944],[30.0651,70.703],[30.2377,70.6222],[30.203,70.5623],[30.2132,70.5433],[30.4221,70.5472],[30.5959,70.5237],[30.9264,70.4011],[30.9606,70.3438],[30.9441,70.2744],[30.4689,70.1979],[30.263,70.1247],[29.9259,70.0965],[28.7812,70.1454],[28.8043,70.0925],[29.6014,69.9768],[29.6469,69.9437],[29.6214,69.8741],[29.621,69.8182],[29.6359,69.7801],[29.6946,69.7446],[29.7921,69.7279],[29.9903,69.7367],[30.0883,69.7176],[30.1552,69.7459],[30.1801,69.8412],[30.2376,69.8622],[30.3488,69.8346],[30.3973,69.7328],[30.4283,69.7223],[30.4844,69.7949],[30.5945,69.7896],[30.7145,69.7957],[30.8697,69.7834],[30.9241,69.6518],[30.9225,69.6058],[30.8967,69.5612],[30.8607,69.5384],[30.7889,69.5285],[30.6154,69.5326],[30.3797,69.5847],[30.2275,69.6338],[30.1802,69.6358],[30.1598,69.6299],[30.1965,69.5806],[30.1867,69.5428],[30.1638,69.5016],[30.1318,69.4643],[30.0873,69.4329],[29.994,69.3925],[29.8327,69.3604],[29.3883,69.2981],[29.353,69.2706],[29.21,69.097],[29.1709,69.0715],[29.1186,69.05],[28.9658,69.022],[28.8919,69.0606],[28.8326,69.119],[28.8463,69.1769],[29.0249,69.288],[29.1918,69.3667],[29.2389,69.3939],[29.3334,69.473],[29.1416,69.6714],[28.8004,69.7315],[28.4117,69.8228],[28.2691,69.8714],[28.0473,69.9717],[27.8899,70.0617],[27.7479,70.0648],[27.5917,70.0422],[27.348,69.9601],[27.2057,69.9187],[27.1275,69.9065],[27.1087,69.9047],[26.9343,69.9281],[26.7402,69.9331],[26.5843,69.9263],[26.5254,69.915],[26.3082,69.7819],[26.1562,69.7147],[26.0725,69.6916],[26.0115,69.6526],[25.9615,69.5886],[25.8502,69.3665],[25.7672,69.2827],[25.7486,69.2314],[25.7682,69.0761],[25.7483,68.9901],[25.6467,68.9191],[25.5753,68.8872],[25.4809,68.8806],[25.3571,68.8625],[25.2491,68.8213],[25.1729,68.7653],[25.0869,68.6396],[24.9414,68.5933],[24.8024,68.6065],[24.7032,68.6528],[24.4905,68.6887],[24.332,68.7115],[24.1541,68.7609],[23.9974,68.7984],[23.854,68.8059],[23.7726,68.7584],[23.707,68.7139],[23.4625,68.6776],[23.324,68.649],[23.1443,68.6426],[23.0717,68.6744],[22.811,68.6953],[22.5007,68.7202],[22.4109,68.7199],[22.3829,68.7766],[22.3004,68.8559],[22.0797,68.9928],[21.9895,69.0411],[21.8197,69.1545],[21.6218,69.2707],[21.5938,69.2736],[21.4612,69.2775],[21.2668,69.2737],[21.1438,69.2473],[21.0661,69.2141],[21.0526,69.1866],[21.1278,69.0808],[21.1045,69.0544],[21.0657,69.0417],[20.8893,69.0714],[20.6759,69.0695],[20.6222,69.0369],[20.492,69.0333],[20.1167,69.0209],[20.2823,68.9343],[20.3371,68.8997],[20.348,68.8487],[20.3194,68.7541],[20.24,68.6731],[20.1475,68.6073],[19.9688,68.542],[20.24,68.4775],[20.056,68.3904],[19.9698,68.3564],[19.87,68.3623],[19.6912,68.3924],[19.259,68.4653],[19.0526,68.4927],[18.8683,68.5011],[18.7698,68.5],[18.3786,68.5624],[18.303,68.5554],[18.1626,68.5284],[18.1471,68.4678],[18.156,68.3168],[18.1767,68.2006],[18.125,68.1334],[18.0732,68.0878],[17.9167,67.9649],[17.5647,68.0484],[17.3246,68.1038],[17.1705,68.0301],[16.7836,67.895],[16.5855,67.6283],[16.5741,67.6196],[16.4571,67.5518],[16.3071,67.5206],[16.1936,67.5052],[16.1274,67.4258],[16.2815,67.3121],[16.3606,67.252],[16.4343,67.1551],[16.4207,67.0934],[16.4035,67.055],[16.2377,66.9764],[15.8842,66.7688],[15.557,66.5521],[15.4229,66.4898],[15.4838,66.306],[15.3749,66.2521],[15.1533,66.1911],[15.04,66.1675],[14.918,66.1537],[14.5433,66.1293],[14.61,65.9323],[14.6352,65.845],[14.6346,65.7933],[14.5958,65.7429],[14.5495,65.6464],[14.4797,65.3015],[14.4263,65.2644],[14.3524,65.1708],[14.1151,64.9461],[13.9248,64.7968],[13.6503,64.5815],[13.8735,64.5136],[14.0776,64.464],[14.1199,64.3877],[14.148,64.2603],[14.1412,64.1735],[14.0633,64.0955],[14.0027,64.0407],[13.9605,64.014],[13.6707,64.0406],[13.2996,64.0748],[13.2035,64.0751],[12.9876,64.0505],[12.7928,64],[12.69,63.9574],[12.6625,63.9405],[12.5327,63.8436],[12.302,63.6712],[12.1752,63.5959],[12.2121,63.4922],[11.9999,63.2917],[12.1387,63.0892],[12.1446,63.0825],[12.2182,63.0006],[12.141,62.9479],[12.1086,62.9195],[12.1196,62.8259],[12.1398,62.7213],[12.1219,62.66],[12.1146,62.5919],[12.3035,62.2856],[12.3014,62.2138],[12.292,62.1674],[12.2337,61.9769],[12.1554,61.7208],[12.2921,61.6535],[12.4868,61.573],[12.5961,61.5413],[12.7575,61.4457],[12.8808,61.3523],[12.8637,61.2903],[12.8282,61.2218],[12.7764,61.174],[12.7278,61.1083],[12.7061,61.0599],[12.683,61.0468],[12.4676,61.0415],[12.3537,61.0232],[12.2941,61.0027],[12.3146,60.8921],[12.4453,60.6896],[12.5538,60.5457],[12.5887,60.4507],[12.5528,60.3545],[12.5158,60.3052],[12.5146,60.2389],[12.4861,60.1068],[12.4021,60.04],[12.292,59.9672],[12.1692,59.9129],[12.0719,59.8976],[11.9883,59.8913],[11.9321,59.8637],[11.8813,59.7825],[11.8343,59.6972],[11.6808,59.5923],[11.6849,59.5558],[11.7434,59.4314],[11.7981,59.2899],[11.7519,59.1576],[11.7122,59.0187],[11.6428,58.9261],[11.5436,58.893],[11.4707,58.9095],[11.3883,59.0365],[11.3864,59.0657],[11.3659,59.1045],[11.1321,59.1432],[11.0908,59.1418],[10.9989,59.1645],[10.945,59.1708],[10.8345,59.1839],[10.7426,59.296],[10.6449,59.3892],[10.6311,59.4282],[10.6344,59.6025],[10.6045,59.68],[10.5953,59.7646],[10.5339,59.6958],[10.5695,59.5871],[10.4938,59.5415],[10.3981,59.5193],[10.4071,59.4557],[10.4464,59.4436],[10.4546,59.3775],[10.4313,59.2796],[10.2432,59.0621],[10.2052,59.0387],[10.1794,59.0093],[10.0831,59.0288],[9.9596,58.9682],[9.8426,58.9585],[9.8002,59.0271],[9.6352,59.1178],[9.5572,59.1127],[9.6271,59.0679],[9.6961,59.0097],[9.6569,58.9712],[9.6185,58.946],[9.5511,58.933],[9.31,58.8568],[9.3958,58.8057],[9.3229,58.7476],[9.2387,58.739],[9.1938,58.7119],[9.1781,58.675],[8.9284,58.57],[8.5214,58.3006],[8.3122,58.2245],[8.1661,58.1453],[8.0374,58.1473],[7.8756,58.08],[7.4659,58.0209],[7.1941,58.0477],[7.0049,58.0242],[6.9034,58.0705],[6.8902,58.1023],[6.8953,58.1208],[6.9123,58.1429],[6.8771,58.1507],[6.8028,58.1545],[6.7711,58.1322],[6.7668,58.0815],[6.7314,58.0683],[6.5905,58.0973],[6.5551,58.1234],[6.6058,58.1764],[6.6925,58.224],[6.6768,58.2338],[6.6599,58.2627],[6.6176,58.2664],[6.4915,58.2594],[6.3891,58.268],[6.0547,58.3751],[5.9766,58.4323],[5.7068,58.5236],[5.5859,58.6204],[5.5173,58.7265],[5.5225,58.8227],[5.5556,58.9752],[5.6122,59.0129],[5.8543,58.9595],[6.099,58.8703],[6.1373,58.8747],[6.2142,58.9447],[6.3633,59.0009],[6.3211,59.0165],[6.0994,58.952],[6.017,58.9877],[5.8892,59.0605],[5.8892,59.0979],[5.9487,59.1354],[5.9686,59.1861],[5.9373,59.234],[5.9519,59.2991],[6.0507,59.3682],[6.1989,59.4381],[6.3057,59.5056],[6.4153,59.5471],[6.4039,59.561],[6.2785,59.5345],[6.1586,59.4896],[6.0174,59.4145],[5.8452,59.3535],[5.718,59.3298],[5.6573,59.3103],[5.5641,59.2912],[5.4676,59.2038],[5.3623,59.1664],[5.1732,59.1625],[5.1316,59.2265],[5.1851,59.4537],[5.2422,59.5643],[5.3049,59.6426],[5.4035,59.6558],[5.4725,59.7131],[5.5297,59.7131],[5.5795,59.6866],[5.7722,59.6609],[5.8673,59.734],[5.991,59.7447],[6.2166,59.8184],[6.2119,59.8318],[6.0593,59.8156],[5.9667,59.8132],[5.834,59.7947],[5.7635,59.8079],[5.7305,59.8631],[5.7836,59.9128],[5.9965,60.0315],[6.0699,60.0835],[6.1118,60.1321],[6.1052,60.1651],[6.1405,60.2335],[6.3487,60.353],[6.5181,60.4076],[6.5736,60.3606],[6.5264,60.2136],[6.5269,60.1529],[6.6609,60.3672],[6.7199,60.4182],[6.7871,60.4541],[6.9497,60.4782],[6.9957,60.512],[6.8063,60.5008],[6.347,60.4191],[6.1533,60.3462],[6.1018,60.2901],[5.9674,60.2056],[5.9044,60.1506],[5.8766,60.07],[5.8009,60.0262],[5.6988,60.01],[5.557,59.9078],[5.4945,59.8256],[5.3534,59.7601],[5.2639,59.7098],[5.2345,59.6918],[5.186,59.6423],[5.1458,59.6388],[5.1107,59.6678],[5.1049,59.7317],[5.1192,59.8337],[5.1871,59.9071],[5.2195,59.9788],[5.1744,60.0457],[5.2057,60.0879],[5.2654,60.0865],[5.3765,60.0672],[5.4945,60.0703],[5.6886,60.1232],[5.6576,60.1541],[5.5738,60.1585],[5.4174,60.1541],[5.2858,60.2057],[5.1836,60.3084],[5.1371,60.4456],[5.1682,60.4848],[5.5465,60.6246],[5.6483,60.688],[5.5894,60.6943],[5.4474,60.6173],[5.244,60.5696],[5.1158,60.636],[5.0491,60.7075],[5.0107,60.8585],[5.0246,60.9361],[5.0086,61.0382],[5.0954,61.0713],[5.1925,61.0537],[5.2882,61.0472],[5.5053,61.0561],[5.984,61.1173],[6.2926,61.081],[6.418,61.0843],[6.6099,61.137],[6.7778,61.1424],[6.9034,61.1021],[6.9721,61.056],[6.9806,60.9941],[7.0387,60.9529],[7.0779,60.9663],[7.0467,61.0153],[7.0401,61.0912],[7.545,61.1771],[7.6045,61.2105],[7.4039,61.2222],[7.3466,61.3006],[7.4525,61.4192],[7.4426,61.4346],[7.3312,61.372],[7.2763,61.2839],[7.298,61.2136],[7.276,61.181],[7.1735,61.166],[6.9426,61.1605],[6.7943,61.1904],[6.657,61.2066],[6.6103,61.2291],[6.6259,61.2793],[6.5999,61.2896],[6.5431,61.2445],[6.4926,61.1546],[6.3835,61.1339],[6.0825,61.1673],[5.6468,61.1476],[5.4513,61.1023],[5.3246,61.1083],[5.1067,61.1875],[5.0217,61.2506],[4.9899,61.3777],[5.0027,61.4336],[5.1725,61.4571],[5.2583,61.4555],[5.3387,61.4855],[5.2676,61.505],[5.1676,61.5434],[5.0994,61.6202],[4.9967,61.6452],[4.9278,61.7107],[4.9104,61.8096],[4.9301,61.8783],[4.9851,61.9004],[5.117,61.8854],[5.4653,61.8969],[5.7933,61.8271],[6.0158,61.7875],[6.4667,61.8074],[6.7308,61.8698],[6.6823,61.887],[6.3959,61.851],[6.1312,61.8524],[5.6645,61.9229],[5.473,61.9456],[5.2669,61.9356],[5.1596,61.957],[5.0965,62.0267],[5.1432,62.1599],[5.2409,62.1887],[5.2938,62.1539],[5.3577,62.1517],[5.4224,62.2074],[5.4843,62.2391],[5.5333,62.3109],[5.7182,62.3789],[5.7963,62.3847],[5.9083,62.416],[5.9798,62.4071],[6.0256,62.3757],[6.0835,62.3496],[6.209,62.3528],[6.5801,62.4073],[6.62,62.4233],[6.6924,62.4681],[6.4571,62.4481],[6.2617,62.4163],[6.1361,62.4075],[6.1185,62.4472],[6.1647,62.4824],[6.2375,62.5199],[6.2729,62.5838],[6.3529,62.6111],[6.4395,62.6097],[6.6184,62.6213],[6.7446,62.6379],[6.9611,62.6268],[7.2838,62.6023],[7.4918,62.5428],[7.5701,62.5482],[7.6531,62.564],[7.6907,62.5856],[7.5274,62.6103],[7.5182,62.6455],[7.5384,62.6721],[7.8047,62.721],[8.0955,62.7318],[8.0455,62.7712],[7.4084,62.7118],[7.2421,62.7523],[7.1108,62.752],[7.0249,62.7288],[6.78,62.7007],[6.735,62.7207],[6.7815,62.7896],[6.9282,62.9027],[6.9404,62.9305],[7.0085,62.9577],[7.3891,63.0233],[7.5719,63.0995],[7.6543,63.1092],[7.736,63.1039],[7.8604,63.1128],[8.1006,63.091],[8.2111,62.9955],[8.3105,62.9655],[8.6231,62.8462],[8.6092,62.8806],[8.3386,63.0422],[8.2352,63.0822],[8.158,63.1615],[8.1845,63.2365],[8.2715,63.2866],[8.5802,63.3134],[8.6355,63.3423],[8.641,63.3921],[8.5938,63.4261],[8.4802,63.4242],[8.3865,63.4453],[8.3607,63.4989],[8.3981,63.5351],[8.5762,63.6012],[8.6736,63.6226],[8.8424,63.6459],[9.1358,63.5937],[9.1581,63.5663],[9.0759,63.5004],[9.0842,63.4634],[9.1561,63.4593],[9.3236,63.5704],[9.5207,63.5857],[9.6022,63.6096],[9.6969,63.6246],[9.8322,63.5242],[9.8915,63.492],[9.936,63.4789],[9.9792,63.3953],[10.021,63.3908],[10.0806,63.4327],[10.1886,63.4548],[10.34,63.4693],[10.5909,63.4472],[10.7045,63.4636],[10.7602,63.4613],[10.7067,63.5363],[10.6736,63.558],[10.7253,63.625],[10.7792,63.6512],[10.9525,63.6982],[11.1179,63.7192],[11.2258,63.7638],[11.3707,63.8048],[11.3479,63.8377],[11.3076,63.8757],[11.2139,63.8781],[11.1756,63.8989],[11.2946,63.9482],[11.4576,64.003],[11.4292,64.0245],[11.3066,64.0489],[11.2136,64.0305],[11.0752,63.9881],[10.9143,63.9211],[10.9667,63.9016],[11.0473,63.8452],[10.9349,63.7702],[10.3392,63.571],[10.0551,63.5127],[9.924,63.5218],[9.8928,63.5762],[9.8323,63.6165],[9.7675,63.6995],[9.6572,63.6973],[9.5946,63.679],[9.5673,63.7062],[9.6147,63.7948],[9.708,63.8649],[9.8645,63.9178],[9.9395,63.9817],[10.01,64.0832],[10.2362,64.1796],[10.5656,64.4183],[10.834,64.4945],[10.9323,64.5777],[11.0904,64.6146],[11.2254,64.6795],[11.3313,64.6859],[11.5238,64.7444],[11.6329,64.8139],[11.5617,64.8183],[11.3925,64.773],[11.2968,64.7548],[11.3035,64.8294],[11.3499,64.9059],[11.4894,64.9758],[12.1597,65.179],[12.2266,65.1454],[12.3065,65.086],[12.5084,65.0994],[12.7384,65.2144],[12.9155,65.3393],[12.8198,65.3175],[12.7153,65.2664],[12.5117,65.1953],[12.4176,65.1841],[12.3639,65.1933],[12.334,65.2407],[12.2634,65.2561],[12.1996,65.2455],[12.1339,65.2792],[12.1222,65.3624],[12.2063,65.4862],[12.2729,65.5682],[12.3448,65.6302],[12.6277,65.8062],[12.6889,65.9022],[12.8168,65.9529],[12.983,65.9416],[13.0331,65.9562],[12.9761,66.0192],[12.7949,66.0691],[12.7838,66.1004],[13.3871,66.1828],[13.6744,66.18],[13.7597,66.221],[13.9158,66.2474],[14.0342,66.2976],[13.9731,66.3197],[13.6813,66.2736],[13.4989,66.2519],[13.4164,66.2526],[13.3521,66.2367],[13.1188,66.2307],[13.0682,66.4308],[13.1047,66.5394],[13.1916,66.5372],[13.2114,66.6408],[13.3118,66.7019],[13.4504,66.7155],[13.5202,66.7417],[13.6211,66.7948],[13.788,66.7825],[13.9595,66.7943],[13.917,66.8194],[13.7041,66.8517],[13.6516,66.9071],[13.7267,66.938],[13.8084,66.9608],[13.8802,66.9649],[14.0224,67.0731],[14.1088,67.1192],[14.2056,67.1112],[14.3403,67.1589],[14.4727,67.1427],[14.6007,67.1739],[14.7756,67.1945],[15.4157,67.2024],[15.4348,67.2467],[15.3001,67.2569],[14.8244,67.2683],[14.5815,67.2674],[14.4793,67.256],[14.4417,67.2714],[14.4483,67.2979],[14.5366,67.3397],[14.5785,67.386],[14.755,67.499],[14.9619,67.5743],[15.1205,67.555],[15.2892,67.4832],[15.4094,67.4742],[15.4653,67.4509],[15.5529,67.3518],[15.5944,67.3485],[15.5757,67.4438],[15.6915,67.5214],[15.6613,67.5428],[15.4873,67.5148],[15.354,67.5439],[15.2487,67.6021],[15.2187,67.6554],[15.2841,67.708],[15.3458,67.7344],[15.3039,67.7653],[15.0408,67.6826],[14.8547,67.6633],[14.7813,67.6749],[14.8211,67.7499],[14.7989,67.8093],[15.0484,67.9558],[15.1343,67.9727],[15.2744,67.9609],[15.4009,67.9196],[15.5066,67.9262],[15.6214,67.9483],[15.6058,67.9879],[15.3569,68.0036],[15.2929,68.0365],[15.316,68.0688],[15.4868,68.1028],[15.6566,68.1644],[15.8513,68.1822],[16.0079,68.2287],[16.0381,68.2182],[16.0646,68.1999],[16.1208,68.0273],[16.2607,67.8866],[16.3123,67.8814],[16.2586,68.0012],[16.3087,68.0356],[16.3722,68.0618],[16.392,68.0916],[16.3192,68.1018],[16.2598,68.1445],[16.1748,68.2813],[16.2038,68.3167],[16.3879,68.3896],[16.6188,68.4063],[16.8649,68.3553],[16.9514,68.3547],[17.094,68.3684],[17.3361,68.4104],[17.4785,68.4263],[17.5528,68.4263],[17.5712,68.4475],[17.5023,68.4611],[17.4802,68.4743],[17.4262,68.4819],[17.2023,68.4593],[16.5849,68.4665],[16.5253,68.4907],[16.5144,68.5326],[16.5799,68.5927],[16.6519,68.6258],[16.8847,68.6854],[17.1312,68.6935],[17.3908,68.7994],[17.49,68.8788],[17.5463,69.0011],[17.7046,69.1],[18.1015,69.1563],[18.1175,69.1812],[18.0754,69.2326],[18.0787,69.3252],[18.1875,69.4331],[18.2598,69.4706],[18.2932,69.4751],[18.3787,69.4398],[18.4826,69.3648],[18.6455,69.3219],[18.859,69.3145],[18.9159,69.3356],[18.75,69.3784],[18.6244,69.4344],[18.6145,69.4906],[18.674,69.5204],[18.7666,69.517],[18.8828,69.5233],[18.9911,69.5611],[19.0068,69.5877],[19.0113,69.6237],[19.0384,69.6604],[19.1973,69.7479],[19.687,69.8047],[19.7225,69.7816],[19.696,69.6129],[19.6397,69.5038],[19.6415,69.424],[19.7368,69.5038],[19.8646,69.7221],[19.9605,69.8246],[20.0689,69.8834],[20.1464,69.8967],[20.223,69.9272],[20.3242,69.9453],[20.3552,69.9219],[20.3872,69.8676],[20.3327,69.677],[20.3382,69.6167],[20.2771,69.5358],[20.0438,69.3557],[20.0545,69.3327],[20.1072,69.3412],[20.1977,69.3709],[20.4867,69.5421],[20.7395,69.5205],[20.7426,69.5345],[20.6615,69.5847],[20.5625,69.6328],[20.5327,69.6923],[20.546,69.8511],[20.6221,69.9139],[20.8403,69.9073],[20.9711,69.916],[21.0321,69.8875],[21.1631,69.8895],[21.2537,70.0032],[21.4329,70.0132],[21.5902,69.938],[21.7796,69.8875],[21.9317,69.8147],[21.9747,69.8346],[21.8926,70.0042],[21.8027,70.0661],[21.6078,70.0982],[21.4004,70.1745],[21.3463,70.2083],[21.3558,70.2334],[21.5388,70.2577],[21.7803,70.2299],[21.9955,70.2934],[22.0544,70.276],[22.2194,70.3092],[22.322,70.2645],[22.3848,70.2777],[22.4212,70.3376],[22.6846,70.3748],[22.8517,70.3405],[22.9412,70.305],[22.9828,70.2368],[23.0465,70.1019],[23.177,70.0291],[23.2579,69.9933],[23.3539,69.9834],[23.4002,70.0198],[23.3103,70.0636],[23.286,70.1048],[23.3291,70.2072],[23.3794,70.2475],[23.6612,70.3998],[23.8972,70.4788],[24.0385,70.4854],[24.2855,70.6624],[24.3556,70.6946],[24.42,70.702],[24.4035,70.7453],[24.2682,70.7727],[24.2635,70.8263],[24.4418,70.8916],[24.658,71.001],[24.7647,71.0084],[24.8316,70.978],[25.0422,70.9286],[25.1712,70.872],[25.2646,70.8435],[25.3254,70.8494],[25.3756,70.8919],[25.4359,70.9119],[25.5698,70.9007],[25.6497,70.8733],[25.7119,70.8697],[25.7682,70.8532],[25.7814,70.8168],[25.6656,70.7771],[25.4683,70.672],[25.2735,70.5524],[25.2093,70.4894],[25.1464,70.324],[24.9942,70.2182],[24.9827,70.144],[25.0438,70.109],[25.2118,70.1365],[25.4188,70.2355],[25.4705,70.3406],[25.9881,70.6254],[26.2309,70.7826],[26.5069,70.9128],[26.6613,70.9397],[26.734,70.8536],[26.6755,70.741],[26.5582,70.6691],[26.6446,70.6362],[26.6281,70.5509],[26.6012,70.5035],[26.584,70.4538],[26.5851,70.41],[26.6661,70.4217],[26.9894,70.5114],[27.0713,70.6084],[27.1473,70.6812],[27.1837,70.744],[27.3094,70.8036],[27.5465,70.804],[27.5557,70.8274],[27.269,70.91],[27.2353,70.9472],[27.3316,70.9967],[27.5971,71.0913],[27.7335,71.0809],[27.815,71.0594],[28.1417,71.043],[28.3923,70.9753],[28.3827,70.8694],[28.3269,70.8252],[28.2719,70.7979],[27.951,70.7176],[27.898,70.6779]],[[25.5863,71.1421],[25.8535,71.1039],[25.945,71.1046],[26.0776,71.0332],[26.1469,71.0395],[26.1338,70.9958],[25.9997,70.9751],[25.7913,70.9625],[25.7602,70.9538],[25.582,70.9608],[25.482,71.0196],[25.3149,71.0341],[25.3152,71.053],[25.4234,71.0974],[25.5863,71.1421]],[[-8.9536,70.8392],[-9.0458,70.8327],[-9.0989,70.8549],[-8.9646,70.9159],[-8.5208,71.0307],[-8.3437,71.1401],[-8.0014,71.1777],[-7.9788,71.1169],[-8.0021,71.0413],[-8.3023,70.9812],[-8.6354,70.9404],[-8.9536,70.8392]],[[19.2193,74.391],[19.0985,74.3521],[18.9176,74.4106],[18.7975,74.4857],[18.8612,74.5142],[19.1829,74.5179],[19.2615,74.479],[19.2747,74.4567],[19.2193,74.391]],[[21.6081,78.5957],[21.7456,78.572],[22.0432,78.577],[22.2073,78.4077],[22.2995,78.2282],[22.4493,78.2152],[22.7346,78.2399],[22.9889,78.252],[23.1192,78.2386],[23.3517,78.1863],[23.452,78.1495],[23.3646,78.1205],[23.152,78.0881],[23.1167,77.9915],[23.3306,77.9579],[23.684,77.8754],[23.883,77.8647],[24.2383,77.8985],[24.5715,77.8344],[24.9019,77.7566],[24.1298,77.6583],[24.0619,77.6306],[23.955,77.5577],[23.8412,77.4978],[23.7361,77.4624],[23.5052,77.4014],[23.3809,77.3803],[23.1014,77.3851],[22.9967,77.3608],[22.8995,77.3114],[22.8018,77.2758],[22.5537,77.2667],[22.427,77.3159],[22.4688,77.3311],[22.4866,77.3601],[22.4425,77.4293],[22.6789,77.5001],[22.7326,77.5394],[22.6854,77.5535],[22.6203,77.5496],[22.4482,77.5711],[22.3973,77.5701],[22.2546,77.5289],[22.0568,77.5012],[21.8562,77.4941],[21.0499,77.441],[20.9281,77.4597],[20.8731,77.5653],[21.2011,77.6195],[21.2515,77.7109],[21.3342,77.7718],[21.4309,77.8121],[21.6084,77.9161],[21.6531,77.9235],[21.2104,78.0058],[21.0354,78.0592],[20.8449,78.1659],[20.7864,78.2521],[20.5283,78.3256],[20.5603,78.4194],[20.3728,78.412],[20.2279,78.4778],[20.3627,78.5148],[21.0469,78.5567],[21.4548,78.5976],[21.6081,78.5957]],[[26.876,78.6489],[26.7295,78.6465],[26.4596,78.7203],[26.4077,78.7843],[26.4558,78.8105],[26.5859,78.8115],[26.7888,78.724],[27.0076,78.6975],[26.876,78.6489]],[[11.2503,78.6107],[11.2617,78.5417],[11.4242,78.5486],[11.6163,78.4751],[11.8257,78.4361],[11.8849,78.4093],[11.9294,78.3749],[12.0562,78.3056],[12.1164,78.2326],[11.965,78.2249],[11.7565,78.329],[11.5865,78.3882],[11.3725,78.4388],[11.1992,78.4413],[11.1213,78.4633],[10.8406,78.6447],[10.7889,78.6865],[10.6284,78.7539],[10.5576,78.8375],[10.5582,78.9029],[10.7729,78.8875],[10.9608,78.8464],[11.1239,78.7534],[11.1529,78.7245],[11.0782,78.686],[11.155,78.6406],[11.2503,78.6107]],[[29.0471,78.9121],[29.3454,78.9058],[29.6451,78.9216],[29.6967,78.9047],[29.3105,78.8521],[28.8812,78.8801],[28.4945,78.8872],[28.0379,78.8287],[27.8891,78.8521],[28.121,78.9084],[28.374,78.9271],[28.4147,78.9614],[28.5111,78.9673],[28.8452,78.9708],[29.0471,78.9121]],[[16.7867,79.9067],[16.8385,79.9048],[16.889,79.9154],[16.9256,79.9435],[16.9664,79.9589],[17.2194,79.9408],[17.5782,79.8847],[17.6848,79.857],[17.8346,79.8],[17.9562,79.7042],[17.8598,79.635],[17.7326,79.5695],[17.6875,79.5333],[17.734,79.4813],[17.715,79.4308],[17.6688,79.3859],[17.861,79.4371],[18.2721,79.6006],[18.3333,79.6107],[18.3974,79.6052],[18.5814,79.5716],[18.7484,79.4882],[18.7853,79.4606],[18.8152,79.4267],[18.8324,79.3848],[18.8229,79.3367],[18.8074,79.3032],[18.72,79.2815],[18.6778,79.2617],[18.7723,79.2603],[18.8801,79.2343],[18.979,79.1792],[19.0895,79.157],[19.4902,79.1757],[19.7509,79.1468],[19.8936,79.0562],[20.1138,79.0767],[20.1145,79.125],[20.1627,79.1457],[20.4582,79.1292],[20.611,79.1066],[20.7672,79.0591],[20.5007,78.9814],[20.7203,78.9067],[21.0896,78.8526],[21.3122,78.7958],[21.3525,78.772],[21.3888,78.7404],[21.2439,78.6994],[21.0963,78.6763],[20.7248,78.6723],[20.387,78.6433],[19.7688,78.6227],[19.6768,78.6096],[19.655,78.5979],[19.6186,78.5622],[19.3807,78.4798],[19.1505,78.3794],[19.0557,78.3189],[18.9838,78.2342],[18.9576,78.1825],[19.0087,78.1323],[18.9951,78.0815],[18.8221,78.0417],[18.7123,78.0401],[18.5746,78.048],[18.4393,78.025],[18.4307,77.9906],[18.4387,77.942],[18.404,77.7939],[18.3619,77.6823],[18.2987,77.5786],[18.2279,77.5226],[18.1374,77.507],[17.8471,77.4968],[17.6233,77.3994],[17.4425,77.2252],[17.3486,77.1569],[17.1525,77.0489],[17.1879,77.0106],[17.249,76.9692],[17.142,76.8949],[16.9767,76.8116],[16.9799,76.7794],[17.0355,76.7204],[17.0627,76.659],[16.9352,76.6062],[16.7005,76.5793],[16.4619,76.6093],[16.3458,76.6448],[16.2381,76.7015],[16.1238,76.7385],[16.0045,76.7607],[15.5468,76.8864],[15.1242,77.0851],[14.7385,77.1624],[14.4869,77.199],[14.3658,77.2345],[14.2476,77.2821],[14.1453,77.3356],[14.0504,77.4032],[14.0042,77.4452],[13.9957,77.5082],[14.0261,77.5452],[14.0713,77.5641],[14.3776,77.5796],[14.4878,77.5708],[14.5963,77.5379],[14.695,77.525],[14.9208,77.6888],[16.206,77.7825],[16.6191,77.7987],[17.0333,77.7977],[16.9688,77.8419],[16.9141,77.898],[16.8529,77.9116],[16.5396,77.8802],[16.0601,77.8471],[15.8264,77.8471],[15.5854,77.8691],[15.3448,77.857],[15.0969,77.809],[14.8469,77.7787],[14.6039,77.7665],[14.0899,77.7714],[13.9625,77.7962],[13.7911,77.8538],[13.7496,77.8833],[13.7142,77.9194],[13.6806,78.0281],[13.7177,78.0576],[13.7701,78.0746],[13.824,78.085],[13.9369,78.0855],[14.0478,78.0668],[14.3072,78.0051],[14.2481,78.0714],[14.9947,78.1512],[15.3414,78.2209],[15.5194,78.2327],[15.698,78.2276],[15.6587,78.2647],[15.6571,78.299],[15.7839,78.3271],[15.8754,78.3391],[16.1503,78.3529],[16.777,78.3504],[17.0029,78.3694],[17.172,78.4171],[16.9918,78.4005],[16.8112,78.3973],[16.7266,78.4072],[16.5354,78.4489],[16.4486,78.5036],[16.6966,78.6129],[16.7826,78.6636],[16.5305,78.6563],[16.4463,78.6385],[16.1575,78.5381],[15.944,78.493],[15.6807,78.4713],[15.4174,78.4732],[15.36,78.4875],[15.2794,78.5541],[15.2542,78.5891],[15.2649,78.6083],[15.3483,78.6631],[15.3916,78.7212],[15.3842,78.7712],[15.3228,78.7812],[15.2253,78.7323],[15.1373,78.6643],[15.0163,78.6301],[14.8918,78.6395],[14.8387,78.6656],[14.7924,78.7056],[14.7436,78.7209],[14.6893,78.7209],[14.5776,78.705],[14.4672,78.6754],[14.5053,78.6305],[14.5154,78.5806],[14.4678,78.5409],[14.4318,78.4925],[14.5456,78.462],[14.6383,78.4146],[14.4995,78.3924],[14.3633,78.3599],[14.2383,78.3099],[14.1104,78.2709],[13.9076,78.2667],[13.655,78.2452],[13.1502,78.2375],[12.9128,78.3011],[12.8695,78.3313],[12.8222,78.3515],[12.6646,78.3848],[12.4348,78.483],[12.2579,78.5947],[12.1383,78.6055],[11.9617,78.6424],[11.8655,78.6742],[11.7738,78.7164],[11.7463,78.7663],[11.7552,78.8117],[11.861,78.8319],[11.611,78.883],[11.3654,78.9504],[11.4562,78.973],[11.5476,78.983],[12.2749,78.9045],[12.3234,78.9143],[12.4033,78.9532],[12.375,78.9664],[12.2531,78.9753],[12.0873,78.9751],[12.0458,78.9832],[11.9818,79.0253],[11.9257,79.0772],[11.902,79.1119],[11.8928,79.1523],[12.0161,79.2131],[12.084,79.2675],[11.9783,79.2927],[11.6793,79.2912],[11.5798,79.2835],[11.6164,79.2053],[11.5212,79.1513],[11.3389,79.1091],[11.2081,79.1296],[11.1072,79.233],[10.9754,79.3049],[10.9258,79.3502],[10.8881,79.4154],[10.8344,79.4628],[10.7376,79.5202],[10.725,79.5555],[10.737,79.5816],[10.8107,79.6409],[10.7546,79.6903],[10.6862,79.7336],[10.6821,79.7583],[10.7464,79.7887],[10.804,79.7988],[10.8659,79.7966],[11.0496,79.7603],[11.1504,79.717],[11.1853,79.7205],[11.2506,79.7849],[11.3437,79.7994],[11.7023,79.8206],[12.1018,79.7375],[12.2052,79.7191],[12.2878,79.7131],[12.2452,79.75],[12.2191,79.7979],[12.28,79.816],[12.6024,79.7732],[12.7535,79.7758],[13.1075,79.8317],[13.6929,79.861],[13.9142,79.8169],[13.9257,79.7934],[13.9211,79.7617],[13.907,79.7522],[13.7775,79.7153],[13.0393,79.6852],[12.5554,79.5695],[13.2151,79.5881],[13.3338,79.5748],[13.3836,79.4808],[13.4316,79.4709],[13.6013,79.4572],[13.7162,79.4292],[13.8337,79.3757],[13.9572,79.3396],[14.0296,79.3441],[14.0559,79.3831],[14.0264,79.4293],[14.0111,79.4819],[14.0198,79.5387],[14.0398,79.5856],[14.1784,79.6187],[14.3798,79.726],[14.5937,79.7987],[14.8318,79.7664],[15.0523,79.6753],[15.2513,79.5455],[15.4439,79.4068],[15.6602,79.2349],[15.7641,79.1743],[15.8585,79.1599],[16.2945,78.9811],[16.3438,78.9761],[16.2535,79.1121],[16.0275,79.3424],[15.8751,79.5192],[15.8407,79.5869],[15.8161,79.6818],[15.8258,79.709],[15.8451,79.7336],[15.9558,79.8351],[16.1002,79.8844],[16.0566,79.954],[16.0938,80.0073],[16.2457,80.0495],[16.3866,80.0526],[16.524,80.0205],[16.7867,79.9067]],[[32.526,80.1191],[31.5776,80.0814],[31.4819,80.1079],[33.0191,80.218],[33.0986,80.2287],[33.384,80.2423],[33.6293,80.2174],[33.5566,80.1981],[32.526,80.1191]],[[18.7416,80.3009],[18.525,80.2456],[18.1622,80.2882],[18.2056,80.3318],[18.2917,80.3583],[18.5193,80.3483],[18.7416,80.3009]],[[20.8979,80.25],[20.9984,80.2388],[21.5492,80.2429],[21.6549,80.2185],[21.6967,80.1592],[21.7807,80.1388],[21.8978,80.1325],[22.1902,80.0597],[22.2897,80.0492],[22.3764,80.0896],[22.4427,80.1903],[22.4462,80.3083],[22.4179,80.3655],[22.4508,80.4022],[22.5488,80.4165],[22.6721,80.4126],[22.7926,80.433],[22.8969,80.469],[23.008,80.474],[23.2514,80.4467],[23.3154,80.4252],[23.2501,80.3809],[23.2246,80.3176],[23.1146,80.187],[23.3533,80.1789],[23.688,80.2065],[23.7729,80.2444],[23.9529,80.3046],[24.143,80.2952],[24.2341,80.3031],[24.2802,80.3293],[24.2976,80.3604],[24.4026,80.3552],[24.5467,80.2952],[24.6137,80.2858],[24.7363,80.3013],[24.7859,80.3007],[24.907,80.2767],[25.4713,80.2331],[25.6669,80.2098],[25.7512,80.188],[25.8363,80.1751],[26.4367,80.1755],[26.8608,80.16],[27.0172,80.1255],[27.1483,80.0592],[27.1986,79.9066],[27.0799,79.8654],[26.2211,79.6774],[26.0059,79.617],[25.9021,79.5614],[25.7264,79.4397],[25.6412,79.403],[25.2391,79.3451],[25.1451,79.3389],[24.8429,79.3672],[24.7506,79.3646],[24.3834,79.3016],[24.2568,79.2635],[24.1329,79.2155],[23.9478,79.1943],[23.7588,79.2056],[22.9037,79.2307],[22.7892,79.2644],[22.6957,79.3291],[22.8655,79.4119],[21.9114,79.3811],[20.8611,79.3979],[20.8056,79.4095],[20.7608,79.4415],[20.3995,79.4634],[20.1282,79.4896],[19.9002,79.5338],[19.6746,79.5912],[19.7467,79.618],[19.8211,79.6336],[20.0148,79.6402],[20.1871,79.6323],[20.4935,79.6328],[20.5648,79.6905],[20.6868,79.7072],[20.7841,79.7486],[20.4607,79.7747],[20.1234,79.7786],[19.8986,79.7442],[19.6381,79.7286],[19.4,79.7266],[18.9421,79.7363],[18.725,79.7607],[18.428,79.8245],[18.3247,79.8597],[18.2848,79.8874],[18.2554,79.9292],[18.5946,79.9667],[18.7265,79.9962],[18.856,80.0366],[18.3438,80.0596],[18.1295,80.0934],[17.9169,80.1431],[18.0895,80.1711],[18.7793,80.1935],[18.9619,80.1748],[19.143,80.1387],[19.3434,80.1164],[19.5371,80.1632],[19.3547,80.1854],[19.1914,80.2632],[19.1569,80.3019],[19.1783,80.3315],[19.2638,80.336],[19.3274,80.3231],[19.5685,80.25],[19.7511,80.2272],[19.8022,80.2947],[19.8104,80.3268],[19.7771,80.3534],[19.6913,80.4023],[19.6144,80.4625],[19.7333,80.4778],[19.8512,80.4712],[20.1043,80.43],[20.3594,80.4009],[20.4759,80.3716],[20.6935,80.2987],[20.8979,80.25]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Norway","sov_a3":"NOR","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Norway","adm0_a3":"NOR","geou_dif":0,"geounit":"Norway","gu_a3":"NOR","su_dif":0,"subunit":"Norway","su_a3":"NOR","brk_diff":0,"name":"Norway","name_long":"Norway","brk_a3":"NOR","brk_name":"Norway","brk_group":"","abbrev":"Nor.","postal":"N","formal_en":"Kingdom of Norway","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Norway","name_alt":"","mapcolor7":5,"mapcolor8":3,"mapcolor9":8,"mapcolor13":12,"pop_est":4676305,"gdp_md_est":276400,"pop_year":-99,"lastcensus":2001,"gdp_year":-99,"economy":"2. Developed region: nonG7","income_grp":"1. High income: OECD","wikipedia":-99,"fips_10":"","iso_a2":"NO","iso_a3":"NOR","iso_n3":"578","un_a3":"578","wb_a2":"NO","wb_a3":"NOR","woe_id":-99,"adm0_a3_is":"NOR","adm0_a3_us":"NOR","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Northern Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":6,"abbrev_len":4,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[88.1098,27.8706],[88.1503,27.8433],[88.1543,27.7987],[88.147,27.7492],[88.1056,27.6424],[88.0679,27.5674],[88.0241,27.4089],[87.9844,27.1339],[87.9932,27.0861],[88.111,26.9285],[88.1572,26.8073],[88.1615,26.7248],[88.1115,26.5864],[88.0549,26.43],[88.027,26.395],[87.9951,26.3824],[87.8492,26.4369],[87.7488,26.4293],[87.6334,26.3991],[87.5131,26.405],[87.4136,26.4229],[87.2874,26.3603],[87.1668,26.3942],[87.0896,26.4332],[87.0379,26.5416],[87.0164,26.5554],[86.7625,26.4419],[86.7014,26.4351],[86.5437,26.496],[86.4145,26.5563],[86.3661,26.5744],[86.2416,26.598],[86.1294,26.6117],[86.0073,26.6494],[85.8557,26.6002],[85.7945,26.6042],[85.7373,26.6397],[85.7074,26.7126],[85.6999,26.7816],[85.6484,26.829],[85.5685,26.8398],[85.4564,26.7972],[85.293,26.741],[85.2402,26.7503],[85.1918,26.7666],[85.1741,26.7815],[85.1516,26.8466],[85.1254,26.861],[85.0873,26.8629],[85.0201,26.8785],[84.9372,26.9269],[84.6854,27.041],[84.6538,27.0917],[84.6548,27.2037],[84.6407,27.2499],[84.6102,27.2987],[84.4809,27.3482],[84.2298,27.4278],[84.091,27.4914],[84.0248,27.4617],[83.8972,27.4351],[83.8288,27.3778],[83.747,27.3959],[83.5517,27.4563],[83.4472,27.4653],[83.384,27.4448],[83.3694,27.4103],[83.2897,27.371],[83.2139,27.4023],[83.0641,27.4445],[82.9328,27.4677],[82.7334,27.519],[82.7108,27.5967],[82.6773,27.6734],[82.6299,27.6871],[82.4514,27.6718],[82.2877,27.7565],[82.1119,27.8649],[82.037,27.9006],[81.9877,27.9138],[81.9452,27.8993],[81.8969,27.8745],[81.8526,27.8671],[81.7572,27.9138],[81.6355,27.9805],[81.486,28.0622],[81.3108,28.1764],[81.239,28.2409],[81.2063,28.2894],[81.1689,28.335],[81.0166,28.4096],[80.8961,28.4686],[80.7508,28.5397],[80.7262,28.5539],[80.6713,28.5962],[80.587,28.6496],[80.5179,28.6652],[80.4958,28.6358],[80.4791,28.6049],[80.4186,28.612],[80.3248,28.6664],[80.2266,28.7233],[80.1496,28.7761],[80.0707,28.8302],[80.0517,28.8703],[80.0846,28.9942],[80.1305,29.1004],[80.1695,29.1243],[80.233,29.1946],[80.256,29.318],[80.2549,29.4233],[80.3169,29.5721],[80.4019,29.7303],[80.549,29.8998],[80.6129,29.9559],[80.6841,29.9943],[80.8199,30.1193],[80.8481,30.1397],[80.9076,30.1719],[80.9661,30.18],[81.0103,30.1645],[81.0556,30.099],[81.1104,30.0368],[81.1771,30.0399],[81.2551,30.0933],[81.4172,30.3376],[81.6419,30.3875],[81.8549,30.3624],[82.0434,30.3268],[82.0989,30.2451],[82.1354,30.159],[82.159,30.1152],[82.2207,30.0639],[82.4865,29.9415],[82.6408,29.8312],[82.8543,29.6834],[83.014,29.6181],[83.1555,29.6126],[83.2352,29.5546],[83.3552,29.4392],[83.4566,29.3063],[83.5835,29.1836],[83.6711,29.1876],[83.7904,29.2274],[83.9359,29.2795],[84.022,29.2539],[84.1014,29.22],[84.1278,29.1563],[84.1756,29.0364],[84.2287,28.9118],[84.3121,28.8681],[84.4107,28.8039],[84.4654,28.7529],[84.6506,28.6596],[84.6768,28.6215],[84.7143,28.5956],[84.7594,28.5792],[84.7969,28.5602],[84.8551,28.5536],[85.0691,28.6097],[85.1264,28.6026],[85.1591,28.5922],[85.1602,28.5719],[85.1215,28.4843],[85.0886,28.3723],[85.1225,28.316],[85.2121,28.2926],[85.4106,28.276],[85.6783,28.2774],[85.7595,28.2207],[85.8402,28.1354],[85.9217,27.9897],[85.9541,27.9282],[85.9945,27.9104],[86.0642,27.9347],[86.0755,27.9946],[86.0787,28.0836],[86.137,28.1144],[86.1742,28.0917],[86.218,28.0221],[86.3286,27.9595],[86.4087,27.9287],[86.485,27.9396],[86.5169,27.9635],[86.5545,28.0852],[86.6145,28.103],[86.6905,28.0949],[86.7196,28.0707],[86.7504,28.0221],[86.8424,27.9992],[86.9338,27.9685],[87.0201,27.9287],[87.1414,27.8383],[87.2907,27.8219],[87.4642,27.8238],[87.5553,27.8218],[87.6226,27.8152],[87.6827,27.8214],[87.8607,27.8861],[87.9334,27.8908],[88.0233,27.8834],[88.1098,27.8706]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":3,"sovereignt":"Nepal","sov_a3":"NPL","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Nepal","adm0_a3":"NPL","geou_dif":0,"geounit":"Nepal","gu_a3":"NPL","su_dif":0,"subunit":"Nepal","su_a3":"NPL","brk_diff":0,"name":"Nepal","name_long":"Nepal","brk_a3":"NPL","brk_name":"Nepal","brk_group":"","abbrev":"Nepal","postal":"NP","formal_en":"Nepal","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Nepal","name_alt":"","mapcolor7":2,"mapcolor8":2,"mapcolor9":3,"mapcolor13":12,"pop_est":28563377,"gdp_md_est":31080,"pop_year":-99,"lastcensus":2001,"gdp_year":-99,"economy":"7. Least developed region","income_grp":"5. Low income","wikipedia":-99,"fips_10":"","iso_a2":"NP","iso_a3":"NPL","iso_n3":"524","un_a3":"524","wb_a2":"NP","wb_a3":"NPL","woe_id":-99,"adm0_a3_is":"NPL","adm0_a3_us":"NPL","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Asia","region_un":"Asia","subregion":"Southern Asia","region_wb":"South Asia","name_len":5,"long_len":5,"abbrev_len":5,"tiny":-99,"homepart":1}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[[83.549,74.0718],[83.4958,74.0484],[83.45,74.0517],[83.4106,74.0396],[83.159,74.0753],[82.8178,74.0916],[82.9029,74.1289],[83.1498,74.1516],[83.5135,74.1224],[83.6184,74.0895],[83.549,74.0718]],[[82.71,74.0909],[82.6128,74.0564],[82.4781,74.0758],[82.3815,74.0992],[82.3294,74.1311],[82.3824,74.1493],[82.5256,74.1614],[82.611,74.1485],[82.689,74.1112],[82.71,74.0909]],[[84.759,74.4594],[84.7104,74.3998],[84.4289,74.4303],[84.3895,74.4544],[84.5403,74.4904],[84.6799,74.5124],[84.8729,74.5155],[84.759,74.4594]],[[86.6531,74.9813],[86.7371,74.963],[87.0006,74.9919],[87.0521,74.9826],[87.1243,74.9399],[87.0117,74.8619],[86.9271,74.8308],[86.692,74.8483],[86.3905,74.8509],[86.2586,74.8935],[86.3307,74.939],[86.5045,74.966],[86.6055,74.9928],[86.6531,74.9813]],[[146.0456,43.4093],[146.0323,43.4071],[146.028,43.4204],[146.0489,43.4336],[146.0886,43.449],[146.1008,43.4402],[146.0863,43.4292],[146.0699,43.4215],[146.0456,43.4093]],[[145.8815,43.4595],[145.8956,43.4545],[145.9139,43.4554],[145.9312,43.457],[145.9411,43.4455],[145.9436,43.4265],[145.9312,43.4256],[145.9072,43.4223],[145.8939,43.4198],[145.8865,43.4331],[145.8815,43.4438],[145.8691,43.4504],[145.8691,43.4579],[145.8815,43.4595]],[[146.3588,43.6254],[146.3323,43.6199],[146.2882,43.6254],[146.2738,43.6298],[146.2837,43.6386],[146.3102,43.6519],[146.3333,43.6475],[146.3498,43.6441],[146.3588,43.6254]],[[142.761,54.3939],[142.9762,54.141],[142.9859,54.0857],[142.9671,54.0288],[142.9266,53.9556],[142.9114,53.8784],[142.9364,53.8109],[142.918,53.7942],[143.0955,53.4887],[143.2236,53.296],[143.26,53.2173],[143.2879,53.1344],[143.3247,52.9631],[143.3326,52.7],[143.3236,52.6136],[143.2951,52.5292],[143.2643,52.4787],[143.201,52.4429],[143.1723,52.3494],[143.1556,52.0837],[143.1906,51.9445],[143.2506,51.8479],[143.2947,51.7443],[143.2995,51.6324],[143.3205,51.5833],[143.4178,51.5206],[143.4555,51.4715],[143.4674,51.4019],[143.4729,51.2992],[143.4888,51.2771],[143.5342,51.2463],[143.736,50.5067],[143.816,50.2826],[144.0479,49.8958],[144.1413,49.6615],[144.1996,49.5498],[144.2399,49.432],[144.2721,49.3113],[144.3412,49.1805],[144.4317,49.0511],[144.6068,48.9358],[144.6855,48.8712],[144.7066,48.8195],[144.7138,48.6403],[144.6727,48.6786],[144.621,48.8148],[144.5363,48.8936],[144.4118,48.9864],[144.2838,49.0698],[144.1255,49.2085],[144.0487,49.2492],[143.9678,49.2763],[143.8191,49.3086],[143.7323,49.312],[143.3822,49.2907],[143.2363,49.2628],[143.105,49.1988],[143.0269,49.1054],[142.9717,48.9178],[142.651,48.2469],[142.5742,48.0722],[142.5459,47.8849],[142.5569,47.7379],[142.579,47.684],[142.6701,47.5369],[142.7454,47.4524],[142.8008,47.4162],[142.864,47.3918],[142.9055,47.3619],[142.9403,47.3228],[143.0056,47.2227],[143.0893,47.0008],[143.1779,46.844],[143.2177,46.7949],[143.3187,46.8074],[143.3844,46.8057],[143.4473,46.792],[143.4856,46.7521],[143.5403,46.5751],[143.5787,46.4061],[143.5807,46.3607],[143.5086,46.2302],[143.4906,46.1746],[143.4823,46.1158],[143.4635,46.0695],[143.4316,46.0287],[143.4187,46.222],[143.3703,46.3585],[143.3521,46.4762],[143.2823,46.559],[143.0479,46.5926],[142.8293,46.6053],[142.7955,46.6202],[142.7474,46.6707],[142.6919,46.7108],[142.6357,46.7162],[142.578,46.7008],[142.4788,46.6442],[142.4064,46.5547],[142.35,46.4587],[142.304,46.3576],[142.2086,46.0889],[142.1497,45.9993],[142.0771,45.917],[142.0156,45.9616],[141.9616,46.0135],[141.93,46.0883],[141.9163,46.1708],[141.8304,46.4511],[141.8665,46.6942],[142.011,47.0303],[142.0387,47.1403],[142.0169,47.2447],[141.9842,47.3477],[141.9625,47.5438],[141.9641,47.5875],[142.0156,47.7006],[142.076,47.8083],[142.1492,47.9021],[142.1817,48.0134],[142.1354,48.2901],[142.0287,48.4771],[141.8973,48.6547],[141.873,48.702],[141.8663,48.7501],[141.9796,48.9722],[142.0201,49.0785],[142.0665,49.3121],[142.1087,49.4396],[142.1423,49.5691],[142.1531,50.2167],[142.1431,50.3121],[142.0711,50.515],[142.066,50.6305],[142.1005,50.7765],[142.1473,50.8902],[142.2079,50.9985],[142.2067,51.2226],[142.0907,51.4294],[142.006,51.5205],[141.8729,51.63],[141.7719,51.6902],[141.7224,51.7363],[141.7719,51.7518],[141.8081,51.7892],[141.721,51.8468],[141.6685,51.9333],[141.6608,52.2729],[141.6824,52.3591],[141.7476,52.4548],[141.8033,52.5556],[141.8556,52.7935],[141.8736,53.0389],[141.8389,53.1385],[141.8235,53.3395],[141.8524,53.3895],[141.9645,53.4564],[142.142,53.4956],[142.1799,53.484],[142.3189,53.4055],[142.3705,53.4025],[142.424,53.4107],[142.5262,53.4475],[142.5835,53.5368],[142.5092,53.5876],[142.5525,53.6526],[142.6796,53.6744],[142.6889,53.7302],[142.6429,53.7368],[142.683,53.816],[142.706,53.8957],[142.6702,53.9684],[142.4666,54.1485],[142.335,54.2807],[142.5517,54.279],[142.6156,54.3036],[142.6662,54.3582],[142.6928,54.4161],[142.761,54.3939]],[[154.8104,49.312],[154.7148,49.2677],[154.6109,49.294],[154.613,49.3806],[154.8249,49.6469],[154.8996,49.6304],[154.8833,49.5664],[154.8023,49.4683],[154.8299,49.3479],[154.8104,49.312]],[[156.4051,50.6576],[156.3654,50.6338],[156.3258,50.6391],[156.1963,50.7021],[156.168,50.7319],[156.2131,50.7847],[156.3765,50.8621],[156.4559,50.8596],[156.4875,50.843],[156.4831,50.7512],[156.4051,50.6576]],[[155.6448,50.8219],[155.5535,50.8106],[155.5128,50.8373],[155.4835,50.8696],[155.4674,50.9136],[155.5686,50.9345],[155.6396,50.9105],[155.6536,50.8454],[155.6448,50.8219]],[[155.9211,50.3022],[155.7924,50.2021],[155.6075,50.1772],[155.5164,50.1456],[155.4489,50.0778],[155.3972,50.0413],[155.2887,50.0612],[155.2431,50.0946],[155.2431,50.2128],[155.1951,50.2646],[155.2184,50.2979],[155.3268,50.2933],[155.4339,50.3689],[155.6802,50.4007],[155.7728,50.4824],[155.8848,50.6841],[156.0017,50.7569],[156.0969,50.7719],[156.1229,50.6713],[156.1006,50.5593],[156.0444,50.4518],[155.9211,50.3022]],[[146.714,43.7438],[146.683,43.7164],[146.6086,43.7405],[146.6135,43.797],[146.622,43.813],[146.8246,43.8605],[146.8841,43.8292],[146.899,43.8042],[146.714,43.7438]],[[149.6877,45.642],[149.5389,45.5914],[149.4471,45.5934],[149.6659,45.8398],[149.7963,45.8761],[149.9623,46.0219],[150.3088,46.2003],[150.3486,46.2134],[150.5531,46.2085],[150.2346,46.0123],[150.195,45.9332],[150.0566,45.8494],[149.9541,45.8225],[149.8834,45.7832],[149.6877,45.642]],[[152.0021,46.8972],[151.8156,46.7871],[151.7541,46.7883],[151.7234,46.8288],[151.7153,46.8527],[151.8644,46.869],[152.0398,47.015],[152.1658,47.1104],[152.2347,47.1434],[152.2889,47.1422],[152.0021,46.8972]],[[153.1011,47.7629],[153.0538,47.7061],[153.0041,47.7135],[152.9843,47.7279],[153.0491,47.797],[153.0792,47.8087],[153.1011,47.7629]],[[154.0813,48.7903],[154.043,48.7388],[154.0007,48.7557],[153.9923,48.7725],[154.0917,48.8321],[154.1264,48.9044],[154.199,48.9049],[154.2284,48.8921],[154.2047,48.8572],[154.0813,48.7903]],[[146.2076,44.4977],[146.356,44.4246],[146.5678,44.4404],[146.5162,44.3747],[146.4365,44.3757],[146.2962,44.281],[146.1729,44.2687],[146.1123,44.2459],[145.9141,44.1037],[145.8873,44.0478],[145.767,43.9407],[145.5868,43.8451],[145.5559,43.6646],[145.4393,43.7371],[145.4262,43.8104],[145.4617,43.8709],[145.6663,43.9991],[145.7483,44.0715],[145.7733,44.129],[145.852,44.193],[145.8902,44.2486],[145.9404,44.2727],[146.1121,44.5001],[146.2076,44.4977]],[[148.5995,45.3176],[148.4146,45.2472],[148.2623,45.2168],[148.0053,45.0702],[147.9138,44.9904],[147.7841,44.9586],[147.6578,44.9771],[147.6219,44.9447],[147.6096,44.8866],[147.5631,44.8355],[147.3102,44.6776],[147.2074,44.5536],[147.0984,44.5313],[146.8975,44.4043],[146.9335,44.5131],[146.9742,44.5657],[147.1409,44.6633],[147.1548,44.7662],[147.2466,44.8561],[147.4305,44.9452],[147.5578,45.0625],[147.6579,45.093],[147.7694,45.1907],[147.8855,45.2256],[147.8727,45.3003],[147.924,45.3833],[147.9646,45.3777],[148.0561,45.2621],[148.1301,45.2582],[148.3242,45.2824],[148.6123,45.4847],[148.7066,45.5207],[148.7727,45.5265],[148.8122,45.51],[148.8262,45.4861],[148.8254,45.4559],[148.803,45.4135],[148.8371,45.3627],[148.7907,45.324],[148.5995,45.3176]],[[107.6955,78.1309],[107.6063,78.0826],[107.4816,78.0578],[107.3438,78.0986],[107.0017,78.0957],[106.4155,78.1398],[106.5833,78.1676],[107.5083,78.1894],[107.5732,78.1855],[107.6955,78.1309]],[[106.2704,78.2062],[106.1511,78.1986],[106.0236,78.2201],[106.0584,78.2646],[106.3506,78.2726],[106.4568,78.34],[106.6404,78.3362],[106.6912,78.3167],[106.7196,78.2942],[106.7189,78.265],[106.6791,78.265],[106.5047,78.2617],[106.4725,78.245],[106.2704,78.2062]],[[100.1359,79.6142],[99.9154,79.6016],[99.9423,79.6714],[99.9558,79.6903],[100.0684,79.701],[100.1415,79.6837],[100.3003,79.6703],[100.1359,79.6142]],[[91.5672,81.1412],[91.2229,81.0638],[89.9758,81.1131],[89.9194,81.1487],[89.9012,81.1707],[90.0699,81.2137],[91.109,81.1991],[91.4778,81.1839],[91.5672,81.1412]],[[97.6745,80.1583],[97.9036,80.095],[98.0178,80.0229],[97.9067,80.0038],[97.8079,79.9563],[97.76,79.8958],[97.627,79.8504],[97.5913,79.775],[97.6517,79.7606],[97.7245,79.7814],[97.8707,79.8526],[98.0646,79.9011],[98.2732,79.8741],[98.3531,79.8843],[98.499,79.9531],[98.4719,80.0091],[98.5318,80.0436],[98.5965,80.0522],[98.8659,80.0454],[99.2949,80.0164],[99.3707,79.9864],[99.473,79.9702],[99.5361,79.9413],[99.7266,79.9199],[99.8184,79.8982],[99.9466,79.849],[100.0612,79.7771],[99.9158,79.7383],[99.8393,79.6689],[99.8055,79.6531],[99.7816,79.6283],[99.7711,79.5677],[99.7488,79.5152],[99.7212,79.4918],[99.7063,79.4635],[99.7216,79.3851],[99.6807,79.3233],[99.5373,79.2766],[99.3878,79.2748],[99.1671,79.3063],[99.1044,79.3054],[99.0418,79.293],[99.3174,79.2272],[99.5173,79.1302],[99.7508,79.1077],[99.8146,79.0958],[99.8996,79.0064],[99.9293,78.9614],[99.5408,78.8527],[99.4396,78.8342],[98.8195,78.8183],[98.4111,78.7878],[98.2825,78.795],[98.0542,78.821],[97.9052,78.8102],[97.6886,78.8273],[97.5555,78.8266],[97.2481,78.868],[96.9329,78.9339],[96.8712,78.9638],[96.8078,78.985],[96.43,79.003],[96.3474,79.0159],[95.7965,79.0014],[95.7028,79.012],[95.5311,79.0981],[95.4369,79.0993],[95.1332,79.0496],[95.0204,79.0527],[94.791,79.0866],[94.6523,79.1275],[94.6316,79.1409],[94.6197,79.1924],[94.4821,79.2186],[94.3138,79.3075],[94.2187,79.4023],[93.7586,79.4514],[93.4787,79.4627],[93.2723,79.4584],[93.0708,79.4953],[93.4047,79.6316],[93.8473,79.7017],[94.0382,79.756],[94.2571,79.8297],[94.3473,79.9419],[94.7194,80.0112],[94.815,80.0348],[94.9468,80.0893],[94.9873,80.0968],[95.2813,80.0305],[95.338,80.0421],[95.3907,80.0728],[95.4976,80.1056],[95.8578,80.11],[96.1625,80.0968],[96.2773,80.1101],[96.4166,80.1043],[97.1205,80.153],[97.5868,80.1683],[97.6745,80.1583]],[[92.6835,79.6852],[92.4406,79.6755],[92.1537,79.6847],[91.6836,79.7906],[91.3763,79.8355],[91.1261,79.9049],[91.0703,79.9815],[91.2293,80.0307],[91.426,80.0492],[91.752,80.0523],[92.1734,80.0455],[92.5928,79.9965],[93.4815,79.9411],[93.8031,79.9045],[93.6035,79.8167],[93.382,79.7839],[93.1551,79.7376],[92.9263,79.7045],[92.6835,79.6852]],[[96.5266,81.0756],[96.5631,81.0301],[96.6933,80.9942],[96.755,80.9579],[97.4137,80.8418],[97.703,80.8267],[97.8318,80.7983],[97.8699,80.7633],[97.8564,80.6981],[97.7472,80.6987],[97.6654,80.6781],[97.2214,80.6524],[97.1131,80.6141],[97.0254,80.5355],[97.0726,80.5199],[97.115,80.4966],[97.2502,80.363],[97.2868,80.3425],[97.417,80.3231],[97.2984,80.2728],[97.1752,80.241],[95.8558,80.177],[94.9613,80.1504],[94.6612,80.1228],[94.565,80.1261],[94.3284,80.076],[93.8724,80.0101],[93.6547,80.0096],[93.0023,80.1021],[92.2016,80.1793],[92.0922,80.2233],[91.8916,80.2493],[91.6374,80.2699],[91.5238,80.3585],[91.6878,80.4185],[91.8967,80.4775],[92.2467,80.4991],[92.5779,80.5333],[92.8268,80.6186],[92.9811,80.703],[93.2625,80.7913],[92.7729,80.7687],[92.5926,80.7809],[92.6102,80.81],[92.7104,80.8722],[92.7646,80.8931],[92.9387,80.9258],[93.0651,80.9885],[93.3587,81.0317],[93.4974,81.0392],[93.6367,81.0381],[93.8889,81.0584],[94.1401,81.0895],[94.3755,81.1074],[94.6116,81.1146],[94.8379,81.1394],[95.0609,81.1881],[95.1596,81.271],[95.8007,81.2805],[95.902,81.2606],[95.984,81.2114],[96.0752,81.1928],[96.1869,81.1839],[96.4711,81.0993],[96.5266,81.0756]],[[102.8848,79.254],[102.7873,79.1764],[102.7458,79.1061],[102.4479,78.8767],[102.4123,78.8354],[102.5873,78.8713],[102.7477,78.9496],[102.8448,79.0144],[102.9504,79.0558],[103.0757,79.0565],[103.1991,79.0713],[103.4334,79.1261],[103.6729,79.15],[103.8008,79.1493],[103.9257,79.1232],[104.004,79.0625],[104.0911,79.0132],[104.4042,78.9771],[104.4492,78.9639],[104.477,78.9233],[104.4521,78.88],[104.6332,78.8352],[104.8811,78.8549],[105.0146,78.8433],[105.146,78.8188],[105.2046,78.7799],[105.2561,78.733],[105.3102,78.6662],[105.3427,78.5939],[105.3126,78.4999],[104.8326,78.3527],[104.7418,78.3397],[104.5194,78.3492],[104.2975,78.3351],[103.7193,78.2583],[103.0031,78.2559],[102.7967,78.1879],[102.7344,78.1899],[102.6731,78.2017],[102.6172,78.2246],[102.1805,78.2053],[101.6924,78.1943],[101.2041,78.1919],[101.0399,78.143],[100.5412,78.0475],[100.0822,77.975],[99.845,77.9568],[99.5003,77.9761],[99.3917,78.0007],[99.2871,78.0381],[99.4387,78.0839],[99.5456,78.1786],[99.6779,78.2335],[100.0189,78.3389],[100.0575,78.3804],[100.1235,78.4705],[100.163,78.504],[100.215,78.5358],[100.2572,78.5738],[100.2627,78.6315],[100.284,78.6792],[100.4164,78.7532],[100.5156,78.7878],[100.6196,78.7974],[100.8756,78.7836],[100.9558,78.7885],[100.8979,78.8125],[100.8563,78.8978],[100.8646,78.9258],[100.9014,78.9801],[100.9654,79.0065],[101.0309,79.0233],[101.0682,79.0962],[101.0522,79.1232],[101.1488,79.1569],[101.1961,79.2044],[101.3104,79.2326],[101.5431,79.2544],[101.5553,79.3126],[101.5906,79.3504],[101.6434,79.3614],[101.7613,79.372],[101.8242,79.3702],[101.9121,79.3116],[102.0053,79.2637],[102.1285,79.2525],[102.2513,79.2561],[102.1772,79.3126],[102.1807,79.3734],[102.2251,79.4129],[102.2824,79.4301],[102.4049,79.4332],[102.7898,79.3921],[103.0416,79.3315],[103.0979,79.2991],[103.0524,79.2825],[102.9396,79.2712],[102.8848,79.254]],[[137.1786,55.1004],[137.0553,54.9268],[136.9694,54.924],[136.9027,54.9606],[136.7651,54.946],[136.7146,54.9562],[136.7953,55.0094],[136.9957,55.0927],[137.0775,55.0917],[137.1561,55.1078],[137.1786,55.1004]],[[137.9599,71.5077],[137.7118,71.4232],[137.6129,71.4339],[137.5118,71.4746],[137.4578,71.4835],[137.4032,71.4773],[137.3442,71.4605],[137.2655,71.4559],[137.0787,71.5022],[137.0641,71.5299],[137.0818,71.5427],[137.1295,71.5562],[137.1682,71.5571],[137.2818,71.5799],[137.8168,71.5879],[137.8576,71.5831],[137.9338,71.5428],[137.9599,71.5077]],[[142.1849,73.8959],[142.4351,73.8516],[142.6392,73.8031],[143.3437,73.5688],[143.4107,73.5208],[143.464,73.4589],[143.4913,73.2464],[143.4515,73.2313],[143.1933,73.2208],[142.8416,73.2448],[142.5869,73.2533],[142.3422,73.2529],[142.1264,73.2817],[141.5967,73.3108],[141.1827,73.3892],[140.754,73.446],[140.6628,73.452],[140.3925,73.4354],[140.027,73.3614],[139.9251,73.3552],[139.7855,73.3552],[139.6855,73.4257],[139.9201,73.4486],[140.1552,73.4575],[140.3807,73.483],[140.5936,73.5646],[140.6975,73.6292],[140.8838,73.7775],[140.9836,73.8315],[141.0848,73.8659],[141.1899,73.8765],[141.3119,73.8719],[141.6819,73.9042],[141.9318,73.9149],[142.1849,73.8959]],[[136.1975,73.9136],[136.1217,73.885],[136.0515,73.9291],[135.7146,74.0595],[135.6334,74.1214],[135.4486,74.1797],[135.4024,74.2017],[135.387,74.2534],[135.6283,74.2199],[136.0368,74.0903],[136.2592,73.985],[136.1975,73.9136]],[[141.0103,73.9995],[140.5072,73.9187],[140.4095,73.9217],[140.1832,74.0046],[140.1016,74.1843],[140.1936,74.2367],[140.3003,74.2572],[140.4074,74.2665],[140.8492,74.2738],[140.9443,74.2646],[141.0386,74.2427],[141.0795,74.2093],[141.0975,74.1678],[141.0469,74.0504],[141.0103,73.9995]],[[113.3872,74.4004],[113.3531,74.353],[113.2992,74.3171],[113.2589,74.2727],[113.1902,74.2393],[112.9776,74.1968],[112.8113,74.1029],[112.7824,74.0951],[112.1958,74.1462],[112.1051,74.1632],[111.9121,74.2192],[111.643,74.2729],[111.5034,74.3531],[111.5701,74.3683],[111.6375,74.3743],[111.8798,74.3638],[111.9492,74.3888],[111.9828,74.4563],[111.9894,74.4962],[112.0076,74.5268],[112.0845,74.549],[112.9518,74.4796],[113.2862,74.441],[113.3872,74.4004]],[[140.0487,75.829],[140.1521,75.8098],[140.2744,75.8224],[140.3891,75.7958],[140.4963,75.6898],[140.5467,75.6632],[140.6021,75.6439],[140.6567,75.6341],[140.8159,75.6307],[140.8893,75.652],[140.9441,75.7005],[140.9404,75.7495],[140.9266,75.7989],[140.9258,75.8668],[140.9503,75.9273],[140.9854,75.9645],[141.0326,75.989],[141.2993,76.0638],[141.4854,76.1372],[141.7423,76.1081],[142.0015,76.0436],[142.4604,75.9036],[142.6695,75.8634],[142.9268,75.8269],[143.1852,75.8136],[143.3111,75.8223],[143.56,75.8604],[143.6858,75.8637],[145.2553,75.5856],[145.3098,75.5641],[145.36,75.5305],[145.0234,75.4897],[144.8031,75.4161],[144.7268,75.3656],[144.8143,75.3245],[144.8835,75.2689],[144.4078,75.1023],[144.216,75.0592],[144.0197,75.0447],[143.6259,75.084],[143.3961,75.0829],[143.1703,75.1169],[142.9221,75.2174],[142.8201,75.2678],[142.7295,75.3376],[142.6996,75.4489],[142.7345,75.5446],[142.8676,75.5718],[142.986,75.6333],[143.0024,75.6599],[142.9418,75.7133],[142.5516,75.7209],[142.3079,75.6917],[142.0862,75.6606],[142.1511,75.4576],[142.1988,75.3927],[142.2647,75.3461],[142.6168,75.1333],[142.697,75.1031],[142.9297,75.0624],[143.1279,74.9703],[142.7782,74.8678],[142.6261,74.8374],[142.4728,74.8204],[142.3784,74.8286],[142.2874,74.8499],[142.1842,74.8996],[142.1,74.951],[141.9873,74.9913],[141.7484,74.9826],[141.53,74.9472],[141.3104,74.9232],[140.6607,74.8818],[140.4639,74.8561],[140.2679,74.8469],[140.011,74.8948],[139.7582,74.9638],[139.6813,74.9641],[139.6059,74.9456],[139.548,74.9041],[139.5123,74.8378],[139.4301,74.7492],[139.3256,74.6868],[139.2153,74.6597],[139.0991,74.6565],[138.9817,74.6737],[138.8656,74.7009],[138.0923,74.7975],[138.0014,74.827],[137.915,74.8708],[137.683,75.0085],[137.5681,75.0406],[137.447,75.0542],[137.218,75.1237],[137.0063,75.235],[136.9623,75.2704],[136.9477,75.3255],[136.9824,75.3653],[137.166,75.3466],[137.2897,75.3486],[137.2152,75.5544],[137.2688,75.7494],[137.3585,75.7816],[137.7065,75.7596],[137.5936,75.8234],[137.5012,75.9097],[137.5605,75.9552],[137.6254,75.9882],[137.7744,76.0157],[137.9771,76.0278],[138.0387,76.0473],[138.096,76.0805],[138.2076,76.1149],[138.4307,76.1301],[138.814,76.1997],[138.9195,76.1967],[139.0176,76.1601],[139.1092,76.1083],[139.2113,76.0807],[139.5285,76.0134],[139.7434,75.9531],[140.0487,75.829]],[[135.9486,75.4096],[135.7459,75.382],[135.452,75.3896],[135.473,75.4632],[135.5234,75.4958],[135.5927,75.5765],[135.5612,75.6365],[135.5784,75.71],[135.6139,75.7663],[135.6986,75.8453],[135.7883,75.7985],[135.8492,75.7292],[135.9048,75.6944],[136.1273,75.6256],[136.1689,75.6056],[135.9834,75.5219],[135.9651,75.4861],[136.0205,75.4384],[135.9486,75.4096]],[[96.5324,76.2781],[96.614,76.2638],[96.5896,76.2212],[96.4867,76.2337],[96.3508,76.2122],[96.3534,76.1775],[96.3006,76.1217],[96.1088,76.1555],[95.8445,76.1603],[95.6786,76.1937],[95.3111,76.2147],[95.3221,76.2616],[95.3799,76.2891],[95.5944,76.2496],[95.7862,76.2939],[96.151,76.2719],[96.2707,76.3054],[96.5324,76.2781]],[[96.8539,76.1992],[96.7979,76.1884],[96.7545,76.1958],[96.7394,76.2069],[96.7402,76.2579],[96.8329,76.3242],[96.8353,76.3448],[96.8779,76.3552],[96.9902,76.3434],[97.0453,76.3154],[97.053,76.3026],[96.9742,76.2365],[96.8539,76.1992]],[[97.5884,76.5994],[97.5353,76.5844],[97.4304,76.5907],[97.3417,76.6289],[97.3104,76.6896],[97.3816,76.7067],[97.5884,76.5994]],[[137.9405,55.0926],[138.0313,55.0533],[138.1721,55.0601],[138.2062,55.0335],[138.0965,54.9909],[138.0166,54.9009],[137.9912,54.8207],[137.9595,54.789],[137.8701,54.7496],[137.7902,54.6969],[137.7215,54.6632],[137.6611,54.6533],[137.5256,54.8258],[137.4627,54.8734],[137.2761,54.7924],[137.2329,54.7906],[137.2752,54.891],[137.3844,55.0007],[137.4355,55.016],[137.5437,55.1631],[137.5773,55.197],[137.9104,55.1101],[137.9405,55.0926]],[[168.0391,54.565],[168.0813,54.5127],[167.6773,54.6977],[167.4881,54.795],[167.4415,54.8559],[167.5117,54.8569],[167.5925,54.7978],[167.7106,54.7702],[167.8826,54.6905],[168.0391,54.565]],[[166.6503,54.8391],[166.6451,54.6941],[166.5213,54.7676],[166.4637,54.8269],[166.3817,54.8381],[166.3248,54.8646],[166.2299,54.9365],[166.1197,55.0304],[166.0823,55.0766],[166.0663,55.1357],[165.9919,55.1905],[165.7511,55.2945],[165.8305,55.3069],[165.9313,55.3515],[166.2119,55.324],[166.2758,55.312],[166.23,55.2423],[166.248,55.1654],[166.4043,55.0056],[166.4795,54.9499],[166.5773,54.9077],[166.6503,54.8391]],[[161.4671,68.901],[161.4225,68.8997],[161.4563,68.966],[161.4611,68.9956],[161.3641,69.0444],[161.1825,69.0816],[161.1365,69.1103],[161.1255,69.197],[161.1646,69.3336],[161.0828,69.4057],[161.1107,69.4698],[161.3233,69.5409],[161.4098,69.5957],[161.5052,69.6395],[161.5207,69.634],[161.6178,69.5924],[161.6093,69.5009],[161.5403,69.4365],[161.3744,69.4137],[161.3509,69.3693],[161.3727,69.2928],[161.3775,69.1944],[161.3942,69.1064],[161.4947,69.016],[161.517,68.9696],[161.5067,68.9276],[161.4671,68.901]],[[169.2008,69.5805],[168.9157,69.5714],[168.348,69.6644],[168.1443,69.7133],[167.9927,69.7758],[167.8213,69.8196],[167.7889,69.8369],[167.814,69.873],[167.8647,69.9011],[168.0596,69.9749],[168.1963,70.0084],[168.3579,70.0157],[169.3748,69.8826],[169.4207,69.8561],[169.4336,69.8322],[169.4182,69.7792],[169.3324,69.7696],[169.2991,69.7348],[169.2634,69.6287],[169.2458,69.6011],[169.2008,69.5805]],[[160.7189,70.8227],[160.6514,70.8059],[160.5048,70.8197],[160.4369,70.851],[160.4404,70.9227],[160.4485,70.934],[160.5658,70.9238],[160.6449,70.8835],[160.7189,70.8227]],[[178.8615,70.8264],[178.7926,70.8221],[178.6482,71.0006],[178.6283,71.0474],[178.6839,71.1057],[178.829,71.1779],[178.8911,71.2311],[179.2351,71.3245],[179.5477,71.4477],[179.7159,71.4662],[179.8864,71.5233],[180,71.5377],[180,70.993],[179.8813,70.9757],[179.6477,70.8989],[179.1525,70.8803],[178.8615,70.8264]],[[146.7952,75.3708],[147.0604,75.3643],[147.4436,75.438],[147.497,75.4405],[148.4324,75.4135],[148.5089,75.3875],[148.5188,75.3365],[148.4892,75.3094],[148.475,75.2724],[148.5901,75.2364],[148.8922,75.2281],[149.0832,75.2621],[149.6453,75.2446],[150.1039,75.2192],[150.2807,75.164],[150.4172,75.1343],[150.5306,75.0999],[150.6129,75.1202],[150.6903,75.1553],[150.7569,75.1624],[150.8224,75.1565],[150.6463,74.9446],[150.5803,74.9189],[150.3313,74.8668],[149.8381,74.7953],[149.5969,74.7726],[149.0502,74.7725],[148.2969,74.8004],[148.0924,74.8257],[147.9719,74.8573],[147.7409,74.932],[147.6269,74.9589],[147.257,74.9843],[147.144,74.9984],[146.9249,75.0625],[146.7033,75.1142],[146.1485,75.1983],[146.1861,75.2956],[146.2576,75.3938],[146.343,75.4809],[146.4385,75.5582],[146.5375,75.5818],[146.751,75.5104],[146.7482,75.4287],[146.7952,75.3708]],[[152.8859,76.1217],[152.7863,76.0858],[152.5586,76.1436],[152.6428,76.1748],[152.7994,76.1948],[152.8351,76.1852],[152.8638,76.1634],[152.8859,76.1217]],[[149.1502,76.6599],[148.3986,76.6482],[148.4481,76.677],[148.7196,76.7466],[149.4064,76.7821],[149.2684,76.7472],[149.2048,76.677],[149.1502,76.6599]],[[112.478,76.6209],[112.6325,76.553],[112.6608,76.5096],[112.6142,76.4993],[112.5865,76.483],[112.5748,76.4524],[112.5316,76.45],[112.3948,76.4838],[112.2969,76.538],[112.1538,76.5493],[112.0027,76.603],[111.9689,76.6262],[112.0111,76.6329],[112.2814,76.6184],[112.3941,76.6438],[112.478,76.6209]],[[96.2854,77.0267],[96.2535,77.0073],[96.2099,76.9921],[96.0914,77.0025],[95.8547,76.975],[95.7658,76.9906],[95.6809,77.0213],[95.3641,77.0115],[95.2703,77.0188],[95.4207,77.0565],[95.8541,77.0976],[96.5284,77.2055],[96.5619,77.1541],[96.5613,77.1296],[96.4243,77.0712],[96.2854,77.0267]],[[89.5143,77.1888],[89.2995,77.184],[89.1793,77.2099],[89.1417,77.2268],[89.2005,77.272],[89.2815,77.3015],[89.6162,77.311],[89.6796,77.2803],[89.6658,77.2545],[89.5143,77.1888]],[[107.4147,77.2427],[107.3022,77.2415],[107.2695,77.289],[107.3664,77.3466],[107.4864,77.3471],[107.5937,77.33],[107.6293,77.3197],[107.6646,77.2998],[107.6795,77.2683],[107.4147,77.2427]],[[20.6777,54.9557],[20.774,54.947],[20.8875,54.9095],[20.9959,54.9027],[21.1889,54.9352],[21.2229,55.1078],[21.2357,55.2641],[21.2976,55.2645],[21.3893,55.2755],[21.4471,55.2344],[21.5547,55.1953],[21.6827,55.1604],[21.8739,55.1007],[22.0724,55.0637],[22.1379,55.0594],[22.3464,55.0643],[22.5673,55.0591],[22.6274,54.9707],[22.7365,54.9289],[22.8247,54.8713],[22.8313,54.8385],[22.7097,54.6326],[22.6845,54.5629],[22.6799,54.493],[22.7243,54.4056],[22.7662,54.3568],[22.7318,54.3501],[22.1685,54.3599],[21.6342,54.3765],[21.1405,54.3918],[20.6647,54.4066],[20.2082,54.4208],[19.9243,54.434],[19.6442,54.4471],[19.6044,54.4592],[19.7585,54.5448],[19.8589,54.6338],[19.9441,54.75],[19.9532,54.8305],[19.9745,54.9212],[20.1076,54.9565],[20.3967,54.9513],[20.5203,54.9949],[20.6789,55.1026],[20.8457,55.232],[20.8998,55.2867],[20.9578,55.2789],[20.8594,55.1836],[20.5948,54.9824],[20.6777,54.9557]],[[63.651,81.6093],[63.5285,81.5966],[62.885,81.6089],[62.573,81.6331],[62.5313,81.647],[62.5152,81.6591],[62.1064,81.6793],[62.284,81.7065],[62.7949,81.7189],[63.7096,81.6873],[63.7674,81.6642],[63.7824,81.6498],[63.651,81.6093]],[[58.2954,81.7152],[57.9648,81.6957],[57.9206,81.7105],[57.9093,81.7219],[57.9451,81.7479],[57.985,81.797],[58.1346,81.828],[59.2618,81.8542],[59.4085,81.8254],[59.3568,81.781],[59.3564,81.759],[58.2954,81.7152]],[[59.3131,81.3052],[59.097,81.2923],[58.719,81.3135],[58.6102,81.3373],[58.6345,81.3604],[58.8806,81.3918],[59.075,81.3977],[59.2809,81.3661],[59.3746,81.325],[59.3131,81.3052]],[[104.8143,77.6521],[104.9652,77.5947],[105.309,77.5492],[105.7103,77.5252],[105.8945,77.4889],[105.9834,77.4476],[106.0596,77.3905],[105.7342,77.352],[105.3846,77.2378],[104.9119,77.1747],[104.3236,77.1327],[104.2024,77.1018],[105.3202,77.0923],[105.6459,77.1007],[105.712,77.0015],[105.8222,76.9975],[106.1454,77.0453],[106.3387,77.0479],[106.7051,77.0138],[106.7837,77.0318],[106.9416,77.0344],[107.2789,76.991],[107.4298,76.9266],[107.1902,76.822],[106.9409,76.7305],[106.6388,76.5734],[106.5455,76.5863],[106.3847,76.5895],[106.4136,76.5123],[106.6832,76.5147],[106.8254,76.4801],[107.1577,76.5241],[107.6242,76.5101],[107.7222,76.5223],[107.9022,76.5697],[107.9499,76.6606],[108.0279,76.7185],[108.1816,76.7378],[108.3521,76.7195],[108.6384,76.7201],[109.3693,76.7492],[109.9812,76.7119],[110.4715,76.7584],[111.1148,76.723],[111.3925,76.6867],[111.6006,76.6223],[111.7861,76.6036],[111.9387,76.5534],[112.0939,76.4803],[112.0168,76.4206],[111.9427,76.3805],[112.1428,76.424],[112.2971,76.4347],[112.4133,76.4083],[112.6195,76.3835],[112.6842,76.2188],[112.7426,76.1869],[112.7984,76.1296],[112.7219,76.0772],[112.6563,76.0536],[112.8189,76.0586],[113.0467,76.1141],[113.094,76.1329],[113.1504,76.1745],[113.066,76.2152],[112.988,76.2397],[113.086,76.2581],[113.2727,76.2517],[113.3655,76.1789],[113.4277,76.1121],[113.5639,75.8917],[113.8572,75.9213],[113.871,75.856],[113.7487,75.7048],[113.6199,75.5927],[113.5676,75.5684],[113.4859,75.564],[113.5172,75.6219],[113.469,75.6567],[113.3916,75.6779],[113.1264,75.6987],[112.6292,75.8354],[112.4967,75.8499],[112.4661,75.8437],[112.453,75.8302],[112.7296,75.7376],[112.9557,75.5719],[113.1615,75.6205],[113.243,75.6114],[113.3563,75.5343],[113.5589,75.5021],[113.7262,75.4506],[113.6136,75.293],[112.9249,75.015],[112.192,74.8532],[111.8683,74.74],[111.299,74.6584],[110.8928,74.5481],[110.3735,74.4661],[110.2259,74.3787],[109.8403,74.322],[109.8664,74.2931],[109.9113,74.2613],[109.8639,74.2089],[109.8103,74.1692],[109.5108,74.0888],[109.075,74.0323],[108.1995,73.6941],[107.7654,73.625],[107.2711,73.621],[107.167,73.5894],[106.7942,73.3767],[106.6794,73.3307],[106.1887,73.308],[105.6771,72.9593],[105.3928,72.841],[105.1439,72.7771],[105.4027,72.7899],[105.7082,72.8367],[106.0667,72.9499],[106.1596,73.002],[106.2088,73.0605],[106.315,73.1064],[106.4779,73.1394],[107.1088,73.1773],[107.3688,73.1631],[107.7504,73.1731],[108.0013,73.2356],[108.151,73.2579],[108.2854,73.2659],[108.3515,73.3102],[108.5754,73.319],[109.0899,73.3784],[109.1656,73.3996],[109.3311,73.4875],[109.6371,73.454],[109.8553,73.4725],[110.4287,73.6289],[110.7733,73.6892],[110.8682,73.7307],[110.7992,73.7598],[110.7224,73.7799],[110.3883,73.726],[110.0912,73.7085],[109.7527,73.7226],[109.7067,73.7438],[109.6656,73.8002],[109.7741,73.8813],[109.8691,73.9306],[110.0839,73.9944],[110.2614,74.0174],[110.9201,73.9479],[111.0563,73.9394],[111.1309,74.0528],[111.3414,74.0474],[111.5506,74.0285],[111.46,74.0048],[111.2281,73.9686],[111.2995,73.8849],[111.4004,73.8277],[111.8037,73.7453],[112.1473,73.7089],[112.4,73.7111],[112.7954,73.7461],[112.856,73.7711],[112.9396,73.8356],[112.8359,73.9621],[112.935,73.9457],[113.0328,73.9139],[113.1815,73.8374],[113.3269,73.7074],[113.4162,73.6476],[113.3645,73.5828],[113.1569,73.4596],[113.277,73.3915],[113.4909,73.3461],[113.4876,73.1451],[113.4746,73.0479],[113.3693,72.9419],[113.2474,72.8972],[113.1278,72.8307],[113.1582,72.7695],[113.1861,72.7302],[113.3122,72.6574],[113.6646,72.6345],[113.7119,72.6542],[113.6301,72.6771],[113.3914,72.711],[113.2981,72.7389],[113.2155,72.8059],[113.3115,72.8783],[113.4175,72.9322],[113.5428,73.0543],[113.5814,73.1422],[113.5589,73.2326],[113.6392,73.2736],[113.7652,73.318],[113.8293,73.3266],[113.8862,73.3458],[113.7951,73.3674],[113.7113,73.3786],[113.5395,73.4336],[113.5104,73.505],[113.8569,73.5334],[114.0605,73.5847],[114.816,73.6072],[115.3377,73.7026],[116.4955,73.6761],[117.3086,73.5992],[118.4502,73.5898],[118.8709,73.5379],[118.9112,73.5184],[118.9364,73.4812],[118.7545,73.4645],[118.457,73.4644],[118.3766,73.3672],[118.4303,73.2465],[118.9604,73.1173],[119.4253,73.064],[119.7504,72.9791],[119.9217,72.9713],[120.5979,72.9811],[120.9972,72.9367],[121.3543,72.9708],[121.7479,72.9697],[121.886,72.9609],[122.0298,72.8972],[122.2602,72.8806],[122.5375,72.8778],[122.6921,72.8908],[122.752,72.9065],[122.7309,72.9313],[122.502,72.9707],[122.5268,73.0167],[122.6152,73.0279],[122.9993,72.9646],[123.1604,72.9549],[123.3012,73.0018],[123.4046,73.0856],[123.4616,73.1442],[123.5219,73.1729],[123.5725,73.1773],[123.6223,73.1933],[123.501,73.2616],[123.3839,73.3473],[123.3553,73.4025],[123.3227,73.4308],[123.3051,73.5329],[123.4162,73.6369],[123.4911,73.6664],[123.7969,73.6268],[123.9339,73.6893],[124.019,73.7123],[124.3881,73.7548],[124.5412,73.7513],[124.7963,73.7118],[125.6171,73.5206],[125.5985,73.4474],[125.7944,73.4685],[125.8879,73.4981],[126.1074,73.5175],[126.2545,73.5482],[126.296,73.5367],[126.3449,73.5063],[126.3089,73.4637],[126.2574,73.4198],[126.2925,73.3942],[126.3354,73.3888],[126.5525,73.3349],[126.8385,73.4342],[126.9552,73.5282],[127.0313,73.5475],[127.7403,73.4815],[127.9551,73.4456],[127.9969,73.4256],[128.0257,73.3908],[128.1417,73.3524],[128.2814,73.3306],[128.2642,73.3007],[128.2578,73.2675],[128.587,73.2624],[128.7305,73.2334],[128.8887,73.1902],[128.8717,73.1394],[128.9134,73.1106],[129.0592,73.1075],[129.1006,73.1124],[129.0537,73.0454],[128.8535,72.9726],[128.7353,72.9433],[128.599,72.8952],[128.674,72.8859],[129.0173,72.8725],[129.2291,72.7757],[129.2504,72.7052],[129.1176,72.677],[128.8153,72.5859],[128.6334,72.5501],[128.5085,72.5473],[128.4183,72.5352],[128.5494,72.4958],[129.1166,72.4857],[129.2813,72.4377],[129.4117,72.3155],[129.4106,72.1663],[129.2835,72.092],[128.935,72.0795],[128.4752,72.2456],[128.197,72.3096],[127.8034,72.434],[127.7261,72.4132],[127.8414,72.3083],[128.0266,72.25],[128.3588,72.0883],[128.9114,71.7553],[129.0401,71.7824],[129.1166,71.8246],[129.1542,71.8787],[129.1216,71.9532],[129.2103,71.9169],[129.2918,71.8502],[129.4608,71.7393],[129.2342,71.7448],[128.949,71.7076],[128.8433,71.6635],[128.9227,71.6018],[129.1343,71.5929],[129.2245,71.5088],[129.3898,71.4049],[129.7619,71.1195],[130.026,71.0654],[130.2812,70.9473],[130.5371,70.8925],[130.6685,70.8883],[130.7571,70.9624],[130.8319,70.9359],[130.898,70.8036],[131.0216,70.7461],[131.1574,70.7422],[131.2683,70.7655],[131.4323,70.8283],[131.562,70.901],[131.769,71.1014],[131.9064,71.2026],[132.0354,71.244],[131.9908,71.2932],[132.0037,71.3502],[132.0988,71.484],[132.2276,71.6428],[132.3258,71.7262],[132.5623,71.8953],[132.6539,71.926],[132.7158,71.8715],[132.7686,71.7987],[132.8036,71.7676],[132.8393,71.7552],[133.1309,71.6067],[133.4262,71.491],[133.6889,71.4342],[134.1028,71.379],[134.7027,71.3868],[134.8139,71.4606],[135.0224,71.515],[135.3594,71.5435],[135.5592,71.6104],[135.8848,71.6306],[136.0903,71.6196],[136.4062,71.5708],[137.1158,71.4157],[137.3154,71.3594],[137.4175,71.299],[137.6506,71.2082],[137.7979,71.1639],[137.9396,71.1334],[137.9917,71.1427],[137.9737,71.1687],[137.902,71.194],[137.844,71.2268],[138.0127,71.2608],[138.0325,71.2858],[138.0906,71.3074],[138.3141,71.3255],[138.0972,71.3586],[138.0222,71.3634],[137.9184,71.3841],[137.9273,71.4298],[137.9957,71.4635],[138.0483,71.526],[138.1185,71.5662],[138.2342,71.5963],[138.3181,71.6028],[138.5252,71.5627],[138.67,71.6348],[138.7802,71.629],[139.0049,71.5561],[139.2094,71.4448],[139.3202,71.4447],[139.6321,71.4893],[139.9842,71.4915],[139.9388,71.5577],[139.6951,71.7004],[139.7229,71.885],[139.5523,71.9267],[139.3593,71.9514],[139.6402,71.9983],[139.8471,72.1486],[140.0141,72.1621],[140.1877,72.1913],[140.1344,72.2096],[139.617,72.2257],[139.5053,72.2077],[139.4305,72.1635],[139.1764,72.1635],[139.145,72.2644],[139.1408,72.3297],[139.4736,72.4665],[139.6012,72.4961],[140.4506,72.4931],[140.7051,72.5189],[141.0793,72.5869],[140.9832,72.63],[140.9729,72.717],[140.6523,72.8428],[140.676,72.8716],[140.7081,72.89],[140.8082,72.891],[141.3098,72.8577],[141.5184,72.7887],[142.0614,72.7208],[143.5158,72.6982],[143.681,72.6732],[144.3039,72.643],[144.5687,72.6099],[145.1993,72.5702],[145.4857,72.5421],[145.7142,72.4974],[146.0833,72.4714],[146.2529,72.4422],[146.2348,72.3497],[145.4671,72.3621],[145.2129,72.3927],[144.8975,72.3962],[144.7764,72.3823],[144.5876,72.3055],[144.3609,72.2653],[144.1692,72.2588],[144.2949,72.1926],[144.4707,72.1748],[145.0392,72.2599],[146.5941,72.3024],[146.8318,72.2954],[146.807,72.2366],[146.5992,72.1235],[146.4017,72.0355],[146.1133,71.945],[146.0059,71.9455],[146.2303,72.1375],[146.1373,72.1465],[146.0515,72.1423],[145.7994,72.2219],[145.7586,72.2259],[145.7097,72.2063],[145.7102,72.1776],[145.6641,72.067],[145.7567,72.0207],[145.7567,71.9413],[145.4072,71.8901],[145.2712,71.8946],[145.1258,71.9271],[145.064,71.9261],[145.0469,71.901],[145.0777,71.8546],[145.0737,71.8309],[145.0179,71.7937],[144.9896,71.7534],[145.0756,71.7074],[145.1886,71.6958],[145.8048,71.7465],[146.0732,71.8083],[146.368,71.9221],[146.8947,72.1975],[147.1271,72.292],[147.2618,72.3279],[147.434,72.3409],[148.4021,72.312],[148.9648,72.2523],[149.5016,72.1643],[149.7662,72.0913],[149.9631,71.9922],[149.9981,71.9505],[150.0169,71.8957],[149.8811,71.843],[149.2797,71.8255],[149.0487,71.7958],[148.9653,71.7628],[148.9549,71.7441],[148.9233,71.7146],[148.9682,71.6905],[149.2379,71.6879],[149.498,71.664],[149.8571,71.6015],[149.9127,71.5807],[150.0265,71.5213],[150.0608,71.5108],[150.5998,71.5201],[150.6349,71.4989],[150.6678,71.4552],[150.5251,71.3858],[150.3848,71.3388],[150.0977,71.2266],[150.243,71.2672],[150.8217,71.3629],[150.9678,71.3805],[151.1453,71.3737],[151.5824,71.287],[151.7598,71.2178],[152.0928,71.0233],[151.9998,71.0025],[151.762,70.9825],[152.5088,70.8345],[152.7983,70.8356],[153.4606,70.8786],[153.7941,70.88],[154.414,70.9745],[155.0295,71.0342],[155.5959,71.0386],[155.8952,71.0955],[156.6846,71.0938],[157.4474,71.0745],[158.037,71.0393],[158.7021,70.935],[159.3507,70.7907],[159.7279,70.6497],[159.8047,70.6049],[159.9118,70.5061],[159.9586,70.4236],[160.0064,70.3097],[159.9834,70.2214],[159.8896,70.1588],[159.8314,70.0814],[159.8392,69.99],[159.7294,69.8702],[159.8325,69.785],[160.1191,69.7298],[160.7395,69.6552],[160.9107,69.6063],[160.9289,69.4585],[160.982,69.3345],[161.0355,69.0982],[161.1408,69.0389],[161.3099,68.9823],[161.3406,68.9052],[161.129,68.6539],[160.9967,68.6075],[160.8561,68.5383],[161.1045,68.5625],[161.2302,68.6539],[161.3651,68.823],[161.4953,68.8499],[161.5656,68.9052],[161.5656,69.064],[161.4801,69.2017],[161.4801,69.3001],[161.5369,69.3795],[161.9451,69.5451],[162.166,69.6116],[162.3757,69.6491],[162.9446,69.6828],[163.2014,69.7147],[163.498,69.6933],[163.7053,69.7018],[163.946,69.7352],[164.1596,69.7193],[164.5133,69.6091],[165.7607,69.5844],[165.9805,69.546],[166.8203,69.4996],[166.8844,69.4999],[167.0731,69.5544],[167.6281,69.7403],[167.8568,69.7282],[167.9501,69.6992],[168.0477,69.6256],[168.15,69.5774],[168.23,69.447],[168.303,69.2715],[168.423,69.2395],[168.5876,69.2284],[168.9462,69.1633],[169.3106,69.0795],[169.4146,68.9196],[169.6099,68.786],[170.0656,68.7987],[170.5376,68.8254],[170.9954,69.0453],[170.9967,69.1347],[170.8838,69.2636],[170.7142,69.3882],[170.5822,69.5833],[170.1609,69.6266],[170.2012,69.6832],[170.3596,69.751],[170.5031,69.8565],[170.5254,69.9379],[170.4868,70.1076],[170.868,70.096],[171.2467,70.0761],[171.9705,70.0003],[172.5596,69.9684],[172.8692,69.9198],[173.0563,69.8649],[173.2774,69.8238],[173.3533,69.924],[173.4387,69.9468],[173.7334,69.8911],[173.948,69.8741],[174.3194,69.8816],[174.7855,69.8557],[175.2956,69.8601],[175.7512,69.9042],[175.9215,69.8953],[176.1075,69.8603],[176.4104,69.7685],[176.9244,69.646],[177.3945,69.6116],[177.9337,69.4956],[178.4428,69.453],[178.8483,69.3872],[178.9069,69.3621],[178.925,69.326],[178.9507,69.2958],[179.2727,69.2597],[179.8683,69.0127],[180,68.9834],[180,65.0672],[179.8273,65.0342],[179.6514,64.9209],[179.4482,64.822],[179.15,64.7816],[178.6984,64.6311],[178.5195,64.603],[178.2854,64.6723],[177.7486,64.717],[177.5816,64.7779],[177.337,64.9313],[177.2519,64.9536],[177.1792,65.0141],[176.8809,65.0819],[176.6248,65.0376],[176.4131,65.0712],[176.341,65.0473],[176.4521,65.0252],[176.6455,65.0072],[176.94,65.016],[177.0373,64.9997],[177.1234,64.947],[177.2229,64.8617],[177.1482,64.8048],[177.0688,64.7867],[176.8311,64.8492],[176.5566,64.84],[176.4295,64.8552],[176.0611,64.9609],[175.7812,64.844],[175.3965,64.7837],[175.0978,64.7769],[174.5488,64.6839],[174.6986,64.6814],[175.0971,64.7466],[175.3307,64.7466],[175.6779,64.7825],[175.8586,64.8253],[175.9459,64.8652],[176.0565,64.9047],[176.1692,64.8848],[176.247,64.843],[176.3009,64.7838],[176.351,64.7051],[176.2832,64.6638],[176.2194,64.6419],[176.1409,64.5858],[176.5076,64.6824],[176.731,64.6249],[176.8429,64.6338],[177.0498,64.7192],[177.3875,64.774],[177.4274,64.7634],[177.4672,64.7368],[177.4099,64.5728],[177.4329,64.4445],[177.6875,64.3047],[177.9533,64.2223],[178.0447,64.2196],[178.1306,64.2353],[178.164,64.3091],[178.2295,64.3644],[178.313,64.3144],[178.3814,64.2609],[178.4771,64.1279],[178.4748,64.089],[178.4514,64.0114],[178.536,63.9756],[178.6503,63.9653],[178.6925,63.8423],[178.7314,63.6671],[178.6813,63.6507],[178.626,63.6507],[178.4404,63.6056],[178.4661,63.5741],[178.6537,63.5566],[178.7064,63.5215],[178.6688,63.4399],[178.6787,63.4023],[178.744,63.3948],[178.7867,63.4424],[178.7754,63.5103],[178.793,63.5403],[178.9186,63.4002],[178.9215,63.345],[179.0281,63.2824],[179.3323,63.1902],[179.3886,63.1472],[179.4051,63.0777],[179.329,63.0579],[179.2596,63.0083],[179.3021,62.9398],[179.3811,62.8837],[179.5109,62.8628],[179.5705,62.7735],[179.5705,62.6875],[179.4772,62.6131],[179.2887,62.5104],[179.177,62.4692],[179.1339,62.3964],[179.1207,62.3204],[179.0446,62.3237],[178.9639,62.3553],[178.0192,62.547],[177.6631,62.5828],[177.3513,62.5875],[177.2926,62.599],[177.2959,62.6445],[177.3158,62.6853],[177.3597,62.737],[177.339,62.7813],[177.2983,62.7842],[177.2587,62.7504],[177.1727,62.7503],[177.0912,62.7896],[177.0235,62.7772],[176.99,62.7222],[176.9635,62.6933],[176.9647,62.6586],[177.008,62.6266],[177.1896,62.5916],[177.1595,62.561],[176.9074,62.5361],[176.7025,62.5058],[176.4365,62.4108],[176.3284,62.346],[175.6139,62.1844],[175.442,62.1279],[175.3658,62.1213],[175.2679,62.1024],[175.1924,62.0344],[174.7976,61.9389],[174.715,61.9479],[174.6105,61.8676],[174.5144,61.8236],[174.285,61.8175],[174.1389,61.7952],[173.8224,61.6794],[173.6234,61.7161],[173.3907,61.5567],[173.1318,61.4066],[173.0546,61.4062],[172.8565,61.4692],[172.8068,61.4361],[172.8379,61.3756],[172.908,61.3116],[172.8678,61.2931],[172.7891,61.3107],[172.7307,61.3144],[172.69,61.2952],[172.697,61.2493],[172.5848,61.1904],[172.4971,61.1859],[172.3961,61.1674],[172.3624,61.1166],[172.3928,61.0618],[172.2133,60.9979],[172.0673,60.9157],[171.9977,60.9007],[171.918,60.8641],[171.8306,60.8374],[171.7295,60.8431],[171.4897,60.7257],[170.9493,60.5229],[170.7993,60.4965],[170.6082,60.4349],[170.5897,60.3937],[170.5886,60.3429],[170.5123,60.2595],[170.4234,60.0478],[170.3965,60.0098],[170.351,59.9655],[170.1541,59.9861],[169.9826,60.0671],[169.9272,60.1042],[169.8976,60.1479],[169.887,60.2179],[169.8543,60.2502],[169.8147,60.2654],[169.6184,60.438],[169.2757,60.5566],[169.2268,60.5959],[168.7883,60.5638],[168.6703,60.5629],[168.4628,60.5922],[168.1375,60.5739],[167.746,60.5093],[167.6261,60.4689],[167.2268,60.4063],[166.9641,60.307],[166.4525,59.947],[166.3318,59.8724],[166.273,59.8562],[166.1865,59.8495],[166.1489,59.9221],[166.136,59.9793],[166.1684,60.0888],[166.2298,60.1783],[166.2925,60.3461],[166.3081,60.4143],[166.3521,60.4848],[166.1802,60.4804],[165.942,60.3569],[165.583,60.2365],[165.4158,60.2052],[165.2853,60.1349],[165.1926,60.1248],[165.0846,60.0986],[165.0736,59.9456],[165.0189,59.8607],[164.9537,59.8436],[164.8543,59.841],[164.7794,59.8742],[164.6697,59.9975],[164.5253,60.0613],[164.44,60.0727],[164.3769,60.0581],[164.2516,59.9738],[164.1133,59.8976],[164.1351,59.9844],[164.0176,60.0173],[163.9129,60.0371],[163.7801,60.0411],[163.7438,60.028],[163.69,59.9784],[163.5743,59.9141],[163.4938,59.8868],[163.41,59.835],[163.3648,59.7814],[163.3212,59.7054],[163.269,59.52],[163.2729,59.3026],[163.0849,59.1314],[163.0102,59.1483],[162.9749,59.1371],[162.94,59.1143],[163.0043,59.0202],[162.9698,58.9865],[162.9346,58.964],[162.8473,58.9393],[162.6434,58.7999],[162.453,58.7086],[162.1416,58.4474],[162.0492,58.2729],[161.9601,58.0769],[162.002,57.981],[162.0396,57.9183],[162.0979,57.8747],[162.1975,57.8292],[162.4114,57.7784],[162.3922,57.745],[162.3914,57.7172],[162.467,57.7662],[162.522,57.9041],[162.6543,57.9482],[162.7184,57.9461],[163.145,57.8373],[163.2258,57.7904],[163.2139,57.6868],[163.1879,57.6374],[163.1088,57.5648],[162.957,57.4775],[162.7793,57.3576],[162.7623,57.2841],[162.7615,57.2439],[162.8081,57.1028],[162.8148,57.0234],[162.7911,56.8754],[162.8026,56.8115],[162.8499,56.7568],[162.9221,56.7227],[163.0464,56.7413],[163.1654,56.7255],[163.2565,56.688],[163.2433,56.5646],[163.294,56.4477],[163.3355,56.2325],[163.2613,56.1737],[163.1893,56.137],[163.0474,56.0447],[162.9717,56.0338],[162.8403,56.0656],[162.6281,56.2323],[162.7132,56.3309],[162.8933,56.3995],[162.9752,56.449],[163.0384,56.5219],[162.9441,56.5081],[162.8776,56.4764],[162.6715,56.4901],[162.5891,56.4549],[162.4887,56.3991],[162.5282,56.2607],[162.4611,56.2355],[162.3341,56.1877],[162.1461,56.1283],[162.085,56.0896],[161.924,55.8404],[161.7756,55.6548],[161.7239,55.4961],[161.7294,55.358],[161.785,55.2053],[161.8242,55.1389],[161.9961,54.998],[162.0803,54.8861],[162.1056,54.7521],[161.9669,54.6887],[161.7257,54.533],[161.6248,54.5163],[161.294,54.5206],[161.1299,54.5982],[160.9355,54.5784],[160.7727,54.5414],[160.5172,54.4309],[160.2889,54.2882],[160.0744,54.1892],[160.0102,54.1309],[159.9218,54.0084],[159.8437,53.7836],[159.8709,53.6727],[159.9143,53.6208],[159.9559,53.5522],[159.8991,53.4477],[159.8977,53.3808],[160.0021,53.2749],[160.0251,53.1296],[159.9475,53.1251],[159.7716,53.2297],[159.5859,53.2377],[159.1361,53.1171],[158.9521,53.0476],[158.7454,52.9089],[158.6837,52.9354],[158.6396,53.0148],[158.5646,53.05],[158.4721,53.0324],[158.4323,52.9574],[158.5602,52.9222],[158.6088,52.8736],[158.5337,52.6884],[158.4808,52.6267],[158.5004,52.4603],[158.4932,52.3832],[158.4635,52.305],[158.3316,52.0909],[158.1035,51.8096],[157.8232,51.6053],[157.6289,51.5346],[157.531,51.4799],[157.4898,51.4089],[157.2022,51.2127],[156.8475,51.0066],[156.7478,50.9693],[156.7243,51.0471],[156.7135,51.1241],[156.6708,51.2269],[156.5435,51.3116],[156.5212,51.3803],[156.5004,51.4751],[156.4898,51.913],[156.3773,52.3666],[156.3647,52.5094],[156.2286,52.6263],[156.1544,52.7473],[156.1104,52.8662],[156.0988,53.0065],[155.9502,53.7443],[155.9049,53.9281],[155.7064,54.5215],[155.6203,54.8646],[155.5639,55.1991],[155.5549,55.3485],[155.6435,55.7936],[155.7166,56.0722],[155.9825,56.6952],[156.0254,56.752],[156.0675,56.7816],[156.5293,57.0212],[156.7284,57.1522],[156.8488,57.2902],[156.9768,57.4663],[156.9636,57.5609],[156.9482,57.6158],[156.8999,57.6769],[156.7916,57.7479],[156.8299,57.7796],[156.872,57.8037],[156.9857,57.8302],[157.2168,57.7768],[157.4504,57.7993],[157.6664,58.0198],[157.9746,57.9859],[158.2104,58.0253],[158.2752,58.009],[158.3211,58.0834],[158.4494,58.1628],[158.687,58.2813],[159.0369,58.4239],[159.2106,58.5194],[159.3084,58.6105],[159.4526,58.6959],[159.5915,58.8037],[159.8474,59.1271],[160.3504,59.394],[160.5475,59.5474],[160.7114,59.6017],[160.8553,59.6269],[161.2189,59.8456],[161.4493,60.0273],[161.7535,60.1523],[161.846,60.2322],[162.0036,60.4202],[162.0682,60.4664],[162.2663,60.5367],[162.7132,60.6595],[162.9731,60.7829],[163.3523,60.8004],[163.4664,60.8498],[163.5852,60.8771],[163.71,60.9168],[163.5535,61.0256],[163.5893,61.0844],[163.6196,61.1113],[163.8934,61.2405],[164.0055,61.3438],[163.9921,61.3882],[163.9728,61.4199],[163.8044,61.4614],[163.8371,61.5583],[163.8827,61.6401],[164.0195,61.7107],[164.068,61.8739],[164.0742,62.045],[164.2072,62.2922],[164.2875,62.3466],[164.5983,62.4706],[164.6707,62.4738],[164.8877,62.4319],[165.1241,62.4115],[165.2081,62.374],[165.2257,62.4058],[165.2139,62.4482],[165.2804,62.463],[165.4174,62.4471],[165.3966,62.4939],[165.044,62.517],[164.7924,62.5711],[164.567,62.6755],[164.4184,62.7046],[164.2557,62.6966],[163.3317,62.5509],[163.2871,62.5114],[163.2442,62.4554],[163.3021,62.373],[163.258,62.3369],[163.2133,62.3134],[163.1635,62.2596],[163.1185,62.1529],[163.1311,62.0499],[163.0177,61.8911],[163.0093,61.7915],[163.2076,61.7366],[163.2578,61.6995],[163.1979,61.6448],[163.1389,61.6114],[163.0853,61.5706],[163.0473,61.5541],[162.9939,61.5442],[162.9217,61.5977],[162.856,61.705],[162.7523,61.7113],[162.7179,61.6951],[162.699,61.6526],[162.6076,61.65],[162.5064,61.6701],[162.3926,61.6621],[162.1884,61.5407],[161.0371,60.9629],[160.915,60.8927],[160.7666,60.7533],[160.482,60.7398],[160.3682,60.7085],[160.2873,60.667],[160.1736,60.6384],[160.1773,60.6907],[160.2011,60.7296],[160.2258,60.8315],[160.3789,61.0255],[160.2813,61.0448],[160.1843,61.0477],[160.004,61.0074],[159.8831,60.9434],[159.7904,60.9566],[159.8346,61.014],[159.9492,61.1286],[159.914,61.2345],[159.8831,61.2918],[159.9309,61.3239],[160.1627,61.5375],[160.2469,61.6476],[160.3174,61.7934],[160.3215,61.8386],[160.3094,61.8944],[160.2378,61.9039],[160.1825,61.9028],[159.7222,61.7584],[159.5523,61.7195],[159.4963,61.7814],[159.423,61.8081],[159.295,61.9142],[159.1893,61.9294],[159.0767,61.9223],[158.8243,61.8502],[158.5472,61.8109],[158.3337,61.8257],[158.1516,61.7648],[158.0701,61.7536],[157.7993,61.7953],[157.4693,61.7989],[157.3707,61.7471],[157.0842,61.6757],[156.8918,61.5652],[156.7906,61.5296],[156.6803,61.4806],[156.6297,61.2725],[156.4826,61.206],[156.3441,61.1551],[156.056,60.9956],[155.8533,60.7771],[155.7161,60.6824],[155.4278,60.5499],[154.9708,60.3767],[154.5782,60.095],[154.4407,59.8838],[154.3898,59.8768],[154.2931,59.8333],[154.2666,59.7304],[154.2688,59.6584],[154.2092,59.6003],[154.1498,59.5285],[154.2129,59.4834],[154.2722,59.4751],[154.3576,59.4814],[154.5825,59.5401],[154.9713,59.4496],[155.1667,59.3602],[155.153,59.2702],[155.1604,59.1901],[155.0167,59.1956],[154.8237,59.1875],[154.7035,59.1413],[154.458,59.2166],[154.376,59.1878],[154.2467,59.1086],[154.0109,59.0755],[153.8917,59.1142],[153.6952,59.2248],[153.3611,59.2148],[153.2729,59.0913],[153.1961,59.0944],[153.0777,59.0819],[152.8822,58.9391],[152.8179,58.9263],[152.5756,58.9541],[152.4007,59.0264],[152.3196,59.0308],[152.1652,58.997],[152.0879,58.9104],[151.7046,58.8667],[151.3268,58.8751],[151.1211,59.0825],[151.505,59.164],[151.7335,59.1467],[151.99,59.1601],[152.2606,59.2236],[152.1695,59.2779],[152.1045,59.2906],[151.9424,59.2841],[151.798,59.3232],[151.4857,59.5241],[151.3482,59.5611],[151.1703,59.5833],[151.0336,59.5856],[150.9825,59.5713],[150.9119,59.523],[150.8633,59.4754],[150.8234,59.4607],[150.7295,59.4691],[150.6152,59.5065],[150.4836,59.4944],[150.5398,59.525],[150.6673,59.5563],[150.4572,59.5907],[150.3256,59.6389],[150.2025,59.6513],[149.6426,59.7704],[149.4245,59.761],[149.2904,59.7285],[149.0652,59.6305],[149.1277,59.5588],[149.1754,59.5268],[149.205,59.4882],[149.133,59.4805],[148.925,59.475],[148.7971,59.5323],[148.7089,59.4485],[148.7441,59.3735],[148.8896,59.4],[148.9646,59.3691],[148.9141,59.2827],[148.7267,59.2579],[148.4912,59.2623],[148.2574,59.4142],[147.8746,59.388],[147.6879,59.2907],[147.5145,59.2686],[147.04,59.3657],[146.8037,59.3729],[146.5372,59.457],[146.4443,59.4305],[146.2734,59.2215],[146.0495,59.1706],[145.9316,59.1984],[145.8291,59.3303],[145.7564,59.3737],[145.5546,59.4135],[144.4834,59.3763],[144.1234,59.4083],[143.8688,59.4114],[143.5238,59.3437],[143.1922,59.3701],[142.5803,59.2401],[142.3304,59.1526],[142.0254,58.9997],[141.7547,58.7453],[141.6029,58.649],[141.3471,58.5281],[140.9877,58.4168],[140.7902,58.3035],[140.685,58.2122],[140.4951,57.8654],[140.4469,57.8137],[140.0023,57.6875],[139.8615,57.5493],[139.8033,57.5142],[139.6192,57.4557],[139.5066,57.3583],[139.4438,57.3297],[139.1816,57.2615],[138.9657,57.0881],[138.6621,56.9655],[138.2178,56.629],[138.1801,56.5885],[138.1406,56.4987],[138.0738,56.4331],[137.6915,56.1394],[137.5729,56.1121],[137.3841,55.9748],[137.1898,55.8923],[137.0121,55.7953],[136.7936,55.6942],[136.4603,55.5767],[136.3512,55.51],[136.1752,55.3522],[135.7508,55.1606],[135.5406,55.1138],[135.2625,54.9433],[135.2348,54.9032],[135.2115,54.8408],[135.2577,54.7315],[135.3254,54.7074],[135.4378,54.6925],[135.8516,54.5839],[136.238,54.6141],[136.5803,54.6136],[136.7146,54.6243],[136.7973,54.621],[136.8237,54.5615],[136.8204,54.4523],[136.7704,54.3533],[136.7294,54.0606],[136.683,53.9313],[136.7188,53.8041],[136.8026,53.782],[136.8864,53.8394],[137.0188,53.8481],[137.1554,53.8217],[137.258,54.0252],[137.1725,54.0569],[137.0962,54.1286],[137.1416,54.1822],[137.3777,54.2823],[137.5251,54.2912],[137.666,54.2833],[137.5132,54.1564],[137.4513,54.1305],[137.4034,54.1235],[137.3393,54.1005],[137.4765,54.0276],[137.6228,53.9705],[137.8348,53.9467],[137.7861,53.9033],[137.6448,53.8658],[137.517,53.7071],[137.3137,53.6316],[137.2215,53.5792],[137.2537,53.5461],[137.3283,53.539],[137.7382,53.5603],[137.9505,53.6036],[138.2529,53.7264],[138.3789,53.9093],[138.4936,53.9597],[138.5279,53.9599],[138.5682,53.9472],[138.5691,53.8188],[138.407,53.6742],[138.2922,53.5924],[138.2497,53.524],[138.3203,53.5229],[138.4507,53.537],[138.5109,53.57],[138.6607,53.7448],[138.6994,53.8697],[138.7217,54.0438],[138.7047,54.1477],[138.7159,54.2227],[138.6572,54.2983],[138.6957,54.32],[139.1051,54.2178],[139.3197,54.193],[139.7074,54.2771],[139.7955,54.2564],[139.8584,54.2053],[140.1787,54.0516],[140.2417,54.001],[140.3471,53.8126],[140.6876,53.5964],[141.0057,53.4946],[141.015,53.4542],[141.2177,53.3345],[141.3737,53.2928],[141.4021,53.184],[141.3279,53.0973],[141.1813,53.0153],[140.8873,53.0915],[140.8396,53.0879],[140.8745,53.0398],[141.0868,52.8976],[141.2559,52.8401],[141.2659,52.6526],[141.245,52.5501],[141.1324,52.4357],[141.1698,52.3684],[141.3297,52.2711],[141.4091,52.2343],[141.4853,52.1785],[141.3855,52.0572],[141.3669,51.9207],[141.2584,51.8607],[141.1294,51.7278],[140.9326,51.6199],[140.8386,51.4142],[140.6877,51.2323],[140.6707,51.0513],[140.6456,50.9868],[140.5209,50.8002],[140.4764,50.546],[140.5354,50.1308],[140.5641,50.1067],[140.6245,50.0824],[140.6133,50.0537],[140.5846,50.0333],[140.4627,49.9115],[140.4646,49.8256],[140.5113,49.7617],[140.5172,49.5961],[140.4311,49.3315],[140.3991,49.2898],[140.3644,49.2208],[140.3486,49.1592],[140.3256,49.12],[140.309,49.0539],[140.3337,48.9948],[140.3783,48.9641],[140.2242,48.7729],[140.1706,48.5237],[140.1133,48.4227],[139.9984,48.3238],[139.7607,48.1806],[139.6763,48.0899],[139.5205,47.9753],[139.3727,47.8874],[139.167,47.6349],[139.0014,47.3833],[138.5868,47.0572],[138.5297,46.9762],[138.5005,46.8898],[138.3918,46.7451],[138.3369,46.5434],[138.2102,46.4629],[138.1063,46.2507],[137.7691,45.9285],[137.6854,45.8184],[137.4252,45.64],[137.147,45.3935],[136.8035,45.1711],[136.7372,45.08],[136.6041,44.9782],[136.4604,44.8221],[136.2512,44.6668],[136.2087,44.562],[136.1423,44.4891],[135.987,44.4398],[135.8746,44.3735],[135.5332,43.9715],[135.4891,43.8988],[135.4834,43.835],[135.2602,43.6846],[135.1311,43.5257],[134.917,43.4266],[134.6918,43.2906],[134.1564,43.0421],[134.0104,42.9475],[133.7094,42.8299],[133.5867,42.8282],[133.3295,42.7639],[133.16,42.697],[133.0594,42.7228],[132.9966,42.808],[132.9239,42.8053],[132.8636,42.7937],[132.709,42.8758],[132.5765,42.8716],[132.4813,42.9098],[132.3038,42.8833],[132.3344,43.2387],[132.3096,43.3135],[132.2332,43.2451],[132.0287,43.1189],[131.9473,43.0954],[131.8666,43.0952],[131.8983,43.1708],[132.0131,43.28],[131.9763,43.296],[131.939,43.302],[131.7947,43.2553],[131.7221,43.2026],[131.5164,42.9964],[131.3933,42.8223],[131.2925,42.7721],[131.2453,42.6974],[131.1583,42.626],[131.0248,42.6452],[130.9457,42.6339],[130.7562,42.6733],[130.7094,42.6564],[130.8342,42.5229],[130.7299,42.3258],[130.6873,42.3025],[130.658,42.3278],[130.6516,42.3725],[130.618,42.4156],[130.5541,42.4747],[130.527,42.5354],[130.5845,42.5673],[130.5766,42.6232],[130.5206,42.6743],[130.4393,42.6855],[130.4199,42.6999],[130.4248,42.7271],[130.4527,42.7554],[130.493,42.7791],[130.5772,42.8116],[130.7225,42.8358],[130.8033,42.8568],[130.8686,42.8633],[130.9429,42.8518],[131.0056,42.8831],[131.0686,42.9022],[131.0835,42.9563],[131.0861,43.0381],[131.109,43.0625],[131.1355,43.0976],[131.1756,43.1422],[131.2119,43.2578],[131.2394,43.3376],[131.2573,43.3781],[131.2618,43.4331],[131.2439,43.469],[131.2092,43.4904],[131.1824,43.5056],[131.1801,43.5671],[131.1836,43.6509],[131.1742,43.7047],[131.2133,44.0029],[131.2553,44.0716],[131.1258,44.4692],[131.0869,44.5957],[131.0606,44.6597],[131.0039,44.7532],[130.9678,44.8],[130.9816,44.8443],[131.033,44.8889],[131.0823,44.91],[131.2279,44.9202],[131.2683,44.9361],[131.4469,44.984],[131.4875,45.0131],[131.5787,45.0836],[131.614,45.1366],[131.654,45.2054],[131.7421,45.2426],[131.7949,45.3053],[131.8519,45.3269],[131.9093,45.2737],[131.9775,45.244],[132.0674,45.226],[132.1813,45.2033],[132.363,45.16],[132.549,45.1228],[132.6656,45.0937],[132.7231,45.0806],[132.8387,45.0611],[132.8888,45.046],[132.936,45.0299],[133.0117,45.0746],[133.1135,45.1307],[133.0969,45.2205],[133.1134,45.3214],[133.186,45.4948],[133.267,45.5453],[133.3096,45.5531],[133.3555,45.5722],[133.4364,45.6047],[133.4656,45.6512],[133.4491,45.7051],[133.4758,45.7577],[133.4847,45.8104],[133.5131,45.8788],[133.5512,45.8978],[133.608,45.9203],[133.6479,45.9552],[133.6857,46.0089],[133.7111,46.0696],[133.7007,46.1397],[133.7502,46.1859],[133.8328,46.2243],[133.8613,46.2478],[133.8748,46.3091],[133.8803,46.336],[133.9027,46.3669],[133.8867,46.4306],[133.8666,46.4991],[133.9575,46.6143],[134.0227,46.7132],[134.0386,46.8582],[134.046,46.882],[134.0714,46.9508],[134.0864,46.9781],[134.1369,47.069],[134.2021,47.1281],[134.1893,47.1942],[134.163,47.2587],[134.1677,47.3022],[134.2252,47.3526],[134.2601,47.3777],[134.2908,47.4136],[134.3395,47.4295],[134.3825,47.4382],[134.4835,47.4474],[134.5419,47.4852],[134.5962,47.5239],[134.6958,47.6249],[134.7281,47.6845],[134.7523,47.7154],[134.6986,47.8014],[134.6503,47.8743],[134.5913,47.9752],[134.566,48.0225],[134.6054,48.0829],[134.6473,48.1202],[134.6693,48.1533],[134.6809,48.2104],[134.6652,48.2539],[134.5636,48.3217],[134.4562,48.3553],[134.335,48.3688],[134.2934,48.3734],[134.2059,48.3599],[133.8422,48.2737],[133.6718,48.2077],[133.5732,48.133],[133.4684,48.0972],[133.3012,48.1015],[133.144,48.1057],[133.0201,48.0644],[132.8771,47.9791],[132.7729,47.9401],[132.7072,47.9473],[132.6369,47.8901],[132.5619,47.7685],[132.4763,47.715],[132.3802,47.7295],[132.1498,47.718],[131.7853,47.6805],[131.5567,47.682],[131.4643,47.7226],[131.3193,47.7278],[131.1219,47.6977],[131.0027,47.6915],[130.9619,47.7093],[130.9328,47.7598],[130.9154,47.8429],[130.8486,47.9294],[130.7326,48.0192],[130.7121,48.1276],[130.7872,48.2546],[130.8043,48.3415],[130.7635,48.3884],[130.7469,48.4304],[130.6592,48.4834],[130.5973,48.5747],[130.5521,48.6025],[130.5656,48.6801],[130.6172,48.7732],[130.5531,48.8612],[130.3553,48.8664],[130.196,48.8917],[130.0371,48.9723],[129.7926,49.1989],[129.6711,49.2785],[129.5914,49.2867],[129.5337,49.3234],[129.4981,49.3888],[129.4407,49.3895],[129.3847,49.3895],[129.3501,49.3624],[129.3099,49.3539],[129.2484,49.3787],[129.1852,49.3814],[129.1201,49.3621],[129.0651,49.3747],[129.0203,49.4192],[128.9383,49.4489],[128.8193,49.4638],[128.7703,49.4947],[128.791,49.5418],[128.769,49.577],[128.704,49.6001],[128.5268,49.5942],[128.2371,49.5593],[127.9996,49.5686],[127.8143,49.6221],[127.7111,49.6715],[127.6901,49.7167],[127.6367,49.7602],[127.5508,49.8018],[127.5024,49.8734],[127.4918,49.975],[127.5123,50.0717],[127.5902,50.209],[127.3953,50.2986],[127.3372,50.3501],[127.3512,50.3936],[127.3408,50.4281],[127.3061,50.4535],[127.3082,50.4942],[127.3472,50.5501],[127.3469,50.6213],[127.307,50.708],[127.1982,50.8294],[127.0204,50.9859],[126.9248,51.1001],[126.9115,51.1723],[126.8877,51.2301],[126.8544,51.2614],[126.8338,51.3149],[126.8478,51.3742],[126.8273,51.4123],[126.8018,51.448],[126.8055,51.5057],[126.7745,51.5451],[126.7092,51.5663],[126.6887,51.6099],[126.7008,51.703],[126.6537,51.7813],[126.5105,51.9258],[126.4681,52.0313],[126.4556,52.1265],[126.3948,52.173],[126.3915,52.2145],[126.3835,52.2865],[126.3463,52.3063],[126.3242,52.3316],[126.3417,52.362],[126.3129,52.3998],[126.2376,52.4448],[126.2029,52.4838],[126.1944,52.5191],[126.1566,52.5466],[126.0459,52.5733],[126.016,52.6102],[126.0232,52.643],[126.0471,52.6735],[126.0602,52.692],[126.0561,52.7159],[126.0481,52.7395],[126.0043,52.7679],[125.9416,52.8007],[125.8719,52.8715],[125.7828,52.8907],[125.7281,52.8907],[125.6808,52.9308],[125.6953,52.9563],[125.6917,53.0037],[125.649,53.0423],[125.596,53.0575],[125.546,53.0476],[125.4225,53.0837],[125.2256,53.1658],[125.075,53.2037],[124.9709,53.1973],[124.9066,53.1727],[124.8821,53.1297],[124.8123,53.1338],[124.6398,53.2106],[124.4659,53.2296],[124.3691,53.2709],[124.2914,53.3409],[124.2199,53.3701],[124.1543,53.3587],[123.9947,53.4056],[123.7409,53.511],[123.6078,53.5465],[123.5598,53.5267],[123.5348,53.5265],[123.4895,53.5294],[123.424,53.5308],[123.3096,53.5556],[123.1541,53.5446],[122.9576,53.4977],[122.7447,53.4685],[122.5158,53.457],[122.3802,53.4625],[122.3378,53.485],[122.0889,53.4515],[121.7439,53.3836],[121.4055,53.317],[120.9854,53.2846],[120.7041,53.1718],[120.4213,52.9681],[120.2182,52.8399],[120.0945,52.7872],[120.0443,52.7182],[120.0676,52.6329],[120.1728,52.6025],[120.3601,52.627],[120.5211,52.615],[120.6562,52.5667],[120.6992,52.4936],[120.6504,52.3959],[120.6654,52.2999],[120.7445,52.2055],[120.7498,52.0965],[120.6814,51.973],[120.5105,51.8485],[120.237,51.723],[120.0669,51.6007],[119.967,51.4221],[119.8132,51.267],[119.7566,51.1795],[119.746,51.1077],[119.685,51.0301],[119.5734,50.9468],[119.5123,50.8631],[119.5018,50.7792],[119.4457,50.7028],[119.344,50.6339],[119.2807,50.561],[119.2559,50.4842],[119.2167,50.4325],[119.1637,50.406],[119.1919,50.3798],[119.3016,50.3539],[119.3463,50.279],[119.3261,50.1549],[119.2599,50.0664],[119.1475,50.0134],[118.9795,49.9789],[118.756,49.9628],[118.4516,49.8445],[118.1866,49.6928],[117.8734,49.5135],[117.8126,49.5135],[117.6984,49.5358],[117.4771,49.6094],[117.2456,49.6249],[117.0217,49.693],[116.889,49.7378],[116.6833,49.8238],[116.6315,49.8771],[116.5512,49.9203],[116.3512,49.9781],[116.2168,50.0093],[116.1346,50.0108],[115.926,49.9521],[115.7952,49.9059],[115.7178,49.8806],[115.588,49.886],[115.4292,49.8965],[115.365,49.9118],[115.2745,49.9489],[115.098,50.0594],[115.0033,50.1386],[114.8796,50.1831],[114.7432,50.2337],[114.6749,50.2457],[114.554,50.2415],[114.3863,50.2555],[114.2971,50.2744],[114.2218,50.2573],[114.0707,50.2047],[113.8812,50.1011],[113.7324,50.0615],[113.5742,50.007],[113.4455,49.9416],[113.319,49.8743],[113.1642,49.7972],[113.0921,49.6925],[113.0556,49.6163],[112.9148,49.5692],[112.8064,49.5236],[112.6974,49.5073],[112.4949,49.5323],[112.3752,49.5146],[112.0797,49.4242],[111.9345,49.416],[111.8334,49.4036],[111.7355,49.3978],[111.5748,49.3764],[111.5119,49.3609],[111.4293,49.3426],[111.3366,49.3559],[111.2042,49.3043],[110.8279,49.1662],[110.7098,49.143],[110.6311,49.1376],[110.5296,49.1871],[110.4278,49.22],[110.3214,49.2159],[110.1999,49.1704],[109.9945,49.2056],[109.7504,49.2393],[109.5287,49.2699],[109.4537,49.2963],[109.2367,49.3349],[108.9199,49.3354],[108.733,49.3356],[108.6137,49.3228],[108.5225,49.3415],[108.4069,49.3964],[108.2131,49.5248],[108.098,49.5626],[108.0338,49.594],[108.0096,49.6469],[107.9654,49.6535],[107.9367,49.691],[107.9388,49.7407],[107.9349,49.849],[107.9479,49.9247],[107.9166,49.9478],[107.7868,49.96],[107.631,49.9831],[107.3471,49.9867],[107.2333,49.9894],[107.1431,50.033],[107.0402,50.0865],[106.9413,50.1967],[106.8537,50.2483],[106.7111,50.3126],[106.5744,50.3288],[106.3685,50.3176],[106.2179,50.3046],[106.0825,50.3326],[105.9965,50.3679],[105.8752,50.4054],[105.6926,50.4142],[105.5416,50.4413],[105.3836,50.4737],[105.2667,50.4605],[105.1859,50.4296],[105.0947,50.3899],[104.977,50.3829],[104.6854,50.3418],[104.5964,50.3172],[104.4663,50.3062],[104.3539,50.2753],[104.26,50.2145],[104.1797,50.1694],[104.0787,50.1542],[103.9585,50.1573],[103.8562,50.1718],[103.8026,50.1761],[103.7232,50.1539],[103.6329,50.1386],[103.4963,50.1649],[103.4212,50.1871],[103.3044,50.2003],[103.2338,50.2643],[103.1617,50.2907],[103.0395,50.3006],[102.8597,50.3333],[102.7654,50.3666],[102.6833,50.3872],[102.5463,50.4613],[102.4694,50.5257],[102.4068,50.5362],[102.3364,50.5442],[102.2884,50.5851],[102.2857,50.6347],[102.3033,50.6655],[102.3166,50.7185],[102.2766,50.7687],[102.2351,50.7912],[102.215,50.8294],[102.2262,50.9015],[102.2103,50.9743],[102.1945,51.0507],[102.152,51.1075],[102.1424,51.2161],[102.1601,51.2608],[102.1557,51.3138],[102.1115,51.3535],[101.9792,51.3822],[101.8212,51.421],[101.5709,51.4672],[101.4644,51.4715],[101.3813,51.4526],[101.3045,51.4748],[101.2232,51.5133],[101.0854,51.553],[100.9036,51.6042],[100.7107,51.6616],[100.5362,51.7135],[100.4689,51.7261],[100.2304,51.7298],[100.0346,51.7371],[99.9217,51.7555],[99.7879,51.8275],[99.7192,51.8716],[99.6129,51.8925],[99.5323,51.8999],[99.407,51.9235],[99.1762,51.9989],[99.0914,52.0349],[99.0343,52.0354],[98.9581,52.1017],[98.8932,52.1173],[98.8486,52.0701],[98.8025,51.9575],[98.7602,51.9051],[98.6405,51.8012],[98.3527,51.7176],[98.3031,51.6743],[98.2769,51.6346],[98.2375,51.5784],[98.2199,51.5056],[98.1847,51.4857],[98.1031,51.4835],[98.0376,51.45],[97.9892,51.3771],[97.9469,51.3484],[97.9232,51.2805],[97.9273,51.2507],[97.9179,51.2179],[97.9108,51.1652],[97.8357,51.0517],[97.8253,50.9853],[97.8562,50.9434],[97.9198,50.8872],[97.9531,50.8552],[97.9642,50.8177],[97.9619,50.7691],[98.0012,50.7021],[98.0298,50.6446],[98.0789,50.6038],[98.145,50.5686],[98.2205,50.5572],[98.2795,50.5333],[98.2927,50.487],[98.2773,50.423],[98.2503,50.3024],[98.2,50.2277],[98.1701,50.1806],[98.122,50.1066],[98.1034,50.0778],[98.0039,50.0143],[97.9366,49.9968],[97.8539,49.9468],[97.7855,49.9445],[97.7207,49.9446],[97.651,49.9336],[97.5894,49.9115],[97.5408,49.8431],[97.4184,49.773],[97.3598,49.7415],[97.2086,49.7308],[97.1369,49.7617],[97.0977,49.805],[97.0491,49.8299],[96.9857,49.8828],[96.7117,49.9116],[96.6402,49.8979],[96.5984,49.8784],[96.5433,49.8925],[96.5058,49.9187],[96.4664,49.9115],[96.3812,49.896],[96.315,49.9011],[96.2297,49.9541],[96.1117,49.9825],[96.0655,49.9987],[96.0186,49.9988],[95.9896,49.9736],[95.9357,49.96],[95.8994,49.9906],[95.852,50.0129],[95.7894,50.0125],[95.7078,49.966],[95.5672,49.9438],[95.5227,49.9112],[95.4418,49.9155],[95.3856,49.9412],[95.3295,49.9441],[95.1662,49.9438],[95.1114,49.9354],[95.0443,49.9616],[95.0129,50.0083],[94.9303,50.0438],[94.8112,50.0482],[94.7181,50.0433],[94.6755,50.0281],[94.6147,50.0237],[94.5646,50.0879],[94.4969,50.1328],[94.4585,50.1657],[94.4002,50.1796],[94.3547,50.2218],[94.3469,50.3034],[94.3193,50.4049],[94.287,50.5114],[94.2511,50.5564],[94.0758,50.5729],[93.9898,50.5688],[93.7954,50.5776],[93.662,50.5837],[93.6256,50.5855],[93.5011,50.5975],[93.3868,50.6085],[93.2705,50.6156],[93.2226,50.6065],[93.1031,50.6039],[93.0099,50.6545],[92.9707,50.7125],[92.9636,50.7449],[92.9413,50.7782],[92.8564,50.7891],[92.7793,50.7787],[92.7387,50.7109],[92.6813,50.6832],[92.6267,50.6883],[92.5789,50.7254],[92.4864,50.7651],[92.4264,50.8031],[92.3548,50.8642],[92.2958,50.8498],[92.279,50.8122],[92.2653,50.7752],[92.1924,50.7006],[92.104,50.692],[91.9565,50.6976],[91.8043,50.6936],[91.7063,50.6655],[91.6342,50.6151],[91.5969,50.5755],[91.5217,50.562],[91.4465,50.5222],[91.415,50.468],[91.3408,50.4701],[91.3006,50.4634],[91.2338,50.4524],[91.0628,50.4226],[91.0216,50.4155],[90.9172,50.3642],[90.8381,50.3237],[90.7607,50.306],[90.7144,50.2594],[90.6551,50.2224],[90.5169,50.2133],[90.3648,50.1669],[90.3113,50.1512],[90.2245,50.1167],[90.1037,50.1033],[90.0537,50.0938],[90.005,50.0693],[89.9773,49.9843],[89.878,49.9535],[89.7442,49.9481],[89.6438,49.903],[89.6343,49.8233],[89.6695,49.7505],[89.6541,49.7175],[89.5792,49.6997],[89.475,49.6605],[89.3956,49.6115],[89.2992,49.6111],[89.2439,49.6271],[89.2029,49.5957],[89.18,49.5322],[89.1095,49.5014],[89.0084,49.4728],[88.9706,49.4837],[88.9454,49.5077],[88.9002,49.5397],[88.8639,49.5276],[88.8604,49.4815],[88.8316,49.4484],[88.7479,49.4462],[88.6827,49.4646],[88.6332,49.4861],[88.5443,49.4826],[88.4524,49.4727],[88.3934,49.4829],[88.3378,49.4726],[88.1926,49.4517],[88.1355,49.3815],[88.1343,49.2984],[88.1157,49.2563],[88.0285,49.2198],[87.9881,49.1869],[87.9348,49.1646],[87.8183,49.1621],[87.8143,49.1623],[87.7625,49.1658],[87.6684,49.1472],[87.5766,49.1324],[87.5158,49.1224],[87.4762,49.0915],[87.4167,49.0766],[87.3229,49.0858],[87.2969,49.1477],[87.2337,49.2162],[87.148,49.2398],[87.0706,49.2546],[87.001,49.2873],[86.9529,49.3221],[86.8121,49.4879],[86.7144,49.5586],[86.6265,49.5627],[86.6143,49.6097],[86.6653,49.6567],[86.7307,49.6956],[86.7287,49.7487],[86.6755,49.7773],[86.6102,49.7691],[86.5223,49.7078],[86.418,49.6385],[86.2924,49.5875],[86.2422,49.5463],[86.1809,49.4993],[86.093,49.5055],[86.0296,49.5034],[85.9744,49.4993],[85.9336,49.5504],[85.8805,49.5565],[85.4984,49.6054],[85.3716,49.6239],[85.2919,49.5995],[85.2326,49.6158],[85.2102,49.6648],[85.1365,49.7507],[85.0765,49.8216],[85.0008,49.8941],[84.9752,49.9511],[84.9997,50.0103],[84.9895,50.0614],[84.924,50.088],[84.839,50.0913],[84.6073,50.2024],[84.499,50.2188],[84.401,50.2392],[84.3232,50.2392],[84.2578,50.2882],[84.1945,50.4375],[84.176,50.5206],[84.0993,50.6047],[84.0023,50.6769],[83.9451,50.7747],[83.8598,50.818],[83.7178,50.8872],[83.5814,50.9357],[83.3573,50.9946],[83.2737,50.9946],[83.1603,50.9892],[83.0928,50.9606],[83.0192,50.8973],[82.919,50.8931],[82.7608,50.8934],[82.7186,50.8695],[82.693,50.8263],[82.6117,50.7715],[82.4939,50.7276],[82.3264,50.7419],[82.2119,50.7194],[82.098,50.7108],[81.9337,50.7664],[81.7521,50.7644],[81.6339,50.7391],[81.4659,50.7398],[81.4314,50.7711],[81.4516,50.8237],[81.4377,50.871],[81.4102,50.9098],[81.3883,50.9565],[81.3191,50.9664],[81.1246,50.9463],[81.0715,50.9688],[81.0775,51.0149],[81.1124,51.0724],[81.141,51.1466],[81.1272,51.1911],[81.0268,51.1857],[80.9656,51.1898],[80.9341,51.2428],[80.8773,51.2814],[80.8131,51.2835],[80.7353,51.2934],[80.6505,51.2773],[80.6055,51.2242],[80.5507,51.2166],[80.491,51.2018],[80.448,51.1833],[80.4215,51.1364],[80.4336,51.0926],[80.4522,50.9976],[80.4236,50.9463],[80.3452,50.9191],[80.2704,50.9246],[80.2202,50.9118],[80.1272,50.8583],[80.0863,50.84],[80.0721,50.8073],[80.0659,50.7582],[79.9862,50.7746],[79.8597,50.9555],[79.7164,51.16],[79.5543,51.378],[79.4688,51.4931],[79.1487,51.8681],[78.9921,52.0474],[78.7215,52.357],[78.4755,52.6384],[78.198,52.9297],[78.0335,53.095],[77.86,53.2692],[77.7994,53.3174],[77.7044,53.3792],[77.4692,53.4988],[77.1324,53.6701],[76.8207,53.8227],[76.5757,53.9425],[76.5131,53.9932],[76.4848,54.0226],[76.4586,54.0553],[76.4221,54.1135],[76.4217,54.1515],[76.6546,54.1453],[76.703,54.1825],[76.789,54.3219],[76.8373,54.4424],[76.7594,54.4369],[76.6155,54.3871],[76.5392,54.3511],[76.4965,54.3357],[76.2666,54.312],[76.1405,54.2585],[75.8807,54.168],[75.6929,54.1148],[75.6568,54.106],[75.4372,54.0896],[75.3981,54.0685],[75.3924,54.0217],[75.3771,53.9701],[75.2202,53.8938],[75.0521,53.8267],[74.989,53.8192],[74.8868,53.834],[74.8342,53.8257],[74.6814,53.7544],[74.452,53.6473],[74.4305,53.6037],[74.4293,53.5507],[74.4027,53.5044],[74.3516,53.4876],[74.2773,53.5277],[74.21,53.5765],[74.0687,53.6114],[73.859,53.6197],[73.7312,53.6028],[73.643,53.5763],[73.4699,53.4689],[73.4069,53.4476],[73.3719,53.4544],[73.3619,53.5062],[73.3269,53.5432],[73.2857,53.5984],[73.3057,53.7072],[73.3994,53.8115],[73.5542,53.8683],[73.6789,53.9294],[73.7155,53.9962],[73.7124,54.0424],[73.6664,54.0635],[73.618,54.0674],[73.5899,54.045],[73.5057,53.9993],[73.3807,53.9628],[73.2766,53.9556],[73.2299,53.9578],[73.1193,53.9808],[72.9141,54.1073],[72.741,54.1245],[72.6223,54.1343],[72.5827,54.1216],[72.5643,54.0904],[72.5756,54.0565],[72.5992,54.023],[72.5859,53.9959],[72.5303,53.9758],[72.4468,53.9418],[72.4043,53.9645],[72.383,54.0537],[72.3873,54.123],[72.3295,54.1814],[72.2691,54.2721],[72.186,54.3256],[72.1054,54.3084],[72.0656,54.2316],[72.0045,54.2057],[71.8874,54.2215],[71.6771,54.178],[71.3364,54.1583],[71.0932,54.2122],[71.0527,54.2605],[71.1521,54.3641],[71.1598,54.4554],[71.1592,54.5386],[71.1855,54.5993],[71.1263,54.715],[70.9918,54.9505],[70.9102,55.128],[70.7903,55.2611],[70.7381,55.3052],[70.4863,55.2824],[70.4172,55.2532],[70.3715,55.2123],[70.2934,55.1836],[70.1824,55.1625],[70.0874,55.1768],[69.9817,55.1991],[69.8702,55.2457],[69.7402,55.3074],[69.4933,55.3569],[69.247,55.3725],[68.9772,55.3896],[68.843,55.3583],[68.7129,55.3085],[68.5248,55.2048],[68.4385,55.1944],[68.302,55.1865],[68.2063,55.1609],[68.2253,55.1152],[68.244,55.0524],[68.2094,55.003],[68.1559,54.9767],[68.0738,54.9596],[67.9399,54.9537],[67.8299,54.9436],[67.6934,54.8724],[67.4847,54.8545],[67.2573,54.8288],[67.0983,54.7882],[66.7545,54.7379],[66.5554,54.7154],[66.2227,54.6674],[65.9547,54.6595],[65.9143,54.6933],[65.7078,54.6187],[65.477,54.6233],[65.4344,54.5933],[65.3781,54.5645],[65.3159,54.5516],[65.2374,54.5161],[65.1922,54.4411],[65.1578,54.3644],[65.0884,54.3402],[64.9954,54.3688],[64.9268,54.3966],[64.8093,54.3686],[64.6499,54.3522],[64.5251,54.3622],[64.4612,54.3842],[64.1994,54.3474],[64.0629,54.3029],[64.0374,54.2797],[64.0039,54.2671],[63.8471,54.2365],[63.7212,54.245],[63.7014,54.2432],[63.582,54.2219],[63.4137,54.1832],[63.2927,54.1705],[63.1913,54.171],[63.1266,54.1393],[63.0739,54.1052],[62.6327,54.0693],[62.5883,54.0444],[62.499,54.0132],[62.0402,54.0026],[62.0023,53.9799],[61.9856,53.9544],[61.9287,53.9465],[61.5981,53.9949],[61.3337,54.0493],[61.2311,54.0195],[61.1438,53.9638],[61.1132,53.8825],[61.1132,53.813],[61.1132,53.7535],[61.0735,53.7104],[60.9855,53.6574],[60.9795,53.6217],[61.0985,53.5831],[61.2479,53.551],[61.3361,53.5652],[61.41,53.5871],[61.4741,53.5803],[61.5191,53.5545],[61.535,53.5233],[61.5266,53.5016],[61.4985,53.4847],[61.401,53.4558],[61.3116,53.4657],[61.2289,53.4459],[61.1859,53.4062],[61.1628,53.3368],[61.1992,53.2872],[61.3109,53.2752],[61.4368,53.2394],[61.5762,53.2225],[61.6599,53.2285],[61.7662,53.1739],[62.0146,53.1079],[62.0811,53.0574],[62.0827,53.0054],[62.0371,52.9661],[61.9742,52.9438],[61.8886,52.9559],[61.7193,52.9694],[61.5336,52.9785],[61.4008,52.996],[61.2069,52.9891],[61.0475,52.9725],[61.0065,52.9333],[60.9447,52.8602],[60.8933,52.8194],[60.8023,52.7447],[60.7744,52.6758],[60.8213,52.5698],[60.9795,52.3948],[60.9945,52.3369],[60.9376,52.2806],[60.8284,52.2334],[60.6703,52.1508],[60.4993,52.1463],[60.4255,52.1256],[60.2337,52.0245],[60.0655,51.9765],[60.0303,51.9333],[60.0675,51.8906],[60.2804,51.8346],[60.3875,51.773],[60.4184,51.7039],[60.4647,51.6512],[60.6304,51.6169],[60.9735,51.5371],[60.9934,51.5287],[61.0148,51.4924],[61.3631,51.4419],[61.4113,51.4147],[61.5547,51.3246],[61.5851,51.2297],[61.5122,51.137],[61.465,50.9902],[61.3895,50.861],[61.2269,50.7748],[60.9423,50.6955],[60.638,50.6637],[60.5085,50.6692],[60.4248,50.6792],[60.2881,50.7042],[60.1867,50.7698],[60.1121,50.8342],[60.0586,50.8503],[60.0053,50.8397],[59.9552,50.7993],[59.8878,50.6902],[59.8124,50.582],[59.7512,50.5439],[59.523,50.4929],[59.4979,50.5111],[59.5239,50.5828],[59.4951,50.6043],[59.4523,50.6204],[59.1709,50.6479],[59.0644,50.6682],[58.9849,50.6761],[58.8837,50.6944],[58.8141,50.7372],[58.6646,50.8683],[58.5475,50.971],[58.3592,51.0638],[58.1885,51.0817],[58.1747,51.0723],[58.0451,51.0688],[57.8389,51.0917],[57.8289,51.089],[57.7648,51.0469],[57.717,50.981],[57.6538,50.9251],[57.5578,50.8956],[57.4422,50.8889],[57.3125,50.9465],[57.179,51.036],[57.0117,51.0652],[56.8496,51.0456],[56.7903,51.0316],[56.6202,50.9809],[56.5669,51.0045],[56.4914,51.0195],[56.3256,50.9361],[56.1439,50.8446],[56.1045,50.7763],[56.0497,50.7135],[55.9292,50.6538],[55.7977,50.6021],[55.6862,50.5829],[55.5423,50.6018],[55.3611,50.6653],[55.1952,50.7447],[55.0148,50.8698],[54.868,50.9414],[54.7271,50.9981],[54.6416,51.0116],[54.5729,50.9902],[54.5461,50.946],[54.5656,50.9113],[54.6063,50.8799],[54.6379,50.7811],[54.65,50.6602],[54.6361,50.5916],[54.5962,50.5507],[54.5553,50.5358],[54.5174,50.5412],[54.4715,50.5838],[54.4434,50.6739],[54.4215,50.7803],[54.2979,50.9141],[54.1911,50.9957],[54.1397,51.0408],[54.0415,51.1152],[53.9568,51.1612],[53.7765,51.2137],[53.6881,51.2518],[53.5347,51.3996],[53.4486,51.4445],[53.3381,51.4824],[53.2473,51.4936],[53.2273,51.485],[53.0384,51.4637],[52.9026,51.4669],[52.8205,51.4946],[52.7351,51.4979],[52.7281,51.4981],[52.6352,51.4795],[52.6178,51.4808],[52.5712,51.4816],[52.4962,51.5122],[52.423,51.5942],[52.3311,51.6813],[52.2191,51.7094],[52.0071,51.6727],[51.7754,51.5542],[51.6091,51.484],[51.4734,51.482],[51.396,51.4713],[51.3445,51.4753],[51.3011,51.4974],[51.2907,51.5402],[51.2699,51.5945],[51.1635,51.6475],[51.0179,51.6816],[50.8824,51.7192],[50.7939,51.7292],[50.7562,51.6751],[50.6439,51.5892],[50.5163,51.5056],[50.3537,51.3697],[50.3093,51.3216],[50.2469,51.2895],[50.1049,51.2546],[49.9323,51.1972],[49.8223,51.1319],[49.6663,51.1023],[49.498,51.0836],[49.4246,51.027],[49.3795,50.9347],[49.3234,50.8517],[49.0587,50.7261],[48.9138,50.6446],[48.8084,50.6013],[48.7348,50.6069],[48.6552,50.6199],[48.6251,50.6127],[48.666,50.5503],[48.7005,50.3538],[48.7494,50.2285],[48.7848,50.1564],[48.818,50.0999],[48.8433,50.0131],[48.8103,49.9624],[48.759,49.9283],[48.6,49.8747],[48.4343,49.8285],[48.335,49.8583],[48.2248,49.9319],[48.1813,49.97],[48.0607,50.0936],[47.8496,50.2823],[47.7058,50.378],[47.5996,50.4136],[47.5036,50.4027],[47.4292,50.358],[47.3764,50.3181],[47.3265,50.2735],[47.2947,50.2175],[47.2977,50.1402],[47.2952,50.0585],[47.2483,50.0009],[47.1296,49.9391],[46.992,49.8527],[46.8896,49.697],[46.8231,49.5022],[46.8021,49.3671],[46.8529,49.3039],[46.9534,49.2526],[47.0182,49.1999],[47.0313,49.1503],[47.0143,49.0983],[46.9622,49.0383],[46.8529,48.9696],[46.7026,48.8056],[46.6092,48.5739],[46.6609,48.4123],[46.8531,48.3236],[47.0043,48.2845],[47.0646,48.2325],[47.119,48.127],[47.1115,48.0201],[47.0933,47.9477],[47.1308,47.8768],[47.2021,47.7925],[47.2924,47.7409],[47.3873,47.7687],[47.4819,47.8039],[47.6002,47.79],[47.9347,47.7607],[48.11,47.7454],[48.167,47.7088],[48.2757,47.5899],[48.4131,47.4565],[48.5525,47.321],[48.6007,47.2623],[48.7144,47.1005],[48.8318,46.9549],[48.9594,46.7746],[48.9503,46.7258],[48.8836,46.7054],[48.7764,46.7104],[48.6936,46.7368],[48.6471,46.7587],[48.6053,46.7659],[48.5584,46.7571],[48.5186,46.7343],[48.5023,46.6986],[48.5092,46.65],[48.5412,46.6056],[48.586,46.5771],[48.6102,46.5665],[48.7743,46.508],[48.959,46.4421],[49.1843,46.3488],[49.2322,46.3372],[49.2459,46.2916],[49.1255,46.2817],[49.1106,46.2285],[49.0796,46.1892],[48.81,46.1005],[48.7426,46.1007],[48.6837,46.0862],[48.6873,46.0288],[48.7034,45.9762],[48.7496,45.9206],[48.7296,45.8968],[48.6896,45.8889],[48.6374,45.9058],[48.5891,45.9349],[48.5373,45.9421],[48.487,45.9349],[48.2576,45.7778],[48.1592,45.737],[48.0528,45.721],[47.8302,45.663],[47.764,45.666],[47.7011,45.6862],[47.6498,45.6567],[47.6333,45.584],[47.574,45.6343],[47.5084,45.6742],[47.4794,45.6876],[47.4633,45.6797],[47.5242,45.6017],[47.5295,45.5302],[47.5146,45.4909],[47.4887,45.4551],[47.4545,45.4331],[47.4131,45.421],[47.3911,45.2948],[47.3513,45.2177],[47.2962,45.1495],[47.2215,45.0243],[47.1615,44.9696],[47.1147,44.906],[47.0838,44.817],[47.0393,44.8379],[47.0029,44.8761],[46.9837,44.8256],[46.9574,44.7826],[46.8412,44.7183],[46.7553,44.6565],[46.7161,44.5607],[46.7072,44.5033],[46.7209,44.4517],[46.753,44.4207],[46.9157,44.3872],[47.0236,44.3433],[47.1227,44.2617],[47.2299,44.1924],[47.307,44.1031],[47.3615,43.9934],[47.4292,43.7799],[47.4628,43.555],[47.5626,43.8347],[47.6465,43.8846],[47.6278,43.806],[47.568,43.685],[47.509,43.5097],[47.4898,43.3817],[47.5116,43.2708],[47.5129,43.2188],[47.4632,43.0351],[47.4889,42.9998],[47.529,42.9671],[47.6349,42.9035],[47.7091,42.8109],[47.7277,42.6807],[47.7697,42.6448],[47.8224,42.6135],[48.0802,42.3537],[48.2286,42.181],[48.303,42.0802],[48.3838,41.9534],[48.4264,41.924],[48.4768,41.9051],[48.5729,41.8445],[48.5187,41.7793],[48.4307,41.6633],[48.3914,41.6019],[48.2981,41.545],[48.1423,41.4848],[48.0561,41.4587],[47.9637,41.334],[47.8611,41.2127],[47.791,41.1993],[47.5918,41.2181],[47.5206,41.2291],[47.3177,41.2824],[47.2611,41.3151],[47.2053,41.4556],[47.1426,41.5161],[47.064,41.5547],[47.0102,41.5875],[46.9878,41.6214],[46.9309,41.6704],[46.8256,41.7434],[46.7493,41.8126],[46.6903,41.8313],[46.616,41.8069],[46.5713,41.8001],[46.5521,41.8123],[46.5377,41.8704],[46.4299,41.891],[46.4115,41.9046],[46.2678,41.9604],[46.2127,41.9899],[46.1598,41.992],[46.0484,42.0087],[45.954,42.0354],[45.9104,42.0707],[45.846,42.11],[45.7266,42.1589],[45.6386,42.2051],[45.6343,42.2347],[45.6884,42.3574],[45.7275,42.475],[45.7053,42.4981],[45.6556,42.5177],[45.5629,42.5357],[45.3438,42.5298],[45.2082,42.6482],[45.1603,42.675],[45.0716,42.6941],[44.9434,42.7303],[44.871,42.7564],[44.8505,42.7468],[44.7711,42.6168],[44.6918,42.7096],[44.6443,42.7347],[44.5765,42.7485],[44.5059,42.7486],[44.3295,42.7035],[44.1997,42.6536],[44.1027,42.6164],[44.0047,42.5956],[43.9574,42.5666],[43.826,42.5715],[43.7599,42.5938],[43.7384,42.617],[43.7499,42.6575],[43.7954,42.703],[43.7987,42.7278],[43.7826,42.747],[43.623,42.8077],[43.5578,42.8445],[43.3479,42.8967],[43.0892,42.9891],[43.0002,43.0497],[42.9916,43.0915],[42.89,43.1326],[42.7606,43.1696],[42.6603,43.1591],[42.566,43.1551],[42.419,43.2242],[42.2797,43.2281],[42.1223,43.2073],[42.0878,43.1991],[42.05,43.1901],[41.5806,43.2192],[41.4607,43.2763],[41.3582,43.3334],[41.0831,43.3745],[40.942,43.4181],[40.8017,43.4799],[40.648,43.5339],[40.5189,43.512],[40.3423,43.5427],[40.1502,43.5698],[40.0846,43.5531],[40.0237,43.4849],[39.9783,43.4198],[39.8736,43.4728],[39.5167,43.7279],[39.3294,43.8973],[38.7173,44.2881],[38.6358,44.318],[38.3118,44.3745],[38.1813,44.4197],[37.8515,44.6988],[37.7049,44.6614],[37.5725,44.6708],[37.4951,44.6953],[37.4113,44.7354],[37.3523,44.7884],[37.2841,44.905],[37.2048,44.972],[36.9444,45.0696],[36.6508,45.1265],[36.6276,45.1513],[36.6191,45.1855],[36.873,45.2518],[36.9412,45.2897],[36.811,45.34],[36.7616,45.3483],[36.7204,45.3719],[36.7938,45.4097],[36.8659,45.4271],[36.9778,45.3836],[37.1035,45.3029],[37.2136,45.2723],[37.2643,45.3109],[37.6472,45.3772],[37.6729,45.4297],[37.6719,45.4884],[37.6344,45.4863],[37.61,45.4995],[37.6124,45.5647],[37.6692,45.6541],[37.8409,45.7996],[37.9331,46.0017],[38.0143,46.0478],[38.0738,46.0171],[38.0697,45.9699],[38.0796,45.9348],[38.1328,46.0028],[38.1836,46.0948],[38.3118,46.0954],[38.4004,46.08],[38.4923,46.0905],[38.3152,46.2419],[38.0777,46.3943],[37.9775,46.3829],[37.9139,46.4065],[37.8096,46.5321],[37.7665,46.6361],[37.8674,46.6338],[37.968,46.618],[38.1595,46.6907],[38.23,46.7013],[38.3435,46.6783],[38.501,46.6637],[38.488,46.7322],[38.4387,46.8131],[38.6308,46.873],[38.8011,46.9062],[39.1268,47.0234],[39.2707,47.0441],[39.2891,47.0709],[39.2935,47.1058],[39.2445,47.1995],[39.1957,47.2688],[39.0237,47.2722],[38.9283,47.1757],[38.6682,47.1439],[38.5524,47.1503],[38.6443,47.2122],[38.736,47.2358],[38.7619,47.2616],[38.5772,47.2391],[38.4848,47.1755],[38.2144,47.0915],[38.2059,47.1356],[38.2014,47.1752],[38.2212,47.2127],[38.2653,47.237],[38.2808,47.259],[38.2808,47.2767],[38.241,47.2877],[38.208,47.2965],[38.2014,47.3208],[38.2124,47.3428],[38.2433,47.3737],[38.2565,47.4089],[38.2588,47.4795],[38.2874,47.5592],[38.3688,47.61],[38.5109,47.6224],[38.6406,47.6659],[38.7189,47.7141],[38.8223,47.837],[38.9003,47.8551],[39.0578,47.8485],[39.1585,47.8374],[39.391,47.8337],[39.6585,47.8412],[39.7359,47.8448],[39.7787,47.8875],[39.7758,47.9645],[39.814,48.0353],[39.8851,48.1684],[39.961,48.2379],[39.9579,48.2689],[39.9182,48.2819],[39.8663,48.2884],[39.8475,48.3028],[39.8499,48.3319],[39.8898,48.3604],[39.8826,48.4191],[39.8575,48.4842],[39.8356,48.5428],[39.7654,48.5719],[39.6447,48.5912],[39.6704,48.6625],[39.7046,48.7394],[39.7559,48.7821],[39.7929,48.8077],[39.9041,48.7938],[39.9845,48.8074],[40.0036,48.8221],[39.9892,48.8514],[39.8638,48.878],[39.7533,48.9145],[39.7057,48.9596],[39.6865,49.0079],[39.7595,49.0366],[39.8897,49.0641],[39.9764,49.1298],[40.07,49.2003],[40.1088,49.2516],[40.1283,49.3072],[40.1262,49.3688],[40.0578,49.4315],[40.0578,49.4971],[40.0949,49.5427],[40.0807,49.5769],[40.0307,49.5967],[39.9585,49.5908],[39.8769,49.5677],[39.7806,49.572],[39.6266,49.6507],[39.4628,49.728],[39.3685,49.7307],[39.3029,49.742],[39.246,49.7819],[39.2118,49.8332],[39.1748,49.856],[39.1149,49.8417],[39.0277,49.8184],[38.9184,49.8247],[38.7767,49.8843],[38.6478,49.9529],[38.552,49.9546],[38.4512,49.9641],[38.2586,50.0523],[38.2087,50.0515],[38.1775,50.0254],[38.1627,49.9545],[38.1468,49.9394],[38.1125,49.9278],[38.0469,49.92],[37.9503,49.9642],[37.7042,50.1091],[37.6051,50.2149],[37.5823,50.2918],[37.5014,50.3407],[37.4229,50.4115],[37.3432,50.4176],[37.2549,50.395],[37.1711,50.3609],[37.1312,50.3515],[36.9885,50.3396],[36.7591,50.2918],[36.6964,50.2462],[36.6194,50.2092],[36.5597,50.2349],[36.4998,50.2805],[36.3688,50.2968],[36.3061,50.2805],[36.2434,50.3118],[36.1895,50.3678],[36.1164,50.4085],[36.0078,50.4197],[35.8902,50.4371],[35.7962,50.4058],[35.6737,50.346],[35.5911,50.3688],[35.5455,50.44],[35.4885,50.4599],[35.4116,50.5397],[35.3917,50.6109],[35.4116,50.6422],[35.4401,50.6821],[35.4401,50.7277],[35.4174,50.7676],[35.3832,50.7989],[35.3461,50.9043],[35.3147,50.9499],[35.3091,50.9869],[35.3348,51.0211],[35.3119,51.0439],[35.2691,51.0468],[35.198,51.0439],[35.1581,51.061],[35.1153,51.1208],[35.0926,51.1807],[35.0641,51.2034],[34.9902,51.2018],[34.8686,51.1892],[34.7604,51.1693],[34.7123,51.1722],[34.6168,51.2031],[34.491,51.2371],[34.2342,51.2438],[34.2139,51.2554],[34.2284,51.2769],[34.2807,51.3117],[34.275,51.3402],[34.2299,51.3632],[34.2065,51.4199],[34.2093,51.4841],[34.2009,51.5538],[34.1468,51.608],[34.1154,51.645],[34.1211,51.6792],[34.2392,51.6922],[34.3793,51.7165],[34.4027,51.7415],[34.3979,51.7804],[34.1131,51.9796],[34.0153,52.156],[33.9221,52.2515],[33.8188,52.3156],[33.7353,52.3448],[33.6134,52.3326],[33.4519,52.3338],[33.2871,52.3536],[33.1484,52.3404],[32.8997,52.2563],[32.8064,52.2526],[32.6454,52.2791],[32.5079,52.3085],[32.4354,52.3072],[32.3913,52.2948],[32.363,52.2721],[32.2828,52.114],[32.2168,52.083],[32.1223,52.0506],[32.0416,52.045],[31.9738,52.0466],[31.8756,52.0709],[31.7824,52.0994],[31.7634,52.1011],[31.7586,52.1258],[31.6906,52.2207],[31.6499,52.2622],[31.6016,52.2848],[31.5773,52.3123],[31.5766,52.426],[31.5855,52.5325],[31.6159,52.5462],[31.5262,52.633],[31.5194,52.6987],[31.5635,52.7314],[31.5648,52.7592],[31.5352,52.7982],[31.4428,52.8618],[31.353,52.9334],[31.2951,52.9898],[31.2588,53.0167],[31.3029,53.0609],[31.3646,53.139],[31.3884,53.1848],[31.4179,53.196],[31.563,53.2025],[31.6683,53.2009],[31.7475,53.1842],[31.7774,53.1469],[31.8497,53.1062],[32.0555,53.0895],[32.142,53.0912],[32.2507,53.1284],[32.4263,53.2106],[32.4693,53.2703],[32.578,53.3124],[32.6444,53.3289],[32.7043,53.3363],[32.7103,53.3714],[32.7064,53.4194],[32.6857,53.4481],[32.4696,53.547],[32.4424,53.5792],[32.4252,53.6173],[32.451,53.6533],[32.4502,53.6929],[32.2004,53.7813],[31.9922,53.7969],[31.8208,53.7919],[31.7542,53.8104],[31.783,53.855],[31.8253,53.935],[31.8378,54.0008],[31.826,54.0307],[31.792,54.0559],[31.6284,54.1112],[31.4036,54.1959],[31.2991,54.2917],[31.2455,54.3917],[31.1848,54.453],[31.0748,54.4918],[31.0819,54.5171],[31.1549,54.6109],[31.1521,54.6253],[31.1213,54.6485],[30.9842,54.6959],[30.7988,54.7833],[30.791,54.806],[30.8045,54.8609],[30.8299,54.915],[30.8668,54.9407],[30.9777,55.0505],[30.9777,55.0878],[30.9589,55.1376],[30.8774,55.2234],[30.8145,55.2787],[30.8105,55.307],[30.821,55.3303],[30.8618,55.3604],[30.9006,55.3974],[30.9088,55.5253],[30.9068,55.57],[30.8822,55.5964],[30.856,55.6075],[30.8008,55.6011],[30.7217,55.6221],[30.6623,55.6555],[30.6256,55.6663],[30.5867,55.7003],[30.4754,55.7688],[30.4563,55.7868],[30.2336,55.8452],[30.0427,55.8364],[29.937,55.8453],[29.8816,55.8323],[29.8239,55.7951],[29.7441,55.7704],[29.6846,55.7697],[29.6301,55.7512],[29.4822,55.6846],[29.413,55.7249],[29.3534,55.7844],[29.3731,55.8347],[29.3979,55.8811],[29.3961,55.9122],[29.375,55.9387],[29.283,55.9679],[29.0874,56.0211],[29.0317,56.0218],[28.9475,56.0021],[28.7947,55.9426],[28.7408,55.9554],[28.6908,56.0026],[28.6369,56.0618],[28.564,56.092],[28.407,56.089],[28.3921,56.0867],[28.3163,56.0525],[28.2843,56.0559],[28.1479,56.1429],[28.1733,56.1903],[28.2021,56.2604],[28.1917,56.3156],[28.1692,56.3869],[28.1108,56.5107],[28.1031,56.5457],[28.0075,56.5999],[27.9916,56.6453],[27.9414,56.7037],[27.8921,56.7411],[27.8815,56.8242],[27.8486,56.8534],[27.8061,56.8671],[27.6557,56.8432],[27.6395,56.8457],[27.7111,56.9781],[27.7174,57.0546],[27.7628,57.1351],[27.8146,57.1669],[27.8303,57.1945],[27.8383,57.2477],[27.8286,57.2933],[27.7969,57.3169],[27.6728,57.3681],[27.5387,57.4298],[27.5111,57.5082],[27.4697,57.524],[27.352,57.5281],[27.3543,57.5503],[27.3718,57.6125],[27.4,57.6668],[27.492,57.725],[27.5147,57.7642],[27.5421,57.7994],[27.7528,57.841],[27.777,57.8567],[27.7785,57.8707],[27.7688,57.8841],[27.722,57.9055],[27.6734,57.9346],[27.6441,58.0139],[27.5711,58.1381],[27.5024,58.2213],[27.4878,58.2701],[27.5056,58.3263],[27.5301,58.3815],[27.5313,58.4353],[27.4271,58.7331],[27.4342,58.7873],[27.4645,58.8413],[27.5131,58.8863],[27.6218,58.945],[27.7576,59.052],[27.8495,59.1927],[27.8977,59.2776],[27.9382,59.297],[28.0164,59.3017],[28.0461,59.3278],[28.0613,59.3433],[28.1283,59.3576],[28.1511,59.3744],[28.133,59.4031],[28.0658,59.4532],[28.0125,59.4843],[28.064,59.554],[28.0463,59.6472],[28.014,59.7248],[28.058,59.7815],[28.1312,59.7865],[28.2125,59.7247],[28.3346,59.6925],[28.4237,59.7341],[28.4539,59.8143],[28.5182,59.8496],[28.6039,59.8181],[28.7477,59.8067],[28.8669,59.8119],[28.9473,59.8288],[28.9815,59.8548],[29.0134,59.9016],[29.0791,59.961],[29.1473,59.9998],[29.6697,59.9557],[30.1226,59.8736],[30.1568,59.9043],[30.1727,59.9571],[30.06,60.0026],[29.9768,60.0264],[29.8723,60.1208],[29.7212,60.1953],[29.5693,60.2019],[29.3704,60.1759],[29.0691,60.1915],[28.8127,60.3315],[28.6432,60.3753],[28.5223,60.483],[28.4916,60.5401],[28.6225,60.4916],[28.6403,60.5429],[28.6506,60.611],[28.5778,60.6525],[28.5128,60.6773],[28.1793,60.571],[27.7977,60.5361],[28.152,60.7458],[28.4074,60.8969],[28.4551,60.9196],[28.5682,60.9602],[28.6629,61.0028],[28.7391,61.0587],[28.993,61.169],[29.2517,61.2878],[29.4924,61.4442],[29.5794,61.4935],[29.6901,61.5461],[29.9332,61.7116],[30.01,61.7574],[30.3064,61.9648],[30.4797,62.0682],[30.5656,62.1276],[30.9357,62.3238],[31.1867,62.4814],[31.2856,62.5678],[31.3824,62.6917],[31.4373,62.7761],[31.534,62.8854],[31.5365,62.9216],[31.5093,62.9553],[31.437,63.0077],[31.3367,63.0681],[31.2475,63.1419],[31.1809,63.2083],[30.9748,63.3006],[30.6553,63.4175],[30.4186,63.5041],[30.0554,63.689],[29.9915,63.7352],[30.0041,63.7473],[30.2103,63.8033],[30.4153,63.9475],[30.5039,64.0206],[30.5261,64.0773],[30.5279,64.1411],[30.5138,64.2],[30.4879,64.2365],[30.3906,64.2824],[30.1081,64.3661],[30.0419,64.4434],[29.9866,64.5243],[29.9855,64.5577],[30.1201,64.6446],[30.1262,64.6881],[30.1103,64.7326],[30.0729,64.765],[29.7832,64.8043],[29.7017,64.8458],[29.6375,64.9118],[29.6042,64.9684],[29.6009,65.002],[29.6225,65.0395],[29.72,65.0803],[29.8108,65.1079],[29.827,65.1451],[29.8262,65.1853],[29.8105,65.2047],[29.6297,65.2239],[29.6124,65.2348],[29.608,65.2487],[29.6172,65.2653],[29.7148,65.337],[29.728,65.4734],[29.8194,65.5688],[29.7159,65.6246],[29.7239,65.6344],[29.8826,65.6636],[30.029,65.6707],[30.0953,65.6817],[30.1027,65.7263],[30.0875,65.7865],[29.9366,66.0229],[29.9034,66.0911],[29.8035,66.1771],[29.7207,66.2349],[29.6709,66.2761],[29.5907,66.3568],[29.5443,66.4397],[29.4644,66.5322],[29.3712,66.617],[29.2933,66.6955],[29.0931,66.8492],[29.0662,66.8917],[29.069,66.9302],[29.087,66.9709],[29.2434,67.0966],[29.3877,67.2014],[29.5723,67.3244],[29.7506,67.4264],[29.9412,67.5475],[29.9881,67.6683],[29.9792,67.6886],[29.8216,67.754],[29.5242,67.9291],[29.3438,68.0619],[29.063,68.118],[28.6852,68.1898],[28.5602,68.3514],[28.4707,68.4884],[28.4793,68.5376],[28.7521,68.7714],[28.7776,68.8138],[28.7729,68.84],[28.7448,68.8564],[28.706,68.8655],[28.4535,68.8723],[28.4141,68.9042],[28.566,68.9282],[28.6922,68.961],[28.8989,69.0097],[28.9658,69.022],[29.1186,69.05],[29.1709,69.0715],[29.21,69.097],[29.353,69.2706],[29.3883,69.2981],[29.8327,69.3604],[29.994,69.3925],[30.0873,69.4329],[30.1318,69.4643],[30.1638,69.5016],[30.1867,69.5428],[30.1965,69.5806],[30.1598,69.6299],[30.1802,69.6358],[30.2275,69.6338],[30.3797,69.5847],[30.6154,69.5326],[30.7889,69.5285],[30.8607,69.5384],[30.8967,69.5612],[30.9225,69.6058],[30.9241,69.6518],[30.8697,69.7834],[31.0495,69.7692],[31.4527,69.6896],[31.547,69.6969],[31.6662,69.721],[31.7886,69.8158],[31.8794,69.832],[31.9979,69.8099],[32.0306,69.8353],[31.9693,69.9139],[31.9846,69.9537],[32.3916,69.8687],[32.5654,69.8065],[32.9417,69.7519],[33.0078,69.7221],[33.0126,69.6705],[32.9946,69.6262],[32.915,69.6017],[32.7543,69.6057],[32.1768,69.674],[32.0915,69.6326],[32.1613,69.5966],[32.3306,69.5542],[32.3777,69.4791],[32.6368,69.4895],[32.8838,69.4608],[32.9998,69.4701],[33.021,69.4456],[32.9416,69.3833],[32.9789,69.3673],[33.2559,69.4277],[33.3849,69.4443],[33.4543,69.4282],[33.4637,69.3782],[33.418,69.3153],[33.413,69.2674],[33.3277,69.1519],[33.1964,69.1168],[33.1412,69.0687],[33.3334,69.0982],[33.4356,69.1304],[33.6271,69.2892],[33.6844,69.3103],[34.2294,69.3131],[34.3527,69.3029],[34.864,69.2281],[35.0096,69.2212],[35.1759,69.2308],[35.2332,69.2656],[35.2898,69.2754],[35.8579,69.1917],[36.6183,69.0035],[37.7306,68.6921],[38.3576,68.4151],[38.4302,68.3556],[38.6568,68.3219],[38.7056,68.3447],[38.8315,68.3249],[39.5689,68.0717],[39.8233,68.0586],[39.7897,68.1122],[39.7463,68.1622],[39.8093,68.1508],[39.8956,68.1145],[40.0357,68.0154],[40.2066,67.9419],[40.3807,67.8319],[40.5258,67.7897],[40.6565,67.7741],[40.7663,67.743],[40.9664,67.7135],[41.0609,67.4442],[41.1339,67.386],[41.1339,67.2669],[41.2617,67.2185],[41.3588,67.2097],[41.3543,67.1214],[41.2756,66.9143],[41.189,66.8262],[40.5216,66.4466],[40.1033,66.3],[39.2891,66.132],[38.6539,66.069],[38.3976,66.0645],[37.9007,66.0956],[37.6282,66.1296],[37.2948,66.225],[36.9837,66.2726],[36.7699,66.2936],[36.3734,66.3023],[35.5135,66.3958],[35.364,66.4287],[34.8246,66.6111],[34.6103,66.5596],[34.4826,66.5503],[34.3961,66.6132],[34.4309,66.6298],[34.4516,66.6512],[34.1461,66.7033],[33.8937,66.7067],[33.7596,66.751],[33.5954,66.7846],[33.5229,66.7644],[33.482,66.7646],[33.1502,66.8439],[33.002,66.9083],[32.8476,67.0215],[32.8853,67.0611],[32.9305,67.0868],[32.3999,67.1527],[31.8953,67.1614],[31.983,67.1298],[32.2016,67.1132],[32.3406,67.0679],[32.501,67.0039],[32.4637,66.9163],[32.6864,66.8295],[32.8573,66.7469],[32.8624,66.7214],[32.9287,66.7041],[33.1806,66.6799],[33.2244,66.6039],[33.1829,66.5739],[33.2174,66.5316],[33.4053,66.4843],[33.5177,66.4714],[33.656,66.4426],[33.5933,66.3846],[33.477,66.3469],[33.3605,66.3295],[33.4158,66.3156],[33.5667,66.321],[34.1127,66.2252],[34.3998,66.1284],[34.6918,65.9519],[34.7863,65.8646],[34.7932,65.8164],[34.777,65.7683],[34.7348,65.7163],[34.7155,65.6641],[34.6157,65.5099],[34.5441,65.4567],[34.4064,65.3958],[34.5359,65.2779],[34.6711,65.1681],[34.8035,64.986],[34.8271,64.9127],[34.8326,64.8002],[34.9522,64.756],[34.9055,64.7387],[34.8583,64.7067],[34.8695,64.56],[35.0354,64.4402],[35.2841,64.3625],[35.432,64.3468],[35.6471,64.3783],[35.8021,64.3354],[36.1465,64.189],[36.302,64.0344],[36.3649,64.0028],[36.7138,63.9451],[36.9752,63.9095],[37.3728,63.8167],[37.4422,63.8134],[37.6354,63.8934],[37.968,63.9491],[38.0708,64.0258],[38.0622,64.091],[37.9771,64.207],[37.9537,64.3201],[37.8436,64.3663],[37.7406,64.397],[37.4296,64.3736],[37.2896,64.3779],[37.1837,64.4085],[37.0404,64.4892],[36.7693,64.6853],[36.6242,64.7505],[36.5787,64.791],[36.5282,64.8474],[36.5346,64.9386],[36.6529,64.9354],[36.7859,64.9872],[36.8828,65.1724],[37.0502,65.1959],[37.1408,65.1943],[37.5281,65.1083],[38.0094,64.8788],[38.1157,64.8546],[38.2282,64.8512],[38.4121,64.8571],[38.442,64.8271],[38.5409,64.7913],[38.6131,64.7867],[39.0535,64.7139],[39.5674,64.5706],[39.758,64.5771],[39.833,64.6564],[39.8486,64.6905],[40.0578,64.7708],[40.2037,64.784],[40.4078,64.7549],[40.4449,64.7787],[40.3754,64.8963],[40.2813,64.9981],[40.1427,65.0633],[39.8965,65.2548],[39.798,65.3499],[39.7491,65.4479],[39.7812,65.5347],[39.8165,65.5979],[40.3278,65.7517],[40.5128,65.8438],[40.6916,65.9634],[40.7744,65.9879],[41.0761,66.0211],[41.4758,66.1234],[41.7809,66.2593],[42.0836,66.4659],[42.2105,66.5197],[42.3137,66.5147],[42.4508,66.4824],[42.6021,66.4225],[42.8065,66.4113],[43.006,66.4209],[43.2332,66.4155],[43.5509,66.3213],[43.6033,66.2912],[43.6531,66.251],[43.5504,66.1734],[43.5419,66.1234],[43.6239,66.1467],[43.737,66.1584],[43.8437,66.1424],[43.9441,66.0987],[44.0167,66.0498],[44.1044,66.0086],[44.1324,66.0646],[44.1453,66.1127],[44.0972,66.2351],[44.2207,66.4071],[44.3164,66.4817],[44.4887,66.6718],[44.4371,66.7946],[44.4293,66.9377],[44.4039,67.0042],[44.2918,67.0997],[44.0744,67.1673],[43.8554,67.1886],[43.7824,67.2545],[43.7957,67.3296],[43.8563,67.4393],[44.0364,67.6707],[44.2254,67.9956],[44.2315,68.0712],[44.2139,68.1126],[44.2265,68.1544],[44.2047,68.2538],[44.1691,68.3271],[43.404,68.6085],[43.358,68.6358],[43.3332,68.6734],[43.4133,68.6817],[43.472,68.6798],[44.048,68.5488],[44.1753,68.5417],[45.0781,68.5782],[45.5194,68.5465],[45.892,68.4797],[46.1584,68.2914],[46.4297,68.1188],[46.6836,67.9705],[46.6904,67.8488],[46.4289,67.8237],[46.1742,67.8182],[45.5287,67.7576],[45.3741,67.6889],[44.9395,67.4774],[44.9021,67.4131],[44.9395,67.3508],[45.1389,67.2847],[45.5622,67.1856],[45.7525,66.9892],[45.8854,66.8911],[45.986,66.8531],[46.084,66.8435],[46.2978,66.8428],[46.4485,66.819],[46.4924,66.8002],[46.5523,66.819],[46.6908,66.8255],[47.4965,66.9298],[47.6559,66.9759],[47.7091,67.045],[47.7681,67.2756],[47.8393,67.3557],[47.9082,67.4547],[47.8826,67.5153],[47.8747,67.5842],[48.2787,67.6504],[48.6538,67.6953],[48.8332,67.6815],[48.8779,67.7313],[48.7627,67.827],[48.6957,67.8742],[48.7543,67.8959],[48.8406,67.8697],[48.9539,67.8538],[49.1553,67.8704],[49.9313,68.0651],[50.2332,68.1753],[50.4141,68.2184],[50.6994,68.3177],[50.8389,68.35],[51.0785,68.3633],[51.3361,68.4024],[51.6167,68.4763],[51.9947,68.5388],[52.0557,68.5413],[52.1288,68.532],[52.2854,68.4594],[52.2274,68.4186],[52.1835,68.3743],[52.2592,68.3509],[52.3223,68.3397],[52.3967,68.3517],[52.475,68.3821],[52.6697,68.4268],[52.7227,68.484],[52.6477,68.5062],[52.5501,68.5924],[52.4351,68.6102],[52.344,68.6082],[52.6836,68.7312],[53.4129,68.9125],[53.802,68.9959],[54.1858,69.0033],[54.4912,68.9923],[54.3763,68.9647],[53.8744,68.9266],[53.7977,68.9075],[53.7982,68.8847],[53.9195,68.8712],[53.9706,68.8443],[53.9293,68.8119],[53.8912,68.8015],[53.8339,68.7089],[53.7589,68.634],[53.9177,68.537],[53.9309,68.4355],[53.8295,68.3827],[53.69,68.4025],[53.5667,68.3671],[53.3426,68.3432],[53.2934,68.3117],[53.2605,68.2675],[53.4031,68.2568],[53.5151,68.2597],[53.9137,68.2312],[53.9679,68.2273],[54.0992,68.259],[54.2329,68.2663],[54.3939,68.2751],[54.4762,68.2941],[54.5612,68.273],[54.718,68.1842],[54.8613,68.2019],[54.923,68.3738],[55.1509,68.48],[55.4181,68.5678],[55.6753,68.5759],[55.9246,68.6373],[56.0437,68.6489],[56.2757,68.6241],[56.6202,68.619],[56.9094,68.5667],[57.1269,68.554],[57.4443,68.6415],[58.173,68.8897],[58.237,68.8339],[58.3539,68.9162],[58.9189,69.0038],[59.0573,69.0061],[59.0599,68.9726],[59.1102,68.8963],[59.2204,68.8496],[59.3705,68.7384],[59.2983,68.7084],[59.2226,68.6913],[59.1123,68.6163],[59.099,68.4443],[59.3107,68.4003],[59.6043,68.3511],[59.7257,68.3516],[59.8275,68.3803],[59.8588,68.396],[59.8974,68.4219],[59.9229,68.4713],[59.9414,68.5105],[59.8651,68.6049],[59.896,68.7063],[60.1603,68.6995],[60.4892,68.729],[60.6377,68.787],[60.8151,68.8952],[60.9336,68.9868],[60.8586,69.1455],[60.6646,69.1103],[60.3373,69.457],[60.1706,69.5909],[60.2765,69.6526],[60.5587,69.6923],[60.813,69.8211],[60.9091,69.8471],[61.0159,69.8515],[61.7705,69.763],[62.6313,69.7431],[63.3614,69.6753],[64.1904,69.5347],[64.5922,69.4356],[64.9285,69.3254],[64.8963,69.2478],[65.0315,69.2698],[65.3268,69.2014],[65.5279,69.1734],[65.7357,69.1323],[65.8127,69.077],[66.0848,69.0363],[66.3656,68.9613],[66.4161,68.9479],[66.7564,68.892],[67.0024,68.8736],[67.1492,68.754],[67.6396,68.5793],[67.7308,68.5137],[68.1569,68.4037],[68.3712,68.3143],[68.5042,68.3484],[68.8295,68.5674],[69.0243,68.818],[69.1405,68.9506],[68.9244,68.9562],[68.7629,68.9174],[68.6596,68.9274],[68.5428,68.9671],[68.3551,69.0676],[68.1174,69.2362],[68.073,69.4208],[68.0059,69.48],[67.7743,69.53],[67.6241,69.5844],[67.0645,69.6937],[66.9641,69.6556],[66.9342,69.5967],[66.8967,69.5538],[66.8402,69.6092],[66.804,69.6592],[66.8029,69.7401],[66.8322,69.8422],[66.9264,70.0143],[67.069,70.0056],[67.1444,70.0306],[67.2393,70.1081],[67.1975,70.1716],[67.1465,70.2199],[67.1568,70.2951],[67.2469,70.5001],[67.2848,70.7387],[67.2115,70.7984],[67.1434,70.8375],[66.8225,70.7974],[66.7022,70.8185],[66.6752,70.8647],[66.6661,70.9006],[66.7588,70.9624],[66.8471,71.0637],[66.6926,71.0417],[66.6396,71.0814],[66.7681,71.1399],[66.9176,71.2824],[67.2742,71.3479],[67.5418,71.412],[67.9594,71.5484],[68.2692,71.6828],[68.4694,71.8526],[68.6074,72.0127],[68.8297,72.3916],[69.0391,72.6699],[69.3914,72.9555],[69.6118,72.9819],[69.6943,72.9775],[69.709,72.9564],[69.6588,72.9318],[69.6451,72.8976],[69.7383,72.885],[69.8875,72.8826],[70.1722,72.9012],[70.6554,72.8904],[71.5002,72.9137],[71.617,72.9021],[71.9296,72.8197],[72.101,72.829],[72.4464,72.7903],[72.6338,72.7445],[72.8121,72.6914],[72.7874,72.483],[72.7529,72.3432],[72.6244,72.0794],[72.5741,72.0125],[72.375,71.8216],[72.2795,71.6955],[72.1297,71.6092],[71.912,71.5479],[71.8844,71.5114],[71.8673,71.4574],[72.0793,71.3067],[72.5813,71.1511],[72.7045,70.9632],[72.7316,70.8229],[72.7,70.4573],[72.6533,70.4034],[72.5619,70.3456],[72.4694,70.275],[72.5297,70.1725],[72.5994,69.7932],[72.6156,69.484],[72.5573,69.3784],[72.5271,69.1542],[72.5273,69.0805],[72.5768,68.9687],[72.6783,68.8749],[72.8119,68.8152],[73.1907,68.7068],[73.548,68.5745],[73.5734,68.5326],[73.5917,68.4819],[73.4652,68.4308],[73.2664,68.2945],[73.1395,68.1813],[73.1294,68.0909],[73.173,67.973],[73.1521,67.865],[73.0668,67.7669],[72.9487,67.6962],[72.5943,67.587],[71.8475,67.0076],[71.6682,66.9397],[71.3652,66.9615],[71.4489,66.879],[71.5512,66.7604],[71.5396,66.6831],[71.342,66.6867],[71.0656,66.6045],[70.9395,66.5481],[70.7249,66.5194],[70.5614,66.5487],[70.3828,66.6025],[70.4089,66.6476],[70.4426,66.6683],[70.568,66.7009],[70.6907,66.7453],[70.6308,66.7542],[70.5791,66.7538],[70.4439,66.6973],[70.2834,66.6858],[70.0937,66.7543],[69.9486,66.83],[69.8771,66.8455],[69.7404,66.8146],[69.2178,66.8286],[69.0787,66.8159],[69.0135,66.7883],[69.0512,66.7664],[69.0911,66.7236],[69.1439,66.6407],[69.1943,66.5787],[69.412,66.5107],[69.701,66.4846],[69.9824,66.4014],[70.3395,66.3424],[71.1455,66.3667],[71.358,66.3594],[71.5656,66.3337],[71.917,66.2467],[72.0676,66.2533],[72.3216,66.3321],[72.384,66.5065],[72.4174,66.5608],[73.3416,66.8068],[73.5136,66.8611],[73.7921,66.9953],[73.8833,67.085],[73.9862,67.3277],[74.0745,67.4141],[74.6761,67.6946],[74.7695,67.7664],[74.7873,67.8975],[74.7782,67.9859],[74.7427,68.0735],[74.6324,68.2183],[74.5112,68.3031],[74.3914,68.4206],[74.481,68.6589],[74.5796,68.7512],[75.1246,68.8617],[75.5896,68.9012],[76.1075,68.9757],[76.316,68.9915],[76.4592,68.9783],[76.6058,68.8976],[76.7351,68.7769],[77.1117,68.5962],[77.2385,68.4696],[77.261,68.3156],[77.2484,67.941],[77.1744,67.7785],[77.3251,67.7356],[77.3956,67.6987],[77.5792,67.6439],[77.6751,67.5896],[77.7716,67.5703],[77.9855,67.5592],[78.5896,67.5785],[78.9225,67.5891],[78.8876,67.6131],[78.8391,67.6312],[78.5591,67.6391],[78.1612,67.6784],[77.5883,67.7519],[77.5201,67.9096],[77.5359,68.0077],[77.6648,68.1904],[77.7568,68.2224],[77.8683,68.2347],[77.9951,68.2595],[77.9587,68.3771],[77.9068,68.4823],[77.7853,68.6305],[77.6507,68.903],[77.4663,68.9051],[77.3283,68.9586],[76.6449,69.1174],[76.001,69.2351],[75.5611,69.2518],[75.42,69.2386],[75.0535,69.1163],[74.8148,69.0906],[74.3626,69.1446],[73.9774,69.1146],[73.836,69.1432],[73.7757,69.1982],[73.8909,69.418],[73.8327,69.5039],[73.6633,69.6171],[73.5602,69.7072],[73.5781,69.803],[73.8302,70.1757],[73.9374,70.2729],[74.2067,70.4455],[74.3434,70.5787],[74.3109,70.6536],[73.7315,71.0687],[73.5766,71.2165],[73.5072,71.2635],[73.3652,71.3198],[73.1505,71.3852],[73.0862,71.4449],[73.6718,71.8451],[73.9395,71.9147],[74.3112,71.9578],[74.4891,71.997],[74.8041,72.0774],[74.9922,72.1448],[75.0532,72.1992],[75.0899,72.2631],[75.0971,72.4207],[75.0604,72.5488],[75.008,72.6194],[74.8969,72.7101],[74.7868,72.8119],[74.8649,72.8384],[74.9422,72.8538],[75.1524,72.8527],[75.3693,72.7966],[75.4749,72.685],[75.6035,72.5811],[75.6031,72.5122],[75.5914,72.4572],[75.6443,72.3823],[75.6911,72.35],[75.7414,72.2962],[75.6944,72.2535],[75.6443,72.2323],[75.5502,72.1708],[75.3945,71.9832],[75.2738,71.9589],[75.2475,71.8134],[75.5032,71.6546],[75.4686,71.5344],[75.4172,71.4947],[75.2803,71.4301],[75.298,71.3785],[75.332,71.3417],[75.7336,71.2659],[76.1104,71.2186],[76.742,71.2021],[76.929,71.1279],[76.9952,71.1811],[77.5896,71.1679],[78.0683,70.9863],[78.3206,70.9304],[78.5258,70.9118],[78.9422,70.9338],[79.0154,70.9502],[79.0839,71.002],[78.8887,70.9972],[78.8035,70.9735],[78.7239,70.976],[78.5877,70.9939],[78.4914,71.0254],[78.3865,71.0871],[78.2126,71.2663],[77.9084,71.3241],[77.7066,71.3006],[77.4811,71.3116],[77.1137,71.4094],[76.8712,71.4466],[76.4334,71.5525],[76.3121,71.5955],[76.2157,71.6829],[76.1036,71.829],[76.0324,71.9104],[76.124,71.9266],[76.4217,72.006],[76.8714,72.033],[77.0613,72.0042],[77.5508,71.8421],[77.7775,71.8364],[78.1869,71.9071],[78.2324,71.9523],[78.1408,72.0447],[78.0164,72.092],[77.7807,72.1143],[77.4929,72.0717],[77.4108,72.1078],[77.4397,72.1565],[77.4716,72.1921],[77.6253,72.2014],[77.7332,72.2292],[77.9682,72.3287],[78.2254,72.3774],[78.4826,72.395],[79.4221,72.3808],[79.9539,72.223],[80.474,72.1531],[80.6992,72.0983],[80.7625,72.0892],[80.8147,72.0543],[80.8561,71.9702],[81.5112,71.7461],[81.6616,71.716],[82.0799,71.7068],[82.5473,71.7586],[82.7578,71.7641],[82.9861,71.7487],[83.1066,71.7205],[83.2336,71.6682],[83.1655,71.6022],[83.1057,71.5625],[82.9771,71.4514],[82.918,71.4199],[82.4932,71.2929],[82.3229,71.26],[82.277,71.0935],[82.2543,71.0562],[82.2392,70.9977],[82.316,70.8794],[82.3359,70.8074],[82.2707,70.7067],[82.1632,70.5981],[82.1824,70.5115],[82.2212,70.3957],[82.2358,70.4303],[82.2314,70.4829],[82.2584,70.5436],[82.4517,70.6901],[82.5925,70.8899],[82.7378,70.9421],[82.8691,70.9548],[83.0102,70.8954],[83.0511,70.8152],[83.0584,70.6947],[83.0302,70.5805],[82.9198,70.4074],[82.7425,70.2865],[82.6823,70.2177],[82.7673,70.1541],[82.8565,70.1045],[82.961,70.0883],[83.0808,70.093],[83.1096,70.1096],[83.132,70.1572],[83.0941,70.2211],[83.0738,70.2767],[83.2935,70.3213],[83.4971,70.3453],[83.6599,70.4184],[83.7005,70.4664],[83.7359,70.5465],[83.6513,70.6722],[83.5789,70.7659],[83.3339,70.9885],[83.1513,71.1036],[83.266,71.2759],[83.4576,71.4675],[83.5311,71.5143],[83.5505,71.5437],[83.5713,71.5944],[83.5535,71.6498],[83.5344,71.6839],[83.3404,71.8275],[83.2003,71.8747],[82.7551,71.9028],[82.6454,71.9252],[82.3191,72.0718],[82.2807,72.1051],[82.2093,72.2112],[82.1836,72.2375],[82.0937,72.2654],[81.7929,72.3266],[81.5862,72.3517],[81.2827,72.3588],[81.0981,72.3897],[80.8271,72.4883],[80.7978,72.52],[80.7196,72.6479],[80.6562,72.712],[80.6754,72.7592],[80.7737,72.8608],[80.8416,72.9492],[80.7574,73.0252],[80.6387,73.0492],[80.5097,73.0861],[80.4555,73.1552],[80.4245,73.2312],[80.4189,73.2896],[80.398,73.3568],[80.4583,73.4137],[80.5959,73.474],[80.5619,73.515],[80.5832,73.5685],[81.4688,73.6404],[81.817,73.6588],[83.5447,73.6665],[83.667,73.6865],[84.4174,73.722],[84.7379,73.7628],[85.0774,73.7195],[85.2006,73.7215],[85.4483,73.7346],[85.6114,73.8216],[85.9793,73.8569],[86.5914,73.8943],[86.893,73.8871],[86.9613,73.8607],[87.0295,73.8242],[86.6977,73.7168],[86.3659,73.6198],[86.0941,73.5783],[85.8271,73.4928],[85.8005,73.4589],[85.7926,73.4383],[85.8024,73.3717],[85.8182,73.327],[86.0981,73.2726],[86.3079,73.1958],[86.5144,73.1405],[86.6771,73.1068],[86.715,73.1258],[86.1217,73.3067],[85.9708,73.3471],[85.9101,73.3904],[85.939,73.4565],[85.9989,73.4858],[86.0924,73.5191],[86.1551,73.5347],[86.3763,73.5688],[87.1201,73.615],[87.2944,73.7047],[87.3695,73.7559],[87.5712,73.8107],[87.5032,73.8325],[87.3375,73.846],[87.2097,73.8787],[86.6971,74.1953],[86.5711,74.2438],[86.1778,74.2794],[86.0014,74.316],[86.1829,74.423],[86.3958,74.4501],[86.5385,74.4442],[86.6647,74.4143],[86.8979,74.3253],[87.2297,74.3639],[87.1062,74.4036],[86.8942,74.4497],[86.7001,74.5225],[86.4257,74.5855],[86.1161,74.6286],[85.791,74.6451],[85.8808,74.7402],[86.0589,74.7282],[86.1195,74.7574],[86.2013,74.8162],[86.6515,74.6824],[86.8629,74.7179],[87.0418,74.7789],[87.4193,74.9409],[87.4676,75.0132],[87.2874,75.0525],[87.1407,75.0723],[86.9391,75.0681],[86.9217,75.1128],[87.006,75.1698],[87.1708,75.1917],[87.6714,75.1296],[88.5037,75.2905],[88.7331,75.3692],[89.3103,75.4701],[89.5951,75.4583],[90.185,75.5911],[91.0047,75.6496],[91.4795,75.6497],[91.8454,75.7237],[92.4075,75.7497],[92.6025,75.7791],[93.5498,75.8541],[94.0752,75.9129],[94.1563,75.9592],[93.687,75.9216],[93.574,75.9563],[93.4755,75.9329],[93.4061,75.9013],[93.1781,75.959],[93.1163,75.9446],[93.0687,75.9128],[92.9866,75.9027],[92.8904,75.91],[92.8586,75.9795],[92.9716,76.0751],[93.1049,76.0258],[93.2593,76.0988],[93.3596,76.1007],[93.6484,76.0542],[93.8429,76.1013],[94.1023,76.1236],[94.3883,76.1028],[94.5067,76.108],[94.5756,76.1518],[95.0385,76.1135],[95.3593,76.1396],[95.5787,76.1373],[95.9199,76.1131],[96.0755,76.082],[95.986,76.0097],[95.6533,75.8922],[95.7438,75.8723],[95.9348,75.926],[96.5086,76.0056],[96.6006,75.9899],[96.5377,75.9216],[96.4971,75.8912],[96.8792,75.9311],[97.2055,76.0187],[97.3507,76.0334],[97.4992,75.9802],[97.6377,76.0291],[97.6698,76.078],[97.9184,76.0887],[98.02,76.1337],[98.1946,76.1664],[98.342,76.1806],[98.662,76.2427],[98.7713,76.224],[98.9847,76.2076],[99.1873,76.1776],[99.5627,76.1093],[99.6156,76.0823],[99.6632,76.078],[99.7704,76.0288],[99.6893,75.9563],[99.6023,75.8521],[99.4422,75.8032],[99.5407,75.7986],[99.6094,75.8113],[99.7375,75.8807],[99.8514,75.9303],[99.8254,76.1359],[99.6168,76.2402],[99.4606,76.2751],[99.0938,76.3843],[98.9695,76.4308],[98.8057,76.4807],[98.8694,76.5096],[99.5763,76.4714],[99.9357,76.4899],[100.3224,76.4792],[100.8437,76.5252],[101.0607,76.4772],[101.3107,76.4789],[101.5978,76.4392],[101.6838,76.4855],[101.213,76.5357],[101.0026,76.5305],[100.928,76.5567],[101.0063,76.6151],[101.0993,76.704],[101.0082,76.7813],[100.9204,76.8225],[100.9059,76.9007],[100.9899,76.9905],[101.1857,77.0286],[101.2929,77.1016],[101.5177,77.1981],[102.6102,77.5085],[103.1314,77.6265],[103.3313,77.6411],[103.5607,77.6319],[104.0146,77.7304],[104.1849,77.7305],[104.8143,77.6521]],[[35.8161,65.1821],[35.8484,65.1427],[35.8584,65.0779],[35.8273,65.0365],[35.8423,65.0015],[35.7787,64.9767],[35.6801,65.0576],[35.6214,65.0588],[35.5586,65.0936],[35.5289,65.1511],[35.5857,65.1671],[35.6087,65.1571],[35.7291,65.1976],[35.8161,65.1821]],[[42.7137,66.7017],[42.6756,66.6881],[42.4773,66.7351],[42.4601,66.7704],[42.4686,66.7855],[42.5475,66.7955],[42.6314,66.7822],[42.6907,66.7353],[42.7137,66.7017]],[[50.2652,69.1856],[50.283,69.0889],[50.2206,69.0488],[50.1645,69.0375],[50.1409,69.0981],[50.0939,69.1255],[49.9208,69.0533],[49.8398,68.9738],[49.6263,68.8597],[49.1805,68.7784],[48.9104,68.7431],[48.667,68.7332],[48.4391,68.8049],[48.3159,68.9424],[48.2944,68.9842],[48.2788,69.0403],[48.2803,69.0966],[48.2963,69.1839],[48.3199,69.2692],[48.4139,69.3457],[48.6313,69.436],[48.8449,69.4947],[48.9533,69.5093],[49.2252,69.5112],[49.9963,69.3094],[50.1673,69.2571],[50.2652,69.1856]],[[60.4505,69.9349],[60.4807,69.8855],[60.4772,69.7937],[60.4402,69.7259],[60.3271,69.7153],[60.2159,69.6877],[60.0262,69.717],[59.9195,69.697],[59.8128,69.6957],[59.7246,69.7062],[59.637,69.721],[59.5782,69.7386],[59.5813,69.7909],[59.5026,69.8662],[59.3815,69.8904],[59.2684,69.8984],[59.1442,69.9219],[59.0825,69.9108],[59.004,69.8833],[58.9527,69.8928],[58.6801,70.051],[58.6342,70.088],[58.6056,70.1292],[58.5681,70.1557],[58.473,70.2668],[58.5199,70.3183],[58.6153,70.3508],[58.678,70.3596],[58.7942,70.433],[59.0053,70.4652],[59.048,70.4605],[59.0883,70.4371],[59.3099,70.3617],[59.426,70.3109],[59.5291,70.249],[59.6363,70.197],[59.9559,70.1083],[60.1723,70.0229],[60.3926,69.9624],[60.4505,69.9349]],[[82.1724,75.4194],[82.2088,75.387],[82.2216,75.3505],[82.1793,75.339],[82.0501,75.341],[81.9785,75.2471],[81.9051,75.2628],[81.8605,75.3165],[81.6977,75.2805],[81.6548,75.2889],[81.5793,75.331],[81.5321,75.3396],[81.5006,75.3679],[81.7121,75.4514],[81.8422,75.407],[81.9266,75.41],[81.9098,75.46],[81.9128,75.4977],[82.0219,75.5135],[82.1656,75.5156],[82.1724,75.4194]],[[79.5015,72.7219],[79.4307,72.7107],[78.8806,72.7516],[78.6902,72.8034],[78.6332,72.8507],[78.6568,72.8923],[79.1643,73.0943],[79.3565,73.0386],[79.4125,72.9831],[79.5413,72.9187],[79.5379,72.7693],[79.5015,72.7219]],[[74.6605,72.8734],[74.6384,72.8638],[74.5881,72.8812],[74.4348,72.9077],[74.1807,72.9753],[74.1002,73.0215],[74.1424,73.0744],[74.1985,73.1091],[74.4088,73.1305],[74.5999,73.1218],[74.7253,73.1082],[74.9615,73.0625],[74.7426,73.0327],[74.6473,72.969],[74.6602,72.9293],[74.6972,72.9077],[74.6605,72.8734]],[[70.6739,73.095],[70.3804,73.0481],[70.2983,73.0445],[70.1187,73.0563],[70.0407,73.0372],[69.9201,73.0845],[69.9304,73.1266],[69.9856,73.1692],[70.0188,73.2243],[69.9959,73.3594],[70.1496,73.4447],[70.35,73.4776],[70.9402,73.5144],[71.0232,73.5042],[71.1412,73.478],[71.2316,73.4478],[71.3512,73.3722],[71.4449,73.3421],[71.5896,73.2832],[71.6305,73.2248],[71.6262,73.174],[71.3557,73.1625],[70.8867,73.1196],[70.6739,73.095]],[[76.7561,73.4458],[76.6594,73.4395],[76.2345,73.4762],[76.0831,73.5235],[76.1396,73.5543],[76.2507,73.5553],[76.7561,73.4458]],[[75.5037,73.4566],[75.3443,73.4323],[75.375,73.4774],[75.5697,73.5406],[75.9302,73.5736],[76.0395,73.5599],[76.0516,73.5493],[75.901,73.4815],[75.8271,73.4591],[75.5037,73.4566]],[[52.9033,71.365],[52.9941,71.2913],[53.074,71.2379],[53.1414,71.2419],[53.1926,71.2153],[53.2052,71.1597],[53.0715,71.065],[53.0481,71.031],[53.1058,70.9993],[53.121,70.982],[53.0227,70.9687],[53.0045,71.0116],[52.9496,71.0536],[52.8354,71.0858],[52.789,71.1149],[52.7384,71.1807],[52.5466,71.2504],[52.4255,71.2393],[52.2895,71.2704],[52.2496,71.2849],[52.2398,71.325],[52.2966,71.3568],[52.5126,71.3851],[52.6174,71.3833],[52.7297,71.3551],[52.7203,71.3898],[52.7322,71.4037],[52.7768,71.3998],[52.9033,71.365]],[[67.7653,76.2376],[67.3652,76.1613],[67.127,76.1082],[66.8932,76.0723],[66.6574,76.047],[66.2824,75.9837],[65.6191,75.9046],[65.2016,75.8395],[64.7445,75.7882],[64.2626,75.7197],[63.7793,75.6726],[63.6595,75.6687],[63.3167,75.6031],[63.046,75.5757],[62.0661,75.4277],[61.6162,75.3196],[61.4865,75.3108],[61.356,75.3148],[61.2488,75.281],[61.1473,75.2226],[60.9356,75.1637],[60.8292,75.1108],[60.7192,75.0686],[60.6554,75.055],[60.5338,75.0593],[60.4756,75.0547],[60.2769,75.0076],[60.2411,74.9708],[60.4549,74.9461],[60.5014,74.9046],[60.4392,74.8753],[60.3008,74.837],[60.2225,74.7966],[60.0801,74.7559],[59.9823,74.7446],[59.7473,74.7459],[59.7347,74.6955],[59.7715,74.6645],[59.7527,74.637],[59.674,74.6102],[59.596,74.6137],[59.2401,74.693],[59.182,74.6658],[59.157,74.6108],[59.1461,74.5519],[59.101,74.5075],[59.0404,74.4855],[58.9282,74.4627],[58.5347,74.4989],[58.5021,74.4642],[58.562,74.4218],[58.6457,74.328],[58.665,74.2893],[58.6179,74.2274],[58.4414,74.1289],[57.7674,74.0138],[57.7784,73.9739],[57.8534,73.8979],[57.8723,73.8504],[57.8449,73.8051],[57.756,73.7692],[57.6574,73.7682],[57.6037,73.7755],[57.4485,73.8256],[57.3131,73.838],[57.2909,73.8146],[57.4643,73.746],[57.5426,73.6582],[57.4598,73.6103],[57.1344,73.5044],[56.9639,73.3666],[56.6342,73.3043],[56.4304,73.2972],[56.2283,73.3141],[56.0346,73.3459],[55.5492,73.3568],[55.2802,73.392],[55.0068,73.4539],[54.7687,73.4494],[54.5658,73.4185],[54.2999,73.351],[54.1315,73.481],[54.2046,73.542],[53.8387,73.6971],[53.7629,73.7662],[53.8514,73.8005],[53.9635,73.8223],[54.174,73.8857],[54.3863,73.9356],[54.6057,73.9513],[54.6427,73.9596],[54.7334,74.034],[54.8313,74.0958],[54.9203,74.1291],[55.0229,74.1866],[55.3409,74.4196],[55.4164,74.4361],[56.0783,74.4813],[56.1371,74.4961],[55.9475,74.5422],[55.7518,74.5412],[55.6615,74.5561],[55.6104,74.5905],[55.5822,74.6277],[55.6597,74.6563],[55.9137,74.7961],[56.2179,74.8975],[56.4987,74.9571],[56.4285,74.9729],[56.34,75.0135],[55.998,75.0034],[55.8632,75.0587],[55.8212,75.0906],[55.8101,75.1249],[55.9207,75.1684],[56.0355,75.1942],[56.1622,75.1866],[56.2887,75.1643],[56.3891,75.1382],[56.4853,75.0961],[56.5703,75.0978],[56.8763,75.2444],[56.8293,75.2777],[56.8095,75.3284],[56.8444,75.3514],[56.9895,75.3751],[57.0875,75.3838],[57.3018,75.3732],[57.6068,75.3413],[57.6315,75.3564],[57.7082,75.4545],[57.7834,75.5067],[58.0937,75.5925],[58.0726,75.619],[58.0583,75.6631],[58.4184,75.7198],[58.6527,75.7768],[58.8813,75.8548],[58.9947,75.8717],[59.1104,75.8737],[59.3466,75.907],[59.7819,75.9458],[60.0361,75.9838],[60.1182,76.0666],[60.2793,76.0962],[60.6062,76.1086],[60.7306,76.1041],[60.8012,76.0688],[60.9422,76.0713],[60.9978,76.0893],[61.0539,76.1199],[61.0369,76.169],[61.0344,76.233],[61.1569,76.2735],[61.2017,76.282],[61.5694,76.2985],[61.7871,76.291],[62.2373,76.2416],[62.4711,76.2305],[62.782,76.2452],[62.9715,76.2367],[63.5262,76.3095],[64.4635,76.3782],[64.7076,76.426],[64.95,76.4843],[65.0729,76.4967],[65.1972,76.4997],[65.3098,76.5179],[65.5284,76.5678],[65.6369,76.5787],[65.7552,76.5793],[65.8629,76.6133],[65.9589,76.6879],[66.063,76.7461],[66.3452,76.821],[66.8288,76.9238],[67.2637,76.9638],[67.535,77.0078],[67.6519,77.0116],[68.0173,76.9906],[68.4857,76.9337],[68.6991,76.8707],[68.8733,76.7896],[68.9117,76.7605],[68.9417,76.7077],[68.8905,76.6597],[68.858,76.6105],[68.8998,76.5729],[68.5586,76.4494],[68.2224,76.3135],[68.1654,76.2849],[67.7653,76.2376]],[[55.3198,73.3083],[55.7873,73.2686],[56.1377,73.2562],[56.3505,73.2255],[56.4296,73.2012],[56.3975,73.1392],[56.3347,73.1137],[56.189,73.033],[56.167,72.9832],[56.1929,72.905],[56.1705,72.8481],[56.1217,72.8066],[56.0838,72.7894],[55.8197,72.7895],[55.7234,72.7664],[55.7185,72.7215],[55.701,72.6717],[55.6164,72.5991],[55.4413,72.5754],[55.4033,72.5491],[55.4169,72.5013],[55.356,72.4651],[55.3596,72.4087],[55.3904,72.3778],[55.3991,72.3136],[55.5181,72.2207],[55.4949,72.1823],[55.4033,72.1069],[55.375,72.0149],[55.2979,71.9354],[55.4711,71.8692],[55.5467,71.7833],[55.6137,71.6899],[55.8193,71.5076],[56.0432,71.3456],[56.4544,71.1074],[56.8948,70.927],[57.0656,70.876],[57.4836,70.7923],[57.5564,70.7658],[57.6254,70.7288],[57.4472,70.661],[57.2637,70.636],[57.247,70.6051],[57.1459,70.5891],[56.6488,70.6465],[56.6217,70.6554],[56.5687,70.6975],[56.5101,70.7288],[56.3857,70.7341],[56.2601,70.7147],[56.3348,70.6767],[56.4172,70.6649],[56.5613,70.5936],[56.4997,70.5664],[56.4346,70.563],[56.1425,70.6579],[56.1147,70.6461],[56.0871,70.6184],[55.9416,70.6493],[55.9072,70.6263],[55.7969,70.6156],[55.7067,70.6419],[55.7064,70.6752],[55.6873,70.6922],[55.2369,70.666],[55.0517,70.6667],[54.8671,70.6781],[54.6451,70.7418],[54.6082,70.7132],[54.6012,70.6801],[54.5174,70.6933],[54.3326,70.7447],[54.1994,70.7649],[53.7224,70.8145],[53.3836,70.8735],[53.4678,70.9006],[53.6136,70.9146],[53.6156,70.9508],[53.5926,71.0007],[53.5878,71.0523],[53.6705,71.0869],[53.857,71.0704],[53.8343,71.1267],[53.9223,71.1376],[54.0939,71.1052],[54.1557,71.1255],[53.8861,71.1963],[53.5908,71.2967],[53.6222,71.3328],[53.5152,71.3425],[53.41,71.3401],[53.319,71.3992],[53.3325,71.4772],[53.4116,71.5301],[53.3639,71.5417],[52.909,71.495],[52.6787,71.5057],[52.4188,71.5369],[52.18,71.4902],[51.9379,71.4747],[51.8126,71.4913],[51.6916,71.5251],[51.5904,71.5711],[51.5113,71.6481],[51.4387,71.7768],[51.4286,71.8255],[51.4436,71.9344],[51.4822,71.9798],[51.5825,72.0712],[51.6531,72.0994],[51.8055,72.1421],[51.8854,72.1532],[52.0687,72.1312],[52.2521,72.1297],[52.3323,72.154],[52.4067,72.1967],[52.4619,72.2523],[52.5861,72.284],[52.6221,72.301],[52.6619,72.3369],[52.7058,72.391],[52.7139,72.437],[52.7487,72.483],[52.8637,72.5499],[52.8232,72.5913],[52.8391,72.6193],[52.9166,72.6689],[52.6831,72.6823],[52.605,72.7041],[52.5285,72.7374],[52.5506,72.7686],[52.5793,72.7914],[52.8122,72.8752],[52.9132,72.9],[53.0242,72.9136],[53.135,72.9132],[53.2535,72.9038],[53.3698,72.9167],[53.2473,72.9731],[53.2371,73.0112],[53.189,73.104],[53.1979,73.1476],[53.2512,73.183],[53.3576,73.2246],[53.5122,73.2384],[53.6337,73.2603],[53.7532,73.2933],[53.8656,73.299],[54.091,73.2765],[54.2023,73.2813],[54.3276,73.2995],[54.6761,73.37],[54.8039,73.3876],[54.9406,73.3833],[55.1214,73.3568],[55.3198,73.3083]],[[50.7537,81.0474],[50.616,81.0413],[50.5182,81.0456],[50.4119,81.0844],[50.3774,81.1027],[50.3685,81.1225],[50.4649,81.1262],[50.506,81.1442],[50.5216,81.1582],[50.5918,81.1694],[50.7159,81.1707],[50.8786,81.1509],[50.9462,81.1082],[50.7888,81.0718],[50.7537,81.0474]],[[54.4153,80.4728],[54.2759,80.4213],[53.8119,80.4762],[53.85,80.5039],[53.9002,80.5154],[53.9016,80.5425],[53.8589,80.563],[53.8772,80.6053],[54.1768,80.5744],[54.2054,80.5618],[54.4071,80.5401],[54.4373,80.4987],[54.4153,80.4728]],[[47.442,80.8537],[47.8995,80.8127],[48.2433,80.8235],[48.3452,80.819],[48.4457,80.806],[48.5474,80.7791],[48.6865,80.7178],[48.6836,80.6333],[48.6255,80.6293],[48.0443,80.6682],[47.7773,80.7563],[47.7053,80.7652],[47.6001,80.7419],[47.5123,80.6879],[47.4142,80.6745],[47.3039,80.6062],[47.1982,80.6149],[47.1449,80.609],[47.011,80.5621],[46.6775,80.5613],[46.6239,80.5407],[46.5137,80.4755],[46.3781,80.4568],[46.1414,80.4467],[46.0599,80.4838],[46.0236,80.5409],[45.969,80.5695],[45.6408,80.537],[45.3893,80.5603],[45.1492,80.5987],[44.905,80.6113],[45.1245,80.6522],[46.3274,80.7352],[46.7991,80.7552],[47.0206,80.8144],[47.3523,80.8529],[47.442,80.8537]],[[54.7189,81.116],[55.4707,81.0199],[56.1701,81.0292],[56.4723,80.9982],[56.9097,80.9129],[57.5678,80.8197],[57.6941,80.7923],[57.5804,80.7555],[56.8147,80.6636],[56.3155,80.6329],[55.8834,80.6284],[55.7125,80.6373],[55.5406,80.7033],[55.1172,80.7519],[54.6682,80.7387],[54.6233,80.7652],[54.5328,80.783],[54.3761,80.787],[54.0666,80.8136],[54.0454,80.872],[54.2405,80.9019],[54.3673,80.9038],[54.4168,80.9865],[54.634,81.1132],[54.7189,81.116]],[[51.4093,79.9442],[51.4352,79.9319],[51.4313,79.9205],[51.0763,79.932],[50.4541,79.9244],[50.0914,79.9806],[50.4727,80.0354],[50.6758,80.0485],[50.9363,80.0942],[51.2544,80.0486],[51.2379,80.0104],[51.2428,79.9913],[51.327,79.9723],[51.4093,79.9442]],[[50.0518,80.0743],[49.9709,80.0607],[49.5883,80.1361],[49.5561,80.1589],[49.8837,80.2302],[50.251,80.2195],[50.31,80.1856],[50.3191,80.1724],[50.0723,80.1095],[50.0518,80.0743]],[[76.2489,79.6511],[76.3726,79.6152],[76.4674,79.6432],[77.3602,79.5568],[77.5493,79.5244],[77.589,79.5019],[76.8102,79.4895],[76.6495,79.4934],[76.6365,79.5444],[76.4576,79.5455],[76.1537,79.5788],[76.0719,79.6256],[76.0516,79.6447],[76.1484,79.6645],[76.2489,79.6511]],[[59.6889,79.9558],[59.3307,79.923],[59.2026,79.933],[59.1692,79.9483],[59.1004,79.9642],[58.9192,79.9846],[58.9461,80.0423],[59.0015,80.0539],[59.5445,80.1188],[59.8017,80.0827],[59.911,79.9943],[59.6889,79.9558]],[[55.4797,80.2738],[55.1951,80.2268],[55.0484,80.2284],[54.9797,80.2564],[55.0916,80.2956],[55.24,80.3254],[55.3532,80.3177],[55.4348,80.3022],[55.4797,80.2738]],[[53.5214,80.1852],[52.8563,80.1732],[52.6359,80.1789],[52.607,80.1912],[52.5505,80.2019],[52.3436,80.2132],[52.2134,80.2637],[52.2702,80.2763],[52.5767,80.2969],[52.6806,80.3185],[52.716,80.3476],[52.8539,80.4024],[53.1856,80.4126],[53.3292,80.4024],[53.3459,80.3663],[53.4861,80.3234],[53.8517,80.2684],[53.7779,80.2283],[53.6529,80.2226],[53.5214,80.1852]],[[57.0787,80.3509],[57.1227,80.317],[57.1189,80.1939],[57.0728,80.1394],[57.0802,80.0947],[56.9869,80.0715],[56.2006,80.0765],[55.8116,80.0872],[55.724,80.1047],[55.9423,80.1633],[56.0122,80.2039],[55.9898,80.3201],[56.0244,80.3413],[56.6551,80.3303],[56.7072,80.3633],[56.9445,80.3662],[57.0787,80.3509]],[[50.2781,80.9272],[50.4314,80.9109],[50.8011,80.9142],[50.9177,80.8904],[51.4548,80.7447],[51.591,80.7408],[51.7036,80.6876],[51.1462,80.604],[50.9608,80.5405],[50.2797,80.5273],[49.846,80.4977],[49.7498,80.4721],[49.7941,80.4253],[49.5859,80.3766],[48.8961,80.3692],[48.811,80.3537],[48.6771,80.3],[48.689,80.2903],[48.922,80.2768],[48.9596,80.2657],[48.9908,80.2424],[49.0107,80.2074],[48.9775,80.1626],[48.8919,80.1553],[48.7974,80.1611],[48.5817,80.1954],[48.5546,80.1833],[48.5326,80.1583],[48.4668,80.1101],[48.3862,80.0958],[48.1672,80.1328],[48.0959,80.1223],[48.0258,80.0995],[47.9399,80.0886],[47.7373,80.0817],[47.6324,80.112],[47.7231,80.1514],[47.9775,80.2125],[47.893,80.2393],[47.6424,80.2453],[47.4443,80.2301],[47.3431,80.1885],[47.2486,80.1802],[46.991,80.1828],[46.8459,80.2372],[46.7382,80.2577],[46.6444,80.3003],[47.4029,80.4448],[47.6561,80.5005],[47.8958,80.5291],[48.2082,80.5439],[48.3062,80.5616],[48.4026,80.5688],[48.4647,80.5581],[48.6251,80.5083],[49.0878,80.5158],[49.1853,80.5586],[49.1927,80.656],[49.1475,80.7121],[49.2443,80.8214],[49.5078,80.8653],[50.1243,80.9239],[50.2781,80.9272]],[[57.9563,80.1232],[57.8001,80.1041],[57.3923,80.1392],[57.3323,80.1581],[57.2814,80.1939],[57.2141,80.3283],[57.2117,80.3685],[57.1862,80.3962],[57.0834,80.4452],[57.0111,80.4683],[57.075,80.4939],[57.522,80.4754],[58.4805,80.4647],[58.9717,80.4159],[59.1159,80.3884],[59.2555,80.3432],[58.3979,80.3188],[58.2839,80.2978],[58.2857,80.2481],[58.2555,80.2018],[58.1632,80.1965],[57.9563,80.1232]],[[62.1678,80.8348],[62.2277,80.7944],[62.1918,80.7302],[62.1146,80.6837],[62.0758,80.6169],[61.7691,80.601],[61.6813,80.5863],[61.5975,80.535],[61.2852,80.5047],[61.0513,80.4186],[60.7223,80.4347],[60.2783,80.4944],[59.9002,80.4461],[59.6498,80.4313],[59.3464,80.505],[59.3044,80.5215],[59.2882,80.5727],[59.3063,80.6178],[59.3865,80.7125],[59.4951,80.7665],[59.5494,80.7836],[59.5923,80.8165],[59.7158,80.8364],[60.0945,80.8486],[60.235,80.8377],[60.278,80.8015],[60.4815,80.8042],[60.8202,80.8266],[61.3132,80.8626],[61.5975,80.8929],[61.8506,80.8859],[62.1029,80.8666],[62.1678,80.8348]],[[57.8103,81.546],[57.8627,81.5064],[58.0166,81.4838],[58.436,81.4642],[58.5639,81.4184],[58.3719,81.387],[57.8587,81.3681],[57.9119,81.3033],[58.0153,81.2548],[57.9129,81.1975],[57.7697,81.1697],[57.451,81.1355],[57.1595,81.1785],[56.8219,81.2379],[56.6692,81.1983],[56.5125,81.1752],[56.364,81.1786],[56.192,81.224],[55.7167,81.1885],[55.5727,81.2281],[55.466,81.3112],[55.7819,81.3294],[56.1568,81.3031],[56.4047,81.387],[56.7187,81.4234],[56.973,81.5105],[57.0915,81.5412],[57.365,81.5353],[57.4564,81.5429],[57.7166,81.5646],[57.8103,81.546]],[[58.6224,81.0417],[58.7615,80.991],[58.8153,80.9336],[58.9025,80.8977],[58.9306,80.8317],[58.86,80.7794],[58.6419,80.768],[58.2856,80.7649],[57.9379,80.7934],[57.7498,80.8891],[57.4052,80.9151],[57.2109,81.0171],[57.4103,81.0468],[57.6563,81.0315],[58.0495,81.1185],[58.1023,81.1143],[58.1899,81.0946],[58.5076,81.0618],[58.6224,81.0417]],[[80.0267,80.8481],[79.0985,80.8121],[79.0068,80.8348],[78.9776,80.8482],[79.1099,80.9236],[79.2174,80.9604],[79.8066,80.9754],[80.2796,80.9498],[80.4279,80.9277],[80.3733,80.8826],[80.3448,80.8679],[80.0267,80.8481]],[[63.3738,80.7001],[63.1876,80.6976],[63.0021,80.7128],[62.7604,80.7627],[62.5203,80.8219],[62.5926,80.853],[62.8193,80.8938],[63.1158,80.9668],[63.6147,80.9809],[63.856,80.9812],[64.0957,80.9983],[64.1659,81.0357],[64.2104,81.1063],[64.2559,81.1444],[64.3102,81.1752],[64.5754,81.1985],[64.8021,81.1973],[65.0277,81.1695],[65.172,81.144],[65.3098,81.0964],[65.382,81.0567],[65.3601,81.0082],[65.3721,80.968],[65.4374,80.9307],[64.9975,80.8189],[64.5483,80.7554],[63.3738,80.7001]],[[61.1408,80.9503],[60.8268,80.9297],[60.3211,80.9555],[60.0582,80.9846],[60.0783,80.9992],[60.1476,81.0167],[60.5866,81.0877],[61.4574,81.104],[61.5674,81.0503],[61.472,81.011],[61.1408,80.9503]]]},"properties":{"scalerank":1,"featurecla":"Admin-0 country","labelrank":2,"sovereignt":"Russia","sov_a3":"RUS","adm0_dif":0,"level":2,"type":"Sovereign country","admin":"Russia","adm0_a3":"RUS","geou_dif":0,"geounit":"Russia","gu_a3":"RUS","su_dif":0,"subunit":"Russia","su_a3":"RUS","brk_diff":0,"name":"Russia","name_long":"Russian Federation","brk_a3":"RUS","brk_name":"Russia","brk_group":"","abbrev":"Rus.","postal":"RUS","formal_en":"Russian Federation","formal_fr":"","note_adm0":"","note_brk":"","name_sort":"Russian Federation","name_alt":"","mapcolor7":2,"mapcolor8":5,"mapcolor9":7,"mapcolor13":7,"pop_est":140041247,"gdp_md_est":2266000,"pop_year":-99,"lastcensus":2010,"gdp_year":-99,"economy":"3. Emerging region: BRIC","income_grp":"3. Upper middle income","wikipedia":-99,"fips_10":"","iso_a2":"RU","iso_a3":"RUS","iso_n3":"643","un_a3":"643","wb_a2":"RU","wb_a3":"RUS","woe_id":-99,"adm0_a3_is":"RUS","adm0_a3_us":"RUS","adm0_a3_un":-99,"adm0_a3_wb":-99,"continent":"Europe","region_un":"Europe","subregion":"Eastern Europe","region_wb":"Europe & Central Asia","name_len":6,"long_len":18,"abbrev_len":4,"tiny":-99,"homepart":1}}],"bbox":[-24.475683593749977,-12.435937500000009,180.00000000000003,81.85419921874998]};
}));
