/*!
 * DevExtreme (dx.all.debug.js)
 * Version: 22.1.4
 * Build date: Fri Jul 22 2022
 *
 * Copyright (c) 2012 - 2022 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
! function() {
    var __webpack_modules__ = {
        23908:
            /*!*****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/animation/easing.js ***!
              \*****************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.convertTransitionTimingFuncToEasing = void 0;
                exports.getEasing = function(name) {
                    return easing[name]
                };
                exports.setEasing = function(value) {
                    easing = value
                };
                var _type = __webpack_require__( /*! ../core/utils/type */ 35922);
                var CSS_TRANSITION_EASING_REGEX = /cubic-bezier\((\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\)/;
                var TransitionTimingFuncMap = {
                    linear: "cubic-bezier(0, 0, 1, 1)",
                    swing: "cubic-bezier(0.445, 0.05, 0.55, 0.95)",
                    ease: "cubic-bezier(0.25, 0.1, 0.25, 1)",
                    "ease-in": "cubic-bezier(0.42, 0, 1, 1)",
                    "ease-out": "cubic-bezier(0, 0, 0.58, 1)",
                    "ease-in-out": "cubic-bezier(0.42, 0, 0.58, 1)"
                };
                var polynomBezier = function(x1, y1, x2, y2) {
                    var Cx = 3 * x1;
                    var Bx = 3 * (x2 - x1) - Cx;
                    var Ax = 1 - Cx - Bx;
                    var Cy = 3 * y1;
                    var By = 3 * (y2 - y1) - Cy;
                    var Ay = 1 - Cy - By;
                    var bezierX = function(t) {
                        return t * (Cx + t * (Bx + t * Ax))
                    };
                    var derivativeX = function(t) {
                        return Cx + t * (2 * Bx + 3 * t * Ax)
                    };
                    return function(t) {
                        return function(t) {
                            return t * (Cy + t * (By + t * Ay))
                        }(function(t) {
                            var x = t;
                            var i = 0;
                            var z;
                            while (i < 14) {
                                z = bezierX(x) - t;
                                if (Math.abs(z) < .001) {
                                    break
                                }
                                x -= z / derivativeX(x);
                                i++
                            }
                            return x
                        }(t))
                    }
                };
                var easing = {};
                exports.convertTransitionTimingFuncToEasing = function(cssTransitionEasing) {
                    cssTransitionEasing = TransitionTimingFuncMap[cssTransitionEasing] || cssTransitionEasing;
                    var coeffs = cssTransitionEasing.match(CSS_TRANSITION_EASING_REGEX);
                    var forceName;
                    if (!coeffs) {
                        forceName = "linear";
                        coeffs = TransitionTimingFuncMap[forceName].match(CSS_TRANSITION_EASING_REGEX)
                    }
                    coeffs = coeffs.slice(1, 5);
                    for (var i = 0; i < coeffs.length; i++) {
                        coeffs[i] = parseFloat(coeffs[i])
                    }
                    var easingName = forceName || "cubicbezier_" + coeffs.join("_").replace(/\./g, "p");
                    if (!(0, _type.isFunction)(easing[easingName])) {
                        easing[easingName] = function(x, t, b, c, d) {
                            return c * polynomBezier(coeffs[0], coeffs[1], coeffs[2], coeffs[3])(t / d) + b
                        }
                    }
                    return easingName
                }
            },
        90057:
            /*!****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/animation/frame.js ***!
              \****************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.cancelAnimationFrame = function() {
                    setAnimationFrameMethods();
                    cancel.apply(window, arguments)
                };
                exports.requestAnimationFrame = function() {
                    setAnimationFrameMethods();
                    return request.apply(window, arguments)
                };
                var _window = __webpack_require__( /*! ../core/utils/window */ 58201);
                var _call_once = (obj = __webpack_require__( /*! ../core/utils/call_once */ 39618), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var window = (0, _window.hasWindow)() ? (0, _window.getWindow)() : {};
                var request = function(callback) {
                    return setTimeout(callback, 1e3 / 60)
                };
                var cancel = function(requestID) {
                    clearTimeout(requestID)
                };
                var setAnimationFrameMethods = (0, _call_once.default)((function() {
                    var nativeRequest = window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame;
                    var nativeCancel = window.cancelAnimationFrame || window.webkitCancelAnimationFrame || window.mozCancelAnimationFrame || window.oCancelAnimationFrame || window.msCancelAnimationFrame;
                    if (nativeRequest && nativeCancel) {
                        request = nativeRequest;
                        cancel = nativeCancel
                    }
                }))
            },
        87209:
            /*!*************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/animation/fx.js ***!
              \*************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 68374));
                var _window = __webpack_require__( /*! ../core/utils/window */ 58201);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../events/core/events_engine */ 55994));
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../core/errors */ 17381));
                var _element = __webpack_require__( /*! ../core/element */ 6415);
                var _extend = __webpack_require__( /*! ../core/utils/extend */ 13306);
                var _type = __webpack_require__( /*! ../core/utils/type */ 35922);
                var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 95479);
                var _translator = __webpack_require__( /*! ./translator */ 31648);
                var _easing = __webpack_require__( /*! ./easing */ 23908);
                var _frame = __webpack_require__( /*! ./frame */ 90057);
                var _support = __webpack_require__( /*! ../core/utils/support */ 60137);
                var _position = _interopRequireDefault(__webpack_require__( /*! ./position */ 49387));
                var _remove = __webpack_require__( /*! ../events/remove */ 29007);
                var _index = __webpack_require__( /*! ../events/utils/index */ 39611);
                var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 62754);
                var _common = __webpack_require__( /*! ../core/utils/common */ 20576);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _typeof(obj) {
                    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj) {
                        return typeof obj
                    } : function(obj) {
                        return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                    }, _typeof(obj)
                }
                var window = (0, _window.getWindow)();
                var removeEventName = (0, _index.addNamespace)(_remove.removeEvent, "dxFX");
                var RELATIVE_VALUE_REGEX = /^([+-])=(.*)/i;
                var TransitionAnimationStrategy = {
                    initAnimation: function($element, config) {
                        $element.css({
                            transitionProperty: "none"
                        });
                        if ("string" === typeof config.from) {
                            $element.addClass(config.from)
                        } else {
                            setProps($element, config.from)
                        }
                        var that = this;
                        var deferred = new _deferred.Deferred;
                        var cleanupWhen = config.cleanupWhen;
                        config.transitionAnimation = {
                            deferred: deferred,
                            finish: function() {
                                that._finishTransition($element);
                                if (cleanupWhen) {
                                    (0, _deferred.when)(deferred, cleanupWhen).always((function() {
                                        that._cleanup($element, config)
                                    }))
                                } else {
                                    that._cleanup($element, config)
                                }
                                deferred.resolveWith($element, [config, $element])
                            }
                        };
                        this._completeAnimationCallback($element, config).done((function() {
                            config.transitionAnimation.finish()
                        })).fail((function() {
                            deferred.rejectWith($element, [config, $element])
                        }));
                        if (!config.duration) {
                            config.transitionAnimation.finish()
                        }
                        $element.css("transform")
                    },
                    animate: function($element, config) {
                        this._startAnimation($element, config);
                        return config.transitionAnimation.deferred.promise()
                    },
                    _completeAnimationCallback: function($element, config) {
                        var that = this;
                        var startTime = Date.now() + config.delay;
                        var deferred = new _deferred.Deferred;
                        var transitionEndFired = new _deferred.Deferred;
                        var simulatedTransitionEndFired = new _deferred.Deferred;
                        var simulatedEndEventTimer;
                        var transitionEndEventFullName = (0, _support.transitionEndEventName)() + ".dxFX";
                        config.transitionAnimation.cleanup = function() {
                            clearTimeout(simulatedEndEventTimer);
                            clearTimeout(waitForJSCompleteTimer);
                            _events_engine.default.off($element, transitionEndEventFullName);
                            _events_engine.default.off($element, removeEventName)
                        };
                        _events_engine.default.one($element, transitionEndEventFullName, (function() {
                            if (Date.now() - startTime >= config.duration) {
                                transitionEndFired.reject()
                            }
                        }));
                        _events_engine.default.off($element, removeEventName);
                        _events_engine.default.on($element, removeEventName, (function() {
                            that.stop($element, config);
                            deferred.reject()
                        }));
                        var waitForJSCompleteTimer = setTimeout((function() {
                            simulatedEndEventTimer = setTimeout((function() {
                                simulatedTransitionEndFired.reject()
                            }), config.duration + config.delay + fx._simulatedTransitionEndDelay);
                            (0, _deferred.when)(transitionEndFired, simulatedTransitionEndFired).fail(function() {
                                deferred.resolve()
                            }.bind(this))
                        }));
                        return deferred.promise()
                    },
                    _startAnimation: function($element, config) {
                        $element.css({
                            transitionProperty: "all",
                            transitionDelay: config.delay + "ms",
                            transitionDuration: config.duration + "ms",
                            transitionTimingFunction: config.easing
                        });
                        if ("string" === typeof config.to) {
                            $element[0].className += " " + config.to
                        } else if (config.to) {
                            setProps($element, config.to)
                        }
                    },
                    _finishTransition: function($element) {
                        $element.css("transition", "none")
                    },
                    _cleanup: function($element, config) {
                        config.transitionAnimation.cleanup();
                        if ("string" === typeof config.from) {
                            $element.removeClass(config.from);
                            $element.removeClass(config.to)
                        }
                    },
                    stop: function($element, config, jumpToEnd) {
                        if (!config) {
                            return
                        }
                        if (jumpToEnd) {
                            config.transitionAnimation.finish()
                        } else {
                            if ((0, _type.isPlainObject)(config.to)) {
                                (0, _iterator.each)(config.to, (function(key) {
                                    $element.css(key, $element.css(key))
                                }))
                            }
                            this._finishTransition($element);
                            this._cleanup($element, config)
                        }
                    }
                };
                var FrameAnimationStrategy = {
                    initAnimation: function($element, config) {
                        setProps($element, config.from)
                    },
                    animate: function($element, config) {
                        var deferred = new _deferred.Deferred;
                        var that = this;
                        if (!config) {
                            return deferred.reject().promise()
                        }(0, _iterator.each)(config.to, (function(prop) {
                            if (void 0 === config.from[prop]) {
                                config.from[prop] = that._normalizeValue($element.css(prop))
                            }
                        }));
                        if (config.to.transform) {
                            config.from.transform = that._parseTransform(config.from.transform);
                            config.to.transform = that._parseTransform(config.to.transform)
                        }
                        config.frameAnimation = {
                            to: config.to,
                            from: config.from,
                            currentValue: config.from,
                            easing: (0, _easing.convertTransitionTimingFuncToEasing)(config.easing),
                            duration: config.duration,
                            startTime: (new Date).valueOf(),
                            finish: function() {
                                this.currentValue = this.to;
                                this.draw();
                                (0, _frame.cancelAnimationFrame)(config.frameAnimation.animationFrameId);
                                deferred.resolve()
                            },
                            draw: function() {
                                if (config.draw) {
                                    config.draw(this.currentValue);
                                    return
                                }
                                var currentValue = (0, _extend.extend)({}, this.currentValue);
                                if (currentValue.transform) {
                                    currentValue.transform = (0, _iterator.map)(currentValue.transform, (function(value, prop) {
                                        if ("translate" === prop) {
                                            return (0, _translator.getTranslateCss)(value)
                                        } else if ("scale" === prop) {
                                            return "scale(" + value + ")"
                                        } else if ("rotate" === prop.substr(0, prop.length - 1)) {
                                            return prop + "(" + value + "deg)"
                                        }
                                    })).join(" ")
                                }
                                $element.css(currentValue)
                            }
                        };
                        if (config.delay) {
                            config.frameAnimation.startTime += config.delay;
                            config.frameAnimation.delayTimeout = setTimeout((function() {
                                that._startAnimation($element, config)
                            }), config.delay)
                        } else {
                            that._startAnimation($element, config)
                        }
                        return deferred.promise()
                    },
                    _startAnimation: function($element, config) {
                        _events_engine.default.off($element, removeEventName);
                        _events_engine.default.on($element, removeEventName, (function() {
                            if (config.frameAnimation) {
                                (0, _frame.cancelAnimationFrame)(config.frameAnimation.animationFrameId)
                            }
                        }));
                        this._animationStep($element, config)
                    },
                    _parseTransform: function(transformString) {
                        var result = {};
                        (0, _iterator.each)(transformString.match(/\w+\d*\w*\([^)]*\)\s*/g), (function(i, part) {
                            var translateData = (0, _translator.parseTranslate)(part);
                            var scaleData = part.match(/scale\((.+?)\)/);
                            var rotateData = part.match(/(rotate.)\((.+)deg\)/);
                            if (translateData) {
                                result.translate = translateData
                            }
                            if (scaleData && scaleData[1]) {
                                result.scale = parseFloat(scaleData[1])
                            }
                            if (rotateData && rotateData[1]) {
                                result[rotateData[1]] = parseFloat(rotateData[2])
                            }
                        }));
                        return result
                    },
                    stop: function($element, config, jumpToEnd) {
                        var frameAnimation = config && config.frameAnimation;
                        if (!frameAnimation) {
                            return
                        }(0, _frame.cancelAnimationFrame)(frameAnimation.animationFrameId);
                        clearTimeout(frameAnimation.delayTimeout);
                        if (jumpToEnd) {
                            frameAnimation.finish()
                        }
                        delete config.frameAnimation
                    },
                    _animationStep: function($element, config) {
                        var frameAnimation = config && config.frameAnimation;
                        if (!frameAnimation) {
                            return
                        }
                        var now = (new Date).valueOf();
                        if (now >= frameAnimation.startTime + frameAnimation.duration) {
                            frameAnimation.finish();
                            return
                        }
                        frameAnimation.currentValue = this._calcStepValue(frameAnimation, now - frameAnimation.startTime);
                        frameAnimation.draw();
                        var that = this;
                        frameAnimation.animationFrameId = (0, _frame.requestAnimationFrame)((function() {
                            that._animationStep($element, config)
                        }))
                    },
                    _calcStepValue: function(frameAnimation, currentDuration) {
                        return function calcValueRecursively(from, to) {
                            var result = Array.isArray(to) ? [] : {};
                            (0, _iterator.each)(to, (function(propName, endPropValue) {
                                if ("string" === typeof endPropValue && false === parseFloat(endPropValue, 10)) {
                                    return true
                                }
                                result[propName] = "object" === _typeof(endPropValue) ? calcValueRecursively(from[propName], endPropValue) : function(propName) {
                                    var x = currentDuration / frameAnimation.duration;
                                    var t = currentDuration;
                                    var b = 1 * from[propName];
                                    var c = to[propName] - from[propName];
                                    var d = frameAnimation.duration;
                                    return (0, _easing.getEasing)(frameAnimation.easing)(x, t, b, c, d)
                                }(propName)
                            }));
                            return result
                        }(frameAnimation.from, frameAnimation.to)
                    },
                    _normalizeValue: function(value) {
                        var numericValue = parseFloat(value, 10);
                        if (false === numericValue) {
                            return value
                        }
                        return numericValue
                    }
                };
                var FallbackToNoAnimationStrategy = {
                    initAnimation: function() {},
                    animate: function() {
                        return (new _deferred.Deferred).resolve().promise()
                    },
                    stop: _common.noop,
                    isSynchronous: true
                };
                var baseConfigValidator = function(config, animationType, validate, typeMessage) {
                    (0, _iterator.each)(["from", "to"], (function() {
                        if (!validate(config[this])) {
                            throw _errors.default.Error("E0010", animationType, this, typeMessage)
                        }
                    }))
                };
                var isObjectConfigValidator = function(config, animationType) {
                    return baseConfigValidator(config, animationType, (function(target) {
                        return (0, _type.isPlainObject)(target)
                    }), "a plain object")
                };
                var CssAnimationConfigurator = {
                    validateConfig: function(config) {
                        ! function(config, animationType) {
                            return baseConfigValidator(config, animationType, (function(target) {
                                return "string" === typeof target
                            }), "a string")
                        }(config, "css")
                    },
                    setup: function() {}
                };
                var positionAliases = {
                    top: {
                        my: "bottom center",
                        at: "top center"
                    },
                    bottom: {
                        my: "top center",
                        at: "bottom center"
                    },
                    right: {
                        my: "left center",
                        at: "right center"
                    },
                    left: {
                        my: "right center",
                        at: "left center"
                    }
                };
                var SlideAnimationConfigurator = {
                    validateConfig: function(config) {
                        isObjectConfigValidator(config, "slide")
                    },
                    setup: function($element, config) {
                        var location = (0, _translator.locate)($element);
                        if ("slide" !== config.type) {
                            var positioningConfig = "slideIn" === config.type ? config.from : config.to;
                            positioningConfig.position = (0, _extend.extend)({
                                of: window
                            }, positionAliases[config.direction]);
                            setupPosition($element, positioningConfig)
                        }
                        this._setUpConfig(location, config.from);
                        this._setUpConfig(location, config.to);
                        (0, _translator.clearCache)($element)
                    },
                    _setUpConfig: function(location, config) {
                        config.left = "left" in config ? config.left : "+=0";
                        config.top = "top" in config ? config.top : "+=0";
                        this._initNewPosition(location, config)
                    },
                    _initNewPosition: function(location, config) {
                        var position = {
                            left: config.left,
                            top: config.top
                        };
                        delete config.left;
                        delete config.top;
                        var relativeValue = this._getRelativeValue(position.left);
                        if (void 0 !== relativeValue) {
                            position.left = relativeValue + location.left
                        } else {
                            config.left = 0
                        }
                        relativeValue = this._getRelativeValue(position.top);
                        if (void 0 !== relativeValue) {
                            position.top = relativeValue + location.top
                        } else {
                            config.top = 0
                        }
                        config.transform = (0, _translator.getTranslateCss)({
                            x: position.left,
                            y: position.top
                        })
                    },
                    _getRelativeValue: function(value) {
                        var relativeValue;
                        if ("string" === typeof value && (relativeValue = RELATIVE_VALUE_REGEX.exec(value))) {
                            return parseInt(relativeValue[1] + "1") * relativeValue[2]
                        }
                    }
                };
                var FadeAnimationConfigurator = {
                    setup: function($element, config) {
                        var _from$opacity, _to$opacity;
                        var from = config.from;
                        var to = config.to;
                        var defaultFromOpacity = "fadeOut" === config.type ? 1 : 0;
                        var defaultToOpacity = "fadeOut" === config.type ? 0 : 1;
                        var fromOpacity = (0, _type.isPlainObject)(from) ? String(null !== (_from$opacity = from.opacity) && void 0 !== _from$opacity ? _from$opacity : defaultFromOpacity) : String(from);
                        var toOpacity = (0, _type.isPlainObject)(to) ? String(null !== (_to$opacity = to.opacity) && void 0 !== _to$opacity ? _to$opacity : defaultToOpacity) : String(to);
                        if (!config.skipElementInitialStyles) {
                            fromOpacity = $element.css("opacity")
                        }
                        switch (config.type) {
                            case "fadeIn":
                                toOpacity = 1;
                                break;
                            case "fadeOut":
                                toOpacity = 0
                        }
                        config.from = {
                            visibility: "visible",
                            opacity: fromOpacity
                        };
                        config.to = {
                            opacity: toOpacity
                        }
                    }
                };
                var PopAnimationConfigurator = {
                    validateConfig: function(config) {
                        isObjectConfigValidator(config, "pop")
                    },
                    setup: function($element, config) {
                        var from = config.from;
                        var to = config.to;
                        var fromOpacity = "opacity" in from ? from.opacity : $element.css("opacity");
                        var toOpacity = "opacity" in to ? to.opacity : 1;
                        var fromScale = "scale" in from ? from.scale : 0;
                        var toScale = "scale" in to ? to.scale : 1;
                        config.from = {
                            opacity: fromOpacity
                        };
                        var translate = (0, _translator.getTranslate)($element);
                        config.from.transform = this._getCssTransform(translate, fromScale);
                        config.to = {
                            opacity: toOpacity
                        };
                        config.to.transform = this._getCssTransform(translate, toScale)
                    },
                    _getCssTransform: function(translate, scale) {
                        return (0, _translator.getTranslateCss)(translate) + "scale(" + scale + ")"
                    }
                };
                var animationConfigurators = {
                    custom: {
                        setup: function() {}
                    },
                    slide: SlideAnimationConfigurator,
                    slideIn: SlideAnimationConfigurator,
                    slideOut: SlideAnimationConfigurator,
                    fade: FadeAnimationConfigurator,
                    fadeIn: FadeAnimationConfigurator,
                    fadeOut: FadeAnimationConfigurator,
                    pop: PopAnimationConfigurator,
                    css: CssAnimationConfigurator
                };
                var defaultJSConfig = {
                    type: "custom",
                    from: {},
                    to: {},
                    duration: 400,
                    start: _common.noop,
                    complete: _common.noop,
                    easing: "ease",
                    delay: 0
                };
                var defaultCssConfig = {
                    duration: 400,
                    easing: "ease",
                    delay: 0
                };

                function setupAnimationOnElement() {
                    var $element = this.element;
                    var config = this.config;
                    setupPosition($element, config.from);
                    setupPosition($element, config.to);
                    this.configurator.setup($element, config);
                    $element.data("dxAnimData", this);
                    if (fx.off) {
                        config.duration = 0;
                        config.delay = 0
                    }
                    this.strategy.initAnimation($element, config);
                    if (config.start) {
                        var element = (0, _element.getPublicElement)($element);
                        config.start.apply(this, [element, config])
                    }
                }
                var startAnimationOnElement = function() {
                    var animation = this;
                    var $element = animation.element;
                    var config = animation.config;
                    animation.isStarted = true;
                    return animation.strategy.animate($element, config).done((function() {
                        ! function(animation) {
                            var $element = animation.element;
                            var config = animation.config;
                            $element.removeData("dxAnimData");
                            if (config.complete) {
                                var element = (0, _element.getPublicElement)($element);
                                config.complete.apply(this, [element, config])
                            }
                            animation.deferred.resolveWith(this, [$element, config])
                        }(animation)
                    })).fail((function() {
                        animation.deferred.rejectWith(this, [$element, config])
                    }))
                };
                var stopAnimationOnElement = function(jumpToEnd) {
                    var $element = this.element;
                    var config = this.config;
                    clearTimeout(this.startTimeout);
                    if (!this.isStarted) {
                        this.start()
                    }
                    this.strategy.stop($element, config, jumpToEnd)
                };
                var scopedRemoveEvent = (0, _index.addNamespace)(_remove.removeEvent, "dxFXStartAnimation");
                var createAnimation = function(element, initialConfig) {
                    var defaultConfig = "css" === initialConfig.type ? defaultCssConfig : defaultJSConfig;
                    var config = (0, _extend.extend)(true, {}, defaultConfig, initialConfig);
                    var configurator = function(config) {
                        var result = animationConfigurators[config.type];
                        if (!result) {
                            throw _errors.default.Error("E0011", config.type)
                        }
                        return result
                    }(config);
                    var strategy = function(config) {
                        config = config || {};
                        var animationStrategies = {
                            transition: (0, _support.transition)() ? TransitionAnimationStrategy : FrameAnimationStrategy,
                            frame: FrameAnimationStrategy,
                            noAnimation: FallbackToNoAnimationStrategy
                        };
                        var strategy = config.strategy || "transition";
                        if ("css" === config.type && !(0, _support.transition)()) {
                            strategy = "noAnimation"
                        }
                        return animationStrategies[strategy]
                    }(config);
                    var animation = {
                        element: (0, _renderer.default)(element),
                        config: config,
                        configurator: configurator,
                        strategy: strategy,
                        isSynchronous: strategy.isSynchronous,
                        setup: setupAnimationOnElement,
                        start: startAnimationOnElement,
                        stop: stopAnimationOnElement,
                        deferred: new _deferred.Deferred
                    };
                    if ((0, _type.isFunction)(configurator.validateConfig)) {
                        configurator.validateConfig(config)
                    }! function(animation) {
                        _events_engine.default.off(animation.element, scopedRemoveEvent);
                        _events_engine.default.on(animation.element, scopedRemoveEvent, (function() {
                            fx.stop(animation.element)
                        }));
                        animation.deferred.always((function() {
                            _events_engine.default.off(animation.element, scopedRemoveEvent)
                        }))
                    }(animation);
                    return animation
                };

                function getAnimQueueData($element) {
                    return $element.data("dxAnimQueue") || []
                }
                var destroyAnimQueueData = function($element) {
                    $element.removeData("dxAnimQueue")
                };

                function isAnimating($element) {
                    return !!$element.data("dxAnimData")
                }

                function shiftFromAnimationQueue($element, queueData) {
                    queueData = getAnimQueueData($element);
                    if (!queueData.length) {
                        return
                    }
                    var animation = queueData.shift();
                    if (0 === queueData.length) {
                        destroyAnimQueueData($element)
                    }(function(animation) {
                        animation.setup();
                        if (fx.off || animation.isSynchronous) {
                            animation.start()
                        } else {
                            animation.startTimeout = setTimeout((function() {
                                animation.start()
                            }))
                        }
                        return animation.deferred.promise()
                    })(animation).done((function() {
                        if (!isAnimating($element)) {
                            shiftFromAnimationQueue($element)
                        }
                    }))
                }

                function setupPosition($element, config) {
                    if (!config || !config.position) {
                        return
                    }
                    var win = (0, _renderer.default)(window);
                    var left = 0;
                    var top = 0;
                    var position = _position.default.calculate($element, config.position);
                    var offset = $element.offset();
                    var currentPosition = $element.position();
                    if (currentPosition.top > offset.top) {
                        top = win.scrollTop()
                    }
                    if (currentPosition.left > offset.left) {
                        left = win.scrollLeft()
                    }(0, _extend.extend)(config, {
                        left: position.h.location - offset.left + currentPosition.left - left,
                        top: position.v.location - offset.top + currentPosition.top - top
                    });
                    delete config.position
                }

                function setProps($element, props) {
                    (0, _iterator.each)(props, (function(key, value) {
                        try {
                            $element.css(key, (0, _type.isFunction)(value) ? value() : value)
                        } catch (e) {}
                    }))
                }
                var fx = {
                    off: false,
                    animationTypes: animationConfigurators,
                    animate: function(element, config) {
                        var $element = (0, _renderer.default)(element);
                        if (!$element.length) {
                            return (new _deferred.Deferred).resolve().promise()
                        }
                        var animation = createAnimation($element, config);
                        ! function($element, animation) {
                            var queueData = getAnimQueueData($element);
                            ! function($element, queueData) {
                                $element.data("dxAnimQueue", queueData)
                            }($element, queueData);
                            queueData.push(animation);
                            if (!isAnimating($element)) {
                                shiftFromAnimationQueue($element, queueData)
                            }
                        }($element, animation);
                        return animation.deferred.promise()
                    },
                    createAnimation: createAnimation,
                    isAnimating: isAnimating,
                    stop: function(element, jumpToEnd) {
                        var $element = (0, _renderer.default)(element);
                        var queueData = getAnimQueueData($element);
                        (0, _iterator.each)(queueData, (function(_, animation) {
                            animation.config.delay = 0;
                            animation.config.duration = 0;
                            animation.isSynchronous = true
                        }));
                        if (!isAnimating($element)) {
                            shiftFromAnimationQueue($element, queueData)
                        }
                        var animation = $element.data("dxAnimData");
                        if (animation) {
                            animation.stop(jumpToEnd)
                        }
                        $element.removeData("dxAnimData");
                        destroyAnimQueueData($element)
                    },
                    _simulatedTransitionEndDelay: 100
                };
                var _default = fx;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        49387:
            /*!*******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/animation/position.js ***!
              \*******************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _size = __webpack_require__( /*! ../core/utils/size */ 58664);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 68374));
                var _common = __webpack_require__( /*! ../core/utils/common */ 20576);
                var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 95479);
                var _window = __webpack_require__( /*! ../core/utils/window */ 58201);
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../core/dom_adapter */ 73349));
                var _type = __webpack_require__( /*! ../core/utils/type */ 35922);
                var _extend = __webpack_require__( /*! ../core/utils/extend */ 13306);
                var _position = __webpack_require__( /*! ../core/utils/position */ 37518);
                var _browser = _interopRequireDefault(__webpack_require__( /*! ../core/utils/browser */ 47810));
                var _translator = __webpack_require__( /*! ./translator */ 31648);
                var _support = __webpack_require__( /*! ../core/utils/support */ 60137);
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../core/devices */ 20530));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var window = (0, _window.getWindow)();
                var horzRe = /left|right/;
                var vertRe = /top|bottom/;
                var collisionRe = /fit|flip|none/;
                var scaleRe = /scale\(.+?\)/;
                var IS_SAFARI = _browser.default.safari;
                var normalizeAlign = function(raw) {
                    var result = {
                        h: "center",
                        v: "center"
                    };
                    var pair = (0, _common.splitPair)(raw);
                    if (pair) {
                        (0, _iterator.each)(pair, (function() {
                            var w = String(this).toLowerCase();
                            if (horzRe.test(w)) {
                                result.h = w
                            } else if (vertRe.test(w)) {
                                result.v = w
                            }
                        }))
                    }
                    return result
                };
                var normalizeOffset = function(raw) {
                    return (0, _common.pairToObject)(raw)
                };
                var getAlignFactor = function(align) {
                    switch (align) {
                        case "center":
                            return .5;
                        case "right":
                        case "bottom":
                            return 1;
                        default:
                            return 0
                    }
                };
                var inverseAlign = function(align) {
                    switch (align) {
                        case "left":
                            return "right";
                        case "right":
                            return "left";
                        case "top":
                            return "bottom";
                        case "bottom":
                            return "top";
                        default:
                            return align
                    }
                };
                var calculateOversize = function(data, bounds) {
                    var oversize = 0;
                    if (data.myLocation < bounds.min) {
                        oversize += bounds.min - data.myLocation
                    }
                    if (data.myLocation > bounds.max) {
                        oversize += data.myLocation - bounds.max
                    }
                    return oversize
                };
                var collisionSide = function(direction, data, bounds) {
                    if (data.myLocation < bounds.min) {
                        return "h" === direction ? "left" : "top"
                    }
                    if (data.myLocation > bounds.max) {
                        return "h" === direction ? "right" : "bottom"
                    }
                    return "none"
                };
                var initMyLocation = function(data) {
                    data.myLocation = data.atLocation + getAlignFactor(data.atAlign) * data.atSize - getAlignFactor(data.myAlign) * data.mySize + data.offset
                };
                var collisionResolvers = {
                    fit: function(data, bounds) {
                        var result = false;
                        if (data.myLocation > bounds.max) {
                            data.myLocation = bounds.max;
                            result = true
                        }
                        if (data.myLocation < bounds.min) {
                            data.myLocation = bounds.min;
                            result = true
                        }
                        data.fit = result
                    },
                    flip: function(data, bounds) {
                        data.flip = false;
                        if ("center" === data.myAlign && "center" === data.atAlign) {
                            return
                        }
                        if (data.myLocation < bounds.min || data.myLocation > bounds.max) {
                            var inverseData = (0, _extend.extend)({}, data, {
                                myAlign: inverseAlign(data.myAlign),
                                atAlign: inverseAlign(data.atAlign),
                                offset: -data.offset
                            });
                            initMyLocation(inverseData);
                            inverseData.oversize = calculateOversize(inverseData, bounds);
                            if (inverseData.myLocation >= bounds.min && inverseData.myLocation <= bounds.max || data.oversize > inverseData.oversize) {
                                data.myLocation = inverseData.myLocation;
                                data.oversize = inverseData.oversize;
                                data.flip = true
                            }
                        }
                    },
                    flipfit: function(data, bounds) {
                        this.flip(data, bounds);
                        this.fit(data, bounds)
                    },
                    none: function(data) {
                        data.oversize = 0
                    }
                };
                var scrollbarWidth;
                var calculateScrollbarWidth = function() {
                    var $scrollDiv = (0, _renderer.default)("<div>").css({
                        width: 100,
                        height: 100,
                        overflow: "scroll",
                        position: "absolute",
                        top: -9999
                    }).appendTo((0, _renderer.default)("body"));
                    var result = $scrollDiv.get(0).offsetWidth - $scrollDiv.get(0).clientWidth;
                    $scrollDiv.remove();
                    scrollbarWidth = result
                };
                var defaultPositionResult = {
                    h: {
                        location: 0,
                        flip: false,
                        fit: false,
                        oversize: 0
                    },
                    v: {
                        location: 0,
                        flip: false,
                        fit: false,
                        oversize: 0
                    }
                };
                var calculatePosition = function(what, options) {
                    var $what = (0, _renderer.default)(what);
                    var currentOffset = $what.offset();
                    var result = (0, _extend.extend)(true, {}, defaultPositionResult, {
                        h: {
                            location: currentOffset.left
                        },
                        v: {
                            location: currentOffset.top
                        }
                    });
                    if (!options) {
                        return result
                    }
                    var my = normalizeAlign(options.my);
                    var at = normalizeAlign(options.at);
                    var of = (0, _renderer.default)(options.of).length && options.of || window;
                    var offset = normalizeOffset(options.offset);
                    var collision = function(raw) {
                        var pair = (0, _common.splitPair)(raw);
                        var h = String(pair && pair[0]).toLowerCase();
                        var v = String(pair && pair[1]).toLowerCase();
                        if (!collisionRe.test(h)) {
                            h = "none"
                        }
                        if (!collisionRe.test(v)) {
                            v = h
                        }
                        return {
                            h: h,
                            v: v
                        }
                    }(options.collision);
                    var boundary = options.boundary;
                    var boundaryOffset = normalizeOffset(options.boundaryOffset);
                    var h = {
                        mySize: (0, _size.getOuterWidth)($what),
                        myAlign: my.h,
                        atAlign: at.h,
                        offset: offset.h,
                        collision: collision.h,
                        boundaryOffset: boundaryOffset.h
                    };
                    var v = {
                        mySize: (0, _size.getOuterHeight)($what),
                        myAlign: my.v,
                        atAlign: at.v,
                        offset: offset.v,
                        collision: collision.v,
                        boundaryOffset: boundaryOffset.v
                    };
                    if ( of .preventDefault) {
                        h.atLocation = of .pageX;
                        v.atLocation = of .pageY;
                        h.atSize = 0;
                        v.atSize = 0
                    } else {
                        of = (0, _renderer.default)( of );
                        if ((0, _type.isWindow)( of [0])) {
                            h.atLocation = of .scrollLeft();
                            v.atLocation = of .scrollTop();
                            if ("phone" === _devices.default.real().deviceType && of [0].visualViewport) {
                                h.atLocation = Math.max(h.atLocation, of [0].visualViewport.offsetLeft);
                                v.atLocation = Math.max(v.atLocation, of [0].visualViewport.offsetTop);
                                h.atSize = of [0].visualViewport.width;
                                v.atSize = of [0].visualViewport.height
                            } else {
                                h.atSize = of [0].innerWidth > of [0].outerWidth ? of [0].innerWidth : (0, _size.getWidth)( of );
                                v.atSize = of [0].innerHeight > of [0].outerHeight || IS_SAFARI ? of [0].innerHeight : (0, _size.getHeight)( of )
                            }
                        } else if (9 === of [0].nodeType) {
                            h.atLocation = 0;
                            v.atLocation = 0;
                            h.atSize = (0, _size.getWidth)( of );
                            v.atSize = (0, _size.getHeight)( of )
                        } else {
                            var ofRect = (0, _position.getBoundingRect)( of .get(0));
                            var o = getOffsetWithoutScale( of );
                            h.atLocation = o.left;
                            v.atLocation = o.top;
                            h.atSize = Math.max(ofRect.width, (0, _size.getOuterWidth)( of ));
                            v.atSize = Math.max(ofRect.height, (0, _size.getOuterHeight)( of ))
                        }
                    }
                    initMyLocation(h);
                    initMyLocation(v);
                    var bounds = function() {
                        var win = (0, _renderer.default)(window);
                        var windowWidth = (0, _size.getWidth)(win);
                        var windowHeight = (0, _size.getHeight)(win);
                        var left = win.scrollLeft();
                        var top = win.scrollTop();
                        var documentElement = _dom_adapter.default.getDocumentElement();
                        var hZoomLevel = _support.touch ? documentElement.clientWidth / windowWidth : 1;
                        var vZoomLevel = _support.touch ? documentElement.clientHeight / windowHeight : 1;
                        if (void 0 === scrollbarWidth) {
                            calculateScrollbarWidth()
                        }
                        var boundaryWidth = windowWidth;
                        var boundaryHeight = windowHeight;
                        if (boundary) {
                            var $boundary = (0, _renderer.default)(boundary);
                            var boundaryPosition = $boundary.offset();
                            left = boundaryPosition.left;
                            top = boundaryPosition.top;
                            boundaryWidth = (0, _size.getWidth)($boundary);
                            boundaryHeight = (0, _size.getHeight)($boundary)
                        }
                        return {
                            h: {
                                min: left + h.boundaryOffset,
                                max: left + boundaryWidth / hZoomLevel - h.mySize - h.boundaryOffset
                            },
                            v: {
                                min: top + v.boundaryOffset,
                                max: top + boundaryHeight / vZoomLevel - v.mySize - v.boundaryOffset
                            }
                        }
                    }();
                    h.oversize = calculateOversize(h, bounds.h);
                    v.oversize = calculateOversize(v, bounds.v);
                    h.collisionSide = collisionSide("h", h, bounds.h);
                    v.collisionSide = collisionSide("v", v, bounds.v);
                    if (collisionResolvers[h.collision]) {
                        collisionResolvers[h.collision](h, bounds.h)
                    }
                    if (collisionResolvers[v.collision]) {
                        collisionResolvers[v.collision](v, bounds.v)
                    }
                    var preciser = function(number) {
                        return options.precise ? number : Math.round(number)
                    };
                    (0, _extend.extend)(true, result, {
                        h: {
                            location: preciser(h.myLocation),
                            oversize: preciser(h.oversize),
                            fit: h.fit,
                            flip: h.flip,
                            collisionSide: h.collisionSide
                        },
                        v: {
                            location: preciser(v.myLocation),
                            oversize: preciser(v.oversize),
                            fit: v.fit,
                            flip: v.flip,
                            collisionSide: v.collisionSide
                        },
                        precise: options.precise
                    });
                    return result
                };
                var setScaleProperty = function(element, scale, transformProp, styleAttr, isEmpty) {
                    var stylePropIsValid = (0, _type.isDefined)(element.style) && !_dom_adapter.default.isNode(element.style);
                    if (stylePropIsValid) {
                        element.style.transform = isEmpty ? transformProp.replace(scale, "") : transformProp
                    } else {
                        element.setAttribute("style", isEmpty ? styleAttr.replace(scale, "") : styleAttr)
                    }
                };
                var getOffsetWithoutScale = function getOffsetWithoutScale($startElement) {
                    var _currentElement$getAt, _currentElement$style, _style$match;
                    var $currentElement = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : $startElement;
                    var currentElement = $currentElement.get(0);
                    if (!currentElement) {
                        return $startElement.offset()
                    }
                    var style = (null === (_currentElement$getAt = currentElement.getAttribute) || void 0 === _currentElement$getAt ? void 0 : _currentElement$getAt.call(currentElement, "style")) || "";
                    var transform = null === (_currentElement$style = currentElement.style) || void 0 === _currentElement$style ? void 0 : _currentElement$style.transform;
                    var scale = null === (_style$match = style.match(scaleRe)) || void 0 === _style$match ? void 0 : _style$match[0];
                    var offset;
                    if (scale) {
                        setScaleProperty(currentElement, scale, transform, style, true);
                        offset = getOffsetWithoutScale($startElement, $currentElement.parent());
                        setScaleProperty(currentElement, scale, transform, style, false)
                    } else {
                        offset = getOffsetWithoutScale($startElement, $currentElement.parent())
                    }
                    return offset
                };
                var position = function(what, options) {
                    var $what = (0, _renderer.default)(what);
                    if (!options) {
                        return $what.offset()
                    }(0, _translator.resetPosition)($what, true);
                    var offset = getOffsetWithoutScale($what);
                    var targetPosition = options.h && options.v ? options : calculatePosition($what, options);
                    var preciser = function(number) {
                        return options.precise ? number : Math.round(number)
                    };
                    (0, _translator.move)($what, {
                        left: targetPosition.h.location - preciser(offset.left),
                        top: targetPosition.v.location - preciser(offset.top)
                    });
                    return targetPosition
                };
                if (!position.inverseAlign) {
                    position.inverseAlign = inverseAlign
                }
                if (!position.normalizeAlign) {
                    position.normalizeAlign = normalizeAlign
                }
                var _default = {
                    calculateScrollbarWidth: calculateScrollbarWidth,
                    calculate: calculatePosition,
                    setup: position,
                    offset: function(element) {
                        element = (0, _renderer.default)(element).get(0);
                        if ((0, _type.isWindow)(element)) {
                            return null
                        } else if (element && "pageY" in element && "pageX" in element) {
                            return {
                                top: element.pageY,
                                left: element.pageX
                            }
                        }
                        return (0, _renderer.default)(element).offset()
                    }
                };
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        42814:
            /*!**************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/animation/presets/presets.js ***!
              \**************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.presets = exports.PresetCollection = void 0;
                var _size = __webpack_require__( /*! ../../core/utils/size */ 58664);
                var _component = __webpack_require__( /*! ../../core/component */ 44297);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 95479);
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../../core/devices */ 20530));
                var _fx = _interopRequireDefault(__webpack_require__( /*! ../fx */ 87209));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var directionPostfixes = {
                    forward: " dx-forward",
                    backward: " dx-backward",
                    none: " dx-no-direction",
                    undefined: " dx-no-direction"
                };
                var AnimationPresetCollection = _component.Component.inherit({
                    ctor: function() {
                        this.callBase.apply(this, arguments);
                        this._registeredPresets = [];
                        this.resetToDefaults()
                    },
                    _getDefaultOptions: function() {
                        return (0, _extend.extend)(this.callBase(), {
                            defaultAnimationDuration: 400,
                            defaultAnimationDelay: 0,
                            defaultStaggerAnimationDuration: 300,
                            defaultStaggerAnimationDelay: 40,
                            defaultStaggerAnimationStartDelay: 500
                        })
                    },
                    _defaultOptionsRules: function() {
                        return this.callBase().concat([{
                            device: function(_device) {
                                return _device.phone
                            },
                            options: {
                                defaultStaggerAnimationDuration: 350,
                                defaultStaggerAnimationDelay: 50,
                                defaultStaggerAnimationStartDelay: 0
                            }
                        }, {
                            device: function() {
                                return _devices.default.current().android || _devices.default.real.android
                            },
                            options: {
                                defaultAnimationDelay: 100
                            }
                        }])
                    },
                    _getPresetOptionName: function(animationName) {
                        return "preset_" + animationName
                    },
                    _createAndroidSlideAnimationConfig: function(throughOpacity, widthMultiplier) {
                        var that = this;
                        var createBaseConfig = function(configModifier) {
                            return {
                                type: "slide",
                                delay: void 0 === configModifier.delay ? that.option("defaultAnimationDelay") : configModifier.delay,
                                duration: void 0 === configModifier.duration ? that.option("defaultAnimationDuration") : configModifier.duration
                            }
                        };
                        return {
                            enter: function($element, configModifier) {
                                var width = (0, _size.getWidth)($element.parent()) * widthMultiplier;
                                var direction = configModifier.direction;
                                var config = createBaseConfig(configModifier);
                                config.to = {
                                    left: 0,
                                    opacity: 1
                                };
                                if ("forward" === direction) {
                                    config.from = {
                                        left: width,
                                        opacity: throughOpacity
                                    }
                                } else if ("backward" === direction) {
                                    config.from = {
                                        left: -width,
                                        opacity: throughOpacity
                                    }
                                } else {
                                    config.from = {
                                        left: 0,
                                        opacity: 0
                                    }
                                }
                                return _fx.default.createAnimation($element, config)
                            },
                            leave: function($element, configModifier) {
                                var width = (0, _size.getWidth)($element.parent()) * widthMultiplier;
                                var direction = configModifier.direction;
                                var config = createBaseConfig(configModifier);
                                config.from = {
                                    left: 0,
                                    opacity: 1
                                };
                                if ("forward" === direction) {
                                    config.to = {
                                        left: -width,
                                        opacity: throughOpacity
                                    }
                                } else if ("backward" === direction) {
                                    config.to = {
                                        left: width,
                                        opacity: throughOpacity
                                    }
                                } else {
                                    config.to = {
                                        left: 0,
                                        opacity: 0
                                    }
                                }
                                return _fx.default.createAnimation($element, config)
                            }
                        }
                    },
                    _createOpenDoorConfig: function() {
                        var that = this;
                        var createBaseConfig = function(configModifier) {
                            return {
                                type: "css",
                                extraCssClasses: "dx-opendoor-animation",
                                delay: void 0 === configModifier.delay ? that.option("defaultAnimationDelay") : configModifier.delay,
                                duration: void 0 === configModifier.duration ? that.option("defaultAnimationDuration") : configModifier.duration
                            }
                        };
                        return {
                            enter: function($element, configModifier) {
                                var direction = configModifier.direction;
                                var config = createBaseConfig(configModifier);
                                config.delay = "none" === direction ? config.delay : config.duration;
                                config.from = "dx-enter dx-opendoor-animation" + directionPostfixes[direction];
                                config.to = "dx-enter-active";
                                return _fx.default.createAnimation($element, config)
                            },
                            leave: function($element, configModifier) {
                                var direction = configModifier.direction;
                                var config = createBaseConfig(configModifier);
                                config.from = "dx-leave dx-opendoor-animation" + directionPostfixes[direction];
                                config.to = "dx-leave-active";
                                return _fx.default.createAnimation($element, config)
                            }
                        }
                    },
                    _createWinPopConfig: function() {
                        var that = this;
                        var baseConfig = {
                            type: "css",
                            extraCssClasses: "dx-win-pop-animation",
                            duration: that.option("defaultAnimationDuration")
                        };
                        return {
                            enter: function($element, configModifier) {
                                var config = baseConfig;
                                var direction = configModifier.direction;
                                config.delay = "none" === direction ? that.option("defaultAnimationDelay") : that.option("defaultAnimationDuration") / 2;
                                config.from = "dx-enter dx-win-pop-animation" + directionPostfixes[direction];
                                config.to = "dx-enter-active";
                                return _fx.default.createAnimation($element, config)
                            },
                            leave: function($element, configModifier) {
                                var config = baseConfig;
                                var direction = configModifier.direction;
                                config.delay = that.option("defaultAnimationDelay");
                                config.from = "dx-leave dx-win-pop-animation" + directionPostfixes[direction];
                                config.to = "dx-leave-active";
                                return _fx.default.createAnimation($element, config)
                            }
                        }
                    },
                    resetToDefaults: function() {
                        this.clear();
                        this.registerDefaultPresets();
                        this.applyChanges()
                    },
                    clear: function(name) {
                        var that = this;
                        var newRegisteredPresets = [];
                        (0, _iterator.each)(this._registeredPresets, (function(index, preset) {
                            if (!name || name === preset.name) {
                                that.option(that._getPresetOptionName(preset.name), void 0)
                            } else {
                                newRegisteredPresets.push(preset)
                            }
                        }));
                        this._registeredPresets = newRegisteredPresets;
                        this.applyChanges()
                    },
                    registerPreset: function(name, config) {
                        this._registeredPresets.push({
                            name: name,
                            config: config
                        })
                    },
                    applyChanges: function() {
                        var that = this;
                        var customRules = [];
                        (0, _iterator.each)(this._registeredPresets, (function(index, preset) {
                            var rule = {
                                device: preset.config.device,
                                options: {}
                            };
                            rule.options[that._getPresetOptionName(preset.name)] = preset.config.animation;
                            customRules.push(rule)
                        }));
                        this._setOptionsByDevice(customRules)
                    },
                    getPreset: function(name) {
                        var result = name;
                        while ("string" === typeof result) {
                            result = this.option(this._getPresetOptionName(result))
                        }
                        return result
                    },
                    registerDefaultPresets: function() {
                        this.registerPreset("pop", {
                            animation: {
                                extraCssClasses: "dx-android-pop-animation",
                                delay: this.option("defaultAnimationDelay"),
                                duration: this.option("defaultAnimationDuration")
                            }
                        });
                        this.registerPreset("openDoor", {
                            animation: this._createOpenDoorConfig()
                        });
                        this.registerPreset("win-pop", {
                            animation: this._createWinPopConfig()
                        });
                        this.registerPreset("fade", {
                            animation: {
                                extraCssClasses: "dx-fade-animation",
                                delay: this.option("defaultAnimationDelay"),
                                duration: this.option("defaultAnimationDuration")
                            }
                        });
                        this.registerPreset("slide", {
                            device: function() {
                                return _devices.default.current().android || _devices.default.real.android
                            },
                            animation: this._createAndroidSlideAnimationConfig(1, 1)
                        });
                        this.registerPreset("slide", {
                            device: function() {
                                return !_devices.default.current().android && !_devices.default.real.android
                            },
                            animation: {
                                extraCssClasses: "dx-slide-animation",
                                delay: this.option("defaultAnimationDelay"),
                                duration: this.option("defaultAnimationDuration")
                            }
                        });
                        this.registerPreset("ios7-slide", {
                            animation: {
                                extraCssClasses: "dx-ios7-slide-animation",
                                delay: this.option("defaultAnimationDelay"),
                                duration: this.option("defaultAnimationDuration")
                            }
                        });
                        this.registerPreset("overflow", {
                            animation: {
                                extraCssClasses: "dx-overflow-animation",
                                delay: this.option("defaultAnimationDelay"),
                                duration: this.option("defaultAnimationDuration")
                            }
                        });
                        this.registerPreset("ios7-toolbar", {
                            device: function() {
                                return !_devices.default.current().android && !_devices.default.real.android
                            },
                            animation: {
                                extraCssClasses: "dx-ios7-toolbar-animation",
                                delay: this.option("defaultAnimationDelay"),
                                duration: this.option("defaultAnimationDuration")
                            }
                        });
                        this.registerPreset("ios7-toolbar", {
                            device: function() {
                                return _devices.default.current().android || _devices.default.real.android
                            },
                            animation: this._createAndroidSlideAnimationConfig(0, .4)
                        });
                        this.registerPreset("stagger-fade", {
                            animation: {
                                extraCssClasses: "dx-fade-animation",
                                staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                duration: this.option("defaultStaggerAnimationDuration"),
                                delay: this.option("defaultStaggerAnimationStartDelay")
                            }
                        });
                        this.registerPreset("stagger-slide", {
                            animation: {
                                extraCssClasses: "dx-slide-animation",
                                staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                duration: this.option("defaultStaggerAnimationDuration"),
                                delay: this.option("defaultStaggerAnimationStartDelay")
                            }
                        });
                        this.registerPreset("stagger-fade-slide", {
                            animation: {
                                extraCssClasses: "dx-fade-slide-animation",
                                staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                duration: this.option("defaultStaggerAnimationDuration"),
                                delay: this.option("defaultStaggerAnimationStartDelay")
                            }
                        });
                        this.registerPreset("stagger-drop", {
                            animation: {
                                extraCssClasses: "dx-drop-animation",
                                staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                duration: this.option("defaultStaggerAnimationDuration"),
                                delay: this.option("defaultStaggerAnimationStartDelay")
                            }
                        });
                        this.registerPreset("stagger-fade-drop", {
                            animation: {
                                extraCssClasses: "dx-fade-drop-animation",
                                staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                duration: this.option("defaultStaggerAnimationDuration"),
                                delay: this.option("defaultStaggerAnimationStartDelay")
                            }
                        });
                        this.registerPreset("stagger-fade-rise", {
                            animation: {
                                extraCssClasses: "dx-fade-rise-animation",
                                staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                duration: this.option("defaultStaggerAnimationDuration"),
                                delay: this.option("defaultStaggerAnimationStartDelay")
                            }
                        });
                        this.registerPreset("stagger-3d-drop", {
                            animation: {
                                extraCssClasses: "dx-3d-drop-animation",
                                staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                duration: this.option("defaultStaggerAnimationDuration"),
                                delay: this.option("defaultStaggerAnimationStartDelay")
                            }
                        });
                        this.registerPreset("stagger-fade-zoom", {
                            animation: {
                                extraCssClasses: "dx-fade-zoom-animation",
                                staggerDelay: this.option("defaultStaggerAnimationDelay"),
                                duration: this.option("defaultStaggerAnimationDuration"),
                                delay: this.option("defaultStaggerAnimationStartDelay")
                            }
                        })
                    }
                });
                exports.PresetCollection = AnimationPresetCollection;
                var animationPresets = new AnimationPresetCollection;
                exports.presets = animationPresets
            },
        52431:
            /*!**************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/animation/transition_executor/transition_executor.js ***!
              \**************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.TransitionExecutor = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 68374));
                var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 38377));
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _common = __webpack_require__( /*! ../../core/utils/common */ 20576);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 35922);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 95479);
                var _fx = _interopRequireDefault(__webpack_require__( /*! ../fx */ 87209));
                var _presets = __webpack_require__( /*! ../presets/presets */ 42814);
                var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 62754);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var directionPostfixes = {
                    forward: " dx-forward",
                    backward: " dx-backward",
                    none: " dx-no-direction",
                    undefined: " dx-no-direction"
                };
                var TransitionExecutor = _class.default.inherit({
                    ctor: function() {
                        this._accumulatedDelays = {
                            enter: 0,
                            leave: 0
                        };
                        this._animations = [];
                        this.reset()
                    },
                    _createAnimations: function($elements, initialConfig, configModifier, type) {
                        $elements = (0, _renderer.default)($elements);
                        var that = this;
                        var result = [];
                        configModifier = configModifier || {};
                        var animationConfig = this._prepareElementAnimationConfig(initialConfig, configModifier, type);
                        if (animationConfig) {
                            $elements.each((function() {
                                var animation = that._createAnimation((0, _renderer.default)(this), animationConfig, configModifier);
                                if (animation) {
                                    animation.element.addClass("dx-animating");
                                    animation.setup();
                                    result.push(animation)
                                }
                            }))
                        }
                        return result
                    },
                    _prepareElementAnimationConfig: function(config, configModifier, type) {
                        var result;
                        if ("string" === typeof config) {
                            var presetName = config;
                            config = _presets.presets.getPreset(presetName)
                        }
                        if (!config) {
                            result = void 0
                        } else if ((0, _type.isFunction)(config[type])) {
                            result = config[type]
                        } else {
                            result = (0, _extend.extend)({
                                skipElementInitialStyles: true,
                                cleanupWhen: this._completePromise
                            }, config, configModifier);
                            if (!result.type || "css" === result.type) {
                                var cssClass = "dx-" + type;
                                var extraCssClasses = (result.extraCssClasses ? " " + result.extraCssClasses : "") + directionPostfixes[result.direction];
                                result.type = "css";
                                result.from = (result.from || cssClass) + extraCssClasses;
                                result.to = result.to || cssClass + "-active"
                            }
                            result.staggerDelay = result.staggerDelay || 0;
                            result.delay = result.delay || 0;
                            if (result.staggerDelay) {
                                result.delay += this._accumulatedDelays[type];
                                this._accumulatedDelays[type] += result.staggerDelay
                            }
                        }
                        return result
                    },
                    _createAnimation: function($element, animationConfig, configModifier) {
                        var result;
                        if ((0, _type.isPlainObject)(animationConfig)) {
                            result = _fx.default.createAnimation($element, animationConfig)
                        } else if ((0, _type.isFunction)(animationConfig)) {
                            result = animationConfig($element, configModifier)
                        }
                        return result
                    },
                    _startAnimations: function() {
                        var animations = this._animations;
                        for (var i = 0; i < animations.length; i++) {
                            animations[i].start()
                        }
                    },
                    _stopAnimations: function(jumpToEnd) {
                        var animations = this._animations;
                        for (var i = 0; i < animations.length; i++) {
                            animations[i].stop(jumpToEnd)
                        }
                    },
                    _clearAnimations: function() {
                        var animations = this._animations;
                        for (var i = 0; i < animations.length; i++) {
                            animations[i].element.removeClass("dx-animating")
                        }
                        this._animations.length = 0
                    },
                    reset: function() {
                        this._accumulatedDelays.enter = 0;
                        this._accumulatedDelays.leave = 0;
                        this._clearAnimations();
                        this._completeDeferred = new _deferred.Deferred;
                        this._completePromise = this._completeDeferred.promise()
                    },
                    enter: function($elements, animationConfig, configModifier) {
                        var animations = this._createAnimations($elements, animationConfig, configModifier, "enter");
                        this._animations.push.apply(this._animations, animations)
                    },
                    leave: function($elements, animationConfig, configModifier) {
                        var animations = this._createAnimations($elements, animationConfig, configModifier, "leave");
                        this._animations.push.apply(this._animations, animations)
                    },
                    start: function() {
                        var that = this;
                        var result;
                        if (!this._animations.length) {
                            that.reset();
                            result = (new _deferred.Deferred).resolve().promise()
                        } else {
                            var animationDeferreds = (0, _iterator.map)(this._animations, (function(animation) {
                                var result = new _deferred.Deferred;
                                animation.deferred.always((function() {
                                    result.resolve()
                                }));
                                return result.promise()
                            }));
                            result = _deferred.when.apply(_renderer.default, animationDeferreds).always((function() {
                                that._completeDeferred.resolve();
                                that.reset()
                            }));
                            (0, _common.executeAsync)((function() {
                                that._startAnimations()
                            }))
                        }
                        return result
                    },
                    stop: function(jumpToEnd) {
                        this._stopAnimations(jumpToEnd)
                    }
                });
                exports.TransitionExecutor = TransitionExecutor
            },
        31648:
            /*!*********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/animation/translator.js ***!
              \*********************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.resetPosition = exports.parseTranslate = exports.move = exports.locate = exports.getTranslateCss = exports.getTranslate = exports.clearCache = void 0;
                var _renderer = (obj = __webpack_require__( /*! ../core/renderer */ 68374), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _element_data = __webpack_require__( /*! ../core/element_data */ 97906);
                var _type = __webpack_require__( /*! ../core/utils/type */ 35922);
                var TRANSFORM_MATRIX_REGEX = /matrix(3d)?\((.+?)\)/;
                var TRANSLATE_REGEX = /translate(?:3d)?\((.+?)\)/;
                exports.locate = function($element) {
                    $element = (0, _renderer.default)($element);
                    var translate = getTranslate($element);
                    return {
                        left: translate.x,
                        top: translate.y
                    }
                };

                function isPercentValue(value) {
                    return "string" === (0, _type.type)(value) && "%" === value[value.length - 1]
                }

                function cacheTranslate($element, translate) {
                    if ($element.length) {
                        (0, _element_data.data)($element.get(0), "dxTranslator", translate)
                    }
                }
                var clearCache = function($element) {
                    if ($element.length) {
                        (0, _element_data.removeData)($element.get(0), "dxTranslator")
                    }
                };
                exports.clearCache = clearCache;
                var getTranslateCss = function(translate) {
                    translate.x = translate.x || 0;
                    translate.y = translate.y || 0;
                    var xValueString = isPercentValue(translate.x) ? translate.x : translate.x + "px";
                    var yValueString = isPercentValue(translate.y) ? translate.y : translate.y + "px";
                    return "translate(" + xValueString + ", " + yValueString + ")"
                };
                exports.getTranslateCss = getTranslateCss;
                var getTranslate = function($element) {
                    var result = $element.length ? (0, _element_data.data)($element.get(0), "dxTranslator") : null;
                    if (!result) {
                        var transformValue = $element.css("transform") || getTranslateCss({
                            x: 0,
                            y: 0
                        });
                        var matrix = transformValue.match(TRANSFORM_MATRIX_REGEX);
                        var is3D = matrix && matrix[1];
                        if (matrix) {
                            matrix = matrix[2].split(",");
                            if ("3d" === is3D) {
                                matrix = matrix.slice(12, 15)
                            } else {
                                matrix.push(0);
                                matrix = matrix.slice(4, 7)
                            }
                        } else {
                            matrix = [0, 0, 0]
                        }
                        result = {
                            x: parseFloat(matrix[0]),
                            y: parseFloat(matrix[1]),
                            z: parseFloat(matrix[2])
                        };
                        cacheTranslate($element, result)
                    }
                    return result
                };
                exports.getTranslate = getTranslate;
                exports.move = function($element, position) {
                    $element = (0, _renderer.default)($element);
                    var left = position.left;
                    var top = position.top;
                    var translate;
                    if (void 0 === left) {
                        translate = getTranslate($element);
                        translate.y = top || 0
                    } else if (void 0 === top) {
                        translate = getTranslate($element);
                        translate.x = left || 0
                    } else {
                        translate = {
                            x: left || 0,
                            y: top || 0,
                            z: 0
                        };
                        cacheTranslate($element, translate)
                    }
                    $element.css({
                        transform: getTranslateCss(translate)
                    });
                    if (isPercentValue(left) || isPercentValue(top)) {
                        clearCache($element)
                    }
                };
                exports.resetPosition = function($element, finishTransition) {
                    $element = (0, _renderer.default)($element);
                    var originalTransition;
                    var stylesConfig = {
                        left: 0,
                        top: 0,
                        transform: "none"
                    };
                    if (finishTransition) {
                        originalTransition = $element.css("transition");
                        stylesConfig.transition = "none"
                    }
                    $element.css(stylesConfig);
                    clearCache($element);
                    if (finishTransition) {
                        $element.get(0).offsetHeight;
                        $element.css("transition", originalTransition)
                    }
                };
                exports.parseTranslate = function(translateString) {
                    var result = translateString.match(TRANSLATE_REGEX);
                    if (!result || !result[1]) {
                        return
                    }
                    result = result[1].split(",");
                    result = {
                        x: parseFloat(result[0]),
                        y: parseFloat(result[1]),
                        z: parseFloat(result[2])
                    };
                    return result
                }
            },
        16354:
            /*!***************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/dx.all.js ***!
              \***************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                __webpack_require__( /*! ./modules/parts/widgets-all */ 85866);
                __webpack_require__( /*! ./modules/parts/viz */ 66312);
                var _core = (obj = __webpack_require__( /*! ./modules/core */ 36991), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _events_strategy = __webpack_require__( /*! ../core/events_strategy */ 80566);
                var _index = __webpack_require__( /*! ../core/options/index */ 95683);
                _core.default.integration = {};
                _core.default.integration.EventsStrategy = _events_strategy.EventsStrategy;
                _core.default.integration.Options = _index.Options;
                var _default = _core.default;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        36991:
            /*!*********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/core.js ***!
              \*********************************************************************/
            function(module, __unused_webpack_exports, __webpack_require__) {
                var windowUtils = __webpack_require__( /*! ../../core/utils/window */ 58201);
                var window = windowUtils.getWindow();
                var DevExpress = window.DevExpress = window.DevExpress || {};
                var errors = DevExpress.errors = __webpack_require__( /*! ../../core/errors */ 17381);
                if (DevExpress._DEVEXTREME_BUNDLE_INITIALIZED) {
                    throw errors.Error("E0024")
                }
                DevExpress._DEVEXTREME_BUNDLE_INITIALIZED = true;
                DevExpress.clientExporter = __webpack_require__( /*! ../../exporter */ 78292);
                DevExpress.excelExporter = __webpack_require__( /*! ../../excel_exporter */ 2994);
                DevExpress.pdfExporter = __webpack_require__( /*! ../../pdf_exporter */ 44194);
                DevExpress.VERSION = __webpack_require__( /*! ../../core/version */ 36739).version;
                DevExpress.Class = __webpack_require__( /*! ../../core/class */ 38377);
                DevExpress.DOMComponent = __webpack_require__( /*! ../../core/dom_component */ 13046);
                DevExpress.Component = __webpack_require__( /*! ../../core/component */ 44297).Component;
                DevExpress.registerComponent = __webpack_require__( /*! ../../core/component_registrator */ 99393);
                DevExpress.devices = __webpack_require__( /*! ../../core/devices */ 20530);
                DevExpress.Color = __webpack_require__( /*! ../../color */ 52752);
                var animationFrame = __webpack_require__( /*! ../../animation/frame */ 90057);
                DevExpress.utils = {};
                DevExpress.utils.requestAnimationFrame = animationFrame.requestAnimationFrame;
                DevExpress.utils.cancelAnimationFrame = animationFrame.cancelAnimationFrame;
                DevExpress.utils.initMobileViewport = __webpack_require__( /*! ../../mobile/init_mobile_viewport/init_mobile_viewport */ 88185).p;
                DevExpress.utils.getTimeZones = __webpack_require__( /*! ../../time_zone_utils */ 88673).Z;
                DevExpress.utils.extendFromObject = __webpack_require__( /*! ../../core/utils/extend */ 13306).extendFromObject;
                DevExpress.utils.triggerShownEvent = __webpack_require__( /*! ../../events/visibility_change */ 80506).triggerShownEvent;
                DevExpress.utils.triggerHidingEvent = __webpack_require__( /*! ../../events/visibility_change */ 80506).triggerHidingEvent;
                DevExpress.utils.resetActiveElement = __webpack_require__( /*! ../../core/utils/dom */ 3532).resetActiveElement;
                DevExpress.utils.findBestMatches = __webpack_require__( /*! ../../core/utils/common */ 20576).findBestMatches;
                DevExpress.createQueue = __webpack_require__( /*! ../../core/utils/queue */ 59504).create;
                DevExpress.utils.dom = __webpack_require__( /*! ../../core/utils/dom */ 3532);
                DevExpress.utils.common = __webpack_require__( /*! ../../core/utils/common */ 20576);
                DevExpress.utils.date = __webpack_require__( /*! ../../core/utils/date */ 91198);
                DevExpress.utils.browser = __webpack_require__( /*! ../../core/utils/browser */ 47810);
                DevExpress.utils.inflector = __webpack_require__( /*! ../../core/utils/inflector */ 78008);
                DevExpress.utils.iterator = __webpack_require__( /*! ../../core/utils/iterator */ 95479);
                DevExpress.utils.readyCallbacks = __webpack_require__( /*! ../../core/utils/ready_callbacks */ 24311);
                DevExpress.utils.resizeCallbacks = __webpack_require__( /*! ../../core/utils/resize_callbacks */ 55814);
                DevExpress.utils.console = __webpack_require__( /*! ../../core/utils/console */ 30869);
                DevExpress.utils.string = __webpack_require__( /*! ../../core/utils/string */ 68752);
                DevExpress.utils.support = __webpack_require__( /*! ../../core/utils/support */ 60137);
                DevExpress.utils.ajax = __webpack_require__( /*! ../../core/utils/ajax */ 37208);
                DevExpress.viewPort = __webpack_require__( /*! ../../core/utils/view_port */ 77695).value;
                DevExpress.hideTopOverlay = __webpack_require__( /*! ../../mobile/hide_top_overlay */ 60628);
                DevExpress.formatHelper = __webpack_require__( /*! ../../format_helper */ 30343);
                DevExpress.config = __webpack_require__( /*! ../../core/config */ 80209);
                DevExpress.animationPresets = __webpack_require__( /*! ../../animation/presets/presets */ 42814).presets;
                DevExpress.fx = __webpack_require__( /*! ../../animation/fx */ 87209);
                DevExpress.TransitionExecutor = __webpack_require__( /*! ../../animation/transition_executor/transition_executor */ 52431).TransitionExecutor;
                DevExpress.AnimationPresetCollection = __webpack_require__( /*! ../../animation/presets/presets */ 42814).PresetCollection;
                DevExpress.events = __webpack_require__( /*! ../../events */ 66365);
                DevExpress.events.click = __webpack_require__( /*! ../../events/click */ 95429);
                DevExpress.events.utils = __webpack_require__( /*! ../../events/utils */ 39611);
                DevExpress.events.GestureEmitter = __webpack_require__( /*! ../../events/gesture/emitter.gesture */ 98621);
                DevExpress.localization = __webpack_require__( /*! ../../localization */ 94484);
                DevExpress.templateRendered = __webpack_require__( /*! ../../core/templates/template_base */ 81033).renderedCallbacks;
                DevExpress.setTemplateEngine = __webpack_require__( /*! ../../core/templates/template_engine_registry */ 72987).setTemplateEngine;
                module.exports = DevExpress
            },
        86635:
            /*!*********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/data.js ***!
              \*********************************************************************/
            function(module, __unused_webpack_exports, __webpack_require__) {
                var DevExpress = __webpack_require__( /*! ./core */ 36991);
                var errors = __webpack_require__( /*! ../../core/errors */ 17381);
                module.exports = DevExpress.data = DevExpress.data || {};
                Object.defineProperty(DevExpress.data, "errorHandler", {
                    get: function() {
                        return __webpack_require__( /*! ../../data/errors */ 18438).errorHandler
                    },
                    set: function(value) {
                        errors.log("W0003", "DevExpress.data", "errorHandler", "21.1", "Use the 'setErrorHandler' method instead");
                        __webpack_require__( /*! ../../data/errors */ 18438).setErrorHandler(value)
                    }
                });
                Object.defineProperty(DevExpress.data, "_errorHandler", {
                    get: function() {
                        return __webpack_require__( /*! ../../data/errors */ 18438).handleError
                    },
                    set: function(value) {
                        errors.log("W0003", "DevExpress.data", "_errorHandler", "21.1", "Use the 'setErrorHandler' method instead");
                        __webpack_require__( /*! ../../data/errors */ 18438).setErrorHandler(value)
                    }
                });
                DevExpress.data.setErrorHandler = __webpack_require__( /*! ../../data/errors */ 18438).setErrorHandler;
                DevExpress.data.DataSource = __webpack_require__( /*! ../../data/data_source */ 33546);
                DevExpress.data.query = __webpack_require__( /*! ../../data/query */ 96687);
                DevExpress.data.Store = __webpack_require__( /*! ../../data/abstract_store */ 67403);
                DevExpress.data.ArrayStore = __webpack_require__( /*! ../../data/array_store */ 26562);
                DevExpress.data.CustomStore = __webpack_require__( /*! ../../data/custom_store */ 88036);
                DevExpress.data.LocalStore = __webpack_require__( /*! ../../data/local_store */ 82837);
                DevExpress.data.base64_encode = __webpack_require__( /*! ../../data/utils */ 16454).base64_encode;
                DevExpress.data.applyChanges = __webpack_require__( /*! ../../data/apply_changes */ 36893);
                DevExpress.data.Guid = __webpack_require__( /*! ../../core/guid */ 73176);
                DevExpress.data.utils = {};
                DevExpress.data.utils.compileGetter = __webpack_require__( /*! ../../core/utils/data */ 47617).compileGetter;
                DevExpress.data.utils.compileSetter = __webpack_require__( /*! ../../core/utils/data */ 47617).compileSetter;
                DevExpress.EndpointSelector = __webpack_require__( /*! ../../data/endpoint_selector */ 8162);
                DevExpress.data.queryImpl = __webpack_require__( /*! ../../data/query_implementation */ 77549).queryImpl;
                DevExpress.data.queryAdapters = __webpack_require__( /*! ../../data/query_adapters */ 16135);
                var dataUtils = __webpack_require__( /*! ../../data/utils */ 16454);
                DevExpress.data.utils.normalizeBinaryCriterion = dataUtils.normalizeBinaryCriterion;
                DevExpress.data.utils.normalizeSortingInfo = dataUtils.normalizeSortingInfo;
                DevExpress.data.utils.errorMessageFromXhr = dataUtils.errorMessageFromXhr;
                DevExpress.data.utils.aggregators = dataUtils.aggregators;
                DevExpress.data.utils.keysEqual = dataUtils.keysEqual;
                DevExpress.data.utils.isDisjunctiveOperator = dataUtils.isDisjunctiveOperator;
                DevExpress.data.utils.isConjunctiveOperator = dataUtils.isConjunctiveOperator;
                DevExpress.data.utils.processRequestResultLock = dataUtils.processRequestResultLock;
                DevExpress.data.utils.toComparable = __webpack_require__( /*! ../../core/utils/data */ 47617).toComparable;
                DevExpress.data.utils.multiLevelGroup = __webpack_require__( /*! ../../data/store_helper */ 99236).multiLevelGroup;
                DevExpress.data.utils.arrangeSortingInfo = __webpack_require__( /*! ../../data/store_helper */ 99236).arrangeSortingInfo;
                DevExpress.data.utils.normalizeDataSourceOptions = __webpack_require__( /*! ../../data/data_source/utils */ 9234).normalizeDataSourceOptions
            },
        72343:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/data.odata.js ***!
              \***************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                __webpack_require__( /*! ./data */ 86635);
                DevExpress.data.ODataStore = __webpack_require__( /*! ../../data/odata/store */ 341);
                DevExpress.data.ODataContext = __webpack_require__( /*! ../../data/odata/context */ 47256);
                DevExpress.data.utils = DevExpress.data.utils || {};
                DevExpress.data.utils.odata = {};
                DevExpress.data.utils.odata.keyConverters = __webpack_require__( /*! ../../data/odata/utils */ 77869).keyConverters;
                DevExpress.data.EdmLiteral = __webpack_require__( /*! ../../data/odata/utils */ 77869).EdmLiteral;
                var ODataUtilsModule = __webpack_require__( /*! ../../data/odata/utils */ 77869);
                DevExpress.data.utils.odata.serializePropName = ODataUtilsModule.serializePropName;
                DevExpress.data.utils.odata.serializeValue = ODataUtilsModule.serializeValue;
                DevExpress.data.utils.odata.serializeKey = ODataUtilsModule.serializeKey;
                DevExpress.data.utils.odata.sendRequest = ODataUtilsModule.sendRequest;
                DevExpress.data.queryAdapters = DevExpress.data.queryAdapters || {};
                DevExpress.data.queryAdapters.odata = __webpack_require__( /*! ../../data/odata/query_adapter */ 54263).odata
            },
        56208:
            /*!********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/file_management.js ***!
              \********************************************************************************/
            function(module, __unused_webpack_exports, __webpack_require__) {
                var _core = _interopRequireDefault(__webpack_require__( /*! ./core */ 36991));
                var _error = _interopRequireDefault(__webpack_require__( /*! ../../file_management/error */ 49816));
                var _file_system_item = _interopRequireDefault(__webpack_require__( /*! ../../file_management/file_system_item */ 45765));
                var _object_provider = _interopRequireDefault(__webpack_require__( /*! ../../file_management/object_provider */ 4323));
                var _remote_provider = _interopRequireDefault(__webpack_require__( /*! ../../file_management/remote_provider */ 41332));
                var _custom_provider = _interopRequireDefault(__webpack_require__( /*! ../../file_management/custom_provider */ 98831));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                module.exports = _core.default.fileManagement = _core.default.fileManagement || {};
                _core.default.fileManagement.FileSystemError = _error.default;
                _core.default.fileManagement.FileSystemItem = _file_system_item.default;
                _core.default.fileManagement.ObjectFileSystemProvider = _object_provider.default;
                _core.default.fileManagement.RemoteFileSystemProvider = _remote_provider.default;
                _core.default.fileManagement.CustomFileSystemProvider = _custom_provider.default
            },
        85357:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/parts/core.js ***!
              \***************************************************************************/
            function(module, __unused_webpack_exports, __webpack_require__) {
                var DevExpress = __webpack_require__( /*! ../../../bundles/modules/core */ 36991);
                __webpack_require__( /*! ../../../integration/jquery */ 78475);
                __webpack_require__( /*! ../../../integration/angular */ 71582);
                __webpack_require__( /*! ../../../integration/knockout */ 49281);
                __webpack_require__( /*! ../../../localization/globalize/core */ 74872);
                __webpack_require__( /*! ../../../localization/globalize/message */ 46949);
                __webpack_require__( /*! ../../../localization/globalize/number */ 908);
                __webpack_require__( /*! ../../../localization/globalize/date */ 60316);
                __webpack_require__( /*! ../../../localization/globalize/currency */ 7239);
                __webpack_require__( /*! ../../../events/click */ 95429);
                __webpack_require__( /*! ../../../events/contextmenu */ 49166);
                __webpack_require__( /*! ../../../events/double_click */ 85272);
                __webpack_require__( /*! ../../../events/drag */ 23174);
                __webpack_require__( /*! ../../../events/hold */ 11699);
                __webpack_require__( /*! ../../../events/hover */ 24028);
                __webpack_require__( /*! ../../../events/pointer */ 93786);
                __webpack_require__( /*! ../../../events/swipe */ 34309);
                __webpack_require__( /*! ../../../events/transform */ 91093);
                module.exports = DevExpress
            },
        94620:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/parts/data.js ***!
              \***************************************************************************/
            function(module, __unused_webpack_exports, __webpack_require__) {
                var DevExpress = __webpack_require__( /*! ./core */ 85357);
                var data = DevExpress.data = __webpack_require__( /*! ../../../bundles/modules/data */ 86635);
                data.odata = __webpack_require__( /*! ../../../bundles/modules/data.odata */ 72343);
                module.exports = data
            },
        70527:
            /*!**************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/parts/file_management.js ***!
              \**************************************************************************************/
            function(module, __unused_webpack_exports, __webpack_require__) {
                var _core = (obj = __webpack_require__( /*! ./core */ 85357), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var fileManagement = __webpack_require__( /*! ../../../bundles/modules/file_management */ 56208);
                _core.default.fileManagement = fileManagement;
                module.exports = fileManagement
            },
        66312:
            /*!**************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/parts/viz.js ***!
              \**************************************************************************/
            function(module, __unused_webpack_exports, __webpack_require__) {
                var DevExpress = __webpack_require__( /*! ./core */ 85357);
                __webpack_require__( /*! ./data */ 94620);
                var viz = DevExpress.viz = __webpack_require__( /*! ../../../bundles/modules/viz */ 20802);
                viz.currentTheme = __webpack_require__( /*! ../../../viz/themes */ 86231).currentTheme;
                viz.registerTheme = __webpack_require__( /*! ../../../viz/themes */ 86231).registerTheme;
                viz.exportFromMarkup = __webpack_require__( /*! ../../../viz/export */ 5259).exportFromMarkup;
                viz.getMarkup = __webpack_require__( /*! ../../../viz/export */ 5259).getMarkup;
                viz.exportWidgets = __webpack_require__( /*! ../../../viz/export */ 5259).exportWidgets;
                viz.currentPalette = __webpack_require__( /*! ../../../viz/palette */ 23696).currentPalette;
                viz.getPalette = __webpack_require__( /*! ../../../viz/palette */ 23696).getPalette;
                viz.generateColors = __webpack_require__( /*! ../../../viz/palette */ 23696).generateColors;
                viz.registerPalette = __webpack_require__( /*! ../../../viz/palette */ 23696).registerPalette;
                viz.refreshTheme = __webpack_require__( /*! ../../../viz/themes */ 86231).refreshTheme;
                viz.dxChart = __webpack_require__( /*! ../../../viz/chart */ 99511);
                viz.dxPieChart = __webpack_require__( /*! ../../../viz/pie_chart */ 72111);
                viz.dxPolarChart = __webpack_require__( /*! ../../../viz/polar_chart */ 80919);
                viz.dxLinearGauge = __webpack_require__( /*! ../../../viz/linear_gauge */ 99630);
                viz.dxCircularGauge = __webpack_require__( /*! ../../../viz/circular_gauge */ 39847);
                viz.dxBarGauge = __webpack_require__( /*! ../../../viz/bar_gauge */ 45888);
                viz.dxRangeSelector = __webpack_require__( /*! ../../../viz/range_selector */ 82879);
                viz.dxVectorMap = __webpack_require__( /*! ../../../viz/vector_map */ 81849);
                viz.map = {};
                viz.map.sources = {};
                viz.map.projection = __webpack_require__( /*! ../../../viz/vector_map/projection */ 102).projection;
                viz.dxSparkline = __webpack_require__( /*! ../../../viz/sparkline */ 43759);
                viz.dxBullet = __webpack_require__( /*! ../../../viz/bullet */ 88950);
                viz.dxTreeMap = __webpack_require__( /*! ../../../viz/tree_map */ 15584);
                viz.dxFunnel = __webpack_require__( /*! ../../../viz/funnel */ 30187);
                viz.dxSankey = __webpack_require__( /*! ../../../viz/sankey */ 34377);
                viz.BaseWidget = __webpack_require__( /*! ../../../viz/core/base_widget */ 59063);
                viz.getTheme = __webpack_require__( /*! ../../../viz/themes */ 86231).getTheme;
                viz.findTheme = __webpack_require__( /*! ../../../viz/themes */ 86231).getTheme;
                viz.refreshAll = __webpack_require__( /*! ../../../viz/themes */ 86231).refreshTheme;
                viz.refreshPaths = __webpack_require__( /*! ../../../viz/utils */ 34434).refreshPaths;
                viz.gauges = {
                    __internals: {}
                };
                viz._dashboard = {};
                viz._dashboard.Renderer = __webpack_require__( /*! ../../../viz/core/renderers/renderer */ 56453).Renderer;
                viz._dashboard.SvgElement = __webpack_require__( /*! ../../../viz/core/renderers/renderer */ 56453).SvgElement;
                viz._dashboard.patchFontOptions = __webpack_require__( /*! ../../../viz/core/utils */ 19157).patchFontOptions;
                module.exports = viz
            },
        85866:
            /*!**********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/parts/widgets-all.js ***!
              \**********************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                __webpack_require__( /*! ./widgets-mobile */ 64178);
                __webpack_require__( /*! ./widgets-web */ 2025)
            },
        50779:
            /*!***********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/parts/widgets-base.js ***!
              \***********************************************************************************/
            function(module, __unused_webpack_exports, __webpack_require__) {
                var DevExpress = __webpack_require__( /*! ./core */ 85357);
                __webpack_require__( /*! ./data */ 94620);
                __webpack_require__( /*! ./file_management */ 70527);
                var ui = DevExpress.ui = __webpack_require__( /*! ../../../bundles/modules/ui */ 26864);
                ui.themes = __webpack_require__( /*! ../../../ui/themes */ 75811);
                ui.setTemplateEngine = __webpack_require__( /*! ../../../core/templates/template_engine_registry */ 72987).setTemplateEngine;
                ui.dialog = __webpack_require__( /*! ../../../ui/dialog */ 15029);
                ui.notify = __webpack_require__( /*! ../../../ui/notify */ 59958);
                ui.repaintFloatingActionButton = __webpack_require__( /*! ../../../ui/speed_dial_action/repaint_floating_action_button */ 81374);
                ui.hideToasts = __webpack_require__( /*! ../../../ui/toast/hide_toasts */ 33964);
                ui.dxActionSheet = __webpack_require__( /*! ../../../ui/action_sheet */ 81476);
                ui.dxAutocomplete = __webpack_require__( /*! ../../../ui/autocomplete */ 65418);
                ui.dxBox = __webpack_require__( /*! ../../../ui/box */ 55551);
                ui.dxButton = __webpack_require__( /*! ../../../ui/button */ 63008);
                ui.dxDropDownButton = __webpack_require__( /*! ../../../ui/drop_down_button */ 45231);
                ui.dxButtonGroup = __webpack_require__( /*! ../../../ui/button_group */ 28236);
                ui.dxCalendar = __webpack_require__( /*! ../../../ui/calendar */ 26559);
                ui.dxCheckBox = __webpack_require__( /*! ../../../ui/check_box */ 18859);
                ui.dxColorBox = __webpack_require__( /*! ../../../ui/color_box */ 4278);
                ui.dxDateBox = __webpack_require__( /*! ../../../ui/date_box */ 29589);
                ui.dxDrawer = __webpack_require__( /*! ../../../ui/drawer */ 45065);
                ui.dxDeferRendering = __webpack_require__( /*! ../../../ui/defer_rendering */ 28414);
                ui.dxDropDownBox = __webpack_require__( /*! ../../../ui/drop_down_box */ 36646);
                ui.dxDropDownMenu = __webpack_require__( /*! ../../../ui/drop_down_menu */ 79561);
                ui.dxFileUploader = __webpack_require__( /*! ../../../ui/file_uploader */ 53749);
                ui.dxForm = __webpack_require__( /*! ../../../ui/form */ 17737);
                ui.dxGallery = __webpack_require__( /*! ../../../ui/gallery */ 49433);
                ui.dxHtmlEditor = __webpack_require__( /*! ../../../ui/html_editor */ 9619);
                ui.dxList = __webpack_require__( /*! ../../../ui/list */ 86e3);
                ui.dxLoadIndicator = __webpack_require__( /*! ../../../ui/load_indicator */ 2492);
                ui.dxLoadPanel = __webpack_require__( /*! ../../../ui/load_panel */ 97218);
                ui.dxLookup = __webpack_require__( /*! ../../../ui/lookup */ 55935);
                ui.dxMap = __webpack_require__( /*! ../../../ui/map */ 64304);
                ui.dxMultiView = __webpack_require__( /*! ../../../ui/multi_view */ 86478);
                ui.dxNavBar = __webpack_require__( /*! ../../../ui/nav_bar */ 65089);
                ui.dxNumberBox = __webpack_require__( /*! ../../../ui/number_box */ 34171);
                ui.dxOverlay = __webpack_require__( /*! ../../../ui/overlay/ui.overlay */ 89799);
                ui.dxPopover = __webpack_require__( /*! ../../../ui/popover */ 22348);
                ui.dxPopup = __webpack_require__( /*! ../../../ui/popup */ 39114);
                ui.dxProgressBar = __webpack_require__( /*! ../../../ui/progress_bar */ 28080);
                ui.dxRadioGroup = __webpack_require__( /*! ../../../ui/radio_group */ 14305);
                ui.dxRangeSlider = __webpack_require__( /*! ../../../ui/range_slider */ 36992);
                ui.dxResizable = __webpack_require__( /*! ../../../ui/resizable */ 46743);
                ui.dxResponsiveBox = __webpack_require__( /*! ../../../ui/responsive_box */ 21643);
                ui.dxScrollView = __webpack_require__( /*! ../../../ui/scroll_view */ 4741);
                ui.dxSelectBox = __webpack_require__( /*! ../../../ui/select_box */ 78665);
                ui.dxSlider = __webpack_require__( /*! ../../../ui/slider */ 97834);
                ui.dxSpeedDialAction = __webpack_require__( /*! ../../../ui/speed_dial_action */ 17017);
                ui.dxSwitch = __webpack_require__( /*! ../../../ui/switch */ 31609);
                ui.dxTabPanel = __webpack_require__( /*! ../../../ui/tab_panel */ 21807);
                ui.dxTabs = __webpack_require__( /*! ../../../ui/tabs */ 13453);
                ui.dxTagBox = __webpack_require__( /*! ../../../ui/tag_box */ 31362);
                ui.dxTextArea = __webpack_require__( /*! ../../../ui/text_area */ 51237);
                ui.dxTextBox = __webpack_require__( /*! ../../../ui/text_box */ 29837);
                ui.dxTileView = __webpack_require__( /*! ../../../ui/tile_view */ 93094);
                ui.dxToast = __webpack_require__( /*! ../../../ui/toast */ 37748);
                ui.dxToolbar = __webpack_require__( /*! ../../../ui/toolbar */ 71042);
                ui.dxTooltip = __webpack_require__( /*! ../../../ui/tooltip */ 94920);
                ui.dxTrackBar = __webpack_require__( /*! ../../../ui/track_bar */ 39661);
                ui.dxDraggable = __webpack_require__( /*! ../../../ui/draggable */ 42160);
                ui.dxSortable = __webpack_require__( /*! ../../../ui/sortable */ 66843);
                DevExpress.validationEngine = __webpack_require__( /*! ../../../ui/validation_engine */ 90964);
                ui.dxValidationSummary = __webpack_require__( /*! ../../../ui/validation_summary */ 97289);
                ui.dxValidationGroup = __webpack_require__( /*! ../../../ui/validation_group */ 4401);
                ui.dxValidator = __webpack_require__( /*! ../../../ui/validator */ 39562);
                __webpack_require__( /*! ../../../ui/html_editor/converters/markdown */ 52935);
                ui.CollectionWidget = __webpack_require__( /*! ../../../ui/collection/ui.collection_widget.edit */ 11050);
                ui.dxDropDownEditor = __webpack_require__( /*! ../../../ui/drop_down_editor/ui.drop_down_editor */ 44687);
                module.exports = ui
            },
        64178:
            /*!*************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/parts/widgets-mobile.js ***!
              \*************************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var ui = __webpack_require__( /*! ./widgets-base */ 50779);
                ui.dxSlideOut = __webpack_require__( /*! ../../../ui/slide_out */ 85643);
                ui.dxSlideOutView = __webpack_require__( /*! ../../../ui/slide_out_view */ 92719)
            },
        2025:
            /*!**********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/parts/widgets-web.js ***!
              \**********************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var data = __webpack_require__( /*! ./data */ 94620);
                var ui = __webpack_require__( /*! ./widgets-base */ 50779);
                ui.dxAccordion = __webpack_require__( /*! ../../../ui/accordion */ 76219);
                ui.dxContextMenu = __webpack_require__( /*! ../../../ui/context_menu */ 10042);
                ui.dxDataGrid = __webpack_require__( /*! ../../../ui/data_grid */ 1186);
                ui.dxDataGridNext = __webpack_require__( /*! ../../../ui/data_grid_next */ 84063);
                ui.dxTreeList = __webpack_require__( /*! ../../../ui/tree_list */ 82655);
                ui.dxMenu = __webpack_require__( /*! ../../../ui/menu */ 76995);
                ui.dxPivotGrid = __webpack_require__( /*! ../../../ui/pivot_grid */ 96089);
                ui.dxPivotGridFieldChooser = __webpack_require__( /*! ../../../ui/pivot_grid_field_chooser */ 32014);
                data.PivotGridDataSource = __webpack_require__( /*! ../../../ui/pivot_grid/data_source */ 98713);
                data.XmlaStore = __webpack_require__( /*! ../../../ui/pivot_grid/xmla_store */ 9170);
                ui.dxScheduler = __webpack_require__( /*! ../../../ui/scheduler */ 9508);
                ui.dxTreeView = __webpack_require__( /*! ../../../ui/tree_view */ 30254);
                ui.dxFilterBuilder = __webpack_require__( /*! ../../../ui/filter_builder */ 20301);
                ui.dxFileManager = __webpack_require__( /*! ../../../ui/file_manager */ 87446);
                ui.dxDiagram = __webpack_require__( /*! ../../../ui/diagram */ 52311);
                ui.dxGantt = __webpack_require__( /*! ../../../ui/gantt */ 33465)
            },
        26864:
            /*!*******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/ui.js ***!
              \*******************************************************************/
            function(module, __unused_webpack_exports, __webpack_require__) {
                __webpack_require__( /*! ./core */ 36991);
                module.exports = DevExpress.ui = {}
            },
        20802:
            /*!********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/viz.js ***!
              \********************************************************************/
            function(module, __unused_webpack_exports, __webpack_require__) {
                __webpack_require__( /*! ./core */ 36991);
                module.exports = DevExpress.viz = DevExpress.viz || {}
            },
        52752:
            /*!******************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/color.js ***!
              \******************************************************/
            function(module, exports) {
                exports.default = void 0;
                var standardColorNames = {
                    aliceblue: "f0f8ff",
                    antiquewhite: "faebd7",
                    aqua: "00ffff",
                    aquamarine: "7fffd4",
                    azure: "f0ffff",
                    beige: "f5f5dc",
                    bisque: "ffe4c4",
                    black: "000000",
                    blanchedalmond: "ffebcd",
                    blue: "0000ff",
                    blueviolet: "8a2be2",
                    brown: "a52a2a",
                    burlywood: "deb887",
                    cadetblue: "5f9ea0",
                    chartreuse: "7fff00",
                    chocolate: "d2691e",
                    coral: "ff7f50",
                    cornflowerblue: "6495ed",
                    cornsilk: "fff8dc",
                    crimson: "dc143c",
                    cyan: "00ffff",
                    darkblue: "00008b",
                    darkcyan: "008b8b",
                    darkgoldenrod: "b8860b",
                    darkgray: "a9a9a9",
                    darkgreen: "006400",
                    darkgrey: "a9a9a9",
                    darkkhaki: "bdb76b",
                    darkmagenta: "8b008b",
                    darkolivegreen: "556b2f",
                    darkorange: "ff8c00",
                    darkorchid: "9932cc",
                    darkred: "8b0000",
                    darksalmon: "e9967a",
                    darkseagreen: "8fbc8f",
                    darkslateblue: "483d8b",
                    darkslategray: "2f4f4f",
                    darkslategrey: "2f4f4f",
                    darkturquoise: "00ced1",
                    darkviolet: "9400d3",
                    deeppink: "ff1493",
                    deepskyblue: "00bfff",
                    dimgray: "696969",
                    dimgrey: "696969",
                    dodgerblue: "1e90ff",
                    feldspar: "d19275",
                    firebrick: "b22222",
                    floralwhite: "fffaf0",
                    forestgreen: "228b22",
                    fuchsia: "ff00ff",
                    gainsboro: "dcdcdc",
                    ghostwhite: "f8f8ff",
                    gold: "ffd700",
                    goldenrod: "daa520",
                    gray: "808080",
                    green: "008000",
                    greenyellow: "adff2f",
                    grey: "808080",
                    honeydew: "f0fff0",
                    hotpink: "ff69b4",
                    indianred: "cd5c5c",
                    indigo: "4b0082",
                    ivory: "fffff0",
                    khaki: "f0e68c",
                    lavender: "e6e6fa",
                    lavenderblush: "fff0f5",
                    lawngreen: "7cfc00",
                    lemonchiffon: "fffacd",
                    lightblue: "add8e6",
                    lightcoral: "f08080",
                    lightcyan: "e0ffff",
                    lightgoldenrodyellow: "fafad2",
                    lightgray: "d3d3d3",
                    lightgreen: "90ee90",
                    lightgrey: "d3d3d3",
                    lightpink: "ffb6c1",
                    lightsalmon: "ffa07a",
                    lightseagreen: "20b2aa",
                    lightskyblue: "87cefa",
                    lightslateblue: "8470ff",
                    lightslategray: "778899",
                    lightslategrey: "778899",
                    lightsteelblue: "b0c4de",
                    lightyellow: "ffffe0",
                    lime: "00ff00",
                    limegreen: "32cd32",
                    linen: "faf0e6",
                    magenta: "ff00ff",
                    maroon: "800000",
                    mediumaquamarine: "66cdaa",
                    mediumblue: "0000cd",
                    mediumorchid: "ba55d3",
                    mediumpurple: "9370d8",
                    mediumseagreen: "3cb371",
                    mediumslateblue: "7b68ee",
                    mediumspringgreen: "00fa9a",
                    mediumturquoise: "48d1cc",
                    mediumvioletred: "c71585",
                    midnightblue: "191970",
                    mintcream: "f5fffa",
                    mistyrose: "ffe4e1",
                    moccasin: "ffe4b5",
                    navajowhite: "ffdead",
                    navy: "000080",
                    oldlace: "fdf5e6",
                    olive: "808000",
                    olivedrab: "6b8e23",
                    orange: "ffa500",
                    orangered: "ff4500",
                    orchid: "da70d6",
                    palegoldenrod: "eee8aa",
                    palegreen: "98fb98",
                    paleturquoise: "afeeee",
                    palevioletred: "d87093",
                    papayawhip: "ffefd5",
                    peachpuff: "ffdab9",
                    peru: "cd853f",
                    pink: "ffc0cb",
                    plum: "dda0dd",
                    powderblue: "b0e0e6",
                    purple: "800080",
                    rebeccapurple: "663399",
                    red: "ff0000",
                    rosybrown: "bc8f8f",
                    royalblue: "4169e1",
                    saddlebrown: "8b4513",
                    salmon: "fa8072",
                    sandybrown: "f4a460",
                    seagreen: "2e8b57",
                    seashell: "fff5ee",
                    sienna: "a0522d",
                    silver: "c0c0c0",
                    skyblue: "87ceeb",
                    slateblue: "6a5acd",
                    slategray: "708090",
                    slategrey: "708090",
                    snow: "fffafa",
                    springgreen: "00ff7f",
                    steelblue: "4682b4",
                    tan: "d2b48c",
                    teal: "008080",
                    thistle: "d8bfd8",
                    tomato: "ff6347",
                    turquoise: "40e0d0",
                    violet: "ee82ee",
                    violetred: "d02090",
                    wheat: "f5deb3",
                    white: "ffffff",
                    whitesmoke: "f5f5f5",
                    yellow: "ffff00",
                    yellowgreen: "9acd32"
                };
                var standardColorTypes = [{
                    re: /^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
                    process: function(colorString) {
                        return [parseInt(colorString[1], 10), parseInt(colorString[2], 10), parseInt(colorString[3], 10)]
                    }
                }, {
                    re: /^rgba\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3}),\s*(\d*\.*\d+)\)$/,
                    process: function(colorString) {
                        return [parseInt(colorString[1], 10), parseInt(colorString[2], 10), parseInt(colorString[3], 10), parseFloat(colorString[4])]
                    }
                }, {
                    re: /^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/,
                    process: function(colorString) {
                        return [parseInt(colorString[1], 16), parseInt(colorString[2], 16), parseInt(colorString[3], 16)]
                    }
                }, {
                    re: /^#([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})$/,
                    process: function(colorString) {
                        return [parseInt(colorString[1] + colorString[1], 16), parseInt(colorString[2] + colorString[2], 16), parseInt(colorString[3] + colorString[3], 16)]
                    }
                }, {
                    re: /^hsv\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
                    process: function(colorString) {
                        var h = parseInt(colorString[1], 10);
                        var s = parseInt(colorString[2], 10);
                        var v = parseInt(colorString[3], 10);
                        var rgb = hsvToRgb(h, s, v);
                        return [rgb[0], rgb[1], rgb[2], 1, [h, s, v]]
                    }
                }, {
                    re: /^hsl\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,
                    process: function(colorString) {
                        var h = parseInt(colorString[1], 10);
                        var s = parseInt(colorString[2], 10);
                        var l = parseInt(colorString[3], 10);
                        var rgb = hslToRgb(h, s, l);
                        return [rgb[0], rgb[1], rgb[2], 1, null, [h, s, l]]
                    }
                }];
                var _round = Math.round;

                function Color(value) {
                    this.baseColor = value;
                    var color;
                    if (value) {
                        color = String(value).toLowerCase().replace(/ /g, "");
                        color = standardColorNames[color] ? "#" + standardColorNames[color] : color;
                        color = function(color) {
                            if ("transparent" === color) {
                                return [0, 0, 0, 0]
                            }
                            var i = 0;
                            var ii = standardColorTypes.length;
                            var str;
                            for (; i < ii; ++i) {
                                str = standardColorTypes[i].re.exec(color);
                                if (str) {
                                    return standardColorTypes[i].process(str)
                                }
                            }
                            return null
                        }(color)
                    }
                    if (!color) {
                        this.colorIsInvalid = true
                    }
                    color = color || {};
                    this.r = normalize(color[0]);
                    this.g = normalize(color[1]);
                    this.b = normalize(color[2]);
                    this.a = normalize(color[3], 1, 1);
                    if (color[4]) {
                        this.hsv = {
                            h: color[4][0],
                            s: color[4][1],
                            v: color[4][2]
                        }
                    } else {
                        this.hsv = function(r, g, b) {
                            var max = Math.max(r, g, b);
                            var min = Math.min(r, g, b);
                            var delta = max - min;
                            var H;
                            var S;
                            var V = max;
                            S = 0 === max ? 0 : 1 - min / max;
                            if (max === min) {
                                H = 0
                            } else {
                                switch (max) {
                                    case r:
                                        H = (g - b) / delta * 60;
                                        if (g < b) {
                                            H += 360
                                        }
                                        break;
                                    case g:
                                        H = (b - r) / delta * 60 + 120;
                                        break;
                                    case b:
                                        H = (r - g) / delta * 60 + 240
                                }
                            }
                            S *= 100;
                            V *= 100 / 255;
                            return {
                                h: Math.round(H),
                                s: Math.round(S),
                                v: Math.round(V)
                            }
                        }(this.r, this.g, this.b)
                    }
                    if (color[5]) {
                        this.hsl = {
                            h: color[5][0],
                            s: color[5][1],
                            l: color[5][2]
                        }
                    } else {
                        this.hsl = function(r, g, b) {
                            r = convertTo01Bounds(r, 255);
                            g = convertTo01Bounds(g, 255);
                            b = convertTo01Bounds(b, 255);
                            var max = Math.max(r, g, b);
                            var min = Math.min(r, g, b);
                            var maxMinSum = max + min;
                            var h;
                            var s;
                            var l = maxMinSum / 2;
                            if (max === min) {
                                h = s = 0
                            } else {
                                var delta = max - min;
                                if (l > .5) {
                                    s = delta / (2 - maxMinSum)
                                } else {
                                    s = delta / maxMinSum
                                }
                                h = function(r, g, b, delta) {
                                    var max = Math.max(r, g, b);
                                    switch (max) {
                                        case r:
                                            return (g - b) / delta + (g < b ? 6 : 0);
                                        case g:
                                            return (b - r) / delta + 2;
                                        case b:
                                            return (r - g) / delta + 4
                                    }
                                }(r, g, b, delta);
                                h /= 6
                            }
                            return {
                                h: _round(360 * h),
                                s: _round(100 * s),
                                l: _round(100 * l)
                            }
                        }(this.r, this.g, this.b)
                    }
                }

                function normalize(colorComponent, def, max) {
                    def = def || 0;
                    max = max || 255;
                    return colorComponent < 0 || isNaN(colorComponent) ? def : colorComponent > max ? max : colorComponent
                }

                function hsvToRgb(h, s, v) {
                    var index = Math.floor(h % 360 / 60);
                    var vMin = (100 - s) * v / 100;
                    var a = h % 60 / 60 * (v - vMin);
                    var vInc = vMin + a;
                    var vDec = v - a;
                    var r;
                    var g;
                    var b;
                    switch (index) {
                        case 0:
                            r = v;
                            g = vInc;
                            b = vMin;
                            break;
                        case 1:
                            r = vDec;
                            g = v;
                            b = vMin;
                            break;
                        case 2:
                            r = vMin;
                            g = v;
                            b = vInc;
                            break;
                        case 3:
                            r = vMin;
                            g = vDec;
                            b = v;
                            break;
                        case 4:
                            r = vInc;
                            g = vMin;
                            b = v;
                            break;
                        case 5:
                            r = v;
                            g = vMin;
                            b = vDec
                    }
                    return [Math.round(2.55 * r), Math.round(2.55 * g), Math.round(2.55 * b)]
                }

                function makeColorTint(colorPart, h) {
                    var colorTint = h;
                    if ("r" === colorPart) {
                        colorTint = h + 1 / 3
                    }
                    if ("b" === colorPart) {
                        colorTint = h - 1 / 3
                    }
                    return colorTint
                }

                function hueToRgb(p, q, colorTint) {
                    colorTint = function(colorTint) {
                        if (colorTint < 0) {
                            colorTint += 1
                        }
                        if (colorTint > 1) {
                            colorTint -= 1
                        }
                        return colorTint
                    }(colorTint);
                    if (colorTint < 1 / 6) {
                        return p + 6 * (q - p) * colorTint
                    }
                    if (colorTint < .5) {
                        return q
                    }
                    if (colorTint < 2 / 3) {
                        return p + (q - p) * (2 / 3 - colorTint) * 6
                    }
                    return p
                }

                function hslToRgb(h, s, l) {
                    var r;
                    var g;
                    var b;
                    h = convertTo01Bounds(h, 360);
                    s = convertTo01Bounds(s, 100);
                    l = convertTo01Bounds(l, 100);
                    if (0 === s) {
                        r = g = b = l
                    } else {
                        var q = l < .5 ? l * (1 + s) : l + s - l * s;
                        var p = 2 * l - q;
                        r = hueToRgb(p, q, makeColorTint("r", h));
                        g = hueToRgb(p, q, makeColorTint("g", h));
                        b = hueToRgb(p, q, makeColorTint("b", h))
                    }
                    return [_round(255 * r), _round(255 * g), _round(255 * b)]
                }

                function convertTo01Bounds(n, max) {
                    n = Math.min(max, Math.max(0, parseFloat(n)));
                    if (Math.abs(n - max) < 1e-6) {
                        return 1
                    }
                    return n % max / parseFloat(max)
                }

                function isIntegerBetweenMinAndMax(number, min, max) {
                    min = min || 0;
                    max = max || 255;
                    if (number % 1 !== 0 || number < min || number > max || "number" !== typeof number || isNaN(number)) {
                        return false
                    }
                    return true
                }
                Color.prototype = {
                    constructor: Color,
                    highlight: function(step) {
                        step = step || 10;
                        return this.alter(step).toHex()
                    },
                    darken: function(step) {
                        step = step || 10;
                        return this.alter(-step).toHex()
                    },
                    alter: function(step) {
                        var result = new Color;
                        result.r = normalize(this.r + step);
                        result.g = normalize(this.g + step);
                        result.b = normalize(this.b + step);
                        return result
                    },
                    blend: function(blendColor, opacity) {
                        var other = blendColor instanceof Color ? blendColor : new Color(blendColor);
                        var result = new Color;
                        result.r = normalize(_round(this.r * (1 - opacity) + other.r * opacity));
                        result.g = normalize(_round(this.g * (1 - opacity) + other.g * opacity));
                        result.b = normalize(_round(this.b * (1 - opacity) + other.b * opacity));
                        return result
                    },
                    toHex: function() {
                        return r = this.r, g = this.g, b = this.b, "#" + (16777216 | r << 16 | g << 8 | b).toString(16).slice(1);
                        var r, g, b
                    },
                    getPureColor: function() {
                        var rgb = hsvToRgb(this.hsv.h, 100, 100);
                        return new Color("rgb(" + rgb.join(",") + ")")
                    },
                    isValidHex: function(hex) {
                        return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex)
                    },
                    isValidRGB: function(r, g, b) {
                        if (!isIntegerBetweenMinAndMax(r) || !isIntegerBetweenMinAndMax(g) || !isIntegerBetweenMinAndMax(b)) {
                            return false
                        }
                        return true
                    },
                    isValidAlpha: function(a) {
                        if (isNaN(a) || a < 0 || a > 1 || "number" !== typeof a) {
                            return false
                        }
                        return true
                    },
                    colorIsInvalid: false,
                    fromHSL: function(hsl) {
                        var color = new Color;
                        var rgb = hslToRgb(hsl.h, hsl.s, hsl.l);
                        color.r = rgb[0];
                        color.g = rgb[1];
                        color.b = rgb[2];
                        return color
                    }
                };
                var _default = Color;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        62414:
            /*!************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/action.js ***!
              \************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _renderer = (obj = __webpack_require__( /*! ./renderer */ 68374), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _window = __webpack_require__( /*! ./utils/window */ 58201);
                var _type = __webpack_require__( /*! ./utils/type */ 35922);
                var _iterator = __webpack_require__( /*! ./utils/iterator */ 95479);
                var Action = function() {
                    function Action(action, config) {
                        config = config || {};
                        this._action = action;
                        this._context = config.context || (0, _window.getWindow)();
                        this._beforeExecute = config.beforeExecute;
                        this._afterExecute = config.afterExecute;
                        this._component = config.component;
                        this._validatingTargetName = config.validatingTargetName;
                        var excludeValidators = this._excludeValidators = {};
                        if (config.excludeValidators) {
                            for (var i = 0; i < config.excludeValidators.length; i++) {
                                excludeValidators[config.excludeValidators[i]] = true
                            }
                        }
                    }
                    var _proto = Action.prototype;
                    _proto.execute = function() {
                        var e = {
                            action: this._action,
                            args: Array.prototype.slice.call(arguments),
                            context: this._context,
                            component: this._component,
                            validatingTargetName: this._validatingTargetName,
                            cancel: false,
                            handled: false
                        };
                        var beforeExecute = this._beforeExecute;
                        var afterExecute = this._afterExecute;
                        var argsBag = e.args[0] || {};
                        if (!this._validateAction(e)) {
                            return
                        }
                        null === beforeExecute || void 0 === beforeExecute ? void 0 : beforeExecute.call(this._context, e);
                        if (e.cancel) {
                            return
                        }
                        var result = this._executeAction(e);
                        if (argsBag.cancel) {
                            return
                        }
                        null === afterExecute || void 0 === afterExecute ? void 0 : afterExecute.call(this._context, e);
                        return result
                    };
                    _proto._validateAction = function(e) {
                        var excludeValidators = this._excludeValidators;
                        var executors = Action.executors;
                        for (var name in executors) {
                            if (!excludeValidators[name]) {
                                var _executor$validate;
                                var executor = executors[name];
                                null === (_executor$validate = executor.validate) || void 0 === _executor$validate ? void 0 : _executor$validate.call(executor, e);
                                if (e.cancel) {
                                    return false
                                }
                            }
                        }
                        return true
                    };
                    _proto._executeAction = function(e) {
                        var result;
                        var executors = Action.executors;
                        for (var name in executors) {
                            var _executor$execute;
                            var executor = executors[name];
                            null === (_executor$execute = executor.execute) || void 0 === _executor$execute ? void 0 : _executor$execute.call(executor, e);
                            if (e.handled) {
                                result = e.result;
                                break
                            }
                        }
                        return result
                    };
                    Action.registerExecutor = function(name, executor) {
                        if ((0, _type.isPlainObject)(name)) {
                            (0, _iterator.each)(name, Action.registerExecutor);
                            return
                        }
                        Action.executors[name] = executor
                    };
                    Action.unregisterExecutor = function() {
                        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                            args[_key] = arguments[_key]
                        }(0, _iterator.each)(args, (function() {
                            delete Action.executors[this]
                        }))
                    };
                    return Action
                }();
                exports.default = Action;
                Action.executors = {};
                var createValidatorByTargetElement = function(condition) {
                    return function(e) {
                        if (!e.args.length) {
                            return
                        }
                        var args = e.args[0];
                        var element = args[e.validatingTargetName] || args.element;
                        if (element && condition((0, _renderer.default)(element))) {
                            e.cancel = true
                        }
                    }
                };
                Action.registerExecutor({
                    disabled: {
                        validate: createValidatorByTargetElement((function($target) {
                            return $target.is(".dx-state-disabled, .dx-state-disabled *")
                        }))
                    },
                    readOnly: {
                        validate: createValidatorByTargetElement((function($target) {
                            return $target.is(".dx-state-readonly, .dx-state-readonly *:not(.dx-state-independent)")
                        }))
                    },
                    undefined: {
                        execute: function(e) {
                            if (!e.action) {
                                e.result = void 0;
                                e.handled = true
                            }
                        }
                    },
                    func: {
                        execute: function(e) {
                            if ((0, _type.isFunction)(e.action)) {
                                e.result = e.action.call(e.context, e.args[0]);
                                e.handled = true
                            }
                        }
                    }
                });
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        38377:
            /*!***********************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/class.js ***!
              \***********************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _errors = (obj = __webpack_require__( /*! ./errors */ 17381), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _type = __webpack_require__( /*! ./utils/type */ 35922);
                var wrapOverridden = function(baseProto, methodName, method) {
                    return function() {
                        var prevCallBase = this.callBase;
                        this.callBase = baseProto[methodName];
                        try {
                            return method.apply(this, arguments)
                        } finally {
                            this.callBase = prevCallBase
                        }
                    }
                };
                var redefine = function(members) {
                    var overridden;
                    var memberName;
                    var member;
                    if (!members) {
                        return this
                    }
                    for (memberName in members) {
                        member = members[memberName];
                        overridden = "function" === typeof this.prototype[memberName] && "function" === typeof member;
                        this.prototype[memberName] = overridden ? wrapOverridden(this.parent.prototype, memberName, member) : member
                    }
                    return this
                };
                var include = function() {
                    var classObj = this;
                    var argument;
                    var name;
                    var i;
                    var hasClassObjOwnProperty = Object.prototype.hasOwnProperty.bind(classObj);
                    var isES6Class = !hasClassObjOwnProperty("_includedCtors") && !hasClassObjOwnProperty("_includedPostCtors");
                    if (isES6Class) {
                        classObj._includedCtors = classObj._includedCtors.slice(0);
                        classObj._includedPostCtors = classObj._includedPostCtors.slice(0)
                    }
                    for (i = 0; i < arguments.length; i++) {
                        argument = arguments[i];
                        if (argument.ctor) {
                            classObj._includedCtors.push(argument.ctor)
                        }
                        if (argument.postCtor) {
                            classObj._includedPostCtors.push(argument.postCtor)
                        }
                        for (name in argument) {
                            if ("ctor" === name || "postCtor" === name || "default" === name) {
                                continue
                            }
                            classObj.prototype[name] = argument[name]
                        }
                    }
                    return classObj
                };
                var subclassOf = function(parentClass) {
                    var hasParentProperty = Object.prototype.hasOwnProperty.bind(this)("parent");
                    var isES6Class = !hasParentProperty && this.parent;
                    if (isES6Class) {
                        var baseClass = Object.getPrototypeOf(this);
                        return baseClass === parentClass || baseClass.subclassOf(parentClass)
                    } else {
                        if (this.parent === parentClass) {
                            return true
                        }
                        if (!this.parent || !this.parent.subclassOf) {
                            return false
                        }
                        return this.parent.subclassOf(parentClass)
                    }
                };
                var abstract = function() {
                    throw _errors.default.Error("E0001")
                };
                var copyStatic = (hasOwn = Object.prototype.hasOwnProperty, function(source, destination) {
                    for (var key in source) {
                        if (!hasOwn.call(source, key)) {
                            return
                        }
                        destination[key] = source[key]
                    }
                });
                var hasOwn;
                var classImpl = function() {};
                classImpl.inherit = function(members) {
                    var inheritor = function() {
                        if (!this || (0, _type.isWindow)(this) || "function" !== typeof this.constructor) {
                            throw _errors.default.Error("E0003")
                        }
                        var instance = this;
                        var ctor = instance.ctor;
                        var includedCtors = instance.constructor._includedCtors;
                        var includedPostCtors = instance.constructor._includedPostCtors;
                        var i;
                        for (i = 0; i < includedCtors.length; i++) {
                            includedCtors[i].call(instance)
                        }
                        if (ctor) {
                            ctor.apply(instance, arguments)
                        }
                        for (i = 0; i < includedPostCtors.length; i++) {
                            includedPostCtors[i].call(instance)
                        }
                    };
                    inheritor.prototype = function(obj) {
                        var func = function() {};
                        func.prototype = obj.prototype;
                        return new func
                    }(this);
                    copyStatic(this, inheritor);
                    inheritor.inherit = this.inherit;
                    inheritor.abstract = abstract;
                    inheritor.redefine = redefine;
                    inheritor.include = include;
                    inheritor.subclassOf = subclassOf;
                    inheritor.parent = this;
                    inheritor._includedCtors = this._includedCtors ? this._includedCtors.slice(0) : [];
                    inheritor._includedPostCtors = this._includedPostCtors ? this._includedPostCtors.slice(0) : [];
                    inheritor.prototype.constructor = inheritor;
                    inheritor.redefine(members);
                    return inheritor
                };
                classImpl.abstract = abstract;
                var _default = classImpl;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        44297:
            /*!***************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/component.js ***!
              \***************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.Component = void 0;
                var _config = _interopRequireDefault(__webpack_require__( /*! ./config */ 80209));
                var _extend = __webpack_require__( /*! ./utils/extend */ 13306);
                var _index = __webpack_require__( /*! ./options/index */ 95683);
                var _utils = __webpack_require__( /*! ./options/utils */ 45434);
                var _class = _interopRequireDefault(__webpack_require__( /*! ./class */ 38377));
                var _action = _interopRequireDefault(__webpack_require__( /*! ./action */ 62414));
                var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 17381));
                var _callbacks = _interopRequireDefault(__webpack_require__( /*! ./utils/callbacks */ 44504));
                var _events_strategy = __webpack_require__( /*! ./events_strategy */ 80566);
                var _public_component = __webpack_require__( /*! ./utils/public_component */ 9321);
                var _postponed_operations = __webpack_require__( /*! ./postponed_operations */ 90889);
                var _type = __webpack_require__( /*! ./utils/type */ 35922);
                var _common = __webpack_require__( /*! ./utils/common */ 20576);
                var _data = __webpack_require__( /*! ./utils/data */ 47617);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var getEventName = function(actionName) {
                    return actionName.charAt(2).toLowerCase() + actionName.substr(3)
                };
                var Component = _class.default.inherit({
                    _setDeprecatedOptions: function() {
                        this._deprecatedOptions = {}
                    },
                    _getDeprecatedOptions: function() {
                        return this._deprecatedOptions
                    },
                    _getDefaultOptions: function() {
                        return {
                            onInitialized: null,
                            onOptionChanged: null,
                            onDisposing: null,
                            defaultOptionsRules: null
                        }
                    },
                    _defaultOptionsRules: function() {
                        return []
                    },
                    _setOptionsByDevice: function(rules) {
                        this._options.applyRules(rules)
                    },
                    _convertRulesToOptions: function(rules) {
                        return (0, _utils.convertRulesToOptions)(rules)
                    },
                    _isInitialOptionValue: function(name) {
                        return this._options.isInitial(name)
                    },
                    _setOptionsByReference: function() {
                        this._optionsByReference = {}
                    },
                    _getOptionsByReference: function() {
                        return this._optionsByReference
                    },
                    ctor: function() {
                        var options = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {};
                        var _optionChangedCallbacks = options._optionChangedCallbacks,
                            _disposingCallbacks = options._disposingCallbacks;
                        this.NAME = (0, _public_component.name)(this.constructor);
                        this._eventsStrategy = _events_strategy.EventsStrategy.create(this, options.eventsStrategy);
                        this._updateLockCount = 0;
                        this._optionChangedCallbacks = _optionChangedCallbacks || (0, _callbacks.default)();
                        this._disposingCallbacks = _disposingCallbacks || (0, _callbacks.default)();
                        this.postponedOperations = new _postponed_operations.PostponedOperations;
                        this._createOptions(options)
                    },
                    _createOptions: function(options) {
                        var _this = this;
                        this.beginUpdate();
                        try {
                            this._setOptionsByReference();
                            this._setDeprecatedOptions();
                            this._options = new _index.Options(this._getDefaultOptions(), this._getDefaultOptions(), this._getOptionsByReference(), this._getDeprecatedOptions());
                            this._options.onChanging((function(name, previousValue, value) {
                                return _this._initialized && _this._optionChanging(name, previousValue, value)
                            }));
                            this._options.onDeprecated((function(option, info) {
                                return _this._logDeprecatedOptionWarning(option, info)
                            }));
                            this._options.onChanged((function(name, value, previousValue) {
                                return _this._notifyOptionChanged(name, value, previousValue)
                            }));
                            this._options.onStartChange((function() {
                                return _this.beginUpdate()
                            }));
                            this._options.onEndChange((function() {
                                return _this.endUpdate()
                            }));
                            this._options.addRules(this._defaultOptionsRules());
                            if (options && options.onInitializing) {
                                options.onInitializing.apply(this, [options])
                            }
                            this._setOptionsByDevice(options.defaultOptionsRules);
                            this._initOptions(options)
                        } finally {
                            this.endUpdate()
                        }
                    },
                    _initOptions: function(options) {
                        this.option(options)
                    },
                    _init: function() {
                        var _this2 = this;
                        this._createOptionChangedAction();
                        this.on("disposing", (function(args) {
                            _this2._disposingCallbacks.fireWith(_this2, [args])
                        }))
                    },
                    _logDeprecatedOptionWarning: function(option, info) {
                        var message = info.message || "Use the '".concat(info.alias, "' option instead");
                        _errors.default.log("W0001", this.NAME, option, info.since, message)
                    },
                    _logDeprecatedComponentWarning: function(since, alias) {
                        _errors.default.log("W0000", this.NAME, since, "Use the '".concat(alias, "' widget instead"))
                    },
                    _createOptionChangedAction: function() {
                        this._optionChangedAction = this._createActionByOption("onOptionChanged", {
                            excludeValidators: ["disabled", "readOnly"]
                        })
                    },
                    _createDisposingAction: function() {
                        this._disposingAction = this._createActionByOption("onDisposing", {
                            excludeValidators: ["disabled", "readOnly"]
                        })
                    },
                    _optionChanged: function(args) {
                        switch (args.name) {
                            case "onDisposing":
                            case "onInitialized":
                                break;
                            case "onOptionChanged":
                                this._createOptionChangedAction()
                        }
                    },
                    _dispose: function() {
                        this._optionChangedCallbacks.empty();
                        this._createDisposingAction();
                        this._disposingAction();
                        this._eventsStrategy.dispose();
                        this._options.dispose();
                        this._disposed = true
                    },
                    _lockUpdate: function() {
                        this._updateLockCount++
                    },
                    _unlockUpdate: function() {
                        this._updateLockCount = Math.max(this._updateLockCount - 1, 0)
                    },
                    _isUpdateAllowed: function() {
                        return 0 === this._updateLockCount
                    },
                    _isInitializingRequired: function() {
                        return !this._initializing && !this._initialized
                    },
                    isInitialized: function() {
                        return this._initialized
                    },
                    _commitUpdate: function() {
                        this.postponedOperations.callPostponedOperations();
                        this._isInitializingRequired() && this._initializeComponent()
                    },
                    _initializeComponent: function() {
                        this._initializing = true;
                        try {
                            this._init()
                        } finally {
                            this._initializing = false;
                            this._lockUpdate();
                            this._createActionByOption("onInitialized", {
                                excludeValidators: ["disabled", "readOnly"]
                            })();
                            this._unlockUpdate();
                            this._initialized = true
                        }
                    },
                    instance: function() {
                        return this
                    },
                    beginUpdate: function() {
                        this._lockUpdate()
                    },
                    endUpdate: function() {
                        this._unlockUpdate();
                        this._isUpdateAllowed() && this._commitUpdate()
                    },
                    _optionChanging: _common.noop,
                    _notifyOptionChanged: function(option, value, previousValue) {
                        if (this._initialized) {
                            var optionNames = [option].concat(this._options.getAliasesByName(option));
                            for (var i = 0; i < optionNames.length; i++) {
                                var name = optionNames[i];
                                var args = {
                                    name: (0, _data.getPathParts)(name)[0],
                                    fullName: name,
                                    value: value,
                                    previousValue: previousValue
                                };
                                if (!(optionName = name, 0 === optionName.indexOf("_", 0))) {
                                    this._optionChangedCallbacks.fireWith(this, [(0, _extend.extend)(this._defaultActionArgs(), args)]);
                                    this._optionChangedAction((0, _extend.extend)({}, args))
                                }
                                if (!this._disposed && this._cancelOptionChange !== name) {
                                    this._optionChanged(args)
                                }
                            }
                        }
                        var optionName
                    },
                    initialOption: function(name) {
                        return this._options.initial(name)
                    },
                    _defaultActionConfig: function() {
                        return {
                            context: this,
                            component: this
                        }
                    },
                    _defaultActionArgs: function() {
                        return {
                            component: this
                        }
                    },
                    _createAction: function(actionSource, config) {
                        var _this3 = this;
                        var action;
                        return function(e) {
                            if (!(0, _type.isDefined)(e)) {
                                e = {}
                            }
                            if (!(0, _type.isPlainObject)(e)) {
                                e = {
                                    actionValue: e
                                }
                            }
                            action = action || new _action.default(actionSource, (0, _extend.extend)(config, _this3._defaultActionConfig()));
                            return action.execute.call(action, (0, _extend.extend)(e, _this3._defaultActionArgs()))
                        }
                    },
                    _createActionByOption: function(optionName, config) {
                        var _this4 = this;
                        var action;
                        var eventName;
                        var actionFunc;
                        var result = function() {
                            if (!eventName) {
                                config = config || {};
                                if ("string" !== typeof optionName) {
                                    throw _errors.default.Error("E0008")
                                }
                                if (0 === optionName.indexOf("on")) {
                                    eventName = getEventName(optionName)
                                }
                                actionFunc = _this4.option(optionName)
                            }
                            if (!action && !actionFunc && !config.beforeExecute && !config.afterExecute && !_this4._eventsStrategy.hasEvent(eventName)) {
                                return
                            }
                            if (!action) {
                                var beforeExecute = config.beforeExecute;
                                config.beforeExecute = function() {
                                    for (var _len2 = arguments.length, props = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                                        props[_key2] = arguments[_key2]
                                    }
                                    beforeExecute && beforeExecute.apply(_this4, props);
                                    _this4._eventsStrategy.fireEvent(eventName, props[0].args)
                                };
                                action = _this4._createAction(actionFunc, config)
                            }
                            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                                args[_key] = arguments[_key]
                            }
                            if ((0, _config.default)().wrapActionsBeforeExecute) {
                                var beforeActionExecute = _this4.option("beforeActionExecute") || _common.noop;
                                var wrappedAction = beforeActionExecute(_this4, action, config) || action;
                                return wrappedAction.apply(_this4, args)
                            }
                            return action.apply(_this4, args)
                        };
                        if ((0, _config.default)().wrapActionsBeforeExecute) {
                            return result
                        }
                        var onActionCreated = this.option("onActionCreated") || _common.noop;
                        return onActionCreated(this, result, config) || result
                    },
                    on: function(eventName, eventHandler) {
                        this._eventsStrategy.on(eventName, eventHandler);
                        return this
                    },
                    off: function(eventName, eventHandler) {
                        this._eventsStrategy.off(eventName, eventHandler);
                        return this
                    },
                    hasActionSubscription: function(actionName) {
                        return !!this._options.silent(actionName) || this._eventsStrategy.hasEvent(getEventName(actionName))
                    },
                    isOptionDeprecated: function(name) {
                        return this._options.isDeprecated(name)
                    },
                    _setOptionWithoutOptionChange: function(name, value) {
                        this._cancelOptionChange = name;
                        this.option(name, value);
                        this._cancelOptionChange = false
                    },
                    _getOptionValue: function(name, context) {
                        var value = this.option(name);
                        if ((0, _type.isFunction)(value)) {
                            return value.bind(context)()
                        }
                        return value
                    },
                    option: function() {
                        var _this$_options;
                        return (_this$_options = this._options).option.apply(_this$_options, arguments)
                    },
                    resetOption: function(name) {
                        this.beginUpdate();
                        this._options.reset(name);
                        this.endUpdate()
                    }
                });
                exports.Component = Component
            },
        99393:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/component_registrator.js ***!
              \***************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ./renderer */ 68374));
                var _component_registrator_callbacks = _interopRequireDefault(__webpack_require__( /*! ./component_registrator_callbacks */ 5554));
                var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 17381));
                var _public_component = __webpack_require__( /*! ./utils/public_component */ 9321);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                _component_registrator_callbacks.default.add((function(name, componentClass) {
                    _renderer.default.fn[name] = function(options) {
                        var isMemberInvoke = "string" === typeof options;
                        var result;
                        if (isMemberInvoke) {
                            var memberName = options;
                            var memberArgs = [].slice.call(arguments).slice(1);
                            this.each((function() {
                                var instance = componentClass.getInstance(this);
                                if (!instance) {
                                    throw _errors.default.Error("E0009", name)
                                }
                                var member = instance[memberName];
                                var memberValue = member.apply(instance, memberArgs);
                                if (void 0 === result) {
                                    result = memberValue
                                }
                            }))
                        } else {
                            this.each((function() {
                                var instance = componentClass.getInstance(this);
                                if (instance) {
                                    instance.option(options)
                                } else {
                                    new componentClass(this, options)
                                }
                            }));
                            result = this
                        }
                        return result
                    }
                }));
                var _default = function(name, namespace, componentClass) {
                    if (!componentClass) {
                        componentClass = namespace
                    } else {
                        namespace[name] = componentClass
                    }(0, _public_component.name)(componentClass, name);
                    _component_registrator_callbacks.default.fire(name, componentClass)
                };
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        5554:
            /*!*************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/component_registrator_callbacks.js ***!
              \*************************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _memorized_callbacks = (obj = __webpack_require__( /*! ./memorized_callbacks */ 83358), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _default = new _memorized_callbacks.default;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        80209:
            /*!************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/config.js ***!
              \************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _extend = __webpack_require__( /*! ./utils/extend */ 13306);
                var _errors = (obj = __webpack_require__( /*! ./errors */ 17381), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var config = {
                    rtlEnabled: false,
                    defaultCurrency: "USD",
                    defaultUseCurrencyAccountingStyle: true,
                    oDataFilterToLower: true,
                    serverDecimalSeparator: ".",
                    decimalSeparator: ".",
                    thousandsSeparator: ",",
                    forceIsoDateParsing: true,
                    wrapActionsBeforeExecute: true,
                    useLegacyStoreResult: false,
                    useJQuery: void 0,
                    editorStylingMode: void 0,
                    useLegacyVisibleIndex: false,
                    floatingActionButtonConfig: {
                        icon: "add",
                        closeIcon: "close",
                        label: "",
                        position: {
                            at: "right bottom",
                            my: "right bottom",
                            offset: {
                                x: -16,
                                y: -16
                            }
                        },
                        maxSpeedDialActionCount: 5,
                        shading: false,
                        direction: "auto"
                    },
                    optionsParser: function(optionsString) {
                        if ("{" !== optionsString.trim().charAt(0)) {
                            optionsString = "{" + optionsString + "}"
                        }
                        try {
                            return new Function("return " + optionsString)()
                        } catch (ex) {
                            throw _errors.default.Error("E3018", ex, optionsString)
                        }
                    }
                };
                var deprecatedFields = ["decimalSeparator", "thousandsSeparator"];
                var configMethod = function() {
                    if (!arguments.length) {
                        return config
                    }
                    var newConfig = arguments.length <= 0 ? void 0 : arguments[0];
                    deprecatedFields.forEach((function(deprecatedField) {
                        if (newConfig[deprecatedField]) {
                            var message = "Now, the ".concat(deprecatedField, " is selected based on the specified locale.");
                            _errors.default.log("W0003", "config", deprecatedField, "19.2", message)
                        }
                    }));
                    (0, _extend.extend)(config, newConfig)
                };
                if ("undefined" !== typeof DevExpress && DevExpress.config) {
                    configMethod(DevExpress.config)
                }
                var _default = configMethod;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        20530:
            /*!*************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/devices.js ***!
              \*************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _size = __webpack_require__( /*! ./utils/size */ 58664);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 68374));
                var _window = __webpack_require__( /*! ./utils/window */ 58201);
                var _extend = __webpack_require__( /*! ./utils/extend */ 13306);
                var _type = __webpack_require__( /*! ./utils/type */ 35922);
                var _iterator = __webpack_require__( /*! ./utils/iterator */ 95479);
                var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 17381));
                var _callbacks = _interopRequireDefault(__webpack_require__( /*! ./utils/callbacks */ 44504));
                var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ./utils/ready_callbacks */ 24311));
                var _resize_callbacks = _interopRequireDefault(__webpack_require__( /*! ./utils/resize_callbacks */ 55814));
                var _events_strategy = __webpack_require__( /*! ./events_strategy */ 80566);
                var _storage = __webpack_require__( /*! ./utils/storage */ 36613);
                var _view_port = __webpack_require__( /*! ./utils/view_port */ 77695);
                var _config = _interopRequireDefault(__webpack_require__( /*! ./config */ 80209));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var navigator = (0, _window.getNavigator)();
                var window = (0, _window.getWindow)();
                var KNOWN_UA_TABLE = {
                    iPhone: "iPhone",
                    iPhone5: "iPhone",
                    iPhone6: "iPhone",
                    iPhone6plus: "iPhone",
                    iPad: "iPad",
                    iPadMini: "iPad Mini",
                    androidPhone: "Android Mobile",
                    androidTablet: "Android",
                    msSurface: "Windows ARM Tablet PC",
                    desktop: "desktop"
                };
                var DEFAULT_DEVICE = {
                    deviceType: "desktop",
                    platform: "generic",
                    version: [],
                    phone: false,
                    tablet: false,
                    android: false,
                    ios: false,
                    generic: true,
                    grade: "A",
                    mac: false
                };
                var uaParsers = {
                    generic: function(userAgent) {
                        var isPhone = /windows phone/i.test(userAgent) || userAgent.match(/WPDesktop/);
                        var isTablet = !isPhone && /Windows(.*)arm(.*)Tablet PC/i.test(userAgent);
                        var isDesktop = !isPhone && !isTablet && /msapphost/i.test(userAgent);
                        var isMac = /((intel|ppc) mac os x)/.test(userAgent.toLowerCase());
                        if (!(isPhone || isTablet || isDesktop || isMac)) {
                            return
                        }
                        return {
                            deviceType: isPhone ? "phone" : isTablet ? "tablet" : "desktop",
                            platform: "generic",
                            version: [],
                            grade: "A",
                            mac: isMac
                        }
                    },
                    ios: function(userAgent) {
                        if (!/ip(hone|od|ad)/i.test(userAgent)) {
                            return
                        }
                        var isPhone = /ip(hone|od)/i.test(userAgent);
                        var matches = userAgent.match(/os (\d+)_(\d+)_?(\d+)?/i);
                        var version = matches ? [parseInt(matches[1], 10), parseInt(matches[2], 10), parseInt(matches[3] || 0, 10)] : [];
                        var isIPhone4 = 480 === window.screen.height;
                        var grade = isIPhone4 ? "B" : "A";
                        return {
                            deviceType: isPhone ? "phone" : "tablet",
                            platform: "ios",
                            version: version,
                            grade: grade
                        }
                    },
                    android: function(userAgent) {
                        if (!/android|htc_|silk/i.test(userAgent)) {
                            return
                        }
                        var isPhone = /mobile/i.test(userAgent);
                        var matches = userAgent.match(/android (\d+)\.?(\d+)?\.?(\d+)?/i);
                        var version = matches ? [parseInt(matches[1], 10), parseInt(matches[2] || 0, 10), parseInt(matches[3] || 0, 10)] : [];
                        var worseThan4_4 = version.length > 1 && (version[0] < 4 || 4 === version[0] && version[1] < 4);
                        var grade = worseThan4_4 ? "B" : "A";
                        return {
                            deviceType: isPhone ? "phone" : "tablet",
                            platform: "android",
                            version: version,
                            grade: grade
                        }
                    }
                };
                var Devices = function() {
                    function Devices(options) {
                        this._window = (null === options || void 0 === options ? void 0 : options.window) || window;
                        this._realDevice = this._getDevice();
                        this._currentDevice = void 0;
                        this._currentOrientation = void 0;
                        this._eventsStrategy = new _events_strategy.EventsStrategy(this);
                        this.changed = (0, _callbacks.default)();
                        if ((0, _window.hasWindow)()) {
                            _ready_callbacks.default.add(this._recalculateOrientation.bind(this));
                            _resize_callbacks.default.add(this._recalculateOrientation.bind(this))
                        }
                    }
                    var _proto = Devices.prototype;
                    _proto.current = function(deviceOrName) {
                        if (deviceOrName) {
                            this._currentDevice = this._getDevice(deviceOrName);
                            this._forced = true;
                            this.changed.fire();
                            return
                        }
                        if (!this._currentDevice) {
                            deviceOrName = void 0;
                            try {
                                deviceOrName = this._getDeviceOrNameFromWindowScope()
                            } catch (e) {
                                deviceOrName = this._getDeviceNameFromSessionStorage()
                            } finally {
                                if (!deviceOrName) {
                                    deviceOrName = this._getDeviceNameFromSessionStorage()
                                }
                                if (deviceOrName) {
                                    this._forced = true
                                }
                            }
                            this._currentDevice = this._getDevice(deviceOrName)
                        }
                        return this._currentDevice
                    };
                    _proto.real = function(forceDevice) {
                        return (0, _extend.extend)({}, this._realDevice)
                    };
                    _proto.orientation = function() {
                        return this._currentOrientation
                    };
                    _proto.isForced = function() {
                        return this._forced
                    };
                    _proto.isRippleEmulator = function() {
                        return !!this._window.tinyHippos
                    };
                    _proto._getCssClasses = function(device) {
                        var result = [];
                        var realDevice = this._realDevice;
                        device = device || this.current();
                        if (device.deviceType) {
                            result.push("dx-device-".concat(device.deviceType));
                            if ("desktop" !== device.deviceType) {
                                result.push("dx-device-mobile")
                            }
                        }
                        result.push("dx-device-".concat(realDevice.platform));
                        if (realDevice.version && realDevice.version.length) {
                            result.push("dx-device-".concat(realDevice.platform, "-").concat(realDevice.version[0]))
                        }
                        if (this.isSimulator()) {
                            result.push("dx-simulator")
                        }
                        if ((0, _config.default)().rtlEnabled) {
                            result.push("dx-rtl")
                        }
                        return result
                    };
                    _proto.attachCssClasses = function(element, device) {
                        this._deviceClasses = this._getCssClasses(device).join(" ");
                        (0, _renderer.default)(element).addClass(this._deviceClasses)
                    };
                    _proto.detachCssClasses = function(element) {
                        (0, _renderer.default)(element).removeClass(this._deviceClasses)
                    };
                    _proto.isSimulator = function() {
                        try {
                            return this._isSimulator || (0, _window.hasWindow)() && this._window.top !== this._window.self && this._window.top["dx-force-device"] || this.isRippleEmulator()
                        } catch (e) {
                            return false
                        }
                    };
                    _proto.forceSimulator = function() {
                        this._isSimulator = true
                    };
                    _proto._getDevice = function(deviceName) {
                        if ("genericPhone" === deviceName) {
                            deviceName = {
                                deviceType: "phone",
                                platform: "generic",
                                generic: true
                            }
                        }
                        if ((0, _type.isPlainObject)(deviceName)) {
                            return this._fromConfig(deviceName)
                        } else {
                            var ua;
                            if (deviceName) {
                                ua = KNOWN_UA_TABLE[deviceName];
                                if (!ua) {
                                    throw _errors.default.Error("E0005")
                                }
                            } else {
                                ua = navigator.userAgent
                            }
                            return this._fromUA(ua)
                        }
                    };
                    _proto._getDeviceOrNameFromWindowScope = function() {
                        var result;
                        if ((0, _window.hasWindow)() && (this._window.top["dx-force-device-object"] || this._window.top["dx-force-device"])) {
                            result = this._window.top["dx-force-device-object"] || this._window.top["dx-force-device"]
                        }
                        return result
                    };
                    _proto._getDeviceNameFromSessionStorage = function() {
                        var sessionStorage = (0, _storage.sessionStorage)();
                        if (!sessionStorage) {
                            return
                        }
                        var deviceOrName = sessionStorage.getItem("dx-force-device");
                        try {
                            return JSON.parse(deviceOrName)
                        } catch (ex) {
                            return deviceOrName
                        }
                    };
                    _proto._fromConfig = function(config) {
                        var result = (0, _extend.extend)({}, DEFAULT_DEVICE, this._currentDevice, config);
                        var shortcuts = {
                            phone: "phone" === result.deviceType,
                            tablet: "tablet" === result.deviceType,
                            android: "android" === result.platform,
                            ios: "ios" === result.platform,
                            generic: "generic" === result.platform
                        };
                        return (0, _extend.extend)(result, shortcuts)
                    };
                    _proto._fromUA = function(ua) {
                        var config;
                        (0, _iterator.each)(uaParsers, (function(platform, parser) {
                            config = parser(ua);
                            return !config
                        }));
                        if (config) {
                            return this._fromConfig(config)
                        }
                        return DEFAULT_DEVICE
                    };
                    _proto._changeOrientation = function() {
                        var $window = (0, _renderer.default)(this._window);
                        var orientation = (0, _size.getHeight)($window) > (0, _size.getWidth)($window) ? "portrait" : "landscape";
                        if (this._currentOrientation === orientation) {
                            return
                        }
                        this._currentOrientation = orientation;
                        this._eventsStrategy.fireEvent("orientationChanged", [{
                            orientation: orientation
                        }])
                    };
                    _proto._recalculateOrientation = function() {
                        var windowWidth = (0, _size.getWidth)(this._window);
                        if (this._currentWidth === windowWidth) {
                            return
                        }
                        this._currentWidth = windowWidth;
                        this._changeOrientation()
                    };
                    _proto.on = function(eventName, eventHandler) {
                        this._eventsStrategy.on(eventName, eventHandler);
                        return this
                    };
                    _proto.off = function(eventName, eventHandler) {
                        this._eventsStrategy.off(eventName, eventHandler);
                        return this
                    };
                    return Devices
                }();
                var devices = new Devices;
                var viewPortElement = (0, _view_port.value)();
                if (viewPortElement) {
                    devices.attachCssClasses(viewPortElement)
                }
                _view_port.changeCallback.add((function(viewPort, prevViewport) {
                    devices.detachCssClasses(prevViewport);
                    devices.attachCssClasses(viewPort)
                }));
                var _default = devices;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        73349:
            /*!*****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/dom_adapter.js ***!
              \*****************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _dependency_injector = (obj = __webpack_require__( /*! ./utils/dependency_injector */ 20476), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _common = __webpack_require__( /*! ./utils/common */ 20576);

                function _typeof(obj) {
                    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj) {
                        return typeof obj
                    } : function(obj) {
                        return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                    }, _typeof(obj)
                }
                var nativeDOMAdapterStrategy = {
                    querySelectorAll: function(element, selector) {
                        return element.querySelectorAll(selector)
                    },
                    elementMatches: function(element, selector) {
                        var _this = this;
                        var matches = element.matches || element.matchesSelector || element.mozMatchesSelector || element.msMatchesSelector || element.oMatchesSelector || element.webkitMatchesSelector || function(selector) {
                            var doc = element.document || element.ownerDocument;
                            if (!doc) {
                                return false
                            }
                            var items = _this.querySelectorAll(doc, selector);
                            for (var i = 0; i < items.length; i++) {
                                if (items[i] === element) {
                                    return true
                                }
                            }
                        };
                        return matches.call(element, selector)
                    },
                    createElement: function(tagName, context) {
                        context = context || this._document;
                        return context.createElement(tagName)
                    },
                    createElementNS: function(ns, tagName, context) {
                        context = context || this._document;
                        return context.createElementNS(ns, tagName)
                    },
                    createTextNode: function(text, context) {
                        context = context || this._document;
                        return context.createTextNode(text)
                    },
                    isNode: function(element) {
                        return element && "object" === _typeof(element) && "nodeType" in element && "nodeName" in element
                    },
                    isElementNode: function(element) {
                        return element && 1 === element.nodeType
                    },
                    isTextNode: function(element) {
                        return element && 3 === element.nodeType
                    },
                    isDocument: function(element) {
                        return element && 9 === element.nodeType
                    },
                    removeElement: function(element) {
                        var parentNode = element && element.parentNode;
                        if (parentNode) {
                            parentNode.removeChild(element)
                        }
                    },
                    insertElement: function(parentElement, newElement, nextSiblingElement) {
                        if (parentElement && newElement && parentElement !== newElement) {
                            if (nextSiblingElement) {
                                parentElement.insertBefore(newElement, nextSiblingElement)
                            } else {
                                parentElement.appendChild(newElement)
                            }
                        }
                    },
                    getAttribute: function(element, name) {
                        return element.getAttribute(name)
                    },
                    setAttribute: function(element, name, value) {
                        element.setAttribute(name, value)
                    },
                    removeAttribute: function(element, name) {
                        element.removeAttribute(name)
                    },
                    setProperty: function(element, name, value) {
                        element[name] = value
                    },
                    setText: function(element, text) {
                        if (element) {
                            element.textContent = text
                        }
                    },
                    setClass: function(element, className, isAdd) {
                        if (1 === element.nodeType && className) {
                            isAdd ? element.classList.add(className) : element.classList.remove(className)
                        }
                    },
                    setStyle: function(element, name, value) {
                        element.style[name] = value || ""
                    },
                    _document: "undefined" === typeof document ? void 0 : document,
                    getDocument: function() {
                        return this._document
                    },
                    getActiveElement: function(element) {
                        var _element$getRootNode, _element$getRootNode2;
                        var activeElementHolder = null !== (_element$getRootNode = null === element || void 0 === element ? void 0 : null === (_element$getRootNode2 = element.getRootNode) || void 0 === _element$getRootNode2 ? void 0 : _element$getRootNode2.call(element)) && void 0 !== _element$getRootNode ? _element$getRootNode : this._document;
                        return activeElementHolder.activeElement
                    },
                    getBody: function() {
                        return this._document.body
                    },
                    createDocumentFragment: function() {
                        return this._document.createDocumentFragment()
                    },
                    getDocumentElement: function() {
                        return this._document.documentElement
                    },
                    getLocation: function() {
                        return this._document.location
                    },
                    getSelection: function() {
                        return this._document.selection
                    },
                    getReadyState: function() {
                        return this._document.readyState
                    },
                    getHead: function() {
                        return this._document.head
                    },
                    hasDocumentProperty: function(property) {
                        return property in this._document
                    },
                    listen: function(element, event, callback, options) {
                        if (!element || !("addEventListener" in element)) {
                            return _common.noop
                        }
                        element.addEventListener(event, callback, options);
                        return function() {
                            element.removeEventListener(event, callback)
                        }
                    },
                    elementsFromPoint: function(x, y) {
                        return this._document.elementsFromPoint(x, y)
                    }
                };
                var _default = (0, _dependency_injector.default)(nativeDOMAdapterStrategy);
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        13046:
            /*!*******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/dom_component.js ***!
              \*******************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 68374));
                var _config = _interopRequireDefault(__webpack_require__( /*! ./config */ 80209));
                var _errors = _interopRequireDefault(__webpack_require__( /*! ./errors */ 17381));
                var _resize_callbacks = _interopRequireDefault(__webpack_require__( /*! ../core/utils/resize_callbacks */ 55814));
                var _component = __webpack_require__( /*! ./component */ 44297);
                var _template_manager = __webpack_require__( /*! ./template_manager */ 14192);
                var _public_component = __webpack_require__( /*! ./utils/public_component */ 9321);
                var _element_data = __webpack_require__( /*! ./element_data */ 97906);
                var _iterator = __webpack_require__( /*! ./utils/iterator */ 95479);
                var _extend = __webpack_require__( /*! ./utils/extend */ 13306);
                var _element = __webpack_require__( /*! ../core/element */ 6415);
                var _common = __webpack_require__( /*! ./utils/common */ 20576);
                var _type = __webpack_require__( /*! ./utils/type */ 35922);
                var _window = __webpack_require__( /*! ../core/utils/window */ 58201);
                var _short = __webpack_require__( /*! ../events/short */ 72918);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var abstract = _component.Component.abstract;
                var DOMComponent = _component.Component.inherit({
                    _getDefaultOptions: function() {
                        return (0, _extend.extend)(this.callBase(), {
                            width: void 0,
                            height: void 0,
                            rtlEnabled: (0, _config.default)().rtlEnabled,
                            elementAttr: {},
                            disabled: false,
                            integrationOptions: {}
                        }, this._useTemplates() ? _template_manager.TemplateManager.createDefaultOptions() : {})
                    },
                    ctor: function(element, options) {
                        this._customClass = null;
                        this._createElement(element);
                        (0, _public_component.attachInstanceToElement)(this._$element, this, this._dispose);
                        this.callBase(options)
                    },
                    _createElement: function(element) {
                        this._$element = (0, _renderer.default)(element)
                    },
                    _getSynchronizableOptionsForCreateComponent: function() {
                        return ["rtlEnabled", "disabled", "templatesRenderAsynchronously"]
                    },
                    _checkFunctionValueDeprecation: function(optionNames) {
                        var _this = this;
                        if (!this.option("_ignoreFunctionValueDeprecation")) {
                            optionNames.forEach((function(optionName) {
                                if ((0, _type.isFunction)(_this.option(optionName))) {
                                    _errors.default.log("W0017", optionName)
                                }
                            }))
                        }
                    },
                    _visibilityChanged: abstract,
                    _dimensionChanged: abstract,
                    _init: function() {
                        this.callBase();
                        this._checkFunctionValueDeprecation(["width", "height", "maxHeight", "maxWidth", "minHeight", "minWidth", "popupHeight", "popupWidth"]);
                        this._attachWindowResizeCallback();
                        this._initTemplateManager()
                    },
                    _setOptionsByDevice: function(instanceCustomRules) {
                        this.callBase([].concat(this.constructor._classCustomRules || [], instanceCustomRules || []))
                    },
                    _isInitialOptionValue: function(name) {
                        var isCustomOption = this.constructor._classCustomRules && Object.prototype.hasOwnProperty.call(this._convertRulesToOptions(this.constructor._classCustomRules), name);
                        return !isCustomOption && this.callBase(name)
                    },
                    _attachWindowResizeCallback: function() {
                        if (this._isDimensionChangeSupported()) {
                            var windowResizeCallBack = this._windowResizeCallBack = this._dimensionChanged.bind(this);
                            _resize_callbacks.default.add(windowResizeCallBack)
                        }
                    },
                    _isDimensionChangeSupported: function() {
                        return this._dimensionChanged !== abstract
                    },
                    _renderComponent: function() {
                        this._initMarkup();
                        (0, _window.hasWindow)() && this._render()
                    },
                    _initMarkup: function() {
                        var _ref = this.option() || {},
                            rtlEnabled = _ref.rtlEnabled;
                        this._renderElementAttributes();
                        this._toggleRTLDirection(rtlEnabled);
                        this._renderVisibilityChange();
                        this._renderDimensions()
                    },
                    _render: function() {
                        this._attachVisibilityChangeHandlers()
                    },
                    _renderElementAttributes: function() {
                        var _ref2 = this.option() || {},
                            elementAttr = _ref2.elementAttr;
                        var attributes = (0, _extend.extend)({}, elementAttr);
                        var classNames = attributes.class;
                        delete attributes.class;
                        this.$element().attr(attributes).removeClass(this._customClass).addClass(classNames);
                        this._customClass = classNames
                    },
                    _renderVisibilityChange: function() {
                        if (this._isDimensionChangeSupported()) {
                            this._attachDimensionChangeHandlers()
                        }
                        if (this._isVisibilityChangeSupported()) {
                            var $element = this.$element();
                            $element.addClass("dx-visibility-change-handler")
                        }
                    },
                    _renderDimensions: function() {
                        var $element = this.$element();
                        var element = $element.get(0);
                        var width = this._getOptionValue("width", element);
                        var height = this._getOptionValue("height", element);
                        if (this._isCssUpdateRequired(element, height, width)) {
                            $element.css({
                                width: null === width ? "" : width,
                                height: null === height ? "" : height
                            })
                        }
                    },
                    _isCssUpdateRequired: function(element, height, width) {
                        return !!((0, _type.isDefined)(width) || (0, _type.isDefined)(height) || element.style.width || element.style.height)
                    },
                    _attachDimensionChangeHandlers: function() {
                        var _this2 = this;
                        var $el = this.$element();
                        var namespace = "".concat(this.NAME, "VisibilityChange");
                        _short.resize.off($el, {
                            namespace: namespace
                        });
                        _short.resize.on($el, (function() {
                            return _this2._dimensionChanged()
                        }), {
                            namespace: namespace
                        })
                    },
                    _attachVisibilityChangeHandlers: function() {
                        var _this3 = this;
                        if (this._isVisibilityChangeSupported()) {
                            var $el = this.$element();
                            var namespace = "".concat(this.NAME, "VisibilityChange");
                            this._isHidden = !this._isVisible();
                            _short.visibility.off($el, {
                                namespace: namespace
                            });
                            _short.visibility.on($el, (function() {
                                return _this3._checkVisibilityChanged("shown")
                            }), (function() {
                                return _this3._checkVisibilityChanged("hiding")
                            }), {
                                namespace: namespace
                            })
                        }
                    },
                    _isVisible: function() {
                        var $element = this.$element();
                        return $element.is(":visible")
                    },
                    _checkVisibilityChanged: function(action) {
                        var isVisible = this._isVisible();
                        if (isVisible) {
                            if ("hiding" === action && !this._isHidden) {
                                this._visibilityChanged(false);
                                this._isHidden = true
                            } else if ("shown" === action && this._isHidden) {
                                this._isHidden = false;
                                this._visibilityChanged(true)
                            }
                        }
                    },
                    _isVisibilityChangeSupported: function() {
                        return this._visibilityChanged !== abstract && (0, _window.hasWindow)()
                    },
                    _clean: _common.noop,
                    _modelByElement: function() {
                        var _this$option = this.option(),
                            modelByElement = _this$option.modelByElement;
                        var $element = this.$element();
                        return modelByElement ? modelByElement($element) : void 0
                    },
                    _invalidate: function() {
                        if (this._isUpdateAllowed()) {
                            throw _errors.default.Error("E0007")
                        }
                        this._requireRefresh = true
                    },
                    _refresh: function() {
                        this._clean();
                        this._renderComponent()
                    },
                    _dispose: function() {
                        this._templateManager && this._templateManager.dispose();
                        this.callBase();
                        this._clean();
                        this._detachWindowResizeCallback()
                    },
                    _detachWindowResizeCallback: function() {
                        if (this._isDimensionChangeSupported()) {
                            _resize_callbacks.default.remove(this._windowResizeCallBack)
                        }
                    },
                    _toggleRTLDirection: function(rtl) {
                        var $element = this.$element();
                        $element.toggleClass("dx-rtl", rtl)
                    },
                    _createComponent: function(element, component) {
                        var _this4 = this;
                        var config = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
                        var synchronizableOptions = (0, _common.grep)(this._getSynchronizableOptionsForCreateComponent(), (function(value) {
                            return !(value in config)
                        }));
                        var _this$option2 = this.option(),
                            integrationOptions = _this$option2.integrationOptions;
                        var _this$option3 = this.option(),
                            nestedComponentOptions = _this$option3.nestedComponentOptions;
                        nestedComponentOptions = nestedComponentOptions || _common.noop;
                        var nestedComponentConfig = (0, _extend.extend)({
                            integrationOptions: integrationOptions
                        }, nestedComponentOptions(this));
                        synchronizableOptions.forEach((function(optionName) {
                            return nestedComponentConfig[optionName] = _this4.option(optionName)
                        }));
                        this._extendConfig(config, nestedComponentConfig);
                        var instance = void 0;
                        if ((0, _type.isString)(component)) {
                            var $element = (0, _renderer.default)(element)[component](config);
                            instance = $element[component]("instance")
                        } else if (element) {
                            instance = component.getInstance(element);
                            if (instance) {
                                instance.option(config)
                            } else {
                                instance = new component(element, config)
                            }
                        }
                        if (instance) {
                            var optionChangedHandler = function(_ref3) {
                                var name = _ref3.name,
                                    value = _ref3.value;
                                if (synchronizableOptions.includes(name)) {
                                    instance.option(name, value)
                                }
                            };
                            this.on("optionChanged", optionChangedHandler);
                            instance.on("disposing", (function() {
                                return _this4.off("optionChanged", optionChangedHandler)
                            }))
                        }
                        return instance
                    },
                    _extendConfig: function(config, extendConfig) {
                        (0, _iterator.each)(extendConfig, (function(key, value) {
                            !Object.prototype.hasOwnProperty.call(config, key) && (config[key] = value)
                        }))
                    },
                    _defaultActionConfig: function() {
                        var $element = this.$element();
                        var context = this._modelByElement($element);
                        return (0, _extend.extend)(this.callBase(), {
                            context: context
                        })
                    },
                    _defaultActionArgs: function() {
                        var $element = this.$element();
                        var model = this._modelByElement($element);
                        var element = this.element();
                        return (0, _extend.extend)(this.callBase(), {
                            element: element,
                            model: model
                        })
                    },
                    _optionChanged: function(args) {
                        switch (args.name) {
                            case "width":
                            case "height":
                                this._renderDimensions();
                                break;
                            case "rtlEnabled":
                                this._invalidate();
                                break;
                            case "elementAttr":
                                this._renderElementAttributes();
                                break;
                            case "disabled":
                            case "integrationOptions":
                                break;
                            default:
                                this.callBase(args)
                        }
                    },
                    _removeAttributes: function(element) {
                        var attrs = element.attributes;
                        for (var i = attrs.length - 1; i >= 0; i--) {
                            var attr = attrs[i];
                            if (attr) {
                                var name = attr.name;
                                if (!name.indexOf("aria-") || -1 !== name.indexOf("dx-") || "role" === name || "style" === name || "tabindex" === name) {
                                    element.removeAttribute(name)
                                }
                            }
                        }
                    },
                    _removeClasses: function(element) {
                        element.className = element.className.split(" ").filter((function(cssClass) {
                            return 0 !== cssClass.lastIndexOf("dx-", 0)
                        })).join(" ")
                    },
                    _updateDOMComponent: function(renderRequired) {
                        if (renderRequired) {
                            this._renderComponent()
                        } else if (this._requireRefresh) {
                            this._requireRefresh = false;
                            this._refresh()
                        }
                    },
                    endUpdate: function() {
                        var renderRequired = this._isInitializingRequired();
                        this.callBase();
                        this._isUpdateAllowed() && this._updateDOMComponent(renderRequired)
                    },
                    $element: function() {
                        return this._$element
                    },
                    element: function() {
                        var $element = this.$element();
                        return (0, _element.getPublicElement)($element)
                    },
                    dispose: function() {
                        var element = this.$element().get(0);
                        (0, _element_data.cleanDataRecursive)(element, true);
                        element.textContent = "";
                        this._removeAttributes(element);
                        this._removeClasses(element)
                    },
                    resetOption: function(optionName) {
                        this.callBase(optionName);
                        if ("width" === optionName || "height" === optionName) {
                            var initialOption = this.initialOption(optionName);
                            !(0, _type.isDefined)(initialOption) && this.$element().css(optionName, "")
                        }
                    },
                    _getAnonymousTemplateName: function() {
                        return
                    },
                    _initTemplateManager: function() {
                        if (this._templateManager || !this._useTemplates()) {
                            return
                        }
                        var _this$option4 = this.option(),
                            _this$option4$integra = _this$option4.integrationOptions,
                            integrationOptions = void 0 === _this$option4$integra ? {} : _this$option4$integra;
                        var createTemplate = integrationOptions.createTemplate;
                        this._templateManager = new _template_manager.TemplateManager(createTemplate, this._getAnonymousTemplateName());
                        this._initTemplates()
                    },
                    _initTemplates: function() {
                        var _this5 = this;
                        var _this$_templateManage = this._templateManager.extractTemplates(this.$element()),
                            templates = _this$_templateManage.templates,
                            anonymousTemplateMeta = _this$_templateManage.anonymousTemplateMeta;
                        var anonymousTemplate = this.option("integrationOptions.templates.".concat(anonymousTemplateMeta.name));
                        templates.forEach((function(_ref4) {
                            var name = _ref4.name,
                                template = _ref4.template;
                            _this5._options.silent("integrationOptions.templates.".concat(name), template)
                        }));
                        if (anonymousTemplateMeta.name && !anonymousTemplate) {
                            this._options.silent("integrationOptions.templates.".concat(anonymousTemplateMeta.name), anonymousTemplateMeta.template);
                            this._options.silent("_hasAnonymousTemplateContent", true)
                        }
                    },
                    _getTemplateByOption: function(optionName) {
                        return this._getTemplate(this.option(optionName))
                    },
                    _getTemplate: function(templateSource) {
                        var templates = this.option("integrationOptions.templates");
                        var isAsyncTemplate = this.option("templatesRenderAsynchronously");
                        var skipTemplates = this.option("integrationOptions.skipTemplates");
                        return this._templateManager.getTemplate(templateSource, templates, {
                            isAsyncTemplate: isAsyncTemplate,
                            skipTemplates: skipTemplates
                        }, this)
                    },
                    _saveTemplate: function(name, template) {
                        this._setOptionWithoutOptionChange("integrationOptions.templates." + name, this._templateManager._createTemplate(template))
                    },
                    _useTemplates: function() {
                        return true
                    }
                });
                DOMComponent.getInstance = function(element) {
                    return (0, _public_component.getInstanceByElement)((0, _renderer.default)(element), this)
                };
                DOMComponent.defaultOptions = function(rule) {
                    this._classCustomRules = this._classCustomRules || [];
                    this._classCustomRules.push(rule)
                };
                var _default = DOMComponent;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        6415:
            /*!*************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/element.js ***!
              \*************************************************************/
            function(__unused_webpack_module, exports) {
                exports.getPublicElement = function(element) {
                    return strategy(element)
                };
                exports.setPublicElementWrapper = function(newStrategy) {
                    strategy = newStrategy
                };
                var strategy = function(element) {
                    return element && element.get(0)
                }
            },
        97906:
            /*!******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/element_data.js ***!
              \******************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.afterCleanData = function(callback) {
                    afterCleanDataFunc = callback
                };
                exports.beforeCleanData = function(callback) {
                    beforeCleanDataFunc = callback
                };
                exports.cleanData = function(nodes) {
                    return strategy.cleanData.call(this, nodes)
                };
                exports.cleanDataRecursive = function(element, cleanSelf) {
                    if (!_dom_adapter.default.isElementNode(element)) {
                        return
                    }
                    var childElements = element.getElementsByTagName("*");
                    strategy.cleanData(childElements);
                    if (cleanSelf) {
                        strategy.cleanData([element])
                    }
                };
                exports.data = function() {
                    return strategy.data.apply(this, arguments)
                };
                exports.getDataStrategy = function() {
                    return strategy
                };
                exports.removeData = function(element, key) {
                    return strategy.removeData.call(this, element, key)
                };
                exports.strategyChanging = exports.setDataStrategy = void 0;
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ./dom_adapter */ 73349));
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../events/core/events_engine */ 55994));
                var _memorized_callbacks = _interopRequireDefault(__webpack_require__( /*! ./memorized_callbacks */ 83358));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var dataMap = new WeakMap;
                var strategy;
                var strategyChanging = new _memorized_callbacks.default;
                exports.strategyChanging = strategyChanging;
                var beforeCleanDataFunc = function() {};
                var afterCleanDataFunc = function() {};
                var setDataStrategy = function(value) {
                    strategyChanging.fire(value);
                    strategy = value;
                    var cleanData = strategy.cleanData;
                    strategy.cleanData = function(nodes) {
                        beforeCleanDataFunc(nodes);
                        var result = cleanData.call(this, nodes);
                        afterCleanDataFunc(nodes);
                        return result
                    }
                };
                exports.setDataStrategy = setDataStrategy;
                setDataStrategy({
                    data: function() {
                        var element = arguments[0];
                        var key = arguments[1];
                        var value = arguments[2];
                        if (!element) {
                            return
                        }
                        var elementData = dataMap.get(element);
                        if (!elementData) {
                            elementData = {};
                            dataMap.set(element, elementData)
                        }
                        if (void 0 === key) {
                            return elementData
                        }
                        if (2 === arguments.length) {
                            return elementData[key]
                        }
                        elementData[key] = value;
                        return value
                    },
                    removeData: function(element, key) {
                        if (!element) {
                            return
                        }
                        if (void 0 === key) {
                            dataMap.delete(element)
                        } else {
                            var elementData = dataMap.get(element);
                            if (elementData) {
                                delete elementData[key]
                            }
                        }
                    },
                    cleanData: function(elements) {
                        for (var i = 0; i < elements.length; i++) {
                            _events_engine.default.off(elements[i]);
                            dataMap.delete(elements[i])
                        }
                    }
                })
            },
        17381:
            /*!************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/errors.js ***!
              \************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _error = (obj = __webpack_require__( /*! ./utils/error */ 95640), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _default = (0, _error.default)({
                    E0001: "Method is not implemented",
                    E0002: "Member name collision: {0}",
                    E0003: "A class must be instantiated using the 'new' keyword",
                    E0004: "The NAME property of the component is not specified",
                    E0005: "Unknown device",
                    E0006: "Unknown endpoint key is requested",
                    E0007: "'Invalidate' method is called outside the update transaction",
                    E0008: "Type of the option name is not appropriate to create an action",
                    E0009: "Component '{0}' has not been initialized for an element",
                    E0010: "Animation configuration with the '{0}' type requires '{1}' configuration as {2}",
                    E0011: "Unknown animation type '{0}'",
                    E0012: "jQuery version is too old. Please upgrade jQuery to 1.10.0 or later",
                    E0013: "KnockoutJS version is too old. Please upgrade KnockoutJS to 2.3.0 or later",
                    E0014: "The 'release' method shouldn't be called for an unlocked Lock object",
                    E0015: "Queued task returned an unexpected result",
                    E0017: "Event namespace is not defined",
                    E0018: "DevExpress.ui.DevExpressPopup widget is required",
                    E0020: "Template engine '{0}' is not supported",
                    E0021: "Unknown theme is set: {0}",
                    E0022: "LINK[rel=DevExpress-theme] tags must go before DevExpress included scripts",
                    E0023: "Template name is not specified",
                    E0024: "DevExtreme bundle already included",
                    E0025: "Unexpected argument type",
                    E0100: "Unknown validation type is detected",
                    E0101: "Misconfigured range validation rule is detected",
                    E0102: "Misconfigured comparison validation rule is detected",
                    E0103: "validationCallback of an asynchronous rule should return a jQuery or a native promise",
                    E0110: "Unknown validation group is detected",
                    E0120: "Adapter for a DevExpressValidator component cannot be configured",
                    E0121: "The 'customItem' parameter of the 'onCustomItemCreating' function is empty or contains invalid data. Assign a custom object or a Promise that is resolved after the item is created.",
                    W0000: "'{0}' is deprecated in {1}. {2}",
                    W0001: "{0} - '{1}' option is deprecated in {2}. {3}",
                    W0002: "{0} - '{1}' method is deprecated in {2}. {3}",
                    W0003: "{0} - '{1}' property is deprecated in {2}. {3}",
                    W0004: "Timeout for theme loading is over: {0}",
                    W0005: "'{0}' event is deprecated in {1}. {2}",
                    W0006: "Invalid recurrence rule: '{0}'",
                    W0007: "'{0}' Globalize culture is not defined",
                    W0008: "Invalid view name: '{0}'",
                    W0009: "Invalid time zone name: '{0}'",
                    W0010: "{0} is deprecated in {1}. {2}",
                    W0011: "Number parsing is invoked while the parser is not defined",
                    W0012: "Date parsing is invoked while the parser is not defined",
                    W0013: "'{0}' file is deprecated in {1}. {2}",
                    W0014: "{0} - '{1}' type is deprecated in {2}. {3}",
                    W0015: "Instead of returning a value from the '{0}' function, write it into the '{1}' field of the function's parameter.",
                    W0016: 'The "{0}" option does not accept the "{1}" value since v{2}. {3}.',
                    W0017: 'Setting the "{0}" property with a function is deprecated since v21.2',
                    W0018: 'Setting the "position" property with a function is deprecated since v21.2'
                });
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        80566:
            /*!*********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/events_strategy.js ***!
              \*********************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.EventsStrategy = void 0;
                var _callbacks = (obj = __webpack_require__( /*! ./utils/callbacks */ 44504), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _iterator = __webpack_require__( /*! ./utils/iterator */ 95479);
                var _type = __webpack_require__( /*! ./utils/type */ 35922);
                var EventsStrategy = function() {
                    function EventsStrategy(owner) {
                        var options = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
                        this._events = {};
                        this._owner = owner;
                        this._options = options
                    }
                    EventsStrategy.create = function(owner, strategy) {
                        if (strategy) {
                            return (0, _type.isFunction)(strategy) ? strategy(owner) : strategy
                        } else {
                            return new EventsStrategy(owner)
                        }
                    };
                    var _proto = EventsStrategy.prototype;
                    _proto.hasEvent = function(eventName) {
                        var callbacks = this._events[eventName];
                        return callbacks ? callbacks.has() : false
                    };
                    _proto.fireEvent = function(eventName, eventArgs) {
                        var callbacks = this._events[eventName];
                        if (callbacks) {
                            callbacks.fireWith(this._owner, eventArgs)
                        }
                        return this._owner
                    };
                    _proto.on = function(eventName, eventHandler) {
                        var _this = this;
                        if ((0, _type.isPlainObject)(eventName)) {
                            (0, _iterator.each)(eventName, (function(e, h) {
                                _this.on(e, h)
                            }))
                        } else {
                            var callbacks = this._events[eventName];
                            if (!callbacks) {
                                callbacks = (0, _callbacks.default)({
                                    syncStrategy: this._options.syncStrategy
                                });
                                this._events[eventName] = callbacks
                            }
                            var addFn = callbacks.originalAdd || callbacks.add;
                            addFn.call(callbacks, eventHandler)
                        }
                    };
                    _proto.off = function(eventName, eventHandler) {
                        var callbacks = this._events[eventName];
                        if (callbacks) {
                            if ((0, _type.isFunction)(eventHandler)) {
                                callbacks.remove(eventHandler)
                            } else {
                                callbacks.empty()
                            }
                        }
                    };
                    _proto.dispose = function() {
                        (0, _iterator.each)(this._events, (function(eventName, event) {
                            event.empty()
                        }))
                    };
                    return EventsStrategy
                }();
                exports.EventsStrategy = EventsStrategy
            },
        73176:
            /*!**********************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/guid.js ***!
              \**********************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _class = (obj = __webpack_require__( /*! ./class */ 38377), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var Guid = _class.default.inherit({
                    ctor: function(value) {
                        if (value) {
                            value = String(value)
                        }
                        this._value = this._normalize(value || this._generate())
                    },
                    _normalize: function(value) {
                        value = value.replace(/[^a-f0-9]/gi, "").toLowerCase();
                        while (value.length < 32) {
                            value += "0"
                        }
                        return [value.substr(0, 8), value.substr(8, 4), value.substr(12, 4), value.substr(16, 4), value.substr(20, 12)].join("-")
                    },
                    _generate: function() {
                        var value = "";
                        for (var i = 0; i < 32; i++) {
                            value += Math.round(15 * Math.random()).toString(16)
                        }
                        return value
                    },
                    toString: function() {
                        return this._value
                    },
                    valueOf: function() {
                        return this._value
                    },
                    toJSON: function() {
                        return this._value
                    }
                });
                var _default = Guid;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        83448:
            /*!******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/http_request.js ***!
              \******************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _window = __webpack_require__( /*! ./utils/window */ 58201);
                var _dependency_injector = (obj = __webpack_require__( /*! ./utils/dependency_injector */ 20476), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var window = (0, _window.getWindow)();
                var nativeXMLHttpRequest = {
                    getXhr: function() {
                        return new window.XMLHttpRequest
                    }
                };
                var _default = (0, _dependency_injector.default)(nativeXMLHttpRequest);
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        15334:
            /*!**********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/inferno_renderer.js ***!
              \**********************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _inferno = __webpack_require__( /*! inferno */ 55285);
                var _inferno2 = __webpack_require__( /*! @devextreme/runtime/inferno */ 44105);
                var _infernoCreateElement = __webpack_require__( /*! inferno-create-element */ 87456);
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ./dom_adapter */ 73349));
                var _element_data = __webpack_require__( /*! ./element_data */ 97906);
                var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ./utils/dependency_injector */ 20476));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var remove = function(element) {
                    var parentNode = element.parentNode;
                    if (parentNode) {
                        (0, _element_data.cleanDataRecursive)(element);
                        parentNode.$V = element.$V;
                        (0, _inferno.render)(null, parentNode);
                        parentNode.appendChild(element);
                        element.innerHTML = "";
                        delete parentNode.$V
                    }
                    delete element.$V
                };
                var _default = (0, _dependency_injector.default)({
                    createElement: function(component, props) {
                        return (0, _infernoCreateElement.createElement)(component, props)
                    },
                    remove: remove,
                    onAfterRender: function() {
                        _inferno2.InfernoEffectHost.callEffects()
                    },
                    onPreRender: function() {
                        _inferno2.InfernoEffectHost.lock()
                    },
                    render: function(component, props, container, replace) {
                        if (!replace) {
                            var parentNode = container.parentNode;
                            var nextNode = null === container || void 0 === container ? void 0 : container.nextSibling;
                            var rootNode = _dom_adapter.default.createElement("div");
                            rootNode.appendChild(container);
                            var mountNode = _dom_adapter.default.createDocumentFragment().appendChild(rootNode);
                            var vNodeAlreadyExists = !!container.$V;
                            vNodeAlreadyExists && remove(container);
                            (0, _inferno2.hydrate)((0, _infernoCreateElement.createElement)(component, props), mountNode);
                            container.$V = mountNode.$V;
                            if (parentNode) {
                                parentNode.insertBefore(container, nextNode)
                            }
                        } else {
                            (0, _inferno.render)((0, _infernoCreateElement.createElement)(component, props), container)
                        }
                    }
                });
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        83358:
            /*!*************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/memorized_callbacks.js ***!
              \*************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 95479);
                var _callbacks = (obj = __webpack_require__( /*! ./utils/callbacks */ 44504), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var MemorizedCallbacks = function() {
                    function MemorizedCallbacks() {
                        this.memory = [];
                        this.callbacks = (0, _callbacks.default)()
                    }
                    var _proto = MemorizedCallbacks.prototype;
                    _proto.add = function(fn) {
                        (0, _iterator.each)(this.memory, (function(_, item) {
                            return fn.apply(fn, item)
                        }));
                        this.callbacks.add(fn)
                    };
                    _proto.remove = function(fn) {
                        this.callbacks.remove(fn)
                    };
                    _proto.fire = function() {
                        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                            args[_key] = arguments[_key]
                        }
                        this.memory.push(args);
                        this.callbacks.fire.apply(this.callbacks, args)
                    };
                    return MemorizedCallbacks
                }();
                exports.default = MemorizedCallbacks;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        95683:
            /*!*******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/options/index.js ***!
              \*******************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.Options = void 0;
                var _type = __webpack_require__( /*! ../utils/type */ 35922);
                var _common = __webpack_require__( /*! ../utils/common */ 20576);
                var _option_manager = __webpack_require__( /*! ./option_manager */ 9030);
                var _data = __webpack_require__( /*! ../utils/data */ 47617);
                var _utils = __webpack_require__( /*! ./utils */ 45434);
                var _extend = __webpack_require__( /*! ../utils/extend */ 13306);

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }

                function _defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) {
                            descriptor.writable = true
                        }
                        Object.defineProperty(target, descriptor.key, descriptor)
                    }
                }
                var Options = function() {
                    function Options(options, defaultOptions, optionsByReference, deprecatedOptions) {
                        var _this = this;
                        this._deprecatedCallback;
                        this._startChangeCallback;
                        this._endChangeCallback;
                        this._default = defaultOptions;
                        this._deprecated = deprecatedOptions;
                        this._deprecatedNames = [];
                        this._initDeprecatedNames();
                        this._optionManager = new _option_manager.OptionManager(options, optionsByReference);
                        this._optionManager.onRelevantNamesPrepared((function(options, name, value, silent) {
                            return _this._setRelevantNames(options, name, value, silent)
                        }));
                        this._cachedOptions = {};
                        this._rules = []
                    }
                    var _proto = Options.prototype;
                    _proto._initDeprecatedNames = function() {
                        for (var optionName in this._deprecated) {
                            this._deprecatedNames.push(optionName)
                        }
                    };
                    _proto._getByRules = function(rules) {
                        rules = Array.isArray(rules) ? this._rules.concat(rules) : this._rules;
                        return (0, _utils.convertRulesToOptions)(rules)
                    };
                    _proto._notifyDeprecated = function(option) {
                        var info = this._deprecated[option];
                        if (info) {
                            this._deprecatedCallback(option, info)
                        }
                    };
                    _proto._setRelevantNames = function(options, name, value, silent) {
                        if (name) {
                            var normalizedName = this._normalizeName(name, silent);
                            if (normalizedName && normalizedName !== name) {
                                this._setField(options, normalizedName, value);
                                this._clearField(options, name)
                            }
                        }
                    };
                    _proto._setField = function(options, fullName, value) {
                        var fieldName = "";
                        var fieldObject = null;
                        do {
                            fieldName = fieldName ? ".".concat(fieldName) : "";
                            fieldName = (0, _utils.getFieldName)(fullName) + fieldName;
                            fullName = (0, _utils.getParentName)(fullName);
                            fieldObject = fullName ? this._optionManager.get(options, fullName, false) : options
                        } while (!fieldObject);
                        fieldObject[fieldName] = value
                    };
                    _proto._clearField = function(options, name) {
                        delete options[name];
                        var previousFieldName = (0, _utils.getParentName)(name);
                        var fieldObject = previousFieldName ? this._optionManager.get(options, previousFieldName, false) : options;
                        if (fieldObject) {
                            delete fieldObject[(0, _utils.getFieldName)(name)]
                        }
                    };
                    _proto._normalizeName = function(name, silent) {
                        if (this._deprecatedNames.length && name) {
                            for (var i = 0; i < this._deprecatedNames.length; i++) {
                                if (this._deprecatedNames[i] === name) {
                                    var deprecate = this._deprecated[name];
                                    if (deprecate) {
                                        !silent && this._notifyDeprecated(name);
                                        return deprecate.alias || name
                                    }
                                }
                            }
                        }
                        return name
                    };
                    _proto.addRules = function(rules) {
                        this._rules = rules.concat(this._rules)
                    };
                    _proto.applyRules = function(rules) {
                        var options = this._getByRules(rules);
                        this.silent(options)
                    };
                    _proto.dispose = function() {
                        this._deprecatedCallback = _common.noop;
                        this._startChangeCallback = _common.noop;
                        this._endChangeCallback = _common.noop;
                        this._optionManager.dispose()
                    };
                    _proto.onChanging = function(callBack) {
                        this._optionManager.onChanging(callBack)
                    };
                    _proto.onChanged = function(callBack) {
                        this._optionManager.onChanged(callBack)
                    };
                    _proto.onDeprecated = function(callBack) {
                        this._deprecatedCallback = callBack
                    };
                    _proto.onStartChange = function(callBack) {
                        this._startChangeCallback = callBack
                    };
                    _proto.onEndChange = function(callBack) {
                        this._endChangeCallback = callBack
                    };
                    _proto.isInitial = function(name) {
                        var value = this.silent(name);
                        var initialValue = this.initial(name);
                        var areFunctions = (0, _type.isFunction)(value) && (0, _type.isFunction)(initialValue);
                        return areFunctions ? value.toString() === initialValue.toString() : (0, _common.equalByValue)(value, initialValue)
                    };
                    _proto.initial = function(name) {
                        return (0, _utils.getNestedOptionValue)(this._initial, name)
                    };
                    _proto.option = function(options, value) {
                        var isGetter = arguments.length < 2 && "object" !== (0, _type.type)(options);
                        if (isGetter) {
                            return this._optionManager.get(void 0, this._normalizeName(options))
                        } else {
                            this._startChangeCallback();
                            try {
                                this._optionManager.set(options, value)
                            } finally {
                                this._endChangeCallback()
                            }
                        }
                    };
                    _proto.silent = function(options, value) {
                        var isGetter = arguments.length < 2 && "object" !== (0, _type.type)(options);
                        if (isGetter) {
                            return this._optionManager.get(void 0, options, void 0, true)
                        } else {
                            this._optionManager.set(options, value, void 0, true)
                        }
                    };
                    _proto.reset = function(name) {
                        var _this2 = this;
                        if (name) {
                            var fullPath = (0, _data.getPathParts)(name);
                            var value = fullPath.reduce((function(value, field) {
                                return value ? value[field] : _this2.initial(field)
                            }), null);
                            var defaultValue = (0, _type.isObject)(value) ? _extends({}, value) : value;
                            this._optionManager.set(name, defaultValue, false)
                        }
                    };
                    _proto.getAliasesByName = function(name) {
                        var _this3 = this;
                        return Object.keys(this._deprecated).filter((function(aliasName) {
                            return name === _this3._deprecated[aliasName].alias
                        }))
                    };
                    _proto.isDeprecated = function(name) {
                        return Object.prototype.hasOwnProperty.call(this._deprecated, name)
                    };
                    _proto.cache = function(name, options) {
                        var isGetter = arguments.length < 2;
                        if (isGetter) {
                            return this._cachedOptions[name]
                        } else {
                            this._cachedOptions[name] = (0, _extend.extend)(this._cachedOptions[name], options)
                        }
                    };
                    ! function(Constructor, protoProps, staticProps) {
                        if (protoProps) {
                            _defineProperties(Constructor.prototype, protoProps)
                        }
                        if (staticProps) {
                            _defineProperties(Constructor, staticProps)
                        }
                        Object.defineProperty(Constructor, "prototype", {
                            writable: false
                        });
                        return Constructor
                    }(Options, [{
                        key: "_initial",
                        get: function() {
                            if (!this._initialOptions) {
                                var rulesOptions = this._getByRules(this.silent("defaultOptionsRules"));
                                this._initialOptions = this._default;
                                this._optionManager._setByReference(this._initialOptions, rulesOptions)
                            }
                            return this._initialOptions
                        },
                        set: function(value) {
                            this._initialOptions = value
                        }
                    }]);
                    return Options
                }();
                exports.Options = Options
            },
        9030:
            /*!****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/options/option_manager.js ***!
              \****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.OptionManager = void 0;
                var _data = __webpack_require__( /*! ../utils/data */ 47617);
                var _common = __webpack_require__( /*! ../utils/common */ 20576);
                var _comparator = __webpack_require__( /*! ../utils/comparator */ 49036);
                var _extend = __webpack_require__( /*! ../utils/extend */ 13306);
                var _type = __webpack_require__( /*! ../utils/type */ 35922);
                var _utils = __webpack_require__( /*! ./utils */ 45434);
                var cachedGetters = {};
                var cachedSetters = {};
                var OptionManager = function() {
                    function OptionManager(options, optionsByReference) {
                        this._options = options;
                        this._optionsByReference = optionsByReference;
                        this._changingCallback;
                        this._changedCallback;
                        this._namePreparedCallbacks
                    }
                    var _proto = OptionManager.prototype;
                    _proto._setByReference = function(options, rulesOptions) {
                        (0, _extend.extend)(true, options, rulesOptions);
                        for (var fieldName in this._optionsByReference) {
                            if (Object.prototype.hasOwnProperty.call(rulesOptions, fieldName)) {
                                options[fieldName] = rulesOptions[fieldName]
                            }
                        }
                    };
                    _proto._setPreparedValue = function(name, value, merge, silent) {
                        var previousValue = this.get(this._options, name, false);
                        if (!(0, _comparator.equals)(previousValue, value)) {
                            var path = (0, _data.getPathParts)(name);
                            !silent && this._changingCallback(name, previousValue, value);
                            cachedSetters[name] = cachedSetters[name] || (0, _data.compileSetter)(name);
                            cachedSetters[name](this._options, value, {
                                functionsAsIs: true,
                                merge: (0, _type.isDefined)(merge) ? merge : !this._optionsByReference[name],
                                unwrapObservables: path.length > 1 && !!this._optionsByReference[path[0]]
                            });
                            !silent && this._changedCallback(name, value, previousValue)
                        }
                    };
                    _proto._prepareRelevantNames = function(options, name, value, silent) {
                        if ((0, _type.isPlainObject)(value)) {
                            for (var valueName in value) {
                                this._prepareRelevantNames(options, "".concat(name, ".").concat(valueName), value[valueName])
                            }
                        }
                        this._namePreparedCallbacks(options, name, value, silent)
                    };
                    _proto.get = function() {
                        var options = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : this._options;
                        var name = arguments.length > 1 ? arguments[1] : void 0;
                        var unwrapObservables = arguments.length > 2 ? arguments[2] : void 0;
                        cachedGetters[name] = cachedGetters[name] || (0, _data.compileGetter)(name);
                        return cachedGetters[name](options, {
                            functionsAsIs: true,
                            unwrapObservables: unwrapObservables
                        })
                    };
                    _proto.set = function(options, value, merge, silent) {
                        options = (0, _utils.normalizeOptions)(options, value);
                        for (var name in options) {
                            this._prepareRelevantNames(options, name, options[name], silent)
                        }
                        for (var _name in options) {
                            this._setPreparedValue(_name, options[_name], merge, silent)
                        }
                    };
                    _proto.onRelevantNamesPrepared = function(callBack) {
                        this._namePreparedCallbacks = callBack
                    };
                    _proto.onChanging = function(callBack) {
                        this._changingCallback = callBack
                    };
                    _proto.onChanged = function(callBack) {
                        this._changedCallback = callBack
                    };
                    _proto.dispose = function() {
                        this._changingCallback = _common.noop;
                        this._changedCallback = _common.noop
                    };
                    return OptionManager
                }();
                exports.OptionManager = OptionManager
            },
        45434:
            /*!*******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/options/utils.js ***!
              \*******************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.normalizeOptions = exports.getParentName = exports.getNestedOptionValue = exports.getFieldName = exports.deviceMatch = exports.createDefaultOptionRules = exports.convertRulesToOptions = void 0;
                var _devices = (obj = __webpack_require__( /*! ../devices */ 20530), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _type = __webpack_require__( /*! ../utils/type */ 35922);
                var _common = __webpack_require__( /*! ../utils/common */ 20576);
                var _extend = __webpack_require__( /*! ../utils/extend */ 13306);
                var _data = __webpack_require__( /*! ../utils/data */ 47617);
                var cachedGetters = {};
                exports.convertRulesToOptions = function(rules) {
                    var currentDevice = _devices.default.current();
                    return rules.reduce((function(options, _ref) {
                        var device = _ref.device,
                            ruleOptions = _ref.options;
                        var deviceFilter = device || {};
                        var match = (0, _type.isFunction)(deviceFilter) ? deviceFilter(currentDevice) : deviceMatch(currentDevice, deviceFilter);
                        if (match) {
                            (0, _extend.extend)(true, options, ruleOptions)
                        }
                        return options
                    }), {})
                };
                exports.normalizeOptions = function(options, value) {
                    return "string" !== typeof options ? options : function(obj, key, value) {
                        if (key in obj) {
                            Object.defineProperty(obj, key, {
                                value: value,
                                enumerable: true,
                                configurable: true,
                                writable: true
                            })
                        } else {
                            obj[key] = value
                        }
                        return obj
                    }({}, options, value)
                };
                var deviceMatch = function(device, filter) {
                    return (0, _type.isEmptyObject)(filter) || (0, _common.findBestMatches)(device, [filter]).length > 0
                };
                exports.deviceMatch = deviceMatch;
                exports.getFieldName = function(fullName) {
                    return fullName.substr(fullName.lastIndexOf(".") + 1)
                };
                exports.getParentName = function(fullName) {
                    return fullName.substr(0, fullName.lastIndexOf("."))
                };
                exports.getNestedOptionValue = function(optionsObject, name) {
                    cachedGetters[name] = cachedGetters[name] || (0, _data.compileGetter)(name);
                    return cachedGetters[name](optionsObject, {
                        functionsAsIs: true
                    })
                };
                exports.createDefaultOptionRules = function() {
                    var options = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : [];
                    return options
                }
            },
        90889:
            /*!**************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/postponed_operations.js ***!
              \**************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.PostponedOperations = void 0;
                var _deferred = __webpack_require__( /*! ./utils/deferred */ 62754);
                var _type = __webpack_require__( /*! ./utils/type */ 35922);

                function _toConsumableArray(arr) {
                    return function(arr) {
                        if (Array.isArray(arr)) {
                            return _arrayLikeToArray(arr)
                        }
                    }(arr) || function(iter) {
                        if ("undefined" !== typeof Symbol && null != iter[Symbol.iterator] || null != iter["@@iterator"]) {
                            return Array.from(iter)
                        }
                    }(arr) || function(o, minLen) {
                        if (!o) {
                            return
                        }
                        if ("string" === typeof o) {
                            return _arrayLikeToArray(o, minLen)
                        }
                        var n = Object.prototype.toString.call(o).slice(8, -1);
                        if ("Object" === n && o.constructor) {
                            n = o.constructor.name
                        }
                        if ("Map" === n || "Set" === n) {
                            return Array.from(o)
                        }
                        if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                            return _arrayLikeToArray(o, minLen)
                        }
                    }(arr) || function() {
                        throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                    }()
                }

                function _arrayLikeToArray(arr, len) {
                    if (null == len || len > arr.length) {
                        len = arr.length
                    }
                    for (var i = 0, arr2 = new Array(len); i < len; i++) {
                        arr2[i] = arr[i]
                    }
                    return arr2
                }
                var PostponedOperations = function() {
                    function PostponedOperations() {
                        this._postponedOperations = {}
                    }
                    var _proto = PostponedOperations.prototype;
                    _proto.add = function(key, fn, postponedPromise) {
                        if (key in this._postponedOperations) {
                            postponedPromise && this._postponedOperations[key].promises.push(postponedPromise)
                        } else {
                            var completePromise = new _deferred.Deferred;
                            this._postponedOperations[key] = {
                                fn: fn,
                                completePromise: completePromise,
                                promises: postponedPromise ? [postponedPromise] : []
                            }
                        }
                        return this._postponedOperations[key].completePromise.promise()
                    };
                    _proto.callPostponedOperations = function() {
                        for (var key in this._postponedOperations) {
                            var operation = this._postponedOperations[key];
                            if ((0, _type.isDefined)(operation)) {
                                if (operation.promises && operation.promises.length) {
                                    _deferred.when.apply(void 0, _toConsumableArray(operation.promises)).done(operation.fn).then(operation.completePromise.resolve)
                                } else {
                                    operation.fn().done(operation.completePromise.resolve)
                                }
                            }
                        }
                        this._postponedOperations = {}
                    };
                    return PostponedOperations
                }();
                exports.PostponedOperations = PostponedOperations
            },
        68374:
            /*!**************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/renderer.js ***!
              \**************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _renderer_base = (obj = __webpack_require__( /*! ./renderer_base */ 82981), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _default = _renderer_base.default.get();
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        82981:
            /*!*******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/renderer_base.js ***!
              \*******************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _element_data = __webpack_require__( /*! ./element_data */ 97906);
                var _dom_adapter = (obj = __webpack_require__( /*! ./dom_adapter */ 73349), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _window = __webpack_require__( /*! ./utils/window */ 58201);
                var _type = __webpack_require__( /*! ./utils/type */ 35922);
                var _style = __webpack_require__( /*! ./utils/style */ 80968);
                var _size = __webpack_require__( /*! ./utils/size */ 58664);
                var _html_parser = __webpack_require__( /*! ./utils/html_parser */ 61371);
                var window = (0, _window.getWindow)();
                var renderer;
                var initRender = function(selector, context) {
                    if (!selector) {
                        this.length = 0;
                        return this
                    }
                    if ("string" === typeof selector) {
                        if ("body" === selector) {
                            this[0] = context ? context.body : _dom_adapter.default.getBody();
                            this.length = 1;
                            return this
                        }
                        context = context || _dom_adapter.default.getDocument();
                        if ("<" === selector[0]) {
                            this[0] = _dom_adapter.default.createElement(selector.slice(1, -1), context);
                            this.length = 1;
                            return this
                        } [].push.apply(this, _dom_adapter.default.querySelectorAll(context, selector));
                        return this
                    } else if (_dom_adapter.default.isNode(selector) || (0, _type.isWindow)(selector)) {
                        this[0] = selector;
                        this.length = 1;
                        return this
                    } else if (Array.isArray(selector)) {
                        [].push.apply(this, selector);
                        return this
                    }
                    return renderer(selector.toArray ? selector.toArray() : [selector])
                };
                renderer = function(selector, context) {
                    return new initRender(selector, context)
                };
                renderer.fn = {
                    dxRenderer: true
                };
                initRender.prototype = renderer.fn;
                var repeatMethod = function(methodName, args) {
                    for (var i = 0; i < this.length; i++) {
                        var item = renderer(this[i]);
                        item[methodName].apply(item, args)
                    }
                    return this
                };
                var setAttributeValue = function(element, attrName, value) {
                    if (void 0 !== value && null !== value) {
                        _dom_adapter.default.setAttribute(element, attrName, value)
                    } else {
                        _dom_adapter.default.removeAttribute(element, attrName)
                    }
                };
                initRender.prototype.show = function() {
                    return this.toggle(true)
                };
                initRender.prototype.hide = function() {
                    return this.toggle(false)
                };
                initRender.prototype.toggle = function(value) {
                    if (this[0]) {
                        this.toggleClass("dx-state-invisible", !value)
                    }
                    return this
                };
                initRender.prototype.attr = function(attrName, value) {
                    if (this.length > 1 && arguments.length > 1) {
                        return repeatMethod.call(this, "attr", arguments)
                    }
                    if (!this[0]) {
                        if ((0, _type.isObject)(attrName) || void 0 !== value) {
                            return this
                        } else {
                            return
                        }
                    }
                    if (!this[0].getAttribute) {
                        return this.prop(attrName, value)
                    }
                    if ("string" === typeof attrName && 1 === arguments.length) {
                        var result = this[0].getAttribute(attrName);
                        return null == result ? void 0 : result
                    } else if ((0, _type.isPlainObject)(attrName)) {
                        for (var key in attrName) {
                            this.attr(key, attrName[key])
                        }
                    } else {
                        setAttributeValue(this[0], attrName, value)
                    }
                    return this
                };
                initRender.prototype.removeAttr = function(attrName) {
                    this[0] && _dom_adapter.default.removeAttribute(this[0], attrName);
                    return this
                };
                initRender.prototype.prop = function(propName, value) {
                    if (!this[0]) {
                        return this
                    }
                    if ("string" === typeof propName && 1 === arguments.length) {
                        return this[0][propName]
                    } else if ((0, _type.isPlainObject)(propName)) {
                        for (var key in propName) {
                            this.prop(key, propName[key])
                        }
                    } else {
                        _dom_adapter.default.setProperty(this[0], propName, value)
                    }
                    return this
                };
                initRender.prototype.addClass = function(className) {
                    return this.toggleClass(className, true)
                };
                initRender.prototype.removeClass = function(className) {
                    return this.toggleClass(className, false)
                };
                initRender.prototype.hasClass = function(className) {
                    if (!this[0] || void 0 === this[0].className) {
                        return false
                    }
                    var classNames = className.split(" ");
                    for (var i = 0; i < classNames.length; i++) {
                        if (this[0].classList) {
                            if (this[0].classList.contains(classNames[i])) {
                                return true
                            }
                        } else {
                            var _className = (0, _type.isString)(this[0].className) ? this[0].className : _dom_adapter.default.getAttribute(this[0], "class");
                            if ((_className || "").split(" ").indexOf(classNames[i]) >= 0) {
                                return true
                            }
                        }
                    }
                    return false
                };
                initRender.prototype.toggleClass = function(className, value) {
                    if (this.length > 1) {
                        return repeatMethod.call(this, "toggleClass", arguments)
                    }
                    if (!this[0] || !className) {
                        return this
                    }
                    value = void 0 === value ? !this.hasClass(className) : value;
                    var classNames = className.split(" ");
                    for (var i = 0; i < classNames.length; i++) {
                        _dom_adapter.default.setClass(this[0], classNames[i], value)
                    }
                    return this
                };
                initRender.prototype.html = function(value) {
                    if (!arguments.length) {
                        return this[0].innerHTML
                    }
                    this.empty();
                    if ("string" === typeof value && !(0, _html_parser.isTablePart)(value) || "number" === typeof value) {
                        this[0].innerHTML = value;
                        return this
                    }
                    return this.append((0, _html_parser.parseHTML)(value))
                };
                var appendElements = function(element, nextSibling) {
                    if (!this[0] || !element) {
                        return
                    }
                    if ("string" === typeof element) {
                        element = (0, _html_parser.parseHTML)(element)
                    } else if (element.nodeType) {
                        element = [element]
                    } else if ((0, _type.isNumeric)(element)) {
                        element = [_dom_adapter.default.createTextNode(element)]
                    }
                    for (var i = 0; i < element.length; i++) {
                        var item = element[i];
                        var container = this[0];
                        var wrapTR = "TABLE" === container.tagName && "TR" === item.tagName;
                        if (wrapTR && container.tBodies && container.tBodies.length) {
                            container = container.tBodies[0]
                        }
                        _dom_adapter.default.insertElement(container, item.nodeType ? item : item[0], nextSibling)
                    }
                };
                var setCss = function(name, value) {
                    if (!this[0] || !this[0].style) {
                        return
                    }
                    if (null === value || "number" === typeof value && isNaN(value)) {
                        return
                    }
                    name = (0, _style.styleProp)(name);
                    for (var i = 0; i < this.length; i++) {
                        this[i].style[name] = (0, _style.normalizeStyleProp)(name, value)
                    }
                };
                initRender.prototype.css = function(name, value) {
                    if ((0, _type.isString)(name)) {
                        if (2 === arguments.length) {
                            setCss.call(this, name, value)
                        } else {
                            if (!this[0]) {
                                return
                            }
                            name = (0, _style.styleProp)(name);
                            var result = window.getComputedStyle(this[0])[name] || this[0].style[name];
                            return (0, _type.isNumeric)(result) ? result.toString() : result
                        }
                    } else if ((0, _type.isPlainObject)(name)) {
                        for (var key in name) {
                            setCss.call(this, key, name[key])
                        }
                    }
                    return this
                };
                initRender.prototype.prepend = function(element) {
                    if (arguments.length > 1) {
                        for (var i = 0; i < arguments.length; i++) {
                            this.prepend(arguments[i])
                        }
                        return this
                    }
                    appendElements.apply(this, [element, this[0].firstChild]);
                    return this
                };
                initRender.prototype.append = function(element) {
                    if (arguments.length > 1) {
                        for (var i = 0; i < arguments.length; i++) {
                            this.append(arguments[i])
                        }
                        return this
                    }
                    appendElements.apply(this, [element]);
                    return this
                };
                initRender.prototype.prependTo = function(element) {
                    if (this.length > 1) {
                        for (var i = this.length - 1; i >= 0; i--) {
                            renderer(this[i]).prependTo(element)
                        }
                        return this
                    }
                    element = renderer(element);
                    if (element[0]) {
                        _dom_adapter.default.insertElement(element[0], this[0], element[0].firstChild)
                    }
                    return this
                };
                initRender.prototype.appendTo = function(element) {
                    if (this.length > 1) {
                        return repeatMethod.call(this, "appendTo", arguments)
                    }
                    _dom_adapter.default.insertElement(renderer(element)[0], this[0]);
                    return this
                };
                initRender.prototype.insertBefore = function(element) {
                    if (element && element[0]) {
                        _dom_adapter.default.insertElement(element[0].parentNode, this[0], element[0])
                    }
                    return this
                };
                initRender.prototype.insertAfter = function(element) {
                    if (element && element[0]) {
                        _dom_adapter.default.insertElement(element[0].parentNode, this[0], element[0].nextSibling)
                    }
                    return this
                };
                initRender.prototype.before = function(element) {
                    if (this[0]) {
                        _dom_adapter.default.insertElement(this[0].parentNode, element[0], this[0])
                    }
                    return this
                };
                initRender.prototype.after = function(element) {
                    if (this[0]) {
                        _dom_adapter.default.insertElement(this[0].parentNode, element[0], this[0].nextSibling)
                    }
                    return this
                };
                initRender.prototype.wrap = function(wrapper) {
                    if (this[0]) {
                        var wrap = renderer(wrapper);
                        wrap.insertBefore(this);
                        wrap.append(this)
                    }
                    return this
                };
                initRender.prototype.wrapInner = function(wrapper) {
                    var contents = this.contents();
                    if (contents.length) {
                        contents.wrap(wrapper)
                    } else {
                        this.append(wrapper)
                    }
                    return this
                };
                initRender.prototype.replaceWith = function(element) {
                    if (!(element && element[0])) {
                        return
                    }
                    if (element.is(this)) {
                        return this
                    }
                    element.insertBefore(this);
                    this.remove();
                    return element
                };
                initRender.prototype.remove = function() {
                    if (this.length > 1) {
                        return repeatMethod.call(this, "remove", arguments)
                    }(0, _element_data.cleanDataRecursive)(this[0], true);
                    _dom_adapter.default.removeElement(this[0]);
                    return this
                };
                initRender.prototype.detach = function() {
                    if (this.length > 1) {
                        return repeatMethod.call(this, "detach", arguments)
                    }
                    _dom_adapter.default.removeElement(this[0]);
                    return this
                };
                initRender.prototype.empty = function() {
                    if (this.length > 1) {
                        return repeatMethod.call(this, "empty", arguments)
                    }(0, _element_data.cleanDataRecursive)(this[0]);
                    _dom_adapter.default.setText(this[0], "");
                    return this
                };
                initRender.prototype.clone = function() {
                    var result = [];
                    for (var i = 0; i < this.length; i++) {
                        result.push(this[i].cloneNode(true))
                    }
                    return renderer(result)
                };
                initRender.prototype.text = function(value) {
                    if (!arguments.length) {
                        var result = "";
                        for (var i = 0; i < this.length; i++) {
                            result += this[i] && this[i].textContent || ""
                        }
                        return result
                    }
                    var text = (0, _type.isFunction)(value) ? value() : value;
                    (0, _element_data.cleanDataRecursive)(this[0], false);
                    _dom_adapter.default.setText(this[0], (0, _type.isDefined)(text) ? text : "");
                    return this
                };
                initRender.prototype.val = function(value) {
                    if (1 === arguments.length) {
                        return this.prop("value", (0, _type.isDefined)(value) ? value : "")
                    }
                    return this.prop("value")
                };
                initRender.prototype.contents = function() {
                    if (!this[0]) {
                        return renderer()
                    }
                    var result = [];
                    result.push.apply(result, this[0].childNodes);
                    return renderer(result)
                };
                initRender.prototype.find = function(selector) {
                    var result = renderer();
                    if (!selector) {
                        return result
                    }
                    var nodes = [];
                    var i;
                    if ("string" === typeof selector) {
                        selector = selector.trim();
                        for (i = 0; i < this.length; i++) {
                            var element = this[i];
                            if (_dom_adapter.default.isElementNode(element)) {
                                var elementId = element.getAttribute("id");
                                var queryId = elementId || "dx-query-children";
                                if (!elementId) {
                                    setAttributeValue(element, "id", queryId)
                                }
                                queryId = "[id='" + queryId + "'] ";
                                var querySelector = queryId + selector.replace(/([^\\])(,)/g, "$1, " + queryId);
                                nodes.push.apply(nodes, _dom_adapter.default.querySelectorAll(element, querySelector));
                                setAttributeValue(element, "id", elementId)
                            } else if (_dom_adapter.default.isDocument(element)) {
                                nodes.push.apply(nodes, _dom_adapter.default.querySelectorAll(element, selector))
                            }
                        }
                    } else {
                        for (i = 0; i < this.length; i++) {
                            selector = _dom_adapter.default.isNode(selector) ? selector : selector[0];
                            if (this[i] !== selector && this[i].contains(selector)) {
                                nodes.push(selector)
                            }
                        }
                    }
                    return result.add(nodes)
                };
                var isVisible = function(_, element) {
                    var _element$host;
                    element = null !== (_element$host = element.host) && void 0 !== _element$host ? _element$host : element;
                    if (!element.nodeType) {
                        return true
                    }
                    return !!(element.offsetWidth || element.offsetHeight || element.getClientRects().length)
                };
                initRender.prototype.filter = function(selector) {
                    if (!selector) {
                        return renderer()
                    }
                    if (":visible" === selector) {
                        return this.filter(isVisible)
                    } else if (":hidden" === selector) {
                        return this.filter((function(_, element) {
                            return !isVisible(0, element)
                        }))
                    }
                    var result = [];
                    for (var i = 0; i < this.length; i++) {
                        var item = this[i];
                        if (_dom_adapter.default.isElementNode(item) && "string" === (0, _type.type)(selector)) {
                            _dom_adapter.default.elementMatches(item, selector) && result.push(item)
                        } else if (_dom_adapter.default.isNode(selector) || (0, _type.isWindow)(selector)) {
                            selector === item && result.push(item)
                        } else if ((0, _type.isFunction)(selector)) {
                            selector.call(item, i, item) && result.push(item)
                        } else {
                            for (var j = 0; j < selector.length; j++) {
                                selector[j] === item && result.push(item)
                            }
                        }
                    }
                    return renderer(result)
                };
                initRender.prototype.not = function(selector) {
                    var result = [];
                    var nodes = this.filter(selector).toArray();
                    for (var i = 0; i < this.length; i++) {
                        if (-1 === nodes.indexOf(this[i])) {
                            result.push(this[i])
                        }
                    }
                    return renderer(result)
                };
                initRender.prototype.is = function(selector) {
                    return !!this.filter(selector).length
                };
                initRender.prototype.children = function(selector) {
                    var result = [];
                    for (var i = 0; i < this.length; i++) {
                        var nodes = this[i] ? this[i].childNodes : [];
                        for (var j = 0; j < nodes.length; j++) {
                            if (_dom_adapter.default.isElementNode(nodes[j])) {
                                result.push(nodes[j])
                            }
                        }
                    }
                    result = renderer(result);
                    return selector ? result.filter(selector) : result
                };
                initRender.prototype.siblings = function() {
                    var element = this[0];
                    if (!element || !element.parentNode) {
                        return renderer()
                    }
                    var result = [];
                    var parentChildNodes = element.parentNode.childNodes || [];
                    for (var i = 0; i < parentChildNodes.length; i++) {
                        var node = parentChildNodes[i];
                        if (_dom_adapter.default.isElementNode(node) && node !== element) {
                            result.push(node)
                        }
                    }
                    return renderer(result)
                };
                initRender.prototype.each = function(callback) {
                    for (var i = 0; i < this.length; i++) {
                        if (false === callback.call(this[i], i, this[i])) {
                            break
                        }
                    }
                };
                initRender.prototype.index = function(element) {
                    if (!element) {
                        return this.parent().children().index(this)
                    }
                    element = renderer(element);
                    return this.toArray().indexOf(element[0])
                };
                initRender.prototype.get = function(index) {
                    return this[index < 0 ? this.length + index : index]
                };
                initRender.prototype.eq = function(index) {
                    index = index < 0 ? this.length + index : index;
                    return renderer(this[index])
                };
                initRender.prototype.first = function() {
                    return this.eq(0)
                };
                initRender.prototype.last = function() {
                    return this.eq(-1)
                };
                initRender.prototype.parent = function(selector) {
                    if (!this[0]) {
                        return renderer()
                    }
                    var result = renderer(this[0].parentNode);
                    return !selector || result.is(selector) ? result : renderer()
                };
                initRender.prototype.parents = function(selector) {
                    var result = [];
                    var parent = this.parent();
                    while (parent && parent[0] && !_dom_adapter.default.isDocument(parent[0])) {
                        if (_dom_adapter.default.isElementNode(parent[0])) {
                            if (!selector || parent.is(selector)) {
                                result.push(parent.get(0))
                            }
                        }
                        parent = parent.parent()
                    }
                    return renderer(result)
                };
                initRender.prototype.closest = function(selector) {
                    if (this.is(selector)) {
                        return this
                    }
                    var parent = this.parent();
                    while (parent && parent.length) {
                        if (parent.is(selector)) {
                            return parent
                        }
                        parent = parent.parent()
                    }
                    return renderer()
                };
                initRender.prototype.next = function(selector) {
                    if (!this[0]) {
                        return renderer()
                    }
                    var next = renderer(this[0].nextSibling);
                    if (!arguments.length) {
                        return next
                    }
                    while (next && next.length) {
                        if (next.is(selector)) {
                            return next
                        }
                        next = next.next()
                    }
                    return renderer()
                };
                initRender.prototype.prev = function() {
                    if (!this[0]) {
                        return renderer()
                    }
                    return renderer(this[0].previousSibling)
                };
                initRender.prototype.add = function(selector) {
                    var targets = renderer(selector);
                    var result = this.toArray();
                    for (var i = 0; i < targets.length; i++) {
                        var target = targets[i];
                        if (-1 === result.indexOf(target)) {
                            result.push(target)
                        }
                    }
                    return renderer(result)
                };
                var emptyArray = [];
                initRender.prototype.splice = function() {
                    return renderer(emptyArray.splice.apply(this, arguments))
                };
                initRender.prototype.slice = function() {
                    return renderer(emptyArray.slice.apply(this, arguments))
                };
                initRender.prototype.toArray = function() {
                    return emptyArray.slice.call(this)
                };
                initRender.prototype.offset = function() {
                    if (!this[0]) {
                        return
                    }
                    return (0, _size.getOffset)(this[0])
                };
                initRender.prototype.offsetParent = function() {
                    if (!this[0]) {
                        return renderer()
                    }
                    var offsetParent = renderer(this[0].offsetParent);
                    while (offsetParent[0] && "static" === offsetParent.css("position")) {
                        offsetParent = renderer(offsetParent[0].offsetParent)
                    }
                    offsetParent = offsetParent[0] ? offsetParent : renderer(_dom_adapter.default.getDocumentElement());
                    return offsetParent
                };
                initRender.prototype.position = function() {
                    if (!this[0]) {
                        return
                    }
                    var offset;
                    var marginTop = parseFloat(this.css("marginTop"));
                    var marginLeft = parseFloat(this.css("marginLeft"));
                    if ("fixed" === this.css("position")) {
                        offset = this[0].getBoundingClientRect();
                        return {
                            top: offset.top - marginTop,
                            left: offset.left - marginLeft
                        }
                    }
                    offset = this.offset();
                    var offsetParent = this.offsetParent();
                    var parentOffset = {
                        top: 0,
                        left: 0
                    };
                    if ("HTML" !== offsetParent[0].nodeName) {
                        parentOffset = offsetParent.offset()
                    }
                    parentOffset = {
                        top: parentOffset.top + parseFloat(offsetParent.css("borderTopWidth")),
                        left: parentOffset.left + parseFloat(offsetParent.css("borderLeftWidth"))
                    };
                    return {
                        top: offset.top - parentOffset.top - marginTop,
                        left: offset.left - parentOffset.left - marginLeft
                    }
                };
                [{
                    name: "scrollLeft",
                    offsetProp: "pageXOffset",
                    scrollWindow: function(win, value) {
                        win.scrollTo(value, win.pageYOffset)
                    }
                }, {
                    name: "scrollTop",
                    offsetProp: "pageYOffset",
                    scrollWindow: function(win, value) {
                        win.scrollTo(win.pageXOffset, value)
                    }
                }].forEach((function(directionStrategy) {
                    var propName = directionStrategy.name;
                    initRender.prototype[propName] = function(value) {
                        if (!this[0]) {
                            return
                        }
                        var window = (0, _size.getWindowByElement)(this[0]);
                        if (void 0 === value) {
                            return window ? window[directionStrategy.offsetProp] : this[0][propName]
                        }
                        if (window) {
                            directionStrategy.scrollWindow(window, value)
                        } else {
                            this[0][propName] = value
                        }
                        return this
                    }
                }));
                initRender.prototype.data = function(key, value) {
                    if (!this[0]) {
                        return
                    }
                    if (arguments.length < 2) {
                        return _element_data.data.call(renderer, this[0], key)
                    }
                    _element_data.data.call(renderer, this[0], key, value);
                    return this
                };
                initRender.prototype.removeData = function(key) {
                    this[0] && (0, _element_data.removeData)(this[0], key);
                    return this
                };
                var rendererWrapper = function() {
                    return renderer.apply(this, arguments)
                };
                Object.defineProperty(rendererWrapper, "fn", {
                    enumerable: true,
                    configurable: true,
                    get: function() {
                        return renderer.fn
                    },
                    set: function(value) {
                        renderer.fn = value
                    }
                });
                var _default = {
                    set: function(strategy) {
                        renderer = strategy
                    },
                    get: function() {
                        return rendererWrapper
                    }
                };
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        91784:
            /*!*********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/resize_observer.js ***!
              \*********************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _common = __webpack_require__( /*! ./utils/common */ 20576);
                var _window = __webpack_require__( /*! ./utils/window */ 58201);
                var window = (0, _window.getWindow)();
                var ResizeObserverMock = {
                    observe: _common.noop,
                    unobserve: _common.noop,
                    disconnect: _common.noop
                };
                var ResizeObserverSingleton = function() {
                    function ResizeObserverSingleton() {
                        var _this = this;
                        if (!(0, _window.hasWindow)() || !window.ResizeObserver) {
                            return ResizeObserverMock
                        }
                        this._callbacksMap = new Map;
                        this._observer = new window.ResizeObserver((function(entries) {
                            entries.forEach((function(entry) {
                                var _this$_callbacksMap$g;
                                null === (_this$_callbacksMap$g = _this._callbacksMap.get(entry.target)) || void 0 === _this$_callbacksMap$g ? void 0 : _this$_callbacksMap$g(entry)
                            }))
                        }))
                    }
                    var _proto = ResizeObserverSingleton.prototype;
                    _proto.observe = function(element, callback) {
                        this._callbacksMap.set(element, callback);
                        this._observer.observe(element)
                    };
                    _proto.unobserve = function(element) {
                        this._callbacksMap.delete(element);
                        this._observer.unobserve(element)
                    };
                    _proto.disconnect = function() {
                        this._callbacksMap.clear();
                        this._observer.disconnect()
                    };
                    return ResizeObserverSingleton
                }();
                var resizeObserverSingleton = new ResizeObserverSingleton;
                var _default = resizeObserverSingleton;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        14192:
            /*!**********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/template_manager.js ***!
              \**********************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.TemplateManager = void 0;
                var _renderer = (obj = __webpack_require__( /*! ./renderer */ 68374), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _type = __webpack_require__( /*! ./utils/type */ 35922);
                var _common = __webpack_require__( /*! ./utils/common */ 20576);
                var _extend = __webpack_require__( /*! ./utils/extend */ 13306);
                var _function_template = __webpack_require__( /*! ./templates/function_template */ 68494);
                var _empty_template = __webpack_require__( /*! ./templates/empty_template */ 10688);
                var _template_manager = __webpack_require__( /*! ./utils/template_manager */ 69697);

                function _defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) {
                            descriptor.writable = true
                        }
                        Object.defineProperty(target, descriptor.key, descriptor)
                    }
                }
                var DX_POLYMORPH_WIDGET_TEMPLATE = new _function_template.FunctionTemplate((function(_ref) {
                    var model = _ref.model,
                        parent = _ref.parent;
                    var widgetName = model.widget;
                    if (!widgetName) {
                        return (0, _renderer.default)()
                    }
                    var widgetElement = (0, _renderer.default)("<div>");
                    var widgetOptions = model.options || {};
                    if (parent) {
                        parent._createComponent(widgetElement, widgetName, widgetOptions)
                    } else {
                        widgetElement[widgetName](widgetOptions)
                    }
                    return widgetElement
                }));
                var TemplateManager = function() {
                    function TemplateManager(createElement, anonymousTemplateName) {
                        this._tempTemplates = [];
                        this._defaultTemplates = {};
                        this._anonymousTemplateName = anonymousTemplateName || "template";
                        this._createElement = createElement || _template_manager.defaultCreateElement;
                        this._createTemplateIfNeeded = this._createTemplateIfNeeded.bind(this)
                    }
                    TemplateManager.createDefaultOptions = function() {
                        return {
                            integrationOptions: {
                                watchMethod: function(fn, callback) {
                                    var options = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
                                    if (!options.skipImmediate) {
                                        callback(fn())
                                    }
                                    return _common.noop
                                },
                                templates: {
                                    "dx-polymorph-widget": DX_POLYMORPH_WIDGET_TEMPLATE
                                },
                                useDeferUpdateForTemplates: true
                            }
                        }
                    };
                    var _proto = TemplateManager.prototype;
                    _proto.addDefaultTemplates = function(templates) {
                        this._defaultTemplates = (0, _extend.extend)({}, this._defaultTemplates, templates)
                    };
                    _proto.dispose = function() {
                        this._tempTemplates.forEach((function(tempTemplate) {
                            tempTemplate.template.dispose && tempTemplate.template.dispose()
                        }));
                        this._tempTemplates = []
                    };
                    _proto.extractTemplates = function($el) {
                        var templates = this._extractTemplates($el);
                        var anonymousTemplateMeta = this._extractAnonymousTemplate($el);
                        return {
                            templates: templates,
                            anonymousTemplateMeta: anonymousTemplateMeta
                        }
                    };
                    _proto._extractTemplates = function($el) {
                        var _this = this;
                        var templates = (0, _template_manager.findTemplates)($el, "dxTemplate");
                        var suitableTemplates = (0, _template_manager.suitableTemplatesByName)(templates);
                        templates.forEach((function(_ref2) {
                            var element = _ref2.element,
                                name = _ref2.options.name;
                            if (element === suitableTemplates[name]) {
                                (0, _renderer.default)(element).addClass("dx-template-wrapper").detach()
                            } else {
                                (0, _renderer.default)(element).remove()
                            }
                        }));
                        return Object.keys(suitableTemplates).map((function(name) {
                            return {
                                name: name,
                                template: _this._createTemplate(suitableTemplates[name])
                            }
                        }))
                    };
                    _proto._extractAnonymousTemplate = function($el) {
                        var $anonymousTemplate = $el.contents().detach();
                        var $notJunkTemplateContent = $anonymousTemplate.filter((function(_, element) {
                            var isTextNode = 3 === element.nodeType;
                            var isEmptyText = (0, _renderer.default)(element).text().trim().length < 1;
                            return !(isTextNode && isEmptyText)
                        }));
                        return $notJunkTemplateContent.length > 0 ? {
                            template: this._createTemplate($anonymousTemplate),
                            name: this._anonymousTemplateName
                        } : {}
                    };
                    _proto._createTemplateIfNeeded = function(templateSource) {
                        var cachedTemplate = this._tempTemplates.filter((function(tempTemplate) {
                            return tempTemplate.source === (0, _template_manager.templateKey)(templateSource)
                        }))[0];
                        if (cachedTemplate) {
                            return cachedTemplate.template
                        }
                        var template = this._createTemplate(templateSource);
                        this._tempTemplates.push({
                            template: template,
                            source: (0, _template_manager.templateKey)(templateSource)
                        });
                        return template
                    };
                    _proto._createTemplate = function(templateSource) {
                        return this._createElement((0, _template_manager.validateTemplateSource)(templateSource))
                    };
                    _proto.getTemplate = function(templateSource, templates, _ref3, context) {
                        var _this2 = this;
                        var isAsyncTemplate = _ref3.isAsyncTemplate,
                            skipTemplates = _ref3.skipTemplates;
                        if (!(0, _type.isFunction)(templateSource)) {
                            return (0, _template_manager.acquireTemplate)(templateSource, this._createTemplateIfNeeded, templates, isAsyncTemplate, skipTemplates, this._defaultTemplates)
                        }
                        return new _function_template.FunctionTemplate((function(options) {
                            var templateSourceResult = templateSource.apply(context, (0, _template_manager.getNormalizedTemplateArgs)(options));
                            if (!(0, _type.isDefined)(templateSourceResult)) {
                                return new _empty_template.EmptyTemplate
                            }
                            var dispose = false;
                            var template = (0, _template_manager.acquireTemplate)(templateSourceResult, (function(templateSource) {
                                if (templateSource.nodeType || (0, _type.isRenderer)(templateSource) && !(0, _renderer.default)(templateSource).is("script")) {
                                    return new _function_template.FunctionTemplate((function() {
                                        return templateSource
                                    }))
                                }
                                dispose = true;
                                return _this2._createTemplate(templateSource)
                            }), templates, isAsyncTemplate, skipTemplates, _this2._defaultTemplates);
                            var result = template.render(options);
                            dispose && template.dispose && template.dispose();
                            return result
                        }))
                    };
                    ! function(Constructor, protoProps, staticProps) {
                        if (protoProps) {
                            _defineProperties(Constructor.prototype, protoProps)
                        }
                        if (staticProps) {
                            _defineProperties(Constructor, staticProps)
                        }
                        Object.defineProperty(Constructor, "prototype", {
                            writable: false
                        });
                        return Constructor
                    }(TemplateManager, [{
                        key: "anonymousTemplateName",
                        get: function() {
                            return this._anonymousTemplateName
                        }
                    }]);
                    return TemplateManager
                }();
                exports.TemplateManager = TemplateManager
            },
        93280:
            /*!*********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/templates/bindable_template.js ***!
              \*********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.BindableTemplate = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../renderer */ 68374));
                var _template_base = __webpack_require__( /*! ./template_base */ 81033);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 55994));
                var _remove = __webpack_require__( /*! ../../events/remove */ 29007);
                var _type = __webpack_require__( /*! ../utils/type */ 35922);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                var watchChanges = function(rawData, watchMethod, fields, fieldsMap, callback) {
                    var fieldsDispose;
                    var globalDispose = function(data, watchMethod, callback) {
                        return watchMethod((function() {
                            return data
                        }), callback)
                    }(rawData, watchMethod, (function(dataWithRawFields) {
                        fieldsDispose && fieldsDispose();
                        if ((0, _type.isPrimitive)(dataWithRawFields)) {
                            callback(dataWithRawFields);
                            return
                        }
                        fieldsDispose = function(data, watchMethod, fields, fieldsMap, callback) {
                            var resolvedData = {};
                            var missedFields = fields.slice();
                            var watchHandlers = fields.map((function(name) {
                                var fieldGetter = fieldsMap[name];
                                return watchMethod(fieldGetter ? function() {
                                    return fieldGetter(data)
                                } : function() {
                                    return data[name]
                                }, (function(value) {
                                    resolvedData[name] = value;
                                    if (missedFields.length) {
                                        var index = missedFields.indexOf(name);
                                        if (index >= 0) {
                                            missedFields.splice(index, 1)
                                        }
                                    }
                                    if (!missedFields.length) {
                                        callback(resolvedData)
                                    }
                                }))
                            }));
                            return function() {
                                watchHandlers.forEach((function(dispose) {
                                    return dispose()
                                }))
                            }
                        }(dataWithRawFields, watchMethod, fields, fieldsMap, callback)
                    }));
                    return function() {
                        fieldsDispose && fieldsDispose();
                        globalDispose && globalDispose()
                    }
                };
                var BindableTemplate = function(_TemplateBase) {
                    ! function(subClass, superClass) {
                        subClass.prototype = Object.create(superClass.prototype);
                        subClass.prototype.constructor = subClass;
                        _setPrototypeOf(subClass, superClass)
                    }(BindableTemplate, _TemplateBase);

                    function BindableTemplate(render, fields, watchMethod, fieldsMap) {
                        var _this;
                        _this = _TemplateBase.call(this) || this;
                        _this._render = render;
                        _this._fields = fields;
                        _this._fieldsMap = fieldsMap || {};
                        _this._watchMethod = watchMethod;
                        return _this
                    }
                    var _proto = BindableTemplate.prototype;
                    _proto._renderCore = function(options) {
                        var _this2 = this;
                        var $container = (0, _renderer.default)(options.container);
                        var dispose = watchChanges(options.model, this._watchMethod, this._fields, this._fieldsMap, (function(data) {
                            $container.empty();
                            _this2._render($container, data, options.model)
                        }));
                        _events_engine.default.on($container, _remove.removeEvent, dispose);
                        return $container.contents()
                    };
                    return BindableTemplate
                }(_template_base.TemplateBase);
                exports.BindableTemplate = BindableTemplate
            },
        91627:
            /*!**************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/templates/child_default_template.js ***!
              \**************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.ChildDefaultTemplate = void 0;
                var _template_base = __webpack_require__( /*! ./template_base */ 81033);

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                var ChildDefaultTemplate = function(_TemplateBase) {
                    ! function(subClass, superClass) {
                        subClass.prototype = Object.create(superClass.prototype);
                        subClass.prototype.constructor = subClass;
                        _setPrototypeOf(subClass, superClass)
                    }(ChildDefaultTemplate, _TemplateBase);

                    function ChildDefaultTemplate(name) {
                        var _this;
                        _this = _TemplateBase.call(this) || this;
                        _this.name = name;
                        return _this
                    }
                    return ChildDefaultTemplate
                }(_template_base.TemplateBase);
                exports.ChildDefaultTemplate = ChildDefaultTemplate
            },
        10688:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/templates/empty_template.js ***!
              \******************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.EmptyTemplate = void 0;
                var _renderer = (obj = __webpack_require__( /*! ../renderer */ 68374), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _template_base = __webpack_require__( /*! ./template_base */ 81033);

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                var EmptyTemplate = function(_TemplateBase) {
                    ! function(subClass, superClass) {
                        subClass.prototype = Object.create(superClass.prototype);
                        subClass.prototype.constructor = subClass;
                        _setPrototypeOf(subClass, superClass)
                    }(EmptyTemplate, _TemplateBase);

                    function EmptyTemplate() {
                        return _TemplateBase.apply(this, arguments) || this
                    }
                    var _proto = EmptyTemplate.prototype;
                    _proto._renderCore = function() {
                        return (0, _renderer.default)()
                    };
                    return EmptyTemplate
                }(_template_base.TemplateBase);
                exports.EmptyTemplate = EmptyTemplate
            },
        68494:
            /*!*********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/templates/function_template.js ***!
              \*********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.FunctionTemplate = void 0;
                var _template_base = __webpack_require__( /*! ./template_base */ 81033);
                var _dom = __webpack_require__( /*! ../utils/dom */ 3532);

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                var FunctionTemplate = function(_TemplateBase) {
                    ! function(subClass, superClass) {
                        subClass.prototype = Object.create(superClass.prototype);
                        subClass.prototype.constructor = subClass;
                        _setPrototypeOf(subClass, superClass)
                    }(FunctionTemplate, _TemplateBase);

                    function FunctionTemplate(render) {
                        var _this;
                        _this = _TemplateBase.call(this) || this;
                        _this._render = render;
                        return _this
                    }
                    var _proto = FunctionTemplate.prototype;
                    _proto._renderCore = function(options) {
                        return (0, _dom.normalizeTemplateElement)(this._render(options))
                    };
                    return FunctionTemplate
                }(_template_base.TemplateBase);
                exports.FunctionTemplate = FunctionTemplate
            },
        9545:
            /*!************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/templates/template.js ***!
              \************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.Template = void 0;
                var _renderer = (obj = __webpack_require__( /*! ../renderer */ 68374), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _template_base = __webpack_require__( /*! ./template_base */ 81033);
                var _dom = __webpack_require__( /*! ../utils/dom */ 3532);
                var _template_engine_registry = __webpack_require__( /*! ./template_engine_registry */ 72987);
                __webpack_require__( /*! ./template_engines */ 32468);

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }(0, _template_engine_registry.registerTemplateEngine)("default", {
                    compile: function(element) {
                        return (0, _dom.normalizeTemplateElement)(element)
                    },
                    render: function(template, model, index) {
                        return template.clone()
                    }
                });
                (0, _template_engine_registry.setTemplateEngine)("default");
                var Template = function(_TemplateBase) {
                    ! function(subClass, superClass) {
                        subClass.prototype = Object.create(superClass.prototype);
                        subClass.prototype.constructor = subClass;
                        _setPrototypeOf(subClass, superClass)
                    }(Template, _TemplateBase);

                    function Template(element) {
                        var _this;
                        _this = _TemplateBase.call(this) || this;
                        _this._element = element;
                        return _this
                    }
                    var _proto = Template.prototype;
                    _proto._renderCore = function(options) {
                        var transclude = options.transclude;
                        if (!transclude && !this._compiledTemplate) {
                            this._compiledTemplate = (0, _template_engine_registry.getCurrentTemplateEngine)().compile(this._element)
                        }
                        return (0, _renderer.default)("<div>").append(transclude ? this._element : (0, _template_engine_registry.getCurrentTemplateEngine)().render(this._compiledTemplate, options.model, options.index)).contents()
                    };
                    _proto.source = function() {
                        return (0, _renderer.default)(this._element).clone()
                    };
                    return Template
                }(_template_base.TemplateBase);
                exports.Template = Template
            },
        81033:
            /*!*****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/templates/template_base.js ***!
              \*****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.renderedCallbacks = exports.TemplateBase = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../renderer */ 68374));
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../dom_adapter */ 73349));
                var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../utils/callbacks */ 44504));
                var _dom = __webpack_require__( /*! ../utils/dom */ 3532);
                var _visibility_change = __webpack_require__( /*! ../../events/visibility_change */ 80506);
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../errors */ 17381));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var renderedCallbacks = (0, _callbacks.default)({
                    syncStrategy: true
                });
                exports.renderedCallbacks = renderedCallbacks;
                var TemplateBase = function() {
                    function TemplateBase() {}
                    var _proto = TemplateBase.prototype;
                    _proto.render = function(options) {
                        options = options || {};
                        var onRendered = options.onRendered;
                        delete options.onRendered;
                        var $result;
                        if (options.renovated && options.transclude && this._element) {
                            $result = (0, _renderer.default)("<div>").append(this._element).contents()
                        } else {
                            $result = this._renderCore(options)
                        }
                        this._ensureResultInContainer($result, options.container);
                        renderedCallbacks.fire($result, options.container);
                        onRendered && onRendered();
                        return $result
                    };
                    _proto._ensureResultInContainer = function($result, container) {
                        if (!container) {
                            return
                        }
                        var $container = (0, _renderer.default)(container);
                        var resultInContainer = (0, _dom.contains)($container.get(0), $result.get(0));
                        $container.append($result);
                        if (resultInContainer) {
                            return
                        }
                        var resultInBody = _dom_adapter.default.getBody().contains($container.get(0));
                        if (!resultInBody) {
                            return
                        }(0, _visibility_change.triggerShownEvent)($result)
                    };
                    _proto._renderCore = function() {
                        throw _errors.default.Error("E0001")
                    };
                    return TemplateBase
                }();
                exports.TemplateBase = TemplateBase
            },
        72987:
            /*!****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/templates/template_engine_registry.js ***!
              \****************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.getCurrentTemplateEngine = function() {
                    return currentTemplateEngine
                };
                exports.registerTemplateEngine = function(name, templateEngine) {
                    templateEngines[name] = templateEngine
                };
                exports.setTemplateEngine = function(templateEngine) {
                    if ((0, _type.isString)(templateEngine)) {
                        currentTemplateEngine = templateEngines[templateEngine];
                        if (!currentTemplateEngine) {
                            throw _errors.default.Error("E0020", templateEngine)
                        }
                    } else {
                        currentTemplateEngine = templateEngine
                    }
                };
                var _type = __webpack_require__( /*! ../utils/type */ 35922);
                var _errors = (obj = __webpack_require__( /*! ../errors */ 17381), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var templateEngines = {};
                var currentTemplateEngine
            },
        32468:
            /*!********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/templates/template_engines.js ***!
              \********************************************************************************/
            function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {
                var _dom = __webpack_require__( /*! ../utils/dom */ 3532);
                var _template_engine_registry = __webpack_require__( /*! ./template_engine_registry */ 72987);
                (0, _template_engine_registry.registerTemplateEngine)("jquery-tmpl", {
                    compile: function(element) {
                        return (0, _dom.extractTemplateMarkup)(element)
                    },
                    render: function(template, data) {
                        return jQuery.tmpl(template, data)
                    }
                });
                (0, _template_engine_registry.registerTemplateEngine)("jsrender", {
                    compile: function(element) {
                        return (jQuery ? jQuery : jsrender).templates((0, _dom.extractTemplateMarkup)(element))
                    },
                    render: function(template, data) {
                        return template.render(data)
                    }
                });
                (0, _template_engine_registry.registerTemplateEngine)("mustache", {
                    compile: function(element) {
                        return (0, _dom.extractTemplateMarkup)(element)
                    },
                    render: function(template, data) {
                        return Mustache.render(template, data)
                    }
                });
                (0, _template_engine_registry.registerTemplateEngine)("hogan", {
                    compile: function(element) {
                        return Hogan.compile((0, _dom.extractTemplateMarkup)(element))
                    },
                    render: function(template, data) {
                        return template.render(data)
                    }
                });
                (0, _template_engine_registry.registerTemplateEngine)("underscore", {
                    compile: function(element) {
                        return _.template((0, _dom.extractTemplateMarkup)(element))
                    },
                    render: function(template, data) {
                        return template(data)
                    }
                });
                (0, _template_engine_registry.registerTemplateEngine)("handlebars", {
                    compile: function(element) {
                        return Handlebars.compile((0, _dom.extractTemplateMarkup)(element))
                    },
                    render: function(template, data) {
                        return template(data)
                    }
                });
                (0, _template_engine_registry.registerTemplateEngine)("doT", {
                    compile: function(element) {
                        return doT.template((0, _dom.extractTemplateMarkup)(element))
                    },
                    render: function(template, data) {
                        return template(data)
                    }
                })
            },
        37208:
            /*!****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/ajax.js ***!
              \****************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _deferred = __webpack_require__( /*! ./deferred */ 62754);
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 73349));
                var _http_request = _interopRequireDefault(__webpack_require__( /*! ../../core/http_request */ 83448));
                var _window = __webpack_require__( /*! ../../core/utils/window */ 58201);
                var _extend = __webpack_require__( /*! ./extend */ 13306);
                var _type = __webpack_require__( /*! ./type */ 35922);
                var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ./dependency_injector */ 20476));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var window = (0, _window.getWindow)();
                var createScript = function(options) {
                    var script = _dom_adapter.default.createElement("script");
                    for (var name in options) {
                        script[name] = options[name]
                    }
                    return script
                };
                var removeScript = function(scriptNode) {
                    scriptNode.parentNode.removeChild(scriptNode)
                };
                var appendToHead = function(element) {
                    return _dom_adapter.default.getHead().appendChild(element)
                };
                var evalScript = function(code) {
                    var script = createScript({
                        text: code
                    });
                    appendToHead(script);
                    removeScript(script)
                };
                var getRequestOptions = function(options, headers) {
                    var params = options.data;
                    var paramsAlreadyString = "string" === typeof params;
                    var url = options.url || window.location.href;
                    if (!paramsAlreadyString && !options.cache) {
                        params = params || {};
                        params._ = Date.now()
                    }
                    if (params && !options.upload) {
                        if (!paramsAlreadyString) {
                            params = function(params) {
                                var result = [];
                                for (var name in params) {
                                    var value = params[name];
                                    if (void 0 === value) {
                                        continue
                                    }
                                    if (null === value) {
                                        value = ""
                                    }
                                    if ("function" === typeof value) {
                                        value = value()
                                    }
                                    result.push(encodeURIComponent(name) + "=" + encodeURIComponent(value))
                                }
                                return result.join("&")
                            }(params)
                        }
                        if ("GET" === getMethod(options)) {
                            if ("" !== params) {
                                url += (url.indexOf("?") > -1 ? "&" : "?") + params
                            }
                            params = null
                        } else if (headers["Content-Type"] && headers["Content-Type"].indexOf("application/x-www-form-urlencoded") > -1) {
                            params = params.replace(/%20/g, "+")
                        }
                    }
                    return {
                        url: url,
                        parameters: params
                    }
                };

                function getMethod(options) {
                    return (options.method || "GET").toUpperCase()
                }
                var getRequestHeaders = function(options) {
                    var headers = options.headers || {};
                    headers["Content-Type"] = headers["Content-Type"] || function(options) {
                        var defaultContentType;
                        if (options.data && !options.upload && "GET" !== getMethod(options)) {
                            defaultContentType = "application/x-www-form-urlencoded;charset=utf-8"
                        }
                        return options.contentType || defaultContentType
                    }(options);
                    headers.Accept = headers.Accept || function(options) {
                        var dataType = options.dataType || "*";
                        var scriptAccept = "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript";
                        var accepts = {
                            "*": "*/*",
                            text: "text/plain",
                            html: "text/html",
                            xml: "application/xml, text/xml",
                            json: "application/json, text/javascript",
                            jsonp: scriptAccept,
                            script: scriptAccept
                        };
                        (0, _extend.extendFromObject)(accepts, options.accepts, true);
                        return accepts[dataType] ? accepts[dataType] + ("*" !== dataType ? ", */*; q=0.01" : "") : accepts["*"]
                    }(options);
                    if (!options.crossDomain && !headers["X-Requested-With"]) {
                        headers["X-Requested-With"] = "XMLHttpRequest"
                    }
                    return headers
                };
                var _default = (0, _dependency_injector.default)({
                    sendRequest: function(options) {
                        var xhr = _http_request.default.getXhr();
                        var d = new _deferred.Deferred;
                        var result = d.promise();
                        var async = (0, _type.isDefined)(options.async) ? options.async : true;
                        var dataType = options.dataType;
                        var timeout = options.timeout || 0;
                        var timeoutId;
                        options.crossDomain = function(url) {
                            if (!(0, _window.hasWindow)()) {
                                return true
                            }
                            var crossDomain = false;
                            var originAnchor = _dom_adapter.default.createElement("a");
                            var urlAnchor = _dom_adapter.default.createElement("a");
                            originAnchor.href = window.location.href;
                            try {
                                urlAnchor.href = url;
                                urlAnchor.href = urlAnchor.href;
                                crossDomain = originAnchor.protocol + "//" + originAnchor.host !== urlAnchor.protocol + "//" + urlAnchor.host
                            } catch (e) {
                                crossDomain = true
                            }
                            return crossDomain
                        }(options.url);
                        var needScriptEvaluation = "jsonp" === dataType || "script" === dataType;
                        if (void 0 === options.cache) {
                            options.cache = !needScriptEvaluation
                        }
                        var callbackName = function(options) {
                            if ("jsonp" === options.dataType) {
                                var random = Math.random().toString().replace(/\D/g, "");
                                var callbackName = options.jsonpCallback || "dxCallback" + Date.now() + "_" + random;
                                var callbackParameter = options.jsonp || "callback";
                                options.data = options.data || {};
                                options.data[callbackParameter] = callbackName;
                                return callbackName
                            }
                        }(options);
                        var headers = getRequestHeaders(options);
                        var requestOptions = getRequestOptions(options, headers);
                        var url = requestOptions.url;
                        var parameters = requestOptions.parameters;
                        if (callbackName) {
                            window[callbackName] = function(data) {
                                d.resolve(data, "success", xhr)
                            }
                        }
                        if (options.crossDomain && needScriptEvaluation) {
                            (function(url) {
                                var script = createScript({
                                    src: url
                                });
                                return new Promise((function(resolve, reject) {
                                    var events = {
                                        load: resolve,
                                        error: reject
                                    };
                                    var loadHandler = function(e) {
                                        events[e.type]();
                                        removeScript(script)
                                    };
                                    for (var event in events) {
                                        _dom_adapter.default.listen(script, event, loadHandler)
                                    }
                                    appendToHead(script)
                                }))
                            })(url).then((function() {
                                if ("jsonp" === dataType) {
                                    return
                                }
                                d.resolve(null, "success", xhr)
                            }), (function() {
                                d.reject(xhr, "error")
                            }));
                            return result
                        }
                        if (options.crossDomain && !("withCredentials" in xhr)) {
                            d.reject(xhr, "error");
                            return result
                        }
                        xhr.open(getMethod(options), url, async, options.username, options.password);
                        if (async) {
                            xhr.timeout = timeout;
                            timeoutId = function(timeout, xhr) {
                                return timeout && setTimeout((function() {
                                    xhr.customStatus = "timeout";
                                    xhr.abort()
                                }), timeout)
                            }(timeout, xhr)
                        }
                        xhr.onreadystatechange = function(e) {
                            if (4 === xhr.readyState) {
                                clearTimeout(timeoutId);
                                if (status = xhr.status, 200 <= status && status < 300) {
                                    if (function(status) {
                                            return 204 !== status
                                        }(xhr.status)) {
                                        ! function(deferred, xhr, dataType) {
                                            var data = function(xhr) {
                                                return xhr.responseType && "text" !== xhr.responseType || "string" !== typeof xhr.responseText ? xhr.response : xhr.responseText
                                            }(xhr);
                                            switch (dataType) {
                                                case "jsonp":
                                                    evalScript(data);
                                                    break;
                                                case "script":
                                                    evalScript(data);
                                                    deferred.resolve(data, "success", xhr);
                                                    break;
                                                case "json":
                                                    try {
                                                        deferred.resolve(JSON.parse(data), "success", xhr)
                                                    } catch (e) {
                                                        deferred.reject(xhr, "parsererror", e)
                                                    }
                                                    break;
                                                default:
                                                    deferred.resolve(data, "success", xhr)
                                            }
                                        }(d, xhr, dataType)
                                    } else {
                                        d.resolve(null, "nocontent", xhr)
                                    }
                                } else {
                                    d.reject(xhr, xhr.customStatus || "error")
                                }
                            }
                            var status
                        };
                        if (options.upload) {
                            xhr.upload.onprogress = options.upload.onprogress;
                            xhr.upload.onloadstart = options.upload.onloadstart;
                            xhr.upload.onabort = options.upload.onabort
                        }
                        if (options.xhrFields) {
                            for (var field in options.xhrFields) {
                                xhr[field] = options.xhrFields[field]
                            }
                        }
                        if ("arraybuffer" === options.responseType) {
                            xhr.responseType = options.responseType
                        }
                        for (var name in headers) {
                            if (Object.prototype.hasOwnProperty.call(headers, name) && (0, _type.isDefined)(headers[name])) {
                                xhr.setRequestHeader(name, headers[name])
                            }
                        }
                        if (options.beforeSend) {
                            options.beforeSend(xhr)
                        }
                        xhr.send(parameters);
                        result.abort = function() {
                            xhr.abort()
                        };
                        return result
                    }
                });
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        89386:
            /*!*****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/array.js ***!
              \*****************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.wrapToArray = exports.removeDuplicates = exports.normalizeIndexes = exports.groupBy = exports.getUniqueValues = exports.getIntersection = void 0;
                var _type = __webpack_require__( /*! ./type */ 35922);
                var _object = __webpack_require__( /*! ./object */ 48013);
                var _config2 = (obj = __webpack_require__( /*! ../config */ 80209), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;

                function _toConsumableArray(arr) {
                    return function(arr) {
                        if (Array.isArray(arr)) {
                            return _arrayLikeToArray(arr)
                        }
                    }(arr) || function(iter) {
                        if ("undefined" !== typeof Symbol && null != iter[Symbol.iterator] || null != iter["@@iterator"]) {
                            return Array.from(iter)
                        }
                    }(arr) || function(o, minLen) {
                        if (!o) {
                            return
                        }
                        if ("string" === typeof o) {
                            return _arrayLikeToArray(o, minLen)
                        }
                        var n = Object.prototype.toString.call(o).slice(8, -1);
                        if ("Object" === n && o.constructor) {
                            n = o.constructor.name
                        }
                        if ("Map" === n || "Set" === n) {
                            return Array.from(o)
                        }
                        if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                            return _arrayLikeToArray(o, minLen)
                        }
                    }(arr) || function() {
                        throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                    }()
                }

                function _arrayLikeToArray(arr, len) {
                    if (null == len || len > arr.length) {
                        len = arr.length
                    }
                    for (var i = 0, arr2 = new Array(len); i < len; i++) {
                        arr2[i] = arr[i]
                    }
                    return arr2
                }

                function createOccurrenceMap(array) {
                    return array.reduce((function(map, value) {
                        var _map$value;
                        map[value] = (null !== (_map$value = map[value]) && void 0 !== _map$value ? _map$value : 0) + 1;
                        return map
                    }), {})
                }
                exports.wrapToArray = function(item) {
                    return Array.isArray(item) ? item : [item]
                };
                exports.getUniqueValues = function(values) {
                    return _toConsumableArray(new Set(values))
                };
                exports.getIntersection = function(firstArray, secondArray) {
                    var secondArrayMap = createOccurrenceMap(secondArray);
                    return firstArray.filter((function(value) {
                        return secondArrayMap[value]--
                    }))
                };
                exports.removeDuplicates = function() {
                    var from = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : [];
                    var toRemove = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : [];
                    var toRemoveMap = createOccurrenceMap(toRemove);
                    return from.filter((function(value) {
                        return !toRemoveMap[value]--
                    }))
                };
                exports.normalizeIndexes = function(items, indexPropName, currentItem, needIndexCallback) {
                    var indexedItems = {};
                    var _config = (0, _config2.default)(),
                        useLegacyVisibleIndex = _config.useLegacyVisibleIndex;
                    var currentIndex = 0;
                    var shouldUpdateIndex = function(item) {
                        return !(0, _type.isDefined)(item[indexPropName]) && (!needIndexCallback || needIndexCallback(item))
                    };
                    items.forEach((function(item) {
                        var index = item[indexPropName];
                        if (index >= 0) {
                            indexedItems[index] = indexedItems[index] || [];
                            if (item === currentItem) {
                                indexedItems[index].unshift(item)
                            } else {
                                indexedItems[index].push(item)
                            }
                        } else {
                            item[indexPropName] = void 0
                        }
                    }));
                    if (!useLegacyVisibleIndex) {
                        items.forEach((function(item) {
                            if (shouldUpdateIndex(item)) {
                                while (indexedItems[currentIndex]) {
                                    currentIndex++
                                }
                                indexedItems[currentIndex] = [item];
                                currentIndex++
                            }
                        }))
                    }
                    currentIndex = 0;
                    (0, _object.orderEach)(indexedItems, (function(index, items) {
                        items.forEach((function(item) {
                            if (index >= 0) {
                                item[indexPropName] = currentIndex++
                            }
                        }))
                    }));
                    if (useLegacyVisibleIndex) {
                        items.forEach((function(item) {
                            if (shouldUpdateIndex(item)) {
                                item[indexPropName] = currentIndex++
                            }
                        }))
                    }
                };
                exports.groupBy = function(array, getGroupName) {
                    return array.reduce((function(groupedResult, item) {
                        var _groupedResult$groupN;
                        var groupName = getGroupName(item);
                        groupedResult[groupName] = null !== (_groupedResult$groupN = groupedResult[groupName]) && void 0 !== _groupedResult$groupN ? _groupedResult$groupN : [];
                        groupedResult[groupName].push(item);
                        return groupedResult
                    }), {})
                }
            },
        34671:
            /*!*************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/array_compare.js ***!
              \*************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.isKeysEqual = exports.findChanges = void 0;
                var _type = __webpack_require__( /*! ./type */ 35922);
                var getKeyWrapper = function(item, getKey) {
                    var key = getKey(item);
                    if ((0, _type.isObject)(key)) {
                        try {
                            return JSON.stringify(key)
                        } catch (e) {
                            return key
                        }
                    }
                    return key
                };
                var getSameNewByOld = function(oldItem, newItems, newIndexByKey, getKey) {
                    var key = getKeyWrapper(oldItem, getKey);
                    return newItems[newIndexByKey[key]]
                };
                exports.isKeysEqual = function(oldKeys, newKeys) {
                    if (oldKeys.length !== newKeys.length) {
                        return false
                    }
                    for (var i = 0; i < newKeys.length; i++) {
                        if (oldKeys[i] !== newKeys[i]) {
                            return false
                        }
                    }
                    return true
                };
                exports.findChanges = function(oldItems, newItems, getKey, isItemEquals) {
                    var oldIndexByKey = {};
                    var newIndexByKey = {};
                    var addedCount = 0;
                    var removeCount = 0;
                    var result = [];
                    oldItems.forEach((function(item, index) {
                        var key = getKeyWrapper(item, getKey);
                        oldIndexByKey[key] = index
                    }));
                    newItems.forEach((function(item, index) {
                        var key = getKeyWrapper(item, getKey);
                        newIndexByKey[key] = index
                    }));
                    var itemCount = Math.max(oldItems.length, newItems.length);
                    for (var index = 0; index < itemCount + addedCount; index++) {
                        var newItem = newItems[index];
                        var oldNextIndex = index - addedCount + removeCount;
                        var nextOldItem = oldItems[oldNextIndex];
                        var isRemoved = !newItem || nextOldItem && !getSameNewByOld(nextOldItem, newItems, newIndexByKey, getKey);
                        if (isRemoved) {
                            if (nextOldItem) {
                                result.push({
                                    type: "remove",
                                    key: getKey(nextOldItem),
                                    index: index,
                                    oldItem: nextOldItem
                                });
                                removeCount++;
                                index--
                            }
                        } else {
                            var key = getKeyWrapper(newItem, getKey);
                            var oldIndex = oldIndexByKey[key];
                            var oldItem = oldItems[oldIndex];
                            if (!oldItem) {
                                addedCount++;
                                result.push({
                                    type: "insert",
                                    data: newItem,
                                    index: index
                                })
                            } else if (oldIndex === oldNextIndex) {
                                if (!isItemEquals(oldItem, newItem)) {
                                    result.push({
                                        type: "update",
                                        data: newItem,
                                        key: getKey(newItem),
                                        index: index,
                                        oldItem: oldItem
                                    })
                                }
                            } else {
                                return
                            }
                        }
                    }
                    return result
                }
            },
        47810:
            /*!*******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/browser.js ***!
              \*******************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _extend = __webpack_require__( /*! ./extend */ 13306);
                var _window = __webpack_require__( /*! ./window */ 58201);
                var navigator = (0, _window.getNavigator)();
                var webkitRegExp = /(webkit)[ /]([\w.]+)/;
                var mozillaRegExp = /(mozilla)(?:.*? rv:([\w.]+))/;
                var browserFromUA = function(ua) {
                    ua = ua.toLowerCase();
                    var result = {};
                    var matches = webkitRegExp.exec(ua) || ua.indexOf("compatible") < 0 && mozillaRegExp.exec(ua) || [];
                    var browserName = matches[1];
                    var browserVersion = matches[2];
                    if ("webkit" === browserName) {
                        result.webkit = true;
                        if (ua.indexOf("chrome") >= 0 || ua.indexOf("crios") >= 0) {
                            browserName = "chrome";
                            browserVersion = /(?:chrome|crios)\/(\d+\.\d+)/.exec(ua);
                            browserVersion = browserVersion && browserVersion[1]
                        } else if (ua.indexOf("fxios") >= 0) {
                            browserName = "mozilla";
                            browserVersion = /fxios\/(\d+\.\d+)/.exec(ua);
                            browserVersion = browserVersion && browserVersion[1]
                        } else if (ua.indexOf("safari") >= 0 && /version|phantomjs/.test(ua)) {
                            browserName = "safari";
                            browserVersion = /(?:version|phantomjs)\/([0-9.]+)/.exec(ua);
                            browserVersion = browserVersion && browserVersion[1]
                        } else {
                            browserName = "unknown";
                            browserVersion = /applewebkit\/([0-9.]+)/.exec(ua);
                            browserVersion = browserVersion && browserVersion[1]
                        }
                    }
                    if (browserName) {
                        result[browserName] = true;
                        result.version = browserVersion
                    }
                    return result
                };
                var _default = (0, _extend.extend)({
                    _fromUA: browserFromUA
                }, browserFromUA(navigator.userAgent));
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        39618:
            /*!*********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/call_once.js ***!
              \*********************************************************************/
            function(module, exports) {
                exports.default = void 0;
                var _default = function(handler) {
                    var result;
                    var _wrappedHandler = function() {
                        result = handler.apply(this, arguments);
                        _wrappedHandler = function() {
                            return result
                        };
                        return result
                    };
                    return function() {
                        return _wrappedHandler.apply(this, arguments)
                    }
                };
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        44504:
            /*!*********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/callbacks.js ***!
              \*********************************************************************/
            function(module, exports) {
                exports.default = void 0;
                var Callback = function(options) {
                    this._options = options || {};
                    this._list = [];
                    this._queue = [];
                    this._firing = false;
                    this._fired = false;
                    this._firingIndexes = []
                };
                Callback.prototype._fireCore = function(context, args) {
                    var firingIndexes = this._firingIndexes;
                    var list = this._list;
                    var stopOnFalse = this._options.stopOnFalse;
                    var step = firingIndexes.length;
                    for (firingIndexes[step] = 0; firingIndexes[step] < list.length; firingIndexes[step]++) {
                        var result = list[firingIndexes[step]].apply(context, args);
                        if (false === result && stopOnFalse) {
                            break
                        }
                    }
                    firingIndexes.pop()
                };
                Callback.prototype.add = function(fn) {
                    if ("function" === typeof fn && (!this._options.unique || !this.has(fn))) {
                        this._list.push(fn)
                    }
                    return this
                };
                Callback.prototype.remove = function(fn) {
                    var list = this._list;
                    var firingIndexes = this._firingIndexes;
                    var index = list.indexOf(fn);
                    if (index > -1) {
                        list.splice(index, 1);
                        if (this._firing && firingIndexes.length) {
                            for (var step = 0; step < firingIndexes.length; step++) {
                                if (index <= firingIndexes[step]) {
                                    firingIndexes[step]--
                                }
                            }
                        }
                    }
                    return this
                };
                Callback.prototype.has = function(fn) {
                    var list = this._list;
                    return fn ? list.indexOf(fn) > -1 : !!list.length
                };
                Callback.prototype.empty = function(fn) {
                    this._list = [];
                    return this
                };
                Callback.prototype.fireWith = function(context, args) {
                    var queue = this._queue;
                    args = args || [];
                    args = args.slice ? args.slice() : args;
                    if (this._options.syncStrategy) {
                        this._firing = true;
                        this._fireCore(context, args)
                    } else {
                        queue.push([context, args]);
                        if (this._firing) {
                            return
                        }
                        this._firing = true;
                        while (queue.length) {
                            var memory = queue.shift();
                            this._fireCore(memory[0], memory[1])
                        }
                    }
                    this._firing = false;
                    this._fired = true;
                    return this
                };
                Callback.prototype.fire = function() {
                    this.fireWith(this, arguments)
                };
                Callback.prototype.fired = function() {
                    return this._fired
                };
                var _default = function(options) {
                    return new Callback(options)
                };
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        20576:
            /*!******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/common.js ***!
              \******************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.splitPair = exports.pairToObject = exports.normalizeKey = exports.noop = exports.grep = exports.getKeyHash = exports.findBestMatches = exports.executeAsync = exports.escapeRegExp = exports.equalByValue = exports.ensureDefined = exports.denormalizeKey = exports.deferUpdater = exports.deferUpdate = exports.deferRenderer = exports.deferRender = exports.asyncNoop = exports.applyServerDecimalSeparator = void 0;
                var _config = _interopRequireDefault(__webpack_require__( /*! ../config */ 80209));
                var _guid = _interopRequireDefault(__webpack_require__( /*! ../guid */ 73176));
                var _deferred = __webpack_require__( /*! ../utils/deferred */ 62754);
                var _data = __webpack_require__( /*! ./data */ 47617);
                var _iterator = __webpack_require__( /*! ./iterator */ 95479);
                var _type = __webpack_require__( /*! ./type */ 35922);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                exports.ensureDefined = function(value, defaultValue) {
                    return (0, _type.isDefined)(value) ? value : defaultValue
                };
                exports.executeAsync = function(action, context) {
                    var deferred = new _deferred.Deferred;
                    var normalizedContext = context || this;
                    var task = {
                        promise: deferred.promise(),
                        abort: function() {
                            clearTimeout(timerId);
                            deferred.rejectWith(normalizedContext)
                        }
                    };
                    var callback = function() {
                        var result = action.call(normalizedContext);
                        if (result && result.done && (0, _type.isFunction)(result.done)) {
                            result.done((function() {
                                deferred.resolveWith(normalizedContext)
                            }))
                        } else {
                            deferred.resolveWith(normalizedContext)
                        }
                    };
                    var timerId = (arguments[2] || setTimeout)(callback, "number" === typeof context ? context : 0);
                    return task
                };
                var delayedFuncs = [];
                var delayedNames = [];
                var delayedDeferreds = [];
                var executingName;
                var deferExecute = function(name, func, deferred) {
                    if (executingName && executingName !== name) {
                        delayedFuncs.push(func);
                        delayedNames.push(name);
                        deferred = deferred || new _deferred.Deferred;
                        delayedDeferreds.push(deferred);
                        return deferred
                    } else {
                        var oldExecutingName = executingName;
                        var currentDelayedCount = delayedDeferreds.length;
                        executingName = name;
                        var result = func();
                        if (!result) {
                            if (delayedDeferreds.length > currentDelayedCount) {
                                result = _deferred.when.apply(this, delayedDeferreds.slice(currentDelayedCount))
                            } else if (deferred) {
                                deferred.resolve()
                            }
                        }
                        executingName = oldExecutingName;
                        if (deferred && result && result.done) {
                            result.done(deferred.resolve).fail(deferred.reject)
                        }
                        if (!executingName && delayedFuncs.length) {
                            ("render" === delayedNames.shift() ? deferRender : deferUpdate)(delayedFuncs.shift(), delayedDeferreds.shift())
                        }
                        return result || (0, _deferred.when)()
                    }
                };
                var deferRender = function(func, deferred) {
                    return deferExecute("render", func, deferred)
                };
                exports.deferRender = deferRender;
                var deferUpdate = function(func, deferred) {
                    return deferExecute("update", func, deferred)
                };
                exports.deferUpdate = deferUpdate;
                exports.deferRenderer = function(func) {
                    return function() {
                        var that = this;
                        return deferExecute("render", (function() {
                            return func.call(that)
                        }))
                    }
                };
                exports.deferUpdater = function(func) {
                    return function() {
                        var that = this;
                        return deferExecute("update", (function() {
                            return func.call(that)
                        }))
                    }
                };
                exports.findBestMatches = function(targetFilter, items, mapFn) {
                    var bestMatches = [];
                    var maxMatchCount = 0;
                    (0, _iterator.each)(items, (function(index, itemSrc) {
                        var matchCount = 0;
                        var item = mapFn ? mapFn(itemSrc) : itemSrc;
                        (0, _iterator.each)(targetFilter, (function(paramName, targetValue) {
                            var value = item[paramName];
                            if (void 0 === value) {
                                return
                            }
                            if (match(value, targetValue)) {
                                matchCount++;
                                return
                            }
                            matchCount = -1;
                            return false
                        }));
                        if (matchCount < maxMatchCount) {
                            return
                        }
                        if (matchCount > maxMatchCount) {
                            bestMatches.length = 0;
                            maxMatchCount = matchCount
                        }
                        bestMatches.push(itemSrc)
                    }));
                    return bestMatches
                };
                var match = function(value, targetValue) {
                    if (Array.isArray(value) && Array.isArray(targetValue)) {
                        var mismatch = false;
                        (0, _iterator.each)(value, (function(index, valueItem) {
                            if (valueItem !== targetValue[index]) {
                                mismatch = true;
                                return false
                            }
                        }));
                        if (mismatch) {
                            return false
                        }
                        return true
                    }
                    if (value === targetValue) {
                        return true
                    }
                    return false
                };
                var splitPair = function(raw) {
                    var _raw$x, _raw$y;
                    switch ((0, _type.type)(raw)) {
                        case "string":
                            return raw.split(/\s+/, 2);
                        case "object":
                            return [null !== (_raw$x = raw.x) && void 0 !== _raw$x ? _raw$x : raw.h, null !== (_raw$y = raw.y) && void 0 !== _raw$y ? _raw$y : raw.v];
                        case "number":
                            return [raw];
                        case "array":
                            return raw;
                        default:
                            return null
                    }
                };
                exports.splitPair = splitPair;
                exports.normalizeKey = function(id) {
                    var key = (0, _type.isString)(id) ? id : id.toString();
                    var arr = key.match(/[^a-zA-Z0-9_]/g);
                    arr && (0, _iterator.each)(arr, (function(_, sign) {
                        key = key.replace(sign, "__" + sign.charCodeAt() + "__")
                    }));
                    return key
                };
                exports.denormalizeKey = function(key) {
                    var arr = key.match(/__\d+__/g);
                    arr && arr.forEach((function(char) {
                        var charCode = parseInt(char.replace("__", ""));
                        key = key.replace(char, String.fromCharCode(charCode))
                    }));
                    return key
                };
                exports.pairToObject = function(raw, preventRound) {
                    var pair = splitPair(raw);
                    var h = preventRound ? parseFloat(pair && pair[0]) : parseInt(pair && pair[0], 10);
                    var v = preventRound ? parseFloat(pair && pair[1]) : parseInt(pair && pair[1], 10);
                    if (!isFinite(h)) {
                        h = 0
                    }
                    if (!isFinite(v)) {
                        v = h
                    }
                    return {
                        h: h,
                        v: v
                    }
                };
                exports.getKeyHash = function(key) {
                    if (key instanceof _guid.default) {
                        return key.toString()
                    } else if ((0, _type.isObject)(key) || Array.isArray(key)) {
                        try {
                            var keyHash = JSON.stringify(key);
                            return "{}" === keyHash ? key : keyHash
                        } catch (e) {
                            return key
                        }
                    }
                    return key
                };
                exports.escapeRegExp = function(string) {
                    return string.replace(/[[\]{}\-()*+?.\\^$|\s]/g, "\\$&")
                };
                exports.applyServerDecimalSeparator = function(value) {
                    var separator = (0, _config.default)().serverDecimalSeparator;
                    if ((0, _type.isDefined)(value)) {
                        value = value.toString().replace(".", separator)
                    }
                    return value
                };
                exports.noop = function() {};
                exports.asyncNoop = function() {
                    return (new _deferred.Deferred).resolve().promise()
                };
                exports.grep = function(elements, checkFunction, invert) {
                    var result = [];
                    var check;
                    var expectedCheck = !invert;
                    for (var i = 0; i < elements.length; i++) {
                        check = !!checkFunction(elements[i], i);
                        if (check === expectedCheck) {
                            result.push(elements[i])
                        }
                    }
                    return result
                };
                var arraysEqualByValue = function(array1, array2, depth) {
                    if (array1.length !== array2.length) {
                        return false
                    }
                    for (var i = 0; i < array1.length; i++) {
                        if (!equalByValue(array1[i], array2[i], depth + 1)) {
                            return false
                        }
                    }
                    return true
                };
                var objectsEqualByValue = function(object1, object2, depth, strict) {
                    for (var propertyName in object1) {
                        if (Object.prototype.hasOwnProperty.call(object1, propertyName) && !equalByValue(object1[propertyName], object2[propertyName], depth + 1, strict)) {
                            return false
                        }
                    }
                    for (var _propertyName in object2) {
                        if (!(_propertyName in object1)) {
                            return false
                        }
                    }
                    return true
                };
                var equalByValue = function(object1, object2) {
                    var depth = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : 0;
                    var strict = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : true;
                    object1 = (0, _data.toComparable)(object1, true);
                    object2 = (0, _data.toComparable)(object2, true);
                    var comparisonResult = strict ? object1 === object2 : object1 == object2;
                    if (comparisonResult || depth >= 3) {
                        return true
                    }
                    if ((0, _type.isObject)(object1) && (0, _type.isObject)(object2)) {
                        return objectsEqualByValue(object1, object2, depth, strict)
                    } else if (Array.isArray(object1) && Array.isArray(object2)) {
                        return arraysEqualByValue(object1, object2, depth)
                    }
                    return false
                };
                exports.equalByValue = equalByValue
            },
        49036:
            /*!**********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/comparator.js ***!
              \**********************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.equals = void 0;
                var _dom_adapter = (obj = __webpack_require__( /*! ../dom_adapter */ 73349), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _data = __webpack_require__( /*! ./data */ 47617);
                var _type = __webpack_require__( /*! ./type */ 35922);

                function _typeof(obj) {
                    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj) {
                        return typeof obj
                    } : function(obj) {
                        return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                    }, _typeof(obj)
                }
                exports.equals = function(oldValue, newValue) {
                    oldValue = (0, _data.toComparable)(oldValue, true);
                    newValue = (0, _data.toComparable)(newValue, true);
                    if (oldValue && newValue && (0, _type.isRenderer)(oldValue) && (0, _type.isRenderer)(newValue)) {
                        return newValue.is(oldValue)
                    }
                    var oldValueIsNaN = oldValue !== oldValue;
                    var newValueIsNaN = newValue !== newValue;
                    if (oldValueIsNaN && newValueIsNaN) {
                        return true
                    }
                    if (0 === oldValue && 0 === newValue) {
                        return function(oldValue, newValue) {
                            return 1 / oldValue === 1 / newValue
                        }(oldValue, newValue)
                    }
                    if (null === oldValue || "object" !== _typeof(oldValue) || _dom_adapter.default.isElementNode(oldValue)) {
                        return oldValue === newValue
                    }
                    return false
                }
            },
        30869:
            /*!*******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/console.js ***!
              \*******************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.logger = exports.debug = void 0;
                var _type = __webpack_require__( /*! ./type */ 35922);
                var noop = function() {};
                var getConsoleMethod = function(method) {
                    if ("undefined" === typeof console || !(0, _type.isFunction)(console[method])) {
                        return noop
                    }
                    return console[method].bind(console)
                };
                var logger = {
                    info: getConsoleMethod("info"),
                    warn: getConsoleMethod("warn"),
                    error: getConsoleMethod("error")
                };
                exports.logger = logger;
                var debug = function() {
                    function assert(condition, message) {
                        if (!condition) {
                            throw new Error(message)
                        }
                    }
                    return {
                        assert: assert,
                        assertParam: function(parameter, message) {
                            assert(null !== parameter && void 0 !== parameter, message)
                        }
                    }
                }();
                exports.debug = debug
            },
        47617:
            /*!****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/data.js ***!
              \****************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.toComparable = exports.getPathParts = exports.compileSetter = exports.compileGetter = void 0;
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../errors */ 17381));
                var _class = _interopRequireDefault(__webpack_require__( /*! ../class */ 38377));
                var _object = __webpack_require__( /*! ./object */ 48013);
                var _type = __webpack_require__( /*! ./type */ 35922);
                var _iterator = __webpack_require__( /*! ./iterator */ 95479);
                var _variable_wrapper = _interopRequireDefault(__webpack_require__( /*! ./variable_wrapper */ 26974));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var unwrapVariable = _variable_wrapper.default.unwrap;
                var isWrapped = _variable_wrapper.default.isWrapped;
                var assign = _variable_wrapper.default.assign;
                var getPathParts = function(name) {
                    return (expr = name, expr.replace(/\[/g, ".").replace(/\]/g, "")).split(".");
                    var expr
                };
                exports.getPathParts = getPathParts;
                var assignPropValue = function(obj, propName, value, options) {
                    if ("this" === propName) {
                        throw new _errors.default.Error("E4016")
                    }
                    var propValue = obj[propName];
                    if (options.unwrapObservables && isWrapped(propValue)) {
                        assign(propValue, value)
                    } else {
                        obj[propName] = value
                    }
                };
                var prepareOptions = function(options) {
                    options = options || {};
                    options.unwrapObservables = void 0 !== options.unwrapObservables ? options.unwrapObservables : true;
                    return options
                };

                function unwrap(value, options) {
                    return options.unwrapObservables ? unwrapVariable(value) : value
                }
                var compileGetter = function(expr) {
                    if (arguments.length > 1) {
                        expr = [].slice.call(arguments)
                    }
                    if (!expr || "this" === expr) {
                        return function(obj) {
                            return obj
                        }
                    }
                    if ("string" === typeof expr) {
                        var path = getPathParts(expr);
                        return function(obj, options) {
                            options = prepareOptions(options);
                            var functionAsIs = options.functionsAsIs;
                            var hasDefaultValue = "defaultValue" in options;
                            var current = unwrap(obj, options);
                            for (var i = 0; i < path.length; i++) {
                                if (!current) {
                                    if (null == current && hasDefaultValue) {
                                        return options.defaultValue
                                    }
                                    break
                                }
                                var pathPart = path[i];
                                if (hasDefaultValue && (0, _type.isObject)(current) && !(pathPart in current)) {
                                    return options.defaultValue
                                }
                                var next = unwrap(current[pathPart], options);
                                if (!functionAsIs && (0, _type.isFunction)(next)) {
                                    next = next.call(current)
                                }
                                current = next
                            }
                            return current
                        }
                    }
                    if (Array.isArray(expr)) {
                        return combineGetters(expr)
                    }
                    if ((0, _type.isFunction)(expr)) {
                        return expr
                    }
                };
                exports.compileGetter = compileGetter;

                function combineGetters(getters) {
                    var compiledGetters = {};
                    for (var i = 0, l = getters.length; i < l; i++) {
                        var getter = getters[i];
                        compiledGetters[getter] = compileGetter(getter)
                    }
                    return function(obj, options) {
                        var result;
                        (0, _iterator.each)(compiledGetters, (function(name) {
                            var value = this(obj, options);
                            if (void 0 === value) {
                                return
                            }
                            var current = result || (result = {});
                            var path = name.split(".");
                            var last = path.length - 1;
                            for (var _i = 0; _i < last; _i++) {
                                var pathItem = path[_i];
                                if (!(pathItem in current)) {
                                    current[pathItem] = {}
                                }
                                current = current[pathItem]
                            }
                            current[path[last]] = value
                        }));
                        return result
                    }
                }
                var ensurePropValueDefined = function(obj, propName, value, options) {
                    if ((0, _type.isDefined)(value)) {
                        return value
                    }
                    var newValue = {};
                    assignPropValue(obj, propName, newValue, options);
                    return newValue
                };
                exports.compileSetter = function(expr) {
                    expr = getPathParts(expr || "this");
                    var lastLevelIndex = expr.length - 1;
                    return function(obj, value, options) {
                        options = prepareOptions(options);
                        var currentValue = unwrap(obj, options);
                        expr.forEach((function(propertyName, levelIndex) {
                            var propertyValue = function(obj, propName, options) {
                                options = options || {};
                                if ("this" === propName) {
                                    return unwrap(obj, options)
                                }
                                return unwrap(obj[propName], options)
                            }(currentValue, propertyName, options);
                            var isPropertyFunc = !options.functionsAsIs && (0, _type.isFunction)(propertyValue) && !isWrapped(propertyValue);
                            if (levelIndex === lastLevelIndex) {
                                if (options.merge && (0, _type.isPlainObject)(value) && (!(0, _type.isDefined)(propertyValue) || (0, _type.isPlainObject)(propertyValue))) {
                                    propertyValue = ensurePropValueDefined(currentValue, propertyName, propertyValue, options);
                                    (0, _object.deepExtendArraySafe)(propertyValue, value, false, true)
                                } else if (isPropertyFunc) {
                                    currentValue[propertyName](value)
                                } else {
                                    assignPropValue(currentValue, propertyName, value, options)
                                }
                            } else {
                                propertyValue = ensurePropValueDefined(currentValue, propertyName, propertyValue, options);
                                if (isPropertyFunc) {
                                    propertyValue = propertyValue.call(currentValue)
                                }
                                currentValue = propertyValue
                            }
                        }))
                    }
                };
                exports.toComparable = function(value, caseSensitive) {
                    if (value instanceof Date) {
                        return value.getTime()
                    }
                    if (value && value instanceof _class.default && value.valueOf) {
                        return value.valueOf()
                    }
                    if (!caseSensitive && "string" === typeof value) {
                        return value.toLowerCase()
                    }
                    return value
                }
            },
        91198:
            /*!****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/date.js ***!
              \****************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _type = __webpack_require__( /*! ./type */ 35922);
                var _math = __webpack_require__( /*! ./math */ 60810);
                var _iterator = __webpack_require__( /*! ./iterator */ 95479);
                var _inflector = __webpack_require__( /*! ./inflector */ 78008);

                function _construct(Parent, args, Class) {
                    if (_isNativeReflectConstruct()) {
                        _construct = Reflect.construct.bind()
                    } else {
                        _construct = function(Parent, args, Class) {
                            var a = [null];
                            a.push.apply(a, args);
                            var Constructor = Function.bind.apply(Parent, a);
                            var instance = new Constructor;
                            if (Class) {
                                _setPrototypeOf(instance, Class.prototype)
                            }
                            return instance
                        }
                    }
                    return _construct.apply(null, arguments)
                }

                function _isNativeReflectConstruct() {
                    if ("undefined" === typeof Reflect || !Reflect.construct) {
                        return false
                    }
                    if (Reflect.construct.sham) {
                        return false
                    }
                    if ("function" === typeof Proxy) {
                        return true
                    }
                    try {
                        Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], (function() {})));
                        return true
                    } catch (e) {
                        return false
                    }
                }

                function _setPrototypeOf(o, p) {
                    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(o, p) {
                        o.__proto__ = p;
                        return o
                    };
                    return _setPrototypeOf(o, p)
                }
                var dateUnitIntervals = ["millisecond", "second", "minute", "hour", "day", "week", "month", "quarter", "year"];
                var toMilliseconds = function toMilliseconds(value) {
                    switch (value) {
                        case "millisecond":
                            return 1;
                        case "second":
                            return 1e3 * toMilliseconds("millisecond");
                        case "minute":
                            return 60 * toMilliseconds("second");
                        case "hour":
                            return 60 * toMilliseconds("minute");
                        case "day":
                            return 24 * toMilliseconds("hour");
                        case "week":
                            return 7 * toMilliseconds("day");
                        case "month":
                            return 30 * toMilliseconds("day");
                        case "quarter":
                            return 3 * toMilliseconds("month");
                        case "year":
                            return 365 * toMilliseconds("day");
                        default:
                            return 0
                    }
                };
                var convertMillisecondsToDateUnits = function(value) {
                    var i;
                    var dateUnitCount;
                    var dateUnitInterval;
                    var dateUnitIntervals = ["millisecond", "second", "minute", "hour", "day", "month", "year"];
                    var result = {};
                    for (i = dateUnitIntervals.length - 1; i >= 0; i--) {
                        dateUnitInterval = dateUnitIntervals[i];
                        dateUnitCount = Math.floor(value / toMilliseconds(dateUnitInterval));
                        if (dateUnitCount > 0) {
                            result[dateUnitInterval + "s"] = dateUnitCount;
                            value -= convertDateUnitToMilliseconds(dateUnitInterval, dateUnitCount)
                        }
                    }
                    return result
                };

                function convertDateUnitToMilliseconds(dateUnit, count) {
                    return toMilliseconds(dateUnit) * count
                }

                function getDateUnitInterval(tickInterval) {
                    var maxInterval = -1;
                    var i;
                    if ((0, _type.isString)(tickInterval)) {
                        return tickInterval
                    }
                    if ((0, _type.isObject)(tickInterval)) {
                        (0, _iterator.each)(tickInterval, (function(key, value) {
                            for (i = 0; i < dateUnitIntervals.length; i++) {
                                if (value && (key === dateUnitIntervals[i] + "s" || key === dateUnitIntervals[i]) && maxInterval < i) {
                                    maxInterval = i
                                }
                            }
                        }));
                        return dateUnitIntervals[maxInterval]
                    }
                    return ""
                }
                var tickIntervalToFormatMap = {
                    millisecond: "millisecond",
                    second: "longtime",
                    minute: "shorttime",
                    hour: "shorttime",
                    day: "day",
                    week: "day",
                    month: "month",
                    quarter: "quarter",
                    year: "year"
                };
                var getQuarter = function(month) {
                    return Math.floor(month / 3)
                };
                var getFirstQuarterMonth = function(month) {
                    return 3 * getQuarter(month)
                };

                function correctDateWithUnitBeginning(date, dateInterval, withCorrection, firstDayOfWeek) {
                    date = new Date(date.getTime());
                    var oldDate = new Date(date.getTime());
                    var firstQuarterMonth;
                    var month;
                    var dateUnitInterval = getDateUnitInterval(dateInterval);
                    switch (dateUnitInterval) {
                        case "second":
                            date = new Date(1e3 * Math.floor(oldDate.getTime() / 1e3));
                            break;
                        case "minute":
                            date = new Date(6e4 * Math.floor(oldDate.getTime() / 6e4));
                            break;
                        case "hour":
                            date = new Date(36e5 * Math.floor(oldDate.getTime() / 36e5));
                            break;
                        case "year":
                            date.setMonth(0);
                        case "month":
                            date.setDate(1);
                        case "day":
                            date.setHours(0, 0, 0, 0);
                            break;
                        case "week":
                            date = getFirstWeekDate(date, firstDayOfWeek || 0);
                            date.setHours(0, 0, 0, 0);
                            break;
                        case "quarter":
                            firstQuarterMonth = getFirstQuarterMonth(date.getMonth());
                            month = date.getMonth();
                            date.setDate(1);
                            date.setHours(0, 0, 0, 0);
                            if (month !== firstQuarterMonth) {
                                date.setMonth(firstQuarterMonth)
                            }
                    }
                    if (withCorrection && "hour" !== dateUnitInterval && "minute" !== dateUnitInterval && "second" !== dateUnitInterval) {
                        fixTimezoneGap(oldDate, date)
                    }
                    return date
                }

                function trimTime(date) {
                    return correctDateWithUnitBeginning(date, "day")
                }

                function addDateInterval(value, interval, dir) {
                    var result = new Date(value.getTime());
                    var intervalObject = (0, _type.isString)(interval) ? getDateIntervalByString(interval.toLowerCase()) : (0, _type.isNumeric)(interval) ? convertMillisecondsToDateUnits(interval) : interval;
                    if (intervalObject.years) {
                        result.setFullYear(result.getFullYear() + intervalObject.years * dir)
                    }
                    if (intervalObject.quarters) {
                        result.setMonth(result.getMonth() + 3 * intervalObject.quarters * dir)
                    }
                    if (intervalObject.months) {
                        result.setMonth(result.getMonth() + intervalObject.months * dir)
                    }
                    if (intervalObject.weeks) {
                        result.setDate(result.getDate() + 7 * intervalObject.weeks * dir)
                    }
                    if (intervalObject.days) {
                        result.setDate(result.getDate() + intervalObject.days * dir)
                    }
                    if (intervalObject.hours) {
                        result.setTime(result.getTime() + 36e5 * intervalObject.hours * dir)
                    }
                    if (intervalObject.minutes) {
                        result.setTime(result.getTime() + 6e4 * intervalObject.minutes * dir)
                    }
                    if (intervalObject.seconds) {
                        result.setTime(result.getTime() + 1e3 * intervalObject.seconds * dir)
                    }
                    if (intervalObject.milliseconds) {
                        result.setTime(result.getTime() + intervalObject.milliseconds * dir)
                    }
                    return result
                }
                var addInterval = function(value, interval, isNegative) {
                    var dir = isNegative ? -1 : 1;
                    return (0, _type.isDate)(value) ? addDateInterval(value, interval, dir) : (0, _math.adjust)(value + interval * dir, interval)
                };

                function getLastMonthDay(date) {
                    var resultDate = createDateWithFullYear(date.getFullYear(), date.getMonth() + 1, 0);
                    return resultDate.getDate()
                }

                function getDateIntervalByString(intervalString) {
                    var result = {};
                    switch (intervalString) {
                        case "year":
                            result.years = 1;
                            break;
                        case "month":
                            result.months = 1;
                            break;
                        case "quarter":
                            result.months = 3;
                            break;
                        case "week":
                            result.weeks = 1;
                            break;
                        case "day":
                            result.days = 1;
                            break;
                        case "hour":
                            result.hours = 1;
                            break;
                        case "minute":
                            result.minutes = 1;
                            break;
                        case "second":
                            result.seconds = 1;
                            break;
                        case "millisecond":
                            result.milliseconds = 1
                    }
                    return result
                }

                function sameMonthAndYear(date1, date2) {
                    return sameYear(date1, date2) && date1.getMonth() === date2.getMonth()
                }

                function sameYear(date1, date2) {
                    return date1 && date2 && date1.getFullYear() === date2.getFullYear()
                }

                function getFirstDecadeInCentury(date) {
                    return date && date.getFullYear() - date.getFullYear() % 100
                }

                function getFirstYearInDecade(date) {
                    return date && date.getFullYear() - date.getFullYear() % 10
                }

                function getFirstWeekDate(date, firstDayOfWeek) {
                    var delta = (date.getDay() - firstDayOfWeek + 7) % 7;
                    var result = new Date(date);
                    result.setDate(date.getDate() - delta);
                    return result
                }

                function normalizeDate(date, min, max) {
                    var normalizedDate = date;
                    if (!(0, _type.isDefined)(date)) {
                        return date
                    }
                    if ((0, _type.isDefined)(min) && date < min) {
                        normalizedDate = min
                    }
                    if ((0, _type.isDefined)(max) && date > max) {
                        normalizedDate = max
                    }
                    return normalizedDate
                }

                function fixTimezoneGap(oldDate, newDate) {
                    if (!(0, _type.isDefined)(oldDate)) {
                        return
                    }
                    var diff = newDate.getHours() - oldDate.getHours();
                    if (0 === diff) {
                        return
                    }
                    var sign = 1 === diff || -23 === diff ? -1 : 1;
                    var trial = new Date(newDate.getTime() + 36e5 * sign);
                    if (sign > 0 || trial.getDate() === newDate.getDate()) {
                        newDate.setTime(trial.getTime())
                    }
                }

                function getTimezonesDifference(min, max) {
                    return 60 * (max.getTimezoneOffset() - min.getTimezoneOffset()) * 1e3
                }
                var createDateWithFullYear = function(year) {
                    var result = _construct(Date, Array.prototype.slice.call(arguments));
                    result.setFullYear(year);
                    return result
                };
                var dateUtils = {
                    dateUnitIntervals: dateUnitIntervals,
                    convertMillisecondsToDateUnits: convertMillisecondsToDateUnits,
                    dateToMilliseconds: function(tickInterval) {
                        var milliseconds = 0;
                        if ((0, _type.isObject)(tickInterval)) {
                            (0, _iterator.each)(tickInterval, (function(key, value) {
                                milliseconds += convertDateUnitToMilliseconds(key.substr(0, key.length - 1), value)
                            }))
                        }
                        if ((0, _type.isString)(tickInterval)) {
                            milliseconds = convertDateUnitToMilliseconds(tickInterval, 1)
                        }
                        return milliseconds
                    },
                    getNextDateUnit: function(unit, withWeeks) {
                        var interval = getDateUnitInterval(unit);
                        switch (interval) {
                            case "millisecond":
                                return "second";
                            case "second":
                                return "minute";
                            case "minute":
                                return "hour";
                            case "hour":
                                return "day";
                            case "day":
                                return withWeeks ? "week" : "month";
                            case "week":
                                return "month";
                            case "month":
                                return "quarter";
                            case "quarter":
                            case "year":
                                return "year";
                            default:
                                return 0
                        }
                    },
                    convertDateUnitToMilliseconds: convertDateUnitToMilliseconds,
                    getDateUnitInterval: getDateUnitInterval,
                    getDateFormatByTickInterval: function(tickInterval) {
                        return tickIntervalToFormatMap[getDateUnitInterval(tickInterval)] || ""
                    },
                    getDatesDifferences: function(date1, date2) {
                        var counter = 0;
                        var differences = {
                            year: date1.getFullYear() !== date2.getFullYear(),
                            month: date1.getMonth() !== date2.getMonth(),
                            day: date1.getDate() !== date2.getDate(),
                            hour: date1.getHours() !== date2.getHours(),
                            minute: date1.getMinutes() !== date2.getMinutes(),
                            second: date1.getSeconds() !== date2.getSeconds(),
                            millisecond: date1.getMilliseconds() !== date2.getMilliseconds()
                        };
                        (0, _iterator.each)(differences, (function(key, value) {
                            if (value) {
                                counter++
                            }
                        }));
                        if (0 === counter && 0 !== getTimezonesDifference(date1, date2)) {
                            differences.hour = true;
                            counter++
                        }
                        differences.count = counter;
                        return differences
                    },
                    correctDateWithUnitBeginning: correctDateWithUnitBeginning,
                    trimTime: trimTime,
                    setToDayEnd: function(date) {
                        var result = trimTime(date);
                        result.setDate(result.getDate() + 1);
                        return new Date(result.getTime() - 1)
                    },
                    roundDateByStartDayHour: function(date, startDayHour) {
                        var startTime = this.dateTimeFromDecimal(startDayHour);
                        var result = new Date(date);
                        if (date.getHours() === startTime.hours && date.getMinutes() < startTime.minutes || date.getHours() < startTime.hours) {
                            result.setHours(startTime.hours, startTime.minutes, 0, 0)
                        }
                        return result
                    },
                    dateTimeFromDecimal: function(number) {
                        var hours = Math.floor(number);
                        var minutes = number % 1 * 60;
                        return {
                            hours: hours,
                            minutes: minutes
                        }
                    },
                    addDateInterval: addDateInterval,
                    addInterval: addInterval,
                    getSequenceByInterval: function(min, max, interval) {
                        var intervals = [];
                        var cur;
                        intervals.push((0, _type.isDate)(min) ? new Date(min.getTime()) : min);
                        cur = min;
                        while (cur < max) {
                            cur = addInterval(cur, interval);
                            intervals.push(cur)
                        }
                        return intervals
                    },
                    getDateIntervalByString: getDateIntervalByString,
                    sameHoursAndMinutes: function(date1, date2) {
                        return date1 && date2 && date1.getHours() === date2.getHours() && date1.getMinutes() === date2.getMinutes()
                    },
                    sameDate: function(date1, date2) {
                        return sameMonthAndYear(date1, date2) && date1.getDate() === date2.getDate()
                    },
                    sameMonthAndYear: sameMonthAndYear,
                    sameMonth: sameMonthAndYear,
                    sameYear: sameYear,
                    sameDecade: function(date1, date2) {
                        if (!(0, _type.isDefined)(date1) || !(0, _type.isDefined)(date2)) {
                            return
                        }
                        var startDecadeDate1 = date1.getFullYear() - date1.getFullYear() % 10;
                        var startDecadeDate2 = date2.getFullYear() - date2.getFullYear() % 10;
                        return date1 && date2 && startDecadeDate1 === startDecadeDate2
                    },
                    sameCentury: function(date1, date2) {
                        if (!(0, _type.isDefined)(date1) || !(0, _type.isDefined)(date2)) {
                            return
                        }
                        var startCenturyDate1 = date1.getFullYear() - date1.getFullYear() % 100;
                        var startCenturyDate2 = date2.getFullYear() - date2.getFullYear() % 100;
                        return date1 && date2 && startCenturyDate1 === startCenturyDate2
                    },
                    getDifferenceInMonth: function(typeView) {
                        var difference = 1;
                        if ("year" === typeView) {
                            difference = 12
                        }
                        if ("decade" === typeView) {
                            difference = 120
                        }
                        if ("century" === typeView) {
                            difference = 1200
                        }
                        return difference
                    },
                    getDifferenceInMonthForCells: function(typeView) {
                        var difference = 1;
                        if ("decade" === typeView) {
                            difference = 12
                        }
                        if ("century" === typeView) {
                            difference = 120
                        }
                        return difference
                    },
                    getFirstYearInDecade: getFirstYearInDecade,
                    getFirstDecadeInCentury: getFirstDecadeInCentury,
                    getShortDateFormat: function() {
                        return "yyyy/MM/dd"
                    },
                    getViewFirstCellDate: function(viewType, date) {
                        if ("month" === viewType) {
                            return createDateWithFullYear(date.getFullYear(), date.getMonth(), 1)
                        }
                        if ("year" === viewType) {
                            return createDateWithFullYear(date.getFullYear(), 0, date.getDate())
                        }
                        if ("decade" === viewType) {
                            return createDateWithFullYear(getFirstYearInDecade(date), date.getMonth(), date.getDate())
                        }
                        if ("century" === viewType) {
                            return createDateWithFullYear(getFirstDecadeInCentury(date), date.getMonth(), date.getDate())
                        }
                    },
                    getViewLastCellDate: function(viewType, date) {
                        if ("month" === viewType) {
                            return createDateWithFullYear(date.getFullYear(), date.getMonth(), getLastMonthDay(date))
                        }
                        if ("year" === viewType) {
                            return createDateWithFullYear(date.getFullYear(), 11, date.getDate())
                        }
                        if ("decade" === viewType) {
                            return createDateWithFullYear(getFirstYearInDecade(date) + 9, date.getMonth(), date.getDate())
                        }
                        if ("century" === viewType) {
                            return createDateWithFullYear(getFirstDecadeInCentury(date) + 90, date.getMonth(), date.getDate())
                        }
                    },
                    getViewDown: function(typeView) {
                        switch (typeView) {
                            case "century":
                                return "decade";
                            case "decade":
                                return "year";
                            case "year":
                                return "month"
                        }
                    },
                    getViewUp: function(typeView) {
                        switch (typeView) {
                            case "month":
                                return "year";
                            case "year":
                                return "decade";
                            case "decade":
                                return "century"
                        }
                    },
                    getLastMonthDay: getLastMonthDay,
                    getLastMonthDate: function(date) {
                        if (!(0, _type.isDefined)(date)) {
                            return
                        }
                        return createDateWithFullYear(date.getFullYear(), date.getMonth() + 1, 0)
                    },
                    getFirstMonthDate: function(date) {
                        if (!(0, _type.isDefined)(date)) {
                            return
                        }
                        return createDateWithFullYear(date.getFullYear(), date.getMonth(), 1)
                    },
                    getFirstWeekDate: getFirstWeekDate,
                    normalizeDateByWeek: function(date, currentDate) {
                        var differenceInDays = dateUtils.getDatesInterval(date, currentDate, "day");
                        var resultDate = new Date(date);
                        if (differenceInDays >= 6) {
                            resultDate = new Date(resultDate.setDate(resultDate.getDate() + 7))
                        }
                        return resultDate
                    },
                    getQuarter: getQuarter,
                    getFirstQuarterMonth: getFirstQuarterMonth,
                    dateInRange: function(date, min, max, format) {
                        if ("date" === format) {
                            min = min && dateUtils.correctDateWithUnitBeginning(min, "day");
                            max = max && dateUtils.correctDateWithUnitBeginning(max, "day");
                            date = date && dateUtils.correctDateWithUnitBeginning(date, "day")
                        }
                        return normalizeDate(date, min, max) === date
                    },
                    intervalsOverlap: function(options) {
                        var firstMin = options.firstMin,
                            firstMax = options.firstMax,
                            secondMin = options.secondMin,
                            secondMax = options.secondMax;
                        return firstMin <= secondMin && secondMin <= firstMax || firstMin > secondMin && firstMin < secondMax || firstMin < secondMax && firstMax > secondMax
                    },
                    roundToHour: function(date) {
                        var result = new Date(date.getTime());
                        result.setHours(result.getHours() + 1);
                        result.setMinutes(0);
                        return result
                    },
                    normalizeDate: normalizeDate,
                    getViewMinBoundaryDate: function(viewType, date) {
                        var resultDate = createDateWithFullYear(date.getFullYear(), date.getMonth(), 1);
                        if ("month" === viewType) {
                            return resultDate
                        }
                        resultDate.setMonth(0);
                        if ("year" === viewType) {
                            return resultDate
                        }
                        if ("decade" === viewType) {
                            resultDate.setFullYear(getFirstYearInDecade(date))
                        }
                        if ("century" === viewType) {
                            resultDate.setFullYear(getFirstDecadeInCentury(date))
                        }
                        return resultDate
                    },
                    getViewMaxBoundaryDate: function(viewType, date) {
                        var resultDate = new Date(date);
                        resultDate.setDate(getLastMonthDay(date));
                        if ("month" === viewType) {
                            return resultDate
                        }
                        resultDate.setMonth(11);
                        resultDate.setDate(getLastMonthDay(resultDate));
                        if ("year" === viewType) {
                            return resultDate
                        }
                        if ("decade" === viewType) {
                            resultDate.setFullYear(getFirstYearInDecade(date) + 9)
                        }
                        if ("century" === viewType) {
                            resultDate.setFullYear(getFirstDecadeInCentury(date) + 99)
                        }
                        return resultDate
                    },
                    fixTimezoneGap: fixTimezoneGap,
                    getTimezonesDifference: getTimezonesDifference,
                    makeDate: function(date) {
                        return new Date(date)
                    },
                    getDatesInterval: function(startDate, endDate, intervalUnit) {
                        var delta = endDate.getTime() - startDate.getTime();
                        var millisecondCount = toMilliseconds(intervalUnit) || 1;
                        return Math.floor(delta / millisecondCount)
                    },
                    getDatesOfInterval: function(startDate, endDate, step) {
                        var result = [];
                        var currentDate = new Date(startDate.getTime());
                        while (currentDate < endDate) {
                            result.push(new Date(currentDate.getTime()));
                            currentDate = this.addInterval(currentDate, step)
                        }
                        return result
                    },
                    createDateWithFullYear: createDateWithFullYear
                };
                dateUtils.sameView = function(view, date1, date2) {
                    return dateUtils[(0, _inflector.camelize)("same " + view)](date1, date2)
                };
                var _default = dateUtils;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        69434:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/date_serialization.js ***!
              \******************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _config = _interopRequireDefault(__webpack_require__( /*! ../config */ 80209));
                var _date = __webpack_require__( /*! ../../localization/ldml/date.formatter */ 40594);
                var _default_date_names = _interopRequireDefault(__webpack_require__( /*! ../../localization/default_date_names */ 15564));
                var _type = __webpack_require__( /*! ./type */ 35922);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var ISO8601_PATTERN = /^(\d{4,})(-)?(\d{2})(-)?(\d{2})(?:T(\d{2})(:)?(\d{2})?(:)?(\d{2}(?:\.(\d{1,3})\d*)?)?)?(Z|([+-])(\d{2})(:)?(\d{2})?)?$/;
                var ISO8601_TIME_PATTERN = /^(\d{2}):(\d{2})(:(\d{2}))?$/;
                var ISO8601_PATTERN_PARTS = ["", "yyyy", "", "MM", "", "dd", "THH", "", "mm", "", "ss", ".SSS"];
                var DATE_SERIALIZATION_PATTERN = /^(\d{4})\/(\d{2})\/(\d{2})$/;
                var dateParser = function(text, skipISO8601Parsing) {
                    var result;
                    if ((0, _type.isString)(text) && !skipISO8601Parsing) {
                        result = function(text) {
                            var parts = text.match(ISO8601_PATTERN);
                            if (!parts) {
                                parts = text.match(ISO8601_TIME_PATTERN);
                                if (parts) {
                                    return new Date(0, 0, 0, getTimePart(parts[1]), getTimePart(parts[2]), getTimePart(parts[4]))
                                }
                                return
                            }
                            var year = getTimePart(parts[1]);
                            var month = --parts[3];
                            var day = parts[5];
                            var timeZoneHour = 0;
                            var timeZoneMinute = 0;
                            var correctYear = function(d) {
                                year < 100 && d.setFullYear(year);
                                return d
                            };
                            timeZoneHour = getTimePart(parts[14]);
                            timeZoneMinute = getTimePart(parts[16]);
                            if ("-" === parts[13]) {
                                timeZoneHour = -timeZoneHour;
                                timeZoneMinute = -timeZoneMinute
                            }
                            var hour = getTimePart(parts[6]) - timeZoneHour;
                            var minute = getTimePart(parts[8]) - timeZoneMinute;
                            var second = getTimePart(parts[10]);
                            var millisecond = function(part) {
                                part = part || "";
                                return getTimePart(part) * Math.pow(10, 3 - part.length)
                            }(parts[11]);
                            if (parts[12]) {
                                return correctYear(new Date(Date.UTC(year, month, day, hour, minute, second, millisecond)))
                            }
                            return correctYear(new Date(year, month, day, hour, minute, second, millisecond))
                        }(text)
                    }
                    return result || function(text) {
                        var isDefaultSerializationFormat = "yyyy/MM/dd" === getDateSerializationFormat(text);
                        var parsedValue = !(0, _type.isDate)(text) && Date.parse(text);
                        if (!parsedValue && isDefaultSerializationFormat) {
                            var parts = text.match(DATE_SERIALIZATION_PATTERN);
                            if (parts) {
                                var newDate = new Date(getTimePart(parts[1]), getTimePart(parts[2]), getTimePart(parts[3]));
                                newDate.setFullYear(getTimePart(parts[1]));
                                newDate.setMonth(getTimePart(parts[2]) - 1);
                                newDate.setDate(getTimePart(parts[3]));
                                return newDate
                            }
                        }
                        return (0, _type.isNumeric)(parsedValue) ? new Date(parsedValue) : text
                    }(text)
                };

                function getTimePart(part) {
                    return +part || 0
                }
                var getDateSerializationFormat = function(value) {
                    if ("number" === typeof value) {
                        return "number"
                    } else if ((0, _type.isString)(value)) {
                        var format;
                        if ((0, _config.default)().forceIsoDateParsing) {
                            format = function(text, useUtc) {
                                var parts = text.match(ISO8601_PATTERN);
                                var result = "";
                                if (!parts) {
                                    parts = text.match(ISO8601_TIME_PATTERN);
                                    if (parts) {
                                        return parts[3] ? "HH:mm:ss" : "HH:mm"
                                    }
                                    return
                                }
                                for (var i = 1; i < ISO8601_PATTERN_PARTS.length; i++) {
                                    if (parts[i]) {
                                        result += ISO8601_PATTERN_PARTS[i] || parts[i]
                                    }
                                }
                                if ("Z" === parts[12]) {
                                    result += "'Z'"
                                }
                                if (parts[14]) {
                                    if (parts[15]) {
                                        result += "xxx"
                                    } else if (parts[16]) {
                                        result += "xx"
                                    } else {
                                        result += "x"
                                    }
                                }
                                return result
                            }(value)
                        }
                        if (format) {
                            return format
                        } else if (value.indexOf(":") >= 0) {
                            return "yyyy/MM/dd HH:mm:ss"
                        } else {
                            return "yyyy/MM/dd"
                        }
                    } else if (value) {
                        return null
                    }
                };
                var _default = {
                    dateParser: dateParser,
                    deserializeDate: function(value) {
                        if ("number" === typeof value) {
                            return new Date(value)
                        }
                        return dateParser(value, !(0, _config.default)().forceIsoDateParsing)
                    },
                    serializeDate: function(value, serializationFormat) {
                        if (!serializationFormat) {
                            return value
                        }
                        if (!(0, _type.isDate)(value)) {
                            return null
                        }
                        if ("number" === serializationFormat) {
                            return value && value.valueOf ? value.valueOf() : null
                        }
                        return (0, _date.getFormatter)(serializationFormat, _default_date_names.default)(value)
                    },
                    getDateSerializationFormat: getDateSerializationFormat
                };
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        62754:
            /*!********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/deferred.js ***!
              \********************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.Deferred = function() {
                    return new _DeferredObj
                };
                exports.fromPromise = fromPromise;
                exports.setStrategy = function(value) {
                    _DeferredObj = value.Deferred;
                    whenFunc = value.when
                };
                exports.when = function() {
                    return whenFunc.apply(this, arguments)
                };
                var _type = __webpack_require__( /*! ../utils/type */ 35922);
                var _extend = __webpack_require__( /*! ../utils/extend */ 13306);
                var _callbacks = (obj = __webpack_require__( /*! ../utils/callbacks */ 44504), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var deferredConfig = [{
                    method: "resolve",
                    handler: "done",
                    state: "resolved"
                }, {
                    method: "reject",
                    handler: "fail",
                    state: "rejected"
                }, {
                    method: "notify",
                    handler: "progress"
                }];
                var _DeferredObj = function() {
                    var that = this;
                    this._state = "pending";
                    this._promise = {};
                    deferredConfig.forEach(function(config) {
                        var methodName = config.method;
                        this[methodName + "Callbacks"] = new _callbacks.default;
                        this[methodName] = function() {
                            return this[methodName + "With"](this._promise, arguments)
                        }.bind(this);
                        this._promise[config.handler] = function(handler) {
                            if (!handler) {
                                return this
                            }
                            var callbacks = that[methodName + "Callbacks"];
                            if (callbacks.fired()) {
                                handler.apply(that[methodName + "Context"], that[methodName + "Args"])
                            } else {
                                callbacks.add(function(context, args) {
                                    handler.apply(context, args)
                                }.bind(this))
                            }
                            return this
                        }
                    }.bind(this));
                    this._promise.always = function(handler) {
                        return this.done(handler).fail(handler)
                    };
                    this._promise.catch = function(handler) {
                        return this.then(null, handler)
                    };
                    this._promise.then = function(resolve, reject) {
                        var result = new _DeferredObj;
                        ["done", "fail"].forEach(function(method) {
                            var callback = "done" === method ? resolve : reject;
                            this[method]((function() {
                                if (!callback) {
                                    result["done" === method ? "resolve" : "reject"].apply(this, arguments);
                                    return
                                }
                                var callbackResult = callback && callback.apply(this, arguments);
                                if ((0, _type.isDeferred)(callbackResult)) {
                                    callbackResult.done(result.resolve).fail(result.reject)
                                } else if ((0, _type.isPromise)(callbackResult)) {
                                    callbackResult.then(result.resolve, result.reject)
                                } else {
                                    result.resolve.apply(this, (0, _type.isDefined)(callbackResult) ? [callbackResult] : arguments)
                                }
                            }))
                        }.bind(this));
                        return result.promise()
                    };
                    this._promise.state = function() {
                        return that._state
                    };
                    this._promise.promise = function(args) {
                        return args ? (0, _extend.extend)(args, that._promise) : that._promise
                    };
                    this._promise.promise(this)
                };
                deferredConfig.forEach((function(config) {
                    var methodName = config.method;
                    var state = config.state;
                    _DeferredObj.prototype[methodName + "With"] = function(context, args) {
                        var callbacks = this[methodName + "Callbacks"];
                        if ("pending" === this.state()) {
                            this[methodName + "Args"] = args;
                            this[methodName + "Context"] = context;
                            if (state) {
                                this._state = state
                            }
                            callbacks.fire(context, args)
                        }
                        return this
                    }
                }));

                function fromPromise(promise, context) {
                    if ((0, _type.isDeferred)(promise)) {
                        return promise
                    } else if ((0, _type.isPromise)(promise)) {
                        var d = new _DeferredObj;
                        promise.then((function() {
                            d.resolveWith.apply(d, [context].concat([
                                [].slice.call(arguments)
                            ]))
                        }), (function() {
                            d.rejectWith.apply(d, [context].concat([
                                [].slice.call(arguments)
                            ]))
                        }));
                        return d
                    }
                    return (new _DeferredObj).resolveWith(context, [promise])
                }
                var whenFunc = function() {
                    if (1 === arguments.length) {
                        return fromPromise(arguments[0])
                    }
                    var values = [].slice.call(arguments);
                    var contexts = [];
                    var resolvedCount = 0;
                    var deferred = new _DeferredObj;
                    var updateState = function(i) {
                        return function(value) {
                            contexts[i] = this;
                            values[i] = arguments.length > 1 ? [].slice.call(arguments) : value;
                            resolvedCount++;
                            if (resolvedCount === values.length) {
                                deferred.resolveWith(contexts, values)
                            }
                        }
                    };
                    for (var i = 0; i < values.length; i++) {
                        if ((0, _type.isDeferred)(values[i])) {
                            values[i].promise().done(updateState(i)).fail(deferred.reject)
                        } else {
                            resolvedCount++
                        }
                    }
                    if (resolvedCount === values.length) {
                        deferred.resolveWith(contexts, values)
                    }
                    return deferred.promise()
                }
            },
        20476:
            /*!*******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/dependency_injector.js ***!
              \*******************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = function(object) {
                    var BaseClass = _class.default.inherit(object);
                    var InjectedClass = BaseClass;
                    var instance = new InjectedClass(object);
                    var initialFields = {};
                    var injectFields = function(injectionObject, initial) {
                        (0, _iterator.each)(injectionObject, (function(key) {
                            if ((0, _type.isFunction)(instance[key])) {
                                if (initial || !object[key]) {
                                    object[key] = function() {
                                        return instance[key].apply(object, arguments)
                                    }
                                }
                            } else {
                                if (initial) {
                                    initialFields[key] = object[key]
                                }
                                object[key] = instance[key]
                            }
                        }))
                    };
                    injectFields(object, true);
                    object.inject = function(injectionObject) {
                        InjectedClass = InjectedClass.inherit(injectionObject);
                        instance = new InjectedClass;
                        injectFields(injectionObject)
                    };
                    object.resetInjection = function() {
                        (0, _extend.extend)(object, initialFields);
                        InjectedClass = BaseClass;
                        instance = new BaseClass
                    };
                    return object
                };
                var _extend = __webpack_require__( /*! ./extend */ 13306);
                var _type = __webpack_require__( /*! ./type */ 35922);
                var _iterator = __webpack_require__( /*! ./iterator */ 95479);
                var _class = (obj = __webpack_require__( /*! ../class */ 38377), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        3532:
            /*!***************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/dom.js ***!
              \***************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.resetActiveElement = exports.replaceWith = exports.normalizeTemplateElement = exports.insertBefore = exports.extractTemplateMarkup = exports.createTextElementHiddenCopy = exports.contains = exports.closestCommonParent = exports.clipboardText = exports.clearSelection = void 0;
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 73349));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 68374));
                var _iterator = __webpack_require__( /*! ./iterator */ 95479);
                var _type = __webpack_require__( /*! ./type */ 35922);
                var _window = __webpack_require__( /*! ./window */ 58201);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var window = (0, _window.getWindow)();
                exports.resetActiveElement = function() {
                    var activeElement = _dom_adapter.default.getActiveElement();
                    if (activeElement && activeElement !== _dom_adapter.default.getBody()) {
                        var _activeElement$blur;
                        null === (_activeElement$blur = activeElement.blur) || void 0 === _activeElement$blur ? void 0 : _activeElement$blur.call(activeElement)
                    }
                };
                exports.clearSelection = function() {
                    var selection = window.getSelection();
                    if (!selection) {
                        return
                    }
                    if ("Caret" === selection.type) {
                        return
                    }
                    if (selection.empty) {
                        selection.empty()
                    } else if (selection.removeAllRanges) {
                        try {
                            selection.removeAllRanges()
                        } catch (e) {}
                    }
                };
                exports.closestCommonParent = function(startTarget, endTarget) {
                    var $startTarget = (0, _renderer.default)(startTarget);
                    var $endTarget = (0, _renderer.default)(endTarget);
                    if ($startTarget[0] === $endTarget[0]) {
                        return $startTarget[0]
                    }
                    var $startParents = $startTarget.parents();
                    var $endParents = $endTarget.parents();
                    var startingParent = Math.min($startParents.length, $endParents.length);
                    for (var i = -startingParent; i < 0; i++) {
                        if ($startParents.get(i) === $endParents.get(i)) {
                            return $startParents.get(i)
                        }
                    }
                };
                exports.extractTemplateMarkup = function(element) {
                    element = (0, _renderer.default)(element);
                    var templateTag = element.length && element.filter((function() {
                        var $node = (0, _renderer.default)(this);
                        return $node.is("script[type]") && $node.attr("type").indexOf("script") < 0
                    }));
                    if (templateTag.length) {
                        return templateTag.eq(0).html()
                    } else {
                        element = (0, _renderer.default)("<div>").append(element);
                        return element.html()
                    }
                };
                exports.normalizeTemplateElement = function normalizeTemplateElement(element) {
                    var $element = (0, _type.isDefined)(element) && (element.nodeType || (0, _type.isRenderer)(element)) ? (0, _renderer.default)(element) : (0, _renderer.default)("<div>").html(element).contents();
                    if (1 === $element.length) {
                        if ($element.is("script")) {
                            $element = normalizeTemplateElement($element.html().trim())
                        } else if ($element.is("table")) {
                            $element = $element.children("tbody").contents()
                        }
                    }
                    return $element
                };
                exports.clipboardText = function(event, text) {
                    var clipboard = event.originalEvent && event.originalEvent.clipboardData || window.clipboardData;
                    if (!text) {
                        return clipboard && clipboard.getData("Text")
                    }
                    clipboard && clipboard.setData("Text", text)
                };
                exports.contains = function contains(container, element) {
                    if (!element) {
                        return false
                    }
                    if (_dom_adapter.default.isTextNode(element)) {
                        element = element.parentNode
                    }
                    if (_dom_adapter.default.isDocument(container)) {
                        return container.documentElement.contains(element)
                    }
                    if ((0, _type.isWindow)(container)) {
                        return contains(container.document, element)
                    }
                    return container.contains ? container.contains(element) : !!(element.compareDocumentPosition(container) & element.DOCUMENT_POSITION_CONTAINS)
                };
                exports.createTextElementHiddenCopy = function(element, text, options) {
                    var elementStyles = window.getComputedStyle((0, _renderer.default)(element).get(0));
                    var includePaddings = options && options.includePaddings;
                    return (0, _renderer.default)("<div>").text(text).css({
                        fontStyle: elementStyles.fontStyle,
                        fontVariant: elementStyles.fontVariant,
                        fontWeight: elementStyles.fontWeight,
                        fontSize: elementStyles.fontSize,
                        fontFamily: elementStyles.fontFamily,
                        letterSpacing: elementStyles.letterSpacing,
                        border: elementStyles.border,
                        paddingTop: includePaddings ? elementStyles.paddingTop : "",
                        paddingRight: includePaddings ? elementStyles.paddingRight : "",
                        paddingBottom: includePaddings ? elementStyles.paddingBottom : "",
                        paddingLeft: includePaddings ? elementStyles.paddingLeft : "",
                        visibility: "hidden",
                        whiteSpace: "pre",
                        position: "absolute",
                        float: "left"
                    })
                };
                var insertBefore = function(element, newElement) {
                    if (newElement) {
                        _dom_adapter.default.insertElement(element.parentNode, newElement, element)
                    }
                    return element
                };
                exports.insertBefore = insertBefore;
                exports.replaceWith = function(element, newElement) {
                    if (!(newElement && newElement[0])) {
                        return
                    }
                    if (newElement.is(element)) {
                        return element
                    }(0, _iterator.each)(newElement, (function(_, currentElement) {
                        insertBefore(element[0], currentElement)
                    }));
                    element.remove();
                    return newElement
                }
            },
        95640:
            /*!*****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/error.js ***!
              \*****************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = function(baseErrors, errors) {
                    var exports = {
                        ERROR_MESSAGES: (0, _extend.extend)(errors, baseErrors),
                        Error: function() {
                            return makeError([].slice.call(arguments))
                        },
                        log: function(id) {
                            var method = "log";
                            if (/^E\d+$/.test(id)) {
                                method = "error"
                            } else if (/^W\d+$/.test(id)) {
                                method = "warn"
                            }
                            _console.logger[method]("log" === method ? id : combineMessage([].slice.call(arguments)))
                        }
                    };

                    function combineMessage(args) {
                        var id = args[0];
                        args = args.slice(1);
                        return formatMessage(id, formatDetails(id, args))
                    }

                    function formatDetails(id, args) {
                        args = [exports.ERROR_MESSAGES[id]].concat(args);
                        return _string.format.apply(this, args).replace(/\.*\s*?$/, "")
                    }

                    function formatMessage(id, details) {
                        return _string.format.apply(this, ["{0} - {1}. See:\n{2}", id, details, getErrorUrl(id)])
                    }

                    function makeError(args) {
                        var id = args[0];
                        args = args.slice(1);
                        var details = formatDetails(id, args);
                        var url = getErrorUrl(id);
                        var message = formatMessage(id, details);
                        return (0, _extend.extend)(new Error(message), {
                            __id: id,
                            __details: details,
                            url: url
                        })
                    }

                    function getErrorUrl(id) {
                        return ERROR_URL + id
                    }
                    return exports
                };
                var _extend = __webpack_require__( /*! ./extend */ 13306);
                var _console = __webpack_require__( /*! ./console */ 30869);
                var _string = __webpack_require__( /*! ./string */ 68752);
                var _version = __webpack_require__( /*! ../version */ 36739);
                var ERROR_URL = "http://js.devexpress.com/error/" + _version.version.split(".").slice(0, 2).join("_") + "/";
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        13306:
            /*!******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/extend.js ***!
              \******************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.extendFromObject = exports.extend = void 0;
                var _type = __webpack_require__( /*! ./type */ 35922);
                exports.extendFromObject = function(target, source, overrideExistingValues) {
                    target = target || {};
                    for (var prop in source) {
                        if (Object.prototype.hasOwnProperty.call(source, prop)) {
                            var value = source[prop];
                            if (!(prop in target) || overrideExistingValues) {
                                target[prop] = value
                            }
                        }
                    }
                    return target
                };
                exports.extend = function extend(target) {
                    target = target || {};
                    var i = 1;
                    var deep = false;
                    if ("boolean" === typeof target) {
                        deep = target;
                        target = arguments[1] || {};
                        i++
                    }
                    for (; i < arguments.length; i++) {
                        var source = arguments[i];
                        if (null == source) {
                            continue
                        }
                        for (var key in source) {
                            var targetValue = target[key];
                            var sourceValue = source[key];
                            var sourceValueIsArray = false;
                            var clone = void 0;
                            if ("__proto__" === key || "constructor" === key || target === sourceValue) {
                                continue
                            }
                            if (deep && sourceValue && ((0, _type.isPlainObject)(sourceValue) || (sourceValueIsArray = Array.isArray(sourceValue)))) {
                                if (sourceValueIsArray) {
                                    clone = targetValue && Array.isArray(targetValue) ? targetValue : []
                                } else {
                                    clone = targetValue && (0, _type.isPlainObject)(targetValue) ? targetValue : {}
                                }
                                target[key] = extend(deep, clone, sourceValue)
                            } else if (void 0 !== sourceValue) {
                                target[key] = sourceValue
                            }
                        }
                    }
                    return target
                }
            },
        61371:
            /*!***********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/html_parser.js ***!
              \***********************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.parseHTML = exports.isTablePart = void 0;
                var _dom_adapter = (obj = __webpack_require__( /*! ../dom_adapter */ 73349), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;

                function _toConsumableArray(arr) {
                    return function(arr) {
                        if (Array.isArray(arr)) {
                            return _arrayLikeToArray(arr)
                        }
                    }(arr) || function(iter) {
                        if ("undefined" !== typeof Symbol && null != iter[Symbol.iterator] || null != iter["@@iterator"]) {
                            return Array.from(iter)
                        }
                    }(arr) || function(o, minLen) {
                        if (!o) {
                            return
                        }
                        if ("string" === typeof o) {
                            return _arrayLikeToArray(o, minLen)
                        }
                        var n = Object.prototype.toString.call(o).slice(8, -1);
                        if ("Object" === n && o.constructor) {
                            n = o.constructor.name
                        }
                        if ("Map" === n || "Set" === n) {
                            return Array.from(o)
                        }
                        if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                            return _arrayLikeToArray(o, minLen)
                        }
                    }(arr) || function() {
                        throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                    }()
                }

                function _arrayLikeToArray(arr, len) {
                    if (null == len || len > arr.length) {
                        len = arr.length
                    }
                    for (var i = 0, arr2 = new Array(len); i < len; i++) {
                        arr2[i] = arr[i]
                    }
                    return arr2
                }
                var isTagName = /<([a-z][^/\0>\x20\t\r\n\f]+)/i;
                var tagWrappers = {
                    default: {
                        tagsCount: 0,
                        startTags: "",
                        endTags: ""
                    },
                    thead: {
                        tagsCount: 1,
                        startTags: "<table>",
                        endTags: "</table>"
                    },
                    td: {
                        tagsCount: 3,
                        startTags: "<table><tbody><tr>",
                        endTags: "</tr></tbody></table>"
                    },
                    col: {
                        tagsCount: 2,
                        startTags: "<table><colgroup>",
                        endTags: "</colgroup></table>"
                    },
                    tr: {
                        tagsCount: 2,
                        startTags: "<table><tbody>",
                        endTags: "</tbody></table>"
                    }
                };
                tagWrappers.tbody = tagWrappers.colgroup = tagWrappers.caption = tagWrappers.tfoot = tagWrappers.thead;
                tagWrappers.th = tagWrappers.td;
                exports.parseHTML = function(html) {
                    if ("string" !== typeof html) {
                        return null
                    }
                    var fragment = _dom_adapter.default.createDocumentFragment();
                    var container = fragment.appendChild(_dom_adapter.default.createElement("div"));
                    var tags = isTagName.exec(html);
                    var firstRootTag = tags && tags[1].toLowerCase();
                    var tagWrapper = tagWrappers[firstRootTag] || tagWrappers.default;
                    container.innerHTML = tagWrapper.startTags + html + tagWrapper.endTags;
                    for (var i = 0; i < tagWrapper.tagsCount; i++) {
                        container = container.lastChild
                    }
                    return _toConsumableArray(container.childNodes)
                };
                exports.isTablePart = function(html) {
                    var tags = isTagName.exec(html);
                    return tags && tags[1] in tagWrappers
                }
            },
        44899:
            /*!****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/icon.js ***!
              \****************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.getImageSourceType = exports.getImageContainer = void 0;
                var _renderer = (obj = __webpack_require__( /*! ../../core/renderer */ 68374), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var getImageSourceType = function(source) {
                    if (!source || "string" !== typeof source) {
                        return false
                    }
                    if (/^\s*<svg[^>]*>(.|\r?\n)*?<\/svg>\s*$/i.test(source)) {
                        return "svg"
                    }
                    if (/data:.*base64|\.|[^<\s]\//.test(source)) {
                        return "image"
                    }
                    if (/^[\w-_]+$/.test(source)) {
                        return "dxIcon"
                    }
                    if (/^\s?([\w-_]\s?)+$/.test(source)) {
                        return "fontIcon"
                    }
                    return false
                };
                exports.getImageSourceType = getImageSourceType;
                exports.getImageContainer = function(source) {
                    switch (getImageSourceType(source)) {
                        case "image":
                            return (0, _renderer.default)("<img>").attr("src", source).addClass("dx-icon");
                        case "fontIcon":
                            return (0, _renderer.default)("<i>").addClass("".concat("dx-icon", " ").concat(source));
                        case "dxIcon":
                            return (0, _renderer.default)("<i>").addClass("".concat("dx-icon", " ").concat("dx-icon", "-").concat(source));
                        case "svg":
                            return (0, _renderer.default)("<i>").addClass("".concat("dx-icon", " ").concat("dx-svg-icon")).append(source);
                        default:
                            return null
                    }
                }
            },
        78008:
            /*!*********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/inflector.js ***!
              \*********************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.underscore = exports.titleize = exports.humanize = exports.dasherize = exports.captionize = exports.camelize = void 0;
                var _iterator = __webpack_require__( /*! ./iterator */ 95479);
                var _normalize = function(text) {
                    if (void 0 === text || null === text) {
                        return ""
                    }
                    return String(text)
                };
                var _upperCaseFirst = function(text) {
                    return _normalize(text).charAt(0).toUpperCase() + text.substr(1)
                };
                var _chop = function(text) {
                    return _normalize(text).replace(/([a-z\d])([A-Z])/g, "$1 $2").split(/[\s_-]+/)
                };
                var dasherize = function(text) {
                    return (0, _iterator.map)(_chop(text), (function(p) {
                        return p.toLowerCase()
                    })).join("-")
                };
                exports.dasherize = dasherize;
                exports.underscore = function(text) {
                    return dasherize(text).replace(/-/g, "_")
                };
                exports.camelize = function(text, upperFirst) {
                    return (0, _iterator.map)(_chop(text), (function(p, i) {
                        p = p.toLowerCase();
                        if (upperFirst || i > 0) {
                            p = _upperCaseFirst(p)
                        }
                        return p
                    })).join("")
                };
                exports.humanize = function(text) {
                    return _upperCaseFirst(dasherize(text).replace(/-/g, " "))
                };
                exports.titleize = function(text) {
                    return (0, _iterator.map)(_chop(text), (function(p) {
                        return _upperCaseFirst(p.toLowerCase())
                    })).join(" ")
                };
                var DIGIT_CHARS = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"];
                exports.captionize = function(name) {
                    var captionList = [];
                    var i;
                    var char;
                    var isPrevCharNewWord = false;
                    var isNewWord = false;
                    for (i = 0; i < name.length; i++) {
                        char = name.charAt(i);
                        isNewWord = char === char.toUpperCase() && "-" !== char && ")" !== char && "/" !== char || char in DIGIT_CHARS;
                        if ("_" === char || "." === char) {
                            char = " ";
                            isNewWord = true
                        } else if (0 === i) {
                            char = char.toUpperCase();
                            isNewWord = true
                        } else if (!isPrevCharNewWord && isNewWord) {
                            if (captionList.length > 0) {
                                captionList.push(" ")
                            }
                        }
                        captionList.push(char);
                        isPrevCharNewWord = isNewWord
                    }
                    return captionList.join("")
                }
            },
        95479:
            /*!********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/iterator.js ***!
              \********************************************************************/
            function(__unused_webpack_module, exports) {
                exports.reverseEach = exports.map = exports.each = void 0;
                exports.map = function(values, callback) {
                    if (Array.isArray(values)) {
                        return values.map(callback)
                    }
                    var result = [];
                    for (var key in values) {
                        result.push(callback(values[key], key))
                    }
                    return result
                };
                exports.each = function(values, callback) {
                    if (!values) {
                        return
                    }
                    if ("length" in values) {
                        for (var i = 0; i < values.length; i++) {
                            if (false === callback.call(values[i], i, values[i])) {
                                break
                            }
                        }
                    } else {
                        for (var key in values) {
                            if (false === callback.call(values[key], key, values[key])) {
                                break
                            }
                        }
                    }
                    return values
                };
                exports.reverseEach = function(array, callback) {
                    if (!array || !("length" in array) || 0 === array.length) {
                        return
                    }
                    for (var i = array.length - 1; i >= 0; i--) {
                        if (false === callback.call(array[i], i, array[i])) {
                            break
                        }
                    }
                }
            },
        88933:
            /*!******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/locker.js ***!
              \******************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _errors = (obj = __webpack_require__( /*! ../errors */ 17381), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _default = function() {
                    var info = {};
                    var currentCount = function(lockName) {
                        return info[lockName] || 0
                    };
                    return {
                        obtain: function(lockName) {
                            info[lockName] = currentCount(lockName) + 1
                        },
                        release: function(lockName) {
                            var count = currentCount(lockName);
                            if (count < 1) {
                                throw _errors.default.Error("E0014")
                            }
                            if (1 === count) {
                                delete info[lockName]
                            } else {
                                info[lockName] = count - 1
                            }
                        },
                        locked: function(lockName) {
                            return currentCount(lockName) > 0
                        }
                    }
                };
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        60810:
            /*!****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/math.js ***!
              \****************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.adjust = function(value, interval) {
                    var precision = getPrecision(interval || 0) + 2;
                    var separatedValue = value.toString().split(".");
                    var sourceValue = value;
                    var absValue = Math.abs(value);
                    var separatedAdjustedValue;
                    var isExponentValue = (0, _type.isExponential)(value);
                    var integerPart = absValue > 1 ? 10 : 0;
                    if (1 === separatedValue.length) {
                        return value
                    }
                    if (!isExponentValue) {
                        if ((0, _type.isExponential)(interval)) {
                            precision = separatedValue[0].length + getExponent(interval)
                        }
                        value = absValue;
                        value = value - Math.floor(value) + integerPart
                    }
                    precision = "0.000300" !== 3e-4.toPrecision(3) && getExponent(value) > 6 || precision > 7 ? 15 : 7;
                    if (!isExponentValue) {
                        separatedAdjustedValue = parseFloat(value.toPrecision(precision)).toString().split(".");
                        if (separatedAdjustedValue[0] === integerPart.toString()) {
                            return parseFloat(separatedValue[0] + "." + separatedAdjustedValue[1])
                        }
                    }
                    return parseFloat(sourceValue.toPrecision(precision))
                };
                exports.fitIntoRange = void 0;
                exports.getExponent = getExponent;
                exports.getExponentLength = function(value) {
                    var _valueString$split$;
                    var valueString = value.toString();
                    return (null === (_valueString$split$ = valueString.split(".")[1]) || void 0 === _valueString$split$ ? void 0 : _valueString$split$.length) || parseInt(valueString.split("e-")[1]) || 0
                };
                exports.getPrecision = getPrecision;
                exports.getRemainderByDivision = function(dividend, divider, digitsCount) {
                    if (divider === parseInt(divider)) {
                        return dividend % divider
                    }
                    var quotient = roundFloatPart(dividend / divider, digitsCount);
                    return (quotient - parseInt(quotient)) * divider
                };
                exports.getRoot = getRoot;
                exports.inRange = void 0;
                exports.multiplyInExponentialForm = function(value, exponentShift) {
                    var exponentialNotation = function(value) {
                        var parts = value.toExponential().split("e");
                        var mantissa = parseFloat(parts[0]);
                        var exponent = parseInt(parts[1]);
                        return {
                            exponent: exponent,
                            mantissa: mantissa
                        }
                    }(value);
                    return parseFloat("".concat(exponentialNotation.mantissa, "e").concat(exponentialNotation.exponent + exponentShift))
                };
                exports.roundFloatPart = roundFloatPart;
                exports.sign = void 0;
                exports.solveCubicEquation = function(a, b, c, d) {
                    if (Math.abs(a) < 1e-8) {
                        a = b;
                        b = c;
                        c = d;
                        if (Math.abs(a) < 1e-8) {
                            a = b;
                            b = c;
                            if (Math.abs(a) < 1e-8) {
                                return []
                            }
                            return [-b / a]
                        }
                        var D2 = b * b - 4 * a * c;
                        if (Math.abs(D2) < 1e-8) {
                            return [-b / (2 * a)]
                        } else if (D2 > 0) {
                            return [(-b + Math.sqrt(D2)) / (2 * a), (-b - Math.sqrt(D2)) / (2 * a)]
                        }
                        return []
                    }
                    var p = (3 * a * c - b * b) / (3 * a * a);
                    var q = (2 * b * b * b - 9 * a * b * c + 27 * a * a * d) / (27 * a * a * a);
                    var roots;
                    var u;
                    if (Math.abs(p) < 1e-8) {
                        roots = [getRoot(-q, 3)]
                    } else if (Math.abs(q) < 1e-8) {
                        roots = [0].concat(p < 0 ? [Math.sqrt(-p), -Math.sqrt(-p)] : [])
                    } else {
                        var D3 = q * q / 4 + p * p * p / 27;
                        if (Math.abs(D3) < 1e-8) {
                            roots = [-1.5 * q / p, 3 * q / p]
                        } else if (D3 > 0) {
                            u = getRoot(-q / 2 - Math.sqrt(D3), 3);
                            roots = [u - p / (3 * u)]
                        } else {
                            u = 2 * Math.sqrt(-p / 3);
                            var t = Math.acos(3 * q / p / u) / 3;
                            var k = 2 * Math.PI / 3;
                            roots = [u * Math.cos(t), u * Math.cos(t - k), u * Math.cos(t - 2 * k)]
                        }
                    }
                    for (var i = 0; i < roots.length; i++) {
                        roots[i] -= b / (3 * a)
                    }
                    return roots
                };
                exports.trunc = function(value) {
                    return Math.trunc ? Math.trunc(value) : value > 0 ? Math.floor(value) : Math.ceil(value)
                };
                var _type = __webpack_require__( /*! ./type */ 35922);
                exports.sign = function(value) {
                    if (0 === value) {
                        return 0
                    }
                    return value / Math.abs(value)
                };
                exports.fitIntoRange = function(value, minValue, maxValue) {
                    var isMinValueUndefined = !minValue && 0 !== minValue;
                    var isMaxValueUndefined = !maxValue && 0 !== maxValue;
                    isMinValueUndefined && (minValue = !isMaxValueUndefined ? Math.min(value, maxValue) : value);
                    isMaxValueUndefined && (maxValue = !isMinValueUndefined ? Math.max(value, minValue) : value);
                    return Math.min(Math.max(value, minValue), maxValue)
                };
                exports.inRange = function(value, minValue, maxValue) {
                    return value >= minValue && value <= maxValue
                };

                function getExponent(value) {
                    return Math.abs(parseInt(value.toExponential().split("e")[1]))
                }

                function getPrecision(value) {
                    var str = value.toString();
                    if (str.indexOf(".") < 0) {
                        return 0
                    }
                    var mantissa = str.split(".");
                    var positionOfDelimiter = mantissa[1].indexOf("e");
                    return positionOfDelimiter >= 0 ? positionOfDelimiter : mantissa[1].length
                }

                function getRoot(x, n) {
                    if (x < 0 && n % 2 !== 1) {
                        return NaN
                    }
                    var y = Math.pow(Math.abs(x), 1 / n);
                    return n % 2 === 1 && x < 0 ? -y : y
                }

                function roundFloatPart(value) {
                    var digitsCount = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : 0;
                    return parseFloat(value.toFixed(digitsCount))
                }
            },
        48013:
            /*!******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/object.js ***!
              \******************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.orderEach = exports.deepExtendArraySafe = exports.clone = void 0;
                var _type = __webpack_require__( /*! ./type */ 35922);
                var _variable_wrapper = (obj = __webpack_require__( /*! ./variable_wrapper */ 26974), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var clone = function() {
                    function Clone() {}
                    return function(obj) {
                        Clone.prototype = obj;
                        return new Clone
                    }
                }();
                exports.clone = clone;
                exports.orderEach = function(map, func) {
                    var keys = [];
                    var key;
                    var i;
                    for (key in map) {
                        if (Object.prototype.hasOwnProperty.call(map, key)) {
                            keys.push(key)
                        }
                    }
                    keys.sort((function(x, y) {
                        var isNumberX = (0, _type.isNumeric)(x);
                        var isNumberY = (0, _type.isNumeric)(y);
                        if (isNumberX && isNumberY) {
                            return x - y
                        }
                        if (isNumberX && !isNumberY) {
                            return -1
                        }
                        if (!isNumberX && isNumberY) {
                            return 1
                        }
                        if (x < y) {
                            return -1
                        }
                        if (x > y) {
                            return 1
                        }
                        return 0
                    }));
                    for (i = 0; i < keys.length; i++) {
                        key = keys[i];
                        func(key, map[key])
                    }
                };
                var assignValueToProperty = function(target, property, value, assignByReference) {
                    if (!assignByReference && _variable_wrapper.default.isWrapped(target[property])) {
                        _variable_wrapper.default.assign(target[property], value)
                    } else {
                        target[property] = value
                    }
                };
                exports.deepExtendArraySafe = function deepExtendArraySafe(target, changes, extendComplexObject, assignByReference) {
                    var prevValue;
                    var newValue;
                    for (var name in changes) {
                        prevValue = target[name];
                        newValue = changes[name];
                        if ("__proto__" === name || "constructor" === name || target === newValue) {
                            continue
                        }
                        if ((0, _type.isPlainObject)(newValue)) {
                            var goDeeper = extendComplexObject ? (0, _type.isObject)(prevValue) : (0, _type.isPlainObject)(prevValue);
                            newValue = deepExtendArraySafe(goDeeper ? prevValue : {}, newValue, extendComplexObject, assignByReference)
                        }
                        if (void 0 !== newValue && prevValue !== newValue) {
                            assignValueToProperty(target, name, newValue, assignByReference)
                        }
                    }
                    return target
                }
            },
        37518:
            /*!********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/position.js ***!
              \********************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.getDefaultAlignment = exports.getBoundingRect = void 0;
                var _config = (obj = __webpack_require__( /*! ../config */ 80209), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _type = __webpack_require__( /*! ../utils/type */ 35922);
                exports.getDefaultAlignment = function(isRtlEnabled) {
                    var rtlEnabled = null !== isRtlEnabled && void 0 !== isRtlEnabled ? isRtlEnabled : (0, _config.default)().rtlEnabled;
                    return rtlEnabled ? "right" : "left"
                };
                exports.getBoundingRect = function(element) {
                    if ((0, _type.isWindow)(element)) {
                        return {
                            width: element.outerWidth,
                            height: element.outerHeight
                        }
                    }
                    return element.getBoundingClientRect()
                }
            },
        9321:
            /*!****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/public_component.js ***!
              \****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.attachInstanceToElement = function($element, componentInstance, disposeFn) {
                    var data = (0, _element_data.data)($element.get(0));
                    var name = getName(componentInstance.constructor);
                    data[name] = componentInstance;
                    if (disposeFn) {
                        _events_engine.default.one($element, _remove.removeEvent, (function() {
                            disposeFn.call(componentInstance)
                        }))
                    }
                    if (!data.dxComponents) {
                        data.dxComponents = []
                    }
                    data.dxComponents.push(name)
                };
                exports.getInstanceByElement = function($element, componentClass) {
                    var name = getName(componentClass);
                    return (0, _element_data.data)($element.get(0), name)
                };
                exports.name = void 0;
                var _element_data = __webpack_require__( /*! ../../core/element_data */ 97906);
                var _events_engine = (obj = __webpack_require__( /*! ../../events/core/events_engine */ 55994), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _type = __webpack_require__( /*! ./type */ 35922);
                var _remove = __webpack_require__( /*! ../../events/remove */ 29007);
                var componentNames = new WeakMap;
                var nextAnonymousComponent = 0;
                var getName = function(componentClass, newName) {
                    if ((0, _type.isDefined)(newName)) {
                        componentNames.set(componentClass, newName);
                        return
                    }
                    if (!componentNames.has(componentClass)) {
                        var generatedName = "dxPrivateComponent" + nextAnonymousComponent++;
                        componentNames.set(componentClass, generatedName);
                        return generatedName
                    }
                    return componentNames.get(componentClass)
                };
                exports.name = getName
            },
        59504:
            /*!*****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/queue.js ***!
              \*****************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.create = createQueue;
                exports.enqueue = void 0;
                var _errors = (obj = __webpack_require__( /*! ../errors */ 17381), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 62754);

                function createQueue(discardPendingTasks) {
                    var _tasks = [];
                    var _busy = false;

                    function exec() {
                        while (_tasks.length) {
                            _busy = true;
                            var task = _tasks.shift();
                            var result = task();
                            if (void 0 === result) {
                                continue
                            }
                            if (result.then) {
                                (0, _deferred.when)(result).always(exec);
                                return
                            }
                            throw _errors.default.Error("E0015")
                        }
                        _busy = false
                    }
                    return {
                        add: function(task, removeTaskCallback) {
                            if (!discardPendingTasks) {
                                _tasks.push(task)
                            } else {
                                if (_tasks[0] && removeTaskCallback) {
                                    removeTaskCallback(_tasks[0])
                                }
                                _tasks = [task]
                            }
                            if (!_busy) {
                                exec()
                            }
                        },
                        busy: function() {
                            return _busy
                        }
                    }
                }
                var enqueue = createQueue().add;
                exports.enqueue = enqueue
            },
        24311:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/ready_callbacks.js ***!
              \***************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../dom_adapter */ 73349));
                var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ./dependency_injector */ 20476));
                var _window = __webpack_require__( /*! ./window */ 58201);
                var _call_once = _interopRequireDefault(__webpack_require__( /*! ./call_once */ 39618));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var callbacks = [];
                var subscribeReady = (0, _call_once.default)((function() {
                    var removeListener = _dom_adapter.default.listen(_dom_adapter.default.getDocument(), "DOMContentLoaded", (function() {
                        readyCallbacks.fire();
                        removeListener()
                    }))
                }));
                var readyCallbacks = {
                    add: function(callback) {
                        var windowExists = (0, _window.hasWindow)();
                        if (windowExists && "loading" !== _dom_adapter.default.getReadyState()) {
                            callback()
                        } else {
                            callbacks.push(callback);
                            windowExists && subscribeReady()
                        }
                    },
                    fire: function() {
                        callbacks.forEach((function(callback) {
                            return callback()
                        }));
                        callbacks = []
                    }
                };
                var _default = (0, _dependency_injector.default)(readyCallbacks);
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        55814:
            /*!****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/resize_callbacks.js ***!
              \****************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _window = __webpack_require__( /*! ./window */ 58201);
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../dom_adapter */ 73349));
                var _callbacks = _interopRequireDefault(__webpack_require__( /*! ./callbacks */ 44504));
                var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ./ready_callbacks */ 24311));
                var _call_once = _interopRequireDefault(__webpack_require__( /*! ./call_once */ 39618));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var resizeCallbacks = function() {
                    var prevSize;
                    var callbacks = (0, _callbacks.default)();
                    var originalCallbacksAdd = callbacks.add;
                    var originalCallbacksRemove = callbacks.remove;
                    if (!(0, _window.hasWindow)()) {
                        return callbacks
                    }
                    var formatSize = function() {
                        var window = (0, _window.getWindow)();
                        return {
                            width: window.innerWidth,
                            height: window.innerHeight
                        }
                    };
                    var handleResize = function() {
                        var now = formatSize();
                        if (now.width === prevSize.width && now.height === prevSize.height) {
                            return
                        }
                        var changedDimension;
                        if (now.width === prevSize.width) {
                            changedDimension = "height"
                        }
                        if (now.height === prevSize.height) {
                            changedDimension = "width"
                        }
                        prevSize = now;
                        callbacks.fire(changedDimension)
                    };
                    var setPrevSize = (0, _call_once.default)((function() {
                        prevSize = formatSize()
                    }));
                    var removeListener;
                    callbacks.add = function() {
                        var result = originalCallbacksAdd.apply(callbacks, arguments);
                        setPrevSize();
                        _ready_callbacks.default.add((function() {
                            if (!removeListener && callbacks.has()) {
                                removeListener = _dom_adapter.default.listen((0, _window.getWindow)(), "resize", handleResize)
                            }
                        }));
                        return result
                    };
                    callbacks.remove = function() {
                        var result = originalCallbacksRemove.apply(callbacks, arguments);
                        if (!callbacks.has() && removeListener) {
                            removeListener();
                            removeListener = void 0
                        }
                        return result
                    };
                    return callbacks
                }();
                var _default = resizeCallbacks;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        49601:
            /*!****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/selection_filter.js ***!
              \****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.SelectionFilterCreator = void 0;
                var _common = __webpack_require__( /*! ./common */ 20576);
                var _type = __webpack_require__( /*! ./type */ 35922);
                exports.SelectionFilterCreator = function(selectedItemKeys, isSelectAll) {
                    this.getLocalFilter = function(keyGetter, equalKeys, equalByReference, keyExpr) {
                        equalKeys = void 0 === equalKeys ? _common.equalByValue : equalKeys;
                        return functionFilter.bind(this, equalKeys, keyGetter, equalByReference, keyExpr)
                    };
                    this.getExpr = function(keyExpr) {
                        if (!keyExpr) {
                            return
                        }
                        var filterExpr;
                        selectedItemKeys.forEach((function(key, index) {
                            filterExpr = filterExpr || [];
                            var filterExprPart;
                            if (index > 0) {
                                filterExpr.push(isSelectAll ? "and" : "or")
                            }
                            if ((0, _type.isString)(keyExpr)) {
                                filterExprPart = getFilterForPlainKey(keyExpr, key)
                            } else {
                                filterExprPart = function(keyExpr, itemKeyValue) {
                                    var filterExpr = [];
                                    for (var i = 0, length = keyExpr.length; i < length; i++) {
                                        var currentKeyExpr = keyExpr[i];
                                        var currentKeyValue = itemKeyValue && itemKeyValue[currentKeyExpr];
                                        var filterExprPart = getFilterForPlainKey(currentKeyExpr, currentKeyValue);
                                        if (!filterExprPart) {
                                            break
                                        }
                                        if (i > 0) {
                                            filterExpr.push(isSelectAll ? "or" : "and")
                                        }
                                        filterExpr.push(filterExprPart)
                                    }
                                    return filterExpr
                                }(keyExpr, key)
                            }
                            filterExpr.push(filterExprPart)
                        }));
                        if (filterExpr && 1 === filterExpr.length) {
                            filterExpr = filterExpr[0]
                        }
                        return filterExpr
                    };
                    this.getCombinedFilter = function(keyExpr, dataSourceFilter) {
                        var filterExpr = this.getExpr(keyExpr);
                        var combinedFilter = filterExpr;
                        if (isSelectAll && dataSourceFilter) {
                            if (filterExpr) {
                                combinedFilter = [];
                                combinedFilter.push(filterExpr);
                                combinedFilter.push(dataSourceFilter)
                            } else {
                                combinedFilter = dataSourceFilter
                            }
                        }
                        return combinedFilter
                    };
                    var selectedItemKeyHashesMap;
                    var normalizeKeys = function(keys, keyOf, keyExpr) {
                        return Array.isArray(keyExpr) ? keys.map((function(key) {
                            return keyOf(key)
                        })) : keys
                    };

                    function functionFilter(equalKeys, keyOf, equalByReference, keyExpr, item) {
                        var key = keyOf(item);
                        var keyHash;
                        var i;
                        if (!equalByReference) {
                            keyHash = (0, _common.getKeyHash)(key);
                            if (!(0, _type.isObject)(keyHash)) {
                                var selectedKeyHashesMap = function(keyOf, keyExpr) {
                                    if (!selectedItemKeyHashesMap) {
                                        selectedItemKeyHashesMap = {};
                                        var normalizedKeys = normalizeKeys(selectedItemKeys, keyOf, keyExpr);
                                        for (var i = 0; i < normalizedKeys.length; i++) {
                                            selectedItemKeyHashesMap[(0, _common.getKeyHash)(normalizedKeys[i])] = true
                                        }
                                    }
                                    return selectedItemKeyHashesMap
                                }(keyOf, keyExpr);
                                if (selectedKeyHashesMap[keyHash]) {
                                    return !isSelectAll
                                }
                                return !!isSelectAll
                            }
                        }
                        for (i = 0; i < selectedItemKeys.length; i++) {
                            if (equalKeys(selectedItemKeys[i], key)) {
                                return !isSelectAll
                            }
                        }
                        return !!isSelectAll
                    }

                    function getFilterForPlainKey(keyExpr, keyValue) {
                        if (void 0 === keyValue) {
                            return
                        }
                        return [keyExpr, isSelectAll ? "<>" : "=", keyValue]
                    }
                }
            },
        58664:
            /*!****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/size.js ***!
              \****************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.setWidth = exports.setOuterWidth = exports.setOuterHeight = exports.setInnerWidth = exports.setInnerHeight = exports.setHeight = exports.parseHeight = exports.implementationsMap = exports.getWindowByElement = exports.getWidth = exports.getVisibleHeight = exports.getVerticalOffsets = exports.getSize = exports.getOuterWidth = exports.getOuterHeight = exports.getOffset = exports.getInnerWidth = exports.getInnerHeight = exports.getHeight = exports.getElementBoxParams = exports.addOffsetToMinHeight = exports.addOffsetToMaxHeight = void 0;
                var _window = __webpack_require__( /*! ../../core/utils/window */ 58201);
                var _dom_adapter = (obj = __webpack_require__( /*! ../../core/dom_adapter */ 73349), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _type = __webpack_require__( /*! ../utils/type */ 35922);
                var window = (0, _window.getWindow)();
                var SPECIAL_HEIGHT_VALUES = ["auto", "none", "inherit", "initial"];
                var getSizeByStyles = function(elementStyles, styles) {
                    var result = 0;
                    styles.forEach((function(style) {
                        result += parseFloat(elementStyles[style]) || 0
                    }));
                    return result
                };
                var getElementBoxParams = function(name, elementStyles) {
                    var beforeName = "width" === name ? "Left" : "Top";
                    var afterName = "width" === name ? "Right" : "Bottom";
                    return {
                        padding: getSizeByStyles(elementStyles, ["padding" + beforeName, "padding" + afterName]),
                        border: getSizeByStyles(elementStyles, ["border" + beforeName + "Width", "border" + afterName + "Width"]),
                        margin: getSizeByStyles(elementStyles, ["margin" + beforeName, "margin" + afterName])
                    }
                };
                exports.getElementBoxParams = getElementBoxParams;
                var getElementComputedStyle = function(element) {
                    var _element$ownerDocumen;
                    var view = (null === element || void 0 === element ? void 0 : null === (_element$ownerDocumen = element.ownerDocument) || void 0 === _element$ownerDocumen ? void 0 : _element$ownerDocumen.defaultView) || window;
                    return view.getComputedStyle && view.getComputedStyle(element)
                };
                var getCSSProperty = function(element, styles, name, defaultValue) {
                    var _element$style;
                    return (null === styles || void 0 === styles ? void 0 : styles[name]) || (null === (_element$style = element.style) || void 0 === _element$style ? void 0 : _element$style[name]) || defaultValue
                };
                var boxIndices = {
                    content: 0,
                    padding: 1,
                    border: 2,
                    margin: 3,
                    "content-box": 0,
                    "border-box": 2
                };
                var dimensionComponents = {
                    width: ["left", "right"],
                    height: ["top", "bottom"]
                };

                function getComponentThickness(elem, dimension, component, styles) {
                    var get = function(elem, styles, field) {
                        return parseFloat(getCSSProperty(elem, styles, field, "0")) || 0
                    };
                    var suffix = "border" === component ? "-width" : "";
                    return get(elem, styles, "".concat(component, "-").concat(dimensionComponents[dimension][0]).concat(suffix)) + get(elem, styles, "".concat(component, "-").concat(dimensionComponents[dimension][1]).concat(suffix))
                }
                var getSize = function(element, dimension, box) {
                    var offsetFieldName = "width" === dimension ? "offsetWidth" : "offsetHeight";
                    var styles = getElementComputedStyle(element);
                    var result = getCSSProperty(element, styles, dimension);
                    if ("" === result || "auto" === result) {
                        result = element[offsetFieldName]
                    }
                    result = parseFloat(result) || 0;
                    var currentBox = getCSSProperty(element, styles, "boxSizing", "content-box");
                    var targetBox = box || currentBox;
                    var targetBoxIndex = boxIndices[targetBox];
                    var currentBoxIndex = boxIndices[currentBox];
                    if (void 0 === targetBoxIndex || void 0 === currentBoxIndex) {
                        throw new Error
                    }
                    if (currentBoxIndex === targetBoxIndex) {
                        return result
                    }
                    var coeff = Math.sign(targetBoxIndex - currentBoxIndex);
                    var padding = false;
                    var border = false;
                    var margin = false;
                    var scrollThickness = false;
                    if (1 === coeff) {
                        targetBoxIndex += 1;
                        currentBoxIndex += 1
                    }
                    for (var boxPart = currentBoxIndex; boxPart !== targetBoxIndex; boxPart += coeff) {
                        switch (boxPart) {
                            case boxIndices.content:
                                break;
                            case boxIndices.padding:
                                padding = coeff * getComponentThickness(element, dimension, "padding", styles);
                                break;
                            case boxIndices.border:
                                border = coeff * getComponentThickness(element, dimension, "border", styles);
                                break;
                            case boxIndices.margin:
                                margin = coeff * getComponentThickness(element, dimension, "margin", styles)
                        }
                    }
                    if (padding || border) {
                        var paddingAndBorder = (false === padding ? coeff * getComponentThickness(element, dimension, "padding", styles) : padding) + (false === border ? coeff * getComponentThickness(element, dimension, "border", styles) : border);
                        scrollThickness = coeff * Math.max(0, Math.floor(element[offsetFieldName] - result - coeff * paddingAndBorder)) || 0
                    }
                    return result + margin + padding + border + scrollThickness
                };
                exports.getSize = getSize;
                var parseHeight = function(value, container) {
                    if (value.indexOf("px") > 0) {
                        value = parseInt(value.replace("px", ""))
                    } else if (value.indexOf("%") > 0) {
                        value = parseInt(value.replace("%", "")) * function(container) {
                            return (0, _type.isWindow)(container) ? container.innerHeight : container.offsetHeight
                        }(container) / 100
                    } else if (!isNaN(value)) {
                        value = parseInt(value)
                    } else if (value.indexOf("vh") > 0) {
                        value = window.innerHeight / 100 * parseInt(value.replace("vh", ""))
                    }
                    return value
                };
                exports.parseHeight = parseHeight;
                var getHeightWithOffset = function(value, offset, container) {
                    if (!value) {
                        return null
                    }
                    if (SPECIAL_HEIGHT_VALUES.indexOf(value) > -1) {
                        return offset ? null : value
                    }
                    if ((0, _type.isString)(value)) {
                        value = parseHeight(value, container)
                    }
                    if ((0, _type.isNumeric)(value)) {
                        return Math.max(0, value + offset)
                    }
                    var operationString = offset < 0 ? " - " : " ";
                    return "calc(" + value + operationString + Math.abs(offset) + "px)"
                };
                exports.addOffsetToMaxHeight = function(value, offset, container) {
                    var maxHeight = getHeightWithOffset(value, offset, container);
                    return null !== maxHeight ? maxHeight : "none"
                };
                exports.addOffsetToMinHeight = function(value, offset, container) {
                    var minHeight = getHeightWithOffset(value, offset, container);
                    return null !== minHeight ? minHeight : 0
                };
                exports.getVerticalOffsets = function(element, withMargins) {
                    if (!element) {
                        return 0
                    }
                    var boxParams = getElementBoxParams("height", window.getComputedStyle(element));
                    return boxParams.padding + boxParams.border + (withMargins ? boxParams.margin : 0)
                };
                exports.getVisibleHeight = function(element) {
                    if (element) {
                        var boundingClientRect = element.getBoundingClientRect();
                        if (boundingClientRect.height) {
                            return boundingClientRect.height
                        }
                    }
                    return 0
                };
                var implementationsMap = {
                    getWidth: function() {
                        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                            args[_key] = arguments[_key]
                        }
                        return elementSizeHelper.apply(void 0, ["width"].concat(args))
                    },
                    setWidth: function() {
                        for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                            args[_key2] = arguments[_key2]
                        }
                        return elementSizeHelper.apply(void 0, ["width"].concat(args))
                    },
                    getHeight: function() {
                        for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
                            args[_key3] = arguments[_key3]
                        }
                        return elementSizeHelper.apply(void 0, ["height"].concat(args))
                    },
                    setHeight: function() {
                        for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
                            args[_key4] = arguments[_key4]
                        }
                        return elementSizeHelper.apply(void 0, ["height"].concat(args))
                    },
                    getOuterWidth: function() {
                        for (var _len5 = arguments.length, args = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
                            args[_key5] = arguments[_key5]
                        }
                        return elementSizeHelper.apply(void 0, ["outerWidth"].concat(args))
                    },
                    setOuterWidth: function() {
                        for (var _len6 = arguments.length, args = new Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
                            args[_key6] = arguments[_key6]
                        }
                        return elementSizeHelper.apply(void 0, ["outerWidth"].concat(args))
                    },
                    getOuterHeight: function() {
                        for (var _len7 = arguments.length, args = new Array(_len7), _key7 = 0; _key7 < _len7; _key7++) {
                            args[_key7] = arguments[_key7]
                        }
                        return elementSizeHelper.apply(void 0, ["outerHeight"].concat(args))
                    },
                    setOuterHeight: function() {
                        for (var _len8 = arguments.length, args = new Array(_len8), _key8 = 0; _key8 < _len8; _key8++) {
                            args[_key8] = arguments[_key8]
                        }
                        return elementSizeHelper.apply(void 0, ["outerHeight"].concat(args))
                    },
                    getInnerWidth: function() {
                        for (var _len9 = arguments.length, args = new Array(_len9), _key9 = 0; _key9 < _len9; _key9++) {
                            args[_key9] = arguments[_key9]
                        }
                        return elementSizeHelper.apply(void 0, ["innerWidth"].concat(args))
                    },
                    setInnerWidth: function() {
                        for (var _len10 = arguments.length, args = new Array(_len10), _key10 = 0; _key10 < _len10; _key10++) {
                            args[_key10] = arguments[_key10]
                        }
                        return elementSizeHelper.apply(void 0, ["innerWidth"].concat(args))
                    },
                    getInnerHeight: function() {
                        for (var _len11 = arguments.length, args = new Array(_len11), _key11 = 0; _key11 < _len11; _key11++) {
                            args[_key11] = arguments[_key11]
                        }
                        return elementSizeHelper.apply(void 0, ["innerHeight"].concat(args))
                    },
                    setInnerHeight: function() {
                        for (var _len12 = arguments.length, args = new Array(_len12), _key12 = 0; _key12 < _len12; _key12++) {
                            args[_key12] = arguments[_key12]
                        }
                        return elementSizeHelper.apply(void 0, ["innerHeight"].concat(args))
                    }
                };
                exports.implementationsMap = implementationsMap;

                function elementSizeHelper(sizeProperty, el, value) {
                    return 2 === arguments.length ? elementSize(el, sizeProperty) : elementSize(el, sizeProperty, value)
                }
                exports.getWidth = function(el) {
                    return implementationsMap.getWidth(el)
                };
                exports.setWidth = function(el, value) {
                    return implementationsMap.setWidth(el, value)
                };
                exports.getHeight = function(el) {
                    return implementationsMap.getHeight(el)
                };
                exports.setHeight = function(el, value) {
                    return implementationsMap.setHeight(el, value)
                };
                exports.getOuterWidth = function(el, includeMargin) {
                    return implementationsMap.getOuterWidth(el, includeMargin || false)
                };
                exports.setOuterWidth = function(el, value) {
                    return implementationsMap.setOuterWidth(el, value)
                };
                exports.getOuterHeight = function(el, includeMargin) {
                    return implementationsMap.getOuterHeight(el, includeMargin || false)
                };
                exports.setOuterHeight = function(el, value) {
                    return implementationsMap.setOuterHeight(el, value)
                };
                exports.getInnerWidth = function(el) {
                    return implementationsMap.getInnerWidth(el)
                };
                exports.setInnerWidth = function(el, value) {
                    return implementationsMap.setInnerWidth(el, value)
                };
                exports.getInnerHeight = function(el) {
                    return implementationsMap.getInnerHeight(el)
                };
                exports.setInnerHeight = function(el, value) {
                    return implementationsMap.setInnerHeight(el, value)
                };
                var elementSize = function elementSize(el, sizeProperty, value) {
                    var partialName = sizeProperty.toLowerCase().indexOf("width") >= 0 ? "Width" : "Height";
                    var propName = partialName.toLowerCase();
                    var isOuter = 0 === sizeProperty.indexOf("outer");
                    var isInner = 0 === sizeProperty.indexOf("inner");
                    var isGetter = 2 === arguments.length || "boolean" === typeof value;
                    if ((0, _type.isRenderer)(el)) {
                        if (el.length > 1 && !isGetter) {
                            for (var i = 0; i < el.length; i++) {
                                elementSize(el[i], sizeProperty, value)
                            }
                            return
                        }
                        el = el[0]
                    }
                    if (!el) {
                        return
                    }
                    if ((0, _type.isWindow)(el)) {
                        return isOuter ? el["inner" + partialName] : _dom_adapter.default.getDocumentElement()["client" + partialName]
                    }
                    if (_dom_adapter.default.isDocument(el)) {
                        var documentElement = _dom_adapter.default.getDocumentElement();
                        var body = _dom_adapter.default.getBody();
                        return Math.max(body["scroll" + partialName], body["offset" + partialName], documentElement["scroll" + partialName], documentElement["offset" + partialName], documentElement["client" + partialName])
                    }
                    if (isGetter) {
                        var box = "content";
                        if (isOuter) {
                            box = value ? "margin" : "border"
                        }
                        if (isInner) {
                            box = "padding"
                        }
                        return getSize(el, propName, box)
                    }
                    if ((0, _type.isNumeric)(value)) {
                        var elementStyles = getElementComputedStyle(el);
                        var sizeAdjustment = getElementBoxParams(propName, elementStyles);
                        var isBorderBox = "border-box" === elementStyles.boxSizing;
                        value = Number(value);
                        if (isOuter) {
                            value -= isBorderBox ? 0 : sizeAdjustment.border + sizeAdjustment.padding
                        } else if (isInner) {
                            value += isBorderBox ? sizeAdjustment.border : -sizeAdjustment.padding
                        } else if (isBorderBox) {
                            value += sizeAdjustment.border + sizeAdjustment.padding
                        }
                    }
                    value += (0, _type.isNumeric)(value) ? "px" : "";
                    _dom_adapter.default.setStyle(el, propName, value);
                    return null
                };
                var getWindowByElement = function(el) {
                    return (0, _type.isWindow)(el) ? el : el.defaultView
                };
                exports.getWindowByElement = getWindowByElement;
                exports.getOffset = function(el) {
                    if (!el.getClientRects().length) {
                        return {
                            top: 0,
                            left: 0
                        }
                    }
                    var rect = el.getBoundingClientRect();
                    var win = getWindowByElement(el.ownerDocument);
                    var docElem = el.ownerDocument.documentElement;
                    return {
                        top: rect.top + win.pageYOffset - docElem.clientTop,
                        left: rect.left + win.pageXOffset - docElem.clientLeft
                    }
                }
            },
        36613:
            /*!*******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/storage.js ***!
              \*******************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.sessionStorage = void 0;
                var _window = __webpack_require__( /*! ../../core/utils/window */ 58201);
                var window = (0, _window.getWindow)();
                exports.sessionStorage = function() {
                    var sessionStorage;
                    try {
                        sessionStorage = window.sessionStorage
                    } catch (e) {}
                    return sessionStorage
                }
            },
        68752:
            /*!******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/string.js ***!
              \******************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.encodeHtml = void 0;
                exports.format = function(template) {
                    for (var _len = arguments.length, values = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
                        values[_key - 1] = arguments[_key]
                    }
                    if ((0, _type.isFunction)(template)) {
                        return template.apply(void 0, values)
                    }
                    values.forEach((function(value, index) {
                        if ((0, _type.isString)(value)) {
                            value = value.replace(/\$/g, "$$$$")
                        }
                        var placeholderReg = new RegExp("\\{" + index + "\\}", "gm");
                        template = template.replace(placeholderReg, value)
                    }));
                    return template
                };
                exports.replaceAll = exports.quadToObject = exports.isEmpty = void 0;
                var _type = __webpack_require__( /*! ./type */ 35922);

                function _typeof(obj) {
                    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj) {
                        return typeof obj
                    } : function(obj) {
                        return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                    }, _typeof(obj)
                }
                var encodeHtml = (encodeRegExp = [new RegExp("&", "g"), new RegExp('"', "g"), new RegExp("'", "g"), new RegExp("<", "g"), new RegExp(">", "g")], function(str) {
                    return String(str).replace(encodeRegExp[0], "&amp;").replace(encodeRegExp[1], "&quot;").replace(encodeRegExp[2], "&#39;").replace(encodeRegExp[3], "&lt;").replace(encodeRegExp[4], "&gt;")
                });
                var encodeRegExp;
                exports.encodeHtml = encodeHtml;
                exports.quadToObject = function(raw) {
                    var quad = function(raw) {
                        switch (_typeof(raw)) {
                            case "string":
                                return raw.split(/\s+/, 4);
                            case "object":
                                return [raw.x || raw.h || raw.left, raw.y || raw.v || raw.top, raw.x || raw.h || raw.right, raw.y || raw.v || raw.bottom];
                            case "number":
                                return [raw];
                            default:
                                return raw
                        }
                    }(raw);
                    var left = parseInt(quad && quad[0], 10);
                    var top = parseInt(quad && quad[1], 10);
                    var right = parseInt(quad && quad[2], 10);
                    var bottom = parseInt(quad && quad[3], 10);
                    if (!isFinite(left)) {
                        left = 0
                    }
                    if (!isFinite(top)) {
                        top = left
                    }
                    if (!isFinite(right)) {
                        right = left
                    }
                    if (!isFinite(bottom)) {
                        bottom = top
                    }
                    return {
                        top: top,
                        right: right,
                        bottom: bottom,
                        left: left
                    }
                };
                var replaceAll = function(text, searchToken, replacementToken) {
                    return text.replace(new RegExp("(" + (str = searchToken, (str + "").replace(/([+*?.[^\]$(){}><|=!:])/g, "\\$1")) + ")", "gi"), replacementToken);
                    var str
                };
                exports.replaceAll = replaceAll;
                var isEmpty = (SPACE_REGEXP = /\s/g, function(text) {
                    return !text || !text.replace(SPACE_REGEXP, "")
                });
                var SPACE_REGEXP;
                exports.isEmpty = isEmpty
            },
        2146:
            /*!*****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/stubs.js ***!
              \*****************************************************************/
            function(__unused_webpack_module, exports) {
                exports.stubComponent = function(componentName) {
                    return function() {
                        function NoComponent() {
                            throw new Error("Module '".concat(componentName, "' not found"))
                        }
                        NoComponent.getInstance = function() {};
                        return NoComponent
                    }()
                }
            },
        80968:
            /*!*****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/style.js ***!
              \*****************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.stylePropPrefix = exports.styleProp = exports.setWidth = exports.setHeight = exports.parsePixelValue = exports.normalizeStyleProp = void 0;
                var _inflector = __webpack_require__( /*! ./inflector */ 78008);
                var _call_once = _interopRequireDefault(__webpack_require__( /*! ./call_once */ 39618));
                var _type = __webpack_require__( /*! ./type */ 35922);
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../dom_adapter */ 73349));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var jsPrefixes = ["", "Webkit", "Moz", "O", "Ms"];
                var cssPrefixes = {
                    "": "",
                    Webkit: "-webkit-",
                    Moz: "-moz-",
                    O: "-o-",
                    ms: "-ms-"
                };
                var getStyles = (0, _call_once.default)((function() {
                    return _dom_adapter.default.createElement("dx").style
                }));
                exports.styleProp = function(name) {
                    if (name in getStyles()) {
                        return name
                    }
                    var originalName = name;
                    name = name.charAt(0).toUpperCase() + name.substr(1);
                    for (var i = 1; i < jsPrefixes.length; i++) {
                        var prefixedProp = jsPrefixes[i].toLowerCase() + name;
                        if (prefixedProp in getStyles()) {
                            return prefixedProp
                        }
                    }
                    return originalName
                };
                exports.stylePropPrefix = function(prop) {
                    return function(prop, callBack) {
                        prop = (0, _inflector.camelize)(prop, true);
                        var result;
                        for (var i = 0, cssPrefixesCount = jsPrefixes.length; i < cssPrefixesCount; i++) {
                            var jsPrefix = jsPrefixes[i];
                            var prefixedProp = jsPrefix + prop;
                            var lowerPrefixedProp = (0, _inflector.camelize)(prefixedProp);
                            result = callBack(lowerPrefixedProp, jsPrefix);
                            if (void 0 === result) {
                                result = callBack(prefixedProp, jsPrefix)
                            }
                            if (void 0 !== result) {
                                break
                            }
                        }
                        return result || ""
                    }(prop, (function(specific, jsPrefix) {
                        if (specific in getStyles()) {
                            return cssPrefixes[jsPrefix]
                        }
                    }))
                };
                var pxExceptions = ["fillOpacity", "columnCount", "flexGrow", "flexShrink", "fontWeight", "lineHeight", "opacity", "zIndex", "zoom"];
                exports.parsePixelValue = function(value) {
                    if ((0, _type.isNumeric)(value)) {
                        return value
                    } else if ((0, _type.isString)(value)) {
                        return Number(value.replace("px", ""))
                    }
                    return NaN
                };
                exports.normalizeStyleProp = function(prop, value) {
                    if ((0, _type.isNumeric)(value) && -1 === pxExceptions.indexOf(prop)) {
                        value += "px"
                    }
                    return value
                };
                var setDimensionProperty = function(elements, propertyName, value) {
                    if (elements) {
                        value = (0, _type.isNumeric)(value) ? value += "px" : value;
                        for (var i = 0; i < elements.length; ++i) {
                            elements[i].style[propertyName] = value
                        }
                    }
                };
                exports.setWidth = function(elements, value) {
                    setDimensionProperty(elements, "width", value)
                };
                exports.setHeight = function(elements, value) {
                    setDimensionProperty(elements, "height", value)
                }
            },
        60137:
            /*!*******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/support.js ***!
              \*******************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.pointerEvents = exports.nativeScrolling = exports.inputType = exports.animation = void 0;
                Object.defineProperty(exports, "styleProp", {
                    enumerable: true,
                    get: function() {
                        return _style.styleProp
                    }
                });
                Object.defineProperty(exports, "stylePropPrefix", {
                    enumerable: true,
                    get: function() {
                        return _style.stylePropPrefix
                    }
                });
                exports.transitionEndEventName = exports.transition = exports.touchEvents = exports.touch = exports.supportProp = void 0;
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../dom_adapter */ 73349));
                var _call_once = _interopRequireDefault(__webpack_require__( /*! ./call_once */ 39618));
                var _window = __webpack_require__( /*! ./window */ 58201);
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../devices */ 20530));
                var _style = __webpack_require__( /*! ./style */ 80968);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var _getNavigator = (0, _window.getNavigator)(),
                    maxTouchPoints = _getNavigator.maxTouchPoints;
                var transitionEndEventNames = {
                    webkitTransition: "webkitTransitionEnd",
                    MozTransition: "transitionend",
                    OTransition: "oTransitionEnd",
                    transition: "transitionend"
                };
                var supportProp = function(prop) {
                    return !!(0, _style.styleProp)(prop)
                };
                exports.supportProp = supportProp;
                exports.inputType = function(type) {
                    if ("text" === type) {
                        return true
                    }
                    var input = _dom_adapter.default.createElement("input");
                    try {
                        input.setAttribute("type", type);
                        input.value = "wrongValue";
                        return !input.value
                    } catch (e) {
                        return false
                    }
                };
                var touchEvents = function(hasWindowProperty, maxTouchPoints) {
                    return (hasWindowProperty("ontouchstart") || !!maxTouchPoints) && !hasWindowProperty("callPhantom")
                }(_window.hasProperty, maxTouchPoints);
                exports.touchEvents = touchEvents;
                var pointerEvents = (hasWindowProperty = _window.hasProperty, hasWindowProperty("PointerEvent"));
                var hasWindowProperty;
                exports.pointerEvents = pointerEvents;
                var touchPointersPresent = !!maxTouchPoints;
                var touch = touchEvents || pointerEvents && touchPointersPresent;
                exports.touch = touch;
                var transition = (0, _call_once.default)((function() {
                    return supportProp("transition")
                }));
                exports.transition = transition;
                var transitionEndEventName = (0, _call_once.default)((function() {
                    return transitionEndEventNames[(0, _style.styleProp)("transition")]
                }));
                exports.transitionEndEventName = transitionEndEventName;
                var animation = (0, _call_once.default)((function() {
                    return supportProp("animation")
                }));
                exports.animation = animation;
                var nativeScrolling = (_devices$real = _devices.default.real(), platform = _devices$real.platform, isMac = _devices$real.mac, isNativeScrollDevice = "ios" === platform || "android" === platform || isMac, isNativeScrollDevice);
                var _devices$real, platform, isMac, isNativeScrollDevice;
                exports.nativeScrolling = nativeScrolling
            },
        19155:
            /*!***************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/svg.js ***!
              \***************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.HIDDEN_FOR_EXPORT = void 0;
                exports.getSvgElement = function(markup) {
                    return _dom_adapter.default.isNode(markup) ? markup : (new window.DOMParser).parseFromString(markup, "image/svg+xml").childNodes[0]
                };
                exports.getSvgMarkup = function(element, backgroundColor) {
                    return function(markup) {
                        var first = true;
                        if (-1 === markup.indexOf("xmlns:xlink")) {
                            markup = markup.replace("<svg", '<svg xmlns:xlink="http://www.w3.org/1999/xlink"')
                        }
                        markup = markup.replace(/xmlns="[\s\S]*?"/gi, (function(match) {
                            if (!first) {
                                return ""
                            }
                            first = false;
                            return match
                        }));
                        return markup.replace(/xmlns:NS1="[\s\S]*?"/gi, "").replace(/NS1:xmlns:xlink="([\s\S]*?)"/gi, 'xmlns:xlink="$1"')
                    }((markup = function(element, backgroundColor) {
                        var temp = _dom_adapter.default.createElement("div");
                        var clone = element.cloneNode(true);
                        if (backgroundColor) {
                            (0, _renderer.default)(clone).css("backgroundColor", backgroundColor)
                        }
                        temp.appendChild(clone);
                        return temp.innerHTML
                    }(element, backgroundColor), markup.replace(/&quot;/gi, "&#34;").replace(/&amp;/gi, "&#38;").replace(/&apos;/gi, "&#39;").replace(/&lt;/gi, "&#60;").replace(/&gt;/gi, "&#62;").replace(/&nbsp;/gi, "&#160;").replace(/&shy;/gi, "&#173;")));
                    var markup
                };
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 73349));
                var _window = __webpack_require__( /*! ./window */ 58201);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 68374));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var window = (0, _window.getWindow)();
                exports.HIDDEN_FOR_EXPORT = "hidden-for-export"
            },
        69697:
            /*!****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/template_manager.js ***!
              \****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.validateTemplateSource = exports.templateKey = exports.suitableTemplatesByName = exports.getNormalizedTemplateArgs = exports.findTemplates = exports.defaultCreateElement = exports.addOneRenderedCall = exports.acquireTemplate = exports.acquireIntegrationTemplate = void 0;
                var _config = _interopRequireDefault(__webpack_require__( /*! ../config */ 80209));
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../devices */ 20530));
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../errors */ 17381));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../renderer */ 68374));
                var _child_default_template = __webpack_require__( /*! ../templates/child_default_template */ 91627);
                var _empty_template = __webpack_require__( /*! ../templates/empty_template */ 10688);
                var _template = __webpack_require__( /*! ../templates/template */ 9545);
                var _template_base = __webpack_require__( /*! ../templates/template_base */ 81033);
                var _array = __webpack_require__( /*! ./array */ 89386);
                var _common = __webpack_require__( /*! ./common */ 20576);
                var _dom = __webpack_require__( /*! ./dom */ 3532);
                var _extend = __webpack_require__( /*! ./extend */ 13306);
                var _type = __webpack_require__( /*! ./type */ 35922);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                exports.findTemplates = function(element, name) {
                    var templates = (0, _renderer.default)(element).contents().filter("[".concat("data-options", '*="').concat(name, '"]'));
                    return [].slice.call(templates).map((function(element) {
                        var optionsString = (0, _renderer.default)(element).attr("data-options") || "";
                        return {
                            element: element,
                            options: (0, _config.default)().optionsParser(optionsString)[name]
                        }
                    })).filter((function(template) {
                        return !!template.options
                    }))
                };
                exports.suitableTemplatesByName = function(rawTemplates) {
                    var templatesMap = (0, _array.groupBy)(rawTemplates, (function(template) {
                        return template.options.name
                    }));
                    if (templatesMap[void 0]) {
                        throw _errors.default.Error("E0023")
                    }
                    var result = {};
                    Object.keys(templatesMap).forEach((function(name) {
                        var _findBestMatches$;
                        var suitableTemplate = null === (_findBestMatches$ = (0, _common.findBestMatches)(_devices.default.current(), templatesMap[name], (function(template) {
                            return template.options
                        }))[0]) || void 0 === _findBestMatches$ ? void 0 : _findBestMatches$.element;
                        if (suitableTemplate) {
                            result[name] = suitableTemplate
                        }
                    }));
                    return result
                };
                var addOneRenderedCall = function(template) {
                    var _render = template.render.bind(template);
                    return (0, _extend.extend)({}, template, {
                        render: function(options) {
                            var templateResult = _render(options);
                            options && options.onRendered && options.onRendered();
                            return templateResult
                        }
                    })
                };
                exports.addOneRenderedCall = addOneRenderedCall;
                exports.getNormalizedTemplateArgs = function(options) {
                    var args = [];
                    if ("model" in options) {
                        args.push(options.model)
                    }
                    if ("index" in options) {
                        args.push(options.index)
                    }
                    args.push(options.container);
                    return args
                };
                exports.validateTemplateSource = function(templateSource) {
                    return "string" === typeof templateSource ? (0, _dom.normalizeTemplateElement)(templateSource) : templateSource
                };
                exports.templateKey = function(templateSource) {
                    return (0, _type.isRenderer)(templateSource) && templateSource[0] || templateSource
                };
                exports.defaultCreateElement = function(element) {
                    return new _template.Template(element)
                };
                var acquireIntegrationTemplate = function(templateSource, templates, isAsyncTemplate, skipTemplates) {
                    var integrationTemplate = null;
                    if (!skipTemplates || -1 === skipTemplates.indexOf(templateSource)) {
                        integrationTemplate = templates[templateSource];
                        if (integrationTemplate && !(integrationTemplate instanceof _template_base.TemplateBase) && !isAsyncTemplate) {
                            integrationTemplate = addOneRenderedCall(integrationTemplate)
                        }
                    }
                    return integrationTemplate
                };
                exports.acquireIntegrationTemplate = acquireIntegrationTemplate;
                exports.acquireTemplate = function(templateSource, createTemplate, templates, isAsyncTemplate, skipTemplates, defaultTemplates) {
                    if (null == templateSource) {
                        return new _empty_template.EmptyTemplate
                    }
                    if (templateSource instanceof _child_default_template.ChildDefaultTemplate) {
                        return defaultTemplates[templateSource.name]
                    }
                    if (templateSource instanceof _template_base.TemplateBase) {
                        return templateSource
                    }
                    if ((0, _type.isFunction)(templateSource.render) && !(0, _type.isRenderer)(templateSource)) {
                        return isAsyncTemplate ? templateSource : addOneRenderedCall(templateSource)
                    }
                    if (templateSource.nodeType || (0, _type.isRenderer)(templateSource)) {
                        return createTemplate((0, _renderer.default)(templateSource))
                    }
                    return acquireIntegrationTemplate(templateSource, templates, isAsyncTemplate, skipTemplates) || defaultTemplates[templateSource] || createTemplate(templateSource)
                }
            },
        35922:
            /*!****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/type.js ***!
              \****************************************************************/
            function(__unused_webpack_module, exports) {
                exports.type = exports.isWindow = exports.isString = exports.isRenderer = exports.isPromise = exports.isPrimitive = exports.isPlainObject = exports.isObject = exports.isNumeric = exports.isFunction = exports.isExponential = exports.isEvent = exports.isEmptyObject = exports.isDefined = exports.isDeferred = exports.isDate = exports.isBoolean = void 0;

                function _typeof(obj) {
                    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj) {
                        return typeof obj
                    } : function(obj) {
                        return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                    }, _typeof(obj)
                }
                var types = {
                    "[object Array]": "array",
                    "[object Date]": "date",
                    "[object Object]": "object",
                    "[object String]": "string",
                    "[object Null]": "null"
                };
                var type = function(object) {
                    var typeOfObject = Object.prototype.toString.call(object);
                    return "object" === _typeof(object) ? types[typeOfObject] || "object" : _typeof(object)
                };
                exports.type = type;
                exports.isBoolean = function(object) {
                    return "boolean" === typeof object
                };
                exports.isExponential = function(value) {
                    return isNumeric(value) && -1 !== value.toString().indexOf("e")
                };
                exports.isDate = function(object) {
                    return "date" === type(object)
                };
                exports.isDefined = function(object) {
                    return null !== object && void 0 !== object
                };
                var isFunction = function(object) {
                    return "function" === typeof object
                };
                exports.isFunction = isFunction;
                exports.isString = function(object) {
                    return "string" === typeof object
                };
                var isNumeric = function(object) {
                    return "number" === typeof object && isFinite(object) || !isNaN(object - parseFloat(object))
                };
                exports.isNumeric = isNumeric;
                exports.isObject = function(object) {
                    return "object" === type(object)
                };
                exports.isEmptyObject = function(object) {
                    var property;
                    for (property in object) {
                        return false
                    }
                    return true
                };
                exports.isPlainObject = function(object) {
                    if (!object || "[object Object]" !== Object.prototype.toString.call(object)) {
                        return false
                    }
                    var proto = Object.getPrototypeOf(object);
                    var ctor = Object.hasOwnProperty.call(proto, "constructor") && proto.constructor;
                    return "function" === typeof ctor && Object.toString.call(ctor) === Object.toString.call(Object)
                };
                exports.isPrimitive = function(value) {
                    return -1 === ["object", "array", "function"].indexOf(type(value))
                };
                exports.isWindow = function(object) {
                    return null != object && object === object.window
                };
                exports.isRenderer = function(object) {
                    return !!object && !!(object.jquery || object.dxRenderer)
                };
                exports.isPromise = function(object) {
                    return !!object && isFunction(object.then)
                };
                exports.isDeferred = function(object) {
                    return !!object && isFunction(object.done) && isFunction(object.fail)
                };
                exports.isEvent = function(object) {
                    return !!(object && object.preventDefault)
                }
            },
        26974:
            /*!****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/variable_wrapper.js ***!
              \****************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _console = __webpack_require__( /*! ./console */ 30869);
                var _dependency_injector = (obj = __webpack_require__( /*! ./dependency_injector */ 20476), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _default = (0, _dependency_injector.default)({
                    isWrapped: function() {
                        return false
                    },
                    isWritableWrapped: function() {
                        return false
                    },
                    wrap: function(value) {
                        return value
                    },
                    unwrap: function(value) {
                        return value
                    },
                    assign: function() {
                        _console.logger.error("Method 'assign' should not be used for not wrapped variables. Use 'isWrapped' method for ensuring.")
                    }
                });
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        58020:
            /*!*******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/version.js ***!
              \*******************************************************************/
            function(__unused_webpack_module, exports) {
                exports.compare = function(x, y, maxLevel) {
                    function normalizeArg(value) {
                        if ("string" === typeof value) {
                            return value.split(".")
                        }
                        if ("number" === typeof value) {
                            return [value]
                        }
                        return value
                    }
                    x = normalizeArg(x);
                    y = normalizeArg(y);
                    var length = Math.max(x.length, y.length);
                    if (isFinite(maxLevel)) {
                        length = Math.min(length, maxLevel)
                    }
                    for (var i = 0; i < length; i++) {
                        var xItem = parseInt(x[i] || 0, 10);
                        var yItem = parseInt(y[i] || 0, 10);
                        if (xItem < yItem) {
                            return -1
                        }
                        if (xItem > yItem) {
                            return 1
                        }
                    }
                    return 0
                }
            },
        77695:
            /*!*********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/view_port.js ***!
              \*********************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.changeCallback = void 0;
                exports.originalViewPort = function() {
                    return $originalViewPort
                };
                exports.value = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../renderer */ 68374));
                var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ./ready_callbacks */ 24311));
                var _callbacks = _interopRequireDefault(__webpack_require__( /*! ./callbacks */ 44504));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var ready = _ready_callbacks.default.add;
                var changeCallback = (0, _callbacks.default)();
                exports.changeCallback = changeCallback;
                var $originalViewPort = (0, _renderer.default)();
                var value = function(element) {
                    if (!arguments.length) {
                        return $current
                    }
                    var $element = (0, _renderer.default)(element);
                    $originalViewPort = $element;
                    var isNewViewportFound = !!$element.length;
                    var prevViewPort = value();
                    $current = isNewViewportFound ? $element : (0, _renderer.default)("body");
                    changeCallback.fire(isNewViewportFound ? value() : (0, _renderer.default)(), prevViewPort)
                };
                var $current;
                exports.value = value;
                ready((function() {
                    value(".dx-viewport")
                }))
            },
        58201:
            /*!******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/window.js ***!
              \******************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.setWindow = exports.hasWindow = exports.hasProperty = exports.getWindow = exports.getNavigator = exports.getCurrentScreenFactor = exports.defaultScreenFactorFunc = void 0;
                var _dom_adapter = (obj = __webpack_require__( /*! ../dom_adapter */ 73349), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var hasWindowValue = "undefined" !== typeof window;
                var hasWindow = function() {
                    return hasWindowValue
                };
                exports.hasWindow = hasWindow;
                var windowObject = hasWindow() ? window : void 0;
                if (!windowObject) {
                    windowObject = {};
                    windowObject.window = windowObject
                }
                exports.getWindow = function() {
                    return windowObject
                };
                exports.setWindow = function(newWindowObject, hasWindow) {
                    if (void 0 === hasWindow) {
                        hasWindowValue = "undefined" !== typeof window && window === newWindowObject
                    } else {
                        hasWindowValue = hasWindow
                    }
                    windowObject = newWindowObject
                };
                exports.hasProperty = function(prop) {
                    return hasWindow() && prop in windowObject
                };
                var defaultScreenFactorFunc = function(width) {
                    if (width < 768) {
                        return "xs"
                    } else if (width < 992) {
                        return "sm"
                    } else if (width < 1200) {
                        return "md"
                    } else {
                        return "lg"
                    }
                };
                exports.defaultScreenFactorFunc = defaultScreenFactorFunc;
                exports.getCurrentScreenFactor = function(screenFactorCallback) {
                    var screenFactorFunc = screenFactorCallback || defaultScreenFactorFunc;
                    var windowWidth = _dom_adapter.default.getDocumentElement().clientWidth;
                    return screenFactorFunc(windowWidth)
                };
                exports.getNavigator = function() {
                    return hasWindow() ? windowObject.navigator : {
                        userAgent: ""
                    }
                }
            },
        36739:
            /*!*************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/version.js ***!
              \*************************************************************/
            function(__unused_webpack_module, exports) {
                exports.version = void 0;
                exports.version = "22.1.4"
            },
        67403:
            /*!********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/abstract_store.js ***!
              \********************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _class = _interopRequireDefault(__webpack_require__( /*! ../core/class */ 38377));
                var _events_strategy = __webpack_require__( /*! ../core/events_strategy */ 80566);
                var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 95479);
                var _errors = __webpack_require__( /*! ./errors */ 18438);
                var _utils = __webpack_require__( /*! ./utils */ 16454);
                var _data = __webpack_require__( /*! ../core/utils/data */ 47617);
                var _store_helper = _interopRequireDefault(__webpack_require__( /*! ./store_helper */ 99236));
                var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 62754);
                var _common = __webpack_require__( /*! ../core/utils/common */ 20576);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _toConsumableArray(arr) {
                    return function(arr) {
                        if (Array.isArray(arr)) {
                            return _arrayLikeToArray(arr)
                        }
                    }(arr) || function(iter) {
                        if ("undefined" !== typeof Symbol && null != iter[Symbol.iterator] || null != iter["@@iterator"]) {
                            return Array.from(iter)
                        }
                    }(arr) || function(o, minLen) {
                        if (!o) {
                            return
                        }
                        if ("string" === typeof o) {
                            return _arrayLikeToArray(o, minLen)
                        }
                        var n = Object.prototype.toString.call(o).slice(8, -1);
                        if ("Object" === n && o.constructor) {
                            n = o.constructor.name
                        }
                        if ("Map" === n || "Set" === n) {
                            return Array.from(o)
                        }
                        if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                            return _arrayLikeToArray(o, minLen)
                        }
                    }(arr) || function() {
                        throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                    }()
                }

                function _arrayLikeToArray(arr, len) {
                    if (null == len || len > arr.length) {
                        len = arr.length
                    }
                    for (var i = 0, arr2 = new Array(len); i < len; i++) {
                        arr2[i] = arr[i]
                    }
                    return arr2
                }
                var abstract = _class.default.abstract;
                var queryByOptions = _store_helper.default.queryByOptions;
                var storeImpl = {};
                var Store = _class.default.inherit({
                    ctor: function(options) {
                        var that = this;
                        options = options || {};
                        this._eventsStrategy = new _events_strategy.EventsStrategy(this);
                        (0, _iterator.each)(["onLoaded", "onLoading", "onInserted", "onInserting", "onUpdated", "onUpdating", "onPush", "onRemoved", "onRemoving", "onModified", "onModifying"], (function(_, optionName) {
                            if (optionName in options) {
                                that.on(optionName.slice(2).toLowerCase(), options[optionName])
                            }
                        }));
                        this._key = options.key;
                        this._errorHandler = options.errorHandler;
                        this._useDefaultSearch = true
                    },
                    _customLoadOptions: function() {
                        return null
                    },
                    key: function() {
                        return this._key
                    },
                    keyOf: function(obj) {
                        if (!this._keyGetter) {
                            this._keyGetter = (0, _data.compileGetter)(this.key())
                        }
                        return this._keyGetter(obj)
                    },
                    _requireKey: function() {
                        if (!this.key()) {
                            throw _errors.errors.Error("E4005")
                        }
                    },
                    load: function(options) {
                        var that = this;
                        options = options || {};
                        this._eventsStrategy.fireEvent("loading", [options]);
                        return this._withLock(this._loadImpl(options)).done((function(result) {
                            that._eventsStrategy.fireEvent("loaded", [result, options])
                        }))
                    },
                    _loadImpl: function(options) {
                        return queryByOptions(this.createQuery(options), options).enumerate()
                    },
                    _withLock: function(task) {
                        var result = new _deferred.Deferred;
                        task.done((function() {
                            var that = this;
                            var args = arguments;
                            _utils.processRequestResultLock.promise().done((function() {
                                result.resolveWith(that, args)
                            }))
                        })).fail((function() {
                            result.rejectWith(this, arguments)
                        }));
                        return result
                    },
                    createQuery: abstract,
                    totalCount: function(options) {
                        return this._totalCountImpl(options)
                    },
                    _totalCountImpl: function(options) {
                        return queryByOptions(this.createQuery(options), options, true).count()
                    },
                    byKey: function(key, extraOptions) {
                        return this._addFailHandlers(this._withLock(this._byKeyImpl(key, extraOptions)))
                    },
                    _byKeyImpl: abstract,
                    insert: function(values) {
                        var that = this;
                        that._eventsStrategy.fireEvent("modifying");
                        that._eventsStrategy.fireEvent("inserting", [values]);
                        return that._addFailHandlers(that._insertImpl(values).done((function(callbackValues, callbackKey) {
                            that._eventsStrategy.fireEvent("inserted", [callbackValues, callbackKey]);
                            that._eventsStrategy.fireEvent("modified")
                        })))
                    },
                    _insertImpl: abstract,
                    update: function(key, values) {
                        var that = this;
                        that._eventsStrategy.fireEvent("modifying");
                        that._eventsStrategy.fireEvent("updating", [key, values]);
                        return that._addFailHandlers(that._updateImpl(key, values).done((function() {
                            that._eventsStrategy.fireEvent("updated", [key, values]);
                            that._eventsStrategy.fireEvent("modified")
                        })))
                    },
                    _updateImpl: abstract,
                    push: function(changes) {
                        var _this = this;
                        var beforePushArgs = {
                            changes: changes,
                            waitFor: []
                        };
                        this._eventsStrategy.fireEvent("beforePush", [beforePushArgs]);
                        _deferred.when.apply(void 0, _toConsumableArray(beforePushArgs.waitFor)).done((function() {
                            _this._pushImpl(changes);
                            _this._eventsStrategy.fireEvent("push", [changes])
                        }))
                    },
                    _pushImpl: _common.noop,
                    remove: function(key) {
                        var that = this;
                        that._eventsStrategy.fireEvent("modifying");
                        that._eventsStrategy.fireEvent("removing", [key]);
                        return that._addFailHandlers(that._removeImpl(key).done((function(callbackKey) {
                            that._eventsStrategy.fireEvent("removed", [callbackKey]);
                            that._eventsStrategy.fireEvent("modified")
                        })))
                    },
                    _removeImpl: abstract,
                    _addFailHandlers: function(deferred) {
                        return deferred.fail(this._errorHandler).fail(_errors.handleError)
                    },
                    on: function(eventName, eventHandler) {
                        this._eventsStrategy.on(eventName, eventHandler);
                        return this
                    },
                    off: function(eventName, eventHandler) {
                        this._eventsStrategy.off(eventName, eventHandler);
                        return this
                    }
                });
                Store.create = function(alias, options) {
                    if (!(alias in storeImpl)) {
                        throw _errors.errors.Error("E4020", alias)
                    }
                    return new storeImpl[alias](options)
                };
                Store.registerClass = function(type, alias) {
                    if (alias) {
                        storeImpl[alias] = type
                    }
                    return type
                };
                Store.inherit = (inheritor = Store.inherit, function(members, alias) {
                    var type = inheritor.apply(this, [members]);
                    Store.registerClass(type, alias);
                    return type
                });
                var inheritor;
                var _default = Store;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        36893:
            /*!*******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/apply_changes.js ***!
              \*******************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _array_utils = __webpack_require__( /*! ./array_utils */ 60637);
                var _default = _array_utils.applyChanges;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        35042:
            /*!*****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/array_query.js ***!
              \*****************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _class = (obj = __webpack_require__( /*! ../core/class */ 38377), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _type = __webpack_require__( /*! ../core/utils/type */ 35922);
                var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 95479);
                var _data = __webpack_require__( /*! ../core/utils/data */ 47617);
                var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 62754);
                var _errors = __webpack_require__( /*! ./errors */ 18438);
                var _utils = __webpack_require__( /*! ./utils */ 16454);
                var Iterator = _class.default.inherit({
                    toArray: function() {
                        var result = [];
                        this.reset();
                        while (this.next()) {
                            result.push(this.current())
                        }
                        return result
                    },
                    countable: function() {
                        return false
                    }
                });
                var ArrayIterator = Iterator.inherit({
                    ctor: function(array) {
                        this.array = array;
                        this.index = -1
                    },
                    next: function() {
                        if (this.index + 1 < this.array.length) {
                            this.index++;
                            return true
                        }
                        return false
                    },
                    current: function() {
                        return this.array[this.index]
                    },
                    reset: function() {
                        this.index = -1
                    },
                    toArray: function() {
                        return this.array.slice(0)
                    },
                    countable: function() {
                        return true
                    },
                    count: function() {
                        return this.array.length
                    }
                });
                var WrappedIterator = Iterator.inherit({
                    ctor: function(iter) {
                        this.iter = iter
                    },
                    next: function() {
                        return this.iter.next()
                    },
                    current: function() {
                        return this.iter.current()
                    },
                    reset: function() {
                        return this.iter.reset()
                    }
                });
                var MapIterator = WrappedIterator.inherit({
                    ctor: function(iter, mapper) {
                        this.callBase(iter);
                        this.index = -1;
                        this.mapper = mapper
                    },
                    current: function() {
                        return this.mapper(this.callBase(), this.index)
                    },
                    next: function() {
                        var hasNext = this.callBase();
                        if (hasNext) {
                            this.index++
                        }
                        return hasNext
                    }
                });
                var defaultCompare = function(xValue, yValue) {
                    xValue = (0, _data.toComparable)(xValue);
                    yValue = (0, _data.toComparable)(yValue);
                    if (null === xValue && null !== yValue) {
                        return -1
                    }
                    if (null !== xValue && null === yValue) {
                        return 1
                    }
                    if (void 0 === xValue && void 0 !== yValue) {
                        return 1
                    }
                    if (void 0 !== xValue && void 0 === yValue) {
                        return -1
                    }
                    if (xValue < yValue) {
                        return -1
                    }
                    if (xValue > yValue) {
                        return 1
                    }
                    return 0
                };
                var SortIterator = Iterator.inherit({
                    ctor: function(iter, getter, desc, compare) {
                        if (!(iter instanceof MapIterator)) {
                            iter = new MapIterator(iter, this._wrap)
                        }
                        this.iter = iter;
                        this.rules = [{
                            getter: getter,
                            desc: desc,
                            compare: compare
                        }]
                    },
                    thenBy: function(getter, desc, compare) {
                        var result = new SortIterator(this.sortedIter || this.iter, getter, desc, compare);
                        if (!this.sortedIter) {
                            result.rules = this.rules.concat(result.rules)
                        }
                        return result
                    },
                    next: function() {
                        this._ensureSorted();
                        return this.sortedIter.next()
                    },
                    current: function() {
                        this._ensureSorted();
                        return this.sortedIter.current()
                    },
                    reset: function() {
                        delete this.sortedIter
                    },
                    countable: function() {
                        return this.sortedIter || this.iter.countable()
                    },
                    count: function() {
                        if (this.sortedIter) {
                            return this.sortedIter.count()
                        }
                        return this.iter.count()
                    },
                    _ensureSorted: function() {
                        var that = this;
                        if (that.sortedIter) {
                            return
                        }(0, _iterator.each)(that.rules, (function() {
                            this.getter = (0, _data.compileGetter)(this.getter)
                        }));
                        that.sortedIter = new MapIterator(new ArrayIterator(this.iter.toArray().sort((function(x, y) {
                            return that._compare(x, y)
                        }))), that._unwrap)
                    },
                    _wrap: function(record, index) {
                        return {
                            index: index,
                            value: record
                        }
                    },
                    _unwrap: function(wrappedItem) {
                        return wrappedItem.value
                    },
                    _compare: function(x, y) {
                        var xIndex = x.index;
                        var yIndex = y.index;
                        x = x.value;
                        y = y.value;
                        if (x === y) {
                            return xIndex - yIndex
                        }
                        for (var i = 0, rulesCount = this.rules.length; i < rulesCount; i++) {
                            var rule = this.rules[i];
                            var xValue = rule.getter(x);
                            var yValue = rule.getter(y);
                            var compare = rule.compare || defaultCompare;
                            var compareResult = compare(xValue, yValue);
                            if (compareResult) {
                                return rule.desc ? -compareResult : compareResult
                            }
                        }
                        return xIndex - yIndex
                    }
                });
                var compileCriteria = function() {
                    var toString = function(value) {
                        return (0, _type.isDefined)(value) ? value.toString() : ""
                    };

                    function compileEquals(getter, value, negate) {
                        return function(obj) {
                            obj = (0, _data.toComparable)(getter(obj));
                            var result = function(value) {
                                return "" === value || 0 === value || false === value
                            }(value) ? obj === value : obj == value;
                            if (negate) {
                                result = !result
                            }
                            return result
                        }
                    }
                    return function(crit) {
                        if ((0, _type.isFunction)(crit)) {
                            return crit
                        }
                        if ((0, _utils.isGroupCriterion)(crit)) {
                            return function(crit) {
                                var ops = [];
                                var isConjunctiveOperator = false;
                                var isConjunctiveNextOperator = false;
                                (0, _iterator.each)(crit, (function() {
                                    if (Array.isArray(this) || (0, _type.isFunction)(this)) {
                                        if (ops.length > 1 && isConjunctiveOperator !== isConjunctiveNextOperator) {
                                            throw new _errors.errors.Error("E4019")
                                        }
                                        ops.push(compileCriteria(this));
                                        isConjunctiveOperator = isConjunctiveNextOperator;
                                        isConjunctiveNextOperator = true
                                    } else {
                                        isConjunctiveNextOperator = (0, _utils.isConjunctiveOperator)(this)
                                    }
                                }));
                                return function(d) {
                                    var result = isConjunctiveOperator;
                                    for (var i = 0; i < ops.length; i++) {
                                        if (ops[i](d) !== isConjunctiveOperator) {
                                            result = !isConjunctiveOperator;
                                            break
                                        }
                                    }
                                    return result
                                }
                            }(crit)
                        }
                        if ((0, _utils.isUnaryOperation)(crit)) {
                            return function(crit) {
                                var op = crit[0];
                                var criteria = compileCriteria(crit[1]);
                                if ("!" === op) {
                                    return function(obj) {
                                        return !criteria(obj)
                                    }
                                }
                                throw _errors.errors.Error("E4003", op)
                            }(crit)
                        }
                        return function(crit) {
                            crit = (0, _utils.normalizeBinaryCriterion)(crit);
                            var getter = (0, _data.compileGetter)(crit[0]);
                            var op = crit[1];
                            var value = crit[2];
                            value = (0, _data.toComparable)(value);
                            var compare = function(obj, operatorFn) {
                                obj = (0, _data.toComparable)(getter(obj));
                                return [value, obj].includes(null) && value !== obj ? false : operatorFn(obj, value)
                            };
                            switch (op.toLowerCase()) {
                                case "=":
                                    return compileEquals(getter, value);
                                case "<>":
                                    return compileEquals(getter, value, true);
                                case ">":
                                    return function(obj) {
                                        return compare(obj, (function(a, b) {
                                            return a > b
                                        }))
                                    };
                                case "<":
                                    return function(obj) {
                                        return compare(obj, (function(a, b) {
                                            return a < b
                                        }))
                                    };
                                case ">=":
                                    return function(obj) {
                                        return compare(obj, (function(a, b) {
                                            return a >= b
                                        }))
                                    };
                                case "<=":
                                    return function(obj) {
                                        return compare(obj, (function(a, b) {
                                            return a <= b
                                        }))
                                    };
                                case "startswith":
                                    return function(obj) {
                                        return 0 === (0, _data.toComparable)(toString(getter(obj))).indexOf(value)
                                    };
                                case "endswith":
                                    return function(obj) {
                                        var getterValue = (0, _data.toComparable)(toString(getter(obj)));
                                        var searchValue = toString(value);
                                        if (getterValue.length < searchValue.length) {
                                            return false
                                        }
                                        var index = getterValue.lastIndexOf(value);
                                        return -1 !== index && index === getterValue.length - value.length
                                    };
                                case "contains":
                                    return function(obj) {
                                        return (0, _data.toComparable)(toString(getter(obj))).indexOf(value) > -1
                                    };
                                case "notcontains":
                                    return function(obj) {
                                        return -1 === (0, _data.toComparable)(toString(getter(obj))).indexOf(value)
                                    }
                            }
                            throw _errors.errors.Error("E4003", op)
                        }(crit)
                    }
                }();
                var FilterIterator = WrappedIterator.inherit({
                    ctor: function(iter, criteria) {
                        this.callBase(iter);
                        this.criteria = compileCriteria(criteria)
                    },
                    next: function() {
                        while (this.iter.next()) {
                            if (this.criteria(this.current())) {
                                return true
                            }
                        }
                        return false
                    }
                });
                var GroupIterator = Iterator.inherit({
                    ctor: function(iter, getter) {
                        this.iter = iter;
                        this.getter = getter
                    },
                    next: function() {
                        this._ensureGrouped();
                        return this.groupedIter.next()
                    },
                    current: function() {
                        this._ensureGrouped();
                        return this.groupedIter.current()
                    },
                    reset: function() {
                        delete this.groupedIter
                    },
                    countable: function() {
                        return !!this.groupedIter
                    },
                    count: function() {
                        return this.groupedIter.count()
                    },
                    _ensureGrouped: function() {
                        if (this.groupedIter) {
                            return
                        }
                        var hash = {};
                        var keys = [];
                        var iter = this.iter;
                        var getter = (0, _data.compileGetter)(this.getter);
                        iter.reset();
                        while (iter.next()) {
                            var current = iter.current();
                            var key = getter(current);
                            if (key in hash) {
                                hash[key].push(current)
                            } else {
                                hash[key] = [current];
                                keys.push(key)
                            }
                        }
                        this.groupedIter = new ArrayIterator((0, _iterator.map)(keys, (function(key) {
                            return {
                                key: key,
                                items: hash[key]
                            }
                        })))
                    }
                });
                var SelectIterator = WrappedIterator.inherit({
                    ctor: function(iter, getter) {
                        this.callBase(iter);
                        this.getter = (0, _data.compileGetter)(getter)
                    },
                    current: function() {
                        return this.getter(this.callBase())
                    },
                    countable: function() {
                        return this.iter.countable()
                    },
                    count: function() {
                        return this.iter.count()
                    }
                });
                var SliceIterator = WrappedIterator.inherit({
                    ctor: function(iter, skip, take) {
                        this.callBase(iter);
                        this.skip = Math.max(0, skip);
                        this.take = Math.max(0, take);
                        this.pos = 0
                    },
                    next: function() {
                        if (this.pos >= this.skip + this.take) {
                            return false
                        }
                        while (this.pos < this.skip && this.iter.next()) {
                            this.pos++
                        }
                        this.pos++;
                        return this.iter.next()
                    },
                    reset: function() {
                        this.callBase();
                        this.pos = 0
                    },
                    countable: function() {
                        return this.iter.countable()
                    },
                    count: function() {
                        return Math.min(this.iter.count() - this.skip, this.take)
                    }
                });
                var _default = function arrayQueryImpl(iter, queryOptions) {
                    queryOptions = queryOptions || {};
                    if (!(iter instanceof Iterator)) {
                        iter = new ArrayIterator(iter)
                    }
                    var handleError = function(error) {
                        var handler = queryOptions.errorHandler;
                        if (handler) {
                            handler(error)
                        }(0, _errors.handleError)(error)
                    };
                    var aggregateCore = function(aggregator) {
                        var d = (new _deferred.Deferred).fail(handleError);
                        var seed;
                        var step = aggregator.step;
                        var finalize = aggregator.finalize;
                        try {
                            iter.reset();
                            if ("seed" in aggregator) {
                                seed = aggregator.seed
                            } else {
                                seed = iter.next() ? iter.current() : NaN
                            }
                            var accumulator = seed;
                            while (iter.next()) {
                                accumulator = step(accumulator, iter.current())
                            }
                            d.resolve(finalize ? finalize(accumulator) : accumulator)
                        } catch (x) {
                            d.reject(x)
                        }
                        return d.promise()
                    };
                    var standardAggregate = function(name) {
                        return aggregateCore(_utils.aggregators[name])
                    };
                    var select = function(getter) {
                        if (!(0, _type.isFunction)(getter) && !Array.isArray(getter)) {
                            getter = [].slice.call(arguments)
                        }
                        return chainQuery(new SelectIterator(iter, getter))
                    };
                    var selectProp = function(name) {
                        return select((0, _data.compileGetter)(name))
                    };

                    function chainQuery(iter) {
                        return arrayQueryImpl(iter, queryOptions)
                    }
                    return {
                        toArray: function() {
                            return iter.toArray()
                        },
                        enumerate: function() {
                            var d = (new _deferred.Deferred).fail(handleError);
                            try {
                                d.resolve(iter.toArray())
                            } catch (x) {
                                d.reject(x)
                            }
                            return d.promise()
                        },
                        sortBy: function(getter, desc, compare) {
                            return chainQuery(new SortIterator(iter, getter, desc, compare))
                        },
                        thenBy: function(getter, desc, compare) {
                            if (iter instanceof SortIterator) {
                                return chainQuery(iter.thenBy(getter, desc, compare))
                            }
                            throw _errors.errors.Error("E4004")
                        },
                        filter: function(criteria) {
                            if (!Array.isArray(criteria)) {
                                criteria = [].slice.call(arguments)
                            }
                            return chainQuery(new FilterIterator(iter, criteria))
                        },
                        slice: function(skip, take) {
                            if (void 0 === take) {
                                take = Number.MAX_VALUE
                            }
                            return chainQuery(new SliceIterator(iter, skip, take))
                        },
                        select: select,
                        groupBy: function(getter) {
                            return chainQuery(new GroupIterator(iter, getter))
                        },
                        aggregate: function(seed, step, finalize) {
                            if (arguments.length < 2) {
                                return aggregateCore({
                                    step: arguments[0]
                                })
                            }
                            return aggregateCore({
                                seed: seed,
                                step: step,
                                finalize: finalize
                            })
                        },
                        count: function() {
                            if (iter.countable()) {
                                var d = (new _deferred.Deferred).fail(handleError);
                                try {
                                    d.resolve(iter.count())
                                } catch (x) {
                                    d.reject(x)
                                }
                                return d.promise()
                            }
                            return standardAggregate("count")
                        },
                        sum: function(getter) {
                            if (getter) {
                                return selectProp(getter).sum()
                            }
                            return standardAggregate("sum")
                        },
                        min: function(getter) {
                            if (getter) {
                                return selectProp(getter).min()
                            }
                            return standardAggregate("min")
                        },
                        max: function(getter) {
                            if (getter) {
                                return selectProp(getter).max()
                            }
                            return standardAggregate("max")
                        },
                        avg: function(getter) {
                            if (getter) {
                                return selectProp(getter).avg()
                            }
                            return standardAggregate("avg")
                        }
                    }
                };
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        26562:
            /*!*****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/array_store.js ***!
              \*****************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _utils = __webpack_require__( /*! ./utils */ 16454);
                var _query = _interopRequireDefault(__webpack_require__( /*! ./query */ 96687));
                var _errors = __webpack_require__( /*! ./errors */ 18438);
                var _abstract_store = _interopRequireDefault(__webpack_require__( /*! ./abstract_store */ 67403));
                var _array_utils = __webpack_require__( /*! ./array_utils */ 60637);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var ArrayStore = _abstract_store.default.inherit({
                    ctor: function(options) {
                        if (Array.isArray(options)) {
                            options = {
                                data: options
                            }
                        } else {
                            options = options || {}
                        }
                        this.callBase(options);
                        var initialArray = options.data;
                        if (initialArray && !Array.isArray(initialArray)) {
                            throw _errors.errors.Error("E4006")
                        }
                        this._array = initialArray || []
                    },
                    createQuery: function() {
                        return (0, _query.default)(this._array, {
                            errorHandler: this._errorHandler
                        })
                    },
                    _byKeyImpl: function(key) {
                        var index = (0, _array_utils.indexByKey)(this, this._array, key);
                        if (-1 === index) {
                            return (0, _utils.rejectedPromise)(_errors.errors.Error("E4009"))
                        }
                        return (0, _utils.trivialPromise)(this._array[index])
                    },
                    _insertImpl: function(values) {
                        return (0, _array_utils.insert)(this, this._array, values)
                    },
                    _pushImpl: function(changes) {
                        (0, _array_utils.applyBatch)({
                            keyInfo: this,
                            data: this._array,
                            changes: changes
                        })
                    },
                    _updateImpl: function(key, values) {
                        return (0, _array_utils.update)(this, this._array, key, values)
                    },
                    _removeImpl: function(key) {
                        return (0, _array_utils.remove)(this, this._array, key)
                    },
                    clear: function() {
                        this._eventsStrategy.fireEvent("modifying");
                        this._array = [];
                        this._eventsStrategy.fireEvent("modified")
                    }
                }, "array");
                var _default = ArrayStore;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        60637:
            /*!*****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/array_utils.js ***!
              \*****************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.applyBatch = applyBatch;
                exports.applyChanges = function(data, changes) {
                    var options = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
                    var _options$keyExpr = options.keyExpr,
                        keyExpr = void 0 === _options$keyExpr ? "id" : _options$keyExpr,
                        _options$immutable = options.immutable,
                        immutable = void 0 === _options$immutable ? true : _options$immutable;
                    var keyGetter = (0, _data.compileGetter)(keyExpr);
                    var keyInfo = {
                        key: function() {
                            return keyExpr
                        },
                        keyOf: function(obj) {
                            return keyGetter(obj)
                        }
                    };
                    return applyBatch({
                        keyInfo: keyInfo,
                        data: data,
                        changes: changes,
                        immutable: immutable,
                        disableCache: true,
                        logError: true
                    })
                };
                exports.createObjectWithChanges = createObjectWithChanges;
                exports.indexByKey = indexByKey;
                exports.insert = insert;
                exports.remove = remove;
                exports.update = update;
                var _type = __webpack_require__( /*! ../core/utils/type */ 35922);
                var _config = _interopRequireDefault(__webpack_require__( /*! ../core/config */ 80209));
                var _guid = _interopRequireDefault(__webpack_require__( /*! ../core/guid */ 73176));
                var _extend = __webpack_require__( /*! ../core/utils/extend */ 13306);
                var _errors = __webpack_require__( /*! ./errors */ 18438);
                var _object = __webpack_require__( /*! ../core/utils/object */ 48013);
                var _data = __webpack_require__( /*! ../core/utils/data */ 47617);
                var _utils = __webpack_require__( /*! ./utils */ 16454);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _typeof(obj) {
                    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj) {
                        return typeof obj
                    } : function(obj) {
                        return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                    }, _typeof(obj)
                }

                function _toConsumableArray(arr) {
                    return function(arr) {
                        if (Array.isArray(arr)) {
                            return _arrayLikeToArray(arr)
                        }
                    }(arr) || function(iter) {
                        if ("undefined" !== typeof Symbol && null != iter[Symbol.iterator] || null != iter["@@iterator"]) {
                            return Array.from(iter)
                        }
                    }(arr) || function(o, minLen) {
                        if (!o) {
                            return
                        }
                        if ("string" === typeof o) {
                            return _arrayLikeToArray(o, minLen)
                        }
                        var n = Object.prototype.toString.call(o).slice(8, -1);
                        if ("Object" === n && o.constructor) {
                            n = o.constructor.name
                        }
                        if ("Map" === n || "Set" === n) {
                            return Array.from(o)
                        }
                        if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                            return _arrayLikeToArray(o, minLen)
                        }
                    }(arr) || function() {
                        throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                    }()
                }

                function _arrayLikeToArray(arr, len) {
                    if (null == len || len > arr.length) {
                        len = arr.length
                    }
                    for (var i = 0, arr2 = new Array(len); i < len; i++) {
                        arr2[i] = arr[i]
                    }
                    return arr2
                }

                function getItems(keyInfo, items, key, groupCount) {
                    if (groupCount) {
                        return function findItems(keyInfo, items, key, groupCount) {
                            var childItems;
                            var result;
                            if (groupCount) {
                                for (var i = 0; i < items.length; i++) {
                                    childItems = items[i].items || items[i].collapsedItems || [];
                                    result = findItems(keyInfo, childItems || [], key, groupCount - 1);
                                    if (result) {
                                        return result
                                    }
                                }
                            } else if (indexByKey(keyInfo, items, key) >= 0) {
                                return items
                            }
                        }(keyInfo, items, key, groupCount) || []
                    }
                    return items
                }

                function setDataByKeyMapValue(array, key, data) {
                    if (array._dataByKeyMap) {
                        array._dataByKeyMap[JSON.stringify(key)] = data;
                        array._dataByKeyMapLength += data ? 1 : -1
                    }
                }

                function createObjectWithChanges(target, changes) {
                    var result = function cloneInstance(instance, clonedInstances) {
                        clonedInstances = clonedInstances || new WeakMap;
                        var result = instance ? Object.create(Object.getPrototypeOf(instance)) : {};
                        if (instance) {
                            clonedInstances.set(instance, result)
                        }
                        var instanceWithoutPrototype = (0, _extend.extendFromObject)({}, instance);
                        for (var name in instanceWithoutPrototype) {
                            var prop = instanceWithoutPrototype[name];
                            if ((0, _type.isObject)(prop) && !(0, _type.isPlainObject)(prop) && !clonedInstances.has(prop)) {
                                instanceWithoutPrototype[name] = cloneInstance(prop, clonedInstances)
                            }
                        }(0, _object.deepExtendArraySafe)(result, instanceWithoutPrototype, true, true);
                        for (var _name in result) {
                            var _prop = result[_name];
                            if ((0, _type.isObject)(_prop) && clonedInstances.has(_prop)) {
                                result[_name] = clonedInstances.get(_prop)
                            }
                        }
                        return result
                    }(target);
                    return (0, _object.deepExtendArraySafe)(result, changes, true, true)
                }

                function applyBatch(_ref) {
                    var keyInfo = _ref.keyInfo,
                        data = _ref.data,
                        changes = _ref.changes,
                        groupCount = _ref.groupCount,
                        useInsertIndex = _ref.useInsertIndex,
                        immutable = _ref.immutable,
                        disableCache = _ref.disableCache,
                        logError = _ref.logError;
                    var resultItems = true === immutable ? _toConsumableArray(data) : data;
                    changes.forEach((function(item) {
                        var items = "insert" === item.type ? resultItems : getItems(keyInfo, resultItems, item.key, groupCount);
                        !disableCache && function(keyInfo, array) {
                            if (keyInfo.key() && (!array._dataByKeyMap || array._dataByKeyMapLength !== array.length)) {
                                var dataByKeyMap = {};
                                var arrayLength = array.length;
                                for (var i = 0; i < arrayLength; i++) {
                                    dataByKeyMap[JSON.stringify(keyInfo.keyOf(array[i]))] = array[i]
                                }
                                array._dataByKeyMap = dataByKeyMap;
                                array._dataByKeyMapLength = arrayLength
                            }
                        }(keyInfo, items);
                        switch (item.type) {
                            case "update":
                                update(keyInfo, items, item.key, item.data, true, immutable, logError);
                                break;
                            case "insert":
                                insert(keyInfo, items, item.data, useInsertIndex && (0, _type.isDefined)(item.index) ? item.index : -1, true, logError);
                                break;
                            case "remove":
                                remove(keyInfo, items, item.key, true, logError)
                        }
                    }));
                    return resultItems
                }

                function getErrorResult(isBatch, logError, errorCode) {
                    return !isBatch ? (0, _utils.rejectedPromise)(_errors.errors.Error(errorCode)) : logError && _errors.errors.log(errorCode)
                }

                function update(keyInfo, array, key, data, isBatch, immutable, logError) {
                    var target;
                    var keyExpr = keyInfo.key();
                    if (keyExpr) {
                        if (function(target, keyOrKeys) {
                                var key;
                                var keys = "string" === typeof keyOrKeys ? keyOrKeys.split() : keyOrKeys.slice();
                                while (keys.length) {
                                    key = keys.shift();
                                    if (key in target) {
                                        return true
                                    }
                                }
                                return false
                            }(data, keyExpr) && !(0, _utils.keysEqual)(keyExpr, key, keyInfo.keyOf(data))) {
                            return getErrorResult(isBatch, logError, "E4017")
                        }
                        target = function(array, key) {
                            if (array._dataByKeyMap) {
                                return array._dataByKeyMap[JSON.stringify(key)]
                            }
                        }(array, key);
                        if (!target) {
                            var index = indexByKey(keyInfo, array, key);
                            if (index < 0) {
                                return getErrorResult(isBatch, logError, "E4009")
                            }
                            target = array[index];
                            if (true === immutable && (0, _type.isDefined)(target)) {
                                var newTarget = createObjectWithChanges(target, data);
                                array[index] = newTarget;
                                return !isBatch && (0, _utils.trivialPromise)(newTarget, key)
                            }
                        }
                    } else {
                        target = key
                    }(0, _object.deepExtendArraySafe)(target, data, true);
                    if (!isBatch) {
                        if ((0, _config.default)().useLegacyStoreResult) {
                            return (0, _utils.trivialPromise)(key, data)
                        } else {
                            return (0, _utils.trivialPromise)(target, key)
                        }
                    }
                }

                function insert(keyInfo, array, data, index, isBatch, logError) {
                    var keyValue;
                    var keyExpr = keyInfo.key();
                    var obj = (0, _type.isPlainObject)(data) ? (0, _extend.extend)({}, data) : data;
                    if (keyExpr) {
                        keyValue = keyInfo.keyOf(obj);
                        if (void 0 === keyValue || "object" === _typeof(keyValue) && (0, _type.isEmptyObject)(keyValue)) {
                            if (Array.isArray(keyExpr)) {
                                throw _errors.errors.Error("E4007")
                            }
                            keyValue = obj[keyExpr] = String(new _guid.default)
                        } else if (void 0 !== array[indexByKey(keyInfo, array, keyValue)]) {
                            return getErrorResult(isBatch, logError, "E4008")
                        }
                    } else {
                        keyValue = obj
                    }
                    if (index >= 0) {
                        array.splice(index, 0, obj)
                    } else {
                        array.push(obj)
                    }
                    setDataByKeyMapValue(array, keyValue, obj);
                    if (!isBatch) {
                        return (0, _utils.trivialPromise)((0, _config.default)().useLegacyStoreResult ? data : obj, keyValue)
                    }
                }

                function remove(keyInfo, array, key, isBatch, logError) {
                    var index = indexByKey(keyInfo, array, key);
                    if (index > -1) {
                        array.splice(index, 1);
                        setDataByKeyMapValue(array, key, null)
                    }
                    if (!isBatch) {
                        return (0, _utils.trivialPromise)(key)
                    } else if (index < 0) {
                        return getErrorResult(isBatch, logError, "E4009")
                    }
                }

                function indexByKey(keyInfo, array, key) {
                    var keyExpr = keyInfo.key();
                    if (! function(array, key) {
                            if (array._dataByKeyMap) {
                                return array._dataByKeyMap[JSON.stringify(key)]
                            }
                            return true
                        }(array, key)) {
                        return -1
                    }
                    for (var i = 0, arrayLength = array.length; i < arrayLength; i++) {
                        if ((0, _utils.keysEqual)(keyExpr, keyInfo.keyOf(array[i]), key)) {
                            return i
                        }
                    }
                    return -1
                }
            },
        88036:
            /*!******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/custom_store.js ***!
              \******************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 68374));
                var _utils = __webpack_require__( /*! ./utils */ 16454);
                var _array_utils = __webpack_require__( /*! ./array_utils */ 60637);
                var _type = __webpack_require__( /*! ../core/utils/type */ 35922);
                var _config = _interopRequireDefault(__webpack_require__( /*! ../core/config */ 80209));
                var _errors = __webpack_require__( /*! ./errors */ 18438);
                var _abstract_store = _interopRequireDefault(__webpack_require__( /*! ./abstract_store */ 67403));
                var _array_query = _interopRequireDefault(__webpack_require__( /*! ./array_query */ 35042));
                var _store_helper = _interopRequireDefault(__webpack_require__( /*! ./store_helper */ 99236));
                var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 62754);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function isPromise(obj) {
                    return obj && (0, _type.isFunction)(obj.then)
                }

                function trivialPromise(value) {
                    return (new _deferred.Deferred).resolve(value).promise()
                }

                function ensureRequiredFuncOption(name, obj) {
                    if (!(0, _type.isFunction)(obj)) {
                        throw _errors.errors.Error("E4011", name)
                    }
                }

                function throwInvalidUserFuncResult(name) {
                    throw _errors.errors.Error("E4012", name)
                }

                function createUserFuncFailureHandler(pendingDeferred) {
                    function errorMessageFromXhr(promiseArguments) {
                        var xhr = promiseArguments[0];
                        var textStatus = promiseArguments[1];
                        if (!xhr || !xhr.getResponseHeader) {
                            return null
                        }
                        return (0, _utils.errorMessageFromXhr)(xhr, textStatus)
                    }
                    return function(arg) {
                        var error;
                        if (arg instanceof Error) {
                            error = arg
                        } else {
                            error = new Error(errorMessageFromXhr(arguments) || arg && String(arg) || "Unknown error")
                        }
                        if (error.message !== _utils.XHR_ERROR_UNLOAD) {
                            pendingDeferred.reject(error)
                        }
                    }
                }

                function invokeUserLoad(store, options) {
                    var userFunc = store._loadFunc;
                    var userResult;
                    ensureRequiredFuncOption("load", userFunc);
                    userResult = userFunc.apply(store, [options]);
                    if (Array.isArray(userResult)) {
                        userResult = trivialPromise(userResult)
                    } else if (null === userResult || void 0 === userResult) {
                        userResult = trivialPromise([])
                    } else if (!isPromise(userResult)) {
                        throwInvalidUserFuncResult("load")
                    }
                    return (0, _deferred.fromPromise)(userResult)
                }

                function runRawLoad(pendingDeferred, store, userFuncOptions, continuation) {
                    if (store.__rawData) {
                        continuation(store.__rawData)
                    } else {
                        var loadPromise = store.__rawDataPromise || invokeUserLoad(store, userFuncOptions);
                        if (store._cacheRawData) {
                            store.__rawDataPromise = loadPromise
                        }
                        loadPromise.always((function() {
                            delete store.__rawDataPromise
                        })).done((function(rawData) {
                            if (store._cacheRawData) {
                                store.__rawData = rawData
                            }
                            continuation(rawData)
                        })).fail(createUserFuncFailureHandler(pendingDeferred))
                    }
                }

                function runRawLoadWithQuery(pendingDeferred, store, options, countOnly) {
                    options = options || {};
                    var userFuncOptions = {};
                    if ("userData" in options) {
                        userFuncOptions.userData = options.userData
                    }
                    runRawLoad(pendingDeferred, store, userFuncOptions, (function(rawData) {
                        var rawDataQuery = (0, _array_query.default)(rawData, {
                            errorHandler: store._errorHandler
                        });
                        var itemsQuery;
                        var totalCountQuery;
                        var waitList = [];
                        var items;
                        var totalCount;
                        if (!countOnly) {
                            itemsQuery = _store_helper.default.queryByOptions(rawDataQuery, options);
                            if (itemsQuery === rawDataQuery) {
                                items = rawData.slice(0)
                            } else {
                                waitList.push(itemsQuery.enumerate().done((function(asyncResult) {
                                    items = asyncResult
                                })))
                            }
                        }
                        if (options.requireTotalCount || countOnly) {
                            totalCountQuery = _store_helper.default.queryByOptions(rawDataQuery, options, true);
                            if (totalCountQuery === rawDataQuery) {
                                totalCount = rawData.length
                            } else {
                                waitList.push(totalCountQuery.count().done((function(asyncResult) {
                                    totalCount = asyncResult
                                })))
                            }
                        }
                        _deferred.when.apply(_renderer.default, waitList).done((function() {
                            if (countOnly) {
                                pendingDeferred.resolve(totalCount)
                            } else if (options.requireTotalCount) {
                                pendingDeferred.resolve(items, {
                                    totalCount: totalCount
                                })
                            } else {
                                pendingDeferred.resolve(items)
                            }
                        })).fail((function(x) {
                            pendingDeferred.reject(x)
                        }))
                    }))
                }
                var CustomStore = _abstract_store.default.inherit({
                    ctor: function(options) {
                        options = options || {};
                        this.callBase(options);
                        this._useDefaultSearch = !!options.useDefaultSearch || "raw" === options.loadMode;
                        this._loadMode = options.loadMode;
                        this._cacheRawData = false !== options.cacheRawData;
                        this._loadFunc = options.load;
                        this._totalCountFunc = options.totalCount;
                        this._byKeyFunc = options.byKey;
                        this._insertFunc = options.insert;
                        this._updateFunc = options.update;
                        this._removeFunc = options.remove
                    },
                    createQuery: function() {
                        throw _errors.errors.Error("E4010")
                    },
                    clearRawDataCache: function() {
                        delete this.__rawData
                    },
                    _totalCountImpl: function(options) {
                        var d = new _deferred.Deferred;
                        if ("raw" === this._loadMode && !this._totalCountFunc) {
                            runRawLoadWithQuery(d, this, options, true)
                        } else {
                            (function(store, options) {
                                var userFunc = store._totalCountFunc;
                                var userResult;
                                if (!(0, _type.isFunction)(userFunc)) {
                                    throw _errors.errors.Error("E4021")
                                }
                                userResult = userFunc.apply(store, [options]);
                                if (!isPromise(userResult)) {
                                    userResult = Number(userResult);
                                    if (!isFinite(userResult)) {
                                        throwInvalidUserFuncResult("totalCount")
                                    }
                                    userResult = trivialPromise(userResult)
                                }
                                return (0, _deferred.fromPromise)(userResult)
                            })(this, options).done((function(count) {
                                d.resolve(Number(count))
                            })).fail(createUserFuncFailureHandler(d));
                            d = this._addFailHandlers(d)
                        }
                        return d.promise()
                    },
                    _pushImpl: function(changes) {
                        if (this.__rawData) {
                            (0, _array_utils.applyBatch)({
                                keyInfo: this,
                                data: this.__rawData,
                                changes: changes
                            })
                        }
                    },
                    _loadImpl: function(options) {
                        var d = new _deferred.Deferred;
                        if ("raw" === this._loadMode) {
                            runRawLoadWithQuery(d, this, options, false)
                        } else {
                            invokeUserLoad(this, options).done((function(data, extra) {
                                d.resolve(data, extra)
                            })).fail(createUserFuncFailureHandler(d));
                            d = this._addFailHandlers(d)
                        }
                        return d.promise()
                    },
                    _byKeyImpl: function(key, extraOptions) {
                        var d = new _deferred.Deferred;
                        if (this._byKeyViaLoad()) {
                            this._requireKey();
                            ! function(pendingDeferred, store, key) {
                                runRawLoad(pendingDeferred, store, {}, (function(rawData) {
                                    var keyExpr = store.key();
                                    var item;
                                    for (var i = 0, len = rawData.length; i < len; i++) {
                                        item = rawData[i];
                                        if ((0, _utils.keysEqual)(keyExpr, store.keyOf(rawData[i]), key)) {
                                            pendingDeferred.resolve(item);
                                            return
                                        }
                                    }
                                    pendingDeferred.reject(_errors.errors.Error("E4009"))
                                }))
                            }(d, this, key)
                        } else {
                            (function(store, key, extraOptions) {
                                var userFunc = store._byKeyFunc;
                                var userResult;
                                ensureRequiredFuncOption("byKey", userFunc);
                                userResult = userFunc.apply(store, [key, extraOptions]);
                                if (!isPromise(userResult)) {
                                    userResult = trivialPromise(userResult)
                                }
                                return (0, _deferred.fromPromise)(userResult)
                            })(this, key, extraOptions).done((function(obj) {
                                d.resolve(obj)
                            })).fail(createUserFuncFailureHandler(d))
                        }
                        return d.promise()
                    },
                    _byKeyViaLoad: function() {
                        return "raw" === this._loadMode && !this._byKeyFunc
                    },
                    _insertImpl: function(values) {
                        var that = this;
                        var userFunc = that._insertFunc;
                        var userResult;
                        var d = new _deferred.Deferred;
                        ensureRequiredFuncOption("insert", userFunc);
                        userResult = userFunc.apply(that, [values]);
                        if (!isPromise(userResult)) {
                            userResult = trivialPromise(userResult)
                        }(0, _deferred.fromPromise)(userResult).done((function(serverResponse) {
                            if ((0, _config.default)().useLegacyStoreResult) {
                                d.resolve(values, serverResponse)
                            } else {
                                d.resolve(serverResponse || values, that.keyOf(serverResponse))
                            }
                        })).fail(createUserFuncFailureHandler(d));
                        return d.promise()
                    },
                    _updateImpl: function(key, values) {
                        var userFunc = this._updateFunc;
                        var userResult;
                        var d = new _deferred.Deferred;
                        ensureRequiredFuncOption("update", userFunc);
                        userResult = userFunc.apply(this, [key, values]);
                        if (!isPromise(userResult)) {
                            userResult = trivialPromise(userResult)
                        }(0, _deferred.fromPromise)(userResult).done((function(serverResponse) {
                            if ((0, _config.default)().useLegacyStoreResult) {
                                d.resolve(key, values)
                            } else {
                                d.resolve(serverResponse || values, key)
                            }
                        })).fail(createUserFuncFailureHandler(d));
                        return d.promise()
                    },
                    _removeImpl: function(key) {
                        var userFunc = this._removeFunc;
                        var userResult;
                        var d = new _deferred.Deferred;
                        ensureRequiredFuncOption("remove", userFunc);
                        userResult = userFunc.apply(this, [key]);
                        if (!isPromise(userResult)) {
                            userResult = trivialPromise()
                        }(0, _deferred.fromPromise)(userResult).done((function() {
                            d.resolve(key)
                        })).fail(createUserFuncFailureHandler(d));
                        return d.promise()
                    }
                });
                var _default = CustomStore;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        33546:
            /*!*****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/data_source.js ***!
              \*****************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _data_source = __webpack_require__( /*! ./data_source/data_source */ 85273);
                var _default = _data_source.DataSource;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        85273:
            /*!*****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/data_source/data_source.js ***!
              \*****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.DataSource = void 0;
                var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 38377));
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _common = __webpack_require__( /*! ../../core/utils/common */ 20576);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 95479);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 35922);
                var _utils = __webpack_require__( /*! ../utils */ 16454);
                var _array_utils = __webpack_require__( /*! ../array_utils */ 60637);
                var _custom_store = _interopRequireDefault(__webpack_require__( /*! ../custom_store */ 88036));
                var _events_strategy = __webpack_require__( /*! ../../core/events_strategy */ 80566);
                var _errors = __webpack_require__( /*! ../errors */ 18438);
                var _queue = __webpack_require__( /*! ../../core/utils/queue */ 59504);
                var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 62754);
                var _operation_manager = _interopRequireDefault(__webpack_require__( /*! ./operation_manager */ 88665));
                var _utils2 = __webpack_require__( /*! ./utils */ 9234);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _toConsumableArray(arr) {
                    return function(arr) {
                        if (Array.isArray(arr)) {
                            return _arrayLikeToArray(arr)
                        }
                    }(arr) || function(iter) {
                        if ("undefined" !== typeof Symbol && null != iter[Symbol.iterator] || null != iter["@@iterator"]) {
                            return Array.from(iter)
                        }
                    }(arr) || function(o, minLen) {
                        if (!o) {
                            return
                        }
                        if ("string" === typeof o) {
                            return _arrayLikeToArray(o, minLen)
                        }
                        var n = Object.prototype.toString.call(o).slice(8, -1);
                        if ("Object" === n && o.constructor) {
                            n = o.constructor.name
                        }
                        if ("Map" === n || "Set" === n) {
                            return Array.from(o)
                        }
                        if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                            return _arrayLikeToArray(o, minLen)
                        }
                    }(arr) || function() {
                        throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                    }()
                }

                function _arrayLikeToArray(arr, len) {
                    if (null == len || len > arr.length) {
                        len = arr.length
                    }
                    for (var i = 0, arr2 = new Array(len); i < len; i++) {
                        arr2[i] = arr[i]
                    }
                    return arr2
                }
                var DataSource = _class.default.inherit({
                    ctor: function(options) {
                        var _options$reshapeOnPus, _this = this;
                        options = (0, _utils2.normalizeDataSourceOptions)(options);
                        this._eventsStrategy = new _events_strategy.EventsStrategy(this, {
                            syncStrategy: true
                        });
                        this._store = options.store;
                        this._changedTime = 0;
                        var needThrottling = 0 !== options.pushAggregationTimeout;
                        if (needThrottling) {
                            var throttlingTimeout = void 0 === options.pushAggregationTimeout ? function() {
                                return 5 * _this._changedTime
                            } : options.pushAggregationTimeout;
                            var pushDeferred;
                            var lastPushWaiters;
                            var throttlingPushHandler = (0, _utils.throttleChanges)((function(changes) {
                                pushDeferred.resolve();
                                var storePushPending = _deferred.when.apply(void 0, _toConsumableArray(lastPushWaiters));
                                storePushPending.done((function() {
                                    return _this._onPush(changes)
                                }));
                                lastPushWaiters = void 0;
                                pushDeferred = void 0
                            }), throttlingTimeout);
                            this._onPushHandler = function(args) {
                                _this._aggregationTimeoutId = throttlingPushHandler(args.changes);
                                if (!pushDeferred) {
                                    pushDeferred = new _deferred.Deferred
                                }
                                lastPushWaiters = args.waitFor;
                                args.waitFor.push(pushDeferred.promise())
                            };
                            this._store.on("beforePush", this._onPushHandler)
                        } else {
                            this._onPushHandler = function(changes) {
                                return _this._onPush(changes)
                            };
                            this._store.on("push", this._onPushHandler)
                        }
                        this._storeLoadOptions = this._extractLoadOptions(options);
                        this._mapFunc = options.map;
                        this._postProcessFunc = options.postProcess;
                        this._pageIndex = void 0 !== options.pageIndex ? options.pageIndex : 0;
                        this._pageSize = void 0 !== options.pageSize ? options.pageSize : 20;
                        this._loadingCount = 0;
                        this._loadQueue = this._createLoadQueue();
                        this._searchValue = "searchValue" in options ? options.searchValue : null;
                        this._searchOperation = options.searchOperation || "contains";
                        this._searchExpr = options.searchExpr;
                        this._paginate = options.paginate;
                        this._reshapeOnPush = null !== (_options$reshapeOnPus = options.reshapeOnPush) && void 0 !== _options$reshapeOnPus ? _options$reshapeOnPus : false;
                        (0, _iterator.each)(["onChanged", "onLoadError", "onLoadingChanged", "onCustomizeLoadResult", "onCustomizeStoreLoadOptions"], (function(_, optionName) {
                            if (optionName in options) {
                                _this.on(optionName.substr(2, 1).toLowerCase() + optionName.substr(3), options[optionName])
                            }
                        }));
                        this._operationManager = new _operation_manager.default;
                        this._init()
                    },
                    _init: function() {
                        this._items = [];
                        this._userData = {};
                        this._totalCount = -1;
                        this._isLoaded = false;
                        if (!(0, _type.isDefined)(this._paginate)) {
                            this._paginate = !this.group()
                        }
                        this._isLastPage = !this._paginate
                    },
                    dispose: function() {
                        var _this$_delayedLoadTas;
                        this._store.off("beforePush", this._onPushHandler);
                        this._store.off("push", this._onPushHandler);
                        this._eventsStrategy.dispose();
                        clearTimeout(this._aggregationTimeoutId);
                        null === (_this$_delayedLoadTas = this._delayedLoadTask) || void 0 === _this$_delayedLoadTas ? void 0 : _this$_delayedLoadTas.abort();
                        this._operationManager.cancelAll();
                        delete this._store;
                        delete this._items;
                        delete this._delayedLoadTask;
                        this._disposed = true
                    },
                    _extractLoadOptions: function(options) {
                        var result = {};
                        var names = ["sort", "filter", "select", "group", "requireTotalCount"];
                        var customNames = this._store._customLoadOptions();
                        if (customNames) {
                            names = names.concat(customNames)
                        }(0, _iterator.each)(names, (function() {
                            result[this] = options[this]
                        }));
                        return result
                    },
                    loadOptions: function() {
                        return this._storeLoadOptions
                    },
                    items: function() {
                        return this._items
                    },
                    pageIndex: function(newIndex) {
                        if (!(0, _type.isNumeric)(newIndex)) {
                            return this._pageIndex
                        }
                        this._pageIndex = newIndex;
                        this._isLastPage = !this._paginate
                    },
                    paginate: function(value) {
                        if (!(0, _type.isBoolean)(value)) {
                            return this._paginate
                        }
                        if (this._paginate !== value) {
                            this._paginate = value;
                            this.pageIndex(0)
                        }
                    },
                    pageSize: function(value) {
                        if (!(0, _type.isNumeric)(value)) {
                            return this._pageSize
                        }
                        this._pageSize = value
                    },
                    isLastPage: function() {
                        return this._isLastPage
                    },
                    generateStoreLoadOptionAccessor: function(optionName) {
                        var _this2 = this;
                        return function(args) {
                            var normalizedArgs = (0, _utils2.normalizeStoreLoadOptionAccessorArguments)(args);
                            if (void 0 === normalizedArgs) {
                                return _this2._storeLoadOptions[optionName]
                            }
                            _this2._storeLoadOptions[optionName] = normalizedArgs
                        }
                    },
                    sort: function() {
                        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                            args[_key] = arguments[_key]
                        }
                        return this.generateStoreLoadOptionAccessor("sort")(args)
                    },
                    filter: function() {
                        var newFilter = (0, _utils2.normalizeStoreLoadOptionAccessorArguments)(arguments);
                        if (void 0 === newFilter) {
                            return this._storeLoadOptions.filter
                        }
                        this._storeLoadOptions.filter = newFilter;
                        this.pageIndex(0)
                    },
                    group: function() {
                        for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                            args[_key2] = arguments[_key2]
                        }
                        return this.generateStoreLoadOptionAccessor("group")(args)
                    },
                    select: function() {
                        for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
                            args[_key3] = arguments[_key3]
                        }
                        return this.generateStoreLoadOptionAccessor("select")(args)
                    },
                    requireTotalCount: function(value) {
                        if (!(0, _type.isBoolean)(value)) {
                            return this._storeLoadOptions.requireTotalCount
                        }
                        this._storeLoadOptions.requireTotalCount = value
                    },
                    searchValue: function(value) {
                        if (arguments.length < 1) {
                            return this._searchValue
                        }
                        this._searchValue = value;
                        this.pageIndex(0)
                    },
                    searchOperation: function(op) {
                        if (!(0, _type.isString)(op)) {
                            return this._searchOperation
                        }
                        this._searchOperation = op;
                        this.pageIndex(0)
                    },
                    searchExpr: function(expr) {
                        var argc = arguments.length;
                        if (0 === argc) {
                            return this._searchExpr
                        }
                        if (argc > 1) {
                            expr = [].slice.call(arguments)
                        }
                        this._searchExpr = expr;
                        this.pageIndex(0)
                    },
                    store: function() {
                        return this._store
                    },
                    key: function() {
                        var _this$_store;
                        return null === (_this$_store = this._store) || void 0 === _this$_store ? void 0 : _this$_store.key()
                    },
                    totalCount: function() {
                        return this._totalCount
                    },
                    isLoaded: function() {
                        return this._isLoaded
                    },
                    isLoading: function() {
                        return this._loadingCount > 0
                    },
                    beginLoading: function() {
                        this._changeLoadingCount(1)
                    },
                    endLoading: function() {
                        this._changeLoadingCount(-1)
                    },
                    _createLoadQueue: function() {
                        return (0, _queue.create)()
                    },
                    _changeLoadingCount: function(increment) {
                        var oldLoading = this.isLoading();
                        this._loadingCount += increment;
                        var newLoading = this.isLoading();
                        if (oldLoading ^ newLoading) {
                            this._eventsStrategy.fireEvent("loadingChanged", [newLoading])
                        }
                    },
                    _scheduleLoadCallbacks: function(deferred) {
                        var _this3 = this;
                        this.beginLoading();
                        deferred.always((function() {
                            _this3.endLoading()
                        }))
                    },
                    _scheduleFailCallbacks: function(deferred) {
                        var _this4 = this;
                        deferred.fail((function() {
                            for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
                                args[_key4] = arguments[_key4]
                            }
                            if (args[0] === _utils2.CANCELED_TOKEN) {
                                return
                            }
                            _this4._eventsStrategy.fireEvent("loadError", args)
                        }))
                    },
                    _fireChanged: function(args) {
                        var date = new Date;
                        this._eventsStrategy.fireEvent("changed", args);
                        this._changedTime = new Date - date
                    },
                    _scheduleChangedCallbacks: function(deferred) {
                        var _this5 = this;
                        deferred.done((function() {
                            return _this5._fireChanged()
                        }))
                    },
                    loadSingle: function(propName, propValue) {
                        var _this6 = this;
                        var d = new _deferred.Deferred;
                        var key = this.key();
                        var store = this._store;
                        var options = this._createStoreLoadOptions();
                        var handleDone = function(data) {
                            var isEmptyArray = Array.isArray(data) && !data.length;
                            if (!(0, _type.isDefined)(data) || isEmptyArray) {
                                d.reject(new _errors.errors.Error("E4009"))
                            } else {
                                if (!Array.isArray(data)) {
                                    data = [data]
                                }
                                d.resolve(_this6._applyMapFunction(data)[0])
                            }
                        };
                        this._scheduleFailCallbacks(d);
                        if (arguments.length < 2) {
                            propValue = propName;
                            propName = key
                        }
                        delete options.skip;
                        delete options.group;
                        delete options.refresh;
                        delete options.pageIndex;
                        delete options.searchString;
                        var shouldForceByKey = function() {
                            return store instanceof _custom_store.default && !store._byKeyViaLoad()
                        };
                        (function() {
                            if (propName === key || shouldForceByKey()) {
                                return store.byKey(propValue, options)
                            }
                            options.take = 1;
                            options.filter = options.filter ? [options.filter, [propName, propValue]] : [propName, propValue];
                            return store.load(options)
                        })().fail(d.reject).done(handleDone);
                        return d.promise()
                    },
                    load: function() {
                        var _this7 = this;
                        var d = new _deferred.Deferred;
                        var loadTask = function() {
                            if (_this7._disposed) {
                                return
                            }
                            if (!(0, _utils2.isPending)(d)) {
                                return
                            }
                            return _this7._loadFromStore(loadOperation, d)
                        };
                        this._scheduleLoadCallbacks(d);
                        this._scheduleFailCallbacks(d);
                        this._scheduleChangedCallbacks(d);
                        var loadOperation = this._createLoadOperation(d);
                        this._eventsStrategy.fireEvent("customizeStoreLoadOptions", [loadOperation]);
                        this._loadQueue.add((function() {
                            if ("number" === typeof loadOperation.delay) {
                                _this7._delayedLoadTask = (0, _common.executeAsync)(loadTask, loadOperation.delay)
                            } else {
                                loadTask()
                            }
                            return d.promise()
                        }));
                        return d.promise({
                            operationId: loadOperation.operationId
                        })
                    },
                    _onPush: function(changes) {
                        var _this8 = this;
                        if (this._reshapeOnPush) {
                            this.load()
                        } else {
                            this._eventsStrategy.fireEvent("changing", [{
                                changes: changes
                            }]);
                            var group = this.group();
                            var items = this.items();
                            var groupLevel = 0;
                            var dataSourceChanges = this.paginate() || group ? changes.filter((function(item) {
                                return "update" === item.type
                            })) : changes;
                            if (group) {
                                groupLevel = Array.isArray(group) ? group.length : 1
                            }
                            if (this._mapFunc) {
                                dataSourceChanges.forEach((function(item) {
                                    if ("insert" === item.type) {
                                        item.data = _this8._mapFunc(item.data)
                                    }
                                }))
                            }(0, _array_utils.applyBatch)({
                                keyInfo: this.store(),
                                data: items,
                                changes: dataSourceChanges,
                                groupCount: groupLevel,
                                useInsertIndex: true
                            });
                            this._fireChanged([{
                                changes: changes
                            }])
                        }
                    },
                    _createLoadOperation: function(deferred) {
                        var _this9 = this;
                        var operationId = this._operationManager.add(deferred);
                        var storeLoadOptions = this._createStoreLoadOptions();
                        deferred.always((function() {
                            return _this9._operationManager.remove(operationId)
                        }));
                        return {
                            operationId: operationId,
                            storeLoadOptions: storeLoadOptions
                        }
                    },
                    reload: function() {
                        var store = this.store();
                        if (store instanceof _custom_store.default) {
                            store.clearRawDataCache()
                        }
                        this._init();
                        return this.load()
                    },
                    cancel: function(operationId) {
                        return this._operationManager.cancel(operationId)
                    },
                    cancelAll: function() {
                        return this._operationManager.cancelAll()
                    },
                    _addSearchOptions: function(storeLoadOptions) {
                        if (this._disposed) {
                            return
                        }
                        if (this.store()._useDefaultSearch) {
                            this._addSearchFilter(storeLoadOptions)
                        } else {
                            storeLoadOptions.searchOperation = this._searchOperation;
                            storeLoadOptions.searchValue = this._searchValue;
                            storeLoadOptions.searchExpr = this._searchExpr
                        }
                    },
                    _createStoreLoadOptions: function() {
                        var result = (0, _extend.extend)({}, this._storeLoadOptions);
                        this._addSearchOptions(result);
                        if (this._paginate) {
                            if (this._pageSize) {
                                result.skip = this._pageIndex * this._pageSize;
                                result.take = this._pageSize
                            }
                        }
                        result.userData = this._userData;
                        return result
                    },
                    _addSearchFilter: function(storeLoadOptions) {
                        var value = this._searchValue;
                        var op = this._searchOperation;
                        var selector = this._searchExpr;
                        var searchFilter = [];
                        if (!value) {
                            return
                        }
                        if (!selector) {
                            selector = "this"
                        }
                        if (!Array.isArray(selector)) {
                            selector = [selector]
                        }(0, _iterator.each)(selector, (function(i, item) {
                            if (searchFilter.length) {
                                searchFilter.push("or")
                            }
                            searchFilter.push([item, op, value])
                        }));
                        if (storeLoadOptions.filter) {
                            storeLoadOptions.filter = [searchFilter, storeLoadOptions.filter]
                        } else {
                            storeLoadOptions.filter = searchFilter
                        }
                    },
                    _loadFromStore: function(loadOptions, pendingDeferred) {
                        var _this10 = this;
                        var handleSuccess = function(data, extra) {
                            if (_this10._disposed) {
                                return
                            }
                            if (!(0, _utils2.isPending)(pendingDeferred)) {
                                return
                            }
                            var loadResult = (0, _extend.extend)((0, _utils2.normalizeLoadResult)(data, extra), loadOptions);
                            _this10._eventsStrategy.fireEvent("customizeLoadResult", [loadResult]);
                            (0, _deferred.when)(loadResult.data).done((function(data) {
                                loadResult.data = data;
                                _this10._processStoreLoadResult(loadResult, pendingDeferred)
                            })).fail(pendingDeferred.reject)
                        };
                        if (loadOptions.data) {
                            return (new _deferred.Deferred).resolve(loadOptions.data).done(handleSuccess)
                        }
                        return this.store().load(loadOptions.storeLoadOptions).done(handleSuccess).fail(pendingDeferred.reject)
                    },
                    _processStoreLoadResult: function(loadResult, pendingDeferred) {
                        var _this11 = this;
                        var data = loadResult.data;
                        var extra = loadResult.extra;
                        var storeLoadOptions = loadResult.storeLoadOptions;
                        var resolvePendingDeferred = function() {
                            _this11._isLoaded = true;
                            _this11._totalCount = isFinite(extra.totalCount) ? extra.totalCount : -1;
                            return pendingDeferred.resolve(data, extra)
                        };
                        if (this._disposed) {
                            return
                        }
                        data = this._applyPostProcessFunction(this._applyMapFunction(data));
                        if (!(0, _type.isPlainObject)(extra)) {
                            extra = {}
                        }
                        this._items = data;
                        if (!data.length || !this._paginate || this._pageSize && data.length < this._pageSize) {
                            this._isLastPage = true
                        }
                        if (storeLoadOptions.requireTotalCount && !isFinite(extra.totalCount)) {
                            void _this11.store().totalCount(storeLoadOptions).done((function(count) {
                                extra.totalCount = count;
                                resolvePendingDeferred()
                            })).fail(pendingDeferred.reject)
                        } else {
                            resolvePendingDeferred()
                        }
                    },
                    _applyMapFunction: function(data) {
                        if (this._mapFunc) {
                            return (0, _utils2.mapDataRespectingGrouping)(data, this._mapFunc, this.group())
                        }
                        return data
                    },
                    _applyPostProcessFunction: function(data) {
                        if (this._postProcessFunc) {
                            return this._postProcessFunc(data)
                        }
                        return data
                    },
                    on: function(eventName, eventHandler) {
                        this._eventsStrategy.on(eventName, eventHandler);
                        return this
                    },
                    off: function(eventName, eventHandler) {
                        this._eventsStrategy.off(eventName, eventHandler);
                        return this
                    }
                });
                exports.DataSource = DataSource
            },
        88665:
            /*!***********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/data_source/operation_manager.js ***!
              \***********************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _utils = __webpack_require__( /*! ./utils */ 9234);
                var OperationManager = function() {
                    function OperationManager() {
                        this._counter = -1;
                        this._deferreds = {}
                    }
                    var _proto = OperationManager.prototype;
                    _proto.add = function(deferred) {
                        this._counter++;
                        this._deferreds[this._counter] = deferred;
                        return this._counter
                    };
                    _proto.remove = function(operationId) {
                        return delete this._deferreds[operationId]
                    };
                    _proto.cancel = function(operationId) {
                        if (operationId in this._deferreds) {
                            this._deferreds[operationId].reject(_utils.CANCELED_TOKEN);
                            return true
                        }
                        return false
                    };
                    _proto.cancelAll = function() {
                        while (this._counter > -1) {
                            this.cancel(this._counter);
                            this._counter--
                        }
                    };
                    return OperationManager
                }();
                exports.default = OperationManager;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        9234:
            /*!***********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/data_source/utils.js ***!
              \***********************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.normalizeStoreLoadOptionAccessorArguments = exports.normalizeLoadResult = exports.normalizeDataSourceOptions = exports.mapDataRespectingGrouping = exports.isPending = exports.CANCELED_TOKEN = void 0;
                var _ajax = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/ajax */ 37208));
                var _abstract_store = _interopRequireDefault(__webpack_require__( /*! ../abstract_store */ 67403));
                var _array_store = _interopRequireDefault(__webpack_require__( /*! ../array_store */ 26562));
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 95479);
                var _custom_store = _interopRequireDefault(__webpack_require__( /*! ../custom_store */ 88036));
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 35922);
                var _utils = __webpack_require__( /*! ../utils */ 16454);
                var _excluded = ["items"];

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }

                function _objectWithoutProperties(source, excluded) {
                    if (null == source) {
                        return {}
                    }
                    var target = function(source, excluded) {
                        if (null == source) {
                            return {}
                        }
                        var target = {};
                        var sourceKeys = Object.keys(source);
                        var key, i;
                        for (i = 0; i < sourceKeys.length; i++) {
                            key = sourceKeys[i];
                            if (excluded.indexOf(key) >= 0) {
                                continue
                            }
                            target[key] = source[key]
                        }
                        return target
                    }(source, excluded);
                    var key, i;
                    if (Object.getOwnPropertySymbols) {
                        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
                        for (i = 0; i < sourceSymbolKeys.length; i++) {
                            key = sourceSymbolKeys[i];
                            if (excluded.indexOf(key) >= 0) {
                                continue
                            }
                            if (!Object.prototype.propertyIsEnumerable.call(source, key)) {
                                continue
                            }
                            target[key] = source[key]
                        }
                    }
                    return target
                }
                exports.CANCELED_TOKEN = "canceled";
                exports.isPending = function(deferred) {
                    return "pending" === deferred.state()
                };
                exports.normalizeStoreLoadOptionAccessorArguments = function(originalArguments) {
                    switch (originalArguments.length) {
                        case 0:
                            return;
                        case 1:
                            return originalArguments[0]
                    }
                    return [].slice.call(originalArguments)
                };
                var mapGroup = function(group, level, mapper) {
                    return (0, _iterator.map)(group, (function(item) {
                        item.items;
                        var restItem = _objectWithoutProperties(item, _excluded);
                        return _extends({}, restItem, {
                            items: mapRecursive(item.items, level - 1, mapper)
                        })
                    }))
                };
                var mapRecursive = function(items, level, mapper) {
                    if (!Array.isArray(items)) {
                        return items
                    }
                    return level ? mapGroup(items, level, mapper) : (0, _iterator.map)(items, mapper)
                };
                exports.mapDataRespectingGrouping = function(items, mapper, groupInfo) {
                    var level = groupInfo ? (0, _utils.normalizeSortingInfo)(groupInfo).length : 0;
                    return mapRecursive(items, level, mapper)
                };
                exports.normalizeLoadResult = function(data, extra) {
                    var _data;
                    if (null !== (_data = data) && void 0 !== _data && _data.data) {
                        extra = data;
                        data = data.data
                    }
                    if (!Array.isArray(data)) {
                        data = [data]
                    }
                    return {
                        data: data,
                        extra: extra
                    }
                };
                var createCustomStoreFromUrl = function(url, normalizationOptions) {
                    return new _custom_store.default({
                        load: function() {
                            return _ajax.default.sendRequest({
                                url: url,
                                dataType: "json"
                            })
                        },
                        loadMode: null === normalizationOptions || void 0 === normalizationOptions ? void 0 : normalizationOptions.fromUrlLoadMode
                    })
                };
                exports.normalizeDataSourceOptions = function(options, normalizationOptions) {
                    var store;
                    if ("string" === typeof options) {
                        options = {
                            paginate: false,
                            store: createCustomStoreFromUrl(options, normalizationOptions)
                        }
                    }
                    if (void 0 === options) {
                        options = []
                    }
                    if (Array.isArray(options) || options instanceof _abstract_store.default) {
                        options = {
                            store: options
                        }
                    } else {
                        options = (0, _extend.extend)({}, options)
                    }
                    if (void 0 === options.store) {
                        options.store = []
                    }
                    store = options.store;
                    if ("load" in options) {
                        store = function(options) {
                            var storeConfig = {};
                            (0, _iterator.each)(["useDefaultSearch", "key", "load", "loadMode", "cacheRawData", "byKey", "lookup", "totalCount", "insert", "update", "remove"], (function() {
                                storeConfig[this] = options[this];
                                delete options[this]
                            }));
                            return new _custom_store.default(storeConfig)
                        }(options)
                    } else if (Array.isArray(store)) {
                        store = new _array_store.default(store)
                    } else if ((0, _type.isPlainObject)(store)) {
                        store = function(storeConfig) {
                            var alias = storeConfig.type;
                            delete storeConfig.type;
                            return _abstract_store.default.create(alias, storeConfig)
                        }((0, _extend.extend)({}, store))
                    }
                    options.store = store;
                    return options
                }
            },
        8162:
            /*!***********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/endpoint_selector.js ***!
              \***********************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _errors = (obj = __webpack_require__( /*! ../core/errors */ 17381), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _window = __webpack_require__( /*! ../core/utils/window */ 58201);
                var window = (0, _window.getWindow)();
                var IS_WINJS_ORIGIN;
                var IS_LOCAL_ORIGIN;
                var EndpointSelector = function(config) {
                    this.config = config;
                    IS_WINJS_ORIGIN = "ms-appx:" === window.location.protocol;
                    IS_LOCAL_ORIGIN = (url = window.location.hostname, /^(localhost$|127\.)/i.test(url));
                    var url
                };
                EndpointSelector.prototype = {
                    urlFor: function(key) {
                        var bag = this.config[key];
                        if (!bag) {
                            throw _errors.default.Error("E0006")
                        }
                        if (bag.production) {
                            if (IS_WINJS_ORIGIN && !Debug.debuggerEnabled || !IS_WINJS_ORIGIN && !IS_LOCAL_ORIGIN) {
                                return bag.production
                            }
                        }
                        return bag.local
                    }
                };
                var _default = EndpointSelector;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        18438:
            /*!************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/errors.js ***!
              \************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.setErrorHandler = exports.handleError = exports.errors = exports.errorHandler = void 0;
                var _error = _interopRequireDefault(__webpack_require__( /*! ../core/utils/error */ 95640));
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../core/errors */ 17381));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var errors = (0, _error.default)(_errors.default.ERROR_MESSAGES, {
                    E4000: "[DevExpress.data]: {0}",
                    E4001: "Unknown aggregating function is detected: '{0}'",
                    E4002: "Unsupported OData protocol version is used",
                    E4003: "Unknown filter operation is used: {0}",
                    E4004: "The thenby() method is called before the sortby() method",
                    E4005: "Store requires a key expression for this operation",
                    E4006: "ArrayStore 'data' option must be an array",
                    E4007: "Compound keys cannot be auto-generated",
                    E4008: "Attempt to insert an item with a duplicated key",
                    E4009: "Data item cannot be found",
                    E4010: "CustomStore does not support creating queries",
                    E4011: "Custom Store method is not implemented or is not a function: {0}",
                    E4012: "Custom Store method returns an invalid value: {0}",
                    E4013: "Local Store requires the 'name' configuration option is specified",
                    E4014: "Unknown data type is specified for ODataStore: {0}",
                    E4015: "Unknown entity name or alias is used: {0}",
                    E4016: "The compileSetter(expr) method is called with 'self' passed as a parameter",
                    E4017: "Keys cannot be modified",
                    E4018: "The server has returned a non-numeric value in a response to an item count request",
                    E4019: "Mixing of group operators inside a single group of filter expression is not allowed",
                    E4020: "Unknown store type is detected: {0}",
                    E4021: "The server response does not provide the totalCount value",
                    E4022: "The server response does not provide the groupCount value",
                    E4023: "Could not parse the following XML: {0}",
                    E4024: "String function {0} cannot be used with the data field {1} of type {2}.",
                    W4000: "Data returned from the server has an incorrect structure",
                    W4001: 'The {0} field is listed in both "keyType" and "fieldTypes". The value of "fieldTypes" is used.',
                    W4002: "Data loading has failed for some cells due to the following error: {0}"
                });
                exports.errors = errors;
                var errorHandler = null;
                exports.errorHandler = errorHandler;
                exports.handleError = function(error) {
                    var _errorHandler;
                    null === (_errorHandler = errorHandler) || void 0 === _errorHandler ? void 0 : _errorHandler(error)
                };
                exports.setErrorHandler = function(handler) {
                    return exports.errorHandler = errorHandler = handler
                }
            },
        82837:
            /*!*****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/local_store.js ***!
              \*****************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../events/core/events_engine */ 55994));
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../core/dom_adapter */ 73349));
                var _window = __webpack_require__( /*! ../core/utils/window */ 58201);
                var _class = _interopRequireDefault(__webpack_require__( /*! ../core/class */ 38377));
                var _errors = __webpack_require__( /*! ./errors */ 18438);
                var _array_store = _interopRequireDefault(__webpack_require__( /*! ./array_store */ 26562));
                var _query = _interopRequireDefault(__webpack_require__( /*! ./query */ 96687));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var window = (0, _window.getWindow)();
                var abstract = _class.default.abstract;
                var LocalStoreBackend = _class.default.inherit({
                    ctor: function(store, storeOptions) {
                        this._store = store;
                        this._dirty = !!storeOptions.data;
                        this.save();
                        var immediate = this._immediate = storeOptions.immediate;
                        var flushInterval = Math.max(100, storeOptions.flushInterval || 1e4);
                        if (!immediate) {
                            var saveProxy = this.save.bind(this);
                            setInterval(saveProxy, flushInterval);
                            _events_engine.default.on(window, "beforeunload", saveProxy);
                            if (window.cordova) {
                                _dom_adapter.default.listen(_dom_adapter.default.getDocument(), "pause", saveProxy, false)
                            }
                        }
                    },
                    notifyChanged: function() {
                        this._dirty = true;
                        if (this._immediate) {
                            this.save()
                        }
                    },
                    load: function() {
                        this._store._array = this._loadImpl();
                        this._dirty = false
                    },
                    save: function() {
                        if (!this._dirty) {
                            return
                        }
                        this._saveImpl(this._store._array);
                        this._dirty = false
                    },
                    _loadImpl: abstract,
                    _saveImpl: abstract
                });
                var DomLocalStoreBackend = LocalStoreBackend.inherit({
                    ctor: function(store, storeOptions) {
                        var name = storeOptions.name;
                        if (!name) {
                            throw _errors.errors.Error("E4013")
                        }
                        this._key = "dx-data-localStore-" + name;
                        this.callBase(store, storeOptions)
                    },
                    _loadImpl: function() {
                        var raw = window.localStorage.getItem(this._key);
                        if (raw) {
                            return JSON.parse(raw)
                        }
                        return []
                    },
                    _saveImpl: function(array) {
                        if (!array.length) {
                            window.localStorage.removeItem(this._key)
                        } else {
                            window.localStorage.setItem(this._key, JSON.stringify(array))
                        }
                    }
                });
                var localStoreBackends = {
                    dom: DomLocalStoreBackend
                };
                var LocalStore = _array_store.default.inherit({
                    ctor: function(options) {
                        if ("string" === typeof options) {
                            options = {
                                name: options
                            }
                        } else {
                            options = options || {}
                        }
                        this.callBase(options);
                        this._backend = new localStoreBackends[options.backend || "dom"](this, options);
                        this._backend.load()
                    },
                    clear: function() {
                        this.callBase();
                        this._backend.notifyChanged()
                    },
                    createQuery: function() {
                        return (0, _query.default)(this._backend._loadImpl(), {
                            errorHandler: this._errorHandler
                        })
                    },
                    _insertImpl: function(values) {
                        var b = this._backend;
                        return this.callBase(values).done(b.notifyChanged.bind(b))
                    },
                    _updateImpl: function(key, values) {
                        var b = this._backend;
                        return this.callBase(key, values).done(b.notifyChanged.bind(b))
                    },
                    _removeImpl: function(key) {
                        var b = this._backend;
                        return this.callBase(key).done(b.notifyChanged.bind(b))
                    }
                }, "local");
                var _default = LocalStore;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        47256:
            /*!*******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/odata/context.js ***!
              \*******************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 38377));
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 35922);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 95479);
                var _errors = __webpack_require__( /*! ../errors */ 18438);
                var _store = _interopRequireDefault(__webpack_require__( /*! ./store */ 341));
                var _request_dispatcher = _interopRequireDefault(__webpack_require__( /*! ./request_dispatcher */ 63081));
                var _utils = __webpack_require__( /*! ./utils */ 77869);
                var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 62754);
                __webpack_require__( /*! ./query_adapter */ 54263);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var ODataContext = _class.default.inherit({
                    ctor: function(options) {
                        var _this = this;
                        this._requestDispatcher = new _request_dispatcher.default(options);
                        this._errorHandler = options.errorHandler;
                        (0, _iterator.each)(options.entities || [], (function(entityAlias, entityOptions) {
                            _this[entityAlias] = new _store.default((0, _extend.extend)({}, options, {
                                url: "".concat(_this._requestDispatcher.url, "/").concat(encodeURIComponent(entityOptions.name || entityAlias))
                            }, entityOptions))
                        }))
                    },
                    get: function(operationName, params) {
                        return this.invoke(operationName, params, "GET")
                    },
                    invoke: function(operationName) {
                        var params = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
                        var httpMethod = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : "POST";
                        httpMethod = httpMethod.toLowerCase();
                        var d = new _deferred.Deferred;
                        var url = "".concat(this._requestDispatcher.url, "/").concat(encodeURIComponent(operationName));
                        var payload;
                        if (4 === this.version()) {
                            if ("get" === httpMethod) {
                                url = (0, _utils.formatFunctionInvocationUrl)(url, (0, _utils.escapeServiceOperationParams)(params, this.version()));
                                params = null
                            } else if ("post" === httpMethod) {
                                payload = params;
                                params = null
                            }
                        }(0, _deferred.when)(this._requestDispatcher.sendRequest(url, httpMethod, (0, _utils.escapeServiceOperationParams)(params, this.version()), payload)).done((function(r) {
                            if ((0, _type.isPlainObject)(r) && operationName in r) {
                                r = r[operationName]
                            }
                            d.resolve(r)
                        })).fail(this._errorHandler).fail(_errors.handleError).fail(d.reject);
                        return d.promise()
                    },
                    objectLink: function(entityAlias, key) {
                        var store = this[entityAlias];
                        if (!store) {
                            throw _errors.errors.Error("E4015", entityAlias)
                        }
                        if (!(0, _type.isDefined)(key)) {
                            return null
                        }
                        return {
                            __metadata: {
                                uri: store._byKeyUrl(key)
                            }
                        }
                    },
                    version: function() {
                        return this._requestDispatcher.version
                    }
                });
                var _default = ODataContext;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        54263:
            /*!*************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/odata/query_adapter.js ***!
              \*************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.odata = void 0;
                var _type = __webpack_require__( /*! ../../core/utils/type */ 35922);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 95479);
                var _config = _interopRequireDefault(__webpack_require__( /*! ../../core/config */ 80209));
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _query_adapters = _interopRequireDefault(__webpack_require__( /*! ../query_adapters */ 16135));
                var _utils = __webpack_require__( /*! ./utils */ 77869);
                var _errors = __webpack_require__( /*! ../errors */ 18438);
                var _utils2 = __webpack_require__( /*! ../utils */ 16454);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var STRING_FUNCTIONS = ["contains", "notcontains", "startswith", "endswith"];
                var compileCriteria = (createBinaryOperationFormatter = function(op) {
                    return function(prop, val) {
                        return "".concat(prop, " ").concat(op, " ").concat(val)
                    }
                }, createStringFuncFormatter = function(op, reverse) {
                    return function(prop, val) {
                        var bag = [op, "("];
                        if (forceLowerCase) {
                            prop = -1 === prop.indexOf("tolower(") ? "tolower(".concat(prop, ")") : prop;
                            val = val.toLowerCase()
                        }
                        if (reverse) {
                            bag.push(val, ",", prop)
                        } else {
                            bag.push(prop, ",", val)
                        }
                        bag.push(")");
                        return bag.join("")
                    }
                }, formatters = {
                    "=": createBinaryOperationFormatter("eq"),
                    "<>": createBinaryOperationFormatter("ne"),
                    ">": createBinaryOperationFormatter("gt"),
                    ">=": createBinaryOperationFormatter("ge"),
                    "<": createBinaryOperationFormatter("lt"),
                    "<=": createBinaryOperationFormatter("le"),
                    startswith: createStringFuncFormatter("startswith"),
                    endswith: createStringFuncFormatter("endswith")
                }, formattersV2 = (0, _extend.extend)({}, formatters, {
                    contains: createStringFuncFormatter("substringof", true),
                    notcontains: createStringFuncFormatter("not substringof", true)
                }), formattersV4 = (0, _extend.extend)({}, formatters, {
                    contains: createStringFuncFormatter("contains"),
                    notcontains: createStringFuncFormatter("not contains")
                }), compileBinary = function(criteria) {
                    var _fieldTypes;
                    criteria = (0, _utils2.normalizeBinaryCriterion)(criteria);
                    var op = criteria[1];
                    var fieldName = criteria[0];
                    var fieldType = fieldTypes && fieldTypes[fieldName];
                    if (fieldType && (name = op, STRING_FUNCTIONS.some((function(funcName) {
                            return funcName === name
                        }))) && "String" !== fieldType) {
                        throw new _errors.errors.Error("E4024", op, fieldName, fieldType)
                    }
                    var name;
                    var formatters = 4 === protocolVersion ? formattersV4 : formattersV2;
                    var formatter = formatters[op.toLowerCase()];
                    if (!formatter) {
                        throw _errors.errors.Error("E4003", op)
                    }
                    var value = criteria[2];
                    if (null !== (_fieldTypes = fieldTypes) && void 0 !== _fieldTypes && _fieldTypes[fieldName]) {
                        value = (0, _utils.convertPrimitiveValue)(fieldTypes[fieldName], value)
                    }
                    return formatter((0, _utils.serializePropName)(fieldName), (0, _utils.serializeValue)(value, protocolVersion))
                }, compileUnary = function(criteria) {
                    var op = criteria[0];
                    var crit = compileCore(criteria[1]);
                    if ("!" === op) {
                        return "not (".concat(crit, ")")
                    }
                    throw _errors.errors.Error("E4003", op)
                }, compileGroup = function(criteria) {
                    var bag = [];
                    var groupOperator;
                    var nextGroupOperator;
                    (0, _iterator.each)(criteria, (function(index, criterion) {
                        if (Array.isArray(criterion)) {
                            if (bag.length > 1 && groupOperator !== nextGroupOperator) {
                                throw new _errors.errors.Error("E4019")
                            }
                            bag.push("(".concat(compileCore(criterion), ")"));
                            groupOperator = nextGroupOperator;
                            nextGroupOperator = "and"
                        } else {
                            nextGroupOperator = (0, _utils2.isConjunctiveOperator)(this) ? "and" : "or"
                        }
                    }));
                    return bag.join(" ".concat(groupOperator, " "))
                }, compileCore = function(criteria) {
                    if (Array.isArray(criteria[0])) {
                        return compileGroup(criteria)
                    }
                    if ((0, _utils2.isUnaryOperation)(criteria)) {
                        return compileUnary(criteria)
                    }
                    return compileBinary(criteria)
                }, function(criteria, version, types, filterToLower) {
                    fieldTypes = types;
                    forceLowerCase = null !== filterToLower && void 0 !== filterToLower ? filterToLower : (0, _config.default)().oDataFilterToLower;
                    protocolVersion = version;
                    return compileCore(criteria)
                });
                var protocolVersion, forceLowerCase, fieldTypes, createBinaryOperationFormatter, createStringFuncFormatter, formatters, formattersV2, formattersV4, compileBinary, compileUnary, compileGroup, compileCore;
                var createODataQueryAdapter = function(queryOptions) {
                    var _sorting = [];
                    var _criteria = [];
                    var _expand = queryOptions.expand;
                    var _select;
                    var _skip;
                    var _take;
                    var _countQuery;
                    var _oDataVersion = queryOptions.version || 2;
                    var hasSlice = function() {
                        return _skip || void 0 !== _take
                    };
                    var hasFunction = function hasFunction(criterion) {
                        for (var i = 0; i < criterion.length; i++) {
                            if ((0, _type.isFunction)(criterion[i])) {
                                return true
                            }
                            if (Array.isArray(criterion[i]) && hasFunction(criterion[i])) {
                                return true
                            }
                        }
                        return false
                    };
                    var requestData = function() {
                        var result = {};
                        if (!_countQuery) {
                            if (_sorting.length) {
                                result.$orderby = _sorting.join(",")
                            }
                            if (_skip) {
                                result.$skip = _skip
                            }
                            if (void 0 !== _take) {
                                result.$top = _take
                            }
                            result.$select = (0, _utils.generateSelect)(_oDataVersion, _select) || void 0;
                            result.$expand = (0, _utils.generateExpand)(_oDataVersion, _expand, _select) || void 0
                        }
                        if (_criteria.length) {
                            var criteria = _criteria.length < 2 ? _criteria[0] : _criteria;
                            var fieldTypes = null === queryOptions || void 0 === queryOptions ? void 0 : queryOptions.fieldTypes;
                            var filterToLower = null === queryOptions || void 0 === queryOptions ? void 0 : queryOptions.filterToLower;
                            result.$filter = compileCriteria(criteria, _oDataVersion, fieldTypes, filterToLower)
                        }
                        if (_countQuery) {
                            result.$top = 0
                        }
                        if (queryOptions.requireTotalCount || _countQuery) {
                            if (4 !== _oDataVersion) {
                                result.$inlinecount = "allpages"
                            } else {
                                result.$count = "true"
                            }
                        }
                        return result
                    };
                    return {
                        optimize: function(tasks) {
                            var selectIndex = -1;
                            for (var i = 0; i < tasks.length; i++) {
                                if ("select" === tasks[i].name) {
                                    selectIndex = i;
                                    break
                                }
                            }
                            if (selectIndex < 0 || !(0, _type.isFunction)(tasks[selectIndex].args[0])) {
                                return
                            }
                            var nextTask = tasks[1 + selectIndex];
                            if (!nextTask || "slice" !== nextTask.name) {
                                return
                            }
                            tasks[1 + selectIndex] = tasks[selectIndex];
                            tasks[selectIndex] = nextTask
                        },
                        exec: function(url) {
                            return (0, _utils.sendRequest)(_oDataVersion, {
                                url: url,
                                params: (0, _extend.extend)(requestData(), null === queryOptions || void 0 === queryOptions ? void 0 : queryOptions.params)
                            }, {
                                beforeSend: queryOptions.beforeSend,
                                jsonp: queryOptions.jsonp,
                                withCredentials: queryOptions.withCredentials,
                                countOnly: _countQuery,
                                deserializeDates: queryOptions.deserializeDates,
                                fieldTypes: queryOptions.fieldTypes,
                                isPaged: isFinite(_take)
                            })
                        },
                        multiSort: function(args) {
                            var rules;
                            if (hasSlice()) {
                                return false
                            }
                            for (var i = 0; i < args.length; i++) {
                                var getter = args[i][0];
                                var desc = !!args[i][1];
                                var rule = void 0;
                                if ("string" !== typeof getter) {
                                    return false
                                }
                                rule = (0, _utils.serializePropName)(getter);
                                if (desc) {
                                    rule += " desc"
                                }
                                rules = rules || [];
                                rules.push(rule)
                            }
                            _sorting = rules
                        },
                        slice: function(skipCount, takeCount) {
                            if (hasSlice()) {
                                return false
                            }
                            _skip = skipCount;
                            _take = takeCount
                        },
                        filter: function(criterion) {
                            if (hasSlice()) {
                                return false
                            }
                            if (!Array.isArray(criterion)) {
                                criterion = [].slice.call(arguments)
                            }
                            if (hasFunction(criterion)) {
                                return false
                            }
                            if (_criteria.length) {
                                _criteria.push("and")
                            }
                            _criteria.push(criterion)
                        },
                        select: function(expr) {
                            if (_select || (0, _type.isFunction)(expr)) {
                                return false
                            }
                            if (!Array.isArray(expr)) {
                                expr = [].slice.call(arguments)
                            }
                            _select = expr
                        },
                        count: function() {
                            return _countQuery = true
                        }
                    }
                };
                _query_adapters.default.odata = createODataQueryAdapter;
                var odata = createODataQueryAdapter;
                exports.odata = odata
            },
        63081:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/odata/request_dispatcher.js ***!
              \******************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _utils = __webpack_require__( /*! ./utils */ 77869);
                __webpack_require__( /*! ./query_adapter */ 54263);

                function _defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) {
                            descriptor.writable = true
                        }
                        Object.defineProperty(target, descriptor.key, descriptor)
                    }
                }
                var RequestDispatcher = function() {
                    function RequestDispatcher(options) {
                        options = options || {};
                        this._url = String(options.url).replace(/\/+$/, "");
                        this._beforeSend = options.beforeSend;
                        this._jsonp = options.jsonp;
                        this._version = options.version || 2;
                        this._withCredentials = options.withCredentials;
                        this._deserializeDates = options.deserializeDates;
                        this._filterToLower = options.filterToLower
                    }
                    var _proto = RequestDispatcher.prototype;
                    _proto.sendRequest = function(url, method, params, payload) {
                        return (0, _utils.sendRequest)(this.version, {
                            url: url,
                            method: method,
                            params: params || {},
                            payload: payload
                        }, {
                            beforeSend: this._beforeSend,
                            jsonp: this._jsonp,
                            withCredentials: this._withCredentials,
                            deserializeDates: this._deserializeDates
                        })
                    };
                    ! function(Constructor, protoProps, staticProps) {
                        if (protoProps) {
                            _defineProperties(Constructor.prototype, protoProps)
                        }
                        if (staticProps) {
                            _defineProperties(Constructor, staticProps)
                        }
                        Object.defineProperty(Constructor, "prototype", {
                            writable: false
                        });
                        return Constructor
                    }(RequestDispatcher, [{
                        key: "version",
                        get: function() {
                            return this._version
                        }
                    }, {
                        key: "beforeSend",
                        get: function() {
                            return this._beforeSend
                        }
                    }, {
                        key: "url",
                        get: function() {
                            return this._url
                        }
                    }, {
                        key: "jsonp",
                        get: function() {
                            return this._jsonp
                        }
                    }, {
                        key: "filterToLower",
                        get: function() {
                            return this._filterToLower
                        }
                    }]);
                    return RequestDispatcher
                }();
                exports.default = RequestDispatcher;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        341:
            /*!*****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/odata/store.js ***!
              \*****************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _type = __webpack_require__( /*! ../../core/utils/type */ 35922);
                var _config = _interopRequireDefault(__webpack_require__( /*! ../../core/config */ 80209));
                var _utils = __webpack_require__( /*! ./utils */ 77869);
                var _errors = __webpack_require__( /*! ../errors */ 18438);
                var _query = _interopRequireDefault(__webpack_require__( /*! ../query */ 96687));
                var _abstract_store = _interopRequireDefault(__webpack_require__( /*! ../abstract_store */ 67403));
                var _request_dispatcher = _interopRequireDefault(__webpack_require__( /*! ./request_dispatcher */ 63081));
                var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 62754);
                __webpack_require__( /*! ./query_adapter */ 54263);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var expandKeyType = function(key, keyType) {
                    return function(obj, key, value) {
                        if (key in obj) {
                            Object.defineProperty(obj, key, {
                                value: value,
                                enumerable: true,
                                configurable: true,
                                writable: true
                            })
                        } else {
                            obj[key] = value
                        }
                        return obj
                    }({}, key, keyType)
                };
                var ODataStore = _abstract_store.default.inherit({
                    ctor: function(options) {
                        this.callBase(options);
                        this._requestDispatcher = new _request_dispatcher.default(options);
                        var key = this.key();
                        var fieldTypes = options.fieldTypes;
                        var keyType = options.keyType;
                        if (keyType) {
                            var keyTypeIsString = "string" === typeof keyType;
                            if (!key) {
                                key = keyTypeIsString ? "5d46402c-7899-4ea9-bd81-8b73c47c7683" : Object.keys(keyType);
                                this._legacyAnonymousKey = key
                            }
                            if (keyTypeIsString) {
                                keyType = expandKeyType(key, keyType)
                            }
                            fieldTypes = function(fieldTypes, keyType) {
                                var result = {};
                                for (var field in fieldTypes) {
                                    result[field] = fieldTypes[field]
                                }
                                for (var keyName in keyType) {
                                    if (keyName in result) {
                                        if (result[keyName] !== keyType[keyName]) {
                                            _errors.errors.log("W4001", keyName)
                                        }
                                    } else {
                                        result[keyName] = keyType[keyName]
                                    }
                                }
                                return result
                            }(fieldTypes, keyType)
                        }
                        this._fieldTypes = fieldTypes || {};
                        if (2 === this.version()) {
                            this._updateMethod = "MERGE"
                        } else {
                            this._updateMethod = "PATCH"
                        }
                    },
                    _customLoadOptions: function() {
                        return ["expand", "customQueryParams"]
                    },
                    _byKeyImpl: function(key, extraOptions) {
                        var params = {};
                        if (extraOptions) {
                            params.$expand = (0, _utils.generateExpand)(this.version(), extraOptions.expand, extraOptions.select) || void 0;
                            params.$select = (0, _utils.generateSelect)(this.version(), extraOptions.select) || void 0
                        }
                        return this._requestDispatcher.sendRequest(this._byKeyUrl(key), "GET", params)
                    },
                    createQuery: function(loadOptions) {
                        var _loadOptions$urlOverr;
                        var url;
                        var queryOptions = {
                            adapter: "odata",
                            beforeSend: this._requestDispatcher.beforeSend,
                            errorHandler: this._errorHandler,
                            jsonp: this._requestDispatcher.jsonp,
                            version: this._requestDispatcher.version,
                            withCredentials: this._requestDispatcher._withCredentials,
                            expand: null === loadOptions || void 0 === loadOptions ? void 0 : loadOptions.expand,
                            requireTotalCount: null === loadOptions || void 0 === loadOptions ? void 0 : loadOptions.requireTotalCount,
                            deserializeDates: this._requestDispatcher._deserializeDates,
                            fieldTypes: this._fieldTypes
                        };
                        url = null !== (_loadOptions$urlOverr = null === loadOptions || void 0 === loadOptions ? void 0 : loadOptions.urlOverride) && void 0 !== _loadOptions$urlOverr ? _loadOptions$urlOverr : this._requestDispatcher.url;
                        if ((0, _type.isDefined)(this._requestDispatcher.filterToLower)) {
                            queryOptions.filterToLower = this._requestDispatcher.filterToLower
                        }
                        if (null !== loadOptions && void 0 !== loadOptions && loadOptions.customQueryParams) {
                            var params = (0, _utils.escapeServiceOperationParams)(null === loadOptions || void 0 === loadOptions ? void 0 : loadOptions.customQueryParams, this.version());
                            if (4 === this.version()) {
                                url = (0, _utils.formatFunctionInvocationUrl)(url, params)
                            } else {
                                queryOptions.params = params
                            }
                        }
                        return (0, _query.default)(url, queryOptions)
                    },
                    _insertImpl: function(values) {
                        var _this = this;
                        this._requireKey();
                        var d = new _deferred.Deferred;
                        (0, _deferred.when)(this._requestDispatcher.sendRequest(this._requestDispatcher.url, "POST", null, values)).done((function(serverResponse) {
                            return d.resolve(serverResponse && !(0, _config.default)().useLegacyStoreResult ? serverResponse : values, _this.keyOf(serverResponse))
                        })).fail(d.reject);
                        return d.promise()
                    },
                    _updateImpl: function(key, values) {
                        var d = new _deferred.Deferred;
                        (0, _deferred.when)(this._requestDispatcher.sendRequest(this._byKeyUrl(key), this._updateMethod, null, values)).done((function(serverResponse) {
                            return (0, _config.default)().useLegacyStoreResult ? d.resolve(key, values) : d.resolve(serverResponse || values, key)
                        })).fail(d.reject);
                        return d.promise()
                    },
                    _removeImpl: function(key) {
                        var d = new _deferred.Deferred;
                        (0, _deferred.when)(this._requestDispatcher.sendRequest(this._byKeyUrl(key), "DELETE")).done((function() {
                            return d.resolve(key)
                        })).fail(d.reject);
                        return d.promise()
                    },
                    _convertKey: function(value) {
                        var result = value;
                        var fieldTypes = this._fieldTypes;
                        var key = this.key() || this._legacyAnonymousKey;
                        if (Array.isArray(key)) {
                            result = {};
                            for (var i = 0; i < key.length; i++) {
                                var keyName = key[i];
                                result[keyName] = (0, _utils.convertPrimitiveValue)(fieldTypes[keyName], value[keyName])
                            }
                        } else if (fieldTypes[key]) {
                            result = (0, _utils.convertPrimitiveValue)(fieldTypes[key], value)
                        }
                        return result
                    },
                    _byKeyUrl: function(value) {
                        var baseUrl = this._requestDispatcher.url;
                        var convertedKey = this._convertKey(value);
                        return "".concat(baseUrl, "(").concat(encodeURIComponent((0, _utils.serializeKey)(convertedKey, this.version())), ")")
                    },
                    version: function() {
                        return this._requestDispatcher.version
                    }
                }, "odata");
                var _default = ODataStore;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        77869:
            /*!*****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/odata/utils.js ***!
              \*****************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.serializeValue = exports.serializePropName = exports.serializeKey = exports.sendRequest = exports.keyConverters = exports.generateSelect = exports.generateExpand = exports.formatFunctionInvocationUrl = exports.escapeServiceOperationParams = exports.convertPrimitiveValue = exports.EdmLiteral = void 0;
                var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 38377));
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 35922);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 95479);
                var _ajax = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/ajax */ 37208));
                var _guid = _interopRequireDefault(__webpack_require__( /*! ../../core/guid */ 73176));
                var _common = __webpack_require__( /*! ../../core/utils/common */ 20576);
                var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 62754);
                var _errors = __webpack_require__( /*! ../errors */ 18438);
                var _utils = __webpack_require__( /*! ../utils */ 16454);
                var _string = __webpack_require__( /*! ../../core/utils/string */ 68752);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _typeof(obj) {
                    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj) {
                        return typeof obj
                    } : function(obj) {
                        return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                    }, _typeof(obj)
                }
                var GUID_REGEX = /^(\{{0,1}([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}\}{0,1})$/;
                var VERBOSE_DATE_REGEX = /^\/Date\((-?\d+)((\+|-)?(\d+)?)\)\/$/;
                var ISO8601_DATE_REGEX = /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d+)?(Z|[-+]{1}\d{2}(:?)(\d{2})?)?$/;
                var JSON_VERBOSE_MIME_TYPE = "application/json;odata=verbose";
                var makeArray = function(value) {
                    return "string" === (0, _type.type)(value) ? value.split() : value
                };
                var hasDot = function(x) {
                    return /\./.test(x)
                };
                var pad = function(text, length, right) {
                    text = String(text);
                    while (text.length < length) {
                        text = right ? "".concat(text, "0") : "0".concat(text)
                    }
                    return text
                };
                var formatISO8601 = function(date, skipZeroTime, skipTimezone) {
                    var bag = [];
                    var padLeft2 = function(text) {
                        return pad(text, 2)
                    };
                    bag.push(date.getFullYear());
                    bag.push("-");
                    bag.push(padLeft2(date.getMonth() + 1));
                    bag.push("-");
                    bag.push(padLeft2(date.getDate()));
                    if (!(skipZeroTime && date.getHours() + date.getMinutes() + date.getSeconds() + date.getMilliseconds() < 1)) {
                        bag.push("T");
                        bag.push(padLeft2(date.getHours()));
                        bag.push(":");
                        bag.push(padLeft2(date.getMinutes()));
                        bag.push(":");
                        bag.push(padLeft2(date.getSeconds()));
                        if (date.getMilliseconds()) {
                            bag.push(".");
                            bag.push(pad(date.getMilliseconds(), 3))
                        }
                        if (!skipTimezone) {
                            bag.push("Z")
                        }
                    }
                    return bag.join("")
                };
                var parseISO8601 = function(isoString) {
                    var result = new Date(60 * new Date(0).getTimezoneOffset() * 1e3);
                    var chunks = isoString.replace("Z", "").split("T");
                    var date = /(\d{4})-(\d{2})-(\d{2})/.exec(chunks[0]);
                    var time = /(\d{2}):(\d{2}):(\d{2})\.?(\d{0,7})?/.exec(chunks[1]);
                    result.setFullYear(Number(date[1]));
                    result.setMonth(Number(date[2]) - 1);
                    result.setDate(Number(date[3]));
                    if (Array.isArray(time) && time.length) {
                        result.setHours(Number(time[1]));
                        result.setMinutes(Number(time[2]));
                        result.setSeconds(Number(time[3]));
                        var fractional = (time[4] || "").slice(0, 3);
                        fractional = pad(fractional, 3, true);
                        result.setMilliseconds(Number(fractional))
                    }
                    return result
                };
                var param = function(params) {
                    var result = [];
                    for (var name in params) {
                        result.push(name + "=" + params[name])
                    }
                    return result.join("&")
                };
                exports.sendRequest = function sendRequest(protocolVersion, request, options) {
                    var deserializeDates = options.deserializeDates,
                        fieldTypes = options.fieldTypes,
                        countOnly = options.countOnly,
                        isPaged = options.isPaged;
                    var d = new _deferred.Deferred;
                    var ajaxOptions = function(protocolVersion, request) {
                        var _options$beforeSend;
                        var options = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
                        var formatPayload = function(payload) {
                            return JSON.stringify(payload, (function(key, value) {
                                if (!(this[key] instanceof Date)) {
                                    return value
                                }
                                value = formatISO8601(this[key]);
                                switch (protocolVersion) {
                                    case 2:
                                        return value.substr(0, value.length - 1);
                                    case 3:
                                    case 4:
                                        return value;
                                    default:
                                        throw _errors.errors.Error("E4002")
                                }
                            }))
                        };
                        request = (0, _extend.extend)({
                            async: true,
                            method: "get",
                            url: "",
                            params: {},
                            payload: null,
                            headers: {},
                            timeout: 3e4
                        }, request);
                        null === (_options$beforeSend = options.beforeSend) || void 0 === _options$beforeSend ? void 0 : _options$beforeSend.call(options, request);
                        var _request = request,
                            async = _request.async, timeout = _request.timeout, headers = _request.headers;
                        var _request2 = request,
                            url = _request2.url,
                            method = _request2.method;
                        var jsonp = options.jsonp,
                            withCredentials = options.withCredentials;
                        method = (method || "get").toLowerCase();
                        var isGet = "get" === method;
                        var useJsonp = isGet && jsonp;
                        var params = (0, _extend.extend)({}, request.params);
                        var ajaxData = isGet ? params : formatPayload(request.payload);
                        var qs = !isGet && param(params);
                        var contentType = !isGet && JSON_VERBOSE_MIME_TYPE;
                        if (qs) {
                            url += (url.indexOf("?") > -1 ? "&" : "?") + qs
                        }
                        if (useJsonp) {
                            ajaxData.$format = "json"
                        }
                        return {
                            url: url,
                            data: ajaxData,
                            dataType: useJsonp ? "jsonp" : "json",
                            jsonp: useJsonp && "$callback",
                            method: method,
                            async: async,
                            timeout: timeout,
                            headers: headers,
                            contentType: contentType,
                            accepts: {
                                json: [JSON_VERBOSE_MIME_TYPE, "text/plain"].join()
                            },
                            xhrFields: {
                                withCredentials: withCredentials
                            }
                        }
                    }(protocolVersion, request, options);
                    _ajax.default.sendRequest(ajaxOptions).always((function(obj, textStatus) {
                        var transformOptions = {
                            deserializeDates: deserializeDates,
                            fieldTypes: fieldTypes
                        };
                        var tuple = interpretJsonFormat(obj, textStatus, transformOptions, ajaxOptions);
                        var error = tuple.error,
                            data = tuple.data,
                            count = tuple.count;
                        var nextUrl = tuple.nextUrl;
                        if (error) {
                            if (error.message !== _utils.XHR_ERROR_UNLOAD) {
                                d.reject(error)
                            }
                        } else if (countOnly) {
                            if (isFinite(count)) {
                                d.resolve(count)
                            } else {
                                d.reject(new _errors.errors.Error("E4018"))
                            }
                        } else if (nextUrl && !isPaged) {
                            if (!(url = nextUrl, /^(?:[a-z]+:)?\/\//i.test(url))) {
                                nextUrl = function(basePath, relativePath) {
                                    var part;
                                    var baseParts = function(url) {
                                        var index = url.indexOf("?");
                                        if (index > -1) {
                                            return url.substr(0, index)
                                        }
                                        return url
                                    }(basePath).split("/");
                                    var relativeParts = relativePath.split("/");
                                    baseParts.pop();
                                    while (relativeParts.length) {
                                        part = relativeParts.shift();
                                        if (".." === part) {
                                            baseParts.pop()
                                        } else {
                                            baseParts.push(part)
                                        }
                                    }
                                    return baseParts.join("/")
                                }(ajaxOptions.url, nextUrl)
                            }
                            sendRequest(protocolVersion, {
                                url: nextUrl
                            }, options).fail(d.reject).done((function(nextData) {
                                return d.resolve(data.concat(nextData))
                            }))
                        } else {
                            var extra = isFinite(count) ? {
                                totalCount: count
                            } : void 0;
                            d.resolve(data, extra)
                        }
                        var url
                    }));
                    return d.promise()
                };
                var interpretJsonFormat = function(obj, textStatus, transformOptions, ajaxOptions) {
                    var error = function(obj, textStatus, ajaxOptions) {
                        var _response, _response2, _response3, _response4;
                        if ("nocontent" === textStatus) {
                            return null
                        }
                        var message = "Unknown error";
                        var response = obj;
                        var httpStatus = 200;
                        var errorData = {
                            requestOptions: ajaxOptions
                        };
                        if ("success" !== textStatus) {
                            var status = obj.status,
                                responseText = obj.responseText;
                            httpStatus = status;
                            message = (0, _utils.errorMessageFromXhr)(obj, textStatus);
                            try {
                                response = JSON.parse(responseText)
                            } catch (x) {}
                        }
                        var errorObj = (null === (_response = response) || void 0 === _response ? void 0 : _response.then) || (null === (_response2 = response) || void 0 === _response2 ? void 0 : _response2.error) || (null === (_response3 = response) || void 0 === _response3 ? void 0 : _response3["odata.error"]) || (null === (_response4 = response) || void 0 === _response4 ? void 0 : _response4["@odata.error"]);
                        if (errorObj) {
                            message = function(errorObj) {
                                var message;
                                var currentMessage;
                                var currentError = errorObj;
                                if ("message" in errorObj) {
                                    var _errorObj$message;
                                    message = (null === (_errorObj$message = errorObj.message) || void 0 === _errorObj$message ? void 0 : _errorObj$message.value) || errorObj.message
                                }
                                while (currentError = currentError.innererror || currentError.internalexception) {
                                    var _currentMessage;
                                    currentMessage = currentError.message;
                                    message = null !== (_currentMessage = currentMessage) && void 0 !== _currentMessage ? _currentMessage : message;
                                    if (currentError.internalexception && -1 === message.indexOf("inner exception")) {
                                        break
                                    }
                                }
                                return message
                            }(errorObj) || message;
                            errorData.errorDetails = errorObj;
                            if (200 === httpStatus) {
                                httpStatus = 500
                            }
                            var customCode = Number(errorObj.code);
                            if (isFinite(customCode) && customCode >= 400) {
                                httpStatus = customCode
                            }
                        }
                        if (httpStatus >= 400 || 0 === httpStatus) {
                            errorData.httpStatus = httpStatus;
                            return (0, _extend.extend)(Error(message), errorData)
                        }
                        return null
                    }(obj, textStatus, ajaxOptions);
                    if (error) {
                        return {
                            error: error
                        }
                    }
                    if (!(0, _type.isPlainObject)(obj)) {
                        return {
                            data: obj
                        }
                    }
                    var value = "d" in obj && (Array.isArray(obj.d) || (0, _type.isObject)(obj.d)) ? interpretVerboseJsonFormat(obj, textStatus) : interpretLightJsonFormat(obj, textStatus);
                    transformTypes(value, transformOptions);
                    return value
                };
                var interpretVerboseJsonFormat = function(_ref) {
                    var _data$results;
                    var data = _ref.d;
                    if (!(0, _type.isDefined)(data)) {
                        return {
                            error: Error("Malformed or unsupported JSON response received")
                        }
                    }
                    return {
                        data: null !== (_data$results = data.results) && void 0 !== _data$results ? _data$results : data,
                        nextUrl: data.__next,
                        count: parseInt(data.__count, 10)
                    }
                };
                var interpretLightJsonFormat = function(obj) {
                    var _obj$value;
                    return {
                        data: null !== (_obj$value = obj.value) && void 0 !== _obj$value ? _obj$value : obj,
                        nextUrl: obj["@odata.nextLink"],
                        count: parseInt(obj["@odata.count"], 10)
                    }
                };
                var EdmLiteral = _class.default.inherit({
                    ctor: function(value) {
                        this._value = value
                    },
                    valueOf: function() {
                        return this._value
                    }
                });
                exports.EdmLiteral = EdmLiteral;
                var transformTypes = function transformTypes(obj) {
                    var options = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
                    (0, _iterator.each)(obj, (function(key, value) {
                        if (null !== value && "object" === _typeof(value)) {
                            if ("results" in value) {
                                obj[key] = value.results
                            }
                            transformTypes(obj[key], options)
                        } else if ("string" === typeof value) {
                            var fieldTypes = options.fieldTypes,
                                deserializeDates = options.deserializeDates;
                            var canBeGuid = !fieldTypes || "String" !== fieldTypes[key];
                            if (canBeGuid && GUID_REGEX.test(value)) {
                                obj[key] = new _guid.default(value)
                            }
                            if (false !== deserializeDates) {
                                if (value.match(VERBOSE_DATE_REGEX)) {
                                    var date = new Date(Number(RegExp.$1) + 60 * RegExp.$2 * 1e3);
                                    obj[key] = new Date(date.valueOf() + 60 * date.getTimezoneOffset() * 1e3)
                                } else if (ISO8601_DATE_REGEX.test(value)) {
                                    obj[key] = new Date(parseISO8601(obj[key]).valueOf())
                                }
                            }
                        }
                    }))
                };
                var serializePropName = function(propName) {
                    return propName instanceof EdmLiteral ? propName.valueOf() : propName.replace(/\./g, "/")
                };
                exports.serializePropName = serializePropName;
                var serializeValueV2 = function(value) {
                    if (value instanceof Date) {
                        return date = value, "datetime'".concat(formatISO8601(date, true, true), "'")
                    }
                    var date;
                    if (value instanceof _guid.default) {
                        return "guid'".concat(value, "'")
                    }
                    if (value instanceof EdmLiteral) {
                        return value.valueOf()
                    }
                    if ("string" === typeof value) {
                        return function(value) {
                            return "'".concat(value.replace(/'/g, "''"), "'")
                        }(value)
                    }
                    return String(value)
                };
                var serializeValue = function(value, protocolVersion) {
                    switch (protocolVersion) {
                        case 2:
                        case 3:
                            return serializeValueV2(value);
                        case 4:
                            return function serializeValueV4(value) {
                                if (value instanceof Date) {
                                    return formatISO8601(value, false, false)
                                }
                                if (value instanceof _guid.default) {
                                    return value.valueOf()
                                }
                                if (Array.isArray(value)) {
                                    return "[".concat(value.map((function(item) {
                                        return serializeValueV4(item)
                                    })).join(","), "]")
                                }
                                return serializeValueV2(value)
                            }(value);
                        default:
                            throw _errors.errors.Error("E4002")
                    }
                };
                exports.serializeValue = serializeValue;
                exports.serializeKey = function(key, protocolVersion) {
                    if ((0, _type.isPlainObject)(key)) {
                        var parts = [];
                        (0, _iterator.each)(key, (function(k, v) {
                            return parts.push("".concat(serializePropName(k), "=").concat(serializeValue(v, protocolVersion)))
                        }));
                        return parts.join()
                    }
                    return serializeValue(key, protocolVersion)
                };
                var keyConverters = {
                    String: function(value) {
                        return "".concat(value)
                    },
                    Int32: function(value) {
                        return Math.floor(value)
                    },
                    Int64: function(value) {
                        return value instanceof EdmLiteral ? value : new EdmLiteral("".concat(value, "L"))
                    },
                    Guid: function(value) {
                        return value instanceof _guid.default ? value : new _guid.default(value)
                    },
                    Boolean: function(value) {
                        return !!value
                    },
                    Single: function(value) {
                        return value instanceof EdmLiteral ? value : new EdmLiteral(value + "f")
                    },
                    Decimal: function(value) {
                        return value instanceof EdmLiteral ? value : new EdmLiteral(value + "m")
                    }
                };
                exports.keyConverters = keyConverters;
                exports.convertPrimitiveValue = function(type, value) {
                    if (null === value) {
                        return null
                    }
                    var converter = keyConverters[type];
                    if (!converter) {
                        throw _errors.errors.Error("E4014", type)
                    }
                    return converter(value)
                };
                exports.generateSelect = function(oDataVersion, select) {
                    if (!select) {
                        return
                    }
                    return oDataVersion < 4 ? serializePropName(select.join()) : (0, _common.grep)(select, hasDot, true).join()
                };
                var format = function(hash) {
                    var result = [];
                    (0, _iterator.each)(hash, (function(key, value) {
                        return result.push("".concat(key).concat(function formatCore(hash) {
                            var result = "";
                            var selectValue = [];
                            var expandValue = [];
                            (0, _iterator.each)(hash, (function(key, value) {
                                if (Array.isArray(value)) {
                                    [].push.apply(selectValue, value)
                                }
                                if ((0, _type.isPlainObject)(value)) {
                                    expandValue.push("".concat(key).concat(formatCore(value)))
                                }
                            }));
                            if (selectValue.length || expandValue.length) {
                                result += "(";
                                if (selectValue.length) {
                                    result += "$select=".concat((0, _iterator.map)(selectValue, serializePropName).join())
                                }
                                if (expandValue.length) {
                                    if (selectValue.length) {
                                        result += ";"
                                    }
                                    result += "$expand=".concat((0, _iterator.map)(expandValue, serializePropName).join())
                                }
                                result += ")"
                            }
                            return result
                        }(value)))
                    }));
                    return result.join()
                };
                var parseTree = function(exprs, root, stepper) {
                    return (0, _iterator.each)(exprs, (function(_, x) {
                        return function parseCore(exprParts, root, stepper) {
                            var result = stepper(root, exprParts.shift(), exprParts);
                            if (false === result) {
                                return
                            }
                            parseCore(exprParts, result, stepper)
                        }(x.split("."), root, stepper)
                    }))
                };
                exports.generateExpand = function(oDataVersion, expand, select) {
                    return oDataVersion < 4 ? function(expand, select) {
                        var hash = {};
                        if (expand) {
                            (0, _iterator.each)(makeArray(expand), (function() {
                                hash[serializePropName(this)] = 1
                            }))
                        }
                        if (select) {
                            (0, _iterator.each)(makeArray(select), (function() {
                                var path = this.split(".");
                                if (path.length < 2) {
                                    return
                                }
                                path.pop();
                                hash[serializePropName(path.join("."))] = 1
                            }))
                        }
                        return (0, _iterator.map)(hash, (function(_, v) {
                            return v
                        })).join()
                    }(expand, select) : function(expand, select) {
                        var hash = {};
                        if (expand || select) {
                            if (expand) {
                                parseTree(makeArray(expand), hash, (function(node, key, path) {
                                    node[key] = node[key] || {};
                                    return !path.length ? false : node[key]
                                }))
                            }
                            if (select) {
                                parseTree((0, _common.grep)(makeArray(select), hasDot), hash, (function(node, key, path) {
                                    if (!path.length) {
                                        node[key] = node[key] || [];
                                        node[key].push(key);
                                        return false
                                    }
                                    return node[key] = node[key] || {}
                                }))
                            }
                            return format(hash)
                        }
                    }(expand, select)
                };
                exports.formatFunctionInvocationUrl = function(baseUrl, args) {
                    return (0, _string.format)("{0}({1})", baseUrl, (0, _iterator.map)(args || {}, (function(value, key) {
                        return (0, _string.format)("{0}={1}", key, value)
                    })).join(","))
                };
                exports.escapeServiceOperationParams = function(params, version) {
                    if (!params) {
                        return params
                    }
                    var result = {};
                    (0, _iterator.each)(params, (function(k, v) {
                        result[k] = serializeValue(v, version)
                    }));
                    return result
                }
            },
        96687:
            /*!***********************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/query.js ***!
              \***********************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _query_implementation = __webpack_require__( /*! ./query_implementation */ 77549);
                var _default = function() {
                    var impl = Array.isArray(arguments[0]) ? "array" : "remote";
                    return _query_implementation.queryImpl[impl].apply(this, arguments)
                };
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        16135:
            /*!********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/query_adapters.js ***!
              \********************************************************************/
            function(module, exports) {
                exports.default = void 0;
                exports.default = {};
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        77549:
            /*!**************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/query_implementation.js ***!
              \**************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.queryImpl = void 0;
                var _array_query = _interopRequireDefault(__webpack_require__( /*! ./array_query */ 35042));
                var _remote_query = _interopRequireDefault(__webpack_require__( /*! ./remote_query */ 41428));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var queryImpl = {
                    array: _array_query.default,
                    remote: _remote_query.default
                };
                exports.queryImpl = queryImpl
            },
        41428:
            /*!******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/remote_query.js ***!
              \******************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _query_adapters = _interopRequireDefault(__webpack_require__( /*! ./query_adapters */ 16135));
                var _errors = __webpack_require__( /*! ./errors */ 18438);
                var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 95479);
                var _type = __webpack_require__( /*! ../core/utils/type */ 35922);
                var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 62754);
                var _array_query = _interopRequireDefault(__webpack_require__( /*! ./array_query */ 35042));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var _default = function remoteQueryImpl(url, queryOptions, tasks) {
                    tasks = tasks || [];
                    queryOptions = queryOptions || {};
                    var createTask = function(name, args) {
                        return {
                            name: name,
                            args: args
                        }
                    };
                    var exec = function(executorTask) {
                        var d = new _deferred.Deferred;
                        var _adapterFactory;
                        var _adapter;
                        var _taskQueue;
                        var _currentTask;
                        var _mergedSortArgs;
                        var rejectWithNotify = function(error) {
                            var handler = queryOptions.errorHandler;
                            if (handler) {
                                handler(error)
                            }(0, _errors.handleError)(error);
                            d.reject(error)
                        };

                        function mergeSortTask(task) {
                            switch (task.name) {
                                case "sortBy":
                                    _mergedSortArgs = [task.args];
                                    return true;
                                case "thenBy":
                                    if (!_mergedSortArgs) {
                                        throw _errors.errors.Error("E4004")
                                    }
                                    _mergedSortArgs.push(task.args);
                                    return true
                            }
                            return false
                        }
                        try {
                            _adapterFactory = queryOptions.adapter;
                            if (!(0, _type.isFunction)(_adapterFactory)) {
                                _adapterFactory = _query_adapters.default[_adapterFactory]
                            }
                            _adapter = _adapterFactory(queryOptions);
                            _taskQueue = [].concat(tasks).concat(executorTask);
                            var optimize = _adapter.optimize;
                            if (optimize) {
                                optimize(_taskQueue)
                            }
                            while (_taskQueue.length) {
                                _currentTask = _taskQueue[0];
                                if (!mergeSortTask(_currentTask)) {
                                    if (_mergedSortArgs) {
                                        _taskQueue.unshift(createTask("multiSort", [_mergedSortArgs]));
                                        _mergedSortArgs = null;
                                        continue
                                    }
                                    if ("enumerate" !== String(_currentTask.name)) {
                                        if (!_adapter[_currentTask.name] || false === _adapter[_currentTask.name].apply(_adapter, _currentTask.args)) {
                                            break
                                        }
                                    }
                                }
                                _taskQueue.shift()
                            }! function() {
                                var head = _taskQueue[0];
                                var unmergedTasks = [];
                                if (head && "multiSort" === head.name) {
                                    _taskQueue.shift();
                                    (0, _iterator.each)(head.args[0], (function() {
                                        unmergedTasks.push(createTask(unmergedTasks.length ? "thenBy" : "sortBy", this))
                                    }))
                                }
                                _taskQueue = unmergedTasks.concat(_taskQueue)
                            }();
                            _adapter.exec(url).done((function(result, extra) {
                                if (!_taskQueue.length) {
                                    d.resolve(result, extra)
                                } else {
                                    var clientChain = (0, _array_query.default)(result, {
                                        errorHandler: queryOptions.errorHandler
                                    });
                                    (0, _iterator.each)(_taskQueue, (function() {
                                        clientChain = clientChain[this.name].apply(clientChain, this.args)
                                    }));
                                    clientChain.done(d.resolve).fail(d.reject)
                                }
                            })).fail(rejectWithNotify)
                        } catch (x) {
                            rejectWithNotify(x)
                        }
                        return d.promise()
                    };
                    var query = {};
                    (0, _iterator.each)(["sortBy", "thenBy", "filter", "slice", "select", "groupBy"], (function() {
                        var name = String(this);
                        query[name] = function() {
                            return remoteQueryImpl(url, queryOptions, tasks.concat(createTask(name, arguments)))
                        }
                    }));
                    (0, _iterator.each)(["count", "min", "max", "sum", "avg", "aggregate", "enumerate"], (function() {
                        var name = String(this);
                        query[name] = function() {
                            return exec.call(this, createTask(name, arguments))
                        }
                    }));
                    return query
                };
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        99236:
            /*!******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/store_helper.js ***!
              \******************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _common = __webpack_require__( /*! ../core/utils/common */ 20576);
                var _extend = __webpack_require__( /*! ../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 95479);
                var _array_query = (obj = __webpack_require__( /*! ./array_query */ 35042), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _utils = __webpack_require__( /*! ./utils */ 16454);

                function multiLevelGroup(query, groupInfo) {
                    query = query.groupBy(groupInfo[0].selector);
                    if (groupInfo.length > 1) {
                        query = query.select((function(g) {
                            return (0, _extend.extend)({}, g, {
                                items: multiLevelGroup((0, _array_query.default)(g.items), groupInfo.slice(1)).toArray()
                            })
                        }))
                    }
                    return query
                }

                function arrangeSortingInfo(groupInfo, sortInfo) {
                    var filteredGroup = [];
                    (0, _iterator.each)(groupInfo, (function(_, group) {
                        var collision = (0, _common.grep)(sortInfo, (function(sort) {
                            return group.selector === sort.selector
                        }));
                        if (collision.length < 1) {
                            filteredGroup.push(group)
                        }
                    }));
                    return filteredGroup.concat(sortInfo)
                }
                var _default = {
                    multiLevelGroup: multiLevelGroup,
                    arrangeSortingInfo: arrangeSortingInfo,
                    queryByOptions: function(query, options, isCountQuery) {
                        options = options || {};
                        var filter = options.filter;
                        if (filter) {
                            query = query.filter(filter)
                        }
                        if (isCountQuery) {
                            return query
                        }
                        var sort = options.sort;
                        var select = options.select;
                        var group = options.group;
                        var skip = options.skip;
                        var take = options.take;
                        if (group) {
                            group = (0, _utils.normalizeSortingInfo)(group);
                            group.keepInitialKeyOrder = !!options.group.keepInitialKeyOrder
                        }
                        if (sort || group) {
                            sort = (0, _utils.normalizeSortingInfo)(sort || []);
                            if (group && !group.keepInitialKeyOrder) {
                                sort = arrangeSortingInfo(group, sort)
                            }(0, _iterator.each)(sort, (function(index) {
                                query = query[index ? "thenBy" : "sortBy"](this.selector, this.desc, this.compare)
                            }))
                        }
                        if (select) {
                            query = query.select(select)
                        }
                        if (group) {
                            query = multiLevelGroup(query, group)
                        }
                        if (take || skip) {
                            query = query.slice(skip || 0, take)
                        }
                        return query
                    }
                };
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        16454:
            /*!***********************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/utils.js ***!
              \***********************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.errorMessageFromXhr = exports.base64_encode = exports.aggregators = exports.XHR_ERROR_UNLOAD = void 0;
                exports.isConjunctiveOperator = function(condition) {
                    return /^(and|&&|&)$/i.test(condition)
                };
                exports.isDisjunctiveOperator = function(condition) {
                    return /^(or|\|\||\|)$/i.test(condition)
                };
                exports.rejectedPromise = exports.processRequestResultLock = exports.normalizeSortingInfo = exports.normalizeBinaryCriterion = exports.keysEqual = exports.isUnaryOperation = exports.isGroupCriterion = void 0;
                exports.throttleChanges = function(func, timeout) {
                    var cache = [];
                    var throttled = function(func, timeout) {
                        var timeoutId;
                        var lastArgs;
                        return function() {
                            var _this = this;
                            lastArgs = arguments;
                            if (!timeoutId) {
                                timeoutId = setTimeout((function() {
                                    timeoutId = void 0;
                                    if (lastArgs) {
                                        func.call(_this, lastArgs)
                                    }
                                }), (0, _type.isFunction)(timeout) ? timeout() : timeout)
                            }
                            return timeoutId
                        }
                    }((function() {
                        func.call(this, cache);
                        cache = []
                    }), timeout);
                    return function(changes) {
                        if (Array.isArray(changes)) {
                            var _cache;
                            (_cache = cache).push.apply(_cache, (arr = changes, function(arr) {
                                if (Array.isArray(arr)) {
                                    return _arrayLikeToArray(arr)
                                }
                            }(arr) || function(iter) {
                                if ("undefined" !== typeof Symbol && null != iter[Symbol.iterator] || null != iter["@@iterator"]) {
                                    return Array.from(iter)
                                }
                            }(arr) || function(o, minLen) {
                                if (!o) {
                                    return
                                }
                                if ("string" === typeof o) {
                                    return _arrayLikeToArray(o, minLen)
                                }
                                var n = Object.prototype.toString.call(o).slice(8, -1);
                                if ("Object" === n && o.constructor) {
                                    n = o.constructor.name
                                }
                                if ("Map" === n || "Set" === n) {
                                    return Array.from(o)
                                }
                                if ("Arguments" === n || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) {
                                    return _arrayLikeToArray(o, minLen)
                                }
                            }(arr) || function() {
                                throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                            }()))
                        }
                        var arr;
                        return throttled.call(this, cache)
                    }
                };
                exports.trivialPromise = void 0;
                var _type = __webpack_require__( /*! ../core/utils/type */ 35922);
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../core/dom_adapter */ 73349));
                var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ../core/utils/ready_callbacks */ 24311));
                var _window = __webpack_require__( /*! ../core/utils/window */ 58201);
                var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 95479);
                var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 62754);
                var _common = __webpack_require__( /*! ../core/utils/common */ 20576);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _arrayLikeToArray(arr, len) {
                    if (null == len || len > arr.length) {
                        len = arr.length
                    }
                    for (var i = 0, arr2 = new Array(len); i < len; i++) {
                        arr2[i] = arr[i]
                    }
                    return arr2
                }
                var ready = _ready_callbacks.default.add;
                exports.XHR_ERROR_UNLOAD = "DEVEXTREME_XHR_ERROR_UNLOAD";
                exports.normalizeBinaryCriterion = function(crit) {
                    return [crit[0], crit.length < 3 ? "=" : String(crit[1]).toLowerCase(), crit.length < 2 ? true : crit[crit.length - 1]]
                };
                exports.normalizeSortingInfo = function(info) {
                    if (!Array.isArray(info)) {
                        info = [info]
                    }
                    return (0, _iterator.map)(info, (function(i) {
                        var result = {
                            selector: (0, _type.isFunction)(i) || "string" === typeof i ? i : i.getter || i.field || i.selector,
                            desc: !!(i.desc || "d" === String(i.dir).charAt(0).toLowerCase())
                        };
                        if (i.compare) {
                            result.compare = i.compare
                        }
                        return result
                    }))
                };
                var errorMessageFromXhr = function() {
                    var textStatusMessages = {
                        timeout: "Network connection timeout",
                        error: "Unspecified network error",
                        parsererror: "Unexpected server response"
                    };
                    var unloading;
                    ready((function() {
                        var window = (0, _window.getWindow)();
                        _dom_adapter.default.listen(window, "beforeunload", (function() {
                            unloading = true
                        }))
                    }));
                    return function(xhr, textStatus) {
                        if (unloading) {
                            return "DEVEXTREME_XHR_ERROR_UNLOAD"
                        }
                        if (xhr.status < 400) {
                            return function(textStatus) {
                                var result = textStatusMessages[textStatus];
                                if (!result) {
                                    return textStatus
                                }
                                return result
                            }(textStatus)
                        }
                        return xhr.statusText
                    }
                }();
                exports.errorMessageFromXhr = errorMessageFromXhr;
                var aggregators = {
                    count: {
                        seed: 0,
                        step: function(count) {
                            return 1 + count
                        }
                    },
                    sum: {
                        seed: 0,
                        step: function(sum, item) {
                            return sum + item
                        }
                    },
                    min: {
                        step: function(min, item) {
                            return item < min ? item : min
                        }
                    },
                    max: {
                        step: function(max, item) {
                            return item > max ? item : max
                        }
                    },
                    avg: {
                        seed: [0, 0],
                        step: function(pair, value) {
                            return [pair[0] + value, pair[1] + 1]
                        },
                        finalize: function(pair) {
                            return pair[1] ? pair[0] / pair[1] : NaN
                        }
                    }
                };
                exports.aggregators = aggregators;
                var processRequestResultLock = (lockCount = 0, {
                    obtain: function() {
                        if (0 === lockCount) {
                            lockDeferred = new _deferred.Deferred
                        }
                        lockCount++
                    },
                    release: function() {
                        lockCount--;
                        if (lockCount < 1) {
                            lockDeferred.resolve()
                        }
                    },
                    promise: function() {
                        var deferred = 0 === lockCount ? (new _deferred.Deferred).resolve() : lockDeferred;
                        return deferred.promise()
                    },
                    reset: function() {
                        lockCount = 0;
                        if (lockDeferred) {
                            lockDeferred.resolve()
                        }
                    }
                });
                var lockCount, lockDeferred;
                exports.processRequestResultLock = processRequestResultLock;
                exports.keysEqual = function(keyExpr, key1, key2) {
                    if (Array.isArray(keyExpr)) {
                        var names = (0, _iterator.map)(key1, (function(v, k) {
                            return k
                        }));
                        var name;
                        for (var i = 0; i < names.length; i++) {
                            name = names[i];
                            if (!(0, _common.equalByValue)(key1[name], key2[name], 0, false)) {
                                return false
                            }
                        }
                        return true
                    }
                    return (0, _common.equalByValue)(key1, key2, 0, false)
                };
                exports.base64_encode = function(input) {
                    if (!Array.isArray(input)) {
                        input = function(str) {
                            var bytes = [];
                            var code;
                            var i;
                            for (i = 0; i < str.length; i++) {
                                code = str.charCodeAt(i);
                                if (code < 128) {
                                    bytes.push(code)
                                } else if (code < 2048) {
                                    bytes.push(192 + (code >> 6), 128 + (63 & code))
                                } else if (code < 65536) {
                                    bytes.push(224 + (code >> 12), 128 + (code >> 6 & 63), 128 + (63 & code))
                                } else if (code < 2097152) {
                                    bytes.push(240 + (code >> 18), 128 + (code >> 12 & 63), 128 + (code >> 6 & 63), 128 + (63 & code))
                                }
                            }
                            return bytes
                        }(String(input))
                    }
                    var result = "";

                    function getBase64Char(index) {
                        return "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(index)
                    }
                    for (var i = 0; i < input.length; i += 3) {
                        var octet1 = input[i];
                        var octet2 = input[i + 1];
                        var octet3 = input[i + 2];
                        result += (0, _iterator.map)([octet1 >> 2, (3 & octet1) << 4 | octet2 >> 4, isNaN(octet2) ? 64 : (15 & octet2) << 2 | octet3 >> 6, isNaN(octet3) ? 64 : 63 & octet3], getBase64Char).join("")
                    }
                    return result
                };
                exports.isUnaryOperation = function(crit) {
                    return "!" === crit[0] && Array.isArray(crit[1])
                };
                exports.isGroupCriterion = function(crit) {
                    var first = crit[0];
                    var second = crit[1];
                    if (Array.isArray(first)) {
                        return true
                    }
                    if ((0, _type.isFunction)(first)) {
                        if (Array.isArray(second) || (0, _type.isFunction)(second) || (value = second, "and" === value || "or" === value)) {
                            return true
                        }
                    }
                    var value;
                    return false
                };
                exports.trivialPromise = function() {
                    var d = new _deferred.Deferred;
                    return d.resolve.apply(d, arguments).promise()
                };
                exports.rejectedPromise = function() {
                    var d = new _deferred.Deferred;
                    return d.reject.apply(d, arguments).promise()
                }
            },
        53305:
            /*!************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data_helper.js ***!
              \************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _data_source = __webpack_require__( /*! ./data/data_source/data_source */ 85273);
                var _extend = __webpack_require__( /*! ./core/utils/extend */ 13306);
                var _utils = __webpack_require__( /*! ./data/data_source/utils */ 9234);
                var DataHelperMixin = {
                    postCtor: function() {
                        this.on("disposing", function() {
                            this._disposeDataSource()
                        }.bind(this))
                    },
                    _refreshDataSource: function() {
                        this._initDataSource();
                        this._loadDataSource()
                    },
                    _initDataSource: function() {
                        var dataSourceOptions = "_getSpecificDataSourceOption" in this ? this._getSpecificDataSourceOption() : this.option("dataSource");
                        var widgetDataSourceOptions;
                        var dataSourceType;
                        this._disposeDataSource();
                        if (dataSourceOptions) {
                            if (dataSourceOptions instanceof _data_source.DataSource) {
                                this._isSharedDataSource = true;
                                this._dataSource = dataSourceOptions
                            } else {
                                widgetDataSourceOptions = "_dataSourceOptions" in this ? this._dataSourceOptions() : {};
                                dataSourceType = this._dataSourceType ? this._dataSourceType() : _data_source.DataSource;
                                dataSourceOptions = (0, _utils.normalizeDataSourceOptions)(dataSourceOptions, {
                                    fromUrlLoadMode: "_dataSourceFromUrlLoadMode" in this && this._dataSourceFromUrlLoadMode()
                                });
                                this._dataSource = new dataSourceType((0, _extend.extend)(true, {}, widgetDataSourceOptions, dataSourceOptions))
                            }
                            if ("_normalizeDataSource" in this) {
                                this._dataSource = this._normalizeDataSource(this._dataSource)
                            }
                            this._addDataSourceHandlers()
                        }
                    },
                    _addDataSourceHandlers: function() {
                        if ("_dataSourceChangedHandler" in this) {
                            this._addDataSourceChangeHandler()
                        }
                        if ("_dataSourceLoadErrorHandler" in this) {
                            this._addDataSourceLoadErrorHandler()
                        }
                        if ("_dataSourceLoadingChangedHandler" in this) {
                            this._addDataSourceLoadingChangedHandler()
                        }
                        this._addReadyWatcher()
                    },
                    _addReadyWatcher: function() {
                        this._dataSource.on("loadingChanged", function(isLoading) {
                            this._ready && this._ready(!isLoading)
                        }.bind(this))
                    },
                    _addDataSourceChangeHandler: function() {
                        var dataSource = this._dataSource;
                        this._proxiedDataSourceChangedHandler = function(e) {
                            this._dataSourceChangedHandler(dataSource.items(), e)
                        }.bind(this);
                        dataSource.on("changed", this._proxiedDataSourceChangedHandler)
                    },
                    _addDataSourceLoadErrorHandler: function() {
                        this._proxiedDataSourceLoadErrorHandler = this._dataSourceLoadErrorHandler.bind(this);
                        this._dataSource.on("loadError", this._proxiedDataSourceLoadErrorHandler)
                    },
                    _addDataSourceLoadingChangedHandler: function() {
                        this._proxiedDataSourceLoadingChangedHandler = this._dataSourceLoadingChangedHandler.bind(this);
                        this._dataSource.on("loadingChanged", this._proxiedDataSourceLoadingChangedHandler)
                    },
                    _loadDataSource: function() {
                        if (this._dataSource) {
                            var dataSource = this._dataSource;
                            if (dataSource.isLoaded()) {
                                this._proxiedDataSourceChangedHandler && this._proxiedDataSourceChangedHandler()
                            } else {
                                dataSource.load()
                            }
                        }
                    },
                    _loadSingle: function(key, value) {
                        key = "this" === key ? this._dataSource.key() || "this" : key;
                        return this._dataSource.loadSingle(key, value)
                    },
                    _isLastPage: function() {
                        return !this._dataSource || this._dataSource.isLastPage() || !this._dataSource._pageSize
                    },
                    _isDataSourceLoading: function() {
                        return this._dataSource && this._dataSource.isLoading()
                    },
                    _disposeDataSource: function() {
                        if (this._dataSource) {
                            if (this._isSharedDataSource) {
                                delete this._isSharedDataSource;
                                this._proxiedDataSourceChangedHandler && this._dataSource.off("changed", this._proxiedDataSourceChangedHandler);
                                this._proxiedDataSourceLoadErrorHandler && this._dataSource.off("loadError", this._proxiedDataSourceLoadErrorHandler);
                                this._proxiedDataSourceLoadingChangedHandler && this._dataSource.off("loadingChanged", this._proxiedDataSourceLoadingChangedHandler)
                            } else {
                                this._dataSource.dispose()
                            }
                            delete this._dataSource;
                            delete this._proxiedDataSourceChangedHandler;
                            delete this._proxiedDataSourceLoadErrorHandler;
                            delete this._proxiedDataSourceLoadingChangedHandler
                        }
                    },
                    getDataSource: function() {
                        return this._dataSource || null
                    }
                };
                var _default = DataHelperMixin;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        95429:
            /*!*************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/click.js ***!
              \*************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.name = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 68374));
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../events/core/events_engine */ 55994));
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../core/devices */ 20530));
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../core/dom_adapter */ 73349));
                var _dom = __webpack_require__( /*! ../core/utils/dom */ 3532);
                var _frame = __webpack_require__( /*! ../animation/frame */ 90057);
                var _index = __webpack_require__( /*! ./utils/index */ 39611);
                var _event_nodes_disposing = __webpack_require__( /*! ./utils/event_nodes_disposing */ 27575);
                var _pointer = _interopRequireDefault(__webpack_require__( /*! ./pointer */ 93786));
                var _emitter = _interopRequireDefault(__webpack_require__( /*! ./core/emitter */ 31391));
                var _emitter_registrator = _interopRequireDefault(__webpack_require__( /*! ./core/emitter_registrator */ 82495));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                exports.name = "dxclick";
                _frame.requestAnimationFrame, _frame.cancelAnimationFrame;
                var prevented = null;
                var lastFiredEvent = null;
                var onNodeRemove = function() {
                    lastFiredEvent = null
                };
                var clickHandler = function(e) {
                    var originalEvent = e.originalEvent;
                    var eventAlreadyFired = lastFiredEvent === originalEvent || originalEvent && originalEvent.DXCLICK_FIRED;
                    var leftButton = !e.which || 1 === e.which;
                    if (leftButton && !prevented && !eventAlreadyFired) {
                        if (originalEvent) {
                            originalEvent.DXCLICK_FIRED = true
                        }(0, _event_nodes_disposing.unsubscribeNodesDisposing)(lastFiredEvent, onNodeRemove);
                        lastFiredEvent = originalEvent;
                        (0, _event_nodes_disposing.subscribeNodesDisposing)(lastFiredEvent, onNodeRemove);
                        (0, _index.fireEvent)({
                            type: "dxclick",
                            originalEvent: e
                        })
                    }
                };
                var ClickEmitter = _emitter.default.inherit({
                    ctor: function(element) {
                        this.callBase(element);
                        _events_engine.default.on(this.getElement(), "click", clickHandler)
                    },
                    start: function(e) {
                        prevented = null
                    },
                    cancel: function() {
                        prevented = true
                    },
                    dispose: function() {
                        _events_engine.default.off(this.getElement(), "click", clickHandler)
                    }
                });
                ! function() {
                    var desktopDevice = _devices.default.real().generic;
                    if (!desktopDevice) {
                        var startTarget = null;
                        var blurPrevented = false;
                        var document = _dom_adapter.default.getDocument();
                        _events_engine.default.subscribeGlobal(document, (0, _index.addNamespace)(_pointer.default.down, "NATIVE_CLICK_FIXER"), (function(e) {
                            startTarget = e.target;
                            blurPrevented = e.isDefaultPrevented()
                        }));
                        _events_engine.default.subscribeGlobal(document, (0, _index.addNamespace)("click", "NATIVE_CLICK_FIXER"), (function(e) {
                            var $target = (0, _renderer.default)(e.target);
                            if (!blurPrevented && startTarget && !$target.is(startTarget) && !(0, _renderer.default)(startTarget).is("label") && (element = $target, (0, _renderer.default)(element).is("input, textarea, select, button ,:focus, :focus *"))) {
                                (0, _dom.resetActiveElement)()
                            }
                            var element;
                            startTarget = null;
                            blurPrevented = false
                        }))
                    }
                }();
                (0, _emitter_registrator.default)({
                    emitter: ClickEmitter,
                    bubble: true,
                    events: ["dxclick"]
                })
            },
        49166:
            /*!*******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/contextmenu.js ***!
              \*******************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.name = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 68374));
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../events/core/events_engine */ 55994));
                var _support = __webpack_require__( /*! ../core/utils/support */ 60137);
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../core/devices */ 20530));
                var _class = _interopRequireDefault(__webpack_require__( /*! ../core/class */ 38377));
                var _event_registrator = _interopRequireDefault(__webpack_require__( /*! ./core/event_registrator */ 85788));
                var _index = __webpack_require__( /*! ./utils/index */ 39611);
                var _hold = _interopRequireDefault(__webpack_require__( /*! ./hold */ 11699));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var CONTEXTMENU_NAMESPACED_EVENT_NAME = (0, _index.addNamespace)("contextmenu", "dxContexMenu");
                var HOLD_NAMESPACED_EVENT_NAME = (0, _index.addNamespace)(_hold.default.name, "dxContexMenu");
                var ContextMenu = _class.default.inherit({
                    setup: function(element) {
                        var $element = (0, _renderer.default)(element);
                        _events_engine.default.on($element, CONTEXTMENU_NAMESPACED_EVENT_NAME, this._contextMenuHandler.bind(this));
                        if (_support.touch || _devices.default.isSimulator()) {
                            _events_engine.default.on($element, HOLD_NAMESPACED_EVENT_NAME, this._holdHandler.bind(this))
                        }
                    },
                    _holdHandler: function(e) {
                        if ((0, _index.isMouseEvent)(e) && !_devices.default.isSimulator()) {
                            return
                        }
                        this._fireContextMenu(e)
                    },
                    _contextMenuHandler: function(e) {
                        this._fireContextMenu(e)
                    },
                    _fireContextMenu: function(e) {
                        return (0, _index.fireEvent)({
                            type: "dxcontextmenu",
                            originalEvent: e
                        })
                    },
                    teardown: function(element) {
                        _events_engine.default.off(element, ".dxContexMenu")
                    }
                });
                (0, _event_registrator.default)("dxcontextmenu", new ContextMenu);
                exports.name = "dxcontextmenu"
            },
        91633:
            /*!*****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/core/emitter.feedback.js ***!
              \*****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.lock = exports.inactive = exports.active = void 0;
                var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 38377));
                var _common = __webpack_require__( /*! ../../core/utils/common */ 20576);
                var _dom = __webpack_require__( /*! ../../core/utils/dom */ 3532);
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../../core/devices */ 20530));
                var _index = __webpack_require__( /*! ../utils/index */ 39611);
                var _pointer = _interopRequireDefault(__webpack_require__( /*! ../pointer */ 93786));
                var _emitter = _interopRequireDefault(__webpack_require__( /*! ./emitter */ 31391));
                var _emitter_registrator = _interopRequireDefault(__webpack_require__( /*! ./emitter_registrator */ 82495));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                exports.active = "dxactive";
                exports.inactive = "dxinactive";
                var FeedbackEvent = _class.default.inherit({
                    ctor: function(timeout, fire) {
                        this._timeout = timeout;
                        this._fire = fire
                    },
                    start: function() {
                        var that = this;
                        this._schedule((function() {
                            that.force()
                        }))
                    },
                    _schedule: function(fn) {
                        this.stop();
                        this._timer = setTimeout(fn, this._timeout)
                    },
                    stop: function() {
                        clearTimeout(this._timer)
                    },
                    force: function() {
                        if (this._fired) {
                            return
                        }
                        this.stop();
                        this._fire();
                        this._fired = true
                    },
                    fired: function() {
                        return this._fired
                    }
                });
                var activeFeedback;
                var FeedbackEmitter = _emitter.default.inherit({
                    ctor: function() {
                        this.callBase.apply(this, arguments);
                        this._active = new FeedbackEvent(0, _common.noop);
                        this._inactive = new FeedbackEvent(0, _common.noop)
                    },
                    configure: function(data, eventName) {
                        switch (eventName) {
                            case "dxactive":
                                data.activeTimeout = data.timeout;
                                break;
                            case "dxinactive":
                                data.inactiveTimeout = data.timeout
                        }
                        this.callBase(data)
                    },
                    start: function(e) {
                        if (activeFeedback) {
                            var activeChildExists = (0, _dom.contains)(this.getElement().get(0), activeFeedback.getElement().get(0));
                            var childJustActivated = !activeFeedback._active.fired();
                            if (activeChildExists && childJustActivated) {
                                this._cancel();
                                return
                            }
                            activeFeedback._inactive.force()
                        }
                        activeFeedback = this;
                        this._initEvents(e);
                        this._active.start()
                    },
                    _initEvents: function(e) {
                        var that = this;
                        var eventTarget = this._getEmitterTarget(e);
                        var mouseEvent = (0, _index.isMouseEvent)(e);
                        var isSimulator = _devices.default.isSimulator();
                        var deferFeedback = isSimulator || !mouseEvent;
                        var activeTimeout = (0, _common.ensureDefined)(this.activeTimeout, 30);
                        var inactiveTimeout = (0, _common.ensureDefined)(this.inactiveTimeout, 400);
                        this._active = new FeedbackEvent(deferFeedback ? activeTimeout : 0, (function() {
                            that._fireEvent("dxactive", e, {
                                target: eventTarget
                            })
                        }));
                        this._inactive = new FeedbackEvent(deferFeedback ? inactiveTimeout : 0, (function() {
                            that._fireEvent("dxinactive", e, {
                                target: eventTarget
                            });
                            activeFeedback = null
                        }))
                    },
                    cancel: function(e) {
                        this.end(e)
                    },
                    end: function(e) {
                        var skipTimers = e.type !== _pointer.default.up;
                        if (skipTimers) {
                            this._active.stop()
                        } else {
                            this._active.force()
                        }
                        this._inactive.start();
                        if (skipTimers) {
                            this._inactive.force()
                        }
                    },
                    dispose: function() {
                        this._active.stop();
                        this._inactive.stop();
                        if (activeFeedback === this) {
                            activeFeedback = null
                        }
                        this.callBase()
                    },
                    lockInactive: function() {
                        this._active.force();
                        this._inactive.stop();
                        activeFeedback = null;
                        this._cancel();
                        return this._inactive.force.bind(this._inactive)
                    }
                });
                FeedbackEmitter.lock = function(deferred) {
                    var lockInactive = activeFeedback ? activeFeedback.lockInactive() : _common.noop;
                    deferred.done(lockInactive)
                };
                (0, _emitter_registrator.default)({
                    emitter: FeedbackEmitter,
                    events: ["dxactive", "dxinactive"]
                });
                var lock = FeedbackEmitter.lock;
                exports.lock = lock
            },
        31391:
            /*!********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/core/emitter.js ***!
              \********************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 68374));
                var _common = __webpack_require__( /*! ../../core/utils/common */ 20576);
                var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 38377));
                var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/callbacks */ 44504));
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _index = __webpack_require__( /*! ../utils/index */ 39611);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var Emitter = _class.default.inherit({
                    ctor: function(element) {
                        this._$element = (0, _renderer.default)(element);
                        this._cancelCallback = (0, _callbacks.default)();
                        this._acceptCallback = (0, _callbacks.default)()
                    },
                    getElement: function() {
                        return this._$element
                    },
                    validate: function(e) {
                        return !(0, _index.isDxMouseWheelEvent)(e)
                    },
                    validatePointers: function(e) {
                        return 1 === (0, _index.hasTouches)(e)
                    },
                    allowInterruptionByMouseWheel: function() {
                        return true
                    },
                    configure: function(data) {
                        (0, _extend.extend)(this, data)
                    },
                    addCancelCallback: function(callback) {
                        this._cancelCallback.add(callback)
                    },
                    removeCancelCallback: function() {
                        this._cancelCallback.empty()
                    },
                    _cancel: function(e) {
                        this._cancelCallback.fire(this, e)
                    },
                    addAcceptCallback: function(callback) {
                        this._acceptCallback.add(callback)
                    },
                    removeAcceptCallback: function() {
                        this._acceptCallback.empty()
                    },
                    _accept: function(e) {
                        this._acceptCallback.fire(this, e)
                    },
                    _requestAccept: function(e) {
                        this._acceptRequestEvent = e
                    },
                    _forgetAccept: function() {
                        this._accept(this._acceptRequestEvent);
                        this._acceptRequestEvent = null
                    },
                    start: _common.noop,
                    move: _common.noop,
                    end: _common.noop,
                    cancel: _common.noop,
                    reset: function() {
                        if (this._acceptRequestEvent) {
                            this._accept(this._acceptRequestEvent)
                        }
                    },
                    _fireEvent: function(eventName, e, params) {
                        var eventData = (0, _extend.extend)({
                            type: eventName,
                            originalEvent: e,
                            target: this._getEmitterTarget(e),
                            delegateTarget: this.getElement().get(0)
                        }, params);
                        e = (0, _index.fireEvent)(eventData);
                        if (e.cancel) {
                            this._cancel(e)
                        }
                        return e
                    },
                    _getEmitterTarget: function(e) {
                        return (this.delegateSelector ? (0, _renderer.default)(e.target).closest(this.delegateSelector) : this.getElement()).get(0)
                    },
                    dispose: _common.noop
                });
                var _default = Emitter;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        82495:
            /*!********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/core/emitter_registrator.js ***!
              \********************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 68374));
                var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/ready_callbacks */ 24311));
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 73349));
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 55994));
                var _element_data = __webpack_require__( /*! ../../core/element_data */ 97906);
                var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 38377));
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 95479);
                var _event_registrator = _interopRequireDefault(__webpack_require__( /*! ./event_registrator */ 85788));
                var _index = __webpack_require__( /*! ../utils/index */ 39611);
                var _pointer = _interopRequireDefault(__webpack_require__( /*! ../pointer */ 93786));
                var _wheel = __webpack_require__( /*! ./wheel */ 765);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var EventManager = _class.default.inherit({
                    ctor: function() {
                        this._attachHandlers();
                        this.reset();
                        this._proxiedCancelHandler = this._cancelHandler.bind(this);
                        this._proxiedAcceptHandler = this._acceptHandler.bind(this)
                    },
                    _attachHandlers: function() {
                        _ready_callbacks.default.add(function() {
                            var document = _dom_adapter.default.getDocument();
                            _events_engine.default.subscribeGlobal(document, (0, _index.addNamespace)(_pointer.default.down, "dxEventManager"), this._pointerDownHandler.bind(this));
                            _events_engine.default.subscribeGlobal(document, (0, _index.addNamespace)(_pointer.default.move, "dxEventManager"), this._pointerMoveHandler.bind(this));
                            _events_engine.default.subscribeGlobal(document, (0, _index.addNamespace)([_pointer.default.up, _pointer.default.cancel].join(" "), "dxEventManager"), this._pointerUpHandler.bind(this));
                            _events_engine.default.subscribeGlobal(document, (0, _index.addNamespace)(_wheel.name, "dxEventManager"), this._mouseWheelHandler.bind(this))
                        }.bind(this))
                    },
                    _eachEmitter: function(callback) {
                        var activeEmitters = this._activeEmitters || [];
                        var i = 0;
                        while (activeEmitters.length > i) {
                            var emitter = activeEmitters[i];
                            if (false === callback(emitter)) {
                                break
                            }
                            if (activeEmitters[i] === emitter) {
                                i++
                            }
                        }
                    },
                    _applyToEmitters: function(method, arg) {
                        this._eachEmitter((function(emitter) {
                            emitter[method].call(emitter, arg)
                        }))
                    },
                    reset: function() {
                        this._eachEmitter(this._proxiedCancelHandler);
                        this._activeEmitters = []
                    },
                    resetEmitter: function(emitter) {
                        this._proxiedCancelHandler(emitter)
                    },
                    _pointerDownHandler: function(e) {
                        if ((0, _index.isMouseEvent)(e) && e.which > 1) {
                            return
                        }
                        this._updateEmitters(e)
                    },
                    _updateEmitters: function(e) {
                        if (!this._isSetChanged(e)) {
                            return
                        }
                        this._cleanEmitters(e);
                        this._fetchEmitters(e)
                    },
                    _isSetChanged: function(e) {
                        var currentSet = this._closestEmitter(e);
                        var previousSet = this._emittersSet || [];
                        var setChanged = currentSet.length !== previousSet.length;
                        (0, _iterator.each)(currentSet, (function(index, emitter) {
                            setChanged = setChanged || previousSet[index] !== emitter;
                            return !setChanged
                        }));
                        this._emittersSet = currentSet;
                        return setChanged
                    },
                    _closestEmitter: function(e) {
                        var that = this;
                        var result = [];
                        var $element = (0, _renderer.default)(e.target);

                        function handleEmitter(_, emitter) {
                            if (!!emitter && emitter.validatePointers(e) && emitter.validate(e)) {
                                emitter.addCancelCallback(that._proxiedCancelHandler);
                                emitter.addAcceptCallback(that._proxiedAcceptHandler);
                                result.push(emitter)
                            }
                        }
                        while ($element.length) {
                            var emitters = (0, _element_data.data)($element.get(0), "dxEmitter") || [];
                            (0, _iterator.each)(emitters, handleEmitter);
                            $element = $element.parent()
                        }
                        return result
                    },
                    _acceptHandler: function(acceptedEmitter, e) {
                        var that = this;
                        this._eachEmitter((function(emitter) {
                            if (emitter !== acceptedEmitter) {
                                that._cancelEmitter(emitter, e)
                            }
                        }))
                    },
                    _cancelHandler: function(canceledEmitter, e) {
                        this._cancelEmitter(canceledEmitter, e)
                    },
                    _cancelEmitter: function(emitter, e) {
                        var activeEmitters = this._activeEmitters;
                        if (e) {
                            emitter.cancel(e)
                        } else {
                            emitter.reset()
                        }
                        emitter.removeCancelCallback();
                        emitter.removeAcceptCallback();
                        var emitterIndex = activeEmitters.indexOf(emitter);
                        if (emitterIndex > -1) {
                            activeEmitters.splice(emitterIndex, 1)
                        }
                    },
                    _cleanEmitters: function(e) {
                        this._applyToEmitters("end", e);
                        this.reset(e)
                    },
                    _fetchEmitters: function(e) {
                        this._activeEmitters = this._emittersSet.slice();
                        this._applyToEmitters("start", e)
                    },
                    _pointerMoveHandler: function(e) {
                        this._applyToEmitters("move", e)
                    },
                    _pointerUpHandler: function(e) {
                        this._updateEmitters(e)
                    },
                    _mouseWheelHandler: function(e) {
                        if (!this._allowInterruptionByMouseWheel()) {
                            return
                        }
                        e.pointers = [null];
                        this._pointerDownHandler(e);
                        this._adjustWheelEvent(e);
                        this._pointerMoveHandler(e);
                        e.pointers = [];
                        this._pointerUpHandler(e)
                    },
                    _allowInterruptionByMouseWheel: function() {
                        var allowInterruption = true;
                        this._eachEmitter((function(emitter) {
                            allowInterruption = emitter.allowInterruptionByMouseWheel() && allowInterruption;
                            return allowInterruption
                        }));
                        return allowInterruption
                    },
                    _adjustWheelEvent: function(e) {
                        var closestGestureEmitter = null;
                        this._eachEmitter((function(emitter) {
                            if (!emitter.gesture) {
                                return
                            }
                            var direction = emitter.getDirection(e);
                            if ("horizontal" !== direction && !e.shiftKey || "vertical" !== direction && e.shiftKey) {
                                closestGestureEmitter = emitter;
                                return false
                            }
                        }));
                        if (!closestGestureEmitter) {
                            return
                        }
                        var direction = closestGestureEmitter.getDirection(e);
                        var verticalGestureDirection = "both" === direction && !e.shiftKey || "vertical" === direction;
                        var prop = verticalGestureDirection ? "pageY" : "pageX";
                        e[prop] += e.delta
                    },
                    isActive: function(element) {
                        var result = false;
                        this._eachEmitter((function(emitter) {
                            result = result || emitter.getElement().is(element)
                        }));
                        return result
                    }
                });
                var eventManager = new EventManager;
                var _default = function(emitterConfig) {
                    var emitterClass = emitterConfig.emitter;
                    var emitterName = emitterConfig.events[0];
                    var emitterEvents = emitterConfig.events;
                    (0, _iterator.each)(emitterEvents, (function(_, eventName) {
                        (0, _event_registrator.default)(eventName, {
                            noBubble: !emitterConfig.bubble,
                            setup: function(element) {
                                var subscriptions = (0, _element_data.data)(element, "dxEmitterSubscription") || {};
                                var emitters = (0, _element_data.data)(element, "dxEmitter") || {};
                                var emitter = emitters[emitterName] || new emitterClass(element);
                                subscriptions[eventName] = true;
                                emitters[emitterName] = emitter;
                                (0, _element_data.data)(element, "dxEmitter", emitters);
                                (0, _element_data.data)(element, "dxEmitterSubscription", subscriptions)
                            },
                            add: function(element, handleObj) {
                                var emitters = (0, _element_data.data)(element, "dxEmitter");
                                var emitter = emitters[emitterName];
                                emitter.configure((0, _extend.extend)({
                                    delegateSelector: handleObj.selector
                                }, handleObj.data), handleObj.type)
                            },
                            teardown: function(element) {
                                var subscriptions = (0, _element_data.data)(element, "dxEmitterSubscription");
                                var emitters = (0, _element_data.data)(element, "dxEmitter");
                                var emitter = emitters[emitterName];
                                delete subscriptions[eventName];
                                var disposeEmitter = true;
                                (0, _iterator.each)(emitterEvents, (function(_, eventName) {
                                    disposeEmitter = disposeEmitter && !subscriptions[eventName];
                                    return disposeEmitter
                                }));
                                if (disposeEmitter) {
                                    if (eventManager.isActive(element)) {
                                        eventManager.resetEmitter(emitter)
                                    }
                                    emitter && emitter.dispose();
                                    delete emitters[emitterName]
                                }
                            }
                        })
                    }))
                };
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        85788:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/core/event_registrator.js ***!
              \******************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 95479);
                var _event_registrator_callbacks = (obj = __webpack_require__( /*! ./event_registrator_callbacks */ 94553), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var registerEvent = function(name, eventObject) {
                    var strategy = {};
                    if ("noBubble" in eventObject) {
                        strategy.noBubble = eventObject.noBubble
                    }
                    if ("bindType" in eventObject) {
                        strategy.bindType = eventObject.bindType
                    }
                    if ("delegateType" in eventObject) {
                        strategy.delegateType = eventObject.delegateType
                    }(0, _iterator.each)(["setup", "teardown", "add", "remove", "trigger", "handle", "_default", "dispose"], (function(_, methodName) {
                        if (!eventObject[methodName]) {
                            return
                        }
                        strategy[methodName] = function() {
                            var args = [].slice.call(arguments);
                            args.unshift(this);
                            return eventObject[methodName].apply(eventObject, args)
                        }
                    }));
                    _event_registrator_callbacks.default.fire(name, strategy)
                };
                registerEvent.callbacks = _event_registrator_callbacks.default;
                var _default = registerEvent;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        94553:
            /*!****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/core/event_registrator_callbacks.js ***!
              \****************************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _memorized_callbacks = (obj = __webpack_require__( /*! ../../core/memorized_callbacks */ 83358), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _default = new _memorized_callbacks.default;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        55994:
            /*!**************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/core/events_engine.js ***!
              \**************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _event_registrator_callbacks = _interopRequireDefault(__webpack_require__( /*! ./event_registrator_callbacks */ 94553));
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 73349));
                var _window = __webpack_require__( /*! ../../core/utils/window */ 58201);
                var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/dependency_injector */ 20476));
                var _type = __webpack_require__( /*! ../../core/utils/type */ 35922);
                var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/callbacks */ 44504));
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../../core/errors */ 17381));
                var _hook_touch_props = _interopRequireDefault(__webpack_require__( /*! ../../events/core/hook_touch_props */ 2418));
                var _call_once = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/call_once */ 39618));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _typeof(obj) {
                    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj) {
                        return typeof obj
                    } : function(obj) {
                        return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                    }, _typeof(obj)
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                var window = (0, _window.getWindow)();
                var NATIVE_EVENTS_TO_SUBSCRIBE = {
                    mouseenter: "mouseover",
                    mouseleave: "mouseout",
                    pointerenter: "pointerover",
                    pointerleave: "pointerout"
                };
                var NATIVE_EVENTS_TO_TRIGGER = {
                    focusin: "focus",
                    focusout: "blur"
                };
                var NO_BUBBLE_EVENTS = ["blur", "focus", "load"];
                var forcePassiveFalseEventNames = ["touchmove", "wheel", "mousewheel", "touchstart"];

                function matchesSafe(target, selector) {
                    return !(0, _type.isWindow)(target) && "#document" !== target.nodeName && _dom_adapter.default.elementMatches(target, selector)
                }
                var elementDataMap = new WeakMap;
                var guid = 0;
                var skipEvent;
                var special = function() {
                    var specialData = {};
                    _event_registrator_callbacks.default.add((function(eventName, eventObject) {
                        specialData[eventName] = eventObject
                    }));
                    return {
                        getField: function(eventName, field) {
                            return specialData[eventName] && specialData[eventName][field]
                        },
                        callMethod: function(eventName, methodName, context, args) {
                            return specialData[eventName] && specialData[eventName][methodName] && specialData[eventName][methodName].apply(context, args)
                        }
                    }
                }();
                var eventsEngine = (0, _dependency_injector.default)({
                    on: getHandler(normalizeOnArguments(iterate((function(element, eventName, selector, data, handler) {
                        var handlersController = getHandlersController(element, eventName);
                        handlersController.addHandler(handler, selector, data)
                    })))),
                    one: getHandler(normalizeOnArguments((function(element, eventName, selector, data, handler) {
                        eventsEngine.on(element, eventName, selector, data, (function oneTimeHandler() {
                            eventsEngine.off(element, eventName, selector, oneTimeHandler);
                            handler.apply(this, arguments)
                        }))
                    }))),
                    off: getHandler((callback = iterate((function(element, eventName, selector, handler) {
                        var handlersController = getHandlersController(element, eventName);
                        handlersController.removeHandler(handler, selector)
                    })), function(element, eventName, selector, handler) {
                        if ("function" === typeof selector) {
                            handler = selector;
                            selector = void 0
                        }
                        callback(element, eventName, selector, handler)
                    })),
                    trigger: getHandler(normalizeTriggerArguments((function(element, event, extraParameters) {
                        var eventName = event.type;
                        var handlersController = getHandlersController(element, event.type);
                        special.callMethod(eventName, "trigger", element, [event, extraParameters]);
                        handlersController.callHandlers(event, extraParameters);
                        var noBubble = special.getField(eventName, "noBubble") || event.isPropagationStopped() || -1 !== NO_BUBBLE_EVENTS.indexOf(eventName);
                        if (!noBubble) {
                            var parents = [];
                            ! function getParents(element) {
                                var _element$parentNode;
                                var parent = null !== (_element$parentNode = element.parentNode) && void 0 !== _element$parentNode ? _element$parentNode : element.host;
                                if (parent) {
                                    parents.push(parent);
                                    getParents(parent)
                                }
                            }(element);
                            parents.push(window);
                            var i = 0;
                            while (parents[i] && !event.isPropagationStopped()) {
                                var parentDataByEvent = getHandlersController(parents[i], event.type);
                                parentDataByEvent.callHandlers((0, _extend.extend)(event, {
                                    currentTarget: parents[i]
                                }), extraParameters);
                                i++
                            }
                        }
                        if (element.nodeType || (0, _type.isWindow)(element)) {
                            special.callMethod(eventName, "_default", element, [event, extraParameters]);
                            ! function(eventName, element) {
                                var nativeMethodName = NATIVE_EVENTS_TO_TRIGGER[eventName] || eventName;
                                if (function(eventName, element) {
                                        return "click" === eventName && "a" === element.localName
                                    }(eventName, element)) {
                                    return
                                }
                                if ((0, _type.isFunction)(element[nativeMethodName])) {
                                    skipEvent = eventName;
                                    element[nativeMethodName]();
                                    skipEvent = void 0
                                }
                            }(eventName, element)
                        }
                    }))),
                    triggerHandler: getHandler(normalizeTriggerArguments((function(element, event, extraParameters) {
                        var handlersController = getHandlersController(element, event.type);
                        handlersController.callHandlers(event, extraParameters)
                    })))
                });
                var callback;

                function applyForEach(args, method) {
                    var element = args[0];
                    if (!element) {
                        return
                    }
                    if (_dom_adapter.default.isNode(element) || (0, _type.isWindow)(element)) {
                        method.apply(eventsEngine, args)
                    } else if (!(0, _type.isString)(element) && "length" in element) {
                        var itemArgs = Array.prototype.slice.call(args, 0);
                        Array.prototype.forEach.call(element, (function(itemElement) {
                            itemArgs[0] = itemElement;
                            applyForEach(itemArgs, method)
                        }))
                    } else {
                        throw _errors.default.Error("E0025")
                    }
                }

                function getHandler(method) {
                    return function() {
                        applyForEach(arguments, method)
                    }
                }
                var passiveEventHandlersSupported = (0, _call_once.default)((function() {
                    var isSupported = false;
                    try {
                        var options = Object.defineProperty({}, "passive", {
                            get: function() {
                                isSupported = true;
                                return true
                            }
                        });
                        window.addEventListener("test", null, options)
                    } catch (e) {}
                    return isSupported
                }));

                function getHandlersController(element, eventName) {
                    var elementData = elementDataMap.get(element);
                    eventName = eventName || "";
                    var eventNameParts = eventName.split(".");
                    var namespaces = eventNameParts.slice(1);
                    var eventNameIsDefined = !!eventNameParts[0];
                    eventName = eventNameParts[0] || "dxEmptyEventType";
                    if (!elementData) {
                        elementData = {};
                        elementDataMap.set(element, elementData)
                    }
                    if (!elementData[eventName]) {
                        elementData[eventName] = {
                            handleObjects: [],
                            nativeHandler: null
                        }
                    }
                    var eventData = elementData[eventName];
                    return {
                        addHandler: function(handler, selector, data) {
                            var callHandler = function(e, extraParameters) {
                                var handlerArgs = [e];
                                var target = e.currentTarget;
                                var relatedTarget = e.relatedTarget;
                                var secondaryTargetIsInside;
                                var result;
                                if (eventName in NATIVE_EVENTS_TO_SUBSCRIBE) {
                                    secondaryTargetIsInside = relatedTarget && target && (relatedTarget === target || function contains(container, element) {
                                        if ((0, _type.isWindow)(container)) {
                                            return contains(container.document, element)
                                        }
                                        return container.contains ? container.contains(element) : !!(element.compareDocumentPosition(container) & element.DOCUMENT_POSITION_CONTAINS)
                                    }(target, relatedTarget))
                                }
                                if (void 0 !== extraParameters) {
                                    handlerArgs.push(extraParameters)
                                }
                                special.callMethod(eventName, "handle", element, [e, data]);
                                if (!secondaryTargetIsInside) {
                                    result = handler.apply(target, handlerArgs)
                                }
                                if (false === result) {
                                    e.preventDefault();
                                    e.stopPropagation()
                                }
                            };
                            var handleObject = {
                                handler: handler,
                                wrappedHandler: function(e, extraParameters) {
                                    if (skipEvent && e.type === skipEvent) {
                                        return
                                    }
                                    e.data = data;
                                    e.delegateTarget = element;
                                    if (selector) {
                                        var currentTarget = e.target;
                                        while (currentTarget && currentTarget !== element) {
                                            if (matchesSafe(currentTarget, selector)) {
                                                e.currentTarget = currentTarget;
                                                callHandler(e, extraParameters)
                                            }
                                            currentTarget = currentTarget.parentNode
                                        }
                                    } else {
                                        e.currentTarget = e.delegateTarget || e.target;
                                        callHandler(e, extraParameters)
                                    }
                                },
                                selector: selector,
                                type: eventName,
                                data: data,
                                namespace: namespaces.join("."),
                                namespaces: namespaces,
                                guid: ++guid
                            };
                            eventData.handleObjects.push(handleObject);
                            var firstHandlerForTheType = 1 === eventData.handleObjects.length;
                            var shouldAddNativeListener = firstHandlerForTheType && eventNameIsDefined;
                            var nativeListenerOptions;
                            if (shouldAddNativeListener) {
                                shouldAddNativeListener = !special.callMethod(eventName, "setup", element, [data, namespaces, handler])
                            }
                            if (shouldAddNativeListener) {
                                eventData.nativeHandler = (subscribeName = eventName, function(event, extraParameters) {
                                    var handlersController = getHandlersController(this, subscribeName);
                                    event = eventsEngine.Event(event);
                                    handlersController.callHandlers(event, extraParameters)
                                });
                                if (passiveEventHandlersSupported() && forcePassiveFalseEventNames.indexOf(eventName) > -1) {
                                    nativeListenerOptions = {
                                        passive: false
                                    }
                                }
                                eventData.removeListener = _dom_adapter.default.listen(element, NATIVE_EVENTS_TO_SUBSCRIBE[eventName] || eventName, eventData.nativeHandler, nativeListenerOptions)
                            }
                            var subscribeName;
                            special.callMethod(eventName, "add", element, [handleObject])
                        },
                        removeHandler: function(handler, selector) {
                            var removeByEventName = function(eventName) {
                                var eventData = elementData[eventName];
                                if (!eventData.handleObjects.length) {
                                    delete elementData[eventName];
                                    return
                                }
                                var removedHandler;
                                eventData.handleObjects = eventData.handleObjects.filter((function(handleObject) {
                                    var skip = namespaces.length && !isSubset(handleObject.namespaces, namespaces) || handler && handleObject.handler !== handler || selector && handleObject.selector !== selector;
                                    if (!skip) {
                                        removedHandler = handleObject.handler;
                                        special.callMethod(eventName, "remove", element, [handleObject])
                                    }
                                    return skip
                                }));
                                var lastHandlerForTheType = !eventData.handleObjects.length;
                                var shouldRemoveNativeListener = lastHandlerForTheType && "dxEmptyEventType" !== eventName;
                                if (shouldRemoveNativeListener) {
                                    special.callMethod(eventName, "teardown", element, [namespaces, removedHandler]);
                                    if (eventData.nativeHandler) {
                                        eventData.removeListener()
                                    }
                                    delete elementData[eventName]
                                }
                            };
                            if (eventNameIsDefined) {
                                removeByEventName(eventName)
                            } else {
                                for (var name in elementData) {
                                    removeByEventName(name)
                                }
                            }
                            var elementDataIsEmpty = 0 === Object.keys(elementData).length;
                            if (elementDataIsEmpty) {
                                elementDataMap.delete(element)
                            }
                        },
                        callHandlers: function(event, extraParameters) {
                            var forceStop = false;
                            var handleCallback = function(handleObject) {
                                if (forceStop) {
                                    return
                                }
                                if (!namespaces.length || isSubset(handleObject.namespaces, namespaces)) {
                                    handleObject.wrappedHandler(event, extraParameters);
                                    forceStop = event.isImmediatePropagationStopped()
                                }
                            };
                            eventData.handleObjects.forEach(handleCallback);
                            if (namespaces.length && elementData.dxEmptyEventType) {
                                elementData.dxEmptyEventType.handleObjects.forEach(handleCallback)
                            }
                        }
                    }
                }

                function isSubset(original, checked) {
                    for (var i = 0; i < checked.length; i++) {
                        if (original.indexOf(checked[i]) < 0) {
                            return false
                        }
                    }
                    return true
                }

                function normalizeOnArguments(callback) {
                    return function(element, eventName, selector, data, handler) {
                        if (!handler) {
                            handler = data;
                            data = void 0
                        }
                        if ("string" !== typeof selector) {
                            data = selector;
                            selector = void 0
                        }
                        if (!handler && "string" === typeof eventName) {
                            handler = data || selector;
                            selector = void 0;
                            data = void 0
                        }
                        callback(element, eventName, selector, data, handler)
                    }
                }

                function normalizeTriggerArguments(callback) {
                    return function(element, src, extraParameters) {
                        if ("string" === typeof src) {
                            src = {
                                type: src
                            }
                        }
                        if (!src.target) {
                            src.target = element
                        }
                        src.currentTarget = element;
                        if (!src.delegateTarget) {
                            src.delegateTarget = element
                        }
                        if (!src.type && src.originalEvent) {
                            src.type = src.originalEvent.type
                        }
                        callback(element, src instanceof eventsEngine.Event ? src : eventsEngine.Event(src), extraParameters)
                    }
                }

                function iterate(callback) {
                    var iterateEventNames = function(element, eventName) {
                        if (eventName && eventName.indexOf(" ") > -1) {
                            var args = Array.prototype.slice.call(arguments, 0);
                            eventName.split(" ").forEach((function(eventName) {
                                args[1] = eventName;
                                callback.apply(this, args)
                            }))
                        } else {
                            callback.apply(this, arguments)
                        }
                    };
                    return function(element, eventName) {
                        if ("object" === _typeof(eventName)) {
                            var args = Array.prototype.slice.call(arguments, 0);
                            for (var name in eventName) {
                                args[1] = name;
                                args[args.length - 1] = eventName[name];
                                iterateEventNames.apply(this, args)
                            }
                        } else {
                            iterateEventNames.apply(this, arguments)
                        }
                    }
                }

                function calculateWhich(event) {
                    if (function(event) {
                            return null == event.which && 0 === event.type.indexOf("key")
                        }(event)) {
                        return null != event.charCode ? event.charCode : event.keyCode
                    }
                    if (function(event) {
                            return !event.which && void 0 !== event.button && /^(?:mouse|pointer|contextmenu|drag|drop)|click/.test(event.type)
                        }(event)) {
                        return {
                            1: 1,
                            2: 3,
                            3: 1,
                            4: 2
                        } [event.button]
                    }
                    return event.which
                }

                function initEvent(EventClass) {
                    if (EventClass) {
                        eventsEngine.Event = EventClass;
                        eventsEngine.Event.prototype = EventClass.prototype
                    }
                }
                initEvent(function(callback) {
                    eventsEngine.Event = function(src, config) {
                        if (!(this instanceof eventsEngine.Event)) {
                            return new eventsEngine.Event(src, config)
                        }
                        if (!src) {
                            src = {}
                        }
                        if ("string" === typeof src) {
                            src = {
                                type: src
                            }
                        }
                        if (!config) {
                            config = {}
                        }
                        callback.call(this, src, config)
                    };
                    _extends(eventsEngine.Event.prototype, {
                        _propagationStopped: false,
                        _immediatePropagationStopped: false,
                        _defaultPrevented: false,
                        isPropagationStopped: function() {
                            return !!(this._propagationStopped || this.originalEvent && this.originalEvent.propagationStopped)
                        },
                        stopPropagation: function() {
                            this._propagationStopped = true;
                            this.originalEvent && this.originalEvent.stopPropagation()
                        },
                        isImmediatePropagationStopped: function() {
                            return this._immediatePropagationStopped
                        },
                        stopImmediatePropagation: function() {
                            this.stopPropagation();
                            this._immediatePropagationStopped = true;
                            this.originalEvent && this.originalEvent.stopImmediatePropagation()
                        },
                        isDefaultPrevented: function() {
                            return !!(this._defaultPrevented || this.originalEvent && this.originalEvent.defaultPrevented)
                        },
                        preventDefault: function() {
                            this._defaultPrevented = true;
                            this.originalEvent && this.originalEvent.preventDefault()
                        }
                    });
                    return eventsEngine.Event
                }((function(src, config) {
                    var _src$view;
                    var srcIsEvent = src instanceof eventsEngine.Event || (0, _window.hasWindow)() && src instanceof window.Event || (null === (_src$view = src.view) || void 0 === _src$view ? void 0 : _src$view.Event) && src instanceof src.view.Event;
                    if (srcIsEvent) {
                        this.originalEvent = src;
                        this.type = src.type;
                        this.currentTarget = void 0;
                        if (Object.prototype.hasOwnProperty.call(src, "isTrusted")) {
                            this.isTrusted = src.isTrusted
                        }
                        this.timeStamp = src.timeStamp || Date.now()
                    } else {
                        _extends(this, src)
                    }
                    addProperty("which", calculateWhich, this);
                    if (0 === src.type.indexOf("touch")) {
                        delete config.pageX;
                        delete config.pageY
                    }
                    _extends(this, config);
                    this.guid = ++guid
                })));

                function addProperty(propName, hook, eventInstance) {
                    Object.defineProperty(eventInstance || eventsEngine.Event.prototype, propName, {
                        enumerable: true,
                        configurable: true,
                        get: function() {
                            return this.originalEvent && hook(this.originalEvent)
                        },
                        set: function(value) {
                            Object.defineProperty(this, propName, {
                                enumerable: true,
                                configurable: true,
                                writable: true,
                                value: value
                            })
                        }
                    })
                } ["target", "relatedTarget", "delegateTarget", "altKey", "bubbles", "cancelable", "changedTouches", "ctrlKey", "detail", "eventPhase", "metaKey", "shiftKey", "view", "char", "code", "charCode", "key", "keyCode", "button", "buttons", "offsetX", "offsetY", "pointerId", "pointerType", "targetTouches", "toElement", "touches"].forEach((function(prop) {
                    return addProperty(prop, (function(event) {
                        return event[prop]
                    }))
                }));
                (0, _hook_touch_props.default)(addProperty);
                var beforeSetStrategy = (0, _callbacks.default)();
                var afterSetStrategy = (0, _callbacks.default)();
                eventsEngine.set = function(engine) {
                    beforeSetStrategy.fire();
                    eventsEngine.inject(engine);
                    initEvent(engine.Event);
                    afterSetStrategy.fire()
                };
                eventsEngine.subscribeGlobal = function() {
                    applyForEach(arguments, normalizeOnArguments((function() {
                        var args = arguments;
                        eventsEngine.on.apply(this, args);
                        beforeSetStrategy.add((function() {
                            var offArgs = Array.prototype.slice.call(args, 0);
                            offArgs.splice(3, 1);
                            eventsEngine.off.apply(this, offArgs)
                        }));
                        afterSetStrategy.add((function() {
                            eventsEngine.on.apply(this, args)
                        }))
                    })))
                };
                eventsEngine.forcePassiveFalseEventNames = forcePassiveFalseEventNames;
                eventsEngine.passiveEventHandlersSupported = passiveEventHandlersSupported;
                var _default = eventsEngine;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        2418:
            /*!*****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/core/hook_touch_props.js ***!
              \*****************************************************************************/
            function(module, exports) {
                exports.default = function(callback) {
                    touchPropsToHook.forEach((function(name) {
                        callback(name, (function(event) {
                            return function(name, event) {
                                if (event[name] && !event.touches || !event.touches) {
                                    return event[name]
                                }
                                var touches = event.touches.length ? event.touches : event.changedTouches;
                                if (!touches.length) {
                                    return
                                }
                                return touches[0][name]
                            }(name, event)
                        }))
                    }), this)
                };
                var touchPropsToHook = ["pageX", "pageY", "screenX", "screenY", "clientX", "clientY"];
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        51661:
            /*!*******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/core/keyboard_processor.js ***!
              \*******************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 68374));
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 55994));
                var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 38377));
                var _index = __webpack_require__( /*! ../../events/utils/index */ 39611);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var createKeyDownOptions = function(e) {
                    return {
                        keyName: (0, _index.normalizeKeyName)(e),
                        key: e.key,
                        code: e.code,
                        ctrl: e.ctrlKey,
                        location: e.location,
                        metaKey: e.metaKey,
                        shift: e.shiftKey,
                        alt: e.altKey,
                        which: e.which,
                        originalEvent: e
                    }
                };
                var KeyboardProcessor = _class.default.inherit({
                    _keydown: (0, _index.addNamespace)("keydown", "KeyboardProcessor"),
                    _compositionStart: (0, _index.addNamespace)("compositionstart", "KeyboardProcessor"),
                    _compositionEnd: (0, _index.addNamespace)("compositionend", "KeyboardProcessor"),
                    ctor: function(options) {
                        var _this = this;
                        options = options || {};
                        if (options.element) {
                            this._element = (0, _renderer.default)(options.element)
                        }
                        if (options.focusTarget) {
                            this._focusTarget = options.focusTarget
                        }
                        this._handler = options.handler;
                        if (this._element) {
                            this._processFunction = function(e) {
                                var focusTargets = (0, _renderer.default)(_this._focusTarget).toArray();
                                var isNotFocusTarget = _this._focusTarget && _this._focusTarget !== e.target && !focusTargets.includes(e.target);
                                var shouldSkipProcessing = _this._isComposingJustFinished && 229 === e.which || _this._isComposing || isNotFocusTarget;
                                _this._isComposingJustFinished = false;
                                if (!shouldSkipProcessing) {
                                    _this.process(e)
                                }
                            };
                            this._toggleProcessingWithContext = this.toggleProcessing.bind(this);
                            _events_engine.default.on(this._element, this._keydown, this._processFunction);
                            _events_engine.default.on(this._element, this._compositionStart, this._toggleProcessingWithContext);
                            _events_engine.default.on(this._element, this._compositionEnd, this._toggleProcessingWithContext)
                        }
                    },
                    dispose: function() {
                        if (this._element) {
                            _events_engine.default.off(this._element, this._keydown, this._processFunction);
                            _events_engine.default.off(this._element, this._compositionStart, this._toggleProcessingWithContext);
                            _events_engine.default.off(this._element, this._compositionEnd, this._toggleProcessingWithContext)
                        }
                        this._element = void 0;
                        this._handler = void 0
                    },
                    process: function(e) {
                        this._handler(createKeyDownOptions(e))
                    },
                    toggleProcessing: function(_ref) {
                        var type = _ref.type;
                        this._isComposing = "compositionstart" === type;
                        this._isComposingJustFinished = !this._isComposing
                    }
                });
                KeyboardProcessor.createKeyDownOptions = createKeyDownOptions;
                var _default = KeyboardProcessor;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        765:
            /*!******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/core/wheel.js ***!
              \******************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.name = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 68374));
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 55994));
                var _event_registrator = _interopRequireDefault(__webpack_require__( /*! ./event_registrator */ 85788));
                var _index = __webpack_require__( /*! ../utils/index */ 39611);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                exports.name = "dxmousewheel";
                var wheel = {
                    setup: function(element) {
                        var $element = (0, _renderer.default)(element);
                        _events_engine.default.on($element, (0, _index.addNamespace)("wheel", "dxWheel"), wheel._wheelHandler.bind(wheel))
                    },
                    teardown: function(element) {
                        _events_engine.default.off(element, ".".concat("dxWheel"))
                    },
                    _wheelHandler: function(e) {
                        var _e$originalEvent = e.originalEvent,
                            deltaMode = _e$originalEvent.deltaMode,
                            deltaY = _e$originalEvent.deltaY,
                            deltaX = _e$originalEvent.deltaX,
                            deltaZ = _e$originalEvent.deltaZ;
                        (0, _index.fireEvent)({
                            type: "dxmousewheel",
                            originalEvent: e,
                            delta: this._normalizeDelta(deltaY, deltaMode),
                            deltaX: deltaX,
                            deltaY: deltaY,
                            deltaZ: deltaZ,
                            deltaMode: deltaMode,
                            pointerType: "mouse"
                        });
                        e.stopPropagation()
                    },
                    _normalizeDelta: function(delta) {
                        var deltaMode = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : 0;
                        if (0 === deltaMode) {
                            return -delta
                        } else {
                            return -30 * delta
                        }
                    }
                };
                (0, _event_registrator.default)("dxmousewheel", wheel)
            },
        85272:
            /*!********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/double_click.js ***!
              \********************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.name = void 0;
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../events/core/events_engine */ 55994));
                var _dom = __webpack_require__( /*! ../core/utils/dom */ 3532);
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../core/dom_adapter */ 73349));
                var _class = _interopRequireDefault(__webpack_require__( /*! ../core/class */ 38377));
                var _event_registrator = _interopRequireDefault(__webpack_require__( /*! ./core/event_registrator */ 85788));
                var _click = __webpack_require__( /*! ./click */ 95429);
                var _index = __webpack_require__( /*! ./utils/index */ 39611);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                exports.name = "dxdblclick";
                var NAMESPACED_CLICK_EVENT = (0, _index.addNamespace)(_click.name, "dxDblClick");
                var DblClick = _class.default.inherit({
                    ctor: function() {
                        this._handlerCount = 0;
                        this._forgetLastClick()
                    },
                    _forgetLastClick: function() {
                        this._firstClickTarget = null;
                        this._lastClickTimeStamp = -300
                    },
                    add: function() {
                        if (this._handlerCount <= 0) {
                            _events_engine.default.on(_dom_adapter.default.getDocument(), NAMESPACED_CLICK_EVENT, this._clickHandler.bind(this))
                        }
                        this._handlerCount++
                    },
                    _clickHandler: function(e) {
                        var timeStamp = e.timeStamp || Date.now();
                        var timeBetweenClicks = timeStamp - this._lastClickTimeStamp;
                        var isSimulated = timeBetweenClicks < 0;
                        var isDouble = !isSimulated && timeBetweenClicks < 300;
                        if (isDouble) {
                            (0, _index.fireEvent)({
                                type: "dxdblclick",
                                target: (0, _dom.closestCommonParent)(this._firstClickTarget, e.target),
                                originalEvent: e
                            });
                            this._forgetLastClick()
                        } else {
                            this._firstClickTarget = e.target;
                            this._lastClickTimeStamp = timeStamp
                        }
                    },
                    remove: function() {
                        this._handlerCount--;
                        if (this._handlerCount <= 0) {
                            this._forgetLastClick();
                            _events_engine.default.off(_dom_adapter.default.getDocument(), NAMESPACED_CLICK_EVENT)
                        }
                    }
                });
                (0, _event_registrator.default)("dxdblclick", new DblClick)
            },
        23174:
            /*!************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/drag.js ***!
              \************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                function _typeof(obj) {
                    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj) {
                        return typeof obj
                    } : function(obj) {
                        return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                    }, _typeof(obj)
                }
                exports.start = exports.move = exports.leave = exports.enter = exports.end = exports.drop = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 68374));
                var _element_data = __webpack_require__( /*! ../core/element_data */ 97906);
                var _array = __webpack_require__( /*! ../core/utils/array */ 89386);
                var iteratorUtils = function(obj, nodeInterop) {
                    if (!nodeInterop && obj && obj.__esModule) {
                        return obj
                    }
                    if (null === obj || "object" !== _typeof(obj) && "function" !== typeof obj) {
                        return {
                            default: obj
                        }
                    }
                    var cache = _getRequireWildcardCache(nodeInterop);
                    if (cache && cache.has(obj)) {
                        return cache.get(obj)
                    }
                    var newObj = {};
                    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
                    for (var key in obj) {
                        if ("default" !== key && Object.prototype.hasOwnProperty.call(obj, key)) {
                            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
                            if (desc && (desc.get || desc.set)) {
                                Object.defineProperty(newObj, key, desc)
                            } else {
                                newObj[key] = obj[key]
                            }
                        }
                    }
                    newObj.default = obj;
                    if (cache) {
                        cache.set(obj, newObj)
                    }
                    return newObj
                }(__webpack_require__( /*! ../core/utils/iterator */ 95479));
                var _dom = __webpack_require__( /*! ../core/utils/dom */ 3532);
                var _event_registrator = _interopRequireDefault(__webpack_require__( /*! ./core/event_registrator */ 85788));
                var _index = __webpack_require__( /*! ./utils/index */ 39611);
                var _emitter = _interopRequireDefault(__webpack_require__( /*! ./gesture/emitter.gesture */ 98621));
                var _emitter_registrator = _interopRequireDefault(__webpack_require__( /*! ./core/emitter_registrator */ 82495));

                function _getRequireWildcardCache(nodeInterop) {
                    if ("function" !== typeof WeakMap) {
                        return null
                    }
                    var cacheBabelInterop = new WeakMap;
                    var cacheNodeInterop = new WeakMap;
                    return (_getRequireWildcardCache = function(nodeInterop) {
                        return nodeInterop ? cacheNodeInterop : cacheBabelInterop
                    })(nodeInterop)
                }

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                exports.start = "dxdragstart";
                exports.move = "dxdrag";
                exports.end = "dxdragend";
                var DRAG_ENTER_EVENT = "dxdragenter";
                exports.enter = DRAG_ENTER_EVENT;
                var DRAG_LEAVE_EVENT = "dxdragleave";
                exports.leave = DRAG_LEAVE_EVENT;
                var DROP_EVENT = "dxdrop";
                exports.drop = DROP_EVENT;
                var knownDropTargets = [];
                var knownDropTargetSelectors = [];
                var knownDropTargetConfigs = [];
                var dropTargetRegistration = {
                    setup: function(element, data) {
                        var knownDropTarget = knownDropTargets.includes(element);
                        if (!knownDropTarget) {
                            knownDropTargets.push(element);
                            knownDropTargetSelectors.push([]);
                            knownDropTargetConfigs.push(data || {})
                        }
                    },
                    add: function(element, handleObj) {
                        var index = knownDropTargets.indexOf(element);
                        this.updateEventsCounter(element, handleObj.type, 1);
                        var selector = handleObj.selector;
                        if (!knownDropTargetSelectors[index].includes(selector)) {
                            knownDropTargetSelectors[index].push(selector)
                        }
                    },
                    updateEventsCounter: function(element, event, value) {
                        if ([DRAG_ENTER_EVENT, DRAG_LEAVE_EVENT, DROP_EVENT].indexOf(event) > -1) {
                            var eventsCount = (0, _element_data.data)(element, "dxDragEventsCount") || 0;
                            (0, _element_data.data)(element, "dxDragEventsCount", Math.max(0, eventsCount + value))
                        }
                    },
                    remove: function(element, handleObj) {
                        this.updateEventsCounter(element, handleObj.type, -1)
                    },
                    teardown: function(element) {
                        var handlersCount = (0, _element_data.data)(element, "dxDragEventsCount");
                        if (!handlersCount) {
                            var index = knownDropTargets.indexOf(element);
                            knownDropTargets.splice(index, 1);
                            knownDropTargetSelectors.splice(index, 1);
                            knownDropTargetConfigs.splice(index, 1);
                            (0, _element_data.removeData)(element, "dxDragEventsCount")
                        }
                    }
                };
                (0, _event_registrator.default)(DRAG_ENTER_EVENT, dropTargetRegistration);
                (0, _event_registrator.default)(DRAG_LEAVE_EVENT, dropTargetRegistration);
                (0, _event_registrator.default)(DROP_EVENT, dropTargetRegistration);
                var DragEmitter = _emitter.default.inherit({
                    ctor: function(element) {
                        this.callBase(element);
                        this.direction = "both"
                    },
                    _init: function(e) {
                        this._initEvent = e
                    },
                    _start: function(e) {
                        e = this._fireEvent("dxdragstart", this._initEvent);
                        this._maxLeftOffset = e.maxLeftOffset;
                        this._maxRightOffset = e.maxRightOffset;
                        this._maxTopOffset = e.maxTopOffset;
                        this._maxBottomOffset = e.maxBottomOffset;
                        var dropTargets = (0, _array.wrapToArray)(e.targetElements || (null === e.targetElements ? [] : knownDropTargets));
                        this._dropTargets = iteratorUtils.map(dropTargets, (function(element) {
                            return (0, _renderer.default)(element).get(0)
                        }))
                    },
                    _move: function(e) {
                        var eventData = (0, _index.eventData)(e);
                        var dragOffset = this._calculateOffset(eventData);
                        e = this._fireEvent("dxdrag", e, {
                            offset: dragOffset
                        });
                        this._processDropTargets(e);
                        if (!e._cancelPreventDefault) {
                            e.preventDefault()
                        }
                    },
                    _calculateOffset: function(eventData) {
                        return {
                            x: this._calculateXOffset(eventData),
                            y: this._calculateYOffset(eventData)
                        }
                    },
                    _calculateXOffset: function(eventData) {
                        if ("vertical" !== this.direction) {
                            var offset = eventData.x - this._startEventData.x;
                            return this._fitOffset(offset, this._maxLeftOffset, this._maxRightOffset)
                        }
                        return 0
                    },
                    _calculateYOffset: function(eventData) {
                        if ("horizontal" !== this.direction) {
                            var offset = eventData.y - this._startEventData.y;
                            return this._fitOffset(offset, this._maxTopOffset, this._maxBottomOffset)
                        }
                        return 0
                    },
                    _fitOffset: function(offset, minOffset, maxOffset) {
                        if (null != minOffset) {
                            offset = Math.max(offset, -minOffset)
                        }
                        if (null != maxOffset) {
                            offset = Math.min(offset, maxOffset)
                        }
                        return offset
                    },
                    _processDropTargets: function(e) {
                        var target = this._findDropTarget(e);
                        var sameTarget = target === this._currentDropTarget;
                        if (!sameTarget) {
                            this._fireDropTargetEvent(e, DRAG_LEAVE_EVENT);
                            this._currentDropTarget = target;
                            this._fireDropTargetEvent(e, DRAG_ENTER_EVENT)
                        }
                    },
                    _fireDropTargetEvent: function(event, eventName) {
                        if (!this._currentDropTarget) {
                            return
                        }
                        var eventData = {
                            type: eventName,
                            originalEvent: event,
                            draggingElement: this._$element.get(0),
                            target: this._currentDropTarget
                        };
                        (0, _index.fireEvent)(eventData)
                    },
                    _findDropTarget: function(e) {
                        var that = this;
                        var result;
                        iteratorUtils.each(knownDropTargets, (function(_, target) {
                            if (!that._checkDropTargetActive(target)) {
                                return
                            }
                            var $target = (0, _renderer.default)(target);
                            iteratorUtils.each(function($element) {
                                var dropTargetIndex = knownDropTargets.indexOf($element.get(0));
                                var dropTargetSelectors = knownDropTargetSelectors[dropTargetIndex].filter((function(selector) {
                                    return selector
                                }));
                                var $delegatedTargets = $element.find(dropTargetSelectors.join(", "));
                                if (knownDropTargetSelectors[dropTargetIndex].includes(void 0)) {
                                    $delegatedTargets = $delegatedTargets.add($element)
                                }
                                return $delegatedTargets
                            }($target), (function(_, delegatedTarget) {
                                var $delegatedTarget = (0, _renderer.default)(delegatedTarget);
                                if (that._checkDropTarget(($element = $target, dropTargetIndex = knownDropTargets.indexOf($element.get(0)), knownDropTargetConfigs[dropTargetIndex]), $delegatedTarget, (0, _renderer.default)(result), e)) {
                                    result = delegatedTarget
                                }
                                var $element, dropTargetIndex
                            }))
                        }));
                        return result
                    },
                    _checkDropTargetActive: function(target) {
                        var active = false;
                        iteratorUtils.each(this._dropTargets, (function(_, activeTarget) {
                            active = active || activeTarget === target || (0, _dom.contains)(activeTarget, target);
                            return !active
                        }));
                        return active
                    },
                    _checkDropTarget: function(config, $target, $prevTarget, e) {
                        var isDraggingElement = $target.get(0) === (0, _renderer.default)(e.target).get(0);
                        if (isDraggingElement) {
                            return false
                        }
                        var targetPosition = function(dropTargetConfig, $element) {
                            if (dropTargetConfig.itemPositionFunc) {
                                return dropTargetConfig.itemPositionFunc($element)
                            } else {
                                return $element.offset()
                            }
                        }(config, $target);
                        if (e.pageX < targetPosition.left) {
                            return false
                        }
                        if (e.pageY < targetPosition.top) {
                            return false
                        }
                        var targetSize = function(dropTargetConfig, $element) {
                            if (dropTargetConfig.itemSizeFunc) {
                                return dropTargetConfig.itemSizeFunc($element)
                            }
                            return {
                                width: $element.get(0).getBoundingClientRect().width,
                                height: $element.get(0).getBoundingClientRect().height
                            }
                        }(config, $target);
                        if (e.pageX > targetPosition.left + targetSize.width) {
                            return false
                        }
                        if (e.pageY > targetPosition.top + targetSize.height) {
                            return false
                        }
                        if ($prevTarget.length && $prevTarget.closest($target).length) {
                            return false
                        }
                        if (config.checkDropTarget && !config.checkDropTarget($target, e)) {
                            return false
                        }
                        return $target
                    },
                    _end: function(e) {
                        var eventData = (0, _index.eventData)(e);
                        this._fireEvent("dxdragend", e, {
                            offset: this._calculateOffset(eventData)
                        });
                        this._fireDropTargetEvent(e, DROP_EVENT);
                        delete this._currentDropTarget
                    }
                });
                (0, _emitter_registrator.default)({
                    emitter: DragEmitter,
                    events: ["dxdragstart", "dxdrag", "dxdragend"]
                })
            },
        98621:
            /*!*******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/gesture/emitter.gesture.js ***!
              \*******************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 68374));
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 55994));
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../../core/devices */ 20530));
                var _style = __webpack_require__( /*! ../../core/utils/style */ 80968);
                var _call_once = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/call_once */ 39618));
                var _dom = __webpack_require__( /*! ../../core/utils/dom */ 3532);
                var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/ready_callbacks */ 24311));
                var _math = __webpack_require__( /*! ../../core/utils/math */ 60810);
                var _common = __webpack_require__( /*! ../../core/utils/common */ 20576);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 35922);
                var _index = __webpack_require__( /*! ../utils/index */ 39611);
                var _emitter = _interopRequireDefault(__webpack_require__( /*! ../core/emitter */ 31391));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var ready = _ready_callbacks.default.add;
                var abs = Math.abs;
                var TOUCH_BOUNDARY = 10;
                var setGestureCover = (0, _call_once.default)((function() {
                    var isDesktop = "desktop" === _devices.default.real().deviceType;
                    if (!(0, _style.styleProp)("pointer-events") || !isDesktop) {
                        return _common.noop
                    }
                    var $cover = (0, _renderer.default)("<div>").addClass("dx-gesture-cover").css("pointerEvents", "none");
                    _events_engine.default.subscribeGlobal($cover, "dxmousewheel", (function(e) {
                        e.preventDefault()
                    }));
                    ready((function() {
                        $cover.appendTo("body")
                    }));
                    return function(toggle, cursor) {
                        $cover.css("pointerEvents", toggle ? "all" : "none");
                        toggle && $cover.css("cursor", cursor)
                    }
                }));
                var GestureEmitter = _emitter.default.inherit({
                    gesture: true,
                    configure: function(data) {
                        this.getElement().css("msTouchAction", data.immediate ? "pinch-zoom" : "");
                        this.callBase(data)
                    },
                    allowInterruptionByMouseWheel: function() {
                        return 2 !== this._stage
                    },
                    getDirection: function() {
                        return this.direction
                    },
                    _cancel: function() {
                        this.callBase.apply(this, arguments);
                        this._toggleGestureCover(false);
                        this._stage = 0
                    },
                    start: function(e) {
                        if (e._needSkipEvent || (0, _index.needSkipEvent)(e)) {
                            this._cancel(e);
                            return
                        }
                        this._startEvent = (0, _index.createEvent)(e);
                        this._startEventData = (0, _index.eventData)(e);
                        this._stage = 1;
                        this._init(e);
                        this._setupImmediateTimer()
                    },
                    _setupImmediateTimer: function() {
                        clearTimeout(this._immediateTimer);
                        this._immediateAccepted = false;
                        if (!this.immediate) {
                            return
                        }
                        this._immediateTimer = setTimeout(function() {
                            this._immediateAccepted = true
                        }.bind(this), 180)
                    },
                    move: function(e) {
                        if (1 === this._stage && this._directionConfirmed(e)) {
                            this._stage = 2;
                            this._resetActiveElement();
                            this._toggleGestureCover(true);
                            this._clearSelection(e);
                            this._adjustStartEvent(e);
                            this._start(this._startEvent);
                            if (0 === this._stage) {
                                return
                            }
                            this._requestAccept(e);
                            this._move(e);
                            this._forgetAccept()
                        } else if (2 === this._stage) {
                            this._clearSelection(e);
                            this._move(e)
                        }
                    },
                    _directionConfirmed: function(e) {
                        var touchBoundary = this._getTouchBoundary(e);
                        var delta = (0, _index.eventDelta)(this._startEventData, (0, _index.eventData)(e));
                        var deltaX = abs(delta.x);
                        var deltaY = abs(delta.y);
                        var horizontalMove = this._validateMove(touchBoundary, deltaX, deltaY);
                        var verticalMove = this._validateMove(touchBoundary, deltaY, deltaX);
                        var direction = this.getDirection(e);
                        var bothAccepted = "both" === direction && (horizontalMove || verticalMove);
                        var horizontalAccepted = "horizontal" === direction && horizontalMove;
                        var verticalAccepted = "vertical" === direction && verticalMove;
                        return bothAccepted || horizontalAccepted || verticalAccepted || this._immediateAccepted
                    },
                    _validateMove: function(touchBoundary, mainAxis, crossAxis) {
                        return mainAxis && mainAxis >= touchBoundary && (this.immediate ? mainAxis >= crossAxis : true)
                    },
                    _getTouchBoundary: function(e) {
                        return this.immediate || (0, _index.isDxMouseWheelEvent)(e) ? 0 : TOUCH_BOUNDARY
                    },
                    _adjustStartEvent: function(e) {
                        var touchBoundary = this._getTouchBoundary(e);
                        var delta = (0, _index.eventDelta)(this._startEventData, (0, _index.eventData)(e));
                        this._startEvent.pageX += (0, _math.sign)(delta.x) * touchBoundary;
                        this._startEvent.pageY += (0, _math.sign)(delta.y) * touchBoundary
                    },
                    _resetActiveElement: function() {
                        if ("ios" === _devices.default.real().platform && this.getElement().find(":focus").length) {
                            (0, _dom.resetActiveElement)()
                        }
                    },
                    _toggleGestureCover: function(toggle) {
                        this._toggleGestureCoverImpl(toggle)
                    },
                    _toggleGestureCoverImpl: function(toggle) {
                        var isStarted = 2 === this._stage;
                        if (isStarted) {
                            ! function(toggle, cursor) {
                                var gestureCoverStrategy = setGestureCover();
                                gestureCoverStrategy(toggle, cursor)
                            }(toggle, this.getElement().css("cursor"))
                        }
                    },
                    _clearSelection: function(e) {
                        if ((0, _index.isDxMouseWheelEvent)(e) || (0, _index.isTouchEvent)(e)) {
                            return
                        }(0, _dom.clearSelection)()
                    },
                    end: function(e) {
                        this._toggleGestureCover(false);
                        if (2 === this._stage) {
                            this._end(e)
                        } else if (1 === this._stage) {
                            this._stop(e)
                        }
                        this._stage = 0
                    },
                    dispose: function() {
                        clearTimeout(this._immediateTimer);
                        this.callBase.apply(this, arguments);
                        this._toggleGestureCover(false)
                    },
                    _init: _common.noop,
                    _start: _common.noop,
                    _move: _common.noop,
                    _stop: _common.noop,
                    _end: _common.noop
                });
                GestureEmitter.initialTouchBoundary = TOUCH_BOUNDARY;
                GestureEmitter.touchBoundary = function(newBoundary) {
                    if ((0, _type.isDefined)(newBoundary)) {
                        TOUCH_BOUNDARY = newBoundary;
                        return
                    }
                    return TOUCH_BOUNDARY
                };
                var _default = GestureEmitter;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        37334:
            /*!**************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/gesture/emitter.gesture.scroll.js ***!
              \**************************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 55994));
                var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 38377));
                var _index = __webpack_require__( /*! ../../events/utils/index */ 39611);
                var _emitter = _interopRequireDefault(__webpack_require__( /*! ../../events/gesture/emitter.gesture */ 98621));
                var _emitter_registrator = _interopRequireDefault(__webpack_require__( /*! ../../events/core/emitter_registrator */ 82495));
                var _frame = __webpack_require__( /*! ../../animation/frame */ 90057);
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../../core/devices */ 20530));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var abstract = _class.default.abstract;
                var realDevice = _devices.default.real();
                var Locker = _class.default.inherit((NAMESPACED_SCROLL_EVENT = (0, _index.addNamespace)("scroll", "dxScrollEmitter"), {
                    ctor: function(element) {
                        var _this = this;
                        this._element = element;
                        this._locked = false;
                        this._proxiedScroll = function(e) {
                            if (!_this._disposed) {
                                _this._scroll(e)
                            }
                        };
                        _events_engine.default.on(this._element, NAMESPACED_SCROLL_EVENT, this._proxiedScroll)
                    },
                    _scroll: abstract,
                    check: function(e, callback) {
                        if (this._locked) {
                            callback()
                        }
                    },
                    dispose: function() {
                        this._disposed = true;
                        _events_engine.default.off(this._element, NAMESPACED_SCROLL_EVENT, this._proxiedScroll)
                    }
                }));
                var NAMESPACED_SCROLL_EVENT;
                var TimeoutLocker = Locker.inherit({
                    ctor: function(element, timeout) {
                        this.callBase(element);
                        this._timeout = timeout
                    },
                    _scroll: function() {
                        this._prepare();
                        this._forget()
                    },
                    _prepare: function() {
                        if (this._timer) {
                            this._clearTimer()
                        }
                        this._locked = true
                    },
                    _clearTimer: function() {
                        clearTimeout(this._timer);
                        this._locked = false;
                        this._timer = null
                    },
                    _forget: function() {
                        var that = this;
                        this._timer = setTimeout((function() {
                            that._clearTimer()
                        }), this._timeout)
                    },
                    dispose: function() {
                        this.callBase();
                        this._clearTimer()
                    }
                });
                var WheelLocker = TimeoutLocker.inherit({
                    ctor: function(element) {
                        this.callBase(element, 400);
                        this._lastWheelDirection = null
                    },
                    check: function(e, callback) {
                        this._checkDirectionChanged(e);
                        this.callBase(e, callback)
                    },
                    _checkDirectionChanged: function(e) {
                        if (!(0, _index.isDxMouseWheelEvent)(e)) {
                            this._lastWheelDirection = null;
                            return
                        }
                        var direction = e.shiftKey || false;
                        var directionChange = null !== this._lastWheelDirection && direction !== this._lastWheelDirection;
                        this._lastWheelDirection = direction;
                        this._locked = this._locked && !directionChange
                    }
                });
                var PointerLocker = TimeoutLocker.inherit({
                    ctor: function(element) {
                        this.callBase(element, 400)
                    }
                });
                ! function() {
                    var isIos = realDevice.ios,
                        isAndroid = realDevice.android;
                    if (!(isIos || isAndroid)) {
                        return
                    }
                    PointerLocker = Locker.inherit({
                        _scroll: function() {
                            this._locked = true;
                            var that = this;
                            (0, _frame.cancelAnimationFrame)(this._scrollFrame);
                            this._scrollFrame = (0, _frame.requestAnimationFrame)((function() {
                                that._locked = false
                            }))
                        },
                        check: function(e, callback) {
                            (0, _frame.cancelAnimationFrame)(this._scrollFrame);
                            (0, _frame.cancelAnimationFrame)(this._checkFrame);
                            var that = this;
                            var callBase = this.callBase;
                            this._checkFrame = (0, _frame.requestAnimationFrame)((function() {
                                callBase.call(that, e, callback);
                                that._locked = false
                            }))
                        },
                        dispose: function() {
                            this.callBase();
                            (0, _frame.cancelAnimationFrame)(this._scrollFrame);
                            (0, _frame.cancelAnimationFrame)(this._checkFrame)
                        }
                    })
                }();
                var ScrollEmitter = _emitter.default.inherit((FRAME_DURATION = Math.round(1e3 / 60), {
                    ctor: function(element) {
                        this.callBase.apply(this, arguments);
                        this.direction = "both";
                        this._pointerLocker = new PointerLocker(element);
                        this._wheelLocker = new WheelLocker(element)
                    },
                    validate: function() {
                        return true
                    },
                    configure: function(data) {
                        if (data.scrollTarget) {
                            this._pointerLocker.dispose();
                            this._wheelLocker.dispose();
                            this._pointerLocker = new PointerLocker(data.scrollTarget);
                            this._wheelLocker = new WheelLocker(data.scrollTarget)
                        }
                        this.callBase(data)
                    },
                    _init: function(e) {
                        this._wheelLocker.check(e, function() {
                            if ((0, _index.isDxMouseWheelEvent)(e)) {
                                this._accept(e)
                            }
                        }.bind(this));
                        this._pointerLocker.check(e, function() {
                            var skipCheck = this.isNative && (0, _index.isMouseEvent)(e);
                            if (!(0, _index.isDxMouseWheelEvent)(e) && !skipCheck) {
                                this._accept(e)
                            }
                        }.bind(this));
                        this._fireEvent("dxscrollinit", e);
                        this._prevEventData = (0, _index.eventData)(e)
                    },
                    move: function(e) {
                        this.callBase.apply(this, arguments);
                        e.isScrollingEvent = this.isNative || e.isScrollingEvent
                    },
                    _start: function(e) {
                        this._savedEventData = (0, _index.eventData)(e);
                        this._fireEvent("dxscrollstart", e);
                        this._prevEventData = (0, _index.eventData)(e)
                    },
                    _move: function(e) {
                        var currentEventData = (0, _index.eventData)(e);
                        this._fireEvent("dxscroll", e, {
                            delta: (0, _index.eventDelta)(this._prevEventData, currentEventData)
                        });
                        var delta = (0, _index.eventDelta)(this._savedEventData, currentEventData);
                        if (delta.time > 200) {
                            this._savedEventData = this._prevEventData
                        }
                        this._prevEventData = (0, _index.eventData)(e)
                    },
                    _end: function(e) {
                        var endEventDelta = (0, _index.eventDelta)(this._prevEventData, (0, _index.eventData)(e));
                        var velocity = {
                            x: 0,
                            y: 0
                        };
                        if (!(0, _index.isDxMouseWheelEvent)(e) && endEventDelta.time < 100) {
                            var delta = (0, _index.eventDelta)(this._savedEventData, this._prevEventData);
                            var velocityMultiplier = FRAME_DURATION / delta.time;
                            velocity = {
                                x: delta.x * velocityMultiplier,
                                y: delta.y * velocityMultiplier
                            }
                        }
                        this._fireEvent("dxscrollend", e, {
                            velocity: velocity
                        })
                    },
                    _stop: function(e) {
                        this._fireEvent("dxscrollstop", e)
                    },
                    cancel: function(e) {
                        this.callBase.apply(this, arguments);
                        this._fireEvent("dxscrollcancel", e)
                    },
                    dispose: function() {
                        this.callBase.apply(this, arguments);
                        this._pointerLocker.dispose();
                        this._wheelLocker.dispose()
                    },
                    _clearSelection: function() {
                        if (this.isNative) {
                            return
                        }
                        return this.callBase.apply(this, arguments)
                    },
                    _toggleGestureCover: function() {
                        if (this.isNative) {
                            return
                        }
                        return this.callBase.apply(this, arguments)
                    }
                }));
                var FRAME_DURATION;
                (0, _emitter_registrator.default)({
                    emitter: ScrollEmitter,
                    events: ["dxscrollinit", "dxscrollstart", "dxscroll", "dxscrollend", "dxscrollstop", "dxscrollcancel"]
                });
                var _default = {
                    init: "dxscrollinit",
                    start: "dxscrollstart",
                    move: "dxscroll",
                    end: "dxscrollend",
                    stop: "dxscrollstop",
                    cancel: "dxscrollcancel",
                    scroll: "scroll"
                };
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        66894:
            /*!*************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/gesture/swipeable.js ***!
              \*************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _swipe = __webpack_require__( /*! ../swipe */ 34309);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 55994));
                var _dom_component = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_component */ 13046));
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 95479);
                var _index = __webpack_require__( /*! ../utils/index */ 39611);
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _public_component = __webpack_require__( /*! ../../core/utils/public_component */ 9321);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var ACTION_TO_EVENT_MAP = {
                    onStart: _swipe.start,
                    onUpdated: _swipe.swipe,
                    onEnd: _swipe.end,
                    onCancel: "dxswipecancel"
                };
                var Swipeable = _dom_component.default.inherit({
                    _getDefaultOptions: function() {
                        return (0, _extend.extend)(this.callBase(), {
                            elastic: true,
                            immediate: false,
                            direction: "horizontal",
                            itemSizeFunc: null,
                            onStart: null,
                            onUpdated: null,
                            onEnd: null,
                            onCancel: null
                        })
                    },
                    _render: function() {
                        this.callBase();
                        this.$element().addClass("dx-swipeable");
                        this._attachEventHandlers()
                    },
                    _attachEventHandlers: function() {
                        this._detachEventHandlers();
                        if (this.option("disabled")) {
                            return
                        }
                        var NAME = this.NAME;
                        this._createEventData();
                        (0, _iterator.each)(ACTION_TO_EVENT_MAP, function(actionName, eventName) {
                            var action = this._createActionByOption(actionName, {
                                context: this
                            });
                            eventName = (0, _index.addNamespace)(eventName, NAME);
                            _events_engine.default.on(this.$element(), eventName, this._eventData, (function(e) {
                                return action({
                                    event: e
                                })
                            }))
                        }.bind(this))
                    },
                    _createEventData: function() {
                        this._eventData = {
                            elastic: this.option("elastic"),
                            itemSizeFunc: this.option("itemSizeFunc"),
                            direction: this.option("direction"),
                            immediate: this.option("immediate")
                        }
                    },
                    _detachEventHandlers: function() {
                        _events_engine.default.off(this.$element(), ".dxSwipeable")
                    },
                    _optionChanged: function(args) {
                        switch (args.name) {
                            case "disabled":
                            case "onStart":
                            case "onUpdated":
                            case "onEnd":
                            case "onCancel":
                            case "elastic":
                            case "immediate":
                            case "itemSizeFunc":
                            case "direction":
                                this._detachEventHandlers();
                                this._attachEventHandlers();
                                break;
                            case "rtlEnabled":
                                break;
                            default:
                                this.callBase(args)
                        }
                    },
                    _useTemplates: function() {
                        return false
                    }
                });
                (0, _public_component.name)(Swipeable, "dxSwipeable");
                var _default = Swipeable;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        11699:
            /*!************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/hold.js ***!
              \************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _index = __webpack_require__( /*! ./utils/index */ 39611);
                var _emitter = _interopRequireDefault(__webpack_require__( /*! ./core/emitter */ 31391));
                var _emitter_registrator = _interopRequireDefault(__webpack_require__( /*! ./core/emitter_registrator */ 82495));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var abs = Math.abs;
                var HoldEmitter = _emitter.default.inherit({
                    start: function(e) {
                        this._startEventData = (0, _index.eventData)(e);
                        this._startTimer(e)
                    },
                    _startTimer: function(e) {
                        var holdTimeout = "timeout" in this ? this.timeout : 750;
                        this._holdTimer = setTimeout(function() {
                            this._requestAccept(e);
                            this._fireEvent("dxhold", e, {
                                target: e.target
                            });
                            this._forgetAccept()
                        }.bind(this), holdTimeout)
                    },
                    move: function(e) {
                        if (this._touchWasMoved(e)) {
                            this._cancel(e)
                        }
                    },
                    _touchWasMoved: function(e) {
                        var delta = (0, _index.eventDelta)(this._startEventData, (0, _index.eventData)(e));
                        return abs(delta.x) > 5 || abs(delta.y) > 5
                    },
                    end: function() {
                        this._stopTimer()
                    },
                    _stopTimer: function() {
                        clearTimeout(this._holdTimer)
                    },
                    cancel: function() {
                        this._stopTimer()
                    },
                    dispose: function() {
                        this._stopTimer()
                    }
                });
                (0, _emitter_registrator.default)({
                    emitter: HoldEmitter,
                    bubble: true,
                    events: ["dxhold"]
                });
                var _default = {
                    name: "dxhold"
                };
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        24028:
            /*!*************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/hover.js ***!
              \*************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.start = exports.end = void 0;
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../events/core/events_engine */ 55994));
                var _element_data = __webpack_require__( /*! ../core/element_data */ 97906);
                var _class = _interopRequireDefault(__webpack_require__( /*! ../core/class */ 38377));
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../core/devices */ 20530));
                var _event_registrator = _interopRequireDefault(__webpack_require__( /*! ./core/event_registrator */ 85788));
                var _index = __webpack_require__( /*! ./utils/index */ 39611);
                var _pointer = _interopRequireDefault(__webpack_require__( /*! ./pointer */ 93786));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                exports.start = "dxhoverstart";
                var POINTERENTER_NAMESPACED_EVENT_NAME = (0, _index.addNamespace)(_pointer.default.enter, "dxHoverStart");
                exports.end = "dxhoverend";
                var POINTERLEAVE_NAMESPACED_EVENT_NAME = (0, _index.addNamespace)(_pointer.default.leave, "dxHoverEnd");
                var Hover = _class.default.inherit({
                    noBubble: true,
                    ctor: function() {
                        this._handlerArrayKeyPath = this._eventNamespace + "_HandlerStore"
                    },
                    setup: function(element) {
                        (0, _element_data.data)(element, this._handlerArrayKeyPath, {})
                    },
                    add: function(element, handleObj) {
                        var that = this;
                        var handler = function(e) {
                            that._handler(e)
                        };
                        _events_engine.default.on(element, this._originalEventName, handleObj.selector, handler);
                        (0, _element_data.data)(element, this._handlerArrayKeyPath)[handleObj.guid] = handler
                    },
                    _handler: function(e) {
                        if ((0, _index.isTouchEvent)(e) || _devices.default.isSimulator()) {
                            return
                        }(0, _index.fireEvent)({
                            type: this._eventName,
                            originalEvent: e,
                            delegateTarget: e.delegateTarget
                        })
                    },
                    remove: function(element, handleObj) {
                        var handler = (0, _element_data.data)(element, this._handlerArrayKeyPath)[handleObj.guid];
                        _events_engine.default.off(element, this._originalEventName, handleObj.selector, handler)
                    },
                    teardown: function(element) {
                        (0, _element_data.removeData)(element, this._handlerArrayKeyPath)
                    }
                });
                var HoverStart = Hover.inherit({
                    ctor: function() {
                        this._eventNamespace = "dxHoverStart";
                        this._eventName = "dxhoverstart";
                        this._originalEventName = POINTERENTER_NAMESPACED_EVENT_NAME;
                        this.callBase()
                    },
                    _handler: function(e) {
                        var pointers = e.pointers || [];
                        if (!pointers.length) {
                            this.callBase(e)
                        }
                    }
                });
                var HoverEnd = Hover.inherit({
                    ctor: function() {
                        this._eventNamespace = "dxHoverEnd";
                        this._eventName = "dxhoverend";
                        this._originalEventName = POINTERLEAVE_NAMESPACED_EVENT_NAME;
                        this.callBase()
                    }
                });
                (0, _event_registrator.default)("dxhoverstart", new HoverStart);
                (0, _event_registrator.default)("dxhoverend", new HoverEnd)
            },
        66365:
            /*!*************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/index.js ***!
              \*************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.triggerHandler = exports.trigger = exports.one = exports.on = exports.off = exports.Event = void 0;
                var _events_engine = (obj = __webpack_require__( /*! ./core/events_engine */ 55994), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var on = _events_engine.default.on;
                exports.on = on;
                var one = _events_engine.default.one;
                exports.one = one;
                var off = _events_engine.default.off;
                exports.off = off;
                var trigger = _events_engine.default.trigger;
                exports.trigger = trigger;
                var triggerHandler = _events_engine.default.triggerHandler;
                exports.triggerHandler = triggerHandler;
                var Event = _events_engine.default.Event;
                exports.Event = Event
            },
        93786:
            /*!***************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/pointer.js ***!
              \***************************************************************/
            function(module, exports, __webpack_require__) {
                function _typeof(obj) {
                    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj) {
                        return typeof obj
                    } : function(obj) {
                        return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj
                    }, _typeof(obj)
                }
                exports.default = void 0;
                var support = function(obj, nodeInterop) {
                    if (!nodeInterop && obj && obj.__esModule) {
                        return obj
                    }
                    if (null === obj || "object" !== _typeof(obj) && "function" !== typeof obj) {
                        return {
                            default: obj
                        }
                    }
                    var cache = _getRequireWildcardCache(nodeInterop);
                    if (cache && cache.has(obj)) {
                        return cache.get(obj)
                    }
                    var newObj = {};
                    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
                    for (var key in obj) {
                        if ("default" !== key && Object.prototype.hasOwnProperty.call(obj, key)) {
                            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
                            if (desc && (desc.get || desc.set)) {
                                Object.defineProperty(newObj, key, desc)
                            } else {
                                newObj[key] = obj[key]
                            }
                        }
                    }
                    newObj.default = obj;
                    if (cache) {
                        cache.set(obj, newObj)
                    }
                    return newObj
                }(__webpack_require__( /*! ../core/utils/support */ 60137));
                var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 95479);
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../core/devices */ 20530));
                var _event_registrator = _interopRequireDefault(__webpack_require__( /*! ./core/event_registrator */ 85788));
                var _touch = _interopRequireDefault(__webpack_require__( /*! ./pointer/touch */ 69120));
                var _mouse = _interopRequireDefault(__webpack_require__( /*! ./pointer/mouse */ 66509));
                var _mouse_and_touch = _interopRequireDefault(__webpack_require__( /*! ./pointer/mouse_and_touch */ 87720));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _getRequireWildcardCache(nodeInterop) {
                    if ("function" !== typeof WeakMap) {
                        return null
                    }
                    var cacheBabelInterop = new WeakMap;
                    var cacheNodeInterop = new WeakMap;
                    return (_getRequireWildcardCache = function(nodeInterop) {
                        return nodeInterop ? cacheNodeInterop : cacheBabelInterop
                    })(nodeInterop)
                }
                var EventStrategy = function(support, device) {
                    var tablet = device.tablet,
                        phone = device.phone;
                    if (support.touch && !(tablet || phone)) {
                        return _mouse_and_touch.default
                    }
                    if (support.touch) {
                        return _touch.default
                    }
                    return _mouse.default
                }(support, _devices.default.real());
                (0, _iterator.each)(EventStrategy.map, (function(pointerEvent, originalEvents) {
                    (0, _event_registrator.default)(pointerEvent, new EventStrategy(pointerEvent, originalEvents))
                }));
                var _default = {
                    down: "dxpointerdown",
                    up: "dxpointerup",
                    move: "dxpointermove",
                    cancel: "dxpointercancel",
                    enter: "dxpointerenter",
                    leave: "dxpointerleave",
                    over: "dxpointerover",
                    out: "dxpointerout"
                };
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        88136:
            /*!********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/pointer/base.js ***!
              \********************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 55994));
                var _browser = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/browser */ 47810));
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 73349));
                var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 38377));
                var _index = __webpack_require__( /*! ../utils/index */ 39611);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var BaseStrategy = _class.default.inherit({
                    ctor: function(eventName, originalEvents) {
                        this._eventName = eventName;
                        this._originalEvents = (0, _index.addNamespace)(originalEvents, "dxPointerEvents");
                        this._handlerCount = 0;
                        this.noBubble = this._isNoBubble()
                    },
                    _isNoBubble: function() {
                        var eventName = this._eventName;
                        return "dxpointerenter" === eventName || "dxpointerleave" === eventName
                    },
                    _handler: function(e) {
                        var delegateTarget = this._getDelegateTarget(e);
                        var event = {
                            type: this._eventName,
                            pointerType: e.pointerType || (0, _index.eventSource)(e),
                            originalEvent: e,
                            delegateTarget: delegateTarget,
                            timeStamp: _browser.default.mozilla ? (new Date).getTime() : e.timeStamp
                        };
                        var originalEvent = e.originalEvent;
                        if (null !== originalEvent && void 0 !== originalEvent && originalEvent.target.shadowRoot) {
                            var _originalEvent$path, _originalEvent$compos;
                            var path = null !== (_originalEvent$path = originalEvent.path) && void 0 !== _originalEvent$path ? _originalEvent$path : null === (_originalEvent$compos = originalEvent.composedPath) || void 0 === _originalEvent$compos ? void 0 : _originalEvent$compos.call(originalEvent);
                            event.target = path[0]
                        }
                        return this._fireEvent(event)
                    },
                    _getDelegateTarget: function(e) {
                        var delegateTarget;
                        if (this.noBubble) {
                            delegateTarget = e.delegateTarget
                        }
                        return delegateTarget
                    },
                    _fireEvent: function(args) {
                        return (0, _index.fireEvent)(args)
                    },
                    _setSelector: function(handleObj) {
                        this._selector = this.noBubble && handleObj ? handleObj.selector : null
                    },
                    _getSelector: function() {
                        return this._selector
                    },
                    setup: function() {
                        return true
                    },
                    add: function(element, handleObj) {
                        if (this._handlerCount <= 0 || this.noBubble) {
                            element = this.noBubble ? element : _dom_adapter.default.getDocument();
                            this._setSelector(handleObj);
                            var that = this;
                            _events_engine.default.on(element, this._originalEvents, this._getSelector(), (function(e) {
                                that._handler(e)
                            }))
                        }
                        if (!this.noBubble) {
                            this._handlerCount++
                        }
                    },
                    remove: function(handleObj) {
                        this._setSelector(handleObj);
                        if (!this.noBubble) {
                            this._handlerCount--
                        }
                    },
                    teardown: function(element) {
                        if (this._handlerCount && !this.noBubble) {
                            return
                        }
                        element = this.noBubble ? element : _dom_adapter.default.getDocument();
                        if (".dxPointerEvents" !== this._originalEvents) {
                            _events_engine.default.off(element, this._originalEvents, this._getSelector())
                        }
                    },
                    dispose: function(element) {
                        element = this.noBubble ? element : _dom_adapter.default.getDocument();
                        _events_engine.default.off(element, this._originalEvents)
                    }
                });
                var _default = BaseStrategy;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        66509:
            /*!*********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/pointer/mouse.js ***!
              \*********************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _base = _interopRequireDefault(__webpack_require__( /*! ./base */ 88136));
                var _observer = _interopRequireDefault(__webpack_require__( /*! ./observer */ 25544));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var eventMap = {
                    dxpointerdown: "mousedown",
                    dxpointermove: "mousemove",
                    dxpointerup: "mouseup",
                    dxpointercancel: "",
                    dxpointerover: "mouseover",
                    dxpointerout: "mouseout",
                    dxpointerenter: "mouseenter",
                    dxpointerleave: "mouseleave"
                };
                var normalizeMouseEvent = function(e) {
                    e.pointerId = 1;
                    return {
                        pointers: observer.pointers(),
                        pointerId: 1
                    }
                };
                var observer;
                var activated = false;
                var activateStrategy = function() {
                    if (activated) {
                        return
                    }
                    observer = new _observer.default(eventMap, (function() {
                        return true
                    }));
                    activated = true
                };
                var MouseStrategy = _base.default.inherit({
                    ctor: function() {
                        this.callBase.apply(this, arguments);
                        activateStrategy()
                    },
                    _fireEvent: function(args) {
                        return this.callBase((0, _extend.extend)(normalizeMouseEvent(args.originalEvent), args))
                    }
                });
                MouseStrategy.map = eventMap;
                MouseStrategy.normalize = normalizeMouseEvent;
                MouseStrategy.activate = activateStrategy;
                MouseStrategy.resetObserver = function() {
                    observer.reset()
                };
                var _default = MouseStrategy;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        87720:
            /*!*******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/pointer/mouse_and_touch.js ***!
              \*******************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _base = _interopRequireDefault(__webpack_require__( /*! ./base */ 88136));
                var _mouse = _interopRequireDefault(__webpack_require__( /*! ./mouse */ 66509));
                var _touch = _interopRequireDefault(__webpack_require__( /*! ./touch */ 69120));
                var _index = __webpack_require__( /*! ../utils/index */ 39611);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var activated = false;
                var activateStrategy = function() {
                    if (activated) {
                        return
                    }
                    _mouse.default.activate();
                    activated = true
                };
                var MouseAndTouchStrategy = _base.default.inherit({
                    EVENT_LOCK_TIMEOUT: 100,
                    ctor: function() {
                        this.callBase.apply(this, arguments);
                        activateStrategy()
                    },
                    _handler: function(e) {
                        var isMouse = (0, _index.isMouseEvent)(e);
                        if (!isMouse) {
                            this._skipNextEvents = true
                        }
                        if (isMouse && this._mouseLocked) {
                            return
                        }
                        if (isMouse && this._skipNextEvents) {
                            this._skipNextEvents = false;
                            this._mouseLocked = true;
                            clearTimeout(this._unlockMouseTimer);
                            var that = this;
                            this._unlockMouseTimer = setTimeout((function() {
                                that._mouseLocked = false
                            }), this.EVENT_LOCK_TIMEOUT);
                            return
                        }
                        return this.callBase(e)
                    },
                    _fireEvent: function(args) {
                        var normalizer = (0, _index.isMouseEvent)(args.originalEvent) ? _mouse.default.normalize : _touch.default.normalize;
                        return this.callBase((0, _extend.extend)(normalizer(args.originalEvent), args))
                    },
                    dispose: function() {
                        this.callBase();
                        this._skipNextEvents = false;
                        this._mouseLocked = false;
                        clearTimeout(this._unlockMouseTimer)
                    }
                });
                MouseAndTouchStrategy.map = {
                    dxpointerdown: "touchstart mousedown",
                    dxpointermove: "touchmove mousemove",
                    dxpointerup: "touchend mouseup",
                    dxpointercancel: "touchcancel",
                    dxpointerover: "mouseover",
                    dxpointerout: "mouseout",
                    dxpointerenter: "mouseenter",
                    dxpointerleave: "mouseleave"
                };
                MouseAndTouchStrategy.resetObserver = _mouse.default.resetObserver;
                var _default = MouseAndTouchStrategy;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        25544:
            /*!************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/pointer/observer.js ***!
              \************************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 95479);
                var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/ready_callbacks */ 24311));
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 73349));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var addEventsListener = function(events, handler) {
                    _ready_callbacks.default.add((function() {
                        events.split(" ").forEach((function(event) {
                            _dom_adapter.default.listen(_dom_adapter.default.getDocument(), event, handler, true)
                        }))
                    }))
                };
                var _default = function(eventMap, pointerEquals, onPointerAdding) {
                    onPointerAdding = onPointerAdding || function() {};
                    var pointers = [];
                    var getPointerIndex = function(e) {
                        var index = -1;
                        (0, _iterator.each)(pointers, (function(i, pointer) {
                            if (!pointerEquals(e, pointer)) {
                                return true
                            }
                            index = i;
                            return false
                        }));
                        return index
                    };
                    var removePointer = function(e) {
                        var index = getPointerIndex(e);
                        if (index > -1) {
                            pointers.splice(index, 1)
                        }
                    };
                    addEventsListener(eventMap.dxpointerdown, (function(e) {
                        if (-1 === getPointerIndex(e)) {
                            onPointerAdding(e);
                            pointers.push(e)
                        }
                    }));
                    addEventsListener(eventMap.dxpointermove, (function(e) {
                        pointers[getPointerIndex(e)] = e
                    }));
                    addEventsListener(eventMap.dxpointerup, removePointer);
                    addEventsListener(eventMap.dxpointercancel, removePointer);
                    this.pointers = function() {
                        return pointers
                    };
                    this.reset = function() {
                        pointers = []
                    }
                };
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        69120:
            /*!*********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/pointer/touch.js ***!
              \*********************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../../core/devices */ 20530));
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 95479);
                var _base = _interopRequireDefault(__webpack_require__( /*! ./base */ 88136));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                var normalizeTouchEvent = function(e) {
                    var pointers = [];
                    (0, _iterator.each)(e.touches, (function(_, touch) {
                        pointers.push((0, _extend.extend)({
                            pointerId: touch.identifier
                        }, touch))
                    }));
                    return {
                        pointers: pointers,
                        pointerId: e.changedTouches[0].identifier
                    }
                };
                var skipTouchWithSameIdentifier = function(pointerEvent) {
                    return "ios" === _devices.default.real().platform && ("dxpointerdown" === pointerEvent || "dxpointerup" === pointerEvent)
                };
                var TouchStrategy = _base.default.inherit({
                    ctor: function() {
                        this.callBase.apply(this, arguments);
                        this._pointerId = 0
                    },
                    _handler: function(e) {
                        if (skipTouchWithSameIdentifier(this._eventName)) {
                            var touch = e.changedTouches[0];
                            if (this._pointerId === touch.identifier && 0 !== this._pointerId) {
                                return
                            }
                            this._pointerId = touch.identifier
                        }
                        return this.callBase.apply(this, arguments)
                    },
                    _fireEvent: function(args) {
                        return this.callBase((0, _extend.extend)(normalizeTouchEvent(args.originalEvent), args))
                    }
                });
                TouchStrategy.map = {
                    dxpointerdown: "touchstart",
                    dxpointermove: "touchmove",
                    dxpointerup: "touchend",
                    dxpointercancel: "touchcancel",
                    dxpointerover: "",
                    dxpointerout: "",
                    dxpointerenter: "",
                    dxpointerleave: ""
                };
                TouchStrategy.normalize = normalizeTouchEvent;
                var _default = TouchStrategy;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        29007:
            /*!**************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/remove.js ***!
              \**************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.removeEvent = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 68374));
                var _element_data = __webpack_require__( /*! ../core/element_data */ 97906);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ./core/events_engine */ 55994));
                var _event_registrator = _interopRequireDefault(__webpack_require__( /*! ./core/event_registrator */ 85788));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                exports.removeEvent = "dxremove";
                (0, _element_data.beforeCleanData)((function(elements) {
                    elements = [].slice.call(elements);
                    for (var i = 0; i < elements.length; i++) {
                        var $element = (0, _renderer.default)(elements[i]);
                        if ($element.prop("dxRemoveEvent")) {
                            $element[0].dxRemoveEvent = null;
                            _events_engine.default.triggerHandler($element, "dxremove")
                        }
                    }
                }));
                (0, _event_registrator.default)("dxremove", {
                    noBubble: true,
                    setup: function(element) {
                        (0, _renderer.default)(element).prop("dxRemoveEvent", true)
                    }
                })
            },
        72918:
            /*!*************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/short.js ***!
              \*************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.visibility = exports.resize = exports.keyboard = exports.hover = exports.focus = exports.dxClick = exports.click = exports.active = void 0;
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ./core/events_engine */ 55994));
                var _keyboard_processor = _interopRequireDefault(__webpack_require__( /*! ./core/keyboard_processor */ 51661));
                var _index = __webpack_require__( /*! ./utils/index */ 39611);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function addNamespace(event, namespace) {
                    return namespace ? (0, _index.addNamespace)(event, namespace) : event
                }

                function executeAction(action, args) {
                    return "function" === typeof action ? action(args) : action.execute(args)
                }
                var active = {
                    on: function($el, active, inactive, opts) {
                        var selector = opts.selector,
                            showTimeout = opts.showTimeout,
                            hideTimeout = opts.hideTimeout,
                            namespace = opts.namespace;
                        _events_engine.default.on($el, addNamespace("dxactive", namespace), selector, {
                            timeout: showTimeout
                        }, (function(event) {
                            return executeAction(active, {
                                event: event,
                                element: event.currentTarget
                            })
                        }));
                        _events_engine.default.on($el, addNamespace("dxinactive", namespace), selector, {
                            timeout: hideTimeout
                        }, (function(event) {
                            return executeAction(inactive, {
                                event: event,
                                element: event.currentTarget
                            })
                        }))
                    },
                    off: function($el, _ref) {
                        var namespace = _ref.namespace,
                            selector = _ref.selector;
                        _events_engine.default.off($el, addNamespace("dxactive", namespace), selector);
                        _events_engine.default.off($el, addNamespace("dxinactive", namespace), selector)
                    }
                };
                exports.active = active;
                var resize = {
                    on: function($el, resize) {
                        var _ref2 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                            namespace = _ref2.namespace;
                        _events_engine.default.on($el, addNamespace("dxresize", namespace), resize)
                    },
                    off: function($el) {
                        var _ref3 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
                            namespace = _ref3.namespace;
                        _events_engine.default.off($el, addNamespace("dxresize", namespace))
                    }
                };
                exports.resize = resize;
                var hover = {
                    on: function($el, start, end, _ref4) {
                        var selector = _ref4.selector,
                            namespace = _ref4.namespace;
                        _events_engine.default.on($el, addNamespace("dxhoverend", namespace), selector, (function(event) {
                            return end(event)
                        }));
                        _events_engine.default.on($el, addNamespace("dxhoverstart", namespace), selector, (function(event) {
                            return executeAction(start, {
                                element: event.target,
                                event: event
                            })
                        }))
                    },
                    off: function($el, _ref5) {
                        var selector = _ref5.selector,
                            namespace = _ref5.namespace;
                        _events_engine.default.off($el, addNamespace("dxhoverstart", namespace), selector);
                        _events_engine.default.off($el, addNamespace("dxhoverend", namespace), selector)
                    }
                };
                exports.hover = hover;
                var visibility = {
                    on: function($el, shown, hiding, _ref6) {
                        var namespace = _ref6.namespace;
                        _events_engine.default.on($el, addNamespace("dxhiding", namespace), hiding);
                        _events_engine.default.on($el, addNamespace("dxshown", namespace), shown)
                    },
                    off: function($el, _ref7) {
                        var namespace = _ref7.namespace;
                        _events_engine.default.off($el, addNamespace("dxhiding", namespace));
                        _events_engine.default.off($el, addNamespace("dxshown", namespace))
                    }
                };
                exports.visibility = visibility;
                var focus = {
                    on: function($el, focusIn, focusOut, _ref8) {
                        var namespace = _ref8.namespace;
                        _events_engine.default.on($el, addNamespace("focusin", namespace), focusIn);
                        _events_engine.default.on($el, addNamespace("focusout", namespace), focusOut)
                    },
                    off: function($el, _ref9) {
                        var namespace = _ref9.namespace;
                        _events_engine.default.off($el, addNamespace("focusin", namespace));
                        _events_engine.default.off($el, addNamespace("focusout", namespace))
                    },
                    trigger: function($el) {
                        return _events_engine.default.trigger($el, "focus")
                    }
                };
                exports.focus = focus;
                var dxClick = {
                    on: function($el, click) {
                        var _ref10 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                            namespace = _ref10.namespace;
                        _events_engine.default.on($el, addNamespace("dxclick", namespace), click)
                    },
                    off: function($el) {
                        var _ref11 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
                            namespace = _ref11.namespace;
                        _events_engine.default.off($el, addNamespace("dxclick", namespace))
                    }
                };
                exports.dxClick = dxClick;
                var click = {
                    on: function($el, click) {
                        var _ref12 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {},
                            namespace = _ref12.namespace;
                        _events_engine.default.on($el, addNamespace("click", namespace), click)
                    },
                    off: function($el) {
                        var _ref13 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
                            namespace = _ref13.namespace;
                        _events_engine.default.off($el, addNamespace("click", namespace))
                    }
                };
                exports.click = click;
                var index = 0;
                var keyboardProcessors = {};
                var keyboard = {
                    on: function(element, focusTarget, handler) {
                        var listenerId = "keyboardProcessorId".concat(index++);
                        keyboardProcessors[listenerId] = new _keyboard_processor.default({
                            element: element,
                            focusTarget: focusTarget,
                            handler: handler
                        });
                        return listenerId
                    },
                    off: function(listenerId) {
                        if (listenerId && keyboardProcessors[listenerId]) {
                            keyboardProcessors[listenerId].dispose();
                            delete keyboardProcessors[listenerId]
                        }
                    },
                    _getProcessor: function(listenerId) {
                        return keyboardProcessors[listenerId]
                    }
                };
                exports.keyboard = keyboard
            },
        34309:
            /*!*************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/events/swipe.js ***!
              \*************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.swipe = exports.start = exports.end = void 0;
                var _size = __webpack_require__( /*! ../core/utils/size */ 58664);
                var _index = __webpack_require__( /*! ./utils/index */ 39611);
                var _emitter = _interopRequireDefault(__webpack_require__( /*! ./gesture/emitter.gesture */ 98621));
                var _emitter_registrator = _interopRequireDefault(__webpack_require__( /*! ./core/emitter_registrator */ 82495));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                exports.start = "dxswipestart";
                exports.swipe = "dxswipe";
                exports.end = "dxswipeend";
                var HorizontalStrategy = {
                    defaultItemSizeFunc: function() {
                        return (0, _size.getWidth)(this.getElement())
                    },
                    getBounds: function() {
                        return [this._maxLeftOffset, this._maxRightOffset]
                    },
                    calcOffsetRatio: function(e) {
                        var endEventData = (0, _index.eventData)(e);
                        return (endEventData.x - (this._savedEventData && this._savedEventData.x || 0)) / this._itemSizeFunc().call(this, e)
                    },
                    isFastSwipe: function(e) {
                        var endEventData = (0, _index.eventData)(e);
                        return this.FAST_SWIPE_SPEED_LIMIT * Math.abs(endEventData.x - this._tickData.x) >= endEventData.time - this._tickData.time
                    }
                };
                var VerticalStrategy = {
                    defaultItemSizeFunc: function() {
                        return (0, _size.getHeight)(this.getElement())
                    },
                    getBounds: function() {
                        return [this._maxTopOffset, this._maxBottomOffset]
                    },
                    calcOffsetRatio: function(e) {
                        var endEventData = (0, _index.eventData)(e);
                        return (endEventData.y - (this._savedEventData && this._savedEventData.y || 0)) / this._itemSizeFunc().call(this, e)
                    },
                    isFastSwipe: function(e) {
                        var endEventData = (0, _index.eventData)(e);
                        return this.FAST_SWIPE_SPEED_LIMIT * Math.abs(endEventData.y - this._tickData.y) >= endEventData.time - this._tickData.time
                    }
                };
                var STRATEGIES = {
                    horizontal: HorizontalStrategy,
                    vertical: VerticalStrategy
                };
                var SwipeEmitter = _emitter.default.inherit({
                    TICK_INTERVAL: 300,
                    FAST_SWIPE_SPEED_LIMIT: 10,
                    ctor: function(element) {
                        this.callBase(element);
                        this.direction = "horizontal";
                        this.elastic = true
                    },
                    _getStrategy: function() {
                        return STRATEGIES[this.direction]
                    },
                    _defaultItemSizeFunc: function() {
                        return this._getStrategy().defaultItemSizeFunc.call(this)
                    },
                    _itemSizeFunc: function() {
                        return this.itemSizeFunc || this._defaultItemSizeFunc
                    },
                    _init: function(e) {
                        this._tickData = (0, _index.eventData)(e)
                    },
                    _start: function(e) {
                        this._savedEventData = (0, _index.eventData)(e);
                        e = this._fireEvent("dxswipestart", e);
                        if (!e.ca