import React from 'react'
import ReactDOM from 'react-dom/client'

import { Provider } from 'react-redux';
import { RouterProvider } from 'react-router-dom'

import { router } from './router.tsx'
import { store } from './store.ts';

import './index.css'
import './colors.css';

ReactDOM.createRoot(document.getElementById('root')!).render(
  <React.StrictMode>
    <Provider store={store}>
      <RouterProvider router={router} />
    </Provider>
  </React.StrictMode>,
)
