import * as React from 'react';

import './Icons.css';

export type IconProps = {
    isActive: boolean,
};

const LIGHT_COLOR = "#FFFFFF";
const DARK_COLOR = "#353535";

export function Dashboard({ isActive }: IconProps) {
    const color = isActive ? LIGHT_COLOR: DARK_COLOR;

    return (
        <svg width="90%" height="90%" viewBox="0 0 75 75" stroke={color} fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M18.75 38.0859H18.1641" strokeWidth="4" strokeMiterlimit="10" strokeLinecap="round" strokeLinejoin="round"/>
            <path d="M58.0078 38.0859H57.4219" strokeWidth="4" strokeMiterlimit="10" strokeLinecap="round" strokeLinejoin="round"/>
            <path d="M21.3405 28.418L20.8331 28.125" strokeWidth="4" strokeMiterlimit="10" strokeLinecap="round" strokeLinejoin="round"/>
            <path d="M28.418 21.3406L28.125 20.8331" strokeWidth="4" strokeMiterlimit="10" strokeLinecap="round" strokeLinejoin="round"/>
            <path d="M54.8314 28.418L55.3388 28.125" strokeWidth="4" strokeMiterlimit="10" strokeLinecap="round" strokeLinejoin="round"/>
            <path d="M47.7539 21.3406L48.0469 20.8331" strokeWidth="4" strokeMiterlimit="10" strokeLinecap="round" strokeLinejoin="round"/>
            <path d="M38.0859 18.75V18.1641" strokeWidth="4" strokeMiterlimit="10" strokeLinecap="round" strokeLinejoin="round"/>
            <path d="M42.7734 26.3994L39.014 40.4296" strokeWidth="4" strokeMiterlimit="10" strokeLinecap="round" strokeLinejoin="round"/>
            <path d="M38.0859 63.8672C52.3245 63.8672 63.8672 52.3245 63.8672 38.0859C63.8672 23.8473 52.3245 12.3047 38.0859 12.3047C23.8473 12.3047 12.3047 23.8473 12.3047 38.0859C12.3047 52.3245 23.8473 63.8672 38.0859 63.8672Z" strokeWidth="4" strokeMiterlimit="10" strokeLinecap="round" strokeLinejoin="round"/>
            <path d="M48.6328 45.1172H62.1094" strokeWidth="4" strokeMiterlimit="10" strokeLinecap="round" strokeLinejoin="round"/>
            <path d="M13.4766 45.1172H27.5391" strokeWidth="4" strokeMiterlimit="10" strokeLinecap="round" strokeLinejoin="round"/>
            <path d="M38.0859 49.8047C40.6748 49.8047 42.7734 47.706 42.7734 45.1172C42.7734 42.5284 40.6748 40.4297 38.0859 40.4297C35.4971 40.4297 33.3984 42.5284 33.3984 45.1172C33.3984 47.706 35.4971 49.8047 38.0859 49.8047Z" strokeWidth="4" strokeMiterlimit="10" strokeLinecap="round" strokeLinejoin="round"/>
        </svg>
    );
}

export function SocialAccounts({ isActive }: IconProps) {
    const color = isActive ? LIGHT_COLOR: DARK_COLOR;

    return (
        <svg width="75%" height="75%" viewBox="0 0 50 50" fill="none" xmlns="http://www.w3.org/2000/svg">
            <g clipPath="url(#clip0_1_246)">
                <path fill={color} d="M27.0833 42.2917V29.1667H22.9167V42.2917C21.6667 42.9167 20.8333 44.375 20.8333 45.8333C20.8333 48.125 22.7083 50 25 50C27.2917 50 29.1667 48.125 29.1667 45.8333C29.1667 44.375 28.3333 42.9167 27.0833 42.2917ZM45.8333 35.4167C44.375 35.4167 42.9167 36.25 42.2917 37.5H35.4167V33.3333H37.0833C42.7083 33.3333 47.7083 29.1667 47.9167 23.5417C48.125 18.125 44.375 13.75 39.375 12.7083C38.5417 5.625 32.5 0 25 0C24.5833 0 24.1667 0 23.75 0C16.25 0.625 10.4167 7.5 10.4167 15.2083C10.4167 15.8333 9.79167 16.6667 8.95833 16.875C4.79167 17.5 1.66667 21.4583 2.08333 25.8333C2.5 30.2083 6.45833 33.3333 10.8333 33.3333H14.5833V37.5H7.70833C7.08333 36.25 5.625 35.4167 4.16667 35.4167C1.875 35.4167 0 37.2917 0 39.5833C0 41.875 1.875 43.75 4.16667 43.75C5.625 43.75 7.08333 42.9167 7.70833 41.6667H18.75V29.1667H10.8333C8.54167 29.1667 6.45833 27.5 6.25 25.4167C6.04167 23.3333 7.5 21.25 9.79167 20.8333C12.5 20.4167 14.5833 17.9167 14.5833 15.2083C14.5833 9.58333 18.75 4.79167 24.1667 4.375C24.375 4.375 24.7917 4.375 25 4.375C30.2083 4.375 34.5833 8.33333 35.4167 13.5417L35.8333 16.4583L38.75 17.0833C41.875 17.7083 43.9583 20.4167 43.75 23.5417C43.5417 26.875 40.625 29.375 37.0833 29.375H31.25V41.875H42.2917C42.9167 43.125 44.375 43.9583 45.8333 43.9583C48.125 43.9583 50 42.0833 50 39.7917C50 37.2917 48.125 35.4167 45.8333 35.4167Z"/>
            </g>
            <defs>
                <clipPath id="clip0_1_246">
                    <rect width="50" height="50"/>
                </clipPath>
            </defs>
        </svg>

    );
}

export function PageContents({ isActive }: IconProps) {
    const color = isActive ? LIGHT_COLOR: DARK_COLOR;

    return (
        <svg width="75%" height="75%" viewBox="0 0 60 60" fill={color} xmlns="http://www.w3.org/2000/svg">
            <path d="M9.32996 16.74C9.88224 16.74 10.33 16.2923 10.33 15.74C10.33 15.1877 9.88224 14.74 9.32996 14.74C8.77767 14.74 8.32996 15.1877 8.32996 15.74C8.32996 16.2923 8.77767 16.74 9.32996 16.74Z"/>
            <path d="M16 16.74C16.5523 16.74 17 16.2923 17 15.74C17 15.1877 16.5523 14.74 16 14.74C15.4477 14.74 15 15.1877 15 15.74C15 16.2923 15.4477 16.74 16 16.74Z"/>
            <path d="M12.67 16.74C13.2223 16.74 13.67 16.2923 13.67 15.74C13.67 15.1877 13.2223 14.74 12.67 14.74C12.1178 14.74 11.67 15.1877 11.67 15.74C11.67 16.2923 12.1178 16.74 12.67 16.74Z"/>
            <path d="M20 30.25L23 27.25C23.1883 27.0617 23.2941 26.8063 23.2941 26.54C23.2941 26.2737 23.1883 26.0183 23 25.83C22.8117 25.6417 22.5563 25.5359 22.29 25.5359C22.0237 25.5359 21.7683 25.6417 21.58 25.83L17.86 29.56C17.6738 29.7473 17.5692 30.0008 17.5692 30.265C17.5692 30.5292 17.6738 30.7826 17.86 30.97L21.58 34.7C21.673 34.7937 21.7836 34.8681 21.9054 34.9189C22.0273 34.9696 22.158 34.9958 22.29 34.9958C22.422 34.9958 22.5527 34.9696 22.6746 34.9189C22.7964 34.8681 22.907 34.7937 23 34.7C23.1863 34.5126 23.2908 34.2592 23.2908 33.995C23.2908 33.7308 23.1863 33.4773 23 33.29L20 30.25Z"/>
            <path d="M34.32 34.68C34.5073 34.8663 34.7608 34.9708 35.025 34.9708C35.2892 34.9708 35.5426 34.8663 35.73 34.68L39.46 31C39.6462 30.8127 39.7508 30.5592 39.7508 30.295C39.7508 30.0308 39.6462 29.7774 39.46 29.59L35.73 25.86C35.5417 25.673 35.2868 25.5685 35.0214 25.5695C34.7561 25.5704 34.502 25.6767 34.315 25.865C34.128 26.0533 34.0235 26.3082 34.0244 26.5736C34.0254 26.8389 34.1317 27.093 34.32 27.28L37.32 30.28L34.32 33.28C34.1367 33.4669 34.0341 33.7183 34.0341 33.98C34.0341 34.2418 34.1367 34.4931 34.32 34.68Z"/>
            <path d="M31 26.15C30.8859 26.0838 30.7598 26.041 30.629 26.0238C30.4982 26.0066 30.3654 26.0155 30.238 26.0498C30.1107 26.0842 29.9914 26.1435 29.887 26.2242C29.7827 26.3049 29.6953 26.4054 29.63 26.52L25.94 33C25.8677 33.1138 25.8191 33.2411 25.7972 33.3741C25.7753 33.5072 25.7806 33.6434 25.8126 33.7744C25.8447 33.9054 25.903 34.0285 25.9839 34.1364C26.0648 34.2443 26.1667 34.3347 26.2835 34.4022C26.4003 34.4697 26.5295 34.5129 26.6634 34.5291C26.7972 34.5454 26.933 34.5344 27.0626 34.4968C27.1921 34.4593 27.3127 34.3959 27.4171 34.3105C27.5215 34.2251 27.6075 34.1195 27.67 34L31.4 27.55C31.4698 27.4328 31.5149 27.3026 31.5325 27.1674C31.5501 27.0321 31.5398 26.8947 31.5024 26.7636C31.4649 26.6325 31.401 26.5104 31.3146 26.4049C31.2282 26.2993 31.1212 26.2126 31 26.15Z"/>
            <path d="M55.86 40C55.801 39.9995 55.7436 39.9811 55.6953 39.9472C55.6471 39.9132 55.6103 39.8654 55.59 39.81C55.1921 38.7633 54.6282 37.7874 53.92 36.92C53.8865 36.8715 53.8685 36.814 53.8685 36.755C53.8685 36.696 53.8865 36.6385 53.92 36.59C54.2246 36.0621 54.3072 35.4349 54.1497 34.8462C53.9922 34.2575 53.6075 33.7553 53.08 33.45L52.33 33V14.74C52.33 13.9443 52.0139 13.1813 51.4513 12.6187C50.8887 12.0561 50.1257 11.74 49.33 11.74H8C7.20435 11.74 6.44129 12.0561 5.87868 12.6187C5.31607 13.1813 5 13.9443 5 14.74V40.08C5.00263 40.6971 5.24896 41.2883 5.68535 41.7246C6.12174 42.161 6.71286 42.4074 7.33 42.41H21L20 46.11H18.67C17.696 46.1107 16.7507 46.4397 15.9867 47.0439C15.2228 47.6482 14.6849 48.4923 14.46 49.44H12C11.7348 49.44 11.4804 49.5454 11.2929 49.7329C11.1054 49.9204 11 50.1748 11 50.44C11 50.7052 11.1054 50.9596 11.2929 51.1471C11.4804 51.3346 11.7348 51.44 12 51.44H37.47C37.4531 51.6789 37.4767 51.919 37.54 52.15C37.615 52.4433 37.7484 52.7185 37.9323 52.9591C38.1161 53.1997 38.3466 53.4006 38.61 53.55L40.72 54.77C40.982 54.9204 41.271 55.0177 41.5706 55.0564C41.8702 55.0951 42.1745 55.0743 42.4661 54.9954C42.7576 54.9165 43.0308 54.7809 43.27 54.5963C43.5092 54.4118 43.7097 54.182 43.86 53.92C43.8924 53.869 43.939 53.8286 43.9941 53.8037C44.0492 53.7788 44.1103 53.7706 44.17 53.78C45.2685 53.97 46.3915 53.97 47.49 53.78C47.5508 53.7701 47.6132 53.7792 47.6687 53.8061C47.7241 53.8329 47.77 53.8762 47.8 53.93C48.0038 54.279 48.296 54.5681 48.6471 54.7682C48.9982 54.9684 49.3959 55.0724 49.8 55.07C50.2032 55.0739 50.6001 54.9703 50.95 54.77L53.06 53.55C53.322 53.3989 53.5514 53.1973 53.735 52.957C53.9187 52.7167 54.0529 52.4425 54.13 52.15C54.2096 51.8593 54.2303 51.5556 54.1908 51.2568C54.1513 50.9579 54.0524 50.67 53.9 50.41C53.8656 50.36 53.8472 50.3007 53.8472 50.24C53.8472 50.1793 53.8656 50.12 53.9 50.07C54.606 49.2047 55.1697 48.2325 55.57 47.19C55.5891 47.1338 55.6255 47.0851 55.674 47.051C55.7225 47.0168 55.7807 46.999 55.84 47C56.4492 46.9974 57.0327 46.7542 57.4634 46.3234C57.8942 45.8927 58.1374 45.3092 58.14 44.7V42.26C58.1296 41.6604 57.8854 41.0886 57.4595 40.6664C57.0336 40.2442 56.4597 40.0051 55.86 40ZM7 14.74C7 14.4748 7.10536 14.2204 7.29289 14.0329C7.48043 13.8453 7.73478 13.74 8 13.74H49.33C49.5952 13.74 49.8496 13.8453 50.0371 14.0329C50.2246 14.2204 50.33 14.4748 50.33 14.74V17.74H7V14.74ZM7.33 40.41C7.28666 40.41 7.24375 40.4015 7.20371 40.3849C7.16368 40.3683 7.1273 40.344 7.09665 40.3133C7.06601 40.2827 7.0417 40.2463 7.02512 40.2063C7.00854 40.1662 7 40.1233 7 40.08V19.74H50.33V32C49.8568 31.8743 49.3558 31.9036 48.9004 32.0836C48.4451 32.2636 48.0594 32.5847 47.8 33C47.7689 33.0493 47.7236 33.0881 47.6701 33.1113C47.6165 33.1345 47.5573 33.141 47.5 33.13C46.4007 32.9499 45.2793 32.9499 44.18 33.13C44.1227 33.1425 44.0629 33.1367 44.0091 33.1133C43.9552 33.09 43.9101 33.0504 43.88 33C43.7298 32.7378 43.5292 32.508 43.2897 32.3237C43.0503 32.1395 42.7768 32.0044 42.4849 31.9263C42.193 31.8482 41.8886 31.8287 41.5891 31.8688C41.2896 31.9089 41.001 32.0079 40.74 32.16L38.63 33.38C38.3673 33.5278 38.1371 33.7271 37.9533 33.9659C37.7694 34.2047 37.6357 34.4782 37.56 34.77C37.4001 35.3595 37.4791 35.9884 37.78 36.52C37.8165 36.5673 37.8363 36.6253 37.8363 36.685C37.8363 36.7447 37.8165 36.8027 37.78 36.85C37.0718 37.7174 36.5079 38.6933 36.11 39.74C36.0897 39.7954 36.0529 39.8432 36.0047 39.8772C35.9564 39.9111 35.899 39.9295 35.84 39.93C35.3502 39.9307 34.8735 40.0884 34.48 40.38L7.33 40.41ZM34 46.11H22L23 42.41H33.5V44.7C33.5064 45.2123 33.6822 45.7081 34 46.11ZM18.68 48.11H36.48C36.7086 48.571 36.9692 49.0154 37.26 49.44H16.57C16.7588 49.0427 17.0562 48.7069 17.4278 48.4716C17.7995 48.2362 18.2301 48.1108 18.67 48.11H18.68ZM56.16 44.7C56.16 44.7796 56.1284 44.8559 56.0721 44.9121C56.0159 44.9684 55.9396 45 55.86 45C55.3942 45.0012 54.9396 45.1431 54.5559 45.4072C54.1722 45.6713 53.8774 46.0453 53.71 46.48C53.3904 47.3231 52.938 48.1097 52.37 48.81C52.0771 49.1718 51.9004 49.6136 51.8629 50.0775C51.8254 50.5415 51.929 51.0059 52.16 51.41C52.1761 51.4444 52.1844 51.482 52.1844 51.52C52.1844 51.558 52.1761 51.5956 52.16 51.63C52.1513 51.6697 52.1343 51.7071 52.1102 51.7399C52.0861 51.7726 52.0554 51.7999 52.02 51.82L49.94 53C49.9053 53.0193 49.867 53.0315 49.8275 53.036C49.788 53.0404 49.7481 53.0369 49.7099 53.0257C49.6718 53.0146 49.6362 52.9959 49.6053 52.9709C49.5744 52.9459 49.5488 52.915 49.53 52.88C49.2936 52.477 48.9405 52.1552 48.5174 51.957C48.0942 51.7588 47.621 51.6936 47.16 51.77C46.2797 51.92 45.3803 51.92 44.5 51.77C44.038 51.6946 43.564 51.7613 43.1408 51.9613C42.7175 52.1613 42.365 52.4852 42.13 52.89C42.0885 52.957 42.023 53.0057 41.9468 53.0262C41.8706 53.0466 41.7895 53.0373 41.72 53L39.61 51.78C39.5746 51.7599 39.5439 51.7326 39.5198 51.6999C39.4957 51.6671 39.4787 51.6297 39.47 51.59C39.4539 51.5556 39.4456 51.518 39.4456 51.48C39.4456 51.442 39.4539 51.4044 39.47 51.37C39.6983 50.9651 39.8004 50.5012 39.7629 50.0379C39.7255 49.5745 39.5504 49.133 39.26 48.77C38.6869 48.0715 38.231 47.2846 37.91 46.44C37.7423 46.0167 37.4517 45.6534 37.0756 45.3967C36.6996 45.1401 36.2553 45.0019 35.8 45C35.7204 45 35.6441 44.9684 35.5879 44.9121C35.5316 44.8559 35.5 44.7796 35.5 44.7V42.26C35.4986 42.2202 35.5054 42.1806 35.52 42.1436C35.5346 42.1065 35.5566 42.0729 35.5848 42.0448C35.6129 42.0166 35.6465 41.9946 35.6836 41.98C35.7206 41.9654 35.7602 41.9586 35.8 41.96C36.2644 41.9582 36.7174 41.8159 37.0994 41.5517C37.4814 41.2875 37.7744 40.9139 37.94 40.48C38.2587 39.6343 38.7148 38.8471 39.29 38.15C39.5804 37.787 39.7555 37.3455 39.7929 36.8821C39.8304 36.4188 39.7283 35.9549 39.5 35.55C39.4837 35.5138 39.4753 35.4746 39.4753 35.435C39.4753 35.3953 39.4837 35.3561 39.5 35.32C39.5081 35.2813 39.525 35.245 39.5492 35.2138C39.5735 35.1826 39.6045 35.1574 39.64 35.14L41.75 33.92C41.7991 33.9063 41.8509 33.9063 41.9 33.92C41.95 33.9206 41.9991 33.9338 42.0428 33.9582C42.0865 33.9827 42.1233 34.0177 42.15 34.06C42.3861 34.4639 42.7387 34.7869 43.1617 34.9868C43.5846 35.1867 44.0581 35.254 44.52 35.18C45.4003 35.03 46.2997 35.03 47.18 35.18C47.645 35.2428 48.1181 35.1637 48.5374 34.9532C48.9567 34.7427 49.3026 34.4104 49.53 34C49.5495 33.967 49.5755 33.9382 49.6062 33.9153C49.6369 33.8924 49.6719 33.8758 49.7091 33.8665C49.7463 33.8572 49.785 33.8554 49.8229 33.8611C49.8608 33.8669 49.8972 33.8801 49.93 33.9L52.04 35.12C52.0755 35.1374 52.1065 35.1626 52.1308 35.1938C52.155 35.225 52.1719 35.2613 52.18 35.3C52.1963 35.3361 52.2047 35.3753 52.2047 35.415C52.2047 35.4546 52.1963 35.4938 52.18 35.53C51.9498 35.9326 51.8467 36.3953 51.8842 36.8575C51.9217 37.3197 52.098 37.7598 52.39 38.12C52.9582 38.8238 53.4105 39.6137 53.73 40.46C53.8876 40.902 54.1756 41.2858 54.5559 41.5607C54.9362 41.8357 55.3909 41.9888 55.86 42C55.8998 41.9986 55.9394 42.0054 55.9764 42.02C56.0135 42.0346 56.0471 42.0566 56.0752 42.0848C56.1034 42.1129 56.1254 42.1465 56.14 42.1836C56.1546 42.2206 56.1614 42.2602 56.16 42.3V44.7Z"/>
            <path d="M45.83 38.9399C44.9321 38.9399 44.0544 39.2062 43.3078 39.7051C42.5612 40.2039 41.9792 40.913 41.6356 41.7426C41.292 42.5721 41.2021 43.485 41.3773 44.3657C41.5525 45.2463 41.9848 46.0553 42.6198 46.6902C43.2547 47.3251 44.0637 47.7575 44.9443 47.9327C45.825 48.1079 46.7378 48.018 47.5674 47.6744C48.397 47.3307 49.1061 46.7488 49.6049 46.0022C50.1038 45.2556 50.37 44.3779 50.37 43.4799C50.37 42.2759 49.8917 41.1211 49.0403 40.2697C48.1889 39.4183 47.0341 38.9399 45.83 38.9399ZM45.83 46.0199C45.3277 46.0199 44.8366 45.871 44.4189 45.5919C44.0012 45.3128 43.6756 44.9161 43.4834 44.452C43.2911 43.9878 43.2408 43.4771 43.3388 42.9844C43.4369 42.4917 43.6788 42.0391 44.034 41.6839C44.3892 41.3287 44.8418 41.0868 45.3345 40.9887C45.8272 40.8907 46.3379 40.941 46.8021 41.1333C47.2662 41.3255 47.6629 41.6511 47.942 42.0688C48.2211 42.4865 48.37 42.9776 48.37 43.4799C48.3648 44.1501 48.0948 44.7911 47.6191 45.2631C47.1433 45.7351 46.5002 46 45.83 45.9999V46.0199Z"/>
        </svg>

    );
}

export function Logout({ isActive }: IconProps) {
    const color = isActive ? LIGHT_COLOR: DARK_COLOR;

    return (
        <svg width="75%" height="75%" viewBox="0 0 42 42" fill={color} xmlns="http://www.w3.org/2000/svg">
            <path d="M20.9999 16.8333C23.2916 16.8333 25.1666 14.9583 25.1666 12.6666V4.33329C25.1666 2.04163 23.2916 0.166626 20.9999 0.166626C18.7083 0.166626 16.8333 2.04163 16.8333 4.33329V12.6666C16.8333 14.9583 18.7083 16.8333 20.9999 16.8333Z"/>
            <path d="M35.7916 6.20833C35.1666 5.58333 34.5416 5.375 33.5 5.375C31.8333 5.375 30.375 6.83333 30.375 8.5C30.375 9.33333 30.7916 10.1667 31.2083 10.7917C33.9166 13.5 35.375 17.0417 35.375 21C35.375 29.125 28.9166 35.5833 20.7916 35.5833C12.6666 35.5833 6.20829 29.125 6.20829 21C6.20829 17.0417 7.87496 13.2917 10.5833 10.7917C11.2083 10.1667 11.625 9.33333 11.625 8.5C11.625 6.83333 10.1666 5.375 8.49996 5.375C7.66663 5.375 6.83329 5.79167 6.20829 6.20833C2.45829 9.95833 0.166626 15.1667 0.166626 21C0.166626 32.4583 9.54163 41.8333 21 41.8333C32.4583 41.8333 41.8333 32.4583 41.8333 21C41.8333 15.1667 39.5416 9.95833 35.7916 6.20833Z"/>
        </svg>
    );
}

export function Twitter() {
    return (
        <svg width="30" height="30" viewBox="0 0 38 31" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M37.75 3.94688C36.3719 4.55729 34.8896 4.96458 33.326 5.15729C34.9156 4.21354 36.1386 2.70833 36.7125 0.930208C35.225 1.80208 33.5771 2.44271 31.824 2.78021C30.424 1.29583 28.4271 0.375 26.2146 0.375C21.9646 0.375 18.5198 3.78958 18.5198 8C18.5198 8.59583 18.5896 9.17604 18.7208 9.73958C12.3271 9.41875 6.65626 6.37917 2.86251 1.76667C2.19585 2.89375 1.82085 4.21354 1.82085 5.60625C1.82085 8.25313 3.17605 10.5833 5.24272 11.9563C3.98126 11.9177 2.79376 11.5667 1.75418 11.0042C1.75418 11.0271 1.75418 11.0615 1.75418 11.0938C1.75418 14.7927 4.4073 17.8729 7.92397 18.574C7.28126 18.75 6.60209 18.8479 5.90209 18.8479C5.40522 18.8479 4.92085 18.7917 4.4521 18.7073C5.43126 21.7302 8.27189 23.9396 11.6375 24.0052C9.00418 26.0469 5.68751 27.2698 2.08126 27.2698C1.45835 27.2698 0.848971 27.2344 0.246887 27.1615C3.65418 29.3188 7.70001 30.5833 12.0427 30.5833C26.1938 30.5833 33.9354 18.9625 33.9354 8.88125C33.9354 8.55104 33.925 8.22188 33.9094 7.89688C35.4198 6.83021 36.7219 5.48438 37.75 3.94688Z" fill="#03A9F4"/>
        </svg>
    );
}

export function Stackoverflow() {
    return (
        <svg width="30" height="30" viewBox="0 0 105 124" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fillRule="evenodd" clipRule="evenodd" d="M88 79.8081H99V123.808H0V79.8081H11V112.808H88V79.8081Z" fill="#BBBBBB"/>
            <path d="M22.9879 76.538L77.0129 87.893L79.2839 77.093L25.2589 65.733L22.9879 76.538ZM30.1369 50.669L80.1829 73.977L84.8449 63.968L34.7979 40.66L30.1369 50.669ZM43.9849 26.116L86.4129 61.447L93.4789 52.962L51.0509 17.632L43.9849 26.116ZM71.3719 0L62.5119 6.59L95.4599 50.89L104.32 44.301L71.3719 0ZM22 101.808H77V90.808H22V101.808Z" fill="#F58025"/>
        </svg>
    );
}

export function Github() {
    return (
        <svg width="30" height="30" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M20 0C8.955 0 0 8.955 0 20C0 29.3717 6.45333 37.2133 15.1533 39.3833C15.06 39.1133 15 38.8 15 38.4117V34.9933C14.1883 34.9933 12.8283 34.9933 12.4867 34.9933C11.1183 34.9933 9.90167 34.405 9.31167 33.3117C8.65667 32.0967 8.54333 30.2383 6.92 29.1017C6.43833 28.7233 6.805 28.2917 7.36 28.35C8.385 28.64 9.235 29.3433 10.035 30.3867C10.8317 31.4317 11.2067 31.6683 12.695 31.6683C13.4167 31.6683 14.4967 31.6267 15.5133 31.4667C16.06 30.0783 17.005 28.8 18.16 28.1967C11.5 27.5117 8.32167 24.1983 8.32167 19.7C8.32167 17.7633 9.14667 15.89 10.5483 14.3117C10.0883 12.745 9.51 9.55 10.725 8.33333C13.7217 8.33333 15.5333 10.2767 15.9683 10.8017C17.4617 10.29 19.1017 10 20.825 10C22.5517 10 24.1983 10.29 25.695 10.805C26.125 10.2833 27.9383 8.33333 30.9417 8.33333C32.1617 9.55167 31.5767 12.76 31.1117 14.3233C32.505 15.8983 33.325 17.7667 33.325 19.7C33.325 24.195 30.1517 27.5067 23.5017 28.195C25.3317 29.15 26.6667 31.8333 26.6667 33.855V38.4117C26.6667 38.585 26.6283 38.71 26.6083 38.8583C34.4017 36.1267 40 28.7267 40 20C40 8.955 31.045 0 20 0Z" fill="#E5E5E5"/>
        </svg>
    );
}

export function Pencil() {
    return (
        <svg width="20" height="20" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
            <g clipPath="url(#clip0_1_413)">
                <path d="M29.656 2.344C26.535 -0.780998 21.465 -0.780998 18.344 2.344L0.031 20.656L0 32H11.312L29.656 13.656C32.781 10.531 32.781 5.469 29.656 2.344ZM9.613 28H3.957V22.312C5.519 20.75 8.051 20.75 9.613 22.312C11.175 23.874 11.176 26.438 9.613 28ZM26.754 10.828L21.098 5.172C22.66 3.61 25.192 3.61 26.754 5.172C28.316 6.734 28.316 9.266 26.754 10.828Z" fill="#2C2C2C"/>
            </g>
            <defs>
                <clipPath id="clip0_1_413">
                    <rect width="32" height="32" fill="white"/>
                </clipPath>
            </defs>
        </svg>
    );
}

export function ReactIcon() {
    return <img src='src/assets/images/tech-icons/react.png' />;
}

export function TypeScriptIcon() {
    return <img src='src/assets/images/tech-icons/typescript.png' />;
}